//
// Copyright (c) 2022 Oleg Lelenkov <o.lelenkov@gmail.com>
// Distributed under terms of the BSD 3-Clause license.
//

#[macro_export]
macro_rules! unode {
    () => (
        $crate::UniNode::Null
    );
    ($value:expr) => (
        $crate::UniNode::from($value)
    );
    ($($values:expr),+ $(,)?) => ({
        let data = vec![$(unode!($values),)+];
        $crate::UniNode::Array(data)
    });
    ($($key:expr => $value:expr,)+) => (
        unode!($($key => $value),+)
    );
    ($($key:expr => $value:expr),*) => ({
        let mut data = ::std::collections::HashMap::new();
        $(
            let _ = data.insert(String::from($key), unode!($value));
        )*
        $crate::UniNode::Object(data)
    });
}
