//
// Copyright (c) 2022 Oleg Lelenkov <o.lelenkov@gmail.com>
// Distributed under terms of the BSD 3-Clause license.
//

use std::path::Path;
use std::io;

pub trait FileAccesor {
    fn read(&self, path: &Path) -> io::Result<String>;

    fn exists(&self, path: &Path) -> bool;
}

#[async_trait::async_trait]
pub trait AsyncFileAccesor {
    async fn read(&self, path: &Path) -> io::Result<String>;

    async fn exists(&self, path: &Path) -> bool;
}

pub struct StdFileAccessor;

impl FileAccesor for StdFileAccessor {
    fn read(&self, path: &Path) -> io::Result<String> {
        std::fs::read_to_string(path)
    }

    fn exists(&self, path: &Path) -> bool {
        path.is_file()
    }
}
