// macros.rs
// Copyright: (c) 2015-2021, Oleg Lelenkov
// Distributed under terms of the BSD 3-Clause license.
//

#[macro_export]
macro_rules! unode {
    () => (
        $crate::UniNode::Null
    );
    ($value:expr) => (
        $crate::UniNode::from($value)
    );
    ($($values:expr),+ $(,)?) => ({
        let data = vec![$(unode!($values),)+];
        $crate::UniNode::Array(data)
    });
    ($($key:expr => $value:expr,)+) => (
        unode!($($key => $value),+)
    );
    ($($key:expr => $value:expr),*) => ({
        let mut data = ::std::collections::HashMap::new();
        $(
            let _ = data.insert(String::from($key), unode!($value));
        )*
        $crate::UniNode::Object(data)
    });
}

macro_rules! impl_is_function {
    ($name:ident, $member:ident) => {
        pub fn $name(&self) -> bool {
            match self {
                $crate::UniNode::$member(_) => true,
                _ => false,
            }
        }
    };
}

macro_rules! impl_get_function {
    ($name:ident, $conv:ident, $type:ty) => {
        pub fn $name(&self, path: &str) -> Option<$type> {
            self.find(path).and_then(|v| v.$conv().ok())
        }
    };
}
