// lib.rs
// Copyright: (c) 2015-2021, Oleg Lelenkov
// Distributed under terms of the BSD 3-Clause license.
//

#[cfg(feature = "loaders")]
mod loaders;
#[cfg(feature = "serialize")]
mod serialize;
mod value;

pub use value::{UniNode, UniNodeError};

#[cfg(feature = "serialize")]
pub use serialize::serialize;

#[cfg(feature = "loaders")]
pub use loaders::{
    UniLoader, FileReader, UniNodeLoadError, register_loader,
    is_available_loader, set_default_reader, from_file, from_string,
    from_file_base,
};
