use serde::Deserialize;

use crate::{unified::Response, Unified, UnifiedError};

#[derive(Debug, Deserialize)]
pub struct Site {
    #[serde(rename = "_id")]
    pub id: String,
    pub name: String,
    #[serde(rename = "desc")]
    pub description: String,
}

impl Unified {
    pub async fn sites(&self) -> Result<Vec<Site>, UnifiedError> {
        let response = self
            .request("/api/self/sites")
            .send()
            .await?
            .json::<Response<Vec<Site>>>()
            .await?;

        Ok(response.data)
    }
}
