use std::{env, error::Error, string::ToString};

use unified::Unified;

#[tokio::main]
async fn main() -> Result<(), Box<dyn Error>> {
    let args: Vec<String> = env::args().collect();

    let unifi = Unified::from_credentials(
        args.get(1).unwrap(),
        args.get(2).unwrap(),
        args.get(3).unwrap(),
    )
    .await?;

    for item in unifi.networks("default").await? {
        println!(
            "{} ({})",
            item.name,
            item.subnet
                .map(|subnet| subnet.to_string())
                .unwrap_or_else(|| "-".to_string())
        );
    }

    Ok(())
}
