
use postgres::{NoTls};
// use crate::{DB_PROPERTIES};
use r2d2_postgres::PostgresConnectionManager;
use r2d2::{Pool, PooledConnection};
use parking_lot::{ RwLock};
use std::time::Duration;
use std::fs;
use std::collections::HashMap;

pub mod pg_dao;

#[macro_use]
extern crate lazy_static;
#[macro_use]
extern crate log;

lazy_static!{

    static ref PG_POOL: RwLock<Pool<PostgresConnectionManager<NoTls>>> = {
        RwLock::new(create_postgres_connection_manager())
    };
    static ref DB_PROPERTIES: HashMap<String, String> = {
        let filepath = "resources/application.properties";
        let contents = fs::read_to_string(filepath).expect("Something went wrong reading the file");
        let mut map = HashMap::new();

        for line in contents.lines() {
            if line.starts_with("//") || line.starts_with("#"){
                continue;
            }
            let tokens: Vec<&str> = line.split("=").collect();

            if tokens.len() >= 2 {
                map.insert(String::from(tokens[0]), String::from(tokens[1]));
            }

        }
        map
    };
}
pub fn connect_db() -> Result<PooledConnection<PostgresConnectionManager<NoTls>>, r2d2::Error>{

    let conn = PG_POOL.read();
    return match conn.get() {

        Ok(t) => Ok(t),
        Err(e) => {
            error!("==> {:?}", e);
            drop(conn);

            let mut conn = PG_POOL.write();
            *conn = create_postgres_connection_manager();
            conn.get()
        }
    };
}
pub fn create_postgres_connection_manager() -> Pool<PostgresConnectionManager<NoTls>> {

    let pool_size = match DB_PROPERTIES.get("db.pgsql.pool_size") {
        Some(t) =>   t.parse::<u32>().unwrap(),
        None => panic!("No such property: db.pgsql.pool_size")
    };
    let idle_timeout_sec = match DB_PROPERTIES.get("db.pgsql.idle_timeout_sec") {
        Some(t) =>   t.parse::<u64>().unwrap_or(15),
        None => 15,
    };

    let manager = PostgresConnectionManager::new( get_data_source().parse().unwrap(),NoTls,);
    let pool = r2d2::Pool::builder()
        .idle_timeout(Some(Duration::from_secs(idle_timeout_sec)))
        .max_size(pool_size)
        .build(manager).unwrap();
    pool
}

fn get_data_source() -> String{
    let data_source
        = format!("host={} port={} user={} password={} dbname={}",
                  match DB_PROPERTIES.get("db.pgsql.host") {
                      Some(v) => v,
                      _ => panic!("No such property: db.pgsql.host"),
                  },
                  match DB_PROPERTIES.get("db.pgsql.port") {
                      Some(v) => v,
                      _ => panic!("No such property: db.pgsql.port"),
                  },
                  match DB_PROPERTIES.get("db.pgsql.user") {
                      Some(v) => v,
                      _ => panic!("No such property: db.pgsql.user"),
                  },
                  match DB_PROPERTIES.get("db.pgsql.password") {
                      Some(v) => v,
                      _ => panic!("No such property: db.pgsql.password"),
                  },
                  match DB_PROPERTIES.get("db.pgsql.dbname") {
                      Some(v) => v,
                      _ => panic!("No such property: db.pgsql.dbname"),
                  }
    );
    data_source
}


#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
        assert_eq!(2 + 2, 4);
    }
}
