use std::{ io};
use std::fs;
use std::collections::HashMap;
use regex::Regex;
use std::path::Path;
use std::fs::File;
use std::io::BufRead;
use crate::model::{ColumnType, Value};

pub fn read_lines<P>(filename: P) -> io::Result<io::Lines<io::BufReader<File>>>
    where P: AsRef<Path>, {
    let file = File::open(filename)?;
    Ok(io::BufReader::new(file).lines())
}


pub fn read_sql(_filepath : &str, arg : &HashMap<String, Value>) -> String {

    let contents = fs::read_to_string(_filepath) .expect("Something went wrong reading the file");

    bind_variables(&contents.trim(), arg)
}
pub fn bind_variables(_sql : &str, arg : &HashMap<String, Value>)  -> String{

    let mut sql = String::from(_sql);

    for(key, value) in arg {


        // let re_key = Regex::new(format!("(?i):{}( |$|\t|\r|\n)", key).as_str()).unwrap();
        // let re_key2 = Regex::new(format!("(?i):{}\\)", key).as_str()).unwrap();
        // let re_key3 = Regex::new(format!("(?i):{},", key).as_str()).unwrap();

        if let Value::String(m) = &value {

            let n = m.replace("'", "''");
            sql = sql.replace(&format!("#{}#", key), &format!("'{}'", n));
            sql = sql.replace(&format!(":{}", key), &format!("'{}'", n));

            // sql = re_key.replace_all(&sql, format!("'{}'\n", m.replace("'","''")).as_str()).to_string();
            // sql = re_key2.replace_all(&sql, format!("'{}')", m.replace("'","''")).as_str()).to_string();
            // sql = re_key3.replace_all(&sql, format!("'{}',", m.replace("'","''")).as_str()).to_string();
        }
        if let Value::StringLikeLeft(m) = &value {

            let n = m.replace("'", "''");
            sql = sql.replace(&format!("#{}#", key), &format!("'%{}'", n));
            sql = sql.replace(&format!(":{}", key), &format!("'%{}'", n));

            // sql = re_key.replace_all(&sql, format!("'%{}'\n", m).as_str()).to_string();
        }
        if let Value::StringLikeRight(m) = &value {

            let n = m.replace("'", "''");
            sql = sql.replace(&format!("#{}#", key), &format!("'{}%'", n));
            sql = sql.replace(&format!(":{}", key), &format!("'{}%'", n));

            // sql = re_key.replace_all(&sql, format!("'{}%'\n", m).as_str()).to_string();
        }
        if let Value::StringLikeBoth(m) = &value {

            let n = m.replace("'", "''");
            sql = sql.replace(&format!("#{}#", key), &format!("'%{}%'", n));
            sql = sql.replace(&format!(":{}", key), &format!("'%{}%'", n));

            // sql = re_key.replace_all(&sql, format!("'%{}%'\n", m).as_str()).to_string();
        }
        if let Value::Float(m) = &value {
            sql = sql.replace(&format!("#{}#", key), &format!("{}", m));
            sql = sql.replace(&format!(":{}", key),&format!("{}", m));

            // sql = re_key.replace_all(&sql, format!("{}\n", m).as_str()).to_string();
            // sql = re_key2.replace_all(&sql, format!("{})", m).as_str()).to_string();
            // sql = re_key3.replace_all(&sql, format!("{},", m).as_str()).to_string();
        }
        if let Value::Integer(m) = &value {
            sql = sql.replace(&format!("#{}#", key), &format!("{}", m));
            sql = sql.replace(&format!(":{}", key), &format!("{}", m));

            // sql = re_key.replace_all(&sql, format!("{}\n", m).as_str()).to_string();
            // sql = re_key2.replace_all(&sql, format!("{})", m).as_str()).to_string();
            // sql = re_key3.replace_all(&sql, format!("{},", m).as_str()).to_string();
        }
        if let Value::Bool(m) = &value {
            sql = sql.replace(&format!("#{}#", key), &format!("{}", m));
            sql = sql.replace(&format!(":{}", key), &format!("{}", m));

            // sql = re_key.replace_all(&sql, format!("{}\n", m).as_str()).to_string();
            // sql = re_key2.replace_all(&sql, format!("{})", m).as_str()).to_string();
            // sql = re_key3.replace_all(&sql, format!("{},", m).as_str()).to_string();
        }
        if let Value::BareString(m) = &value {
            sql = sql.replace(&format!("#{}#", key), &format!("{}", m));
            sql = sql.replace(&format!(":{}", key), &format!("{}", m));

            // sql = re_key.replace_all(&sql, format!("{}\n", m).as_str()).to_string();
            // sql = re_key2.replace_all(&sql, format!("{})", m).as_str()).to_string();
            // sql = re_key3.replace_all(&sql, format!("{},", m).as_str()).to_string();
        }
        if let Value::StringArray(list) =&value{

            let mut m = String::new();

            for (i, item) in list.iter().enumerate() {
                if i > 0 {
                    m.push_str(", ");
                }

                let n = item.replace("'", "''");
                m.push_str(format!("'{}'", n).as_str());
            }
            sql = sql.replace(&format!("#{}#", key), &format!("{}", m));
            sql = sql.replace(&format!(":{}", key), &format!("{}", m));

            // sql = re_key.replace_all(&sql, format!("{} ", m).as_str()).to_string();
            // sql = re_key2.replace_all(&sql, format!("{})", m).as_str()).to_string();
            // sql = re_key3.replace_all(&sql, format!("{},", m).as_str()).to_string();
        }
        if let Value::IntegerArray(list) =&value{

            let mut m = String::new();

            for (i, item) in list.iter().enumerate() {
                if i > 0 {
                    m.push_str(", ");
                }
                m.push_str(format!("{}", item).as_str());
            }
            sql = sql.replace(&format!("#{}#", key), &format!("{}", m));
            sql = sql.replace(&format!(":{}", key), &format!("{}", m));

            // sql = re_key.replace_all(&sql, format!("{}\n", m).as_str()).to_string();
            // sql = re_key2.replace_all(&sql, format!("{})", m).as_str()).to_string();
            // sql = re_key3.replace_all(&sql, format!("{},", m).as_str()).to_string();
        }
    }
    // sql = sql.replace("'", "''");
    sql
}
#[deprecated(
since = "0.5.01",
note = "Please use the bind_variables instead"
)]
pub fn bind_values(value_map : &HashMap<String, Value>) -> String {

    let mut sql = String::new();

    let mut idx = 0;
    for (_key, value) in value_map {

        if idx > 0 {
            sql.push_str(", ");
        }
        idx = idx + 1;

        if let Value::String(m) = value {
            sql.push_str("'");
            sql.push_str(m.replace("'","''").as_str());
            sql.push_str("'");
        }

        if let Value::Float(m) = value {
            sql.push_str(format!("{}", m).as_str());
        }
        if let Value::Integer(m) = value {
            sql.push_str(format!("{}", m).as_str());
        }
    }
    sql

}
pub fn get_column_type(column_info : &str) -> ColumnType {

//    let re_str = Regex::new("[A-Z]+[0-9]?").unwrap();
    let re_str = Regex::new("VARCHAR2").unwrap();
    let re_int = Regex::new("NUMBER\\(\\d+\\)").unwrap();
    let re_float = Regex::new("NUMBER\\(\\d+,\\d+\\)").unwrap();
    let re_date = Regex::new("DATE").unwrap();

    if re_str.is_match(column_info) {
        ColumnType::String

    } else if re_int.is_match(column_info) {
        ColumnType::Integer

    } else if re_float.is_match(column_info) {
        ColumnType::Float

    } else if re_date.is_match(column_info) {
        ColumnType::Date

    }else {
        ColumnType::String
    }

}

pub fn get_string_value (arg : Option<&Value>) -> &str {
    let mut rt = "";

    if let Some(x) = arg {

        if let Value::String(y) = x {
            rt = y.as_str();
        }
    }
    rt
}
pub fn get_integer_value (arg : Option<&Value>) -> &i64 {
    let mut rt : &i64 = &0;

    if let Some(x) = arg {

        if let Value::Integer(y) = x {
            rt = y;
        }
    }
    rt
}
pub fn get_float_value (arg : Option<&Value>) -> &f64 {
    let mut rt  = &0.0;

    if let Some(x) = arg {

        if let Value::Float(y) = x {
            rt = y;
        }
    }
    rt
}


#[cfg(test)]
mod tests {
    #[test]
    fn hello_test (){
        println!("Hello");
    }
}