use serde::{Serialize};
use std::fmt::{Display, Formatter, Result as FmtResult};
use serde_json::{to_string_pretty};

#[derive(Debug, Serialize)]
pub enum OraDaoError {

    ConnectionError(String),

    StatementError(String),

    QueryError(String),

    RedisError(String),

}

impl Display for OraDaoError {
    fn fmt(&self, f: &mut Formatter) -> FmtResult {
        let error = to_string_pretty(self).unwrap();
        error!("{}", &error);
        write!(f, "{}", error)
    }
}