use postgres::{NoTls};
use crate::{DB_PROPERTIES};
use r2d2_postgres::PostgresConnectionManager;
use r2d2::{Pool, PooledConnection};
use parking_lot::{ RwLock};

lazy_static!{

    static ref PG_POOL: RwLock<Pool<PostgresConnectionManager<NoTls>>> = {
        RwLock::new(create_postgres_connection_manager())
    };
}
pub fn connect_db() -> Result<PooledConnection<PostgresConnectionManager<NoTls>>, r2d2::Error>{

    let conn = PG_POOL.read();
    return match conn.get() {

        Ok(t) => Ok(t),
        Err(e) => {
            error!("==> {:?}", e);
            drop(conn);

            let mut conn = PG_POOL.write();
            *conn = create_postgres_connection_manager();
            conn.get()
        }
    };
}
pub fn create_postgres_connection_manager() -> Pool<PostgresConnectionManager<NoTls>> {

    let pool_size = match DB_PROPERTIES.get("db.pool_size") {
        Some(t) =>   t.parse::<i32>().unwrap(),
        None => panic!("No pool_size is set up.")
    };
    let manager = PostgresConnectionManager::new( get_data_source().parse().unwrap(),NoTls,);
    let pool = r2d2::Pool::builder().max_size(3).build(manager).unwrap();
    pool
}

pub fn get_data_source() -> String{
    let data_source = format!("host={} port={} user={} password={} dbname={}"
                              , match DB_PROPERTIES.get("db.host") {
            Some(v) => v,
            _ => panic!(format!("No such property: db.host")),
        }
                              , match DB_PROPERTIES.get("db.port") {
            Some(v) => v,
            _ => panic!(format!("No such property: db.port")),
        }
                              , match DB_PROPERTIES.get("db.user") {
            Some(v) => v,
            _ => panic!(format!("No such property: db.user")),
        }
                              , match DB_PROPERTIES.get("db.password") {
            Some(v) => v,
            _ => panic!(format!("No such property: db.password")),
        }
                              , match DB_PROPERTIES.get("db.dbname") {
            Some(v) => v,
            _ => panic!(format!("No such property: db.dbname")),
        }
    );
    data_source
}
