extern crate serde;
use serde::{Deserialize};
use std::collections::HashMap;

pub fn default_string() -> String {
    "".to_string()
}

#[derive(Debug, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct SqlMap {

    #[serde(rename = "SqlStatement", default)]
    pub sql_statements: Vec<SqlStatement>,

}

#[derive(Debug, Deserialize)]
pub struct SqlStatement {

    pub id: String,
    pub crud: String,
    pub statement: String,

    #[serde(rename = "clause", default)]
    pub clauses: Vec<Clause>,

    #[serde(rename = "isNotEmpty", default)]
    pub is_not_empty: Vec<Property>,

    #[serde(rename = "isEqual", default)]
    pub is_equal: Vec<Property>,

    #[serde(rename = "footer", default)]
    pub footer: String,
}

#[derive(Debug, Deserialize)]
pub struct Clause {

    #[serde(default = "default_string")]
    pub id: String,

    #[serde(default = "default_string")]
    pub statement: String,

    #[serde(rename = "isNotEmpty", default)]
    pub is_not_empty: Vec<Property>,

    #[serde(rename = "isEqual", default)]
    pub is_equal: Vec<Property>,
}
#[derive(Debug, Deserialize)]
pub struct Property {

    pub property: String,

    #[serde(default = "default_string")]
    pub value: String,

    pub statement: String

}
#[derive(Debug, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct SqlStatementMap{

    pub statement: String,
    pub clause_map: HashMap<String, String>,
}
