/// Error indicating an expected value was not found.
#[derive(Debug, PartialEq, Eq, Clone, Copy)]
pub struct Mismatch<T> {
	/// Value expected.
	pub expected: T,
	/// Value found.
	pub found: T,
}

/// Error indicating value found is outside of a valid range.
#[derive(Debug, PartialEq, Eq, Clone, Copy)]
pub struct OutOfBounds<T> {
	/// Minimum allowed value.
	pub min: Option<T>,
	/// Maximum allowed value.
	pub max: Option<T>,
	/// Value found.
	pub found: T,
}
