//! **Unsound and unsafe**. For edutainment purposes only.
#![no_std]
#![deny(unsafe_op_in_unsafe_fn)]

/// Unbinds the lifetime in a reference. This disconnects the input lifetime
/// from the output lifetime, so use of the output reference will no longer
/// cause input reference to be kept "live" (as defined in
/// [RFC 2094: non-lexical lifetimes][NLL]). The output reference is given an
/// [unbounded lifetime][UBL], so the borrow checker is free to coerce it to
/// whatever is expected.
///
/// The output lifetime may still be implicitly bound by any references within
/// the referenced type `T`. You may need to unbind these as well, or replace
/// them with `'static`.
///
/// [NLL]: https://rust-lang.github.io/rfcs/2094-nll.html
/// [UBL]: https://doc.rust-lang.org/nomicon/unbounded-lifetimes.html
///
/// # Safety
///
/// This is **unsound and unsafe**, even though it is marked as a safe function!
/// Invoking these functions risks incurring the wrath of the optimizer. Rust
/// references are not pointers. For edutainment purposes only.
#[inline(always)]
pub fn reference<'bounded, 'unbounded, Ref: Reference<'bounded, 'unbounded>>(
    r#ref: Ref,
) -> Ref::Unbound {
    unsafe { r#ref.unbounded() }
}

/// # Safety
///
/// _This section intentionally left blank._
pub unsafe trait Reference<'bounded, 'unbounded> {
    type Unbound;

    /// # Safety
    ///
    /// _This section intentionally left blank._
    unsafe fn unbounded(self) -> Self::Unbound;
}

unsafe impl<'bounded, 'unbounded, SharedReference: 'unbounded> Reference<'bounded, 'unbounded>
    for &'bounded SharedReference
{
    type Unbound = &'unbounded SharedReference;

    #[inline(always)]
    unsafe fn unbounded(self) -> Self::Unbound {
        unsafe { ::core::mem::transmute(self) }
    }
}

unsafe impl<'bounded, 'unbounded, ExclusiveReference: 'unbounded> Reference<'bounded, 'unbounded>
    for &'bounded mut ExclusiveReference
{
    type Unbound = &'unbounded mut ExclusiveReference;

    #[inline(always)]
    unsafe fn unbounded(self) -> Self::Unbound {
        unsafe { ::core::mem::transmute(self) }
    }
}
