//! Not safe. For edutainment purposes only.

/// Unbinds the lifetime in a reference. This disconnects the input lifetime
/// from the output lifetime, so use of the output reference no longer requires
/// the input reference to be kept "alive" (in terms of [RFC 2094 NLL][1]). The
/// output reference is given an [unbounded lifetime][2], so the borrow checker is
/// free to coerce it to whatever is expected.
///
/// The output lifetime may still be implicitly bound by any references within
/// the referenced type `T`, unless those have also been unbound.
///
/// [1]: https://rust-lang.github.io/rfcs/2094-nll.html
/// [2]: https://doc.rust-lang.org/nomicon/unbounded-lifetimes.html
///
/// # Safety
///
/// This is **not safe**. For edutainment purposes only.
#[inline(always)]
pub fn reference<'bound, 'unbound, T: sealed::UnbindReference<'bound, 'unbound>>(
    x: T,
) -> T::Unbound {
    unsafe { x.unbind() }
}

mod sealed {
    pub unsafe trait UnbindReference<'bound, 'unbound> {
        type Unbound;
        unsafe fn unbind(self) -> Self::Unbound;
    }

    unsafe impl<'bound, 'unbound, T: 'unbound> UnbindReference<'bound, 'unbound> for &'bound T {
        type Unbound = &'unbound T;
        #[inline(always)]
        unsafe fn unbind(self) -> Self::Unbound {
            unsafe { ::std::mem::transmute(self) }
        }
    }

    unsafe impl<'bound, 'unbound, T: 'unbound> UnbindReference<'bound, 'unbound> for &'bound mut T {
        type Unbound = &'unbound mut T;
        #[inline(always)]
        unsafe fn unbind(self) -> Self::Unbound {
            unsafe { ::std::mem::transmute(self) }
        }
    }
}
