# Unbothered gpio
Everything is unwrapped under the hood for the precious prettiness of your code.
It's more than a simple Rust crate, it's a philosophy of life.

## Reading
```rust no_run
use unbothered_gpio::{UnbotheredGpioPin, UnbotheredGpioPinReader};

// Open pin 17 for reading
let mut reader = UnbotheredGpioPinReader::new(17);

let state: bool = reader.read();
println!("Pin 17 state : {}", state);
```

## Writing
```rust no_run
use unbothered_gpio::{UnbotheredGpioPin, UnbotheredGpioPinWriter};

// Open pin 17 for writing
let mut writer = UnbotheredGpioPinWriter::new(17);

// Set gpio pin 17 state to true
writer.write(true);
```

## Listening
```rust no_run
use unbothered_gpio::UnbotheredGpioPinListener;

UnbotheredGpioPinListener::new(17, |state: bool| {
    println!("New state for pin 17 : {}", state)
}).keep_alive();
```
