use quick_xml::events::{BytesDecl, Event};
use quick_xml::Writer;
use std::io;

use super::driver::*;
use structs::Worksheet;
use structs::WriterManager;

pub(crate) fn write<W: io::Seek + io::Write>(
    worksheet: &Worksheet,
    writer_mng: &mut WriterManager<W>,
) -> String {
    if worksheet.has_drawing_object() == false {
        return String::from("");
    }

    let mut writer = Writer::new(io::Cursor::new(Vec::new()));
    // XML header
    let _ = writer.write_event(Event::Decl(BytesDecl::new(
        b"1.0",
        Some(b"UTF-8"),
        Some(b"yes"),
    )));
    write_new_line(&mut writer);

    worksheet
        .get_worksheet_drawing()
        .write_to(&mut writer, worksheet.get_ole_objects());

    let file_no = writer_mng.add_file_at_drawing(writer);
    file_no.to_string()
}
