// c:numRef
use super::Formula;
use super::NumberingCache;
use structs::Spreadsheet;
use writer::driver::*;
use quick_xml::Reader;
use quick_xml::events::{Event, BytesStart};
use quick_xml::Writer;
use std::io::Cursor;

#[derive(Clone, Default, Debug)]
pub struct NumberReference {
    formula: Formula,
    numbering_cache: NumberingCache,
}
impl NumberReference {
    pub fn get_formula(&self)-> &Formula {
        &self.formula
    }

    pub fn get_formula_mut(&mut self)-> &mut Formula {
        &mut self.formula
    }

    pub fn set_formula(&mut self, value:Formula)-> &mut NumberReference {
        self.formula = value;
        self
    }

    pub fn get_numbering_cache(&self)-> &NumberingCache {
        &self.numbering_cache
    }

    pub fn get_numbering_cache_mut(&mut self)-> &mut NumberingCache {
        &mut self.numbering_cache
    }

    pub fn set_numbering_cache(&mut self, value:NumberingCache)-> &mut NumberReference {
        self.numbering_cache = value;
        self
    }

    pub(crate) fn set_attributes<R: std::io::BufRead>(
        &mut self,
        reader:&mut Reader<R>,
        _e:&BytesStart
    ) {
        let mut buf = Vec::new();
        loop {
            match reader.read_event(&mut buf) {
                Ok(Event::Start(ref e)) => {
                    match e.name() {
                        b"c:f" => {
                            self.formula.set_attributes(reader, e);
                        },
                        b"c:numCache" => {
                            self.numbering_cache.set_attributes(reader, e);
                        },
                        _ => (),
                    }
                },
                Ok(Event::End(ref e)) => {
                    match e.name() {
                        b"c:numRef" => return,
                        _ => (),
                    }
                },
                Ok(Event::Eof) => panic!("Error not find {} end element", "c:numRef"),
                Err(e) => panic!("Error at position {}: {:?}", reader.buffer_position(), e),
                _ => (),
            }
            buf.clear();
        }
    }

    pub(crate) fn write_to(&self, writer: &mut Writer<Cursor<Vec<u8>>>, spreadsheet: &Spreadsheet) {
        // c:numRef
        write_start_tag(writer, "c:numRef", vec![], false);

        // c:f
        &self.formula.write_to(writer);

        // c:numCache
        &self.numbering_cache.write_to(writer, self.get_formula().get_address(), spreadsheet);

        write_end_tag(writer, "c:numRef");
    }
}
