// a:glow
use super::super::super::Int64Value;
use super::SchemeColor;
use writer::driver::*;
use reader::driver::*;
use quick_xml::Reader;
use quick_xml::events::{Event, BytesStart};
use quick_xml::Writer;
use std::io::Cursor;

#[derive(Default, Debug)]
pub struct Glow {
    radius: Int64Value,
    scheme_color: Option<SchemeColor>,
}
impl Glow {
    pub fn get_radius(&self)-> &i64 {
        &self.radius.get_value()
    }
    
    pub fn set_radius(&mut self, value:i64)-> &mut Glow {
        self.radius.set_value(value);
        self
    }

    pub fn get_scheme_color(&self) -> &Option<SchemeColor> {
        &self.scheme_color
    }

    pub fn set_scheme_color(&mut self, value:SchemeColor) {
        self.scheme_color = Some(value);
    }

    pub(crate) fn set_attributes<R: std::io::BufRead>(
        &mut self,
        reader:&mut Reader<R>,
        e:&BytesStart
    ) {
        self.radius.set_value_string(get_attribute(e, b"rad").unwrap());

        let mut buf = Vec::new();
        loop {
            match reader.read_event(&mut buf) {
                Ok(Event::Start(ref e)) => {
                    match e.name() {
                        b"a:schemeClr" => {
                            let mut obj = SchemeColor::default();
                            obj.set_attributes(reader, e, false);
                            &mut self.set_scheme_color(obj);
                        },
                        _ => (),
                    }
                },
                Ok(Event::End(ref e)) => {
                    match e.name() {
                        b"a:glow" => return,
                        _ => (),
                    }
                },
                Ok(Event::Eof) => panic!("Error not find {} end element", "a:glow"),
                Err(e) => panic!("Error at position {}: {:?}", reader.buffer_position(), e),
                _ => (),
            }
            buf.clear();
        }
    }

    pub(crate) fn write_to(&self, writer: &mut Writer<Cursor<Vec<u8>>>) {
        // a:glow
        write_start_tag(writer, "a:glow", vec![
            ("rad", &self.radius.get_value_string()),
        ], false);

        // a:schemeClr
        match &self.scheme_color {
            Some(v) => {
                v.write_to(writer);
            },
            None => {}
        }

        write_end_tag(writer, "a:glow");
    }
}
