use num_rational::BigRational;
use num_traits::One;

use crate::{Env, Value, run};

const AMOUNT: usize = 6;
const STDSRC: [&str; AMOUNT] = [
    include_str!("base.um"),
    include_str!("struct.um"),
    include_str!("macro.um"),

    include_str!("impl/display.um"),
    include_str!("impl/clone.um"),
    include_str!("impl/iter.um"),
];

pub fn init(env: &mut Env<'_>) {
    env.set("__prelude", &Value::Number(BigRational::one()).into());

    let ms: [&str; AMOUNT] = ["base", "struct", "macro", "impl/display", "impl/clone", "impl/iter"];
    for (i, m) in ms.iter().enumerate() {
        log::debug!("[{}/{}] Running <std/{}>...", i+1, AMOUNT, m);

        let (nvars, vals) = run(&format!("<std/{}>", m), STDSRC[i], env, None, false);
        match vals {
            Ok(_) => {},
            Err(msg) => panic!("<std/{}>: {}", m, msg),
        }
        if let Some(nvars) = nvars {
            env.update(nvars);
        }
    }

    env.unset("__prelude");
}
