use std::collections::HashMap;

use maplit::hashmap;

use crate::RefTVal;

mod fmt;
mod io;
mod sys;
mod regex;
mod time;

pub fn get(name: &str) -> Option<HashMap<String, RefTVal>> {
    let mut vars = hashmap!{};
    match name {
        "fmt" => fmt::init(&mut vars),
        "io" => io::init(&mut vars),
        "sys" => sys::init(&mut vars),

        "time" => time::init(&mut vars),

        "regex" => regex::init(&mut vars),

        _ => return None,
    }
    Some(vars)
}
