use num::{BigRational, One};

use crate::{Env, Value, run};

const STDSRC: [&str; 4] = [
    include_str!("base.um"),
    include_str!("struct.um"),
    include_str!("macro.um"),
    include_str!("impl.um"),
];

pub fn init<'a>(env: &mut Env<'a>) {
    env.set("__prelude", &Value::Number(BigRational::one()).into());

    let ms = vec!["base", "struct", "macro", "impl"];
    for (i, m) in ms.iter().enumerate() {
        let (nvars, vals) = run(&format!("<std/{}>", m), STDSRC[i], &env, None, (0, false));
        match vals {
            Ok(_) => {},
            Err(m) => panic!("{}", m),
        }
        if let Some(nvars) = nvars {
            env.update(nvars);
        }
    }

    env.unset("__prelude");
}
