use std::collections::HashMap;
use std::sync::Arc;

use maplit::hashmap;

use crate::{Args, Env, Callable, FnArgs, FnReturn, RefTVal, Value, run_interactive, umcore::{_parse_margs, _macro_init}};

pub fn init(vars: &mut HashMap<String, RefTVal>) {
    vars.extend(hashmap!{
        "args".into() => args_init(),
        "inspect".into() => _macro_init(inspect),
    });
}

pub fn args_init() -> RefTVal {
    Value::Function {
        args: Arc::new(vec![]),
        vars: hashmap!{}.into(),
        body: Callable::Native(args),
    }.into()
}
pub fn args(_args: FnArgs) -> FnReturn {
    let outargs: Vec<RefTVal> = Args::handle().unwrap()
        .script.iter()
        .map(|a| Value::String(a.clone()).into())
        .collect();
    (None, Ok(Value::List(outargs).into()))
}

pub fn inspect(args: FnArgs) -> FnReturn {
    let (env, _pos, tokens) = match _parse_margs("macro sys.inspect", args) {
        Ok(t) => t,
        Err(m) => return (None, Err(m)),
    };

    let mut name = "inspect".to_string();
    if tokens.len() > 1 {
        name += "_";
        name += &tokens[1].data;
    }

    let nenv = Env::child(&env);
    run_interactive(&name, &nenv);

    (None, Ok(Value::none().into()))
}
