use std::collections::HashMap;
use std::sync::Arc;

use maplit::hashmap;

use crate::{TVal, RefTVal, Value, FnArgs, FnReturn, Callable, Type, Error, umcore::_parse_fargs};

pub fn init(vars: &mut HashMap<String, RefTVal>) {
    vars.extend(hashmap!{
        "format".into() => format_init(),
    });
}

pub fn format_init() -> RefTVal {
    Value::Function {
        args: Arc::new(vec![
            ("f".into(), Type::string()),
            ("*vargs".into(), Type::any()),
        ]),
        vars: hashmap!{}.into(),
        body: Callable::Native(format),
    }.into()
}
pub fn format(args: FnArgs) -> FnReturn {
    let (_this, pos, args) = match _parse_fargs("function fmt.format", args) {
        Ok(t) => t,
        Err(m) => return (None, Err(m)),
    };

    if let Value::List(ref args) = args.clone_out().val {
        if let Some(rv0) = args.get(0) {
            if let TVal { val: Value::String(f), .. } = rv0.clone_out() {
                let ps = args[1..].iter()
                    .map(|a| a.clone_out().val.to_string())
                    .collect::<Vec<String>>();
                let mut s = f;
                for p in ps {
                    s = s.replacen("{}", &p, 1);
                }
                return (None, Ok(Value::String(s).into()));
            }
        }
    }

    (None, Err(Error::Script(format!("function fmt.format: expected args [String, Any], got {}", args.clone_out().val), pos)))
}
