use std::collections::HashMap;

use crate::{Env, TVal, run};

const STDSRC_BASE: &str = include_str!("base.um");

pub fn _init(vars: &mut HashMap<String, TVal>) {
    let env = Env::from(vars.clone());
    let (nvars, vals) = run("<std/base>", STDSRC_BASE, &env, None, (0, false));
    match vals {
        Ok(_) => {},
        Err(m) => panic!("{}", m),
    }
    if let Some(nvars) = nvars {
        vars.extend(nvars);
    }
}
