use std::sync::Arc;

use num::ToPrimitive;

use maplit::hashmap;

use crate::{Error, Env, Type, Value, TVal, FnArgs, FnReturn, Callable, run};

use super::_parse_fargs;

pub fn eval_init() -> TVal {
    Value::Function {
        args: Arc::new(vec![
            ("code".into(), Type::string()),
        ]),
        vars: hashmap!{}.into(),
        body: Callable::Native(eval),
    }.into()
}
pub fn eval(args: FnArgs) -> FnReturn {
    let (mut pos, args) = match _parse_fargs("function eval", args) {
        Ok(t) => t,
        Err(m) => return (None, Err(m)),
    };

    use Value::*;
    if let List(ref args) = args.val {
        if let Some(TVal { val: String(s), .. }) = args.get(1) {
            let filename = match &mut pos {
                Some(p) => {
                    let filename = p.filename.clone() + "<eval>";
                    p.filename = filename.clone();
                    filename
                },
                None => "<eval>".into(),
            };
            let (_, vals) = run(&filename, s, &Env::prelude(), pos, (0, false));
            return (None, vals);
        }
    }

    (None, Err(Error::ScriptError(format!("function eval: expected args [String], got {}", args.val), pos)))
}
pub fn exit_init() -> TVal {
    Value::Function {
        args: Arc::new(vec![
            ("status".into(), Type::number()),
        ]),
        vars: hashmap!{}.into(),
        body: Callable::Native(exit),
    }.into()
}
pub fn exit(args: FnArgs) -> FnReturn {
    let (pos, args) = match _parse_fargs("function exit", args) {
        Ok(t) => t,
        Err(m) => return (None, Err(m)),
    };

    use Value::*;
    if let List(ref args) = args.val {
        let ec = match args.get(1) {
            Some(TVal { val: Number(n), .. }) => n.to_integer().to_i32().unwrap_or(128),
            _ => 0,
        };
        std::process::exit(ec);
    }

    (None, Err(Error::ScriptError(format!("function exit: expected args [Number], got {}", args.val), pos)))
}
