# UltraHook Client

Rust client for https://www.ultrahook.com/

Uses UltraHook for receiving webhooks without a public internet presence.

There's just one function really `get_webhooks`.

Example: 

```rust
let (config, stream) = get_webhooks(&key, &subdomain).await?;
println!("Receiving webhooks forwarded from {}", config.host);
let mut responses = Box::pin(stream);
while let Some(response) = responses.next().await {
    let response = response?;
    if matches!(response, UltraHookEvent::Request(..) {
        println!("Webhook details:");
        println!("{:?}", response);
    }
}
```
