use futures::StreamExt;
use std::env::{args, var};
use std::error::Error;
use ultrahook::get_webhooks;

#[tokio::main(flavor = "current_thread")]
async fn main() -> Result<(), Box<dyn Error>> {
    let subdomain = args().nth(1).expect("A subdomain argument");
    let key = var("ULTRAHOOK_API_KEY")?;

    let (config, stream) = get_webhooks(&key, &subdomain).await?;
    println!("Receiving webhooks forwarded from {}", config.host);
    let mut responses = Box::pin(stream);
    while let Some(response) = responses.next().await {
        println!("Message:");
        println!("{:?}", response?);
    }
    Ok(())
}
