use std::net::TcpListener;
use ultnote::handlers;
use ultnote::Program;

fn main() {
    // Start the server
    let host: &str = "127.0.0.1:8787";
    let listener = TcpListener::bind(host).expect("Could not start listener");
    println!(
        r"
-------------------------------------------------------------
-- Ultnote - For VS Code Extension - Ultnote ------------
-------------------------------------------------------------
Ultnote is running on {host}

The default path for your notes is ~/ultnote
Change the path in File > Preferences > Settings > 'ultnote'

--------------------------------------------------------------
-- Default Keybindings ---------------------------------------
--------------------------------------------------------------
alt+f: Search notes in VS Code, add ultnote path to workspace
alt+p: Preview notes as static website using mdBook
alt+o: Open main.rs to see what code is being generated

Change in File > Preferences > Keyboard Shortcuts > 'ultnote'
"
    );
    // The Program will remain in state while the server is running
    let mut program = Program::new();

    // This is the main loop over incoming streams
    for stream in listener.incoming() {
        let stream = stream.expect("Could not iterate over stream");
        handlers::code_request(stream, &mut program);
    }
}
