#[macro_use]
extern crate clap;
use clap::App;
mod ext;
mod lib;
mod log;
mod net;
use ext::read_dir_size;
use rand::Rng;

fn main() {
    let log = cf::logger::SimpleLogger::new();
    let yaml = load_yaml!("uix_cli.yml");
    let matches = App::from_yaml(yaml).get_matches();

    if let Some(m) = matches.value_of("stress") {
        lib::stress(m.parse::<i32>().unwrap_or_else(|_e| 42));
    } else if let Some(m) = matches.value_of("dirsize") {
        read_dir_size(m);
    } else if let Some(_m) = matches.value_of("mergelog") {
        let files: Vec<_> = matches
            .values_of("mergelog")
            .expect("No files specified")
            .collect();
        log::LogFiles::merge(files);
    } else if let Some(_m) = matches.value_of("download") {
        let args: Vec<_> = matches
            .values_of("download")
            .expect("No files specified")
            .collect();
        let s = format!("Downloading from {:?}", args.join(" "));
        log.info(&s);

        let filename = if args.iter().len() >= 2 {
            args[1]
        } else {
            args[0].split("/").last().unwrap()
        };
        net::download(args[0], filename);
    } else if let Some(m) = matches.value_of("random_file") {
        lib::create_file_with_size(m.parse::<usize>().unwrap());
    } else if matches.is_present("account") {
        let sh = lib::StringHelper {};
        let mut rnd = rand::thread_rng();
        let account = &sh.generate_string(rnd.gen_range(8..12));
        let password = &sh.generate_string(rnd.gen_range(13..18));
        println!("{} | {}", account, password);
    } else if matches.is_present("redis_sync") {
        // sync files with redis
        let rs = net::RedisSync::new();
        let args: Vec<String> = std::env::args().collect();
        if args.len() > 2 {
            rs.to_server(args[2..].iter().map(|x| x.as_str()).collect());
        }
    }
}
