// use cf::IO as cio;
use std::fs;
use std::fs::File;
use std::io::{prelude::*, BufReader, BufWriter};
use std::path::Path;

pub struct LogFiles {}
impl LogFiles {
    fn read(filename: impl AsRef<Path>) -> Vec<String> {
        let file = fs::File::open(filename).expect("Open file failed.");
        let buf = BufReader::new(file);
        let mut res = vec!["[2020".to_string()];
        for ln in buf.lines() {
            let ln = ln.unwrap();
            if ln.starts_with("[2021-") {
                res.push(ln);
            } else {
                let mut e = String::from(res.last().unwrap());
                e.push_str(&ln);
                res.pop();
                res.push(e);
            }
        }
        res
    }

    pub fn merge(file_list: Vec<&str>) {
        let mut merged: Vec<String> = Vec::new();
        println!("Merging log files: {:?}", &file_list);

        for f in file_list.iter() {
            merged.extend(LogFiles::read(f));
        }
        merged.sort();
        let input = File::create("res.txt").expect("open filed failed");
        let mut buffered = BufWriter::new(input);
        for line in merged.iter() {
            buffered.write(line.as_bytes()).expect("");
            buffered.write("\n".as_bytes()).expect("");
        }
        println!("{}", "Export result to res.txt");
    }
}
