use cf::FileSystem;

pub fn read_dir_size(dir_name: &str) {
    // Print out the given directory size in human readable format
    let _size = FileSystem::dir_size(dir_name).unwrap() as f64;
    let units = "KB MB GB TB".split_whitespace().collect::<Vec<&str>>();
    let ans = units.iter().fold((_size, "B"), |(n, w), u| {
        if n > 1024.0 {
            (n / 1024.0, u)
        } else {
            (n, w)
        }
    });
    println!("{:.2} {}", ans.0, ans.1);
}
