#[macro_use]
extern crate clap;
use clap::App;
mod lib;
mod log;
mod net;
use rand::Rng;

fn main() {
    let yaml = load_yaml!("uix_cli.yml");
    let matches = App::from_yaml(yaml).get_matches();

    if let Some(m) = matches.value_of("stress") {
        lib::stress(m.parse::<i32>().unwrap_or_else(|_e| 42));
    } else if let Some(_m) = matches.value_of("mergelog") {
        let files: Vec<_> = matches.values_of("mergelog").unwrap().collect();
        log::LogFiles::merge(files);
    } else if let Some(f) = matches.value_of("tovps") {
        net::upload2olvps(f);
    } else if let Some(_m) = matches.value_of("download") {
        let args: Vec<_> = matches.values_of("download").unwrap().collect();
        let filename = if args.iter().len() >= 2 {
            args[1]
        } else {
            args[0].split("/").last().unwrap()
        };
        net::download(args[0], filename);
    } else if let Some(m) = matches.value_of("random_file") {
        lib::create_file_with_size(m.parse::<usize>().unwrap());
    } else {
        let sh = lib::StringHelper {};
        let mut rnd = rand::thread_rng();
        let account = &sh.generate_string(rnd.gen_range(8..12));
        let password = &sh.generate_string(rnd.gen_range(13..18));
        println!("{} | {}", account, password);
    }
}
