use indicatif::{ProgressBar, ProgressStyle};
use rand::seq::SliceRandom;
use rand::thread_rng;
use std::fs::File;
use std::io::{BufWriter, Write};

use rand::{distributions::Alphanumeric, Rng};
use std::{thread, time::Duration};

pub fn stress(size: i32) {
    println!("Allocating {} MB memory", size);
    let m = (size / 4) as i64;
    let _v: Vec<i64> = (1..(1024 * 1024 * m)).collect();
    thread::sleep(Duration::from_millis(3000));
}

pub struct StringHelper {}
impl StringHelper {
    pub fn generate_string(&self, length: usize) -> String {
        rand::thread_rng()
            .sample_iter(&Alphanumeric)
            .take(length)
            .map(char::from)
            .collect()
    }
}

pub fn create_file_with_size(mb_size: usize) {
    // Create a random binary file with size <mb_size> MB
    let size = 1024 * 1024 * mb_size;
    let f = File::create("cc.txt").expect("Failed to create file");
    let mut writer = BufWriter::new(f);
    let mut v = (0..1024).map(|i| (i % 255) as u8).collect::<Vec<_>>();
    let mut rng = thread_rng();
    v.shuffle(&mut rng);
    let cnt = size / 1024;
    let pb = ProgressBar::new(cnt as u64 / 1024);
    pb.set_style(ProgressStyle::default_bar()
        .template("{spinner:.red} [{elapsed_precise}] [{wide_bar:.cyan/blue}] {pos:>3}MB/{len:3}MB ({eta})")
        .progress_chars("->-"));

    for i in 0..cnt {
        writer.write(&v).expect("Unable to write data");
        if i % 1024 == 0 {
            pb.set_position(i as u64 / 1024);
        }
    }
    pb.finish_with_message("downloaded");
}
