use rand::{distributions::Alphanumeric, Rng};
use std::{thread, time::Duration};

pub fn stress(size: i32) {
    println!("Allocating {} MB memory", size);
    let m = (size / 4) as i64;
    let _v: Vec<i64> = (1..(1024 * 1024 * m)).collect();
    thread::sleep(Duration::from_millis(3000));
}

pub struct StringHelper {}
impl StringHelper {
    pub fn generate_string(&self, length: usize) -> String {
        rand::thread_rng()
            .sample_iter(&Alphanumeric)
            .take(length)
            .map(char::from)
            .collect()
    }
}
