use log::*;
#[cfg(target_os = "linux")]
extern crate tun_tap;
#[cfg(target_os = "linux")]
use tun_tap::*;
#[cfg(target_os = "macos")]
extern crate tun_tap_mac;
#[cfg(target_os = "macos")]
use tun_tap_mac::*;
use virtio_bindings::bindings::virtio_net::*;
extern crate mac_address;
use self::mac_address::*;

const HOST_FEATURES: u32 = (1 << VIRTIO_NET_F_STATUS) | (1 << VIRTIO_NET_F_MAC);
const MEMORY_BAR0: u32 = 0xfe000000;

pub struct VirtioNetDevice {
	iface: Option<Iface>,
	mac_addr: [u8; 6],
}

impl VirtioNetDevice {
	pub const fn new() -> VirtioNetDevice {
		//let virt_queues: Vec<Virtqueue> = Vec::new();
		VirtioNetDevice {
			//virt_queues,
			iface: None,
			mac_addr: [0; 6],
		}
	}

}
