# Changelog
All notable changes to this project will be documented in this file.

## [0.1.6] - 2021-11-10

### Features

- **derive**: Add FromStr shortcut (#22)

## [0.1.5] - 2020-04-20

### Bug Fixes

- **sys**: Update to latest snapshot of libucl

### Documentation

- **vh**: Document unpack_closure- Missed a few words


### Features

- **derive**: Ability to add pre_sync_hook
- **derive**: Ability to add chunks
- **parser**: Introduce VaribleHandler trait
- **vh**: Make variables handlers into features
- **vh**: Add simple and safe iterface to parser
- **vh/compound**: Introduce Compound VarHandler
- **vh/env**: Introduce EnvVar variable handler

### Miscellaneous Tasks

- **changelog**: Update for 0.1.4
- **parser**: Remove unused imports
- **readme**: Sync readme- Change how libc version defined
- Cleanup parser test code
- Sync libucl with upstream
- Release derive crate


### Refactor

- **vh**: Remove unnecessary copy in handlers
- **vh**: Don't try to pass unsafe function as safe- Apply clippy suggestions to Priority
- Apply clippy suggestions


### Styling

- **derive**: Clippy suggestions- Run cargo fmt
- Run cargofmt
- Remove whitespace in src/lib.rs docs


### Testing

- **vh**: Workaround for Azure?
- **vh**: Don't run env test on ci for now

### Ci

- **github**: Setup github actions (#16)- Automate release notes creation


## [0.1.4] - 2020-04-05

### Bug Fixes

- **iter**: Iterators for implicit arrays (#12)
- **priority**: Priority incorrectly capped at 15 (#15)

### Documentation
- Fix a typo
- Fix typos


### Features

- **object**: Implement PartialEq (#10)
- **object**: Ability to clone and deepclone objects
- **object**: Implement Ord (#14)- Derive mandatory traits for Priority


### Miscellaneous Tasks
- Cleanup iterators code


### Styling
- Run cargo fmt


### Testing

- **parser**: Add at least one error state test (#13)- Add unit tests for Priority
- Test unhappy paths in utils


### Ci
- Ignore some paths when coverage is calculated
- Add token for codecov and setup notificaitons
- Fix codecov token


## [0.1.3] - 2020-04-04

### Bug Fixes

- **derive**: Automatically convert TryFrom errors

### Features

- **derive**: Fields mappers and validators
- **derive**: Map conversion helper- Parse time object into f64 and Duration
- Ability to register variables on a builder.
- Ability to call set_filevars on a builder.
- Add TryInto trait for simplicity of conversion.
- Ability to "wrap" other errors inside ObjectError.


### Miscellaneous Tasks
- Remove unused code


<!-- generated by git-cliff -->
