//! Argument and parameter types used by DNS Commands and Responses
use atat::atat_derive::AtatEnum;

/// Type of resolution operation:
#[derive(Clone, PartialEq, AtatEnum)]
pub enum ResolutionType {
    /// - 0: domain name to IP address
    DomainNameToIp = 0,
    /// - 1: IP address to domain name (host by name)
    IpToDomainName = 1,
}
