// 99 characters, I guess I can’t add any more feature flags. Just as well I have all those I need.
#![feature(const_trait_impl, const_char_convert, const_option, const_fn_floating_point_arithmetic)]
#![no_std]
// What do you want *docs* for!? (But I will begrudgingly allow doctests to run.)
#![cfg(any(not(doc), doctest))]

use core::ops::Add;

pub struct U;

impl const Add<u32> for U {
    type Output = char;

    fn add(self, n: u32) -> char {
        char::from_u32(
            n % 10 +
            (n / 10) % 10 * 0x10 +
            (n / 100) % 10 * 0x100 +
            (n / 1000) % 10 * 0x1000 +
            (n / 10000) % 10 * 0x10000 +
            (n / 100000) % 10 * 0x100000
        ).expect("I expected better of you. Depart, and reflect upon your transgressions.")
    }
}

impl const Add<f32> for U {
    type Output = char;

    fn add(self, f: f32) -> char {
        let n = f as u32;
        if f != (n as f32) {
            panic!("Begone, fractionaliser of U+ literals!");
        }
        char::from_u32(
            0xf32 +
            n % 10 * 0x1000 +
            (n / 10) % 10 * 0x10000 +
            (n / 100) % 10 * 0x100000
        ).expect("Will you never be better?")
    }
}

impl const Add<f64> for U {
    type Output = char;

    fn add(self, f: f64) -> char {
        let n = f as u32;
        if f != (n as f64) {
            panic!("Get ye hence, fracticious one!");
        }
        char::from_u32(
            0xf64 +
            n % 10 * 0x1000 +
            (n / 10) % 10 * 0x10000 +
            (n / 100) % 10 * 0x100000
        ).expect("I am exceedingly wrothful to youwards.")
    }
}

#[test]
fn success() {
    assert_eq!(U+0000, '\u{0}');
    assert_eq!(U+1234, '\u{1234}');
    assert_eq!(U+2f64, '\u{2f64}');
    assert_eq!(U+102f64, '\u{102f64}');
    assert_eq!(U+104f32, '\u{104f32}');
    // Evaluated at const time!
    const MAX: char = U+109999;
    assert_eq!(MAX, '\u{109999}');
}

/// ```rust
/// #![feature(const_trait_impl)]  // Not sure quite why this is needed, but meh.
/// use u_plus::U;
/// const HAPPINESS: char = U+2323;
/// ```
///
/// ```rust,compile_fail
/// #![feature(const_trait_impl)]
/// use u_plus::U;
/// const MISERY: char = U+119999;
/// ```
///
/// ```rust,compile_fail
/// #![feature(const_trait_impl)]
/// use u_plus::U;
/// const SORROW: char = U+1F622;
/// ```
#[cfg(doctest)]
const _: () = ();
