Known issues that probably won’t ever be fixed (and hopefully *can’t* ever be fixed):

- Unicode scalar values whose hexadecimal representations contain a non-decimal
  character (such as U+1F622) cannot use this representation (except as noted below).

  (I thought I might have to mention that surrogates like U+DEAD can’t be
  represented because of using `char`, but this rule already covers surrogates,
  as they all start with D and so already couldn’t be expressed.
  I’m sticking with calling this code point literals rather than
  scalar value literals, and you probably can’t stop me.)

- Sequences ending in F32 or F64 (e.g. U+0F32) but containing no other
  non-decimal characters work, but the F has to be lowercase (e.g. `U+0f32`).

- If you write the number after `U+` in a format other than decimal,
  you will be punished with incorrect answers (other than for zero).
  I mean, really, what did you *expect*, writing a monstrosity like `U+0x1F92E`?

Known issues that could conceivably become fixable at some future point (but probably not):

- rustfmt will uglify the code, turning `U+1234` into `U + 1234` and possibly
  even inserting a line break. Tch. Such poor taste.

Known issues that will probably become fixable in the future:

- Depends on nightly rustc for various const stuff.
  (You do want your Unicode literals checked at compile time, right?)

- Doesn’t explain the error very well.

Other limitations:

- This only works in stead of `char` literals; for string literals,
  you *could* use things like the `const_format` crate if you really want to,
  like `concatcp!("U+1234 = ", U+1234)`.
