// SPDX-License-Identifier: MIT-0
//
// GENERATED FILE
// ALL CHANGES MADE IN THIS FILE WILL BE LOST!
//
// MIT No Attribution
//
// Copyright 2022 René Kijewski <crates.io@k6i.de>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
// associated documentation files (the "Software"), to deal in the Software without restriction,
// including without limitation the rights to use, copy, modify, merge, publish, distribute,
// sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
// NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

use tz::TimeZoneRef;

/// All defined time zones statically accessible
pub mod time_zone {
    use super::*;

    /// africa
    pub mod africa {
        use super::*;

        /// Time zone data for Africa/Abidjan,
        pub const ABIDJAN: TimeZoneRef<'static> = tzdata::AFRICA_ABIDJAN;

        /// Time zone data for Africa/Accra,
        pub const ACCRA: TimeZoneRef<'static> = tzdata::AFRICA_ACCRA;

        /// Time zone data for Africa/Addis_Ababa,
        pub const ADDIS_ABABA: TimeZoneRef<'static> = tzdata::AFRICA_ADDIS_ABABA;

        /// Time zone data for Africa/Algiers,
        pub const ALGIERS: TimeZoneRef<'static> = tzdata::AFRICA_ALGIERS;

        /// Time zone data for Africa/Asmara,
        pub const ASMARA: TimeZoneRef<'static> = tzdata::AFRICA_ASMARA;

        /// Time zone data for Africa/Asmera,
        pub const ASMERA: TimeZoneRef<'static> = tzdata::AFRICA_ASMARA;

        /// Time zone data for Africa/Bamako,
        pub const BAMAKO: TimeZoneRef<'static> = tzdata::AFRICA_BAMAKO;

        /// Time zone data for Africa/Bangui,
        pub const BANGUI: TimeZoneRef<'static> = tzdata::AFRICA_BANGUI;

        /// Time zone data for Africa/Banjul,
        pub const BANJUL: TimeZoneRef<'static> = tzdata::AFRICA_BANJUL;

        /// Time zone data for Africa/Bissau,
        pub const BISSAU: TimeZoneRef<'static> = tzdata::AFRICA_BISSAU;

        /// Time zone data for Africa/Blantyre,
        pub const BLANTYRE: TimeZoneRef<'static> = tzdata::AFRICA_BLANTYRE;

        /// Time zone data for Africa/Brazzaville,
        pub const BRAZZAVILLE: TimeZoneRef<'static> = tzdata::AFRICA_BRAZZAVILLE;

        /// Time zone data for Africa/Bujumbura,
        pub const BUJUMBURA: TimeZoneRef<'static> = tzdata::AFRICA_BUJUMBURA;

        /// Time zone data for Africa/Cairo,
        pub const CAIRO: TimeZoneRef<'static> = tzdata::EGYPT;

        /// Time zone data for Africa/Casablanca,
        pub const CASABLANCA: TimeZoneRef<'static> = tzdata::AFRICA_CASABLANCA;

        /// Time zone data for Africa/Ceuta,
        pub const CEUTA: TimeZoneRef<'static> = tzdata::AFRICA_CEUTA;

        /// Time zone data for Africa/Conakry,
        pub const CONAKRY: TimeZoneRef<'static> = tzdata::AFRICA_CONAKRY;

        /// Time zone data for Africa/Dakar,
        pub const DAKAR: TimeZoneRef<'static> = tzdata::AFRICA_DAKAR;

        /// Time zone data for Africa/Dar_es_Salaam,
        pub const DAR_ES_SALAAM: TimeZoneRef<'static> = tzdata::AFRICA_DAR_ES_SALAAM;

        /// Time zone data for Africa/Djibouti,
        pub const DJIBOUTI: TimeZoneRef<'static> = tzdata::AFRICA_DJIBOUTI;

        /// Time zone data for Africa/Douala,
        pub const DOUALA: TimeZoneRef<'static> = tzdata::AFRICA_DOUALA;

        /// Time zone data for Africa/El_Aaiun,
        pub const EL_AAIUN: TimeZoneRef<'static> = tzdata::AFRICA_EL_AAIUN;

        /// Time zone data for Africa/Freetown,
        pub const FREETOWN: TimeZoneRef<'static> = tzdata::AFRICA_FREETOWN;

        /// Time zone data for Africa/Gaborone,
        pub const GABORONE: TimeZoneRef<'static> = tzdata::AFRICA_GABORONE;

        /// Time zone data for Africa/Harare,
        pub const HARARE: TimeZoneRef<'static> = tzdata::AFRICA_HARARE;

        /// Time zone data for Africa/Johannesburg,
        pub const JOHANNESBURG: TimeZoneRef<'static> = tzdata::AFRICA_JOHANNESBURG;

        /// Time zone data for Africa/Juba,
        pub const JUBA: TimeZoneRef<'static> = tzdata::AFRICA_JUBA;

        /// Time zone data for Africa/Kampala,
        pub const KAMPALA: TimeZoneRef<'static> = tzdata::AFRICA_KAMPALA;

        /// Time zone data for Africa/Khartoum,
        pub const KHARTOUM: TimeZoneRef<'static> = tzdata::AFRICA_KHARTOUM;

        /// Time zone data for Africa/Kigali,
        pub const KIGALI: TimeZoneRef<'static> = tzdata::AFRICA_KIGALI;

        /// Time zone data for Africa/Kinshasa,
        pub const KINSHASA: TimeZoneRef<'static> = tzdata::AFRICA_KINSHASA;

        /// Time zone data for Africa/Lagos,
        pub const LAGOS: TimeZoneRef<'static> = tzdata::AFRICA_LAGOS;

        /// Time zone data for Africa/Libreville,
        pub const LIBREVILLE: TimeZoneRef<'static> = tzdata::AFRICA_LIBREVILLE;

        /// Time zone data for Africa/Lome,
        pub const LOME: TimeZoneRef<'static> = tzdata::AFRICA_LOME;

        /// Time zone data for Africa/Luanda,
        pub const LUANDA: TimeZoneRef<'static> = tzdata::AFRICA_LUANDA;

        /// Time zone data for Africa/Lubumbashi,
        pub const LUBUMBASHI: TimeZoneRef<'static> = tzdata::AFRICA_LUBUMBASHI;

        /// Time zone data for Africa/Lusaka,
        pub const LUSAKA: TimeZoneRef<'static> = tzdata::AFRICA_LUSAKA;

        /// Time zone data for Africa/Malabo,
        pub const MALABO: TimeZoneRef<'static> = tzdata::AFRICA_MALABO;

        /// Time zone data for Africa/Maputo,
        pub const MAPUTO: TimeZoneRef<'static> = tzdata::AFRICA_MAPUTO;

        /// Time zone data for Africa/Maseru,
        pub const MASERU: TimeZoneRef<'static> = tzdata::AFRICA_MASERU;

        /// Time zone data for Africa/Mbabane,
        pub const MBABANE: TimeZoneRef<'static> = tzdata::AFRICA_MBABANE;

        /// Time zone data for Africa/Mogadishu,
        pub const MOGADISHU: TimeZoneRef<'static> = tzdata::AFRICA_MOGADISHU;

        /// Time zone data for Africa/Monrovia,
        pub const MONROVIA: TimeZoneRef<'static> = tzdata::AFRICA_MONROVIA;

        /// Time zone data for Africa/Nairobi,
        pub const NAIROBI: TimeZoneRef<'static> = tzdata::AFRICA_NAIROBI;

        /// Time zone data for Africa/Ndjamena,
        pub const NDJAMENA: TimeZoneRef<'static> = tzdata::AFRICA_NDJAMENA;

        /// Time zone data for Africa/Niamey,
        pub const NIAMEY: TimeZoneRef<'static> = tzdata::AFRICA_NIAMEY;

        /// Time zone data for Africa/Nouakchott,
        pub const NOUAKCHOTT: TimeZoneRef<'static> = tzdata::AFRICA_NOUAKCHOTT;

        /// Time zone data for Africa/Ouagadougou,
        pub const OUAGADOUGOU: TimeZoneRef<'static> = tzdata::AFRICA_OUAGADOUGOU;

        /// Time zone data for Africa/Porto-Novo,
        pub const PORTO_NOVO: TimeZoneRef<'static> = tzdata::AFRICA_PORTO_NOVO;

        /// Time zone data for Africa/Sao_Tome,
        pub const SAO_TOME: TimeZoneRef<'static> = tzdata::AFRICA_SAO_TOME;

        /// Time zone data for Africa/Timbuktu,
        pub const TIMBUKTU: TimeZoneRef<'static> = tzdata::AFRICA_TIMBUKTU;

        /// Time zone data for Africa/Tripoli,
        pub const TRIPOLI: TimeZoneRef<'static> = tzdata::LIBYA;

        /// Time zone data for Africa/Tunis,
        pub const TUNIS: TimeZoneRef<'static> = tzdata::AFRICA_TUNIS;

        /// Time zone data for Africa/Windhoek,
        pub const WINDHOEK: TimeZoneRef<'static> = tzdata::AFRICA_WINDHOEK;

        /// Raw, unparsed time zone data for Africa/Abidjan,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ABIDJAN: &[u8] = raw_tzdata::AFRICA_ABIDJAN;

        /// Raw, unparsed time zone data for Africa/Accra,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ACCRA: &[u8] = raw_tzdata::AFRICA_ACCRA;

        /// Raw, unparsed time zone data for Africa/Addis_Ababa,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ADDIS_ABABA: &[u8] = raw_tzdata::AFRICA_ADDIS_ABABA;

        /// Raw, unparsed time zone data for Africa/Algiers,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ALGIERS: &[u8] = raw_tzdata::AFRICA_ALGIERS;

        /// Raw, unparsed time zone data for Africa/Asmara,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ASMARA: &[u8] = raw_tzdata::AFRICA_ASMARA;

        /// Raw, unparsed time zone data for Africa/Asmera,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ASMERA: &[u8] = raw_tzdata::AFRICA_ASMARA;

        /// Raw, unparsed time zone data for Africa/Bamako,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BAMAKO: &[u8] = raw_tzdata::AFRICA_BAMAKO;

        /// Raw, unparsed time zone data for Africa/Bangui,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BANGUI: &[u8] = raw_tzdata::AFRICA_BANGUI;

        /// Raw, unparsed time zone data for Africa/Banjul,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BANJUL: &[u8] = raw_tzdata::AFRICA_BANJUL;

        /// Raw, unparsed time zone data for Africa/Bissau,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BISSAU: &[u8] = raw_tzdata::AFRICA_BISSAU;

        /// Raw, unparsed time zone data for Africa/Blantyre,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BLANTYRE: &[u8] = raw_tzdata::AFRICA_BLANTYRE;

        /// Raw, unparsed time zone data for Africa/Brazzaville,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BRAZZAVILLE: &[u8] = raw_tzdata::AFRICA_BRAZZAVILLE;

        /// Raw, unparsed time zone data for Africa/Bujumbura,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BUJUMBURA: &[u8] = raw_tzdata::AFRICA_BUJUMBURA;

        /// Raw, unparsed time zone data for Africa/Cairo,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CAIRO: &[u8] = raw_tzdata::EGYPT;

        /// Raw, unparsed time zone data for Africa/Casablanca,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CASABLANCA: &[u8] = raw_tzdata::AFRICA_CASABLANCA;

        /// Raw, unparsed time zone data for Africa/Ceuta,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CEUTA: &[u8] = raw_tzdata::AFRICA_CEUTA;

        /// Raw, unparsed time zone data for Africa/Conakry,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CONAKRY: &[u8] = raw_tzdata::AFRICA_CONAKRY;

        /// Raw, unparsed time zone data for Africa/Dakar,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DAKAR: &[u8] = raw_tzdata::AFRICA_DAKAR;

        /// Raw, unparsed time zone data for Africa/Dar_es_Salaam,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DAR_ES_SALAAM: &[u8] = raw_tzdata::AFRICA_DAR_ES_SALAAM;

        /// Raw, unparsed time zone data for Africa/Djibouti,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DJIBOUTI: &[u8] = raw_tzdata::AFRICA_DJIBOUTI;

        /// Raw, unparsed time zone data for Africa/Douala,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DOUALA: &[u8] = raw_tzdata::AFRICA_DOUALA;

        /// Raw, unparsed time zone data for Africa/El_Aaiun,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_EL_AAIUN: &[u8] = raw_tzdata::AFRICA_EL_AAIUN;

        /// Raw, unparsed time zone data for Africa/Freetown,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_FREETOWN: &[u8] = raw_tzdata::AFRICA_FREETOWN;

        /// Raw, unparsed time zone data for Africa/Gaborone,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GABORONE: &[u8] = raw_tzdata::AFRICA_GABORONE;

        /// Raw, unparsed time zone data for Africa/Harare,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_HARARE: &[u8] = raw_tzdata::AFRICA_HARARE;

        /// Raw, unparsed time zone data for Africa/Johannesburg,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_JOHANNESBURG: &[u8] = raw_tzdata::AFRICA_JOHANNESBURG;

        /// Raw, unparsed time zone data for Africa/Juba,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_JUBA: &[u8] = raw_tzdata::AFRICA_JUBA;

        /// Raw, unparsed time zone data for Africa/Kampala,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KAMPALA: &[u8] = raw_tzdata::AFRICA_KAMPALA;

        /// Raw, unparsed time zone data for Africa/Khartoum,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KHARTOUM: &[u8] = raw_tzdata::AFRICA_KHARTOUM;

        /// Raw, unparsed time zone data for Africa/Kigali,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KIGALI: &[u8] = raw_tzdata::AFRICA_KIGALI;

        /// Raw, unparsed time zone data for Africa/Kinshasa,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KINSHASA: &[u8] = raw_tzdata::AFRICA_KINSHASA;

        /// Raw, unparsed time zone data for Africa/Lagos,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LAGOS: &[u8] = raw_tzdata::AFRICA_LAGOS;

        /// Raw, unparsed time zone data for Africa/Libreville,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LIBREVILLE: &[u8] = raw_tzdata::AFRICA_LIBREVILLE;

        /// Raw, unparsed time zone data for Africa/Lome,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LOME: &[u8] = raw_tzdata::AFRICA_LOME;

        /// Raw, unparsed time zone data for Africa/Luanda,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LUANDA: &[u8] = raw_tzdata::AFRICA_LUANDA;

        /// Raw, unparsed time zone data for Africa/Lubumbashi,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LUBUMBASHI: &[u8] = raw_tzdata::AFRICA_LUBUMBASHI;

        /// Raw, unparsed time zone data for Africa/Lusaka,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LUSAKA: &[u8] = raw_tzdata::AFRICA_LUSAKA;

        /// Raw, unparsed time zone data for Africa/Malabo,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MALABO: &[u8] = raw_tzdata::AFRICA_MALABO;

        /// Raw, unparsed time zone data for Africa/Maputo,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MAPUTO: &[u8] = raw_tzdata::AFRICA_MAPUTO;

        /// Raw, unparsed time zone data for Africa/Maseru,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MASERU: &[u8] = raw_tzdata::AFRICA_MASERU;

        /// Raw, unparsed time zone data for Africa/Mbabane,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MBABANE: &[u8] = raw_tzdata::AFRICA_MBABANE;

        /// Raw, unparsed time zone data for Africa/Mogadishu,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MOGADISHU: &[u8] = raw_tzdata::AFRICA_MOGADISHU;

        /// Raw, unparsed time zone data for Africa/Monrovia,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MONROVIA: &[u8] = raw_tzdata::AFRICA_MONROVIA;

        /// Raw, unparsed time zone data for Africa/Nairobi,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NAIROBI: &[u8] = raw_tzdata::AFRICA_NAIROBI;

        /// Raw, unparsed time zone data for Africa/Ndjamena,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NDJAMENA: &[u8] = raw_tzdata::AFRICA_NDJAMENA;

        /// Raw, unparsed time zone data for Africa/Niamey,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NIAMEY: &[u8] = raw_tzdata::AFRICA_NIAMEY;

        /// Raw, unparsed time zone data for Africa/Nouakchott,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NOUAKCHOTT: &[u8] = raw_tzdata::AFRICA_NOUAKCHOTT;

        /// Raw, unparsed time zone data for Africa/Ouagadougou,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_OUAGADOUGOU: &[u8] = raw_tzdata::AFRICA_OUAGADOUGOU;

        /// Raw, unparsed time zone data for Africa/Porto-Novo,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PORTO_NOVO: &[u8] = raw_tzdata::AFRICA_PORTO_NOVO;

        /// Raw, unparsed time zone data for Africa/Sao_Tome,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SAO_TOME: &[u8] = raw_tzdata::AFRICA_SAO_TOME;

        /// Raw, unparsed time zone data for Africa/Timbuktu,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TIMBUKTU: &[u8] = raw_tzdata::AFRICA_TIMBUKTU;

        /// Raw, unparsed time zone data for Africa/Tripoli,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TRIPOLI: &[u8] = raw_tzdata::LIBYA;

        /// Raw, unparsed time zone data for Africa/Tunis,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TUNIS: &[u8] = raw_tzdata::AFRICA_TUNIS;

        /// Raw, unparsed time zone data for Africa/Windhoek,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_WINDHOEK: &[u8] = raw_tzdata::AFRICA_WINDHOEK;
    }

    /// america
    pub mod america {
        use super::*;

        /// Time zone data for America/Adak,
        pub const ADAK: TimeZoneRef<'static> = tzdata::AMERICA_ADAK;

        /// Time zone data for America/Anchorage,
        pub const ANCHORAGE: TimeZoneRef<'static> = tzdata::AMERICA_ANCHORAGE;

        /// Time zone data for America/Anguilla,
        pub const ANGUILLA: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;

        /// Time zone data for America/Antigua,
        pub const ANTIGUA: TimeZoneRef<'static> = tzdata::AMERICA_ANTIGUA;

        /// Time zone data for America/Araguaina,
        pub const ARAGUAINA: TimeZoneRef<'static> = tzdata::AMERICA_ARAGUAINA;

        /// Time zone data for America/Aruba,
        pub const ARUBA: TimeZoneRef<'static> = tzdata::AMERICA_ARUBA;

        /// Time zone data for America/Asuncion,
        pub const ASUNCION: TimeZoneRef<'static> = tzdata::AMERICA_ASUNCION;

        /// Time zone data for America/Atikokan,
        pub const ATIKOKAN: TimeZoneRef<'static> = tzdata::AMERICA_ATIKOKAN;

        /// Time zone data for America/Atka,
        pub const ATKA: TimeZoneRef<'static> = tzdata::AMERICA_ADAK;

        /// Time zone data for America/Bahia,
        pub const BAHIA: TimeZoneRef<'static> = tzdata::AMERICA_BAHIA;

        /// Time zone data for America/Bahia_Banderas,
        pub const BAHIA_BANDERAS: TimeZoneRef<'static> = tzdata::AMERICA_BAHIA_BANDERAS;

        /// Time zone data for America/Barbados,
        pub const BARBADOS: TimeZoneRef<'static> = tzdata::AMERICA_BARBADOS;

        /// Time zone data for America/Belem,
        pub const BELEM: TimeZoneRef<'static> = tzdata::AMERICA_BELEM;

        /// Time zone data for America/Belize,
        pub const BELIZE: TimeZoneRef<'static> = tzdata::AMERICA_BELIZE;

        /// Time zone data for America/Blanc-Sablon,
        pub const BLANC_SABLON: TimeZoneRef<'static> = tzdata::AMERICA_BLANC_SABLON;

        /// Time zone data for America/Boa_Vista,
        pub const BOA_VISTA: TimeZoneRef<'static> = tzdata::AMERICA_BOA_VISTA;

        /// Time zone data for America/Bogota,
        pub const BOGOTA: TimeZoneRef<'static> = tzdata::AMERICA_BOGOTA;

        /// Time zone data for America/Boise,
        pub const BOISE: TimeZoneRef<'static> = tzdata::AMERICA_BOISE;

        /// Time zone data for America/Buenos_Aires,
        pub const BUENOS_AIRES: TimeZoneRef<'static> = tzdata::AMERICA_BUENOS_AIRES;

        /// Time zone data for America/Cambridge_Bay,
        pub const CAMBRIDGE_BAY: TimeZoneRef<'static> = tzdata::AMERICA_CAMBRIDGE_BAY;

        /// Time zone data for America/Campo_Grande,
        pub const CAMPO_GRANDE: TimeZoneRef<'static> = tzdata::AMERICA_CAMPO_GRANDE;

        /// Time zone data for America/Cancun,
        pub const CANCUN: TimeZoneRef<'static> = tzdata::AMERICA_CANCUN;

        /// Time zone data for America/Caracas,
        pub const CARACAS: TimeZoneRef<'static> = tzdata::AMERICA_CARACAS;

        /// Time zone data for America/Catamarca,
        pub const CATAMARCA: TimeZoneRef<'static> = tzdata::AMERICA_CATAMARCA;

        /// Time zone data for America/Cayenne,
        pub const CAYENNE: TimeZoneRef<'static> = tzdata::AMERICA_CAYENNE;

        /// Time zone data for America/Cayman,
        pub const CAYMAN: TimeZoneRef<'static> = tzdata::AMERICA_CAYMAN;

        /// Time zone data for America/Chicago,
        pub const CHICAGO: TimeZoneRef<'static> = tzdata::AMERICA_CHICAGO;

        /// Time zone data for America/Chihuahua,
        pub const CHIHUAHUA: TimeZoneRef<'static> = tzdata::AMERICA_CHIHUAHUA;

        /// Time zone data for America/Coral_Harbour,
        pub const CORAL_HARBOUR: TimeZoneRef<'static> = tzdata::AMERICA_CORAL_HARBOUR;

        /// Time zone data for America/Cordoba,
        pub const CORDOBA: TimeZoneRef<'static> = tzdata::AMERICA_CORDOBA;

        /// Time zone data for America/Costa_Rica,
        pub const COSTA_RICA: TimeZoneRef<'static> = tzdata::AMERICA_COSTA_RICA;

        /// Time zone data for America/Creston,
        pub const CRESTON: TimeZoneRef<'static> = tzdata::AMERICA_CRESTON;

        /// Time zone data for America/Cuiaba,
        pub const CUIABA: TimeZoneRef<'static> = tzdata::AMERICA_CUIABA;

        /// Time zone data for America/Curacao,
        pub const CURACAO: TimeZoneRef<'static> = tzdata::AMERICA_CURACAO;

        /// Time zone data for America/Danmarkshavn,
        pub const DANMARKSHAVN: TimeZoneRef<'static> = tzdata::AMERICA_DANMARKSHAVN;

        /// Time zone data for America/Dawson,
        pub const DAWSON: TimeZoneRef<'static> = tzdata::AMERICA_DAWSON;

        /// Time zone data for America/Dawson_Creek,
        pub const DAWSON_CREEK: TimeZoneRef<'static> = tzdata::AMERICA_DAWSON_CREEK;

        /// Time zone data for America/Denver,
        pub const DENVER: TimeZoneRef<'static> = tzdata::NAVAJO;

        /// Time zone data for America/Detroit,
        pub const DETROIT: TimeZoneRef<'static> = tzdata::AMERICA_DETROIT;

        /// Time zone data for America/Dominica,
        pub const DOMINICA: TimeZoneRef<'static> = tzdata::AMERICA_DOMINICA;

        /// Time zone data for America/Edmonton,
        pub const EDMONTON: TimeZoneRef<'static> = tzdata::AMERICA_EDMONTON;

        /// Time zone data for America/Eirunepe,
        pub const EIRUNEPE: TimeZoneRef<'static> = tzdata::AMERICA_EIRUNEPE;

        /// Time zone data for America/El_Salvador,
        pub const EL_SALVADOR: TimeZoneRef<'static> = tzdata::AMERICA_EL_SALVADOR;

        /// Time zone data for America/Ensenada,
        pub const ENSENADA: TimeZoneRef<'static> = tzdata::AMERICA_ENSENADA;

        /// Time zone data for America/Fortaleza,
        pub const FORTALEZA: TimeZoneRef<'static> = tzdata::AMERICA_FORTALEZA;

        /// Time zone data for America/Fort_Nelson,
        pub const FORT_NELSON: TimeZoneRef<'static> = tzdata::AMERICA_FORT_NELSON;

        /// Time zone data for America/Fort_Wayne,
        pub const FORT_WAYNE: TimeZoneRef<'static> = tzdata::AMERICA_FORT_WAYNE;

        /// Time zone data for America/Glace_Bay,
        pub const GLACE_BAY: TimeZoneRef<'static> = tzdata::AMERICA_GLACE_BAY;

        /// Time zone data for America/Godthab,
        pub const GODTHAB: TimeZoneRef<'static> = tzdata::AMERICA_GODTHAB;

        /// Time zone data for America/Goose_Bay,
        pub const GOOSE_BAY: TimeZoneRef<'static> = tzdata::AMERICA_GOOSE_BAY;

        /// Time zone data for America/Grand_Turk,
        pub const GRAND_TURK: TimeZoneRef<'static> = tzdata::AMERICA_GRAND_TURK;

        /// Time zone data for America/Grenada,
        pub const GRENADA: TimeZoneRef<'static> = tzdata::AMERICA_GRENADA;

        /// Time zone data for America/Guadeloupe,
        pub const GUADELOUPE: TimeZoneRef<'static> = tzdata::AMERICA_GUADELOUPE;

        /// Time zone data for America/Guatemala,
        pub const GUATEMALA: TimeZoneRef<'static> = tzdata::AMERICA_GUATEMALA;

        /// Time zone data for America/Guayaquil,
        pub const GUAYAQUIL: TimeZoneRef<'static> = tzdata::AMERICA_GUAYAQUIL;

        /// Time zone data for America/Guyana,
        pub const GUYANA: TimeZoneRef<'static> = tzdata::AMERICA_GUYANA;

        /// Time zone data for America/Halifax,
        pub const HALIFAX: TimeZoneRef<'static> = tzdata::AMERICA_HALIFAX;

        /// Time zone data for America/Havana,
        pub const HAVANA: TimeZoneRef<'static> = tzdata::CUBA;

        /// Time zone data for America/Hermosillo,
        pub const HERMOSILLO: TimeZoneRef<'static> = tzdata::AMERICA_HERMOSILLO;

        /// Time zone data for America/Indianapolis,
        pub const INDIANAPOLIS: TimeZoneRef<'static> = tzdata::AMERICA_FORT_WAYNE;

        /// Time zone data for America/Inuvik,
        pub const INUVIK: TimeZoneRef<'static> = tzdata::AMERICA_INUVIK;

        /// Time zone data for America/Iqaluit,
        pub const IQALUIT: TimeZoneRef<'static> = tzdata::AMERICA_IQALUIT;

        /// Time zone data for America/Jamaica,
        pub const JAMAICA: TimeZoneRef<'static> = tzdata::JAMAICA;

        /// Time zone data for America/Jujuy,
        pub const JUJUY: TimeZoneRef<'static> = tzdata::AMERICA_JUJUY;

        /// Time zone data for America/Juneau,
        pub const JUNEAU: TimeZoneRef<'static> = tzdata::AMERICA_JUNEAU;

        /// Time zone data for America/Knox_IN,
        pub const KNOX_IN: TimeZoneRef<'static> = tzdata::AMERICA_KNOX_IN;

        /// Time zone data for America/Kralendijk,
        pub const KRALENDIJK: TimeZoneRef<'static> = tzdata::AMERICA_CURACAO;

        /// Time zone data for America/La_Paz,
        pub const LA_PAZ: TimeZoneRef<'static> = tzdata::AMERICA_LA_PAZ;

        /// Time zone data for America/Lima,
        pub const LIMA: TimeZoneRef<'static> = tzdata::AMERICA_LIMA;

        /// Time zone data for America/Los_Angeles,
        pub const LOS_ANGELES: TimeZoneRef<'static> = tzdata::AMERICA_LOS_ANGELES;

        /// Time zone data for America/Louisville,
        pub const LOUISVILLE: TimeZoneRef<'static> = tzdata::AMERICA_LOUISVILLE;

        /// Time zone data for America/Lower_Princes,
        pub const LOWER_PRINCES: TimeZoneRef<'static> = tzdata::AMERICA_CURACAO;

        /// Time zone data for America/Maceio,
        pub const MACEIO: TimeZoneRef<'static> = tzdata::AMERICA_MACEIO;

        /// Time zone data for America/Managua,
        pub const MANAGUA: TimeZoneRef<'static> = tzdata::AMERICA_MANAGUA;

        /// Time zone data for America/Manaus,
        pub const MANAUS: TimeZoneRef<'static> = tzdata::AMERICA_MANAUS;

        /// Time zone data for America/Marigot,
        pub const MARIGOT: TimeZoneRef<'static> = tzdata::AMERICA_MARIGOT;

        /// Time zone data for America/Martinique,
        pub const MARTINIQUE: TimeZoneRef<'static> = tzdata::AMERICA_MARTINIQUE;

        /// Time zone data for America/Matamoros,
        pub const MATAMOROS: TimeZoneRef<'static> = tzdata::AMERICA_MATAMOROS;

        /// Time zone data for America/Mazatlan,
        pub const MAZATLAN: TimeZoneRef<'static> = tzdata::AMERICA_MAZATLAN;

        /// Time zone data for America/Mendoza,
        pub const MENDOZA: TimeZoneRef<'static> = tzdata::AMERICA_MENDOZA;

        /// Time zone data for America/Menominee,
        pub const MENOMINEE: TimeZoneRef<'static> = tzdata::AMERICA_MENOMINEE;

        /// Time zone data for America/Merida,
        pub const MERIDA: TimeZoneRef<'static> = tzdata::AMERICA_MERIDA;

        /// Time zone data for America/Metlakatla,
        pub const METLAKATLA: TimeZoneRef<'static> = tzdata::AMERICA_METLAKATLA;

        /// Time zone data for America/Mexico_City,
        pub const MEXICO_CITY: TimeZoneRef<'static> = tzdata::AMERICA_MEXICO_CITY;

        /// Time zone data for America/Miquelon,
        pub const MIQUELON: TimeZoneRef<'static> = tzdata::AMERICA_MIQUELON;

        /// Time zone data for America/Moncton,
        pub const MONCTON: TimeZoneRef<'static> = tzdata::AMERICA_MONCTON;

        /// Time zone data for America/Monterrey,
        pub const MONTERREY: TimeZoneRef<'static> = tzdata::AMERICA_MONTERREY;

        /// Time zone data for America/Montevideo,
        pub const MONTEVIDEO: TimeZoneRef<'static> = tzdata::AMERICA_MONTEVIDEO;

        /// Time zone data for America/Montreal,
        pub const MONTREAL: TimeZoneRef<'static> = tzdata::AMERICA_MONTREAL;

        /// Time zone data for America/Montserrat,
        pub const MONTSERRAT: TimeZoneRef<'static> = tzdata::AMERICA_MONTSERRAT;

        /// Time zone data for America/Nassau,
        pub const NASSAU: TimeZoneRef<'static> = tzdata::AMERICA_NASSAU;

        /// Time zone data for America/New_York,
        pub const NEW_YORK: TimeZoneRef<'static> = tzdata::AMERICA_NEW_YORK;

        /// Time zone data for America/Nipigon,
        pub const NIPIGON: TimeZoneRef<'static> = tzdata::AMERICA_NIPIGON;

        /// Time zone data for America/Nome,
        pub const NOME: TimeZoneRef<'static> = tzdata::AMERICA_NOME;

        /// Time zone data for America/Noronha,
        pub const NORONHA: TimeZoneRef<'static> = tzdata::AMERICA_NORONHA;

        /// Time zone data for America/Nuuk,
        pub const NUUK: TimeZoneRef<'static> = tzdata::AMERICA_GODTHAB;

        /// Time zone data for America/Ojinaga,
        pub const OJINAGA: TimeZoneRef<'static> = tzdata::AMERICA_OJINAGA;

        /// Time zone data for America/Panama,
        pub const PANAMA: TimeZoneRef<'static> = tzdata::AMERICA_PANAMA;

        /// Time zone data for America/Pangnirtung,
        pub const PANGNIRTUNG: TimeZoneRef<'static> = tzdata::AMERICA_PANGNIRTUNG;

        /// Time zone data for America/Paramaribo,
        pub const PARAMARIBO: TimeZoneRef<'static> = tzdata::AMERICA_PARAMARIBO;

        /// Time zone data for America/Phoenix,
        pub const PHOENIX: TimeZoneRef<'static> = tzdata::AMERICA_PHOENIX;

        /// Time zone data for America/Porto_Acre,
        pub const PORTO_ACRE: TimeZoneRef<'static> = tzdata::AMERICA_PORTO_ACRE;

        /// Time zone data for America/Porto_Velho,
        pub const PORTO_VELHO: TimeZoneRef<'static> = tzdata::AMERICA_PORTO_VELHO;

        /// Time zone data for America/Port-au-Prince,
        pub const PORT_AU_PRINCE: TimeZoneRef<'static> = tzdata::AMERICA_PORT_AU_PRINCE;

        /// Time zone data for America/Port_of_Spain,
        pub const PORT_OF_SPAIN: TimeZoneRef<'static> = tzdata::AMERICA_MARIGOT;

        /// Time zone data for America/Puerto_Rico,
        pub const PUERTO_RICO: TimeZoneRef<'static> = tzdata::AMERICA_PUERTO_RICO;

        /// Time zone data for America/Punta_Arenas,
        pub const PUNTA_ARENAS: TimeZoneRef<'static> = tzdata::AMERICA_PUNTA_ARENAS;

        /// Time zone data for America/Rainy_River,
        pub const RAINY_RIVER: TimeZoneRef<'static> = tzdata::AMERICA_RAINY_RIVER;

        /// Time zone data for America/Rankin_Inlet,
        pub const RANKIN_INLET: TimeZoneRef<'static> = tzdata::AMERICA_RANKIN_INLET;

        /// Time zone data for America/Recife,
        pub const RECIFE: TimeZoneRef<'static> = tzdata::AMERICA_RECIFE;

        /// Time zone data for America/Regina,
        pub const REGINA: TimeZoneRef<'static> = tzdata::AMERICA_REGINA;

        /// Time zone data for America/Resolute,
        pub const RESOLUTE: TimeZoneRef<'static> = tzdata::AMERICA_RESOLUTE;

        /// Time zone data for America/Rio_Branco,
        pub const RIO_BRANCO: TimeZoneRef<'static> = tzdata::AMERICA_PORTO_ACRE;

        /// Time zone data for America/Rosario,
        pub const ROSARIO: TimeZoneRef<'static> = tzdata::AMERICA_ROSARIO;

        /// Time zone data for America/Santarem,
        pub const SANTAREM: TimeZoneRef<'static> = tzdata::AMERICA_SANTAREM;

        /// Time zone data for America/Santa_Isabel,
        pub const SANTA_ISABEL: TimeZoneRef<'static> = tzdata::AMERICA_SANTA_ISABEL;

        /// Time zone data for America/Santiago,
        pub const SANTIAGO: TimeZoneRef<'static> = tzdata::AMERICA_SANTIAGO;

        /// Time zone data for America/Santo_Domingo,
        pub const SANTO_DOMINGO: TimeZoneRef<'static> = tzdata::AMERICA_SANTO_DOMINGO;

        /// Time zone data for America/Sao_Paulo,
        pub const SAO_PAULO: TimeZoneRef<'static> = tzdata::AMERICA_SAO_PAULO;

        /// Time zone data for America/Scoresbysund,
        pub const SCORESBYSUND: TimeZoneRef<'static> = tzdata::AMERICA_SCORESBYSUND;

        /// Time zone data for America/Shiprock,
        pub const SHIPROCK: TimeZoneRef<'static> = tzdata::NAVAJO;

        /// Time zone data for America/Sitka,
        pub const SITKA: TimeZoneRef<'static> = tzdata::AMERICA_SITKA;

        /// Time zone data for America/St_Barthelemy,
        pub const ST_BARTHELEMY: TimeZoneRef<'static> = tzdata::AMERICA_MARIGOT;

        /// Time zone data for America/St_Johns,
        pub const ST_JOHNS: TimeZoneRef<'static> = tzdata::AMERICA_ST_JOHNS;

        /// Time zone data for America/St_Kitts,
        pub const ST_KITTS: TimeZoneRef<'static> = tzdata::AMERICA_ST_KITTS;

        /// Time zone data for America/St_Lucia,
        pub const ST_LUCIA: TimeZoneRef<'static> = tzdata::AMERICA_ST_LUCIA;

        /// Time zone data for America/St_Thomas,
        pub const ST_THOMAS: TimeZoneRef<'static> = tzdata::AMERICA_ST_THOMAS;

        /// Time zone data for America/St_Vincent,
        pub const ST_VINCENT: TimeZoneRef<'static> = tzdata::AMERICA_ST_VINCENT;

        /// Time zone data for America/Swift_Current,
        pub const SWIFT_CURRENT: TimeZoneRef<'static> = tzdata::AMERICA_SWIFT_CURRENT;

        /// Time zone data for America/Tegucigalpa,
        pub const TEGUCIGALPA: TimeZoneRef<'static> = tzdata::AMERICA_TEGUCIGALPA;

        /// Time zone data for America/Thule,
        pub const THULE: TimeZoneRef<'static> = tzdata::AMERICA_THULE;

        /// Time zone data for America/Thunder_Bay,
        pub const THUNDER_BAY: TimeZoneRef<'static> = tzdata::AMERICA_THUNDER_BAY;

        /// Time zone data for America/Tijuana,
        pub const TIJUANA: TimeZoneRef<'static> = tzdata::AMERICA_SANTA_ISABEL;

        /// Time zone data for America/Toronto,
        pub const TORONTO: TimeZoneRef<'static> = tzdata::AMERICA_TORONTO;

        /// Time zone data for America/Tortola,
        pub const TORTOLA: TimeZoneRef<'static> = tzdata::AMERICA_TORTOLA;

        /// Time zone data for America/Vancouver,
        pub const VANCOUVER: TimeZoneRef<'static> = tzdata::AMERICA_VANCOUVER;

        /// Time zone data for America/Virgin,
        pub const VIRGIN: TimeZoneRef<'static> = tzdata::AMERICA_ST_THOMAS;

        /// Time zone data for America/Whitehorse,
        pub const WHITEHORSE: TimeZoneRef<'static> = tzdata::AMERICA_WHITEHORSE;

        /// Time zone data for America/Winnipeg,
        pub const WINNIPEG: TimeZoneRef<'static> = tzdata::AMERICA_WINNIPEG;

        /// Time zone data for America/Yakutat,
        pub const YAKUTAT: TimeZoneRef<'static> = tzdata::AMERICA_YAKUTAT;

        /// Time zone data for America/Yellowknife,
        pub const YELLOWKNIFE: TimeZoneRef<'static> = tzdata::AMERICA_YELLOWKNIFE;

        /// Raw, unparsed time zone data for America/Adak,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ADAK: &[u8] = raw_tzdata::AMERICA_ADAK;

        /// Raw, unparsed time zone data for America/Anchorage,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ANCHORAGE: &[u8] = raw_tzdata::AMERICA_ANCHORAGE;

        /// Raw, unparsed time zone data for America/Anguilla,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ANGUILLA: &[u8] = raw_tzdata::AMERICA_ANGUILLA;

        /// Raw, unparsed time zone data for America/Antigua,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ANTIGUA: &[u8] = raw_tzdata::AMERICA_ANTIGUA;

        /// Raw, unparsed time zone data for America/Araguaina,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ARAGUAINA: &[u8] = raw_tzdata::AMERICA_ARAGUAINA;

        /// Raw, unparsed time zone data for America/Aruba,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ARUBA: &[u8] = raw_tzdata::AMERICA_ARUBA;

        /// Raw, unparsed time zone data for America/Asuncion,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ASUNCION: &[u8] = raw_tzdata::AMERICA_ASUNCION;

        /// Raw, unparsed time zone data for America/Atikokan,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ATIKOKAN: &[u8] = raw_tzdata::AMERICA_ATIKOKAN;

        /// Raw, unparsed time zone data for America/Atka,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ATKA: &[u8] = raw_tzdata::AMERICA_ADAK;

        /// Raw, unparsed time zone data for America/Bahia,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BAHIA: &[u8] = raw_tzdata::AMERICA_BAHIA;

        /// Raw, unparsed time zone data for America/Bahia_Banderas,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BAHIA_BANDERAS: &[u8] = raw_tzdata::AMERICA_BAHIA_BANDERAS;

        /// Raw, unparsed time zone data for America/Barbados,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BARBADOS: &[u8] = raw_tzdata::AMERICA_BARBADOS;

        /// Raw, unparsed time zone data for America/Belem,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BELEM: &[u8] = raw_tzdata::AMERICA_BELEM;

        /// Raw, unparsed time zone data for America/Belize,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BELIZE: &[u8] = raw_tzdata::AMERICA_BELIZE;

        /// Raw, unparsed time zone data for America/Blanc-Sablon,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BLANC_SABLON: &[u8] = raw_tzdata::AMERICA_BLANC_SABLON;

        /// Raw, unparsed time zone data for America/Boa_Vista,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BOA_VISTA: &[u8] = raw_tzdata::AMERICA_BOA_VISTA;

        /// Raw, unparsed time zone data for America/Bogota,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BOGOTA: &[u8] = raw_tzdata::AMERICA_BOGOTA;

        /// Raw, unparsed time zone data for America/Boise,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BOISE: &[u8] = raw_tzdata::AMERICA_BOISE;

        /// Raw, unparsed time zone data for America/Buenos_Aires,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BUENOS_AIRES: &[u8] = raw_tzdata::AMERICA_BUENOS_AIRES;

        /// Raw, unparsed time zone data for America/Cambridge_Bay,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CAMBRIDGE_BAY: &[u8] = raw_tzdata::AMERICA_CAMBRIDGE_BAY;

        /// Raw, unparsed time zone data for America/Campo_Grande,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CAMPO_GRANDE: &[u8] = raw_tzdata::AMERICA_CAMPO_GRANDE;

        /// Raw, unparsed time zone data for America/Cancun,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CANCUN: &[u8] = raw_tzdata::AMERICA_CANCUN;

        /// Raw, unparsed time zone data for America/Caracas,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CARACAS: &[u8] = raw_tzdata::AMERICA_CARACAS;

        /// Raw, unparsed time zone data for America/Catamarca,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CATAMARCA: &[u8] = raw_tzdata::AMERICA_CATAMARCA;

        /// Raw, unparsed time zone data for America/Cayenne,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CAYENNE: &[u8] = raw_tzdata::AMERICA_CAYENNE;

        /// Raw, unparsed time zone data for America/Cayman,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CAYMAN: &[u8] = raw_tzdata::AMERICA_CAYMAN;

        /// Raw, unparsed time zone data for America/Chicago,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CHICAGO: &[u8] = raw_tzdata::AMERICA_CHICAGO;

        /// Raw, unparsed time zone data for America/Chihuahua,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CHIHUAHUA: &[u8] = raw_tzdata::AMERICA_CHIHUAHUA;

        /// Raw, unparsed time zone data for America/Coral_Harbour,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CORAL_HARBOUR: &[u8] = raw_tzdata::AMERICA_CORAL_HARBOUR;

        /// Raw, unparsed time zone data for America/Cordoba,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CORDOBA: &[u8] = raw_tzdata::AMERICA_CORDOBA;

        /// Raw, unparsed time zone data for America/Costa_Rica,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_COSTA_RICA: &[u8] = raw_tzdata::AMERICA_COSTA_RICA;

        /// Raw, unparsed time zone data for America/Creston,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CRESTON: &[u8] = raw_tzdata::AMERICA_CRESTON;

        /// Raw, unparsed time zone data for America/Cuiaba,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CUIABA: &[u8] = raw_tzdata::AMERICA_CUIABA;

        /// Raw, unparsed time zone data for America/Curacao,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CURACAO: &[u8] = raw_tzdata::AMERICA_CURACAO;

        /// Raw, unparsed time zone data for America/Danmarkshavn,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DANMARKSHAVN: &[u8] = raw_tzdata::AMERICA_DANMARKSHAVN;

        /// Raw, unparsed time zone data for America/Dawson,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DAWSON: &[u8] = raw_tzdata::AMERICA_DAWSON;

        /// Raw, unparsed time zone data for America/Dawson_Creek,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DAWSON_CREEK: &[u8] = raw_tzdata::AMERICA_DAWSON_CREEK;

        /// Raw, unparsed time zone data for America/Denver,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DENVER: &[u8] = raw_tzdata::NAVAJO;

        /// Raw, unparsed time zone data for America/Detroit,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DETROIT: &[u8] = raw_tzdata::AMERICA_DETROIT;

        /// Raw, unparsed time zone data for America/Dominica,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DOMINICA: &[u8] = raw_tzdata::AMERICA_DOMINICA;

        /// Raw, unparsed time zone data for America/Edmonton,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_EDMONTON: &[u8] = raw_tzdata::AMERICA_EDMONTON;

        /// Raw, unparsed time zone data for America/Eirunepe,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_EIRUNEPE: &[u8] = raw_tzdata::AMERICA_EIRUNEPE;

        /// Raw, unparsed time zone data for America/El_Salvador,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_EL_SALVADOR: &[u8] = raw_tzdata::AMERICA_EL_SALVADOR;

        /// Raw, unparsed time zone data for America/Ensenada,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ENSENADA: &[u8] = raw_tzdata::AMERICA_ENSENADA;

        /// Raw, unparsed time zone data for America/Fortaleza,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_FORTALEZA: &[u8] = raw_tzdata::AMERICA_FORTALEZA;

        /// Raw, unparsed time zone data for America/Fort_Nelson,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_FORT_NELSON: &[u8] = raw_tzdata::AMERICA_FORT_NELSON;

        /// Raw, unparsed time zone data for America/Fort_Wayne,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_FORT_WAYNE: &[u8] = raw_tzdata::AMERICA_FORT_WAYNE;

        /// Raw, unparsed time zone data for America/Glace_Bay,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GLACE_BAY: &[u8] = raw_tzdata::AMERICA_GLACE_BAY;

        /// Raw, unparsed time zone data for America/Godthab,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GODTHAB: &[u8] = raw_tzdata::AMERICA_GODTHAB;

        /// Raw, unparsed time zone data for America/Goose_Bay,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GOOSE_BAY: &[u8] = raw_tzdata::AMERICA_GOOSE_BAY;

        /// Raw, unparsed time zone data for America/Grand_Turk,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GRAND_TURK: &[u8] = raw_tzdata::AMERICA_GRAND_TURK;

        /// Raw, unparsed time zone data for America/Grenada,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GRENADA: &[u8] = raw_tzdata::AMERICA_GRENADA;

        /// Raw, unparsed time zone data for America/Guadeloupe,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GUADELOUPE: &[u8] = raw_tzdata::AMERICA_GUADELOUPE;

        /// Raw, unparsed time zone data for America/Guatemala,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GUATEMALA: &[u8] = raw_tzdata::AMERICA_GUATEMALA;

        /// Raw, unparsed time zone data for America/Guayaquil,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GUAYAQUIL: &[u8] = raw_tzdata::AMERICA_GUAYAQUIL;

        /// Raw, unparsed time zone data for America/Guyana,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GUYANA: &[u8] = raw_tzdata::AMERICA_GUYANA;

        /// Raw, unparsed time zone data for America/Halifax,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_HALIFAX: &[u8] = raw_tzdata::AMERICA_HALIFAX;

        /// Raw, unparsed time zone data for America/Havana,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_HAVANA: &[u8] = raw_tzdata::CUBA;

        /// Raw, unparsed time zone data for America/Hermosillo,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_HERMOSILLO: &[u8] = raw_tzdata::AMERICA_HERMOSILLO;

        /// Raw, unparsed time zone data for America/Indianapolis,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_INDIANAPOLIS: &[u8] = raw_tzdata::AMERICA_FORT_WAYNE;

        /// Raw, unparsed time zone data for America/Inuvik,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_INUVIK: &[u8] = raw_tzdata::AMERICA_INUVIK;

        /// Raw, unparsed time zone data for America/Iqaluit,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_IQALUIT: &[u8] = raw_tzdata::AMERICA_IQALUIT;

        /// Raw, unparsed time zone data for America/Jamaica,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_JAMAICA: &[u8] = raw_tzdata::JAMAICA;

        /// Raw, unparsed time zone data for America/Jujuy,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_JUJUY: &[u8] = raw_tzdata::AMERICA_JUJUY;

        /// Raw, unparsed time zone data for America/Juneau,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_JUNEAU: &[u8] = raw_tzdata::AMERICA_JUNEAU;

        /// Raw, unparsed time zone data for America/Knox_IN,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KNOX_IN: &[u8] = raw_tzdata::AMERICA_KNOX_IN;

        /// Raw, unparsed time zone data for America/Kralendijk,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KRALENDIJK: &[u8] = raw_tzdata::AMERICA_CURACAO;

        /// Raw, unparsed time zone data for America/La_Paz,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LA_PAZ: &[u8] = raw_tzdata::AMERICA_LA_PAZ;

        /// Raw, unparsed time zone data for America/Lima,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LIMA: &[u8] = raw_tzdata::AMERICA_LIMA;

        /// Raw, unparsed time zone data for America/Los_Angeles,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LOS_ANGELES: &[u8] = raw_tzdata::AMERICA_LOS_ANGELES;

        /// Raw, unparsed time zone data for America/Louisville,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LOUISVILLE: &[u8] = raw_tzdata::AMERICA_LOUISVILLE;

        /// Raw, unparsed time zone data for America/Lower_Princes,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LOWER_PRINCES: &[u8] = raw_tzdata::AMERICA_CURACAO;

        /// Raw, unparsed time zone data for America/Maceio,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MACEIO: &[u8] = raw_tzdata::AMERICA_MACEIO;

        /// Raw, unparsed time zone data for America/Managua,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MANAGUA: &[u8] = raw_tzdata::AMERICA_MANAGUA;

        /// Raw, unparsed time zone data for America/Manaus,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MANAUS: &[u8] = raw_tzdata::AMERICA_MANAUS;

        /// Raw, unparsed time zone data for America/Marigot,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MARIGOT: &[u8] = raw_tzdata::AMERICA_MARIGOT;

        /// Raw, unparsed time zone data for America/Martinique,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MARTINIQUE: &[u8] = raw_tzdata::AMERICA_MARTINIQUE;

        /// Raw, unparsed time zone data for America/Matamoros,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MATAMOROS: &[u8] = raw_tzdata::AMERICA_MATAMOROS;

        /// Raw, unparsed time zone data for America/Mazatlan,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MAZATLAN: &[u8] = raw_tzdata::AMERICA_MAZATLAN;

        /// Raw, unparsed time zone data for America/Mendoza,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MENDOZA: &[u8] = raw_tzdata::AMERICA_MENDOZA;

        /// Raw, unparsed time zone data for America/Menominee,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MENOMINEE: &[u8] = raw_tzdata::AMERICA_MENOMINEE;

        /// Raw, unparsed time zone data for America/Merida,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MERIDA: &[u8] = raw_tzdata::AMERICA_MERIDA;

        /// Raw, unparsed time zone data for America/Metlakatla,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_METLAKATLA: &[u8] = raw_tzdata::AMERICA_METLAKATLA;

        /// Raw, unparsed time zone data for America/Mexico_City,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MEXICO_CITY: &[u8] = raw_tzdata::AMERICA_MEXICO_CITY;

        /// Raw, unparsed time zone data for America/Miquelon,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MIQUELON: &[u8] = raw_tzdata::AMERICA_MIQUELON;

        /// Raw, unparsed time zone data for America/Moncton,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MONCTON: &[u8] = raw_tzdata::AMERICA_MONCTON;

        /// Raw, unparsed time zone data for America/Monterrey,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MONTERREY: &[u8] = raw_tzdata::AMERICA_MONTERREY;

        /// Raw, unparsed time zone data for America/Montevideo,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MONTEVIDEO: &[u8] = raw_tzdata::AMERICA_MONTEVIDEO;

        /// Raw, unparsed time zone data for America/Montreal,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MONTREAL: &[u8] = raw_tzdata::AMERICA_MONTREAL;

        /// Raw, unparsed time zone data for America/Montserrat,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MONTSERRAT: &[u8] = raw_tzdata::AMERICA_MONTSERRAT;

        /// Raw, unparsed time zone data for America/Nassau,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NASSAU: &[u8] = raw_tzdata::AMERICA_NASSAU;

        /// Raw, unparsed time zone data for America/New_York,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NEW_YORK: &[u8] = raw_tzdata::AMERICA_NEW_YORK;

        /// Raw, unparsed time zone data for America/Nipigon,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NIPIGON: &[u8] = raw_tzdata::AMERICA_NIPIGON;

        /// Raw, unparsed time zone data for America/Nome,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NOME: &[u8] = raw_tzdata::AMERICA_NOME;

        /// Raw, unparsed time zone data for America/Noronha,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NORONHA: &[u8] = raw_tzdata::AMERICA_NORONHA;

        /// Raw, unparsed time zone data for America/Nuuk,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NUUK: &[u8] = raw_tzdata::AMERICA_GODTHAB;

        /// Raw, unparsed time zone data for America/Ojinaga,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_OJINAGA: &[u8] = raw_tzdata::AMERICA_OJINAGA;

        /// Raw, unparsed time zone data for America/Panama,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PANAMA: &[u8] = raw_tzdata::AMERICA_PANAMA;

        /// Raw, unparsed time zone data for America/Pangnirtung,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PANGNIRTUNG: &[u8] = raw_tzdata::AMERICA_PANGNIRTUNG;

        /// Raw, unparsed time zone data for America/Paramaribo,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PARAMARIBO: &[u8] = raw_tzdata::AMERICA_PARAMARIBO;

        /// Raw, unparsed time zone data for America/Phoenix,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PHOENIX: &[u8] = raw_tzdata::AMERICA_PHOENIX;

        /// Raw, unparsed time zone data for America/Porto_Acre,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PORTO_ACRE: &[u8] = raw_tzdata::AMERICA_PORTO_ACRE;

        /// Raw, unparsed time zone data for America/Porto_Velho,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PORTO_VELHO: &[u8] = raw_tzdata::AMERICA_PORTO_VELHO;

        /// Raw, unparsed time zone data for America/Port-au-Prince,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PORT_AU_PRINCE: &[u8] = raw_tzdata::AMERICA_PORT_AU_PRINCE;

        /// Raw, unparsed time zone data for America/Port_of_Spain,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PORT_OF_SPAIN: &[u8] = raw_tzdata::AMERICA_MARIGOT;

        /// Raw, unparsed time zone data for America/Puerto_Rico,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PUERTO_RICO: &[u8] = raw_tzdata::AMERICA_PUERTO_RICO;

        /// Raw, unparsed time zone data for America/Punta_Arenas,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PUNTA_ARENAS: &[u8] = raw_tzdata::AMERICA_PUNTA_ARENAS;

        /// Raw, unparsed time zone data for America/Rainy_River,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_RAINY_RIVER: &[u8] = raw_tzdata::AMERICA_RAINY_RIVER;

        /// Raw, unparsed time zone data for America/Rankin_Inlet,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_RANKIN_INLET: &[u8] = raw_tzdata::AMERICA_RANKIN_INLET;

        /// Raw, unparsed time zone data for America/Recife,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_RECIFE: &[u8] = raw_tzdata::AMERICA_RECIFE;

        /// Raw, unparsed time zone data for America/Regina,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_REGINA: &[u8] = raw_tzdata::AMERICA_REGINA;

        /// Raw, unparsed time zone data for America/Resolute,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_RESOLUTE: &[u8] = raw_tzdata::AMERICA_RESOLUTE;

        /// Raw, unparsed time zone data for America/Rio_Branco,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_RIO_BRANCO: &[u8] = raw_tzdata::AMERICA_PORTO_ACRE;

        /// Raw, unparsed time zone data for America/Rosario,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ROSARIO: &[u8] = raw_tzdata::AMERICA_ROSARIO;

        /// Raw, unparsed time zone data for America/Santarem,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SANTAREM: &[u8] = raw_tzdata::AMERICA_SANTAREM;

        /// Raw, unparsed time zone data for America/Santa_Isabel,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SANTA_ISABEL: &[u8] = raw_tzdata::AMERICA_SANTA_ISABEL;

        /// Raw, unparsed time zone data for America/Santiago,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SANTIAGO: &[u8] = raw_tzdata::AMERICA_SANTIAGO;

        /// Raw, unparsed time zone data for America/Santo_Domingo,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SANTO_DOMINGO: &[u8] = raw_tzdata::AMERICA_SANTO_DOMINGO;

        /// Raw, unparsed time zone data for America/Sao_Paulo,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SAO_PAULO: &[u8] = raw_tzdata::AMERICA_SAO_PAULO;

        /// Raw, unparsed time zone data for America/Scoresbysund,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SCORESBYSUND: &[u8] = raw_tzdata::AMERICA_SCORESBYSUND;

        /// Raw, unparsed time zone data for America/Shiprock,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SHIPROCK: &[u8] = raw_tzdata::NAVAJO;

        /// Raw, unparsed time zone data for America/Sitka,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SITKA: &[u8] = raw_tzdata::AMERICA_SITKA;

        /// Raw, unparsed time zone data for America/St_Barthelemy,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ST_BARTHELEMY: &[u8] = raw_tzdata::AMERICA_MARIGOT;

        /// Raw, unparsed time zone data for America/St_Johns,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ST_JOHNS: &[u8] = raw_tzdata::AMERICA_ST_JOHNS;

        /// Raw, unparsed time zone data for America/St_Kitts,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ST_KITTS: &[u8] = raw_tzdata::AMERICA_ST_KITTS;

        /// Raw, unparsed time zone data for America/St_Lucia,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ST_LUCIA: &[u8] = raw_tzdata::AMERICA_ST_LUCIA;

        /// Raw, unparsed time zone data for America/St_Thomas,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ST_THOMAS: &[u8] = raw_tzdata::AMERICA_ST_THOMAS;

        /// Raw, unparsed time zone data for America/St_Vincent,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ST_VINCENT: &[u8] = raw_tzdata::AMERICA_ST_VINCENT;

        /// Raw, unparsed time zone data for America/Swift_Current,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SWIFT_CURRENT: &[u8] = raw_tzdata::AMERICA_SWIFT_CURRENT;

        /// Raw, unparsed time zone data for America/Tegucigalpa,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TEGUCIGALPA: &[u8] = raw_tzdata::AMERICA_TEGUCIGALPA;

        /// Raw, unparsed time zone data for America/Thule,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_THULE: &[u8] = raw_tzdata::AMERICA_THULE;

        /// Raw, unparsed time zone data for America/Thunder_Bay,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_THUNDER_BAY: &[u8] = raw_tzdata::AMERICA_THUNDER_BAY;

        /// Raw, unparsed time zone data for America/Tijuana,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TIJUANA: &[u8] = raw_tzdata::AMERICA_SANTA_ISABEL;

        /// Raw, unparsed time zone data for America/Toronto,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TORONTO: &[u8] = raw_tzdata::AMERICA_TORONTO;

        /// Raw, unparsed time zone data for America/Tortola,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TORTOLA: &[u8] = raw_tzdata::AMERICA_TORTOLA;

        /// Raw, unparsed time zone data for America/Vancouver,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_VANCOUVER: &[u8] = raw_tzdata::AMERICA_VANCOUVER;

        /// Raw, unparsed time zone data for America/Virgin,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_VIRGIN: &[u8] = raw_tzdata::AMERICA_ST_THOMAS;

        /// Raw, unparsed time zone data for America/Whitehorse,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_WHITEHORSE: &[u8] = raw_tzdata::AMERICA_WHITEHORSE;

        /// Raw, unparsed time zone data for America/Winnipeg,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_WINNIPEG: &[u8] = raw_tzdata::AMERICA_WINNIPEG;

        /// Raw, unparsed time zone data for America/Yakutat,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_YAKUTAT: &[u8] = raw_tzdata::AMERICA_YAKUTAT;

        /// Raw, unparsed time zone data for America/Yellowknife,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_YELLOWKNIFE: &[u8] = raw_tzdata::AMERICA_YELLOWKNIFE;
    }

    /// antarctica
    pub mod antarctica {
        use super::*;

        /// Time zone data for Antarctica/Casey,
        pub const CASEY: TimeZoneRef<'static> = tzdata::ANTARCTICA_CASEY;

        /// Time zone data for Antarctica/Davis,
        pub const DAVIS: TimeZoneRef<'static> = tzdata::ANTARCTICA_DAVIS;

        /// Time zone data for Antarctica/DumontDUrville,
        pub const DUMONT_D_URVILLE: TimeZoneRef<'static> = tzdata::ANTARCTICA_DUMONT_D_URVILLE;

        /// Time zone data for Antarctica/Macquarie,
        pub const MACQUARIE: TimeZoneRef<'static> = tzdata::ANTARCTICA_MACQUARIE;

        /// Time zone data for Antarctica/Mawson,
        pub const MAWSON: TimeZoneRef<'static> = tzdata::ANTARCTICA_MAWSON;

        /// Time zone data for Antarctica/McMurdo,
        pub const MC_MURDO: TimeZoneRef<'static> = tzdata::ANTARCTICA_MC_MURDO;

        /// Time zone data for Antarctica/Palmer,
        pub const PALMER: TimeZoneRef<'static> = tzdata::ANTARCTICA_PALMER;

        /// Time zone data for Antarctica/Rothera,
        pub const ROTHERA: TimeZoneRef<'static> = tzdata::ANTARCTICA_ROTHERA;

        /// Time zone data for Antarctica/South_Pole,
        pub const SOUTH_POLE: TimeZoneRef<'static> = tzdata::ANTARCTICA_MC_MURDO;

        /// Time zone data for Antarctica/Syowa,
        pub const SYOWA: TimeZoneRef<'static> = tzdata::ANTARCTICA_SYOWA;

        /// Time zone data for Antarctica/Troll,
        pub const TROLL: TimeZoneRef<'static> = tzdata::ANTARCTICA_TROLL;

        /// Time zone data for Antarctica/Vostok,
        pub const VOSTOK: TimeZoneRef<'static> = tzdata::ANTARCTICA_VOSTOK;

        /// Raw, unparsed time zone data for Antarctica/Casey,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CASEY: &[u8] = raw_tzdata::ANTARCTICA_CASEY;

        /// Raw, unparsed time zone data for Antarctica/Davis,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DAVIS: &[u8] = raw_tzdata::ANTARCTICA_DAVIS;

        /// Raw, unparsed time zone data for Antarctica/DumontDUrville,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DUMONT_D_URVILLE: &[u8] = raw_tzdata::ANTARCTICA_DUMONT_D_URVILLE;

        /// Raw, unparsed time zone data for Antarctica/Macquarie,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MACQUARIE: &[u8] = raw_tzdata::ANTARCTICA_MACQUARIE;

        /// Raw, unparsed time zone data for Antarctica/Mawson,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MAWSON: &[u8] = raw_tzdata::ANTARCTICA_MAWSON;

        /// Raw, unparsed time zone data for Antarctica/McMurdo,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MC_MURDO: &[u8] = raw_tzdata::ANTARCTICA_MC_MURDO;

        /// Raw, unparsed time zone data for Antarctica/Palmer,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PALMER: &[u8] = raw_tzdata::ANTARCTICA_PALMER;

        /// Raw, unparsed time zone data for Antarctica/Rothera,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ROTHERA: &[u8] = raw_tzdata::ANTARCTICA_ROTHERA;

        /// Raw, unparsed time zone data for Antarctica/South_Pole,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SOUTH_POLE: &[u8] = raw_tzdata::ANTARCTICA_MC_MURDO;

        /// Raw, unparsed time zone data for Antarctica/Syowa,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SYOWA: &[u8] = raw_tzdata::ANTARCTICA_SYOWA;

        /// Raw, unparsed time zone data for Antarctica/Troll,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TROLL: &[u8] = raw_tzdata::ANTARCTICA_TROLL;

        /// Raw, unparsed time zone data for Antarctica/Vostok,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_VOSTOK: &[u8] = raw_tzdata::ANTARCTICA_VOSTOK;
    }

    /// arctic
    pub mod arctic {
        use super::*;

        /// Time zone data for Arctic/Longyearbyen,
        pub const LONGYEARBYEN: TimeZoneRef<'static> = tzdata::ARCTIC_LONGYEARBYEN;

        /// Raw, unparsed time zone data for Arctic/Longyearbyen,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LONGYEARBYEN: &[u8] = raw_tzdata::ARCTIC_LONGYEARBYEN;
    }

    /// asia
    pub mod asia {
        use super::*;

        /// Time zone data for Asia/Aden,
        pub const ADEN: TimeZoneRef<'static> = tzdata::ASIA_ADEN;

        /// Time zone data for Asia/Almaty,
        pub const ALMATY: TimeZoneRef<'static> = tzdata::ASIA_ALMATY;

        /// Time zone data for Asia/Amman,
        pub const AMMAN: TimeZoneRef<'static> = tzdata::ASIA_AMMAN;

        /// Time zone data for Asia/Anadyr,
        pub const ANADYR: TimeZoneRef<'static> = tzdata::ASIA_ANADYR;

        /// Time zone data for Asia/Aqtau,
        pub const AQTAU: TimeZoneRef<'static> = tzdata::ASIA_AQTAU;

        /// Time zone data for Asia/Aqtobe,
        pub const AQTOBE: TimeZoneRef<'static> = tzdata::ASIA_AQTOBE;

        /// Time zone data for Asia/Ashgabat,
        pub const ASHGABAT: TimeZoneRef<'static> = tzdata::ASIA_ASHGABAT;

        /// Time zone data for Asia/Ashkhabad,
        pub const ASHKHABAD: TimeZoneRef<'static> = tzdata::ASIA_ASHGABAT;

        /// Time zone data for Asia/Atyrau,
        pub const ATYRAU: TimeZoneRef<'static> = tzdata::ASIA_ATYRAU;

        /// Time zone data for Asia/Baghdad,
        pub const BAGHDAD: TimeZoneRef<'static> = tzdata::ASIA_BAGHDAD;

        /// Time zone data for Asia/Bahrain,
        pub const BAHRAIN: TimeZoneRef<'static> = tzdata::ASIA_BAHRAIN;

        /// Time zone data for Asia/Baku,
        pub const BAKU: TimeZoneRef<'static> = tzdata::ASIA_BAKU;

        /// Time zone data for Asia/Bangkok,
        pub const BANGKOK: TimeZoneRef<'static> = tzdata::ASIA_BANGKOK;

        /// Time zone data for Asia/Barnaul,
        pub const BARNAUL: TimeZoneRef<'static> = tzdata::ASIA_BARNAUL;

        /// Time zone data for Asia/Beirut,
        pub const BEIRUT: TimeZoneRef<'static> = tzdata::ASIA_BEIRUT;

        /// Time zone data for Asia/Bishkek,
        pub const BISHKEK: TimeZoneRef<'static> = tzdata::ASIA_BISHKEK;

        /// Time zone data for Asia/Brunei,
        pub const BRUNEI: TimeZoneRef<'static> = tzdata::ASIA_BRUNEI;

        /// Time zone data for Asia/Calcutta,
        pub const CALCUTTA: TimeZoneRef<'static> = tzdata::ASIA_CALCUTTA;

        /// Time zone data for Asia/Chita,
        pub const CHITA: TimeZoneRef<'static> = tzdata::ASIA_CHITA;

        /// Time zone data for Asia/Choibalsan,
        pub const CHOIBALSAN: TimeZoneRef<'static> = tzdata::ASIA_CHOIBALSAN;

        /// Time zone data for Asia/Chongqing,
        pub const CHONGQING: TimeZoneRef<'static> = tzdata::ASIA_CHONGQING;

        /// Time zone data for Asia/Chungking,
        pub const CHUNGKING: TimeZoneRef<'static> = tzdata::ASIA_CHONGQING;

        /// Time zone data for Asia/Colombo,
        pub const COLOMBO: TimeZoneRef<'static> = tzdata::ASIA_COLOMBO;

        /// Time zone data for Asia/Dacca,
        pub const DACCA: TimeZoneRef<'static> = tzdata::ASIA_DACCA;

        /// Time zone data for Asia/Damascus,
        pub const DAMASCUS: TimeZoneRef<'static> = tzdata::ASIA_DAMASCUS;

        /// Time zone data for Asia/Dhaka,
        pub const DHAKA: TimeZoneRef<'static> = tzdata::ASIA_DACCA;

        /// Time zone data for Asia/Dili,
        pub const DILI: TimeZoneRef<'static> = tzdata::ASIA_DILI;

        /// Time zone data for Asia/Dubai,
        pub const DUBAI: TimeZoneRef<'static> = tzdata::ASIA_DUBAI;

        /// Time zone data for Asia/Dushanbe,
        pub const DUSHANBE: TimeZoneRef<'static> = tzdata::ASIA_DUSHANBE;

        /// Time zone data for Asia/Famagusta,
        pub const FAMAGUSTA: TimeZoneRef<'static> = tzdata::ASIA_FAMAGUSTA;

        /// Time zone data for Asia/Gaza,
        pub const GAZA: TimeZoneRef<'static> = tzdata::ASIA_GAZA;

        /// Time zone data for Asia/Hanoi,
        pub const HANOI: TimeZoneRef<'static> = tzdata::ASIA_HANOI;

        /// Time zone data for Asia/Harbin,
        pub const HARBIN: TimeZoneRef<'static> = tzdata::ASIA_HARBIN;

        /// Time zone data for Asia/Hebron,
        pub const HEBRON: TimeZoneRef<'static> = tzdata::ASIA_HEBRON;

        /// Time zone data for Asia/Hong_Kong,
        pub const HONG_KONG: TimeZoneRef<'static> = tzdata::HONGKONG;

        /// Time zone data for Asia/Hovd,
        pub const HOVD: TimeZoneRef<'static> = tzdata::ASIA_HOVD;

        /// Time zone data for Asia/Ho_Chi_Minh,
        pub const HO_CHI_MINH: TimeZoneRef<'static> = tzdata::ASIA_HO_CHI_MINH;

        /// Time zone data for Asia/Irkutsk,
        pub const IRKUTSK: TimeZoneRef<'static> = tzdata::ASIA_IRKUTSK;

        /// Time zone data for Asia/Istanbul,
        pub const ISTANBUL: TimeZoneRef<'static> = tzdata::TURKEY;

        /// Time zone data for Asia/Jakarta,
        pub const JAKARTA: TimeZoneRef<'static> = tzdata::ASIA_JAKARTA;

        /// Time zone data for Asia/Jayapura,
        pub const JAYAPURA: TimeZoneRef<'static> = tzdata::ASIA_JAYAPURA;

        /// Time zone data for Asia/Jerusalem,
        pub const JERUSALEM: TimeZoneRef<'static> = tzdata::ISRAEL;

        /// Time zone data for Asia/Kabul,
        pub const KABUL: TimeZoneRef<'static> = tzdata::ASIA_KABUL;

        /// Time zone data for Asia/Kamchatka,
        pub const KAMCHATKA: TimeZoneRef<'static> = tzdata::ASIA_KAMCHATKA;

        /// Time zone data for Asia/Karachi,
        pub const KARACHI: TimeZoneRef<'static> = tzdata::ASIA_KARACHI;

        /// Time zone data for Asia/Kashgar,
        pub const KASHGAR: TimeZoneRef<'static> = tzdata::ASIA_KASHGAR;

        /// Time zone data for Asia/Kathmandu,
        pub const KATHMANDU: TimeZoneRef<'static> = tzdata::ASIA_KATHMANDU;

        /// Time zone data for Asia/Katmandu,
        pub const KATMANDU: TimeZoneRef<'static> = tzdata::ASIA_KATHMANDU;

        /// Time zone data for Asia/Khandyga,
        pub const KHANDYGA: TimeZoneRef<'static> = tzdata::ASIA_KHANDYGA;

        /// Time zone data for Asia/Kolkata,
        pub const KOLKATA: TimeZoneRef<'static> = tzdata::ASIA_CALCUTTA;

        /// Time zone data for Asia/Krasnoyarsk,
        pub const KRASNOYARSK: TimeZoneRef<'static> = tzdata::ASIA_KRASNOYARSK;

        /// Time zone data for Asia/Kuala_Lumpur,
        pub const KUALA_LUMPUR: TimeZoneRef<'static> = tzdata::ASIA_KUALA_LUMPUR;

        /// Time zone data for Asia/Kuching,
        pub const KUCHING: TimeZoneRef<'static> = tzdata::ASIA_KUCHING;

        /// Time zone data for Asia/Kuwait,
        pub const KUWAIT: TimeZoneRef<'static> = tzdata::ASIA_KUWAIT;

        /// Time zone data for Asia/Macao,
        pub const MACAO: TimeZoneRef<'static> = tzdata::ASIA_MACAO;

        /// Time zone data for Asia/Macau,
        pub const MACAU: TimeZoneRef<'static> = tzdata::ASIA_MACAO;

        /// Time zone data for Asia/Magadan,
        pub const MAGADAN: TimeZoneRef<'static> = tzdata::ASIA_MAGADAN;

        /// Time zone data for Asia/Makassar,
        pub const MAKASSAR: TimeZoneRef<'static> = tzdata::ASIA_MAKASSAR;

        /// Time zone data for Asia/Manila,
        pub const MANILA: TimeZoneRef<'static> = tzdata::ASIA_MANILA;

        /// Time zone data for Asia/Muscat,
        pub const MUSCAT: TimeZoneRef<'static> = tzdata::ASIA_MUSCAT;

        /// Time zone data for Asia/Nicosia,
        pub const NICOSIA: TimeZoneRef<'static> = tzdata::ASIA_NICOSIA;

        /// Time zone data for Asia/Novokuznetsk,
        pub const NOVOKUZNETSK: TimeZoneRef<'static> = tzdata::ASIA_NOVOKUZNETSK;

        /// Time zone data for Asia/Novosibirsk,
        pub const NOVOSIBIRSK: TimeZoneRef<'static> = tzdata::ASIA_NOVOSIBIRSK;

        /// Time zone data for Asia/Omsk,
        pub const OMSK: TimeZoneRef<'static> = tzdata::ASIA_OMSK;

        /// Time zone data for Asia/Oral,
        pub const ORAL: TimeZoneRef<'static> = tzdata::ASIA_ORAL;

        /// Time zone data for Asia/Phnom_Penh,
        pub const PHNOM_PENH: TimeZoneRef<'static> = tzdata::ASIA_PHNOM_PENH;

        /// Time zone data for Asia/Pontianak,
        pub const PONTIANAK: TimeZoneRef<'static> = tzdata::ASIA_PONTIANAK;

        /// Time zone data for Asia/Pyongyang,
        pub const PYONGYANG: TimeZoneRef<'static> = tzdata::ASIA_PYONGYANG;

        /// Time zone data for Asia/Qatar,
        pub const QATAR: TimeZoneRef<'static> = tzdata::ASIA_QATAR;

        /// Time zone data for Asia/Qostanay,
        pub const QOSTANAY: TimeZoneRef<'static> = tzdata::ASIA_QOSTANAY;

        /// Time zone data for Asia/Qyzylorda,
        pub const QYZYLORDA: TimeZoneRef<'static> = tzdata::ASIA_QYZYLORDA;

        /// Time zone data for Asia/Rangoon,
        pub const RANGOON: TimeZoneRef<'static> = tzdata::ASIA_RANGOON;

        /// Time zone data for Asia/Riyadh,
        pub const RIYADH: TimeZoneRef<'static> = tzdata::ASIA_RIYADH;

        /// Time zone data for Asia/Saigon,
        pub const SAIGON: TimeZoneRef<'static> = tzdata::ASIA_HO_CHI_MINH;

        /// Time zone data for Asia/Sakhalin,
        pub const SAKHALIN: TimeZoneRef<'static> = tzdata::ASIA_SAKHALIN;

        /// Time zone data for Asia/Samarkand,
        pub const SAMARKAND: TimeZoneRef<'static> = tzdata::ASIA_SAMARKAND;

        /// Time zone data for Asia/Seoul,
        pub const SEOUL: TimeZoneRef<'static> = tzdata::ROK;

        /// Time zone data for Asia/Shanghai,
        pub const SHANGHAI: TimeZoneRef<'static> = tzdata::PRC;

        /// Time zone data for Asia/Singapore,
        pub const SINGAPORE: TimeZoneRef<'static> = tzdata::SINGAPORE;

        /// Time zone data for Asia/Srednekolymsk,
        pub const SREDNEKOLYMSK: TimeZoneRef<'static> = tzdata::ASIA_SREDNEKOLYMSK;

        /// Time zone data for Asia/Taipei,
        pub const TAIPEI: TimeZoneRef<'static> = tzdata::ROC;

        /// Time zone data for Asia/Tashkent,
        pub const TASHKENT: TimeZoneRef<'static> = tzdata::ASIA_TASHKENT;

        /// Time zone data for Asia/Tbilisi,
        pub const TBILISI: TimeZoneRef<'static> = tzdata::ASIA_TBILISI;

        /// Time zone data for Asia/Tehran,
        pub const TEHRAN: TimeZoneRef<'static> = tzdata::IRAN;

        /// Time zone data for Asia/Tel_Aviv,
        pub const TEL_AVIV: TimeZoneRef<'static> = tzdata::ASIA_TEL_AVIV;

        /// Time zone data for Asia/Thimbu,
        pub const THIMBU: TimeZoneRef<'static> = tzdata::ASIA_THIMBU;

        /// Time zone data for Asia/Thimphu,
        pub const THIMPHU: TimeZoneRef<'static> = tzdata::ASIA_THIMBU;

        /// Time zone data for Asia/Tokyo,
        pub const TOKYO: TimeZoneRef<'static> = tzdata::JAPAN;

        /// Time zone data for Asia/Tomsk,
        pub const TOMSK: TimeZoneRef<'static> = tzdata::ASIA_TOMSK;

        /// Time zone data for Asia/Ujung_Pandang,
        pub const UJUNG_PANDANG: TimeZoneRef<'static> = tzdata::ASIA_MAKASSAR;

        /// Time zone data for Asia/Ulaanbaatar,
        pub const ULAANBAATAR: TimeZoneRef<'static> = tzdata::ASIA_ULAANBAATAR;

        /// Time zone data for Asia/Ulan_Bator,
        pub const ULAN_BATOR: TimeZoneRef<'static> = tzdata::ASIA_ULAANBAATAR;

        /// Time zone data for Asia/Urumqi,
        pub const URUMQI: TimeZoneRef<'static> = tzdata::ASIA_URUMQI;

        /// Time zone data for Asia/Ust-Nera,
        pub const UST_NERA: TimeZoneRef<'static> = tzdata::ASIA_UST_NERA;

        /// Time zone data for Asia/Vientiane,
        pub const VIENTIANE: TimeZoneRef<'static> = tzdata::ASIA_VIENTIANE;

        /// Time zone data for Asia/Vladivostok,
        pub const VLADIVOSTOK: TimeZoneRef<'static> = tzdata::ASIA_VLADIVOSTOK;

        /// Time zone data for Asia/Yakutsk,
        pub const YAKUTSK: TimeZoneRef<'static> = tzdata::ASIA_YAKUTSK;

        /// Time zone data for Asia/Yangon,
        pub const YANGON: TimeZoneRef<'static> = tzdata::ASIA_RANGOON;

        /// Time zone data for Asia/Yekaterinburg,
        pub const YEKATERINBURG: TimeZoneRef<'static> = tzdata::ASIA_YEKATERINBURG;

        /// Time zone data for Asia/Yerevan,
        pub const YEREVAN: TimeZoneRef<'static> = tzdata::ASIA_YEREVAN;

        /// Raw, unparsed time zone data for Asia/Aden,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ADEN: &[u8] = raw_tzdata::ASIA_ADEN;

        /// Raw, unparsed time zone data for Asia/Almaty,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ALMATY: &[u8] = raw_tzdata::ASIA_ALMATY;

        /// Raw, unparsed time zone data for Asia/Amman,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_AMMAN: &[u8] = raw_tzdata::ASIA_AMMAN;

        /// Raw, unparsed time zone data for Asia/Anadyr,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ANADYR: &[u8] = raw_tzdata::ASIA_ANADYR;

        /// Raw, unparsed time zone data for Asia/Aqtau,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_AQTAU: &[u8] = raw_tzdata::ASIA_AQTAU;

        /// Raw, unparsed time zone data for Asia/Aqtobe,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_AQTOBE: &[u8] = raw_tzdata::ASIA_AQTOBE;

        /// Raw, unparsed time zone data for Asia/Ashgabat,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ASHGABAT: &[u8] = raw_tzdata::ASIA_ASHGABAT;

        /// Raw, unparsed time zone data for Asia/Ashkhabad,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ASHKHABAD: &[u8] = raw_tzdata::ASIA_ASHGABAT;

        /// Raw, unparsed time zone data for Asia/Atyrau,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ATYRAU: &[u8] = raw_tzdata::ASIA_ATYRAU;

        /// Raw, unparsed time zone data for Asia/Baghdad,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BAGHDAD: &[u8] = raw_tzdata::ASIA_BAGHDAD;

        /// Raw, unparsed time zone data for Asia/Bahrain,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BAHRAIN: &[u8] = raw_tzdata::ASIA_BAHRAIN;

        /// Raw, unparsed time zone data for Asia/Baku,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BAKU: &[u8] = raw_tzdata::ASIA_BAKU;

        /// Raw, unparsed time zone data for Asia/Bangkok,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BANGKOK: &[u8] = raw_tzdata::ASIA_BANGKOK;

        /// Raw, unparsed time zone data for Asia/Barnaul,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BARNAUL: &[u8] = raw_tzdata::ASIA_BARNAUL;

        /// Raw, unparsed time zone data for Asia/Beirut,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BEIRUT: &[u8] = raw_tzdata::ASIA_BEIRUT;

        /// Raw, unparsed time zone data for Asia/Bishkek,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BISHKEK: &[u8] = raw_tzdata::ASIA_BISHKEK;

        /// Raw, unparsed time zone data for Asia/Brunei,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BRUNEI: &[u8] = raw_tzdata::ASIA_BRUNEI;

        /// Raw, unparsed time zone data for Asia/Calcutta,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CALCUTTA: &[u8] = raw_tzdata::ASIA_CALCUTTA;

        /// Raw, unparsed time zone data for Asia/Chita,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CHITA: &[u8] = raw_tzdata::ASIA_CHITA;

        /// Raw, unparsed time zone data for Asia/Choibalsan,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CHOIBALSAN: &[u8] = raw_tzdata::ASIA_CHOIBALSAN;

        /// Raw, unparsed time zone data for Asia/Chongqing,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CHONGQING: &[u8] = raw_tzdata::ASIA_CHONGQING;

        /// Raw, unparsed time zone data for Asia/Chungking,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CHUNGKING: &[u8] = raw_tzdata::ASIA_CHONGQING;

        /// Raw, unparsed time zone data for Asia/Colombo,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_COLOMBO: &[u8] = raw_tzdata::ASIA_COLOMBO;

        /// Raw, unparsed time zone data for Asia/Dacca,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DACCA: &[u8] = raw_tzdata::ASIA_DACCA;

        /// Raw, unparsed time zone data for Asia/Damascus,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DAMASCUS: &[u8] = raw_tzdata::ASIA_DAMASCUS;

        /// Raw, unparsed time zone data for Asia/Dhaka,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DHAKA: &[u8] = raw_tzdata::ASIA_DACCA;

        /// Raw, unparsed time zone data for Asia/Dili,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DILI: &[u8] = raw_tzdata::ASIA_DILI;

        /// Raw, unparsed time zone data for Asia/Dubai,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DUBAI: &[u8] = raw_tzdata::ASIA_DUBAI;

        /// Raw, unparsed time zone data for Asia/Dushanbe,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DUSHANBE: &[u8] = raw_tzdata::ASIA_DUSHANBE;

        /// Raw, unparsed time zone data for Asia/Famagusta,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_FAMAGUSTA: &[u8] = raw_tzdata::ASIA_FAMAGUSTA;

        /// Raw, unparsed time zone data for Asia/Gaza,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GAZA: &[u8] = raw_tzdata::ASIA_GAZA;

        /// Raw, unparsed time zone data for Asia/Hanoi,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_HANOI: &[u8] = raw_tzdata::ASIA_HANOI;

        /// Raw, unparsed time zone data for Asia/Harbin,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_HARBIN: &[u8] = raw_tzdata::ASIA_HARBIN;

        /// Raw, unparsed time zone data for Asia/Hebron,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_HEBRON: &[u8] = raw_tzdata::ASIA_HEBRON;

        /// Raw, unparsed time zone data for Asia/Hong_Kong,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_HONG_KONG: &[u8] = raw_tzdata::HONGKONG;

        /// Raw, unparsed time zone data for Asia/Hovd,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_HOVD: &[u8] = raw_tzdata::ASIA_HOVD;

        /// Raw, unparsed time zone data for Asia/Ho_Chi_Minh,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_HO_CHI_MINH: &[u8] = raw_tzdata::ASIA_HO_CHI_MINH;

        /// Raw, unparsed time zone data for Asia/Irkutsk,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_IRKUTSK: &[u8] = raw_tzdata::ASIA_IRKUTSK;

        /// Raw, unparsed time zone data for Asia/Istanbul,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ISTANBUL: &[u8] = raw_tzdata::TURKEY;

        /// Raw, unparsed time zone data for Asia/Jakarta,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_JAKARTA: &[u8] = raw_tzdata::ASIA_JAKARTA;

        /// Raw, unparsed time zone data for Asia/Jayapura,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_JAYAPURA: &[u8] = raw_tzdata::ASIA_JAYAPURA;

        /// Raw, unparsed time zone data for Asia/Jerusalem,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_JERUSALEM: &[u8] = raw_tzdata::ISRAEL;

        /// Raw, unparsed time zone data for Asia/Kabul,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KABUL: &[u8] = raw_tzdata::ASIA_KABUL;

        /// Raw, unparsed time zone data for Asia/Kamchatka,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KAMCHATKA: &[u8] = raw_tzdata::ASIA_KAMCHATKA;

        /// Raw, unparsed time zone data for Asia/Karachi,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KARACHI: &[u8] = raw_tzdata::ASIA_KARACHI;

        /// Raw, unparsed time zone data for Asia/Kashgar,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KASHGAR: &[u8] = raw_tzdata::ASIA_KASHGAR;

        /// Raw, unparsed time zone data for Asia/Kathmandu,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KATHMANDU: &[u8] = raw_tzdata::ASIA_KATHMANDU;

        /// Raw, unparsed time zone data for Asia/Katmandu,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KATMANDU: &[u8] = raw_tzdata::ASIA_KATHMANDU;

        /// Raw, unparsed time zone data for Asia/Khandyga,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KHANDYGA: &[u8] = raw_tzdata::ASIA_KHANDYGA;

        /// Raw, unparsed time zone data for Asia/Kolkata,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KOLKATA: &[u8] = raw_tzdata::ASIA_CALCUTTA;

        /// Raw, unparsed time zone data for Asia/Krasnoyarsk,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KRASNOYARSK: &[u8] = raw_tzdata::ASIA_KRASNOYARSK;

        /// Raw, unparsed time zone data for Asia/Kuala_Lumpur,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KUALA_LUMPUR: &[u8] = raw_tzdata::ASIA_KUALA_LUMPUR;

        /// Raw, unparsed time zone data for Asia/Kuching,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KUCHING: &[u8] = raw_tzdata::ASIA_KUCHING;

        /// Raw, unparsed time zone data for Asia/Kuwait,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KUWAIT: &[u8] = raw_tzdata::ASIA_KUWAIT;

        /// Raw, unparsed time zone data for Asia/Macao,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MACAO: &[u8] = raw_tzdata::ASIA_MACAO;

        /// Raw, unparsed time zone data for Asia/Macau,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MACAU: &[u8] = raw_tzdata::ASIA_MACAO;

        /// Raw, unparsed time zone data for Asia/Magadan,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MAGADAN: &[u8] = raw_tzdata::ASIA_MAGADAN;

        /// Raw, unparsed time zone data for Asia/Makassar,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MAKASSAR: &[u8] = raw_tzdata::ASIA_MAKASSAR;

        /// Raw, unparsed time zone data for Asia/Manila,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MANILA: &[u8] = raw_tzdata::ASIA_MANILA;

        /// Raw, unparsed time zone data for Asia/Muscat,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MUSCAT: &[u8] = raw_tzdata::ASIA_MUSCAT;

        /// Raw, unparsed time zone data for Asia/Nicosia,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NICOSIA: &[u8] = raw_tzdata::ASIA_NICOSIA;

        /// Raw, unparsed time zone data for Asia/Novokuznetsk,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NOVOKUZNETSK: &[u8] = raw_tzdata::ASIA_NOVOKUZNETSK;

        /// Raw, unparsed time zone data for Asia/Novosibirsk,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NOVOSIBIRSK: &[u8] = raw_tzdata::ASIA_NOVOSIBIRSK;

        /// Raw, unparsed time zone data for Asia/Omsk,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_OMSK: &[u8] = raw_tzdata::ASIA_OMSK;

        /// Raw, unparsed time zone data for Asia/Oral,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ORAL: &[u8] = raw_tzdata::ASIA_ORAL;

        /// Raw, unparsed time zone data for Asia/Phnom_Penh,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PHNOM_PENH: &[u8] = raw_tzdata::ASIA_PHNOM_PENH;

        /// Raw, unparsed time zone data for Asia/Pontianak,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PONTIANAK: &[u8] = raw_tzdata::ASIA_PONTIANAK;

        /// Raw, unparsed time zone data for Asia/Pyongyang,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PYONGYANG: &[u8] = raw_tzdata::ASIA_PYONGYANG;

        /// Raw, unparsed time zone data for Asia/Qatar,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_QATAR: &[u8] = raw_tzdata::ASIA_QATAR;

        /// Raw, unparsed time zone data for Asia/Qostanay,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_QOSTANAY: &[u8] = raw_tzdata::ASIA_QOSTANAY;

        /// Raw, unparsed time zone data for Asia/Qyzylorda,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_QYZYLORDA: &[u8] = raw_tzdata::ASIA_QYZYLORDA;

        /// Raw, unparsed time zone data for Asia/Rangoon,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_RANGOON: &[u8] = raw_tzdata::ASIA_RANGOON;

        /// Raw, unparsed time zone data for Asia/Riyadh,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_RIYADH: &[u8] = raw_tzdata::ASIA_RIYADH;

        /// Raw, unparsed time zone data for Asia/Saigon,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SAIGON: &[u8] = raw_tzdata::ASIA_HO_CHI_MINH;

        /// Raw, unparsed time zone data for Asia/Sakhalin,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SAKHALIN: &[u8] = raw_tzdata::ASIA_SAKHALIN;

        /// Raw, unparsed time zone data for Asia/Samarkand,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SAMARKAND: &[u8] = raw_tzdata::ASIA_SAMARKAND;

        /// Raw, unparsed time zone data for Asia/Seoul,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SEOUL: &[u8] = raw_tzdata::ROK;

        /// Raw, unparsed time zone data for Asia/Shanghai,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SHANGHAI: &[u8] = raw_tzdata::PRC;

        /// Raw, unparsed time zone data for Asia/Singapore,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SINGAPORE: &[u8] = raw_tzdata::SINGAPORE;

        /// Raw, unparsed time zone data for Asia/Srednekolymsk,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SREDNEKOLYMSK: &[u8] = raw_tzdata::ASIA_SREDNEKOLYMSK;

        /// Raw, unparsed time zone data for Asia/Taipei,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TAIPEI: &[u8] = raw_tzdata::ROC;

        /// Raw, unparsed time zone data for Asia/Tashkent,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TASHKENT: &[u8] = raw_tzdata::ASIA_TASHKENT;

        /// Raw, unparsed time zone data for Asia/Tbilisi,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TBILISI: &[u8] = raw_tzdata::ASIA_TBILISI;

        /// Raw, unparsed time zone data for Asia/Tehran,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TEHRAN: &[u8] = raw_tzdata::IRAN;

        /// Raw, unparsed time zone data for Asia/Tel_Aviv,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TEL_AVIV: &[u8] = raw_tzdata::ASIA_TEL_AVIV;

        /// Raw, unparsed time zone data for Asia/Thimbu,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_THIMBU: &[u8] = raw_tzdata::ASIA_THIMBU;

        /// Raw, unparsed time zone data for Asia/Thimphu,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_THIMPHU: &[u8] = raw_tzdata::ASIA_THIMBU;

        /// Raw, unparsed time zone data for Asia/Tokyo,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TOKYO: &[u8] = raw_tzdata::JAPAN;

        /// Raw, unparsed time zone data for Asia/Tomsk,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TOMSK: &[u8] = raw_tzdata::ASIA_TOMSK;

        /// Raw, unparsed time zone data for Asia/Ujung_Pandang,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_UJUNG_PANDANG: &[u8] = raw_tzdata::ASIA_MAKASSAR;

        /// Raw, unparsed time zone data for Asia/Ulaanbaatar,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ULAANBAATAR: &[u8] = raw_tzdata::ASIA_ULAANBAATAR;

        /// Raw, unparsed time zone data for Asia/Ulan_Bator,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ULAN_BATOR: &[u8] = raw_tzdata::ASIA_ULAANBAATAR;

        /// Raw, unparsed time zone data for Asia/Urumqi,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_URUMQI: &[u8] = raw_tzdata::ASIA_URUMQI;

        /// Raw, unparsed time zone data for Asia/Ust-Nera,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_UST_NERA: &[u8] = raw_tzdata::ASIA_UST_NERA;

        /// Raw, unparsed time zone data for Asia/Vientiane,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_VIENTIANE: &[u8] = raw_tzdata::ASIA_VIENTIANE;

        /// Raw, unparsed time zone data for Asia/Vladivostok,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_VLADIVOSTOK: &[u8] = raw_tzdata::ASIA_VLADIVOSTOK;

        /// Raw, unparsed time zone data for Asia/Yakutsk,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_YAKUTSK: &[u8] = raw_tzdata::ASIA_YAKUTSK;

        /// Raw, unparsed time zone data for Asia/Yangon,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_YANGON: &[u8] = raw_tzdata::ASIA_RANGOON;

        /// Raw, unparsed time zone data for Asia/Yekaterinburg,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_YEKATERINBURG: &[u8] = raw_tzdata::ASIA_YEKATERINBURG;

        /// Raw, unparsed time zone data for Asia/Yerevan,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_YEREVAN: &[u8] = raw_tzdata::ASIA_YEREVAN;
    }

    /// atlantic
    pub mod atlantic {
        use super::*;

        /// Time zone data for Atlantic/Azores,
        pub const AZORES: TimeZoneRef<'static> = tzdata::ATLANTIC_AZORES;

        /// Time zone data for Atlantic/Bermuda,
        pub const BERMUDA: TimeZoneRef<'static> = tzdata::ATLANTIC_BERMUDA;

        /// Time zone data for Atlantic/Canary,
        pub const CANARY: TimeZoneRef<'static> = tzdata::ATLANTIC_CANARY;

        /// Time zone data for Atlantic/Cape_Verde,
        pub const CAPE_VERDE: TimeZoneRef<'static> = tzdata::ATLANTIC_CAPE_VERDE;

        /// Time zone data for Atlantic/Faeroe,
        pub const FAEROE: TimeZoneRef<'static> = tzdata::ATLANTIC_FAEROE;

        /// Time zone data for Atlantic/Faroe,
        pub const FAROE: TimeZoneRef<'static> = tzdata::ATLANTIC_FAEROE;

        /// Time zone data for Atlantic/Jan_Mayen,
        pub const JAN_MAYEN: TimeZoneRef<'static> = tzdata::ATLANTIC_JAN_MAYEN;

        /// Time zone data for Atlantic/Madeira,
        pub const MADEIRA: TimeZoneRef<'static> = tzdata::ATLANTIC_MADEIRA;

        /// Time zone data for Atlantic/Reykjavik,
        pub const REYKJAVIK: TimeZoneRef<'static> = tzdata::ICELAND;

        /// Time zone data for Atlantic/South_Georgia,
        pub const SOUTH_GEORGIA: TimeZoneRef<'static> = tzdata::ATLANTIC_SOUTH_GEORGIA;

        /// Time zone data for Atlantic/Stanley,
        pub const STANLEY: TimeZoneRef<'static> = tzdata::ATLANTIC_STANLEY;

        /// Time zone data for Atlantic/St_Helena,
        pub const ST_HELENA: TimeZoneRef<'static> = tzdata::ATLANTIC_ST_HELENA;

        /// Raw, unparsed time zone data for Atlantic/Azores,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_AZORES: &[u8] = raw_tzdata::ATLANTIC_AZORES;

        /// Raw, unparsed time zone data for Atlantic/Bermuda,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BERMUDA: &[u8] = raw_tzdata::ATLANTIC_BERMUDA;

        /// Raw, unparsed time zone data for Atlantic/Canary,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CANARY: &[u8] = raw_tzdata::ATLANTIC_CANARY;

        /// Raw, unparsed time zone data for Atlantic/Cape_Verde,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CAPE_VERDE: &[u8] = raw_tzdata::ATLANTIC_CAPE_VERDE;

        /// Raw, unparsed time zone data for Atlantic/Faeroe,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_FAEROE: &[u8] = raw_tzdata::ATLANTIC_FAEROE;

        /// Raw, unparsed time zone data for Atlantic/Faroe,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_FAROE: &[u8] = raw_tzdata::ATLANTIC_FAEROE;

        /// Raw, unparsed time zone data for Atlantic/Jan_Mayen,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_JAN_MAYEN: &[u8] = raw_tzdata::ATLANTIC_JAN_MAYEN;

        /// Raw, unparsed time zone data for Atlantic/Madeira,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MADEIRA: &[u8] = raw_tzdata::ATLANTIC_MADEIRA;

        /// Raw, unparsed time zone data for Atlantic/Reykjavik,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_REYKJAVIK: &[u8] = raw_tzdata::ICELAND;

        /// Raw, unparsed time zone data for Atlantic/South_Georgia,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SOUTH_GEORGIA: &[u8] = raw_tzdata::ATLANTIC_SOUTH_GEORGIA;

        /// Raw, unparsed time zone data for Atlantic/Stanley,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_STANLEY: &[u8] = raw_tzdata::ATLANTIC_STANLEY;

        /// Raw, unparsed time zone data for Atlantic/St_Helena,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ST_HELENA: &[u8] = raw_tzdata::ATLANTIC_ST_HELENA;
    }

    /// australia
    pub mod australia {
        use super::*;

        /// Time zone data for Australia/ACT,
        pub const ACT: TimeZoneRef<'static> = tzdata::AUSTRALIA_ACT;

        /// Time zone data for Australia/Adelaide,
        pub const ADELAIDE: TimeZoneRef<'static> = tzdata::AUSTRALIA_ADELAIDE;

        /// Time zone data for Australia/Brisbane,
        pub const BRISBANE: TimeZoneRef<'static> = tzdata::AUSTRALIA_BRISBANE;

        /// Time zone data for Australia/Broken_Hill,
        pub const BROKEN_HILL: TimeZoneRef<'static> = tzdata::AUSTRALIA_BROKEN_HILL;

        /// Time zone data for Australia/Canberra,
        pub const CANBERRA: TimeZoneRef<'static> = tzdata::AUSTRALIA_ACT;

        /// Time zone data for Australia/Currie,
        pub const CURRIE: TimeZoneRef<'static> = tzdata::AUSTRALIA_CURRIE;

        /// Time zone data for Australia/Darwin,
        pub const DARWIN: TimeZoneRef<'static> = tzdata::AUSTRALIA_DARWIN;

        /// Time zone data for Australia/Eucla,
        pub const EUCLA: TimeZoneRef<'static> = tzdata::AUSTRALIA_EUCLA;

        /// Time zone data for Australia/Hobart,
        pub const HOBART: TimeZoneRef<'static> = tzdata::AUSTRALIA_HOBART;

        /// Time zone data for Australia/LHI,
        pub const LHI: TimeZoneRef<'static> = tzdata::AUSTRALIA_LHI;

        /// Time zone data for Australia/Lindeman,
        pub const LINDEMAN: TimeZoneRef<'static> = tzdata::AUSTRALIA_LINDEMAN;

        /// Time zone data for Australia/Lord_Howe,
        pub const LORD_HOWE: TimeZoneRef<'static> = tzdata::AUSTRALIA_LHI;

        /// Time zone data for Australia/Melbourne,
        pub const MELBOURNE: TimeZoneRef<'static> = tzdata::AUSTRALIA_MELBOURNE;

        /// Time zone data for Australia/North,
        pub const NORTH: TimeZoneRef<'static> = tzdata::AUSTRALIA_DARWIN;

        /// Time zone data for Australia/NSW,
        pub const NSW: TimeZoneRef<'static> = tzdata::AUSTRALIA_ACT;

        /// Time zone data for Australia/Perth,
        pub const PERTH: TimeZoneRef<'static> = tzdata::AUSTRALIA_PERTH;

        /// Time zone data for Australia/Queensland,
        pub const QUEENSLAND: TimeZoneRef<'static> = tzdata::AUSTRALIA_BRISBANE;

        /// Time zone data for Australia/South,
        pub const SOUTH: TimeZoneRef<'static> = tzdata::AUSTRALIA_ADELAIDE;

        /// Time zone data for Australia/Sydney,
        pub const SYDNEY: TimeZoneRef<'static> = tzdata::AUSTRALIA_ACT;

        /// Time zone data for Australia/Tasmania,
        pub const TASMANIA: TimeZoneRef<'static> = tzdata::AUSTRALIA_HOBART;

        /// Time zone data for Australia/Victoria,
        pub const VICTORIA: TimeZoneRef<'static> = tzdata::AUSTRALIA_MELBOURNE;

        /// Time zone data for Australia/West,
        pub const WEST: TimeZoneRef<'static> = tzdata::AUSTRALIA_PERTH;

        /// Time zone data for Australia/Yancowinna,
        pub const YANCOWINNA: TimeZoneRef<'static> = tzdata::AUSTRALIA_BROKEN_HILL;

        /// Raw, unparsed time zone data for Australia/ACT,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ACT: &[u8] = raw_tzdata::AUSTRALIA_ACT;

        /// Raw, unparsed time zone data for Australia/Adelaide,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ADELAIDE: &[u8] = raw_tzdata::AUSTRALIA_ADELAIDE;

        /// Raw, unparsed time zone data for Australia/Brisbane,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BRISBANE: &[u8] = raw_tzdata::AUSTRALIA_BRISBANE;

        /// Raw, unparsed time zone data for Australia/Broken_Hill,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BROKEN_HILL: &[u8] = raw_tzdata::AUSTRALIA_BROKEN_HILL;

        /// Raw, unparsed time zone data for Australia/Canberra,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CANBERRA: &[u8] = raw_tzdata::AUSTRALIA_ACT;

        /// Raw, unparsed time zone data for Australia/Currie,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CURRIE: &[u8] = raw_tzdata::AUSTRALIA_CURRIE;

        /// Raw, unparsed time zone data for Australia/Darwin,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DARWIN: &[u8] = raw_tzdata::AUSTRALIA_DARWIN;

        /// Raw, unparsed time zone data for Australia/Eucla,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_EUCLA: &[u8] = raw_tzdata::AUSTRALIA_EUCLA;

        /// Raw, unparsed time zone data for Australia/Hobart,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_HOBART: &[u8] = raw_tzdata::AUSTRALIA_HOBART;

        /// Raw, unparsed time zone data for Australia/LHI,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LHI: &[u8] = raw_tzdata::AUSTRALIA_LHI;

        /// Raw, unparsed time zone data for Australia/Lindeman,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LINDEMAN: &[u8] = raw_tzdata::AUSTRALIA_LINDEMAN;

        /// Raw, unparsed time zone data for Australia/Lord_Howe,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LORD_HOWE: &[u8] = raw_tzdata::AUSTRALIA_LHI;

        /// Raw, unparsed time zone data for Australia/Melbourne,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MELBOURNE: &[u8] = raw_tzdata::AUSTRALIA_MELBOURNE;

        /// Raw, unparsed time zone data for Australia/North,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NORTH: &[u8] = raw_tzdata::AUSTRALIA_DARWIN;

        /// Raw, unparsed time zone data for Australia/NSW,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NSW: &[u8] = raw_tzdata::AUSTRALIA_ACT;

        /// Raw, unparsed time zone data for Australia/Perth,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PERTH: &[u8] = raw_tzdata::AUSTRALIA_PERTH;

        /// Raw, unparsed time zone data for Australia/Queensland,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_QUEENSLAND: &[u8] = raw_tzdata::AUSTRALIA_BRISBANE;

        /// Raw, unparsed time zone data for Australia/South,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SOUTH: &[u8] = raw_tzdata::AUSTRALIA_ADELAIDE;

        /// Raw, unparsed time zone data for Australia/Sydney,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SYDNEY: &[u8] = raw_tzdata::AUSTRALIA_ACT;

        /// Raw, unparsed time zone data for Australia/Tasmania,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TASMANIA: &[u8] = raw_tzdata::AUSTRALIA_HOBART;

        /// Raw, unparsed time zone data for Australia/Victoria,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_VICTORIA: &[u8] = raw_tzdata::AUSTRALIA_MELBOURNE;

        /// Raw, unparsed time zone data for Australia/West,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_WEST: &[u8] = raw_tzdata::AUSTRALIA_PERTH;

        /// Raw, unparsed time zone data for Australia/Yancowinna,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_YANCOWINNA: &[u8] = raw_tzdata::AUSTRALIA_BROKEN_HILL;
    }

    /// brazil
    pub mod brazil {
        use super::*;

        /// Time zone data for Brazil/Acre,
        pub const ACRE: TimeZoneRef<'static> = tzdata::AMERICA_PORTO_ACRE;

        /// Time zone data for Brazil/DeNoronha,
        pub const DE_NORONHA: TimeZoneRef<'static> = tzdata::AMERICA_NORONHA;

        /// Time zone data for Brazil/East,
        pub const EAST: TimeZoneRef<'static> = tzdata::AMERICA_SAO_PAULO;

        /// Time zone data for Brazil/West,
        pub const WEST: TimeZoneRef<'static> = tzdata::AMERICA_MANAUS;

        /// Raw, unparsed time zone data for Brazil/Acre,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ACRE: &[u8] = raw_tzdata::AMERICA_PORTO_ACRE;

        /// Raw, unparsed time zone data for Brazil/DeNoronha,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DE_NORONHA: &[u8] = raw_tzdata::AMERICA_NORONHA;

        /// Raw, unparsed time zone data for Brazil/East,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_EAST: &[u8] = raw_tzdata::AMERICA_SAO_PAULO;

        /// Raw, unparsed time zone data for Brazil/West,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_WEST: &[u8] = raw_tzdata::AMERICA_MANAUS;
    }

    /// canada
    pub mod canada {
        use super::*;

        /// Time zone data for Canada/Atlantic,
        pub const ATLANTIC: TimeZoneRef<'static> = tzdata::AMERICA_HALIFAX;

        /// Time zone data for Canada/Central,
        pub const CENTRAL: TimeZoneRef<'static> = tzdata::AMERICA_WINNIPEG;

        /// Time zone data for Canada/Eastern,
        pub const EASTERN: TimeZoneRef<'static> = tzdata::AMERICA_TORONTO;

        /// Time zone data for Canada/Mountain,
        pub const MOUNTAIN: TimeZoneRef<'static> = tzdata::AMERICA_EDMONTON;

        /// Time zone data for Canada/Newfoundland,
        pub const NEWFOUNDLAND: TimeZoneRef<'static> = tzdata::AMERICA_ST_JOHNS;

        /// Time zone data for Canada/Pacific,
        pub const PACIFIC: TimeZoneRef<'static> = tzdata::AMERICA_VANCOUVER;

        /// Time zone data for Canada/Saskatchewan,
        pub const SASKATCHEWAN: TimeZoneRef<'static> = tzdata::AMERICA_REGINA;

        /// Time zone data for Canada/Yukon,
        pub const YUKON: TimeZoneRef<'static> = tzdata::AMERICA_WHITEHORSE;

        /// Raw, unparsed time zone data for Canada/Atlantic,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ATLANTIC: &[u8] = raw_tzdata::AMERICA_HALIFAX;

        /// Raw, unparsed time zone data for Canada/Central,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CENTRAL: &[u8] = raw_tzdata::AMERICA_WINNIPEG;

        /// Raw, unparsed time zone data for Canada/Eastern,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_EASTERN: &[u8] = raw_tzdata::AMERICA_TORONTO;

        /// Raw, unparsed time zone data for Canada/Mountain,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MOUNTAIN: &[u8] = raw_tzdata::AMERICA_EDMONTON;

        /// Raw, unparsed time zone data for Canada/Newfoundland,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NEWFOUNDLAND: &[u8] = raw_tzdata::AMERICA_ST_JOHNS;

        /// Raw, unparsed time zone data for Canada/Pacific,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PACIFIC: &[u8] = raw_tzdata::AMERICA_VANCOUVER;

        /// Raw, unparsed time zone data for Canada/Saskatchewan,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SASKATCHEWAN: &[u8] = raw_tzdata::AMERICA_REGINA;

        /// Raw, unparsed time zone data for Canada/Yukon,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_YUKON: &[u8] = raw_tzdata::AMERICA_WHITEHORSE;
    }

    /// chile
    pub mod chile {
        use super::*;

        /// Time zone data for Chile/Continental,
        pub const CONTINENTAL: TimeZoneRef<'static> = tzdata::AMERICA_SANTIAGO;

        /// Time zone data for Chile/EasterIsland,
        pub const EASTER_ISLAND: TimeZoneRef<'static> = tzdata::CHILE_EASTER_ISLAND;

        /// Raw, unparsed time zone data for Chile/Continental,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CONTINENTAL: &[u8] = raw_tzdata::AMERICA_SANTIAGO;

        /// Raw, unparsed time zone data for Chile/EasterIsland,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_EASTER_ISLAND: &[u8] = raw_tzdata::CHILE_EASTER_ISLAND;
    }

    /// etc
    pub mod etc {
        use super::*;

        /// Time zone data for Etc/GMT,
        pub const GMT: TimeZoneRef<'static> = tzdata::GMT;

        /// Time zone data for Etc/GMT0,
        pub const GMT_0: TimeZoneRef<'static> = tzdata::GMT;

        /// Time zone data for Etc/GMT-0,
        pub const GMT_MINUS_0: TimeZoneRef<'static> = tzdata::GMT;

        /// Time zone data for Etc/GMT-1,
        pub const GMT_MINUS_1: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_1;

        /// Time zone data for Etc/GMT-10,
        pub const GMT_MINUS_10: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_10;

        /// Time zone data for Etc/GMT-11,
        pub const GMT_MINUS_11: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_11;

        /// Time zone data for Etc/GMT-12,
        pub const GMT_MINUS_12: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_12;

        /// Time zone data for Etc/GMT-13,
        pub const GMT_MINUS_13: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_13;

        /// Time zone data for Etc/GMT-14,
        pub const GMT_MINUS_14: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_14;

        /// Time zone data for Etc/GMT-2,
        pub const GMT_MINUS_2: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_2;

        /// Time zone data for Etc/GMT-3,
        pub const GMT_MINUS_3: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_3;

        /// Time zone data for Etc/GMT-4,
        pub const GMT_MINUS_4: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_4;

        /// Time zone data for Etc/GMT-5,
        pub const GMT_MINUS_5: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_5;

        /// Time zone data for Etc/GMT-6,
        pub const GMT_MINUS_6: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_6;

        /// Time zone data for Etc/GMT-7,
        pub const GMT_MINUS_7: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_7;

        /// Time zone data for Etc/GMT-8,
        pub const GMT_MINUS_8: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_8;

        /// Time zone data for Etc/GMT-9,
        pub const GMT_MINUS_9: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_9;

        /// Time zone data for Etc/GMT+0,
        pub const GMT_PLUS_0: TimeZoneRef<'static> = tzdata::GMT;

        /// Time zone data for Etc/GMT+1,
        pub const GMT_PLUS_1: TimeZoneRef<'static> = tzdata::ATLANTIC_JAN_MAYEN;

        /// Time zone data for Etc/GMT+10,
        pub const GMT_PLUS_10: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_10;

        /// Time zone data for Etc/GMT+11,
        pub const GMT_PLUS_11: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_11;

        /// Time zone data for Etc/GMT+12,
        pub const GMT_PLUS_12: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_12;

        /// Time zone data for Etc/GMT+2,
        pub const GMT_PLUS_2: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_2;

        /// Time zone data for Etc/GMT+3,
        pub const GMT_PLUS_3: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_3;

        /// Time zone data for Etc/GMT+4,
        pub const GMT_PLUS_4: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_4;

        /// Time zone data for Etc/GMT+5,
        pub const GMT_PLUS_5: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_5;

        /// Time zone data for Etc/GMT+6,
        pub const GMT_PLUS_6: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_6;

        /// Time zone data for Etc/GMT+7,
        pub const GMT_PLUS_7: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_7;

        /// Time zone data for Etc/GMT+8,
        pub const GMT_PLUS_8: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_8;

        /// Time zone data for Etc/GMT+9,
        pub const GMT_PLUS_9: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_9;

        /// Time zone data for Etc/Greenwich,
        pub const GREENWICH: TimeZoneRef<'static> = tzdata::GMT;

        /// Time zone data for etc/localtime,
        pub const LOCALTIME: TimeZoneRef<'static> = tzdata::GMT;

        /// Time zone data for Etc/UCT,
        pub const UCT: TimeZoneRef<'static> = tzdata::UCT;

        /// Time zone data for Etc/Universal,
        pub const UNIVERSAL: TimeZoneRef<'static> = tzdata::UCT;

        /// Time zone data for Etc/UTC,
        pub const UTC: TimeZoneRef<'static> = tzdata::UCT;

        /// Time zone data for Etc/Zulu,
        pub const ZULU: TimeZoneRef<'static> = tzdata::UCT;

        /// Raw, unparsed time zone data for Etc/GMT,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT: &[u8] = raw_tzdata::GMT;

        /// Raw, unparsed time zone data for Etc/GMT0,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_0: &[u8] = raw_tzdata::GMT;

        /// Raw, unparsed time zone data for Etc/GMT-0,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_MINUS_0: &[u8] = raw_tzdata::GMT;

        /// Raw, unparsed time zone data for Etc/GMT-1,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_MINUS_1: &[u8] = raw_tzdata::ETC_GMT_MINUS_1;

        /// Raw, unparsed time zone data for Etc/GMT-10,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_MINUS_10: &[u8] = raw_tzdata::ETC_GMT_MINUS_10;

        /// Raw, unparsed time zone data for Etc/GMT-11,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_MINUS_11: &[u8] = raw_tzdata::ETC_GMT_MINUS_11;

        /// Raw, unparsed time zone data for Etc/GMT-12,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_MINUS_12: &[u8] = raw_tzdata::ETC_GMT_MINUS_12;

        /// Raw, unparsed time zone data for Etc/GMT-13,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_MINUS_13: &[u8] = raw_tzdata::ETC_GMT_MINUS_13;

        /// Raw, unparsed time zone data for Etc/GMT-14,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_MINUS_14: &[u8] = raw_tzdata::ETC_GMT_MINUS_14;

        /// Raw, unparsed time zone data for Etc/GMT-2,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_MINUS_2: &[u8] = raw_tzdata::ETC_GMT_MINUS_2;

        /// Raw, unparsed time zone data for Etc/GMT-3,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_MINUS_3: &[u8] = raw_tzdata::ETC_GMT_MINUS_3;

        /// Raw, unparsed time zone data for Etc/GMT-4,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_MINUS_4: &[u8] = raw_tzdata::ETC_GMT_MINUS_4;

        /// Raw, unparsed time zone data for Etc/GMT-5,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_MINUS_5: &[u8] = raw_tzdata::ETC_GMT_MINUS_5;

        /// Raw, unparsed time zone data for Etc/GMT-6,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_MINUS_6: &[u8] = raw_tzdata::ETC_GMT_MINUS_6;

        /// Raw, unparsed time zone data for Etc/GMT-7,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_MINUS_7: &[u8] = raw_tzdata::ETC_GMT_MINUS_7;

        /// Raw, unparsed time zone data for Etc/GMT-8,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_MINUS_8: &[u8] = raw_tzdata::ETC_GMT_MINUS_8;

        /// Raw, unparsed time zone data for Etc/GMT-9,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_MINUS_9: &[u8] = raw_tzdata::ETC_GMT_MINUS_9;

        /// Raw, unparsed time zone data for Etc/GMT+0,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_PLUS_0: &[u8] = raw_tzdata::GMT;

        /// Raw, unparsed time zone data for Etc/GMT+1,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_PLUS_1: &[u8] = raw_tzdata::ATLANTIC_JAN_MAYEN;

        /// Raw, unparsed time zone data for Etc/GMT+10,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_PLUS_10: &[u8] = raw_tzdata::ETC_GMT_PLUS_10;

        /// Raw, unparsed time zone data for Etc/GMT+11,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_PLUS_11: &[u8] = raw_tzdata::ETC_GMT_PLUS_11;

        /// Raw, unparsed time zone data for Etc/GMT+12,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_PLUS_12: &[u8] = raw_tzdata::ETC_GMT_PLUS_12;

        /// Raw, unparsed time zone data for Etc/GMT+2,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_PLUS_2: &[u8] = raw_tzdata::ETC_GMT_PLUS_2;

        /// Raw, unparsed time zone data for Etc/GMT+3,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_PLUS_3: &[u8] = raw_tzdata::ETC_GMT_PLUS_3;

        /// Raw, unparsed time zone data for Etc/GMT+4,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_PLUS_4: &[u8] = raw_tzdata::ETC_GMT_PLUS_4;

        /// Raw, unparsed time zone data for Etc/GMT+5,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_PLUS_5: &[u8] = raw_tzdata::ETC_GMT_PLUS_5;

        /// Raw, unparsed time zone data for Etc/GMT+6,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_PLUS_6: &[u8] = raw_tzdata::ETC_GMT_PLUS_6;

        /// Raw, unparsed time zone data for Etc/GMT+7,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_PLUS_7: &[u8] = raw_tzdata::ETC_GMT_PLUS_7;

        /// Raw, unparsed time zone data for Etc/GMT+8,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_PLUS_8: &[u8] = raw_tzdata::ETC_GMT_PLUS_8;

        /// Raw, unparsed time zone data for Etc/GMT+9,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GMT_PLUS_9: &[u8] = raw_tzdata::ETC_GMT_PLUS_9;

        /// Raw, unparsed time zone data for Etc/Greenwich,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GREENWICH: &[u8] = raw_tzdata::GMT;

        /// Raw, unparsed time zone data for etc/localtime,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LOCALTIME: &[u8] = raw_tzdata::GMT;

        /// Raw, unparsed time zone data for Etc/UCT,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_UCT: &[u8] = raw_tzdata::UCT;

        /// Raw, unparsed time zone data for Etc/Universal,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_UNIVERSAL: &[u8] = raw_tzdata::UCT;

        /// Raw, unparsed time zone data for Etc/UTC,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_UTC: &[u8] = raw_tzdata::UCT;

        /// Raw, unparsed time zone data for Etc/Zulu,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ZULU: &[u8] = raw_tzdata::UCT;
    }

    /// europe
    pub mod europe {
        use super::*;

        /// Time zone data for Europe/Amsterdam,
        pub const AMSTERDAM: TimeZoneRef<'static> = tzdata::EUROPE_AMSTERDAM;

        /// Time zone data for Europe/Andorra,
        pub const ANDORRA: TimeZoneRef<'static> = tzdata::EUROPE_ANDORRA;

        /// Time zone data for Europe/Astrakhan,
        pub const ASTRAKHAN: TimeZoneRef<'static> = tzdata::EUROPE_ASTRAKHAN;

        /// Time zone data for Europe/Athens,
        pub const ATHENS: TimeZoneRef<'static> = tzdata::EUROPE_ATHENS;

        /// Time zone data for Europe/Belfast,
        pub const BELFAST: TimeZoneRef<'static> = tzdata::EUROPE_BELFAST;

        /// Time zone data for Europe/Belgrade,
        pub const BELGRADE: TimeZoneRef<'static> = tzdata::EUROPE_BELGRADE;

        /// Time zone data for Europe/Berlin,
        pub const BERLIN: TimeZoneRef<'static> = tzdata::EUROPE_BERLIN;

        /// Time zone data for Europe/Bratislava,
        pub const BRATISLAVA: TimeZoneRef<'static> = tzdata::EUROPE_BRATISLAVA;

        /// Time zone data for Europe/Brussels,
        pub const BRUSSELS: TimeZoneRef<'static> = tzdata::EUROPE_BRUSSELS;

        /// Time zone data for Europe/Bucharest,
        pub const BUCHAREST: TimeZoneRef<'static> = tzdata::EUROPE_BUCHAREST;

        /// Time zone data for Europe/Budapest,
        pub const BUDAPEST: TimeZoneRef<'static> = tzdata::EUROPE_BUDAPEST;

        /// Time zone data for Europe/Busingen,
        pub const BUSINGEN: TimeZoneRef<'static> = tzdata::EUROPE_BUSINGEN;

        /// Time zone data for Europe/Chisinau,
        pub const CHISINAU: TimeZoneRef<'static> = tzdata::EUROPE_CHISINAU;

        /// Time zone data for Europe/Copenhagen,
        pub const COPENHAGEN: TimeZoneRef<'static> = tzdata::EUROPE_COPENHAGEN;

        /// Time zone data for Europe/Dublin,
        pub const DUBLIN: TimeZoneRef<'static> = tzdata::EIRE;

        /// Time zone data for Europe/Gibraltar,
        pub const GIBRALTAR: TimeZoneRef<'static> = tzdata::EUROPE_GIBRALTAR;

        /// Time zone data for Europe/Guernsey,
        pub const GUERNSEY: TimeZoneRef<'static> = tzdata::EUROPE_GUERNSEY;

        /// Time zone data for Europe/Helsinki,
        pub const HELSINKI: TimeZoneRef<'static> = tzdata::EUROPE_HELSINKI;

        /// Time zone data for Europe/Isle_of_Man,
        pub const ISLE_OF_MAN: TimeZoneRef<'static> = tzdata::EUROPE_ISLE_OF_MAN;

        /// Time zone data for Europe/Istanbul,
        pub const ISTANBUL: TimeZoneRef<'static> = tzdata::TURKEY;

        /// Time zone data for Europe/Jersey,
        pub const JERSEY: TimeZoneRef<'static> = tzdata::EUROPE_JERSEY;

        /// Time zone data for Europe/Kaliningrad,
        pub const KALININGRAD: TimeZoneRef<'static> = tzdata::EUROPE_KALININGRAD;

        /// Time zone data for Europe/Kiev,
        pub const KIEV: TimeZoneRef<'static> = tzdata::EUROPE_KIEV;

        /// Time zone data for Europe/Kirov,
        pub const KIROV: TimeZoneRef<'static> = tzdata::EUROPE_KIROV;

        /// Time zone data for Europe/Lisbon,
        pub const LISBON: TimeZoneRef<'static> = tzdata::PORTUGAL;

        /// Time zone data for Europe/Ljubljana,
        pub const LJUBLJANA: TimeZoneRef<'static> = tzdata::EUROPE_LJUBLJANA;

        /// Time zone data for Europe/London,
        pub const LONDON: TimeZoneRef<'static> = tzdata::GB;

        /// Time zone data for Europe/Luxembourg,
        pub const LUXEMBOURG: TimeZoneRef<'static> = tzdata::EUROPE_LUXEMBOURG;

        /// Time zone data for Europe/Madrid,
        pub const MADRID: TimeZoneRef<'static> = tzdata::EUROPE_MADRID;

        /// Time zone data for Europe/Malta,
        pub const MALTA: TimeZoneRef<'static> = tzdata::EUROPE_MALTA;

        /// Time zone data for Europe/Mariehamn,
        pub const MARIEHAMN: TimeZoneRef<'static> = tzdata::EUROPE_HELSINKI;

        /// Time zone data for Europe/Minsk,
        pub const MINSK: TimeZoneRef<'static> = tzdata::EUROPE_MINSK;

        /// Time zone data for Europe/Monaco,
        pub const MONACO: TimeZoneRef<'static> = tzdata::EUROPE_MONACO;

        /// Time zone data for Europe/Moscow,
        pub const MOSCOW: TimeZoneRef<'static> = tzdata::W_SU;

        /// Time zone data for Europe/Nicosia,
        pub const NICOSIA: TimeZoneRef<'static> = tzdata::ASIA_NICOSIA;

        /// Time zone data for Europe/Oslo,
        pub const OSLO: TimeZoneRef<'static> = tzdata::ARCTIC_LONGYEARBYEN;

        /// Time zone data for Europe/Paris,
        pub const PARIS: TimeZoneRef<'static> = tzdata::EUROPE_PARIS;

        /// Time zone data for Europe/Podgorica,
        pub const PODGORICA: TimeZoneRef<'static> = tzdata::EUROPE_BELGRADE;

        /// Time zone data for Europe/Prague,
        pub const PRAGUE: TimeZoneRef<'static> = tzdata::EUROPE_BRATISLAVA;

        /// Time zone data for Europe/Riga,
        pub const RIGA: TimeZoneRef<'static> = tzdata::EUROPE_RIGA;

        /// Time zone data for Europe/Rome,
        pub const ROME: TimeZoneRef<'static> = tzdata::EUROPE_ROME;

        /// Time zone data for Europe/Samara,
        pub const SAMARA: TimeZoneRef<'static> = tzdata::EUROPE_SAMARA;

        /// Time zone data for Europe/San_Marino,
        pub const SAN_MARINO: TimeZoneRef<'static> = tzdata::EUROPE_ROME;

        /// Time zone data for Europe/Sarajevo,
        pub const SARAJEVO: TimeZoneRef<'static> = tzdata::EUROPE_SARAJEVO;

        /// Time zone data for Europe/Saratov,
        pub const SARATOV: TimeZoneRef<'static> = tzdata::EUROPE_SARATOV;

        /// Time zone data for Europe/Simferopol,
        pub const SIMFEROPOL: TimeZoneRef<'static> = tzdata::EUROPE_SIMFEROPOL;

        /// Time zone data for Europe/Skopje,
        pub const SKOPJE: TimeZoneRef<'static> = tzdata::EUROPE_SKOPJE;

        /// Time zone data for Europe/Sofia,
        pub const SOFIA: TimeZoneRef<'static> = tzdata::EUROPE_SOFIA;

        /// Time zone data for Europe/Stockholm,
        pub const STOCKHOLM: TimeZoneRef<'static> = tzdata::EUROPE_STOCKHOLM;

        /// Time zone data for Europe/Tallinn,
        pub const TALLINN: TimeZoneRef<'static> = tzdata::EUROPE_TALLINN;

        /// Time zone data for Europe/Tirane,
        pub const TIRANE: TimeZoneRef<'static> = tzdata::EUROPE_TIRANE;

        /// Time zone data for Europe/Tiraspol,
        pub const TIRASPOL: TimeZoneRef<'static> = tzdata::EUROPE_TIRASPOL;

        /// Time zone data for Europe/Ulyanovsk,
        pub const ULYANOVSK: TimeZoneRef<'static> = tzdata::EUROPE_ULYANOVSK;

        /// Time zone data for Europe/Uzhgorod,
        pub const UZHGOROD: TimeZoneRef<'static> = tzdata::EUROPE_UZHGOROD;

        /// Time zone data for Europe/Vaduz,
        pub const VADUZ: TimeZoneRef<'static> = tzdata::EUROPE_VADUZ;

        /// Time zone data for Europe/Vatican,
        pub const VATICAN: TimeZoneRef<'static> = tzdata::EUROPE_ROME;

        /// Time zone data for Europe/Vienna,
        pub const VIENNA: TimeZoneRef<'static> = tzdata::EUROPE_VIENNA;

        /// Time zone data for Europe/Vilnius,
        pub const VILNIUS: TimeZoneRef<'static> = tzdata::EUROPE_VILNIUS;

        /// Time zone data for Europe/Volgograd,
        pub const VOLGOGRAD: TimeZoneRef<'static> = tzdata::EUROPE_VOLGOGRAD;

        /// Time zone data for Europe/Warsaw,
        pub const WARSAW: TimeZoneRef<'static> = tzdata::POLAND;

        /// Time zone data for Europe/Zagreb,
        pub const ZAGREB: TimeZoneRef<'static> = tzdata::EUROPE_ZAGREB;

        /// Time zone data for Europe/Zaporozhye,
        pub const ZAPOROZHYE: TimeZoneRef<'static> = tzdata::EUROPE_ZAPOROZHYE;

        /// Time zone data for Europe/Zurich,
        pub const ZURICH: TimeZoneRef<'static> = tzdata::EUROPE_BUSINGEN;

        /// Raw, unparsed time zone data for Europe/Amsterdam,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_AMSTERDAM: &[u8] = raw_tzdata::EUROPE_AMSTERDAM;

        /// Raw, unparsed time zone data for Europe/Andorra,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ANDORRA: &[u8] = raw_tzdata::EUROPE_ANDORRA;

        /// Raw, unparsed time zone data for Europe/Astrakhan,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ASTRAKHAN: &[u8] = raw_tzdata::EUROPE_ASTRAKHAN;

        /// Raw, unparsed time zone data for Europe/Athens,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ATHENS: &[u8] = raw_tzdata::EUROPE_ATHENS;

        /// Raw, unparsed time zone data for Europe/Belfast,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BELFAST: &[u8] = raw_tzdata::EUROPE_BELFAST;

        /// Raw, unparsed time zone data for Europe/Belgrade,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BELGRADE: &[u8] = raw_tzdata::EUROPE_BELGRADE;

        /// Raw, unparsed time zone data for Europe/Berlin,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BERLIN: &[u8] = raw_tzdata::EUROPE_BERLIN;

        /// Raw, unparsed time zone data for Europe/Bratislava,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BRATISLAVA: &[u8] = raw_tzdata::EUROPE_BRATISLAVA;

        /// Raw, unparsed time zone data for Europe/Brussels,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BRUSSELS: &[u8] = raw_tzdata::EUROPE_BRUSSELS;

        /// Raw, unparsed time zone data for Europe/Bucharest,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BUCHAREST: &[u8] = raw_tzdata::EUROPE_BUCHAREST;

        /// Raw, unparsed time zone data for Europe/Budapest,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BUDAPEST: &[u8] = raw_tzdata::EUROPE_BUDAPEST;

        /// Raw, unparsed time zone data for Europe/Busingen,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BUSINGEN: &[u8] = raw_tzdata::EUROPE_BUSINGEN;

        /// Raw, unparsed time zone data for Europe/Chisinau,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CHISINAU: &[u8] = raw_tzdata::EUROPE_CHISINAU;

        /// Raw, unparsed time zone data for Europe/Copenhagen,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_COPENHAGEN: &[u8] = raw_tzdata::EUROPE_COPENHAGEN;

        /// Raw, unparsed time zone data for Europe/Dublin,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_DUBLIN: &[u8] = raw_tzdata::EIRE;

        /// Raw, unparsed time zone data for Europe/Gibraltar,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GIBRALTAR: &[u8] = raw_tzdata::EUROPE_GIBRALTAR;

        /// Raw, unparsed time zone data for Europe/Guernsey,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GUERNSEY: &[u8] = raw_tzdata::EUROPE_GUERNSEY;

        /// Raw, unparsed time zone data for Europe/Helsinki,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_HELSINKI: &[u8] = raw_tzdata::EUROPE_HELSINKI;

        /// Raw, unparsed time zone data for Europe/Isle_of_Man,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ISLE_OF_MAN: &[u8] = raw_tzdata::EUROPE_ISLE_OF_MAN;

        /// Raw, unparsed time zone data for Europe/Istanbul,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ISTANBUL: &[u8] = raw_tzdata::TURKEY;

        /// Raw, unparsed time zone data for Europe/Jersey,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_JERSEY: &[u8] = raw_tzdata::EUROPE_JERSEY;

        /// Raw, unparsed time zone data for Europe/Kaliningrad,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KALININGRAD: &[u8] = raw_tzdata::EUROPE_KALININGRAD;

        /// Raw, unparsed time zone data for Europe/Kiev,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KIEV: &[u8] = raw_tzdata::EUROPE_KIEV;

        /// Raw, unparsed time zone data for Europe/Kirov,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KIROV: &[u8] = raw_tzdata::EUROPE_KIROV;

        /// Raw, unparsed time zone data for Europe/Lisbon,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LISBON: &[u8] = raw_tzdata::PORTUGAL;

        /// Raw, unparsed time zone data for Europe/Ljubljana,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LJUBLJANA: &[u8] = raw_tzdata::EUROPE_LJUBLJANA;

        /// Raw, unparsed time zone data for Europe/London,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LONDON: &[u8] = raw_tzdata::GB;

        /// Raw, unparsed time zone data for Europe/Luxembourg,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_LUXEMBOURG: &[u8] = raw_tzdata::EUROPE_LUXEMBOURG;

        /// Raw, unparsed time zone data for Europe/Madrid,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MADRID: &[u8] = raw_tzdata::EUROPE_MADRID;

        /// Raw, unparsed time zone data for Europe/Malta,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MALTA: &[u8] = raw_tzdata::EUROPE_MALTA;

        /// Raw, unparsed time zone data for Europe/Mariehamn,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MARIEHAMN: &[u8] = raw_tzdata::EUROPE_HELSINKI;

        /// Raw, unparsed time zone data for Europe/Minsk,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MINSK: &[u8] = raw_tzdata::EUROPE_MINSK;

        /// Raw, unparsed time zone data for Europe/Monaco,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MONACO: &[u8] = raw_tzdata::EUROPE_MONACO;

        /// Raw, unparsed time zone data for Europe/Moscow,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MOSCOW: &[u8] = raw_tzdata::W_SU;

        /// Raw, unparsed time zone data for Europe/Nicosia,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NICOSIA: &[u8] = raw_tzdata::ASIA_NICOSIA;

        /// Raw, unparsed time zone data for Europe/Oslo,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_OSLO: &[u8] = raw_tzdata::ARCTIC_LONGYEARBYEN;

        /// Raw, unparsed time zone data for Europe/Paris,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PARIS: &[u8] = raw_tzdata::EUROPE_PARIS;

        /// Raw, unparsed time zone data for Europe/Podgorica,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PODGORICA: &[u8] = raw_tzdata::EUROPE_BELGRADE;

        /// Raw, unparsed time zone data for Europe/Prague,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PRAGUE: &[u8] = raw_tzdata::EUROPE_BRATISLAVA;

        /// Raw, unparsed time zone data for Europe/Riga,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_RIGA: &[u8] = raw_tzdata::EUROPE_RIGA;

        /// Raw, unparsed time zone data for Europe/Rome,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ROME: &[u8] = raw_tzdata::EUROPE_ROME;

        /// Raw, unparsed time zone data for Europe/Samara,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SAMARA: &[u8] = raw_tzdata::EUROPE_SAMARA;

        /// Raw, unparsed time zone data for Europe/San_Marino,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SAN_MARINO: &[u8] = raw_tzdata::EUROPE_ROME;

        /// Raw, unparsed time zone data for Europe/Sarajevo,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SARAJEVO: &[u8] = raw_tzdata::EUROPE_SARAJEVO;

        /// Raw, unparsed time zone data for Europe/Saratov,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SARATOV: &[u8] = raw_tzdata::EUROPE_SARATOV;

        /// Raw, unparsed time zone data for Europe/Simferopol,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SIMFEROPOL: &[u8] = raw_tzdata::EUROPE_SIMFEROPOL;

        /// Raw, unparsed time zone data for Europe/Skopje,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SKOPJE: &[u8] = raw_tzdata::EUROPE_SKOPJE;

        /// Raw, unparsed time zone data for Europe/Sofia,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SOFIA: &[u8] = raw_tzdata::EUROPE_SOFIA;

        /// Raw, unparsed time zone data for Europe/Stockholm,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_STOCKHOLM: &[u8] = raw_tzdata::EUROPE_STOCKHOLM;

        /// Raw, unparsed time zone data for Europe/Tallinn,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TALLINN: &[u8] = raw_tzdata::EUROPE_TALLINN;

        /// Raw, unparsed time zone data for Europe/Tirane,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TIRANE: &[u8] = raw_tzdata::EUROPE_TIRANE;

        /// Raw, unparsed time zone data for Europe/Tiraspol,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TIRASPOL: &[u8] = raw_tzdata::EUROPE_TIRASPOL;

        /// Raw, unparsed time zone data for Europe/Ulyanovsk,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ULYANOVSK: &[u8] = raw_tzdata::EUROPE_ULYANOVSK;

        /// Raw, unparsed time zone data for Europe/Uzhgorod,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_UZHGOROD: &[u8] = raw_tzdata::EUROPE_UZHGOROD;

        /// Raw, unparsed time zone data for Europe/Vaduz,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_VADUZ: &[u8] = raw_tzdata::EUROPE_VADUZ;

        /// Raw, unparsed time zone data for Europe/Vatican,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_VATICAN: &[u8] = raw_tzdata::EUROPE_ROME;

        /// Raw, unparsed time zone data for Europe/Vienna,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_VIENNA: &[u8] = raw_tzdata::EUROPE_VIENNA;

        /// Raw, unparsed time zone data for Europe/Vilnius,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_VILNIUS: &[u8] = raw_tzdata::EUROPE_VILNIUS;

        /// Raw, unparsed time zone data for Europe/Volgograd,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_VOLGOGRAD: &[u8] = raw_tzdata::EUROPE_VOLGOGRAD;

        /// Raw, unparsed time zone data for Europe/Warsaw,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_WARSAW: &[u8] = raw_tzdata::POLAND;

        /// Raw, unparsed time zone data for Europe/Zagreb,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ZAGREB: &[u8] = raw_tzdata::EUROPE_ZAGREB;

        /// Raw, unparsed time zone data for Europe/Zaporozhye,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ZAPOROZHYE: &[u8] = raw_tzdata::EUROPE_ZAPOROZHYE;

        /// Raw, unparsed time zone data for Europe/Zurich,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ZURICH: &[u8] = raw_tzdata::EUROPE_BUSINGEN;
    }

    /// indian
    pub mod indian {
        use super::*;

        /// Time zone data for Indian/Antananarivo,
        pub const ANTANANARIVO: TimeZoneRef<'static> = tzdata::INDIAN_ANTANANARIVO;

        /// Time zone data for Indian/Chagos,
        pub const CHAGOS: TimeZoneRef<'static> = tzdata::INDIAN_CHAGOS;

        /// Time zone data for Indian/Christmas,
        pub const CHRISTMAS: TimeZoneRef<'static> = tzdata::INDIAN_CHRISTMAS;

        /// Time zone data for Indian/Cocos,
        pub const COCOS: TimeZoneRef<'static> = tzdata::INDIAN_COCOS;

        /// Time zone data for Indian/Comoro,
        pub const COMORO: TimeZoneRef<'static> = tzdata::INDIAN_COMORO;

        /// Time zone data for Indian/Kerguelen,
        pub const KERGUELEN: TimeZoneRef<'static> = tzdata::INDIAN_KERGUELEN;

        /// Time zone data for Indian/Mahe,
        pub const MAHE: TimeZoneRef<'static> = tzdata::INDIAN_MAHE;

        /// Time zone data for Indian/Maldives,
        pub const MALDIVES: TimeZoneRef<'static> = tzdata::INDIAN_MALDIVES;

        /// Time zone data for Indian/Mauritius,
        pub const MAURITIUS: TimeZoneRef<'static> = tzdata::INDIAN_MAURITIUS;

        /// Time zone data for Indian/Mayotte,
        pub const MAYOTTE: TimeZoneRef<'static> = tzdata::INDIAN_MAYOTTE;

        /// Time zone data for Indian/Reunion,
        pub const REUNION: TimeZoneRef<'static> = tzdata::INDIAN_REUNION;

        /// Raw, unparsed time zone data for Indian/Antananarivo,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ANTANANARIVO: &[u8] = raw_tzdata::INDIAN_ANTANANARIVO;

        /// Raw, unparsed time zone data for Indian/Chagos,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CHAGOS: &[u8] = raw_tzdata::INDIAN_CHAGOS;

        /// Raw, unparsed time zone data for Indian/Christmas,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CHRISTMAS: &[u8] = raw_tzdata::INDIAN_CHRISTMAS;

        /// Raw, unparsed time zone data for Indian/Cocos,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_COCOS: &[u8] = raw_tzdata::INDIAN_COCOS;

        /// Raw, unparsed time zone data for Indian/Comoro,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_COMORO: &[u8] = raw_tzdata::INDIAN_COMORO;

        /// Raw, unparsed time zone data for Indian/Kerguelen,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KERGUELEN: &[u8] = raw_tzdata::INDIAN_KERGUELEN;

        /// Raw, unparsed time zone data for Indian/Mahe,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MAHE: &[u8] = raw_tzdata::INDIAN_MAHE;

        /// Raw, unparsed time zone data for Indian/Maldives,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MALDIVES: &[u8] = raw_tzdata::INDIAN_MALDIVES;

        /// Raw, unparsed time zone data for Indian/Mauritius,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MAURITIUS: &[u8] = raw_tzdata::INDIAN_MAURITIUS;

        /// Raw, unparsed time zone data for Indian/Mayotte,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MAYOTTE: &[u8] = raw_tzdata::INDIAN_MAYOTTE;

        /// Raw, unparsed time zone data for Indian/Reunion,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_REUNION: &[u8] = raw_tzdata::INDIAN_REUNION;
    }

    /// mexico
    pub mod mexico {
        use super::*;

        /// Time zone data for Mexico/BajaNorte,
        pub const BAJA_NORTE: TimeZoneRef<'static> = tzdata::AMERICA_SANTA_ISABEL;

        /// Time zone data for Mexico/BajaSur,
        pub const BAJA_SUR: TimeZoneRef<'static> = tzdata::AMERICA_MAZATLAN;

        /// Time zone data for Mexico/General,
        pub const GENERAL: TimeZoneRef<'static> = tzdata::AMERICA_MEXICO_CITY;

        /// Raw, unparsed time zone data for Mexico/BajaNorte,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BAJA_NORTE: &[u8] = raw_tzdata::AMERICA_SANTA_ISABEL;

        /// Raw, unparsed time zone data for Mexico/BajaSur,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BAJA_SUR: &[u8] = raw_tzdata::AMERICA_MAZATLAN;

        /// Raw, unparsed time zone data for Mexico/General,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GENERAL: &[u8] = raw_tzdata::AMERICA_MEXICO_CITY;
    }

    /// pacific
    pub mod pacific {
        use super::*;

        /// Time zone data for Pacific/Apia,
        pub const APIA: TimeZoneRef<'static> = tzdata::PACIFIC_APIA;

        /// Time zone data for Pacific/Auckland,
        pub const AUCKLAND: TimeZoneRef<'static> = tzdata::NZ;

        /// Time zone data for Pacific/Bougainville,
        pub const BOUGAINVILLE: TimeZoneRef<'static> = tzdata::PACIFIC_BOUGAINVILLE;

        /// Time zone data for Pacific/Chatham,
        pub const CHATHAM: TimeZoneRef<'static> = tzdata::NZ_CHAT;

        /// Time zone data for Pacific/Chuuk,
        pub const CHUUK: TimeZoneRef<'static> = tzdata::PACIFIC_CHUUK;

        /// Time zone data for Pacific/Easter,
        pub const EASTER: TimeZoneRef<'static> = tzdata::CHILE_EASTER_ISLAND;

        /// Time zone data for Pacific/Efate,
        pub const EFATE: TimeZoneRef<'static> = tzdata::PACIFIC_EFATE;

        /// Time zone data for Pacific/Enderbury,
        pub const ENDERBURY: TimeZoneRef<'static> = tzdata::PACIFIC_ENDERBURY;

        /// Time zone data for Pacific/Fakaofo,
        pub const FAKAOFO: TimeZoneRef<'static> = tzdata::PACIFIC_FAKAOFO;

        /// Time zone data for Pacific/Fiji,
        pub const FIJI: TimeZoneRef<'static> = tzdata::PACIFIC_FIJI;

        /// Time zone data for Pacific/Funafuti,
        pub const FUNAFUTI: TimeZoneRef<'static> = tzdata::PACIFIC_FUNAFUTI;

        /// Time zone data for Pacific/Galapagos,
        pub const GALAPAGOS: TimeZoneRef<'static> = tzdata::PACIFIC_GALAPAGOS;

        /// Time zone data for Pacific/Gambier,
        pub const GAMBIER: TimeZoneRef<'static> = tzdata::PACIFIC_GAMBIER;

        /// Time zone data for Pacific/Guadalcanal,
        pub const GUADALCANAL: TimeZoneRef<'static> = tzdata::PACIFIC_GUADALCANAL;

        /// Time zone data for Pacific/Guam,
        pub const GUAM: TimeZoneRef<'static> = tzdata::PACIFIC_GUAM;

        /// Time zone data for Pacific/Honolulu,
        pub const HONOLULU: TimeZoneRef<'static> = tzdata::PACIFIC_HONOLULU;

        /// Time zone data for Pacific/Johnston,
        pub const JOHNSTON: TimeZoneRef<'static> = tzdata::HST;

        /// Time zone data for Pacific/Kanton,
        pub const KANTON: TimeZoneRef<'static> = tzdata::PACIFIC_KANTON;

        /// Time zone data for Pacific/Kiritimati,
        pub const KIRITIMATI: TimeZoneRef<'static> = tzdata::PACIFIC_KIRITIMATI;

        /// Time zone data for Pacific/Kosrae,
        pub const KOSRAE: TimeZoneRef<'static> = tzdata::PACIFIC_KOSRAE;

        /// Time zone data for Pacific/Kwajalein,
        pub const KWAJALEIN: TimeZoneRef<'static> = tzdata::KWAJALEIN;

        /// Time zone data for Pacific/Majuro,
        pub const MAJURO: TimeZoneRef<'static> = tzdata::PACIFIC_MAJURO;

        /// Time zone data for Pacific/Marquesas,
        pub const MARQUESAS: TimeZoneRef<'static> = tzdata::PACIFIC_MARQUESAS;

        /// Time zone data for Pacific/Midway,
        pub const MIDWAY: TimeZoneRef<'static> = tzdata::PACIFIC_MIDWAY;

        /// Time zone data for Pacific/Nauru,
        pub const NAURU: TimeZoneRef<'static> = tzdata::PACIFIC_NAURU;

        /// Time zone data for Pacific/Niue,
        pub const NIUE: TimeZoneRef<'static> = tzdata::PACIFIC_NIUE;

        /// Time zone data for Pacific/Norfolk,
        pub const NORFOLK: TimeZoneRef<'static> = tzdata::PACIFIC_NORFOLK;

        /// Time zone data for Pacific/Noumea,
        pub const NOUMEA: TimeZoneRef<'static> = tzdata::PACIFIC_NOUMEA;

        /// Time zone data for Pacific/Pago_Pago,
        pub const PAGO_PAGO: TimeZoneRef<'static> = tzdata::PACIFIC_PAGO_PAGO;

        /// Time zone data for Pacific/Palau,
        pub const PALAU: TimeZoneRef<'static> = tzdata::PACIFIC_PALAU;

        /// Time zone data for Pacific/Pitcairn,
        pub const PITCAIRN: TimeZoneRef<'static> = tzdata::PACIFIC_PITCAIRN;

        /// Time zone data for Pacific/Pohnpei,
        pub const POHNPEI: TimeZoneRef<'static> = tzdata::PACIFIC_POHNPEI;

        /// Time zone data for Pacific/Ponape,
        pub const PONAPE: TimeZoneRef<'static> = tzdata::PACIFIC_POHNPEI;

        /// Time zone data for Pacific/Port_Moresby,
        pub const PORT_MORESBY: TimeZoneRef<'static> = tzdata::PACIFIC_PORT_MORESBY;

        /// Time zone data for Pacific/Rarotonga,
        pub const RAROTONGA: TimeZoneRef<'static> = tzdata::PACIFIC_RAROTONGA;

        /// Time zone data for Pacific/Saipan,
        pub const SAIPAN: TimeZoneRef<'static> = tzdata::PACIFIC_SAIPAN;

        /// Time zone data for Pacific/Samoa,
        pub const SAMOA: TimeZoneRef<'static> = tzdata::PACIFIC_PAGO_PAGO;

        /// Time zone data for Pacific/Tahiti,
        pub const TAHITI: TimeZoneRef<'static> = tzdata::PACIFIC_TAHITI;

        /// Time zone data for Pacific/Tarawa,
        pub const TARAWA: TimeZoneRef<'static> = tzdata::PACIFIC_TARAWA;

        /// Time zone data for Pacific/Tongatapu,
        pub const TONGATAPU: TimeZoneRef<'static> = tzdata::PACIFIC_TONGATAPU;

        /// Time zone data for Pacific/Truk,
        pub const TRUK: TimeZoneRef<'static> = tzdata::PACIFIC_CHUUK;

        /// Time zone data for Pacific/Wake,
        pub const WAKE: TimeZoneRef<'static> = tzdata::PACIFIC_WAKE;

        /// Time zone data for Pacific/Wallis,
        pub const WALLIS: TimeZoneRef<'static> = tzdata::PACIFIC_WALLIS;

        /// Time zone data for Pacific/Yap,
        pub const YAP: TimeZoneRef<'static> = tzdata::PACIFIC_CHUUK;

        /// Raw, unparsed time zone data for Pacific/Apia,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_APIA: &[u8] = raw_tzdata::PACIFIC_APIA;

        /// Raw, unparsed time zone data for Pacific/Auckland,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_AUCKLAND: &[u8] = raw_tzdata::NZ;

        /// Raw, unparsed time zone data for Pacific/Bougainville,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_BOUGAINVILLE: &[u8] = raw_tzdata::PACIFIC_BOUGAINVILLE;

        /// Raw, unparsed time zone data for Pacific/Chatham,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CHATHAM: &[u8] = raw_tzdata::NZ_CHAT;

        /// Raw, unparsed time zone data for Pacific/Chuuk,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CHUUK: &[u8] = raw_tzdata::PACIFIC_CHUUK;

        /// Raw, unparsed time zone data for Pacific/Easter,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_EASTER: &[u8] = raw_tzdata::CHILE_EASTER_ISLAND;

        /// Raw, unparsed time zone data for Pacific/Efate,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_EFATE: &[u8] = raw_tzdata::PACIFIC_EFATE;

        /// Raw, unparsed time zone data for Pacific/Enderbury,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ENDERBURY: &[u8] = raw_tzdata::PACIFIC_ENDERBURY;

        /// Raw, unparsed time zone data for Pacific/Fakaofo,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_FAKAOFO: &[u8] = raw_tzdata::PACIFIC_FAKAOFO;

        /// Raw, unparsed time zone data for Pacific/Fiji,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_FIJI: &[u8] = raw_tzdata::PACIFIC_FIJI;

        /// Raw, unparsed time zone data for Pacific/Funafuti,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_FUNAFUTI: &[u8] = raw_tzdata::PACIFIC_FUNAFUTI;

        /// Raw, unparsed time zone data for Pacific/Galapagos,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GALAPAGOS: &[u8] = raw_tzdata::PACIFIC_GALAPAGOS;

        /// Raw, unparsed time zone data for Pacific/Gambier,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GAMBIER: &[u8] = raw_tzdata::PACIFIC_GAMBIER;

        /// Raw, unparsed time zone data for Pacific/Guadalcanal,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GUADALCANAL: &[u8] = raw_tzdata::PACIFIC_GUADALCANAL;

        /// Raw, unparsed time zone data for Pacific/Guam,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_GUAM: &[u8] = raw_tzdata::PACIFIC_GUAM;

        /// Raw, unparsed time zone data for Pacific/Honolulu,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_HONOLULU: &[u8] = raw_tzdata::PACIFIC_HONOLULU;

        /// Raw, unparsed time zone data for Pacific/Johnston,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_JOHNSTON: &[u8] = raw_tzdata::HST;

        /// Raw, unparsed time zone data for Pacific/Kanton,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KANTON: &[u8] = raw_tzdata::PACIFIC_KANTON;

        /// Raw, unparsed time zone data for Pacific/Kiritimati,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KIRITIMATI: &[u8] = raw_tzdata::PACIFIC_KIRITIMATI;

        /// Raw, unparsed time zone data for Pacific/Kosrae,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KOSRAE: &[u8] = raw_tzdata::PACIFIC_KOSRAE;

        /// Raw, unparsed time zone data for Pacific/Kwajalein,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_KWAJALEIN: &[u8] = raw_tzdata::KWAJALEIN;

        /// Raw, unparsed time zone data for Pacific/Majuro,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MAJURO: &[u8] = raw_tzdata::PACIFIC_MAJURO;

        /// Raw, unparsed time zone data for Pacific/Marquesas,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MARQUESAS: &[u8] = raw_tzdata::PACIFIC_MARQUESAS;

        /// Raw, unparsed time zone data for Pacific/Midway,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MIDWAY: &[u8] = raw_tzdata::PACIFIC_MIDWAY;

        /// Raw, unparsed time zone data for Pacific/Nauru,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NAURU: &[u8] = raw_tzdata::PACIFIC_NAURU;

        /// Raw, unparsed time zone data for Pacific/Niue,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NIUE: &[u8] = raw_tzdata::PACIFIC_NIUE;

        /// Raw, unparsed time zone data for Pacific/Norfolk,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NORFOLK: &[u8] = raw_tzdata::PACIFIC_NORFOLK;

        /// Raw, unparsed time zone data for Pacific/Noumea,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_NOUMEA: &[u8] = raw_tzdata::PACIFIC_NOUMEA;

        /// Raw, unparsed time zone data for Pacific/Pago_Pago,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PAGO_PAGO: &[u8] = raw_tzdata::PACIFIC_PAGO_PAGO;

        /// Raw, unparsed time zone data for Pacific/Palau,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PALAU: &[u8] = raw_tzdata::PACIFIC_PALAU;

        /// Raw, unparsed time zone data for Pacific/Pitcairn,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PITCAIRN: &[u8] = raw_tzdata::PACIFIC_PITCAIRN;

        /// Raw, unparsed time zone data for Pacific/Pohnpei,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_POHNPEI: &[u8] = raw_tzdata::PACIFIC_POHNPEI;

        /// Raw, unparsed time zone data for Pacific/Ponape,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PONAPE: &[u8] = raw_tzdata::PACIFIC_POHNPEI;

        /// Raw, unparsed time zone data for Pacific/Port_Moresby,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PORT_MORESBY: &[u8] = raw_tzdata::PACIFIC_PORT_MORESBY;

        /// Raw, unparsed time zone data for Pacific/Rarotonga,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_RAROTONGA: &[u8] = raw_tzdata::PACIFIC_RAROTONGA;

        /// Raw, unparsed time zone data for Pacific/Saipan,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SAIPAN: &[u8] = raw_tzdata::PACIFIC_SAIPAN;

        /// Raw, unparsed time zone data for Pacific/Samoa,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SAMOA: &[u8] = raw_tzdata::PACIFIC_PAGO_PAGO;

        /// Raw, unparsed time zone data for Pacific/Tahiti,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TAHITI: &[u8] = raw_tzdata::PACIFIC_TAHITI;

        /// Raw, unparsed time zone data for Pacific/Tarawa,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TARAWA: &[u8] = raw_tzdata::PACIFIC_TARAWA;

        /// Raw, unparsed time zone data for Pacific/Tongatapu,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TONGATAPU: &[u8] = raw_tzdata::PACIFIC_TONGATAPU;

        /// Raw, unparsed time zone data for Pacific/Truk,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_TRUK: &[u8] = raw_tzdata::PACIFIC_CHUUK;

        /// Raw, unparsed time zone data for Pacific/Wake,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_WAKE: &[u8] = raw_tzdata::PACIFIC_WAKE;

        /// Raw, unparsed time zone data for Pacific/Wallis,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_WALLIS: &[u8] = raw_tzdata::PACIFIC_WALLIS;

        /// Raw, unparsed time zone data for Pacific/Yap,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_YAP: &[u8] = raw_tzdata::PACIFIC_CHUUK;
    }

    /// us
    pub mod us {
        use super::*;

        /// Time zone data for US/Alaska,
        pub const ALASKA: TimeZoneRef<'static> = tzdata::AMERICA_ANCHORAGE;

        /// Time zone data for US/Aleutian,
        pub const ALEUTIAN: TimeZoneRef<'static> = tzdata::AMERICA_ADAK;

        /// Time zone data for US/Arizona,
        pub const ARIZONA: TimeZoneRef<'static> = tzdata::AMERICA_PHOENIX;

        /// Time zone data for US/Central,
        pub const CENTRAL: TimeZoneRef<'static> = tzdata::AMERICA_CHICAGO;

        /// Time zone data for US/Eastern,
        pub const EASTERN: TimeZoneRef<'static> = tzdata::AMERICA_NEW_YORK;

        /// Time zone data for US/East-Indiana,
        pub const EAST_INDIANA: TimeZoneRef<'static> = tzdata::AMERICA_FORT_WAYNE;

        /// Time zone data for US/Hawaii,
        pub const HAWAII: TimeZoneRef<'static> = tzdata::PACIFIC_HONOLULU;

        /// Time zone data for US/Indiana-Starke,
        pub const INDIANA_STARKE: TimeZoneRef<'static> = tzdata::AMERICA_KNOX_IN;

        /// Time zone data for US/Michigan,
        pub const MICHIGAN: TimeZoneRef<'static> = tzdata::AMERICA_DETROIT;

        /// Time zone data for US/Mountain,
        pub const MOUNTAIN: TimeZoneRef<'static> = tzdata::NAVAJO;

        /// Time zone data for US/Pacific,
        pub const PACIFIC: TimeZoneRef<'static> = tzdata::AMERICA_LOS_ANGELES;

        /// Time zone data for US/Samoa,
        pub const SAMOA: TimeZoneRef<'static> = tzdata::PACIFIC_PAGO_PAGO;

        /// Raw, unparsed time zone data for US/Alaska,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ALASKA: &[u8] = raw_tzdata::AMERICA_ANCHORAGE;

        /// Raw, unparsed time zone data for US/Aleutian,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ALEUTIAN: &[u8] = raw_tzdata::AMERICA_ADAK;

        /// Raw, unparsed time zone data for US/Arizona,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_ARIZONA: &[u8] = raw_tzdata::AMERICA_PHOENIX;

        /// Raw, unparsed time zone data for US/Central,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_CENTRAL: &[u8] = raw_tzdata::AMERICA_CHICAGO;

        /// Raw, unparsed time zone data for US/Eastern,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_EASTERN: &[u8] = raw_tzdata::AMERICA_NEW_YORK;

        /// Raw, unparsed time zone data for US/East-Indiana,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_EAST_INDIANA: &[u8] = raw_tzdata::AMERICA_FORT_WAYNE;

        /// Raw, unparsed time zone data for US/Hawaii,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_HAWAII: &[u8] = raw_tzdata::PACIFIC_HONOLULU;

        /// Raw, unparsed time zone data for US/Indiana-Starke,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_INDIANA_STARKE: &[u8] = raw_tzdata::AMERICA_KNOX_IN;

        /// Raw, unparsed time zone data for US/Michigan,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MICHIGAN: &[u8] = raw_tzdata::AMERICA_DETROIT;

        /// Raw, unparsed time zone data for US/Mountain,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_MOUNTAIN: &[u8] = raw_tzdata::NAVAJO;

        /// Raw, unparsed time zone data for US/Pacific,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_PACIFIC: &[u8] = raw_tzdata::AMERICA_LOS_ANGELES;

        /// Raw, unparsed time zone data for US/Samoa,
        #[cfg(feature = "binary")]
        #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
        pub const RAW_SAMOA: &[u8] = raw_tzdata::PACIFIC_PAGO_PAGO;
    }

    /// Time zone data for CET,
    pub const CET: TimeZoneRef<'static> = tzdata::CET;

    /// Time zone data for CST6CDT,
    pub const CST_6_CDT: TimeZoneRef<'static> = tzdata::CST_6_CDT;

    /// Time zone data for Cuba,
    pub const CUBA: TimeZoneRef<'static> = tzdata::CUBA;

    /// Time zone data for EET,
    pub const EET: TimeZoneRef<'static> = tzdata::EET;

    /// Time zone data for Egypt,
    pub const EGYPT: TimeZoneRef<'static> = tzdata::EGYPT;

    /// Time zone data for Eire,
    pub const EIRE: TimeZoneRef<'static> = tzdata::EIRE;

    /// Time zone data for EST,
    pub const EST: TimeZoneRef<'static> = tzdata::EST;

    /// Time zone data for EST5EDT,
    pub const EST_5_EDT: TimeZoneRef<'static> = tzdata::EST_5_EDT;

    /// Time zone data for Factory,
    pub const FACTORY: TimeZoneRef<'static> = tzdata::FACTORY;

    /// Time zone data for GB,
    pub const GB: TimeZoneRef<'static> = tzdata::GB;

    /// Time zone data for GB-Eire,
    pub const GB_EIRE: TimeZoneRef<'static> = tzdata::GB;

    /// Time zone data for GMT,
    pub const GMT: TimeZoneRef<'static> = tzdata::GMT;

    /// Time zone data for GMT0,
    pub const GMT_0: TimeZoneRef<'static> = tzdata::GMT;

    /// Time zone data for GMT-0,
    pub const GMT_MINUS_0: TimeZoneRef<'static> = tzdata::GMT;

    /// Time zone data for GMT+0,
    pub const GMT_PLUS_0: TimeZoneRef<'static> = tzdata::GMT;

    /// Time zone data for Greenwich,
    pub const GREENWICH: TimeZoneRef<'static> = tzdata::GMT;

    /// Time zone data for Hongkong,
    pub const HONGKONG: TimeZoneRef<'static> = tzdata::HONGKONG;

    /// Time zone data for HST,
    pub const HST: TimeZoneRef<'static> = tzdata::HST;

    /// Time zone data for Iceland,
    pub const ICELAND: TimeZoneRef<'static> = tzdata::ICELAND;

    /// Time zone data for Iran,
    pub const IRAN: TimeZoneRef<'static> = tzdata::IRAN;

    /// Time zone data for Israel,
    pub const ISRAEL: TimeZoneRef<'static> = tzdata::ISRAEL;

    /// Time zone data for Jamaica,
    pub const JAMAICA: TimeZoneRef<'static> = tzdata::JAMAICA;

    /// Time zone data for Japan,
    pub const JAPAN: TimeZoneRef<'static> = tzdata::JAPAN;

    /// Time zone data for Kwajalein,
    pub const KWAJALEIN: TimeZoneRef<'static> = tzdata::KWAJALEIN;

    /// Time zone data for Libya,
    pub const LIBYA: TimeZoneRef<'static> = tzdata::LIBYA;

    /// Time zone data for MET,
    pub const MET: TimeZoneRef<'static> = tzdata::MET;

    /// Time zone data for MST,
    pub const MST: TimeZoneRef<'static> = tzdata::MST;

    /// Time zone data for MST7MDT,
    pub const MST_7_MDT: TimeZoneRef<'static> = tzdata::MST_7_MDT;

    /// Time zone data for Navajo,
    pub const NAVAJO: TimeZoneRef<'static> = tzdata::NAVAJO;

    /// Time zone data for NZ,
    pub const NZ: TimeZoneRef<'static> = tzdata::NZ;

    /// Time zone data for NZ-CHAT,
    pub const NZ_CHAT: TimeZoneRef<'static> = tzdata::NZ_CHAT;

    /// Time zone data for Poland,
    pub const POLAND: TimeZoneRef<'static> = tzdata::POLAND;

    /// Time zone data for Portugal,
    pub const PORTUGAL: TimeZoneRef<'static> = tzdata::PORTUGAL;

    /// Time zone data for PRC,
    pub const PRC: TimeZoneRef<'static> = tzdata::PRC;

    /// Time zone data for PST8PDT,
    pub const PST_8_PDT: TimeZoneRef<'static> = tzdata::PST_8_PDT;

    /// Time zone data for ROC,
    pub const ROC: TimeZoneRef<'static> = tzdata::ROC;

    /// Time zone data for ROK,
    pub const ROK: TimeZoneRef<'static> = tzdata::ROK;

    /// Time zone data for Singapore,
    pub const SINGAPORE: TimeZoneRef<'static> = tzdata::SINGAPORE;

    /// Time zone data for Turkey,
    pub const TURKEY: TimeZoneRef<'static> = tzdata::TURKEY;

    /// Time zone data for UCT,
    pub const UCT: TimeZoneRef<'static> = tzdata::UCT;

    /// Time zone data for Universal,
    pub const UNIVERSAL: TimeZoneRef<'static> = tzdata::UCT;

    /// Time zone data for UTC,
    pub const UTC: TimeZoneRef<'static> = tzdata::UCT;

    /// Time zone data for WET,
    pub const WET: TimeZoneRef<'static> = tzdata::WET;

    /// Time zone data for W-SU,
    pub const W_SU: TimeZoneRef<'static> = tzdata::W_SU;

    /// Time zone data for Zulu,
    pub const ZULU: TimeZoneRef<'static> = tzdata::UCT;

    /// Raw, unparsed time zone data for CET,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_CET: &[u8] = raw_tzdata::CET;

    /// Raw, unparsed time zone data for CST6CDT,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_CST_6_CDT: &[u8] = raw_tzdata::CST_6_CDT;

    /// Raw, unparsed time zone data for Cuba,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_CUBA: &[u8] = raw_tzdata::CUBA;

    /// Raw, unparsed time zone data for EET,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_EET: &[u8] = raw_tzdata::EET;

    /// Raw, unparsed time zone data for Egypt,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_EGYPT: &[u8] = raw_tzdata::EGYPT;

    /// Raw, unparsed time zone data for Eire,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_EIRE: &[u8] = raw_tzdata::EIRE;

    /// Raw, unparsed time zone data for EST,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_EST: &[u8] = raw_tzdata::EST;

    /// Raw, unparsed time zone data for EST5EDT,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_EST_5_EDT: &[u8] = raw_tzdata::EST_5_EDT;

    /// Raw, unparsed time zone data for Factory,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_FACTORY: &[u8] = raw_tzdata::FACTORY;

    /// Raw, unparsed time zone data for GB,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_GB: &[u8] = raw_tzdata::GB;

    /// Raw, unparsed time zone data for GB-Eire,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_GB_EIRE: &[u8] = raw_tzdata::GB;

    /// Raw, unparsed time zone data for GMT,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_GMT: &[u8] = raw_tzdata::GMT;

    /// Raw, unparsed time zone data for GMT0,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_GMT_0: &[u8] = raw_tzdata::GMT;

    /// Raw, unparsed time zone data for GMT-0,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_GMT_MINUS_0: &[u8] = raw_tzdata::GMT;

    /// Raw, unparsed time zone data for GMT+0,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_GMT_PLUS_0: &[u8] = raw_tzdata::GMT;

    /// Raw, unparsed time zone data for Greenwich,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_GREENWICH: &[u8] = raw_tzdata::GMT;

    /// Raw, unparsed time zone data for Hongkong,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_HONGKONG: &[u8] = raw_tzdata::HONGKONG;

    /// Raw, unparsed time zone data for HST,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_HST: &[u8] = raw_tzdata::HST;

    /// Raw, unparsed time zone data for Iceland,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_ICELAND: &[u8] = raw_tzdata::ICELAND;

    /// Raw, unparsed time zone data for Iran,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_IRAN: &[u8] = raw_tzdata::IRAN;

    /// Raw, unparsed time zone data for Israel,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_ISRAEL: &[u8] = raw_tzdata::ISRAEL;

    /// Raw, unparsed time zone data for Jamaica,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_JAMAICA: &[u8] = raw_tzdata::JAMAICA;

    /// Raw, unparsed time zone data for Japan,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_JAPAN: &[u8] = raw_tzdata::JAPAN;

    /// Raw, unparsed time zone data for Kwajalein,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_KWAJALEIN: &[u8] = raw_tzdata::KWAJALEIN;

    /// Raw, unparsed time zone data for Libya,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_LIBYA: &[u8] = raw_tzdata::LIBYA;

    /// Raw, unparsed time zone data for MET,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_MET: &[u8] = raw_tzdata::MET;

    /// Raw, unparsed time zone data for MST,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_MST: &[u8] = raw_tzdata::MST;

    /// Raw, unparsed time zone data for MST7MDT,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_MST_7_MDT: &[u8] = raw_tzdata::MST_7_MDT;

    /// Raw, unparsed time zone data for Navajo,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_NAVAJO: &[u8] = raw_tzdata::NAVAJO;

    /// Raw, unparsed time zone data for NZ,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_NZ: &[u8] = raw_tzdata::NZ;

    /// Raw, unparsed time zone data for NZ-CHAT,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_NZ_CHAT: &[u8] = raw_tzdata::NZ_CHAT;

    /// Raw, unparsed time zone data for Poland,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_POLAND: &[u8] = raw_tzdata::POLAND;

    /// Raw, unparsed time zone data for Portugal,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_PORTUGAL: &[u8] = raw_tzdata::PORTUGAL;

    /// Raw, unparsed time zone data for PRC,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_PRC: &[u8] = raw_tzdata::PRC;

    /// Raw, unparsed time zone data for PST8PDT,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_PST_8_PDT: &[u8] = raw_tzdata::PST_8_PDT;

    /// Raw, unparsed time zone data for ROC,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_ROC: &[u8] = raw_tzdata::ROC;

    /// Raw, unparsed time zone data for ROK,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_ROK: &[u8] = raw_tzdata::ROK;

    /// Raw, unparsed time zone data for Singapore,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_SINGAPORE: &[u8] = raw_tzdata::SINGAPORE;

    /// Raw, unparsed time zone data for Turkey,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_TURKEY: &[u8] = raw_tzdata::TURKEY;

    /// Raw, unparsed time zone data for UCT,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_UCT: &[u8] = raw_tzdata::UCT;

    /// Raw, unparsed time zone data for Universal,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_UNIVERSAL: &[u8] = raw_tzdata::UCT;

    /// Raw, unparsed time zone data for UTC,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_UTC: &[u8] = raw_tzdata::UCT;

    /// Raw, unparsed time zone data for WET,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_WET: &[u8] = raw_tzdata::WET;

    /// Raw, unparsed time zone data for W-SU,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_W_SU: &[u8] = raw_tzdata::W_SU;

    /// Raw, unparsed time zone data for Zulu,
    #[cfg(feature = "binary")]
    #[cfg_attr(feature = "docsrs", doc(cfg(feature = "binary")))]
    pub const RAW_ZULU: &[u8] = raw_tzdata::UCT;
}

#[cfg(feature = "by-name")]
pub(crate) const TIME_ZONES_BY_NAME: phf::Map<&'static str, &'static TimeZoneRef<'static>> =
    ::phf::Map {
        key: 12913932095322966823,
        disps: &[
            (0, 27),
            (0, 63),
            (0, 0),
            (0, 0),
            (0, 1),
            (0, 0),
            (0, 4),
            (0, 123),
            (0, 102),
            (0, 13),
            (0, 13),
            (0, 1),
            (0, 172),
            (0, 44),
            (0, 1),
            (2, 241),
            (0, 199),
            (0, 5),
            (0, 11),
            (0, 172),
            (0, 102),
            (1, 570),
            (0, 4),
            (1, 48),
            (0, 9),
            (0, 133),
            (0, 147),
            (0, 25),
            (0, 34),
            (2, 32),
            (0, 262),
            (0, 552),
            (1, 204),
            (0, 256),
            (0, 441),
            (3, 0),
            (3, 361),
            (0, 501),
            (0, 22),
            (0, 7),
            (0, 45),
            (1, 184),
            (0, 3),
            (0, 424),
            (0, 1),
            (5, 408),
            (0, 113),
            (0, 50),
            (0, 4),
            (1, 426),
            (0, 0),
            (1, 243),
            (10, 50),
            (0, 142),
            (0, 2),
            (2, 512),
            (0, 95),
            (2, 199),
            (0, 20),
            (0, 82),
            (0, 315),
            (0, 535),
            (10, 132),
            (0, 10),
            (3, 519),
            (2, 147),
            (0, 1),
            (0, 47),
            (0, 3),
            (0, 11),
            (0, 4),
            (0, 72),
            (0, 20),
            (1, 3),
            (0, 67),
            (0, 457),
            (0, 17),
            (0, 262),
            (0, 376),
            (0, 45),
            (0, 209),
            (0, 21),
            (0, 256),
            (0, 12),
            (0, 43),
            (0, 18),
            (0, 238),
            (0, 0),
            (0, 134),
            (0, 262),
            (0, 147),
            (0, 40),
            (1, 112),
            (0, 147),
            (1, 449),
            (2, 8),
            (0, 183),
            (3, 420),
            (1, 244),
            (1, 534),
            (1, 76),
            (2, 327),
            (0, 96),
            (0, 221),
            (1, 5),
            (0, 147),
            (0, 475),
            (9, 257),
            (33, 245),
            (2, 236),
            (0, 1),
            (6, 435),
            (5, 372),
            (0, 356),
            (2, 359),
        ],
        entries: &[
            ("pacific/kiritimati", &tzdata::PACIFIC_KIRITIMATI),
            ("africa/maseru", &tzdata::AFRICA_MASERU),
            ("australia/broken_hill", &tzdata::AUSTRALIA_BROKEN_HILL),
            ("africa/el_aaiun", &tzdata::AFRICA_EL_AAIUN),
            ("asia/singapore", &tzdata::SINGAPORE),
            ("america/santa_isabel", &tzdata::AMERICA_SANTA_ISABEL),
            ("etc/gmt-0", &tzdata::GMT),
            ("asia/yerevan", &tzdata::ASIA_YEREVAN),
            ("etc/gmt+9", &tzdata::ETC_GMT_PLUS_9),
            ("pacific/samoa", &tzdata::PACIFIC_PAGO_PAGO),
            ("asia/samarkand", &tzdata::ASIA_SAMARKAND),
            ("australia/eucla", &tzdata::AUSTRALIA_EUCLA),
            ("europe/simferopol", &tzdata::EUROPE_SIMFEROPOL),
            ("america/chicago", &tzdata::AMERICA_CHICAGO),
            ("europe/tiraspol", &tzdata::EUROPE_TIRASPOL),
            ("pst8pdt", &tzdata::PST_8_PDT),
            ("pacific/majuro", &tzdata::PACIFIC_MAJURO),
            ("africa/ouagadougou", &tzdata::AFRICA_OUAGADOUGOU),
            ("etc/gmt+10", &tzdata::ETC_GMT_PLUS_10),
            ("america/nuuk", &tzdata::AMERICA_GODTHAB),
            ("indian/mahe", &tzdata::INDIAN_MAHE),
            ("africa/lome", &tzdata::AFRICA_LOME),
            ("asia/beirut", &tzdata::ASIA_BEIRUT),
            ("us/east-indiana", &tzdata::AMERICA_FORT_WAYNE),
            ("europe/ulyanovsk", &tzdata::EUROPE_ULYANOVSK),
            ("asia/dacca", &tzdata::ASIA_DACCA),
            ("mexico/bajanorte", &tzdata::AMERICA_SANTA_ISABEL),
            ("america/maceio", &tzdata::AMERICA_MACEIO),
            ("atlantic/reykjavik", &tzdata::ICELAND),
            ("america/ojinaga", &tzdata::AMERICA_OJINAGA),
            ("africa/casablanca", &tzdata::AFRICA_CASABLANCA),
            ("africa/luanda", &tzdata::AFRICA_LUANDA),
            ("asia/makassar", &tzdata::ASIA_MAKASSAR),
            ("america/phoenix", &tzdata::AMERICA_PHOENIX),
            ("kwajalein", &tzdata::KWAJALEIN),
            ("europe/moscow", &tzdata::W_SU),
            ("antarctica/mcmurdo", &tzdata::ANTARCTICA_MC_MURDO),
            ("asia/hovd", &tzdata::ASIA_HOVD),
            ("asia/dubai", &tzdata::ASIA_DUBAI),
            ("etc/gmt+0", &tzdata::GMT),
            ("africa/freetown", &tzdata::AFRICA_FREETOWN),
            ("est", &tzdata::EST),
            ("gmt+0", &tzdata::GMT),
            ("america/blanc-sablon", &tzdata::AMERICA_BLANC_SABLON),
            ("america/porto_acre", &tzdata::AMERICA_PORTO_ACRE),
            ("indian/mauritius", &tzdata::INDIAN_MAURITIUS),
            ("europe/rome", &tzdata::EUROPE_ROME),
            ("europe/vilnius", &tzdata::EUROPE_VILNIUS),
            ("america/punta_arenas", &tzdata::AMERICA_PUNTA_ARENAS),
            ("europe/podgorica", &tzdata::EUROPE_BELGRADE),
            ("asia/brunei", &tzdata::ASIA_BRUNEI),
            ("america/sitka", &tzdata::AMERICA_SITKA),
            ("america/rosario", &tzdata::AMERICA_ROSARIO),
            ("europe/athens", &tzdata::EUROPE_ATHENS),
            ("pacific/pago_pago", &tzdata::PACIFIC_PAGO_PAGO),
            ("america/dominica", &tzdata::AMERICA_DOMINICA),
            ("america/menominee", &tzdata::AMERICA_MENOMINEE),
            ("africa/lusaka", &tzdata::AFRICA_LUSAKA),
            ("africa/ndjamena", &tzdata::AFRICA_NDJAMENA),
            ("etc/gmt+4", &tzdata::ETC_GMT_PLUS_4),
            ("asia/macau", &tzdata::ASIA_MACAO),
            ("antarctica/palmer", &tzdata::ANTARCTICA_PALMER),
            ("indian/chagos", &tzdata::INDIAN_CHAGOS),
            ("africa/malabo", &tzdata::AFRICA_MALABO),
            ("africa/nouakchott", &tzdata::AFRICA_NOUAKCHOTT),
            ("europe/luxembourg", &tzdata::EUROPE_LUXEMBOURG),
            ("europe/bratislava", &tzdata::EUROPE_BRATISLAVA),
            ("africa/addis_ababa", &tzdata::AFRICA_ADDIS_ABABA),
            ("brazil/denoronha", &tzdata::AMERICA_NORONHA),
            ("asia/ulan_bator", &tzdata::ASIA_ULAANBAATAR),
            ("jamaica", &tzdata::JAMAICA),
            ("europe/isle_of_man", &tzdata::EUROPE_ISLE_OF_MAN),
            ("asia/chita", &tzdata::ASIA_CHITA),
            ("europe/andorra", &tzdata::EUROPE_ANDORRA),
            ("gmt-0", &tzdata::GMT),
            ("america/fortaleza", &tzdata::AMERICA_FORTALEZA),
            ("america/knox_in", &tzdata::AMERICA_KNOX_IN),
            ("pacific/yap", &tzdata::PACIFIC_CHUUK),
            ("america/santarem", &tzdata::AMERICA_SANTAREM),
            ("arctic/longyearbyen", &tzdata::ARCTIC_LONGYEARBYEN),
            ("america/porto_velho", &tzdata::AMERICA_PORTO_VELHO),
            ("europe/lisbon", &tzdata::PORTUGAL),
            ("pacific/wake", &tzdata::PACIFIC_WAKE),
            ("america/curacao", &tzdata::AMERICA_CURACAO),
            ("singapore", &tzdata::SINGAPORE),
            ("australia/lord_howe", &tzdata::AUSTRALIA_LHI),
            ("universal", &tzdata::UCT),
            ("europe/astrakhan", &tzdata::EUROPE_ASTRAKHAN),
            ("utc", &tzdata::UCT),
            ("australia/hobart", &tzdata::AUSTRALIA_HOBART),
            ("antarctica/south_pole", &tzdata::ANTARCTICA_MC_MURDO),
            ("africa/conakry", &tzdata::AFRICA_CONAKRY),
            ("europe/warsaw", &tzdata::POLAND),
            ("europe/guernsey", &tzdata::EUROPE_GUERNSEY),
            ("america/cayman", &tzdata::AMERICA_CAYMAN),
            ("asia/nicosia", &tzdata::ASIA_NICOSIA),
            ("chile/easterisland", &tzdata::CHILE_EASTER_ISLAND),
            ("pacific/tongatapu", &tzdata::PACIFIC_TONGATAPU),
            ("america/caracas", &tzdata::AMERICA_CARACAS),
            ("canada/saskatchewan", &tzdata::AMERICA_REGINA),
            ("america/grenada", &tzdata::AMERICA_GRENADA),
            ("atlantic/south_georgia", &tzdata::ATLANTIC_SOUTH_GEORGIA),
            ("asia/qostanay", &tzdata::ASIA_QOSTANAY),
            ("africa/nairobi", &tzdata::AFRICA_NAIROBI),
            ("america/mendoza", &tzdata::AMERICA_MENDOZA),
            ("asia/barnaul", &tzdata::ASIA_BARNAUL),
            ("asia/tashkent", &tzdata::ASIA_TASHKENT),
            ("pacific/tahiti", &tzdata::PACIFIC_TAHITI),
            ("japan", &tzdata::JAPAN),
            ("pacific/niue", &tzdata::PACIFIC_NIUE),
            ("asia/dhaka", &tzdata::ASIA_DACCA),
            ("atlantic/st_helena", &tzdata::ATLANTIC_ST_HELENA),
            ("cuba", &tzdata::CUBA),
            ("europe/berlin", &tzdata::EUROPE_BERLIN),
            ("america/belem", &tzdata::AMERICA_BELEM),
            ("etc/gmt-4", &tzdata::ETC_GMT_MINUS_4),
            ("antarctica/troll", &tzdata::ANTARCTICA_TROLL),
            ("europe/kaliningrad", &tzdata::EUROPE_KALININGRAD),
            ("africa/djibouti", &tzdata::AFRICA_DJIBOUTI),
            ("europe/belgrade", &tzdata::EUROPE_BELGRADE),
            ("africa/ceuta", &tzdata::AFRICA_CEUTA),
            ("us/aleutian", &tzdata::AMERICA_ADAK),
            ("america/vancouver", &tzdata::AMERICA_VANCOUVER),
            ("gmt", &tzdata::GMT),
            ("america/puerto_rico", &tzdata::AMERICA_PUERTO_RICO),
            ("etc/gmt+7", &tzdata::ETC_GMT_PLUS_7),
            ("america/dawson_creek", &tzdata::AMERICA_DAWSON_CREEK),
            ("pacific/norfolk", &tzdata::PACIFIC_NORFOLK),
            ("gb-eire", &tzdata::GB),
            ("asia/hanoi", &tzdata::ASIA_HANOI),
            ("america/nassau", &tzdata::AMERICA_NASSAU),
            ("america/fort_nelson", &tzdata::AMERICA_FORT_NELSON),
            ("america/goose_bay", &tzdata::AMERICA_GOOSE_BAY),
            ("america/cancun", &tzdata::AMERICA_CANCUN),
            ("africa/asmera", &tzdata::AFRICA_ASMARA),
            ("europe/belfast", &tzdata::EUROPE_BELFAST),
            ("pacific/wallis", &tzdata::PACIFIC_WALLIS),
            ("etc/localtime", &tzdata::GMT),
            ("africa/kigali", &tzdata::AFRICA_KIGALI),
            ("etc/greenwich", &tzdata::GMT),
            ("egypt", &tzdata::EGYPT),
            ("africa/algiers", &tzdata::AFRICA_ALGIERS),
            ("asia/sakhalin", &tzdata::ASIA_SAKHALIN),
            ("asia/qatar", &tzdata::ASIA_QATAR),
            ("america/barbados", &tzdata::AMERICA_BARBADOS),
            ("asia/kuwait", &tzdata::ASIA_KUWAIT),
            ("etc/gmt0", &tzdata::GMT),
            ("antarctica/rothera", &tzdata::ANTARCTICA_ROTHERA),
            ("america/manaus", &tzdata::AMERICA_MANAUS),
            ("america/cambridge_bay", &tzdata::AMERICA_CAMBRIDGE_BAY),
            ("us/indiana-starke", &tzdata::AMERICA_KNOX_IN),
            ("mst", &tzdata::MST),
            ("etc/gmt+1", &tzdata::ATLANTIC_JAN_MAYEN),
            ("asia/baghdad", &tzdata::ASIA_BAGHDAD),
            ("asia/gaza", &tzdata::ASIA_GAZA),
            ("america/montevideo", &tzdata::AMERICA_MONTEVIDEO),
            ("atlantic/madeira", &tzdata::ATLANTIC_MADEIRA),
            ("america/rio_branco", &tzdata::AMERICA_PORTO_ACRE),
            ("asia/qyzylorda", &tzdata::ASIA_QYZYLORDA),
            ("asia/kolkata", &tzdata::ASIA_CALCUTTA),
            ("etc/gmt-5", &tzdata::ETC_GMT_MINUS_5),
            ("asia/ashgabat", &tzdata::ASIA_ASHGABAT),
            ("asia/novokuznetsk", &tzdata::ASIA_NOVOKUZNETSK),
            ("pacific/nauru", &tzdata::PACIFIC_NAURU),
            ("atlantic/faeroe", &tzdata::ATLANTIC_FAEROE),
            ("america/araguaina", &tzdata::AMERICA_ARAGUAINA),
            ("etc/gmt+5", &tzdata::ETC_GMT_PLUS_5),
            ("europe/madrid", &tzdata::EUROPE_MADRID),
            ("america/tijuana", &tzdata::AMERICA_SANTA_ISABEL),
            ("asia/choibalsan", &tzdata::ASIA_CHOIBALSAN),
            ("asia/ho_chi_minh", &tzdata::ASIA_HO_CHI_MINH),
            ("america/la_paz", &tzdata::AMERICA_LA_PAZ),
            ("pacific/saipan", &tzdata::PACIFIC_SAIPAN),
            ("america/halifax", &tzdata::AMERICA_HALIFAX),
            ("europe/nicosia", &tzdata::ASIA_NICOSIA),
            ("pacific/fiji", &tzdata::PACIFIC_FIJI),
            ("us/mountain", &tzdata::NAVAJO),
            ("etc/gmt+11", &tzdata::ETC_GMT_PLUS_11),
            ("canada/central", &tzdata::AMERICA_WINNIPEG),
            ("canada/mountain", &tzdata::AMERICA_EDMONTON),
            ("europe/kiev", &tzdata::EUROPE_KIEV),
            ("etc/gmt-14", &tzdata::ETC_GMT_MINUS_14),
            ("indian/mayotte", &tzdata::INDIAN_MAYOTTE),
            ("africa/harare", &tzdata::AFRICA_HARARE),
            ("asia/tel_aviv", &tzdata::ASIA_TEL_AVIV),
            ("hongkong", &tzdata::HONGKONG),
            ("mexico/general", &tzdata::AMERICA_MEXICO_CITY),
            ("gmt0", &tzdata::GMT),
            ("africa/sao_tome", &tzdata::AFRICA_SAO_TOME),
            ("america/asuncion", &tzdata::AMERICA_ASUNCION),
            ("america/kralendijk", &tzdata::AMERICA_CURACAO),
            ("cet", &tzdata::CET),
            ("america/belize", &tzdata::AMERICA_BELIZE),
            ("america/boise", &tzdata::AMERICA_BOISE),
            ("america/atikokan", &tzdata::AMERICA_ATIKOKAN),
            (
                "antarctica/dumontdurville",
                &tzdata::ANTARCTICA_DUMONT_D_URVILLE,
            ),
            ("america/guadeloupe", &tzdata::AMERICA_GUADELOUPE),
            ("etc/universal", &tzdata::UCT),
            ("atlantic/stanley", &tzdata::ATLANTIC_STANLEY),
            ("america/detroit", &tzdata::AMERICA_DETROIT),
            ("america/fort_wayne", &tzdata::AMERICA_FORT_WAYNE),
            ("europe/copenhagen", &tzdata::EUROPE_COPENHAGEN),
            ("asia/harbin", &tzdata::ASIA_HARBIN),
            ("etc/zulu", &tzdata::UCT),
            ("america/scoresbysund", &tzdata::AMERICA_SCORESBYSUND),
            ("australia/west", &tzdata::AUSTRALIA_PERTH),
            ("asia/krasnoyarsk", &tzdata::ASIA_KRASNOYARSK),
            ("australia/south", &tzdata::AUSTRALIA_ADELAIDE),
            ("asia/karachi", &tzdata::ASIA_KARACHI),
            ("pacific/guadalcanal", &tzdata::PACIFIC_GUADALCANAL),
            ("pacific/kanton", &tzdata::PACIFIC_KANTON),
            ("asia/riyadh", &tzdata::ASIA_RIYADH),
            ("australia/victoria", &tzdata::AUSTRALIA_MELBOURNE),
            ("asia/bangkok", &tzdata::ASIA_BANGKOK),
            ("libya", &tzdata::LIBYA),
            ("america/paramaribo", &tzdata::AMERICA_PARAMARIBO),
            ("pacific/chuuk", &tzdata::PACIFIC_CHUUK),
            ("america/st_lucia", &tzdata::AMERICA_ST_LUCIA),
            ("etc/gmt-2", &tzdata::ETC_GMT_MINUS_2),
            ("africa/bangui", &tzdata::AFRICA_BANGUI),
            ("atlantic/jan_mayen", &tzdata::ATLANTIC_JAN_MAYEN),
            ("america/tegucigalpa", &tzdata::AMERICA_TEGUCIGALPA),
            ("indian/maldives", &tzdata::INDIAN_MALDIVES),
            ("atlantic/cape_verde", &tzdata::ATLANTIC_CAPE_VERDE),
            ("eet", &tzdata::EET),
            ("europe/prague", &tzdata::EUROPE_BRATISLAVA),
            ("gb", &tzdata::GB),
            ("asia/phnom_penh", &tzdata::ASIA_PHNOM_PENH),
            ("wet", &tzdata::WET),
            ("antarctica/casey", &tzdata::ANTARCTICA_CASEY),
            ("europe/san_marino", &tzdata::EUROPE_ROME),
            ("america/thule", &tzdata::AMERICA_THULE),
            ("africa/bissau", &tzdata::AFRICA_BISSAU),
            ("asia/irkutsk", &tzdata::ASIA_IRKUTSK),
            ("america/santo_domingo", &tzdata::AMERICA_SANTO_DOMINGO),
            ("america/nipigon", &tzdata::AMERICA_NIPIGON),
            ("america/coral_harbour", &tzdata::AMERICA_CORAL_HARBOUR),
            ("pacific/chatham", &tzdata::NZ_CHAT),
            ("europe/jersey", &tzdata::EUROPE_JERSEY),
            ("america/st_thomas", &tzdata::AMERICA_ST_THOMAS),
            ("chile/continental", &tzdata::AMERICA_SANTIAGO),
            ("africa/khartoum", &tzdata::AFRICA_KHARTOUM),
            ("indian/kerguelen", &tzdata::INDIAN_KERGUELEN),
            ("pacific/gambier", &tzdata::PACIFIC_GAMBIER),
            ("pacific/rarotonga", &tzdata::PACIFIC_RAROTONGA),
            ("pacific/kosrae", &tzdata::PACIFIC_KOSRAE),
            ("asia/istanbul", &tzdata::TURKEY),
            ("america/indianapolis", &tzdata::AMERICA_FORT_WAYNE),
            ("america/whitehorse", &tzdata::AMERICA_WHITEHORSE),
            ("canada/eastern", &tzdata::AMERICA_TORONTO),
            ("antarctica/mawson", &tzdata::ANTARCTICA_MAWSON),
            ("america/los_angeles", &tzdata::AMERICA_LOS_ANGELES),
            ("africa/gaborone", &tzdata::AFRICA_GABORONE),
            ("america/guayaquil", &tzdata::AMERICA_GUAYAQUIL),
            ("pacific/port_moresby", &tzdata::PACIFIC_PORT_MORESBY),
            ("america/lower_princes", &tzdata::AMERICA_CURACAO),
            ("pacific/auckland", &tzdata::NZ),
            ("america/glace_bay", &tzdata::AMERICA_GLACE_BAY),
            ("africa/mbabane", &tzdata::AFRICA_MBABANE),
            ("asia/calcutta", &tzdata::ASIA_CALCUTTA),
            ("asia/oral", &tzdata::ASIA_ORAL),
            ("us/samoa", &tzdata::PACIFIC_PAGO_PAGO),
            ("america/matamoros", &tzdata::AMERICA_MATAMOROS),
            ("europe/tallinn", &tzdata::EUROPE_TALLINN),
            ("asia/ulaanbaatar", &tzdata::ASIA_ULAANBAATAR),
            ("africa/bujumbura", &tzdata::AFRICA_BUJUMBURA),
            ("canada/atlantic", &tzdata::AMERICA_HALIFAX),
            ("us/hawaii", &tzdata::PACIFIC_HONOLULU),
            ("antarctica/macquarie", &tzdata::ANTARCTICA_MACQUARIE),
            ("europe/skopje", &tzdata::EUROPE_SKOPJE),
            ("asia/vladivostok", &tzdata::ASIA_VLADIVOSTOK),
            ("etc/gmt+6", &tzdata::ETC_GMT_PLUS_6),
            ("america/boa_vista", &tzdata::AMERICA_BOA_VISTA),
            ("europe/vaduz", &tzdata::EUROPE_VADUZ),
            ("asia/dushanbe", &tzdata::ASIA_DUSHANBE),
            ("portugal", &tzdata::PORTUGAL),
            ("atlantic/azores", &tzdata::ATLANTIC_AZORES),
            ("mst7mdt", &tzdata::MST_7_MDT),
            ("brazil/west", &tzdata::AMERICA_MANAUS),
            ("america/st_vincent", &tzdata::AMERICA_ST_VINCENT),
            ("etc/gmt-6", &tzdata::ETC_GMT_MINUS_6),
            ("asia/shanghai", &tzdata::PRC),
            ("africa/banjul", &tzdata::AFRICA_BANJUL),
            ("asia/bahrain", &tzdata::ASIA_BAHRAIN),
            ("asia/ashkhabad", &tzdata::ASIA_ASHGABAT),
            ("africa/windhoek", &tzdata::AFRICA_WINDHOEK),
            ("africa/mogadishu", &tzdata::AFRICA_MOGADISHU),
            ("etc/utc", &tzdata::UCT),
            ("pacific/midway", &tzdata::PACIFIC_MIDWAY),
            ("us/central", &tzdata::AMERICA_CHICAGO),
            ("asia/muscat", &tzdata::ASIA_MUSCAT),
            ("cst6cdt", &tzdata::CST_6_CDT),
            ("america/shiprock", &tzdata::NAVAJO),
            ("africa/monrovia", &tzdata::AFRICA_MONROVIA),
            ("america/cayenne", &tzdata::AMERICA_CAYENNE),
            ("asia/damascus", &tzdata::ASIA_DAMASCUS),
            ("america/dawson", &tzdata::AMERICA_DAWSON),
            ("america/aruba", &tzdata::AMERICA_ARUBA),
            ("pacific/guam", &tzdata::PACIFIC_GUAM),
            ("indian/cocos", &tzdata::INDIAN_COCOS),
            ("asia/yangon", &tzdata::ASIA_RANGOON),
            ("america/eirunepe", &tzdata::AMERICA_EIRUNEPE),
            ("america/monterrey", &tzdata::AMERICA_MONTERREY),
            ("etc/gmt", &tzdata::GMT),
            ("america/havana", &tzdata::CUBA),
            ("etc/gmt-3", &tzdata::ETC_GMT_MINUS_3),
            ("america/regina", &tzdata::AMERICA_REGINA),
            ("asia/macao", &tzdata::ASIA_MACAO),
            ("america/port_of_spain", &tzdata::AMERICA_MARIGOT),
            ("asia/kuching", &tzdata::ASIA_KUCHING),
            ("navajo", &tzdata::NAVAJO),
            ("canada/newfoundland", &tzdata::AMERICA_ST_JOHNS),
            ("nz-chat", &tzdata::NZ_CHAT),
            ("europe/kirov", &tzdata::EUROPE_KIROV),
            ("asia/pontianak", &tzdata::ASIA_PONTIANAK),
            ("etc/gmt+2", &tzdata::ETC_GMT_PLUS_2),
            ("asia/aqtau", &tzdata::ASIA_AQTAU),
            ("america/sao_paulo", &tzdata::AMERICA_SAO_PAULO),
            ("etc/gmt-1", &tzdata::ETC_GMT_MINUS_1),
            ("etc/gmt+3", &tzdata::ETC_GMT_PLUS_3),
            ("america/noronha", &tzdata::AMERICA_NORONHA),
            ("africa/douala", &tzdata::AFRICA_DOUALA),
            ("africa/dar_es_salaam", &tzdata::AFRICA_DAR_ES_SALAAM),
            ("australia/adelaide", &tzdata::AUSTRALIA_ADELAIDE),
            ("asia/pyongyang", &tzdata::ASIA_PYONGYANG),
            ("asia/dili", &tzdata::ASIA_DILI),
            ("asia/kabul", &tzdata::ASIA_KABUL),
            ("etc/uct", &tzdata::UCT),
            ("america/adak", &tzdata::AMERICA_ADAK),
            ("brazil/east", &tzdata::AMERICA_SAO_PAULO),
            ("pacific/easter", &tzdata::CHILE_EASTER_ISLAND),
            ("europe/riga", &tzdata::EUROPE_RIGA),
            ("europe/brussels", &tzdata::EUROPE_BRUSSELS),
            ("israel", &tzdata::ISRAEL),
            ("pacific/bougainville", &tzdata::PACIFIC_BOUGAINVILLE),
            ("america/danmarkshavn", &tzdata::AMERICA_DANMARKSHAVN),
            ("australia/yancowinna", &tzdata::AUSTRALIA_BROKEN_HILL),
            ("america/iqaluit", &tzdata::AMERICA_IQALUIT),
            ("america/montserrat", &tzdata::AMERICA_MONTSERRAT),
            ("asia/amman", &tzdata::ASIA_AMMAN),
            ("america/miquelon", &tzdata::AMERICA_MIQUELON),
            ("america/mazatlan", &tzdata::AMERICA_MAZATLAN),
            ("asia/tomsk", &tzdata::ASIA_TOMSK),
            ("asia/novosibirsk", &tzdata::ASIA_NOVOSIBIRSK),
            ("america/ensenada", &tzdata::AMERICA_ENSENADA),
            ("europe/malta", &tzdata::EUROPE_MALTA),
            ("asia/thimphu", &tzdata::ASIA_THIMBU),
            ("us/arizona", &tzdata::AMERICA_PHOENIX),
            ("pacific/pitcairn", &tzdata::PACIFIC_PITCAIRN),
            ("america/guyana", &tzdata::AMERICA_GUYANA),
            ("australia/currie", &tzdata::AUSTRALIA_CURRIE),
            ("america/campo_grande", &tzdata::AMERICA_CAMPO_GRANDE),
            ("asia/ujung_pandang", &tzdata::ASIA_MAKASSAR),
            ("europe/stockholm", &tzdata::EUROPE_STOCKHOLM),
            ("etc/gmt-11", &tzdata::ETC_GMT_MINUS_11),
            ("america/metlakatla", &tzdata::AMERICA_METLAKATLA),
            ("africa/asmara", &tzdata::AFRICA_ASMARA),
            ("europe/amsterdam", &tzdata::EUROPE_AMSTERDAM),
            ("europe/bucharest", &tzdata::EUROPE_BUCHAREST),
            ("asia/bishkek", &tzdata::ASIA_BISHKEK),
            ("australia/act", &tzdata::AUSTRALIA_ACT),
            ("america/jamaica", &tzdata::JAMAICA),
            ("australia/tasmania", &tzdata::AUSTRALIA_HOBART),
            ("europe/london", &tzdata::GB),
            ("asia/rangoon", &tzdata::ASIA_RANGOON),
            ("america/martinique", &tzdata::AMERICA_MARTINIQUE),
            ("america/grand_turk", &tzdata::AMERICA_GRAND_TURK),
            ("pacific/enderbury", &tzdata::PACIFIC_ENDERBURY),
            ("australia/melbourne", &tzdata::AUSTRALIA_MELBOURNE),
            ("asia/yakutsk", &tzdata::ASIA_YAKUTSK),
            ("america/panama", &tzdata::AMERICA_PANAMA),
            ("america/el_salvador", &tzdata::AMERICA_EL_SALVADOR),
            ("africa/lagos", &tzdata::AFRICA_LAGOS),
            ("est5edt", &tzdata::EST_5_EDT),
            ("asia/yekaterinburg", &tzdata::ASIA_YEKATERINBURG),
            ("asia/anadyr", &tzdata::ASIA_ANADYR),
            ("america/rainy_river", &tzdata::AMERICA_RAINY_RIVER),
            ("america/new_york", &tzdata::AMERICA_NEW_YORK),
            ("africa/tunis", &tzdata::AFRICA_TUNIS),
            ("europe/zaporozhye", &tzdata::EUROPE_ZAPOROZHYE),
            ("africa/niamey", &tzdata::AFRICA_NIAMEY),
            ("asia/seoul", &tzdata::ROK),
            ("america/catamarca", &tzdata::AMERICA_CATAMARCA),
            ("america/edmonton", &tzdata::AMERICA_EDMONTON),
            ("iran", &tzdata::IRAN),
            ("europe/sofia", &tzdata::EUROPE_SOFIA),
            ("pacific/ponape", &tzdata::PACIFIC_POHNPEI),
            ("america/swift_current", &tzdata::AMERICA_SWIFT_CURRENT),
            ("asia/taipei", &tzdata::ROC),
            ("america/buenos_aires", &tzdata::AMERICA_BUENOS_AIRES),
            ("europe/zagreb", &tzdata::EUROPE_ZAGREB),
            ("europe/sarajevo", &tzdata::EUROPE_SARAJEVO),
            ("atlantic/bermuda", &tzdata::ATLANTIC_BERMUDA),
            ("factory", &tzdata::FACTORY),
            ("africa/abidjan", &tzdata::AFRICA_ABIDJAN),
            ("america/nome", &tzdata::AMERICA_NOME),
            ("australia/north", &tzdata::AUSTRALIA_DARWIN),
            ("america/chihuahua", &tzdata::AMERICA_CHIHUAHUA),
            ("indian/antananarivo", &tzdata::INDIAN_ANTANANARIVO),
            ("africa/johannesburg", &tzdata::AFRICA_JOHANNESBURG),
            ("africa/juba", &tzdata::AFRICA_JUBA),
            ("antarctica/davis", &tzdata::ANTARCTICA_DAVIS),
            ("asia/kuala_lumpur", &tzdata::ASIA_KUALA_LUMPUR),
            ("canada/pacific", &tzdata::AMERICA_VANCOUVER),
            ("indian/comoro", &tzdata::INDIAN_COMORO),
            ("america/yellowknife", &tzdata::AMERICA_YELLOWKNIFE),
            ("africa/brazzaville", &tzdata::AFRICA_BRAZZAVILLE),
            ("america/resolute", &tzdata::AMERICA_RESOLUTE),
            ("africa/maputo", &tzdata::AFRICA_MAPUTO),
            ("africa/cairo", &tzdata::EGYPT),
            ("etc/gmt-7", &tzdata::ETC_GMT_MINUS_7),
            ("atlantic/canary", &tzdata::ATLANTIC_CANARY),
            ("america/port-au-prince", &tzdata::AMERICA_PORT_AU_PRINCE),
            ("pacific/tarawa", &tzdata::PACIFIC_TARAWA),
            ("etc/gmt+8", &tzdata::ETC_GMT_PLUS_8),
            ("atlantic/faroe", &tzdata::ATLANTIC_FAEROE),
            ("etc/gmt+12", &tzdata::ETC_GMT_PLUS_12),
            ("america/mexico_city", &tzdata::AMERICA_MEXICO_CITY),
            ("antarctica/vostok", &tzdata::ANTARCTICA_VOSTOK),
            ("asia/thimbu", &tzdata::ASIA_THIMBU),
            ("america/merida", &tzdata::AMERICA_MERIDA),
            ("america/pangnirtung", &tzdata::AMERICA_PANGNIRTUNG),
            ("europe/vienna", &tzdata::EUROPE_VIENNA),
            ("prc", &tzdata::PRC),
            ("europe/chisinau", &tzdata::EUROPE_CHISINAU),
            ("etc/gmt-8", &tzdata::ETC_GMT_MINUS_8),
            ("australia/lhi", &tzdata::AUSTRALIA_LHI),
            ("australia/darwin", &tzdata::AUSTRALIA_DARWIN),
            ("america/jujuy", &tzdata::AMERICA_JUJUY),
            ("asia/colombo", &tzdata::ASIA_COLOMBO),
            ("america/anchorage", &tzdata::AMERICA_ANCHORAGE),
            ("europe/ljubljana", &tzdata::EUROPE_LJUBLJANA),
            ("europe/helsinki", &tzdata::EUROPE_HELSINKI),
            ("europe/dublin", &tzdata::EIRE),
            ("pacific/johnston", &tzdata::HST),
            ("australia/lindeman", &tzdata::AUSTRALIA_LINDEMAN),
            ("europe/vatican", &tzdata::EUROPE_ROME),
            ("america/st_barthelemy", &tzdata::AMERICA_MARIGOT),
            ("america/cuiaba", &tzdata::AMERICA_CUIABA),
            ("africa/tripoli", &tzdata::LIBYA),
            ("pacific/efate", &tzdata::PACIFIC_EFATE),
            ("asia/kathmandu", &tzdata::ASIA_KATHMANDU),
            ("asia/famagusta", &tzdata::ASIA_FAMAGUSTA),
            ("asia/urumqi", &tzdata::ASIA_URUMQI),
            ("australia/nsw", &tzdata::AUSTRALIA_ACT),
            ("america/denver", &tzdata::NAVAJO),
            ("africa/accra", &tzdata::AFRICA_ACCRA),
            ("america/thunder_bay", &tzdata::AMERICA_THUNDER_BAY),
            ("america/winnipeg", &tzdata::AMERICA_WINNIPEG),
            ("asia/omsk", &tzdata::ASIA_OMSK),
            ("pacific/marquesas", &tzdata::PACIFIC_MARQUESAS),
            ("america/tortola", &tzdata::AMERICA_TORTOLA),
            ("poland", &tzdata::POLAND),
            ("america/toronto", &tzdata::AMERICA_TORONTO),
            ("asia/katmandu", &tzdata::ASIA_KATHMANDU),
            ("etc/gmt-12", &tzdata::ETC_GMT_MINUS_12),
            ("us/eastern", &tzdata::AMERICA_NEW_YORK),
            ("pacific/apia", &tzdata::PACIFIC_APIA),
            ("asia/kamchatka", &tzdata::ASIA_KAMCHATKA),
            ("asia/saigon", &tzdata::ASIA_HO_CHI_MINH),
            ("europe/busingen", &tzdata::EUROPE_BUSINGEN),
            ("america/bahia_banderas", &tzdata::AMERICA_BAHIA_BANDERAS),
            ("asia/hebron", &tzdata::ASIA_HEBRON),
            ("asia/atyrau", &tzdata::ASIA_ATYRAU),
            ("america/bahia", &tzdata::AMERICA_BAHIA),
            ("america/hermosillo", &tzdata::AMERICA_HERMOSILLO),
            ("america/managua", &tzdata::AMERICA_MANAGUA),
            ("us/pacific", &tzdata::AMERICA_LOS_ANGELES),
            ("europe/zurich", &tzdata::EUROPE_BUSINGEN),
            ("america/atka", &tzdata::AMERICA_ADAK),
            ("asia/kashgar", &tzdata::ASIA_KASHGAR),
            ("africa/lubumbashi", &tzdata::AFRICA_LUBUMBASHI),
            ("africa/timbuktu", &tzdata::AFRICA_TIMBUKTU),
            ("australia/canberra", &tzdata::AUSTRALIA_ACT),
            ("asia/chongqing", &tzdata::ASIA_CHONGQING),
            ("america/juneau", &tzdata::AMERICA_JUNEAU),
            ("europe/gibraltar", &tzdata::EUROPE_GIBRALTAR),
            ("africa/dakar", &tzdata::AFRICA_DAKAR),
            ("africa/bamako", &tzdata::AFRICA_BAMAKO),
            ("africa/kinshasa", &tzdata::AFRICA_KINSHASA),
            ("asia/baku", &tzdata::ASIA_BAKU),
            ("etc/gmt-9", &tzdata::ETC_GMT_MINUS_9),
            ("asia/magadan", &tzdata::ASIA_MAGADAN),
            ("mexico/bajasur", &tzdata::AMERICA_MAZATLAN),
            ("america/inuvik", &tzdata::AMERICA_INUVIK),
            ("america/cordoba", &tzdata::AMERICA_CORDOBA),
            ("pacific/palau", &tzdata::PACIFIC_PALAU),
            ("asia/aden", &tzdata::ASIA_ADEN),
            ("america/lima", &tzdata::AMERICA_LIMA),
            ("pacific/honolulu", &tzdata::PACIFIC_HONOLULU),
            ("zulu", &tzdata::UCT),
            ("america/anguilla", &tzdata::AMERICA_ANGUILLA),
            ("asia/ust-nera", &tzdata::ASIA_UST_NERA),
            ("brazil/acre", &tzdata::AMERICA_PORTO_ACRE),
            ("asia/manila", &tzdata::ASIA_MANILA),
            ("antarctica/syowa", &tzdata::ANTARCTICA_SYOWA),
            ("met", &tzdata::MET),
            ("asia/tbilisi", &tzdata::ASIA_TBILISI),
            ("africa/libreville", &tzdata::AFRICA_LIBREVILLE),
            ("europe/minsk", &tzdata::EUROPE_MINSK),
            ("asia/tehran", &tzdata::IRAN),
            ("europe/saratov", &tzdata::EUROPE_SARATOV),
            ("indian/christmas", &tzdata::INDIAN_CHRISTMAS),
            ("africa/kampala", &tzdata::AFRICA_KAMPALA),
            ("america/montreal", &tzdata::AMERICA_MONTREAL),
            ("us/michigan", &tzdata::AMERICA_DETROIT),
            ("australia/queensland", &tzdata::AUSTRALIA_BRISBANE),
            ("australia/sydney", &tzdata::AUSTRALIA_ACT),
            ("america/recife", &tzdata::AMERICA_RECIFE),
            ("turkey", &tzdata::TURKEY),
            ("australia/perth", &tzdata::AUSTRALIA_PERTH),
            ("pacific/funafuti", &tzdata::PACIFIC_FUNAFUTI),
            ("us/alaska", &tzdata::AMERICA_ANCHORAGE),
            ("asia/khandyga", &tzdata::ASIA_KHANDYGA),
            ("hst", &tzdata::HST),
            ("africa/blantyre", &tzdata::AFRICA_BLANTYRE),
            ("pacific/fakaofo", &tzdata::PACIFIC_FAKAOFO),
            ("greenwich", &tzdata::GMT),
            ("nz", &tzdata::NZ),
            ("america/creston", &tzdata::AMERICA_CRESTON),
            ("america/godthab", &tzdata::AMERICA_GODTHAB),
            ("asia/srednekolymsk", &tzdata::ASIA_SREDNEKOLYMSK),
            ("asia/aqtobe", &tzdata::ASIA_AQTOBE),
            ("eire", &tzdata::EIRE),
            ("asia/almaty", &tzdata::ASIA_ALMATY),
            ("asia/jayapura", &tzdata::ASIA_JAYAPURA),
            ("asia/jakarta", &tzdata::ASIA_JAKARTA),
            ("europe/paris", &tzdata::EUROPE_PARIS),
            ("asia/tokyo", &tzdata::JAPAN),
            ("rok", &tzdata::ROK),
            ("america/antigua", &tzdata::AMERICA_ANTIGUA),
            ("etc/gmt-10", &tzdata::ETC_GMT_MINUS_10),
            ("europe/budapest", &tzdata::EUROPE_BUDAPEST),
            ("asia/hong_kong", &tzdata::HONGKONG),
            ("europe/oslo", &tzdata::ARCTIC_LONGYEARBYEN),
            ("roc", &tzdata::ROC),
            ("etc/gmt-13", &tzdata::ETC_GMT_MINUS_13),
            ("pacific/galapagos", &tzdata::PACIFIC_GALAPAGOS),
            ("america/moncton", &tzdata::AMERICA_MONCTON),
            ("america/louisville", &tzdata::AMERICA_LOUISVILLE),
            ("asia/chungking", &tzdata::ASIA_CHONGQING),
            ("canada/yukon", &tzdata::AMERICA_WHITEHORSE),
            ("w-su", &tzdata::W_SU),
            ("australia/brisbane", &tzdata::AUSTRALIA_BRISBANE),
            ("europe/mariehamn", &tzdata::EUROPE_HELSINKI),
            ("pacific/pohnpei", &tzdata::PACIFIC_POHNPEI),
            ("uct", &tzdata::UCT),
            ("america/marigot", &tzdata::AMERICA_MARIGOT),
            ("america/santiago", &tzdata::AMERICA_SANTIAGO),
            ("america/bogota", &tzdata::AMERICA_BOGOTA),
            ("america/costa_rica", &tzdata::AMERICA_COSTA_RICA),
            ("asia/jerusalem", &tzdata::ISRAEL),
            ("iceland", &tzdata::ICELAND),
            ("america/yakutat", &tzdata::AMERICA_YAKUTAT),
            ("america/rankin_inlet", &tzdata::AMERICA_RANKIN_INLET),
            ("europe/volgograd", &tzdata::EUROPE_VOLGOGRAD),
            ("europe/tirane", &tzdata::EUROPE_TIRANE),
            ("america/st_johns", &tzdata::AMERICA_ST_JOHNS),
            ("europe/monaco", &tzdata::EUROPE_MONACO),
            ("indian/reunion", &tzdata::INDIAN_REUNION),
            ("pacific/noumea", &tzdata::PACIFIC_NOUMEA),
            ("europe/samara", &tzdata::EUROPE_SAMARA),
            ("africa/porto-novo", &tzdata::AFRICA_PORTO_NOVO),
            ("america/virgin", &tzdata::AMERICA_ST_THOMAS),
            ("europe/istanbul", &tzdata::TURKEY),
            ("pacific/kwajalein", &tzdata::KWAJALEIN),
            ("america/st_kitts", &tzdata::AMERICA_ST_KITTS),
            ("america/guatemala", &tzdata::AMERICA_GUATEMALA),
            ("europe/uzhgorod", &tzdata::EUROPE_UZHGOROD),
            ("pacific/truk", &tzdata::PACIFIC_CHUUK),
            ("asia/vientiane", &tzdata::ASIA_VIENTIANE),
        ],
    };

#[cfg(all(feature = "binary", feature = "by-name"))]
pub(crate) const RAW_TIME_ZONES_BY_NAME: phf::Map<&'static str, &'static [u8]> = ::phf::Map {
    key: 12913932095322966823,
    disps: &[
        (0, 27),
        (0, 63),
        (0, 0),
        (0, 0),
        (0, 1),
        (0, 0),
        (0, 4),
        (0, 123),
        (0, 102),
        (0, 13),
        (0, 13),
        (0, 1),
        (0, 172),
        (0, 44),
        (0, 1),
        (2, 241),
        (0, 199),
        (0, 5),
        (0, 11),
        (0, 172),
        (0, 102),
        (1, 570),
        (0, 4),
        (1, 48),
        (0, 9),
        (0, 133),
        (0, 147),
        (0, 25),
        (0, 34),
        (2, 32),
        (0, 262),
        (0, 552),
        (1, 204),
        (0, 256),
        (0, 441),
        (3, 0),
        (3, 361),
        (0, 501),
        (0, 22),
        (0, 7),
        (0, 45),
        (1, 184),
        (0, 3),
        (0, 424),
        (0, 1),
        (5, 408),
        (0, 113),
        (0, 50),
        (0, 4),
        (1, 426),
        (0, 0),
        (1, 243),
        (10, 50),
        (0, 142),
        (0, 2),
        (2, 512),
        (0, 95),
        (2, 199),
        (0, 20),
        (0, 82),
        (0, 315),
        (0, 535),
        (10, 132),
        (0, 10),
        (3, 519),
        (2, 147),
        (0, 1),
        (0, 47),
        (0, 3),
        (0, 11),
        (0, 4),
        (0, 72),
        (0, 20),
        (1, 3),
        (0, 67),
        (0, 457),
        (0, 17),
        (0, 262),
        (0, 376),
        (0, 45),
        (0, 209),
        (0, 21),
        (0, 256),
        (0, 12),
        (0, 43),
        (0, 18),
        (0, 238),
        (0, 0),
        (0, 134),
        (0, 262),
        (0, 147),
        (0, 40),
        (1, 112),
        (0, 147),
        (1, 449),
        (2, 8),
        (0, 183),
        (3, 420),
        (1, 244),
        (1, 534),
        (1, 76),
        (2, 327),
        (0, 96),
        (0, 221),
        (1, 5),
        (0, 147),
        (0, 475),
        (9, 257),
        (33, 245),
        (2, 236),
        (0, 1),
        (6, 435),
        (5, 372),
        (0, 356),
        (2, 359),
    ],
    entries: &[
        ("pacific/kiritimati", raw_tzdata::PACIFIC_KIRITIMATI),
        ("africa/maseru", raw_tzdata::AFRICA_MASERU),
        ("australia/broken_hill", raw_tzdata::AUSTRALIA_BROKEN_HILL),
        ("africa/el_aaiun", raw_tzdata::AFRICA_EL_AAIUN),
        ("asia/singapore", raw_tzdata::SINGAPORE),
        ("america/santa_isabel", raw_tzdata::AMERICA_SANTA_ISABEL),
        ("etc/gmt-0", raw_tzdata::GMT),
        ("asia/yerevan", raw_tzdata::ASIA_YEREVAN),
        ("etc/gmt+9", raw_tzdata::ETC_GMT_PLUS_9),
        ("pacific/samoa", raw_tzdata::PACIFIC_PAGO_PAGO),
        ("asia/samarkand", raw_tzdata::ASIA_SAMARKAND),
        ("australia/eucla", raw_tzdata::AUSTRALIA_EUCLA),
        ("europe/simferopol", raw_tzdata::EUROPE_SIMFEROPOL),
        ("america/chicago", raw_tzdata::AMERICA_CHICAGO),
        ("europe/tiraspol", raw_tzdata::EUROPE_TIRASPOL),
        ("pst8pdt", raw_tzdata::PST_8_PDT),
        ("pacific/majuro", raw_tzdata::PACIFIC_MAJURO),
        ("africa/ouagadougou", raw_tzdata::AFRICA_OUAGADOUGOU),
        ("etc/gmt+10", raw_tzdata::ETC_GMT_PLUS_10),
        ("america/nuuk", raw_tzdata::AMERICA_GODTHAB),
        ("indian/mahe", raw_tzdata::INDIAN_MAHE),
        ("africa/lome", raw_tzdata::AFRICA_LOME),
        ("asia/beirut", raw_tzdata::ASIA_BEIRUT),
        ("us/east-indiana", raw_tzdata::AMERICA_FORT_WAYNE),
        ("europe/ulyanovsk", raw_tzdata::EUROPE_ULYANOVSK),
        ("asia/dacca", raw_tzdata::ASIA_DACCA),
        ("mexico/bajanorte", raw_tzdata::AMERICA_SANTA_ISABEL),
        ("america/maceio", raw_tzdata::AMERICA_MACEIO),
        ("atlantic/reykjavik", raw_tzdata::ICELAND),
        ("america/ojinaga", raw_tzdata::AMERICA_OJINAGA),
        ("africa/casablanca", raw_tzdata::AFRICA_CASABLANCA),
        ("africa/luanda", raw_tzdata::AFRICA_LUANDA),
        ("asia/makassar", raw_tzdata::ASIA_MAKASSAR),
        ("america/phoenix", raw_tzdata::AMERICA_PHOENIX),
        ("kwajalein", raw_tzdata::KWAJALEIN),
        ("europe/moscow", raw_tzdata::W_SU),
        ("antarctica/mcmurdo", raw_tzdata::ANTARCTICA_MC_MURDO),
        ("asia/hovd", raw_tzdata::ASIA_HOVD),
        ("asia/dubai", raw_tzdata::ASIA_DUBAI),
        ("etc/gmt+0", raw_tzdata::GMT),
        ("africa/freetown", raw_tzdata::AFRICA_FREETOWN),
        ("est", raw_tzdata::EST),
        ("gmt+0", raw_tzdata::GMT),
        ("america/blanc-sablon", raw_tzdata::AMERICA_BLANC_SABLON),
        ("america/porto_acre", raw_tzdata::AMERICA_PORTO_ACRE),
        ("indian/mauritius", raw_tzdata::INDIAN_MAURITIUS),
        ("europe/rome", raw_tzdata::EUROPE_ROME),
        ("europe/vilnius", raw_tzdata::EUROPE_VILNIUS),
        ("america/punta_arenas", raw_tzdata::AMERICA_PUNTA_ARENAS),
        ("europe/podgorica", raw_tzdata::EUROPE_BELGRADE),
        ("asia/brunei", raw_tzdata::ASIA_BRUNEI),
        ("america/sitka", raw_tzdata::AMERICA_SITKA),
        ("america/rosario", raw_tzdata::AMERICA_ROSARIO),
        ("europe/athens", raw_tzdata::EUROPE_ATHENS),
        ("pacific/pago_pago", raw_tzdata::PACIFIC_PAGO_PAGO),
        ("america/dominica", raw_tzdata::AMERICA_DOMINICA),
        ("america/menominee", raw_tzdata::AMERICA_MENOMINEE),
        ("africa/lusaka", raw_tzdata::AFRICA_LUSAKA),
        ("africa/ndjamena", raw_tzdata::AFRICA_NDJAMENA),
        ("etc/gmt+4", raw_tzdata::ETC_GMT_PLUS_4),
        ("asia/macau", raw_tzdata::ASIA_MACAO),
        ("antarctica/palmer", raw_tzdata::ANTARCTICA_PALMER),
        ("indian/chagos", raw_tzdata::INDIAN_CHAGOS),
        ("africa/malabo", raw_tzdata::AFRICA_MALABO),
        ("africa/nouakchott", raw_tzdata::AFRICA_NOUAKCHOTT),
        ("europe/luxembourg", raw_tzdata::EUROPE_LUXEMBOURG),
        ("europe/bratislava", raw_tzdata::EUROPE_BRATISLAVA),
        ("africa/addis_ababa", raw_tzdata::AFRICA_ADDIS_ABABA),
        ("brazil/denoronha", raw_tzdata::AMERICA_NORONHA),
        ("asia/ulan_bator", raw_tzdata::ASIA_ULAANBAATAR),
        ("jamaica", raw_tzdata::JAMAICA),
        ("europe/isle_of_man", raw_tzdata::EUROPE_ISLE_OF_MAN),
        ("asia/chita", raw_tzdata::ASIA_CHITA),
        ("europe/andorra", raw_tzdata::EUROPE_ANDORRA),
        ("gmt-0", raw_tzdata::GMT),
        ("america/fortaleza", raw_tzdata::AMERICA_FORTALEZA),
        ("america/knox_in", raw_tzdata::AMERICA_KNOX_IN),
        ("pacific/yap", raw_tzdata::PACIFIC_CHUUK),
        ("america/santarem", raw_tzdata::AMERICA_SANTAREM),
        ("arctic/longyearbyen", raw_tzdata::ARCTIC_LONGYEARBYEN),
        ("america/porto_velho", raw_tzdata::AMERICA_PORTO_VELHO),
        ("europe/lisbon", raw_tzdata::PORTUGAL),
        ("pacific/wake", raw_tzdata::PACIFIC_WAKE),
        ("america/curacao", raw_tzdata::AMERICA_CURACAO),
        ("singapore", raw_tzdata::SINGAPORE),
        ("australia/lord_howe", raw_tzdata::AUSTRALIA_LHI),
        ("universal", raw_tzdata::UCT),
        ("europe/astrakhan", raw_tzdata::EUROPE_ASTRAKHAN),
        ("utc", raw_tzdata::UCT),
        ("australia/hobart", raw_tzdata::AUSTRALIA_HOBART),
        ("antarctica/south_pole", raw_tzdata::ANTARCTICA_MC_MURDO),
        ("africa/conakry", raw_tzdata::AFRICA_CONAKRY),
        ("europe/warsaw", raw_tzdata::POLAND),
        ("europe/guernsey", raw_tzdata::EUROPE_GUERNSEY),
        ("america/cayman", raw_tzdata::AMERICA_CAYMAN),
        ("asia/nicosia", raw_tzdata::ASIA_NICOSIA),
        ("chile/easterisland", raw_tzdata::CHILE_EASTER_ISLAND),
        ("pacific/tongatapu", raw_tzdata::PACIFIC_TONGATAPU),
        ("america/caracas", raw_tzdata::AMERICA_CARACAS),
        ("canada/saskatchewan", raw_tzdata::AMERICA_REGINA),
        ("america/grenada", raw_tzdata::AMERICA_GRENADA),
        ("atlantic/south_georgia", raw_tzdata::ATLANTIC_SOUTH_GEORGIA),
        ("asia/qostanay", raw_tzdata::ASIA_QOSTANAY),
        ("africa/nairobi", raw_tzdata::AFRICA_NAIROBI),
        ("america/mendoza", raw_tzdata::AMERICA_MENDOZA),
        ("asia/barnaul", raw_tzdata::ASIA_BARNAUL),
        ("asia/tashkent", raw_tzdata::ASIA_TASHKENT),
        ("pacific/tahiti", raw_tzdata::PACIFIC_TAHITI),
        ("japan", raw_tzdata::JAPAN),
        ("pacific/niue", raw_tzdata::PACIFIC_NIUE),
        ("asia/dhaka", raw_tzdata::ASIA_DACCA),
        ("atlantic/st_helena", raw_tzdata::ATLANTIC_ST_HELENA),
        ("cuba", raw_tzdata::CUBA),
        ("europe/berlin", raw_tzdata::EUROPE_BERLIN),
        ("america/belem", raw_tzdata::AMERICA_BELEM),
        ("etc/gmt-4", raw_tzdata::ETC_GMT_MINUS_4),
        ("antarctica/troll", raw_tzdata::ANTARCTICA_TROLL),
        ("europe/kaliningrad", raw_tzdata::EUROPE_KALININGRAD),
        ("africa/djibouti", raw_tzdata::AFRICA_DJIBOUTI),
        ("europe/belgrade", raw_tzdata::EUROPE_BELGRADE),
        ("africa/ceuta", raw_tzdata::AFRICA_CEUTA),
        ("us/aleutian", raw_tzdata::AMERICA_ADAK),
        ("america/vancouver", raw_tzdata::AMERICA_VANCOUVER),
        ("gmt", raw_tzdata::GMT),
        ("america/puerto_rico", raw_tzdata::AMERICA_PUERTO_RICO),
        ("etc/gmt+7", raw_tzdata::ETC_GMT_PLUS_7),
        ("america/dawson_creek", raw_tzdata::AMERICA_DAWSON_CREEK),
        ("pacific/norfolk", raw_tzdata::PACIFIC_NORFOLK),
        ("gb-eire", raw_tzdata::GB),
        ("asia/hanoi", raw_tzdata::ASIA_HANOI),
        ("america/nassau", raw_tzdata::AMERICA_NASSAU),
        ("america/fort_nelson", raw_tzdata::AMERICA_FORT_NELSON),
        ("america/goose_bay", raw_tzdata::AMERICA_GOOSE_BAY),
        ("america/cancun", raw_tzdata::AMERICA_CANCUN),
        ("africa/asmera", raw_tzdata::AFRICA_ASMARA),
        ("europe/belfast", raw_tzdata::EUROPE_BELFAST),
        ("pacific/wallis", raw_tzdata::PACIFIC_WALLIS),
        ("etc/localtime", raw_tzdata::GMT),
        ("africa/kigali", raw_tzdata::AFRICA_KIGALI),
        ("etc/greenwich", raw_tzdata::GMT),
        ("egypt", raw_tzdata::EGYPT),
        ("africa/algiers", raw_tzdata::AFRICA_ALGIERS),
        ("asia/sakhalin", raw_tzdata::ASIA_SAKHALIN),
        ("asia/qatar", raw_tzdata::ASIA_QATAR),
        ("america/barbados", raw_tzdata::AMERICA_BARBADOS),
        ("asia/kuwait", raw_tzdata::ASIA_KUWAIT),
        ("etc/gmt0", raw_tzdata::GMT),
        ("antarctica/rothera", raw_tzdata::ANTARCTICA_ROTHERA),
        ("america/manaus", raw_tzdata::AMERICA_MANAUS),
        ("america/cambridge_bay", raw_tzdata::AMERICA_CAMBRIDGE_BAY),
        ("us/indiana-starke", raw_tzdata::AMERICA_KNOX_IN),
        ("mst", raw_tzdata::MST),
        ("etc/gmt+1", raw_tzdata::ATLANTIC_JAN_MAYEN),
        ("asia/baghdad", raw_tzdata::ASIA_BAGHDAD),
        ("asia/gaza", raw_tzdata::ASIA_GAZA),
        ("america/montevideo", raw_tzdata::AMERICA_MONTEVIDEO),
        ("atlantic/madeira", raw_tzdata::ATLANTIC_MADEIRA),
        ("america/rio_branco", raw_tzdata::AMERICA_PORTO_ACRE),
        ("asia/qyzylorda", raw_tzdata::ASIA_QYZYLORDA),
        ("asia/kolkata", raw_tzdata::ASIA_CALCUTTA),
        ("etc/gmt-5", raw_tzdata::ETC_GMT_MINUS_5),
        ("asia/ashgabat", raw_tzdata::ASIA_ASHGABAT),
        ("asia/novokuznetsk", raw_tzdata::ASIA_NOVOKUZNETSK),
        ("pacific/nauru", raw_tzdata::PACIFIC_NAURU),
        ("atlantic/faeroe", raw_tzdata::ATLANTIC_FAEROE),
        ("america/araguaina", raw_tzdata::AMERICA_ARAGUAINA),
        ("etc/gmt+5", raw_tzdata::ETC_GMT_PLUS_5),
        ("europe/madrid", raw_tzdata::EUROPE_MADRID),
        ("america/tijuana", raw_tzdata::AMERICA_SANTA_ISABEL),
        ("asia/choibalsan", raw_tzdata::ASIA_CHOIBALSAN),
        ("asia/ho_chi_minh", raw_tzdata::ASIA_HO_CHI_MINH),
        ("america/la_paz", raw_tzdata::AMERICA_LA_PAZ),
        ("pacific/saipan", raw_tzdata::PACIFIC_SAIPAN),
        ("america/halifax", raw_tzdata::AMERICA_HALIFAX),
        ("europe/nicosia", raw_tzdata::ASIA_NICOSIA),
        ("pacific/fiji", raw_tzdata::PACIFIC_FIJI),
        ("us/mountain", raw_tzdata::NAVAJO),
        ("etc/gmt+11", raw_tzdata::ETC_GMT_PLUS_11),
        ("canada/central", raw_tzdata::AMERICA_WINNIPEG),
        ("canada/mountain", raw_tzdata::AMERICA_EDMONTON),
        ("europe/kiev", raw_tzdata::EUROPE_KIEV),
        ("etc/gmt-14", raw_tzdata::ETC_GMT_MINUS_14),
        ("indian/mayotte", raw_tzdata::INDIAN_MAYOTTE),
        ("africa/harare", raw_tzdata::AFRICA_HARARE),
        ("asia/tel_aviv", raw_tzdata::ASIA_TEL_AVIV),
        ("hongkong", raw_tzdata::HONGKONG),
        ("mexico/general", raw_tzdata::AMERICA_MEXICO_CITY),
        ("gmt0", raw_tzdata::GMT),
        ("africa/sao_tome", raw_tzdata::AFRICA_SAO_TOME),
        ("america/asuncion", raw_tzdata::AMERICA_ASUNCION),
        ("america/kralendijk", raw_tzdata::AMERICA_CURACAO),
        ("cet", raw_tzdata::CET),
        ("america/belize", raw_tzdata::AMERICA_BELIZE),
        ("america/boise", raw_tzdata::AMERICA_BOISE),
        ("america/atikokan", raw_tzdata::AMERICA_ATIKOKAN),
        (
            "antarctica/dumontdurville",
            raw_tzdata::ANTARCTICA_DUMONT_D_URVILLE,
        ),
        ("america/guadeloupe", raw_tzdata::AMERICA_GUADELOUPE),
        ("etc/universal", raw_tzdata::UCT),
        ("atlantic/stanley", raw_tzdata::ATLANTIC_STANLEY),
        ("america/detroit", raw_tzdata::AMERICA_DETROIT),
        ("america/fort_wayne", raw_tzdata::AMERICA_FORT_WAYNE),
        ("europe/copenhagen", raw_tzdata::EUROPE_COPENHAGEN),
        ("asia/harbin", raw_tzdata::ASIA_HARBIN),
        ("etc/zulu", raw_tzdata::UCT),
        ("america/scoresbysund", raw_tzdata::AMERICA_SCORESBYSUND),
        ("australia/west", raw_tzdata::AUSTRALIA_PERTH),
        ("asia/krasnoyarsk", raw_tzdata::ASIA_KRASNOYARSK),
        ("australia/south", raw_tzdata::AUSTRALIA_ADELAIDE),
        ("asia/karachi", raw_tzdata::ASIA_KARACHI),
        ("pacific/guadalcanal", raw_tzdata::PACIFIC_GUADALCANAL),
        ("pacific/kanton", raw_tzdata::PACIFIC_KANTON),
        ("asia/riyadh", raw_tzdata::ASIA_RIYADH),
        ("australia/victoria", raw_tzdata::AUSTRALIA_MELBOURNE),
        ("asia/bangkok", raw_tzdata::ASIA_BANGKOK),
        ("libya", raw_tzdata::LIBYA),
        ("america/paramaribo", raw_tzdata::AMERICA_PARAMARIBO),
        ("pacific/chuuk", raw_tzdata::PACIFIC_CHUUK),
        ("america/st_lucia", raw_tzdata::AMERICA_ST_LUCIA),
        ("etc/gmt-2", raw_tzdata::ETC_GMT_MINUS_2),
        ("africa/bangui", raw_tzdata::AFRICA_BANGUI),
        ("atlantic/jan_mayen", raw_tzdata::ATLANTIC_JAN_MAYEN),
        ("america/tegucigalpa", raw_tzdata::AMERICA_TEGUCIGALPA),
        ("indian/maldives", raw_tzdata::INDIAN_MALDIVES),
        ("atlantic/cape_verde", raw_tzdata::ATLANTIC_CAPE_VERDE),
        ("eet", raw_tzdata::EET),
        ("europe/prague", raw_tzdata::EUROPE_BRATISLAVA),
        ("gb", raw_tzdata::GB),
        ("asia/phnom_penh", raw_tzdata::ASIA_PHNOM_PENH),
        ("wet", raw_tzdata::WET),
        ("antarctica/casey", raw_tzdata::ANTARCTICA_CASEY),
        ("europe/san_marino", raw_tzdata::EUROPE_ROME),
        ("america/thule", raw_tzdata::AMERICA_THULE),
        ("africa/bissau", raw_tzdata::AFRICA_BISSAU),
        ("asia/irkutsk", raw_tzdata::ASIA_IRKUTSK),
        ("america/santo_domingo", raw_tzdata::AMERICA_SANTO_DOMINGO),
        ("america/nipigon", raw_tzdata::AMERICA_NIPIGON),
        ("america/coral_harbour", raw_tzdata::AMERICA_CORAL_HARBOUR),
        ("pacific/chatham", raw_tzdata::NZ_CHAT),
        ("europe/jersey", raw_tzdata::EUROPE_JERSEY),
        ("america/st_thomas", raw_tzdata::AMERICA_ST_THOMAS),
        ("chile/continental", raw_tzdata::AMERICA_SANTIAGO),
        ("africa/khartoum", raw_tzdata::AFRICA_KHARTOUM),
        ("indian/kerguelen", raw_tzdata::INDIAN_KERGUELEN),
        ("pacific/gambier", raw_tzdata::PACIFIC_GAMBIER),
        ("pacific/rarotonga", raw_tzdata::PACIFIC_RAROTONGA),
        ("pacific/kosrae", raw_tzdata::PACIFIC_KOSRAE),
        ("asia/istanbul", raw_tzdata::TURKEY),
        ("america/indianapolis", raw_tzdata::AMERICA_FORT_WAYNE),
        ("america/whitehorse", raw_tzdata::AMERICA_WHITEHORSE),
        ("canada/eastern", raw_tzdata::AMERICA_TORONTO),
        ("antarctica/mawson", raw_tzdata::ANTARCTICA_MAWSON),
        ("america/los_angeles", raw_tzdata::AMERICA_LOS_ANGELES),
        ("africa/gaborone", raw_tzdata::AFRICA_GABORONE),
        ("america/guayaquil", raw_tzdata::AMERICA_GUAYAQUIL),
        ("pacific/port_moresby", raw_tzdata::PACIFIC_PORT_MORESBY),
        ("america/lower_princes", raw_tzdata::AMERICA_CURACAO),
        ("pacific/auckland", raw_tzdata::NZ),
        ("america/glace_bay", raw_tzdata::AMERICA_GLACE_BAY),
        ("africa/mbabane", raw_tzdata::AFRICA_MBABANE),
        ("asia/calcutta", raw_tzdata::ASIA_CALCUTTA),
        ("asia/oral", raw_tzdata::ASIA_ORAL),
        ("us/samoa", raw_tzdata::PACIFIC_PAGO_PAGO),
        ("america/matamoros", raw_tzdata::AMERICA_MATAMOROS),
        ("europe/tallinn", raw_tzdata::EUROPE_TALLINN),
        ("asia/ulaanbaatar", raw_tzdata::ASIA_ULAANBAATAR),
        ("africa/bujumbura", raw_tzdata::AFRICA_BUJUMBURA),
        ("canada/atlantic", raw_tzdata::AMERICA_HALIFAX),
        ("us/hawaii", raw_tzdata::PACIFIC_HONOLULU),
        ("antarctica/macquarie", raw_tzdata::ANTARCTICA_MACQUARIE),
        ("europe/skopje", raw_tzdata::EUROPE_SKOPJE),
        ("asia/vladivostok", raw_tzdata::ASIA_VLADIVOSTOK),
        ("etc/gmt+6", raw_tzdata::ETC_GMT_PLUS_6),
        ("america/boa_vista", raw_tzdata::AMERICA_BOA_VISTA),
        ("europe/vaduz", raw_tzdata::EUROPE_VADUZ),
        ("asia/dushanbe", raw_tzdata::ASIA_DUSHANBE),
        ("portugal", raw_tzdata::PORTUGAL),
        ("atlantic/azores", raw_tzdata::ATLANTIC_AZORES),
        ("mst7mdt", raw_tzdata::MST_7_MDT),
        ("brazil/west", raw_tzdata::AMERICA_MANAUS),
        ("america/st_vincent", raw_tzdata::AMERICA_ST_VINCENT),
        ("etc/gmt-6", raw_tzdata::ETC_GMT_MINUS_6),
        ("asia/shanghai", raw_tzdata::PRC),
        ("africa/banjul", raw_tzdata::AFRICA_BANJUL),
        ("asia/bahrain", raw_tzdata::ASIA_BAHRAIN),
        ("asia/ashkhabad", raw_tzdata::ASIA_ASHGABAT),
        ("africa/windhoek", raw_tzdata::AFRICA_WINDHOEK),
        ("africa/mogadishu", raw_tzdata::AFRICA_MOGADISHU),
        ("etc/utc", raw_tzdata::UCT),
        ("pacific/midway", raw_tzdata::PACIFIC_MIDWAY),
        ("us/central", raw_tzdata::AMERICA_CHICAGO),
        ("asia/muscat", raw_tzdata::ASIA_MUSCAT),
        ("cst6cdt", raw_tzdata::CST_6_CDT),
        ("america/shiprock", raw_tzdata::NAVAJO),
        ("africa/monrovia", raw_tzdata::AFRICA_MONROVIA),
        ("america/cayenne", raw_tzdata::AMERICA_CAYENNE),
        ("asia/damascus", raw_tzdata::ASIA_DAMASCUS),
        ("america/dawson", raw_tzdata::AMERICA_DAWSON),
        ("america/aruba", raw_tzdata::AMERICA_ARUBA),
        ("pacific/guam", raw_tzdata::PACIFIC_GUAM),
        ("indian/cocos", raw_tzdata::INDIAN_COCOS),
        ("asia/yangon", raw_tzdata::ASIA_RANGOON),
        ("america/eirunepe", raw_tzdata::AMERICA_EIRUNEPE),
        ("america/monterrey", raw_tzdata::AMERICA_MONTERREY),
        ("etc/gmt", raw_tzdata::GMT),
        ("america/havana", raw_tzdata::CUBA),
        ("etc/gmt-3", raw_tzdata::ETC_GMT_MINUS_3),
        ("america/regina", raw_tzdata::AMERICA_REGINA),
        ("asia/macao", raw_tzdata::ASIA_MACAO),
        ("america/port_of_spain", raw_tzdata::AMERICA_MARIGOT),
        ("asia/kuching", raw_tzdata::ASIA_KUCHING),
        ("navajo", raw_tzdata::NAVAJO),
        ("canada/newfoundland", raw_tzdata::AMERICA_ST_JOHNS),
        ("nz-chat", raw_tzdata::NZ_CHAT),
        ("europe/kirov", raw_tzdata::EUROPE_KIROV),
        ("asia/pontianak", raw_tzdata::ASIA_PONTIANAK),
        ("etc/gmt+2", raw_tzdata::ETC_GMT_PLUS_2),
        ("asia/aqtau", raw_tzdata::ASIA_AQTAU),
        ("america/sao_paulo", raw_tzdata::AMERICA_SAO_PAULO),
        ("etc/gmt-1", raw_tzdata::ETC_GMT_MINUS_1),
        ("etc/gmt+3", raw_tzdata::ETC_GMT_PLUS_3),
        ("america/noronha", raw_tzdata::AMERICA_NORONHA),
        ("africa/douala", raw_tzdata::AFRICA_DOUALA),
        ("africa/dar_es_salaam", raw_tzdata::AFRICA_DAR_ES_SALAAM),
        ("australia/adelaide", raw_tzdata::AUSTRALIA_ADELAIDE),
        ("asia/pyongyang", raw_tzdata::ASIA_PYONGYANG),
        ("asia/dili", raw_tzdata::ASIA_DILI),
        ("asia/kabul", raw_tzdata::ASIA_KABUL),
        ("etc/uct", raw_tzdata::UCT),
        ("america/adak", raw_tzdata::AMERICA_ADAK),
        ("brazil/east", raw_tzdata::AMERICA_SAO_PAULO),
        ("pacific/easter", raw_tzdata::CHILE_EASTER_ISLAND),
        ("europe/riga", raw_tzdata::EUROPE_RIGA),
        ("europe/brussels", raw_tzdata::EUROPE_BRUSSELS),
        ("israel", raw_tzdata::ISRAEL),
        ("pacific/bougainville", raw_tzdata::PACIFIC_BOUGAINVILLE),
        ("america/danmarkshavn", raw_tzdata::AMERICA_DANMARKSHAVN),
        ("australia/yancowinna", raw_tzdata::AUSTRALIA_BROKEN_HILL),
        ("america/iqaluit", raw_tzdata::AMERICA_IQALUIT),
        ("america/montserrat", raw_tzdata::AMERICA_MONTSERRAT),
        ("asia/amman", raw_tzdata::ASIA_AMMAN),
        ("america/miquelon", raw_tzdata::AMERICA_MIQUELON),
        ("america/mazatlan", raw_tzdata::AMERICA_MAZATLAN),
        ("asia/tomsk", raw_tzdata::ASIA_TOMSK),
        ("asia/novosibirsk", raw_tzdata::ASIA_NOVOSIBIRSK),
        ("america/ensenada", raw_tzdata::AMERICA_ENSENADA),
        ("europe/malta", raw_tzdata::EUROPE_MALTA),
        ("asia/thimphu", raw_tzdata::ASIA_THIMBU),
        ("us/arizona", raw_tzdata::AMERICA_PHOENIX),
        ("pacific/pitcairn", raw_tzdata::PACIFIC_PITCAIRN),
        ("america/guyana", raw_tzdata::AMERICA_GUYANA),
        ("australia/currie", raw_tzdata::AUSTRALIA_CURRIE),
        ("america/campo_grande", raw_tzdata::AMERICA_CAMPO_GRANDE),
        ("asia/ujung_pandang", raw_tzdata::ASIA_MAKASSAR),
        ("europe/stockholm", raw_tzdata::EUROPE_STOCKHOLM),
        ("etc/gmt-11", raw_tzdata::ETC_GMT_MINUS_11),
        ("america/metlakatla", raw_tzdata::AMERICA_METLAKATLA),
        ("africa/asmara", raw_tzdata::AFRICA_ASMARA),
        ("europe/amsterdam", raw_tzdata::EUROPE_AMSTERDAM),
        ("europe/bucharest", raw_tzdata::EUROPE_BUCHAREST),
        ("asia/bishkek", raw_tzdata::ASIA_BISHKEK),
        ("australia/act", raw_tzdata::AUSTRALIA_ACT),
        ("america/jamaica", raw_tzdata::JAMAICA),
        ("australia/tasmania", raw_tzdata::AUSTRALIA_HOBART),
        ("europe/london", raw_tzdata::GB),
        ("asia/rangoon", raw_tzdata::ASIA_RANGOON),
        ("america/martinique", raw_tzdata::AMERICA_MARTINIQUE),
        ("america/grand_turk", raw_tzdata::AMERICA_GRAND_TURK),
        ("pacific/enderbury", raw_tzdata::PACIFIC_ENDERBURY),
        ("australia/melbourne", raw_tzdata::AUSTRALIA_MELBOURNE),
        ("asia/yakutsk", raw_tzdata::ASIA_YAKUTSK),
        ("america/panama", raw_tzdata::AMERICA_PANAMA),
        ("america/el_salvador", raw_tzdata::AMERICA_EL_SALVADOR),
        ("africa/lagos", raw_tzdata::AFRICA_LAGOS),
        ("est5edt", raw_tzdata::EST_5_EDT),
        ("asia/yekaterinburg", raw_tzdata::ASIA_YEKATERINBURG),
        ("asia/anadyr", raw_tzdata::ASIA_ANADYR),
        ("america/rainy_river", raw_tzdata::AMERICA_RAINY_RIVER),
        ("america/new_york", raw_tzdata::AMERICA_NEW_YORK),
        ("africa/tunis", raw_tzdata::AFRICA_TUNIS),
        ("europe/zaporozhye", raw_tzdata::EUROPE_ZAPOROZHYE),
        ("africa/niamey", raw_tzdata::AFRICA_NIAMEY),
        ("asia/seoul", raw_tzdata::ROK),
        ("america/catamarca", raw_tzdata::AMERICA_CATAMARCA),
        ("america/edmonton", raw_tzdata::AMERICA_EDMONTON),
        ("iran", raw_tzdata::IRAN),
        ("europe/sofia", raw_tzdata::EUROPE_SOFIA),
        ("pacific/ponape", raw_tzdata::PACIFIC_POHNPEI),
        ("america/swift_current", raw_tzdata::AMERICA_SWIFT_CURRENT),
        ("asia/taipei", raw_tzdata::ROC),
        ("america/buenos_aires", raw_tzdata::AMERICA_BUENOS_AIRES),
        ("europe/zagreb", raw_tzdata::EUROPE_ZAGREB),
        ("europe/sarajevo", raw_tzdata::EUROPE_SARAJEVO),
        ("atlantic/bermuda", raw_tzdata::ATLANTIC_BERMUDA),
        ("factory", raw_tzdata::FACTORY),
        ("africa/abidjan", raw_tzdata::AFRICA_ABIDJAN),
        ("america/nome", raw_tzdata::AMERICA_NOME),
        ("australia/north", raw_tzdata::AUSTRALIA_DARWIN),
        ("america/chihuahua", raw_tzdata::AMERICA_CHIHUAHUA),
        ("indian/antananarivo", raw_tzdata::INDIAN_ANTANANARIVO),
        ("africa/johannesburg", raw_tzdata::AFRICA_JOHANNESBURG),
        ("africa/juba", raw_tzdata::AFRICA_JUBA),
        ("antarctica/davis", raw_tzdata::ANTARCTICA_DAVIS),
        ("asia/kuala_lumpur", raw_tzdata::ASIA_KUALA_LUMPUR),
        ("canada/pacific", raw_tzdata::AMERICA_VANCOUVER),
        ("indian/comoro", raw_tzdata::INDIAN_COMORO),
        ("america/yellowknife", raw_tzdata::AMERICA_YELLOWKNIFE),
        ("africa/brazzaville", raw_tzdata::AFRICA_BRAZZAVILLE),
        ("america/resolute", raw_tzdata::AMERICA_RESOLUTE),
        ("africa/maputo", raw_tzdata::AFRICA_MAPUTO),
        ("africa/cairo", raw_tzdata::EGYPT),
        ("etc/gmt-7", raw_tzdata::ETC_GMT_MINUS_7),
        ("atlantic/canary", raw_tzdata::ATLANTIC_CANARY),
        ("america/port-au-prince", raw_tzdata::AMERICA_PORT_AU_PRINCE),
        ("pacific/tarawa", raw_tzdata::PACIFIC_TARAWA),
        ("etc/gmt+8", raw_tzdata::ETC_GMT_PLUS_8),
        ("atlantic/faroe", raw_tzdata::ATLANTIC_FAEROE),
        ("etc/gmt+12", raw_tzdata::ETC_GMT_PLUS_12),
        ("america/mexico_city", raw_tzdata::AMERICA_MEXICO_CITY),
        ("antarctica/vostok", raw_tzdata::ANTARCTICA_VOSTOK),
        ("asia/thimbu", raw_tzdata::ASIA_THIMBU),
        ("america/merida", raw_tzdata::AMERICA_MERIDA),
        ("america/pangnirtung", raw_tzdata::AMERICA_PANGNIRTUNG),
        ("europe/vienna", raw_tzdata::EUROPE_VIENNA),
        ("prc", raw_tzdata::PRC),
        ("europe/chisinau", raw_tzdata::EUROPE_CHISINAU),
        ("etc/gmt-8", raw_tzdata::ETC_GMT_MINUS_8),
        ("australia/lhi", raw_tzdata::AUSTRALIA_LHI),
        ("australia/darwin", raw_tzdata::AUSTRALIA_DARWIN),
        ("america/jujuy", raw_tzdata::AMERICA_JUJUY),
        ("asia/colombo", raw_tzdata::ASIA_COLOMBO),
        ("america/anchorage", raw_tzdata::AMERICA_ANCHORAGE),
        ("europe/ljubljana", raw_tzdata::EUROPE_LJUBLJANA),
        ("europe/helsinki", raw_tzdata::EUROPE_HELSINKI),
        ("europe/dublin", raw_tzdata::EIRE),
        ("pacific/johnston", raw_tzdata::HST),
        ("australia/lindeman", raw_tzdata::AUSTRALIA_LINDEMAN),
        ("europe/vatican", raw_tzdata::EUROPE_ROME),
        ("america/st_barthelemy", raw_tzdata::AMERICA_MARIGOT),
        ("america/cuiaba", raw_tzdata::AMERICA_CUIABA),
        ("africa/tripoli", raw_tzdata::LIBYA),
        ("pacific/efate", raw_tzdata::PACIFIC_EFATE),
        ("asia/kathmandu", raw_tzdata::ASIA_KATHMANDU),
        ("asia/famagusta", raw_tzdata::ASIA_FAMAGUSTA),
        ("asia/urumqi", raw_tzdata::ASIA_URUMQI),
        ("australia/nsw", raw_tzdata::AUSTRALIA_ACT),
        ("america/denver", raw_tzdata::NAVAJO),
        ("africa/accra", raw_tzdata::AFRICA_ACCRA),
        ("america/thunder_bay", raw_tzdata::AMERICA_THUNDER_BAY),
        ("america/winnipeg", raw_tzdata::AMERICA_WINNIPEG),
        ("asia/omsk", raw_tzdata::ASIA_OMSK),
        ("pacific/marquesas", raw_tzdata::PACIFIC_MARQUESAS),
        ("america/tortola", raw_tzdata::AMERICA_TORTOLA),
        ("poland", raw_tzdata::POLAND),
        ("america/toronto", raw_tzdata::AMERICA_TORONTO),
        ("asia/katmandu", raw_tzdata::ASIA_KATHMANDU),
        ("etc/gmt-12", raw_tzdata::ETC_GMT_MINUS_12),
        ("us/eastern", raw_tzdata::AMERICA_NEW_YORK),
        ("pacific/apia", raw_tzdata::PACIFIC_APIA),
        ("asia/kamchatka", raw_tzdata::ASIA_KAMCHATKA),
        ("asia/saigon", raw_tzdata::ASIA_HO_CHI_MINH),
        ("europe/busingen", raw_tzdata::EUROPE_BUSINGEN),
        ("america/bahia_banderas", raw_tzdata::AMERICA_BAHIA_BANDERAS),
        ("asia/hebron", raw_tzdata::ASIA_HEBRON),
        ("asia/atyrau", raw_tzdata::ASIA_ATYRAU),
        ("america/bahia", raw_tzdata::AMERICA_BAHIA),
        ("america/hermosillo", raw_tzdata::AMERICA_HERMOSILLO),
        ("america/managua", raw_tzdata::AMERICA_MANAGUA),
        ("us/pacific", raw_tzdata::AMERICA_LOS_ANGELES),
        ("europe/zurich", raw_tzdata::EUROPE_BUSINGEN),
        ("america/atka", raw_tzdata::AMERICA_ADAK),
        ("asia/kashgar", raw_tzdata::ASIA_KASHGAR),
        ("africa/lubumbashi", raw_tzdata::AFRICA_LUBUMBASHI),
        ("africa/timbuktu", raw_tzdata::AFRICA_TIMBUKTU),
        ("australia/canberra", raw_tzdata::AUSTRALIA_ACT),
        ("asia/chongqing", raw_tzdata::ASIA_CHONGQING),
        ("america/juneau", raw_tzdata::AMERICA_JUNEAU),
        ("europe/gibraltar", raw_tzdata::EUROPE_GIBRALTAR),
        ("africa/dakar", raw_tzdata::AFRICA_DAKAR),
        ("africa/bamako", raw_tzdata::AFRICA_BAMAKO),
        ("africa/kinshasa", raw_tzdata::AFRICA_KINSHASA),
        ("asia/baku", raw_tzdata::ASIA_BAKU),
        ("etc/gmt-9", raw_tzdata::ETC_GMT_MINUS_9),
        ("asia/magadan", raw_tzdata::ASIA_MAGADAN),
        ("mexico/bajasur", raw_tzdata::AMERICA_MAZATLAN),
        ("america/inuvik", raw_tzdata::AMERICA_INUVIK),
        ("america/cordoba", raw_tzdata::AMERICA_CORDOBA),
        ("pacific/palau", raw_tzdata::PACIFIC_PALAU),
        ("asia/aden", raw_tzdata::ASIA_ADEN),
        ("america/lima", raw_tzdata::AMERICA_LIMA),
        ("pacific/honolulu", raw_tzdata::PACIFIC_HONOLULU),
        ("zulu", raw_tzdata::UCT),
        ("america/anguilla", raw_tzdata::AMERICA_ANGUILLA),
        ("asia/ust-nera", raw_tzdata::ASIA_UST_NERA),
        ("brazil/acre", raw_tzdata::AMERICA_PORTO_ACRE),
        ("asia/manila", raw_tzdata::ASIA_MANILA),
        ("antarctica/syowa", raw_tzdata::ANTARCTICA_SYOWA),
        ("met", raw_tzdata::MET),
        ("asia/tbilisi", raw_tzdata::ASIA_TBILISI),
        ("africa/libreville", raw_tzdata::AFRICA_LIBREVILLE),
        ("europe/minsk", raw_tzdata::EUROPE_MINSK),
        ("asia/tehran", raw_tzdata::IRAN),
        ("europe/saratov", raw_tzdata::EUROPE_SARATOV),
        ("indian/christmas", raw_tzdata::INDIAN_CHRISTMAS),
        ("africa/kampala", raw_tzdata::AFRICA_KAMPALA),
        ("america/montreal", raw_tzdata::AMERICA_MONTREAL),
        ("us/michigan", raw_tzdata::AMERICA_DETROIT),
        ("australia/queensland", raw_tzdata::AUSTRALIA_BRISBANE),
        ("australia/sydney", raw_tzdata::AUSTRALIA_ACT),
        ("america/recife", raw_tzdata::AMERICA_RECIFE),
        ("turkey", raw_tzdata::TURKEY),
        ("australia/perth", raw_tzdata::AUSTRALIA_PERTH),
        ("pacific/funafuti", raw_tzdata::PACIFIC_FUNAFUTI),
        ("us/alaska", raw_tzdata::AMERICA_ANCHORAGE),
        ("asia/khandyga", raw_tzdata::ASIA_KHANDYGA),
        ("hst", raw_tzdata::HST),
        ("africa/blantyre", raw_tzdata::AFRICA_BLANTYRE),
        ("pacific/fakaofo", raw_tzdata::PACIFIC_FAKAOFO),
        ("greenwich", raw_tzdata::GMT),
        ("nz", raw_tzdata::NZ),
        ("america/creston", raw_tzdata::AMERICA_CRESTON),
        ("america/godthab", raw_tzdata::AMERICA_GODTHAB),
        ("asia/srednekolymsk", raw_tzdata::ASIA_SREDNEKOLYMSK),
        ("asia/aqtobe", raw_tzdata::ASIA_AQTOBE),
        ("eire", raw_tzdata::EIRE),
        ("asia/almaty", raw_tzdata::ASIA_ALMATY),
        ("asia/jayapura", raw_tzdata::ASIA_JAYAPURA),
        ("asia/jakarta", raw_tzdata::ASIA_JAKARTA),
        ("europe/paris", raw_tzdata::EUROPE_PARIS),
        ("asia/tokyo", raw_tzdata::JAPAN),
        ("rok", raw_tzdata::ROK),
        ("america/antigua", raw_tzdata::AMERICA_ANTIGUA),
        ("etc/gmt-10", raw_tzdata::ETC_GMT_MINUS_10),
        ("europe/budapest", raw_tzdata::EUROPE_BUDAPEST),
        ("asia/hong_kong", raw_tzdata::HONGKONG),
        ("europe/oslo", raw_tzdata::ARCTIC_LONGYEARBYEN),
        ("roc", raw_tzdata::ROC),
        ("etc/gmt-13", raw_tzdata::ETC_GMT_MINUS_13),
        ("pacific/galapagos", raw_tzdata::PACIFIC_GALAPAGOS),
        ("america/moncton", raw_tzdata::AMERICA_MONCTON),
        ("america/louisville", raw_tzdata::AMERICA_LOUISVILLE),
        ("asia/chungking", raw_tzdata::ASIA_CHONGQING),
        ("canada/yukon", raw_tzdata::AMERICA_WHITEHORSE),
        ("w-su", raw_tzdata::W_SU),
        ("australia/brisbane", raw_tzdata::AUSTRALIA_BRISBANE),
        ("europe/mariehamn", raw_tzdata::EUROPE_HELSINKI),
        ("pacific/pohnpei", raw_tzdata::PACIFIC_POHNPEI),
        ("uct", raw_tzdata::UCT),
        ("america/marigot", raw_tzdata::AMERICA_MARIGOT),
        ("america/santiago", raw_tzdata::AMERICA_SANTIAGO),
        ("america/bogota", raw_tzdata::AMERICA_BOGOTA),
        ("america/costa_rica", raw_tzdata::AMERICA_COSTA_RICA),
        ("asia/jerusalem", raw_tzdata::ISRAEL),
        ("iceland", raw_tzdata::ICELAND),
        ("america/yakutat", raw_tzdata::AMERICA_YAKUTAT),
        ("america/rankin_inlet", raw_tzdata::AMERICA_RANKIN_INLET),
        ("europe/volgograd", raw_tzdata::EUROPE_VOLGOGRAD),
        ("europe/tirane", raw_tzdata::EUROPE_TIRANE),
        ("america/st_johns", raw_tzdata::AMERICA_ST_JOHNS),
        ("europe/monaco", raw_tzdata::EUROPE_MONACO),
        ("indian/reunion", raw_tzdata::INDIAN_REUNION),
        ("pacific/noumea", raw_tzdata::PACIFIC_NOUMEA),
        ("europe/samara", raw_tzdata::EUROPE_SAMARA),
        ("africa/porto-novo", raw_tzdata::AFRICA_PORTO_NOVO),
        ("america/virgin", raw_tzdata::AMERICA_ST_THOMAS),
        ("europe/istanbul", raw_tzdata::TURKEY),
        ("pacific/kwajalein", raw_tzdata::KWAJALEIN),
        ("america/st_kitts", raw_tzdata::AMERICA_ST_KITTS),
        ("america/guatemala", raw_tzdata::AMERICA_GUATEMALA),
        ("europe/uzhgorod", raw_tzdata::EUROPE_UZHGOROD),
        ("pacific/truk", raw_tzdata::PACIFIC_CHUUK),
        ("asia/vientiane", raw_tzdata::ASIA_VIENTIANE),
    ],
};

#[cfg(feature = "list")]
pub(crate) const TIME_ZONES_LIST: [&str; 571] = [
    "Africa/Abidjan",
    "Africa/Accra",
    "Africa/Addis_Ababa",
    "Africa/Algiers",
    "Africa/Asmara",
    "Africa/Asmera",
    "Africa/Bamako",
    "Africa/Bangui",
    "Africa/Banjul",
    "Africa/Bissau",
    "Africa/Blantyre",
    "Africa/Brazzaville",
    "Africa/Bujumbura",
    "Africa/Cairo",
    "Africa/Casablanca",
    "Africa/Ceuta",
    "Africa/Conakry",
    "Africa/Dakar",
    "Africa/Dar_es_Salaam",
    "Africa/Djibouti",
    "Africa/Douala",
    "Africa/El_Aaiun",
    "Africa/Freetown",
    "Africa/Gaborone",
    "Africa/Harare",
    "Africa/Johannesburg",
    "Africa/Juba",
    "Africa/Kampala",
    "Africa/Khartoum",
    "Africa/Kigali",
    "Africa/Kinshasa",
    "Africa/Lagos",
    "Africa/Libreville",
    "Africa/Lome",
    "Africa/Luanda",
    "Africa/Lubumbashi",
    "Africa/Lusaka",
    "Africa/Malabo",
    "Africa/Maputo",
    "Africa/Maseru",
    "Africa/Mbabane",
    "Africa/Mogadishu",
    "Africa/Monrovia",
    "Africa/Nairobi",
    "Africa/Ndjamena",
    "Africa/Niamey",
    "Africa/Nouakchott",
    "Africa/Ouagadougou",
    "Africa/Porto-Novo",
    "Africa/Sao_Tome",
    "Africa/Timbuktu",
    "Africa/Tripoli",
    "Africa/Tunis",
    "Africa/Windhoek",
    "America/Adak",
    "America/Anchorage",
    "America/Anguilla",
    "America/Antigua",
    "America/Araguaina",
    "America/Aruba",
    "America/Asuncion",
    "America/Atikokan",
    "America/Atka",
    "America/Bahia",
    "America/Bahia_Banderas",
    "America/Barbados",
    "America/Belem",
    "America/Belize",
    "America/Blanc-Sablon",
    "America/Boa_Vista",
    "America/Bogota",
    "America/Boise",
    "America/Buenos_Aires",
    "America/Cambridge_Bay",
    "America/Campo_Grande",
    "America/Cancun",
    "America/Caracas",
    "America/Catamarca",
    "America/Cayenne",
    "America/Cayman",
    "America/Chicago",
    "America/Chihuahua",
    "America/Coral_Harbour",
    "America/Cordoba",
    "America/Costa_Rica",
    "America/Creston",
    "America/Cuiaba",
    "America/Curacao",
    "America/Danmarkshavn",
    "America/Dawson",
    "America/Dawson_Creek",
    "America/Denver",
    "America/Detroit",
    "America/Dominica",
    "America/Edmonton",
    "America/Eirunepe",
    "America/El_Salvador",
    "America/Ensenada",
    "America/Fort_Nelson",
    "America/Fort_Wayne",
    "America/Fortaleza",
    "America/Glace_Bay",
    "America/Godthab",
    "America/Goose_Bay",
    "America/Grand_Turk",
    "America/Grenada",
    "America/Guadeloupe",
    "America/Guatemala",
    "America/Guayaquil",
    "America/Guyana",
    "America/Halifax",
    "America/Havana",
    "America/Hermosillo",
    "America/Indianapolis",
    "America/Inuvik",
    "America/Iqaluit",
    "America/Jamaica",
    "America/Jujuy",
    "America/Juneau",
    "America/Knox_IN",
    "America/Kralendijk",
    "America/La_Paz",
    "America/Lima",
    "America/Los_Angeles",
    "America/Louisville",
    "America/Lower_Princes",
    "America/Maceio",
    "America/Managua",
    "America/Manaus",
    "America/Marigot",
    "America/Martinique",
    "America/Matamoros",
    "America/Mazatlan",
    "America/Mendoza",
    "America/Menominee",
    "America/Merida",
    "America/Metlakatla",
    "America/Mexico_City",
    "America/Miquelon",
    "America/Moncton",
    "America/Monterrey",
    "America/Montevideo",
    "America/Montreal",
    "America/Montserrat",
    "America/Nassau",
    "America/New_York",
    "America/Nipigon",
    "America/Nome",
    "America/Noronha",
    "America/Nuuk",
    "America/Ojinaga",
    "America/Panama",
    "America/Pangnirtung",
    "America/Paramaribo",
    "America/Phoenix",
    "America/Port-au-Prince",
    "America/Port_of_Spain",
    "America/Porto_Acre",
    "America/Porto_Velho",
    "America/Puerto_Rico",
    "America/Punta_Arenas",
    "America/Rainy_River",
    "America/Rankin_Inlet",
    "America/Recife",
    "America/Regina",
    "America/Resolute",
    "America/Rio_Branco",
    "America/Rosario",
    "America/Santa_Isabel",
    "America/Santarem",
    "America/Santiago",
    "America/Santo_Domingo",
    "America/Sao_Paulo",
    "America/Scoresbysund",
    "America/Shiprock",
    "America/Sitka",
    "America/St_Barthelemy",
    "America/St_Johns",
    "America/St_Kitts",
    "America/St_Lucia",
    "America/St_Thomas",
    "America/St_Vincent",
    "America/Swift_Current",
    "America/Tegucigalpa",
    "America/Thule",
    "America/Thunder_Bay",
    "America/Tijuana",
    "America/Toronto",
    "America/Tortola",
    "America/Vancouver",
    "America/Virgin",
    "America/Whitehorse",
    "America/Winnipeg",
    "America/Yakutat",
    "America/Yellowknife",
    "Antarctica/Casey",
    "Antarctica/Davis",
    "Antarctica/DumontDUrville",
    "Antarctica/Macquarie",
    "Antarctica/Mawson",
    "Antarctica/McMurdo",
    "Antarctica/Palmer",
    "Antarctica/Rothera",
    "Antarctica/South_Pole",
    "Antarctica/Syowa",
    "Antarctica/Troll",
    "Antarctica/Vostok",
    "Arctic/Longyearbyen",
    "Asia/Aden",
    "Asia/Almaty",
    "Asia/Amman",
    "Asia/Anadyr",
    "Asia/Aqtau",
    "Asia/Aqtobe",
    "Asia/Ashgabat",
    "Asia/Ashkhabad",
    "Asia/Atyrau",
    "Asia/Baghdad",
    "Asia/Bahrain",
    "Asia/Baku",
    "Asia/Bangkok",
    "Asia/Barnaul",
    "Asia/Beirut",
    "Asia/Bishkek",
    "Asia/Brunei",
    "Asia/Calcutta",
    "Asia/Chita",
    "Asia/Choibalsan",
    "Asia/Chongqing",
    "Asia/Chungking",
    "Asia/Colombo",
    "Asia/Dacca",
    "Asia/Damascus",
    "Asia/Dhaka",
    "Asia/Dili",
    "Asia/Dubai",
    "Asia/Dushanbe",
    "Asia/Famagusta",
    "Asia/Gaza",
    "Asia/Hanoi",
    "Asia/Harbin",
    "Asia/Hebron",
    "Asia/Ho_Chi_Minh",
    "Asia/Hong_Kong",
    "Asia/Hovd",
    "Asia/Irkutsk",
    "Asia/Istanbul",
    "Asia/Jakarta",
    "Asia/Jayapura",
    "Asia/Jerusalem",
    "Asia/Kabul",
    "Asia/Kamchatka",
    "Asia/Karachi",
    "Asia/Kashgar",
    "Asia/Kathmandu",
    "Asia/Katmandu",
    "Asia/Khandyga",
    "Asia/Kolkata",
    "Asia/Krasnoyarsk",
    "Asia/Kuala_Lumpur",
    "Asia/Kuching",
    "Asia/Kuwait",
    "Asia/Macao",
    "Asia/Macau",
    "Asia/Magadan",
    "Asia/Makassar",
    "Asia/Manila",
    "Asia/Muscat",
    "Asia/Nicosia",
    "Asia/Novokuznetsk",
    "Asia/Novosibirsk",
    "Asia/Omsk",
    "Asia/Oral",
    "Asia/Phnom_Penh",
    "Asia/Pontianak",
    "Asia/Pyongyang",
    "Asia/Qatar",
    "Asia/Qostanay",
    "Asia/Qyzylorda",
    "Asia/Rangoon",
    "Asia/Riyadh",
    "Asia/Saigon",
    "Asia/Sakhalin",
    "Asia/Samarkand",
    "Asia/Seoul",
    "Asia/Shanghai",
    "Asia/Singapore",
    "Asia/Srednekolymsk",
    "Asia/Taipei",
    "Asia/Tashkent",
    "Asia/Tbilisi",
    "Asia/Tehran",
    "Asia/Tel_Aviv",
    "Asia/Thimbu",
    "Asia/Thimphu",
    "Asia/Tokyo",
    "Asia/Tomsk",
    "Asia/Ujung_Pandang",
    "Asia/Ulaanbaatar",
    "Asia/Ulan_Bator",
    "Asia/Urumqi",
    "Asia/Ust-Nera",
    "Asia/Vientiane",
    "Asia/Vladivostok",
    "Asia/Yakutsk",
    "Asia/Yangon",
    "Asia/Yekaterinburg",
    "Asia/Yerevan",
    "Atlantic/Azores",
    "Atlantic/Bermuda",
    "Atlantic/Canary",
    "Atlantic/Cape_Verde",
    "Atlantic/Faeroe",
    "Atlantic/Faroe",
    "Atlantic/Jan_Mayen",
    "Atlantic/Madeira",
    "Atlantic/Reykjavik",
    "Atlantic/South_Georgia",
    "Atlantic/St_Helena",
    "Atlantic/Stanley",
    "Australia/ACT",
    "Australia/Adelaide",
    "Australia/Brisbane",
    "Australia/Broken_Hill",
    "Australia/Canberra",
    "Australia/Currie",
    "Australia/Darwin",
    "Australia/Eucla",
    "Australia/Hobart",
    "Australia/LHI",
    "Australia/Lindeman",
    "Australia/Lord_Howe",
    "Australia/Melbourne",
    "Australia/North",
    "Australia/NSW",
    "Australia/Perth",
    "Australia/Queensland",
    "Australia/South",
    "Australia/Sydney",
    "Australia/Tasmania",
    "Australia/Victoria",
    "Australia/West",
    "Australia/Yancowinna",
    "Brazil/Acre",
    "Brazil/DeNoronha",
    "Brazil/East",
    "Brazil/West",
    "Canada/Atlantic",
    "Canada/Central",
    "Canada/Eastern",
    "Canada/Mountain",
    "Canada/Newfoundland",
    "Canada/Pacific",
    "Canada/Saskatchewan",
    "Canada/Yukon",
    "CET",
    "Chile/Continental",
    "Chile/EasterIsland",
    "CST6CDT",
    "Cuba",
    "EET",
    "Egypt",
    "Eire",
    "EST",
    "EST5EDT",
    "Etc/GMT",
    "Etc/GMT+0",
    "Etc/GMT+1",
    "Etc/GMT+10",
    "Etc/GMT+11",
    "Etc/GMT+12",
    "Etc/GMT+2",
    "Etc/GMT+3",
    "Etc/GMT+4",
    "Etc/GMT+5",
    "Etc/GMT+6",
    "Etc/GMT+7",
    "Etc/GMT+8",
    "Etc/GMT+9",
    "Etc/GMT-0",
    "Etc/GMT-1",
    "Etc/GMT-10",
    "Etc/GMT-11",
    "Etc/GMT-12",
    "Etc/GMT-13",
    "Etc/GMT-14",
    "Etc/GMT-2",
    "Etc/GMT-3",
    "Etc/GMT-4",
    "Etc/GMT-5",
    "Etc/GMT-6",
    "Etc/GMT-7",
    "Etc/GMT-8",
    "Etc/GMT-9",
    "Etc/GMT0",
    "Etc/Greenwich",
    "etc/localtime",
    "Etc/UCT",
    "Etc/Universal",
    "Etc/UTC",
    "Etc/Zulu",
    "Europe/Amsterdam",
    "Europe/Andorra",
    "Europe/Astrakhan",
    "Europe/Athens",
    "Europe/Belfast",
    "Europe/Belgrade",
    "Europe/Berlin",
    "Europe/Bratislava",
    "Europe/Brussels",
    "Europe/Bucharest",
    "Europe/Budapest",
    "Europe/Busingen",
    "Europe/Chisinau",
    "Europe/Copenhagen",
    "Europe/Dublin",
    "Europe/Gibraltar",
    "Europe/Guernsey",
    "Europe/Helsinki",
    "Europe/Isle_of_Man",
    "Europe/Istanbul",
    "Europe/Jersey",
    "Europe/Kaliningrad",
    "Europe/Kiev",
    "Europe/Kirov",
    "Europe/Lisbon",
    "Europe/Ljubljana",
    "Europe/London",
    "Europe/Luxembourg",
    "Europe/Madrid",
    "Europe/Malta",
    "Europe/Mariehamn",
    "Europe/Minsk",
    "Europe/Monaco",
    "Europe/Moscow",
    "Europe/Nicosia",
    "Europe/Oslo",
    "Europe/Paris",
    "Europe/Podgorica",
    "Europe/Prague",
    "Europe/Riga",
    "Europe/Rome",
    "Europe/Samara",
    "Europe/San_Marino",
    "Europe/Sarajevo",
    "Europe/Saratov",
    "Europe/Simferopol",
    "Europe/Skopje",
    "Europe/Sofia",
    "Europe/Stockholm",
    "Europe/Tallinn",
    "Europe/Tirane",
    "Europe/Tiraspol",
    "Europe/Ulyanovsk",
    "Europe/Uzhgorod",
    "Europe/Vaduz",
    "Europe/Vatican",
    "Europe/Vienna",
    "Europe/Vilnius",
    "Europe/Volgograd",
    "Europe/Warsaw",
    "Europe/Zagreb",
    "Europe/Zaporozhye",
    "Europe/Zurich",
    "Factory",
    "GB",
    "GB-Eire",
    "GMT",
    "GMT+0",
    "GMT-0",
    "GMT0",
    "Greenwich",
    "Hongkong",
    "HST",
    "Iceland",
    "Indian/Antananarivo",
    "Indian/Chagos",
    "Indian/Christmas",
    "Indian/Cocos",
    "Indian/Comoro",
    "Indian/Kerguelen",
    "Indian/Mahe",
    "Indian/Maldives",
    "Indian/Mauritius",
    "Indian/Mayotte",
    "Indian/Reunion",
    "Iran",
    "Israel",
    "Jamaica",
    "Japan",
    "Kwajalein",
    "Libya",
    "MET",
    "Mexico/BajaNorte",
    "Mexico/BajaSur",
    "Mexico/General",
    "MST",
    "MST7MDT",
    "Navajo",
    "NZ",
    "NZ-CHAT",
    "Pacific/Apia",
    "Pacific/Auckland",
    "Pacific/Bougainville",
    "Pacific/Chatham",
    "Pacific/Chuuk",
    "Pacific/Easter",
    "Pacific/Efate",
    "Pacific/Enderbury",
    "Pacific/Fakaofo",
    "Pacific/Fiji",
    "Pacific/Funafuti",
    "Pacific/Galapagos",
    "Pacific/Gambier",
    "Pacific/Guadalcanal",
    "Pacific/Guam",
    "Pacific/Honolulu",
    "Pacific/Johnston",
    "Pacific/Kanton",
    "Pacific/Kiritimati",
    "Pacific/Kosrae",
    "Pacific/Kwajalein",
    "Pacific/Majuro",
    "Pacific/Marquesas",
    "Pacific/Midway",
    "Pacific/Nauru",
    "Pacific/Niue",
    "Pacific/Norfolk",
    "Pacific/Noumea",
    "Pacific/Pago_Pago",
    "Pacific/Palau",
    "Pacific/Pitcairn",
    "Pacific/Pohnpei",
    "Pacific/Ponape",
    "Pacific/Port_Moresby",
    "Pacific/Rarotonga",
    "Pacific/Saipan",
    "Pacific/Samoa",
    "Pacific/Tahiti",
    "Pacific/Tarawa",
    "Pacific/Tongatapu",
    "Pacific/Truk",
    "Pacific/Wake",
    "Pacific/Wallis",
    "Pacific/Yap",
    "Poland",
    "Portugal",
    "PRC",
    "PST8PDT",
    "ROC",
    "ROK",
    "Singapore",
    "Turkey",
    "UCT",
    "Universal",
    "US/Alaska",
    "US/Aleutian",
    "US/Arizona",
    "US/Central",
    "US/East-Indiana",
    "US/Eastern",
    "US/Hawaii",
    "US/Indiana-Starke",
    "US/Michigan",
    "US/Mountain",
    "US/Pacific",
    "US/Samoa",
    "UTC",
    "W-SU",
    "WET",
    "Zulu",
];

mod tzdata {
    use tz::timezone::*;

    pub(crate) const AFRICA_ABIDJAN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1830383032, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(-968, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_ACCRA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1709337548, 2),
            Transition::new(-1581206400, 1),
            Transition::new(-1577917200, 2),
            Transition::new(-1556834400, 1),
            Transition::new(-1546294800, 2),
            Transition::new(-1525298400, 1),
            Transition::new(-1514758800, 2),
            Transition::new(-1493762400, 1),
            Transition::new(-1483222800, 2),
            Transition::new(-1462226400, 1),
            Transition::new(-1451686800, 2),
            Transition::new(-1430604000, 1),
            Transition::new(-1420064400, 2),
            Transition::new(-1399068000, 1),
            Transition::new(-1388528400, 2),
            Transition::new(-1367532000, 1),
            Transition::new(-1356992400, 2),
            Transition::new(-1335996000, 1),
            Transition::new(-1325456400, 2),
            Transition::new(-1304373600, 1),
            Transition::new(-1293834000, 2),
            Transition::new(-1272837600, 1),
            Transition::new(-1262298000, 2),
            Transition::new(-1241301600, 1),
            Transition::new(-1230762000, 2),
            Transition::new(-1209765600, 1),
            Transition::new(-1199226000, 2),
            Transition::new(-1178143200, 1),
            Transition::new(-1167603600, 2),
            Transition::new(-1146607200, 1),
            Transition::new(-1136067600, 2),
            Transition::new(-1115071200, 1),
            Transition::new(-1104531600, 2),
            Transition::new(-1083535200, 1),
            Transition::new(-1072995600, 2),
            Transition::new(-1051912800, 1),
            Transition::new(-1041373200, 2),
            Transition::new(-1020376800, 1),
            Transition::new(-1009837200, 2),
            Transition::new(-988840800, 1),
            Transition::new(-978301200, 2),
            Transition::new(-957304800, 1),
            Transition::new(-946765200, 2),
            Transition::new(-936309600, 1),
            Transition::new(-915142800, 2),
            Transition::new(-904773600, 1),
            Transition::new(-883606800, 2),
            Transition::new(-880329600, 3),
            Transition::new(-756952200, 2),
            Transition::new(-610149600, 4),
            Transition::new(-599610600, 2),
            Transition::new(-578613600, 4),
            Transition::new(-568074600, 2),
            Transition::new(-546991200, 4),
            Transition::new(-536452200, 2),
            Transition::new(-515455200, 4),
            Transition::new(-504916200, 2),
            Transition::new(-483919200, 4),
            Transition::new(-473380200, 2),
            Transition::new(-452383200, 4),
            Transition::new(-441844200, 2),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-52, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(1200, true, Some(b"+0020")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(1800, false, Some(b"+0030")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(1800, true, Some(b"+0030")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_ADDIS_ABABA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3155682888, 1),
            Transition::new(-1062210920, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(9288, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(9320, false, Some(b"ADMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_ALGIERS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2486592732, 1),
            Transition::new(-1855958961, 3),
            Transition::new(-1689814800, 2),
            Transition::new(-1680397200, 3),
            Transition::new(-1665363600, 2),
            Transition::new(-1648342800, 3),
            Transition::new(-1635123600, 2),
            Transition::new(-1616893200, 3),
            Transition::new(-1604278800, 2),
            Transition::new(-1585443600, 3),
            Transition::new(-1574038800, 2),
            Transition::new(-1552266000, 3),
            Transition::new(-1539997200, 2),
            Transition::new(-1531443600, 3),
            Transition::new(-956365200, 2),
            Transition::new(-950486400, 3),
            Transition::new(-942012000, 5),
            Transition::new(-812502000, 4),
            Transition::new(-796262400, 5),
            Transition::new(-781052400, 4),
            Transition::new(-766630800, 5),
            Transition::new(-733280400, 3),
            Transition::new(-439430400, 5),
            Transition::new(-212029200, 3),
            Transition::new(41468400, 2),
            Transition::new(54774000, 3),
            Transition::new(231724800, 2),
            Transition::new(246236400, 5),
            Transition::new(259545600, 4),
            Transition::new(275274000, 5),
            Transition::new(309740400, 3),
            Transition::new(325468800, 2),
            Transition::new(341802000, 3),
            Transition::new(357523200, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(732, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(561, false, Some(b"PMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, true, Some(b"WEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"WET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, true, Some(b"CEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"CET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"CET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_ASMARA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3155682932, 1),
            Transition::new(-2524530932, 2),
            Transition::new(-1062210920, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(9332, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(9332, false, Some(b"AMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(9320, false, Some(b"ADMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_BAMAKO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1830382080, 1),
            Transition::new(-1131235200, 2),
            Transition::new(-300841200, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-1920, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_BANGUI: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1830388460, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(4460, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_BANJUL: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1830380004, 1),
            Transition::new(-1159829604, 2),
            Transition::new(-880930800, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-3996, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3996, false, Some(b"BMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_BISSAU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1830380400, 1),
            Transition::new(157770000, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-3740, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_BLANTYRE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1844302800, 1),
            Transition::new(-1751682070, 2),
            Transition::new(-1404440460, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(8400, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(8470, false, Some(b"ZMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(8460, false, Some(b"ZMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_BRAZZAVILLE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1830387668, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(3668, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_BUJUMBURA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-2524528648, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(7048, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_CASABLANCA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1773012580, 2),
            Transition::new(-956361600, 1),
            Transition::new(-950490000, 2),
            Transition::new(-942019200, 1),
            Transition::new(-761187600, 2),
            Transition::new(-617241600, 1),
            Transition::new(-605149200, 2),
            Transition::new(-81432000, 1),
            Transition::new(-71110800, 2),
            Transition::new(141264000, 1),
            Transition::new(147222000, 2),
            Transition::new(199756800, 1),
            Transition::new(207702000, 2),
            Transition::new(231292800, 1),
            Transition::new(244249200, 2),
            Transition::new(265507200, 1),
            Transition::new(271033200, 2),
            Transition::new(448243200, 3),
            Transition::new(504918000, 2),
            Transition::new(1212278400, 1),
            Transition::new(1220223600, 2),
            Transition::new(1243814400, 1),
            Transition::new(1250809200, 2),
            Transition::new(1272758400, 1),
            Transition::new(1281222000, 2),
            Transition::new(1301788800, 1),
            Transition::new(1312066800, 2),
            Transition::new(1335664800, 1),
            Transition::new(1342749600, 2),
            Transition::new(1345428000, 1),
            Transition::new(1348970400, 2),
            Transition::new(1367114400, 1),
            Transition::new(1373162400, 2),
            Transition::new(1376100000, 1),
            Transition::new(1382839200, 2),
            Transition::new(1396144800, 1),
            Transition::new(1403920800, 2),
            Transition::new(1406944800, 1),
            Transition::new(1414288800, 2),
            Transition::new(1427594400, 1),
            Transition::new(1434247200, 2),
            Transition::new(1437271200, 1),
            Transition::new(1445738400, 2),
            Transition::new(1459044000, 1),
            Transition::new(1465092000, 2),
            Transition::new(1468116000, 1),
            Transition::new(1477792800, 2),
            Transition::new(1490493600, 1),
            Transition::new(1495332000, 2),
            Transition::new(1498960800, 1),
            Transition::new(1509242400, 2),
            Transition::new(1521943200, 1),
            Transition::new(1526176800, 2),
            Transition::new(1529200800, 1),
            Transition::new(1540692000, 3),
            Transition::new(1557021600, 4),
            Transition::new(1560045600, 3),
            Transition::new(1587261600, 4),
            Transition::new(1590890400, 3),
            Transition::new(1618106400, 4),
            Transition::new(1621130400, 3),
            Transition::new(1648346400, 4),
            Transition::new(1651975200, 3),
            Transition::new(1679191200, 4),
            Transition::new(1682820000, 3),
            Transition::new(1710036000, 4),
            Transition::new(1713060000, 3),
            Transition::new(1740276000, 4),
            Transition::new(1743904800, 3),
            Transition::new(1771120800, 4),
            Transition::new(1774144800, 3),
            Transition::new(1801965600, 4),
            Transition::new(1804989600, 3),
            Transition::new(1832205600, 4),
            Transition::new(1835834400, 3),
            Transition::new(1863050400, 4),
            Transition::new(1866074400, 3),
            Transition::new(1893290400, 4),
            Transition::new(1896919200, 3),
            Transition::new(1924135200, 4),
            Transition::new(1927764000, 3),
            Transition::new(1954980000, 4),
            Transition::new(1958004000, 3),
            Transition::new(1985220000, 4),
            Transition::new(1988848800, 3),
            Transition::new(2016064800, 4),
            Transition::new(2019088800, 3),
            Transition::new(2046304800, 4),
            Transition::new(2049933600, 3),
            Transition::new(2077149600, 4),
            Transition::new(2080778400, 3),
            Transition::new(2107994400, 4),
            Transition::new(2111018400, 3),
            Transition::new(2138234400, 4),
            Transition::new(2141863200, 3),
            Transition::new(2169079200, 4),
            Transition::new(2172708000, 3),
            Transition::new(2199924000, 4),
            Transition::new(2202948000, 3),
            Transition::new(2230164000, 4),
            Transition::new(2233792800, 3),
            Transition::new(2261008800, 4),
            Transition::new(2264032800, 3),
            Transition::new(2291248800, 4),
            Transition::new(2294877600, 3),
            Transition::new(2322093600, 4),
            Transition::new(2325722400, 3),
            Transition::new(2352938400, 4),
            Transition::new(2355962400, 3),
            Transition::new(2383178400, 4),
            Transition::new(2386807200, 3),
            Transition::new(2414023200, 4),
            Transition::new(2417652000, 3),
            Transition::new(2444868000, 4),
            Transition::new(2447892000, 3),
            Transition::new(2475108000, 4),
            Transition::new(2478736800, 3),
            Transition::new(2505952800, 4),
            Transition::new(2508976800, 3),
            Transition::new(2536192800, 4),
            Transition::new(2539821600, 3),
            Transition::new(2567037600, 4),
            Transition::new(2570666400, 3),
            Transition::new(2597882400, 4),
            Transition::new(2600906400, 3),
            Transition::new(2628122400, 4),
            Transition::new(2631751200, 3),
            Transition::new(2658967200, 4),
            Transition::new(2662596000, 3),
            Transition::new(2689812000, 4),
            Transition::new(2692836000, 3),
            Transition::new(2720052000, 4),
            Transition::new(2723680800, 3),
            Transition::new(2750896800, 4),
            Transition::new(2753920800, 3),
            Transition::new(2781136800, 4),
            Transition::new(2784765600, 3),
            Transition::new(2811981600, 4),
            Transition::new(2815610400, 3),
            Transition::new(2842826400, 4),
            Transition::new(2845850400, 3),
            Transition::new(2873066400, 4),
            Transition::new(2876695200, 3),
            Transition::new(2903911200, 4),
            Transition::new(2907540000, 3),
            Transition::new(2934756000, 4),
            Transition::new(2937780000, 3),
            Transition::new(2964996000, 4),
            Transition::new(2968624800, 3),
            Transition::new(2995840800, 4),
            Transition::new(2998864800, 3),
            Transition::new(3026080800, 4),
            Transition::new(3029709600, 3),
            Transition::new(3056925600, 4),
            Transition::new(3060554400, 3),
            Transition::new(3087770400, 4),
            Transition::new(3090794400, 3),
            Transition::new(3118010400, 4),
            Transition::new(3121639200, 3),
            Transition::new(3148855200, 4),
            Transition::new(3152484000, 3),
            Transition::new(3179700000, 4),
            Transition::new(3182724000, 3),
            Transition::new(3209940000, 4),
            Transition::new(3213568800, 3),
            Transition::new(3240784800, 4),
            Transition::new(3243808800, 3),
            Transition::new(3271024800, 4),
            Transition::new(3274653600, 3),
            Transition::new(3301869600, 4),
            Transition::new(3305498400, 3),
            Transition::new(3332714400, 4),
            Transition::new(3335738400, 3),
            Transition::new(3362954400, 4),
            Transition::new(3366583200, 3),
            Transition::new(3393799200, 4),
            Transition::new(3397428000, 3),
            Transition::new(3424644000, 4),
            Transition::new(3427668000, 3),
            Transition::new(3454884000, 4),
            Transition::new(3458512800, 3),
            Transition::new(3485728800, 4),
            Transition::new(3488752800, 3),
            Transition::new(3515968800, 4),
            Transition::new(3519597600, 3),
            Transition::new(3546813600, 4),
            Transition::new(3550442400, 3),
            Transition::new(3577658400, 4),
            Transition::new(3580682400, 3),
            Transition::new(3607898400, 4),
            Transition::new(3611527200, 3),
            Transition::new(3638743200, 4),
            Transition::new(3642372000, 3),
            Transition::new(3669588000, 4),
            Transition::new(3672612000, 3),
            Transition::new(3699828000, 4),
            Transition::new(3703456800, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-1820, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, true, Some(b"+01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"+00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"+01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, true, Some(b"+00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"+01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_CEUTA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2177452800, 1),
            Transition::new(-1630112400, 2),
            Transition::new(-1616810400, 1),
            Transition::new(-1442451600, 2),
            Transition::new(-1427673600, 1),
            Transition::new(-1379293200, 2),
            Transition::new(-1364774400, 1),
            Transition::new(-1348448400, 2),
            Transition::new(-1333324800, 1),
            Transition::new(-1316390400, 2),
            Transition::new(-1301270400, 1),
            Transition::new(-81432000, 2),
            Transition::new(-71110800, 1),
            Transition::new(141264000, 2),
            Transition::new(147222000, 1),
            Transition::new(199756800, 2),
            Transition::new(207702000, 1),
            Transition::new(231292800, 2),
            Transition::new(244249200, 1),
            Transition::new(265507200, 2),
            Transition::new(271033200, 1),
            Transition::new(448243200, 3),
            Transition::new(512528400, 4),
            Transition::new(528253200, 3),
            Transition::new(543978000, 4),
            Transition::new(559702800, 3),
            Transition::new(575427600, 4),
            Transition::new(591152400, 3),
            Transition::new(606877200, 4),
            Transition::new(622602000, 3),
            Transition::new(638326800, 4),
            Transition::new(654656400, 3),
            Transition::new(670381200, 4),
            Transition::new(686106000, 3),
            Transition::new(701830800, 4),
            Transition::new(717555600, 3),
            Transition::new(733280400, 4),
            Transition::new(749005200, 3),
            Transition::new(764730000, 4),
            Transition::new(780454800, 3),
            Transition::new(796179600, 4),
            Transition::new(811904400, 3),
            Transition::new(828234000, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-1276, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"WET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, true, Some(b"WEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"CET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, true, Some(b"CEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(3600, false, Some(b"CET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(7200, true, Some(b"CEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_CONAKRY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1830380708, 1),
            Transition::new(-1131235200, 2),
            Transition::new(-315615600, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-3292, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_DAKAR: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1830379816, 1),
            Transition::new(-902098800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-4184, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_DAR_ES_SALAAM: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1230777428, 1),
            Transition::new(-694321200, 2),
            Transition::new(-284006700, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(9428, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(9900, false, Some(b"+0245")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_DJIBOUTI: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1846291956, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(10356, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_DOUALA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1830386328, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(2328, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_EL_AAIUN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1136070432, 1),
            Transition::new(198291600, 3),
            Transition::new(199756800, 2),
            Transition::new(207702000, 3),
            Transition::new(231292800, 2),
            Transition::new(244249200, 3),
            Transition::new(265507200, 2),
            Transition::new(271033200, 3),
            Transition::new(1212278400, 2),
            Transition::new(1220223600, 3),
            Transition::new(1243814400, 2),
            Transition::new(1250809200, 3),
            Transition::new(1272758400, 2),
            Transition::new(1281222000, 3),
            Transition::new(1301788800, 2),
            Transition::new(1312066800, 3),
            Transition::new(1335664800, 2),
            Transition::new(1342749600, 3),
            Transition::new(1345428000, 2),
            Transition::new(1348970400, 3),
            Transition::new(1367114400, 2),
            Transition::new(1373162400, 3),
            Transition::new(1376100000, 2),
            Transition::new(1382839200, 3),
            Transition::new(1396144800, 2),
            Transition::new(1403920800, 3),
            Transition::new(1406944800, 2),
            Transition::new(1414288800, 3),
            Transition::new(1427594400, 2),
            Transition::new(1434247200, 3),
            Transition::new(1437271200, 2),
            Transition::new(1445738400, 3),
            Transition::new(1459044000, 2),
            Transition::new(1465092000, 3),
            Transition::new(1468116000, 2),
            Transition::new(1477792800, 3),
            Transition::new(1490493600, 2),
            Transition::new(1495332000, 3),
            Transition::new(1498960800, 2),
            Transition::new(1509242400, 3),
            Transition::new(1521943200, 2),
            Transition::new(1526176800, 3),
            Transition::new(1529200800, 2),
            Transition::new(1540692000, 5),
            Transition::new(1557021600, 4),
            Transition::new(1560045600, 5),
            Transition::new(1587261600, 4),
            Transition::new(1590890400, 5),
            Transition::new(1618106400, 4),
            Transition::new(1621130400, 5),
            Transition::new(1648346400, 4),
            Transition::new(1651975200, 5),
            Transition::new(1679191200, 4),
            Transition::new(1682820000, 5),
            Transition::new(1710036000, 4),
            Transition::new(1713060000, 5),
            Transition::new(1740276000, 4),
            Transition::new(1743904800, 5),
            Transition::new(1771120800, 4),
            Transition::new(1774144800, 5),
            Transition::new(1801965600, 4),
            Transition::new(1804989600, 5),
            Transition::new(1832205600, 4),
            Transition::new(1835834400, 5),
            Transition::new(1863050400, 4),
            Transition::new(1866074400, 5),
            Transition::new(1893290400, 4),
            Transition::new(1896919200, 5),
            Transition::new(1924135200, 4),
            Transition::new(1927764000, 5),
            Transition::new(1954980000, 4),
            Transition::new(1958004000, 5),
            Transition::new(1985220000, 4),
            Transition::new(1988848800, 5),
            Transition::new(2016064800, 4),
            Transition::new(2019088800, 5),
            Transition::new(2046304800, 4),
            Transition::new(2049933600, 5),
            Transition::new(2077149600, 4),
            Transition::new(2080778400, 5),
            Transition::new(2107994400, 4),
            Transition::new(2111018400, 5),
            Transition::new(2138234400, 4),
            Transition::new(2141863200, 5),
            Transition::new(2169079200, 4),
            Transition::new(2172708000, 5),
            Transition::new(2199924000, 4),
            Transition::new(2202948000, 5),
            Transition::new(2230164000, 4),
            Transition::new(2233792800, 5),
            Transition::new(2261008800, 4),
            Transition::new(2264032800, 5),
            Transition::new(2291248800, 4),
            Transition::new(2294877600, 5),
            Transition::new(2322093600, 4),
            Transition::new(2325722400, 5),
            Transition::new(2352938400, 4),
            Transition::new(2355962400, 5),
            Transition::new(2383178400, 4),
            Transition::new(2386807200, 5),
            Transition::new(2414023200, 4),
            Transition::new(2417652000, 5),
            Transition::new(2444868000, 4),
            Transition::new(2447892000, 5),
            Transition::new(2475108000, 4),
            Transition::new(2478736800, 5),
            Transition::new(2505952800, 4),
            Transition::new(2508976800, 5),
            Transition::new(2536192800, 4),
            Transition::new(2539821600, 5),
            Transition::new(2567037600, 4),
            Transition::new(2570666400, 5),
            Transition::new(2597882400, 4),
            Transition::new(2600906400, 5),
            Transition::new(2628122400, 4),
            Transition::new(2631751200, 5),
            Transition::new(2658967200, 4),
            Transition::new(2662596000, 5),
            Transition::new(2689812000, 4),
            Transition::new(2692836000, 5),
            Transition::new(2720052000, 4),
            Transition::new(2723680800, 5),
            Transition::new(2750896800, 4),
            Transition::new(2753920800, 5),
            Transition::new(2781136800, 4),
            Transition::new(2784765600, 5),
            Transition::new(2811981600, 4),
            Transition::new(2815610400, 5),
            Transition::new(2842826400, 4),
            Transition::new(2845850400, 5),
            Transition::new(2873066400, 4),
            Transition::new(2876695200, 5),
            Transition::new(2903911200, 4),
            Transition::new(2907540000, 5),
            Transition::new(2934756000, 4),
            Transition::new(2937780000, 5),
            Transition::new(2964996000, 4),
            Transition::new(2968624800, 5),
            Transition::new(2995840800, 4),
            Transition::new(2998864800, 5),
            Transition::new(3026080800, 4),
            Transition::new(3029709600, 5),
            Transition::new(3056925600, 4),
            Transition::new(3060554400, 5),
            Transition::new(3087770400, 4),
            Transition::new(3090794400, 5),
            Transition::new(3118010400, 4),
            Transition::new(3121639200, 5),
            Transition::new(3148855200, 4),
            Transition::new(3152484000, 5),
            Transition::new(3179700000, 4),
            Transition::new(3182724000, 5),
            Transition::new(3209940000, 4),
            Transition::new(3213568800, 5),
            Transition::new(3240784800, 4),
            Transition::new(3243808800, 5),
            Transition::new(3271024800, 4),
            Transition::new(3274653600, 5),
            Transition::new(3301869600, 4),
            Transition::new(3305498400, 5),
            Transition::new(3332714400, 4),
            Transition::new(3335738400, 5),
            Transition::new(3362954400, 4),
            Transition::new(3366583200, 5),
            Transition::new(3393799200, 4),
            Transition::new(3397428000, 5),
            Transition::new(3424644000, 4),
            Transition::new(3427668000, 5),
            Transition::new(3454884000, 4),
            Transition::new(3458512800, 5),
            Transition::new(3485728800, 4),
            Transition::new(3488752800, 5),
            Transition::new(3515968800, 4),
            Transition::new(3519597600, 5),
            Transition::new(3546813600, 4),
            Transition::new(3550442400, 5),
            Transition::new(3577658400, 4),
            Transition::new(3580682400, 5),
            Transition::new(3607898400, 4),
            Transition::new(3611527200, 5),
            Transition::new(3638743200, 4),
            Transition::new(3642372000, 5),
            Transition::new(3669588000, 4),
            Transition::new(3672612000, 5),
            Transition::new(3699828000, 4),
            Transition::new(3703456800, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-3168, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, true, Some(b"+01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"+00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, true, Some(b"+00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"+01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"+01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_FREETOWN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2776979220, 1),
            Transition::new(-1783120020, 3),
            Transition::new(-1170284400, 2),
            Transition::new(-1159831200, 3),
            Transition::new(-1146610800, 2),
            Transition::new(-1128295200, 3),
            Transition::new(-1115074800, 2),
            Transition::new(-1096759200, 3),
            Transition::new(-1083538800, 2),
            Transition::new(-1065136800, 3),
            Transition::new(-1051916400, 2),
            Transition::new(-1033600800, 3),
            Transition::new(-1020380400, 2),
            Transition::new(-1002064800, 3),
            Transition::new(-988844400, 2),
            Transition::new(-965258400, 3),
            Transition::new(-957308400, 2),
            Transition::new(-956964000, 3),
            Transition::new(-885769200, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-3180, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3180, false, Some(b"FMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-2400, true, Some(b"-0040")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(1200, true, Some(b"+01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(2400, false, Some(b"XXX")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(1200, true, Some(b"+01")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::Julian0WithLeap(match Julian0WithLeap::new(0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                    RuleDay::Julian1WithoutLeap(match Julian1WithoutLeap::new(365) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    85200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_GABORONE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2682294220, 1),
            Transition::new(-2109288600, 2),
            Transition::new(-829526400, 3),
            Transition::new(-813805200, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(6220, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(5400, false, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"CAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_HARARE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-2109290652, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(7452, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_JOHANNESBURG: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2458173120, 1),
            Transition::new(-2109288600, 3),
            Transition::new(-860976000, 2),
            Transition::new(-845254800, 3),
            Transition::new(-829526400, 2),
            Transition::new(-813805200, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(6720, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(5400, false, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_JUBA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1230775588, 2),
            Transition::new(10360800, 1),
            Transition::new(24786000, 2),
            Transition::new(41810400, 1),
            Transition::new(56322000, 2),
            Transition::new(73432800, 1),
            Transition::new(87944400, 2),
            Transition::new(104882400, 1),
            Transition::new(119480400, 2),
            Transition::new(136332000, 1),
            Transition::new(151016400, 2),
            Transition::new(167781600, 1),
            Transition::new(182552400, 2),
            Transition::new(199231200, 1),
            Transition::new(214174800, 2),
            Transition::new(230680800, 1),
            Transition::new(245710800, 2),
            Transition::new(262735200, 1),
            Transition::new(277246800, 2),
            Transition::new(294184800, 1),
            Transition::new(308782800, 2),
            Transition::new(325634400, 1),
            Transition::new(340405200, 2),
            Transition::new(357084000, 1),
            Transition::new(371941200, 2),
            Transition::new(388533600, 1),
            Transition::new(403477200, 2),
            Transition::new(419983200, 1),
            Transition::new(435013200, 2),
            Transition::new(452037600, 1),
            Transition::new(466635600, 2),
            Transition::new(483487200, 1),
            Transition::new(498171600, 2),
            Transition::new(947930400, 3),
            Transition::new(1612126800, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(7588, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"CAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_KAMPALA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1309745380, 1),
            Transition::new(-1262314800, 2),
            Transition::new(-694319400, 3),
            Transition::new(-410237100, 1),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(7780, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(9000, false, Some(b"+0230")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(9900, false, Some(b"+0245")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_KHARTOUM: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1230775808, 2),
            Transition::new(10360800, 1),
            Transition::new(24786000, 2),
            Transition::new(41810400, 1),
            Transition::new(56322000, 2),
            Transition::new(73432800, 1),
            Transition::new(87944400, 2),
            Transition::new(104882400, 1),
            Transition::new(119480400, 2),
            Transition::new(136332000, 1),
            Transition::new(151016400, 2),
            Transition::new(167781600, 1),
            Transition::new(182552400, 2),
            Transition::new(199231200, 1),
            Transition::new(214174800, 2),
            Transition::new(230680800, 1),
            Transition::new(245710800, 2),
            Transition::new(262735200, 1),
            Transition::new(277246800, 2),
            Transition::new(294184800, 1),
            Transition::new(308782800, 2),
            Transition::new(325634400, 1),
            Transition::new(340405200, 2),
            Transition::new(357084000, 1),
            Transition::new(371941200, 2),
            Transition::new(388533600, 1),
            Transition::new(403477200, 2),
            Transition::new(419983200, 1),
            Transition::new(435013200, 2),
            Transition::new(452037600, 1),
            Transition::new(466635600, 2),
            Transition::new(483487200, 1),
            Transition::new(498171600, 2),
            Transition::new(947930400, 3),
            Transition::new(1509483600, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(7808, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"CAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_KIGALI: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1091498416, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(7216, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_KINSHASA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-2276643672, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(3672, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_LAGOS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2035584815, 1),
            Transition::new(-1940889600, 0),
            Transition::new(-1767226415, 2),
            Transition::new(-1588465800, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(815, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(1800, false, Some(b"+0030")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_LIBREVILLE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1830386268, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(2268, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_LOME: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-2429827492, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(292, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_LUANDA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2461452776, 1),
            Transition::new(-1830387600, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(3176, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3124, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_LUBUMBASHI: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2276646592, 1),
            Transition::new(-1567990800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(6592, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_LUSAKA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-2109289988, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(6788, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_MALABO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1830386108, 1),
            Transition::new(-190857600, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(2108, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_MAPUTO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-2109291020, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(7820, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_MASERU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2109289800, 1),
            Transition::new(-829526400, 2),
            Transition::new(-813805200, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(6600, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_MBABANE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-2109290664, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(7464, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_MOGADISHU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2403572488, 1),
            Transition::new(-1230778800, 2),
            Transition::new(-410236200, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(10888, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(9000, false, Some(b"+0230")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_MONROVIA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2776979812, 1),
            Transition::new(-1604359012, 2),
            Transition::new(63593070, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-2588, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-2588, false, Some(b"MMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-2670, false, Some(b"MMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_NAIROBI: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1946168836, 1),
            Transition::new(-1309746600, 2),
            Transition::new(-1261969200, 1),
            Transition::new(-1041388200, 3),
            Transition::new(-865305900, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(8836, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(9000, false, Some(b"+0230")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(9900, false, Some(b"+0245")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_NDJAMENA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1830387612, 1),
            Transition::new(308703600, 2),
            Transition::new(321314400, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(3612, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, true, Some(b"WAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_NIAMEY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1830384508, 1),
            Transition::new(-1131231600, 2),
            Transition::new(-315619200, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(508, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_NOUAKCHOTT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1830380172, 1),
            Transition::new(-1131235200, 2),
            Transition::new(-286930800, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-3828, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_OUAGADOUGOU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1830383636, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(-364, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_PORTO_NOVO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1830384628, 1),
            Transition::new(-1131235200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(628, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_SAO_TOME: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713912016, 1),
            Transition::new(-1830384000, 2),
            Transition::new(1514768400, 3),
            Transition::new(1546304400, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(1616, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-2205, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_TIMBUKTU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1830383276, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(-724, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_TUNIS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2797202444, 1),
            Transition::new(-1855958961, 3),
            Transition::new(-969242400, 2),
            Transition::new(-950493600, 3),
            Transition::new(-941940000, 2),
            Transition::new(-891136800, 3),
            Transition::new(-877827600, 2),
            Transition::new(-857257200, 3),
            Transition::new(-844556400, 2),
            Transition::new(-842918400, 3),
            Transition::new(-842223600, 2),
            Transition::new(-828230400, 3),
            Transition::new(-812502000, 2),
            Transition::new(-796269600, 3),
            Transition::new(-781052400, 2),
            Transition::new(-766634400, 3),
            Transition::new(231202800, 2),
            Transition::new(243903600, 3),
            Transition::new(262825200, 2),
            Transition::new(276044400, 3),
            Transition::new(581122800, 2),
            Transition::new(591145200, 3),
            Transition::new(606870000, 2),
            Transition::new(622594800, 3),
            Transition::new(641516400, 2),
            Transition::new(654649200, 3),
            Transition::new(1114902000, 2),
            Transition::new(1128038400, 3),
            Transition::new(1143334800, 2),
            Transition::new(1162083600, 3),
            Transition::new(1174784400, 2),
            Transition::new(1193533200, 3),
            Transition::new(1206838800, 2),
            Transition::new(1224982800, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(2444, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(561, false, Some(b"PMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, true, Some(b"CEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"CET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"CET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_WINDHOEK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2458170504, 1),
            Transition::new(-2109288600, 2),
            Transition::new(-860976000, 3),
            Transition::new(-845254800, 2),
            Transition::new(637970400, 5),
            Transition::new(764200800, 4),
            Transition::new(778640400, 5),
            Transition::new(796780800, 4),
            Transition::new(810090000, 5),
            Transition::new(828835200, 4),
            Transition::new(841539600, 5),
            Transition::new(860284800, 4),
            Transition::new(873594000, 5),
            Transition::new(891734400, 4),
            Transition::new(905043600, 5),
            Transition::new(923184000, 4),
            Transition::new(936493200, 5),
            Transition::new(954633600, 4),
            Transition::new(967942800, 5),
            Transition::new(986083200, 4),
            Transition::new(999392400, 5),
            Transition::new(1018137600, 4),
            Transition::new(1030842000, 5),
            Transition::new(1049587200, 4),
            Transition::new(1062896400, 5),
            Transition::new(1081036800, 4),
            Transition::new(1094346000, 5),
            Transition::new(1112486400, 4),
            Transition::new(1125795600, 5),
            Transition::new(1143936000, 4),
            Transition::new(1157245200, 5),
            Transition::new(1175385600, 4),
            Transition::new(1188694800, 5),
            Transition::new(1207440000, 4),
            Transition::new(1220749200, 5),
            Transition::new(1238889600, 4),
            Transition::new(1252198800, 5),
            Transition::new(1270339200, 4),
            Transition::new(1283648400, 5),
            Transition::new(1301788800, 4),
            Transition::new(1315098000, 5),
            Transition::new(1333238400, 4),
            Transition::new(1346547600, 5),
            Transition::new(1365292800, 4),
            Transition::new(1377997200, 5),
            Transition::new(1396742400, 4),
            Transition::new(1410051600, 5),
            Transition::new(1428192000, 4),
            Transition::new(1441501200, 5),
            Transition::new(1459641600, 4),
            Transition::new(1472950800, 5),
            Transition::new(1491091200, 4),
            Transition::new(1504400400, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(4104, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(5400, false, Some(b"+0130")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, true, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ADAK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3225223727, 1),
            Transition::new(-2188944802, 2),
            Transition::new(-880196400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765374400, 2),
            Transition::new(-86878800, 5),
            Transition::new(-21466800, 6),
            Transition::new(-5745600, 5),
            Transition::new(9982800, 6),
            Transition::new(25704000, 5),
            Transition::new(41432400, 6),
            Transition::new(57758400, 5),
            Transition::new(73486800, 6),
            Transition::new(89208000, 5),
            Transition::new(104936400, 6),
            Transition::new(120657600, 5),
            Transition::new(126709200, 6),
            Transition::new(152107200, 5),
            Transition::new(162392400, 6),
            Transition::new(183556800, 5),
            Transition::new(199285200, 6),
            Transition::new(215611200, 5),
            Transition::new(230734800, 6),
            Transition::new(247060800, 5),
            Transition::new(262789200, 6),
            Transition::new(278510400, 5),
            Transition::new(294238800, 6),
            Transition::new(309960000, 5),
            Transition::new(325688400, 6),
            Transition::new(341409600, 5),
            Transition::new(357138000, 6),
            Transition::new(372859200, 5),
            Transition::new(388587600, 6),
            Transition::new(404913600, 5),
            Transition::new(420037200, 6),
            Transition::new(436363200, 7),
            Transition::new(439034400, 9),
            Transition::new(452088000, 8),
            Transition::new(467809200, 9),
            Transition::new(483537600, 8),
            Transition::new(499258800, 9),
            Transition::new(514987200, 8),
            Transition::new(530708400, 9),
            Transition::new(544622400, 8),
            Transition::new(562158000, 9),
            Transition::new(576072000, 8),
            Transition::new(594212400, 9),
            Transition::new(607521600, 8),
            Transition::new(625662000, 9),
            Transition::new(638971200, 8),
            Transition::new(657111600, 9),
            Transition::new(671025600, 8),
            Transition::new(688561200, 9),
            Transition::new(702475200, 8),
            Transition::new(720010800, 9),
            Transition::new(733924800, 8),
            Transition::new(752065200, 9),
            Transition::new(765374400, 8),
            Transition::new(783514800, 9),
            Transition::new(796824000, 8),
            Transition::new(814964400, 9),
            Transition::new(828878400, 8),
            Transition::new(846414000, 9),
            Transition::new(860328000, 8),
            Transition::new(877863600, 9),
            Transition::new(891777600, 8),
            Transition::new(909313200, 9),
            Transition::new(923227200, 8),
            Transition::new(941367600, 9),
            Transition::new(954676800, 8),
            Transition::new(972817200, 9),
            Transition::new(986126400, 8),
            Transition::new(1004266800, 9),
            Transition::new(1018180800, 8),
            Transition::new(1035716400, 9),
            Transition::new(1049630400, 8),
            Transition::new(1067166000, 9),
            Transition::new(1081080000, 8),
            Transition::new(1099220400, 9),
            Transition::new(1112529600, 8),
            Transition::new(1130670000, 9),
            Transition::new(1143979200, 8),
            Transition::new(1162119600, 9),
            Transition::new(1173614400, 8),
        ],
        &{
            const V: [LocalTimeType; 10] = [
                match LocalTimeType::new(44002, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-42398, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-39600, false, Some(b"NST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, true, Some(b"NWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, true, Some(b"NPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-39600, false, Some(b"BST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, true, Some(b"BDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, false, Some(b"AHST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, true, Some(b"HDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, false, Some(b"HST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-36000, false, Some(b"HST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-32400, true, Some(b"HDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ANCHORAGE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3225223727, 1),
            Transition::new(-2188951224, 2),
            Transition::new(-880200000, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765378000, 2),
            Transition::new(-86882400, 5),
            Transition::new(-21470400, 6),
            Transition::new(-5749200, 5),
            Transition::new(9979200, 6),
            Transition::new(25700400, 5),
            Transition::new(41428800, 6),
            Transition::new(57754800, 5),
            Transition::new(73483200, 6),
            Transition::new(89204400, 5),
            Transition::new(104932800, 6),
            Transition::new(120654000, 5),
            Transition::new(126705600, 6),
            Transition::new(152103600, 5),
            Transition::new(162388800, 6),
            Transition::new(183553200, 5),
            Transition::new(199281600, 6),
            Transition::new(215607600, 5),
            Transition::new(230731200, 6),
            Transition::new(247057200, 5),
            Transition::new(262785600, 6),
            Transition::new(278506800, 5),
            Transition::new(294235200, 6),
            Transition::new(309956400, 5),
            Transition::new(325684800, 6),
            Transition::new(341406000, 5),
            Transition::new(357134400, 6),
            Transition::new(372855600, 5),
            Transition::new(388584000, 6),
            Transition::new(404910000, 5),
            Transition::new(420033600, 6),
            Transition::new(436359600, 7),
            Transition::new(439030800, 9),
            Transition::new(452084400, 8),
            Transition::new(467805600, 9),
            Transition::new(483534000, 8),
            Transition::new(499255200, 9),
            Transition::new(514983600, 8),
            Transition::new(530704800, 9),
            Transition::new(544618800, 8),
            Transition::new(562154400, 9),
            Transition::new(576068400, 8),
            Transition::new(594208800, 9),
            Transition::new(607518000, 8),
            Transition::new(625658400, 9),
            Transition::new(638967600, 8),
            Transition::new(657108000, 9),
            Transition::new(671022000, 8),
            Transition::new(688557600, 9),
            Transition::new(702471600, 8),
            Transition::new(720007200, 9),
            Transition::new(733921200, 8),
            Transition::new(752061600, 9),
            Transition::new(765370800, 8),
            Transition::new(783511200, 9),
            Transition::new(796820400, 8),
            Transition::new(814960800, 9),
            Transition::new(828874800, 8),
            Transition::new(846410400, 9),
            Transition::new(860324400, 8),
            Transition::new(877860000, 9),
            Transition::new(891774000, 8),
            Transition::new(909309600, 9),
            Transition::new(923223600, 8),
            Transition::new(941364000, 9),
            Transition::new(954673200, 8),
            Transition::new(972813600, 9),
            Transition::new(986122800, 8),
            Transition::new(1004263200, 9),
            Transition::new(1018177200, 8),
            Transition::new(1035712800, 9),
            Transition::new(1049626800, 8),
            Transition::new(1067162400, 9),
            Transition::new(1081076400, 8),
            Transition::new(1099216800, 9),
            Transition::new(1112526000, 8),
            Transition::new(1130666400, 9),
            Transition::new(1143975600, 8),
            Transition::new(1162116000, 9),
            Transition::new(1173610800, 8),
        ],
        &{
            const V: [LocalTimeType; 10] = [
                match LocalTimeType::new(50424, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-35976, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, true, Some(b"AWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, true, Some(b"APT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, false, Some(b"AHST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, true, Some(b"AHDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"YST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ANGUILLA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1825098464, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(-15136, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ANTIGUA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1825098768, 1),
            Transition::new(-599598000, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-14832, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ARAGUAINA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767214032, 2),
            Transition::new(-1206957600, 1),
            Transition::new(-1191362400, 2),
            Transition::new(-1175374800, 1),
            Transition::new(-1159826400, 2),
            Transition::new(-633819600, 1),
            Transition::new(-622069200, 2),
            Transition::new(-602283600, 1),
            Transition::new(-591832800, 2),
            Transition::new(-570747600, 1),
            Transition::new(-560210400, 2),
            Transition::new(-539125200, 1),
            Transition::new(-531352800, 2),
            Transition::new(-191365200, 1),
            Transition::new(-184197600, 2),
            Transition::new(-155163600, 1),
            Transition::new(-150069600, 2),
            Transition::new(-128898000, 1),
            Transition::new(-121125600, 2),
            Transition::new(-99954000, 1),
            Transition::new(-89589600, 2),
            Transition::new(-68418000, 1),
            Transition::new(-57967200, 2),
            Transition::new(499748400, 1),
            Transition::new(511236000, 2),
            Transition::new(530593200, 1),
            Transition::new(540266400, 2),
            Transition::new(562129200, 1),
            Transition::new(571197600, 2),
            Transition::new(592974000, 1),
            Transition::new(602042400, 2),
            Transition::new(624423600, 1),
            Transition::new(634701600, 2),
            Transition::new(813726000, 1),
            Transition::new(824004000, 2),
            Transition::new(844570800, 1),
            Transition::new(856058400, 2),
            Transition::new(876106800, 1),
            Transition::new(888717600, 2),
            Transition::new(908074800, 1),
            Transition::new(919562400, 2),
            Transition::new(938919600, 1),
            Transition::new(951616800, 2),
            Transition::new(970974000, 1),
            Transition::new(982461600, 2),
            Transition::new(1003028400, 1),
            Transition::new(1013911200, 2),
            Transition::new(1036292400, 1),
            Transition::new(1045360800, 2),
            Transition::new(1350788400, 1),
            Transition::new(1361066400, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-11568, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ARUBA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1826738376, 1),
            Transition::new(-157750200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-16824, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-16200, false, Some(b"-0430")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ASUNCION: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524507760, 1),
            Transition::new(-1206389360, 2),
            Transition::new(86760000, 3),
            Transition::new(134017200, 2),
            Transition::new(181368000, 4),
            Transition::new(194497200, 2),
            Transition::new(212990400, 4),
            Transition::new(226033200, 2),
            Transition::new(244526400, 4),
            Transition::new(257569200, 2),
            Transition::new(276062400, 4),
            Transition::new(291783600, 2),
            Transition::new(307598400, 4),
            Transition::new(323406000, 2),
            Transition::new(339220800, 4),
            Transition::new(354942000, 2),
            Transition::new(370756800, 4),
            Transition::new(386478000, 2),
            Transition::new(402292800, 4),
            Transition::new(418014000, 2),
            Transition::new(433828800, 4),
            Transition::new(449636400, 2),
            Transition::new(465451200, 4),
            Transition::new(481172400, 2),
            Transition::new(496987200, 4),
            Transition::new(512708400, 2),
            Transition::new(528523200, 4),
            Transition::new(544244400, 2),
            Transition::new(560059200, 4),
            Transition::new(575866800, 2),
            Transition::new(591681600, 4),
            Transition::new(607402800, 2),
            Transition::new(625032000, 4),
            Transition::new(638938800, 2),
            Transition::new(654753600, 4),
            Transition::new(670474800, 2),
            Transition::new(686721600, 4),
            Transition::new(699418800, 2),
            Transition::new(718257600, 4),
            Transition::new(733546800, 2),
            Transition::new(749448000, 4),
            Transition::new(762318000, 2),
            Transition::new(780984000, 4),
            Transition::new(793767600, 2),
            Transition::new(812520000, 4),
            Transition::new(825649200, 2),
            Transition::new(844574400, 4),
            Transition::new(856666800, 2),
            Transition::new(876024000, 4),
            Transition::new(888721200, 2),
            Transition::new(907473600, 4),
            Transition::new(920775600, 2),
            Transition::new(938923200, 4),
            Transition::new(952225200, 2),
            Transition::new(970372800, 4),
            Transition::new(983674800, 2),
            Transition::new(1002427200, 4),
            Transition::new(1018148400, 2),
            Transition::new(1030852800, 4),
            Transition::new(1049598000, 2),
            Transition::new(1062907200, 4),
            Transition::new(1081047600, 2),
            Transition::new(1097985600, 4),
            Transition::new(1110682800, 2),
            Transition::new(1129435200, 4),
            Transition::new(1142132400, 2),
            Transition::new(1160884800, 4),
            Transition::new(1173582000, 2),
            Transition::new(1192939200, 4),
            Transition::new(1205031600, 2),
            Transition::new(1224388800, 4),
            Transition::new(1236481200, 2),
            Transition::new(1255838400, 4),
            Transition::new(1270954800, 2),
            Transition::new(1286078400, 4),
            Transition::new(1302404400, 2),
            Transition::new(1317528000, 4),
            Transition::new(1333854000, 2),
            Transition::new(1349582400, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-13840, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-13840, false, Some(b"AMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-14400, false, Some(b"-04")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-10800, true, Some(b"-03")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 4, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ATIKOKAN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2366733212, 2),
            Transition::new(-1632067200, 1),
            Transition::new(-1615136400, 2),
            Transition::new(-923248800, 1),
            Transition::new(-880214400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765392400, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-21988, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BAHIA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767216356, 2),
            Transition::new(-1206957600, 1),
            Transition::new(-1191362400, 2),
            Transition::new(-1175374800, 1),
            Transition::new(-1159826400, 2),
            Transition::new(-633819600, 1),
            Transition::new(-622069200, 2),
            Transition::new(-602283600, 1),
            Transition::new(-591832800, 2),
            Transition::new(-570747600, 1),
            Transition::new(-560210400, 2),
            Transition::new(-539125200, 1),
            Transition::new(-531352800, 2),
            Transition::new(-191365200, 1),
            Transition::new(-184197600, 2),
            Transition::new(-155163600, 1),
            Transition::new(-150069600, 2),
            Transition::new(-128898000, 1),
            Transition::new(-121125600, 2),
            Transition::new(-99954000, 1),
            Transition::new(-89589600, 2),
            Transition::new(-68418000, 1),
            Transition::new(-57967200, 2),
            Transition::new(499748400, 1),
            Transition::new(511236000, 2),
            Transition::new(530593200, 1),
            Transition::new(540266400, 2),
            Transition::new(562129200, 1),
            Transition::new(571197600, 2),
            Transition::new(592974000, 1),
            Transition::new(602042400, 2),
            Transition::new(624423600, 1),
            Transition::new(634701600, 2),
            Transition::new(656478000, 1),
            Transition::new(666756000, 2),
            Transition::new(687927600, 1),
            Transition::new(697600800, 2),
            Transition::new(719982000, 1),
            Transition::new(728445600, 2),
            Transition::new(750826800, 1),
            Transition::new(761709600, 2),
            Transition::new(782276400, 1),
            Transition::new(793159200, 2),
            Transition::new(813726000, 1),
            Transition::new(824004000, 2),
            Transition::new(844570800, 1),
            Transition::new(856058400, 2),
            Transition::new(876106800, 1),
            Transition::new(888717600, 2),
            Transition::new(908074800, 1),
            Transition::new(919562400, 2),
            Transition::new(938919600, 1),
            Transition::new(951616800, 2),
            Transition::new(970974000, 1),
            Transition::new(982461600, 2),
            Transition::new(1003028400, 1),
            Transition::new(1013911200, 2),
            Transition::new(1036292400, 1),
            Transition::new(1045360800, 2),
            Transition::new(1318734000, 1),
            Transition::new(1330221600, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-9244, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BAHIA_BANDERAS: TimeZoneRef<'static> =
        match TimeZoneRef::<'static>::new(
            &[
                Transition::new(-1514739600, 1),
                Transition::new(-1343066400, 2),
                Transition::new(-1234807200, 1),
                Transition::new(-1220292000, 2),
                Transition::new(-1207159200, 1),
                Transition::new(-1191344400, 2),
                Transition::new(-873828000, 1),
                Transition::new(-661539600, 3),
                Transition::new(28800, 1),
                Transition::new(828867600, 4),
                Transition::new(846403200, 1),
                Transition::new(860317200, 4),
                Transition::new(877852800, 1),
                Transition::new(891766800, 4),
                Transition::new(909302400, 1),
                Transition::new(923216400, 4),
                Transition::new(941356800, 1),
                Transition::new(954666000, 4),
                Transition::new(972806400, 1),
                Transition::new(989139600, 4),
                Transition::new(1001836800, 1),
                Transition::new(1018170000, 4),
                Transition::new(1035705600, 1),
                Transition::new(1049619600, 4),
                Transition::new(1067155200, 1),
                Transition::new(1081069200, 4),
                Transition::new(1099209600, 1),
                Transition::new(1112518800, 4),
                Transition::new(1130659200, 1),
                Transition::new(1143968400, 4),
                Transition::new(1162108800, 1),
                Transition::new(1175418000, 4),
                Transition::new(1193558400, 1),
                Transition::new(1207472400, 4),
                Transition::new(1225008000, 1),
                Transition::new(1238922000, 4),
                Transition::new(1256457600, 1),
                Transition::new(1270371600, 5),
                Transition::new(1288508400, 2),
            ],
            &{
                const V: [LocalTimeType; 6] = [
                    match LocalTimeType::new(-25260, false, Some(b"LMT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-28800, false, Some(b"PST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                ];
                V
            },
            &[],
            &Some({
                const V: TransitionRule = TransitionRule::Alternate(
                    match AlternateTime::new(
                        match LocalTimeType::new(-21600, false, Some(b"CST")) {
                            Ok(v) => v,
                            Err(e) => panic!("{}", e.0),
                        },
                        match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                            Ok(v) => v,
                            Err(e) => panic!("{}", e.0),
                        },
                        RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                            Ok(v) => v,
                            Err(e) => panic!("{}", e.0),
                        }),
                        7200,
                        RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                            Ok(v) => v,
                            Err(e) => panic!("{}", e.0),
                        }),
                        7200,
                    ) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                );
                V
            }),
        ) {
            Ok(v) => v,
            Err(e) => panic!("{}", e.0),
        };

    pub(crate) const AMERICA_BARBADOS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1841256091, 2),
            Transition::new(-874263600, 1),
            Transition::new(-862682400, 2),
            Transition::new(-841604400, 1),
            Transition::new(-830714400, 2),
            Transition::new(-811882800, 3),
            Transition::new(-798660000, 2),
            Transition::new(234943200, 1),
            Transition::new(244616400, 2),
            Transition::new(261554400, 1),
            Transition::new(276066000, 2),
            Transition::new(293004000, 1),
            Transition::new(307515600, 2),
            Transition::new(325058400, 1),
            Transition::new(338706000, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-14309, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-12600, true, Some(b"-0330")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BELEM: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767213964, 2),
            Transition::new(-1206957600, 1),
            Transition::new(-1191362400, 2),
            Transition::new(-1175374800, 1),
            Transition::new(-1159826400, 2),
            Transition::new(-633819600, 1),
            Transition::new(-622069200, 2),
            Transition::new(-602283600, 1),
            Transition::new(-591832800, 2),
            Transition::new(-570747600, 1),
            Transition::new(-560210400, 2),
            Transition::new(-539125200, 1),
            Transition::new(-531352800, 2),
            Transition::new(-191365200, 1),
            Transition::new(-184197600, 2),
            Transition::new(-155163600, 1),
            Transition::new(-150069600, 2),
            Transition::new(-128898000, 1),
            Transition::new(-121125600, 2),
            Transition::new(-99954000, 1),
            Transition::new(-89589600, 2),
            Transition::new(-68418000, 1),
            Transition::new(-57967200, 2),
            Transition::new(499748400, 1),
            Transition::new(511236000, 2),
            Transition::new(530593200, 1),
            Transition::new(540266400, 2),
            Transition::new(562129200, 1),
            Transition::new(571197600, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-11636, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BELIZE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1822500432, 2),
            Transition::new(-1616954400, 1),
            Transition::new(-1606069800, 2),
            Transition::new(-1585504800, 1),
            Transition::new(-1574015400, 2),
            Transition::new(-1554055200, 1),
            Transition::new(-1542565800, 2),
            Transition::new(-1522605600, 1),
            Transition::new(-1511116200, 2),
            Transition::new(-1490551200, 1),
            Transition::new(-1479666600, 2),
            Transition::new(-1459101600, 1),
            Transition::new(-1448217000, 2),
            Transition::new(-1427652000, 1),
            Transition::new(-1416162600, 2),
            Transition::new(-1396202400, 1),
            Transition::new(-1384713000, 2),
            Transition::new(-1364752800, 1),
            Transition::new(-1353263400, 2),
            Transition::new(-1333303200, 1),
            Transition::new(-1321813800, 2),
            Transition::new(-1301248800, 1),
            Transition::new(-1290364200, 2),
            Transition::new(-1269799200, 1),
            Transition::new(-1258914600, 2),
            Transition::new(-1238349600, 1),
            Transition::new(-1226860200, 2),
            Transition::new(-1206900000, 1),
            Transition::new(-1195410600, 2),
            Transition::new(-1175450400, 1),
            Transition::new(-1163961000, 2),
            Transition::new(-1143396000, 1),
            Transition::new(-1132511400, 2),
            Transition::new(-1111946400, 1),
            Transition::new(-1101061800, 2),
            Transition::new(-1080496800, 1),
            Transition::new(-1069612200, 2),
            Transition::new(-1049047200, 1),
            Transition::new(-1037557800, 2),
            Transition::new(-1017597600, 1),
            Transition::new(-1006108200, 2),
            Transition::new(-986148000, 1),
            Transition::new(-974658600, 2),
            Transition::new(-954093600, 1),
            Transition::new(-943209000, 2),
            Transition::new(-922644000, 1),
            Transition::new(-911759400, 2),
            Transition::new(-891194400, 1),
            Transition::new(-879705000, 2),
            Transition::new(-868212000, 3),
            Transition::new(-769395600, 4),
            Transition::new(-758746800, 2),
            Transition::new(-701892000, 1),
            Transition::new(-690402600, 2),
            Transition::new(-670442400, 1),
            Transition::new(-658953000, 2),
            Transition::new(-638992800, 1),
            Transition::new(-627503400, 2),
            Transition::new(-606938400, 1),
            Transition::new(-596053800, 2),
            Transition::new(-575488800, 1),
            Transition::new(-564604200, 2),
            Transition::new(-544039200, 1),
            Transition::new(-532549800, 2),
            Transition::new(-512589600, 1),
            Transition::new(-501100200, 2),
            Transition::new(-481140000, 1),
            Transition::new(-469650600, 2),
            Transition::new(-449690400, 1),
            Transition::new(-438201000, 2),
            Transition::new(-417636000, 1),
            Transition::new(-406751400, 2),
            Transition::new(-386186400, 1),
            Transition::new(-375301800, 2),
            Transition::new(-354736800, 1),
            Transition::new(-343247400, 2),
            Transition::new(-323287200, 1),
            Transition::new(-311797800, 2),
            Transition::new(-291837600, 1),
            Transition::new(-280348200, 2),
            Transition::new(-259783200, 1),
            Transition::new(-248898600, 2),
            Transition::new(-228333600, 1),
            Transition::new(-217449000, 2),
            Transition::new(-196884000, 1),
            Transition::new(-185999400, 2),
            Transition::new(-165434400, 1),
            Transition::new(-153945000, 2),
            Transition::new(-133984800, 1),
            Transition::new(-122495400, 2),
            Transition::new(-102535200, 1),
            Transition::new(-91045800, 2),
            Transition::new(-70480800, 1),
            Transition::new(-59596200, 2),
            Transition::new(123919200, 5),
            Transition::new(129618000, 2),
            Transition::new(409039200, 5),
            Transition::new(413874000, 2),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-21168, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-19800, true, Some(b"-0530")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BLANC_SABLON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713896692, 2),
            Transition::new(-1632074400, 1),
            Transition::new(-1615143600, 2),
            Transition::new(-880221600, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765399600, 2),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-13708, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"AWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"APT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BOA_VISTA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767211040, 2),
            Transition::new(-1206954000, 1),
            Transition::new(-1191358800, 2),
            Transition::new(-1175371200, 1),
            Transition::new(-1159822800, 2),
            Transition::new(-633816000, 1),
            Transition::new(-622065600, 2),
            Transition::new(-602280000, 1),
            Transition::new(-591829200, 2),
            Transition::new(-570744000, 1),
            Transition::new(-560206800, 2),
            Transition::new(-539121600, 1),
            Transition::new(-531349200, 2),
            Transition::new(-191361600, 1),
            Transition::new(-184194000, 2),
            Transition::new(-155160000, 1),
            Transition::new(-150066000, 2),
            Transition::new(-128894400, 1),
            Transition::new(-121122000, 2),
            Transition::new(-99950400, 1),
            Transition::new(-89586000, 2),
            Transition::new(-68414400, 1),
            Transition::new(-57963600, 2),
            Transition::new(499752000, 1),
            Transition::new(511239600, 2),
            Transition::new(530596800, 1),
            Transition::new(540270000, 2),
            Transition::new(562132800, 1),
            Transition::new(571201200, 2),
            Transition::new(938923200, 1),
            Transition::new(951620400, 2),
            Transition::new(970977600, 1),
            Transition::new(971578800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-14560, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BOGOTA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2707671824, 1),
            Transition::new(-1739041424, 3),
            Transition::new(704869200, 2),
            Transition::new(733896000, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-17776, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-17776, false, Some(b"BMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BOISE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2717640000, 2),
            Transition::new(-1633269600, 1),
            Transition::new(-1615129200, 2),
            Transition::new(-1601820000, 1),
            Transition::new(-1583679600, 2),
            Transition::new(-1471788000, 5),
            Transition::new(-880210800, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765388800, 5),
            Transition::new(-84380400, 6),
            Transition::new(-68659200, 5),
            Transition::new(-52930800, 6),
            Transition::new(-37209600, 5),
            Transition::new(-21481200, 6),
            Transition::new(-5760000, 5),
            Transition::new(9968400, 6),
            Transition::new(25689600, 5),
            Transition::new(41418000, 6),
            Transition::new(57744000, 5),
            Transition::new(73472400, 6),
            Transition::new(89193600, 5),
            Transition::new(104922000, 6),
            Transition::new(120643200, 5),
            Transition::new(129114000, 6),
            Transition::new(152092800, 5),
            Transition::new(162378000, 6),
            Transition::new(183542400, 5),
            Transition::new(199270800, 6),
            Transition::new(215596800, 5),
            Transition::new(230720400, 6),
            Transition::new(247046400, 5),
            Transition::new(262774800, 6),
            Transition::new(278496000, 5),
            Transition::new(294224400, 6),
            Transition::new(309945600, 5),
            Transition::new(325674000, 6),
            Transition::new(341395200, 5),
            Transition::new(357123600, 6),
            Transition::new(372844800, 5),
            Transition::new(388573200, 6),
            Transition::new(404899200, 5),
            Transition::new(420022800, 6),
            Transition::new(436348800, 5),
            Transition::new(452077200, 6),
            Transition::new(467798400, 5),
            Transition::new(483526800, 6),
            Transition::new(499248000, 5),
            Transition::new(514976400, 6),
            Transition::new(530697600, 5),
            Transition::new(544611600, 6),
            Transition::new(562147200, 5),
            Transition::new(576061200, 6),
            Transition::new(594201600, 5),
            Transition::new(607510800, 6),
            Transition::new(625651200, 5),
            Transition::new(638960400, 6),
            Transition::new(657100800, 5),
            Transition::new(671014800, 6),
            Transition::new(688550400, 5),
            Transition::new(702464400, 6),
            Transition::new(720000000, 5),
            Transition::new(733914000, 6),
            Transition::new(752054400, 5),
            Transition::new(765363600, 6),
            Transition::new(783504000, 5),
            Transition::new(796813200, 6),
            Transition::new(814953600, 5),
            Transition::new(828867600, 6),
            Transition::new(846403200, 5),
            Transition::new(860317200, 6),
            Transition::new(877852800, 5),
            Transition::new(891766800, 6),
            Transition::new(909302400, 5),
            Transition::new(923216400, 6),
            Transition::new(941356800, 5),
            Transition::new(954666000, 6),
            Transition::new(972806400, 5),
            Transition::new(986115600, 6),
            Transition::new(1004256000, 5),
            Transition::new(1018170000, 6),
            Transition::new(1035705600, 5),
            Transition::new(1049619600, 6),
            Transition::new(1067155200, 5),
            Transition::new(1081069200, 6),
            Transition::new(1099209600, 5),
            Transition::new(1112518800, 6),
            Transition::new(1130659200, 5),
            Transition::new(1143968400, 6),
            Transition::new(1162108800, 5),
            Transition::new(1173603600, 6),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(-27889, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BUENOS_AIRES: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2372097972, 1),
            Transition::new(-1567453392, 2),
            Transition::new(-1233432000, 3),
            Transition::new(-1222981200, 2),
            Transition::new(-1205956800, 3),
            Transition::new(-1194037200, 2),
            Transition::new(-1172865600, 3),
            Transition::new(-1162501200, 2),
            Transition::new(-1141329600, 3),
            Transition::new(-1130965200, 2),
            Transition::new(-1109793600, 3),
            Transition::new(-1099429200, 2),
            Transition::new(-1078257600, 3),
            Transition::new(-1067806800, 2),
            Transition::new(-1046635200, 3),
            Transition::new(-1036270800, 2),
            Transition::new(-1015099200, 3),
            Transition::new(-1004734800, 2),
            Transition::new(-983563200, 3),
            Transition::new(-973198800, 2),
            Transition::new(-952027200, 3),
            Transition::new(-941576400, 2),
            Transition::new(-931032000, 3),
            Transition::new(-900882000, 2),
            Transition::new(-890337600, 3),
            Transition::new(-833749200, 2),
            Transition::new(-827265600, 3),
            Transition::new(-752274000, 2),
            Transition::new(-733780800, 3),
            Transition::new(-197326800, 2),
            Transition::new(-190843200, 3),
            Transition::new(-184194000, 2),
            Transition::new(-164491200, 3),
            Transition::new(-152658000, 2),
            Transition::new(-132955200, 3),
            Transition::new(-121122000, 2),
            Transition::new(-101419200, 3),
            Transition::new(-86821200, 2),
            Transition::new(-71092800, 3),
            Transition::new(-54766800, 2),
            Transition::new(-39038400, 3),
            Transition::new(-23317200, 2),
            Transition::new(-7588800, 5),
            Transition::new(128142000, 4),
            Transition::new(136605600, 5),
            Transition::new(596948400, 4),
            Transition::new(605066400, 5),
            Transition::new(624423600, 4),
            Transition::new(636516000, 5),
            Transition::new(656478000, 4),
            Transition::new(667965600, 5),
            Transition::new(687927600, 4),
            Transition::new(699415200, 5),
            Transition::new(719377200, 4),
            Transition::new(731469600, 5),
            Transition::new(938919600, 3),
            Transition::new(952052400, 5),
            Transition::new(1198983600, 4),
            Transition::new(1205632800, 5),
            Transition::new(1224385200, 4),
            Transition::new(1237082400, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-14028, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-15408, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CAMBRIDGE_BAY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1577923200, 3),
            Transition::new(-880210800, 1),
            Transition::new(-769395600, 2),
            Transition::new(-765388800, 3),
            Transition::new(-147891600, 4),
            Transition::new(-131562000, 3),
            Transition::new(325674000, 5),
            Transition::new(341395200, 3),
            Transition::new(357123600, 5),
            Transition::new(372844800, 3),
            Transition::new(388573200, 5),
            Transition::new(404899200, 3),
            Transition::new(420022800, 5),
            Transition::new(436348800, 3),
            Transition::new(452077200, 5),
            Transition::new(467798400, 3),
            Transition::new(483526800, 5),
            Transition::new(499248000, 3),
            Transition::new(514976400, 5),
            Transition::new(530697600, 3),
            Transition::new(544611600, 5),
            Transition::new(562147200, 3),
            Transition::new(576061200, 5),
            Transition::new(594201600, 3),
            Transition::new(607510800, 5),
            Transition::new(625651200, 3),
            Transition::new(638960400, 5),
            Transition::new(657100800, 3),
            Transition::new(671014800, 5),
            Transition::new(688550400, 3),
            Transition::new(702464400, 5),
            Transition::new(720000000, 3),
            Transition::new(733914000, 5),
            Transition::new(752054400, 3),
            Transition::new(765363600, 5),
            Transition::new(783504000, 3),
            Transition::new(796813200, 5),
            Transition::new(814953600, 3),
            Transition::new(828867600, 5),
            Transition::new(846403200, 3),
            Transition::new(860317200, 5),
            Transition::new(877852800, 3),
            Transition::new(891766800, 5),
            Transition::new(909302400, 3),
            Transition::new(923216400, 5),
            Transition::new(941356800, 7),
            Transition::new(954662400, 6),
            Transition::new(972802800, 8),
            Transition::new(973400400, 7),
            Transition::new(986115600, 5),
            Transition::new(1004256000, 3),
            Transition::new(1018170000, 5),
            Transition::new(1035705600, 3),
            Transition::new(1049619600, 5),
            Transition::new(1067155200, 3),
            Transition::new(1081069200, 5),
            Transition::new(1099209600, 3),
            Transition::new(1112518800, 5),
            Transition::new(1130659200, 3),
            Transition::new(1143968400, 5),
            Transition::new(1162108800, 3),
            Transition::new(1173603600, 5),
        ],
        &{
            const V: [LocalTimeType; 9] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"MDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CAMPO_GRANDE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767212492, 2),
            Transition::new(-1206954000, 1),
            Transition::new(-1191358800, 2),
            Transition::new(-1175371200, 1),
            Transition::new(-1159822800, 2),
            Transition::new(-633816000, 1),
            Transition::new(-622065600, 2),
            Transition::new(-602280000, 1),
            Transition::new(-591829200, 2),
            Transition::new(-570744000, 1),
            Transition::new(-560206800, 2),
            Transition::new(-539121600, 1),
            Transition::new(-531349200, 2),
            Transition::new(-191361600, 1),
            Transition::new(-184194000, 2),
            Transition::new(-155160000, 1),
            Transition::new(-150066000, 2),
            Transition::new(-128894400, 1),
            Transition::new(-121122000, 2),
            Transition::new(-99950400, 1),
            Transition::new(-89586000, 2),
            Transition::new(-68414400, 1),
            Transition::new(-57963600, 2),
            Transition::new(499752000, 1),
            Transition::new(511239600, 2),
            Transition::new(530596800, 1),
            Transition::new(540270000, 2),
            Transition::new(562132800, 1),
            Transition::new(571201200, 2),
            Transition::new(592977600, 1),
            Transition::new(602046000, 2),
            Transition::new(624427200, 1),
            Transition::new(634705200, 2),
            Transition::new(656481600, 1),
            Transition::new(666759600, 2),
            Transition::new(687931200, 1),
            Transition::new(697604400, 2),
            Transition::new(719985600, 1),
            Transition::new(728449200, 2),
            Transition::new(750830400, 1),
            Transition::new(761713200, 2),
            Transition::new(782280000, 1),
            Transition::new(793162800, 2),
            Transition::new(813729600, 1),
            Transition::new(824007600, 2),
            Transition::new(844574400, 1),
            Transition::new(856062000, 2),
            Transition::new(876110400, 1),
            Transition::new(888721200, 2),
            Transition::new(908078400, 1),
            Transition::new(919566000, 2),
            Transition::new(938923200, 1),
            Transition::new(951620400, 2),
            Transition::new(970977600, 1),
            Transition::new(982465200, 2),
            Transition::new(1003032000, 1),
            Transition::new(1013914800, 2),
            Transition::new(1036296000, 1),
            Transition::new(1045364400, 2),
            Transition::new(1066536000, 1),
            Transition::new(1076814000, 2),
            Transition::new(1099368000, 1),
            Transition::new(1108868400, 2),
            Transition::new(1129435200, 1),
            Transition::new(1140318000, 2),
            Transition::new(1162699200, 1),
            Transition::new(1172372400, 2),
            Transition::new(1192334400, 1),
            Transition::new(1203217200, 2),
            Transition::new(1224388800, 1),
            Transition::new(1234666800, 2),
            Transition::new(1255838400, 1),
            Transition::new(1266721200, 2),
            Transition::new(1287288000, 1),
            Transition::new(1298170800, 2),
            Transition::new(1318737600, 1),
            Transition::new(1330225200, 2),
            Transition::new(1350792000, 1),
            Transition::new(1361070000, 2),
            Transition::new(1382241600, 1),
            Transition::new(1392519600, 2),
            Transition::new(1413691200, 1),
            Transition::new(1424574000, 2),
            Transition::new(1445140800, 1),
            Transition::new(1456023600, 2),
            Transition::new(1476590400, 1),
            Transition::new(1487473200, 2),
            Transition::new(1508040000, 1),
            Transition::new(1518922800, 2),
            Transition::new(1541304000, 1),
            Transition::new(1550372400, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-13108, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CANCUN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514743200, 1),
            Transition::new(377935200, 3),
            Transition::new(828860400, 2),
            Transition::new(846396000, 3),
            Transition::new(860310000, 2),
            Transition::new(877845600, 3),
            Transition::new(891759600, 2),
            Transition::new(902037600, 4),
            Transition::new(909298800, 1),
            Transition::new(923212800, 4),
            Transition::new(941353200, 1),
            Transition::new(954662400, 4),
            Transition::new(972802800, 1),
            Transition::new(989136000, 4),
            Transition::new(1001833200, 1),
            Transition::new(1018166400, 4),
            Transition::new(1035702000, 1),
            Transition::new(1049616000, 4),
            Transition::new(1067151600, 1),
            Transition::new(1081065600, 4),
            Transition::new(1099206000, 1),
            Transition::new(1112515200, 4),
            Transition::new(1130655600, 1),
            Transition::new(1143964800, 4),
            Transition::new(1162105200, 1),
            Transition::new(1175414400, 4),
            Transition::new(1193554800, 1),
            Transition::new(1207468800, 4),
            Transition::new(1225004400, 1),
            Transition::new(1238918400, 4),
            Transition::new(1256454000, 1),
            Transition::new(1270368000, 4),
            Transition::new(1288508400, 1),
            Transition::new(1301817600, 4),
            Transition::new(1319958000, 1),
            Transition::new(1333267200, 4),
            Transition::new(1351407600, 1),
            Transition::new(1365321600, 4),
            Transition::new(1382857200, 1),
            Transition::new(1396771200, 4),
            Transition::new(1414306800, 1),
            Transition::new(1422777600, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-20824, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CARACAS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524505536, 1),
            Transition::new(-1826739140, 2),
            Transition::new(-157750200, 3),
            Transition::new(1197183600, 2),
            Transition::new(1462086000, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-16064, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-16060, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-16200, false, Some(b"-0430")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CATAMARCA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2372096212, 1),
            Transition::new(-1567453392, 2),
            Transition::new(-1233432000, 3),
            Transition::new(-1222981200, 2),
            Transition::new(-1205956800, 3),
            Transition::new(-1194037200, 2),
            Transition::new(-1172865600, 3),
            Transition::new(-1162501200, 2),
            Transition::new(-1141329600, 3),
            Transition::new(-1130965200, 2),
            Transition::new(-1109793600, 3),
            Transition::new(-1099429200, 2),
            Transition::new(-1078257600, 3),
            Transition::new(-1067806800, 2),
            Transition::new(-1046635200, 3),
            Transition::new(-1036270800, 2),
            Transition::new(-1015099200, 3),
            Transition::new(-1004734800, 2),
            Transition::new(-983563200, 3),
            Transition::new(-973198800, 2),
            Transition::new(-952027200, 3),
            Transition::new(-941576400, 2),
            Transition::new(-931032000, 3),
            Transition::new(-900882000, 2),
            Transition::new(-890337600, 3),
            Transition::new(-833749200, 2),
            Transition::new(-827265600, 3),
            Transition::new(-752274000, 2),
            Transition::new(-733780800, 3),
            Transition::new(-197326800, 2),
            Transition::new(-190843200, 3),
            Transition::new(-184194000, 2),
            Transition::new(-164491200, 3),
            Transition::new(-152658000, 2),
            Transition::new(-132955200, 3),
            Transition::new(-121122000, 2),
            Transition::new(-101419200, 3),
            Transition::new(-86821200, 2),
            Transition::new(-71092800, 3),
            Transition::new(-54766800, 2),
            Transition::new(-39038400, 3),
            Transition::new(-23317200, 2),
            Transition::new(-7588800, 5),
            Transition::new(128142000, 4),
            Transition::new(136605600, 5),
            Transition::new(596948400, 4),
            Transition::new(605066400, 5),
            Transition::new(624423600, 4),
            Transition::new(636516000, 5),
            Transition::new(656478000, 4),
            Transition::new(667965600, 2),
            Transition::new(687931200, 4),
            Transition::new(699415200, 5),
            Transition::new(719377200, 4),
            Transition::new(731469600, 5),
            Transition::new(938919600, 3),
            Transition::new(952052400, 5),
            Transition::new(1086058800, 2),
            Transition::new(1087704000, 5),
            Transition::new(1198983600, 4),
            Transition::new(1205632800, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-15788, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-15408, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CAYENNE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1846269040, 1),
            Transition::new(-71092800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-12560, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CAYMAN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524502068, 1),
            Transition::new(-1827687170, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-19532, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18430, false, Some(b"KMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CHICAGO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2717647200, 2),
            Transition::new(-1633276800, 1),
            Transition::new(-1615136400, 2),
            Transition::new(-1601827200, 1),
            Transition::new(-1583686800, 2),
            Transition::new(-1563724800, 1),
            Transition::new(-1551632400, 2),
            Transition::new(-1538928000, 1),
            Transition::new(-1520182800, 2),
            Transition::new(-1504454400, 1),
            Transition::new(-1491757200, 2),
            Transition::new(-1473004800, 1),
            Transition::new(-1459702800, 2),
            Transition::new(-1441555200, 1),
            Transition::new(-1428253200, 2),
            Transition::new(-1410105600, 1),
            Transition::new(-1396803600, 2),
            Transition::new(-1378656000, 1),
            Transition::new(-1365354000, 2),
            Transition::new(-1347206400, 1),
            Transition::new(-1333904400, 2),
            Transition::new(-1315152000, 1),
            Transition::new(-1301850000, 2),
            Transition::new(-1283702400, 1),
            Transition::new(-1270400400, 2),
            Transition::new(-1252252800, 1),
            Transition::new(-1238950800, 2),
            Transition::new(-1220803200, 1),
            Transition::new(-1207501200, 2),
            Transition::new(-1189353600, 1),
            Transition::new(-1176051600, 2),
            Transition::new(-1157299200, 1),
            Transition::new(-1144602000, 2),
            Transition::new(-1125849600, 1),
            Transition::new(-1112547600, 2),
            Transition::new(-1094400000, 1),
            Transition::new(-1081098000, 2),
            Transition::new(-1067788800, 3),
            Transition::new(-1045414800, 2),
            Transition::new(-1031500800, 1),
            Transition::new(-1018198800, 2),
            Transition::new(-1000051200, 1),
            Transition::new(-986749200, 2),
            Transition::new(-967996800, 1),
            Transition::new(-955299600, 2),
            Transition::new(-936547200, 1),
            Transition::new(-923245200, 2),
            Transition::new(-905097600, 1),
            Transition::new(-891795600, 2),
            Transition::new(-880214400, 4),
            Transition::new(-769395600, 5),
            Transition::new(-765392400, 2),
            Transition::new(-747244800, 1),
            Transition::new(-733942800, 2),
            Transition::new(-715795200, 1),
            Transition::new(-702493200, 2),
            Transition::new(-684345600, 1),
            Transition::new(-671043600, 2),
            Transition::new(-652896000, 1),
            Transition::new(-639594000, 2),
            Transition::new(-620841600, 1),
            Transition::new(-608144400, 2),
            Transition::new(-589392000, 1),
            Transition::new(-576090000, 2),
            Transition::new(-557942400, 1),
            Transition::new(-544640400, 2),
            Transition::new(-526492800, 1),
            Transition::new(-513190800, 2),
            Transition::new(-495043200, 1),
            Transition::new(-481741200, 2),
            Transition::new(-463593600, 1),
            Transition::new(-447267600, 2),
            Transition::new(-431539200, 1),
            Transition::new(-415818000, 2),
            Transition::new(-400089600, 1),
            Transition::new(-384368400, 2),
            Transition::new(-368640000, 1),
            Transition::new(-352918800, 2),
            Transition::new(-337190400, 1),
            Transition::new(-321469200, 2),
            Transition::new(-305740800, 1),
            Transition::new(-289414800, 2),
            Transition::new(-273686400, 1),
            Transition::new(-257965200, 2),
            Transition::new(-242236800, 1),
            Transition::new(-226515600, 2),
            Transition::new(-210787200, 1),
            Transition::new(-195066000, 2),
            Transition::new(-179337600, 1),
            Transition::new(-163616400, 2),
            Transition::new(-147888000, 1),
            Transition::new(-131562000, 2),
            Transition::new(-116438400, 1),
            Transition::new(-100112400, 2),
            Transition::new(-84384000, 1),
            Transition::new(-68662800, 2),
            Transition::new(-52934400, 1),
            Transition::new(-37213200, 2),
            Transition::new(-21484800, 1),
            Transition::new(-5763600, 2),
            Transition::new(9964800, 1),
            Transition::new(25686000, 2),
            Transition::new(41414400, 1),
            Transition::new(57740400, 2),
            Transition::new(73468800, 1),
            Transition::new(89190000, 2),
            Transition::new(104918400, 1),
            Transition::new(120639600, 2),
            Transition::new(126691200, 1),
            Transition::new(152089200, 2),
            Transition::new(162374400, 1),
            Transition::new(183538800, 2),
            Transition::new(199267200, 1),
            Transition::new(215593200, 2),
            Transition::new(230716800, 1),
            Transition::new(247042800, 2),
            Transition::new(262771200, 1),
            Transition::new(278492400, 2),
            Transition::new(294220800, 1),
            Transition::new(309942000, 2),
            Transition::new(325670400, 1),
            Transition::new(341391600, 2),
            Transition::new(357120000, 1),
            Transition::new(372841200, 2),
            Transition::new(388569600, 1),
            Transition::new(404895600, 2),
            Transition::new(420019200, 1),
            Transition::new(436345200, 2),
            Transition::new(452073600, 1),
            Transition::new(467794800, 2),
            Transition::new(483523200, 1),
            Transition::new(499244400, 2),
            Transition::new(514972800, 1),
            Transition::new(530694000, 2),
            Transition::new(544608000, 1),
            Transition::new(562143600, 2),
            Transition::new(576057600, 1),
            Transition::new(594198000, 2),
            Transition::new(607507200, 1),
            Transition::new(625647600, 2),
            Transition::new(638956800, 1),
            Transition::new(657097200, 2),
            Transition::new(671011200, 1),
            Transition::new(688546800, 2),
            Transition::new(702460800, 1),
            Transition::new(719996400, 2),
            Transition::new(733910400, 1),
            Transition::new(752050800, 2),
            Transition::new(765360000, 1),
            Transition::new(783500400, 2),
            Transition::new(796809600, 1),
            Transition::new(814950000, 2),
            Transition::new(828864000, 1),
            Transition::new(846399600, 2),
            Transition::new(860313600, 1),
            Transition::new(877849200, 2),
            Transition::new(891763200, 1),
            Transition::new(909298800, 2),
            Transition::new(923212800, 1),
            Transition::new(941353200, 2),
            Transition::new(954662400, 1),
            Transition::new(972802800, 2),
            Transition::new(986112000, 1),
            Transition::new(1004252400, 2),
            Transition::new(1018166400, 1),
            Transition::new(1035702000, 2),
            Transition::new(1049616000, 1),
            Transition::new(1067151600, 2),
            Transition::new(1081065600, 1),
            Transition::new(1099206000, 2),
            Transition::new(1112515200, 1),
            Transition::new(1130655600, 2),
            Transition::new(1143964800, 1),
            Transition::new(1162105200, 2),
            Transition::new(1173600000, 1),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-21036, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CHIHUAHUA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514739600, 1),
            Transition::new(-1343066400, 2),
            Transition::new(-1234807200, 1),
            Transition::new(-1220292000, 2),
            Transition::new(-1207159200, 1),
            Transition::new(-1191344400, 2),
            Transition::new(828864000, 3),
            Transition::new(846399600, 2),
            Transition::new(860313600, 3),
            Transition::new(877849200, 2),
            Transition::new(891766800, 4),
            Transition::new(909302400, 1),
            Transition::new(923216400, 4),
            Transition::new(941356800, 1),
            Transition::new(954666000, 4),
            Transition::new(972806400, 1),
            Transition::new(989139600, 4),
            Transition::new(1001836800, 1),
            Transition::new(1018170000, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-25460, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CORAL_HARBOUR: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713890440, 2),
            Transition::new(-1632070800, 1),
            Transition::new(-1615140000, 2),
            Transition::new(-1596992400, 1),
            Transition::new(-1583179200, 2),
            Transition::new(-880218000, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765396000, 2),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-19960, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CORDOBA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2372096592, 1),
            Transition::new(-1567453392, 2),
            Transition::new(-1233432000, 3),
            Transition::new(-1222981200, 2),
            Transition::new(-1205956800, 3),
            Transition::new(-1194037200, 2),
            Transition::new(-1172865600, 3),
            Transition::new(-1162501200, 2),
            Transition::new(-1141329600, 3),
            Transition::new(-1130965200, 2),
            Transition::new(-1109793600, 3),
            Transition::new(-1099429200, 2),
            Transition::new(-1078257600, 3),
            Transition::new(-1067806800, 2),
            Transition::new(-1046635200, 3),
            Transition::new(-1036270800, 2),
            Transition::new(-1015099200, 3),
            Transition::new(-1004734800, 2),
            Transition::new(-983563200, 3),
            Transition::new(-973198800, 2),
            Transition::new(-952027200, 3),
            Transition::new(-941576400, 2),
            Transition::new(-931032000, 3),
            Transition::new(-900882000, 2),
            Transition::new(-890337600, 3),
            Transition::new(-833749200, 2),
            Transition::new(-827265600, 3),
            Transition::new(-752274000, 2),
            Transition::new(-733780800, 3),
            Transition::new(-197326800, 2),
            Transition::new(-190843200, 3),
            Transition::new(-184194000, 2),
            Transition::new(-164491200, 3),
            Transition::new(-152658000, 2),
            Transition::new(-132955200, 3),
            Transition::new(-121122000, 2),
            Transition::new(-101419200, 3),
            Transition::new(-86821200, 2),
            Transition::new(-71092800, 3),
            Transition::new(-54766800, 2),
            Transition::new(-39038400, 3),
            Transition::new(-23317200, 2),
            Transition::new(-7588800, 5),
            Transition::new(128142000, 4),
            Transition::new(136605600, 5),
            Transition::new(596948400, 4),
            Transition::new(605066400, 5),
            Transition::new(624423600, 4),
            Transition::new(636516000, 5),
            Transition::new(656478000, 4),
            Transition::new(667965600, 2),
            Transition::new(687931200, 4),
            Transition::new(699415200, 5),
            Transition::new(719377200, 4),
            Transition::new(731469600, 5),
            Transition::new(938919600, 3),
            Transition::new(952052400, 5),
            Transition::new(1198983600, 4),
            Transition::new(1205632800, 5),
            Transition::new(1224385200, 4),
            Transition::new(1237082400, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-15408, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-15408, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_COSTA_RICA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524501427, 1),
            Transition::new(-1545071027, 3),
            Transition::new(288770400, 2),
            Transition::new(297234000, 3),
            Transition::new(320220000, 2),
            Transition::new(328683600, 3),
            Transition::new(664264800, 2),
            Transition::new(678344400, 3),
            Transition::new(695714400, 2),
            Transition::new(700635600, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-20173, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-20173, false, Some(b"SJMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CRESTON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713882436, 1),
            Transition::new(-1680454800, 2),
            Transition::new(-1627833600, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-27964, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CUIABA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767212140, 2),
            Transition::new(-1206954000, 1),
            Transition::new(-1191358800, 2),
            Transition::new(-1175371200, 1),
            Transition::new(-1159822800, 2),
            Transition::new(-633816000, 1),
            Transition::new(-622065600, 2),
            Transition::new(-602280000, 1),
            Transition::new(-591829200, 2),
            Transition::new(-570744000, 1),
            Transition::new(-560206800, 2),
            Transition::new(-539121600, 1),
            Transition::new(-531349200, 2),
            Transition::new(-191361600, 1),
            Transition::new(-184194000, 2),
            Transition::new(-155160000, 1),
            Transition::new(-150066000, 2),
            Transition::new(-128894400, 1),
            Transition::new(-121122000, 2),
            Transition::new(-99950400, 1),
            Transition::new(-89586000, 2),
            Transition::new(-68414400, 1),
            Transition::new(-57963600, 2),
            Transition::new(499752000, 1),
            Transition::new(511239600, 2),
            Transition::new(530596800, 1),
            Transition::new(540270000, 2),
            Transition::new(562132800, 1),
            Transition::new(571201200, 2),
            Transition::new(592977600, 1),
            Transition::new(602046000, 2),
            Transition::new(624427200, 1),
            Transition::new(634705200, 2),
            Transition::new(656481600, 1),
            Transition::new(666759600, 2),
            Transition::new(687931200, 1),
            Transition::new(697604400, 2),
            Transition::new(719985600, 1),
            Transition::new(728449200, 2),
            Transition::new(750830400, 1),
            Transition::new(761713200, 2),
            Transition::new(782280000, 1),
            Transition::new(793162800, 2),
            Transition::new(813729600, 1),
            Transition::new(824007600, 2),
            Transition::new(844574400, 1),
            Transition::new(856062000, 2),
            Transition::new(876110400, 1),
            Transition::new(888721200, 2),
            Transition::new(908078400, 1),
            Transition::new(919566000, 2),
            Transition::new(938923200, 1),
            Transition::new(951620400, 2),
            Transition::new(970977600, 1),
            Transition::new(982465200, 2),
            Transition::new(1003032000, 1),
            Transition::new(1013914800, 2),
            Transition::new(1036296000, 1),
            Transition::new(1045364400, 2),
            Transition::new(1099368000, 1),
            Transition::new(1108868400, 2),
            Transition::new(1129435200, 1),
            Transition::new(1140318000, 2),
            Transition::new(1162699200, 1),
            Transition::new(1172372400, 2),
            Transition::new(1192334400, 1),
            Transition::new(1203217200, 2),
            Transition::new(1224388800, 1),
            Transition::new(1234666800, 2),
            Transition::new(1255838400, 1),
            Transition::new(1266721200, 2),
            Transition::new(1287288000, 1),
            Transition::new(1298170800, 2),
            Transition::new(1318737600, 1),
            Transition::new(1330225200, 2),
            Transition::new(1350792000, 1),
            Transition::new(1361070000, 2),
            Transition::new(1382241600, 1),
            Transition::new(1392519600, 2),
            Transition::new(1413691200, 1),
            Transition::new(1424574000, 2),
            Transition::new(1445140800, 1),
            Transition::new(1456023600, 2),
            Transition::new(1476590400, 1),
            Transition::new(1487473200, 2),
            Transition::new(1508040000, 1),
            Transition::new(1518922800, 2),
            Transition::new(1541304000, 1),
            Transition::new(1550372400, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-13460, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CURACAO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1826738653, 1),
            Transition::new(-157750200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-16547, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-16200, false, Some(b"-0430")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_DANMARKSHAVN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1686091520, 1),
            Transition::new(323845200, 2),
            Transition::new(338950800, 1),
            Transition::new(354675600, 2),
            Transition::new(370400400, 1),
            Transition::new(386125200, 2),
            Transition::new(401850000, 1),
            Transition::new(417574800, 2),
            Transition::new(433299600, 1),
            Transition::new(449024400, 2),
            Transition::new(465354000, 1),
            Transition::new(481078800, 2),
            Transition::new(496803600, 1),
            Transition::new(512528400, 2),
            Transition::new(528253200, 1),
            Transition::new(543978000, 2),
            Transition::new(559702800, 1),
            Transition::new(575427600, 2),
            Transition::new(591152400, 1),
            Transition::new(606877200, 2),
            Transition::new(622602000, 1),
            Transition::new(638326800, 2),
            Transition::new(654656400, 1),
            Transition::new(670381200, 2),
            Transition::new(686106000, 1),
            Transition::new(701830800, 2),
            Transition::new(717555600, 1),
            Transition::new(733280400, 2),
            Transition::new(749005200, 1),
            Transition::new(764730000, 2),
            Transition::new(780454800, 1),
            Transition::new(796179600, 2),
            Transition::new(811904400, 1),
            Transition::new(820465200, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-4480, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_DAWSON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2188996940, 2),
            Transition::new(-1632056400, 1),
            Transition::new(-1615125600, 2),
            Transition::new(-1596978000, 1),
            Transition::new(-1583164800, 2),
            Transition::new(-880203600, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765381600, 2),
            Transition::new(-147884400, 5),
            Transition::new(-131554800, 2),
            Transition::new(120646800, 6),
            Transition::new(325677600, 7),
            Transition::new(341398800, 6),
            Transition::new(357127200, 7),
            Transition::new(372848400, 6),
            Transition::new(388576800, 7),
            Transition::new(404902800, 6),
            Transition::new(420026400, 7),
            Transition::new(436352400, 6),
            Transition::new(452080800, 7),
            Transition::new(467802000, 6),
            Transition::new(483530400, 7),
            Transition::new(499251600, 6),
            Transition::new(514980000, 7),
            Transition::new(530701200, 6),
            Transition::new(544615200, 7),
            Transition::new(562150800, 6),
            Transition::new(576064800, 7),
            Transition::new(594205200, 6),
            Transition::new(607514400, 7),
            Transition::new(625654800, 6),
            Transition::new(638964000, 7),
            Transition::new(657104400, 6),
            Transition::new(671018400, 7),
            Transition::new(688554000, 6),
            Transition::new(702468000, 7),
            Transition::new(720003600, 6),
            Transition::new(733917600, 7),
            Transition::new(752058000, 6),
            Transition::new(765367200, 7),
            Transition::new(783507600, 6),
            Transition::new(796816800, 7),
            Transition::new(814957200, 6),
            Transition::new(828871200, 7),
            Transition::new(846406800, 6),
            Transition::new(860320800, 7),
            Transition::new(877856400, 6),
            Transition::new(891770400, 7),
            Transition::new(909306000, 6),
            Transition::new(923220000, 7),
            Transition::new(941360400, 6),
            Transition::new(954669600, 7),
            Transition::new(972810000, 6),
            Transition::new(986119200, 7),
            Transition::new(1004259600, 6),
            Transition::new(1018173600, 7),
            Transition::new(1035709200, 6),
            Transition::new(1049623200, 7),
            Transition::new(1067158800, 6),
            Transition::new(1081072800, 7),
            Transition::new(1099213200, 6),
            Transition::new(1112522400, 7),
            Transition::new(1130662800, 6),
            Transition::new(1143972000, 7),
            Transition::new(1162112400, 6),
            Transition::new(1173607200, 7),
            Transition::new(1194166800, 6),
            Transition::new(1205056800, 7),
            Transition::new(1225616400, 6),
            Transition::new(1236506400, 7),
            Transition::new(1257066000, 6),
            Transition::new(1268560800, 7),
            Transition::new(1289120400, 6),
            Transition::new(1300010400, 7),
            Transition::new(1320570000, 6),
            Transition::new(1331460000, 7),
            Transition::new(1352019600, 6),
            Transition::new(1362909600, 7),
            Transition::new(1383469200, 6),
            Transition::new(1394359200, 7),
            Transition::new(1414918800, 6),
            Transition::new(1425808800, 7),
            Transition::new(1446368400, 6),
            Transition::new(1457863200, 7),
            Transition::new(1478422800, 6),
            Transition::new(1489312800, 7),
            Transition::new(1509872400, 6),
            Transition::new(1520762400, 7),
            Transition::new(1541322000, 6),
            Transition::new(1552212000, 7),
            Transition::new(1572771600, 6),
            Transition::new(1583661600, 7),
            Transition::new(1604214000, 8),
        ],
        &{
            const V: [LocalTimeType; 9] = [
                match LocalTimeType::new(-33460, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"YST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"YDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_DAWSON_CREEK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713881544, 2),
            Transition::new(-1632060000, 1),
            Transition::new(-1615129200, 2),
            Transition::new(-880207200, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765385200, 2),
            Transition::new(-715788000, 1),
            Transition::new(-702486000, 2),
            Transition::new(-684338400, 1),
            Transition::new(-671036400, 2),
            Transition::new(-652888800, 1),
            Transition::new(-639586800, 2),
            Transition::new(-620834400, 1),
            Transition::new(-608137200, 2),
            Transition::new(-589384800, 1),
            Transition::new(-576082800, 2),
            Transition::new(-557935200, 1),
            Transition::new(-544633200, 2),
            Transition::new(-526485600, 1),
            Transition::new(-513183600, 2),
            Transition::new(-495036000, 1),
            Transition::new(-481734000, 2),
            Transition::new(-463586400, 1),
            Transition::new(-450284400, 2),
            Transition::new(-431532000, 1),
            Transition::new(-418230000, 2),
            Transition::new(-400082400, 1),
            Transition::new(-386780400, 2),
            Transition::new(-368632800, 1),
            Transition::new(-355330800, 2),
            Transition::new(-337183200, 1),
            Transition::new(-323881200, 2),
            Transition::new(-305733600, 1),
            Transition::new(-292431600, 2),
            Transition::new(-273679200, 1),
            Transition::new(-260982000, 2),
            Transition::new(-242229600, 1),
            Transition::new(-226508400, 2),
            Transition::new(-210780000, 1),
            Transition::new(-195058800, 2),
            Transition::new(-179330400, 1),
            Transition::new(-163609200, 2),
            Transition::new(-147880800, 1),
            Transition::new(-131554800, 2),
            Transition::new(-116431200, 1),
            Transition::new(-100105200, 2),
            Transition::new(-84376800, 1),
            Transition::new(-68655600, 2),
            Transition::new(-52927200, 1),
            Transition::new(-37206000, 2),
            Transition::new(-21477600, 1),
            Transition::new(-5756400, 2),
            Transition::new(9972000, 1),
            Transition::new(25693200, 2),
            Transition::new(41421600, 1),
            Transition::new(57747600, 2),
            Transition::new(73476000, 1),
            Transition::new(84013200, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-28856, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_DETROIT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2051202469, 1),
            Transition::new(-1724083200, 2),
            Transition::new(-880218000, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765396000, 2),
            Transition::new(-684349200, 5),
            Transition::new(-671047200, 2),
            Transition::new(-80506740, 5),
            Transition::new(-68666400, 2),
            Transition::new(-52938000, 5),
            Transition::new(-37216800, 2),
            Transition::new(104914800, 5),
            Transition::new(120636000, 2),
            Transition::new(126687600, 5),
            Transition::new(152085600, 2),
            Transition::new(167814000, 5),
            Transition::new(183535200, 2),
            Transition::new(199263600, 5),
            Transition::new(215589600, 2),
            Transition::new(230713200, 5),
            Transition::new(247039200, 2),
            Transition::new(262767600, 5),
            Transition::new(278488800, 2),
            Transition::new(294217200, 5),
            Transition::new(309938400, 2),
            Transition::new(325666800, 5),
            Transition::new(341388000, 2),
            Transition::new(357116400, 5),
            Transition::new(372837600, 2),
            Transition::new(388566000, 5),
            Transition::new(404892000, 2),
            Transition::new(420015600, 5),
            Transition::new(436341600, 2),
            Transition::new(452070000, 5),
            Transition::new(467791200, 2),
            Transition::new(483519600, 5),
            Transition::new(499240800, 2),
            Transition::new(514969200, 5),
            Transition::new(530690400, 2),
            Transition::new(544604400, 5),
            Transition::new(562140000, 2),
            Transition::new(576054000, 5),
            Transition::new(594194400, 2),
            Transition::new(607503600, 5),
            Transition::new(625644000, 2),
            Transition::new(638953200, 5),
            Transition::new(657093600, 2),
            Transition::new(671007600, 5),
            Transition::new(688543200, 2),
            Transition::new(702457200, 5),
            Transition::new(719992800, 2),
            Transition::new(733906800, 5),
            Transition::new(752047200, 2),
            Transition::new(765356400, 5),
            Transition::new(783496800, 2),
            Transition::new(796806000, 5),
            Transition::new(814946400, 2),
            Transition::new(828860400, 5),
            Transition::new(846396000, 2),
            Transition::new(860310000, 5),
            Transition::new(877845600, 2),
            Transition::new(891759600, 5),
            Transition::new(909295200, 2),
            Transition::new(923209200, 5),
            Transition::new(941349600, 2),
            Transition::new(954658800, 5),
            Transition::new(972799200, 2),
            Transition::new(986108400, 5),
            Transition::new(1004248800, 2),
            Transition::new(1018162800, 5),
            Transition::new(1035698400, 2),
            Transition::new(1049612400, 5),
            Transition::new(1067148000, 2),
            Transition::new(1081062000, 5),
            Transition::new(1099202400, 2),
            Transition::new(1112511600, 5),
            Transition::new(1130652000, 2),
            Transition::new(1143961200, 5),
            Transition::new(1162101600, 2),
            Transition::new(1173596400, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-19931, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_DOMINICA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1846266804, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(-14736, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_EDMONTON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1998663968, 2),
            Transition::new(-1632063600, 1),
            Transition::new(-1615132800, 2),
            Transition::new(-1600614000, 1),
            Transition::new(-1596816000, 2),
            Transition::new(-1567954800, 1),
            Transition::new(-1551628800, 2),
            Transition::new(-1536505200, 1),
            Transition::new(-1523203200, 2),
            Transition::new(-1504450800, 1),
            Transition::new(-1491753600, 2),
            Transition::new(-1473001200, 1),
            Transition::new(-1459699200, 2),
            Transition::new(-880210800, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765388800, 2),
            Transition::new(-715791600, 1),
            Transition::new(-702489600, 2),
            Transition::new(73472400, 1),
            Transition::new(89193600, 2),
            Transition::new(104922000, 1),
            Transition::new(120643200, 2),
            Transition::new(136371600, 1),
            Transition::new(152092800, 2),
            Transition::new(167821200, 1),
            Transition::new(183542400, 2),
            Transition::new(199270800, 1),
            Transition::new(215596800, 2),
            Transition::new(230720400, 1),
            Transition::new(247046400, 2),
            Transition::new(262774800, 1),
            Transition::new(278496000, 2),
            Transition::new(294224400, 1),
            Transition::new(309945600, 2),
            Transition::new(325674000, 1),
            Transition::new(341395200, 2),
            Transition::new(357123600, 1),
            Transition::new(372844800, 2),
            Transition::new(388573200, 1),
            Transition::new(404899200, 2),
            Transition::new(420022800, 1),
            Transition::new(436348800, 2),
            Transition::new(452077200, 1),
            Transition::new(467798400, 2),
            Transition::new(483526800, 1),
            Transition::new(499248000, 2),
            Transition::new(514976400, 1),
            Transition::new(530697600, 2),
            Transition::new(544611600, 1),
            Transition::new(562147200, 2),
            Transition::new(576061200, 1),
            Transition::new(594201600, 2),
            Transition::new(607510800, 1),
            Transition::new(625651200, 2),
            Transition::new(638960400, 1),
            Transition::new(657100800, 2),
            Transition::new(671014800, 1),
            Transition::new(688550400, 2),
            Transition::new(702464400, 1),
            Transition::new(720000000, 2),
            Transition::new(733914000, 1),
            Transition::new(752054400, 2),
            Transition::new(765363600, 1),
            Transition::new(783504000, 2),
            Transition::new(796813200, 1),
            Transition::new(814953600, 2),
            Transition::new(828867600, 1),
            Transition::new(846403200, 2),
            Transition::new(860317200, 1),
            Transition::new(877852800, 2),
            Transition::new(891766800, 1),
            Transition::new(909302400, 2),
            Transition::new(923216400, 1),
            Transition::new(941356800, 2),
            Transition::new(954666000, 1),
            Transition::new(972806400, 2),
            Transition::new(986115600, 1),
            Transition::new(1004256000, 2),
            Transition::new(1018170000, 1),
            Transition::new(1035705600, 2),
            Transition::new(1049619600, 1),
            Transition::new(1067155200, 2),
            Transition::new(1081069200, 1),
            Transition::new(1099209600, 2),
            Transition::new(1112518800, 1),
            Transition::new(1130659200, 2),
            Transition::new(1143968400, 1),
            Transition::new(1162108800, 2),
            Transition::new(1173603600, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-27232, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_EIRUNEPE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767208832, 2),
            Transition::new(-1206950400, 1),
            Transition::new(-1191355200, 2),
            Transition::new(-1175367600, 1),
            Transition::new(-1159819200, 2),
            Transition::new(-633812400, 1),
            Transition::new(-622062000, 2),
            Transition::new(-602276400, 1),
            Transition::new(-591825600, 2),
            Transition::new(-570740400, 1),
            Transition::new(-560203200, 2),
            Transition::new(-539118000, 1),
            Transition::new(-531345600, 2),
            Transition::new(-191358000, 1),
            Transition::new(-184190400, 2),
            Transition::new(-155156400, 1),
            Transition::new(-150062400, 2),
            Transition::new(-128890800, 1),
            Transition::new(-121118400, 2),
            Transition::new(-99946800, 1),
            Transition::new(-89582400, 2),
            Transition::new(-68410800, 1),
            Transition::new(-57960000, 2),
            Transition::new(499755600, 1),
            Transition::new(511243200, 2),
            Transition::new(530600400, 1),
            Transition::new(540273600, 2),
            Transition::new(562136400, 1),
            Transition::new(571204800, 2),
            Transition::new(750834000, 1),
            Transition::new(761716800, 2),
            Transition::new(1214283600, 3),
            Transition::new(1384056000, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-16768, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_EL_SALVADOR: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1546279392, 2),
            Transition::new(547020000, 1),
            Transition::new(559717200, 2),
            Transition::new(578469600, 1),
            Transition::new(591166800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-21408, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ENSENADA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514736000, 1),
            Transition::new(-1343062800, 2),
            Transition::new(-1234717200, 1),
            Transition::new(-875808000, 2),
            Transition::new(-661539600, 1),
            Transition::new(828871200, 3),
            Transition::new(846406800, 1),
            Transition::new(860320800, 3),
            Transition::new(877856400, 1),
            Transition::new(891770400, 3),
            Transition::new(909306000, 1),
            Transition::new(923220000, 3),
            Transition::new(941360400, 1),
            Transition::new(954669600, 3),
            Transition::new(972810000, 1),
            Transition::new(989143200, 3),
            Transition::new(1001840400, 1),
            Transition::new(1018173600, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-27988, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-28800, false, Some(b"PST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_FORTALEZA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767216360, 2),
            Transition::new(-1206957600, 1),
            Transition::new(-1191362400, 2),
            Transition::new(-1175374800, 1),
            Transition::new(-1159826400, 2),
            Transition::new(-633819600, 1),
            Transition::new(-622069200, 2),
            Transition::new(-602283600, 1),
            Transition::new(-591832800, 2),
            Transition::new(-570747600, 1),
            Transition::new(-560210400, 2),
            Transition::new(-539125200, 1),
            Transition::new(-531352800, 2),
            Transition::new(-191365200, 1),
            Transition::new(-184197600, 2),
            Transition::new(-155163600, 1),
            Transition::new(-150069600, 2),
            Transition::new(-128898000, 1),
            Transition::new(-121125600, 2),
            Transition::new(-99954000, 1),
            Transition::new(-89589600, 2),
            Transition::new(-68418000, 1),
            Transition::new(-57967200, 2),
            Transition::new(499748400, 1),
            Transition::new(511236000, 2),
            Transition::new(530593200, 1),
            Transition::new(540266400, 2),
            Transition::new(562129200, 1),
            Transition::new(571197600, 2),
            Transition::new(592974000, 1),
            Transition::new(602042400, 2),
            Transition::new(624423600, 1),
            Transition::new(634701600, 2),
            Transition::new(938919600, 1),
            Transition::new(951616800, 2),
            Transition::new(970974000, 1),
            Transition::new(972180000, 2),
            Transition::new(1003028400, 1),
            Transition::new(1013911200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-9240, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_FORT_NELSON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713880953, 2),
            Transition::new(-1632060000, 1),
            Transition::new(-1615129200, 2),
            Transition::new(-880207200, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765385200, 2),
            Transition::new(-715788000, 1),
            Transition::new(-702486000, 2),
            Transition::new(-684338400, 1),
            Transition::new(-671036400, 2),
            Transition::new(-652888800, 1),
            Transition::new(-639586800, 2),
            Transition::new(-620834400, 1),
            Transition::new(-608137200, 2),
            Transition::new(-589384800, 1),
            Transition::new(-576082800, 2),
            Transition::new(-557935200, 1),
            Transition::new(-544633200, 2),
            Transition::new(-526485600, 1),
            Transition::new(-513183600, 2),
            Transition::new(-495036000, 1),
            Transition::new(-481734000, 2),
            Transition::new(-463586400, 1),
            Transition::new(-450284400, 2),
            Transition::new(-431532000, 1),
            Transition::new(-418230000, 2),
            Transition::new(-400082400, 1),
            Transition::new(-386780400, 2),
            Transition::new(-368632800, 1),
            Transition::new(-355330800, 2),
            Transition::new(-337183200, 1),
            Transition::new(-323881200, 2),
            Transition::new(-305733600, 1),
            Transition::new(-292431600, 2),
            Transition::new(-273679200, 1),
            Transition::new(-260982000, 2),
            Transition::new(-242229600, 1),
            Transition::new(-226508400, 2),
            Transition::new(-210780000, 1),
            Transition::new(-195058800, 2),
            Transition::new(-179330400, 1),
            Transition::new(-163609200, 2),
            Transition::new(-147880800, 1),
            Transition::new(-131554800, 2),
            Transition::new(-116431200, 1),
            Transition::new(-100105200, 2),
            Transition::new(-84376800, 1),
            Transition::new(-68655600, 2),
            Transition::new(-52927200, 1),
            Transition::new(-37206000, 2),
            Transition::new(-21477600, 1),
            Transition::new(-5756400, 2),
            Transition::new(9972000, 1),
            Transition::new(25693200, 2),
            Transition::new(41421600, 1),
            Transition::new(57747600, 2),
            Transition::new(73476000, 1),
            Transition::new(89197200, 2),
            Transition::new(104925600, 1),
            Transition::new(120646800, 2),
            Transition::new(136375200, 1),
            Transition::new(152096400, 2),
            Transition::new(167824800, 1),
            Transition::new(183546000, 2),
            Transition::new(199274400, 1),
            Transition::new(215600400, 2),
            Transition::new(230724000, 1),
            Transition::new(247050000, 2),
            Transition::new(262778400, 1),
            Transition::new(278499600, 2),
            Transition::new(294228000, 1),
            Transition::new(309949200, 2),
            Transition::new(325677600, 1),
            Transition::new(341398800, 2),
            Transition::new(357127200, 1),
            Transition::new(372848400, 2),
            Transition::new(388576800, 1),
            Transition::new(404902800, 2),
            Transition::new(420026400, 1),
            Transition::new(436352400, 2),
            Transition::new(452080800, 1),
            Transition::new(467802000, 2),
            Transition::new(483530400, 1),
            Transition::new(499251600, 2),
            Transition::new(514980000, 1),
            Transition::new(530701200, 2),
            Transition::new(544615200, 1),
            Transition::new(562150800, 2),
            Transition::new(576064800, 1),
            Transition::new(594205200, 2),
            Transition::new(607514400, 1),
            Transition::new(625654800, 2),
            Transition::new(638964000, 1),
            Transition::new(657104400, 2),
            Transition::new(671018400, 1),
            Transition::new(688554000, 2),
            Transition::new(702468000, 1),
            Transition::new(720003600, 2),
            Transition::new(733917600, 1),
            Transition::new(752058000, 2),
            Transition::new(765367200, 1),
            Transition::new(783507600, 2),
            Transition::new(796816800, 1),
            Transition::new(814957200, 2),
            Transition::new(828871200, 1),
            Transition::new(846406800, 2),
            Transition::new(860320800, 1),
            Transition::new(877856400, 2),
            Transition::new(891770400, 1),
            Transition::new(909306000, 2),
            Transition::new(923220000, 1),
            Transition::new(941360400, 2),
            Transition::new(954669600, 1),
            Transition::new(972810000, 2),
            Transition::new(986119200, 1),
            Transition::new(1004259600, 2),
            Transition::new(1018173600, 1),
            Transition::new(1035709200, 2),
            Transition::new(1049623200, 1),
            Transition::new(1067158800, 2),
            Transition::new(1081072800, 1),
            Transition::new(1099213200, 2),
            Transition::new(1112522400, 1),
            Transition::new(1130662800, 2),
            Transition::new(1143972000, 1),
            Transition::new(1162112400, 2),
            Transition::new(1173607200, 1),
            Transition::new(1194166800, 2),
            Transition::new(1205056800, 1),
            Transition::new(1225616400, 2),
            Transition::new(1236506400, 1),
            Transition::new(1257066000, 2),
            Transition::new(1268560800, 1),
            Transition::new(1289120400, 2),
            Transition::new(1300010400, 1),
            Transition::new(1320570000, 2),
            Transition::new(1331460000, 1),
            Transition::new(1352019600, 2),
            Transition::new(1362909600, 1),
            Transition::new(1383469200, 2),
            Transition::new(1394359200, 1),
            Transition::new(1414918800, 2),
            Transition::new(1425808800, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-29447, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_FORT_WAYNE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2717647200, 2),
            Transition::new(-1633276800, 1),
            Transition::new(-1615136400, 2),
            Transition::new(-1601827200, 1),
            Transition::new(-1583686800, 2),
            Transition::new(-900259200, 1),
            Transition::new(-891795600, 2),
            Transition::new(-880214400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765392400, 2),
            Transition::new(-747244800, 1),
            Transition::new(-733942800, 2),
            Transition::new(-715795200, 1),
            Transition::new(-702493200, 2),
            Transition::new(-684345600, 1),
            Transition::new(-671043600, 2),
            Transition::new(-652896000, 1),
            Transition::new(-639594000, 2),
            Transition::new(-620841600, 1),
            Transition::new(-608144400, 2),
            Transition::new(-589392000, 1),
            Transition::new(-576090000, 2),
            Transition::new(-557942400, 1),
            Transition::new(-544640400, 2),
            Transition::new(-526492800, 1),
            Transition::new(-513190800, 2),
            Transition::new(-495043200, 1),
            Transition::new(-481741200, 2),
            Transition::new(-463593600, 5),
            Transition::new(-386787600, 2),
            Transition::new(-368640000, 5),
            Transition::new(-21488400, 6),
            Transition::new(-5767200, 5),
            Transition::new(9961200, 6),
            Transition::new(25682400, 5),
            Transition::new(1143961200, 6),
            Transition::new(1162101600, 5),
            Transition::new(1173596400, 6),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(-20678, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_GLACE_BAY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2131646412, 2),
            Transition::new(-1632074400, 1),
            Transition::new(-1615143600, 2),
            Transition::new(-880221600, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765399600, 2),
            Transition::new(-526500000, 1),
            Transition::new(-513198000, 2),
            Transition::new(73461600, 1),
            Transition::new(89182800, 2),
            Transition::new(104911200, 1),
            Transition::new(120632400, 2),
            Transition::new(136360800, 1),
            Transition::new(152082000, 2),
            Transition::new(167810400, 1),
            Transition::new(183531600, 2),
            Transition::new(199260000, 1),
            Transition::new(215586000, 2),
            Transition::new(230709600, 1),
            Transition::new(247035600, 2),
            Transition::new(262764000, 1),
            Transition::new(278485200, 2),
            Transition::new(294213600, 1),
            Transition::new(309934800, 2),
            Transition::new(325663200, 1),
            Transition::new(341384400, 2),
            Transition::new(357112800, 1),
            Transition::new(372834000, 2),
            Transition::new(388562400, 1),
            Transition::new(404888400, 2),
            Transition::new(420012000, 1),
            Transition::new(436338000, 2),
            Transition::new(452066400, 1),
            Transition::new(467787600, 2),
            Transition::new(483516000, 1),
            Transition::new(499237200, 2),
            Transition::new(514965600, 1),
            Transition::new(530686800, 2),
            Transition::new(544600800, 1),
            Transition::new(562136400, 2),
            Transition::new(576050400, 1),
            Transition::new(594190800, 2),
            Transition::new(607500000, 1),
            Transition::new(625640400, 2),
            Transition::new(638949600, 1),
            Transition::new(657090000, 2),
            Transition::new(671004000, 1),
            Transition::new(688539600, 2),
            Transition::new(702453600, 1),
            Transition::new(719989200, 2),
            Transition::new(733903200, 1),
            Transition::new(752043600, 2),
            Transition::new(765352800, 1),
            Transition::new(783493200, 2),
            Transition::new(796802400, 1),
            Transition::new(814942800, 2),
            Transition::new(828856800, 1),
            Transition::new(846392400, 2),
            Transition::new(860306400, 1),
            Transition::new(877842000, 2),
            Transition::new(891756000, 1),
            Transition::new(909291600, 2),
            Transition::new(923205600, 1),
            Transition::new(941346000, 2),
            Transition::new(954655200, 1),
            Transition::new(972795600, 2),
            Transition::new(986104800, 1),
            Transition::new(1004245200, 2),
            Transition::new(1018159200, 1),
            Transition::new(1035694800, 2),
            Transition::new(1049608800, 1),
            Transition::new(1067144400, 2),
            Transition::new(1081058400, 1),
            Transition::new(1099198800, 2),
            Transition::new(1112508000, 1),
            Transition::new(1130648400, 2),
            Transition::new(1143957600, 1),
            Transition::new(1162098000, 2),
            Transition::new(1173592800, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-14388, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"AWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"APT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-14400, false, Some(b"AST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_GODTHAB: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1686083584, 1),
            Transition::new(323845200, 2),
            Transition::new(338950800, 1),
            Transition::new(354675600, 2),
            Transition::new(370400400, 1),
            Transition::new(386125200, 2),
            Transition::new(401850000, 1),
            Transition::new(417574800, 2),
            Transition::new(433299600, 1),
            Transition::new(449024400, 2),
            Transition::new(465354000, 1),
            Transition::new(481078800, 2),
            Transition::new(496803600, 1),
            Transition::new(512528400, 2),
            Transition::new(528253200, 1),
            Transition::new(543978000, 2),
            Transition::new(559702800, 1),
            Transition::new(575427600, 2),
            Transition::new(591152400, 1),
            Transition::new(606877200, 2),
            Transition::new(622602000, 1),
            Transition::new(638326800, 2),
            Transition::new(654656400, 1),
            Transition::new(670381200, 2),
            Transition::new(686106000, 1),
            Transition::new(701830800, 2),
            Transition::new(717555600, 1),
            Transition::new(733280400, 2),
            Transition::new(749005200, 1),
            Transition::new(764730000, 2),
            Transition::new(780454800, 1),
            Transition::new(796179600, 2),
            Transition::new(811904400, 1),
            Transition::new(828234000, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-12416, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-10800, false, Some(b"-03")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-7200, true, Some(b"-02")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    -7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    -3600,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_GOOSE_BAY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713895900, 1),
            Transition::new(-1632076148, 2),
            Transition::new(-1615145348, 1),
            Transition::new(-1096921748, 3),
            Transition::new(-1061670600, 4),
            Transition::new(-1048973400, 3),
            Transition::new(-1030221000, 4),
            Transition::new(-1017523800, 3),
            Transition::new(-998771400, 4),
            Transition::new(-986074200, 3),
            Transition::new(-966717000, 4),
            Transition::new(-954624600, 3),
            Transition::new(-935267400, 4),
            Transition::new(-922570200, 3),
            Transition::new(-903817800, 4),
            Transition::new(-891120600, 3),
            Transition::new(-872368200, 6),
            Transition::new(-769395600, 5),
            Transition::new(-765401400, 3),
            Transition::new(-746044200, 4),
            Transition::new(-733347000, 3),
            Transition::new(-714594600, 4),
            Transition::new(-701897400, 3),
            Transition::new(-683145000, 4),
            Transition::new(-670447800, 3),
            Transition::new(-651695400, 4),
            Transition::new(-638998200, 3),
            Transition::new(-619641000, 4),
            Transition::new(-606943800, 3),
            Transition::new(-589401000, 4),
            Transition::new(-576099000, 3),
            Transition::new(-557951400, 4),
            Transition::new(-544649400, 3),
            Transition::new(-526501800, 4),
            Transition::new(-513199800, 3),
            Transition::new(-495052200, 4),
            Transition::new(-481750200, 3),
            Transition::new(-463602600, 4),
            Transition::new(-450300600, 3),
            Transition::new(-431548200, 4),
            Transition::new(-418246200, 3),
            Transition::new(-400098600, 4),
            Transition::new(-386796600, 3),
            Transition::new(-368649000, 4),
            Transition::new(-355347000, 3),
            Transition::new(-337199400, 4),
            Transition::new(-323897400, 3),
            Transition::new(-305749800, 4),
            Transition::new(-289423800, 3),
            Transition::new(-273695400, 4),
            Transition::new(-257974200, 3),
            Transition::new(-242245800, 4),
            Transition::new(-226524600, 3),
            Transition::new(-210796200, 4),
            Transition::new(-195075000, 3),
            Transition::new(-179346600, 4),
            Transition::new(-163625400, 3),
            Transition::new(-147897000, 4),
            Transition::new(-131571000, 3),
            Transition::new(-119903400, 8),
            Transition::new(-116445600, 7),
            Transition::new(-100119600, 8),
            Transition::new(-84391200, 7),
            Transition::new(-68670000, 8),
            Transition::new(-52941600, 7),
            Transition::new(-37220400, 8),
            Transition::new(-21492000, 7),
            Transition::new(-5770800, 8),
            Transition::new(9957600, 7),
            Transition::new(25678800, 8),
            Transition::new(41407200, 7),
            Transition::new(57733200, 8),
            Transition::new(73461600, 7),
            Transition::new(89182800, 8),
            Transition::new(104911200, 7),
            Transition::new(120632400, 8),
            Transition::new(136360800, 7),
            Transition::new(152082000, 8),
            Transition::new(167810400, 7),
            Transition::new(183531600, 8),
            Transition::new(199260000, 7),
            Transition::new(215586000, 8),
            Transition::new(230709600, 7),
            Transition::new(247035600, 8),
            Transition::new(262764000, 7),
            Transition::new(278485200, 8),
            Transition::new(294213600, 7),
            Transition::new(309934800, 8),
            Transition::new(325663200, 7),
            Transition::new(341384400, 8),
            Transition::new(357112800, 7),
            Transition::new(372834000, 8),
            Transition::new(388562400, 7),
            Transition::new(404888400, 8),
            Transition::new(420012000, 7),
            Transition::new(436338000, 8),
            Transition::new(452066400, 7),
            Transition::new(467787600, 8),
            Transition::new(483516000, 7),
            Transition::new(499237200, 8),
            Transition::new(514965600, 7),
            Transition::new(530686800, 8),
            Transition::new(544593660, 7),
            Transition::new(562129260, 8),
            Transition::new(576043260, 9),
            Transition::new(594180060, 8),
            Transition::new(607492860, 7),
            Transition::new(625633260, 8),
            Transition::new(638942460, 7),
            Transition::new(657082860, 8),
            Transition::new(670996860, 7),
            Transition::new(688532460, 8),
            Transition::new(702446460, 7),
            Transition::new(719982060, 8),
            Transition::new(733896060, 7),
            Transition::new(752036460, 8),
            Transition::new(765345660, 7),
            Transition::new(783486060, 8),
            Transition::new(796795260, 7),
            Transition::new(814935660, 8),
            Transition::new(828849660, 7),
            Transition::new(846385260, 8),
            Transition::new(860299260, 7),
            Transition::new(877834860, 8),
            Transition::new(891748860, 7),
            Transition::new(909284460, 8),
            Transition::new(923198460, 7),
            Transition::new(941338860, 8),
            Transition::new(954648060, 7),
            Transition::new(972788460, 8),
            Transition::new(986097660, 7),
            Transition::new(1004238060, 8),
            Transition::new(1018152060, 7),
            Transition::new(1035687660, 8),
            Transition::new(1049601660, 7),
            Transition::new(1067137260, 8),
            Transition::new(1081051260, 7),
            Transition::new(1099191660, 8),
            Transition::new(1112500860, 7),
            Transition::new(1130641260, 8),
            Transition::new(1143950460, 7),
            Transition::new(1162090860, 8),
            Transition::new(1173585660, 7),
            Transition::new(1194145260, 8),
            Transition::new(1205035260, 7),
            Transition::new(1225594860, 8),
            Transition::new(1236484860, 7),
            Transition::new(1257044460, 8),
            Transition::new(1268539260, 7),
            Transition::new(1289098860, 8),
            Transition::new(1299988860, 7),
            Transition::new(1320555600, 8),
        ],
        &{
            const V: [LocalTimeType; 10] = [
                match LocalTimeType::new(-14500, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-12652, false, Some(b"NST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9052, true, Some(b"NDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-12600, false, Some(b"NST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9000, true, Some(b"NDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9000, true, Some(b"NPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9000, true, Some(b"NWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"ADDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-14400, false, Some(b"AST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_GRAND_TURK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524504528, 1),
            Transition::new(-1827687170, 2),
            Transition::new(294217200, 3),
            Transition::new(309938400, 2),
            Transition::new(325666800, 3),
            Transition::new(341388000, 2),
            Transition::new(357116400, 3),
            Transition::new(372837600, 2),
            Transition::new(388566000, 3),
            Transition::new(404892000, 2),
            Transition::new(420015600, 3),
            Transition::new(436341600, 2),
            Transition::new(452070000, 3),
            Transition::new(467791200, 2),
            Transition::new(483519600, 3),
            Transition::new(499240800, 2),
            Transition::new(514969200, 3),
            Transition::new(530690400, 2),
            Transition::new(544604400, 3),
            Transition::new(562140000, 2),
            Transition::new(576054000, 3),
            Transition::new(594194400, 2),
            Transition::new(607503600, 3),
            Transition::new(625644000, 2),
            Transition::new(638953200, 3),
            Transition::new(657093600, 2),
            Transition::new(671007600, 3),
            Transition::new(688543200, 2),
            Transition::new(702457200, 3),
            Transition::new(719992800, 2),
            Transition::new(733906800, 3),
            Transition::new(752047200, 2),
            Transition::new(765356400, 3),
            Transition::new(783496800, 2),
            Transition::new(796806000, 3),
            Transition::new(814946400, 2),
            Transition::new(828860400, 3),
            Transition::new(846396000, 2),
            Transition::new(860310000, 3),
            Transition::new(877845600, 2),
            Transition::new(891759600, 3),
            Transition::new(909295200, 2),
            Transition::new(923209200, 3),
            Transition::new(941349600, 2),
            Transition::new(954658800, 3),
            Transition::new(972799200, 2),
            Transition::new(986108400, 3),
            Transition::new(1004248800, 2),
            Transition::new(1018162800, 3),
            Transition::new(1035698400, 2),
            Transition::new(1049612400, 3),
            Transition::new(1067148000, 2),
            Transition::new(1081062000, 3),
            Transition::new(1099202400, 2),
            Transition::new(1112511600, 3),
            Transition::new(1130652000, 2),
            Transition::new(1143961200, 3),
            Transition::new(1162101600, 2),
            Transition::new(1173596400, 3),
            Transition::new(1194156000, 2),
            Transition::new(1205046000, 3),
            Transition::new(1225605600, 2),
            Transition::new(1236495600, 3),
            Transition::new(1257055200, 2),
            Transition::new(1268550000, 3),
            Transition::new(1289109600, 2),
            Transition::new(1299999600, 3),
            Transition::new(1320559200, 2),
            Transition::new(1331449200, 3),
            Transition::new(1352008800, 2),
            Transition::new(1362898800, 3),
            Transition::new(1383458400, 2),
            Transition::new(1394348400, 3),
            Transition::new(1414908000, 2),
            Transition::new(1425798000, 4),
            Transition::new(1520751600, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-17072, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18430, false, Some(b"KMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_GRENADA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1846266780, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(-14820, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_GUADELOUPE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1848254032, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(-14768, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_GUATEMALA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1617040676, 2),
            Transition::new(123055200, 1),
            Transition::new(130914000, 2),
            Transition::new(422344800, 1),
            Transition::new(433054800, 2),
            Transition::new(669708000, 1),
            Transition::new(684219600, 2),
            Transition::new(1146376800, 1),
            Transition::new(1159678800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-21724, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_GUAYAQUIL: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524502440, 1),
            Transition::new(-1230749160, 3),
            Transition::new(722926800, 2),
            Transition::new(728884800, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-19160, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18840, false, Some(b"QMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_GUYANA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1843589241, 1),
            Transition::new(-1730577600, 2),
            Transition::new(176096700, 3),
            Transition::new(701841600, 1),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-13959, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-13500, false, Some(b"-0345")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_HALIFAX: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2131645536, 2),
            Transition::new(-1696276800, 1),
            Transition::new(-1680469200, 2),
            Transition::new(-1632074400, 1),
            Transition::new(-1615143600, 2),
            Transition::new(-1566763200, 1),
            Transition::new(-1557090000, 2),
            Transition::new(-1535486400, 1),
            Transition::new(-1524949200, 2),
            Transition::new(-1504468800, 1),
            Transition::new(-1493413200, 2),
            Transition::new(-1472414400, 1),
            Transition::new(-1461963600, 2),
            Transition::new(-1440964800, 1),
            Transition::new(-1429390800, 2),
            Transition::new(-1409515200, 1),
            Transition::new(-1396731600, 2),
            Transition::new(-1376856000, 1),
            Transition::new(-1366491600, 2),
            Transition::new(-1346616000, 1),
            Transition::new(-1333832400, 2),
            Transition::new(-1313956800, 1),
            Transition::new(-1303678800, 2),
            Transition::new(-1282507200, 1),
            Transition::new(-1272661200, 2),
            Transition::new(-1251057600, 1),
            Transition::new(-1240088400, 2),
            Transition::new(-1219608000, 1),
            Transition::new(-1207429200, 2),
            Transition::new(-1188763200, 1),
            Transition::new(-1175979600, 2),
            Transition::new(-1157313600, 1),
            Transition::new(-1143925200, 2),
            Transition::new(-1124049600, 1),
            Transition::new(-1113771600, 2),
            Transition::new(-1091390400, 1),
            Transition::new(-1081026000, 2),
            Transition::new(-1059854400, 1),
            Transition::new(-1050786000, 2),
            Transition::new(-1030910400, 1),
            Transition::new(-1018126800, 2),
            Transition::new(-999460800, 1),
            Transition::new(-986677200, 2),
            Transition::new(-965592000, 1),
            Transition::new(-955227600, 2),
            Transition::new(-935956800, 1),
            Transition::new(-923173200, 2),
            Transition::new(-904507200, 1),
            Transition::new(-891723600, 2),
            Transition::new(-880221600, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765399600, 2),
            Transition::new(-747252000, 1),
            Transition::new(-733950000, 2),
            Transition::new(-715802400, 1),
            Transition::new(-702500400, 2),
            Transition::new(-684352800, 1),
            Transition::new(-671050800, 2),
            Transition::new(-652903200, 1),
            Transition::new(-639601200, 2),
            Transition::new(-589399200, 1),
            Transition::new(-576097200, 2),
            Transition::new(-557949600, 1),
            Transition::new(-544647600, 2),
            Transition::new(-526500000, 1),
            Transition::new(-513198000, 2),
            Transition::new(-495050400, 1),
            Transition::new(-481748400, 2),
            Transition::new(-431546400, 1),
            Transition::new(-418244400, 2),
            Transition::new(-400096800, 1),
            Transition::new(-386794800, 2),
            Transition::new(-368647200, 1),
            Transition::new(-355345200, 2),
            Transition::new(-337197600, 1),
            Transition::new(-323895600, 2),
            Transition::new(-242244000, 1),
            Transition::new(-226522800, 2),
            Transition::new(-210794400, 1),
            Transition::new(-195073200, 2),
            Transition::new(-179344800, 1),
            Transition::new(-163623600, 2),
            Transition::new(-147895200, 1),
            Transition::new(-131569200, 2),
            Transition::new(-116445600, 1),
            Transition::new(-100119600, 2),
            Transition::new(-84391200, 1),
            Transition::new(-68670000, 2),
            Transition::new(-52941600, 1),
            Transition::new(-37220400, 2),
            Transition::new(-21492000, 1),
            Transition::new(-5770800, 2),
            Transition::new(9957600, 1),
            Transition::new(25678800, 2),
            Transition::new(41407200, 1),
            Transition::new(57733200, 2),
            Transition::new(73461600, 1),
            Transition::new(89182800, 2),
            Transition::new(104911200, 1),
            Transition::new(120632400, 2),
            Transition::new(136360800, 1),
            Transition::new(152082000, 2),
            Transition::new(167810400, 1),
            Transition::new(183531600, 2),
            Transition::new(199260000, 1),
            Transition::new(215586000, 2),
            Transition::new(230709600, 1),
            Transition::new(247035600, 2),
            Transition::new(262764000, 1),
            Transition::new(278485200, 2),
            Transition::new(294213600, 1),
            Transition::new(309934800, 2),
            Transition::new(325663200, 1),
            Transition::new(341384400, 2),
            Transition::new(357112800, 1),
            Transition::new(372834000, 2),
            Transition::new(388562400, 1),
            Transition::new(404888400, 2),
            Transition::new(420012000, 1),
            Transition::new(436338000, 2),
            Transition::new(452066400, 1),
            Transition::new(467787600, 2),
            Transition::new(483516000, 1),
            Transition::new(499237200, 2),
            Transition::new(514965600, 1),
            Transition::new(530686800, 2),
            Transition::new(544600800, 1),
            Transition::new(562136400, 2),
            Transition::new(576050400, 1),
            Transition::new(594190800, 2),
            Transition::new(607500000, 1),
            Transition::new(625640400, 2),
            Transition::new(638949600, 1),
            Transition::new(657090000, 2),
            Transition::new(671004000, 1),
            Transition::new(688539600, 2),
            Transition::new(702453600, 1),
            Transition::new(719989200, 2),
            Transition::new(733903200, 1),
            Transition::new(752043600, 2),
            Transition::new(765352800, 1),
            Transition::new(783493200, 2),
            Transition::new(796802400, 1),
            Transition::new(814942800, 2),
            Transition::new(828856800, 1),
            Transition::new(846392400, 2),
            Transition::new(860306400, 1),
            Transition::new(877842000, 2),
            Transition::new(891756000, 1),
            Transition::new(909291600, 2),
            Transition::new(923205600, 1),
            Transition::new(941346000, 2),
            Transition::new(954655200, 1),
            Transition::new(972795600, 2),
            Transition::new(986104800, 1),
            Transition::new(1004245200, 2),
            Transition::new(1018159200, 1),
            Transition::new(1035694800, 2),
            Transition::new(1049608800, 1),
            Transition::new(1067144400, 2),
            Transition::new(1081058400, 1),
            Transition::new(1099198800, 2),
            Transition::new(1112508000, 1),
            Transition::new(1130648400, 2),
            Transition::new(1143957600, 1),
            Transition::new(1162098000, 2),
            Transition::new(1173592800, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-15264, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"AWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"APT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-14400, false, Some(b"AST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_HERMOSILLO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514739600, 1),
            Transition::new(-1343066400, 2),
            Transition::new(-1234807200, 1),
            Transition::new(-1220292000, 2),
            Transition::new(-1207159200, 1),
            Transition::new(-1191344400, 2),
            Transition::new(-873828000, 1),
            Transition::new(-661539600, 3),
            Transition::new(28800, 1),
            Transition::new(828867600, 4),
            Transition::new(846403200, 1),
            Transition::new(860317200, 4),
            Transition::new(877852800, 1),
            Transition::new(891766800, 4),
            Transition::new(909302400, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-26632, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_INUVIK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-536457600, 2),
            Transition::new(-147888000, 1),
            Transition::new(-131558400, 2),
            Transition::new(294228000, 3),
            Transition::new(325674000, 4),
            Transition::new(341395200, 3),
            Transition::new(357123600, 4),
            Transition::new(372844800, 3),
            Transition::new(388573200, 4),
            Transition::new(404899200, 3),
            Transition::new(420022800, 4),
            Transition::new(436348800, 3),
            Transition::new(452077200, 4),
            Transition::new(467798400, 3),
            Transition::new(483526800, 4),
            Transition::new(499248000, 3),
            Transition::new(514976400, 4),
            Transition::new(530697600, 3),
            Transition::new(544611600, 4),
            Transition::new(562147200, 3),
            Transition::new(576061200, 4),
            Transition::new(594201600, 3),
            Transition::new(607510800, 4),
            Transition::new(625651200, 3),
            Transition::new(638960400, 4),
            Transition::new(657100800, 3),
            Transition::new(671014800, 4),
            Transition::new(688550400, 3),
            Transition::new(702464400, 4),
            Transition::new(720000000, 3),
            Transition::new(733914000, 4),
            Transition::new(752054400, 3),
            Transition::new(765363600, 4),
            Transition::new(783504000, 3),
            Transition::new(796813200, 4),
            Transition::new(814953600, 3),
            Transition::new(828867600, 4),
            Transition::new(846403200, 3),
            Transition::new(860317200, 4),
            Transition::new(877852800, 3),
            Transition::new(891766800, 4),
            Transition::new(909302400, 3),
            Transition::new(923216400, 4),
            Transition::new(941356800, 3),
            Transition::new(954666000, 4),
            Transition::new(972806400, 3),
            Transition::new(986115600, 4),
            Transition::new(1004256000, 3),
            Transition::new(1018170000, 4),
            Transition::new(1035705600, 3),
            Transition::new(1049619600, 4),
            Transition::new(1067155200, 3),
            Transition::new(1081069200, 4),
            Transition::new(1099209600, 3),
            Transition::new(1112518800, 4),
            Transition::new(1130659200, 3),
            Transition::new(1143968400, 4),
            Transition::new(1162108800, 3),
            Transition::new(1173603600, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"PDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_IQALUIT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-865296000, 5),
            Transition::new(-769395600, 1),
            Transition::new(-765396000, 2),
            Transition::new(-147898800, 3),
            Transition::new(-131569200, 2),
            Transition::new(325666800, 4),
            Transition::new(341388000, 2),
            Transition::new(357116400, 4),
            Transition::new(372837600, 2),
            Transition::new(388566000, 4),
            Transition::new(404892000, 2),
            Transition::new(420015600, 4),
            Transition::new(436341600, 2),
            Transition::new(452070000, 4),
            Transition::new(467791200, 2),
            Transition::new(483519600, 4),
            Transition::new(499240800, 2),
            Transition::new(514969200, 4),
            Transition::new(530690400, 2),
            Transition::new(544604400, 4),
            Transition::new(562140000, 2),
            Transition::new(576054000, 4),
            Transition::new(594194400, 2),
            Transition::new(607503600, 4),
            Transition::new(625644000, 2),
            Transition::new(638953200, 4),
            Transition::new(657093600, 2),
            Transition::new(671007600, 4),
            Transition::new(688543200, 2),
            Transition::new(702457200, 4),
            Transition::new(719992800, 2),
            Transition::new(733906800, 4),
            Transition::new(752047200, 2),
            Transition::new(765356400, 4),
            Transition::new(783496800, 2),
            Transition::new(796806000, 4),
            Transition::new(814946400, 2),
            Transition::new(828860400, 4),
            Transition::new(846396000, 2),
            Transition::new(860310000, 4),
            Transition::new(877845600, 2),
            Transition::new(891759600, 4),
            Transition::new(909295200, 2),
            Transition::new(923209200, 4),
            Transition::new(941349600, 6),
            Transition::new(954662400, 7),
            Transition::new(972802800, 2),
            Transition::new(986108400, 4),
            Transition::new(1004248800, 2),
            Transition::new(1018162800, 4),
            Transition::new(1035698400, 2),
            Transition::new(1049612400, 4),
            Transition::new(1067148000, 2),
            Transition::new(1081062000, 4),
            Transition::new(1099202400, 2),
            Transition::new(1112511600, 4),
            Transition::new(1130652000, 2),
            Transition::new(1143961200, 4),
            Transition::new(1162101600, 2),
            Transition::new(1173596400, 4),
        ],
        &{
            const V: [LocalTimeType; 8] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"EDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_JUJUY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2372096328, 1),
            Transition::new(-1567453392, 2),
            Transition::new(-1233432000, 3),
            Transition::new(-1222981200, 2),
            Transition::new(-1205956800, 3),
            Transition::new(-1194037200, 2),
            Transition::new(-1172865600, 3),
            Transition::new(-1162501200, 2),
            Transition::new(-1141329600, 3),
            Transition::new(-1130965200, 2),
            Transition::new(-1109793600, 3),
            Transition::new(-1099429200, 2),
            Transition::new(-1078257600, 3),
            Transition::new(-1067806800, 2),
            Transition::new(-1046635200, 3),
            Transition::new(-1036270800, 2),
            Transition::new(-1015099200, 3),
            Transition::new(-1004734800, 2),
            Transition::new(-983563200, 3),
            Transition::new(-973198800, 2),
            Transition::new(-952027200, 3),
            Transition::new(-941576400, 2),
            Transition::new(-931032000, 3),
            Transition::new(-900882000, 2),
            Transition::new(-890337600, 3),
            Transition::new(-833749200, 2),
            Transition::new(-827265600, 3),
            Transition::new(-752274000, 2),
            Transition::new(-733780800, 3),
            Transition::new(-197326800, 2),
            Transition::new(-190843200, 3),
            Transition::new(-184194000, 2),
            Transition::new(-164491200, 3),
            Transition::new(-152658000, 2),
            Transition::new(-132955200, 3),
            Transition::new(-121122000, 2),
            Transition::new(-101419200, 3),
            Transition::new(-86821200, 2),
            Transition::new(-71092800, 3),
            Transition::new(-54766800, 2),
            Transition::new(-39038400, 3),
            Transition::new(-23317200, 2),
            Transition::new(-7588800, 5),
            Transition::new(128142000, 4),
            Transition::new(136605600, 5),
            Transition::new(596948400, 4),
            Transition::new(605066400, 5),
            Transition::new(624423600, 4),
            Transition::new(636516000, 2),
            Transition::new(657086400, 3),
            Transition::new(669178800, 2),
            Transition::new(686721600, 4),
            Transition::new(699415200, 5),
            Transition::new(719377200, 4),
            Transition::new(731469600, 5),
            Transition::new(938919600, 3),
            Transition::new(952052400, 5),
            Transition::new(1198983600, 4),
            Transition::new(1205632800, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-15672, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-15408, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_JUNEAU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3225223727, 1),
            Transition::new(-2188954939, 2),
            Transition::new(-880207200, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765385200, 2),
            Transition::new(-21477600, 5),
            Transition::new(-5756400, 2),
            Transition::new(9972000, 5),
            Transition::new(25693200, 2),
            Transition::new(41421600, 5),
            Transition::new(57747600, 2),
            Transition::new(73476000, 5),
            Transition::new(89197200, 2),
            Transition::new(104925600, 5),
            Transition::new(120646800, 2),
            Transition::new(126698400, 5),
            Transition::new(152096400, 2),
            Transition::new(162381600, 5),
            Transition::new(183546000, 2),
            Transition::new(199274400, 5),
            Transition::new(215600400, 2),
            Transition::new(230724000, 5),
            Transition::new(247050000, 2),
            Transition::new(262778400, 5),
            Transition::new(278499600, 2),
            Transition::new(294228000, 5),
            Transition::new(309949200, 2),
            Transition::new(325677600, 6),
            Transition::new(341402400, 2),
            Transition::new(357127200, 5),
            Transition::new(372848400, 2),
            Transition::new(388576800, 5),
            Transition::new(404902800, 2),
            Transition::new(420026400, 5),
            Transition::new(436352400, 7),
            Transition::new(439030800, 9),
            Transition::new(452084400, 8),
            Transition::new(467805600, 9),
            Transition::new(483534000, 8),
            Transition::new(499255200, 9),
            Transition::new(514983600, 8),
            Transition::new(530704800, 9),
            Transition::new(544618800, 8),
            Transition::new(562154400, 9),
            Transition::new(576068400, 8),
            Transition::new(594208800, 9),
            Transition::new(607518000, 8),
            Transition::new(625658400, 9),
            Transition::new(638967600, 8),
            Transition::new(657108000, 9),
            Transition::new(671022000, 8),
            Transition::new(688557600, 9),
            Transition::new(702471600, 8),
            Transition::new(720007200, 9),
            Transition::new(733921200, 8),
            Transition::new(752061600, 9),
            Transition::new(765370800, 8),
            Transition::new(783511200, 9),
            Transition::new(796820400, 8),
            Transition::new(814960800, 9),
            Transition::new(828874800, 8),
            Transition::new(846410400, 9),
            Transition::new(860324400, 8),
            Transition::new(877860000, 9),
            Transition::new(891774000, 8),
            Transition::new(909309600, 9),
            Transition::new(923223600, 8),
            Transition::new(941364000, 9),
            Transition::new(954673200, 8),
            Transition::new(972813600, 9),
            Transition::new(986122800, 8),
            Transition::new(1004263200, 9),
            Transition::new(1018177200, 8),
            Transition::new(1035712800, 9),
            Transition::new(1049626800, 8),
            Transition::new(1067162400, 9),
            Transition::new(1081076400, 8),
            Transition::new(1099216800, 9),
            Transition::new(1112526000, 8),
            Transition::new(1130666400, 9),
            Transition::new(1143975600, 8),
            Transition::new(1162116000, 9),
            Transition::new(1173610800, 8),
        ],
        &{
            const V: [LocalTimeType; 10] = [
                match LocalTimeType::new(54139, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32261, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"YST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_KNOX_IN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2717647200, 2),
            Transition::new(-1633276800, 1),
            Transition::new(-1615136400, 2),
            Transition::new(-1601827200, 1),
            Transition::new(-1583686800, 2),
            Transition::new(-880214400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765392400, 2),
            Transition::new(-715795200, 1),
            Transition::new(-702493200, 2),
            Transition::new(-684345600, 1),
            Transition::new(-671043600, 2),
            Transition::new(-652896000, 1),
            Transition::new(-639594000, 2),
            Transition::new(-620841600, 1),
            Transition::new(-608144400, 2),
            Transition::new(-589392000, 1),
            Transition::new(-576090000, 2),
            Transition::new(-557942400, 1),
            Transition::new(-544640400, 2),
            Transition::new(-526492800, 1),
            Transition::new(-513190800, 2),
            Transition::new(-495043200, 1),
            Transition::new(-481741200, 2),
            Transition::new(-463593600, 1),
            Transition::new(-447267600, 2),
            Transition::new(-431539200, 1),
            Transition::new(-415818000, 2),
            Transition::new(-400089600, 1),
            Transition::new(-386787600, 2),
            Transition::new(-368640000, 1),
            Transition::new(-355338000, 2),
            Transition::new(-337190400, 1),
            Transition::new(-321469200, 2),
            Transition::new(-305740800, 1),
            Transition::new(-289414800, 2),
            Transition::new(-273686400, 1),
            Transition::new(-257965200, 2),
            Transition::new(-242236800, 5),
            Transition::new(-195066000, 2),
            Transition::new(-84384000, 1),
            Transition::new(-68662800, 2),
            Transition::new(-52934400, 1),
            Transition::new(-37213200, 2),
            Transition::new(-21484800, 1),
            Transition::new(-5763600, 2),
            Transition::new(9964800, 1),
            Transition::new(25686000, 2),
            Transition::new(41414400, 1),
            Transition::new(57740400, 2),
            Transition::new(73468800, 1),
            Transition::new(89190000, 2),
            Transition::new(104918400, 1),
            Transition::new(120639600, 2),
            Transition::new(126691200, 1),
            Transition::new(152089200, 2),
            Transition::new(162374400, 1),
            Transition::new(183538800, 2),
            Transition::new(199267200, 1),
            Transition::new(215593200, 2),
            Transition::new(230716800, 1),
            Transition::new(247042800, 2),
            Transition::new(262771200, 1),
            Transition::new(278492400, 2),
            Transition::new(294220800, 1),
            Transition::new(309942000, 2),
            Transition::new(325670400, 1),
            Transition::new(341391600, 2),
            Transition::new(357120000, 1),
            Transition::new(372841200, 2),
            Transition::new(388569600, 1),
            Transition::new(404895600, 2),
            Transition::new(420019200, 1),
            Transition::new(436345200, 2),
            Transition::new(452073600, 1),
            Transition::new(467794800, 2),
            Transition::new(483523200, 1),
            Transition::new(499244400, 2),
            Transition::new(514972800, 1),
            Transition::new(530694000, 2),
            Transition::new(544608000, 1),
            Transition::new(562143600, 2),
            Transition::new(576057600, 1),
            Transition::new(594198000, 2),
            Transition::new(607507200, 1),
            Transition::new(625647600, 2),
            Transition::new(638956800, 1),
            Transition::new(657097200, 2),
            Transition::new(671011200, 1),
            Transition::new(688546800, 5),
            Transition::new(1143961200, 1),
            Transition::new(1162105200, 2),
            Transition::new(1173600000, 1),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-20790, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_LA_PAZ: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524505244, 1),
            Transition::new(-1205954844, 2),
            Transition::new(-1192307244, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-16356, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-16356, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-12756, true, Some(b"BST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_LIMA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524503108, 1),
            Transition::new(-1938538284, 3),
            Transition::new(-1009825200, 2),
            Transition::new(-1002052800, 3),
            Transition::new(-986756400, 2),
            Transition::new(-971035200, 3),
            Transition::new(-955306800, 2),
            Transition::new(-939585600, 3),
            Transition::new(504939600, 2),
            Transition::new(512712000, 3),
            Transition::new(536475600, 2),
            Transition::new(544248000, 3),
            Transition::new(631170000, 2),
            Transition::new(638942400, 3),
            Transition::new(757400400, 2),
            Transition::new(765172800, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-18492, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18516, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_LOS_ANGELES: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2717640000, 2),
            Transition::new(-1633269600, 1),
            Transition::new(-1615129200, 2),
            Transition::new(-1601820000, 1),
            Transition::new(-1583679600, 2),
            Transition::new(-880207200, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765385200, 2),
            Transition::new(-687967140, 1),
            Transition::new(-662655600, 2),
            Transition::new(-620838000, 1),
            Transition::new(-608137200, 2),
            Transition::new(-589388400, 1),
            Transition::new(-576082800, 2),
            Transition::new(-557938800, 1),
            Transition::new(-544633200, 2),
            Transition::new(-526489200, 1),
            Transition::new(-513183600, 2),
            Transition::new(-495039600, 1),
            Transition::new(-481734000, 2),
            Transition::new(-463590000, 1),
            Transition::new(-450284400, 2),
            Transition::new(-431535600, 1),
            Transition::new(-418230000, 2),
            Transition::new(-400086000, 1),
            Transition::new(-386780400, 2),
            Transition::new(-368636400, 1),
            Transition::new(-355330800, 2),
            Transition::new(-337186800, 1),
            Transition::new(-323881200, 2),
            Transition::new(-305737200, 1),
            Transition::new(-292431600, 2),
            Transition::new(-273682800, 1),
            Transition::new(-260982000, 2),
            Transition::new(-242233200, 1),
            Transition::new(-226508400, 2),
            Transition::new(-210783600, 1),
            Transition::new(-195058800, 2),
            Transition::new(-179334000, 1),
            Transition::new(-163609200, 2),
            Transition::new(-147884400, 1),
            Transition::new(-131554800, 2),
            Transition::new(-116434800, 1),
            Transition::new(-100105200, 2),
            Transition::new(-84376800, 1),
            Transition::new(-68655600, 2),
            Transition::new(-52927200, 1),
            Transition::new(-37206000, 2),
            Transition::new(-21477600, 1),
            Transition::new(-5756400, 2),
            Transition::new(9972000, 1),
            Transition::new(25693200, 2),
            Transition::new(41421600, 1),
            Transition::new(57747600, 2),
            Transition::new(73476000, 1),
            Transition::new(89197200, 2),
            Transition::new(104925600, 1),
            Transition::new(120646800, 2),
            Transition::new(126698400, 1),
            Transition::new(152096400, 2),
            Transition::new(162381600, 1),
            Transition::new(183546000, 2),
            Transition::new(199274400, 1),
            Transition::new(215600400, 2),
            Transition::new(230724000, 1),
            Transition::new(247050000, 2),
            Transition::new(262778400, 1),
            Transition::new(278499600, 2),
            Transition::new(294228000, 1),
            Transition::new(309949200, 2),
            Transition::new(325677600, 1),
            Transition::new(341398800, 2),
            Transition::new(357127200, 1),
            Transition::new(372848400, 2),
            Transition::new(388576800, 1),
            Transition::new(404902800, 2),
            Transition::new(420026400, 1),
            Transition::new(436352400, 2),
            Transition::new(452080800, 1),
            Transition::new(467802000, 2),
            Transition::new(483530400, 1),
            Transition::new(499251600, 2),
            Transition::new(514980000, 1),
            Transition::new(530701200, 2),
            Transition::new(544615200, 1),
            Transition::new(562150800, 2),
            Transition::new(576064800, 1),
            Transition::new(594205200, 2),
            Transition::new(607514400, 1),
            Transition::new(625654800, 2),
            Transition::new(638964000, 1),
            Transition::new(657104400, 2),
            Transition::new(671018400, 1),
            Transition::new(688554000, 2),
            Transition::new(702468000, 1),
            Transition::new(720003600, 2),
            Transition::new(733917600, 1),
            Transition::new(752058000, 2),
            Transition::new(765367200, 1),
            Transition::new(783507600, 2),
            Transition::new(796816800, 1),
            Transition::new(814957200, 2),
            Transition::new(828871200, 1),
            Transition::new(846406800, 2),
            Transition::new(860320800, 1),
            Transition::new(877856400, 2),
            Transition::new(891770400, 1),
            Transition::new(909306000, 2),
            Transition::new(923220000, 1),
            Transition::new(941360400, 2),
            Transition::new(954669600, 1),
            Transition::new(972810000, 2),
            Transition::new(986119200, 1),
            Transition::new(1004259600, 2),
            Transition::new(1018173600, 1),
            Transition::new(1035709200, 2),
            Transition::new(1049623200, 1),
            Transition::new(1067158800, 2),
            Transition::new(1081072800, 1),
            Transition::new(1099213200, 2),
            Transition::new(1112522400, 1),
            Transition::new(1130662800, 2),
            Transition::new(1143972000, 1),
            Transition::new(1162112400, 2),
            Transition::new(1173607200, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-28378, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-28800, false, Some(b"PST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_LOUISVILLE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2717647200, 2),
            Transition::new(-1633276800, 1),
            Transition::new(-1615136400, 2),
            Transition::new(-1601827200, 1),
            Transition::new(-1583686800, 2),
            Transition::new(-1535904000, 1),
            Transition::new(-1525280400, 2),
            Transition::new(-905097600, 1),
            Transition::new(-891795600, 2),
            Transition::new(-880214400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765392400, 2),
            Transition::new(-747251940, 1),
            Transition::new(-744224400, 2),
            Transition::new(-620841600, 1),
            Transition::new(-608144400, 2),
            Transition::new(-589392000, 1),
            Transition::new(-576090000, 2),
            Transition::new(-557942400, 1),
            Transition::new(-544640400, 2),
            Transition::new(-526492800, 1),
            Transition::new(-513190800, 2),
            Transition::new(-495043200, 1),
            Transition::new(-481741200, 2),
            Transition::new(-463593600, 1),
            Transition::new(-450291600, 2),
            Transition::new(-431539200, 1),
            Transition::new(-415818000, 2),
            Transition::new(-400089600, 1),
            Transition::new(-384368400, 2),
            Transition::new(-368640000, 1),
            Transition::new(-352918800, 2),
            Transition::new(-337190400, 1),
            Transition::new(-321469200, 2),
            Transition::new(-305740800, 1),
            Transition::new(-289414800, 2),
            Transition::new(-273686400, 1),
            Transition::new(-266432400, 5),
            Transition::new(-52938000, 6),
            Transition::new(-37216800, 5),
            Transition::new(-21488400, 6),
            Transition::new(-5767200, 5),
            Transition::new(9961200, 6),
            Transition::new(25682400, 5),
            Transition::new(41410800, 6),
            Transition::new(57736800, 5),
            Transition::new(73465200, 6),
            Transition::new(89186400, 5),
            Transition::new(104914800, 6),
            Transition::new(120636000, 5),
            Transition::new(126687600, 1),
            Transition::new(152089200, 5),
            Transition::new(162370800, 6),
            Transition::new(183535200, 5),
            Transition::new(199263600, 6),
            Transition::new(215589600, 5),
            Transition::new(230713200, 6),
            Transition::new(247039200, 5),
            Transition::new(262767600, 6),
            Transition::new(278488800, 5),
            Transition::new(294217200, 6),
            Transition::new(309938400, 5),
            Transition::new(325666800, 6),
            Transition::new(341388000, 5),
            Transition::new(357116400, 6),
            Transition::new(372837600, 5),
            Transition::new(388566000, 6),
            Transition::new(404892000, 5),
            Transition::new(420015600, 6),
            Transition::new(436341600, 5),
            Transition::new(452070000, 6),
            Transition::new(467791200, 5),
            Transition::new(483519600, 6),
            Transition::new(499240800, 5),
            Transition::new(514969200, 6),
            Transition::new(530690400, 5),
            Transition::new(544604400, 6),
            Transition::new(562140000, 5),
            Transition::new(576054000, 6),
            Transition::new(594194400, 5),
            Transition::new(607503600, 6),
            Transition::new(625644000, 5),
            Transition::new(638953200, 6),
            Transition::new(657093600, 5),
            Transition::new(671007600, 6),
            Transition::new(688543200, 5),
            Transition::new(702457200, 6),
            Transition::new(719992800, 5),
            Transition::new(733906800, 6),
            Transition::new(752047200, 5),
            Transition::new(765356400, 6),
            Transition::new(783496800, 5),
            Transition::new(796806000, 6),
            Transition::new(814946400, 5),
            Transition::new(828860400, 6),
            Transition::new(846396000, 5),
            Transition::new(860310000, 6),
            Transition::new(877845600, 5),
            Transition::new(891759600, 6),
            Transition::new(909295200, 5),
            Transition::new(923209200, 6),
            Transition::new(941349600, 5),
            Transition::new(954658800, 6),
            Transition::new(972799200, 5),
            Transition::new(986108400, 6),
            Transition::new(1004248800, 5),
            Transition::new(1018162800, 6),
            Transition::new(1035698400, 5),
            Transition::new(1049612400, 6),
            Transition::new(1067148000, 5),
            Transition::new(1081062000, 6),
            Transition::new(1099202400, 5),
            Transition::new(1112511600, 6),
            Transition::new(1130652000, 5),
            Transition::new(1143961200, 6),
            Transition::new(1162101600, 5),
            Transition::new(1173596400, 6),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(-20582, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MACEIO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767217028, 2),
            Transition::new(-1206957600, 1),
            Transition::new(-1191362400, 2),
            Transition::new(-1175374800, 1),
            Transition::new(-1159826400, 2),
            Transition::new(-633819600, 1),
            Transition::new(-622069200, 2),
            Transition::new(-602283600, 1),
            Transition::new(-591832800, 2),
            Transition::new(-570747600, 1),
            Transition::new(-560210400, 2),
            Transition::new(-539125200, 1),
            Transition::new(-531352800, 2),
            Transition::new(-191365200, 1),
            Transition::new(-184197600, 2),
            Transition::new(-155163600, 1),
            Transition::new(-150069600, 2),
            Transition::new(-128898000, 1),
            Transition::new(-121125600, 2),
            Transition::new(-99954000, 1),
            Transition::new(-89589600, 2),
            Transition::new(-68418000, 1),
            Transition::new(-57967200, 2),
            Transition::new(499748400, 1),
            Transition::new(511236000, 2),
            Transition::new(530593200, 1),
            Transition::new(540266400, 2),
            Transition::new(562129200, 1),
            Transition::new(571197600, 2),
            Transition::new(592974000, 1),
            Transition::new(602042400, 2),
            Transition::new(624423600, 1),
            Transition::new(634701600, 2),
            Transition::new(813726000, 1),
            Transition::new(824004000, 2),
            Transition::new(938919600, 1),
            Transition::new(951616800, 2),
            Transition::new(970974000, 1),
            Transition::new(972180000, 2),
            Transition::new(1003028400, 1),
            Transition::new(1013911200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-8572, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MANAGUA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524500892, 1),
            Transition::new(-1121105688, 2),
            Transition::new(105084000, 3),
            Transition::new(161758800, 2),
            Transition::new(290584800, 4),
            Transition::new(299134800, 2),
            Transition::new(322034400, 4),
            Transition::new(330584400, 2),
            Transition::new(694260000, 3),
            Transition::new(717310800, 2),
            Transition::new(725868000, 3),
            Transition::new(852094800, 2),
            Transition::new(1113112800, 4),
            Transition::new(1128229200, 2),
            Transition::new(1146384000, 4),
            Transition::new(1159682400, 2),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-20708, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-20712, false, Some(b"MMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MANAUS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767211196, 2),
            Transition::new(-1206954000, 1),
            Transition::new(-1191358800, 2),
            Transition::new(-1175371200, 1),
            Transition::new(-1159822800, 2),
            Transition::new(-633816000, 1),
            Transition::new(-622065600, 2),
            Transition::new(-602280000, 1),
            Transition::new(-591829200, 2),
            Transition::new(-570744000, 1),
            Transition::new(-560206800, 2),
            Transition::new(-539121600, 1),
            Transition::new(-531349200, 2),
            Transition::new(-191361600, 1),
            Transition::new(-184194000, 2),
            Transition::new(-155160000, 1),
            Transition::new(-150066000, 2),
            Transition::new(-128894400, 1),
            Transition::new(-121122000, 2),
            Transition::new(-99950400, 1),
            Transition::new(-89586000, 2),
            Transition::new(-68414400, 1),
            Transition::new(-57963600, 2),
            Transition::new(499752000, 1),
            Transition::new(511239600, 2),
            Transition::new(530596800, 1),
            Transition::new(540270000, 2),
            Transition::new(562132800, 1),
            Transition::new(571201200, 2),
            Transition::new(750830400, 1),
            Transition::new(761713200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-14404, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MARIGOT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1825098836, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(-14764, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MARTINIQUE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524506940, 1),
            Transition::new(-1851537340, 2),
            Transition::new(323841600, 3),
            Transition::new(338958000, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-14660, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14660, false, Some(b"FFMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MATAMOROS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514743200, 1),
            Transition::new(576057600, 2),
            Transition::new(594198000, 1),
            Transition::new(828864000, 2),
            Transition::new(846399600, 1),
            Transition::new(860313600, 2),
            Transition::new(877849200, 1),
            Transition::new(891763200, 2),
            Transition::new(909298800, 1),
            Transition::new(923212800, 2),
            Transition::new(941353200, 1),
            Transition::new(954662400, 2),
            Transition::new(972802800, 1),
            Transition::new(989136000, 2),
            Transition::new(1001833200, 1),
            Transition::new(1018166400, 2),
            Transition::new(1035702000, 1),
            Transition::new(1049616000, 2),
            Transition::new(1067151600, 1),
            Transition::new(1081065600, 2),
            Transition::new(1099206000, 1),
            Transition::new(1112515200, 2),
            Transition::new(1130655600, 1),
            Transition::new(1143964800, 2),
            Transition::new(1162105200, 1),
            Transition::new(1175414400, 2),
            Transition::new(1193554800, 1),
            Transition::new(1207468800, 2),
            Transition::new(1225004400, 1),
            Transition::new(1238918400, 2),
            Transition::new(1256454000, 1),
            Transition::new(1268553600, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-24000, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MAZATLAN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514739600, 1),
            Transition::new(-1343066400, 2),
            Transition::new(-1234807200, 1),
            Transition::new(-1220292000, 2),
            Transition::new(-1207159200, 1),
            Transition::new(-1191344400, 2),
            Transition::new(-873828000, 1),
            Transition::new(-661539600, 3),
            Transition::new(28800, 1),
            Transition::new(828867600, 4),
            Transition::new(846403200, 1),
            Transition::new(860317200, 4),
            Transition::new(877852800, 1),
            Transition::new(891766800, 4),
            Transition::new(909302400, 1),
            Transition::new(923216400, 4),
            Transition::new(941356800, 1),
            Transition::new(954666000, 4),
            Transition::new(972806400, 1),
            Transition::new(989139600, 4),
            Transition::new(1001836800, 1),
            Transition::new(1018170000, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-25540, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MENDOZA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2372095484, 1),
            Transition::new(-1567453392, 2),
            Transition::new(-1233432000, 3),
            Transition::new(-1222981200, 2),
            Transition::new(-1205956800, 3),
            Transition::new(-1194037200, 2),
            Transition::new(-1172865600, 3),
            Transition::new(-1162501200, 2),
            Transition::new(-1141329600, 3),
            Transition::new(-1130965200, 2),
            Transition::new(-1109793600, 3),
            Transition::new(-1099429200, 2),
            Transition::new(-1078257600, 3),
            Transition::new(-1067806800, 2),
            Transition::new(-1046635200, 3),
            Transition::new(-1036270800, 2),
            Transition::new(-1015099200, 3),
            Transition::new(-1004734800, 2),
            Transition::new(-983563200, 3),
            Transition::new(-973198800, 2),
            Transition::new(-952027200, 3),
            Transition::new(-941576400, 2),
            Transition::new(-931032000, 3),
            Transition::new(-900882000, 2),
            Transition::new(-890337600, 3),
            Transition::new(-833749200, 2),
            Transition::new(-827265600, 3),
            Transition::new(-752274000, 2),
            Transition::new(-733780800, 3),
            Transition::new(-197326800, 2),
            Transition::new(-190843200, 3),
            Transition::new(-184194000, 2),
            Transition::new(-164491200, 3),
            Transition::new(-152658000, 2),
            Transition::new(-132955200, 3),
            Transition::new(-121122000, 2),
            Transition::new(-101419200, 3),
            Transition::new(-86821200, 2),
            Transition::new(-71092800, 3),
            Transition::new(-54766800, 2),
            Transition::new(-39038400, 3),
            Transition::new(-23317200, 2),
            Transition::new(-7588800, 5),
            Transition::new(128142000, 4),
            Transition::new(136605600, 5),
            Transition::new(596948400, 4),
            Transition::new(605066400, 5),
            Transition::new(624423600, 4),
            Transition::new(636516000, 2),
            Transition::new(655963200, 3),
            Transition::new(667796400, 2),
            Transition::new(687499200, 3),
            Transition::new(699418800, 2),
            Transition::new(719380800, 4),
            Transition::new(731469600, 5),
            Transition::new(938919600, 3),
            Transition::new(952052400, 5),
            Transition::new(1085281200, 2),
            Transition::new(1096171200, 5),
            Transition::new(1198983600, 4),
            Transition::new(1205632800, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-16516, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-15408, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MENOMINEE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2659759773, 2),
            Transition::new(-1633276800, 1),
            Transition::new(-1615136400, 2),
            Transition::new(-1601827200, 1),
            Transition::new(-1583686800, 2),
            Transition::new(-880214400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765392400, 2),
            Transition::new(-747244800, 1),
            Transition::new(-733942800, 2),
            Transition::new(-116438400, 1),
            Transition::new(-100112400, 2),
            Transition::new(-21484800, 5),
            Transition::new(104914800, 1),
            Transition::new(120639600, 2),
            Transition::new(126691200, 1),
            Transition::new(152089200, 2),
            Transition::new(162374400, 1),
            Transition::new(183538800, 2),
            Transition::new(199267200, 1),
            Transition::new(215593200, 2),
            Transition::new(230716800, 1),
            Transition::new(247042800, 2),
            Transition::new(262771200, 1),
            Transition::new(278492400, 2),
            Transition::new(294220800, 1),
            Transition::new(309942000, 2),
            Transition::new(325670400, 1),
            Transition::new(341391600, 2),
            Transition::new(357120000, 1),
            Transition::new(372841200, 2),
            Transition::new(388569600, 1),
            Transition::new(404895600, 2),
            Transition::new(420019200, 1),
            Transition::new(436345200, 2),
            Transition::new(452073600, 1),
            Transition::new(467794800, 2),
            Transition::new(483523200, 1),
            Transition::new(499244400, 2),
            Transition::new(514972800, 1),
            Transition::new(530694000, 2),
            Transition::new(544608000, 1),
            Transition::new(562143600, 2),
            Transition::new(576057600, 1),
            Transition::new(594198000, 2),
            Transition::new(607507200, 1),
            Transition::new(625647600, 2),
            Transition::new(638956800, 1),
            Transition::new(657097200, 2),
            Transition::new(671011200, 1),
            Transition::new(688546800, 2),
            Transition::new(702460800, 1),
            Transition::new(719996400, 2),
            Transition::new(733910400, 1),
            Transition::new(752050800, 2),
            Transition::new(765360000, 1),
            Transition::new(783500400, 2),
            Transition::new(796809600, 1),
            Transition::new(814950000, 2),
            Transition::new(828864000, 1),
            Transition::new(846399600, 2),
            Transition::new(860313600, 1),
            Transition::new(877849200, 2),
            Transition::new(891763200, 1),
            Transition::new(909298800, 2),
            Transition::new(923212800, 1),
            Transition::new(941353200, 2),
            Transition::new(954662400, 1),
            Transition::new(972802800, 2),
            Transition::new(986112000, 1),
            Transition::new(1004252400, 2),
            Transition::new(1018166400, 1),
            Transition::new(1035702000, 2),
            Transition::new(1049616000, 1),
            Transition::new(1067151600, 2),
            Transition::new(1081065600, 1),
            Transition::new(1099206000, 2),
            Transition::new(1112515200, 1),
            Transition::new(1130655600, 2),
            Transition::new(1143964800, 1),
            Transition::new(1162105200, 2),
            Transition::new(1173600000, 1),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-21027, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MERIDA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514743200, 1),
            Transition::new(377935200, 2),
            Transition::new(407653200, 1),
            Transition::new(828864000, 3),
            Transition::new(846399600, 1),
            Transition::new(860313600, 3),
            Transition::new(877849200, 1),
            Transition::new(891763200, 3),
            Transition::new(909298800, 1),
            Transition::new(923212800, 3),
            Transition::new(941353200, 1),
            Transition::new(954662400, 3),
            Transition::new(972802800, 1),
            Transition::new(989136000, 3),
            Transition::new(1001833200, 1),
            Transition::new(1018166400, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-21508, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_METLAKATLA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3225223727, 1),
            Transition::new(-2188955622, 2),
            Transition::new(-880207200, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765385200, 2),
            Transition::new(-21477600, 5),
            Transition::new(-5756400, 2),
            Transition::new(9972000, 5),
            Transition::new(25693200, 2),
            Transition::new(41421600, 5),
            Transition::new(57747600, 2),
            Transition::new(73476000, 5),
            Transition::new(89197200, 2),
            Transition::new(104925600, 5),
            Transition::new(120646800, 2),
            Transition::new(126698400, 5),
            Transition::new(152096400, 2),
            Transition::new(162381600, 5),
            Transition::new(183546000, 2),
            Transition::new(199274400, 5),
            Transition::new(215600400, 2),
            Transition::new(230724000, 5),
            Transition::new(247050000, 2),
            Transition::new(262778400, 5),
            Transition::new(278499600, 2),
            Transition::new(294228000, 5),
            Transition::new(309949200, 2),
            Transition::new(325677600, 5),
            Transition::new(341398800, 2),
            Transition::new(357127200, 5),
            Transition::new(372848400, 2),
            Transition::new(388576800, 5),
            Transition::new(404902800, 2),
            Transition::new(420026400, 5),
            Transition::new(436352400, 2),
            Transition::new(1446372000, 6),
            Transition::new(1457866800, 7),
            Transition::new(1478426400, 6),
            Transition::new(1489316400, 7),
            Transition::new(1509876000, 6),
            Transition::new(1520766000, 7),
            Transition::new(1541325600, 2),
            Transition::new(1547978400, 6),
            Transition::new(1552215600, 7),
        ],
        &{
            const V: [LocalTimeType; 8] = [
                match LocalTimeType::new(54822, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-31578, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MEXICO_CITY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514739600, 1),
            Transition::new(-1343066400, 2),
            Transition::new(-1234807200, 1),
            Transition::new(-1220292000, 2),
            Transition::new(-1207159200, 1),
            Transition::new(-1191344400, 2),
            Transition::new(-975261600, 3),
            Transition::new(-963169200, 2),
            Transition::new(-917114400, 3),
            Transition::new(-907354800, 2),
            Transition::new(-821901600, 4),
            Transition::new(-810068400, 2),
            Transition::new(-627501600, 3),
            Transition::new(-612990000, 2),
            Transition::new(828864000, 3),
            Transition::new(846399600, 2),
            Transition::new(860313600, 3),
            Transition::new(877849200, 2),
            Transition::new(891763200, 3),
            Transition::new(909298800, 2),
            Transition::new(923212800, 3),
            Transition::new(941353200, 2),
            Transition::new(954662400, 3),
            Transition::new(972802800, 2),
            Transition::new(989136000, 3),
            Transition::new(1001833200, 2),
            Transition::new(1018166400, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-23796, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MIQUELON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1850328920, 1),
            Transition::new(326001600, 2),
            Transition::new(544597200, 3),
            Transition::new(562132800, 2),
            Transition::new(576046800, 3),
            Transition::new(594187200, 2),
            Transition::new(607496400, 3),
            Transition::new(625636800, 2),
            Transition::new(638946000, 3),
            Transition::new(657086400, 2),
            Transition::new(671000400, 3),
            Transition::new(688536000, 2),
            Transition::new(702450000, 3),
            Transition::new(719985600, 2),
            Transition::new(733899600, 3),
            Transition::new(752040000, 2),
            Transition::new(765349200, 3),
            Transition::new(783489600, 2),
            Transition::new(796798800, 3),
            Transition::new(814939200, 2),
            Transition::new(828853200, 3),
            Transition::new(846388800, 2),
            Transition::new(860302800, 3),
            Transition::new(877838400, 2),
            Transition::new(891752400, 3),
            Transition::new(909288000, 2),
            Transition::new(923202000, 3),
            Transition::new(941342400, 2),
            Transition::new(954651600, 3),
            Transition::new(972792000, 2),
            Transition::new(986101200, 3),
            Transition::new(1004241600, 2),
            Transition::new(1018155600, 3),
            Transition::new(1035691200, 2),
            Transition::new(1049605200, 3),
            Transition::new(1067140800, 2),
            Transition::new(1081054800, 3),
            Transition::new(1099195200, 2),
            Transition::new(1112504400, 3),
            Transition::new(1130644800, 2),
            Transition::new(1143954000, 3),
            Transition::new(1162094400, 2),
            Transition::new(1173589200, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-13480, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-10800, false, Some(b"-03")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-7200, true, Some(b"-02")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MONCTON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2715882052, 1),
            Transition::new(-2131642800, 3),
            Transition::new(-1632074400, 2),
            Transition::new(-1615143600, 3),
            Transition::new(-1153681200, 2),
            Transition::new(-1145822400, 3),
            Transition::new(-1122231600, 2),
            Transition::new(-1114372800, 3),
            Transition::new(-1090782000, 2),
            Transition::new(-1082923200, 3),
            Transition::new(-1059332400, 2),
            Transition::new(-1051473600, 3),
            Transition::new(-1027882800, 2),
            Transition::new(-1020024000, 3),
            Transition::new(-996433200, 2),
            Transition::new(-988574400, 3),
            Transition::new(-965674800, 2),
            Transition::new(-955396800, 3),
            Transition::new(-934743600, 2),
            Transition::new(-923947200, 3),
            Transition::new(-904503600, 2),
            Transition::new(-891892800, 3),
            Transition::new(-880221600, 4),
            Transition::new(-769395600, 5),
            Transition::new(-765399600, 3),
            Transition::new(-747252000, 2),
            Transition::new(-733950000, 3),
            Transition::new(-715802400, 2),
            Transition::new(-702500400, 3),
            Transition::new(-684352800, 2),
            Transition::new(-671050800, 3),
            Transition::new(-652903200, 2),
            Transition::new(-639601200, 3),
            Transition::new(-620848800, 2),
            Transition::new(-608151600, 3),
            Transition::new(-589399200, 2),
            Transition::new(-576097200, 3),
            Transition::new(-557949600, 2),
            Transition::new(-544647600, 3),
            Transition::new(-526500000, 2),
            Transition::new(-513198000, 3),
            Transition::new(-495050400, 2),
            Transition::new(-481748400, 3),
            Transition::new(-463600800, 2),
            Transition::new(-450298800, 3),
            Transition::new(-431546400, 2),
            Transition::new(-418244400, 3),
            Transition::new(-400096800, 2),
            Transition::new(-384375600, 3),
            Transition::new(-368647200, 2),
            Transition::new(-352926000, 3),
            Transition::new(-337197600, 2),
            Transition::new(-321476400, 3),
            Transition::new(-305748000, 2),
            Transition::new(-289422000, 3),
            Transition::new(-273693600, 2),
            Transition::new(-257972400, 3),
            Transition::new(-242244000, 2),
            Transition::new(-226522800, 3),
            Transition::new(-210794400, 2),
            Transition::new(-195073200, 3),
            Transition::new(-179344800, 2),
            Transition::new(-163623600, 3),
            Transition::new(-147895200, 2),
            Transition::new(-131569200, 3),
            Transition::new(-116445600, 2),
            Transition::new(-100119600, 3),
            Transition::new(-84391200, 2),
            Transition::new(-68670000, 3),
            Transition::new(-52941600, 2),
            Transition::new(-37220400, 3),
            Transition::new(-21492000, 2),
            Transition::new(-5770800, 3),
            Transition::new(9957600, 2),
            Transition::new(25678800, 3),
            Transition::new(41407200, 2),
            Transition::new(57733200, 3),
            Transition::new(73461600, 2),
            Transition::new(89182800, 3),
            Transition::new(136360800, 2),
            Transition::new(152082000, 3),
            Transition::new(167810400, 2),
            Transition::new(183531600, 3),
            Transition::new(199260000, 2),
            Transition::new(215586000, 3),
            Transition::new(230709600, 2),
            Transition::new(247035600, 3),
            Transition::new(262764000, 2),
            Transition::new(278485200, 3),
            Transition::new(294213600, 2),
            Transition::new(309934800, 3),
            Transition::new(325663200, 2),
            Transition::new(341384400, 3),
            Transition::new(357112800, 2),
            Transition::new(372834000, 3),
            Transition::new(388562400, 2),
            Transition::new(404888400, 3),
            Transition::new(420012000, 2),
            Transition::new(436338000, 3),
            Transition::new(452066400, 2),
            Transition::new(467787600, 3),
            Transition::new(483516000, 2),
            Transition::new(499237200, 3),
            Transition::new(514965600, 2),
            Transition::new(530686800, 3),
            Transition::new(544600800, 2),
            Transition::new(562136400, 3),
            Transition::new(576050400, 2),
            Transition::new(594190800, 3),
            Transition::new(607500000, 2),
            Transition::new(625640400, 3),
            Transition::new(638949600, 2),
            Transition::new(657090000, 3),
            Transition::new(671004000, 2),
            Transition::new(688539600, 3),
            Transition::new(702453600, 2),
            Transition::new(719989200, 3),
            Transition::new(733896060, 2),
            Transition::new(752036460, 3),
            Transition::new(765345660, 2),
            Transition::new(783486060, 3),
            Transition::new(796795260, 2),
            Transition::new(814935660, 3),
            Transition::new(828849660, 2),
            Transition::new(846385260, 3),
            Transition::new(860299260, 2),
            Transition::new(877834860, 3),
            Transition::new(891748860, 2),
            Transition::new(909284460, 3),
            Transition::new(923198460, 2),
            Transition::new(941338860, 3),
            Transition::new(954648060, 2),
            Transition::new(972788460, 3),
            Transition::new(986097660, 2),
            Transition::new(1004238060, 3),
            Transition::new(1018152060, 2),
            Transition::new(1035687660, 3),
            Transition::new(1049601660, 2),
            Transition::new(1067137260, 3),
            Transition::new(1081051260, 2),
            Transition::new(1099191660, 3),
            Transition::new(1112500860, 2),
            Transition::new(1130641260, 3),
            Transition::new(1143950460, 2),
            Transition::new(1162090860, 3),
            Transition::new(1173592800, 2),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-15548, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"AWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"APT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-14400, false, Some(b"AST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MONTERREY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514743200, 1),
            Transition::new(576057600, 2),
            Transition::new(594198000, 1),
            Transition::new(828864000, 2),
            Transition::new(846399600, 1),
            Transition::new(860313600, 2),
            Transition::new(877849200, 1),
            Transition::new(891763200, 2),
            Transition::new(909298800, 1),
            Transition::new(923212800, 2),
            Transition::new(941353200, 1),
            Transition::new(954662400, 2),
            Transition::new(972802800, 1),
            Transition::new(989136000, 2),
            Transition::new(1001833200, 1),
            Transition::new(1018166400, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-24076, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MONTEVIDEO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1942690509, 1),
            Transition::new(-1567455309, 2),
            Transition::new(-1459627200, 4),
            Transition::new(-1443819600, 3),
            Transition::new(-1428006600, 4),
            Transition::new(-1412283600, 3),
            Transition::new(-1396470600, 4),
            Transition::new(-1380747600, 3),
            Transition::new(-1141590600, 4),
            Transition::new(-1128286800, 3),
            Transition::new(-1110141000, 4),
            Transition::new(-1096837200, 3),
            Transition::new(-1078691400, 4),
            Transition::new(-1065387600, 3),
            Transition::new(-1047241800, 4),
            Transition::new(-1033938000, 3),
            Transition::new(-1015187400, 4),
            Transition::new(-1002488400, 3),
            Transition::new(-983737800, 4),
            Transition::new(-971038800, 3),
            Transition::new(-954707400, 4),
            Transition::new(-938984400, 3),
            Transition::new(-920838600, 4),
            Transition::new(-907534800, 3),
            Transition::new(-896819400, 4),
            Transition::new(-853621200, 6),
            Transition::new(-845847000, 5),
            Transition::new(-334789200, 6),
            Transition::new(-319671000, 5),
            Transition::new(-314226000, 7),
            Transition::new(-309996000, 5),
            Transition::new(-149720400, 7),
            Transition::new(-134604000, 5),
            Transition::new(-50446800, 6),
            Transition::new(-34205400, 5),
            Transition::new(9860400, 7),
            Transition::new(14176800, 5),
            Transition::new(72846000, 7),
            Transition::new(80100000, 5),
            Transition::new(127278000, 8),
            Transition::new(132111000, 6),
            Transition::new(147234600, 5),
            Transition::new(156913200, 7),
            Transition::new(165376800, 5),
            Transition::new(219812400, 7),
            Transition::new(226461600, 5),
            Transition::new(250052400, 7),
            Transition::new(257911200, 5),
            Transition::new(282711600, 7),
            Transition::new(289360800, 5),
            Transition::new(294202800, 7),
            Transition::new(322020000, 5),
            Transition::new(566449200, 7),
            Transition::new(573012000, 5),
            Transition::new(597812400, 7),
            Transition::new(605066400, 5),
            Transition::new(625633200, 7),
            Transition::new(635911200, 5),
            Transition::new(656478000, 7),
            Transition::new(667965600, 5),
            Transition::new(688532400, 7),
            Transition::new(699415200, 5),
            Transition::new(719377200, 7),
            Transition::new(730864800, 5),
            Transition::new(1095562800, 7),
            Transition::new(1111896000, 5),
            Transition::new(1128834000, 7),
            Transition::new(1142136000, 5),
            Transition::new(1159678800, 7),
            Transition::new(1173585600, 5),
            Transition::new(1191733200, 7),
            Transition::new(1205035200, 5),
            Transition::new(1223182800, 7),
            Transition::new(1236484800, 5),
            Transition::new(1254632400, 7),
            Transition::new(1268539200, 5),
            Transition::new(1286082000, 7),
            Transition::new(1299988800, 5),
            Transition::new(1317531600, 7),
            Transition::new(1331438400, 5),
            Transition::new(1349586000, 7),
            Transition::new(1362888000, 5),
            Transition::new(1381035600, 7),
            Transition::new(1394337600, 5),
            Transition::new(1412485200, 7),
            Transition::new(1425787200, 5),
        ],
        &{
            const V: [LocalTimeType; 9] = [
                match LocalTimeType::new(-13491, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-13491, false, Some(b"MMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-12600, false, Some(b"-0330")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9000, true, Some(b"-0230")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-5400, true, Some(b"-0130")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MONTREAL: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713892744, 2),
            Transition::new(-1665334800, 1),
            Transition::new(-1662753600, 2),
            Transition::new(-1632070800, 1),
            Transition::new(-1615140000, 2),
            Transition::new(-1601742600, 1),
            Transition::new(-1583775000, 2),
            Transition::new(-1567355400, 1),
            Transition::new(-1554053400, 2),
            Transition::new(-1535907600, 1),
            Transition::new(-1522603800, 2),
            Transition::new(-1504458000, 1),
            Transition::new(-1491154200, 2),
            Transition::new(-1439830800, 1),
            Transition::new(-1428255000, 2),
            Transition::new(-1409504400, 1),
            Transition::new(-1396805400, 2),
            Transition::new(-1378054800, 1),
            Transition::new(-1365355800, 2),
            Transition::new(-1346612400, 1),
            Transition::new(-1333915200, 2),
            Transition::new(-1315162800, 1),
            Transition::new(-1301860800, 2),
            Transition::new(-1283713200, 1),
            Transition::new(-1270411200, 2),
            Transition::new(-1252263600, 1),
            Transition::new(-1238961600, 2),
            Transition::new(-1220814000, 1),
            Transition::new(-1207512000, 2),
            Transition::new(-1188759600, 1),
            Transition::new(-1176062400, 2),
            Transition::new(-1157310000, 1),
            Transition::new(-1144008000, 2),
            Transition::new(-1125860400, 1),
            Transition::new(-1112558400, 2),
            Transition::new(-1094410800, 1),
            Transition::new(-1081108800, 2),
            Transition::new(-1062961200, 1),
            Transition::new(-1049659200, 2),
            Transition::new(-1031511600, 1),
            Transition::new(-1018209600, 2),
            Transition::new(-1000062000, 1),
            Transition::new(-986760000, 2),
            Transition::new(-968007600, 1),
            Transition::new(-955310400, 2),
            Transition::new(-936558000, 1),
            Transition::new(-880218000, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765396000, 2),
            Transition::new(-747248400, 1),
            Transition::new(-733946400, 2),
            Transition::new(-715798800, 1),
            Transition::new(-702496800, 2),
            Transition::new(-684349200, 1),
            Transition::new(-671047200, 2),
            Transition::new(-652899600, 1),
            Transition::new(-636573600, 2),
            Transition::new(-620845200, 1),
            Transition::new(-605124000, 2),
            Transition::new(-589395600, 1),
            Transition::new(-576093600, 2),
            Transition::new(-557946000, 1),
            Transition::new(-544644000, 2),
            Transition::new(-526496400, 1),
            Transition::new(-513194400, 2),
            Transition::new(-495046800, 1),
            Transition::new(-481744800, 2),
            Transition::new(-463597200, 1),
            Transition::new(-450295200, 2),
            Transition::new(-431542800, 1),
            Transition::new(-418240800, 2),
            Transition::new(-400093200, 1),
            Transition::new(-384372000, 2),
            Transition::new(-368643600, 1),
            Transition::new(-352922400, 2),
            Transition::new(-337194000, 1),
            Transition::new(-321472800, 2),
            Transition::new(-305744400, 1),
            Transition::new(-289418400, 2),
            Transition::new(-273690000, 1),
            Transition::new(-257968800, 2),
            Transition::new(-242240400, 1),
            Transition::new(-226519200, 2),
            Transition::new(-210790800, 1),
            Transition::new(-195069600, 2),
            Transition::new(-179341200, 1),
            Transition::new(-163620000, 2),
            Transition::new(-147891600, 1),
            Transition::new(-131565600, 2),
            Transition::new(-116442000, 1),
            Transition::new(-100116000, 2),
            Transition::new(-84387600, 1),
            Transition::new(-68666400, 2),
            Transition::new(-52938000, 1),
            Transition::new(-37216800, 2),
            Transition::new(-21488400, 1),
            Transition::new(-5767200, 2),
            Transition::new(9961200, 1),
            Transition::new(25682400, 2),
            Transition::new(41410800, 1),
            Transition::new(57736800, 2),
            Transition::new(73465200, 1),
            Transition::new(89186400, 2),
            Transition::new(104914800, 1),
            Transition::new(120636000, 2),
            Transition::new(136364400, 1),
            Transition::new(152085600, 2),
            Transition::new(167814000, 1),
            Transition::new(183535200, 2),
            Transition::new(199263600, 1),
            Transition::new(215589600, 2),
            Transition::new(230713200, 1),
            Transition::new(247039200, 2),
            Transition::new(262767600, 1),
            Transition::new(278488800, 2),
            Transition::new(294217200, 1),
            Transition::new(309938400, 2),
            Transition::new(325666800, 1),
            Transition::new(341388000, 2),
            Transition::new(357116400, 1),
            Transition::new(372837600, 2),
            Transition::new(388566000, 1),
            Transition::new(404892000, 2),
            Transition::new(420015600, 1),
            Transition::new(436341600, 2),
            Transition::new(452070000, 1),
            Transition::new(467791200, 2),
            Transition::new(483519600, 1),
            Transition::new(499240800, 2),
            Transition::new(514969200, 1),
            Transition::new(530690400, 2),
            Transition::new(544604400, 1),
            Transition::new(562140000, 2),
            Transition::new(576054000, 1),
            Transition::new(594194400, 2),
            Transition::new(607503600, 1),
            Transition::new(625644000, 2),
            Transition::new(638953200, 1),
            Transition::new(657093600, 2),
            Transition::new(671007600, 1),
            Transition::new(688543200, 2),
            Transition::new(702457200, 1),
            Transition::new(719992800, 2),
            Transition::new(733906800, 1),
            Transition::new(752047200, 2),
            Transition::new(765356400, 1),
            Transition::new(783496800, 2),
            Transition::new(796806000, 1),
            Transition::new(814946400, 2),
            Transition::new(828860400, 1),
            Transition::new(846396000, 2),
            Transition::new(860310000, 1),
            Transition::new(877845600, 2),
            Transition::new(891759600, 1),
            Transition::new(909295200, 2),
            Transition::new(923209200, 1),
            Transition::new(941349600, 2),
            Transition::new(954658800, 1),
            Transition::new(972799200, 2),
            Transition::new(986108400, 1),
            Transition::new(1004248800, 2),
            Transition::new(1018162800, 1),
            Transition::new(1035698400, 2),
            Transition::new(1049612400, 1),
            Transition::new(1067148000, 2),
            Transition::new(1081062000, 1),
            Transition::new(1099202400, 2),
            Transition::new(1112511600, 1),
            Transition::new(1130652000, 2),
            Transition::new(1143961200, 1),
            Transition::new(1162101600, 2),
            Transition::new(1173596400, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-17656, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MONTSERRAT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1846266608, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(-14932, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_NASSAU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1825095030, 2),
            Transition::new(-873140400, 1),
            Transition::new(-788904000, 2),
            Transition::new(-786222000, 1),
            Transition::new(-769395600, 3),
            Transition::new(-763848000, 2),
            Transition::new(-179341200, 4),
            Transition::new(-163620000, 2),
            Transition::new(-147891600, 4),
            Transition::new(-131565600, 2),
            Transition::new(-116442000, 4),
            Transition::new(-100116000, 2),
            Transition::new(-84387600, 4),
            Transition::new(-68666400, 2),
            Transition::new(-52938000, 4),
            Transition::new(-37216800, 2),
            Transition::new(-21488400, 4),
            Transition::new(-5767200, 2),
            Transition::new(9961200, 4),
            Transition::new(25682400, 2),
            Transition::new(41410800, 4),
            Transition::new(57736800, 2),
            Transition::new(73465200, 4),
            Transition::new(89186400, 2),
            Transition::new(104914800, 4),
            Transition::new(120636000, 2),
            Transition::new(136364400, 4),
            Transition::new(152085600, 2),
            Transition::new(167814000, 4),
            Transition::new(183535200, 2),
            Transition::new(199263600, 4),
            Transition::new(215589600, 2),
            Transition::new(230713200, 4),
            Transition::new(247039200, 2),
            Transition::new(262767600, 4),
            Transition::new(278488800, 2),
            Transition::new(294217200, 4),
            Transition::new(309938400, 2),
            Transition::new(325666800, 4),
            Transition::new(341388000, 2),
            Transition::new(357116400, 4),
            Transition::new(372837600, 2),
            Transition::new(388566000, 4),
            Transition::new(404892000, 2),
            Transition::new(420015600, 4),
            Transition::new(436341600, 2),
            Transition::new(452070000, 4),
            Transition::new(467791200, 2),
            Transition::new(483519600, 4),
            Transition::new(499240800, 2),
            Transition::new(514969200, 4),
            Transition::new(530690400, 2),
            Transition::new(544604400, 4),
            Transition::new(562140000, 2),
            Transition::new(576054000, 4),
            Transition::new(594194400, 2),
            Transition::new(607503600, 4),
            Transition::new(625644000, 2),
            Transition::new(638953200, 4),
            Transition::new(657093600, 2),
            Transition::new(671007600, 4),
            Transition::new(688543200, 2),
            Transition::new(702457200, 4),
            Transition::new(719992800, 2),
            Transition::new(733906800, 4),
            Transition::new(752047200, 2),
            Transition::new(765356400, 4),
            Transition::new(783496800, 2),
            Transition::new(796806000, 4),
            Transition::new(814946400, 2),
            Transition::new(828860400, 4),
            Transition::new(846396000, 2),
            Transition::new(860310000, 4),
            Transition::new(877845600, 2),
            Transition::new(891759600, 4),
            Transition::new(909295200, 2),
            Transition::new(923209200, 4),
            Transition::new(941349600, 2),
            Transition::new(954658800, 4),
            Transition::new(972799200, 2),
            Transition::new(986108400, 4),
            Transition::new(1004248800, 2),
            Transition::new(1018162800, 4),
            Transition::new(1035698400, 2),
            Transition::new(1049612400, 4),
            Transition::new(1067148000, 2),
            Transition::new(1081062000, 4),
            Transition::new(1099202400, 2),
            Transition::new(1112511600, 4),
            Transition::new(1130652000, 2),
            Transition::new(1143961200, 4),
            Transition::new(1162101600, 2),
            Transition::new(1173596400, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-18570, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_NEW_YORK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2717650800, 2),
            Transition::new(-1633280400, 1),
            Transition::new(-1615140000, 2),
            Transition::new(-1601830800, 1),
            Transition::new(-1583690400, 2),
            Transition::new(-1570381200, 1),
            Transition::new(-1551636000, 2),
            Transition::new(-1536512400, 1),
            Transition::new(-1523210400, 2),
            Transition::new(-1504458000, 1),
            Transition::new(-1491760800, 2),
            Transition::new(-1473008400, 1),
            Transition::new(-1459706400, 2),
            Transition::new(-1441558800, 1),
            Transition::new(-1428256800, 2),
            Transition::new(-1410109200, 1),
            Transition::new(-1396807200, 2),
            Transition::new(-1378659600, 1),
            Transition::new(-1365357600, 2),
            Transition::new(-1347210000, 1),
            Transition::new(-1333908000, 2),
            Transition::new(-1315155600, 1),
            Transition::new(-1301853600, 2),
            Transition::new(-1283706000, 1),
            Transition::new(-1270404000, 2),
            Transition::new(-1252256400, 1),
            Transition::new(-1238954400, 2),
            Transition::new(-1220806800, 1),
            Transition::new(-1207504800, 2),
            Transition::new(-1189357200, 1),
            Transition::new(-1176055200, 2),
            Transition::new(-1157302800, 1),
            Transition::new(-1144605600, 2),
            Transition::new(-1125853200, 1),
            Transition::new(-1112551200, 2),
            Transition::new(-1094403600, 1),
            Transition::new(-1081101600, 2),
            Transition::new(-1062954000, 1),
            Transition::new(-1049652000, 2),
            Transition::new(-1031504400, 1),
            Transition::new(-1018202400, 2),
            Transition::new(-1000054800, 1),
            Transition::new(-986752800, 2),
            Transition::new(-968000400, 1),
            Transition::new(-955303200, 2),
            Transition::new(-936550800, 1),
            Transition::new(-923248800, 2),
            Transition::new(-905101200, 1),
            Transition::new(-891799200, 2),
            Transition::new(-880218000, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765396000, 2),
            Transition::new(-747248400, 1),
            Transition::new(-733946400, 2),
            Transition::new(-715798800, 1),
            Transition::new(-702496800, 2),
            Transition::new(-684349200, 1),
            Transition::new(-671047200, 2),
            Transition::new(-652899600, 1),
            Transition::new(-639597600, 2),
            Transition::new(-620845200, 1),
            Transition::new(-608148000, 2),
            Transition::new(-589395600, 1),
            Transition::new(-576093600, 2),
            Transition::new(-557946000, 1),
            Transition::new(-544644000, 2),
            Transition::new(-526496400, 1),
            Transition::new(-513194400, 2),
            Transition::new(-495046800, 1),
            Transition::new(-481744800, 2),
            Transition::new(-463597200, 1),
            Transition::new(-447271200, 2),
            Transition::new(-431542800, 1),
            Transition::new(-415821600, 2),
            Transition::new(-400093200, 1),
            Transition::new(-384372000, 2),
            Transition::new(-368643600, 1),
            Transition::new(-352922400, 2),
            Transition::new(-337194000, 1),
            Transition::new(-321472800, 2),
            Transition::new(-305744400, 1),
            Transition::new(-289418400, 2),
            Transition::new(-273690000, 1),
            Transition::new(-257968800, 2),
            Transition::new(-242240400, 1),
            Transition::new(-226519200, 2),
            Transition::new(-210790800, 1),
            Transition::new(-195069600, 2),
            Transition::new(-179341200, 1),
            Transition::new(-163620000, 2),
            Transition::new(-147891600, 1),
            Transition::new(-131565600, 2),
            Transition::new(-116442000, 1),
            Transition::new(-100116000, 2),
            Transition::new(-84387600, 1),
            Transition::new(-68666400, 2),
            Transition::new(-52938000, 1),
            Transition::new(-37216800, 2),
            Transition::new(-21488400, 1),
            Transition::new(-5767200, 2),
            Transition::new(9961200, 1),
            Transition::new(25682400, 2),
            Transition::new(41410800, 1),
            Transition::new(57736800, 2),
            Transition::new(73465200, 1),
            Transition::new(89186400, 2),
            Transition::new(104914800, 1),
            Transition::new(120636000, 2),
            Transition::new(126687600, 1),
            Transition::new(152085600, 2),
            Transition::new(162370800, 1),
            Transition::new(183535200, 2),
            Transition::new(199263600, 1),
            Transition::new(215589600, 2),
            Transition::new(230713200, 1),
            Transition::new(247039200, 2),
            Transition::new(262767600, 1),
            Transition::new(278488800, 2),
            Transition::new(294217200, 1),
            Transition::new(309938400, 2),
            Transition::new(325666800, 1),
            Transition::new(341388000, 2),
            Transition::new(357116400, 1),
            Transition::new(372837600, 2),
            Transition::new(388566000, 1),
            Transition::new(404892000, 2),
            Transition::new(420015600, 1),
            Transition::new(436341600, 2),
            Transition::new(452070000, 1),
            Transition::new(467791200, 2),
            Transition::new(483519600, 1),
            Transition::new(499240800, 2),
            Transition::new(514969200, 1),
            Transition::new(530690400, 2),
            Transition::new(544604400, 1),
            Transition::new(562140000, 2),
            Transition::new(576054000, 1),
            Transition::new(594194400, 2),
            Transition::new(607503600, 1),
            Transition::new(625644000, 2),
            Transition::new(638953200, 1),
            Transition::new(657093600, 2),
            Transition::new(671007600, 1),
            Transition::new(688543200, 2),
            Transition::new(702457200, 1),
            Transition::new(719992800, 2),
            Transition::new(733906800, 1),
            Transition::new(752047200, 2),
            Transition::new(765356400, 1),
            Transition::new(783496800, 2),
            Transition::new(796806000, 1),
            Transition::new(814946400, 2),
            Transition::new(828860400, 1),
            Transition::new(846396000, 2),
            Transition::new(860310000, 1),
            Transition::new(877845600, 2),
            Transition::new(891759600, 1),
            Transition::new(909295200, 2),
            Transition::new(923209200, 1),
            Transition::new(941349600, 2),
            Transition::new(954658800, 1),
            Transition::new(972799200, 2),
            Transition::new(986108400, 1),
            Transition::new(1004248800, 2),
            Transition::new(1018162800, 1),
            Transition::new(1035698400, 2),
            Transition::new(1049612400, 1),
            Transition::new(1067148000, 2),
            Transition::new(1081062000, 1),
            Transition::new(1099202400, 2),
            Transition::new(1112511600, 1),
            Transition::new(1130652000, 2),
            Transition::new(1143961200, 1),
            Transition::new(1162101600, 2),
            Transition::new(1173596400, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-17762, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_NIPIGON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2366734016, 2),
            Transition::new(-1632070800, 1),
            Transition::new(-1615140000, 2),
            Transition::new(-923252400, 1),
            Transition::new(-880218000, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765396000, 2),
            Transition::new(136364400, 1),
            Transition::new(152085600, 2),
            Transition::new(167814000, 1),
            Transition::new(183535200, 2),
            Transition::new(199263600, 1),
            Transition::new(215589600, 2),
            Transition::new(230713200, 1),
            Transition::new(247039200, 2),
            Transition::new(262767600, 1),
            Transition::new(278488800, 2),
            Transition::new(294217200, 1),
            Transition::new(309938400, 2),
            Transition::new(325666800, 1),
            Transition::new(341388000, 2),
            Transition::new(357116400, 1),
            Transition::new(372837600, 2),
            Transition::new(388566000, 1),
            Transition::new(404892000, 2),
            Transition::new(420015600, 1),
            Transition::new(436341600, 2),
            Transition::new(452070000, 1),
            Transition::new(467791200, 2),
            Transition::new(483519600, 1),
            Transition::new(499240800, 2),
            Transition::new(514969200, 1),
            Transition::new(530690400, 2),
            Transition::new(544604400, 1),
            Transition::new(562140000, 2),
            Transition::new(576054000, 1),
            Transition::new(594194400, 2),
            Transition::new(607503600, 1),
            Transition::new(625644000, 2),
            Transition::new(638953200, 1),
            Transition::new(657093600, 2),
            Transition::new(671007600, 1),
            Transition::new(688543200, 2),
            Transition::new(702457200, 1),
            Transition::new(719992800, 2),
            Transition::new(733906800, 1),
            Transition::new(752047200, 2),
            Transition::new(765356400, 1),
            Transition::new(783496800, 2),
            Transition::new(796806000, 1),
            Transition::new(814946400, 2),
            Transition::new(828860400, 1),
            Transition::new(846396000, 2),
            Transition::new(860310000, 1),
            Transition::new(877845600, 2),
            Transition::new(891759600, 1),
            Transition::new(909295200, 2),
            Transition::new(923209200, 1),
            Transition::new(941349600, 2),
            Transition::new(954658800, 1),
            Transition::new(972799200, 2),
            Transition::new(986108400, 1),
            Transition::new(1004248800, 2),
            Transition::new(1018162800, 1),
            Transition::new(1035698400, 2),
            Transition::new(1049612400, 1),
            Transition::new(1067148000, 2),
            Transition::new(1081062000, 1),
            Transition::new(1099202400, 2),
            Transition::new(1112511600, 1),
            Transition::new(1130652000, 2),
            Transition::new(1143961200, 1),
            Transition::new(1162101600, 2),
            Transition::new(1173596400, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-21184, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_NOME: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3225223727, 1),
            Transition::new(-2188947502, 2),
            Transition::new(-880196400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765374400, 2),
            Transition::new(-86878800, 5),
            Transition::new(-21466800, 6),
            Transition::new(-5745600, 5),
            Transition::new(9982800, 6),
            Transition::new(25704000, 5),
            Transition::new(41432400, 6),
            Transition::new(57758400, 5),
            Transition::new(73486800, 6),
            Transition::new(89208000, 5),
            Transition::new(104936400, 6),
            Transition::new(120657600, 5),
            Transition::new(126709200, 6),
            Transition::new(152107200, 5),
            Transition::new(162392400, 6),
            Transition::new(183556800, 5),
            Transition::new(199285200, 6),
            Transition::new(215611200, 5),
            Transition::new(230734800, 6),
            Transition::new(247060800, 5),
            Transition::new(262789200, 6),
            Transition::new(278510400, 5),
            Transition::new(294238800, 6),
            Transition::new(309960000, 5),
            Transition::new(325688400, 6),
            Transition::new(341409600, 5),
            Transition::new(357138000, 6),
            Transition::new(372859200, 5),
            Transition::new(388587600, 6),
            Transition::new(404913600, 5),
            Transition::new(420037200, 6),
            Transition::new(436363200, 7),
            Transition::new(439030800, 9),
            Transition::new(452084400, 8),
            Transition::new(467805600, 9),
            Transition::new(483534000, 8),
            Transition::new(499255200, 9),
            Transition::new(514983600, 8),
            Transition::new(530704800, 9),
            Transition::new(544618800, 8),
            Transition::new(562154400, 9),
            Transition::new(576068400, 8),
            Transition::new(594208800, 9),
            Transition::new(607518000, 8),
            Transition::new(625658400, 9),
            Transition::new(638967600, 8),
            Transition::new(657108000, 9),
            Transition::new(671022000, 8),
            Transition::new(688557600, 9),
            Transition::new(702471600, 8),
            Transition::new(720007200, 9),
            Transition::new(733921200, 8),
            Transition::new(752061600, 9),
            Transition::new(765370800, 8),
            Transition::new(783511200, 9),
            Transition::new(796820400, 8),
            Transition::new(814960800, 9),
            Transition::new(828874800, 8),
            Transition::new(846410400, 9),
            Transition::new(860324400, 8),
            Transition::new(877860000, 9),
            Transition::new(891774000, 8),
            Transition::new(909309600, 9),
            Transition::new(923223600, 8),
            Transition::new(941364000, 9),
            Transition::new(954673200, 8),
            Transition::new(972813600, 9),
            Transition::new(986122800, 8),
            Transition::new(1004263200, 9),
            Transition::new(1018177200, 8),
            Transition::new(1035712800, 9),
            Transition::new(1049626800, 8),
            Transition::new(1067162400, 9),
            Transition::new(1081076400, 8),
            Transition::new(1099216800, 9),
            Transition::new(1112526000, 8),
            Transition::new(1130666400, 9),
            Transition::new(1143975600, 8),
            Transition::new(1162116000, 9),
            Transition::new(1173610800, 8),
        ],
        &{
            const V: [LocalTimeType; 10] = [
                match LocalTimeType::new(46702, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-39698, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-39600, false, Some(b"NST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, true, Some(b"NWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, true, Some(b"NPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-39600, false, Some(b"BST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, true, Some(b"BDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"YST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_NORONHA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767217820, 2),
            Transition::new(-1206961200, 1),
            Transition::new(-1191366000, 2),
            Transition::new(-1175378400, 1),
            Transition::new(-1159830000, 2),
            Transition::new(-633823200, 1),
            Transition::new(-622072800, 2),
            Transition::new(-602287200, 1),
            Transition::new(-591836400, 2),
            Transition::new(-570751200, 1),
            Transition::new(-560214000, 2),
            Transition::new(-539128800, 1),
            Transition::new(-531356400, 2),
            Transition::new(-191368800, 1),
            Transition::new(-184201200, 2),
            Transition::new(-155167200, 1),
            Transition::new(-150073200, 2),
            Transition::new(-128901600, 1),
            Transition::new(-121129200, 2),
            Transition::new(-99957600, 1),
            Transition::new(-89593200, 2),
            Transition::new(-68421600, 1),
            Transition::new(-57970800, 2),
            Transition::new(499744800, 1),
            Transition::new(511232400, 2),
            Transition::new(530589600, 1),
            Transition::new(540262800, 2),
            Transition::new(562125600, 1),
            Transition::new(571194000, 2),
            Transition::new(592970400, 1),
            Transition::new(602038800, 2),
            Transition::new(624420000, 1),
            Transition::new(634698000, 2),
            Transition::new(938916000, 1),
            Transition::new(951613200, 2),
            Transition::new(970970400, 1),
            Transition::new(971571600, 2),
            Transition::new(1003024800, 1),
            Transition::new(1013907600, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-7780, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, true, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, false, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-7200, false, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_OJINAGA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514739600, 1),
            Transition::new(-1343066400, 2),
            Transition::new(-1234807200, 1),
            Transition::new(-1220292000, 2),
            Transition::new(-1207159200, 1),
            Transition::new(-1191344400, 2),
            Transition::new(828864000, 3),
            Transition::new(846399600, 2),
            Transition::new(860313600, 3),
            Transition::new(877849200, 2),
            Transition::new(891766800, 4),
            Transition::new(909302400, 1),
            Transition::new(923216400, 4),
            Transition::new(941356800, 1),
            Transition::new(954666000, 4),
            Transition::new(972806400, 1),
            Transition::new(989139600, 4),
            Transition::new(1001836800, 1),
            Transition::new(1018170000, 4),
            Transition::new(1035705600, 1),
            Transition::new(1049619600, 4),
            Transition::new(1067155200, 1),
            Transition::new(1081069200, 4),
            Transition::new(1099209600, 1),
            Transition::new(1112518800, 4),
            Transition::new(1130659200, 1),
            Transition::new(1143968400, 4),
            Transition::new(1162108800, 1),
            Transition::new(1175418000, 4),
            Transition::new(1193558400, 1),
            Transition::new(1207472400, 4),
            Transition::new(1225008000, 1),
            Transition::new(1238922000, 4),
            Transition::new(1256457600, 1),
            Transition::new(1268557200, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-25060, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_PANAMA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524502512, 1),
            Transition::new(-1946918424, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-19088, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-19176, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_PANGNIRTUNG: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1546300800, 3),
            Transition::new(-880221600, 1),
            Transition::new(-769395600, 2),
            Transition::new(-765399600, 3),
            Transition::new(-147902400, 4),
            Transition::new(-131572800, 3),
            Transition::new(325663200, 5),
            Transition::new(341384400, 3),
            Transition::new(357112800, 5),
            Transition::new(372834000, 3),
            Transition::new(388562400, 5),
            Transition::new(404888400, 3),
            Transition::new(420012000, 5),
            Transition::new(436338000, 3),
            Transition::new(452066400, 5),
            Transition::new(467787600, 3),
            Transition::new(483516000, 5),
            Transition::new(499237200, 3),
            Transition::new(514965600, 5),
            Transition::new(530686800, 3),
            Transition::new(544600800, 5),
            Transition::new(562136400, 3),
            Transition::new(576050400, 5),
            Transition::new(594190800, 3),
            Transition::new(607500000, 5),
            Transition::new(625640400, 3),
            Transition::new(638949600, 5),
            Transition::new(657090000, 3),
            Transition::new(671004000, 5),
            Transition::new(688539600, 3),
            Transition::new(702453600, 5),
            Transition::new(719989200, 3),
            Transition::new(733903200, 5),
            Transition::new(752043600, 3),
            Transition::new(765352800, 5),
            Transition::new(783493200, 3),
            Transition::new(796802400, 6),
            Transition::new(814946400, 7),
            Transition::new(828860400, 6),
            Transition::new(846396000, 7),
            Transition::new(860310000, 6),
            Transition::new(877845600, 7),
            Transition::new(891759600, 6),
            Transition::new(909295200, 7),
            Transition::new(923209200, 6),
            Transition::new(941349600, 8),
            Transition::new(954662400, 9),
            Transition::new(972802800, 7),
            Transition::new(986108400, 6),
            Transition::new(1004248800, 7),
            Transition::new(1018162800, 6),
            Transition::new(1035698400, 7),
            Transition::new(1049612400, 6),
            Transition::new(1067148000, 7),
            Transition::new(1081062000, 6),
            Transition::new(1099202400, 7),
            Transition::new(1112511600, 6),
            Transition::new(1130652000, 7),
            Transition::new(1143961200, 6),
            Transition::new(1162101600, 7),
            Transition::new(1173596400, 6),
        ],
        &{
            const V: [LocalTimeType; 10] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"AWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"APT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"ADDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_PARAMARIBO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1861906760, 1),
            Transition::new(-1104524348, 2),
            Transition::new(-765317964, 3),
            Transition::new(465449400, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-13240, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-13252, false, Some(b"PMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-13236, false, Some(b"PMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-12600, false, Some(b"-0330")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_PHOENIX: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2717643600, 2),
            Transition::new(-1633273200, 1),
            Transition::new(-1615132800, 2),
            Transition::new(-1601823600, 1),
            Transition::new(-1583683200, 2),
            Transition::new(-880210800, 3),
            Transition::new(-820519140, 2),
            Transition::new(-812653140, 3),
            Transition::new(-796845540, 2),
            Transition::new(-84380400, 1),
            Transition::new(-68659200, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-26898, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_PORTO_ACRE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767209328, 2),
            Transition::new(-1206950400, 1),
            Transition::new(-1191355200, 2),
            Transition::new(-1175367600, 1),
            Transition::new(-1159819200, 2),
            Transition::new(-633812400, 1),
            Transition::new(-622062000, 2),
            Transition::new(-602276400, 1),
            Transition::new(-591825600, 2),
            Transition::new(-570740400, 1),
            Transition::new(-560203200, 2),
            Transition::new(-539118000, 1),
            Transition::new(-531345600, 2),
            Transition::new(-191358000, 1),
            Transition::new(-184190400, 2),
            Transition::new(-155156400, 1),
            Transition::new(-150062400, 2),
            Transition::new(-128890800, 1),
            Transition::new(-121118400, 2),
            Transition::new(-99946800, 1),
            Transition::new(-89582400, 2),
            Transition::new(-68410800, 1),
            Transition::new(-57960000, 2),
            Transition::new(499755600, 1),
            Transition::new(511243200, 2),
            Transition::new(530600400, 1),
            Transition::new(540273600, 2),
            Transition::new(562136400, 1),
            Transition::new(571204800, 2),
            Transition::new(1214283600, 3),
            Transition::new(1384056000, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-16272, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_PORTO_VELHO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767210264, 2),
            Transition::new(-1206954000, 1),
            Transition::new(-1191358800, 2),
            Transition::new(-1175371200, 1),
            Transition::new(-1159822800, 2),
            Transition::new(-633816000, 1),
            Transition::new(-622065600, 2),
            Transition::new(-602280000, 1),
            Transition::new(-591829200, 2),
            Transition::new(-570744000, 1),
            Transition::new(-560206800, 2),
            Transition::new(-539121600, 1),
            Transition::new(-531349200, 2),
            Transition::new(-191361600, 1),
            Transition::new(-184194000, 2),
            Transition::new(-155160000, 1),
            Transition::new(-150066000, 2),
            Transition::new(-128894400, 1),
            Transition::new(-121122000, 2),
            Transition::new(-99950400, 1),
            Transition::new(-89586000, 2),
            Transition::new(-68414400, 1),
            Transition::new(-57963600, 2),
            Transition::new(499752000, 1),
            Transition::new(511239600, 2),
            Transition::new(530596800, 1),
            Transition::new(540270000, 2),
            Transition::new(562132800, 1),
            Transition::new(571201200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-15336, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_PORT_AU_PRINCE: TimeZoneRef<'static> =
        match TimeZoneRef::<'static>::new(
            &[
                Transition::new(-2524504240, 1),
                Transition::new(-1670483460, 3),
                Transition::new(421218000, 2),
                Transition::new(436334400, 3),
                Transition::new(452062800, 2),
                Transition::new(467784000, 3),
                Transition::new(483512400, 2),
                Transition::new(499233600, 3),
                Transition::new(514962000, 2),
                Transition::new(530683200, 3),
                Transition::new(546411600, 2),
                Transition::new(562132800, 3),
                Transition::new(576050400, 2),
                Transition::new(594194400, 3),
                Transition::new(607500000, 2),
                Transition::new(625644000, 3),
                Transition::new(638949600, 2),
                Transition::new(657093600, 3),
                Transition::new(671004000, 2),
                Transition::new(688543200, 3),
                Transition::new(702453600, 2),
                Transition::new(719992800, 3),
                Transition::new(733903200, 2),
                Transition::new(752047200, 3),
                Transition::new(765352800, 2),
                Transition::new(783496800, 3),
                Transition::new(796802400, 2),
                Transition::new(814946400, 3),
                Transition::new(828856800, 2),
                Transition::new(846396000, 3),
                Transition::new(860306400, 2),
                Transition::new(877845600, 3),
                Transition::new(1112504400, 2),
                Transition::new(1130644800, 3),
                Transition::new(1143954000, 2),
                Transition::new(1162094400, 3),
                Transition::new(1331449200, 2),
                Transition::new(1352008800, 3),
                Transition::new(1362898800, 2),
                Transition::new(1383458400, 3),
                Transition::new(1394348400, 2),
                Transition::new(1414908000, 3),
                Transition::new(1425798000, 2),
                Transition::new(1446357600, 3),
                Transition::new(1489302000, 2),
            ],
            &{
                const V: [LocalTimeType; 4] = [
                    match LocalTimeType::new(-17360, false, Some(b"LMT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-17340, false, Some(b"PPMT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                ];
                V
            },
            &[],
            &Some({
                const V: TransitionRule = TransitionRule::Alternate(
                    match AlternateTime::new(
                        match LocalTimeType::new(-18000, false, Some(b"EST")) {
                            Ok(v) => v,
                            Err(e) => panic!("{}", e.0),
                        },
                        match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                            Ok(v) => v,
                            Err(e) => panic!("{}", e.0),
                        },
                        RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                            Ok(v) => v,
                            Err(e) => panic!("{}", e.0),
                        }),
                        7200,
                        RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                            Ok(v) => v,
                            Err(e) => panic!("{}", e.0),
                        }),
                        7200,
                    ) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                );
                V
            }),
        ) {
            Ok(v) => v,
            Err(e) => panic!("{}", e.0),
        };

    pub(crate) const AMERICA_PUERTO_RICO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2233035335, 1),
            Transition::new(-873057600, 3),
            Transition::new(-769395600, 2),
            Transition::new(-765399600, 1),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-15865, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"APT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"AWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_PUNTA_ARENAS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524504580, 1),
            Transition::new(-1892661435, 2),
            Transition::new(-1688410800, 1),
            Transition::new(-1619205435, 3),
            Transition::new(-1593806400, 1),
            Transition::new(-1335986235, 4),
            Transition::new(-1317585600, 2),
            Transition::new(-1304362800, 4),
            Transition::new(-1286049600, 2),
            Transition::new(-1272826800, 4),
            Transition::new(-1254513600, 2),
            Transition::new(-1241290800, 4),
            Transition::new(-1222977600, 2),
            Transition::new(-1209754800, 4),
            Transition::new(-1191355200, 2),
            Transition::new(-1178132400, 3),
            Transition::new(-870552000, 2),
            Transition::new(-865278000, 3),
            Transition::new(-718056000, 2),
            Transition::new(-713649600, 3),
            Transition::new(-36619200, 5),
            Transition::new(-23922000, 3),
            Transition::new(-3355200, 5),
            Transition::new(7527600, 3),
            Transition::new(24465600, 5),
            Transition::new(37767600, 3),
            Transition::new(55915200, 5),
            Transition::new(69217200, 3),
            Transition::new(87969600, 5),
            Transition::new(100666800, 3),
            Transition::new(118209600, 5),
            Transition::new(132116400, 3),
            Transition::new(150868800, 5),
            Transition::new(163566000, 3),
            Transition::new(182318400, 5),
            Transition::new(195620400, 3),
            Transition::new(213768000, 5),
            Transition::new(227070000, 3),
            Transition::new(245217600, 5),
            Transition::new(258519600, 3),
            Transition::new(277272000, 5),
            Transition::new(289969200, 3),
            Transition::new(308721600, 5),
            Transition::new(321418800, 3),
            Transition::new(340171200, 5),
            Transition::new(353473200, 3),
            Transition::new(371620800, 5),
            Transition::new(384922800, 3),
            Transition::new(403070400, 5),
            Transition::new(416372400, 3),
            Transition::new(434520000, 5),
            Transition::new(447822000, 3),
            Transition::new(466574400, 5),
            Transition::new(479271600, 3),
            Transition::new(498024000, 5),
            Transition::new(510721200, 3),
            Transition::new(529473600, 5),
            Transition::new(545194800, 3),
            Transition::new(560923200, 5),
            Transition::new(574225200, 3),
            Transition::new(592372800, 5),
            Transition::new(605674800, 3),
            Transition::new(624427200, 5),
            Transition::new(637124400, 3),
            Transition::new(653457600, 5),
            Transition::new(668574000, 3),
            Transition::new(687326400, 5),
            Transition::new(700628400, 3),
            Transition::new(718776000, 5),
            Transition::new(732078000, 3),
            Transition::new(750225600, 5),
            Transition::new(763527600, 3),
            Transition::new(781675200, 5),
            Transition::new(794977200, 3),
            Transition::new(813729600, 5),
            Transition::new(826426800, 3),
            Transition::new(845179200, 5),
            Transition::new(859690800, 3),
            Transition::new(876628800, 5),
            Transition::new(889930800, 3),
            Transition::new(906868800, 5),
            Transition::new(923194800, 3),
            Transition::new(939528000, 5),
            Transition::new(952830000, 3),
            Transition::new(971582400, 5),
            Transition::new(984279600, 3),
            Transition::new(1003032000, 5),
            Transition::new(1015729200, 3),
            Transition::new(1034481600, 5),
            Transition::new(1047178800, 3),
            Transition::new(1065931200, 5),
            Transition::new(1079233200, 3),
            Transition::new(1097380800, 5),
            Transition::new(1110682800, 3),
            Transition::new(1128830400, 5),
            Transition::new(1142132400, 3),
            Transition::new(1160884800, 5),
            Transition::new(1173582000, 3),
            Transition::new(1192334400, 5),
            Transition::new(1206846000, 3),
            Transition::new(1223784000, 5),
            Transition::new(1237086000, 3),
            Transition::new(1255233600, 5),
            Transition::new(1270350000, 3),
            Transition::new(1286683200, 5),
            Transition::new(1304823600, 3),
            Transition::new(1313899200, 5),
            Transition::new(1335668400, 3),
            Transition::new(1346558400, 5),
            Transition::new(1367118000, 3),
            Transition::new(1378612800, 5),
            Transition::new(1398567600, 3),
            Transition::new(1410062400, 5),
            Transition::new(1463281200, 3),
            Transition::new(1471147200, 5),
            Transition::new(1480820400, 6),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(-17020, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-16965, false, Some(b"SMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_RAINY_RIVER: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2366732504, 2),
            Transition::new(-1632067200, 1),
            Transition::new(-1615136400, 2),
            Transition::new(-923248800, 1),
            Transition::new(-880214400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765392400, 2),
            Transition::new(136368000, 1),
            Transition::new(152089200, 2),
            Transition::new(167817600, 1),
            Transition::new(183538800, 2),
            Transition::new(199267200, 1),
            Transition::new(215593200, 2),
            Transition::new(230716800, 1),
            Transition::new(247042800, 2),
            Transition::new(262771200, 1),
            Transition::new(278492400, 2),
            Transition::new(294220800, 1),
            Transition::new(309942000, 2),
            Transition::new(325670400, 1),
            Transition::new(341391600, 2),
            Transition::new(357120000, 1),
            Transition::new(372841200, 2),
            Transition::new(388569600, 1),
            Transition::new(404895600, 2),
            Transition::new(420019200, 1),
            Transition::new(436345200, 2),
            Transition::new(452073600, 1),
            Transition::new(467794800, 2),
            Transition::new(483523200, 1),
            Transition::new(499244400, 2),
            Transition::new(514972800, 1),
            Transition::new(530694000, 2),
            Transition::new(544608000, 1),
            Transition::new(562143600, 2),
            Transition::new(576057600, 1),
            Transition::new(594198000, 2),
            Transition::new(607507200, 1),
            Transition::new(625647600, 2),
            Transition::new(638956800, 1),
            Transition::new(657097200, 2),
            Transition::new(671011200, 1),
            Transition::new(688546800, 2),
            Transition::new(702460800, 1),
            Transition::new(719996400, 2),
            Transition::new(733910400, 1),
            Transition::new(752050800, 2),
            Transition::new(765360000, 1),
            Transition::new(783500400, 2),
            Transition::new(796809600, 1),
            Transition::new(814950000, 2),
            Transition::new(828864000, 1),
            Transition::new(846399600, 2),
            Transition::new(860313600, 1),
            Transition::new(877849200, 2),
            Transition::new(891763200, 1),
            Transition::new(909298800, 2),
            Transition::new(923212800, 1),
            Transition::new(941353200, 2),
            Transition::new(954662400, 1),
            Transition::new(972802800, 2),
            Transition::new(986112000, 1),
            Transition::new(1004252400, 2),
            Transition::new(1018166400, 1),
            Transition::new(1035702000, 2),
            Transition::new(1049616000, 1),
            Transition::new(1067151600, 2),
            Transition::new(1081065600, 1),
            Transition::new(1099206000, 2),
            Transition::new(1112515200, 1),
            Transition::new(1130655600, 2),
            Transition::new(1143964800, 1),
            Transition::new(1162105200, 2),
            Transition::new(1173600000, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-22696, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_RANKIN_INLET: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-410227200, 2),
            Transition::new(-147895200, 1),
            Transition::new(-131565600, 2),
            Transition::new(325670400, 3),
            Transition::new(341391600, 2),
            Transition::new(357120000, 3),
            Transition::new(372841200, 2),
            Transition::new(388569600, 3),
            Transition::new(404895600, 2),
            Transition::new(420019200, 3),
            Transition::new(436345200, 2),
            Transition::new(452073600, 3),
            Transition::new(467794800, 2),
            Transition::new(483523200, 3),
            Transition::new(499244400, 2),
            Transition::new(514972800, 3),
            Transition::new(530694000, 2),
            Transition::new(544608000, 3),
            Transition::new(562143600, 2),
            Transition::new(576057600, 3),
            Transition::new(594198000, 2),
            Transition::new(607507200, 3),
            Transition::new(625647600, 2),
            Transition::new(638956800, 3),
            Transition::new(657097200, 2),
            Transition::new(671011200, 3),
            Transition::new(688546800, 2),
            Transition::new(702460800, 3),
            Transition::new(719996400, 2),
            Transition::new(733910400, 3),
            Transition::new(752050800, 2),
            Transition::new(765360000, 3),
            Transition::new(783500400, 2),
            Transition::new(796809600, 3),
            Transition::new(814950000, 2),
            Transition::new(828864000, 3),
            Transition::new(846399600, 2),
            Transition::new(860313600, 3),
            Transition::new(877849200, 2),
            Transition::new(891763200, 3),
            Transition::new(909298800, 2),
            Transition::new(923212800, 3),
            Transition::new(941353200, 2),
            Transition::new(954662400, 3),
            Transition::new(972802800, 4),
            Transition::new(986112000, 3),
            Transition::new(1004252400, 2),
            Transition::new(1018166400, 3),
            Transition::new(1035702000, 2),
            Transition::new(1049616000, 3),
            Transition::new(1067151600, 2),
            Transition::new(1081065600, 3),
            Transition::new(1099206000, 2),
            Transition::new(1112515200, 3),
            Transition::new(1130655600, 2),
            Transition::new(1143964800, 3),
            Transition::new(1162105200, 2),
            Transition::new(1173600000, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"CDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_RECIFE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767217224, 2),
            Transition::new(-1206957600, 1),
            Transition::new(-1191362400, 2),
            Transition::new(-1175374800, 1),
            Transition::new(-1159826400, 2),
            Transition::new(-633819600, 1),
            Transition::new(-622069200, 2),
            Transition::new(-602283600, 1),
            Transition::new(-591832800, 2),
            Transition::new(-570747600, 1),
            Transition::new(-560210400, 2),
            Transition::new(-539125200, 1),
            Transition::new(-531352800, 2),
            Transition::new(-191365200, 1),
            Transition::new(-184197600, 2),
            Transition::new(-155163600, 1),
            Transition::new(-150069600, 2),
            Transition::new(-128898000, 1),
            Transition::new(-121125600, 2),
            Transition::new(-99954000, 1),
            Transition::new(-89589600, 2),
            Transition::new(-68418000, 1),
            Transition::new(-57967200, 2),
            Transition::new(499748400, 1),
            Transition::new(511236000, 2),
            Transition::new(530593200, 1),
            Transition::new(540266400, 2),
            Transition::new(562129200, 1),
            Transition::new(571197600, 2),
            Transition::new(592974000, 1),
            Transition::new(602042400, 2),
            Transition::new(624423600, 1),
            Transition::new(634701600, 2),
            Transition::new(938919600, 1),
            Transition::new(951616800, 2),
            Transition::new(970974000, 1),
            Transition::new(971575200, 2),
            Transition::new(1003028400, 1),
            Transition::new(1013911200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-8376, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_REGINA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2030202084, 2),
            Transition::new(-1632063600, 1),
            Transition::new(-1615132800, 2),
            Transition::new(-1251651600, 1),
            Transition::new(-1238349600, 2),
            Transition::new(-1220202000, 1),
            Transition::new(-1206900000, 2),
            Transition::new(-1188752400, 1),
            Transition::new(-1175450400, 2),
            Transition::new(-1156698000, 1),
            Transition::new(-1144000800, 2),
            Transition::new(-1125248400, 1),
            Transition::new(-1111946400, 2),
            Transition::new(-1032714000, 1),
            Transition::new(-1016992800, 2),
            Transition::new(-1001264400, 1),
            Transition::new(-986148000, 2),
            Transition::new(-969814800, 1),
            Transition::new(-954093600, 2),
            Transition::new(-937760400, 1),
            Transition::new(-922039200, 2),
            Transition::new(-906310800, 1),
            Transition::new(-890589600, 2),
            Transition::new(-880210800, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765388800, 2),
            Transition::new(-748450800, 1),
            Transition::new(-732729600, 2),
            Transition::new(-715791600, 1),
            Transition::new(-702489600, 2),
            Transition::new(-684342000, 1),
            Transition::new(-671040000, 2),
            Transition::new(-652892400, 1),
            Transition::new(-639590400, 2),
            Transition::new(-620838000, 1),
            Transition::new(-608140800, 2),
            Transition::new(-589388400, 1),
            Transition::new(-576086400, 2),
            Transition::new(-557938800, 1),
            Transition::new(-544636800, 2),
            Transition::new(-526489200, 1),
            Transition::new(-513187200, 2),
            Transition::new(-495039600, 1),
            Transition::new(-481737600, 2),
            Transition::new(-463590000, 1),
            Transition::new(-450288000, 2),
            Transition::new(-431535600, 1),
            Transition::new(-418233600, 2),
            Transition::new(-400086000, 1),
            Transition::new(-386784000, 2),
            Transition::new(-337186800, 1),
            Transition::new(-321465600, 2),
            Transition::new(-305737200, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-25116, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_RESOLUTE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-704937600, 2),
            Transition::new(-147895200, 1),
            Transition::new(-131565600, 2),
            Transition::new(325670400, 3),
            Transition::new(341391600, 2),
            Transition::new(357120000, 3),
            Transition::new(372841200, 2),
            Transition::new(388569600, 3),
            Transition::new(404895600, 2),
            Transition::new(420019200, 3),
            Transition::new(436345200, 2),
            Transition::new(452073600, 3),
            Transition::new(467794800, 2),
            Transition::new(483523200, 3),
            Transition::new(499244400, 2),
            Transition::new(514972800, 3),
            Transition::new(530694000, 2),
            Transition::new(544608000, 3),
            Transition::new(562143600, 2),
            Transition::new(576057600, 3),
            Transition::new(594198000, 2),
            Transition::new(607507200, 3),
            Transition::new(625647600, 2),
            Transition::new(638956800, 3),
            Transition::new(657097200, 2),
            Transition::new(671011200, 3),
            Transition::new(688546800, 2),
            Transition::new(702460800, 3),
            Transition::new(719996400, 2),
            Transition::new(733910400, 3),
            Transition::new(752050800, 2),
            Transition::new(765360000, 3),
            Transition::new(783500400, 2),
            Transition::new(796809600, 3),
            Transition::new(814950000, 2),
            Transition::new(828864000, 3),
            Transition::new(846399600, 2),
            Transition::new(860313600, 3),
            Transition::new(877849200, 2),
            Transition::new(891763200, 3),
            Transition::new(909298800, 2),
            Transition::new(923212800, 3),
            Transition::new(941353200, 2),
            Transition::new(954662400, 3),
            Transition::new(972802800, 4),
            Transition::new(986112000, 3),
            Transition::new(1004252400, 2),
            Transition::new(1018166400, 3),
            Transition::new(1035702000, 2),
            Transition::new(1049616000, 3),
            Transition::new(1067151600, 2),
            Transition::new(1081065600, 3),
            Transition::new(1099206000, 2),
            Transition::new(1112515200, 3),
            Transition::new(1130655600, 2),
            Transition::new(1143964800, 3),
            Transition::new(1162105200, 4),
            Transition::new(1173600000, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"CDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ROSARIO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2372011040, 1),
            Transition::new(-1567453396, 2),
            Transition::new(-1233432000, 3),
            Transition::new(-1222981200, 2),
            Transition::new(-1205956800, 3),
            Transition::new(-1194037200, 2),
            Transition::new(-1172865600, 3),
            Transition::new(-1162501200, 2),
            Transition::new(-1141329600, 3),
            Transition::new(-1130965200, 2),
            Transition::new(-1109793600, 3),
            Transition::new(-1099429200, 2),
            Transition::new(-1078257600, 3),
            Transition::new(-1067806800, 2),
            Transition::new(-1046635200, 3),
            Transition::new(-1036270800, 2),
            Transition::new(-1015099200, 3),
            Transition::new(-1004734800, 2),
            Transition::new(-983563200, 3),
            Transition::new(-973198800, 2),
            Transition::new(-952027200, 3),
            Transition::new(-941576400, 2),
            Transition::new(-931032000, 3),
            Transition::new(-900882000, 2),
            Transition::new(-890337600, 3),
            Transition::new(-833749200, 2),
            Transition::new(-827265600, 3),
            Transition::new(-752274000, 2),
            Transition::new(-733780800, 3),
            Transition::new(-197326800, 2),
            Transition::new(-190843200, 3),
            Transition::new(-184194000, 2),
            Transition::new(-164491200, 3),
            Transition::new(-152658000, 2),
            Transition::new(-132955200, 3),
            Transition::new(-121122000, 2),
            Transition::new(-101419200, 3),
            Transition::new(-86821200, 2),
            Transition::new(-71092800, 3),
            Transition::new(-54766800, 2),
            Transition::new(-39038400, 3),
            Transition::new(-23317200, 2),
            Transition::new(-7588800, 5),
            Transition::new(128142000, 4),
            Transition::new(136605600, 5),
            Transition::new(596948400, 4),
            Transition::new(605066400, 5),
            Transition::new(624423600, 4),
            Transition::new(636516000, 5),
            Transition::new(656478000, 4),
            Transition::new(667965600, 5),
            Transition::new(938919600, 3),
            Transition::new(952052400, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-14560, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-15404, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_SANTAREM: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767212472, 2),
            Transition::new(-1206954000, 1),
            Transition::new(-1191358800, 2),
            Transition::new(-1175371200, 1),
            Transition::new(-1159822800, 2),
            Transition::new(-633816000, 1),
            Transition::new(-622065600, 2),
            Transition::new(-602280000, 1),
            Transition::new(-591829200, 2),
            Transition::new(-570744000, 1),
            Transition::new(-560206800, 2),
            Transition::new(-539121600, 1),
            Transition::new(-531349200, 2),
            Transition::new(-191361600, 1),
            Transition::new(-184194000, 2),
            Transition::new(-155160000, 1),
            Transition::new(-150066000, 2),
            Transition::new(-128894400, 1),
            Transition::new(-121122000, 2),
            Transition::new(-99950400, 1),
            Transition::new(-89586000, 2),
            Transition::new(-68414400, 1),
            Transition::new(-57963600, 2),
            Transition::new(499752000, 1),
            Transition::new(511239600, 2),
            Transition::new(530596800, 1),
            Transition::new(540270000, 2),
            Transition::new(562132800, 1),
            Transition::new(571201200, 2),
            Transition::new(1214280000, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-13128, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_SANTA_ISABEL: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514736000, 1),
            Transition::new(-1451667600, 2),
            Transition::new(-1343062800, 1),
            Transition::new(-1234803600, 2),
            Transition::new(-1222963200, 3),
            Transition::new(-1207242000, 2),
            Transition::new(-873820800, 4),
            Transition::new(-769395600, 5),
            Transition::new(-761677200, 2),
            Transition::new(-686073600, 3),
            Transition::new(-661539600, 2),
            Transition::new(-495039600, 3),
            Transition::new(-481734000, 2),
            Transition::new(-463590000, 3),
            Transition::new(-450284400, 2),
            Transition::new(-431535600, 3),
            Transition::new(-418230000, 2),
            Transition::new(-400086000, 3),
            Transition::new(-386780400, 2),
            Transition::new(-368636400, 3),
            Transition::new(-355330800, 2),
            Transition::new(-337186800, 3),
            Transition::new(-323881200, 2),
            Transition::new(-305737200, 3),
            Transition::new(-292431600, 2),
            Transition::new(199274400, 3),
            Transition::new(215600400, 2),
            Transition::new(230724000, 3),
            Transition::new(247050000, 2),
            Transition::new(262778400, 3),
            Transition::new(278499600, 2),
            Transition::new(294228000, 3),
            Transition::new(309949200, 2),
            Transition::new(325677600, 3),
            Transition::new(341398800, 2),
            Transition::new(357127200, 3),
            Transition::new(372848400, 2),
            Transition::new(388576800, 3),
            Transition::new(404902800, 2),
            Transition::new(420026400, 3),
            Transition::new(436352400, 2),
            Transition::new(452080800, 3),
            Transition::new(467802000, 2),
            Transition::new(483530400, 3),
            Transition::new(499251600, 2),
            Transition::new(514980000, 3),
            Transition::new(530701200, 2),
            Transition::new(544615200, 3),
            Transition::new(562150800, 2),
            Transition::new(576064800, 3),
            Transition::new(594205200, 2),
            Transition::new(607514400, 3),
            Transition::new(625654800, 2),
            Transition::new(638964000, 3),
            Transition::new(657104400, 2),
            Transition::new(671018400, 3),
            Transition::new(688554000, 2),
            Transition::new(702468000, 3),
            Transition::new(720003600, 2),
            Transition::new(733917600, 3),
            Transition::new(752058000, 2),
            Transition::new(765367200, 3),
            Transition::new(783507600, 2),
            Transition::new(796816800, 3),
            Transition::new(814957200, 2),
            Transition::new(828871200, 3),
            Transition::new(846406800, 2),
            Transition::new(860320800, 3),
            Transition::new(877856400, 2),
            Transition::new(891770400, 3),
            Transition::new(909306000, 2),
            Transition::new(923220000, 3),
            Transition::new(941360400, 2),
            Transition::new(954669600, 3),
            Transition::new(972810000, 2),
            Transition::new(986119200, 3),
            Transition::new(1004259600, 2),
            Transition::new(1018173600, 3),
            Transition::new(1035709200, 2),
            Transition::new(1049623200, 3),
            Transition::new(1067158800, 2),
            Transition::new(1081072800, 3),
            Transition::new(1099213200, 2),
            Transition::new(1112522400, 3),
            Transition::new(1130662800, 2),
            Transition::new(1143972000, 3),
            Transition::new(1162112400, 2),
            Transition::new(1175421600, 3),
            Transition::new(1193562000, 2),
            Transition::new(1207476000, 3),
            Transition::new(1225011600, 2),
            Transition::new(1238925600, 3),
            Transition::new(1256461200, 2),
            Transition::new(1268560800, 3),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-28084, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-28800, false, Some(b"PST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_SANTIAGO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524504635, 1),
            Transition::new(-1892661435, 2),
            Transition::new(-1688410800, 1),
            Transition::new(-1619205435, 3),
            Transition::new(-1593806400, 1),
            Transition::new(-1335986235, 4),
            Transition::new(-1317585600, 2),
            Transition::new(-1304362800, 4),
            Transition::new(-1286049600, 2),
            Transition::new(-1272826800, 4),
            Transition::new(-1254513600, 2),
            Transition::new(-1241290800, 4),
            Transition::new(-1222977600, 2),
            Transition::new(-1209754800, 4),
            Transition::new(-1191355200, 2),
            Transition::new(-1178132400, 3),
            Transition::new(-870552000, 2),
            Transition::new(-865278000, 3),
            Transition::new(-740520000, 5),
            Transition::new(-736376400, 3),
            Transition::new(-718056000, 2),
            Transition::new(-713649600, 3),
            Transition::new(-36619200, 5),
            Transition::new(-23922000, 3),
            Transition::new(-3355200, 5),
            Transition::new(7527600, 3),
            Transition::new(24465600, 5),
            Transition::new(37767600, 3),
            Transition::new(55915200, 5),
            Transition::new(69217200, 3),
            Transition::new(87969600, 5),
            Transition::new(100666800, 3),
            Transition::new(118209600, 5),
            Transition::new(132116400, 3),
            Transition::new(150868800, 5),
            Transition::new(163566000, 3),
            Transition::new(182318400, 5),
            Transition::new(195620400, 3),
            Transition::new(213768000, 5),
            Transition::new(227070000, 3),
            Transition::new(245217600, 5),
            Transition::new(258519600, 3),
            Transition::new(277272000, 5),
            Transition::new(289969200, 3),
            Transition::new(308721600, 5),
            Transition::new(321418800, 3),
            Transition::new(340171200, 5),
            Transition::new(353473200, 3),
            Transition::new(371620800, 5),
            Transition::new(384922800, 3),
            Transition::new(403070400, 5),
            Transition::new(416372400, 3),
            Transition::new(434520000, 5),
            Transition::new(447822000, 3),
            Transition::new(466574400, 5),
            Transition::new(479271600, 3),
            Transition::new(498024000, 5),
            Transition::new(510721200, 3),
            Transition::new(529473600, 5),
            Transition::new(545194800, 3),
            Transition::new(560923200, 5),
            Transition::new(574225200, 3),
            Transition::new(592372800, 5),
            Transition::new(605674800, 3),
            Transition::new(624427200, 5),
            Transition::new(637124400, 3),
            Transition::new(653457600, 5),
            Transition::new(668574000, 3),
            Transition::new(687326400, 5),
            Transition::new(700628400, 3),
            Transition::new(718776000, 5),
            Transition::new(732078000, 3),
            Transition::new(750225600, 5),
            Transition::new(763527600, 3),
            Transition::new(781675200, 5),
            Transition::new(794977200, 3),
            Transition::new(813729600, 5),
            Transition::new(826426800, 3),
            Transition::new(845179200, 5),
            Transition::new(859690800, 3),
            Transition::new(876628800, 5),
            Transition::new(889930800, 3),
            Transition::new(906868800, 5),
            Transition::new(923194800, 3),
            Transition::new(939528000, 5),
            Transition::new(952830000, 3),
            Transition::new(971582400, 5),
            Transition::new(984279600, 3),
            Transition::new(1003032000, 5),
            Transition::new(1015729200, 3),
            Transition::new(1034481600, 5),
            Transition::new(1047178800, 3),
            Transition::new(1065931200, 5),
            Transition::new(1079233200, 3),
            Transition::new(1097380800, 5),
            Transition::new(1110682800, 3),
            Transition::new(1128830400, 5),
            Transition::new(1142132400, 3),
            Transition::new(1160884800, 5),
            Transition::new(1173582000, 3),
            Transition::new(1192334400, 5),
            Transition::new(1206846000, 3),
            Transition::new(1223784000, 5),
            Transition::new(1237086000, 3),
            Transition::new(1255233600, 5),
            Transition::new(1270350000, 3),
            Transition::new(1286683200, 5),
            Transition::new(1304823600, 3),
            Transition::new(1313899200, 5),
            Transition::new(1335668400, 3),
            Transition::new(1346558400, 5),
            Transition::new(1367118000, 3),
            Transition::new(1378612800, 5),
            Transition::new(1398567600, 3),
            Transition::new(1410062400, 5),
            Transition::new(1463281200, 3),
            Transition::new(1471147200, 5),
            Transition::new(1494730800, 3),
            Transition::new(1502596800, 5),
            Transition::new(1526180400, 3),
            Transition::new(1534046400, 5),
            Transition::new(1554606000, 3),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-16965, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-16965, false, Some(b"SMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-14400, false, Some(b"-04")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-10800, true, Some(b"-03")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(9, 1, 6) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    86400,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 6) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    86400,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_SANTO_DOMINGO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524504824, 1),
            Transition::new(-1159773600, 3),
            Transition::new(-100119600, 2),
            Transition::new(-89668800, 3),
            Transition::new(-5770800, 4),
            Transition::new(4422600, 3),
            Transition::new(25678800, 4),
            Transition::new(33193800, 3),
            Transition::new(57733200, 4),
            Transition::new(64816200, 3),
            Transition::new(89182800, 4),
            Transition::new(96438600, 3),
            Transition::new(120632400, 4),
            Transition::new(127974600, 3),
            Transition::new(152082000, 5),
            Transition::new(972799200, 3),
            Transition::new(975823200, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-16776, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-16800, false, Some(b"SDMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-16200, true, Some(b"-0430")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_SAO_PAULO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767214412, 2),
            Transition::new(-1206957600, 1),
            Transition::new(-1191362400, 2),
            Transition::new(-1175374800, 1),
            Transition::new(-1159826400, 2),
            Transition::new(-633819600, 1),
            Transition::new(-622069200, 2),
            Transition::new(-602283600, 1),
            Transition::new(-591832800, 2),
            Transition::new(-570747600, 1),
            Transition::new(-560210400, 2),
            Transition::new(-539125200, 1),
            Transition::new(-531352800, 2),
            Transition::new(-195426000, 1),
            Transition::new(-184197600, 2),
            Transition::new(-155163600, 1),
            Transition::new(-150069600, 2),
            Transition::new(-128898000, 1),
            Transition::new(-121125600, 2),
            Transition::new(-99954000, 1),
            Transition::new(-89589600, 2),
            Transition::new(-68418000, 1),
            Transition::new(-57967200, 2),
            Transition::new(499748400, 1),
            Transition::new(511236000, 2),
            Transition::new(530593200, 1),
            Transition::new(540266400, 2),
            Transition::new(562129200, 1),
            Transition::new(571197600, 2),
            Transition::new(592974000, 1),
            Transition::new(602042400, 2),
            Transition::new(624423600, 1),
            Transition::new(634701600, 2),
            Transition::new(656478000, 1),
            Transition::new(666756000, 2),
            Transition::new(687927600, 1),
            Transition::new(697600800, 2),
            Transition::new(719982000, 1),
            Transition::new(728445600, 2),
            Transition::new(750826800, 1),
            Transition::new(761709600, 2),
            Transition::new(782276400, 1),
            Transition::new(793159200, 2),
            Transition::new(813726000, 1),
            Transition::new(824004000, 2),
            Transition::new(844570800, 1),
            Transition::new(856058400, 2),
            Transition::new(876106800, 1),
            Transition::new(888717600, 2),
            Transition::new(908074800, 1),
            Transition::new(919562400, 2),
            Transition::new(938919600, 1),
            Transition::new(951616800, 2),
            Transition::new(970974000, 1),
            Transition::new(982461600, 2),
            Transition::new(1003028400, 1),
            Transition::new(1013911200, 2),
            Transition::new(1036292400, 1),
            Transition::new(1045360800, 2),
            Transition::new(1066532400, 1),
            Transition::new(1076810400, 2),
            Transition::new(1099364400, 1),
            Transition::new(1108864800, 2),
            Transition::new(1129431600, 1),
            Transition::new(1140314400, 2),
            Transition::new(1162695600, 1),
            Transition::new(1172368800, 2),
            Transition::new(1192330800, 1),
            Transition::new(1203213600, 2),
            Transition::new(1224385200, 1),
            Transition::new(1234663200, 2),
            Transition::new(1255834800, 1),
            Transition::new(1266717600, 2),
            Transition::new(1287284400, 1),
            Transition::new(1298167200, 2),
            Transition::new(1318734000, 1),
            Transition::new(1330221600, 2),
            Transition::new(1350788400, 1),
            Transition::new(1361066400, 2),
            Transition::new(1382238000, 1),
            Transition::new(1392516000, 2),
            Transition::new(1413687600, 1),
            Transition::new(1424570400, 2),
            Transition::new(1445137200, 1),
            Transition::new(1456020000, 2),
            Transition::new(1476586800, 1),
            Transition::new(1487469600, 2),
            Transition::new(1508036400, 1),
            Transition::new(1518919200, 2),
            Transition::new(1541300400, 1),
            Transition::new(1550368800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-11188, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_SCORESBYSUND: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1686090728, 1),
            Transition::new(323841600, 2),
            Transition::new(338961600, 1),
            Transition::new(354679200, 4),
            Transition::new(370400400, 3),
            Transition::new(386125200, 4),
            Transition::new(401850000, 3),
            Transition::new(417574800, 4),
            Transition::new(433299600, 3),
            Transition::new(449024400, 4),
            Transition::new(465354000, 3),
            Transition::new(481078800, 4),
            Transition::new(496803600, 3),
            Transition::new(512528400, 4),
            Transition::new(528253200, 3),
            Transition::new(543978000, 4),
            Transition::new(559702800, 3),
            Transition::new(575427600, 4),
            Transition::new(591152400, 3),
            Transition::new(606877200, 4),
            Transition::new(622602000, 3),
            Transition::new(638326800, 4),
            Transition::new(654656400, 3),
            Transition::new(670381200, 4),
            Transition::new(686106000, 3),
            Transition::new(701830800, 4),
            Transition::new(717555600, 3),
            Transition::new(733280400, 4),
            Transition::new(749005200, 3),
            Transition::new(764730000, 4),
            Transition::new(780454800, 3),
            Transition::new(796179600, 4),
            Transition::new(811904400, 3),
            Transition::new(828234000, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-5272, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, false, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, true, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, true, Some(b"+00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-3600, false, Some(b"-01")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(0, true, Some(b"+00")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    3600,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_SITKA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3225223727, 1),
            Transition::new(-2188954727, 2),
            Transition::new(-880207200, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765385200, 2),
            Transition::new(-21477600, 5),
            Transition::new(-5756400, 2),
            Transition::new(9972000, 5),
            Transition::new(25693200, 2),
            Transition::new(41421600, 5),
            Transition::new(57747600, 2),
            Transition::new(73476000, 5),
            Transition::new(89197200, 2),
            Transition::new(104925600, 5),
            Transition::new(120646800, 2),
            Transition::new(126698400, 5),
            Transition::new(152096400, 2),
            Transition::new(162381600, 5),
            Transition::new(183546000, 2),
            Transition::new(199274400, 5),
            Transition::new(215600400, 2),
            Transition::new(230724000, 5),
            Transition::new(247050000, 2),
            Transition::new(262778400, 5),
            Transition::new(278499600, 2),
            Transition::new(294228000, 5),
            Transition::new(309949200, 2),
            Transition::new(325677600, 5),
            Transition::new(341398800, 2),
            Transition::new(357127200, 5),
            Transition::new(372848400, 2),
            Transition::new(388576800, 5),
            Transition::new(404902800, 2),
            Transition::new(420026400, 5),
            Transition::new(436352400, 6),
            Transition::new(439030800, 8),
            Transition::new(452084400, 7),
            Transition::new(467805600, 8),
            Transition::new(483534000, 7),
            Transition::new(499255200, 8),
            Transition::new(514983600, 7),
            Transition::new(530704800, 8),
            Transition::new(544618800, 7),
            Transition::new(562154400, 8),
            Transition::new(576068400, 7),
            Transition::new(594208800, 8),
            Transition::new(607518000, 7),
            Transition::new(625658400, 8),
            Transition::new(638967600, 7),
            Transition::new(657108000, 8),
            Transition::new(671022000, 7),
            Transition::new(688557600, 8),
            Transition::new(702471600, 7),
            Transition::new(720007200, 8),
            Transition::new(733921200, 7),
            Transition::new(752061600, 8),
            Transition::new(765370800, 7),
            Transition::new(783511200, 8),
            Transition::new(796820400, 7),
            Transition::new(814960800, 8),
            Transition::new(828874800, 7),
            Transition::new(846410400, 8),
            Transition::new(860324400, 7),
            Transition::new(877860000, 8),
            Transition::new(891774000, 7),
            Transition::new(909309600, 8),
            Transition::new(923223600, 7),
            Transition::new(941364000, 8),
            Transition::new(954673200, 7),
            Transition::new(972813600, 8),
            Transition::new(986122800, 7),
            Transition::new(1004263200, 8),
            Transition::new(1018177200, 7),
            Transition::new(1035712800, 8),
            Transition::new(1049626800, 7),
            Transition::new(1067162400, 8),
            Transition::new(1081076400, 7),
            Transition::new(1099216800, 8),
            Transition::new(1112526000, 7),
            Transition::new(1130666400, 8),
            Transition::new(1143975600, 7),
            Transition::new(1162116000, 8),
            Transition::new(1173610800, 7),
        ],
        &{
            const V: [LocalTimeType; 9] = [
                match LocalTimeType::new(53927, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32473, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"YST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ST_JOHNS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713897748, 2),
            Transition::new(-1664130548, 1),
            Transition::new(-1650137348, 2),
            Transition::new(-1632076148, 1),
            Transition::new(-1615145348, 2),
            Transition::new(-1598650148, 1),
            Transition::new(-1590100148, 2),
            Transition::new(-1567286948, 1),
            Transition::new(-1551565748, 2),
            Transition::new(-1535837348, 1),
            Transition::new(-1520116148, 2),
            Transition::new(-1503782948, 1),
            Transition::new(-1488666548, 2),
            Transition::new(-1472333348, 1),
            Transition::new(-1457216948, 2),
            Transition::new(-1440883748, 1),
            Transition::new(-1425767348, 2),
            Transition::new(-1409434148, 1),
            Transition::new(-1394317748, 2),
            Transition::new(-1377984548, 1),
            Transition::new(-1362263348, 2),
            Transition::new(-1346534948, 1),
            Transition::new(-1330813748, 2),
            Transition::new(-1314480548, 1),
            Transition::new(-1299364148, 2),
            Transition::new(-1283030948, 1),
            Transition::new(-1267914548, 2),
            Transition::new(-1251581348, 1),
            Transition::new(-1236464948, 2),
            Transition::new(-1220131748, 1),
            Transition::new(-1205015348, 2),
            Transition::new(-1188682148, 1),
            Transition::new(-1172960948, 2),
            Transition::new(-1156627748, 1),
            Transition::new(-1141511348, 2),
            Transition::new(-1125178148, 1),
            Transition::new(-1110061748, 2),
            Transition::new(-1096921748, 4),
            Transition::new(-1093728600, 3),
            Transition::new(-1078612200, 4),
            Transition::new(-1061670600, 3),
            Transition::new(-1048973400, 4),
            Transition::new(-1030221000, 3),
            Transition::new(-1017523800, 4),
            Transition::new(-998771400, 3),
            Transition::new(-986074200, 4),
            Transition::new(-966717000, 3),
            Transition::new(-954624600, 4),
            Transition::new(-935267400, 3),
            Transition::new(-922570200, 4),
            Transition::new(-903817800, 3),
            Transition::new(-891120600, 4),
            Transition::new(-872368200, 6),
            Transition::new(-769395600, 5),
            Transition::new(-765401400, 4),
            Transition::new(-746044200, 3),
            Transition::new(-733347000, 4),
            Transition::new(-714594600, 3),
            Transition::new(-701897400, 4),
            Transition::new(-683145000, 3),
            Transition::new(-670447800, 4),
            Transition::new(-651695400, 3),
            Transition::new(-638998200, 4),
            Transition::new(-619641000, 3),
            Transition::new(-606943800, 4),
            Transition::new(-589401000, 3),
            Transition::new(-576099000, 4),
            Transition::new(-557951400, 3),
            Transition::new(-544649400, 4),
            Transition::new(-526501800, 3),
            Transition::new(-513199800, 4),
            Transition::new(-495052200, 3),
            Transition::new(-481750200, 4),
            Transition::new(-463602600, 3),
            Transition::new(-450300600, 4),
            Transition::new(-431548200, 3),
            Transition::new(-418246200, 4),
            Transition::new(-400098600, 3),
            Transition::new(-386796600, 4),
            Transition::new(-368649000, 3),
            Transition::new(-355347000, 4),
            Transition::new(-337199400, 3),
            Transition::new(-323897400, 4),
            Transition::new(-305749800, 3),
            Transition::new(-289423800, 4),
            Transition::new(-273695400, 3),
            Transition::new(-257974200, 4),
            Transition::new(-242245800, 3),
            Transition::new(-226524600, 4),
            Transition::new(-210796200, 3),
            Transition::new(-195075000, 4),
            Transition::new(-179346600, 3),
            Transition::new(-163625400, 4),
            Transition::new(-147897000, 3),
            Transition::new(-131571000, 4),
            Transition::new(-116447400, 3),
            Transition::new(-100121400, 4),
            Transition::new(-84393000, 3),
            Transition::new(-68671800, 4),
            Transition::new(-52943400, 3),
            Transition::new(-37222200, 4),
            Transition::new(-21493800, 3),
            Transition::new(-5772600, 4),
            Transition::new(9955800, 3),
            Transition::new(25677000, 4),
            Transition::new(41405400, 3),
            Transition::new(57731400, 4),
            Transition::new(73459800, 3),
            Transition::new(89181000, 4),
            Transition::new(104909400, 3),
            Transition::new(120630600, 4),
            Transition::new(136359000, 3),
            Transition::new(152080200, 4),
            Transition::new(167808600, 3),
            Transition::new(183529800, 4),
            Transition::new(199258200, 3),
            Transition::new(215584200, 4),
            Transition::new(230707800, 3),
            Transition::new(247033800, 4),
            Transition::new(262762200, 3),
            Transition::new(278483400, 4),
            Transition::new(294211800, 3),
            Transition::new(309933000, 4),
            Transition::new(325661400, 3),
            Transition::new(341382600, 4),
            Transition::new(357111000, 3),
            Transition::new(372832200, 4),
            Transition::new(388560600, 3),
            Transition::new(404886600, 4),
            Transition::new(420010200, 3),
            Transition::new(436336200, 4),
            Transition::new(452064600, 3),
            Transition::new(467785800, 4),
            Transition::new(483514200, 3),
            Transition::new(499235400, 4),
            Transition::new(514963800, 3),
            Transition::new(530685000, 4),
            Transition::new(544591860, 3),
            Transition::new(562127460, 4),
            Transition::new(576041460, 7),
            Transition::new(594178260, 4),
            Transition::new(607491060, 3),
            Transition::new(625631460, 4),
            Transition::new(638940660, 3),
            Transition::new(657081060, 4),
            Transition::new(670995060, 3),
            Transition::new(688530660, 4),
            Transition::new(702444660, 3),
            Transition::new(719980260, 4),
            Transition::new(733894260, 3),
            Transition::new(752034660, 4),
            Transition::new(765343860, 3),
            Transition::new(783484260, 4),
            Transition::new(796793460, 3),
            Transition::new(814933860, 4),
            Transition::new(828847860, 3),
            Transition::new(846383460, 4),
            Transition::new(860297460, 3),
            Transition::new(877833060, 4),
            Transition::new(891747060, 3),
            Transition::new(909282660, 4),
            Transition::new(923196660, 3),
            Transition::new(941337060, 4),
            Transition::new(954646260, 3),
            Transition::new(972786660, 4),
            Transition::new(986095860, 3),
            Transition::new(1004236260, 4),
            Transition::new(1018150260, 3),
            Transition::new(1035685860, 4),
            Transition::new(1049599860, 3),
            Transition::new(1067135460, 4),
            Transition::new(1081049460, 3),
            Transition::new(1099189860, 4),
            Transition::new(1112499060, 3),
            Transition::new(1130639460, 4),
            Transition::new(1143948660, 3),
            Transition::new(1162089060, 4),
            Transition::new(1173583860, 3),
            Transition::new(1194143460, 4),
            Transition::new(1205033460, 3),
            Transition::new(1225593060, 4),
            Transition::new(1236483060, 3),
            Transition::new(1257042660, 4),
            Transition::new(1268537460, 3),
            Transition::new(1289097060, 4),
            Transition::new(1299987060, 3),
            Transition::new(1320553800, 4),
        ],
        &{
            const V: [LocalTimeType; 8] = [
                match LocalTimeType::new(-12652, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9052, true, Some(b"NDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-12652, false, Some(b"NST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9000, true, Some(b"NDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-12600, false, Some(b"NST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9000, true, Some(b"NPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9000, true, Some(b"NWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-5400, true, Some(b"NDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-12600, false, Some(b"NST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-9000, true, Some(b"NDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ST_KITTS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1825098548, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(-15052, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ST_LUCIA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524506960, 1),
            Transition::new(-1830369360, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-14640, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14640, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ST_THOMAS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1846266016, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(-15584, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ST_VINCENT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524506904, 1),
            Transition::new(-1830369304, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-14696, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14696, false, Some(b"KMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_SWIFT_CURRENT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2030201320, 2),
            Transition::new(-1632063600, 1),
            Transition::new(-1615132800, 2),
            Transition::new(-880210800, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765388800, 2),
            Transition::new(-747241200, 1),
            Transition::new(-732729600, 2),
            Transition::new(-715791600, 1),
            Transition::new(-702489600, 2),
            Transition::new(-684342000, 1),
            Transition::new(-671040000, 2),
            Transition::new(-652892400, 1),
            Transition::new(-639590400, 2),
            Transition::new(-400086000, 1),
            Transition::new(-384364800, 2),
            Transition::new(-337186800, 1),
            Transition::new(-321465600, 2),
            Transition::new(-305737200, 1),
            Transition::new(-292435200, 2),
            Transition::new(-273682800, 1),
            Transition::new(-260985600, 2),
            Transition::new(73472400, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-25880, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_TEGUCIGALPA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1538503868, 2),
            Transition::new(547020000, 1),
            Transition::new(559717200, 2),
            Transition::new(578469600, 1),
            Transition::new(591166800, 2),
            Transition::new(1146981600, 1),
            Transition::new(1154926800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-20932, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_THULE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1686079492, 2),
            Transition::new(670399200, 1),
            Transition::new(686120400, 2),
            Transition::new(701848800, 1),
            Transition::new(717570000, 2),
            Transition::new(733903200, 1),
            Transition::new(752043600, 2),
            Transition::new(765352800, 1),
            Transition::new(783493200, 2),
            Transition::new(796802400, 1),
            Transition::new(814942800, 2),
            Transition::new(828856800, 1),
            Transition::new(846392400, 2),
            Transition::new(860306400, 1),
            Transition::new(877842000, 2),
            Transition::new(891756000, 1),
            Transition::new(909291600, 2),
            Transition::new(923205600, 1),
            Transition::new(941346000, 2),
            Transition::new(954655200, 1),
            Transition::new(972795600, 2),
            Transition::new(986104800, 1),
            Transition::new(1004245200, 2),
            Transition::new(1018159200, 1),
            Transition::new(1035694800, 2),
            Transition::new(1049608800, 1),
            Transition::new(1067144400, 2),
            Transition::new(1081058400, 1),
            Transition::new(1099198800, 2),
            Transition::new(1112508000, 1),
            Transition::new(1130648400, 2),
            Transition::new(1143957600, 1),
            Transition::new(1162098000, 2),
            Transition::new(1173592800, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-16508, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-14400, false, Some(b"AST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_THUNDER_BAY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2366733780, 1),
            Transition::new(-1893434400, 2),
            Transition::new(-880218000, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765396000, 2),
            Transition::new(9961200, 5),
            Transition::new(25682400, 2),
            Transition::new(41410800, 5),
            Transition::new(57736800, 2),
            Transition::new(73465200, 5),
            Transition::new(89186400, 2),
            Transition::new(136364400, 5),
            Transition::new(152085600, 2),
            Transition::new(167814000, 5),
            Transition::new(183535200, 2),
            Transition::new(199263600, 5),
            Transition::new(215589600, 2),
            Transition::new(230713200, 5),
            Transition::new(247039200, 2),
            Transition::new(262767600, 5),
            Transition::new(278488800, 2),
            Transition::new(294217200, 5),
            Transition::new(309938400, 2),
            Transition::new(325666800, 5),
            Transition::new(341388000, 2),
            Transition::new(357116400, 5),
            Transition::new(372837600, 2),
            Transition::new(388566000, 5),
            Transition::new(404892000, 2),
            Transition::new(420015600, 5),
            Transition::new(436341600, 2),
            Transition::new(452070000, 5),
            Transition::new(467791200, 2),
            Transition::new(483519600, 5),
            Transition::new(499240800, 2),
            Transition::new(514969200, 5),
            Transition::new(530690400, 2),
            Transition::new(544604400, 5),
            Transition::new(562140000, 2),
            Transition::new(576054000, 5),
            Transition::new(594194400, 2),
            Transition::new(607503600, 5),
            Transition::new(625644000, 2),
            Transition::new(638953200, 5),
            Transition::new(657093600, 2),
            Transition::new(671007600, 5),
            Transition::new(688543200, 2),
            Transition::new(702457200, 5),
            Transition::new(719992800, 2),
            Transition::new(733906800, 5),
            Transition::new(752047200, 2),
            Transition::new(765356400, 5),
            Transition::new(783496800, 2),
            Transition::new(796806000, 5),
            Transition::new(814946400, 2),
            Transition::new(828860400, 5),
            Transition::new(846396000, 2),
            Transition::new(860310000, 5),
            Transition::new(877845600, 2),
            Transition::new(891759600, 5),
            Transition::new(909295200, 2),
            Transition::new(923209200, 5),
            Transition::new(941349600, 2),
            Transition::new(954658800, 5),
            Transition::new(972799200, 2),
            Transition::new(986108400, 5),
            Transition::new(1004248800, 2),
            Transition::new(1018162800, 5),
            Transition::new(1035698400, 2),
            Transition::new(1049612400, 5),
            Transition::new(1067148000, 2),
            Transition::new(1081062000, 5),
            Transition::new(1099202400, 2),
            Transition::new(1112511600, 5),
            Transition::new(1130652000, 2),
            Transition::new(1143961200, 5),
            Transition::new(1162101600, 2),
            Transition::new(1173596400, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-21420, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_TORONTO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2366736148, 2),
            Transition::new(-1632070800, 1),
            Transition::new(-1615140000, 2),
            Transition::new(-1601753400, 1),
            Transition::new(-1583697600, 2),
            Transition::new(-1567357200, 1),
            Transition::new(-1554667200, 2),
            Transition::new(-1534698000, 1),
            Transition::new(-1524074400, 2),
            Transition::new(-1503248400, 1),
            Transition::new(-1492365600, 2),
            Transition::new(-1471798800, 1),
            Transition::new(-1460916000, 2),
            Transition::new(-1440954000, 1),
            Transition::new(-1428861600, 2),
            Transition::new(-1409504400, 1),
            Transition::new(-1397412000, 2),
            Transition::new(-1378054800, 1),
            Transition::new(-1365962400, 2),
            Transition::new(-1346605200, 1),
            Transition::new(-1333908000, 2),
            Transition::new(-1315155600, 1),
            Transition::new(-1301853600, 2),
            Transition::new(-1283706000, 1),
            Transition::new(-1270404000, 2),
            Transition::new(-1252256400, 1),
            Transition::new(-1238954400, 2),
            Transition::new(-1220806800, 1),
            Transition::new(-1207504800, 2),
            Transition::new(-1188752400, 1),
            Transition::new(-1176055200, 2),
            Transition::new(-1157302800, 1),
            Transition::new(-1144000800, 2),
            Transition::new(-1125853200, 1),
            Transition::new(-1112551200, 2),
            Transition::new(-1094403600, 1),
            Transition::new(-1081101600, 2),
            Transition::new(-1062954000, 1),
            Transition::new(-1049652000, 2),
            Transition::new(-1031504400, 1),
            Transition::new(-1018202400, 2),
            Transition::new(-1000054800, 1),
            Transition::new(-986752800, 2),
            Transition::new(-968000400, 1),
            Transition::new(-955303200, 2),
            Transition::new(-936550800, 1),
            Transition::new(-880218000, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765396000, 2),
            Transition::new(-747248400, 1),
            Transition::new(-733946400, 2),
            Transition::new(-715806000, 1),
            Transition::new(-702504000, 2),
            Transition::new(-684356400, 1),
            Transition::new(-671054400, 2),
            Transition::new(-652906800, 1),
            Transition::new(-634161600, 2),
            Transition::new(-620845200, 1),
            Transition::new(-602704800, 2),
            Transition::new(-589395600, 1),
            Transition::new(-576093600, 2),
            Transition::new(-557946000, 1),
            Transition::new(-544644000, 2),
            Transition::new(-526496400, 1),
            Transition::new(-513194400, 2),
            Transition::new(-495046800, 1),
            Transition::new(-481744800, 2),
            Transition::new(-463597200, 1),
            Transition::new(-450295200, 2),
            Transition::new(-431542800, 1),
            Transition::new(-418240800, 2),
            Transition::new(-400093200, 1),
            Transition::new(-384372000, 2),
            Transition::new(-368643600, 1),
            Transition::new(-352922400, 2),
            Transition::new(-337194000, 1),
            Transition::new(-321472800, 2),
            Transition::new(-305744400, 1),
            Transition::new(-289418400, 2),
            Transition::new(-273690000, 1),
            Transition::new(-257968800, 2),
            Transition::new(-242240400, 1),
            Transition::new(-226519200, 2),
            Transition::new(-210790800, 1),
            Transition::new(-195069600, 2),
            Transition::new(-179341200, 1),
            Transition::new(-163620000, 2),
            Transition::new(-147891600, 1),
            Transition::new(-131565600, 2),
            Transition::new(-116442000, 1),
            Transition::new(-100116000, 2),
            Transition::new(-84387600, 1),
            Transition::new(-68666400, 2),
            Transition::new(-52938000, 1),
            Transition::new(-37216800, 2),
            Transition::new(-21488400, 1),
            Transition::new(-5767200, 2),
            Transition::new(9961200, 1),
            Transition::new(25682400, 2),
            Transition::new(41410800, 1),
            Transition::new(57736800, 2),
            Transition::new(73465200, 1),
            Transition::new(89186400, 2),
            Transition::new(104914800, 1),
            Transition::new(120636000, 2),
            Transition::new(136364400, 1),
            Transition::new(152085600, 2),
            Transition::new(167814000, 1),
            Transition::new(183535200, 2),
            Transition::new(199263600, 1),
            Transition::new(215589600, 2),
            Transition::new(230713200, 1),
            Transition::new(247039200, 2),
            Transition::new(262767600, 1),
            Transition::new(278488800, 2),
            Transition::new(294217200, 1),
            Transition::new(309938400, 2),
            Transition::new(325666800, 1),
            Transition::new(341388000, 2),
            Transition::new(357116400, 1),
            Transition::new(372837600, 2),
            Transition::new(388566000, 1),
            Transition::new(404892000, 2),
            Transition::new(420015600, 1),
            Transition::new(436341600, 2),
            Transition::new(452070000, 1),
            Transition::new(467791200, 2),
            Transition::new(483519600, 1),
            Transition::new(499240800, 2),
            Transition::new(514969200, 1),
            Transition::new(530690400, 2),
            Transition::new(544604400, 1),
            Transition::new(562140000, 2),
            Transition::new(576054000, 1),
            Transition::new(594194400, 2),
            Transition::new(607503600, 1),
            Transition::new(625644000, 2),
            Transition::new(638953200, 1),
            Transition::new(657093600, 2),
            Transition::new(671007600, 1),
            Transition::new(688543200, 2),
            Transition::new(702457200, 1),
            Transition::new(719992800, 2),
            Transition::new(733906800, 1),
            Transition::new(752047200, 2),
            Transition::new(765356400, 1),
            Transition::new(783496800, 2),
            Transition::new(796806000, 1),
            Transition::new(814946400, 2),
            Transition::new(828860400, 1),
            Transition::new(846396000, 2),
            Transition::new(860310000, 1),
            Transition::new(877845600, 2),
            Transition::new(891759600, 1),
            Transition::new(909295200, 2),
            Transition::new(923209200, 1),
            Transition::new(941349600, 2),
            Transition::new(954658800, 1),
            Transition::new(972799200, 2),
            Transition::new(986108400, 1),
            Transition::new(1004248800, 2),
            Transition::new(1018162800, 1),
            Transition::new(1035698400, 2),
            Transition::new(1049612400, 1),
            Transition::new(1067148000, 2),
            Transition::new(1081062000, 1),
            Transition::new(1099202400, 2),
            Transition::new(1112511600, 1),
            Transition::new(1130652000, 2),
            Transition::new(1143961200, 1),
            Transition::new(1162101600, 2),
            Transition::new(1173596400, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-19052, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_TORTOLA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1846266092, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(-15508, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_VANCOUVER: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713880852, 2),
            Transition::new(-1632060000, 1),
            Transition::new(-1615129200, 2),
            Transition::new(-880207200, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765385200, 2),
            Transition::new(-747237600, 1),
            Transition::new(-733935600, 2),
            Transition::new(-715788000, 1),
            Transition::new(-702486000, 2),
            Transition::new(-684338400, 1),
            Transition::new(-671036400, 2),
            Transition::new(-652888800, 1),
            Transition::new(-639586800, 2),
            Transition::new(-620834400, 1),
            Transition::new(-608137200, 2),
            Transition::new(-589384800, 1),
            Transition::new(-576082800, 2),
            Transition::new(-557935200, 1),
            Transition::new(-544633200, 2),
            Transition::new(-526485600, 1),
            Transition::new(-513183600, 2),
            Transition::new(-495036000, 1),
            Transition::new(-481734000, 2),
            Transition::new(-463586400, 1),
            Transition::new(-450284400, 2),
            Transition::new(-431532000, 1),
            Transition::new(-418230000, 2),
            Transition::new(-400082400, 1),
            Transition::new(-386780400, 2),
            Transition::new(-368632800, 1),
            Transition::new(-355330800, 2),
            Transition::new(-337183200, 1),
            Transition::new(-323881200, 2),
            Transition::new(-305733600, 1),
            Transition::new(-292431600, 2),
            Transition::new(-273679200, 1),
            Transition::new(-260982000, 2),
            Transition::new(-242229600, 1),
            Transition::new(-226508400, 2),
            Transition::new(-210780000, 1),
            Transition::new(-195058800, 2),
            Transition::new(-179330400, 1),
            Transition::new(-163609200, 2),
            Transition::new(-147880800, 1),
            Transition::new(-131554800, 2),
            Transition::new(-116431200, 1),
            Transition::new(-100105200, 2),
            Transition::new(-84376800, 1),
            Transition::new(-68655600, 2),
            Transition::new(-52927200, 1),
            Transition::new(-37206000, 2),
            Transition::new(-21477600, 1),
            Transition::new(-5756400, 2),
            Transition::new(9972000, 1),
            Transition::new(25693200, 2),
            Transition::new(41421600, 1),
            Transition::new(57747600, 2),
            Transition::new(73476000, 1),
            Transition::new(89197200, 2),
            Transition::new(104925600, 1),
            Transition::new(120646800, 2),
            Transition::new(136375200, 1),
            Transition::new(152096400, 2),
            Transition::new(167824800, 1),
            Transition::new(183546000, 2),
            Transition::new(199274400, 1),
            Transition::new(215600400, 2),
            Transition::new(230724000, 1),
            Transition::new(247050000, 2),
            Transition::new(262778400, 1),
            Transition::new(278499600, 2),
            Transition::new(294228000, 1),
            Transition::new(309949200, 2),
            Transition::new(325677600, 1),
            Transition::new(341398800, 2),
            Transition::new(357127200, 1),
            Transition::new(372848400, 2),
            Transition::new(388576800, 1),
            Transition::new(404902800, 2),
            Transition::new(420026400, 1),
            Transition::new(436352400, 2),
            Transition::new(452080800, 1),
            Transition::new(467802000, 2),
            Transition::new(483530400, 1),
            Transition::new(499251600, 2),
            Transition::new(514980000, 1),
            Transition::new(530701200, 2),
            Transition::new(544615200, 1),
            Transition::new(562150800, 2),
            Transition::new(576064800, 1),
            Transition::new(594205200, 2),
            Transition::new(607514400, 1),
            Transition::new(625654800, 2),
            Transition::new(638964000, 1),
            Transition::new(657104400, 2),
            Transition::new(671018400, 1),
            Transition::new(688554000, 2),
            Transition::new(702468000, 1),
            Transition::new(720003600, 2),
            Transition::new(733917600, 1),
            Transition::new(752058000, 2),
            Transition::new(765367200, 1),
            Transition::new(783507600, 2),
            Transition::new(796816800, 1),
            Transition::new(814957200, 2),
            Transition::new(828871200, 1),
            Transition::new(846406800, 2),
            Transition::new(860320800, 1),
            Transition::new(877856400, 2),
            Transition::new(891770400, 1),
            Transition::new(909306000, 2),
            Transition::new(923220000, 1),
            Transition::new(941360400, 2),
            Transition::new(954669600, 1),
            Transition::new(972810000, 2),
            Transition::new(986119200, 1),
            Transition::new(1004259600, 2),
            Transition::new(1018173600, 1),
            Transition::new(1035709200, 2),
            Transition::new(1049623200, 1),
            Transition::new(1067158800, 2),
            Transition::new(1081072800, 1),
            Transition::new(1099213200, 2),
            Transition::new(1112522400, 1),
            Transition::new(1130662800, 2),
            Transition::new(1143972000, 1),
            Transition::new(1162112400, 2),
            Transition::new(1173607200, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-29548, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-28800, false, Some(b"PST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_WHITEHORSE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2188997988, 2),
            Transition::new(-1632056400, 1),
            Transition::new(-1615125600, 2),
            Transition::new(-1596978000, 1),
            Transition::new(-1583164800, 2),
            Transition::new(-880203600, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765381600, 2),
            Transition::new(-147884400, 5),
            Transition::new(-131554800, 2),
            Transition::new(-81961200, 6),
            Transition::new(325677600, 7),
            Transition::new(341398800, 6),
            Transition::new(357127200, 7),
            Transition::new(372848400, 6),
            Transition::new(388576800, 7),
            Transition::new(404902800, 6),
            Transition::new(420026400, 7),
            Transition::new(436352400, 6),
            Transition::new(452080800, 7),
            Transition::new(467802000, 6),
            Transition::new(483530400, 7),
            Transition::new(499251600, 6),
            Transition::new(514980000, 7),
            Transition::new(530701200, 6),
            Transition::new(544615200, 7),
            Transition::new(562150800, 6),
            Transition::new(576064800, 7),
            Transition::new(594205200, 6),
            Transition::new(607514400, 7),
            Transition::new(625654800, 6),
            Transition::new(638964000, 7),
            Transition::new(657104400, 6),
            Transition::new(671018400, 7),
            Transition::new(688554000, 6),
            Transition::new(702468000, 7),
            Transition::new(720003600, 6),
            Transition::new(733917600, 7),
            Transition::new(752058000, 6),
            Transition::new(765367200, 7),
            Transition::new(783507600, 6),
            Transition::new(796816800, 7),
            Transition::new(814957200, 6),
            Transition::new(828871200, 7),
            Transition::new(846406800, 6),
            Transition::new(860320800, 7),
            Transition::new(877856400, 6),
            Transition::new(891770400, 7),
            Transition::new(909306000, 6),
            Transition::new(923220000, 7),
            Transition::new(941360400, 6),
            Transition::new(954669600, 7),
            Transition::new(972810000, 6),
            Transition::new(986119200, 7),
            Transition::new(1004259600, 6),
            Transition::new(1018173600, 7),
            Transition::new(1035709200, 6),
            Transition::new(1049623200, 7),
            Transition::new(1067158800, 6),
            Transition::new(1081072800, 7),
            Transition::new(1099213200, 6),
            Transition::new(1112522400, 7),
            Transition::new(1130662800, 6),
            Transition::new(1143972000, 7),
            Transition::new(1162112400, 6),
            Transition::new(1173607200, 7),
            Transition::new(1194166800, 6),
            Transition::new(1205056800, 7),
            Transition::new(1225616400, 6),
            Transition::new(1236506400, 7),
            Transition::new(1257066000, 6),
            Transition::new(1268560800, 7),
            Transition::new(1289120400, 6),
            Transition::new(1300010400, 7),
            Transition::new(1320570000, 6),
            Transition::new(1331460000, 7),
            Transition::new(1352019600, 6),
            Transition::new(1362909600, 7),
            Transition::new(1383469200, 6),
            Transition::new(1394359200, 7),
            Transition::new(1414918800, 6),
            Transition::new(1425808800, 7),
            Transition::new(1446368400, 6),
            Transition::new(1457863200, 7),
            Transition::new(1478422800, 6),
            Transition::new(1489312800, 7),
            Transition::new(1509872400, 6),
            Transition::new(1520762400, 7),
            Transition::new(1541322000, 6),
            Transition::new(1552212000, 7),
            Transition::new(1572771600, 6),
            Transition::new(1583661600, 7),
            Transition::new(1604214000, 8),
        ],
        &{
            const V: [LocalTimeType; 9] = [
                match LocalTimeType::new(-32412, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"YST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"YDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_WINNIPEG: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2602258284, 2),
            Transition::new(-1694368800, 1),
            Transition::new(-1681671600, 2),
            Transition::new(-1632067200, 1),
            Transition::new(-1615136400, 2),
            Transition::new(-1029686400, 1),
            Transition::new(-1018198800, 2),
            Transition::new(-880214400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765392400, 2),
            Transition::new(-746035200, 1),
            Transition::new(-732733200, 2),
            Transition::new(-715795200, 1),
            Transition::new(-702493200, 2),
            Transition::new(-684345600, 1),
            Transition::new(-671043600, 2),
            Transition::new(-652896000, 1),
            Transition::new(-639594000, 2),
            Transition::new(-620755200, 1),
            Transition::new(-607626000, 2),
            Transition::new(-589392000, 1),
            Transition::new(-576090000, 2),
            Transition::new(-557942400, 1),
            Transition::new(-544640400, 2),
            Transition::new(-526492800, 1),
            Transition::new(-513190800, 2),
            Transition::new(-495043200, 1),
            Transition::new(-481741200, 2),
            Transition::new(-463593600, 1),
            Transition::new(-450291600, 2),
            Transition::new(-431539200, 1),
            Transition::new(-418237200, 2),
            Transition::new(-400089600, 1),
            Transition::new(-386787600, 2),
            Transition::new(-368640000, 1),
            Transition::new(-355338000, 2),
            Transition::new(-337190400, 1),
            Transition::new(-321469200, 2),
            Transition::new(-305740800, 1),
            Transition::new(-292438800, 2),
            Transition::new(-210787200, 1),
            Transition::new(-198090000, 2),
            Transition::new(-116438400, 1),
            Transition::new(-100108800, 2),
            Transition::new(-84384000, 1),
            Transition::new(-68659200, 2),
            Transition::new(-52934400, 1),
            Transition::new(-37209600, 2),
            Transition::new(-21484800, 1),
            Transition::new(-5760000, 2),
            Transition::new(9964800, 1),
            Transition::new(25689600, 2),
            Transition::new(41414400, 1),
            Transition::new(57744000, 2),
            Transition::new(73468800, 1),
            Transition::new(89193600, 2),
            Transition::new(104918400, 1),
            Transition::new(120643200, 2),
            Transition::new(136368000, 1),
            Transition::new(152092800, 2),
            Transition::new(167817600, 1),
            Transition::new(183542400, 2),
            Transition::new(199267200, 1),
            Transition::new(215596800, 2),
            Transition::new(230716800, 1),
            Transition::new(247046400, 2),
            Transition::new(262771200, 1),
            Transition::new(278496000, 2),
            Transition::new(294220800, 1),
            Transition::new(309945600, 2),
            Transition::new(325670400, 1),
            Transition::new(341395200, 2),
            Transition::new(357120000, 1),
            Transition::new(372844800, 2),
            Transition::new(388569600, 1),
            Transition::new(404899200, 2),
            Transition::new(420019200, 1),
            Transition::new(436348800, 2),
            Transition::new(452073600, 1),
            Transition::new(467798400, 2),
            Transition::new(483523200, 1),
            Transition::new(499248000, 2),
            Transition::new(514972800, 1),
            Transition::new(530697600, 2),
            Transition::new(544608000, 1),
            Transition::new(562147200, 2),
            Transition::new(576057600, 1),
            Transition::new(594201600, 2),
            Transition::new(607507200, 1),
            Transition::new(625651200, 2),
            Transition::new(638956800, 1),
            Transition::new(657100800, 2),
            Transition::new(671011200, 1),
            Transition::new(688550400, 2),
            Transition::new(702460800, 1),
            Transition::new(720000000, 2),
            Transition::new(733910400, 1),
            Transition::new(752054400, 2),
            Transition::new(765360000, 1),
            Transition::new(783504000, 2),
            Transition::new(796809600, 1),
            Transition::new(814953600, 2),
            Transition::new(828864000, 1),
            Transition::new(846403200, 2),
            Transition::new(860313600, 1),
            Transition::new(877852800, 2),
            Transition::new(891763200, 1),
            Transition::new(909302400, 2),
            Transition::new(923212800, 1),
            Transition::new(941356800, 2),
            Transition::new(954662400, 1),
            Transition::new(972806400, 2),
            Transition::new(986112000, 1),
            Transition::new(1004256000, 2),
            Transition::new(1018166400, 1),
            Transition::new(1035705600, 2),
            Transition::new(1049616000, 1),
            Transition::new(1067155200, 2),
            Transition::new(1081065600, 1),
            Transition::new(1099209600, 2),
            Transition::new(1112515200, 1),
            Transition::new(1130659200, 2),
            Transition::new(1143964800, 1),
            Transition::new(1162105200, 2),
            Transition::new(1173600000, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-23316, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_YAKUTAT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3225223727, 1),
            Transition::new(-2188953665, 2),
            Transition::new(-880203600, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765381600, 2),
            Transition::new(-21474000, 5),
            Transition::new(-5752800, 2),
            Transition::new(9975600, 5),
            Transition::new(25696800, 2),
            Transition::new(41425200, 5),
            Transition::new(57751200, 2),
            Transition::new(73479600, 5),
            Transition::new(89200800, 2),
            Transition::new(104929200, 5),
            Transition::new(120650400, 2),
            Transition::new(126702000, 5),
            Transition::new(152100000, 2),
            Transition::new(162385200, 5),
            Transition::new(183549600, 2),
            Transition::new(199278000, 5),
            Transition::new(215604000, 2),
            Transition::new(230727600, 5),
            Transition::new(247053600, 2),
            Transition::new(262782000, 5),
            Transition::new(278503200, 2),
            Transition::new(294231600, 5),
            Transition::new(309952800, 2),
            Transition::new(325681200, 5),
            Transition::new(341402400, 2),
            Transition::new(357130800, 5),
            Transition::new(372852000, 2),
            Transition::new(388580400, 5),
            Transition::new(404906400, 2),
            Transition::new(420030000, 5),
            Transition::new(436356000, 2),
            Transition::new(439030800, 7),
            Transition::new(452084400, 6),
            Transition::new(467805600, 7),
            Transition::new(483534000, 6),
            Transition::new(499255200, 7),
            Transition::new(514983600, 6),
            Transition::new(530704800, 7),
            Transition::new(544618800, 6),
            Transition::new(562154400, 7),
            Transition::new(576068400, 6),
            Transition::new(594208800, 7),
            Transition::new(607518000, 6),
            Transition::new(625658400, 7),
            Transition::new(638967600, 6),
            Transition::new(657108000, 7),
            Transition::new(671022000, 6),
            Transition::new(688557600, 7),
            Transition::new(702471600, 6),
            Transition::new(720007200, 7),
            Transition::new(733921200, 6),
            Transition::new(752061600, 7),
            Transition::new(765370800, 6),
            Transition::new(783511200, 7),
            Transition::new(796820400, 6),
            Transition::new(814960800, 7),
            Transition::new(828874800, 6),
            Transition::new(846410400, 7),
            Transition::new(860324400, 6),
            Transition::new(877860000, 7),
            Transition::new(891774000, 6),
            Transition::new(909309600, 7),
            Transition::new(923223600, 6),
            Transition::new(941364000, 7),
            Transition::new(954673200, 6),
            Transition::new(972813600, 7),
            Transition::new(986122800, 6),
            Transition::new(1004263200, 7),
            Transition::new(1018177200, 6),
            Transition::new(1035712800, 7),
            Transition::new(1049626800, 6),
            Transition::new(1067162400, 7),
            Transition::new(1081076400, 6),
            Transition::new(1099216800, 7),
            Transition::new(1112526000, 6),
            Transition::new(1130666400, 7),
            Transition::new(1143975600, 6),
            Transition::new(1162116000, 7),
            Transition::new(1173610800, 6),
        ],
        &{
            const V: [LocalTimeType; 8] = [
                match LocalTimeType::new(52865, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-33535, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"YST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_YELLOWKNIFE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1104537600, 3),
            Transition::new(-880210800, 1),
            Transition::new(-769395600, 2),
            Transition::new(-765388800, 3),
            Transition::new(-147891600, 4),
            Transition::new(-131562000, 3),
            Transition::new(325674000, 5),
            Transition::new(341395200, 3),
            Transition::new(357123600, 5),
            Transition::new(372844800, 3),
            Transition::new(388573200, 5),
            Transition::new(404899200, 3),
            Transition::new(420022800, 5),
            Transition::new(436348800, 3),
            Transition::new(452077200, 5),
            Transition::new(467798400, 3),
            Transition::new(483526800, 5),
            Transition::new(499248000, 3),
            Transition::new(514976400, 5),
            Transition::new(530697600, 3),
            Transition::new(544611600, 5),
            Transition::new(562147200, 3),
            Transition::new(576061200, 5),
            Transition::new(594201600, 3),
            Transition::new(607510800, 5),
            Transition::new(625651200, 3),
            Transition::new(638960400, 5),
            Transition::new(657100800, 3),
            Transition::new(671014800, 5),
            Transition::new(688550400, 3),
            Transition::new(702464400, 5),
            Transition::new(720000000, 3),
            Transition::new(733914000, 5),
            Transition::new(752054400, 3),
            Transition::new(765363600, 5),
            Transition::new(783504000, 3),
            Transition::new(796813200, 5),
            Transition::new(814953600, 3),
            Transition::new(828867600, 5),
            Transition::new(846403200, 3),
            Transition::new(860317200, 5),
            Transition::new(877852800, 3),
            Transition::new(891766800, 5),
            Transition::new(909302400, 3),
            Transition::new(923216400, 5),
            Transition::new(941356800, 3),
            Transition::new(954666000, 5),
            Transition::new(972806400, 3),
            Transition::new(986115600, 5),
            Transition::new(1004256000, 3),
            Transition::new(1018170000, 5),
            Transition::new(1035705600, 3),
            Transition::new(1049619600, 5),
            Transition::new(1067155200, 3),
            Transition::new(1081069200, 5),
            Transition::new(1099209600, 3),
            Transition::new(1112518800, 5),
            Transition::new(1130659200, 3),
            Transition::new(1143968400, 5),
            Transition::new(1162108800, 3),
            Transition::new(1173603600, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"MDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_CASEY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-31536000, 1),
            Transition::new(1255802400, 2),
            Transition::new(1267714800, 1),
            Transition::new(1319738400, 2),
            Transition::new(1329843600, 1),
            Transition::new(1477065600, 2),
            Transition::new(1520701200, 1),
            Transition::new(1538856000, 2),
            Transition::new(1552752000, 1),
            Transition::new(1570129200, 2),
            Transition::new(1583596800, 1),
            Transition::new(1601740860, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, false, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(39600, false, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_DAVIS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-409190400, 1),
            Transition::new(-163062000, 0),
            Transition::new(-28857600, 1),
            Transition::new(1255806000, 2),
            Transition::new(1268251200, 1),
            Transition::new(1319742000, 2),
            Transition::new(1329854400, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_DUMONT_D_URVILLE: TimeZoneRef<'static> =
        match TimeZoneRef::<'static>::new(
            &[
                Transition::new(-725846400, 1),
                Transition::new(-566992800, 0),
                Transition::new(-415497600, 1),
            ],
            &{
                const V: [LocalTimeType; 2] = [
                    match LocalTimeType::new(0, false, Some(b"-00")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(36000, false, Some(b"+10")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                ];
                V
            },
            &[],
            &Some({
                const V: TransitionRule =
                    TransitionRule::Fixed(match LocalTimeType::new(36000, false, Some(b"+10")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    });
                V
            }),
        ) {
            Ok(v) => v,
            Err(e) => panic!("{}", e.0),
        };

    pub(crate) const ANTARCTICA_MACQUARIE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2214259200, 1),
            Transition::new(-1680508800, 2),
            Transition::new(-1665388800, 1),
            Transition::new(-1601719200, 0),
            Transition::new(-687052800, 1),
            Transition::new(-71136000, 2),
            Transition::new(-55411200, 1),
            Transition::new(-37267200, 2),
            Transition::new(-25776000, 1),
            Transition::new(-5817600, 2),
            Transition::new(5673600, 1),
            Transition::new(25632000, 2),
            Transition::new(37728000, 1),
            Transition::new(57686400, 2),
            Transition::new(67968000, 1),
            Transition::new(89136000, 2),
            Transition::new(100022400, 1),
            Transition::new(120585600, 2),
            Transition::new(131472000, 1),
            Transition::new(152035200, 2),
            Transition::new(162921600, 1),
            Transition::new(183484800, 2),
            Transition::new(194976000, 1),
            Transition::new(215539200, 2),
            Transition::new(226425600, 1),
            Transition::new(246988800, 2),
            Transition::new(257875200, 1),
            Transition::new(278438400, 2),
            Transition::new(289324800, 1),
            Transition::new(309888000, 2),
            Transition::new(320774400, 1),
            Transition::new(341337600, 2),
            Transition::new(352224000, 1),
            Transition::new(372787200, 2),
            Transition::new(386092800, 1),
            Transition::new(404841600, 2),
            Transition::new(417542400, 1),
            Transition::new(436291200, 2),
            Transition::new(447177600, 1),
            Transition::new(467740800, 2),
            Transition::new(478627200, 1),
            Transition::new(499190400, 2),
            Transition::new(510076800, 1),
            Transition::new(530035200, 2),
            Transition::new(542736000, 1),
            Transition::new(562089600, 2),
            Transition::new(574790400, 1),
            Transition::new(594144000, 2),
            Transition::new(606240000, 1),
            Transition::new(625593600, 2),
            Transition::new(637689600, 1),
            Transition::new(657043200, 2),
            Transition::new(670348800, 1),
            Transition::new(686678400, 2),
            Transition::new(701798400, 1),
            Transition::new(718128000, 2),
            Transition::new(733248000, 1),
            Transition::new(749577600, 2),
            Transition::new(764697600, 1),
            Transition::new(781027200, 2),
            Transition::new(796147200, 1),
            Transition::new(812476800, 2),
            Transition::new(828201600, 1),
            Transition::new(844531200, 2),
            Transition::new(859651200, 1),
            Transition::new(875980800, 2),
            Transition::new(891100800, 1),
            Transition::new(907430400, 2),
            Transition::new(922550400, 1),
            Transition::new(938880000, 2),
            Transition::new(954000000, 1),
            Transition::new(967305600, 2),
            Transition::new(985449600, 1),
            Transition::new(1002384000, 2),
            Transition::new(1017504000, 1),
            Transition::new(1033833600, 2),
            Transition::new(1048953600, 1),
            Transition::new(1065283200, 2),
            Transition::new(1080403200, 1),
            Transition::new(1096732800, 2),
            Transition::new(1111852800, 1),
            Transition::new(1128182400, 2),
            Transition::new(1143907200, 1),
            Transition::new(1159632000, 2),
            Transition::new(1174752000, 1),
            Transition::new(1191686400, 2),
            Transition::new(1207411200, 1),
            Transition::new(1223136000, 2),
            Transition::new(1238860800, 1),
            Transition::new(1254585600, 2),
            Transition::new(1301760000, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"AEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, true, Some(b"AEDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(36000, false, Some(b"AEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(39600, true, Some(b"AEDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_MAWSON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-501206400, 1),
            Transition::new(1255809600, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_MC_MURDO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-441849600, 2),
            Transition::new(152632800, 1),
            Transition::new(162309600, 2),
            Transition::new(183477600, 1),
            Transition::new(194968800, 2),
            Transition::new(215532000, 1),
            Transition::new(226418400, 2),
            Transition::new(246981600, 1),
            Transition::new(257868000, 2),
            Transition::new(278431200, 1),
            Transition::new(289317600, 2),
            Transition::new(309880800, 1),
            Transition::new(320767200, 2),
            Transition::new(341330400, 1),
            Transition::new(352216800, 2),
            Transition::new(372780000, 1),
            Transition::new(384271200, 2),
            Transition::new(404834400, 1),
            Transition::new(415720800, 2),
            Transition::new(436284000, 1),
            Transition::new(447170400, 2),
            Transition::new(467733600, 1),
            Transition::new(478620000, 2),
            Transition::new(499183200, 1),
            Transition::new(510069600, 2),
            Transition::new(530632800, 1),
            Transition::new(541519200, 2),
            Transition::new(562082400, 1),
            Transition::new(573573600, 2),
            Transition::new(594136800, 1),
            Transition::new(605023200, 2),
            Transition::new(623772000, 1),
            Transition::new(637682400, 2),
            Transition::new(655221600, 1),
            Transition::new(669132000, 2),
            Transition::new(686671200, 1),
            Transition::new(700581600, 2),
            Transition::new(718120800, 1),
            Transition::new(732636000, 2),
            Transition::new(749570400, 1),
            Transition::new(764085600, 2),
            Transition::new(781020000, 1),
            Transition::new(795535200, 2),
            Transition::new(812469600, 1),
            Transition::new(826984800, 2),
            Transition::new(844524000, 1),
            Transition::new(858434400, 2),
            Transition::new(875973600, 1),
            Transition::new(889884000, 2),
            Transition::new(907423200, 1),
            Transition::new(921938400, 2),
            Transition::new(938872800, 1),
            Transition::new(953388000, 2),
            Transition::new(970322400, 1),
            Transition::new(984837600, 2),
            Transition::new(1002376800, 1),
            Transition::new(1016287200, 2),
            Transition::new(1033826400, 1),
            Transition::new(1047736800, 2),
            Transition::new(1065276000, 1),
            Transition::new(1079791200, 2),
            Transition::new(1096725600, 1),
            Transition::new(1111240800, 2),
            Transition::new(1128175200, 1),
            Transition::new(1142690400, 2),
            Transition::new(1159624800, 1),
            Transition::new(1174140000, 2),
            Transition::new(1191074400, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(46800, true, Some(b"NZDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(43200, false, Some(b"NZST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(43200, false, Some(b"NZST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(46800, true, Some(b"NZDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(9, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_PALMER: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-157766400, 2),
            Transition::new(-152658000, 1),
            Transition::new(-132955200, 2),
            Transition::new(-121122000, 1),
            Transition::new(-101419200, 2),
            Transition::new(-86821200, 1),
            Transition::new(-71092800, 2),
            Transition::new(-54766800, 1),
            Transition::new(-39038400, 2),
            Transition::new(-23317200, 1),
            Transition::new(-7588800, 4),
            Transition::new(128142000, 3),
            Transition::new(136605600, 4),
            Transition::new(389070000, 1),
            Transition::new(403070400, 2),
            Transition::new(416372400, 1),
            Transition::new(434520000, 2),
            Transition::new(447822000, 1),
            Transition::new(466574400, 2),
            Transition::new(479271600, 1),
            Transition::new(498024000, 2),
            Transition::new(510721200, 1),
            Transition::new(529473600, 2),
            Transition::new(545194800, 1),
            Transition::new(560923200, 2),
            Transition::new(574225200, 1),
            Transition::new(592372800, 2),
            Transition::new(605674800, 1),
            Transition::new(624427200, 2),
            Transition::new(637124400, 1),
            Transition::new(653457600, 2),
            Transition::new(668574000, 1),
            Transition::new(687326400, 2),
            Transition::new(700628400, 1),
            Transition::new(718776000, 2),
            Transition::new(732078000, 1),
            Transition::new(750225600, 2),
            Transition::new(763527600, 1),
            Transition::new(781675200, 2),
            Transition::new(794977200, 1),
            Transition::new(813729600, 2),
            Transition::new(826426800, 1),
            Transition::new(845179200, 2),
            Transition::new(859690800, 1),
            Transition::new(876628800, 2),
            Transition::new(889930800, 1),
            Transition::new(906868800, 2),
            Transition::new(923194800, 1),
            Transition::new(939528000, 2),
            Transition::new(952830000, 1),
            Transition::new(971582400, 2),
            Transition::new(984279600, 1),
            Transition::new(1003032000, 2),
            Transition::new(1015729200, 1),
            Transition::new(1034481600, 2),
            Transition::new(1047178800, 1),
            Transition::new(1065931200, 2),
            Transition::new(1079233200, 1),
            Transition::new(1097380800, 2),
            Transition::new(1110682800, 1),
            Transition::new(1128830400, 2),
            Transition::new(1142132400, 1),
            Transition::new(1160884800, 2),
            Transition::new(1173582000, 1),
            Transition::new(1192334400, 2),
            Transition::new(1206846000, 1),
            Transition::new(1223784000, 2),
            Transition::new(1237086000, 1),
            Transition::new(1255233600, 2),
            Transition::new(1270350000, 1),
            Transition::new(1286683200, 2),
            Transition::new(1304823600, 1),
            Transition::new(1313899200, 2),
            Transition::new(1335668400, 1),
            Transition::new(1346558400, 2),
            Transition::new(1367118000, 1),
            Transition::new(1378612800, 2),
            Transition::new(1398567600, 1),
            Transition::new(1410062400, 2),
            Transition::new(1463281200, 1),
            Transition::new(1471147200, 2),
            Transition::new(1480820400, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_ROTHERA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(218246400, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_SYOWA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-407808000, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_TROLL: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(1108166400, 2),
            Transition::new(1111885200, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, true, Some(b"+02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"+00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(0, false, Some(b"+00")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(7200, true, Some(b"+02")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    3600,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_VOSTOK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-380073600, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ARCTIC_LONGYEARBYEN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2366757780, 2),
            Transition::new(-1691884800, 1),
            Transition::new(-1680573600, 2),
            Transition::new(-927511200, 1),
            Transition::new(-857257200, 2),
            Transition::new(-844556400, 1),
            Transition::new(-828226800, 2),
            Transition::new(-812502000, 1),
            Transition::new(-796777200, 2),
            Transition::new(-781052400, 1),
            Transition::new(-765327600, 2),
            Transition::new(-340844400, 1),
            Transition::new(-324514800, 2),
            Transition::new(-308790000, 1),
            Transition::new(-293065200, 2),
            Transition::new(-277340400, 1),
            Transition::new(-261615600, 2),
            Transition::new(-245890800, 1),
            Transition::new(-230166000, 2),
            Transition::new(-214441200, 1),
            Transition::new(-198716400, 2),
            Transition::new(-182991600, 1),
            Transition::new(-166662000, 2),
            Transition::new(-147913200, 1),
            Transition::new(-135212400, 2),
            Transition::new(323830800, 1),
            Transition::new(338950800, 2),
            Transition::new(354675600, 1),
            Transition::new(370400400, 2),
            Transition::new(386125200, 1),
            Transition::new(401850000, 2),
            Transition::new(417574800, 1),
            Transition::new(433299600, 2),
            Transition::new(449024400, 1),
            Transition::new(465354000, 2),
            Transition::new(481078800, 1),
            Transition::new(496803600, 2),
            Transition::new(512528400, 1),
            Transition::new(528253200, 2),
            Transition::new(543978000, 1),
            Transition::new(559702800, 2),
            Transition::new(575427600, 1),
            Transition::new(591152400, 2),
            Transition::new(606877200, 1),
            Transition::new(622602000, 2),
            Transition::new(638326800, 1),
            Transition::new(654656400, 2),
            Transition::new(670381200, 1),
            Transition::new(686106000, 2),
            Transition::new(701830800, 1),
            Transition::new(717555600, 2),
            Transition::new(733280400, 1),
            Transition::new(749005200, 2),
            Transition::new(764730000, 1),
            Transition::new(780454800, 2),
            Transition::new(796179600, 1),
            Transition::new(811904400, 2),
            Transition::new(828234000, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(2580, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, true, Some(b"CEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"CET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(3600, false, Some(b"CET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(7200, true, Some(b"CEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_ADEN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-631162794, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(10794, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_ALMATY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441170468, 1),
            Transition::new(-1247547600, 3),
            Transition::new(354909600, 2),
            Transition::new(370717200, 3),
            Transition::new(386445600, 2),
            Transition::new(402253200, 3),
            Transition::new(417981600, 2),
            Transition::new(433789200, 3),
            Transition::new(449604000, 2),
            Transition::new(465336000, 3),
            Transition::new(481060800, 2),
            Transition::new(496785600, 3),
            Transition::new(512510400, 2),
            Transition::new(528235200, 3),
            Transition::new(543960000, 2),
            Transition::new(559684800, 3),
            Transition::new(575409600, 2),
            Transition::new(591134400, 3),
            Transition::new(606859200, 2),
            Transition::new(622584000, 3),
            Transition::new(638308800, 2),
            Transition::new(654638400, 3),
            Transition::new(670363200, 4),
            Transition::new(686091600, 1),
            Transition::new(695768400, 3),
            Transition::new(701812800, 2),
            Transition::new(717537600, 3),
            Transition::new(733262400, 2),
            Transition::new(748987200, 3),
            Transition::new(764712000, 2),
            Transition::new(780436800, 3),
            Transition::new(796161600, 2),
            Transition::new(811886400, 3),
            Transition::new(828216000, 2),
            Transition::new(846360000, 3),
            Transition::new(859665600, 2),
            Transition::new(877809600, 3),
            Transition::new(891115200, 2),
            Transition::new(909259200, 3),
            Transition::new(922564800, 2),
            Transition::new(941313600, 3),
            Transition::new(954014400, 2),
            Transition::new(972763200, 3),
            Transition::new(985464000, 2),
            Transition::new(1004212800, 3),
            Transition::new(1017518400, 2),
            Transition::new(1035662400, 3),
            Transition::new(1048968000, 2),
            Transition::new(1067112000, 3),
            Transition::new(1080417600, 2),
            Transition::new(1099166400, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(18468, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, true, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_AMMAN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1230776624, 2),
            Transition::new(108165600, 1),
            Transition::new(118270800, 2),
            Transition::new(136591200, 1),
            Transition::new(149806800, 2),
            Transition::new(168127200, 1),
            Transition::new(181342800, 2),
            Transition::new(199749600, 1),
            Transition::new(215643600, 2),
            Transition::new(231285600, 1),
            Transition::new(244501200, 2),
            Transition::new(262735200, 1),
            Transition::new(275950800, 2),
            Transition::new(481154400, 1),
            Transition::new(496962000, 2),
            Transition::new(512949600, 1),
            Transition::new(528670800, 2),
            Transition::new(544399200, 1),
            Transition::new(560120400, 2),
            Transition::new(575848800, 1),
            Transition::new(592174800, 2),
            Transition::new(610581600, 1),
            Transition::new(623624400, 2),
            Transition::new(641167200, 1),
            Transition::new(655074000, 2),
            Transition::new(671839200, 1),
            Transition::new(685918800, 2),
            Transition::new(702856800, 1),
            Transition::new(717973200, 2),
            Transition::new(733701600, 1),
            Transition::new(749422800, 2),
            Transition::new(765151200, 1),
            Transition::new(779662800, 2),
            Transition::new(797205600, 1),
            Transition::new(811116000, 2),
            Transition::new(828655200, 1),
            Transition::new(843170400, 2),
            Transition::new(860104800, 1),
            Transition::new(874620000, 2),
            Transition::new(891554400, 1),
            Transition::new(906069600, 2),
            Transition::new(930780000, 1),
            Transition::new(938124000, 2),
            Transition::new(954367200, 1),
            Transition::new(970178400, 2),
            Transition::new(985816800, 1),
            Transition::new(1001628000, 2),
            Transition::new(1017352800, 1),
            Transition::new(1033077600, 2),
            Transition::new(1048802400, 1),
            Transition::new(1066946400, 2),
            Transition::new(1080252000, 1),
            Transition::new(1097791200, 2),
            Transition::new(1112306400, 1),
            Transition::new(1128031200, 2),
            Transition::new(1143756000, 1),
            Transition::new(1161900000, 2),
            Transition::new(1175205600, 1),
            Transition::new(1193349600, 2),
            Transition::new(1206655200, 1),
            Transition::new(1225404000, 2),
            Transition::new(1238104800, 1),
            Transition::new(1256853600, 2),
            Transition::new(1269554400, 1),
            Transition::new(1288303200, 2),
            Transition::new(1301608800, 1),
            Transition::new(1319752800, 2),
            Transition::new(1333058400, 1),
            Transition::new(1387486800, 2),
            Transition::new(1395957600, 1),
            Transition::new(1414706400, 2),
            Transition::new(1427407200, 1),
            Transition::new(1446156000, 2),
            Transition::new(1459461600, 1),
            Transition::new(1477605600, 2),
            Transition::new(1490911200, 1),
            Transition::new(1509055200, 2),
            Transition::new(1522360800, 1),
            Transition::new(1540504800, 2),
            Transition::new(1553810400, 1),
            Transition::new(1571954400, 2),
            Transition::new(1585260000, 1),
            Transition::new(1604008800, 2),
            Transition::new(1616709600, 1),
            Transition::new(1635458400, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(8624, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"EEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"EET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(7200, false, Some(b"EET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(10800, true, Some(b"EEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(2, 5, 4) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    86400,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 5) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    3600,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_ANADYR: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441194596, 1),
            Transition::new(-1247572800, 3),
            Transition::new(354884400, 2),
            Transition::new(370692000, 3),
            Transition::new(386420400, 4),
            Transition::new(402231600, 1),
            Transition::new(417960000, 4),
            Transition::new(433767600, 1),
            Transition::new(449582400, 4),
            Transition::new(465314400, 1),
            Transition::new(481039200, 4),
            Transition::new(496764000, 1),
            Transition::new(512488800, 4),
            Transition::new(528213600, 1),
            Transition::new(543938400, 4),
            Transition::new(559663200, 1),
            Transition::new(575388000, 4),
            Transition::new(591112800, 1),
            Transition::new(606837600, 4),
            Transition::new(622562400, 1),
            Transition::new(638287200, 4),
            Transition::new(654616800, 1),
            Transition::new(670341600, 5),
            Transition::new(686070000, 6),
            Transition::new(695746800, 1),
            Transition::new(701791200, 4),
            Transition::new(717516000, 1),
            Transition::new(733240800, 4),
            Transition::new(748965600, 1),
            Transition::new(764690400, 4),
            Transition::new(780415200, 1),
            Transition::new(796140000, 4),
            Transition::new(811864800, 1),
            Transition::new(828194400, 4),
            Transition::new(846338400, 1),
            Transition::new(859644000, 4),
            Transition::new(877788000, 1),
            Transition::new(891093600, 4),
            Transition::new(909237600, 1),
            Transition::new(922543200, 4),
            Transition::new(941292000, 1),
            Transition::new(953992800, 4),
            Transition::new(972741600, 1),
            Transition::new(985442400, 4),
            Transition::new(1004191200, 1),
            Transition::new(1017496800, 4),
            Transition::new(1035640800, 1),
            Transition::new(1048946400, 4),
            Transition::new(1067090400, 1),
            Transition::new(1080396000, 4),
            Transition::new(1099144800, 1),
            Transition::new(1111845600, 4),
            Transition::new(1130594400, 1),
            Transition::new(1143295200, 4),
            Transition::new(1162044000, 1),
            Transition::new(1174744800, 4),
            Transition::new(1193493600, 1),
            Transition::new(1206799200, 4),
            Transition::new(1224943200, 1),
            Transition::new(1238248800, 4),
            Transition::new(1256392800, 1),
            Transition::new(1269698400, 5),
            Transition::new(1288450800, 6),
            Transition::new(1301151600, 1),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(42596, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(43200, false, Some(b"+12")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(50400, true, Some(b"+14")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(46800, false, Some(b"+13")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(46800, true, Some(b"+13")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(43200, true, Some(b"+12")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, false, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(43200, false, Some(b"+12")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_AQTAU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441164064, 1),
            Transition::new(-1247544000, 2),
            Transition::new(370724400, 3),
            Transition::new(386445600, 4),
            Transition::new(402256800, 2),
            Transition::new(417985200, 4),
            Transition::new(433792800, 2),
            Transition::new(449607600, 4),
            Transition::new(465339600, 2),
            Transition::new(481064400, 4),
            Transition::new(496789200, 2),
            Transition::new(512514000, 4),
            Transition::new(528238800, 2),
            Transition::new(543963600, 4),
            Transition::new(559688400, 2),
            Transition::new(575413200, 4),
            Transition::new(591138000, 2),
            Transition::new(606862800, 4),
            Transition::new(622587600, 2),
            Transition::new(638312400, 4),
            Transition::new(654642000, 2),
            Transition::new(670366800, 5),
            Transition::new(686095200, 1),
            Transition::new(695772000, 2),
            Transition::new(701816400, 4),
            Transition::new(717541200, 2),
            Transition::new(733266000, 4),
            Transition::new(748990800, 2),
            Transition::new(764715600, 4),
            Transition::new(780440400, 1),
            Transition::new(796168800, 5),
            Transition::new(811893600, 1),
            Transition::new(828223200, 5),
            Transition::new(846367200, 1),
            Transition::new(859672800, 5),
            Transition::new(877816800, 1),
            Transition::new(891122400, 5),
            Transition::new(909266400, 1),
            Transition::new(922572000, 5),
            Transition::new(941320800, 1),
            Transition::new(954021600, 5),
            Transition::new(972770400, 1),
            Transition::new(985471200, 5),
            Transition::new(1004220000, 1),
            Transition::new(1017525600, 5),
            Transition::new(1035669600, 1),
            Transition::new(1048975200, 5),
            Transition::new(1067119200, 1),
            Transition::new(1080424800, 5),
            Transition::new(1099173600, 2),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(12064, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, true, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_AQTOBE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441165720, 1),
            Transition::new(-1247544000, 2),
            Transition::new(354913200, 3),
            Transition::new(370720800, 4),
            Transition::new(386445600, 3),
            Transition::new(402256800, 2),
            Transition::new(417985200, 3),
            Transition::new(433792800, 2),
            Transition::new(449607600, 3),
            Transition::new(465339600, 2),
            Transition::new(481064400, 3),
            Transition::new(496789200, 2),
            Transition::new(512514000, 3),
            Transition::new(528238800, 2),
            Transition::new(543963600, 3),
            Transition::new(559688400, 2),
            Transition::new(575413200, 3),
            Transition::new(591138000, 2),
            Transition::new(606862800, 3),
            Transition::new(622587600, 2),
            Transition::new(638312400, 3),
            Transition::new(654642000, 2),
            Transition::new(670366800, 5),
            Transition::new(686095200, 1),
            Transition::new(695772000, 2),
            Transition::new(701816400, 3),
            Transition::new(717541200, 2),
            Transition::new(733266000, 3),
            Transition::new(748990800, 2),
            Transition::new(764715600, 3),
            Transition::new(780440400, 2),
            Transition::new(796165200, 3),
            Transition::new(811890000, 2),
            Transition::new(828219600, 3),
            Transition::new(846363600, 2),
            Transition::new(859669200, 3),
            Transition::new(877813200, 2),
            Transition::new(891118800, 3),
            Transition::new(909262800, 2),
            Transition::new(922568400, 3),
            Transition::new(941317200, 2),
            Transition::new(954018000, 3),
            Transition::new(972766800, 2),
            Transition::new(985467600, 3),
            Transition::new(1004216400, 2),
            Transition::new(1017522000, 3),
            Transition::new(1035666000, 2),
            Transition::new(1048971600, 3),
            Transition::new(1067115600, 2),
            Transition::new(1080421200, 3),
            Transition::new(1099170000, 2),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(13720, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, true, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_ASHGABAT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441166012, 1),
            Transition::new(-1247544000, 3),
            Transition::new(354913200, 2),
            Transition::new(370720800, 3),
            Transition::new(386449200, 2),
            Transition::new(402256800, 3),
            Transition::new(417985200, 2),
            Transition::new(433792800, 3),
            Transition::new(449607600, 2),
            Transition::new(465339600, 3),
            Transition::new(481064400, 2),
            Transition::new(496789200, 3),
            Transition::new(512514000, 2),
            Transition::new(528238800, 3),
            Transition::new(543963600, 2),
            Transition::new(559688400, 3),
            Transition::new(575413200, 2),
            Transition::new(591138000, 3),
            Transition::new(606862800, 2),
            Transition::new(622587600, 3),
            Transition::new(638312400, 2),
            Transition::new(654642000, 3),
            Transition::new(670366800, 4),
            Transition::new(686095200, 1),
            Transition::new(695772000, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(14012, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, true, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_ATYRAU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441164464, 1),
            Transition::new(-1247540400, 2),
            Transition::new(370724400, 3),
            Transition::new(386445600, 4),
            Transition::new(402256800, 2),
            Transition::new(417985200, 4),
            Transition::new(433792800, 2),
            Transition::new(449607600, 4),
            Transition::new(465339600, 2),
            Transition::new(481064400, 4),
            Transition::new(496789200, 2),
            Transition::new(512514000, 4),
            Transition::new(528238800, 2),
            Transition::new(543963600, 4),
            Transition::new(559688400, 2),
            Transition::new(575413200, 4),
            Transition::new(591138000, 2),
            Transition::new(606862800, 4),
            Transition::new(622587600, 2),
            Transition::new(638312400, 4),
            Transition::new(654642000, 2),
            Transition::new(670366800, 5),
            Transition::new(686095200, 6),
            Transition::new(695772000, 2),
            Transition::new(701816400, 4),
            Transition::new(717541200, 2),
            Transition::new(733266000, 4),
            Transition::new(748990800, 2),
            Transition::new(764715600, 4),
            Transition::new(780440400, 2),
            Transition::new(796165200, 4),
            Transition::new(811890000, 2),
            Transition::new(828219600, 4),
            Transition::new(846363600, 2),
            Transition::new(859669200, 4),
            Transition::new(877813200, 2),
            Transition::new(891118800, 4),
            Transition::new(909262800, 2),
            Transition::new(922568400, 5),
            Transition::new(941320800, 6),
            Transition::new(954021600, 5),
            Transition::new(972770400, 6),
            Transition::new(985471200, 5),
            Transition::new(1004220000, 6),
            Transition::new(1017525600, 5),
            Transition::new(1035669600, 6),
            Transition::new(1048975200, 5),
            Transition::new(1067119200, 6),
            Transition::new(1080424800, 5),
            Transition::new(1099173600, 2),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(12464, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, true, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_BAGHDAD: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524532260, 1),
            Transition::new(-1641005856, 2),
            Transition::new(389048400, 3),
            Transition::new(402264000, 2),
            Transition::new(417906000, 3),
            Transition::new(433800000, 2),
            Transition::new(449614800, 3),
            Transition::new(465422400, 2),
            Transition::new(481150800, 3),
            Transition::new(496792800, 2),
            Transition::new(512517600, 3),
            Transition::new(528242400, 2),
            Transition::new(543967200, 3),
            Transition::new(559692000, 2),
            Transition::new(575416800, 3),
            Transition::new(591141600, 2),
            Transition::new(606866400, 3),
            Transition::new(622591200, 2),
            Transition::new(638316000, 3),
            Transition::new(654645600, 2),
            Transition::new(670464000, 3),
            Transition::new(686275200, 2),
            Transition::new(702086400, 3),
            Transition::new(717897600, 2),
            Transition::new(733622400, 3),
            Transition::new(749433600, 2),
            Transition::new(765158400, 3),
            Transition::new(780969600, 2),
            Transition::new(796694400, 3),
            Transition::new(812505600, 2),
            Transition::new(828316800, 3),
            Transition::new(844128000, 2),
            Transition::new(859852800, 3),
            Transition::new(875664000, 2),
            Transition::new(891388800, 3),
            Transition::new(907200000, 2),
            Transition::new(922924800, 3),
            Transition::new(938736000, 2),
            Transition::new(954547200, 3),
            Transition::new(970358400, 2),
            Transition::new(986083200, 3),
            Transition::new(1001894400, 2),
            Transition::new(1017619200, 3),
            Transition::new(1033430400, 2),
            Transition::new(1049155200, 3),
            Transition::new(1064966400, 2),
            Transition::new(1080777600, 3),
            Transition::new(1096588800, 2),
            Transition::new(1112313600, 3),
            Transition::new(1128124800, 2),
            Transition::new(1143849600, 3),
            Transition::new(1159660800, 2),
            Transition::new(1175385600, 3),
            Transition::new(1191196800, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(10660, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10656, false, Some(b"BMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, true, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_BAHRAIN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-897880940, 1),
            Transition::new(-820553400, 2),
            Transition::new(76190400, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(12140, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(12600, false, Some(b"+0330")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_BAKU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441163964, 1),
            Transition::new(-405140400, 3),
            Transition::new(354916800, 2),
            Transition::new(370724400, 3),
            Transition::new(386452800, 2),
            Transition::new(402260400, 3),
            Transition::new(417988800, 2),
            Transition::new(433796400, 3),
            Transition::new(449611200, 2),
            Transition::new(465343200, 3),
            Transition::new(481068000, 2),
            Transition::new(496792800, 3),
            Transition::new(512517600, 2),
            Transition::new(528242400, 3),
            Transition::new(543967200, 2),
            Transition::new(559692000, 3),
            Transition::new(575416800, 2),
            Transition::new(591141600, 3),
            Transition::new(606866400, 2),
            Transition::new(622591200, 3),
            Transition::new(638316000, 2),
            Transition::new(654645600, 3),
            Transition::new(670370400, 4),
            Transition::new(686098800, 1),
            Transition::new(701823600, 4),
            Transition::new(717548400, 3),
            Transition::new(828234000, 2),
            Transition::new(846378000, 3),
            Transition::new(859680000, 2),
            Transition::new(877824000, 3),
            Transition::new(891129600, 2),
            Transition::new(909273600, 3),
            Transition::new(922579200, 2),
            Transition::new(941328000, 3),
            Transition::new(954028800, 2),
            Transition::new(972777600, 3),
            Transition::new(985478400, 2),
            Transition::new(1004227200, 3),
            Transition::new(1017532800, 2),
            Transition::new(1035676800, 3),
            Transition::new(1048982400, 2),
            Transition::new(1067126400, 3),
            Transition::new(1080432000, 2),
            Transition::new(1099180800, 3),
            Transition::new(1111881600, 2),
            Transition::new(1130630400, 3),
            Transition::new(1143331200, 2),
            Transition::new(1162080000, 3),
            Transition::new(1174780800, 2),
            Transition::new(1193529600, 3),
            Transition::new(1206835200, 2),
            Transition::new(1224979200, 3),
            Transition::new(1238284800, 2),
            Transition::new(1256428800, 3),
            Transition::new(1269734400, 2),
            Transition::new(1288483200, 3),
            Transition::new(1301184000, 2),
            Transition::new(1319932800, 3),
            Transition::new(1332633600, 2),
            Transition::new(1351382400, 3),
            Transition::new(1364688000, 2),
            Transition::new(1382832000, 3),
            Transition::new(1396137600, 2),
            Transition::new(1414281600, 3),
            Transition::new(1427587200, 2),
            Transition::new(1445731200, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(11964, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, true, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, true, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_BANGKOK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2840164924, 1),
            Transition::new(-1570084924, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(24124, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(24124, false, Some(b"BMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_BARNAUL: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1579844100, 1),
            Transition::new(-1247551200, 3),
            Transition::new(354906000, 2),
            Transition::new(370713600, 3),
            Transition::new(386442000, 2),
            Transition::new(402249600, 3),
            Transition::new(417978000, 2),
            Transition::new(433785600, 3),
            Transition::new(449600400, 2),
            Transition::new(465332400, 3),
            Transition::new(481057200, 2),
            Transition::new(496782000, 3),
            Transition::new(512506800, 2),
            Transition::new(528231600, 3),
            Transition::new(543956400, 2),
            Transition::new(559681200, 3),
            Transition::new(575406000, 2),
            Transition::new(591130800, 3),
            Transition::new(606855600, 2),
            Transition::new(622580400, 3),
            Transition::new(638305200, 2),
            Transition::new(654634800, 3),
            Transition::new(670359600, 4),
            Transition::new(686088000, 1),
            Transition::new(695764800, 3),
            Transition::new(701809200, 2),
            Transition::new(717534000, 3),
            Transition::new(733258800, 2),
            Transition::new(748983600, 3),
            Transition::new(764708400, 2),
            Transition::new(780433200, 3),
            Transition::new(796158000, 2),
            Transition::new(801590400, 4),
            Transition::new(811886400, 1),
            Transition::new(828216000, 4),
            Transition::new(846360000, 1),
            Transition::new(859665600, 4),
            Transition::new(877809600, 1),
            Transition::new(891115200, 4),
            Transition::new(909259200, 1),
            Transition::new(922564800, 4),
            Transition::new(941313600, 1),
            Transition::new(954014400, 4),
            Transition::new(972763200, 1),
            Transition::new(985464000, 4),
            Transition::new(1004212800, 1),
            Transition::new(1017518400, 4),
            Transition::new(1035662400, 1),
            Transition::new(1048968000, 4),
            Transition::new(1067112000, 1),
            Transition::new(1080417600, 4),
            Transition::new(1099166400, 1),
            Transition::new(1111867200, 4),
            Transition::new(1130616000, 1),
            Transition::new(1143316800, 4),
            Transition::new(1162065600, 1),
            Transition::new(1174766400, 4),
            Transition::new(1193515200, 1),
            Transition::new(1206820800, 4),
            Transition::new(1224964800, 1),
            Transition::new(1238270400, 4),
            Transition::new(1256414400, 1),
            Transition::new(1269720000, 4),
            Transition::new(1288468800, 1),
            Transition::new(1301169600, 3),
            Transition::new(1414263600, 1),
            Transition::new(1459022400, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(20100, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, true, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, true, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_BEIRUT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2840149320, 2),
            Transition::new(-1570413600, 1),
            Transition::new(-1552186800, 2),
            Transition::new(-1538359200, 1),
            Transition::new(-1522551600, 2),
            Transition::new(-1507514400, 1),
            Transition::new(-1490583600, 2),
            Transition::new(-1473645600, 1),
            Transition::new(-1460948400, 2),
            Transition::new(-399866400, 1),
            Transition::new(-386650800, 2),
            Transition::new(-368330400, 1),
            Transition::new(-355114800, 2),
            Transition::new(-336794400, 1),
            Transition::new(-323578800, 2),
            Transition::new(-305172000, 1),
            Transition::new(-291956400, 2),
            Transition::new(-273636000, 1),
            Transition::new(-260420400, 2),
            Transition::new(78012000, 1),
            Transition::new(86734800, 2),
            Transition::new(105055200, 1),
            Transition::new(118270800, 2),
            Transition::new(136591200, 1),
            Transition::new(149806800, 2),
            Transition::new(168127200, 1),
            Transition::new(181342800, 2),
            Transition::new(199749600, 1),
            Transition::new(212965200, 2),
            Transition::new(231285600, 1),
            Transition::new(244501200, 2),
            Transition::new(262735200, 1),
            Transition::new(275950800, 2),
            Transition::new(452210400, 1),
            Transition::new(466722000, 2),
            Transition::new(483746400, 1),
            Transition::new(498258000, 2),
            Transition::new(515282400, 1),
            Transition::new(529794000, 2),
            Transition::new(546818400, 1),
            Transition::new(561330000, 2),
            Transition::new(581119200, 1),
            Transition::new(592952400, 2),
            Transition::new(610754400, 1),
            Transition::new(624488400, 2),
            Transition::new(641512800, 1),
            Transition::new(656024400, 2),
            Transition::new(673048800, 1),
            Transition::new(687560400, 2),
            Transition::new(704671200, 1),
            Transition::new(718146000, 2),
            Transition::new(733269600, 1),
            Transition::new(748990800, 2),
            Transition::new(764719200, 1),
            Transition::new(780440400, 2),
            Transition::new(796168800, 1),
            Transition::new(811890000, 2),
            Transition::new(828223200, 1),
            Transition::new(843944400, 2),
            Transition::new(859672800, 1),
            Transition::new(875394000, 2),
            Transition::new(891122400, 1),
            Transition::new(906843600, 2),
            Transition::new(922572000, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(8520, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"EEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"EET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(7200, false, Some(b"EET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(10800, true, Some(b"EEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_BISHKEK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441169904, 1),
            Transition::new(-1247547600, 3),
            Transition::new(354909600, 2),
            Transition::new(370717200, 3),
            Transition::new(386445600, 2),
            Transition::new(402253200, 3),
            Transition::new(417981600, 2),
            Transition::new(433789200, 3),
            Transition::new(449604000, 2),
            Transition::new(465336000, 3),
            Transition::new(481060800, 2),
            Transition::new(496785600, 3),
            Transition::new(512510400, 2),
            Transition::new(528235200, 3),
            Transition::new(543960000, 2),
            Transition::new(559684800, 3),
            Transition::new(575409600, 2),
            Transition::new(591134400, 3),
            Transition::new(606859200, 2),
            Transition::new(622584000, 3),
            Transition::new(638308800, 2),
            Transition::new(654638400, 3),
            Transition::new(670363200, 4),
            Transition::new(683582400, 1),
            Transition::new(703018800, 4),
            Transition::new(717530400, 1),
            Transition::new(734468400, 4),
            Transition::new(748980000, 1),
            Transition::new(765918000, 4),
            Transition::new(780429600, 1),
            Transition::new(797367600, 4),
            Transition::new(811879200, 1),
            Transition::new(828817200, 4),
            Transition::new(843933600, 1),
            Transition::new(859671000, 4),
            Transition::new(877811400, 1),
            Transition::new(891120600, 4),
            Transition::new(909261000, 1),
            Transition::new(922570200, 4),
            Transition::new(941315400, 1),
            Transition::new(954019800, 4),
            Transition::new(972765000, 1),
            Transition::new(985469400, 4),
            Transition::new(1004214600, 1),
            Transition::new(1017523800, 4),
            Transition::new(1035664200, 1),
            Transition::new(1048973400, 4),
            Transition::new(1067113800, 1),
            Transition::new(1080423000, 4),
            Transition::new(1099168200, 1),
            Transition::new(1111872600, 4),
            Transition::new(1123783200, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(17904, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, true, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_BRUNEI: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1383464380, 1),
            Transition::new(-1167636600, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(27580, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(27000, false, Some(b"+0730")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_CALCUTTA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3645237208, 1),
            Transition::new(-3155694800, 2),
            Transition::new(-2019705670, 3),
            Transition::new(-891581400, 4),
            Transition::new(-872058600, 3),
            Transition::new(-862637400, 4),
            Transition::new(-764145000, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(21208, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21200, false, Some(b"HMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(19270, false, Some(b"MMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(19800, false, Some(b"IST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(23400, true, Some(b"+0630")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(19800, false, Some(b"IST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_CHITA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1579419232, 1),
            Transition::new(-1247558400, 3),
            Transition::new(354898800, 2),
            Transition::new(370706400, 3),
            Transition::new(386434800, 2),
            Transition::new(402242400, 3),
            Transition::new(417970800, 2),
            Transition::new(433778400, 3),
            Transition::new(449593200, 2),
            Transition::new(465325200, 3),
            Transition::new(481050000, 2),
            Transition::new(496774800, 3),
            Transition::new(512499600, 2),
            Transition::new(528224400, 3),
            Transition::new(543949200, 2),
            Transition::new(559674000, 3),
            Transition::new(575398800, 2),
            Transition::new(591123600, 3),
            Transition::new(606848400, 2),
            Transition::new(622573200, 3),
            Transition::new(638298000, 2),
            Transition::new(654627600, 3),
            Transition::new(670352400, 4),
            Transition::new(686080800, 1),
            Transition::new(695757600, 3),
            Transition::new(701802000, 2),
            Transition::new(717526800, 3),
            Transition::new(733251600, 2),
            Transition::new(748976400, 3),
            Transition::new(764701200, 2),
            Transition::new(780426000, 3),
            Transition::new(796150800, 2),
            Transition::new(811875600, 3),
            Transition::new(828205200, 2),
            Transition::new(846349200, 3),
            Transition::new(859654800, 2),
            Transition::new(877798800, 3),
            Transition::new(891104400, 2),
            Transition::new(909248400, 3),
            Transition::new(922554000, 2),
            Transition::new(941302800, 3),
            Transition::new(954003600, 2),
            Transition::new(972752400, 3),
            Transition::new(985453200, 2),
            Transition::new(1004202000, 3),
            Transition::new(1017507600, 2),
            Transition::new(1035651600, 3),
            Transition::new(1048957200, 2),
            Transition::new(1067101200, 3),
            Transition::new(1080406800, 2),
            Transition::new(1099155600, 3),
            Transition::new(1111856400, 2),
            Transition::new(1130605200, 3),
            Transition::new(1143306000, 2),
            Transition::new(1162054800, 3),
            Transition::new(1174755600, 2),
            Transition::new(1193504400, 3),
            Transition::new(1206810000, 2),
            Transition::new(1224954000, 3),
            Transition::new(1238259600, 2),
            Transition::new(1256403600, 3),
            Transition::new(1269709200, 2),
            Transition::new(1288458000, 3),
            Transition::new(1301158800, 5),
            Transition::new(1414252800, 1),
            Transition::new(1459015200, 3),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(27232, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, true, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, true, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_CHOIBALSAN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2032933080, 1),
            Transition::new(252435600, 2),
            Transition::new(417974400, 4),
            Transition::new(433778400, 3),
            Transition::new(449593200, 4),
            Transition::new(465314400, 3),
            Transition::new(481042800, 4),
            Transition::new(496764000, 3),
            Transition::new(512492400, 4),
            Transition::new(528213600, 3),
            Transition::new(543942000, 4),
            Transition::new(559663200, 3),
            Transition::new(575391600, 4),
            Transition::new(591112800, 3),
            Transition::new(606841200, 4),
            Transition::new(622562400, 3),
            Transition::new(638290800, 4),
            Transition::new(654616800, 3),
            Transition::new(670345200, 4),
            Transition::new(686066400, 3),
            Transition::new(701794800, 4),
            Transition::new(717516000, 3),
            Transition::new(733244400, 4),
            Transition::new(748965600, 3),
            Transition::new(764694000, 4),
            Transition::new(780415200, 3),
            Transition::new(796143600, 4),
            Transition::new(811864800, 3),
            Transition::new(828198000, 4),
            Transition::new(843919200, 3),
            Transition::new(859647600, 4),
            Transition::new(875368800, 3),
            Transition::new(891097200, 4),
            Transition::new(906818400, 3),
            Transition::new(988390800, 4),
            Transition::new(1001692800, 3),
            Transition::new(1017421200, 4),
            Transition::new(1033142400, 3),
            Transition::new(1048870800, 4),
            Transition::new(1064592000, 3),
            Transition::new(1080320400, 4),
            Transition::new(1096041600, 3),
            Transition::new(1111770000, 4),
            Transition::new(1127491200, 3),
            Transition::new(1143219600, 4),
            Transition::new(1159545600, 3),
            Transition::new(1206889200, 2),
            Transition::new(1427479200, 5),
            Transition::new(1443193200, 2),
            Transition::new(1458928800, 5),
            Transition::new(1474642800, 2),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(27480, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, true, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, true, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_CHONGQING: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1325487980, 1),
            Transition::new(325962000, 3),
            Transition::new(515527200, 2),
            Transition::new(527014800, 3),
            Transition::new(545162400, 2),
            Transition::new(558464400, 3),
            Transition::new(577216800, 2),
            Transition::new(589914000, 3),
            Transition::new(608666400, 2),
            Transition::new(621968400, 3),
            Transition::new(640116000, 2),
            Transition::new(653418000, 3),
            Transition::new(671565600, 2),
            Transition::new(684867600, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(25580, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(28800, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_COLOMBO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2840159964, 1),
            Transition::new(-2019705572, 2),
            Transition::new(-883287000, 3),
            Transition::new(-862639200, 4),
            Transition::new(-764051400, 2),
            Transition::new(832962600, 5),
            Transition::new(846266400, 6),
            Transition::new(1145039400, 2),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(19164, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(19172, false, Some(b"MMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(19800, false, Some(b"+0530")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(23400, true, Some(b"+0630")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(23400, false, Some(b"+0630")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(19800, false, Some(b"+0530")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_DACCA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524543300, 1),
            Transition::new(-891582800, 2),
            Transition::new(-872058600, 3),
            Transition::new(-862637400, 2),
            Transition::new(-576138600, 4),
            Transition::new(1245430800, 5),
            Transition::new(1262278800, 4),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(21700, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21200, false, Some(b"HMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(23400, false, Some(b"+0630")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(19800, false, Some(b"+0530")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, true, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_DAMASCUS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1577931912, 2),
            Transition::new(-1568592000, 1),
            Transition::new(-1554080400, 2),
            Transition::new(-1537142400, 1),
            Transition::new(-1522630800, 2),
            Transition::new(-1505692800, 1),
            Transition::new(-1491181200, 2),
            Transition::new(-1474243200, 1),
            Transition::new(-1459126800, 2),
            Transition::new(-242265600, 1),
            Transition::new(-228877200, 2),
            Transition::new(-210556800, 1),
            Transition::new(-197427600, 2),
            Transition::new(-178934400, 1),
            Transition::new(-165718800, 2),
            Transition::new(-147398400, 1),
            Transition::new(-134269200, 2),
            Transition::new(-116467200, 1),
            Transition::new(-102646800, 2),
            Transition::new(-84326400, 1),
            Transition::new(-71110800, 2),
            Transition::new(-52704000, 1),
            Transition::new(-39488400, 2),
            Transition::new(-21168000, 1),
            Transition::new(-7952400, 2),
            Transition::new(10368000, 1),
            Transition::new(23583600, 2),
            Transition::new(41904000, 1),
            Transition::new(55119600, 2),
            Transition::new(73526400, 1),
            Transition::new(86742000, 2),
            Transition::new(105062400, 1),
            Transition::new(118278000, 2),
            Transition::new(136598400, 1),
            Transition::new(149814000, 2),
            Transition::new(168134400, 1),
            Transition::new(181350000, 2),
            Transition::new(199756800, 1),
            Transition::new(212972400, 2),
            Transition::new(231292800, 1),
            Transition::new(241916400, 2),
            Transition::new(262828800, 1),
            Transition::new(273452400, 2),
            Transition::new(418694400, 1),
            Transition::new(433810800, 2),
            Transition::new(450316800, 1),
            Transition::new(465433200, 2),
            Transition::new(508896000, 1),
            Transition::new(529196400, 2),
            Transition::new(541555200, 1),
            Transition::new(562633200, 2),
            Transition::new(574387200, 1),
            Transition::new(594255600, 2),
            Transition::new(607305600, 1),
            Transition::new(623199600, 2),
            Transition::new(638928000, 1),
            Transition::new(654649200, 2),
            Transition::new(670456800, 1),
            Transition::new(686264400, 2),
            Transition::new(702684000, 1),
            Transition::new(717886800, 2),
            Transition::new(733096800, 1),
            Transition::new(748904400, 2),
            Transition::new(765151200, 1),
            Transition::new(780958800, 2),
            Transition::new(796687200, 1),
            Transition::new(812494800, 2),
            Transition::new(828309600, 1),
            Transition::new(844117200, 2),
            Transition::new(859759200, 1),
            Transition::new(875653200, 2),
            Transition::new(891208800, 1),
            Transition::new(907189200, 2),
            Transition::new(922917600, 1),
            Transition::new(938725200, 2),
            Transition::new(954540000, 1),
            Transition::new(970347600, 2),
            Transition::new(986076000, 1),
            Transition::new(1001883600, 2),
            Transition::new(1017612000, 1),
            Transition::new(1033419600, 2),
            Transition::new(1049148000, 1),
            Transition::new(1064955600, 2),
            Transition::new(1080770400, 1),
            Transition::new(1096578000, 2),
            Transition::new(1112306400, 1),
            Transition::new(1128114000, 2),
            Transition::new(1143842400, 1),
            Transition::new(1158872400, 2),
            Transition::new(1175205600, 1),
            Transition::new(1193950800, 2),
            Transition::new(1207260000, 1),
            Transition::new(1225486800, 2),
            Transition::new(1238104800, 1),
            Transition::new(1256850000, 2),
            Transition::new(1270159200, 1),
            Transition::new(1288299600, 2),
            Transition::new(1301608800, 1),
            Transition::new(1319749200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(8712, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"EEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"EET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(7200, false, Some(b"EET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(10800, true, Some(b"EEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 5) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 5) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_DILI: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1830414140, 1),
            Transition::new(-879152400, 2),
            Transition::new(199897200, 1),
            Transition::new(969120000, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(30140, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_DUBAI: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1577936472, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(13272, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fix