// SPDX-License-Identifier: MIT-0
//
// GENERATED FILE
// ALL CHANGES MADE IN THIS FILE WILL BE LOST!
//
// MIT No Attribution
//
// Copyright 2022 René Kijewski <crates.io@k6i.de>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
// associated documentation files (the "Software"), to deal in the Software without restriction,
// including without limitation the rights to use, copy, modify, merge, publish, distribute,
// sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
// NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

use tz::TimeZoneRef;

/// All defined time zones statically accessible
pub mod time_zone {
    use super::*;

    /// africa
    pub mod africa {
        use super::*;

        /// Africa/Abidjan,
        pub const ABIDJAN: TimeZoneRef<'static> = tzdata::AFRICA_ABIDJAN;
        /// Africa/Accra,
        pub const ACCRA: TimeZoneRef<'static> = tzdata::AFRICA_ABIDJAN;
        /// Africa/Addis_Ababa,
        pub const ADDIS_ABABA: TimeZoneRef<'static> = tzdata::AFRICA_ADDIS_ABABA;
        /// Africa/Algiers,
        pub const ALGIERS: TimeZoneRef<'static> = tzdata::AFRICA_ALGIERS;
        /// Africa/Asmara,
        pub const ASMARA: TimeZoneRef<'static> = tzdata::AFRICA_ADDIS_ABABA;
        /// Africa/Asmera,
        pub const ASMERA: TimeZoneRef<'static> = tzdata::AFRICA_ADDIS_ABABA;
        /// Africa/Bamako,
        pub const BAMAKO: TimeZoneRef<'static> = tzdata::AFRICA_ABIDJAN;
        /// Africa/Bangui,
        pub const BANGUI: TimeZoneRef<'static> = tzdata::AFRICA_BANGUI;
        /// Africa/Banjul,
        pub const BANJUL: TimeZoneRef<'static> = tzdata::AFRICA_ABIDJAN;
        /// Africa/Bissau,
        pub const BISSAU: TimeZoneRef<'static> = tzdata::AFRICA_BISSAU;
        /// Africa/Blantyre,
        pub const BLANTYRE: TimeZoneRef<'static> = tzdata::AFRICA_BLANTYRE;
        /// Africa/Brazzaville,
        pub const BRAZZAVILLE: TimeZoneRef<'static> = tzdata::AFRICA_BANGUI;
        /// Africa/Bujumbura,
        pub const BUJUMBURA: TimeZoneRef<'static> = tzdata::AFRICA_BLANTYRE;
        /// Africa/Cairo,
        pub const CAIRO: TimeZoneRef<'static> = tzdata::EGYPT;
        /// Africa/Casablanca,
        pub const CASABLANCA: TimeZoneRef<'static> = tzdata::AFRICA_CASABLANCA;
        /// Africa/Ceuta,
        pub const CEUTA: TimeZoneRef<'static> = tzdata::AFRICA_CEUTA;
        /// Africa/Conakry,
        pub const CONAKRY: TimeZoneRef<'static> = tzdata::AFRICA_ABIDJAN;
        /// Africa/Dakar,
        pub const DAKAR: TimeZoneRef<'static> = tzdata::AFRICA_ABIDJAN;
        /// Africa/Dar_es_Salaam,
        pub const DAR_ES_SALAAM: TimeZoneRef<'static> = tzdata::AFRICA_ADDIS_ABABA;
        /// Africa/Djibouti,
        pub const DJIBOUTI: TimeZoneRef<'static> = tzdata::AFRICA_ADDIS_ABABA;
        /// Africa/Douala,
        pub const DOUALA: TimeZoneRef<'static> = tzdata::AFRICA_BANGUI;
        /// Africa/El_Aaiun,
        pub const EL_AAIUN: TimeZoneRef<'static> = tzdata::AFRICA_EL_AAIUN;
        /// Africa/Freetown,
        pub const FREETOWN: TimeZoneRef<'static> = tzdata::AFRICA_ABIDJAN;
        /// Africa/Gaborone,
        pub const GABORONE: TimeZoneRef<'static> = tzdata::AFRICA_BLANTYRE;
        /// Africa/Harare,
        pub const HARARE: TimeZoneRef<'static> = tzdata::AFRICA_BLANTYRE;
        /// Africa/Johannesburg,
        pub const JOHANNESBURG: TimeZoneRef<'static> = tzdata::AFRICA_JOHANNESBURG;
        /// Africa/Juba,
        pub const JUBA: TimeZoneRef<'static> = tzdata::AFRICA_JUBA;
        /// Africa/Kampala,
        pub const KAMPALA: TimeZoneRef<'static> = tzdata::AFRICA_ADDIS_ABABA;
        /// Africa/Khartoum,
        pub const KHARTOUM: TimeZoneRef<'static> = tzdata::AFRICA_KHARTOUM;
        /// Africa/Kigali,
        pub const KIGALI: TimeZoneRef<'static> = tzdata::AFRICA_BLANTYRE;
        /// Africa/Kinshasa,
        pub const KINSHASA: TimeZoneRef<'static> = tzdata::AFRICA_BANGUI;
        /// Africa/Lagos,
        pub const LAGOS: TimeZoneRef<'static> = tzdata::AFRICA_BANGUI;
        /// Africa/Libreville,
        pub const LIBREVILLE: TimeZoneRef<'static> = tzdata::AFRICA_BANGUI;
        /// Africa/Lome,
        pub const LOME: TimeZoneRef<'static> = tzdata::AFRICA_ABIDJAN;
        /// Africa/Luanda,
        pub const LUANDA: TimeZoneRef<'static> = tzdata::AFRICA_BANGUI;
        /// Africa/Lubumbashi,
        pub const LUBUMBASHI: TimeZoneRef<'static> = tzdata::AFRICA_BLANTYRE;
        /// Africa/Lusaka,
        pub const LUSAKA: TimeZoneRef<'static> = tzdata::AFRICA_BLANTYRE;
        /// Africa/Malabo,
        pub const MALABO: TimeZoneRef<'static> = tzdata::AFRICA_BANGUI;
        /// Africa/Maputo,
        pub const MAPUTO: TimeZoneRef<'static> = tzdata::AFRICA_BLANTYRE;
        /// Africa/Maseru,
        pub const MASERU: TimeZoneRef<'static> = tzdata::AFRICA_JOHANNESBURG;
        /// Africa/Mbabane,
        pub const MBABANE: TimeZoneRef<'static> = tzdata::AFRICA_JOHANNESBURG;
        /// Africa/Mogadishu,
        pub const MOGADISHU: TimeZoneRef<'static> = tzdata::AFRICA_ADDIS_ABABA;
        /// Africa/Monrovia,
        pub const MONROVIA: TimeZoneRef<'static> = tzdata::AFRICA_MONROVIA;
        /// Africa/Nairobi,
        pub const NAIROBI: TimeZoneRef<'static> = tzdata::AFRICA_ADDIS_ABABA;
        /// Africa/Ndjamena,
        pub const NDJAMENA: TimeZoneRef<'static> = tzdata::AFRICA_NDJAMENA;
        /// Africa/Niamey,
        pub const NIAMEY: TimeZoneRef<'static> = tzdata::AFRICA_BANGUI;
        /// Africa/Nouakchott,
        pub const NOUAKCHOTT: TimeZoneRef<'static> = tzdata::AFRICA_ABIDJAN;
        /// Africa/Ouagadougou,
        pub const OUAGADOUGOU: TimeZoneRef<'static> = tzdata::AFRICA_ABIDJAN;
        /// Africa/Porto-Novo,
        pub const PORTO_NOVO: TimeZoneRef<'static> = tzdata::AFRICA_BANGUI;
        /// Africa/Sao_Tome,
        pub const SAO_TOME: TimeZoneRef<'static> = tzdata::AFRICA_SAO_TOME;
        /// Africa/Timbuktu,
        pub const TIMBUKTU: TimeZoneRef<'static> = tzdata::AFRICA_ABIDJAN;
        /// Africa/Tripoli,
        pub const TRIPOLI: TimeZoneRef<'static> = tzdata::LIBYA;
        /// Africa/Tunis,
        pub const TUNIS: TimeZoneRef<'static> = tzdata::AFRICA_TUNIS;
        /// Africa/Windhoek,
        pub const WINDHOEK: TimeZoneRef<'static> = tzdata::AFRICA_WINDHOEK;
    }

    /// america
    pub mod america {
        use super::*;

        /// America/Adak,
        pub const ADAK: TimeZoneRef<'static> = tzdata::AMERICA_ADAK;
        /// America/Anchorage,
        pub const ANCHORAGE: TimeZoneRef<'static> = tzdata::AMERICA_ANCHORAGE;
        /// America/Anguilla,
        pub const ANGUILLA: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/Antigua,
        pub const ANTIGUA: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/Araguaina,
        pub const ARAGUAINA: TimeZoneRef<'static> = tzdata::AMERICA_ARAGUAINA;
        /// America/Aruba,
        pub const ARUBA: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/Asuncion,
        pub const ASUNCION: TimeZoneRef<'static> = tzdata::AMERICA_ASUNCION;
        /// America/Atikokan,
        pub const ATIKOKAN: TimeZoneRef<'static> = tzdata::AMERICA_ATIKOKAN;
        /// America/Atka,
        pub const ATKA: TimeZoneRef<'static> = tzdata::AMERICA_ADAK;
        /// America/Bahia,
        pub const BAHIA: TimeZoneRef<'static> = tzdata::AMERICA_BAHIA;
        /// America/Bahia_Banderas,
        pub const BAHIA_BANDERAS: TimeZoneRef<'static> = tzdata::AMERICA_BAHIA_BANDERAS;
        /// America/Barbados,
        pub const BARBADOS: TimeZoneRef<'static> = tzdata::AMERICA_BARBADOS;
        /// America/Belem,
        pub const BELEM: TimeZoneRef<'static> = tzdata::AMERICA_BELEM;
        /// America/Belize,
        pub const BELIZE: TimeZoneRef<'static> = tzdata::AMERICA_BELIZE;
        /// America/Blanc-Sablon,
        pub const BLANC_SABLON: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/Boa_Vista,
        pub const BOA_VISTA: TimeZoneRef<'static> = tzdata::AMERICA_BOA_VISTA;
        /// America/Bogota,
        pub const BOGOTA: TimeZoneRef<'static> = tzdata::AMERICA_BOGOTA;
        /// America/Boise,
        pub const BOISE: TimeZoneRef<'static> = tzdata::AMERICA_BOISE;
        /// America/Buenos_Aires,
        pub const BUENOS_AIRES: TimeZoneRef<'static> = tzdata::AMERICA_BUENOS_AIRES;
        /// America/Cambridge_Bay,
        pub const CAMBRIDGE_BAY: TimeZoneRef<'static> = tzdata::AMERICA_CAMBRIDGE_BAY;
        /// America/Campo_Grande,
        pub const CAMPO_GRANDE: TimeZoneRef<'static> = tzdata::AMERICA_CAMPO_GRANDE;
        /// America/Cancun,
        pub const CANCUN: TimeZoneRef<'static> = tzdata::AMERICA_CANCUN;
        /// America/Caracas,
        pub const CARACAS: TimeZoneRef<'static> = tzdata::AMERICA_CARACAS;
        /// America/Catamarca,
        pub const CATAMARCA: TimeZoneRef<'static> = tzdata::AMERICA_CATAMARCA;
        /// America/Cayenne,
        pub const CAYENNE: TimeZoneRef<'static> = tzdata::AMERICA_CAYENNE;
        /// America/Cayman,
        pub const CAYMAN: TimeZoneRef<'static> = tzdata::AMERICA_ATIKOKAN;
        /// America/Chicago,
        pub const CHICAGO: TimeZoneRef<'static> = tzdata::AMERICA_CHICAGO;
        /// America/Chihuahua,
        pub const CHIHUAHUA: TimeZoneRef<'static> = tzdata::AMERICA_CHIHUAHUA;
        /// America/Coral_Harbour,
        pub const CORAL_HARBOUR: TimeZoneRef<'static> = tzdata::AMERICA_ATIKOKAN;
        /// America/Cordoba,
        pub const CORDOBA: TimeZoneRef<'static> = tzdata::AMERICA_CORDOBA;
        /// America/Costa_Rica,
        pub const COSTA_RICA: TimeZoneRef<'static> = tzdata::AMERICA_COSTA_RICA;
        /// America/Creston,
        pub const CRESTON: TimeZoneRef<'static> = tzdata::AMERICA_CRESTON;
        /// America/Cuiaba,
        pub const CUIABA: TimeZoneRef<'static> = tzdata::AMERICA_CUIABA;
        /// America/Curacao,
        pub const CURACAO: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/Danmarkshavn,
        pub const DANMARKSHAVN: TimeZoneRef<'static> = tzdata::AMERICA_DANMARKSHAVN;
        /// America/Dawson,
        pub const DAWSON: TimeZoneRef<'static> = tzdata::AMERICA_DAWSON;
        /// America/Dawson_Creek,
        pub const DAWSON_CREEK: TimeZoneRef<'static> = tzdata::AMERICA_DAWSON_CREEK;
        /// America/Denver,
        pub const DENVER: TimeZoneRef<'static> = tzdata::NAVAJO;
        /// America/Detroit,
        pub const DETROIT: TimeZoneRef<'static> = tzdata::AMERICA_DETROIT;
        /// America/Dominica,
        pub const DOMINICA: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/Edmonton,
        pub const EDMONTON: TimeZoneRef<'static> = tzdata::AMERICA_EDMONTON;
        /// America/Eirunepe,
        pub const EIRUNEPE: TimeZoneRef<'static> = tzdata::AMERICA_EIRUNEPE;
        /// America/El_Salvador,
        pub const EL_SALVADOR: TimeZoneRef<'static> = tzdata::AMERICA_EL_SALVADOR;
        /// America/Ensenada,
        pub const ENSENADA: TimeZoneRef<'static> = tzdata::AMERICA_ENSENADA;
        /// America/Fortaleza,
        pub const FORTALEZA: TimeZoneRef<'static> = tzdata::AMERICA_FORTALEZA;
        /// America/Fort_Nelson,
        pub const FORT_NELSON: TimeZoneRef<'static> = tzdata::AMERICA_FORT_NELSON;
        /// America/Fort_Wayne,
        pub const FORT_WAYNE: TimeZoneRef<'static> = tzdata::AMERICA_FORT_WAYNE;
        /// America/Glace_Bay,
        pub const GLACE_BAY: TimeZoneRef<'static> = tzdata::AMERICA_GLACE_BAY;
        /// America/Godthab,
        pub const GODTHAB: TimeZoneRef<'static> = tzdata::AMERICA_GODTHAB;
        /// America/Goose_Bay,
        pub const GOOSE_BAY: TimeZoneRef<'static> = tzdata::AMERICA_GOOSE_BAY;
        /// America/Grand_Turk,
        pub const GRAND_TURK: TimeZoneRef<'static> = tzdata::AMERICA_GRAND_TURK;
        /// America/Grenada,
        pub const GRENADA: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/Guadeloupe,
        pub const GUADELOUPE: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/Guatemala,
        pub const GUATEMALA: TimeZoneRef<'static> = tzdata::AMERICA_GUATEMALA;
        /// America/Guayaquil,
        pub const GUAYAQUIL: TimeZoneRef<'static> = tzdata::AMERICA_GUAYAQUIL;
        /// America/Guyana,
        pub const GUYANA: TimeZoneRef<'static> = tzdata::AMERICA_GUYANA;
        /// America/Halifax,
        pub const HALIFAX: TimeZoneRef<'static> = tzdata::AMERICA_HALIFAX;
        /// America/Havana,
        pub const HAVANA: TimeZoneRef<'static> = tzdata::CUBA;
        /// America/Hermosillo,
        pub const HERMOSILLO: TimeZoneRef<'static> = tzdata::AMERICA_HERMOSILLO;
        /// America/Indianapolis,
        pub const INDIANAPOLIS: TimeZoneRef<'static> = tzdata::AMERICA_FORT_WAYNE;
        /// America/Inuvik,
        pub const INUVIK: TimeZoneRef<'static> = tzdata::AMERICA_INUVIK;
        /// America/Iqaluit,
        pub const IQALUIT: TimeZoneRef<'static> = tzdata::AMERICA_IQALUIT;
        /// America/Jamaica,
        pub const JAMAICA: TimeZoneRef<'static> = tzdata::JAMAICA;
        /// America/Jujuy,
        pub const JUJUY: TimeZoneRef<'static> = tzdata::AMERICA_JUJUY;
        /// America/Juneau,
        pub const JUNEAU: TimeZoneRef<'static> = tzdata::AMERICA_JUNEAU;
        /// America/Knox_IN,
        pub const KNOX_IN: TimeZoneRef<'static> = tzdata::AMERICA_KNOX_IN;
        /// America/Kralendijk,
        pub const KRALENDIJK: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/La_Paz,
        pub const LA_PAZ: TimeZoneRef<'static> = tzdata::AMERICA_LA_PAZ;
        /// America/Lima,
        pub const LIMA: TimeZoneRef<'static> = tzdata::AMERICA_LIMA;
        /// America/Los_Angeles,
        pub const LOS_ANGELES: TimeZoneRef<'static> = tzdata::AMERICA_LOS_ANGELES;
        /// America/Louisville,
        pub const LOUISVILLE: TimeZoneRef<'static> = tzdata::AMERICA_LOUISVILLE;
        /// America/Lower_Princes,
        pub const LOWER_PRINCES: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/Maceio,
        pub const MACEIO: TimeZoneRef<'static> = tzdata::AMERICA_MACEIO;
        /// America/Managua,
        pub const MANAGUA: TimeZoneRef<'static> = tzdata::AMERICA_MANAGUA;
        /// America/Manaus,
        pub const MANAUS: TimeZoneRef<'static> = tzdata::AMERICA_MANAUS;
        /// America/Marigot,
        pub const MARIGOT: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/Martinique,
        pub const MARTINIQUE: TimeZoneRef<'static> = tzdata::AMERICA_MARTINIQUE;
        /// America/Matamoros,
        pub const MATAMOROS: TimeZoneRef<'static> = tzdata::AMERICA_MATAMOROS;
        /// America/Mazatlan,
        pub const MAZATLAN: TimeZoneRef<'static> = tzdata::AMERICA_MAZATLAN;
        /// America/Mendoza,
        pub const MENDOZA: TimeZoneRef<'static> = tzdata::AMERICA_MENDOZA;
        /// America/Menominee,
        pub const MENOMINEE: TimeZoneRef<'static> = tzdata::AMERICA_MENOMINEE;
        /// America/Merida,
        pub const MERIDA: TimeZoneRef<'static> = tzdata::AMERICA_MERIDA;
        /// America/Metlakatla,
        pub const METLAKATLA: TimeZoneRef<'static> = tzdata::AMERICA_METLAKATLA;
        /// America/Mexico_City,
        pub const MEXICO_CITY: TimeZoneRef<'static> = tzdata::AMERICA_MEXICO_CITY;
        /// America/Miquelon,
        pub const MIQUELON: TimeZoneRef<'static> = tzdata::AMERICA_MIQUELON;
        /// America/Moncton,
        pub const MONCTON: TimeZoneRef<'static> = tzdata::AMERICA_MONCTON;
        /// America/Monterrey,
        pub const MONTERREY: TimeZoneRef<'static> = tzdata::AMERICA_MONTERREY;
        /// America/Montevideo,
        pub const MONTEVIDEO: TimeZoneRef<'static> = tzdata::AMERICA_MONTEVIDEO;
        /// America/Montreal,
        pub const MONTREAL: TimeZoneRef<'static> = tzdata::AMERICA_MONTREAL;
        /// America/Montserrat,
        pub const MONTSERRAT: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/Nassau,
        pub const NASSAU: TimeZoneRef<'static> = tzdata::AMERICA_MONTREAL;
        /// America/New_York,
        pub const NEW_YORK: TimeZoneRef<'static> = tzdata::AMERICA_NEW_YORK;
        /// America/Nipigon,
        pub const NIPIGON: TimeZoneRef<'static> = tzdata::AMERICA_NIPIGON;
        /// America/Nome,
        pub const NOME: TimeZoneRef<'static> = tzdata::AMERICA_NOME;
        /// America/Noronha,
        pub const NORONHA: TimeZoneRef<'static> = tzdata::AMERICA_NORONHA;
        /// America/Nuuk,
        pub const NUUK: TimeZoneRef<'static> = tzdata::AMERICA_GODTHAB;
        /// America/Ojinaga,
        pub const OJINAGA: TimeZoneRef<'static> = tzdata::AMERICA_OJINAGA;
        /// America/Panama,
        pub const PANAMA: TimeZoneRef<'static> = tzdata::AMERICA_ATIKOKAN;
        /// America/Pangnirtung,
        pub const PANGNIRTUNG: TimeZoneRef<'static> = tzdata::AMERICA_PANGNIRTUNG;
        /// America/Paramaribo,
        pub const PARAMARIBO: TimeZoneRef<'static> = tzdata::AMERICA_PARAMARIBO;
        /// America/Phoenix,
        pub const PHOENIX: TimeZoneRef<'static> = tzdata::AMERICA_CRESTON;
        /// America/Porto_Acre,
        pub const PORTO_ACRE: TimeZoneRef<'static> = tzdata::AMERICA_PORTO_ACRE;
        /// America/Porto_Velho,
        pub const PORTO_VELHO: TimeZoneRef<'static> = tzdata::AMERICA_PORTO_VELHO;
        /// America/Port-au-Prince,
        pub const PORT_AU_PRINCE: TimeZoneRef<'static> = tzdata::AMERICA_PORT_AU_PRINCE;
        /// America/Port_of_Spain,
        pub const PORT_OF_SPAIN: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/Puerto_Rico,
        pub const PUERTO_RICO: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/Punta_Arenas,
        pub const PUNTA_ARENAS: TimeZoneRef<'static> = tzdata::AMERICA_PUNTA_ARENAS;
        /// America/Rainy_River,
        pub const RAINY_RIVER: TimeZoneRef<'static> = tzdata::AMERICA_RAINY_RIVER;
        /// America/Rankin_Inlet,
        pub const RANKIN_INLET: TimeZoneRef<'static> = tzdata::AMERICA_RANKIN_INLET;
        /// America/Recife,
        pub const RECIFE: TimeZoneRef<'static> = tzdata::AMERICA_RECIFE;
        /// America/Regina,
        pub const REGINA: TimeZoneRef<'static> = tzdata::AMERICA_REGINA;
        /// America/Resolute,
        pub const RESOLUTE: TimeZoneRef<'static> = tzdata::AMERICA_RESOLUTE;
        /// America/Rio_Branco,
        pub const RIO_BRANCO: TimeZoneRef<'static> = tzdata::AMERICA_PORTO_ACRE;
        /// America/Rosario,
        pub const ROSARIO: TimeZoneRef<'static> = tzdata::AMERICA_CORDOBA;
        /// America/Santarem,
        pub const SANTAREM: TimeZoneRef<'static> = tzdata::AMERICA_SANTAREM;
        /// America/Santa_Isabel,
        pub const SANTA_ISABEL: TimeZoneRef<'static> = tzdata::AMERICA_ENSENADA;
        /// America/Santiago,
        pub const SANTIAGO: TimeZoneRef<'static> = tzdata::AMERICA_SANTIAGO;
        /// America/Santo_Domingo,
        pub const SANTO_DOMINGO: TimeZoneRef<'static> = tzdata::AMERICA_SANTO_DOMINGO;
        /// America/Sao_Paulo,
        pub const SAO_PAULO: TimeZoneRef<'static> = tzdata::AMERICA_SAO_PAULO;
        /// America/Scoresbysund,
        pub const SCORESBYSUND: TimeZoneRef<'static> = tzdata::AMERICA_SCORESBYSUND;
        /// America/Shiprock,
        pub const SHIPROCK: TimeZoneRef<'static> = tzdata::NAVAJO;
        /// America/Sitka,
        pub const SITKA: TimeZoneRef<'static> = tzdata::AMERICA_SITKA;
        /// America/St_Barthelemy,
        pub const ST_BARTHELEMY: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/St_Johns,
        pub const ST_JOHNS: TimeZoneRef<'static> = tzdata::AMERICA_ST_JOHNS;
        /// America/St_Kitts,
        pub const ST_KITTS: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/St_Lucia,
        pub const ST_LUCIA: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/St_Thomas,
        pub const ST_THOMAS: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/St_Vincent,
        pub const ST_VINCENT: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/Swift_Current,
        pub const SWIFT_CURRENT: TimeZoneRef<'static> = tzdata::AMERICA_SWIFT_CURRENT;
        /// America/Tegucigalpa,
        pub const TEGUCIGALPA: TimeZoneRef<'static> = tzdata::AMERICA_TEGUCIGALPA;
        /// America/Thule,
        pub const THULE: TimeZoneRef<'static> = tzdata::AMERICA_THULE;
        /// America/Thunder_Bay,
        pub const THUNDER_BAY: TimeZoneRef<'static> = tzdata::AMERICA_THUNDER_BAY;
        /// America/Tijuana,
        pub const TIJUANA: TimeZoneRef<'static> = tzdata::AMERICA_ENSENADA;
        /// America/Toronto,
        pub const TORONTO: TimeZoneRef<'static> = tzdata::AMERICA_MONTREAL;
        /// America/Tortola,
        pub const TORTOLA: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/Vancouver,
        pub const VANCOUVER: TimeZoneRef<'static> = tzdata::AMERICA_VANCOUVER;
        /// America/Virgin,
        pub const VIRGIN: TimeZoneRef<'static> = tzdata::AMERICA_ANGUILLA;
        /// America/Whitehorse,
        pub const WHITEHORSE: TimeZoneRef<'static> = tzdata::AMERICA_WHITEHORSE;
        /// America/Winnipeg,
        pub const WINNIPEG: TimeZoneRef<'static> = tzdata::AMERICA_WINNIPEG;
        /// America/Yakutat,
        pub const YAKUTAT: TimeZoneRef<'static> = tzdata::AMERICA_YAKUTAT;
        /// America/Yellowknife,
        pub const YELLOWKNIFE: TimeZoneRef<'static> = tzdata::AMERICA_YELLOWKNIFE;
    }

    /// antarctica
    pub mod antarctica {
        use super::*;

        /// Antarctica/Casey,
        pub const CASEY: TimeZoneRef<'static> = tzdata::ANTARCTICA_CASEY;
        /// Antarctica/Davis,
        pub const DAVIS: TimeZoneRef<'static> = tzdata::ANTARCTICA_DAVIS;
        /// Antarctica/DumontDUrville,
        pub const DUMONT_D_URVILLE: TimeZoneRef<'static> = tzdata::ANTARCTICA_DUMONT_D_URVILLE;
        /// Antarctica/Macquarie,
        pub const MACQUARIE: TimeZoneRef<'static> = tzdata::ANTARCTICA_MACQUARIE;
        /// Antarctica/Mawson,
        pub const MAWSON: TimeZoneRef<'static> = tzdata::ANTARCTICA_MAWSON;
        /// Antarctica/McMurdo,
        pub const MC_MURDO: TimeZoneRef<'static> = tzdata::NZ;
        /// Antarctica/Palmer,
        pub const PALMER: TimeZoneRef<'static> = tzdata::ANTARCTICA_PALMER;
        /// Antarctica/Rothera,
        pub const ROTHERA: TimeZoneRef<'static> = tzdata::ANTARCTICA_ROTHERA;
        /// Antarctica/South_Pole,
        pub const SOUTH_POLE: TimeZoneRef<'static> = tzdata::NZ;
        /// Antarctica/Syowa,
        pub const SYOWA: TimeZoneRef<'static> = tzdata::ANTARCTICA_SYOWA;
        /// Antarctica/Troll,
        pub const TROLL: TimeZoneRef<'static> = tzdata::ANTARCTICA_TROLL;
        /// Antarctica/Vostok,
        pub const VOSTOK: TimeZoneRef<'static> = tzdata::ANTARCTICA_VOSTOK;
    }

    /// arctic
    pub mod arctic {
        use super::*;

        /// Arctic/Longyearbyen,
        pub const LONGYEARBYEN: TimeZoneRef<'static> = tzdata::ARCTIC_LONGYEARBYEN;
    }

    /// asia
    pub mod asia {
        use super::*;

        /// Asia/Aden,
        pub const ADEN: TimeZoneRef<'static> = tzdata::ANTARCTICA_SYOWA;
        /// Asia/Almaty,
        pub const ALMATY: TimeZoneRef<'static> = tzdata::ASIA_ALMATY;
        /// Asia/Amman,
        pub const AMMAN: TimeZoneRef<'static> = tzdata::ASIA_AMMAN;
        /// Asia/Anadyr,
        pub const ANADYR: TimeZoneRef<'static> = tzdata::ASIA_ANADYR;
        /// Asia/Aqtau,
        pub const AQTAU: TimeZoneRef<'static> = tzdata::ASIA_AQTAU;
        /// Asia/Aqtobe,
        pub const AQTOBE: TimeZoneRef<'static> = tzdata::ASIA_AQTOBE;
        /// Asia/Ashgabat,
        pub const ASHGABAT: TimeZoneRef<'static> = tzdata::ASIA_ASHGABAT;
        /// Asia/Ashkhabad,
        pub const ASHKHABAD: TimeZoneRef<'static> = tzdata::ASIA_ASHGABAT;
        /// Asia/Atyrau,
        pub const ATYRAU: TimeZoneRef<'static> = tzdata::ASIA_ATYRAU;
        /// Asia/Baghdad,
        pub const BAGHDAD: TimeZoneRef<'static> = tzdata::ASIA_BAGHDAD;
        /// Asia/Bahrain,
        pub const BAHRAIN: TimeZoneRef<'static> = tzdata::ASIA_BAHRAIN;
        /// Asia/Baku,
        pub const BAKU: TimeZoneRef<'static> = tzdata::ASIA_BAKU;
        /// Asia/Bangkok,
        pub const BANGKOK: TimeZoneRef<'static> = tzdata::ASIA_BANGKOK;
        /// Asia/Barnaul,
        pub const BARNAUL: TimeZoneRef<'static> = tzdata::ASIA_BARNAUL;
        /// Asia/Beirut,
        pub const BEIRUT: TimeZoneRef<'static> = tzdata::ASIA_BEIRUT;
        /// Asia/Bishkek,
        pub const BISHKEK: TimeZoneRef<'static> = tzdata::ASIA_BISHKEK;
        /// Asia/Brunei,
        pub const BRUNEI: TimeZoneRef<'static> = tzdata::ASIA_BRUNEI;
        /// Asia/Calcutta,
        pub const CALCUTTA: TimeZoneRef<'static> = tzdata::ASIA_CALCUTTA;
        /// Asia/Chita,
        pub const CHITA: TimeZoneRef<'static> = tzdata::ASIA_CHITA;
        /// Asia/Choibalsan,
        pub const CHOIBALSAN: TimeZoneRef<'static> = tzdata::ASIA_CHOIBALSAN;
        /// Asia/Chongqing,
        pub const CHONGQING: TimeZoneRef<'static> = tzdata::PRC;
        /// Asia/Chungking,
        pub const CHUNGKING: TimeZoneRef<'static> = tzdata::PRC;
        /// Asia/Colombo,
        pub const COLOMBO: TimeZoneRef<'static> = tzdata::ASIA_COLOMBO;
        /// Asia/Dacca,
        pub const DACCA: TimeZoneRef<'static> = tzdata::ASIA_DACCA;
        /// Asia/Damascus,
        pub const DAMASCUS: TimeZoneRef<'static> = tzdata::ASIA_DAMASCUS;
        /// Asia/Dhaka,
        pub const DHAKA: TimeZoneRef<'static> = tzdata::ASIA_DACCA;
        /// Asia/Dili,
        pub const DILI: TimeZoneRef<'static> = tzdata::ASIA_DILI;
        /// Asia/Dubai,
        pub const DUBAI: TimeZoneRef<'static> = tzdata::ASIA_DUBAI;
        /// Asia/Dushanbe,
        pub const DUSHANBE: TimeZoneRef<'static> = tzdata::ASIA_DUSHANBE;
        /// Asia/Famagusta,
        pub const FAMAGUSTA: TimeZoneRef<'static> = tzdata::ASIA_FAMAGUSTA;
        /// Asia/Gaza,
        pub const GAZA: TimeZoneRef<'static> = tzdata::ASIA_GAZA;
        /// Asia/Harbin,
        pub const HARBIN: TimeZoneRef<'static> = tzdata::PRC;
        /// Asia/Hebron,
        pub const HEBRON: TimeZoneRef<'static> = tzdata::ASIA_HEBRON;
        /// Asia/Hong_Kong,
        pub const HONG_KONG: TimeZoneRef<'static> = tzdata::HONGKONG;
        /// Asia/Hovd,
        pub const HOVD: TimeZoneRef<'static> = tzdata::ASIA_HOVD;
        /// Asia/Ho_Chi_Minh,
        pub const HO_CHI_MINH: TimeZoneRef<'static> = tzdata::ASIA_HO_CHI_MINH;
        /// Asia/Irkutsk,
        pub const IRKUTSK: TimeZoneRef<'static> = tzdata::ASIA_IRKUTSK;
        /// Asia/Istanbul,
        pub const ISTANBUL: TimeZoneRef<'static> = tzdata::TURKEY;
        /// Asia/Jakarta,
        pub const JAKARTA: TimeZoneRef<'static> = tzdata::ASIA_JAKARTA;
        /// Asia/Jayapura,
        pub const JAYAPURA: TimeZoneRef<'static> = tzdata::ASIA_JAYAPURA;
        /// Asia/Jerusalem,
        pub const JERUSALEM: TimeZoneRef<'static> = tzdata::ISRAEL;
        /// Asia/Kabul,
        pub const KABUL: TimeZoneRef<'static> = tzdata::ASIA_KABUL;
        /// Asia/Kamchatka,
        pub const KAMCHATKA: TimeZoneRef<'static> = tzdata::ASIA_KAMCHATKA;
        /// Asia/Karachi,
        pub const KARACHI: TimeZoneRef<'static> = tzdata::ASIA_KARACHI;
        /// Asia/Kashgar,
        pub const KASHGAR: TimeZoneRef<'static> = tzdata::ASIA_KASHGAR;
        /// Asia/Kathmandu,
        pub const KATHMANDU: TimeZoneRef<'static> = tzdata::ASIA_KATHMANDU;
        /// Asia/Katmandu,
        pub const KATMANDU: TimeZoneRef<'static> = tzdata::ASIA_KATHMANDU;
        /// Asia/Khandyga,
        pub const KHANDYGA: TimeZoneRef<'static> = tzdata::ASIA_KHANDYGA;
        /// Asia/Kolkata,
        pub const KOLKATA: TimeZoneRef<'static> = tzdata::ASIA_CALCUTTA;
        /// Asia/Krasnoyarsk,
        pub const KRASNOYARSK: TimeZoneRef<'static> = tzdata::ASIA_KRASNOYARSK;
        /// Asia/Kuala_Lumpur,
        pub const KUALA_LUMPUR: TimeZoneRef<'static> = tzdata::ASIA_KUALA_LUMPUR;
        /// Asia/Kuching,
        pub const KUCHING: TimeZoneRef<'static> = tzdata::ASIA_KUCHING;
        /// Asia/Kuwait,
        pub const KUWAIT: TimeZoneRef<'static> = tzdata::ANTARCTICA_SYOWA;
        /// Asia/Macao,
        pub const MACAO: TimeZoneRef<'static> = tzdata::ASIA_MACAO;
        /// Asia/Macau,
        pub const MACAU: TimeZoneRef<'static> = tzdata::ASIA_MACAO;
        /// Asia/Magadan,
        pub const MAGADAN: TimeZoneRef<'static> = tzdata::ASIA_MAGADAN;
        /// Asia/Makassar,
        pub const MAKASSAR: TimeZoneRef<'static> = tzdata::ASIA_MAKASSAR;
        /// Asia/Manila,
        pub const MANILA: TimeZoneRef<'static> = tzdata::ASIA_MANILA;
        /// Asia/Muscat,
        pub const MUSCAT: TimeZoneRef<'static> = tzdata::ASIA_DUBAI;
        /// Asia/Nicosia,
        pub const NICOSIA: TimeZoneRef<'static> = tzdata::ASIA_NICOSIA;
        /// Asia/Novokuznetsk,
        pub const NOVOKUZNETSK: TimeZoneRef<'static> = tzdata::ASIA_NOVOKUZNETSK;
        /// Asia/Novosibirsk,
        pub const NOVOSIBIRSK: TimeZoneRef<'static> = tzdata::ASIA_NOVOSIBIRSK;
        /// Asia/Omsk,
        pub const OMSK: TimeZoneRef<'static> = tzdata::ASIA_OMSK;
        /// Asia/Oral,
        pub const ORAL: TimeZoneRef<'static> = tzdata::ASIA_ORAL;
        /// Asia/Phnom_Penh,
        pub const PHNOM_PENH: TimeZoneRef<'static> = tzdata::ASIA_BANGKOK;
        /// Asia/Pontianak,
        pub const PONTIANAK: TimeZoneRef<'static> = tzdata::ASIA_PONTIANAK;
        /// Asia/Pyongyang,
        pub const PYONGYANG: TimeZoneRef<'static> = tzdata::ASIA_PYONGYANG;
        /// Asia/Qatar,
        pub const QATAR: TimeZoneRef<'static> = tzdata::ASIA_BAHRAIN;
        /// Asia/Qostanay,
        pub const QOSTANAY: TimeZoneRef<'static> = tzdata::ASIA_QOSTANAY;
        /// Asia/Qyzylorda,
        pub const QYZYLORDA: TimeZoneRef<'static> = tzdata::ASIA_QYZYLORDA;
        /// Asia/Rangoon,
        pub const RANGOON: TimeZoneRef<'static> = tzdata::ASIA_RANGOON;
        /// Asia/Riyadh,
        pub const RIYADH: TimeZoneRef<'static> = tzdata::ANTARCTICA_SYOWA;
        /// Asia/Saigon,
        pub const SAIGON: TimeZoneRef<'static> = tzdata::ASIA_HO_CHI_MINH;
        /// Asia/Sakhalin,
        pub const SAKHALIN: TimeZoneRef<'static> = tzdata::ASIA_SAKHALIN;
        /// Asia/Samarkand,
        pub const SAMARKAND: TimeZoneRef<'static> = tzdata::ASIA_SAMARKAND;
        /// Asia/Seoul,
        pub const SEOUL: TimeZoneRef<'static> = tzdata::ROK;
        /// Asia/Shanghai,
        pub const SHANGHAI: TimeZoneRef<'static> = tzdata::PRC;
        /// Asia/Singapore,
        pub const SINGAPORE: TimeZoneRef<'static> = tzdata::SINGAPORE;
        /// Asia/Srednekolymsk,
        pub const SREDNEKOLYMSK: TimeZoneRef<'static> = tzdata::ASIA_SREDNEKOLYMSK;
        /// Asia/Taipei,
        pub const TAIPEI: TimeZoneRef<'static> = tzdata::ROC;
        /// Asia/Tashkent,
        pub const TASHKENT: TimeZoneRef<'static> = tzdata::ASIA_TASHKENT;
        /// Asia/Tbilisi,
        pub const TBILISI: TimeZoneRef<'static> = tzdata::ASIA_TBILISI;
        /// Asia/Tehran,
        pub const TEHRAN: TimeZoneRef<'static> = tzdata::IRAN;
        /// Asia/Tel_Aviv,
        pub const TEL_AVIV: TimeZoneRef<'static> = tzdata::ISRAEL;
        /// Asia/Thimbu,
        pub const THIMBU: TimeZoneRef<'static> = tzdata::ASIA_THIMBU;
        /// Asia/Thimphu,
        pub const THIMPHU: TimeZoneRef<'static> = tzdata::ASIA_THIMBU;
        /// Asia/Tokyo,
        pub const TOKYO: TimeZoneRef<'static> = tzdata::JAPAN;
        /// Asia/Tomsk,
        pub const TOMSK: TimeZoneRef<'static> = tzdata::ASIA_TOMSK;
        /// Asia/Ujung_Pandang,
        pub const UJUNG_PANDANG: TimeZoneRef<'static> = tzdata::ASIA_MAKASSAR;
        /// Asia/Ulaanbaatar,
        pub const ULAANBAATAR: TimeZoneRef<'static> = tzdata::ASIA_ULAANBAATAR;
        /// Asia/Ulan_Bator,
        pub const ULAN_BATOR: TimeZoneRef<'static> = tzdata::ASIA_ULAANBAATAR;
        /// Asia/Urumqi,
        pub const URUMQI: TimeZoneRef<'static> = tzdata::ASIA_KASHGAR;
        /// Asia/Ust-Nera,
        pub const UST_NERA: TimeZoneRef<'static> = tzdata::ASIA_UST_NERA;
        /// Asia/Vientiane,
        pub const VIENTIANE: TimeZoneRef<'static> = tzdata::ASIA_BANGKOK;
        /// Asia/Vladivostok,
        pub const VLADIVOSTOK: TimeZoneRef<'static> = tzdata::ASIA_VLADIVOSTOK;
        /// Asia/Yakutsk,
        pub const YAKUTSK: TimeZoneRef<'static> = tzdata::ASIA_YAKUTSK;
        /// Asia/Yangon,
        pub const YANGON: TimeZoneRef<'static> = tzdata::ASIA_RANGOON;
        /// Asia/Yekaterinburg,
        pub const YEKATERINBURG: TimeZoneRef<'static> = tzdata::ASIA_YEKATERINBURG;
        /// Asia/Yerevan,
        pub const YEREVAN: TimeZoneRef<'static> = tzdata::ASIA_YEREVAN;
    }

    /// atlantic
    pub mod atlantic {
        use super::*;

        /// Atlantic/Azores,
        pub const AZORES: TimeZoneRef<'static> = tzdata::ATLANTIC_AZORES;
        /// Atlantic/Bermuda,
        pub const BERMUDA: TimeZoneRef<'static> = tzdata::ATLANTIC_BERMUDA;
        /// Atlantic/Canary,
        pub const CANARY: TimeZoneRef<'static> = tzdata::ATLANTIC_CANARY;
        /// Atlantic/Cape_Verde,
        pub const CAPE_VERDE: TimeZoneRef<'static> = tzdata::ATLANTIC_CAPE_VERDE;
        /// Atlantic/Faeroe,
        pub const FAEROE: TimeZoneRef<'static> = tzdata::ATLANTIC_FAEROE;
        /// Atlantic/Faroe,
        pub const FAROE: TimeZoneRef<'static> = tzdata::ATLANTIC_FAEROE;
        /// Atlantic/Jan_Mayen,
        pub const JAN_MAYEN: TimeZoneRef<'static> = tzdata::ARCTIC_LONGYEARBYEN;
        /// Atlantic/Madeira,
        pub const MADEIRA: TimeZoneRef<'static> = tzdata::ATLANTIC_MADEIRA;
        /// Atlantic/Reykjavik,
        pub const REYKJAVIK: TimeZoneRef<'static> = tzdata::ICELAND;
        /// Atlantic/South_Georgia,
        pub const SOUTH_GEORGIA: TimeZoneRef<'static> = tzdata::ATLANTIC_SOUTH_GEORGIA;
        /// Atlantic/Stanley,
        pub const STANLEY: TimeZoneRef<'static> = tzdata::ATLANTIC_STANLEY;
        /// Atlantic/St_Helena,
        pub const ST_HELENA: TimeZoneRef<'static> = tzdata::AFRICA_ABIDJAN;
    }

    /// australia
    pub mod australia {
        use super::*;

        /// Australia/ACT,
        pub const ACT: TimeZoneRef<'static> = tzdata::AUSTRALIA_ACT;
        /// Australia/Adelaide,
        pub const ADELAIDE: TimeZoneRef<'static> = tzdata::AUSTRALIA_ADELAIDE;
        /// Australia/Brisbane,
        pub const BRISBANE: TimeZoneRef<'static> = tzdata::AUSTRALIA_BRISBANE;
        /// Australia/Broken_Hill,
        pub const BROKEN_HILL: TimeZoneRef<'static> = tzdata::AUSTRALIA_BROKEN_HILL;
        /// Australia/Canberra,
        pub const CANBERRA: TimeZoneRef<'static> = tzdata::AUSTRALIA_ACT;
        /// Australia/Currie,
        pub const CURRIE: TimeZoneRef<'static> = tzdata::AUSTRALIA_CURRIE;
        /// Australia/Darwin,
        pub const DARWIN: TimeZoneRef<'static> = tzdata::AUSTRALIA_DARWIN;
        /// Australia/Eucla,
        pub const EUCLA: TimeZoneRef<'static> = tzdata::AUSTRALIA_EUCLA;
        /// Australia/Hobart,
        pub const HOBART: TimeZoneRef<'static> = tzdata::AUSTRALIA_CURRIE;
        /// Australia/LHI,
        pub const LHI: TimeZoneRef<'static> = tzdata::AUSTRALIA_LHI;
        /// Australia/Lindeman,
        pub const LINDEMAN: TimeZoneRef<'static> = tzdata::AUSTRALIA_LINDEMAN;
        /// Australia/Lord_Howe,
        pub const LORD_HOWE: TimeZoneRef<'static> = tzdata::AUSTRALIA_LHI;
        /// Australia/Melbourne,
        pub const MELBOURNE: TimeZoneRef<'static> = tzdata::AUSTRALIA_MELBOURNE;
        /// Australia/North,
        pub const NORTH: TimeZoneRef<'static> = tzdata::AUSTRALIA_DARWIN;
        /// Australia/NSW,
        pub const NSW: TimeZoneRef<'static> = tzdata::AUSTRALIA_ACT;
        /// Australia/Perth,
        pub const PERTH: TimeZoneRef<'static> = tzdata::AUSTRALIA_PERTH;
        /// Australia/Queensland,
        pub const QUEENSLAND: TimeZoneRef<'static> = tzdata::AUSTRALIA_BRISBANE;
        /// Australia/South,
        pub const SOUTH: TimeZoneRef<'static> = tzdata::AUSTRALIA_ADELAIDE;
        /// Australia/Sydney,
        pub const SYDNEY: TimeZoneRef<'static> = tzdata::AUSTRALIA_ACT;
        /// Australia/Tasmania,
        pub const TASMANIA: TimeZoneRef<'static> = tzdata::AUSTRALIA_CURRIE;
        /// Australia/Victoria,
        pub const VICTORIA: TimeZoneRef<'static> = tzdata::AUSTRALIA_MELBOURNE;
        /// Australia/West,
        pub const WEST: TimeZoneRef<'static> = tzdata::AUSTRALIA_PERTH;
        /// Australia/Yancowinna,
        pub const YANCOWINNA: TimeZoneRef<'static> = tzdata::AUSTRALIA_BROKEN_HILL;
    }

    /// brazil
    pub mod brazil {
        use super::*;

        /// Brazil/Acre,
        pub const ACRE: TimeZoneRef<'static> = tzdata::AMERICA_PORTO_ACRE;
        /// Brazil/DeNoronha,
        pub const DE_NORONHA: TimeZoneRef<'static> = tzdata::AMERICA_NORONHA;
        /// Brazil/East,
        pub const EAST: TimeZoneRef<'static> = tzdata::AMERICA_SAO_PAULO;
        /// Brazil/West,
        pub const WEST: TimeZoneRef<'static> = tzdata::AMERICA_MANAUS;
    }

    /// canada
    pub mod canada {
        use super::*;

        /// Canada/Atlantic,
        pub const ATLANTIC: TimeZoneRef<'static> = tzdata::AMERICA_HALIFAX;
        /// Canada/Central,
        pub const CENTRAL: TimeZoneRef<'static> = tzdata::AMERICA_WINNIPEG;
        /// Canada/Eastern,
        pub const EASTERN: TimeZoneRef<'static> = tzdata::AMERICA_MONTREAL;
        /// Canada/Mountain,
        pub const MOUNTAIN: TimeZoneRef<'static> = tzdata::AMERICA_EDMONTON;
        /// Canada/Newfoundland,
        pub const NEWFOUNDLAND: TimeZoneRef<'static> = tzdata::AMERICA_ST_JOHNS;
        /// Canada/Pacific,
        pub const PACIFIC: TimeZoneRef<'static> = tzdata::AMERICA_VANCOUVER;
        /// Canada/Saskatchewan,
        pub const SASKATCHEWAN: TimeZoneRef<'static> = tzdata::AMERICA_REGINA;
        /// Canada/Yukon,
        pub const YUKON: TimeZoneRef<'static> = tzdata::AMERICA_WHITEHORSE;
    }

    /// chile
    pub mod chile {
        use super::*;

        /// Chile/Continental,
        pub const CONTINENTAL: TimeZoneRef<'static> = tzdata::AMERICA_SANTIAGO;
        /// Chile/EasterIsland,
        pub const EASTER_ISLAND: TimeZoneRef<'static> = tzdata::CHILE_EASTER_ISLAND;
    }

    /// etc
    pub mod etc {
        use super::*;

        /// Etc/GMT,
        pub const GMT: TimeZoneRef<'static> = tzdata::GMT;
        /// Etc/GMT0,
        pub const GMT_0: TimeZoneRef<'static> = tzdata::GMT;
        /// Etc/GMT-0,
        pub const GMT_MINUS_0: TimeZoneRef<'static> = tzdata::GMT;
        /// Etc/GMT-1,
        pub const GMT_MINUS_1: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_1;
        /// Etc/GMT-10,
        pub const GMT_MINUS_10: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_10;
        /// Etc/GMT-11,
        pub const GMT_MINUS_11: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_11;
        /// Etc/GMT-12,
        pub const GMT_MINUS_12: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_12;
        /// Etc/GMT-13,
        pub const GMT_MINUS_13: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_13;
        /// Etc/GMT-14,
        pub const GMT_MINUS_14: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_14;
        /// Etc/GMT-2,
        pub const GMT_MINUS_2: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_2;
        /// Etc/GMT-3,
        pub const GMT_MINUS_3: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_3;
        /// Etc/GMT-4,
        pub const GMT_MINUS_4: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_4;
        /// Etc/GMT-5,
        pub const GMT_MINUS_5: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_5;
        /// Etc/GMT-6,
        pub const GMT_MINUS_6: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_6;
        /// Etc/GMT-7,
        pub const GMT_MINUS_7: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_7;
        /// Etc/GMT-8,
        pub const GMT_MINUS_8: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_8;
        /// Etc/GMT-9,
        pub const GMT_MINUS_9: TimeZoneRef<'static> = tzdata::ETC_GMT_MINUS_9;
        /// Etc/GMT+0,
        pub const GMT_PLUS_0: TimeZoneRef<'static> = tzdata::GMT;
        /// Etc/GMT+1,
        pub const GMT_PLUS_1: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_1;
        /// Etc/GMT+10,
        pub const GMT_PLUS_10: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_10;
        /// Etc/GMT+11,
        pub const GMT_PLUS_11: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_11;
        /// Etc/GMT+12,
        pub const GMT_PLUS_12: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_12;
        /// Etc/GMT+2,
        pub const GMT_PLUS_2: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_2;
        /// Etc/GMT+3,
        pub const GMT_PLUS_3: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_3;
        /// Etc/GMT+4,
        pub const GMT_PLUS_4: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_4;
        /// Etc/GMT+5,
        pub const GMT_PLUS_5: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_5;
        /// Etc/GMT+6,
        pub const GMT_PLUS_6: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_6;
        /// Etc/GMT+7,
        pub const GMT_PLUS_7: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_7;
        /// Etc/GMT+8,
        pub const GMT_PLUS_8: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_8;
        /// Etc/GMT+9,
        pub const GMT_PLUS_9: TimeZoneRef<'static> = tzdata::ETC_GMT_PLUS_9;
        /// Etc/Greenwich,
        pub const GREENWICH: TimeZoneRef<'static> = tzdata::GMT;
        /// Etc/UCT,
        pub const UCT: TimeZoneRef<'static> = tzdata::UCT;
        /// Etc/Universal,
        pub const UNIVERSAL: TimeZoneRef<'static> = tzdata::UCT;
        /// Etc/UTC,
        pub const UTC: TimeZoneRef<'static> = tzdata::UCT;
        /// Etc/Zulu,
        pub const ZULU: TimeZoneRef<'static> = tzdata::UCT;
    }

    /// europe
    pub mod europe {
        use super::*;

        /// Europe/Amsterdam,
        pub const AMSTERDAM: TimeZoneRef<'static> = tzdata::EUROPE_AMSTERDAM;
        /// Europe/Andorra,
        pub const ANDORRA: TimeZoneRef<'static> = tzdata::EUROPE_ANDORRA;
        /// Europe/Astrakhan,
        pub const ASTRAKHAN: TimeZoneRef<'static> = tzdata::EUROPE_ASTRAKHAN;
        /// Europe/Athens,
        pub const ATHENS: TimeZoneRef<'static> = tzdata::EUROPE_ATHENS;
        /// Europe/Belfast,
        pub const BELFAST: TimeZoneRef<'static> = tzdata::GB;
        /// Europe/Belgrade,
        pub const BELGRADE: TimeZoneRef<'static> = tzdata::EUROPE_BELGRADE;
        /// Europe/Berlin,
        pub const BERLIN: TimeZoneRef<'static> = tzdata::EUROPE_BERLIN;
        /// Europe/Bratislava,
        pub const BRATISLAVA: TimeZoneRef<'static> = tzdata::EUROPE_BRATISLAVA;
        /// Europe/Brussels,
        pub const BRUSSELS: TimeZoneRef<'static> = tzdata::EUROPE_BRUSSELS;
        /// Europe/Bucharest,
        pub const BUCHAREST: TimeZoneRef<'static> = tzdata::EUROPE_BUCHAREST;
        /// Europe/Budapest,
        pub const BUDAPEST: TimeZoneRef<'static> = tzdata::EUROPE_BUDAPEST;
        /// Europe/Busingen,
        pub const BUSINGEN: TimeZoneRef<'static> = tzdata::EUROPE_BUSINGEN;
        /// Europe/Chisinau,
        pub const CHISINAU: TimeZoneRef<'static> = tzdata::EUROPE_CHISINAU;
        /// Europe/Copenhagen,
        pub const COPENHAGEN: TimeZoneRef<'static> = tzdata::EUROPE_COPENHAGEN;
        /// Europe/Dublin,
        pub const DUBLIN: TimeZoneRef<'static> = tzdata::EIRE;
        /// Europe/Gibraltar,
        pub const GIBRALTAR: TimeZoneRef<'static> = tzdata::EUROPE_GIBRALTAR;
        /// Europe/Guernsey,
        pub const GUERNSEY: TimeZoneRef<'static> = tzdata::GB;
        /// Europe/Helsinki,
        pub const HELSINKI: TimeZoneRef<'static> = tzdata::EUROPE_HELSINKI;
        /// Europe/Isle_of_Man,
        pub const ISLE_OF_MAN: TimeZoneRef<'static> = tzdata::GB;
        /// Europe/Istanbul,
        pub const ISTANBUL: TimeZoneRef<'static> = tzdata::TURKEY;
        /// Europe/Jersey,
        pub const JERSEY: TimeZoneRef<'static> = tzdata::GB;
        /// Europe/Kaliningrad,
        pub const KALININGRAD: TimeZoneRef<'static> = tzdata::EUROPE_KALININGRAD;
        /// Europe/Kiev,
        pub const KIEV: TimeZoneRef<'static> = tzdata::EUROPE_KIEV;
        /// Europe/Kirov,
        pub const KIROV: TimeZoneRef<'static> = tzdata::EUROPE_KIROV;
        /// Europe/Lisbon,
        pub const LISBON: TimeZoneRef<'static> = tzdata::PORTUGAL;
        /// Europe/Ljubljana,
        pub const LJUBLJANA: TimeZoneRef<'static> = tzdata::EUROPE_BELGRADE;
        /// Europe/London,
        pub const LONDON: TimeZoneRef<'static> = tzdata::GB;
        /// Europe/Luxembourg,
        pub const LUXEMBOURG: TimeZoneRef<'static> = tzdata::EUROPE_LUXEMBOURG;
        /// Europe/Madrid,
        pub const MADRID: TimeZoneRef<'static> = tzdata::EUROPE_MADRID;
        /// Europe/Malta,
        pub const MALTA: TimeZoneRef<'static> = tzdata::EUROPE_MALTA;
        /// Europe/Mariehamn,
        pub const MARIEHAMN: TimeZoneRef<'static> = tzdata::EUROPE_HELSINKI;
        /// Europe/Minsk,
        pub const MINSK: TimeZoneRef<'static> = tzdata::EUROPE_MINSK;
        /// Europe/Monaco,
        pub const MONACO: TimeZoneRef<'static> = tzdata::EUROPE_MONACO;
        /// Europe/Moscow,
        pub const MOSCOW: TimeZoneRef<'static> = tzdata::W_SU;
        /// Europe/Nicosia,
        pub const NICOSIA: TimeZoneRef<'static> = tzdata::ASIA_NICOSIA;
        /// Europe/Oslo,
        pub const OSLO: TimeZoneRef<'static> = tzdata::ARCTIC_LONGYEARBYEN;
        /// Europe/Paris,
        pub const PARIS: TimeZoneRef<'static> = tzdata::EUROPE_PARIS;
        /// Europe/Podgorica,
        pub const PODGORICA: TimeZoneRef<'static> = tzdata::EUROPE_BELGRADE;
        /// Europe/Prague,
        pub const PRAGUE: TimeZoneRef<'static> = tzdata::EUROPE_BRATISLAVA;
        /// Europe/Riga,
        pub const RIGA: TimeZoneRef<'static> = tzdata::EUROPE_RIGA;
        /// Europe/Rome,
        pub const ROME: TimeZoneRef<'static> = tzdata::EUROPE_ROME;
        /// Europe/Samara,
        pub const SAMARA: TimeZoneRef<'static> = tzdata::EUROPE_SAMARA;
        /// Europe/San_Marino,
        pub const SAN_MARINO: TimeZoneRef<'static> = tzdata::EUROPE_ROME;
        /// Europe/Sarajevo,
        pub const SARAJEVO: TimeZoneRef<'static> = tzdata::EUROPE_BELGRADE;
        /// Europe/Saratov,
        pub const SARATOV: TimeZoneRef<'static> = tzdata::EUROPE_SARATOV;
        /// Europe/Simferopol,
        pub const SIMFEROPOL: TimeZoneRef<'static> = tzdata::EUROPE_SIMFEROPOL;
        /// Europe/Skopje,
        pub const SKOPJE: TimeZoneRef<'static> = tzdata::EUROPE_BELGRADE;
        /// Europe/Sofia,
        pub const SOFIA: TimeZoneRef<'static> = tzdata::EUROPE_SOFIA;
        /// Europe/Stockholm,
        pub const STOCKHOLM: TimeZoneRef<'static> = tzdata::EUROPE_STOCKHOLM;
        /// Europe/Tallinn,
        pub const TALLINN: TimeZoneRef<'static> = tzdata::EUROPE_TALLINN;
        /// Europe/Tirane,
        pub const TIRANE: TimeZoneRef<'static> = tzdata::EUROPE_TIRANE;
        /// Europe/Tiraspol,
        pub const TIRASPOL: TimeZoneRef<'static> = tzdata::EUROPE_CHISINAU;
        /// Europe/Ulyanovsk,
        pub const ULYANOVSK: TimeZoneRef<'static> = tzdata::EUROPE_ULYANOVSK;
        /// Europe/Uzhgorod,
        pub const UZHGOROD: TimeZoneRef<'static> = tzdata::EUROPE_UZHGOROD;
        /// Europe/Vaduz,
        pub const VADUZ: TimeZoneRef<'static> = tzdata::EUROPE_BUSINGEN;
        /// Europe/Vatican,
        pub const VATICAN: TimeZoneRef<'static> = tzdata::EUROPE_ROME;
        /// Europe/Vienna,
        pub const VIENNA: TimeZoneRef<'static> = tzdata::EUROPE_VIENNA;
        /// Europe/Vilnius,
        pub const VILNIUS: TimeZoneRef<'static> = tzdata::EUROPE_VILNIUS;
        /// Europe/Volgograd,
        pub const VOLGOGRAD: TimeZoneRef<'static> = tzdata::EUROPE_VOLGOGRAD;
        /// Europe/Warsaw,
        pub const WARSAW: TimeZoneRef<'static> = tzdata::POLAND;
        /// Europe/Zagreb,
        pub const ZAGREB: TimeZoneRef<'static> = tzdata::EUROPE_BELGRADE;
        /// Europe/Zaporozhye,
        pub const ZAPOROZHYE: TimeZoneRef<'static> = tzdata::EUROPE_ZAPOROZHYE;
        /// Europe/Zurich,
        pub const ZURICH: TimeZoneRef<'static> = tzdata::EUROPE_BUSINGEN;
    }

    /// indian
    pub mod indian {
        use super::*;

        /// Indian/Antananarivo,
        pub const ANTANANARIVO: TimeZoneRef<'static> = tzdata::AFRICA_ADDIS_ABABA;
        /// Indian/Chagos,
        pub const CHAGOS: TimeZoneRef<'static> = tzdata::INDIAN_CHAGOS;
        /// Indian/Christmas,
        pub const CHRISTMAS: TimeZoneRef<'static> = tzdata::INDIAN_CHRISTMAS;
        /// Indian/Cocos,
        pub const COCOS: TimeZoneRef<'static> = tzdata::INDIAN_COCOS;
        /// Indian/Comoro,
        pub const COMORO: TimeZoneRef<'static> = tzdata::AFRICA_ADDIS_ABABA;
        /// Indian/Kerguelen,
        pub const KERGUELEN: TimeZoneRef<'static> = tzdata::INDIAN_KERGUELEN;
        /// Indian/Mahe,
        pub const MAHE: TimeZoneRef<'static> = tzdata::INDIAN_MAHE;
        /// Indian/Maldives,
        pub const MALDIVES: TimeZoneRef<'static> = tzdata::INDIAN_MALDIVES;
        /// Indian/Mauritius,
        pub const MAURITIUS: TimeZoneRef<'static> = tzdata::INDIAN_MAURITIUS;
        /// Indian/Mayotte,
        pub const MAYOTTE: TimeZoneRef<'static> = tzdata::AFRICA_ADDIS_ABABA;
        /// Indian/Reunion,
        pub const REUNION: TimeZoneRef<'static> = tzdata::INDIAN_REUNION;
    }

    /// mexico
    pub mod mexico {
        use super::*;

        /// Mexico/BajaNorte,
        pub const BAJA_NORTE: TimeZoneRef<'static> = tzdata::AMERICA_ENSENADA;
        /// Mexico/BajaSur,
        pub const BAJA_SUR: TimeZoneRef<'static> = tzdata::AMERICA_MAZATLAN;
        /// Mexico/General,
        pub const GENERAL: TimeZoneRef<'static> = tzdata::AMERICA_MEXICO_CITY;
    }

    /// pacific
    pub mod pacific {
        use super::*;

        /// Pacific/Apia,
        pub const APIA: TimeZoneRef<'static> = tzdata::PACIFIC_APIA;
        /// Pacific/Auckland,
        pub const AUCKLAND: TimeZoneRef<'static> = tzdata::NZ;
        /// Pacific/Bougainville,
        pub const BOUGAINVILLE: TimeZoneRef<'static> = tzdata::PACIFIC_BOUGAINVILLE;
        /// Pacific/Chatham,
        pub const CHATHAM: TimeZoneRef<'static> = tzdata::NZ_CHAT;
        /// Pacific/Chuuk,
        pub const CHUUK: TimeZoneRef<'static> = tzdata::PACIFIC_CHUUK;
        /// Pacific/Easter,
        pub const EASTER: TimeZoneRef<'static> = tzdata::CHILE_EASTER_ISLAND;
        /// Pacific/Efate,
        pub const EFATE: TimeZoneRef<'static> = tzdata::PACIFIC_EFATE;
        /// Pacific/Enderbury,
        pub const ENDERBURY: TimeZoneRef<'static> = tzdata::PACIFIC_ENDERBURY;
        /// Pacific/Fakaofo,
        pub const FAKAOFO: TimeZoneRef<'static> = tzdata::PACIFIC_FAKAOFO;
        /// Pacific/Fiji,
        pub const FIJI: TimeZoneRef<'static> = tzdata::PACIFIC_FIJI;
        /// Pacific/Funafuti,
        pub const FUNAFUTI: TimeZoneRef<'static> = tzdata::PACIFIC_FUNAFUTI;
        /// Pacific/Galapagos,
        pub const GALAPAGOS: TimeZoneRef<'static> = tzdata::PACIFIC_GALAPAGOS;
        /// Pacific/Gambier,
        pub const GAMBIER: TimeZoneRef<'static> = tzdata::PACIFIC_GAMBIER;
        /// Pacific/Guadalcanal,
        pub const GUADALCANAL: TimeZoneRef<'static> = tzdata::PACIFIC_GUADALCANAL;
        /// Pacific/Guam,
        pub const GUAM: TimeZoneRef<'static> = tzdata::PACIFIC_GUAM;
        /// Pacific/Honolulu,
        pub const HONOLULU: TimeZoneRef<'static> = tzdata::PACIFIC_HONOLULU;
        /// Pacific/Johnston,
        pub const JOHNSTON: TimeZoneRef<'static> = tzdata::PACIFIC_HONOLULU;
        /// Pacific/Kanton,
        pub const KANTON: TimeZoneRef<'static> = tzdata::PACIFIC_ENDERBURY;
        /// Pacific/Kiritimati,
        pub const KIRITIMATI: TimeZoneRef<'static> = tzdata::PACIFIC_KIRITIMATI;
        /// Pacific/Kosrae,
        pub const KOSRAE: TimeZoneRef<'static> = tzdata::PACIFIC_KOSRAE;
        /// Pacific/Kwajalein,
        pub const KWAJALEIN: TimeZoneRef<'static> = tzdata::KWAJALEIN;
        /// Pacific/Majuro,
        pub const MAJURO: TimeZoneRef<'static> = tzdata::PACIFIC_MAJURO;
        /// Pacific/Marquesas,
        pub const MARQUESAS: TimeZoneRef<'static> = tzdata::PACIFIC_MARQUESAS;
        /// Pacific/Midway,
        pub const MIDWAY: TimeZoneRef<'static> = tzdata::PACIFIC_MIDWAY;
        /// Pacific/Nauru,
        pub const NAURU: TimeZoneRef<'static> = tzdata::PACIFIC_NAURU;
        /// Pacific/Niue,
        pub const NIUE: TimeZoneRef<'static> = tzdata::PACIFIC_NIUE;
        /// Pacific/Norfolk,
        pub const NORFOLK: TimeZoneRef<'static> = tzdata::PACIFIC_NORFOLK;
        /// Pacific/Noumea,
        pub const NOUMEA: TimeZoneRef<'static> = tzdata::PACIFIC_NOUMEA;
        /// Pacific/Pago_Pago,
        pub const PAGO_PAGO: TimeZoneRef<'static> = tzdata::PACIFIC_MIDWAY;
        /// Pacific/Palau,
        pub const PALAU: TimeZoneRef<'static> = tzdata::PACIFIC_PALAU;
        /// Pacific/Pitcairn,
        pub const PITCAIRN: TimeZoneRef<'static> = tzdata::PACIFIC_PITCAIRN;
        /// Pacific/Pohnpei,
        pub const POHNPEI: TimeZoneRef<'static> = tzdata::PACIFIC_POHNPEI;
        /// Pacific/Ponape,
        pub const PONAPE: TimeZoneRef<'static> = tzdata::PACIFIC_POHNPEI;
        /// Pacific/Port_Moresby,
        pub const PORT_MORESBY: TimeZoneRef<'static> = tzdata::ANTARCTICA_DUMONT_D_URVILLE;
        /// Pacific/Rarotonga,
        pub const RAROTONGA: TimeZoneRef<'static> = tzdata::PACIFIC_RAROTONGA;
        /// Pacific/Saipan,
        pub const SAIPAN: TimeZoneRef<'static> = tzdata::PACIFIC_GUAM;
        /// Pacific/Samoa,
        pub const SAMOA: TimeZoneRef<'static> = tzdata::PACIFIC_MIDWAY;
        /// Pacific/Tahiti,
        pub const TAHITI: TimeZoneRef<'static> = tzdata::PACIFIC_TAHITI;
        /// Pacific/Tarawa,
        pub const TARAWA: TimeZoneRef<'static> = tzdata::PACIFIC_TARAWA;
        /// Pacific/Tongatapu,
        pub const TONGATAPU: TimeZoneRef<'static> = tzdata::PACIFIC_TONGATAPU;
        /// Pacific/Truk,
        pub const TRUK: TimeZoneRef<'static> = tzdata::PACIFIC_CHUUK;
        /// Pacific/Wake,
        pub const WAKE: TimeZoneRef<'static> = tzdata::PACIFIC_WAKE;
        /// Pacific/Wallis,
        pub const WALLIS: TimeZoneRef<'static> = tzdata::PACIFIC_WALLIS;
        /// Pacific/Yap,
        pub const YAP: TimeZoneRef<'static> = tzdata::PACIFIC_CHUUK;
    }

    /// us
    pub mod us {
        use super::*;

        /// US/Alaska,
        pub const ALASKA: TimeZoneRef<'static> = tzdata::AMERICA_ANCHORAGE;
        /// US/Aleutian,
        pub const ALEUTIAN: TimeZoneRef<'static> = tzdata::AMERICA_ADAK;
        /// US/Arizona,
        pub const ARIZONA: TimeZoneRef<'static> = tzdata::AMERICA_CRESTON;
        /// US/Central,
        pub const CENTRAL: TimeZoneRef<'static> = tzdata::AMERICA_CHICAGO;
        /// US/Eastern,
        pub const EASTERN: TimeZoneRef<'static> = tzdata::AMERICA_NEW_YORK;
        /// US/East-Indiana,
        pub const EAST_INDIANA: TimeZoneRef<'static> = tzdata::AMERICA_FORT_WAYNE;
        /// US/Hawaii,
        pub const HAWAII: TimeZoneRef<'static> = tzdata::PACIFIC_HONOLULU;
        /// US/Indiana-Starke,
        pub const INDIANA_STARKE: TimeZoneRef<'static> = tzdata::AMERICA_KNOX_IN;
        /// US/Michigan,
        pub const MICHIGAN: TimeZoneRef<'static> = tzdata::AMERICA_DETROIT;
        /// US/Mountain,
        pub const MOUNTAIN: TimeZoneRef<'static> = tzdata::NAVAJO;
        /// US/Pacific,
        pub const PACIFIC: TimeZoneRef<'static> = tzdata::AMERICA_LOS_ANGELES;
        /// US/Samoa,
        pub const SAMOA: TimeZoneRef<'static> = tzdata::PACIFIC_MIDWAY;
    }

    /// CET,
    pub const CET: TimeZoneRef<'static> = tzdata::CET;
    /// CST6CDT,
    pub const CST_6_CDT: TimeZoneRef<'static> = tzdata::CST_6_CDT;
    /// Cuba,
    pub const CUBA: TimeZoneRef<'static> = tzdata::CUBA;
    /// EET,
    pub const EET: TimeZoneRef<'static> = tzdata::EET;
    /// Egypt,
    pub const EGYPT: TimeZoneRef<'static> = tzdata::EGYPT;
    /// Eire,
    pub const EIRE: TimeZoneRef<'static> = tzdata::EIRE;
    /// EST,
    pub const EST: TimeZoneRef<'static> = tzdata::EST;
    /// EST5EDT,
    pub const EST_5_EDT: TimeZoneRef<'static> = tzdata::EST_5_EDT;
    /// Factory,
    pub const FACTORY: TimeZoneRef<'static> = tzdata::FACTORY;
    /// GB,
    pub const GB: TimeZoneRef<'static> = tzdata::GB;
    /// GB-Eire,
    pub const GB_EIRE: TimeZoneRef<'static> = tzdata::GB;
    /// GMT,
    pub const GMT: TimeZoneRef<'static> = tzdata::GMT;
    /// GMT0,
    pub const GMT_0: TimeZoneRef<'static> = tzdata::GMT;
    /// GMT-0,
    pub const GMT_MINUS_0: TimeZoneRef<'static> = tzdata::GMT;
    /// GMT+0,
    pub const GMT_PLUS_0: TimeZoneRef<'static> = tzdata::GMT;
    /// Greenwich,
    pub const GREENWICH: TimeZoneRef<'static> = tzdata::GMT;
    /// Hongkong,
    pub const HONGKONG: TimeZoneRef<'static> = tzdata::HONGKONG;
    /// HST,
    pub const HST: TimeZoneRef<'static> = tzdata::HST;
    /// Iceland,
    pub const ICELAND: TimeZoneRef<'static> = tzdata::ICELAND;
    /// Iran,
    pub const IRAN: TimeZoneRef<'static> = tzdata::IRAN;
    /// Israel,
    pub const ISRAEL: TimeZoneRef<'static> = tzdata::ISRAEL;
    /// Jamaica,
    pub const JAMAICA: TimeZoneRef<'static> = tzdata::JAMAICA;
    /// Japan,
    pub const JAPAN: TimeZoneRef<'static> = tzdata::JAPAN;
    /// Kwajalein,
    pub const KWAJALEIN: TimeZoneRef<'static> = tzdata::KWAJALEIN;
    /// Libya,
    pub const LIBYA: TimeZoneRef<'static> = tzdata::LIBYA;
    /// MET,
    pub const MET: TimeZoneRef<'static> = tzdata::MET;
    /// MST,
    pub const MST: TimeZoneRef<'static> = tzdata::MST;
    /// MST7MDT,
    pub const MST_7_MDT: TimeZoneRef<'static> = tzdata::MST_7_MDT;
    /// Navajo,
    pub const NAVAJO: TimeZoneRef<'static> = tzdata::NAVAJO;
    /// NZ,
    pub const NZ: TimeZoneRef<'static> = tzdata::NZ;
    /// NZ-CHAT,
    pub const NZ_CHAT: TimeZoneRef<'static> = tzdata::NZ_CHAT;
    /// Poland,
    pub const POLAND: TimeZoneRef<'static> = tzdata::POLAND;
    /// Portugal,
    pub const PORTUGAL: TimeZoneRef<'static> = tzdata::PORTUGAL;
    /// PRC,
    pub const PRC: TimeZoneRef<'static> = tzdata::PRC;
    /// PST8PDT,
    pub const PST_8_PDT: TimeZoneRef<'static> = tzdata::PST_8_PDT;
    /// ROC,
    pub const ROC: TimeZoneRef<'static> = tzdata::ROC;
    /// ROK,
    pub const ROK: TimeZoneRef<'static> = tzdata::ROK;
    /// Singapore,
    pub const SINGAPORE: TimeZoneRef<'static> = tzdata::SINGAPORE;
    /// Turkey,
    pub const TURKEY: TimeZoneRef<'static> = tzdata::TURKEY;
    /// UCT,
    pub const UCT: TimeZoneRef<'static> = tzdata::UCT;
    /// Universal,
    pub const UNIVERSAL: TimeZoneRef<'static> = tzdata::UCT;
    /// UTC,
    pub const UTC: TimeZoneRef<'static> = tzdata::UCT;
    /// WET,
    pub const WET: TimeZoneRef<'static> = tzdata::WET;
    /// W-SU,
    pub const W_SU: TimeZoneRef<'static> = tzdata::W_SU;
    /// Zulu,
    pub const ZULU: TimeZoneRef<'static> = tzdata::UCT;
}

#[cfg(feature = "by-name")]
pub(crate) const TIME_ZONES_BY_NAME: phf::Map<&'static str, &'static TimeZoneRef<'static>> =
    ::phf::Map {
        key: 12913932095322966823,
        disps: &[
            (0, 51),
            (0, 1),
            (0, 3),
            (0, 3),
            (0, 49),
            (0, 20),
            (0, 72),
            (0, 0),
            (0, 3),
            (0, 17),
            (0, 37),
            (0, 220),
            (0, 38),
            (0, 114),
            (3, 3),
            (0, 426),
            (0, 69),
            (0, 13),
            (0, 406),
            (0, 27),
            (0, 3),
            (0, 63),
            (0, 2),
            (0, 0),
            (0, 80),
            (1, 0),
            (1, 143),
            (0, 48),
            (0, 238),
            (0, 146),
            (0, 0),
            (0, 290),
            (0, 20),
            (0, 1),
            (0, 25),
            (2, 386),
            (0, 174),
            (0, 17),
            (0, 6),
            (0, 9),
            (0, 2),
            (0, 8),
            (0, 18),
            (6, 343),
            (0, 251),
            (0, 20),
            (0, 51),
            (0, 213),
            (0, 107),
            (0, 224),
            (0, 76),
            (0, 86),
            (0, 279),
            (0, 102),
            (4, 519),
            (1, 359),
            (0, 240),
            (4, 118),
            (2, 434),
            (0, 32),
            (0, 194),
            (4, 488),
            (0, 223),
            (0, 7),
            (0, 493),
            (0, 419),
            (0, 0),
            (0, 0),
            (1, 122),
            (0, 29),
            (0, 30),
            (0, 376),
            (0, 60),
            (0, 22),
            (0, 111),
            (0, 10),
            (0, 11),
            (8, 118),
            (0, 56),
            (4, 243),
            (0, 302),
            (0, 16),
            (0, 6),
            (9, 387),
            (1, 142),
            (0, 2),
            (0, 3),
            (6, 231),
            (5, 527),
            (0, 77),
            (0, 3),
            (2, 169),
            (0, 90),
            (4, 15),
            (0, 4),
            (2, 493),
            (1, 342),
            (0, 3),
            (23, 250),
            (7, 127),
            (1, 320),
            (0, 3),
            (0, 0),
            (57, 89),
            (6, 75),
            (23, 38),
            (0, 7),
            (0, 20),
            (0, 306),
            (3, 244),
            (1, 282),
            (0, 113),
            (0, 4),
            (0, 4),
        ],
        entries: &[
            ("europe/istanbul", &tzdata::TURKEY),
            ("etc/gmt+1", &tzdata::ETC_GMT_PLUS_1),
            ("asia/novokuznetsk", &tzdata::ASIA_NOVOKUZNETSK),
            ("africa/sao_tome", &tzdata::AFRICA_SAO_TOME),
            ("europe/minsk", &tzdata::EUROPE_MINSK),
            ("america/guadeloupe", &tzdata::AMERICA_ANGUILLA),
            ("america/dawson_creek", &tzdata::AMERICA_DAWSON_CREEK),
            ("antarctica/vostok", &tzdata::ANTARCTICA_VOSTOK),
            ("europe/budapest", &tzdata::EUROPE_BUDAPEST),
            ("america/nuuk", &tzdata::AMERICA_GODTHAB),
            ("asia/aqtau", &tzdata::ASIA_AQTAU),
            ("cuba", &tzdata::CUBA),
            ("america/mexico_city", &tzdata::AMERICA_MEXICO_CITY),
            ("europe/london", &tzdata::GB),
            ("america/aruba", &tzdata::AMERICA_ANGUILLA),
            ("america/la_paz", &tzdata::AMERICA_LA_PAZ),
            ("asia/thimbu", &tzdata::ASIA_THIMBU),
            ("antarctica/south_pole", &tzdata::NZ),
            ("est5edt", &tzdata::EST_5_EDT),
            ("america/araguaina", &tzdata::AMERICA_ARAGUAINA),
            ("asia/colombo", &tzdata::ASIA_COLOMBO),
            ("europe/lisbon", &tzdata::PORTUGAL),
            ("africa/algiers", &tzdata::AFRICA_ALGIERS),
            ("nz-chat", &tzdata::NZ_CHAT),
            ("africa/cairo", &tzdata::EGYPT),
            ("asia/barnaul", &tzdata::ASIA_BARNAUL),
            ("asia/hong_kong", &tzdata::HONGKONG),
            ("america/port_of_spain", &tzdata::AMERICA_ANGUILLA),
            ("america/tegucigalpa", &tzdata::AMERICA_TEGUCIGALPA),
            ("us/central", &tzdata::AMERICA_CHICAGO),
            ("pacific/guam", &tzdata::PACIFIC_GUAM),
            ("africa/abidjan", &tzdata::AFRICA_ABIDJAN),
            ("europe/copenhagen", &tzdata::EUROPE_COPENHAGEN),
            ("america/nipigon", &tzdata::AMERICA_NIPIGON),
            ("etc/gmt+4", &tzdata::ETC_GMT_PLUS_4),
            ("pacific/efate", &tzdata::PACIFIC_EFATE),
            ("pacific/palau", &tzdata::PACIFIC_PALAU),
            ("arctic/longyearbyen", &tzdata::ARCTIC_LONGYEARBYEN),
            ("america/creston", &tzdata::AMERICA_CRESTON),
            ("asia/tomsk", &tzdata::ASIA_TOMSK),
            ("etc/gmt+12", &tzdata::ETC_GMT_PLUS_12),
            ("wet", &tzdata::WET),
            ("america/fortaleza", &tzdata::AMERICA_FORTALEZA),
            ("etc/greenwich", &tzdata::GMT),
            ("etc/gmt-9", &tzdata::ETC_GMT_MINUS_9),
            ("europe/mariehamn", &tzdata::EUROPE_HELSINKI),
            ("america/monterrey", &tzdata::AMERICA_MONTERREY),
            ("europe/belfast", &tzdata::GB),
            ("pacific/yap", &tzdata::PACIFIC_CHUUK),
            ("asia/jayapura", &tzdata::ASIA_JAYAPURA),
            ("asia/qyzylorda", &tzdata::ASIA_QYZYLORDA),
            ("etc/gmt-3", &tzdata::ETC_GMT_MINUS_3),
            ("america/hermosillo", &tzdata::AMERICA_HERMOSILLO),
            ("pacific/samoa", &tzdata::PACIFIC_MIDWAY),
            ("asia/srednekolymsk", &tzdata::ASIA_SREDNEKOLYMSK),
            ("america/guatemala", &tzdata::AMERICA_GUATEMALA),
            ("europe/ulyanovsk", &tzdata::EUROPE_ULYANOVSK),
            ("america/paramaribo", &tzdata::AMERICA_PARAMARIBO),
            ("asia/hebron", &tzdata::ASIA_HEBRON),
            ("asia/kamchatka", &tzdata::ASIA_KAMCHATKA),
            ("america/belem", &tzdata::AMERICA_BELEM),
            ("asia/kuala_lumpur", &tzdata::ASIA_KUALA_LUMPUR),
            ("pacific/niue", &tzdata::PACIFIC_NIUE),
            ("america/ojinaga", &tzdata::AMERICA_OJINAGA),
            ("asia/kuwait", &tzdata::ANTARCTICA_SYOWA),
            ("us/arizona", &tzdata::AMERICA_CRESTON),
            ("america/atikokan", &tzdata::AMERICA_ATIKOKAN),
            ("asia/katmandu", &tzdata::ASIA_KATHMANDU),
            ("europe/zagreb", &tzdata::EUROPE_BELGRADE),
            ("africa/harare", &tzdata::AFRICA_BLANTYRE),
            ("hongkong", &tzdata::HONGKONG),
            ("america/yellowknife", &tzdata::AMERICA_YELLOWKNIFE),
            ("asia/nicosia", &tzdata::ASIA_NICOSIA),
            ("africa/luanda", &tzdata::AFRICA_BANGUI),
            ("asia/kabul", &tzdata::ASIA_KABUL),
            ("africa/el_aaiun", &tzdata::AFRICA_EL_AAIUN),
            ("europe/kaliningrad", &tzdata::EUROPE_KALININGRAD),
            ("asia/macau", &tzdata::ASIA_MACAO),
            ("pacific/saipan", &tzdata::PACIFIC_GUAM),
            ("europe/oslo", &tzdata::ARCTIC_LONGYEARBYEN),
            ("australia/melbourne", &tzdata::AUSTRALIA_MELBOURNE),
            ("australia/lhi", &tzdata::AUSTRALIA_LHI),
            ("us/aleutian", &tzdata::AMERICA_ADAK),
            ("met", &tzdata::MET),
            ("europe/san_marino", &tzdata::EUROPE_ROME),
            ("asia/brunei", &tzdata::ASIA_BRUNEI),
            ("poland", &tzdata::POLAND),
            ("africa/johannesburg", &tzdata::AFRICA_JOHANNESBURG),
            ("asia/ujung_pandang", &tzdata::ASIA_MAKASSAR),
            ("asia/chita", &tzdata::ASIA_CHITA),
            ("etc/gmt-8", &tzdata::ETC_GMT_MINUS_8),
            ("asia/seoul", &tzdata::ROK),
            ("pacific/tahiti", &tzdata::PACIFIC_TAHITI),
            ("africa/dakar", &tzdata::AFRICA_ABIDJAN),
            ("pst8pdt", &tzdata::PST_8_PDT),
            ("australia/lindeman", &tzdata::AUSTRALIA_LINDEMAN),
            ("australia/darwin", &tzdata::AUSTRALIA_DARWIN),
            ("pacific/funafuti", &tzdata::PACIFIC_FUNAFUTI),
            ("atlantic/jan_mayen", &tzdata::ARCTIC_LONGYEARBYEN),
            ("portugal", &tzdata::PORTUGAL),
            ("pacific/galapagos", &tzdata::PACIFIC_GALAPAGOS),
            ("africa/gaborone", &tzdata::AFRICA_BLANTYRE),
            ("asia/tokyo", &tzdata::JAPAN),
            ("africa/maseru", &tzdata::AFRICA_JOHANNESBURG),
            ("us/michigan", &tzdata::AMERICA_DETROIT),
            ("etc/gmt+2", &tzdata::ETC_GMT_PLUS_2),
            ("america/manaus", &tzdata::AMERICA_MANAUS),
            ("antarctica/syowa", &tzdata::ANTARCTICA_SYOWA),
            ("asia/chongqing", &tzdata::PRC),
            ("us/alaska", &tzdata::AMERICA_ANCHORAGE),
            ("jamaica", &tzdata::JAMAICA),
            ("mexico/bajasur", &tzdata::AMERICA_MAZATLAN),
            ("indian/antananarivo", &tzdata::AFRICA_ADDIS_ABABA),
            ("america/bahia", &tzdata::AMERICA_BAHIA),
            ("navajo", &tzdata::NAVAJO),
            ("canada/eastern", &tzdata::AMERICA_MONTREAL),
            ("us/samoa", &tzdata::PACIFIC_MIDWAY),
            ("america/ensenada", &tzdata::AMERICA_ENSENADA),
            ("europe/zurich", &tzdata::EUROPE_BUSINGEN),
            ("asia/manila", &tzdata::ASIA_MANILA),
            ("europe/busingen", &tzdata::EUROPE_BUSINGEN),
            ("europe/andorra", &tzdata::EUROPE_ANDORRA),
            ("atlantic/faeroe", &tzdata::ATLANTIC_FAEROE),
            ("asia/anadyr", &tzdata::ASIA_ANADYR),
            ("america/cayenne", &tzdata::AMERICA_CAYENNE),
            ("america/menominee", &tzdata::AMERICA_MENOMINEE),
            ("america/recife", &tzdata::AMERICA_RECIFE),
            ("america/rainy_river", &tzdata::AMERICA_RAINY_RIVER),
            ("pacific/enderbury", &tzdata::PACIFIC_ENDERBURY),
            ("europe/madrid", &tzdata::EUROPE_MADRID),
            ("america/st_thomas", &tzdata::AMERICA_ANGUILLA),
            ("etc/gmt-6", &tzdata::ETC_GMT_MINUS_6),
            ("australia/nsw", &tzdata::AUSTRALIA_ACT),
            ("africa/lubumbashi", &tzdata::AFRICA_BLANTYRE),
            ("asia/ulan_bator", &tzdata::ASIA_ULAANBAATAR),
            ("australia/north", &tzdata::AUSTRALIA_DARWIN),
            ("etc/gmt+8", &tzdata::ETC_GMT_PLUS_8),
            ("america/tijuana", &tzdata::AMERICA_ENSENADA),
            ("africa/mogadishu", &tzdata::AFRICA_ADDIS_ABABA),
            ("america/inuvik", &tzdata::AMERICA_INUVIK),
            ("america/lima", &tzdata::AMERICA_LIMA),
            ("europe/warsaw", &tzdata::POLAND),
            ("europe/jersey", &tzdata::GB),
            ("asia/qostanay", &tzdata::ASIA_QOSTANAY),
            ("america/buenos_aires", &tzdata::AMERICA_BUENOS_AIRES),
            ("australia/canberra", &tzdata::AUSTRALIA_ACT),
            ("pacific/pitcairn", &tzdata::PACIFIC_PITCAIRN),
            ("africa/bissau", &tzdata::AFRICA_BISSAU),
            ("australia/west", &tzdata::AUSTRALIA_PERTH),
            ("pacific/pago_pago", &tzdata::PACIFIC_MIDWAY),
            ("pacific/kiritimati", &tzdata::PACIFIC_KIRITIMATI),
            ("europe/astrakhan", &tzdata::EUROPE_ASTRAKHAN),
            ("america/scoresbysund", &tzdata::AMERICA_SCORESBYSUND),
            ("etc/gmt-0", &tzdata::GMT),
            ("canada/central", &tzdata::AMERICA_WINNIPEG),
            ("america/swift_current", &tzdata::AMERICA_SWIFT_CURRENT),
            ("pacific/kwajalein", &tzdata::KWAJALEIN),
            ("europe/paris", &tzdata::EUROPE_PARIS),
            ("africa/casablanca", &tzdata::AFRICA_CASABLANCA),
            ("europe/podgorica", &tzdata::EUROPE_BELGRADE),
            ("israel", &tzdata::ISRAEL),
            ("australia/queensland", &tzdata::AUSTRALIA_BRISBANE),
            ("etc/gmt-4", &tzdata::ETC_GMT_MINUS_4),
            ("america/anguilla", &tzdata::AMERICA_ANGUILLA),
            ("europe/vaduz", &tzdata::EUROPE_BUSINGEN),
            ("america/jujuy", &tzdata::AMERICA_JUJUY),
            ("america/grenada", &tzdata::AMERICA_ANGUILLA),
            ("america/managua", &tzdata::AMERICA_MANAGUA),
            ("europe/rome", &tzdata::EUROPE_ROME),
            ("africa/freetown", &tzdata::AFRICA_ABIDJAN),
            ("america/bahia_banderas", &tzdata::AMERICA_BAHIA_BANDERAS),
            ("gmt0", &tzdata::GMT),
            ("canada/atlantic", &tzdata::AMERICA_HALIFAX),
            ("etc/zulu", &tzdata::UCT),
            ("america/sao_paulo", &tzdata::AMERICA_SAO_PAULO),
            ("europe/tirane", &tzdata::EUROPE_TIRANE),
            ("europe/belgrade", &tzdata::EUROPE_BELGRADE),
            ("asia/macao", &tzdata::ASIA_MACAO),
            ("japan", &tzdata::JAPAN),
            ("africa/ouagadougou", &tzdata::AFRICA_ABIDJAN),
            ("brazil/denoronha", &tzdata::AMERICA_NORONHA),
            ("asia/riyadh", &tzdata::ANTARCTICA_SYOWA),
            ("atlantic/south_georgia", &tzdata::ATLANTIC_SOUTH_GEORGIA),
            ("europe/brussels", &tzdata::EUROPE_BRUSSELS),
            ("indian/mayotte", &tzdata::AFRICA_ADDIS_ABABA),
            ("america/montserrat", &tzdata::AMERICA_ANGUILLA),
            ("hst", &tzdata::HST),
            ("america/jamaica", &tzdata::JAMAICA),
            ("africa/lagos", &tzdata::AFRICA_BANGUI),
            ("asia/istanbul", &tzdata::TURKEY),
            ("asia/rangoon", &tzdata::ASIA_RANGOON),
            ("america/santiago", &tzdata::AMERICA_SANTIAGO),
            ("asia/harbin", &tzdata::PRC),
            ("asia/almaty", &tzdata::ASIA_ALMATY),
            ("europe/zaporozhye", &tzdata::EUROPE_ZAPOROZHYE),
            ("america/port-au-prince", &tzdata::AMERICA_PORT_AU_PRINCE),
            ("australia/perth", &tzdata::AUSTRALIA_PERTH),
            ("america/resolute", &tzdata::AMERICA_RESOLUTE),
            ("asia/jakarta", &tzdata::ASIA_JAKARTA),
            ("africa/bamako", &tzdata::AFRICA_ABIDJAN),
            ("america/thunder_bay", &tzdata::AMERICA_THUNDER_BAY),
            ("america/detroit", &tzdata::AMERICA_DETROIT),
            ("antarctica/casey", &tzdata::ANTARCTICA_CASEY),
            ("america/blanc-sablon", &tzdata::AMERICA_ANGUILLA),
            ("asia/khandyga", &tzdata::ASIA_KHANDYGA),
            ("asia/choibalsan", &tzdata::ASIA_CHOIBALSAN),
            ("australia/tasmania", &tzdata::AUSTRALIA_CURRIE),
            ("asia/calcutta", &tzdata::ASIA_CALCUTTA),
            ("america/iqaluit", &tzdata::AMERICA_IQALUIT),
            ("america/montevideo", &tzdata::AMERICA_MONTEVIDEO),
            ("america/havana", &tzdata::CUBA),
            ("zulu", &tzdata::UCT),
            ("europe/dublin", &tzdata::EIRE),
            ("america/curacao", &tzdata::AMERICA_ANGUILLA),
            ("america/punta_arenas", &tzdata::AMERICA_PUNTA_ARENAS),
            ("pacific/kanton", &tzdata::PACIFIC_ENDERBURY),
            ("africa/kigali", &tzdata::AFRICA_BLANTYRE),
            ("etc/gmt+9", &tzdata::ETC_GMT_PLUS_9),
            ("europe/moscow", &tzdata::W_SU),
            ("australia/brisbane", &tzdata::AUSTRALIA_BRISBANE),
            ("america/sitka", &tzdata::AMERICA_SITKA),
            ("europe/ljubljana", &tzdata::EUROPE_BELGRADE),
            ("pacific/rarotonga", &tzdata::PACIFIC_RAROTONGA),
            ("europe/vatican", &tzdata::EUROPE_ROME),
            ("mexico/bajanorte", &tzdata::AMERICA_ENSENADA),
            ("antarctica/mcmurdo", &tzdata::NZ),
            ("america/rankin_inlet", &tzdata::AMERICA_RANKIN_INLET),
            ("australia/south", &tzdata::AUSTRALIA_ADELAIDE),
            ("europe/vilnius", &tzdata::EUROPE_VILNIUS),
            ("us/indiana-starke", &tzdata::AMERICA_KNOX_IN),
            ("europe/kirov", &tzdata::EUROPE_KIROV),
            ("africa/monrovia", &tzdata::AFRICA_MONROVIA),
            ("atlantic/stanley", &tzdata::ATLANTIC_STANLEY),
            ("america/juneau", &tzdata::AMERICA_JUNEAU),
            ("australia/hobart", &tzdata::AUSTRALIA_CURRIE),
            ("greenwich", &tzdata::GMT),
            ("asia/damascus", &tzdata::ASIA_DAMASCUS),
            ("asia/yangon", &tzdata::ASIA_RANGOON),
            ("asia/krasnoyarsk", &tzdata::ASIA_KRASNOYARSK),
            ("etc/gmt-10", &tzdata::ETC_GMT_MINUS_10),
            ("america/catamarca", &tzdata::AMERICA_CATAMARCA),
            ("asia/bishkek", &tzdata::ASIA_BISHKEK),
            ("australia/broken_hill", &tzdata::AUSTRALIA_BROKEN_HILL),
            ("asia/vladivostok", &tzdata::ASIA_VLADIVOSTOK),
            ("america/chicago", &tzdata::AMERICA_CHICAGO),
            ("pacific/guadalcanal", &tzdata::PACIFIC_GUADALCANAL),
            ("pacific/wake", &tzdata::PACIFIC_WAKE),
            ("pacific/honolulu", &tzdata::PACIFIC_HONOLULU),
            ("etc/gmt-11", &tzdata::ETC_GMT_MINUS_11),
            ("africa/windhoek", &tzdata::AFRICA_WINDHOEK),
            ("asia/aden", &tzdata::ANTARCTICA_SYOWA),
            ("chile/easterisland", &tzdata::CHILE_EASTER_ISLAND),
            ("asia/thimphu", &tzdata::ASIA_THIMBU),
            ("europe/skopje", &tzdata::EUROPE_BELGRADE),
            ("pacific/tongatapu", &tzdata::PACIFIC_TONGATAPU),
            ("pacific/johnston", &tzdata::PACIFIC_HONOLULU),
            ("america/santarem", &tzdata::AMERICA_SANTAREM),
            ("europe/luxembourg", &tzdata::EUROPE_LUXEMBOURG),
            ("asia/ust-nera", &tzdata::ASIA_UST_NERA),
            ("europe/saratov", &tzdata::EUROPE_SARATOV),
            ("asia/dhaka", &tzdata::ASIA_DACCA),
            ("america/porto_velho", &tzdata::AMERICA_PORTO_VELHO),
            ("etc/gmt+0", &tzdata::GMT),
            ("canada/mountain", &tzdata::AMERICA_EDMONTON),
            ("africa/nouakchott", &tzdata::AFRICA_ABIDJAN),
            ("factory", &tzdata::FACTORY),
            ("america/antigua", &tzdata::AMERICA_ANGUILLA),
            ("europe/helsinki", &tzdata::EUROPE_HELSINKI),
            ("africa/kampala", &tzdata::AFRICA_ADDIS_ABABA),
            ("america/adak", &tzdata::AMERICA_ADAK),
            ("asia/gaza", &tzdata::ASIA_GAZA),
            ("america/fort_wayne", &tzdata::AMERICA_FORT_WAYNE),
            ("brazil/east", &tzdata::AMERICA_SAO_PAULO),
            ("etc/gmt+10", &tzdata::ETC_GMT_PLUS_10),
            ("africa/brazzaville", &tzdata::AFRICA_BANGUI),
            ("america/kralendijk", &tzdata::AMERICA_ANGUILLA),
            ("europe/sofia", &tzdata::EUROPE_SOFIA),
            ("africa/ndjamena", &tzdata::AFRICA_NDJAMENA),
            ("asia/baku", &tzdata::ASIA_BAKU),
            ("europe/bucharest", &tzdata::EUROPE_BUCHAREST),
            ("asia/saigon", &tzdata::ASIA_HO_CHI_MINH),
            ("pacific/fakaofo", &tzdata::PACIFIC_FAKAOFO),
            ("asia/yerevan", &tzdata::ASIA_YEREVAN),
            ("america/santa_isabel", &tzdata::AMERICA_ENSENADA),
            ("indian/kerguelen", &tzdata::INDIAN_KERGUELEN),
            ("asia/famagusta", &tzdata::ASIA_FAMAGUSTA),
            ("etc/uct", &tzdata::UCT),
            ("africa/accra", &tzdata::AFRICA_ABIDJAN),
            ("america/guayaquil", &tzdata::AMERICA_GUAYAQUIL),
            ("asia/kashgar", &tzdata::ASIA_KASHGAR),
            ("america/rio_branco", &tzdata::AMERICA_PORTO_ACRE),
            ("gmt+0", &tzdata::GMT),
            ("asia/bahrain", &tzdata::ASIA_BAHRAIN),
            ("eire", &tzdata::EIRE),
            ("pacific/majuro", &tzdata::PACIFIC_MAJURO),
            ("etc/gmt0", &tzdata::GMT),
            ("america/mendoza", &tzdata::AMERICA_MENDOZA),
            ("pacific/bougainville", &tzdata::PACIFIC_BOUGAINVILLE),
            ("indian/mahe", &tzdata::INDIAN_MAHE),
            ("mst", &tzdata::MST),
            ("europe/monaco", &tzdata::EUROPE_MONACO),
            ("australia/yancowinna", &tzdata::AUSTRALIA_BROKEN_HILL),
            ("asia/pontianak", &tzdata::ASIA_PONTIANAK),
            ("america/vancouver", &tzdata::AMERICA_VANCOUVER),
            ("antarctica/palmer", &tzdata::ANTARCTICA_PALMER),
            ("antarctica/davis", &tzdata::ANTARCTICA_DAVIS),
            ("australia/currie", &tzdata::AUSTRALIA_CURRIE),
            ("asia/muscat", &tzdata::ASIA_DUBAI),
            ("singapore", &tzdata::SINGAPORE),
            ("europe/amsterdam", &tzdata::EUROPE_AMSTERDAM),
            ("pacific/apia", &tzdata::PACIFIC_APIA),
            ("asia/novosibirsk", &tzdata::ASIA_NOVOSIBIRSK),
            ("america/cambridge_bay", &tzdata::AMERICA_CAMBRIDGE_BAY),
            ("africa/ceuta", &tzdata::AFRICA_CEUTA),
            ("us/east-indiana", &tzdata::AMERICA_FORT_WAYNE),
            ("america/rosario", &tzdata::AMERICA_CORDOBA),
            ("africa/lome", &tzdata::AFRICA_ABIDJAN),
            ("europe/riga", &tzdata::EUROPE_RIGA),
            ("africa/nairobi", &tzdata::AFRICA_ADDIS_ABABA),
            ("europe/nicosia", &tzdata::ASIA_NICOSIA),
            ("africa/banjul", &tzdata::AFRICA_ABIDJAN),
            ("antarctica/troll", &tzdata::ANTARCTICA_TROLL),
            ("europe/tallinn", &tzdata::EUROPE_TALLINN),
            ("asia/baghdad", &tzdata::ASIA_BAGHDAD),
            ("mexico/general", &tzdata::AMERICA_MEXICO_CITY),
            ("africa/addis_ababa", &tzdata::AFRICA_ADDIS_ABABA),
            ("asia/singapore", &tzdata::SINGAPORE),
            ("atlantic/madeira", &tzdata::ATLANTIC_MADEIRA),
            ("america/mazatlan", &tzdata::AMERICA_MAZATLAN),
            ("america/st_johns", &tzdata::AMERICA_ST_JOHNS),
            ("europe/chisinau", &tzdata::EUROPE_CHISINAU),
            ("america/goose_bay", &tzdata::AMERICA_GOOSE_BAY),
            ("america/nassau", &tzdata::AMERICA_MONTREAL),
            ("america/coral_harbour", &tzdata::AMERICA_ATIKOKAN),
            ("america/grand_turk", &tzdata::AMERICA_GRAND_TURK),
            ("africa/djibouti", &tzdata::AFRICA_ADDIS_ABABA),
            ("australia/adelaide", &tzdata::AUSTRALIA_ADELAIDE),
            ("asia/tashkent", &tzdata::ASIA_TASHKENT),
            ("europe/bratislava", &tzdata::EUROPE_BRATISLAVA),
            ("us/hawaii", &tzdata::PACIFIC_HONOLULU),
            ("america/chihuahua", &tzdata::AMERICA_CHIHUAHUA),
            ("america/el_salvador", &tzdata::AMERICA_EL_SALVADOR),
            ("etc/gmt+7", &tzdata::ETC_GMT_PLUS_7),
            ("australia/victoria", &tzdata::AUSTRALIA_MELBOURNE),
            ("pacific/truk", &tzdata::PACIFIC_CHUUK),
            ("america/lower_princes", &tzdata::AMERICA_ANGUILLA),
            ("etc/gmt+3", &tzdata::ETC_GMT_PLUS_3),
            ("eet", &tzdata::EET),
            ("asia/hovd", &tzdata::ASIA_HOVD),
            ("indian/reunion", &tzdata::INDIAN_REUNION),
            ("asia/phnom_penh", &tzdata::ASIA_BANGKOK),
            ("asia/dacca", &tzdata::ASIA_DACCA),
            ("pacific/midway", &tzdata::PACIFIC_MIDWAY),
            ("america/campo_grande", &tzdata::AMERICA_CAMPO_GRANDE),
            ("america/winnipeg", &tzdata::AMERICA_WINNIPEG),
            ("america/knox_in", &tzdata::AMERICA_KNOX_IN),
            ("america/danmarkshavn", &tzdata::AMERICA_DANMARKSHAVN),
            ("antarctica/macquarie", &tzdata::ANTARCTICA_MACQUARIE),
            ("asia/kuching", &tzdata::ASIA_KUCHING),
            ("europe/vienna", &tzdata::EUROPE_VIENNA),
            ("asia/chungking", &tzdata::PRC),
            ("asia/qatar", &tzdata::ASIA_BAHRAIN),
            ("cet", &tzdata::CET),
            ("asia/ashgabat", &tzdata::ASIA_ASHGABAT),
            ("europe/berlin", &tzdata::EUROPE_BERLIN),
            ("europe/tiraspol", &tzdata::EUROPE_CHISINAU),
            ("america/shiprock", &tzdata::NAVAJO),
            ("etc/gmt-12", &tzdata::ETC_GMT_MINUS_12),
            ("africa/niamey", &tzdata::AFRICA_BANGUI),
            ("america/dominica", &tzdata::AMERICA_ANGUILLA),
            ("america/glace_bay", &tzdata::AMERICA_GLACE_BAY),
            ("america/bogota", &tzdata::AMERICA_BOGOTA),
            ("europe/simferopol", &tzdata::EUROPE_SIMFEROPOL),
            ("asia/kolkata", &tzdata::ASIA_CALCUTTA),
            ("europe/athens", &tzdata::EUROPE_ATHENS),
            ("america/barbados", &tzdata::AMERICA_BARBADOS),
            ("utc", &tzdata::UCT),
            ("us/mountain", &tzdata::NAVAJO),
            ("atlantic/st_helena", &tzdata::AFRICA_ABIDJAN),
            ("asia/aqtobe", &tzdata::ASIA_AQTOBE),
            ("asia/irkutsk", &tzdata::ASIA_IRKUTSK),
            ("australia/lord_howe", &tzdata::AUSTRALIA_LHI),
            ("america/anchorage", &tzdata::AMERICA_ANCHORAGE),
            ("america/panama", &tzdata::AMERICA_ATIKOKAN),
            ("america/tortola", &tzdata::AMERICA_ANGUILLA),
            ("etc/gmt-1", &tzdata::ETC_GMT_MINUS_1),
            ("america/godthab", &tzdata::AMERICA_GODTHAB),
            ("brazil/acre", &tzdata::AMERICA_PORTO_ACRE),
            ("america/louisville", &tzdata::AMERICA_LOUISVILLE),
            ("etc/gmt-14", &tzdata::ETC_GMT_MINUS_14),
            ("america/maceio", &tzdata::AMERICA_MACEIO),
            ("etc/utc", &tzdata::UCT),
            ("africa/porto-novo", &tzdata::AFRICA_BANGUI),
            ("mst7mdt", &tzdata::MST_7_MDT),
            ("america/st_barthelemy", &tzdata::AMERICA_ANGUILLA),
            ("america/halifax", &tzdata::AMERICA_HALIFAX),
            ("asia/magadan", &tzdata::ASIA_MAGADAN),
            ("america/los_angeles", &tzdata::AMERICA_LOS_ANGELES),
            ("america/dawson", &tzdata::AMERICA_DAWSON),
            ("us/pacific", &tzdata::AMERICA_LOS_ANGELES),
            ("asia/ho_chi_minh", &tzdata::ASIA_HO_CHI_MINH),
            ("kwajalein", &tzdata::KWAJALEIN),
            ("africa/tunis", &tzdata::AFRICA_TUNIS),
            ("africa/bangui", &tzdata::AFRICA_BANGUI),
            ("america/yakutat", &tzdata::AMERICA_YAKUTAT),
            ("america/belize", &tzdata::AMERICA_BELIZE),
            ("pacific/auckland", &tzdata::NZ),
            ("america/toronto", &tzdata::AMERICA_MONTREAL),
            ("etc/gmt-2", &tzdata::ETC_GMT_MINUS_2),
            ("cst6cdt", &tzdata::CST_6_CDT),
            ("america/pangnirtung", &tzdata::AMERICA_PANGNIRTUNG),
            ("america/boise", &tzdata::AMERICA_BOISE),
            ("asia/vientiane", &tzdata::ASIA_BANGKOK),
            ("america/cuiaba", &tzdata::AMERICA_CUIABA),
            ("asia/tbilisi", &tzdata::ASIA_TBILISI),
            ("america/new_york", &tzdata::AMERICA_NEW_YORK),
            ("america/indianapolis", &tzdata::AMERICA_FORT_WAYNE),
            ("asia/karachi", &tzdata::ASIA_KARACHI),
            ("europe/volgograd", &tzdata::EUROPE_VOLGOGRAD),
            ("pacific/kosrae", &tzdata::PACIFIC_KOSRAE),
            ("w-su", &tzdata::W_SU),
            ("america/fort_nelson", &tzdata::AMERICA_FORT_NELSON),
            ("africa/asmara", &tzdata::AFRICA_ADDIS_ABABA),
            ("asia/pyongyang", &tzdata::ASIA_PYONGYANG),
            ("pacific/gambier", &tzdata::PACIFIC_GAMBIER),
            (
                "antarctica/dumontdurville",
                &tzdata::ANTARCTICA_DUMONT_D_URVILLE,
            ),
            ("america/cancun", &tzdata::AMERICA_CANCUN),
            ("america/cayman", &tzdata::AMERICA_ATIKOKAN),
            ("africa/malabo", &tzdata::AFRICA_BANGUI),
            ("africa/lusaka", &tzdata::AFRICA_BLANTYRE),
            ("europe/kiev", &tzdata::EUROPE_KIEV),
            ("gmt-0", &tzdata::GMT),
            ("iran", &tzdata::IRAN),
            ("america/marigot", &tzdata::AMERICA_ANGUILLA),
            ("europe/samara", &tzdata::EUROPE_SAMARA),
            ("europe/uzhgorod", &tzdata::EUROPE_UZHGOROD),
            ("uct", &tzdata::UCT),
            ("indian/christmas", &tzdata::INDIAN_CHRISTMAS),
            ("pacific/marquesas", &tzdata::PACIFIC_MARQUESAS),
            ("indian/maldives", &tzdata::INDIAN_MALDIVES),
            ("america/eirunepe", &tzdata::AMERICA_EIRUNEPE),
            ("america/martinique", &tzdata::AMERICA_MARTINIQUE),
            ("asia/urumqi", &tzdata::ASIA_KASHGAR),
            ("asia/makassar", &tzdata::ASIA_MAKASSAR),
            ("america/merida", &tzdata::AMERICA_MERIDA),
            ("indian/mauritius", &tzdata::INDIAN_MAURITIUS),
            ("iceland", &tzdata::ICELAND),
            ("nz", &tzdata::NZ),
            ("roc", &tzdata::ROC),
            ("africa/kinshasa", &tzdata::AFRICA_BANGUI),
            ("africa/tripoli", &tzdata::LIBYA),
            ("europe/stockholm", &tzdata::EUROPE_STOCKHOLM),
            ("america/costa_rica", &tzdata::AMERICA_COSTA_RICA),
            ("america/cordoba", &tzdata::AMERICA_CORDOBA),
            ("africa/libreville", &tzdata::AFRICA_BANGUI),
            ("us/eastern", &tzdata::AMERICA_NEW_YORK),
            ("africa/blantyre", &tzdata::AFRICA_BLANTYRE),
            ("asia/dili", &tzdata::ASIA_DILI),
            ("asia/sakhalin", &tzdata::ASIA_SAKHALIN),
            ("africa/asmera", &tzdata::AFRICA_ADDIS_ABABA),
            ("america/asuncion", &tzdata::AMERICA_ASUNCION),
            ("asia/yekaterinburg", &tzdata::ASIA_YEKATERINBURG),
            ("pacific/nauru", &tzdata::PACIFIC_NAURU),
            ("etc/gmt-13", &tzdata::ETC_GMT_MINUS_13),
            ("asia/amman", &tzdata::ASIA_AMMAN),
            ("america/nome", &tzdata::AMERICA_NOME),
            ("asia/kathmandu", &tzdata::ASIA_KATHMANDU),
            ("etc/gmt+6", &tzdata::ETC_GMT_PLUS_6),
            ("libya", &tzdata::LIBYA),
            ("atlantic/azores", &tzdata::ATLANTIC_AZORES),
            ("atlantic/faroe", &tzdata::ATLANTIC_FAEROE),
            ("america/matamoros", &tzdata::AMERICA_MATAMOROS),
            ("asia/dubai", &tzdata::ASIA_DUBAI),
            ("america/virgin", &tzdata::AMERICA_ANGUILLA),
            ("etc/gmt+11", &tzdata::ETC_GMT_PLUS_11),
            ("asia/ulaanbaatar", &tzdata::ASIA_ULAANBAATAR),
            ("asia/oral", &tzdata::ASIA_ORAL),
            ("pacific/chuuk", &tzdata::PACIFIC_CHUUK),
            ("america/whitehorse", &tzdata::AMERICA_WHITEHORSE),
            ("europe/sarajevo", &tzdata::EUROPE_BELGRADE),
            ("atlantic/reykjavik", &tzdata::ICELAND),
            ("etc/gmt", &tzdata::GMT),
            ("indian/cocos", &tzdata::INDIAN_COCOS),
            ("turkey", &tzdata::TURKEY),
            ("est", &tzdata::EST),
            ("canada/saskatchewan", &tzdata::AMERICA_REGINA),
            ("canada/newfoundland", &tzdata::AMERICA_ST_JOHNS),
            ("america/moncton", &tzdata::AMERICA_MONCTON),
            ("america/denver", &tzdata::NAVAJO),
            ("pacific/pohnpei", &tzdata::PACIFIC_POHNPEI),
            ("asia/tehran", &tzdata::IRAN),
            ("africa/dar_es_salaam", &tzdata::AFRICA_ADDIS_ABABA),
            ("chile/continental", &tzdata::AMERICA_SANTIAGO),
            ("antarctica/rothera", &tzdata::ANTARCTICA_ROTHERA),
            ("asia/tel_aviv", &tzdata::ISRAEL),
            ("australia/sydney", &tzdata::AUSTRALIA_ACT),
            ("australia/eucla", &tzdata::AUSTRALIA_EUCLA),
            ("australia/act", &tzdata::AUSTRALIA_ACT),
            ("atlantic/bermuda", &tzdata::ATLANTIC_BERMUDA),
            ("africa/mbabane", &tzdata::AFRICA_JOHANNESBURG),
            ("asia/samarkand", &tzdata::ASIA_SAMARKAND),
            ("europe/gibraltar", &tzdata::EUROPE_GIBRALTAR),
            ("etc/gmt-5", &tzdata::ETC_GMT_MINUS_5),
            ("africa/conakry", &tzdata::AFRICA_ABIDJAN),
            ("europe/malta", &tzdata::EUROPE_MALTA),
            ("canada/pacific", &tzdata::AMERICA_VANCOUVER),
            ("asia/omsk", &tzdata::ASIA_OMSK),
            ("atlantic/canary", &tzdata::ATLANTIC_CANARY),
            ("universal", &tzdata::UCT),
            ("africa/khartoum", &tzdata::AFRICA_KHARTOUM),
            ("canada/yukon", &tzdata::AMERICA_WHITEHORSE),
            ("america/miquelon", &tzdata::AMERICA_MIQUELON),
            ("asia/shanghai", &tzdata::PRC),
            ("indian/comoro", &tzdata::AFRICA_ADDIS_ABABA),
            ("asia/atyrau", &tzdata::ASIA_ATYRAU),
            ("antarctica/mawson", &tzdata::ANTARCTICA_MAWSON),
            ("indian/chagos", &tzdata::INDIAN_CHAGOS),
            ("etc/gmt-7", &tzdata::ETC_GMT_MINUS_7),
            ("america/santo_domingo", &tzdata::AMERICA_SANTO_DOMINGO),
            ("america/edmonton", &tzdata::AMERICA_EDMONTON),
            ("pacific/wallis", &tzdata::PACIFIC_WALLIS),
            ("america/st_lucia", &tzdata::AMERICA_ANGUILLA),
            ("asia/dushanbe", &tzdata::ASIA_DUSHANBE),
            ("atlantic/cape_verde", &tzdata::ATLANTIC_CAPE_VERDE),
            ("america/st_kitts", &tzdata::AMERICA_ANGUILLA),
            ("asia/ashkhabad", &tzdata::ASIA_ASHGABAT),
            ("etc/universal", &tzdata::UCT),
            ("asia/taipei", &tzdata::ROC),
            ("prc", &tzdata::PRC),
            ("asia/bangkok", &tzdata::ASIA_BANGKOK),
            ("america/thule", &tzdata::AMERICA_THULE),
            ("pacific/tarawa", &tzdata::PACIFIC_TARAWA),
            ("europe/prague", &tzdata::EUROPE_BRATISLAVA),
            ("asia/jerusalem", &tzdata::ISRAEL),
            ("gb-eire", &tzdata::GB),
            ("europe/isle_of_man", &tzdata::GB),
            ("rok", &tzdata::ROK),
            ("america/porto_acre", &tzdata::AMERICA_PORTO_ACRE),
            ("asia/yakutsk", &tzdata::ASIA_YAKUTSK),
            ("america/noronha", &tzdata::AMERICA_NORONHA),
            ("america/caracas", &tzdata::AMERICA_CARACAS),
            ("pacific/easter", &tzdata::CHILE_EASTER_ISLAND),
            ("america/guyana", &tzdata::AMERICA_GUYANA),
            ("pacific/chatham", &tzdata::NZ_CHAT),
            ("africa/juba", &tzdata::AFRICA_JUBA),
            ("america/metlakatla", &tzdata::AMERICA_METLAKATLA),
            ("america/puerto_rico", &tzdata::AMERICA_ANGUILLA),
            ("pacific/norfolk", &tzdata::PACIFIC_NORFOLK),
            ("africa/timbuktu", &tzdata::AFRICA_ABIDJAN),
            ("gmt", &tzdata::GMT),
            ("africa/bujumbura", &tzdata::AFRICA_BLANTYRE),
            ("egypt", &tzdata::EGYPT),
            ("gb", &tzdata::GB),
            ("pacific/fiji", &tzdata::PACIFIC_FIJI),
            ("pacific/port_moresby", &tzdata::ANTARCTICA_DUMONT_D_URVILLE),
            ("america/st_vincent", &tzdata::AMERICA_ANGUILLA),
            ("pacific/ponape", &tzdata::PACIFIC_POHNPEI),
            ("america/regina", &tzdata::AMERICA_REGINA),
            ("etc/gmt+5", &tzdata::ETC_GMT_PLUS_5),
            ("pacific/noumea", &tzdata::PACIFIC_NOUMEA),
            ("africa/maputo", &tzdata::AFRICA_BLANTYRE),
            ("america/montreal", &tzdata::AMERICA_MONTREAL),
            ("africa/douala", &tzdata::AFRICA_BANGUI),
            ("asia/beirut", &tzdata::ASIA_BEIRUT),
            ("brazil/west", &tzdata::AMERICA_MANAUS),
            ("america/boa_vista", &tzdata::AMERICA_BOA_VISTA),
            ("europe/guernsey", &tzdata::GB),
            ("america/atka", &tzdata::AMERICA_ADAK),
            ("america/phoenix", &tzdata::AMERICA_CRESTON),
        ],
    };

#[cfg(feature = "list")]
pub(crate) const TIME_ZONES_LIST: [&str; 569] = [
    "Africa/Abidjan",
    "Africa/Accra",
    "Africa/Addis_Ababa",
    "Africa/Algiers",
    "Africa/Asmara",
    "Africa/Asmera",
    "Africa/Bamako",
    "Africa/Bangui",
    "Africa/Banjul",
    "Africa/Bissau",
    "Africa/Blantyre",
    "Africa/Brazzaville",
    "Africa/Bujumbura",
    "Africa/Cairo",
    "Africa/Casablanca",
    "Africa/Ceuta",
    "Africa/Conakry",
    "Africa/Dakar",
    "Africa/Dar_es_Salaam",
    "Africa/Djibouti",
    "Africa/Douala",
    "Africa/El_Aaiun",
    "Africa/Freetown",
    "Africa/Gaborone",
    "Africa/Harare",
    "Africa/Johannesburg",
    "Africa/Juba",
    "Africa/Kampala",
    "Africa/Khartoum",
    "Africa/Kigali",
    "Africa/Kinshasa",
    "Africa/Lagos",
    "Africa/Libreville",
    "Africa/Lome",
    "Africa/Luanda",
    "Africa/Lubumbashi",
    "Africa/Lusaka",
    "Africa/Malabo",
    "Africa/Maputo",
    "Africa/Maseru",
    "Africa/Mbabane",
    "Africa/Mogadishu",
    "Africa/Monrovia",
    "Africa/Nairobi",
    "Africa/Ndjamena",
    "Africa/Niamey",
    "Africa/Nouakchott",
    "Africa/Ouagadougou",
    "Africa/Porto-Novo",
    "Africa/Sao_Tome",
    "Africa/Timbuktu",
    "Africa/Tripoli",
    "Africa/Tunis",
    "Africa/Windhoek",
    "America/Adak",
    "America/Anchorage",
    "America/Anguilla",
    "America/Antigua",
    "America/Araguaina",
    "America/Aruba",
    "America/Asuncion",
    "America/Atikokan",
    "America/Atka",
    "America/Bahia",
    "America/Bahia_Banderas",
    "America/Barbados",
    "America/Belem",
    "America/Belize",
    "America/Blanc-Sablon",
    "America/Boa_Vista",
    "America/Bogota",
    "America/Boise",
    "America/Buenos_Aires",
    "America/Cambridge_Bay",
    "America/Campo_Grande",
    "America/Cancun",
    "America/Caracas",
    "America/Catamarca",
    "America/Cayenne",
    "America/Cayman",
    "America/Chicago",
    "America/Chihuahua",
    "America/Coral_Harbour",
    "America/Cordoba",
    "America/Costa_Rica",
    "America/Creston",
    "America/Cuiaba",
    "America/Curacao",
    "America/Danmarkshavn",
    "America/Dawson",
    "America/Dawson_Creek",
    "America/Denver",
    "America/Detroit",
    "America/Dominica",
    "America/Edmonton",
    "America/Eirunepe",
    "America/El_Salvador",
    "America/Ensenada",
    "America/Fort_Nelson",
    "America/Fort_Wayne",
    "America/Fortaleza",
    "America/Glace_Bay",
    "America/Godthab",
    "America/Goose_Bay",
    "America/Grand_Turk",
    "America/Grenada",
    "America/Guadeloupe",
    "America/Guatemala",
    "America/Guayaquil",
    "America/Guyana",
    "America/Halifax",
    "America/Havana",
    "America/Hermosillo",
    "America/Indianapolis",
    "America/Inuvik",
    "America/Iqaluit",
    "America/Jamaica",
    "America/Jujuy",
    "America/Juneau",
    "America/Knox_IN",
    "America/Kralendijk",
    "America/La_Paz",
    "America/Lima",
    "America/Los_Angeles",
    "America/Louisville",
    "America/Lower_Princes",
    "America/Maceio",
    "America/Managua",
    "America/Manaus",
    "America/Marigot",
    "America/Martinique",
    "America/Matamoros",
    "America/Mazatlan",
    "America/Mendoza",
    "America/Menominee",
    "America/Merida",
    "America/Metlakatla",
    "America/Mexico_City",
    "America/Miquelon",
    "America/Moncton",
    "America/Monterrey",
    "America/Montevideo",
    "America/Montreal",
    "America/Montserrat",
    "America/Nassau",
    "America/New_York",
    "America/Nipigon",
    "America/Nome",
    "America/Noronha",
    "America/Nuuk",
    "America/Ojinaga",
    "America/Panama",
    "America/Pangnirtung",
    "America/Paramaribo",
    "America/Phoenix",
    "America/Port-au-Prince",
    "America/Port_of_Spain",
    "America/Porto_Acre",
    "America/Porto_Velho",
    "America/Puerto_Rico",
    "America/Punta_Arenas",
    "America/Rainy_River",
    "America/Rankin_Inlet",
    "America/Recife",
    "America/Regina",
    "America/Resolute",
    "America/Rio_Branco",
    "America/Rosario",
    "America/Santa_Isabel",
    "America/Santarem",
    "America/Santiago",
    "America/Santo_Domingo",
    "America/Sao_Paulo",
    "America/Scoresbysund",
    "America/Shiprock",
    "America/Sitka",
    "America/St_Barthelemy",
    "America/St_Johns",
    "America/St_Kitts",
    "America/St_Lucia",
    "America/St_Thomas",
    "America/St_Vincent",
    "America/Swift_Current",
    "America/Tegucigalpa",
    "America/Thule",
    "America/Thunder_Bay",
    "America/Tijuana",
    "America/Toronto",
    "America/Tortola",
    "America/Vancouver",
    "America/Virgin",
    "America/Whitehorse",
    "America/Winnipeg",
    "America/Yakutat",
    "America/Yellowknife",
    "Antarctica/Casey",
    "Antarctica/Davis",
    "Antarctica/DumontDUrville",
    "Antarctica/Macquarie",
    "Antarctica/Mawson",
    "Antarctica/McMurdo",
    "Antarctica/Palmer",
    "Antarctica/Rothera",
    "Antarctica/South_Pole",
    "Antarctica/Syowa",
    "Antarctica/Troll",
    "Antarctica/Vostok",
    "Arctic/Longyearbyen",
    "Asia/Aden",
    "Asia/Almaty",
    "Asia/Amman",
    "Asia/Anadyr",
    "Asia/Aqtau",
    "Asia/Aqtobe",
    "Asia/Ashgabat",
    "Asia/Ashkhabad",
    "Asia/Atyrau",
    "Asia/Baghdad",
    "Asia/Bahrain",
    "Asia/Baku",
    "Asia/Bangkok",
    "Asia/Barnaul",
    "Asia/Beirut",
    "Asia/Bishkek",
    "Asia/Brunei",
    "Asia/Calcutta",
    "Asia/Chita",
    "Asia/Choibalsan",
    "Asia/Chongqing",
    "Asia/Chungking",
    "Asia/Colombo",
    "Asia/Dacca",
    "Asia/Damascus",
    "Asia/Dhaka",
    "Asia/Dili",
    "Asia/Dubai",
    "Asia/Dushanbe",
    "Asia/Famagusta",
    "Asia/Gaza",
    "Asia/Harbin",
    "Asia/Hebron",
    "Asia/Ho_Chi_Minh",
    "Asia/Hong_Kong",
    "Asia/Hovd",
    "Asia/Irkutsk",
    "Asia/Istanbul",
    "Asia/Jakarta",
    "Asia/Jayapura",
    "Asia/Jerusalem",
    "Asia/Kabul",
    "Asia/Kamchatka",
    "Asia/Karachi",
    "Asia/Kashgar",
    "Asia/Kathmandu",
    "Asia/Katmandu",
    "Asia/Khandyga",
    "Asia/Kolkata",
    "Asia/Krasnoyarsk",
    "Asia/Kuala_Lumpur",
    "Asia/Kuching",
    "Asia/Kuwait",
    "Asia/Macao",
    "Asia/Macau",
    "Asia/Magadan",
    "Asia/Makassar",
    "Asia/Manila",
    "Asia/Muscat",
    "Asia/Nicosia",
    "Asia/Novokuznetsk",
    "Asia/Novosibirsk",
    "Asia/Omsk",
    "Asia/Oral",
    "Asia/Phnom_Penh",
    "Asia/Pontianak",
    "Asia/Pyongyang",
    "Asia/Qatar",
    "Asia/Qostanay",
    "Asia/Qyzylorda",
    "Asia/Rangoon",
    "Asia/Riyadh",
    "Asia/Saigon",
    "Asia/Sakhalin",
    "Asia/Samarkand",
    "Asia/Seoul",
    "Asia/Shanghai",
    "Asia/Singapore",
    "Asia/Srednekolymsk",
    "Asia/Taipei",
    "Asia/Tashkent",
    "Asia/Tbilisi",
    "Asia/Tehran",
    "Asia/Tel_Aviv",
    "Asia/Thimbu",
    "Asia/Thimphu",
    "Asia/Tokyo",
    "Asia/Tomsk",
    "Asia/Ujung_Pandang",
    "Asia/Ulaanbaatar",
    "Asia/Ulan_Bator",
    "Asia/Urumqi",
    "Asia/Ust-Nera",
    "Asia/Vientiane",
    "Asia/Vladivostok",
    "Asia/Yakutsk",
    "Asia/Yangon",
    "Asia/Yekaterinburg",
    "Asia/Yerevan",
    "Atlantic/Azores",
    "Atlantic/Bermuda",
    "Atlantic/Canary",
    "Atlantic/Cape_Verde",
    "Atlantic/Faeroe",
    "Atlantic/Faroe",
    "Atlantic/Jan_Mayen",
    "Atlantic/Madeira",
    "Atlantic/Reykjavik",
    "Atlantic/South_Georgia",
    "Atlantic/St_Helena",
    "Atlantic/Stanley",
    "Australia/ACT",
    "Australia/Adelaide",
    "Australia/Brisbane",
    "Australia/Broken_Hill",
    "Australia/Canberra",
    "Australia/Currie",
    "Australia/Darwin",
    "Australia/Eucla",
    "Australia/Hobart",
    "Australia/LHI",
    "Australia/Lindeman",
    "Australia/Lord_Howe",
    "Australia/Melbourne",
    "Australia/North",
    "Australia/NSW",
    "Australia/Perth",
    "Australia/Queensland",
    "Australia/South",
    "Australia/Sydney",
    "Australia/Tasmania",
    "Australia/Victoria",
    "Australia/West",
    "Australia/Yancowinna",
    "Brazil/Acre",
    "Brazil/DeNoronha",
    "Brazil/East",
    "Brazil/West",
    "Canada/Atlantic",
    "Canada/Central",
    "Canada/Eastern",
    "Canada/Mountain",
    "Canada/Newfoundland",
    "Canada/Pacific",
    "Canada/Saskatchewan",
    "Canada/Yukon",
    "CET",
    "Chile/Continental",
    "Chile/EasterIsland",
    "CST6CDT",
    "Cuba",
    "EET",
    "Egypt",
    "Eire",
    "EST",
    "EST5EDT",
    "Etc/GMT",
    "Etc/GMT+0",
    "Etc/GMT+1",
    "Etc/GMT+10",
    "Etc/GMT+11",
    "Etc/GMT+12",
    "Etc/GMT+2",
    "Etc/GMT+3",
    "Etc/GMT+4",
    "Etc/GMT+5",
    "Etc/GMT+6",
    "Etc/GMT+7",
    "Etc/GMT+8",
    "Etc/GMT+9",
    "Etc/GMT-0",
    "Etc/GMT-1",
    "Etc/GMT-10",
    "Etc/GMT-11",
    "Etc/GMT-12",
    "Etc/GMT-13",
    "Etc/GMT-14",
    "Etc/GMT-2",
    "Etc/GMT-3",
    "Etc/GMT-4",
    "Etc/GMT-5",
    "Etc/GMT-6",
    "Etc/GMT-7",
    "Etc/GMT-8",
    "Etc/GMT-9",
    "Etc/GMT0",
    "Etc/Greenwich",
    "Etc/UCT",
    "Etc/Universal",
    "Etc/UTC",
    "Etc/Zulu",
    "Europe/Amsterdam",
    "Europe/Andorra",
    "Europe/Astrakhan",
    "Europe/Athens",
    "Europe/Belfast",
    "Europe/Belgrade",
    "Europe/Berlin",
    "Europe/Bratislava",
    "Europe/Brussels",
    "Europe/Bucharest",
    "Europe/Budapest",
    "Europe/Busingen",
    "Europe/Chisinau",
    "Europe/Copenhagen",
    "Europe/Dublin",
    "Europe/Gibraltar",
    "Europe/Guernsey",
    "Europe/Helsinki",
    "Europe/Isle_of_Man",
    "Europe/Istanbul",
    "Europe/Jersey",
    "Europe/Kaliningrad",
    "Europe/Kiev",
    "Europe/Kirov",
    "Europe/Lisbon",
    "Europe/Ljubljana",
    "Europe/London",
    "Europe/Luxembourg",
    "Europe/Madrid",
    "Europe/Malta",
    "Europe/Mariehamn",
    "Europe/Minsk",
    "Europe/Monaco",
    "Europe/Moscow",
    "Europe/Nicosia",
    "Europe/Oslo",
    "Europe/Paris",
    "Europe/Podgorica",
    "Europe/Prague",
    "Europe/Riga",
    "Europe/Rome",
    "Europe/Samara",
    "Europe/San_Marino",
    "Europe/Sarajevo",
    "Europe/Saratov",
    "Europe/Simferopol",
    "Europe/Skopje",
    "Europe/Sofia",
    "Europe/Stockholm",
    "Europe/Tallinn",
    "Europe/Tirane",
    "Europe/Tiraspol",
    "Europe/Ulyanovsk",
    "Europe/Uzhgorod",
    "Europe/Vaduz",
    "Europe/Vatican",
    "Europe/Vienna",
    "Europe/Vilnius",
    "Europe/Volgograd",
    "Europe/Warsaw",
    "Europe/Zagreb",
    "Europe/Zaporozhye",
    "Europe/Zurich",
    "Factory",
    "GB",
    "GB-Eire",
    "GMT",
    "GMT+0",
    "GMT-0",
    "GMT0",
    "Greenwich",
    "Hongkong",
    "HST",
    "Iceland",
    "Indian/Antananarivo",
    "Indian/Chagos",
    "Indian/Christmas",
    "Indian/Cocos",
    "Indian/Comoro",
    "Indian/Kerguelen",
    "Indian/Mahe",
    "Indian/Maldives",
    "Indian/Mauritius",
    "Indian/Mayotte",
    "Indian/Reunion",
    "Iran",
    "Israel",
    "Jamaica",
    "Japan",
    "Kwajalein",
    "Libya",
    "MET",
    "Mexico/BajaNorte",
    "Mexico/BajaSur",
    "Mexico/General",
    "MST",
    "MST7MDT",
    "Navajo",
    "NZ",
    "NZ-CHAT",
    "Pacific/Apia",
    "Pacific/Auckland",
    "Pacific/Bougainville",
    "Pacific/Chatham",
    "Pacific/Chuuk",
    "Pacific/Easter",
    "Pacific/Efate",
    "Pacific/Enderbury",
    "Pacific/Fakaofo",
    "Pacific/Fiji",
    "Pacific/Funafuti",
    "Pacific/Galapagos",
    "Pacific/Gambier",
    "Pacific/Guadalcanal",
    "Pacific/Guam",
    "Pacific/Honolulu",
    "Pacific/Johnston",
    "Pacific/Kanton",
    "Pacific/Kiritimati",
    "Pacific/Kosrae",
    "Pacific/Kwajalein",
    "Pacific/Majuro",
    "Pacific/Marquesas",
    "Pacific/Midway",
    "Pacific/Nauru",
    "Pacific/Niue",
    "Pacific/Norfolk",
    "Pacific/Noumea",
    "Pacific/Pago_Pago",
    "Pacific/Palau",
    "Pacific/Pitcairn",
    "Pacific/Pohnpei",
    "Pacific/Ponape",
    "Pacific/Port_Moresby",
    "Pacific/Rarotonga",
    "Pacific/Saipan",
    "Pacific/Samoa",
    "Pacific/Tahiti",
    "Pacific/Tarawa",
    "Pacific/Tongatapu",
    "Pacific/Truk",
    "Pacific/Wake",
    "Pacific/Wallis",
    "Pacific/Yap",
    "Poland",
    "Portugal",
    "PRC",
    "PST8PDT",
    "ROC",
    "ROK",
    "Singapore",
    "Turkey",
    "UCT",
    "Universal",
    "US/Alaska",
    "US/Aleutian",
    "US/Arizona",
    "US/Central",
    "US/East-Indiana",
    "US/Eastern",
    "US/Hawaii",
    "US/Indiana-Starke",
    "US/Michigan",
    "US/Mountain",
    "US/Pacific",
    "US/Samoa",
    "UTC",
    "W-SU",
    "WET",
    "Zulu",
];

mod tzdata {
    use tz::timezone::*;

    pub(crate) const AFRICA_ABIDJAN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1830383032, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(-968, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_ADDIS_ABABA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1946168836, 1),
            Transition::new(-1309746600, 2),
            Transition::new(-1261969200, 1),
            Transition::new(-1041388200, 3),
            Transition::new(-865305900, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(8836, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(9000, false, Some(b"+0230")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(9900, false, Some(b"+0245")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_ALGIERS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2486592732, 1),
            Transition::new(-1855958961, 3),
            Transition::new(-1689814800, 2),
            Transition::new(-1680397200, 3),
            Transition::new(-1665363600, 2),
            Transition::new(-1648342800, 3),
            Transition::new(-1635123600, 2),
            Transition::new(-1616893200, 3),
            Transition::new(-1604278800, 2),
            Transition::new(-1585443600, 3),
            Transition::new(-1574038800, 2),
            Transition::new(-1552266000, 3),
            Transition::new(-1539997200, 2),
            Transition::new(-1531443600, 3),
            Transition::new(-956365200, 2),
            Transition::new(-950486400, 3),
            Transition::new(-942012000, 5),
            Transition::new(-812502000, 4),
            Transition::new(-796262400, 5),
            Transition::new(-781052400, 4),
            Transition::new(-766630800, 5),
            Transition::new(-733280400, 3),
            Transition::new(-439430400, 5),
            Transition::new(-212029200, 3),
            Transition::new(41468400, 2),
            Transition::new(54774000, 3),
            Transition::new(231724800, 2),
            Transition::new(246236400, 5),
            Transition::new(259545600, 4),
            Transition::new(275274000, 5),
            Transition::new(309740400, 3),
            Transition::new(325468800, 2),
            Transition::new(341802000, 3),
            Transition::new(357523200, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(732, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(561, false, Some(b"PMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, true, Some(b"WEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"WET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, true, Some(b"CEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"CET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"CET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_BANGUI: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2035584815, 1),
            Transition::new(-1940889600, 0),
            Transition::new(-1767226415, 2),
            Transition::new(-1588465800, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(815, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(1800, false, Some(b"+0030")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_BISSAU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1830380400, 1),
            Transition::new(157770000, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-3740, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_BLANTYRE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-2109291020, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(7820, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_CASABLANCA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1773012580, 2),
            Transition::new(-956361600, 1),
            Transition::new(-950490000, 2),
            Transition::new(-942019200, 1),
            Transition::new(-761187600, 2),
            Transition::new(-617241600, 1),
            Transition::new(-605149200, 2),
            Transition::new(-81432000, 1),
            Transition::new(-71110800, 2),
            Transition::new(141264000, 1),
            Transition::new(147222000, 2),
            Transition::new(199756800, 1),
            Transition::new(207702000, 2),
            Transition::new(231292800, 1),
            Transition::new(244249200, 2),
            Transition::new(265507200, 1),
            Transition::new(271033200, 2),
            Transition::new(448243200, 3),
            Transition::new(504918000, 2),
            Transition::new(1212278400, 1),
            Transition::new(1220223600, 2),
            Transition::new(1243814400, 1),
            Transition::new(1250809200, 2),
            Transition::new(1272758400, 1),
            Transition::new(1281222000, 2),
            Transition::new(1301788800, 1),
            Transition::new(1312066800, 2),
            Transition::new(1335664800, 1),
            Transition::new(1342749600, 2),
            Transition::new(1345428000, 1),
            Transition::new(1348970400, 2),
            Transition::new(1367114400, 1),
            Transition::new(1373162400, 2),
            Transition::new(1376100000, 1),
            Transition::new(1382839200, 2),
            Transition::new(1396144800, 1),
            Transition::new(1403920800, 2),
            Transition::new(1406944800, 1),
            Transition::new(1414288800, 2),
            Transition::new(1427594400, 1),
            Transition::new(1434247200, 2),
            Transition::new(1437271200, 1),
            Transition::new(1445738400, 2),
            Transition::new(1459044000, 1),
            Transition::new(1465092000, 2),
            Transition::new(1468116000, 1),
            Transition::new(1477792800, 2),
            Transition::new(1490493600, 1),
            Transition::new(1495332000, 2),
            Transition::new(1498960800, 1),
            Transition::new(1509242400, 2),
            Transition::new(1521943200, 1),
            Transition::new(1526176800, 2),
            Transition::new(1529200800, 1),
            Transition::new(1540692000, 3),
            Transition::new(1557021600, 4),
            Transition::new(1560045600, 3),
            Transition::new(1587261600, 4),
            Transition::new(1590890400, 3),
            Transition::new(1618106400, 4),
            Transition::new(1621130400, 3),
            Transition::new(1648346400, 4),
            Transition::new(1651975200, 3),
            Transition::new(1679191200, 4),
            Transition::new(1682820000, 3),
            Transition::new(1710036000, 4),
            Transition::new(1713060000, 3),
            Transition::new(1740276000, 4),
            Transition::new(1743904800, 3),
            Transition::new(1771120800, 4),
            Transition::new(1774144800, 3),
            Transition::new(1801965600, 4),
            Transition::new(1804989600, 3),
            Transition::new(1832205600, 4),
            Transition::new(1835834400, 3),
            Transition::new(1863050400, 4),
            Transition::new(1866074400, 3),
            Transition::new(1893290400, 4),
            Transition::new(1896919200, 3),
            Transition::new(1924135200, 4),
            Transition::new(1927764000, 3),
            Transition::new(1954980000, 4),
            Transition::new(1958004000, 3),
            Transition::new(1985220000, 4),
            Transition::new(1988848800, 3),
            Transition::new(2016064800, 4),
            Transition::new(2019088800, 3),
            Transition::new(2046304800, 4),
            Transition::new(2049933600, 3),
            Transition::new(2077149600, 4),
            Transition::new(2080778400, 3),
            Transition::new(2107994400, 4),
            Transition::new(2111018400, 3),
            Transition::new(2138234400, 4),
            Transition::new(2141863200, 3),
            Transition::new(2169079200, 4),
            Transition::new(2172708000, 3),
            Transition::new(2199924000, 4),
            Transition::new(2202948000, 3),
            Transition::new(2230164000, 4),
            Transition::new(2233792800, 3),
            Transition::new(2261008800, 4),
            Transition::new(2264032800, 3),
            Transition::new(2291248800, 4),
            Transition::new(2294877600, 3),
            Transition::new(2322093600, 4),
            Transition::new(2325722400, 3),
            Transition::new(2352938400, 4),
            Transition::new(2355962400, 3),
            Transition::new(2383178400, 4),
            Transition::new(2386807200, 3),
            Transition::new(2414023200, 4),
            Transition::new(2417652000, 3),
            Transition::new(2444868000, 4),
            Transition::new(2447892000, 3),
            Transition::new(2475108000, 4),
            Transition::new(2478736800, 3),
            Transition::new(2505952800, 4),
            Transition::new(2508976800, 3),
            Transition::new(2536192800, 4),
            Transition::new(2539821600, 3),
            Transition::new(2567037600, 4),
            Transition::new(2570666400, 3),
            Transition::new(2597882400, 4),
            Transition::new(2600906400, 3),
            Transition::new(2628122400, 4),
            Transition::new(2631751200, 3),
            Transition::new(2658967200, 4),
            Transition::new(2662596000, 3),
            Transition::new(2689812000, 4),
            Transition::new(2692836000, 3),
            Transition::new(2720052000, 4),
            Transition::new(2723680800, 3),
            Transition::new(2750896800, 4),
            Transition::new(2753920800, 3),
            Transition::new(2781136800, 4),
            Transition::new(2784765600, 3),
            Transition::new(2811981600, 4),
            Transition::new(2815610400, 3),
            Transition::new(2842826400, 4),
            Transition::new(2845850400, 3),
            Transition::new(2873066400, 4),
            Transition::new(2876695200, 3),
            Transition::new(2903911200, 4),
            Transition::new(2907540000, 3),
            Transition::new(2934756000, 4),
            Transition::new(2937780000, 3),
            Transition::new(2964996000, 4),
            Transition::new(2968624800, 3),
            Transition::new(2995840800, 4),
            Transition::new(2998864800, 3),
            Transition::new(3026080800, 4),
            Transition::new(3029709600, 3),
            Transition::new(3056925600, 4),
            Transition::new(3060554400, 3),
            Transition::new(3087770400, 4),
            Transition::new(3090794400, 3),
            Transition::new(3118010400, 4),
            Transition::new(3121639200, 3),
            Transition::new(3148855200, 4),
            Transition::new(3152484000, 3),
            Transition::new(3179700000, 4),
            Transition::new(3182724000, 3),
            Transition::new(3209940000, 4),
            Transition::new(3213568800, 3),
            Transition::new(3240784800, 4),
            Transition::new(3243808800, 3),
            Transition::new(3271024800, 4),
            Transition::new(3274653600, 3),
            Transition::new(3301869600, 4),
            Transition::new(3305498400, 3),
            Transition::new(3332714400, 4),
            Transition::new(3335738400, 3),
            Transition::new(3362954400, 4),
            Transition::new(3366583200, 3),
            Transition::new(3393799200, 4),
            Transition::new(3397428000, 3),
            Transition::new(3424644000, 4),
            Transition::new(3427668000, 3),
            Transition::new(3454884000, 4),
            Transition::new(3458512800, 3),
            Transition::new(3485728800, 4),
            Transition::new(3488752800, 3),
            Transition::new(3515968800, 4),
            Transition::new(3519597600, 3),
            Transition::new(3546813600, 4),
            Transition::new(3550442400, 3),
            Transition::new(3577658400, 4),
            Transition::new(3580682400, 3),
            Transition::new(3607898400, 4),
            Transition::new(3611527200, 3),
            Transition::new(3638743200, 4),
            Transition::new(3642372000, 3),
            Transition::new(3669588000, 4),
            Transition::new(3672612000, 3),
            Transition::new(3699828000, 4),
            Transition::new(3703456800, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-1820, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, true, Some(b"+01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"+00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"+01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, true, Some(b"+00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"+01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_CEUTA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2177452800, 1),
            Transition::new(-1630112400, 2),
            Transition::new(-1616810400, 1),
            Transition::new(-1442451600, 2),
            Transition::new(-1427673600, 1),
            Transition::new(-1379293200, 2),
            Transition::new(-1364774400, 1),
            Transition::new(-1348448400, 2),
            Transition::new(-1333324800, 1),
            Transition::new(-1316390400, 2),
            Transition::new(-1301270400, 1),
            Transition::new(-81432000, 2),
            Transition::new(-71110800, 1),
            Transition::new(141264000, 2),
            Transition::new(147222000, 1),
            Transition::new(199756800, 2),
            Transition::new(207702000, 1),
            Transition::new(231292800, 2),
            Transition::new(244249200, 1),
            Transition::new(265507200, 2),
            Transition::new(271033200, 1),
            Transition::new(448243200, 3),
            Transition::new(512528400, 4),
            Transition::new(528253200, 3),
            Transition::new(543978000, 4),
            Transition::new(559702800, 3),
            Transition::new(575427600, 4),
            Transition::new(591152400, 3),
            Transition::new(606877200, 4),
            Transition::new(622602000, 3),
            Transition::new(638326800, 4),
            Transition::new(654656400, 3),
            Transition::new(670381200, 4),
            Transition::new(686106000, 3),
            Transition::new(701830800, 4),
            Transition::new(717555600, 3),
            Transition::new(733280400, 4),
            Transition::new(749005200, 3),
            Transition::new(764730000, 4),
            Transition::new(780454800, 3),
            Transition::new(796179600, 4),
            Transition::new(811904400, 3),
            Transition::new(828234000, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-1276, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"WET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, true, Some(b"WEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"CET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, true, Some(b"CEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(3600, false, Some(b"CET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(7200, true, Some(b"CEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_EL_AAIUN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1136070432, 1),
            Transition::new(198291600, 3),
            Transition::new(199756800, 2),
            Transition::new(207702000, 3),
            Transition::new(231292800, 2),
            Transition::new(244249200, 3),
            Transition::new(265507200, 2),
            Transition::new(271033200, 3),
            Transition::new(1212278400, 2),
            Transition::new(1220223600, 3),
            Transition::new(1243814400, 2),
            Transition::new(1250809200, 3),
            Transition::new(1272758400, 2),
            Transition::new(1281222000, 3),
            Transition::new(1301788800, 2),
            Transition::new(1312066800, 3),
            Transition::new(1335664800, 2),
            Transition::new(1342749600, 3),
            Transition::new(1345428000, 2),
            Transition::new(1348970400, 3),
            Transition::new(1367114400, 2),
            Transition::new(1373162400, 3),
            Transition::new(1376100000, 2),
            Transition::new(1382839200, 3),
            Transition::new(1396144800, 2),
            Transition::new(1403920800, 3),
            Transition::new(1406944800, 2),
            Transition::new(1414288800, 3),
            Transition::new(1427594400, 2),
            Transition::new(1434247200, 3),
            Transition::new(1437271200, 2),
            Transition::new(1445738400, 3),
            Transition::new(1459044000, 2),
            Transition::new(1465092000, 3),
            Transition::new(1468116000, 2),
            Transition::new(1477792800, 3),
            Transition::new(1490493600, 2),
            Transition::new(1495332000, 3),
            Transition::new(1498960800, 2),
            Transition::new(1509242400, 3),
            Transition::new(1521943200, 2),
            Transition::new(1526176800, 3),
            Transition::new(1529200800, 2),
            Transition::new(1540692000, 5),
            Transition::new(1557021600, 4),
            Transition::new(1560045600, 5),
            Transition::new(1587261600, 4),
            Transition::new(1590890400, 5),
            Transition::new(1618106400, 4),
            Transition::new(1621130400, 5),
            Transition::new(1648346400, 4),
            Transition::new(1651975200, 5),
            Transition::new(1679191200, 4),
            Transition::new(1682820000, 5),
            Transition::new(1710036000, 4),
            Transition::new(1713060000, 5),
            Transition::new(1740276000, 4),
            Transition::new(1743904800, 5),
            Transition::new(1771120800, 4),
            Transition::new(1774144800, 5),
            Transition::new(1801965600, 4),
            Transition::new(1804989600, 5),
            Transition::new(1832205600, 4),
            Transition::new(1835834400, 5),
            Transition::new(1863050400, 4),
            Transition::new(1866074400, 5),
            Transition::new(1893290400, 4),
            Transition::new(1896919200, 5),
            Transition::new(1924135200, 4),
            Transition::new(1927764000, 5),
            Transition::new(1954980000, 4),
            Transition::new(1958004000, 5),
            Transition::new(1985220000, 4),
            Transition::new(1988848800, 5),
            Transition::new(2016064800, 4),
            Transition::new(2019088800, 5),
            Transition::new(2046304800, 4),
            Transition::new(2049933600, 5),
            Transition::new(2077149600, 4),
            Transition::new(2080778400, 5),
            Transition::new(2107994400, 4),
            Transition::new(2111018400, 5),
            Transition::new(2138234400, 4),
            Transition::new(2141863200, 5),
            Transition::new(2169079200, 4),
            Transition::new(2172708000, 5),
            Transition::new(2199924000, 4),
            Transition::new(2202948000, 5),
            Transition::new(2230164000, 4),
            Transition::new(2233792800, 5),
            Transition::new(2261008800, 4),
            Transition::new(2264032800, 5),
            Transition::new(2291248800, 4),
            Transition::new(2294877600, 5),
            Transition::new(2322093600, 4),
            Transition::new(2325722400, 5),
            Transition::new(2352938400, 4),
            Transition::new(2355962400, 5),
            Transition::new(2383178400, 4),
            Transition::new(2386807200, 5),
            Transition::new(2414023200, 4),
            Transition::new(2417652000, 5),
            Transition::new(2444868000, 4),
            Transition::new(2447892000, 5),
            Transition::new(2475108000, 4),
            Transition::new(2478736800, 5),
            Transition::new(2505952800, 4),
            Transition::new(2508976800, 5),
            Transition::new(2536192800, 4),
            Transition::new(2539821600, 5),
            Transition::new(2567037600, 4),
            Transition::new(2570666400, 5),
            Transition::new(2597882400, 4),
            Transition::new(2600906400, 5),
            Transition::new(2628122400, 4),
            Transition::new(2631751200, 5),
            Transition::new(2658967200, 4),
            Transition::new(2662596000, 5),
            Transition::new(2689812000, 4),
            Transition::new(2692836000, 5),
            Transition::new(2720052000, 4),
            Transition::new(2723680800, 5),
            Transition::new(2750896800, 4),
            Transition::new(2753920800, 5),
            Transition::new(2781136800, 4),
            Transition::new(2784765600, 5),
            Transition::new(2811981600, 4),
            Transition::new(2815610400, 5),
            Transition::new(2842826400, 4),
            Transition::new(2845850400, 5),
            Transition::new(2873066400, 4),
            Transition::new(2876695200, 5),
            Transition::new(2903911200, 4),
            Transition::new(2907540000, 5),
            Transition::new(2934756000, 4),
            Transition::new(2937780000, 5),
            Transition::new(2964996000, 4),
            Transition::new(2968624800, 5),
            Transition::new(2995840800, 4),
            Transition::new(2998864800, 5),
            Transition::new(3026080800, 4),
            Transition::new(3029709600, 5),
            Transition::new(3056925600, 4),
            Transition::new(3060554400, 5),
            Transition::new(3087770400, 4),
            Transition::new(3090794400, 5),
            Transition::new(3118010400, 4),
            Transition::new(3121639200, 5),
            Transition::new(3148855200, 4),
            Transition::new(3152484000, 5),
            Transition::new(3179700000, 4),
            Transition::new(3182724000, 5),
            Transition::new(3209940000, 4),
            Transition::new(3213568800, 5),
            Transition::new(3240784800, 4),
            Transition::new(3243808800, 5),
            Transition::new(3271024800, 4),
            Transition::new(3274653600, 5),
            Transition::new(3301869600, 4),
            Transition::new(3305498400, 5),
            Transition::new(3332714400, 4),
            Transition::new(3335738400, 5),
            Transition::new(3362954400, 4),
            Transition::new(3366583200, 5),
            Transition::new(3393799200, 4),
            Transition::new(3397428000, 5),
            Transition::new(3424644000, 4),
            Transition::new(3427668000, 5),
            Transition::new(3454884000, 4),
            Transition::new(3458512800, 5),
            Transition::new(3485728800, 4),
            Transition::new(3488752800, 5),
            Transition::new(3515968800, 4),
            Transition::new(3519597600, 5),
            Transition::new(3546813600, 4),
            Transition::new(3550442400, 5),
            Transition::new(3577658400, 4),
            Transition::new(3580682400, 5),
            Transition::new(3607898400, 4),
            Transition::new(3611527200, 5),
            Transition::new(3638743200, 4),
            Transition::new(3642372000, 5),
            Transition::new(3669588000, 4),
            Transition::new(3672612000, 5),
            Transition::new(3699828000, 4),
            Transition::new(3703456800, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-3168, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, true, Some(b"+01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"+00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, true, Some(b"+00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"+01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"+01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_JOHANNESBURG: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2458173120, 1),
            Transition::new(-2109288600, 3),
            Transition::new(-860976000, 2),
            Transition::new(-845254800, 3),
            Transition::new(-829526400, 2),
            Transition::new(-813805200, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(6720, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(5400, false, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_JUBA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1230775588, 2),
            Transition::new(10360800, 1),
            Transition::new(24786000, 2),
            Transition::new(41810400, 1),
            Transition::new(56322000, 2),
            Transition::new(73432800, 1),
            Transition::new(87944400, 2),
            Transition::new(104882400, 1),
            Transition::new(119480400, 2),
            Transition::new(136332000, 1),
            Transition::new(151016400, 2),
            Transition::new(167781600, 1),
            Transition::new(182552400, 2),
            Transition::new(199231200, 1),
            Transition::new(214174800, 2),
            Transition::new(230680800, 1),
            Transition::new(245710800, 2),
            Transition::new(262735200, 1),
            Transition::new(277246800, 2),
            Transition::new(294184800, 1),
            Transition::new(308782800, 2),
            Transition::new(325634400, 1),
            Transition::new(340405200, 2),
            Transition::new(357084000, 1),
            Transition::new(371941200, 2),
            Transition::new(388533600, 1),
            Transition::new(403477200, 2),
            Transition::new(419983200, 1),
            Transition::new(435013200, 2),
            Transition::new(452037600, 1),
            Transition::new(466635600, 2),
            Transition::new(483487200, 1),
            Transition::new(498171600, 2),
            Transition::new(947930400, 3),
            Transition::new(1612126800, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(7588, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"CAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_KHARTOUM: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1230775808, 2),
            Transition::new(10360800, 1),
            Transition::new(24786000, 2),
            Transition::new(41810400, 1),
            Transition::new(56322000, 2),
            Transition::new(73432800, 1),
            Transition::new(87944400, 2),
            Transition::new(104882400, 1),
            Transition::new(119480400, 2),
            Transition::new(136332000, 1),
            Transition::new(151016400, 2),
            Transition::new(167781600, 1),
            Transition::new(182552400, 2),
            Transition::new(199231200, 1),
            Transition::new(214174800, 2),
            Transition::new(230680800, 1),
            Transition::new(245710800, 2),
            Transition::new(262735200, 1),
            Transition::new(277246800, 2),
            Transition::new(294184800, 1),
            Transition::new(308782800, 2),
            Transition::new(325634400, 1),
            Transition::new(340405200, 2),
            Transition::new(357084000, 1),
            Transition::new(371941200, 2),
            Transition::new(388533600, 1),
            Transition::new(403477200, 2),
            Transition::new(419983200, 1),
            Transition::new(435013200, 2),
            Transition::new(452037600, 1),
            Transition::new(466635600, 2),
            Transition::new(483487200, 1),
            Transition::new(498171600, 2),
            Transition::new(947930400, 3),
            Transition::new(1509483600, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(7808, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"CAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"EAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_MONROVIA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2776979812, 1),
            Transition::new(-1604359012, 2),
            Transition::new(63593070, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-2588, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-2588, false, Some(b"MMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-2670, false, Some(b"MMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_NDJAMENA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1830387612, 1),
            Transition::new(308703600, 2),
            Transition::new(321314400, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(3612, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, true, Some(b"WAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_SAO_TOME: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713912016, 1),
            Transition::new(-1830384000, 2),
            Transition::new(1514768400, 3),
            Transition::new(1546304400, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(1616, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-2205, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_TUNIS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2797202444, 1),
            Transition::new(-1855958961, 3),
            Transition::new(-969242400, 2),
            Transition::new(-950493600, 3),
            Transition::new(-941940000, 2),
            Transition::new(-891136800, 3),
            Transition::new(-877827600, 2),
            Transition::new(-857257200, 3),
            Transition::new(-844556400, 2),
            Transition::new(-842918400, 3),
            Transition::new(-842223600, 2),
            Transition::new(-828230400, 3),
            Transition::new(-812502000, 2),
            Transition::new(-796269600, 3),
            Transition::new(-781052400, 2),
            Transition::new(-766634400, 3),
            Transition::new(231202800, 2),
            Transition::new(243903600, 3),
            Transition::new(262825200, 2),
            Transition::new(276044400, 3),
            Transition::new(581122800, 2),
            Transition::new(591145200, 3),
            Transition::new(606870000, 2),
            Transition::new(622594800, 3),
            Transition::new(641516400, 2),
            Transition::new(654649200, 3),
            Transition::new(1114902000, 2),
            Transition::new(1128038400, 3),
            Transition::new(1143334800, 2),
            Transition::new(1162083600, 3),
            Transition::new(1174784400, 2),
            Transition::new(1193533200, 3),
            Transition::new(1206838800, 2),
            Transition::new(1224982800, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(2444, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(561, false, Some(b"PMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, true, Some(b"CEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"CET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(3600, false, Some(b"CET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AFRICA_WINDHOEK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2458170504, 1),
            Transition::new(-2109288600, 2),
            Transition::new(-860976000, 3),
            Transition::new(-845254800, 2),
            Transition::new(637970400, 5),
            Transition::new(764200800, 4),
            Transition::new(778640400, 5),
            Transition::new(796780800, 4),
            Transition::new(810090000, 5),
            Transition::new(828835200, 4),
            Transition::new(841539600, 5),
            Transition::new(860284800, 4),
            Transition::new(873594000, 5),
            Transition::new(891734400, 4),
            Transition::new(905043600, 5),
            Transition::new(923184000, 4),
            Transition::new(936493200, 5),
            Transition::new(954633600, 4),
            Transition::new(967942800, 5),
            Transition::new(986083200, 4),
            Transition::new(999392400, 5),
            Transition::new(1018137600, 4),
            Transition::new(1030842000, 5),
            Transition::new(1049587200, 4),
            Transition::new(1062896400, 5),
            Transition::new(1081036800, 4),
            Transition::new(1094346000, 5),
            Transition::new(1112486400, 4),
            Transition::new(1125795600, 5),
            Transition::new(1143936000, 4),
            Transition::new(1157245200, 5),
            Transition::new(1175385600, 4),
            Transition::new(1188694800, 5),
            Transition::new(1207440000, 4),
            Transition::new(1220749200, 5),
            Transition::new(1238889600, 4),
            Transition::new(1252198800, 5),
            Transition::new(1270339200, 4),
            Transition::new(1283648400, 5),
            Transition::new(1301788800, 4),
            Transition::new(1315098000, 5),
            Transition::new(1333238400, 4),
            Transition::new(1346547600, 5),
            Transition::new(1365292800, 4),
            Transition::new(1377997200, 5),
            Transition::new(1396742400, 4),
            Transition::new(1410051600, 5),
            Transition::new(1428192000, 4),
            Transition::new(1441501200, 5),
            Transition::new(1459641600, 4),
            Transition::new(1472950800, 5),
            Transition::new(1491091200, 4),
            Transition::new(1504400400, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(4104, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(5400, false, Some(b"+0130")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"SAST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, true, Some(b"WAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"CAT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ADAK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3225223727, 1),
            Transition::new(-2188944802, 2),
            Transition::new(-880196400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765374400, 2),
            Transition::new(-86878800, 5),
            Transition::new(-21466800, 6),
            Transition::new(-5745600, 5),
            Transition::new(9982800, 6),
            Transition::new(25704000, 5),
            Transition::new(41432400, 6),
            Transition::new(57758400, 5),
            Transition::new(73486800, 6),
            Transition::new(89208000, 5),
            Transition::new(104936400, 6),
            Transition::new(120657600, 5),
            Transition::new(126709200, 6),
            Transition::new(152107200, 5),
            Transition::new(162392400, 6),
            Transition::new(183556800, 5),
            Transition::new(199285200, 6),
            Transition::new(215611200, 5),
            Transition::new(230734800, 6),
            Transition::new(247060800, 5),
            Transition::new(262789200, 6),
            Transition::new(278510400, 5),
            Transition::new(294238800, 6),
            Transition::new(309960000, 5),
            Transition::new(325688400, 6),
            Transition::new(341409600, 5),
            Transition::new(357138000, 6),
            Transition::new(372859200, 5),
            Transition::new(388587600, 6),
            Transition::new(404913600, 5),
            Transition::new(420037200, 6),
            Transition::new(436363200, 7),
            Transition::new(439034400, 9),
            Transition::new(452088000, 8),
            Transition::new(467809200, 9),
            Transition::new(483537600, 8),
            Transition::new(499258800, 9),
            Transition::new(514987200, 8),
            Transition::new(530708400, 9),
            Transition::new(544622400, 8),
            Transition::new(562158000, 9),
            Transition::new(576072000, 8),
            Transition::new(594212400, 9),
            Transition::new(607521600, 8),
            Transition::new(625662000, 9),
            Transition::new(638971200, 8),
            Transition::new(657111600, 9),
            Transition::new(671025600, 8),
            Transition::new(688561200, 9),
            Transition::new(702475200, 8),
            Transition::new(720010800, 9),
            Transition::new(733924800, 8),
            Transition::new(752065200, 9),
            Transition::new(765374400, 8),
            Transition::new(783514800, 9),
            Transition::new(796824000, 8),
            Transition::new(814964400, 9),
            Transition::new(828878400, 8),
            Transition::new(846414000, 9),
            Transition::new(860328000, 8),
            Transition::new(877863600, 9),
            Transition::new(891777600, 8),
            Transition::new(909313200, 9),
            Transition::new(923227200, 8),
            Transition::new(941367600, 9),
            Transition::new(954676800, 8),
            Transition::new(972817200, 9),
            Transition::new(986126400, 8),
            Transition::new(1004266800, 9),
            Transition::new(1018180800, 8),
            Transition::new(1035716400, 9),
            Transition::new(1049630400, 8),
            Transition::new(1067166000, 9),
            Transition::new(1081080000, 8),
            Transition::new(1099220400, 9),
            Transition::new(1112529600, 8),
            Transition::new(1130670000, 9),
            Transition::new(1143979200, 8),
            Transition::new(1162119600, 9),
            Transition::new(1173614400, 8),
        ],
        &{
            const V: [LocalTimeType; 10] = [
                match LocalTimeType::new(44002, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-42398, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-39600, false, Some(b"NST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, true, Some(b"NWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, true, Some(b"NPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-39600, false, Some(b"BST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, true, Some(b"BDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, false, Some(b"AHST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, true, Some(b"HDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, false, Some(b"HST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-36000, false, Some(b"HST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-32400, true, Some(b"HDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ANCHORAGE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3225223727, 1),
            Transition::new(-2188951224, 2),
            Transition::new(-880200000, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765378000, 2),
            Transition::new(-86882400, 5),
            Transition::new(-21470400, 6),
            Transition::new(-5749200, 5),
            Transition::new(9979200, 6),
            Transition::new(25700400, 5),
            Transition::new(41428800, 6),
            Transition::new(57754800, 5),
            Transition::new(73483200, 6),
            Transition::new(89204400, 5),
            Transition::new(104932800, 6),
            Transition::new(120654000, 5),
            Transition::new(126705600, 6),
            Transition::new(152103600, 5),
            Transition::new(162388800, 6),
            Transition::new(183553200, 5),
            Transition::new(199281600, 6),
            Transition::new(215607600, 5),
            Transition::new(230731200, 6),
            Transition::new(247057200, 5),
            Transition::new(262785600, 6),
            Transition::new(278506800, 5),
            Transition::new(294235200, 6),
            Transition::new(309956400, 5),
            Transition::new(325684800, 6),
            Transition::new(341406000, 5),
            Transition::new(357134400, 6),
            Transition::new(372855600, 5),
            Transition::new(388584000, 6),
            Transition::new(404910000, 5),
            Transition::new(420033600, 6),
            Transition::new(436359600, 7),
            Transition::new(439030800, 9),
            Transition::new(452084400, 8),
            Transition::new(467805600, 9),
            Transition::new(483534000, 8),
            Transition::new(499255200, 9),
            Transition::new(514983600, 8),
            Transition::new(530704800, 9),
            Transition::new(544618800, 8),
            Transition::new(562154400, 9),
            Transition::new(576068400, 8),
            Transition::new(594208800, 9),
            Transition::new(607518000, 8),
            Transition::new(625658400, 9),
            Transition::new(638967600, 8),
            Transition::new(657108000, 9),
            Transition::new(671022000, 8),
            Transition::new(688557600, 9),
            Transition::new(702471600, 8),
            Transition::new(720007200, 9),
            Transition::new(733921200, 8),
            Transition::new(752061600, 9),
            Transition::new(765370800, 8),
            Transition::new(783511200, 9),
            Transition::new(796820400, 8),
            Transition::new(814960800, 9),
            Transition::new(828874800, 8),
            Transition::new(846410400, 9),
            Transition::new(860324400, 8),
            Transition::new(877860000, 9),
            Transition::new(891774000, 8),
            Transition::new(909309600, 9),
            Transition::new(923223600, 8),
            Transition::new(941364000, 9),
            Transition::new(954673200, 8),
            Transition::new(972813600, 9),
            Transition::new(986122800, 8),
            Transition::new(1004263200, 9),
            Transition::new(1018177200, 8),
            Transition::new(1035712800, 9),
            Transition::new(1049626800, 8),
            Transition::new(1067162400, 9),
            Transition::new(1081076400, 8),
            Transition::new(1099216800, 9),
            Transition::new(1112526000, 8),
            Transition::new(1130666400, 9),
            Transition::new(1143975600, 8),
            Transition::new(1162116000, 9),
            Transition::new(1173610800, 8),
        ],
        &{
            const V: [LocalTimeType; 10] = [
                match LocalTimeType::new(50424, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-35976, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, true, Some(b"AWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, true, Some(b"APT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, false, Some(b"AHST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, true, Some(b"AHDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"YST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ANGUILLA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2233035335, 1),
            Transition::new(-873057600, 3),
            Transition::new(-769395600, 2),
            Transition::new(-765399600, 1),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-15865, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"APT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"AWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ARAGUAINA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767214032, 2),
            Transition::new(-1206957600, 1),
            Transition::new(-1191362400, 2),
            Transition::new(-1175374800, 1),
            Transition::new(-1159826400, 2),
            Transition::new(-633819600, 1),
            Transition::new(-622069200, 2),
            Transition::new(-602283600, 1),
            Transition::new(-591832800, 2),
            Transition::new(-570747600, 1),
            Transition::new(-560210400, 2),
            Transition::new(-539125200, 1),
            Transition::new(-531352800, 2),
            Transition::new(-191365200, 1),
            Transition::new(-184197600, 2),
            Transition::new(-155163600, 1),
            Transition::new(-150069600, 2),
            Transition::new(-128898000, 1),
            Transition::new(-121125600, 2),
            Transition::new(-99954000, 1),
            Transition::new(-89589600, 2),
            Transition::new(-68418000, 1),
            Transition::new(-57967200, 2),
            Transition::new(499748400, 1),
            Transition::new(511236000, 2),
            Transition::new(530593200, 1),
            Transition::new(540266400, 2),
            Transition::new(562129200, 1),
            Transition::new(571197600, 2),
            Transition::new(592974000, 1),
            Transition::new(602042400, 2),
            Transition::new(624423600, 1),
            Transition::new(634701600, 2),
            Transition::new(813726000, 1),
            Transition::new(824004000, 2),
            Transition::new(844570800, 1),
            Transition::new(856058400, 2),
            Transition::new(876106800, 1),
            Transition::new(888717600, 2),
            Transition::new(908074800, 1),
            Transition::new(919562400, 2),
            Transition::new(938919600, 1),
            Transition::new(951616800, 2),
            Transition::new(970974000, 1),
            Transition::new(982461600, 2),
            Transition::new(1003028400, 1),
            Transition::new(1013911200, 2),
            Transition::new(1036292400, 1),
            Transition::new(1045360800, 2),
            Transition::new(1350788400, 1),
            Transition::new(1361066400, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-11568, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ASUNCION: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524507760, 1),
            Transition::new(-1206389360, 2),
            Transition::new(86760000, 3),
            Transition::new(134017200, 2),
            Transition::new(181368000, 4),
            Transition::new(194497200, 2),
            Transition::new(212990400, 4),
            Transition::new(226033200, 2),
            Transition::new(244526400, 4),
            Transition::new(257569200, 2),
            Transition::new(276062400, 4),
            Transition::new(291783600, 2),
            Transition::new(307598400, 4),
            Transition::new(323406000, 2),
            Transition::new(339220800, 4),
            Transition::new(354942000, 2),
            Transition::new(370756800, 4),
            Transition::new(386478000, 2),
            Transition::new(402292800, 4),
            Transition::new(418014000, 2),
            Transition::new(433828800, 4),
            Transition::new(449636400, 2),
            Transition::new(465451200, 4),
            Transition::new(481172400, 2),
            Transition::new(496987200, 4),
            Transition::new(512708400, 2),
            Transition::new(528523200, 4),
            Transition::new(544244400, 2),
            Transition::new(560059200, 4),
            Transition::new(575866800, 2),
            Transition::new(591681600, 4),
            Transition::new(607402800, 2),
            Transition::new(625032000, 4),
            Transition::new(638938800, 2),
            Transition::new(654753600, 4),
            Transition::new(670474800, 2),
            Transition::new(686721600, 4),
            Transition::new(699418800, 2),
            Transition::new(718257600, 4),
            Transition::new(733546800, 2),
            Transition::new(749448000, 4),
            Transition::new(762318000, 2),
            Transition::new(780984000, 4),
            Transition::new(793767600, 2),
            Transition::new(812520000, 4),
            Transition::new(825649200, 2),
            Transition::new(844574400, 4),
            Transition::new(856666800, 2),
            Transition::new(876024000, 4),
            Transition::new(888721200, 2),
            Transition::new(907473600, 4),
            Transition::new(920775600, 2),
            Transition::new(938923200, 4),
            Transition::new(952225200, 2),
            Transition::new(970372800, 4),
            Transition::new(983674800, 2),
            Transition::new(1002427200, 4),
            Transition::new(1018148400, 2),
            Transition::new(1030852800, 4),
            Transition::new(1049598000, 2),
            Transition::new(1062907200, 4),
            Transition::new(1081047600, 2),
            Transition::new(1097985600, 4),
            Transition::new(1110682800, 2),
            Transition::new(1129435200, 4),
            Transition::new(1142132400, 2),
            Transition::new(1160884800, 4),
            Transition::new(1173582000, 2),
            Transition::new(1192939200, 4),
            Transition::new(1205031600, 2),
            Transition::new(1224388800, 4),
            Transition::new(1236481200, 2),
            Transition::new(1255838400, 4),
            Transition::new(1270954800, 2),
            Transition::new(1286078400, 4),
            Transition::new(1302404400, 2),
            Transition::new(1317528000, 4),
            Transition::new(1333854000, 2),
            Transition::new(1349582400, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-13840, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-13840, false, Some(b"AMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-14400, false, Some(b"-04")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-10800, true, Some(b"-03")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 4, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ATIKOKAN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524502512, 1),
            Transition::new(-1946918424, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-19088, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-19176, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BAHIA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767216356, 2),
            Transition::new(-1206957600, 1),
            Transition::new(-1191362400, 2),
            Transition::new(-1175374800, 1),
            Transition::new(-1159826400, 2),
            Transition::new(-633819600, 1),
            Transition::new(-622069200, 2),
            Transition::new(-602283600, 1),
            Transition::new(-591832800, 2),
            Transition::new(-570747600, 1),
            Transition::new(-560210400, 2),
            Transition::new(-539125200, 1),
            Transition::new(-531352800, 2),
            Transition::new(-191365200, 1),
            Transition::new(-184197600, 2),
            Transition::new(-155163600, 1),
            Transition::new(-150069600, 2),
            Transition::new(-128898000, 1),
            Transition::new(-121125600, 2),
            Transition::new(-99954000, 1),
            Transition::new(-89589600, 2),
            Transition::new(-68418000, 1),
            Transition::new(-57967200, 2),
            Transition::new(499748400, 1),
            Transition::new(511236000, 2),
            Transition::new(530593200, 1),
            Transition::new(540266400, 2),
            Transition::new(562129200, 1),
            Transition::new(571197600, 2),
            Transition::new(592974000, 1),
            Transition::new(602042400, 2),
            Transition::new(624423600, 1),
            Transition::new(634701600, 2),
            Transition::new(656478000, 1),
            Transition::new(666756000, 2),
            Transition::new(687927600, 1),
            Transition::new(697600800, 2),
            Transition::new(719982000, 1),
            Transition::new(728445600, 2),
            Transition::new(750826800, 1),
            Transition::new(761709600, 2),
            Transition::new(782276400, 1),
            Transition::new(793159200, 2),
            Transition::new(813726000, 1),
            Transition::new(824004000, 2),
            Transition::new(844570800, 1),
            Transition::new(856058400, 2),
            Transition::new(876106800, 1),
            Transition::new(888717600, 2),
            Transition::new(908074800, 1),
            Transition::new(919562400, 2),
            Transition::new(938919600, 1),
            Transition::new(951616800, 2),
            Transition::new(970974000, 1),
            Transition::new(982461600, 2),
            Transition::new(1003028400, 1),
            Transition::new(1013911200, 2),
            Transition::new(1036292400, 1),
            Transition::new(1045360800, 2),
            Transition::new(1318734000, 1),
            Transition::new(1330221600, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-9244, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BAHIA_BANDERAS: TimeZoneRef<'static> =
        match TimeZoneRef::<'static>::new(
            &[
                Transition::new(-1514739600, 1),
                Transition::new(-1343066400, 2),
                Transition::new(-1234807200, 1),
                Transition::new(-1220292000, 2),
                Transition::new(-1207159200, 1),
                Transition::new(-1191344400, 2),
                Transition::new(-873828000, 1),
                Transition::new(-661539600, 3),
                Transition::new(28800, 1),
                Transition::new(828867600, 4),
                Transition::new(846403200, 1),
                Transition::new(860317200, 4),
                Transition::new(877852800, 1),
                Transition::new(891766800, 4),
                Transition::new(909302400, 1),
                Transition::new(923216400, 4),
                Transition::new(941356800, 1),
                Transition::new(954666000, 4),
                Transition::new(972806400, 1),
                Transition::new(989139600, 4),
                Transition::new(1001836800, 1),
                Transition::new(1018170000, 4),
                Transition::new(1035705600, 1),
                Transition::new(1049619600, 4),
                Transition::new(1067155200, 1),
                Transition::new(1081069200, 4),
                Transition::new(1099209600, 1),
                Transition::new(1112518800, 4),
                Transition::new(1130659200, 1),
                Transition::new(1143968400, 4),
                Transition::new(1162108800, 1),
                Transition::new(1175418000, 4),
                Transition::new(1193558400, 1),
                Transition::new(1207472400, 4),
                Transition::new(1225008000, 1),
                Transition::new(1238922000, 4),
                Transition::new(1256457600, 1),
                Transition::new(1270371600, 5),
                Transition::new(1288508400, 2),
            ],
            &{
                const V: [LocalTimeType; 6] = [
                    match LocalTimeType::new(-25260, false, Some(b"LMT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-28800, false, Some(b"PST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                ];
                V
            },
            &[],
            &Some({
                const V: TransitionRule = TransitionRule::Alternate(
                    match AlternateTime::new(
                        match LocalTimeType::new(-21600, false, Some(b"CST")) {
                            Ok(v) => v,
                            Err(e) => panic!("{}", e.0),
                        },
                        match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                            Ok(v) => v,
                            Err(e) => panic!("{}", e.0),
                        },
                        RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                            Ok(v) => v,
                            Err(e) => panic!("{}", e.0),
                        }),
                        7200,
                        RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                            Ok(v) => v,
                            Err(e) => panic!("{}", e.0),
                        }),
                        7200,
                    ) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                );
                V
            }),
        ) {
            Ok(v) => v,
            Err(e) => panic!("{}", e.0),
        };

    pub(crate) const AMERICA_BARBADOS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1841256091, 2),
            Transition::new(-874263600, 1),
            Transition::new(-862682400, 2),
            Transition::new(-841604400, 1),
            Transition::new(-830714400, 2),
            Transition::new(-811882800, 3),
            Transition::new(-798660000, 2),
            Transition::new(234943200, 1),
            Transition::new(244616400, 2),
            Transition::new(261554400, 1),
            Transition::new(276066000, 2),
            Transition::new(293004000, 1),
            Transition::new(307515600, 2),
            Transition::new(325058400, 1),
            Transition::new(338706000, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-14309, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-12600, true, Some(b"-0330")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BELEM: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767213964, 2),
            Transition::new(-1206957600, 1),
            Transition::new(-1191362400, 2),
            Transition::new(-1175374800, 1),
            Transition::new(-1159826400, 2),
            Transition::new(-633819600, 1),
            Transition::new(-622069200, 2),
            Transition::new(-602283600, 1),
            Transition::new(-591832800, 2),
            Transition::new(-570747600, 1),
            Transition::new(-560210400, 2),
            Transition::new(-539125200, 1),
            Transition::new(-531352800, 2),
            Transition::new(-191365200, 1),
            Transition::new(-184197600, 2),
            Transition::new(-155163600, 1),
            Transition::new(-150069600, 2),
            Transition::new(-128898000, 1),
            Transition::new(-121125600, 2),
            Transition::new(-99954000, 1),
            Transition::new(-89589600, 2),
            Transition::new(-68418000, 1),
            Transition::new(-57967200, 2),
            Transition::new(499748400, 1),
            Transition::new(511236000, 2),
            Transition::new(530593200, 1),
            Transition::new(540266400, 2),
            Transition::new(562129200, 1),
            Transition::new(571197600, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-11636, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BELIZE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1822500432, 2),
            Transition::new(-1616954400, 1),
            Transition::new(-1606069800, 2),
            Transition::new(-1585504800, 1),
            Transition::new(-1574015400, 2),
            Transition::new(-1554055200, 1),
            Transition::new(-1542565800, 2),
            Transition::new(-1522605600, 1),
            Transition::new(-1511116200, 2),
            Transition::new(-1490551200, 1),
            Transition::new(-1479666600, 2),
            Transition::new(-1459101600, 1),
            Transition::new(-1448217000, 2),
            Transition::new(-1427652000, 1),
            Transition::new(-1416162600, 2),
            Transition::new(-1396202400, 1),
            Transition::new(-1384713000, 2),
            Transition::new(-1364752800, 1),
            Transition::new(-1353263400, 2),
            Transition::new(-1333303200, 1),
            Transition::new(-1321813800, 2),
            Transition::new(-1301248800, 1),
            Transition::new(-1290364200, 2),
            Transition::new(-1269799200, 1),
            Transition::new(-1258914600, 2),
            Transition::new(-1238349600, 1),
            Transition::new(-1226860200, 2),
            Transition::new(-1206900000, 1),
            Transition::new(-1195410600, 2),
            Transition::new(-1175450400, 1),
            Transition::new(-1163961000, 2),
            Transition::new(-1143396000, 1),
            Transition::new(-1132511400, 2),
            Transition::new(-1111946400, 1),
            Transition::new(-1101061800, 2),
            Transition::new(-1080496800, 1),
            Transition::new(-1069612200, 2),
            Transition::new(-1049047200, 1),
            Transition::new(-1037557800, 2),
            Transition::new(-1017597600, 1),
            Transition::new(-1006108200, 2),
            Transition::new(-986148000, 1),
            Transition::new(-974658600, 2),
            Transition::new(-954093600, 1),
            Transition::new(-943209000, 2),
            Transition::new(-922644000, 1),
            Transition::new(-911759400, 2),
            Transition::new(-891194400, 1),
            Transition::new(-879705000, 2),
            Transition::new(-868212000, 3),
            Transition::new(-769395600, 4),
            Transition::new(-758746800, 2),
            Transition::new(-701892000, 1),
            Transition::new(-690402600, 2),
            Transition::new(-670442400, 1),
            Transition::new(-658953000, 2),
            Transition::new(-638992800, 1),
            Transition::new(-627503400, 2),
            Transition::new(-606938400, 1),
            Transition::new(-596053800, 2),
            Transition::new(-575488800, 1),
            Transition::new(-564604200, 2),
            Transition::new(-544039200, 1),
            Transition::new(-532549800, 2),
            Transition::new(-512589600, 1),
            Transition::new(-501100200, 2),
            Transition::new(-481140000, 1),
            Transition::new(-469650600, 2),
            Transition::new(-449690400, 1),
            Transition::new(-438201000, 2),
            Transition::new(-417636000, 1),
            Transition::new(-406751400, 2),
            Transition::new(-386186400, 1),
            Transition::new(-375301800, 2),
            Transition::new(-354736800, 1),
            Transition::new(-343247400, 2),
            Transition::new(-323287200, 1),
            Transition::new(-311797800, 2),
            Transition::new(-291837600, 1),
            Transition::new(-280348200, 2),
            Transition::new(-259783200, 1),
            Transition::new(-248898600, 2),
            Transition::new(-228333600, 1),
            Transition::new(-217449000, 2),
            Transition::new(-196884000, 1),
            Transition::new(-185999400, 2),
            Transition::new(-165434400, 1),
            Transition::new(-153945000, 2),
            Transition::new(-133984800, 1),
            Transition::new(-122495400, 2),
            Transition::new(-102535200, 1),
            Transition::new(-91045800, 2),
            Transition::new(-70480800, 1),
            Transition::new(-59596200, 2),
            Transition::new(123919200, 5),
            Transition::new(129618000, 2),
            Transition::new(409039200, 5),
            Transition::new(413874000, 2),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-21168, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-19800, true, Some(b"-0530")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BOA_VISTA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767211040, 2),
            Transition::new(-1206954000, 1),
            Transition::new(-1191358800, 2),
            Transition::new(-1175371200, 1),
            Transition::new(-1159822800, 2),
            Transition::new(-633816000, 1),
            Transition::new(-622065600, 2),
            Transition::new(-602280000, 1),
            Transition::new(-591829200, 2),
            Transition::new(-570744000, 1),
            Transition::new(-560206800, 2),
            Transition::new(-539121600, 1),
            Transition::new(-531349200, 2),
            Transition::new(-191361600, 1),
            Transition::new(-184194000, 2),
            Transition::new(-155160000, 1),
            Transition::new(-150066000, 2),
            Transition::new(-128894400, 1),
            Transition::new(-121122000, 2),
            Transition::new(-99950400, 1),
            Transition::new(-89586000, 2),
            Transition::new(-68414400, 1),
            Transition::new(-57963600, 2),
            Transition::new(499752000, 1),
            Transition::new(511239600, 2),
            Transition::new(530596800, 1),
            Transition::new(540270000, 2),
            Transition::new(562132800, 1),
            Transition::new(571201200, 2),
            Transition::new(938923200, 1),
            Transition::new(951620400, 2),
            Transition::new(970977600, 1),
            Transition::new(971578800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-14560, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BOGOTA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2707671824, 1),
            Transition::new(-1739041424, 3),
            Transition::new(704869200, 2),
            Transition::new(733896000, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-17776, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-17776, false, Some(b"BMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BOISE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2717640000, 2),
            Transition::new(-1633269600, 1),
            Transition::new(-1615129200, 2),
            Transition::new(-1601820000, 1),
            Transition::new(-1583679600, 2),
            Transition::new(-1471788000, 5),
            Transition::new(-880210800, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765388800, 5),
            Transition::new(-84380400, 6),
            Transition::new(-68659200, 5),
            Transition::new(-52930800, 6),
            Transition::new(-37209600, 5),
            Transition::new(-21481200, 6),
            Transition::new(-5760000, 5),
            Transition::new(9968400, 6),
            Transition::new(25689600, 5),
            Transition::new(41418000, 6),
            Transition::new(57744000, 5),
            Transition::new(73472400, 6),
            Transition::new(89193600, 5),
            Transition::new(104922000, 6),
            Transition::new(120643200, 5),
            Transition::new(129114000, 6),
            Transition::new(152092800, 5),
            Transition::new(162378000, 6),
            Transition::new(183542400, 5),
            Transition::new(199270800, 6),
            Transition::new(215596800, 5),
            Transition::new(230720400, 6),
            Transition::new(247046400, 5),
            Transition::new(262774800, 6),
            Transition::new(278496000, 5),
            Transition::new(294224400, 6),
            Transition::new(309945600, 5),
            Transition::new(325674000, 6),
            Transition::new(341395200, 5),
            Transition::new(357123600, 6),
            Transition::new(372844800, 5),
            Transition::new(388573200, 6),
            Transition::new(404899200, 5),
            Transition::new(420022800, 6),
            Transition::new(436348800, 5),
            Transition::new(452077200, 6),
            Transition::new(467798400, 5),
            Transition::new(483526800, 6),
            Transition::new(499248000, 5),
            Transition::new(514976400, 6),
            Transition::new(530697600, 5),
            Transition::new(544611600, 6),
            Transition::new(562147200, 5),
            Transition::new(576061200, 6),
            Transition::new(594201600, 5),
            Transition::new(607510800, 6),
            Transition::new(625651200, 5),
            Transition::new(638960400, 6),
            Transition::new(657100800, 5),
            Transition::new(671014800, 6),
            Transition::new(688550400, 5),
            Transition::new(702464400, 6),
            Transition::new(720000000, 5),
            Transition::new(733914000, 6),
            Transition::new(752054400, 5),
            Transition::new(765363600, 6),
            Transition::new(783504000, 5),
            Transition::new(796813200, 6),
            Transition::new(814953600, 5),
            Transition::new(828867600, 6),
            Transition::new(846403200, 5),
            Transition::new(860317200, 6),
            Transition::new(877852800, 5),
            Transition::new(891766800, 6),
            Transition::new(909302400, 5),
            Transition::new(923216400, 6),
            Transition::new(941356800, 5),
            Transition::new(954666000, 6),
            Transition::new(972806400, 5),
            Transition::new(986115600, 6),
            Transition::new(1004256000, 5),
            Transition::new(1018170000, 6),
            Transition::new(1035705600, 5),
            Transition::new(1049619600, 6),
            Transition::new(1067155200, 5),
            Transition::new(1081069200, 6),
            Transition::new(1099209600, 5),
            Transition::new(1112518800, 6),
            Transition::new(1130659200, 5),
            Transition::new(1143968400, 6),
            Transition::new(1162108800, 5),
            Transition::new(1173603600, 6),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(-27889, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_BUENOS_AIRES: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2372097972, 1),
            Transition::new(-1567453392, 2),
            Transition::new(-1233432000, 3),
            Transition::new(-1222981200, 2),
            Transition::new(-1205956800, 3),
            Transition::new(-1194037200, 2),
            Transition::new(-1172865600, 3),
            Transition::new(-1162501200, 2),
            Transition::new(-1141329600, 3),
            Transition::new(-1130965200, 2),
            Transition::new(-1109793600, 3),
            Transition::new(-1099429200, 2),
            Transition::new(-1078257600, 3),
            Transition::new(-1067806800, 2),
            Transition::new(-1046635200, 3),
            Transition::new(-1036270800, 2),
            Transition::new(-1015099200, 3),
            Transition::new(-1004734800, 2),
            Transition::new(-983563200, 3),
            Transition::new(-973198800, 2),
            Transition::new(-952027200, 3),
            Transition::new(-941576400, 2),
            Transition::new(-931032000, 3),
            Transition::new(-900882000, 2),
            Transition::new(-890337600, 3),
            Transition::new(-833749200, 2),
            Transition::new(-827265600, 3),
            Transition::new(-752274000, 2),
            Transition::new(-733780800, 3),
            Transition::new(-197326800, 2),
            Transition::new(-190843200, 3),
            Transition::new(-184194000, 2),
            Transition::new(-164491200, 3),
            Transition::new(-152658000, 2),
            Transition::new(-132955200, 3),
            Transition::new(-121122000, 2),
            Transition::new(-101419200, 3),
            Transition::new(-86821200, 2),
            Transition::new(-71092800, 3),
            Transition::new(-54766800, 2),
            Transition::new(-39038400, 3),
            Transition::new(-23317200, 2),
            Transition::new(-7588800, 5),
            Transition::new(128142000, 4),
            Transition::new(136605600, 5),
            Transition::new(596948400, 4),
            Transition::new(605066400, 5),
            Transition::new(624423600, 4),
            Transition::new(636516000, 5),
            Transition::new(656478000, 4),
            Transition::new(667965600, 5),
            Transition::new(687927600, 4),
            Transition::new(699415200, 5),
            Transition::new(719377200, 4),
            Transition::new(731469600, 5),
            Transition::new(938919600, 3),
            Transition::new(952052400, 5),
            Transition::new(1198983600, 4),
            Transition::new(1205632800, 5),
            Transition::new(1224385200, 4),
            Transition::new(1237082400, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-14028, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-15408, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CAMBRIDGE_BAY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1577923200, 3),
            Transition::new(-880210800, 1),
            Transition::new(-769395600, 2),
            Transition::new(-765388800, 3),
            Transition::new(-147891600, 4),
            Transition::new(-131562000, 3),
            Transition::new(325674000, 5),
            Transition::new(341395200, 3),
            Transition::new(357123600, 5),
            Transition::new(372844800, 3),
            Transition::new(388573200, 5),
            Transition::new(404899200, 3),
            Transition::new(420022800, 5),
            Transition::new(436348800, 3),
            Transition::new(452077200, 5),
            Transition::new(467798400, 3),
            Transition::new(483526800, 5),
            Transition::new(499248000, 3),
            Transition::new(514976400, 5),
            Transition::new(530697600, 3),
            Transition::new(544611600, 5),
            Transition::new(562147200, 3),
            Transition::new(576061200, 5),
            Transition::new(594201600, 3),
            Transition::new(607510800, 5),
            Transition::new(625651200, 3),
            Transition::new(638960400, 5),
            Transition::new(657100800, 3),
            Transition::new(671014800, 5),
            Transition::new(688550400, 3),
            Transition::new(702464400, 5),
            Transition::new(720000000, 3),
            Transition::new(733914000, 5),
            Transition::new(752054400, 3),
            Transition::new(765363600, 5),
            Transition::new(783504000, 3),
            Transition::new(796813200, 5),
            Transition::new(814953600, 3),
            Transition::new(828867600, 5),
            Transition::new(846403200, 3),
            Transition::new(860317200, 5),
            Transition::new(877852800, 3),
            Transition::new(891766800, 5),
            Transition::new(909302400, 3),
            Transition::new(923216400, 5),
            Transition::new(941356800, 7),
            Transition::new(954662400, 6),
            Transition::new(972802800, 8),
            Transition::new(973400400, 7),
            Transition::new(986115600, 5),
            Transition::new(1004256000, 3),
            Transition::new(1018170000, 5),
            Transition::new(1035705600, 3),
            Transition::new(1049619600, 5),
            Transition::new(1067155200, 3),
            Transition::new(1081069200, 5),
            Transition::new(1099209600, 3),
            Transition::new(1112518800, 5),
            Transition::new(1130659200, 3),
            Transition::new(1143968400, 5),
            Transition::new(1162108800, 3),
            Transition::new(1173603600, 5),
        ],
        &{
            const V: [LocalTimeType; 9] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"MDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CAMPO_GRANDE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767212492, 2),
            Transition::new(-1206954000, 1),
            Transition::new(-1191358800, 2),
            Transition::new(-1175371200, 1),
            Transition::new(-1159822800, 2),
            Transition::new(-633816000, 1),
            Transition::new(-622065600, 2),
            Transition::new(-602280000, 1),
            Transition::new(-591829200, 2),
            Transition::new(-570744000, 1),
            Transition::new(-560206800, 2),
            Transition::new(-539121600, 1),
            Transition::new(-531349200, 2),
            Transition::new(-191361600, 1),
            Transition::new(-184194000, 2),
            Transition::new(-155160000, 1),
            Transition::new(-150066000, 2),
            Transition::new(-128894400, 1),
            Transition::new(-121122000, 2),
            Transition::new(-99950400, 1),
            Transition::new(-89586000, 2),
            Transition::new(-68414400, 1),
            Transition::new(-57963600, 2),
            Transition::new(499752000, 1),
            Transition::new(511239600, 2),
            Transition::new(530596800, 1),
            Transition::new(540270000, 2),
            Transition::new(562132800, 1),
            Transition::new(571201200, 2),
            Transition::new(592977600, 1),
            Transition::new(602046000, 2),
            Transition::new(624427200, 1),
            Transition::new(634705200, 2),
            Transition::new(656481600, 1),
            Transition::new(666759600, 2),
            Transition::new(687931200, 1),
            Transition::new(697604400, 2),
            Transition::new(719985600, 1),
            Transition::new(728449200, 2),
            Transition::new(750830400, 1),
            Transition::new(761713200, 2),
            Transition::new(782280000, 1),
            Transition::new(793162800, 2),
            Transition::new(813729600, 1),
            Transition::new(824007600, 2),
            Transition::new(844574400, 1),
            Transition::new(856062000, 2),
            Transition::new(876110400, 1),
            Transition::new(888721200, 2),
            Transition::new(908078400, 1),
            Transition::new(919566000, 2),
            Transition::new(938923200, 1),
            Transition::new(951620400, 2),
            Transition::new(970977600, 1),
            Transition::new(982465200, 2),
            Transition::new(1003032000, 1),
            Transition::new(1013914800, 2),
            Transition::new(1036296000, 1),
            Transition::new(1045364400, 2),
            Transition::new(1066536000, 1),
            Transition::new(1076814000, 2),
            Transition::new(1099368000, 1),
            Transition::new(1108868400, 2),
            Transition::new(1129435200, 1),
            Transition::new(1140318000, 2),
            Transition::new(1162699200, 1),
            Transition::new(1172372400, 2),
            Transition::new(1192334400, 1),
            Transition::new(1203217200, 2),
            Transition::new(1224388800, 1),
            Transition::new(1234666800, 2),
            Transition::new(1255838400, 1),
            Transition::new(1266721200, 2),
            Transition::new(1287288000, 1),
            Transition::new(1298170800, 2),
            Transition::new(1318737600, 1),
            Transition::new(1330225200, 2),
            Transition::new(1350792000, 1),
            Transition::new(1361070000, 2),
            Transition::new(1382241600, 1),
            Transition::new(1392519600, 2),
            Transition::new(1413691200, 1),
            Transition::new(1424574000, 2),
            Transition::new(1445140800, 1),
            Transition::new(1456023600, 2),
            Transition::new(1476590400, 1),
            Transition::new(1487473200, 2),
            Transition::new(1508040000, 1),
            Transition::new(1518922800, 2),
            Transition::new(1541304000, 1),
            Transition::new(1550372400, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-13108, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CANCUN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514743200, 1),
            Transition::new(377935200, 3),
            Transition::new(828860400, 2),
            Transition::new(846396000, 3),
            Transition::new(860310000, 2),
            Transition::new(877845600, 3),
            Transition::new(891759600, 2),
            Transition::new(902037600, 4),
            Transition::new(909298800, 1),
            Transition::new(923212800, 4),
            Transition::new(941353200, 1),
            Transition::new(954662400, 4),
            Transition::new(972802800, 1),
            Transition::new(989136000, 4),
            Transition::new(1001833200, 1),
            Transition::new(1018166400, 4),
            Transition::new(1035702000, 1),
            Transition::new(1049616000, 4),
            Transition::new(1067151600, 1),
            Transition::new(1081065600, 4),
            Transition::new(1099206000, 1),
            Transition::new(1112515200, 4),
            Transition::new(1130655600, 1),
            Transition::new(1143964800, 4),
            Transition::new(1162105200, 1),
            Transition::new(1175414400, 4),
            Transition::new(1193554800, 1),
            Transition::new(1207468800, 4),
            Transition::new(1225004400, 1),
            Transition::new(1238918400, 4),
            Transition::new(1256454000, 1),
            Transition::new(1270368000, 4),
            Transition::new(1288508400, 1),
            Transition::new(1301817600, 4),
            Transition::new(1319958000, 1),
            Transition::new(1333267200, 4),
            Transition::new(1351407600, 1),
            Transition::new(1365321600, 4),
            Transition::new(1382857200, 1),
            Transition::new(1396771200, 4),
            Transition::new(1414306800, 1),
            Transition::new(1422777600, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-20824, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CARACAS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524505536, 1),
            Transition::new(-1826739140, 2),
            Transition::new(-157750200, 3),
            Transition::new(1197183600, 2),
            Transition::new(1462086000, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-16064, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-16060, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-16200, false, Some(b"-0430")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CATAMARCA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2372096212, 1),
            Transition::new(-1567453392, 2),
            Transition::new(-1233432000, 3),
            Transition::new(-1222981200, 2),
            Transition::new(-1205956800, 3),
            Transition::new(-1194037200, 2),
            Transition::new(-1172865600, 3),
            Transition::new(-1162501200, 2),
            Transition::new(-1141329600, 3),
            Transition::new(-1130965200, 2),
            Transition::new(-1109793600, 3),
            Transition::new(-1099429200, 2),
            Transition::new(-1078257600, 3),
            Transition::new(-1067806800, 2),
            Transition::new(-1046635200, 3),
            Transition::new(-1036270800, 2),
            Transition::new(-1015099200, 3),
            Transition::new(-1004734800, 2),
            Transition::new(-983563200, 3),
            Transition::new(-973198800, 2),
            Transition::new(-952027200, 3),
            Transition::new(-941576400, 2),
            Transition::new(-931032000, 3),
            Transition::new(-900882000, 2),
            Transition::new(-890337600, 3),
            Transition::new(-833749200, 2),
            Transition::new(-827265600, 3),
            Transition::new(-752274000, 2),
            Transition::new(-733780800, 3),
            Transition::new(-197326800, 2),
            Transition::new(-190843200, 3),
            Transition::new(-184194000, 2),
            Transition::new(-164491200, 3),
            Transition::new(-152658000, 2),
            Transition::new(-132955200, 3),
            Transition::new(-121122000, 2),
            Transition::new(-101419200, 3),
            Transition::new(-86821200, 2),
            Transition::new(-71092800, 3),
            Transition::new(-54766800, 2),
            Transition::new(-39038400, 3),
            Transition::new(-23317200, 2),
            Transition::new(-7588800, 5),
            Transition::new(128142000, 4),
            Transition::new(136605600, 5),
            Transition::new(596948400, 4),
            Transition::new(605066400, 5),
            Transition::new(624423600, 4),
            Transition::new(636516000, 5),
            Transition::new(656478000, 4),
            Transition::new(667965600, 2),
            Transition::new(687931200, 4),
            Transition::new(699415200, 5),
            Transition::new(719377200, 4),
            Transition::new(731469600, 5),
            Transition::new(938919600, 3),
            Transition::new(952052400, 5),
            Transition::new(1086058800, 2),
            Transition::new(1087704000, 5),
            Transition::new(1198983600, 4),
            Transition::new(1205632800, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-15788, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-15408, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CAYENNE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1846269040, 1),
            Transition::new(-71092800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-12560, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CHICAGO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2717647200, 2),
            Transition::new(-1633276800, 1),
            Transition::new(-1615136400, 2),
            Transition::new(-1601827200, 1),
            Transition::new(-1583686800, 2),
            Transition::new(-1563724800, 1),
            Transition::new(-1551632400, 2),
            Transition::new(-1538928000, 1),
            Transition::new(-1520182800, 2),
            Transition::new(-1504454400, 1),
            Transition::new(-1491757200, 2),
            Transition::new(-1473004800, 1),
            Transition::new(-1459702800, 2),
            Transition::new(-1441555200, 1),
            Transition::new(-1428253200, 2),
            Transition::new(-1410105600, 1),
            Transition::new(-1396803600, 2),
            Transition::new(-1378656000, 1),
            Transition::new(-1365354000, 2),
            Transition::new(-1347206400, 1),
            Transition::new(-1333904400, 2),
            Transition::new(-1315152000, 1),
            Transition::new(-1301850000, 2),
            Transition::new(-1283702400, 1),
            Transition::new(-1270400400, 2),
            Transition::new(-1252252800, 1),
            Transition::new(-1238950800, 2),
            Transition::new(-1220803200, 1),
            Transition::new(-1207501200, 2),
            Transition::new(-1189353600, 1),
            Transition::new(-1176051600, 2),
            Transition::new(-1157299200, 1),
            Transition::new(-1144602000, 2),
            Transition::new(-1125849600, 1),
            Transition::new(-1112547600, 2),
            Transition::new(-1094400000, 1),
            Transition::new(-1081098000, 2),
            Transition::new(-1067788800, 3),
            Transition::new(-1045414800, 2),
            Transition::new(-1031500800, 1),
            Transition::new(-1018198800, 2),
            Transition::new(-1000051200, 1),
            Transition::new(-986749200, 2),
            Transition::new(-967996800, 1),
            Transition::new(-955299600, 2),
            Transition::new(-936547200, 1),
            Transition::new(-923245200, 2),
            Transition::new(-905097600, 1),
            Transition::new(-891795600, 2),
            Transition::new(-880214400, 4),
            Transition::new(-769395600, 5),
            Transition::new(-765392400, 2),
            Transition::new(-747244800, 1),
            Transition::new(-733942800, 2),
            Transition::new(-715795200, 1),
            Transition::new(-702493200, 2),
            Transition::new(-684345600, 1),
            Transition::new(-671043600, 2),
            Transition::new(-652896000, 1),
            Transition::new(-639594000, 2),
            Transition::new(-620841600, 1),
            Transition::new(-608144400, 2),
            Transition::new(-589392000, 1),
            Transition::new(-576090000, 2),
            Transition::new(-557942400, 1),
            Transition::new(-544640400, 2),
            Transition::new(-526492800, 1),
            Transition::new(-513190800, 2),
            Transition::new(-495043200, 1),
            Transition::new(-481741200, 2),
            Transition::new(-463593600, 1),
            Transition::new(-447267600, 2),
            Transition::new(-431539200, 1),
            Transition::new(-415818000, 2),
            Transition::new(-400089600, 1),
            Transition::new(-384368400, 2),
            Transition::new(-368640000, 1),
            Transition::new(-352918800, 2),
            Transition::new(-337190400, 1),
            Transition::new(-321469200, 2),
            Transition::new(-305740800, 1),
            Transition::new(-289414800, 2),
            Transition::new(-273686400, 1),
            Transition::new(-257965200, 2),
            Transition::new(-242236800, 1),
            Transition::new(-226515600, 2),
            Transition::new(-210787200, 1),
            Transition::new(-195066000, 2),
            Transition::new(-179337600, 1),
            Transition::new(-163616400, 2),
            Transition::new(-147888000, 1),
            Transition::new(-131562000, 2),
            Transition::new(-116438400, 1),
            Transition::new(-100112400, 2),
            Transition::new(-84384000, 1),
            Transition::new(-68662800, 2),
            Transition::new(-52934400, 1),
            Transition::new(-37213200, 2),
            Transition::new(-21484800, 1),
            Transition::new(-5763600, 2),
            Transition::new(9964800, 1),
            Transition::new(25686000, 2),
            Transition::new(41414400, 1),
            Transition::new(57740400, 2),
            Transition::new(73468800, 1),
            Transition::new(89190000, 2),
            Transition::new(104918400, 1),
            Transition::new(120639600, 2),
            Transition::new(126691200, 1),
            Transition::new(152089200, 2),
            Transition::new(162374400, 1),
            Transition::new(183538800, 2),
            Transition::new(199267200, 1),
            Transition::new(215593200, 2),
            Transition::new(230716800, 1),
            Transition::new(247042800, 2),
            Transition::new(262771200, 1),
            Transition::new(278492400, 2),
            Transition::new(294220800, 1),
            Transition::new(309942000, 2),
            Transition::new(325670400, 1),
            Transition::new(341391600, 2),
            Transition::new(357120000, 1),
            Transition::new(372841200, 2),
            Transition::new(388569600, 1),
            Transition::new(404895600, 2),
            Transition::new(420019200, 1),
            Transition::new(436345200, 2),
            Transition::new(452073600, 1),
            Transition::new(467794800, 2),
            Transition::new(483523200, 1),
            Transition::new(499244400, 2),
            Transition::new(514972800, 1),
            Transition::new(530694000, 2),
            Transition::new(544608000, 1),
            Transition::new(562143600, 2),
            Transition::new(576057600, 1),
            Transition::new(594198000, 2),
            Transition::new(607507200, 1),
            Transition::new(625647600, 2),
            Transition::new(638956800, 1),
            Transition::new(657097200, 2),
            Transition::new(671011200, 1),
            Transition::new(688546800, 2),
            Transition::new(702460800, 1),
            Transition::new(719996400, 2),
            Transition::new(733910400, 1),
            Transition::new(752050800, 2),
            Transition::new(765360000, 1),
            Transition::new(783500400, 2),
            Transition::new(796809600, 1),
            Transition::new(814950000, 2),
            Transition::new(828864000, 1),
            Transition::new(846399600, 2),
            Transition::new(860313600, 1),
            Transition::new(877849200, 2),
            Transition::new(891763200, 1),
            Transition::new(909298800, 2),
            Transition::new(923212800, 1),
            Transition::new(941353200, 2),
            Transition::new(954662400, 1),
            Transition::new(972802800, 2),
            Transition::new(986112000, 1),
            Transition::new(1004252400, 2),
            Transition::new(1018166400, 1),
            Transition::new(1035702000, 2),
            Transition::new(1049616000, 1),
            Transition::new(1067151600, 2),
            Transition::new(1081065600, 1),
            Transition::new(1099206000, 2),
            Transition::new(1112515200, 1),
            Transition::new(1130655600, 2),
            Transition::new(1143964800, 1),
            Transition::new(1162105200, 2),
            Transition::new(1173600000, 1),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-21036, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CHIHUAHUA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514739600, 1),
            Transition::new(-1343066400, 2),
            Transition::new(-1234807200, 1),
            Transition::new(-1220292000, 2),
            Transition::new(-1207159200, 1),
            Transition::new(-1191344400, 2),
            Transition::new(828864000, 3),
            Transition::new(846399600, 2),
            Transition::new(860313600, 3),
            Transition::new(877849200, 2),
            Transition::new(891766800, 4),
            Transition::new(909302400, 1),
            Transition::new(923216400, 4),
            Transition::new(941356800, 1),
            Transition::new(954666000, 4),
            Transition::new(972806400, 1),
            Transition::new(989139600, 4),
            Transition::new(1001836800, 1),
            Transition::new(1018170000, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-25460, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CORDOBA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2372096592, 1),
            Transition::new(-1567453392, 2),
            Transition::new(-1233432000, 3),
            Transition::new(-1222981200, 2),
            Transition::new(-1205956800, 3),
            Transition::new(-1194037200, 2),
            Transition::new(-1172865600, 3),
            Transition::new(-1162501200, 2),
            Transition::new(-1141329600, 3),
            Transition::new(-1130965200, 2),
            Transition::new(-1109793600, 3),
            Transition::new(-1099429200, 2),
            Transition::new(-1078257600, 3),
            Transition::new(-1067806800, 2),
            Transition::new(-1046635200, 3),
            Transition::new(-1036270800, 2),
            Transition::new(-1015099200, 3),
            Transition::new(-1004734800, 2),
            Transition::new(-983563200, 3),
            Transition::new(-973198800, 2),
            Transition::new(-952027200, 3),
            Transition::new(-941576400, 2),
            Transition::new(-931032000, 3),
            Transition::new(-900882000, 2),
            Transition::new(-890337600, 3),
            Transition::new(-833749200, 2),
            Transition::new(-827265600, 3),
            Transition::new(-752274000, 2),
            Transition::new(-733780800, 3),
            Transition::new(-197326800, 2),
            Transition::new(-190843200, 3),
            Transition::new(-184194000, 2),
            Transition::new(-164491200, 3),
            Transition::new(-152658000, 2),
            Transition::new(-132955200, 3),
            Transition::new(-121122000, 2),
            Transition::new(-101419200, 3),
            Transition::new(-86821200, 2),
            Transition::new(-71092800, 3),
            Transition::new(-54766800, 2),
            Transition::new(-39038400, 3),
            Transition::new(-23317200, 2),
            Transition::new(-7588800, 5),
            Transition::new(128142000, 4),
            Transition::new(136605600, 5),
            Transition::new(596948400, 4),
            Transition::new(605066400, 5),
            Transition::new(624423600, 4),
            Transition::new(636516000, 5),
            Transition::new(656478000, 4),
            Transition::new(667965600, 2),
            Transition::new(687931200, 4),
            Transition::new(699415200, 5),
            Transition::new(719377200, 4),
            Transition::new(731469600, 5),
            Transition::new(938919600, 3),
            Transition::new(952052400, 5),
            Transition::new(1198983600, 4),
            Transition::new(1205632800, 5),
            Transition::new(1224385200, 4),
            Transition::new(1237082400, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-15408, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-15408, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_COSTA_RICA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524501427, 1),
            Transition::new(-1545071027, 3),
            Transition::new(288770400, 2),
            Transition::new(297234000, 3),
            Transition::new(320220000, 2),
            Transition::new(328683600, 3),
            Transition::new(664264800, 2),
            Transition::new(678344400, 3),
            Transition::new(695714400, 2),
            Transition::new(700635600, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-20173, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-20173, false, Some(b"SJMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CRESTON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2717643600, 2),
            Transition::new(-1633273200, 1),
            Transition::new(-1615132800, 2),
            Transition::new(-1601823600, 1),
            Transition::new(-1583683200, 2),
            Transition::new(-880210800, 3),
            Transition::new(-820519140, 2),
            Transition::new(-812653140, 3),
            Transition::new(-796845540, 2),
            Transition::new(-84380400, 1),
            Transition::new(-68659200, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-26898, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_CUIABA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767212140, 2),
            Transition::new(-1206954000, 1),
            Transition::new(-1191358800, 2),
            Transition::new(-1175371200, 1),
            Transition::new(-1159822800, 2),
            Transition::new(-633816000, 1),
            Transition::new(-622065600, 2),
            Transition::new(-602280000, 1),
            Transition::new(-591829200, 2),
            Transition::new(-570744000, 1),
            Transition::new(-560206800, 2),
            Transition::new(-539121600, 1),
            Transition::new(-531349200, 2),
            Transition::new(-191361600, 1),
            Transition::new(-184194000, 2),
            Transition::new(-155160000, 1),
            Transition::new(-150066000, 2),
            Transition::new(-128894400, 1),
            Transition::new(-121122000, 2),
            Transition::new(-99950400, 1),
            Transition::new(-89586000, 2),
            Transition::new(-68414400, 1),
            Transition::new(-57963600, 2),
            Transition::new(499752000, 1),
            Transition::new(511239600, 2),
            Transition::new(530596800, 1),
            Transition::new(540270000, 2),
            Transition::new(562132800, 1),
            Transition::new(571201200, 2),
            Transition::new(592977600, 1),
            Transition::new(602046000, 2),
            Transition::new(624427200, 1),
            Transition::new(634705200, 2),
            Transition::new(656481600, 1),
            Transition::new(666759600, 2),
            Transition::new(687931200, 1),
            Transition::new(697604400, 2),
            Transition::new(719985600, 1),
            Transition::new(728449200, 2),
            Transition::new(750830400, 1),
            Transition::new(761713200, 2),
            Transition::new(782280000, 1),
            Transition::new(793162800, 2),
            Transition::new(813729600, 1),
            Transition::new(824007600, 2),
            Transition::new(844574400, 1),
            Transition::new(856062000, 2),
            Transition::new(876110400, 1),
            Transition::new(888721200, 2),
            Transition::new(908078400, 1),
            Transition::new(919566000, 2),
            Transition::new(938923200, 1),
            Transition::new(951620400, 2),
            Transition::new(970977600, 1),
            Transition::new(982465200, 2),
            Transition::new(1003032000, 1),
            Transition::new(1013914800, 2),
            Transition::new(1036296000, 1),
            Transition::new(1045364400, 2),
            Transition::new(1099368000, 1),
            Transition::new(1108868400, 2),
            Transition::new(1129435200, 1),
            Transition::new(1140318000, 2),
            Transition::new(1162699200, 1),
            Transition::new(1172372400, 2),
            Transition::new(1192334400, 1),
            Transition::new(1203217200, 2),
            Transition::new(1224388800, 1),
            Transition::new(1234666800, 2),
            Transition::new(1255838400, 1),
            Transition::new(1266721200, 2),
            Transition::new(1287288000, 1),
            Transition::new(1298170800, 2),
            Transition::new(1318737600, 1),
            Transition::new(1330225200, 2),
            Transition::new(1350792000, 1),
            Transition::new(1361070000, 2),
            Transition::new(1382241600, 1),
            Transition::new(1392519600, 2),
            Transition::new(1413691200, 1),
            Transition::new(1424574000, 2),
            Transition::new(1445140800, 1),
            Transition::new(1456023600, 2),
            Transition::new(1476590400, 1),
            Transition::new(1487473200, 2),
            Transition::new(1508040000, 1),
            Transition::new(1518922800, 2),
            Transition::new(1541304000, 1),
            Transition::new(1550372400, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-13460, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_DANMARKSHAVN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1686091520, 1),
            Transition::new(323845200, 2),
            Transition::new(338950800, 1),
            Transition::new(354675600, 2),
            Transition::new(370400400, 1),
            Transition::new(386125200, 2),
            Transition::new(401850000, 1),
            Transition::new(417574800, 2),
            Transition::new(433299600, 1),
            Transition::new(449024400, 2),
            Transition::new(465354000, 1),
            Transition::new(481078800, 2),
            Transition::new(496803600, 1),
            Transition::new(512528400, 2),
            Transition::new(528253200, 1),
            Transition::new(543978000, 2),
            Transition::new(559702800, 1),
            Transition::new(575427600, 2),
            Transition::new(591152400, 1),
            Transition::new(606877200, 2),
            Transition::new(622602000, 1),
            Transition::new(638326800, 2),
            Transition::new(654656400, 1),
            Transition::new(670381200, 2),
            Transition::new(686106000, 1),
            Transition::new(701830800, 2),
            Transition::new(717555600, 1),
            Transition::new(733280400, 2),
            Transition::new(749005200, 1),
            Transition::new(764730000, 2),
            Transition::new(780454800, 1),
            Transition::new(796179600, 2),
            Transition::new(811904400, 1),
            Transition::new(820465200, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-4480, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(0, false, Some(b"GMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_DAWSON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2188996940, 2),
            Transition::new(-1632056400, 1),
            Transition::new(-1615125600, 2),
            Transition::new(-1596978000, 1),
            Transition::new(-1583164800, 2),
            Transition::new(-880203600, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765381600, 2),
            Transition::new(-147884400, 5),
            Transition::new(-131554800, 2),
            Transition::new(120646800, 6),
            Transition::new(325677600, 7),
            Transition::new(341398800, 6),
            Transition::new(357127200, 7),
            Transition::new(372848400, 6),
            Transition::new(388576800, 7),
            Transition::new(404902800, 6),
            Transition::new(420026400, 7),
            Transition::new(436352400, 6),
            Transition::new(452080800, 7),
            Transition::new(467802000, 6),
            Transition::new(483530400, 7),
            Transition::new(499251600, 6),
            Transition::new(514980000, 7),
            Transition::new(530701200, 6),
            Transition::new(544615200, 7),
            Transition::new(562150800, 6),
            Transition::new(576064800, 7),
            Transition::new(594205200, 6),
            Transition::new(607514400, 7),
            Transition::new(625654800, 6),
            Transition::new(638964000, 7),
            Transition::new(657104400, 6),
            Transition::new(671018400, 7),
            Transition::new(688554000, 6),
            Transition::new(702468000, 7),
            Transition::new(720003600, 6),
            Transition::new(733917600, 7),
            Transition::new(752058000, 6),
            Transition::new(765367200, 7),
            Transition::new(783507600, 6),
            Transition::new(796816800, 7),
            Transition::new(814957200, 6),
            Transition::new(828871200, 7),
            Transition::new(846406800, 6),
            Transition::new(860320800, 7),
            Transition::new(877856400, 6),
            Transition::new(891770400, 7),
            Transition::new(909306000, 6),
            Transition::new(923220000, 7),
            Transition::new(941360400, 6),
            Transition::new(954669600, 7),
            Transition::new(972810000, 6),
            Transition::new(986119200, 7),
            Transition::new(1004259600, 6),
            Transition::new(1018173600, 7),
            Transition::new(1035709200, 6),
            Transition::new(1049623200, 7),
            Transition::new(1067158800, 6),
            Transition::new(1081072800, 7),
            Transition::new(1099213200, 6),
            Transition::new(1112522400, 7),
            Transition::new(1130662800, 6),
            Transition::new(1143972000, 7),
            Transition::new(1162112400, 6),
            Transition::new(1173607200, 7),
            Transition::new(1194166800, 6),
            Transition::new(1205056800, 7),
            Transition::new(1225616400, 6),
            Transition::new(1236506400, 7),
            Transition::new(1257066000, 6),
            Transition::new(1268560800, 7),
            Transition::new(1289120400, 6),
            Transition::new(1300010400, 7),
            Transition::new(1320570000, 6),
            Transition::new(1331460000, 7),
            Transition::new(1352019600, 6),
            Transition::new(1362909600, 7),
            Transition::new(1383469200, 6),
            Transition::new(1394359200, 7),
            Transition::new(1414918800, 6),
            Transition::new(1425808800, 7),
            Transition::new(1446368400, 6),
            Transition::new(1457863200, 7),
            Transition::new(1478422800, 6),
            Transition::new(1489312800, 7),
            Transition::new(1509872400, 6),
            Transition::new(1520762400, 7),
            Transition::new(1541322000, 6),
            Transition::new(1552212000, 7),
            Transition::new(1572771600, 6),
            Transition::new(1583661600, 7),
            Transition::new(1604214000, 8),
        ],
        &{
            const V: [LocalTimeType; 9] = [
                match LocalTimeType::new(-33460, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"YST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"YDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_DAWSON_CREEK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713881544, 2),
            Transition::new(-1632060000, 1),
            Transition::new(-1615129200, 2),
            Transition::new(-880207200, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765385200, 2),
            Transition::new(-715788000, 1),
            Transition::new(-702486000, 2),
            Transition::new(-684338400, 1),
            Transition::new(-671036400, 2),
            Transition::new(-652888800, 1),
            Transition::new(-639586800, 2),
            Transition::new(-620834400, 1),
            Transition::new(-608137200, 2),
            Transition::new(-589384800, 1),
            Transition::new(-576082800, 2),
            Transition::new(-557935200, 1),
            Transition::new(-544633200, 2),
            Transition::new(-526485600, 1),
            Transition::new(-513183600, 2),
            Transition::new(-495036000, 1),
            Transition::new(-481734000, 2),
            Transition::new(-463586400, 1),
            Transition::new(-450284400, 2),
            Transition::new(-431532000, 1),
            Transition::new(-418230000, 2),
            Transition::new(-400082400, 1),
            Transition::new(-386780400, 2),
            Transition::new(-368632800, 1),
            Transition::new(-355330800, 2),
            Transition::new(-337183200, 1),
            Transition::new(-323881200, 2),
            Transition::new(-305733600, 1),
            Transition::new(-292431600, 2),
            Transition::new(-273679200, 1),
            Transition::new(-260982000, 2),
            Transition::new(-242229600, 1),
            Transition::new(-226508400, 2),
            Transition::new(-210780000, 1),
            Transition::new(-195058800, 2),
            Transition::new(-179330400, 1),
            Transition::new(-163609200, 2),
            Transition::new(-147880800, 1),
            Transition::new(-131554800, 2),
            Transition::new(-116431200, 1),
            Transition::new(-100105200, 2),
            Transition::new(-84376800, 1),
            Transition::new(-68655600, 2),
            Transition::new(-52927200, 1),
            Transition::new(-37206000, 2),
            Transition::new(-21477600, 1),
            Transition::new(-5756400, 2),
            Transition::new(9972000, 1),
            Transition::new(25693200, 2),
            Transition::new(41421600, 1),
            Transition::new(57747600, 2),
            Transition::new(73476000, 1),
            Transition::new(84013200, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-28856, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_DETROIT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2051202469, 1),
            Transition::new(-1724083200, 2),
            Transition::new(-880218000, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765396000, 2),
            Transition::new(-684349200, 5),
            Transition::new(-671047200, 2),
            Transition::new(-80506740, 5),
            Transition::new(-68666400, 2),
            Transition::new(-52938000, 5),
            Transition::new(-37216800, 2),
            Transition::new(104914800, 5),
            Transition::new(120636000, 2),
            Transition::new(126687600, 5),
            Transition::new(152085600, 2),
            Transition::new(167814000, 5),
            Transition::new(183535200, 2),
            Transition::new(199263600, 5),
            Transition::new(215589600, 2),
            Transition::new(230713200, 5),
            Transition::new(247039200, 2),
            Transition::new(262767600, 5),
            Transition::new(278488800, 2),
            Transition::new(294217200, 5),
            Transition::new(309938400, 2),
            Transition::new(325666800, 5),
            Transition::new(341388000, 2),
            Transition::new(357116400, 5),
            Transition::new(372837600, 2),
            Transition::new(388566000, 5),
            Transition::new(404892000, 2),
            Transition::new(420015600, 5),
            Transition::new(436341600, 2),
            Transition::new(452070000, 5),
            Transition::new(467791200, 2),
            Transition::new(483519600, 5),
            Transition::new(499240800, 2),
            Transition::new(514969200, 5),
            Transition::new(530690400, 2),
            Transition::new(544604400, 5),
            Transition::new(562140000, 2),
            Transition::new(576054000, 5),
            Transition::new(594194400, 2),
            Transition::new(607503600, 5),
            Transition::new(625644000, 2),
            Transition::new(638953200, 5),
            Transition::new(657093600, 2),
            Transition::new(671007600, 5),
            Transition::new(688543200, 2),
            Transition::new(702457200, 5),
            Transition::new(719992800, 2),
            Transition::new(733906800, 5),
            Transition::new(752047200, 2),
            Transition::new(765356400, 5),
            Transition::new(783496800, 2),
            Transition::new(796806000, 5),
            Transition::new(814946400, 2),
            Transition::new(828860400, 5),
            Transition::new(846396000, 2),
            Transition::new(860310000, 5),
            Transition::new(877845600, 2),
            Transition::new(891759600, 5),
            Transition::new(909295200, 2),
            Transition::new(923209200, 5),
            Transition::new(941349600, 2),
            Transition::new(954658800, 5),
            Transition::new(972799200, 2),
            Transition::new(986108400, 5),
            Transition::new(1004248800, 2),
            Transition::new(1018162800, 5),
            Transition::new(1035698400, 2),
            Transition::new(1049612400, 5),
            Transition::new(1067148000, 2),
            Transition::new(1081062000, 5),
            Transition::new(1099202400, 2),
            Transition::new(1112511600, 5),
            Transition::new(1130652000, 2),
            Transition::new(1143961200, 5),
            Transition::new(1162101600, 2),
            Transition::new(1173596400, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-19931, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_EDMONTON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1998663968, 2),
            Transition::new(-1632063600, 1),
            Transition::new(-1615132800, 2),
            Transition::new(-1600614000, 1),
            Transition::new(-1596816000, 2),
            Transition::new(-1567954800, 1),
            Transition::new(-1551628800, 2),
            Transition::new(-1536505200, 1),
            Transition::new(-1523203200, 2),
            Transition::new(-1504450800, 1),
            Transition::new(-1491753600, 2),
            Transition::new(-1473001200, 1),
            Transition::new(-1459699200, 2),
            Transition::new(-880210800, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765388800, 2),
            Transition::new(-715791600, 1),
            Transition::new(-702489600, 2),
            Transition::new(73472400, 1),
            Transition::new(89193600, 2),
            Transition::new(104922000, 1),
            Transition::new(120643200, 2),
            Transition::new(136371600, 1),
            Transition::new(152092800, 2),
            Transition::new(167821200, 1),
            Transition::new(183542400, 2),
            Transition::new(199270800, 1),
            Transition::new(215596800, 2),
            Transition::new(230720400, 1),
            Transition::new(247046400, 2),
            Transition::new(262774800, 1),
            Transition::new(278496000, 2),
            Transition::new(294224400, 1),
            Transition::new(309945600, 2),
            Transition::new(325674000, 1),
            Transition::new(341395200, 2),
            Transition::new(357123600, 1),
            Transition::new(372844800, 2),
            Transition::new(388573200, 1),
            Transition::new(404899200, 2),
            Transition::new(420022800, 1),
            Transition::new(436348800, 2),
            Transition::new(452077200, 1),
            Transition::new(467798400, 2),
            Transition::new(483526800, 1),
            Transition::new(499248000, 2),
            Transition::new(514976400, 1),
            Transition::new(530697600, 2),
            Transition::new(544611600, 1),
            Transition::new(562147200, 2),
            Transition::new(576061200, 1),
            Transition::new(594201600, 2),
            Transition::new(607510800, 1),
            Transition::new(625651200, 2),
            Transition::new(638960400, 1),
            Transition::new(657100800, 2),
            Transition::new(671014800, 1),
            Transition::new(688550400, 2),
            Transition::new(702464400, 1),
            Transition::new(720000000, 2),
            Transition::new(733914000, 1),
            Transition::new(752054400, 2),
            Transition::new(765363600, 1),
            Transition::new(783504000, 2),
            Transition::new(796813200, 1),
            Transition::new(814953600, 2),
            Transition::new(828867600, 1),
            Transition::new(846403200, 2),
            Transition::new(860317200, 1),
            Transition::new(877852800, 2),
            Transition::new(891766800, 1),
            Transition::new(909302400, 2),
            Transition::new(923216400, 1),
            Transition::new(941356800, 2),
            Transition::new(954666000, 1),
            Transition::new(972806400, 2),
            Transition::new(986115600, 1),
            Transition::new(1004256000, 2),
            Transition::new(1018170000, 1),
            Transition::new(1035705600, 2),
            Transition::new(1049619600, 1),
            Transition::new(1067155200, 2),
            Transition::new(1081069200, 1),
            Transition::new(1099209600, 2),
            Transition::new(1112518800, 1),
            Transition::new(1130659200, 2),
            Transition::new(1143968400, 1),
            Transition::new(1162108800, 2),
            Transition::new(1173603600, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-27232, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_EIRUNEPE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767208832, 2),
            Transition::new(-1206950400, 1),
            Transition::new(-1191355200, 2),
            Transition::new(-1175367600, 1),
            Transition::new(-1159819200, 2),
            Transition::new(-633812400, 1),
            Transition::new(-622062000, 2),
            Transition::new(-602276400, 1),
            Transition::new(-591825600, 2),
            Transition::new(-570740400, 1),
            Transition::new(-560203200, 2),
            Transition::new(-539118000, 1),
            Transition::new(-531345600, 2),
            Transition::new(-191358000, 1),
            Transition::new(-184190400, 2),
            Transition::new(-155156400, 1),
            Transition::new(-150062400, 2),
            Transition::new(-128890800, 1),
            Transition::new(-121118400, 2),
            Transition::new(-99946800, 1),
            Transition::new(-89582400, 2),
            Transition::new(-68410800, 1),
            Transition::new(-57960000, 2),
            Transition::new(499755600, 1),
            Transition::new(511243200, 2),
            Transition::new(530600400, 1),
            Transition::new(540273600, 2),
            Transition::new(562136400, 1),
            Transition::new(571204800, 2),
            Transition::new(750834000, 1),
            Transition::new(761716800, 2),
            Transition::new(1214283600, 3),
            Transition::new(1384056000, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-16768, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_EL_SALVADOR: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1546279392, 2),
            Transition::new(547020000, 1),
            Transition::new(559717200, 2),
            Transition::new(578469600, 1),
            Transition::new(591166800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-21408, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ENSENADA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514736000, 1),
            Transition::new(-1451667600, 2),
            Transition::new(-1343062800, 1),
            Transition::new(-1234803600, 2),
            Transition::new(-1222963200, 3),
            Transition::new(-1207242000, 2),
            Transition::new(-873820800, 4),
            Transition::new(-769395600, 5),
            Transition::new(-761677200, 2),
            Transition::new(-686073600, 3),
            Transition::new(-661539600, 2),
            Transition::new(-495039600, 3),
            Transition::new(-481734000, 2),
            Transition::new(-463590000, 3),
            Transition::new(-450284400, 2),
            Transition::new(-431535600, 3),
            Transition::new(-418230000, 2),
            Transition::new(-400086000, 3),
            Transition::new(-386780400, 2),
            Transition::new(-368636400, 3),
            Transition::new(-355330800, 2),
            Transition::new(-337186800, 3),
            Transition::new(-323881200, 2),
            Transition::new(-305737200, 3),
            Transition::new(-292431600, 2),
            Transition::new(199274400, 3),
            Transition::new(215600400, 2),
            Transition::new(230724000, 3),
            Transition::new(247050000, 2),
            Transition::new(262778400, 3),
            Transition::new(278499600, 2),
            Transition::new(294228000, 3),
            Transition::new(309949200, 2),
            Transition::new(325677600, 3),
            Transition::new(341398800, 2),
            Transition::new(357127200, 3),
            Transition::new(372848400, 2),
            Transition::new(388576800, 3),
            Transition::new(404902800, 2),
            Transition::new(420026400, 3),
            Transition::new(436352400, 2),
            Transition::new(452080800, 3),
            Transition::new(467802000, 2),
            Transition::new(483530400, 3),
            Transition::new(499251600, 2),
            Transition::new(514980000, 3),
            Transition::new(530701200, 2),
            Transition::new(544615200, 3),
            Transition::new(562150800, 2),
            Transition::new(576064800, 3),
            Transition::new(594205200, 2),
            Transition::new(607514400, 3),
            Transition::new(625654800, 2),
            Transition::new(638964000, 3),
            Transition::new(657104400, 2),
            Transition::new(671018400, 3),
            Transition::new(688554000, 2),
            Transition::new(702468000, 3),
            Transition::new(720003600, 2),
            Transition::new(733917600, 3),
            Transition::new(752058000, 2),
            Transition::new(765367200, 3),
            Transition::new(783507600, 2),
            Transition::new(796816800, 3),
            Transition::new(814957200, 2),
            Transition::new(828871200, 3),
            Transition::new(846406800, 2),
            Transition::new(860320800, 3),
            Transition::new(877856400, 2),
            Transition::new(891770400, 3),
            Transition::new(909306000, 2),
            Transition::new(923220000, 3),
            Transition::new(941360400, 2),
            Transition::new(954669600, 3),
            Transition::new(972810000, 2),
            Transition::new(986119200, 3),
            Transition::new(1004259600, 2),
            Transition::new(1018173600, 3),
            Transition::new(1035709200, 2),
            Transition::new(1049623200, 3),
            Transition::new(1067158800, 2),
            Transition::new(1081072800, 3),
            Transition::new(1099213200, 2),
            Transition::new(1112522400, 3),
            Transition::new(1130662800, 2),
            Transition::new(1143972000, 3),
            Transition::new(1162112400, 2),
            Transition::new(1175421600, 3),
            Transition::new(1193562000, 2),
            Transition::new(1207476000, 3),
            Transition::new(1225011600, 2),
            Transition::new(1238925600, 3),
            Transition::new(1256461200, 2),
            Transition::new(1268560800, 3),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-28084, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-28800, false, Some(b"PST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_FORTALEZA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767216360, 2),
            Transition::new(-1206957600, 1),
            Transition::new(-1191362400, 2),
            Transition::new(-1175374800, 1),
            Transition::new(-1159826400, 2),
            Transition::new(-633819600, 1),
            Transition::new(-622069200, 2),
            Transition::new(-602283600, 1),
            Transition::new(-591832800, 2),
            Transition::new(-570747600, 1),
            Transition::new(-560210400, 2),
            Transition::new(-539125200, 1),
            Transition::new(-531352800, 2),
            Transition::new(-191365200, 1),
            Transition::new(-184197600, 2),
            Transition::new(-155163600, 1),
            Transition::new(-150069600, 2),
            Transition::new(-128898000, 1),
            Transition::new(-121125600, 2),
            Transition::new(-99954000, 1),
            Transition::new(-89589600, 2),
            Transition::new(-68418000, 1),
            Transition::new(-57967200, 2),
            Transition::new(499748400, 1),
            Transition::new(511236000, 2),
            Transition::new(530593200, 1),
            Transition::new(540266400, 2),
            Transition::new(562129200, 1),
            Transition::new(571197600, 2),
            Transition::new(592974000, 1),
            Transition::new(602042400, 2),
            Transition::new(624423600, 1),
            Transition::new(634701600, 2),
            Transition::new(938919600, 1),
            Transition::new(951616800, 2),
            Transition::new(970974000, 1),
            Transition::new(972180000, 2),
            Transition::new(1003028400, 1),
            Transition::new(1013911200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-9240, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_FORT_NELSON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713880953, 2),
            Transition::new(-1632060000, 1),
            Transition::new(-1615129200, 2),
            Transition::new(-880207200, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765385200, 2),
            Transition::new(-715788000, 1),
            Transition::new(-702486000, 2),
            Transition::new(-684338400, 1),
            Transition::new(-671036400, 2),
            Transition::new(-652888800, 1),
            Transition::new(-639586800, 2),
            Transition::new(-620834400, 1),
            Transition::new(-608137200, 2),
            Transition::new(-589384800, 1),
            Transition::new(-576082800, 2),
            Transition::new(-557935200, 1),
            Transition::new(-544633200, 2),
            Transition::new(-526485600, 1),
            Transition::new(-513183600, 2),
            Transition::new(-495036000, 1),
            Transition::new(-481734000, 2),
            Transition::new(-463586400, 1),
            Transition::new(-450284400, 2),
            Transition::new(-431532000, 1),
            Transition::new(-418230000, 2),
            Transition::new(-400082400, 1),
            Transition::new(-386780400, 2),
            Transition::new(-368632800, 1),
            Transition::new(-355330800, 2),
            Transition::new(-337183200, 1),
            Transition::new(-323881200, 2),
            Transition::new(-305733600, 1),
            Transition::new(-292431600, 2),
            Transition::new(-273679200, 1),
            Transition::new(-260982000, 2),
            Transition::new(-242229600, 1),
            Transition::new(-226508400, 2),
            Transition::new(-210780000, 1),
            Transition::new(-195058800, 2),
            Transition::new(-179330400, 1),
            Transition::new(-163609200, 2),
            Transition::new(-147880800, 1),
            Transition::new(-131554800, 2),
            Transition::new(-116431200, 1),
            Transition::new(-100105200, 2),
            Transition::new(-84376800, 1),
            Transition::new(-68655600, 2),
            Transition::new(-52927200, 1),
            Transition::new(-37206000, 2),
            Transition::new(-21477600, 1),
            Transition::new(-5756400, 2),
            Transition::new(9972000, 1),
            Transition::new(25693200, 2),
            Transition::new(41421600, 1),
            Transition::new(57747600, 2),
            Transition::new(73476000, 1),
            Transition::new(89197200, 2),
            Transition::new(104925600, 1),
            Transition::new(120646800, 2),
            Transition::new(136375200, 1),
            Transition::new(152096400, 2),
            Transition::new(167824800, 1),
            Transition::new(183546000, 2),
            Transition::new(199274400, 1),
            Transition::new(215600400, 2),
            Transition::new(230724000, 1),
            Transition::new(247050000, 2),
            Transition::new(262778400, 1),
            Transition::new(278499600, 2),
            Transition::new(294228000, 1),
            Transition::new(309949200, 2),
            Transition::new(325677600, 1),
            Transition::new(341398800, 2),
            Transition::new(357127200, 1),
            Transition::new(372848400, 2),
            Transition::new(388576800, 1),
            Transition::new(404902800, 2),
            Transition::new(420026400, 1),
            Transition::new(436352400, 2),
            Transition::new(452080800, 1),
            Transition::new(467802000, 2),
            Transition::new(483530400, 1),
            Transition::new(499251600, 2),
            Transition::new(514980000, 1),
            Transition::new(530701200, 2),
            Transition::new(544615200, 1),
            Transition::new(562150800, 2),
            Transition::new(576064800, 1),
            Transition::new(594205200, 2),
            Transition::new(607514400, 1),
            Transition::new(625654800, 2),
            Transition::new(638964000, 1),
            Transition::new(657104400, 2),
            Transition::new(671018400, 1),
            Transition::new(688554000, 2),
            Transition::new(702468000, 1),
            Transition::new(720003600, 2),
            Transition::new(733917600, 1),
            Transition::new(752058000, 2),
            Transition::new(765367200, 1),
            Transition::new(783507600, 2),
            Transition::new(796816800, 1),
            Transition::new(814957200, 2),
            Transition::new(828871200, 1),
            Transition::new(846406800, 2),
            Transition::new(860320800, 1),
            Transition::new(877856400, 2),
            Transition::new(891770400, 1),
            Transition::new(909306000, 2),
            Transition::new(923220000, 1),
            Transition::new(941360400, 2),
            Transition::new(954669600, 1),
            Transition::new(972810000, 2),
            Transition::new(986119200, 1),
            Transition::new(1004259600, 2),
            Transition::new(1018173600, 1),
            Transition::new(1035709200, 2),
            Transition::new(1049623200, 1),
            Transition::new(1067158800, 2),
            Transition::new(1081072800, 1),
            Transition::new(1099213200, 2),
            Transition::new(1112522400, 1),
            Transition::new(1130662800, 2),
            Transition::new(1143972000, 1),
            Transition::new(1162112400, 2),
            Transition::new(1173607200, 1),
            Transition::new(1194166800, 2),
            Transition::new(1205056800, 1),
            Transition::new(1225616400, 2),
            Transition::new(1236506400, 1),
            Transition::new(1257066000, 2),
            Transition::new(1268560800, 1),
            Transition::new(1289120400, 2),
            Transition::new(1300010400, 1),
            Transition::new(1320570000, 2),
            Transition::new(1331460000, 1),
            Transition::new(1352019600, 2),
            Transition::new(1362909600, 1),
            Transition::new(1383469200, 2),
            Transition::new(1394359200, 1),
            Transition::new(1414918800, 2),
            Transition::new(1425808800, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-29447, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_FORT_WAYNE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2717647200, 2),
            Transition::new(-1633276800, 1),
            Transition::new(-1615136400, 2),
            Transition::new(-1601827200, 1),
            Transition::new(-1583686800, 2),
            Transition::new(-900259200, 1),
            Transition::new(-891795600, 2),
            Transition::new(-880214400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765392400, 2),
            Transition::new(-747244800, 1),
            Transition::new(-733942800, 2),
            Transition::new(-715795200, 1),
            Transition::new(-702493200, 2),
            Transition::new(-684345600, 1),
            Transition::new(-671043600, 2),
            Transition::new(-652896000, 1),
            Transition::new(-639594000, 2),
            Transition::new(-620841600, 1),
            Transition::new(-608144400, 2),
            Transition::new(-589392000, 1),
            Transition::new(-576090000, 2),
            Transition::new(-557942400, 1),
            Transition::new(-544640400, 2),
            Transition::new(-526492800, 1),
            Transition::new(-513190800, 2),
            Transition::new(-495043200, 1),
            Transition::new(-481741200, 2),
            Transition::new(-463593600, 5),
            Transition::new(-386787600, 2),
            Transition::new(-368640000, 5),
            Transition::new(-21488400, 6),
            Transition::new(-5767200, 5),
            Transition::new(9961200, 6),
            Transition::new(25682400, 5),
            Transition::new(1143961200, 6),
            Transition::new(1162101600, 5),
            Transition::new(1173596400, 6),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(-20678, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_GLACE_BAY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2131646412, 2),
            Transition::new(-1632074400, 1),
            Transition::new(-1615143600, 2),
            Transition::new(-880221600, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765399600, 2),
            Transition::new(-526500000, 1),
            Transition::new(-513198000, 2),
            Transition::new(73461600, 1),
            Transition::new(89182800, 2),
            Transition::new(104911200, 1),
            Transition::new(120632400, 2),
            Transition::new(136360800, 1),
            Transition::new(152082000, 2),
            Transition::new(167810400, 1),
            Transition::new(183531600, 2),
            Transition::new(199260000, 1),
            Transition::new(215586000, 2),
            Transition::new(230709600, 1),
            Transition::new(247035600, 2),
            Transition::new(262764000, 1),
            Transition::new(278485200, 2),
            Transition::new(294213600, 1),
            Transition::new(309934800, 2),
            Transition::new(325663200, 1),
            Transition::new(341384400, 2),
            Transition::new(357112800, 1),
            Transition::new(372834000, 2),
            Transition::new(388562400, 1),
            Transition::new(404888400, 2),
            Transition::new(420012000, 1),
            Transition::new(436338000, 2),
            Transition::new(452066400, 1),
            Transition::new(467787600, 2),
            Transition::new(483516000, 1),
            Transition::new(499237200, 2),
            Transition::new(514965600, 1),
            Transition::new(530686800, 2),
            Transition::new(544600800, 1),
            Transition::new(562136400, 2),
            Transition::new(576050400, 1),
            Transition::new(594190800, 2),
            Transition::new(607500000, 1),
            Transition::new(625640400, 2),
            Transition::new(638949600, 1),
            Transition::new(657090000, 2),
            Transition::new(671004000, 1),
            Transition::new(688539600, 2),
            Transition::new(702453600, 1),
            Transition::new(719989200, 2),
            Transition::new(733903200, 1),
            Transition::new(752043600, 2),
            Transition::new(765352800, 1),
            Transition::new(783493200, 2),
            Transition::new(796802400, 1),
            Transition::new(814942800, 2),
            Transition::new(828856800, 1),
            Transition::new(846392400, 2),
            Transition::new(860306400, 1),
            Transition::new(877842000, 2),
            Transition::new(891756000, 1),
            Transition::new(909291600, 2),
            Transition::new(923205600, 1),
            Transition::new(941346000, 2),
            Transition::new(954655200, 1),
            Transition::new(972795600, 2),
            Transition::new(986104800, 1),
            Transition::new(1004245200, 2),
            Transition::new(1018159200, 1),
            Transition::new(1035694800, 2),
            Transition::new(1049608800, 1),
            Transition::new(1067144400, 2),
            Transition::new(1081058400, 1),
            Transition::new(1099198800, 2),
            Transition::new(1112508000, 1),
            Transition::new(1130648400, 2),
            Transition::new(1143957600, 1),
            Transition::new(1162098000, 2),
            Transition::new(1173592800, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-14388, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"AWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"APT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-14400, false, Some(b"AST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_GODTHAB: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1686083584, 1),
            Transition::new(323845200, 2),
            Transition::new(338950800, 1),
            Transition::new(354675600, 2),
            Transition::new(370400400, 1),
            Transition::new(386125200, 2),
            Transition::new(401850000, 1),
            Transition::new(417574800, 2),
            Transition::new(433299600, 1),
            Transition::new(449024400, 2),
            Transition::new(465354000, 1),
            Transition::new(481078800, 2),
            Transition::new(496803600, 1),
            Transition::new(512528400, 2),
            Transition::new(528253200, 1),
            Transition::new(543978000, 2),
            Transition::new(559702800, 1),
            Transition::new(575427600, 2),
            Transition::new(591152400, 1),
            Transition::new(606877200, 2),
            Transition::new(622602000, 1),
            Transition::new(638326800, 2),
            Transition::new(654656400, 1),
            Transition::new(670381200, 2),
            Transition::new(686106000, 1),
            Transition::new(701830800, 2),
            Transition::new(717555600, 1),
            Transition::new(733280400, 2),
            Transition::new(749005200, 1),
            Transition::new(764730000, 2),
            Transition::new(780454800, 1),
            Transition::new(796179600, 2),
            Transition::new(811904400, 1),
            Transition::new(828234000, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-12416, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-10800, false, Some(b"-03")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-7200, true, Some(b"-02")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    -7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    -3600,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_GOOSE_BAY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713895900, 1),
            Transition::new(-1632076148, 2),
            Transition::new(-1615145348, 1),
            Transition::new(-1096921748, 3),
            Transition::new(-1061670600, 4),
            Transition::new(-1048973400, 3),
            Transition::new(-1030221000, 4),
            Transition::new(-1017523800, 3),
            Transition::new(-998771400, 4),
            Transition::new(-986074200, 3),
            Transition::new(-966717000, 4),
            Transition::new(-954624600, 3),
            Transition::new(-935267400, 4),
            Transition::new(-922570200, 3),
            Transition::new(-903817800, 4),
            Transition::new(-891120600, 3),
            Transition::new(-872368200, 6),
            Transition::new(-769395600, 5),
            Transition::new(-765401400, 3),
            Transition::new(-746044200, 4),
            Transition::new(-733347000, 3),
            Transition::new(-714594600, 4),
            Transition::new(-701897400, 3),
            Transition::new(-683145000, 4),
            Transition::new(-670447800, 3),
            Transition::new(-651695400, 4),
            Transition::new(-638998200, 3),
            Transition::new(-619641000, 4),
            Transition::new(-606943800, 3),
            Transition::new(-589401000, 4),
            Transition::new(-576099000, 3),
            Transition::new(-557951400, 4),
            Transition::new(-544649400, 3),
            Transition::new(-526501800, 4),
            Transition::new(-513199800, 3),
            Transition::new(-495052200, 4),
            Transition::new(-481750200, 3),
            Transition::new(-463602600, 4),
            Transition::new(-450300600, 3),
            Transition::new(-431548200, 4),
            Transition::new(-418246200, 3),
            Transition::new(-400098600, 4),
            Transition::new(-386796600, 3),
            Transition::new(-368649000, 4),
            Transition::new(-355347000, 3),
            Transition::new(-337199400, 4),
            Transition::new(-323897400, 3),
            Transition::new(-305749800, 4),
            Transition::new(-289423800, 3),
            Transition::new(-273695400, 4),
            Transition::new(-257974200, 3),
            Transition::new(-242245800, 4),
            Transition::new(-226524600, 3),
            Transition::new(-210796200, 4),
            Transition::new(-195075000, 3),
            Transition::new(-179346600, 4),
            Transition::new(-163625400, 3),
            Transition::new(-147897000, 4),
            Transition::new(-131571000, 3),
            Transition::new(-119903400, 8),
            Transition::new(-116445600, 7),
            Transition::new(-100119600, 8),
            Transition::new(-84391200, 7),
            Transition::new(-68670000, 8),
            Transition::new(-52941600, 7),
            Transition::new(-37220400, 8),
            Transition::new(-21492000, 7),
            Transition::new(-5770800, 8),
            Transition::new(9957600, 7),
            Transition::new(25678800, 8),
            Transition::new(41407200, 7),
            Transition::new(57733200, 8),
            Transition::new(73461600, 7),
            Transition::new(89182800, 8),
            Transition::new(104911200, 7),
            Transition::new(120632400, 8),
            Transition::new(136360800, 7),
            Transition::new(152082000, 8),
            Transition::new(167810400, 7),
            Transition::new(183531600, 8),
            Transition::new(199260000, 7),
            Transition::new(215586000, 8),
            Transition::new(230709600, 7),
            Transition::new(247035600, 8),
            Transition::new(262764000, 7),
            Transition::new(278485200, 8),
            Transition::new(294213600, 7),
            Transition::new(309934800, 8),
            Transition::new(325663200, 7),
            Transition::new(341384400, 8),
            Transition::new(357112800, 7),
            Transition::new(372834000, 8),
            Transition::new(388562400, 7),
            Transition::new(404888400, 8),
            Transition::new(420012000, 7),
            Transition::new(436338000, 8),
            Transition::new(452066400, 7),
            Transition::new(467787600, 8),
            Transition::new(483516000, 7),
            Transition::new(499237200, 8),
            Transition::new(514965600, 7),
            Transition::new(530686800, 8),
            Transition::new(544593660, 7),
            Transition::new(562129260, 8),
            Transition::new(576043260, 9),
            Transition::new(594180060, 8),
            Transition::new(607492860, 7),
            Transition::new(625633260, 8),
            Transition::new(638942460, 7),
            Transition::new(657082860, 8),
            Transition::new(670996860, 7),
            Transition::new(688532460, 8),
            Transition::new(702446460, 7),
            Transition::new(719982060, 8),
            Transition::new(733896060, 7),
            Transition::new(752036460, 8),
            Transition::new(765345660, 7),
            Transition::new(783486060, 8),
            Transition::new(796795260, 7),
            Transition::new(814935660, 8),
            Transition::new(828849660, 7),
            Transition::new(846385260, 8),
            Transition::new(860299260, 7),
            Transition::new(877834860, 8),
            Transition::new(891748860, 7),
            Transition::new(909284460, 8),
            Transition::new(923198460, 7),
            Transition::new(941338860, 8),
            Transition::new(954648060, 7),
            Transition::new(972788460, 8),
            Transition::new(986097660, 7),
            Transition::new(1004238060, 8),
            Transition::new(1018152060, 7),
            Transition::new(1035687660, 8),
            Transition::new(1049601660, 7),
            Transition::new(1067137260, 8),
            Transition::new(1081051260, 7),
            Transition::new(1099191660, 8),
            Transition::new(1112500860, 7),
            Transition::new(1130641260, 8),
            Transition::new(1143950460, 7),
            Transition::new(1162090860, 8),
            Transition::new(1173585660, 7),
            Transition::new(1194145260, 8),
            Transition::new(1205035260, 7),
            Transition::new(1225594860, 8),
            Transition::new(1236484860, 7),
            Transition::new(1257044460, 8),
            Transition::new(1268539260, 7),
            Transition::new(1289098860, 8),
            Transition::new(1299988860, 7),
            Transition::new(1320555600, 8),
        ],
        &{
            const V: [LocalTimeType; 10] = [
                match LocalTimeType::new(-14500, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-12652, false, Some(b"NST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9052, true, Some(b"NDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-12600, false, Some(b"NST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9000, true, Some(b"NDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9000, true, Some(b"NPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9000, true, Some(b"NWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"ADDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-14400, false, Some(b"AST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_GRAND_TURK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524504528, 1),
            Transition::new(-1827687170, 2),
            Transition::new(294217200, 3),
            Transition::new(309938400, 2),
            Transition::new(325666800, 3),
            Transition::new(341388000, 2),
            Transition::new(357116400, 3),
            Transition::new(372837600, 2),
            Transition::new(388566000, 3),
            Transition::new(404892000, 2),
            Transition::new(420015600, 3),
            Transition::new(436341600, 2),
            Transition::new(452070000, 3),
            Transition::new(467791200, 2),
            Transition::new(483519600, 3),
            Transition::new(499240800, 2),
            Transition::new(514969200, 3),
            Transition::new(530690400, 2),
            Transition::new(544604400, 3),
            Transition::new(562140000, 2),
            Transition::new(576054000, 3),
            Transition::new(594194400, 2),
            Transition::new(607503600, 3),
            Transition::new(625644000, 2),
            Transition::new(638953200, 3),
            Transition::new(657093600, 2),
            Transition::new(671007600, 3),
            Transition::new(688543200, 2),
            Transition::new(702457200, 3),
            Transition::new(719992800, 2),
            Transition::new(733906800, 3),
            Transition::new(752047200, 2),
            Transition::new(765356400, 3),
            Transition::new(783496800, 2),
            Transition::new(796806000, 3),
            Transition::new(814946400, 2),
            Transition::new(828860400, 3),
            Transition::new(846396000, 2),
            Transition::new(860310000, 3),
            Transition::new(877845600, 2),
            Transition::new(891759600, 3),
            Transition::new(909295200, 2),
            Transition::new(923209200, 3),
            Transition::new(941349600, 2),
            Transition::new(954658800, 3),
            Transition::new(972799200, 2),
            Transition::new(986108400, 3),
            Transition::new(1004248800, 2),
            Transition::new(1018162800, 3),
            Transition::new(1035698400, 2),
            Transition::new(1049612400, 3),
            Transition::new(1067148000, 2),
            Transition::new(1081062000, 3),
            Transition::new(1099202400, 2),
            Transition::new(1112511600, 3),
            Transition::new(1130652000, 2),
            Transition::new(1143961200, 3),
            Transition::new(1162101600, 2),
            Transition::new(1173596400, 3),
            Transition::new(1194156000, 2),
            Transition::new(1205046000, 3),
            Transition::new(1225605600, 2),
            Transition::new(1236495600, 3),
            Transition::new(1257055200, 2),
            Transition::new(1268550000, 3),
            Transition::new(1289109600, 2),
            Transition::new(1299999600, 3),
            Transition::new(1320559200, 2),
            Transition::new(1331449200, 3),
            Transition::new(1352008800, 2),
            Transition::new(1362898800, 3),
            Transition::new(1383458400, 2),
            Transition::new(1394348400, 3),
            Transition::new(1414908000, 2),
            Transition::new(1425798000, 4),
            Transition::new(1520751600, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-17072, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18430, false, Some(b"KMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_GUATEMALA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1617040676, 2),
            Transition::new(123055200, 1),
            Transition::new(130914000, 2),
            Transition::new(422344800, 1),
            Transition::new(433054800, 2),
            Transition::new(669708000, 1),
            Transition::new(684219600, 2),
            Transition::new(1146376800, 1),
            Transition::new(1159678800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-21724, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_GUAYAQUIL: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524502440, 1),
            Transition::new(-1230749160, 3),
            Transition::new(722926800, 2),
            Transition::new(728884800, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-19160, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18840, false, Some(b"QMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_GUYANA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1843589241, 1),
            Transition::new(-1730577600, 2),
            Transition::new(176096700, 3),
            Transition::new(701841600, 1),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-13959, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-13500, false, Some(b"-0345")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_HALIFAX: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2131645536, 2),
            Transition::new(-1696276800, 1),
            Transition::new(-1680469200, 2),
            Transition::new(-1632074400, 1),
            Transition::new(-1615143600, 2),
            Transition::new(-1566763200, 1),
            Transition::new(-1557090000, 2),
            Transition::new(-1535486400, 1),
            Transition::new(-1524949200, 2),
            Transition::new(-1504468800, 1),
            Transition::new(-1493413200, 2),
            Transition::new(-1472414400, 1),
            Transition::new(-1461963600, 2),
            Transition::new(-1440964800, 1),
            Transition::new(-1429390800, 2),
            Transition::new(-1409515200, 1),
            Transition::new(-1396731600, 2),
            Transition::new(-1376856000, 1),
            Transition::new(-1366491600, 2),
            Transition::new(-1346616000, 1),
            Transition::new(-1333832400, 2),
            Transition::new(-1313956800, 1),
            Transition::new(-1303678800, 2),
            Transition::new(-1282507200, 1),
            Transition::new(-1272661200, 2),
            Transition::new(-1251057600, 1),
            Transition::new(-1240088400, 2),
            Transition::new(-1219608000, 1),
            Transition::new(-1207429200, 2),
            Transition::new(-1188763200, 1),
            Transition::new(-1175979600, 2),
            Transition::new(-1157313600, 1),
            Transition::new(-1143925200, 2),
            Transition::new(-1124049600, 1),
            Transition::new(-1113771600, 2),
            Transition::new(-1091390400, 1),
            Transition::new(-1081026000, 2),
            Transition::new(-1059854400, 1),
            Transition::new(-1050786000, 2),
            Transition::new(-1030910400, 1),
            Transition::new(-1018126800, 2),
            Transition::new(-999460800, 1),
            Transition::new(-986677200, 2),
            Transition::new(-965592000, 1),
            Transition::new(-955227600, 2),
            Transition::new(-935956800, 1),
            Transition::new(-923173200, 2),
            Transition::new(-904507200, 1),
            Transition::new(-891723600, 2),
            Transition::new(-880221600, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765399600, 2),
            Transition::new(-747252000, 1),
            Transition::new(-733950000, 2),
            Transition::new(-715802400, 1),
            Transition::new(-702500400, 2),
            Transition::new(-684352800, 1),
            Transition::new(-671050800, 2),
            Transition::new(-652903200, 1),
            Transition::new(-639601200, 2),
            Transition::new(-589399200, 1),
            Transition::new(-576097200, 2),
            Transition::new(-557949600, 1),
            Transition::new(-544647600, 2),
            Transition::new(-526500000, 1),
            Transition::new(-513198000, 2),
            Transition::new(-495050400, 1),
            Transition::new(-481748400, 2),
            Transition::new(-431546400, 1),
            Transition::new(-418244400, 2),
            Transition::new(-400096800, 1),
            Transition::new(-386794800, 2),
            Transition::new(-368647200, 1),
            Transition::new(-355345200, 2),
            Transition::new(-337197600, 1),
            Transition::new(-323895600, 2),
            Transition::new(-242244000, 1),
            Transition::new(-226522800, 2),
            Transition::new(-210794400, 1),
            Transition::new(-195073200, 2),
            Transition::new(-179344800, 1),
            Transition::new(-163623600, 2),
            Transition::new(-147895200, 1),
            Transition::new(-131569200, 2),
            Transition::new(-116445600, 1),
            Transition::new(-100119600, 2),
            Transition::new(-84391200, 1),
            Transition::new(-68670000, 2),
            Transition::new(-52941600, 1),
            Transition::new(-37220400, 2),
            Transition::new(-21492000, 1),
            Transition::new(-5770800, 2),
            Transition::new(9957600, 1),
            Transition::new(25678800, 2),
            Transition::new(41407200, 1),
            Transition::new(57733200, 2),
            Transition::new(73461600, 1),
            Transition::new(89182800, 2),
            Transition::new(104911200, 1),
            Transition::new(120632400, 2),
            Transition::new(136360800, 1),
            Transition::new(152082000, 2),
            Transition::new(167810400, 1),
            Transition::new(183531600, 2),
            Transition::new(199260000, 1),
            Transition::new(215586000, 2),
            Transition::new(230709600, 1),
            Transition::new(247035600, 2),
            Transition::new(262764000, 1),
            Transition::new(278485200, 2),
            Transition::new(294213600, 1),
            Transition::new(309934800, 2),
            Transition::new(325663200, 1),
            Transition::new(341384400, 2),
            Transition::new(357112800, 1),
            Transition::new(372834000, 2),
            Transition::new(388562400, 1),
            Transition::new(404888400, 2),
            Transition::new(420012000, 1),
            Transition::new(436338000, 2),
            Transition::new(452066400, 1),
            Transition::new(467787600, 2),
            Transition::new(483516000, 1),
            Transition::new(499237200, 2),
            Transition::new(514965600, 1),
            Transition::new(530686800, 2),
            Transition::new(544600800, 1),
            Transition::new(562136400, 2),
            Transition::new(576050400, 1),
            Transition::new(594190800, 2),
            Transition::new(607500000, 1),
            Transition::new(625640400, 2),
            Transition::new(638949600, 1),
            Transition::new(657090000, 2),
            Transition::new(671004000, 1),
            Transition::new(688539600, 2),
            Transition::new(702453600, 1),
            Transition::new(719989200, 2),
            Transition::new(733903200, 1),
            Transition::new(752043600, 2),
            Transition::new(765352800, 1),
            Transition::new(783493200, 2),
            Transition::new(796802400, 1),
            Transition::new(814942800, 2),
            Transition::new(828856800, 1),
            Transition::new(846392400, 2),
            Transition::new(860306400, 1),
            Transition::new(877842000, 2),
            Transition::new(891756000, 1),
            Transition::new(909291600, 2),
            Transition::new(923205600, 1),
            Transition::new(941346000, 2),
            Transition::new(954655200, 1),
            Transition::new(972795600, 2),
            Transition::new(986104800, 1),
            Transition::new(1004245200, 2),
            Transition::new(1018159200, 1),
            Transition::new(1035694800, 2),
            Transition::new(1049608800, 1),
            Transition::new(1067144400, 2),
            Transition::new(1081058400, 1),
            Transition::new(1099198800, 2),
            Transition::new(1112508000, 1),
            Transition::new(1130648400, 2),
            Transition::new(1143957600, 1),
            Transition::new(1162098000, 2),
            Transition::new(1173592800, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-15264, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"AWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"APT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-14400, false, Some(b"AST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_HERMOSILLO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514739600, 1),
            Transition::new(-1343066400, 2),
            Transition::new(-1234807200, 1),
            Transition::new(-1220292000, 2),
            Transition::new(-1207159200, 1),
            Transition::new(-1191344400, 2),
            Transition::new(-873828000, 1),
            Transition::new(-661539600, 3),
            Transition::new(28800, 1),
            Transition::new(828867600, 4),
            Transition::new(846403200, 1),
            Transition::new(860317200, 4),
            Transition::new(877852800, 1),
            Transition::new(891766800, 4),
            Transition::new(909302400, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-26632, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_INUVIK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-536457600, 2),
            Transition::new(-147888000, 1),
            Transition::new(-131558400, 2),
            Transition::new(294228000, 3),
            Transition::new(325674000, 4),
            Transition::new(341395200, 3),
            Transition::new(357123600, 4),
            Transition::new(372844800, 3),
            Transition::new(388573200, 4),
            Transition::new(404899200, 3),
            Transition::new(420022800, 4),
            Transition::new(436348800, 3),
            Transition::new(452077200, 4),
            Transition::new(467798400, 3),
            Transition::new(483526800, 4),
            Transition::new(499248000, 3),
            Transition::new(514976400, 4),
            Transition::new(530697600, 3),
            Transition::new(544611600, 4),
            Transition::new(562147200, 3),
            Transition::new(576061200, 4),
            Transition::new(594201600, 3),
            Transition::new(607510800, 4),
            Transition::new(625651200, 3),
            Transition::new(638960400, 4),
            Transition::new(657100800, 3),
            Transition::new(671014800, 4),
            Transition::new(688550400, 3),
            Transition::new(702464400, 4),
            Transition::new(720000000, 3),
            Transition::new(733914000, 4),
            Transition::new(752054400, 3),
            Transition::new(765363600, 4),
            Transition::new(783504000, 3),
            Transition::new(796813200, 4),
            Transition::new(814953600, 3),
            Transition::new(828867600, 4),
            Transition::new(846403200, 3),
            Transition::new(860317200, 4),
            Transition::new(877852800, 3),
            Transition::new(891766800, 4),
            Transition::new(909302400, 3),
            Transition::new(923216400, 4),
            Transition::new(941356800, 3),
            Transition::new(954666000, 4),
            Transition::new(972806400, 3),
            Transition::new(986115600, 4),
            Transition::new(1004256000, 3),
            Transition::new(1018170000, 4),
            Transition::new(1035705600, 3),
            Transition::new(1049619600, 4),
            Transition::new(1067155200, 3),
            Transition::new(1081069200, 4),
            Transition::new(1099209600, 3),
            Transition::new(1112518800, 4),
            Transition::new(1130659200, 3),
            Transition::new(1143968400, 4),
            Transition::new(1162108800, 3),
            Transition::new(1173603600, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"PDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_IQALUIT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-865296000, 5),
            Transition::new(-769395600, 1),
            Transition::new(-765396000, 2),
            Transition::new(-147898800, 3),
            Transition::new(-131569200, 2),
            Transition::new(325666800, 4),
            Transition::new(341388000, 2),
            Transition::new(357116400, 4),
            Transition::new(372837600, 2),
            Transition::new(388566000, 4),
            Transition::new(404892000, 2),
            Transition::new(420015600, 4),
            Transition::new(436341600, 2),
            Transition::new(452070000, 4),
            Transition::new(467791200, 2),
            Transition::new(483519600, 4),
            Transition::new(499240800, 2),
            Transition::new(514969200, 4),
            Transition::new(530690400, 2),
            Transition::new(544604400, 4),
            Transition::new(562140000, 2),
            Transition::new(576054000, 4),
            Transition::new(594194400, 2),
            Transition::new(607503600, 4),
            Transition::new(625644000, 2),
            Transition::new(638953200, 4),
            Transition::new(657093600, 2),
            Transition::new(671007600, 4),
            Transition::new(688543200, 2),
            Transition::new(702457200, 4),
            Transition::new(719992800, 2),
            Transition::new(733906800, 4),
            Transition::new(752047200, 2),
            Transition::new(765356400, 4),
            Transition::new(783496800, 2),
            Transition::new(796806000, 4),
            Transition::new(814946400, 2),
            Transition::new(828860400, 4),
            Transition::new(846396000, 2),
            Transition::new(860310000, 4),
            Transition::new(877845600, 2),
            Transition::new(891759600, 4),
            Transition::new(909295200, 2),
            Transition::new(923209200, 4),
            Transition::new(941349600, 6),
            Transition::new(954662400, 7),
            Transition::new(972802800, 2),
            Transition::new(986108400, 4),
            Transition::new(1004248800, 2),
            Transition::new(1018162800, 4),
            Transition::new(1035698400, 2),
            Transition::new(1049612400, 4),
            Transition::new(1067148000, 2),
            Transition::new(1081062000, 4),
            Transition::new(1099202400, 2),
            Transition::new(1112511600, 4),
            Transition::new(1130652000, 2),
            Transition::new(1143961200, 4),
            Transition::new(1162101600, 2),
            Transition::new(1173596400, 4),
        ],
        &{
            const V: [LocalTimeType; 8] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"EDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_JUJUY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2372096328, 1),
            Transition::new(-1567453392, 2),
            Transition::new(-1233432000, 3),
            Transition::new(-1222981200, 2),
            Transition::new(-1205956800, 3),
            Transition::new(-1194037200, 2),
            Transition::new(-1172865600, 3),
            Transition::new(-1162501200, 2),
            Transition::new(-1141329600, 3),
            Transition::new(-1130965200, 2),
            Transition::new(-1109793600, 3),
            Transition::new(-1099429200, 2),
            Transition::new(-1078257600, 3),
            Transition::new(-1067806800, 2),
            Transition::new(-1046635200, 3),
            Transition::new(-1036270800, 2),
            Transition::new(-1015099200, 3),
            Transition::new(-1004734800, 2),
            Transition::new(-983563200, 3),
            Transition::new(-973198800, 2),
            Transition::new(-952027200, 3),
            Transition::new(-941576400, 2),
            Transition::new(-931032000, 3),
            Transition::new(-900882000, 2),
            Transition::new(-890337600, 3),
            Transition::new(-833749200, 2),
            Transition::new(-827265600, 3),
            Transition::new(-752274000, 2),
            Transition::new(-733780800, 3),
            Transition::new(-197326800, 2),
            Transition::new(-190843200, 3),
            Transition::new(-184194000, 2),
            Transition::new(-164491200, 3),
            Transition::new(-152658000, 2),
            Transition::new(-132955200, 3),
            Transition::new(-121122000, 2),
            Transition::new(-101419200, 3),
            Transition::new(-86821200, 2),
            Transition::new(-71092800, 3),
            Transition::new(-54766800, 2),
            Transition::new(-39038400, 3),
            Transition::new(-23317200, 2),
            Transition::new(-7588800, 5),
            Transition::new(128142000, 4),
            Transition::new(136605600, 5),
            Transition::new(596948400, 4),
            Transition::new(605066400, 5),
            Transition::new(624423600, 4),
            Transition::new(636516000, 2),
            Transition::new(657086400, 3),
            Transition::new(669178800, 2),
            Transition::new(686721600, 4),
            Transition::new(699415200, 5),
            Transition::new(719377200, 4),
            Transition::new(731469600, 5),
            Transition::new(938919600, 3),
            Transition::new(952052400, 5),
            Transition::new(1198983600, 4),
            Transition::new(1205632800, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-15672, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-15408, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_JUNEAU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3225223727, 1),
            Transition::new(-2188954939, 2),
            Transition::new(-880207200, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765385200, 2),
            Transition::new(-21477600, 5),
            Transition::new(-5756400, 2),
            Transition::new(9972000, 5),
            Transition::new(25693200, 2),
            Transition::new(41421600, 5),
            Transition::new(57747600, 2),
            Transition::new(73476000, 5),
            Transition::new(89197200, 2),
            Transition::new(104925600, 5),
            Transition::new(120646800, 2),
            Transition::new(126698400, 5),
            Transition::new(152096400, 2),
            Transition::new(162381600, 5),
            Transition::new(183546000, 2),
            Transition::new(199274400, 5),
            Transition::new(215600400, 2),
            Transition::new(230724000, 5),
            Transition::new(247050000, 2),
            Transition::new(262778400, 5),
            Transition::new(278499600, 2),
            Transition::new(294228000, 5),
            Transition::new(309949200, 2),
            Transition::new(325677600, 6),
            Transition::new(341402400, 2),
            Transition::new(357127200, 5),
            Transition::new(372848400, 2),
            Transition::new(388576800, 5),
            Transition::new(404902800, 2),
            Transition::new(420026400, 5),
            Transition::new(436352400, 7),
            Transition::new(439030800, 9),
            Transition::new(452084400, 8),
            Transition::new(467805600, 9),
            Transition::new(483534000, 8),
            Transition::new(499255200, 9),
            Transition::new(514983600, 8),
            Transition::new(530704800, 9),
            Transition::new(544618800, 8),
            Transition::new(562154400, 9),
            Transition::new(576068400, 8),
            Transition::new(594208800, 9),
            Transition::new(607518000, 8),
            Transition::new(625658400, 9),
            Transition::new(638967600, 8),
            Transition::new(657108000, 9),
            Transition::new(671022000, 8),
            Transition::new(688557600, 9),
            Transition::new(702471600, 8),
            Transition::new(720007200, 9),
            Transition::new(733921200, 8),
            Transition::new(752061600, 9),
            Transition::new(765370800, 8),
            Transition::new(783511200, 9),
            Transition::new(796820400, 8),
            Transition::new(814960800, 9),
            Transition::new(828874800, 8),
            Transition::new(846410400, 9),
            Transition::new(860324400, 8),
            Transition::new(877860000, 9),
            Transition::new(891774000, 8),
            Transition::new(909309600, 9),
            Transition::new(923223600, 8),
            Transition::new(941364000, 9),
            Transition::new(954673200, 8),
            Transition::new(972813600, 9),
            Transition::new(986122800, 8),
            Transition::new(1004263200, 9),
            Transition::new(1018177200, 8),
            Transition::new(1035712800, 9),
            Transition::new(1049626800, 8),
            Transition::new(1067162400, 9),
            Transition::new(1081076400, 8),
            Transition::new(1099216800, 9),
            Transition::new(1112526000, 8),
            Transition::new(1130666400, 9),
            Transition::new(1143975600, 8),
            Transition::new(1162116000, 9),
            Transition::new(1173610800, 8),
        ],
        &{
            const V: [LocalTimeType; 10] = [
                match LocalTimeType::new(54139, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32261, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"YST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_KNOX_IN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2717647200, 2),
            Transition::new(-1633276800, 1),
            Transition::new(-1615136400, 2),
            Transition::new(-1601827200, 1),
            Transition::new(-1583686800, 2),
            Transition::new(-880214400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765392400, 2),
            Transition::new(-715795200, 1),
            Transition::new(-702493200, 2),
            Transition::new(-684345600, 1),
            Transition::new(-671043600, 2),
            Transition::new(-652896000, 1),
            Transition::new(-639594000, 2),
            Transition::new(-620841600, 1),
            Transition::new(-608144400, 2),
            Transition::new(-589392000, 1),
            Transition::new(-576090000, 2),
            Transition::new(-557942400, 1),
            Transition::new(-544640400, 2),
            Transition::new(-526492800, 1),
            Transition::new(-513190800, 2),
            Transition::new(-495043200, 1),
            Transition::new(-481741200, 2),
            Transition::new(-463593600, 1),
            Transition::new(-447267600, 2),
            Transition::new(-431539200, 1),
            Transition::new(-415818000, 2),
            Transition::new(-400089600, 1),
            Transition::new(-386787600, 2),
            Transition::new(-368640000, 1),
            Transition::new(-355338000, 2),
            Transition::new(-337190400, 1),
            Transition::new(-321469200, 2),
            Transition::new(-305740800, 1),
            Transition::new(-289414800, 2),
            Transition::new(-273686400, 1),
            Transition::new(-257965200, 2),
            Transition::new(-242236800, 5),
            Transition::new(-195066000, 2),
            Transition::new(-84384000, 1),
            Transition::new(-68662800, 2),
            Transition::new(-52934400, 1),
            Transition::new(-37213200, 2),
            Transition::new(-21484800, 1),
            Transition::new(-5763600, 2),
            Transition::new(9964800, 1),
            Transition::new(25686000, 2),
            Transition::new(41414400, 1),
            Transition::new(57740400, 2),
            Transition::new(73468800, 1),
            Transition::new(89190000, 2),
            Transition::new(104918400, 1),
            Transition::new(120639600, 2),
            Transition::new(126691200, 1),
            Transition::new(152089200, 2),
            Transition::new(162374400, 1),
            Transition::new(183538800, 2),
            Transition::new(199267200, 1),
            Transition::new(215593200, 2),
            Transition::new(230716800, 1),
            Transition::new(247042800, 2),
            Transition::new(262771200, 1),
            Transition::new(278492400, 2),
            Transition::new(294220800, 1),
            Transition::new(309942000, 2),
            Transition::new(325670400, 1),
            Transition::new(341391600, 2),
            Transition::new(357120000, 1),
            Transition::new(372841200, 2),
            Transition::new(388569600, 1),
            Transition::new(404895600, 2),
            Transition::new(420019200, 1),
            Transition::new(436345200, 2),
            Transition::new(452073600, 1),
            Transition::new(467794800, 2),
            Transition::new(483523200, 1),
            Transition::new(499244400, 2),
            Transition::new(514972800, 1),
            Transition::new(530694000, 2),
            Transition::new(544608000, 1),
            Transition::new(562143600, 2),
            Transition::new(576057600, 1),
            Transition::new(594198000, 2),
            Transition::new(607507200, 1),
            Transition::new(625647600, 2),
            Transition::new(638956800, 1),
            Transition::new(657097200, 2),
            Transition::new(671011200, 1),
            Transition::new(688546800, 5),
            Transition::new(1143961200, 1),
            Transition::new(1162105200, 2),
            Transition::new(1173600000, 1),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-20790, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_LA_PAZ: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524505244, 1),
            Transition::new(-1205954844, 2),
            Transition::new(-1192307244, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-16356, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-16356, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-12756, true, Some(b"BST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_LIMA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524503108, 1),
            Transition::new(-1938538284, 3),
            Transition::new(-1009825200, 2),
            Transition::new(-1002052800, 3),
            Transition::new(-986756400, 2),
            Transition::new(-971035200, 3),
            Transition::new(-955306800, 2),
            Transition::new(-939585600, 3),
            Transition::new(504939600, 2),
            Transition::new(512712000, 3),
            Transition::new(536475600, 2),
            Transition::new(544248000, 3),
            Transition::new(631170000, 2),
            Transition::new(638942400, 3),
            Transition::new(757400400, 2),
            Transition::new(765172800, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-18492, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18516, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_LOS_ANGELES: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2717640000, 2),
            Transition::new(-1633269600, 1),
            Transition::new(-1615129200, 2),
            Transition::new(-1601820000, 1),
            Transition::new(-1583679600, 2),
            Transition::new(-880207200, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765385200, 2),
            Transition::new(-687967140, 1),
            Transition::new(-662655600, 2),
            Transition::new(-620838000, 1),
            Transition::new(-608137200, 2),
            Transition::new(-589388400, 1),
            Transition::new(-576082800, 2),
            Transition::new(-557938800, 1),
            Transition::new(-544633200, 2),
            Transition::new(-526489200, 1),
            Transition::new(-513183600, 2),
            Transition::new(-495039600, 1),
            Transition::new(-481734000, 2),
            Transition::new(-463590000, 1),
            Transition::new(-450284400, 2),
            Transition::new(-431535600, 1),
            Transition::new(-418230000, 2),
            Transition::new(-400086000, 1),
            Transition::new(-386780400, 2),
            Transition::new(-368636400, 1),
            Transition::new(-355330800, 2),
            Transition::new(-337186800, 1),
            Transition::new(-323881200, 2),
            Transition::new(-305737200, 1),
            Transition::new(-292431600, 2),
            Transition::new(-273682800, 1),
            Transition::new(-260982000, 2),
            Transition::new(-242233200, 1),
            Transition::new(-226508400, 2),
            Transition::new(-210783600, 1),
            Transition::new(-195058800, 2),
            Transition::new(-179334000, 1),
            Transition::new(-163609200, 2),
            Transition::new(-147884400, 1),
            Transition::new(-131554800, 2),
            Transition::new(-116434800, 1),
            Transition::new(-100105200, 2),
            Transition::new(-84376800, 1),
            Transition::new(-68655600, 2),
            Transition::new(-52927200, 1),
            Transition::new(-37206000, 2),
            Transition::new(-21477600, 1),
            Transition::new(-5756400, 2),
            Transition::new(9972000, 1),
            Transition::new(25693200, 2),
            Transition::new(41421600, 1),
            Transition::new(57747600, 2),
            Transition::new(73476000, 1),
            Transition::new(89197200, 2),
            Transition::new(104925600, 1),
            Transition::new(120646800, 2),
            Transition::new(126698400, 1),
            Transition::new(152096400, 2),
            Transition::new(162381600, 1),
            Transition::new(183546000, 2),
            Transition::new(199274400, 1),
            Transition::new(215600400, 2),
            Transition::new(230724000, 1),
            Transition::new(247050000, 2),
            Transition::new(262778400, 1),
            Transition::new(278499600, 2),
            Transition::new(294228000, 1),
            Transition::new(309949200, 2),
            Transition::new(325677600, 1),
            Transition::new(341398800, 2),
            Transition::new(357127200, 1),
            Transition::new(372848400, 2),
            Transition::new(388576800, 1),
            Transition::new(404902800, 2),
            Transition::new(420026400, 1),
            Transition::new(436352400, 2),
            Transition::new(452080800, 1),
            Transition::new(467802000, 2),
            Transition::new(483530400, 1),
            Transition::new(499251600, 2),
            Transition::new(514980000, 1),
            Transition::new(530701200, 2),
            Transition::new(544615200, 1),
            Transition::new(562150800, 2),
            Transition::new(576064800, 1),
            Transition::new(594205200, 2),
            Transition::new(607514400, 1),
            Transition::new(625654800, 2),
            Transition::new(638964000, 1),
            Transition::new(657104400, 2),
            Transition::new(671018400, 1),
            Transition::new(688554000, 2),
            Transition::new(702468000, 1),
            Transition::new(720003600, 2),
            Transition::new(733917600, 1),
            Transition::new(752058000, 2),
            Transition::new(765367200, 1),
            Transition::new(783507600, 2),
            Transition::new(796816800, 1),
            Transition::new(814957200, 2),
            Transition::new(828871200, 1),
            Transition::new(846406800, 2),
            Transition::new(860320800, 1),
            Transition::new(877856400, 2),
            Transition::new(891770400, 1),
            Transition::new(909306000, 2),
            Transition::new(923220000, 1),
            Transition::new(941360400, 2),
            Transition::new(954669600, 1),
            Transition::new(972810000, 2),
            Transition::new(986119200, 1),
            Transition::new(1004259600, 2),
            Transition::new(1018173600, 1),
            Transition::new(1035709200, 2),
            Transition::new(1049623200, 1),
            Transition::new(1067158800, 2),
            Transition::new(1081072800, 1),
            Transition::new(1099213200, 2),
            Transition::new(1112522400, 1),
            Transition::new(1130662800, 2),
            Transition::new(1143972000, 1),
            Transition::new(1162112400, 2),
            Transition::new(1173607200, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-28378, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-28800, false, Some(b"PST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_LOUISVILLE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2717647200, 2),
            Transition::new(-1633276800, 1),
            Transition::new(-1615136400, 2),
            Transition::new(-1601827200, 1),
            Transition::new(-1583686800, 2),
            Transition::new(-1535904000, 1),
            Transition::new(-1525280400, 2),
            Transition::new(-905097600, 1),
            Transition::new(-891795600, 2),
            Transition::new(-880214400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765392400, 2),
            Transition::new(-747251940, 1),
            Transition::new(-744224400, 2),
            Transition::new(-620841600, 1),
            Transition::new(-608144400, 2),
            Transition::new(-589392000, 1),
            Transition::new(-576090000, 2),
            Transition::new(-557942400, 1),
            Transition::new(-544640400, 2),
            Transition::new(-526492800, 1),
            Transition::new(-513190800, 2),
            Transition::new(-495043200, 1),
            Transition::new(-481741200, 2),
            Transition::new(-463593600, 1),
            Transition::new(-450291600, 2),
            Transition::new(-431539200, 1),
            Transition::new(-415818000, 2),
            Transition::new(-400089600, 1),
            Transition::new(-384368400, 2),
            Transition::new(-368640000, 1),
            Transition::new(-352918800, 2),
            Transition::new(-337190400, 1),
            Transition::new(-321469200, 2),
            Transition::new(-305740800, 1),
            Transition::new(-289414800, 2),
            Transition::new(-273686400, 1),
            Transition::new(-266432400, 5),
            Transition::new(-52938000, 6),
            Transition::new(-37216800, 5),
            Transition::new(-21488400, 6),
            Transition::new(-5767200, 5),
            Transition::new(9961200, 6),
            Transition::new(25682400, 5),
            Transition::new(41410800, 6),
            Transition::new(57736800, 5),
            Transition::new(73465200, 6),
            Transition::new(89186400, 5),
            Transition::new(104914800, 6),
            Transition::new(120636000, 5),
            Transition::new(126687600, 1),
            Transition::new(152089200, 5),
            Transition::new(162370800, 6),
            Transition::new(183535200, 5),
            Transition::new(199263600, 6),
            Transition::new(215589600, 5),
            Transition::new(230713200, 6),
            Transition::new(247039200, 5),
            Transition::new(262767600, 6),
            Transition::new(278488800, 5),
            Transition::new(294217200, 6),
            Transition::new(309938400, 5),
            Transition::new(325666800, 6),
            Transition::new(341388000, 5),
            Transition::new(357116400, 6),
            Transition::new(372837600, 5),
            Transition::new(388566000, 6),
            Transition::new(404892000, 5),
            Transition::new(420015600, 6),
            Transition::new(436341600, 5),
            Transition::new(452070000, 6),
            Transition::new(467791200, 5),
            Transition::new(483519600, 6),
            Transition::new(499240800, 5),
            Transition::new(514969200, 6),
            Transition::new(530690400, 5),
            Transition::new(544604400, 6),
            Transition::new(562140000, 5),
            Transition::new(576054000, 6),
            Transition::new(594194400, 5),
            Transition::new(607503600, 6),
            Transition::new(625644000, 5),
            Transition::new(638953200, 6),
            Transition::new(657093600, 5),
            Transition::new(671007600, 6),
            Transition::new(688543200, 5),
            Transition::new(702457200, 6),
            Transition::new(719992800, 5),
            Transition::new(733906800, 6),
            Transition::new(752047200, 5),
            Transition::new(765356400, 6),
            Transition::new(783496800, 5),
            Transition::new(796806000, 6),
            Transition::new(814946400, 5),
            Transition::new(828860400, 6),
            Transition::new(846396000, 5),
            Transition::new(860310000, 6),
            Transition::new(877845600, 5),
            Transition::new(891759600, 6),
            Transition::new(909295200, 5),
            Transition::new(923209200, 6),
            Transition::new(941349600, 5),
            Transition::new(954658800, 6),
            Transition::new(972799200, 5),
            Transition::new(986108400, 6),
            Transition::new(1004248800, 5),
            Transition::new(1018162800, 6),
            Transition::new(1035698400, 5),
            Transition::new(1049612400, 6),
            Transition::new(1067148000, 5),
            Transition::new(1081062000, 6),
            Transition::new(1099202400, 5),
            Transition::new(1112511600, 6),
            Transition::new(1130652000, 5),
            Transition::new(1143961200, 6),
            Transition::new(1162101600, 5),
            Transition::new(1173596400, 6),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(-20582, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MACEIO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767217028, 2),
            Transition::new(-1206957600, 1),
            Transition::new(-1191362400, 2),
            Transition::new(-1175374800, 1),
            Transition::new(-1159826400, 2),
            Transition::new(-633819600, 1),
            Transition::new(-622069200, 2),
            Transition::new(-602283600, 1),
            Transition::new(-591832800, 2),
            Transition::new(-570747600, 1),
            Transition::new(-560210400, 2),
            Transition::new(-539125200, 1),
            Transition::new(-531352800, 2),
            Transition::new(-191365200, 1),
            Transition::new(-184197600, 2),
            Transition::new(-155163600, 1),
            Transition::new(-150069600, 2),
            Transition::new(-128898000, 1),
            Transition::new(-121125600, 2),
            Transition::new(-99954000, 1),
            Transition::new(-89589600, 2),
            Transition::new(-68418000, 1),
            Transition::new(-57967200, 2),
            Transition::new(499748400, 1),
            Transition::new(511236000, 2),
            Transition::new(530593200, 1),
            Transition::new(540266400, 2),
            Transition::new(562129200, 1),
            Transition::new(571197600, 2),
            Transition::new(592974000, 1),
            Transition::new(602042400, 2),
            Transition::new(624423600, 1),
            Transition::new(634701600, 2),
            Transition::new(813726000, 1),
            Transition::new(824004000, 2),
            Transition::new(938919600, 1),
            Transition::new(951616800, 2),
            Transition::new(970974000, 1),
            Transition::new(972180000, 2),
            Transition::new(1003028400, 1),
            Transition::new(1013911200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-8572, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MANAGUA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524500892, 1),
            Transition::new(-1121105688, 2),
            Transition::new(105084000, 3),
            Transition::new(161758800, 2),
            Transition::new(290584800, 4),
            Transition::new(299134800, 2),
            Transition::new(322034400, 4),
            Transition::new(330584400, 2),
            Transition::new(694260000, 3),
            Transition::new(717310800, 2),
            Transition::new(725868000, 3),
            Transition::new(852094800, 2),
            Transition::new(1113112800, 4),
            Transition::new(1128229200, 2),
            Transition::new(1146384000, 4),
            Transition::new(1159682400, 2),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-20708, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-20712, false, Some(b"MMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MANAUS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767211196, 2),
            Transition::new(-1206954000, 1),
            Transition::new(-1191358800, 2),
            Transition::new(-1175371200, 1),
            Transition::new(-1159822800, 2),
            Transition::new(-633816000, 1),
            Transition::new(-622065600, 2),
            Transition::new(-602280000, 1),
            Transition::new(-591829200, 2),
            Transition::new(-570744000, 1),
            Transition::new(-560206800, 2),
            Transition::new(-539121600, 1),
            Transition::new(-531349200, 2),
            Transition::new(-191361600, 1),
            Transition::new(-184194000, 2),
            Transition::new(-155160000, 1),
            Transition::new(-150066000, 2),
            Transition::new(-128894400, 1),
            Transition::new(-121122000, 2),
            Transition::new(-99950400, 1),
            Transition::new(-89586000, 2),
            Transition::new(-68414400, 1),
            Transition::new(-57963600, 2),
            Transition::new(499752000, 1),
            Transition::new(511239600, 2),
            Transition::new(530596800, 1),
            Transition::new(540270000, 2),
            Transition::new(562132800, 1),
            Transition::new(571201200, 2),
            Transition::new(750830400, 1),
            Transition::new(761713200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-14404, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MARTINIQUE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524506940, 1),
            Transition::new(-1851537340, 2),
            Transition::new(323841600, 3),
            Transition::new(338958000, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-14660, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14660, false, Some(b"FFMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MATAMOROS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514743200, 1),
            Transition::new(576057600, 2),
            Transition::new(594198000, 1),
            Transition::new(828864000, 2),
            Transition::new(846399600, 1),
            Transition::new(860313600, 2),
            Transition::new(877849200, 1),
            Transition::new(891763200, 2),
            Transition::new(909298800, 1),
            Transition::new(923212800, 2),
            Transition::new(941353200, 1),
            Transition::new(954662400, 2),
            Transition::new(972802800, 1),
            Transition::new(989136000, 2),
            Transition::new(1001833200, 1),
            Transition::new(1018166400, 2),
            Transition::new(1035702000, 1),
            Transition::new(1049616000, 2),
            Transition::new(1067151600, 1),
            Transition::new(1081065600, 2),
            Transition::new(1099206000, 1),
            Transition::new(1112515200, 2),
            Transition::new(1130655600, 1),
            Transition::new(1143964800, 2),
            Transition::new(1162105200, 1),
            Transition::new(1175414400, 2),
            Transition::new(1193554800, 1),
            Transition::new(1207468800, 2),
            Transition::new(1225004400, 1),
            Transition::new(1238918400, 2),
            Transition::new(1256454000, 1),
            Transition::new(1268553600, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-24000, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MAZATLAN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514739600, 1),
            Transition::new(-1343066400, 2),
            Transition::new(-1234807200, 1),
            Transition::new(-1220292000, 2),
            Transition::new(-1207159200, 1),
            Transition::new(-1191344400, 2),
            Transition::new(-873828000, 1),
            Transition::new(-661539600, 3),
            Transition::new(28800, 1),
            Transition::new(828867600, 4),
            Transition::new(846403200, 1),
            Transition::new(860317200, 4),
            Transition::new(877852800, 1),
            Transition::new(891766800, 4),
            Transition::new(909302400, 1),
            Transition::new(923216400, 4),
            Transition::new(941356800, 1),
            Transition::new(954666000, 4),
            Transition::new(972806400, 1),
            Transition::new(989139600, 4),
            Transition::new(1001836800, 1),
            Transition::new(1018170000, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-25540, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MENDOZA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2372095484, 1),
            Transition::new(-1567453392, 2),
            Transition::new(-1233432000, 3),
            Transition::new(-1222981200, 2),
            Transition::new(-1205956800, 3),
            Transition::new(-1194037200, 2),
            Transition::new(-1172865600, 3),
            Transition::new(-1162501200, 2),
            Transition::new(-1141329600, 3),
            Transition::new(-1130965200, 2),
            Transition::new(-1109793600, 3),
            Transition::new(-1099429200, 2),
            Transition::new(-1078257600, 3),
            Transition::new(-1067806800, 2),
            Transition::new(-1046635200, 3),
            Transition::new(-1036270800, 2),
            Transition::new(-1015099200, 3),
            Transition::new(-1004734800, 2),
            Transition::new(-983563200, 3),
            Transition::new(-973198800, 2),
            Transition::new(-952027200, 3),
            Transition::new(-941576400, 2),
            Transition::new(-931032000, 3),
            Transition::new(-900882000, 2),
            Transition::new(-890337600, 3),
            Transition::new(-833749200, 2),
            Transition::new(-827265600, 3),
            Transition::new(-752274000, 2),
            Transition::new(-733780800, 3),
            Transition::new(-197326800, 2),
            Transition::new(-190843200, 3),
            Transition::new(-184194000, 2),
            Transition::new(-164491200, 3),
            Transition::new(-152658000, 2),
            Transition::new(-132955200, 3),
            Transition::new(-121122000, 2),
            Transition::new(-101419200, 3),
            Transition::new(-86821200, 2),
            Transition::new(-71092800, 3),
            Transition::new(-54766800, 2),
            Transition::new(-39038400, 3),
            Transition::new(-23317200, 2),
            Transition::new(-7588800, 5),
            Transition::new(128142000, 4),
            Transition::new(136605600, 5),
            Transition::new(596948400, 4),
            Transition::new(605066400, 5),
            Transition::new(624423600, 4),
            Transition::new(636516000, 2),
            Transition::new(655963200, 3),
            Transition::new(667796400, 2),
            Transition::new(687499200, 3),
            Transition::new(699418800, 2),
            Transition::new(719380800, 4),
            Transition::new(731469600, 5),
            Transition::new(938919600, 3),
            Transition::new(952052400, 5),
            Transition::new(1085281200, 2),
            Transition::new(1096171200, 5),
            Transition::new(1198983600, 4),
            Transition::new(1205632800, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-16516, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-15408, false, Some(b"CMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MENOMINEE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2659759773, 2),
            Transition::new(-1633276800, 1),
            Transition::new(-1615136400, 2),
            Transition::new(-1601827200, 1),
            Transition::new(-1583686800, 2),
            Transition::new(-880214400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765392400, 2),
            Transition::new(-747244800, 1),
            Transition::new(-733942800, 2),
            Transition::new(-116438400, 1),
            Transition::new(-100112400, 2),
            Transition::new(-21484800, 5),
            Transition::new(104914800, 1),
            Transition::new(120639600, 2),
            Transition::new(126691200, 1),
            Transition::new(152089200, 2),
            Transition::new(162374400, 1),
            Transition::new(183538800, 2),
            Transition::new(199267200, 1),
            Transition::new(215593200, 2),
            Transition::new(230716800, 1),
            Transition::new(247042800, 2),
            Transition::new(262771200, 1),
            Transition::new(278492400, 2),
            Transition::new(294220800, 1),
            Transition::new(309942000, 2),
            Transition::new(325670400, 1),
            Transition::new(341391600, 2),
            Transition::new(357120000, 1),
            Transition::new(372841200, 2),
            Transition::new(388569600, 1),
            Transition::new(404895600, 2),
            Transition::new(420019200, 1),
            Transition::new(436345200, 2),
            Transition::new(452073600, 1),
            Transition::new(467794800, 2),
            Transition::new(483523200, 1),
            Transition::new(499244400, 2),
            Transition::new(514972800, 1),
            Transition::new(530694000, 2),
            Transition::new(544608000, 1),
            Transition::new(562143600, 2),
            Transition::new(576057600, 1),
            Transition::new(594198000, 2),
            Transition::new(607507200, 1),
            Transition::new(625647600, 2),
            Transition::new(638956800, 1),
            Transition::new(657097200, 2),
            Transition::new(671011200, 1),
            Transition::new(688546800, 2),
            Transition::new(702460800, 1),
            Transition::new(719996400, 2),
            Transition::new(733910400, 1),
            Transition::new(752050800, 2),
            Transition::new(765360000, 1),
            Transition::new(783500400, 2),
            Transition::new(796809600, 1),
            Transition::new(814950000, 2),
            Transition::new(828864000, 1),
            Transition::new(846399600, 2),
            Transition::new(860313600, 1),
            Transition::new(877849200, 2),
            Transition::new(891763200, 1),
            Transition::new(909298800, 2),
            Transition::new(923212800, 1),
            Transition::new(941353200, 2),
            Transition::new(954662400, 1),
            Transition::new(972802800, 2),
            Transition::new(986112000, 1),
            Transition::new(1004252400, 2),
            Transition::new(1018166400, 1),
            Transition::new(1035702000, 2),
            Transition::new(1049616000, 1),
            Transition::new(1067151600, 2),
            Transition::new(1081065600, 1),
            Transition::new(1099206000, 2),
            Transition::new(1112515200, 1),
            Transition::new(1130655600, 2),
            Transition::new(1143964800, 1),
            Transition::new(1162105200, 2),
            Transition::new(1173600000, 1),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-21027, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MERIDA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514743200, 1),
            Transition::new(377935200, 2),
            Transition::new(407653200, 1),
            Transition::new(828864000, 3),
            Transition::new(846399600, 1),
            Transition::new(860313600, 3),
            Transition::new(877849200, 1),
            Transition::new(891763200, 3),
            Transition::new(909298800, 1),
            Transition::new(923212800, 3),
            Transition::new(941353200, 1),
            Transition::new(954662400, 3),
            Transition::new(972802800, 1),
            Transition::new(989136000, 3),
            Transition::new(1001833200, 1),
            Transition::new(1018166400, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-21508, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_METLAKATLA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3225223727, 1),
            Transition::new(-2188955622, 2),
            Transition::new(-880207200, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765385200, 2),
            Transition::new(-21477600, 5),
            Transition::new(-5756400, 2),
            Transition::new(9972000, 5),
            Transition::new(25693200, 2),
            Transition::new(41421600, 5),
            Transition::new(57747600, 2),
            Transition::new(73476000, 5),
            Transition::new(89197200, 2),
            Transition::new(104925600, 5),
            Transition::new(120646800, 2),
            Transition::new(126698400, 5),
            Transition::new(152096400, 2),
            Transition::new(162381600, 5),
            Transition::new(183546000, 2),
            Transition::new(199274400, 5),
            Transition::new(215600400, 2),
            Transition::new(230724000, 5),
            Transition::new(247050000, 2),
            Transition::new(262778400, 5),
            Transition::new(278499600, 2),
            Transition::new(294228000, 5),
            Transition::new(309949200, 2),
            Transition::new(325677600, 5),
            Transition::new(341398800, 2),
            Transition::new(357127200, 5),
            Transition::new(372848400, 2),
            Transition::new(388576800, 5),
            Transition::new(404902800, 2),
            Transition::new(420026400, 5),
            Transition::new(436352400, 2),
            Transition::new(1446372000, 6),
            Transition::new(1457866800, 7),
            Transition::new(1478426400, 6),
            Transition::new(1489316400, 7),
            Transition::new(1509876000, 6),
            Transition::new(1520766000, 7),
            Transition::new(1541325600, 2),
            Transition::new(1547978400, 6),
            Transition::new(1552215600, 7),
        ],
        &{
            const V: [LocalTimeType; 8] = [
                match LocalTimeType::new(54822, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-31578, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MEXICO_CITY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514739600, 1),
            Transition::new(-1343066400, 2),
            Transition::new(-1234807200, 1),
            Transition::new(-1220292000, 2),
            Transition::new(-1207159200, 1),
            Transition::new(-1191344400, 2),
            Transition::new(-975261600, 3),
            Transition::new(-963169200, 2),
            Transition::new(-917114400, 3),
            Transition::new(-907354800, 2),
            Transition::new(-821901600, 4),
            Transition::new(-810068400, 2),
            Transition::new(-627501600, 3),
            Transition::new(-612990000, 2),
            Transition::new(828864000, 3),
            Transition::new(846399600, 2),
            Transition::new(860313600, 3),
            Transition::new(877849200, 2),
            Transition::new(891763200, 3),
            Transition::new(909298800, 2),
            Transition::new(923212800, 3),
            Transition::new(941353200, 2),
            Transition::new(954662400, 3),
            Transition::new(972802800, 2),
            Transition::new(989136000, 3),
            Transition::new(1001833200, 2),
            Transition::new(1018166400, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-23796, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MIQUELON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1850328920, 1),
            Transition::new(326001600, 2),
            Transition::new(544597200, 3),
            Transition::new(562132800, 2),
            Transition::new(576046800, 3),
            Transition::new(594187200, 2),
            Transition::new(607496400, 3),
            Transition::new(625636800, 2),
            Transition::new(638946000, 3),
            Transition::new(657086400, 2),
            Transition::new(671000400, 3),
            Transition::new(688536000, 2),
            Transition::new(702450000, 3),
            Transition::new(719985600, 2),
            Transition::new(733899600, 3),
            Transition::new(752040000, 2),
            Transition::new(765349200, 3),
            Transition::new(783489600, 2),
            Transition::new(796798800, 3),
            Transition::new(814939200, 2),
            Transition::new(828853200, 3),
            Transition::new(846388800, 2),
            Transition::new(860302800, 3),
            Transition::new(877838400, 2),
            Transition::new(891752400, 3),
            Transition::new(909288000, 2),
            Transition::new(923202000, 3),
            Transition::new(941342400, 2),
            Transition::new(954651600, 3),
            Transition::new(972792000, 2),
            Transition::new(986101200, 3),
            Transition::new(1004241600, 2),
            Transition::new(1018155600, 3),
            Transition::new(1035691200, 2),
            Transition::new(1049605200, 3),
            Transition::new(1067140800, 2),
            Transition::new(1081054800, 3),
            Transition::new(1099195200, 2),
            Transition::new(1112504400, 3),
            Transition::new(1130644800, 2),
            Transition::new(1143954000, 3),
            Transition::new(1162094400, 2),
            Transition::new(1173589200, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-13480, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-10800, false, Some(b"-03")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-7200, true, Some(b"-02")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MONCTON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2715882052, 1),
            Transition::new(-2131642800, 3),
            Transition::new(-1632074400, 2),
            Transition::new(-1615143600, 3),
            Transition::new(-1153681200, 2),
            Transition::new(-1145822400, 3),
            Transition::new(-1122231600, 2),
            Transition::new(-1114372800, 3),
            Transition::new(-1090782000, 2),
            Transition::new(-1082923200, 3),
            Transition::new(-1059332400, 2),
            Transition::new(-1051473600, 3),
            Transition::new(-1027882800, 2),
            Transition::new(-1020024000, 3),
            Transition::new(-996433200, 2),
            Transition::new(-988574400, 3),
            Transition::new(-965674800, 2),
            Transition::new(-955396800, 3),
            Transition::new(-934743600, 2),
            Transition::new(-923947200, 3),
            Transition::new(-904503600, 2),
            Transition::new(-891892800, 3),
            Transition::new(-880221600, 4),
            Transition::new(-769395600, 5),
            Transition::new(-765399600, 3),
            Transition::new(-747252000, 2),
            Transition::new(-733950000, 3),
            Transition::new(-715802400, 2),
            Transition::new(-702500400, 3),
            Transition::new(-684352800, 2),
            Transition::new(-671050800, 3),
            Transition::new(-652903200, 2),
            Transition::new(-639601200, 3),
            Transition::new(-620848800, 2),
            Transition::new(-608151600, 3),
            Transition::new(-589399200, 2),
            Transition::new(-576097200, 3),
            Transition::new(-557949600, 2),
            Transition::new(-544647600, 3),
            Transition::new(-526500000, 2),
            Transition::new(-513198000, 3),
            Transition::new(-495050400, 2),
            Transition::new(-481748400, 3),
            Transition::new(-463600800, 2),
            Transition::new(-450298800, 3),
            Transition::new(-431546400, 2),
            Transition::new(-418244400, 3),
            Transition::new(-400096800, 2),
            Transition::new(-384375600, 3),
            Transition::new(-368647200, 2),
            Transition::new(-352926000, 3),
            Transition::new(-337197600, 2),
            Transition::new(-321476400, 3),
            Transition::new(-305748000, 2),
            Transition::new(-289422000, 3),
            Transition::new(-273693600, 2),
            Transition::new(-257972400, 3),
            Transition::new(-242244000, 2),
            Transition::new(-226522800, 3),
            Transition::new(-210794400, 2),
            Transition::new(-195073200, 3),
            Transition::new(-179344800, 2),
            Transition::new(-163623600, 3),
            Transition::new(-147895200, 2),
            Transition::new(-131569200, 3),
            Transition::new(-116445600, 2),
            Transition::new(-100119600, 3),
            Transition::new(-84391200, 2),
            Transition::new(-68670000, 3),
            Transition::new(-52941600, 2),
            Transition::new(-37220400, 3),
            Transition::new(-21492000, 2),
            Transition::new(-5770800, 3),
            Transition::new(9957600, 2),
            Transition::new(25678800, 3),
            Transition::new(41407200, 2),
            Transition::new(57733200, 3),
            Transition::new(73461600, 2),
            Transition::new(89182800, 3),
            Transition::new(136360800, 2),
            Transition::new(152082000, 3),
            Transition::new(167810400, 2),
            Transition::new(183531600, 3),
            Transition::new(199260000, 2),
            Transition::new(215586000, 3),
            Transition::new(230709600, 2),
            Transition::new(247035600, 3),
            Transition::new(262764000, 2),
            Transition::new(278485200, 3),
            Transition::new(294213600, 2),
            Transition::new(309934800, 3),
            Transition::new(325663200, 2),
            Transition::new(341384400, 3),
            Transition::new(357112800, 2),
            Transition::new(372834000, 3),
            Transition::new(388562400, 2),
            Transition::new(404888400, 3),
            Transition::new(420012000, 2),
            Transition::new(436338000, 3),
            Transition::new(452066400, 2),
            Transition::new(467787600, 3),
            Transition::new(483516000, 2),
            Transition::new(499237200, 3),
            Transition::new(514965600, 2),
            Transition::new(530686800, 3),
            Transition::new(544600800, 2),
            Transition::new(562136400, 3),
            Transition::new(576050400, 2),
            Transition::new(594190800, 3),
            Transition::new(607500000, 2),
            Transition::new(625640400, 3),
            Transition::new(638949600, 2),
            Transition::new(657090000, 3),
            Transition::new(671004000, 2),
            Transition::new(688539600, 3),
            Transition::new(702453600, 2),
            Transition::new(719989200, 3),
            Transition::new(733896060, 2),
            Transition::new(752036460, 3),
            Transition::new(765345660, 2),
            Transition::new(783486060, 3),
            Transition::new(796795260, 2),
            Transition::new(814935660, 3),
            Transition::new(828849660, 2),
            Transition::new(846385260, 3),
            Transition::new(860299260, 2),
            Transition::new(877834860, 3),
            Transition::new(891748860, 2),
            Transition::new(909284460, 3),
            Transition::new(923198460, 2),
            Transition::new(941338860, 3),
            Transition::new(954648060, 2),
            Transition::new(972788460, 3),
            Transition::new(986097660, 2),
            Transition::new(1004238060, 3),
            Transition::new(1018152060, 2),
            Transition::new(1035687660, 3),
            Transition::new(1049601660, 2),
            Transition::new(1067137260, 3),
            Transition::new(1081051260, 2),
            Transition::new(1099191660, 3),
            Transition::new(1112500860, 2),
            Transition::new(1130641260, 3),
            Transition::new(1143950460, 2),
            Transition::new(1162090860, 3),
            Transition::new(1173592800, 2),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-15548, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"AWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"APT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-14400, false, Some(b"AST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MONTERREY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514743200, 1),
            Transition::new(576057600, 2),
            Transition::new(594198000, 1),
            Transition::new(828864000, 2),
            Transition::new(846399600, 1),
            Transition::new(860313600, 2),
            Transition::new(877849200, 1),
            Transition::new(891763200, 2),
            Transition::new(909298800, 1),
            Transition::new(923212800, 2),
            Transition::new(941353200, 1),
            Transition::new(954662400, 2),
            Transition::new(972802800, 1),
            Transition::new(989136000, 2),
            Transition::new(1001833200, 1),
            Transition::new(1018166400, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-24076, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MONTEVIDEO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1942690509, 1),
            Transition::new(-1567455309, 2),
            Transition::new(-1459627200, 4),
            Transition::new(-1443819600, 3),
            Transition::new(-1428006600, 4),
            Transition::new(-1412283600, 3),
            Transition::new(-1396470600, 4),
            Transition::new(-1380747600, 3),
            Transition::new(-1141590600, 4),
            Transition::new(-1128286800, 3),
            Transition::new(-1110141000, 4),
            Transition::new(-1096837200, 3),
            Transition::new(-1078691400, 4),
            Transition::new(-1065387600, 3),
            Transition::new(-1047241800, 4),
            Transition::new(-1033938000, 3),
            Transition::new(-1015187400, 4),
            Transition::new(-1002488400, 3),
            Transition::new(-983737800, 4),
            Transition::new(-971038800, 3),
            Transition::new(-954707400, 4),
            Transition::new(-938984400, 3),
            Transition::new(-920838600, 4),
            Transition::new(-907534800, 3),
            Transition::new(-896819400, 4),
            Transition::new(-853621200, 6),
            Transition::new(-845847000, 5),
            Transition::new(-334789200, 6),
            Transition::new(-319671000, 5),
            Transition::new(-314226000, 7),
            Transition::new(-309996000, 5),
            Transition::new(-149720400, 7),
            Transition::new(-134604000, 5),
            Transition::new(-50446800, 6),
            Transition::new(-34205400, 5),
            Transition::new(9860400, 7),
            Transition::new(14176800, 5),
            Transition::new(72846000, 7),
            Transition::new(80100000, 5),
            Transition::new(127278000, 8),
            Transition::new(132111000, 6),
            Transition::new(147234600, 5),
            Transition::new(156913200, 7),
            Transition::new(165376800, 5),
            Transition::new(219812400, 7),
            Transition::new(226461600, 5),
            Transition::new(250052400, 7),
            Transition::new(257911200, 5),
            Transition::new(282711600, 7),
            Transition::new(289360800, 5),
            Transition::new(294202800, 7),
            Transition::new(322020000, 5),
            Transition::new(566449200, 7),
            Transition::new(573012000, 5),
            Transition::new(597812400, 7),
            Transition::new(605066400, 5),
            Transition::new(625633200, 7),
            Transition::new(635911200, 5),
            Transition::new(656478000, 7),
            Transition::new(667965600, 5),
            Transition::new(688532400, 7),
            Transition::new(699415200, 5),
            Transition::new(719377200, 7),
            Transition::new(730864800, 5),
            Transition::new(1095562800, 7),
            Transition::new(1111896000, 5),
            Transition::new(1128834000, 7),
            Transition::new(1142136000, 5),
            Transition::new(1159678800, 7),
            Transition::new(1173585600, 5),
            Transition::new(1191733200, 7),
            Transition::new(1205035200, 5),
            Transition::new(1223182800, 7),
            Transition::new(1236484800, 5),
            Transition::new(1254632400, 7),
            Transition::new(1268539200, 5),
            Transition::new(1286082000, 7),
            Transition::new(1299988800, 5),
            Transition::new(1317531600, 7),
            Transition::new(1331438400, 5),
            Transition::new(1349586000, 7),
            Transition::new(1362888000, 5),
            Transition::new(1381035600, 7),
            Transition::new(1394337600, 5),
            Transition::new(1412485200, 7),
            Transition::new(1425787200, 5),
        ],
        &{
            const V: [LocalTimeType; 9] = [
                match LocalTimeType::new(-13491, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-13491, false, Some(b"MMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-12600, false, Some(b"-0330")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9000, true, Some(b"-0230")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-5400, true, Some(b"-0130")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_MONTREAL: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2366736148, 2),
            Transition::new(-1632070800, 1),
            Transition::new(-1615140000, 2),
            Transition::new(-1601753400, 1),
            Transition::new(-1583697600, 2),
            Transition::new(-1567357200, 1),
            Transition::new(-1554667200, 2),
            Transition::new(-1534698000, 1),
            Transition::new(-1524074400, 2),
            Transition::new(-1503248400, 1),
            Transition::new(-1492365600, 2),
            Transition::new(-1471798800, 1),
            Transition::new(-1460916000, 2),
            Transition::new(-1440954000, 1),
            Transition::new(-1428861600, 2),
            Transition::new(-1409504400, 1),
            Transition::new(-1397412000, 2),
            Transition::new(-1378054800, 1),
            Transition::new(-1365962400, 2),
            Transition::new(-1346605200, 1),
            Transition::new(-1333908000, 2),
            Transition::new(-1315155600, 1),
            Transition::new(-1301853600, 2),
            Transition::new(-1283706000, 1),
            Transition::new(-1270404000, 2),
            Transition::new(-1252256400, 1),
            Transition::new(-1238954400, 2),
            Transition::new(-1220806800, 1),
            Transition::new(-1207504800, 2),
            Transition::new(-1188752400, 1),
            Transition::new(-1176055200, 2),
            Transition::new(-1157302800, 1),
            Transition::new(-1144000800, 2),
            Transition::new(-1125853200, 1),
            Transition::new(-1112551200, 2),
            Transition::new(-1094403600, 1),
            Transition::new(-1081101600, 2),
            Transition::new(-1062954000, 1),
            Transition::new(-1049652000, 2),
            Transition::new(-1031504400, 1),
            Transition::new(-1018202400, 2),
            Transition::new(-1000054800, 1),
            Transition::new(-986752800, 2),
            Transition::new(-968000400, 1),
            Transition::new(-955303200, 2),
            Transition::new(-936550800, 1),
            Transition::new(-880218000, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765396000, 2),
            Transition::new(-747248400, 1),
            Transition::new(-733946400, 2),
            Transition::new(-715806000, 1),
            Transition::new(-702504000, 2),
            Transition::new(-684356400, 1),
            Transition::new(-671054400, 2),
            Transition::new(-652906800, 1),
            Transition::new(-634161600, 2),
            Transition::new(-620845200, 1),
            Transition::new(-602704800, 2),
            Transition::new(-589395600, 1),
            Transition::new(-576093600, 2),
            Transition::new(-557946000, 1),
            Transition::new(-544644000, 2),
            Transition::new(-526496400, 1),
            Transition::new(-513194400, 2),
            Transition::new(-495046800, 1),
            Transition::new(-481744800, 2),
            Transition::new(-463597200, 1),
            Transition::new(-450295200, 2),
            Transition::new(-431542800, 1),
            Transition::new(-418240800, 2),
            Transition::new(-400093200, 1),
            Transition::new(-384372000, 2),
            Transition::new(-368643600, 1),
            Transition::new(-352922400, 2),
            Transition::new(-337194000, 1),
            Transition::new(-321472800, 2),
            Transition::new(-305744400, 1),
            Transition::new(-289418400, 2),
            Transition::new(-273690000, 1),
            Transition::new(-257968800, 2),
            Transition::new(-242240400, 1),
            Transition::new(-226519200, 2),
            Transition::new(-210790800, 1),
            Transition::new(-195069600, 2),
            Transition::new(-179341200, 1),
            Transition::new(-163620000, 2),
            Transition::new(-147891600, 1),
            Transition::new(-131565600, 2),
            Transition::new(-116442000, 1),
            Transition::new(-100116000, 2),
            Transition::new(-84387600, 1),
            Transition::new(-68666400, 2),
            Transition::new(-52938000, 1),
            Transition::new(-37216800, 2),
            Transition::new(-21488400, 1),
            Transition::new(-5767200, 2),
            Transition::new(9961200, 1),
            Transition::new(25682400, 2),
            Transition::new(41410800, 1),
            Transition::new(57736800, 2),
            Transition::new(73465200, 1),
            Transition::new(89186400, 2),
            Transition::new(104914800, 1),
            Transition::new(120636000, 2),
            Transition::new(136364400, 1),
            Transition::new(152085600, 2),
            Transition::new(167814000, 1),
            Transition::new(183535200, 2),
            Transition::new(199263600, 1),
            Transition::new(215589600, 2),
            Transition::new(230713200, 1),
            Transition::new(247039200, 2),
            Transition::new(262767600, 1),
            Transition::new(278488800, 2),
            Transition::new(294217200, 1),
            Transition::new(309938400, 2),
            Transition::new(325666800, 1),
            Transition::new(341388000, 2),
            Transition::new(357116400, 1),
            Transition::new(372837600, 2),
            Transition::new(388566000, 1),
            Transition::new(404892000, 2),
            Transition::new(420015600, 1),
            Transition::new(436341600, 2),
            Transition::new(452070000, 1),
            Transition::new(467791200, 2),
            Transition::new(483519600, 1),
            Transition::new(499240800, 2),
            Transition::new(514969200, 1),
            Transition::new(530690400, 2),
            Transition::new(544604400, 1),
            Transition::new(562140000, 2),
            Transition::new(576054000, 1),
            Transition::new(594194400, 2),
            Transition::new(607503600, 1),
            Transition::new(625644000, 2),
            Transition::new(638953200, 1),
            Transition::new(657093600, 2),
            Transition::new(671007600, 1),
            Transition::new(688543200, 2),
            Transition::new(702457200, 1),
            Transition::new(719992800, 2),
            Transition::new(733906800, 1),
            Transition::new(752047200, 2),
            Transition::new(765356400, 1),
            Transition::new(783496800, 2),
            Transition::new(796806000, 1),
            Transition::new(814946400, 2),
            Transition::new(828860400, 1),
            Transition::new(846396000, 2),
            Transition::new(860310000, 1),
            Transition::new(877845600, 2),
            Transition::new(891759600, 1),
            Transition::new(909295200, 2),
            Transition::new(923209200, 1),
            Transition::new(941349600, 2),
            Transition::new(954658800, 1),
            Transition::new(972799200, 2),
            Transition::new(986108400, 1),
            Transition::new(1004248800, 2),
            Transition::new(1018162800, 1),
            Transition::new(1035698400, 2),
            Transition::new(1049612400, 1),
            Transition::new(1067148000, 2),
            Transition::new(1081062000, 1),
            Transition::new(1099202400, 2),
            Transition::new(1112511600, 1),
            Transition::new(1130652000, 2),
            Transition::new(1143961200, 1),
            Transition::new(1162101600, 2),
            Transition::new(1173596400, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-19052, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_NEW_YORK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2717650800, 2),
            Transition::new(-1633280400, 1),
            Transition::new(-1615140000, 2),
            Transition::new(-1601830800, 1),
            Transition::new(-1583690400, 2),
            Transition::new(-1570381200, 1),
            Transition::new(-1551636000, 2),
            Transition::new(-1536512400, 1),
            Transition::new(-1523210400, 2),
            Transition::new(-1504458000, 1),
            Transition::new(-1491760800, 2),
            Transition::new(-1473008400, 1),
            Transition::new(-1459706400, 2),
            Transition::new(-1441558800, 1),
            Transition::new(-1428256800, 2),
            Transition::new(-1410109200, 1),
            Transition::new(-1396807200, 2),
            Transition::new(-1378659600, 1),
            Transition::new(-1365357600, 2),
            Transition::new(-1347210000, 1),
            Transition::new(-1333908000, 2),
            Transition::new(-1315155600, 1),
            Transition::new(-1301853600, 2),
            Transition::new(-1283706000, 1),
            Transition::new(-1270404000, 2),
            Transition::new(-1252256400, 1),
            Transition::new(-1238954400, 2),
            Transition::new(-1220806800, 1),
            Transition::new(-1207504800, 2),
            Transition::new(-1189357200, 1),
            Transition::new(-1176055200, 2),
            Transition::new(-1157302800, 1),
            Transition::new(-1144605600, 2),
            Transition::new(-1125853200, 1),
            Transition::new(-1112551200, 2),
            Transition::new(-1094403600, 1),
            Transition::new(-1081101600, 2),
            Transition::new(-1062954000, 1),
            Transition::new(-1049652000, 2),
            Transition::new(-1031504400, 1),
            Transition::new(-1018202400, 2),
            Transition::new(-1000054800, 1),
            Transition::new(-986752800, 2),
            Transition::new(-968000400, 1),
            Transition::new(-955303200, 2),
            Transition::new(-936550800, 1),
            Transition::new(-923248800, 2),
            Transition::new(-905101200, 1),
            Transition::new(-891799200, 2),
            Transition::new(-880218000, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765396000, 2),
            Transition::new(-747248400, 1),
            Transition::new(-733946400, 2),
            Transition::new(-715798800, 1),
            Transition::new(-702496800, 2),
            Transition::new(-684349200, 1),
            Transition::new(-671047200, 2),
            Transition::new(-652899600, 1),
            Transition::new(-639597600, 2),
            Transition::new(-620845200, 1),
            Transition::new(-608148000, 2),
            Transition::new(-589395600, 1),
            Transition::new(-576093600, 2),
            Transition::new(-557946000, 1),
            Transition::new(-544644000, 2),
            Transition::new(-526496400, 1),
            Transition::new(-513194400, 2),
            Transition::new(-495046800, 1),
            Transition::new(-481744800, 2),
            Transition::new(-463597200, 1),
            Transition::new(-447271200, 2),
            Transition::new(-431542800, 1),
            Transition::new(-415821600, 2),
            Transition::new(-400093200, 1),
            Transition::new(-384372000, 2),
            Transition::new(-368643600, 1),
            Transition::new(-352922400, 2),
            Transition::new(-337194000, 1),
            Transition::new(-321472800, 2),
            Transition::new(-305744400, 1),
            Transition::new(-289418400, 2),
            Transition::new(-273690000, 1),
            Transition::new(-257968800, 2),
            Transition::new(-242240400, 1),
            Transition::new(-226519200, 2),
            Transition::new(-210790800, 1),
            Transition::new(-195069600, 2),
            Transition::new(-179341200, 1),
            Transition::new(-163620000, 2),
            Transition::new(-147891600, 1),
            Transition::new(-131565600, 2),
            Transition::new(-116442000, 1),
            Transition::new(-100116000, 2),
            Transition::new(-84387600, 1),
            Transition::new(-68666400, 2),
            Transition::new(-52938000, 1),
            Transition::new(-37216800, 2),
            Transition::new(-21488400, 1),
            Transition::new(-5767200, 2),
            Transition::new(9961200, 1),
            Transition::new(25682400, 2),
            Transition::new(41410800, 1),
            Transition::new(57736800, 2),
            Transition::new(73465200, 1),
            Transition::new(89186400, 2),
            Transition::new(104914800, 1),
            Transition::new(120636000, 2),
            Transition::new(126687600, 1),
            Transition::new(152085600, 2),
            Transition::new(162370800, 1),
            Transition::new(183535200, 2),
            Transition::new(199263600, 1),
            Transition::new(215589600, 2),
            Transition::new(230713200, 1),
            Transition::new(247039200, 2),
            Transition::new(262767600, 1),
            Transition::new(278488800, 2),
            Transition::new(294217200, 1),
            Transition::new(309938400, 2),
            Transition::new(325666800, 1),
            Transition::new(341388000, 2),
            Transition::new(357116400, 1),
            Transition::new(372837600, 2),
            Transition::new(388566000, 1),
            Transition::new(404892000, 2),
            Transition::new(420015600, 1),
            Transition::new(436341600, 2),
            Transition::new(452070000, 1),
            Transition::new(467791200, 2),
            Transition::new(483519600, 1),
            Transition::new(499240800, 2),
            Transition::new(514969200, 1),
            Transition::new(530690400, 2),
            Transition::new(544604400, 1),
            Transition::new(562140000, 2),
            Transition::new(576054000, 1),
            Transition::new(594194400, 2),
            Transition::new(607503600, 1),
            Transition::new(625644000, 2),
            Transition::new(638953200, 1),
            Transition::new(657093600, 2),
            Transition::new(671007600, 1),
            Transition::new(688543200, 2),
            Transition::new(702457200, 1),
            Transition::new(719992800, 2),
            Transition::new(733906800, 1),
            Transition::new(752047200, 2),
            Transition::new(765356400, 1),
            Transition::new(783496800, 2),
            Transition::new(796806000, 1),
            Transition::new(814946400, 2),
            Transition::new(828860400, 1),
            Transition::new(846396000, 2),
            Transition::new(860310000, 1),
            Transition::new(877845600, 2),
            Transition::new(891759600, 1),
            Transition::new(909295200, 2),
            Transition::new(923209200, 1),
            Transition::new(941349600, 2),
            Transition::new(954658800, 1),
            Transition::new(972799200, 2),
            Transition::new(986108400, 1),
            Transition::new(1004248800, 2),
            Transition::new(1018162800, 1),
            Transition::new(1035698400, 2),
            Transition::new(1049612400, 1),
            Transition::new(1067148000, 2),
            Transition::new(1081062000, 1),
            Transition::new(1099202400, 2),
            Transition::new(1112511600, 1),
            Transition::new(1130652000, 2),
            Transition::new(1143961200, 1),
            Transition::new(1162101600, 2),
            Transition::new(1173596400, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-17762, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_NIPIGON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2366734016, 2),
            Transition::new(-1632070800, 1),
            Transition::new(-1615140000, 2),
            Transition::new(-923252400, 1),
            Transition::new(-880218000, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765396000, 2),
            Transition::new(136364400, 1),
            Transition::new(152085600, 2),
            Transition::new(167814000, 1),
            Transition::new(183535200, 2),
            Transition::new(199263600, 1),
            Transition::new(215589600, 2),
            Transition::new(230713200, 1),
            Transition::new(247039200, 2),
            Transition::new(262767600, 1),
            Transition::new(278488800, 2),
            Transition::new(294217200, 1),
            Transition::new(309938400, 2),
            Transition::new(325666800, 1),
            Transition::new(341388000, 2),
            Transition::new(357116400, 1),
            Transition::new(372837600, 2),
            Transition::new(388566000, 1),
            Transition::new(404892000, 2),
            Transition::new(420015600, 1),
            Transition::new(436341600, 2),
            Transition::new(452070000, 1),
            Transition::new(467791200, 2),
            Transition::new(483519600, 1),
            Transition::new(499240800, 2),
            Transition::new(514969200, 1),
            Transition::new(530690400, 2),
            Transition::new(544604400, 1),
            Transition::new(562140000, 2),
            Transition::new(576054000, 1),
            Transition::new(594194400, 2),
            Transition::new(607503600, 1),
            Transition::new(625644000, 2),
            Transition::new(638953200, 1),
            Transition::new(657093600, 2),
            Transition::new(671007600, 1),
            Transition::new(688543200, 2),
            Transition::new(702457200, 1),
            Transition::new(719992800, 2),
            Transition::new(733906800, 1),
            Transition::new(752047200, 2),
            Transition::new(765356400, 1),
            Transition::new(783496800, 2),
            Transition::new(796806000, 1),
            Transition::new(814946400, 2),
            Transition::new(828860400, 1),
            Transition::new(846396000, 2),
            Transition::new(860310000, 1),
            Transition::new(877845600, 2),
            Transition::new(891759600, 1),
            Transition::new(909295200, 2),
            Transition::new(923209200, 1),
            Transition::new(941349600, 2),
            Transition::new(954658800, 1),
            Transition::new(972799200, 2),
            Transition::new(986108400, 1),
            Transition::new(1004248800, 2),
            Transition::new(1018162800, 1),
            Transition::new(1035698400, 2),
            Transition::new(1049612400, 1),
            Transition::new(1067148000, 2),
            Transition::new(1081062000, 1),
            Transition::new(1099202400, 2),
            Transition::new(1112511600, 1),
            Transition::new(1130652000, 2),
            Transition::new(1143961200, 1),
            Transition::new(1162101600, 2),
            Transition::new(1173596400, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-21184, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_NOME: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3225223727, 1),
            Transition::new(-2188947502, 2),
            Transition::new(-880196400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765374400, 2),
            Transition::new(-86878800, 5),
            Transition::new(-21466800, 6),
            Transition::new(-5745600, 5),
            Transition::new(9982800, 6),
            Transition::new(25704000, 5),
            Transition::new(41432400, 6),
            Transition::new(57758400, 5),
            Transition::new(73486800, 6),
            Transition::new(89208000, 5),
            Transition::new(104936400, 6),
            Transition::new(120657600, 5),
            Transition::new(126709200, 6),
            Transition::new(152107200, 5),
            Transition::new(162392400, 6),
            Transition::new(183556800, 5),
            Transition::new(199285200, 6),
            Transition::new(215611200, 5),
            Transition::new(230734800, 6),
            Transition::new(247060800, 5),
            Transition::new(262789200, 6),
            Transition::new(278510400, 5),
            Transition::new(294238800, 6),
            Transition::new(309960000, 5),
            Transition::new(325688400, 6),
            Transition::new(341409600, 5),
            Transition::new(357138000, 6),
            Transition::new(372859200, 5),
            Transition::new(388587600, 6),
            Transition::new(404913600, 5),
            Transition::new(420037200, 6),
            Transition::new(436363200, 7),
            Transition::new(439030800, 9),
            Transition::new(452084400, 8),
            Transition::new(467805600, 9),
            Transition::new(483534000, 8),
            Transition::new(499255200, 9),
            Transition::new(514983600, 8),
            Transition::new(530704800, 9),
            Transition::new(544618800, 8),
            Transition::new(562154400, 9),
            Transition::new(576068400, 8),
            Transition::new(594208800, 9),
            Transition::new(607518000, 8),
            Transition::new(625658400, 9),
            Transition::new(638967600, 8),
            Transition::new(657108000, 9),
            Transition::new(671022000, 8),
            Transition::new(688557600, 9),
            Transition::new(702471600, 8),
            Transition::new(720007200, 9),
            Transition::new(733921200, 8),
            Transition::new(752061600, 9),
            Transition::new(765370800, 8),
            Transition::new(783511200, 9),
            Transition::new(796820400, 8),
            Transition::new(814960800, 9),
            Transition::new(828874800, 8),
            Transition::new(846410400, 9),
            Transition::new(860324400, 8),
            Transition::new(877860000, 9),
            Transition::new(891774000, 8),
            Transition::new(909309600, 9),
            Transition::new(923223600, 8),
            Transition::new(941364000, 9),
            Transition::new(954673200, 8),
            Transition::new(972813600, 9),
            Transition::new(986122800, 8),
            Transition::new(1004263200, 9),
            Transition::new(1018177200, 8),
            Transition::new(1035712800, 9),
            Transition::new(1049626800, 8),
            Transition::new(1067162400, 9),
            Transition::new(1081076400, 8),
            Transition::new(1099216800, 9),
            Transition::new(1112526000, 8),
            Transition::new(1130666400, 9),
            Transition::new(1143975600, 8),
            Transition::new(1162116000, 9),
            Transition::new(1173610800, 8),
        ],
        &{
            const V: [LocalTimeType; 10] = [
                match LocalTimeType::new(46702, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-39698, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-39600, false, Some(b"NST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, true, Some(b"NWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, true, Some(b"NPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-39600, false, Some(b"BST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-36000, true, Some(b"BDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"YST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_NORONHA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767217820, 2),
            Transition::new(-1206961200, 1),
            Transition::new(-1191366000, 2),
            Transition::new(-1175378400, 1),
            Transition::new(-1159830000, 2),
            Transition::new(-633823200, 1),
            Transition::new(-622072800, 2),
            Transition::new(-602287200, 1),
            Transition::new(-591836400, 2),
            Transition::new(-570751200, 1),
            Transition::new(-560214000, 2),
            Transition::new(-539128800, 1),
            Transition::new(-531356400, 2),
            Transition::new(-191368800, 1),
            Transition::new(-184201200, 2),
            Transition::new(-155167200, 1),
            Transition::new(-150073200, 2),
            Transition::new(-128901600, 1),
            Transition::new(-121129200, 2),
            Transition::new(-99957600, 1),
            Transition::new(-89593200, 2),
            Transition::new(-68421600, 1),
            Transition::new(-57970800, 2),
            Transition::new(499744800, 1),
            Transition::new(511232400, 2),
            Transition::new(530589600, 1),
            Transition::new(540262800, 2),
            Transition::new(562125600, 1),
            Transition::new(571194000, 2),
            Transition::new(592970400, 1),
            Transition::new(602038800, 2),
            Transition::new(624420000, 1),
            Transition::new(634698000, 2),
            Transition::new(938916000, 1),
            Transition::new(951613200, 2),
            Transition::new(970970400, 1),
            Transition::new(971571600, 2),
            Transition::new(1003024800, 1),
            Transition::new(1013907600, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-7780, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, true, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, false, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-7200, false, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_OJINAGA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1514739600, 1),
            Transition::new(-1343066400, 2),
            Transition::new(-1234807200, 1),
            Transition::new(-1220292000, 2),
            Transition::new(-1207159200, 1),
            Transition::new(-1191344400, 2),
            Transition::new(828864000, 3),
            Transition::new(846399600, 2),
            Transition::new(860313600, 3),
            Transition::new(877849200, 2),
            Transition::new(891766800, 4),
            Transition::new(909302400, 1),
            Transition::new(923216400, 4),
            Transition::new(941356800, 1),
            Transition::new(954666000, 4),
            Transition::new(972806400, 1),
            Transition::new(989139600, 4),
            Transition::new(1001836800, 1),
            Transition::new(1018170000, 4),
            Transition::new(1035705600, 1),
            Transition::new(1049619600, 4),
            Transition::new(1067155200, 1),
            Transition::new(1081069200, 4),
            Transition::new(1099209600, 1),
            Transition::new(1112518800, 4),
            Transition::new(1130659200, 1),
            Transition::new(1143968400, 4),
            Transition::new(1162108800, 1),
            Transition::new(1175418000, 4),
            Transition::new(1193558400, 1),
            Transition::new(1207472400, 4),
            Transition::new(1225008000, 1),
            Transition::new(1238922000, 4),
            Transition::new(1256457600, 1),
            Transition::new(1268557200, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-25060, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_PANGNIRTUNG: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1546300800, 3),
            Transition::new(-880221600, 1),
            Transition::new(-769395600, 2),
            Transition::new(-765399600, 3),
            Transition::new(-147902400, 4),
            Transition::new(-131572800, 3),
            Transition::new(325663200, 5),
            Transition::new(341384400, 3),
            Transition::new(357112800, 5),
            Transition::new(372834000, 3),
            Transition::new(388562400, 5),
            Transition::new(404888400, 3),
            Transition::new(420012000, 5),
            Transition::new(436338000, 3),
            Transition::new(452066400, 5),
            Transition::new(467787600, 3),
            Transition::new(483516000, 5),
            Transition::new(499237200, 3),
            Transition::new(514965600, 5),
            Transition::new(530686800, 3),
            Transition::new(544600800, 5),
            Transition::new(562136400, 3),
            Transition::new(576050400, 5),
            Transition::new(594190800, 3),
            Transition::new(607500000, 5),
            Transition::new(625640400, 3),
            Transition::new(638949600, 5),
            Transition::new(657090000, 3),
            Transition::new(671004000, 5),
            Transition::new(688539600, 3),
            Transition::new(702453600, 5),
            Transition::new(719989200, 3),
            Transition::new(733903200, 5),
            Transition::new(752043600, 3),
            Transition::new(765352800, 5),
            Transition::new(783493200, 3),
            Transition::new(796802400, 6),
            Transition::new(814946400, 7),
            Transition::new(828860400, 6),
            Transition::new(846396000, 7),
            Transition::new(860310000, 6),
            Transition::new(877845600, 7),
            Transition::new(891759600, 6),
            Transition::new(909295200, 7),
            Transition::new(923209200, 6),
            Transition::new(941349600, 8),
            Transition::new(954662400, 9),
            Transition::new(972802800, 7),
            Transition::new(986108400, 6),
            Transition::new(1004248800, 7),
            Transition::new(1018162800, 6),
            Transition::new(1035698400, 7),
            Transition::new(1049612400, 6),
            Transition::new(1067148000, 7),
            Transition::new(1081062000, 6),
            Transition::new(1099202400, 7),
            Transition::new(1112511600, 6),
            Transition::new(1130652000, 7),
            Transition::new(1143961200, 6),
            Transition::new(1162101600, 7),
            Transition::new(1173596400, 6),
        ],
        &{
            const V: [LocalTimeType; 10] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"AWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"APT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"ADDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_PARAMARIBO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1861906760, 1),
            Transition::new(-1104524348, 2),
            Transition::new(-765317964, 3),
            Transition::new(465449400, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-13240, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-13252, false, Some(b"PMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-13236, false, Some(b"PMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-12600, false, Some(b"-0330")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_PORTO_ACRE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767209328, 2),
            Transition::new(-1206950400, 1),
            Transition::new(-1191355200, 2),
            Transition::new(-1175367600, 1),
            Transition::new(-1159819200, 2),
            Transition::new(-633812400, 1),
            Transition::new(-622062000, 2),
            Transition::new(-602276400, 1),
            Transition::new(-591825600, 2),
            Transition::new(-570740400, 1),
            Transition::new(-560203200, 2),
            Transition::new(-539118000, 1),
            Transition::new(-531345600, 2),
            Transition::new(-191358000, 1),
            Transition::new(-184190400, 2),
            Transition::new(-155156400, 1),
            Transition::new(-150062400, 2),
            Transition::new(-128890800, 1),
            Transition::new(-121118400, 2),
            Transition::new(-99946800, 1),
            Transition::new(-89582400, 2),
            Transition::new(-68410800, 1),
            Transition::new(-57960000, 2),
            Transition::new(499755600, 1),
            Transition::new(511243200, 2),
            Transition::new(530600400, 1),
            Transition::new(540273600, 2),
            Transition::new(562136400, 1),
            Transition::new(571204800, 2),
            Transition::new(1214283600, 3),
            Transition::new(1384056000, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-16272, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_PORTO_VELHO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767210264, 2),
            Transition::new(-1206954000, 1),
            Transition::new(-1191358800, 2),
            Transition::new(-1175371200, 1),
            Transition::new(-1159822800, 2),
            Transition::new(-633816000, 1),
            Transition::new(-622065600, 2),
            Transition::new(-602280000, 1),
            Transition::new(-591829200, 2),
            Transition::new(-570744000, 1),
            Transition::new(-560206800, 2),
            Transition::new(-539121600, 1),
            Transition::new(-531349200, 2),
            Transition::new(-191361600, 1),
            Transition::new(-184194000, 2),
            Transition::new(-155160000, 1),
            Transition::new(-150066000, 2),
            Transition::new(-128894400, 1),
            Transition::new(-121122000, 2),
            Transition::new(-99950400, 1),
            Transition::new(-89586000, 2),
            Transition::new(-68414400, 1),
            Transition::new(-57963600, 2),
            Transition::new(499752000, 1),
            Transition::new(511239600, 2),
            Transition::new(530596800, 1),
            Transition::new(540270000, 2),
            Transition::new(562132800, 1),
            Transition::new(571201200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-15336, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_PORT_AU_PRINCE: TimeZoneRef<'static> =
        match TimeZoneRef::<'static>::new(
            &[
                Transition::new(-2524504240, 1),
                Transition::new(-1670483460, 3),
                Transition::new(421218000, 2),
                Transition::new(436334400, 3),
                Transition::new(452062800, 2),
                Transition::new(467784000, 3),
                Transition::new(483512400, 2),
                Transition::new(499233600, 3),
                Transition::new(514962000, 2),
                Transition::new(530683200, 3),
                Transition::new(546411600, 2),
                Transition::new(562132800, 3),
                Transition::new(576050400, 2),
                Transition::new(594194400, 3),
                Transition::new(607500000, 2),
                Transition::new(625644000, 3),
                Transition::new(638949600, 2),
                Transition::new(657093600, 3),
                Transition::new(671004000, 2),
                Transition::new(688543200, 3),
                Transition::new(702453600, 2),
                Transition::new(719992800, 3),
                Transition::new(733903200, 2),
                Transition::new(752047200, 3),
                Transition::new(765352800, 2),
                Transition::new(783496800, 3),
                Transition::new(796802400, 2),
                Transition::new(814946400, 3),
                Transition::new(828856800, 2),
                Transition::new(846396000, 3),
                Transition::new(860306400, 2),
                Transition::new(877845600, 3),
                Transition::new(1112504400, 2),
                Transition::new(1130644800, 3),
                Transition::new(1143954000, 2),
                Transition::new(1162094400, 3),
                Transition::new(1331449200, 2),
                Transition::new(1352008800, 3),
                Transition::new(1362898800, 2),
                Transition::new(1383458400, 3),
                Transition::new(1394348400, 2),
                Transition::new(1414908000, 3),
                Transition::new(1425798000, 2),
                Transition::new(1446357600, 3),
                Transition::new(1489302000, 2),
            ],
            &{
                const V: [LocalTimeType; 4] = [
                    match LocalTimeType::new(-17360, false, Some(b"LMT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-17340, false, Some(b"PPMT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                ];
                V
            },
            &[],
            &Some({
                const V: TransitionRule = TransitionRule::Alternate(
                    match AlternateTime::new(
                        match LocalTimeType::new(-18000, false, Some(b"EST")) {
                            Ok(v) => v,
                            Err(e) => panic!("{}", e.0),
                        },
                        match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                            Ok(v) => v,
                            Err(e) => panic!("{}", e.0),
                        },
                        RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                            Ok(v) => v,
                            Err(e) => panic!("{}", e.0),
                        }),
                        7200,
                        RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                            Ok(v) => v,
                            Err(e) => panic!("{}", e.0),
                        }),
                        7200,
                    ) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                );
                V
            }),
        ) {
            Ok(v) => v,
            Err(e) => panic!("{}", e.0),
        };

    pub(crate) const AMERICA_PUNTA_ARENAS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524504580, 1),
            Transition::new(-1892661434, 2),
            Transition::new(-1688410800, 1),
            Transition::new(-1619205434, 3),
            Transition::new(-1593806400, 1),
            Transition::new(-1335986234, 4),
            Transition::new(-1317585600, 2),
            Transition::new(-1304362800, 4),
            Transition::new(-1286049600, 2),
            Transition::new(-1272826800, 4),
            Transition::new(-1254513600, 2),
            Transition::new(-1241290800, 4),
            Transition::new(-1222977600, 2),
            Transition::new(-1209754800, 4),
            Transition::new(-1191355200, 2),
            Transition::new(-1178132400, 3),
            Transition::new(-870552000, 2),
            Transition::new(-865278000, 3),
            Transition::new(-718056000, 2),
            Transition::new(-713649600, 3),
            Transition::new(-36619200, 5),
            Transition::new(-23922000, 3),
            Transition::new(-3355200, 5),
            Transition::new(7527600, 3),
            Transition::new(24465600, 5),
            Transition::new(37767600, 3),
            Transition::new(55915200, 5),
            Transition::new(69217200, 3),
            Transition::new(87969600, 5),
            Transition::new(100666800, 3),
            Transition::new(118209600, 5),
            Transition::new(132116400, 3),
            Transition::new(150868800, 5),
            Transition::new(163566000, 3),
            Transition::new(182318400, 5),
            Transition::new(195620400, 3),
            Transition::new(213768000, 5),
            Transition::new(227070000, 3),
            Transition::new(245217600, 5),
            Transition::new(258519600, 3),
            Transition::new(277272000, 5),
            Transition::new(289969200, 3),
            Transition::new(308721600, 5),
            Transition::new(321418800, 3),
            Transition::new(340171200, 5),
            Transition::new(353473200, 3),
            Transition::new(371620800, 5),
            Transition::new(384922800, 3),
            Transition::new(403070400, 5),
            Transition::new(416372400, 3),
            Transition::new(434520000, 5),
            Transition::new(447822000, 3),
            Transition::new(466574400, 5),
            Transition::new(479271600, 3),
            Transition::new(498024000, 5),
            Transition::new(510721200, 3),
            Transition::new(529473600, 5),
            Transition::new(545194800, 3),
            Transition::new(560923200, 5),
            Transition::new(574225200, 3),
            Transition::new(592372800, 5),
            Transition::new(605674800, 3),
            Transition::new(624427200, 5),
            Transition::new(637124400, 3),
            Transition::new(653457600, 5),
            Transition::new(668574000, 3),
            Transition::new(687326400, 5),
            Transition::new(700628400, 3),
            Transition::new(718776000, 5),
            Transition::new(732078000, 3),
            Transition::new(750225600, 5),
            Transition::new(763527600, 3),
            Transition::new(781675200, 5),
            Transition::new(794977200, 3),
            Transition::new(813729600, 5),
            Transition::new(826426800, 3),
            Transition::new(845179200, 5),
            Transition::new(859690800, 3),
            Transition::new(876628800, 5),
            Transition::new(889930800, 3),
            Transition::new(906868800, 5),
            Transition::new(923194800, 3),
            Transition::new(939528000, 5),
            Transition::new(952830000, 3),
            Transition::new(971582400, 5),
            Transition::new(984279600, 3),
            Transition::new(1003032000, 5),
            Transition::new(1015729200, 3),
            Transition::new(1034481600, 5),
            Transition::new(1047178800, 3),
            Transition::new(1065931200, 5),
            Transition::new(1079233200, 3),
            Transition::new(1097380800, 5),
            Transition::new(1110682800, 3),
            Transition::new(1128830400, 5),
            Transition::new(1142132400, 3),
            Transition::new(1160884800, 5),
            Transition::new(1173582000, 3),
            Transition::new(1192334400, 5),
            Transition::new(1206846000, 3),
            Transition::new(1223784000, 5),
            Transition::new(1237086000, 3),
            Transition::new(1255233600, 5),
            Transition::new(1270350000, 3),
            Transition::new(1286683200, 5),
            Transition::new(1304823600, 3),
            Transition::new(1313899200, 5),
            Transition::new(1335668400, 3),
            Transition::new(1346558400, 5),
            Transition::new(1367118000, 3),
            Transition::new(1378612800, 5),
            Transition::new(1398567600, 3),
            Transition::new(1410062400, 5),
            Transition::new(1463281200, 3),
            Transition::new(1471147200, 5),
            Transition::new(1480820400, 6),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(-17020, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-16966, false, Some(b"SMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_RAINY_RIVER: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2366732504, 2),
            Transition::new(-1632067200, 1),
            Transition::new(-1615136400, 2),
            Transition::new(-923248800, 1),
            Transition::new(-880214400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765392400, 2),
            Transition::new(136368000, 1),
            Transition::new(152089200, 2),
            Transition::new(167817600, 1),
            Transition::new(183538800, 2),
            Transition::new(199267200, 1),
            Transition::new(215593200, 2),
            Transition::new(230716800, 1),
            Transition::new(247042800, 2),
            Transition::new(262771200, 1),
            Transition::new(278492400, 2),
            Transition::new(294220800, 1),
            Transition::new(309942000, 2),
            Transition::new(325670400, 1),
            Transition::new(341391600, 2),
            Transition::new(357120000, 1),
            Transition::new(372841200, 2),
            Transition::new(388569600, 1),
            Transition::new(404895600, 2),
            Transition::new(420019200, 1),
            Transition::new(436345200, 2),
            Transition::new(452073600, 1),
            Transition::new(467794800, 2),
            Transition::new(483523200, 1),
            Transition::new(499244400, 2),
            Transition::new(514972800, 1),
            Transition::new(530694000, 2),
            Transition::new(544608000, 1),
            Transition::new(562143600, 2),
            Transition::new(576057600, 1),
            Transition::new(594198000, 2),
            Transition::new(607507200, 1),
            Transition::new(625647600, 2),
            Transition::new(638956800, 1),
            Transition::new(657097200, 2),
            Transition::new(671011200, 1),
            Transition::new(688546800, 2),
            Transition::new(702460800, 1),
            Transition::new(719996400, 2),
            Transition::new(733910400, 1),
            Transition::new(752050800, 2),
            Transition::new(765360000, 1),
            Transition::new(783500400, 2),
            Transition::new(796809600, 1),
            Transition::new(814950000, 2),
            Transition::new(828864000, 1),
            Transition::new(846399600, 2),
            Transition::new(860313600, 1),
            Transition::new(877849200, 2),
            Transition::new(891763200, 1),
            Transition::new(909298800, 2),
            Transition::new(923212800, 1),
            Transition::new(941353200, 2),
            Transition::new(954662400, 1),
            Transition::new(972802800, 2),
            Transition::new(986112000, 1),
            Transition::new(1004252400, 2),
            Transition::new(1018166400, 1),
            Transition::new(1035702000, 2),
            Transition::new(1049616000, 1),
            Transition::new(1067151600, 2),
            Transition::new(1081065600, 1),
            Transition::new(1099206000, 2),
            Transition::new(1112515200, 1),
            Transition::new(1130655600, 2),
            Transition::new(1143964800, 1),
            Transition::new(1162105200, 2),
            Transition::new(1173600000, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-22696, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_RANKIN_INLET: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-410227200, 2),
            Transition::new(-147895200, 1),
            Transition::new(-131565600, 2),
            Transition::new(325670400, 3),
            Transition::new(341391600, 2),
            Transition::new(357120000, 3),
            Transition::new(372841200, 2),
            Transition::new(388569600, 3),
            Transition::new(404895600, 2),
            Transition::new(420019200, 3),
            Transition::new(436345200, 2),
            Transition::new(452073600, 3),
            Transition::new(467794800, 2),
            Transition::new(483523200, 3),
            Transition::new(499244400, 2),
            Transition::new(514972800, 3),
            Transition::new(530694000, 2),
            Transition::new(544608000, 3),
            Transition::new(562143600, 2),
            Transition::new(576057600, 3),
            Transition::new(594198000, 2),
            Transition::new(607507200, 3),
            Transition::new(625647600, 2),
            Transition::new(638956800, 3),
            Transition::new(657097200, 2),
            Transition::new(671011200, 3),
            Transition::new(688546800, 2),
            Transition::new(702460800, 3),
            Transition::new(719996400, 2),
            Transition::new(733910400, 3),
            Transition::new(752050800, 2),
            Transition::new(765360000, 3),
            Transition::new(783500400, 2),
            Transition::new(796809600, 3),
            Transition::new(814950000, 2),
            Transition::new(828864000, 3),
            Transition::new(846399600, 2),
            Transition::new(860313600, 3),
            Transition::new(877849200, 2),
            Transition::new(891763200, 3),
            Transition::new(909298800, 2),
            Transition::new(923212800, 3),
            Transition::new(941353200, 2),
            Transition::new(954662400, 3),
            Transition::new(972802800, 4),
            Transition::new(986112000, 3),
            Transition::new(1004252400, 2),
            Transition::new(1018166400, 3),
            Transition::new(1035702000, 2),
            Transition::new(1049616000, 3),
            Transition::new(1067151600, 2),
            Transition::new(1081065600, 3),
            Transition::new(1099206000, 2),
            Transition::new(1112515200, 3),
            Transition::new(1130655600, 2),
            Transition::new(1143964800, 3),
            Transition::new(1162105200, 2),
            Transition::new(1173600000, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"CDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_RECIFE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767217224, 2),
            Transition::new(-1206957600, 1),
            Transition::new(-1191362400, 2),
            Transition::new(-1175374800, 1),
            Transition::new(-1159826400, 2),
            Transition::new(-633819600, 1),
            Transition::new(-622069200, 2),
            Transition::new(-602283600, 1),
            Transition::new(-591832800, 2),
            Transition::new(-570747600, 1),
            Transition::new(-560210400, 2),
            Transition::new(-539125200, 1),
            Transition::new(-531352800, 2),
            Transition::new(-191365200, 1),
            Transition::new(-184197600, 2),
            Transition::new(-155163600, 1),
            Transition::new(-150069600, 2),
            Transition::new(-128898000, 1),
            Transition::new(-121125600, 2),
            Transition::new(-99954000, 1),
            Transition::new(-89589600, 2),
            Transition::new(-68418000, 1),
            Transition::new(-57967200, 2),
            Transition::new(499748400, 1),
            Transition::new(511236000, 2),
            Transition::new(530593200, 1),
            Transition::new(540266400, 2),
            Transition::new(562129200, 1),
            Transition::new(571197600, 2),
            Transition::new(592974000, 1),
            Transition::new(602042400, 2),
            Transition::new(624423600, 1),
            Transition::new(634701600, 2),
            Transition::new(938919600, 1),
            Transition::new(951616800, 2),
            Transition::new(970974000, 1),
            Transition::new(971575200, 2),
            Transition::new(1003028400, 1),
            Transition::new(1013911200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-8376, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_REGINA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2030202084, 2),
            Transition::new(-1632063600, 1),
            Transition::new(-1615132800, 2),
            Transition::new(-1251651600, 1),
            Transition::new(-1238349600, 2),
            Transition::new(-1220202000, 1),
            Transition::new(-1206900000, 2),
            Transition::new(-1188752400, 1),
            Transition::new(-1175450400, 2),
            Transition::new(-1156698000, 1),
            Transition::new(-1144000800, 2),
            Transition::new(-1125248400, 1),
            Transition::new(-1111946400, 2),
            Transition::new(-1032714000, 1),
            Transition::new(-1016992800, 2),
            Transition::new(-1001264400, 1),
            Transition::new(-986148000, 2),
            Transition::new(-969814800, 1),
            Transition::new(-954093600, 2),
            Transition::new(-937760400, 1),
            Transition::new(-922039200, 2),
            Transition::new(-906310800, 1),
            Transition::new(-890589600, 2),
            Transition::new(-880210800, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765388800, 2),
            Transition::new(-748450800, 1),
            Transition::new(-732729600, 2),
            Transition::new(-715791600, 1),
            Transition::new(-702489600, 2),
            Transition::new(-684342000, 1),
            Transition::new(-671040000, 2),
            Transition::new(-652892400, 1),
            Transition::new(-639590400, 2),
            Transition::new(-620838000, 1),
            Transition::new(-608140800, 2),
            Transition::new(-589388400, 1),
            Transition::new(-576086400, 2),
            Transition::new(-557938800, 1),
            Transition::new(-544636800, 2),
            Transition::new(-526489200, 1),
            Transition::new(-513187200, 2),
            Transition::new(-495039600, 1),
            Transition::new(-481737600, 2),
            Transition::new(-463590000, 1),
            Transition::new(-450288000, 2),
            Transition::new(-431535600, 1),
            Transition::new(-418233600, 2),
            Transition::new(-400086000, 1),
            Transition::new(-386784000, 2),
            Transition::new(-337186800, 1),
            Transition::new(-321465600, 2),
            Transition::new(-305737200, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-25116, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_RESOLUTE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-704937600, 2),
            Transition::new(-147895200, 1),
            Transition::new(-131565600, 2),
            Transition::new(325670400, 3),
            Transition::new(341391600, 2),
            Transition::new(357120000, 3),
            Transition::new(372841200, 2),
            Transition::new(388569600, 3),
            Transition::new(404895600, 2),
            Transition::new(420019200, 3),
            Transition::new(436345200, 2),
            Transition::new(452073600, 3),
            Transition::new(467794800, 2),
            Transition::new(483523200, 3),
            Transition::new(499244400, 2),
            Transition::new(514972800, 3),
            Transition::new(530694000, 2),
            Transition::new(544608000, 3),
            Transition::new(562143600, 2),
            Transition::new(576057600, 3),
            Transition::new(594198000, 2),
            Transition::new(607507200, 3),
            Transition::new(625647600, 2),
            Transition::new(638956800, 3),
            Transition::new(657097200, 2),
            Transition::new(671011200, 3),
            Transition::new(688546800, 2),
            Transition::new(702460800, 3),
            Transition::new(719996400, 2),
            Transition::new(733910400, 3),
            Transition::new(752050800, 2),
            Transition::new(765360000, 3),
            Transition::new(783500400, 2),
            Transition::new(796809600, 3),
            Transition::new(814950000, 2),
            Transition::new(828864000, 3),
            Transition::new(846399600, 2),
            Transition::new(860313600, 3),
            Transition::new(877849200, 2),
            Transition::new(891763200, 3),
            Transition::new(909298800, 2),
            Transition::new(923212800, 3),
            Transition::new(941353200, 2),
            Transition::new(954662400, 3),
            Transition::new(972802800, 4),
            Transition::new(986112000, 3),
            Transition::new(1004252400, 2),
            Transition::new(1018166400, 3),
            Transition::new(1035702000, 2),
            Transition::new(1049616000, 3),
            Transition::new(1067151600, 2),
            Transition::new(1081065600, 3),
            Transition::new(1099206000, 2),
            Transition::new(1112515200, 3),
            Transition::new(1130655600, 2),
            Transition::new(1143964800, 3),
            Transition::new(1162105200, 4),
            Transition::new(1173600000, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"CDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_SANTAREM: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767212472, 2),
            Transition::new(-1206954000, 1),
            Transition::new(-1191358800, 2),
            Transition::new(-1175371200, 1),
            Transition::new(-1159822800, 2),
            Transition::new(-633816000, 1),
            Transition::new(-622065600, 2),
            Transition::new(-602280000, 1),
            Transition::new(-591829200, 2),
            Transition::new(-570744000, 1),
            Transition::new(-560206800, 2),
            Transition::new(-539121600, 1),
            Transition::new(-531349200, 2),
            Transition::new(-191361600, 1),
            Transition::new(-184194000, 2),
            Transition::new(-155160000, 1),
            Transition::new(-150066000, 2),
            Transition::new(-128894400, 1),
            Transition::new(-121122000, 2),
            Transition::new(-99950400, 1),
            Transition::new(-89586000, 2),
            Transition::new(-68414400, 1),
            Transition::new(-57963600, 2),
            Transition::new(499752000, 1),
            Transition::new(511239600, 2),
            Transition::new(530596800, 1),
            Transition::new(540270000, 2),
            Transition::new(562132800, 1),
            Transition::new(571201200, 2),
            Transition::new(1214280000, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-13128, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_SANTIAGO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524504634, 1),
            Transition::new(-1892661434, 2),
            Transition::new(-1688410800, 1),
            Transition::new(-1619205434, 3),
            Transition::new(-1593806400, 1),
            Transition::new(-1335986234, 4),
            Transition::new(-1317585600, 2),
            Transition::new(-1304362800, 4),
            Transition::new(-1286049600, 2),
            Transition::new(-1272826800, 4),
            Transition::new(-1254513600, 2),
            Transition::new(-1241290800, 4),
            Transition::new(-1222977600, 2),
            Transition::new(-1209754800, 4),
            Transition::new(-1191355200, 2),
            Transition::new(-1178132400, 3),
            Transition::new(-870552000, 2),
            Transition::new(-865278000, 3),
            Transition::new(-740520000, 5),
            Transition::new(-736376400, 3),
            Transition::new(-718056000, 2),
            Transition::new(-713649600, 3),
            Transition::new(-36619200, 5),
            Transition::new(-23922000, 3),
            Transition::new(-3355200, 5),
            Transition::new(7527600, 3),
            Transition::new(24465600, 5),
            Transition::new(37767600, 3),
            Transition::new(55915200, 5),
            Transition::new(69217200, 3),
            Transition::new(87969600, 5),
            Transition::new(100666800, 3),
            Transition::new(118209600, 5),
            Transition::new(132116400, 3),
            Transition::new(150868800, 5),
            Transition::new(163566000, 3),
            Transition::new(182318400, 5),
            Transition::new(195620400, 3),
            Transition::new(213768000, 5),
            Transition::new(227070000, 3),
            Transition::new(245217600, 5),
            Transition::new(258519600, 3),
            Transition::new(277272000, 5),
            Transition::new(289969200, 3),
            Transition::new(308721600, 5),
            Transition::new(321418800, 3),
            Transition::new(340171200, 5),
            Transition::new(353473200, 3),
            Transition::new(371620800, 5),
            Transition::new(384922800, 3),
            Transition::new(403070400, 5),
            Transition::new(416372400, 3),
            Transition::new(434520000, 5),
            Transition::new(447822000, 3),
            Transition::new(466574400, 5),
            Transition::new(479271600, 3),
            Transition::new(498024000, 5),
            Transition::new(510721200, 3),
            Transition::new(529473600, 5),
            Transition::new(545194800, 3),
            Transition::new(560923200, 5),
            Transition::new(574225200, 3),
            Transition::new(592372800, 5),
            Transition::new(605674800, 3),
            Transition::new(624427200, 5),
            Transition::new(637124400, 3),
            Transition::new(653457600, 5),
            Transition::new(668574000, 3),
            Transition::new(687326400, 5),
            Transition::new(700628400, 3),
            Transition::new(718776000, 5),
            Transition::new(732078000, 3),
            Transition::new(750225600, 5),
            Transition::new(763527600, 3),
            Transition::new(781675200, 5),
            Transition::new(794977200, 3),
            Transition::new(813729600, 5),
            Transition::new(826426800, 3),
            Transition::new(845179200, 5),
            Transition::new(859690800, 3),
            Transition::new(876628800, 5),
            Transition::new(889930800, 3),
            Transition::new(906868800, 5),
            Transition::new(923194800, 3),
            Transition::new(939528000, 5),
            Transition::new(952830000, 3),
            Transition::new(971582400, 5),
            Transition::new(984279600, 3),
            Transition::new(1003032000, 5),
            Transition::new(1015729200, 3),
            Transition::new(1034481600, 5),
            Transition::new(1047178800, 3),
            Transition::new(1065931200, 5),
            Transition::new(1079233200, 3),
            Transition::new(1097380800, 5),
            Transition::new(1110682800, 3),
            Transition::new(1128830400, 5),
            Transition::new(1142132400, 3),
            Transition::new(1160884800, 5),
            Transition::new(1173582000, 3),
            Transition::new(1192334400, 5),
            Transition::new(1206846000, 3),
            Transition::new(1223784000, 5),
            Transition::new(1237086000, 3),
            Transition::new(1255233600, 5),
            Transition::new(1270350000, 3),
            Transition::new(1286683200, 5),
            Transition::new(1304823600, 3),
            Transition::new(1313899200, 5),
            Transition::new(1335668400, 3),
            Transition::new(1346558400, 5),
            Transition::new(1367118000, 3),
            Transition::new(1378612800, 5),
            Transition::new(1398567600, 3),
            Transition::new(1410062400, 5),
            Transition::new(1463281200, 3),
            Transition::new(1471147200, 5),
            Transition::new(1494730800, 3),
            Transition::new(1502596800, 5),
            Transition::new(1526180400, 3),
            Transition::new(1534046400, 5),
            Transition::new(1554606000, 3),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-16966, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-16966, false, Some(b"SMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-14400, false, Some(b"-04")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-10800, true, Some(b"-03")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(9, 1, 6) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    86400,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 6) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    86400,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_SANTO_DOMINGO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524504824, 1),
            Transition::new(-1159773600, 3),
            Transition::new(-100119600, 2),
            Transition::new(-89668800, 3),
            Transition::new(-5770800, 4),
            Transition::new(4422600, 3),
            Transition::new(25678800, 4),
            Transition::new(33193800, 3),
            Transition::new(57733200, 4),
            Transition::new(64816200, 3),
            Transition::new(89182800, 4),
            Transition::new(96438600, 3),
            Transition::new(120632400, 4),
            Transition::new(127974600, 3),
            Transition::new(152082000, 5),
            Transition::new(972799200, 3),
            Transition::new(975823200, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-16776, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-16800, false, Some(b"SDMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-16200, true, Some(b"-0430")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_SAO_PAULO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1767214412, 2),
            Transition::new(-1206957600, 1),
            Transition::new(-1191362400, 2),
            Transition::new(-1175374800, 1),
            Transition::new(-1159826400, 2),
            Transition::new(-633819600, 1),
            Transition::new(-622069200, 2),
            Transition::new(-602283600, 1),
            Transition::new(-591832800, 2),
            Transition::new(-570747600, 1),
            Transition::new(-560210400, 2),
            Transition::new(-539125200, 1),
            Transition::new(-531352800, 2),
            Transition::new(-195426000, 1),
            Transition::new(-184197600, 2),
            Transition::new(-155163600, 1),
            Transition::new(-150069600, 2),
            Transition::new(-128898000, 1),
            Transition::new(-121125600, 2),
            Transition::new(-99954000, 1),
            Transition::new(-89589600, 2),
            Transition::new(-68418000, 1),
            Transition::new(-57967200, 2),
            Transition::new(499748400, 1),
            Transition::new(511236000, 2),
            Transition::new(530593200, 1),
            Transition::new(540266400, 2),
            Transition::new(562129200, 1),
            Transition::new(571197600, 2),
            Transition::new(592974000, 1),
            Transition::new(602042400, 2),
            Transition::new(624423600, 1),
            Transition::new(634701600, 2),
            Transition::new(656478000, 1),
            Transition::new(666756000, 2),
            Transition::new(687927600, 1),
            Transition::new(697600800, 2),
            Transition::new(719982000, 1),
            Transition::new(728445600, 2),
            Transition::new(750826800, 1),
            Transition::new(761709600, 2),
            Transition::new(782276400, 1),
            Transition::new(793159200, 2),
            Transition::new(813726000, 1),
            Transition::new(824004000, 2),
            Transition::new(844570800, 1),
            Transition::new(856058400, 2),
            Transition::new(876106800, 1),
            Transition::new(888717600, 2),
            Transition::new(908074800, 1),
            Transition::new(919562400, 2),
            Transition::new(938919600, 1),
            Transition::new(951616800, 2),
            Transition::new(970974000, 1),
            Transition::new(982461600, 2),
            Transition::new(1003028400, 1),
            Transition::new(1013911200, 2),
            Transition::new(1036292400, 1),
            Transition::new(1045360800, 2),
            Transition::new(1066532400, 1),
            Transition::new(1076810400, 2),
            Transition::new(1099364400, 1),
            Transition::new(1108864800, 2),
            Transition::new(1129431600, 1),
            Transition::new(1140314400, 2),
            Transition::new(1162695600, 1),
            Transition::new(1172368800, 2),
            Transition::new(1192330800, 1),
            Transition::new(1203213600, 2),
            Transition::new(1224385200, 1),
            Transition::new(1234663200, 2),
            Transition::new(1255834800, 1),
            Transition::new(1266717600, 2),
            Transition::new(1287284400, 1),
            Transition::new(1298167200, 2),
            Transition::new(1318734000, 1),
            Transition::new(1330221600, 2),
            Transition::new(1350788400, 1),
            Transition::new(1361066400, 2),
            Transition::new(1382238000, 1),
            Transition::new(1392516000, 2),
            Transition::new(1413687600, 1),
            Transition::new(1424570400, 2),
            Transition::new(1445137200, 1),
            Transition::new(1456020000, 2),
            Transition::new(1476586800, 1),
            Transition::new(1487469600, 2),
            Transition::new(1508036400, 1),
            Transition::new(1518919200, 2),
            Transition::new(1541300400, 1),
            Transition::new(1550368800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-11188, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_SCORESBYSUND: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1686090728, 1),
            Transition::new(323841600, 2),
            Transition::new(338961600, 1),
            Transition::new(354679200, 4),
            Transition::new(370400400, 3),
            Transition::new(386125200, 4),
            Transition::new(401850000, 3),
            Transition::new(417574800, 4),
            Transition::new(433299600, 3),
            Transition::new(449024400, 4),
            Transition::new(465354000, 3),
            Transition::new(481078800, 4),
            Transition::new(496803600, 3),
            Transition::new(512528400, 4),
            Transition::new(528253200, 3),
            Transition::new(543978000, 4),
            Transition::new(559702800, 3),
            Transition::new(575427600, 4),
            Transition::new(591152400, 3),
            Transition::new(606877200, 4),
            Transition::new(622602000, 3),
            Transition::new(638326800, 4),
            Transition::new(654656400, 3),
            Transition::new(670381200, 4),
            Transition::new(686106000, 3),
            Transition::new(701830800, 4),
            Transition::new(717555600, 3),
            Transition::new(733280400, 4),
            Transition::new(749005200, 3),
            Transition::new(764730000, 4),
            Transition::new(780454800, 3),
            Transition::new(796179600, 4),
            Transition::new(811904400, 3),
            Transition::new(828234000, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-5272, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, false, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, true, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, true, Some(b"+00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-3600, false, Some(b"-01")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(0, true, Some(b"+00")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    3600,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_SITKA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3225223727, 1),
            Transition::new(-2188954727, 2),
            Transition::new(-880207200, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765385200, 2),
            Transition::new(-21477600, 5),
            Transition::new(-5756400, 2),
            Transition::new(9972000, 5),
            Transition::new(25693200, 2),
            Transition::new(41421600, 5),
            Transition::new(57747600, 2),
            Transition::new(73476000, 5),
            Transition::new(89197200, 2),
            Transition::new(104925600, 5),
            Transition::new(120646800, 2),
            Transition::new(126698400, 5),
            Transition::new(152096400, 2),
            Transition::new(162381600, 5),
            Transition::new(183546000, 2),
            Transition::new(199274400, 5),
            Transition::new(215600400, 2),
            Transition::new(230724000, 5),
            Transition::new(247050000, 2),
            Transition::new(262778400, 5),
            Transition::new(278499600, 2),
            Transition::new(294228000, 5),
            Transition::new(309949200, 2),
            Transition::new(325677600, 5),
            Transition::new(341398800, 2),
            Transition::new(357127200, 5),
            Transition::new(372848400, 2),
            Transition::new(388576800, 5),
            Transition::new(404902800, 2),
            Transition::new(420026400, 5),
            Transition::new(436352400, 6),
            Transition::new(439030800, 8),
            Transition::new(452084400, 7),
            Transition::new(467805600, 8),
            Transition::new(483534000, 7),
            Transition::new(499255200, 8),
            Transition::new(514983600, 7),
            Transition::new(530704800, 8),
            Transition::new(544618800, 7),
            Transition::new(562154400, 8),
            Transition::new(576068400, 7),
            Transition::new(594208800, 8),
            Transition::new(607518000, 7),
            Transition::new(625658400, 8),
            Transition::new(638967600, 7),
            Transition::new(657108000, 8),
            Transition::new(671022000, 7),
            Transition::new(688557600, 8),
            Transition::new(702471600, 7),
            Transition::new(720007200, 8),
            Transition::new(733921200, 7),
            Transition::new(752061600, 8),
            Transition::new(765370800, 7),
            Transition::new(783511200, 8),
            Transition::new(796820400, 7),
            Transition::new(814960800, 8),
            Transition::new(828874800, 7),
            Transition::new(846410400, 8),
            Transition::new(860324400, 7),
            Transition::new(877860000, 8),
            Transition::new(891774000, 7),
            Transition::new(909309600, 8),
            Transition::new(923223600, 7),
            Transition::new(941364000, 8),
            Transition::new(954673200, 7),
            Transition::new(972813600, 8),
            Transition::new(986122800, 7),
            Transition::new(1004263200, 8),
            Transition::new(1018177200, 7),
            Transition::new(1035712800, 8),
            Transition::new(1049626800, 7),
            Transition::new(1067162400, 8),
            Transition::new(1081076400, 7),
            Transition::new(1099216800, 8),
            Transition::new(1112526000, 7),
            Transition::new(1130666400, 8),
            Transition::new(1143975600, 7),
            Transition::new(1162116000, 8),
            Transition::new(1173610800, 7),
        ],
        &{
            const V: [LocalTimeType; 9] = [
                match LocalTimeType::new(53927, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32473, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"YST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_ST_JOHNS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713897748, 2),
            Transition::new(-1664130548, 1),
            Transition::new(-1650137348, 2),
            Transition::new(-1632076148, 1),
            Transition::new(-1615145348, 2),
            Transition::new(-1598650148, 1),
            Transition::new(-1590100148, 2),
            Transition::new(-1567286948, 1),
            Transition::new(-1551565748, 2),
            Transition::new(-1535837348, 1),
            Transition::new(-1520116148, 2),
            Transition::new(-1503782948, 1),
            Transition::new(-1488666548, 2),
            Transition::new(-1472333348, 1),
            Transition::new(-1457216948, 2),
            Transition::new(-1440883748, 1),
            Transition::new(-1425767348, 2),
            Transition::new(-1409434148, 1),
            Transition::new(-1394317748, 2),
            Transition::new(-1377984548, 1),
            Transition::new(-1362263348, 2),
            Transition::new(-1346534948, 1),
            Transition::new(-1330813748, 2),
            Transition::new(-1314480548, 1),
            Transition::new(-1299364148, 2),
            Transition::new(-1283030948, 1),
            Transition::new(-1267914548, 2),
            Transition::new(-1251581348, 1),
            Transition::new(-1236464948, 2),
            Transition::new(-1220131748, 1),
            Transition::new(-1205015348, 2),
            Transition::new(-1188682148, 1),
            Transition::new(-1172960948, 2),
            Transition::new(-1156627748, 1),
            Transition::new(-1141511348, 2),
            Transition::new(-1125178148, 1),
            Transition::new(-1110061748, 2),
            Transition::new(-1096921748, 4),
            Transition::new(-1093728600, 3),
            Transition::new(-1078612200, 4),
            Transition::new(-1061670600, 3),
            Transition::new(-1048973400, 4),
            Transition::new(-1030221000, 3),
            Transition::new(-1017523800, 4),
            Transition::new(-998771400, 3),
            Transition::new(-986074200, 4),
            Transition::new(-966717000, 3),
            Transition::new(-954624600, 4),
            Transition::new(-935267400, 3),
            Transition::new(-922570200, 4),
            Transition::new(-903817800, 3),
            Transition::new(-891120600, 4),
            Transition::new(-872368200, 6),
            Transition::new(-769395600, 5),
            Transition::new(-765401400, 4),
            Transition::new(-746044200, 3),
            Transition::new(-733347000, 4),
            Transition::new(-714594600, 3),
            Transition::new(-701897400, 4),
            Transition::new(-683145000, 3),
            Transition::new(-670447800, 4),
            Transition::new(-651695400, 3),
            Transition::new(-638998200, 4),
            Transition::new(-619641000, 3),
            Transition::new(-606943800, 4),
            Transition::new(-589401000, 3),
            Transition::new(-576099000, 4),
            Transition::new(-557951400, 3),
            Transition::new(-544649400, 4),
            Transition::new(-526501800, 3),
            Transition::new(-513199800, 4),
            Transition::new(-495052200, 3),
            Transition::new(-481750200, 4),
            Transition::new(-463602600, 3),
            Transition::new(-450300600, 4),
            Transition::new(-431548200, 3),
            Transition::new(-418246200, 4),
            Transition::new(-400098600, 3),
            Transition::new(-386796600, 4),
            Transition::new(-368649000, 3),
            Transition::new(-355347000, 4),
            Transition::new(-337199400, 3),
            Transition::new(-323897400, 4),
            Transition::new(-305749800, 3),
            Transition::new(-289423800, 4),
            Transition::new(-273695400, 3),
            Transition::new(-257974200, 4),
            Transition::new(-242245800, 3),
            Transition::new(-226524600, 4),
            Transition::new(-210796200, 3),
            Transition::new(-195075000, 4),
            Transition::new(-179346600, 3),
            Transition::new(-163625400, 4),
            Transition::new(-147897000, 3),
            Transition::new(-131571000, 4),
            Transition::new(-116447400, 3),
            Transition::new(-100121400, 4),
            Transition::new(-84393000, 3),
            Transition::new(-68671800, 4),
            Transition::new(-52943400, 3),
            Transition::new(-37222200, 4),
            Transition::new(-21493800, 3),
            Transition::new(-5772600, 4),
            Transition::new(9955800, 3),
            Transition::new(25677000, 4),
            Transition::new(41405400, 3),
            Transition::new(57731400, 4),
            Transition::new(73459800, 3),
            Transition::new(89181000, 4),
            Transition::new(104909400, 3),
            Transition::new(120630600, 4),
            Transition::new(136359000, 3),
            Transition::new(152080200, 4),
            Transition::new(167808600, 3),
            Transition::new(183529800, 4),
            Transition::new(199258200, 3),
            Transition::new(215584200, 4),
            Transition::new(230707800, 3),
            Transition::new(247033800, 4),
            Transition::new(262762200, 3),
            Transition::new(278483400, 4),
            Transition::new(294211800, 3),
            Transition::new(309933000, 4),
            Transition::new(325661400, 3),
            Transition::new(341382600, 4),
            Transition::new(357111000, 3),
            Transition::new(372832200, 4),
            Transition::new(388560600, 3),
            Transition::new(404886600, 4),
            Transition::new(420010200, 3),
            Transition::new(436336200, 4),
            Transition::new(452064600, 3),
            Transition::new(467785800, 4),
            Transition::new(483514200, 3),
            Transition::new(499235400, 4),
            Transition::new(514963800, 3),
            Transition::new(530685000, 4),
            Transition::new(544591860, 3),
            Transition::new(562127460, 4),
            Transition::new(576041460, 7),
            Transition::new(594178260, 4),
            Transition::new(607491060, 3),
            Transition::new(625631460, 4),
            Transition::new(638940660, 3),
            Transition::new(657081060, 4),
            Transition::new(670995060, 3),
            Transition::new(688530660, 4),
            Transition::new(702444660, 3),
            Transition::new(719980260, 4),
            Transition::new(733894260, 3),
            Transition::new(752034660, 4),
            Transition::new(765343860, 3),
            Transition::new(783484260, 4),
            Transition::new(796793460, 3),
            Transition::new(814933860, 4),
            Transition::new(828847860, 3),
            Transition::new(846383460, 4),
            Transition::new(860297460, 3),
            Transition::new(877833060, 4),
            Transition::new(891747060, 3),
            Transition::new(909282660, 4),
            Transition::new(923196660, 3),
            Transition::new(941337060, 4),
            Transition::new(954646260, 3),
            Transition::new(972786660, 4),
            Transition::new(986095860, 3),
            Transition::new(1004236260, 4),
            Transition::new(1018150260, 3),
            Transition::new(1035685860, 4),
            Transition::new(1049599860, 3),
            Transition::new(1067135460, 4),
            Transition::new(1081049460, 3),
            Transition::new(1099189860, 4),
            Transition::new(1112499060, 3),
            Transition::new(1130639460, 4),
            Transition::new(1143948660, 3),
            Transition::new(1162089060, 4),
            Transition::new(1173583860, 3),
            Transition::new(1194143460, 4),
            Transition::new(1205033460, 3),
            Transition::new(1225593060, 4),
            Transition::new(1236483060, 3),
            Transition::new(1257042660, 4),
            Transition::new(1268537460, 3),
            Transition::new(1289097060, 4),
            Transition::new(1299987060, 3),
            Transition::new(1320553800, 4),
        ],
        &{
            const V: [LocalTimeType; 8] = [
                match LocalTimeType::new(-12652, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9052, true, Some(b"NDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-12652, false, Some(b"NST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9000, true, Some(b"NDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-12600, false, Some(b"NST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9000, true, Some(b"NPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-9000, true, Some(b"NWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-5400, true, Some(b"NDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-12600, false, Some(b"NST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-9000, true, Some(b"NDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_SWIFT_CURRENT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2030201320, 2),
            Transition::new(-1632063600, 1),
            Transition::new(-1615132800, 2),
            Transition::new(-880210800, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765388800, 2),
            Transition::new(-747241200, 1),
            Transition::new(-732729600, 2),
            Transition::new(-715791600, 1),
            Transition::new(-702489600, 2),
            Transition::new(-684342000, 1),
            Transition::new(-671040000, 2),
            Transition::new(-652892400, 1),
            Transition::new(-639590400, 2),
            Transition::new(-400086000, 1),
            Transition::new(-384364800, 2),
            Transition::new(-337186800, 1),
            Transition::new(-321465600, 2),
            Transition::new(-305737200, 1),
            Transition::new(-292435200, 2),
            Transition::new(-273682800, 1),
            Transition::new(-260985600, 2),
            Transition::new(73472400, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-25880, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_TEGUCIGALPA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1538503868, 2),
            Transition::new(547020000, 1),
            Transition::new(559717200, 2),
            Transition::new(578469600, 1),
            Transition::new(591166800, 2),
            Transition::new(1146981600, 1),
            Transition::new(1154926800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-20932, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_THULE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1686079492, 2),
            Transition::new(670399200, 1),
            Transition::new(686120400, 2),
            Transition::new(701848800, 1),
            Transition::new(717570000, 2),
            Transition::new(733903200, 1),
            Transition::new(752043600, 2),
            Transition::new(765352800, 1),
            Transition::new(783493200, 2),
            Transition::new(796802400, 1),
            Transition::new(814942800, 2),
            Transition::new(828856800, 1),
            Transition::new(846392400, 2),
            Transition::new(860306400, 1),
            Transition::new(877842000, 2),
            Transition::new(891756000, 1),
            Transition::new(909291600, 2),
            Transition::new(923205600, 1),
            Transition::new(941346000, 2),
            Transition::new(954655200, 1),
            Transition::new(972795600, 2),
            Transition::new(986104800, 1),
            Transition::new(1004245200, 2),
            Transition::new(1018159200, 1),
            Transition::new(1035694800, 2),
            Transition::new(1049608800, 1),
            Transition::new(1067144400, 2),
            Transition::new(1081058400, 1),
            Transition::new(1099198800, 2),
            Transition::new(1112508000, 1),
            Transition::new(1130648400, 2),
            Transition::new(1143957600, 1),
            Transition::new(1162098000, 2),
            Transition::new(1173592800, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-16508, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-14400, false, Some(b"AST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_THUNDER_BAY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2366733780, 1),
            Transition::new(-1893434400, 2),
            Transition::new(-880218000, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765396000, 2),
            Transition::new(9961200, 5),
            Transition::new(25682400, 2),
            Transition::new(41410800, 5),
            Transition::new(57736800, 2),
            Transition::new(73465200, 5),
            Transition::new(89186400, 2),
            Transition::new(136364400, 5),
            Transition::new(152085600, 2),
            Transition::new(167814000, 5),
            Transition::new(183535200, 2),
            Transition::new(199263600, 5),
            Transition::new(215589600, 2),
            Transition::new(230713200, 5),
            Transition::new(247039200, 2),
            Transition::new(262767600, 5),
            Transition::new(278488800, 2),
            Transition::new(294217200, 5),
            Transition::new(309938400, 2),
            Transition::new(325666800, 5),
            Transition::new(341388000, 2),
            Transition::new(357116400, 5),
            Transition::new(372837600, 2),
            Transition::new(388566000, 5),
            Transition::new(404892000, 2),
            Transition::new(420015600, 5),
            Transition::new(436341600, 2),
            Transition::new(452070000, 5),
            Transition::new(467791200, 2),
            Transition::new(483519600, 5),
            Transition::new(499240800, 2),
            Transition::new(514969200, 5),
            Transition::new(530690400, 2),
            Transition::new(544604400, 5),
            Transition::new(562140000, 2),
            Transition::new(576054000, 5),
            Transition::new(594194400, 2),
            Transition::new(607503600, 5),
            Transition::new(625644000, 2),
            Transition::new(638953200, 5),
            Transition::new(657093600, 2),
            Transition::new(671007600, 5),
            Transition::new(688543200, 2),
            Transition::new(702457200, 5),
            Transition::new(719992800, 2),
            Transition::new(733906800, 5),
            Transition::new(752047200, 2),
            Transition::new(765356400, 5),
            Transition::new(783496800, 2),
            Transition::new(796806000, 5),
            Transition::new(814946400, 2),
            Transition::new(828860400, 5),
            Transition::new(846396000, 2),
            Transition::new(860310000, 5),
            Transition::new(877845600, 2),
            Transition::new(891759600, 5),
            Transition::new(909295200, 2),
            Transition::new(923209200, 5),
            Transition::new(941349600, 2),
            Transition::new(954658800, 5),
            Transition::new(972799200, 2),
            Transition::new(986108400, 5),
            Transition::new(1004248800, 2),
            Transition::new(1018162800, 5),
            Transition::new(1035698400, 2),
            Transition::new(1049612400, 5),
            Transition::new(1067148000, 2),
            Transition::new(1081062000, 5),
            Transition::new(1099202400, 2),
            Transition::new(1112511600, 5),
            Transition::new(1130652000, 2),
            Transition::new(1143961200, 5),
            Transition::new(1162101600, 2),
            Transition::new(1173596400, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-21420, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"EST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"EST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"EDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_VANCOUVER: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713880852, 2),
            Transition::new(-1632060000, 1),
            Transition::new(-1615129200, 2),
            Transition::new(-880207200, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765385200, 2),
            Transition::new(-747237600, 1),
            Transition::new(-733935600, 2),
            Transition::new(-715788000, 1),
            Transition::new(-702486000, 2),
            Transition::new(-684338400, 1),
            Transition::new(-671036400, 2),
            Transition::new(-652888800, 1),
            Transition::new(-639586800, 2),
            Transition::new(-620834400, 1),
            Transition::new(-608137200, 2),
            Transition::new(-589384800, 1),
            Transition::new(-576082800, 2),
            Transition::new(-557935200, 1),
            Transition::new(-544633200, 2),
            Transition::new(-526485600, 1),
            Transition::new(-513183600, 2),
            Transition::new(-495036000, 1),
            Transition::new(-481734000, 2),
            Transition::new(-463586400, 1),
            Transition::new(-450284400, 2),
            Transition::new(-431532000, 1),
            Transition::new(-418230000, 2),
            Transition::new(-400082400, 1),
            Transition::new(-386780400, 2),
            Transition::new(-368632800, 1),
            Transition::new(-355330800, 2),
            Transition::new(-337183200, 1),
            Transition::new(-323881200, 2),
            Transition::new(-305733600, 1),
            Transition::new(-292431600, 2),
            Transition::new(-273679200, 1),
            Transition::new(-260982000, 2),
            Transition::new(-242229600, 1),
            Transition::new(-226508400, 2),
            Transition::new(-210780000, 1),
            Transition::new(-195058800, 2),
            Transition::new(-179330400, 1),
            Transition::new(-163609200, 2),
            Transition::new(-147880800, 1),
            Transition::new(-131554800, 2),
            Transition::new(-116431200, 1),
            Transition::new(-100105200, 2),
            Transition::new(-84376800, 1),
            Transition::new(-68655600, 2),
            Transition::new(-52927200, 1),
            Transition::new(-37206000, 2),
            Transition::new(-21477600, 1),
            Transition::new(-5756400, 2),
            Transition::new(9972000, 1),
            Transition::new(25693200, 2),
            Transition::new(41421600, 1),
            Transition::new(57747600, 2),
            Transition::new(73476000, 1),
            Transition::new(89197200, 2),
            Transition::new(104925600, 1),
            Transition::new(120646800, 2),
            Transition::new(136375200, 1),
            Transition::new(152096400, 2),
            Transition::new(167824800, 1),
            Transition::new(183546000, 2),
            Transition::new(199274400, 1),
            Transition::new(215600400, 2),
            Transition::new(230724000, 1),
            Transition::new(247050000, 2),
            Transition::new(262778400, 1),
            Transition::new(278499600, 2),
            Transition::new(294228000, 1),
            Transition::new(309949200, 2),
            Transition::new(325677600, 1),
            Transition::new(341398800, 2),
            Transition::new(357127200, 1),
            Transition::new(372848400, 2),
            Transition::new(388576800, 1),
            Transition::new(404902800, 2),
            Transition::new(420026400, 1),
            Transition::new(436352400, 2),
            Transition::new(452080800, 1),
            Transition::new(467802000, 2),
            Transition::new(483530400, 1),
            Transition::new(499251600, 2),
            Transition::new(514980000, 1),
            Transition::new(530701200, 2),
            Transition::new(544615200, 1),
            Transition::new(562150800, 2),
            Transition::new(576064800, 1),
            Transition::new(594205200, 2),
            Transition::new(607514400, 1),
            Transition::new(625654800, 2),
            Transition::new(638964000, 1),
            Transition::new(657104400, 2),
            Transition::new(671018400, 1),
            Transition::new(688554000, 2),
            Transition::new(702468000, 1),
            Transition::new(720003600, 2),
            Transition::new(733917600, 1),
            Transition::new(752058000, 2),
            Transition::new(765367200, 1),
            Transition::new(783507600, 2),
            Transition::new(796816800, 1),
            Transition::new(814957200, 2),
            Transition::new(828871200, 1),
            Transition::new(846406800, 2),
            Transition::new(860320800, 1),
            Transition::new(877856400, 2),
            Transition::new(891770400, 1),
            Transition::new(909306000, 2),
            Transition::new(923220000, 1),
            Transition::new(941360400, 2),
            Transition::new(954669600, 1),
            Transition::new(972810000, 2),
            Transition::new(986119200, 1),
            Transition::new(1004259600, 2),
            Transition::new(1018173600, 1),
            Transition::new(1035709200, 2),
            Transition::new(1049623200, 1),
            Transition::new(1067158800, 2),
            Transition::new(1081072800, 1),
            Transition::new(1099213200, 2),
            Transition::new(1112522400, 1),
            Transition::new(1130662800, 2),
            Transition::new(1143972000, 1),
            Transition::new(1162112400, 2),
            Transition::new(1173607200, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-29548, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-28800, false, Some(b"PST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_WHITEHORSE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2188997988, 2),
            Transition::new(-1632056400, 1),
            Transition::new(-1615125600, 2),
            Transition::new(-1596978000, 1),
            Transition::new(-1583164800, 2),
            Transition::new(-880203600, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765381600, 2),
            Transition::new(-147884400, 5),
            Transition::new(-131554800, 2),
            Transition::new(-81961200, 6),
            Transition::new(325677600, 7),
            Transition::new(341398800, 6),
            Transition::new(357127200, 7),
            Transition::new(372848400, 6),
            Transition::new(388576800, 7),
            Transition::new(404902800, 6),
            Transition::new(420026400, 7),
            Transition::new(436352400, 6),
            Transition::new(452080800, 7),
            Transition::new(467802000, 6),
            Transition::new(483530400, 7),
            Transition::new(499251600, 6),
            Transition::new(514980000, 7),
            Transition::new(530701200, 6),
            Transition::new(544615200, 7),
            Transition::new(562150800, 6),
            Transition::new(576064800, 7),
            Transition::new(594205200, 6),
            Transition::new(607514400, 7),
            Transition::new(625654800, 6),
            Transition::new(638964000, 7),
            Transition::new(657104400, 6),
            Transition::new(671018400, 7),
            Transition::new(688554000, 6),
            Transition::new(702468000, 7),
            Transition::new(720003600, 6),
            Transition::new(733917600, 7),
            Transition::new(752058000, 6),
            Transition::new(765367200, 7),
            Transition::new(783507600, 6),
            Transition::new(796816800, 7),
            Transition::new(814957200, 6),
            Transition::new(828871200, 7),
            Transition::new(846406800, 6),
            Transition::new(860320800, 7),
            Transition::new(877856400, 6),
            Transition::new(891770400, 7),
            Transition::new(909306000, 6),
            Transition::new(923220000, 7),
            Transition::new(941360400, 6),
            Transition::new(954669600, 7),
            Transition::new(972810000, 6),
            Transition::new(986119200, 7),
            Transition::new(1004259600, 6),
            Transition::new(1018173600, 7),
            Transition::new(1035709200, 6),
            Transition::new(1049623200, 7),
            Transition::new(1067158800, 6),
            Transition::new(1081072800, 7),
            Transition::new(1099213200, 6),
            Transition::new(1112522400, 7),
            Transition::new(1130662800, 6),
            Transition::new(1143972000, 7),
            Transition::new(1162112400, 6),
            Transition::new(1173607200, 7),
            Transition::new(1194166800, 6),
            Transition::new(1205056800, 7),
            Transition::new(1225616400, 6),
            Transition::new(1236506400, 7),
            Transition::new(1257066000, 6),
            Transition::new(1268560800, 7),
            Transition::new(1289120400, 6),
            Transition::new(1300010400, 7),
            Transition::new(1320570000, 6),
            Transition::new(1331460000, 7),
            Transition::new(1352019600, 6),
            Transition::new(1362909600, 7),
            Transition::new(1383469200, 6),
            Transition::new(1394359200, 7),
            Transition::new(1414918800, 6),
            Transition::new(1425808800, 7),
            Transition::new(1446368400, 6),
            Transition::new(1457863200, 7),
            Transition::new(1478422800, 6),
            Transition::new(1489312800, 7),
            Transition::new(1509872400, 6),
            Transition::new(1520762400, 7),
            Transition::new(1541322000, 6),
            Transition::new(1552212000, 7),
            Transition::new(1572771600, 6),
            Transition::new(1583661600, 7),
            Transition::new(1604214000, 8),
        ],
        &{
            const V: [LocalTimeType; 9] = [
                match LocalTimeType::new(-32412, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"YST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"YDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_WINNIPEG: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2602258284, 2),
            Transition::new(-1694368800, 1),
            Transition::new(-1681671600, 2),
            Transition::new(-1632067200, 1),
            Transition::new(-1615136400, 2),
            Transition::new(-1029686400, 1),
            Transition::new(-1018198800, 2),
            Transition::new(-880214400, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765392400, 2),
            Transition::new(-746035200, 1),
            Transition::new(-732733200, 2),
            Transition::new(-715795200, 1),
            Transition::new(-702493200, 2),
            Transition::new(-684345600, 1),
            Transition::new(-671043600, 2),
            Transition::new(-652896000, 1),
            Transition::new(-639594000, 2),
            Transition::new(-620755200, 1),
            Transition::new(-607626000, 2),
            Transition::new(-589392000, 1),
            Transition::new(-576090000, 2),
            Transition::new(-557942400, 1),
            Transition::new(-544640400, 2),
            Transition::new(-526492800, 1),
            Transition::new(-513190800, 2),
            Transition::new(-495043200, 1),
            Transition::new(-481741200, 2),
            Transition::new(-463593600, 1),
            Transition::new(-450291600, 2),
            Transition::new(-431539200, 1),
            Transition::new(-418237200, 2),
            Transition::new(-400089600, 1),
            Transition::new(-386787600, 2),
            Transition::new(-368640000, 1),
            Transition::new(-355338000, 2),
            Transition::new(-337190400, 1),
            Transition::new(-321469200, 2),
            Transition::new(-305740800, 1),
            Transition::new(-292438800, 2),
            Transition::new(-210787200, 1),
            Transition::new(-198090000, 2),
            Transition::new(-116438400, 1),
            Transition::new(-100108800, 2),
            Transition::new(-84384000, 1),
            Transition::new(-68659200, 2),
            Transition::new(-52934400, 1),
            Transition::new(-37209600, 2),
            Transition::new(-21484800, 1),
            Transition::new(-5760000, 2),
            Transition::new(9964800, 1),
            Transition::new(25689600, 2),
            Transition::new(41414400, 1),
            Transition::new(57744000, 2),
            Transition::new(73468800, 1),
            Transition::new(89193600, 2),
            Transition::new(104918400, 1),
            Transition::new(120643200, 2),
            Transition::new(136368000, 1),
            Transition::new(152092800, 2),
            Transition::new(167817600, 1),
            Transition::new(183542400, 2),
            Transition::new(199267200, 1),
            Transition::new(215596800, 2),
            Transition::new(230716800, 1),
            Transition::new(247046400, 2),
            Transition::new(262771200, 1),
            Transition::new(278496000, 2),
            Transition::new(294220800, 1),
            Transition::new(309945600, 2),
            Transition::new(325670400, 1),
            Transition::new(341395200, 2),
            Transition::new(357120000, 1),
            Transition::new(372844800, 2),
            Transition::new(388569600, 1),
            Transition::new(404899200, 2),
            Transition::new(420019200, 1),
            Transition::new(436348800, 2),
            Transition::new(452073600, 1),
            Transition::new(467798400, 2),
            Transition::new(483523200, 1),
            Transition::new(499248000, 2),
            Transition::new(514972800, 1),
            Transition::new(530697600, 2),
            Transition::new(544608000, 1),
            Transition::new(562147200, 2),
            Transition::new(576057600, 1),
            Transition::new(594201600, 2),
            Transition::new(607507200, 1),
            Transition::new(625651200, 2),
            Transition::new(638956800, 1),
            Transition::new(657100800, 2),
            Transition::new(671011200, 1),
            Transition::new(688550400, 2),
            Transition::new(702460800, 1),
            Transition::new(720000000, 2),
            Transition::new(733910400, 1),
            Transition::new(752054400, 2),
            Transition::new(765360000, 1),
            Transition::new(783504000, 2),
            Transition::new(796809600, 1),
            Transition::new(814953600, 2),
            Transition::new(828864000, 1),
            Transition::new(846403200, 2),
            Transition::new(860313600, 1),
            Transition::new(877852800, 2),
            Transition::new(891763200, 1),
            Transition::new(909302400, 2),
            Transition::new(923212800, 1),
            Transition::new(941356800, 2),
            Transition::new(954662400, 1),
            Transition::new(972806400, 2),
            Transition::new(986112000, 1),
            Transition::new(1004256000, 2),
            Transition::new(1018166400, 1),
            Transition::new(1035705600, 2),
            Transition::new(1049616000, 1),
            Transition::new(1067155200, 2),
            Transition::new(1081065600, 1),
            Transition::new(1099209600, 2),
            Transition::new(1112515200, 1),
            Transition::new(1130659200, 2),
            Transition::new(1143964800, 1),
            Transition::new(1162105200, 2),
            Transition::new(1173600000, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-23316, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_YAKUTAT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3225223727, 1),
            Transition::new(-2188953665, 2),
            Transition::new(-880203600, 3),
            Transition::new(-769395600, 4),
            Transition::new(-765381600, 2),
            Transition::new(-21474000, 5),
            Transition::new(-5752800, 2),
            Transition::new(9975600, 5),
            Transition::new(25696800, 2),
            Transition::new(41425200, 5),
            Transition::new(57751200, 2),
            Transition::new(73479600, 5),
            Transition::new(89200800, 2),
            Transition::new(104929200, 5),
            Transition::new(120650400, 2),
            Transition::new(126702000, 5),
            Transition::new(152100000, 2),
            Transition::new(162385200, 5),
            Transition::new(183549600, 2),
            Transition::new(199278000, 5),
            Transition::new(215604000, 2),
            Transition::new(230727600, 5),
            Transition::new(247053600, 2),
            Transition::new(262782000, 5),
            Transition::new(278503200, 2),
            Transition::new(294231600, 5),
            Transition::new(309952800, 2),
            Transition::new(325681200, 5),
            Transition::new(341402400, 2),
            Transition::new(357130800, 5),
            Transition::new(372852000, 2),
            Transition::new(388580400, 5),
            Transition::new(404906400, 2),
            Transition::new(420030000, 5),
            Transition::new(436356000, 2),
            Transition::new(439030800, 7),
            Transition::new(452084400, 6),
            Transition::new(467805600, 7),
            Transition::new(483534000, 6),
            Transition::new(499255200, 7),
            Transition::new(514983600, 6),
            Transition::new(530704800, 7),
            Transition::new(544618800, 6),
            Transition::new(562154400, 7),
            Transition::new(576068400, 6),
            Transition::new(594208800, 7),
            Transition::new(607518000, 6),
            Transition::new(625658400, 7),
            Transition::new(638967600, 6),
            Transition::new(657108000, 7),
            Transition::new(671022000, 6),
            Transition::new(688557600, 7),
            Transition::new(702471600, 6),
            Transition::new(720007200, 7),
            Transition::new(733921200, 6),
            Transition::new(752061600, 7),
            Transition::new(765370800, 6),
            Transition::new(783511200, 7),
            Transition::new(796820400, 6),
            Transition::new(814960800, 7),
            Transition::new(828874800, 6),
            Transition::new(846410400, 7),
            Transition::new(860324400, 6),
            Transition::new(877860000, 7),
            Transition::new(891774000, 6),
            Transition::new(909309600, 7),
            Transition::new(923223600, 6),
            Transition::new(941364000, 7),
            Transition::new(954673200, 6),
            Transition::new(972813600, 7),
            Transition::new(986122800, 6),
            Transition::new(1004263200, 7),
            Transition::new(1018177200, 6),
            Transition::new(1035712800, 7),
            Transition::new(1049626800, 6),
            Transition::new(1067162400, 7),
            Transition::new(1081076400, 6),
            Transition::new(1099216800, 7),
            Transition::new(1112526000, 6),
            Transition::new(1130666400, 7),
            Transition::new(1143975600, 6),
            Transition::new(1162116000, 7),
            Transition::new(1173610800, 6),
        ],
        &{
            const V: [LocalTimeType; 8] = [
                match LocalTimeType::new(52865, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-33535, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"YST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"YDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-32400, false, Some(b"AKST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-28800, true, Some(b"AKDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AMERICA_YELLOWKNIFE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1104537600, 3),
            Transition::new(-880210800, 1),
            Transition::new(-769395600, 2),
            Transition::new(-765388800, 3),
            Transition::new(-147891600, 4),
            Transition::new(-131562000, 3),
            Transition::new(325674000, 5),
            Transition::new(341395200, 3),
            Transition::new(357123600, 5),
            Transition::new(372844800, 3),
            Transition::new(388573200, 5),
            Transition::new(404899200, 3),
            Transition::new(420022800, 5),
            Transition::new(436348800, 3),
            Transition::new(452077200, 5),
            Transition::new(467798400, 3),
            Transition::new(483526800, 5),
            Transition::new(499248000, 3),
            Transition::new(514976400, 5),
            Transition::new(530697600, 3),
            Transition::new(544611600, 5),
            Transition::new(562147200, 3),
            Transition::new(576061200, 5),
            Transition::new(594201600, 3),
            Transition::new(607510800, 5),
            Transition::new(625651200, 3),
            Transition::new(638960400, 5),
            Transition::new(657100800, 3),
            Transition::new(671014800, 5),
            Transition::new(688550400, 3),
            Transition::new(702464400, 5),
            Transition::new(720000000, 3),
            Transition::new(733914000, 5),
            Transition::new(752054400, 3),
            Transition::new(765363600, 5),
            Transition::new(783504000, 3),
            Transition::new(796813200, 5),
            Transition::new(814953600, 3),
            Transition::new(828867600, 5),
            Transition::new(846403200, 3),
            Transition::new(860317200, 5),
            Transition::new(877852800, 3),
            Transition::new(891766800, 5),
            Transition::new(909302400, 3),
            Transition::new(923216400, 5),
            Transition::new(941356800, 3),
            Transition::new(954666000, 5),
            Transition::new(972806400, 3),
            Transition::new(986115600, 5),
            Transition::new(1004256000, 3),
            Transition::new(1018170000, 5),
            Transition::new(1035705600, 3),
            Transition::new(1049619600, 5),
            Transition::new(1067155200, 3),
            Transition::new(1081069200, 5),
            Transition::new(1099209600, 3),
            Transition::new(1112518800, 5),
            Transition::new(1130659200, 3),
            Transition::new(1143968400, 5),
            Transition::new(1162108800, 3),
            Transition::new(1173603600, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"MST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"MDDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-25200, false, Some(b"MST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-21600, true, Some(b"MDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_CASEY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-31536000, 1),
            Transition::new(1255802400, 2),
            Transition::new(1267714800, 1),
            Transition::new(1319738400, 2),
            Transition::new(1329843600, 1),
            Transition::new(1477065600, 2),
            Transition::new(1520701200, 1),
            Transition::new(1538856000, 2),
            Transition::new(1552752000, 1),
            Transition::new(1570129200, 2),
            Transition::new(1583596800, 1),
            Transition::new(1601740860, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, false, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(39600, false, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_DAVIS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-409190400, 1),
            Transition::new(-163062000, 0),
            Transition::new(-28857600, 1),
            Transition::new(1255806000, 2),
            Transition::new(1268251200, 1),
            Transition::new(1319742000, 2),
            Transition::new(1329854400, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_DUMONT_D_URVILLE: TimeZoneRef<'static> =
        match TimeZoneRef::<'static>::new(
            &[
                Transition::new(-2840176120, 1),
                Transition::new(-2366790512, 2),
            ],
            &{
                const V: [LocalTimeType; 3] = [
                    match LocalTimeType::new(35320, false, Some(b"LMT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(35312, false, Some(b"PMMT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(36000, false, Some(b"+10")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                ];
                V
            },
            &[],
            &Some({
                const V: TransitionRule =
                    TransitionRule::Fixed(match LocalTimeType::new(36000, false, Some(b"+10")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    });
                V
            }),
        ) {
            Ok(v) => v,
            Err(e) => panic!("{}", e.0),
        };

    pub(crate) const ANTARCTICA_MACQUARIE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2214259200, 1),
            Transition::new(-1680508800, 2),
            Transition::new(-1665388800, 1),
            Transition::new(-1601719200, 0),
            Transition::new(-687052800, 1),
            Transition::new(-71136000, 2),
            Transition::new(-55411200, 1),
            Transition::new(-37267200, 2),
            Transition::new(-25776000, 1),
            Transition::new(-5817600, 2),
            Transition::new(5673600, 1),
            Transition::new(25632000, 2),
            Transition::new(37728000, 1),
            Transition::new(57686400, 2),
            Transition::new(67968000, 1),
            Transition::new(89136000, 2),
            Transition::new(100022400, 1),
            Transition::new(120585600, 2),
            Transition::new(131472000, 1),
            Transition::new(152035200, 2),
            Transition::new(162921600, 1),
            Transition::new(183484800, 2),
            Transition::new(194976000, 1),
            Transition::new(215539200, 2),
            Transition::new(226425600, 1),
            Transition::new(246988800, 2),
            Transition::new(257875200, 1),
            Transition::new(278438400, 2),
            Transition::new(289324800, 1),
            Transition::new(309888000, 2),
            Transition::new(320774400, 1),
            Transition::new(341337600, 2),
            Transition::new(352224000, 1),
            Transition::new(372787200, 2),
            Transition::new(386092800, 1),
            Transition::new(404841600, 2),
            Transition::new(417542400, 1),
            Transition::new(436291200, 2),
            Transition::new(447177600, 1),
            Transition::new(467740800, 2),
            Transition::new(478627200, 1),
            Transition::new(499190400, 2),
            Transition::new(510076800, 1),
            Transition::new(530035200, 2),
            Transition::new(542736000, 1),
            Transition::new(562089600, 2),
            Transition::new(574790400, 1),
            Transition::new(594144000, 2),
            Transition::new(606240000, 1),
            Transition::new(625593600, 2),
            Transition::new(637689600, 1),
            Transition::new(657043200, 2),
            Transition::new(670348800, 1),
            Transition::new(686678400, 2),
            Transition::new(701798400, 1),
            Transition::new(718128000, 2),
            Transition::new(733248000, 1),
            Transition::new(749577600, 2),
            Transition::new(764697600, 1),
            Transition::new(781027200, 2),
            Transition::new(796147200, 1),
            Transition::new(812476800, 2),
            Transition::new(828201600, 1),
            Transition::new(844531200, 2),
            Transition::new(859651200, 1),
            Transition::new(875980800, 2),
            Transition::new(891100800, 1),
            Transition::new(907430400, 2),
            Transition::new(922550400, 1),
            Transition::new(938880000, 2),
            Transition::new(954000000, 1),
            Transition::new(967305600, 2),
            Transition::new(985449600, 1),
            Transition::new(1002384000, 2),
            Transition::new(1017504000, 1),
            Transition::new(1033833600, 2),
            Transition::new(1048953600, 1),
            Transition::new(1065283200, 2),
            Transition::new(1080403200, 1),
            Transition::new(1096732800, 2),
            Transition::new(1111852800, 1),
            Transition::new(1128182400, 2),
            Transition::new(1143907200, 1),
            Transition::new(1159632000, 2),
            Transition::new(1174752000, 1),
            Transition::new(1191686400, 2),
            Transition::new(1207411200, 1),
            Transition::new(1223136000, 2),
            Transition::new(1238860800, 1),
            Transition::new(1254585600, 2),
            Transition::new(1301760000, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"AEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, true, Some(b"AEDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(36000, false, Some(b"AEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(39600, true, Some(b"AEDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_MAWSON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-501206400, 1),
            Transition::new(1255809600, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_PALMER: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-157766400, 2),
            Transition::new(-152658000, 1),
            Transition::new(-132955200, 2),
            Transition::new(-121122000, 1),
            Transition::new(-101419200, 2),
            Transition::new(-86821200, 1),
            Transition::new(-71092800, 2),
            Transition::new(-54766800, 1),
            Transition::new(-39038400, 2),
            Transition::new(-23317200, 1),
            Transition::new(-7588800, 4),
            Transition::new(128142000, 3),
            Transition::new(136605600, 4),
            Transition::new(389070000, 1),
            Transition::new(403070400, 2),
            Transition::new(416372400, 1),
            Transition::new(434520000, 2),
            Transition::new(447822000, 1),
            Transition::new(466574400, 2),
            Transition::new(479271600, 1),
            Transition::new(498024000, 2),
            Transition::new(510721200, 1),
            Transition::new(529473600, 2),
            Transition::new(545194800, 1),
            Transition::new(560923200, 2),
            Transition::new(574225200, 1),
            Transition::new(592372800, 2),
            Transition::new(605674800, 1),
            Transition::new(624427200, 2),
            Transition::new(637124400, 1),
            Transition::new(653457600, 2),
            Transition::new(668574000, 1),
            Transition::new(687326400, 2),
            Transition::new(700628400, 1),
            Transition::new(718776000, 2),
            Transition::new(732078000, 1),
            Transition::new(750225600, 2),
            Transition::new(763527600, 1),
            Transition::new(781675200, 2),
            Transition::new(794977200, 1),
            Transition::new(813729600, 2),
            Transition::new(826426800, 1),
            Transition::new(845179200, 2),
            Transition::new(859690800, 1),
            Transition::new(876628800, 2),
            Transition::new(889930800, 1),
            Transition::new(906868800, 2),
            Transition::new(923194800, 1),
            Transition::new(939528000, 2),
            Transition::new(952830000, 1),
            Transition::new(971582400, 2),
            Transition::new(984279600, 1),
            Transition::new(1003032000, 2),
            Transition::new(1015729200, 1),
            Transition::new(1034481600, 2),
            Transition::new(1047178800, 1),
            Transition::new(1065931200, 2),
            Transition::new(1079233200, 1),
            Transition::new(1097380800, 2),
            Transition::new(1110682800, 1),
            Transition::new(1128830400, 2),
            Transition::new(1142132400, 1),
            Transition::new(1160884800, 2),
            Transition::new(1173582000, 1),
            Transition::new(1192334400, 2),
            Transition::new(1206846000, 1),
            Transition::new(1223784000, 2),
            Transition::new(1237086000, 1),
            Transition::new(1255233600, 2),
            Transition::new(1270350000, 1),
            Transition::new(1286683200, 2),
            Transition::new(1304823600, 1),
            Transition::new(1313899200, 2),
            Transition::new(1335668400, 1),
            Transition::new(1346558400, 2),
            Transition::new(1367118000, 1),
            Transition::new(1378612800, 2),
            Transition::new(1398567600, 1),
            Transition::new(1410062400, 2),
            Transition::new(1463281200, 1),
            Transition::new(1471147200, 2),
            Transition::new(1480820400, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_ROTHERA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(218246400, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_SYOWA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-719636812, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(11212, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_TROLL: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(1108166400, 2),
            Transition::new(1111885200, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, true, Some(b"+02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"+00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(0, false, Some(b"+00")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(7200, true, Some(b"+02")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    3600,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ANTARCTICA_VOSTOK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-380073600, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(0, false, Some(b"-00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ARCTIC_LONGYEARBYEN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2366757780, 2),
            Transition::new(-1691884800, 1),
            Transition::new(-1680573600, 2),
            Transition::new(-927511200, 1),
            Transition::new(-857257200, 2),
            Transition::new(-844556400, 1),
            Transition::new(-828226800, 2),
            Transition::new(-812502000, 1),
            Transition::new(-796777200, 2),
            Transition::new(-781052400, 1),
            Transition::new(-765327600, 2),
            Transition::new(-340844400, 1),
            Transition::new(-324514800, 2),
            Transition::new(-308790000, 1),
            Transition::new(-293065200, 2),
            Transition::new(-277340400, 1),
            Transition::new(-261615600, 2),
            Transition::new(-245890800, 1),
            Transition::new(-230166000, 2),
            Transition::new(-214441200, 1),
            Transition::new(-198716400, 2),
            Transition::new(-182991600, 1),
            Transition::new(-166662000, 2),
            Transition::new(-147913200, 1),
            Transition::new(-135212400, 2),
            Transition::new(323830800, 1),
            Transition::new(338950800, 2),
            Transition::new(354675600, 1),
            Transition::new(370400400, 2),
            Transition::new(386125200, 1),
            Transition::new(401850000, 2),
            Transition::new(417574800, 1),
            Transition::new(433299600, 2),
            Transition::new(449024400, 1),
            Transition::new(465354000, 2),
            Transition::new(481078800, 1),
            Transition::new(496803600, 2),
            Transition::new(512528400, 1),
            Transition::new(528253200, 2),
            Transition::new(543978000, 1),
            Transition::new(559702800, 2),
            Transition::new(575427600, 1),
            Transition::new(591152400, 2),
            Transition::new(606877200, 1),
            Transition::new(622602000, 2),
            Transition::new(638326800, 1),
            Transition::new(654656400, 2),
            Transition::new(670381200, 1),
            Transition::new(686106000, 2),
            Transition::new(701830800, 1),
            Transition::new(717555600, 2),
            Transition::new(733280400, 1),
            Transition::new(749005200, 2),
            Transition::new(764730000, 1),
            Transition::new(780454800, 2),
            Transition::new(796179600, 1),
            Transition::new(811904400, 2),
            Transition::new(828234000, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(2580, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, true, Some(b"CEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, false, Some(b"CET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(3600, false, Some(b"CET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(7200, true, Some(b"CEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_ALMATY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441170468, 1),
            Transition::new(-1247547600, 3),
            Transition::new(354909600, 2),
            Transition::new(370717200, 3),
            Transition::new(386445600, 2),
            Transition::new(402253200, 3),
            Transition::new(417981600, 2),
            Transition::new(433789200, 3),
            Transition::new(449604000, 2),
            Transition::new(465336000, 3),
            Transition::new(481060800, 2),
            Transition::new(496785600, 3),
            Transition::new(512510400, 2),
            Transition::new(528235200, 3),
            Transition::new(543960000, 2),
            Transition::new(559684800, 3),
            Transition::new(575409600, 2),
            Transition::new(591134400, 3),
            Transition::new(606859200, 2),
            Transition::new(622584000, 3),
            Transition::new(638308800, 2),
            Transition::new(654638400, 3),
            Transition::new(670363200, 4),
            Transition::new(686091600, 1),
            Transition::new(695768400, 3),
            Transition::new(701812800, 2),
            Transition::new(717537600, 3),
            Transition::new(733262400, 2),
            Transition::new(748987200, 3),
            Transition::new(764712000, 2),
            Transition::new(780436800, 3),
            Transition::new(796161600, 2),
            Transition::new(811886400, 3),
            Transition::new(828216000, 2),
            Transition::new(846360000, 3),
            Transition::new(859665600, 2),
            Transition::new(877809600, 3),
            Transition::new(891115200, 2),
            Transition::new(909259200, 3),
            Transition::new(922564800, 2),
            Transition::new(941313600, 3),
            Transition::new(954014400, 2),
            Transition::new(972763200, 3),
            Transition::new(985464000, 2),
            Transition::new(1004212800, 3),
            Transition::new(1017518400, 2),
            Transition::new(1035662400, 3),
            Transition::new(1048968000, 2),
            Transition::new(1067112000, 3),
            Transition::new(1080417600, 2),
            Transition::new(1099166400, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(18468, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, true, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_AMMAN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1230776624, 2),
            Transition::new(108165600, 1),
            Transition::new(118270800, 2),
            Transition::new(136591200, 1),
            Transition::new(149806800, 2),
            Transition::new(168127200, 1),
            Transition::new(181342800, 2),
            Transition::new(199749600, 1),
            Transition::new(215643600, 2),
            Transition::new(231285600, 1),
            Transition::new(244501200, 2),
            Transition::new(262735200, 1),
            Transition::new(275950800, 2),
            Transition::new(481154400, 1),
            Transition::new(496962000, 2),
            Transition::new(512949600, 1),
            Transition::new(528670800, 2),
            Transition::new(544399200, 1),
            Transition::new(560120400, 2),
            Transition::new(575848800, 1),
            Transition::new(592174800, 2),
            Transition::new(610581600, 1),
            Transition::new(623624400, 2),
            Transition::new(641167200, 1),
            Transition::new(655074000, 2),
            Transition::new(671839200, 1),
            Transition::new(685918800, 2),
            Transition::new(702856800, 1),
            Transition::new(717973200, 2),
            Transition::new(733701600, 1),
            Transition::new(749422800, 2),
            Transition::new(765151200, 1),
            Transition::new(779662800, 2),
            Transition::new(797205600, 1),
            Transition::new(811116000, 2),
            Transition::new(828655200, 1),
            Transition::new(843170400, 2),
            Transition::new(860104800, 1),
            Transition::new(874620000, 2),
            Transition::new(891554400, 1),
            Transition::new(906069600, 2),
            Transition::new(930780000, 1),
            Transition::new(938124000, 2),
            Transition::new(954367200, 1),
            Transition::new(970178400, 2),
            Transition::new(985816800, 1),
            Transition::new(1001628000, 2),
            Transition::new(1017352800, 1),
            Transition::new(1033077600, 2),
            Transition::new(1048802400, 1),
            Transition::new(1066946400, 2),
            Transition::new(1080252000, 1),
            Transition::new(1097791200, 2),
            Transition::new(1112306400, 1),
            Transition::new(1128031200, 2),
            Transition::new(1143756000, 1),
            Transition::new(1161900000, 2),
            Transition::new(1175205600, 1),
            Transition::new(1193349600, 2),
            Transition::new(1206655200, 1),
            Transition::new(1225404000, 2),
            Transition::new(1238104800, 1),
            Transition::new(1256853600, 2),
            Transition::new(1269554400, 1),
            Transition::new(1288303200, 2),
            Transition::new(1301608800, 1),
            Transition::new(1319752800, 2),
            Transition::new(1333058400, 1),
            Transition::new(1387486800, 2),
            Transition::new(1395957600, 1),
            Transition::new(1414706400, 2),
            Transition::new(1427407200, 1),
            Transition::new(1446156000, 2),
            Transition::new(1459461600, 1),
            Transition::new(1477605600, 2),
            Transition::new(1490911200, 1),
            Transition::new(1509055200, 2),
            Transition::new(1522360800, 1),
            Transition::new(1540504800, 2),
            Transition::new(1553810400, 1),
            Transition::new(1571954400, 2),
            Transition::new(1585260000, 1),
            Transition::new(1604008800, 2),
            Transition::new(1616709600, 1),
            Transition::new(1635458400, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(8624, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"EEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"EET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(7200, false, Some(b"EET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(10800, true, Some(b"EEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(2, 5, 4) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    86400,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 5) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    3600,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_ANADYR: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441194596, 1),
            Transition::new(-1247572800, 3),
            Transition::new(354884400, 2),
            Transition::new(370692000, 3),
            Transition::new(386420400, 4),
            Transition::new(402231600, 1),
            Transition::new(417960000, 4),
            Transition::new(433767600, 1),
            Transition::new(449582400, 4),
            Transition::new(465314400, 1),
            Transition::new(481039200, 4),
            Transition::new(496764000, 1),
            Transition::new(512488800, 4),
            Transition::new(528213600, 1),
            Transition::new(543938400, 4),
            Transition::new(559663200, 1),
            Transition::new(575388000, 4),
            Transition::new(591112800, 1),
            Transition::new(606837600, 4),
            Transition::new(622562400, 1),
            Transition::new(638287200, 4),
            Transition::new(654616800, 1),
            Transition::new(670341600, 5),
            Transition::new(686070000, 6),
            Transition::new(695746800, 1),
            Transition::new(701791200, 4),
            Transition::new(717516000, 1),
            Transition::new(733240800, 4),
            Transition::new(748965600, 1),
            Transition::new(764690400, 4),
            Transition::new(780415200, 1),
            Transition::new(796140000, 4),
            Transition::new(811864800, 1),
            Transition::new(828194400, 4),
            Transition::new(846338400, 1),
            Transition::new(859644000, 4),
            Transition::new(877788000, 1),
            Transition::new(891093600, 4),
            Transition::new(909237600, 1),
            Transition::new(922543200, 4),
            Transition::new(941292000, 1),
            Transition::new(953992800, 4),
            Transition::new(972741600, 1),
            Transition::new(985442400, 4),
            Transition::new(1004191200, 1),
            Transition::new(1017496800, 4),
            Transition::new(1035640800, 1),
            Transition::new(1048946400, 4),
            Transition::new(1067090400, 1),
            Transition::new(1080396000, 4),
            Transition::new(1099144800, 1),
            Transition::new(1111845600, 4),
            Transition::new(1130594400, 1),
            Transition::new(1143295200, 4),
            Transition::new(1162044000, 1),
            Transition::new(1174744800, 4),
            Transition::new(1193493600, 1),
            Transition::new(1206799200, 4),
            Transition::new(1224943200, 1),
            Transition::new(1238248800, 4),
            Transition::new(1256392800, 1),
            Transition::new(1269698400, 5),
            Transition::new(1288450800, 6),
            Transition::new(1301151600, 1),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(42596, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(43200, false, Some(b"+12")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(50400, true, Some(b"+14")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(46800, false, Some(b"+13")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(46800, true, Some(b"+13")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(43200, true, Some(b"+12")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, false, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(43200, false, Some(b"+12")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_AQTAU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441164064, 1),
            Transition::new(-1247544000, 2),
            Transition::new(370724400, 3),
            Transition::new(386445600, 4),
            Transition::new(402256800, 2),
            Transition::new(417985200, 4),
            Transition::new(433792800, 2),
            Transition::new(449607600, 4),
            Transition::new(465339600, 2),
            Transition::new(481064400, 4),
            Transition::new(496789200, 2),
            Transition::new(512514000, 4),
            Transition::new(528238800, 2),
            Transition::new(543963600, 4),
            Transition::new(559688400, 2),
            Transition::new(575413200, 4),
            Transition::new(591138000, 2),
            Transition::new(606862800, 4),
            Transition::new(622587600, 2),
            Transition::new(638312400, 4),
            Transition::new(654642000, 2),
            Transition::new(670366800, 5),
            Transition::new(686095200, 1),
            Transition::new(695772000, 2),
            Transition::new(701816400, 4),
            Transition::new(717541200, 2),
            Transition::new(733266000, 4),
            Transition::new(748990800, 2),
            Transition::new(764715600, 4),
            Transition::new(780440400, 1),
            Transition::new(796168800, 5),
            Transition::new(811893600, 1),
            Transition::new(828223200, 5),
            Transition::new(846367200, 1),
            Transition::new(859672800, 5),
            Transition::new(877816800, 1),
            Transition::new(891122400, 5),
            Transition::new(909266400, 1),
            Transition::new(922572000, 5),
            Transition::new(941320800, 1),
            Transition::new(954021600, 5),
            Transition::new(972770400, 1),
            Transition::new(985471200, 5),
            Transition::new(1004220000, 1),
            Transition::new(1017525600, 5),
            Transition::new(1035669600, 1),
            Transition::new(1048975200, 5),
            Transition::new(1067119200, 1),
            Transition::new(1080424800, 5),
            Transition::new(1099173600, 2),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(12064, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, true, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_AQTOBE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441165720, 1),
            Transition::new(-1247544000, 2),
            Transition::new(354913200, 3),
            Transition::new(370720800, 4),
            Transition::new(386445600, 3),
            Transition::new(402256800, 2),
            Transition::new(417985200, 3),
            Transition::new(433792800, 2),
            Transition::new(449607600, 3),
            Transition::new(465339600, 2),
            Transition::new(481064400, 3),
            Transition::new(496789200, 2),
            Transition::new(512514000, 3),
            Transition::new(528238800, 2),
            Transition::new(543963600, 3),
            Transition::new(559688400, 2),
            Transition::new(575413200, 3),
            Transition::new(591138000, 2),
            Transition::new(606862800, 3),
            Transition::new(622587600, 2),
            Transition::new(638312400, 3),
            Transition::new(654642000, 2),
            Transition::new(670366800, 5),
            Transition::new(686095200, 1),
            Transition::new(695772000, 2),
            Transition::new(701816400, 3),
            Transition::new(717541200, 2),
            Transition::new(733266000, 3),
            Transition::new(748990800, 2),
            Transition::new(764715600, 3),
            Transition::new(780440400, 2),
            Transition::new(796165200, 3),
            Transition::new(811890000, 2),
            Transition::new(828219600, 3),
            Transition::new(846363600, 2),
            Transition::new(859669200, 3),
            Transition::new(877813200, 2),
            Transition::new(891118800, 3),
            Transition::new(909262800, 2),
            Transition::new(922568400, 3),
            Transition::new(941317200, 2),
            Transition::new(954018000, 3),
            Transition::new(972766800, 2),
            Transition::new(985467600, 3),
            Transition::new(1004216400, 2),
            Transition::new(1017522000, 3),
            Transition::new(1035666000, 2),
            Transition::new(1048971600, 3),
            Transition::new(1067115600, 2),
            Transition::new(1080421200, 3),
            Transition::new(1099170000, 2),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(13720, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, true, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_ASHGABAT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441166012, 1),
            Transition::new(-1247544000, 3),
            Transition::new(354913200, 2),
            Transition::new(370720800, 3),
            Transition::new(386449200, 2),
            Transition::new(402256800, 3),
            Transition::new(417985200, 2),
            Transition::new(433792800, 3),
            Transition::new(449607600, 2),
            Transition::new(465339600, 3),
            Transition::new(481064400, 2),
            Transition::new(496789200, 3),
            Transition::new(512514000, 2),
            Transition::new(528238800, 3),
            Transition::new(543963600, 2),
            Transition::new(559688400, 3),
            Transition::new(575413200, 2),
            Transition::new(591138000, 3),
            Transition::new(606862800, 2),
            Transition::new(622587600, 3),
            Transition::new(638312400, 2),
            Transition::new(654642000, 3),
            Transition::new(670366800, 4),
            Transition::new(686095200, 1),
            Transition::new(695772000, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(14012, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, true, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_ATYRAU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441164464, 1),
            Transition::new(-1247540400, 2),
            Transition::new(370724400, 3),
            Transition::new(386445600, 4),
            Transition::new(402256800, 2),
            Transition::new(417985200, 4),
            Transition::new(433792800, 2),
            Transition::new(449607600, 4),
            Transition::new(465339600, 2),
            Transition::new(481064400, 4),
            Transition::new(496789200, 2),
            Transition::new(512514000, 4),
            Transition::new(528238800, 2),
            Transition::new(543963600, 4),
            Transition::new(559688400, 2),
            Transition::new(575413200, 4),
            Transition::new(591138000, 2),
            Transition::new(606862800, 4),
            Transition::new(622587600, 2),
            Transition::new(638312400, 4),
            Transition::new(654642000, 2),
            Transition::new(670366800, 5),
            Transition::new(686095200, 6),
            Transition::new(695772000, 2),
            Transition::new(701816400, 4),
            Transition::new(717541200, 2),
            Transition::new(733266000, 4),
            Transition::new(748990800, 2),
            Transition::new(764715600, 4),
            Transition::new(780440400, 2),
            Transition::new(796165200, 4),
            Transition::new(811890000, 2),
            Transition::new(828219600, 4),
            Transition::new(846363600, 2),
            Transition::new(859669200, 4),
            Transition::new(877813200, 2),
            Transition::new(891118800, 4),
            Transition::new(909262800, 2),
            Transition::new(922568400, 5),
            Transition::new(941320800, 6),
            Transition::new(954021600, 5),
            Transition::new(972770400, 6),
            Transition::new(985471200, 5),
            Transition::new(1004220000, 6),
            Transition::new(1017525600, 5),
            Transition::new(1035669600, 6),
            Transition::new(1048975200, 5),
            Transition::new(1067119200, 6),
            Transition::new(1080424800, 5),
            Transition::new(1099173600, 2),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(12464, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, true, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_BAGHDAD: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524532260, 1),
            Transition::new(-1641005856, 2),
            Transition::new(389048400, 3),
            Transition::new(402264000, 2),
            Transition::new(417906000, 3),
            Transition::new(433800000, 2),
            Transition::new(449614800, 3),
            Transition::new(465422400, 2),
            Transition::new(481150800, 3),
            Transition::new(496792800, 2),
            Transition::new(512517600, 3),
            Transition::new(528242400, 2),
            Transition::new(543967200, 3),
            Transition::new(559692000, 2),
            Transition::new(575416800, 3),
            Transition::new(591141600, 2),
            Transition::new(606866400, 3),
            Transition::new(622591200, 2),
            Transition::new(638316000, 3),
            Transition::new(654645600, 2),
            Transition::new(670464000, 3),
            Transition::new(686275200, 2),
            Transition::new(702086400, 3),
            Transition::new(717897600, 2),
            Transition::new(733622400, 3),
            Transition::new(749433600, 2),
            Transition::new(765158400, 3),
            Transition::new(780969600, 2),
            Transition::new(796694400, 3),
            Transition::new(812505600, 2),
            Transition::new(828316800, 3),
            Transition::new(844128000, 2),
            Transition::new(859852800, 3),
            Transition::new(875664000, 2),
            Transition::new(891388800, 3),
            Transition::new(907200000, 2),
            Transition::new(922924800, 3),
            Transition::new(938736000, 2),
            Transition::new(954547200, 3),
            Transition::new(970358400, 2),
            Transition::new(986083200, 3),
            Transition::new(1001894400, 2),
            Transition::new(1017619200, 3),
            Transition::new(1033430400, 2),
            Transition::new(1049155200, 3),
            Transition::new(1064966400, 2),
            Transition::new(1080777600, 3),
            Transition::new(1096588800, 2),
            Transition::new(1112313600, 3),
            Transition::new(1128124800, 2),
            Transition::new(1143849600, 3),
            Transition::new(1159660800, 2),
            Transition::new(1175385600, 3),
            Transition::new(1191196800, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(10660, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10656, false, Some(b"BMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, true, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_BAHRAIN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1577935568, 1),
            Transition::new(76190400, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(12368, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_BAKU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441163964, 1),
            Transition::new(-405140400, 3),
            Transition::new(354916800, 2),
            Transition::new(370724400, 3),
            Transition::new(386452800, 2),
            Transition::new(402260400, 3),
            Transition::new(417988800, 2),
            Transition::new(433796400, 3),
            Transition::new(449611200, 2),
            Transition::new(465343200, 3),
            Transition::new(481068000, 2),
            Transition::new(496792800, 3),
            Transition::new(512517600, 2),
            Transition::new(528242400, 3),
            Transition::new(543967200, 2),
            Transition::new(559692000, 3),
            Transition::new(575416800, 2),
            Transition::new(591141600, 3),
            Transition::new(606866400, 2),
            Transition::new(622591200, 3),
            Transition::new(638316000, 2),
            Transition::new(654645600, 3),
            Transition::new(670370400, 4),
            Transition::new(686098800, 1),
            Transition::new(701823600, 4),
            Transition::new(717548400, 3),
            Transition::new(828234000, 2),
            Transition::new(846378000, 3),
            Transition::new(859680000, 2),
            Transition::new(877824000, 3),
            Transition::new(891129600, 2),
            Transition::new(909273600, 3),
            Transition::new(922579200, 2),
            Transition::new(941328000, 3),
            Transition::new(954028800, 2),
            Transition::new(972777600, 3),
            Transition::new(985478400, 2),
            Transition::new(1004227200, 3),
            Transition::new(1017532800, 2),
            Transition::new(1035676800, 3),
            Transition::new(1048982400, 2),
            Transition::new(1067126400, 3),
            Transition::new(1080432000, 2),
            Transition::new(1099180800, 3),
            Transition::new(1111881600, 2),
            Transition::new(1130630400, 3),
            Transition::new(1143331200, 2),
            Transition::new(1162080000, 3),
            Transition::new(1174780800, 2),
            Transition::new(1193529600, 3),
            Transition::new(1206835200, 2),
            Transition::new(1224979200, 3),
            Transition::new(1238284800, 2),
            Transition::new(1256428800, 3),
            Transition::new(1269734400, 2),
            Transition::new(1288483200, 3),
            Transition::new(1301184000, 2),
            Transition::new(1319932800, 3),
            Transition::new(1332633600, 2),
            Transition::new(1351382400, 3),
            Transition::new(1364688000, 2),
            Transition::new(1382832000, 3),
            Transition::new(1396137600, 2),
            Transition::new(1414281600, 3),
            Transition::new(1427587200, 2),
            Transition::new(1445731200, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(11964, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, true, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, true, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_BANGKOK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2840164924, 1),
            Transition::new(-1570084924, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(24124, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(24124, false, Some(b"BMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_BARNAUL: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1579844100, 1),
            Transition::new(-1247551200, 3),
            Transition::new(354906000, 2),
            Transition::new(370713600, 3),
            Transition::new(386442000, 2),
            Transition::new(402249600, 3),
            Transition::new(417978000, 2),
            Transition::new(433785600, 3),
            Transition::new(449600400, 2),
            Transition::new(465332400, 3),
            Transition::new(481057200, 2),
            Transition::new(496782000, 3),
            Transition::new(512506800, 2),
            Transition::new(528231600, 3),
            Transition::new(543956400, 2),
            Transition::new(559681200, 3),
            Transition::new(575406000, 2),
            Transition::new(591130800, 3),
            Transition::new(606855600, 2),
            Transition::new(622580400, 3),
            Transition::new(638305200, 2),
            Transition::new(654634800, 3),
            Transition::new(670359600, 4),
            Transition::new(686088000, 1),
            Transition::new(695764800, 3),
            Transition::new(701809200, 2),
            Transition::new(717534000, 3),
            Transition::new(733258800, 2),
            Transition::new(748983600, 3),
            Transition::new(764708400, 2),
            Transition::new(780433200, 3),
            Transition::new(796158000, 2),
            Transition::new(801590400, 4),
            Transition::new(811886400, 1),
            Transition::new(828216000, 4),
            Transition::new(846360000, 1),
            Transition::new(859665600, 4),
            Transition::new(877809600, 1),
            Transition::new(891115200, 4),
            Transition::new(909259200, 1),
            Transition::new(922564800, 4),
            Transition::new(941313600, 1),
            Transition::new(954014400, 4),
            Transition::new(972763200, 1),
            Transition::new(985464000, 4),
            Transition::new(1004212800, 1),
            Transition::new(1017518400, 4),
            Transition::new(1035662400, 1),
            Transition::new(1048968000, 4),
            Transition::new(1067112000, 1),
            Transition::new(1080417600, 4),
            Transition::new(1099166400, 1),
            Transition::new(1111867200, 4),
            Transition::new(1130616000, 1),
            Transition::new(1143316800, 4),
            Transition::new(1162065600, 1),
            Transition::new(1174766400, 4),
            Transition::new(1193515200, 1),
            Transition::new(1206820800, 4),
            Transition::new(1224964800, 1),
            Transition::new(1238270400, 4),
            Transition::new(1256414400, 1),
            Transition::new(1269720000, 4),
            Transition::new(1288468800, 1),
            Transition::new(1301169600, 3),
            Transition::new(1414263600, 1),
            Transition::new(1459022400, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(20100, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, true, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, true, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_BEIRUT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2840149320, 2),
            Transition::new(-1570413600, 1),
            Transition::new(-1552186800, 2),
            Transition::new(-1538359200, 1),
            Transition::new(-1522551600, 2),
            Transition::new(-1507514400, 1),
            Transition::new(-1490583600, 2),
            Transition::new(-1473645600, 1),
            Transition::new(-1460948400, 2),
            Transition::new(-399866400, 1),
            Transition::new(-386650800, 2),
            Transition::new(-368330400, 1),
            Transition::new(-355114800, 2),
            Transition::new(-336794400, 1),
            Transition::new(-323578800, 2),
            Transition::new(-305172000, 1),
            Transition::new(-291956400, 2),
            Transition::new(-273636000, 1),
            Transition::new(-260420400, 2),
            Transition::new(78012000, 1),
            Transition::new(86734800, 2),
            Transition::new(105055200, 1),
            Transition::new(118270800, 2),
            Transition::new(136591200, 1),
            Transition::new(149806800, 2),
            Transition::new(168127200, 1),
            Transition::new(181342800, 2),
            Transition::new(199749600, 1),
            Transition::new(212965200, 2),
            Transition::new(231285600, 1),
            Transition::new(244501200, 2),
            Transition::new(262735200, 1),
            Transition::new(275950800, 2),
            Transition::new(452210400, 1),
            Transition::new(466722000, 2),
            Transition::new(483746400, 1),
            Transition::new(498258000, 2),
            Transition::new(515282400, 1),
            Transition::new(529794000, 2),
            Transition::new(546818400, 1),
            Transition::new(561330000, 2),
            Transition::new(581119200, 1),
            Transition::new(592952400, 2),
            Transition::new(610754400, 1),
            Transition::new(624488400, 2),
            Transition::new(641512800, 1),
            Transition::new(656024400, 2),
            Transition::new(673048800, 1),
            Transition::new(687560400, 2),
            Transition::new(704671200, 1),
            Transition::new(718146000, 2),
            Transition::new(733269600, 1),
            Transition::new(748990800, 2),
            Transition::new(764719200, 1),
            Transition::new(780440400, 2),
            Transition::new(796168800, 1),
            Transition::new(811890000, 2),
            Transition::new(828223200, 1),
            Transition::new(843944400, 2),
            Transition::new(859672800, 1),
            Transition::new(875394000, 2),
            Transition::new(891122400, 1),
            Transition::new(906843600, 2),
            Transition::new(922572000, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(8520, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"EEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"EET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(7200, false, Some(b"EET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(10800, true, Some(b"EEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_BISHKEK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441169904, 1),
            Transition::new(-1247547600, 3),
            Transition::new(354909600, 2),
            Transition::new(370717200, 3),
            Transition::new(386445600, 2),
            Transition::new(402253200, 3),
            Transition::new(417981600, 2),
            Transition::new(433789200, 3),
            Transition::new(449604000, 2),
            Transition::new(465336000, 3),
            Transition::new(481060800, 2),
            Transition::new(496785600, 3),
            Transition::new(512510400, 2),
            Transition::new(528235200, 3),
            Transition::new(543960000, 2),
            Transition::new(559684800, 3),
            Transition::new(575409600, 2),
            Transition::new(591134400, 3),
            Transition::new(606859200, 2),
            Transition::new(622584000, 3),
            Transition::new(638308800, 2),
            Transition::new(654638400, 3),
            Transition::new(670363200, 4),
            Transition::new(683582400, 1),
            Transition::new(703018800, 4),
            Transition::new(717530400, 1),
            Transition::new(734468400, 4),
            Transition::new(748980000, 1),
            Transition::new(765918000, 4),
            Transition::new(780429600, 1),
            Transition::new(797367600, 4),
            Transition::new(811879200, 1),
            Transition::new(828817200, 4),
            Transition::new(843933600, 1),
            Transition::new(859671000, 4),
            Transition::new(877811400, 1),
            Transition::new(891120600, 4),
            Transition::new(909261000, 1),
            Transition::new(922570200, 4),
            Transition::new(941315400, 1),
            Transition::new(954019800, 4),
            Transition::new(972765000, 1),
            Transition::new(985469400, 4),
            Transition::new(1004214600, 1),
            Transition::new(1017523800, 4),
            Transition::new(1035664200, 1),
            Transition::new(1048973400, 4),
            Transition::new(1067113800, 1),
            Transition::new(1080423000, 4),
            Transition::new(1099168200, 1),
            Transition::new(1111872600, 4),
            Transition::new(1123783200, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(17904, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, true, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_BRUNEI: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1383464380, 1),
            Transition::new(-1167636600, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(27580, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(27000, false, Some(b"+0730")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_CALCUTTA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3645237208, 1),
            Transition::new(-3155694800, 2),
            Transition::new(-2019705670, 3),
            Transition::new(-891581400, 4),
            Transition::new(-872058600, 3),
            Transition::new(-862637400, 4),
            Transition::new(-764145000, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(21208, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21200, false, Some(b"HMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(19270, false, Some(b"MMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(19800, false, Some(b"IST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(23400, true, Some(b"+0630")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(19800, false, Some(b"IST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_CHITA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1579419232, 1),
            Transition::new(-1247558400, 3),
            Transition::new(354898800, 2),
            Transition::new(370706400, 3),
            Transition::new(386434800, 2),
            Transition::new(402242400, 3),
            Transition::new(417970800, 2),
            Transition::new(433778400, 3),
            Transition::new(449593200, 2),
            Transition::new(465325200, 3),
            Transition::new(481050000, 2),
            Transition::new(496774800, 3),
            Transition::new(512499600, 2),
            Transition::new(528224400, 3),
            Transition::new(543949200, 2),
            Transition::new(559674000, 3),
            Transition::new(575398800, 2),
            Transition::new(591123600, 3),
            Transition::new(606848400, 2),
            Transition::new(622573200, 3),
            Transition::new(638298000, 2),
            Transition::new(654627600, 3),
            Transition::new(670352400, 4),
            Transition::new(686080800, 1),
            Transition::new(695757600, 3),
            Transition::new(701802000, 2),
            Transition::new(717526800, 3),
            Transition::new(733251600, 2),
            Transition::new(748976400, 3),
            Transition::new(764701200, 2),
            Transition::new(780426000, 3),
            Transition::new(796150800, 2),
            Transition::new(811875600, 3),
            Transition::new(828205200, 2),
            Transition::new(846349200, 3),
            Transition::new(859654800, 2),
            Transition::new(877798800, 3),
            Transition::new(891104400, 2),
            Transition::new(909248400, 3),
            Transition::new(922554000, 2),
            Transition::new(941302800, 3),
            Transition::new(954003600, 2),
            Transition::new(972752400, 3),
            Transition::new(985453200, 2),
            Transition::new(1004202000, 3),
            Transition::new(1017507600, 2),
            Transition::new(1035651600, 3),
            Transition::new(1048957200, 2),
            Transition::new(1067101200, 3),
            Transition::new(1080406800, 2),
            Transition::new(1099155600, 3),
            Transition::new(1111856400, 2),
            Transition::new(1130605200, 3),
            Transition::new(1143306000, 2),
            Transition::new(1162054800, 3),
            Transition::new(1174755600, 2),
            Transition::new(1193504400, 3),
            Transition::new(1206810000, 2),
            Transition::new(1224954000, 3),
            Transition::new(1238259600, 2),
            Transition::new(1256403600, 3),
            Transition::new(1269709200, 2),
            Transition::new(1288458000, 3),
            Transition::new(1301158800, 5),
            Transition::new(1414252800, 1),
            Transition::new(1459015200, 3),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(27232, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, true, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, true, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_CHOIBALSAN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2032933080, 1),
            Transition::new(252435600, 2),
            Transition::new(417974400, 4),
            Transition::new(433778400, 3),
            Transition::new(449593200, 4),
            Transition::new(465314400, 3),
            Transition::new(481042800, 4),
            Transition::new(496764000, 3),
            Transition::new(512492400, 4),
            Transition::new(528213600, 3),
            Transition::new(543942000, 4),
            Transition::new(559663200, 3),
            Transition::new(575391600, 4),
            Transition::new(591112800, 3),
            Transition::new(606841200, 4),
            Transition::new(622562400, 3),
            Transition::new(638290800, 4),
            Transition::new(654616800, 3),
            Transition::new(670345200, 4),
            Transition::new(686066400, 3),
            Transition::new(701794800, 4),
            Transition::new(717516000, 3),
            Transition::new(733244400, 4),
            Transition::new(748965600, 3),
            Transition::new(764694000, 4),
            Transition::new(780415200, 3),
            Transition::new(796143600, 4),
            Transition::new(811864800, 3),
            Transition::new(828198000, 4),
            Transition::new(843919200, 3),
            Transition::new(859647600, 4),
            Transition::new(875368800, 3),
            Transition::new(891097200, 4),
            Transition::new(906818400, 3),
            Transition::new(988390800, 4),
            Transition::new(1001692800, 3),
            Transition::new(1017421200, 4),
            Transition::new(1033142400, 3),
            Transition::new(1048870800, 4),
            Transition::new(1064592000, 3),
            Transition::new(1080320400, 4),
            Transition::new(1096041600, 3),
            Transition::new(1111770000, 4),
            Transition::new(1127491200, 3),
            Transition::new(1143219600, 4),
            Transition::new(1159545600, 3),
            Transition::new(1206889200, 2),
            Transition::new(1427479200, 5),
            Transition::new(1443193200, 2),
            Transition::new(1458928800, 5),
            Transition::new(1474642800, 2),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(27480, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, true, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, true, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_COLOMBO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2840159964, 1),
            Transition::new(-2019705572, 2),
            Transition::new(-883287000, 3),
            Transition::new(-862639200, 4),
            Transition::new(-764051400, 2),
            Transition::new(832962600, 5),
            Transition::new(846266400, 6),
            Transition::new(1145039400, 2),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(19164, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(19172, false, Some(b"MMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(19800, false, Some(b"+0530")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(23400, true, Some(b"+0630")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(23400, false, Some(b"+0630")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(19800, false, Some(b"+0530")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_DACCA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524543300, 1),
            Transition::new(-891582800, 2),
            Transition::new(-872058600, 3),
            Transition::new(-862637400, 2),
            Transition::new(-576138600, 4),
            Transition::new(1245430800, 5),
            Transition::new(1262278800, 4),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(21700, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21200, false, Some(b"HMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(23400, false, Some(b"+0630")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(19800, false, Some(b"+0530")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, true, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_DAMASCUS: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1577931912, 2),
            Transition::new(-1568592000, 1),
            Transition::new(-1554080400, 2),
            Transition::new(-1537142400, 1),
            Transition::new(-1522630800, 2),
            Transition::new(-1505692800, 1),
            Transition::new(-1491181200, 2),
            Transition::new(-1474243200, 1),
            Transition::new(-1459126800, 2),
            Transition::new(-242265600, 1),
            Transition::new(-228877200, 2),
            Transition::new(-210556800, 1),
            Transition::new(-197427600, 2),
            Transition::new(-178934400, 1),
            Transition::new(-165718800, 2),
            Transition::new(-147398400, 1),
            Transition::new(-134269200, 2),
            Transition::new(-116467200, 1),
            Transition::new(-102646800, 2),
            Transition::new(-84326400, 1),
            Transition::new(-71110800, 2),
            Transition::new(-52704000, 1),
            Transition::new(-39488400, 2),
            Transition::new(-21168000, 1),
            Transition::new(-7952400, 2),
            Transition::new(10368000, 1),
            Transition::new(23583600, 2),
            Transition::new(41904000, 1),
            Transition::new(55119600, 2),
            Transition::new(73526400, 1),
            Transition::new(86742000, 2),
            Transition::new(105062400, 1),
            Transition::new(118278000, 2),
            Transition::new(136598400, 1),
            Transition::new(149814000, 2),
            Transition::new(168134400, 1),
            Transition::new(181350000, 2),
            Transition::new(199756800, 1),
            Transition::new(212972400, 2),
            Transition::new(231292800, 1),
            Transition::new(241916400, 2),
            Transition::new(262828800, 1),
            Transition::new(273452400, 2),
            Transition::new(418694400, 1),
            Transition::new(433810800, 2),
            Transition::new(450316800, 1),
            Transition::new(465433200, 2),
            Transition::new(508896000, 1),
            Transition::new(529196400, 2),
            Transition::new(541555200, 1),
            Transition::new(562633200, 2),
            Transition::new(574387200, 1),
            Transition::new(594255600, 2),
            Transition::new(607305600, 1),
            Transition::new(623199600, 2),
            Transition::new(638928000, 1),
            Transition::new(654649200, 2),
            Transition::new(670456800, 1),
            Transition::new(686264400, 2),
            Transition::new(702684000, 1),
            Transition::new(717886800, 2),
            Transition::new(733096800, 1),
            Transition::new(748904400, 2),
            Transition::new(765151200, 1),
            Transition::new(780958800, 2),
            Transition::new(796687200, 1),
            Transition::new(812494800, 2),
            Transition::new(828309600, 1),
            Transition::new(844117200, 2),
            Transition::new(859759200, 1),
            Transition::new(875653200, 2),
            Transition::new(891208800, 1),
            Transition::new(907189200, 2),
            Transition::new(922917600, 1),
            Transition::new(938725200, 2),
            Transition::new(954540000, 1),
            Transition::new(970347600, 2),
            Transition::new(986076000, 1),
            Transition::new(1001883600, 2),
            Transition::new(1017612000, 1),
            Transition::new(1033419600, 2),
            Transition::new(1049148000, 1),
            Transition::new(1064955600, 2),
            Transition::new(1080770400, 1),
            Transition::new(1096578000, 2),
            Transition::new(1112306400, 1),
            Transition::new(1128114000, 2),
            Transition::new(1143842400, 1),
            Transition::new(1158872400, 2),
            Transition::new(1175205600, 1),
            Transition::new(1193950800, 2),
            Transition::new(1207260000, 1),
            Transition::new(1225486800, 2),
            Transition::new(1238104800, 1),
            Transition::new(1256850000, 2),
            Transition::new(1270159200, 1),
            Transition::new(1288299600, 2),
            Transition::new(1301608800, 1),
            Transition::new(1319749200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(8712, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"EEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"EET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(7200, false, Some(b"EET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(10800, true, Some(b"EEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 5) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 5) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_DILI: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1830414140, 1),
            Transition::new(-879152400, 2),
            Transition::new(199897200, 1),
            Transition::new(969120000, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(30140, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_DUBAI: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1577936472, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(13272, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_DUSHANBE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441168512, 1),
            Transition::new(-1247547600, 3),
            Transition::new(354909600, 2),
            Transition::new(370717200, 3),
            Transition::new(386445600, 2),
            Transition::new(402253200, 3),
            Transition::new(417981600, 2),
            Transition::new(433789200, 3),
            Transition::new(449604000, 2),
            Transition::new(465336000, 3),
            Transition::new(481060800, 2),
            Transition::new(496785600, 3),
            Transition::new(512510400, 2),
            Transition::new(528235200, 3),
            Transition::new(543960000, 2),
            Transition::new(559684800, 3),
            Transition::new(575409600, 2),
            Transition::new(591134400, 3),
            Transition::new(606859200, 2),
            Transition::new(622584000, 3),
            Transition::new(638308800, 2),
            Transition::new(654638400, 3),
            Transition::new(670363200, 4),
            Transition::new(684363600, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(16512, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, true, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_FAMAGUSTA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1518920148, 2),
            Transition::new(166572000, 1),
            Transition::new(182293200, 2),
            Transition::new(200959200, 1),
            Transition::new(213829200, 2),
            Transition::new(228866400, 1),
            Transition::new(243982800, 2),
            Transition::new(260316000, 1),
            Transition::new(276123600, 2),
            Transition::new(291765600, 1),
            Transition::new(307486800, 2),
            Transition::new(323820000, 1),
            Transition::new(338936400, 2),
            Transition::new(354664800, 1),
            Transition::new(370386000, 2),
            Transition::new(386114400, 1),
            Transition::new(401835600, 2),
            Transition::new(417564000, 1),
            Transition::new(433285200, 2),
            Transition::new(449013600, 1),
            Transition::new(465339600, 2),
            Transition::new(481068000, 1),
            Transition::new(496789200, 2),
            Transition::new(512517600, 1),
            Transition::new(528238800, 2),
            Transition::new(543967200, 1),
            Transition::new(559688400, 2),
            Transition::new(575416800, 1),
            Transition::new(591138000, 2),
            Transition::new(606866400, 1),
            Transition::new(622587600, 2),
            Transition::new(638316000, 1),
            Transition::new(654642000, 2),
            Transition::new(670370400, 1),
            Transition::new(686091600, 2),
            Transition::new(701820000, 1),
            Transition::new(717541200, 2),
            Transition::new(733269600, 1),
            Transition::new(748990800, 2),
            Transition::new(764719200, 1),
            Transition::new(780440400, 2),
            Transition::new(796168800, 1),
            Transition::new(811890000, 2),
            Transition::new(828223200, 1),
            Transition::new(843944400, 2),
            Transition::new(859672800, 1),
            Transition::new(875394000, 2),
            Transition::new(891122400, 1),
            Transition::new(909277200, 2),
            Transition::new(922582800, 1),
            Transition::new(941331600, 2),
            Transition::new(954032400, 1),
            Transition::new(972781200, 2),
            Transition::new(985482000, 1),
            Transition::new(1004230800, 2),
            Transition::new(1017536400, 1),
            Transition::new(1035680400, 2),
            Transition::new(1048986000, 1),
            Transition::new(1067130000, 2),
            Transition::new(1080435600, 1),
            Transition::new(1099184400, 2),
            Transition::new(1111885200, 1),
            Transition::new(1130634000, 2),
            Transition::new(1143334800, 1),
            Transition::new(1162083600, 2),
            Transition::new(1174784400, 1),
            Transition::new(1193533200, 2),
            Transition::new(1206838800, 1),
            Transition::new(1224982800, 2),
            Transition::new(1238288400, 1),
            Transition::new(1256432400, 2),
            Transition::new(1269738000, 1),
            Transition::new(1288486800, 2),
            Transition::new(1301187600, 1),
            Transition::new(1319936400, 2),
            Transition::new(1332637200, 1),
            Transition::new(1351386000, 2),
            Transition::new(1364691600, 1),
            Transition::new(1382835600, 2),
            Transition::new(1396141200, 1),
            Transition::new(1414285200, 2),
            Transition::new(1427590800, 1),
            Transition::new(1445734800, 2),
            Transition::new(1459040400, 1),
            Transition::new(1473282000, 3),
            Transition::new(1509238800, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(8148, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"EEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"EET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(7200, false, Some(b"EET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(10800, true, Some(b"EEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    14400,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_GAZA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2185409872, 2),
            Transition::new(-933638400, 1),
            Transition::new(-923097600, 2),
            Transition::new(-919036800, 1),
            Transition::new(-857347200, 2),
            Transition::new(-844300800, 1),
            Transition::new(-825811200, 2),
            Transition::new(-812678400, 1),
            Transition::new(-794188800, 2),
            Transition::new(-779846400, 1),
            Transition::new(-762652800, 2),
            Transition::new(-748310400, 1),
            Transition::new(-731116800, 2),
            Transition::new(-399088800, 1),
            Transition::new(-386650800, 2),
            Transition::new(-368330400, 1),
            Transition::new(-355114800, 2),
            Transition::new(-336790800, 1),
            Transition::new(-323654400, 2),
            Transition::new(-305168400, 1),
            Transition::new(-292032000, 2),
            Transition::new(-273632400, 1),
            Transition::new(-260496000, 2),
            Transition::new(-242096400, 1),
            Transition::new(-228960000, 2),
            Transition::new(-210560400, 1),
            Transition::new(-197424000, 2),
            Transition::new(-178938000, 1),
            Transition::new(-165801600, 2),
            Transition::new(-147402000, 1),
            Transition::new(-134265600, 2),
            Transition::new(-115866000, 1),
            Transition::new(-102643200, 2),
            Transition::new(-84330000, 1),
            Transition::new(-81313200, 4),
            Transition::new(142380000, 3),
            Transition::new(150843600, 4),
            Transition::new(167176800, 3),
            Transition::new(178664400, 4),
            Transition::new(334101600, 3),
            Transition::new(337730400, 4),
            Transition::new(452642400, 3),
            Transition::new(462319200, 4),
            Transition::new(482277600, 3),
            Transition::new(494370000, 4),
            Transition::new(516751200, 3),
            Transition::new(526424400, 4),
            Transition::new(545436000, 3),
            Transition::new(558478800, 4),
            Transition::new(576626400, 3),
            Transition::new(589323600, 4),
            Transition::new(609890400, 3),
            Transition::new(620773200, 4),
            Transition::new(638316000, 3),
            Transition::new(651618000, 4),
            Transition::new(669765600, 3),
            Transition::new(683672400, 4),
            Transition::new(701820000, 3),
            Transition::new(715726800, 4),
            Transition::new(733701600, 3),
            Transition::new(747176400, 4),
            Transition::new(765151200, 3),
            Transition::new(778021200, 4),
            Transition::new(796600800, 3),
            Transition::new(810075600, 4),
            Transition::new(820447200, 2),
            Transition::new(828655200, 1),
            Transition::new(843170400, 2),
            Transition::new(860104800, 1),
            Transition::new(874620000, 2),
            Transition::new(891554400, 1),
            Transition::new(906069600, 2),
            Transition::new(924213600, 1),
            Transition::new(939934800, 2),
            Transition::new(956268000, 1),
            Transition::new(971989200, 2),
            Transition::new(987717600, 1),
            Transition::new(1003438800, 2),
            Transition::new(1019167200, 1),
            Transition::new(1034888400, 2),
            Transition::new(1050616800, 1),
            Transition::new(1066338000, 2),
            Transition::new(1082066400, 1),
            Transition::new(1096581600, 2),
            Transition::new(1113516000, 1),
            Transition::new(1128380400, 2),
            Transition::new(1143842400, 1),
            Transition::new(1158872400, 2),
            Transition::new(1175378400, 1),
            Transition::new(1189638000, 2),
            Transition::new(1206655200, 1),
            Transition::new(1219957200, 2),
            Transition::new(1238104800, 1),
            Transition::new(1252015200, 2),
            Transition::new(1269640860, 1),
            Transition::new(1281474000, 2),
            Transition::new(1301608860, 1),
            Transition::new(1312146000, 2),
            Transition::new(1333058400, 1),
            Transition::new(1348178400, 2),
            Transition::new(1364508000, 1),
            Transition::new(1380229200, 2),
            Transition::new(1395957600, 1),
            Transition::new(1414098000, 2),
            Transition::new(1427493600, 1),
            Transition::new(1445551200, 2),
            Transition::new(1458946800, 1),
            Transition::new(1477692000, 2),
            Transition::new(1490396400, 1),
            Transition::new(1509141600, 2),
            Transition::new(1521846000, 1),
            Transition::new(1540591200, 2),
            Transition::new(1553810400, 1),
            Transition::new(1572037200, 2),
            Transition::new(1585346400, 1),
            Transition::new(1603490400, 2),
            Transition::new(1616796000, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(8272, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"EEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"EET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"IDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"IST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(7200, false, Some(b"EET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(10800, true, Some(b"EEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 4, 4) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    172800,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 5) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    3600,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_HEBRON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2185410023, 2),
            Transition::new(-933638400, 1),
            Transition::new(-923097600, 2),
            Transition::new(-919036800, 1),
            Transition::new(-857347200, 2),
            Transition::new(-844300800, 1),
            Transition::new(-825811200, 2),
            Transition::new(-812678400, 1),
            Transition::new(-794188800, 2),
            Transition::new(-779846400, 1),
            Transition::new(-762652800, 2),
            Transition::new(-748310400, 1),
            Transition::new(-731116800, 2),
            Transition::new(-399088800, 1),
            Transition::new(-386650800, 2),
            Transition::new(-368330400, 1),
            Transition::new(-355114800, 2),
            Transition::new(-336790800, 1),
            Transition::new(-323654400, 2),
            Transition::new(-305168400, 1),
            Transition::new(-292032000, 2),
            Transition::new(-273632400, 1),
            Transition::new(-260496000, 2),
            Transition::new(-242096400, 1),
            Transition::new(-228960000, 2),
            Transition::new(-210560400, 1),
            Transition::new(-197424000, 2),
            Transition::new(-178938000, 1),
            Transition::new(-165801600, 2),
            Transition::new(-147402000, 1),
            Transition::new(-134265600, 2),
            Transition::new(-115866000, 1),
            Transition::new(-102643200, 2),
            Transition::new(-84330000, 1),
            Transition::new(-81313200, 4),
            Transition::new(142380000, 3),
            Transition::new(150843600, 4),
            Transition::new(167176800, 3),
            Transition::new(178664400, 4),
            Transition::new(334101600, 3),
            Transition::new(337730400, 4),
            Transition::new(452642400, 3),
            Transition::new(462319200, 4),
            Transition::new(482277600, 3),
            Transition::new(494370000, 4),
            Transition::new(516751200, 3),
            Transition::new(526424400, 4),
            Transition::new(545436000, 3),
            Transition::new(558478800, 4),
            Transition::new(576626400, 3),
            Transition::new(589323600, 4),
            Transition::new(609890400, 3),
            Transition::new(620773200, 4),
            Transition::new(638316000, 3),
            Transition::new(651618000, 4),
            Transition::new(669765600, 3),
            Transition::new(683672400, 4),
            Transition::new(701820000, 3),
            Transition::new(715726800, 4),
            Transition::new(733701600, 3),
            Transition::new(747176400, 4),
            Transition::new(765151200, 3),
            Transition::new(778021200, 4),
            Transition::new(796600800, 3),
            Transition::new(810075600, 4),
            Transition::new(820447200, 2),
            Transition::new(828655200, 1),
            Transition::new(843170400, 2),
            Transition::new(860104800, 1),
            Transition::new(874620000, 2),
            Transition::new(891554400, 1),
            Transition::new(906069600, 2),
            Transition::new(924213600, 1),
            Transition::new(939934800, 2),
            Transition::new(956268000, 1),
            Transition::new(971989200, 2),
            Transition::new(987717600, 1),
            Transition::new(1003438800, 2),
            Transition::new(1019167200, 1),
            Transition::new(1034888400, 2),
            Transition::new(1050616800, 1),
            Transition::new(1066338000, 2),
            Transition::new(1082066400, 1),
            Transition::new(1096581600, 2),
            Transition::new(1113516000, 1),
            Transition::new(1128380400, 2),
            Transition::new(1143842400, 1),
            Transition::new(1158872400, 2),
            Transition::new(1175378400, 1),
            Transition::new(1189638000, 2),
            Transition::new(1206655200, 1),
            Transition::new(1220216400, 2),
            Transition::new(1238104800, 1),
            Transition::new(1252015200, 2),
            Transition::new(1269554400, 1),
            Transition::new(1281474000, 2),
            Transition::new(1301608860, 1),
            Transition::new(1312146000, 2),
            Transition::new(1314655200, 1),
            Transition::new(1317330000, 2),
            Transition::new(1333058400, 1),
            Transition::new(1348178400, 2),
            Transition::new(1364508000, 1),
            Transition::new(1380229200, 2),
            Transition::new(1395957600, 1),
            Transition::new(1414098000, 2),
            Transition::new(1427493600, 1),
            Transition::new(1445551200, 2),
            Transition::new(1458946800, 1),
            Transition::new(1477692000, 2),
            Transition::new(1490396400, 1),
            Transition::new(1509141600, 2),
            Transition::new(1521846000, 1),
            Transition::new(1540591200, 2),
            Transition::new(1553810400, 1),
            Transition::new(1572037200, 2),
            Transition::new(1585346400, 1),
            Transition::new(1603490400, 2),
            Transition::new(1616796000, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(8423, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"EEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"EET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"IDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"IST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(7200, false, Some(b"EET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(10800, true, Some(b"EEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 4, 4) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    172800,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 5) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    3600,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_HOVD: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2032927596, 1),
            Transition::new(252439200, 3),
            Transition::new(417978000, 2),
            Transition::new(433785600, 3),
            Transition::new(449600400, 2),
            Transition::new(465321600, 3),
            Transition::new(481050000, 2),
            Transition::new(496771200, 3),
            Transition::new(512499600, 2),
            Transition::new(528220800, 3),
            Transition::new(543949200, 2),
            Transition::new(559670400, 3),
            Transition::new(575398800, 2),
            Transition::new(591120000, 3),
            Transition::new(606848400, 2),
            Transition::new(622569600, 3),
            Transition::new(638298000, 2),
            Transition::new(654624000, 3),
            Transition::new(670352400, 2),
            Transition::new(686073600, 3),
            Transition::new(701802000, 2),
            Transition::new(717523200, 3),
            Transition::new(733251600, 2),
            Transition::new(748972800, 3),
            Transition::new(764701200, 2),
            Transition::new(780422400, 3),
            Transition::new(796150800, 2),
            Transition::new(811872000, 3),
            Transition::new(828205200, 2),
            Transition::new(843926400, 3),
            Transition::new(859654800, 2),
            Transition::new(875376000, 3),
            Transition::new(891104400, 2),
            Transition::new(906825600, 3),
            Transition::new(988398000, 2),
            Transition::new(1001700000, 3),
            Transition::new(1017428400, 2),
            Transition::new(1033149600, 3),
            Transition::new(1048878000, 2),
            Transition::new(1064599200, 3),
            Transition::new(1080327600, 2),
            Transition::new(1096048800, 3),
            Transition::new(1111777200, 2),
            Transition::new(1127498400, 3),
            Transition::new(1143226800, 2),
            Transition::new(1159552800, 3),
            Transition::new(1427482800, 2),
            Transition::new(1443196800, 3),
            Transition::new(1458932400, 2),
            Transition::new(1474646400, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(21996, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, true, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_HO_CHI_MINH: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2004073600, 1),
            Transition::new(-1851577590, 2),
            Transition::new(-852105600, 3),
            Transition::new(-782643600, 4),
            Transition::new(-767869200, 2),
            Transition::new(-718095600, 3),
            Transition::new(-457776000, 2),
            Transition::new(-315648000, 3),
            Transition::new(171820800, 2),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(25600, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25590, false, Some(b"PLMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_IRKUTSK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2840165825, 1),
            Transition::new(-1575874625, 2),
            Transition::new(-1247554800, 4),
            Transition::new(354902400, 3),
            Transition::new(370710000, 4),
            Transition::new(386438400, 3),
            Transition::new(402246000, 4),
            Transition::new(417974400, 3),
            Transition::new(433782000, 4),
            Transition::new(449596800, 3),
            Transition::new(465328800, 4),
            Transition::new(481053600, 3),
            Transition::new(496778400, 4),
            Transition::new(512503200, 3),
            Transition::new(528228000, 4),
            Transition::new(543952800, 3),
            Transition::new(559677600, 4),
            Transition::new(575402400, 3),
            Transition::new(591127200, 4),
            Transition::new(606852000, 3),
            Transition::new(622576800, 4),
            Transition::new(638301600, 3),
            Transition::new(654631200, 4),
            Transition::new(670356000, 5),
            Transition::new(686084400, 2),
            Transition::new(695761200, 4),
            Transition::new(701805600, 3),
            Transition::new(717530400, 4),
            Transition::new(733255200, 3),
            Transition::new(748980000, 4),
            Transition::new(764704800, 3),
            Transition::new(780429600, 4),
            Transition::new(796154400, 3),
            Transition::new(811879200, 4),
            Transition::new(828208800, 3),
            Transition::new(846352800, 4),
            Transition::new(859658400, 3),
            Transition::new(877802400, 4),
            Transition::new(891108000, 3),
            Transition::new(909252000, 4),
            Transition::new(922557600, 3),
            Transition::new(941306400, 4),
            Transition::new(954007200, 3),
            Transition::new(972756000, 4),
            Transition::new(985456800, 3),
            Transition::new(1004205600, 4),
            Transition::new(1017511200, 3),
            Transition::new(1035655200, 4),
            Transition::new(1048960800, 3),
            Transition::new(1067104800, 4),
            Transition::new(1080410400, 3),
            Transition::new(1099159200, 4),
            Transition::new(1111860000, 3),
            Transition::new(1130608800, 4),
            Transition::new(1143309600, 3),
            Transition::new(1162058400, 4),
            Transition::new(1174759200, 3),
            Transition::new(1193508000, 4),
            Transition::new(1206813600, 3),
            Transition::new(1224957600, 4),
            Transition::new(1238263200, 3),
            Transition::new(1256407200, 4),
            Transition::new(1269712800, 3),
            Transition::new(1288461600, 4),
            Transition::new(1301162400, 6),
            Transition::new(1414256400, 4),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(25025, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25025, false, Some(b"IMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, true, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, true, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_JAKARTA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3231299232, 1),
            Transition::new(-1451719200, 2),
            Transition::new(-1172906400, 3),
            Transition::new(-876641400, 4),
            Transition::new(-766054800, 3),
            Transition::new(-683883000, 5),
            Transition::new(-620812800, 3),
            Transition::new(-189415800, 6),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(25632, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25632, false, Some(b"BMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(26400, false, Some(b"+0720")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(27000, false, Some(b"+0730")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"WIB")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(25200, false, Some(b"WIB")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_JAYAPURA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1172913768, 1),
            Transition::new(-799491600, 2),
            Transition::new(-189423000, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(33768, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(34200, false, Some(b"+0930")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"WIT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(32400, false, Some(b"WIT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_KABUL: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524538208, 1),
            Transition::new(-788932800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(16608, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(16200, false, Some(b"+0430")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(16200, false, Some(b"+0430")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_KAMCHATKA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1487759676, 1),
            Transition::new(-1247569200, 3),
            Transition::new(354888000, 2),
            Transition::new(370695600, 3),
            Transition::new(386424000, 2),
            Transition::new(402231600, 3),
            Transition::new(417960000, 2),
            Transition::new(433767600, 3),
            Transition::new(449582400, 2),
            Transition::new(465314400, 3),
            Transition::new(481039200, 2),
            Transition::new(496764000, 3),
            Transition::new(512488800, 2),
            Transition::new(528213600, 3),
            Transition::new(543938400, 2),
            Transition::new(559663200, 3),
            Transition::new(575388000, 2),
            Transition::new(591112800, 3),
            Transition::new(606837600, 2),
            Transition::new(622562400, 3),
            Transition::new(638287200, 2),
            Transition::new(654616800, 3),
            Transition::new(670341600, 4),
            Transition::new(686070000, 1),
            Transition::new(695746800, 3),
            Transition::new(701791200, 2),
            Transition::new(717516000, 3),
            Transition::new(733240800, 2),
            Transition::new(748965600, 3),
            Transition::new(764690400, 2),
            Transition::new(780415200, 3),
            Transition::new(796140000, 2),
            Transition::new(811864800, 3),
            Transition::new(828194400, 2),
            Transition::new(846338400, 3),
            Transition::new(859644000, 2),
            Transition::new(877788000, 3),
            Transition::new(891093600, 2),
            Transition::new(909237600, 3),
            Transition::new(922543200, 2),
            Transition::new(941292000, 3),
            Transition::new(953992800, 2),
            Transition::new(972741600, 3),
            Transition::new(985442400, 2),
            Transition::new(1004191200, 3),
            Transition::new(1017496800, 2),
            Transition::new(1035640800, 3),
            Transition::new(1048946400, 2),
            Transition::new(1067090400, 3),
            Transition::new(1080396000, 2),
            Transition::new(1099144800, 3),
            Transition::new(1111845600, 2),
            Transition::new(1130594400, 3),
            Transition::new(1143295200, 2),
            Transition::new(1162044000, 3),
            Transition::new(1174744800, 2),
            Transition::new(1193493600, 3),
            Transition::new(1206799200, 2),
            Transition::new(1224943200, 3),
            Transition::new(1238248800, 2),
            Transition::new(1256392800, 3),
            Transition::new(1269698400, 4),
            Transition::new(1288450800, 1),
            Transition::new(1301151600, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(38076, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, false, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(46800, true, Some(b"+13")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(43200, false, Some(b"+12")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(43200, true, Some(b"+12")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(43200, false, Some(b"+12")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_KARACHI: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1988166492, 1),
            Transition::new(-862637400, 2),
            Transition::new(-764145000, 1),
            Transition::new(-576135000, 3),
            Transition::new(38775600, 5),
            Transition::new(1018119600, 4),
            Transition::new(1033840800, 5),
            Transition::new(1212260400, 4),
            Transition::new(1225476000, 5),
            Transition::new(1239735600, 4),
            Transition::new(1257012000, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(16092, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(19800, false, Some(b"+0530")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(23400, true, Some(b"+0630")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"PKST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"PKT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"PKT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_KASHGAR: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[Transition::new(-1325483420, 1)],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(21020, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_KATHMANDU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1577943676, 1),
            Transition::new(504901800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(20476, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(19800, false, Some(b"+0530")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(20700, false, Some(b"+0545")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(20700, false, Some(b"+0545")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_KHANDYGA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1579424533, 1),
            Transition::new(-1247558400, 3),
            Transition::new(354898800, 2),
            Transition::new(370706400, 3),
            Transition::new(386434800, 2),
            Transition::new(402242400, 3),
            Transition::new(417970800, 2),
            Transition::new(433778400, 3),
            Transition::new(449593200, 2),
            Transition::new(465325200, 3),
            Transition::new(481050000, 2),
            Transition::new(496774800, 3),
            Transition::new(512499600, 2),
            Transition::new(528224400, 3),
            Transition::new(543949200, 2),
            Transition::new(559674000, 3),
            Transition::new(575398800, 2),
            Transition::new(591123600, 3),
            Transition::new(606848400, 2),
            Transition::new(622573200, 3),
            Transition::new(638298000, 2),
            Transition::new(654627600, 3),
            Transition::new(670352400, 4),
            Transition::new(686080800, 1),
            Transition::new(695757600, 3),
            Transition::new(701802000, 2),
            Transition::new(717526800, 3),
            Transition::new(733251600, 2),
            Transition::new(748976400, 3),
            Transition::new(764701200, 2),
            Transition::new(780426000, 3),
            Transition::new(796150800, 2),
            Transition::new(811875600, 3),
            Transition::new(828205200, 2),
            Transition::new(846349200, 3),
            Transition::new(859654800, 2),
            Transition::new(877798800, 3),
            Transition::new(891104400, 2),
            Transition::new(909248400, 3),
            Transition::new(922554000, 2),
            Transition::new(941302800, 3),
            Transition::new(954003600, 2),
            Transition::new(972752400, 3),
            Transition::new(985453200, 2),
            Transition::new(1004202000, 3),
            Transition::new(1017507600, 2),
            Transition::new(1035651600, 3),
            Transition::new(1048957200, 2),
            Transition::new(1067101200, 3),
            Transition::new(1072882800, 6),
            Transition::new(1080403200, 5),
            Transition::new(1099152000, 6),
            Transition::new(1111852800, 5),
            Transition::new(1130601600, 6),
            Transition::new(1143302400, 5),
            Transition::new(1162051200, 6),
            Transition::new(1174752000, 5),
            Transition::new(1193500800, 6),
            Transition::new(1206806400, 5),
            Transition::new(1224950400, 6),
            Transition::new(1238256000, 5),
            Transition::new(1256400000, 6),
            Transition::new(1269705600, 5),
            Transition::new(1288454400, 6),
            Transition::new(1301155200, 7),
            Transition::new(1315832400, 6),
            Transition::new(1414252800, 3),
        ],
        &{
            const V: [LocalTimeType; 8] = [
                match LocalTimeType::new(32533, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, true, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, true, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, true, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, false, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_KRASNOYARSK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1577513486, 1),
            Transition::new(-1247551200, 3),
            Transition::new(354906000, 2),
            Transition::new(370713600, 3),
            Transition::new(386442000, 2),
            Transition::new(402249600, 3),
            Transition::new(417978000, 2),
            Transition::new(433785600, 3),
            Transition::new(449600400, 2),
            Transition::new(465332400, 3),
            Transition::new(481057200, 2),
            Transition::new(496782000, 3),
            Transition::new(512506800, 2),
            Transition::new(528231600, 3),
            Transition::new(543956400, 2),
            Transition::new(559681200, 3),
            Transition::new(575406000, 2),
            Transition::new(591130800, 3),
            Transition::new(606855600, 2),
            Transition::new(622580400, 3),
            Transition::new(638305200, 2),
            Transition::new(654634800, 3),
            Transition::new(670359600, 4),
            Transition::new(686088000, 1),
            Transition::new(695764800, 3),
            Transition::new(701809200, 2),
            Transition::new(717534000, 3),
            Transition::new(733258800, 2),
            Transition::new(748983600, 3),
            Transition::new(764708400, 2),
            Transition::new(780433200, 3),
            Transition::new(796158000, 2),
            Transition::new(811882800, 3),
            Transition::new(828212400, 2),
            Transition::new(846356400, 3),
            Transition::new(859662000, 2),
            Transition::new(877806000, 3),
            Transition::new(891111600, 2),
            Transition::new(909255600, 3),
            Transition::new(922561200, 2),
            Transition::new(941310000, 3),
            Transition::new(954010800, 2),
            Transition::new(972759600, 3),
            Transition::new(985460400, 2),
            Transition::new(1004209200, 3),
            Transition::new(1017514800, 2),
            Transition::new(1035658800, 3),
            Transition::new(1048964400, 2),
            Transition::new(1067108400, 3),
            Transition::new(1080414000, 2),
            Transition::new(1099162800, 3),
            Transition::new(1111863600, 2),
            Transition::new(1130612400, 3),
            Transition::new(1143313200, 2),
            Transition::new(1162062000, 3),
            Transition::new(1174762800, 2),
            Transition::new(1193511600, 3),
            Transition::new(1206817200, 2),
            Transition::new(1224961200, 3),
            Transition::new(1238266800, 2),
            Transition::new(1256410800, 3),
            Transition::new(1269716400, 2),
            Transition::new(1288465200, 3),
            Transition::new(1301166000, 5),
            Transition::new(1414260000, 3),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(22286, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, true, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, true, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_KUALA_LUMPUR: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2177477206, 1),
            Transition::new(-2038200925, 2),
            Transition::new(-1167634800, 3),
            Transition::new(-1073028000, 4),
            Transition::new(-894180000, 5),
            Transition::new(-879665400, 6),
            Transition::new(-767005200, 5),
            Transition::new(378664200, 7),
        ],
        &{
            const V: [LocalTimeType; 8] = [
                match LocalTimeType::new(24406, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(24925, false, Some(b"SMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(26400, true, Some(b"+0720")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(26400, false, Some(b"+0720")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(27000, false, Some(b"+0730")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_KUCHING: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1383463280, 1),
            Transition::new(-1167636600, 3),
            Transition::new(-1082448000, 2),
            Transition::new(-1074586800, 3),
            Transition::new(-1050825600, 2),
            Transition::new(-1042964400, 3),
            Transition::new(-1019289600, 2),
            Transition::new(-1011428400, 3),
            Transition::new(-987753600, 2),
            Transition::new(-979892400, 3),
            Transition::new(-956217600, 2),
            Transition::new(-948356400, 3),
            Transition::new(-924595200, 2),
            Transition::new(-916734000, 3),
            Transition::new(-893059200, 2),
            Transition::new(-885198000, 3),
            Transition::new(-879667200, 4),
            Transition::new(-767005200, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(26480, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(27000, false, Some(b"+0730")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(30000, true, Some(b"+0820")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_MACAO: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2056692850, 1),
            Transition::new(-884509200, 3),
            Transition::new(-873280800, 2),
            Transition::new(-855918000, 3),
            Transition::new(-841744800, 2),
            Transition::new(-828529200, 3),
            Transition::new(-765363600, 1),
            Transition::new(-747046800, 4),
            Transition::new(-733827600, 1),
            Transition::new(-716461200, 4),
            Transition::new(-697021200, 1),
            Transition::new(-683715600, 4),
            Transition::new(-667990800, 1),
            Transition::new(-654771600, 4),
            Transition::new(-636627600, 1),
            Transition::new(-623322000, 4),
            Transition::new(-605178000, 1),
            Transition::new(-591872400, 4),
            Transition::new(-573642000, 1),
            Transition::new(-559818000, 4),
            Transition::new(-541674000, 1),
            Transition::new(-528368400, 4),
            Transition::new(-510224400, 1),
            Transition::new(-498128400, 4),
            Transition::new(-478774800, 1),
            Transition::new(-466678800, 4),
            Transition::new(-446720400, 1),
            Transition::new(-435229200, 4),
            Transition::new(-415258200, 1),
            Transition::new(-403158600, 4),
            Transition::new(-383808600, 1),
            Transition::new(-371709000, 4),
            Transition::new(-352359000, 1),
            Transition::new(-340259400, 4),
            Transition::new(-320909400, 1),
            Transition::new(-308809800, 4),
            Transition::new(-288855000, 1),
            Transition::new(-277360200, 4),
            Transition::new(-257405400, 1),
            Transition::new(-245910600, 4),
            Transition::new(-225955800, 1),
            Transition::new(-213856200, 4),
            Transition::new(-194506200, 1),
            Transition::new(-182406600, 4),
            Transition::new(-163056600, 1),
            Transition::new(-148537800, 4),
            Transition::new(-132820200, 1),
            Transition::new(-117088200, 4),
            Transition::new(-101370600, 1),
            Transition::new(-85638600, 4),
            Transition::new(-69312600, 1),
            Transition::new(-53584200, 4),
            Transition::new(-37863000, 1),
            Transition::new(-22134600, 4),
            Transition::new(-6413400, 1),
            Transition::new(9315000, 4),
            Transition::new(25036200, 1),
            Transition::new(40764600, 4),
            Transition::new(56485800, 1),
            Transition::new(72214200, 4),
            Transition::new(88540200, 1),
            Transition::new(104268600, 4),
            Transition::new(119989800, 1),
            Transition::new(126041400, 4),
            Transition::new(151439400, 1),
            Transition::new(167167800, 4),
            Transition::new(182889000, 1),
            Transition::new(198617400, 4),
            Transition::new(214338600, 1),
            Transition::new(295385400, 4),
            Transition::new(309292200, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(27250, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, true, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(28800, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_MAGADAN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441188192, 1),
            Transition::new(-1247565600, 3),
            Transition::new(354891600, 2),
            Transition::new(370699200, 3),
            Transition::new(386427600, 2),
            Transition::new(402235200, 3),
            Transition::new(417963600, 2),
            Transition::new(433771200, 3),
            Transition::new(449586000, 2),
            Transition::new(465318000, 3),
            Transition::new(481042800, 2),
            Transition::new(496767600, 3),
            Transition::new(512492400, 2),
            Transition::new(528217200, 3),
            Transition::new(543942000, 2),
            Transition::new(559666800, 3),
            Transition::new(575391600, 2),
            Transition::new(591116400, 3),
            Transition::new(606841200, 2),
            Transition::new(622566000, 3),
            Transition::new(638290800, 2),
            Transition::new(654620400, 3),
            Transition::new(670345200, 4),
            Transition::new(686073600, 1),
            Transition::new(695750400, 3),
            Transition::new(701794800, 2),
            Transition::new(717519600, 3),
            Transition::new(733244400, 2),
            Transition::new(748969200, 3),
            Transition::new(764694000, 2),
            Transition::new(780418800, 3),
            Transition::new(796143600, 2),
            Transition::new(811868400, 3),
            Transition::new(828198000, 2),
            Transition::new(846342000, 3),
            Transition::new(859647600, 2),
            Transition::new(877791600, 3),
            Transition::new(891097200, 2),
            Transition::new(909241200, 3),
            Transition::new(922546800, 2),
            Transition::new(941295600, 3),
            Transition::new(953996400, 2),
            Transition::new(972745200, 3),
            Transition::new(985446000, 2),
            Transition::new(1004194800, 3),
            Transition::new(1017500400, 2),
            Transition::new(1035644400, 3),
            Transition::new(1048950000, 2),
            Transition::new(1067094000, 3),
            Transition::new(1080399600, 2),
            Transition::new(1099148400, 3),
            Transition::new(1111849200, 2),
            Transition::new(1130598000, 3),
            Transition::new(1143298800, 2),
            Transition::new(1162047600, 3),
            Transition::new(1174748400, 2),
            Transition::new(1193497200, 3),
            Transition::new(1206802800, 2),
            Transition::new(1224946800, 3),
            Transition::new(1238252400, 2),
            Transition::new(1256396400, 3),
            Transition::new(1269702000, 2),
            Transition::new(1288450800, 3),
            Transition::new(1301151600, 5),
            Transition::new(1414245600, 1),
            Transition::new(1461427200, 3),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(36192, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(43200, true, Some(b"+12")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, false, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, true, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(43200, false, Some(b"+12")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(39600, false, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_MAKASSAR: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1577951856, 1),
            Transition::new(-1172908656, 2),
            Transition::new(-880272000, 3),
            Transition::new(-766054800, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(28656, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28656, false, Some(b"MMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"WITA")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(28800, false, Some(b"WITA")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_MANILA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-3944621040, 1),
            Transition::new(-2229321840, 3),
            Transition::new(-1046678400, 2),
            Transition::new(-1038733200, 3),
            Transition::new(-873273600, 4),
            Transition::new(-794221200, 3),
            Transition::new(-496224000, 2),
            Transition::new(-489315600, 3),
            Transition::new(259344000, 2),
            Transition::new(275151600, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-57360, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(29040, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, true, Some(b"PDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"JST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(28800, false, Some(b"PST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_NICOSIA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1518920008, 2),
            Transition::new(166572000, 1),
            Transition::new(182293200, 2),
            Transition::new(200959200, 1),
            Transition::new(213829200, 2),
            Transition::new(228866400, 1),
            Transition::new(243982800, 2),
            Transition::new(260316000, 1),
            Transition::new(276123600, 2),
            Transition::new(291765600, 1),
            Transition::new(307486800, 2),
            Transition::new(323820000, 1),
            Transition::new(338936400, 2),
            Transition::new(354664800, 1),
            Transition::new(370386000, 2),
            Transition::new(386114400, 1),
            Transition::new(401835600, 2),
            Transition::new(417564000, 1),
            Transition::new(433285200, 2),
            Transition::new(449013600, 1),
            Transition::new(465339600, 2),
            Transition::new(481068000, 1),
            Transition::new(496789200, 2),
            Transition::new(512517600, 1),
            Transition::new(528238800, 2),
            Transition::new(543967200, 1),
            Transition::new(559688400, 2),
            Transition::new(575416800, 1),
            Transition::new(591138000, 2),
            Transition::new(606866400, 1),
            Transition::new(622587600, 2),
            Transition::new(638316000, 1),
            Transition::new(654642000, 2),
            Transition::new(670370400, 1),
            Transition::new(686091600, 2),
            Transition::new(701820000, 1),
            Transition::new(717541200, 2),
            Transition::new(733269600, 1),
            Transition::new(748990800, 2),
            Transition::new(764719200, 1),
            Transition::new(780440400, 2),
            Transition::new(796168800, 1),
            Transition::new(811890000, 2),
            Transition::new(828223200, 1),
            Transition::new(843944400, 2),
            Transition::new(859672800, 1),
            Transition::new(875394000, 2),
            Transition::new(891122400, 1),
            Transition::new(909277200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(8008, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"EEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"EET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(7200, false, Some(b"EET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(10800, true, Some(b"EEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    14400,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_NOVOKUZNETSK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441259328, 1),
            Transition::new(-1247551200, 3),
            Transition::new(354906000, 2),
            Transition::new(370713600, 3),
            Transition::new(386442000, 2),
            Transition::new(402249600, 3),
            Transition::new(417978000, 2),
            Transition::new(433785600, 3),
            Transition::new(449600400, 2),
            Transition::new(465332400, 3),
            Transition::new(481057200, 2),
            Transition::new(496782000, 3),
            Transition::new(512506800, 2),
            Transition::new(528231600, 3),
            Transition::new(543956400, 2),
            Transition::new(559681200, 3),
            Transition::new(575406000, 2),
            Transition::new(591130800, 3),
            Transition::new(606855600, 2),
            Transition::new(622580400, 3),
            Transition::new(638305200, 2),
            Transition::new(654634800, 3),
            Transition::new(670359600, 4),
            Transition::new(686088000, 1),
            Transition::new(695764800, 3),
            Transition::new(701809200, 2),
            Transition::new(717534000, 3),
            Transition::new(733258800, 2),
            Transition::new(748983600, 3),
            Transition::new(764708400, 2),
            Transition::new(780433200, 3),
            Transition::new(796158000, 2),
            Transition::new(811882800, 3),
            Transition::new(828212400, 2),
            Transition::new(846356400, 3),
            Transition::new(859662000, 2),
            Transition::new(877806000, 3),
            Transition::new(891111600, 2),
            Transition::new(909255600, 3),
            Transition::new(922561200, 2),
            Transition::new(941310000, 3),
            Transition::new(954010800, 2),
            Transition::new(972759600, 3),
            Transition::new(985460400, 2),
            Transition::new(1004209200, 3),
            Transition::new(1017514800, 2),
            Transition::new(1035658800, 3),
            Transition::new(1048964400, 2),
            Transition::new(1067108400, 3),
            Transition::new(1080414000, 2),
            Transition::new(1099162800, 3),
            Transition::new(1111863600, 2),
            Transition::new(1130612400, 3),
            Transition::new(1143313200, 2),
            Transition::new(1162062000, 3),
            Transition::new(1174762800, 2),
            Transition::new(1193511600, 3),
            Transition::new(1206817200, 2),
            Transition::new(1224961200, 3),
            Transition::new(1238266800, 2),
            Transition::new(1256410800, 3),
            Transition::new(1269716400, 4),
            Transition::new(1288468800, 1),
            Transition::new(1301169600, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(20928, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, true, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, true, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_NOVOSIBIRSK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1579476700, 1),
            Transition::new(-1247551200, 3),
            Transition::new(354906000, 2),
            Transition::new(370713600, 3),
            Transition::new(386442000, 2),
            Transition::new(402249600, 3),
            Transition::new(417978000, 2),
            Transition::new(433785600, 3),
            Transition::new(449600400, 2),
            Transition::new(465332400, 3),
            Transition::new(481057200, 2),
            Transition::new(496782000, 3),
            Transition::new(512506800, 2),
            Transition::new(528231600, 3),
            Transition::new(543956400, 2),
            Transition::new(559681200, 3),
            Transition::new(575406000, 2),
            Transition::new(591130800, 3),
            Transition::new(606855600, 2),
            Transition::new(622580400, 3),
            Transition::new(638305200, 2),
            Transition::new(654634800, 3),
            Transition::new(670359600, 4),
            Transition::new(686088000, 1),
            Transition::new(695764800, 3),
            Transition::new(701809200, 2),
            Transition::new(717534000, 3),
            Transition::new(733258800, 2),
            Transition::new(738086400, 4),
            Transition::new(748987200, 1),
            Transition::new(764712000, 4),
            Transition::new(780436800, 1),
            Transition::new(796161600, 4),
            Transition::new(811886400, 1),
            Transition::new(828216000, 4),
            Transition::new(846360000, 1),
            Transition::new(859665600, 4),
            Transition::new(877809600, 1),
            Transition::new(891115200, 4),
            Transition::new(909259200, 1),
            Transition::new(922564800, 4),
            Transition::new(941313600, 1),
            Transition::new(954014400, 4),
            Transition::new(972763200, 1),
            Transition::new(985464000, 4),
            Transition::new(1004212800, 1),
            Transition::new(1017518400, 4),
            Transition::new(1035662400, 1),
            Transition::new(1048968000, 4),
            Transition::new(1067112000, 1),
            Transition::new(1080417600, 4),
            Transition::new(1099166400, 1),
            Transition::new(1111867200, 4),
            Transition::new(1130616000, 1),
            Transition::new(1143316800, 4),
            Transition::new(1162065600, 1),
            Transition::new(1174766400, 4),
            Transition::new(1193515200, 1),
            Transition::new(1206820800, 4),
            Transition::new(1224964800, 1),
            Transition::new(1238270400, 4),
            Transition::new(1256414400, 1),
            Transition::new(1269720000, 4),
            Transition::new(1288468800, 1),
            Transition::new(1301169600, 3),
            Transition::new(1414263600, 1),
            Transition::new(1469304000, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(19900, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, true, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, true, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_OMSK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1582088010, 1),
            Transition::new(-1247547600, 3),
            Transition::new(354909600, 2),
            Transition::new(370717200, 3),
            Transition::new(386445600, 2),
            Transition::new(402253200, 3),
            Transition::new(417981600, 2),
            Transition::new(433789200, 3),
            Transition::new(449604000, 2),
            Transition::new(465336000, 3),
            Transition::new(481060800, 2),
            Transition::new(496785600, 3),
            Transition::new(512510400, 2),
            Transition::new(528235200, 3),
            Transition::new(543960000, 2),
            Transition::new(559684800, 3),
            Transition::new(575409600, 2),
            Transition::new(591134400, 3),
            Transition::new(606859200, 2),
            Transition::new(622584000, 3),
            Transition::new(638308800, 2),
            Transition::new(654638400, 3),
            Transition::new(670363200, 4),
            Transition::new(686091600, 1),
            Transition::new(695768400, 3),
            Transition::new(701812800, 2),
            Transition::new(717537600, 3),
            Transition::new(733262400, 2),
            Transition::new(748987200, 3),
            Transition::new(764712000, 2),
            Transition::new(780436800, 3),
            Transition::new(796161600, 2),
            Transition::new(811886400, 3),
            Transition::new(828216000, 2),
            Transition::new(846360000, 3),
            Transition::new(859665600, 2),
            Transition::new(877809600, 3),
            Transition::new(891115200, 2),
            Transition::new(909259200, 3),
            Transition::new(922564800, 2),
            Transition::new(941313600, 3),
            Transition::new(954014400, 2),
            Transition::new(972763200, 3),
            Transition::new(985464000, 2),
            Transition::new(1004212800, 3),
            Transition::new(1017518400, 2),
            Transition::new(1035662400, 3),
            Transition::new(1048968000, 2),
            Transition::new(1067112000, 3),
            Transition::new(1080417600, 2),
            Transition::new(1099166400, 3),
            Transition::new(1111867200, 2),
            Transition::new(1130616000, 3),
            Transition::new(1143316800, 2),
            Transition::new(1162065600, 3),
            Transition::new(1174766400, 2),
            Transition::new(1193515200, 3),
            Transition::new(1206820800, 2),
            Transition::new(1224964800, 3),
            Transition::new(1238270400, 2),
            Transition::new(1256414400, 3),
            Transition::new(1269720000, 2),
            Transition::new(1288468800, 3),
            Transition::new(1301169600, 5),
            Transition::new(1414263600, 3),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(17610, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, true, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_ORAL: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441164324, 1),
            Transition::new(-1247540400, 2),
            Transition::new(354913200, 3),
            Transition::new(370720800, 4),
            Transition::new(386445600, 3),
            Transition::new(402256800, 2),
            Transition::new(417985200, 3),
            Transition::new(433792800, 2),
            Transition::new(449607600, 3),
            Transition::new(465339600, 2),
            Transition::new(481064400, 3),
            Transition::new(496789200, 2),
            Transition::new(512514000, 3),
            Transition::new(528238800, 2),
            Transition::new(543963600, 3),
            Transition::new(559688400, 2),
            Transition::new(575413200, 3),
            Transition::new(591138000, 2),
            Transition::new(606862800, 5),
            Transition::new(622591200, 6),
            Transition::new(638316000, 5),
            Transition::new(654645600, 6),
            Transition::new(670370400, 5),
            Transition::new(686095200, 6),
            Transition::new(695772000, 2),
            Transition::new(701816400, 5),
            Transition::new(717544800, 6),
            Transition::new(733269600, 5),
            Transition::new(748994400, 6),
            Transition::new(764719200, 5),
            Transition::new(780444000, 6),
            Transition::new(796168800, 5),
            Transition::new(811893600, 6),
            Transition::new(828223200, 5),
            Transition::new(846367200, 6),
            Transition::new(859672800, 5),
            Transition::new(877816800, 6),
            Transition::new(891122400, 5),
            Transition::new(909266400, 6),
            Transition::new(922572000, 5),
            Transition::new(941320800, 6),
            Transition::new(954021600, 5),
            Transition::new(972770400, 6),
            Transition::new(985471200, 5),
            Transition::new(1004220000, 6),
            Transition::new(1017525600, 5),
            Transition::new(1035669600, 6),
            Transition::new(1048975200, 5),
            Transition::new(1067119200, 6),
            Transition::new(1080424800, 5),
            Transition::new(1099173600, 2),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(12324, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, true, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_PONTIANAK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1946186240, 1),
            Transition::new(-1172906240, 2),
            Transition::new(-881220600, 3),
            Transition::new(-766054800, 2),
            Transition::new(-683883000, 4),
            Transition::new(-620812800, 2),
            Transition::new(-189415800, 5),
            Transition::new(567964800, 6),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(26240, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(26240, false, Some(b"PMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(27000, false, Some(b"+0730")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"WITA")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"WIB")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(25200, false, Some(b"WIB")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_PYONGYANG: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1948782180, 1),
            Transition::new(-1830414600, 2),
            Transition::new(-768646800, 3),
            Transition::new(1439564400, 1),
            Transition::new(1525446000, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(30180, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(30600, false, Some(b"KST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"JST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"KST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(32400, false, Some(b"KST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_QOSTANAY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441167268, 1),
            Transition::new(-1247544000, 2),
            Transition::new(354913200, 3),
            Transition::new(370720800, 4),
            Transition::new(386445600, 3),
            Transition::new(402256800, 2),
            Transition::new(417985200, 3),
            Transition::new(433792800, 2),
            Transition::new(449607600, 3),
            Transition::new(465339600, 2),
            Transition::new(481064400, 3),
            Transition::new(496789200, 2),
            Transition::new(512514000, 3),
            Transition::new(528238800, 2),
            Transition::new(543963600, 3),
            Transition::new(559688400, 2),
            Transition::new(575413200, 3),
            Transition::new(591138000, 2),
            Transition::new(606862800, 3),
            Transition::new(622587600, 2),
            Transition::new(638312400, 3),
            Transition::new(654642000, 2),
            Transition::new(670366800, 5),
            Transition::new(686095200, 1),
            Transition::new(695772000, 2),
            Transition::new(701816400, 3),
            Transition::new(717541200, 2),
            Transition::new(733266000, 3),
            Transition::new(748990800, 2),
            Transition::new(764715600, 3),
            Transition::new(780440400, 2),
            Transition::new(796165200, 3),
            Transition::new(811890000, 2),
            Transition::new(828219600, 3),
            Transition::new(846363600, 2),
            Transition::new(859669200, 3),
            Transition::new(877813200, 2),
            Transition::new(891118800, 3),
            Transition::new(909262800, 2),
            Transition::new(922568400, 3),
            Transition::new(941317200, 2),
            Transition::new(954018000, 3),
            Transition::new(972766800, 2),
            Transition::new(985467600, 3),
            Transition::new(1004216400, 2),
            Transition::new(1017522000, 3),
            Transition::new(1035666000, 2),
            Transition::new(1048971600, 3),
            Transition::new(1067115600, 2),
            Transition::new(1080421200, 3),
            Transition::new(1099170000, 4),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(15268, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, true, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_QYZYLORDA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441167712, 1),
            Transition::new(-1247544000, 2),
            Transition::new(354913200, 3),
            Transition::new(370720800, 4),
            Transition::new(386445600, 3),
            Transition::new(402256800, 2),
            Transition::new(417985200, 3),
            Transition::new(433792800, 2),
            Transition::new(449607600, 3),
            Transition::new(465339600, 2),
            Transition::new(481064400, 3),
            Transition::new(496789200, 2),
            Transition::new(512514000, 3),
            Transition::new(528238800, 2),
            Transition::new(543963600, 3),
            Transition::new(559688400, 2),
            Transition::new(575413200, 3),
            Transition::new(591138000, 2),
            Transition::new(606862800, 3),
            Transition::new(622587600, 2),
            Transition::new(638312400, 3),
            Transition::new(654642000, 2),
            Transition::new(670366800, 5),
            Transition::new(686095200, 2),
            Transition::new(695768400, 4),
            Transition::new(701812800, 3),
            Transition::new(717541200, 2),
            Transition::new(733266000, 3),
            Transition::new(748990800, 2),
            Transition::new(764715600, 3),
            Transition::new(780440400, 2),
            Transition::new(796165200, 3),
            Transition::new(811890000, 2),
            Transition::new(828219600, 3),
            Transition::new(846363600, 2),
            Transition::new(859669200, 3),
            Transition::new(877813200, 2),
            Transition::new(891118800, 3),
            Transition::new(909262800, 2),
            Transition::new(922568400, 3),
            Transition::new(941317200, 2),
            Transition::new(954018000, 3),
            Transition::new(972766800, 2),
            Transition::new(985467600, 3),
            Transition::new(1004216400, 2),
            Transition::new(1017522000, 3),
            Transition::new(1035666000, 2),
            Transition::new(1048971600, 3),
            Transition::new(1067115600, 2),
            Transition::new(1080421200, 3),
            Transition::new(1099170000, 4),
            Transition::new(1545328800, 2),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(15712, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, true, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_RANGOON: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2840163887, 1),
            Transition::new(-1577946287, 2),
            Transition::new(-873268200, 3),
            Transition::new(-778410000, 2),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(23087, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(23087, false, Some(b"RMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(23400, false, Some(b"+0630")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(23400, false, Some(b"+0630")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_SAKHALIN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2031039048, 1),
            Transition::new(-768560400, 3),
            Transition::new(354891600, 2),
            Transition::new(370699200, 3),
            Transition::new(386427600, 2),
            Transition::new(402235200, 3),
            Transition::new(417963600, 2),
            Transition::new(433771200, 3),
            Transition::new(449586000, 2),
            Transition::new(465318000, 3),
            Transition::new(481042800, 2),
            Transition::new(496767600, 3),
            Transition::new(512492400, 2),
            Transition::new(528217200, 3),
            Transition::new(543942000, 2),
            Transition::new(559666800, 3),
            Transition::new(575391600, 2),
            Transition::new(591116400, 3),
            Transition::new(606841200, 2),
            Transition::new(622566000, 3),
            Transition::new(638290800, 2),
            Transition::new(654620400, 3),
            Transition::new(670345200, 4),
            Transition::new(686073600, 5),
            Transition::new(695750400, 3),
            Transition::new(701794800, 2),
            Transition::new(717519600, 3),
            Transition::new(733244400, 2),
            Transition::new(748969200, 3),
            Transition::new(764694000, 2),
            Transition::new(780418800, 3),
            Transition::new(796143600, 2),
            Transition::new(811868400, 3),
            Transition::new(828198000, 2),
            Transition::new(846342000, 3),
            Transition::new(859647600, 4),
            Transition::new(877795200, 5),
            Transition::new(891100800, 4),
            Transition::new(909244800, 5),
            Transition::new(922550400, 4),
            Transition::new(941299200, 5),
            Transition::new(954000000, 4),
            Transition::new(972748800, 5),
            Transition::new(985449600, 4),
            Transition::new(1004198400, 5),
            Transition::new(1017504000, 4),
            Transition::new(1035648000, 5),
            Transition::new(1048953600, 4),
            Transition::new(1067097600, 5),
            Transition::new(1080403200, 4),
            Transition::new(1099152000, 5),
            Transition::new(1111852800, 4),
            Transition::new(1130601600, 5),
            Transition::new(1143302400, 4),
            Transition::new(1162051200, 5),
            Transition::new(1174752000, 4),
            Transition::new(1193500800, 5),
            Transition::new(1206806400, 4),
            Transition::new(1224950400, 5),
            Transition::new(1238256000, 4),
            Transition::new(1256400000, 5),
            Transition::new(1269705600, 4),
            Transition::new(1288454400, 5),
            Transition::new(1301155200, 3),
            Transition::new(1414249200, 5),
            Transition::new(1459008000, 3),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(34248, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(43200, true, Some(b"+12")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, false, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, true, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(39600, false, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_SAMARKAND: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441168073, 1),
            Transition::new(-1247544000, 2),
            Transition::new(354913200, 3),
            Transition::new(370720800, 4),
            Transition::new(386445600, 3),
            Transition::new(402256800, 2),
            Transition::new(417985200, 3),
            Transition::new(433792800, 2),
            Transition::new(449607600, 3),
            Transition::new(465339600, 2),
            Transition::new(481064400, 3),
            Transition::new(496789200, 2),
            Transition::new(512514000, 3),
            Transition::new(528238800, 2),
            Transition::new(543963600, 3),
            Transition::new(559688400, 2),
            Transition::new(575413200, 3),
            Transition::new(591138000, 2),
            Transition::new(606862800, 3),
            Transition::new(622587600, 2),
            Transition::new(638312400, 3),
            Transition::new(654642000, 2),
            Transition::new(670366800, 3),
            Transition::new(686091600, 2),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(16073, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_SREDNEKOLYMSK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441188892, 1),
            Transition::new(-1247565600, 3),
            Transition::new(354891600, 2),
            Transition::new(370699200, 3),
            Transition::new(386427600, 2),
            Transition::new(402235200, 3),
            Transition::new(417963600, 2),
            Transition::new(433771200, 3),
            Transition::new(449586000, 2),
            Transition::new(465318000, 3),
            Transition::new(481042800, 2),
            Transition::new(496767600, 3),
            Transition::new(512492400, 2),
            Transition::new(528217200, 3),
            Transition::new(543942000, 2),
            Transition::new(559666800, 3),
            Transition::new(575391600, 2),
            Transition::new(591116400, 3),
            Transition::new(606841200, 2),
            Transition::new(622566000, 3),
            Transition::new(638290800, 2),
            Transition::new(654620400, 3),
            Transition::new(670345200, 4),
            Transition::new(686073600, 1),
            Transition::new(695750400, 3),
            Transition::new(701794800, 2),
            Transition::new(717519600, 3),
            Transition::new(733244400, 2),
            Transition::new(748969200, 3),
            Transition::new(764694000, 2),
            Transition::new(780418800, 3),
            Transition::new(796143600, 2),
            Transition::new(811868400, 3),
            Transition::new(828198000, 2),
            Transition::new(846342000, 3),
            Transition::new(859647600, 2),
            Transition::new(877791600, 3),
            Transition::new(891097200, 2),
            Transition::new(909241200, 3),
            Transition::new(922546800, 2),
            Transition::new(941295600, 3),
            Transition::new(953996400, 2),
            Transition::new(972745200, 3),
            Transition::new(985446000, 2),
            Transition::new(1004194800, 3),
            Transition::new(1017500400, 2),
            Transition::new(1035644400, 3),
            Transition::new(1048950000, 2),
            Transition::new(1067094000, 3),
            Transition::new(1080399600, 2),
            Transition::new(1099148400, 3),
            Transition::new(1111849200, 2),
            Transition::new(1130598000, 3),
            Transition::new(1143298800, 2),
            Transition::new(1162047600, 3),
            Transition::new(1174748400, 2),
            Transition::new(1193497200, 3),
            Transition::new(1206802800, 2),
            Transition::new(1224946800, 3),
            Transition::new(1238252400, 2),
            Transition::new(1256396400, 3),
            Transition::new(1269702000, 2),
            Transition::new(1288450800, 3),
            Transition::new(1301151600, 5),
            Transition::new(1414245600, 3),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(36892, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(43200, true, Some(b"+12")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, false, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, true, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(43200, false, Some(b"+12")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(39600, false, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_TASHKENT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441168631, 1),
            Transition::new(-1247547600, 3),
            Transition::new(354909600, 2),
            Transition::new(370717200, 3),
            Transition::new(386445600, 2),
            Transition::new(402253200, 3),
            Transition::new(417981600, 2),
            Transition::new(433789200, 3),
            Transition::new(449604000, 2),
            Transition::new(465336000, 3),
            Transition::new(481060800, 2),
            Transition::new(496785600, 3),
            Transition::new(512510400, 2),
            Transition::new(528235200, 3),
            Transition::new(543960000, 2),
            Transition::new(559684800, 3),
            Transition::new(575409600, 2),
            Transition::new(591134400, 3),
            Transition::new(606859200, 2),
            Transition::new(622584000, 3),
            Transition::new(638308800, 2),
            Transition::new(654638400, 3),
            Transition::new(670363200, 4),
            Transition::new(686091600, 1),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(16631, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, true, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_TBILISI: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2840151551, 1),
            Transition::new(-1441162751, 2),
            Transition::new(-405140400, 4),
            Transition::new(354916800, 3),
            Transition::new(370724400, 4),
            Transition::new(386452800, 3),
            Transition::new(402260400, 4),
            Transition::new(417988800, 3),
            Transition::new(433796400, 4),
            Transition::new(449611200, 3),
            Transition::new(465343200, 4),
            Transition::new(481068000, 3),
            Transition::new(496792800, 4),
            Transition::new(512517600, 3),
            Transition::new(528242400, 4),
            Transition::new(543967200, 3),
            Transition::new(559692000, 4),
            Transition::new(575416800, 3),
            Transition::new(591141600, 4),
            Transition::new(606866400, 3),
            Transition::new(622591200, 4),
            Transition::new(638316000, 3),
            Transition::new(654645600, 4),
            Transition::new(670370400, 5),
            Transition::new(686098800, 2),
            Transition::new(701816400, 5),
            Transition::new(717537600, 2),
            Transition::new(733266000, 5),
            Transition::new(748987200, 2),
            Transition::new(764715600, 5),
            Transition::new(780436800, 4),
            Transition::new(796161600, 3),
            Transition::new(811882800, 4),
            Transition::new(828216000, 3),
            Transition::new(859662000, 3),
            Transition::new(877806000, 4),
            Transition::new(891115200, 3),
            Transition::new(909255600, 4),
            Transition::new(922564800, 3),
            Transition::new(941310000, 4),
            Transition::new(954014400, 3),
            Transition::new(972759600, 4),
            Transition::new(985464000, 3),
            Transition::new(1004209200, 4),
            Transition::new(1017518400, 3),
            Transition::new(1035658800, 4),
            Transition::new(1048968000, 3),
            Transition::new(1067108400, 4),
            Transition::new(1080417600, 3),
            Transition::new(1088276400, 5),
            Transition::new(1099177200, 2),
            Transition::new(1111878000, 4),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(10751, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10751, false, Some(b"TBMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, true, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, true, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_THIMBU: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-706341516, 1),
            Transition::new(560025000, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(21516, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(19800, false, Some(b"+0530")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_TOMSK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1578807591, 1),
            Transition::new(-1247551200, 3),
            Transition::new(354906000, 2),
            Transition::new(370713600, 3),
            Transition::new(386442000, 2),
            Transition::new(402249600, 3),
            Transition::new(417978000, 2),
            Transition::new(433785600, 3),
            Transition::new(449600400, 2),
            Transition::new(465332400, 3),
            Transition::new(481057200, 2),
            Transition::new(496782000, 3),
            Transition::new(512506800, 2),
            Transition::new(528231600, 3),
            Transition::new(543956400, 2),
            Transition::new(559681200, 3),
            Transition::new(575406000, 2),
            Transition::new(591130800, 3),
            Transition::new(606855600, 2),
            Transition::new(622580400, 3),
            Transition::new(638305200, 2),
            Transition::new(654634800, 3),
            Transition::new(670359600, 4),
            Transition::new(686088000, 1),
            Transition::new(695764800, 3),
            Transition::new(701809200, 2),
            Transition::new(717534000, 3),
            Transition::new(733258800, 2),
            Transition::new(748983600, 3),
            Transition::new(764708400, 2),
            Transition::new(780433200, 3),
            Transition::new(796158000, 2),
            Transition::new(811882800, 3),
            Transition::new(828212400, 2),
            Transition::new(846356400, 3),
            Transition::new(859662000, 2),
            Transition::new(877806000, 3),
            Transition::new(891111600, 2),
            Transition::new(909255600, 3),
            Transition::new(922561200, 2),
            Transition::new(941310000, 3),
            Transition::new(954010800, 2),
            Transition::new(972759600, 3),
            Transition::new(985460400, 2),
            Transition::new(1004209200, 3),
            Transition::new(1017514800, 2),
            Transition::new(1020193200, 4),
            Transition::new(1035662400, 1),
            Transition::new(1048968000, 4),
            Transition::new(1067112000, 1),
            Transition::new(1080417600, 4),
            Transition::new(1099166400, 1),
            Transition::new(1111867200, 4),
            Transition::new(1130616000, 1),
            Transition::new(1143316800, 4),
            Transition::new(1162065600, 1),
            Transition::new(1174766400, 4),
            Transition::new(1193515200, 1),
            Transition::new(1206820800, 4),
            Transition::new(1224964800, 1),
            Transition::new(1238270400, 4),
            Transition::new(1256414400, 1),
            Transition::new(1269720000, 4),
            Transition::new(1288468800, 1),
            Transition::new(1301169600, 3),
            Transition::new(1414263600, 1),
            Transition::new(1464465600, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(20391, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, true, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, true, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_ULAANBAATAR: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2032931252, 1),
            Transition::new(252435600, 3),
            Transition::new(417974400, 2),
            Transition::new(433782000, 3),
            Transition::new(449596800, 2),
            Transition::new(465318000, 3),
            Transition::new(481046400, 2),
            Transition::new(496767600, 3),
            Transition::new(512496000, 2),
            Transition::new(528217200, 3),
            Transition::new(543945600, 2),
            Transition::new(559666800, 3),
            Transition::new(575395200, 2),
            Transition::new(591116400, 3),
            Transition::new(606844800, 2),
            Transition::new(622566000, 3),
            Transition::new(638294400, 2),
            Transition::new(654620400, 3),
            Transition::new(670348800, 2),
            Transition::new(686070000, 3),
            Transition::new(701798400, 2),
            Transition::new(717519600, 3),
            Transition::new(733248000, 2),
            Transition::new(748969200, 3),
            Transition::new(764697600, 2),
            Transition::new(780418800, 3),
            Transition::new(796147200, 2),
            Transition::new(811868400, 3),
            Transition::new(828201600, 2),
            Transition::new(843922800, 3),
            Transition::new(859651200, 2),
            Transition::new(875372400, 3),
            Transition::new(891100800, 2),
            Transition::new(906822000, 3),
            Transition::new(988394400, 2),
            Transition::new(1001696400, 3),
            Transition::new(1017424800, 2),
            Transition::new(1033146000, 3),
            Transition::new(1048874400, 2),
            Transition::new(1064595600, 3),
            Transition::new(1080324000, 2),
            Transition::new(1096045200, 3),
            Transition::new(1111773600, 2),
            Transition::new(1127494800, 3),
            Transition::new(1143223200, 2),
            Transition::new(1159549200, 3),
            Transition::new(1427479200, 2),
            Transition::new(1443193200, 3),
            Transition::new(1458928800, 2),
            Transition::new(1474642800, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(25652, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(25200, false, Some(b"+07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, true, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_UST_NERA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1579426374, 1),
            Transition::new(-1247558400, 2),
            Transition::new(354898800, 4),
            Transition::new(370699200, 3),
            Transition::new(386427600, 4),
            Transition::new(402235200, 3),
            Transition::new(417963600, 4),
            Transition::new(433771200, 3),
            Transition::new(449586000, 4),
            Transition::new(465318000, 3),
            Transition::new(481042800, 4),
            Transition::new(496767600, 3),
            Transition::new(512492400, 4),
            Transition::new(528217200, 3),
            Transition::new(543942000, 4),
            Transition::new(559666800, 3),
            Transition::new(575391600, 4),
            Transition::new(591116400, 3),
            Transition::new(606841200, 4),
            Transition::new(622566000, 3),
            Transition::new(638290800, 4),
            Transition::new(654620400, 3),
            Transition::new(670345200, 5),
            Transition::new(686073600, 6),
            Transition::new(695750400, 3),
            Transition::new(701794800, 4),
            Transition::new(717519600, 3),
            Transition::new(733244400, 4),
            Transition::new(748969200, 3),
            Transition::new(764694000, 4),
            Transition::new(780418800, 3),
            Transition::new(796143600, 4),
            Transition::new(811868400, 3),
            Transition::new(828198000, 4),
            Transition::new(846342000, 3),
            Transition::new(859647600, 4),
            Transition::new(877791600, 3),
            Transition::new(891097200, 4),
            Transition::new(909241200, 3),
            Transition::new(922546800, 4),
            Transition::new(941295600, 3),
            Transition::new(953996400, 4),
            Transition::new(972745200, 3),
            Transition::new(985446000, 4),
            Transition::new(1004194800, 3),
            Transition::new(1017500400, 4),
            Transition::new(1035644400, 3),
            Transition::new(1048950000, 4),
            Transition::new(1067094000, 3),
            Transition::new(1080399600, 4),
            Transition::new(1099148400, 3),
            Transition::new(1111849200, 4),
            Transition::new(1130598000, 3),
            Transition::new(1143298800, 4),
            Transition::new(1162047600, 3),
            Transition::new(1174748400, 4),
            Transition::new(1193497200, 3),
            Transition::new(1206802800, 4),
            Transition::new(1224946800, 3),
            Transition::new(1238252400, 4),
            Transition::new(1256396400, 3),
            Transition::new(1269702000, 4),
            Transition::new(1288450800, 3),
            Transition::new(1301151600, 7),
            Transition::new(1315828800, 3),
            Transition::new(1414249200, 6),
        ],
        &{
            const V: [LocalTimeType; 8] = [
                match LocalTimeType::new(34374, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, false, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(43200, true, Some(b"+12")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, true, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(43200, false, Some(b"+12")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(36000, false, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_VLADIVOSTOK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1487321251, 1),
            Transition::new(-1247562000, 3),
            Transition::new(354895200, 2),
            Transition::new(370702800, 3),
            Transition::new(386431200, 2),
            Transition::new(402238800, 3),
            Transition::new(417967200, 2),
            Transition::new(433774800, 3),
            Transition::new(449589600, 2),
            Transition::new(465321600, 3),
            Transition::new(481046400, 2),
            Transition::new(496771200, 3),
            Transition::new(512496000, 2),
            Transition::new(528220800, 3),
            Transition::new(543945600, 2),
            Transition::new(559670400, 3),
            Transition::new(575395200, 2),
            Transition::new(591120000, 3),
            Transition::new(606844800, 2),
            Transition::new(622569600, 3),
            Transition::new(638294400, 2),
            Transition::new(654624000, 3),
            Transition::new(670348800, 4),
            Transition::new(686077200, 1),
            Transition::new(695754000, 3),
            Transition::new(701798400, 2),
            Transition::new(717523200, 3),
            Transition::new(733248000, 2),
            Transition::new(748972800, 3),
            Transition::new(764697600, 2),
            Transition::new(780422400, 3),
            Transition::new(796147200, 2),
            Transition::new(811872000, 3),
            Transition::new(828201600, 2),
            Transition::new(846345600, 3),
            Transition::new(859651200, 2),
            Transition::new(877795200, 3),
            Transition::new(891100800, 2),
            Transition::new(909244800, 3),
            Transition::new(922550400, 2),
            Transition::new(941299200, 3),
            Transition::new(954000000, 2),
            Transition::new(972748800, 3),
            Transition::new(985449600, 2),
            Transition::new(1004198400, 3),
            Transition::new(1017504000, 2),
            Transition::new(1035648000, 3),
            Transition::new(1048953600, 2),
            Transition::new(1067097600, 3),
            Transition::new(1080403200, 2),
            Transition::new(1099152000, 3),
            Transition::new(1111852800, 2),
            Transition::new(1130601600, 3),
            Transition::new(1143302400, 2),
            Transition::new(1162051200, 3),
            Transition::new(1174752000, 2),
            Transition::new(1193500800, 3),
            Transition::new(1206806400, 2),
            Transition::new(1224950400, 3),
            Transition::new(1238256000, 2),
            Transition::new(1256400000, 3),
            Transition::new(1269705600, 2),
            Transition::new(1288454400, 3),
            Transition::new(1301155200, 5),
            Transition::new(1414249200, 3),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(31651, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, true, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, true, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, false, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(36000, false, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_YAKUTSK: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1579423138, 1),
            Transition::new(-1247558400, 3),
            Transition::new(354898800, 2),
            Transition::new(370706400, 3),
            Transition::new(386434800, 2),
            Transition::new(402242400, 3),
            Transition::new(417970800, 2),
            Transition::new(433778400, 3),
            Transition::new(449593200, 2),
            Transition::new(465325200, 3),
            Transition::new(481050000, 2),
            Transition::new(496774800, 3),
            Transition::new(512499600, 2),
            Transition::new(528224400, 3),
            Transition::new(543949200, 2),
            Transition::new(559674000, 3),
            Transition::new(575398800, 2),
            Transition::new(591123600, 3),
            Transition::new(606848400, 2),
            Transition::new(622573200, 3),
            Transition::new(638298000, 2),
            Transition::new(654627600, 3),
            Transition::new(670352400, 4),
            Transition::new(686080800, 1),
            Transition::new(695757600, 3),
            Transition::new(701802000, 2),
            Transition::new(717526800, 3),
            Transition::new(733251600, 2),
            Transition::new(748976400, 3),
            Transition::new(764701200, 2),
            Transition::new(780426000, 3),
            Transition::new(796150800, 2),
            Transition::new(811875600, 3),
            Transition::new(828205200, 2),
            Transition::new(846349200, 3),
            Transition::new(859654800, 2),
            Transition::new(877798800, 3),
            Transition::new(891104400, 2),
            Transition::new(909248400, 3),
            Transition::new(922554000, 2),
            Transition::new(941302800, 3),
            Transition::new(954003600, 2),
            Transition::new(972752400, 3),
            Transition::new(985453200, 2),
            Transition::new(1004202000, 3),
            Transition::new(1017507600, 2),
            Transition::new(1035651600, 3),
            Transition::new(1048957200, 2),
            Transition::new(1067101200, 3),
            Transition::new(1080406800, 2),
            Transition::new(1099155600, 3),
            Transition::new(1111856400, 2),
            Transition::new(1130605200, 3),
            Transition::new(1143306000, 2),
            Transition::new(1162054800, 3),
            Transition::new(1174755600, 2),
            Transition::new(1193504400, 3),
            Transition::new(1206810000, 2),
            Transition::new(1224954000, 3),
            Transition::new(1238259600, 2),
            Transition::new(1256403600, 3),
            Transition::new(1269709200, 2),
            Transition::new(1288458000, 3),
            Transition::new(1301158800, 5),
            Transition::new(1414252800, 3),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(31138, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"+08")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, true, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, true, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"+10")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(32400, false, Some(b"+09")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_YEKATERINBURG: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1688270553, 1),
            Transition::new(-1592610305, 2),
            Transition::new(-1247544000, 4),
            Transition::new(354913200, 3),
            Transition::new(370720800, 4),
            Transition::new(386449200, 3),
            Transition::new(402256800, 4),
            Transition::new(417985200, 3),
            Transition::new(433792800, 4),
            Transition::new(449607600, 3),
            Transition::new(465339600, 4),
            Transition::new(481064400, 3),
            Transition::new(496789200, 4),
            Transition::new(512514000, 3),
            Transition::new(528238800, 4),
            Transition::new(543963600, 3),
            Transition::new(559688400, 4),
            Transition::new(575413200, 3),
            Transition::new(591138000, 4),
            Transition::new(606862800, 3),
            Transition::new(622587600, 4),
            Transition::new(638312400, 3),
            Transition::new(654642000, 4),
            Transition::new(670366800, 5),
            Transition::new(686095200, 2),
            Transition::new(695772000, 4),
            Transition::new(701816400, 3),
            Transition::new(717541200, 4),
            Transition::new(733266000, 3),
            Transition::new(748990800, 4),
            Transition::new(764715600, 3),
            Transition::new(780440400, 4),
            Transition::new(796165200, 3),
            Transition::new(811890000, 4),
            Transition::new(828219600, 3),
            Transition::new(846363600, 4),
            Transition::new(859669200, 3),
            Transition::new(877813200, 4),
            Transition::new(891118800, 3),
            Transition::new(909262800, 4),
            Transition::new(922568400, 3),
            Transition::new(941317200, 4),
            Transition::new(954018000, 3),
            Transition::new(972766800, 4),
            Transition::new(985467600, 3),
            Transition::new(1004216400, 4),
            Transition::new(1017522000, 3),
            Transition::new(1035666000, 4),
            Transition::new(1048971600, 3),
            Transition::new(1067115600, 4),
            Transition::new(1080421200, 3),
            Transition::new(1099170000, 4),
            Transition::new(1111870800, 3),
            Transition::new(1130619600, 4),
            Transition::new(1143320400, 3),
            Transition::new(1162069200, 4),
            Transition::new(1174770000, 3),
            Transition::new(1193518800, 4),
            Transition::new(1206824400, 3),
            Transition::new(1224968400, 4),
            Transition::new(1238274000, 3),
            Transition::new(1256418000, 4),
            Transition::new(1269723600, 3),
            Transition::new(1288472400, 4),
            Transition::new(1301173200, 6),
            Transition::new(1414267200, 4),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(14553, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(13505, false, Some(b"PMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, true, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, true, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(21600, false, Some(b"+06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(18000, false, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ASIA_YEREVAN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1441162680, 1),
            Transition::new(-405140400, 3),
            Transition::new(354916800, 2),
            Transition::new(370724400, 3),
            Transition::new(386452800, 2),
            Transition::new(402260400, 3),
            Transition::new(417988800, 2),
            Transition::new(433796400, 3),
            Transition::new(449611200, 2),
            Transition::new(465343200, 3),
            Transition::new(481068000, 2),
            Transition::new(496792800, 3),
            Transition::new(512517600, 2),
            Transition::new(528242400, 3),
            Transition::new(543967200, 2),
            Transition::new(559692000, 3),
            Transition::new(575416800, 2),
            Transition::new(591141600, 3),
            Transition::new(606866400, 2),
            Transition::new(622591200, 3),
            Transition::new(638316000, 2),
            Transition::new(654645600, 3),
            Transition::new(670370400, 4),
            Transition::new(686098800, 1),
            Transition::new(701823600, 4),
            Transition::new(717548400, 1),
            Transition::new(733273200, 4),
            Transition::new(748998000, 1),
            Transition::new(764722800, 4),
            Transition::new(780447600, 1),
            Transition::new(796172400, 4),
            Transition::new(811897200, 3),
            Transition::new(859672800, 2),
            Transition::new(877816800, 3),
            Transition::new(891122400, 2),
            Transition::new(909266400, 3),
            Transition::new(922572000, 2),
            Transition::new(941320800, 3),
            Transition::new(954021600, 2),
            Transition::new(972770400, 3),
            Transition::new(985471200, 2),
            Transition::new(1004220000, 3),
            Transition::new(1017525600, 2),
            Transition::new(1035669600, 3),
            Transition::new(1048975200, 2),
            Transition::new(1067119200, 3),
            Transition::new(1080424800, 2),
            Transition::new(1099173600, 3),
            Transition::new(1111874400, 2),
            Transition::new(1130623200, 3),
            Transition::new(1143324000, 2),
            Transition::new(1162072800, 3),
            Transition::new(1174773600, 2),
            Transition::new(1193522400, 3),
            Transition::new(1206828000, 2),
            Transition::new(1224972000, 3),
            Transition::new(1238277600, 2),
            Transition::new(1256421600, 3),
            Transition::new(1269727200, 2),
            Transition::new(1288476000, 3),
            Transition::new(1301176800, 2),
            Transition::new(1319925600, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(10680, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, false, Some(b"+03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(18000, true, Some(b"+05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(14400, true, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(14400, false, Some(b"+04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ATLANTIC_AZORES: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713904240, 1),
            Transition::new(-1830376800, 3),
            Transition::new(-1689548400, 2),
            Transition::new(-1677794400, 3),
            Transition::new(-1667430000, 2),
            Transition::new(-1647730800, 3),
            Transition::new(-1635807600, 2),
            Transition::new(-1616194800, 3),
            Transition::new(-1604358000, 2),
            Transition::new(-1584658800, 3),
            Transition::new(-1572735600, 2),
            Transition::new(-1553036400, 3),
            Transition::new(-1541199600, 2),
            Transition::new(-1521500400, 3),
            Transition::new(-1442444400, 2),
            Transition::new(-1426806000, 3),
            Transition::new(-1379286000, 2),
            Transition::new(-1364770800, 3),
            Transition::new(-1348441200, 2),
            Transition::new(-1333321200, 3),
            Transition::new(-1316386800, 2),
            Transition::new(-1301266800, 3),
            Transition::new(-1284332400, 2),
            Transition::new(-1269817200, 3),
            Transition::new(-1221433200, 2),
            Transition::new(-1206918000, 3),
            Transition::new(-1191193200, 2),
            Transition::new(-1175468400, 3),
            Transition::new(-1127689200, 2),
            Transition::new(-1111964400, 3),
            Transition::new(-1096844400, 2),
            Transition::new(-1080514800, 3),
            Transition::new(-1063580400, 2),
            Transition::new(-1049065200, 3),
            Transition::new(-1033340400, 2),
            Transition::new(-1017615600, 3),
            Transition::new(-1002495600, 2),
            Transition::new(-986166000, 3),
            Transition::new(-969231600, 2),
            Transition::new(-950482800, 3),
            Transition::new(-942015600, 2),
            Transition::new(-922662000, 3),
            Transition::new(-906937200, 2),
            Transition::new(-891126000, 3),
            Transition::new(-877302000, 2),
            Transition::new(-873676800, 4),
            Transition::new(-864000000, 2),
            Transition::new(-857948400, 3),
            Transition::new(-845852400, 2),
            Transition::new(-842832000, 4),
            Transition::new(-831340800, 2),
            Transition::new(-825894000, 3),
            Transition::new(-814402800, 2),
            Transition::new(-810777600, 4),
            Transition::new(-799891200, 2),
            Transition::new(-794444400, 3),
            Transition::new(-782953200, 2),
            Transition::new(-779328000, 4),
            Transition::new(-768441600, 2),
            Transition::new(-762994800, 3),
            Transition::new(-749084400, 2),
            Transition::new(-733359600, 3),
            Transition::new(-717624000, 2),
            Transition::new(-701899200, 3),
            Transition::new(-686174400, 2),
            Transition::new(-670449600, 3),
            Transition::new(-654724800, 2),
            Transition::new(-639000000, 3),
            Transition::new(-623275200, 2),
            Transition::new(-607550400, 3),
            Transition::new(-591825600, 2),
            Transition::new(-575496000, 3),
            Transition::new(-559771200, 2),
            Transition::new(-544046400, 3),
            Transition::new(-528321600, 2),
            Transition::new(-512596800, 3),
            Transition::new(-496872000, 2),
            Transition::new(-481147200, 3),
            Transition::new(-465422400, 2),
            Transition::new(-449697600, 3),
            Transition::new(-433972800, 2),
            Transition::new(-417643200, 3),
            Transition::new(-401918400, 2),
            Transition::new(-386193600, 3),
            Transition::new(-370468800, 2),
            Transition::new(-354744000, 3),
            Transition::new(-339019200, 2),
            Transition::new(-323294400, 3),
            Transition::new(-307569600, 2),
            Transition::new(-291844800, 3),
            Transition::new(-276120000, 2),
            Transition::new(-260395200, 3),
            Transition::new(-244670400, 2),
            Transition::new(-228340800, 3),
            Transition::new(-212616000, 2),
            Transition::new(-196891200, 3),
            Transition::new(-181166400, 2),
            Transition::new(-165441600, 3),
            Transition::new(-149716800, 2),
            Transition::new(-133992000, 3),
            Transition::new(-118267200, 5),
            Transition::new(228272400, 4),
            Transition::new(243997200, 5),
            Transition::new(260326800, 4),
            Transition::new(276051600, 5),
            Transition::new(291776400, 4),
            Transition::new(307504800, 5),
            Transition::new(323226000, 4),
            Transition::new(338954400, 5),
            Transition::new(354679200, 4),
            Transition::new(370404000, 5),
            Transition::new(386128800, 4),
            Transition::new(401853600, 5),
            Transition::new(417582000, 4),
            Transition::new(433303200, 5),
            Transition::new(449028000, 4),
            Transition::new(465357600, 5),
            Transition::new(481082400, 4),
            Transition::new(496807200, 5),
            Transition::new(512532000, 4),
            Transition::new(528256800, 5),
            Transition::new(543981600, 4),
            Transition::new(559706400, 5),
            Transition::new(575431200, 4),
            Transition::new(591156000, 5),
            Transition::new(606880800, 4),
            Transition::new(622605600, 5),
            Transition::new(638330400, 4),
            Transition::new(654660000, 5),
            Transition::new(670384800, 4),
            Transition::new(686109600, 5),
            Transition::new(701834400, 4),
            Transition::new(717559200, 6),
            Transition::new(733280400, 4),
            Transition::new(749005200, 5),
            Transition::new(764730000, 4),
            Transition::new(780454800, 5),
            Transition::new(796179600, 4),
            Transition::new(811904400, 5),
            Transition::new(828234000, 4),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(-6160, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-6872, false, Some(b"HMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, true, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, false, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, true, Some(b"+00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"WET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-3600, false, Some(b"-01")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(0, true, Some(b"+00")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    3600,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ATLANTIC_BERMUDA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524506042, 2),
            Transition::new(-1664307642, 1),
            Transition::new(-1648932042, 2),
            Transition::new(-1632080442, 1),
            Transition::new(-1618692042, 2),
            Transition::new(-1262281242, 4),
            Transition::new(-882727200, 3),
            Transition::new(-858538800, 4),
            Transition::new(-845229600, 3),
            Transition::new(-825879600, 4),
            Transition::new(-814384800, 3),
            Transition::new(-793825200, 4),
            Transition::new(-782935200, 3),
            Transition::new(-762375600, 4),
            Transition::new(-713988000, 3),
            Transition::new(-703710000, 4),
            Transition::new(-681933600, 3),
            Transition::new(-672865200, 4),
            Transition::new(-650484000, 3),
            Transition::new(-641415600, 4),
            Transition::new(-618429600, 3),
            Transition::new(-609966000, 4),
            Transition::new(-586980000, 3),
            Transition::new(-578516400, 4),
            Transition::new(-555530400, 3),
            Transition::new(-546462000, 4),
            Transition::new(-429127200, 3),
            Transition::new(-415825200, 4),
            Transition::new(136360800, 3),
            Transition::new(152082000, 4),
            Transition::new(167810400, 3),
            Transition::new(183531600, 4),
            Transition::new(199260000, 3),
            Transition::new(215586000, 4),
            Transition::new(230709600, 3),
            Transition::new(247035600, 4),
            Transition::new(262764000, 3),
            Transition::new(278485200, 4),
            Transition::new(294213600, 3),
            Transition::new(309934800, 4),
            Transition::new(325663200, 3),
            Transition::new(341384400, 4),
            Transition::new(357112800, 3),
            Transition::new(372834000, 4),
            Transition::new(388562400, 3),
            Transition::new(404888400, 4),
            Transition::new(420012000, 3),
            Transition::new(436338000, 4),
            Transition::new(452066400, 3),
            Transition::new(467787600, 4),
            Transition::new(483516000, 3),
            Transition::new(499237200, 4),
            Transition::new(514965600, 3),
            Transition::new(530686800, 4),
            Transition::new(544600800, 3),
            Transition::new(562136400, 4),
            Transition::new(576050400, 3),
            Transition::new(594190800, 4),
            Transition::new(607500000, 3),
            Transition::new(625640400, 4),
            Transition::new(638949600, 3),
            Transition::new(657090000, 4),
            Transition::new(671004000, 3),
            Transition::new(688539600, 4),
            Transition::new(702453600, 3),
            Transition::new(719989200, 4),
            Transition::new(733903200, 3),
            Transition::new(752043600, 4),
            Transition::new(765352800, 3),
            Transition::new(783493200, 4),
            Transition::new(796802400, 3),
            Transition::new(814942800, 4),
            Transition::new(828856800, 3),
            Transition::new(846392400, 4),
            Transition::new(860306400, 3),
            Transition::new(877842000, 4),
            Transition::new(891756000, 3),
            Transition::new(909291600, 4),
            Transition::new(923205600, 3),
            Transition::new(941346000, 4),
            Transition::new(954655200, 3),
            Transition::new(972795600, 4),
            Transition::new(986104800, 3),
            Transition::new(1004245200, 4),
            Transition::new(1018159200, 3),
            Transition::new(1035694800, 4),
            Transition::new(1049608800, 3),
            Transition::new(1067144400, 4),
            Transition::new(1081058400, 3),
            Transition::new(1099198800, 4),
            Transition::new(1112508000, 3),
            Transition::new(1130648400, 4),
            Transition::new(1143957600, 3),
            Transition::new(1162098000, 4),
            Transition::new(1173592800, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(-15558, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-11958, true, Some(b"BST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-15558, false, Some(b"BMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"AST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-14400, false, Some(b"AST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-10800, true, Some(b"ADT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ATLANTIC_CANARY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1509663504, 1),
            Transition::new(-733874400, 2),
            Transition::new(323827200, 3),
            Transition::new(338950800, 2),
            Transition::new(354675600, 3),
            Transition::new(370400400, 2),
            Transition::new(386125200, 3),
            Transition::new(401850000, 2),
            Transition::new(417574800, 3),
            Transition::new(433299600, 2),
            Transition::new(449024400, 3),
            Transition::new(465354000, 2),
            Transition::new(481078800, 3),
            Transition::new(496803600, 2),
            Transition::new(512528400, 3),
            Transition::new(528253200, 2),
            Transition::new(543978000, 3),
            Transition::new(559702800, 2),
            Transition::new(575427600, 3),
            Transition::new(591152400, 2),
            Transition::new(606877200, 3),
            Transition::new(622602000, 2),
            Transition::new(638326800, 3),
            Transition::new(654656400, 2),
            Transition::new(670381200, 3),
            Transition::new(686106000, 2),
            Transition::new(701830800, 3),
            Transition::new(717555600, 2),
            Transition::new(733280400, 3),
            Transition::new(749005200, 2),
            Transition::new(764730000, 3),
            Transition::new(780454800, 2),
            Transition::new(796179600, 3),
            Transition::new(811904400, 2),
            Transition::new(828234000, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-3696, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"WET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, true, Some(b"WEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(0, false, Some(b"WET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(3600, true, Some(b"WEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    3600,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ATLANTIC_CAPE_VERDE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1830376800, 1),
            Transition::new(-862610400, 2),
            Transition::new(-764118000, 1),
            Transition::new(186120000, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-5644, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, false, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, true, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ATLANTIC_FAEROE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1955748776, 1),
            Transition::new(354675600, 2),
            Transition::new(370400400, 1),
            Transition::new(386125200, 2),
            Transition::new(401850000, 1),
            Transition::new(417574800, 2),
            Transition::new(433299600, 1),
            Transition::new(449024400, 2),
            Transition::new(465354000, 1),
            Transition::new(481078800, 2),
            Transition::new(496803600, 1),
            Transition::new(512528400, 2),
            Transition::new(528253200, 1),
            Transition::new(543978000, 2),
            Transition::new(559702800, 1),
            Transition::new(575427600, 2),
            Transition::new(591152400, 1),
            Transition::new(606877200, 2),
            Transition::new(622602000, 1),
            Transition::new(638326800, 2),
            Transition::new(654656400, 1),
            Transition::new(670381200, 2),
            Transition::new(686106000, 1),
            Transition::new(701830800, 2),
            Transition::new(717555600, 1),
            Transition::new(733280400, 2),
            Transition::new(749005200, 1),
            Transition::new(764730000, 2),
            Transition::new(780454800, 1),
            Transition::new(796179600, 2),
            Transition::new(811904400, 1),
            Transition::new(828234000, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(-1624, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"WET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, true, Some(b"WEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(0, false, Some(b"WET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(3600, true, Some(b"WEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    3600,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ATLANTIC_MADEIRA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2713906344, 1),
            Transition::new(-1830380400, 3),
            Transition::new(-1689552000, 2),
            Transition::new(-1677798000, 3),
            Transition::new(-1667433600, 2),
            Transition::new(-1647734400, 3),
            Transition::new(-1635811200, 2),
            Transition::new(-1616198400, 3),
            Transition::new(-1604361600, 2),
            Transition::new(-1584662400, 3),
            Transition::new(-1572739200, 2),
            Transition::new(-1553040000, 3),
            Transition::new(-1541203200, 2),
            Transition::new(-1521504000, 3),
            Transition::new(-1442448000, 2),
            Transition::new(-1426809600, 3),
            Transition::new(-1379289600, 2),
            Transition::new(-1364774400, 3),
            Transition::new(-1348444800, 2),
            Transition::new(-1333324800, 3),
            Transition::new(-1316390400, 2),
            Transition::new(-1301270400, 3),
            Transition::new(-1284336000, 2),
            Transition::new(-1269820800, 3),
            Transition::new(-1221436800, 2),
            Transition::new(-1206921600, 3),
            Transition::new(-1191196800, 2),
            Transition::new(-1175472000, 3),
            Transition::new(-1127692800, 2),
            Transition::new(-1111968000, 3),
            Transition::new(-1096848000, 2),
            Transition::new(-1080518400, 3),
            Transition::new(-1063584000, 2),
            Transition::new(-1049068800, 3),
            Transition::new(-1033344000, 2),
            Transition::new(-1017619200, 3),
            Transition::new(-1002499200, 2),
            Transition::new(-986169600, 3),
            Transition::new(-969235200, 2),
            Transition::new(-950486400, 3),
            Transition::new(-942019200, 2),
            Transition::new(-922665600, 3),
            Transition::new(-906940800, 2),
            Transition::new(-891129600, 3),
            Transition::new(-877305600, 2),
            Transition::new(-873680400, 4),
            Transition::new(-864003600, 2),
            Transition::new(-857952000, 3),
            Transition::new(-845856000, 2),
            Transition::new(-842835600, 4),
            Transition::new(-831344400, 2),
            Transition::new(-825897600, 3),
            Transition::new(-814406400, 2),
            Transition::new(-810781200, 4),
            Transition::new(-799894800, 2),
            Transition::new(-794448000, 3),
            Transition::new(-782956800, 2),
            Transition::new(-779331600, 4),
            Transition::new(-768445200, 2),
            Transition::new(-762998400, 3),
            Transition::new(-749088000, 2),
            Transition::new(-733363200, 3),
            Transition::new(-717627600, 2),
            Transition::new(-701902800, 3),
            Transition::new(-686178000, 2),
            Transition::new(-670453200, 3),
            Transition::new(-654728400, 2),
            Transition::new(-639003600, 3),
            Transition::new(-623278800, 2),
            Transition::new(-607554000, 3),
            Transition::new(-591829200, 2),
            Transition::new(-575499600, 3),
            Transition::new(-559774800, 2),
            Transition::new(-544050000, 3),
            Transition::new(-528325200, 2),
            Transition::new(-512600400, 3),
            Transition::new(-496875600, 2),
            Transition::new(-481150800, 3),
            Transition::new(-465426000, 2),
            Transition::new(-449701200, 3),
            Transition::new(-433976400, 2),
            Transition::new(-417646800, 3),
            Transition::new(-401922000, 2),
            Transition::new(-386197200, 3),
            Transition::new(-370472400, 2),
            Transition::new(-354747600, 3),
            Transition::new(-339022800, 2),
            Transition::new(-323298000, 3),
            Transition::new(-307573200, 2),
            Transition::new(-291848400, 3),
            Transition::new(-276123600, 2),
            Transition::new(-260398800, 3),
            Transition::new(-244674000, 2),
            Transition::new(-228344400, 3),
            Transition::new(-212619600, 2),
            Transition::new(-196894800, 3),
            Transition::new(-181170000, 2),
            Transition::new(-165445200, 3),
            Transition::new(-149720400, 2),
            Transition::new(-133995600, 3),
            Transition::new(-118270800, 6),
            Transition::new(228268800, 5),
            Transition::new(243993600, 6),
            Transition::new(260323200, 5),
            Transition::new(276048000, 6),
            Transition::new(291772800, 5),
            Transition::new(307501200, 6),
            Transition::new(323222400, 5),
            Transition::new(338950800, 6),
            Transition::new(354675600, 5),
            Transition::new(370400400, 6),
            Transition::new(386125200, 5),
            Transition::new(401850000, 6),
            Transition::new(417578400, 5),
            Transition::new(433299600, 6),
            Transition::new(449024400, 5),
            Transition::new(465354000, 6),
            Transition::new(481078800, 5),
            Transition::new(496803600, 6),
            Transition::new(512528400, 5),
            Transition::new(528253200, 6),
            Transition::new(543978000, 5),
            Transition::new(559702800, 6),
            Transition::new(575427600, 5),
            Transition::new(591152400, 6),
            Transition::new(606877200, 5),
            Transition::new(622602000, 6),
            Transition::new(638326800, 5),
            Transition::new(654656400, 6),
            Transition::new(670381200, 5),
            Transition::new(686106000, 6),
            Transition::new(701830800, 5),
            Transition::new(717555600, 6),
            Transition::new(733280400, 5),
            Transition::new(749005200, 6),
            Transition::new(764730000, 5),
            Transition::new(780454800, 6),
            Transition::new(796179600, 5),
            Transition::new(811904400, 6),
            Transition::new(828234000, 5),
        ],
        &{
            const V: [LocalTimeType; 7] = [
                match LocalTimeType::new(-4056, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-4056, false, Some(b"FMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, true, Some(b"+00")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-3600, false, Some(b"-01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, true, Some(b"+01")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(3600, true, Some(b"WEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(0, false, Some(b"WET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(0, false, Some(b"WET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(3600, true, Some(b"WEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    3600,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const ATLANTIC_SOUTH_GEORGIA: TimeZoneRef<'static> =
        match TimeZoneRef::<'static>::new(
            &[Transition::new(-2524512832, 1)],
            &{
                const V: [LocalTimeType; 2] = [
                    match LocalTimeType::new(-8768, false, Some(b"LMT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-7200, false, Some(b"-02")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                ];
                V
            },
            &[],
            &Some({
                const V: TransitionRule =
                    TransitionRule::Fixed(match LocalTimeType::new(-7200, false, Some(b"-02")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    });
                V
            }),
        ) {
            Ok(v) => v,
            Err(e) => panic!("{}", e.0),
        };

    pub(crate) const ATLANTIC_STANLEY: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524507716, 1),
            Transition::new(-1824235716, 3),
            Transition::new(-1018209600, 2),
            Transition::new(-1003093200, 3),
            Transition::new(-986760000, 2),
            Transition::new(-971643600, 3),
            Transition::new(-954705600, 2),
            Transition::new(-939589200, 3),
            Transition::new(-923256000, 2),
            Transition::new(-908139600, 3),
            Transition::new(-891806400, 2),
            Transition::new(-876690000, 3),
            Transition::new(-860356800, 2),
            Transition::new(-852066000, 3),
            Transition::new(420609600, 5),
            Transition::new(433306800, 4),
            Transition::new(452052000, 5),
            Transition::new(464151600, 4),
            Transition::new(483501600, 5),
            Transition::new(495601200, 2),
            Transition::new(514350000, 3),
            Transition::new(527054400, 2),
            Transition::new(545799600, 3),
            Transition::new(558504000, 2),
            Transition::new(577249200, 3),
            Transition::new(589953600, 2),
            Transition::new(608698800, 3),
            Transition::new(621403200, 2),
            Transition::new(640753200, 3),
            Transition::new(652852800, 2),
            Transition::new(672202800, 3),
            Transition::new(684907200, 2),
            Transition::new(703652400, 3),
            Transition::new(716356800, 2),
            Transition::new(735102000, 3),
            Transition::new(747806400, 2),
            Transition::new(766551600, 3),
            Transition::new(779256000, 2),
            Transition::new(798001200, 3),
            Transition::new(810705600, 2),
            Transition::new(830055600, 3),
            Transition::new(842760000, 2),
            Transition::new(861505200, 3),
            Transition::new(874209600, 2),
            Transition::new(892954800, 3),
            Transition::new(905659200, 2),
            Transition::new(924404400, 3),
            Transition::new(937108800, 2),
            Transition::new(955854000, 3),
            Transition::new(968558400, 2),
            Transition::new(987310800, 3),
            Transition::new(999410400, 2),
            Transition::new(1019365200, 3),
            Transition::new(1030860000, 2),
            Transition::new(1050814800, 3),
            Transition::new(1062914400, 2),
            Transition::new(1082264400, 3),
            Transition::new(1094364000, 2),
            Transition::new(1113714000, 3),
            Transition::new(1125813600, 2),
            Transition::new(1145163600, 3),
            Transition::new(1157263200, 2),
            Transition::new(1176613200, 3),
            Transition::new(1188712800, 2),
            Transition::new(1208667600, 3),
            Transition::new(1220767200, 2),
            Transition::new(1240117200, 3),
            Transition::new(1252216800, 2),
            Transition::new(1271566800, 3),
            Transition::new(1283666400, 5),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-13884, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-13884, false, Some(b"SMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, true, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, false, Some(b"-04")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-7200, true, Some(b"-02")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(-10800, false, Some(b"-03")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AUSTRALIA_ACT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2364113092, 2),
            Transition::new(-1672560000, 1),
            Transition::new(-1665388800, 2),
            Transition::new(-883641600, 1),
            Transition::new(-876124800, 2),
            Transition::new(-860400000, 1),
            Transition::new(-844675200, 2),
            Transition::new(-828345600, 1),
            Transition::new(-813225600, 2),
            Transition::new(57686400, 1),
            Transition::new(67968000, 2),
            Transition::new(89136000, 1),
            Transition::new(100022400, 2),
            Transition::new(120585600, 1),
            Transition::new(131472000, 2),
            Transition::new(152035200, 1),
            Transition::new(162921600, 2),
            Transition::new(183484800, 1),
            Transition::new(194976000, 2),
            Transition::new(215539200, 1),
            Transition::new(226425600, 2),
            Transition::new(246988800, 1),
            Transition::new(257875200, 2),
            Transition::new(278438400, 1),
            Transition::new(289324800, 2),
            Transition::new(309888000, 1),
            Transition::new(320774400, 2),
            Transition::new(341337600, 1),
            Transition::new(352224000, 2),
            Transition::new(372787200, 1),
            Transition::new(386697600, 2),
            Transition::new(404841600, 1),
            Transition::new(415728000, 2),
            Transition::new(436291200, 1),
            Transition::new(447177600, 2),
            Transition::new(467740800, 1),
            Transition::new(478627200, 2),
            Transition::new(499190400, 1),
            Transition::new(511286400, 2),
            Transition::new(530035200, 1),
            Transition::new(542736000, 2),
            Transition::new(562089600, 1),
            Transition::new(574790400, 2),
            Transition::new(594144000, 1),
            Transition::new(606240000, 2),
            Transition::new(625593600, 1),
            Transition::new(636480000, 2),
            Transition::new(657043200, 1),
            Transition::new(667929600, 2),
            Transition::new(688492800, 1),
            Transition::new(699379200, 2),
            Transition::new(719942400, 1),
            Transition::new(731433600, 2),
            Transition::new(751996800, 1),
            Transition::new(762883200, 2),
            Transition::new(783446400, 1),
            Transition::new(794332800, 2),
            Transition::new(814896000, 1),
            Transition::new(828201600, 2),
            Transition::new(846345600, 1),
            Transition::new(859651200, 2),
            Transition::new(877795200, 1),
            Transition::new(891100800, 2),
            Transition::new(909244800, 1),
            Transition::new(922550400, 2),
            Transition::new(941299200, 1),
            Transition::new(954000000, 2),
            Transition::new(967305600, 1),
            Transition::new(985449600, 2),
            Transition::new(1004198400, 1),
            Transition::new(1017504000, 2),
            Transition::new(1035648000, 1),
            Transition::new(1048953600, 2),
            Transition::new(1067097600, 1),
            Transition::new(1080403200, 2),
            Transition::new(1099152000, 1),
            Transition::new(1111852800, 2),
            Transition::new(1130601600, 1),
            Transition::new(1143907200, 2),
            Transition::new(1162051200, 1),
            Transition::new(1174752000, 2),
            Transition::new(1193500800, 1),
            Transition::new(1207411200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(36292, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, true, Some(b"AEDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"AEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(36000, false, Some(b"AEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(39600, true, Some(b"AEDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AUSTRALIA_ADELAIDE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2364110060, 1),
            Transition::new(-2230189200, 3),
            Transition::new(-1672558200, 2),
            Transition::new(-1665387000, 3),
            Transition::new(-883639800, 2),
            Transition::new(-876123000, 3),
            Transition::new(-860398200, 2),
            Transition::new(-844673400, 3),
            Transition::new(-828343800, 2),
            Transition::new(-813223800, 3),
            Transition::new(57688200, 2),
            Transition::new(67969800, 3),
            Transition::new(89137800, 2),
            Transition::new(100024200, 3),
            Transition::new(120587400, 2),
            Transition::new(131473800, 3),
            Transition::new(152037000, 2),
            Transition::new(162923400, 3),
            Transition::new(183486600, 2),
            Transition::new(194977800, 3),
            Transition::new(215541000, 2),
            Transition::new(226427400, 3),
            Transition::new(246990600, 2),
            Transition::new(257877000, 3),
            Transition::new(278440200, 2),
            Transition::new(289326600, 3),
            Transition::new(309889800, 2),
            Transition::new(320776200, 3),
            Transition::new(341339400, 2),
            Transition::new(352225800, 3),
            Transition::new(372789000, 2),
            Transition::new(384280200, 3),
            Transition::new(404843400, 2),
            Transition::new(415729800, 3),
            Transition::new(436293000, 2),
            Transition::new(447179400, 3),
            Transition::new(467742600, 2),
            Transition::new(478629000, 3),
            Transition::new(499192200, 2),
            Transition::new(511288200, 3),
            Transition::new(530037000, 2),
            Transition::new(542737800, 3),
            Transition::new(562091400, 2),
            Transition::new(574792200, 3),
            Transition::new(594145800, 2),
            Transition::new(606241800, 3),
            Transition::new(625595400, 2),
            Transition::new(637691400, 3),
            Transition::new(657045000, 2),
            Transition::new(667931400, 3),
            Transition::new(688494600, 2),
            Transition::new(701195400, 3),
            Transition::new(719944200, 2),
            Transition::new(731435400, 3),
            Transition::new(751998600, 2),
            Transition::new(764094600, 3),
            Transition::new(783448200, 2),
            Transition::new(796149000, 3),
            Transition::new(814897800, 2),
            Transition::new(828203400, 3),
            Transition::new(846347400, 2),
            Transition::new(859653000, 3),
            Transition::new(877797000, 2),
            Transition::new(891102600, 3),
            Transition::new(909246600, 2),
            Transition::new(922552200, 3),
            Transition::new(941301000, 2),
            Transition::new(954001800, 3),
            Transition::new(972750600, 2),
            Transition::new(985451400, 3),
            Transition::new(1004200200, 2),
            Transition::new(1017505800, 3),
            Transition::new(1035649800, 2),
            Transition::new(1048955400, 3),
            Transition::new(1067099400, 2),
            Transition::new(1080405000, 3),
            Transition::new(1099153800, 2),
            Transition::new(1111854600, 3),
            Transition::new(1130603400, 2),
            Transition::new(1143909000, 3),
            Transition::new(1162053000, 2),
            Transition::new(1174753800, 3),
            Transition::new(1193502600, 2),
            Transition::new(1207413000, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(33260, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"ACST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(37800, true, Some(b"ACDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(34200, false, Some(b"ACST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(34200, false, Some(b"ACST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(37800, true, Some(b"ACDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AUSTRALIA_BRISBANE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2366791928, 2),
            Transition::new(-1672560000, 1),
            Transition::new(-1665388800, 2),
            Transition::new(-883641600, 1),
            Transition::new(-876124800, 2),
            Transition::new(-860400000, 1),
            Transition::new(-844675200, 2),
            Transition::new(-828345600, 1),
            Transition::new(-813225600, 2),
            Transition::new(57686400, 1),
            Transition::new(67968000, 2),
            Transition::new(625593600, 1),
            Transition::new(636480000, 2),
            Transition::new(657043200, 1),
            Transition::new(667929600, 2),
            Transition::new(688492800, 1),
            Transition::new(699379200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(36728, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, true, Some(b"AEDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"AEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(36000, false, Some(b"AEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AUSTRALIA_BROKEN_HILL: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2364110748, 1),
            Transition::new(-2314951200, 2),
            Transition::new(-2230189200, 4),
            Transition::new(-1672558200, 3),
            Transition::new(-1665387000, 4),
            Transition::new(-883639800, 3),
            Transition::new(-876123000, 4),
            Transition::new(-860398200, 3),
            Transition::new(-844673400, 4),
            Transition::new(-828343800, 3),
            Transition::new(-813223800, 4),
            Transition::new(57688200, 3),
            Transition::new(67969800, 4),
            Transition::new(89137800, 3),
            Transition::new(100024200, 4),
            Transition::new(120587400, 3),
            Transition::new(131473800, 4),
            Transition::new(152037000, 3),
            Transition::new(162923400, 4),
            Transition::new(183486600, 3),
            Transition::new(194977800, 4),
            Transition::new(215541000, 3),
            Transition::new(226427400, 4),
            Transition::new(246990600, 3),
            Transition::new(257877000, 4),
            Transition::new(278440200, 3),
            Transition::new(289326600, 4),
            Transition::new(309889800, 3),
            Transition::new(320776200, 4),
            Transition::new(341339400, 3),
            Transition::new(352225800, 4),
            Transition::new(372789000, 3),
            Transition::new(386699400, 4),
            Transition::new(404843400, 3),
            Transition::new(415729800, 4),
            Transition::new(436293000, 3),
            Transition::new(447179400, 4),
            Transition::new(467742600, 3),
            Transition::new(478629000, 4),
            Transition::new(499192200, 3),
            Transition::new(511288200, 4),
            Transition::new(530037000, 3),
            Transition::new(542737800, 4),
            Transition::new(562091400, 3),
            Transition::new(574792200, 4),
            Transition::new(594145800, 3),
            Transition::new(606241800, 4),
            Transition::new(625595400, 3),
            Transition::new(636481800, 4),
            Transition::new(657045000, 3),
            Transition::new(667931400, 4),
            Transition::new(688494600, 3),
            Transition::new(699381000, 4),
            Transition::new(719944200, 3),
            Transition::new(731435400, 4),
            Transition::new(751998600, 3),
            Transition::new(762885000, 4),
            Transition::new(783448200, 3),
            Transition::new(794334600, 4),
            Transition::new(814897800, 3),
            Transition::new(828203400, 4),
            Transition::new(846347400, 3),
            Transition::new(859653000, 4),
            Transition::new(877797000, 3),
            Transition::new(891102600, 4),
            Transition::new(909246600, 3),
            Transition::new(922552200, 4),
            Transition::new(941301000, 3),
            Transition::new(954001800, 4),
            Transition::new(972750600, 3),
            Transition::new(985451400, 4),
            Transition::new(1004200200, 3),
            Transition::new(1017505800, 4),
            Transition::new(1035649800, 3),
            Transition::new(1048955400, 4),
            Transition::new(1067099400, 3),
            Transition::new(1080405000, 4),
            Transition::new(1099153800, 3),
            Transition::new(1111854600, 4),
            Transition::new(1130603400, 3),
            Transition::new(1143909000, 4),
            Transition::new(1162053000, 3),
            Transition::new(1174753800, 4),
            Transition::new(1193502600, 3),
            Transition::new(1207413000, 4),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(33948, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"AEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"ACST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(37800, true, Some(b"ACDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(34200, false, Some(b"ACST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(34200, false, Some(b"ACST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(37800, true, Some(b"ACDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AUSTRALIA_CURRIE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2345795356, 2),
            Transition::new(-1680508800, 1),
            Transition::new(-1665388800, 2),
            Transition::new(-1646640000, 1),
            Transition::new(-1635753600, 2),
            Transition::new(-1615190400, 1),
            Transition::new(-1604304000, 2),
            Transition::new(-883641600, 1),
            Transition::new(-876124800, 2),
            Transition::new(-860400000, 1),
            Transition::new(-844675200, 2),
            Transition::new(-828345600, 1),
            Transition::new(-813225600, 2),
            Transition::new(-71136000, 1),
            Transition::new(-55411200, 2),
            Transition::new(-37267200, 1),
            Transition::new(-25776000, 2),
            Transition::new(-5817600, 1),
            Transition::new(5673600, 2),
            Transition::new(25632000, 1),
            Transition::new(37728000, 2),
            Transition::new(57686400, 1),
            Transition::new(67968000, 2),
            Transition::new(89136000, 1),
            Transition::new(100022400, 2),
            Transition::new(120585600, 1),
            Transition::new(131472000, 2),
            Transition::new(152035200, 1),
            Transition::new(162921600, 2),
            Transition::new(183484800, 1),
            Transition::new(194976000, 2),
            Transition::new(215539200, 1),
            Transition::new(226425600, 2),
            Transition::new(246988800, 1),
            Transition::new(257875200, 2),
            Transition::new(278438400, 1),
            Transition::new(289324800, 2),
            Transition::new(309888000, 1),
            Transition::new(320774400, 2),
            Transition::new(341337600, 1),
            Transition::new(352224000, 2),
            Transition::new(372787200, 1),
            Transition::new(386092800, 2),
            Transition::new(404841600, 1),
            Transition::new(417542400, 2),
            Transition::new(436291200, 1),
            Transition::new(447177600, 2),
            Transition::new(467740800, 1),
            Transition::new(478627200, 2),
            Transition::new(499190400, 1),
            Transition::new(510076800, 2),
            Transition::new(530035200, 1),
            Transition::new(542736000, 2),
            Transition::new(562089600, 1),
            Transition::new(574790400, 2),
            Transition::new(594144000, 1),
            Transition::new(606240000, 2),
            Transition::new(625593600, 1),
            Transition::new(637689600, 2),
            Transition::new(657043200, 1),
            Transition::new(670348800, 2),
            Transition::new(686678400, 1),
            Transition::new(701798400, 2),
            Transition::new(718128000, 1),
            Transition::new(733248000, 2),
            Transition::new(749577600, 1),
            Transition::new(764697600, 2),
            Transition::new(781027200, 1),
            Transition::new(796147200, 2),
            Transition::new(812476800, 1),
            Transition::new(828201600, 2),
            Transition::new(844531200, 1),
            Transition::new(859651200, 2),
            Transition::new(875980800, 1),
            Transition::new(891100800, 2),
            Transition::new(907430400, 1),
            Transition::new(922550400, 2),
            Transition::new(938880000, 1),
            Transition::new(954000000, 2),
            Transition::new(967305600, 1),
            Transition::new(985449600, 2),
            Transition::new(1002384000, 1),
            Transition::new(1017504000, 2),
            Transition::new(1033833600, 1),
            Transition::new(1048953600, 2),
            Transition::new(1065283200, 1),
            Transition::new(1080403200, 2),
            Transition::new(1096732800, 1),
            Transition::new(1111852800, 2),
            Transition::new(1128182400, 1),
            Transition::new(1143907200, 2),
            Transition::new(1159632000, 1),
            Transition::new(1174752000, 2),
            Transition::new(1191686400, 1),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(35356, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, true, Some(b"AEDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"AEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(36000, false, Some(b"AEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(39600, true, Some(b"AEDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AUSTRALIA_DARWIN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2364108200, 1),
            Transition::new(-2230189200, 3),
            Transition::new(-1672558200, 2),
            Transition::new(-1665387000, 3),
            Transition::new(-883639800, 2),
            Transition::new(-876123000, 3),
            Transition::new(-860398200, 2),
            Transition::new(-844673400, 3),
            Transition::new(-828343800, 2),
            Transition::new(-813223800, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(31400, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, false, Some(b"ACST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(37800, true, Some(b"ACDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(34200, false, Some(b"ACST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(34200, false, Some(b"ACST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AUSTRALIA_EUCLA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2337928528, 2),
            Transition::new(-1672555500, 1),
            Transition::new(-1665384300, 2),
            Transition::new(-883637100, 1),
            Transition::new(-876120300, 2),
            Transition::new(-860395500, 1),
            Transition::new(-844670700, 2),
            Transition::new(152039700, 1),
            Transition::new(162926100, 2),
            Transition::new(436295700, 1),
            Transition::new(447182100, 2),
            Transition::new(690311700, 1),
            Transition::new(699383700, 2),
            Transition::new(1165079700, 1),
            Transition::new(1174756500, 2),
            Transition::new(1193505300, 1),
            Transition::new(1206810900, 2),
            Transition::new(1224954900, 1),
            Transition::new(1238260500, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(30928, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(35100, true, Some(b"+0945")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(31500, false, Some(b"+0845")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(31500, false, Some(b"+0845")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AUSTRALIA_LHI: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2364114980, 1),
            Transition::new(352216800, 3),
            Transition::new(372785400, 2),
            Transition::new(384273000, 3),
            Transition::new(404839800, 2),
            Transition::new(415722600, 3),
            Transition::new(436289400, 2),
            Transition::new(447172200, 3),
            Transition::new(467739000, 2),
            Transition::new(478621800, 3),
            Transition::new(499188600, 4),
            Transition::new(511282800, 3),
            Transition::new(530033400, 4),
            Transition::new(542732400, 3),
            Transition::new(562087800, 4),
            Transition::new(574786800, 3),
            Transition::new(594142200, 4),
            Transition::new(606236400, 3),
            Transition::new(625591800, 4),
            Transition::new(636476400, 3),
            Transition::new(657041400, 4),
            Transition::new(667926000, 3),
            Transition::new(688491000, 4),
            Transition::new(699375600, 3),
            Transition::new(719940600, 4),
            Transition::new(731430000, 3),
            Transition::new(751995000, 4),
            Transition::new(762879600, 3),
            Transition::new(783444600, 4),
            Transition::new(794329200, 3),
            Transition::new(814894200, 4),
            Transition::new(828198000, 3),
            Transition::new(846343800, 4),
            Transition::new(859647600, 3),
            Transition::new(877793400, 4),
            Transition::new(891097200, 3),
            Transition::new(909243000, 4),
            Transition::new(922546800, 3),
            Transition::new(941297400, 4),
            Transition::new(953996400, 3),
            Transition::new(967303800, 4),
            Transition::new(985446000, 3),
            Transition::new(1004196600, 4),
            Transition::new(1017500400, 3),
            Transition::new(1035646200, 4),
            Transition::new(1048950000, 3),
            Transition::new(1067095800, 4),
            Transition::new(1080399600, 3),
            Transition::new(1099150200, 4),
            Transition::new(1111849200, 3),
            Transition::new(1130599800, 4),
            Transition::new(1143903600, 3),
            Transition::new(1162049400, 4),
            Transition::new(1174748400, 3),
            Transition::new(1193499000, 4),
            Transition::new(1207407600, 3),
        ],
        &{
            const V: [LocalTimeType; 5] = [
                match LocalTimeType::new(38180, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"AEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(41400, true, Some(b"+1130")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(37800, false, Some(b"+1030")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, true, Some(b"+11")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(37800, false, Some(b"+1030")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(39600, true, Some(b"+11")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AUSTRALIA_LINDEMAN: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2366790956, 2),
            Transition::new(-1672560000, 1),
            Transition::new(-1665388800, 2),
            Transition::new(-883641600, 1),
            Transition::new(-876124800, 2),
            Transition::new(-860400000, 1),
            Transition::new(-844675200, 2),
            Transition::new(-828345600, 1),
            Transition::new(-813225600, 2),
            Transition::new(57686400, 1),
            Transition::new(67968000, 2),
            Transition::new(625593600, 1),
            Transition::new(636480000, 2),
            Transition::new(657043200, 1),
            Transition::new(667929600, 2),
            Transition::new(688492800, 1),
            Transition::new(699379200, 2),
            Transition::new(719942400, 1),
            Transition::new(731433600, 2),
            Transition::new(751996800, 1),
            Transition::new(762883200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(35756, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, true, Some(b"AEDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"AEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(36000, false, Some(b"AEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AUSTRALIA_MELBOURNE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2364111592, 2),
            Transition::new(-1672560000, 1),
            Transition::new(-1665388800, 2),
            Transition::new(-883641600, 1),
            Transition::new(-876124800, 2),
            Transition::new(-860400000, 1),
            Transition::new(-844675200, 2),
            Transition::new(-828345600, 1),
            Transition::new(-813225600, 2),
            Transition::new(57686400, 1),
            Transition::new(67968000, 2),
            Transition::new(89136000, 1),
            Transition::new(100022400, 2),
            Transition::new(120585600, 1),
            Transition::new(131472000, 2),
            Transition::new(152035200, 1),
            Transition::new(162921600, 2),
            Transition::new(183484800, 1),
            Transition::new(194976000, 2),
            Transition::new(215539200, 1),
            Transition::new(226425600, 2),
            Transition::new(246988800, 1),
            Transition::new(257875200, 2),
            Transition::new(278438400, 1),
            Transition::new(289324800, 2),
            Transition::new(309888000, 1),
            Transition::new(320774400, 2),
            Transition::new(341337600, 1),
            Transition::new(352224000, 2),
            Transition::new(372787200, 1),
            Transition::new(384278400, 2),
            Transition::new(404841600, 1),
            Transition::new(415728000, 2),
            Transition::new(436291200, 1),
            Transition::new(447177600, 2),
            Transition::new(467740800, 1),
            Transition::new(478627200, 2),
            Transition::new(499190400, 1),
            Transition::new(511286400, 2),
            Transition::new(530035200, 1),
            Transition::new(542736000, 2),
            Transition::new(561484800, 1),
            Transition::new(574790400, 2),
            Transition::new(594144000, 1),
            Transition::new(606240000, 2),
            Transition::new(625593600, 1),
            Transition::new(637689600, 2),
            Transition::new(657043200, 1),
            Transition::new(667929600, 2),
            Transition::new(688492800, 1),
            Transition::new(699379200, 2),
            Transition::new(719942400, 1),
            Transition::new(731433600, 2),
            Transition::new(751996800, 1),
            Transition::new(762883200, 2),
            Transition::new(783446400, 1),
            Transition::new(796147200, 2),
            Transition::new(814896000, 1),
            Transition::new(828201600, 2),
            Transition::new(846345600, 1),
            Transition::new(859651200, 2),
            Transition::new(877795200, 1),
            Transition::new(891100800, 2),
            Transition::new(909244800, 1),
            Transition::new(922550400, 2),
            Transition::new(941299200, 1),
            Transition::new(954000000, 2),
            Transition::new(967305600, 1),
            Transition::new(985449600, 2),
            Transition::new(1004198400, 1),
            Transition::new(1017504000, 2),
            Transition::new(1035648000, 1),
            Transition::new(1048953600, 2),
            Transition::new(1067097600, 1),
            Transition::new(1080403200, 2),
            Transition::new(1099152000, 1),
            Transition::new(1111852800, 2),
            Transition::new(1130601600, 1),
            Transition::new(1143907200, 2),
            Transition::new(1162051200, 1),
            Transition::new(1174752000, 2),
            Transition::new(1193500800, 1),
            Transition::new(1207411200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(34792, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(39600, true, Some(b"AEDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(36000, false, Some(b"AEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(36000, false, Some(b"AEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(39600, true, Some(b"AEDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const AUSTRALIA_PERTH: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2337925404, 2),
            Transition::new(-1672552800, 1),
            Transition::new(-1665381600, 2),
            Transition::new(-883634400, 1),
            Transition::new(-876117600, 2),
            Transition::new(-860392800, 1),
            Transition::new(-844668000, 2),
            Transition::new(152042400, 1),
            Transition::new(162928800, 2),
            Transition::new(436298400, 1),
            Transition::new(447184800, 2),
            Transition::new(690314400, 1),
            Transition::new(699386400, 2),
            Transition::new(1165082400, 1),
            Transition::new(1174759200, 2),
            Transition::new(1193508000, 1),
            Transition::new(1206813600, 2),
            Transition::new(1224957600, 1),
            Transition::new(1238263200, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(27804, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(32400, true, Some(b"AWDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(28800, false, Some(b"AWST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(28800, false, Some(b"AWST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const CET: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1693706400, 1),
            Transition::new(-1680483600, 0),
            Transition::new(-1663455600, 1),
            Transition::new(-1650150000, 0),
            Transition::new(-1632006000, 1),
            Transition::new(-1618700400, 0),
            Transition::new(-938905200, 1),
            Transition::new(-857257200, 0),
            Transition::new(-844556400, 1),
            Transition::new(-828226800, 0),
            Transition::new(-812502000, 1),
            Transition::new(-796777200, 0),
            Transition::new(-781052400, 1),
            Transition::new(-766623600, 0),
            Transition::new(228877200, 1),
            Transition::new(243997200, 0),
            Transition::new(260326800, 1),
            Transition::new(276051600, 0),
            Transition::new(291776400, 1),
            Transition::new(307501200, 0),
            Transition::new(323830800, 1),
            Transition::new(338950800, 0),
            Transition::new(354675600, 1),
            Transition::new(370400400, 0),
            Transition::new(386125200, 1),
            Transition::new(401850000, 0),
            Transition::new(417574800, 1),
            Transition::new(433299600, 0),
            Transition::new(449024400, 1),
            Transition::new(465354000, 0),
            Transition::new(481078800, 1),
            Transition::new(496803600, 0),
            Transition::new(512528400, 1),
            Transition::new(528253200, 0),
            Transition::new(543978000, 1),
            Transition::new(559702800, 0),
            Transition::new(575427600, 1),
            Transition::new(591152400, 0),
            Transition::new(606877200, 1),
            Transition::new(622602000, 0),
            Transition::new(638326800, 1),
            Transition::new(654656400, 0),
            Transition::new(670381200, 1),
            Transition::new(686106000, 0),
            Transition::new(701830800, 1),
            Transition::new(717555600, 0),
            Transition::new(733280400, 1),
            Transition::new(749005200, 0),
            Transition::new(764730000, 1),
            Transition::new(780454800, 0),
            Transition::new(796179600, 1),
            Transition::new(811904400, 0),
            Transition::new(828234000, 1),
        ],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(3600, false, Some(b"CET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, true, Some(b"CEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(3600, false, Some(b"CET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(7200, true, Some(b"CEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const CHILE_EASTER_ISLAND: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524495352, 1),
            Transition::new(-1178124152, 3),
            Transition::new(-36619200, 2),
            Transition::new(-23922000, 3),
            Transition::new(-3355200, 2),
            Transition::new(7527600, 3),
            Transition::new(24465600, 2),
            Transition::new(37767600, 3),
            Transition::new(55915200, 2),
            Transition::new(69217200, 3),
            Transition::new(87969600, 2),
            Transition::new(100666800, 3),
            Transition::new(118209600, 2),
            Transition::new(132116400, 3),
            Transition::new(150868800, 2),
            Transition::new(163566000, 3),
            Transition::new(182318400, 2),
            Transition::new(195620400, 3),
            Transition::new(213768000, 2),
            Transition::new(227070000, 3),
            Transition::new(245217600, 2),
            Transition::new(258519600, 3),
            Transition::new(277272000, 2),
            Transition::new(289969200, 3),
            Transition::new(308721600, 2),
            Transition::new(321418800, 3),
            Transition::new(340171200, 2),
            Transition::new(353473200, 3),
            Transition::new(371620800, 2),
            Transition::new(384922800, 4),
            Transition::new(403070400, 5),
            Transition::new(416372400, 4),
            Transition::new(434520000, 5),
            Transition::new(447822000, 4),
            Transition::new(466574400, 5),
            Transition::new(479271600, 4),
            Transition::new(498024000, 5),
            Transition::new(510721200, 4),
            Transition::new(529473600, 5),
            Transition::new(545194800, 4),
            Transition::new(560923200, 5),
            Transition::new(574225200, 4),
            Transition::new(592372800, 5),
            Transition::new(605674800, 4),
            Transition::new(624427200, 5),
            Transition::new(637124400, 4),
            Transition::new(653457600, 5),
            Transition::new(668574000, 4),
            Transition::new(687326400, 5),
            Transition::new(700628400, 4),
            Transition::new(718776000, 5),
            Transition::new(732078000, 4),
            Transition::new(750225600, 5),
            Transition::new(763527600, 4),
            Transition::new(781675200, 5),
            Transition::new(794977200, 4),
            Transition::new(813729600, 5),
            Transition::new(826426800, 4),
            Transition::new(845179200, 5),
            Transition::new(859690800, 4),
            Transition::new(876628800, 5),
            Transition::new(889930800, 4),
            Transition::new(906868800, 5),
            Transition::new(923194800, 4),
            Transition::new(939528000, 5),
            Transition::new(952830000, 4),
            Transition::new(971582400, 5),
            Transition::new(984279600, 4),
            Transition::new(1003032000, 5),
            Transition::new(1015729200, 4),
            Transition::new(1034481600, 5),
            Transition::new(1047178800, 4),
            Transition::new(1065931200, 5),
            Transition::new(1079233200, 4),
            Transition::new(1097380800, 5),
            Transition::new(1110682800, 4),
            Transition::new(1128830400, 5),
            Transition::new(1142132400, 4),
            Transition::new(1160884800, 5),
            Transition::new(1173582000, 4),
            Transition::new(1192334400, 5),
            Transition::new(1206846000, 4),
            Transition::new(1223784000, 5),
            Transition::new(1237086000, 4),
            Transition::new(1255233600, 5),
            Transition::new(1270350000, 4),
            Transition::new(1286683200, 5),
            Transition::new(1304823600, 4),
            Transition::new(1313899200, 5),
            Transition::new(1335668400, 4),
            Transition::new(1346558400, 5),
            Transition::new(1367118000, 4),
            Transition::new(1378612800, 5),
            Transition::new(1398567600, 4),
            Transition::new(1410062400, 5),
            Transition::new(1463281200, 4),
            Transition::new(1471147200, 5),
            Transition::new(1494730800, 4),
            Transition::new(1502596800, 5),
            Transition::new(1526180400, 4),
            Transition::new(1534046400, 5),
            Transition::new(1554606000, 4),
        ],
        &{
            const V: [LocalTimeType; 6] = [
                match LocalTimeType::new(-26248, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-26248, false, Some(b"EMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, true, Some(b"-06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-25200, false, Some(b"-07")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-21600, false, Some(b"-06")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"-05")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"-06")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"-05")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(9, 1, 6) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    79200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(4, 1, 6) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    79200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const CST_6_CDT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-1633276800, 1),
            Transition::new(-1615136400, 0),
            Transition::new(-1601827200, 1),
            Transition::new(-1583686800, 0),
            Transition::new(-880214400, 2),
            Transition::new(-769395600, 3),
            Transition::new(-765392400, 0),
            Transition::new(-84384000, 1),
            Transition::new(-68662800, 0),
            Transition::new(-52934400, 1),
            Transition::new(-37213200, 0),
            Transition::new(-21484800, 1),
            Transition::new(-5763600, 0),
            Transition::new(9964800, 1),
            Transition::new(25686000, 0),
            Transition::new(41414400, 1),
            Transition::new(57740400, 0),
            Transition::new(73468800, 1),
            Transition::new(89190000, 0),
            Transition::new(104918400, 1),
            Transition::new(120639600, 0),
            Transition::new(126691200, 1),
            Transition::new(152089200, 0),
            Transition::new(162374400, 1),
            Transition::new(183538800, 0),
            Transition::new(199267200, 1),
            Transition::new(215593200, 0),
            Transition::new(230716800, 1),
            Transition::new(247042800, 0),
            Transition::new(262771200, 1),
            Transition::new(278492400, 0),
            Transition::new(294220800, 1),
            Transition::new(309942000, 0),
            Transition::new(325670400, 1),
            Transition::new(341391600, 0),
            Transition::new(357120000, 1),
            Transition::new(372841200, 0),
            Transition::new(388569600, 1),
            Transition::new(404895600, 0),
            Transition::new(420019200, 1),
            Transition::new(436345200, 0),
            Transition::new(452073600, 1),
            Transition::new(467794800, 0),
            Transition::new(483523200, 1),
            Transition::new(499244400, 0),
            Transition::new(514972800, 1),
            Transition::new(530694000, 0),
            Transition::new(544608000, 1),
            Transition::new(562143600, 0),
            Transition::new(576057600, 1),
            Transition::new(594198000, 0),
            Transition::new(607507200, 1),
            Transition::new(625647600, 0),
            Transition::new(638956800, 1),
            Transition::new(657097200, 0),
            Transition::new(671011200, 1),
            Transition::new(688546800, 0),
            Transition::new(702460800, 1),
            Transition::new(719996400, 0),
            Transition::new(733910400, 1),
            Transition::new(752050800, 0),
            Transition::new(765360000, 1),
            Transition::new(783500400, 0),
            Transition::new(796809600, 1),
            Transition::new(814950000, 0),
            Transition::new(828864000, 1),
            Transition::new(846399600, 0),
            Transition::new(860313600, 1),
            Transition::new(877849200, 0),
            Transition::new(891763200, 1),
            Transition::new(909298800, 0),
            Transition::new(923212800, 1),
            Transition::new(941353200, 0),
            Transition::new(954662400, 1),
            Transition::new(972802800, 0),
            Transition::new(986112000, 1),
            Transition::new(1004252400, 0),
            Transition::new(1018166400, 1),
            Transition::new(1035702000, 0),
            Transition::new(1049616000, 1),
            Transition::new(1067151600, 0),
            Transition::new(1081065600, 1),
            Transition::new(1099206000, 0),
            Transition::new(1112515200, 1),
            Transition::new(1130655600, 0),
            Transition::new(1143964800, 1),
            Transition::new(1162105200, 0),
            Transition::new(1173600000, 1),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-21600, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CWT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, true, Some(b"CPT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-21600, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-18000, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    7200,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const CUBA: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2524501832, 1),
            Transition::new(-1402813824, 3),
            Transition::new(-1311534000, 2),
            Transition::new(-1300996800, 3),
            Transition::new(-933534000, 2),
            Transition::new(-925675200, 3),
            Transition::new(-902084400, 2),
            Transition::new(-893620800, 3),
            Transition::new(-870030000, 2),
            Transition::new(-862171200, 3),
            Transition::new(-775681200, 2),
            Transition::new(-767822400, 3),
            Transition::new(-744231600, 2),
            Transition::new(-736372800, 3),
            Transition::new(-144702000, 2),
            Transition::new(-134251200, 3),
            Transition::new(-113425200, 2),
            Transition::new(-102542400, 3),
            Transition::new(-86295600, 2),
            Transition::new(-72907200, 3),
            Transition::new(-54154800, 2),
            Transition::new(-41457600, 3),
            Transition::new(-21495600, 2),
            Transition::new(-5774400, 3),
            Transition::new(9954000, 2),
            Transition::new(25675200, 3),
            Transition::new(41403600, 2),
            Transition::new(57729600, 3),
            Transition::new(73458000, 2),
            Transition::new(87364800, 3),
            Transition::new(104907600, 2),
            Transition::new(118900800, 3),
            Transition::new(136357200, 2),
            Transition::new(150436800, 3),
            Transition::new(167806800, 2),
            Transition::new(183528000, 3),
            Transition::new(199256400, 2),
            Transition::new(215582400, 3),
            Transition::new(230706000, 2),
            Transition::new(247032000, 3),
            Transition::new(263365200, 2),
            Transition::new(276667200, 3),
            Transition::new(290581200, 2),
            Transition::new(308721600, 3),
            Transition::new(322030800, 2),
            Transition::new(340171200, 3),
            Transition::new(358318800, 2),
            Transition::new(371620800, 3),
            Transition::new(389768400, 2),
            Transition::new(403070400, 3),
            Transition::new(421218000, 2),
            Transition::new(434520000, 3),
            Transition::new(452667600, 2),
            Transition::new(466574400, 3),
            Transition::new(484117200, 2),
            Transition::new(498024000, 3),
            Transition::new(511333200, 2),
            Transition::new(529473600, 3),
            Transition::new(542782800, 2),
            Transition::new(560923200, 3),
            Transition::new(574837200, 2),
            Transition::new(592372800, 3),
            Transition::new(606286800, 2),
            Transition::new(623822400, 3),
            Transition::new(638946000, 2),
            Transition::new(655876800, 3),
            Transition::new(671000400, 2),
            Transition::new(687330000, 3),
            Transition::new(702450000, 2),
            Transition::new(718779600, 3),
            Transition::new(733899600, 2),
            Transition::new(750229200, 3),
            Transition::new(765349200, 2),
            Transition::new(781678800, 3),
            Transition::new(796798800, 2),
            Transition::new(813128400, 3),
            Transition::new(828853200, 2),
            Transition::new(844578000, 3),
            Transition::new(860302800, 2),
            Transition::new(876632400, 3),
            Transition::new(891147600, 2),
            Transition::new(909291600, 3),
            Transition::new(922597200, 2),
            Transition::new(941346000, 3),
            Transition::new(954651600, 2),
            Transition::new(972795600, 3),
            Transition::new(986101200, 2),
            Transition::new(1004245200, 3),
            Transition::new(1018155600, 2),
            Transition::new(1035694800, 3),
            Transition::new(1049605200, 2),
            Transition::new(1067144400, 3),
            Transition::new(1080450000, 2),
            Transition::new(1162098000, 3),
            Transition::new(1173589200, 2),
            Transition::new(1193547600, 3),
            Transition::new(1205643600, 2),
            Transition::new(1224997200, 3),
            Transition::new(1236488400, 2),
            Transition::new(1256446800, 3),
            Transition::new(1268542800, 2),
            Transition::new(1288501200, 3),
            Transition::new(1300597200, 2),
            Transition::new(1321160400, 3),
            Transition::new(1333256400, 2),
            Transition::new(1352005200, 3),
        ],
        &{
            const V: [LocalTimeType; 4] = [
                match LocalTimeType::new(-19768, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-19776, false, Some(b"HMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-14400, true, Some(b"CDT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(-18000, false, Some(b"CST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(-18000, false, Some(b"CST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(-14400, true, Some(b"CDT")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 2, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    0,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(11, 1, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    3600,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const EET: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(228877200, 1),
            Transition::new(243997200, 0),
            Transition::new(260326800, 1),
            Transition::new(276051600, 0),
            Transition::new(291776400, 1),
            Transition::new(307501200, 0),
            Transition::new(323830800, 1),
            Transition::new(338950800, 0),
            Transition::new(354675600, 1),
            Transition::new(370400400, 0),
            Transition::new(386125200, 1),
            Transition::new(401850000, 0),
            Transition::new(417574800, 1),
            Transition::new(433299600, 0),
            Transition::new(449024400, 1),
            Transition::new(465354000, 0),
            Transition::new(481078800, 1),
            Transition::new(496803600, 0),
            Transition::new(512528400, 1),
            Transition::new(528253200, 0),
            Transition::new(543978000, 1),
            Transition::new(559702800, 0),
            Transition::new(575427600, 1),
            Transition::new(591152400, 0),
            Transition::new(606877200, 1),
            Transition::new(622602000, 0),
            Transition::new(638326800, 1),
            Transition::new(654656400, 0),
            Transition::new(670381200, 1),
            Transition::new(686106000, 0),
            Transition::new(701830800, 1),
            Transition::new(717555600, 0),
            Transition::new(733280400, 1),
            Transition::new(749005200, 0),
            Transition::new(764730000, 1),
            Transition::new(780454800, 0),
            Transition::new(796179600, 1),
            Transition::new(811904400, 0),
            Transition::new(828234000, 1),
        ],
        &{
            const V: [LocalTimeType; 2] = [
                match LocalTimeType::new(7200, false, Some(b"EET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"EEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule = TransitionRule::Alternate(
                match AlternateTime::new(
                    match LocalTimeType::new(7200, false, Some(b"EET")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    match LocalTimeType::new(10800, true, Some(b"EEST")) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    },
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(3, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    10800,
                    RuleDay::MonthWeekDay(match MonthWeekDay::new(10, 5, 0) {
                        Ok(v) => v,
                        Err(e) => panic!("{}", e.0),
                    }),
                    14400,
                ) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            );
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const EGYPT: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2185409109, 2),
            Transition::new(-929844000, 1),
            Transition::new(-923108400, 2),
            Transition::new(-906170400, 1),
            Transition::new(-892868400, 2),
            Transition::new(-875844000, 1),
            Transition::new(-857790000, 2),
            Transition::new(-844308000, 1),
            Transition::new(-825822000, 2),
            Transition::new(-812685600, 1),
            Transition::new(-794199600, 2),
            Transition::new(-779853600, 1),
            Transition::new(-762663600, 2),
            Transition::new(-399088800, 1),
            Transition::new(-386650800, 2),
            Transition::new(-368330400, 1),
            Transition::new(-355114800, 2),
            Transition::new(-336790800, 1),
            Transition::new(-323654400, 2),
            Transition::new(-305168400, 1),
            Transition::new(-292032000, 2),
            Transition::new(-273632400, 1),
            Transition::new(-260496000, 2),
            Transition::new(-242096400, 1),
            Transition::new(-228960000, 2),
            Transition::new(-210560400, 1),
            Transition::new(-197424000, 2),
            Transition::new(-178938000, 1),
            Transition::new(-165801600, 2),
            Transition::new(-147402000, 1),
            Transition::new(-134265600, 2),
            Transition::new(-115866000, 1),
            Transition::new(-102643200, 2),
            Transition::new(-84330000, 1),
            Transition::new(-71107200, 2),
            Transition::new(-52707600, 1),
            Transition::new(-39484800, 2),
            Transition::new(-21171600, 1),
            Transition::new(-7948800, 2),
            Transition::new(10364400, 1),
            Transition::new(23587200, 2),
            Transition::new(41900400, 1),
            Transition::new(55123200, 2),
            Transition::new(73522800, 1),
            Transition::new(86745600, 2),
            Transition::new(105058800, 1),
            Transition::new(118281600, 2),
            Transition::new(136594800, 1),
            Transition::new(149817600, 2),
            Transition::new(168130800, 1),
            Transition::new(181353600, 2),
            Transition::new(199753200, 1),
            Transition::new(212976000, 2),
            Transition::new(231289200, 1),
            Transition::new(244512000, 2),
            Transition::new(262825200, 1),
            Transition::new(276048000, 2),
            Transition::new(294361200, 1),
            Transition::new(307584000, 2),
            Transition::new(325983600, 1),
            Transition::new(339206400, 2),
            Transition::new(357519600, 1),
            Transition::new(370742400, 2),
            Transition::new(396399600, 1),
            Transition::new(402278400, 2),
            Transition::new(426812400, 1),
            Transition::new(433814400, 2),
            Transition::new(452214000, 1),
            Transition::new(465436800, 2),
            Transition::new(483750000, 1),
            Transition::new(496972800, 2),
            Transition::new(515286000, 1),
            Transition::new(528508800, 2),
            Transition::new(546822000, 1),
            Transition::new(560044800, 2),
            Transition::new(578444400, 1),
            Transition::new(591667200, 2),
            Transition::new(610412400, 1),
            Transition::new(623203200, 2),
            Transition::new(641516400, 1),
            Transition::new(654739200, 2),
            Transition::new(673052400, 1),
            Transition::new(686275200, 2),
            Transition::new(704674800, 1),
            Transition::new(717897600, 2),
            Transition::new(736210800, 1),
            Transition::new(749433600, 2),
            Transition::new(767746800, 1),
            Transition::new(780969600, 2),
            Transition::new(799020000, 1),
            Transition::new(812322000, 2),
            Transition::new(830469600, 1),
            Transition::new(843771600, 2),
            Transition::new(861919200, 1),
            Transition::new(875221200, 2),
            Transition::new(893368800, 1),
            Transition::new(906670800, 2),
            Transition::new(925423200, 1),
            Transition::new(938725200, 2),
            Transition::new(956872800, 1),
            Transition::new(970174800, 2),
            Transition::new(988322400, 1),
            Transition::new(1001624400, 2),
            Transition::new(1019772000, 1),
            Transition::new(1033074000, 2),
            Transition::new(1051221600, 1),
            Transition::new(1064523600, 2),
            Transition::new(1083276000, 1),
            Transition::new(1096578000, 2),
            Transition::new(1114725600, 1),
            Transition::new(1128027600, 2),
            Transition::new(1146175200, 1),
            Transition::new(1158872400, 2),
            Transition::new(1177624800, 1),
            Transition::new(1189112400, 2),
            Transition::new(1209074400, 1),
            Transition::new(1219957200, 2),
            Transition::new(1240524000, 1),
            Transition::new(1250802000, 2),
            Transition::new(1272578400, 1),
            Transition::new(1281474000, 2),
            Transition::new(1284069600, 1),
            Transition::new(1285880400, 2),
            Transition::new(1400191200, 1),
            Transition::new(1403816400, 2),
            Transition::new(1406844000, 1),
            Transition::new(1411678800, 2),
        ],
        &{
            const V: [LocalTimeType; 3] = [
                match LocalTimeType::new(7509, false, Some(b"LMT")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(10800, true, Some(b"EEST")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
                match LocalTimeType::new(7200, false, Some(b"EET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                },
            ];
            V
        },
        &[],
        &Some({
            const V: TransitionRule =
                TransitionRule::Fixed(match LocalTimeType::new(7200, false, Some(b"EET")) {
                    Ok(v) => v,
                    Err(e) => panic!("{}", e.0),
                });
            V
        }),
    ) {
        Ok(v) => v,
        Err(e) => panic!("{}", e.0),
    };

    pub(crate) const EIRE: TimeZoneRef<'static> = match TimeZoneRef::<'static>::new(
        &[
            Transition::new(-2821649700, 1),
            Transition::new(-1691962479, 2),
            Transition::new(-1680471279, 4),
            Transition::new(-1664143200, 3),
            Transition::new(-1650146400, 4),
            Transition::new(-1633903200, 3),
            Transition::new(-1617487200, 4),
            Transition::new(-1601848800, 3),
            Transition::new(-1586037600, 4),
            Transition::new(-1570399200, 3),
            Transition::new(-1552168800, 4),
            Transition::new(-1538344800, 3),
            Transition::new(-1522533600, 4),
            Transition::new(-1507500000, 5),
            Transition::new(-1490565600, 4),
            Transition::new(-1473631200, 5),
            Transition::new(-1460930400, 4),
            Transition::new(-1442786400, 5),
            Transition::new(-1428876000, 4),
            Transition::new(-1410732000, 5),
            Transition::new(-1396216800, 4),
            Transition::new(-1379282400, 5),
            Transition::new(-1364767200, 4),
            Transition::new(-1348437600, 5),
            Transition::new(-1333317600, 4),
            Transition::new(-1315778400, 5),
            Transition::new(-1301263200, 4),
            Transition::new(-1284328800, 5),
            Transition::new(-1269813600, 4),
            Transition::new(-1253484000, 5),
            Transition::new(-1238364000, 4),
            Transition::new(-1221429600, 5),
            Transition::new(-1206914400, 4),
            Transition::new(-1189980000, 5),
            Transition::new(-1175464800, 4),
            Transition::new(-1159135200, 5),
            Transition::new(-1143410400, 4),
            Transition::new(-1126476000, 5),
            Transition::new(-1111960800, 4),
            Transition::new(-1095631200, 5),
            Transition::new(-1080511200, 4),
            Transition::new(-1063576800, 5),
            Transition::new(-1049061600, 4),
            Transition::new(-1032127200, 5),
            Transition::new(-1017612000, 4),
            Transition::new(-1001282400, 5),
            Transition::new(-986162400, 4),
            Transition::new(-969228000, 5),
            Transition::new(-950479200, 4),
            Transition::new(-942012000, 5),
            Transition::new(-733356000, 4),
            Transition::new(-719445600, 5),
            Transition::new(-699487200, 4),
            Transition::new(-684972000, 5),
            Transition::new(-668037600, 4),
            Transition::new(-654732000, 5),
            Transition::new(-636588000, 4),
            Transition::new(-622072800, 5),
            Transition::new(-605743200, 4),
            Transition::new(-590623200, 5),
            Transition::new(-574293600, 4),
            Transition::new(-558568800, 5),
            Transition::new(-542239200, 4),
            Transition::new(-527119200, 5),
            Transition::new(-512604000, 4),
            Transition::new(-496274400, 5),
            Transition::new(-481154400, 4),
            Transition::new(-464220000, 5),
            Transition::new(-449704800, 4),
            Transition::new(-432165600, 5),
            Transition::new(-417650400, 4),
            Transition::new(-401320800, 5),
            Transition::new(-386200800, 4),
            Transition::new(-369266400, 5),
            Transition::new(-354751200, 4),
            Transition::new(-337816800, 5),
            Transition::new(-323301600, 4),
            Transition::new(-306972000, 5),
            Transition::new(-291852000, 4),
            Transition::new(-276732000, 5),
            Transition::new(-257983200, 4),
            Transition::new(-245282400, 5),
            Transition::new(-226533600, 4),
            Transition::new(-213228000, 5),
            Transition::new(-195084000, 4),
            Transition::new(-182383200, 5),
            Transition::new(-163634400, 4),
            Transition::new(-150933600, 5),
            Transition::new(-132184800, 4),
            Transition::new(-119484000, 5),
            Transition::new(-100735200, 4),
            Transition::new(-88034400, 5),
            Transition::new(-68680800, 4),
            Transition::new(-59004000, 5),
            Transition::new(-37242000, 7),
            Transition::new(57722400, 6),
            Transition::new(69818400, 7),
            Transition::new(89172000, 6),
            Transition::new(101268000, 7),
            Transition::new(120621600, 6),
            Transition::new(132717600, 7),
            Transition::new(152071200, 6),
            Transition::new(164167200, 7),
            Transition::new(183520800, 6),
            Transition::new(196221600, 7),
            Transition::new(214970400, 6),
            Transition::new(227671200, 7),
            Transition::new(246420000, 6),
            Transition::new(259120800, 7),
            Transition::new(278474400, 6),
            Transition::new(290570400, 7),
            Transition::new(309924000, 6),
            Transition::new(322020000, 7),
            Transition::new(341373600, 6),
            Transition::new(354675600, 7),
            Transition::new(372819600, 6),
            Transition::new(386125200, 7),
            Transition::new(40426920