// SPDX-License-Identifier: MIT-0

// GENERATED FILE
// ALL CHANGES MADE IN THIS FILE WILL BE LOST!

// MIT No Attribution
//
// Copyright 2022 René Kijewski <crates.io@k6i.de>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
// associated documentation files (the "Software"), to deal in the Software without restriction,
// including without limitation the rights to use, copy, modify, merge, publish, distribute,
// sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
// NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

use once_cell::race::OnceBox;
use tz::TimeZone;

use crate::{DbTimeZone, Lower32};

/// All defined time zones statically accessible
#[allow(non_upper_case_globals)]
pub mod time_zone {
    use super::*;

    /// Africa/Abidjan,
    pub static AfricaAbidjan: &DbTimeZone = &DbTimeZone {
        index: 0,
        name: "Africa/Abidjan",
        debug_name: "AfricaAbidjan",
        bytes: bytes::AfricaAbidjan,
        parsed: &parsed::AfricaAbidjan,
    };

    /// Africa/Accra,
    pub static AfricaAccra: &DbTimeZone = AfricaAbidjan;

    /// Africa/Addis_Ababa,
    pub static AfricaAddisAbaba: &DbTimeZone = &DbTimeZone {
        index: 1,
        name: "Africa/Addis_Ababa",
        debug_name: "AfricaAddisAbaba",
        bytes: bytes::AfricaAddisAbaba,
        parsed: &parsed::AfricaAddisAbaba,
    };

    /// Africa/Algiers,
    pub static AfricaAlgiers: &DbTimeZone = &DbTimeZone {
        index: 2,
        name: "Africa/Algiers",
        debug_name: "AfricaAlgiers",
        bytes: bytes::AfricaAlgiers,
        parsed: &parsed::AfricaAlgiers,
    };

    /// Africa/Asmara,
    pub static AfricaAsmara: &DbTimeZone = AfricaAddisAbaba;

    /// Africa/Asmera,
    pub static AfricaAsmera: &DbTimeZone = AfricaAddisAbaba;

    /// Africa/Bamako,
    pub static AfricaBamako: &DbTimeZone = AfricaAbidjan;

    /// Africa/Bangui,
    pub static AfricaBangui: &DbTimeZone = &DbTimeZone {
        index: 3,
        name: "Africa/Bangui",
        debug_name: "AfricaBangui",
        bytes: bytes::AfricaBangui,
        parsed: &parsed::AfricaBangui,
    };

    /// Africa/Banjul,
    pub static AfricaBanjul: &DbTimeZone = AfricaAbidjan;

    /// Africa/Bissau,
    pub static AfricaBissau: &DbTimeZone = &DbTimeZone {
        index: 4,
        name: "Africa/Bissau",
        debug_name: "AfricaBissau",
        bytes: bytes::AfricaBissau,
        parsed: &parsed::AfricaBissau,
    };

    /// Africa/Blantyre,
    pub static AfricaBlantyre: &DbTimeZone = &DbTimeZone {
        index: 5,
        name: "Africa/Blantyre",
        debug_name: "AfricaBlantyre",
        bytes: bytes::AfricaBlantyre,
        parsed: &parsed::AfricaBlantyre,
    };

    /// Africa/Brazzaville,
    pub static AfricaBrazzaville: &DbTimeZone = AfricaBangui;

    /// Africa/Bujumbura,
    pub static AfricaBujumbura: &DbTimeZone = AfricaBlantyre;

    /// Africa/Cairo,
    pub static AfricaCairo: &DbTimeZone = &DbTimeZone {
        index: 6,
        name: "Africa/Cairo",
        debug_name: "AfricaCairo",
        bytes: bytes::AfricaCairo,
        parsed: &parsed::AfricaCairo,
    };

    /// Africa/Casablanca,
    pub static AfricaCasablanca: &DbTimeZone = &DbTimeZone {
        index: 7,
        name: "Africa/Casablanca",
        debug_name: "AfricaCasablanca",
        bytes: bytes::AfricaCasablanca,
        parsed: &parsed::AfricaCasablanca,
    };

    /// Africa/Ceuta,
    pub static AfricaCeuta: &DbTimeZone = &DbTimeZone {
        index: 8,
        name: "Africa/Ceuta",
        debug_name: "AfricaCeuta",
        bytes: bytes::AfricaCeuta,
        parsed: &parsed::AfricaCeuta,
    };

    /// Africa/Conakry,
    pub static AfricaConakry: &DbTimeZone = AfricaAbidjan;

    /// Africa/Dakar,
    pub static AfricaDakar: &DbTimeZone = AfricaAbidjan;

    /// Africa/Dar_es_Salaam,
    pub static AfricaDarEsSalaam: &DbTimeZone = AfricaAddisAbaba;

    /// Africa/Djibouti,
    pub static AfricaDjibouti: &DbTimeZone = AfricaAddisAbaba;

    /// Africa/Douala,
    pub static AfricaDouala: &DbTimeZone = AfricaBangui;

    /// Africa/El_Aaiun,
    pub static AfricaElAaiun: &DbTimeZone = &DbTimeZone {
        index: 9,
        name: "Africa/El_Aaiun",
        debug_name: "AfricaElAaiun",
        bytes: bytes::AfricaElAaiun,
        parsed: &parsed::AfricaElAaiun,
    };

    /// Africa/Freetown,
    pub static AfricaFreetown: &DbTimeZone = AfricaAbidjan;

    /// Africa/Gaborone,
    pub static AfricaGaborone: &DbTimeZone = AfricaBlantyre;

    /// Africa/Harare,
    pub static AfricaHarare: &DbTimeZone = AfricaBlantyre;

    /// Africa/Johannesburg,
    pub static AfricaJohannesburg: &DbTimeZone = &DbTimeZone {
        index: 10,
        name: "Africa/Johannesburg",
        debug_name: "AfricaJohannesburg",
        bytes: bytes::AfricaJohannesburg,
        parsed: &parsed::AfricaJohannesburg,
    };

    /// Africa/Juba,
    pub static AfricaJuba: &DbTimeZone = &DbTimeZone {
        index: 11,
        name: "Africa/Juba",
        debug_name: "AfricaJuba",
        bytes: bytes::AfricaJuba,
        parsed: &parsed::AfricaJuba,
    };

    /// Africa/Kampala,
    pub static AfricaKampala: &DbTimeZone = AfricaAddisAbaba;

    /// Africa/Khartoum,
    pub static AfricaKhartoum: &DbTimeZone = &DbTimeZone {
        index: 12,
        name: "Africa/Khartoum",
        debug_name: "AfricaKhartoum",
        bytes: bytes::AfricaKhartoum,
        parsed: &parsed::AfricaKhartoum,
    };

    /// Africa/Kigali,
    pub static AfricaKigali: &DbTimeZone = AfricaBlantyre;

    /// Africa/Kinshasa,
    pub static AfricaKinshasa: &DbTimeZone = AfricaBangui;

    /// Africa/Lagos,
    pub static AfricaLagos: &DbTimeZone = AfricaBangui;

    /// Africa/Libreville,
    pub static AfricaLibreville: &DbTimeZone = AfricaBangui;

    /// Africa/Lome,
    pub static AfricaLome: &DbTimeZone = AfricaAbidjan;

    /// Africa/Luanda,
    pub static AfricaLuanda: &DbTimeZone = AfricaBangui;

    /// Africa/Lubumbashi,
    pub static AfricaLubumbashi: &DbTimeZone = AfricaBlantyre;

    /// Africa/Lusaka,
    pub static AfricaLusaka: &DbTimeZone = AfricaBlantyre;

    /// Africa/Malabo,
    pub static AfricaMalabo: &DbTimeZone = AfricaBangui;

    /// Africa/Maputo,
    pub static AfricaMaputo: &DbTimeZone = AfricaBlantyre;

    /// Africa/Maseru,
    pub static AfricaMaseru: &DbTimeZone = AfricaJohannesburg;

    /// Africa/Mbabane,
    pub static AfricaMbabane: &DbTimeZone = AfricaJohannesburg;

    /// Africa/Mogadishu,
    pub static AfricaMogadishu: &DbTimeZone = AfricaAddisAbaba;

    /// Africa/Monrovia,
    pub static AfricaMonrovia: &DbTimeZone = &DbTimeZone {
        index: 13,
        name: "Africa/Monrovia",
        debug_name: "AfricaMonrovia",
        bytes: bytes::AfricaMonrovia,
        parsed: &parsed::AfricaMonrovia,
    };

    /// Africa/Nairobi,
    pub static AfricaNairobi: &DbTimeZone = AfricaAddisAbaba;

    /// Africa/Ndjamena,
    pub static AfricaNdjamena: &DbTimeZone = &DbTimeZone {
        index: 14,
        name: "Africa/Ndjamena",
        debug_name: "AfricaNdjamena",
        bytes: bytes::AfricaNdjamena,
        parsed: &parsed::AfricaNdjamena,
    };

    /// Africa/Niamey,
    pub static AfricaNiamey: &DbTimeZone = AfricaBangui;

    /// Africa/Nouakchott,
    pub static AfricaNouakchott: &DbTimeZone = AfricaAbidjan;

    /// Africa/Ouagadougou,
    pub static AfricaOuagadougou: &DbTimeZone = AfricaAbidjan;

    /// Africa/Porto-Novo,
    pub static AfricaPortoNovo: &DbTimeZone = AfricaBangui;

    /// Africa/Sao_Tome,
    pub static AfricaSaoTome: &DbTimeZone = &DbTimeZone {
        index: 15,
        name: "Africa/Sao_Tome",
        debug_name: "AfricaSaoTome",
        bytes: bytes::AfricaSaoTome,
        parsed: &parsed::AfricaSaoTome,
    };

    /// Africa/Timbuktu,
    pub static AfricaTimbuktu: &DbTimeZone = AfricaAbidjan;

    /// Africa/Tripoli,
    pub static AfricaTripoli: &DbTimeZone = &DbTimeZone {
        index: 16,
        name: "Africa/Tripoli",
        debug_name: "AfricaTripoli",
        bytes: bytes::AfricaTripoli,
        parsed: &parsed::AfricaTripoli,
    };

    /// Africa/Tunis,
    pub static AfricaTunis: &DbTimeZone = &DbTimeZone {
        index: 17,
        name: "Africa/Tunis",
        debug_name: "AfricaTunis",
        bytes: bytes::AfricaTunis,
        parsed: &parsed::AfricaTunis,
    };

    /// Africa/Windhoek,
    pub static AfricaWindhoek: &DbTimeZone = &DbTimeZone {
        index: 18,
        name: "Africa/Windhoek",
        debug_name: "AfricaWindhoek",
        bytes: bytes::AfricaWindhoek,
        parsed: &parsed::AfricaWindhoek,
    };

    /// America/Adak,
    pub static AmericaAdak: &DbTimeZone = &DbTimeZone {
        index: 19,
        name: "America/Adak",
        debug_name: "AmericaAdak",
        bytes: bytes::AmericaAdak,
        parsed: &parsed::AmericaAdak,
    };

    /// America/Anchorage,
    pub static AmericaAnchorage: &DbTimeZone = &DbTimeZone {
        index: 20,
        name: "America/Anchorage",
        debug_name: "AmericaAnchorage",
        bytes: bytes::AmericaAnchorage,
        parsed: &parsed::AmericaAnchorage,
    };

    /// America/Anguilla,
    pub static AmericaAnguilla: &DbTimeZone = &DbTimeZone {
        index: 21,
        name: "America/Anguilla",
        debug_name: "AmericaAnguilla",
        bytes: bytes::AmericaAnguilla,
        parsed: &parsed::AmericaAnguilla,
    };

    /// America/Antigua,
    pub static AmericaAntigua: &DbTimeZone = AmericaAnguilla;

    /// America/Araguaina,
    pub static AmericaAraguaina: &DbTimeZone = &DbTimeZone {
        index: 22,
        name: "America/Araguaina",
        debug_name: "AmericaAraguaina",
        bytes: bytes::AmericaAraguaina,
        parsed: &parsed::AmericaAraguaina,
    };

    /// America/Aruba,
    pub static AmericaAruba: &DbTimeZone = AmericaAnguilla;

    /// America/Asuncion,
    pub static AmericaAsuncion: &DbTimeZone = &DbTimeZone {
        index: 23,
        name: "America/Asuncion",
        debug_name: "AmericaAsuncion",
        bytes: bytes::AmericaAsuncion,
        parsed: &parsed::AmericaAsuncion,
    };

    /// America/Atikokan,
    pub static AmericaAtikokan: &DbTimeZone = &DbTimeZone {
        index: 24,
        name: "America/Atikokan",
        debug_name: "AmericaAtikokan",
        bytes: bytes::AmericaAtikokan,
        parsed: &parsed::AmericaAtikokan,
    };

    /// America/Atka,
    pub static AmericaAtka: &DbTimeZone = AmericaAdak;

    /// America/Bahia,
    pub static AmericaBahia: &DbTimeZone = &DbTimeZone {
        index: 25,
        name: "America/Bahia",
        debug_name: "AmericaBahia",
        bytes: bytes::AmericaBahia,
        parsed: &parsed::AmericaBahia,
    };

    /// America/Bahia_Banderas,
    pub static AmericaBahiaBanderas: &DbTimeZone = &DbTimeZone {
        index: 26,
        name: "America/Bahia_Banderas",
        debug_name: "AmericaBahiaBanderas",
        bytes: bytes::AmericaBahiaBanderas,
        parsed: &parsed::AmericaBahiaBanderas,
    };

    /// America/Barbados,
    pub static AmericaBarbados: &DbTimeZone = &DbTimeZone {
        index: 27,
        name: "America/Barbados",
        debug_name: "AmericaBarbados",
        bytes: bytes::AmericaBarbados,
        parsed: &parsed::AmericaBarbados,
    };

    /// America/Belem,
    pub static AmericaBelem: &DbTimeZone = &DbTimeZone {
        index: 28,
        name: "America/Belem",
        debug_name: "AmericaBelem",
        bytes: bytes::AmericaBelem,
        parsed: &parsed::AmericaBelem,
    };

    /// America/Belize,
    pub static AmericaBelize: &DbTimeZone = &DbTimeZone {
        index: 29,
        name: "America/Belize",
        debug_name: "AmericaBelize",
        bytes: bytes::AmericaBelize,
        parsed: &parsed::AmericaBelize,
    };

    /// America/Blanc-Sablon,
    pub static AmericaBlancSablon: &DbTimeZone = AmericaAnguilla;

    /// America/Boa_Vista,
    pub static AmericaBoaVista: &DbTimeZone = &DbTimeZone {
        index: 30,
        name: "America/Boa_Vista",
        debug_name: "AmericaBoaVista",
        bytes: bytes::AmericaBoaVista,
        parsed: &parsed::AmericaBoaVista,
    };

    /// America/Bogota,
    pub static AmericaBogota: &DbTimeZone = &DbTimeZone {
        index: 31,
        name: "America/Bogota",
        debug_name: "AmericaBogota",
        bytes: bytes::AmericaBogota,
        parsed: &parsed::AmericaBogota,
    };

    /// America/Boise,
    pub static AmericaBoise: &DbTimeZone = &DbTimeZone {
        index: 32,
        name: "America/Boise",
        debug_name: "AmericaBoise",
        bytes: bytes::AmericaBoise,
        parsed: &parsed::AmericaBoise,
    };

    /// America/Buenos_Aires,
    pub static AmericaBuenosAires: &DbTimeZone = &DbTimeZone {
        index: 33,
        name: "America/Buenos_Aires",
        debug_name: "AmericaBuenosAires",
        bytes: bytes::AmericaBuenosAires,
        parsed: &parsed::AmericaBuenosAires,
    };

    /// America/Cambridge_Bay,
    pub static AmericaCambridgeBay: &DbTimeZone = &DbTimeZone {
        index: 34,
        name: "America/Cambridge_Bay",
        debug_name: "AmericaCambridgeBay",
        bytes: bytes::AmericaCambridgeBay,
        parsed: &parsed::AmericaCambridgeBay,
    };

    /// America/Campo_Grande,
    pub static AmericaCampoGrande: &DbTimeZone = &DbTimeZone {
        index: 35,
        name: "America/Campo_Grande",
        debug_name: "AmericaCampoGrande",
        bytes: bytes::AmericaCampoGrande,
        parsed: &parsed::AmericaCampoGrande,
    };

    /// America/Cancun,
    pub static AmericaCancun: &DbTimeZone = &DbTimeZone {
        index: 36,
        name: "America/Cancun",
        debug_name: "AmericaCancun",
        bytes: bytes::AmericaCancun,
        parsed: &parsed::AmericaCancun,
    };

    /// America/Caracas,
    pub static AmericaCaracas: &DbTimeZone = &DbTimeZone {
        index: 37,
        name: "America/Caracas",
        debug_name: "AmericaCaracas",
        bytes: bytes::AmericaCaracas,
        parsed: &parsed::AmericaCaracas,
    };

    /// America/Catamarca,
    pub static AmericaCatamarca: &DbTimeZone = &DbTimeZone {
        index: 38,
        name: "America/Catamarca",
        debug_name: "AmericaCatamarca",
        bytes: bytes::AmericaCatamarca,
        parsed: &parsed::AmericaCatamarca,
    };

    /// America/Cayenne,
    pub static AmericaCayenne: &DbTimeZone = &DbTimeZone {
        index: 39,
        name: "America/Cayenne",
        debug_name: "AmericaCayenne",
        bytes: bytes::AmericaCayenne,
        parsed: &parsed::AmericaCayenne,
    };

    /// America/Cayman,
    pub static AmericaCayman: &DbTimeZone = AmericaAtikokan;

    /// America/Chicago,
    pub static AmericaChicago: &DbTimeZone = &DbTimeZone {
        index: 40,
        name: "America/Chicago",
        debug_name: "AmericaChicago",
        bytes: bytes::AmericaChicago,
        parsed: &parsed::AmericaChicago,
    };

    /// America/Chihuahua,
    pub static AmericaChihuahua: &DbTimeZone = &DbTimeZone {
        index: 41,
        name: "America/Chihuahua",
        debug_name: "AmericaChihuahua",
        bytes: bytes::AmericaChihuahua,
        parsed: &parsed::AmericaChihuahua,
    };

    /// America/Coral_Harbour,
    pub static AmericaCoralHarbour: &DbTimeZone = AmericaAtikokan;

    /// America/Cordoba,
    pub static AmericaCordoba: &DbTimeZone = &DbTimeZone {
        index: 42,
        name: "America/Cordoba",
        debug_name: "AmericaCordoba",
        bytes: bytes::AmericaCordoba,
        parsed: &parsed::AmericaCordoba,
    };

    /// America/Costa_Rica,
    pub static AmericaCostaRica: &DbTimeZone = &DbTimeZone {
        index: 43,
        name: "America/Costa_Rica",
        debug_name: "AmericaCostaRica",
        bytes: bytes::AmericaCostaRica,
        parsed: &parsed::AmericaCostaRica,
    };

    /// America/Creston,
    pub static AmericaCreston: &DbTimeZone = &DbTimeZone {
        index: 44,
        name: "America/Creston",
        debug_name: "AmericaCreston",
        bytes: bytes::AmericaCreston,
        parsed: &parsed::AmericaCreston,
    };

    /// America/Cuiaba,
    pub static AmericaCuiaba: &DbTimeZone = &DbTimeZone {
        index: 45,
        name: "America/Cuiaba",
        debug_name: "AmericaCuiaba",
        bytes: bytes::AmericaCuiaba,
        parsed: &parsed::AmericaCuiaba,
    };

    /// America/Curacao,
    pub static AmericaCuracao: &DbTimeZone = AmericaAnguilla;

    /// America/Danmarkshavn,
    pub static AmericaDanmarkshavn: &DbTimeZone = &DbTimeZone {
        index: 46,
        name: "America/Danmarkshavn",
        debug_name: "AmericaDanmarkshavn",
        bytes: bytes::AmericaDanmarkshavn,
        parsed: &parsed::AmericaDanmarkshavn,
    };

    /// America/Dawson,
    pub static AmericaDawson: &DbTimeZone = &DbTimeZone {
        index: 47,
        name: "America/Dawson",
        debug_name: "AmericaDawson",
        bytes: bytes::AmericaDawson,
        parsed: &parsed::AmericaDawson,
    };

    /// America/Dawson_Creek,
    pub static AmericaDawsonCreek: &DbTimeZone = &DbTimeZone {
        index: 48,
        name: "America/Dawson_Creek",
        debug_name: "AmericaDawsonCreek",
        bytes: bytes::AmericaDawsonCreek,
        parsed: &parsed::AmericaDawsonCreek,
    };

    /// America/Denver,
    pub static AmericaDenver: &DbTimeZone = &DbTimeZone {
        index: 49,
        name: "America/Denver",
        debug_name: "AmericaDenver",
        bytes: bytes::AmericaDenver,
        parsed: &parsed::AmericaDenver,
    };

    /// America/Detroit,
    pub static AmericaDetroit: &DbTimeZone = &DbTimeZone {
        index: 50,
        name: "America/Detroit",
        debug_name: "AmericaDetroit",
        bytes: bytes::AmericaDetroit,
        parsed: &parsed::AmericaDetroit,
    };

    /// America/Dominica,
    pub static AmericaDominica: &DbTimeZone = AmericaAnguilla;

    /// America/Edmonton,
    pub static AmericaEdmonton: &DbTimeZone = &DbTimeZone {
        index: 51,
        name: "America/Edmonton",
        debug_name: "AmericaEdmonton",
        bytes: bytes::AmericaEdmonton,
        parsed: &parsed::AmericaEdmonton,
    };

    /// America/Eirunepe,
    pub static AmericaEirunepe: &DbTimeZone = &DbTimeZone {
        index: 52,
        name: "America/Eirunepe",
        debug_name: "AmericaEirunepe",
        bytes: bytes::AmericaEirunepe,
        parsed: &parsed::AmericaEirunepe,
    };

    /// America/El_Salvador,
    pub static AmericaElSalvador: &DbTimeZone = &DbTimeZone {
        index: 53,
        name: "America/El_Salvador",
        debug_name: "AmericaElSalvador",
        bytes: bytes::AmericaElSalvador,
        parsed: &parsed::AmericaElSalvador,
    };

    /// America/Ensenada,
    pub static AmericaEnsenada: &DbTimeZone = &DbTimeZone {
        index: 54,
        name: "America/Ensenada",
        debug_name: "AmericaEnsenada",
        bytes: bytes::AmericaEnsenada,
        parsed: &parsed::AmericaEnsenada,
    };

    /// America/Fort_Nelson,
    pub static AmericaFortNelson: &DbTimeZone = &DbTimeZone {
        index: 55,
        name: "America/Fort_Nelson",
        debug_name: "AmericaFortNelson",
        bytes: bytes::AmericaFortNelson,
        parsed: &parsed::AmericaFortNelson,
    };

    /// America/Fort_Wayne,
    pub static AmericaFortWayne: &DbTimeZone = &DbTimeZone {
        index: 56,
        name: "America/Fort_Wayne",
        debug_name: "AmericaFortWayne",
        bytes: bytes::AmericaFortWayne,
        parsed: &parsed::AmericaFortWayne,
    };

    /// America/Fortaleza,
    pub static AmericaFortaleza: &DbTimeZone = &DbTimeZone {
        index: 57,
        name: "America/Fortaleza",
        debug_name: "AmericaFortaleza",
        bytes: bytes::AmericaFortaleza,
        parsed: &parsed::AmericaFortaleza,
    };

    /// America/Glace_Bay,
    pub static AmericaGlaceBay: &DbTimeZone = &DbTimeZone {
        index: 58,
        name: "America/Glace_Bay",
        debug_name: "AmericaGlaceBay",
        bytes: bytes::AmericaGlaceBay,
        parsed: &parsed::AmericaGlaceBay,
    };

    /// America/Godthab,
    pub static AmericaGodthab: &DbTimeZone = &DbTimeZone {
        index: 59,
        name: "America/Godthab",
        debug_name: "AmericaGodthab",
        bytes: bytes::AmericaGodthab,
        parsed: &parsed::AmericaGodthab,
    };

    /// America/Goose_Bay,
    pub static AmericaGooseBay: &DbTimeZone = &DbTimeZone {
        index: 60,
        name: "America/Goose_Bay",
        debug_name: "AmericaGooseBay",
        bytes: bytes::AmericaGooseBay,
        parsed: &parsed::AmericaGooseBay,
    };

    /// America/Grand_Turk,
    pub static AmericaGrandTurk: &DbTimeZone = &DbTimeZone {
        index: 61,
        name: "America/Grand_Turk",
        debug_name: "AmericaGrandTurk",
        bytes: bytes::AmericaGrandTurk,
        parsed: &parsed::AmericaGrandTurk,
    };

    /// America/Grenada,
    pub static AmericaGrenada: &DbTimeZone = AmericaAnguilla;

    /// America/Guadeloupe,
    pub static AmericaGuadeloupe: &DbTimeZone = AmericaAnguilla;

    /// America/Guatemala,
    pub static AmericaGuatemala: &DbTimeZone = &DbTimeZone {
        index: 62,
        name: "America/Guatemala",
        debug_name: "AmericaGuatemala",
        bytes: bytes::AmericaGuatemala,
        parsed: &parsed::AmericaGuatemala,
    };

    /// America/Guayaquil,
    pub static AmericaGuayaquil: &DbTimeZone = &DbTimeZone {
        index: 63,
        name: "America/Guayaquil",
        debug_name: "AmericaGuayaquil",
        bytes: bytes::AmericaGuayaquil,
        parsed: &parsed::AmericaGuayaquil,
    };

    /// America/Guyana,
    pub static AmericaGuyana: &DbTimeZone = &DbTimeZone {
        index: 64,
        name: "America/Guyana",
        debug_name: "AmericaGuyana",
        bytes: bytes::AmericaGuyana,
        parsed: &parsed::AmericaGuyana,
    };

    /// America/Halifax,
    pub static AmericaHalifax: &DbTimeZone = &DbTimeZone {
        index: 65,
        name: "America/Halifax",
        debug_name: "AmericaHalifax",
        bytes: bytes::AmericaHalifax,
        parsed: &parsed::AmericaHalifax,
    };

    /// America/Havana,
    pub static AmericaHavana: &DbTimeZone = &DbTimeZone {
        index: 66,
        name: "America/Havana",
        debug_name: "AmericaHavana",
        bytes: bytes::AmericaHavana,
        parsed: &parsed::AmericaHavana,
    };

    /// America/Hermosillo,
    pub static AmericaHermosillo: &DbTimeZone = &DbTimeZone {
        index: 67,
        name: "America/Hermosillo",
        debug_name: "AmericaHermosillo",
        bytes: bytes::AmericaHermosillo,
        parsed: &parsed::AmericaHermosillo,
    };

    /// America/Indianapolis,
    pub static AmericaIndianapolis: &DbTimeZone = AmericaFortWayne;

    /// America/Inuvik,
    pub static AmericaInuvik: &DbTimeZone = &DbTimeZone {
        index: 68,
        name: "America/Inuvik",
        debug_name: "AmericaInuvik",
        bytes: bytes::AmericaInuvik,
        parsed: &parsed::AmericaInuvik,
    };

    /// America/Iqaluit,
    pub static AmericaIqaluit: &DbTimeZone = &DbTimeZone {
        index: 69,
        name: "America/Iqaluit",
        debug_name: "AmericaIqaluit",
        bytes: bytes::AmericaIqaluit,
        parsed: &parsed::AmericaIqaluit,
    };

    /// America/Jamaica,
    pub static AmericaJamaica: &DbTimeZone = &DbTimeZone {
        index: 70,
        name: "America/Jamaica",
        debug_name: "AmericaJamaica",
        bytes: bytes::AmericaJamaica,
        parsed: &parsed::AmericaJamaica,
    };

    /// America/Jujuy,
    pub static AmericaJujuy: &DbTimeZone = &DbTimeZone {
        index: 71,
        name: "America/Jujuy",
        debug_name: "AmericaJujuy",
        bytes: bytes::AmericaJujuy,
        parsed: &parsed::AmericaJujuy,
    };

    /// America/Juneau,
    pub static AmericaJuneau: &DbTimeZone = &DbTimeZone {
        index: 72,
        name: "America/Juneau",
        debug_name: "AmericaJuneau",
        bytes: bytes::AmericaJuneau,
        parsed: &parsed::AmericaJuneau,
    };

    /// America/Knox_IN,
    pub static AmericaKnoxIn: &DbTimeZone = &DbTimeZone {
        index: 73,
        name: "America/Knox_IN",
        debug_name: "AmericaKnoxIn",
        bytes: bytes::AmericaKnoxIn,
        parsed: &parsed::AmericaKnoxIn,
    };

    /// America/Kralendijk,
    pub static AmericaKralendijk: &DbTimeZone = AmericaAnguilla;

    /// America/La_Paz,
    pub static AmericaLaPaz: &DbTimeZone = &DbTimeZone {
        index: 74,
        name: "America/La_Paz",
        debug_name: "AmericaLaPaz",
        bytes: bytes::AmericaLaPaz,
        parsed: &parsed::AmericaLaPaz,
    };

    /// America/Lima,
    pub static AmericaLima: &DbTimeZone = &DbTimeZone {
        index: 75,
        name: "America/Lima",
        debug_name: "AmericaLima",
        bytes: bytes::AmericaLima,
        parsed: &parsed::AmericaLima,
    };

    /// America/Los_Angeles,
    pub static AmericaLosAngeles: &DbTimeZone = &DbTimeZone {
        index: 76,
        name: "America/Los_Angeles",
        debug_name: "AmericaLosAngeles",
        bytes: bytes::AmericaLosAngeles,
        parsed: &parsed::AmericaLosAngeles,
    };

    /// America/Louisville,
    pub static AmericaLouisville: &DbTimeZone = &DbTimeZone {
        index: 77,
        name: "America/Louisville",
        debug_name: "AmericaLouisville",
        bytes: bytes::AmericaLouisville,
        parsed: &parsed::AmericaLouisville,
    };

    /// America/Lower_Princes,
    pub static AmericaLowerPrinces: &DbTimeZone = AmericaAnguilla;

    /// America/Maceio,
    pub static AmericaMaceio: &DbTimeZone = &DbTimeZone {
        index: 78,
        name: "America/Maceio",
        debug_name: "AmericaMaceio",
        bytes: bytes::AmericaMaceio,
        parsed: &parsed::AmericaMaceio,
    };

    /// America/Managua,
    pub static AmericaManagua: &DbTimeZone = &DbTimeZone {
        index: 79,
        name: "America/Managua",
        debug_name: "AmericaManagua",
        bytes: bytes::AmericaManagua,
        parsed: &parsed::AmericaManagua,
    };

    /// America/Manaus,
    pub static AmericaManaus: &DbTimeZone = &DbTimeZone {
        index: 80,
        name: "America/Manaus",
        debug_name: "AmericaManaus",
        bytes: bytes::AmericaManaus,
        parsed: &parsed::AmericaManaus,
    };

    /// America/Marigot,
    pub static AmericaMarigot: &DbTimeZone = AmericaAnguilla;

    /// America/Martinique,
    pub static AmericaMartinique: &DbTimeZone = &DbTimeZone {
        index: 81,
        name: "America/Martinique",
        debug_name: "AmericaMartinique",
        bytes: bytes::AmericaMartinique,
        parsed: &parsed::AmericaMartinique,
    };

    /// America/Matamoros,
    pub static AmericaMatamoros: &DbTimeZone = &DbTimeZone {
        index: 82,
        name: "America/Matamoros",
        debug_name: "AmericaMatamoros",
        bytes: bytes::AmericaMatamoros,
        parsed: &parsed::AmericaMatamoros,
    };

    /// America/Mazatlan,
    pub static AmericaMazatlan: &DbTimeZone = &DbTimeZone {
        index: 83,
        name: "America/Mazatlan",
        debug_name: "AmericaMazatlan",
        bytes: bytes::AmericaMazatlan,
        parsed: &parsed::AmericaMazatlan,
    };

    /// America/Mendoza,
    pub static AmericaMendoza: &DbTimeZone = &DbTimeZone {
        index: 84,
        name: "America/Mendoza",
        debug_name: "AmericaMendoza",
        bytes: bytes::AmericaMendoza,
        parsed: &parsed::AmericaMendoza,
    };

    /// America/Menominee,
    pub static AmericaMenominee: &DbTimeZone = &DbTimeZone {
        index: 85,
        name: "America/Menominee",
        debug_name: "AmericaMenominee",
        bytes: bytes::AmericaMenominee,
        parsed: &parsed::AmericaMenominee,
    };

    /// America/Merida,
    pub static AmericaMerida: &DbTimeZone = &DbTimeZone {
        index: 86,
        name: "America/Merida",
        debug_name: "AmericaMerida",
        bytes: bytes::AmericaMerida,
        parsed: &parsed::AmericaMerida,
    };

    /// America/Metlakatla,
    pub static AmericaMetlakatla: &DbTimeZone = &DbTimeZone {
        index: 87,
        name: "America/Metlakatla",
        debug_name: "AmericaMetlakatla",
        bytes: bytes::AmericaMetlakatla,
        parsed: &parsed::AmericaMetlakatla,
    };

    /// America/Mexico_City,
    pub static AmericaMexicoCity: &DbTimeZone = &DbTimeZone {
        index: 88,
        name: "America/Mexico_City",
        debug_name: "AmericaMexicoCity",
        bytes: bytes::AmericaMexicoCity,
        parsed: &parsed::AmericaMexicoCity,
    };

    /// America/Miquelon,
    pub static AmericaMiquelon: &DbTimeZone = &DbTimeZone {
        index: 89,
        name: "America/Miquelon",
        debug_name: "AmericaMiquelon",
        bytes: bytes::AmericaMiquelon,
        parsed: &parsed::AmericaMiquelon,
    };

    /// America/Moncton,
    pub static AmericaMoncton: &DbTimeZone = &DbTimeZone {
        index: 90,
        name: "America/Moncton",
        debug_name: "AmericaMoncton",
        bytes: bytes::AmericaMoncton,
        parsed: &parsed::AmericaMoncton,
    };

    /// America/Monterrey,
    pub static AmericaMonterrey: &DbTimeZone = &DbTimeZone {
        index: 91,
        name: "America/Monterrey",
        debug_name: "AmericaMonterrey",
        bytes: bytes::AmericaMonterrey,
        parsed: &parsed::AmericaMonterrey,
    };

    /// America/Montevideo,
    pub static AmericaMontevideo: &DbTimeZone = &DbTimeZone {
        index: 92,
        name: "America/Montevideo",
        debug_name: "AmericaMontevideo",
        bytes: bytes::AmericaMontevideo,
        parsed: &parsed::AmericaMontevideo,
    };

    /// America/Montreal,
    pub static AmericaMontreal: &DbTimeZone = &DbTimeZone {
        index: 93,
        name: "America/Montreal",
        debug_name: "AmericaMontreal",
        bytes: bytes::AmericaMontreal,
        parsed: &parsed::AmericaMontreal,
    };

    /// America/Montserrat,
    pub static AmericaMontserrat: &DbTimeZone = AmericaAnguilla;

    /// America/Nassau,
    pub static AmericaNassau: &DbTimeZone = AmericaMontreal;

    /// America/New_York,
    pub static AmericaNewYork: &DbTimeZone = &DbTimeZone {
        index: 94,
        name: "America/New_York",
        debug_name: "AmericaNewYork",
        bytes: bytes::AmericaNewYork,
        parsed: &parsed::AmericaNewYork,
    };

    /// America/Nipigon,
    pub static AmericaNipigon: &DbTimeZone = &DbTimeZone {
        index: 95,
        name: "America/Nipigon",
        debug_name: "AmericaNipigon",
        bytes: bytes::AmericaNipigon,
        parsed: &parsed::AmericaNipigon,
    };

    /// America/Nome,
    pub static AmericaNome: &DbTimeZone = &DbTimeZone {
        index: 96,
        name: "America/Nome",
        debug_name: "AmericaNome",
        bytes: bytes::AmericaNome,
        parsed: &parsed::AmericaNome,
    };

    /// America/Noronha,
    pub static AmericaNoronha: &DbTimeZone = &DbTimeZone {
        index: 97,
        name: "America/Noronha",
        debug_name: "AmericaNoronha",
        bytes: bytes::AmericaNoronha,
        parsed: &parsed::AmericaNoronha,
    };

    /// America/Nuuk,
    pub static AmericaNuuk: &DbTimeZone = AmericaGodthab;

    /// America/Ojinaga,
    pub static AmericaOjinaga: &DbTimeZone = &DbTimeZone {
        index: 98,
        name: "America/Ojinaga",
        debug_name: "AmericaOjinaga",
        bytes: bytes::AmericaOjinaga,
        parsed: &parsed::AmericaOjinaga,
    };

    /// America/Panama,
    pub static AmericaPanama: &DbTimeZone = AmericaAtikokan;

    /// America/Pangnirtung,
    pub static AmericaPangnirtung: &DbTimeZone = &DbTimeZone {
        index: 99,
        name: "America/Pangnirtung",
        debug_name: "AmericaPangnirtung",
        bytes: bytes::AmericaPangnirtung,
        parsed: &parsed::AmericaPangnirtung,
    };

    /// America/Paramaribo,
    pub static AmericaParamaribo: &DbTimeZone = &DbTimeZone {
        index: 100,
        name: "America/Paramaribo",
        debug_name: "AmericaParamaribo",
        bytes: bytes::AmericaParamaribo,
        parsed: &parsed::AmericaParamaribo,
    };

    /// America/Phoenix,
    pub static AmericaPhoenix: &DbTimeZone = AmericaCreston;

    /// America/Port-au-Prince,
    pub static AmericaPortAuPrince: &DbTimeZone = &DbTimeZone {
        index: 101,
        name: "America/Port-au-Prince",
        debug_name: "AmericaPortAuPrince",
        bytes: bytes::AmericaPortAuPrince,
        parsed: &parsed::AmericaPortAuPrince,
    };

    /// America/Port_of_Spain,
    pub static AmericaPortOfSpain: &DbTimeZone = AmericaAnguilla;

    /// America/Porto_Acre,
    pub static AmericaPortoAcre: &DbTimeZone = &DbTimeZone {
        index: 102,
        name: "America/Porto_Acre",
        debug_name: "AmericaPortoAcre",
        bytes: bytes::AmericaPortoAcre,
        parsed: &parsed::AmericaPortoAcre,
    };

    /// America/Porto_Velho,
    pub static AmericaPortoVelho: &DbTimeZone = &DbTimeZone {
        index: 103,
        name: "America/Porto_Velho",
        debug_name: "AmericaPortoVelho",
        bytes: bytes::AmericaPortoVelho,
        parsed: &parsed::AmericaPortoVelho,
    };

    /// America/Puerto_Rico,
    pub static AmericaPuertoRico: &DbTimeZone = AmericaAnguilla;

    /// America/Punta_Arenas,
    pub static AmericaPuntaArenas: &DbTimeZone = &DbTimeZone {
        index: 104,
        name: "America/Punta_Arenas",
        debug_name: "AmericaPuntaArenas",
        bytes: bytes::AmericaPuntaArenas,
        parsed: &parsed::AmericaPuntaArenas,
    };

    /// America/Rainy_River,
    pub static AmericaRainyRiver: &DbTimeZone = &DbTimeZone {
        index: 105,
        name: "America/Rainy_River",
        debug_name: "AmericaRainyRiver",
        bytes: bytes::AmericaRainyRiver,
        parsed: &parsed::AmericaRainyRiver,
    };

    /// America/Rankin_Inlet,
    pub static AmericaRankinInlet: &DbTimeZone = &DbTimeZone {
        index: 106,
        name: "America/Rankin_Inlet",
        debug_name: "AmericaRankinInlet",
        bytes: bytes::AmericaRankinInlet,
        parsed: &parsed::AmericaRankinInlet,
    };

    /// America/Recife,
    pub static AmericaRecife: &DbTimeZone = &DbTimeZone {
        index: 107,
        name: "America/Recife",
        debug_name: "AmericaRecife",
        bytes: bytes::AmericaRecife,
        parsed: &parsed::AmericaRecife,
    };

    /// America/Regina,
    pub static AmericaRegina: &DbTimeZone = &DbTimeZone {
        index: 108,
        name: "America/Regina",
        debug_name: "AmericaRegina",
        bytes: bytes::AmericaRegina,
        parsed: &parsed::AmericaRegina,
    };

    /// America/Resolute,
    pub static AmericaResolute: &DbTimeZone = &DbTimeZone {
        index: 109,
        name: "America/Resolute",
        debug_name: "AmericaResolute",
        bytes: bytes::AmericaResolute,
        parsed: &parsed::AmericaResolute,
    };

    /// America/Rio_Branco,
    pub static AmericaRioBranco: &DbTimeZone = AmericaPortoAcre;

    /// America/Rosario,
    pub static AmericaRosario: &DbTimeZone = AmericaCordoba;

    /// America/Santa_Isabel,
    pub static AmericaSantaIsabel: &DbTimeZone = AmericaEnsenada;

    /// America/Santarem,
    pub static AmericaSantarem: &DbTimeZone = &DbTimeZone {
        index: 110,
        name: "America/Santarem",
        debug_name: "AmericaSantarem",
        bytes: bytes::AmericaSantarem,
        parsed: &parsed::AmericaSantarem,
    };

    /// America/Santiago,
    pub static AmericaSantiago: &DbTimeZone = &DbTimeZone {
        index: 111,
        name: "America/Santiago",
        debug_name: "AmericaSantiago",
        bytes: bytes::AmericaSantiago,
        parsed: &parsed::AmericaSantiago,
    };

    /// America/Santo_Domingo,
    pub static AmericaSantoDomingo: &DbTimeZone = &DbTimeZone {
        index: 112,
        name: "America/Santo_Domingo",
        debug_name: "AmericaSantoDomingo",
        bytes: bytes::AmericaSantoDomingo,
        parsed: &parsed::AmericaSantoDomingo,
    };

    /// America/Sao_Paulo,
    pub static AmericaSaoPaulo: &DbTimeZone = &DbTimeZone {
        index: 113,
        name: "America/Sao_Paulo",
        debug_name: "AmericaSaoPaulo",
        bytes: bytes::AmericaSaoPaulo,
        parsed: &parsed::AmericaSaoPaulo,
    };

    /// America/Scoresbysund,
    pub static AmericaScoresbysund: &DbTimeZone = &DbTimeZone {
        index: 114,
        name: "America/Scoresbysund",
        debug_name: "AmericaScoresbysund",
        bytes: bytes::AmericaScoresbysund,
        parsed: &parsed::AmericaScoresbysund,
    };

    /// America/Shiprock,
    pub static AmericaShiprock: &DbTimeZone = AmericaDenver;

    /// America/Sitka,
    pub static AmericaSitka: &DbTimeZone = &DbTimeZone {
        index: 115,
        name: "America/Sitka",
        debug_name: "AmericaSitka",
        bytes: bytes::AmericaSitka,
        parsed: &parsed::AmericaSitka,
    };

    /// America/St_Barthelemy,
    pub static AmericaStBarthelemy: &DbTimeZone = AmericaAnguilla;

    /// America/St_Johns,
    pub static AmericaStJohns: &DbTimeZone = &DbTimeZone {
        index: 116,
        name: "America/St_Johns",
        debug_name: "AmericaStJohns",
        bytes: bytes::AmericaStJohns,
        parsed: &parsed::AmericaStJohns,
    };

    /// America/St_Kitts,
    pub static AmericaStKitts: &DbTimeZone = AmericaAnguilla;

    /// America/St_Lucia,
    pub static AmericaStLucia: &DbTimeZone = AmericaAnguilla;

    /// America/St_Thomas,
    pub static AmericaStThomas: &DbTimeZone = AmericaAnguilla;

    /// America/St_Vincent,
    pub static AmericaStVincent: &DbTimeZone = AmericaAnguilla;

    /// America/Swift_Current,
    pub static AmericaSwiftCurrent: &DbTimeZone = &DbTimeZone {
        index: 117,
        name: "America/Swift_Current",
        debug_name: "AmericaSwiftCurrent",
        bytes: bytes::AmericaSwiftCurrent,
        parsed: &parsed::AmericaSwiftCurrent,
    };

    /// America/Tegucigalpa,
    pub static AmericaTegucigalpa: &DbTimeZone = &DbTimeZone {
        index: 118,
        name: "America/Tegucigalpa",
        debug_name: "AmericaTegucigalpa",
        bytes: bytes::AmericaTegucigalpa,
        parsed: &parsed::AmericaTegucigalpa,
    };

    /// America/Thule,
    pub static AmericaThule: &DbTimeZone = &DbTimeZone {
        index: 119,
        name: "America/Thule",
        debug_name: "AmericaThule",
        bytes: bytes::AmericaThule,
        parsed: &parsed::AmericaThule,
    };

    /// America/Thunder_Bay,
    pub static AmericaThunderBay: &DbTimeZone = &DbTimeZone {
        index: 120,
        name: "America/Thunder_Bay",
        debug_name: "AmericaThunderBay",
        bytes: bytes::AmericaThunderBay,
        parsed: &parsed::AmericaThunderBay,
    };

    /// America/Tijuana,
    pub static AmericaTijuana: &DbTimeZone = AmericaEnsenada;

    /// America/Toronto,
    pub static AmericaToronto: &DbTimeZone = AmericaMontreal;

    /// America/Tortola,
    pub static AmericaTortola: &DbTimeZone = AmericaAnguilla;

    /// America/Vancouver,
    pub static AmericaVancouver: &DbTimeZone = &DbTimeZone {
        index: 121,
        name: "America/Vancouver",
        debug_name: "AmericaVancouver",
        bytes: bytes::AmericaVancouver,
        parsed: &parsed::AmericaVancouver,
    };

    /// America/Virgin,
    pub static AmericaVirgin: &DbTimeZone = AmericaAnguilla;

    /// America/Whitehorse,
    pub static AmericaWhitehorse: &DbTimeZone = &DbTimeZone {
        index: 122,
        name: "America/Whitehorse",
        debug_name: "AmericaWhitehorse",
        bytes: bytes::AmericaWhitehorse,
        parsed: &parsed::AmericaWhitehorse,
    };

    /// America/Winnipeg,
    pub static AmericaWinnipeg: &DbTimeZone = &DbTimeZone {
        index: 123,
        name: "America/Winnipeg",
        debug_name: "AmericaWinnipeg",
        bytes: bytes::AmericaWinnipeg,
        parsed: &parsed::AmericaWinnipeg,
    };

    /// America/Yakutat,
    pub static AmericaYakutat: &DbTimeZone = &DbTimeZone {
        index: 124,
        name: "America/Yakutat",
        debug_name: "AmericaYakutat",
        bytes: bytes::AmericaYakutat,
        parsed: &parsed::AmericaYakutat,
    };

    /// America/Yellowknife,
    pub static AmericaYellowknife: &DbTimeZone = &DbTimeZone {
        index: 125,
        name: "America/Yellowknife",
        debug_name: "AmericaYellowknife",
        bytes: bytes::AmericaYellowknife,
        parsed: &parsed::AmericaYellowknife,
    };

    /// Antarctica/Casey,
    pub static AntarcticaCasey: &DbTimeZone = &DbTimeZone {
        index: 126,
        name: "Antarctica/Casey",
        debug_name: "AntarcticaCasey",
        bytes: bytes::AntarcticaCasey,
        parsed: &parsed::AntarcticaCasey,
    };

    /// Antarctica/Davis,
    pub static AntarcticaDavis: &DbTimeZone = &DbTimeZone {
        index: 127,
        name: "Antarctica/Davis",
        debug_name: "AntarcticaDavis",
        bytes: bytes::AntarcticaDavis,
        parsed: &parsed::AntarcticaDavis,
    };

    /// Antarctica/DumontDUrville,
    pub static AntarcticaDumontDUrville: &DbTimeZone = &DbTimeZone {
        index: 128,
        name: "Antarctica/DumontDUrville",
        debug_name: "AntarcticaDumontDUrville",
        bytes: bytes::AntarcticaDumontDUrville,
        parsed: &parsed::AntarcticaDumontDUrville,
    };

    /// Antarctica/Macquarie,
    pub static AntarcticaMacquarie: &DbTimeZone = &DbTimeZone {
        index: 129,
        name: "Antarctica/Macquarie",
        debug_name: "AntarcticaMacquarie",
        bytes: bytes::AntarcticaMacquarie,
        parsed: &parsed::AntarcticaMacquarie,
    };

    /// Antarctica/Mawson,
    pub static AntarcticaMawson: &DbTimeZone = &DbTimeZone {
        index: 130,
        name: "Antarctica/Mawson",
        debug_name: "AntarcticaMawson",
        bytes: bytes::AntarcticaMawson,
        parsed: &parsed::AntarcticaMawson,
    };

    /// Antarctica/McMurdo,
    pub static AntarcticaMcMurdo: &DbTimeZone = &DbTimeZone {
        index: 131,
        name: "Antarctica/McMurdo",
        debug_name: "AntarcticaMcMurdo",
        bytes: bytes::AntarcticaMcMurdo,
        parsed: &parsed::AntarcticaMcMurdo,
    };

    /// Antarctica/Palmer,
    pub static AntarcticaPalmer: &DbTimeZone = &DbTimeZone {
        index: 132,
        name: "Antarctica/Palmer",
        debug_name: "AntarcticaPalmer",
        bytes: bytes::AntarcticaPalmer,
        parsed: &parsed::AntarcticaPalmer,
    };

    /// Antarctica/Rothera,
    pub static AntarcticaRothera: &DbTimeZone = &DbTimeZone {
        index: 133,
        name: "Antarctica/Rothera",
        debug_name: "AntarcticaRothera",
        bytes: bytes::AntarcticaRothera,
        parsed: &parsed::AntarcticaRothera,
    };

    /// Antarctica/South_Pole,
    pub static AntarcticaSouthPole: &DbTimeZone = AntarcticaMcMurdo;

    /// Antarctica/Syowa,
    pub static AntarcticaSyowa: &DbTimeZone = &DbTimeZone {
        index: 134,
        name: "Antarctica/Syowa",
        debug_name: "AntarcticaSyowa",
        bytes: bytes::AntarcticaSyowa,
        parsed: &parsed::AntarcticaSyowa,
    };

    /// Antarctica/Troll,
    pub static AntarcticaTroll: &DbTimeZone = &DbTimeZone {
        index: 135,
        name: "Antarctica/Troll",
        debug_name: "AntarcticaTroll",
        bytes: bytes::AntarcticaTroll,
        parsed: &parsed::AntarcticaTroll,
    };

    /// Antarctica/Vostok,
    pub static AntarcticaVostok: &DbTimeZone = &DbTimeZone {
        index: 136,
        name: "Antarctica/Vostok",
        debug_name: "AntarcticaVostok",
        bytes: bytes::AntarcticaVostok,
        parsed: &parsed::AntarcticaVostok,
    };

    /// Arctic/Longyearbyen,
    pub static ArcticLongyearbyen: &DbTimeZone = &DbTimeZone {
        index: 137,
        name: "Arctic/Longyearbyen",
        debug_name: "ArcticLongyearbyen",
        bytes: bytes::ArcticLongyearbyen,
        parsed: &parsed::ArcticLongyearbyen,
    };

    /// Asia/Aden,
    pub static AsiaAden: &DbTimeZone = AntarcticaSyowa;

    /// Asia/Almaty,
    pub static AsiaAlmaty: &DbTimeZone = &DbTimeZone {
        index: 138,
        name: "Asia/Almaty",
        debug_name: "AsiaAlmaty",
        bytes: bytes::AsiaAlmaty,
        parsed: &parsed::AsiaAlmaty,
    };

    /// Asia/Amman,
    pub static AsiaAmman: &DbTimeZone = &DbTimeZone {
        index: 139,
        name: "Asia/Amman",
        debug_name: "AsiaAmman",
        bytes: bytes::AsiaAmman,
        parsed: &parsed::AsiaAmman,
    };

    /// Asia/Anadyr,
    pub static AsiaAnadyr: &DbTimeZone = &DbTimeZone {
        index: 140,
        name: "Asia/Anadyr",
        debug_name: "AsiaAnadyr",
        bytes: bytes::AsiaAnadyr,
        parsed: &parsed::AsiaAnadyr,
    };

    /// Asia/Aqtau,
    pub static AsiaAqtau: &DbTimeZone = &DbTimeZone {
        index: 141,
        name: "Asia/Aqtau",
        debug_name: "AsiaAqtau",
        bytes: bytes::AsiaAqtau,
        parsed: &parsed::AsiaAqtau,
    };

    /// Asia/Aqtobe,
    pub static AsiaAqtobe: &DbTimeZone = &DbTimeZone {
        index: 142,
        name: "Asia/Aqtobe",
        debug_name: "AsiaAqtobe",
        bytes: bytes::AsiaAqtobe,
        parsed: &parsed::AsiaAqtobe,
    };

    /// Asia/Ashgabat,
    pub static AsiaAshgabat: &DbTimeZone = &DbTimeZone {
        index: 143,
        name: "Asia/Ashgabat",
        debug_name: "AsiaAshgabat",
        bytes: bytes::AsiaAshgabat,
        parsed: &parsed::AsiaAshgabat,
    };

    /// Asia/Ashkhabad,
    pub static AsiaAshkhabad: &DbTimeZone = AsiaAshgabat;

    /// Asia/Atyrau,
    pub static AsiaAtyrau: &DbTimeZone = &DbTimeZone {
        index: 144,
        name: "Asia/Atyrau",
        debug_name: "AsiaAtyrau",
        bytes: bytes::AsiaAtyrau,
        parsed: &parsed::AsiaAtyrau,
    };

    /// Asia/Baghdad,
    pub static AsiaBaghdad: &DbTimeZone = &DbTimeZone {
        index: 145,
        name: "Asia/Baghdad",
        debug_name: "AsiaBaghdad",
        bytes: bytes::AsiaBaghdad,
        parsed: &parsed::AsiaBaghdad,
    };

    /// Asia/Bahrain,
    pub static AsiaBahrain: &DbTimeZone = &DbTimeZone {
        index: 146,
        name: "Asia/Bahrain",
        debug_name: "AsiaBahrain",
        bytes: bytes::AsiaBahrain,
        parsed: &parsed::AsiaBahrain,
    };

    /// Asia/Baku,
    pub static AsiaBaku: &DbTimeZone = &DbTimeZone {
        index: 147,
        name: "Asia/Baku",
        debug_name: "AsiaBaku",
        bytes: bytes::AsiaBaku,
        parsed: &parsed::AsiaBaku,
    };

    /// Asia/Bangkok,
    pub static AsiaBangkok: &DbTimeZone = &DbTimeZone {
        index: 148,
        name: "Asia/Bangkok",
        debug_name: "AsiaBangkok",
        bytes: bytes::AsiaBangkok,
        parsed: &parsed::AsiaBangkok,
    };

    /// Asia/Barnaul,
    pub static AsiaBarnaul: &DbTimeZone = &DbTimeZone {
        index: 149,
        name: "Asia/Barnaul",
        debug_name: "AsiaBarnaul",
        bytes: bytes::AsiaBarnaul,
        parsed: &parsed::AsiaBarnaul,
    };

    /// Asia/Beirut,
    pub static AsiaBeirut: &DbTimeZone = &DbTimeZone {
        index: 150,
        name: "Asia/Beirut",
        debug_name: "AsiaBeirut",
        bytes: bytes::AsiaBeirut,
        parsed: &parsed::AsiaBeirut,
    };

    /// Asia/Bishkek,
    pub static AsiaBishkek: &DbTimeZone = &DbTimeZone {
        index: 151,
        name: "Asia/Bishkek",
        debug_name: "AsiaBishkek",
        bytes: bytes::AsiaBishkek,
        parsed: &parsed::AsiaBishkek,
    };

    /// Asia/Brunei,
    pub static AsiaBrunei: &DbTimeZone = &DbTimeZone {
        index: 152,
        name: "Asia/Brunei",
        debug_name: "AsiaBrunei",
        bytes: bytes::AsiaBrunei,
        parsed: &parsed::AsiaBrunei,
    };

    /// Asia/Calcutta,
    pub static AsiaCalcutta: &DbTimeZone = &DbTimeZone {
        index: 153,
        name: "Asia/Calcutta",
        debug_name: "AsiaCalcutta",
        bytes: bytes::AsiaCalcutta,
        parsed: &parsed::AsiaCalcutta,
    };

    /// Asia/Chita,
    pub static AsiaChita: &DbTimeZone = &DbTimeZone {
        index: 154,
        name: "Asia/Chita",
        debug_name: "AsiaChita",
        bytes: bytes::AsiaChita,
        parsed: &parsed::AsiaChita,
    };

    /// Asia/Choibalsan,
    pub static AsiaChoibalsan: &DbTimeZone = &DbTimeZone {
        index: 155,
        name: "Asia/Choibalsan",
        debug_name: "AsiaChoibalsan",
        bytes: bytes::AsiaChoibalsan,
        parsed: &parsed::AsiaChoibalsan,
    };

    /// Asia/Chongqing,
    pub static AsiaChongqing: &DbTimeZone = &DbTimeZone {
        index: 156,
        name: "Asia/Chongqing",
        debug_name: "AsiaChongqing",
        bytes: bytes::AsiaChongqing,
        parsed: &parsed::AsiaChongqing,
    };

    /// Asia/Chungking,
    pub static AsiaChungking: &DbTimeZone = AsiaChongqing;

    /// Asia/Colombo,
    pub static AsiaColombo: &DbTimeZone = &DbTimeZone {
        index: 157,
        name: "Asia/Colombo",
        debug_name: "AsiaColombo",
        bytes: bytes::AsiaColombo,
        parsed: &parsed::AsiaColombo,
    };

    /// Asia/Dacca,
    pub static AsiaDacca: &DbTimeZone = &DbTimeZone {
        index: 158,
        name: "Asia/Dacca",
        debug_name: "AsiaDacca",
        bytes: bytes::AsiaDacca,
        parsed: &parsed::AsiaDacca,
    };

    /// Asia/Damascus,
    pub static AsiaDamascus: &DbTimeZone = &DbTimeZone {
        index: 159,
        name: "Asia/Damascus",
        debug_name: "AsiaDamascus",
        bytes: bytes::AsiaDamascus,
        parsed: &parsed::AsiaDamascus,
    };

    /// Asia/Dhaka,
    pub static AsiaDhaka: &DbTimeZone = AsiaDacca;

    /// Asia/Dili,
    pub static AsiaDili: &DbTimeZone = &DbTimeZone {
        index: 160,
        name: "Asia/Dili",
        debug_name: "AsiaDili",
        bytes: bytes::AsiaDili,
        parsed: &parsed::AsiaDili,
    };

    /// Asia/Dubai,
    pub static AsiaDubai: &DbTimeZone = &DbTimeZone {
        index: 161,
        name: "Asia/Dubai",
        debug_name: "AsiaDubai",
        bytes: bytes::AsiaDubai,
        parsed: &parsed::AsiaDubai,
    };

    /// Asia/Dushanbe,
    pub static AsiaDushanbe: &DbTimeZone = &DbTimeZone {
        index: 162,
        name: "Asia/Dushanbe",
        debug_name: "AsiaDushanbe",
        bytes: bytes::AsiaDushanbe,
        parsed: &parsed::AsiaDushanbe,
    };

    /// Asia/Famagusta,
    pub static AsiaFamagusta: &DbTimeZone = &DbTimeZone {
        index: 163,
        name: "Asia/Famagusta",
        debug_name: "AsiaFamagusta",
        bytes: bytes::AsiaFamagusta,
        parsed: &parsed::AsiaFamagusta,
    };

    /// Asia/Gaza,
    pub static AsiaGaza: &DbTimeZone = &DbTimeZone {
        index: 164,
        name: "Asia/Gaza",
        debug_name: "AsiaGaza",
        bytes: bytes::AsiaGaza,
        parsed: &parsed::AsiaGaza,
    };

    /// Asia/Harbin,
    pub static AsiaHarbin: &DbTimeZone = AsiaChongqing;

    /// Asia/Hebron,
    pub static AsiaHebron: &DbTimeZone = &DbTimeZone {
        index: 165,
        name: "Asia/Hebron",
        debug_name: "AsiaHebron",
        bytes: bytes::AsiaHebron,
        parsed: &parsed::AsiaHebron,
    };

    /// Asia/Ho_Chi_Minh,
    pub static AsiaHoChiMinh: &DbTimeZone = &DbTimeZone {
        index: 166,
        name: "Asia/Ho_Chi_Minh",
        debug_name: "AsiaHoChiMinh",
        bytes: bytes::AsiaHoChiMinh,
        parsed: &parsed::AsiaHoChiMinh,
    };

    /// Asia/Hong_Kong,
    pub static AsiaHongKong: &DbTimeZone = &DbTimeZone {
        index: 167,
        name: "Asia/Hong_Kong",
        debug_name: "AsiaHongKong",
        bytes: bytes::AsiaHongKong,
        parsed: &parsed::AsiaHongKong,
    };

    /// Asia/Hovd,
    pub static AsiaHovd: &DbTimeZone = &DbTimeZone {
        index: 168,
        name: "Asia/Hovd",
        debug_name: "AsiaHovd",
        bytes: bytes::AsiaHovd,
        parsed: &parsed::AsiaHovd,
    };

    /// Asia/Irkutsk,
    pub static AsiaIrkutsk: &DbTimeZone = &DbTimeZone {
        index: 169,
        name: "Asia/Irkutsk",
        debug_name: "AsiaIrkutsk",
        bytes: bytes::AsiaIrkutsk,
        parsed: &parsed::AsiaIrkutsk,
    };

    /// Asia/Istanbul,
    pub static AsiaIstanbul: &DbTimeZone = &DbTimeZone {
        index: 170,
        name: "Asia/Istanbul",
        debug_name: "AsiaIstanbul",
        bytes: bytes::AsiaIstanbul,
        parsed: &parsed::AsiaIstanbul,
    };

    /// Asia/Jakarta,
    pub static AsiaJakarta: &DbTimeZone = &DbTimeZone {
        index: 171,
        name: "Asia/Jakarta",
        debug_name: "AsiaJakarta",
        bytes: bytes::AsiaJakarta,
        parsed: &parsed::AsiaJakarta,
    };

    /// Asia/Jayapura,
    pub static AsiaJayapura: &DbTimeZone = &DbTimeZone {
        index: 172,
        name: "Asia/Jayapura",
        debug_name: "AsiaJayapura",
        bytes: bytes::AsiaJayapura,
        parsed: &parsed::AsiaJayapura,
    };

    /// Asia/Jerusalem,
    pub static AsiaJerusalem: &DbTimeZone = &DbTimeZone {
        index: 173,
        name: "Asia/Jerusalem",
        debug_name: "AsiaJerusalem",
        bytes: bytes::AsiaJerusalem,
        parsed: &parsed::AsiaJerusalem,
    };

    /// Asia/Kabul,
    pub static AsiaKabul: &DbTimeZone = &DbTimeZone {
        index: 174,
        name: "Asia/Kabul",
        debug_name: "AsiaKabul",
        bytes: bytes::AsiaKabul,
        parsed: &parsed::AsiaKabul,
    };

    /// Asia/Kamchatka,
    pub static AsiaKamchatka: &DbTimeZone = &DbTimeZone {
        index: 175,
        name: "Asia/Kamchatka",
        debug_name: "AsiaKamchatka",
        bytes: bytes::AsiaKamchatka,
        parsed: &parsed::AsiaKamchatka,
    };

    /// Asia/Karachi,
    pub static AsiaKarachi: &DbTimeZone = &DbTimeZone {
        index: 176,
        name: "Asia/Karachi",
        debug_name: "AsiaKarachi",
        bytes: bytes::AsiaKarachi,
        parsed: &parsed::AsiaKarachi,
    };

    /// Asia/Kashgar,
    pub static AsiaKashgar: &DbTimeZone = &DbTimeZone {
        index: 177,
        name: "Asia/Kashgar",
        debug_name: "AsiaKashgar",
        bytes: bytes::AsiaKashgar,
        parsed: &parsed::AsiaKashgar,
    };

    /// Asia/Kathmandu,
    pub static AsiaKathmandu: &DbTimeZone = &DbTimeZone {
        index: 178,
        name: "Asia/Kathmandu",
        debug_name: "AsiaKathmandu",
        bytes: bytes::AsiaKathmandu,
        parsed: &parsed::AsiaKathmandu,
    };

    /// Asia/Katmandu,
    pub static AsiaKatmandu: &DbTimeZone = AsiaKathmandu;

    /// Asia/Khandyga,
    pub static AsiaKhandyga: &DbTimeZone = &DbTimeZone {
        index: 179,
        name: "Asia/Khandyga",
        debug_name: "AsiaKhandyga",
        bytes: bytes::AsiaKhandyga,
        parsed: &parsed::AsiaKhandyga,
    };

    /// Asia/Kolkata,
    pub static AsiaKolkata: &DbTimeZone = AsiaCalcutta;

    /// Asia/Krasnoyarsk,
    pub static AsiaKrasnoyarsk: &DbTimeZone = &DbTimeZone {
        index: 180,
        name: "Asia/Krasnoyarsk",
        debug_name: "AsiaKrasnoyarsk",
        bytes: bytes::AsiaKrasnoyarsk,
        parsed: &parsed::AsiaKrasnoyarsk,
    };

    /// Asia/Kuala_Lumpur,
    pub static AsiaKualaLumpur: &DbTimeZone = &DbTimeZone {
        index: 181,
        name: "Asia/Kuala_Lumpur",
        debug_name: "AsiaKualaLumpur",
        bytes: bytes::AsiaKualaLumpur,
        parsed: &parsed::AsiaKualaLumpur,
    };

    /// Asia/Kuching,
    pub static AsiaKuching: &DbTimeZone = &DbTimeZone {
        index: 182,
        name: "Asia/Kuching",
        debug_name: "AsiaKuching",
        bytes: bytes::AsiaKuching,
        parsed: &parsed::AsiaKuching,
    };

    /// Asia/Kuwait,
    pub static AsiaKuwait: &DbTimeZone = AntarcticaSyowa;

    /// Asia/Macao,
    pub static AsiaMacao: &DbTimeZone = &DbTimeZone {
        index: 183,
        name: "Asia/Macao",
        debug_name: "AsiaMacao",
        bytes: bytes::AsiaMacao,
        parsed: &parsed::AsiaMacao,
    };

    /// Asia/Macau,
    pub static AsiaMacau: &DbTimeZone = AsiaMacao;

    /// Asia/Magadan,
    pub static AsiaMagadan: &DbTimeZone = &DbTimeZone {
        index: 184,
        name: "Asia/Magadan",
        debug_name: "AsiaMagadan",
        bytes: bytes::AsiaMagadan,
        parsed: &parsed::AsiaMagadan,
    };

    /// Asia/Makassar,
    pub static AsiaMakassar: &DbTimeZone = &DbTimeZone {
        index: 185,
        name: "Asia/Makassar",
        debug_name: "AsiaMakassar",
        bytes: bytes::AsiaMakassar,
        parsed: &parsed::AsiaMakassar,
    };

    /// Asia/Manila,
    pub static AsiaManila: &DbTimeZone = &DbTimeZone {
        index: 186,
        name: "Asia/Manila",
        debug_name: "AsiaManila",
        bytes: bytes::AsiaManila,
        parsed: &parsed::AsiaManila,
    };

    /// Asia/Muscat,
    pub static AsiaMuscat: &DbTimeZone = AsiaDubai;

    /// Asia/Nicosia,
    pub static AsiaNicosia: &DbTimeZone = &DbTimeZone {
        index: 187,
        name: "Asia/Nicosia",
        debug_name: "AsiaNicosia",
        bytes: bytes::AsiaNicosia,
        parsed: &parsed::AsiaNicosia,
    };

    /// Asia/Novokuznetsk,
    pub static AsiaNovokuznetsk: &DbTimeZone = &DbTimeZone {
        index: 188,
        name: "Asia/Novokuznetsk",
        debug_name: "AsiaNovokuznetsk",
        bytes: bytes::AsiaNovokuznetsk,
        parsed: &parsed::AsiaNovokuznetsk,
    };

    /// Asia/Novosibirsk,
    pub static AsiaNovosibirsk: &DbTimeZone = &DbTimeZone {
        index: 189,
        name: "Asia/Novosibirsk",
        debug_name: "AsiaNovosibirsk",
        bytes: bytes::AsiaNovosibirsk,
        parsed: &parsed::AsiaNovosibirsk,
    };

    /// Asia/Omsk,
    pub static AsiaOmsk: &DbTimeZone = &DbTimeZone {
        index: 190,
        name: "Asia/Omsk",
        debug_name: "AsiaOmsk",
        bytes: bytes::AsiaOmsk,
        parsed: &parsed::AsiaOmsk,
    };

    /// Asia/Oral,
    pub static AsiaOral: &DbTimeZone = &DbTimeZone {
        index: 191,
        name: "Asia/Oral",
        debug_name: "AsiaOral",
        bytes: bytes::AsiaOral,
        parsed: &parsed::AsiaOral,
    };

    /// Asia/Phnom_Penh,
    pub static AsiaPhnomPenh: &DbTimeZone = AsiaBangkok;

    /// Asia/Pontianak,
    pub static AsiaPontianak: &DbTimeZone = &DbTimeZone {
        index: 192,
        name: "Asia/Pontianak",
        debug_name: "AsiaPontianak",
        bytes: bytes::AsiaPontianak,
        parsed: &parsed::AsiaPontianak,
    };

    /// Asia/Pyongyang,
    pub static AsiaPyongyang: &DbTimeZone = &DbTimeZone {
        index: 193,
        name: "Asia/Pyongyang",
        debug_name: "AsiaPyongyang",
        bytes: bytes::AsiaPyongyang,
        parsed: &parsed::AsiaPyongyang,
    };

    /// Asia/Qatar,
    pub static AsiaQatar: &DbTimeZone = AsiaBahrain;

    /// Asia/Qostanay,
    pub static AsiaQostanay: &DbTimeZone = &DbTimeZone {
        index: 194,
        name: "Asia/Qostanay",
        debug_name: "AsiaQostanay",
        bytes: bytes::AsiaQostanay,
        parsed: &parsed::AsiaQostanay,
    };

    /// Asia/Qyzylorda,
    pub static AsiaQyzylorda: &DbTimeZone = &DbTimeZone {
        index: 195,
        name: "Asia/Qyzylorda",
        debug_name: "AsiaQyzylorda",
        bytes: bytes::AsiaQyzylorda,
        parsed: &parsed::AsiaQyzylorda,
    };

    /// Asia/Rangoon,
    pub static AsiaRangoon: &DbTimeZone = &DbTimeZone {
        index: 196,
        name: "Asia/Rangoon",
        debug_name: "AsiaRangoon",
        bytes: bytes::AsiaRangoon,
        parsed: &parsed::AsiaRangoon,
    };

    /// Asia/Riyadh,
    pub static AsiaRiyadh: &DbTimeZone = AntarcticaSyowa;

    /// Asia/Saigon,
    pub static AsiaSaigon: &DbTimeZone = AsiaHoChiMinh;

    /// Asia/Sakhalin,
    pub static AsiaSakhalin: &DbTimeZone = &DbTimeZone {
        index: 197,
        name: "Asia/Sakhalin",
        debug_name: "AsiaSakhalin",
        bytes: bytes::AsiaSakhalin,
        parsed: &parsed::AsiaSakhalin,
    };

    /// Asia/Samarkand,
    pub static AsiaSamarkand: &DbTimeZone = &DbTimeZone {
        index: 198,
        name: "Asia/Samarkand",
        debug_name: "AsiaSamarkand",
        bytes: bytes::AsiaSamarkand,
        parsed: &parsed::AsiaSamarkand,
    };

    /// Asia/Seoul,
    pub static AsiaSeoul: &DbTimeZone = &DbTimeZone {
        index: 199,
        name: "Asia/Seoul",
        debug_name: "AsiaSeoul",
        bytes: bytes::AsiaSeoul,
        parsed: &parsed::AsiaSeoul,
    };

    /// Asia/Shanghai,
    pub static AsiaShanghai: &DbTimeZone = AsiaChongqing;

    /// Asia/Singapore,
    pub static AsiaSingapore: &DbTimeZone = &DbTimeZone {
        index: 200,
        name: "Asia/Singapore",
        debug_name: "AsiaSingapore",
        bytes: bytes::AsiaSingapore,
        parsed: &parsed::AsiaSingapore,
    };

    /// Asia/Srednekolymsk,
    pub static AsiaSrednekolymsk: &DbTimeZone = &DbTimeZone {
        index: 201,
        name: "Asia/Srednekolymsk",
        debug_name: "AsiaSrednekolymsk",
        bytes: bytes::AsiaSrednekolymsk,
        parsed: &parsed::AsiaSrednekolymsk,
    };

    /// Asia/Taipei,
    pub static AsiaTaipei: &DbTimeZone = &DbTimeZone {
        index: 202,
        name: "Asia/Taipei",
        debug_name: "AsiaTaipei",
        bytes: bytes::AsiaTaipei,
        parsed: &parsed::AsiaTaipei,
    };

    /// Asia/Tashkent,
    pub static AsiaTashkent: &DbTimeZone = &DbTimeZone {
        index: 203,
        name: "Asia/Tashkent",
        debug_name: "AsiaTashkent",
        bytes: bytes::AsiaTashkent,
        parsed: &parsed::AsiaTashkent,
    };

    /// Asia/Tbilisi,
    pub static AsiaTbilisi: &DbTimeZone = &DbTimeZone {
        index: 204,
        name: "Asia/Tbilisi",
        debug_name: "AsiaTbilisi",
        bytes: bytes::AsiaTbilisi,
        parsed: &parsed::AsiaTbilisi,
    };

    /// Asia/Tehran,
    pub static AsiaTehran: &DbTimeZone = &DbTimeZone {
        index: 205,
        name: "Asia/Tehran",
        debug_name: "AsiaTehran",
        bytes: bytes::AsiaTehran,
        parsed: &parsed::AsiaTehran,
    };

    /// Asia/Tel_Aviv,
    pub static AsiaTelAviv: &DbTimeZone = AsiaJerusalem;

    /// Asia/Thimbu,
    pub static AsiaThimbu: &DbTimeZone = &DbTimeZone {
        index: 206,
        name: "Asia/Thimbu",
        debug_name: "AsiaThimbu",
        bytes: bytes::AsiaThimbu,
        parsed: &parsed::AsiaThimbu,
    };

    /// Asia/Thimphu,
    pub static AsiaThimphu: &DbTimeZone = AsiaThimbu;

    /// Asia/Tokyo,
    pub static AsiaTokyo: &DbTimeZone = &DbTimeZone {
        index: 207,
        name: "Asia/Tokyo",
        debug_name: "AsiaTokyo",
        bytes: bytes::AsiaTokyo,
        parsed: &parsed::AsiaTokyo,
    };

    /// Asia/Tomsk,
    pub static AsiaTomsk: &DbTimeZone = &DbTimeZone {
        index: 208,
        name: "Asia/Tomsk",
        debug_name: "AsiaTomsk",
        bytes: bytes::AsiaTomsk,
        parsed: &parsed::AsiaTomsk,
    };

    /// Asia/Ujung_Pandang,
    pub static AsiaUjungPandang: &DbTimeZone = AsiaMakassar;

    /// Asia/Ulaanbaatar,
    pub static AsiaUlaanbaatar: &DbTimeZone = &DbTimeZone {
        index: 209,
        name: "Asia/Ulaanbaatar",
        debug_name: "AsiaUlaanbaatar",
        bytes: bytes::AsiaUlaanbaatar,
        parsed: &parsed::AsiaUlaanbaatar,
    };

    /// Asia/Ulan_Bator,
    pub static AsiaUlanBator: &DbTimeZone = AsiaUlaanbaatar;

    /// Asia/Urumqi,
    pub static AsiaUrumqi: &DbTimeZone = AsiaKashgar;

    /// Asia/Ust-Nera,
    pub static AsiaUstNera: &DbTimeZone = &DbTimeZone {
        index: 210,
        name: "Asia/Ust-Nera",
        debug_name: "AsiaUstNera",
        bytes: bytes::AsiaUstNera,
        parsed: &parsed::AsiaUstNera,
    };

    /// Asia/Vientiane,
    pub static AsiaVientiane: &DbTimeZone = AsiaBangkok;

    /// Asia/Vladivostok,
    pub static AsiaVladivostok: &DbTimeZone = &DbTimeZone {
        index: 211,
        name: "Asia/Vladivostok",
        debug_name: "AsiaVladivostok",
        bytes: bytes::AsiaVladivostok,
        parsed: &parsed::AsiaVladivostok,
    };

    /// Asia/Yakutsk,
    pub static AsiaYakutsk: &DbTimeZone = &DbTimeZone {
        index: 212,
        name: "Asia/Yakutsk",
        debug_name: "AsiaYakutsk",
        bytes: bytes::AsiaYakutsk,
        parsed: &parsed::AsiaYakutsk,
    };

    /// Asia/Yangon,
    pub static AsiaYangon: &DbTimeZone = AsiaRangoon;

    /// Asia/Yekaterinburg,
    pub static AsiaYekaterinburg: &DbTimeZone = &DbTimeZone {
        index: 213,
        name: "Asia/Yekaterinburg",
        debug_name: "AsiaYekaterinburg",
        bytes: bytes::AsiaYekaterinburg,
        parsed: &parsed::AsiaYekaterinburg,
    };

    /// Asia/Yerevan,
    pub static AsiaYerevan: &DbTimeZone = &DbTimeZone {
        index: 214,
        name: "Asia/Yerevan",
        debug_name: "AsiaYerevan",
        bytes: bytes::AsiaYerevan,
        parsed: &parsed::AsiaYerevan,
    };

    /// Atlantic/Azores,
    pub static AtlanticAzores: &DbTimeZone = &DbTimeZone {
        index: 215,
        name: "Atlantic/Azores",
        debug_name: "AtlanticAzores",
        bytes: bytes::AtlanticAzores,
        parsed: &parsed::AtlanticAzores,
    };

    /// Atlantic/Bermuda,
    pub static AtlanticBermuda: &DbTimeZone = &DbTimeZone {
        index: 216,
        name: "Atlantic/Bermuda",
        debug_name: "AtlanticBermuda",
        bytes: bytes::AtlanticBermuda,
        parsed: &parsed::AtlanticBermuda,
    };

    /// Atlantic/Canary,
    pub static AtlanticCanary: &DbTimeZone = &DbTimeZone {
        index: 217,
        name: "Atlantic/Canary",
        debug_name: "AtlanticCanary",
        bytes: bytes::AtlanticCanary,
        parsed: &parsed::AtlanticCanary,
    };

    /// Atlantic/Cape_Verde,
    pub static AtlanticCapeVerde: &DbTimeZone = &DbTimeZone {
        index: 218,
        name: "Atlantic/Cape_Verde",
        debug_name: "AtlanticCapeVerde",
        bytes: bytes::AtlanticCapeVerde,
        parsed: &parsed::AtlanticCapeVerde,
    };

    /// Atlantic/Faeroe,
    pub static AtlanticFaeroe: &DbTimeZone = &DbTimeZone {
        index: 219,
        name: "Atlantic/Faeroe",
        debug_name: "AtlanticFaeroe",
        bytes: bytes::AtlanticFaeroe,
        parsed: &parsed::AtlanticFaeroe,
    };

    /// Atlantic/Faroe,
    pub static AtlanticFaroe: &DbTimeZone = AtlanticFaeroe;

    /// Atlantic/Jan_Mayen,
    pub static AtlanticJanMayen: &DbTimeZone = ArcticLongyearbyen;

    /// Atlantic/Madeira,
    pub static AtlanticMadeira: &DbTimeZone = &DbTimeZone {
        index: 220,
        name: "Atlantic/Madeira",
        debug_name: "AtlanticMadeira",
        bytes: bytes::AtlanticMadeira,
        parsed: &parsed::AtlanticMadeira,
    };

    /// Atlantic/Reykjavik,
    pub static AtlanticReykjavik: &DbTimeZone = &DbTimeZone {
        index: 221,
        name: "Atlantic/Reykjavik",
        debug_name: "AtlanticReykjavik",
        bytes: bytes::AtlanticReykjavik,
        parsed: &parsed::AtlanticReykjavik,
    };

    /// Atlantic/South_Georgia,
    pub static AtlanticSouthGeorgia: &DbTimeZone = &DbTimeZone {
        index: 222,
        name: "Atlantic/South_Georgia",
        debug_name: "AtlanticSouthGeorgia",
        bytes: bytes::AtlanticSouthGeorgia,
        parsed: &parsed::AtlanticSouthGeorgia,
    };

    /// Atlantic/St_Helena,
    pub static AtlanticStHelena: &DbTimeZone = AfricaAbidjan;

    /// Atlantic/Stanley,
    pub static AtlanticStanley: &DbTimeZone = &DbTimeZone {
        index: 223,
        name: "Atlantic/Stanley",
        debug_name: "AtlanticStanley",
        bytes: bytes::AtlanticStanley,
        parsed: &parsed::AtlanticStanley,
    };

    /// Australia/ACT,
    pub static AustraliaAct: &DbTimeZone = &DbTimeZone {
        index: 224,
        name: "Australia/ACT",
        debug_name: "AustraliaAct",
        bytes: bytes::AustraliaAct,
        parsed: &parsed::AustraliaAct,
    };

    /// Australia/Adelaide,
    pub static AustraliaAdelaide: &DbTimeZone = &DbTimeZone {
        index: 225,
        name: "Australia/Adelaide",
        debug_name: "AustraliaAdelaide",
        bytes: bytes::AustraliaAdelaide,
        parsed: &parsed::AustraliaAdelaide,
    };

    /// Australia/Brisbane,
    pub static AustraliaBrisbane: &DbTimeZone = &DbTimeZone {
        index: 226,
        name: "Australia/Brisbane",
        debug_name: "AustraliaBrisbane",
        bytes: bytes::AustraliaBrisbane,
        parsed: &parsed::AustraliaBrisbane,
    };

    /// Australia/Broken_Hill,
    pub static AustraliaBrokenHill: &DbTimeZone = &DbTimeZone {
        index: 227,
        name: "Australia/Broken_Hill",
        debug_name: "AustraliaBrokenHill",
        bytes: bytes::AustraliaBrokenHill,
        parsed: &parsed::AustraliaBrokenHill,
    };

    /// Australia/Canberra,
    pub static AustraliaCanberra: &DbTimeZone = AustraliaAct;

    /// Australia/Currie,
    pub static AustraliaCurrie: &DbTimeZone = &DbTimeZone {
        index: 228,
        name: "Australia/Currie",
        debug_name: "AustraliaCurrie",
        bytes: bytes::AustraliaCurrie,
        parsed: &parsed::AustraliaCurrie,
    };

    /// Australia/Darwin,
    pub static AustraliaDarwin: &DbTimeZone = &DbTimeZone {
        index: 229,
        name: "Australia/Darwin",
        debug_name: "AustraliaDarwin",
        bytes: bytes::AustraliaDarwin,
        parsed: &parsed::AustraliaDarwin,
    };

    /// Australia/Eucla,
    pub static AustraliaEucla: &DbTimeZone = &DbTimeZone {
        index: 230,
        name: "Australia/Eucla",
        debug_name: "AustraliaEucla",
        bytes: bytes::AustraliaEucla,
        parsed: &parsed::AustraliaEucla,
    };

    /// Australia/Hobart,
    pub static AustraliaHobart: &DbTimeZone = AustraliaCurrie;

    /// Australia/LHI,
    pub static AustraliaLhi: &DbTimeZone = &DbTimeZone {
        index: 231,
        name: "Australia/LHI",
        debug_name: "AustraliaLhi",
        bytes: bytes::AustraliaLhi,
        parsed: &parsed::AustraliaLhi,
    };

    /// Australia/Lindeman,
    pub static AustraliaLindeman: &DbTimeZone = &DbTimeZone {
        index: 232,
        name: "Australia/Lindeman",
        debug_name: "AustraliaLindeman",
        bytes: bytes::AustraliaLindeman,
        parsed: &parsed::AustraliaLindeman,
    };

    /// Australia/Lord_Howe,
    pub static AustraliaLordHowe: &DbTimeZone = AustraliaLhi;

    /// Australia/Melbourne,
    pub static AustraliaMelbourne: &DbTimeZone = &DbTimeZone {
        index: 233,
        name: "Australia/Melbourne",
        debug_name: "AustraliaMelbourne",
        bytes: bytes::AustraliaMelbourne,
        parsed: &parsed::AustraliaMelbourne,
    };

    /// Australia/North,
    pub static AustraliaNorth: &DbTimeZone = AustraliaDarwin;

    /// Australia/NSW,
    pub static AustraliaNsw: &DbTimeZone = AustraliaAct;

    /// Australia/Perth,
    pub static AustraliaPerth: &DbTimeZone = &DbTimeZone {
        index: 234,
        name: "Australia/Perth",
        debug_name: "AustraliaPerth",
        bytes: bytes::AustraliaPerth,
        parsed: &parsed::AustraliaPerth,
    };

    /// Australia/Queensland,
    pub static AustraliaQueensland: &DbTimeZone = AustraliaBrisbane;

    /// Australia/South,
    pub static AustraliaSouth: &DbTimeZone = AustraliaAdelaide;

    /// Australia/Sydney,
    pub static AustraliaSydney: &DbTimeZone = AustraliaAct;

    /// Australia/Tasmania,
    pub static AustraliaTasmania: &DbTimeZone = AustraliaCurrie;

    /// Australia/Victoria,
    pub static AustraliaVictoria: &DbTimeZone = AustraliaMelbourne;

    /// Australia/West,
    pub static AustraliaWest: &DbTimeZone = AustraliaPerth;

    /// Australia/Yancowinna,
    pub static AustraliaYancowinna: &DbTimeZone = AustraliaBrokenHill;

    /// Brazil/Acre,
    pub static BrazilAcre: &DbTimeZone = AmericaPortoAcre;

    /// Brazil/DeNoronha,
    pub static BrazilDeNoronha: &DbTimeZone = AmericaNoronha;

    /// Brazil/East,
    pub static BrazilEast: &DbTimeZone = AmericaSaoPaulo;

    /// Brazil/West,
    pub static BrazilWest: &DbTimeZone = AmericaManaus;

    /// Canada/Atlantic,
    pub static CanadaAtlantic: &DbTimeZone = AmericaHalifax;

    /// Canada/Central,
    pub static CanadaCentral: &DbTimeZone = AmericaWinnipeg;

    /// Canada/Eastern,
    pub static CanadaEastern: &DbTimeZone = AmericaMontreal;

    /// Canada/Mountain,
    pub static CanadaMountain: &DbTimeZone = AmericaEdmonton;

    /// Canada/Newfoundland,
    pub static CanadaNewfoundland: &DbTimeZone = AmericaStJohns;

    /// Canada/Pacific,
    pub static CanadaPacific: &DbTimeZone = AmericaVancouver;

    /// Canada/Saskatchewan,
    pub static CanadaSaskatchewan: &DbTimeZone = AmericaRegina;

    /// Canada/Yukon,
    pub static CanadaYukon: &DbTimeZone = AmericaWhitehorse;

    /// CET,
    pub static Cet: &DbTimeZone = &DbTimeZone {
        index: 235,
        name: "CET",
        debug_name: "Cet",
        bytes: bytes::Cet,
        parsed: &parsed::Cet,
    };

    /// Chile/Continental,
    pub static ChileContinental: &DbTimeZone = AmericaSantiago;

    /// Chile/EasterIsland,
    pub static ChileEasterIsland: &DbTimeZone = &DbTimeZone {
        index: 236,
        name: "Chile/EasterIsland",
        debug_name: "ChileEasterIsland",
        bytes: bytes::ChileEasterIsland,
        parsed: &parsed::ChileEasterIsland,
    };

    /// CST6CDT,
    pub static Cst6Cdt: &DbTimeZone = &DbTimeZone {
        index: 237,
        name: "CST6CDT",
        debug_name: "Cst6Cdt",
        bytes: bytes::Cst6Cdt,
        parsed: &parsed::Cst6Cdt,
    };

    /// Cuba,
    pub static Cuba: &DbTimeZone = AmericaHavana;

    /// EET,
    pub static Eet: &DbTimeZone = &DbTimeZone {
        index: 238,
        name: "EET",
        debug_name: "Eet",
        bytes: bytes::Eet,
        parsed: &parsed::Eet,
    };

    /// Egypt,
    pub static Egypt: &DbTimeZone = AfricaCairo;

    /// Eire,
    pub static Eire: &DbTimeZone = &DbTimeZone {
        index: 239,
        name: "Eire",
        debug_name: "Eire",
        bytes: bytes::Eire,
        parsed: &parsed::Eire,
    };

    /// EST,
    pub static Est: &DbTimeZone = &DbTimeZone {
        index: 240,
        name: "EST",
        debug_name: "Est",
        bytes: bytes::Est,
        parsed: &parsed::Est,
    };

    /// EST5EDT,
    pub static Est5Edt: &DbTimeZone = &DbTimeZone {
        index: 241,
        name: "EST5EDT",
        debug_name: "Est5Edt",
        bytes: bytes::Est5Edt,
        parsed: &parsed::Est5Edt,
    };

    /// Etc/GMT,
    pub static EtcGmt: &DbTimeZone = &DbTimeZone {
        index: 242,
        name: "Etc/GMT",
        debug_name: "EtcGmt",
        bytes: bytes::EtcGmt,
        parsed: &parsed::EtcGmt,
    };

    /// Etc/GMT0,
    pub static EtcGmt0: &DbTimeZone = EtcGmt;

    /// Etc/GMT-0,
    pub static EtcGmtMinus0: &DbTimeZone = EtcGmt;

    /// Etc/GMT-1,
    pub static EtcGmtMinus1: &DbTimeZone = &DbTimeZone {
        index: 243,
        name: "Etc/GMT-1",
        debug_name: "EtcGmtMinus1",
        bytes: bytes::EtcGmtMinus1,
        parsed: &parsed::EtcGmtMinus1,
    };

    /// Etc/GMT-10,
    pub static EtcGmtMinus10: &DbTimeZone = &DbTimeZone {
        index: 244,
        name: "Etc/GMT-10",
        debug_name: "EtcGmtMinus10",
        bytes: bytes::EtcGmtMinus10,
        parsed: &parsed::EtcGmtMinus10,
    };

    /// Etc/GMT-11,
    pub static EtcGmtMinus11: &DbTimeZone = &DbTimeZone {
        index: 245,
        name: "Etc/GMT-11",
        debug_name: "EtcGmtMinus11",
        bytes: bytes::EtcGmtMinus11,
        parsed: &parsed::EtcGmtMinus11,
    };

    /// Etc/GMT-12,
    pub static EtcGmtMinus12: &DbTimeZone = &DbTimeZone {
        index: 246,
        name: "Etc/GMT-12",
        debug_name: "EtcGmtMinus12",
        bytes: bytes::EtcGmtMinus12,
        parsed: &parsed::EtcGmtMinus12,
    };

    /// Etc/GMT-13,
    pub static EtcGmtMinus13: &DbTimeZone = &DbTimeZone {
        index: 247,
        name: "Etc/GMT-13",
        debug_name: "EtcGmtMinus13",
        bytes: bytes::EtcGmtMinus13,
        parsed: &parsed::EtcGmtMinus13,
    };

    /// Etc/GMT-14,
    pub static EtcGmtMinus14: &DbTimeZone = &DbTimeZone {
        index: 248,
        name: "Etc/GMT-14",
        debug_name: "EtcGmtMinus14",
        bytes: bytes::EtcGmtMinus14,
        parsed: &parsed::EtcGmtMinus14,
    };

    /// Etc/GMT-2,
    pub static EtcGmtMinus2: &DbTimeZone = &DbTimeZone {
        index: 249,
        name: "Etc/GMT-2",
        debug_name: "EtcGmtMinus2",
        bytes: bytes::EtcGmtMinus2,
        parsed: &parsed::EtcGmtMinus2,
    };

    /// Etc/GMT-3,
    pub static EtcGmtMinus3: &DbTimeZone = &DbTimeZone {
        index: 250,
        name: "Etc/GMT-3",
        debug_name: "EtcGmtMinus3",
        bytes: bytes::EtcGmtMinus3,
        parsed: &parsed::EtcGmtMinus3,
    };

    /// Etc/GMT-4,
    pub static EtcGmtMinus4: &DbTimeZone = &DbTimeZone {
        index: 251,
        name: "Etc/GMT-4",
        debug_name: "EtcGmtMinus4",
        bytes: bytes::EtcGmtMinus4,
        parsed: &parsed::EtcGmtMinus4,
    };

    /// Etc/GMT-5,
    pub static EtcGmtMinus5: &DbTimeZone = &DbTimeZone {
        index: 252,
        name: "Etc/GMT-5",
        debug_name: "EtcGmtMinus5",
        bytes: bytes::EtcGmtMinus5,
        parsed: &parsed::EtcGmtMinus5,
    };

    /// Etc/GMT-6,
    pub static EtcGmtMinus6: &DbTimeZone = &DbTimeZone {
        index: 253,
        name: "Etc/GMT-6",
        debug_name: "EtcGmtMinus6",
        bytes: bytes::EtcGmtMinus6,
        parsed: &parsed::EtcGmtMinus6,
    };

    /// Etc/GMT-7,
    pub static EtcGmtMinus7: &DbTimeZone = &DbTimeZone {
        index: 254,
        name: "Etc/GMT-7",
        debug_name: "EtcGmtMinus7",
        bytes: bytes::EtcGmtMinus7,
        parsed: &parsed::EtcGmtMinus7,
    };

    /// Etc/GMT-8,
    pub static EtcGmtMinus8: &DbTimeZone = &DbTimeZone {
        index: 255,
        name: "Etc/GMT-8",
        debug_name: "EtcGmtMinus8",
        bytes: bytes::EtcGmtMinus8,
        parsed: &parsed::EtcGmtMinus8,
    };

    /// Etc/GMT-9,
    pub static EtcGmtMinus9: &DbTimeZone = &DbTimeZone {
        index: 256,
        name: "Etc/GMT-9",
        debug_name: "EtcGmtMinus9",
        bytes: bytes::EtcGmtMinus9,
        parsed: &parsed::EtcGmtMinus9,
    };

    /// Etc/GMT+0,
    pub static EtcGmtPlus0: &DbTimeZone = EtcGmt;

    /// Etc/GMT+1,
    pub static EtcGmtPlus1: &DbTimeZone = &DbTimeZone {
        index: 257,
        name: "Etc/GMT+1",
        debug_name: "EtcGmtPlus1",
        bytes: bytes::EtcGmtPlus1,
        parsed: &parsed::EtcGmtPlus1,
    };

    /// Etc/GMT+10,
    pub static EtcGmtPlus10: &DbTimeZone = &DbTimeZone {
        index: 258,
        name: "Etc/GMT+10",
        debug_name: "EtcGmtPlus10",
        bytes: bytes::EtcGmtPlus10,
        parsed: &parsed::EtcGmtPlus10,
    };

    /// Etc/GMT+11,
    pub static EtcGmtPlus11: &DbTimeZone = &DbTimeZone {
        index: 259,
        name: "Etc/GMT+11",
        debug_name: "EtcGmtPlus11",
        bytes: bytes::EtcGmtPlus11,
        parsed: &parsed::EtcGmtPlus11,
    };

    /// Etc/GMT+12,
    pub static EtcGmtPlus12: &DbTimeZone = &DbTimeZone {
        index: 260,
        name: "Etc/GMT+12",
        debug_name: "EtcGmtPlus12",
        bytes: bytes::EtcGmtPlus12,
        parsed: &parsed::EtcGmtPlus12,
    };

    /// Etc/GMT+2,
    pub static EtcGmtPlus2: &DbTimeZone = &DbTimeZone {
        index: 261,
        name: "Etc/GMT+2",
        debug_name: "EtcGmtPlus2",
        bytes: bytes::EtcGmtPlus2,
        parsed: &parsed::EtcGmtPlus2,
    };

    /// Etc/GMT+3,
    pub static EtcGmtPlus3: &DbTimeZone = &DbTimeZone {
        index: 262,
        name: "Etc/GMT+3",
        debug_name: "EtcGmtPlus3",
        bytes: bytes::EtcGmtPlus3,
        parsed: &parsed::EtcGmtPlus3,
    };

    /// Etc/GMT+4,
    pub static EtcGmtPlus4: &DbTimeZone = &DbTimeZone {
        index: 263,
        name: "Etc/GMT+4",
        debug_name: "EtcGmtPlus4",
        bytes: bytes::EtcGmtPlus4,
        parsed: &parsed::EtcGmtPlus4,
    };

    /// Etc/GMT+5,
    pub static EtcGmtPlus5: &DbTimeZone = &DbTimeZone {
        index: 264,
        name: "Etc/GMT+5",
        debug_name: "EtcGmtPlus5",
        bytes: bytes::EtcGmtPlus5,
        parsed: &parsed::EtcGmtPlus5,
    };

    /// Etc/GMT+6,
    pub static EtcGmtPlus6: &DbTimeZone = &DbTimeZone {
        index: 265,
        name: "Etc/GMT+6",
        debug_name: "EtcGmtPlus6",
        bytes: bytes::EtcGmtPlus6,
        parsed: &parsed::EtcGmtPlus6,
    };

    /// Etc/GMT+7,
    pub static EtcGmtPlus7: &DbTimeZone = &DbTimeZone {
        index: 266,
        name: "Etc/GMT+7",
        debug_name: "EtcGmtPlus7",
        bytes: bytes::EtcGmtPlus7,
        parsed: &parsed::EtcGmtPlus7,
    };

    /// Etc/GMT+8,
    pub static EtcGmtPlus8: &DbTimeZone = &DbTimeZone {
        index: 267,
        name: "Etc/GMT+8",
        debug_name: "EtcGmtPlus8",
        bytes: bytes::EtcGmtPlus8,
        parsed: &parsed::EtcGmtPlus8,
    };

    /// Etc/GMT+9,
    pub static EtcGmtPlus9: &DbTimeZone = &DbTimeZone {
        index: 268,
        name: "Etc/GMT+9",
        debug_name: "EtcGmtPlus9",
        bytes: bytes::EtcGmtPlus9,
        parsed: &parsed::EtcGmtPlus9,
    };

    /// Etc/Greenwich,
    pub static EtcGreenwich: &DbTimeZone = EtcGmt;

    /// Etc/UCT,
    pub static EtcUct: &DbTimeZone = &DbTimeZone {
        index: 269,
        name: "Etc/UCT",
        debug_name: "EtcUct",
        bytes: bytes::EtcUct,
        parsed: &parsed::EtcUct,
    };

    /// Etc/Universal,
    pub static EtcUniversal: &DbTimeZone = EtcUct;

    /// Etc/UTC,
    pub static EtcUtc: &DbTimeZone = EtcUct;

    /// Etc/Zulu,
    pub static EtcZulu: &DbTimeZone = EtcUct;

    /// Europe/Amsterdam,
    pub static EuropeAmsterdam: &DbTimeZone = &DbTimeZone {
        index: 270,
        name: "Europe/Amsterdam",
        debug_name: "EuropeAmsterdam",
        bytes: bytes::EuropeAmsterdam,
        parsed: &parsed::EuropeAmsterdam,
    };

    /// Europe/Andorra,
    pub static EuropeAndorra: &DbTimeZone = &DbTimeZone {
        index: 271,
        name: "Europe/Andorra",
        debug_name: "EuropeAndorra",
        bytes: bytes::EuropeAndorra,
        parsed: &parsed::EuropeAndorra,
    };

    /// Europe/Astrakhan,
    pub static EuropeAstrakhan: &DbTimeZone = &DbTimeZone {
        index: 272,
        name: "Europe/Astrakhan",
        debug_name: "EuropeAstrakhan",
        bytes: bytes::EuropeAstrakhan,
        parsed: &parsed::EuropeAstrakhan,
    };

    /// Europe/Athens,
    pub static EuropeAthens: &DbTimeZone = &DbTimeZone {
        index: 273,
        name: "Europe/Athens",
        debug_name: "EuropeAthens",
        bytes: bytes::EuropeAthens,
        parsed: &parsed::EuropeAthens,
    };

    /// Europe/Belfast,
    pub static EuropeBelfast: &DbTimeZone = &DbTimeZone {
        index: 274,
        name: "Europe/Belfast",
        debug_name: "EuropeBelfast",
        bytes: bytes::EuropeBelfast,
        parsed: &parsed::EuropeBelfast,
    };

    /// Europe/Belgrade,
    pub static EuropeBelgrade: &DbTimeZone = &DbTimeZone {
        index: 275,
        name: "Europe/Belgrade",
        debug_name: "EuropeBelgrade",
        bytes: bytes::EuropeBelgrade,
        parsed: &parsed::EuropeBelgrade,
    };

    /// Europe/Berlin,
    pub static EuropeBerlin: &DbTimeZone = &DbTimeZone {
        index: 276,
        name: "Europe/Berlin",
        debug_name: "EuropeBerlin",
        bytes: bytes::EuropeBerlin,
        parsed: &parsed::EuropeBerlin,
    };

    /// Europe/Bratislava,
    pub static EuropeBratislava: &DbTimeZone = &DbTimeZone {
        index: 277,
        name: "Europe/Bratislava",
        debug_name: "EuropeBratislava",
        bytes: bytes::EuropeBratislava,
        parsed: &parsed::EuropeBratislava,
    };

    /// Europe/Brussels,
    pub static EuropeBrussels: &DbTimeZone = &DbTimeZone {
        index: 278,
        name: "Europe/Brussels",
        debug_name: "EuropeBrussels",
        bytes: bytes::EuropeBrussels,
        parsed: &parsed::EuropeBrussels,
    };

    /// Europe/Bucharest,
    pub static EuropeBucharest: &DbTimeZone = &DbTimeZone {
        index: 279,
        name: "Europe/Bucharest",
        debug_name: "EuropeBucharest",
        bytes: bytes::EuropeBucharest,
        parsed: &parsed::EuropeBucharest,
    };

    /// Europe/Budapest,
    pub static EuropeBudapest: &DbTimeZone = &DbTimeZone {
        index: 280,
        name: "Europe/Budapest",
        debug_name: "EuropeBudapest",
        bytes: bytes::EuropeBudapest,
        parsed: &parsed::EuropeBudapest,
    };

    /// Europe/Busingen,
    pub static EuropeBusingen: &DbTimeZone = &DbTimeZone {
        index: 281,
        name: "Europe/Busingen",
        debug_name: "EuropeBusingen",
        bytes: bytes::EuropeBusingen,
        parsed: &parsed::EuropeBusingen,
    };

    /// Europe/Chisinau,
    pub static EuropeChisinau: &DbTimeZone = &DbTimeZone {
        index: 282,
        name: "Europe/Chisinau",
        debug_name: "EuropeChisinau",
        bytes: bytes::EuropeChisinau,
        parsed: &parsed::EuropeChisinau,
    };

    /// Europe/Copenhagen,
    pub static EuropeCopenhagen: &DbTimeZone = &DbTimeZone {
        index: 283,
        name: "Europe/Copenhagen",
        debug_name: "EuropeCopenhagen",
        bytes: bytes::EuropeCopenhagen,
        parsed: &parsed::EuropeCopenhagen,
    };

    /// Europe/Dublin,
    pub static EuropeDublin: &DbTimeZone = Eire;

    /// Europe/Gibraltar,
    pub static EuropeGibraltar: &DbTimeZone = &DbTimeZone {
        index: 284,
        name: "Europe/Gibraltar",
        debug_name: "EuropeGibraltar",
        bytes: bytes::EuropeGibraltar,
        parsed: &parsed::EuropeGibraltar,
    };

    /// Europe/Guernsey,
    pub static EuropeGuernsey: &DbTimeZone = EuropeBelfast;

    /// Europe/Helsinki,
    pub static EuropeHelsinki: &DbTimeZone = &DbTimeZone {
        index: 285,
        name: "Europe/Helsinki",
        debug_name: "EuropeHelsinki",
        bytes: bytes::EuropeHelsinki,
        parsed: &parsed::EuropeHelsinki,
    };

    /// Europe/Isle_of_Man,
    pub static EuropeIsleOfMan: &DbTimeZone = EuropeBelfast;

    /// Europe/Istanbul,
    pub static EuropeIstanbul: &DbTimeZone = AsiaIstanbul;

    /// Europe/Jersey,
    pub static EuropeJersey: &DbTimeZone = EuropeBelfast;

    /// Europe/Kaliningrad,
    pub static EuropeKaliningrad: &DbTimeZone = &DbTimeZone {
        index: 286,
        name: "Europe/Kaliningrad",
        debug_name: "EuropeKaliningrad",
        bytes: bytes::EuropeKaliningrad,
        parsed: &parsed::EuropeKaliningrad,
    };

    /// Europe/Kiev,
    pub static EuropeKiev: &DbTimeZone = &DbTimeZone {
        index: 287,
        name: "Europe/Kiev",
        debug_name: "EuropeKiev",
        bytes: bytes::EuropeKiev,
        parsed: &parsed::EuropeKiev,
    };

    /// Europe/Kirov,
    pub static EuropeKirov: &DbTimeZone = &DbTimeZone {
        index: 288,
        name: "Europe/Kirov",
        debug_name: "EuropeKirov",
        bytes: bytes::EuropeKirov,
        parsed: &parsed::EuropeKirov,
    };

    /// Europe/Lisbon,
    pub static EuropeLisbon: &DbTimeZone = &DbTimeZone {
        index: 289,
        name: "Europe/Lisbon",
        debug_name: "EuropeLisbon",
        bytes: bytes::EuropeLisbon,
        parsed: &parsed::EuropeLisbon,
    };

    /// Europe/Ljubljana,
    pub static EuropeLjubljana: &DbTimeZone = EuropeBelgrade;

    /// Europe/London,
    pub static EuropeLondon: &DbTimeZone = EuropeBelfast;

    /// Europe/Luxembourg,
    pub static EuropeLuxembourg: &DbTimeZone = &DbTimeZone {
        index: 290,
        name: "Europe/Luxembourg",
        debug_name: "EuropeLuxembourg",
        bytes: bytes::EuropeLuxembourg,
        parsed: &parsed::EuropeLuxembourg,
    };

    /// Europe/Madrid,
    pub static EuropeMadrid: &DbTimeZone = &DbTimeZone {
        index: 291,
        name: "Europe/Madrid",
        debug_name: "EuropeMadrid",
        bytes: bytes::EuropeMadrid,
        parsed: &parsed::EuropeMadrid,
    };

    /// Europe/Malta,
    pub static EuropeMalta: &DbTimeZone = &DbTimeZone {
        index: 292,
        name: "Europe/Malta",
        debug_name: "EuropeMalta",
        bytes: bytes::EuropeMalta,
        parsed: &parsed::EuropeMalta,
    };

    /// Europe/Mariehamn,
    pub static EuropeMariehamn: &DbTimeZone = EuropeHelsinki;

    /// Europe/Minsk,
    pub static EuropeMinsk: &DbTimeZone = &DbTimeZone {
        index: 293,
        name: "Europe/Minsk",
        debug_name: "EuropeMinsk",
        bytes: bytes::EuropeMinsk,
        parsed: &parsed::EuropeMinsk,
    };

    /// Europe/Monaco,
    pub static EuropeMonaco: &DbTimeZone = &DbTimeZone {
        index: 294,
        name: "Europe/Monaco",
        debug_name: "EuropeMonaco",
        bytes: bytes::EuropeMonaco,
        parsed: &parsed::EuropeMonaco,
    };

    /// Europe/Moscow,
    pub static EuropeMoscow: &DbTimeZone = &DbTimeZone {
        index: 295,
        name: "Europe/Moscow",
        debug_name: "EuropeMoscow",
        bytes: bytes::EuropeMoscow,
        parsed: &parsed::EuropeMoscow,
    };

    /// Europe/Nicosia,
    pub static EuropeNicosia: &DbTimeZone = AsiaNicosia;

    /// Europe/Oslo,
    pub static EuropeOslo: &DbTimeZone = ArcticLongyearbyen;

    /// Europe/Paris,
    pub static EuropeParis: &DbTimeZone = &DbTimeZone {
        index: 296,
        name: "Europe/Paris",
        debug_name: "EuropeParis",
        bytes: bytes::EuropeParis,
        parsed: &parsed::EuropeParis,
    };

    /// Europe/Podgorica,
    pub static EuropePodgorica: &DbTimeZone = EuropeBelgrade;

    /// Europe/Prague,
    pub static EuropePrague: &DbTimeZone = EuropeBratislava;

    /// Europe/Riga,
    pub static EuropeRiga: &DbTimeZone = &DbTimeZone {
        index: 297,
        name: "Europe/Riga",
        debug_name: "EuropeRiga",
        bytes: bytes::EuropeRiga,
        parsed: &parsed::EuropeRiga,
    };

    /// Europe/Rome,
    pub static EuropeRome: &DbTimeZone = &DbTimeZone {
        index: 298,
        name: "Europe/Rome",
        debug_name: "EuropeRome",
        bytes: bytes::EuropeRome,
        parsed: &parsed::EuropeRome,
    };

    /// Europe/Samara,
    pub static EuropeSamara: &DbTimeZone = &DbTimeZone {
        index: 299,
        name: "Europe/Samara",
        debug_name: "EuropeSamara",
        bytes: bytes::EuropeSamara,
        parsed: &parsed::EuropeSamara,
    };

    /// Europe/San_Marino,
    pub static EuropeSanMarino: &DbTimeZone = EuropeRome;

    /// Europe/Sarajevo,
    pub static EuropeSarajevo: &DbTimeZone = EuropeBelgrade;

    /// Europe/Saratov,
    pub static EuropeSaratov: &DbTimeZone = &DbTimeZone {
        index: 300,
        name: "Europe/Saratov",
        debug_name: "EuropeSaratov",
        bytes: bytes::EuropeSaratov,
        parsed: &parsed::EuropeSaratov,
    };

    /// Europe/Simferopol,
    pub static EuropeSimferopol: &DbTimeZone = &DbTimeZone {
        index: 301,
        name: "Europe/Simferopol",
        debug_name: "EuropeSimferopol",
        bytes: bytes::EuropeSimferopol,
        parsed: &parsed::EuropeSimferopol,
    };

    /// Europe/Skopje,
    pub static EuropeSkopje: &DbTimeZone = EuropeBelgrade;

    /// Europe/Sofia,
    pub static EuropeSofia: &DbTimeZone = &DbTimeZone {
        index: 302,
        name: "Europe/Sofia",
        debug_name: "EuropeSofia",
        bytes: bytes::EuropeSofia,
        parsed: &parsed::EuropeSofia,
    };

    /// Europe/Stockholm,
    pub static EuropeStockholm: &DbTimeZone = &DbTimeZone {
        index: 303,
        name: "Europe/Stockholm",
        debug_name: "EuropeStockholm",
        bytes: bytes::EuropeStockholm,
        parsed: &parsed::EuropeStockholm,
    };

    /// Europe/Tallinn,
    pub static EuropeTallinn: &DbTimeZone = &DbTimeZone {
        index: 304,
        name: "Europe/Tallinn",
        debug_name: "EuropeTallinn",
        bytes: bytes::EuropeTallinn,
        parsed: &parsed::EuropeTallinn,
    };

    /// Europe/Tirane,
    pub static EuropeTirane: &DbTimeZone = &DbTimeZone {
        index: 305,
        name: "Europe/Tirane",
        debug_name: "EuropeTirane",
        bytes: bytes::EuropeTirane,
        parsed: &parsed::EuropeTirane,
    };

    /// Europe/Tiraspol,
    pub static EuropeTiraspol: &DbTimeZone = EuropeChisinau;

    /// Europe/Ulyanovsk,
    pub static EuropeUlyanovsk: &DbTimeZone = &DbTimeZone {
        index: 306,
        name: "Europe/Ulyanovsk",
        debug_name: "EuropeUlyanovsk",
        bytes: bytes::EuropeUlyanovsk,
        parsed: &parsed::EuropeUlyanovsk,
    };

    /// Europe/Uzhgorod,
    pub static EuropeUzhgorod: &DbTimeZone = &DbTimeZone {
        index: 307,
        name: "Europe/Uzhgorod",
        debug_name: "EuropeUzhgorod",
        bytes: bytes::EuropeUzhgorod,
        parsed: &parsed::EuropeUzhgorod,
    };

    /// Europe/Vaduz,
    pub static EuropeVaduz: &DbTimeZone = EuropeBusingen;

    /// Europe/Vatican,
    pub static EuropeVatican: &DbTimeZone = EuropeRome;

    /// Europe/Vienna,
    pub static EuropeVienna: &DbTimeZone = &DbTimeZone {
        index: 308,
        name: "Europe/Vienna",
        debug_name: "EuropeVienna",
        bytes: bytes::EuropeVienna,
        parsed: &parsed::EuropeVienna,
    };

    /// Europe/Vilnius,
    pub static EuropeVilnius: &DbTimeZone = &DbTimeZone {
        index: 309,
        name: "Europe/Vilnius",
        debug_name: "EuropeVilnius",
        bytes: bytes::EuropeVilnius,
        parsed: &parsed::EuropeVilnius,
    };

    /// Europe/Volgograd,
    pub static EuropeVolgograd: &DbTimeZone = &DbTimeZone {
        index: 310,
        name: "Europe/Volgograd",
        debug_name: "EuropeVolgograd",
        bytes: bytes::EuropeVolgograd,
        parsed: &parsed::EuropeVolgograd,
    };

    /// Europe/Warsaw,
    pub static EuropeWarsaw: &DbTimeZone = &DbTimeZone {
        index: 311,
        name: "Europe/Warsaw",
        debug_name: "EuropeWarsaw",
        bytes: bytes::EuropeWarsaw,
        parsed: &parsed::EuropeWarsaw,
    };

    /// Europe/Zagreb,
    pub static EuropeZagreb: &DbTimeZone = EuropeBelgrade;

    /// Europe/Zaporozhye,
    pub static EuropeZaporozhye: &DbTimeZone = &DbTimeZone {
        index: 312,
        name: "Europe/Zaporozhye",
        debug_name: "EuropeZaporozhye",
        bytes: bytes::EuropeZaporozhye,
        parsed: &parsed::EuropeZaporozhye,
    };

    /// Europe/Zurich,
    pub static EuropeZurich: &DbTimeZone = EuropeBusingen;

    /// Factory,
    pub static Factory: &DbTimeZone = &DbTimeZone {
        index: 313,
        name: "Factory",
        debug_name: "Factory",
        bytes: bytes::Factory,
        parsed: &parsed::Factory,
    };

    /// GB,
    pub static Gb: &DbTimeZone = EuropeBelfast;

    /// GB-Eire,
    pub static GbEire: &DbTimeZone = EuropeBelfast;

    /// GMT,
    pub static Gmt: &DbTimeZone = EtcGmt;

    /// GMT0,
    pub static Gmt0: &DbTimeZone = EtcGmt;

    /// GMT-0,
    pub static GmtMinus0: &DbTimeZone = EtcGmt;

    /// GMT+0,
    pub static GmtPlus0: &DbTimeZone = EtcGmt;

    /// Greenwich,
    pub static Greenwich: &DbTimeZone = EtcGmt;

    /// Hongkong,
    pub static Hongkong: &DbTimeZone = AsiaHongKong;

    /// HST,
    pub static Hst: &DbTimeZone = &DbTimeZone {
        index: 314,
        name: "HST",
        debug_name: "Hst",
        bytes: bytes::Hst,
        parsed: &parsed::Hst,
    };

    /// Iceland,
    pub static Iceland: &DbTimeZone = AtlanticReykjavik;

    /// Indian/Antananarivo,
    pub static IndianAntananarivo: &DbTimeZone = AfricaAddisAbaba;

    /// Indian/Chagos,
    pub static IndianChagos: &DbTimeZone = &DbTimeZone {
        index: 315,
        name: "Indian/Chagos",
        debug_name: "IndianChagos",
        bytes: bytes::IndianChagos,
        parsed: &parsed::IndianChagos,
    };

    /// Indian/Christmas,
    pub static IndianChristmas: &DbTimeZone = &DbTimeZone {
        index: 316,
        name: "Indian/Christmas",
        debug_name: "IndianChristmas",
        bytes: bytes::IndianChristmas,
        parsed: &parsed::IndianChristmas,
    };

    /// Indian/Cocos,
    pub static IndianCocos: &DbTimeZone = &DbTimeZone {
        index: 317,
        name: "Indian/Cocos",
        debug_name: "IndianCocos",
        bytes: bytes::IndianCocos,
        parsed: &parsed::IndianCocos,
    };

    /// Indian/Comoro,
    pub static IndianComoro: &DbTimeZone = AfricaAddisAbaba;

    /// Indian/Kerguelen,
    pub static IndianKerguelen: &DbTimeZone = &DbTimeZone {
        index: 318,
        name: "Indian/Kerguelen",
        debug_name: "IndianKerguelen",
        bytes: bytes::IndianKerguelen,
        parsed: &parsed::IndianKerguelen,
    };

    /// Indian/Mahe,
    pub static IndianMahe: &DbTimeZone = &DbTimeZone {
        index: 319,
        name: "Indian/Mahe",
        debug_name: "IndianMahe",
        bytes: bytes::IndianMahe,
        parsed: &parsed::IndianMahe,
    };

    /// Indian/Maldives,
    pub static IndianMaldives: &DbTimeZone = &DbTimeZone {
        index: 320,
        name: "Indian/Maldives",
        debug_name: "IndianMaldives",
        bytes: bytes::IndianMaldives,
        parsed: &parsed::IndianMaldives,
    };

    /// Indian/Mauritius,
    pub static IndianMauritius: &DbTimeZone = &DbTimeZone {
        index: 321,
        name: "Indian/Mauritius",
        debug_name: "IndianMauritius",
        bytes: bytes::IndianMauritius,
        parsed: &parsed::IndianMauritius,
    };

    /// Indian/Mayotte,
    pub static IndianMayotte: &DbTimeZone = AfricaAddisAbaba;

    /// Indian/Reunion,
    pub static IndianReunion: &DbTimeZone = &DbTimeZone {
        index: 322,
        name: "Indian/Reunion",
        debug_name: "IndianReunion",
        bytes: bytes::IndianReunion,
        parsed: &parsed::IndianReunion,
    };

    /// Iran,
    pub static Iran: &DbTimeZone = AsiaTehran;

    /// Israel,
    pub static Israel: &DbTimeZone = AsiaJerusalem;

    /// Jamaica,
    pub static Jamaica: &DbTimeZone = AmericaJamaica;

    /// Japan,
    pub static Japan: &DbTimeZone = AsiaTokyo;

    /// Kwajalein,
    pub static Kwajalein: &DbTimeZone = &DbTimeZone {
        index: 323,
        name: "Kwajalein",
        debug_name: "Kwajalein",
        bytes: bytes::Kwajalein,
        parsed: &parsed::Kwajalein,
    };

    /// Libya,
    pub static Libya: &DbTimeZone = AfricaTripoli;

    /// MET,
    pub static Met: &DbTimeZone = &DbTimeZone {
        index: 324,
        name: "MET",
        debug_name: "Met",
        bytes: bytes::Met,
        parsed: &parsed::Met,
    };

    /// Mexico/BajaNorte,
    pub static MexicoBajaNorte: &DbTimeZone = AmericaEnsenada;

    /// Mexico/BajaSur,
    pub static MexicoBajaSur: &DbTimeZone = AmericaMazatlan;

    /// Mexico/General,
    pub static MexicoGeneral: &DbTimeZone = AmericaMexicoCity;

    /// MST,
    pub static Mst: &DbTimeZone = &DbTimeZone {
        index: 325,
        name: "MST",
        debug_name: "Mst",
        bytes: bytes::Mst,
        parsed: &parsed::Mst,
    };

    /// MST7MDT,
    pub static Mst7Mdt: &DbTimeZone = &DbTimeZone {
        index: 326,
        name: "MST7MDT",
        debug_name: "Mst7Mdt",
        bytes: bytes::Mst7Mdt,
        parsed: &parsed::Mst7Mdt,
    };

    /// Navajo,
    pub static Navajo: &DbTimeZone = AmericaDenver;

    /// NZ,
    pub static Nz: &DbTimeZone = AntarcticaMcMurdo;

    /// NZ-CHAT,
    pub static NzChat: &DbTimeZone = &DbTimeZone {
        index: 327,
        name: "NZ-CHAT",
        debug_name: "NzChat",
        bytes: bytes::NzChat,
        parsed: &parsed::NzChat,
    };

    /// Pacific/Apia,
    pub static PacificApia: &DbTimeZone = &DbTimeZone {
        index: 328,
        name: "Pacific/Apia",
        debug_name: "PacificApia",
        bytes: bytes::PacificApia,
        parsed: &parsed::PacificApia,
    };

    /// Pacific/Auckland,
    pub static PacificAuckland: &DbTimeZone = AntarcticaMcMurdo;

    /// Pacific/Bougainville,
    pub static PacificBougainville: &DbTimeZone = &DbTimeZone {
        index: 329,
        name: "Pacific/Bougainville",
        debug_name: "PacificBougainville",
        bytes: bytes::PacificBougainville,
        parsed: &parsed::PacificBougainville,
    };

    /// Pacific/Chatham,
    pub static PacificChatham: &DbTimeZone = NzChat;

    /// Pacific/Chuuk,
    pub static PacificChuuk: &DbTimeZone = &DbTimeZone {
        index: 330,
        name: "Pacific/Chuuk",
        debug_name: "PacificChuuk",
        bytes: bytes::PacificChuuk,
        parsed: &parsed::PacificChuuk,
    };

    /// Pacific/Easter,
    pub static PacificEaster: &DbTimeZone = ChileEasterIsland;

    /// Pacific/Efate,
    pub static PacificEfate: &DbTimeZone = &DbTimeZone {
        index: 331,
        name: "Pacific/Efate",
        debug_name: "PacificEfate",
        bytes: bytes::PacificEfate,
        parsed: &parsed::PacificEfate,
    };

    /// Pacific/Enderbury,
    pub static PacificEnderbury: &DbTimeZone = &DbTimeZone {
        index: 332,
        name: "Pacific/Enderbury",
        debug_name: "PacificEnderbury",
        bytes: bytes::PacificEnderbury,
        parsed: &parsed::PacificEnderbury,
    };

    /// Pacific/Fakaofo,
    pub static PacificFakaofo: &DbTimeZone = &DbTimeZone {
        index: 333,
        name: "Pacific/Fakaofo",
        debug_name: "PacificFakaofo",
        bytes: bytes::PacificFakaofo,
        parsed: &parsed::PacificFakaofo,
    };

    /// Pacific/Fiji,
    pub static PacificFiji: &DbTimeZone = &DbTimeZone {
        index: 334,
        name: "Pacific/Fiji",
        debug_name: "PacificFiji",
        bytes: bytes::PacificFiji,
        parsed: &parsed::PacificFiji,
    };

    /// Pacific/Funafuti,
    pub static PacificFunafuti: &DbTimeZone = &DbTimeZone {
        index: 335,
        name: "Pacific/Funafuti",
        debug_name: "PacificFunafuti",
        bytes: bytes::PacificFunafuti,
        parsed: &parsed::PacificFunafuti,
    };

    /// Pacific/Galapagos,
    pub static PacificGalapagos: &DbTimeZone = &DbTimeZone {
        index: 336,
        name: "Pacific/Galapagos",
        debug_name: "PacificGalapagos",
        bytes: bytes::PacificGalapagos,
        parsed: &parsed::PacificGalapagos,
    };

    /// Pacific/Gambier,
    pub static PacificGambier: &DbTimeZone = &DbTimeZone {
        index: 337,
        name: "Pacific/Gambier",
        debug_name: "PacificGambier",
        bytes: bytes::PacificGambier,
        parsed: &parsed::PacificGambier,
    };

    /// Pacific/Guadalcanal,
    pub static PacificGuadalcanal: &DbTimeZone = &DbTimeZone {
        index: 338,
        name: "Pacific/Guadalcanal",
        debug_name: "PacificGuadalcanal",
        bytes: bytes::PacificGuadalcanal,
        parsed: &parsed::PacificGuadalcanal,
    };

    /// Pacific/Guam,
    pub static PacificGuam: &DbTimeZone = &DbTimeZone {
        index: 339,
        name: "Pacific/Guam",
        debug_name: "PacificGuam",
        bytes: bytes::PacificGuam,
        parsed: &parsed::PacificGuam,
    };

    /// Pacific/Honolulu,
    pub static PacificHonolulu: &DbTimeZone = &DbTimeZone {
        index: 340,
        name: "Pacific/Honolulu",
        debug_name: "PacificHonolulu",
        bytes: bytes::PacificHonolulu,
        parsed: &parsed::PacificHonolulu,
    };

    /// Pacific/Johnston,
    pub static PacificJohnston: &DbTimeZone = PacificHonolulu;

    /// Pacific/Kanton,
    pub static PacificKanton: &DbTimeZone = PacificEnderbury;

    /// Pacific/Kiritimati,
    pub static PacificKiritimati: &DbTimeZone = &DbTimeZone {
        index: 341,
        name: "Pacific/Kiritimati",
        debug_name: "PacificKiritimati",
        bytes: bytes::PacificKiritimati,
        parsed: &parsed::PacificKiritimati,
    };

    /// Pacific/Kosrae,
    pub static PacificKosrae: &DbTimeZone = &DbTimeZone {
        index: 342,
        name: "Pacific/Kosrae",
        debug_name: "PacificKosrae",
        bytes: bytes::PacificKosrae,
        parsed: &parsed::PacificKosrae,
    };

    /// Pacific/Kwajalein,
    pub static PacificKwajalein: &DbTimeZone = Kwajalein;

    /// Pacific/Majuro,
    pub static PacificMajuro: &DbTimeZone = &DbTimeZone {
        index: 343,
        name: "Pacific/Majuro",
        debug_name: "PacificMajuro",
        bytes: bytes::PacificMajuro,
        parsed: &parsed::PacificMajuro,
    };

    /// Pacific/Marquesas,
    pub static PacificMarquesas: &DbTimeZone = &DbTimeZone {
        index: 344,
        name: "Pacific/Marquesas",
        debug_name: "PacificMarquesas",
        bytes: bytes::PacificMarquesas,
        parsed: &parsed::PacificMarquesas,
    };

    /// Pacific/Midway,
    pub static PacificMidway: &DbTimeZone = &DbTimeZone {
        index: 345,
        name: "Pacific/Midway",
        debug_name: "PacificMidway",
        bytes: bytes::PacificMidway,
        parsed: &parsed::PacificMidway,
    };

    /// Pacific/Nauru,
    pub static PacificNauru: &DbTimeZone = &DbTimeZone {
        index: 346,
        name: "Pacific/Nauru",
        debug_name: "PacificNauru",
        bytes: bytes::PacificNauru,
        parsed: &parsed::PacificNauru,
    };

    /// Pacific/Niue,
    pub static PacificNiue: &DbTimeZone = &DbTimeZone {
        index: 347,
        name: "Pacific/Niue",
        debug_name: "PacificNiue",
        bytes: bytes::PacificNiue,
        parsed: &parsed::PacificNiue,
    };

    /// Pacific/Norfolk,
    pub static PacificNorfolk: &DbTimeZone = &DbTimeZone {
        index: 348,
        name: "Pacific/Norfolk",
        debug_name: "PacificNorfolk",
        bytes: bytes::PacificNorfolk,
        parsed: &parsed::PacificNorfolk,
    };

    /// Pacific/Noumea,
    pub static PacificNoumea: &DbTimeZone = &DbTimeZone {
        index: 349,
        name: "Pacific/Noumea",
        debug_name: "PacificNoumea",
        bytes: bytes::PacificNoumea,
        parsed: &parsed::PacificNoumea,
    };

    /// Pacific/Pago_Pago,
    pub static PacificPagoPago: &DbTimeZone = PacificMidway;

    /// Pacific/Palau,
    pub static PacificPalau: &DbTimeZone = &DbTimeZone {
        index: 350,
        name: "Pacific/Palau",
        debug_name: "PacificPalau",
        bytes: bytes::PacificPalau,
        parsed: &parsed::PacificPalau,
    };

    /// Pacific/Pitcairn,
    pub static PacificPitcairn: &DbTimeZone = &DbTimeZone {
        index: 351,
        name: "Pacific/Pitcairn",
        debug_name: "PacificPitcairn",
        bytes: bytes::PacificPitcairn,
        parsed: &parsed::PacificPitcairn,
    };

    /// Pacific/Pohnpei,
    pub static PacificPohnpei: &DbTimeZone = &DbTimeZone {
        index: 352,
        name: "Pacific/Pohnpei",
        debug_name: "PacificPohnpei",
        bytes: bytes::PacificPohnpei,
        parsed: &parsed::PacificPohnpei,
    };

    /// Pacific/Ponape,
    pub static PacificPonape: &DbTimeZone = PacificPohnpei;

    /// Pacific/Port_Moresby,
    pub static PacificPortMoresby: &DbTimeZone = AntarcticaDumontDUrville;

    /// Pacific/Rarotonga,
    pub static PacificRarotonga: &DbTimeZone = &DbTimeZone {
        index: 353,
        name: "Pacific/Rarotonga",
        debug_name: "PacificRarotonga",
        bytes: bytes::PacificRarotonga,
        parsed: &parsed::PacificRarotonga,
    };

    /// Pacific/Saipan,
    pub static PacificSaipan: &DbTimeZone = PacificGuam;

    /// Pacific/Samoa,
    pub static PacificSamoa: &DbTimeZone = PacificMidway;

    /// Pacific/Tahiti,
    pub static PacificTahiti: &DbTimeZone = &DbTimeZone {
        index: 354,
        name: "Pacific/Tahiti",
        debug_name: "PacificTahiti",
        bytes: bytes::PacificTahiti,
        parsed: &parsed::PacificTahiti,
    };

    /// Pacific/Tarawa,
    pub static PacificTarawa: &DbTimeZone = &DbTimeZone {
        index: 355,
        name: "Pacific/Tarawa",
        debug_name: "PacificTarawa",
        bytes: bytes::PacificTarawa,
        parsed: &parsed::PacificTarawa,
    };

    /// Pacific/Tongatapu,
    pub static PacificTongatapu: &DbTimeZone = &DbTimeZone {
        index: 356,
        name: "Pacific/Tongatapu",
        debug_name: "PacificTongatapu",
        bytes: bytes::PacificTongatapu,
        parsed: &parsed::PacificTongatapu,
    };

    /// Pacific/Truk,
    pub static PacificTruk: &DbTimeZone = PacificChuuk;

    /// Pacific/Wake,
    pub static PacificWake: &DbTimeZone = &DbTimeZone {
        index: 357,
        name: "Pacific/Wake",
        debug_name: "PacificWake",
        bytes: bytes::PacificWake,
        parsed: &parsed::PacificWake,
    };

    /// Pacific/Wallis,
    pub static PacificWallis: &DbTimeZone = &DbTimeZone {
        index: 358,
        name: "Pacific/Wallis",
        debug_name: "PacificWallis",
        bytes: bytes::PacificWallis,
        parsed: &parsed::PacificWallis,
    };

    /// Pacific/Yap,
    pub static PacificYap: &DbTimeZone = PacificChuuk;

    /// Poland,
    pub static Poland: &DbTimeZone = EuropeWarsaw;

    /// Portugal,
    pub static Portugal: &DbTimeZone = EuropeLisbon;

    /// PRC,
    pub static Prc: &DbTimeZone = AsiaChongqing;

    /// PST8PDT,
    pub static Pst8Pdt: &DbTimeZone = &DbTimeZone {
        index: 359,
        name: "PST8PDT",
        debug_name: "Pst8Pdt",
        bytes: bytes::Pst8Pdt,
        parsed: &parsed::Pst8Pdt,
    };

    /// ROC,
    pub static Roc: &DbTimeZone = AsiaTaipei;

    /// ROK,
    pub static Rok: &DbTimeZone = AsiaSeoul;

    /// Singapore,
    pub static Singapore: &DbTimeZone = AsiaSingapore;

    /// Turkey,
    pub static Turkey: &DbTimeZone = AsiaIstanbul;

    /// UCT,
    pub static Uct: &DbTimeZone = EtcUct;

    /// Universal,
    pub static Universal: &DbTimeZone = EtcUct;

    /// US/Alaska,
    pub static UsAlaska: &DbTimeZone = AmericaAnchorage;

    /// US/Aleutian,
    pub static UsAleutian: &DbTimeZone = AmericaAdak;

    /// US/Arizona,
    pub static UsArizona: &DbTimeZone = AmericaCreston;

    /// US/Central,
    pub static UsCentral: &DbTimeZone = AmericaChicago;

    /// US/East-Indiana,
    pub static UsEastIndiana: &DbTimeZone = AmericaFortWayne;

    /// US/Eastern,
    pub static UsEastern: &DbTimeZone = AmericaNewYork;

    /// US/Hawaii,
    pub static UsHawaii: &DbTimeZone = PacificHonolulu;

    /// US/Indiana-Starke,
    pub static UsIndianaStarke: &DbTimeZone = AmericaKnoxIn;

    /// US/Michigan,
    pub static UsMichigan: &DbTimeZone = AmericaDetroit;

    /// US/Mountain,
    pub static UsMountain: &DbTimeZone = AmericaDenver;

    /// US/Pacific,
    pub static UsPacific: &DbTimeZone = AmericaLosAngeles;

    /// US/Samoa,
    pub static UsSamoa: &DbTimeZone = PacificMidway;

    /// UTC,
    pub static Utc: &DbTimeZone = EtcUct;

    /// W-SU,
    pub static WSu: &DbTimeZone = EuropeMoscow;

    /// WET,
    pub static Wet: &DbTimeZone = &DbTimeZone {
        index: 360,
        name: "WET",
        debug_name: "Wet",
        bytes: bytes::Wet,
        parsed: &parsed::Wet,
    };

    /// Zulu,
    pub static Zulu: &DbTimeZone = EtcUct;
}

pub(crate) fn tz_by_name(s: &str) -> Option<&'static DbTimeZone> {
    Some(*TIME_ZONES_BY_NAME.get(Lower32([0u64; 4]).for_str(s)?)?)
}

static TIME_ZONES_BY_NAME: phf::Map<&'static str, &'static DbTimeZone> = ::phf::Map {
    key: 12913932095322966823,
    disps: &[
        (0, 51),
        (0, 1),
        (0, 3),
        (0, 3),
        (0, 49),
        (0, 20),
        (0, 72),
        (0, 0),
        (0, 3),
        (0, 17),
        (0, 37),
        (0, 220),
        (0, 38),
        (0, 114),
        (3, 3),
        (0, 426),
        (0, 69),
        (0, 13),
        (0, 406),
        (0, 27),
        (0, 3),
        (0, 63),
        (0, 2),
        (0, 0),
        (0, 80),
        (1, 0),
        (1, 143),
        (0, 48),
        (0, 238),
        (0, 146),
        (0, 0),
        (0, 290),
        (0, 20),
        (0, 1),
        (0, 25),
        (2, 386),
        (0, 174),
        (0, 17),
        (0, 6),
        (0, 9),
        (0, 2),
        (0, 8),
        (0, 18),
        (6, 343),
        (0, 251),
        (0, 20),
        (0, 51),
        (0, 213),
        (0, 107),
        (0, 224),
        (0, 76),
        (0, 86),
        (0, 279),
        (0, 102),
        (4, 519),
        (1, 359),
        (0, 240),
        (4, 118),
        (2, 434),
        (0, 32),
        (0, 194),
        (4, 488),
        (0, 223),
        (0, 7),
        (0, 493),
        (0, 419),
        (0, 0),
        (0, 0),
        (1, 122),
        (0, 29),
        (0, 30),
        (0, 376),
        (0, 60),
        (0, 22),
        (0, 111),
        (0, 10),
        (0, 11),
        (8, 118),
        (0, 56),
        (4, 243),
        (0, 302),
        (0, 16),
        (0, 6),
        (9, 387),
        (1, 142),
        (0, 2),
        (0, 3),
        (6, 231),
        (5, 527),
        (0, 77),
        (0, 3),
        (2, 169),
        (0, 90),
        (4, 15),
        (0, 4),
        (2, 493),
        (1, 342),
        (0, 3),
        (23, 250),
        (7, 127),
        (1, 320),
        (0, 3),
        (0, 0),
        (57, 89),
        (6, 75),
        (23, 38),
        (0, 7),
        (0, 20),
        (0, 306),
        (3, 244),
        (1, 282),
        (0, 113),
        (0, 4),
        (0, 4),
    ],
    entries: &[
        ("europe/istanbul", time_zone::AsiaIstanbul),
        ("etc/gmt+1", time_zone::EtcGmtPlus1),
        ("asia/novokuznetsk", time_zone::AsiaNovokuznetsk),
        ("africa/sao_tome", time_zone::AfricaSaoTome),
        ("europe/minsk", time_zone::EuropeMinsk),
        ("america/guadeloupe", time_zone::AmericaAnguilla),
        ("america/dawson_creek", time_zone::AmericaDawsonCreek),
        ("antarctica/vostok", time_zone::AntarcticaVostok),
        ("europe/budapest", time_zone::EuropeBudapest),
        ("america/nuuk", time_zone::AmericaGodthab),
        ("asia/aqtau", time_zone::AsiaAqtau),
        ("cuba", time_zone::AmericaHavana),
        ("america/mexico_city", time_zone::AmericaMexicoCity),
        ("europe/london", time_zone::EuropeBelfast),
        ("america/aruba", time_zone::AmericaAnguilla),
        ("america/la_paz", time_zone::AmericaLaPaz),
        ("asia/thimbu", time_zone::AsiaThimbu),
        ("antarctica/south_pole", time_zone::AntarcticaMcMurdo),
        ("est5edt", time_zone::Est5Edt),
        ("america/araguaina", time_zone::AmericaAraguaina),
        ("asia/colombo", time_zone::AsiaColombo),
        ("europe/lisbon", time_zone::EuropeLisbon),
        ("africa/algiers", time_zone::AfricaAlgiers),
        ("nz-chat", time_zone::NzChat),
        ("africa/cairo", time_zone::AfricaCairo),
        ("asia/barnaul", time_zone::AsiaBarnaul),
        ("asia/hong_kong", time_zone::AsiaHongKong),
        ("america/port_of_spain", time_zone::AmericaAnguilla),
        ("america/tegucigalpa", time_zone::AmericaTegucigalpa),
        ("us/central", time_zone::AmericaChicago),
        ("pacific/guam", time_zone::PacificGuam),
        ("africa/abidjan", time_zone::AfricaAbidjan),
        ("europe/copenhagen", time_zone::EuropeCopenhagen),
        ("america/nipigon", time_zone::AmericaNipigon),
        ("etc/gmt+4", time_zone::EtcGmtPlus4),
        ("pacific/efate", time_zone::PacificEfate),
        ("pacific/palau", time_zone::PacificPalau),
        ("arctic/longyearbyen", time_zone::ArcticLongyearbyen),
        ("america/creston", time_zone::AmericaCreston),
        ("asia/tomsk", time_zone::AsiaTomsk),
        ("etc/gmt+12", time_zone::EtcGmtPlus12),
        ("wet", time_zone::Wet),
        ("america/fortaleza", time_zone::AmericaFortaleza),
        ("etc/greenwich", time_zone::EtcGmt),
        ("etc/gmt-9", time_zone::EtcGmtMinus9),
        ("europe/mariehamn", time_zone::EuropeHelsinki),
        ("america/monterrey", time_zone::AmericaMonterrey),
        ("europe/belfast", time_zone::EuropeBelfast),
        ("pacific/yap", time_zone::PacificChuuk),
        ("asia/jayapura", time_zone::AsiaJayapura),
        ("asia/qyzylorda", time_zone::AsiaQyzylorda),
        ("etc/gmt-3", time_zone::EtcGmtMinus3),
        ("america/hermosillo", time_zone::AmericaHermosillo),
        ("pacific/samoa", time_zone::PacificMidway),
        ("asia/srednekolymsk", time_zone::AsiaSrednekolymsk),
        ("america/guatemala", time_zone::AmericaGuatemala),
        ("europe/ulyanovsk", time_zone::EuropeUlyanovsk),
        ("america/paramaribo", time_zone::AmericaParamaribo),
        ("asia/hebron", time_zone::AsiaHebron),
        ("asia/kamchatka", time_zone::AsiaKamchatka),
        ("america/belem", time_zone::AmericaBelem),
        ("asia/kuala_lumpur", time_zone::AsiaKualaLumpur),
        ("pacific/niue", time_zone::PacificNiue),
        ("america/ojinaga", time_zone::AmericaOjinaga),
        ("asia/kuwait", time_zone::AntarcticaSyowa),
        ("us/arizona", time_zone::AmericaCreston),
        ("america/atikokan", time_zone::AmericaAtikokan),
        ("asia/katmandu", time_zone::AsiaKathmandu),
        ("europe/zagreb", time_zone::EuropeBelgrade),
        ("africa/harare", time_zone::AfricaBlantyre),
        ("hongkong", time_zone::AsiaHongKong),
        ("america/yellowknife", time_zone::AmericaYellowknife),
        ("asia/nicosia", time_zone::AsiaNicosia),
        ("africa/luanda", time_zone::AfricaBangui),
        ("asia/kabul", time_zone::AsiaKabul),
        ("africa/el_aaiun", time_zone::AfricaElAaiun),
        ("europe/kaliningrad", time_zone::EuropeKaliningrad),
        ("asia/macau", time_zone::AsiaMacao),
        ("pacific/saipan", time_zone::PacificGuam),
        ("europe/oslo", time_zone::ArcticLongyearbyen),
        ("australia/melbourne", time_zone::AustraliaMelbourne),
        ("australia/lhi", time_zone::AustraliaLhi),
        ("us/aleutian", time_zone::AmericaAdak),
        ("met", time_zone::Met),
        ("europe/san_marino", time_zone::EuropeRome),
        ("asia/brunei", time_zone::AsiaBrunei),
        ("poland", time_zone::EuropeWarsaw),
        ("africa/johannesburg", time_zone::AfricaJohannesburg),
        ("asia/ujung_pandang", time_zone::AsiaMakassar),
        ("asia/chita", time_zone::AsiaChita),
        ("etc/gmt-8", time_zone::EtcGmtMinus8),
        ("asia/seoul", time_zone::AsiaSeoul),
        ("pacific/tahiti", time_zone::PacificTahiti),
        ("africa/dakar", time_zone::AfricaAbidjan),
        ("pst8pdt", time_zone::Pst8Pdt),
        ("australia/lindeman", time_zone::AustraliaLindeman),
        ("australia/darwin", time_zone::AustraliaDarwin),
        ("pacific/funafuti", time_zone::PacificFunafuti),
        ("atlantic/jan_mayen", time_zone::ArcticLongyearbyen),
        ("portugal", time_zone::EuropeLisbon),
        ("pacific/galapagos", time_zone::PacificGalapagos),
        ("africa/gaborone", time_zone::AfricaBlantyre),
        ("asia/tokyo", time_zone::AsiaTokyo),
        ("africa/maseru", time_zone::AfricaJohannesburg),
        ("us/michigan", time_zone::AmericaDetroit),
        ("etc/gmt+2", time_zone::EtcGmtPlus2),
        ("america/manaus", time_zone::AmericaManaus),
        ("antarctica/syowa", time_zone::AntarcticaSyowa),
        ("asia/chongqing", time_zone::AsiaChongqing),
        ("us/alaska", time_zone::AmericaAnchorage),
        ("jamaica", time_zone::AmericaJamaica),
        ("mexico/bajasur", time_zone::AmericaMazatlan),
        ("indian/antananarivo", time_zone::AfricaAddisAbaba),
        ("america/bahia", time_zone::AmericaBahia),
        ("navajo", time_zone::AmericaDenver),
        ("canada/eastern", time_zone::AmericaMontreal),
        ("us/samoa", time_zone::PacificMidway),
        ("america/ensenada", time_zone::AmericaEnsenada),
        ("europe/zurich", time_zone::EuropeBusingen),
        ("asia/manila", time_zone::AsiaManila),
        ("europe/busingen", time_zone::EuropeBusingen),
        ("europe/andorra", time_zone::EuropeAndorra),
        ("atlantic/faeroe", time_zone::AtlanticFaeroe),
        ("asia/anadyr", time_zone::AsiaAnadyr),
        ("america/cayenne", time_zone::AmericaCayenne),
        ("america/menominee", time_zone::AmericaMenominee),
        ("america/recife", time_zone::AmericaRecife),
        ("america/rainy_river", time_zone::AmericaRainyRiver),
        ("pacific/enderbury", time_zone::PacificEnderbury),
        ("europe/madrid", time_zone::EuropeMadrid),
        ("america/st_thomas", time_zone::AmericaAnguilla),
        ("etc/gmt-6", time_zone::EtcGmtMinus6),
        ("australia/nsw", time_zone::AustraliaAct),
        ("africa/lubumbashi", time_zone::AfricaBlantyre),
        ("asia/ulan_bator", time_zone::AsiaUlaanbaatar),
        ("australia/north", time_zone::AustraliaDarwin),
        ("etc/gmt+8", time_zone::EtcGmtPlus8),
        ("america/tijuana", time_zone::AmericaEnsenada),
        ("africa/mogadishu", time_zone::AfricaAddisAbaba),
        ("america/inuvik", time_zone::AmericaInuvik),
        ("america/lima", time_zone::AmericaLima),
        ("europe/warsaw", time_zone::EuropeWarsaw),
        ("europe/jersey", time_zone::EuropeBelfast),
        ("asia/qostanay", time_zone::AsiaQostanay),
        ("america/buenos_aires", time_zone::AmericaBuenosAires),
        ("australia/canberra", time_zone::AustraliaAct),
        ("pacific/pitcairn", time_zone::PacificPitcairn),
        ("africa/bissau", time_zone::AfricaBissau),
        ("australia/west", time_zone::AustraliaPerth),
        ("pacific/pago_pago", time_zone::PacificMidway),
        ("pacific/kiritimati", time_zone::PacificKiritimati),
        ("europe/astrakhan", time_zone::EuropeAstrakhan),
        ("america/scoresbysund", time_zone::AmericaScoresbysund),
        ("etc/gmt-0", time_zone::EtcGmt),
        ("canada/central", time_zone::AmericaWinnipeg),
        ("america/swift_current", time_zone::AmericaSwiftCurrent),
        ("pacific/kwajalein", time_zone::Kwajalein),
        ("europe/paris", time_zone::EuropeParis),
        ("africa/casablanca", time_zone::AfricaCasablanca),
        ("europe/podgorica", time_zone::EuropeBelgrade),
        ("israel", time_zone::AsiaJerusalem),
        ("australia/queensland", time_zone::AustraliaBrisbane),
        ("etc/gmt-4", time_zone::EtcGmtMinus4),
        ("america/anguilla", time_zone::AmericaAnguilla),
        ("europe/vaduz", time_zone::EuropeBusingen),
        ("america/jujuy", time_zone::AmericaJujuy),
        ("america/grenada", time_zone::AmericaAnguilla),
        ("america/managua", time_zone::AmericaManagua),
        ("europe/rome", time_zone::EuropeRome),
        ("africa/freetown", time_zone::AfricaAbidjan),
        ("america/bahia_banderas", time_zone::AmericaBahiaBanderas),
        ("gmt0", time_zone::EtcGmt),
        ("canada/atlantic", time_zone::AmericaHalifax),
        ("etc/zulu", time_zone::EtcUct),
        ("america/sao_paulo", time_zone::AmericaSaoPaulo),
        ("europe/tirane", time_zone::EuropeTirane),
        ("europe/belgrade", time_zone::EuropeBelgrade),
        ("asia/macao", time_zone::AsiaMacao),
        ("japan", time_zone::AsiaTokyo),
        ("africa/ouagadougou", time_zone::AfricaAbidjan),
        ("brazil/denoronha", time_zone::AmericaNoronha),
        ("asia/riyadh", time_zone::AntarcticaSyowa),
        ("atlantic/south_georgia", time_zone::AtlanticSouthGeorgia),
        ("europe/brussels", time_zone::EuropeBrussels),
        ("indian/mayotte", time_zone::AfricaAddisAbaba),
        ("america/montserrat", time_zone::AmericaAnguilla),
        ("hst", time_zone::Hst),
        ("america/jamaica", time_zone::AmericaJamaica),
        ("africa/lagos", time_zone::AfricaBangui),
        ("asia/istanbul", time_zone::AsiaIstanbul),
        ("asia/rangoon", time_zone::AsiaRangoon),
        ("america/santiago", time_zone::AmericaSantiago),
        ("asia/harbin", time_zone::AsiaChongqing),
        ("asia/almaty", time_zone::AsiaAlmaty),
        ("europe/zaporozhye", time_zone::EuropeZaporozhye),
        ("america/port-au-prince", time_zone::AmericaPortAuPrince),
        ("australia/perth", time_zone::AustraliaPerth),
        ("america/resolute", time_zone::AmericaResolute),
        ("asia/jakarta", time_zone::AsiaJakarta),
        ("africa/bamako", time_zone::AfricaAbidjan),
        ("america/thunder_bay", time_zone::AmericaThunderBay),
        ("america/detroit", time_zone::AmericaDetroit),
        ("antarctica/casey", time_zone::AntarcticaCasey),
        ("america/blanc-sablon", time_zone::AmericaAnguilla),
        ("asia/khandyga", time_zone::AsiaKhandyga),
        ("asia/choibalsan", time_zone::AsiaChoibalsan),
        ("australia/tasmania", time_zone::AustraliaCurrie),
        ("asia/calcutta", time_zone::AsiaCalcutta),
        ("america/iqaluit", time_zone::AmericaIqaluit),
        ("america/montevideo", time_zone::AmericaMontevideo),
        ("america/havana", time_zone::AmericaHavana),
        ("zulu", time_zone::EtcUct),
        ("europe/dublin", time_zone::Eire),
        ("america/curacao", time_zone::AmericaAnguilla),
        ("america/punta_arenas", time_zone::AmericaPuntaArenas),
        ("pacific/kanton", time_zone::PacificEnderbury),
        ("africa/kigali", time_zone::AfricaBlantyre),
        ("etc/gmt+9", time_zone::EtcGmtPlus9),
        ("europe/moscow", time_zone::EuropeMoscow),
        ("australia/brisbane", time_zone::AustraliaBrisbane),
        ("america/sitka", time_zone::AmericaSitka),
        ("europe/ljubljana", time_zone::EuropeBelgrade),
        ("pacific/rarotonga", time_zone::PacificRarotonga),
        ("europe/vatican", time_zone::EuropeRome),
        ("mexico/bajanorte", time_zone::AmericaEnsenada),
        ("antarctica/mcmurdo", time_zone::AntarcticaMcMurdo),
        ("america/rankin_inlet", time_zone::AmericaRankinInlet),
        ("australia/south", time_zone::AustraliaAdelaide),
        ("europe/vilnius", time_zone::EuropeVilnius),
        ("us/indiana-starke", time_zone::AmericaKnoxIn),
        ("europe/kirov", time_zone::EuropeKirov),
        ("africa/monrovia", time_zone::AfricaMonrovia),
        ("atlantic/stanley", time_zone::AtlanticStanley),
        ("america/juneau", time_zone::AmericaJuneau),
        ("australia/hobart", time_zone::AustraliaCurrie),
        ("greenwich", time_zone::EtcGmt),
        ("asia/damascus", time_zone::AsiaDamascus),
        ("asia/yangon", time_zone::AsiaRangoon),
        ("asia/krasnoyarsk", time_zone::AsiaKrasnoyarsk),
        ("etc/gmt-10", time_zone::EtcGmtMinus10),
        ("america/catamarca", time_zone::AmericaCatamarca),
        ("asia/bishkek", time_zone::AsiaBishkek),
        ("australia/broken_hill", time_zone::AustraliaBrokenHill),
        ("asia/vladivostok", time_zone::AsiaVladivostok),
        ("america/chicago", time_zone::AmericaChicago),
        ("pacific/guadalcanal", time_zone::PacificGuadalcanal),
        ("pacific/wake", time_zone::PacificWake),
        ("pacific/honolulu", time_zone::PacificHonolulu),
        ("etc/gmt-11", time_zone::EtcGmtMinus11),
        ("africa/windhoek", time_zone::AfricaWindhoek),
        ("asia/aden", time_zone::AntarcticaSyowa),
        ("chile/easterisland", time_zone::ChileEasterIsland),
        ("asia/thimphu", time_zone::AsiaThimbu),
        ("europe/skopje", time_zone::EuropeBelgrade),
        ("pacific/tongatapu", time_zone::PacificTongatapu),
        ("pacific/johnston", time_zone::PacificHonolulu),
        ("america/santarem", time_zone::AmericaSantarem),
        ("europe/luxembourg", time_zone::EuropeLuxembourg),
        ("asia/ust-nera", time_zone::AsiaUstNera),
        ("europe/saratov", time_zone::EuropeSaratov),
        ("asia/dhaka", time_zone::AsiaDacca),
        ("america/porto_velho", time_zone::AmericaPortoVelho),
        ("etc/gmt+0", time_zone::EtcGmt),
        ("canada/mountain", time_zone::AmericaEdmonton),
        ("africa/nouakchott", time_zone::AfricaAbidjan),
        ("factory", time_zone::Factory),
        ("america/antigua", time_zone::AmericaAnguilla),
        ("europe/helsinki", time_zone::EuropeHelsinki),
        ("africa/kampala", time_zone::AfricaAddisAbaba),
        ("america/adak", time_zone::AmericaAdak),
        ("asia/gaza", time_zone::AsiaGaza),
        ("america/fort_wayne", time_zone::AmericaFortWayne),
        ("brazil/east", time_zone::AmericaSaoPaulo),
        ("etc/gmt+10", time_zone::EtcGmtPlus10),
        ("africa/brazzaville", time_zone::AfricaBangui),
        ("america/kralendijk", time_zone::AmericaAnguilla),
        ("europe/sofia", time_zone::EuropeSofia),
        ("africa/ndjamena", time_zone::AfricaNdjamena),
        ("asia/baku", time_zone::AsiaBaku),
        ("europe/bucharest", time_zone::EuropeBucharest),
        ("asia/saigon", time_zone::AsiaHoChiMinh),
        ("pacific/fakaofo", time_zone::PacificFakaofo),
        ("asia/yerevan", time_zone::AsiaYerevan),
        ("america/santa_isabel", time_zone::AmericaEnsenada),
        ("indian/kerguelen", time_zone::IndianKerguelen),
        ("asia/famagusta", time_zone::AsiaFamagusta),
        ("etc/uct", time_zone::EtcUct),
        ("africa/accra", time_zone::AfricaAbidjan),
        ("america/guayaquil", time_zone::AmericaGuayaquil),
        ("asia/kashgar", time_zone::AsiaKashgar),
        ("america/rio_branco", time_zone::AmericaPortoAcre),
        ("gmt+0", time_zone::EtcGmt),
        ("asia/bahrain", time_zone::AsiaBahrain),
        ("eire", time_zone::Eire),
        ("pacific/majuro", time_zone::PacificMajuro),
        ("etc/gmt0", time_zone::EtcGmt),
        ("america/mendoza", time_zone::AmericaMendoza),
        ("pacific/bougainville", time_zone::PacificBougainville),
        ("indian/mahe", time_zone::IndianMahe),
        ("mst", time_zone::Mst),
        ("europe/monaco", time_zone::EuropeMonaco),
        ("australia/yancowinna", time_zone::AustraliaBrokenHill),
        ("asia/pontianak", time_zone::AsiaPontianak),
        ("america/vancouver", time_zone::AmericaVancouver),
        ("antarctica/palmer", time_zone::AntarcticaPalmer),
        ("antarctica/davis", time_zone::AntarcticaDavis),
        ("australia/currie", time_zone::AustraliaCurrie),
        ("asia/muscat", time_zone::AsiaDubai),
        ("singapore", time_zone::AsiaSingapore),
        ("europe/amsterdam", time_zone::EuropeAmsterdam),
        ("pacific/apia", time_zone::PacificApia),
        ("asia/novosibirsk", time_zone::AsiaNovosibirsk),
        ("america/cambridge_bay", time_zone::AmericaCambridgeBay),
        ("africa/ceuta", time_zone::AfricaCeuta),
        ("us/east-indiana", time_zone::AmericaFortWayne),
        ("america/rosario", time_zone::AmericaCordoba),
        ("africa/lome", time_zone::AfricaAbidjan),
        ("europe/riga", time_zone::EuropeRiga),
        ("africa/nairobi", time_zone::AfricaAddisAbaba),
        ("europe/nicosia", time_zone::AsiaNicosia),
        ("africa/banjul", time_zone::AfricaAbidjan),
        ("antarctica/troll", time_zone::AntarcticaTroll),
        ("europe/tallinn", time_zone::EuropeTallinn),
        ("asia/baghdad", time_zone::AsiaBaghdad),
        ("mexico/general", time_zone::AmericaMexicoCity),
        ("africa/addis_ababa", time_zone::AfricaAddisAbaba),
        ("asia/singapore", time_zone::AsiaSingapore),
        ("atlantic/madeira", time_zone::AtlanticMadeira),
        ("america/mazatlan", time_zone::AmericaMazatlan),
        ("america/st_johns", time_zone::AmericaStJohns),
        ("europe/chisinau", time_zone::EuropeChisinau),
        ("america/goose_bay", time_zone::AmericaGooseBay),
        ("america/nassau", time_zone::AmericaMontreal),
        ("america/coral_harbour", time_zone::AmericaAtikokan),
        ("america/grand_turk", time_zone::AmericaGrandTurk),
        ("africa/djibouti", time_zone::AfricaAddisAbaba),
        ("australia/adelaide", time_zone::AustraliaAdelaide),
        ("asia/tashkent", time_zone::AsiaTashkent),
        ("europe/bratislava", time_zone::EuropeBratislava),
        ("us/hawaii", time_zone::PacificHonolulu),
        ("america/chihuahua", time_zone::AmericaChihuahua),
        ("america/el_salvador", time_zone::AmericaElSalvador),
        ("etc/gmt+7", time_zone::EtcGmtPlus7),
        ("australia/victoria", time_zone::AustraliaMelbourne),
        ("pacific/truk", time_zone::PacificChuuk),
        ("america/lower_princes", time_zone::AmericaAnguilla),
        ("etc/gmt+3", time_zone::EtcGmtPlus3),
        ("eet", time_zone::Eet),
        ("asia/hovd", time_zone::AsiaHovd),
        ("indian/reunion", time_zone::IndianReunion),
        ("asia/phnom_penh", time_zone::AsiaBangkok),
        ("asia/dacca", time_zone::AsiaDacca),
        ("pacific/midway", time_zone::PacificMidway),
        ("america/campo_grande", time_zone::AmericaCampoGrande),
        ("america/winnipeg", time_zone::AmericaWinnipeg),
        ("america/knox_in", time_zone::AmericaKnoxIn),
        ("america/danmarkshavn", time_zone::AmericaDanmarkshavn),
        ("antarctica/macquarie", time_zone::AntarcticaMacquarie),
        ("asia/kuching", time_zone::AsiaKuching),
        ("europe/vienna", time_zone::EuropeVienna),
        ("asia/chungking", time_zone::AsiaChongqing),
        ("asia/qatar", time_zone::AsiaBahrain),
        ("cet", time_zone::Cet),
        ("asia/ashgabat", time_zone::AsiaAshgabat),
        ("europe/berlin", time_zone::EuropeBerlin),
        ("europe/tiraspol", time_zone::EuropeChisinau),
        ("america/shiprock", time_zone::AmericaDenver),
        ("etc/gmt-12", time_zone::EtcGmtMinus12),
        ("africa/niamey", time_zone::AfricaBangui),
        ("america/dominica", time_zone::AmericaAnguilla),
        ("america/glace_bay", time_zone::AmericaGlaceBay),
        ("america/bogota", time_zone::AmericaBogota),
        ("europe/simferopol", time_zone::EuropeSimferopol),
        ("asia/kolkata", time_zone::AsiaCalcutta),
        ("europe/athens", time_zone::EuropeAthens),
        ("america/barbados", time_zone::AmericaBarbados),
        ("utc", time_zone::EtcUct),
        ("us/mountain", time_zone::AmericaDenver),
        ("atlantic/st_helena", time_zone::AfricaAbidjan),
        ("asia/aqtobe", time_zone::AsiaAqtobe),
        ("asia/irkutsk", time_zone::AsiaIrkutsk),
        ("australia/lord_howe", time_zone::AustraliaLhi),
        ("america/anchorage", time_zone::AmericaAnchorage),
        ("america/panama", time_zone::AmericaAtikokan),
        ("america/tortola", time_zone::AmericaAnguilla),
        ("etc/gmt-1", time_zone::EtcGmtMinus1),
        ("america/godthab", time_zone::AmericaGodthab),
        ("brazil/acre", time_zone::AmericaPortoAcre),
        ("america/louisville", time_zone::AmericaLouisville),
        ("etc/gmt-14", time_zone::EtcGmtMinus14),
        ("america/maceio", time_zone::AmericaMaceio),
        ("etc/utc", time_zone::EtcUct),
        ("africa/porto-novo", time_zone::AfricaBangui),
        ("mst7mdt", time_zone::Mst7Mdt),
        ("america/st_barthelemy", time_zone::AmericaAnguilla),
        ("america/halifax", time_zone::AmericaHalifax),
        ("asia/magadan", time_zone::AsiaMagadan),
        ("america/los_angeles", time_zone::AmericaLosAngeles),
        ("america/dawson", time_zone::AmericaDawson),
        ("us/pacific", time_zone::AmericaLosAngeles),
        ("asia/ho_chi_minh", time_zone::AsiaHoChiMinh),
        ("kwajalein", time_zone::Kwajalein),
        ("africa/tunis", time_zone::AfricaTunis),
        ("africa/bangui", time_zone::AfricaBangui),
        ("america/yakutat", time_zone::AmericaYakutat),
        ("america/belize", time_zone::AmericaBelize),
        ("pacific/auckland", time_zone::AntarcticaMcMurdo),
        ("america/toronto", time_zone::AmericaMontreal),
        ("etc/gmt-2", time_zone::EtcGmtMinus2),
        ("cst6cdt", time_zone::Cst6Cdt),
        ("america/pangnirtung", time_zone::AmericaPangnirtung),
        ("america/boise", time_zone::AmericaBoise),
        ("asia/vientiane", time_zone::AsiaBangkok),
        ("america/cuiaba", time_zone::AmericaCuiaba),
        ("asia/tbilisi", time_zone::AsiaTbilisi),
        ("america/new_york", time_zone::AmericaNewYork),
        ("america/indianapolis", time_zone::AmericaFortWayne),
        ("asia/karachi", time_zone::AsiaKarachi),
        ("europe/volgograd", time_zone::EuropeVolgograd),
        ("pacific/kosrae", time_zone::PacificKosrae),
        ("w-su", time_zone::EuropeMoscow),
        ("america/fort_nelson", time_zone::AmericaFortNelson),
        ("africa/asmara", time_zone::AfricaAddisAbaba),
        ("asia/pyongyang", time_zone::AsiaPyongyang),
        ("pacific/gambier", time_zone::PacificGambier),
        (
            "antarctica/dumontdurville",
            time_zone::AntarcticaDumontDUrville,
        ),
        ("america/cancun", time_zone::AmericaCancun),
        ("america/cayman", time_zone::AmericaAtikokan),
        ("africa/malabo", time_zone::AfricaBangui),
        ("africa/lusaka", time_zone::AfricaBlantyre),
        ("europe/kiev", time_zone::EuropeKiev),
        ("gmt-0", time_zone::EtcGmt),
        ("iran", time_zone::AsiaTehran),
        ("america/marigot", time_zone::AmericaAnguilla),
        ("europe/samara", time_zone::EuropeSamara),
        ("europe/uzhgorod", time_zone::EuropeUzhgorod),
        ("uct", time_zone::EtcUct),
        ("indian/christmas", time_zone::IndianChristmas),
        ("pacific/marquesas", time_zone::PacificMarquesas),
        ("indian/maldives", time_zone::IndianMaldives),
        ("america/eirunepe", time_zone::AmericaEirunepe),
        ("america/martinique", time_zone::AmericaMartinique),
        ("asia/urumqi", time_zone::AsiaKashgar),
        ("asia/makassar", time_zone::AsiaMakassar),
        ("america/merida", time_zone::AmericaMerida),
        ("indian/mauritius", time_zone::IndianMauritius),
        ("iceland", time_zone::AtlanticReykjavik),
        ("nz", time_zone::AntarcticaMcMurdo),
        ("roc", time_zone::AsiaTaipei),
        ("africa/kinshasa", time_zone::AfricaBangui),
        ("africa/tripoli", time_zone::AfricaTripoli),
        ("europe/stockholm", time_zone::EuropeStockholm),
        ("america/costa_rica", time_zone::AmericaCostaRica),
        ("america/cordoba", time_zone::AmericaCordoba),
        ("africa/libreville", time_zone::AfricaBangui),
        ("us/eastern", time_zone::AmericaNewYork),
        ("africa/blantyre", time_zone::AfricaBlantyre),
        ("asia/dili", time_zone::AsiaDili),
        ("asia/sakhalin", time_zone::AsiaSakhalin),
        ("africa/asmera", time_zone::AfricaAddisAbaba),
        ("america/asuncion", time_zone::AmericaAsuncion),
        ("asia/yekaterinburg", time_zone::AsiaYekaterinburg),
        ("pacific/nauru", time_zone::PacificNauru),
        ("etc/gmt-13", time_zone::EtcGmtMinus13),
        ("asia/amman", time_zone::AsiaAmman),
        ("america/nome", time_zone::AmericaNome),
        ("asia/kathmandu", time_zone::AsiaKathmandu),
        ("etc/gmt+6", time_zone::EtcGmtPlus6),
        ("libya", time_zone::AfricaTripoli),
        ("atlantic/azores", time_zone::AtlanticAzores),
        ("atlantic/faroe", time_zone::AtlanticFaeroe),
        ("america/matamoros", time_zone::AmericaMatamoros),
        ("asia/dubai", time_zone::AsiaDubai),
        ("america/virgin", time_zone::AmericaAnguilla),
        ("etc/gmt+11", time_zone::EtcGmtPlus11),
        ("asia/ulaanbaatar", time_zone::AsiaUlaanbaatar),
        ("asia/oral", time_zone::AsiaOral),
        ("pacific/chuuk", time_zone::PacificChuuk),
        ("america/whitehorse", time_zone::AmericaWhitehorse),
        ("europe/sarajevo", time_zone::EuropeBelgrade),
        ("atlantic/reykjavik", time_zone::AtlanticReykjavik),
        ("etc/gmt", time_zone::EtcGmt),
        ("indian/cocos", time_zone::IndianCocos),
        ("turkey", time_zone::AsiaIstanbul),
        ("est", time_zone::Est),
        ("canada/saskatchewan", time_zone::AmericaRegina),
        ("canada/newfoundland", time_zone::AmericaStJohns),
        ("america/moncton", time_zone::AmericaMoncton),
        ("america/denver", time_zone::AmericaDenver),
        ("pacific/pohnpei", time_zone::PacificPohnpei),
        ("asia/tehran", time_zone::AsiaTehran),
        ("africa/dar_es_salaam", time_zone::AfricaAddisAbaba),
        ("chile/continental", time_zone::AmericaSantiago),
        ("antarctica/rothera", time_zone::AntarcticaRothera),
        ("asia/tel_aviv", time_zone::AsiaJerusalem),
        ("australia/sydney", time_zone::AustraliaAct),
        ("australia/eucla", time_zone::AustraliaEucla),
        ("australia/act", time_zone::AustraliaAct),
        ("atlantic/bermuda", time_zone::AtlanticBermuda),
        ("africa/mbabane", time_zone::AfricaJohannesburg),
        ("asia/samarkand", time_zone::AsiaSamarkand),
        ("europe/gibraltar", time_zone::EuropeGibraltar),
        ("etc/gmt-5", time_zone::EtcGmtMinus5),
        ("africa/conakry", time_zone::AfricaAbidjan),
        ("europe/malta", time_zone::EuropeMalta),
        ("canada/pacific", time_zone::AmericaVancouver),
        ("asia/omsk", time_zone::AsiaOmsk),
        ("atlantic/canary", time_zone::AtlanticCanary),
        ("universal", time_zone::EtcUct),
        ("africa/khartoum", time_zone::AfricaKhartoum),
        ("canada/yukon", time_zone::AmericaWhitehorse),
        ("america/miquelon", time_zone::AmericaMiquelon),
        ("asia/shanghai", time_zone::AsiaChongqing),
        ("indian/comoro", time_zone::AfricaAddisAbaba),
        ("asia/atyrau", time_zone::AsiaAtyrau),
        ("antarctica/mawson", time_zone::AntarcticaMawson),
        ("indian/chagos", time_zone::IndianChagos),
        ("etc/gmt-7", time_zone::EtcGmtMinus7),
        ("america/santo_domingo", time_zone::AmericaSantoDomingo),
        ("america/edmonton", time_zone::AmericaEdmonton),
        ("pacific/wallis", time_zone::PacificWallis),
        ("america/st_lucia", time_zone::AmericaAnguilla),
        ("asia/dushanbe", time_zone::AsiaDushanbe),
        ("atlantic/cape_verde", time_zone::AtlanticCapeVerde),
        ("america/st_kitts", time_zone::AmericaAnguilla),
        ("asia/ashkhabad", time_zone::AsiaAshgabat),
        ("etc/universal", time_zone::EtcUct),
        ("asia/taipei", time_zone::AsiaTaipei),
        ("prc", time_zone::AsiaChongqing),
        ("asia/bangkok", time_zone::AsiaBangkok),
        ("america/thule", time_zone::AmericaThule),
        ("pacific/tarawa", time_zone::PacificTarawa),
        ("europe/prague", time_zone::EuropeBratislava),
        ("asia/jerusalem", time_zone::AsiaJerusalem),
        ("gb-eire", time_zone::EuropeBelfast),
        ("europe/isle_of_man", time_zone::EuropeBelfast),
        ("rok", time_zone::AsiaSeoul),
        ("america/porto_acre", time_zone::AmericaPortoAcre),
        ("asia/yakutsk", time_zone::AsiaYakutsk),
        ("america/noronha", time_zone::AmericaNoronha),
        ("america/caracas", time_zone::AmericaCaracas),
        ("pacific/easter", time_zone::ChileEasterIsland),
        ("america/guyana", time_zone::AmericaGuyana),
        ("pacific/chatham", time_zone::NzChat),
        ("africa/juba", time_zone::AfricaJuba),
        ("america/metlakatla", time_zone::AmericaMetlakatla),
        ("america/puerto_rico", time_zone::AmericaAnguilla),
        ("pacific/norfolk", time_zone::PacificNorfolk),
        ("africa/timbuktu", time_zone::AfricaAbidjan),
        ("gmt", time_zone::EtcGmt),
        ("africa/bujumbura", time_zone::AfricaBlantyre),
        ("egypt", time_zone::AfricaCairo),
        ("gb", time_zone::EuropeBelfast),
        ("pacific/fiji", time_zone::PacificFiji),
        ("pacific/port_moresby", time_zone::AntarcticaDumontDUrville),
        ("america/st_vincent", time_zone::AmericaAnguilla),
        ("pacific/ponape", time_zone::PacificPohnpei),
        ("america/regina", time_zone::AmericaRegina),
        ("etc/gmt+5", time_zone::EtcGmtPlus5),
        ("pacific/noumea", time_zone::PacificNoumea),
        ("africa/maputo", time_zone::AfricaBlantyre),
        ("america/montreal", time_zone::AmericaMontreal),
        ("africa/douala", time_zone::AfricaBangui),
        ("asia/beirut", time_zone::AsiaBeirut),
        ("brazil/west", time_zone::AmericaManaus),
        ("america/boa_vista", time_zone::AmericaBoaVista),
        ("europe/guernsey", time_zone::EuropeBelfast),
        ("america/atka", time_zone::AmericaAdak),
        ("america/phoenix", time_zone::AmericaCreston),
    ],
};

pub(crate) static TIME_ZONES_LIST: [(&str, &DbTimeZone); 569] = [
    ("Africa/Abidjan", time_zone::AfricaAbidjan),
    ("Africa/Accra", time_zone::AfricaAbidjan),
    ("Africa/Addis_Ababa", time_zone::AfricaAddisAbaba),
    ("Africa/Algiers", time_zone::AfricaAlgiers),
    ("Africa/Asmara", time_zone::AfricaAddisAbaba),
    ("Africa/Asmera", time_zone::AfricaAddisAbaba),
    ("Africa/Bamako", time_zone::AfricaAbidjan),
    ("Africa/Bangui", time_zone::AfricaBangui),
    ("Africa/Banjul", time_zone::AfricaAbidjan),
    ("Africa/Bissau", time_zone::AfricaBissau),
    ("Africa/Blantyre", time_zone::AfricaBlantyre),
    ("Africa/Brazzaville", time_zone::AfricaBangui),
    ("Africa/Bujumbura", time_zone::AfricaBlantyre),
    ("Africa/Cairo", time_zone::AfricaCairo),
    ("Africa/Casablanca", time_zone::AfricaCasablanca),
    ("Africa/Ceuta", time_zone::AfricaCeuta),
    ("Africa/Conakry", time_zone::AfricaAbidjan),
    ("Africa/Dakar", time_zone::AfricaAbidjan),
    ("Africa/Dar_es_Salaam", time_zone::AfricaAddisAbaba),
    ("Africa/Djibouti", time_zone::AfricaAddisAbaba),
    ("Africa/Douala", time_zone::AfricaBangui),
    ("Africa/El_Aaiun", time_zone::AfricaElAaiun),
    ("Africa/Freetown", time_zone::AfricaAbidjan),
    ("Africa/Gaborone", time_zone::AfricaBlantyre),
    ("Africa/Harare", time_zone::AfricaBlantyre),
    ("Africa/Johannesburg", time_zone::AfricaJohannesburg),
    ("Africa/Juba", time_zone::AfricaJuba),
    ("Africa/Kampala", time_zone::AfricaAddisAbaba),
    ("Africa/Khartoum", time_zone::AfricaKhartoum),
    ("Africa/Kigali", time_zone::AfricaBlantyre),
    ("Africa/Kinshasa", time_zone::AfricaBangui),
    ("Africa/Lagos", time_zone::AfricaBangui),
    ("Africa/Libreville", time_zone::AfricaBangui),
    ("Africa/Lome", time_zone::AfricaAbidjan),
    ("Africa/Luanda", time_zone::AfricaBangui),
    ("Africa/Lubumbashi", time_zone::AfricaBlantyre),
    ("Africa/Lusaka", time_zone::AfricaBlantyre),
    ("Africa/Malabo", time_zone::AfricaBangui),
    ("Africa/Maputo", time_zone::AfricaBlantyre),
    ("Africa/Maseru", time_zone::AfricaJohannesburg),
    ("Africa/Mbabane", time_zone::AfricaJohannesburg),
    ("Africa/Mogadishu", time_zone::AfricaAddisAbaba),
    ("Africa/Monrovia", time_zone::AfricaMonrovia),
    ("Africa/Nairobi", time_zone::AfricaAddisAbaba),
    ("Africa/Ndjamena", time_zone::AfricaNdjamena),
    ("Africa/Niamey", time_zone::AfricaBangui),
    ("Africa/Nouakchott", time_zone::AfricaAbidjan),
    ("Africa/Ouagadougou", time_zone::AfricaAbidjan),
    ("Africa/Porto-Novo", time_zone::AfricaBangui),
    ("Africa/Sao_Tome", time_zone::AfricaSaoTome),
    ("Africa/Timbuktu", time_zone::AfricaAbidjan),
    ("Africa/Tripoli", time_zone::AfricaTripoli),
    ("Africa/Tunis", time_zone::AfricaTunis),
    ("Africa/Windhoek", time_zone::AfricaWindhoek),
    ("America/Adak", time_zone::AmericaAdak),
    ("America/Anchorage", time_zone::AmericaAnchorage),
    ("America/Anguilla", time_zone::AmericaAnguilla),
    ("America/Antigua", time_zone::AmericaAnguilla),
    ("America/Araguaina", time_zone::AmericaAraguaina),
    ("America/Aruba", time_zone::AmericaAnguilla),
    ("America/Asuncion", time_zone::AmericaAsuncion),
    ("America/Atikokan", time_zone::AmericaAtikokan),
    ("America/Atka", time_zone::AmericaAdak),
    ("America/Bahia", time_zone::AmericaBahia),
    ("America/Bahia_Banderas", time_zone::AmericaBahiaBanderas),
    ("America/Barbados", time_zone::AmericaBarbados),
    ("America/Belem", time_zone::AmericaBelem),
    ("America/Belize", time_zone::AmericaBelize),
    ("America/Blanc-Sablon", time_zone::AmericaAnguilla),
    ("America/Boa_Vista", time_zone::AmericaBoaVista),
    ("America/Bogota", time_zone::AmericaBogota),
    ("America/Boise", time_zone::AmericaBoise),
    ("America/Buenos_Aires", time_zone::AmericaBuenosAires),
    ("America/Cambridge_Bay", time_zone::AmericaCambridgeBay),
    ("America/Campo_Grande", time_zone::AmericaCampoGrande),
    ("America/Cancun", time_zone::AmericaCancun),
    ("America/Caracas", time_zone::AmericaCaracas),
    ("America/Catamarca", time_zone::AmericaCatamarca),
    ("America/Cayenne", time_zone::AmericaCayenne),
    ("America/Cayman", time_zone::AmericaAtikokan),
    ("America/Chicago", time_zone::AmericaChicago),
    ("America/Chihuahua", time_zone::AmericaChihuahua),
    ("America/Coral_Harbour", time_zone::AmericaAtikokan),
    ("America/Cordoba", time_zone::AmericaCordoba),
    ("America/Costa_Rica", time_zone::AmericaCostaRica),
    ("America/Creston", time_zone::AmericaCreston),
    ("America/Cuiaba", time_zone::AmericaCuiaba),
    ("America/Curacao", time_zone::AmericaAnguilla),
    ("America/Danmarkshavn", time_zone::AmericaDanmarkshavn),
    ("America/Dawson", time_zone::AmericaDawson),
    ("America/Dawson_Creek", time_zone::AmericaDawsonCreek),
    ("America/Denver", time_zone::AmericaDenver),
    ("America/Detroit", time_zone::AmericaDetroit),
    ("America/Dominica", time_zone::AmericaAnguilla),
    ("America/Edmonton", time_zone::AmericaEdmonton),
    ("America/Eirunepe", time_zone::AmericaEirunepe),
    ("America/El_Salvador", time_zone::AmericaElSalvador),
    ("America/Ensenada", time_zone::AmericaEnsenada),
    ("America/Fort_Nelson", time_zone::AmericaFortNelson),
    ("America/Fort_Wayne", time_zone::AmericaFortWayne),
    ("America/Fortaleza", time_zone::AmericaFortaleza),
    ("America/Glace_Bay", time_zone::AmericaGlaceBay),
    ("America/Godthab", time_zone::AmericaGodthab),
    ("America/Goose_Bay", time_zone::AmericaGooseBay),
    ("America/Grand_Turk", time_zone::AmericaGrandTurk),
    ("America/Grenada", time_zone::AmericaAnguilla),
    ("America/Guadeloupe", time_zone::AmericaAnguilla),
    ("America/Guatemala", time_zone::AmericaGuatemala),
    ("America/Guayaquil", time_zone::AmericaGuayaquil),
    ("America/Guyana", time_zone::AmericaGuyana),
    ("America/Halifax", time_zone::AmericaHalifax),
    ("America/Havana", time_zone::AmericaHavana),
    ("America/Hermosillo", time_zone::AmericaHermosillo),
    ("America/Indianapolis", time_zone::AmericaFortWayne),
    ("America/Inuvik", time_zone::AmericaInuvik),
    ("America/Iqaluit", time_zone::AmericaIqaluit),
    ("America/Jamaica", time_zone::AmericaJamaica),
    ("America/Jujuy", time_zone::AmericaJujuy),
    ("America/Juneau", time_zone::AmericaJuneau),
    ("America/Knox_IN", time_zone::AmericaKnoxIn),
    ("America/Kralendijk", time_zone::AmericaAnguilla),
    ("America/La_Paz", time_zone::AmericaLaPaz),
    ("America/Lima", time_zone::AmericaLima),
    ("America/Los_Angeles", time_zone::AmericaLosAngeles),
    ("America/Louisville", time_zone::AmericaLouisville),
    ("America/Lower_Princes", time_zone::AmericaAnguilla),
    ("America/Maceio", time_zone::AmericaMaceio),
    ("America/Managua", time_zone::AmericaManagua),
    ("America/Manaus", time_zone::AmericaManaus),
    ("America/Marigot", time_zone::AmericaAnguilla),
    ("America/Martinique", time_zone::AmericaMartinique),
    ("America/Matamoros", time_zone::AmericaMatamoros),
    ("America/Mazatlan", time_zone::AmericaMazatlan),
    ("America/Mendoza", time_zone::AmericaMendoza),
    ("America/Menominee", time_zone::AmericaMenominee),
    ("America/Merida", time_zone::AmericaMerida),
    ("America/Metlakatla", time_zone::AmericaMetlakatla),
    ("America/Mexico_City", time_zone::AmericaMexicoCity),
    ("America/Miquelon", time_zone::AmericaMiquelon),
    ("America/Moncton", time_zone::AmericaMoncton),
    ("America/Monterrey", time_zone::AmericaMonterrey),
    ("America/Montevideo", time_zone::AmericaMontevideo),
    ("America/Montreal", time_zone::AmericaMontreal),
    ("America/Montserrat", time_zone::AmericaAnguilla),
    ("America/Nassau", time_zone::AmericaMontreal),
    ("America/New_York", time_zone::AmericaNewYork),
    ("America/Nipigon", time_zone::AmericaNipigon),
    ("America/Nome", time_zone::AmericaNome),
    ("America/Noronha", time_zone::AmericaNoronha),
    ("America/Nuuk", time_zone::AmericaGodthab),
    ("America/Ojinaga", time_zone::AmericaOjinaga),
    ("America/Panama", time_zone::AmericaAtikokan),
    ("America/Pangnirtung", time_zone::AmericaPangnirtung),
    ("America/Paramaribo", time_zone::AmericaParamaribo),
    ("America/Phoenix", time_zone::AmericaCreston),
    ("America/Port-au-Prince", time_zone::AmericaPortAuPrince),
    ("America/Port_of_Spain", time_zone::AmericaAnguilla),
    ("America/Porto_Acre", time_zone::AmericaPortoAcre),
    ("America/Porto_Velho", time_zone::AmericaPortoVelho),
    ("America/Puerto_Rico", time_zone::AmericaAnguilla),
    ("America/Punta_Arenas", time_zone::AmericaPuntaArenas),
    ("America/Rainy_River", time_zone::AmericaRainyRiver),
    ("America/Rankin_Inlet", time_zone::AmericaRankinInlet),
    ("America/Recife", time_zone::AmericaRecife),
    ("America/Regina", time_zone::AmericaRegina),
    ("America/Resolute", time_zone::AmericaResolute),
    ("America/Rio_Branco", time_zone::AmericaPortoAcre),
    ("America/Rosario", time_zone::AmericaCordoba),
    ("America/Santa_Isabel", time_zone::AmericaEnsenada),
    ("America/Santarem", time_zone::AmericaSantarem),
    ("America/Santiago", time_zone::AmericaSantiago),
    ("America/Santo_Domingo", time_zone::AmericaSantoDomingo),
    ("America/Sao_Paulo", time_zone::AmericaSaoPaulo),
    ("America/Scoresbysund", time_zone::AmericaScoresbysund),
    ("America/Shiprock", time_zone::AmericaDenver),
    ("America/Sitka", time_zone::AmericaSitka),
    ("America/St_Barthelemy", time_zone::AmericaAnguilla),
    ("America/St_Johns", time_zone::AmericaStJohns),
    ("America/St_Kitts", time_zone::AmericaAnguilla),
    ("America/St_Lucia", time_zone::AmericaAnguilla),
    ("America/St_Thomas", time_zone::AmericaAnguilla),
    ("America/St_Vincent", time_zone::AmericaAnguilla),
    ("America/Swift_Current", time_zone::AmericaSwiftCurrent),
    ("America/Tegucigalpa", time_zone::AmericaTegucigalpa),
    ("America/Thule", time_zone::AmericaThule),
    ("America/Thunder_Bay", time_zone::AmericaThunderBay),
    ("America/Tijuana", time_zone::AmericaEnsenada),
    ("America/Toronto", time_zone::AmericaMontreal),
    ("America/Tortola", time_zone::AmericaAnguilla),
    ("America/Vancouver", time_zone::AmericaVancouver),
    ("America/Virgin", time_zone::AmericaAnguilla),
    ("America/Whitehorse", time_zone::AmericaWhitehorse),
    ("America/Winnipeg", time_zone::AmericaWinnipeg),
    ("America/Yakutat", time_zone::AmericaYakutat),
    ("America/Yellowknife", time_zone::AmericaYellowknife),
    ("Antarctica/Casey", time_zone::AntarcticaCasey),
    ("Antarctica/Davis", time_zone::AntarcticaDavis),
    (
        "Antarctica/DumontDUrville",
        time_zone::AntarcticaDumontDUrville,
    ),
    ("Antarctica/Macquarie", time_zone::AntarcticaMacquarie),
    ("Antarctica/Mawson", time_zone::AntarcticaMawson),
    ("Antarctica/McMurdo", time_zone::AntarcticaMcMurdo),
    ("Antarctica/Palmer", time_zone::AntarcticaPalmer),
    ("Antarctica/Rothera", time_zone::AntarcticaRothera),
    ("Antarctica/South_Pole", time_zone::AntarcticaMcMurdo),
    ("Antarctica/Syowa", time_zone::AntarcticaSyowa),
    ("Antarctica/Troll", time_zone::AntarcticaTroll),
    ("Antarctica/Vostok", time_zone::AntarcticaVostok),
    ("Arctic/Longyearbyen", time_zone::ArcticLongyearbyen),
    ("Asia/Aden", time_zone::AntarcticaSyowa),
    ("Asia/Almaty", time_zone::AsiaAlmaty),
    ("Asia/Amman", time_zone::AsiaAmman),
    ("Asia/Anadyr", time_zone::AsiaAnadyr),
    ("Asia/Aqtau", time_zone::AsiaAqtau),
    ("Asia/Aqtobe", time_zone::AsiaAqtobe),
    ("Asia/Ashgabat", time_zone::AsiaAshgabat),
    ("Asia/Ashkhabad", time_zone::AsiaAshgabat),
    ("Asia/Atyrau", time_zone::AsiaAtyrau),
    ("Asia/Baghdad", time_zone::AsiaBaghdad),
    ("Asia/Bahrain", time_zone::AsiaBahrain),
    ("Asia/Baku", time_zone::AsiaBaku),
    ("Asia/Bangkok", time_zone::AsiaBangkok),
    ("Asia/Barnaul", time_zone::AsiaBarnaul),
    ("Asia/Beirut", time_zone::AsiaBeirut),
    ("Asia/Bishkek", time_zone::AsiaBishkek),
    ("Asia/Brunei", time_zone::AsiaBrunei),
    ("Asia/Calcutta", time_zone::AsiaCalcutta),
    ("Asia/Chita", time_zone::AsiaChita),
    ("Asia/Choibalsan", time_zone::AsiaChoibalsan),
    ("Asia/Chongqing", time_zone::AsiaChongqing),
    ("Asia/Chungking", time_zone::AsiaChongqing),
    ("Asia/Colombo", time_zone::AsiaColombo),
    ("Asia/Dacca", time_zone::AsiaDacca),
    ("Asia/Damascus", time_zone::AsiaDamascus),
    ("Asia/Dhaka", time_zone::AsiaDacca),
    ("Asia/Dili", time_zone::AsiaDili),
    ("Asia/Dubai", time_zone::AsiaDubai),
    ("Asia/Dushanbe", time_zone::AsiaDushanbe),
    ("Asia/Famagusta", time_zone::AsiaFamagusta),
    ("Asia/Gaza", time_zone::AsiaGaza),
    ("Asia/Harbin", time_zone::AsiaChongqing),
    ("Asia/Hebron", time_zone::AsiaHebron),
    ("Asia/Ho_Chi_Minh", time_zone::AsiaHoChiMinh),
    ("Asia/Hong_Kong", time_zone::AsiaHongKong),
    ("Asia/Hovd", time_zone::AsiaHovd),
    ("Asia/Irkutsk", time_zone::AsiaIrkutsk),
    ("Asia/Istanbul", time_zone::AsiaIstanbul),
    ("Asia/Jakarta", time_zone::AsiaJakarta),
    ("Asia/Jayapura", time_zone::AsiaJayapura),
    ("Asia/Jerusalem", time_zone::AsiaJerusalem),
    ("Asia/Kabul", time_zone::AsiaKabul),
    ("Asia/Kamchatka", time_zone::AsiaKamchatka),
    ("Asia/Karachi", time_zone::AsiaKarachi),
    ("Asia/Kashgar", time_zone::AsiaKashgar),
    ("Asia/Kathmandu", time_zone::AsiaKathmandu),
    ("Asia/Katmandu", time_zone::AsiaKathmandu),
    ("Asia/Khandyga", time_zone::AsiaKhandyga),
    ("Asia/Kolkata", time_zone::AsiaCalcutta),
    ("Asia/Krasnoyarsk", time_zone::AsiaKrasnoyarsk),
    ("Asia/Kuala_Lumpur", time_zone::AsiaKualaLumpur),
    ("Asia/Kuching", time_zone::AsiaKuching),
    ("Asia/Kuwait", time_zone::AntarcticaSyowa),
    ("Asia/Macao", time_zone::AsiaMacao),
    ("Asia/Macau", time_zone::AsiaMacao),
    ("Asia/Magadan", time_zone::AsiaMagadan),
    ("Asia/Makassar", time_zone::AsiaMakassar),
    ("Asia/Manila", time_zone::AsiaManila),
    ("Asia/Muscat", time_zone::AsiaDubai),
    ("Asia/Nicosia", time_zone::AsiaNicosia),
    ("Asia/Novokuznetsk", time_zone::AsiaNovokuznetsk),
    ("Asia/Novosibirsk", time_zone::AsiaNovosibirsk),
    ("Asia/Omsk", time_zone::AsiaOmsk),
    ("Asia/Oral", time_zone::AsiaOral),
    ("Asia/Phnom_Penh", time_zone::AsiaBangkok),
    ("Asia/Pontianak", time_zone::AsiaPontianak),
    ("Asia/Pyongyang", time_zone::AsiaPyongyang),
    ("Asia/Qatar", time_zone::AsiaBahrain),
    ("Asia/Qostanay", time_zone::AsiaQostanay),
    ("Asia/Qyzylorda", time_zone::AsiaQyzylorda),
    ("Asia/Rangoon", time_zone::AsiaRangoon),
    ("Asia/Riyadh", time_zone::AntarcticaSyowa),
    ("Asia/Saigon", time_zone::AsiaHoChiMinh),
    ("Asia/Sakhalin", time_zone::AsiaSakhalin),
    ("Asia/Samarkand", time_zone::AsiaSamarkand),
    ("Asia/Seoul", time_zone::AsiaSeoul),
    ("Asia/Shanghai", time_zone::AsiaChongqing),
    ("Asia/Singapore", time_zone::AsiaSingapore),
    ("Asia/Srednekolymsk", time_zone::AsiaSrednekolymsk),
    ("Asia/Taipei", time_zone::AsiaTaipei),
    ("Asia/Tashkent", time_zone::AsiaTashkent),
    ("Asia/Tbilisi", time_zone::AsiaTbilisi),
    ("Asia/Tehran", time_zone::AsiaTehran),
    ("Asia/Tel_Aviv", time_zone::AsiaJerusalem),
    ("Asia/Thimbu", time_zone::AsiaThimbu),
    ("Asia/Thimphu", time_zone::AsiaThimbu),
    ("Asia/Tokyo", time_zone::AsiaTokyo),
    ("Asia/Tomsk", time_zone::AsiaTomsk),
    ("Asia/Ujung_Pandang", time_zone::AsiaMakassar),
    ("Asia/Ulaanbaatar", time_zone::AsiaUlaanbaatar),
    ("Asia/Ulan_Bator", time_zone::AsiaUlaanbaatar),
    ("Asia/Urumqi", time_zone::AsiaKashgar),
    ("Asia/Ust-Nera", time_zone::AsiaUstNera),
    ("Asia/Vientiane", time_zone::AsiaBangkok),
    ("Asia/Vladivostok", time_zone::AsiaVladivostok),
    ("Asia/Yakutsk", time_zone::AsiaYakutsk),
    ("Asia/Yangon", time_zone::AsiaRangoon),
    ("Asia/Yekaterinburg", time_zone::AsiaYekaterinburg),
    ("Asia/Yerevan", time_zone::AsiaYerevan),
    ("Atlantic/Azores", time_zone::AtlanticAzores),
    ("Atlantic/Bermuda", time_zone::AtlanticBermuda),
    ("Atlantic/Canary", time_zone::AtlanticCanary),
    ("Atlantic/Cape_Verde", time_zone::AtlanticCapeVerde),
    ("Atlantic/Faeroe", time_zone::AtlanticFaeroe),
    ("Atlantic/Faroe", time_zone::AtlanticFaeroe),
    ("Atlantic/Jan_Mayen", time_zone::ArcticLongyearbyen),
    ("Atlantic/Madeira", time_zone::AtlanticMadeira),
    ("Atlantic/Reykjavik", time_zone::AtlanticReykjavik),
    ("Atlantic/South_Georgia", time_zone::AtlanticSouthGeorgia),
    ("Atlantic/St_Helena", time_zone::AfricaAbidjan),
    ("Atlantic/Stanley", time_zone::AtlanticStanley),
    ("Australia/ACT", time_zone::AustraliaAct),
    ("Australia/Adelaide", time_zone::AustraliaAdelaide),
    ("Australia/Brisbane", time_zone::AustraliaBrisbane),
    ("Australia/Broken_Hill", time_zone::AustraliaBrokenHill),
    ("Australia/Canberra", time_zone::AustraliaAct),
    ("Australia/Currie", time_zone::AustraliaCurrie),
    ("Australia/Darwin", time_zone::AustraliaDarwin),
    ("Australia/Eucla", time_zone::AustraliaEucla),
    ("Australia/Hobart", time_zone::AustraliaCurrie),
    ("Australia/LHI", time_zone::AustraliaLhi),
    ("Australia/Lindeman", time_zone::AustraliaLindeman),
    ("Australia/Lord_Howe", time_zone::AustraliaLhi),
    ("Australia/Melbourne", time_zone::AustraliaMelbourne),
    ("Australia/North", time_zone::AustraliaDarwin),
    ("Australia/NSW", time_zone::AustraliaAct),
    ("Australia/Perth", time_zone::AustraliaPerth),
    ("Australia/Queensland", time_zone::AustraliaBrisbane),
    ("Australia/South", time_zone::AustraliaAdelaide),
    ("Australia/Sydney", time_zone::AustraliaAct),
    ("Australia/Tasmania", time_zone::AustraliaCurrie),
    ("Australia/Victoria", time_zone::AustraliaMelbourne),
    ("Australia/West", time_zone::AustraliaPerth),
    ("Australia/Yancowinna", time_zone::AustraliaBrokenHill),
    ("Brazil/Acre", time_zone::AmericaPortoAcre),
    ("Brazil/DeNoronha", time_zone::AmericaNoronha),
    ("Brazil/East", time_zone::AmericaSaoPaulo),
    ("Brazil/West", time_zone::AmericaManaus),
    ("Canada/Atlantic", time_zone::AmericaHalifax),
    ("Canada/Central", time_zone::AmericaWinnipeg),
    ("Canada/Eastern", time_zone::AmericaMontreal),
    ("Canada/Mountain", time_zone::AmericaEdmonton),
    ("Canada/Newfoundland", time_zone::AmericaStJohns),
    ("Canada/Pacific", time_zone::AmericaVancouver),
    ("Canada/Saskatchewan", time_zone::AmericaRegina),
    ("Canada/Yukon", time_zone::AmericaWhitehorse),
    ("CET", time_zone::Cet),
    ("Chile/Continental", time_zone::AmericaSantiago),
    ("Chile/EasterIsland", time_zone::ChileEasterIsland),
    ("CST6CDT", time_zone::Cst6Cdt),
    ("Cuba", time_zone::AmericaHavana),
    ("EET", time_zone::Eet),
    ("Egypt", time_zone::AfricaCairo),
    ("Eire", time_zone::Eire),
    ("EST", time_zone::Est),
    ("EST5EDT", time_zone::Est5Edt),
    ("Etc/GMT", time_zone::EtcGmt),
    ("Etc/GMT0", time_zone::EtcGmt),
    ("Etc/GMT-0", time_zone::EtcGmt),
    ("Etc/GMT-1", time_zone::EtcGmtMinus1),
    ("Etc/GMT-10", time_zone::EtcGmtMinus10),
    ("Etc/GMT-11", time_zone::EtcGmtMinus11),
    ("Etc/GMT-12", time_zone::EtcGmtMinus12),
    ("Etc/GMT-13", time_zone::EtcGmtMinus13),
    ("Etc/GMT-14", time_zone::EtcGmtMinus14),
    ("Etc/GMT-2", time_zone::EtcGmtMinus2),
    ("Etc/GMT-3", time_zone::EtcGmtMinus3),
    ("Etc/GMT-4", time_zone::EtcGmtMinus4),
    ("Etc/GMT-5", time_zone::EtcGmtMinus5),
    ("Etc/GMT-6", time_zone::EtcGmtMinus6),
    ("Etc/GMT-7", time_zone::EtcGmtMinus7),
    ("Etc/GMT-8", time_zone::EtcGmtMinus8),
    ("Etc/GMT-9", time_zone::EtcGmtMinus9),
    ("Etc/GMT+0", time_zone::EtcGmt),
    ("Etc/GMT+1", time_zone::EtcGmtPlus1),
    ("Etc/GMT+10", time_zone::EtcGmtPlus10),
    ("Etc/GMT+11", time_zone::EtcGmtPlus11),
    ("Etc/GMT+12", time_zone::EtcGmtPlus12),
    ("Etc/GMT+2", time_zone::EtcGmtPlus2),
    ("Etc/GMT+3", time_zone::EtcGmtPlus3),
    ("Etc/GMT+4", time_zone::EtcGmtPlus4),
    ("Etc/GMT+5", time_zone::EtcGmtPlus5),
    ("Etc/GMT+6", time_zone::EtcGmtPlus6),
    ("Etc/GMT+7", time_zone::EtcGmtPlus7),
    ("Etc/GMT+8", time_zone::EtcGmtPlus8),
    ("Etc/GMT+9", time_zone::EtcGmtPlus9),
    ("Etc/Greenwich", time_zone::EtcGmt),
    ("Etc/UCT", time_zone::EtcUct),
    ("Etc/Universal", time_zone::EtcUct),
    ("Etc/UTC", time_zone::EtcUct),
    ("Etc/Zulu", time_zone::EtcUct),
    ("Europe/Amsterdam", time_zone::EuropeAmsterdam),
    ("Europe/Andorra", time_zone::EuropeAndorra),
    ("Europe/Astrakhan", time_zone::EuropeAstrakhan),
    ("Europe/Athens", time_zone::EuropeAthens),
    ("Europe/Belfast", time_zone::EuropeBelfast),
    ("Europe/Belgrade", time_zone::EuropeBelgrade),
    ("Europe/Berlin", time_zone::EuropeBerlin),
    ("Europe/Bratislava", time_zone::EuropeBratislava),
    ("Europe/Brussels", time_zone::EuropeBrussels),
    ("Europe/Bucharest", time_zone::EuropeBucharest),
    ("Europe/Budapest", time_zone::EuropeBudapest),
    ("Europe/Busingen", time_zone::EuropeBusingen),
    ("Europe/Chisinau", time_zone::EuropeChisinau),
    ("Europe/Copenhagen", time_zone::EuropeCopenhagen),
    ("Europe/Dublin", time_zone::Eire),
    ("Europe/Gibraltar", time_zone::EuropeGibraltar),
    ("Europe/Guernsey", time_zone::EuropeBelfast),
    ("Europe/Helsinki", time_zone::EuropeHelsinki),
    ("Europe/Isle_of_Man", time_zone::EuropeBelfast),
    ("Europe/Istanbul", time_zone::AsiaIstanbul),
    ("Europe/Jersey", time_zone::EuropeBelfast),
    ("Europe/Kaliningrad", time_zone::EuropeKaliningrad),
    ("Europe/Kiev", time_zone::EuropeKiev),
    ("Europe/Kirov", time_zone::EuropeKirov),
    ("Europe/Lisbon", time_zone::EuropeLisbon),
    ("Europe/Ljubljana", time_zone::EuropeBelgrade),
    ("Europe/London", time_zone::EuropeBelfast),
    ("Europe/Luxembourg", time_zone::EuropeLuxembourg),
    ("Europe/Madrid", time_zone::EuropeMadrid),
    ("Europe/Malta", time_zone::EuropeMalta),
    ("Europe/Mariehamn", time_zone::EuropeHelsinki),
    ("Europe/Minsk", time_zone::EuropeMinsk),
    ("Europe/Monaco", time_zone::EuropeMonaco),
    ("Europe/Moscow", time_zone::EuropeMoscow),
    ("Europe/Nicosia", time_zone::AsiaNicosia),
    ("Europe/Oslo", time_zone::ArcticLongyearbyen),
    ("Europe/Paris", time_zone::EuropeParis),
    ("Europe/Podgorica", time_zone::EuropeBelgrade),
    ("Europe/Prague", time_zone::EuropeBratislava),
    ("Europe/Riga", time_zone::EuropeRiga),
    ("Europe/Rome", time_zone::EuropeRome),
    ("Europe/Samara", time_zone::EuropeSamara),
    ("Europe/San_Marino", time_zone::EuropeRome),
    ("Europe/Sarajevo", time_zone::EuropeBelgrade),
    ("Europe/Saratov", time_zone::EuropeSaratov),
    ("Europe/Simferopol", time_zone::EuropeSimferopol),
    ("Europe/Skopje", time_zone::EuropeBelgrade),
    ("Europe/Sofia", time_zone::EuropeSofia),
    ("Europe/Stockholm", time_zone::EuropeStockholm),
    ("Europe/Tallinn", time_zone::EuropeTallinn),
    ("Europe/Tirane", time_zone::EuropeTirane),
    ("Europe/Tiraspol", time_zone::EuropeChisinau),
    ("Europe/Ulyanovsk", time_zone::EuropeUlyanovsk),
    ("Europe/Uzhgorod", time_zone::EuropeUzhgorod),
    ("Europe/Vaduz", time_zone::EuropeBusingen),
    ("Europe/Vatican", time_zone::EuropeRome),
    ("Europe/Vienna", time_zone::EuropeVienna),
    ("Europe/Vilnius", time_zone::EuropeVilnius),
    ("Europe/Volgograd", time_zone::EuropeVolgograd),
    ("Europe/Warsaw", time_zone::EuropeWarsaw),
    ("Europe/Zagreb", time_zone::EuropeBelgrade),
    ("Europe/Zaporozhye", time_zone::EuropeZaporozhye),
    ("Europe/Zurich", time_zone::EuropeBusingen),
    ("Factory", time_zone::Factory),
    ("GB", time_zone::EuropeBelfast),
    ("GB-Eire", time_zone::EuropeBelfast),
    ("GMT", time_zone::EtcGmt),
    ("GMT0", time_zone::EtcGmt),
    ("GMT-0", time_zone::EtcGmt),
    ("GMT+0", time_zone::EtcGmt),
    ("Greenwich", time_zone::EtcGmt),
    ("Hongkong", time_zone::AsiaHongKong),
    ("HST", time_zone::Hst),
    ("Iceland", time_zone::AtlanticReykjavik),
    ("Indian/Antananarivo", time_zone::AfricaAddisAbaba),
    ("Indian/Chagos", time_zone::IndianChagos),
    ("Indian/Christmas", time_zone::IndianChristmas),
    ("Indian/Cocos", time_zone::IndianCocos),
    ("Indian/Comoro", time_zone::AfricaAddisAbaba),
    ("Indian/Kerguelen", time_zone::IndianKerguelen),
    ("Indian/Mahe", time_zone::IndianMahe),
    ("Indian/Maldives", time_zone::IndianMaldives),
    ("Indian/Mauritius", time_zone::IndianMauritius),
    ("Indian/Mayotte", time_zone::AfricaAddisAbaba),
    ("Indian/Reunion", time_zone::IndianReunion),
    ("Iran", time_zone::AsiaTehran),
    ("Israel", time_zone::AsiaJerusalem),
    ("Jamaica", time_zone::AmericaJamaica),
    ("Japan", time_zone::AsiaTokyo),
    ("Kwajalein", time_zone::Kwajalein),
    ("Libya", time_zone::AfricaTripoli),
    ("MET", time_zone::Met),
    ("Mexico/BajaNorte", time_zone::AmericaEnsenada),
    ("Mexico/BajaSur", time_zone::AmericaMazatlan),
    ("Mexico/General", time_zone::AmericaMexicoCity),
    ("MST", time_zone::Mst),
    ("MST7MDT", time_zone::Mst7Mdt),
    ("Navajo", time_zone::AmericaDenver),
    ("NZ", time_zone::AntarcticaMcMurdo),
    ("NZ-CHAT", time_zone::NzChat),
    ("Pacific/Apia", time_zone::PacificApia),
    ("Pacific/Auckland", time_zone::AntarcticaMcMurdo),
    ("Pacific/Bougainville", time_zone::PacificBougainville),
    ("Pacific/Chatham", time_zone::NzChat),
    ("Pacific/Chuuk", time_zone::PacificChuuk),
    ("Pacific/Easter", time_zone::ChileEasterIsland),
    ("Pacific/Efate", time_zone::PacificEfate),
    ("Pacific/Enderbury", time_zone::PacificEnderbury),
    ("Pacific/Fakaofo", time_zone::PacificFakaofo),
    ("Pacific/Fiji", time_zone::PacificFiji),
    ("Pacific/Funafuti", time_zone::PacificFunafuti),
    ("Pacific/Galapagos", time_zone::PacificGalapagos),
    ("Pacific/Gambier", time_zone::PacificGambier),
    ("Pacific/Guadalcanal", time_zone::PacificGuadalcanal),
    ("Pacific/Guam", time_zone::PacificGuam),
    ("Pacific/Honolulu", time_zone::PacificHonolulu),
    ("Pacific/Johnston", time_zone::PacificHonolulu),
    ("Pacific/Kanton", time_zone::PacificEnderbury),
    ("Pacific/Kiritimati", time_zone::PacificKiritimati),
    ("Pacific/Kosrae", time_zone::PacificKosrae),
    ("Pacific/Kwajalein", time_zone::Kwajalein),
    ("Pacific/Majuro", time_zone::PacificMajuro),
    ("Pacific/Marquesas", time_zone::PacificMarquesas),
    ("Pacific/Midway", time_zone::PacificMidway),
    ("Pacific/Nauru", time_zone::PacificNauru),
    ("Pacific/Niue", time_zone::PacificNiue),
    ("Pacific/Norfolk", time_zone::PacificNorfolk),
    ("Pacific/Noumea", time_zone::PacificNoumea),
    ("Pacific/Pago_Pago", time_zone::PacificMidway),
    ("Pacific/Palau", time_zone::PacificPalau),
    ("Pacific/Pitcairn", time_zone::PacificPitcairn),
    ("Pacific/Pohnpei", time_zone::PacificPohnpei),
    ("Pacific/Ponape", time_zone::PacificPohnpei),
    ("Pacific/Port_Moresby", time_zone::AntarcticaDumontDUrville),
    ("Pacific/Rarotonga", time_zone::PacificRarotonga),
    ("Pacific/Saipan", time_zone::PacificGuam),
    ("Pacific/Samoa", time_zone::PacificMidway),
    ("Pacific/Tahiti", time_zone::PacificTahiti),
    ("Pacific/Tarawa", time_zone::PacificTarawa),
    ("Pacific/Tongatapu", time_zone::PacificTongatapu),
    ("Pacific/Truk", time_zone::PacificChuuk),
    ("Pacific/Wake", time_zone::PacificWake),
    ("Pacific/Wallis", time_zone::PacificWallis),
    ("Pacific/Yap", time_zone::PacificChuuk),
    ("Poland", time_zone::EuropeWarsaw),
    ("Portugal", time_zone::EuropeLisbon),
    ("PRC", time_zone::AsiaChongqing),
    ("PST8PDT", time_zone::Pst8Pdt),
    ("ROC", time_zone::AsiaTaipei),
    ("ROK", time_zone::AsiaSeoul),
    ("Singapore", time_zone::AsiaSingapore),
    ("Turkey", time_zone::AsiaIstanbul),
    ("UCT", time_zone::EtcUct),
    ("Universal", time_zone::EtcUct),
    ("US/Alaska", time_zone::AmericaAnchorage),
    ("US/Aleutian", time_zone::AmericaAdak),
    ("US/Arizona", time_zone::AmericaCreston),
    ("US/Central", time_zone::AmericaChicago),
    ("US/East-Indiana", time_zone::AmericaFortWayne),
    ("US/Eastern", time_zone::AmericaNewYork),
    ("US/Hawaii", time_zone::PacificHonolulu),
    ("US/Indiana-Starke", time_zone::AmericaKnoxIn),
    ("US/Michigan", time_zone::AmericaDetroit),
    ("US/Mountain", time_zone::AmericaDenver),
    ("US/Pacific", time_zone::AmericaLosAngeles),
    ("US/Samoa", time_zone::PacificMidway),
    ("UTC", time_zone::EtcUct),
    ("W-SU", time_zone::EuropeMoscow),
    ("WET", time_zone::Wet),
    ("Zulu", time_zone::EtcUct),
];

#[allow(non_upper_case_globals)]
pub(crate) mod parsed {
    use super::*;

    pub(crate) static AfricaAbidjan: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaAddisAbaba: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaAlgiers: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaBangui: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaBissau: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaBlantyre: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaCairo: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaCasablanca: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaCeuta: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaElAaiun: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaJohannesburg: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaJuba: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaKhartoum: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaMonrovia: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaNdjamena: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaSaoTome: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaTripoli: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaTunis: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AfricaWindhoek: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaAdak: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaAnchorage: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaAnguilla: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaAraguaina: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaAsuncion: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaAtikokan: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaBahia: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaBahiaBanderas: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaBarbados: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaBelem: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaBelize: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaBoaVista: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaBogota: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaBoise: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaBuenosAires: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaCambridgeBay: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaCampoGrande: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaCancun: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaCaracas: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaCatamarca: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaCayenne: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaChicago: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaChihuahua: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaCordoba: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaCostaRica: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaCreston: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaCuiaba: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaDanmarkshavn: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaDawson: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaDawsonCreek: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaDenver: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaDetroit: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaEdmonton: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaEirunepe: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaElSalvador: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaEnsenada: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaFortNelson: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaFortWayne: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaFortaleza: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaGlaceBay: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaGodthab: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaGooseBay: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaGrandTurk: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaGuatemala: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaGuayaquil: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaGuyana: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaHalifax: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaHavana: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaHermosillo: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaInuvik: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaIqaluit: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaJamaica: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaJujuy: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaJuneau: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaKnoxIn: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaLaPaz: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaLima: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaLosAngeles: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaLouisville: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaMaceio: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaManagua: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaManaus: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaMartinique: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaMatamoros: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaMazatlan: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaMendoza: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaMenominee: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaMerida: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaMetlakatla: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaMexicoCity: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaMiquelon: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaMoncton: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaMonterrey: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaMontevideo: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaMontreal: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaNewYork: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaNipigon: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaNome: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaNoronha: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaOjinaga: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaPangnirtung: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaParamaribo: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaPortAuPrince: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaPortoAcre: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaPortoVelho: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaPuntaArenas: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaRainyRiver: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaRankinInlet: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaRecife: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaRegina: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaResolute: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaSantarem: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaSantiago: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaSantoDomingo: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaSaoPaulo: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaScoresbysund: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaSitka: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaStJohns: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaSwiftCurrent: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaTegucigalpa: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaThule: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaThunderBay: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaVancouver: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaWhitehorse: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaWinnipeg: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaYakutat: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AmericaYellowknife: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AntarcticaCasey: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AntarcticaDavis: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AntarcticaDumontDUrville: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AntarcticaMacquarie: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AntarcticaMawson: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AntarcticaMcMurdo: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AntarcticaPalmer: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AntarcticaRothera: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AntarcticaSyowa: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AntarcticaTroll: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AntarcticaVostok: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static ArcticLongyearbyen: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaAlmaty: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaAmman: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaAnadyr: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaAqtau: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaAqtobe: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaAshgabat: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaAtyrau: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaBaghdad: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaBahrain: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaBaku: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaBangkok: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaBarnaul: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaBeirut: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaBishkek: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaBrunei: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaCalcutta: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaChita: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaChoibalsan: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaChongqing: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaColombo: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaDacca: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaDamascus: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaDili: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaDubai: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaDushanbe: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaFamagusta: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaGaza: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaHebron: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaHoChiMinh: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaHongKong: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaHovd: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaIrkutsk: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaIstanbul: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaJakarta: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaJayapura: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaJerusalem: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaKabul: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaKamchatka: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaKarachi: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaKashgar: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaKathmandu: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaKhandyga: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaKrasnoyarsk: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaKualaLumpur: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaKuching: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaMacao: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaMagadan: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaMakassar: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaManila: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaNicosia: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaNovokuznetsk: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaNovosibirsk: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaOmsk: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaOral: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaPontianak: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaPyongyang: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaQostanay: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaQyzylorda: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaRangoon: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaSakhalin: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaSamarkand: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaSeoul: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaSingapore: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaSrednekolymsk: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaTaipei: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaTashkent: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaTbilisi: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaTehran: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaThimbu: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaTokyo: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaTomsk: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaUlaanbaatar: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaUstNera: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaVladivostok: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaYakutsk: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaYekaterinburg: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AsiaYerevan: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AtlanticAzores: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AtlanticBermuda: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AtlanticCanary: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AtlanticCapeVerde: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AtlanticFaeroe: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AtlanticMadeira: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AtlanticReykjavik: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AtlanticSouthGeorgia: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AtlanticStanley: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AustraliaAct: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AustraliaAdelaide: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AustraliaBrisbane: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AustraliaBrokenHill: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AustraliaCurrie: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AustraliaDarwin: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AustraliaEucla: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AustraliaLhi: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AustraliaLindeman: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AustraliaMelbourne: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static AustraliaPerth: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static Cet: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static ChileEasterIsland: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static Cst6Cdt: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static Eet: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static Eire: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static Est: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static Est5Edt: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmt: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtMinus1: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtMinus10: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtMinus11: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtMinus12: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtMinus13: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtMinus14: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtMinus2: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtMinus3: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtMinus4: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtMinus5: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtMinus6: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtMinus7: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtMinus8: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtMinus9: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtPlus1: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtPlus10: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtPlus11: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtPlus12: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtPlus2: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtPlus3: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtPlus4: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtPlus5: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtPlus6: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtPlus7: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtPlus8: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcGmtPlus9: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EtcUct: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeAmsterdam: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeAndorra: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeAstrakhan: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeAthens: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeBelfast: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeBelgrade: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeBerlin: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeBratislava: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeBrussels: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeBucharest: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeBudapest: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeBusingen: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeChisinau: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeCopenhagen: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeGibraltar: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeHelsinki: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeKaliningrad: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeKiev: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeKirov: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeLisbon: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeLuxembourg: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeMadrid: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeMalta: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeMinsk: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeMonaco: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeMoscow: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeParis: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeRiga: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeRome: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeSamara: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeSaratov: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeSimferopol: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeSofia: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeStockholm: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeTallinn: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeTirane: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeUlyanovsk: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeUzhgorod: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeVienna: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeVilnius: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeVolgograd: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeWarsaw: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static EuropeZaporozhye: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static Factory: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static Hst: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static IndianChagos: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static IndianChristmas: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static IndianCocos: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static IndianKerguelen: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static IndianMahe: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static IndianMaldives: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static IndianMauritius: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static IndianReunion: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static Kwajalein: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static Met: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static Mst: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static Mst7Mdt: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static NzChat: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificApia: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificBougainville: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificChuuk: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificEfate: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificEnderbury: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificFakaofo: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificFiji: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificFunafuti: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificGalapagos: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificGambier: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificGuadalcanal: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificGuam: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificHonolulu: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificKiritimati: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificKosrae: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificMajuro: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificMarquesas: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificMidway: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificNauru: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificNiue: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificNorfolk: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificNoumea: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificPalau: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificPitcairn: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificPohnpei: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificRarotonga: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificTahiti: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificTarawa: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificTongatapu: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificWake: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static PacificWallis: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static Pst8Pdt: OnceBox<TimeZone> = OnceBox::new();
    pub(crate) static Wet: OnceBox<TimeZone> = OnceBox::new();
}

#[allow(non_upper_case_globals)]
pub(crate) mod bytes {
    pub(crate) const AfricaAbidjan: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 0, 0, 0, 2, 0, 0, 0, 8, 255, 255, 255, 255, 146, 230, 146, 72, 1, 255, 255, 252, 56, 0,
        0, 0, 0, 0, 0, 0, 4, 76, 77, 84, 0, 71, 77, 84, 0, 10, 71, 77, 84, 48, 10,
    ];
    pub(crate) const AfricaAddisAbaba: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        5, 0, 0, 0, 4, 0, 0, 0, 20, 255, 255, 255, 255, 139, 255, 209, 252, 255, 255, 255, 255,
        177, 238, 218, 88, 255, 255, 255, 255, 180, 199, 224, 208, 255, 255, 255, 255, 193, 237,
        173, 88, 255, 255, 255, 255, 204, 108, 122, 212, 1, 2, 1, 3, 2, 0, 0, 34, 132, 0, 0, 0, 0,
        35, 40, 0, 4, 0, 0, 42, 48, 0, 10, 0, 0, 38, 172, 0, 14, 76, 77, 84, 0, 43, 48, 50, 51, 48,
        0, 69, 65, 84, 0, 43, 48, 50, 52, 53, 0, 10, 69, 65, 84, 45, 51, 10,
    ];
    pub(crate) const AfricaAlgiers: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        34, 0, 0, 0, 6, 0, 0, 0, 26, 255, 255, 255, 255, 107, 201, 155, 36, 255, 255, 255, 255,
        145, 96, 80, 79, 255, 255, 255, 255, 155, 71, 120, 240, 255, 255, 255, 255, 155, 215, 44,
        112, 255, 255, 255, 255, 156, 188, 145, 112, 255, 255, 255, 255, 157, 192, 72, 240, 255,
        255, 255, 255, 158, 137, 254, 112, 255, 255, 255, 255, 159, 160, 42, 240, 255, 255, 255,
        255, 160, 96, 165, 240, 255, 255, 255, 255, 161, 128, 12, 240, 255, 255, 255, 255, 162, 46,
        18, 240, 255, 255, 255, 255, 163, 122, 76, 240, 255, 255, 255, 255, 164, 53, 129, 240, 255,
        255, 255, 255, 164, 184, 6, 112, 255, 255, 255, 255, 198, 255, 6, 112, 255, 255, 255, 255,
        199, 88, 186, 128, 255, 255, 255, 255, 199, 218, 9, 160, 255, 255, 255, 255, 207, 146, 52,
        16, 255, 255, 255, 255, 208, 138, 0, 0, 255, 255, 255, 255, 209, 114, 22, 16, 255, 255,
        255, 255, 210, 78, 36, 112, 255, 255, 255, 255, 212, 75, 7, 112, 255, 255, 255, 255, 229,
        206, 211, 0, 255, 255, 255, 255, 243, 92, 176, 240, 0, 0, 0, 0, 2, 120, 193, 240, 0, 0, 0,
        0, 3, 67, 200, 240, 0, 0, 0, 0, 13, 207, 215, 0, 0, 0, 0, 0, 14, 173, 68, 240, 0, 0, 0, 0,
        15, 120, 90, 0, 0, 0, 0, 0, 16, 104, 89, 16, 0, 0, 0, 0, 18, 118, 67, 112, 0, 0, 0, 0, 19,
        102, 66, 128, 0, 0, 0, 0, 20, 95, 124, 16, 0, 0, 0, 0, 21, 79, 95, 0, 1, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 5, 4, 5, 4, 5, 3, 5, 3, 2, 3, 2, 5, 4, 5, 3, 2, 3, 5, 0, 0, 2,
        220, 0, 0, 0, 0, 2, 49, 0, 4, 0, 0, 14, 16, 1, 8, 0, 0, 0, 0, 0, 13, 0, 0, 28, 32, 1, 17,
        0, 0, 14, 16, 0, 22, 76, 77, 84, 0, 80, 77, 84, 0, 87, 69, 83, 84, 0, 87, 69, 84, 0, 67,
        69, 83, 84, 0, 67, 69, 84, 0, 10, 67, 69, 84, 45, 49, 10,
    ];
    pub(crate) const AfricaBangui: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        4, 0, 0, 0, 4, 0, 0, 0, 18, 255, 255, 255, 255, 134, 171, 112, 209, 255, 255, 255, 255,
        140, 80, 96, 0, 255, 255, 255, 255, 150, 170, 67, 209, 255, 255, 255, 255, 161, 81, 239,
        120, 1, 0, 2, 3, 0, 0, 3, 47, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 7, 8, 0, 8, 0, 0, 14, 16, 0,
        14, 76, 77, 84, 0, 71, 77, 84, 0, 43, 48, 48, 51, 48, 0, 87, 65, 84, 0, 10, 87, 65, 84, 45,
        49, 10,
    ];
    pub(crate) const AfricaBissau: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        2, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 146, 230, 156, 144, 0, 0, 0, 0, 9, 103, 97,
        16, 1, 2, 255, 255, 241, 100, 0, 0, 255, 255, 241, 240, 0, 4, 0, 0, 0, 0, 0, 8, 76, 77, 84,
        0, 45, 48, 49, 0, 71, 77, 84, 0, 10, 71, 77, 84, 48, 10,
    ];
    pub(crate) const AfricaBlantyre: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 0, 0, 0, 2, 0, 0, 0, 8, 255, 255, 255, 255, 130, 70, 197, 244, 1, 0, 0, 30, 140, 0, 0,
        0, 0, 28, 32, 0, 4, 76, 77, 84, 0, 67, 65, 84, 0, 10, 67, 65, 84, 45, 50, 10,
    ];
    pub(crate) const AfricaCairo: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        127, 0, 0, 0, 3, 0, 0, 0, 13, 255, 255, 255, 255, 125, 189, 77, 171, 255, 255, 255, 255,
        200, 147, 180, 224, 255, 255, 255, 255, 200, 250, 123, 208, 255, 255, 255, 255, 201, 252,
        239, 224, 255, 255, 255, 255, 202, 199, 232, 208, 255, 255, 255, 255, 203, 203, 174, 96,
        255, 255, 255, 255, 204, 223, 41, 208, 255, 255, 255, 255, 205, 172, 225, 224, 255, 255,
        255, 255, 206, 198, 244, 208, 255, 255, 255, 255, 207, 143, 102, 224, 255, 255, 255, 255,
        208, 169, 121, 208, 255, 255, 255, 255, 209, 132, 96, 224, 255, 255, 255, 255, 210, 138,
        173, 80, 255, 255, 255, 255, 232, 54, 99, 96, 255, 255, 255, 255, 232, 244, 45, 80, 255,
        255, 255, 255, 234, 11, 185, 96, 255, 255, 255, 255, 234, 213, 96, 208, 255, 255, 255, 255,
        235, 236, 250, 240, 255, 255, 255, 255, 236, 181, 109, 0, 255, 255, 255, 255, 237, 207,
        127, 240, 255, 255, 255, 255, 238, 151, 242, 0, 255, 255, 255, 255, 239, 176, 179, 112,
        255, 255, 255, 255, 240, 121, 37, 128, 255, 255, 255, 255, 241, 145, 230, 240, 255, 255,
        255, 255, 242, 90, 89, 0, 255, 255, 255, 255, 243, 115, 26, 112, 255, 255, 255, 255, 244,
        59, 140, 128, 255, 255, 255, 255, 245, 85, 159, 112, 255, 255, 255, 255, 246, 30, 17, 128,
        255, 255, 255, 255, 247, 54, 210, 240, 255, 255, 255, 255, 247, 255, 69, 0, 255, 255, 255,
        255, 249, 24, 6, 112, 255, 255, 255, 255, 249, 225, 202, 0, 255, 255, 255, 255, 250, 249,
        57, 240, 255, 255, 255, 255, 251, 194, 253, 128, 255, 255, 255, 255, 252, 219, 190, 240,
        255, 255, 255, 255, 253, 165, 130, 128, 255, 255, 255, 255, 254, 188, 242, 112, 255, 255,
        255, 255, 255, 134, 182, 0, 0, 0, 0, 0, 0, 158, 37, 240, 0, 0, 0, 0, 1, 103, 233, 128, 0,
        0, 0, 0, 2, 127, 89, 112, 0, 0, 0, 0, 3, 73, 29, 0, 0, 0, 0, 0, 4, 97, 222, 112, 0, 0, 0,
        0, 5, 43, 162, 0, 0, 0, 0, 0, 6, 67, 17, 240, 0, 0, 0, 0, 7, 12, 213, 128, 0, 0, 0, 0, 8,
        36, 69, 112, 0, 0, 0, 0, 8, 238, 9, 0, 0, 0, 0, 0, 10, 5, 120, 240, 0, 0, 0, 0, 10, 207,
        60, 128, 0, 0, 0, 0, 11, 231, 253, 240, 0, 0, 0, 0, 12, 177, 193, 128, 0, 0, 0, 0, 13, 201,
        49, 112, 0, 0, 0, 0, 14, 146, 245, 0, 0, 0, 0, 0, 15, 170, 100, 240, 0, 0, 0, 0, 16, 116,
        40, 128, 0, 0, 0, 0, 17, 139, 152, 112, 0, 0, 0, 0, 18, 85, 92, 0, 0, 0, 0, 0, 19, 110, 29,
        112, 0, 0, 0, 0, 20, 55, 225, 0, 0, 0, 0, 0, 21, 79, 80, 240, 0, 0, 0, 0, 22, 25, 20, 128,
        0, 0, 0, 0, 23, 160, 147, 240, 0, 0, 0, 0, 23, 250, 72, 0, 0, 0, 0, 0, 25, 112, 163, 240,
        0, 0, 0, 0, 25, 219, 123, 128, 0, 0, 0, 0, 26, 244, 60, 240, 0, 0, 0, 0, 27, 190, 0, 128,
        0, 0, 0, 0, 28, 213, 112, 112, 0, 0, 0, 0, 29, 159, 52, 0, 0, 0, 0, 0, 30, 182, 163, 240,
        0, 0, 0, 0, 31, 128, 103, 128, 0, 0, 0, 0, 32, 151, 215, 112, 0, 0, 0, 0, 33, 97, 155, 0,
        0, 0, 0, 0, 34, 122, 92, 112, 0, 0, 0, 0, 35, 68, 32, 0, 0, 0, 0, 0, 36, 98, 39, 112, 0, 0,
        0, 0, 37, 37, 83, 128, 0, 0, 0, 0, 38, 60, 195, 112, 0, 0, 0, 0, 39, 6, 135, 0, 0, 0, 0, 0,
        40, 29, 246, 240, 0, 0, 0, 0, 40, 231, 186, 128, 0, 0, 0, 0, 42, 0, 123, 240, 0, 0, 0, 0,
        42, 202, 63, 128, 0, 0, 0, 0, 43, 225, 175, 112, 0, 0, 0, 0, 44, 171, 115, 0, 0, 0, 0, 0,
        45, 194, 226, 240, 0, 0, 0, 0, 46, 140, 166, 128, 0, 0, 0, 0, 47, 160, 19, 224, 0, 0, 0, 0,
        48, 107, 12, 208, 0, 0, 0, 0, 49, 127, 245, 224, 0, 0, 0, 0, 50, 74, 238, 208, 0, 0, 0, 0,
        51, 95, 215, 224, 0, 0, 0, 0, 52, 42, 208, 208, 0, 0, 0, 0, 53, 63, 185, 224, 0, 0, 0, 0,
        54, 10, 178, 208, 0, 0, 0, 0, 55, 40, 214, 96, 0, 0, 0, 0, 55, 243, 207, 80, 0, 0, 0, 0,
        57, 8, 184, 96, 0, 0, 0, 0, 57, 211, 177, 80, 0, 0, 0, 0, 58, 232, 154, 96, 0, 0, 0, 0, 59,
        179, 147, 80, 0, 0, 0, 0, 60, 200, 124, 96, 0, 0, 0, 0, 61, 147, 117, 80, 0, 0, 0, 0, 62,
        168, 94, 96, 0, 0, 0, 0, 63, 115, 87, 80, 0, 0, 0, 0, 64, 145, 122, 224, 0, 0, 0, 0, 65,
        92, 115, 208, 0, 0, 0, 0, 66, 113, 92, 224, 0, 0, 0, 0, 67, 60, 85, 208, 0, 0, 0, 0, 68,
        81, 62, 224, 0, 0, 0, 0, 69, 18, 253, 80, 0, 0, 0, 0, 70, 49, 32, 224, 0, 0, 0, 0, 70, 224,
        106, 80, 0, 0, 0, 0, 72, 17, 2, 224, 0, 0, 0, 0, 72, 183, 17, 208, 0, 0, 0, 0, 73, 240,
        228, 224, 0, 0, 0, 0, 74, 141, 185, 80, 0, 0, 0, 0, 75, 218, 1, 96, 0, 0, 0, 0, 76, 97,
        189, 208, 0, 0, 0, 0, 76, 137, 88, 224, 0, 0, 0, 0, 76, 164, 250, 80, 0, 0, 0, 0, 83, 117,
        56, 224, 0, 0, 0, 0, 83, 172, 137, 208, 0, 0, 0, 0, 83, 218, 188, 96, 0, 0, 0, 0, 84, 36,
        130, 80, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 0, 29, 85, 0, 0, 0, 0, 42, 48, 1, 4, 0, 0, 28, 32, 0, 9,
        76, 77, 84, 0, 69, 69, 83, 84, 0, 69, 69, 84, 0, 10, 69, 69, 84, 45, 50, 10,
    ];
    pub(crate) const AfricaCasablanca: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        197, 0, 0, 0, 5, 0, 0, 0, 12, 255, 255, 255, 255, 150, 81, 249, 156, 255, 255, 255, 255,
        198, 255, 20, 128, 255, 255, 255, 255, 199, 88, 172, 112, 255, 255, 255, 255, 199, 217,
        237, 128, 255, 255, 255, 255, 210, 161, 50, 240, 255, 255, 255, 255, 219, 53, 164, 0, 255,
        255, 255, 255, 219, 238, 39, 240, 255, 255, 255, 255, 251, 37, 114, 64, 255, 255, 255, 255,
        251, 194, 239, 112, 0, 0, 0, 0, 8, 107, 132, 128, 0, 0, 0, 0, 8, 198, 109, 240, 0, 0, 0, 0,
        11, 232, 12, 0, 0, 0, 0, 0, 12, 97, 71, 240, 0, 0, 0, 0, 13, 201, 63, 128, 0, 0, 0, 0, 14,
        142, 242, 112, 0, 0, 0, 0, 15, 211, 81, 128, 0, 0, 0, 0, 16, 39, 163, 112, 0, 0, 0, 0, 26,
        183, 166, 0, 0, 0, 0, 0, 30, 24, 111, 240, 0, 0, 0, 0, 72, 65, 230, 128, 0, 0, 0, 0, 72,
        187, 34, 112, 0, 0, 0, 0, 74, 35, 26, 0, 0, 0, 0, 0, 74, 141, 213, 112, 0, 0, 0, 0, 75,
        220, 192, 128, 0, 0, 0, 0, 76, 93, 229, 112, 0, 0, 0, 0, 77, 151, 184, 128, 0, 0, 0, 0, 78,
        52, 140, 240, 0, 0, 0, 0, 79, 156, 160, 160, 0, 0, 0, 0, 80, 8, 187, 160, 0, 0, 0, 0, 80,
        49, 154, 32, 0, 0, 0, 0, 80, 103, 167, 160, 0, 0, 0, 0, 81, 124, 130, 160, 0, 0, 0, 0, 81,
        216, 203, 160, 0, 0, 0, 0, 82, 5, 158, 160, 0, 0, 0, 0, 82, 108, 115, 160, 0, 0, 0, 0, 83,
        55, 122, 160, 0, 0, 0, 0, 83, 174, 33, 160, 0, 0, 0, 0, 83, 220, 70, 32, 0, 0, 0, 0, 84,
        76, 85, 160, 0, 0, 0, 0, 85, 23, 92, 160, 0, 0, 0, 0, 85, 124, 224, 32, 0, 0, 0, 0, 85,
        171, 4, 160, 0, 0, 0, 0, 86, 44, 55, 160, 0, 0, 0, 0, 86, 247, 62, 160, 0, 0, 0, 0, 87, 83,
        135, 160, 0, 0, 0, 0, 87, 129, 172, 32, 0, 0, 0, 0, 88, 21, 84, 32, 0, 0, 0, 0, 88, 215,
        32, 160, 0, 0, 0, 0, 89, 32, 244, 160, 0, 0, 0, 0, 89, 88, 83, 160, 0, 0, 0, 0, 89, 245,
        54, 32, 0, 0, 0, 0, 90, 183, 2, 160, 0, 0, 0, 0, 90, 247, 156, 32, 0, 0, 0, 0, 91, 37, 192,
        160, 0, 0, 0, 0, 91, 213, 24, 32, 0, 0, 0, 0, 92, 206, 67, 160, 0, 0, 0, 0, 92, 252, 104,
        32, 0, 0, 0, 0, 94, 155, 176, 160, 0, 0, 0, 0, 94, 211, 15, 160, 0, 0, 0, 0, 96, 114, 88,
        32, 0, 0, 0, 0, 96, 160, 124, 160, 0, 0, 0, 0, 98, 63, 197, 32, 0, 0, 0, 0, 98, 119, 36,
        32, 0, 0, 0, 0, 100, 22, 108, 160, 0, 0, 0, 0, 100, 77, 203, 160, 0, 0, 0, 0, 101, 237, 20,
        32, 0, 0, 0, 0, 102, 27, 56, 160, 0, 0, 0, 0, 103, 186, 129, 32, 0, 0, 0, 0, 103, 241, 224,
        32, 0, 0, 0, 0, 105, 145, 40, 160, 0, 0, 0, 0, 105, 191, 77, 32, 0, 0, 0, 0, 107, 103, 208,
        32, 0, 0, 0, 0, 107, 149, 244, 160, 0, 0, 0, 0, 109, 53, 61, 32, 0, 0, 0, 0, 109, 108, 156,
        32, 0, 0, 0, 0, 111, 11, 228, 160, 0, 0, 0, 0, 111, 58, 9, 32, 0, 0, 0, 0, 112, 217, 81,
        160, 0, 0, 0, 0, 113, 16, 176, 160, 0, 0, 0, 0, 114, 175, 249, 32, 0, 0, 0, 0, 114, 231,
        88, 32, 0, 0, 0, 0, 116, 134, 160, 160, 0, 0, 0, 0, 116, 180, 197, 32, 0, 0, 0, 0, 118, 84,
        13, 160, 0, 0, 0, 0, 118, 139, 108, 160, 0, 0, 0, 0, 120, 42, 181, 32, 0, 0, 0, 0, 120, 88,
        217, 160, 0, 0, 0, 0, 121, 248, 34, 32, 0, 0, 0, 0, 122, 47, 129, 32, 0, 0, 0, 0, 123, 206,
        201, 160, 0, 0, 0, 0, 124, 6, 40, 160, 0, 0, 0, 0, 125, 165, 113, 32, 0, 0, 0, 0, 125, 211,
        149, 160, 0, 0, 0, 0, 127, 114, 222, 32, 0, 0, 0, 0, 127, 170, 61, 32, 0, 0, 0, 0, 129, 73,
        133, 160, 0, 0, 0, 0, 129, 128, 228, 160, 0, 0, 0, 0, 131, 32, 45, 32, 0, 0, 0, 0, 131, 78,
        81, 160, 0, 0, 0, 0, 132, 237, 154, 32, 0, 0, 0, 0, 133, 36, 249, 32, 0, 0, 0, 0, 134, 196,
        65, 160, 0, 0, 0, 0, 134, 242, 102, 32, 0, 0, 0, 0, 136, 145, 174, 160, 0, 0, 0, 0, 136,
        201, 13, 160, 0, 0, 0, 0, 138, 104, 86, 32, 0, 0, 0, 0, 138, 159, 181, 32, 0, 0, 0, 0, 140,
        62, 253, 160, 0, 0, 0, 0, 140, 109, 34, 32, 0, 0, 0, 0, 142, 12, 106, 160, 0, 0, 0, 0, 142,
        67, 201, 160, 0, 0, 0, 0, 143, 227, 18, 32, 0, 0, 0, 0, 144, 26, 113, 32, 0, 0, 0, 0, 145,
        185, 185, 160, 0, 0, 0, 0, 145, 231, 222, 32, 0, 0, 0, 0, 147, 135, 38, 160, 0, 0, 0, 0,
        147, 190, 133, 160, 0, 0, 0, 0, 149, 93, 206, 32, 0, 0, 0, 0, 149, 139, 242, 160, 0, 0, 0,
        0, 151, 43, 59, 32, 0, 0, 0, 0, 151, 98, 154, 32, 0, 0, 0, 0, 153, 1, 226, 160, 0, 0, 0, 0,
        153, 57, 65, 160, 0, 0, 0, 0, 154, 216, 138, 32, 0, 0, 0, 0, 155, 6, 174, 160, 0, 0, 0, 0,
        156, 165, 247, 32, 0, 0, 0, 0, 156, 221, 86, 32, 0, 0, 0, 0, 158, 124, 158, 160, 0, 0, 0,
        0, 158, 179, 253, 160, 0, 0, 0, 0, 160, 83, 70, 32, 0, 0, 0, 0, 160, 129, 106, 160, 0, 0,
        0, 0, 162, 32, 179, 32, 0, 0, 0, 0, 162, 88, 18, 32, 0, 0, 0, 0, 163, 247, 90, 160, 0, 0,
        0, 0, 164, 37, 127, 32, 0, 0, 0, 0, 165, 196, 199, 160, 0, 0, 0, 0, 165, 252, 38, 160, 0,
        0, 0, 0, 167, 155, 111, 32, 0, 0, 0, 0, 167, 210, 206, 32, 0, 0, 0, 0, 169, 114, 22, 160,
        0, 0, 0, 0, 169, 160, 59, 32, 0, 0, 0, 0, 171, 63, 131, 160, 0, 0, 0, 0, 171, 118, 226,
        160, 0, 0, 0, 0, 173, 22, 43, 32, 0, 0, 0, 0, 173, 77, 138, 32, 0, 0, 0, 0, 174, 236, 210,
        160, 0, 0, 0, 0, 175, 26, 247, 32, 0, 0, 0, 0, 176, 186, 63, 160, 0, 0, 0, 0, 176, 241,
        158, 160, 0, 0, 0, 0, 178, 144, 231, 32, 0, 0, 0, 0, 178, 191, 11, 160, 0, 0, 0, 0, 180,
        94, 84, 32, 0, 0, 0, 0, 180, 149, 179, 32, 0, 0, 0, 0, 182, 52, 251, 160, 0, 0, 0, 0, 182,
        108, 90, 160, 0, 0, 0, 0, 184, 11, 163, 32, 0, 0, 0, 0, 184, 57, 199, 160, 0, 0, 0, 0, 185,
        217, 16, 32, 0, 0, 0, 0, 186, 16, 111, 32, 0, 0, 0, 0, 187, 175, 183, 160, 0, 0, 0, 0, 187,
        231, 22, 160, 0, 0, 0, 0, 189, 134, 95, 32, 0, 0, 0, 0, 189, 180, 131, 160, 0, 0, 0, 0,
        191, 83, 204, 32, 0, 0, 0, 0, 191, 139, 43, 32, 0, 0, 0, 0, 193, 42, 115, 160, 0, 0, 0, 0,
        193, 88, 152, 32, 0, 0, 0, 0, 194, 247, 224, 160, 0, 0, 0, 0, 195, 47, 63, 160, 0, 0, 0, 0,
        196, 206, 136, 32, 0, 0, 0, 0, 197, 5, 231, 32, 0, 0, 0, 0, 198, 165, 47, 160, 0, 0, 0, 0,
        198, 211, 84, 32, 0, 0, 0, 0, 200, 114, 156, 160, 0, 0, 0, 0, 200, 169, 251, 160, 0, 0, 0,
        0, 202, 73, 68, 32, 0, 0, 0, 0, 202, 128, 163, 32, 0, 0, 0, 0, 204, 31, 235, 160, 0, 0, 0,
        0, 204, 78, 16, 32, 0, 0, 0, 0, 205, 237, 88, 160, 0, 0, 0, 0, 206, 36, 183, 160, 0, 0, 0,
        0, 207, 196, 0, 32, 0, 0, 0, 0, 207, 242, 36, 160, 0, 0, 0, 0, 209, 145, 109, 32, 0, 0, 0,
        0, 209, 200, 204, 32, 0, 0, 0, 0, 211, 104, 20, 160, 0, 0, 0, 0, 211, 159, 115, 160, 0, 0,
        0, 0, 213, 62, 188, 32, 0, 0, 0, 0, 213, 108, 224, 160, 0, 0, 0, 0, 215, 12, 41, 32, 0, 0,
        0, 0, 215, 67, 136, 32, 0, 0, 0, 0, 216, 226, 208, 160, 0, 0, 0, 0, 217, 26, 47, 160, 0, 0,
        0, 0, 218, 185, 120, 32, 0, 0, 0, 0, 218, 231, 156, 160, 0, 0, 0, 0, 220, 134, 229, 32, 0,
        0, 0, 0, 220, 190, 68, 32, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 255, 255,
        248, 228, 0, 0, 0, 0, 14, 16, 1, 4, 0, 0, 0, 0, 0, 8, 0, 0, 14, 16, 0, 4, 0, 0, 0, 0, 1, 8,
        76, 77, 84, 0, 43, 48, 49, 0, 43, 48, 48, 0, 10, 60, 43, 48, 49, 62, 45, 49, 10,
    ];
    pub(crate) const AfricaCeuta: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        43, 0, 0, 0, 5, 0, 0, 0, 22, 255, 255, 255, 255, 126, 54, 181, 0, 255, 255, 255, 255, 158,
        214, 117, 112, 255, 255, 255, 255, 159, 161, 110, 96, 255, 255, 255, 255, 170, 5, 239, 112,
        255, 255, 255, 255, 170, 231, 110, 0, 255, 255, 255, 255, 173, 201, 167, 240, 255, 255,
        255, 255, 174, 167, 50, 0, 255, 255, 255, 255, 175, 160, 79, 112, 255, 255, 255, 255, 176,
        135, 20, 0, 255, 255, 255, 255, 177, 137, 122, 0, 255, 255, 255, 255, 178, 112, 48, 128,
        255, 255, 255, 255, 251, 37, 114, 64, 255, 255, 255, 255, 251, 194, 239, 112, 0, 0, 0, 0,
        8, 107, 132, 128, 0, 0, 0, 0, 8, 198, 109, 240, 0, 0, 0, 0, 11, 232, 12, 0, 0, 0, 0, 0, 12,
        97, 71, 240, 0, 0, 0, 0, 13, 201, 63, 128, 0, 0, 0, 0, 14, 142, 242, 112, 0, 0, 0, 0, 15,
        211, 81, 128, 0, 0, 0, 0, 16, 39, 163, 112, 0, 0, 0, 0, 26, 183, 166, 0, 0, 0, 0, 0, 30,
        140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33,
        92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54,
        16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0,
        0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0,
        0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0,
        0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144,
        0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 255, 255, 251, 4, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 16, 1, 8, 0, 0, 14, 16, 0, 13,
        0, 0, 28, 32, 1, 17, 76, 77, 84, 0, 87, 69, 84, 0, 87, 69, 83, 84, 0, 67, 69, 84, 0, 67,
        69, 83, 84, 0, 10, 67, 69, 84, 45, 49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77,
        49, 48, 46, 53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const AfricaElAaiun: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        186, 0, 0, 0, 6, 0, 0, 0, 16, 255, 255, 255, 255, 188, 72, 240, 224, 0, 0, 0, 0, 11, 209,
        176, 144, 0, 0, 0, 0, 11, 232, 12, 0, 0, 0, 0, 0, 12, 97, 71, 240, 0, 0, 0, 0, 13, 201, 63,
        128, 0, 0, 0, 0, 14, 142, 242, 112, 0, 0, 0, 0, 15, 211, 81, 128, 0, 0, 0, 0, 16, 39, 163,
        112, 0, 0, 0, 0, 72, 65, 230, 128, 0, 0, 0, 0, 72, 187, 34, 112, 0, 0, 0, 0, 74, 35, 26, 0,
        0, 0, 0, 0, 74, 141, 213, 112, 0, 0, 0, 0, 75, 220, 192, 128, 0, 0, 0, 0, 76, 93, 229, 112,
        0, 0, 0, 0, 77, 151, 184, 128, 0, 0, 0, 0, 78, 52, 140, 240, 0, 0, 0, 0, 79, 156, 160, 160,
        0, 0, 0, 0, 80, 8, 187, 160, 0, 0, 0, 0, 80, 49, 154, 32, 0, 0, 0, 0, 80, 103, 167, 160, 0,
        0, 0, 0, 81, 124, 130, 160, 0, 0, 0, 0, 81, 216, 203, 160, 0, 0, 0, 0, 82, 5, 158, 160, 0,
        0, 0, 0, 82, 108, 115, 160, 0, 0, 0, 0, 83, 55, 122, 160, 0, 0, 0, 0, 83, 174, 33, 160, 0,
        0, 0, 0, 83, 220, 70, 32, 0, 0, 0, 0, 84, 76, 85, 160, 0, 0, 0, 0, 85, 23, 92, 160, 0, 0,
        0, 0, 85, 124, 224, 32, 0, 0, 0, 0, 85, 171, 4, 160, 0, 0, 0, 0, 86, 44, 55, 160, 0, 0, 0,
        0, 86, 247, 62, 160, 0, 0, 0, 0, 87, 83, 135, 160, 0, 0, 0, 0, 87, 129, 172, 32, 0, 0, 0,
        0, 88, 21, 84, 32, 0, 0, 0, 0, 88, 215, 32, 160, 0, 0, 0, 0, 89, 32, 244, 160, 0, 0, 0, 0,
        89, 88, 83, 160, 0, 0, 0, 0, 89, 245, 54, 32, 0, 0, 0, 0, 90, 183, 2, 160, 0, 0, 0, 0, 90,
        247, 156, 32, 0, 0, 0, 0, 91, 37, 192, 160, 0, 0, 0, 0, 91, 213, 24, 32, 0, 0, 0, 0, 92,
        206, 67, 160, 0, 0, 0, 0, 92, 252, 104, 32, 0, 0, 0, 0, 94, 155, 176, 160, 0, 0, 0, 0, 94,
        211, 15, 160, 0, 0, 0, 0, 96, 114, 88, 32, 0, 0, 0, 0, 96, 160, 124, 160, 0, 0, 0, 0, 98,
        63, 197, 32, 0, 0, 0, 0, 98, 119, 36, 32, 0, 0, 0, 0, 100, 22, 108, 160, 0, 0, 0, 0, 100,
        77, 203, 160, 0, 0, 0, 0, 101, 237, 20, 32, 0, 0, 0, 0, 102, 27, 56, 160, 0, 0, 0, 0, 103,
        186, 129, 32, 0, 0, 0, 0, 103, 241, 224, 32, 0, 0, 0, 0, 105, 145, 40, 160, 0, 0, 0, 0,
        105, 191, 77, 32, 0, 0, 0, 0, 107, 103, 208, 32, 0, 0, 0, 0, 107, 149, 244, 160, 0, 0, 0,
        0, 109, 53, 61, 32, 0, 0, 0, 0, 109, 108, 156, 32, 0, 0, 0, 0, 111, 11, 228, 160, 0, 0, 0,
        0, 111, 58, 9, 32, 0, 0, 0, 0, 112, 217, 81, 160, 0, 0, 0, 0, 113, 16, 176, 160, 0, 0, 0,
        0, 114, 175, 249, 32, 0, 0, 0, 0, 114, 231, 88, 32, 0, 0, 0, 0, 116, 134, 160, 160, 0, 0,
        0, 0, 116, 180, 197, 32, 0, 0, 0, 0, 118, 84, 13, 160, 0, 0, 0, 0, 118, 139, 108, 160, 0,
        0, 0, 0, 120, 42, 181, 32, 0, 0, 0, 0, 120, 88, 217, 160, 0, 0, 0, 0, 121, 248, 34, 32, 0,
        0, 0, 0, 122, 47, 129, 32, 0, 0, 0, 0, 123, 206, 201, 160, 0, 0, 0, 0, 124, 6, 40, 160, 0,
        0, 0, 0, 125, 165, 113, 32, 0, 0, 0, 0, 125, 211, 149, 160, 0, 0, 0, 0, 127, 114, 222, 32,
        0, 0, 0, 0, 127, 170, 61, 32, 0, 0, 0, 0, 129, 73, 133, 160, 0, 0, 0, 0, 129, 128, 228,
        160, 0, 0, 0, 0, 131, 32, 45, 32, 0, 0, 0, 0, 131, 78, 81, 160, 0, 0, 0, 0, 132, 237, 154,
        32, 0, 0, 0, 0, 133, 36, 249, 32, 0, 0, 0, 0, 134, 196, 65, 160, 0, 0, 0, 0, 134, 242, 102,
        32, 0, 0, 0, 0, 136, 145, 174, 160, 0, 0, 0, 0, 136, 201, 13, 160, 0, 0, 0, 0, 138, 104,
        86, 32, 0, 0, 0, 0, 138, 159, 181, 32, 0, 0, 0, 0, 140, 62, 253, 160, 0, 0, 0, 0, 140, 109,
        34, 32, 0, 0, 0, 0, 142, 12, 106, 160, 0, 0, 0, 0, 142, 67, 201, 160, 0, 0, 0, 0, 143, 227,
        18, 32, 0, 0, 0, 0, 144, 26, 113, 32, 0, 0, 0, 0, 145, 185, 185, 160, 0, 0, 0, 0, 145, 231,
        222, 32, 0, 0, 0, 0, 147, 135, 38, 160, 0, 0, 0, 0, 147, 190, 133, 160, 0, 0, 0, 0, 149,
        93, 206, 32, 0, 0, 0, 0, 149, 139, 242, 160, 0, 0, 0, 0, 151, 43, 59, 32, 0, 0, 0, 0, 151,
        98, 154, 32, 0, 0, 0, 0, 153, 1, 226, 160, 0, 0, 0, 0, 153, 57, 65, 160, 0, 0, 0, 0, 154,
        216, 138, 32, 0, 0, 0, 0, 155, 6, 174, 160, 0, 0, 0, 0, 156, 165, 247, 32, 0, 0, 0, 0, 156,
        221, 86, 32, 0, 0, 0, 0, 158, 124, 158, 160, 0, 0, 0, 0, 158, 179, 253, 160, 0, 0, 0, 0,
        160, 83, 70, 32, 0, 0, 0, 0, 160, 129, 106, 160, 0, 0, 0, 0, 162, 32, 179, 32, 0, 0, 0, 0,
        162, 88, 18, 32, 0, 0, 0, 0, 163, 247, 90, 160, 0, 0, 0, 0, 164, 37, 127, 32, 0, 0, 0, 0,
        165, 196, 199, 160, 0, 0, 0, 0, 165, 252, 38, 160, 0, 0, 0, 0, 167, 155, 111, 32, 0, 0, 0,
        0, 167, 210, 206, 32, 0, 0, 0, 0, 169, 114, 22, 160, 0, 0, 0, 0, 169, 160, 59, 32, 0, 0, 0,
        0, 171, 63, 131, 160, 0, 0, 0, 0, 171, 118, 226, 160, 0, 0, 0, 0, 173, 22, 43, 32, 0, 0, 0,
        0, 173, 77, 138, 32, 0, 0, 0, 0, 174, 236, 210, 160, 0, 0, 0, 0, 175, 26, 247, 32, 0, 0, 0,
        0, 176, 186, 63, 160, 0, 0, 0, 0, 176, 241, 158, 160, 0, 0, 0, 0, 178, 144, 231, 32, 0, 0,
        0, 0, 178, 191, 11, 160, 0, 0, 0, 0, 180, 94, 84, 32, 0, 0, 0, 0, 180, 149, 179, 32, 0, 0,
        0, 0, 182, 52, 251, 160, 0, 0, 0, 0, 182, 108, 90, 160, 0, 0, 0, 0, 184, 11, 163, 32, 0, 0,
        0, 0, 184, 57, 199, 160, 0, 0, 0, 0, 185, 217, 16, 32, 0, 0, 0, 0, 186, 16, 111, 32, 0, 0,
        0, 0, 187, 175, 183, 160, 0, 0, 0, 0, 187, 231, 22, 160, 0, 0, 0, 0, 189, 134, 95, 32, 0,
        0, 0, 0, 189, 180, 131, 160, 0, 0, 0, 0, 191, 83, 204, 32, 0, 0, 0, 0, 191, 139, 43, 32, 0,
        0, 0, 0, 193, 42, 115, 160, 0, 0, 0, 0, 193, 88, 152, 32, 0, 0, 0, 0, 194, 247, 224, 160,
        0, 0, 0, 0, 195, 47, 63, 160, 0, 0, 0, 0, 196, 206, 136, 32, 0, 0, 0, 0, 197, 5, 231, 32,
        0, 0, 0, 0, 198, 165, 47, 160, 0, 0, 0, 0, 198, 211, 84, 32, 0, 0, 0, 0, 200, 114, 156,
        160, 0, 0, 0, 0, 200, 169, 251, 160, 0, 0, 0, 0, 202, 73, 68, 32, 0, 0, 0, 0, 202, 128,
        163, 32, 0, 0, 0, 0, 204, 31, 235, 160, 0, 0, 0, 0, 204, 78, 16, 32, 0, 0, 0, 0, 205, 237,
        88, 160, 0, 0, 0, 0, 206, 36, 183, 160, 0, 0, 0, 0, 207, 196, 0, 32, 0, 0, 0, 0, 207, 242,
        36, 160, 0, 0, 0, 0, 209, 145, 109, 32, 0, 0, 0, 0, 209, 200, 204, 32, 0, 0, 0, 0, 211,
        104, 20, 160, 0, 0, 0, 0, 211, 159, 115, 160, 0, 0, 0, 0, 213, 62, 188, 32, 0, 0, 0, 0,
        213, 108, 224, 160, 0, 0, 0, 0, 215, 12, 41, 32, 0, 0, 0, 0, 215, 67, 136, 32, 0, 0, 0, 0,
        216, 226, 208, 160, 0, 0, 0, 0, 217, 26, 47, 160, 0, 0, 0, 0, 218, 185, 120, 32, 0, 0, 0,
        0, 218, 231, 156, 160, 0, 0, 0, 0, 220, 134, 229, 32, 0, 0, 0, 0, 220, 190, 68, 32, 1, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5,
        4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5,
        4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5,
        4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5,
        4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5,
        4, 5, 4, 5, 255, 255, 243, 160, 0, 0, 255, 255, 241, 240, 0, 4, 0, 0, 14, 16, 1, 8, 0, 0,
        0, 0, 0, 12, 0, 0, 0, 0, 1, 12, 0, 0, 14, 16, 0, 8, 76, 77, 84, 0, 45, 48, 49, 0, 43, 48,
        49, 0, 43, 48, 48, 0, 10, 60, 43, 48, 49, 62, 45, 49, 10,
    ];
    pub(crate) const AfricaJohannesburg: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        6, 0, 0, 0, 4, 0, 0, 0, 9, 255, 255, 255, 255, 109, 123, 65, 64, 255, 255, 255, 255, 130,
        70, 207, 104, 255, 255, 255, 255, 204, 174, 140, 128, 255, 255, 255, 255, 205, 158, 111,
        112, 255, 255, 255, 255, 206, 142, 110, 128, 255, 255, 255, 255, 207, 126, 81, 112, 1, 3,
        2, 3, 2, 3, 0, 0, 26, 64, 0, 0, 0, 0, 21, 24, 0, 4, 0, 0, 42, 48, 1, 4, 0, 0, 28, 32, 0, 4,
        76, 77, 84, 0, 83, 65, 83, 84, 0, 10, 83, 65, 83, 84, 45, 50, 10,
    ];
    pub(crate) const AfricaJuba: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        35, 0, 0, 0, 4, 0, 0, 0, 17, 255, 255, 255, 255, 182, 163, 218, 220, 0, 0, 0, 0, 0, 158,
        23, 224, 0, 0, 0, 0, 1, 122, 52, 80, 0, 0, 0, 0, 2, 125, 249, 224, 0, 0, 0, 0, 3, 91, 103,
        208, 0, 0, 0, 0, 4, 96, 126, 224, 0, 0, 0, 0, 5, 61, 236, 208, 0, 0, 0, 0, 6, 64, 96, 224,
        0, 0, 0, 0, 7, 31, 32, 80, 0, 0, 0, 0, 8, 32, 66, 224, 0, 0, 0, 0, 9, 0, 83, 208, 0, 0, 0,
        0, 10, 0, 36, 224, 0, 0, 0, 0, 10, 225, 135, 80, 0, 0, 0, 0, 11, 224, 6, 224, 0, 0, 0, 0,
        12, 196, 12, 80, 0, 0, 0, 0, 13, 191, 232, 224, 0, 0, 0, 0, 14, 165, 63, 208, 0, 0, 0, 0,
        15, 169, 5, 96, 0, 0, 0, 0, 16, 134, 115, 80, 0, 0, 0, 0, 17, 136, 231, 96, 0, 0, 0, 0, 18,
        103, 166, 208, 0, 0, 0, 0, 19, 104, 201, 96, 0, 0, 0, 0, 20, 74, 43, 208, 0, 0, 0, 0, 21,
        72, 171, 96, 0, 0, 0, 0, 22, 43, 95, 80, 0, 0, 0, 0, 23, 40, 141, 96, 0, 0, 0, 0, 24, 12,
        146, 208, 0, 0, 0, 0, 25, 8, 111, 96, 0, 0, 0, 0, 25, 237, 198, 80, 0, 0, 0, 0, 26, 241,
        139, 224, 0, 0, 0, 0, 27, 208, 75, 80, 0, 0, 0, 0, 28, 209, 109, 224, 0, 0, 0, 0, 29, 177,
        126, 208, 0, 0, 0, 0, 56, 128, 69, 32, 0, 0, 0, 0, 96, 23, 26, 80, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 2, 0, 0, 29,
        164, 0, 0, 0, 0, 42, 48, 1, 4, 0, 0, 28, 32, 0, 9, 0, 0, 42, 48, 0, 13, 76, 77, 84, 0, 67,
        65, 83, 84, 0, 67, 65, 84, 0, 69, 65, 84, 0, 10, 67, 65, 84, 45, 50, 10,
    ];
    pub(crate) const AfricaKhartoum: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        35, 0, 0, 0, 4, 0, 0, 0, 17, 255, 255, 255, 255, 182, 163, 218, 0, 0, 0, 0, 0, 0, 158, 23,
        224, 0, 0, 0, 0, 1, 122, 52, 80, 0, 0, 0, 0, 2, 125, 249, 224, 0, 0, 0, 0, 3, 91, 103, 208,
        0, 0, 0, 0, 4, 96, 126, 224, 0, 0, 0, 0, 5, 61, 236, 208, 0, 0, 0, 0, 6, 64, 96, 224, 0, 0,
        0, 0, 7, 31, 32, 80, 0, 0, 0, 0, 8, 32, 66, 224, 0, 0, 0, 0, 9, 0, 83, 208, 0, 0, 0, 0, 10,
        0, 36, 224, 0, 0, 0, 0, 10, 225, 135, 80, 0, 0, 0, 0, 11, 224, 6, 224, 0, 0, 0, 0, 12, 196,
        12, 80, 0, 0, 0, 0, 13, 191, 232, 224, 0, 0, 0, 0, 14, 165, 63, 208, 0, 0, 0, 0, 15, 169,
        5, 96, 0, 0, 0, 0, 16, 134, 115, 80, 0, 0, 0, 0, 17, 136, 231, 96, 0, 0, 0, 0, 18, 103,
        166, 208, 0, 0, 0, 0, 19, 104, 201, 96, 0, 0, 0, 0, 20, 74, 43, 208, 0, 0, 0, 0, 21, 72,
        171, 96, 0, 0, 0, 0, 22, 43, 95, 80, 0, 0, 0, 0, 23, 40, 141, 96, 0, 0, 0, 0, 24, 12, 146,
        208, 0, 0, 0, 0, 25, 8, 111, 96, 0, 0, 0, 0, 25, 237, 198, 80, 0, 0, 0, 0, 26, 241, 139,
        224, 0, 0, 0, 0, 27, 208, 75, 80, 0, 0, 0, 0, 28, 209, 109, 224, 0, 0, 0, 0, 29, 177, 126,
        208, 0, 0, 0, 0, 56, 128, 69, 32, 0, 0, 0, 0, 89, 248, 228, 80, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 2, 0, 0, 30,
        128, 0, 0, 0, 0, 42, 48, 1, 4, 0, 0, 28, 32, 0, 9, 0, 0, 42, 48, 0, 13, 76, 77, 84, 0, 67,
        65, 83, 84, 0, 67, 65, 84, 0, 69, 65, 84, 0, 10, 67, 65, 84, 45, 50, 10,
    ];
    pub(crate) const AfricaMonrovia: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        3, 0, 0, 0, 4, 0, 0, 0, 12, 255, 255, 255, 255, 90, 122, 166, 156, 255, 255, 255, 255, 160,
        95, 108, 156, 0, 0, 0, 0, 3, 202, 90, 110, 1, 2, 3, 255, 255, 245, 228, 0, 0, 255, 255,
        245, 228, 0, 4, 255, 255, 245, 146, 0, 4, 0, 0, 0, 0, 0, 8, 76, 77, 84, 0, 77, 77, 84, 0,
        71, 77, 84, 0, 10, 71, 77, 84, 48, 10,
    ];
    pub(crate) const AfricaNdjamena: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        3, 0, 0, 0, 3, 0, 0, 0, 13, 255, 255, 255, 255, 146, 230, 128, 100, 0, 0, 0, 0, 18, 102,
        113, 112, 0, 0, 0, 0, 19, 38, 222, 96, 1, 2, 1, 0, 0, 14, 28, 0, 0, 0, 0, 14, 16, 0, 4, 0,
        0, 28, 32, 1, 8, 76, 77, 84, 0, 87, 65, 84, 0, 87, 65, 83, 84, 0, 10, 87, 65, 84, 45, 49,
        10,
    ];
    pub(crate) const AfricaSaoTome: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        4, 0, 0, 0, 4, 0, 0, 0, 12, 255, 255, 255, 255, 94, 60, 253, 48, 255, 255, 255, 255, 146,
        230, 142, 128, 0, 0, 0, 0, 90, 73, 136, 16, 0, 0, 0, 0, 92, 42, 187, 144, 1, 2, 3, 2, 0, 0,
        6, 80, 0, 0, 255, 255, 247, 99, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 16, 0, 8, 76, 77, 84, 0,
        71, 77, 84, 0, 87, 65, 84, 0, 10, 71, 77, 84, 48, 10,
    ];
    pub(crate) const AfricaTripoli: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        32, 0, 0, 0, 4, 0, 0, 0, 17, 255, 255, 255, 255, 161, 242, 193, 36, 255, 255, 255, 255,
        221, 187, 177, 16, 255, 255, 255, 255, 222, 35, 173, 96, 255, 255, 255, 255, 225, 120, 210,
        16, 255, 255, 255, 255, 225, 231, 101, 224, 255, 255, 255, 255, 229, 47, 63, 112, 255, 255,
        255, 255, 229, 169, 204, 224, 255, 255, 255, 255, 235, 78, 198, 240, 0, 0, 0, 0, 22, 146,
        66, 96, 0, 0, 0, 0, 23, 8, 247, 112, 0, 0, 0, 0, 23, 250, 43, 224, 0, 0, 0, 0, 24, 234, 42,
        240, 0, 0, 0, 0, 25, 219, 95, 96, 0, 0, 0, 0, 26, 204, 175, 240, 0, 0, 0, 0, 27, 189, 228,
        96, 0, 0, 0, 0, 28, 180, 122, 240, 0, 0, 0, 0, 29, 159, 23, 224, 0, 0, 0, 0, 30, 147, 11,
        112, 0, 0, 0, 0, 31, 130, 238, 96, 0, 0, 0, 0, 32, 112, 74, 112, 0, 0, 0, 0, 33, 97, 126,
        224, 0, 0, 0, 0, 34, 82, 207, 112, 0, 0, 0, 0, 35, 68, 3, 224, 0, 0, 0, 0, 36, 52, 2, 240,
        0, 0, 0, 0, 37, 37, 55, 96, 0, 0, 0, 0, 38, 64, 183, 240, 0, 0, 0, 0, 50, 78, 241, 96, 0,
        0, 0, 0, 51, 68, 54, 112, 0, 0, 0, 0, 52, 53, 106, 224, 0, 0, 0, 0, 80, 157, 153, 0, 0, 0,
        0, 0, 81, 84, 217, 128, 0, 0, 0, 0, 82, 105, 180, 128, 2, 1, 2, 1, 2, 1, 2, 3, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 2, 1, 3, 2, 1, 3, 0, 0, 12, 92, 0, 0, 0, 0, 28,
        32, 1, 4, 0, 0, 14, 16, 0, 9, 0, 0, 28, 32, 0, 13, 76, 77, 84, 0, 67, 69, 83, 84, 0, 67,
        69, 84, 0, 69, 69, 84, 0, 10, 69, 69, 84, 45, 50, 10,
    ];
    pub(crate) const AfricaTunis: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        34, 0, 0, 0, 4, 0, 0, 0, 17, 255, 255, 255, 255, 89, 70, 19, 244, 255, 255, 255, 255, 145,
        96, 80, 79, 255, 255, 255, 255, 198, 58, 136, 224, 255, 255, 255, 255, 199, 88, 158, 96,
        255, 255, 255, 255, 199, 219, 34, 224, 255, 255, 255, 255, 202, 226, 84, 224, 255, 255,
        255, 255, 203, 173, 105, 240, 255, 255, 255, 255, 204, 231, 75, 16, 255, 255, 255, 255,
        205, 169, 23, 144, 255, 255, 255, 255, 205, 194, 22, 0, 255, 255, 255, 255, 205, 204, 176,
        16, 255, 255, 255, 255, 206, 162, 53, 0, 255, 255, 255, 255, 207, 146, 52, 16, 255, 255,
        255, 255, 208, 137, 227, 224, 255, 255, 255, 255, 209, 114, 22, 16, 255, 255, 255, 255,
        210, 78, 22, 96, 0, 0, 0, 0, 13, 199, 223, 240, 0, 0, 0, 0, 14, 137, 172, 112, 0, 0, 0, 0,
        15, 170, 100, 240, 0, 0, 0, 0, 16, 116, 26, 112, 0, 0, 0, 0, 34, 163, 58, 240, 0, 0, 0, 0,
        35, 60, 40, 240, 0, 0, 0, 0, 36, 44, 25, 240, 0, 0, 0, 0, 37, 28, 10, 240, 0, 0, 0, 0, 38,
        60, 195, 112, 0, 0, 0, 0, 39, 5, 39, 112, 0, 0, 0, 0, 66, 116, 13, 240, 0, 0, 0, 0, 67, 60,
        128, 0, 0, 0, 0, 0, 68, 37, 231, 144, 0, 0, 0, 0, 69, 67, 253, 16, 0, 0, 0, 0, 70, 5, 201,
        144, 0, 0, 0, 0, 71, 35, 223, 16, 0, 0, 0, 0, 71, 238, 230, 16, 0, 0, 0, 0, 73, 3, 193, 16,
        1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 0, 0, 9, 140, 0, 0, 0, 0, 2, 49, 0, 4, 0, 0, 28, 32, 1, 8, 0, 0, 14, 16, 0, 13,
        76, 77, 84, 0, 80, 77, 84, 0, 67, 69, 83, 84, 0, 67, 69, 84, 0, 10, 67, 69, 84, 45, 49, 10,
    ];
    pub(crate) const AfricaWindhoek: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        53, 0, 0, 0, 6, 0, 0, 0, 23, 255, 255, 255, 255, 109, 123, 75, 120, 255, 255, 255, 255,
        130, 70, 207, 104, 255, 255, 255, 255, 204, 174, 140, 128, 255, 255, 255, 255, 205, 158,
        111, 112, 0, 0, 0, 0, 38, 6, 167, 224, 0, 0, 0, 0, 45, 140, 199, 96, 0, 0, 0, 0, 46, 105,
        28, 16, 0, 0, 0, 0, 47, 125, 233, 0, 0, 0, 0, 0, 48, 72, 254, 16, 0, 0, 0, 0, 49, 103, 5,
        128, 0, 0, 0, 0, 50, 40, 224, 16, 0, 0, 0, 0, 51, 70, 231, 128, 0, 0, 0, 0, 52, 17, 252,
        144, 0, 0, 0, 0, 53, 38, 201, 128, 0, 0, 0, 0, 53, 241, 222, 144, 0, 0, 0, 0, 55, 6, 171,
        128, 0, 0, 0, 0, 55, 209, 192, 144, 0, 0, 0, 0, 56, 230, 141, 128, 0, 0, 0, 0, 57, 177,
        162, 144, 0, 0, 0, 0, 58, 198, 111, 128, 0, 0, 0, 0, 59, 145, 132, 144, 0, 0, 0, 0, 60,
        175, 140, 0, 0, 0, 0, 0, 61, 113, 102, 144, 0, 0, 0, 0, 62, 143, 110, 0, 0, 0, 0, 0, 63,
        90, 131, 16, 0, 0, 0, 0, 64, 111, 80, 0, 0, 0, 0, 0, 65, 58, 101, 16, 0, 0, 0, 0, 66, 79,
        50, 0, 0, 0, 0, 0, 67, 26, 71, 16, 0, 0, 0, 0, 68, 47, 20, 0, 0, 0, 0, 0, 68, 250, 41, 16,
        0, 0, 0, 0, 70, 14, 246, 0, 0, 0, 0, 0, 70, 218, 11, 16, 0, 0, 0, 0, 71, 248, 18, 128, 0,
        0, 0, 0, 72, 195, 39, 144, 0, 0, 0, 0, 73, 215, 244, 128, 0, 0, 0, 0, 74, 163, 9, 144, 0,
        0, 0, 0, 75, 183, 214, 128, 0, 0, 0, 0, 76, 130, 235, 144, 0, 0, 0, 0, 77, 151, 184, 128,
        0, 0, 0, 0, 78, 98, 205, 144, 0, 0, 0, 0, 79, 119, 154, 128, 0, 0, 0, 0, 80, 66, 175, 144,
        0, 0, 0, 0, 81, 96, 183, 0, 0, 0, 0, 0, 82, 34, 145, 144, 0, 0, 0, 0, 83, 64, 153, 0, 0, 0,
        0, 0, 84, 11, 174, 16, 0, 0, 0, 0, 85, 32, 123, 0, 0, 0, 0, 0, 85, 235, 144, 16, 0, 0, 0,
        0, 87, 0, 93, 0, 0, 0, 0, 0, 87, 203, 114, 16, 0, 0, 0, 0, 88, 224, 63, 0, 0, 0, 0, 0, 89,
        171, 84, 16, 1, 2, 3, 2, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4,
        5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 0, 0, 16,
        8, 0, 0, 0, 0, 21, 24, 0, 4, 0, 0, 28, 32, 0, 10, 0, 0, 42, 48, 1, 10, 0, 0, 14, 16, 1, 15,
        0, 0, 28, 32, 0, 19, 76, 77, 84, 0, 43, 48, 49, 51, 48, 0, 83, 65, 83, 84, 0, 87, 65, 84,
        0, 67, 65, 84, 0, 10, 67, 65, 84, 45, 50, 10,
    ];
    pub(crate) const AmericaAdak: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        84, 0, 0, 0, 10, 0, 0, 0, 33, 255, 255, 255, 255, 63, 194, 253, 209, 255, 255, 255, 255,
        125, 135, 90, 94, 255, 255, 255, 255, 203, 137, 68, 208, 255, 255, 255, 255, 210, 35, 244,
        112, 255, 255, 255, 255, 210, 97, 80, 64, 255, 255, 255, 255, 250, 210, 85, 176, 255, 255,
        255, 255, 254, 184, 113, 80, 255, 255, 255, 255, 255, 168, 84, 64, 0, 0, 0, 0, 0, 152, 83,
        80, 0, 0, 0, 0, 1, 136, 54, 64, 0, 0, 0, 0, 2, 120, 53, 80, 0, 0, 0, 0, 3, 113, 82, 192, 0,
        0, 0, 0, 4, 97, 81, 208, 0, 0, 0, 0, 5, 81, 52, 192, 0, 0, 0, 0, 6, 65, 51, 208, 0, 0, 0,
        0, 7, 49, 22, 192, 0, 0, 0, 0, 7, 141, 109, 208, 0, 0, 0, 0, 9, 16, 248, 192, 0, 0, 0, 0,
        9, 173, 233, 80, 0, 0, 0, 0, 10, 240, 218, 192, 0, 0, 0, 0, 11, 224, 217, 208, 0, 0, 0, 0,
        12, 217, 247, 64, 0, 0, 0, 0, 13, 192, 187, 208, 0, 0, 0, 0, 14, 185, 217, 64, 0, 0, 0, 0,
        15, 169, 216, 80, 0, 0, 0, 0, 16, 153, 187, 64, 0, 0, 0, 0, 17, 137, 186, 80, 0, 0, 0, 0,
        18, 121, 157, 64, 0, 0, 0, 0, 19, 105, 156, 80, 0, 0, 0, 0, 20, 89, 127, 64, 0, 0, 0, 0,
        21, 73, 126, 80, 0, 0, 0, 0, 22, 57, 97, 64, 0, 0, 0, 0, 23, 41, 96, 80, 0, 0, 0, 0, 24,
        34, 125, 192, 0, 0, 0, 0, 25, 9, 66, 80, 0, 0, 0, 0, 26, 2, 95, 192, 0, 0, 0, 0, 26, 43,
        34, 32, 0, 0, 0, 0, 26, 242, 80, 192, 0, 0, 0, 0, 27, 226, 51, 176, 0, 0, 0, 0, 28, 210,
        50, 192, 0, 0, 0, 0, 29, 194, 21, 176, 0, 0, 0, 0, 30, 178, 20, 192, 0, 0, 0, 0, 31, 161,
        247, 176, 0, 0, 0, 0, 32, 118, 71, 64, 0, 0, 0, 0, 33, 129, 217, 176, 0, 0, 0, 0, 34, 86,
        41, 64, 0, 0, 0, 0, 35, 106, 246, 48, 0, 0, 0, 0, 36, 54, 11, 64, 0, 0, 0, 0, 37, 74, 216,
        48, 0, 0, 0, 0, 38, 21, 237, 64, 0, 0, 0, 0, 39, 42, 186, 48, 0, 0, 0, 0, 39, 255, 9, 192,
        0, 0, 0, 0, 41, 10, 156, 48, 0, 0, 0, 0, 41, 222, 235, 192, 0, 0, 0, 0, 42, 234, 126, 48,
        0, 0, 0, 0, 43, 190, 205, 192, 0, 0, 0, 0, 44, 211, 154, 176, 0, 0, 0, 0, 45, 158, 175,
        192, 0, 0, 0, 0, 46, 179, 124, 176, 0, 0, 0, 0, 47, 126, 145, 192, 0, 0, 0, 0, 48, 147, 94,
        176, 0, 0, 0, 0, 49, 103, 174, 64, 0, 0, 0, 0, 50, 115, 64, 176, 0, 0, 0, 0, 51, 71, 144,
        64, 0, 0, 0, 0, 52, 83, 34, 176, 0, 0, 0, 0, 53, 39, 114, 64, 0, 0, 0, 0, 54, 51, 4, 176,
        0, 0, 0, 0, 55, 7, 84, 64, 0, 0, 0, 0, 56, 28, 33, 48, 0, 0, 0, 0, 56, 231, 54, 64, 0, 0,
        0, 0, 57, 252, 3, 48, 0, 0, 0, 0, 58, 199, 24, 64, 0, 0, 0, 0, 59, 219, 229, 48, 0, 0, 0,
        0, 60, 176, 52, 192, 0, 0, 0, 0, 61, 187, 199, 48, 0, 0, 0, 0, 62, 144, 22, 192, 0, 0, 0,
        0, 63, 155, 169, 48, 0, 0, 0, 0, 64, 111, 248, 192, 0, 0, 0, 0, 65, 132, 197, 176, 0, 0, 0,
        0, 66, 79, 218, 192, 0, 0, 0, 0, 67, 100, 167, 176, 0, 0, 0, 0, 68, 47, 188, 192, 0, 0, 0,
        0, 69, 68, 137, 176, 0, 0, 0, 0, 69, 243, 239, 64, 1, 2, 3, 4, 2, 5, 6, 5, 6, 5, 6, 5, 6,
        5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 7, 9, 8, 9, 8, 9, 8, 9,
        8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9,
        8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 0, 0, 171, 226, 0, 0, 255, 255, 90, 98, 0, 0, 255, 255,
        101, 80, 0, 4, 255, 255, 115, 96, 1, 8, 255, 255, 115, 96, 1, 12, 255, 255, 101, 80, 0, 16,
        255, 255, 115, 96, 1, 20, 255, 255, 115, 96, 0, 24, 255, 255, 129, 112, 1, 29, 255, 255,
        115, 96, 0, 25, 76, 77, 84, 0, 78, 83, 84, 0, 78, 87, 84, 0, 78, 80, 84, 0, 66, 83, 84, 0,
        66, 68, 84, 0, 65, 72, 83, 84, 0, 72, 68, 84, 0, 10, 72, 83, 84, 49, 48, 72, 68, 84, 44,
        77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaAnchorage: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        84, 0, 0, 0, 10, 0, 0, 0, 40, 255, 255, 255, 255, 63, 194, 253, 209, 255, 255, 255, 255,
        125, 135, 65, 72, 255, 255, 255, 255, 203, 137, 54, 192, 255, 255, 255, 255, 210, 35, 244,
        112, 255, 255, 255, 255, 210, 97, 66, 48, 255, 255, 255, 255, 250, 210, 71, 160, 255, 255,
        255, 255, 254, 184, 99, 64, 255, 255, 255, 255, 255, 168, 70, 48, 0, 0, 0, 0, 0, 152, 69,
        64, 0, 0, 0, 0, 1, 136, 40, 48, 0, 0, 0, 0, 2, 120, 39, 64, 0, 0, 0, 0, 3, 113, 68, 176, 0,
        0, 0, 0, 4, 97, 67, 192, 0, 0, 0, 0, 5, 81, 38, 176, 0, 0, 0, 0, 6, 65, 37, 192, 0, 0, 0,
        0, 7, 49, 8, 176, 0, 0, 0, 0, 7, 141, 95, 192, 0, 0, 0, 0, 9, 16, 234, 176, 0, 0, 0, 0, 9,
        173, 219, 64, 0, 0, 0, 0, 10, 240, 204, 176, 0, 0, 0, 0, 11, 224, 203, 192, 0, 0, 0, 0, 12,
        217, 233, 48, 0, 0, 0, 0, 13, 192, 173, 192, 0, 0, 0, 0, 14, 185, 203, 48, 0, 0, 0, 0, 15,
        169, 202, 64, 0, 0, 0, 0, 16, 153, 173, 48, 0, 0, 0, 0, 17, 137, 172, 64, 0, 0, 0, 0, 18,
        121, 143, 48, 0, 0, 0, 0, 19, 105, 142, 64, 0, 0, 0, 0, 20, 89, 113, 48, 0, 0, 0, 0, 21,
        73, 112, 64, 0, 0, 0, 0, 22, 57, 83, 48, 0, 0, 0, 0, 23, 41, 82, 64, 0, 0, 0, 0, 24, 34,
        111, 176, 0, 0, 0, 0, 25, 9, 52, 64, 0, 0, 0, 0, 26, 2, 81, 176, 0, 0, 0, 0, 26, 43, 20,
        16, 0, 0, 0, 0, 26, 242, 66, 176, 0, 0, 0, 0, 27, 226, 37, 160, 0, 0, 0, 0, 28, 210, 36,
        176, 0, 0, 0, 0, 29, 194, 7, 160, 0, 0, 0, 0, 30, 178, 6, 176, 0, 0, 0, 0, 31, 161, 233,
        160, 0, 0, 0, 0, 32, 118, 57, 48, 0, 0, 0, 0, 33, 129, 203, 160, 0, 0, 0, 0, 34, 86, 27,
        48, 0, 0, 0, 0, 35, 106, 232, 32, 0, 0, 0, 0, 36, 53, 253, 48, 0, 0, 0, 0, 37, 74, 202, 32,
        0, 0, 0, 0, 38, 21, 223, 48, 0, 0, 0, 0, 39, 42, 172, 32, 0, 0, 0, 0, 39, 254, 251, 176, 0,
        0, 0, 0, 41, 10, 142, 32, 0, 0, 0, 0, 41, 222, 221, 176, 0, 0, 0, 0, 42, 234, 112, 32, 0,
        0, 0, 0, 43, 190, 191, 176, 0, 0, 0, 0, 44, 211, 140, 160, 0, 0, 0, 0, 45, 158, 161, 176,
        0, 0, 0, 0, 46, 179, 110, 160, 0, 0, 0, 0, 47, 126, 131, 176, 0, 0, 0, 0, 48, 147, 80, 160,
        0, 0, 0, 0, 49, 103, 160, 48, 0, 0, 0, 0, 50, 115, 50, 160, 0, 0, 0, 0, 51, 71, 130, 48, 0,
        0, 0, 0, 52, 83, 20, 160, 0, 0, 0, 0, 53, 39, 100, 48, 0, 0, 0, 0, 54, 50, 246, 160, 0, 0,
        0, 0, 55, 7, 70, 48, 0, 0, 0, 0, 56, 28, 19, 32, 0, 0, 0, 0, 56, 231, 40, 48, 0, 0, 0, 0,
        57, 251, 245, 32, 0, 0, 0, 0, 58, 199, 10, 48, 0, 0, 0, 0, 59, 219, 215, 32, 0, 0, 0, 0,
        60, 176, 38, 176, 0, 0, 0, 0, 61, 187, 185, 32, 0, 0, 0, 0, 62, 144, 8, 176, 0, 0, 0, 0,
        63, 155, 155, 32, 0, 0, 0, 0, 64, 111, 234, 176, 0, 0, 0, 0, 65, 132, 183, 160, 0, 0, 0, 0,
        66, 79, 204, 176, 0, 0, 0, 0, 67, 100, 153, 160, 0, 0, 0, 0, 68, 47, 174, 176, 0, 0, 0, 0,
        69, 68, 123, 160, 0, 0, 0, 0, 69, 243, 225, 48, 1, 2, 3, 4, 2, 5, 6, 5, 6, 5, 6, 5, 6, 5,
        6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 7, 9, 8, 9, 8, 9, 8, 9, 8,
        9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8,
        9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 0, 0, 196, 248, 0, 0, 255, 255, 115, 120, 0, 0, 255, 255,
        115, 96, 0, 4, 255, 255, 129, 112, 1, 8, 255, 255, 129, 112, 1, 12, 255, 255, 115, 96, 0,
        16, 255, 255, 129, 112, 1, 21, 255, 255, 129, 112, 0, 26, 255, 255, 143, 128, 1, 30, 255,
        255, 129, 112, 0, 35, 76, 77, 84, 0, 65, 83, 84, 0, 65, 87, 84, 0, 65, 80, 84, 0, 65, 72,
        83, 84, 0, 65, 72, 68, 84, 0, 89, 83, 84, 0, 65, 75, 68, 84, 0, 65, 75, 83, 84, 0, 10, 65,
        75, 83, 84, 57, 65, 75, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48,
        10,
    ];
    pub(crate) const AmericaAnguilla: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        4, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 122, 230, 149, 185, 255, 255, 255, 255,
        203, 246, 50, 192, 255, 255, 255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 96, 237,
        208, 1, 3, 2, 1, 255, 255, 194, 7, 0, 0, 255, 255, 199, 192, 0, 4, 255, 255, 213, 208, 1,
        8, 255, 255, 213, 208, 1, 12, 76, 77, 84, 0, 65, 83, 84, 0, 65, 80, 84, 0, 65, 87, 84, 0,
        10, 65, 83, 84, 52, 10,
    ];
    pub(crate) const AmericaAraguaina: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        51, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 150, 170, 116, 48, 255, 255, 255, 255,
        184, 15, 73, 224, 255, 255, 255, 255, 184, 253, 64, 160, 255, 255, 255, 255, 185, 241, 52,
        48, 255, 255, 255, 255, 186, 222, 116, 32, 255, 255, 255, 255, 218, 56, 174, 48, 255, 255,
        255, 255, 218, 235, 250, 48, 255, 255, 255, 255, 220, 25, 225, 176, 255, 255, 255, 255,
        220, 185, 89, 32, 255, 255, 255, 255, 221, 251, 21, 48, 255, 255, 255, 255, 222, 155, 222,
        32, 255, 255, 255, 255, 223, 221, 154, 48, 255, 255, 255, 255, 224, 84, 51, 32, 255, 255,
        255, 255, 244, 151, 255, 176, 255, 255, 255, 255, 245, 5, 94, 32, 255, 255, 255, 255, 246,
        192, 100, 48, 255, 255, 255, 255, 247, 14, 30, 160, 255, 255, 255, 255, 248, 81, 44, 48,
        255, 255, 255, 255, 248, 199, 197, 32, 255, 255, 255, 255, 250, 10, 210, 176, 255, 255,
        255, 255, 250, 168, 248, 160, 255, 255, 255, 255, 251, 236, 6, 48, 255, 255, 255, 255, 252,
        139, 125, 160, 0, 0, 0, 0, 29, 201, 142, 48, 0, 0, 0, 0, 30, 120, 215, 160, 0, 0, 0, 0, 31,
        160, 53, 176, 0, 0, 0, 0, 32, 51, 207, 160, 0, 0, 0, 0, 33, 129, 105, 48, 0, 0, 0, 0, 34,
        11, 200, 160, 0, 0, 0, 0, 35, 88, 16, 176, 0, 0, 0, 0, 35, 226, 112, 32, 0, 0, 0, 0, 37,
        55, 242, 176, 0, 0, 0, 0, 37, 212, 199, 32, 0, 0, 0, 0, 48, 128, 121, 48, 0, 0, 0, 0, 49,
        29, 77, 160, 0, 0, 0, 0, 50, 87, 32, 176, 0, 0, 0, 0, 51, 6, 106, 32, 0, 0, 0, 0, 52, 56,
        84, 48, 0, 0, 0, 0, 52, 248, 193, 32, 0, 0, 0, 0, 54, 32, 31, 48, 0, 0, 0, 0, 54, 207, 104,
        160, 0, 0, 0, 0, 55, 246, 198, 176, 0, 0, 0, 0, 56, 184, 133, 32, 0, 0, 0, 0, 57, 223, 227,
        48, 0, 0, 0, 0, 58, 143, 44, 160, 0, 0, 0, 0, 59, 200, 255, 176, 0, 0, 0, 0, 60, 111, 14,
        160, 0, 0, 0, 0, 61, 196, 145, 48, 0, 0, 0, 0, 62, 78, 240, 160, 0, 0, 0, 0, 80, 131, 101,
        48, 0, 0, 0, 0, 81, 32, 57, 160, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 255, 255, 210, 208, 0, 0, 255, 255, 227, 224, 1, 4, 255, 255, 213, 208, 0, 8, 76, 77,
        84, 0, 45, 48, 50, 0, 45, 48, 51, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AmericaAsuncion: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        79, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 105, 135, 17, 144, 255, 255, 255, 255,
        184, 23, 245, 144, 0, 0, 0, 0, 5, 43, 218, 64, 0, 0, 0, 0, 7, 252, 240, 176, 0, 0, 0, 0,
        10, 207, 116, 192, 0, 0, 0, 0, 11, 151, 202, 176, 0, 0, 0, 0, 12, 177, 249, 192, 0, 0, 0,
        0, 13, 120, 254, 48, 0, 0, 0, 0, 14, 147, 45, 64, 0, 0, 0, 0, 15, 90, 49, 176, 0, 0, 0, 0,
        16, 116, 96, 192, 0, 0, 0, 0, 17, 100, 67, 176, 0, 0, 0, 0, 18, 85, 148, 64, 0, 0, 0, 0,
        19, 70, 200, 176, 0, 0, 0, 0, 20, 56, 25, 64, 0, 0, 0, 0, 21, 39, 252, 48, 0, 0, 0, 0, 22,
        25, 76, 192, 0, 0, 0, 0, 23, 9, 47, 176, 0, 0, 0, 0, 23, 250, 128, 64, 0, 0, 0, 0, 24, 234,
        99, 48, 0, 0, 0, 0, 25, 219, 179, 192, 0, 0, 0, 0, 26, 204, 232, 48, 0, 0, 0, 0, 27, 190,
        56, 192, 0, 0, 0, 0, 28, 174, 27, 176, 0, 0, 0, 0, 29, 159, 108, 64, 0, 0, 0, 0, 30, 143,
        79, 48, 0, 0, 0, 0, 31, 128, 159, 192, 0, 0, 0, 0, 32, 112, 130, 176, 0, 0, 0, 0, 33, 97,
        211, 64, 0, 0, 0, 0, 34, 83, 7, 176, 0, 0, 0, 0, 35, 68, 88, 64, 0, 0, 0, 0, 36, 52, 59,
        48, 0, 0, 0, 0, 37, 65, 59, 64, 0, 0, 0, 0, 38, 21, 110, 176, 0, 0, 0, 0, 39, 6, 191, 64,
        0, 0, 0, 0, 39, 246, 162, 48, 0, 0, 0, 0, 40, 238, 138, 64, 0, 0, 0, 0, 41, 176, 72, 176,
        0, 0, 0, 0, 42, 207, 189, 192, 0, 0, 0, 0, 43, 185, 9, 48, 0, 0, 0, 0, 44, 171, 171, 64, 0,
        0, 0, 0, 45, 112, 12, 176, 0, 0, 0, 0, 46, 140, 222, 192, 0, 0, 0, 0, 47, 79, 238, 176, 0,
        0, 0, 0, 48, 110, 18, 64, 0, 0, 0, 0, 49, 54, 104, 48, 0, 0, 0, 0, 50, 87, 46, 192, 0, 0,
        0, 0, 51, 15, 178, 176, 0, 0, 0, 0, 52, 55, 16, 192, 0, 0, 0, 0, 52, 248, 207, 48, 0, 0, 0,
        0, 54, 22, 242, 192, 0, 0, 0, 0, 54, 225, 235, 176, 0, 0, 0, 0, 55, 246, 212, 192, 0, 0, 0,
        0, 56, 193, 205, 176, 0, 0, 0, 0, 57, 214, 182, 192, 0, 0, 0, 0, 58, 161, 175, 176, 0, 0,
        0, 0, 59, 191, 211, 64, 0, 0, 0, 0, 60, 175, 182, 48, 0, 0, 0, 0, 61, 113, 144, 192, 0, 0,
        0, 0, 62, 143, 152, 48, 0, 0, 0, 0, 63, 90, 173, 64, 0, 0, 0, 0, 64, 111, 122, 48, 0, 0, 0,
        0, 65, 113, 238, 64, 0, 0, 0, 0, 66, 51, 172, 176, 0, 0, 0, 0, 67, 81, 208, 64, 0, 0, 0, 0,
        68, 19, 142, 176, 0, 0, 0, 0, 69, 49, 178, 64, 0, 0, 0, 0, 69, 243, 112, 176, 0, 0, 0, 0,
        71, 26, 206, 192, 0, 0, 0, 0, 71, 211, 82, 176, 0, 0, 0, 0, 72, 250, 176, 192, 0, 0, 0, 0,
        73, 179, 52, 176, 0, 0, 0, 0, 74, 218, 146, 192, 0, 0, 0, 0, 75, 193, 59, 48, 0, 0, 0, 0,
        76, 167, 255, 192, 0, 0, 0, 0, 77, 161, 29, 48, 0, 0, 0, 0, 78, 135, 225, 192, 0, 0, 0, 0,
        79, 128, 255, 48, 0, 0, 0, 0, 80, 112, 254, 64, 1, 2, 3, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2,
        4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2,
        4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2,
        4, 2, 4, 2, 4, 255, 255, 201, 240, 0, 0, 255, 255, 201, 240, 0, 4, 255, 255, 199, 192, 0,
        8, 255, 255, 213, 208, 0, 12, 255, 255, 213, 208, 1, 12, 76, 77, 84, 0, 65, 77, 84, 0, 45,
        48, 52, 0, 45, 48, 51, 0, 10, 60, 45, 48, 52, 62, 52, 60, 45, 48, 51, 62, 44, 77, 49, 48,
        46, 49, 46, 48, 47, 48, 44, 77, 51, 46, 52, 46, 48, 47, 48, 10,
    ];
    pub(crate) const AmericaAtikokan: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        2, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 105, 135, 38, 16, 255, 255, 255, 255, 139,
        244, 97, 232, 1, 2, 255, 255, 181, 112, 0, 0, 255, 255, 181, 24, 0, 4, 255, 255, 185, 176,
        0, 8, 76, 77, 84, 0, 67, 77, 84, 0, 69, 83, 84, 0, 10, 69, 83, 84, 53, 10,
    ];
    pub(crate) const AmericaBahia: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        61, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 150, 170, 107, 28, 255, 255, 255, 255,
        184, 15, 73, 224, 255, 255, 255, 255, 184, 253, 64, 160, 255, 255, 255, 255, 185, 241, 52,
        48, 255, 255, 255, 255, 186, 222, 116, 32, 255, 255, 255, 255, 218, 56, 174, 48, 255, 255,
        255, 255, 218, 235, 250, 48, 255, 255, 255, 255, 220, 25, 225, 176, 255, 255, 255, 255,
        220, 185, 89, 32, 255, 255, 255, 255, 221, 251, 21, 48, 255, 255, 255, 255, 222, 155, 222,
        32, 255, 255, 255, 255, 223, 221, 154, 48, 255, 255, 255, 255, 224, 84, 51, 32, 255, 255,
        255, 255, 244, 151, 255, 176, 255, 255, 255, 255, 245, 5, 94, 32, 255, 255, 255, 255, 246,
        192, 100, 48, 255, 255, 255, 255, 247, 14, 30, 160, 255, 255, 255, 255, 248, 81, 44, 48,
        255, 255, 255, 255, 248, 199, 197, 32, 255, 255, 255, 255, 250, 10, 210, 176, 255, 255,
        255, 255, 250, 168, 248, 160, 255, 255, 255, 255, 251, 236, 6, 48, 255, 255, 255, 255, 252,
        139, 125, 160, 0, 0, 0, 0, 29, 201, 142, 48, 0, 0, 0, 0, 30, 120, 215, 160, 0, 0, 0, 0, 31,
        160, 53, 176, 0, 0, 0, 0, 32, 51, 207, 160, 0, 0, 0, 0, 33, 129, 105, 48, 0, 0, 0, 0, 34,
        11, 200, 160, 0, 0, 0, 0, 35, 88, 16, 176, 0, 0, 0, 0, 35, 226, 112, 32, 0, 0, 0, 0, 37,
        55, 242, 176, 0, 0, 0, 0, 37, 212, 199, 32, 0, 0, 0, 0, 39, 33, 15, 48, 0, 0, 0, 0, 39,
        189, 227, 160, 0, 0, 0, 0, 41, 0, 241, 48, 0, 0, 0, 0, 41, 148, 139, 32, 0, 0, 0, 0, 42,
        234, 13, 176, 0, 0, 0, 0, 43, 107, 50, 160, 0, 0, 0, 0, 44, 192, 181, 48, 0, 0, 0, 0, 45,
        102, 196, 32, 0, 0, 0, 0, 46, 160, 151, 48, 0, 0, 0, 0, 47, 70, 166, 32, 0, 0, 0, 0, 48,
        128, 121, 48, 0, 0, 0, 0, 49, 29, 77, 160, 0, 0, 0, 0, 50, 87, 32, 176, 0, 0, 0, 0, 51, 6,
        106, 32, 0, 0, 0, 0, 52, 56, 84, 48, 0, 0, 0, 0, 52, 248, 193, 32, 0, 0, 0, 0, 54, 32, 31,
        48, 0, 0, 0, 0, 54, 207, 104, 160, 0, 0, 0, 0, 55, 246, 198, 176, 0, 0, 0, 0, 56, 184, 133,
        32, 0, 0, 0, 0, 57, 223, 227, 48, 0, 0, 0, 0, 58, 143, 44, 160, 0, 0, 0, 0, 59, 200, 255,
        176, 0, 0, 0, 0, 60, 111, 14, 160, 0, 0, 0, 0, 61, 196, 145, 48, 0, 0, 0, 0, 62, 78, 240,
        160, 0, 0, 0, 0, 78, 154, 72, 176, 0, 0, 0, 0, 79, 73, 146, 32, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 255, 255, 219, 228, 0, 0,
        255, 255, 227, 224, 1, 4, 255, 255, 213, 208, 0, 8, 76, 77, 84, 0, 45, 48, 50, 0, 45, 48,
        51, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AmericaBahiaBanderas: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        39, 0, 0, 0, 6, 0, 0, 0, 24, 255, 255, 255, 255, 165, 182, 232, 112, 255, 255, 255, 255,
        175, 242, 110, 224, 255, 255, 255, 255, 182, 102, 86, 96, 255, 255, 255, 255, 183, 67, 210,
        96, 255, 255, 255, 255, 184, 12, 54, 96, 255, 255, 255, 255, 184, 253, 134, 240, 255, 255,
        255, 255, 203, 234, 113, 96, 255, 255, 255, 255, 216, 145, 180, 240, 0, 0, 0, 0, 0, 0, 112,
        128, 0, 0, 0, 0, 49, 103, 132, 16, 0, 0, 0, 0, 50, 115, 22, 128, 0, 0, 0, 0, 51, 71, 102,
        16, 0, 0, 0, 0, 52, 82, 248, 128, 0, 0, 0, 0, 53, 39, 72, 16, 0, 0, 0, 0, 54, 50, 218, 128,
        0, 0, 0, 0, 55, 7, 42, 16, 0, 0, 0, 0, 56, 27, 247, 0, 0, 0, 0, 0, 56, 231, 12, 16, 0, 0,
        0, 0, 57, 251, 217, 0, 0, 0, 0, 0, 58, 245, 18, 144, 0, 0, 0, 0, 59, 182, 209, 0, 0, 0, 0,
        0, 60, 176, 10, 144, 0, 0, 0, 0, 61, 187, 157, 0, 0, 0, 0, 0, 62, 143, 236, 144, 0, 0, 0,
        0, 63, 155, 127, 0, 0, 0, 0, 0, 64, 111, 206, 144, 0, 0, 0, 0, 65, 132, 155, 128, 0, 0, 0,
        0, 66, 79, 176, 144, 0, 0, 0, 0, 67, 100, 125, 128, 0, 0, 0, 0, 68, 47, 146, 144, 0, 0, 0,
        0, 69, 68, 95, 128, 0, 0, 0, 0, 70, 15, 116, 144, 0, 0, 0, 0, 71, 36, 65, 128, 0, 0, 0, 0,
        71, 248, 145, 16, 0, 0, 0, 0, 73, 4, 35, 128, 0, 0, 0, 0, 73, 216, 115, 16, 0, 0, 0, 0, 74,
        228, 5, 128, 0, 0, 0, 0, 75, 184, 85, 16, 0, 0, 0, 0, 76, 205, 19, 240, 1, 2, 1, 2, 1, 2,
        1, 3, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4,
        1, 5, 2, 255, 255, 157, 84, 0, 0, 255, 255, 157, 144, 0, 4, 255, 255, 171, 160, 0, 8, 255,
        255, 143, 128, 0, 12, 255, 255, 171, 160, 1, 16, 255, 255, 185, 176, 1, 20, 76, 77, 84, 0,
        77, 83, 84, 0, 67, 83, 84, 0, 80, 83, 84, 0, 77, 68, 84, 0, 67, 68, 84, 0, 10, 67, 83, 84,
        54, 67, 68, 84, 44, 77, 52, 46, 49, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48, 10,
    ];
    pub(crate) const AmericaBarbados: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        15, 0, 0, 0, 4, 0, 0, 0, 18, 255, 255, 255, 255, 146, 64, 169, 101, 255, 255, 255, 255,
        203, 227, 203, 208, 255, 255, 255, 255, 204, 148, 130, 224, 255, 255, 255, 255, 205, 214,
        34, 208, 255, 255, 255, 255, 206, 124, 77, 224, 255, 255, 255, 255, 207, 155, 166, 208,
        255, 255, 255, 255, 208, 101, 106, 96, 0, 0, 0, 0, 14, 0, 242, 224, 0, 0, 0, 0, 14, 148,
        140, 208, 0, 0, 0, 0, 15, 151, 0, 224, 0, 0, 0, 0, 16, 116, 110, 208, 0, 0, 0, 0, 17, 118,
        226, 224, 0, 0, 0, 0, 18, 84, 80, 208, 0, 0, 0, 0, 19, 95, 255, 96, 0, 0, 0, 0, 20, 48, 62,
        80, 2, 1, 2, 1, 2, 3, 2, 1, 2, 1, 2, 1, 2, 1, 2, 255, 255, 200, 27, 0, 0, 255, 255, 213,
        208, 1, 4, 255, 255, 199, 192, 0, 8, 255, 255, 206, 200, 1, 12, 76, 77, 84, 0, 65, 68, 84,
        0, 65, 83, 84, 0, 45, 48, 51, 51, 48, 0, 10, 65, 83, 84, 52, 10,
    ];
    pub(crate) const AmericaBelem: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        29, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 150, 170, 116, 116, 255, 255, 255, 255,
        184, 15, 73, 224, 255, 255, 255, 255, 184, 253, 64, 160, 255, 255, 255, 255, 185, 241, 52,
        48, 255, 255, 255, 255, 186, 222, 116, 32, 255, 255, 255, 255, 218, 56, 174, 48, 255, 255,
        255, 255, 218, 235, 250, 48, 255, 255, 255, 255, 220, 25, 225, 176, 255, 255, 255, 255,
        220, 185, 89, 32, 255, 255, 255, 255, 221, 251, 21, 48, 255, 255, 255, 255, 222, 155, 222,
        32, 255, 255, 255, 255, 223, 221, 154, 48, 255, 255, 255, 255, 224, 84, 51, 32, 255, 255,
        255, 255, 244, 151, 255, 176, 255, 255, 255, 255, 245, 5, 94, 32, 255, 255, 255, 255, 246,
        192, 100, 48, 255, 255, 255, 255, 247, 14, 30, 160, 255, 255, 255, 255, 248, 81, 44, 48,
        255, 255, 255, 255, 248, 199, 197, 32, 255, 255, 255, 255, 250, 10, 210, 176, 255, 255,
        255, 255, 250, 168, 248, 160, 255, 255, 255, 255, 251, 236, 6, 48, 255, 255, 255, 255, 252,
        139, 125, 160, 0, 0, 0, 0, 29, 201, 142, 48, 0, 0, 0, 0, 30, 120, 215, 160, 0, 0, 0, 0, 31,
        160, 53, 176, 0, 0, 0, 0, 32, 51, 207, 160, 0, 0, 0, 0, 33, 129, 105, 48, 0, 0, 0, 0, 34,
        11, 200, 160, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 255, 255, 210, 140, 0, 0, 255, 255, 227, 224, 1, 4, 255, 255, 213, 208, 0, 8, 76,
        77, 84, 0, 45, 48, 50, 0, 45, 48, 51, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AmericaBelize: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        98, 0, 0, 0, 6, 0, 0, 0, 26, 255, 255, 255, 255, 147, 94, 217, 176, 255, 255, 255, 255,
        159, 159, 59, 224, 255, 255, 255, 255, 160, 69, 81, 216, 255, 255, 255, 255, 161, 127, 29,
        224, 255, 255, 255, 255, 162, 46, 110, 88, 255, 255, 255, 255, 163, 94, 255, 224, 255, 255,
        255, 255, 164, 14, 80, 88, 255, 255, 255, 255, 165, 62, 225, 224, 255, 255, 255, 255, 165,
        238, 50, 88, 255, 255, 255, 255, 167, 39, 254, 96, 255, 255, 255, 255, 167, 206, 20, 88,
        255, 255, 255, 255, 169, 7, 224, 96, 255, 255, 255, 255, 169, 173, 246, 88, 255, 255, 255,
        255, 170, 231, 194, 96, 255, 255, 255, 255, 171, 151, 18, 216, 255, 255, 255, 255, 172,
        199, 164, 96, 255, 255, 255, 255, 173, 118, 244, 216, 255, 255, 255, 255, 174, 167, 134,
        96, 255, 255, 255, 255, 175, 86, 214, 216, 255, 255, 255, 255, 176, 135, 104, 96, 255, 255,
        255, 255, 177, 54, 184, 216, 255, 255, 255, 255, 178, 112, 132, 224, 255, 255, 255, 255,
        179, 22, 154, 216, 255, 255, 255, 255, 180, 80, 102, 224, 255, 255, 255, 255, 180, 246,
        124, 216, 255, 255, 255, 255, 182, 48, 72, 224, 255, 255, 255, 255, 182, 223, 153, 88, 255,
        255, 255, 255, 184, 16, 42, 224, 255, 255, 255, 255, 184, 191, 123, 88, 255, 255, 255, 255,
        185, 240, 12, 224, 255, 255, 255, 255, 186, 159, 93, 88, 255, 255, 255, 255, 187, 217, 41,
        96, 255, 255, 255, 255, 188, 127, 63, 88, 255, 255, 255, 255, 189, 185, 11, 96, 255, 255,
        255, 255, 190, 95, 33, 88, 255, 255, 255, 255, 191, 152, 237, 96, 255, 255, 255, 255, 192,
        63, 3, 88, 255, 255, 255, 255, 193, 120, 207, 96, 255, 255, 255, 255, 194, 40, 31, 216,
        255, 255, 255, 255, 195, 88, 177, 96, 255, 255, 255, 255, 196, 8, 1, 216, 255, 255, 255,
        255, 197, 56, 147, 96, 255, 255, 255, 255, 197, 231, 227, 216, 255, 255, 255, 255, 199, 33,
        175, 224, 255, 255, 255, 255, 199, 199, 197, 216, 255, 255, 255, 255, 201, 1, 145, 224,
        255, 255, 255, 255, 201, 167, 167, 216, 255, 255, 255, 255, 202, 225, 115, 224, 255, 255,
        255, 255, 203, 144, 196, 88, 255, 255, 255, 255, 204, 64, 34, 224, 255, 255, 255, 255, 210,
        35, 244, 112, 255, 255, 255, 255, 210, 198, 113, 80, 255, 255, 255, 255, 214, 41, 250, 96,
        255, 255, 255, 255, 214, 217, 74, 216, 255, 255, 255, 255, 216, 9, 220, 96, 255, 255, 255,
        255, 216, 185, 44, 216, 255, 255, 255, 255, 217, 233, 190, 96, 255, 255, 255, 255, 218,
        153, 14, 216, 255, 255, 255, 255, 219, 210, 218, 224, 255, 255, 255, 255, 220, 120, 240,
        216, 255, 255, 255, 255, 221, 178, 188, 224, 255, 255, 255, 255, 222, 88, 210, 216, 255,
        255, 255, 255, 223, 146, 158, 224, 255, 255, 255, 255, 224, 65, 239, 88, 255, 255, 255,
        255, 225, 114, 128, 224, 255, 255, 255, 255, 226, 33, 209, 88, 255, 255, 255, 255, 227, 82,
        98, 224, 255, 255, 255, 255, 228, 1, 179, 88, 255, 255, 255, 255, 229, 50, 68, 224, 255,
        255, 255, 255, 229, 225, 149, 88, 255, 255, 255, 255, 231, 27, 97, 96, 255, 255, 255, 255,
        231, 193, 119, 88, 255, 255, 255, 255, 232, 251, 67, 96, 255, 255, 255, 255, 233, 161, 89,
        88, 255, 255, 255, 255, 234, 219, 37, 96, 255, 255, 255, 255, 235, 138, 117, 216, 255, 255,
        255, 255, 236, 187, 7, 96, 255, 255, 255, 255, 237, 106, 87, 216, 255, 255, 255, 255, 238,
        154, 233, 96, 255, 255, 255, 255, 239, 74, 57, 216, 255, 255, 255, 255, 240, 132, 5, 224,
        255, 255, 255, 255, 241, 42, 27, 216, 255, 255, 255, 255, 242, 99, 231, 224, 255, 255, 255,
        255, 243, 9, 253, 216, 255, 255, 255, 255, 244, 67, 201, 224, 255, 255, 255, 255, 244, 233,
        223, 216, 255, 255, 255, 255, 246, 35, 171, 224, 255, 255, 255, 255, 246, 210, 252, 88,
        255, 255, 255, 255, 248, 3, 141, 224, 255, 255, 255, 255, 248, 178, 222, 88, 255, 255, 255,
        255, 249, 227, 111, 224, 255, 255, 255, 255, 250, 146, 192, 88, 255, 255, 255, 255, 251,
        204, 140, 96, 255, 255, 255, 255, 252, 114, 162, 88, 0, 0, 0, 0, 7, 98, 219, 96, 0, 0, 0,
        0, 7, 185, 208, 80, 0, 0, 0, 0, 24, 97, 113, 96, 0, 0, 0, 0, 24, 171, 55, 80, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        5, 2, 5, 2, 255, 255, 173, 80, 0, 0, 255, 255, 178, 168, 1, 4, 255, 255, 171, 160, 0, 10,
        255, 255, 185, 176, 1, 14, 255, 255, 185, 176, 1, 18, 255, 255, 185, 176, 1, 22, 76, 77,
        84, 0, 45, 48, 53, 51, 48, 0, 67, 83, 84, 0, 67, 87, 84, 0, 67, 80, 84, 0, 67, 68, 84, 0,
        10, 67, 83, 84, 54, 10,
    ];
    pub(crate) const AmericaBoaVista: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        33, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 150, 170, 127, 224, 255, 255, 255, 255,
        184, 15, 87, 240, 255, 255, 255, 255, 184, 253, 78, 176, 255, 255, 255, 255, 185, 241, 66,
        64, 255, 255, 255, 255, 186, 222, 130, 48, 255, 255, 255, 255, 218, 56, 188, 64, 255, 255,
        255, 255, 218, 236, 8, 64, 255, 255, 255, 255, 220, 25, 239, 192, 255, 255, 255, 255, 220,
        185, 103, 48, 255, 255, 255, 255, 221, 251, 35, 64, 255, 255, 255, 255, 222, 155, 236, 48,
        255, 255, 255, 255, 223, 221, 168, 64, 255, 255, 255, 255, 224, 84, 65, 48, 255, 255, 255,
        255, 244, 152, 13, 192, 255, 255, 255, 255, 245, 5, 108, 48, 255, 255, 255, 255, 246, 192,
        114, 64, 255, 255, 255, 255, 247, 14, 44, 176, 255, 255, 255, 255, 248, 81, 58, 64, 255,
        255, 255, 255, 248, 199, 211, 48, 255, 255, 255, 255, 250, 10, 224, 192, 255, 255, 255,
        255, 250, 169, 6, 176, 255, 255, 255, 255, 251, 236, 20, 64, 255, 255, 255, 255, 252, 139,
        139, 176, 0, 0, 0, 0, 29, 201, 156, 64, 0, 0, 0, 0, 30, 120, 229, 176, 0, 0, 0, 0, 31, 160,
        67, 192, 0, 0, 0, 0, 32, 51, 221, 176, 0, 0, 0, 0, 33, 129, 119, 64, 0, 0, 0, 0, 34, 11,
        214, 176, 0, 0, 0, 0, 55, 246, 212, 192, 0, 0, 0, 0, 56, 184, 147, 48, 0, 0, 0, 0, 57, 223,
        241, 64, 0, 0, 0, 0, 57, 233, 29, 176, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 255, 255, 199, 32, 0, 0, 255, 255, 213,
        208, 1, 4, 255, 255, 199, 192, 0, 8, 76, 77, 84, 0, 45, 48, 51, 0, 45, 48, 52, 0, 10, 60,
        45, 48, 52, 62, 52, 10,
    ];
    pub(crate) const AmericaBogota: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        4, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 94, 156, 52, 240, 255, 255, 255, 255, 152,
        88, 85, 112, 0, 0, 0, 0, 42, 3, 115, 80, 0, 0, 0, 0, 43, 190, 93, 64, 1, 3, 2, 3, 255, 255,
        186, 144, 0, 0, 255, 255, 186, 144, 0, 4, 255, 255, 199, 192, 1, 8, 255, 255, 185, 176, 0,
        12, 76, 77, 84, 0, 66, 77, 84, 0, 45, 48, 52, 0, 45, 48, 53, 0, 10, 60, 45, 48, 53, 62, 53,
        10,
    ];
    pub(crate) const AmericaBoise: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        90, 0, 0, 0, 7, 0, 0, 0, 28, 255, 255, 255, 255, 94, 4, 26, 192, 255, 255, 255, 255, 158,
        166, 72, 160, 255, 255, 255, 255, 159, 187, 21, 144, 255, 255, 255, 255, 160, 134, 42, 160,
        255, 255, 255, 255, 161, 154, 247, 144, 255, 255, 255, 255, 168, 70, 76, 32, 255, 255, 255,
        255, 203, 137, 12, 144, 255, 255, 255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 97,
        24, 0, 255, 255, 255, 255, 250, 248, 117, 16, 255, 255, 255, 255, 251, 232, 88, 0, 255,
        255, 255, 255, 252, 216, 87, 16, 255, 255, 255, 255, 253, 200, 58, 0, 255, 255, 255, 255,
        254, 184, 57, 16, 255, 255, 255, 255, 255, 168, 28, 0, 0, 0, 0, 0, 0, 152, 27, 16, 0, 0, 0,
        0, 1, 135, 254, 0, 0, 0, 0, 0, 2, 119, 253, 16, 0, 0, 0, 0, 3, 113, 26, 128, 0, 0, 0, 0, 4,
        97, 25, 144, 0, 0, 0, 0, 5, 80, 252, 128, 0, 0, 0, 0, 6, 64, 251, 144, 0, 0, 0, 0, 7, 48,
        222, 128, 0, 0, 0, 0, 7, 178, 31, 144, 0, 0, 0, 0, 9, 16, 192, 128, 0, 0, 0, 0, 9, 173,
        177, 16, 0, 0, 0, 0, 10, 240, 162, 128, 0, 0, 0, 0, 11, 224, 161, 144, 0, 0, 0, 0, 12, 217,
        191, 0, 0, 0, 0, 0, 13, 192, 131, 144, 0, 0, 0, 0, 14, 185, 161, 0, 0, 0, 0, 0, 15, 169,
        160, 16, 0, 0, 0, 0, 16, 153, 131, 0, 0, 0, 0, 0, 17, 137, 130, 16, 0, 0, 0, 0, 18, 121,
        101, 0, 0, 0, 0, 0, 19, 105, 100, 16, 0, 0, 0, 0, 20, 89, 71, 0, 0, 0, 0, 0, 21, 73, 70,
        16, 0, 0, 0, 0, 22, 57, 41, 0, 0, 0, 0, 0, 23, 41, 40, 16, 0, 0, 0, 0, 24, 34, 69, 128, 0,
        0, 0, 0, 25, 9, 10, 16, 0, 0, 0, 0, 26, 2, 39, 128, 0, 0, 0, 0, 26, 242, 38, 144, 0, 0, 0,
        0, 27, 226, 9, 128, 0, 0, 0, 0, 28, 210, 8, 144, 0, 0, 0, 0, 29, 193, 235, 128, 0, 0, 0, 0,
        30, 177, 234, 144, 0, 0, 0, 0, 31, 161, 205, 128, 0, 0, 0, 0, 32, 118, 29, 16, 0, 0, 0, 0,
        33, 129, 175, 128, 0, 0, 0, 0, 34, 85, 255, 16, 0, 0, 0, 0, 35, 106, 204, 0, 0, 0, 0, 0,
        36, 53, 225, 16, 0, 0, 0, 0, 37, 74, 174, 0, 0, 0, 0, 0, 38, 21, 195, 16, 0, 0, 0, 0, 39,
        42, 144, 0, 0, 0, 0, 0, 39, 254, 223, 144, 0, 0, 0, 0, 41, 10, 114, 0, 0, 0, 0, 0, 41, 222,
        193, 144, 0, 0, 0, 0, 42, 234, 84, 0, 0, 0, 0, 0, 43, 190, 163, 144, 0, 0, 0, 0, 44, 211,
        112, 128, 0, 0, 0, 0, 45, 158, 133, 144, 0, 0, 0, 0, 46, 179, 82, 128, 0, 0, 0, 0, 47, 126,
        103, 144, 0, 0, 0, 0, 48, 147, 52, 128, 0, 0, 0, 0, 49, 103, 132, 16, 0, 0, 0, 0, 50, 115,
        22, 128, 0, 0, 0, 0, 51, 71, 102, 16, 0, 0, 0, 0, 52, 82, 248, 128, 0, 0, 0, 0, 53, 39, 72,
        16, 0, 0, 0, 0, 54, 50, 218, 128, 0, 0, 0, 0, 55, 7, 42, 16, 0, 0, 0, 0, 56, 27, 247, 0, 0,
        0, 0, 0, 56, 231, 12, 16, 0, 0, 0, 0, 57, 251, 217, 0, 0, 0, 0, 0, 58, 198, 238, 16, 0, 0,
        0, 0, 59, 219, 187, 0, 0, 0, 0, 0, 60, 176, 10, 144, 0, 0, 0, 0, 61, 187, 157, 0, 0, 0, 0,
        0, 62, 143, 236, 144, 0, 0, 0, 0, 63, 155, 127, 0, 0, 0, 0, 0, 64, 111, 206, 144, 0, 0, 0,
        0, 65, 132, 155, 128, 0, 0, 0, 0, 66, 79, 176, 144, 0, 0, 0, 0, 67, 100, 125, 128, 0, 0, 0,
        0, 68, 47, 146, 144, 0, 0, 0, 0, 69, 68, 95, 128, 0, 0, 0, 0, 69, 243, 197, 16, 2, 1, 2, 1,
        2, 5, 3, 4, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6,
        5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6,
        5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 255, 255,
        147, 15, 0, 0, 255, 255, 157, 144, 1, 4, 255, 255, 143, 128, 0, 8, 255, 255, 171, 160, 1,
        12, 255, 255, 171, 160, 1, 16, 255, 255, 157, 144, 0, 20, 255, 255, 171, 160, 1, 24, 76,
        77, 84, 0, 80, 68, 84, 0, 80, 83, 84, 0, 77, 87, 84, 0, 77, 80, 84, 0, 77, 83, 84, 0, 77,
        68, 84, 0, 10, 77, 83, 84, 55, 77, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46,
        49, 46, 48, 10,
    ];
    pub(crate) const AmericaBuenosAires: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        61, 0, 0, 0, 6, 0, 0, 0, 20, 255, 255, 255, 255, 114, 156, 168, 76, 255, 255, 255, 255,
        162, 146, 143, 48, 255, 255, 255, 255, 182, 123, 82, 64, 255, 255, 255, 255, 183, 26, 201,
        176, 255, 255, 255, 255, 184, 30, 143, 64, 255, 255, 255, 255, 184, 212, 112, 48, 255, 255,
        255, 255, 186, 23, 125, 192, 255, 255, 255, 255, 186, 181, 163, 176, 255, 255, 255, 255,
        187, 248, 177, 64, 255, 255, 255, 255, 188, 150, 215, 48, 255, 255, 255, 255, 189, 217,
        228, 192, 255, 255, 255, 255, 190, 120, 10, 176, 255, 255, 255, 255, 191, 187, 24, 64, 255,
        255, 255, 255, 192, 90, 143, 176, 255, 255, 255, 255, 193, 157, 157, 64, 255, 255, 255,
        255, 194, 59, 195, 48, 255, 255, 255, 255, 195, 126, 208, 192, 255, 255, 255, 255, 196, 28,
        246, 176, 255, 255, 255, 255, 197, 96, 4, 64, 255, 255, 255, 255, 197, 254, 42, 48, 255,
        255, 255, 255, 199, 65, 55, 192, 255, 255, 255, 255, 199, 224, 175, 48, 255, 255, 255, 255,
        200, 129, 148, 64, 255, 255, 255, 255, 202, 77, 161, 176, 255, 255, 255, 255, 202, 238,
        134, 192, 255, 255, 255, 255, 206, 77, 255, 48, 255, 255, 255, 255, 206, 176, 237, 192,
        255, 255, 255, 255, 211, 41, 53, 176, 255, 255, 255, 255, 212, 67, 100, 192, 255, 255, 255,
        255, 244, 61, 8, 48, 255, 255, 255, 255, 244, 159, 246, 192, 255, 255, 255, 255, 245, 5,
        108, 48, 255, 255, 255, 255, 246, 50, 16, 64, 255, 255, 255, 255, 246, 230, 159, 176, 255,
        255, 255, 255, 248, 19, 67, 192, 255, 255, 255, 255, 248, 199, 211, 48, 255, 255, 255, 255,
        249, 244, 119, 64, 255, 255, 255, 255, 250, 211, 54, 176, 255, 255, 255, 255, 251, 195, 53,
        192, 255, 255, 255, 255, 252, 188, 83, 48, 255, 255, 255, 255, 253, 172, 82, 64, 255, 255,
        255, 255, 254, 156, 53, 48, 255, 255, 255, 255, 255, 140, 52, 64, 0, 0, 0, 0, 7, 163, 74,
        176, 0, 0, 0, 0, 8, 36, 111, 160, 0, 0, 0, 0, 35, 148, 181, 176, 0, 0, 0, 0, 36, 16, 148,
        160, 0, 0, 0, 0, 37, 55, 242, 176, 0, 0, 0, 0, 37, 240, 118, 160, 0, 0, 0, 0, 39, 33, 15,
        48, 0, 0, 0, 0, 39, 208, 88, 160, 0, 0, 0, 0, 41, 0, 241, 48, 0, 0, 0, 0, 41, 176, 58, 160,
        0, 0, 0, 0, 42, 224, 211, 48, 0, 0, 0, 0, 43, 153, 87, 32, 0, 0, 0, 0, 55, 246, 198, 176,
        0, 0, 0, 0, 56, 191, 42, 176, 0, 0, 0, 0, 71, 119, 9, 176, 0, 0, 0, 0, 71, 220, 127, 32, 0,
        0, 0, 0, 72, 250, 162, 176, 0, 0, 0, 0, 73, 188, 97, 32, 1, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 3, 5, 4, 5, 4, 5, 255, 255, 201, 52, 0, 0, 255,
        255, 195, 208, 0, 4, 255, 255, 199, 192, 0, 8, 255, 255, 213, 208, 1, 12, 255, 255, 227,
        224, 1, 16, 255, 255, 213, 208, 0, 12, 76, 77, 84, 0, 67, 77, 84, 0, 45, 48, 52, 0, 45, 48,
        51, 0, 45, 48, 50, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AmericaCambridgeBay: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        62, 0, 0, 0, 9, 0, 0, 0, 37, 255, 255, 255, 255, 161, 242, 205, 128, 255, 255, 255, 255,
        203, 137, 12, 144, 255, 255, 255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 97, 24,
        0, 255, 255, 255, 255, 247, 47, 90, 112, 255, 255, 255, 255, 248, 40, 133, 240, 0, 0, 0, 0,
        19, 105, 100, 16, 0, 0, 0, 0, 20, 89, 71, 0, 0, 0, 0, 0, 21, 73, 70, 16, 0, 0, 0, 0, 22,
        57, 41, 0, 0, 0, 0, 0, 23, 41, 40, 16, 0, 0, 0, 0, 24, 34, 69, 128, 0, 0, 0, 0, 25, 9, 10,
        16, 0, 0, 0, 0, 26, 2, 39, 128, 0, 0, 0, 0, 26, 242, 38, 144, 0, 0, 0, 0, 27, 226, 9, 128,
        0, 0, 0, 0, 28, 210, 8, 144, 0, 0, 0, 0, 29, 193, 235, 128, 0, 0, 0, 0, 30, 177, 234, 144,
        0, 0, 0, 0, 31, 161, 205, 128, 0, 0, 0, 0, 32, 118, 29, 16, 0, 0, 0, 0, 33, 129, 175, 128,
        0, 0, 0, 0, 34, 85, 255, 16, 0, 0, 0, 0, 35, 106, 204, 0, 0, 0, 0, 0, 36, 53, 225, 16, 0,
        0, 0, 0, 37, 74, 174, 0, 0, 0, 0, 0, 38, 21, 195, 16, 0, 0, 0, 0, 39, 42, 144, 0, 0, 0, 0,
        0, 39, 254, 223, 144, 0, 0, 0, 0, 41, 10, 114, 0, 0, 0, 0, 0, 41, 222, 193, 144, 0, 0, 0,
        0, 42, 234, 84, 0, 0, 0, 0, 0, 43, 190, 163, 144, 0, 0, 0, 0, 44, 211, 112, 128, 0, 0, 0,
        0, 45, 158, 133, 144, 0, 0, 0, 0, 46, 179, 82, 128, 0, 0, 0, 0, 47, 126, 103, 144, 0, 0, 0,
        0, 48, 147, 52, 128, 0, 0, 0, 0, 49, 103, 132, 16, 0, 0, 0, 0, 50, 115, 22, 128, 0, 0, 0,
        0, 51, 71, 102, 16, 0, 0, 0, 0, 52, 82, 248, 128, 0, 0, 0, 0, 53, 39, 72, 16, 0, 0, 0, 0,
        54, 50, 218, 128, 0, 0, 0, 0, 55, 7, 42, 16, 0, 0, 0, 0, 56, 27, 247, 0, 0, 0, 0, 0, 56,
        230, 254, 0, 0, 0, 0, 0, 57, 251, 202, 240, 0, 0, 0, 0, 58, 4, 233, 80, 0, 0, 0, 0, 58,
        198, 238, 16, 0, 0, 0, 0, 59, 219, 187, 0, 0, 0, 0, 0, 60, 176, 10, 144, 0, 0, 0, 0, 61,
        187, 157, 0, 0, 0, 0, 0, 62, 143, 236, 144, 0, 0, 0, 0, 63, 155, 127, 0, 0, 0, 0, 0, 64,
        111, 206, 144, 0, 0, 0, 0, 65, 132, 155, 128, 0, 0, 0, 0, 66, 79, 176, 144, 0, 0, 0, 0, 67,
        100, 125, 128, 0, 0, 0, 0, 68, 47, 146, 144, 0, 0, 0, 0, 69, 68, 95, 128, 0, 0, 0, 0, 69,
        243, 197, 16, 3, 1, 2, 3, 4, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3,
        5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 7, 6, 8, 7, 5, 3, 5, 3, 5, 3, 5,
        3, 5, 3, 5, 3, 5, 0, 0, 0, 0, 0, 0, 255, 255, 171, 160, 1, 4, 255, 255, 171, 160, 1, 8,
        255, 255, 157, 144, 0, 12, 255, 255, 185, 176, 1, 16, 255, 255, 171, 160, 1, 21, 255, 255,
        185, 176, 1, 25, 255, 255, 171, 160, 0, 29, 255, 255, 185, 176, 0, 33, 45, 48, 48, 0, 77,
        87, 84, 0, 77, 80, 84, 0, 77, 83, 84, 0, 77, 68, 68, 84, 0, 77, 68, 84, 0, 67, 68, 84, 0,
        67, 83, 84, 0, 69, 83, 84, 0, 10, 77, 83, 84, 55, 77, 68, 84, 44, 77, 51, 46, 50, 46, 48,
        44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaCampoGrande: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        91, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 150, 170, 122, 52, 255, 255, 255, 255,
        184, 15, 87, 240, 255, 255, 255, 255, 184, 253, 78, 176, 255, 255, 255, 255, 185, 241, 66,
        64, 255, 255, 255, 255, 186, 222, 130, 48, 255, 255, 255, 255, 218, 56, 188, 64, 255, 255,
        255, 255, 218, 236, 8, 64, 255, 255, 255, 255, 220, 25, 239, 192, 255, 255, 255, 255, 220,
        185, 103, 48, 255, 255, 255, 255, 221, 251, 35, 64, 255, 255, 255, 255, 222, 155, 236, 48,
        255, 255, 255, 255, 223, 221, 168, 64, 255, 255, 255, 255, 224, 84, 65, 48, 255, 255, 255,
        255, 244, 152, 13, 192, 255, 255, 255, 255, 245, 5, 108, 48, 255, 255, 255, 255, 246, 192,
        114, 64, 255, 255, 255, 255, 247, 14, 44, 176, 255, 255, 255, 255, 248, 81, 58, 64, 255,
        255, 255, 255, 248, 199, 211, 48, 255, 255, 255, 255, 250, 10, 224, 192, 255, 255, 255,
        255, 250, 169, 6, 176, 255, 255, 255, 255, 251, 236, 20, 64, 255, 255, 255, 255, 252, 139,
        139, 176, 0, 0, 0, 0, 29, 201, 156, 64, 0, 0, 0, 0, 30, 120, 229, 176, 0, 0, 0, 0, 31, 160,
        67, 192, 0, 0, 0, 0, 32, 51, 221, 176, 0, 0, 0, 0, 33, 129, 119, 64, 0, 0, 0, 0, 34, 11,
        214, 176, 0, 0, 0, 0, 35, 88, 30, 192, 0, 0, 0, 0, 35, 226, 126, 48, 0, 0, 0, 0, 37, 56, 0,
        192, 0, 0, 0, 0, 37, 212, 213, 48, 0, 0, 0, 0, 39, 33, 29, 64, 0, 0, 0, 0, 39, 189, 241,
        176, 0, 0, 0, 0, 41, 0, 255, 64, 0, 0, 0, 0, 41, 148, 153, 48, 0, 0, 0, 0, 42, 234, 27,
        192, 0, 0, 0, 0, 43, 107, 64, 176, 0, 0, 0, 0, 44, 192, 195, 64, 0, 0, 0, 0, 45, 102, 210,
        48, 0, 0, 0, 0, 46, 160, 165, 64, 0, 0, 0, 0, 47, 70, 180, 48, 0, 0, 0, 0, 48, 128, 135,
        64, 0, 0, 0, 0, 49, 29, 91, 176, 0, 0, 0, 0, 50, 87, 46, 192, 0, 0, 0, 0, 51, 6, 120, 48,
        0, 0, 0, 0, 52, 56, 98, 64, 0, 0, 0, 0, 52, 248, 207, 48, 0, 0, 0, 0, 54, 32, 45, 64, 0, 0,
        0, 0, 54, 207, 118, 176, 0, 0, 0, 0, 55, 246, 212, 192, 0, 0, 0, 0, 56, 184, 147, 48, 0, 0,
        0, 0, 57, 223, 241, 64, 0, 0, 0, 0, 58, 143, 58, 176, 0, 0, 0, 0, 59, 201, 13, 192, 0, 0,
        0, 0, 60, 111, 28, 176, 0, 0, 0, 0, 61, 196, 159, 64, 0, 0, 0, 0, 62, 78, 254, 176, 0, 0,
        0, 0, 63, 146, 12, 64, 0, 0, 0, 0, 64, 46, 224, 176, 0, 0, 0, 0, 65, 135, 6, 64, 0, 0, 0,
        0, 66, 23, 253, 48, 0, 0, 0, 0, 67, 81, 208, 64, 0, 0, 0, 0, 67, 247, 223, 48, 0, 0, 0, 0,
        69, 77, 97, 192, 0, 0, 0, 0, 69, 224, 251, 176, 0, 0, 0, 0, 71, 17, 148, 64, 0, 0, 0, 0,
        71, 183, 163, 48, 0, 0, 0, 0, 72, 250, 176, 192, 0, 0, 0, 0, 73, 151, 133, 48, 0, 0, 0, 0,
        74, 218, 146, 192, 0, 0, 0, 0, 75, 128, 161, 176, 0, 0, 0, 0, 76, 186, 116, 192, 0, 0, 0,
        0, 77, 96, 131, 176, 0, 0, 0, 0, 78, 154, 86, 192, 0, 0, 0, 0, 79, 73, 160, 48, 0, 0, 0, 0,
        80, 131, 115, 64, 0, 0, 0, 0, 81, 32, 71, 176, 0, 0, 0, 0, 82, 99, 85, 64, 0, 0, 0, 0, 83,
        0, 41, 176, 0, 0, 0, 0, 84, 67, 55, 64, 0, 0, 0, 0, 84, 233, 70, 48, 0, 0, 0, 0, 86, 35,
        25, 64, 0, 0, 0, 0, 86, 201, 40, 48, 0, 0, 0, 0, 88, 2, 251, 64, 0, 0, 0, 0, 88, 169, 10,
        48, 0, 0, 0, 0, 89, 226, 221, 64, 0, 0, 0, 0, 90, 136, 236, 48, 0, 0, 0, 0, 91, 222, 110,
        192, 0, 0, 0, 0, 92, 104, 206, 48, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 255, 255, 204, 204, 0, 0, 255, 255, 213, 208, 1, 4,
        255, 255, 199, 192, 0, 8, 76, 77, 84, 0, 45, 48, 51, 0, 45, 48, 52, 0, 10, 60, 45, 48, 52,
        62, 52, 10,
    ];
    pub(crate) const AmericaCancun: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        42, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 165, 182, 218, 96, 0, 0, 0, 0, 22, 134,
        213, 96, 0, 0, 0, 0, 49, 103, 103, 240, 0, 0, 0, 0, 50, 114, 250, 96, 0, 0, 0, 0, 51, 71,
        73, 240, 0, 0, 0, 0, 52, 82, 220, 96, 0, 0, 0, 0, 53, 39, 43, 240, 0, 0, 0, 0, 53, 196, 0,
        96, 0, 0, 0, 0, 54, 50, 204, 112, 0, 0, 0, 0, 55, 7, 28, 0, 0, 0, 0, 0, 56, 27, 232, 240,
        0, 0, 0, 0, 56, 230, 254, 0, 0, 0, 0, 0, 57, 251, 202, 240, 0, 0, 0, 0, 58, 245, 4, 128, 0,
        0, 0, 0, 59, 182, 194, 240, 0, 0, 0, 0, 60, 175, 252, 128, 0, 0, 0, 0, 61, 187, 142, 240,
        0, 0, 0, 0, 62, 143, 222, 128, 0, 0, 0, 0, 63, 155, 112, 240, 0, 0, 0, 0, 64, 111, 192,
        128, 0, 0, 0, 0, 65, 132, 141, 112, 0, 0, 0, 0, 66, 79, 162, 128, 0, 0, 0, 0, 67, 100, 111,
        112, 0, 0, 0, 0, 68, 47, 132, 128, 0, 0, 0, 0, 69, 68, 81, 112, 0, 0, 0, 0, 70, 15, 102,
        128, 0, 0, 0, 0, 71, 36, 51, 112, 0, 0, 0, 0, 71, 248, 131, 0, 0, 0, 0, 0, 73, 4, 21, 112,
        0, 0, 0, 0, 73, 216, 101, 0, 0, 0, 0, 0, 74, 227, 247, 112, 0, 0, 0, 0, 75, 184, 71, 0, 0,
        0, 0, 0, 76, 205, 19, 240, 0, 0, 0, 0, 77, 152, 41, 0, 0, 0, 0, 0, 78, 172, 245, 240, 0, 0,
        0, 0, 79, 120, 11, 0, 0, 0, 0, 0, 80, 140, 215, 240, 0, 0, 0, 0, 81, 97, 39, 128, 0, 0, 0,
        0, 82, 108, 185, 240, 0, 0, 0, 0, 83, 65, 9, 128, 0, 0, 0, 0, 84, 76, 155, 240, 0, 0, 0, 0,
        84, 205, 221, 0, 1, 3, 2, 3, 2, 3, 2, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1,
        4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 3, 255, 255, 174, 168, 0, 0, 255, 255, 171,
        160, 0, 4, 255, 255, 199, 192, 1, 8, 255, 255, 185, 176, 0, 12, 255, 255, 185, 176, 1, 16,
        76, 77, 84, 0, 67, 83, 84, 0, 69, 68, 84, 0, 69, 83, 84, 0, 67, 68, 84, 0, 10, 69, 83, 84,
        53, 10,
    ];
    pub(crate) const AmericaCaracas: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        5, 0, 0, 0, 4, 0, 0, 0, 18, 255, 255, 255, 255, 105, 135, 26, 64, 255, 255, 255, 255, 147,
        30, 44, 60, 255, 255, 255, 255, 246, 152, 236, 72, 0, 0, 0, 0, 71, 91, 146, 112, 0, 0, 0,
        0, 87, 37, 169, 112, 1, 2, 3, 2, 3, 255, 255, 193, 64, 0, 0, 255, 255, 193, 68, 0, 4, 255,
        255, 192, 184, 0, 8, 255, 255, 199, 192, 0, 14, 76, 77, 84, 0, 67, 77, 84, 0, 45, 48, 52,
        51, 48, 0, 45, 48, 52, 0, 10, 60, 45, 48, 52, 62, 52, 10,
    ];
    pub(crate) const AmericaCatamarca: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        61, 0, 0, 0, 6, 0, 0, 0, 20, 255, 255, 255, 255, 114, 156, 175, 44, 255, 255, 255, 255,
        162, 146, 143, 48, 255, 255, 255, 255, 182, 123, 82, 64, 255, 255, 255, 255, 183, 26, 201,
        176, 255, 255, 255, 255, 184, 30, 143, 64, 255, 255, 255, 255, 184, 212, 112, 48, 255, 255,
        255, 255, 186, 23, 125, 192, 255, 255, 255, 255, 186, 181, 163, 176, 255, 255, 255, 255,
        187, 248, 177, 64, 255, 255, 255, 255, 188, 150, 215, 48, 255, 255, 255, 255, 189, 217,
        228, 192, 255, 255, 255, 255, 190, 120, 10, 176, 255, 255, 255, 255, 191, 187, 24, 64, 255,
        255, 255, 255, 192, 90, 143, 176, 255, 255, 255, 255, 193, 157, 157, 64, 255, 255, 255,
        255, 194, 59, 195, 48, 255, 255, 255, 255, 195, 126, 208, 192, 255, 255, 255, 255, 196, 28,
        246, 176, 255, 255, 255, 255, 197, 96, 4, 64, 255, 255, 255, 255, 197, 254, 42, 48, 255,
        255, 255, 255, 199, 65, 55, 192, 255, 255, 255, 255, 199, 224, 175, 48, 255, 255, 255, 255,
        200, 129, 148, 64, 255, 255, 255, 255, 202, 77, 161, 176, 255, 255, 255, 255, 202, 238,
        134, 192, 255, 255, 255, 255, 206, 77, 255, 48, 255, 255, 255, 255, 206, 176, 237, 192,
        255, 255, 255, 255, 211, 41, 53, 176, 255, 255, 255, 255, 212, 67, 100, 192, 255, 255, 255,
        255, 244, 61, 8, 48, 255, 255, 255, 255, 244, 159, 246, 192, 255, 255, 255, 255, 245, 5,
        108, 48, 255, 255, 255, 255, 246, 50, 16, 64, 255, 255, 255, 255, 246, 230, 159, 176, 255,
        255, 255, 255, 248, 19, 67, 192, 255, 255, 255, 255, 248, 199, 211, 48, 255, 255, 255, 255,
        249, 244, 119, 64, 255, 255, 255, 255, 250, 211, 54, 176, 255, 255, 255, 255, 251, 195, 53,
        192, 255, 255, 255, 255, 252, 188, 83, 48, 255, 255, 255, 255, 253, 172, 82, 64, 255, 255,
        255, 255, 254, 156, 53, 48, 255, 255, 255, 255, 255, 140, 52, 64, 0, 0, 0, 0, 7, 163, 74,
        176, 0, 0, 0, 0, 8, 36, 111, 160, 0, 0, 0, 0, 35, 148, 181, 176, 0, 0, 0, 0, 36, 16, 148,
        160, 0, 0, 0, 0, 37, 55, 242, 176, 0, 0, 0, 0, 37, 240, 118, 160, 0, 0, 0, 0, 39, 33, 15,
        48, 0, 0, 0, 0, 39, 208, 88, 160, 0, 0, 0, 0, 41, 0, 255, 64, 0, 0, 0, 0, 41, 176, 58, 160,
        0, 0, 0, 0, 42, 224, 211, 48, 0, 0, 0, 0, 43, 153, 87, 32, 0, 0, 0, 0, 55, 246, 198, 176,
        0, 0, 0, 0, 56, 191, 42, 176, 0, 0, 0, 0, 64, 187, 241, 48, 0, 0, 0, 0, 64, 213, 11, 192,
        0, 0, 0, 0, 71, 119, 9, 176, 0, 0, 0, 0, 71, 220, 127, 32, 1, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 5, 4, 5, 4, 5, 4, 5, 4, 2, 4, 5, 4, 5, 3, 5, 2, 5, 4, 5, 255, 255, 194, 84, 0, 0, 255,
        255, 195, 208, 0, 4, 255, 255, 199, 192, 0, 8, 255, 255, 213, 208, 1, 12, 255, 255, 227,
        224, 1, 16, 255, 255, 213, 208, 0, 12, 76, 77, 84, 0, 67, 77, 84, 0, 45, 48, 52, 0, 45, 48,
        51, 0, 45, 48, 50, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AmericaCayenne: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        2, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 145, 244, 43, 144, 255, 255, 255, 255, 251,
        195, 53, 192, 1, 2, 255, 255, 206, 240, 0, 0, 255, 255, 199, 192, 0, 4, 255, 255, 213, 208,
        0, 8, 76, 77, 84, 0, 45, 48, 52, 0, 45, 48, 51, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AmericaChicago: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        175, 0, 0, 0, 6, 0, 0, 0, 24, 255, 255, 255, 255, 94, 3, 254, 160, 255, 255, 255, 255, 158,
        166, 44, 128, 255, 255, 255, 255, 159, 186, 249, 112, 255, 255, 255, 255, 160, 134, 14,
        128, 255, 255, 255, 255, 161, 154, 219, 112, 255, 255, 255, 255, 162, 203, 116, 0, 255,
        255, 255, 255, 163, 131, 247, 240, 255, 255, 255, 255, 164, 69, 210, 128, 255, 255, 255,
        255, 165, 99, 217, 240, 255, 255, 255, 255, 166, 83, 217, 0, 255, 255, 255, 255, 167, 21,
        151, 112, 255, 255, 255, 255, 168, 51, 187, 0, 255, 255, 255, 255, 168, 254, 179, 240, 255,
        255, 255, 255, 170, 19, 157, 0, 255, 255, 255, 255, 170, 222, 149, 240, 255, 255, 255, 255,
        171, 243, 127, 0, 255, 255, 255, 255, 172, 190, 119, 240, 255, 255, 255, 255, 173, 211, 97,
        0, 255, 255, 255, 255, 174, 158, 89, 240, 255, 255, 255, 255, 175, 179, 67, 0, 255, 255,
        255, 255, 176, 126, 59, 240, 255, 255, 255, 255, 177, 156, 95, 128, 255, 255, 255, 255,
        178, 103, 88, 112, 255, 255, 255, 255, 179, 124, 65, 128, 255, 255, 255, 255, 180, 71, 58,
        112, 255, 255, 255, 255, 181, 92, 35, 128, 255, 255, 255, 255, 182, 39, 28, 112, 255, 255,
        255, 255, 183, 60, 5, 128, 255, 255, 255, 255, 184, 6, 254, 112, 255, 255, 255, 255, 185,
        27, 231, 128, 255, 255, 255, 255, 185, 230, 224, 112, 255, 255, 255, 255, 187, 5, 4, 0,
        255, 255, 255, 255, 187, 198, 194, 112, 255, 255, 255, 255, 188, 228, 230, 0, 255, 255,
        255, 255, 189, 175, 222, 240, 255, 255, 255, 255, 190, 196, 200, 0, 255, 255, 255, 255,
        191, 143, 192, 240, 255, 255, 255, 255, 192, 90, 214, 0, 255, 255, 255, 255, 193, 176, 60,
        112, 255, 255, 255, 255, 194, 132, 140, 0, 255, 255, 255, 255, 195, 79, 132, 240, 255, 255,
        255, 255, 196, 100, 110, 0, 255, 255, 255, 255, 197, 47, 102, 240, 255, 255, 255, 255, 198,
        77, 138, 128, 255, 255, 255, 255, 199, 15, 72, 240, 255, 255, 255, 255, 200, 45, 108, 128,
        255, 255, 255, 255, 200, 248, 101, 112, 255, 255, 255, 255, 202, 13, 78, 128, 255, 255,
        255, 255, 202, 216, 71, 112, 255, 255, 255, 255, 203, 136, 254, 128, 255, 255, 255, 255,
        210, 35, 244, 112, 255, 255, 255, 255, 210, 97, 9, 240, 255, 255, 255, 255, 211, 117, 243,
        0, 255, 255, 255, 255, 212, 64, 235, 240, 255, 255, 255, 255, 213, 85, 213, 0, 255, 255,
        255, 255, 214, 32, 205, 240, 255, 255, 255, 255, 215, 53, 183, 0, 255, 255, 255, 255, 216,
        0, 175, 240, 255, 255, 255, 255, 217, 21, 153, 0, 255, 255, 255, 255, 217, 224, 145, 240,
        255, 255, 255, 255, 218, 254, 181, 128, 255, 255, 255, 255, 219, 192, 115, 240, 255, 255,
        255, 255, 220, 222, 151, 128, 255, 255, 255, 255, 221, 169, 144, 112, 255, 255, 255, 255,
        222, 190, 121, 128, 255, 255, 255, 255, 223, 137, 114, 112, 255, 255, 255, 255, 224, 158,
        91, 128, 255, 255, 255, 255, 225, 105, 84, 112, 255, 255, 255, 255, 226, 126, 61, 128, 255,
        255, 255, 255, 227, 73, 54, 112, 255, 255, 255, 255, 228, 94, 31, 128, 255, 255, 255, 255,
        229, 87, 60, 240, 255, 255, 255, 255, 230, 71, 60, 0, 255, 255, 255, 255, 231, 55, 30, 240,
        255, 255, 255, 255, 232, 39, 30, 0, 255, 255, 255, 255, 233, 23, 0, 240, 255, 255, 255,
        255, 234, 7, 0, 0, 255, 255, 255, 255, 234, 246, 226, 240, 255, 255, 255, 255, 235, 230,
        226, 0, 255, 255, 255, 255, 236, 214, 196, 240, 255, 255, 255, 255, 237, 198, 196, 0, 255,
        255, 255, 255, 238, 191, 225, 112, 255, 255, 255, 255, 239, 175, 224, 128, 255, 255, 255,
        255, 240, 159, 195, 112, 255, 255, 255, 255, 241, 143, 194, 128, 255, 255, 255, 255, 242,
        127, 165, 112, 255, 255, 255, 255, 243, 111, 164, 128, 255, 255, 255, 255, 244, 95, 135,
        112, 255, 255, 255, 255, 245, 79, 134, 128, 255, 255, 255, 255, 246, 63, 105, 112, 255,
        255, 255, 255, 247, 47, 104, 128, 255, 255, 255, 255, 248, 40, 133, 240, 255, 255, 255,
        255, 249, 15, 74, 128, 255, 255, 255, 255, 250, 8, 103, 240, 255, 255, 255, 255, 250, 248,
        103, 0, 255, 255, 255, 255, 251, 232, 73, 240, 255, 255, 255, 255, 252, 216, 73, 0, 255,
        255, 255, 255, 253, 200, 43, 240, 255, 255, 255, 255, 254, 184, 43, 0, 255, 255, 255, 255,
        255, 168, 13, 240, 0, 0, 0, 0, 0, 152, 13, 0, 0, 0, 0, 0, 1, 135, 239, 240, 0, 0, 0, 0, 2,
        119, 239, 0, 0, 0, 0, 0, 3, 113, 12, 112, 0, 0, 0, 0, 4, 97, 11, 128, 0, 0, 0, 0, 5, 80,
        238, 112, 0, 0, 0, 0, 6, 64, 237, 128, 0, 0, 0, 0, 7, 48, 208, 112, 0, 0, 0, 0, 7, 141, 39,
        128, 0, 0, 0, 0, 9, 16, 178, 112, 0, 0, 0, 0, 9, 173, 163, 0, 0, 0, 0, 0, 10, 240, 148,
        112, 0, 0, 0, 0, 11, 224, 147, 128, 0, 0, 0, 0, 12, 217, 176, 240, 0, 0, 0, 0, 13, 192,
        117, 128, 0, 0, 0, 0, 14, 185, 146, 240, 0, 0, 0, 0, 15, 169, 146, 0, 0, 0, 0, 0, 16, 153,
        116, 240, 0, 0, 0, 0, 17, 137, 116, 0, 0, 0, 0, 0, 18, 121, 86, 240, 0, 0, 0, 0, 19, 105,
        86, 0, 0, 0, 0, 0, 20, 89, 56, 240, 0, 0, 0, 0, 21, 73, 56, 0, 0, 0, 0, 0, 22, 57, 26, 240,
        0, 0, 0, 0, 23, 41, 26, 0, 0, 0, 0, 0, 24, 34, 55, 112, 0, 0, 0, 0, 25, 8, 252, 0, 0, 0, 0,
        0, 26, 2, 25, 112, 0, 0, 0, 0, 26, 242, 24, 128, 0, 0, 0, 0, 27, 225, 251, 112, 0, 0, 0, 0,
        28, 209, 250, 128, 0, 0, 0, 0, 29, 193, 221, 112, 0, 0, 0, 0, 30, 177, 220, 128, 0, 0, 0,
        0, 31, 161, 191, 112, 0, 0, 0, 0, 32, 118, 15, 0, 0, 0, 0, 0, 33, 129, 161, 112, 0, 0, 0,
        0, 34, 85, 241, 0, 0, 0, 0, 0, 35, 106, 189, 240, 0, 0, 0, 0, 36, 53, 211, 0, 0, 0, 0, 0,
        37, 74, 159, 240, 0, 0, 0, 0, 38, 21, 181, 0, 0, 0, 0, 0, 39, 42, 129, 240, 0, 0, 0, 0, 39,
        254, 209, 128, 0, 0, 0, 0, 41, 10, 99, 240, 0, 0, 0, 0, 41, 222, 179, 128, 0, 0, 0, 0, 42,
        234, 69, 240, 0, 0, 0, 0, 43, 190, 149, 128, 0, 0, 0, 0, 44, 211, 98, 112, 0, 0, 0, 0, 45,
        158, 119, 128, 0, 0, 0, 0, 46, 179, 68, 112, 0, 0, 0, 0, 47, 126, 89, 128, 0, 0, 0, 0, 48,
        147, 38, 112, 0, 0, 0, 0, 49, 103, 118, 0, 0, 0, 0, 0, 50, 115, 8, 112, 0, 0, 0, 0, 51, 71,
        88, 0, 0, 0, 0, 0, 52, 82, 234, 112, 0, 0, 0, 0, 53, 39, 58, 0, 0, 0, 0, 0, 54, 50, 204,
        112, 0, 0, 0, 0, 55, 7, 28, 0, 0, 0, 0, 0, 56, 27, 232, 240, 0, 0, 0, 0, 56, 230, 254, 0,
        0, 0, 0, 0, 57, 251, 202, 240, 0, 0, 0, 0, 58, 198, 224, 0, 0, 0, 0, 0, 59, 219, 172, 240,
        0, 0, 0, 0, 60, 175, 252, 128, 0, 0, 0, 0, 61, 187, 142, 240, 0, 0, 0, 0, 62, 143, 222,
        128, 0, 0, 0, 0, 63, 155, 112, 240, 0, 0, 0, 0, 64, 111, 192, 128, 0, 0, 0, 0, 65, 132,
        141, 112, 0, 0, 0, 0, 66, 79, 162, 128, 0, 0, 0, 0, 67, 100, 111, 112, 0, 0, 0, 0, 68, 47,
        132, 128, 0, 0, 0, 0, 69, 68, 81, 112, 0, 0, 0, 0, 69, 243, 183, 0, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 4, 5, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 255, 255, 173, 212, 0, 0, 255, 255, 185,
        176, 1, 4, 255, 255, 171, 160, 0, 8, 255, 255, 185, 176, 0, 12, 255, 255, 185, 176, 1, 16,
        255, 255, 185, 176, 1, 20, 76, 77, 84, 0, 67, 68, 84, 0, 67, 83, 84, 0, 69, 83, 84, 0, 67,
        87, 84, 0, 67, 80, 84, 0, 10, 67, 83, 84, 54, 67, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44,
        77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaChihuahua: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        19, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 165, 182, 232, 112, 255, 255, 255, 255,
        175, 242, 110, 224, 255, 255, 255, 255, 182, 102, 86, 96, 255, 255, 255, 255, 183, 67, 210,
        96, 255, 255, 255, 255, 184, 12, 54, 96, 255, 255, 255, 255, 184, 253, 134, 240, 0, 0, 0,
        0, 49, 103, 118, 0, 0, 0, 0, 0, 50, 115, 8, 112, 0, 0, 0, 0, 51, 71, 88, 0, 0, 0, 0, 0, 52,
        82, 234, 112, 0, 0, 0, 0, 53, 39, 72, 16, 0, 0, 0, 0, 54, 50, 218, 128, 0, 0, 0, 0, 55, 7,
        42, 16, 0, 0, 0, 0, 56, 27, 247, 0, 0, 0, 0, 0, 56, 231, 12, 16, 0, 0, 0, 0, 57, 251, 217,
        0, 0, 0, 0, 0, 58, 245, 18, 144, 0, 0, 0, 0, 59, 182, 209, 0, 0, 0, 0, 0, 60, 176, 10, 144,
        1, 2, 1, 2, 1, 2, 3, 2, 3, 2, 4, 1, 4, 1, 4, 1, 4, 1, 4, 255, 255, 156, 140, 0, 0, 255,
        255, 157, 144, 0, 4, 255, 255, 171, 160, 0, 8, 255, 255, 185, 176, 1, 12, 255, 255, 171,
        160, 1, 16, 76, 77, 84, 0, 77, 83, 84, 0, 67, 83, 84, 0, 67, 68, 84, 0, 77, 68, 84, 0, 10,
        77, 83, 84, 55, 77, 68, 84, 44, 77, 52, 46, 49, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48, 10,
    ];
    pub(crate) const AmericaCordoba: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        61, 0, 0, 0, 6, 0, 0, 0, 20, 255, 255, 255, 255, 114, 156, 173, 176, 255, 255, 255, 255,
        162, 146, 143, 48, 255, 255, 255, 255, 182, 123, 82, 64, 255, 255, 255, 255, 183, 26, 201,
        176, 255, 255, 255, 255, 184, 30, 143, 64, 255, 255, 255, 255, 184, 212, 112, 48, 255, 255,
        255, 255, 186, 23, 125, 192, 255, 255, 255, 255, 186, 181, 163, 176, 255, 255, 255, 255,
        187, 248, 177, 64, 255, 255, 255, 255, 188, 150, 215, 48, 255, 255, 255, 255, 189, 217,
        228, 192, 255, 255, 255, 255, 190, 120, 10, 176, 255, 255, 255, 255, 191, 187, 24, 64, 255,
        255, 255, 255, 192, 90, 143, 176, 255, 255, 255, 255, 193, 157, 157, 64, 255, 255, 255,
        255, 194, 59, 195, 48, 255, 255, 255, 255, 195, 126, 208, 192, 255, 255, 255, 255, 196, 28,
        246, 176, 255, 255, 255, 255, 197, 96, 4, 64, 255, 255, 255, 255, 197, 254, 42, 48, 255,
        255, 255, 255, 199, 65, 55, 192, 255, 255, 255, 255, 199, 224, 175, 48, 255, 255, 255, 255,
        200, 129, 148, 64, 255, 255, 255, 255, 202, 77, 161, 176, 255, 255, 255, 255, 202, 238,
        134, 192, 255, 255, 255, 255, 206, 77, 255, 48, 255, 255, 255, 255, 206, 176, 237, 192,
        255, 255, 255, 255, 211, 41, 53, 176, 255, 255, 255, 255, 212, 67, 100, 192, 255, 255, 255,
        255, 244, 61, 8, 48, 255, 255, 255, 255, 244, 159, 246, 192, 255, 255, 255, 255, 245, 5,
        108, 48, 255, 255, 255, 255, 246, 50, 16, 64, 255, 255, 255, 255, 246, 230, 159, 176, 255,
        255, 255, 255, 248, 19, 67, 192, 255, 255, 255, 255, 248, 199, 211, 48, 255, 255, 255, 255,
        249, 244, 119, 64, 255, 255, 255, 255, 250, 211, 54, 176, 255, 255, 255, 255, 251, 195, 53,
        192, 255, 255, 255, 255, 252, 188, 83, 48, 255, 255, 255, 255, 253, 172, 82, 64, 255, 255,
        255, 255, 254, 156, 53, 48, 255, 255, 255, 255, 255, 140, 52, 64, 0, 0, 0, 0, 7, 163, 74,
        176, 0, 0, 0, 0, 8, 36, 111, 160, 0, 0, 0, 0, 35, 148, 181, 176, 0, 0, 0, 0, 36, 16, 148,
        160, 0, 0, 0, 0, 37, 55, 242, 176, 0, 0, 0, 0, 37, 240, 118, 160, 0, 0, 0, 0, 39, 33, 15,
        48, 0, 0, 0, 0, 39, 208, 88, 160, 0, 0, 0, 0, 41, 0, 255, 64, 0, 0, 0, 0, 41, 176, 58, 160,
        0, 0, 0, 0, 42, 224, 211, 48, 0, 0, 0, 0, 43, 153, 87, 32, 0, 0, 0, 0, 55, 246, 198, 176,
        0, 0, 0, 0, 56, 191, 42, 176, 0, 0, 0, 0, 71, 119, 9, 176, 0, 0, 0, 0, 71, 220, 127, 32, 0,
        0, 0, 0, 72, 250, 162, 176, 0, 0, 0, 0, 73, 188, 97, 32, 1, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 5, 4, 5, 4, 5, 4, 5, 4, 2, 4, 5, 4, 5, 3, 5, 4, 5, 4, 5, 255, 255, 195, 208, 0, 0, 255,
        255, 195, 208, 0, 4, 255, 255, 199, 192, 0, 8, 255, 255, 213, 208, 1, 12, 255, 255, 227,
        224, 1, 16, 255, 255, 213, 208, 0, 12, 76, 77, 84, 0, 67, 77, 84, 0, 45, 48, 52, 0, 45, 48,
        51, 0, 45, 48, 50, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AmericaCostaRica: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        10, 0, 0, 0, 4, 0, 0, 0, 17, 255, 255, 255, 255, 105, 135, 42, 77, 255, 255, 255, 255, 163,
        232, 22, 77, 0, 0, 0, 0, 17, 54, 73, 96, 0, 0, 0, 0, 17, 183, 110, 80, 0, 0, 0, 0, 19, 22,
        43, 96, 0, 0, 0, 0, 19, 151, 80, 80, 0, 0, 0, 0, 39, 151, 224, 96, 0, 0, 0, 0, 40, 110,
        182, 208, 0, 0, 0, 0, 41, 119, 194, 96, 0, 0, 0, 0, 41, 194, 217, 208, 1, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 255, 255, 177, 51, 0, 0, 255, 255, 177, 51, 0, 4, 255, 255, 185, 176, 1, 9, 255,
        255, 171, 160, 0, 13, 76, 77, 84, 0, 83, 74, 77, 84, 0, 67, 68, 84, 0, 67, 83, 84, 0, 10,
        67, 83, 84, 54, 10,
    ];
    pub(crate) const AmericaCreston: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        11, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 94, 4, 12, 176, 255, 255, 255, 255, 158,
        166, 58, 144, 255, 255, 255, 255, 159, 187, 7, 128, 255, 255, 255, 255, 160, 134, 28, 144,
        255, 255, 255, 255, 161, 154, 233, 128, 255, 255, 255, 255, 203, 137, 12, 144, 255, 255,
        255, 255, 207, 23, 223, 28, 255, 255, 255, 255, 207, 143, 229, 172, 255, 255, 255, 255,
        208, 129, 26, 28, 255, 255, 255, 255, 250, 248, 117, 16, 255, 255, 255, 255, 251, 232, 88,
        0, 2, 1, 2, 1, 2, 3, 2, 3, 2, 1, 2, 255, 255, 150, 238, 0, 0, 255, 255, 171, 160, 1, 4,
        255, 255, 157, 144, 0, 8, 255, 255, 171, 160, 1, 12, 76, 77, 84, 0, 77, 68, 84, 0, 77, 83,
        84, 0, 77, 87, 84, 0, 10, 77, 83, 84, 55, 10,
    ];
    pub(crate) const AmericaCuiaba: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        89, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 150, 170, 123, 148, 255, 255, 255, 255,
        184, 15, 87, 240, 255, 255, 255, 255, 184, 253, 78, 176, 255, 255, 255, 255, 185, 241, 66,
        64, 255, 255, 255, 255, 186, 222, 130, 48, 255, 255, 255, 255, 218, 56, 188, 64, 255, 255,
        255, 255, 218, 236, 8, 64, 255, 255, 255, 255, 220, 25, 239, 192, 255, 255, 255, 255, 220,
        185, 103, 48, 255, 255, 255, 255, 221, 251, 35, 64, 255, 255, 255, 255, 222, 155, 236, 48,
        255, 255, 255, 255, 223, 221, 168, 64, 255, 255, 255, 255, 224, 84, 65, 48, 255, 255, 255,
        255, 244, 152, 13, 192, 255, 255, 255, 255, 245, 5, 108, 48, 255, 255, 255, 255, 246, 192,
        114, 64, 255, 255, 255, 255, 247, 14, 44, 176, 255, 255, 255, 255, 248, 81, 58, 64, 255,
        255, 255, 255, 248, 199, 211, 48, 255, 255, 255, 255, 250, 10, 224, 192, 255, 255, 255,
        255, 250, 169, 6, 176, 255, 255, 255, 255, 251, 236, 20, 64, 255, 255, 255, 255, 252, 139,
        139, 176, 0, 0, 0, 0, 29, 201, 156, 64, 0, 0, 0, 0, 30, 120, 229, 176, 0, 0, 0, 0, 31, 160,
        67, 192, 0, 0, 0, 0, 32, 51, 221, 176, 0, 0, 0, 0, 33, 129, 119, 64, 0, 0, 0, 0, 34, 11,
        214, 176, 0, 0, 0, 0, 35, 88, 30, 192, 0, 0, 0, 0, 35, 226, 126, 48, 0, 0, 0, 0, 37, 56, 0,
        192, 0, 0, 0, 0, 37, 212, 213, 48, 0, 0, 0, 0, 39, 33, 29, 64, 0, 0, 0, 0, 39, 189, 241,
        176, 0, 0, 0, 0, 41, 0, 255, 64, 0, 0, 0, 0, 41, 148, 153, 48, 0, 0, 0, 0, 42, 234, 27,
        192, 0, 0, 0, 0, 43, 107, 64, 176, 0, 0, 0, 0, 44, 192, 195, 64, 0, 0, 0, 0, 45, 102, 210,
        48, 0, 0, 0, 0, 46, 160, 165, 64, 0, 0, 0, 0, 47, 70, 180, 48, 0, 0, 0, 0, 48, 128, 135,
        64, 0, 0, 0, 0, 49, 29, 91, 176, 0, 0, 0, 0, 50, 87, 46, 192, 0, 0, 0, 0, 51, 6, 120, 48,
        0, 0, 0, 0, 52, 56, 98, 64, 0, 0, 0, 0, 52, 248, 207, 48, 0, 0, 0, 0, 54, 32, 45, 64, 0, 0,
        0, 0, 54, 207, 118, 176, 0, 0, 0, 0, 55, 246, 212, 192, 0, 0, 0, 0, 56, 184, 147, 48, 0, 0,
        0, 0, 57, 223, 241, 64, 0, 0, 0, 0, 58, 143, 58, 176, 0, 0, 0, 0, 59, 201, 13, 192, 0, 0,
        0, 0, 60, 111, 28, 176, 0, 0, 0, 0, 61, 196, 159, 64, 0, 0, 0, 0, 62, 78, 254, 176, 0, 0,
        0, 0, 65, 135, 6, 64, 0, 0, 0, 0, 66, 23, 253, 48, 0, 0, 0, 0, 67, 81, 208, 64, 0, 0, 0, 0,
        67, 247, 223, 48, 0, 0, 0, 0, 69, 77, 97, 192, 0, 0, 0, 0, 69, 224, 251, 176, 0, 0, 0, 0,
        71, 17, 148, 64, 0, 0, 0, 0, 71, 183, 163, 48, 0, 0, 0, 0, 72, 250, 176, 192, 0, 0, 0, 0,
        73, 151, 133, 48, 0, 0, 0, 0, 74, 218, 146, 192, 0, 0, 0, 0, 75, 128, 161, 176, 0, 0, 0, 0,
        76, 186, 116, 192, 0, 0, 0, 0, 77, 96, 131, 176, 0, 0, 0, 0, 78, 154, 86, 192, 0, 0, 0, 0,
        79, 73, 160, 48, 0, 0, 0, 0, 80, 131, 115, 64, 0, 0, 0, 0, 81, 32, 71, 176, 0, 0, 0, 0, 82,
        99, 85, 64, 0, 0, 0, 0, 83, 0, 41, 176, 0, 0, 0, 0, 84, 67, 55, 64, 0, 0, 0, 0, 84, 233,
        70, 48, 0, 0, 0, 0, 86, 35, 25, 64, 0, 0, 0, 0, 86, 201, 40, 48, 0, 0, 0, 0, 88, 2, 251,
        64, 0, 0, 0, 0, 88, 169, 10, 48, 0, 0, 0, 0, 89, 226, 221, 64, 0, 0, 0, 0, 90, 136, 236,
        48, 0, 0, 0, 0, 91, 222, 110, 192, 0, 0, 0, 0, 92, 104, 206, 48, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 255, 255, 203, 108, 0, 0, 255,
        255, 213, 208, 1, 4, 255, 255, 199, 192, 0, 8, 76, 77, 84, 0, 45, 48, 51, 0, 45, 48, 52, 0,
        10, 60, 45, 48, 52, 62, 52, 10,
    ];
    pub(crate) const AmericaDanmarkshavn: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        34, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 155, 128, 73, 0, 0, 0, 0, 0, 19, 77, 124,
        80, 0, 0, 0, 0, 20, 51, 250, 144, 0, 0, 0, 0, 21, 35, 235, 144, 0, 0, 0, 0, 22, 19, 220,
        144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23, 243, 190, 144, 0, 0, 0, 0, 24, 227, 175,
        144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 188,
        189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140,
        144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92,
        99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16,
        0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0,
        0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0,
        0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0,
        0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0,
        0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 48, 231, 78, 48, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 3, 255, 255, 238, 128, 0,
        0, 255, 255, 213, 208, 0, 4, 255, 255, 227, 224, 1, 8, 0, 0, 0, 0, 0, 12, 76, 77, 84, 0,
        45, 48, 51, 0, 45, 48, 50, 0, 71, 77, 84, 0, 10, 71, 77, 84, 48, 10,
    ];
    pub(crate) const AmericaDawson: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        93, 0, 0, 0, 9, 0, 0, 0, 37, 255, 255, 255, 255, 125, 134, 142, 180, 255, 255, 255, 255,
        158, 184, 203, 176, 255, 255, 255, 255, 159, 187, 35, 160, 255, 255, 255, 255, 160, 208,
        12, 176, 255, 255, 255, 255, 161, 162, 210, 128, 255, 255, 255, 255, 203, 137, 40, 176,
        255, 255, 255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 97, 52, 32, 255, 255, 255,
        255, 247, 47, 118, 144, 255, 255, 255, 255, 248, 40, 162, 16, 0, 0, 0, 0, 7, 48, 236, 144,
        0, 0, 0, 0, 19, 105, 114, 32, 0, 0, 0, 0, 20, 89, 85, 16, 0, 0, 0, 0, 21, 73, 84, 32, 0, 0,
        0, 0, 22, 57, 55, 16, 0, 0, 0, 0, 23, 41, 54, 32, 0, 0, 0, 0, 24, 34, 83, 144, 0, 0, 0, 0,
        25, 9, 24, 32, 0, 0, 0, 0, 26, 2, 53, 144, 0, 0, 0, 0, 26, 242, 52, 160, 0, 0, 0, 0, 27,
        226, 23, 144, 0, 0, 0, 0, 28, 210, 22, 160, 0, 0, 0, 0, 29, 193, 249, 144, 0, 0, 0, 0, 30,
        177, 248, 160, 0, 0, 0, 0, 31, 161, 219, 144, 0, 0, 0, 0, 32, 118, 43, 32, 0, 0, 0, 0, 33,
        129, 189, 144, 0, 0, 0, 0, 34, 86, 13, 32, 0, 0, 0, 0, 35, 106, 218, 16, 0, 0, 0, 0, 36,
        53, 239, 32, 0, 0, 0, 0, 37, 74, 188, 16, 0, 0, 0, 0, 38, 21, 209, 32, 0, 0, 0, 0, 39, 42,
        158, 16, 0, 0, 0, 0, 39, 254, 237, 160, 0, 0, 0, 0, 41, 10, 128, 16, 0, 0, 0, 0, 41, 222,
        207, 160, 0, 0, 0, 0, 42, 234, 98, 16, 0, 0, 0, 0, 43, 190, 177, 160, 0, 0, 0, 0, 44, 211,
        126, 144, 0, 0, 0, 0, 45, 158, 147, 160, 0, 0, 0, 0, 46, 179, 96, 144, 0, 0, 0, 0, 47, 126,
        117, 160, 0, 0, 0, 0, 48, 147, 66, 144, 0, 0, 0, 0, 49, 103, 146, 32, 0, 0, 0, 0, 50, 115,
        36, 144, 0, 0, 0, 0, 51, 71, 116, 32, 0, 0, 0, 0, 52, 83, 6, 144, 0, 0, 0, 0, 53, 39, 86,
        32, 0, 0, 0, 0, 54, 50, 232, 144, 0, 0, 0, 0, 55, 7, 56, 32, 0, 0, 0, 0, 56, 28, 5, 16, 0,
        0, 0, 0, 56, 231, 26, 32, 0, 0, 0, 0, 57, 251, 231, 16, 0, 0, 0, 0, 58, 198, 252, 32, 0, 0,
        0, 0, 59, 219, 201, 16, 0, 0, 0, 0, 60, 176, 24, 160, 0, 0, 0, 0, 61, 187, 171, 16, 0, 0,
        0, 0, 62, 143, 250, 160, 0, 0, 0, 0, 63, 155, 141, 16, 0, 0, 0, 0, 64, 111, 220, 160, 0, 0,
        0, 0, 65, 132, 169, 144, 0, 0, 0, 0, 66, 79, 190, 160, 0, 0, 0, 0, 67, 100, 139, 144, 0, 0,
        0, 0, 68, 47, 160, 160, 0, 0, 0, 0, 69, 68, 109, 144, 0, 0, 0, 0, 69, 243, 211, 32, 0, 0,
        0, 0, 71, 45, 138, 16, 0, 0, 0, 0, 71, 211, 181, 32, 0, 0, 0, 0, 73, 13, 108, 16, 0, 0, 0,
        0, 73, 179, 151, 32, 0, 0, 0, 0, 74, 237, 78, 16, 0, 0, 0, 0, 75, 156, 179, 160, 0, 0, 0,
        0, 76, 214, 106, 144, 0, 0, 0, 0, 77, 124, 149, 160, 0, 0, 0, 0, 78, 182, 76, 144, 0, 0, 0,
        0, 79, 92, 119, 160, 0, 0, 0, 0, 80, 150, 46, 144, 0, 0, 0, 0, 81, 60, 89, 160, 0, 0, 0, 0,
        82, 118, 16, 144, 0, 0, 0, 0, 83, 28, 59, 160, 0, 0, 0, 0, 84, 85, 242, 144, 0, 0, 0, 0,
        84, 252, 29, 160, 0, 0, 0, 0, 86, 53, 212, 144, 0, 0, 0, 0, 86, 229, 58, 32, 0, 0, 0, 0,
        88, 30, 241, 16, 0, 0, 0, 0, 88, 197, 28, 32, 0, 0, 0, 0, 89, 254, 211, 16, 0, 0, 0, 0, 90,
        164, 254, 32, 0, 0, 0, 0, 91, 222, 181, 16, 0, 0, 0, 0, 92, 132, 224, 32, 0, 0, 0, 0, 93,
        190, 151, 16, 0, 0, 0, 0, 94, 100, 194, 32, 0, 0, 0, 0, 95, 158, 92, 240, 2, 1, 2, 1, 2, 3,
        4, 2, 5, 2, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7,
        6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7,
        6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 8, 255, 255,
        125, 76, 0, 0, 255, 255, 143, 128, 1, 4, 255, 255, 129, 112, 0, 8, 255, 255, 143, 128, 1,
        12, 255, 255, 143, 128, 1, 16, 255, 255, 157, 144, 1, 20, 255, 255, 143, 128, 0, 25, 255,
        255, 157, 144, 1, 29, 255, 255, 157, 144, 0, 33, 76, 77, 84, 0, 89, 68, 84, 0, 89, 83, 84,
        0, 89, 87, 84, 0, 89, 80, 84, 0, 89, 68, 68, 84, 0, 80, 83, 84, 0, 80, 68, 84, 0, 77, 83,
        84, 0, 10, 77, 83, 84, 55, 10,
    ];
    pub(crate) const AmericaDawsonCreek: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        58, 0, 0, 0, 6, 0, 0, 0, 24, 255, 255, 255, 255, 94, 61, 116, 56, 255, 255, 255, 255, 158,
        184, 189, 160, 255, 255, 255, 255, 159, 187, 21, 144, 255, 255, 255, 255, 203, 137, 26,
        160, 255, 255, 255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 97, 38, 16, 255, 255,
        255, 255, 213, 85, 241, 32, 255, 255, 255, 255, 214, 32, 234, 16, 255, 255, 255, 255, 215,
        53, 211, 32, 255, 255, 255, 255, 216, 0, 204, 16, 255, 255, 255, 255, 217, 21, 181, 32,
        255, 255, 255, 255, 217, 224, 174, 16, 255, 255, 255, 255, 218, 254, 209, 160, 255, 255,
        255, 255, 219, 192, 144, 16, 255, 255, 255, 255, 220, 222, 179, 160, 255, 255, 255, 255,
        221, 169, 172, 144, 255, 255, 255, 255, 222, 190, 149, 160, 255, 255, 255, 255, 223, 137,
        142, 144, 255, 255, 255, 255, 224, 158, 119, 160, 255, 255, 255, 255, 225, 105, 112, 144,
        255, 255, 255, 255, 226, 126, 89, 160, 255, 255, 255, 255, 227, 73, 82, 144, 255, 255, 255,
        255, 228, 94, 59, 160, 255, 255, 255, 255, 229, 41, 52, 144, 255, 255, 255, 255, 230, 71,
        88, 32, 255, 255, 255, 255, 231, 18, 81, 16, 255, 255, 255, 255, 232, 39, 58, 32, 255, 255,
        255, 255, 232, 242, 51, 16, 255, 255, 255, 255, 234, 7, 28, 32, 255, 255, 255, 255, 234,
        210, 21, 16, 255, 255, 255, 255, 235, 230, 254, 32, 255, 255, 255, 255, 236, 177, 247, 16,
        255, 255, 255, 255, 237, 198, 224, 32, 255, 255, 255, 255, 238, 145, 217, 16, 255, 255,
        255, 255, 239, 175, 252, 160, 255, 255, 255, 255, 240, 113, 187, 16, 255, 255, 255, 255,
        241, 143, 222, 160, 255, 255, 255, 255, 242, 127, 193, 144, 255, 255, 255, 255, 243, 111,
        192, 160, 255, 255, 255, 255, 244, 95, 163, 144, 255, 255, 255, 255, 245, 79, 162, 160,
        255, 255, 255, 255, 246, 63, 133, 144, 255, 255, 255, 255, 247, 47, 132, 160, 255, 255,
        255, 255, 248, 40, 162, 16, 255, 255, 255, 255, 249, 15, 102, 160, 255, 255, 255, 255, 250,
        8, 132, 16, 255, 255, 255, 255, 250, 248, 131, 32, 255, 255, 255, 255, 251, 232, 102, 16,
        255, 255, 255, 255, 252, 216, 101, 32, 255, 255, 255, 255, 253, 200, 72, 16, 255, 255, 255,
        255, 254, 184, 71, 32, 255, 255, 255, 255, 255, 168, 42, 16, 0, 0, 0, 0, 0, 152, 41, 32, 0,
        0, 0, 0, 1, 136, 12, 16, 0, 0, 0, 0, 2, 120, 11, 32, 0, 0, 0, 0, 3, 113, 40, 144, 0, 0, 0,
        0, 4, 97, 39, 160, 0, 0, 0, 0, 5, 1, 240, 144, 2, 1, 2, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 5, 255, 255, 143, 72, 0, 0, 255, 255, 157, 144, 1, 4,
        255, 255, 143, 128, 0, 8, 255, 255, 157, 144, 1, 12, 255, 255, 157, 144, 1, 16, 255, 255,
        157, 144, 0, 20, 76, 77, 84, 0, 80, 68, 84, 0, 80, 83, 84, 0, 80, 87, 84, 0, 80, 80, 84, 0,
        77, 83, 84, 0, 10, 77, 83, 84, 55, 10,
    ];
    pub(crate) const AmericaDenver: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        97, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 94, 4, 12, 176, 255, 255, 255, 255, 158,
        166, 58, 144, 255, 255, 255, 255, 159, 187, 7, 128, 255, 255, 255, 255, 160, 134, 28, 144,
        255, 255, 255, 255, 161, 154, 233, 128, 255, 255, 255, 255, 162, 101, 254, 144, 255, 255,
        255, 255, 163, 132, 6, 0, 255, 255, 255, 255, 164, 69, 224, 144, 255, 255, 255, 255, 164,
        143, 166, 128, 255, 255, 255, 255, 203, 137, 12, 144, 255, 255, 255, 255, 210, 35, 244,
        112, 255, 255, 255, 255, 210, 97, 24, 0, 255, 255, 255, 255, 247, 47, 118, 144, 255, 255,
        255, 255, 248, 40, 148, 0, 255, 255, 255, 255, 249, 15, 88, 144, 255, 255, 255, 255, 250,
        8, 118, 0, 255, 255, 255, 255, 250, 248, 117, 16, 255, 255, 255, 255, 251, 232, 88, 0, 255,
        255, 255, 255, 252, 216, 87, 16, 255, 255, 255, 255, 253, 200, 58, 0, 255, 255, 255, 255,
        254, 184, 57, 16, 255, 255, 255, 255, 255, 168, 28, 0, 0, 0, 0, 0, 0, 152, 27, 16, 0, 0, 0,
        0, 1, 135, 254, 0, 0, 0, 0, 0, 2, 119, 253, 16, 0, 0, 0, 0, 3, 113, 26, 128, 0, 0, 0, 0, 4,
        97, 25, 144, 0, 0, 0, 0, 5, 80, 252, 128, 0, 0, 0, 0, 6, 64, 251, 144, 0, 0, 0, 0, 7, 48,
        222, 128, 0, 0, 0, 0, 7, 141, 53, 144, 0, 0, 0, 0, 9, 16, 192, 128, 0, 0, 0, 0, 9, 173,
        177, 16, 0, 0, 0, 0, 10, 240, 162, 128, 0, 0, 0, 0, 11, 224, 161, 144, 0, 0, 0, 0, 12, 217,
        191, 0, 0, 0, 0, 0, 13, 192, 131, 144, 0, 0, 0, 0, 14, 185, 161, 0, 0, 0, 0, 0, 15, 169,
        160, 16, 0, 0, 0, 0, 16, 153, 131, 0, 0, 0, 0, 0, 17, 137, 130, 16, 0, 0, 0, 0, 18, 121,
        101, 0, 0, 0, 0, 0, 19, 105, 100, 16, 0, 0, 0, 0, 20, 89, 71, 0, 0, 0, 0, 0, 21, 73, 70,
        16, 0, 0, 0, 0, 22, 57, 41, 0, 0, 0, 0, 0, 23, 41, 40, 16, 0, 0, 0, 0, 24, 34, 69, 128, 0,
        0, 0, 0, 25, 9, 10, 16, 0, 0, 0, 0, 26, 2, 39, 128, 0, 0, 0, 0, 26, 242, 38, 144, 0, 0, 0,
        0, 27, 226, 9, 128, 0, 0, 0, 0, 28, 210, 8, 144, 0, 0, 0, 0, 29, 193, 235, 128, 0, 0, 0, 0,
        30, 177, 234, 144, 0, 0, 0, 0, 31, 161, 205, 128, 0, 0, 0, 0, 32, 118, 29, 16, 0, 0, 0, 0,
        33, 129, 175, 128, 0, 0, 0, 0, 34, 85, 255, 16, 0, 0, 0, 0, 35, 106, 204, 0, 0, 0, 0, 0,
        36, 53, 225, 16, 0, 0, 0, 0, 37, 74, 174, 0, 0, 0, 0, 0, 38, 21, 195, 16, 0, 0, 0, 0, 39,
        42, 144, 0, 0, 0, 0, 0, 39, 254, 223, 144, 0, 0, 0, 0, 41, 10, 114, 0, 0, 0, 0, 0, 41, 222,
        193, 144, 0, 0, 0, 0, 42, 234, 84, 0, 0, 0, 0, 0, 43, 190, 163, 144, 0, 0, 0, 0, 44, 211,
        112, 128, 0, 0, 0, 0, 45, 158, 133, 144, 0, 0, 0, 0, 46, 179, 82, 128, 0, 0, 0, 0, 47, 126,
        103, 144, 0, 0, 0, 0, 48, 147, 52, 128, 0, 0, 0, 0, 49, 103, 132, 16, 0, 0, 0, 0, 50, 115,
        22, 128, 0, 0, 0, 0, 51, 71, 102, 16, 0, 0, 0, 0, 52, 82, 248, 128, 0, 0, 0, 0, 53, 39, 72,
        16, 0, 0, 0, 0, 54, 50, 218, 128, 0, 0, 0, 0, 55, 7, 42, 16, 0, 0, 0, 0, 56, 27, 247, 0, 0,
        0, 0, 0, 56, 231, 12, 16, 0, 0, 0, 0, 57, 251, 217, 0, 0, 0, 0, 0, 58, 198, 238, 16, 0, 0,
        0, 0, 59, 219, 187, 0, 0, 0, 0, 0, 60, 176, 10, 144, 0, 0, 0, 0, 61, 187, 157, 0, 0, 0, 0,
        0, 62, 143, 236, 144, 0, 0, 0, 0, 63, 155, 127, 0, 0, 0, 0, 0, 64, 111, 206, 144, 0, 0, 0,
        0, 65, 132, 155, 128, 0, 0, 0, 0, 66, 79, 176, 144, 0, 0, 0, 0, 67, 100, 125, 128, 0, 0, 0,
        0, 68, 47, 146, 144, 0, 0, 0, 0, 69, 68, 95, 128, 0, 0, 0, 0, 69, 243, 197, 16, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 255, 255, 157, 148, 0, 0, 255, 255, 171, 160, 1, 4, 255, 255, 157, 144, 0, 8, 255,
        255, 171, 160, 1, 12, 255, 255, 171, 160, 1, 16, 76, 77, 84, 0, 77, 68, 84, 0, 77, 83, 84,
        0, 77, 87, 84, 0, 77, 80, 84, 0, 10, 77, 83, 84, 55, 77, 68, 84, 44, 77, 51, 46, 50, 46,
        48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaDetroit: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        80, 0, 0, 0, 6, 0, 0, 0, 24, 255, 255, 255, 255, 133, 189, 34, 91, 255, 255, 255, 255, 153,
        60, 148, 0, 255, 255, 255, 255, 203, 136, 240, 112, 255, 255, 255, 255, 210, 35, 244, 112,
        255, 255, 255, 255, 210, 96, 251, 224, 255, 255, 255, 255, 215, 53, 168, 240, 255, 255,
        255, 255, 216, 0, 161, 224, 255, 255, 255, 255, 251, 51, 144, 140, 255, 255, 255, 255, 251,
        232, 59, 224, 255, 255, 255, 255, 252, 216, 58, 240, 255, 255, 255, 255, 253, 200, 29, 224,
        0, 0, 0, 0, 6, 64, 223, 112, 0, 0, 0, 0, 7, 48, 194, 96, 0, 0, 0, 0, 7, 141, 25, 112, 0, 0,
        0, 0, 9, 16, 164, 96, 0, 0, 0, 0, 10, 0, 163, 112, 0, 0, 0, 0, 10, 240, 134, 96, 0, 0, 0,
        0, 11, 224, 133, 112, 0, 0, 0, 0, 12, 217, 162, 224, 0, 0, 0, 0, 13, 192, 103, 112, 0, 0,
        0, 0, 14, 185, 132, 224, 0, 0, 0, 0, 15, 169, 131, 240, 0, 0, 0, 0, 16, 153, 102, 224, 0,
        0, 0, 0, 17, 137, 101, 240, 0, 0, 0, 0, 18, 121, 72, 224, 0, 0, 0, 0, 19, 105, 71, 240, 0,
        0, 0, 0, 20, 89, 42, 224, 0, 0, 0, 0, 21, 73, 41, 240, 0, 0, 0, 0, 22, 57, 12, 224, 0, 0,
        0, 0, 23, 41, 11, 240, 0, 0, 0, 0, 24, 34, 41, 96, 0, 0, 0, 0, 25, 8, 237, 240, 0, 0, 0, 0,
        26, 2, 11, 96, 0, 0, 0, 0, 26, 242, 10, 112, 0, 0, 0, 0, 27, 225, 237, 96, 0, 0, 0, 0, 28,
        209, 236, 112, 0, 0, 0, 0, 29, 193, 207, 96, 0, 0, 0, 0, 30, 177, 206, 112, 0, 0, 0, 0, 31,
        161, 177, 96, 0, 0, 0, 0, 32, 118, 0, 240, 0, 0, 0, 0, 33, 129, 147, 96, 0, 0, 0, 0, 34,
        85, 226, 240, 0, 0, 0, 0, 35, 106, 175, 224, 0, 0, 0, 0, 36, 53, 196, 240, 0, 0, 0, 0, 37,
        74, 145, 224, 0, 0, 0, 0, 38, 21, 166, 240, 0, 0, 0, 0, 39, 42, 115, 224, 0, 0, 0, 0, 39,
        254, 195, 112, 0, 0, 0, 0, 41, 10, 85, 224, 0, 0, 0, 0, 41, 222, 165, 112, 0, 0, 0, 0, 42,
        234, 55, 224, 0, 0, 0, 0, 43, 190, 135, 112, 0, 0, 0, 0, 44, 211, 84, 96, 0, 0, 0, 0, 45,
        158, 105, 112, 0, 0, 0, 0, 46, 179, 54, 96, 0, 0, 0, 0, 47, 126, 75, 112, 0, 0, 0, 0, 48,
        147, 24, 96, 0, 0, 0, 0, 49, 103, 103, 240, 0, 0, 0, 0, 50, 114, 250, 96, 0, 0, 0, 0, 51,
        71, 73, 240, 0, 0, 0, 0, 52, 82, 220, 96, 0, 0, 0, 0, 53, 39, 43, 240, 0, 0, 0, 0, 54, 50,
        190, 96, 0, 0, 0, 0, 55, 7, 13, 240, 0, 0, 0, 0, 56, 27, 218, 224, 0, 0, 0, 0, 56, 230,
        239, 240, 0, 0, 0, 0, 57, 251, 188, 224, 0, 0, 0, 0, 58, 198, 209, 240, 0, 0, 0, 0, 59,
        219, 158, 224, 0, 0, 0, 0, 60, 175, 238, 112, 0, 0, 0, 0, 61, 187, 128, 224, 0, 0, 0, 0,
        62, 143, 208, 112, 0, 0, 0, 0, 63, 155, 98, 224, 0, 0, 0, 0, 64, 111, 178, 112, 0, 0, 0, 0,
        65, 132, 127, 96, 0, 0, 0, 0, 66, 79, 148, 112, 0, 0, 0, 0, 67, 100, 97, 96, 0, 0, 0, 0,
        68, 47, 118, 112, 0, 0, 0, 0, 69, 68, 67, 96, 0, 0, 0, 0, 69, 243, 168, 240, 1, 2, 3, 4, 2,
        5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2,
        5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2,
        5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 255, 255, 178, 37, 0, 0, 255, 255, 171, 160,
        0, 4, 255, 255, 185, 176, 0, 8, 255, 255, 199, 192, 1, 12, 255, 255, 199, 192, 1, 16, 255,
        255, 199, 192, 1, 20, 76, 77, 84, 0, 67, 83, 84, 0, 69, 83, 84, 0, 69, 87, 84, 0, 69, 80,
        84, 0, 69, 68, 84, 0, 10, 69, 83, 84, 53, 69, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77,
        49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaEdmonton: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        89, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 136, 222, 206, 224, 255, 255, 255, 255,
        158, 184, 175, 144, 255, 255, 255, 255, 159, 187, 7, 128, 255, 255, 255, 255, 160, 152,
        145, 144, 255, 255, 255, 255, 160, 210, 133, 128, 255, 255, 255, 255, 162, 138, 232, 144,
        255, 255, 255, 255, 163, 132, 6, 0, 255, 255, 255, 255, 164, 106, 202, 144, 255, 255, 255,
        255, 165, 53, 195, 128, 255, 255, 255, 255, 166, 83, 231, 16, 255, 255, 255, 255, 167, 21,
        165, 128, 255, 255, 255, 255, 168, 51, 201, 16, 255, 255, 255, 255, 168, 254, 194, 0, 255,
        255, 255, 255, 203, 137, 12, 144, 255, 255, 255, 255, 210, 35, 244, 112, 255, 255, 255,
        255, 210, 97, 24, 0, 255, 255, 255, 255, 213, 85, 227, 16, 255, 255, 255, 255, 214, 32,
        220, 0, 0, 0, 0, 0, 4, 97, 25, 144, 0, 0, 0, 0, 5, 80, 252, 128, 0, 0, 0, 0, 6, 64, 251,
        144, 0, 0, 0, 0, 7, 48, 222, 128, 0, 0, 0, 0, 8, 32, 221, 144, 0, 0, 0, 0, 9, 16, 192, 128,
        0, 0, 0, 0, 10, 0, 191, 144, 0, 0, 0, 0, 10, 240, 162, 128, 0, 0, 0, 0, 11, 224, 161, 144,
        0, 0, 0, 0, 12, 217, 191, 0, 0, 0, 0, 0, 13, 192, 131, 144, 0, 0, 0, 0, 14, 185, 161, 0, 0,
        0, 0, 0, 15, 169, 160, 16, 0, 0, 0, 0, 16, 153, 131, 0, 0, 0, 0, 0, 17, 137, 130, 16, 0, 0,
        0, 0, 18, 121, 101, 0, 0, 0, 0, 0, 19, 105, 100, 16, 0, 0, 0, 0, 20, 89, 71, 0, 0, 0, 0, 0,
        21, 73, 70, 16, 0, 0, 0, 0, 22, 57, 41, 0, 0, 0, 0, 0, 23, 41, 40, 16, 0, 0, 0, 0, 24, 34,
        69, 128, 0, 0, 0, 0, 25, 9, 10, 16, 0, 0, 0, 0, 26, 2, 39, 128, 0, 0, 0, 0, 26, 242, 38,
        144, 0, 0, 0, 0, 27, 226, 9, 128, 0, 0, 0, 0, 28, 210, 8, 144, 0, 0, 0, 0, 29, 193, 235,
        128, 0, 0, 0, 0, 30, 177, 234, 144, 0, 0, 0, 0, 31, 161, 205, 128, 0, 0, 0, 0, 32, 118, 29,
        16, 0, 0, 0, 0, 33, 129, 175, 128, 0, 0, 0, 0, 34, 85, 255, 16, 0, 0, 0, 0, 35, 106, 204,
        0, 0, 0, 0, 0, 36, 53, 225, 16, 0, 0, 0, 0, 37, 74, 174, 0, 0, 0, 0, 0, 38, 21, 195, 16, 0,
        0, 0, 0, 39, 42, 144, 0, 0, 0, 0, 0, 39, 254, 223, 144, 0, 0, 0, 0, 41, 10, 114, 0, 0, 0,
        0, 0, 41, 222, 193, 144, 0, 0, 0, 0, 42, 234, 84, 0, 0, 0, 0, 0, 43, 190, 163, 144, 0, 0,
        0, 0, 44, 211, 112, 128, 0, 0, 0, 0, 45, 158, 133, 144, 0, 0, 0, 0, 46, 179, 82, 128, 0, 0,
        0, 0, 47, 126, 103, 144, 0, 0, 0, 0, 48, 147, 52, 128, 0, 0, 0, 0, 49, 103, 132, 16, 0, 0,
        0, 0, 50, 115, 22, 128, 0, 0, 0, 0, 51, 71, 102, 16, 0, 0, 0, 0, 52, 82, 248, 128, 0, 0, 0,
        0, 53, 39, 72, 16, 0, 0, 0, 0, 54, 50, 218, 128, 0, 0, 0, 0, 55, 7, 42, 16, 0, 0, 0, 0, 56,
        27, 247, 0, 0, 0, 0, 0, 56, 231, 12, 16, 0, 0, 0, 0, 57, 251, 217, 0, 0, 0, 0, 0, 58, 198,
        238, 16, 0, 0, 0, 0, 59, 219, 187, 0, 0, 0, 0, 0, 60, 176, 10, 144, 0, 0, 0, 0, 61, 187,
        157, 0, 0, 0, 0, 0, 62, 143, 236, 144, 0, 0, 0, 0, 63, 155, 127, 0, 0, 0, 0, 0, 64, 111,
        206, 144, 0, 0, 0, 0, 65, 132, 155, 128, 0, 0, 0, 0, 66, 79, 176, 144, 0, 0, 0, 0, 67, 100,
        125, 128, 0, 0, 0, 0, 68, 47, 146, 144, 0, 0, 0, 0, 69, 68, 95, 128, 0, 0, 0, 0, 69, 243,
        197, 16, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 255, 255, 149, 160, 0, 0, 255, 255, 171, 160, 1, 4, 255, 255, 157, 144, 0, 8, 255,
        255, 171, 160, 1, 12, 255, 255, 171, 160, 1, 16, 76, 77, 84, 0, 77, 68, 84, 0, 77, 83, 84,
        0, 77, 87, 84, 0, 77, 80, 84, 0, 10, 77, 83, 84, 55, 77, 68, 84, 44, 77, 51, 46, 50, 46,
        48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaEirunepe: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        33, 0, 0, 0, 4, 0, 0, 0, 12, 255, 255, 255, 255, 150, 170, 136, 128, 255, 255, 255, 255,
        184, 15, 102, 0, 255, 255, 255, 255, 184, 253, 92, 192, 255, 255, 255, 255, 185, 241, 80,
        80, 255, 255, 255, 255, 186, 222, 144, 64, 255, 255, 255, 255, 218, 56, 202, 80, 255, 255,
        255, 255, 218, 236, 22, 80, 255, 255, 255, 255, 220, 25, 253, 208, 255, 255, 255, 255, 220,
        185, 117, 64, 255, 255, 255, 255, 221, 251, 49, 80, 255, 255, 255, 255, 222, 155, 250, 64,
        255, 255, 255, 255, 223, 221, 182, 80, 255, 255, 255, 255, 224, 84, 79, 64, 255, 255, 255,
        255, 244, 152, 27, 208, 255, 255, 255, 255, 245, 5, 122, 64, 255, 255, 255, 255, 246, 192,
        128, 80, 255, 255, 255, 255, 247, 14, 58, 192, 255, 255, 255, 255, 248, 81, 72, 80, 255,
        255, 255, 255, 248, 199, 225, 64, 255, 255, 255, 255, 250, 10, 238, 208, 255, 255, 255,
        255, 250, 169, 20, 192, 255, 255, 255, 255, 251, 236, 34, 80, 255, 255, 255, 255, 252, 139,
        153, 192, 0, 0, 0, 0, 29, 201, 170, 80, 0, 0, 0, 0, 30, 120, 243, 192, 0, 0, 0, 0, 31, 160,
        81, 208, 0, 0, 0, 0, 32, 51, 235, 192, 0, 0, 0, 0, 33, 129, 133, 80, 0, 0, 0, 0, 34, 11,
        228, 192, 0, 0, 0, 0, 44, 192, 209, 80, 0, 0, 0, 0, 45, 102, 224, 64, 0, 0, 0, 0, 72, 96,
        127, 80, 0, 0, 0, 0, 82, 127, 4, 192, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 2, 255, 255, 190, 128, 0, 0, 255, 255, 199, 192,
        1, 4, 255, 255, 185, 176, 0, 8, 255, 255, 199, 192, 0, 4, 76, 77, 84, 0, 45, 48, 52, 0, 45,
        48, 53, 0, 10, 60, 45, 48, 53, 62, 53, 10,
    ];
    pub(crate) const AmericaElSalvador: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        5, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 163, 213, 166, 32, 0, 0, 0, 0, 32, 154,
        220, 224, 0, 0, 0, 0, 33, 92, 155, 80, 0, 0, 0, 0, 34, 122, 190, 224, 0, 0, 0, 0, 35, 60,
        125, 80, 2, 1, 2, 1, 2, 255, 255, 172, 96, 0, 0, 255, 255, 185, 176, 1, 4, 255, 255, 171,
        160, 0, 8, 76, 77, 84, 0, 67, 68, 84, 0, 67, 83, 84, 0, 10, 67, 83, 84, 54, 10,
    ];
    pub(crate) const AmericaEnsenada: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        94, 0, 0, 0, 6, 0, 0, 0, 24, 255, 255, 255, 255, 165, 182, 246, 128, 255, 255, 255, 255,
        169, 121, 79, 112, 255, 255, 255, 255, 175, 242, 124, 240, 255, 255, 255, 255, 182, 102,
        100, 112, 255, 255, 255, 255, 183, 27, 16, 0, 255, 255, 255, 255, 184, 10, 242, 240, 255,
        255, 255, 255, 203, 234, 141, 128, 255, 255, 255, 255, 210, 35, 244, 112, 255, 255, 255,
        255, 210, 153, 186, 112, 255, 255, 255, 255, 215, 27, 89, 0, 255, 255, 255, 255, 216, 145,
        180, 240, 255, 255, 255, 255, 226, 126, 75, 144, 255, 255, 255, 255, 227, 73, 82, 144, 255,
        255, 255, 255, 228, 94, 45, 144, 255, 255, 255, 255, 229, 41, 52, 144, 255, 255, 255, 255,
        230, 71, 74, 16, 255, 255, 255, 255, 231, 18, 81, 16, 255, 255, 255, 255, 232, 39, 44, 16,
        255, 255, 255, 255, 232, 242, 51, 16, 255, 255, 255, 255, 234, 7, 14, 16, 255, 255, 255,
        255, 234, 210, 21, 16, 255, 255, 255, 255, 235, 230, 240, 16, 255, 255, 255, 255, 236, 177,
        247, 16, 255, 255, 255, 255, 237, 198, 210, 16, 255, 255, 255, 255, 238, 145, 217, 16, 0,
        0, 0, 0, 11, 224, 175, 160, 0, 0, 0, 0, 12, 217, 205, 16, 0, 0, 0, 0, 13, 192, 145, 160, 0,
        0, 0, 0, 14, 185, 175, 16, 0, 0, 0, 0, 15, 169, 174, 32, 0, 0, 0, 0, 16, 153, 145, 16, 0,
        0, 0, 0, 17, 137, 144, 32, 0, 0, 0, 0, 18, 121, 115, 16, 0, 0, 0, 0, 19, 105, 114, 32, 0,
        0, 0, 0, 20, 89, 85, 16, 0, 0, 0, 0, 21, 73, 84, 32, 0, 0, 0, 0, 22, 57, 55, 16, 0, 0, 0,
        0, 23, 41, 54, 32, 0, 0, 0, 0, 24, 34, 83, 144, 0, 0, 0, 0, 25, 9, 24, 32, 0, 0, 0, 0, 26,
        2, 53, 144, 0, 0, 0, 0, 26, 242, 52, 160, 0, 0, 0, 0, 27, 226, 23, 144, 0, 0, 0, 0, 28,
        210, 22, 160, 0, 0, 0, 0, 29, 193, 249, 144, 0, 0, 0, 0, 30, 177, 248, 160, 0, 0, 0, 0, 31,
        161, 219, 144, 0, 0, 0, 0, 32, 118, 43, 32, 0, 0, 0, 0, 33, 129, 189, 144, 0, 0, 0, 0, 34,
        86, 13, 32, 0, 0, 0, 0, 35, 106, 218, 16, 0, 0, 0, 0, 36, 53, 239, 32, 0, 0, 0, 0, 37, 74,
        188, 16, 0, 0, 0, 0, 38, 21, 209, 32, 0, 0, 0, 0, 39, 42, 158, 16, 0, 0, 0, 0, 39, 254,
        237, 160, 0, 0, 0, 0, 41, 10, 128, 16, 0, 0, 0, 0, 41, 222, 207, 160, 0, 0, 0, 0, 42, 234,
        98, 16, 0, 0, 0, 0, 43, 190, 177, 160, 0, 0, 0, 0, 44, 211, 126, 144, 0, 0, 0, 0, 45, 158,
        147, 160, 0, 0, 0, 0, 46, 179, 96, 144, 0, 0, 0, 0, 47, 126, 117, 160, 0, 0, 0, 0, 48, 147,
        66, 144, 0, 0, 0, 0, 49, 103, 146, 32, 0, 0, 0, 0, 50, 115, 36, 144, 0, 0, 0, 0, 51, 71,
        116, 32, 0, 0, 0, 0, 52, 83, 6, 144, 0, 0, 0, 0, 53, 39, 86, 32, 0, 0, 0, 0, 54, 50, 232,
        144, 0, 0, 0, 0, 55, 7, 56, 32, 0, 0, 0, 0, 56, 28, 5, 16, 0, 0, 0, 0, 56, 231, 26, 32, 0,
        0, 0, 0, 57, 251, 231, 16, 0, 0, 0, 0, 58, 198, 252, 32, 0, 0, 0, 0, 59, 219, 201, 16, 0,
        0, 0, 0, 60, 176, 24, 160, 0, 0, 0, 0, 61, 187, 171, 16, 0, 0, 0, 0, 62, 143, 250, 160, 0,
        0, 0, 0, 63, 155, 141, 16, 0, 0, 0, 0, 64, 111, 220, 160, 0, 0, 0, 0, 65, 132, 169, 144, 0,
        0, 0, 0, 66, 79, 190, 160, 0, 0, 0, 0, 67, 100, 139, 144, 0, 0, 0, 0, 68, 47, 160, 160, 0,
        0, 0, 0, 69, 68, 109, 144, 0, 0, 0, 0, 70, 15, 130, 160, 0, 0, 0, 0, 71, 36, 79, 144, 0, 0,
        0, 0, 71, 248, 159, 32, 0, 0, 0, 0, 73, 4, 49, 144, 0, 0, 0, 0, 73, 216, 129, 32, 0, 0, 0,
        0, 74, 228, 19, 144, 0, 0, 0, 0, 75, 156, 179, 160, 1, 2, 1, 2, 3, 2, 4, 5, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 255, 255, 146, 76, 0, 0,
        255, 255, 157, 144, 0, 4, 255, 255, 143, 128, 0, 8, 255, 255, 157, 144, 1, 12, 255, 255,
        157, 144, 1, 16, 255, 255, 157, 144, 1, 20, 76, 77, 84, 0, 77, 83, 84, 0, 80, 83, 84, 0,
        80, 68, 84, 0, 80, 87, 84, 0, 80, 80, 84, 0, 10, 80, 83, 84, 56, 80, 68, 84, 44, 77, 51,
        46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaFortNelson: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        143, 0, 0, 0, 6, 0, 0, 0, 24, 255, 255, 255, 255, 94, 61, 118, 135, 255, 255, 255, 255,
        158, 184, 189, 160, 255, 255, 255, 255, 159, 187, 21, 144, 255, 255, 255, 255, 203, 137,
        26, 160, 255, 255, 255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 97, 38, 16, 255,
        255, 255, 255, 213, 85, 241, 32, 255, 255, 255, 255, 214, 32, 234, 16, 255, 255, 255, 255,
        215, 53, 211, 32, 255, 255, 255, 255, 216, 0, 204, 16, 255, 255, 255, 255, 217, 21, 181,
        32, 255, 255, 255, 255, 217, 224, 174, 16, 255, 255, 255, 255, 218, 254, 209, 160, 255,
        255, 255, 255, 219, 192, 144, 16, 255, 255, 255, 255, 220, 222, 179, 160, 255, 255, 255,
        255, 221, 169, 172, 144, 255, 255, 255, 255, 222, 190, 149, 160, 255, 255, 255, 255, 223,
        137, 142, 144, 255, 255, 255, 255, 224, 158, 119, 160, 255, 255, 255, 255, 225, 105, 112,
        144, 255, 255, 255, 255, 226, 126, 89, 160, 255, 255, 255, 255, 227, 73, 82, 144, 255, 255,
        255, 255, 228, 94, 59, 160, 255, 255, 255, 255, 229, 41, 52, 144, 255, 255, 255, 255, 230,
        71, 88, 32, 255, 255, 255, 255, 231, 18, 81, 16, 255, 255, 255, 255, 232, 39, 58, 32, 255,
        255, 255, 255, 232, 242, 51, 16, 255, 255, 255, 255, 234, 7, 28, 32, 255, 255, 255, 255,
        234, 210, 21, 16, 255, 255, 255, 255, 235, 230, 254, 32, 255, 255, 255, 255, 236, 177, 247,
        16, 255, 255, 255, 255, 237, 198, 224, 32, 255, 255, 255, 255, 238, 145, 217, 16, 255, 255,
        255, 255, 239, 175, 252, 160, 255, 255, 255, 255, 240, 113, 187, 16, 255, 255, 255, 255,
        241, 143, 222, 160, 255, 255, 255, 255, 242, 127, 193, 144, 255, 255, 255, 255, 243, 111,
        192, 160, 255, 255, 255, 255, 244, 95, 163, 144, 255, 255, 255, 255, 245, 79, 162, 160,
        255, 255, 255, 255, 246, 63, 133, 144, 255, 255, 255, 255, 247, 47, 132, 160, 255, 255,
        255, 255, 248, 40, 162, 16, 255, 255, 255, 255, 249, 15, 102, 160, 255, 255, 255, 255, 250,
        8, 132, 16, 255, 255, 255, 255, 250, 248, 131, 32, 255, 255, 255, 255, 251, 232, 102, 16,
        255, 255, 255, 255, 252, 216, 101, 32, 255, 255, 255, 255, 253, 200, 72, 16, 255, 255, 255,
        255, 254, 184, 71, 32, 255, 255, 255, 255, 255, 168, 42, 16, 0, 0, 0, 0, 0, 152, 41, 32, 0,
        0, 0, 0, 1, 136, 12, 16, 0, 0, 0, 0, 2, 120, 11, 32, 0, 0, 0, 0, 3, 113, 40, 144, 0, 0, 0,
        0, 4, 97, 39, 160, 0, 0, 0, 0, 5, 81, 10, 144, 0, 0, 0, 0, 6, 65, 9, 160, 0, 0, 0, 0, 7,
        48, 236, 144, 0, 0, 0, 0, 8, 32, 235, 160, 0, 0, 0, 0, 9, 16, 206, 144, 0, 0, 0, 0, 10, 0,
        205, 160, 0, 0, 0, 0, 10, 240, 176, 144, 0, 0, 0, 0, 11, 224, 175, 160, 0, 0, 0, 0, 12,
        217, 205, 16, 0, 0, 0, 0, 13, 192, 145, 160, 0, 0, 0, 0, 14, 185, 175, 16, 0, 0, 0, 0, 15,
        169, 174, 32, 0, 0, 0, 0, 16, 153, 145, 16, 0, 0, 0, 0, 17, 137, 144, 32, 0, 0, 0, 0, 18,
        121, 115, 16, 0, 0, 0, 0, 19, 105, 114, 32, 0, 0, 0, 0, 20, 89, 85, 16, 0, 0, 0, 0, 21, 73,
        84, 32, 0, 0, 0, 0, 22, 57, 55, 16, 0, 0, 0, 0, 23, 41, 54, 32, 0, 0, 0, 0, 24, 34, 83,
        144, 0, 0, 0, 0, 25, 9, 24, 32, 0, 0, 0, 0, 26, 2, 53, 144, 0, 0, 0, 0, 26, 242, 52, 160,
        0, 0, 0, 0, 27, 226, 23, 144, 0, 0, 0, 0, 28, 210, 22, 160, 0, 0, 0, 0, 29, 193, 249, 144,
        0, 0, 0, 0, 30, 177, 248, 160, 0, 0, 0, 0, 31, 161, 219, 144, 0, 0, 0, 0, 32, 118, 43, 32,
        0, 0, 0, 0, 33, 129, 189, 144, 0, 0, 0, 0, 34, 86, 13, 32, 0, 0, 0, 0, 35, 106, 218, 16, 0,
        0, 0, 0, 36, 53, 239, 32, 0, 0, 0, 0, 37, 74, 188, 16, 0, 0, 0, 0, 38, 21, 209, 32, 0, 0,
        0, 0, 39, 42, 158, 16, 0, 0, 0, 0, 39, 254, 237, 160, 0, 0, 0, 0, 41, 10, 128, 16, 0, 0, 0,
        0, 41, 222, 207, 160, 0, 0, 0, 0, 42, 234, 98, 16, 0, 0, 0, 0, 43, 190, 177, 160, 0, 0, 0,
        0, 44, 211, 126, 144, 0, 0, 0, 0, 45, 158, 147, 160, 0, 0, 0, 0, 46, 179, 96, 144, 0, 0, 0,
        0, 47, 126, 117, 160, 0, 0, 0, 0, 48, 147, 66, 144, 0, 0, 0, 0, 49, 103, 146, 32, 0, 0, 0,
        0, 50, 115, 36, 144, 0, 0, 0, 0, 51, 71, 116, 32, 0, 0, 0, 0, 52, 83, 6, 144, 0, 0, 0, 0,
        53, 39, 86, 32, 0, 0, 0, 0, 54, 50, 232, 144, 0, 0, 0, 0, 55, 7, 56, 32, 0, 0, 0, 0, 56,
        28, 5, 16, 0, 0, 0, 0, 56, 231, 26, 32, 0, 0, 0, 0, 57, 251, 231, 16, 0, 0, 0, 0, 58, 198,
        252, 32, 0, 0, 0, 0, 59, 219, 201, 16, 0, 0, 0, 0, 60, 176, 24, 160, 0, 0, 0, 0, 61, 187,
        171, 16, 0, 0, 0, 0, 62, 143, 250, 160, 0, 0, 0, 0, 63, 155, 141, 16, 0, 0, 0, 0, 64, 111,
        220, 160, 0, 0, 0, 0, 65, 132, 169, 144, 0, 0, 0, 0, 66, 79, 190, 160, 0, 0, 0, 0, 67, 100,
        139, 144, 0, 0, 0, 0, 68, 47, 160, 160, 0, 0, 0, 0, 69, 68, 109, 144, 0, 0, 0, 0, 69, 243,
        211, 32, 0, 0, 0, 0, 71, 45, 138, 16, 0, 0, 0, 0, 71, 211, 181, 32, 0, 0, 0, 0, 73, 13,
        108, 16, 0, 0, 0, 0, 73, 179, 151, 32, 0, 0, 0, 0, 74, 237, 78, 16, 0, 0, 0, 0, 75, 156,
        179, 160, 0, 0, 0, 0, 76, 214, 106, 144, 0, 0, 0, 0, 77, 124, 149, 160, 0, 0, 0, 0, 78,
        182, 76, 144, 0, 0, 0, 0, 79, 92, 119, 160, 0, 0, 0, 0, 80, 150, 46, 144, 0, 0, 0, 0, 81,
        60, 89, 160, 0, 0, 0, 0, 82, 118, 16, 144, 0, 0, 0, 0, 83, 28, 59, 160, 0, 0, 0, 0, 84, 85,
        242, 144, 0, 0, 0, 0, 84, 252, 29, 160, 2, 1, 2, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 5, 255, 255, 140, 249, 0, 0, 255, 255, 157, 144, 1, 4, 255, 255, 143, 128,
        0, 8, 255, 255, 157, 144, 1, 12, 255, 255, 157, 144, 1, 16, 255, 255, 157, 144, 0, 20, 76,
        77, 84, 0, 80, 68, 84, 0, 80, 83, 84, 0, 80, 87, 84, 0, 80, 80, 84, 0, 77, 83, 84, 0, 10,
        77, 83, 84, 55, 10,
    ];
    pub(crate) const AmericaFortWayne: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        38, 0, 0, 0, 7, 0, 0, 0, 28, 255, 255, 255, 255, 94, 3, 254, 160, 255, 255, 255, 255, 158,
        166, 44, 128, 255, 255, 255, 255, 159, 186, 249, 112, 255, 255, 255, 255, 160, 134, 14,
        128, 255, 255, 255, 255, 161, 154, 219, 112, 255, 255, 255, 255, 202, 87, 34, 128, 255,
        255, 255, 255, 202, 216, 71, 112, 255, 255, 255, 255, 203, 136, 254, 128, 255, 255, 255,
        255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 97, 9, 240, 255, 255, 255, 255, 211, 117,
        243, 0, 255, 255, 255, 255, 212, 64, 235, 240, 255, 255, 255, 255, 213, 85, 213, 0, 255,
        255, 255, 255, 214, 32, 205, 240, 255, 255, 255, 255, 215, 53, 183, 0, 255, 255, 255, 255,
        216, 0, 175, 240, 255, 255, 255, 255, 217, 21, 153, 0, 255, 255, 255, 255, 217, 224, 145,
        240, 255, 255, 255, 255, 218, 254, 181, 128, 255, 255, 255, 255, 219, 192, 115, 240, 255,
        255, 255, 255, 220, 222, 151, 128, 255, 255, 255, 255, 221, 169, 144, 112, 255, 255, 255,
        255, 222, 190, 121, 128, 255, 255, 255, 255, 223, 137, 114, 112, 255, 255, 255, 255, 224,
        158, 91, 128, 255, 255, 255, 255, 225, 105, 84, 112, 255, 255, 255, 255, 226, 126, 61, 128,
        255, 255, 255, 255, 227, 73, 54, 112, 255, 255, 255, 255, 228, 94, 31, 128, 255, 255, 255,
        255, 232, 242, 22, 240, 255, 255, 255, 255, 234, 7, 0, 0, 255, 255, 255, 255, 254, 184, 28,
        240, 255, 255, 255, 255, 255, 167, 255, 224, 0, 0, 0, 0, 0, 151, 254, 240, 0, 0, 0, 0, 1,
        135, 225, 224, 0, 0, 0, 0, 68, 47, 118, 112, 0, 0, 0, 0, 69, 68, 67, 96, 0, 0, 0, 0, 69,
        243, 168, 240, 2, 1, 2, 1, 2, 1, 2, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 5, 2, 5, 6, 5, 6, 5, 6, 5, 6, 255, 255, 175, 58, 0, 0, 255, 255, 185, 176, 1, 4,
        255, 255, 171, 160, 0, 8, 255, 255, 185, 176, 1, 12, 255, 255, 185, 176, 1, 16, 255, 255,
        185, 176, 0, 20, 255, 255, 199, 192, 1, 24, 76, 77, 84, 0, 67, 68, 84, 0, 67, 83, 84, 0,
        67, 87, 84, 0, 67, 80, 84, 0, 69, 83, 84, 0, 69, 68, 84, 0, 10, 69, 83, 84, 53, 69, 68, 84,
        44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaFortaleza: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        39, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 150, 170, 107, 24, 255, 255, 255, 255,
        184, 15, 73, 224, 255, 255, 255, 255, 184, 253, 64, 160, 255, 255, 255, 255, 185, 241, 52,
        48, 255, 255, 255, 255, 186, 222, 116, 32, 255, 255, 255, 255, 218, 56, 174, 48, 255, 255,
        255, 255, 218, 235, 250, 48, 255, 255, 255, 255, 220, 25, 225, 176, 255, 255, 255, 255,
        220, 185, 89, 32, 255, 255, 255, 255, 221, 251, 21, 48, 255, 255, 255, 255, 222, 155, 222,
        32, 255, 255, 255, 255, 223, 221, 154, 48, 255, 255, 255, 255, 224, 84, 51, 32, 255, 255,
        255, 255, 244, 151, 255, 176, 255, 255, 255, 255, 245, 5, 94, 32, 255, 255, 255, 255, 246,
        192, 100, 48, 255, 255, 255, 255, 247, 14, 30, 160, 255, 255, 255, 255, 248, 81, 44, 48,
        255, 255, 255, 255, 248, 199, 197, 32, 255, 255, 255, 255, 250, 10, 210, 176, 255, 255,
        255, 255, 250, 168, 248, 160, 255, 255, 255, 255, 251, 236, 6, 48, 255, 255, 255, 255, 252,
        139, 125, 160, 0, 0, 0, 0, 29, 201, 142, 48, 0, 0, 0, 0, 30, 120, 215, 160, 0, 0, 0, 0, 31,
        160, 53, 176, 0, 0, 0, 0, 32, 51, 207, 160, 0, 0, 0, 0, 33, 129, 105, 48, 0, 0, 0, 0, 34,
        11, 200, 160, 0, 0, 0, 0, 35, 88, 16, 176, 0, 0, 0, 0, 35, 226, 112, 32, 0, 0, 0, 0, 37,
        55, 242, 176, 0, 0, 0, 0, 37, 212, 199, 32, 0, 0, 0, 0, 55, 246, 198, 176, 0, 0, 0, 0, 56,
        184, 133, 32, 0, 0, 0, 0, 57, 223, 227, 48, 0, 0, 0, 0, 57, 242, 74, 32, 0, 0, 0, 0, 59,
        200, 255, 176, 0, 0, 0, 0, 60, 111, 14, 160, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 255, 255, 219, 232,
        0, 0, 255, 255, 227, 224, 1, 4, 255, 255, 213, 208, 0, 8, 76, 77, 84, 0, 45, 48, 50, 0, 45,
        48, 51, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AmericaGlaceBay: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        79, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 128, 241, 168, 52, 255, 255, 255, 255,
        158, 184, 133, 96, 255, 255, 255, 255, 159, 186, 221, 80, 255, 255, 255, 255, 203, 136,
        226, 96, 255, 255, 255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 96, 237, 208, 255,
        255, 255, 255, 224, 158, 63, 96, 255, 255, 255, 255, 225, 105, 56, 80, 0, 0, 0, 0, 4, 96,
        239, 96, 0, 0, 0, 0, 5, 80, 210, 80, 0, 0, 0, 0, 6, 64, 209, 96, 0, 0, 0, 0, 7, 48, 180,
        80, 0, 0, 0, 0, 8, 32, 179, 96, 0, 0, 0, 0, 9, 16, 150, 80, 0, 0, 0, 0, 10, 0, 149, 96, 0,
        0, 0, 0, 10, 240, 120, 80, 0, 0, 0, 0, 11, 224, 119, 96, 0, 0, 0, 0, 12, 217, 148, 208, 0,
        0, 0, 0, 13, 192, 89, 96, 0, 0, 0, 0, 14, 185, 118, 208, 0, 0, 0, 0, 15, 169, 117, 224, 0,
        0, 0, 0, 16, 153, 88, 208, 0, 0, 0, 0, 17, 137, 87, 224, 0, 0, 0, 0, 18, 121, 58, 208, 0,
        0, 0, 0, 19, 105, 57, 224, 0, 0, 0, 0, 20, 89, 28, 208, 0, 0, 0, 0, 21, 73, 27, 224, 0, 0,
        0, 0, 22, 56, 254, 208, 0, 0, 0, 0, 23, 40, 253, 224, 0, 0, 0, 0, 24, 34, 27, 80, 0, 0, 0,
        0, 25, 8, 223, 224, 0, 0, 0, 0, 26, 1, 253, 80, 0, 0, 0, 0, 26, 241, 252, 96, 0, 0, 0, 0,
        27, 225, 223, 80, 0, 0, 0, 0, 28, 209, 222, 96, 0, 0, 0, 0, 29, 193, 193, 80, 0, 0, 0, 0,
        30, 177, 192, 96, 0, 0, 0, 0, 31, 161, 163, 80, 0, 0, 0, 0, 32, 117, 242, 224, 0, 0, 0, 0,
        33, 129, 133, 80, 0, 0, 0, 0, 34, 85, 212, 224, 0, 0, 0, 0, 35, 106, 161, 208, 0, 0, 0, 0,
        36, 53, 182, 224, 0, 0, 0, 0, 37, 74, 131, 208, 0, 0, 0, 0, 38, 21, 152, 224, 0, 0, 0, 0,
        39, 42, 101, 208, 0, 0, 0, 0, 39, 254, 181, 96, 0, 0, 0, 0, 41, 10, 71, 208, 0, 0, 0, 0,
        41, 222, 151, 96, 0, 0, 0, 0, 42, 234, 41, 208, 0, 0, 0, 0, 43, 190, 121, 96, 0, 0, 0, 0,
        44, 211, 70, 80, 0, 0, 0, 0, 45, 158, 91, 96, 0, 0, 0, 0, 46, 179, 40, 80, 0, 0, 0, 0, 47,
        126, 61, 96, 0, 0, 0, 0, 48, 147, 10, 80, 0, 0, 0, 0, 49, 103, 89, 224, 0, 0, 0, 0, 50,
        114, 236, 80, 0, 0, 0, 0, 51, 71, 59, 224, 0, 0, 0, 0, 52, 82, 206, 80, 0, 0, 0, 0, 53, 39,
        29, 224, 0, 0, 0, 0, 54, 50, 176, 80, 0, 0, 0, 0, 55, 6, 255, 224, 0, 0, 0, 0, 56, 27, 204,
        208, 0, 0, 0, 0, 56, 230, 225, 224, 0, 0, 0, 0, 57, 251, 174, 208, 0, 0, 0, 0, 58, 198,
        195, 224, 0, 0, 0, 0, 59, 219, 144, 208, 0, 0, 0, 0, 60, 175, 224, 96, 0, 0, 0, 0, 61, 187,
        114, 208, 0, 0, 0, 0, 62, 143, 194, 96, 0, 0, 0, 0, 63, 155, 84, 208, 0, 0, 0, 0, 64, 111,
        164, 96, 0, 0, 0, 0, 65, 132, 113, 80, 0, 0, 0, 0, 66, 79, 134, 96, 0, 0, 0, 0, 67, 100,
        83, 80, 0, 0, 0, 0, 68, 47, 104, 96, 0, 0, 0, 0, 69, 68, 53, 80, 0, 0, 0, 0, 69, 243, 154,
        224, 2, 1, 2, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 255, 255, 199, 204, 0, 0, 255,
        255, 213, 208, 1, 4, 255, 255, 199, 192, 0, 8, 255, 255, 213, 208, 1, 12, 255, 255, 213,
        208, 1, 16, 76, 77, 84, 0, 65, 68, 84, 0, 65, 83, 84, 0, 65, 87, 84, 0, 65, 80, 84, 0, 10,
        65, 83, 84, 52, 65, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaGodthab: &[u8] = &[
        84, 90, 105, 102, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 51,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        34, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 155, 128, 104, 0, 0, 0, 0, 0, 19, 77, 124,
        80, 0, 0, 0, 0, 20, 51, 250, 144, 0, 0, 0, 0, 21, 35, 235, 144, 0, 0, 0, 0, 22, 19, 220,
        144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23, 243, 190, 144, 0, 0, 0, 0, 24, 227, 175,
        144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 188,
        189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140,
        144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92,
        99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16,
        0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0,
        0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0,
        0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0,
        0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0,
        0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 255, 255, 207, 128, 0,
        0, 255, 255, 213, 208, 0, 4, 255, 255, 227, 224, 1, 8, 76, 77, 84, 0, 45, 48, 51, 0, 45,
        48, 50, 0, 10, 60, 45, 48, 51, 62, 51, 60, 45, 48, 50, 62, 44, 77, 51, 46, 53, 46, 48, 47,
        45, 50, 44, 77, 49, 48, 46, 53, 46, 48, 47, 45, 49, 10,
    ];
    pub(crate) const AmericaGooseBay: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        152, 0, 0, 0, 10, 0, 0, 0, 33, 255, 255, 255, 255, 94, 61, 60, 36, 255, 255, 255, 255, 158,
        184, 126, 140, 255, 255, 255, 255, 159, 186, 214, 124, 255, 255, 255, 255, 190, 158, 77,
        108, 255, 255, 255, 255, 192, 184, 49, 56, 255, 255, 255, 255, 193, 121, 239, 168, 255,
        255, 255, 255, 194, 152, 19, 56, 255, 255, 255, 255, 195, 89, 209, 168, 255, 255, 255, 255,
        196, 119, 245, 56, 255, 255, 255, 255, 197, 57, 179, 168, 255, 255, 255, 255, 198, 97, 17,
        184, 255, 255, 255, 255, 199, 25, 149, 168, 255, 255, 255, 255, 200, 64, 243, 184, 255,
        255, 255, 255, 201, 2, 178, 40, 255, 255, 255, 255, 202, 32, 213, 184, 255, 255, 255, 255,
        202, 226, 148, 40, 255, 255, 255, 255, 204, 0, 183, 184, 255, 255, 255, 255, 210, 35, 244,
        112, 255, 255, 255, 255, 210, 96, 230, 200, 255, 255, 255, 255, 211, 136, 68, 216, 255,
        255, 255, 255, 212, 74, 3, 72, 255, 255, 255, 255, 213, 104, 38, 216, 255, 255, 255, 255,
        214, 41, 229, 72, 255, 255, 255, 255, 215, 72, 8, 216, 255, 255, 255, 255, 216, 9, 199, 72,
        255, 255, 255, 255, 217, 39, 234, 216, 255, 255, 255, 255, 217, 233, 169, 72, 255, 255,
        255, 255, 219, 17, 7, 88, 255, 255, 255, 255, 219, 210, 197, 200, 255, 255, 255, 255, 220,
        222, 116, 88, 255, 255, 255, 255, 221, 169, 109, 72, 255, 255, 255, 255, 222, 190, 86, 88,
        255, 255, 255, 255, 223, 137, 79, 72, 255, 255, 255, 255, 224, 158, 56, 88, 255, 255, 255,
        255, 225, 105, 49, 72, 255, 255, 255, 255, 226, 126, 26, 88, 255, 255, 255, 255, 227, 73,
        19, 72, 255, 255, 255, 255, 228, 93, 252, 88, 255, 255, 255, 255, 229, 40, 245, 72, 255,
        255, 255, 255, 230, 71, 24, 216, 255, 255, 255, 255, 231, 18, 17, 200, 255, 255, 255, 255,
        232, 38, 250, 216, 255, 255, 255, 255, 232, 241, 243, 200, 255, 255, 255, 255, 234, 6, 220,
        216, 255, 255, 255, 255, 234, 209, 213, 200, 255, 255, 255, 255, 235, 230, 190, 216, 255,
        255, 255, 255, 236, 177, 183, 200, 255, 255, 255, 255, 237, 198, 160, 216, 255, 255, 255,
        255, 238, 191, 190, 72, 255, 255, 255, 255, 239, 175, 189, 88, 255, 255, 255, 255, 240,
        159, 160, 72, 255, 255, 255, 255, 241, 143, 159, 88, 255, 255, 255, 255, 242, 127, 130, 72,
        255, 255, 255, 255, 243, 111, 129, 88, 255, 255, 255, 255, 244, 95, 100, 72, 255, 255, 255,
        255, 245, 79, 99, 88, 255, 255, 255, 255, 246, 63, 70, 72, 255, 255, 255, 255, 247, 47, 69,
        88, 255, 255, 255, 255, 248, 40, 98, 200, 255, 255, 255, 255, 248, 218, 107, 88, 255, 255,
        255, 255, 249, 15, 46, 96, 255, 255, 255, 255, 250, 8, 75, 208, 255, 255, 255, 255, 250,
        248, 74, 224, 255, 255, 255, 255, 251, 232, 45, 208, 255, 255, 255, 255, 252, 216, 44, 224,
        255, 255, 255, 255, 253, 200, 15, 208, 255, 255, 255, 255, 254, 184, 14, 224, 255, 255,
        255, 255, 255, 167, 241, 208, 0, 0, 0, 0, 0, 151, 240, 224, 0, 0, 0, 0, 1, 135, 211, 208,
        0, 0, 0, 0, 2, 119, 210, 224, 0, 0, 0, 0, 3, 112, 240, 80, 0, 0, 0, 0, 4, 96, 239, 96, 0,
        0, 0, 0, 5, 80, 210, 80, 0, 0, 0, 0, 6, 64, 209, 96, 0, 0, 0, 0, 7, 48, 180, 80, 0, 0, 0,
        0, 8, 32, 179, 96, 0, 0, 0, 0, 9, 16, 150, 80, 0, 0, 0, 0, 10, 0, 149, 96, 0, 0, 0, 0, 10,
        240, 120, 80, 0, 0, 0, 0, 11, 224, 119, 96, 0, 0, 0, 0, 12, 217, 148, 208, 0, 0, 0, 0, 13,
        192, 89, 96, 0, 0, 0, 0, 14, 185, 118, 208, 0, 0, 0, 0, 15, 169, 117, 224, 0, 0, 0, 0, 16,
        153, 88, 208, 0, 0, 0, 0, 17, 137, 87, 224, 0, 0, 0, 0, 18, 121, 58, 208, 0, 0, 0, 0, 19,
        105, 57, 224, 0, 0, 0, 0, 20, 89, 28, 208, 0, 0, 0, 0, 21, 73, 27, 224, 0, 0, 0, 0, 22, 56,
        254, 208, 0, 0, 0, 0, 23, 40, 253, 224, 0, 0, 0, 0, 24, 34, 27, 80, 0, 0, 0, 0, 25, 8, 223,
        224, 0, 0, 0, 0, 26, 1, 253, 80, 0, 0, 0, 0, 26, 241, 252, 96, 0, 0, 0, 0, 27, 225, 223,
        80, 0, 0, 0, 0, 28, 209, 222, 96, 0, 0, 0, 0, 29, 193, 193, 80, 0, 0, 0, 0, 30, 177, 192,
        96, 0, 0, 0, 0, 31, 161, 163, 80, 0, 0, 0, 0, 32, 117, 214, 252, 0, 0, 0, 0, 33, 129, 105,
        108, 0, 0, 0, 0, 34, 85, 184, 252, 0, 0, 0, 0, 35, 106, 119, 220, 0, 0, 0, 0, 36, 53, 154,
        252, 0, 0, 0, 0, 37, 74, 103, 236, 0, 0, 0, 0, 38, 21, 124, 252, 0, 0, 0, 0, 39, 42, 73,
        236, 0, 0, 0, 0, 39, 254, 153, 124, 0, 0, 0, 0, 41, 10, 43, 236, 0, 0, 0, 0, 41, 222, 123,
        124, 0, 0, 0, 0, 42, 234, 13, 236, 0, 0, 0, 0, 43, 190, 93, 124, 0, 0, 0, 0, 44, 211, 42,
        108, 0, 0, 0, 0, 45, 158, 63, 124, 0, 0, 0, 0, 46, 179, 12, 108, 0, 0, 0, 0, 47, 126, 33,
        124, 0, 0, 0, 0, 48, 146, 238, 108, 0, 0, 0, 0, 49, 103, 61, 252, 0, 0, 0, 0, 50, 114, 208,
        108, 0, 0, 0, 0, 51, 71, 31, 252, 0, 0, 0, 0, 52, 82, 178, 108, 0, 0, 0, 0, 53, 39, 1, 252,
        0, 0, 0, 0, 54, 50, 148, 108, 0, 0, 0, 0, 55, 6, 227, 252, 0, 0, 0, 0, 56, 27, 176, 236, 0,
        0, 0, 0, 56, 230, 197, 252, 0, 0, 0, 0, 57, 251, 146, 236, 0, 0, 0, 0, 58, 198, 167, 252,
        0, 0, 0, 0, 59, 219, 116, 236, 0, 0, 0, 0, 60, 175, 196, 124, 0, 0, 0, 0, 61, 187, 86, 236,
        0, 0, 0, 0, 62, 143, 166, 124, 0, 0, 0, 0, 63, 155, 56, 236, 0, 0, 0, 0, 64, 111, 136, 124,
        0, 0, 0, 0, 65, 132, 85, 108, 0, 0, 0, 0, 66, 79, 106, 124, 0, 0, 0, 0, 67, 100, 55, 108,
        0, 0, 0, 0, 68, 47, 76, 124, 0, 0, 0, 0, 69, 68, 25, 108, 0, 0, 0, 0, 69, 243, 126, 252, 0,
        0, 0, 0, 71, 45, 53, 236, 0, 0, 0, 0, 71, 211, 96, 252, 0, 0, 0, 0, 73, 13, 23, 236, 0, 0,
        0, 0, 73, 179, 66, 252, 0, 0, 0, 0, 74, 236, 249, 236, 0, 0, 0, 0, 75, 156, 95, 124, 0, 0,
        0, 0, 76, 214, 22, 108, 0, 0, 0, 0, 77, 124, 65, 124, 0, 0, 0, 0, 78, 182, 20, 80, 1, 2, 1,
        3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 6, 5, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 8, 7, 8, 7,
        8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7,
        8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 9, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7,
        8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 255,
        255, 199, 92, 0, 0, 255, 255, 206, 148, 0, 4, 255, 255, 220, 164, 1, 8, 255, 255, 206, 200,
        0, 4, 255, 255, 220, 216, 1, 8, 255, 255, 220, 216, 1, 12, 255, 255, 220, 216, 1, 16, 255,
        255, 213, 208, 1, 20, 255, 255, 199, 192, 0, 24, 255, 255, 227, 224, 1, 28, 76, 77, 84, 0,
        78, 83, 84, 0, 78, 68, 84, 0, 78, 80, 84, 0, 78, 87, 84, 0, 65, 68, 84, 0, 65, 83, 84, 0,
        65, 68, 68, 84, 0, 10, 65, 83, 84, 52, 65, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49,
        49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaGrandTurk: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        76, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 105, 135, 30, 48, 255, 255, 255, 255, 147,
        15, 180, 254, 0, 0, 0, 0, 17, 137, 101, 240, 0, 0, 0, 0, 18, 121, 72, 224, 0, 0, 0, 0, 19,
        105, 71, 240, 0, 0, 0, 0, 20, 89, 42, 224, 0, 0, 0, 0, 21, 73, 41, 240, 0, 0, 0, 0, 22, 57,
        12, 224, 0, 0, 0, 0, 23, 41, 11, 240, 0, 0, 0, 0, 24, 34, 41, 96, 0, 0, 0, 0, 25, 8, 237,
        240, 0, 0, 0, 0, 26, 2, 11, 96, 0, 0, 0, 0, 26, 242, 10, 112, 0, 0, 0, 0, 27, 225, 237, 96,
        0, 0, 0, 0, 28, 209, 236, 112, 0, 0, 0, 0, 29, 193, 207, 96, 0, 0, 0, 0, 30, 177, 206, 112,
        0, 0, 0, 0, 31, 161, 177, 96, 0, 0, 0, 0, 32, 118, 0, 240, 0, 0, 0, 0, 33, 129, 147, 96, 0,
        0, 0, 0, 34, 85, 226, 240, 0, 0, 0, 0, 35, 106, 175, 224, 0, 0, 0, 0, 36, 53, 196, 240, 0,
        0, 0, 0, 37, 74, 145, 224, 0, 0, 0, 0, 38, 21, 166, 240, 0, 0, 0, 0, 39, 42, 115, 224, 0,
        0, 0, 0, 39, 254, 195, 112, 0, 0, 0, 0, 41, 10, 85, 224, 0, 0, 0, 0, 41, 222, 165, 112, 0,
        0, 0, 0, 42, 234, 55, 224, 0, 0, 0, 0, 43, 190, 135, 112, 0, 0, 0, 0, 44, 211, 84, 96, 0,
        0, 0, 0, 45, 158, 105, 112, 0, 0, 0, 0, 46, 179, 54, 96, 0, 0, 0, 0, 47, 126, 75, 112, 0,
        0, 0, 0, 48, 147, 24, 96, 0, 0, 0, 0, 49, 103, 103, 240, 0, 0, 0, 0, 50, 114, 250, 96, 0,
        0, 0, 0, 51, 71, 73, 240, 0, 0, 0, 0, 52, 82, 220, 96, 0, 0, 0, 0, 53, 39, 43, 240, 0, 0,
        0, 0, 54, 50, 190, 96, 0, 0, 0, 0, 55, 7, 13, 240, 0, 0, 0, 0, 56, 27, 218, 224, 0, 0, 0,
        0, 56, 230, 239, 240, 0, 0, 0, 0, 57, 251, 188, 224, 0, 0, 0, 0, 58, 198, 209, 240, 0, 0,
        0, 0, 59, 219, 158, 224, 0, 0, 0, 0, 60, 175, 238, 112, 0, 0, 0, 0, 61, 187, 128, 224, 0,
        0, 0, 0, 62, 143, 208, 112, 0, 0, 0, 0, 63, 155, 98, 224, 0, 0, 0, 0, 64, 111, 178, 112, 0,
        0, 0, 0, 65, 132, 127, 96, 0, 0, 0, 0, 66, 79, 148, 112, 0, 0, 0, 0, 67, 100, 97, 96, 0, 0,
        0, 0, 68, 47, 118, 112, 0, 0, 0, 0, 69, 68, 67, 96, 0, 0, 0, 0, 69, 243, 168, 240, 0, 0, 0,
        0, 71, 45, 95, 224, 0, 0, 0, 0, 71, 211, 138, 240, 0, 0, 0, 0, 73, 13, 65, 224, 0, 0, 0, 0,
        73, 179, 108, 240, 0, 0, 0, 0, 74, 237, 35, 224, 0, 0, 0, 0, 75, 156, 137, 112, 0, 0, 0, 0,
        76, 214, 64, 96, 0, 0, 0, 0, 77, 124, 107, 112, 0, 0, 0, 0, 78, 182, 34, 96, 0, 0, 0, 0,
        79, 92, 77, 112, 0, 0, 0, 0, 80, 150, 4, 96, 0, 0, 0, 0, 81, 60, 47, 112, 0, 0, 0, 0, 82,
        117, 230, 96, 0, 0, 0, 0, 83, 28, 17, 112, 0, 0, 0, 0, 84, 85, 200, 96, 0, 0, 0, 0, 84,
        251, 243, 112, 0, 0, 0, 0, 90, 164, 211, 240, 1, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 4,
        3, 255, 255, 189, 80, 0, 0, 255, 255, 184, 2, 0, 4, 255, 255, 185, 176, 0, 8, 255, 255,
        199, 192, 1, 12, 255, 255, 199, 192, 0, 16, 76, 77, 84, 0, 75, 77, 84, 0, 69, 83, 84, 0,
        69, 68, 84, 0, 65, 83, 84, 0, 10, 69, 83, 84, 53, 69, 68, 84, 44, 77, 51, 46, 50, 46, 48,
        44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaGuatemala: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        9, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 159, 157, 234, 220, 0, 0, 0, 0, 7, 85, 172,
        96, 0, 0, 0, 0, 7, 205, 150, 208, 0, 0, 0, 0, 25, 44, 120, 96, 0, 0, 0, 0, 25, 207, 228,
        80, 0, 0, 0, 0, 39, 234, 238, 224, 0, 0, 0, 0, 40, 200, 92, 208, 0, 0, 0, 0, 68, 84, 82,
        96, 0, 0, 0, 0, 69, 31, 75, 80, 2, 1, 2, 1, 2, 1, 2, 1, 2, 255, 255, 171, 36, 0, 0, 255,
        255, 185, 176, 1, 4, 255, 255, 171, 160, 0, 8, 76, 77, 84, 0, 67, 68, 84, 0, 67, 83, 84, 0,
        10, 67, 83, 84, 54, 10,
    ];
    pub(crate) const AmericaGuayaquil: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        4, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 105, 135, 38, 88, 255, 255, 255, 255, 182,
        164, 66, 24, 0, 0, 0, 0, 43, 22, 252, 208, 0, 0, 0, 0, 43, 113, 230, 64, 1, 3, 2, 3, 255,
        255, 181, 40, 0, 0, 255, 255, 182, 104, 0, 4, 255, 255, 199, 192, 1, 8, 255, 255, 185, 176,
        0, 12, 76, 77, 84, 0, 81, 77, 84, 0, 45, 48, 52, 0, 45, 48, 53, 0, 10, 60, 45, 48, 53, 62,
        53, 10,
    ];
    pub(crate) const AmericaGuyana: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        4, 0, 0, 0, 4, 0, 0, 0, 18, 255, 255, 255, 255, 146, 29, 15, 135, 255, 255, 255, 255, 152,
        217, 123, 64, 0, 0, 0, 0, 10, 127, 5, 188, 0, 0, 0, 0, 41, 213, 64, 192, 1, 2, 3, 1, 255,
        255, 201, 121, 0, 0, 255, 255, 199, 192, 0, 4, 255, 255, 203, 68, 0, 8, 255, 255, 213, 208,
        0, 14, 76, 77, 84, 0, 45, 48, 52, 0, 45, 48, 51, 52, 53, 0, 45, 48, 51, 0, 10, 60, 45, 48,
        52, 62, 52, 10,
    ];
    pub(crate) const AmericaHalifax: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        167, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 128, 241, 171, 160, 255, 255, 255, 255,
        154, 228, 222, 192, 255, 255, 255, 255, 155, 214, 19, 48, 255, 255, 255, 255, 158, 184,
        133, 96, 255, 255, 255, 255, 159, 186, 221, 80, 255, 255, 255, 255, 162, 157, 23, 64, 255,
        255, 255, 255, 163, 48, 177, 48, 255, 255, 255, 255, 164, 122, 86, 64, 255, 255, 255, 255,
        165, 27, 31, 48, 255, 255, 255, 255, 166, 83, 160, 192, 255, 255, 255, 255, 166, 252, 82,
        176, 255, 255, 255, 255, 168, 60, 189, 64, 255, 255, 255, 255, 168, 220, 52, 176, 255, 255,
        255, 255, 170, 28, 159, 64, 255, 255, 255, 255, 170, 205, 58, 48, 255, 255, 255, 255, 171,
        252, 129, 64, 255, 255, 255, 255, 172, 191, 145, 48, 255, 255, 255, 255, 173, 238, 216, 64,
        255, 255, 255, 255, 174, 140, 254, 48, 255, 255, 255, 255, 175, 188, 69, 64, 255, 255, 255,
        255, 176, 127, 85, 48, 255, 255, 255, 255, 177, 174, 156, 64, 255, 255, 255, 255, 178, 75,
        112, 176, 255, 255, 255, 255, 179, 142, 126, 64, 255, 255, 255, 255, 180, 36, 187, 48, 255,
        255, 255, 255, 181, 110, 96, 64, 255, 255, 255, 255, 182, 21, 192, 176, 255, 255, 255, 255,
        183, 78, 66, 64, 255, 255, 255, 255, 184, 8, 23, 176, 255, 255, 255, 255, 185, 36, 233,
        192, 255, 255, 255, 255, 185, 231, 249, 176, 255, 255, 255, 255, 187, 4, 203, 192, 255,
        255, 255, 255, 187, 209, 22, 48, 255, 255, 255, 255, 189, 0, 93, 64, 255, 255, 255, 255,
        189, 157, 49, 176, 255, 255, 255, 255, 190, 242, 180, 64, 255, 255, 255, 255, 191, 144,
        218, 48, 255, 255, 255, 255, 192, 211, 231, 192, 255, 255, 255, 255, 193, 94, 71, 48, 255,
        255, 255, 255, 194, 141, 142, 64, 255, 255, 255, 255, 195, 80, 158, 48, 255, 255, 255, 255,
        196, 109, 112, 64, 255, 255, 255, 255, 197, 48, 128, 48, 255, 255, 255, 255, 198, 114, 60,
        64, 255, 255, 255, 255, 199, 16, 98, 48, 255, 255, 255, 255, 200, 54, 110, 192, 255, 255,
        255, 255, 200, 249, 126, 176, 255, 255, 255, 255, 202, 22, 80, 192, 255, 255, 255, 255,
        202, 217, 96, 176, 255, 255, 255, 255, 203, 136, 226, 96, 255, 255, 255, 255, 210, 35, 244,
        112, 255, 255, 255, 255, 210, 96, 237, 208, 255, 255, 255, 255, 211, 117, 214, 224, 255,
        255, 255, 255, 212, 64, 207, 208, 255, 255, 255, 255, 213, 85, 184, 224, 255, 255, 255,
        255, 214, 32, 177, 208, 255, 255, 255, 255, 215, 53, 154, 224, 255, 255, 255, 255, 216, 0,
        147, 208, 255, 255, 255, 255, 217, 21, 124, 224, 255, 255, 255, 255, 217, 224, 117, 208,
        255, 255, 255, 255, 220, 222, 123, 96, 255, 255, 255, 255, 221, 169, 116, 80, 255, 255,
        255, 255, 222, 190, 93, 96, 255, 255, 255, 255, 223, 137, 86, 80, 255, 255, 255, 255, 224,
        158, 63, 96, 255, 255, 255, 255, 225, 105, 56, 80, 255, 255, 255, 255, 226, 126, 33, 96,
        255, 255, 255, 255, 227, 73, 26, 80, 255, 255, 255, 255, 230, 71, 31, 224, 255, 255, 255,
        255, 231, 18, 24, 208, 255, 255, 255, 255, 232, 39, 1, 224, 255, 255, 255, 255, 232, 241,
        250, 208, 255, 255, 255, 255, 234, 6, 227, 224, 255, 255, 255, 255, 234, 209, 220, 208,
        255, 255, 255, 255, 235, 230, 197, 224, 255, 255, 255, 255, 236, 177, 190, 208, 255, 255,
        255, 255, 241, 143, 166, 96, 255, 255, 255, 255, 242, 127, 137, 80, 255, 255, 255, 255,
        243, 111, 136, 96, 255, 255, 255, 255, 244, 95, 107, 80, 255, 255, 255, 255, 245, 79, 106,
        96, 255, 255, 255, 255, 246, 63, 77, 80, 255, 255, 255, 255, 247, 47, 76, 96, 255, 255,
        255, 255, 248, 40, 105, 208, 255, 255, 255, 255, 249, 15, 46, 96, 255, 255, 255, 255, 250,
        8, 75, 208, 255, 255, 255, 255, 250, 248, 74, 224, 255, 255, 255, 255, 251, 232, 45, 208,
        255, 255, 255, 255, 252, 216, 44, 224, 255, 255, 255, 255, 253, 200, 15, 208, 255, 255,
        255, 255, 254, 184, 14, 224, 255, 255, 255, 255, 255, 167, 241, 208, 0, 0, 0, 0, 0, 151,
        240, 224, 0, 0, 0, 0, 1, 135, 211, 208, 0, 0, 0, 0, 2, 119, 210, 224, 0, 0, 0, 0, 3, 112,
        240, 80, 0, 0, 0, 0, 4, 96, 239, 96, 0, 0, 0, 0, 5, 80, 210, 80, 0, 0, 0, 0, 6, 64, 209,
        96, 0, 0, 0, 0, 7, 48, 180, 80, 0, 0, 0, 0, 8, 32, 179, 96, 0, 0, 0, 0, 9, 16, 150, 80, 0,
        0, 0, 0, 10, 0, 149, 96, 0, 0, 0, 0, 10, 240, 120, 80, 0, 0, 0, 0, 11, 224, 119, 96, 0, 0,
        0, 0, 12, 217, 148, 208, 0, 0, 0, 0, 13, 192, 89, 96, 0, 0, 0, 0, 14, 185, 118, 208, 0, 0,
        0, 0, 15, 169, 117, 224, 0, 0, 0, 0, 16, 153, 88, 208, 0, 0, 0, 0, 17, 137, 87, 224, 0, 0,
        0, 0, 18, 121, 58, 208, 0, 0, 0, 0, 19, 105, 57, 224, 0, 0, 0, 0, 20, 89, 28, 208, 0, 0, 0,
        0, 21, 73, 27, 224, 0, 0, 0, 0, 22, 56, 254, 208, 0, 0, 0, 0, 23, 40, 253, 224, 0, 0, 0, 0,
        24, 34, 27, 80, 0, 0, 0, 0, 25, 8, 223, 224, 0, 0, 0, 0, 26, 1, 253, 80, 0, 0, 0, 0, 26,
        241, 252, 96, 0, 0, 0, 0, 27, 225, 223, 80, 0, 0, 0, 0, 28, 209, 222, 96, 0, 0, 0, 0, 29,
        193, 193, 80, 0, 0, 0, 0, 30, 177, 192, 96, 0, 0, 0, 0, 31, 161, 163, 80, 0, 0, 0, 0, 32,
        117, 242, 224, 0, 0, 0, 0, 33, 129, 133, 80, 0, 0, 0, 0, 34, 85, 212, 224, 0, 0, 0, 0, 35,
        106, 161, 208, 0, 0, 0, 0, 36, 53, 182, 224, 0, 0, 0, 0, 37, 74, 131, 208, 0, 0, 0, 0, 38,
        21, 152, 224, 0, 0, 0, 0, 39, 42, 101, 208, 0, 0, 0, 0, 39, 254, 181, 96, 0, 0, 0, 0, 41,
        10, 71, 208, 0, 0, 0, 0, 41, 222, 151, 96, 0, 0, 0, 0, 42, 234, 41, 208, 0, 0, 0, 0, 43,
        190, 121, 96, 0, 0, 0, 0, 44, 211, 70, 80, 0, 0, 0, 0, 45, 158, 91, 96, 0, 0, 0, 0, 46,
        179, 40, 80, 0, 0, 0, 0, 47, 126, 61, 96, 0, 0, 0, 0, 48, 147, 10, 80, 0, 0, 0, 0, 49, 103,
        89, 224, 0, 0, 0, 0, 50, 114, 236, 80, 0, 0, 0, 0, 51, 71, 59, 224, 0, 0, 0, 0, 52, 82,
        206, 80, 0, 0, 0, 0, 53, 39, 29, 224, 0, 0, 0, 0, 54, 50, 176, 80, 0, 0, 0, 0, 55, 6, 255,
        224, 0, 0, 0, 0, 56, 27, 204, 208, 0, 0, 0, 0, 56, 230, 225, 224, 0, 0, 0, 0, 57, 251, 174,
        208, 0, 0, 0, 0, 58, 198, 195, 224, 0, 0, 0, 0, 59, 219, 144, 208, 0, 0, 0, 0, 60, 175,
        224, 96, 0, 0, 0, 0, 61, 187, 114, 208, 0, 0, 0, 0, 62, 143, 194, 96, 0, 0, 0, 0, 63, 155,
        84, 208, 0, 0, 0, 0, 64, 111, 164, 96, 0, 0, 0, 0, 65, 132, 113, 80, 0, 0, 0, 0, 66, 79,
        134, 96, 0, 0, 0, 0, 67, 100, 83, 80, 0, 0, 0, 0, 68, 47, 104, 96, 0, 0, 0, 0, 69, 68, 53,
        80, 0, 0, 0, 0, 69, 243, 154, 224, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 255,
        255, 196, 96, 0, 0, 255, 255, 213, 208, 1, 4, 255, 255, 199, 192, 0, 8, 255, 255, 213, 208,
        1, 12, 255, 255, 213, 208, 1, 16, 76, 77, 84, 0, 65, 68, 84, 0, 65, 83, 84, 0, 65, 87, 84,
        0, 65, 80, 84, 0, 10, 65, 83, 84, 52, 65, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49,
        49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaHavana: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        106, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 105, 135, 40, 184, 255, 255, 255, 255,
        172, 98, 194, 128, 255, 255, 255, 255, 177, 211, 148, 80, 255, 255, 255, 255, 178, 116, 93,
        64, 255, 255, 255, 255, 200, 91, 102, 208, 255, 255, 255, 255, 200, 211, 81, 64, 255, 255,
        255, 255, 202, 59, 72, 208, 255, 255, 255, 255, 202, 188, 109, 192, 255, 255, 255, 255,
        204, 36, 101, 80, 255, 255, 255, 255, 204, 156, 79, 192, 255, 255, 255, 255, 209, 196, 11,
        80, 255, 255, 255, 255, 210, 59, 245, 192, 255, 255, 255, 255, 211, 163, 237, 80, 255, 255,
        255, 255, 212, 27, 215, 192, 255, 255, 255, 255, 247, 96, 5, 208, 255, 255, 255, 255, 247,
        255, 125, 64, 255, 255, 255, 255, 249, 61, 68, 208, 255, 255, 255, 255, 249, 227, 83, 192,
        255, 255, 255, 255, 250, 219, 59, 208, 255, 255, 255, 255, 251, 167, 134, 64, 255, 255,
        255, 255, 252, 197, 169, 208, 255, 255, 255, 255, 253, 135, 104, 64, 255, 255, 255, 255,
        254, 184, 0, 208, 255, 255, 255, 255, 255, 167, 227, 192, 0, 0, 0, 0, 0, 151, 226, 208, 0,
        0, 0, 0, 1, 135, 197, 192, 0, 0, 0, 0, 2, 119, 196, 208, 0, 0, 0, 0, 3, 112, 226, 64, 0, 0,
        0, 0, 4, 96, 225, 80, 0, 0, 0, 0, 5, 53, 20, 192, 0, 0, 0, 0, 6, 64, 195, 80, 0, 0, 0, 0,
        7, 22, 72, 64, 0, 0, 0, 0, 8, 32, 165, 80, 0, 0, 0, 0, 8, 247, 123, 192, 0, 0, 0, 0, 10, 0,
        135, 80, 0, 0, 0, 0, 10, 240, 106, 64, 0, 0, 0, 0, 11, 224, 105, 80, 0, 0, 0, 0, 12, 217,
        134, 192, 0, 0, 0, 0, 13, 192, 75, 80, 0, 0, 0, 0, 14, 185, 104, 192, 0, 0, 0, 0, 15, 178,
        162, 80, 0, 0, 0, 0, 16, 125, 155, 64, 0, 0, 0, 0, 17, 81, 234, 208, 0, 0, 0, 0, 18, 102,
        183, 192, 0, 0, 0, 0, 19, 49, 204, 208, 0, 0, 0, 0, 20, 70, 153, 192, 0, 0, 0, 0, 21, 91,
        130, 208, 0, 0, 0, 0, 22, 38, 123, 192, 0, 0, 0, 0, 23, 59, 100, 208, 0, 0, 0, 0, 24, 6,
        93, 192, 0, 0, 0, 0, 25, 27, 70, 208, 0, 0, 0, 0, 25, 230, 63, 192, 0, 0, 0, 0, 26, 251,
        40, 208, 0, 0, 0, 0, 27, 207, 92, 64, 0, 0, 0, 0, 28, 219, 10, 208, 0, 0, 0, 0, 29, 175,
        62, 64, 0, 0, 0, 0, 30, 122, 83, 80, 0, 0, 0, 0, 31, 143, 32, 64, 0, 0, 0, 0, 32, 90, 53,
        80, 0, 0, 0, 0, 33, 111, 2, 64, 0, 0, 0, 0, 34, 67, 81, 208, 0, 0, 0, 0, 35, 78, 228, 64,
        0, 0, 0, 0, 36, 35, 51, 208, 0, 0, 0, 0, 37, 46, 198, 64, 0, 0, 0, 0, 38, 21, 138, 208, 0,
        0, 0, 0, 39, 23, 226, 192, 0, 0, 0, 0, 39, 254, 167, 80, 0, 0, 0, 0, 40, 247, 210, 208, 0,
        0, 0, 0, 41, 222, 137, 80, 0, 0, 0, 0, 42, 215, 180, 208, 0, 0, 0, 0, 43, 190, 107, 80, 0,
        0, 0, 0, 44, 183, 150, 208, 0, 0, 0, 0, 45, 158, 77, 80, 0, 0, 0, 0, 46, 151, 120, 208, 0,
        0, 0, 0, 47, 126, 47, 80, 0, 0, 0, 0, 48, 119, 90, 208, 0, 0, 0, 0, 49, 103, 75, 208, 0, 0,
        0, 0, 50, 87, 60, 208, 0, 0, 0, 0, 51, 71, 45, 208, 0, 0, 0, 0, 52, 64, 89, 80, 0, 0, 0, 0,
        53, 29, 213, 80, 0, 0, 0, 0, 54, 50, 176, 80, 0, 0, 0, 0, 54, 253, 183, 80, 0, 0, 0, 0, 56,
        27, 204, 208, 0, 0, 0, 0, 56, 230, 211, 208, 0, 0, 0, 0, 57, 251, 174, 208, 0, 0, 0, 0, 58,
        198, 181, 208, 0, 0, 0, 0, 59, 219, 144, 208, 0, 0, 0, 0, 60, 175, 210, 80, 0, 0, 0, 0, 61,
        187, 114, 208, 0, 0, 0, 0, 62, 143, 180, 80, 0, 0, 0, 0, 63, 155, 84, 208, 0, 0, 0, 0, 64,
        102, 91, 208, 0, 0, 0, 0, 69, 68, 53, 80, 0, 0, 0, 0, 69, 243, 140, 208, 0, 0, 0, 0, 71,
        36, 23, 80, 0, 0, 0, 0, 71, 220, 169, 80, 0, 0, 0, 0, 73, 3, 249, 80, 0, 0, 0, 0, 73, 179,
        80, 208, 0, 0, 0, 0, 74, 227, 219, 80, 0, 0, 0, 0, 75, 156, 109, 80, 0, 0, 0, 0, 76, 204,
        247, 208, 0, 0, 0, 0, 77, 133, 137, 208, 0, 0, 0, 0, 78, 191, 78, 208, 0, 0, 0, 0, 79, 119,
        224, 208, 0, 0, 0, 0, 80, 149, 246, 80, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 255,
        255, 178, 200, 0, 0, 255, 255, 178, 192, 0, 4, 255, 255, 199, 192, 1, 8, 255, 255, 185,
        176, 0, 12, 76, 77, 84, 0, 72, 77, 84, 0, 67, 68, 84, 0, 67, 83, 84, 0, 10, 67, 83, 84, 53,
        67, 68, 84, 44, 77, 51, 46, 50, 46, 48, 47, 48, 44, 77, 49, 49, 46, 49, 46, 48, 47, 49, 10,
    ];
    pub(crate) const AmericaHermosillo: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        15, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 165, 182, 232, 112, 255, 255, 255, 255,
        175, 242, 110, 224, 255, 255, 255, 255, 182, 102, 86, 96, 255, 255, 255, 255, 183, 67, 210,
        96, 255, 255, 255, 255, 184, 12, 54, 96, 255, 255, 255, 255, 184, 253, 134, 240, 255, 255,
        255, 255, 203, 234, 113, 96, 255, 255, 255, 255, 216, 145, 180, 240, 0, 0, 0, 0, 0, 0, 112,
        128, 0, 0, 0, 0, 49, 103, 132, 16, 0, 0, 0, 0, 50, 115, 22, 128, 0, 0, 0, 0, 51, 71, 102,
        16, 0, 0, 0, 0, 52, 82, 248, 128, 0, 0, 0, 0, 53, 39, 72, 16, 0, 0, 0, 0, 54, 50, 218, 128,
        1, 2, 1, 2, 1, 2, 1, 3, 1, 4, 1, 4, 1, 4, 1, 255, 255, 151, 248, 0, 0, 255, 255, 157, 144,
        0, 4, 255, 255, 171, 160, 0, 8, 255, 255, 143, 128, 0, 12, 255, 255, 171, 160, 1, 16, 76,
        77, 84, 0, 77, 83, 84, 0, 67, 83, 84, 0, 80, 83, 84, 0, 77, 68, 84, 0, 10, 77, 83, 84, 55,
        10,
    ];
    pub(crate) const AmericaInuvik: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        59, 0, 0, 0, 5, 0, 0, 0, 21, 255, 255, 255, 255, 224, 6, 78, 128, 255, 255, 255, 255, 247,
        47, 104, 128, 255, 255, 255, 255, 248, 40, 148, 0, 0, 0, 0, 0, 17, 137, 144, 32, 0, 0, 0,
        0, 19, 105, 100, 16, 0, 0, 0, 0, 20, 89, 71, 0, 0, 0, 0, 0, 21, 73, 70, 16, 0, 0, 0, 0, 22,
        57, 41, 0, 0, 0, 0, 0, 23, 41, 40, 16, 0, 0, 0, 0, 24, 34, 69, 128, 0, 0, 0, 0, 25, 9, 10,
        16, 0, 0, 0, 0, 26, 2, 39, 128, 0, 0, 0, 0, 26, 242, 38, 144, 0, 0, 0, 0, 27, 226, 9, 128,
        0, 0, 0, 0, 28, 210, 8, 144, 0, 0, 0, 0, 29, 193, 235, 128, 0, 0, 0, 0, 30, 177, 234, 144,
        0, 0, 0, 0, 31, 161, 205, 128, 0, 0, 0, 0, 32, 118, 29, 16, 0, 0, 0, 0, 33, 129, 175, 128,
        0, 0, 0, 0, 34, 85, 255, 16, 0, 0, 0, 0, 35, 106, 204, 0, 0, 0, 0, 0, 36, 53, 225, 16, 0,
        0, 0, 0, 37, 74, 174, 0, 0, 0, 0, 0, 38, 21, 195, 16, 0, 0, 0, 0, 39, 42, 144, 0, 0, 0, 0,
        0, 39, 254, 223, 144, 0, 0, 0, 0, 41, 10, 114, 0, 0, 0, 0, 0, 41, 222, 193, 144, 0, 0, 0,
        0, 42, 234, 84, 0, 0, 0, 0, 0, 43, 190, 163, 144, 0, 0, 0, 0, 44, 211, 112, 128, 0, 0, 0,
        0, 45, 158, 133, 144, 0, 0, 0, 0, 46, 179, 82, 128, 0, 0, 0, 0, 47, 126, 103, 144, 0, 0, 0,
        0, 48, 147, 52, 128, 0, 0, 0, 0, 49, 103, 132, 16, 0, 0, 0, 0, 50, 115, 22, 128, 0, 0, 0,
        0, 51, 71, 102, 16, 0, 0, 0, 0, 52, 82, 248, 128, 0, 0, 0, 0, 53, 39, 72, 16, 0, 0, 0, 0,
        54, 50, 218, 128, 0, 0, 0, 0, 55, 7, 42, 16, 0, 0, 0, 0, 56, 27, 247, 0, 0, 0, 0, 0, 56,
        231, 12, 16, 0, 0, 0, 0, 57, 251, 217, 0, 0, 0, 0, 0, 58, 198, 238, 16, 0, 0, 0, 0, 59,
        219, 187, 0, 0, 0, 0, 0, 60, 176, 10, 144, 0, 0, 0, 0, 61, 187, 157, 0, 0, 0, 0, 0, 62,
        143, 236, 144, 0, 0, 0, 0, 63, 155, 127, 0, 0, 0, 0, 0, 64, 111, 206, 144, 0, 0, 0, 0, 65,
        132, 155, 128, 0, 0, 0, 0, 66, 79, 176, 144, 0, 0, 0, 0, 67, 100, 125, 128, 0, 0, 0, 0, 68,
        47, 146, 144, 0, 0, 0, 0, 69, 68, 95, 128, 0, 0, 0, 0, 69, 243, 197, 16, 2, 1, 2, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 0, 0, 0, 0, 0, 0, 255,
        255, 171, 160, 1, 4, 255, 255, 143, 128, 0, 9, 255, 255, 157, 144, 0, 13, 255, 255, 171,
        160, 1, 17, 45, 48, 48, 0, 80, 68, 68, 84, 0, 80, 83, 84, 0, 77, 83, 84, 0, 77, 68, 84, 0,
        10, 77, 83, 84, 55, 77, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48,
        10,
    ];
    pub(crate) const AmericaIqaluit: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        60, 0, 0, 0, 8, 0, 0, 0, 33, 255, 255, 255, 255, 204, 108, 161, 128, 255, 255, 255, 255,
        210, 35, 244, 112, 255, 255, 255, 255, 210, 96, 251, 224, 255, 255, 255, 255, 247, 47, 62,
        80, 255, 255, 255, 255, 248, 40, 105, 208, 0, 0, 0, 0, 19, 105, 71, 240, 0, 0, 0, 0, 20,
        89, 42, 224, 0, 0, 0, 0, 21, 73, 41, 240, 0, 0, 0, 0, 22, 57, 12, 224, 0, 0, 0, 0, 23, 41,
        11, 240, 0, 0, 0, 0, 24, 34, 41, 96, 0, 0, 0, 0, 25, 8, 237, 240, 0, 0, 0, 0, 26, 2, 11,
        96, 0, 0, 0, 0, 26, 242, 10, 112, 0, 0, 0, 0, 27, 225, 237, 96, 0, 0, 0, 0, 28, 209, 236,
        112, 0, 0, 0, 0, 29, 193, 207, 96, 0, 0, 0, 0, 30, 177, 206, 112, 0, 0, 0, 0, 31, 161, 177,
        96, 0, 0, 0, 0, 32, 118, 0, 240, 0, 0, 0, 0, 33, 129, 147, 96, 0, 0, 0, 0, 34, 85, 226,
        240, 0, 0, 0, 0, 35, 106, 175, 224, 0, 0, 0, 0, 36, 53, 196, 240, 0, 0, 0, 0, 37, 74, 145,
        224, 0, 0, 0, 0, 38, 21, 166, 240, 0, 0, 0, 0, 39, 42, 115, 224, 0, 0, 0, 0, 39, 254, 195,
        112, 0, 0, 0, 0, 41, 10, 85, 224, 0, 0, 0, 0, 41, 222, 165, 112, 0, 0, 0, 0, 42, 234, 55,
        224, 0, 0, 0, 0, 43, 190, 135, 112, 0, 0, 0, 0, 44, 211, 84, 96, 0, 0, 0, 0, 45, 158, 105,
        112, 0, 0, 0, 0, 46, 179, 54, 96, 0, 0, 0, 0, 47, 126, 75, 112, 0, 0, 0, 0, 48, 147, 24,
        96, 0, 0, 0, 0, 49, 103, 103, 240, 0, 0, 0, 0, 50, 114, 250, 96, 0, 0, 0, 0, 51, 71, 73,
        240, 0, 0, 0, 0, 52, 82, 220, 96, 0, 0, 0, 0, 53, 39, 43, 240, 0, 0, 0, 0, 54, 50, 190, 96,
        0, 0, 0, 0, 55, 7, 13, 240, 0, 0, 0, 0, 56, 27, 218, 224, 0, 0, 0, 0, 56, 230, 254, 0, 0,
        0, 0, 0, 57, 251, 202, 240, 0, 0, 0, 0, 58, 198, 209, 240, 0, 0, 0, 0, 59, 219, 158, 224,
        0, 0, 0, 0, 60, 175, 238, 112, 0, 0, 0, 0, 61, 187, 128, 224, 0, 0, 0, 0, 62, 143, 208,
        112, 0, 0, 0, 0, 63, 155, 98, 224, 0, 0, 0, 0, 64, 111, 178, 112, 0, 0, 0, 0, 65, 132, 127,
        96, 0, 0, 0, 0, 66, 79, 148, 112, 0, 0, 0, 0, 67, 100, 97, 96, 0, 0, 0, 0, 68, 47, 118,
        112, 0, 0, 0, 0, 69, 68, 67, 96, 0, 0, 0, 0, 69, 243, 168, 240, 5, 1, 2, 3, 2, 4, 2, 4, 2,
        4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2,
        4, 2, 4, 2, 4, 6, 7, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 0, 0, 0, 0, 0, 0, 255, 255,
        199, 192, 1, 4, 255, 255, 185, 176, 0, 8, 255, 255, 213, 208, 1, 12, 255, 255, 199, 192, 1,
        17, 255, 255, 199, 192, 1, 21, 255, 255, 171, 160, 0, 25, 255, 255, 185, 176, 1, 29, 45,
        48, 48, 0, 69, 80, 84, 0, 69, 83, 84, 0, 69, 68, 68, 84, 0, 69, 68, 84, 0, 69, 87, 84, 0,
        67, 83, 84, 0, 67, 68, 84, 0, 10, 69, 83, 84, 53, 69, 68, 84, 44, 77, 51, 46, 50, 46, 48,
        44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaJamaica: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        22, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 105, 135, 35, 126, 255, 255, 255, 255,
        147, 15, 180, 254, 0, 0, 0, 0, 7, 141, 25, 112, 0, 0, 0, 0, 9, 16, 164, 96, 0, 0, 0, 0, 9,
        173, 148, 240, 0, 0, 0, 0, 10, 240, 134, 96, 0, 0, 0, 0, 11, 224, 133, 112, 0, 0, 0, 0, 12,
        217, 162, 224, 0, 0, 0, 0, 13, 192, 103, 112, 0, 0, 0, 0, 14, 185, 132, 224, 0, 0, 0, 0,
        15, 169, 131, 240, 0, 0, 0, 0, 16, 153, 102, 224, 0, 0, 0, 0, 17, 137, 101, 240, 0, 0, 0,
        0, 18, 121, 72, 224, 0, 0, 0, 0, 19, 105, 71, 240, 0, 0, 0, 0, 20, 89, 42, 224, 0, 0, 0, 0,
        21, 73, 41, 240, 0, 0, 0, 0, 22, 57, 12, 224, 0, 0, 0, 0, 23, 41, 11, 240, 0, 0, 0, 0, 24,
        34, 41, 96, 0, 0, 0, 0, 25, 8, 237, 240, 0, 0, 0, 0, 26, 2, 11, 96, 1, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 255, 255, 184, 2, 0, 0, 255, 255, 184, 2, 0, 4,
        255, 255, 185, 176, 0, 8, 255, 255, 199, 192, 1, 12, 76, 77, 84, 0, 75, 77, 84, 0, 69, 83,
        84, 0, 69, 68, 84, 0, 10, 69, 83, 84, 53, 10,
    ];
    pub(crate) const AmericaJujuy: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        59, 0, 0, 0, 6, 0, 0, 0, 20, 255, 255, 255, 255, 114, 156, 174, 184, 255, 255, 255, 255,
        162, 146, 143, 48, 255, 255, 255, 255, 182, 123, 82, 64, 255, 255, 255, 255, 183, 26, 201,
        176, 255, 255, 255, 255, 184, 30, 143, 64, 255, 255, 255, 255, 184, 212, 112, 48, 255, 255,
        255, 255, 186, 23, 125, 192, 255, 255, 255, 255, 186, 181, 163, 176, 255, 255, 255, 255,
        187, 248, 177, 64, 255, 255, 255, 255, 188, 150, 215, 48, 255, 255, 255, 255, 189, 217,
        228, 192, 255, 255, 255, 255, 190, 120, 10, 176, 255, 255, 255, 255, 191, 187, 24, 64, 255,
        255, 255, 255, 192, 90, 143, 176, 255, 255, 255, 255, 193, 157, 157, 64, 255, 255, 255,
        255, 194, 59, 195, 48, 255, 255, 255, 255, 195, 126, 208, 192, 255, 255, 255, 255, 196, 28,
        246, 176, 255, 255, 255, 255, 197, 96, 4, 64, 255, 255, 255, 255, 197, 254, 42, 48, 255,
        255, 255, 255, 199, 65, 55, 192, 255, 255, 255, 255, 199, 224, 175, 48, 255, 255, 255, 255,
        200, 129, 148, 64, 255, 255, 255, 255, 202, 77, 161, 176, 255, 255, 255, 255, 202, 238,
        134, 192, 255, 255, 255, 255, 206, 77, 255, 48, 255, 255, 255, 255, 206, 176, 237, 192,
        255, 255, 255, 255, 211, 41, 53, 176, 255, 255, 255, 255, 212, 67, 100, 192, 255, 255, 255,
        255, 244, 61, 8, 48, 255, 255, 255, 255, 244, 159, 246, 192, 255, 255, 255, 255, 245, 5,
        108, 48, 255, 255, 255, 255, 246, 50, 16, 64, 255, 255, 255, 255, 246, 230, 159, 176, 255,
        255, 255, 255, 248, 19, 67, 192, 255, 255, 255, 255, 248, 199, 211, 48, 255, 255, 255, 255,
        249, 244, 119, 64, 255, 255, 255, 255, 250, 211, 54, 176, 255, 255, 255, 255, 251, 195, 53,
        192, 255, 255, 255, 255, 252, 188, 83, 48, 255, 255, 255, 255, 253, 172, 82, 64, 255, 255,
        255, 255, 254, 156, 53, 48, 255, 255, 255, 255, 255, 140, 52, 64, 0, 0, 0, 0, 7, 163, 74,
        176, 0, 0, 0, 0, 8, 36, 111, 160, 0, 0, 0, 0, 35, 148, 181, 176, 0, 0, 0, 0, 36, 16, 148,
        160, 0, 0, 0, 0, 37, 55, 242, 176, 0, 0, 0, 0, 37, 240, 118, 160, 0, 0, 0, 0, 39, 42, 87,
        192, 0, 0, 0, 0, 39, 226, 219, 176, 0, 0, 0, 0, 40, 238, 138, 64, 0, 0, 0, 0, 41, 176, 58,
        160, 0, 0, 0, 0, 42, 224, 211, 48, 0, 0, 0, 0, 43, 153, 87, 32, 0, 0, 0, 0, 55, 246, 198,
        176, 0, 0, 0, 0, 56, 191, 42, 176, 0, 0, 0, 0, 71, 119, 9, 176, 0, 0, 0, 0, 71, 220, 127,
        32, 1, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 5, 4, 5, 4, 5, 4, 2, 3, 2, 4, 5, 4, 5, 3, 5, 4, 5,
        255, 255, 194, 200, 0, 0, 255, 255, 195, 208, 0, 4, 255, 255, 199, 192, 0, 8, 255, 255,
        213, 208, 1, 12, 255, 255, 227, 224, 1, 16, 255, 255, 213, 208, 0, 12, 76, 77, 84, 0, 67,
        77, 84, 0, 45, 48, 52, 0, 45, 48, 51, 0, 45, 48, 50, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AmericaJuneau: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        83, 0, 0, 0, 10, 0, 0, 0, 38, 255, 255, 255, 255, 63, 194, 253, 209, 255, 255, 255, 255,
        125, 135, 50, 197, 255, 255, 255, 255, 203, 137, 26, 160, 255, 255, 255, 255, 210, 35, 244,
        112, 255, 255, 255, 255, 210, 97, 38, 16, 255, 255, 255, 255, 254, 184, 71, 32, 255, 255,
        255, 255, 255, 168, 42, 16, 0, 0, 0, 0, 0, 152, 41, 32, 0, 0, 0, 0, 1, 136, 12, 16, 0, 0,
        0, 0, 2, 120, 11, 32, 0, 0, 0, 0, 3, 113, 40, 144, 0, 0, 0, 0, 4, 97, 39, 160, 0, 0, 0, 0,
        5, 81, 10, 144, 0, 0, 0, 0, 6, 65, 9, 160, 0, 0, 0, 0, 7, 48, 236, 144, 0, 0, 0, 0, 7, 141,
        67, 160, 0, 0, 0, 0, 9, 16, 206, 144, 0, 0, 0, 0, 9, 173, 191, 32, 0, 0, 0, 0, 10, 240,
        176, 144, 0, 0, 0, 0, 11, 224, 175, 160, 0, 0, 0, 0, 12, 217, 205, 16, 0, 0, 0, 0, 13, 192,
        145, 160, 0, 0, 0, 0, 14, 185, 175, 16, 0, 0, 0, 0, 15, 169, 174, 32, 0, 0, 0, 0, 16, 153,
        145, 16, 0, 0, 0, 0, 17, 137, 144, 32, 0, 0, 0, 0, 18, 121, 115, 16, 0, 0, 0, 0, 19, 105,
        114, 32, 0, 0, 0, 0, 20, 89, 99, 32, 0, 0, 0, 0, 21, 73, 84, 32, 0, 0, 0, 0, 22, 57, 55,
        16, 0, 0, 0, 0, 23, 41, 54, 32, 0, 0, 0, 0, 24, 34, 83, 144, 0, 0, 0, 0, 25, 9, 24, 32, 0,
        0, 0, 0, 26, 2, 53, 144, 0, 0, 0, 0, 26, 43, 20, 16, 0, 0, 0, 0, 26, 242, 66, 176, 0, 0, 0,
        0, 27, 226, 37, 160, 0, 0, 0, 0, 28, 210, 36, 176, 0, 0, 0, 0, 29, 194, 7, 160, 0, 0, 0, 0,
        30, 178, 6, 176, 0, 0, 0, 0, 31, 161, 233, 160, 0, 0, 0, 0, 32, 118, 57, 48, 0, 0, 0, 0,
        33, 129, 203, 160, 0, 0, 0, 0, 34, 86, 27, 48, 0, 0, 0, 0, 35, 106, 232, 32, 0, 0, 0, 0,
        36, 53, 253, 48, 0, 0, 0, 0, 37, 74, 202, 32, 0, 0, 0, 0, 38, 21, 223, 48, 0, 0, 0, 0, 39,
        42, 172, 32, 0, 0, 0, 0, 39, 254, 251, 176, 0, 0, 0, 0, 41, 10, 142, 32, 0, 0, 0, 0, 41,
        222, 221, 176, 0, 0, 0, 0, 42, 234, 112, 32, 0, 0, 0, 0, 43, 190, 191, 176, 0, 0, 0, 0, 44,
        211, 140, 160, 0, 0, 0, 0, 45, 158, 161, 176, 0, 0, 0, 0, 46, 179, 110, 160, 0, 0, 0, 0,
        47, 126, 131, 176, 0, 0, 0, 0, 48, 147, 80, 160, 0, 0, 0, 0, 49, 103, 160, 48, 0, 0, 0, 0,
        50, 115, 50, 160, 0, 0, 0, 0, 51, 71, 130, 48, 0, 0, 0, 0, 52, 83, 20, 160, 0, 0, 0, 0, 53,
        39, 100, 48, 0, 0, 0, 0, 54, 50, 246, 160, 0, 0, 0, 0, 55, 7, 70, 48, 0, 0, 0, 0, 56, 28,
        19, 32, 0, 0, 0, 0, 56, 231, 40, 48, 0, 0, 0, 0, 57, 251, 245, 32, 0, 0, 0, 0, 58, 199, 10,
        48, 0, 0, 0, 0, 59, 219, 215, 32, 0, 0, 0, 0, 60, 176, 38, 176, 0, 0, 0, 0, 61, 187, 185,
        32, 0, 0, 0, 0, 62, 144, 8, 176, 0, 0, 0, 0, 63, 155, 155, 32, 0, 0, 0, 0, 64, 111, 234,
        176, 0, 0, 0, 0, 65, 132, 183, 160, 0, 0, 0, 0, 66, 79, 204, 176, 0, 0, 0, 0, 67, 100, 153,
        160, 0, 0, 0, 0, 68, 47, 174, 176, 0, 0, 0, 0, 69, 68, 123, 160, 0, 0, 0, 0, 69, 243, 225,
        48, 1, 2, 3, 4, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 6, 2,
        5, 2, 5, 2, 5, 7, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8,
        9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 0, 0, 211, 123, 0,
        0, 255, 255, 129, 251, 0, 0, 255, 255, 143, 128, 0, 4, 255, 255, 157, 144, 1, 8, 255, 255,
        157, 144, 1, 12, 255, 255, 157, 144, 1, 16, 255, 255, 143, 128, 1, 20, 255, 255, 129, 112,
        0, 24, 255, 255, 143, 128, 1, 28, 255, 255, 129, 112, 0, 33, 76, 77, 84, 0, 80, 83, 84, 0,
        80, 87, 84, 0, 80, 80, 84, 0, 80, 68, 84, 0, 89, 68, 84, 0, 89, 83, 84, 0, 65, 75, 68, 84,
        0, 65, 75, 83, 84, 0, 10, 65, 75, 83, 84, 57, 65, 75, 68, 84, 44, 77, 51, 46, 50, 46, 48,
        44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaKnoxIn: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        93, 0, 0, 0, 6, 0, 0, 0, 24, 255, 255, 255, 255, 94, 3, 254, 160, 255, 255, 255, 255, 158,
        166, 44, 128, 255, 255, 255, 255, 159, 186, 249, 112, 255, 255, 255, 255, 160, 134, 14,
        128, 255, 255, 255, 255, 161, 154, 219, 112, 255, 255, 255, 255, 203, 136, 254, 128, 255,
        255, 255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 97, 9, 240, 255, 255, 255, 255,
        213, 85, 213, 0, 255, 255, 255, 255, 214, 32, 205, 240, 255, 255, 255, 255, 215, 53, 183,
        0, 255, 255, 255, 255, 216, 0, 175, 240, 255, 255, 255, 255, 217, 21, 153, 0, 255, 255,
        255, 255, 217, 224, 145, 240, 255, 255, 255, 255, 218, 254, 181, 128, 255, 255, 255, 255,
        219, 192, 115, 240, 255, 255, 255, 255, 220, 222, 151, 128, 255, 255, 255, 255, 221, 169,
        144, 112, 255, 255, 255, 255, 222, 190, 121, 128, 255, 255, 255, 255, 223, 137, 114, 112,
        255, 255, 255, 255, 224, 158, 91, 128, 255, 255, 255, 255, 225, 105, 84, 112, 255, 255,
        255, 255, 226, 126, 61, 128, 255, 255, 255, 255, 227, 73, 54, 112, 255, 255, 255, 255, 228,
        94, 31, 128, 255, 255, 255, 255, 229, 87, 60, 240, 255, 255, 255, 255, 230, 71, 60, 0, 255,
        255, 255, 255, 231, 55, 30, 240, 255, 255, 255, 255, 232, 39, 30, 0, 255, 255, 255, 255,
        232, 242, 22, 240, 255, 255, 255, 255, 234, 7, 0, 0, 255, 255, 255, 255, 234, 209, 248,
        240, 255, 255, 255, 255, 235, 230, 226, 0, 255, 255, 255, 255, 236, 214, 196, 240, 255,
        255, 255, 255, 237, 198, 196, 0, 255, 255, 255, 255, 238, 191, 225, 112, 255, 255, 255,
        255, 239, 175, 224, 128, 255, 255, 255, 255, 240, 159, 195, 112, 255, 255, 255, 255, 241,
        143, 194, 128, 255, 255, 255, 255, 244, 95, 135, 112, 255, 255, 255, 255, 250, 248, 103, 0,
        255, 255, 255, 255, 251, 232, 73, 240, 255, 255, 255, 255, 252, 216, 73, 0, 255, 255, 255,
        255, 253, 200, 43, 240, 255, 255, 255, 255, 254, 184, 43, 0, 255, 255, 255, 255, 255, 168,
        13, 240, 0, 0, 0, 0, 0, 152, 13, 0, 0, 0, 0, 0, 1, 135, 239, 240, 0, 0, 0, 0, 2, 119, 239,
        0, 0, 0, 0, 0, 3, 113, 12, 112, 0, 0, 0, 0, 4, 97, 11, 128, 0, 0, 0, 0, 5, 80, 238, 112, 0,
        0, 0, 0, 6, 64, 237, 128, 0, 0, 0, 0, 7, 48, 208, 112, 0, 0, 0, 0, 7, 141, 39, 128, 0, 0,
        0, 0, 9, 16, 178, 112, 0, 0, 0, 0, 9, 173, 163, 0, 0, 0, 0, 0, 10, 240, 148, 112, 0, 0, 0,
        0, 11, 224, 147, 128, 0, 0, 0, 0, 12, 217, 176, 240, 0, 0, 0, 0, 13, 192, 117, 128, 0, 0,
        0, 0, 14, 185, 146, 240, 0, 0, 0, 0, 15, 169, 146, 0, 0, 0, 0, 0, 16, 153, 116, 240, 0, 0,
        0, 0, 17, 137, 116, 0, 0, 0, 0, 0, 18, 121, 86, 240, 0, 0, 0, 0, 19, 105, 86, 0, 0, 0, 0,
        0, 20, 89, 56, 240, 0, 0, 0, 0, 21, 73, 56, 0, 0, 0, 0, 0, 22, 57, 26, 240, 0, 0, 0, 0, 23,
        41, 26, 0, 0, 0, 0, 0, 24, 34, 55, 112, 0, 0, 0, 0, 25, 8, 252, 0, 0, 0, 0, 0, 26, 2, 25,
        112, 0, 0, 0, 0, 26, 242, 24, 128, 0, 0, 0, 0, 27, 225, 251, 112, 0, 0, 0, 0, 28, 209, 250,
        128, 0, 0, 0, 0, 29, 193, 221, 112, 0, 0, 0, 0, 30, 177, 220, 128, 0, 0, 0, 0, 31, 161,
        191, 112, 0, 0, 0, 0, 32, 118, 15, 0, 0, 0, 0, 0, 33, 129, 161, 112, 0, 0, 0, 0, 34, 85,
        241, 0, 0, 0, 0, 0, 35, 106, 189, 240, 0, 0, 0, 0, 36, 53, 211, 0, 0, 0, 0, 0, 37, 74, 159,
        240, 0, 0, 0, 0, 38, 21, 181, 0, 0, 0, 0, 0, 39, 42, 129, 240, 0, 0, 0, 0, 39, 254, 209,
        128, 0, 0, 0, 0, 41, 10, 99, 240, 0, 0, 0, 0, 68, 47, 118, 112, 0, 0, 0, 0, 69, 68, 81,
        112, 0, 0, 0, 0, 69, 243, 183, 0, 2, 1, 2, 1, 2, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 5, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 5, 1, 2, 1, 255, 255, 174, 202, 0, 0, 255, 255, 185, 176, 1,
        4, 255, 255, 171, 160, 0, 8, 255, 255, 185, 176, 1, 12, 255, 255, 185, 176, 1, 16, 255,
        255, 185, 176, 0, 20, 76, 77, 84, 0, 67, 68, 84, 0, 67, 83, 84, 0, 67, 87, 84, 0, 67, 80,
        84, 0, 69, 83, 84, 0, 10, 67, 83, 84, 54, 67, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77,
        49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaLaPaz: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        3, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 105, 135, 27, 100, 255, 255, 255, 255, 184,
        30, 150, 228, 255, 255, 255, 255, 184, 238, 213, 212, 1, 2, 3, 255, 255, 192, 28, 0, 0,
        255, 255, 192, 28, 0, 4, 255, 255, 206, 44, 1, 8, 255, 255, 199, 192, 0, 12, 76, 77, 84, 0,
        67, 77, 84, 0, 66, 83, 84, 0, 45, 48, 52, 0, 10, 60, 45, 48, 52, 62, 52, 10,
    ];
    pub(crate) const AmericaLima: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        16, 0, 0, 0, 4, 0, 0, 0, 12, 255, 255, 255, 255, 105, 135, 35, 188, 255, 255, 255, 255,
        140, 116, 64, 212, 255, 255, 255, 255, 195, 207, 74, 80, 255, 255, 255, 255, 196, 69, 227,
        64, 255, 255, 255, 255, 197, 47, 74, 208, 255, 255, 255, 255, 198, 31, 45, 192, 255, 255,
        255, 255, 199, 15, 44, 208, 255, 255, 255, 255, 199, 255, 15, 192, 0, 0, 0, 0, 30, 24, 196,
        80, 0, 0, 0, 0, 30, 143, 93, 64, 0, 0, 0, 0, 31, 249, 247, 208, 0, 0, 0, 0, 32, 112, 144,
        192, 0, 0, 0, 0, 37, 158, 227, 208, 0, 0, 0, 0, 38, 21, 124, 192, 0, 0, 0, 0, 45, 37, 3,
        80, 0, 0, 0, 0, 45, 155, 156, 64, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 255, 255,
        183, 196, 0, 0, 255, 255, 183, 172, 0, 0, 255, 255, 199, 192, 1, 4, 255, 255, 185, 176, 0,
        8, 76, 77, 84, 0, 45, 48, 52, 0, 45, 48, 53, 0, 10, 60, 45, 48, 53, 62, 53, 10,
    ];
    pub(crate) const AmericaLosAngeles: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        125, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 94, 4, 26, 192, 255, 255, 255, 255, 158,
        166, 72, 160, 255, 255, 255, 255, 159, 187, 21, 144, 255, 255, 255, 255, 160, 134, 42, 160,
        255, 255, 255, 255, 161, 154, 247, 144, 255, 255, 255, 255, 203, 137, 26, 160, 255, 255,
        255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 97, 38, 16, 255, 255, 255, 255, 214,
        254, 116, 92, 255, 255, 255, 255, 216, 128, 173, 144, 255, 255, 255, 255, 218, 254, 195,
        144, 255, 255, 255, 255, 219, 192, 144, 16, 255, 255, 255, 255, 220, 222, 165, 144, 255,
        255, 255, 255, 221, 169, 172, 144, 255, 255, 255, 255, 222, 190, 135, 144, 255, 255, 255,
        255, 223, 137, 142, 144, 255, 255, 255, 255, 224, 158, 105, 144, 255, 255, 255, 255, 225,
        105, 112, 144, 255, 255, 255, 255, 226, 126, 75, 144, 255, 255, 255, 255, 227, 73, 82, 144,
        255, 255, 255, 255, 228, 94, 45, 144, 255, 255, 255, 255, 229, 41, 52, 144, 255, 255, 255,
        255, 230, 71, 74, 16, 255, 255, 255, 255, 231, 18, 81, 16, 255, 255, 255, 255, 232, 39, 44,
        16, 255, 255, 255, 255, 232, 242, 51, 16, 255, 255, 255, 255, 234, 7, 14, 16, 255, 255,
        255, 255, 234, 210, 21, 16, 255, 255, 255, 255, 235, 230, 240, 16, 255, 255, 255, 255, 236,
        177, 247, 16, 255, 255, 255, 255, 237, 198, 210, 16, 255, 255, 255, 255, 238, 145, 217, 16,
        255, 255, 255, 255, 239, 175, 238, 144, 255, 255, 255, 255, 240, 113, 187, 16, 255, 255,
        255, 255, 241, 143, 208, 144, 255, 255, 255, 255, 242, 127, 193, 144, 255, 255, 255, 255,
        243, 111, 178, 144, 255, 255, 255, 255, 244, 95, 163, 144, 255, 255, 255, 255, 245, 79,
        148, 144, 255, 255, 255, 255, 246, 63, 133, 144, 255, 255, 255, 255, 247, 47, 118, 144,
        255, 255, 255, 255, 248, 40, 162, 16, 255, 255, 255, 255, 249, 15, 88, 144, 255, 255, 255,
        255, 250, 8, 132, 16, 255, 255, 255, 255, 250, 248, 131, 32, 255, 255, 255, 255, 251, 232,
        102, 16, 255, 255, 255, 255, 252, 216, 101, 32, 255, 255, 255, 255, 253, 200, 72, 16, 255,
        255, 255, 255, 254, 184, 71, 32, 255, 255, 255, 255, 255, 168, 42, 16, 0, 0, 0, 0, 0, 152,
        41, 32, 0, 0, 0, 0, 1, 136, 12, 16, 0, 0, 0, 0, 2, 120, 11, 32, 0, 0, 0, 0, 3, 113, 40,
        144, 0, 0, 0, 0, 4, 97, 39, 160, 0, 0, 0, 0, 5, 81, 10, 144, 0, 0, 0, 0, 6, 65, 9, 160, 0,
        0, 0, 0, 7, 48, 236, 144, 0, 0, 0, 0, 7, 141, 67, 160, 0, 0, 0, 0, 9, 16, 206, 144, 0, 0,
        0, 0, 9, 173, 191, 32, 0, 0, 0, 0, 10, 240, 176, 144, 0, 0, 0, 0, 11, 224, 175, 160, 0, 0,
        0, 0, 12, 217, 205, 16, 0, 0, 0, 0, 13, 192, 145, 160, 0, 0, 0, 0, 14, 185, 175, 16, 0, 0,
        0, 0, 15, 169, 174, 32, 0, 0, 0, 0, 16, 153, 145, 16, 0, 0, 0, 0, 17, 137, 144, 32, 0, 0,
        0, 0, 18, 121, 115, 16, 0, 0, 0, 0, 19, 105, 114, 32, 0, 0, 0, 0, 20, 89, 85, 16, 0, 0, 0,
        0, 21, 73, 84, 32, 0, 0, 0, 0, 22, 57, 55, 16, 0, 0, 0, 0, 23, 41, 54, 32, 0, 0, 0, 0, 24,
        34, 83, 144, 0, 0, 0, 0, 25, 9, 24, 32, 0, 0, 0, 0, 26, 2, 53, 144, 0, 0, 0, 0, 26, 242,
        52, 160, 0, 0, 0, 0, 27, 226, 23, 144, 0, 0, 0, 0, 28, 210, 22, 160, 0, 0, 0, 0, 29, 193,
        249, 144, 0, 0, 0, 0, 30, 177, 248, 160, 0, 0, 0, 0, 31, 161, 219, 144, 0, 0, 0, 0, 32,
        118, 43, 32, 0, 0, 0, 0, 33, 129, 189, 144, 0, 0, 0, 0, 34, 86, 13, 32, 0, 0, 0, 0, 35,
        106, 218, 16, 0, 0, 0, 0, 36, 53, 239, 32, 0, 0, 0, 0, 37, 74, 188, 16, 0, 0, 0, 0, 38, 21,
        209, 32, 0, 0, 0, 0, 39, 42, 158, 16, 0, 0, 0, 0, 39, 254, 237, 160, 0, 0, 0, 0, 41, 10,
        128, 16, 0, 0, 0, 0, 41, 222, 207, 160, 0, 0, 0, 0, 42, 234, 98, 16, 0, 0, 0, 0, 43, 190,
        177, 160, 0, 0, 0, 0, 44, 211, 126, 144, 0, 0, 0, 0, 45, 158, 147, 160, 0, 0, 0, 0, 46,
        179, 96, 144, 0, 0, 0, 0, 47, 126, 117, 160, 0, 0, 0, 0, 48, 147, 66, 144, 0, 0, 0, 0, 49,
        103, 146, 32, 0, 0, 0, 0, 50, 115, 36, 144, 0, 0, 0, 0, 51, 71, 116, 32, 0, 0, 0, 0, 52,
        83, 6, 144, 0, 0, 0, 0, 53, 39, 86, 32, 0, 0, 0, 0, 54, 50, 232, 144, 0, 0, 0, 0, 55, 7,
        56, 32, 0, 0, 0, 0, 56, 28, 5, 16, 0, 0, 0, 0, 56, 231, 26, 32, 0, 0, 0, 0, 57, 251, 231,
        16, 0, 0, 0, 0, 58, 198, 252, 32, 0, 0, 0, 0, 59, 219, 201, 16, 0, 0, 0, 0, 60, 176, 24,
        160, 0, 0, 0, 0, 61, 187, 171, 16, 0, 0, 0, 0, 62, 143, 250, 160, 0, 0, 0, 0, 63, 155, 141,
        16, 0, 0, 0, 0, 64, 111, 220, 160, 0, 0, 0, 0, 65, 132, 169, 144, 0, 0, 0, 0, 66, 79, 190,
        160, 0, 0, 0, 0, 67, 100, 139, 144, 0, 0, 0, 0, 68, 47, 160, 160, 0, 0, 0, 0, 69, 68, 109,
        144, 0, 0, 0, 0, 69, 243, 211, 32, 2, 1, 2, 1, 2, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 255, 255, 145, 38, 0, 0, 255, 255, 157,
        144, 1, 4, 255, 255, 143, 128, 0, 8, 255, 255, 157, 144, 1, 12, 255, 255, 157, 144, 1, 16,
        76, 77, 84, 0, 80, 68, 84, 0, 80, 83, 84, 0, 80, 87, 84, 0, 80, 80, 84, 0, 10, 80, 83, 84,
        56, 80, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaLouisville: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        117, 0, 0, 0, 7, 0, 0, 0, 28, 255, 255, 255, 255, 94, 3, 254, 160, 255, 255, 255, 255, 158,
        166, 44, 128, 255, 255, 255, 255, 159, 186, 249, 112, 255, 255, 255, 255, 160, 134, 14,
        128, 255, 255, 255, 255, 161, 154, 219, 112, 255, 255, 255, 255, 164, 115, 247, 0, 255,
        255, 255, 255, 165, 22, 17, 112, 255, 255, 255, 255, 202, 13, 78, 128, 255, 255, 255, 255,
        202, 216, 71, 112, 255, 255, 255, 255, 203, 136, 254, 128, 255, 255, 255, 255, 210, 35,
        244, 112, 255, 255, 255, 255, 210, 97, 9, 240, 255, 255, 255, 255, 211, 117, 215, 28, 255,
        255, 255, 255, 211, 164, 9, 112, 255, 255, 255, 255, 218, 254, 181, 128, 255, 255, 255,
        255, 219, 192, 115, 240, 255, 255, 255, 255, 220, 222, 151, 128, 255, 255, 255, 255, 221,
        169, 144, 112, 255, 255, 255, 255, 222, 190, 121, 128, 255, 255, 255, 255, 223, 137, 114,
        112, 255, 255, 255, 255, 224, 158, 91, 128, 255, 255, 255, 255, 225, 105, 84, 112, 255,
        255, 255, 255, 226, 126, 61, 128, 255, 255, 255, 255, 227, 73, 54, 112, 255, 255, 255, 255,
        228, 94, 31, 128, 255, 255, 255, 255, 229, 41, 24, 112, 255, 255, 255, 255, 230, 71, 60, 0,
        255, 255, 255, 255, 231, 55, 30, 240, 255, 255, 255, 255, 232, 39, 30, 0, 255, 255, 255,
        255, 233, 23, 0, 240, 255, 255, 255, 255, 234, 7, 0, 0, 255, 255, 255, 255, 234, 246, 226,
        240, 255, 255, 255, 255, 235, 230, 226, 0, 255, 255, 255, 255, 236, 214, 196, 240, 255,
        255, 255, 255, 237, 198, 196, 0, 255, 255, 255, 255, 238, 191, 225, 112, 255, 255, 255,
        255, 239, 175, 224, 128, 255, 255, 255, 255, 240, 30, 144, 112, 255, 255, 255, 255, 252,
        216, 58, 240, 255, 255, 255, 255, 253, 200, 29, 224, 255, 255, 255, 255, 254, 184, 28, 240,
        255, 255, 255, 255, 255, 167, 255, 224, 0, 0, 0, 0, 0, 151, 254, 240, 0, 0, 0, 0, 1, 135,
        225, 224, 0, 0, 0, 0, 2, 119, 224, 240, 0, 0, 0, 0, 3, 112, 254, 96, 0, 0, 0, 0, 4, 96,
        253, 112, 0, 0, 0, 0, 5, 80, 224, 96, 0, 0, 0, 0, 6, 64, 223, 112, 0, 0, 0, 0, 7, 48, 194,
        96, 0, 0, 0, 0, 7, 141, 25, 112, 0, 0, 0, 0, 9, 16, 178, 112, 0, 0, 0, 0, 9, 173, 148, 240,
        0, 0, 0, 0, 10, 240, 134, 96, 0, 0, 0, 0, 11, 224, 133, 112, 0, 0, 0, 0, 12, 217, 162, 224,
        0, 0, 0, 0, 13, 192, 103, 112, 0, 0, 0, 0, 14, 185, 132, 224, 0, 0, 0, 0, 15, 169, 131,
        240, 0, 0, 0, 0, 16, 153, 102, 224, 0, 0, 0, 0, 17, 137, 101, 240, 0, 0, 0, 0, 18, 121, 72,
        224, 0, 0, 0, 0, 19, 105, 71, 240, 0, 0, 0, 0, 20, 89, 42, 224, 0, 0, 0, 0, 21, 73, 41,
        240, 0, 0, 0, 0, 22, 57, 12, 224, 0, 0, 0, 0, 23, 41, 11, 240, 0, 0, 0, 0, 24, 34, 41, 96,
        0, 0, 0, 0, 25, 8, 237, 240, 0, 0, 0, 0, 26, 2, 11, 96, 0, 0, 0, 0, 26, 242, 10, 112, 0, 0,
        0, 0, 27, 225, 237, 96, 0, 0, 0, 0, 28, 209, 236, 112, 0, 0, 0, 0, 29, 193, 207, 96, 0, 0,
        0, 0, 30, 177, 206, 112, 0, 0, 0, 0, 31, 161, 177, 96, 0, 0, 0, 0, 32, 118, 0, 240, 0, 0,
        0, 0, 33, 129, 147, 96, 0, 0, 0, 0, 34, 85, 226, 240, 0, 0, 0, 0, 35, 106, 175, 224, 0, 0,
        0, 0, 36, 53, 196, 240, 0, 0, 0, 0, 37, 74, 145, 224, 0, 0, 0, 0, 38, 21, 166, 240, 0, 0,
        0, 0, 39, 42, 115, 224, 0, 0, 0, 0, 39, 254, 195, 112, 0, 0, 0, 0, 41, 10, 85, 224, 0, 0,
        0, 0, 41, 222, 165, 112, 0, 0, 0, 0, 42, 234, 55, 224, 0, 0, 0, 0, 43, 190, 135, 112, 0, 0,
        0, 0, 44, 211, 84, 96, 0, 0, 0, 0, 45, 158, 105, 112, 0, 0, 0, 0, 46, 179, 54, 96, 0, 0, 0,
        0, 47, 126, 75, 112, 0, 0, 0, 0, 48, 147, 24, 96, 0, 0, 0, 0, 49, 103, 103, 240, 0, 0, 0,
        0, 50, 114, 250, 96, 0, 0, 0, 0, 51, 71, 73, 240, 0, 0, 0, 0, 52, 82, 220, 96, 0, 0, 0, 0,
        53, 39, 43, 240, 0, 0, 0, 0, 54, 50, 190, 96, 0, 0, 0, 0, 55, 7, 13, 240, 0, 0, 0, 0, 56,
        27, 218, 224, 0, 0, 0, 0, 56, 230, 239, 240, 0, 0, 0, 0, 57, 251, 188, 224, 0, 0, 0, 0, 58,
        198, 209, 240, 0, 0, 0, 0, 59, 219, 158, 224, 0, 0, 0, 0, 60, 175, 238, 112, 0, 0, 0, 0,
        61, 187, 128, 224, 0, 0, 0, 0, 62, 143, 208, 112, 0, 0, 0, 0, 63, 155, 98, 224, 0, 0, 0, 0,
        64, 111, 178, 112, 0, 0, 0, 0, 65, 132, 127, 96, 0, 0, 0, 0, 66, 79, 148, 112, 0, 0, 0, 0,
        67, 100, 97, 96, 0, 0, 0, 0, 68, 47, 118, 112, 0, 0, 0, 0, 69, 68, 67, 96, 0, 0, 0, 0, 69,
        243, 168, 240, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 1, 5, 6, 5, 6,
        5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6,
        5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6,
        5, 6, 255, 255, 175, 154, 0, 0, 255, 255, 185, 176, 1, 4, 255, 255, 171, 160, 0, 8, 255,
        255, 185, 176, 1, 12, 255, 255, 185, 176, 1, 16, 255, 255, 185, 176, 0, 20, 255, 255, 199,
        192, 1, 24, 76, 77, 84, 0, 67, 68, 84, 0, 67, 83, 84, 0, 67, 87, 84, 0, 67, 80, 84, 0, 69,
        83, 84, 0, 69, 68, 84, 0, 10, 69, 83, 84, 53, 69, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44,
        77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaMaceio: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        41, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 150, 170, 104, 124, 255, 255, 255, 255,
        184, 15, 73, 224, 255, 255, 255, 255, 184, 253, 64, 160, 255, 255, 255, 255, 185, 241, 52,
        48, 255, 255, 255, 255, 186, 222, 116, 32, 255, 255, 255, 255, 218, 56, 174, 48, 255, 255,
        255, 255, 218, 235, 250, 48, 255, 255, 255, 255, 220, 25, 225, 176, 255, 255, 255, 255,
        220, 185, 89, 32, 255, 255, 255, 255, 221, 251, 21, 48, 255, 255, 255, 255, 222, 155, 222,
        32, 255, 255, 255, 255, 223, 221, 154, 48, 255, 255, 255, 255, 224, 84, 51, 32, 255, 255,
        255, 255, 244, 151, 255, 176, 255, 255, 255, 255, 245, 5, 94, 32, 255, 255, 255, 255, 246,
        192, 100, 48, 255, 255, 255, 255, 247, 14, 30, 160, 255, 255, 255, 255, 248, 81, 44, 48,
        255, 255, 255, 255, 248, 199, 197, 32, 255, 255, 255, 255, 250, 10, 210, 176, 255, 255,
        255, 255, 250, 168, 248, 160, 255, 255, 255, 255, 251, 236, 6, 48, 255, 255, 255, 255, 252,
        139, 125, 160, 0, 0, 0, 0, 29, 201, 142, 48, 0, 0, 0, 0, 30, 120, 215, 160, 0, 0, 0, 0, 31,
        160, 53, 176, 0, 0, 0, 0, 32, 51, 207, 160, 0, 0, 0, 0, 33, 129, 105, 48, 0, 0, 0, 0, 34,
        11, 200, 160, 0, 0, 0, 0, 35, 88, 16, 176, 0, 0, 0, 0, 35, 226, 112, 32, 0, 0, 0, 0, 37,
        55, 242, 176, 0, 0, 0, 0, 37, 212, 199, 32, 0, 0, 0, 0, 48, 128, 121, 48, 0, 0, 0, 0, 49,
        29, 77, 160, 0, 0, 0, 0, 55, 246, 198, 176, 0, 0, 0, 0, 56, 184, 133, 32, 0, 0, 0, 0, 57,
        223, 227, 48, 0, 0, 0, 0, 57, 242, 74, 32, 0, 0, 0, 0, 59, 200, 255, 176, 0, 0, 0, 0, 60,
        111, 14, 160, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 255, 255, 222, 132, 0, 0, 255, 255, 227, 224,
        1, 4, 255, 255, 213, 208, 0, 8, 76, 77, 84, 0, 45, 48, 50, 0, 45, 48, 51, 0, 10, 60, 45,
        48, 51, 62, 51, 10,
    ];
    pub(crate) const AmericaManagua: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        16, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 105, 135, 44, 100, 255, 255, 255, 255,
        189, 45, 72, 232, 0, 0, 0, 0, 6, 67, 116, 96, 0, 0, 0, 0, 9, 164, 62, 80, 0, 0, 0, 0, 17,
        81, 248, 224, 0, 0, 0, 0, 17, 212, 111, 80, 0, 0, 0, 0, 19, 49, 218, 224, 0, 0, 0, 0, 19,
        180, 81, 80, 0, 0, 0, 0, 41, 97, 145, 32, 0, 0, 0, 0, 42, 193, 75, 80, 0, 0, 0, 0, 43, 67,
        221, 224, 0, 0, 0, 0, 50, 201, 239, 80, 0, 0, 0, 0, 66, 88, 192, 224, 0, 0, 0, 0, 67, 63,
        105, 80, 0, 0, 0, 0, 68, 84, 110, 128, 0, 0, 0, 0, 69, 31, 89, 96, 1, 2, 3, 2, 4, 2, 4, 2,
        3, 2, 3, 2, 4, 2, 4, 2, 255, 255, 175, 28, 0, 0, 255, 255, 175, 24, 0, 4, 255, 255, 171,
        160, 0, 8, 255, 255, 185, 176, 0, 12, 255, 255, 185, 176, 1, 16, 76, 77, 84, 0, 77, 77, 84,
        0, 67, 83, 84, 0, 69, 83, 84, 0, 67, 68, 84, 0, 10, 67, 83, 84, 54, 10,
    ];
    pub(crate) const AmericaManaus: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        31, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 150, 170, 127, 68, 255, 255, 255, 255,
        184, 15, 87, 240, 255, 255, 255, 255, 184, 253, 78, 176, 255, 255, 255, 255, 185, 241, 66,
        64, 255, 255, 255, 255, 186, 222, 130, 48, 255, 255, 255, 255, 218, 56, 188, 64, 255, 255,
        255, 255, 218, 236, 8, 64, 255, 255, 255, 255, 220, 25, 239, 192, 255, 255, 255, 255, 220,
        185, 103, 48, 255, 255, 255, 255, 221, 251, 35, 64, 255, 255, 255, 255, 222, 155, 236, 48,
        255, 255, 255, 255, 223, 221, 168, 64, 255, 255, 255, 255, 224, 84, 65, 48, 255, 255, 255,
        255, 244, 152, 13, 192, 255, 255, 255, 255, 245, 5, 108, 48, 255, 255, 255, 255, 246, 192,
        114, 64, 255, 255, 255, 255, 247, 14, 44, 176, 255, 255, 255, 255, 248, 81, 58, 64, 255,
        255, 255, 255, 248, 199, 211, 48, 255, 255, 255, 255, 250, 10, 224, 192, 255, 255, 255,
        255, 250, 169, 6, 176, 255, 255, 255, 255, 251, 236, 20, 64, 255, 255, 255, 255, 252, 139,
        139, 176, 0, 0, 0, 0, 29, 201, 156, 64, 0, 0, 0, 0, 30, 120, 229, 176, 0, 0, 0, 0, 31, 160,
        67, 192, 0, 0, 0, 0, 32, 51, 221, 176, 0, 0, 0, 0, 33, 129, 119, 64, 0, 0, 0, 0, 34, 11,
        214, 176, 0, 0, 0, 0, 44, 192, 195, 64, 0, 0, 0, 0, 45, 102, 210, 48, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 255, 255, 199, 188,
        0, 0, 255, 255, 213, 208, 1, 4, 255, 255, 199, 192, 0, 8, 76, 77, 84, 0, 45, 48, 51, 0, 45,
        48, 52, 0, 10, 60, 45, 48, 52, 62, 52, 10,
    ];
    pub(crate) const AmericaMartinique: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        4, 0, 0, 0, 4, 0, 0, 0, 17, 255, 255, 255, 255, 105, 135, 20, 196, 255, 255, 255, 255, 145,
        163, 200, 68, 0, 0, 0, 0, 19, 77, 110, 64, 0, 0, 0, 0, 20, 52, 22, 176, 1, 2, 3, 2, 255,
        255, 198, 188, 0, 0, 255, 255, 198, 188, 0, 4, 255, 255, 199, 192, 0, 9, 255, 255, 213,
        208, 1, 13, 76, 77, 84, 0, 70, 70, 77, 84, 0, 65, 83, 84, 0, 65, 68, 84, 0, 10, 65, 83, 84,
        52, 10,
    ];
    pub(crate) const AmericaMatamoros: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        32, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 165, 182, 218, 96, 0, 0, 0, 0, 34, 85,
        241, 0, 0, 0, 0, 0, 35, 106, 189, 240, 0, 0, 0, 0, 49, 103, 118, 0, 0, 0, 0, 0, 50, 115, 8,
        112, 0, 0, 0, 0, 51, 71, 88, 0, 0, 0, 0, 0, 52, 82, 234, 112, 0, 0, 0, 0, 53, 39, 58, 0, 0,
        0, 0, 0, 54, 50, 204, 112, 0, 0, 0, 0, 55, 7, 28, 0, 0, 0, 0, 0, 56, 27, 232, 240, 0, 0, 0,
        0, 56, 230, 254, 0, 0, 0, 0, 0, 57, 251, 202, 240, 0, 0, 0, 0, 58, 245, 4, 128, 0, 0, 0, 0,
        59, 182, 194, 240, 0, 0, 0, 0, 60, 175, 252, 128, 0, 0, 0, 0, 61, 187, 142, 240, 0, 0, 0,
        0, 62, 143, 222, 128, 0, 0, 0, 0, 63, 155, 112, 240, 0, 0, 0, 0, 64, 111, 192, 128, 0, 0,
        0, 0, 65, 132, 141, 112, 0, 0, 0, 0, 66, 79, 162, 128, 0, 0, 0, 0, 67, 100, 111, 112, 0, 0,
        0, 0, 68, 47, 132, 128, 0, 0, 0, 0, 69, 68, 81, 112, 0, 0, 0, 0, 70, 15, 102, 128, 0, 0, 0,
        0, 71, 36, 51, 112, 0, 0, 0, 0, 71, 248, 131, 0, 0, 0, 0, 0, 73, 4, 21, 112, 0, 0, 0, 0,
        73, 216, 101, 0, 0, 0, 0, 0, 74, 227, 247, 112, 0, 0, 0, 0, 75, 156, 151, 128, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 255,
        255, 162, 64, 0, 0, 255, 255, 171, 160, 0, 4, 255, 255, 185, 176, 1, 8, 76, 77, 84, 0, 67,
        83, 84, 0, 67, 68, 84, 0, 10, 67, 83, 84, 54, 67, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44,
        77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaMazatlan: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        22, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 165, 182, 232, 112, 255, 255, 255, 255,
        175, 242, 110, 224, 255, 255, 255, 255, 182, 102, 86, 96, 255, 255, 255, 255, 183, 67, 210,
        96, 255, 255, 255, 255, 184, 12, 54, 96, 255, 255, 255, 255, 184, 253, 134, 240, 255, 255,
        255, 255, 203, 234, 113, 96, 255, 255, 255, 255, 216, 145, 180, 240, 0, 0, 0, 0, 0, 0, 112,
        128, 0, 0, 0, 0, 49, 103, 132, 16, 0, 0, 0, 0, 50, 115, 22, 128, 0, 0, 0, 0, 51, 71, 102,
        16, 0, 0, 0, 0, 52, 82, 248, 128, 0, 0, 0, 0, 53, 39, 72, 16, 0, 0, 0, 0, 54, 50, 218, 128,
        0, 0, 0, 0, 55, 7, 42, 16, 0, 0, 0, 0, 56, 27, 247, 0, 0, 0, 0, 0, 56, 231, 12, 16, 0, 0,
        0, 0, 57, 251, 217, 0, 0, 0, 0, 0, 58, 245, 18, 144, 0, 0, 0, 0, 59, 182, 209, 0, 0, 0, 0,
        0, 60, 176, 10, 144, 1, 2, 1, 2, 1, 2, 1, 3, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 255,
        255, 156, 60, 0, 0, 255, 255, 157, 144, 0, 4, 255, 255, 171, 160, 0, 8, 255, 255, 143, 128,
        0, 12, 255, 255, 171, 160, 1, 16, 76, 77, 84, 0, 77, 83, 84, 0, 67, 83, 84, 0, 80, 83, 84,
        0, 77, 68, 84, 0, 10, 77, 83, 84, 55, 77, 68, 84, 44, 77, 52, 46, 49, 46, 48, 44, 77, 49,
        48, 46, 53, 46, 48, 10,
    ];
    pub(crate) const AmericaMendoza: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        61, 0, 0, 0, 6, 0, 0, 0, 20, 255, 255, 255, 255, 114, 156, 178, 4, 255, 255, 255, 255, 162,
        146, 143, 48, 255, 255, 255, 255, 182, 123, 82, 64, 255, 255, 255, 255, 183, 26, 201, 176,
        255, 255, 255, 255, 184, 30, 143, 64, 255, 255, 255, 255, 184, 212, 112, 48, 255, 255, 255,
        255, 186, 23, 125, 192, 255, 255, 255, 255, 186, 181, 163, 176, 255, 255, 255, 255, 187,
        248, 177, 64, 255, 255, 255, 255, 188, 150, 215, 48, 255, 255, 255, 255, 189, 217, 228,
        192, 255, 255, 255, 255, 190, 120, 10, 176, 255, 255, 255, 255, 191, 187, 24, 64, 255, 255,
        255, 255, 192, 90, 143, 176, 255, 255, 255, 255, 193, 157, 157, 64, 255, 255, 255, 255,
        194, 59, 195, 48, 255, 255, 255, 255, 195, 126, 208, 192, 255, 255, 255, 255, 196, 28, 246,
        176, 255, 255, 255, 255, 197, 96, 4, 64, 255, 255, 255, 255, 197, 254, 42, 48, 255, 255,
        255, 255, 199, 65, 55, 192, 255, 255, 255, 255, 199, 224, 175, 48, 255, 255, 255, 255, 200,
        129, 148, 64, 255, 255, 255, 255, 202, 77, 161, 176, 255, 255, 255, 255, 202, 238, 134,
        192, 255, 255, 255, 255, 206, 77, 255, 48, 255, 255, 255, 255, 206, 176, 237, 192, 255,
        255, 255, 255, 211, 41, 53, 176, 255, 255, 255, 255, 212, 67, 100, 192, 255, 255, 255, 255,
        244, 61, 8, 48, 255, 255, 255, 255, 244, 159, 246, 192, 255, 255, 255, 255, 245, 5, 108,
        48, 255, 255, 255, 255, 246, 50, 16, 64, 255, 255, 255, 255, 246, 230, 159, 176, 255, 255,
        255, 255, 248, 19, 67, 192, 255, 255, 255, 255, 248, 199, 211, 48, 255, 255, 255, 255, 249,
        244, 119, 64, 255, 255, 255, 255, 250, 211, 54, 176, 255, 255, 255, 255, 251, 195, 53, 192,
        255, 255, 255, 255, 252, 188, 83, 48, 255, 255, 255, 255, 253, 172, 82, 64, 255, 255, 255,
        255, 254, 156, 53, 48, 255, 255, 255, 255, 255, 140, 52, 64, 0, 0, 0, 0, 7, 163, 74, 176,
        0, 0, 0, 0, 8, 36, 111, 160, 0, 0, 0, 0, 35, 148, 181, 176, 0, 0, 0, 0, 36, 16, 148, 160,
        0, 0, 0, 0, 37, 55, 242, 176, 0, 0, 0, 0, 37, 240, 118, 160, 0, 0, 0, 0, 39, 25, 52, 64, 0,
        0, 0, 0, 39, 205, 195, 176, 0, 0, 0, 0, 40, 250, 103, 192, 0, 0, 0, 0, 41, 176, 72, 176, 0,
        0, 0, 0, 42, 224, 225, 64, 0, 0, 0, 0, 43, 153, 87, 32, 0, 0, 0, 0, 55, 246, 198, 176, 0,
        0, 0, 0, 56, 191, 42, 176, 0, 0, 0, 0, 64, 176, 19, 176, 0, 0, 0, 0, 65, 86, 62, 192, 0, 0,
        0, 0, 71, 119, 9, 176, 0, 0, 0, 0, 71, 220, 127, 32, 1, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 5,
        4, 5, 4, 5, 4, 2, 3, 2, 3, 2, 4, 5, 3, 5, 2, 5, 4, 5, 255, 255, 191, 124, 0, 0, 255, 255,
        195, 208, 0, 4, 255, 255, 199, 192, 0, 8, 255, 255, 213, 208, 1, 12, 255, 255, 227, 224, 1,
        16, 255, 255, 213, 208, 0, 12, 76, 77, 84, 0, 67, 77, 84, 0, 45, 48, 52, 0, 45, 48, 51, 0,
        45, 48, 50, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AmericaMenominee: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        82, 0, 0, 0, 6, 0, 0, 0, 24, 255, 255, 255, 255, 97, 119, 73, 99, 255, 255, 255, 255, 158,
        166, 44, 128, 255, 255, 255, 255, 159, 186, 249, 112, 255, 255, 255, 255, 160, 134, 14,
        128, 255, 255, 255, 255, 161, 154, 219, 112, 255, 255, 255, 255, 203, 136, 254, 128, 255,
        255, 255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 97, 9, 240, 255, 255, 255, 255,
        211, 117, 243, 0, 255, 255, 255, 255, 212, 64, 235, 240, 255, 255, 255, 255, 249, 15, 74,
        128, 255, 255, 255, 255, 250, 8, 103, 240, 255, 255, 255, 255, 254, 184, 43, 0, 0, 0, 0, 0,
        6, 64, 223, 112, 0, 0, 0, 0, 7, 48, 208, 112, 0, 0, 0, 0, 7, 141, 39, 128, 0, 0, 0, 0, 9,
        16, 178, 112, 0, 0, 0, 0, 9, 173, 163, 0, 0, 0, 0, 0, 10, 240, 148, 112, 0, 0, 0, 0, 11,
        224, 147, 128, 0, 0, 0, 0, 12, 217, 176, 240, 0, 0, 0, 0, 13, 192, 117, 128, 0, 0, 0, 0,
        14, 185, 146, 240, 0, 0, 0, 0, 15, 169, 146, 0, 0, 0, 0, 0, 16, 153, 116, 240, 0, 0, 0, 0,
        17, 137, 116, 0, 0, 0, 0, 0, 18, 121, 86, 240, 0, 0, 0, 0, 19, 105, 86, 0, 0, 0, 0, 0, 20,
        89, 56, 240, 0, 0, 0, 0, 21, 73, 56, 0, 0, 0, 0, 0, 22, 57, 26, 240, 0, 0, 0, 0, 23, 41,
        26, 0, 0, 0, 0, 0, 24, 34, 55, 112, 0, 0, 0, 0, 25, 8, 252, 0, 0, 0, 0, 0, 26, 2, 25, 112,
        0, 0, 0, 0, 26, 242, 24, 128, 0, 0, 0, 0, 27, 225, 251, 112, 0, 0, 0, 0, 28, 209, 250, 128,
        0, 0, 0, 0, 29, 193, 221, 112, 0, 0, 0, 0, 30, 177, 220, 128, 0, 0, 0, 0, 31, 161, 191,
        112, 0, 0, 0, 0, 32, 118, 15, 0, 0, 0, 0, 0, 33, 129, 161, 112, 0, 0, 0, 0, 34, 85, 241, 0,
        0, 0, 0, 0, 35, 106, 189, 240, 0, 0, 0, 0, 36, 53, 211, 0, 0, 0, 0, 0, 37, 74, 159, 240, 0,
        0, 0, 0, 38, 21, 181, 0, 0, 0, 0, 0, 39, 42, 129, 240, 0, 0, 0, 0, 39, 254, 209, 128, 0, 0,
        0, 0, 41, 10, 99, 240, 0, 0, 0, 0, 41, 222, 179, 128, 0, 0, 0, 0, 42, 234, 69, 240, 0, 0,
        0, 0, 43, 190, 149, 128, 0, 0, 0, 0, 44, 211, 98, 112, 0, 0, 0, 0, 45, 158, 119, 128, 0, 0,
        0, 0, 46, 179, 68, 112, 0, 0, 0, 0, 47, 126, 89, 128, 0, 0, 0, 0, 48, 147, 38, 112, 0, 0,
        0, 0, 49, 103, 118, 0, 0, 0, 0, 0, 50, 115, 8, 112, 0, 0, 0, 0, 51, 71, 88, 0, 0, 0, 0, 0,
        52, 82, 234, 112, 0, 0, 0, 0, 53, 39, 58, 0, 0, 0, 0, 0, 54, 50, 204, 112, 0, 0, 0, 0, 55,
        7, 28, 0, 0, 0, 0, 0, 56, 27, 232, 240, 0, 0, 0, 0, 56, 230, 254, 0, 0, 0, 0, 0, 57, 251,
        202, 240, 0, 0, 0, 0, 58, 198, 224, 0, 0, 0, 0, 0, 59, 219, 172, 240, 0, 0, 0, 0, 60, 175,
        252, 128, 0, 0, 0, 0, 61, 187, 142, 240, 0, 0, 0, 0, 62, 143, 222, 128, 0, 0, 0, 0, 63,
        155, 112, 240, 0, 0, 0, 0, 64, 111, 192, 128, 0, 0, 0, 0, 65, 132, 141, 112, 0, 0, 0, 0,
        66, 79, 162, 128, 0, 0, 0, 0, 67, 100, 111, 112, 0, 0, 0, 0, 68, 47, 132, 128, 0, 0, 0, 0,
        69, 68, 81, 112, 0, 0, 0, 0, 69, 243, 183, 0, 2, 1, 2, 1, 2, 3, 4, 2, 1, 2, 1, 2, 5, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 255, 255, 173, 221, 0, 0, 255, 255, 185, 176, 1, 4, 255, 255, 171,
        160, 0, 8, 255, 255, 185, 176, 1, 12, 255, 255, 185, 176, 1, 16, 255, 255, 185, 176, 0, 20,
        76, 77, 84, 0, 67, 68, 84, 0, 67, 83, 84, 0, 67, 87, 84, 0, 67, 80, 84, 0, 69, 83, 84, 0,
        10, 67, 83, 84, 54, 67, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48,
        10,
    ];
    pub(crate) const AmericaMerida: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        16, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 165, 182, 218, 96, 0, 0, 0, 0, 22, 134,
        213, 96, 0, 0, 0, 0, 24, 76, 75, 80, 0, 0, 0, 0, 49, 103, 118, 0, 0, 0, 0, 0, 50, 115, 8,
        112, 0, 0, 0, 0, 51, 71, 88, 0, 0, 0, 0, 0, 52, 82, 234, 112, 0, 0, 0, 0, 53, 39, 58, 0, 0,
        0, 0, 0, 54, 50, 204, 112, 0, 0, 0, 0, 55, 7, 28, 0, 0, 0, 0, 0, 56, 27, 232, 240, 0, 0, 0,
        0, 56, 230, 254, 0, 0, 0, 0, 0, 57, 251, 202, 240, 0, 0, 0, 0, 58, 245, 4, 128, 0, 0, 0, 0,
        59, 182, 194, 240, 0, 0, 0, 0, 60, 175, 252, 128, 1, 2, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3,
        1, 3, 255, 255, 171, 252, 0, 0, 255, 255, 171, 160, 0, 4, 255, 255, 185, 176, 0, 8, 255,
        255, 185, 176, 1, 12, 76, 77, 84, 0, 67, 83, 84, 0, 69, 83, 84, 0, 67, 68, 84, 0, 10, 67,
        83, 84, 54, 67, 68, 84, 44, 77, 52, 46, 49, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48, 10,
    ];
    pub(crate) const AmericaMetlakatla: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        44, 0, 0, 0, 8, 0, 0, 0, 30, 255, 255, 255, 255, 63, 194, 253, 209, 255, 255, 255, 255,
        125, 135, 48, 26, 255, 255, 255, 255, 203, 137, 26, 160, 255, 255, 255, 255, 210, 35, 244,
        112, 255, 255, 255, 255, 210, 97, 38, 16, 255, 255, 255, 255, 254, 184, 71, 32, 255, 255,
        255, 255, 255, 168, 42, 16, 0, 0, 0, 0, 0, 152, 41, 32, 0, 0, 0, 0, 1, 136, 12, 16, 0, 0,
        0, 0, 2, 120, 11, 32, 0, 0, 0, 0, 3, 113, 40, 144, 0, 0, 0, 0, 4, 97, 39, 160, 0, 0, 0, 0,
        5, 81, 10, 144, 0, 0, 0, 0, 6, 65, 9, 160, 0, 0, 0, 0, 7, 48, 236, 144, 0, 0, 0, 0, 7, 141,
        67, 160, 0, 0, 0, 0, 9, 16, 206, 144, 0, 0, 0, 0, 9, 173, 191, 32, 0, 0, 0, 0, 10, 240,
        176, 144, 0, 0, 0, 0, 11, 224, 175, 160, 0, 0, 0, 0, 12, 217, 205, 16, 0, 0, 0, 0, 13, 192,
        145, 160, 0, 0, 0, 0, 14, 185, 175, 16, 0, 0, 0, 0, 15, 169, 174, 32, 0, 0, 0, 0, 16, 153,
        145, 16, 0, 0, 0, 0, 17, 137, 144, 32, 0, 0, 0, 0, 18, 121, 115, 16, 0, 0, 0, 0, 19, 105,
        114, 32, 0, 0, 0, 0, 20, 89, 85, 16, 0, 0, 0, 0, 21, 73, 84, 32, 0, 0, 0, 0, 22, 57, 55,
        16, 0, 0, 0, 0, 23, 41, 54, 32, 0, 0, 0, 0, 24, 34, 83, 144, 0, 0, 0, 0, 25, 9, 24, 32, 0,
        0, 0, 0, 26, 2, 53, 144, 0, 0, 0, 0, 86, 53, 226, 160, 0, 0, 0, 0, 86, 229, 72, 48, 0, 0,
        0, 0, 88, 30, 255, 32, 0, 0, 0, 0, 88, 197, 42, 48, 0, 0, 0, 0, 89, 254, 225, 32, 0, 0, 0,
        0, 90, 165, 12, 48, 0, 0, 0, 0, 91, 222, 195, 32, 0, 0, 0, 0, 92, 68, 70, 160, 0, 0, 0, 0,
        92, 132, 238, 48, 1, 2, 3, 4, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5,
        2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 6, 7, 6, 7, 6, 7, 2, 6, 7, 0, 0, 214, 38, 0, 0, 255, 255,
        132, 166, 0, 0, 255, 255, 143, 128, 0, 4, 255, 255, 157, 144, 1, 8, 255, 255, 157, 144, 1,
        12, 255, 255, 157, 144, 1, 16, 255, 255, 129, 112, 0, 20, 255, 255, 143, 128, 1, 25, 76,
        77, 84, 0, 80, 83, 84, 0, 80, 87, 84, 0, 80, 80, 84, 0, 80, 68, 84, 0, 65, 75, 83, 84, 0,
        65, 75, 68, 84, 0, 10, 65, 75, 83, 84, 57, 65, 75, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44,
        77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaMexicoCity: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        27, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 165, 182, 232, 112, 255, 255, 255, 255,
        175, 242, 110, 224, 255, 255, 255, 255, 182, 102, 86, 96, 255, 255, 255, 255, 183, 67, 210,
        96, 255, 255, 255, 255, 184, 12, 54, 96, 255, 255, 255, 255, 184, 253, 134, 240, 255, 255,
        255, 255, 197, 222, 176, 96, 255, 255, 255, 255, 198, 151, 52, 80, 255, 255, 255, 255, 201,
        85, 241, 224, 255, 255, 255, 255, 201, 234, 221, 80, 255, 255, 255, 255, 207, 2, 198, 224,
        255, 255, 255, 255, 207, 183, 86, 80, 255, 255, 255, 255, 218, 153, 21, 224, 255, 255, 255,
        255, 219, 118, 131, 208, 0, 0, 0, 0, 49, 103, 118, 0, 0, 0, 0, 0, 50, 115, 8, 112, 0, 0, 0,
        0, 51, 71, 88, 0, 0, 0, 0, 0, 52, 82, 234, 112, 0, 0, 0, 0, 53, 39, 58, 0, 0, 0, 0, 0, 54,
        50, 204, 112, 0, 0, 0, 0, 55, 7, 28, 0, 0, 0, 0, 0, 56, 27, 232, 240, 0, 0, 0, 0, 56, 230,
        254, 0, 0, 0, 0, 0, 57, 251, 202, 240, 0, 0, 0, 0, 58, 245, 4, 128, 0, 0, 0, 0, 59, 182,
        194, 240, 0, 0, 0, 0, 60, 175, 252, 128, 1, 2, 1, 2, 1, 2, 3, 2, 3, 2, 4, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 255, 255, 163, 12, 0, 0, 255, 255, 157, 144, 0, 4, 255, 255,
        171, 160, 0, 8, 255, 255, 185, 176, 1, 12, 255, 255, 185, 176, 1, 16, 76, 77, 84, 0, 77,
        83, 84, 0, 67, 83, 84, 0, 67, 68, 84, 0, 67, 87, 84, 0, 10, 67, 83, 84, 54, 67, 68, 84, 44,
        77, 52, 46, 49, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48, 10,
    ];
    pub(crate) const AmericaMiquelon: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        43, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 145, 182, 56, 168, 0, 0, 0, 0, 19, 110,
        99, 192, 0, 0, 0, 0, 32, 117, 228, 208, 0, 0, 0, 0, 33, 129, 119, 64, 0, 0, 0, 0, 34, 85,
        198, 208, 0, 0, 0, 0, 35, 106, 147, 192, 0, 0, 0, 0, 36, 53, 168, 208, 0, 0, 0, 0, 37, 74,
        117, 192, 0, 0, 0, 0, 38, 21, 138, 208, 0, 0, 0, 0, 39, 42, 87, 192, 0, 0, 0, 0, 39, 254,
        167, 80, 0, 0, 0, 0, 41, 10, 57, 192, 0, 0, 0, 0, 41, 222, 137, 80, 0, 0, 0, 0, 42, 234,
        27, 192, 0, 0, 0, 0, 43, 190, 107, 80, 0, 0, 0, 0, 44, 211, 56, 64, 0, 0, 0, 0, 45, 158,
        77, 80, 0, 0, 0, 0, 46, 179, 26, 64, 0, 0, 0, 0, 47, 126, 47, 80, 0, 0, 0, 0, 48, 146, 252,
        64, 0, 0, 0, 0, 49, 103, 75, 208, 0, 0, 0, 0, 50, 114, 222, 64, 0, 0, 0, 0, 51, 71, 45,
        208, 0, 0, 0, 0, 52, 82, 192, 64, 0, 0, 0, 0, 53, 39, 15, 208, 0, 0, 0, 0, 54, 50, 162, 64,
        0, 0, 0, 0, 55, 6, 241, 208, 0, 0, 0, 0, 56, 27, 190, 192, 0, 0, 0, 0, 56, 230, 211, 208,
        0, 0, 0, 0, 57, 251, 160, 192, 0, 0, 0, 0, 58, 198, 181, 208, 0, 0, 0, 0, 59, 219, 130,
        192, 0, 0, 0, 0, 60, 175, 210, 80, 0, 0, 0, 0, 61, 187, 100, 192, 0, 0, 0, 0, 62, 143, 180,
        80, 0, 0, 0, 0, 63, 155, 70, 192, 0, 0, 0, 0, 64, 111, 150, 80, 0, 0, 0, 0, 65, 132, 99,
        64, 0, 0, 0, 0, 66, 79, 120, 80, 0, 0, 0, 0, 67, 100, 69, 64, 0, 0, 0, 0, 68, 47, 90, 80,
        0, 0, 0, 0, 69, 68, 39, 64, 0, 0, 0, 0, 69, 243, 140, 208, 1, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 255, 255, 203, 88, 0, 0, 255, 255, 199, 192, 0, 4, 255, 255, 213, 208, 0, 8, 255,
        255, 227, 224, 1, 12, 76, 77, 84, 0, 65, 83, 84, 0, 45, 48, 51, 0, 45, 48, 50, 0, 10, 60,
        45, 48, 51, 62, 51, 60, 45, 48, 50, 62, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49,
        46, 48, 10,
    ];
    pub(crate) const AmericaMoncton: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        146, 0, 0, 0, 6, 0, 0, 0, 24, 255, 255, 255, 255, 94, 30, 237, 188, 255, 255, 255, 255,
        128, 241, 182, 80, 255, 255, 255, 255, 158, 184, 133, 96, 255, 255, 255, 255, 159, 186,
        221, 80, 255, 255, 255, 255, 187, 60, 56, 208, 255, 255, 255, 255, 187, 180, 35, 64, 255,
        255, 255, 255, 189, 28, 26, 208, 255, 255, 255, 255, 189, 148, 5, 64, 255, 255, 255, 255,
        190, 251, 252, 208, 255, 255, 255, 255, 191, 115, 231, 64, 255, 255, 255, 255, 192, 219,
        222, 208, 255, 255, 255, 255, 193, 83, 201, 64, 255, 255, 255, 255, 194, 187, 192, 208,
        255, 255, 255, 255, 195, 51, 171, 64, 255, 255, 255, 255, 196, 155, 162, 208, 255, 255,
        255, 255, 197, 19, 141, 64, 255, 255, 255, 255, 198, 112, 248, 208, 255, 255, 255, 255,
        199, 13, 205, 64, 255, 255, 255, 255, 200, 72, 241, 208, 255, 255, 255, 255, 200, 237, 175,
        64, 255, 255, 255, 255, 202, 22, 94, 208, 255, 255, 255, 255, 202, 214, 203, 192, 255, 255,
        255, 255, 203, 136, 226, 96, 255, 255, 255, 255, 210, 35, 244, 112, 255, 255, 255, 255,
        210, 96, 237, 208, 255, 255, 255, 255, 211, 117, 214, 224, 255, 255, 255, 255, 212, 64,
        207, 208, 255, 255, 255, 255, 213, 85, 184, 224, 255, 255, 255, 255, 214, 32, 177, 208,
        255, 255, 255, 255, 215, 53, 154, 224, 255, 255, 255, 255, 216, 0, 147, 208, 255, 255, 255,
        255, 217, 21, 124, 224, 255, 255, 255, 255, 217, 224, 117, 208, 255, 255, 255, 255, 218,
        254, 153, 96, 255, 255, 255, 255, 219, 192, 87, 208, 255, 255, 255, 255, 220, 222, 123, 96,
        255, 255, 255, 255, 221, 169, 116, 80, 255, 255, 255, 255, 222, 190, 93, 96, 255, 255, 255,
        255, 223, 137, 86, 80, 255, 255, 255, 255, 224, 158, 63, 96, 255, 255, 255, 255, 225, 105,
        56, 80, 255, 255, 255, 255, 226, 126, 33, 96, 255, 255, 255, 255, 227, 73, 26, 80, 255,
        255, 255, 255, 228, 94, 3, 96, 255, 255, 255, 255, 229, 40, 252, 80, 255, 255, 255, 255,
        230, 71, 31, 224, 255, 255, 255, 255, 231, 18, 24, 208, 255, 255, 255, 255, 232, 39, 1,
        224, 255, 255, 255, 255, 233, 22, 228, 208, 255, 255, 255, 255, 234, 6, 227, 224, 255, 255,
        255, 255, 234, 246, 198, 208, 255, 255, 255, 255, 235, 230, 197, 224, 255, 255, 255, 255,
        236, 214, 168, 208, 255, 255, 255, 255, 237, 198, 167, 224, 255, 255, 255, 255, 238, 191,
        197, 80, 255, 255, 255, 255, 239, 175, 196, 96, 255, 255, 255, 255, 240, 159, 167, 80, 255,
        255, 255, 255, 241, 143, 166, 96, 255, 255, 255, 255, 242, 127, 137, 80, 255, 255, 255,
        255, 243, 111, 136, 96, 255, 255, 255, 255, 244, 95, 107, 80, 255, 255, 255, 255, 245, 79,
        106, 96, 255, 255, 255, 255, 246, 63, 77, 80, 255, 255, 255, 255, 247, 47, 76, 96, 255,
        255, 255, 255, 248, 40, 105, 208, 255, 255, 255, 255, 249, 15, 46, 96, 255, 255, 255, 255,
        250, 8, 75, 208, 255, 255, 255, 255, 250, 248, 74, 224, 255, 255, 255, 255, 251, 232, 45,
        208, 255, 255, 255, 255, 252, 216, 44, 224, 255, 255, 255, 255, 253, 200, 15, 208, 255,
        255, 255, 255, 254, 184, 14, 224, 255, 255, 255, 255, 255, 167, 241, 208, 0, 0, 0, 0, 0,
        151, 240, 224, 0, 0, 0, 0, 1, 135, 211, 208, 0, 0, 0, 0, 2, 119, 210, 224, 0, 0, 0, 0, 3,
        112, 240, 80, 0, 0, 0, 0, 4, 96, 239, 96, 0, 0, 0, 0, 5, 80, 210, 80, 0, 0, 0, 0, 8, 32,
        179, 96, 0, 0, 0, 0, 9, 16, 150, 80, 0, 0, 0, 0, 10, 0, 149, 96, 0, 0, 0, 0, 10, 240, 120,
        80, 0, 0, 0, 0, 11, 224, 119, 96, 0, 0, 0, 0, 12, 217, 148, 208, 0, 0, 0, 0, 13, 192, 89,
        96, 0, 0, 0, 0, 14, 185, 118, 208, 0, 0, 0, 0, 15, 169, 117, 224, 0, 0, 0, 0, 16, 153, 88,
        208, 0, 0, 0, 0, 17, 137, 87, 224, 0, 0, 0, 0, 18, 121, 58, 208, 0, 0, 0, 0, 19, 105, 57,
        224, 0, 0, 0, 0, 20, 89, 28, 208, 0, 0, 0, 0, 21, 73, 27, 224, 0, 0, 0, 0, 22, 56, 254,
        208, 0, 0, 0, 0, 23, 40, 253, 224, 0, 0, 0, 0, 24, 34, 27, 80, 0, 0, 0, 0, 25, 8, 223, 224,
        0, 0, 0, 0, 26, 1, 253, 80, 0, 0, 0, 0, 26, 241, 252, 96, 0, 0, 0, 0, 27, 225, 223, 80, 0,
        0, 0, 0, 28, 209, 222, 96, 0, 0, 0, 0, 29, 193, 193, 80, 0, 0, 0, 0, 30, 177, 192, 96, 0,
        0, 0, 0, 31, 161, 163, 80, 0, 0, 0, 0, 32, 117, 242, 224, 0, 0, 0, 0, 33, 129, 133, 80, 0,
        0, 0, 0, 34, 85, 212, 224, 0, 0, 0, 0, 35, 106, 161, 208, 0, 0, 0, 0, 36, 53, 182, 224, 0,
        0, 0, 0, 37, 74, 131, 208, 0, 0, 0, 0, 38, 21, 152, 224, 0, 0, 0, 0, 39, 42, 101, 208, 0,
        0, 0, 0, 39, 254, 181, 96, 0, 0, 0, 0, 41, 10, 71, 208, 0, 0, 0, 0, 41, 222, 151, 96, 0, 0,
        0, 0, 42, 234, 41, 208, 0, 0, 0, 0, 43, 190, 93, 124, 0, 0, 0, 0, 44, 211, 42, 108, 0, 0,
        0, 0, 45, 158, 63, 124, 0, 0, 0, 0, 46, 179, 12, 108, 0, 0, 0, 0, 47, 126, 33, 124, 0, 0,
        0, 0, 48, 146, 238, 108, 0, 0, 0, 0, 49, 103, 61, 252, 0, 0, 0, 0, 50, 114, 208, 108, 0, 0,
        0, 0, 51, 71, 31, 252, 0, 0, 0, 0, 52, 82, 178, 108, 0, 0, 0, 0, 53, 39, 1, 252, 0, 0, 0,
        0, 54, 50, 148, 108, 0, 0, 0, 0, 55, 6, 227, 252, 0, 0, 0, 0, 56, 27, 176, 236, 0, 0, 0, 0,
        56, 230, 197, 252, 0, 0, 0, 0, 57, 251, 146, 236, 0, 0, 0, 0, 58, 198, 167, 252, 0, 0, 0,
        0, 59, 219, 116, 236, 0, 0, 0, 0, 60, 175, 196, 124, 0, 0, 0, 0, 61, 187, 86, 236, 0, 0, 0,
        0, 62, 143, 166, 124, 0, 0, 0, 0, 63, 155, 56, 236, 0, 0, 0, 0, 64, 111, 136, 124, 0, 0, 0,
        0, 65, 132, 85, 108, 0, 0, 0, 0, 66, 79, 106, 124, 0, 0, 0, 0, 67, 100, 55, 108, 0, 0, 0,
        0, 68, 47, 76, 124, 0, 0, 0, 0, 69, 68, 25, 108, 0, 0, 0, 0, 69, 243, 154, 224, 1, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 5, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 255, 255, 195, 68, 0, 0,
        255, 255, 185, 176, 0, 4, 255, 255, 213, 208, 1, 8, 255, 255, 199, 192, 0, 12, 255, 255,
        213, 208, 1, 16, 255, 255, 213, 208, 1, 20, 76, 77, 84, 0, 69, 83, 84, 0, 65, 68, 84, 0,
        65, 83, 84, 0, 65, 87, 84, 0, 65, 80, 84, 0, 10, 65, 83, 84, 52, 65, 68, 84, 44, 77, 51,
        46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaMonterrey: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        16, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 165, 182, 218, 96, 0, 0, 0, 0, 34, 85,
        241, 0, 0, 0, 0, 0, 35, 106, 189, 240, 0, 0, 0, 0, 49, 103, 118, 0, 0, 0, 0, 0, 50, 115, 8,
        112, 0, 0, 0, 0, 51, 71, 88, 0, 0, 0, 0, 0, 52, 82, 234, 112, 0, 0, 0, 0, 53, 39, 58, 0, 0,
        0, 0, 0, 54, 50, 204, 112, 0, 0, 0, 0, 55, 7, 28, 0, 0, 0, 0, 0, 56, 27, 232, 240, 0, 0, 0,
        0, 56, 230, 254, 0, 0, 0, 0, 0, 57, 251, 202, 240, 0, 0, 0, 0, 58, 245, 4, 128, 0, 0, 0, 0,
        59, 182, 194, 240, 0, 0, 0, 0, 60, 175, 252, 128, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 255, 255, 161, 244, 0, 0, 255, 255, 171, 160, 0, 4, 255, 255, 185, 176, 1, 8, 76, 77,
        84, 0, 67, 83, 84, 0, 67, 68, 84, 0, 10, 67, 83, 84, 54, 67, 68, 84, 44, 77, 52, 46, 49,
        46, 48, 44, 77, 49, 48, 46, 53, 46, 48, 10,
    ];
    pub(crate) const AmericaMontevideo: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        86, 0, 0, 0, 9, 0, 0, 0, 38, 255, 255, 255, 255, 140, 52, 229, 51, 255, 255, 255, 255, 162,
        146, 135, 179, 255, 255, 255, 255, 168, 255, 219, 64, 255, 255, 255, 255, 169, 241, 15,
        176, 255, 255, 255, 255, 170, 226, 89, 56, 255, 255, 255, 255, 171, 210, 67, 48, 255, 255,
        255, 255, 172, 195, 140, 184, 255, 255, 255, 255, 173, 179, 118, 176, 255, 255, 255, 255,
        187, 244, 181, 184, 255, 255, 255, 255, 188, 191, 181, 176, 255, 255, 255, 255, 189, 212,
        151, 184, 255, 255, 255, 255, 190, 159, 151, 176, 255, 255, 255, 255, 191, 180, 121, 184,
        255, 255, 255, 255, 192, 127, 121, 176, 255, 255, 255, 255, 193, 148, 91, 184, 255, 255,
        255, 255, 194, 95, 91, 176, 255, 255, 255, 255, 195, 125, 120, 56, 255, 255, 255, 255, 196,
        63, 61, 176, 255, 255, 255, 255, 197, 93, 90, 56, 255, 255, 255, 255, 198, 31, 31, 176,
        255, 255, 255, 255, 199, 24, 82, 56, 255, 255, 255, 255, 200, 8, 60, 48, 255, 255, 255,
        255, 201, 29, 30, 56, 255, 255, 255, 255, 201, 232, 30, 48, 255, 255, 255, 255, 202, 139,
        159, 56, 255, 255, 255, 255, 205, 30, 198, 48, 255, 255, 255, 255, 205, 149, 102, 40, 255,
        255, 255, 255, 236, 11, 133, 176, 255, 255, 255, 255, 236, 242, 53, 40, 255, 255, 255, 255,
        237, 69, 74, 176, 255, 255, 255, 255, 237, 133, 214, 32, 255, 255, 255, 255, 247, 19, 114,
        176, 255, 255, 255, 255, 247, 250, 27, 32, 255, 255, 255, 255, 252, 254, 62, 48, 255, 255,
        255, 255, 253, 246, 17, 40, 0, 0, 0, 0, 0, 150, 117, 48, 0, 0, 0, 0, 0, 216, 82, 32, 0, 0,
        0, 0, 4, 87, 138, 176, 0, 0, 0, 0, 4, 198, 58, 160, 0, 0, 0, 0, 7, 150, 27, 176, 0, 0, 0,
        0, 7, 223, 218, 152, 0, 0, 0, 0, 8, 198, 159, 40, 0, 0, 0, 0, 9, 90, 78, 48, 0, 0, 0, 0, 9,
        219, 115, 32, 0, 0, 0, 0, 13, 26, 18, 48, 0, 0, 0, 0, 13, 127, 135, 160, 0, 0, 0, 0, 14,
        231, 127, 48, 0, 0, 0, 0, 15, 95, 105, 160, 0, 0, 0, 0, 16, 217, 214, 48, 0, 0, 0, 0, 17,
        63, 75, 160, 0, 0, 0, 0, 17, 137, 45, 176, 0, 0, 0, 0, 19, 49, 162, 160, 0, 0, 0, 0, 33,
        195, 84, 48, 0, 0, 0, 0, 34, 39, 120, 32, 0, 0, 0, 0, 35, 161, 228, 176, 0, 0, 0, 0, 36,
        16, 148, 160, 0, 0, 0, 0, 37, 74, 103, 176, 0, 0, 0, 0, 37, 231, 60, 32, 0, 0, 0, 0, 39,
        33, 15, 48, 0, 0, 0, 0, 39, 208, 88, 160, 0, 0, 0, 0, 41, 10, 43, 176, 0, 0, 0, 0, 41, 176,
        58, 160, 0, 0, 0, 0, 42, 224, 211, 48, 0, 0, 0, 0, 43, 144, 28, 160, 0, 0, 0, 0, 65, 76,
        246, 48, 0, 0, 0, 0, 66, 70, 47, 192, 0, 0, 0, 0, 67, 72, 163, 208, 0, 0, 0, 0, 68, 19,
        156, 192, 0, 0, 0, 0, 69, 31, 75, 80, 0, 0, 0, 0, 69, 243, 126, 192, 0, 0, 0, 0, 71, 8,
        103, 208, 0, 0, 0, 0, 71, 211, 96, 192, 0, 0, 0, 0, 72, 232, 73, 208, 0, 0, 0, 0, 73, 179,
        66, 192, 0, 0, 0, 0, 74, 200, 43, 208, 0, 0, 0, 0, 75, 156, 95, 64, 0, 0, 0, 0, 76, 168,
        13, 208, 0, 0, 0, 0, 77, 124, 65, 64, 0, 0, 0, 0, 78, 135, 239, 208, 0, 0, 0, 0, 79, 92,
        35, 64, 0, 0, 0, 0, 80, 113, 12, 80, 0, 0, 0, 0, 81, 60, 5, 64, 0, 0, 0, 0, 82, 80, 238,
        80, 0, 0, 0, 0, 83, 27, 231, 64, 0, 0, 0, 0, 84, 48, 208, 80, 0, 0, 0, 0, 84, 251, 201, 64,
        1, 2, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 6, 5, 6, 5, 7,
        5, 7, 5, 6, 5, 7, 5, 7, 5, 8, 6, 5, 7, 5, 7, 5, 7, 5, 7, 5, 7, 5, 7, 5, 7, 5, 7, 5, 7, 5,
        7, 5, 7, 5, 7, 5, 7, 5, 7, 5, 7, 5, 7, 5, 7, 5, 7, 5, 7, 5, 7, 5, 7, 5, 7, 5, 255, 255,
        203, 77, 0, 0, 255, 255, 203, 77, 0, 4, 255, 255, 199, 192, 0, 8, 255, 255, 206, 200, 0,
        12, 255, 255, 213, 208, 1, 18, 255, 255, 213, 208, 0, 18, 255, 255, 220, 216, 1, 22, 255,
        255, 227, 224, 1, 28, 255, 255, 234, 232, 1, 32, 76, 77, 84, 0, 77, 77, 84, 0, 45, 48, 52,
        0, 45, 48, 51, 51, 48, 0, 45, 48, 51, 0, 45, 48, 50, 51, 48, 0, 45, 48, 50, 0, 45, 48, 49,
        51, 48, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AmericaMontreal: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        172, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 114, 238, 120, 236, 255, 255, 255, 255,
        158, 184, 147, 112, 255, 255, 255, 255, 159, 186, 235, 96, 255, 255, 255, 255, 160, 135,
        46, 200, 255, 255, 255, 255, 161, 154, 177, 64, 255, 255, 255, 255, 162, 148, 6, 240, 255,
        255, 255, 255, 163, 85, 169, 64, 255, 255, 255, 255, 164, 134, 93, 240, 255, 255, 255, 255,
        165, 40, 120, 96, 255, 255, 255, 255, 166, 102, 63, 240, 255, 255, 255, 255, 167, 12, 78,
        224, 255, 255, 255, 255, 168, 70, 33, 240, 255, 255, 255, 255, 168, 236, 48, 224, 255, 255,
        255, 255, 170, 28, 201, 112, 255, 255, 255, 255, 170, 213, 77, 96, 255, 255, 255, 255, 171,
        252, 171, 112, 255, 255, 255, 255, 172, 181, 47, 96, 255, 255, 255, 255, 173, 220, 141,
        112, 255, 255, 255, 255, 174, 149, 17, 96, 255, 255, 255, 255, 175, 188, 111, 112, 255,
        255, 255, 255, 176, 126, 45, 224, 255, 255, 255, 255, 177, 156, 81, 112, 255, 255, 255,
        255, 178, 103, 74, 96, 255, 255, 255, 255, 179, 124, 51, 112, 255, 255, 255, 255, 180, 71,
        44, 96, 255, 255, 255, 255, 181, 92, 21, 112, 255, 255, 255, 255, 182, 39, 14, 96, 255,
        255, 255, 255, 183, 59, 247, 112, 255, 255, 255, 255, 184, 6, 240, 96, 255, 255, 255, 255,
        185, 37, 19, 240, 255, 255, 255, 255, 185, 230, 210, 96, 255, 255, 255, 255, 187, 4, 245,
        240, 255, 255, 255, 255, 187, 207, 238, 224, 255, 255, 255, 255, 188, 228, 215, 240, 255,
        255, 255, 255, 189, 175, 208, 224, 255, 255, 255, 255, 190, 196, 185, 240, 255, 255, 255,
        255, 191, 143, 178, 224, 255, 255, 255, 255, 192, 164, 155, 240, 255, 255, 255, 255, 193,
        111, 148, 224, 255, 255, 255, 255, 194, 132, 125, 240, 255, 255, 255, 255, 195, 79, 118,
        224, 255, 255, 255, 255, 196, 100, 95, 240, 255, 255, 255, 255, 197, 47, 88, 224, 255, 255,
        255, 255, 198, 77, 124, 112, 255, 255, 255, 255, 199, 15, 58, 224, 255, 255, 255, 255, 200,
        45, 94, 112, 255, 255, 255, 255, 203, 136, 240, 112, 255, 255, 255, 255, 210, 35, 244, 112,
        255, 255, 255, 255, 210, 96, 251, 224, 255, 255, 255, 255, 211, 117, 228, 240, 255, 255,
        255, 255, 212, 64, 221, 224, 255, 255, 255, 255, 213, 85, 170, 208, 255, 255, 255, 255,
        214, 32, 163, 192, 255, 255, 255, 255, 215, 53, 140, 208, 255, 255, 255, 255, 216, 0, 133,
        192, 255, 255, 255, 255, 217, 21, 110, 208, 255, 255, 255, 255, 218, 51, 118, 64, 255, 255,
        255, 255, 218, 254, 167, 112, 255, 255, 255, 255, 220, 19, 116, 96, 255, 255, 255, 255,
        220, 222, 137, 112, 255, 255, 255, 255, 221, 169, 130, 96, 255, 255, 255, 255, 222, 190,
        107, 112, 255, 255, 255, 255, 223, 137, 100, 96, 255, 255, 255, 255, 224, 158, 77, 112,
        255, 255, 255, 255, 225, 105, 70, 96, 255, 255, 255, 255, 226, 126, 47, 112, 255, 255, 255,
        255, 227, 73, 40, 96, 255, 255, 255, 255, 228, 94, 17, 112, 255, 255, 255, 255, 229, 41,
        10, 96, 255, 255, 255, 255, 230, 71, 45, 240, 255, 255, 255, 255, 231, 18, 38, 224, 255,
        255, 255, 255, 232, 39, 15, 240, 255, 255, 255, 255, 233, 22, 242, 224, 255, 255, 255, 255,
        234, 6, 241, 240, 255, 255, 255, 255, 234, 246, 212, 224, 255, 255, 255, 255, 235, 230,
        211, 240, 255, 255, 255, 255, 236, 214, 182, 224, 255, 255, 255, 255, 237, 198, 181, 240,
        255, 255, 255, 255, 238, 191, 211, 96, 255, 255, 255, 255, 239, 175, 210, 112, 255, 255,
        255, 255, 240, 159, 181, 96, 255, 255, 255, 255, 241, 143, 180, 112, 255, 255, 255, 255,
        242, 127, 151, 96, 255, 255, 255, 255, 243, 111, 150, 112, 255, 255, 255, 255, 244, 95,
        121, 96, 255, 255, 255, 255, 245, 79, 120, 112, 255, 255, 255, 255, 246, 63, 91, 96, 255,
        255, 255, 255, 247, 47, 90, 112, 255, 255, 255, 255, 248, 40, 119, 224, 255, 255, 255, 255,
        249, 15, 60, 112, 255, 255, 255, 255, 250, 8, 89, 224, 255, 255, 255, 255, 250, 248, 88,
        240, 255, 255, 255, 255, 251, 232, 59, 224, 255, 255, 255, 255, 252, 216, 58, 240, 255,
        255, 255, 255, 253, 200, 29, 224, 255, 255, 255, 255, 254, 184, 28, 240, 255, 255, 255,
        255, 255, 167, 255, 224, 0, 0, 0, 0, 0, 151, 254, 240, 0, 0, 0, 0, 1, 135, 225, 224, 0, 0,
        0, 0, 2, 119, 224, 240, 0, 0, 0, 0, 3, 112, 254, 96, 0, 0, 0, 0, 4, 96, 253, 112, 0, 0, 0,
        0, 5, 80, 224, 96, 0, 0, 0, 0, 6, 64, 223, 112, 0, 0, 0, 0, 7, 48, 194, 96, 0, 0, 0, 0, 8,
        32, 193, 112, 0, 0, 0, 0, 9, 16, 164, 96, 0, 0, 0, 0, 10, 0, 163, 112, 0, 0, 0, 0, 10, 240,
        134, 96, 0, 0, 0, 0, 11, 224, 133, 112, 0, 0, 0, 0, 12, 217, 162, 224, 0, 0, 0, 0, 13, 192,
        103, 112, 0, 0, 0, 0, 14, 185, 132, 224, 0, 0, 0, 0, 15, 169, 131, 240, 0, 0, 0, 0, 16,
        153, 102, 224, 0, 0, 0, 0, 17, 137, 101, 240, 0, 0, 0, 0, 18, 121, 72, 224, 0, 0, 0, 0, 19,
        105, 71, 240, 0, 0, 0, 0, 20, 89, 42, 224, 0, 0, 0, 0, 21, 73, 41, 240, 0, 0, 0, 0, 22, 57,
        12, 224, 0, 0, 0, 0, 23, 41, 11, 240, 0, 0, 0, 0, 24, 34, 41, 96, 0, 0, 0, 0, 25, 8, 237,
        240, 0, 0, 0, 0, 26, 2, 11, 96, 0, 0, 0, 0, 26, 242, 10, 112, 0, 0, 0, 0, 27, 225, 237, 96,
        0, 0, 0, 0, 28, 209, 236, 112, 0, 0, 0, 0, 29, 193, 207, 96, 0, 0, 0, 0, 30, 177, 206, 112,
        0, 0, 0, 0, 31, 161, 177, 96, 0, 0, 0, 0, 32, 118, 0, 240, 0, 0, 0, 0, 33, 129, 147, 96, 0,
        0, 0, 0, 34, 85, 226, 240, 0, 0, 0, 0, 35, 106, 175, 224, 0, 0, 0, 0, 36, 53, 196, 240, 0,
        0, 0, 0, 37, 74, 145, 224, 0, 0, 0, 0, 38, 21, 166, 240, 0, 0, 0, 0, 39, 42, 115, 224, 0,
        0, 0, 0, 39, 254, 195, 112, 0, 0, 0, 0, 41, 10, 85, 224, 0, 0, 0, 0, 41, 222, 165, 112, 0,
        0, 0, 0, 42, 234, 55, 224, 0, 0, 0, 0, 43, 190, 135, 112, 0, 0, 0, 0, 44, 211, 84, 96, 0,
        0, 0, 0, 45, 158, 105, 112, 0, 0, 0, 0, 46, 179, 54, 96, 0, 0, 0, 0, 47, 126, 75, 112, 0,
        0, 0, 0, 48, 147, 24, 96, 0, 0, 0, 0, 49, 103, 103, 240, 0, 0, 0, 0, 50, 114, 250, 96, 0,
        0, 0, 0, 51, 71, 73, 240, 0, 0, 0, 0, 52, 82, 220, 96, 0, 0, 0, 0, 53, 39, 43, 240, 0, 0,
        0, 0, 54, 50, 190, 96, 0, 0, 0, 0, 55, 7, 13, 240, 0, 0, 0, 0, 56, 27, 218, 224, 0, 0, 0,
        0, 56, 230, 239, 240, 0, 0, 0, 0, 57, 251, 188, 224, 0, 0, 0, 0, 58, 198, 209, 240, 0, 0,
        0, 0, 59, 219, 158, 224, 0, 0, 0, 0, 60, 175, 238, 112, 0, 0, 0, 0, 61, 187, 128, 224, 0,
        0, 0, 0, 62, 143, 208, 112, 0, 0, 0, 0, 63, 155, 98, 224, 0, 0, 0, 0, 64, 111, 178, 112, 0,
        0, 0, 0, 65, 132, 127, 96, 0, 0, 0, 0, 66, 79, 148, 112, 0, 0, 0, 0, 67, 100, 97, 96, 0, 0,
        0, 0, 68, 47, 118, 112, 0, 0, 0, 0, 69, 68, 67, 96, 0, 0, 0, 0, 69, 243, 168, 240, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 255, 255, 181, 148, 0, 0, 255,
        255, 199, 192, 1, 4, 255, 255, 185, 176, 0, 8, 255, 255, 199, 192, 1, 12, 255, 255, 199,
        192, 1, 16, 76, 77, 84, 0, 69, 68, 84, 0, 69, 83, 84, 0, 69, 87, 84, 0, 69, 80, 84, 0, 10,
        69, 83, 84, 53, 69, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaNewYork: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        175, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 94, 3, 240, 144, 255, 255, 255, 255, 158,
        166, 30, 112, 255, 255, 255, 255, 159, 186, 235, 96, 255, 255, 255, 255, 160, 134, 0, 112,
        255, 255, 255, 255, 161, 154, 205, 96, 255, 255, 255, 255, 162, 101, 226, 112, 255, 255,
        255, 255, 163, 131, 233, 224, 255, 255, 255, 255, 164, 106, 174, 112, 255, 255, 255, 255,
        165, 53, 167, 96, 255, 255, 255, 255, 166, 83, 202, 240, 255, 255, 255, 255, 167, 21, 137,
        96, 255, 255, 255, 255, 168, 51, 172, 240, 255, 255, 255, 255, 168, 254, 165, 224, 255,
        255, 255, 255, 170, 19, 142, 240, 255, 255, 255, 255, 170, 222, 135, 224, 255, 255, 255,
        255, 171, 243, 112, 240, 255, 255, 255, 255, 172, 190, 105, 224, 255, 255, 255, 255, 173,
        211, 82, 240, 255, 255, 255, 255, 174, 158, 75, 224, 255, 255, 255, 255, 175, 179, 52, 240,
        255, 255, 255, 255, 176, 126, 45, 224, 255, 255, 255, 255, 177, 156, 81, 112, 255, 255,
        255, 255, 178, 103, 74, 96, 255, 255, 255, 255, 179, 124, 51, 112, 255, 255, 255, 255, 180,
        71, 44, 96, 255, 255, 255, 255, 181, 92, 21, 112, 255, 255, 255, 255, 182, 39, 14, 96, 255,
        255, 255, 255, 183, 59, 247, 112, 255, 255, 255, 255, 184, 6, 240, 96, 255, 255, 255, 255,
        185, 27, 217, 112, 255, 255, 255, 255, 185, 230, 210, 96, 255, 255, 255, 255, 187, 4, 245,
        240, 255, 255, 255, 255, 187, 198, 180, 96, 255, 255, 255, 255, 188, 228, 215, 240, 255,
        255, 255, 255, 189, 175, 208, 224, 255, 255, 255, 255, 190, 196, 185, 240, 255, 255, 255,
        255, 191, 143, 178, 224, 255, 255, 255, 255, 192, 164, 155, 240, 255, 255, 255, 255, 193,
        111, 148, 224, 255, 255, 255, 255, 194, 132, 125, 240, 255, 255, 255, 255, 195, 79, 118,
        224, 255, 255, 255, 255, 196, 100, 95, 240, 255, 255, 255, 255, 197, 47, 88, 224, 255, 255,
        255, 255, 198, 77, 124, 112, 255, 255, 255, 255, 199, 15, 58, 224, 255, 255, 255, 255, 200,
        45, 94, 112, 255, 255, 255, 255, 200, 248, 87, 96, 255, 255, 255, 255, 202, 13, 64, 112,
        255, 255, 255, 255, 202, 216, 57, 96, 255, 255, 255, 255, 203, 136, 240, 112, 255, 255,
        255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 96, 251, 224, 255, 255, 255, 255,
        211, 117, 228, 240, 255, 255, 255, 255, 212, 64, 221, 224, 255, 255, 255, 255, 213, 85,
        198, 240, 255, 255, 255, 255, 214, 32, 191, 224, 255, 255, 255, 255, 215, 53, 168, 240,
        255, 255, 255, 255, 216, 0, 161, 224, 255, 255, 255, 255, 217, 21, 138, 240, 255, 255, 255,
        255, 217, 224, 131, 224, 255, 255, 255, 255, 218, 254, 167, 112, 255, 255, 255, 255, 219,
        192, 101, 224, 255, 255, 255, 255, 220, 222, 137, 112, 255, 255, 255, 255, 221, 169, 130,
        96, 255, 255, 255, 255, 222, 190, 107, 112, 255, 255, 255, 255, 223, 137, 100, 96, 255,
        255, 255, 255, 224, 158, 77, 112, 255, 255, 255, 255, 225, 105, 70, 96, 255, 255, 255, 255,
        226, 126, 47, 112, 255, 255, 255, 255, 227, 73, 40, 96, 255, 255, 255, 255, 228, 94, 17,
        112, 255, 255, 255, 255, 229, 87, 46, 224, 255, 255, 255, 255, 230, 71, 45, 240, 255, 255,
        255, 255, 231, 55, 16, 224, 255, 255, 255, 255, 232, 39, 15, 240, 255, 255, 255, 255, 233,
        22, 242, 224, 255, 255, 255, 255, 234, 6, 241, 240, 255, 255, 255, 255, 234, 246, 212, 224,
        255, 255, 255, 255, 235, 230, 211, 240, 255, 255, 255, 255, 236, 214, 182, 224, 255, 255,
        255, 255, 237, 198, 181, 240, 255, 255, 255, 255, 238, 191, 211, 96, 255, 255, 255, 255,
        239, 175, 210, 112, 255, 255, 255, 255, 240, 159, 181, 96, 255, 255, 255, 255, 241, 143,
        180, 112, 255, 255, 255, 255, 242, 127, 151, 96, 255, 255, 255, 255, 243, 111, 150, 112,
        255, 255, 255, 255, 244, 95, 121, 96, 255, 255, 255, 255, 245, 79, 120, 112, 255, 255, 255,
        255, 246, 63, 91, 96, 255, 255, 255, 255, 247, 47, 90, 112, 255, 255, 255, 255, 248, 40,
        119, 224, 255, 255, 255, 255, 249, 15, 60, 112, 255, 255, 255, 255, 250, 8, 89, 224, 255,
        255, 255, 255, 250, 248, 88, 240, 255, 255, 255, 255, 251, 232, 59, 224, 255, 255, 255,
        255, 252, 216, 58, 240, 255, 255, 255, 255, 253, 200, 29, 224, 255, 255, 255, 255, 254,
        184, 28, 240, 255, 255, 255, 255, 255, 167, 255, 224, 0, 0, 0, 0, 0, 151, 254, 240, 0, 0,
        0, 0, 1, 135, 225, 224, 0, 0, 0, 0, 2, 119, 224, 240, 0, 0, 0, 0, 3, 112, 254, 96, 0, 0, 0,
        0, 4, 96, 253, 112, 0, 0, 0, 0, 5, 80, 224, 96, 0, 0, 0, 0, 6, 64, 223, 112, 0, 0, 0, 0, 7,
        48, 194, 96, 0, 0, 0, 0, 7, 141, 25, 112, 0, 0, 0, 0, 9, 16, 164, 96, 0, 0, 0, 0, 9, 173,
        148, 240, 0, 0, 0, 0, 10, 240, 134, 96, 0, 0, 0, 0, 11, 224, 133, 112, 0, 0, 0, 0, 12, 217,
        162, 224, 0, 0, 0, 0, 13, 192, 103, 112, 0, 0, 0, 0, 14, 185, 132, 224, 0, 0, 0, 0, 15,
        169, 131, 240, 0, 0, 0, 0, 16, 153, 102, 224, 0, 0, 0, 0, 17, 137, 101, 240, 0, 0, 0, 0,
        18, 121, 72, 224, 0, 0, 0, 0, 19, 105, 71, 240, 0, 0, 0, 0, 20, 89, 42, 224, 0, 0, 0, 0,
        21, 73, 41, 240, 0, 0, 0, 0, 22, 57, 12, 224, 0, 0, 0, 0, 23, 41, 11, 240, 0, 0, 0, 0, 24,
        34, 41, 96, 0, 0, 0, 0, 25, 8, 237, 240, 0, 0, 0, 0, 26, 2, 11, 96, 0, 0, 0, 0, 26, 242,
        10, 112, 0, 0, 0, 0, 27, 225, 237, 96, 0, 0, 0, 0, 28, 209, 236, 112, 0, 0, 0, 0, 29, 193,
        207, 96, 0, 0, 0, 0, 30, 177, 206, 112, 0, 0, 0, 0, 31, 161, 177, 96, 0, 0, 0, 0, 32, 118,
        0, 240, 0, 0, 0, 0, 33, 129, 147, 96, 0, 0, 0, 0, 34, 85, 226, 240, 0, 0, 0, 0, 35, 106,
        175, 224, 0, 0, 0, 0, 36, 53, 196, 240, 0, 0, 0, 0, 37, 74, 145, 224, 0, 0, 0, 0, 38, 21,
        166, 240, 0, 0, 0, 0, 39, 42, 115, 224, 0, 0, 0, 0, 39, 254, 195, 112, 0, 0, 0, 0, 41, 10,
        85, 224, 0, 0, 0, 0, 41, 222, 165, 112, 0, 0, 0, 0, 42, 234, 55, 224, 0, 0, 0, 0, 43, 190,
        135, 112, 0, 0, 0, 0, 44, 211, 84, 96, 0, 0, 0, 0, 45, 158, 105, 112, 0, 0, 0, 0, 46, 179,
        54, 96, 0, 0, 0, 0, 47, 126, 75, 112, 0, 0, 0, 0, 48, 147, 24, 96, 0, 0, 0, 0, 49, 103,
        103, 240, 0, 0, 0, 0, 50, 114, 250, 96, 0, 0, 0, 0, 51, 71, 73, 240, 0, 0, 0, 0, 52, 82,
        220, 96, 0, 0, 0, 0, 53, 39, 43, 240, 0, 0, 0, 0, 54, 50, 190, 96, 0, 0, 0, 0, 55, 7, 13,
        240, 0, 0, 0, 0, 56, 27, 218, 224, 0, 0, 0, 0, 56, 230, 239, 240, 0, 0, 0, 0, 57, 251, 188,
        224, 0, 0, 0, 0, 58, 198, 209, 240, 0, 0, 0, 0, 59, 219, 158, 224, 0, 0, 0, 0, 60, 175,
        238, 112, 0, 0, 0, 0, 61, 187, 128, 224, 0, 0, 0, 0, 62, 143, 208, 112, 0, 0, 0, 0, 63,
        155, 98, 224, 0, 0, 0, 0, 64, 111, 178, 112, 0, 0, 0, 0, 65, 132, 127, 96, 0, 0, 0, 0, 66,
        79, 148, 112, 0, 0, 0, 0, 67, 100, 97, 96, 0, 0, 0, 0, 68, 47, 118, 112, 0, 0, 0, 0, 69,
        68, 67, 96, 0, 0, 0, 0, 69, 243, 168, 240, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 255, 255, 186, 158, 0, 0, 255, 255, 199, 192, 1, 4, 255, 255,
        185, 176, 0, 8, 255, 255, 199, 192, 1, 12, 255, 255, 199, 192, 1, 16, 76, 77, 84, 0, 69,
        68, 84, 0, 69, 83, 84, 0, 69, 87, 84, 0, 69, 80, 84, 0, 10, 69, 83, 84, 53, 69, 68, 84, 44,
        77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaNipigon: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        74, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 114, 238, 129, 64, 255, 255, 255, 255,
        158, 184, 147, 112, 255, 255, 255, 255, 159, 186, 235, 96, 255, 255, 255, 255, 200, 248,
        73, 80, 255, 255, 255, 255, 203, 136, 240, 112, 255, 255, 255, 255, 210, 35, 244, 112, 255,
        255, 255, 255, 210, 96, 251, 224, 0, 0, 0, 0, 8, 32, 193, 112, 0, 0, 0, 0, 9, 16, 164, 96,
        0, 0, 0, 0, 10, 0, 163, 112, 0, 0, 0, 0, 10, 240, 134, 96, 0, 0, 0, 0, 11, 224, 133, 112,
        0, 0, 0, 0, 12, 217, 162, 224, 0, 0, 0, 0, 13, 192, 103, 112, 0, 0, 0, 0, 14, 185, 132,
        224, 0, 0, 0, 0, 15, 169, 131, 240, 0, 0, 0, 0, 16, 153, 102, 224, 0, 0, 0, 0, 17, 137,
        101, 240, 0, 0, 0, 0, 18, 121, 72, 224, 0, 0, 0, 0, 19, 105, 71, 240, 0, 0, 0, 0, 20, 89,
        42, 224, 0, 0, 0, 0, 21, 73, 41, 240, 0, 0, 0, 0, 22, 57, 12, 224, 0, 0, 0, 0, 23, 41, 11,
        240, 0, 0, 0, 0, 24, 34, 41, 96, 0, 0, 0, 0, 25, 8, 237, 240, 0, 0, 0, 0, 26, 2, 11, 96, 0,
        0, 0, 0, 26, 242, 10, 112, 0, 0, 0, 0, 27, 225, 237, 96, 0, 0, 0, 0, 28, 209, 236, 112, 0,
        0, 0, 0, 29, 193, 207, 96, 0, 0, 0, 0, 30, 177, 206, 112, 0, 0, 0, 0, 31, 161, 177, 96, 0,
        0, 0, 0, 32, 118, 0, 240, 0, 0, 0, 0, 33, 129, 147, 96, 0, 0, 0, 0, 34, 85, 226, 240, 0, 0,
        0, 0, 35, 106, 175, 224, 0, 0, 0, 0, 36, 53, 196, 240, 0, 0, 0, 0, 37, 74, 145, 224, 0, 0,
        0, 0, 38, 21, 166, 240, 0, 0, 0, 0, 39, 42, 115, 224, 0, 0, 0, 0, 39, 254, 195, 112, 0, 0,
        0, 0, 41, 10, 85, 224, 0, 0, 0, 0, 41, 222, 165, 112, 0, 0, 0, 0, 42, 234, 55, 224, 0, 0,
        0, 0, 43, 190, 135, 112, 0, 0, 0, 0, 44, 211, 84, 96, 0, 0, 0, 0, 45, 158, 105, 112, 0, 0,
        0, 0, 46, 179, 54, 96, 0, 0, 0, 0, 47, 126, 75, 112, 0, 0, 0, 0, 48, 147, 24, 96, 0, 0, 0,
        0, 49, 103, 103, 240, 0, 0, 0, 0, 50, 114, 250, 96, 0, 0, 0, 0, 51, 71, 73, 240, 0, 0, 0,
        0, 52, 82, 220, 96, 0, 0, 0, 0, 53, 39, 43, 240, 0, 0, 0, 0, 54, 50, 190, 96, 0, 0, 0, 0,
        55, 7, 13, 240, 0, 0, 0, 0, 56, 27, 218, 224, 0, 0, 0, 0, 56, 230, 239, 240, 0, 0, 0, 0,
        57, 251, 188, 224, 0, 0, 0, 0, 58, 198, 209, 240, 0, 0, 0, 0, 59, 219, 158, 224, 0, 0, 0,
        0, 60, 175, 238, 112, 0, 0, 0, 0, 61, 187, 128, 224, 0, 0, 0, 0, 62, 143, 208, 112, 0, 0,
        0, 0, 63, 155, 98, 224, 0, 0, 0, 0, 64, 111, 178, 112, 0, 0, 0, 0, 65, 132, 127, 96, 0, 0,
        0, 0, 66, 79, 148, 112, 0, 0, 0, 0, 67, 100, 97, 96, 0, 0, 0, 0, 68, 47, 118, 112, 0, 0, 0,
        0, 69, 68, 67, 96, 0, 0, 0, 0, 69, 243, 168, 240, 2, 1, 2, 1, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        255, 255, 173, 64, 0, 0, 255, 255, 199, 192, 1, 4, 255, 255, 185, 176, 0, 8, 255, 255, 199,
        192, 1, 12, 255, 255, 199, 192, 1, 16, 76, 77, 84, 0, 69, 68, 84, 0, 69, 83, 84, 0, 69, 87,
        84, 0, 69, 80, 84, 0, 10, 69, 83, 84, 53, 69, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77,
        49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaNome: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        84, 0, 0, 0, 10, 0, 0, 0, 38, 255, 255, 255, 255, 63, 194, 253, 209, 255, 255, 255, 255,
        125, 135, 79, 210, 255, 255, 255, 255, 203, 137, 68, 208, 255, 255, 255, 255, 210, 35, 244,
        112, 255, 255, 255, 255, 210, 97, 80, 64, 255, 255, 255, 255, 250, 210, 85, 176, 255, 255,
        255, 255, 254, 184, 113, 80, 255, 255, 255, 255, 255, 168, 84, 64, 0, 0, 0, 0, 0, 152, 83,
        80, 0, 0, 0, 0, 1, 136, 54, 64, 0, 0, 0, 0, 2, 120, 53, 80, 0, 0, 0, 0, 3, 113, 82, 192, 0,
        0, 0, 0, 4, 97, 81, 208, 0, 0, 0, 0, 5, 81, 52, 192, 0, 0, 0, 0, 6, 65, 51, 208, 0, 0, 0,
        0, 7, 49, 22, 192, 0, 0, 0, 0, 7, 141, 109, 208, 0, 0, 0, 0, 9, 16, 248, 192, 0, 0, 0, 0,
        9, 173, 233, 80, 0, 0, 0, 0, 10, 240, 218, 192, 0, 0, 0, 0, 11, 224, 217, 208, 0, 0, 0, 0,
        12, 217, 247, 64, 0, 0, 0, 0, 13, 192, 187, 208, 0, 0, 0, 0, 14, 185, 217, 64, 0, 0, 0, 0,
        15, 169, 216, 80, 0, 0, 0, 0, 16, 153, 187, 64, 0, 0, 0, 0, 17, 137, 186, 80, 0, 0, 0, 0,
        18, 121, 157, 64, 0, 0, 0, 0, 19, 105, 156, 80, 0, 0, 0, 0, 20, 89, 127, 64, 0, 0, 0, 0,
        21, 73, 126, 80, 0, 0, 0, 0, 22, 57, 97, 64, 0, 0, 0, 0, 23, 41, 96, 80, 0, 0, 0, 0, 24,
        34, 125, 192, 0, 0, 0, 0, 25, 9, 66, 80, 0, 0, 0, 0, 26, 2, 95, 192, 0, 0, 0, 0, 26, 43,
        20, 16, 0, 0, 0, 0, 26, 242, 66, 176, 0, 0, 0, 0, 27, 226, 37, 160, 0, 0, 0, 0, 28, 210,
        36, 176, 0, 0, 0, 0, 29, 194, 7, 160, 0, 0, 0, 0, 30, 178, 6, 176, 0, 0, 0, 0, 31, 161,
        233, 160, 0, 0, 0, 0, 32, 118, 57, 48, 0, 0, 0, 0, 33, 129, 203, 160, 0, 0, 0, 0, 34, 86,
        27, 48, 0, 0, 0, 0, 35, 106, 232, 32, 0, 0, 0, 0, 36, 53, 253, 48, 0, 0, 0, 0, 37, 74, 202,
        32, 0, 0, 0, 0, 38, 21, 223, 48, 0, 0, 0, 0, 39, 42, 172, 32, 0, 0, 0, 0, 39, 254, 251,
        176, 0, 0, 0, 0, 41, 10, 142, 32, 0, 0, 0, 0, 41, 222, 221, 176, 0, 0, 0, 0, 42, 234, 112,
        32, 0, 0, 0, 0, 43, 190, 191, 176, 0, 0, 0, 0, 44, 211, 140, 160, 0, 0, 0, 0, 45, 158, 161,
        176, 0, 0, 0, 0, 46, 179, 110, 160, 0, 0, 0, 0, 47, 126, 131, 176, 0, 0, 0, 0, 48, 147, 80,
        160, 0, 0, 0, 0, 49, 103, 160, 48, 0, 0, 0, 0, 50, 115, 50, 160, 0, 0, 0, 0, 51, 71, 130,
        48, 0, 0, 0, 0, 52, 83, 20, 160, 0, 0, 0, 0, 53, 39, 100, 48, 0, 0, 0, 0, 54, 50, 246, 160,
        0, 0, 0, 0, 55, 7, 70, 48, 0, 0, 0, 0, 56, 28, 19, 32, 0, 0, 0, 0, 56, 231, 40, 48, 0, 0,
        0, 0, 57, 251, 245, 32, 0, 0, 0, 0, 58, 199, 10, 48, 0, 0, 0, 0, 59, 219, 215, 32, 0, 0, 0,
        0, 60, 176, 38, 176, 0, 0, 0, 0, 61, 187, 185, 32, 0, 0, 0, 0, 62, 144, 8, 176, 0, 0, 0, 0,
        63, 155, 155, 32, 0, 0, 0, 0, 64, 111, 234, 176, 0, 0, 0, 0, 65, 132, 183, 160, 0, 0, 0, 0,
        66, 79, 204, 176, 0, 0, 0, 0, 67, 100, 153, 160, 0, 0, 0, 0, 68, 47, 174, 176, 0, 0, 0, 0,
        69, 68, 123, 160, 0, 0, 0, 0, 69, 243, 225, 48, 1, 2, 3, 4, 2, 5, 6, 5, 6, 5, 6, 5, 6, 5,
        6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 7, 9, 8, 9, 8, 9, 8, 9, 8,
        9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9, 8,
        9, 8, 9, 8, 9, 8, 9, 8, 9, 8, 0, 0, 182, 110, 0, 0, 255, 255, 100, 238, 0, 0, 255, 255,
        101, 80, 0, 4, 255, 255, 115, 96, 1, 8, 255, 255, 115, 96, 1, 12, 255, 255, 101, 80, 0, 16,
        255, 255, 115, 96, 1, 20, 255, 255, 129, 112, 0, 24, 255, 255, 143, 128, 1, 28, 255, 255,
        129, 112, 0, 33, 76, 77, 84, 0, 78, 83, 84, 0, 78, 87, 84, 0, 78, 80, 84, 0, 66, 83, 84, 0,
        66, 68, 84, 0, 89, 83, 84, 0, 65, 75, 68, 84, 0, 65, 75, 83, 84, 0, 10, 65, 75, 83, 84, 57,
        65, 75, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaNoronha: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        39, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 150, 170, 101, 100, 255, 255, 255, 255,
        184, 15, 59, 208, 255, 255, 255, 255, 184, 253, 50, 144, 255, 255, 255, 255, 185, 241, 38,
        32, 255, 255, 255, 255, 186, 222, 102, 16, 255, 255, 255, 255, 218, 56, 160, 32, 255, 255,
        255, 255, 218, 235, 236, 32, 255, 255, 255, 255, 220, 25, 211, 160, 255, 255, 255, 255,
        220, 185, 75, 16, 255, 255, 255, 255, 221, 251, 7, 32, 255, 255, 255, 255, 222, 155, 208,
        16, 255, 255, 255, 255, 223, 221, 140, 32, 255, 255, 255, 255, 224, 84, 37, 16, 255, 255,
        255, 255, 244, 151, 241, 160, 255, 255, 255, 255, 245, 5, 80, 16, 255, 255, 255, 255, 246,
        192, 86, 32, 255, 255, 255, 255, 247, 14, 16, 144, 255, 255, 255, 255, 248, 81, 30, 32,
        255, 255, 255, 255, 248, 199, 183, 16, 255, 255, 255, 255, 250, 10, 196, 160, 255, 255,
        255, 255, 250, 168, 234, 144, 255, 255, 255, 255, 251, 235, 248, 32, 255, 255, 255, 255,
        252, 139, 111, 144, 0, 0, 0, 0, 29, 201, 128, 32, 0, 0, 0, 0, 30, 120, 201, 144, 0, 0, 0,
        0, 31, 160, 39, 160, 0, 0, 0, 0, 32, 51, 193, 144, 0, 0, 0, 0, 33, 129, 91, 32, 0, 0, 0, 0,
        34, 11, 186, 144, 0, 0, 0, 0, 35, 88, 2, 160, 0, 0, 0, 0, 35, 226, 98, 16, 0, 0, 0, 0, 37,
        55, 228, 160, 0, 0, 0, 0, 37, 212, 185, 16, 0, 0, 0, 0, 55, 246, 184, 160, 0, 0, 0, 0, 56,
        184, 119, 16, 0, 0, 0, 0, 57, 223, 213, 32, 0, 0, 0, 0, 57, 233, 1, 144, 0, 0, 0, 0, 59,
        200, 241, 160, 0, 0, 0, 0, 60, 111, 0, 144, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 255, 255, 225, 156, 0,
        0, 255, 255, 241, 240, 1, 4, 255, 255, 227, 224, 0, 8, 76, 77, 84, 0, 45, 48, 49, 0, 45,
        48, 50, 0, 10, 60, 45, 48, 50, 62, 50, 10,
    ];
    pub(crate) const AmericaOjinaga: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        35, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 165, 182, 232, 112, 255, 255, 255, 255,
        175, 242, 110, 224, 255, 255, 255, 255, 182, 102, 86, 96, 255, 255, 255, 255, 183, 67, 210,
        96, 255, 255, 255, 255, 184, 12, 54, 96, 255, 255, 255, 255, 184, 253, 134, 240, 0, 0, 0,
        0, 49, 103, 118, 0, 0, 0, 0, 0, 50, 115, 8, 112, 0, 0, 0, 0, 51, 71, 88, 0, 0, 0, 0, 0, 52,
        82, 234, 112, 0, 0, 0, 0, 53, 39, 72, 16, 0, 0, 0, 0, 54, 50, 218, 128, 0, 0, 0, 0, 55, 7,
        42, 16, 0, 0, 0, 0, 56, 27, 247, 0, 0, 0, 0, 0, 56, 231, 12, 16, 0, 0, 0, 0, 57, 251, 217,
        0, 0, 0, 0, 0, 58, 245, 18, 144, 0, 0, 0, 0, 59, 182, 209, 0, 0, 0, 0, 0, 60, 176, 10, 144,
        0, 0, 0, 0, 61, 187, 157, 0, 0, 0, 0, 0, 62, 143, 236, 144, 0, 0, 0, 0, 63, 155, 127, 0, 0,
        0, 0, 0, 64, 111, 206, 144, 0, 0, 0, 0, 65, 132, 155, 128, 0, 0, 0, 0, 66, 79, 176, 144, 0,
        0, 0, 0, 67, 100, 125, 128, 0, 0, 0, 0, 68, 47, 146, 144, 0, 0, 0, 0, 69, 68, 95, 128, 0,
        0, 0, 0, 70, 15, 116, 144, 0, 0, 0, 0, 71, 36, 65, 128, 0, 0, 0, 0, 71, 248, 145, 16, 0, 0,
        0, 0, 73, 4, 35, 128, 0, 0, 0, 0, 73, 216, 115, 16, 0, 0, 0, 0, 74, 228, 5, 128, 0, 0, 0,
        0, 75, 156, 165, 144, 1, 2, 1, 2, 1, 2, 3, 2, 3, 2, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4,
        1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 255, 255, 158, 28, 0, 0, 255, 255, 157, 144, 0, 4, 255,
        255, 171, 160, 0, 8, 255, 255, 185, 176, 1, 12, 255, 255, 171, 160, 1, 16, 76, 77, 84, 0,
        77, 83, 84, 0, 67, 83, 84, 0, 67, 68, 84, 0, 77, 68, 84, 0, 10, 77, 83, 84, 55, 77, 68, 84,
        44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaPangnirtung: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        61, 0, 0, 0, 10, 0, 0, 0, 41, 255, 255, 255, 255, 163, 213, 82, 128, 255, 255, 255, 255,
        203, 136, 226, 96, 255, 255, 255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 96, 237,
        208, 255, 255, 255, 255, 247, 47, 48, 64, 255, 255, 255, 255, 248, 40, 91, 192, 0, 0, 0, 0,
        19, 105, 57, 224, 0, 0, 0, 0, 20, 89, 28, 208, 0, 0, 0, 0, 21, 73, 27, 224, 0, 0, 0, 0, 22,
        56, 254, 208, 0, 0, 0, 0, 23, 40, 253, 224, 0, 0, 0, 0, 24, 34, 27, 80, 0, 0, 0, 0, 25, 8,
        223, 224, 0, 0, 0, 0, 26, 1, 253, 80, 0, 0, 0, 0, 26, 241, 252, 96, 0, 0, 0, 0, 27, 225,
        223, 80, 0, 0, 0, 0, 28, 209, 222, 96, 0, 0, 0, 0, 29, 193, 193, 80, 0, 0, 0, 0, 30, 177,
        192, 96, 0, 0, 0, 0, 31, 161, 163, 80, 0, 0, 0, 0, 32, 117, 242, 224, 0, 0, 0, 0, 33, 129,
        133, 80, 0, 0, 0, 0, 34, 85, 212, 224, 0, 0, 0, 0, 35, 106, 161, 208, 0, 0, 0, 0, 36, 53,
        182, 224, 0, 0, 0, 0, 37, 74, 131, 208, 0, 0, 0, 0, 38, 21, 152, 224, 0, 0, 0, 0, 39, 42,
        101, 208, 0, 0, 0, 0, 39, 254, 181, 96, 0, 0, 0, 0, 41, 10, 71, 208, 0, 0, 0, 0, 41, 222,
        151, 96, 0, 0, 0, 0, 42, 234, 41, 208, 0, 0, 0, 0, 43, 190, 121, 96, 0, 0, 0, 0, 44, 211,
        70, 80, 0, 0, 0, 0, 45, 158, 91, 96, 0, 0, 0, 0, 46, 179, 40, 80, 0, 0, 0, 0, 47, 126, 61,
        96, 0, 0, 0, 0, 48, 147, 24, 96, 0, 0, 0, 0, 49, 103, 103, 240, 0, 0, 0, 0, 50, 114, 250,
        96, 0, 0, 0, 0, 51, 71, 73, 240, 0, 0, 0, 0, 52, 82, 220, 96, 0, 0, 0, 0, 53, 39, 43, 240,
        0, 0, 0, 0, 54, 50, 190, 96, 0, 0, 0, 0, 55, 7, 13, 240, 0, 0, 0, 0, 56, 27, 218, 224, 0,
        0, 0, 0, 56, 230, 254, 0, 0, 0, 0, 0, 57, 251, 202, 240, 0, 0, 0, 0, 58, 198, 209, 240, 0,
        0, 0, 0, 59, 219, 158, 224, 0, 0, 0, 0, 60, 175, 238, 112, 0, 0, 0, 0, 61, 187, 128, 224,
        0, 0, 0, 0, 62, 143, 208, 112, 0, 0, 0, 0, 63, 155, 98, 224, 0, 0, 0, 0, 64, 111, 178, 112,
        0, 0, 0, 0, 65, 132, 127, 96, 0, 0, 0, 0, 66, 79, 148, 112, 0, 0, 0, 0, 67, 100, 97, 96, 0,
        0, 0, 0, 68, 47, 118, 112, 0, 0, 0, 0, 69, 68, 67, 96, 0, 0, 0, 0, 69, 243, 168, 240, 3, 1,
        2, 3, 4, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3,
        5, 3, 5, 3, 6, 7, 6, 7, 6, 7, 6, 7, 6, 8, 9, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 0,
        0, 0, 0, 0, 0, 255, 255, 213, 208, 1, 4, 255, 255, 213, 208, 1, 8, 255, 255, 199, 192, 0,
        12, 255, 255, 227, 224, 1, 16, 255, 255, 213, 208, 1, 21, 255, 255, 199, 192, 1, 25, 255,
        255, 185, 176, 0, 29, 255, 255, 171, 160, 0, 33, 255, 255, 185, 176, 1, 37, 45, 48, 48, 0,
        65, 87, 84, 0, 65, 80, 84, 0, 65, 83, 84, 0, 65, 68, 68, 84, 0, 65, 68, 84, 0, 69, 68, 84,
        0, 69, 83, 84, 0, 67, 83, 84, 0, 67, 68, 84, 0, 10, 69, 83, 84, 53, 69, 68, 84, 44, 77, 51,
        46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaParamaribo: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        4, 0, 0, 0, 5, 0, 0, 0, 18, 255, 255, 255, 255, 145, 5, 142, 184, 255, 255, 255, 255, 190,
        42, 75, 196, 255, 255, 255, 255, 210, 98, 44, 180, 0, 0, 0, 0, 27, 190, 49, 184, 1, 2, 3,
        4, 255, 255, 204, 72, 0, 0, 255, 255, 204, 60, 0, 4, 255, 255, 204, 76, 0, 4, 255, 255,
        206, 200, 0, 8, 255, 255, 213, 208, 0, 14, 76, 77, 84, 0, 80, 77, 84, 0, 45, 48, 51, 51,
        48, 0, 45, 48, 51, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AmericaPortAuPrince: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        45, 0, 0, 0, 4, 0, 0, 0, 17, 255, 255, 255, 255, 105, 135, 31, 80, 255, 255, 255, 255, 156,
        110, 113, 252, 0, 0, 0, 0, 25, 27, 70, 208, 0, 0, 0, 0, 26, 1, 239, 64, 0, 0, 0, 0, 26,
        241, 238, 80, 0, 0, 0, 0, 27, 225, 209, 64, 0, 0, 0, 0, 28, 209, 208, 80, 0, 0, 0, 0, 29,
        193, 179, 64, 0, 0, 0, 0, 30, 177, 178, 80, 0, 0, 0, 0, 31, 161, 149, 64, 0, 0, 0, 0, 32,
        145, 148, 80, 0, 0, 0, 0, 33, 129, 119, 64, 0, 0, 0, 0, 34, 85, 212, 224, 0, 0, 0, 0, 35,
        106, 175, 224, 0, 0, 0, 0, 36, 53, 182, 224, 0, 0, 0, 0, 37, 74, 145, 224, 0, 0, 0, 0, 38,
        21, 152, 224, 0, 0, 0, 0, 39, 42, 115, 224, 0, 0, 0, 0, 39, 254, 181, 96, 0, 0, 0, 0, 41,
        10, 85, 224, 0, 0, 0, 0, 41, 222, 151, 96, 0, 0, 0, 0, 42, 234, 55, 224, 0, 0, 0, 0, 43,
        190, 121, 96, 0, 0, 0, 0, 44, 211, 84, 96, 0, 0, 0, 0, 45, 158, 91, 96, 0, 0, 0, 0, 46,
        179, 54, 96, 0, 0, 0, 0, 47, 126, 61, 96, 0, 0, 0, 0, 48, 147, 24, 96, 0, 0, 0, 0, 49, 103,
        89, 224, 0, 0, 0, 0, 50, 114, 250, 96, 0, 0, 0, 0, 51, 71, 59, 224, 0, 0, 0, 0, 52, 82,
        220, 96, 0, 0, 0, 0, 66, 79, 120, 80, 0, 0, 0, 0, 67, 100, 69, 64, 0, 0, 0, 0, 68, 47, 90,
        80, 0, 0, 0, 0, 69, 68, 39, 64, 0, 0, 0, 0, 79, 92, 77, 112, 0, 0, 0, 0, 80, 150, 4, 96, 0,
        0, 0, 0, 81, 60, 47, 112, 0, 0, 0, 0, 82, 117, 230, 96, 0, 0, 0, 0, 83, 28, 17, 112, 0, 0,
        0, 0, 84, 85, 200, 96, 0, 0, 0, 0, 84, 251, 243, 112, 0, 0, 0, 0, 86, 53, 170, 96, 0, 0, 0,
        0, 88, 196, 241, 240, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 255, 255, 188, 48, 0, 0,
        255, 255, 188, 68, 0, 4, 255, 255, 199, 192, 1, 9, 255, 255, 185, 176, 0, 13, 76, 77, 84,
        0, 80, 80, 77, 84, 0, 69, 68, 84, 0, 69, 83, 84, 0, 10, 69, 83, 84, 53, 69, 68, 84, 44, 77,
        51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaPortoAcre: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        31, 0, 0, 0, 4, 0, 0, 0, 12, 255, 255, 255, 255, 150, 170, 134, 144, 255, 255, 255, 255,
        184, 15, 102, 0, 255, 255, 255, 255, 184, 253, 92, 192, 255, 255, 255, 255, 185, 241, 80,
        80, 255, 255, 255, 255, 186, 222, 144, 64, 255, 255, 255, 255, 218, 56, 202, 80, 255, 255,
        255, 255, 218, 236, 22, 80, 255, 255, 255, 255, 220, 25, 253, 208, 255, 255, 255, 255, 220,
        185, 117, 64, 255, 255, 255, 255, 221, 251, 49, 80, 255, 255, 255, 255, 222, 155, 250, 64,
        255, 255, 255, 255, 223, 221, 182, 80, 255, 255, 255, 255, 224, 84, 79, 64, 255, 255, 255,
        255, 244, 152, 27, 208, 255, 255, 255, 255, 245, 5, 122, 64, 255, 255, 255, 255, 246, 192,
        128, 80, 255, 255, 255, 255, 247, 14, 58, 192, 255, 255, 255, 255, 248, 81, 72, 80, 255,
        255, 255, 255, 248, 199, 225, 64, 255, 255, 255, 255, 250, 10, 238, 208, 255, 255, 255,
        255, 250, 169, 20, 192, 255, 255, 255, 255, 251, 236, 34, 80, 255, 255, 255, 255, 252, 139,
        153, 192, 0, 0, 0, 0, 29, 201, 170, 80, 0, 0, 0, 0, 30, 120, 243, 192, 0, 0, 0, 0, 31, 160,
        81, 208, 0, 0, 0, 0, 32, 51, 235, 192, 0, 0, 0, 0, 33, 129, 133, 80, 0, 0, 0, 0, 34, 11,
        228, 192, 0, 0, 0, 0, 72, 96, 127, 80, 0, 0, 0, 0, 82, 127, 4, 192, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 2, 255, 255, 192, 112, 0,
        0, 255, 255, 199, 192, 1, 4, 255, 255, 185, 176, 0, 8, 255, 255, 199, 192, 0, 4, 76, 77,
        84, 0, 45, 48, 52, 0, 45, 48, 53, 0, 10, 60, 45, 48, 53, 62, 53, 10,
    ];
    pub(crate) const AmericaPortoVelho: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        29, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 150, 170, 130, 232, 255, 255, 255, 255,
        184, 15, 87, 240, 255, 255, 255, 255, 184, 253, 78, 176, 255, 255, 255, 255, 185, 241, 66,
        64, 255, 255, 255, 255, 186, 222, 130, 48, 255, 255, 255, 255, 218, 56, 188, 64, 255, 255,
        255, 255, 218, 236, 8, 64, 255, 255, 255, 255, 220, 25, 239, 192, 255, 255, 255, 255, 220,
        185, 103, 48, 255, 255, 255, 255, 221, 251, 35, 64, 255, 255, 255, 255, 222, 155, 236, 48,
        255, 255, 255, 255, 223, 221, 168, 64, 255, 255, 255, 255, 224, 84, 65, 48, 255, 255, 255,
        255, 244, 152, 13, 192, 255, 255, 255, 255, 245, 5, 108, 48, 255, 255, 255, 255, 246, 192,
        114, 64, 255, 255, 255, 255, 247, 14, 44, 176, 255, 255, 255, 255, 248, 81, 58, 64, 255,
        255, 255, 255, 248, 199, 211, 48, 255, 255, 255, 255, 250, 10, 224, 192, 255, 255, 255,
        255, 250, 169, 6, 176, 255, 255, 255, 255, 251, 236, 20, 64, 255, 255, 255, 255, 252, 139,
        139, 176, 0, 0, 0, 0, 29, 201, 156, 64, 0, 0, 0, 0, 30, 120, 229, 176, 0, 0, 0, 0, 31, 160,
        67, 192, 0, 0, 0, 0, 32, 51, 221, 176, 0, 0, 0, 0, 33, 129, 119, 64, 0, 0, 0, 0, 34, 11,
        214, 176, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 255, 255, 196, 24, 0, 0, 255, 255, 213, 208, 1, 4, 255, 255, 199, 192, 0, 8, 76, 77,
        84, 0, 45, 48, 51, 0, 45, 48, 52, 0, 10, 60, 45, 48, 52, 62, 52, 10,
    ];
    pub(crate) const AmericaPuntaArenas: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        116, 0, 0, 0, 7, 0, 0, 0, 20, 255, 255, 255, 255, 105, 135, 29, 252, 255, 255, 255, 255,
        143, 48, 71, 70, 255, 255, 255, 255, 155, 92, 229, 80, 255, 255, 255, 255, 159, 124, 226,
        198, 255, 255, 255, 255, 161, 0, 113, 192, 255, 255, 255, 255, 176, 94, 119, 198, 255, 255,
        255, 255, 177, 119, 61, 64, 255, 255, 255, 255, 178, 65, 0, 208, 255, 255, 255, 255, 179,
        88, 112, 192, 255, 255, 255, 255, 180, 34, 52, 80, 255, 255, 255, 255, 181, 57, 164, 64,
        255, 255, 255, 255, 182, 3, 103, 208, 255, 255, 255, 255, 183, 26, 215, 192, 255, 255, 255,
        255, 183, 228, 155, 80, 255, 255, 255, 255, 184, 253, 92, 192, 255, 255, 255, 255, 185,
        199, 32, 80, 255, 255, 255, 255, 204, 28, 110, 64, 255, 255, 255, 255, 204, 108, 231, 208,
        255, 255, 255, 255, 213, 51, 85, 192, 255, 255, 255, 255, 213, 118, 146, 64, 255, 255, 255,
        255, 253, 209, 60, 64, 255, 255, 255, 255, 254, 146, 250, 176, 255, 255, 255, 255, 255,
        204, 205, 192, 0, 0, 0, 0, 0, 114, 220, 176, 0, 0, 0, 0, 1, 117, 80, 192, 0, 0, 0, 0, 2,
        64, 73, 176, 0, 0, 0, 0, 3, 85, 50, 192, 0, 0, 0, 0, 4, 32, 43, 176, 0, 0, 0, 0, 5, 62, 79,
        64, 0, 0, 0, 0, 6, 0, 13, 176, 0, 0, 0, 0, 7, 11, 188, 64, 0, 0, 0, 0, 7, 223, 239, 176, 0,
        0, 0, 0, 8, 254, 19, 64, 0, 0, 0, 0, 9, 191, 209, 176, 0, 0, 0, 0, 10, 221, 245, 64, 0, 0,
        0, 0, 11, 168, 238, 48, 0, 0, 0, 0, 12, 189, 215, 64, 0, 0, 0, 0, 13, 136, 208, 48, 0, 0,
        0, 0, 14, 157, 185, 64, 0, 0, 0, 0, 15, 104, 178, 48, 0, 0, 0, 0, 16, 134, 213, 192, 0, 0,
        0, 0, 17, 72, 148, 48, 0, 0, 0, 0, 18, 102, 183, 192, 0, 0, 0, 0, 19, 40, 118, 48, 0, 0, 0,
        0, 20, 70, 153, 192, 0, 0, 0, 0, 21, 17, 146, 176, 0, 0, 0, 0, 22, 38, 123, 192, 0, 0, 0,
        0, 22, 241, 116, 176, 0, 0, 0, 0, 24, 6, 93, 192, 0, 0, 0, 0, 24, 209, 86, 176, 0, 0, 0, 0,
        25, 230, 63, 192, 0, 0, 0, 0, 26, 177, 56, 176, 0, 0, 0, 0, 27, 207, 92, 64, 0, 0, 0, 0,
        28, 145, 26, 176, 0, 0, 0, 0, 29, 175, 62, 64, 0, 0, 0, 0, 30, 112, 252, 176, 0, 0, 0, 0,
        31, 143, 32, 64, 0, 0, 0, 0, 32, 127, 3, 48, 0, 0, 0, 0, 33, 111, 2, 64, 0, 0, 0, 0, 34,
        57, 251, 48, 0, 0, 0, 0, 35, 78, 228, 64, 0, 0, 0, 0, 36, 25, 221, 48, 0, 0, 0, 0, 37, 56,
        0, 192, 0, 0, 0, 0, 37, 249, 191, 48, 0, 0, 0, 0, 38, 242, 248, 192, 0, 0, 0, 0, 39, 217,
        161, 48, 0, 0, 0, 0, 40, 247, 196, 192, 0, 0, 0, 0, 41, 194, 189, 176, 0, 0, 0, 0, 42, 215,
        166, 192, 0, 0, 0, 0, 43, 162, 159, 176, 0, 0, 0, 0, 44, 183, 136, 192, 0, 0, 0, 0, 45,
        130, 129, 176, 0, 0, 0, 0, 46, 151, 106, 192, 0, 0, 0, 0, 47, 98, 99, 176, 0, 0, 0, 0, 48,
        128, 135, 64, 0, 0, 0, 0, 49, 66, 69, 176, 0, 0, 0, 0, 50, 96, 105, 64, 0, 0, 0, 0, 51, 61,
        215, 48, 0, 0, 0, 0, 52, 64, 75, 64, 0, 0, 0, 0, 53, 11, 68, 48, 0, 0, 0, 0, 54, 13, 184,
        64, 0, 0, 0, 0, 55, 6, 213, 176, 0, 0, 0, 0, 56, 0, 15, 64, 0, 0, 0, 0, 56, 203, 8, 48, 0,
        0, 0, 0, 57, 233, 43, 192, 0, 0, 0, 0, 58, 170, 234, 48, 0, 0, 0, 0, 59, 201, 13, 192, 0,
        0, 0, 0, 60, 138, 204, 48, 0, 0, 0, 0, 61, 168, 239, 192, 0, 0, 0, 0, 62, 106, 174, 48, 0,
        0, 0, 0, 63, 136, 209, 192, 0, 0, 0, 0, 64, 83, 202, 176, 0, 0, 0, 0, 65, 104, 179, 192, 0,
        0, 0, 0, 66, 51, 172, 176, 0, 0, 0, 0, 67, 72, 149, 192, 0, 0, 0, 0, 68, 19, 142, 176, 0,
        0, 0, 0, 69, 49, 178, 64, 0, 0, 0, 0, 69, 243, 112, 176, 0, 0, 0, 0, 71, 17, 148, 64, 0, 0,
        0, 0, 71, 239, 2, 48, 0, 0, 0, 0, 72, 241, 118, 64, 0, 0, 0, 0, 73, 188, 111, 48, 0, 0, 0,
        0, 74, 209, 88, 64, 0, 0, 0, 0, 75, 184, 0, 176, 0, 0, 0, 0, 76, 177, 58, 64, 0, 0, 0, 0,
        77, 198, 7, 48, 0, 0, 0, 0, 78, 80, 130, 192, 0, 0, 0, 0, 79, 156, 174, 176, 0, 0, 0, 0,
        80, 66, 217, 192, 0, 0, 0, 0, 81, 124, 144, 176, 0, 0, 0, 0, 82, 43, 246, 64, 0, 0, 0, 0,
        83, 92, 114, 176, 0, 0, 0, 0, 84, 11, 216, 64, 0, 0, 0, 0, 87, 55, 230, 48, 0, 0, 0, 0, 87,
        175, 236, 192, 0, 0, 0, 0, 88, 67, 134, 176, 1, 2, 1, 3, 1, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2,
        3, 2, 3, 2, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5,
        3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5,
        3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5,
        3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 6, 255, 255, 189, 132, 0, 0, 255, 255, 189, 186, 0, 4, 255,
        255, 185, 176, 0, 8, 255, 255, 199, 192, 0, 12, 255, 255, 199, 192, 1, 12, 255, 255, 213,
        208, 1, 16, 255, 255, 213, 208, 0, 16, 76, 77, 84, 0, 83, 77, 84, 0, 45, 48, 53, 0, 45, 48,
        52, 0, 45, 48, 51, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AmericaRainyRiver: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        74, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 114, 238, 135, 40, 255, 255, 255, 255,
        158, 184, 161, 128, 255, 255, 255, 255, 159, 186, 249, 112, 255, 255, 255, 255, 200, 248,
        87, 96, 255, 255, 255, 255, 203, 136, 254, 128, 255, 255, 255, 255, 210, 35, 244, 112, 255,
        255, 255, 255, 210, 97, 9, 240, 0, 0, 0, 0, 8, 32, 207, 128, 0, 0, 0, 0, 9, 16, 178, 112,
        0, 0, 0, 0, 10, 0, 177, 128, 0, 0, 0, 0, 10, 240, 148, 112, 0, 0, 0, 0, 11, 224, 147, 128,
        0, 0, 0, 0, 12, 217, 176, 240, 0, 0, 0, 0, 13, 192, 117, 128, 0, 0, 0, 0, 14, 185, 146,
        240, 0, 0, 0, 0, 15, 169, 146, 0, 0, 0, 0, 0, 16, 153, 116, 240, 0, 0, 0, 0, 17, 137, 116,
        0, 0, 0, 0, 0, 18, 121, 86, 240, 0, 0, 0, 0, 19, 105, 86, 0, 0, 0, 0, 0, 20, 89, 56, 240,
        0, 0, 0, 0, 21, 73, 56, 0, 0, 0, 0, 0, 22, 57, 26, 240, 0, 0, 0, 0, 23, 41, 26, 0, 0, 0, 0,
        0, 24, 34, 55, 112, 0, 0, 0, 0, 25, 8, 252, 0, 0, 0, 0, 0, 26, 2, 25, 112, 0, 0, 0, 0, 26,
        242, 24, 128, 0, 0, 0, 0, 27, 225, 251, 112, 0, 0, 0, 0, 28, 209, 250, 128, 0, 0, 0, 0, 29,
        193, 221, 112, 0, 0, 0, 0, 30, 177, 220, 128, 0, 0, 0, 0, 31, 161, 191, 112, 0, 0, 0, 0,
        32, 118, 15, 0, 0, 0, 0, 0, 33, 129, 161, 112, 0, 0, 0, 0, 34, 85, 241, 0, 0, 0, 0, 0, 35,
        106, 189, 240, 0, 0, 0, 0, 36, 53, 211, 0, 0, 0, 0, 0, 37, 74, 159, 240, 0, 0, 0, 0, 38,
        21, 181, 0, 0, 0, 0, 0, 39, 42, 129, 240, 0, 0, 0, 0, 39, 254, 209, 128, 0, 0, 0, 0, 41,
        10, 99, 240, 0, 0, 0, 0, 41, 222, 179, 128, 0, 0, 0, 0, 42, 234, 69, 240, 0, 0, 0, 0, 43,
        190, 149, 128, 0, 0, 0, 0, 44, 211, 98, 112, 0, 0, 0, 0, 45, 158, 119, 128, 0, 0, 0, 0, 46,
        179, 68, 112, 0, 0, 0, 0, 47, 126, 89, 128, 0, 0, 0, 0, 48, 147, 38, 112, 0, 0, 0, 0, 49,
        103, 118, 0, 0, 0, 0, 0, 50, 115, 8, 112, 0, 0, 0, 0, 51, 71, 88, 0, 0, 0, 0, 0, 52, 82,
        234, 112, 0, 0, 0, 0, 53, 39, 58, 0, 0, 0, 0, 0, 54, 50, 204, 112, 0, 0, 0, 0, 55, 7, 28,
        0, 0, 0, 0, 0, 56, 27, 232, 240, 0, 0, 0, 0, 56, 230, 254, 0, 0, 0, 0, 0, 57, 251, 202,
        240, 0, 0, 0, 0, 58, 198, 224, 0, 0, 0, 0, 0, 59, 219, 172, 240, 0, 0, 0, 0, 60, 175, 252,
        128, 0, 0, 0, 0, 61, 187, 142, 240, 0, 0, 0, 0, 62, 143, 222, 128, 0, 0, 0, 0, 63, 155,
        112, 240, 0, 0, 0, 0, 64, 111, 192, 128, 0, 0, 0, 0, 65, 132, 141, 112, 0, 0, 0, 0, 66, 79,
        162, 128, 0, 0, 0, 0, 67, 100, 111, 112, 0, 0, 0, 0, 68, 47, 132, 128, 0, 0, 0, 0, 69, 68,
        81, 112, 0, 0, 0, 0, 69, 243, 183, 0, 2, 1, 2, 1, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 255, 255,
        167, 88, 0, 0, 255, 255, 185, 176, 1, 4, 255, 255, 171, 160, 0, 8, 255, 255, 185, 176, 1,
        12, 255, 255, 185, 176, 1, 16, 76, 77, 84, 0, 67, 68, 84, 0, 67, 83, 84, 0, 67, 87, 84, 0,
        67, 80, 84, 0, 10, 67, 83, 84, 54, 67, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49,
        46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaRankinInlet: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        58, 0, 0, 0, 5, 0, 0, 0, 21, 255, 255, 255, 255, 231, 140, 110, 0, 255, 255, 255, 255, 247,
        47, 76, 96, 255, 255, 255, 255, 248, 40, 119, 224, 0, 0, 0, 0, 19, 105, 86, 0, 0, 0, 0, 0,
        20, 89, 56, 240, 0, 0, 0, 0, 21, 73, 56, 0, 0, 0, 0, 0, 22, 57, 26, 240, 0, 0, 0, 0, 23,
        41, 26, 0, 0, 0, 0, 0, 24, 34, 55, 112, 0, 0, 0, 0, 25, 8, 252, 0, 0, 0, 0, 0, 26, 2, 25,
        112, 0, 0, 0, 0, 26, 242, 24, 128, 0, 0, 0, 0, 27, 225, 251, 112, 0, 0, 0, 0, 28, 209, 250,
        128, 0, 0, 0, 0, 29, 193, 221, 112, 0, 0, 0, 0, 30, 177, 220, 128, 0, 0, 0, 0, 31, 161,
        191, 112, 0, 0, 0, 0, 32, 118, 15, 0, 0, 0, 0, 0, 33, 129, 161, 112, 0, 0, 0, 0, 34, 85,
        241, 0, 0, 0, 0, 0, 35, 106, 189, 240, 0, 0, 0, 0, 36, 53, 211, 0, 0, 0, 0, 0, 37, 74, 159,
        240, 0, 0, 0, 0, 38, 21, 181, 0, 0, 0, 0, 0, 39, 42, 129, 240, 0, 0, 0, 0, 39, 254, 209,
        128, 0, 0, 0, 0, 41, 10, 99, 240, 0, 0, 0, 0, 41, 222, 179, 128, 0, 0, 0, 0, 42, 234, 69,
        240, 0, 0, 0, 0, 43, 190, 149, 128, 0, 0, 0, 0, 44, 211, 98, 112, 0, 0, 0, 0, 45, 158, 119,
        128, 0, 0, 0, 0, 46, 179, 68, 112, 0, 0, 0, 0, 47, 126, 89, 128, 0, 0, 0, 0, 48, 147, 38,
        112, 0, 0, 0, 0, 49, 103, 118, 0, 0, 0, 0, 0, 50, 115, 8, 112, 0, 0, 0, 0, 51, 71, 88, 0,
        0, 0, 0, 0, 52, 82, 234, 112, 0, 0, 0, 0, 53, 39, 58, 0, 0, 0, 0, 0, 54, 50, 204, 112, 0,
        0, 0, 0, 55, 7, 28, 0, 0, 0, 0, 0, 56, 27, 232, 240, 0, 0, 0, 0, 56, 230, 254, 0, 0, 0, 0,
        0, 57, 251, 202, 240, 0, 0, 0, 0, 58, 198, 224, 0, 0, 0, 0, 0, 59, 219, 172, 240, 0, 0, 0,
        0, 60, 175, 252, 128, 0, 0, 0, 0, 61, 187, 142, 240, 0, 0, 0, 0, 62, 143, 222, 128, 0, 0,
        0, 0, 63, 155, 112, 240, 0, 0, 0, 0, 64, 111, 192, 128, 0, 0, 0, 0, 65, 132, 141, 112, 0,
        0, 0, 0, 66, 79, 162, 128, 0, 0, 0, 0, 67, 100, 111, 112, 0, 0, 0, 0, 68, 47, 132, 128, 0,
        0, 0, 0, 69, 68, 81, 112, 0, 0, 0, 0, 69, 243, 183, 0, 2, 1, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 4, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 0, 0, 0, 0, 0, 0, 255, 255, 199, 192, 1, 4,
        255, 255, 171, 160, 0, 9, 255, 255, 185, 176, 1, 13, 255, 255, 185, 176, 0, 17, 45, 48, 48,
        0, 67, 68, 68, 84, 0, 67, 83, 84, 0, 67, 68, 84, 0, 69, 83, 84, 0, 10, 67, 83, 84, 54, 67,
        68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaRecife: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        39, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 150, 170, 103, 184, 255, 255, 255, 255,
        184, 15, 73, 224, 255, 255, 255, 255, 184, 253, 64, 160, 255, 255, 255, 255, 185, 241, 52,
        48, 255, 255, 255, 255, 186, 222, 116, 32, 255, 255, 255, 255, 218, 56, 174, 48, 255, 255,
        255, 255, 218, 235, 250, 48, 255, 255, 255, 255, 220, 25, 225, 176, 255, 255, 255, 255,
        220, 185, 89, 32, 255, 255, 255, 255, 221, 251, 21, 48, 255, 255, 255, 255, 222, 155, 222,
        32, 255, 255, 255, 255, 223, 221, 154, 48, 255, 255, 255, 255, 224, 84, 51, 32, 255, 255,
        255, 255, 244, 151, 255, 176, 255, 255, 255, 255, 245, 5, 94, 32, 255, 255, 255, 255, 246,
        192, 100, 48, 255, 255, 255, 255, 247, 14, 30, 160, 255, 255, 255, 255, 248, 81, 44, 48,
        255, 255, 255, 255, 248, 199, 197, 32, 255, 255, 255, 255, 250, 10, 210, 176, 255, 255,
        255, 255, 250, 168, 248, 160, 255, 255, 255, 255, 251, 236, 6, 48, 255, 255, 255, 255, 252,
        139, 125, 160, 0, 0, 0, 0, 29, 201, 142, 48, 0, 0, 0, 0, 30, 120, 215, 160, 0, 0, 0, 0, 31,
        160, 53, 176, 0, 0, 0, 0, 32, 51, 207, 160, 0, 0, 0, 0, 33, 129, 105, 48, 0, 0, 0, 0, 34,
        11, 200, 160, 0, 0, 0, 0, 35, 88, 16, 176, 0, 0, 0, 0, 35, 226, 112, 32, 0, 0, 0, 0, 37,
        55, 242, 176, 0, 0, 0, 0, 37, 212, 199, 32, 0, 0, 0, 0, 55, 246, 198, 176, 0, 0, 0, 0, 56,
        184, 133, 32, 0, 0, 0, 0, 57, 223, 227, 48, 0, 0, 0, 0, 57, 233, 15, 160, 0, 0, 0, 0, 59,
        200, 255, 176, 0, 0, 0, 0, 60, 111, 14, 160, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 255, 255, 223, 72,
        0, 0, 255, 255, 227, 224, 1, 4, 255, 255, 213, 208, 0, 8, 76, 77, 84, 0, 45, 48, 50, 0, 45,
        48, 51, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AmericaRegina: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        53, 0, 0, 0, 6, 0, 0, 0, 24, 255, 255, 255, 255, 134, 253, 147, 28, 255, 255, 255, 255,
        158, 184, 175, 144, 255, 255, 255, 255, 159, 187, 7, 128, 255, 255, 255, 255, 181, 101, 79,
        240, 255, 255, 255, 255, 182, 48, 72, 224, 255, 255, 255, 255, 183, 69, 49, 240, 255, 255,
        255, 255, 184, 16, 42, 224, 255, 255, 255, 255, 185, 37, 19, 240, 255, 255, 255, 255, 185,
        240, 12, 224, 255, 255, 255, 255, 187, 14, 48, 112, 255, 255, 255, 255, 187, 207, 238, 224,
        255, 255, 255, 255, 188, 238, 18, 112, 255, 255, 255, 255, 189, 185, 11, 96, 255, 255, 255,
        255, 194, 114, 8, 240, 255, 255, 255, 255, 195, 97, 235, 224, 255, 255, 255, 255, 196, 81,
        234, 240, 255, 255, 255, 255, 197, 56, 147, 96, 255, 255, 255, 255, 198, 49, 204, 240, 255,
        255, 255, 255, 199, 33, 175, 224, 255, 255, 255, 255, 200, 26, 233, 112, 255, 255, 255,
        255, 201, 10, 204, 96, 255, 255, 255, 255, 201, 250, 203, 112, 255, 255, 255, 255, 202,
        234, 174, 96, 255, 255, 255, 255, 203, 137, 12, 144, 255, 255, 255, 255, 210, 35, 244, 112,
        255, 255, 255, 255, 210, 97, 24, 0, 255, 255, 255, 255, 211, 99, 140, 16, 255, 255, 255,
        255, 212, 83, 111, 0, 255, 255, 255, 255, 213, 85, 227, 16, 255, 255, 255, 255, 214, 32,
        220, 0, 255, 255, 255, 255, 215, 53, 197, 16, 255, 255, 255, 255, 216, 0, 190, 0, 255, 255,
        255, 255, 217, 21, 167, 16, 255, 255, 255, 255, 217, 224, 160, 0, 255, 255, 255, 255, 218,
        254, 195, 144, 255, 255, 255, 255, 219, 192, 130, 0, 255, 255, 255, 255, 220, 222, 165,
        144, 255, 255, 255, 255, 221, 169, 158, 128, 255, 255, 255, 255, 222, 190, 135, 144, 255,
        255, 255, 255, 223, 137, 128, 128, 255, 255, 255, 255, 224, 158, 105, 144, 255, 255, 255,
        255, 225, 105, 98, 128, 255, 255, 255, 255, 226, 126, 75, 144, 255, 255, 255, 255, 227, 73,
        68, 128, 255, 255, 255, 255, 228, 94, 45, 144, 255, 255, 255, 255, 229, 41, 38, 128, 255,
        255, 255, 255, 230, 71, 74, 16, 255, 255, 255, 255, 231, 18, 67, 0, 255, 255, 255, 255,
        232, 39, 44, 16, 255, 255, 255, 255, 232, 242, 37, 0, 255, 255, 255, 255, 235, 230, 240,
        16, 255, 255, 255, 255, 236, 214, 211, 0, 255, 255, 255, 255, 237, 198, 210, 16, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 5, 255, 255, 157, 228, 0, 0, 255,
        255, 171, 160, 1, 4, 255, 255, 157, 144, 0, 8, 255, 255, 171, 160, 1, 12, 255, 255, 171,
        160, 1, 16, 255, 255, 171, 160, 0, 20, 76, 77, 84, 0, 77, 68, 84, 0, 77, 83, 84, 0, 77, 87,
        84, 0, 77, 80, 84, 0, 67, 83, 84, 0, 10, 67, 83, 84, 54, 10,
    ];
    pub(crate) const AmericaResolute: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        58, 0, 0, 0, 5, 0, 0, 0, 21, 255, 255, 255, 255, 213, 251, 129, 128, 255, 255, 255, 255,
        247, 47, 76, 96, 255, 255, 255, 255, 248, 40, 119, 224, 0, 0, 0, 0, 19, 105, 86, 0, 0, 0,
        0, 0, 20, 89, 56, 240, 0, 0, 0, 0, 21, 73, 56, 0, 0, 0, 0, 0, 22, 57, 26, 240, 0, 0, 0, 0,
        23, 41, 26, 0, 0, 0, 0, 0, 24, 34, 55, 112, 0, 0, 0, 0, 25, 8, 252, 0, 0, 0, 0, 0, 26, 2,
        25, 112, 0, 0, 0, 0, 26, 242, 24, 128, 0, 0, 0, 0, 27, 225, 251, 112, 0, 0, 0, 0, 28, 209,
        250, 128, 0, 0, 0, 0, 29, 193, 221, 112, 0, 0, 0, 0, 30, 177, 220, 128, 0, 0, 0, 0, 31,
        161, 191, 112, 0, 0, 0, 0, 32, 118, 15, 0, 0, 0, 0, 0, 33, 129, 161, 112, 0, 0, 0, 0, 34,
        85, 241, 0, 0, 0, 0, 0, 35, 106, 189, 240, 0, 0, 0, 0, 36, 53, 211, 0, 0, 0, 0, 0, 37, 74,
        159, 240, 0, 0, 0, 0, 38, 21, 181, 0, 0, 0, 0, 0, 39, 42, 129, 240, 0, 0, 0, 0, 39, 254,
        209, 128, 0, 0, 0, 0, 41, 10, 99, 240, 0, 0, 0, 0, 41, 222, 179, 128, 0, 0, 0, 0, 42, 234,
        69, 240, 0, 0, 0, 0, 43, 190, 149, 128, 0, 0, 0, 0, 44, 211, 98, 112, 0, 0, 0, 0, 45, 158,
        119, 128, 0, 0, 0, 0, 46, 179, 68, 112, 0, 0, 0, 0, 47, 126, 89, 128, 0, 0, 0, 0, 48, 147,
        38, 112, 0, 0, 0, 0, 49, 103, 118, 0, 0, 0, 0, 0, 50, 115, 8, 112, 0, 0, 0, 0, 51, 71, 88,
        0, 0, 0, 0, 0, 52, 82, 234, 112, 0, 0, 0, 0, 53, 39, 58, 0, 0, 0, 0, 0, 54, 50, 204, 112,
        0, 0, 0, 0, 55, 7, 28, 0, 0, 0, 0, 0, 56, 27, 232, 240, 0, 0, 0, 0, 56, 230, 254, 0, 0, 0,
        0, 0, 57, 251, 202, 240, 0, 0, 0, 0, 58, 198, 224, 0, 0, 0, 0, 0, 59, 219, 172, 240, 0, 0,
        0, 0, 60, 175, 252, 128, 0, 0, 0, 0, 61, 187, 142, 240, 0, 0, 0, 0, 62, 143, 222, 128, 0,
        0, 0, 0, 63, 155, 112, 240, 0, 0, 0, 0, 64, 111, 192, 128, 0, 0, 0, 0, 65, 132, 141, 112,
        0, 0, 0, 0, 66, 79, 162, 128, 0, 0, 0, 0, 67, 100, 111, 112, 0, 0, 0, 0, 68, 47, 132, 128,
        0, 0, 0, 0, 69, 68, 81, 112, 0, 0, 0, 0, 69, 243, 183, 0, 2, 1, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 4, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 3, 0, 0, 0, 0, 0, 0, 255, 255, 199, 192, 1,
        4, 255, 255, 171, 160, 0, 9, 255, 255, 185, 176, 1, 13, 255, 255, 185, 176, 0, 17, 45, 48,
        48, 0, 67, 68, 68, 84, 0, 67, 83, 84, 0, 67, 68, 84, 0, 69, 83, 84, 0, 10, 67, 83, 84, 54,
        67, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaSantarem: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        30, 0, 0, 0, 4, 0, 0, 0, 12, 255, 255, 255, 255, 150, 170, 122, 72, 255, 255, 255, 255,
        184, 15, 87, 240, 255, 255, 255, 255, 184, 253, 78, 176, 255, 255, 255, 255, 185, 241, 66,
        64, 255, 255, 255, 255, 186, 222, 130, 48, 255, 255, 255, 255, 218, 56, 188, 64, 255, 255,
        255, 255, 218, 236, 8, 64, 255, 255, 255, 255, 220, 25, 239, 192, 255, 255, 255, 255, 220,
        185, 103, 48, 255, 255, 255, 255, 221, 251, 35, 64, 255, 255, 255, 255, 222, 155, 236, 48,
        255, 255, 255, 255, 223, 221, 168, 64, 255, 255, 255, 255, 224, 84, 65, 48, 255, 255, 255,
        255, 244, 152, 13, 192, 255, 255, 255, 255, 245, 5, 108, 48, 255, 255, 255, 255, 246, 192,
        114, 64, 255, 255, 255, 255, 247, 14, 44, 176, 255, 255, 255, 255, 248, 81, 58, 64, 255,
        255, 255, 255, 248, 199, 211, 48, 255, 255, 255, 255, 250, 10, 224, 192, 255, 255, 255,
        255, 250, 169, 6, 176, 255, 255, 255, 255, 251, 236, 20, 64, 255, 255, 255, 255, 252, 139,
        139, 176, 0, 0, 0, 0, 29, 201, 156, 64, 0, 0, 0, 0, 30, 120, 229, 176, 0, 0, 0, 0, 31, 160,
        67, 192, 0, 0, 0, 0, 32, 51, 221, 176, 0, 0, 0, 0, 33, 129, 119, 64, 0, 0, 0, 0, 34, 11,
        214, 176, 0, 0, 0, 0, 72, 96, 113, 64, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 255, 255, 204, 184, 0, 0, 255, 255, 213, 208, 1, 4,
        255, 255, 199, 192, 0, 8, 255, 255, 213, 208, 0, 4, 76, 77, 84, 0, 45, 48, 51, 0, 45, 48,
        52, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AmericaSantiago: &[u8] = &[
        84, 90, 105, 102, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 51,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        122, 0, 0, 0, 6, 0, 0, 0, 20, 255, 255, 255, 255, 105, 135, 29, 198, 255, 255, 255, 255,
        143, 48, 71, 70, 255, 255, 255, 255, 155, 92, 229, 80, 255, 255, 255, 255, 159, 124, 226,
        198, 255, 255, 255, 255, 161, 0, 113, 192, 255, 255, 255, 255, 176, 94, 119, 198, 255, 255,
        255, 255, 177, 119, 61, 64, 255, 255, 255, 255, 178, 65, 0, 208, 255, 255, 255, 255, 179,
        88, 112, 192, 255, 255, 255, 255, 180, 34, 52, 80, 255, 255, 255, 255, 181, 57, 164, 64,
        255, 255, 255, 255, 182, 3, 103, 208, 255, 255, 255, 255, 183, 26, 215, 192, 255, 255, 255,
        255, 183, 228, 155, 80, 255, 255, 255, 255, 184, 253, 92, 192, 255, 255, 255, 255, 185,
        199, 32, 80, 255, 255, 255, 255, 204, 28, 110, 64, 255, 255, 255, 255, 204, 108, 231, 208,
        255, 255, 255, 255, 211, 220, 143, 192, 255, 255, 255, 255, 212, 27, 201, 176, 255, 255,
        255, 255, 213, 51, 85, 192, 255, 255, 255, 255, 213, 118, 146, 64, 255, 255, 255, 255, 253,
        209, 60, 64, 255, 255, 255, 255, 254, 146, 250, 176, 255, 255, 255, 255, 255, 204, 205,
        192, 0, 0, 0, 0, 0, 114, 220, 176, 0, 0, 0, 0, 1, 117, 80, 192, 0, 0, 0, 0, 2, 64, 73, 176,
        0, 0, 0, 0, 3, 85, 50, 192, 0, 0, 0, 0, 4, 32, 43, 176, 0, 0, 0, 0, 5, 62, 79, 64, 0, 0, 0,
        0, 6, 0, 13, 176, 0, 0, 0, 0, 7, 11, 188, 64, 0, 0, 0, 0, 7, 223, 239, 176, 0, 0, 0, 0, 8,
        254, 19, 64, 0, 0, 0, 0, 9, 191, 209, 176, 0, 0, 0, 0, 10, 221, 245, 64, 0, 0, 0, 0, 11,
        168, 238, 48, 0, 0, 0, 0, 12, 189, 215, 64, 0, 0, 0, 0, 13, 136, 208, 48, 0, 0, 0, 0, 14,
        157, 185, 64, 0, 0, 0, 0, 15, 104, 178, 48, 0, 0, 0, 0, 16, 134, 213, 192, 0, 0, 0, 0, 17,
        72, 148, 48, 0, 0, 0, 0, 18, 102, 183, 192, 0, 0, 0, 0, 19, 40, 118, 48, 0, 0, 0, 0, 20,
        70, 153, 192, 0, 0, 0, 0, 21, 17, 146, 176, 0, 0, 0, 0, 22, 38, 123, 192, 0, 0, 0, 0, 22,
        241, 116, 176, 0, 0, 0, 0, 24, 6, 93, 192, 0, 0, 0, 0, 24, 209, 86, 176, 0, 0, 0, 0, 25,
        230, 63, 192, 0, 0, 0, 0, 26, 177, 56, 176, 0, 0, 0, 0, 27, 207, 92, 64, 0, 0, 0, 0, 28,
        145, 26, 176, 0, 0, 0, 0, 29, 175, 62, 64, 0, 0, 0, 0, 30, 112, 252, 176, 0, 0, 0, 0, 31,
        143, 32, 64, 0, 0, 0, 0, 32, 127, 3, 48, 0, 0, 0, 0, 33, 111, 2, 64, 0, 0, 0, 0, 34, 57,
        251, 48, 0, 0, 0, 0, 35, 78, 228, 64, 0, 0, 0, 0, 36, 25, 221, 48, 0, 0, 0, 0, 37, 56, 0,
        192, 0, 0, 0, 0, 37, 249, 191, 48, 0, 0, 0, 0, 38, 242, 248, 192, 0, 0, 0, 0, 39, 217, 161,
        48, 0, 0, 0, 0, 40, 247, 196, 192, 0, 0, 0, 0, 41, 194, 189, 176, 0, 0, 0, 0, 42, 215, 166,
        192, 0, 0, 0, 0, 43, 162, 159, 176, 0, 0, 0, 0, 44, 183, 136, 192, 0, 0, 0, 0, 45, 130,
        129, 176, 0, 0, 0, 0, 46, 151, 106, 192, 0, 0, 0, 0, 47, 98, 99, 176, 0, 0, 0, 0, 48, 128,
        135, 64, 0, 0, 0, 0, 49, 66, 69, 176, 0, 0, 0, 0, 50, 96, 105, 64, 0, 0, 0, 0, 51, 61, 215,
        48, 0, 0, 0, 0, 52, 64, 75, 64, 0, 0, 0, 0, 53, 11, 68, 48, 0, 0, 0, 0, 54, 13, 184, 64, 0,
        0, 0, 0, 55, 6, 213, 176, 0, 0, 0, 0, 56, 0, 15, 64, 0, 0, 0, 0, 56, 203, 8, 48, 0, 0, 0,
        0, 57, 233, 43, 192, 0, 0, 0, 0, 58, 170, 234, 48, 0, 0, 0, 0, 59, 201, 13, 192, 0, 0, 0,
        0, 60, 138, 204, 48, 0, 0, 0, 0, 61, 168, 239, 192, 0, 0, 0, 0, 62, 106, 174, 48, 0, 0, 0,
        0, 63, 136, 209, 192, 0, 0, 0, 0, 64, 83, 202, 176, 0, 0, 0, 0, 65, 104, 179, 192, 0, 0, 0,
        0, 66, 51, 172, 176, 0, 0, 0, 0, 67, 72, 149, 192, 0, 0, 0, 0, 68, 19, 142, 176, 0, 0, 0,
        0, 69, 49, 178, 64, 0, 0, 0, 0, 69, 243, 112, 176, 0, 0, 0, 0, 71, 17, 148, 64, 0, 0, 0, 0,
        71, 239, 2, 48, 0, 0, 0, 0, 72, 241, 118, 64, 0, 0, 0, 0, 73, 188, 111, 48, 0, 0, 0, 0, 74,
        209, 88, 64, 0, 0, 0, 0, 75, 184, 0, 176, 0, 0, 0, 0, 76, 177, 58, 64, 0, 0, 0, 0, 77, 198,
        7, 48, 0, 0, 0, 0, 78, 80, 130, 192, 0, 0, 0, 0, 79, 156, 174, 176, 0, 0, 0, 0, 80, 66,
        217, 192, 0, 0, 0, 0, 81, 124, 144, 176, 0, 0, 0, 0, 82, 43, 246, 64, 0, 0, 0, 0, 83, 92,
        114, 176, 0, 0, 0, 0, 84, 11, 216, 64, 0, 0, 0, 0, 87, 55, 230, 48, 0, 0, 0, 0, 87, 175,
        236, 192, 0, 0, 0, 0, 89, 23, 200, 48, 0, 0, 0, 0, 89, 143, 206, 192, 0, 0, 0, 0, 90, 247,
        170, 48, 0, 0, 0, 0, 91, 111, 176, 192, 0, 0, 0, 0, 92, 169, 103, 176, 1, 2, 1, 3, 1, 4, 2,
        4, 2, 4, 2, 4, 2, 4, 2, 3, 2, 3, 5, 3, 2, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5,
        3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5,
        3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5,
        3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 255, 255, 189,
        186, 0, 0, 255, 255, 189, 186, 0, 4, 255, 255, 185, 176, 0, 8, 255, 255, 199, 192, 0, 12,
        255, 255, 199, 192, 1, 12, 255, 255, 213, 208, 1, 16, 76, 77, 84, 0, 83, 77, 84, 0, 45, 48,
        53, 0, 45, 48, 52, 0, 45, 48, 51, 0, 10, 60, 45, 48, 52, 62, 52, 60, 45, 48, 51, 62, 44,
        77, 57, 46, 49, 46, 54, 47, 50, 52, 44, 77, 52, 46, 49, 46, 54, 47, 50, 52, 10,
    ];
    pub(crate) const AmericaSantoDomingo: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        17, 0, 0, 0, 6, 0, 0, 0, 27, 255, 255, 255, 255, 105, 135, 29, 8, 255, 255, 255, 255, 186,
        223, 66, 96, 255, 255, 255, 255, 250, 8, 75, 208, 255, 255, 255, 255, 250, 167, 195, 64,
        255, 255, 255, 255, 255, 167, 241, 208, 0, 0, 0, 0, 0, 67, 123, 200, 0, 0, 0, 0, 1, 135,
        211, 208, 0, 0, 0, 0, 1, 250, 127, 72, 0, 0, 0, 0, 3, 112, 240, 80, 0, 0, 0, 0, 3, 221, 4,
        72, 0, 0, 0, 0, 5, 80, 210, 80, 0, 0, 0, 0, 5, 191, 137, 72, 0, 0, 0, 0, 7, 48, 180, 80, 0,
        0, 0, 0, 7, 160, 188, 200, 0, 0, 0, 0, 9, 16, 150, 80, 0, 0, 0, 0, 57, 251, 188, 224, 0, 0,
        0, 0, 58, 41, 225, 96, 1, 3, 2, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 5, 3, 5, 255, 255, 190,
        120, 0, 0, 255, 255, 190, 96, 0, 4, 255, 255, 199, 192, 1, 9, 255, 255, 185, 176, 0, 13,
        255, 255, 192, 184, 1, 17, 255, 255, 199, 192, 0, 23, 76, 77, 84, 0, 83, 68, 77, 84, 0, 69,
        68, 84, 0, 69, 83, 84, 0, 45, 48, 52, 51, 48, 0, 65, 83, 84, 0, 10, 65, 83, 84, 52, 10,
    ];
    pub(crate) const AmericaSaoPaulo: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        91, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 150, 170, 114, 180, 255, 255, 255, 255,
        184, 15, 73, 224, 255, 255, 255, 255, 184, 253, 64, 160, 255, 255, 255, 255, 185, 241, 52,
        48, 255, 255, 255, 255, 186, 222, 116, 32, 255, 255, 255, 255, 218, 56, 174, 48, 255, 255,
        255, 255, 218, 235, 250, 48, 255, 255, 255, 255, 220, 25, 225, 176, 255, 255, 255, 255,
        220, 185, 89, 32, 255, 255, 255, 255, 221, 251, 21, 48, 255, 255, 255, 255, 222, 155, 222,
        32, 255, 255, 255, 255, 223, 221, 154, 48, 255, 255, 255, 255, 224, 84, 51, 32, 255, 255,
        255, 255, 244, 90, 9, 48, 255, 255, 255, 255, 245, 5, 94, 32, 255, 255, 255, 255, 246, 192,
        100, 48, 255, 255, 255, 255, 247, 14, 30, 160, 255, 255, 255, 255, 248, 81, 44, 48, 255,
        255, 255, 255, 248, 199, 197, 32, 255, 255, 255, 255, 250, 10, 210, 176, 255, 255, 255,
        255, 250, 168, 248, 160, 255, 255, 255, 255, 251, 236, 6, 48, 255, 255, 255, 255, 252, 139,
        125, 160, 0, 0, 0, 0, 29, 201, 142, 48, 0, 0, 0, 0, 30, 120, 215, 160, 0, 0, 0, 0, 31, 160,
        53, 176, 0, 0, 0, 0, 32, 51, 207, 160, 0, 0, 0, 0, 33, 129, 105, 48, 0, 0, 0, 0, 34, 11,
        200, 160, 0, 0, 0, 0, 35, 88, 16, 176, 0, 0, 0, 0, 35, 226, 112, 32, 0, 0, 0, 0, 37, 55,
        242, 176, 0, 0, 0, 0, 37, 212, 199, 32, 0, 0, 0, 0, 39, 33, 15, 48, 0, 0, 0, 0, 39, 189,
        227, 160, 0, 0, 0, 0, 41, 0, 241, 48, 0, 0, 0, 0, 41, 148, 139, 32, 0, 0, 0, 0, 42, 234,
        13, 176, 0, 0, 0, 0, 43, 107, 50, 160, 0, 0, 0, 0, 44, 192, 181, 48, 0, 0, 0, 0, 45, 102,
        196, 32, 0, 0, 0, 0, 46, 160, 151, 48, 0, 0, 0, 0, 47, 70, 166, 32, 0, 0, 0, 0, 48, 128,
        121, 48, 0, 0, 0, 0, 49, 29, 77, 160, 0, 0, 0, 0, 50, 87, 32, 176, 0, 0, 0, 0, 51, 6, 106,
        32, 0, 0, 0, 0, 52, 56, 84, 48, 0, 0, 0, 0, 52, 248, 193, 32, 0, 0, 0, 0, 54, 32, 31, 48,
        0, 0, 0, 0, 54, 207, 104, 160, 0, 0, 0, 0, 55, 246, 198, 176, 0, 0, 0, 0, 56, 184, 133, 32,
        0, 0, 0, 0, 57, 223, 227, 48, 0, 0, 0, 0, 58, 143, 44, 160, 0, 0, 0, 0, 59, 200, 255, 176,
        0, 0, 0, 0, 60, 111, 14, 160, 0, 0, 0, 0, 61, 196, 145, 48, 0, 0, 0, 0, 62, 78, 240, 160,
        0, 0, 0, 0, 63, 145, 254, 48, 0, 0, 0, 0, 64, 46, 210, 160, 0, 0, 0, 0, 65, 134, 248, 48,
        0, 0, 0, 0, 66, 23, 239, 32, 0, 0, 0, 0, 67, 81, 194, 48, 0, 0, 0, 0, 67, 247, 209, 32, 0,
        0, 0, 0, 69, 77, 83, 176, 0, 0, 0, 0, 69, 224, 237, 160, 0, 0, 0, 0, 71, 17, 134, 48, 0, 0,
        0, 0, 71, 183, 149, 32, 0, 0, 0, 0, 72, 250, 162, 176, 0, 0, 0, 0, 73, 151, 119, 32, 0, 0,
        0, 0, 74, 218, 132, 176, 0, 0, 0, 0, 75, 128, 147, 160, 0, 0, 0, 0, 76, 186, 102, 176, 0,
        0, 0, 0, 77, 96, 117, 160, 0, 0, 0, 0, 78, 154, 72, 176, 0, 0, 0, 0, 79, 73, 146, 32, 0, 0,
        0, 0, 80, 131, 101, 48, 0, 0, 0, 0, 81, 32, 57, 160, 0, 0, 0, 0, 82, 99, 71, 48, 0, 0, 0,
        0, 83, 0, 27, 160, 0, 0, 0, 0, 84, 67, 41, 48, 0, 0, 0, 0, 84, 233, 56, 32, 0, 0, 0, 0, 86,
        35, 11, 48, 0, 0, 0, 0, 86, 201, 26, 32, 0, 0, 0, 0, 88, 2, 237, 48, 0, 0, 0, 0, 88, 168,
        252, 32, 0, 0, 0, 0, 89, 226, 207, 48, 0, 0, 0, 0, 90, 136, 222, 32, 0, 0, 0, 0, 91, 222,
        96, 176, 0, 0, 0, 0, 92, 104, 192, 32, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 255, 255, 212, 76, 0, 0, 255, 255, 227, 224, 1,
        4, 255, 255, 213, 208, 0, 8, 76, 77, 84, 0, 45, 48, 50, 0, 45, 48, 51, 0, 10, 60, 45, 48,
        51, 62, 51, 10,
    ];
    pub(crate) const AmericaScoresbysund: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        34, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 155, 128, 76, 24, 0, 0, 0, 0, 19, 77, 110,
        64, 0, 0, 0, 0, 20, 52, 36, 192, 0, 0, 0, 0, 21, 35, 249, 160, 0, 0, 0, 0, 22, 19, 220,
        144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23, 243, 190, 144, 0, 0, 0, 0, 24, 227, 175,
        144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 188,
        189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140,
        144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92,
        99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16,
        0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0,
        0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0,
        0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0,
        0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0,
        0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 1, 2, 1, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 255, 255, 235, 104, 0,
        0, 255, 255, 227, 224, 0, 4, 255, 255, 241, 240, 1, 8, 255, 255, 241, 240, 0, 8, 0, 0, 0,
        0, 1, 12, 76, 77, 84, 0, 45, 48, 50, 0, 45, 48, 49, 0, 43, 48, 48, 0, 10, 60, 45, 48, 49,
        62, 49, 60, 43, 48, 48, 62, 44, 77, 51, 46, 53, 46, 48, 47, 48, 44, 77, 49, 48, 46, 53, 46,
        48, 47, 49, 10,
    ];
    pub(crate) const AmericaSitka: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        83, 0, 0, 0, 9, 0, 0, 0, 34, 255, 255, 255, 255, 63, 194, 253, 209, 255, 255, 255, 255,
        125, 135, 51, 153, 255, 255, 255, 255, 203, 137, 26, 160, 255, 255, 255, 255, 210, 35, 244,
        112, 255, 255, 255, 255, 210, 97, 38, 16, 255, 255, 255, 255, 254, 184, 71, 32, 255, 255,
        255, 255, 255, 168, 42, 16, 0, 0, 0, 0, 0, 152, 41, 32, 0, 0, 0, 0, 1, 136, 12, 16, 0, 0,
        0, 0, 2, 120, 11, 32, 0, 0, 0, 0, 3, 113, 40, 144, 0, 0, 0, 0, 4, 97, 39, 160, 0, 0, 0, 0,
        5, 81, 10, 144, 0, 0, 0, 0, 6, 65, 9, 160, 0, 0, 0, 0, 7, 48, 236, 144, 0, 0, 0, 0, 7, 141,
        67, 160, 0, 0, 0, 0, 9, 16, 206, 144, 0, 0, 0, 0, 9, 173, 191, 32, 0, 0, 0, 0, 10, 240,
        176, 144, 0, 0, 0, 0, 11, 224, 175, 160, 0, 0, 0, 0, 12, 217, 205, 16, 0, 0, 0, 0, 13, 192,
        145, 160, 0, 0, 0, 0, 14, 185, 175, 16, 0, 0, 0, 0, 15, 169, 174, 32, 0, 0, 0, 0, 16, 153,
        145, 16, 0, 0, 0, 0, 17, 137, 144, 32, 0, 0, 0, 0, 18, 121, 115, 16, 0, 0, 0, 0, 19, 105,
        114, 32, 0, 0, 0, 0, 20, 89, 85, 16, 0, 0, 0, 0, 21, 73, 84, 32, 0, 0, 0, 0, 22, 57, 55,
        16, 0, 0, 0, 0, 23, 41, 54, 32, 0, 0, 0, 0, 24, 34, 83, 144, 0, 0, 0, 0, 25, 9, 24, 32, 0,
        0, 0, 0, 26, 2, 53, 144, 0, 0, 0, 0, 26, 43, 20, 16, 0, 0, 0, 0, 26, 242, 66, 176, 0, 0, 0,
        0, 27, 226, 37, 160, 0, 0, 0, 0, 28, 210, 36, 176, 0, 0, 0, 0, 29, 194, 7, 160, 0, 0, 0, 0,
        30, 178, 6, 176, 0, 0, 0, 0, 31, 161, 233, 160, 0, 0, 0, 0, 32, 118, 57, 48, 0, 0, 0, 0,
        33, 129, 203, 160, 0, 0, 0, 0, 34, 86, 27, 48, 0, 0, 0, 0, 35, 106, 232, 32, 0, 0, 0, 0,
        36, 53, 253, 48, 0, 0, 0, 0, 37, 74, 202, 32, 0, 0, 0, 0, 38, 21, 223, 48, 0, 0, 0, 0, 39,
        42, 172, 32, 0, 0, 0, 0, 39, 254, 251, 176, 0, 0, 0, 0, 41, 10, 142, 32, 0, 0, 0, 0, 41,
        222, 221, 176, 0, 0, 0, 0, 42, 234, 112, 32, 0, 0, 0, 0, 43, 190, 191, 176, 0, 0, 0, 0, 44,
        211, 140, 160, 0, 0, 0, 0, 45, 158, 161, 176, 0, 0, 0, 0, 46, 179, 110, 160, 0, 0, 0, 0,
        47, 126, 131, 176, 0, 0, 0, 0, 48, 147, 80, 160, 0, 0, 0, 0, 49, 103, 160, 48, 0, 0, 0, 0,
        50, 115, 50, 160, 0, 0, 0, 0, 51, 71, 130, 48, 0, 0, 0, 0, 52, 83, 20, 160, 0, 0, 0, 0, 53,
        39, 100, 48, 0, 0, 0, 0, 54, 50, 246, 160, 0, 0, 0, 0, 55, 7, 70, 48, 0, 0, 0, 0, 56, 28,
        19, 32, 0, 0, 0, 0, 56, 231, 40, 48, 0, 0, 0, 0, 57, 251, 245, 32, 0, 0, 0, 0, 58, 199, 10,
        48, 0, 0, 0, 0, 59, 219, 215, 32, 0, 0, 0, 0, 60, 176, 38, 176, 0, 0, 0, 0, 61, 187, 185,
        32, 0, 0, 0, 0, 62, 144, 8, 176, 0, 0, 0, 0, 63, 155, 155, 32, 0, 0, 0, 0, 64, 111, 234,
        176, 0, 0, 0, 0, 65, 132, 183, 160, 0, 0, 0, 0, 66, 79, 204, 176, 0, 0, 0, 0, 67, 100, 153,
        160, 0, 0, 0, 0, 68, 47, 174, 176, 0, 0, 0, 0, 69, 68, 123, 160, 0, 0, 0, 0, 69, 243, 225,
        48, 1, 2, 3, 4, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2,
        5, 2, 5, 2, 5, 6, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7,
        8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 0, 0, 210, 167, 0,
        0, 255, 255, 129, 39, 0, 0, 255, 255, 143, 128, 0, 4, 255, 255, 157, 144, 1, 8, 255, 255,
        157, 144, 1, 12, 255, 255, 157, 144, 1, 16, 255, 255, 129, 112, 0, 20, 255, 255, 143, 128,
        1, 24, 255, 255, 129, 112, 0, 29, 76, 77, 84, 0, 80, 83, 84, 0, 80, 87, 84, 0, 80, 80, 84,
        0, 80, 68, 84, 0, 89, 83, 84, 0, 65, 75, 68, 84, 0, 65, 75, 83, 84, 0, 10, 65, 75, 83, 84,
        57, 65, 75, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaStJohns: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        187, 0, 0, 0, 8, 0, 0, 0, 25, 255, 255, 255, 255, 94, 61, 52, 236, 255, 255, 255, 255, 156,
        207, 98, 12, 255, 255, 255, 255, 157, 164, 230, 252, 255, 255, 255, 255, 158, 184, 126,
        140, 255, 255, 255, 255, 159, 186, 214, 124, 255, 255, 255, 255, 160, 182, 136, 220, 255,
        255, 255, 255, 161, 56, 255, 76, 255, 255, 255, 255, 162, 149, 25, 92, 255, 255, 255, 255,
        163, 132, 252, 76, 255, 255, 255, 255, 164, 116, 251, 92, 255, 255, 255, 255, 165, 100,
        222, 76, 255, 255, 255, 255, 166, 94, 23, 220, 255, 255, 255, 255, 167, 68, 192, 76, 255,
        255, 255, 255, 168, 61, 249, 220, 255, 255, 255, 255, 169, 36, 162, 76, 255, 255, 255, 255,
        170, 29, 219, 220, 255, 255, 255, 255, 171, 4, 132, 76, 255, 255, 255, 255, 171, 253, 189,
        220, 255, 255, 255, 255, 172, 228, 102, 76, 255, 255, 255, 255, 173, 221, 159, 220, 255,
        255, 255, 255, 174, 205, 130, 204, 255, 255, 255, 255, 175, 189, 129, 220, 255, 255, 255,
        255, 176, 173, 100, 204, 255, 255, 255, 255, 177, 166, 158, 92, 255, 255, 255, 255, 178,
        141, 70, 204, 255, 255, 255, 255, 179, 134, 128, 92, 255, 255, 255, 255, 180, 109, 40, 204,
        255, 255, 255, 255, 181, 102, 98, 92, 255, 255, 255, 255, 182, 77, 10, 204, 255, 255, 255,
        255, 183, 70, 68, 92, 255, 255, 255, 255, 184, 44, 236, 204, 255, 255, 255, 255, 185, 38,
        38, 92, 255, 255, 255, 255, 186, 22, 9, 76, 255, 255, 255, 255, 187, 15, 66, 220, 255, 255,
        255, 255, 187, 245, 235, 76, 255, 255, 255, 255, 188, 239, 36, 220, 255, 255, 255, 255,
        189, 213, 205, 76, 255, 255, 255, 255, 190, 158, 77, 108, 255, 255, 255, 255, 190, 207, 6,
        168, 255, 255, 255, 255, 191, 181, 175, 24, 255, 255, 255, 255, 192, 184, 49, 56, 255, 255,
        255, 255, 193, 121, 239, 168, 255, 255, 255, 255, 194, 152, 19, 56, 255, 255, 255, 255,
        195, 89, 209, 168, 255, 255, 255, 255, 196, 119, 245, 56, 255, 255, 255, 255, 197, 57, 179,
        168, 255, 255, 255, 255, 198, 97, 17, 184, 255, 255, 255, 255, 199, 25, 149, 168, 255, 255,
        255, 255, 200, 64, 243, 184, 255, 255, 255, 255, 201, 2, 178, 40, 255, 255, 255, 255, 202,
        32, 213, 184, 255, 255, 255, 255, 202, 226, 148, 40, 255, 255, 255, 255, 204, 0, 183, 184,
        255, 255, 255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 96, 230, 200, 255, 255,
        255, 255, 211, 136, 68, 216, 255, 255, 255, 255, 212, 74, 3, 72, 255, 255, 255, 255, 213,
        104, 38, 216, 255, 255, 255, 255, 214, 41, 229, 72, 255, 255, 255, 255, 215, 72, 8, 216,
        255, 255, 255, 255, 216, 9, 199, 72, 255, 255, 255, 255, 217, 39, 234, 216, 255, 255, 255,
        255, 217, 233, 169, 72, 255, 255, 255, 255, 219, 17, 7, 88, 255, 255, 255, 255, 219, 210,
        197, 200, 255, 255, 255, 255, 220, 222, 116, 88, 255, 255, 255, 255, 221, 169, 109, 72,
        255, 255, 255, 255, 222, 190, 86, 88, 255, 255, 255, 255, 223, 137, 79, 72, 255, 255, 255,
        255, 224, 158, 56, 88, 255, 255, 255, 255, 225, 105, 49, 72, 255, 255, 255, 255, 226, 126,
        26, 88, 255, 255, 255, 255, 227, 73, 19, 72, 255, 255, 255, 255, 228, 93, 252, 88, 255,
        255, 255, 255, 229, 40, 245, 72, 255, 255, 255, 255, 230, 71, 24, 216, 255, 255, 255, 255,
        231, 18, 17, 200, 255, 255, 255, 255, 232, 38, 250, 216, 255, 255, 255, 255, 232, 241, 243,
        200, 255, 255, 255, 255, 234, 6, 220, 216, 255, 255, 255, 255, 234, 209, 213, 200, 255,
        255, 255, 255, 235, 230, 190, 216, 255, 255, 255, 255, 236, 177, 183, 200, 255, 255, 255,
        255, 237, 198, 160, 216, 255, 255, 255, 255, 238, 191, 190, 72, 255, 255, 255, 255, 239,
        175, 189, 88, 255, 255, 255, 255, 240, 159, 160, 72, 255, 255, 255, 255, 241, 143, 159, 88,
        255, 255, 255, 255, 242, 127, 130, 72, 255, 255, 255, 255, 243, 111, 129, 88, 255, 255,
        255, 255, 244, 95, 100, 72, 255, 255, 255, 255, 245, 79, 99, 88, 255, 255, 255, 255, 246,
        63, 70, 72, 255, 255, 255, 255, 247, 47, 69, 88, 255, 255, 255, 255, 248, 40, 98, 200, 255,
        255, 255, 255, 249, 15, 39, 88, 255, 255, 255, 255, 250, 8, 68, 200, 255, 255, 255, 255,
        250, 248, 67, 216, 255, 255, 255, 255, 251, 232, 38, 200, 255, 255, 255, 255, 252, 216, 37,
        216, 255, 255, 255, 255, 253, 200, 8, 200, 255, 255, 255, 255, 254, 184, 7, 216, 255, 255,
        255, 255, 255, 167, 234, 200, 0, 0, 0, 0, 0, 151, 233, 216, 0, 0, 0, 0, 1, 135, 204, 200,
        0, 0, 0, 0, 2, 119, 203, 216, 0, 0, 0, 0, 3, 112, 233, 72, 0, 0, 0, 0, 4, 96, 232, 88, 0,
        0, 0, 0, 5, 80, 203, 72, 0, 0, 0, 0, 6, 64, 202, 88, 0, 0, 0, 0, 7, 48, 173, 72, 0, 0, 0,
        0, 8, 32, 172, 88, 0, 0, 0, 0, 9, 16, 143, 72, 0, 0, 0, 0, 10, 0, 142, 88, 0, 0, 0, 0, 10,
        240, 113, 72, 0, 0, 0, 0, 11, 224, 112, 88, 0, 0, 0, 0, 12, 217, 141, 200, 0, 0, 0, 0, 13,
        192, 82, 88, 0, 0, 0, 0, 14, 185, 111, 200, 0, 0, 0, 0, 15, 169, 110, 216, 0, 0, 0, 0, 16,
        153, 81, 200, 0, 0, 0, 0, 17, 137, 80, 216, 0, 0, 0, 0, 18, 121, 51, 200, 0, 0, 0, 0, 19,
        105, 50, 216, 0, 0, 0, 0, 20, 89, 21, 200, 0, 0, 0, 0, 21, 73, 20, 216, 0, 0, 0, 0, 22, 56,
        247, 200, 0, 0, 0, 0, 23, 40, 246, 216, 0, 0, 0, 0, 24, 34, 20, 72, 0, 0, 0, 0, 25, 8, 216,
        216, 0, 0, 0, 0, 26, 1, 246, 72, 0, 0, 0, 0, 26, 241, 245, 88, 0, 0, 0, 0, 27, 225, 216,
        72, 0, 0, 0, 0, 28, 209, 215, 88, 0, 0, 0, 0, 29, 193, 186, 72, 0, 0, 0, 0, 30, 177, 185,
        88, 0, 0, 0, 0, 31, 161, 156, 72, 0, 0, 0, 0, 32, 117, 207, 244, 0, 0, 0, 0, 33, 129, 98,
        100, 0, 0, 0, 0, 34, 85, 177, 244, 0, 0, 0, 0, 35, 106, 112, 212, 0, 0, 0, 0, 36, 53, 147,
        244, 0, 0, 0, 0, 37, 74, 96, 228, 0, 0, 0, 0, 38, 21, 117, 244, 0, 0, 0, 0, 39, 42, 66,
        228, 0, 0, 0, 0, 39, 254, 146, 116, 0, 0, 0, 0, 41, 10, 36, 228, 0, 0, 0, 0, 41, 222, 116,
        116, 0, 0, 0, 0, 42, 234, 6, 228, 0, 0, 0, 0, 43, 190, 86, 116, 0, 0, 0, 0, 44, 211, 35,
        100, 0, 0, 0, 0, 45, 158, 56, 116, 0, 0, 0, 0, 46, 179, 5, 100, 0, 0, 0, 0, 47, 126, 26,
        116, 0, 0, 0, 0, 48, 146, 231, 100, 0, 0, 0, 0, 49, 103, 54, 244, 0, 0, 0, 0, 50, 114, 201,
        100, 0, 0, 0, 0, 51, 71, 24, 244, 0, 0, 0, 0, 52, 82, 171, 100, 0, 0, 0, 0, 53, 38, 250,
        244, 0, 0, 0, 0, 54, 50, 141, 100, 0, 0, 0, 0, 55, 6, 220, 244, 0, 0, 0, 0, 56, 27, 169,
        228, 0, 0, 0, 0, 56, 230, 190, 244, 0, 0, 0, 0, 57, 251, 139, 228, 0, 0, 0, 0, 58, 198,
        160, 244, 0, 0, 0, 0, 59, 219, 109, 228, 0, 0, 0, 0, 60, 175, 189, 116, 0, 0, 0, 0, 61,
        187, 79, 228, 0, 0, 0, 0, 62, 143, 159, 116, 0, 0, 0, 0, 63, 155, 49, 228, 0, 0, 0, 0, 64,
        111, 129, 116, 0, 0, 0, 0, 65, 132, 78, 100, 0, 0, 0, 0, 66, 79, 99, 116, 0, 0, 0, 0, 67,
        100, 48, 100, 0, 0, 0, 0, 68, 47, 69, 116, 0, 0, 0, 0, 69, 68, 18, 100, 0, 0, 0, 0, 69,
        243, 119, 244, 0, 0, 0, 0, 71, 45, 46, 228, 0, 0, 0, 0, 71, 211, 89, 244, 0, 0, 0, 0, 73,
        13, 16, 228, 0, 0, 0, 0, 73, 179, 59, 244, 0, 0, 0, 0, 74, 236, 242, 228, 0, 0, 0, 0, 75,
        156, 88, 116, 0, 0, 0, 0, 76, 214, 15, 100, 0, 0, 0, 0, 77, 124, 58, 116, 0, 0, 0, 0, 78,
        182, 13, 72, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 6, 5, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 7, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 255, 255, 206, 148, 0, 0, 255, 255, 220, 164, 1, 4, 255,
        255, 206, 148, 0, 8, 255, 255, 220, 216, 1, 4, 255, 255, 206, 200, 0, 8, 255, 255, 220,
        216, 1, 12, 255, 255, 220, 216, 1, 16, 255, 255, 234, 232, 1, 20, 76, 77, 84, 0, 78, 68,
        84, 0, 78, 83, 84, 0, 78, 80, 84, 0, 78, 87, 84, 0, 78, 68, 68, 84, 0, 10, 78, 83, 84, 51,
        58, 51, 48, 78, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaSwiftCurrent: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        23, 0, 0, 0, 6, 0, 0, 0, 24, 255, 255, 255, 255, 134, 253, 150, 24, 255, 255, 255, 255,
        158, 184, 175, 144, 255, 255, 255, 255, 159, 187, 7, 128, 255, 255, 255, 255, 203, 137, 12,
        144, 255, 255, 255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 97, 24, 0, 255, 255,
        255, 255, 211, 118, 1, 16, 255, 255, 255, 255, 212, 83, 111, 0, 255, 255, 255, 255, 213,
        85, 227, 16, 255, 255, 255, 255, 214, 32, 220, 0, 255, 255, 255, 255, 215, 53, 197, 16,
        255, 255, 255, 255, 216, 0, 190, 0, 255, 255, 255, 255, 217, 21, 167, 16, 255, 255, 255,
        255, 217, 224, 160, 0, 255, 255, 255, 255, 232, 39, 44, 16, 255, 255, 255, 255, 233, 23,
        15, 0, 255, 255, 255, 255, 235, 230, 240, 16, 255, 255, 255, 255, 236, 214, 211, 0, 255,
        255, 255, 255, 237, 198, 210, 16, 255, 255, 255, 255, 238, 145, 203, 0, 255, 255, 255, 255,
        239, 175, 238, 144, 255, 255, 255, 255, 240, 113, 173, 0, 0, 0, 0, 0, 4, 97, 25, 144, 2, 1,
        2, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 5, 255, 255, 154, 232, 0, 0,
        255, 255, 171, 160, 1, 4, 255, 255, 157, 144, 0, 8, 255, 255, 171, 160, 1, 12, 255, 255,
        171, 160, 1, 16, 255, 255, 171, 160, 0, 20, 76, 77, 84, 0, 77, 68, 84, 0, 77, 83, 84, 0,
        77, 87, 84, 0, 77, 80, 84, 0, 67, 83, 84, 0, 10, 67, 83, 84, 54, 10,
    ];
    pub(crate) const AmericaTegucigalpa: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        7, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 164, 76, 75, 68, 0, 0, 0, 0, 32, 154, 220,
        224, 0, 0, 0, 0, 33, 92, 155, 80, 0, 0, 0, 0, 34, 122, 190, 224, 0, 0, 0, 0, 35, 60, 125,
        80, 0, 0, 0, 0, 68, 93, 140, 224, 0, 0, 0, 0, 68, 214, 200, 208, 2, 1, 2, 1, 2, 1, 2, 255,
        255, 174, 60, 0, 0, 255, 255, 185, 176, 1, 4, 255, 255, 171, 160, 0, 8, 76, 77, 84, 0, 67,
        68, 84, 0, 67, 83, 84, 0, 10, 67, 83, 84, 54, 10,
    ];
    pub(crate) const AmericaThule: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        34, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 155, 128, 119, 252, 0, 0, 0, 0, 39, 245,
        122, 224, 0, 0, 0, 0, 40, 229, 93, 208, 0, 0, 0, 0, 41, 213, 92, 224, 0, 0, 0, 0, 42, 197,
        63, 208, 0, 0, 0, 0, 43, 190, 121, 96, 0, 0, 0, 0, 44, 211, 70, 80, 0, 0, 0, 0, 45, 158,
        91, 96, 0, 0, 0, 0, 46, 179, 40, 80, 0, 0, 0, 0, 47, 126, 61, 96, 0, 0, 0, 0, 48, 147, 10,
        80, 0, 0, 0, 0, 49, 103, 89, 224, 0, 0, 0, 0, 50, 114, 236, 80, 0, 0, 0, 0, 51, 71, 59,
        224, 0, 0, 0, 0, 52, 82, 206, 80, 0, 0, 0, 0, 53, 39, 29, 224, 0, 0, 0, 0, 54, 50, 176, 80,
        0, 0, 0, 0, 55, 6, 255, 224, 0, 0, 0, 0, 56, 27, 204, 208, 0, 0, 0, 0, 56, 230, 225, 224,
        0, 0, 0, 0, 57, 251, 174, 208, 0, 0, 0, 0, 58, 198, 195, 224, 0, 0, 0, 0, 59, 219, 144,
        208, 0, 0, 0, 0, 60, 175, 224, 96, 0, 0, 0, 0, 61, 187, 114, 208, 0, 0, 0, 0, 62, 143, 194,
        96, 0, 0, 0, 0, 63, 155, 84, 208, 0, 0, 0, 0, 64, 111, 164, 96, 0, 0, 0, 0, 65, 132, 113,
        80, 0, 0, 0, 0, 66, 79, 134, 96, 0, 0, 0, 0, 67, 100, 83, 80, 0, 0, 0, 0, 68, 47, 104, 96,
        0, 0, 0, 0, 69, 68, 53, 80, 0, 0, 0, 0, 69, 243, 154, 224, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 255, 255, 191, 132, 0,
        0, 255, 255, 213, 208, 1, 4, 255, 255, 199, 192, 0, 8, 76, 77, 84, 0, 65, 68, 84, 0, 65,
        83, 84, 0, 10, 65, 83, 84, 52, 65, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46,
        49, 46, 48, 10,
    ];
    pub(crate) const AmericaThunderBay: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        78, 0, 0, 0, 6, 0, 0, 0, 24, 255, 255, 255, 255, 114, 238, 130, 44, 255, 255, 255, 255,
        143, 36, 123, 224, 255, 255, 255, 255, 203, 136, 240, 112, 255, 255, 255, 255, 210, 35,
        244, 112, 255, 255, 255, 255, 210, 96, 251, 224, 0, 0, 0, 0, 0, 151, 254, 240, 0, 0, 0, 0,
        1, 135, 225, 224, 0, 0, 0, 0, 2, 119, 224, 240, 0, 0, 0, 0, 3, 112, 254, 96, 0, 0, 0, 0, 4,
        96, 253, 112, 0, 0, 0, 0, 5, 80, 224, 96, 0, 0, 0, 0, 8, 32, 193, 112, 0, 0, 0, 0, 9, 16,
        164, 96, 0, 0, 0, 0, 10, 0, 163, 112, 0, 0, 0, 0, 10, 240, 134, 96, 0, 0, 0, 0, 11, 224,
        133, 112, 0, 0, 0, 0, 12, 217, 162, 224, 0, 0, 0, 0, 13, 192, 103, 112, 0, 0, 0, 0, 14,
        185, 132, 224, 0, 0, 0, 0, 15, 169, 131, 240, 0, 0, 0, 0, 16, 153, 102, 224, 0, 0, 0, 0,
        17, 137, 101, 240, 0, 0, 0, 0, 18, 121, 72, 224, 0, 0, 0, 0, 19, 105, 71, 240, 0, 0, 0, 0,
        20, 89, 42, 224, 0, 0, 0, 0, 21, 73, 41, 240, 0, 0, 0, 0, 22, 57, 12, 224, 0, 0, 0, 0, 23,
        41, 11, 240, 0, 0, 0, 0, 24, 34, 41, 96, 0, 0, 0, 0, 25, 8, 237, 240, 0, 0, 0, 0, 26, 2,
        11, 96, 0, 0, 0, 0, 26, 242, 10, 112, 0, 0, 0, 0, 27, 225, 237, 96, 0, 0, 0, 0, 28, 209,
        236, 112, 0, 0, 0, 0, 29, 193, 207, 96, 0, 0, 0, 0, 30, 177, 206, 112, 0, 0, 0, 0, 31, 161,
        177, 96, 0, 0, 0, 0, 32, 118, 0, 240, 0, 0, 0, 0, 33, 129, 147, 96, 0, 0, 0, 0, 34, 85,
        226, 240, 0, 0, 0, 0, 35, 106, 175, 224, 0, 0, 0, 0, 36, 53, 196, 240, 0, 0, 0, 0, 37, 74,
        145, 224, 0, 0, 0, 0, 38, 21, 166, 240, 0, 0, 0, 0, 39, 42, 115, 224, 0, 0, 0, 0, 39, 254,
        195, 112, 0, 0, 0, 0, 41, 10, 85, 224, 0, 0, 0, 0, 41, 222, 165, 112, 0, 0, 0, 0, 42, 234,
        55, 224, 0, 0, 0, 0, 43, 190, 135, 112, 0, 0, 0, 0, 44, 211, 84, 96, 0, 0, 0, 0, 45, 158,
        105, 112, 0, 0, 0, 0, 46, 179, 54, 96, 0, 0, 0, 0, 47, 126, 75, 112, 0, 0, 0, 0, 48, 147,
        24, 96, 0, 0, 0, 0, 49, 103, 103, 240, 0, 0, 0, 0, 50, 114, 250, 96, 0, 0, 0, 0, 51, 71,
        73, 240, 0, 0, 0, 0, 52, 82, 220, 96, 0, 0, 0, 0, 53, 39, 43, 240, 0, 0, 0, 0, 54, 50, 190,
        96, 0, 0, 0, 0, 55, 7, 13, 240, 0, 0, 0, 0, 56, 27, 218, 224, 0, 0, 0, 0, 56, 230, 239,
        240, 0, 0, 0, 0, 57, 251, 188, 224, 0, 0, 0, 0, 58, 198, 209, 240, 0, 0, 0, 0, 59, 219,
        158, 224, 0, 0, 0, 0, 60, 175, 238, 112, 0, 0, 0, 0, 61, 187, 128, 224, 0, 0, 0, 0, 62,
        143, 208, 112, 0, 0, 0, 0, 63, 155, 98, 224, 0, 0, 0, 0, 64, 111, 178, 112, 0, 0, 0, 0, 65,
        132, 127, 96, 0, 0, 0, 0, 66, 79, 148, 112, 0, 0, 0, 0, 67, 100, 97, 96, 0, 0, 0, 0, 68,
        47, 118, 112, 0, 0, 0, 0, 69, 68, 67, 96, 0, 0, 0, 0, 69, 243, 168, 240, 1, 2, 3, 4, 2, 5,
        2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5,
        2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5,
        2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 255, 255, 172, 84, 0, 0, 255, 255, 171, 160, 0, 4, 255,
        255, 185, 176, 0, 8, 255, 255, 199, 192, 1, 12, 255, 255, 199, 192, 1, 16, 255, 255, 199,
        192, 1, 20, 76, 77, 84, 0, 67, 83, 84, 0, 69, 83, 84, 0, 69, 87, 84, 0, 69, 80, 84, 0, 69,
        68, 84, 0, 10, 69, 83, 84, 53, 69, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46,
        49, 46, 48, 10,
    ];
    pub(crate) const AmericaVancouver: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        129, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 94, 61, 118, 236, 255, 255, 255, 255,
        158, 184, 189, 160, 255, 255, 255, 255, 159, 187, 21, 144, 255, 255, 255, 255, 203, 137,
        26, 160, 255, 255, 255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 97, 38, 16, 255,
        255, 255, 255, 211, 118, 15, 32, 255, 255, 255, 255, 212, 65, 8, 16, 255, 255, 255, 255,
        213, 85, 241, 32, 255, 255, 255, 255, 214, 32, 234, 16, 255, 255, 255, 255, 215, 53, 211,
        32, 255, 255, 255, 255, 216, 0, 204, 16, 255, 255, 255, 255, 217, 21, 181, 32, 255, 255,
        255, 255, 217, 224, 174, 16, 255, 255, 255, 255, 218, 254, 209, 160, 255, 255, 255, 255,
        219, 192, 144, 16, 255, 255, 255, 255, 220, 222, 179, 160, 255, 255, 255, 255, 221, 169,
        172, 144, 255, 255, 255, 255, 222, 190, 149, 160, 255, 255, 255, 255, 223, 137, 142, 144,
        255, 255, 255, 255, 224, 158, 119, 160, 255, 255, 255, 255, 225, 105, 112, 144, 255, 255,
        255, 255, 226, 126, 89, 160, 255, 255, 255, 255, 227, 73, 82, 144, 255, 255, 255, 255, 228,
        94, 59, 160, 255, 255, 255, 255, 229, 41, 52, 144, 255, 255, 255, 255, 230, 71, 88, 32,
        255, 255, 255, 255, 231, 18, 81, 16, 255, 255, 255, 255, 232, 39, 58, 32, 255, 255, 255,
        255, 232, 242, 51, 16, 255, 255, 255, 255, 234, 7, 28, 32, 255, 255, 255, 255, 234, 210,
        21, 16, 255, 255, 255, 255, 235, 230, 254, 32, 255, 255, 255, 255, 236, 177, 247, 16, 255,
        255, 255, 255, 237, 198, 224, 32, 255, 255, 255, 255, 238, 145, 217, 16, 255, 255, 255,
        255, 239, 175, 252, 160, 255, 255, 255, 255, 240, 113, 187, 16, 255, 255, 255, 255, 241,
        143, 222, 160, 255, 255, 255, 255, 242, 127, 193, 144, 255, 255, 255, 255, 243, 111, 192,
        160, 255, 255, 255, 255, 244, 95, 163, 144, 255, 255, 255, 255, 245, 79, 162, 160, 255,
        255, 255, 255, 246, 63, 133, 144, 255, 255, 255, 255, 247, 47, 132, 160, 255, 255, 255,
        255, 248, 40, 162, 16, 255, 255, 255, 255, 249, 15, 102, 160, 255, 255, 255, 255, 250, 8,
        132, 16, 255, 255, 255, 255, 250, 248, 131, 32, 255, 255, 255, 255, 251, 232, 102, 16, 255,
        255, 255, 255, 252, 216, 101, 32, 255, 255, 255, 255, 253, 200, 72, 16, 255, 255, 255, 255,
        254, 184, 71, 32, 255, 255, 255, 255, 255, 168, 42, 16, 0, 0, 0, 0, 0, 152, 41, 32, 0, 0,
        0, 0, 1, 136, 12, 16, 0, 0, 0, 0, 2, 120, 11, 32, 0, 0, 0, 0, 3, 113, 40, 144, 0, 0, 0, 0,
        4, 97, 39, 160, 0, 0, 0, 0, 5, 81, 10, 144, 0, 0, 0, 0, 6, 65, 9, 160, 0, 0, 0, 0, 7, 48,
        236, 144, 0, 0, 0, 0, 8, 32, 235, 160, 0, 0, 0, 0, 9, 16, 206, 144, 0, 0, 0, 0, 10, 0, 205,
        160, 0, 0, 0, 0, 10, 240, 176, 144, 0, 0, 0, 0, 11, 224, 175, 160, 0, 0, 0, 0, 12, 217,
        205, 16, 0, 0, 0, 0, 13, 192, 145, 160, 0, 0, 0, 0, 14, 185, 175, 16, 0, 0, 0, 0, 15, 169,
        174, 32, 0, 0, 0, 0, 16, 153, 145, 16, 0, 0, 0, 0, 17, 137, 144, 32, 0, 0, 0, 0, 18, 121,
        115, 16, 0, 0, 0, 0, 19, 105, 114, 32, 0, 0, 0, 0, 20, 89, 85, 16, 0, 0, 0, 0, 21, 73, 84,
        32, 0, 0, 0, 0, 22, 57, 55, 16, 0, 0, 0, 0, 23, 41, 54, 32, 0, 0, 0, 0, 24, 34, 83, 144, 0,
        0, 0, 0, 25, 9, 24, 32, 0, 0, 0, 0, 26, 2, 53, 144, 0, 0, 0, 0, 26, 242, 52, 160, 0, 0, 0,
        0, 27, 226, 23, 144, 0, 0, 0, 0, 28, 210, 22, 160, 0, 0, 0, 0, 29, 193, 249, 144, 0, 0, 0,
        0, 30, 177, 248, 160, 0, 0, 0, 0, 31, 161, 219, 144, 0, 0, 0, 0, 32, 118, 43, 32, 0, 0, 0,
        0, 33, 129, 189, 144, 0, 0, 0, 0, 34, 86, 13, 32, 0, 0, 0, 0, 35, 106, 218, 16, 0, 0, 0, 0,
        36, 53, 239, 32, 0, 0, 0, 0, 37, 74, 188, 16, 0, 0, 0, 0, 38, 21, 209, 32, 0, 0, 0, 0, 39,
        42, 158, 16, 0, 0, 0, 0, 39, 254, 237, 160, 0, 0, 0, 0, 41, 10, 128, 16, 0, 0, 0, 0, 41,
        222, 207, 160, 0, 0, 0, 0, 42, 234, 98, 16, 0, 0, 0, 0, 43, 190, 177, 160, 0, 0, 0, 0, 44,
        211, 126, 144, 0, 0, 0, 0, 45, 158, 147, 160, 0, 0, 0, 0, 46, 179, 96, 144, 0, 0, 0, 0, 47,
        126, 117, 160, 0, 0, 0, 0, 48, 147, 66, 144, 0, 0, 0, 0, 49, 103, 146, 32, 0, 0, 0, 0, 50,
        115, 36, 144, 0, 0, 0, 0, 51, 71, 116, 32, 0, 0, 0, 0, 52, 83, 6, 144, 0, 0, 0, 0, 53, 39,
        86, 32, 0, 0, 0, 0, 54, 50, 232, 144, 0, 0, 0, 0, 55, 7, 56, 32, 0, 0, 0, 0, 56, 28, 5, 16,
        0, 0, 0, 0, 56, 231, 26, 32, 0, 0, 0, 0, 57, 251, 231, 16, 0, 0, 0, 0, 58, 198, 252, 32, 0,
        0, 0, 0, 59, 219, 201, 16, 0, 0, 0, 0, 60, 176, 24, 160, 0, 0, 0, 0, 61, 187, 171, 16, 0,
        0, 0, 0, 62, 143, 250, 160, 0, 0, 0, 0, 63, 155, 141, 16, 0, 0, 0, 0, 64, 111, 220, 160, 0,
        0, 0, 0, 65, 132, 169, 144, 0, 0, 0, 0, 66, 79, 190, 160, 0, 0, 0, 0, 67, 100, 139, 144, 0,
        0, 0, 0, 68, 47, 160, 160, 0, 0, 0, 0, 69, 68, 109, 144, 0, 0, 0, 0, 69, 243, 211, 32, 2,
        1, 2, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 255, 255, 140, 148, 0, 0, 255, 255, 157, 144, 1, 4, 255, 255, 143,
        128, 0, 8, 255, 255, 157, 144, 1, 12, 255, 255, 157, 144, 1, 16, 76, 77, 84, 0, 80, 68, 84,
        0, 80, 83, 84, 0, 80, 87, 84, 0, 80, 80, 84, 0, 10, 80, 83, 84, 56, 80, 68, 84, 44, 77, 51,
        46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaWhitehorse: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        93, 0, 0, 0, 9, 0, 0, 0, 37, 255, 255, 255, 255, 125, 134, 138, 156, 255, 255, 255, 255,
        158, 184, 203, 176, 255, 255, 255, 255, 159, 187, 35, 160, 255, 255, 255, 255, 160, 208,
        12, 176, 255, 255, 255, 255, 161, 162, 210, 128, 255, 255, 255, 255, 203, 137, 40, 176,
        255, 255, 255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 97, 52, 32, 255, 255, 255,
        255, 247, 47, 118, 144, 255, 255, 255, 255, 248, 40, 162, 16, 255, 255, 255, 255, 251, 29,
        95, 16, 0, 0, 0, 0, 19, 105, 114, 32, 0, 0, 0, 0, 20, 89, 85, 16, 0, 0, 0, 0, 21, 73, 84,
        32, 0, 0, 0, 0, 22, 57, 55, 16, 0, 0, 0, 0, 23, 41, 54, 32, 0, 0, 0, 0, 24, 34, 83, 144, 0,
        0, 0, 0, 25, 9, 24, 32, 0, 0, 0, 0, 26, 2, 53, 144, 0, 0, 0, 0, 26, 242, 52, 160, 0, 0, 0,
        0, 27, 226, 23, 144, 0, 0, 0, 0, 28, 210, 22, 160, 0, 0, 0, 0, 29, 193, 249, 144, 0, 0, 0,
        0, 30, 177, 248, 160, 0, 0, 0, 0, 31, 161, 219, 144, 0, 0, 0, 0, 32, 118, 43, 32, 0, 0, 0,
        0, 33, 129, 189, 144, 0, 0, 0, 0, 34, 86, 13, 32, 0, 0, 0, 0, 35, 106, 218, 16, 0, 0, 0, 0,
        36, 53, 239, 32, 0, 0, 0, 0, 37, 74, 188, 16, 0, 0, 0, 0, 38, 21, 209, 32, 0, 0, 0, 0, 39,
        42, 158, 16, 0, 0, 0, 0, 39, 254, 237, 160, 0, 0, 0, 0, 41, 10, 128, 16, 0, 0, 0, 0, 41,
        222, 207, 160, 0, 0, 0, 0, 42, 234, 98, 16, 0, 0, 0, 0, 43, 190, 177, 160, 0, 0, 0, 0, 44,
        211, 126, 144, 0, 0, 0, 0, 45, 158, 147, 160, 0, 0, 0, 0, 46, 179, 96, 144, 0, 0, 0, 0, 47,
        126, 117, 160, 0, 0, 0, 0, 48, 147, 66, 144, 0, 0, 0, 0, 49, 103, 146, 32, 0, 0, 0, 0, 50,
        115, 36, 144, 0, 0, 0, 0, 51, 71, 116, 32, 0, 0, 0, 0, 52, 83, 6, 144, 0, 0, 0, 0, 53, 39,
        86, 32, 0, 0, 0, 0, 54, 50, 232, 144, 0, 0, 0, 0, 55, 7, 56, 32, 0, 0, 0, 0, 56, 28, 5, 16,
        0, 0, 0, 0, 56, 231, 26, 32, 0, 0, 0, 0, 57, 251, 231, 16, 0, 0, 0, 0, 58, 198, 252, 32, 0,
        0, 0, 0, 59, 219, 201, 16, 0, 0, 0, 0, 60, 176, 24, 160, 0, 0, 0, 0, 61, 187, 171, 16, 0,
        0, 0, 0, 62, 143, 250, 160, 0, 0, 0, 0, 63, 155, 141, 16, 0, 0, 0, 0, 64, 111, 220, 160, 0,
        0, 0, 0, 65, 132, 169, 144, 0, 0, 0, 0, 66, 79, 190, 160, 0, 0, 0, 0, 67, 100, 139, 144, 0,
        0, 0, 0, 68, 47, 160, 160, 0, 0, 0, 0, 69, 68, 109, 144, 0, 0, 0, 0, 69, 243, 211, 32, 0,
        0, 0, 0, 71, 45, 138, 16, 0, 0, 0, 0, 71, 211, 181, 32, 0, 0, 0, 0, 73, 13, 108, 16, 0, 0,
        0, 0, 73, 179, 151, 32, 0, 0, 0, 0, 74, 237, 78, 16, 0, 0, 0, 0, 75, 156, 179, 160, 0, 0,
        0, 0, 76, 214, 106, 144, 0, 0, 0, 0, 77, 124, 149, 160, 0, 0, 0, 0, 78, 182, 76, 144, 0, 0,
        0, 0, 79, 92, 119, 160, 0, 0, 0, 0, 80, 150, 46, 144, 0, 0, 0, 0, 81, 60, 89, 160, 0, 0, 0,
        0, 82, 118, 16, 144, 0, 0, 0, 0, 83, 28, 59, 160, 0, 0, 0, 0, 84, 85, 242, 144, 0, 0, 0, 0,
        84, 252, 29, 160, 0, 0, 0, 0, 86, 53, 212, 144, 0, 0, 0, 0, 86, 229, 58, 32, 0, 0, 0, 0,
        88, 30, 241, 16, 0, 0, 0, 0, 88, 197, 28, 32, 0, 0, 0, 0, 89, 254, 211, 16, 0, 0, 0, 0, 90,
        164, 254, 32, 0, 0, 0, 0, 91, 222, 181, 16, 0, 0, 0, 0, 92, 132, 224, 32, 0, 0, 0, 0, 93,
        190, 151, 16, 0, 0, 0, 0, 94, 100, 194, 32, 0, 0, 0, 0, 95, 158, 92, 240, 2, 1, 2, 1, 2, 3,
        4, 2, 5, 2, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7,
        6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7,
        6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 8, 255, 255,
        129, 100, 0, 0, 255, 255, 143, 128, 1, 4, 255, 255, 129, 112, 0, 8, 255, 255, 143, 128, 1,
        12, 255, 255, 143, 128, 1, 16, 255, 255, 157, 144, 1, 20, 255, 255, 143, 128, 0, 25, 255,
        255, 157, 144, 1, 29, 255, 255, 157, 144, 0, 33, 76, 77, 84, 0, 89, 68, 84, 0, 89, 83, 84,
        0, 89, 87, 84, 0, 89, 80, 84, 0, 89, 68, 68, 84, 0, 80, 83, 84, 0, 80, 68, 84, 0, 77, 83,
        84, 0, 10, 77, 83, 84, 55, 10,
    ];
    pub(crate) const AmericaWinnipeg: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        125, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 100, 228, 176, 148, 255, 255, 255, 255,
        155, 1, 251, 224, 255, 255, 255, 255, 155, 195, 186, 80, 255, 255, 255, 255, 158, 184, 161,
        128, 255, 255, 255, 255, 159, 186, 249, 112, 255, 255, 255, 255, 194, 160, 59, 128, 255,
        255, 255, 255, 195, 79, 132, 240, 255, 255, 255, 255, 203, 136, 254, 128, 255, 255, 255,
        255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 97, 9, 240, 255, 255, 255, 255, 211, 136,
        104, 0, 255, 255, 255, 255, 212, 83, 96, 240, 255, 255, 255, 255, 213, 85, 213, 0, 255,
        255, 255, 255, 214, 32, 205, 240, 255, 255, 255, 255, 215, 53, 183, 0, 255, 255, 255, 255,
        216, 0, 175, 240, 255, 255, 255, 255, 217, 21, 153, 0, 255, 255, 255, 255, 217, 224, 145,
        240, 255, 255, 255, 255, 219, 0, 7, 0, 255, 255, 255, 255, 219, 200, 92, 240, 255, 255,
        255, 255, 220, 222, 151, 128, 255, 255, 255, 255, 221, 169, 144, 112, 255, 255, 255, 255,
        222, 190, 121, 128, 255, 255, 255, 255, 223, 137, 114, 112, 255, 255, 255, 255, 224, 158,
        91, 128, 255, 255, 255, 255, 225, 105, 84, 112, 255, 255, 255, 255, 226, 126, 61, 128, 255,
        255, 255, 255, 227, 73, 54, 112, 255, 255, 255, 255, 228, 94, 31, 128, 255, 255, 255, 255,
        229, 41, 24, 112, 255, 255, 255, 255, 230, 71, 60, 0, 255, 255, 255, 255, 231, 18, 52, 240,
        255, 255, 255, 255, 232, 39, 30, 0, 255, 255, 255, 255, 232, 242, 22, 240, 255, 255, 255,
        255, 234, 7, 0, 0, 255, 255, 255, 255, 234, 209, 248, 240, 255, 255, 255, 255, 235, 230,
        226, 0, 255, 255, 255, 255, 236, 214, 196, 240, 255, 255, 255, 255, 237, 198, 196, 0, 255,
        255, 255, 255, 238, 145, 188, 240, 255, 255, 255, 255, 243, 111, 164, 128, 255, 255, 255,
        255, 244, 49, 98, 240, 255, 255, 255, 255, 249, 15, 74, 128, 255, 255, 255, 255, 250, 8,
        118, 0, 255, 255, 255, 255, 250, 248, 103, 0, 255, 255, 255, 255, 251, 232, 88, 0, 255,
        255, 255, 255, 252, 216, 73, 0, 255, 255, 255, 255, 253, 200, 58, 0, 255, 255, 255, 255,
        254, 184, 43, 0, 255, 255, 255, 255, 255, 168, 28, 0, 0, 0, 0, 0, 0, 152, 13, 0, 0, 0, 0,
        0, 1, 135, 254, 0, 0, 0, 0, 0, 2, 119, 239, 0, 0, 0, 0, 0, 3, 113, 26, 128, 0, 0, 0, 0, 4,
        97, 11, 128, 0, 0, 0, 0, 5, 80, 252, 128, 0, 0, 0, 0, 6, 64, 237, 128, 0, 0, 0, 0, 7, 48,
        222, 128, 0, 0, 0, 0, 8, 32, 207, 128, 0, 0, 0, 0, 9, 16, 192, 128, 0, 0, 0, 0, 10, 0, 177,
        128, 0, 0, 0, 0, 10, 240, 162, 128, 0, 0, 0, 0, 11, 224, 147, 128, 0, 0, 0, 0, 12, 217,
        191, 0, 0, 0, 0, 0, 13, 192, 117, 128, 0, 0, 0, 0, 14, 185, 161, 0, 0, 0, 0, 0, 15, 169,
        146, 0, 0, 0, 0, 0, 16, 153, 131, 0, 0, 0, 0, 0, 17, 137, 116, 0, 0, 0, 0, 0, 18, 121, 101,
        0, 0, 0, 0, 0, 19, 105, 86, 0, 0, 0, 0, 0, 20, 89, 71, 0, 0, 0, 0, 0, 21, 73, 56, 0, 0, 0,
        0, 0, 22, 57, 41, 0, 0, 0, 0, 0, 23, 41, 26, 0, 0, 0, 0, 0, 24, 34, 69, 128, 0, 0, 0, 0,
        25, 8, 252, 0, 0, 0, 0, 0, 26, 2, 39, 128, 0, 0, 0, 0, 26, 242, 24, 128, 0, 0, 0, 0, 27,
        226, 9, 128, 0, 0, 0, 0, 28, 209, 250, 128, 0, 0, 0, 0, 29, 193, 235, 128, 0, 0, 0, 0, 30,
        177, 220, 128, 0, 0, 0, 0, 31, 161, 205, 128, 0, 0, 0, 0, 32, 118, 15, 0, 0, 0, 0, 0, 33,
        129, 175, 128, 0, 0, 0, 0, 34, 85, 241, 0, 0, 0, 0, 0, 35, 106, 204, 0, 0, 0, 0, 0, 36, 53,
        211, 0, 0, 0, 0, 0, 37, 74, 174, 0, 0, 0, 0, 0, 38, 21, 181, 0, 0, 0, 0, 0, 39, 42, 144, 0,
        0, 0, 0, 0, 39, 254, 209, 128, 0, 0, 0, 0, 41, 10, 114, 0, 0, 0, 0, 0, 41, 222, 179, 128,
        0, 0, 0, 0, 42, 234, 84, 0, 0, 0, 0, 0, 43, 190, 149, 128, 0, 0, 0, 0, 44, 211, 112, 128,
        0, 0, 0, 0, 45, 158, 119, 128, 0, 0, 0, 0, 46, 179, 82, 128, 0, 0, 0, 0, 47, 126, 89, 128,
        0, 0, 0, 0, 48, 147, 52, 128, 0, 0, 0, 0, 49, 103, 118, 0, 0, 0, 0, 0, 50, 115, 22, 128, 0,
        0, 0, 0, 51, 71, 88, 0, 0, 0, 0, 0, 52, 82, 248, 128, 0, 0, 0, 0, 53, 39, 58, 0, 0, 0, 0,
        0, 54, 50, 218, 128, 0, 0, 0, 0, 55, 7, 28, 0, 0, 0, 0, 0, 56, 27, 247, 0, 0, 0, 0, 0, 56,
        230, 254, 0, 0, 0, 0, 0, 57, 251, 217, 0, 0, 0, 0, 0, 58, 198, 224, 0, 0, 0, 0, 0, 59, 219,
        187, 0, 0, 0, 0, 0, 60, 175, 252, 128, 0, 0, 0, 0, 61, 187, 157, 0, 0, 0, 0, 0, 62, 143,
        222, 128, 0, 0, 0, 0, 63, 155, 127, 0, 0, 0, 0, 0, 64, 111, 192, 128, 0, 0, 0, 0, 65, 132,
        155, 128, 0, 0, 0, 0, 66, 79, 162, 128, 0, 0, 0, 0, 67, 100, 125, 128, 0, 0, 0, 0, 68, 47,
        132, 128, 0, 0, 0, 0, 69, 68, 81, 112, 0, 0, 0, 0, 69, 243, 183, 0, 2, 1, 2, 1, 2, 1, 2, 3,
        4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 255, 255,
        164, 236, 0, 0, 255, 255, 185, 176, 1, 4, 255, 255, 171, 160, 0, 8, 255, 255, 185, 176, 1,
        12, 255, 255, 185, 176, 1, 16, 76, 77, 84, 0, 67, 68, 84, 0, 67, 83, 84, 0, 67, 87, 84, 0,
        67, 80, 84, 0, 10, 67, 83, 84, 54, 67, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49,
        46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaYakutat: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        83, 0, 0, 0, 8, 0, 0, 0, 30, 255, 255, 255, 255, 63, 194, 253, 209, 255, 255, 255, 255,
        125, 135, 55, 191, 255, 255, 255, 255, 203, 137, 40, 176, 255, 255, 255, 255, 210, 35, 244,
        112, 255, 255, 255, 255, 210, 97, 52, 32, 255, 255, 255, 255, 254, 184, 85, 48, 255, 255,
        255, 255, 255, 168, 56, 32, 0, 0, 0, 0, 0, 152, 55, 48, 0, 0, 0, 0, 1, 136, 26, 32, 0, 0,
        0, 0, 2, 120, 25, 48, 0, 0, 0, 0, 3, 113, 54, 160, 0, 0, 0, 0, 4, 97, 53, 176, 0, 0, 0, 0,
        5, 81, 24, 160, 0, 0, 0, 0, 6, 65, 23, 176, 0, 0, 0, 0, 7, 48, 250, 160, 0, 0, 0, 0, 7,
        141, 81, 176, 0, 0, 0, 0, 9, 16, 220, 160, 0, 0, 0, 0, 9, 173, 205, 48, 0, 0, 0, 0, 10,
        240, 190, 160, 0, 0, 0, 0, 11, 224, 189, 176, 0, 0, 0, 0, 12, 217, 219, 32, 0, 0, 0, 0, 13,
        192, 159, 176, 0, 0, 0, 0, 14, 185, 189, 32, 0, 0, 0, 0, 15, 169, 188, 48, 0, 0, 0, 0, 16,
        153, 159, 32, 0, 0, 0, 0, 17, 137, 158, 48, 0, 0, 0, 0, 18, 121, 129, 32, 0, 0, 0, 0, 19,
        105, 128, 48, 0, 0, 0, 0, 20, 89, 99, 32, 0, 0, 0, 0, 21, 73, 98, 48, 0, 0, 0, 0, 22, 57,
        69, 32, 0, 0, 0, 0, 23, 41, 68, 48, 0, 0, 0, 0, 24, 34, 97, 160, 0, 0, 0, 0, 25, 9, 38, 48,
        0, 0, 0, 0, 26, 2, 67, 160, 0, 0, 0, 0, 26, 43, 20, 16, 0, 0, 0, 0, 26, 242, 66, 176, 0, 0,
        0, 0, 27, 226, 37, 160, 0, 0, 0, 0, 28, 210, 36, 176, 0, 0, 0, 0, 29, 194, 7, 160, 0, 0, 0,
        0, 30, 178, 6, 176, 0, 0, 0, 0, 31, 161, 233, 160, 0, 0, 0, 0, 32, 118, 57, 48, 0, 0, 0, 0,
        33, 129, 203, 160, 0, 0, 0, 0, 34, 86, 27, 48, 0, 0, 0, 0, 35, 106, 232, 32, 0, 0, 0, 0,
        36, 53, 253, 48, 0, 0, 0, 0, 37, 74, 202, 32, 0, 0, 0, 0, 38, 21, 223, 48, 0, 0, 0, 0, 39,
        42, 172, 32, 0, 0, 0, 0, 39, 254, 251, 176, 0, 0, 0, 0, 41, 10, 142, 32, 0, 0, 0, 0, 41,
        222, 221, 176, 0, 0, 0, 0, 42, 234, 112, 32, 0, 0, 0, 0, 43, 190, 191, 176, 0, 0, 0, 0, 44,
        211, 140, 160, 0, 0, 0, 0, 45, 158, 161, 176, 0, 0, 0, 0, 46, 179, 110, 160, 0, 0, 0, 0,
        47, 126, 131, 176, 0, 0, 0, 0, 48, 147, 80, 160, 0, 0, 0, 0, 49, 103, 160, 48, 0, 0, 0, 0,
        50, 115, 50, 160, 0, 0, 0, 0, 51, 71, 130, 48, 0, 0, 0, 0, 52, 83, 20, 160, 0, 0, 0, 0, 53,
        39, 100, 48, 0, 0, 0, 0, 54, 50, 246, 160, 0, 0, 0, 0, 55, 7, 70, 48, 0, 0, 0, 0, 56, 28,
        19, 32, 0, 0, 0, 0, 56, 231, 40, 48, 0, 0, 0, 0, 57, 251, 245, 32, 0, 0, 0, 0, 58, 199, 10,
        48, 0, 0, 0, 0, 59, 219, 215, 32, 0, 0, 0, 0, 60, 176, 38, 176, 0, 0, 0, 0, 61, 187, 185,
        32, 0, 0, 0, 0, 62, 144, 8, 176, 0, 0, 0, 0, 63, 155, 155, 32, 0, 0, 0, 0, 64, 111, 234,
        176, 0, 0, 0, 0, 65, 132, 183, 160, 0, 0, 0, 0, 66, 79, 204, 176, 0, 0, 0, 0, 67, 100, 153,
        160, 0, 0, 0, 0, 68, 47, 174, 176, 0, 0, 0, 0, 69, 68, 123, 160, 0, 0, 0, 0, 69, 243, 225,
        48, 1, 2, 3, 4, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2,
        5, 2, 5, 2, 5, 2, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6,
        7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 0, 0, 206, 129, 0,
        0, 255, 255, 125, 1, 0, 0, 255, 255, 129, 112, 0, 4, 255, 255, 143, 128, 1, 8, 255, 255,
        143, 128, 1, 12, 255, 255, 143, 128, 1, 16, 255, 255, 143, 128, 1, 20, 255, 255, 129, 112,
        0, 25, 76, 77, 84, 0, 89, 83, 84, 0, 89, 87, 84, 0, 89, 80, 84, 0, 89, 68, 84, 0, 65, 75,
        68, 84, 0, 65, 75, 83, 84, 0, 10, 65, 75, 83, 84, 57, 65, 75, 68, 84, 44, 77, 51, 46, 50,
        46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AmericaYellowknife: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        61, 0, 0, 0, 6, 0, 0, 0, 25, 255, 255, 255, 255, 190, 42, 24, 0, 255, 255, 255, 255, 203,
        137, 12, 144, 255, 255, 255, 255, 210, 35, 244, 112, 255, 255, 255, 255, 210, 97, 24, 0,
        255, 255, 255, 255, 247, 47, 90, 112, 255, 255, 255, 255, 248, 40, 133, 240, 0, 0, 0, 0,
        19, 105, 100, 16, 0, 0, 0, 0, 20, 89, 71, 0, 0, 0, 0, 0, 21, 73, 70, 16, 0, 0, 0, 0, 22,
        57, 41, 0, 0, 0, 0, 0, 23, 41, 40, 16, 0, 0, 0, 0, 24, 34, 69, 128, 0, 0, 0, 0, 25, 9, 10,
        16, 0, 0, 0, 0, 26, 2, 39, 128, 0, 0, 0, 0, 26, 242, 38, 144, 0, 0, 0, 0, 27, 226, 9, 128,
        0, 0, 0, 0, 28, 210, 8, 144, 0, 0, 0, 0, 29, 193, 235, 128, 0, 0, 0, 0, 30, 177, 234, 144,
        0, 0, 0, 0, 31, 161, 205, 128, 0, 0, 0, 0, 32, 118, 29, 16, 0, 0, 0, 0, 33, 129, 175, 128,
        0, 0, 0, 0, 34, 85, 255, 16, 0, 0, 0, 0, 35, 106, 204, 0, 0, 0, 0, 0, 36, 53, 225, 16, 0,
        0, 0, 0, 37, 74, 174, 0, 0, 0, 0, 0, 38, 21, 195, 16, 0, 0, 0, 0, 39, 42, 144, 0, 0, 0, 0,
        0, 39, 254, 223, 144, 0, 0, 0, 0, 41, 10, 114, 0, 0, 0, 0, 0, 41, 222, 193, 144, 0, 0, 0,
        0, 42, 234, 84, 0, 0, 0, 0, 0, 43, 190, 163, 144, 0, 0, 0, 0, 44, 211, 112, 128, 0, 0, 0,
        0, 45, 158, 133, 144, 0, 0, 0, 0, 46, 179, 82, 128, 0, 0, 0, 0, 47, 126, 103, 144, 0, 0, 0,
        0, 48, 147, 52, 128, 0, 0, 0, 0, 49, 103, 132, 16, 0, 0, 0, 0, 50, 115, 22, 128, 0, 0, 0,
        0, 51, 71, 102, 16, 0, 0, 0, 0, 52, 82, 248, 128, 0, 0, 0, 0, 53, 39, 72, 16, 0, 0, 0, 0,
        54, 50, 218, 128, 0, 0, 0, 0, 55, 7, 42, 16, 0, 0, 0, 0, 56, 27, 247, 0, 0, 0, 0, 0, 56,
        231, 12, 16, 0, 0, 0, 0, 57, 251, 217, 0, 0, 0, 0, 0, 58, 198, 238, 16, 0, 0, 0, 0, 59,
        219, 187, 0, 0, 0, 0, 0, 60, 176, 10, 144, 0, 0, 0, 0, 61, 187, 157, 0, 0, 0, 0, 0, 62,
        143, 236, 144, 0, 0, 0, 0, 63, 155, 127, 0, 0, 0, 0, 0, 64, 111, 206, 144, 0, 0, 0, 0, 65,
        132, 155, 128, 0, 0, 0, 0, 66, 79, 176, 144, 0, 0, 0, 0, 67, 100, 125, 128, 0, 0, 0, 0, 68,
        47, 146, 144, 0, 0, 0, 0, 69, 68, 95, 128, 0, 0, 0, 0, 69, 243, 197, 16, 3, 1, 2, 3, 4, 3,
        5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3,
        5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 3, 5, 0, 0, 0, 0, 0,
        0, 255, 255, 171, 160, 1, 4, 255, 255, 171, 160, 1, 8, 255, 255, 157, 144, 0, 12, 255, 255,
        185, 176, 1, 16, 255, 255, 171, 160, 1, 21, 45, 48, 48, 0, 77, 87, 84, 0, 77, 80, 84, 0,
        77, 83, 84, 0, 77, 68, 68, 84, 0, 77, 68, 84, 0, 10, 77, 83, 84, 55, 77, 68, 84, 44, 77,
        51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AntarcticaCasey: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        12, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 254, 30, 204, 128, 0, 0, 0, 0, 74, 218, 6,
        32, 0, 0, 0, 0, 75, 143, 202, 240, 0, 0, 0, 0, 78, 169, 156, 32, 0, 0, 0, 0, 79, 67, 205,
        144, 0, 0, 0, 0, 88, 10, 59, 128, 0, 0, 0, 0, 90, 164, 15, 16, 0, 0, 0, 0, 91, 185, 20, 64,
        0, 0, 0, 0, 92, 141, 29, 128, 0, 0, 0, 0, 93, 150, 69, 48, 0, 0, 0, 0, 94, 99, 197, 0, 0,
        0, 0, 0, 95, 120, 160, 60, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 112,
        128, 0, 4, 0, 0, 154, 176, 0, 8, 45, 48, 48, 0, 43, 48, 56, 0, 43, 49, 49, 0, 10, 60, 43,
        49, 49, 62, 45, 49, 49, 10,
    ];
    pub(crate) const AntarcticaDavis: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        7, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 231, 156, 64, 0, 255, 255, 255, 255, 246,
        71, 223, 16, 255, 255, 255, 255, 254, 71, 171, 0, 0, 0, 0, 0, 74, 218, 20, 48, 0, 0, 0, 0,
        75, 151, 250, 64, 0, 0, 0, 0, 78, 169, 170, 48, 0, 0, 0, 0, 79, 67, 247, 192, 1, 0, 1, 2,
        1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 98, 112, 0, 4, 0, 0, 70, 80, 0, 8, 45, 48, 48, 0, 43, 48,
        55, 0, 43, 48, 53, 0, 10, 60, 43, 48, 55, 62, 45, 55, 10,
    ];
    pub(crate) const AntarcticaDumontDUrville: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        2, 0, 0, 0, 3, 0, 0, 0, 13, 255, 255, 255, 255, 86, 182, 90, 8, 255, 255, 255, 255, 114,
        237, 164, 144, 1, 2, 0, 0, 137, 248, 0, 0, 0, 0, 137, 240, 0, 4, 0, 0, 140, 160, 0, 9, 76,
        77, 84, 0, 80, 77, 77, 84, 0, 43, 49, 48, 0, 10, 60, 43, 49, 48, 62, 45, 49, 48, 10,
    ];
    pub(crate) const AntarcticaMacquarie: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        91, 0, 0, 0, 3, 0, 0, 0, 14, 255, 255, 255, 255, 124, 5, 22, 0, 255, 255, 255, 255, 155,
        213, 120, 128, 255, 255, 255, 255, 156, 188, 47, 0, 255, 255, 255, 255, 160, 135, 180, 96,
        255, 255, 255, 255, 215, 12, 104, 0, 255, 255, 255, 255, 251, 194, 141, 0, 255, 255, 255,
        255, 252, 178, 126, 0, 255, 255, 255, 255, 253, 199, 89, 0, 255, 255, 255, 255, 254, 118,
        176, 128, 255, 255, 255, 255, 255, 167, 59, 0, 0, 0, 0, 0, 0, 86, 146, 128, 0, 0, 0, 0, 1,
        135, 29, 0, 0, 0, 0, 0, 2, 63, 175, 0, 0, 0, 0, 0, 3, 112, 57, 128, 0, 0, 0, 0, 4, 13, 28,
        0, 0, 0, 0, 0, 5, 80, 27, 128, 0, 0, 0, 0, 5, 246, 56, 128, 0, 0, 0, 0, 7, 47, 253, 128, 0,
        0, 0, 0, 7, 214, 26, 128, 0, 0, 0, 0, 9, 15, 223, 128, 0, 0, 0, 0, 9, 181, 252, 128, 0, 0,
        0, 0, 10, 239, 193, 128, 0, 0, 0, 0, 11, 159, 25, 0, 0, 0, 0, 0, 12, 216, 222, 0, 0, 0, 0,
        0, 13, 126, 251, 0, 0, 0, 0, 0, 14, 184, 192, 0, 0, 0, 0, 0, 15, 94, 221, 0, 0, 0, 0, 0,
        16, 152, 162, 0, 0, 0, 0, 0, 17, 62, 191, 0, 0, 0, 0, 0, 18, 120, 132, 0, 0, 0, 0, 0, 19,
        30, 161, 0, 0, 0, 0, 0, 20, 88, 102, 0, 0, 0, 0, 0, 20, 254, 131, 0, 0, 0, 0, 0, 22, 56,
        72, 0, 0, 0, 0, 0, 23, 3, 79, 0, 0, 0, 0, 0, 24, 33, 100, 128, 0, 0, 0, 0, 24, 227, 49, 0,
        0, 0, 0, 0, 26, 1, 70, 128, 0, 0, 0, 0, 26, 167, 99, 128, 0, 0, 0, 0, 27, 225, 40, 128, 0,
        0, 0, 0, 28, 135, 69, 128, 0, 0, 0, 0, 29, 193, 10, 128, 0, 0, 0, 0, 30, 103, 39, 128, 0,
        0, 0, 0, 31, 151, 178, 0, 0, 0, 0, 0, 32, 89, 126, 128, 0, 0, 0, 0, 33, 128, 206, 128, 0,
        0, 0, 0, 34, 66, 155, 0, 0, 0, 0, 0, 35, 105, 235, 0, 0, 0, 0, 0, 36, 34, 125, 0, 0, 0, 0,
        0, 37, 73, 205, 0, 0, 0, 0, 0, 38, 2, 95, 0, 0, 0, 0, 0, 39, 41, 175, 0, 0, 0, 0, 0, 39,
        244, 182, 0, 0, 0, 0, 0, 40, 237, 225, 128, 0, 0, 0, 0, 41, 212, 152, 0, 0, 0, 0, 0, 42,
        205, 195, 128, 0, 0, 0, 0, 43, 180, 122, 0, 0, 0, 0, 0, 44, 173, 165, 128, 0, 0, 0, 0, 45,
        148, 92, 0, 0, 0, 0, 0, 46, 141, 135, 128, 0, 0, 0, 0, 47, 116, 62, 0, 0, 0, 0, 0, 48, 109,
        105, 128, 0, 0, 0, 0, 49, 93, 90, 128, 0, 0, 0, 0, 50, 86, 134, 0, 0, 0, 0, 0, 51, 61, 60,
        128, 0, 0, 0, 0, 52, 54, 104, 0, 0, 0, 0, 0, 53, 29, 30, 128, 0, 0, 0, 0, 54, 22, 74, 0, 0,
        0, 0, 0, 54, 253, 0, 128, 0, 0, 0, 0, 55, 246, 44, 0, 0, 0, 0, 0, 56, 220, 226, 128, 0, 0,
        0, 0, 57, 167, 233, 128, 0, 0, 0, 0, 58, 188, 196, 128, 0, 0, 0, 0, 59, 191, 42, 128, 0, 0,
        0, 0, 60, 165, 225, 0, 0, 0, 0, 0, 61, 159, 12, 128, 0, 0, 0, 0, 62, 133, 195, 0, 0, 0, 0,
        0, 63, 126, 238, 128, 0, 0, 0, 0, 64, 101, 165, 0, 0, 0, 0, 0, 65, 94, 208, 128, 0, 0, 0,
        0, 66, 69, 135, 0, 0, 0, 0, 0, 67, 62, 178, 128, 0, 0, 0, 0, 68, 46, 163, 128, 0, 0, 0, 0,
        69, 30, 148, 128, 0, 0, 0, 0, 70, 5, 75, 0, 0, 0, 0, 0, 71, 7, 177, 0, 0, 0, 0, 0, 71, 247,
        162, 0, 0, 0, 0, 0, 72, 231, 147, 0, 0, 0, 0, 0, 73, 215, 132, 0, 0, 0, 0, 0, 74, 199, 117,
        0, 0, 0, 0, 0, 77, 151, 72, 0, 1, 2, 1, 0, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 140, 160, 0, 4, 0, 0, 154, 176, 1,
        9, 45, 48, 48, 0, 65, 69, 83, 84, 0, 65, 69, 68, 84, 0, 10, 65, 69, 83, 84, 45, 49, 48, 65,
        69, 68, 84, 44, 77, 49, 48, 46, 49, 46, 48, 44, 77, 52, 46, 49, 46, 48, 47, 51, 10,
    ];
    pub(crate) const AntarcticaMawson: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        2, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 226, 32, 50, 128, 0, 0, 0, 0, 74, 218, 34,
        64, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 84, 96, 0, 4, 0, 0, 70, 80, 0, 8, 45, 48, 48, 0, 43, 48,
        54, 0, 43, 48, 53, 0, 10, 60, 43, 48, 53, 62, 45, 53, 10,
    ];
    pub(crate) const AntarcticaMcMurdo: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        96, 0, 0, 0, 6, 0, 0, 0, 19, 255, 255, 255, 255, 65, 183, 76, 168, 255, 255, 255, 255, 176,
        180, 178, 232, 255, 255, 255, 255, 177, 81, 135, 88, 255, 255, 255, 255, 178, 120, 229,
        104, 255, 255, 255, 255, 179, 67, 229, 96, 255, 255, 255, 255, 180, 88, 199, 104, 255, 255,
        255, 255, 181, 35, 199, 96, 255, 255, 255, 255, 182, 56, 169, 104, 255, 255, 255, 255, 183,
        3, 169, 96, 255, 255, 255, 255, 184, 24, 139, 104, 255, 255, 255, 255, 184, 236, 197, 224,
        255, 255, 255, 255, 185, 248, 109, 104, 255, 255, 255, 255, 186, 204, 167, 224, 255, 255,
        255, 255, 187, 216, 79, 104, 255, 255, 255, 255, 188, 227, 232, 224, 255, 255, 255, 255,
        189, 174, 246, 232, 255, 255, 255, 255, 190, 195, 202, 224, 255, 255, 255, 255, 191, 142,
        216, 232, 255, 255, 255, 255, 192, 163, 172, 224, 255, 255, 255, 255, 193, 110, 186, 232,
        255, 255, 255, 255, 194, 131, 142, 224, 255, 255, 255, 255, 195, 78, 156, 232, 255, 255,
        255, 255, 196, 99, 112, 224, 255, 255, 255, 255, 197, 46, 126, 232, 255, 255, 255, 255,
        198, 76, 141, 96, 255, 255, 255, 255, 199, 14, 96, 232, 255, 255, 255, 255, 200, 44, 111,
        96, 255, 255, 255, 255, 200, 247, 125, 104, 255, 255, 255, 255, 210, 218, 154, 64, 0, 0, 0,
        0, 9, 24, 253, 224, 0, 0, 0, 0, 9, 172, 165, 224, 0, 0, 0, 0, 10, 239, 165, 96, 0, 0, 0, 0,
        11, 158, 252, 224, 0, 0, 0, 0, 12, 216, 193, 224, 0, 0, 0, 0, 13, 126, 222, 224, 0, 0, 0,
        0, 14, 184, 163, 224, 0, 0, 0, 0, 15, 94, 192, 224, 0, 0, 0, 0, 16, 152, 133, 224, 0, 0, 0,
        0, 17, 62, 162, 224, 0, 0, 0, 0, 18, 120, 103, 224, 0, 0, 0, 0, 19, 30, 132, 224, 0, 0, 0,
        0, 20, 88, 73, 224, 0, 0, 0, 0, 20, 254, 102, 224, 0, 0, 0, 0, 22, 56, 43, 224, 0, 0, 0, 0,
        22, 231, 131, 96, 0, 0, 0, 0, 24, 33, 72, 96, 0, 0, 0, 0, 24, 199, 101, 96, 0, 0, 0, 0, 26,
        1, 42, 96, 0, 0, 0, 0, 26, 167, 71, 96, 0, 0, 0, 0, 27, 225, 12, 96, 0, 0, 0, 0, 28, 135,
        41, 96, 0, 0, 0, 0, 29, 192, 238, 96, 0, 0, 0, 0, 30, 103, 11, 96, 0, 0, 0, 0, 31, 160,
        208, 96, 0, 0, 0, 0, 32, 70, 237, 96, 0, 0, 0, 0, 33, 128, 178, 96, 0, 0, 0, 0, 34, 48, 9,
        224, 0, 0, 0, 0, 35, 105, 206, 224, 0, 0, 0, 0, 36, 15, 235, 224, 0, 0, 0, 0, 37, 46, 1,
        96, 0, 0, 0, 0, 38, 2, 66, 224, 0, 0, 0, 0, 39, 13, 227, 96, 0, 0, 0, 0, 39, 226, 36, 224,
        0, 0, 0, 0, 40, 237, 197, 96, 0, 0, 0, 0, 41, 194, 6, 224, 0, 0, 0, 0, 42, 205, 167, 96, 0,
        0, 0, 0, 43, 171, 35, 96, 0, 0, 0, 0, 44, 173, 137, 96, 0, 0, 0, 0, 45, 139, 5, 96, 0, 0,
        0, 0, 46, 141, 107, 96, 0, 0, 0, 0, 47, 106, 231, 96, 0, 0, 0, 0, 48, 109, 77, 96, 0, 0, 0,
        0, 49, 74, 201, 96, 0, 0, 0, 0, 50, 86, 105, 224, 0, 0, 0, 0, 51, 42, 171, 96, 0, 0, 0, 0,
        52, 54, 75, 224, 0, 0, 0, 0, 53, 10, 141, 96, 0, 0, 0, 0, 54, 22, 45, 224, 0, 0, 0, 0, 54,
        243, 169, 224, 0, 0, 0, 0, 55, 246, 15, 224, 0, 0, 0, 0, 56, 211, 139, 224, 0, 0, 0, 0, 57,
        213, 241, 224, 0, 0, 0, 0, 58, 179, 109, 224, 0, 0, 0, 0, 59, 191, 14, 96, 0, 0, 0, 0, 60,
        147, 79, 224, 0, 0, 0, 0, 61, 158, 240, 96, 0, 0, 0, 0, 62, 115, 49, 224, 0, 0, 0, 0, 63,
        126, 210, 96, 0, 0, 0, 0, 64, 92, 78, 96, 0, 0, 0, 0, 65, 94, 180, 96, 0, 0, 0, 0, 66, 60,
        48, 96, 0, 0, 0, 0, 67, 62, 150, 96, 0, 0, 0, 0, 68, 28, 18, 96, 0, 0, 0, 0, 69, 30, 120,
        96, 0, 0, 0, 0, 69, 251, 244, 96, 0, 0, 0, 0, 70, 254, 90, 96, 2, 1, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5,
        4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5,
        4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 0, 0, 163,
        216, 0, 0, 0, 0, 175, 200, 1, 4, 0, 0, 161, 184, 0, 9, 0, 0, 168, 192, 1, 4, 0, 0, 182,
        208, 1, 14, 0, 0, 168, 192, 0, 4, 76, 77, 84, 0, 78, 90, 83, 84, 0, 78, 90, 77, 84, 0, 78,
        90, 68, 84, 0, 10, 78, 90, 83, 84, 45, 49, 50, 78, 90, 68, 84, 44, 77, 57, 46, 53, 46, 48,
        44, 77, 52, 46, 49, 46, 48, 47, 51, 10,
    ];
    pub(crate) const AntarcticaPalmer: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        82, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 246, 152, 173, 0, 255, 255, 255, 255, 246,
        230, 159, 176, 255, 255, 255, 255, 248, 19, 67, 192, 255, 255, 255, 255, 248, 199, 211, 48,
        255, 255, 255, 255, 249, 244, 119, 64, 255, 255, 255, 255, 250, 211, 54, 176, 255, 255,
        255, 255, 251, 195, 53, 192, 255, 255, 255, 255, 252, 188, 83, 48, 255, 255, 255, 255, 253,
        172, 82, 64, 255, 255, 255, 255, 254, 156, 53, 48, 255, 255, 255, 255, 255, 140, 52, 64, 0,
        0, 0, 0, 7, 163, 74, 176, 0, 0, 0, 0, 8, 36, 111, 160, 0, 0, 0, 0, 23, 48, 188, 176, 0, 0,
        0, 0, 24, 6, 93, 192, 0, 0, 0, 0, 24, 209, 86, 176, 0, 0, 0, 0, 25, 230, 63, 192, 0, 0, 0,
        0, 26, 177, 56, 176, 0, 0, 0, 0, 27, 207, 92, 64, 0, 0, 0, 0, 28, 145, 26, 176, 0, 0, 0, 0,
        29, 175, 62, 64, 0, 0, 0, 0, 30, 112, 252, 176, 0, 0, 0, 0, 31, 143, 32, 64, 0, 0, 0, 0,
        32, 127, 3, 48, 0, 0, 0, 0, 33, 111, 2, 64, 0, 0, 0, 0, 34, 57, 251, 48, 0, 0, 0, 0, 35,
        78, 228, 64, 0, 0, 0, 0, 36, 25, 221, 48, 0, 0, 0, 0, 37, 56, 0, 192, 0, 0, 0, 0, 37, 249,
        191, 48, 0, 0, 0, 0, 38, 242, 248, 192, 0, 0, 0, 0, 39, 217, 161, 48, 0, 0, 0, 0, 40, 247,
        196, 192, 0, 0, 0, 0, 41, 194, 189, 176, 0, 0, 0, 0, 42, 215, 166, 192, 0, 0, 0, 0, 43,
        162, 159, 176, 0, 0, 0, 0, 44, 183, 136, 192, 0, 0, 0, 0, 45, 130, 129, 176, 0, 0, 0, 0,
        46, 151, 106, 192, 0, 0, 0, 0, 47, 98, 99, 176, 0, 0, 0, 0, 48, 128, 135, 64, 0, 0, 0, 0,
        49, 66, 69, 176, 0, 0, 0, 0, 50, 96, 105, 64, 0, 0, 0, 0, 51, 61, 215, 48, 0, 0, 0, 0, 52,
        64, 75, 64, 0, 0, 0, 0, 53, 11, 68, 48, 0, 0, 0, 0, 54, 13, 184, 64, 0, 0, 0, 0, 55, 6,
        213, 176, 0, 0, 0, 0, 56, 0, 15, 64, 0, 0, 0, 0, 56, 203, 8, 48, 0, 0, 0, 0, 57, 233, 43,
        192, 0, 0, 0, 0, 58, 170, 234, 48, 0, 0, 0, 0, 59, 201, 13, 192, 0, 0, 0, 0, 60, 138, 204,
        48, 0, 0, 0, 0, 61, 168, 239, 192, 0, 0, 0, 0, 62, 106, 174, 48, 0, 0, 0, 0, 63, 136, 209,
        192, 0, 0, 0, 0, 64, 83, 202, 176, 0, 0, 0, 0, 65, 104, 179, 192, 0, 0, 0, 0, 66, 51, 172,
        176, 0, 0, 0, 0, 67, 72, 149, 192, 0, 0, 0, 0, 68, 19, 142, 176, 0, 0, 0, 0, 69, 49, 178,
        64, 0, 0, 0, 0, 69, 243, 112, 176, 0, 0, 0, 0, 71, 17, 148, 64, 0, 0, 0, 0, 71, 239, 2, 48,
        0, 0, 0, 0, 72, 241, 118, 64, 0, 0, 0, 0, 73, 188, 111, 48, 0, 0, 0, 0, 74, 209, 88, 64, 0,
        0, 0, 0, 75, 184, 0, 176, 0, 0, 0, 0, 76, 177, 58, 64, 0, 0, 0, 0, 77, 198, 7, 48, 0, 0, 0,
        0, 78, 80, 130, 192, 0, 0, 0, 0, 79, 156, 174, 176, 0, 0, 0, 0, 80, 66, 217, 192, 0, 0, 0,
        0, 81, 124, 144, 176, 0, 0, 0, 0, 82, 43, 246, 64, 0, 0, 0, 0, 83, 92, 114, 176, 0, 0, 0,
        0, 84, 11, 216, 64, 0, 0, 0, 0, 87, 55, 230, 48, 0, 0, 0, 0, 87, 175, 236, 192, 0, 0, 0, 0,
        88, 67, 134, 176, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 4, 3, 4, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 4, 0, 0,
        0, 0, 0, 0, 255, 255, 199, 192, 0, 4, 255, 255, 213, 208, 1, 8, 255, 255, 227, 224, 1, 12,
        255, 255, 213, 208, 0, 8, 45, 48, 48, 0, 45, 48, 52, 0, 45, 48, 51, 0, 45, 48, 50, 0, 10,
        60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AntarcticaRothera: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 0, 0, 0, 2, 0, 0, 0, 8, 0, 0, 0, 0, 13, 2, 45, 0, 1, 0, 0, 0, 0, 0, 0, 255, 255, 213,
        208, 0, 4, 45, 48, 48, 0, 45, 48, 51, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AntarcticaSyowa: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 0, 0, 0, 2, 0, 0, 0, 8, 255, 255, 255, 255, 213, 27, 54, 180, 1, 0, 0, 43, 204, 0, 0, 0,
        0, 42, 48, 0, 4, 76, 77, 84, 0, 43, 48, 51, 0, 10, 60, 43, 48, 51, 62, 45, 51, 10,
    ];
    pub(crate) const AntarcticaTroll: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        2, 0, 0, 0, 3, 0, 0, 0, 12, 0, 0, 0, 0, 66, 13, 71, 0, 0, 0, 0, 0, 66, 70, 5, 144, 2, 1, 0,
        0, 0, 0, 0, 0, 0, 0, 28, 32, 1, 4, 0, 0, 0, 0, 0, 8, 45, 48, 48, 0, 43, 48, 50, 0, 43, 48,
        48, 0, 10, 60, 43, 48, 48, 62, 48, 60, 43, 48, 50, 62, 45, 50, 44, 77, 51, 46, 53, 46, 48,
        47, 49, 44, 77, 49, 48, 46, 53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const AntarcticaVostok: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 0, 0, 0, 2, 0, 0, 0, 8, 255, 255, 255, 255, 233, 88, 137, 128, 1, 0, 0, 0, 0, 0, 0, 0,
        0, 84, 96, 0, 4, 45, 48, 48, 0, 43, 48, 54, 0, 10, 60, 43, 48, 54, 62, 45, 54, 10,
    ];
    pub(crate) const ArcticLongyearbyen: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        58, 0, 0, 0, 3, 0, 0, 0, 13, 255, 255, 255, 255, 114, 238, 36, 108, 255, 255, 255, 255,
        155, 39, 227, 0, 255, 255, 255, 255, 155, 212, 123, 96, 255, 255, 255, 255, 200, 183, 77,
        96, 255, 255, 255, 255, 204, 231, 75, 16, 255, 255, 255, 255, 205, 169, 23, 144, 255, 255,
        255, 255, 206, 162, 67, 16, 255, 255, 255, 255, 207, 146, 52, 16, 255, 255, 255, 255, 208,
        130, 37, 16, 255, 255, 255, 255, 209, 114, 22, 16, 255, 255, 255, 255, 210, 98, 7, 16, 255,
        255, 255, 255, 235, 175, 32, 144, 255, 255, 255, 255, 236, 168, 76, 16, 255, 255, 255, 255,
        237, 152, 61, 16, 255, 255, 255, 255, 238, 136, 46, 16, 255, 255, 255, 255, 239, 120, 31,
        16, 255, 255, 255, 255, 240, 104, 16, 16, 255, 255, 255, 255, 241, 88, 1, 16, 255, 255,
        255, 255, 242, 71, 242, 16, 255, 255, 255, 255, 243, 55, 227, 16, 255, 255, 255, 255, 244,
        39, 212, 16, 255, 255, 255, 255, 245, 23, 197, 16, 255, 255, 255, 255, 246, 16, 240, 144,
        255, 255, 255, 255, 247, 47, 6, 16, 255, 255, 255, 255, 247, 240, 210, 144, 0, 0, 0, 0, 19,
        77, 68, 16, 0, 0, 0, 0, 20, 51, 250, 144, 0, 0, 0, 0, 21, 35, 235, 144, 0, 0, 0, 0, 22, 19,
        220, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23, 243, 190, 144, 0, 0, 0, 0, 24, 227,
        175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27,
        188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30,
        140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33,
        92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54,
        16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0,
        0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0,
        0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0,
        0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144,
        0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0, 0, 10, 20, 0, 0, 0, 0, 28, 32, 1,
        4, 0, 0, 14, 16, 0, 9, 76, 77, 84, 0, 67, 69, 83, 84, 0, 67, 69, 84, 0, 10, 67, 69, 84, 45,
        49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const AsiaAlmaty: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        51, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 170, 25, 123, 220, 255, 255, 255, 255,
        181, 163, 239, 48, 0, 0, 0, 0, 21, 39, 125, 160, 0, 0, 0, 0, 22, 24, 178, 16, 0, 0, 0, 0,
        23, 8, 177, 32, 0, 0, 0, 0, 23, 249, 229, 144, 0, 0, 0, 0, 24, 233, 228, 160, 0, 0, 0, 0,
        25, 219, 25, 16, 0, 0, 0, 0, 26, 204, 105, 160, 0, 0, 0, 0, 27, 188, 118, 192, 0, 0, 0, 0,
        28, 172, 103, 192, 0, 0, 0, 0, 29, 156, 88, 192, 0, 0, 0, 0, 30, 140, 73, 192, 0, 0, 0, 0,
        31, 124, 58, 192, 0, 0, 0, 0, 32, 108, 43, 192, 0, 0, 0, 0, 33, 92, 28, 192, 0, 0, 0, 0,
        34, 76, 13, 192, 0, 0, 0, 0, 35, 59, 254, 192, 0, 0, 0, 0, 36, 43, 239, 192, 0, 0, 0, 0,
        37, 27, 224, 192, 0, 0, 0, 0, 38, 11, 209, 192, 0, 0, 0, 0, 39, 4, 253, 64, 0, 0, 0, 0, 39,
        244, 238, 64, 0, 0, 0, 0, 40, 228, 237, 80, 0, 0, 0, 0, 41, 120, 149, 80, 0, 0, 0, 0, 41,
        212, 208, 64, 0, 0, 0, 0, 42, 196, 193, 64, 0, 0, 0, 0, 43, 180, 178, 64, 0, 0, 0, 0, 44,
        164, 163, 64, 0, 0, 0, 0, 45, 148, 148, 64, 0, 0, 0, 0, 46, 132, 133, 64, 0, 0, 0, 0, 47,
        116, 118, 64, 0, 0, 0, 0, 48, 100, 103, 64, 0, 0, 0, 0, 49, 93, 146, 192, 0, 0, 0, 0, 50,
        114, 109, 192, 0, 0, 0, 0, 51, 61, 116, 192, 0, 0, 0, 0, 52, 82, 79, 192, 0, 0, 0, 0, 53,
        29, 86, 192, 0, 0, 0, 0, 54, 50, 49, 192, 0, 0, 0, 0, 54, 253, 56, 192, 0, 0, 0, 0, 56, 27,
        78, 64, 0, 0, 0, 0, 56, 221, 26, 192, 0, 0, 0, 0, 57, 251, 48, 64, 0, 0, 0, 0, 58, 188,
        252, 192, 0, 0, 0, 0, 59, 219, 18, 64, 0, 0, 0, 0, 60, 166, 25, 64, 0, 0, 0, 0, 61, 186,
        244, 64, 0, 0, 0, 0, 62, 133, 251, 64, 0, 0, 0, 0, 63, 154, 214, 64, 0, 0, 0, 0, 64, 101,
        221, 64, 0, 0, 0, 0, 65, 131, 242, 192, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 4, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 0, 0, 72, 36, 0, 0, 0, 0, 70, 80, 0, 4, 0, 0, 98, 112, 1, 8, 0, 0, 84, 96, 0,
        12, 0, 0, 84, 96, 1, 12, 76, 77, 84, 0, 43, 48, 53, 0, 43, 48, 55, 0, 43, 48, 54, 0, 10,
        60, 43, 48, 54, 62, 45, 54, 10,
    ];
    pub(crate) const AsiaAmman: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        85, 0, 0, 0, 3, 0, 0, 0, 13, 255, 255, 255, 255, 182, 163, 214, 208, 0, 0, 0, 0, 6, 114,
        121, 224, 0, 0, 0, 0, 7, 12, 171, 80, 0, 0, 0, 0, 8, 36, 55, 96, 0, 0, 0, 0, 8, 237, 222,
        208, 0, 0, 0, 0, 10, 5, 106, 224, 0, 0, 0, 0, 10, 207, 18, 80, 0, 0, 0, 0, 11, 231, 239,
        224, 0, 0, 0, 0, 12, 218, 117, 208, 0, 0, 0, 0, 13, 201, 35, 96, 0, 0, 0, 0, 14, 146, 202,
        208, 0, 0, 0, 0, 15, 169, 5, 96, 0, 0, 0, 0, 16, 114, 172, 208, 0, 0, 0, 0, 28, 173, 213,
        96, 0, 0, 0, 0, 29, 159, 9, 208, 0, 0, 0, 0, 30, 146, 253, 96, 0, 0, 0, 0, 31, 130, 224,
        80, 0, 0, 0, 0, 32, 114, 223, 96, 0, 0, 0, 0, 33, 98, 194, 80, 0, 0, 0, 0, 34, 82, 193, 96,
        0, 0, 0, 0, 35, 75, 222, 208, 0, 0, 0, 0, 36, 100, 188, 96, 0, 0, 0, 0, 37, 43, 192, 208,
        0, 0, 0, 0, 38, 55, 111, 96, 0, 0, 0, 0, 39, 11, 162, 208, 0, 0, 0, 0, 40, 11, 115, 224, 0,
        0, 0, 0, 40, 226, 74, 80, 0, 0, 0, 0, 41, 228, 190, 96, 0, 0, 0, 0, 42, 203, 102, 208, 0,
        0, 0, 0, 43, 187, 101, 224, 0, 0, 0, 0, 44, 171, 72, 208, 0, 0, 0, 0, 45, 155, 71, 224, 0,
        0, 0, 0, 46, 120, 181, 208, 0, 0, 0, 0, 47, 132, 100, 96, 0, 0, 0, 0, 48, 88, 165, 224, 0,
        0, 0, 0, 49, 100, 70, 96, 0, 0, 0, 0, 50, 65, 194, 96, 0, 0, 0, 0, 51, 68, 40, 96, 0, 0, 0,
        0, 52, 33, 164, 96, 0, 0, 0, 0, 53, 36, 10, 96, 0, 0, 0, 0, 54, 1, 134, 96, 0, 0, 0, 0, 55,
        122, 147, 96, 0, 0, 0, 0, 55, 234, 162, 224, 0, 0, 0, 0, 56, 226, 124, 224, 0, 0, 0, 0, 57,
        211, 191, 96, 0, 0, 0, 0, 58, 194, 94, 224, 0, 0, 0, 0, 59, 179, 161, 96, 0, 0, 0, 0, 60,
        163, 146, 96, 0, 0, 0, 0, 61, 147, 131, 96, 0, 0, 0, 0, 62, 131, 116, 96, 0, 0, 0, 0, 63,
        152, 79, 96, 0, 0, 0, 0, 64, 99, 86, 96, 0, 0, 0, 0, 65, 110, 246, 224, 0, 0, 0, 0, 66, 76,
        114, 224, 0, 0, 0, 0, 67, 60, 99, 224, 0, 0, 0, 0, 68, 44, 84, 224, 0, 0, 0, 0, 69, 65, 47,
        224, 0, 0, 0, 0, 70, 12, 54, 224, 0, 0, 0, 0, 71, 33, 17, 224, 0, 0, 0, 0, 71, 236, 24,
        224, 0, 0, 0, 0, 73, 10, 46, 96, 0, 0, 0, 0, 73, 203, 250, 224, 0, 0, 0, 0, 74, 234, 16,
        96, 0, 0, 0, 0, 75, 171, 220, 224, 0, 0, 0, 0, 76, 201, 242, 96, 0, 0, 0, 0, 77, 148, 249,
        96, 0, 0, 0, 0, 78, 169, 212, 96, 0, 0, 0, 0, 79, 116, 219, 96, 0, 0, 0, 0, 82, 179, 94,
        80, 0, 0, 0, 0, 83, 52, 159, 96, 0, 0, 0, 0, 84, 82, 180, 224, 0, 0, 0, 0, 85, 20, 129, 96,
        0, 0, 0, 0, 86, 50, 150, 224, 0, 0, 0, 0, 86, 253, 157, 224, 0, 0, 0, 0, 88, 18, 120, 224,
        0, 0, 0, 0, 88, 221, 127, 224, 0, 0, 0, 0, 89, 242, 90, 224, 0, 0, 0, 0, 90, 189, 97, 224,
        0, 0, 0, 0, 91, 210, 60, 224, 0, 0, 0, 0, 92, 157, 67, 224, 0, 0, 0, 0, 93, 178, 30, 224,
        0, 0, 0, 0, 94, 125, 37, 224, 0, 0, 0, 0, 95, 155, 59, 96, 0, 0, 0, 0, 96, 93, 7, 224, 0,
        0, 0, 0, 97, 123, 29, 96, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 0, 0, 33, 176, 0, 0, 0, 0, 42, 48, 1, 4, 0, 0, 28, 32, 0, 9, 76, 77, 84, 0, 69,
        69, 83, 84, 0, 69, 69, 84, 0, 10, 69, 69, 84, 45, 50, 69, 69, 83, 84, 44, 77, 50, 46, 53,
        46, 52, 47, 50, 52, 44, 77, 49, 48, 46, 53, 46, 53, 47, 49, 10,
    ];
    pub(crate) const AsiaAnadyr: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        64, 0, 0, 0, 7, 0, 0, 0, 20, 255, 255, 255, 255, 170, 25, 29, 156, 255, 255, 255, 255, 181,
        163, 140, 192, 0, 0, 0, 0, 21, 39, 27, 48, 0, 0, 0, 0, 22, 24, 79, 160, 0, 0, 0, 0, 23, 8,
        78, 176, 0, 0, 0, 0, 23, 249, 145, 48, 0, 0, 0, 0, 24, 233, 144, 64, 0, 0, 0, 0, 25, 218,
        196, 176, 0, 0, 0, 0, 26, 204, 21, 64, 0, 0, 0, 0, 27, 188, 34, 96, 0, 0, 0, 0, 28, 172,
        19, 96, 0, 0, 0, 0, 29, 156, 4, 96, 0, 0, 0, 0, 30, 139, 245, 96, 0, 0, 0, 0, 31, 123, 230,
        96, 0, 0, 0, 0, 32, 107, 215, 96, 0, 0, 0, 0, 33, 91, 200, 96, 0, 0, 0, 0, 34, 75, 185, 96,
        0, 0, 0, 0, 35, 59, 170, 96, 0, 0, 0, 0, 36, 43, 155, 96, 0, 0, 0, 0, 37, 27, 140, 96, 0,
        0, 0, 0, 38, 11, 125, 96, 0, 0, 0, 0, 39, 4, 168, 224, 0, 0, 0, 0, 39, 244, 153, 224, 0, 0,
        0, 0, 40, 228, 152, 240, 0, 0, 0, 0, 41, 120, 64, 240, 0, 0, 0, 0, 41, 212, 123, 224, 0, 0,
        0, 0, 42, 196, 108, 224, 0, 0, 0, 0, 43, 180, 93, 224, 0, 0, 0, 0, 44, 164, 78, 224, 0, 0,
        0, 0, 45, 148, 63, 224, 0, 0, 0, 0, 46, 132, 48, 224, 0, 0, 0, 0, 47, 116, 33, 224, 0, 0,
        0, 0, 48, 100, 18, 224, 0, 0, 0, 0, 49, 93, 62, 96, 0, 0, 0, 0, 50, 114, 25, 96, 0, 0, 0,
        0, 51, 61, 32, 96, 0, 0, 0, 0, 52, 81, 251, 96, 0, 0, 0, 0, 53, 29, 2, 96, 0, 0, 0, 0, 54,
        49, 221, 96, 0, 0, 0, 0, 54, 252, 228, 96, 0, 0, 0, 0, 56, 26, 249, 224, 0, 0, 0, 0, 56,
        220, 198, 96, 0, 0, 0, 0, 57, 250, 219, 224, 0, 0, 0, 0, 58, 188, 168, 96, 0, 0, 0, 0, 59,
        218, 189, 224, 0, 0, 0, 0, 60, 165, 196, 224, 0, 0, 0, 0, 61, 186, 159, 224, 0, 0, 0, 0,
        62, 133, 166, 224, 0, 0, 0, 0, 63, 154, 129, 224, 0, 0, 0, 0, 64, 101, 136, 224, 0, 0, 0,
        0, 65, 131, 158, 96, 0, 0, 0, 0, 66, 69, 106, 224, 0, 0, 0, 0, 67, 99, 128, 96, 0, 0, 0, 0,
        68, 37, 76, 224, 0, 0, 0, 0, 69, 67, 98, 96, 0, 0, 0, 0, 70, 5, 46, 224, 0, 0, 0, 0, 71,
        35, 68, 96, 0, 0, 0, 0, 71, 238, 75, 96, 0, 0, 0, 0, 73, 3, 38, 96, 0, 0, 0, 0, 73, 206,
        45, 96, 0, 0, 0, 0, 74, 227, 8, 96, 0, 0, 0, 0, 75, 174, 15, 96, 0, 0, 0, 0, 76, 204, 50,
        240, 0, 0, 0, 0, 77, 141, 255, 112, 1, 3, 2, 3, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1,
        4, 1, 4, 1, 5, 6, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4,
        1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 5, 6, 1, 0, 0, 166, 100, 0, 0, 0, 0, 168, 192, 0, 4,
        0, 0, 196, 224, 1, 8, 0, 0, 182, 208, 0, 12, 0, 0, 182, 208, 1, 12, 0, 0, 168, 192, 1, 4,
        0, 0, 154, 176, 0, 16, 76, 77, 84, 0, 43, 49, 50, 0, 43, 49, 52, 0, 43, 49, 51, 0, 43, 49,
        49, 0, 10, 60, 43, 49, 50, 62, 45, 49, 50, 10,
    ];
    pub(crate) const AsiaAqtau: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        50, 0, 0, 0, 6, 0, 0, 0, 16, 255, 255, 255, 255, 170, 25, 148, 224, 255, 255, 255, 255,
        181, 163, 253, 64, 0, 0, 0, 0, 22, 24, 206, 48, 0, 0, 0, 0, 23, 8, 177, 32, 0, 0, 0, 0, 23,
        249, 243, 160, 0, 0, 0, 0, 24, 233, 242, 176, 0, 0, 0, 0, 25, 219, 39, 32, 0, 0, 0, 0, 26,
        204, 119, 176, 0, 0, 0, 0, 27, 188, 132, 208, 0, 0, 0, 0, 28, 172, 117, 208, 0, 0, 0, 0,
        29, 156, 102, 208, 0, 0, 0, 0, 30, 140, 87, 208, 0, 0, 0, 0, 31, 124, 72, 208, 0, 0, 0, 0,
        32, 108, 57, 208, 0, 0, 0, 0, 33, 92, 42, 208, 0, 0, 0, 0, 34, 76, 27, 208, 0, 0, 0, 0, 35,
        60, 12, 208, 0, 0, 0, 0, 36, 43, 253, 208, 0, 0, 0, 0, 37, 27, 238, 208, 0, 0, 0, 0, 38,
        11, 223, 208, 0, 0, 0, 0, 39, 5, 11, 80, 0, 0, 0, 0, 39, 244, 252, 80, 0, 0, 0, 0, 40, 228,
        251, 96, 0, 0, 0, 0, 41, 120, 163, 96, 0, 0, 0, 0, 41, 212, 222, 80, 0, 0, 0, 0, 42, 196,
        207, 80, 0, 0, 0, 0, 43, 180, 192, 80, 0, 0, 0, 0, 44, 164, 177, 80, 0, 0, 0, 0, 45, 148,
        162, 80, 0, 0, 0, 0, 46, 132, 147, 80, 0, 0, 0, 0, 47, 116, 146, 96, 0, 0, 0, 0, 48, 100,
        131, 96, 0, 0, 0, 0, 49, 93, 174, 224, 0, 0, 0, 0, 50, 114, 137, 224, 0, 0, 0, 0, 51, 61,
        144, 224, 0, 0, 0, 0, 52, 82, 107, 224, 0, 0, 0, 0, 53, 29, 114, 224, 0, 0, 0, 0, 54, 50,
        77, 224, 0, 0, 0, 0, 54, 253, 84, 224, 0, 0, 0, 0, 56, 27, 106, 96, 0, 0, 0, 0, 56, 221,
        54, 224, 0, 0, 0, 0, 57, 251, 76, 96, 0, 0, 0, 0, 58, 189, 24, 224, 0, 0, 0, 0, 59, 219,
        46, 96, 0, 0, 0, 0, 60, 166, 53, 96, 0, 0, 0, 0, 61, 187, 16, 96, 0, 0, 0, 0, 62, 134, 23,
        96, 0, 0, 0, 0, 63, 154, 242, 96, 0, 0, 0, 0, 64, 101, 249, 96, 0, 0, 0, 0, 65, 132, 14,
        224, 1, 2, 3, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 5, 1, 2, 4, 2, 4, 2, 4,
        1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 2, 0, 0, 47, 32, 0, 0, 0, 0,
        56, 64, 0, 4, 0, 0, 70, 80, 0, 8, 0, 0, 84, 96, 0, 12, 0, 0, 84, 96, 1, 12, 0, 0, 70, 80,
        1, 8, 76, 77, 84, 0, 43, 48, 52, 0, 43, 48, 53, 0, 43, 48, 54, 0, 10, 60, 43, 48, 53, 62,
        45, 53, 10,
    ];
    pub(crate) const AsiaAqtobe: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        51, 0, 0, 0, 6, 0, 0, 0, 16, 255, 255, 255, 255, 170, 25, 142, 104, 255, 255, 255, 255,
        181, 163, 253, 64, 0, 0, 0, 0, 21, 39, 139, 176, 0, 0, 0, 0, 22, 24, 192, 32, 0, 0, 0, 0,
        23, 8, 177, 32, 0, 0, 0, 0, 23, 249, 243, 160, 0, 0, 0, 0, 24, 233, 242, 176, 0, 0, 0, 0,
        25, 219, 39, 32, 0, 0, 0, 0, 26, 204, 119, 176, 0, 0, 0, 0, 27, 188, 132, 208, 0, 0, 0, 0,
        28, 172, 117, 208, 0, 0, 0, 0, 29, 156, 102, 208, 0, 0, 0, 0, 30, 140, 87, 208, 0, 0, 0, 0,
        31, 124, 72, 208, 0, 0, 0, 0, 32, 108, 57, 208, 0, 0, 0, 0, 33, 92, 42, 208, 0, 0, 0, 0,
        34, 76, 27, 208, 0, 0, 0, 0, 35, 60, 12, 208, 0, 0, 0, 0, 36, 43, 253, 208, 0, 0, 0, 0, 37,
        27, 238, 208, 0, 0, 0, 0, 38, 11, 223, 208, 0, 0, 0, 0, 39, 5, 11, 80, 0, 0, 0, 0, 39, 244,
        252, 80, 0, 0, 0, 0, 40, 228, 251, 96, 0, 0, 0, 0, 41, 120, 163, 96, 0, 0, 0, 0, 41, 212,
        222, 80, 0, 0, 0, 0, 42, 196, 207, 80, 0, 0, 0, 0, 43, 180, 192, 80, 0, 0, 0, 0, 44, 164,
        177, 80, 0, 0, 0, 0, 45, 148, 162, 80, 0, 0, 0, 0, 46, 132, 147, 80, 0, 0, 0, 0, 47, 116,
        132, 80, 0, 0, 0, 0, 48, 100, 117, 80, 0, 0, 0, 0, 49, 93, 160, 208, 0, 0, 0, 0, 50, 114,
        123, 208, 0, 0, 0, 0, 51, 61, 130, 208, 0, 0, 0, 0, 52, 82, 93, 208, 0, 0, 0, 0, 53, 29,
        100, 208, 0, 0, 0, 0, 54, 50, 63, 208, 0, 0, 0, 0, 54, 253, 70, 208, 0, 0, 0, 0, 56, 27,
        92, 80, 0, 0, 0, 0, 56, 221, 40, 208, 0, 0, 0, 0, 57, 251, 62, 80, 0, 0, 0, 0, 58, 189, 10,
        208, 0, 0, 0, 0, 59, 219, 32, 80, 0, 0, 0, 0, 60, 166, 39, 80, 0, 0, 0, 0, 61, 187, 2, 80,
        0, 0, 0, 0, 62, 134, 9, 80, 0, 0, 0, 0, 63, 154, 228, 80, 0, 0, 0, 0, 64, 101, 235, 80, 0,
        0, 0, 0, 65, 132, 0, 208, 1, 2, 3, 4, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        5, 1, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 0,
        0, 53, 152, 0, 0, 0, 0, 56, 64, 0, 4, 0, 0, 70, 80, 0, 8, 0, 0, 84, 96, 1, 12, 0, 0, 84,
        96, 0, 12, 0, 0, 70, 80, 1, 8, 76, 77, 84, 0, 43, 48, 52, 0, 43, 48, 53, 0, 43, 48, 54, 0,
        10, 60, 43, 48, 53, 62, 45, 53, 10,
    ];
    pub(crate) const AsiaAshgabat: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        25, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 170, 25, 141, 68, 255, 255, 255, 255, 181,
        163, 253, 64, 0, 0, 0, 0, 21, 39, 139, 176, 0, 0, 0, 0, 22, 24, 192, 32, 0, 0, 0, 0, 23, 8,
        191, 48, 0, 0, 0, 0, 23, 249, 243, 160, 0, 0, 0, 0, 24, 233, 242, 176, 0, 0, 0, 0, 25, 219,
        39, 32, 0, 0, 0, 0, 26, 204, 119, 176, 0, 0, 0, 0, 27, 188, 132, 208, 0, 0, 0, 0, 28, 172,
        117, 208, 0, 0, 0, 0, 29, 156, 102, 208, 0, 0, 0, 0, 30, 140, 87, 208, 0, 0, 0, 0, 31, 124,
        72, 208, 0, 0, 0, 0, 32, 108, 57, 208, 0, 0, 0, 0, 33, 92, 42, 208, 0, 0, 0, 0, 34, 76, 27,
        208, 0, 0, 0, 0, 35, 60, 12, 208, 0, 0, 0, 0, 36, 43, 253, 208, 0, 0, 0, 0, 37, 27, 238,
        208, 0, 0, 0, 0, 38, 11, 223, 208, 0, 0, 0, 0, 39, 5, 11, 80, 0, 0, 0, 0, 39, 244, 252, 80,
        0, 0, 0, 0, 40, 228, 251, 96, 0, 0, 0, 0, 41, 120, 163, 96, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 1, 3, 0, 0, 54, 188, 0, 0, 0, 0, 56, 64, 0, 4, 0, 0,
        84, 96, 1, 8, 0, 0, 70, 80, 0, 12, 0, 0, 70, 80, 1, 12, 76, 77, 84, 0, 43, 48, 52, 0, 43,
        48, 54, 0, 43, 48, 53, 0, 10, 60, 43, 48, 53, 62, 45, 53, 10,
    ];
    pub(crate) const AsiaAtyrau: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        50, 0, 0, 0, 7, 0, 0, 0, 20, 255, 255, 255, 255, 170, 25, 147, 80, 255, 255, 255, 255, 181,
        164, 11, 80, 0, 0, 0, 0, 22, 24, 206, 48, 0, 0, 0, 0, 23, 8, 177, 32, 0, 0, 0, 0, 23, 249,
        243, 160, 0, 0, 0, 0, 24, 233, 242, 176, 0, 0, 0, 0, 25, 219, 39, 32, 0, 0, 0, 0, 26, 204,
        119, 176, 0, 0, 0, 0, 27, 188, 132, 208, 0, 0, 0, 0, 28, 172, 117, 208, 0, 0, 0, 0, 29,
        156, 102, 208, 0, 0, 0, 0, 30, 140, 87, 208, 0, 0, 0, 0, 31, 124, 72, 208, 0, 0, 0, 0, 32,
        108, 57, 208, 0, 0, 0, 0, 33, 92, 42, 208, 0, 0, 0, 0, 34, 76, 27, 208, 0, 0, 0, 0, 35, 60,
        12, 208, 0, 0, 0, 0, 36, 43, 253, 208, 0, 0, 0, 0, 37, 27, 238, 208, 0, 0, 0, 0, 38, 11,
        223, 208, 0, 0, 0, 0, 39, 5, 11, 80, 0, 0, 0, 0, 39, 244, 252, 80, 0, 0, 0, 0, 40, 228,
        251, 96, 0, 0, 0, 0, 41, 120, 163, 96, 0, 0, 0, 0, 41, 212, 222, 80, 0, 0, 0, 0, 42, 196,
        207, 80, 0, 0, 0, 0, 43, 180, 192, 80, 0, 0, 0, 0, 44, 164, 177, 80, 0, 0, 0, 0, 45, 148,
        162, 80, 0, 0, 0, 0, 46, 132, 147, 80, 0, 0, 0, 0, 47, 116, 132, 80, 0, 0, 0, 0, 48, 100,
        117, 80, 0, 0, 0, 0, 49, 93, 160, 208, 0, 0, 0, 0, 50, 114, 123, 208, 0, 0, 0, 0, 51, 61,
        130, 208, 0, 0, 0, 0, 52, 82, 93, 208, 0, 0, 0, 0, 53, 29, 100, 208, 0, 0, 0, 0, 54, 50,
        63, 208, 0, 0, 0, 0, 54, 253, 70, 208, 0, 0, 0, 0, 56, 27, 106, 96, 0, 0, 0, 0, 56, 221,
        54, 224, 0, 0, 0, 0, 57, 251, 76, 96, 0, 0, 0, 0, 58, 189, 24, 224, 0, 0, 0, 0, 59, 219,
        46, 96, 0, 0, 0, 0, 60, 166, 53, 96, 0, 0, 0, 0, 61, 187, 16, 96, 0, 0, 0, 0, 62, 134, 23,
        96, 0, 0, 0, 0, 63, 154, 242, 96, 0, 0, 0, 0, 64, 101, 249, 96, 0, 0, 0, 0, 65, 132, 14,
        224, 1, 2, 3, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 4, 2, 5, 6, 2, 4, 2, 4, 2, 4,
        2, 4, 2, 4, 2, 4, 2, 4, 2, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 2, 0, 0, 48, 176, 0, 0, 0, 0,
        42, 48, 0, 4, 0, 0, 70, 80, 0, 8, 0, 0, 84, 96, 0, 12, 0, 0, 84, 96, 1, 12, 0, 0, 70, 80,
        1, 8, 0, 0, 56, 64, 0, 16, 76, 77, 84, 0, 43, 48, 51, 0, 43, 48, 53, 0, 43, 48, 54, 0, 43,
        48, 52, 0, 10, 60, 43, 48, 53, 62, 45, 53, 10,
    ];
    pub(crate) const AsiaBaghdad: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        54, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 105, 134, 177, 220, 255, 255, 255, 255,
        158, 48, 60, 224, 0, 0, 0, 0, 23, 48, 104, 80, 0, 0, 0, 0, 23, 250, 15, 192, 0, 0, 0, 0,
        24, 232, 189, 80, 0, 0, 0, 0, 25, 219, 67, 64, 0, 0, 0, 0, 26, 204, 147, 208, 0, 0, 0, 0,
        27, 189, 200, 64, 0, 0, 0, 0, 28, 173, 199, 80, 0, 0, 0, 0, 29, 156, 116, 224, 0, 0, 0, 0,
        30, 140, 101, 224, 0, 0, 0, 0, 31, 124, 86, 224, 0, 0, 0, 0, 32, 108, 71, 224, 0, 0, 0, 0,
        33, 92, 56, 224, 0, 0, 0, 0, 34, 76, 41, 224, 0, 0, 0, 0, 35, 60, 26, 224, 0, 0, 0, 0, 36,
        44, 11, 224, 0, 0, 0, 0, 37, 27, 252, 224, 0, 0, 0, 0, 38, 11, 237, 224, 0, 0, 0, 0, 39, 5,
        25, 96, 0, 0, 0, 0, 39, 246, 120, 0, 0, 0, 0, 0, 40, 231, 186, 128, 0, 0, 0, 0, 41, 216,
        253, 0, 0, 0, 0, 0, 42, 202, 63, 128, 0, 0, 0, 0, 43, 186, 48, 128, 0, 0, 0, 0, 44, 171,
        115, 0, 0, 0, 0, 0, 45, 155, 100, 0, 0, 0, 0, 0, 46, 140, 166, 128, 0, 0, 0, 0, 47, 124,
        151, 128, 0, 0, 0, 0, 48, 109, 218, 0, 0, 0, 0, 0, 49, 95, 28, 128, 0, 0, 0, 0, 50, 80, 95,
        0, 0, 0, 0, 0, 51, 64, 80, 0, 0, 0, 0, 0, 52, 49, 146, 128, 0, 0, 0, 0, 53, 33, 131, 128,
        0, 0, 0, 0, 54, 18, 198, 0, 0, 0, 0, 0, 55, 2, 183, 0, 0, 0, 0, 0, 55, 243, 249, 128, 0, 0,
        0, 0, 56, 229, 60, 0, 0, 0, 0, 0, 57, 214, 126, 128, 0, 0, 0, 0, 58, 198, 111, 128, 0, 0,
        0, 0, 59, 183, 178, 0, 0, 0, 0, 0, 60, 167, 163, 0, 0, 0, 0, 0, 61, 152, 229, 128, 0, 0, 0,
        0, 62, 136, 214, 128, 0, 0, 0, 0, 63, 122, 25, 0, 0, 0, 0, 0, 64, 107, 91, 128, 0, 0, 0, 0,
        65, 92, 158, 0, 0, 0, 0, 0, 66, 76, 143, 0, 0, 0, 0, 0, 67, 61, 209, 128, 0, 0, 0, 0, 68,
        45, 194, 128, 0, 0, 0, 0, 69, 31, 5, 0, 0, 0, 0, 0, 70, 14, 246, 0, 0, 0, 0, 0, 71, 0, 56,
        128, 1, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 0, 0, 41, 164,
        0, 0, 0, 0, 41, 160, 0, 4, 0, 0, 42, 48, 0, 8, 0, 0, 56, 64, 1, 12, 76, 77, 84, 0, 66, 77,
        84, 0, 43, 48, 51, 0, 43, 48, 52, 0, 10, 60, 43, 48, 51, 62, 45, 51, 10,
    ];
    pub(crate) const AsiaBahrain: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        2, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 161, 242, 157, 48, 0, 0, 0, 0, 4, 138, 146,
        192, 1, 2, 0, 0, 48, 80, 0, 0, 0, 0, 56, 64, 0, 4, 0, 0, 42, 48, 0, 8, 76, 77, 84, 0, 43,
        48, 52, 0, 43, 48, 51, 0, 10, 60, 43, 48, 51, 62, 45, 51, 10,
    ];
    pub(crate) const AsiaBaku: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        66, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 170, 25, 149, 68, 255, 255, 255, 255, 231,
        218, 12, 80, 0, 0, 0, 0, 21, 39, 153, 192, 0, 0, 0, 0, 22, 24, 206, 48, 0, 0, 0, 0, 23, 8,
        205, 64, 0, 0, 0, 0, 23, 250, 1, 176, 0, 0, 0, 0, 24, 234, 0, 192, 0, 0, 0, 0, 25, 219, 53,
        48, 0, 0, 0, 0, 26, 204, 133, 192, 0, 0, 0, 0, 27, 188, 146, 224, 0, 0, 0, 0, 28, 172, 131,
        224, 0, 0, 0, 0, 29, 156, 116, 224, 0, 0, 0, 0, 30, 140, 101, 224, 0, 0, 0, 0, 31, 124, 86,
        224, 0, 0, 0, 0, 32, 108, 71, 224, 0, 0, 0, 0, 33, 92, 56, 224, 0, 0, 0, 0, 34, 76, 41,
        224, 0, 0, 0, 0, 35, 60, 26, 224, 0, 0, 0, 0, 36, 44, 11, 224, 0, 0, 0, 0, 37, 27, 252,
        224, 0, 0, 0, 0, 38, 11, 237, 224, 0, 0, 0, 0, 39, 5, 25, 96, 0, 0, 0, 0, 39, 245, 10, 96,
        0, 0, 0, 0, 40, 229, 9, 112, 0, 0, 0, 0, 41, 212, 250, 112, 0, 0, 0, 0, 42, 196, 235, 112,
        0, 0, 0, 0, 49, 93, 217, 16, 0, 0, 0, 0, 50, 114, 180, 16, 0, 0, 0, 0, 51, 61, 173, 0, 0,
        0, 0, 0, 52, 82, 136, 0, 0, 0, 0, 0, 53, 29, 143, 0, 0, 0, 0, 0, 54, 50, 106, 0, 0, 0, 0,
        0, 54, 253, 113, 0, 0, 0, 0, 0, 56, 27, 134, 128, 0, 0, 0, 0, 56, 221, 83, 0, 0, 0, 0, 0,
        57, 251, 104, 128, 0, 0, 0, 0, 58, 189, 53, 0, 0, 0, 0, 0, 59, 219, 74, 128, 0, 0, 0, 0,
        60, 166, 81, 128, 0, 0, 0, 0, 61, 187, 44, 128, 0, 0, 0, 0, 62, 134, 51, 128, 0, 0, 0, 0,
        63, 155, 14, 128, 0, 0, 0, 0, 64, 102, 21, 128, 0, 0, 0, 0, 65, 132, 43, 0, 0, 0, 0, 0, 66,
        69, 247, 128, 0, 0, 0, 0, 67, 100, 13, 0, 0, 0, 0, 0, 68, 37, 217, 128, 0, 0, 0, 0, 69, 67,
        239, 0, 0, 0, 0, 0, 70, 5, 187, 128, 0, 0, 0, 0, 71, 35, 209, 0, 0, 0, 0, 0, 71, 238, 216,
        0, 0, 0, 0, 0, 73, 3, 179, 0, 0, 0, 0, 0, 73, 206, 186, 0, 0, 0, 0, 0, 74, 227, 149, 0, 0,
        0, 0, 0, 75, 174, 156, 0, 0, 0, 0, 0, 76, 204, 177, 128, 0, 0, 0, 0, 77, 142, 126, 0, 0, 0,
        0, 0, 78, 172, 147, 128, 0, 0, 0, 0, 79, 110, 96, 0, 0, 0, 0, 0, 80, 140, 117, 128, 0, 0,
        0, 0, 81, 87, 124, 128, 0, 0, 0, 0, 82, 108, 87, 128, 0, 0, 0, 0, 83, 55, 94, 128, 0, 0, 0,
        0, 84, 76, 57, 128, 0, 0, 0, 0, 85, 23, 64, 128, 0, 0, 0, 0, 86, 44, 27, 128, 1, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 1, 4, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 0, 0, 46, 188, 0, 0, 0, 0, 42, 48, 0, 4, 0, 0, 70, 80, 1, 8, 0, 0, 56, 64, 0, 12, 0,
        0, 56, 64, 1, 12, 76, 77, 84, 0, 43, 48, 51, 0, 43, 48, 53, 0, 43, 48, 52, 0, 10, 60, 43,
        48, 52, 62, 45, 52, 10,
    ];
    pub(crate) const AsiaBangkok: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        2, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 86, 182, 133, 196, 255, 255, 255, 255, 162,
        106, 103, 196, 1, 2, 0, 0, 94, 60, 0, 0, 0, 0, 94, 60, 0, 4, 0, 0, 98, 112, 0, 8, 76, 77,
        84, 0, 66, 77, 84, 0, 43, 48, 55, 0, 10, 60, 43, 48, 55, 62, 45, 55, 10,
    ];
    pub(crate) const AsiaBarnaul: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        67, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 161, 213, 125, 252, 255, 255, 255, 255,
        181, 163, 225, 32, 0, 0, 0, 0, 21, 39, 111, 144, 0, 0, 0, 0, 22, 24, 164, 0, 0, 0, 0, 0,
        23, 8, 163, 16, 0, 0, 0, 0, 23, 249, 215, 128, 0, 0, 0, 0, 24, 233, 214, 144, 0, 0, 0, 0,
        25, 219, 11, 0, 0, 0, 0, 0, 26, 204, 91, 144, 0, 0, 0, 0, 27, 188, 104, 176, 0, 0, 0, 0,
        28, 172, 89, 176, 0, 0, 0, 0, 29, 156, 74, 176, 0, 0, 0, 0, 30, 140, 59, 176, 0, 0, 0, 0,
        31, 124, 44, 176, 0, 0, 0, 0, 32, 108, 29, 176, 0, 0, 0, 0, 33, 92, 14, 176, 0, 0, 0, 0,
        34, 75, 255, 176, 0, 0, 0, 0, 35, 59, 240, 176, 0, 0, 0, 0, 36, 43, 225, 176, 0, 0, 0, 0,
        37, 27, 210, 176, 0, 0, 0, 0, 38, 11, 195, 176, 0, 0, 0, 0, 39, 4, 239, 48, 0, 0, 0, 0, 39,
        244, 224, 48, 0, 0, 0, 0, 40, 228, 223, 64, 0, 0, 0, 0, 41, 120, 135, 64, 0, 0, 0, 0, 41,
        212, 194, 48, 0, 0, 0, 0, 42, 196, 179, 48, 0, 0, 0, 0, 43, 180, 164, 48, 0, 0, 0, 0, 44,
        164, 149, 48, 0, 0, 0, 0, 45, 148, 134, 48, 0, 0, 0, 0, 46, 132, 119, 48, 0, 0, 0, 0, 47,
        116, 104, 48, 0, 0, 0, 0, 47, 199, 76, 128, 0, 0, 0, 0, 48, 100, 103, 64, 0, 0, 0, 0, 49,
        93, 146, 192, 0, 0, 0, 0, 50, 114, 109, 192, 0, 0, 0, 0, 51, 61, 116, 192, 0, 0, 0, 0, 52,
        82, 79, 192, 0, 0, 0, 0, 53, 29, 86, 192, 0, 0, 0, 0, 54, 50, 49, 192, 0, 0, 0, 0, 54, 253,
        56, 192, 0, 0, 0, 0, 56, 27, 78, 64, 0, 0, 0, 0, 56, 221, 26, 192, 0, 0, 0, 0, 57, 251, 48,
        64, 0, 0, 0, 0, 58, 188, 252, 192, 0, 0, 0, 0, 59, 219, 18, 64, 0, 0, 0, 0, 60, 166, 25,
        64, 0, 0, 0, 0, 61, 186, 244, 64, 0, 0, 0, 0, 62, 133, 251, 64, 0, 0, 0, 0, 63, 154, 214,
        64, 0, 0, 0, 0, 64, 101, 221, 64, 0, 0, 0, 0, 65, 131, 242, 192, 0, 0, 0, 0, 66, 69, 191,
        64, 0, 0, 0, 0, 67, 99, 212, 192, 0, 0, 0, 0, 68, 37, 161, 64, 0, 0, 0, 0, 69, 67, 182,
        192, 0, 0, 0, 0, 70, 5, 131, 64, 0, 0, 0, 0, 71, 35, 152, 192, 0, 0, 0, 0, 71, 238, 159,
        192, 0, 0, 0, 0, 73, 3, 122, 192, 0, 0, 0, 0, 73, 206, 129, 192, 0, 0, 0, 0, 74, 227, 92,
        192, 0, 0, 0, 0, 75, 174, 99, 192, 0, 0, 0, 0, 76, 204, 121, 64, 0, 0, 0, 0, 77, 142, 69,
        192, 0, 0, 0, 0, 84, 75, 243, 48, 0, 0, 0, 0, 86, 246, 234, 64, 1, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 1, 3, 2, 3, 2, 3, 2, 3, 2, 4, 1, 4, 1, 4, 1, 4,
        1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 3, 1, 3, 0, 0,
        78, 132, 0, 0, 0, 0, 84, 96, 0, 4, 0, 0, 112, 128, 1, 8, 0, 0, 98, 112, 0, 12, 0, 0, 98,
        112, 1, 12, 76, 77, 84, 0, 43, 48, 54, 0, 43, 48, 56, 0, 43, 48, 55, 0, 10, 60, 43, 48, 55,
        62, 45, 55, 10,
    ];
    pub(crate) const AsiaBeirut: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        64, 0, 0, 0, 3, 0, 0, 0, 13, 255, 255, 255, 255, 86, 182, 194, 184, 255, 255, 255, 255,
        162, 101, 99, 224, 255, 255, 255, 255, 163, 123, 130, 80, 255, 255, 255, 255, 164, 78, 128,
        96, 255, 255, 255, 255, 165, 63, 180, 208, 255, 255, 255, 255, 166, 37, 39, 224, 255, 255,
        255, 255, 167, 39, 127, 208, 255, 255, 255, 255, 168, 41, 243, 224, 255, 255, 255, 255,
        168, 235, 178, 80, 255, 255, 255, 255, 232, 42, 133, 224, 255, 255, 255, 255, 232, 244, 45,
        80, 255, 255, 255, 255, 234, 11, 185, 96, 255, 255, 255, 255, 234, 213, 96, 208, 255, 255,
        255, 255, 235, 236, 236, 224, 255, 255, 255, 255, 236, 182, 148, 80, 255, 255, 255, 255,
        237, 207, 113, 224, 255, 255, 255, 255, 238, 153, 25, 80, 255, 255, 255, 255, 239, 176,
        165, 96, 255, 255, 255, 255, 240, 122, 76, 208, 0, 0, 0, 0, 4, 166, 94, 96, 0, 0, 0, 0, 5,
        43, 119, 208, 0, 0, 0, 0, 6, 67, 3, 224, 0, 0, 0, 0, 7, 12, 171, 80, 0, 0, 0, 0, 8, 36, 55,
        96, 0, 0, 0, 0, 8, 237, 222, 208, 0, 0, 0, 0, 10, 5, 106, 224, 0, 0, 0, 0, 10, 207, 18, 80,
        0, 0, 0, 0, 11, 231, 239, 224, 0, 0, 0, 0, 12, 177, 151, 80, 0, 0, 0, 0, 13, 201, 35, 96,
        0, 0, 0, 0, 14, 146, 202, 208, 0, 0, 0, 0, 15, 169, 5, 96, 0, 0, 0, 0, 16, 114, 172, 208,
        0, 0, 0, 0, 26, 244, 46, 224, 0, 0, 0, 0, 27, 209, 156, 208, 0, 0, 0, 0, 28, 213, 98, 96,
        0, 0, 0, 0, 29, 178, 208, 80, 0, 0, 0, 0, 30, 182, 149, 224, 0, 0, 0, 0, 31, 148, 3, 208,
        0, 0, 0, 0, 32, 151, 201, 96, 0, 0, 0, 0, 33, 117, 55, 80, 0, 0, 0, 0, 34, 163, 44, 224, 0,
        0, 0, 0, 35, 87, 188, 80, 0, 0, 0, 0, 36, 103, 95, 96, 0, 0, 0, 0, 37, 56, 239, 208, 0, 0,
        0, 0, 38, 60, 181, 96, 0, 0, 0, 0, 39, 26, 35, 80, 0, 0, 0, 0, 40, 29, 232, 224, 0, 0, 0,
        0, 40, 251, 86, 208, 0, 0, 0, 0, 42, 0, 109, 224, 0, 0, 0, 0, 42, 206, 9, 208, 0, 0, 0, 0,
        43, 180, 206, 96, 0, 0, 0, 0, 44, 164, 177, 80, 0, 0, 0, 0, 45, 148, 176, 96, 0, 0, 0, 0,
        46, 132, 147, 80, 0, 0, 0, 0, 47, 116, 146, 96, 0, 0, 0, 0, 48, 100, 117, 80, 0, 0, 0, 0,
        49, 93, 174, 224, 0, 0, 0, 0, 50, 77, 145, 208, 0, 0, 0, 0, 51, 61, 144, 224, 0, 0, 0, 0,
        52, 45, 115, 208, 0, 0, 0, 0, 53, 29, 114, 224, 0, 0, 0, 0, 54, 13, 85, 208, 0, 0, 0, 0,
        54, 253, 84, 224, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0, 0, 33, 72, 0, 0, 0, 0, 42, 48, 1, 4, 0, 0, 28, 32, 0, 9,
        76, 77, 84, 0, 69, 69, 83, 84, 0, 69, 69, 84, 0, 10, 69, 69, 84, 45, 50, 69, 69, 83, 84,
        44, 77, 51, 46, 53, 46, 48, 47, 48, 44, 77, 49, 48, 46, 53, 46, 48, 47, 48, 10,
    ];
    pub(crate) const AsiaBishkek: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        52, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 170, 25, 126, 16, 255, 255, 255, 255, 181,
        163, 239, 48, 0, 0, 0, 0, 21, 39, 125, 160, 0, 0, 0, 0, 22, 24, 178, 16, 0, 0, 0, 0, 23, 8,
        177, 32, 0, 0, 0, 0, 23, 249, 229, 144, 0, 0, 0, 0, 24, 233, 228, 160, 0, 0, 0, 0, 25, 219,
        25, 16, 0, 0, 0, 0, 26, 204, 105, 160, 0, 0, 0, 0, 27, 188, 118, 192, 0, 0, 0, 0, 28, 172,
        103, 192, 0, 0, 0, 0, 29, 156, 88, 192, 0, 0, 0, 0, 30, 140, 73, 192, 0, 0, 0, 0, 31, 124,
        58, 192, 0, 0, 0, 0, 32, 108, 43, 192, 0, 0, 0, 0, 33, 92, 28, 192, 0, 0, 0, 0, 34, 76, 13,
        192, 0, 0, 0, 0, 35, 59, 254, 192, 0, 0, 0, 0, 36, 43, 239, 192, 0, 0, 0, 0, 37, 27, 224,
        192, 0, 0, 0, 0, 38, 11, 209, 192, 0, 0, 0, 0, 39, 4, 253, 64, 0, 0, 0, 0, 39, 244, 238,
        64, 0, 0, 0, 0, 40, 190, 163, 192, 0, 0, 0, 0, 41, 231, 55, 48, 0, 0, 0, 0, 42, 196, 165,
        32, 0, 0, 0, 0, 43, 199, 25, 48, 0, 0, 0, 0, 44, 164, 135, 32, 0, 0, 0, 0, 45, 166, 251,
        48, 0, 0, 0, 0, 46, 132, 105, 32, 0, 0, 0, 0, 47, 134, 221, 48, 0, 0, 0, 0, 48, 100, 75,
        32, 0, 0, 0, 0, 49, 102, 191, 48, 0, 0, 0, 0, 50, 77, 103, 160, 0, 0, 0, 0, 51, 61, 137,
        216, 0, 0, 0, 0, 52, 82, 86, 200, 0, 0, 0, 0, 53, 29, 107, 216, 0, 0, 0, 0, 54, 50, 56,
        200, 0, 0, 0, 0, 54, 253, 77, 216, 0, 0, 0, 0, 56, 27, 85, 72, 0, 0, 0, 0, 56, 221, 47,
        216, 0, 0, 0, 0, 57, 251, 55, 72, 0, 0, 0, 0, 58, 189, 17, 216, 0, 0, 0, 0, 59, 219, 25,
        72, 0, 0, 0, 0, 60, 166, 46, 88, 0, 0, 0, 0, 61, 186, 251, 72, 0, 0, 0, 0, 62, 134, 16, 88,
        0, 0, 0, 0, 63, 154, 221, 72, 0, 0, 0, 0, 64, 101, 242, 88, 0, 0, 0, 0, 65, 131, 249, 200,
        0, 0, 0, 0, 66, 69, 212, 88, 0, 0, 0, 0, 66, 251, 146, 32, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4,
        1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 3, 0, 0, 69, 240, 0, 0, 0, 0, 70, 80, 0, 4, 0, 0, 98, 112, 1,
        8, 0, 0, 84, 96, 0, 12, 0, 0, 84, 96, 1, 12, 76, 77, 84, 0, 43, 48, 53, 0, 43, 48, 55, 0,
        43, 48, 54, 0, 10, 60, 43, 48, 54, 62, 45, 54, 10,
    ];
    pub(crate) const AsiaBrunei: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        2, 0, 0, 0, 3, 0, 0, 0, 14, 255, 255, 255, 255, 173, 138, 2, 68, 255, 255, 255, 255, 186,
        103, 71, 136, 1, 2, 0, 0, 107, 188, 0, 0, 0, 0, 105, 120, 0, 4, 0, 0, 112, 128, 0, 10, 76,
        77, 84, 0, 43, 48, 55, 51, 48, 0, 43, 48, 56, 0, 10, 60, 43, 48, 56, 62, 45, 56, 10,
    ];
    pub(crate) const AsiaCalcutta: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        7, 0, 0, 0, 5, 0, 0, 0, 22, 255, 255, 255, 255, 38, 186, 24, 40, 255, 255, 255, 255, 67,
        231, 235, 48, 255, 255, 255, 255, 135, 157, 188, 186, 255, 255, 255, 255, 202, 219, 140,
        40, 255, 255, 255, 255, 204, 5, 113, 24, 255, 255, 255, 255, 204, 149, 50, 168, 255, 255,
        255, 255, 210, 116, 18, 152, 1, 2, 3, 4, 3, 4, 3, 0, 0, 82, 216, 0, 0, 0, 0, 82, 208, 0, 4,
        0, 0, 75, 70, 0, 8, 0, 0, 77, 88, 0, 12, 0, 0, 91, 104, 1, 16, 76, 77, 84, 0, 72, 77, 84,
        0, 77, 77, 84, 0, 73, 83, 84, 0, 43, 48, 54, 51, 48, 0, 10, 73, 83, 84, 45, 53, 58, 51, 48,
        10,
    ];
    pub(crate) const AsiaChita: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        66, 0, 0, 0, 6, 0, 0, 0, 16, 255, 255, 255, 255, 161, 219, 249, 160, 255, 255, 255, 255,
        181, 163, 197, 0, 0, 0, 0, 0, 21, 39, 83, 112, 0, 0, 0, 0, 22, 24, 135, 224, 0, 0, 0, 0,
        23, 8, 134, 240, 0, 0, 0, 0, 23, 249, 187, 96, 0, 0, 0, 0, 24, 233, 186, 112, 0, 0, 0, 0,
        25, 218, 238, 224, 0, 0, 0, 0, 26, 204, 63, 112, 0, 0, 0, 0, 27, 188, 76, 144, 0, 0, 0, 0,
        28, 172, 61, 144, 0, 0, 0, 0, 29, 156, 46, 144, 0, 0, 0, 0, 30, 140, 31, 144, 0, 0, 0, 0,
        31, 124, 16, 144, 0, 0, 0, 0, 32, 108, 1, 144, 0, 0, 0, 0, 33, 91, 242, 144, 0, 0, 0, 0,
        34, 75, 227, 144, 0, 0, 0, 0, 35, 59, 212, 144, 0, 0, 0, 0, 36, 43, 197, 144, 0, 0, 0, 0,
        37, 27, 182, 144, 0, 0, 0, 0, 38, 11, 167, 144, 0, 0, 0, 0, 39, 4, 211, 16, 0, 0, 0, 0, 39,
        244, 196, 16, 0, 0, 0, 0, 40, 228, 195, 32, 0, 0, 0, 0, 41, 120, 107, 32, 0, 0, 0, 0, 41,
        212, 166, 16, 0, 0, 0, 0, 42, 196, 151, 16, 0, 0, 0, 0, 43, 180, 136, 16, 0, 0, 0, 0, 44,
        164, 121, 16, 0, 0, 0, 0, 45, 148, 106, 16, 0, 0, 0, 0, 46, 132, 91, 16, 0, 0, 0, 0, 47,
        116, 76, 16, 0, 0, 0, 0, 48, 100, 61, 16, 0, 0, 0, 0, 49, 93, 104, 144, 0, 0, 0, 0, 50,
        114, 67, 144, 0, 0, 0, 0, 51, 61, 74, 144, 0, 0, 0, 0, 52, 82, 37, 144, 0, 0, 0, 0, 53, 29,
        44, 144, 0, 0, 0, 0, 54, 50, 7, 144, 0, 0, 0, 0, 54, 253, 14, 144, 0, 0, 0, 0, 56, 27, 36,
        16, 0, 0, 0, 0, 56, 220, 240, 144, 0, 0, 0, 0, 57, 251, 6, 16, 0, 0, 0, 0, 58, 188, 210,
        144, 0, 0, 0, 0, 59, 218, 232, 16, 0, 0, 0, 0, 60, 165, 239, 16, 0, 0, 0, 0, 61, 186, 202,
        16, 0, 0, 0, 0, 62, 133, 209, 16, 0, 0, 0, 0, 63, 154, 172, 16, 0, 0, 0, 0, 64, 101, 179,
        16, 0, 0, 0, 0, 65, 131, 200, 144, 0, 0, 0, 0, 66, 69, 149, 16, 0, 0, 0, 0, 67, 99, 170,
        144, 0, 0, 0, 0, 68, 37, 119, 16, 0, 0, 0, 0, 69, 67, 140, 144, 0, 0, 0, 0, 70, 5, 89, 16,
        0, 0, 0, 0, 71, 35, 110, 144, 0, 0, 0, 0, 71, 238, 117, 144, 0, 0, 0, 0, 73, 3, 80, 144, 0,
        0, 0, 0, 73, 206, 87, 144, 0, 0, 0, 0, 74, 227, 50, 144, 0, 0, 0, 0, 75, 174, 57, 144, 0,
        0, 0, 0, 76, 204, 79, 16, 0, 0, 0, 0, 77, 142, 27, 144, 0, 0, 0, 0, 84, 75, 201, 0, 0, 0,
        0, 0, 86, 246, 206, 32, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        4, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 5, 1, 3, 0, 0, 106, 96, 0, 0, 0, 0, 112, 128, 0, 4, 0, 0,
        140, 160, 1, 8, 0, 0, 126, 144, 0, 12, 0, 0, 126, 144, 1, 12, 0, 0, 140, 160, 0, 8, 76, 77,
        84, 0, 43, 48, 56, 0, 43, 49, 48, 0, 43, 48, 57, 0, 10, 60, 43, 48, 57, 62, 45, 57, 10,
    ];
    pub(crate) const AsiaChoibalsan: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        51, 0, 0, 0, 6, 0, 0, 0, 20, 255, 255, 255, 255, 134, 211, 231, 40, 0, 0, 0, 0, 15, 11,
        220, 144, 0, 0, 0, 0, 24, 233, 200, 128, 0, 0, 0, 0, 25, 218, 238, 224, 0, 0, 0, 0, 26,
        204, 63, 112, 0, 0, 0, 0, 27, 188, 34, 96, 0, 0, 0, 0, 28, 172, 33, 112, 0, 0, 0, 0, 29,
        156, 4, 96, 0, 0, 0, 0, 30, 140, 3, 112, 0, 0, 0, 0, 31, 123, 230, 96, 0, 0, 0, 0, 32, 107,
        229, 112, 0, 0, 0, 0, 33, 91, 200, 96, 0, 0, 0, 0, 34, 75, 199, 112, 0, 0, 0, 0, 35, 59,
        170, 96, 0, 0, 0, 0, 36, 43, 169, 112, 0, 0, 0, 0, 37, 27, 140, 96, 0, 0, 0, 0, 38, 11,
        139, 112, 0, 0, 0, 0, 39, 4, 168, 224, 0, 0, 0, 0, 39, 244, 167, 240, 0, 0, 0, 0, 40, 228,
        138, 224, 0, 0, 0, 0, 41, 212, 137, 240, 0, 0, 0, 0, 42, 196, 108, 224, 0, 0, 0, 0, 43,
        180, 107, 240, 0, 0, 0, 0, 44, 164, 78, 224, 0, 0, 0, 0, 45, 148, 77, 240, 0, 0, 0, 0, 46,
        132, 48, 224, 0, 0, 0, 0, 47, 116, 47, 240, 0, 0, 0, 0, 48, 100, 18, 224, 0, 0, 0, 0, 49,
        93, 76, 112, 0, 0, 0, 0, 50, 77, 47, 96, 0, 0, 0, 0, 51, 61, 46, 112, 0, 0, 0, 0, 52, 45,
        17, 96, 0, 0, 0, 0, 53, 29, 16, 112, 0, 0, 0, 0, 54, 12, 243, 96, 0, 0, 0, 0, 58, 233, 165,
        144, 0, 0, 0, 0, 59, 180, 158, 128, 0, 0, 0, 0, 60, 164, 157, 144, 0, 0, 0, 0, 61, 148,
        128, 128, 0, 0, 0, 0, 62, 132, 127, 144, 0, 0, 0, 0, 63, 116, 98, 128, 0, 0, 0, 0, 64, 100,
        97, 144, 0, 0, 0, 0, 65, 84, 68, 128, 0, 0, 0, 0, 66, 68, 67, 144, 0, 0, 0, 0, 67, 52, 38,
        128, 0, 0, 0, 0, 68, 36, 37, 144, 0, 0, 0, 0, 69, 29, 67, 0, 0, 0, 0, 0, 71, 239, 170, 240,
        0, 0, 0, 0, 85, 21, 154, 160, 0, 0, 0, 0, 86, 5, 97, 112, 0, 0, 0, 0, 86, 245, 124, 160, 0,
        0, 0, 0, 87, 229, 67, 112, 1, 2, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4,
        3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 2, 5, 2, 5, 2,
        0, 0, 107, 88, 0, 0, 0, 0, 98, 112, 0, 4, 0, 0, 112, 128, 0, 8, 0, 0, 126, 144, 0, 12, 0,
        0, 140, 160, 1, 16, 0, 0, 126, 144, 1, 12, 76, 77, 84, 0, 43, 48, 55, 0, 43, 48, 56, 0, 43,
        48, 57, 0, 43, 49, 48, 0, 10, 60, 43, 48, 56, 62, 45, 56, 10,
    ];
    pub(crate) const AsiaChongqing: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        29, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 126, 54, 67, 41, 255, 255, 255, 255, 160,
        151, 162, 128, 255, 255, 255, 255, 161, 121, 4, 240, 255, 255, 255, 255, 200, 89, 94, 128,
        255, 255, 255, 255, 201, 9, 249, 112, 255, 255, 255, 255, 201, 211, 189, 0, 255, 255, 255,
        255, 203, 5, 138, 240, 255, 255, 255, 255, 203, 124, 64, 0, 255, 255, 255, 255, 210, 59,
        62, 240, 255, 255, 255, 255, 211, 139, 123, 128, 255, 255, 255, 255, 212, 66, 173, 240,
        255, 255, 255, 255, 213, 69, 34, 0, 255, 255, 255, 255, 214, 76, 191, 240, 255, 255, 255,
        255, 215, 60, 191, 0, 255, 255, 255, 255, 216, 6, 102, 112, 255, 255, 255, 255, 217, 29,
        242, 128, 255, 255, 255, 255, 217, 65, 124, 240, 0, 0, 0, 0, 30, 186, 82, 32, 0, 0, 0, 0,
        31, 105, 155, 144, 0, 0, 0, 0, 32, 126, 132, 160, 0, 0, 0, 0, 33, 73, 125, 144, 0, 0, 0, 0,
        34, 103, 161, 32, 0, 0, 0, 0, 35, 41, 95, 144, 0, 0, 0, 0, 36, 71, 131, 32, 0, 0, 0, 0, 37,
        18, 124, 16, 0, 0, 0, 0, 38, 39, 101, 32, 0, 0, 0, 0, 38, 242, 94, 16, 0, 0, 0, 0, 40, 7,
        71, 32, 0, 0, 0, 0, 40, 210, 64, 16, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 0, 113, 215, 0, 0, 0, 0, 126, 144, 1, 4, 0, 0, 112,
        128, 0, 8, 76, 77, 84, 0, 67, 68, 84, 0, 67, 83, 84, 0, 10, 67, 83, 84, 45, 56, 10,
    ];
    pub(crate) const AsiaColombo: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        8, 0, 0, 0, 7, 0, 0, 0, 24, 255, 255, 255, 255, 86, 182, 153, 36, 255, 255, 255, 255, 135,
        157, 189, 28, 255, 255, 255, 255, 203, 90, 28, 40, 255, 255, 255, 255, 204, 149, 43, 160,
        255, 255, 255, 255, 210, 117, 128, 56, 0, 0, 0, 0, 49, 166, 0, 40, 0, 0, 0, 0, 50, 113, 0,
        32, 0, 0, 0, 0, 68, 63, 234, 40, 1, 2, 3, 4, 2, 5, 6, 2, 0, 0, 74, 220, 0, 0, 0, 0, 74,
        228, 0, 4, 0, 0, 77, 88, 0, 8, 0, 0, 84, 96, 1, 14, 0, 0, 91, 104, 1, 18, 0, 0, 91, 104, 0,
        18, 0, 0, 84, 96, 0, 14, 76, 77, 84, 0, 77, 77, 84, 0, 43, 48, 53, 51, 48, 0, 43, 48, 54,
        0, 43, 48, 54, 51, 48, 0, 10, 60, 43, 48, 53, 51, 48, 62, 45, 53, 58, 51, 48, 10,
    ];
    pub(crate) const AsiaDacca: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        7, 0, 0, 0, 6, 0, 0, 0, 28, 255, 255, 255, 255, 105, 134, 134, 188, 255, 255, 255, 255,
        202, 219, 134, 176, 255, 255, 255, 255, 204, 5, 113, 24, 255, 255, 255, 255, 204, 149, 50,
        168, 255, 255, 255, 255, 221, 168, 210, 152, 0, 0, 0, 0, 74, 59, 196, 16, 0, 0, 0, 0, 75,
        60, 216, 144, 1, 2, 3, 2, 4, 5, 4, 0, 0, 84, 196, 0, 0, 0, 0, 82, 208, 0, 4, 0, 0, 91, 104,
        0, 8, 0, 0, 77, 88, 0, 14, 0, 0, 84, 96, 0, 20, 0, 0, 98, 112, 1, 24, 76, 77, 84, 0, 72,
        77, 84, 0, 43, 48, 54, 51, 48, 0, 43, 48, 53, 51, 48, 0, 43, 48, 54, 0, 43, 48, 55, 0, 10,
        60, 43, 48, 54, 62, 45, 54, 10,
    ];
    pub(crate) const AsiaDamascus: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        99, 0, 0, 0, 3, 0, 0, 0, 13, 255, 255, 255, 255, 161, 242, 171, 120, 255, 255, 255, 255,
        162, 129, 47, 128, 255, 255, 255, 255, 163, 94, 157, 112, 255, 255, 255, 255, 164, 97, 17,
        128, 255, 255, 255, 255, 165, 62, 127, 112, 255, 255, 255, 255, 166, 64, 243, 128, 255,
        255, 255, 255, 167, 30, 97, 112, 255, 255, 255, 255, 168, 32, 213, 128, 255, 255, 255, 255,
        169, 7, 125, 240, 255, 255, 255, 255, 241, 143, 82, 0, 255, 255, 255, 255, 242, 91, 156,
        112, 255, 255, 255, 255, 243, 115, 40, 128, 255, 255, 255, 255, 244, 59, 126, 112, 255,
        255, 255, 255, 245, 85, 173, 128, 255, 255, 255, 255, 246, 31, 84, 240, 255, 255, 255, 255,
        247, 54, 225, 0, 255, 255, 255, 255, 247, 255, 54, 240, 255, 255, 255, 255, 249, 14, 218,
        0, 255, 255, 255, 255, 249, 225, 187, 240, 255, 255, 255, 255, 250, 249, 72, 0, 255, 255,
        255, 255, 251, 194, 239, 112, 255, 255, 255, 255, 252, 219, 205, 0, 255, 255, 255, 255,
        253, 165, 116, 112, 255, 255, 255, 255, 254, 189, 0, 128, 255, 255, 255, 255, 255, 134,
        167, 240, 0, 0, 0, 0, 0, 158, 52, 0, 0, 0, 0, 0, 1, 103, 219, 112, 0, 0, 0, 0, 2, 127, 103,
        128, 0, 0, 0, 0, 3, 73, 14, 240, 0, 0, 0, 0, 4, 97, 236, 128, 0, 0, 0, 0, 5, 43, 147, 240,
        0, 0, 0, 0, 6, 67, 32, 0, 0, 0, 0, 0, 7, 12, 199, 112, 0, 0, 0, 0, 8, 36, 83, 128, 0, 0, 0,
        0, 8, 237, 250, 240, 0, 0, 0, 0, 10, 5, 135, 0, 0, 0, 0, 0, 10, 207, 46, 112, 0, 0, 0, 0,
        11, 232, 12, 0, 0, 0, 0, 0, 12, 177, 179, 112, 0, 0, 0, 0, 13, 201, 63, 128, 0, 0, 0, 0,
        14, 107, 89, 240, 0, 0, 0, 0, 15, 170, 115, 0, 0, 0, 0, 0, 16, 76, 141, 112, 0, 0, 0, 0,
        24, 244, 197, 0, 0, 0, 0, 0, 25, 219, 109, 112, 0, 0, 0, 0, 26, 215, 74, 0, 0, 0, 0, 0, 27,
        189, 242, 112, 0, 0, 0, 0, 30, 85, 35, 0, 0, 0, 0, 0, 31, 138, 229, 112, 0, 0, 0, 0, 32,
        71, 122, 0, 0, 0, 0, 0, 33, 137, 25, 240, 0, 0, 0, 0, 34, 60, 116, 0, 0, 0, 0, 0, 35, 107,
        158, 240, 0, 0, 0, 0, 36, 50, 191, 128, 0, 0, 0, 0, 37, 37, 69, 112, 0, 0, 0, 0, 38, 21,
        68, 128, 0, 0, 0, 0, 39, 5, 39, 112, 0, 0, 0, 0, 39, 246, 91, 224, 0, 0, 0, 0, 40, 231,
        144, 80, 0, 0, 0, 0, 41, 226, 27, 96, 0, 0, 0, 0, 42, 202, 21, 80, 0, 0, 0, 0, 43, 178, 43,
        96, 0, 0, 0, 0, 44, 163, 95, 208, 0, 0, 0, 0, 45, 155, 71, 224, 0, 0, 0, 0, 46, 140, 124,
        80, 0, 0, 0, 0, 47, 124, 123, 96, 0, 0, 0, 0, 48, 109, 175, 208, 0, 0, 0, 0, 49, 95, 0, 96,
        0, 0, 0, 0, 50, 80, 52, 208, 0, 0, 0, 0, 51, 62, 226, 96, 0, 0, 0, 0, 52, 49, 104, 80, 0,
        0, 0, 0, 53, 30, 196, 96, 0, 0, 0, 0, 54, 18, 155, 208, 0, 0, 0, 0, 55, 2, 154, 224, 0, 0,
        0, 0, 55, 243, 207, 80, 0, 0, 0, 0, 56, 229, 31, 224, 0, 0, 0, 0, 57, 214, 84, 80, 0, 0, 0,
        0, 58, 198, 83, 96, 0, 0, 0, 0, 59, 183, 135, 208, 0, 0, 0, 0, 60, 167, 134, 224, 0, 0, 0,
        0, 61, 152, 187, 80, 0, 0, 0, 0, 62, 136, 186, 96, 0, 0, 0, 0, 63, 121, 238, 208, 0, 0, 0,
        0, 64, 107, 63, 96, 0, 0, 0, 0, 65, 92, 115, 208, 0, 0, 0, 0, 66, 76, 114, 224, 0, 0, 0, 0,
        67, 61, 167, 80, 0, 0, 0, 0, 68, 45, 166, 96, 0, 0, 0, 0, 69, 18, 253, 80, 0, 0, 0, 0, 70,
        12, 54, 224, 0, 0, 0, 0, 71, 42, 62, 80, 0, 0, 0, 0, 71, 245, 83, 96, 0, 0, 0, 0, 73, 11,
        113, 208, 0, 0, 0, 0, 73, 203, 250, 224, 0, 0, 0, 0, 74, 234, 2, 80, 0, 0, 0, 0, 75, 181,
        23, 96, 0, 0, 0, 0, 76, 201, 228, 80, 0, 0, 0, 0, 77, 148, 249, 96, 0, 0, 0, 0, 78, 169,
        198, 80, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 0, 34, 8, 0, 0, 0, 0, 42, 48, 1, 4, 0, 0, 28, 32, 0,
        9, 76, 77, 84, 0, 69, 69, 83, 84, 0, 69, 69, 84, 0, 10, 69, 69, 84, 45, 50, 69, 69, 83, 84,
        44, 77, 51, 46, 53, 46, 53, 47, 48, 44, 77, 49, 48, 46, 53, 46, 53, 47, 48, 10,
    ];
    pub(crate) const AsiaDili: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        4, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 146, 230, 24, 196, 255, 255, 255, 255, 203,
        153, 50, 240, 0, 0, 0, 0, 11, 234, 48, 112, 0, 0, 0, 0, 57, 195, 153, 0, 1, 2, 1, 2, 0, 0,
        117, 188, 0, 0, 0, 0, 112, 128, 0, 4, 0, 0, 126, 144, 0, 8, 76, 77, 84, 0, 43, 48, 56, 0,
        43, 48, 57, 0, 10, 60, 43, 48, 57, 62, 45, 57, 10,
    ];
    pub(crate) const AsiaDubai: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 0, 0, 0, 2, 0, 0, 0, 8, 255, 255, 255, 255, 161, 242, 153, 168, 1, 0, 0, 51, 216, 0, 0,
        0, 0, 56, 64, 0, 4, 76, 77, 84, 0, 43, 48, 52, 0, 10, 60, 43, 48, 52, 62, 45, 52, 10,
    ];
    pub(crate) const AsiaDushanbe: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        24, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 170, 25, 131, 128, 255, 255, 255, 255,
        181, 163, 239, 48, 0, 0, 0, 0, 21, 39, 125, 160, 0, 0, 0, 0, 22, 24, 178, 16, 0, 0, 0, 0,
        23, 8, 177, 32, 0, 0, 0, 0, 23, 249, 229, 144, 0, 0, 0, 0, 24, 233, 228, 160, 0, 0, 0, 0,
        25, 219, 25, 16, 0, 0, 0, 0, 26, 204, 105, 160, 0, 0, 0, 0, 27, 188, 118, 192, 0, 0, 0, 0,
        28, 172, 103, 192, 0, 0, 0, 0, 29, 156, 88, 192, 0, 0, 0, 0, 30, 140, 73, 192, 0, 0, 0, 0,
        31, 124, 58, 192, 0, 0, 0, 0, 32, 108, 43, 192, 0, 0, 0, 0, 33, 92, 28, 192, 0, 0, 0, 0,
        34, 76, 13, 192, 0, 0, 0, 0, 35, 59, 254, 192, 0, 0, 0, 0, 36, 43, 239, 192, 0, 0, 0, 0,
        37, 27, 224, 192, 0, 0, 0, 0, 38, 11, 209, 192, 0, 0, 0, 0, 39, 4, 253, 64, 0, 0, 0, 0, 39,
        244, 238, 64, 0, 0, 0, 0, 40, 202, 143, 80, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 4, 1, 0, 0, 64, 128, 0, 0, 0, 0, 70, 80, 0, 4, 0, 0, 98, 112, 1, 8, 0, 0,
        84, 96, 0, 12, 0, 0, 84, 96, 1, 12, 76, 77, 84, 0, 43, 48, 53, 0, 43, 48, 55, 0, 43, 48,
        54, 0, 10, 60, 43, 48, 53, 62, 45, 53, 10,
    ];
    pub(crate) const AsiaFamagusta: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        86, 0, 0, 0, 4, 0, 0, 0, 17, 255, 255, 255, 255, 165, 119, 30, 44, 0, 0, 0, 0, 9, 237, 175,
        224, 0, 0, 0, 0, 10, 221, 146, 208, 0, 0, 0, 0, 11, 250, 100, 224, 0, 0, 0, 0, 12, 190,
        198, 80, 0, 0, 0, 0, 13, 164, 57, 96, 0, 0, 0, 0, 14, 138, 225, 208, 0, 0, 0, 0, 15, 132,
        27, 96, 0, 0, 0, 0, 16, 117, 79, 208, 0, 0, 0, 0, 17, 99, 253, 96, 0, 0, 0, 0, 18, 83, 224,
        80, 0, 0, 0, 0, 19, 77, 25, 224, 0, 0, 0, 0, 20, 51, 194, 80, 0, 0, 0, 0, 21, 35, 193, 96,
        0, 0, 0, 0, 22, 19, 164, 80, 0, 0, 0, 0, 23, 3, 163, 96, 0, 0, 0, 0, 23, 243, 134, 80, 0,
        0, 0, 0, 24, 227, 133, 96, 0, 0, 0, 0, 25, 211, 104, 80, 0, 0, 0, 0, 26, 195, 103, 96, 0,
        0, 0, 0, 27, 188, 132, 208, 0, 0, 0, 0, 28, 172, 131, 224, 0, 0, 0, 0, 29, 156, 102, 208,
        0, 0, 0, 0, 30, 140, 101, 224, 0, 0, 0, 0, 31, 124, 72, 208, 0, 0, 0, 0, 32, 108, 71, 224,
        0, 0, 0, 0, 33, 92, 42, 208, 0, 0, 0, 0, 34, 76, 41, 224, 0, 0, 0, 0, 35, 60, 12, 208, 0,
        0, 0, 0, 36, 44, 11, 224, 0, 0, 0, 0, 37, 27, 238, 208, 0, 0, 0, 0, 38, 11, 237, 224, 0, 0,
        0, 0, 39, 5, 11, 80, 0, 0, 0, 0, 39, 245, 10, 96, 0, 0, 0, 0, 40, 228, 237, 80, 0, 0, 0, 0,
        41, 212, 236, 96, 0, 0, 0, 0, 42, 196, 207, 80, 0, 0, 0, 0, 43, 180, 206, 96, 0, 0, 0, 0,
        44, 164, 177, 80, 0, 0, 0, 0, 45, 148, 176, 96, 0, 0, 0, 0, 46, 132, 147, 80, 0, 0, 0, 0,
        47, 116, 146, 96, 0, 0, 0, 0, 48, 100, 117, 80, 0, 0, 0, 0, 49, 93, 174, 224, 0, 0, 0, 0,
        50, 77, 145, 208, 0, 0, 0, 0, 51, 61, 144, 224, 0, 0, 0, 0, 52, 45, 115, 208, 0, 0, 0, 0,
        53, 29, 114, 224, 0, 0, 0, 0, 54, 50, 120, 16, 0, 0, 0, 0, 54, 253, 127, 16, 0, 0, 0, 0,
        56, 27, 148, 144, 0, 0, 0, 0, 56, 221, 97, 16, 0, 0, 0, 0, 57, 251, 118, 144, 0, 0, 0, 0,
        58, 189, 67, 16, 0, 0, 0, 0, 59, 219, 88, 144, 0, 0, 0, 0, 60, 166, 95, 144, 0, 0, 0, 0,
        61, 187, 58, 144, 0, 0, 0, 0, 62, 134, 65, 144, 0, 0, 0, 0, 63, 155, 28, 144, 0, 0, 0, 0,
        64, 102, 35, 144, 0, 0, 0, 0, 65, 132, 57, 16, 0, 0, 0, 0, 66, 70, 5, 144, 0, 0, 0, 0, 67,
        100, 27, 16, 0, 0, 0, 0, 68, 37, 231, 144, 0, 0, 0, 0, 69, 67, 253, 16, 0, 0, 0, 0, 70, 5,
        201, 144, 0, 0, 0, 0, 71, 35, 223, 16, 0, 0, 0, 0, 71, 238, 230, 16, 0, 0, 0, 0, 73, 3,
        193, 16, 0, 0, 0, 0, 73, 206, 200, 16, 0, 0, 0, 0, 74, 227, 163, 16, 0, 0, 0, 0, 75, 174,
        170, 16, 0, 0, 0, 0, 76, 204, 191, 144, 0, 0, 0, 0, 77, 142, 140, 16, 0, 0, 0, 0, 78, 172,
        161, 144, 0, 0, 0, 0, 79, 110, 110, 16, 0, 0, 0, 0, 80, 140, 131, 144, 0, 0, 0, 0, 81, 87,
        138, 144, 0, 0, 0, 0, 82, 108, 101, 144, 0, 0, 0, 0, 83, 55, 108, 144, 0, 0, 0, 0, 84, 76,
        71, 144, 0, 0, 0, 0, 85, 23, 78, 144, 0, 0, 0, 0, 86, 44, 41, 144, 0, 0, 0, 0, 86, 247, 48,
        144, 0, 0, 0, 0, 87, 208, 127, 208, 0, 0, 0, 0, 89, 245, 40, 16, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 3, 2, 0, 0, 31, 212, 0, 0, 0, 0, 42, 48, 1, 4,
        0, 0, 28, 32, 0, 9, 0, 0, 42, 48, 0, 13, 76, 77, 84, 0, 69, 69, 83, 84, 0, 69, 69, 84, 0,
        43, 48, 51, 0, 10, 69, 69, 84, 45, 50, 69, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 47, 51,
        44, 77, 49, 48, 46, 53, 46, 48, 47, 52, 10,
    ];
    pub(crate) const AsiaGaza: &[u8] = &[
        84, 90, 105, 102, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 51,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        117, 0, 0, 0, 5, 0, 0, 0, 21, 255, 255, 255, 255, 125, 189, 74, 176, 255, 255, 255, 255,
        200, 89, 207, 0, 255, 255, 255, 255, 200, 250, 166, 0, 255, 255, 255, 255, 201, 56, 156,
        128, 255, 255, 255, 255, 204, 229, 235, 128, 255, 255, 255, 255, 205, 172, 254, 0, 255,
        255, 255, 255, 206, 199, 31, 0, 255, 255, 255, 255, 207, 143, 131, 0, 255, 255, 255, 255,
        208, 169, 164, 0, 255, 255, 255, 255, 209, 132, 125, 0, 255, 255, 255, 255, 210, 138, 215,
        128, 255, 255, 255, 255, 211, 101, 176, 128, 255, 255, 255, 255, 212, 108, 11, 0, 255, 255,
        255, 255, 232, 54, 99, 96, 255, 255, 255, 255, 232, 244, 45, 80, 255, 255, 255, 255, 234,
        11, 185, 96, 255, 255, 255, 255, 234, 213, 96, 208, 255, 255, 255, 255, 235, 236, 250, 240,
        255, 255, 255, 255, 236, 181, 109, 0, 255, 255, 255, 255, 237, 207, 127, 240, 255, 255,
        255, 255, 238, 151, 242, 0, 255, 255, 255, 255, 239, 176, 179, 112, 255, 255, 255, 255,
        240, 121, 37, 128, 255, 255, 255, 255, 241, 145, 230, 240, 255, 255, 255, 255, 242, 90, 89,
        0, 255, 255, 255, 255, 243, 115, 26, 112, 255, 255, 255, 255, 244, 59, 140, 128, 255, 255,
        255, 255, 245, 85, 159, 112, 255, 255, 255, 255, 246, 30, 17, 128, 255, 255, 255, 255, 247,
        54, 210, 240, 255, 255, 255, 255, 247, 255, 69, 0, 255, 255, 255, 255, 249, 24, 6, 112,
        255, 255, 255, 255, 249, 225, 202, 0, 255, 255, 255, 255, 250, 249, 57, 240, 255, 255, 255,
        255, 251, 39, 66, 80, 0, 0, 0, 0, 8, 124, 139, 224, 0, 0, 0, 0, 8, 253, 176, 208, 0, 0, 0,
        0, 9, 246, 234, 96, 0, 0, 0, 0, 10, 166, 51, 208, 0, 0, 0, 0, 19, 233, 252, 96, 0, 0, 0, 0,
        20, 33, 91, 96, 0, 0, 0, 0, 26, 250, 198, 96, 0, 0, 0, 0, 27, 142, 110, 96, 0, 0, 0, 0, 28,
        190, 248, 224, 0, 0, 0, 0, 29, 119, 124, 208, 0, 0, 0, 0, 30, 204, 255, 96, 0, 0, 0, 0, 31,
        96, 153, 80, 0, 0, 0, 0, 32, 130, 177, 96, 0, 0, 0, 0, 33, 73, 181, 208, 0, 0, 0, 0, 34,
        94, 158, 224, 0, 0, 0, 0, 35, 32, 93, 80, 0, 0, 0, 0, 36, 90, 48, 96, 0, 0, 0, 0, 37, 0,
        63, 80, 0, 0, 0, 0, 38, 11, 237, 224, 0, 0, 0, 0, 38, 214, 230, 208, 0, 0, 0, 0, 39, 235,
        207, 224, 0, 0, 0, 0, 40, 192, 3, 80, 0, 0, 0, 0, 41, 212, 236, 96, 0, 0, 0, 0, 42, 169,
        31, 208, 0, 0, 0, 0, 43, 187, 101, 224, 0, 0, 0, 0, 44, 137, 1, 208, 0, 0, 0, 0, 45, 155,
        71, 224, 0, 0, 0, 0, 46, 95, 169, 80, 0, 0, 0, 0, 47, 123, 41, 224, 0, 0, 0, 0, 48, 72,
        197, 208, 0, 0, 0, 0, 48, 231, 7, 224, 0, 0, 0, 0, 49, 100, 70, 96, 0, 0, 0, 0, 50, 65,
        194, 96, 0, 0, 0, 0, 51, 68, 40, 96, 0, 0, 0, 0, 52, 33, 164, 96, 0, 0, 0, 0, 53, 36, 10,
        96, 0, 0, 0, 0, 54, 1, 134, 96, 0, 0, 0, 0, 55, 22, 97, 96, 0, 0, 0, 0, 56, 6, 68, 80, 0,
        0, 0, 0, 56, 255, 125, 224, 0, 0, 0, 0, 57, 239, 96, 208, 0, 0, 0, 0, 58, 223, 95, 224, 0,
        0, 0, 0, 59, 207, 66, 208, 0, 0, 0, 0, 60, 191, 65, 224, 0, 0, 0, 0, 61, 175, 36, 208, 0,
        0, 0, 0, 62, 159, 35, 224, 0, 0, 0, 0, 63, 143, 6, 208, 0, 0, 0, 0, 64, 127, 5, 224, 0, 0,
        0, 0, 65, 92, 129, 224, 0, 0, 0, 0, 66, 94, 231, 224, 0, 0, 0, 0, 67, 65, 183, 240, 0, 0,
        0, 0, 68, 45, 166, 96, 0, 0, 0, 0, 69, 18, 253, 80, 0, 0, 0, 0, 70, 14, 217, 224, 0, 0, 0,
        0, 70, 232, 111, 112, 0, 0, 0, 0, 71, 236, 24, 224, 0, 0, 0, 0, 72, 183, 17, 208, 0, 0, 0,
        0, 73, 203, 250, 224, 0, 0, 0, 0, 74, 160, 60, 96, 0, 0, 0, 0, 75, 173, 46, 156, 0, 0, 0,
        0, 76, 97, 189, 208, 0, 0, 0, 0, 77, 148, 249, 156, 0, 0, 0, 0, 78, 53, 194, 80, 0, 0, 0,
        0, 79, 116, 219, 96, 0, 0, 0, 0, 80, 91, 145, 224, 0, 0, 0, 0, 81, 84, 189, 96, 0, 0, 0, 0,
        82, 68, 160, 80, 0, 0, 0, 0, 83, 52, 159, 96, 0, 0, 0, 0, 84, 73, 108, 80, 0, 0, 0, 0, 85,
        21, 210, 224, 0, 0, 0, 0, 86, 41, 92, 96, 0, 0, 0, 0, 86, 245, 194, 240, 0, 0, 0, 0, 88,
        19, 202, 96, 0, 0, 0, 0, 88, 213, 164, 240, 0, 0, 0, 0, 89, 243, 172, 96, 0, 0, 0, 0, 90,
        181, 134, 240, 0, 0, 0, 0, 91, 211, 142, 96, 0, 0, 0, 0, 92, 157, 67, 224, 0, 0, 0, 0, 93,
        179, 98, 80, 0, 0, 0, 0, 94, 126, 119, 96, 0, 0, 0, 0, 95, 147, 82, 96, 0, 0, 0, 0, 96, 94,
        89, 96, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0,
        0, 32, 80, 0, 0, 0, 0, 42, 48, 1, 4, 0, 0, 28, 32, 0, 9, 0, 0, 42, 48, 1, 13, 0, 0, 28, 32,
        0, 17, 76, 77, 84, 0, 69, 69, 83, 84, 0, 69, 69, 84, 0, 73, 68, 84, 0, 73, 83, 84, 0, 10,
        69, 69, 84, 45, 50, 69, 69, 83, 84, 44, 77, 51, 46, 52, 46, 52, 47, 52, 56, 44, 77, 49, 48,
        46, 53, 46, 53, 47, 49, 10,
    ];
    pub(crate) const AsiaHebron: &[u8] = &[
        84, 90, 105, 102, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 51,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        119, 0, 0, 0, 5, 0, 0, 0, 21, 255, 255, 255, 255, 125, 189, 74, 25, 255, 255, 255, 255,
        200, 89, 207, 0, 255, 255, 255, 255, 200, 250, 166, 0, 255, 255, 255, 255, 201, 56, 156,
        128, 255, 255, 255, 255, 204, 229, 235, 128, 255, 255, 255, 255, 205, 172, 254, 0, 255,
        255, 255, 255, 206, 199, 31, 0, 255, 255, 255, 255, 207, 143, 131, 0, 255, 255, 255, 255,
        208, 169, 164, 0, 255, 255, 255, 255, 209, 132, 125, 0, 255, 255, 255, 255, 210, 138, 215,
        128, 255, 255, 255, 255, 211, 101, 176, 128, 255, 255, 255, 255, 212, 108, 11, 0, 255, 255,
        255, 255, 232, 54, 99, 96, 255, 255, 255, 255, 232, 244, 45, 80, 255, 255, 255, 255, 234,
        11, 185, 96, 255, 255, 255, 255, 234, 213, 96, 208, 255, 255, 255, 255, 235, 236, 250, 240,
        255, 255, 255, 255, 236, 181, 109, 0, 255, 255, 255, 255, 237, 207, 127, 240, 255, 255,
        255, 255, 238, 151, 242, 0, 255, 255, 255, 255, 239, 176, 179, 112, 255, 255, 255, 255,
        240, 121, 37, 128, 255, 255, 255, 255, 241, 145, 230, 240, 255, 255, 255, 255, 242, 90, 89,
        0, 255, 255, 255, 255, 243, 115, 26, 112, 255, 255, 255, 255, 244, 59, 140, 128, 255, 255,
        255, 255, 245, 85, 159, 112, 255, 255, 255, 255, 246, 30, 17, 128, 255, 255, 255, 255, 247,
        54, 210, 240, 255, 255, 255, 255, 247, 255, 69, 0, 255, 255, 255, 255, 249, 24, 6, 112,
        255, 255, 255, 255, 249, 225, 202, 0, 255, 255, 255, 255, 250, 249, 57, 240, 255, 255, 255,
        255, 251, 39, 66, 80, 0, 0, 0, 0, 8, 124, 139, 224, 0, 0, 0, 0, 8, 253, 176, 208, 0, 0, 0,
        0, 9, 246, 234, 96, 0, 0, 0, 0, 10, 166, 51, 208, 0, 0, 0, 0, 19, 233, 252, 96, 0, 0, 0, 0,
        20, 33, 91, 96, 0, 0, 0, 0, 26, 250, 198, 96, 0, 0, 0, 0, 27, 142, 110, 96, 0, 0, 0, 0, 28,
        190, 248, 224, 0, 0, 0, 0, 29, 119, 124, 208, 0, 0, 0, 0, 30, 204, 255, 96, 0, 0, 0, 0, 31,
        96, 153, 80, 0, 0, 0, 0, 32, 130, 177, 96, 0, 0, 0, 0, 33, 73, 181, 208, 0, 0, 0, 0, 34,
        94, 158, 224, 0, 0, 0, 0, 35, 32, 93, 80, 0, 0, 0, 0, 36, 90, 48, 96, 0, 0, 0, 0, 37, 0,
        63, 80, 0, 0, 0, 0, 38, 11, 237, 224, 0, 0, 0, 0, 38, 214, 230, 208, 0, 0, 0, 0, 39, 235,
        207, 224, 0, 0, 0, 0, 40, 192, 3, 80, 0, 0, 0, 0, 41, 212, 236, 96, 0, 0, 0, 0, 42, 169,
        31, 208, 0, 0, 0, 0, 43, 187, 101, 224, 0, 0, 0, 0, 44, 137, 1, 208, 0, 0, 0, 0, 45, 155,
        71, 224, 0, 0, 0, 0, 46, 95, 169, 80, 0, 0, 0, 0, 47, 123, 41, 224, 0, 0, 0, 0, 48, 72,
        197, 208, 0, 0, 0, 0, 48, 231, 7, 224, 0, 0, 0, 0, 49, 100, 70, 96, 0, 0, 0, 0, 50, 65,
        194, 96, 0, 0, 0, 0, 51, 68, 40, 96, 0, 0, 0, 0, 52, 33, 164, 96, 0, 0, 0, 0, 53, 36, 10,
        96, 0, 0, 0, 0, 54, 1, 134, 96, 0, 0, 0, 0, 55, 22, 97, 96, 0, 0, 0, 0, 56, 6, 68, 80, 0,
        0, 0, 0, 56, 255, 125, 224, 0, 0, 0, 0, 57, 239, 96, 208, 0, 0, 0, 0, 58, 223, 95, 224, 0,
        0, 0, 0, 59, 207, 66, 208, 0, 0, 0, 0, 60, 191, 65, 224, 0, 0, 0, 0, 61, 175, 36, 208, 0,
        0, 0, 0, 62, 159, 35, 224, 0, 0, 0, 0, 63, 143, 6, 208, 0, 0, 0, 0, 64, 127, 5, 224, 0, 0,
        0, 0, 65, 92, 129, 224, 0, 0, 0, 0, 66, 94, 231, 224, 0, 0, 0, 0, 67, 65, 183, 240, 0, 0,
        0, 0, 68, 45, 166, 96, 0, 0, 0, 0, 69, 18, 253, 80, 0, 0, 0, 0, 70, 14, 217, 224, 0, 0, 0,
        0, 70, 232, 111, 112, 0, 0, 0, 0, 71, 236, 24, 224, 0, 0, 0, 0, 72, 187, 6, 80, 0, 0, 0, 0,
        73, 203, 250, 224, 0, 0, 0, 0, 74, 160, 60, 96, 0, 0, 0, 0, 75, 171, 220, 224, 0, 0, 0, 0,
        76, 97, 189, 208, 0, 0, 0, 0, 77, 148, 249, 156, 0, 0, 0, 0, 78, 53, 194, 80, 0, 0, 0, 0,
        78, 92, 11, 224, 0, 0, 0, 0, 78, 132, 220, 80, 0, 0, 0, 0, 79, 116, 219, 96, 0, 0, 0, 0,
        80, 91, 145, 224, 0, 0, 0, 0, 81, 84, 189, 96, 0, 0, 0, 0, 82, 68, 160, 80, 0, 0, 0, 0, 83,
        52, 159, 96, 0, 0, 0, 0, 84, 73, 108, 80, 0, 0, 0, 0, 85, 21, 210, 224, 0, 0, 0, 0, 86, 41,
        92, 96, 0, 0, 0, 0, 86, 245, 194, 240, 0, 0, 0, 0, 88, 19, 202, 96, 0, 0, 0, 0, 88, 213,
        164, 240, 0, 0, 0, 0, 89, 243, 172, 96, 0, 0, 0, 0, 90, 181, 134, 240, 0, 0, 0, 0, 91, 211,
        142, 96, 0, 0, 0, 0, 92, 157, 67, 224, 0, 0, 0, 0, 93, 179, 98, 80, 0, 0, 0, 0, 94, 126,
        119, 96, 0, 0, 0, 0, 95, 147, 82, 96, 0, 0, 0, 0, 96, 94, 89, 96, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0, 0, 32, 231, 0, 0, 0, 0,
        42, 48, 1, 4, 0, 0, 28, 32, 0, 9, 0, 0, 42, 48, 1, 13, 0, 0, 28, 32, 0, 17, 76, 77, 84, 0,
        69, 69, 83, 84, 0, 69, 69, 84, 0, 73, 68, 84, 0, 73, 83, 84, 0, 10, 69, 69, 84, 45, 50, 69,
        69, 83, 84, 44, 77, 51, 46, 52, 46, 52, 47, 52, 56, 44, 77, 49, 48, 46, 53, 46, 53, 47, 49,
        10,
    ];
    pub(crate) const AsiaHoChiMinh: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        9, 0, 0, 0, 5, 0, 0, 0, 21, 255, 255, 255, 255, 136, 140, 67, 128, 255, 255, 255, 255, 145,
        163, 43, 10, 255, 255, 255, 255, 205, 53, 230, 128, 255, 255, 255, 255, 209, 89, 206, 112,
        255, 255, 255, 255, 210, 59, 62, 240, 255, 255, 255, 255, 213, 50, 187, 16, 255, 255, 255,
        255, 228, 182, 228, 128, 255, 255, 255, 255, 237, 47, 152, 0, 0, 0, 0, 0, 10, 61, 199, 0,
        1, 2, 3, 4, 2, 3, 2, 3, 2, 0, 0, 100, 0, 0, 0, 0, 0, 99, 246, 0, 4, 0, 0, 98, 112, 0, 9, 0,
        0, 112, 128, 0, 13, 0, 0, 126, 144, 0, 17, 76, 77, 84, 0, 80, 76, 77, 84, 0, 43, 48, 55, 0,
        43, 48, 56, 0, 43, 48, 57, 0, 10, 60, 43, 48, 55, 62, 45, 55, 10,
    ];
    pub(crate) const AsiaHongKong: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        69, 0, 0, 0, 5, 0, 0, 0, 22, 255, 255, 255, 255, 133, 105, 99, 144, 255, 255, 255, 255,
        202, 77, 49, 48, 255, 255, 255, 255, 202, 219, 147, 48, 255, 255, 255, 255, 203, 75, 113,
        120, 255, 255, 255, 255, 210, 160, 222, 144, 255, 255, 255, 255, 211, 107, 215, 128, 255,
        255, 255, 255, 212, 147, 88, 184, 255, 255, 255, 255, 213, 66, 176, 56, 255, 255, 255, 255,
        214, 115, 58, 184, 255, 255, 255, 255, 215, 62, 65, 184, 255, 255, 255, 255, 216, 46, 50,
        184, 255, 255, 255, 255, 216, 249, 57, 184, 255, 255, 255, 255, 218, 14, 20, 184, 255, 255,
        255, 255, 218, 217, 27, 184, 255, 255, 255, 255, 219, 237, 246, 184, 255, 255, 255, 255,
        220, 184, 253, 184, 255, 255, 255, 255, 221, 205, 216, 184, 255, 255, 255, 255, 222, 162,
        26, 56, 255, 255, 255, 255, 223, 182, 245, 56, 255, 255, 255, 255, 224, 129, 252, 56, 255,
        255, 255, 255, 225, 150, 201, 40, 255, 255, 255, 255, 226, 79, 105, 56, 255, 255, 255, 255,
        227, 118, 171, 40, 255, 255, 255, 255, 228, 47, 75, 56, 255, 255, 255, 255, 229, 95, 199,
        168, 255, 255, 255, 255, 230, 15, 45, 56, 255, 255, 255, 255, 231, 63, 169, 168, 255, 255,
        255, 255, 231, 248, 73, 184, 255, 255, 255, 255, 233, 31, 139, 168, 255, 255, 255, 255,
        233, 216, 43, 184, 255, 255, 255, 255, 234, 255, 109, 168, 255, 255, 255, 255, 235, 184,
        13, 184, 255, 255, 255, 255, 236, 223, 79, 168, 255, 255, 255, 255, 237, 151, 239, 184,
        255, 255, 255, 255, 238, 200, 108, 40, 255, 255, 255, 255, 239, 119, 209, 184, 255, 255,
        255, 255, 240, 168, 78, 40, 255, 255, 255, 255, 241, 87, 179, 184, 255, 255, 255, 255, 242,
        136, 48, 40, 255, 255, 255, 255, 243, 64, 208, 56, 255, 255, 255, 255, 244, 104, 18, 40,
        255, 255, 255, 255, 245, 32, 178, 56, 255, 255, 255, 255, 246, 71, 244, 40, 255, 255, 255,
        255, 247, 37, 126, 56, 255, 255, 255, 255, 248, 21, 97, 40, 255, 255, 255, 255, 249, 5, 96,
        56, 255, 255, 255, 255, 249, 245, 67, 40, 255, 255, 255, 255, 250, 229, 66, 56, 255, 255,
        255, 255, 251, 222, 95, 168, 255, 255, 255, 255, 252, 206, 94, 184, 255, 255, 255, 255,
        253, 190, 65, 168, 255, 255, 255, 255, 254, 174, 64, 184, 255, 255, 255, 255, 255, 158, 35,
        168, 0, 0, 0, 0, 0, 142, 34, 184, 0, 0, 0, 0, 1, 126, 5, 168, 0, 0, 0, 0, 2, 110, 4, 184,
        0, 0, 0, 0, 3, 93, 231, 168, 0, 0, 0, 0, 4, 77, 230, 184, 0, 0, 0, 0, 5, 71, 4, 40, 0, 0,
        0, 0, 6, 55, 3, 56, 0, 0, 0, 0, 7, 38, 230, 40, 0, 0, 0, 0, 7, 131, 61, 56, 0, 0, 0, 0, 9,
        6, 200, 40, 0, 0, 0, 0, 9, 246, 199, 56, 0, 0, 0, 0, 10, 230, 170, 40, 0, 0, 0, 0, 11, 214,
        169, 56, 0, 0, 0, 0, 12, 198, 140, 40, 0, 0, 0, 0, 17, 155, 57, 56, 0, 0, 0, 0, 18, 111,
        108, 168, 1, 2, 3, 4, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0, 0, 107, 10, 0, 0, 0, 0, 112, 128, 0, 4, 0, 0, 126,
        144, 1, 8, 0, 0, 119, 136, 1, 13, 0, 0, 126, 144, 0, 18, 76, 77, 84, 0, 72, 75, 84, 0, 72,
        75, 83, 84, 0, 72, 75, 87, 84, 0, 74, 83, 84, 0, 10, 72, 75, 84, 45, 56, 10,
    ];
    pub(crate) const AsiaHovd: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        50, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 134, 211, 252, 148, 0, 0, 0, 0, 15, 11,
        234, 160, 0, 0, 0, 0, 24, 233, 214, 144, 0, 0, 0, 0, 25, 219, 11, 0, 0, 0, 0, 0, 26, 204,
        91, 144, 0, 0, 0, 0, 27, 188, 62, 128, 0, 0, 0, 0, 28, 172, 61, 144, 0, 0, 0, 0, 29, 156,
        32, 128, 0, 0, 0, 0, 30, 140, 31, 144, 0, 0, 0, 0, 31, 124, 2, 128, 0, 0, 0, 0, 32, 108, 1,
        144, 0, 0, 0, 0, 33, 91, 228, 128, 0, 0, 0, 0, 34, 75, 227, 144, 0, 0, 0, 0, 35, 59, 198,
        128, 0, 0, 0, 0, 36, 43, 197, 144, 0, 0, 0, 0, 37, 27, 168, 128, 0, 0, 0, 0, 38, 11, 167,
        144, 0, 0, 0, 0, 39, 4, 197, 0, 0, 0, 0, 0, 39, 244, 196, 16, 0, 0, 0, 0, 40, 228, 167, 0,
        0, 0, 0, 0, 41, 212, 166, 16, 0, 0, 0, 0, 42, 196, 137, 0, 0, 0, 0, 0, 43, 180, 136, 16, 0,
        0, 0, 0, 44, 164, 107, 0, 0, 0, 0, 0, 45, 148, 106, 16, 0, 0, 0, 0, 46, 132, 77, 0, 0, 0,
        0, 0, 47, 116, 76, 16, 0, 0, 0, 0, 48, 100, 47, 0, 0, 0, 0, 0, 49, 93, 104, 144, 0, 0, 0,
        0, 50, 77, 75, 128, 0, 0, 0, 0, 51, 61, 74, 144, 0, 0, 0, 0, 52, 45, 45, 128, 0, 0, 0, 0,
        53, 29, 44, 144, 0, 0, 0, 0, 54, 13, 15, 128, 0, 0, 0, 0, 58, 233, 193, 176, 0, 0, 0, 0,
        59, 180, 186, 160, 0, 0, 0, 0, 60, 164, 185, 176, 0, 0, 0, 0, 61, 148, 156, 160, 0, 0, 0,
        0, 62, 132, 155, 176, 0, 0, 0, 0, 63, 116, 126, 160, 0, 0, 0, 0, 64, 100, 125, 176, 0, 0,
        0, 0, 65, 84, 96, 160, 0, 0, 0, 0, 66, 68, 95, 176, 0, 0, 0, 0, 67, 52, 66, 160, 0, 0, 0,
        0, 68, 36, 65, 176, 0, 0, 0, 0, 69, 29, 95, 32, 0, 0, 0, 0, 85, 21, 168, 176, 0, 0, 0, 0,
        86, 5, 111, 128, 0, 0, 0, 0, 86, 245, 138, 176, 0, 0, 0, 0, 87, 229, 81, 128, 1, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 0, 0, 85, 236, 0, 0, 0, 0, 84, 96, 0, 4, 0,
        0, 112, 128, 1, 8, 0, 0, 98, 112, 0, 12, 76, 77, 84, 0, 43, 48, 54, 0, 43, 48, 56, 0, 43,
        48, 55, 0, 10, 60, 43, 48, 55, 62, 45, 55, 10,
    ];
    pub(crate) const AsiaIrkutsk: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        66, 0, 0, 0, 7, 0, 0, 0, 20, 255, 255, 255, 255, 86, 182, 130, 63, 255, 255, 255, 255, 162,
        18, 15, 191, 255, 255, 255, 255, 181, 163, 211, 16, 0, 0, 0, 0, 21, 39, 97, 128, 0, 0, 0,
        0, 22, 24, 149, 240, 0, 0, 0, 0, 23, 8, 149, 0, 0, 0, 0, 0, 23, 249, 201, 112, 0, 0, 0, 0,
        24, 233, 200, 128, 0, 0, 0, 0, 25, 218, 252, 240, 0, 0, 0, 0, 26, 204, 77, 128, 0, 0, 0, 0,
        27, 188, 90, 160, 0, 0, 0, 0, 28, 172, 75, 160, 0, 0, 0, 0, 29, 156, 60, 160, 0, 0, 0, 0,
        30, 140, 45, 160, 0, 0, 0, 0, 31, 124, 30, 160, 0, 0, 0, 0, 32, 108, 15, 160, 0, 0, 0, 0,
        33, 92, 0, 160, 0, 0, 0, 0, 34, 75, 241, 160, 0, 0, 0, 0, 35, 59, 226, 160, 0, 0, 0, 0, 36,
        43, 211, 160, 0, 0, 0, 0, 37, 27, 196, 160, 0, 0, 0, 0, 38, 11, 181, 160, 0, 0, 0, 0, 39,
        4, 225, 32, 0, 0, 0, 0, 39, 244, 210, 32, 0, 0, 0, 0, 40, 228, 209, 48, 0, 0, 0, 0, 41,
        120, 121, 48, 0, 0, 0, 0, 41, 212, 180, 32, 0, 0, 0, 0, 42, 196, 165, 32, 0, 0, 0, 0, 43,
        180, 150, 32, 0, 0, 0, 0, 44, 164, 135, 32, 0, 0, 0, 0, 45, 148, 120, 32, 0, 0, 0, 0, 46,
        132, 105, 32, 0, 0, 0, 0, 47, 116, 90, 32, 0, 0, 0, 0, 48, 100, 75, 32, 0, 0, 0, 0, 49, 93,
        118, 160, 0, 0, 0, 0, 50, 114, 81, 160, 0, 0, 0, 0, 51, 61, 88, 160, 0, 0, 0, 0, 52, 82,
        51, 160, 0, 0, 0, 0, 53, 29, 58, 160, 0, 0, 0, 0, 54, 50, 21, 160, 0, 0, 0, 0, 54, 253, 28,
        160, 0, 0, 0, 0, 56, 27, 50, 32, 0, 0, 0, 0, 56, 220, 254, 160, 0, 0, 0, 0, 57, 251, 20,
        32, 0, 0, 0, 0, 58, 188, 224, 160, 0, 0, 0, 0, 59, 218, 246, 32, 0, 0, 0, 0, 60, 165, 253,
        32, 0, 0, 0, 0, 61, 186, 216, 32, 0, 0, 0, 0, 62, 133, 223, 32, 0, 0, 0, 0, 63, 154, 186,
        32, 0, 0, 0, 0, 64, 101, 193, 32, 0, 0, 0, 0, 65, 131, 214, 160, 0, 0, 0, 0, 66, 69, 163,
        32, 0, 0, 0, 0, 67, 99, 184, 160, 0, 0, 0, 0, 68, 37, 133, 32, 0, 0, 0, 0, 69, 67, 154,
        160, 0, 0, 0, 0, 70, 5, 103, 32, 0, 0, 0, 0, 71, 35, 124, 160, 0, 0, 0, 0, 71, 238, 131,
        160, 0, 0, 0, 0, 73, 3, 94, 160, 0, 0, 0, 0, 73, 206, 101, 160, 0, 0, 0, 0, 74, 227, 64,
        160, 0, 0, 0, 0, 75, 174, 71, 160, 0, 0, 0, 0, 76, 204, 93, 32, 0, 0, 0, 0, 77, 142, 41,
        160, 0, 0, 0, 0, 84, 75, 215, 16, 1, 2, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4,
        3, 4, 3, 4, 5, 2, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 6, 4, 0, 0, 97, 193, 0, 0, 0, 0, 97, 193, 0,
        4, 0, 0, 98, 112, 0, 8, 0, 0, 126, 144, 1, 12, 0, 0, 112, 128, 0, 16, 0, 0, 112, 128, 1,
        16, 0, 0, 126, 144, 0, 12, 76, 77, 84, 0, 73, 77, 84, 0, 43, 48, 55, 0, 43, 48, 57, 0, 43,
        48, 56, 0, 10, 60, 43, 48, 56, 62, 45, 56, 10,
    ];
    pub(crate) const AsiaIstanbul: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        115, 0, 0, 0, 6, 0, 0, 0, 25, 255, 255, 255, 255, 86, 182, 200, 216, 255, 255, 255, 255,
        144, 139, 245, 152, 255, 255, 255, 255, 155, 12, 23, 96, 255, 255, 255, 255, 155, 213, 190,
        208, 255, 255, 255, 255, 162, 101, 99, 224, 255, 255, 255, 255, 163, 123, 130, 80, 255,
        255, 255, 255, 164, 78, 128, 96, 255, 255, 255, 255, 165, 63, 180, 208, 255, 255, 255, 255,
        166, 37, 39, 224, 255, 255, 255, 255, 167, 39, 127, 208, 255, 255, 255, 255, 170, 40, 40,
        96, 255, 255, 255, 255, 170, 225, 253, 208, 255, 255, 255, 255, 171, 249, 137, 224, 255,
        255, 255, 255, 172, 195, 49, 80, 255, 255, 255, 255, 200, 129, 63, 224, 255, 255, 255, 255,
        201, 1, 19, 80, 255, 255, 255, 255, 201, 74, 245, 96, 255, 255, 255, 255, 202, 206, 128,
        80, 255, 255, 255, 255, 203, 203, 174, 96, 255, 255, 255, 255, 210, 107, 9, 80, 255, 255,
        255, 255, 211, 162, 57, 96, 255, 255, 255, 255, 212, 67, 2, 80, 255, 255, 255, 255, 213,
        76, 13, 224, 255, 255, 255, 255, 214, 41, 123, 208, 255, 255, 255, 255, 215, 43, 239, 224,
        255, 255, 255, 255, 216, 9, 93, 208, 255, 255, 255, 255, 217, 2, 151, 96, 255, 255, 255,
        255, 217, 233, 63, 208, 255, 255, 255, 255, 218, 235, 179, 224, 255, 255, 255, 255, 219,
        210, 92, 80, 255, 255, 255, 255, 220, 212, 208, 96, 255, 255, 255, 255, 221, 178, 62, 80,
        255, 255, 255, 255, 241, 244, 185, 96, 255, 255, 255, 255, 244, 98, 239, 80, 255, 255, 255,
        255, 245, 104, 6, 96, 255, 255, 255, 255, 246, 31, 56, 208, 0, 0, 0, 0, 6, 110, 147, 112,
        0, 0, 0, 0, 7, 57, 154, 112, 0, 0, 0, 0, 7, 251, 117, 0, 0, 0, 0, 0, 9, 25, 124, 112, 0, 0,
        0, 0, 9, 208, 203, 0, 0, 0, 0, 0, 10, 249, 94, 112, 0, 0, 0, 0, 11, 177, 254, 128, 0, 0, 0,
        0, 12, 217, 64, 112, 0, 0, 0, 0, 13, 164, 85, 128, 0, 0, 0, 0, 14, 166, 173, 112, 0, 0, 0,
        0, 15, 132, 55, 128, 0, 0, 0, 0, 15, 248, 17, 80, 0, 0, 0, 0, 25, 137, 176, 112, 0, 0, 0,
        0, 25, 220, 176, 224, 0, 0, 0, 0, 27, 230, 208, 240, 0, 0, 0, 0, 28, 198, 239, 240, 0, 0,
        0, 0, 29, 155, 49, 112, 0, 0, 0, 0, 30, 140, 115, 240, 0, 0, 0, 0, 31, 124, 100, 240, 0, 0,
        0, 0, 32, 108, 85, 240, 0, 0, 0, 0, 33, 92, 70, 240, 0, 0, 0, 0, 34, 76, 55, 240, 0, 0, 0,
        0, 35, 60, 40, 240, 0, 0, 0, 0, 36, 44, 25, 240, 0, 0, 0, 0, 37, 28, 10, 240, 0, 0, 0, 0,
        38, 11, 251, 240, 0, 0, 0, 0, 39, 5, 39, 112, 0, 0, 0, 0, 39, 245, 24, 112, 0, 0, 0, 0, 40,
        229, 9, 112, 0, 0, 0, 0, 41, 212, 250, 112, 0, 0, 0, 0, 42, 196, 235, 112, 0, 0, 0, 0, 43,
        180, 220, 112, 0, 0, 0, 0, 44, 164, 205, 112, 0, 0, 0, 0, 45, 139, 131, 240, 0, 0, 0, 0,
        46, 132, 175, 112, 0, 0, 0, 0, 47, 116, 160, 112, 0, 0, 0, 0, 48, 100, 145, 112, 0, 0, 0,
        0, 49, 93, 188, 240, 0, 0, 0, 0, 50, 114, 151, 240, 0, 0, 0, 0, 51, 61, 158, 240, 0, 0, 0,
        0, 52, 82, 121, 240, 0, 0, 0, 0, 53, 29, 128, 240, 0, 0, 0, 0, 54, 50, 91, 240, 0, 0, 0, 0,
        54, 253, 98, 240, 0, 0, 0, 0, 56, 27, 120, 112, 0, 0, 0, 0, 56, 221, 68, 240, 0, 0, 0, 0,
        57, 251, 90, 112, 0, 0, 0, 0, 58, 189, 38, 240, 0, 0, 0, 0, 59, 219, 60, 112, 0, 0, 0, 0,
        60, 166, 67, 112, 0, 0, 0, 0, 61, 187, 30, 112, 0, 0, 0, 0, 62, 134, 37, 112, 0, 0, 0, 0,
        63, 155, 0, 112, 0, 0, 0, 0, 64, 102, 7, 112, 0, 0, 0, 0, 65, 132, 28, 240, 0, 0, 0, 0, 66,
        69, 233, 112, 0, 0, 0, 0, 67, 99, 254, 240, 0, 0, 0, 0, 68, 37, 203, 112, 0, 0, 0, 0, 69,
        67, 224, 240, 0, 0, 0, 0, 70, 5, 201, 144, 0, 0, 0, 0, 71, 35, 223, 16, 0, 0, 0, 0, 71,
        238, 230, 16, 0, 0, 0, 0, 73, 3, 193, 16, 0, 0, 0, 0, 73, 206, 200, 16, 0, 0, 0, 0, 74,
        227, 163, 16, 0, 0, 0, 0, 75, 174, 170, 16, 0, 0, 0, 0, 76, 204, 191, 144, 0, 0, 0, 0, 77,
        143, 221, 144, 0, 0, 0, 0, 78, 172, 161, 144, 0, 0, 0, 0, 79, 110, 110, 16, 0, 0, 0, 0, 80,
        140, 131, 144, 0, 0, 0, 0, 81, 87, 138, 144, 0, 0, 0, 0, 82, 108, 101, 144, 0, 0, 0, 0, 83,
        56, 190, 16, 0, 0, 0, 0, 84, 76, 71, 144, 0, 0, 0, 0, 85, 23, 78, 144, 0, 0, 0, 0, 86, 62,
        158, 144, 0, 0, 0, 0, 86, 247, 48, 144, 0, 0, 0, 0, 87, 207, 46, 80, 1, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 4, 5, 4, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 4, 0, 0, 27, 40, 0, 0, 0, 0, 27, 104, 0,
        4, 0, 0, 42, 48, 1, 8, 0, 0, 28, 32, 0, 13, 0, 0, 42, 48, 0, 17, 0, 0, 56, 64, 1, 21, 76,
        77, 84, 0, 73, 77, 84, 0, 69, 69, 83, 84, 0, 69, 69, 84, 0, 43, 48, 51, 0, 43, 48, 52, 0,
        10, 60, 43, 48, 51, 62, 45, 51, 10,
    ];
    pub(crate) const AsiaJakarta: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        8, 0, 0, 0, 7, 0, 0, 0, 32, 255, 255, 255, 255, 63, 102, 73, 96, 255, 255, 255, 255, 169,
        120, 133, 224, 255, 255, 255, 255, 186, 22, 222, 96, 255, 255, 255, 255, 203, 191, 131,
        136, 255, 255, 255, 255, 210, 86, 238, 112, 255, 255, 255, 255, 215, 60, 198, 8, 255, 255,
        255, 255, 218, 255, 38, 0, 255, 255, 255, 255, 244, 181, 190, 136, 1, 2, 3, 4, 3, 5, 3, 6,
        0, 0, 100, 32, 0, 0, 0, 0, 100, 32, 0, 4, 0, 0, 103, 32, 0, 8, 0, 0, 105, 120, 0, 14, 0, 0,
        126, 144, 0, 20, 0, 0, 112, 128, 0, 24, 0, 0, 98, 112, 0, 28, 76, 77, 84, 0, 66, 77, 84, 0,
        43, 48, 55, 50, 48, 0, 43, 48, 55, 51, 48, 0, 43, 48, 57, 0, 43, 48, 56, 0, 87, 73, 66, 0,
        10, 87, 73, 66, 45, 55, 10,
    ];
    pub(crate) const AsiaJayapura: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        3, 0, 0, 0, 4, 0, 0, 0, 18, 255, 255, 255, 255, 186, 22, 193, 152, 255, 255, 255, 255, 208,
        88, 185, 240, 255, 255, 255, 255, 244, 181, 162, 104, 1, 2, 3, 0, 0, 131, 232, 0, 0, 0, 0,
        126, 144, 0, 4, 0, 0, 133, 152, 0, 8, 0, 0, 126, 144, 0, 14, 76, 77, 84, 0, 43, 48, 57, 0,
        43, 48, 57, 51, 48, 0, 87, 73, 84, 0, 10, 87, 73, 84, 45, 57, 10,
    ];
    pub(crate) const AsiaJerusalem: &[u8] = &[
        84, 90, 105, 102, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 51,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        100, 0, 0, 0, 5, 0, 0, 0, 21, 255, 255, 255, 255, 86, 182, 194, 250, 255, 255, 255, 255,
        158, 48, 69, 136, 255, 255, 255, 255, 200, 89, 207, 0, 255, 255, 255, 255, 200, 250, 166,
        0, 255, 255, 255, 255, 201, 56, 156, 128, 255, 255, 255, 255, 204, 229, 235, 128, 255, 255,
        255, 255, 205, 172, 254, 0, 255, 255, 255, 255, 206, 199, 31, 0, 255, 255, 255, 255, 207,
        143, 131, 0, 255, 255, 255, 255, 208, 169, 164, 0, 255, 255, 255, 255, 209, 132, 125, 0,
        255, 255, 255, 255, 210, 138, 215, 128, 255, 255, 255, 255, 211, 101, 176, 128, 255, 255,
        255, 255, 212, 108, 11, 0, 255, 255, 255, 255, 215, 90, 48, 128, 255, 255, 255, 255, 215,
        223, 88, 0, 255, 255, 255, 255, 216, 47, 195, 128, 255, 255, 255, 255, 217, 30, 99, 0, 255,
        255, 255, 255, 218, 16, 247, 0, 255, 255, 255, 255, 218, 235, 208, 0, 255, 255, 255, 255,
        219, 180, 52, 0, 255, 255, 255, 255, 220, 185, 61, 0, 255, 255, 255, 255, 221, 224, 141, 0,
        255, 255, 255, 255, 222, 180, 206, 128, 255, 255, 255, 255, 223, 164, 191, 128, 255, 255,
        255, 255, 224, 139, 118, 0, 255, 255, 255, 255, 225, 86, 125, 0, 255, 255, 255, 255, 226,
        190, 102, 128, 255, 255, 255, 255, 227, 54, 95, 0, 255, 255, 255, 255, 228, 158, 72, 128,
        255, 255, 255, 255, 229, 22, 65, 0, 255, 255, 255, 255, 230, 116, 240, 0, 255, 255, 255,
        255, 231, 17, 210, 128, 255, 255, 255, 255, 232, 38, 173, 128, 255, 255, 255, 255, 232,
        232, 122, 0, 0, 0, 0, 0, 8, 124, 139, 224, 0, 0, 0, 0, 8, 253, 176, 208, 0, 0, 0, 0, 9,
        246, 234, 96, 0, 0, 0, 0, 10, 166, 51, 208, 0, 0, 0, 0, 19, 233, 252, 96, 0, 0, 0, 0, 20,
        33, 91, 96, 0, 0, 0, 0, 26, 250, 198, 96, 0, 0, 0, 0, 27, 142, 110, 96, 0, 0, 0, 0, 28,
        190, 248, 224, 0, 0, 0, 0, 29, 119, 124, 208, 0, 0, 0, 0, 30, 204, 255, 96, 0, 0, 0, 0, 31,
        96, 153, 80, 0, 0, 0, 0, 32, 130, 177, 96, 0, 0, 0, 0, 33, 73, 181, 208, 0, 0, 0, 0, 34,
        94, 158, 224, 0, 0, 0, 0, 35, 32, 93, 80, 0, 0, 0, 0, 36, 90, 48, 96, 0, 0, 0, 0, 37, 0,
        63, 80, 0, 0, 0, 0, 38, 11, 237, 224, 0, 0, 0, 0, 38, 214, 230, 208, 0, 0, 0, 0, 39, 235,
        207, 224, 0, 0, 0, 0, 40, 192, 3, 80, 0, 0, 0, 0, 41, 212, 236, 96, 0, 0, 0, 0, 42, 169,
        31, 208, 0, 0, 0, 0, 43, 187, 101, 224, 0, 0, 0, 0, 44, 137, 1, 208, 0, 0, 0, 0, 45, 155,
        71, 224, 0, 0, 0, 0, 46, 95, 169, 80, 0, 0, 0, 0, 47, 123, 41, 224, 0, 0, 0, 0, 48, 72,
        197, 208, 0, 0, 0, 0, 49, 72, 150, 224, 0, 0, 0, 0, 50, 60, 110, 80, 0, 0, 0, 0, 51, 49,
        179, 96, 0, 0, 0, 0, 52, 26, 254, 208, 0, 0, 0, 0, 53, 17, 149, 96, 0, 0, 0, 0, 53, 241,
        166, 80, 0, 0, 0, 0, 55, 4, 8, 128, 0, 0, 0, 0, 55, 207, 1, 112, 0, 0, 0, 0, 56, 246, 95,
        128, 0, 0, 0, 0, 57, 220, 249, 224, 0, 0, 0, 0, 58, 208, 237, 112, 0, 0, 0, 0, 59, 174, 91,
        96, 0, 0, 0, 0, 60, 163, 160, 112, 0, 0, 0, 0, 61, 160, 178, 96, 0, 0, 0, 0, 62, 131, 130,
        112, 0, 0, 0, 0, 63, 124, 159, 224, 0, 0, 0, 0, 64, 115, 54, 112, 0, 0, 0, 0, 65, 80, 164,
        96, 0, 0, 0, 0, 66, 76, 143, 0, 0, 0, 0, 0, 67, 72, 79, 112, 0, 0, 0, 0, 68, 44, 113, 0, 0,
        0, 0, 0, 69, 30, 246, 240, 0, 0, 0, 0, 70, 12, 83, 0, 0, 0, 0, 0, 70, 236, 99, 240, 0, 0,
        0, 0, 71, 236, 53, 0, 0, 0, 0, 0, 72, 231, 245, 112, 0, 0, 0, 0, 73, 204, 23, 0, 0, 0, 0,
        0, 74, 190, 156, 240, 0, 0, 0, 0, 75, 171, 249, 0, 0, 0, 0, 0, 76, 140, 9, 240, 0, 0, 0, 0,
        77, 149, 21, 128, 0, 0, 0, 0, 78, 135, 155, 112, 0, 0, 0, 0, 79, 116, 247, 128, 0, 0, 0, 0,
        80, 94, 66, 240, 0, 0, 0, 0, 81, 84, 217, 128, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 0, 0, 33, 6, 0,
        0, 0, 0, 32, 248, 0, 4, 0, 0, 42, 48, 1, 8, 0, 0, 28, 32, 0, 12, 0, 0, 56, 64, 1, 16, 76,
        77, 84, 0, 74, 77, 84, 0, 73, 68, 84, 0, 73, 83, 84, 0, 73, 68, 68, 84, 0, 10, 73, 83, 84,
        45, 50, 73, 68, 84, 44, 77, 51, 46, 52, 46, 52, 47, 50, 54, 44, 77, 49, 48, 46, 53, 46, 48,
        10,
    ];
    pub(crate) const AsiaKabul: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        2, 0, 0, 0, 3, 0, 0, 0, 14, 255, 255, 255, 255, 105, 134, 154, 160, 255, 255, 255, 255,
        208, 249, 215, 64, 1, 2, 0, 0, 64, 224, 0, 0, 0, 0, 56, 64, 0, 4, 0, 0, 63, 72, 0, 8, 76,
        77, 84, 0, 43, 48, 52, 0, 43, 48, 52, 51, 48, 0, 10, 60, 43, 48, 52, 51, 48, 62, 45, 52,
        58, 51, 48, 10,
    ];
    pub(crate) const AsiaKamchatka: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        64, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 167, 82, 150, 196, 255, 255, 255, 255,
        181, 163, 154, 208, 0, 0, 0, 0, 21, 39, 41, 64, 0, 0, 0, 0, 22, 24, 93, 176, 0, 0, 0, 0,
        23, 8, 92, 192, 0, 0, 0, 0, 23, 249, 145, 48, 0, 0, 0, 0, 24, 233, 144, 64, 0, 0, 0, 0, 25,
        218, 196, 176, 0, 0, 0, 0, 26, 204, 21, 64, 0, 0, 0, 0, 27, 188, 34, 96, 0, 0, 0, 0, 28,
        172, 19, 96, 0, 0, 0, 0, 29, 156, 4, 96, 0, 0, 0, 0, 30, 139, 245, 96, 0, 0, 0, 0, 31, 123,
        230, 96, 0, 0, 0, 0, 32, 107, 215, 96, 0, 0, 0, 0, 33, 91, 200, 96, 0, 0, 0, 0, 34, 75,
        185, 96, 0, 0, 0, 0, 35, 59, 170, 96, 0, 0, 0, 0, 36, 43, 155, 96, 0, 0, 0, 0, 37, 27, 140,
        96, 0, 0, 0, 0, 38, 11, 125, 96, 0, 0, 0, 0, 39, 4, 168, 224, 0, 0, 0, 0, 39, 244, 153,
        224, 0, 0, 0, 0, 40, 228, 152, 240, 0, 0, 0, 0, 41, 120, 64, 240, 0, 0, 0, 0, 41, 212, 123,
        224, 0, 0, 0, 0, 42, 196, 108, 224, 0, 0, 0, 0, 43, 180, 93, 224, 0, 0, 0, 0, 44, 164, 78,
        224, 0, 0, 0, 0, 45, 148, 63, 224, 0, 0, 0, 0, 46, 132, 48, 224, 0, 0, 0, 0, 47, 116, 33,
        224, 0, 0, 0, 0, 48, 100, 18, 224, 0, 0, 0, 0, 49, 93, 62, 96, 0, 0, 0, 0, 50, 114, 25, 96,
        0, 0, 0, 0, 51, 61, 32, 96, 0, 0, 0, 0, 52, 81, 251, 96, 0, 0, 0, 0, 53, 29, 2, 96, 0, 0,
        0, 0, 54, 49, 221, 96, 0, 0, 0, 0, 54, 252, 228, 96, 0, 0, 0, 0, 56, 26, 249, 224, 0, 0, 0,
        0, 56, 220, 198, 96, 0, 0, 0, 0, 57, 250, 219, 224, 0, 0, 0, 0, 58, 188, 168, 96, 0, 0, 0,
        0, 59, 218, 189, 224, 0, 0, 0, 0, 60, 165, 196, 224, 0, 0, 0, 0, 61, 186, 159, 224, 0, 0,
        0, 0, 62, 133, 166, 224, 0, 0, 0, 0, 63, 154, 129, 224, 0, 0, 0, 0, 64, 101, 136, 224, 0,
        0, 0, 0, 65, 131, 158, 96, 0, 0, 0, 0, 66, 69, 106, 224, 0, 0, 0, 0, 67, 99, 128, 96, 0, 0,
        0, 0, 68, 37, 76, 224, 0, 0, 0, 0, 69, 67, 98, 96, 0, 0, 0, 0, 70, 5, 46, 224, 0, 0, 0, 0,
        71, 35, 68, 96, 0, 0, 0, 0, 71, 238, 75, 96, 0, 0, 0, 0, 73, 3, 38, 96, 0, 0, 0, 0, 73,
        206, 45, 96, 0, 0, 0, 0, 74, 227, 8, 96, 0, 0, 0, 0, 75, 174, 15, 96, 0, 0, 0, 0, 76, 204,
        50, 240, 0, 0, 0, 0, 77, 141, 255, 112, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 4, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 1, 3, 0, 0, 148, 188, 0, 0, 0, 0, 154, 176, 0,
        4, 0, 0, 182, 208, 1, 8, 0, 0, 168, 192, 0, 12, 0, 0, 168, 192, 1, 12, 76, 77, 84, 0, 43,
        49, 49, 0, 43, 49, 51, 0, 43, 49, 50, 0, 10, 60, 43, 49, 50, 62, 45, 49, 50, 10,
    ];
    pub(crate) const AsiaKarachi: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        11, 0, 0, 0, 6, 0, 0, 0, 29, 255, 255, 255, 255, 137, 126, 252, 164, 255, 255, 255, 255,
        204, 149, 50, 168, 255, 255, 255, 255, 210, 116, 18, 152, 255, 255, 255, 255, 221, 168,
        224, 168, 0, 0, 0, 0, 2, 79, 171, 48, 0, 0, 0, 0, 60, 175, 69, 176, 0, 0, 0, 0, 61, 159,
        40, 160, 0, 0, 0, 0, 72, 65, 160, 48, 0, 0, 0, 0, 73, 11, 71, 160, 0, 0, 0, 0, 73, 228,
        221, 48, 0, 0, 0, 0, 74, 236, 123, 32, 1, 2, 1, 3, 5, 4, 5, 4, 5, 4, 5, 0, 0, 62, 220, 0,
        0, 0, 0, 77, 88, 0, 4, 0, 0, 91, 104, 1, 10, 0, 0, 70, 80, 0, 16, 0, 0, 84, 96, 1, 20, 0,
        0, 70, 80, 0, 25, 76, 77, 84, 0, 43, 48, 53, 51, 48, 0, 43, 48, 54, 51, 48, 0, 43, 48, 53,
        0, 80, 75, 83, 84, 0, 80, 75, 84, 0, 10, 80, 75, 84, 45, 53, 10,
    ];
    pub(crate) const AsiaKashgar: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 0, 0, 0, 2, 0, 0, 0, 8, 255, 255, 255, 255, 176, 254, 186, 100, 1, 0, 0, 82, 28, 0, 0,
        0, 0, 84, 96, 0, 4, 76, 77, 84, 0, 43, 48, 54, 0, 10, 60, 43, 48, 54, 62, 45, 54, 10,
    ];
    pub(crate) const AsiaKathmandu: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        2, 0, 0, 0, 3, 0, 0, 0, 16, 255, 255, 255, 255, 161, 242, 125, 132, 0, 0, 0, 0, 30, 24, 48,
        168, 1, 2, 0, 0, 79, 252, 0, 0, 0, 0, 77, 88, 0, 4, 0, 0, 80, 220, 0, 10, 76, 77, 84, 0,
        43, 48, 53, 51, 48, 0, 43, 48, 53, 52, 53, 0, 10, 60, 43, 48, 53, 52, 53, 62, 45, 53, 58,
        52, 53, 10,
    ];
    pub(crate) const AsiaKhandyga: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        67, 0, 0, 0, 8, 0, 0, 0, 20, 255, 255, 255, 255, 161, 219, 228, 235, 255, 255, 255, 255,
        181, 163, 197, 0, 0, 0, 0, 0, 21, 39, 83, 112, 0, 0, 0, 0, 22, 24, 135, 224, 0, 0, 0, 0,
        23, 8, 134, 240, 0, 0, 0, 0, 23, 249, 187, 96, 0, 0, 0, 0, 24, 233, 186, 112, 0, 0, 0, 0,
        25, 218, 238, 224, 0, 0, 0, 0, 26, 204, 63, 112, 0, 0, 0, 0, 27, 188, 76, 144, 0, 0, 0, 0,
        28, 172, 61, 144, 0, 0, 0, 0, 29, 156, 46, 144, 0, 0, 0, 0, 30, 140, 31, 144, 0, 0, 0, 0,
        31, 124, 16, 144, 0, 0, 0, 0, 32, 108, 1, 144, 0, 0, 0, 0, 33, 91, 242, 144, 0, 0, 0, 0,
        34, 75, 227, 144, 0, 0, 0, 0, 35, 59, 212, 144, 0, 0, 0, 0, 36, 43, 197, 144, 0, 0, 0, 0,
        37, 27, 182, 144, 0, 0, 0, 0, 38, 11, 167, 144, 0, 0, 0, 0, 39, 4, 211, 16, 0, 0, 0, 0, 39,
        244, 196, 16, 0, 0, 0, 0, 40, 228, 195, 32, 0, 0, 0, 0, 41, 120, 107, 32, 0, 0, 0, 0, 41,
        212, 166, 16, 0, 0, 0, 0, 42, 196, 151, 16, 0, 0, 0, 0, 43, 180, 136, 16, 0, 0, 0, 0, 44,
        164, 121, 16, 0, 0, 0, 0, 45, 148, 106, 16, 0, 0, 0, 0, 46, 132, 91, 16, 0, 0, 0, 0, 47,
        116, 76, 16, 0, 0, 0, 0, 48, 100, 61, 16, 0, 0, 0, 0, 49, 93, 104, 144, 0, 0, 0, 0, 50,
        114, 67, 144, 0, 0, 0, 0, 51, 61, 74, 144, 0, 0, 0, 0, 52, 82, 37, 144, 0, 0, 0, 0, 53, 29,
        44, 144, 0, 0, 0, 0, 54, 50, 7, 144, 0, 0, 0, 0, 54, 253, 14, 144, 0, 0, 0, 0, 56, 27, 36,
        16, 0, 0, 0, 0, 56, 220, 240, 144, 0, 0, 0, 0, 57, 251, 6, 16, 0, 0, 0, 0, 58, 188, 210,
        144, 0, 0, 0, 0, 59, 218, 232, 16, 0, 0, 0, 0, 60, 165, 239, 16, 0, 0, 0, 0, 61, 186, 202,
        16, 0, 0, 0, 0, 62, 133, 209, 16, 0, 0, 0, 0, 63, 154, 172, 16, 0, 0, 0, 0, 63, 242, 228,
        112, 0, 0, 0, 0, 64, 101, 165, 0, 0, 0, 0, 0, 65, 131, 186, 128, 0, 0, 0, 0, 66, 69, 135,
        0, 0, 0, 0, 0, 67, 99, 156, 128, 0, 0, 0, 0, 68, 37, 105, 0, 0, 0, 0, 0, 69, 67, 126, 128,
        0, 0, 0, 0, 70, 5, 75, 0, 0, 0, 0, 0, 71, 35, 96, 128, 0, 0, 0, 0, 71, 238, 103, 128, 0, 0,
        0, 0, 73, 3, 66, 128, 0, 0, 0, 0, 73, 206, 73, 128, 0, 0, 0, 0, 74, 227, 36, 128, 0, 0, 0,
        0, 75, 174, 43, 128, 0, 0, 0, 0, 76, 204, 65, 0, 0, 0, 0, 0, 77, 142, 13, 128, 0, 0, 0, 0,
        78, 110, 2, 80, 0, 0, 0, 0, 84, 75, 201, 0, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 4, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 7, 6, 3, 0, 0, 127, 21, 0, 0, 0, 0,
        112, 128, 0, 4, 0, 0, 140, 160, 1, 8, 0, 0, 126, 144, 0, 12, 0, 0, 126, 144, 1, 12, 0, 0,
        154, 176, 1, 16, 0, 0, 140, 160, 0, 8, 0, 0, 154, 176, 0, 16, 76, 77, 84, 0, 43, 48, 56, 0,
        43, 49, 48, 0, 43, 48, 57, 0, 43, 49, 49, 0, 10, 60, 43, 48, 57, 62, 45, 57, 10,
    ];
    pub(crate) const AsiaKrasnoyarsk: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        65, 0, 0, 0, 6, 0, 0, 0, 16, 255, 255, 255, 255, 161, 249, 13, 242, 255, 255, 255, 255,
        181, 163, 225, 32, 0, 0, 0, 0, 21, 39, 111, 144, 0, 0, 0, 0, 22, 24, 164, 0, 0, 0, 0, 0,
        23, 8, 163, 16, 0, 0, 0, 0, 23, 249, 215, 128, 0, 0, 0, 0, 24, 233, 214, 144, 0, 0, 0, 0,
        25, 219, 11, 0, 0, 0, 0, 0, 26, 204, 91, 144, 0, 0, 0, 0, 27, 188, 104, 176, 0, 0, 0, 0,
        28, 172, 89, 176, 0, 0, 0, 0, 29, 156, 74, 176, 0, 0, 0, 0, 30, 140, 59, 176, 0, 0, 0, 0,
        31, 124, 44, 176, 0, 0, 0, 0, 32, 108, 29, 176, 0, 0, 0, 0, 33, 92, 14, 176, 0, 0, 0, 0,
        34, 75, 255, 176, 0, 0, 0, 0, 35, 59, 240, 176, 0, 0, 0, 0, 36, 43, 225, 176, 0, 0, 0, 0,
        37, 27, 210, 176, 0, 0, 0, 0, 38, 11, 195, 176, 0, 0, 0, 0, 39, 4, 239, 48, 0, 0, 0, 0, 39,
        244, 224, 48, 0, 0, 0, 0, 40, 228, 223, 64, 0, 0, 0, 0, 41, 120, 135, 64, 0, 0, 0, 0, 41,
        212, 194, 48, 0, 0, 0, 0, 42, 196, 179, 48, 0, 0, 0, 0, 43, 180, 164, 48, 0, 0, 0, 0, 44,
        164, 149, 48, 0, 0, 0, 0, 45, 148, 134, 48, 0, 0, 0, 0, 46, 132, 119, 48, 0, 0, 0, 0, 47,
        116, 104, 48, 0, 0, 0, 0, 48, 100, 89, 48, 0, 0, 0, 0, 49, 93, 132, 176, 0, 0, 0, 0, 50,
        114, 95, 176, 0, 0, 0, 0, 51, 61, 102, 176, 0, 0, 0, 0, 52, 82, 65, 176, 0, 0, 0, 0, 53,
        29, 72, 176, 0, 0, 0, 0, 54, 50, 35, 176, 0, 0, 0, 0, 54, 253, 42, 176, 0, 0, 0, 0, 56, 27,
        64, 48, 0, 0, 0, 0, 56, 221, 12, 176, 0, 0, 0, 0, 57, 251, 34, 48, 0, 0, 0, 0, 58, 188,
        238, 176, 0, 0, 0, 0, 59, 219, 4, 48, 0, 0, 0, 0, 60, 166, 11, 48, 0, 0, 0, 0, 61, 186,
        230, 48, 0, 0, 0, 0, 62, 133, 237, 48, 0, 0, 0, 0, 63, 154, 200, 48, 0, 0, 0, 0, 64, 101,
        207, 48, 0, 0, 0, 0, 65, 131, 228, 176, 0, 0, 0, 0, 66, 69, 177, 48, 0, 0, 0, 0, 67, 99,
        198, 176, 0, 0, 0, 0, 68, 37, 147, 48, 0, 0, 0, 0, 69, 67, 168, 176, 0, 0, 0, 0, 70, 5,
        117, 48, 0, 0, 0, 0, 71, 35, 138, 176, 0, 0, 0, 0, 71, 238, 145, 176, 0, 0, 0, 0, 73, 3,
        108, 176, 0, 0, 0, 0, 73, 206, 115, 176, 0, 0, 0, 0, 74, 227, 78, 176, 0, 0, 0, 0, 75, 174,
        85, 176, 0, 0, 0, 0, 76, 204, 107, 48, 0, 0, 0, 0, 77, 142, 55, 176, 0, 0, 0, 0, 84, 75,
        229, 32, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 1, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 5, 3, 0, 0, 87, 14, 0, 0, 0, 0, 84, 96, 0, 4, 0, 0, 112, 128, 1, 8, 0, 0,
        98, 112, 0, 12, 0, 0, 98, 112, 1, 12, 0, 0, 112, 128, 0, 8, 76, 77, 84, 0, 43, 48, 54, 0,
        43, 48, 56, 0, 43, 48, 55, 0, 10, 60, 43, 48, 55, 62, 45, 55, 10,
    ];
    pub(crate) const AsiaKualaLumpur: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        8, 0, 0, 0, 8, 0, 0, 0, 32, 255, 255, 255, 255, 126, 54, 85, 170, 255, 255, 255, 255, 134,
        131, 133, 163, 255, 255, 255, 255, 186, 103, 78, 144, 255, 255, 255, 255, 192, 10, 228, 96,
        255, 255, 255, 255, 202, 179, 229, 96, 255, 255, 255, 255, 203, 145, 95, 8, 255, 255, 255,
        255, 210, 72, 109, 240, 0, 0, 0, 0, 22, 145, 245, 8, 1, 2, 3, 4, 5, 6, 5, 7, 0, 0, 95, 86,
        0, 0, 0, 0, 97, 93, 0, 4, 0, 0, 98, 112, 0, 8, 0, 0, 103, 32, 1, 12, 0, 0, 103, 32, 0, 12,
        0, 0, 105, 120, 0, 18, 0, 0, 126, 144, 0, 24, 0, 0, 112, 128, 0, 28, 76, 77, 84, 0, 83, 77,
        84, 0, 43, 48, 55, 0, 43, 48, 55, 50, 48, 0, 43, 48, 55, 51, 48, 0, 43, 48, 57, 0, 43, 48,
        56, 0, 10, 60, 43, 48, 56, 62, 45, 56, 10,
    ];
    pub(crate) const AsiaKuching: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        18, 0, 0, 0, 5, 0, 0, 0, 24, 255, 255, 255, 255, 173, 138, 6, 144, 255, 255, 255, 255, 186,
        103, 71, 136, 255, 255, 255, 255, 191, 123, 39, 128, 255, 255, 255, 255, 191, 243, 27, 80,
        255, 255, 255, 255, 193, 93, 172, 128, 255, 255, 255, 255, 193, 213, 160, 80, 255, 255,
        255, 255, 195, 62, 224, 0, 255, 255, 255, 255, 195, 182, 211, 208, 255, 255, 255, 255, 197,
        32, 19, 128, 255, 255, 255, 255, 197, 152, 7, 80, 255, 255, 255, 255, 199, 1, 71, 0, 255,
        255, 255, 255, 199, 121, 58, 208, 255, 255, 255, 255, 200, 227, 204, 0, 255, 255, 255, 255,
        201, 91, 191, 208, 255, 255, 255, 255, 202, 196, 255, 128, 255, 255, 255, 255, 203, 60,
        243, 80, 255, 255, 255, 255, 203, 145, 88, 0, 255, 255, 255, 255, 210, 72, 109, 240, 1, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 3, 0, 0, 103, 112, 0, 0, 0, 0, 105, 120, 0, 4,
        0, 0, 117, 48, 1, 10, 0, 0, 112, 128, 0, 16, 0, 0, 126, 144, 0, 20, 76, 77, 84, 0, 43, 48,
        55, 51, 48, 0, 43, 48, 56, 50, 48, 0, 43, 48, 56, 0, 43, 48, 57, 0, 10, 60, 43, 48, 56, 62,
        45, 56, 10,
    ];
    pub(crate) const AsiaMacao: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        71, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 133, 105, 91, 142, 255, 255, 255, 255,
        203, 71, 117, 240, 255, 255, 255, 255, 203, 242, 202, 224, 255, 255, 255, 255, 204, 251,
        186, 80, 255, 255, 255, 255, 205, 211, 254, 96, 255, 255, 255, 255, 206, 157, 165, 208,
        255, 255, 255, 255, 210, 97, 122, 112, 255, 255, 255, 255, 211, 120, 248, 112, 255, 255,
        255, 255, 212, 66, 173, 240, 255, 255, 255, 255, 213, 75, 171, 112, 255, 255, 255, 255,
        214, 116, 76, 240, 255, 255, 255, 255, 215, 63, 83, 240, 255, 255, 255, 255, 216, 47, 68,
        240, 255, 255, 255, 255, 216, 248, 250, 112, 255, 255, 255, 255, 218, 13, 213, 112, 255,
        255, 255, 255, 218, 216, 220, 112, 255, 255, 255, 255, 219, 237, 183, 112, 255, 255, 255,
        255, 220, 184, 190, 112, 255, 255, 255, 255, 221, 206, 234, 240, 255, 255, 255, 255, 222,
        161, 218, 240, 255, 255, 255, 255, 223, 182, 181, 240, 255, 255, 255, 255, 224, 129, 188,
        240, 255, 255, 255, 255, 225, 150, 151, 240, 255, 255, 255, 255, 226, 79, 41, 240, 255,
        255, 255, 255, 227, 118, 121, 240, 255, 255, 255, 255, 228, 47, 11, 240, 255, 255, 255,
        255, 229, 95, 150, 112, 255, 255, 255, 255, 230, 14, 237, 240, 255, 255, 255, 255, 231, 63,
        169, 168, 255, 255, 255, 255, 231, 248, 73, 184, 255, 255, 255, 255, 233, 31, 139, 168,
        255, 255, 255, 255, 233, 216, 43, 184, 255, 255, 255, 255, 234, 255, 109, 168, 255, 255,
        255, 255, 235, 184, 13, 184, 255, 255, 255, 255, 236, 223, 79, 168, 255, 255, 255, 255,
        237, 151, 239, 184, 255, 255, 255, 255, 238, 200, 108, 40, 255, 255, 255, 255, 239, 119,
        209, 184, 255, 255, 255, 255, 240, 168, 78, 40, 255, 255, 255, 255, 241, 87, 179, 184, 255,
        255, 255, 255, 242, 136, 48, 40, 255, 255, 255, 255, 243, 64, 208, 56, 255, 255, 255, 255,
        244, 104, 18, 40, 255, 255, 255, 255, 245, 32, 178, 56, 255, 255, 255, 255, 246, 71, 244,
        40, 255, 255, 255, 255, 247, 37, 126, 56, 255, 255, 255, 255, 248, 21, 83, 24, 255, 255,
        255, 255, 249, 5, 96, 56, 255, 255, 255, 255, 249, 245, 53, 24, 255, 255, 255, 255, 250,
        229, 66, 56, 255, 255, 255, 255, 251, 222, 95, 168, 255, 255, 255, 255, 252, 206, 94, 184,
        255, 255, 255, 255, 253, 190, 65, 168, 255, 255, 255, 255, 254, 174, 64, 184, 255, 255,
        255, 255, 255, 158, 35, 168, 0, 0, 0, 0, 0, 142, 34, 184, 0, 0, 0, 0, 1, 126, 5, 168, 0, 0,
        0, 0, 2, 110, 4, 184, 0, 0, 0, 0, 3, 93, 231, 168, 0, 0, 0, 0, 4, 77, 230, 184, 0, 0, 0, 0,
        5, 71, 4, 40, 0, 0, 0, 0, 6, 55, 3, 56, 0, 0, 0, 0, 7, 38, 230, 40, 0, 0, 0, 0, 7, 131, 61,
        56, 0, 0, 0, 0, 9, 6, 200, 40, 0, 0, 0, 0, 9, 246, 199, 56, 0, 0, 0, 0, 10, 230, 170, 40,
        0, 0, 0, 0, 11, 214, 169, 56, 0, 0, 0, 0, 12, 198, 140, 40, 0, 0, 0, 0, 17, 155, 57, 56, 0,
        0, 0, 0, 18, 111, 108, 168, 1, 3, 2, 3, 2, 3, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1,
        4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1,
        4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 0, 0, 106, 114, 0, 0, 0, 0,
        112, 128, 0, 4, 0, 0, 140, 160, 1, 8, 0, 0, 126, 144, 0, 12, 0, 0, 126, 144, 1, 16, 76, 77,
        84, 0, 67, 83, 84, 0, 43, 49, 48, 0, 43, 48, 57, 0, 67, 68, 84, 0, 10, 67, 83, 84, 45, 56,
        10,
    ];
    pub(crate) const AsiaMagadan: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        66, 0, 0, 0, 6, 0, 0, 0, 16, 255, 255, 255, 255, 170, 25, 54, 160, 255, 255, 255, 255, 181,
        163, 168, 224, 0, 0, 0, 0, 21, 39, 55, 80, 0, 0, 0, 0, 22, 24, 107, 192, 0, 0, 0, 0, 23, 8,
        106, 208, 0, 0, 0, 0, 23, 249, 159, 64, 0, 0, 0, 0, 24, 233, 158, 80, 0, 0, 0, 0, 25, 218,
        210, 192, 0, 0, 0, 0, 26, 204, 35, 80, 0, 0, 0, 0, 27, 188, 48, 112, 0, 0, 0, 0, 28, 172,
        33, 112, 0, 0, 0, 0, 29, 156, 18, 112, 0, 0, 0, 0, 30, 140, 3, 112, 0, 0, 0, 0, 31, 123,
        244, 112, 0, 0, 0, 0, 32, 107, 229, 112, 0, 0, 0, 0, 33, 91, 214, 112, 0, 0, 0, 0, 34, 75,
        199, 112, 0, 0, 0, 0, 35, 59, 184, 112, 0, 0, 0, 0, 36, 43, 169, 112, 0, 0, 0, 0, 37, 27,
        154, 112, 0, 0, 0, 0, 38, 11, 139, 112, 0, 0, 0, 0, 39, 4, 182, 240, 0, 0, 0, 0, 39, 244,
        167, 240, 0, 0, 0, 0, 40, 228, 167, 0, 0, 0, 0, 0, 41, 120, 79, 0, 0, 0, 0, 0, 41, 212,
        137, 240, 0, 0, 0, 0, 42, 196, 122, 240, 0, 0, 0, 0, 43, 180, 107, 240, 0, 0, 0, 0, 44,
        164, 92, 240, 0, 0, 0, 0, 45, 148, 77, 240, 0, 0, 0, 0, 46, 132, 62, 240, 0, 0, 0, 0, 47,
        116, 47, 240, 0, 0, 0, 0, 48, 100, 32, 240, 0, 0, 0, 0, 49, 93, 76, 112, 0, 0, 0, 0, 50,
        114, 39, 112, 0, 0, 0, 0, 51, 61, 46, 112, 0, 0, 0, 0, 52, 82, 9, 112, 0, 0, 0, 0, 53, 29,
        16, 112, 0, 0, 0, 0, 54, 49, 235, 112, 0, 0, 0, 0, 54, 252, 242, 112, 0, 0, 0, 0, 56, 27,
        7, 240, 0, 0, 0, 0, 56, 220, 212, 112, 0, 0, 0, 0, 57, 250, 233, 240, 0, 0, 0, 0, 58, 188,
        182, 112, 0, 0, 0, 0, 59, 218, 203, 240, 0, 0, 0, 0, 60, 165, 210, 240, 0, 0, 0, 0, 61,
        186, 173, 240, 0, 0, 0, 0, 62, 133, 180, 240, 0, 0, 0, 0, 63, 154, 143, 240, 0, 0, 0, 0,
        64, 101, 150, 240, 0, 0, 0, 0, 65, 131, 172, 112, 0, 0, 0, 0, 66, 69, 120, 240, 0, 0, 0, 0,
        67, 99, 142, 112, 0, 0, 0, 0, 68, 37, 90, 240, 0, 0, 0, 0, 69, 67, 112, 112, 0, 0, 0, 0,
        70, 5, 60, 240, 0, 0, 0, 0, 71, 35, 82, 112, 0, 0, 0, 0, 71, 238, 89, 112, 0, 0, 0, 0, 73,
        3, 52, 112, 0, 0, 0, 0, 73, 206, 59, 112, 0, 0, 0, 0, 74, 227, 22, 112, 0, 0, 0, 0, 75,
        174, 29, 112, 0, 0, 0, 0, 76, 204, 50, 240, 0, 0, 0, 0, 77, 141, 255, 112, 0, 0, 0, 0, 84,
        75, 172, 224, 0, 0, 0, 0, 87, 27, 156, 0, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 4, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 5, 1, 3, 0, 0, 141, 96, 0, 0, 0, 0, 140,
        160, 0, 4, 0, 0, 168, 192, 1, 8, 0, 0, 154, 176, 0, 12, 0, 0, 154, 176, 1, 12, 0, 0, 168,
        192, 0, 8, 76, 77, 84, 0, 43, 49, 48, 0, 43, 49, 50, 0, 43, 49, 49, 0, 10, 60, 43, 49, 49,
        62, 45, 49, 49, 10,
    ];
    pub(crate) const AsiaMakassar: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        4, 0, 0, 0, 5, 0, 0, 0, 21, 255, 255, 255, 255, 161, 242, 93, 144, 255, 255, 255, 255, 186,
        22, 213, 144, 255, 255, 255, 255, 203, 136, 29, 128, 255, 255, 255, 255, 210, 86, 238, 112,
        1, 2, 3, 4, 0, 0, 111, 240, 0, 0, 0, 0, 111, 240, 0, 4, 0, 0, 112, 128, 0, 8, 0, 0, 126,
        144, 0, 12, 0, 0, 112, 128, 0, 16, 76, 77, 84, 0, 77, 77, 84, 0, 43, 48, 56, 0, 43, 48, 57,
        0, 87, 73, 84, 65, 0, 10, 87, 73, 84, 65, 45, 56, 10,
    ];
    pub(crate) const AsiaManila: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        10, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 20, 225, 220, 16, 255, 255, 255, 255, 123,
        31, 63, 144, 255, 255, 255, 255, 193, 156, 244, 128, 255, 255, 255, 255, 194, 22, 48, 112,
        255, 255, 255, 255, 203, 242, 231, 0, 255, 255, 255, 255, 208, 169, 37, 112, 255, 255, 255,
        255, 226, 108, 57, 0, 255, 255, 255, 255, 226, 213, 162, 240, 0, 0, 0, 0, 15, 117, 70, 128,
        0, 0, 0, 0, 16, 102, 122, 240, 1, 3, 2, 3, 4, 3, 2, 3, 2, 3, 255, 255, 31, 240, 0, 0, 0, 0,
        113, 112, 0, 0, 0, 0, 126, 144, 1, 4, 0, 0, 112, 128, 0, 8, 0, 0, 126, 144, 0, 12, 76, 77,
        84, 0, 80, 68, 84, 0, 80, 83, 84, 0, 74, 83, 84, 0, 10, 80, 83, 84, 45, 56, 10,
    ];
    pub(crate) const AsiaNicosia: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        49, 0, 0, 0, 3, 0, 0, 0, 13, 255, 255, 255, 255, 165, 119, 30, 184, 0, 0, 0, 0, 9, 237,
        175, 224, 0, 0, 0, 0, 10, 221, 146, 208, 0, 0, 0, 0, 11, 250, 100, 224, 0, 0, 0, 0, 12,
        190, 198, 80, 0, 0, 0, 0, 13, 164, 57, 96, 0, 0, 0, 0, 14, 138, 225, 208, 0, 0, 0, 0, 15,
        132, 27, 96, 0, 0, 0, 0, 16, 117, 79, 208, 0, 0, 0, 0, 17, 99, 253, 96, 0, 0, 0, 0, 18, 83,
        224, 80, 0, 0, 0, 0, 19, 77, 25, 224, 0, 0, 0, 0, 20, 51, 194, 80, 0, 0, 0, 0, 21, 35, 193,
        96, 0, 0, 0, 0, 22, 19, 164, 80, 0, 0, 0, 0, 23, 3, 163, 96, 0, 0, 0, 0, 23, 243, 134, 80,
        0, 0, 0, 0, 24, 227, 133, 96, 0, 0, 0, 0, 25, 211, 104, 80, 0, 0, 0, 0, 26, 195, 103, 96,
        0, 0, 0, 0, 27, 188, 132, 208, 0, 0, 0, 0, 28, 172, 131, 224, 0, 0, 0, 0, 29, 156, 102,
        208, 0, 0, 0, 0, 30, 140, 101, 224, 0, 0, 0, 0, 31, 124, 72, 208, 0, 0, 0, 0, 32, 108, 71,
        224, 0, 0, 0, 0, 33, 92, 42, 208, 0, 0, 0, 0, 34, 76, 41, 224, 0, 0, 0, 0, 35, 60, 12, 208,
        0, 0, 0, 0, 36, 44, 11, 224, 0, 0, 0, 0, 37, 27, 238, 208, 0, 0, 0, 0, 38, 11, 237, 224, 0,
        0, 0, 0, 39, 5, 11, 80, 0, 0, 0, 0, 39, 245, 10, 96, 0, 0, 0, 0, 40, 228, 237, 80, 0, 0, 0,
        0, 41, 212, 236, 96, 0, 0, 0, 0, 42, 196, 207, 80, 0, 0, 0, 0, 43, 180, 206, 96, 0, 0, 0,
        0, 44, 164, 177, 80, 0, 0, 0, 0, 45, 148, 176, 96, 0, 0, 0, 0, 46, 132, 147, 80, 0, 0, 0,
        0, 47, 116, 146, 96, 0, 0, 0, 0, 48, 100, 117, 80, 0, 0, 0, 0, 49, 93, 174, 224, 0, 0, 0,
        0, 50, 77, 145, 208, 0, 0, 0, 0, 51, 61, 144, 224, 0, 0, 0, 0, 52, 45, 115, 208, 0, 0, 0,
        0, 53, 29, 114, 224, 0, 0, 0, 0, 54, 50, 120, 16, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 0, 0, 31, 72, 0, 0, 0, 0, 42, 48, 1, 4, 0, 0, 28, 32, 0, 9, 76, 77, 84, 0,
        69, 69, 83, 84, 0, 69, 69, 84, 0, 10, 69, 69, 84, 45, 50, 69, 69, 83, 84, 44, 77, 51, 46,
        53, 46, 48, 47, 51, 44, 77, 49, 48, 46, 53, 46, 48, 47, 52, 10,
    ];
    pub(crate) const AsiaNovokuznetsk: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        64, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 170, 24, 32, 192, 255, 255, 255, 255, 181,
        163, 225, 32, 0, 0, 0, 0, 21, 39, 111, 144, 0, 0, 0, 0, 22, 24, 164, 0, 0, 0, 0, 0, 23, 8,
        163, 16, 0, 0, 0, 0, 23, 249, 215, 128, 0, 0, 0, 0, 24, 233, 214, 144, 0, 0, 0, 0, 25, 219,
        11, 0, 0, 0, 0, 0, 26, 204, 91, 144, 0, 0, 0, 0, 27, 188, 104, 176, 0, 0, 0, 0, 28, 172,
        89, 176, 0, 0, 0, 0, 29, 156, 74, 176, 0, 0, 0, 0, 30, 140, 59, 176, 0, 0, 0, 0, 31, 124,
        44, 176, 0, 0, 0, 0, 32, 108, 29, 176, 0, 0, 0, 0, 33, 92, 14, 176, 0, 0, 0, 0, 34, 75,
        255, 176, 0, 0, 0, 0, 35, 59, 240, 176, 0, 0, 0, 0, 36, 43, 225, 176, 0, 0, 0, 0, 37, 27,
        210, 176, 0, 0, 0, 0, 38, 11, 195, 176, 0, 0, 0, 0, 39, 4, 239, 48, 0, 0, 0, 0, 39, 244,
        224, 48, 0, 0, 0, 0, 40, 228, 223, 64, 0, 0, 0, 0, 41, 120, 135, 64, 0, 0, 0, 0, 41, 212,
        194, 48, 0, 0, 0, 0, 42, 196, 179, 48, 0, 0, 0, 0, 43, 180, 164, 48, 0, 0, 0, 0, 44, 164,
        149, 48, 0, 0, 0, 0, 45, 148, 134, 48, 0, 0, 0, 0, 46, 132, 119, 48, 0, 0, 0, 0, 47, 116,
        104, 48, 0, 0, 0, 0, 48, 100, 89, 48, 0, 0, 0, 0, 49, 93, 132, 176, 0, 0, 0, 0, 50, 114,
        95, 176, 0, 0, 0, 0, 51, 61, 102, 176, 0, 0, 0, 0, 52, 82, 65, 176, 0, 0, 0, 0, 53, 29, 72,
        176, 0, 0, 0, 0, 54, 50, 35, 176, 0, 0, 0, 0, 54, 253, 42, 176, 0, 0, 0, 0, 56, 27, 64, 48,
        0, 0, 0, 0, 56, 221, 12, 176, 0, 0, 0, 0, 57, 251, 34, 48, 0, 0, 0, 0, 58, 188, 238, 176,
        0, 0, 0, 0, 59, 219, 4, 48, 0, 0, 0, 0, 60, 166, 11, 48, 0, 0, 0, 0, 61, 186, 230, 48, 0,
        0, 0, 0, 62, 133, 237, 48, 0, 0, 0, 0, 63, 154, 200, 48, 0, 0, 0, 0, 64, 101, 207, 48, 0,
        0, 0, 0, 65, 131, 228, 176, 0, 0, 0, 0, 66, 69, 177, 48, 0, 0, 0, 0, 67, 99, 198, 176, 0,
        0, 0, 0, 68, 37, 147, 48, 0, 0, 0, 0, 69, 67, 168, 176, 0, 0, 0, 0, 70, 5, 117, 48, 0, 0,
        0, 0, 71, 35, 138, 176, 0, 0, 0, 0, 71, 238, 145, 176, 0, 0, 0, 0, 73, 3, 108, 176, 0, 0,
        0, 0, 73, 206, 115, 176, 0, 0, 0, 0, 74, 227, 78, 176, 0, 0, 0, 0, 75, 174, 85, 176, 0, 0,
        0, 0, 76, 204, 121, 64, 0, 0, 0, 0, 77, 142, 69, 192, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 1, 3, 0, 0, 81, 192, 0, 0, 0,
        0, 84, 96, 0, 4, 0, 0, 112, 128, 1, 8, 0, 0, 98, 112, 0, 12, 0, 0, 98, 112, 1, 12, 76, 77,
        84, 0, 43, 48, 54, 0, 43, 48, 56, 0, 43, 48, 55, 0, 10, 60, 43, 48, 55, 62, 45, 55, 10,
    ];
    pub(crate) const AsiaNovosibirsk: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        67, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 161, 219, 25, 36, 255, 255, 255, 255, 181,
        163, 225, 32, 0, 0, 0, 0, 21, 39, 111, 144, 0, 0, 0, 0, 22, 24, 164, 0, 0, 0, 0, 0, 23, 8,
        163, 16, 0, 0, 0, 0, 23, 249, 215, 128, 0, 0, 0, 0, 24, 233, 214, 144, 0, 0, 0, 0, 25, 219,
        11, 0, 0, 0, 0, 0, 26, 204, 91, 144, 0, 0, 0, 0, 27, 188, 104, 176, 0, 0, 0, 0, 28, 172,
        89, 176, 0, 0, 0, 0, 29, 156, 74, 176, 0, 0, 0, 0, 30, 140, 59, 176, 0, 0, 0, 0, 31, 124,
        44, 176, 0, 0, 0, 0, 32, 108, 29, 176, 0, 0, 0, 0, 33, 92, 14, 176, 0, 0, 0, 0, 34, 75,
        255, 176, 0, 0, 0, 0, 35, 59, 240, 176, 0, 0, 0, 0, 36, 43, 225, 176, 0, 0, 0, 0, 37, 27,
        210, 176, 0, 0, 0, 0, 38, 11, 195, 176, 0, 0, 0, 0, 39, 4, 239, 48, 0, 0, 0, 0, 39, 244,
        224, 48, 0, 0, 0, 0, 40, 228, 223, 64, 0, 0, 0, 0, 41, 120, 135, 64, 0, 0, 0, 0, 41, 212,
        194, 48, 0, 0, 0, 0, 42, 196, 179, 48, 0, 0, 0, 0, 43, 180, 164, 48, 0, 0, 0, 0, 43, 254,
        78, 0, 0, 0, 0, 0, 44, 164, 163, 64, 0, 0, 0, 0, 45, 148, 148, 64, 0, 0, 0, 0, 46, 132,
        133, 64, 0, 0, 0, 0, 47, 116, 118, 64, 0, 0, 0, 0, 48, 100, 103, 64, 0, 0, 0, 0, 49, 93,
        146, 192, 0, 0, 0, 0, 50, 114, 109, 192, 0, 0, 0, 0, 51, 61, 116, 192, 0, 0, 0, 0, 52, 82,
        79, 192, 0, 0, 0, 0, 53, 29, 86, 192, 0, 0, 0, 0, 54, 50, 49, 192, 0, 0, 0, 0, 54, 253, 56,
        192, 0, 0, 0, 0, 56, 27, 78, 64, 0, 0, 0, 0, 56, 221, 26, 192, 0, 0, 0, 0, 57, 251, 48, 64,
        0, 0, 0, 0, 58, 188, 252, 192, 0, 0, 0, 0, 59, 219, 18, 64, 0, 0, 0, 0, 60, 166, 25, 64, 0,
        0, 0, 0, 61, 186, 244, 64, 0, 0, 0, 0, 62, 133, 251, 64, 0, 0, 0, 0, 63, 154, 214, 64, 0,
        0, 0, 0, 64, 101, 221, 64, 0, 0, 0, 0, 65, 131, 242, 192, 0, 0, 0, 0, 66, 69, 191, 64, 0,
        0, 0, 0, 67, 99, 212, 192, 0, 0, 0, 0, 68, 37, 161, 64, 0, 0, 0, 0, 69, 67, 182, 192, 0, 0,
        0, 0, 70, 5, 131, 64, 0, 0, 0, 0, 71, 35, 152, 192, 0, 0, 0, 0, 71, 238, 159, 192, 0, 0, 0,
        0, 73, 3, 122, 192, 0, 0, 0, 0, 73, 206, 129, 192, 0, 0, 0, 0, 74, 227, 92, 192, 0, 0, 0,
        0, 75, 174, 99, 192, 0, 0, 0, 0, 76, 204, 121, 64, 0, 0, 0, 0, 77, 142, 69, 192, 0, 0, 0,
        0, 84, 75, 243, 48, 0, 0, 0, 0, 87, 147, 204, 192, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 1, 3, 2, 3, 2, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4,
        1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 3, 1, 3, 0, 0, 77, 188, 0,
        0, 0, 0, 84, 96, 0, 4, 0, 0, 112, 128, 1, 8, 0, 0, 98, 112, 0, 12, 0, 0, 98, 112, 1, 12,
        76, 77, 84, 0, 43, 48, 54, 0, 43, 48, 56, 0, 43, 48, 55, 0, 10, 60, 43, 48, 55, 62, 45, 55,
        10,
    ];
    pub(crate) const AsiaOmsk: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        65, 0, 0, 0, 6, 0, 0, 0, 16, 255, 255, 255, 255, 161, 179, 64, 182, 255, 255, 255, 255,
        181, 163, 239, 48, 0, 0, 0, 0, 21, 39, 125, 160, 0, 0, 0, 0, 22, 24, 178, 16, 0, 0, 0, 0,
        23, 8, 177, 32, 0, 0, 0, 0, 23, 249, 229, 144, 0, 0, 0, 0, 24, 233, 228, 160, 0, 0, 0, 0,
        25, 219, 25, 16, 0, 0, 0, 0, 26, 204, 105, 160, 0, 0, 0, 0, 27, 188, 118, 192, 0, 0, 0, 0,
        28, 172, 103, 192, 0, 0, 0, 0, 29, 156, 88, 192, 0, 0, 0, 0, 30, 140, 73, 192, 0, 0, 0, 0,
        31, 124, 58, 192, 0, 0, 0, 0, 32, 108, 43, 192, 0, 0, 0, 0, 33, 92, 28, 192, 0, 0, 0, 0,
        34, 76, 13, 192, 0, 0, 0, 0, 35, 59, 254, 192, 0, 0, 0, 0, 36, 43, 239, 192, 0, 0, 0, 0,
        37, 27, 224, 192, 0, 0, 0, 0, 38, 11, 209, 192, 0, 0, 0, 0, 39, 4, 253, 64, 0, 0, 0, 0, 39,
        244, 238, 64, 0, 0, 0, 0, 40, 228, 237, 80, 0, 0, 0, 0, 41, 120, 149, 80, 0, 0, 0, 0, 41,
        212, 208, 64, 0, 0, 0, 0, 42, 196, 193, 64, 0, 0, 0, 0, 43, 180, 178, 64, 0, 0, 0, 0, 44,
        164, 163, 64, 0, 0, 0, 0, 45, 148, 148, 64, 0, 0, 0, 0, 46, 132, 133, 64, 0, 0, 0, 0, 47,
        116, 118, 64, 0, 0, 0, 0, 48, 100, 103, 64, 0, 0, 0, 0, 49, 93, 146, 192, 0, 0, 0, 0, 50,
        114, 109, 192, 0, 0, 0, 0, 51, 61, 116, 192, 0, 0, 0, 0, 52, 82, 79, 192, 0, 0, 0, 0, 53,
        29, 86, 192, 0, 0, 0, 0, 54, 50, 49, 192, 0, 0, 0, 0, 54, 253, 56, 192, 0, 0, 0, 0, 56, 27,
        78, 64, 0, 0, 0, 0, 56, 221, 26, 192, 0, 0, 0, 0, 57, 251, 48, 64, 0, 0, 0, 0, 58, 188,
        252, 192, 0, 0, 0, 0, 59, 219, 18, 64, 0, 0, 0, 0, 60, 166, 25, 64, 0, 0, 0, 0, 61, 186,
        244, 64, 0, 0, 0, 0, 62, 133, 251, 64, 0, 0, 0, 0, 63, 154, 214, 64, 0, 0, 0, 0, 64, 101,
        221, 64, 0, 0, 0, 0, 65, 131, 242, 192, 0, 0, 0, 0, 66, 69, 191, 64, 0, 0, 0, 0, 67, 99,
        212, 192, 0, 0, 0, 0, 68, 37, 161, 64, 0, 0, 0, 0, 69, 67, 182, 192, 0, 0, 0, 0, 70, 5,
        131, 64, 0, 0, 0, 0, 71, 35, 152, 192, 0, 0, 0, 0, 71, 238, 159, 192, 0, 0, 0, 0, 73, 3,
        122, 192, 0, 0, 0, 0, 73, 206, 129, 192, 0, 0, 0, 0, 74, 227, 92, 192, 0, 0, 0, 0, 75, 174,
        99, 192, 0, 0, 0, 0, 76, 204, 121, 64, 0, 0, 0, 0, 77, 142, 69, 192, 0, 0, 0, 0, 84, 75,
        243, 48, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 1, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 5, 3, 0, 0, 68, 202, 0, 0, 0, 0, 70, 80, 0, 4, 0, 0, 98, 112, 1, 8, 0, 0,
        84, 96, 0, 12, 0, 0, 84, 96, 1, 12, 0, 0, 98, 112, 0, 8, 76, 77, 84, 0, 43, 48, 53, 0, 43,
        48, 55, 0, 43, 48, 54, 0, 10, 60, 43, 48, 54, 62, 45, 54, 10,
    ];
    pub(crate) const AsiaOral: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        51, 0, 0, 0, 7, 0, 0, 0, 20, 255, 255, 255, 255, 170, 25, 147, 220, 255, 255, 255, 255,
        181, 164, 11, 80, 0, 0, 0, 0, 21, 39, 139, 176, 0, 0, 0, 0, 22, 24, 192, 32, 0, 0, 0, 0,
        23, 8, 177, 32, 0, 0, 0, 0, 23, 249, 243, 160, 0, 0, 0, 0, 24, 233, 242, 176, 0, 0, 0, 0,
        25, 219, 39, 32, 0, 0, 0, 0, 26, 204, 119, 176, 0, 0, 0, 0, 27, 188, 132, 208, 0, 0, 0, 0,
        28, 172, 117, 208, 0, 0, 0, 0, 29, 156, 102, 208, 0, 0, 0, 0, 30, 140, 87, 208, 0, 0, 0, 0,
        31, 124, 72, 208, 0, 0, 0, 0, 32, 108, 57, 208, 0, 0, 0, 0, 33, 92, 42, 208, 0, 0, 0, 0,
        34, 76, 27, 208, 0, 0, 0, 0, 35, 60, 12, 208, 0, 0, 0, 0, 36, 43, 253, 208, 0, 0, 0, 0, 37,
        27, 252, 224, 0, 0, 0, 0, 38, 11, 237, 224, 0, 0, 0, 0, 39, 5, 25, 96, 0, 0, 0, 0, 39, 245,
        10, 96, 0, 0, 0, 0, 40, 228, 251, 96, 0, 0, 0, 0, 41, 120, 163, 96, 0, 0, 0, 0, 41, 212,
        222, 80, 0, 0, 0, 0, 42, 196, 221, 96, 0, 0, 0, 0, 43, 180, 206, 96, 0, 0, 0, 0, 44, 164,
        191, 96, 0, 0, 0, 0, 45, 148, 176, 96, 0, 0, 0, 0, 46, 132, 161, 96, 0, 0, 0, 0, 47, 116,
        146, 96, 0, 0, 0, 0, 48, 100, 131, 96, 0, 0, 0, 0, 49, 93, 174, 224, 0, 0, 0, 0, 50, 114,
        137, 224, 0, 0, 0, 0, 51, 61, 144, 224, 0, 0, 0, 0, 52, 82, 107, 224, 0, 0, 0, 0, 53, 29,
        114, 224, 0, 0, 0, 0, 54, 50, 77, 224, 0, 0, 0, 0, 54, 253, 84, 224, 0, 0, 0, 0, 56, 27,
        106, 96, 0, 0, 0, 0, 56, 221, 54, 224, 0, 0, 0, 0, 57, 251, 76, 96, 0, 0, 0, 0, 58, 189,
        24, 224, 0, 0, 0, 0, 59, 219, 46, 96, 0, 0, 0, 0, 60, 166, 53, 96, 0, 0, 0, 0, 61, 187, 16,
        96, 0, 0, 0, 0, 62, 134, 23, 96, 0, 0, 0, 0, 63, 154, 242, 96, 0, 0, 0, 0, 64, 101, 249,
        96, 0, 0, 0, 0, 65, 132, 14, 224, 1, 2, 3, 4, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 5,
        6, 5, 6, 5, 6, 2, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6,
        5, 2, 0, 0, 48, 36, 0, 0, 0, 0, 42, 48, 0, 4, 0, 0, 70, 80, 0, 8, 0, 0, 84, 96, 1, 12, 0,
        0, 84, 96, 0, 12, 0, 0, 70, 80, 1, 8, 0, 0, 56, 64, 0, 16, 76, 77, 84, 0, 43, 48, 51, 0,
        43, 48, 53, 0, 43, 48, 54, 0, 43, 48, 52, 0, 10, 60, 43, 48, 53, 62, 45, 53, 10,
    ];
    pub(crate) const AsiaPontianak: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        8, 0, 0, 0, 7, 0, 0, 0, 31, 255, 255, 255, 255, 139, 255, 142, 0, 255, 255, 255, 255, 186,
        22, 223, 0, 255, 255, 255, 255, 203, 121, 164, 8, 255, 255, 255, 255, 210, 86, 238, 112,
        255, 255, 255, 255, 215, 60, 198, 8, 255, 255, 255, 255, 218, 255, 38, 0, 255, 255, 255,
        255, 244, 181, 190, 136, 0, 0, 0, 0, 33, 218, 116, 128, 1, 2, 3, 2, 4, 2, 5, 6, 0, 0, 102,
        128, 0, 0, 0, 0, 102, 128, 0, 4, 0, 0, 105, 120, 0, 8, 0, 0, 126, 144, 0, 14, 0, 0, 112,
        128, 0, 18, 0, 0, 112, 128, 0, 22, 0, 0, 98, 112, 0, 27, 76, 77, 84, 0, 80, 77, 84, 0, 43,
        48, 55, 51, 48, 0, 43, 48, 57, 0, 43, 48, 56, 0, 87, 73, 84, 65, 0, 87, 73, 66, 0, 10, 87,
        73, 66, 45, 55, 10,
    ];
    pub(crate) const AsiaPyongyang: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        5, 0, 0, 0, 4, 0, 0, 0, 12, 255, 255, 255, 255, 139, 215, 241, 156, 255, 255, 255, 255,
        146, 230, 22, 248, 255, 255, 255, 255, 210, 47, 97, 112, 0, 0, 0, 0, 85, 206, 2, 112, 0, 0,
        0, 0, 90, 236, 117, 112, 1, 2, 3, 1, 3, 0, 0, 117, 228, 0, 0, 0, 0, 119, 136, 0, 4, 0, 0,
        126, 144, 0, 8, 0, 0, 126, 144, 0, 4, 76, 77, 84, 0, 75, 83, 84, 0, 74, 83, 84, 0, 10, 75,
        83, 84, 45, 57, 10,
    ];
    pub(crate) const AsiaQostanay: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        51, 0, 0, 0, 6, 0, 0, 0, 16, 255, 255, 255, 255, 170, 25, 136, 92, 255, 255, 255, 255, 181,
        163, 253, 64, 0, 0, 0, 0, 21, 39, 139, 176, 0, 0, 0, 0, 22, 24, 192, 32, 0, 0, 0, 0, 23, 8,
        177, 32, 0, 0, 0, 0, 23, 249, 243, 160, 0, 0, 0, 0, 24, 233, 242, 176, 0, 0, 0, 0, 25, 219,
        39, 32, 0, 0, 0, 0, 26, 204, 119, 176, 0, 0, 0, 0, 27, 188, 132, 208, 0, 0, 0, 0, 28, 172,
        117, 208, 0, 0, 0, 0, 29, 156, 102, 208, 0, 0, 0, 0, 30, 140, 87, 208, 0, 0, 0, 0, 31, 124,
        72, 208, 0, 0, 0, 0, 32, 108, 57, 208, 0, 0, 0, 0, 33, 92, 42, 208, 0, 0, 0, 0, 34, 76, 27,
        208, 0, 0, 0, 0, 35, 60, 12, 208, 0, 0, 0, 0, 36, 43, 253, 208, 0, 0, 0, 0, 37, 27, 238,
        208, 0, 0, 0, 0, 38, 11, 223, 208, 0, 0, 0, 0, 39, 5, 11, 80, 0, 0, 0, 0, 39, 244, 252, 80,
        0, 0, 0, 0, 40, 228, 251, 96, 0, 0, 0, 0, 41, 120, 163, 96, 0, 0, 0, 0, 41, 212, 222, 80,
        0, 0, 0, 0, 42, 196, 207, 80, 0, 0, 0, 0, 43, 180, 192, 80, 0, 0, 0, 0, 44, 164, 177, 80,
        0, 0, 0, 0, 45, 148, 162, 80, 0, 0, 0, 0, 46, 132, 147, 80, 0, 0, 0, 0, 47, 116, 132, 80,
        0, 0, 0, 0, 48, 100, 117, 80, 0, 0, 0, 0, 49, 93, 160, 208, 0, 0, 0, 0, 50, 114, 123, 208,
        0, 0, 0, 0, 51, 61, 130, 208, 0, 0, 0, 0, 52, 82, 93, 208, 0, 0, 0, 0, 53, 29, 100, 208, 0,
        0, 0, 0, 54, 50, 63, 208, 0, 0, 0, 0, 54, 253, 70, 208, 0, 0, 0, 0, 56, 27, 92, 80, 0, 0,
        0, 0, 56, 221, 40, 208, 0, 0, 0, 0, 57, 251, 62, 80, 0, 0, 0, 0, 58, 189, 10, 208, 0, 0, 0,
        0, 59, 219, 32, 80, 0, 0, 0, 0, 60, 166, 39, 80, 0, 0, 0, 0, 61, 187, 2, 80, 0, 0, 0, 0,
        62, 134, 9, 80, 0, 0, 0, 0, 63, 154, 228, 80, 0, 0, 0, 0, 64, 101, 235, 80, 0, 0, 0, 0, 65,
        132, 0, 208, 1, 2, 3, 4, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 5, 1, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 0, 0, 59, 164,
        0, 0, 0, 0, 56, 64, 0, 4, 0, 0, 70, 80, 0, 8, 0, 0, 84, 96, 1, 12, 0, 0, 84, 96, 0, 12, 0,
        0, 70, 80, 1, 8, 76, 77, 84, 0, 43, 48, 52, 0, 43, 48, 53, 0, 43, 48, 54, 0, 10, 60, 43,
        48, 54, 62, 45, 54, 10,
    ];
    pub(crate) const AsiaQyzylorda: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        52, 0, 0, 0, 6, 0, 0, 0, 16, 255, 255, 255, 255, 170, 25, 134, 160, 255, 255, 255, 255,
        181, 163, 253, 64, 0, 0, 0, 0, 21, 39, 139, 176, 0, 0, 0, 0, 22, 24, 192, 32, 0, 0, 0, 0,
        23, 8, 177, 32, 0, 0, 0, 0, 23, 249, 243, 160, 0, 0, 0, 0, 24, 233, 242, 176, 0, 0, 0, 0,
        25, 219, 39, 32, 0, 0, 0, 0, 26, 204, 119, 176, 0, 0, 0, 0, 27, 188, 132, 208, 0, 0, 0, 0,
        28, 172, 117, 208, 0, 0, 0, 0, 29, 156, 102, 208, 0, 0, 0, 0, 30, 140, 87, 208, 0, 0, 0, 0,
        31, 124, 72, 208, 0, 0, 0, 0, 32, 108, 57, 208, 0, 0, 0, 0, 33, 92, 42, 208, 0, 0, 0, 0,
        34, 76, 27, 208, 0, 0, 0, 0, 35, 60, 12, 208, 0, 0, 0, 0, 36, 43, 253, 208, 0, 0, 0, 0, 37,
        27, 238, 208, 0, 0, 0, 0, 38, 11, 223, 208, 0, 0, 0, 0, 39, 5, 11, 80, 0, 0, 0, 0, 39, 244,
        252, 80, 0, 0, 0, 0, 40, 228, 251, 96, 0, 0, 0, 0, 41, 120, 149, 80, 0, 0, 0, 0, 41, 212,
        208, 64, 0, 0, 0, 0, 42, 196, 207, 80, 0, 0, 0, 0, 43, 180, 192, 80, 0, 0, 0, 0, 44, 164,
        177, 80, 0, 0, 0, 0, 45, 148, 162, 80, 0, 0, 0, 0, 46, 132, 147, 80, 0, 0, 0, 0, 47, 116,
        132, 80, 0, 0, 0, 0, 48, 100, 117, 80, 0, 0, 0, 0, 49, 93, 160, 208, 0, 0, 0, 0, 50, 114,
        123, 208, 0, 0, 0, 0, 51, 61, 130, 208, 0, 0, 0, 0, 52, 82, 93, 208, 0, 0, 0, 0, 53, 29,
        100, 208, 0, 0, 0, 0, 54, 50, 63, 208, 0, 0, 0, 0, 54, 253, 70, 208, 0, 0, 0, 0, 56, 27,
        92, 80, 0, 0, 0, 0, 56, 221, 40, 208, 0, 0, 0, 0, 57, 251, 62, 80, 0, 0, 0, 0, 58, 189, 10,
        208, 0, 0, 0, 0, 59, 219, 32, 80, 0, 0, 0, 0, 60, 166, 39, 80, 0, 0, 0, 0, 61, 187, 2, 80,
        0, 0, 0, 0, 62, 134, 9, 80, 0, 0, 0, 0, 63, 154, 228, 80, 0, 0, 0, 0, 64, 101, 235, 80, 0,
        0, 0, 0, 65, 132, 0, 208, 0, 0, 0, 0, 92, 27, 216, 160, 1, 2, 3, 4, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 5, 2, 4, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 4, 2, 0, 0, 61, 96, 0, 0, 0, 0, 56, 64, 0, 4, 0, 0, 70, 80, 0, 8,
        0, 0, 84, 96, 1, 12, 0, 0, 84, 96, 0, 12, 0, 0, 70, 80, 1, 8, 76, 77, 84, 0, 43, 48, 52, 0,
        43, 48, 53, 0, 43, 48, 54, 0, 10, 60, 43, 48, 53, 62, 45, 53, 10,
    ];
    pub(crate) const AsiaRangoon: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        4, 0, 0, 0, 4, 0, 0, 0, 18, 255, 255, 255, 255, 86, 182, 137, 209, 255, 255, 255, 255, 161,
        242, 115, 81, 255, 255, 255, 255, 203, 242, 252, 24, 255, 255, 255, 255, 209, 154, 103,
        240, 1, 2, 3, 2, 0, 0, 90, 47, 0, 0, 0, 0, 90, 47, 0, 4, 0, 0, 91, 104, 0, 8, 0, 0, 126,
        144, 0, 14, 76, 77, 84, 0, 82, 77, 84, 0, 43, 48, 54, 51, 48, 0, 43, 48, 57, 0, 10, 60, 43,
        48, 54, 51, 48, 62, 45, 54, 58, 51, 48, 10,
    ];
    pub(crate) const AsiaSakhalin: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        66, 0, 0, 0, 6, 0, 0, 0, 20, 255, 255, 255, 255, 134, 240, 205, 184, 255, 255, 255, 255,
        210, 48, 178, 240, 0, 0, 0, 0, 21, 39, 55, 80, 0, 0, 0, 0, 22, 24, 107, 192, 0, 0, 0, 0,
        23, 8, 106, 208, 0, 0, 0, 0, 23, 249, 159, 64, 0, 0, 0, 0, 24, 233, 158, 80, 0, 0, 0, 0,
        25, 218, 210, 192, 0, 0, 0, 0, 26, 204, 35, 80, 0, 0, 0, 0, 27, 188, 48, 112, 0, 0, 0, 0,
        28, 172, 33, 112, 0, 0, 0, 0, 29, 156, 18, 112, 0, 0, 0, 0, 30, 140, 3, 112, 0, 0, 0, 0,
        31, 123, 244, 112, 0, 0, 0, 0, 32, 107, 229, 112, 0, 0, 0, 0, 33, 91, 214, 112, 0, 0, 0, 0,
        34, 75, 199, 112, 0, 0, 0, 0, 35, 59, 184, 112, 0, 0, 0, 0, 36, 43, 169, 112, 0, 0, 0, 0,
        37, 27, 154, 112, 0, 0, 0, 0, 38, 11, 139, 112, 0, 0, 0, 0, 39, 4, 182, 240, 0, 0, 0, 0,
        39, 244, 167, 240, 0, 0, 0, 0, 40, 228, 167, 0, 0, 0, 0, 0, 41, 120, 79, 0, 0, 0, 0, 0, 41,
        212, 137, 240, 0, 0, 0, 0, 42, 196, 122, 240, 0, 0, 0, 0, 43, 180, 107, 240, 0, 0, 0, 0,
        44, 164, 92, 240, 0, 0, 0, 0, 45, 148, 77, 240, 0, 0, 0, 0, 46, 132, 62, 240, 0, 0, 0, 0,
        47, 116, 47, 240, 0, 0, 0, 0, 48, 100, 32, 240, 0, 0, 0, 0, 49, 93, 76, 112, 0, 0, 0, 0,
        50, 114, 39, 112, 0, 0, 0, 0, 51, 61, 46, 112, 0, 0, 0, 0, 52, 82, 23, 128, 0, 0, 0, 0, 53,
        29, 30, 128, 0, 0, 0, 0, 54, 49, 249, 128, 0, 0, 0, 0, 54, 253, 0, 128, 0, 0, 0, 0, 56, 27,
        22, 0, 0, 0, 0, 0, 56, 220, 226, 128, 0, 0, 0, 0, 57, 250, 248, 0, 0, 0, 0, 0, 58, 188,
        196, 128, 0, 0, 0, 0, 59, 218, 218, 0, 0, 0, 0, 0, 60, 165, 225, 0, 0, 0, 0, 0, 61, 186,
        188, 0, 0, 0, 0, 0, 62, 133, 195, 0, 0, 0, 0, 0, 63, 154, 158, 0, 0, 0, 0, 0, 64, 101, 165,
        0, 0, 0, 0, 0, 65, 131, 186, 128, 0, 0, 0, 0, 66, 69, 135, 0, 0, 0, 0, 0, 67, 99, 156, 128,
        0, 0, 0, 0, 68, 37, 105, 0, 0, 0, 0, 0, 69, 67, 126, 128, 0, 0, 0, 0, 70, 5, 75, 0, 0, 0,
        0, 0, 71, 35, 96, 128, 0, 0, 0, 0, 71, 238, 103, 128, 0, 0, 0, 0, 73, 3, 66, 128, 0, 0, 0,
        0, 73, 206, 73, 128, 0, 0, 0, 0, 74, 227, 36, 128, 0, 0, 0, 0, 75, 174, 43, 128, 0, 0, 0,
        0, 76, 204, 65, 0, 0, 0, 0, 0, 77, 142, 13, 128, 0, 0, 0, 0, 84, 75, 186, 240, 0, 0, 0, 0,
        86, 246, 178, 0, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 5, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5,
        4, 5, 4, 5, 4, 5, 4, 5, 3, 5, 3, 0, 0, 133, 200, 0, 0, 0, 0, 126, 144, 0, 4, 0, 0, 168,
        192, 1, 8, 0, 0, 154, 176, 0, 12, 0, 0, 154, 176, 1, 12, 0, 0, 140, 160, 0, 16, 76, 77, 84,
        0, 43, 48, 57, 0, 43, 49, 50, 0, 43, 49, 49, 0, 43, 49, 48, 0, 10, 60, 43, 49, 49, 62, 45,
        49, 49, 10,
    ];
    pub(crate) const AsiaSamarkand: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        24, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 170, 25, 133, 55, 255, 255, 255, 255, 181,
        163, 253, 64, 0, 0, 0, 0, 21, 39, 139, 176, 0, 0, 0, 0, 22, 24, 192, 32, 0, 0, 0, 0, 23, 8,
        177, 32, 0, 0, 0, 0, 23, 249, 243, 160, 0, 0, 0, 0, 24, 233, 242, 176, 0, 0, 0, 0, 25, 219,
        39, 32, 0, 0, 0, 0, 26, 204, 119, 176, 0, 0, 0, 0, 27, 188, 132, 208, 0, 0, 0, 0, 28, 172,
        117, 208, 0, 0, 0, 0, 29, 156, 102, 208, 0, 0, 0, 0, 30, 140, 87, 208, 0, 0, 0, 0, 31, 124,
        72, 208, 0, 0, 0, 0, 32, 108, 57, 208, 0, 0, 0, 0, 33, 92, 42, 208, 0, 0, 0, 0, 34, 76, 27,
        208, 0, 0, 0, 0, 35, 60, 12, 208, 0, 0, 0, 0, 36, 43, 253, 208, 0, 0, 0, 0, 37, 27, 238,
        208, 0, 0, 0, 0, 38, 11, 223, 208, 0, 0, 0, 0, 39, 5, 11, 80, 0, 0, 0, 0, 39, 244, 252, 80,
        0, 0, 0, 0, 40, 228, 237, 80, 1, 2, 3, 4, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 0, 0, 62, 201, 0, 0, 0, 0, 56, 64, 0, 4, 0, 0, 70, 80, 0, 8, 0, 0, 84, 96, 1,
        12, 0, 0, 84, 96, 0, 12, 76, 77, 84, 0, 43, 48, 52, 0, 43, 48, 53, 0, 43, 48, 54, 0, 10,
        60, 43, 48, 53, 62, 45, 53, 10,
    ];
    pub(crate) const AsiaSeoul: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        29, 0, 0, 0, 6, 0, 0, 0, 16, 255, 255, 255, 255, 139, 215, 240, 120, 255, 255, 255, 255,
        146, 230, 22, 248, 255, 255, 255, 255, 210, 67, 39, 240, 255, 255, 255, 255, 215, 101, 143,
        112, 255, 255, 255, 255, 215, 238, 157, 96, 255, 255, 255, 255, 216, 248, 250, 112, 255,
        255, 255, 255, 217, 205, 45, 224, 255, 255, 255, 255, 218, 215, 138, 240, 255, 255, 255,
        255, 219, 173, 15, 224, 255, 255, 255, 255, 220, 230, 226, 240, 255, 255, 255, 255, 221,
        140, 241, 224, 255, 255, 255, 255, 226, 79, 41, 240, 255, 255, 255, 255, 228, 107, 183,
        248, 255, 255, 255, 255, 229, 19, 24, 104, 255, 255, 255, 255, 230, 98, 3, 120, 255, 255,
        255, 255, 231, 17, 76, 232, 255, 255, 255, 255, 232, 47, 112, 120, 255, 255, 255, 255, 232,
        231, 244, 104, 255, 255, 255, 255, 234, 15, 82, 120, 255, 255, 255, 255, 234, 199, 214,
        104, 255, 255, 255, 255, 235, 239, 52, 120, 255, 255, 255, 255, 236, 167, 184, 104, 255,
        255, 255, 255, 237, 207, 22, 120, 255, 255, 255, 255, 238, 135, 154, 104, 255, 255, 255,
        255, 240, 53, 113, 120, 0, 0, 0, 0, 32, 163, 96, 144, 0, 0, 0, 0, 33, 110, 103, 144, 0, 0,
        0, 0, 34, 131, 66, 144, 0, 0, 0, 0, 35, 78, 73, 144, 1, 2, 4, 3, 4, 3, 4, 3, 4, 3, 4, 1, 5,
        1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 4, 3, 4, 3, 4, 0, 0, 119, 8, 0, 0, 0, 0, 119, 136, 0, 4,
        0, 0, 126, 144, 0, 8, 0, 0, 140, 160, 1, 12, 0, 0, 126, 144, 0, 4, 0, 0, 133, 152, 1, 12,
        76, 77, 84, 0, 75, 83, 84, 0, 74, 83, 84, 0, 75, 68, 84, 0, 10, 75, 83, 84, 45, 57, 10,
    ];
    pub(crate) const AsiaSingapore: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        8, 0, 0, 0, 8, 0, 0, 0, 32, 255, 255, 255, 255, 126, 54, 83, 163, 255, 255, 255, 255, 134,
        131, 133, 163, 255, 255, 255, 255, 186, 103, 78, 144, 255, 255, 255, 255, 192, 10, 228, 96,
        255, 255, 255, 255, 202, 179, 229, 96, 255, 255, 255, 255, 203, 145, 95, 8, 255, 255, 255,
        255, 210, 72, 109, 240, 0, 0, 0, 0, 22, 145, 245, 8, 1, 2, 3, 4, 5, 6, 5, 7, 0, 0, 97, 93,
        0, 0, 0, 0, 97, 93, 0, 4, 0, 0, 98, 112, 0, 8, 0, 0, 103, 32, 1, 12, 0, 0, 103, 32, 0, 12,
        0, 0, 105, 120, 0, 18, 0, 0, 126, 144, 0, 24, 0, 0, 112, 128, 0, 28, 76, 77, 84, 0, 83, 77,
        84, 0, 43, 48, 55, 0, 43, 48, 55, 50, 48, 0, 43, 48, 55, 51, 48, 0, 43, 48, 57, 0, 43, 48,
        56, 0, 10, 60, 43, 48, 56, 62, 45, 56, 10,
    ];
    pub(crate) const AsiaSrednekolymsk: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        65, 0, 0, 0, 6, 0, 0, 0, 16, 255, 255, 255, 255, 170, 25, 51, 228, 255, 255, 255, 255, 181,
        163, 168, 224, 0, 0, 0, 0, 21, 39, 55, 80, 0, 0, 0, 0, 22, 24, 107, 192, 0, 0, 0, 0, 23, 8,
        106, 208, 0, 0, 0, 0, 23, 249, 159, 64, 0, 0, 0, 0, 24, 233, 158, 80, 0, 0, 0, 0, 25, 218,
        210, 192, 0, 0, 0, 0, 26, 204, 35, 80, 0, 0, 0, 0, 27, 188, 48, 112, 0, 0, 0, 0, 28, 172,
        33, 112, 0, 0, 0, 0, 29, 156, 18, 112, 0, 0, 0, 0, 30, 140, 3, 112, 0, 0, 0, 0, 31, 123,
        244, 112, 0, 0, 0, 0, 32, 107, 229, 112, 0, 0, 0, 0, 33, 91, 214, 112, 0, 0, 0, 0, 34, 75,
        199, 112, 0, 0, 0, 0, 35, 59, 184, 112, 0, 0, 0, 0, 36, 43, 169, 112, 0, 0, 0, 0, 37, 27,
        154, 112, 0, 0, 0, 0, 38, 11, 139, 112, 0, 0, 0, 0, 39, 4, 182, 240, 0, 0, 0, 0, 39, 244,
        167, 240, 0, 0, 0, 0, 40, 228, 167, 0, 0, 0, 0, 0, 41, 120, 79, 0, 0, 0, 0, 0, 41, 212,
        137, 240, 0, 0, 0, 0, 42, 196, 122, 240, 0, 0, 0, 0, 43, 180, 107, 240, 0, 0, 0, 0, 44,
        164, 92, 240, 0, 0, 0, 0, 45, 148, 77, 240, 0, 0, 0, 0, 46, 132, 62, 240, 0, 0, 0, 0, 47,
        116, 47, 240, 0, 0, 0, 0, 48, 100, 32, 240, 0, 0, 0, 0, 49, 93, 76, 112, 0, 0, 0, 0, 50,
        114, 39, 112, 0, 0, 0, 0, 51, 61, 46, 112, 0, 0, 0, 0, 52, 82, 9, 112, 0, 0, 0, 0, 53, 29,
        16, 112, 0, 0, 0, 0, 54, 49, 235, 112, 0, 0, 0, 0, 54, 252, 242, 112, 0, 0, 0, 0, 56, 27,
        7, 240, 0, 0, 0, 0, 56, 220, 212, 112, 0, 0, 0, 0, 57, 250, 233, 240, 0, 0, 0, 0, 58, 188,
        182, 112, 0, 0, 0, 0, 59, 218, 203, 240, 0, 0, 0, 0, 60, 165, 210, 240, 0, 0, 0, 0, 61,
        186, 173, 240, 0, 0, 0, 0, 62, 133, 180, 240, 0, 0, 0, 0, 63, 154, 143, 240, 0, 0, 0, 0,
        64, 101, 150, 240, 0, 0, 0, 0, 65, 131, 172, 112, 0, 0, 0, 0, 66, 69, 120, 240, 0, 0, 0, 0,
        67, 99, 142, 112, 0, 0, 0, 0, 68, 37, 90, 240, 0, 0, 0, 0, 69, 67, 112, 112, 0, 0, 0, 0,
        70, 5, 60, 240, 0, 0, 0, 0, 71, 35, 82, 112, 0, 0, 0, 0, 71, 238, 89, 112, 0, 0, 0, 0, 73,
        3, 52, 112, 0, 0, 0, 0, 73, 206, 59, 112, 0, 0, 0, 0, 74, 227, 22, 112, 0, 0, 0, 0, 75,
        174, 29, 112, 0, 0, 0, 0, 76, 204, 50, 240, 0, 0, 0, 0, 77, 141, 255, 112, 0, 0, 0, 0, 84,
        75, 172, 224, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 1, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 5, 3, 0, 0, 144, 28, 0, 0, 0, 0, 140, 160, 0, 4, 0, 0, 168, 192, 1, 8,
        0, 0, 154, 176, 0, 12, 0, 0, 154, 176, 1, 12, 0, 0, 168, 192, 0, 8, 76, 77, 84, 0, 43, 49,
        48, 0, 43, 49, 50, 0, 43, 49, 49, 0, 10, 60, 43, 49, 49, 62, 45, 49, 49, 10,
    ];
    pub(crate) const AsiaTaipei: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        41, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 116, 206, 240, 24, 255, 255, 255, 255,
        195, 85, 73, 128, 255, 255, 255, 255, 210, 84, 89, 128, 255, 255, 255, 255, 211, 139, 123,
        128, 255, 255, 255, 255, 212, 66, 173, 240, 255, 255, 255, 255, 213, 69, 34, 0, 255, 255,
        255, 255, 214, 76, 191, 240, 255, 255, 255, 255, 215, 60, 191, 0, 255, 255, 255, 255, 216,
        6, 102, 112, 255, 255, 255, 255, 217, 29, 242, 128, 255, 255, 255, 255, 217, 231, 153, 240,
        255, 255, 255, 255, 218, 255, 38, 0, 255, 255, 255, 255, 219, 200, 205, 112, 255, 255, 255,
        255, 220, 224, 89, 128, 255, 255, 255, 255, 221, 170, 0, 240, 255, 255, 255, 255, 222, 114,
        115, 0, 255, 255, 255, 255, 223, 181, 100, 112, 255, 255, 255, 255, 224, 124, 133, 0, 255,
        255, 255, 255, 225, 150, 151, 240, 255, 255, 255, 255, 226, 93, 184, 128, 255, 255, 255,
        255, 227, 119, 203, 112, 255, 255, 255, 255, 228, 62, 236, 0, 255, 255, 255, 255, 229, 48,
        32, 112, 255, 255, 255, 255, 230, 33, 113, 0, 255, 255, 255, 255, 231, 18, 165, 112, 255,
        255, 255, 255, 232, 2, 164, 128, 255, 255, 255, 255, 232, 243, 216, 240, 255, 255, 255,
        255, 233, 227, 216, 0, 255, 255, 255, 255, 234, 213, 12, 112, 255, 255, 255, 255, 235, 197,
        11, 128, 255, 255, 255, 255, 236, 182, 63, 240, 255, 255, 255, 255, 237, 247, 252, 0, 255,
        255, 255, 255, 238, 152, 196, 240, 255, 255, 255, 255, 239, 217, 47, 128, 255, 255, 255,
        255, 240, 121, 248, 112, 0, 0, 0, 0, 7, 252, 86, 0, 0, 0, 0, 0, 8, 237, 138, 112, 0, 0, 0,
        0, 9, 221, 137, 128, 0, 0, 0, 0, 10, 206, 189, 240, 0, 0, 0, 0, 17, 219, 161, 128, 0, 0, 0,
        0, 18, 84, 221, 112, 1, 2, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1,
        3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 0, 0, 113, 232, 0, 0, 0, 0, 112, 128,
        0, 4, 0, 0, 126, 144, 0, 8, 0, 0, 126, 144, 1, 12, 76, 77, 84, 0, 67, 83, 84, 0, 74, 83,
        84, 0, 67, 68, 84, 0, 10, 67, 83, 84, 45, 56, 10,
    ];
    pub(crate) const AsiaTashkent: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        24, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 170, 25, 131, 9, 255, 255, 255, 255, 181,
        163, 239, 48, 0, 0, 0, 0, 21, 39, 125, 160, 0, 0, 0, 0, 22, 24, 178, 16, 0, 0, 0, 0, 23, 8,
        177, 32, 0, 0, 0, 0, 23, 249, 229, 144, 0, 0, 0, 0, 24, 233, 228, 160, 0, 0, 0, 0, 25, 219,
        25, 16, 0, 0, 0, 0, 26, 204, 105, 160, 0, 0, 0, 0, 27, 188, 118, 192, 0, 0, 0, 0, 28, 172,
        103, 192, 0, 0, 0, 0, 29, 156, 88, 192, 0, 0, 0, 0, 30, 140, 73, 192, 0, 0, 0, 0, 31, 124,
        58, 192, 0, 0, 0, 0, 32, 108, 43, 192, 0, 0, 0, 0, 33, 92, 28, 192, 0, 0, 0, 0, 34, 76, 13,
        192, 0, 0, 0, 0, 35, 59, 254, 192, 0, 0, 0, 0, 36, 43, 239, 192, 0, 0, 0, 0, 37, 27, 224,
        192, 0, 0, 0, 0, 38, 11, 209, 192, 0, 0, 0, 0, 39, 4, 253, 64, 0, 0, 0, 0, 39, 244, 238,
        64, 0, 0, 0, 0, 40, 228, 237, 80, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 4, 1, 0, 0, 64, 247, 0, 0, 0, 0, 70, 80, 0, 4, 0, 0, 98, 112, 1, 8, 0, 0, 84, 96,
        0, 12, 0, 0, 84, 96, 1, 12, 76, 77, 84, 0, 43, 48, 53, 0, 43, 48, 55, 0, 43, 48, 54, 0, 10,
        60, 43, 48, 53, 62, 45, 53, 10,
    ];
    pub(crate) const AsiaTbilisi: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        52, 0, 0, 0, 6, 0, 0, 0, 21, 255, 255, 255, 255, 86, 182, 186, 1, 255, 255, 255, 255, 170,
        25, 154, 1, 255, 255, 255, 255, 231, 218, 12, 80, 0, 0, 0, 0, 21, 39, 153, 192, 0, 0, 0, 0,
        22, 24, 206, 48, 0, 0, 0, 0, 23, 8, 205, 64, 0, 0, 0, 0, 23, 250, 1, 176, 0, 0, 0, 0, 24,
        234, 0, 192, 0, 0, 0, 0, 25, 219, 53, 48, 0, 0, 0, 0, 26, 204, 133, 192, 0, 0, 0, 0, 27,
        188, 146, 224, 0, 0, 0, 0, 28, 172, 131, 224, 0, 0, 0, 0, 29, 156, 116, 224, 0, 0, 0, 0,
        30, 140, 101, 224, 0, 0, 0, 0, 31, 124, 86, 224, 0, 0, 0, 0, 32, 108, 71, 224, 0, 0, 0, 0,
        33, 92, 56, 224, 0, 0, 0, 0, 34, 76, 41, 224, 0, 0, 0, 0, 35, 60, 26, 224, 0, 0, 0, 0, 36,
        44, 11, 224, 0, 0, 0, 0, 37, 27, 252, 224, 0, 0, 0, 0, 38, 11, 237, 224, 0, 0, 0, 0, 39, 5,
        25, 96, 0, 0, 0, 0, 39, 245, 10, 96, 0, 0, 0, 0, 40, 229, 9, 112, 0, 0, 0, 0, 41, 212, 222,
        80, 0, 0, 0, 0, 42, 196, 193, 64, 0, 0, 0, 0, 43, 180, 192, 80, 0, 0, 0, 0, 44, 164, 163,
        64, 0, 0, 0, 0, 45, 148, 162, 80, 0, 0, 0, 0, 46, 132, 133, 64, 0, 0, 0, 0, 47, 116, 118,
        64, 0, 0, 0, 0, 48, 100, 89, 48, 0, 0, 0, 0, 49, 93, 146, 192, 0, 0, 0, 0, 51, 61, 102,
        176, 0, 0, 0, 0, 52, 82, 65, 176, 0, 0, 0, 0, 53, 29, 86, 192, 0, 0, 0, 0, 54, 50, 35, 176,
        0, 0, 0, 0, 54, 253, 56, 192, 0, 0, 0, 0, 56, 27, 64, 48, 0, 0, 0, 0, 56, 221, 26, 192, 0,
        0, 0, 0, 57, 251, 34, 48, 0, 0, 0, 0, 58, 188, 252, 192, 0, 0, 0, 0, 59, 219, 4, 48, 0, 0,
        0, 0, 60, 166, 25, 64, 0, 0, 0, 0, 61, 186, 230, 48, 0, 0, 0, 0, 62, 133, 251, 64, 0, 0, 0,
        0, 63, 154, 200, 48, 0, 0, 0, 0, 64, 101, 221, 64, 0, 0, 0, 0, 64, 221, 199, 176, 0, 0, 0,
        0, 65, 132, 28, 240, 0, 0, 0, 0, 66, 69, 233, 112, 1, 2, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4,
        3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 5, 2, 5, 2, 5, 2, 5, 4, 3, 4, 3, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 5, 2, 4, 0, 0, 41, 255, 0, 0, 0, 0, 41, 255, 0, 4, 0, 0, 42, 48, 0, 9, 0,
        0, 70, 80, 1, 13, 0, 0, 56, 64, 0, 17, 0, 0, 56, 64, 1, 17, 76, 77, 84, 0, 84, 66, 77, 84,
        0, 43, 48, 51, 0, 43, 48, 53, 0, 43, 48, 52, 0, 10, 60, 43, 48, 52, 62, 45, 52, 10,
    ];
    pub(crate) const AsiaTehran: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        201, 0, 0, 0, 6, 0, 0, 0, 28, 255, 255, 255, 255, 154, 108, 125, 200, 255, 255, 255, 255,
        210, 219, 18, 200, 0, 0, 0, 0, 14, 187, 162, 72, 0, 0, 0, 0, 15, 116, 45, 64, 0, 0, 0, 0,
        16, 142, 64, 48, 0, 0, 0, 0, 16, 237, 58, 64, 0, 0, 0, 0, 17, 85, 103, 200, 0, 0, 0, 0, 18,
        69, 74, 184, 0, 0, 0, 0, 19, 55, 236, 200, 0, 0, 0, 0, 20, 45, 21, 184, 0, 0, 0, 0, 40, 32,
        118, 200, 0, 0, 0, 0, 40, 219, 157, 184, 0, 0, 0, 0, 41, 203, 156, 200, 0, 0, 0, 0, 42,
        190, 34, 184, 0, 0, 0, 0, 43, 172, 208, 72, 0, 0, 0, 0, 44, 159, 86, 56, 0, 0, 0, 0, 45,
        142, 3, 200, 0, 0, 0, 0, 46, 128, 137, 184, 0, 0, 0, 0, 47, 111, 55, 72, 0, 0, 0, 0, 48,
        97, 189, 56, 0, 0, 0, 0, 49, 80, 106, 200, 0, 0, 0, 0, 50, 66, 240, 184, 0, 0, 0, 0, 51,
        50, 239, 200, 0, 0, 0, 0, 52, 37, 117, 184, 0, 0, 0, 0, 53, 20, 35, 72, 0, 0, 0, 0, 54, 6,
        169, 56, 0, 0, 0, 0, 54, 245, 86, 200, 0, 0, 0, 0, 55, 231, 220, 184, 0, 0, 0, 0, 56, 214,
        138, 72, 0, 0, 0, 0, 57, 201, 16, 56, 0, 0, 0, 0, 58, 185, 15, 72, 0, 0, 0, 0, 59, 171,
        149, 56, 0, 0, 0, 0, 60, 154, 66, 200, 0, 0, 0, 0, 61, 140, 200, 184, 0, 0, 0, 0, 62, 123,
        118, 72, 0, 0, 0, 0, 63, 109, 252, 56, 0, 0, 0, 0, 64, 92, 169, 200, 0, 0, 0, 0, 65, 79,
        47, 184, 0, 0, 0, 0, 66, 63, 46, 200, 0, 0, 0, 0, 67, 49, 180, 184, 0, 0, 0, 0, 71, 226,
        201, 72, 0, 0, 0, 0, 72, 213, 79, 56, 0, 0, 0, 0, 73, 197, 78, 72, 0, 0, 0, 0, 74, 183,
        212, 56, 0, 0, 0, 0, 75, 166, 129, 200, 0, 0, 0, 0, 76, 153, 7, 184, 0, 0, 0, 0, 77, 135,
        181, 72, 0, 0, 0, 0, 78, 122, 59, 56, 0, 0, 0, 0, 79, 104, 232, 200, 0, 0, 0, 0, 80, 91,
        110, 184, 0, 0, 0, 0, 81, 75, 109, 200, 0, 0, 0, 0, 82, 61, 243, 184, 0, 0, 0, 0, 83, 44,
        161, 72, 0, 0, 0, 0, 84, 31, 39, 56, 0, 0, 0, 0, 85, 13, 212, 200, 0, 0, 0, 0, 86, 0, 90,
        184, 0, 0, 0, 0, 86, 239, 8, 72, 0, 0, 0, 0, 87, 225, 142, 56, 0, 0, 0, 0, 88, 209, 141,
        72, 0, 0, 0, 0, 89, 196, 19, 56, 0, 0, 0, 0, 90, 178, 192, 200, 0, 0, 0, 0, 91, 165, 70,
        184, 0, 0, 0, 0, 92, 147, 244, 72, 0, 0, 0, 0, 93, 134, 122, 56, 0, 0, 0, 0, 94, 117, 39,
        200, 0, 0, 0, 0, 95, 103, 173, 184, 0, 0, 0, 0, 96, 87, 172, 200, 0, 0, 0, 0, 97, 74, 50,
        184, 0, 0, 0, 0, 98, 56, 224, 72, 0, 0, 0, 0, 99, 43, 102, 56, 0, 0, 0, 0, 100, 26, 19,
        200, 0, 0, 0, 0, 101, 12, 153, 184, 0, 0, 0, 0, 101, 251, 71, 72, 0, 0, 0, 0, 102, 237,
        205, 56, 0, 0, 0, 0, 103, 221, 204, 72, 0, 0, 0, 0, 104, 208, 82, 56, 0, 0, 0, 0, 105, 190,
        255, 200, 0, 0, 0, 0, 106, 177, 133, 184, 0, 0, 0, 0, 107, 160, 51, 72, 0, 0, 0, 0, 108,
        146, 185, 56, 0, 0, 0, 0, 109, 129, 102, 200, 0, 0, 0, 0, 110, 115, 236, 184, 0, 0, 0, 0,
        111, 98, 154, 72, 0, 0, 0, 0, 112, 85, 32, 56, 0, 0, 0, 0, 113, 69, 31, 72, 0, 0, 0, 0,
        114, 55, 165, 56, 0, 0, 0, 0, 115, 38, 82, 200, 0, 0, 0, 0, 116, 24, 216, 184, 0, 0, 0, 0,
        117, 7, 134, 72, 0, 0, 0, 0, 117, 250, 12, 56, 0, 0, 0, 0, 118, 232, 185, 200, 0, 0, 0, 0,
        119, 219, 63, 184, 0, 0, 0, 0, 120, 203, 62, 200, 0, 0, 0, 0, 121, 189, 196, 184, 0, 0, 0,
        0, 122, 172, 114, 72, 0, 0, 0, 0, 123, 158, 248, 56, 0, 0, 0, 0, 124, 141, 165, 200, 0, 0,
        0, 0, 125, 128, 43, 184, 0, 0, 0, 0, 126, 110, 217, 72, 0, 0, 0, 0, 127, 97, 95, 56, 0, 0,
        0, 0, 128, 81, 94, 72, 0, 0, 0, 0, 129, 67, 228, 56, 0, 0, 0, 0, 130, 50, 145, 200, 0, 0,
        0, 0, 131, 37, 23, 184, 0, 0, 0, 0, 132, 19, 197, 72, 0, 0, 0, 0, 133, 6, 75, 56, 0, 0, 0,
        0, 133, 244, 248, 200, 0, 0, 0, 0, 134, 231, 126, 184, 0, 0, 0, 0, 135, 215, 125, 200, 0,
        0, 0, 0, 136, 202, 3, 184, 0, 0, 0, 0, 137, 184, 177, 72, 0, 0, 0, 0, 138, 171, 55, 56, 0,
        0, 0, 0, 139, 153, 228, 200, 0, 0, 0, 0, 140, 140, 106, 184, 0, 0, 0, 0, 141, 123, 24, 72,
        0, 0, 0, 0, 142, 109, 158, 56, 0, 0, 0, 0, 143, 93, 157, 72, 0, 0, 0, 0, 144, 80, 35, 56,
        0, 0, 0, 0, 145, 62, 208, 200, 0, 0, 0, 0, 146, 49, 86, 184, 0, 0, 0, 0, 147, 32, 4, 72, 0,
        0, 0, 0, 148, 18, 138, 56, 0, 0, 0, 0, 149, 1, 55, 200, 0, 0, 0, 0, 149, 243, 189, 184, 0,
        0, 0, 0, 150, 227, 188, 200, 0, 0, 0, 0, 151, 214, 66, 184, 0, 0, 0, 0, 152, 196, 240, 72,
        0, 0, 0, 0, 153, 183, 118, 56, 0, 0, 0, 0, 154, 166, 35, 200, 0, 0, 0, 0, 155, 152, 169,
        184, 0, 0, 0, 0, 156, 135, 87, 72, 0, 0, 0, 0, 157, 121, 221, 56, 0, 0, 0, 0, 158, 105,
        220, 72, 0, 0, 0, 0, 159, 92, 98, 56, 0, 0, 0, 0, 160, 75, 15, 200, 0, 0, 0, 0, 161, 61,
        149, 184, 0, 0, 0, 0, 162, 44, 67, 72, 0, 0, 0, 0, 163, 30, 201, 56, 0, 0, 0, 0, 164, 13,
        118, 200, 0, 0, 0, 0, 164, 255, 252, 184, 0, 0, 0, 0, 165, 239, 251, 200, 0, 0, 0, 0, 166,
        226, 129, 184, 0, 0, 0, 0, 167, 209, 47, 72, 0, 0, 0, 0, 168, 195, 181, 56, 0, 0, 0, 0,
        169, 178, 98, 200, 0, 0, 0, 0, 170, 164, 232, 184, 0, 0, 0, 0, 171, 147, 150, 72, 0, 0, 0,
        0, 172, 134, 28, 56, 0, 0, 0, 0, 173, 116, 201, 200, 0, 0, 0, 0, 174, 103, 79, 184, 0, 0,
        0, 0, 175, 87, 78, 200, 0, 0, 0, 0, 176, 73, 212, 184, 0, 0, 0, 0, 177, 56, 130, 72, 0, 0,
        0, 0, 178, 43, 8, 56, 0, 0, 0, 0, 179, 25, 181, 200, 0, 0, 0, 0, 180, 12, 59, 184, 0, 0, 0,
        0, 180, 250, 233, 72, 0, 0, 0, 0, 181, 237, 111, 56, 0, 0, 0, 0, 182, 221, 110, 72, 0, 0,
        0, 0, 183, 207, 244, 56, 0, 0, 0, 0, 184, 190, 161, 200, 0, 0, 0, 0, 185, 177, 39, 184, 0,
        0, 0, 0, 186, 159, 213, 72, 0, 0, 0, 0, 187, 146, 91, 56, 0, 0, 0, 0, 188, 129, 8, 200, 0,
        0, 0, 0, 189, 115, 142, 184, 0, 0, 0, 0, 190, 99, 141, 200, 0, 0, 0, 0, 191, 86, 19, 184,
        0, 0, 0, 0, 192, 68, 193, 72, 0, 0, 0, 0, 193, 55, 71, 56, 0, 0, 0, 0, 194, 37, 244, 200,
        0, 0, 0, 0, 195, 24, 122, 184, 0, 0, 0, 0, 196, 7, 40, 72, 0, 0, 0, 0, 196, 249, 174, 56,
        0, 0, 0, 0, 197, 233, 173, 72, 0, 0, 0, 0, 198, 220, 51, 56, 0, 0, 0, 0, 199, 202, 224,
        200, 0, 0, 0, 0, 200, 189, 102, 184, 0, 0, 0, 0, 201, 172, 20, 72, 0, 0, 0, 0, 202, 158,
        154, 56, 0, 0, 0, 0, 203, 141, 71, 200, 0, 0, 0, 0, 204, 127, 205, 184, 0, 0, 0, 0, 205,
        111, 204, 200, 0, 0, 0, 0, 206, 98, 82, 184, 0, 0, 0, 0, 207, 81, 0, 72, 0, 0, 0, 0, 208,
        67, 134, 56, 0, 0, 0, 0, 209, 50, 51, 200, 0, 0, 0, 0, 210, 36, 185, 184, 0, 0, 0, 0, 211,
        19, 103, 72, 0, 0, 0, 0, 212, 5, 237, 56, 0, 0, 0, 0, 212, 245, 236, 72, 0, 0, 0, 0, 213,
        232, 114, 56, 0, 0, 0, 0, 214, 215, 31, 200, 0, 0, 0, 0, 215, 201, 165, 184, 0, 0, 0, 0,
        216, 184, 83, 72, 0, 0, 0, 0, 217, 170, 217, 56, 0, 0, 0, 0, 218, 153, 134, 200, 0, 0, 0,
        0, 219, 140, 12, 184, 0, 0, 0, 0, 220, 124, 11, 200, 0, 0, 0, 0, 221, 110, 145, 184, 0, 0,
        0, 0, 222, 93, 63, 72, 1, 2, 4, 3, 4, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5,
        2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5,
        2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5,
        2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5,
        2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5,
        2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5,
        2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 0, 0,
        48, 56, 0, 0, 0, 0, 48, 56, 0, 4, 0, 0, 49, 56, 0, 8, 0, 0, 70, 80, 1, 14, 0, 0, 56, 64, 0,
        18, 0, 0, 63, 72, 1, 22, 76, 77, 84, 0, 84, 77, 84, 0, 43, 48, 51, 51, 48, 0, 43, 48, 53,
        0, 43, 48, 52, 0, 43, 48, 52, 51, 48, 0, 10, 60, 43, 48, 51, 51, 48, 62, 45, 51, 58, 51,
        48, 60, 43, 48, 52, 51, 48, 62, 44, 74, 55, 57, 47, 50, 52, 44, 74, 50, 54, 51, 47, 50, 52,
        10,
    ];
    pub(crate) const AsiaThimbu: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        2, 0, 0, 0, 3, 0, 0, 0, 14, 255, 255, 255, 255, 213, 230, 21, 116, 0, 0, 0, 0, 33, 97, 77,
        168, 1, 2, 0, 0, 84, 12, 0, 0, 0, 0, 77, 88, 0, 4, 0, 0, 84, 96, 0, 10, 76, 77, 84, 0, 43,
        48, 53, 51, 48, 0, 43, 48, 54, 0, 10, 60, 43, 48, 54, 62, 45, 54, 10,
    ];
    pub(crate) const AsiaTokyo: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        9, 0, 0, 0, 3, 0, 0, 0, 12, 255, 255, 255, 255, 101, 194, 164, 112, 255, 255, 255, 255,
        215, 62, 2, 112, 255, 255, 255, 255, 215, 237, 89, 240, 255, 255, 255, 255, 216, 248, 250,
        112, 255, 255, 255, 255, 217, 205, 59, 240, 255, 255, 255, 255, 219, 7, 0, 240, 255, 255,
        255, 255, 219, 173, 29, 240, 255, 255, 255, 255, 220, 230, 226, 240, 255, 255, 255, 255,
        221, 140, 255, 240, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 0, 131, 3, 0, 0, 0, 0, 140, 160, 1, 4, 0,
        0, 126, 144, 0, 8, 76, 77, 84, 0, 74, 68, 84, 0, 74, 83, 84, 0, 10, 74, 83, 84, 45, 57, 10,
    ];
    pub(crate) const AsiaTomsk: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        67, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 161, 229, 78, 217, 255, 255, 255, 255,
        181, 163, 225, 32, 0, 0, 0, 0, 21, 39, 111, 144, 0, 0, 0, 0, 22, 24, 164, 0, 0, 0, 0, 0,
        23, 8, 163, 16, 0, 0, 0, 0, 23, 249, 215, 128, 0, 0, 0, 0, 24, 233, 214, 144, 0, 0, 0, 0,
        25, 219, 11, 0, 0, 0, 0, 0, 26, 204, 91, 144, 0, 0, 0, 0, 27, 188, 104, 176, 0, 0, 0, 0,
        28, 172, 89, 176, 0, 0, 0, 0, 29, 156, 74, 176, 0, 0, 0, 0, 30, 140, 59, 176, 0, 0, 0, 0,
        31, 124, 44, 176, 0, 0, 0, 0, 32, 108, 29, 176, 0, 0, 0, 0, 33, 92, 14, 176, 0, 0, 0, 0,
        34, 75, 255, 176, 0, 0, 0, 0, 35, 59, 240, 176, 0, 0, 0, 0, 36, 43, 225, 176, 0, 0, 0, 0,
        37, 27, 210, 176, 0, 0, 0, 0, 38, 11, 195, 176, 0, 0, 0, 0, 39, 4, 239, 48, 0, 0, 0, 0, 39,
        244, 224, 48, 0, 0, 0, 0, 40, 228, 223, 64, 0, 0, 0, 0, 41, 120, 135, 64, 0, 0, 0, 0, 41,
        212, 194, 48, 0, 0, 0, 0, 42, 196, 179, 48, 0, 0, 0, 0, 43, 180, 164, 48, 0, 0, 0, 0, 44,
        164, 149, 48, 0, 0, 0, 0, 45, 148, 134, 48, 0, 0, 0, 0, 46, 132, 119, 48, 0, 0, 0, 0, 47,
        116, 104, 48, 0, 0, 0, 0, 48, 100, 89, 48, 0, 0, 0, 0, 49, 93, 132, 176, 0, 0, 0, 0, 50,
        114, 95, 176, 0, 0, 0, 0, 51, 61, 102, 176, 0, 0, 0, 0, 52, 82, 65, 176, 0, 0, 0, 0, 53,
        29, 72, 176, 0, 0, 0, 0, 54, 50, 35, 176, 0, 0, 0, 0, 54, 253, 42, 176, 0, 0, 0, 0, 56, 27,
        64, 48, 0, 0, 0, 0, 56, 221, 12, 176, 0, 0, 0, 0, 57, 251, 34, 48, 0, 0, 0, 0, 58, 188,
        238, 176, 0, 0, 0, 0, 59, 219, 4, 48, 0, 0, 0, 0, 60, 166, 11, 48, 0, 0, 0, 0, 60, 206,
        233, 176, 0, 0, 0, 0, 61, 186, 244, 64, 0, 0, 0, 0, 62, 133, 251, 64, 0, 0, 0, 0, 63, 154,
        214, 64, 0, 0, 0, 0, 64, 101, 221, 64, 0, 0, 0, 0, 65, 131, 242, 192, 0, 0, 0, 0, 66, 69,
        191, 64, 0, 0, 0, 0, 67, 99, 212, 192, 0, 0, 0, 0, 68, 37, 161, 64, 0, 0, 0, 0, 69, 67,
        182, 192, 0, 0, 0, 0, 70, 5, 131, 64, 0, 0, 0, 0, 71, 35, 152, 192, 0, 0, 0, 0, 71, 238,
        159, 192, 0, 0, 0, 0, 73, 3, 122, 192, 0, 0, 0, 0, 73, 206, 129, 192, 0, 0, 0, 0, 74, 227,
        92, 192, 0, 0, 0, 0, 75, 174, 99, 192, 0, 0, 0, 0, 76, 204, 121, 64, 0, 0, 0, 0, 77, 142,
        69, 192, 0, 0, 0, 0, 84, 75, 243, 48, 0, 0, 0, 0, 87, 73, 248, 192, 1, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 3, 1, 3, 0,
        0, 79, 167, 0, 0, 0, 0, 84, 96, 0, 4, 0, 0, 112, 128, 1, 8, 0, 0, 98, 112, 0, 12, 0, 0, 98,
        112, 1, 12, 76, 77, 84, 0, 43, 48, 54, 0, 43, 48, 56, 0, 43, 48, 55, 0, 10, 60, 43, 48, 55,
        62, 45, 55, 10,
    ];
    pub(crate) const AsiaUlaanbaatar: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        50, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 134, 211, 238, 76, 0, 0, 0, 0, 15, 11,
        220, 144, 0, 0, 0, 0, 24, 233, 200, 128, 0, 0, 0, 0, 25, 218, 252, 240, 0, 0, 0, 0, 26,
        204, 77, 128, 0, 0, 0, 0, 27, 188, 48, 112, 0, 0, 0, 0, 28, 172, 47, 128, 0, 0, 0, 0, 29,
        156, 18, 112, 0, 0, 0, 0, 30, 140, 17, 128, 0, 0, 0, 0, 31, 123, 244, 112, 0, 0, 0, 0, 32,
        107, 243, 128, 0, 0, 0, 0, 33, 91, 214, 112, 0, 0, 0, 0, 34, 75, 213, 128, 0, 0, 0, 0, 35,
        59, 184, 112, 0, 0, 0, 0, 36, 43, 183, 128, 0, 0, 0, 0, 37, 27, 154, 112, 0, 0, 0, 0, 38,
        11, 153, 128, 0, 0, 0, 0, 39, 4, 182, 240, 0, 0, 0, 0, 39, 244, 182, 0, 0, 0, 0, 0, 40,
        228, 152, 240, 0, 0, 0, 0, 41, 212, 152, 0, 0, 0, 0, 0, 42, 196, 122, 240, 0, 0, 0, 0, 43,
        180, 122, 0, 0, 0, 0, 0, 44, 164, 92, 240, 0, 0, 0, 0, 45, 148, 92, 0, 0, 0, 0, 0, 46, 132,
        62, 240, 0, 0, 0, 0, 47, 116, 62, 0, 0, 0, 0, 0, 48, 100, 32, 240, 0, 0, 0, 0, 49, 93, 90,
        128, 0, 0, 0, 0, 50, 77, 61, 112, 0, 0, 0, 0, 51, 61, 60, 128, 0, 0, 0, 0, 52, 45, 31, 112,
        0, 0, 0, 0, 53, 29, 30, 128, 0, 0, 0, 0, 54, 13, 1, 112, 0, 0, 0, 0, 58, 233, 179, 160, 0,
        0, 0, 0, 59, 180, 172, 144, 0, 0, 0, 0, 60, 164, 171, 160, 0, 0, 0, 0, 61, 148, 142, 144,
        0, 0, 0, 0, 62, 132, 141, 160, 0, 0, 0, 0, 63, 116, 112, 144, 0, 0, 0, 0, 64, 100, 111,
        160, 0, 0, 0, 0, 65, 84, 82, 144, 0, 0, 0, 0, 66, 68, 81, 160, 0, 0, 0, 0, 67, 52, 52, 144,
        0, 0, 0, 0, 68, 36, 51, 160, 0, 0, 0, 0, 69, 29, 81, 16, 0, 0, 0, 0, 85, 21, 154, 160, 0,
        0, 0, 0, 86, 5, 97, 112, 0, 0, 0, 0, 86, 245, 124, 160, 0, 0, 0, 0, 87, 229, 67, 112, 1, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 0, 0, 100, 52, 0, 0, 0, 0, 98, 112,
        0, 4, 0, 0, 126, 144, 1, 8, 0, 0, 112, 128, 0, 12, 76, 77, 84, 0, 43, 48, 55, 0, 43, 48,
        57, 0, 43, 48, 56, 0, 10, 60, 43, 48, 56, 62, 45, 56, 10,
    ];
    pub(crate) const AsiaUstNera: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        66, 0, 0, 0, 8, 0, 0, 0, 24, 255, 255, 255, 255, 161, 219, 221, 186, 255, 255, 255, 255,
        181, 163, 197, 0, 0, 0, 0, 0, 21, 39, 83, 112, 0, 0, 0, 0, 22, 24, 107, 192, 0, 0, 0, 0,
        23, 8, 106, 208, 0, 0, 0, 0, 23, 249, 159, 64, 0, 0, 0, 0, 24, 233, 158, 80, 0, 0, 0, 0,
        25, 218, 210, 192, 0, 0, 0, 0, 26, 204, 35, 80, 0, 0, 0, 0, 27, 188, 48, 112, 0, 0, 0, 0,
        28, 172, 33, 112, 0, 0, 0, 0, 29, 156, 18, 112, 0, 0, 0, 0, 30, 140, 3, 112, 0, 0, 0, 0,
        31, 123, 244, 112, 0, 0, 0, 0, 32, 107, 229, 112, 0, 0, 0, 0, 33, 91, 214, 112, 0, 0, 0, 0,
        34, 75, 199, 112, 0, 0, 0, 0, 35, 59, 184, 112, 0, 0, 0, 0, 36, 43, 169, 112, 0, 0, 0, 0,
        37, 27, 154, 112, 0, 0, 0, 0, 38, 11, 139, 112, 0, 0, 0, 0, 39, 4, 182, 240, 0, 0, 0, 0,
        39, 244, 167, 240, 0, 0, 0, 0, 40, 228, 167, 0, 0, 0, 0, 0, 41, 120, 79, 0, 0, 0, 0, 0, 41,
        212, 137, 240, 0, 0, 0, 0, 42, 196, 122, 240, 0, 0, 0, 0, 43, 180, 107, 240, 0, 0, 0, 0,
        44, 164, 92, 240, 0, 0, 0, 0, 45, 148, 77, 240, 0, 0, 0, 0, 46, 132, 62, 240, 0, 0, 0, 0,
        47, 116, 47, 240, 0, 0, 0, 0, 48, 100, 32, 240, 0, 0, 0, 0, 49, 93, 76, 112, 0, 0, 0, 0,
        50, 114, 39, 112, 0, 0, 0, 0, 51, 61, 46, 112, 0, 0, 0, 0, 52, 82, 9, 112, 0, 0, 0, 0, 53,
        29, 16, 112, 0, 0, 0, 0, 54, 49, 235, 112, 0, 0, 0, 0, 54, 252, 242, 112, 0, 0, 0, 0, 56,
        27, 7, 240, 0, 0, 0, 0, 56, 220, 212, 112, 0, 0, 0, 0, 57, 250, 233, 240, 0, 0, 0, 0, 58,
        188, 182, 112, 0, 0, 0, 0, 59, 218, 203, 240, 0, 0, 0, 0, 60, 165, 210, 240, 0, 0, 0, 0,
        61, 186, 173, 240, 0, 0, 0, 0, 62, 133, 180, 240, 0, 0, 0, 0, 63, 154, 143, 240, 0, 0, 0,
        0, 64, 101, 150, 240, 0, 0, 0, 0, 65, 131, 172, 112, 0, 0, 0, 0, 66, 69, 120, 240, 0, 0, 0,
        0, 67, 99, 142, 112, 0, 0, 0, 0, 68, 37, 90, 240, 0, 0, 0, 0, 69, 67, 112, 112, 0, 0, 0, 0,
        70, 5, 60, 240, 0, 0, 0, 0, 71, 35, 82, 112, 0, 0, 0, 0, 71, 238, 89, 112, 0, 0, 0, 0, 73,
        3, 52, 112, 0, 0, 0, 0, 73, 206, 59, 112, 0, 0, 0, 0, 74, 227, 22, 112, 0, 0, 0, 0, 75,
        174, 29, 112, 0, 0, 0, 0, 76, 204, 50, 240, 0, 0, 0, 0, 77, 141, 255, 112, 0, 0, 0, 0, 78,
        109, 244, 64, 0, 0, 0, 0, 84, 75, 186, 240, 1, 2, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 5, 6, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4,
        3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 7, 3, 6, 0, 0, 134, 70, 0, 0, 0, 0, 112,
        128, 0, 4, 0, 0, 126, 144, 0, 8, 0, 0, 154, 176, 0, 12, 0, 0, 168, 192, 1, 16, 0, 0, 154,
        176, 1, 12, 0, 0, 140, 160, 0, 20, 0, 0, 168, 192, 0, 16, 76, 77, 84, 0, 43, 48, 56, 0, 43,
        48, 57, 0, 43, 49, 49, 0, 43, 49, 50, 0, 43, 49, 48, 0, 10, 60, 43, 49, 48, 62, 45, 49, 48,
        10,
    ];
    pub(crate) const AsiaVladivostok: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        65, 0, 0, 0, 6, 0, 0, 0, 16, 255, 255, 255, 255, 167, 89, 71, 93, 255, 255, 255, 255, 181,
        163, 182, 240, 0, 0, 0, 0, 21, 39, 69, 96, 0, 0, 0, 0, 22, 24, 121, 208, 0, 0, 0, 0, 23, 8,
        120, 224, 0, 0, 0, 0, 23, 249, 173, 80, 0, 0, 0, 0, 24, 233, 172, 96, 0, 0, 0, 0, 25, 218,
        224, 208, 0, 0, 0, 0, 26, 204, 49, 96, 0, 0, 0, 0, 27, 188, 62, 128, 0, 0, 0, 0, 28, 172,
        47, 128, 0, 0, 0, 0, 29, 156, 32, 128, 0, 0, 0, 0, 30, 140, 17, 128, 0, 0, 0, 0, 31, 124,
        2, 128, 0, 0, 0, 0, 32, 107, 243, 128, 0, 0, 0, 0, 33, 91, 228, 128, 0, 0, 0, 0, 34, 75,
        213, 128, 0, 0, 0, 0, 35, 59, 198, 128, 0, 0, 0, 0, 36, 43, 183, 128, 0, 0, 0, 0, 37, 27,
        168, 128, 0, 0, 0, 0, 38, 11, 153, 128, 0, 0, 0, 0, 39, 4, 197, 0, 0, 0, 0, 0, 39, 244,
        182, 0, 0, 0, 0, 0, 40, 228, 181, 16, 0, 0, 0, 0, 41, 120, 93, 16, 0, 0, 0, 0, 41, 212,
        152, 0, 0, 0, 0, 0, 42, 196, 137, 0, 0, 0, 0, 0, 43, 180, 122, 0, 0, 0, 0, 0, 44, 164, 107,
        0, 0, 0, 0, 0, 45, 148, 92, 0, 0, 0, 0, 0, 46, 132, 77, 0, 0, 0, 0, 0, 47, 116, 62, 0, 0,
        0, 0, 0, 48, 100, 47, 0, 0, 0, 0, 0, 49, 93, 90, 128, 0, 0, 0, 0, 50, 114, 53, 128, 0, 0,
        0, 0, 51, 61, 60, 128, 0, 0, 0, 0, 52, 82, 23, 128, 0, 0, 0, 0, 53, 29, 30, 128, 0, 0, 0,
        0, 54, 49, 249, 128, 0, 0, 0, 0, 54, 253, 0, 128, 0, 0, 0, 0, 56, 27, 22, 0, 0, 0, 0, 0,
        56, 220, 226, 128, 0, 0, 0, 0, 57, 250, 248, 0, 0, 0, 0, 0, 58, 188, 196, 128, 0, 0, 0, 0,
        59, 218, 218, 0, 0, 0, 0, 0, 60, 165, 225, 0, 0, 0, 0, 0, 61, 186, 188, 0, 0, 0, 0, 0, 62,
        133, 195, 0, 0, 0, 0, 0, 63, 154, 158, 0, 0, 0, 0, 0, 64, 101, 165, 0, 0, 0, 0, 0, 65, 131,
        186, 128, 0, 0, 0, 0, 66, 69, 135, 0, 0, 0, 0, 0, 67, 99, 156, 128, 0, 0, 0, 0, 68, 37,
        105, 0, 0, 0, 0, 0, 69, 67, 126, 128, 0, 0, 0, 0, 70, 5, 75, 0, 0, 0, 0, 0, 71, 35, 96,
        128, 0, 0, 0, 0, 71, 238, 103, 128, 0, 0, 0, 0, 73, 3, 66, 128, 0, 0, 0, 0, 73, 206, 73,
        128, 0, 0, 0, 0, 74, 227, 36, 128, 0, 0, 0, 0, 75, 174, 43, 128, 0, 0, 0, 0, 76, 204, 65,
        0, 0, 0, 0, 0, 77, 142, 13, 128, 0, 0, 0, 0, 84, 75, 186, 240, 1, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 5, 3, 0, 0, 123,
        163, 0, 0, 0, 0, 126, 144, 0, 4, 0, 0, 154, 176, 1, 8, 0, 0, 140, 160, 0, 12, 0, 0, 140,
        160, 1, 12, 0, 0, 154, 176, 0, 8, 76, 77, 84, 0, 43, 48, 57, 0, 43, 49, 49, 0, 43, 49, 48,
        0, 10, 60, 43, 49, 48, 62, 45, 49, 48, 10,
    ];
    pub(crate) const AsiaYakutsk: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        65, 0, 0, 0, 6, 0, 0, 0, 16, 255, 255, 255, 255, 161, 219, 234, 94, 255, 255, 255, 255,
        181, 163, 197, 0, 0, 0, 0, 0, 21, 39, 83, 112, 0, 0, 0, 0, 22, 24, 135, 224, 0, 0, 0, 0,
        23, 8, 134, 240, 0, 0, 0, 0, 23, 249, 187, 96, 0, 0, 0, 0, 24, 233, 186, 112, 0, 0, 0, 0,
        25, 218, 238, 224, 0, 0, 0, 0, 26, 204, 63, 112, 0, 0, 0, 0, 27, 188, 76, 144, 0, 0, 0, 0,
        28, 172, 61, 144, 0, 0, 0, 0, 29, 156, 46, 144, 0, 0, 0, 0, 30, 140, 31, 144, 0, 0, 0, 0,
        31, 124, 16, 144, 0, 0, 0, 0, 32, 108, 1, 144, 0, 0, 0, 0, 33, 91, 242, 144, 0, 0, 0, 0,
        34, 75, 227, 144, 0, 0, 0, 0, 35, 59, 212, 144, 0, 0, 0, 0, 36, 43, 197, 144, 0, 0, 0, 0,
        37, 27, 182, 144, 0, 0, 0, 0, 38, 11, 167, 144, 0, 0, 0, 0, 39, 4, 211, 16, 0, 0, 0, 0, 39,
        244, 196, 16, 0, 0, 0, 0, 40, 228, 195, 32, 0, 0, 0, 0, 41, 120, 107, 32, 0, 0, 0, 0, 41,
        212, 166, 16, 0, 0, 0, 0, 42, 196, 151, 16, 0, 0, 0, 0, 43, 180, 136, 16, 0, 0, 0, 0, 44,
        164, 121, 16, 0, 0, 0, 0, 45, 148, 106, 16, 0, 0, 0, 0, 46, 132, 91, 16, 0, 0, 0, 0, 47,
        116, 76, 16, 0, 0, 0, 0, 48, 100, 61, 16, 0, 0, 0, 0, 49, 93, 104, 144, 0, 0, 0, 0, 50,
        114, 67, 144, 0, 0, 0, 0, 51, 61, 74, 144, 0, 0, 0, 0, 52, 82, 37, 144, 0, 0, 0, 0, 53, 29,
        44, 144, 0, 0, 0, 0, 54, 50, 7, 144, 0, 0, 0, 0, 54, 253, 14, 144, 0, 0, 0, 0, 56, 27, 36,
        16, 0, 0, 0, 0, 56, 220, 240, 144, 0, 0, 0, 0, 57, 251, 6, 16, 0, 0, 0, 0, 58, 188, 210,
        144, 0, 0, 0, 0, 59, 218, 232, 16, 0, 0, 0, 0, 60, 165, 239, 16, 0, 0, 0, 0, 61, 186, 202,
        16, 0, 0, 0, 0, 62, 133, 209, 16, 0, 0, 0, 0, 63, 154, 172, 16, 0, 0, 0, 0, 64, 101, 179,
        16, 0, 0, 0, 0, 65, 131, 200, 144, 0, 0, 0, 0, 66, 69, 149, 16, 0, 0, 0, 0, 67, 99, 170,
        144, 0, 0, 0, 0, 68, 37, 119, 16, 0, 0, 0, 0, 69, 67, 140, 144, 0, 0, 0, 0, 70, 5, 89, 16,
        0, 0, 0, 0, 71, 35, 110, 144, 0, 0, 0, 0, 71, 238, 117, 144, 0, 0, 0, 0, 73, 3, 80, 144, 0,
        0, 0, 0, 73, 206, 87, 144, 0, 0, 0, 0, 74, 227, 50, 144, 0, 0, 0, 0, 75, 174, 57, 144, 0,
        0, 0, 0, 76, 204, 79, 16, 0, 0, 0, 0, 77, 142, 27, 144, 0, 0, 0, 0, 84, 75, 201, 0, 1, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 1, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 5, 3, 0, 0, 121, 162, 0, 0, 0, 0, 112, 128, 0, 4, 0, 0, 140, 160, 1, 8, 0, 0, 126, 144,
        0, 12, 0, 0, 126, 144, 1, 12, 0, 0, 140, 160, 0, 8, 76, 77, 84, 0, 43, 48, 56, 0, 43, 49,
        48, 0, 43, 48, 57, 0, 10, 60, 43, 48, 57, 62, 45, 57, 10,
    ];
    pub(crate) const AsiaYekaterinburg: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        66, 0, 0, 0, 7, 0, 0, 0, 20, 255, 255, 255, 255, 155, 95, 9, 39, 255, 255, 255, 255, 161,
        18, 177, 255, 255, 255, 255, 255, 181, 163, 253, 64, 0, 0, 0, 0, 21, 39, 139, 176, 0, 0, 0,
        0, 22, 24, 192, 32, 0, 0, 0, 0, 23, 8, 191, 48, 0, 0, 0, 0, 23, 249, 243, 160, 0, 0, 0, 0,
        24, 233, 242, 176, 0, 0, 0, 0, 25, 219, 39, 32, 0, 0, 0, 0, 26, 204, 119, 176, 0, 0, 0, 0,
        27, 188, 132, 208, 0, 0, 0, 0, 28, 172, 117, 208, 0, 0, 0, 0, 29, 156, 102, 208, 0, 0, 0,
        0, 30, 140, 87, 208, 0, 0, 0, 0, 31, 124, 72, 208, 0, 0, 0, 0, 32, 108, 57, 208, 0, 0, 0,
        0, 33, 92, 42, 208, 0, 0, 0, 0, 34, 76, 27, 208, 0, 0, 0, 0, 35, 60, 12, 208, 0, 0, 0, 0,
        36, 43, 253, 208, 0, 0, 0, 0, 37, 27, 238, 208, 0, 0, 0, 0, 38, 11, 223, 208, 0, 0, 0, 0,
        39, 5, 11, 80, 0, 0, 0, 0, 39, 244, 252, 80, 0, 0, 0, 0, 40, 228, 251, 96, 0, 0, 0, 0, 41,
        120, 163, 96, 0, 0, 0, 0, 41, 212, 222, 80, 0, 0, 0, 0, 42, 196, 207, 80, 0, 0, 0, 0, 43,
        180, 192, 80, 0, 0, 0, 0, 44, 164, 177, 80, 0, 0, 0, 0, 45, 148, 162, 80, 0, 0, 0, 0, 46,
        132, 147, 80, 0, 0, 0, 0, 47, 116, 132, 80, 0, 0, 0, 0, 48, 100, 117, 80, 0, 0, 0, 0, 49,
        93, 160, 208, 0, 0, 0, 0, 50, 114, 123, 208, 0, 0, 0, 0, 51, 61, 130, 208, 0, 0, 0, 0, 52,
        82, 93, 208, 0, 0, 0, 0, 53, 29, 100, 208, 0, 0, 0, 0, 54, 50, 63, 208, 0, 0, 0, 0, 54,
        253, 70, 208, 0, 0, 0, 0, 56, 27, 92, 80, 0, 0, 0, 0, 56, 221, 40, 208, 0, 0, 0, 0, 57,
        251, 62, 80, 0, 0, 0, 0, 58, 189, 10, 208, 0, 0, 0, 0, 59, 219, 32, 80, 0, 0, 0, 0, 60,
        166, 39, 80, 0, 0, 0, 0, 61, 187, 2, 80, 0, 0, 0, 0, 62, 134, 9, 80, 0, 0, 0, 0, 63, 154,
        228, 80, 0, 0, 0, 0, 64, 101, 235, 80, 0, 0, 0, 0, 65, 132, 0, 208, 0, 0, 0, 0, 66, 69,
        205, 80, 0, 0, 0, 0, 67, 99, 226, 208, 0, 0, 0, 0, 68, 37, 175, 80, 0, 0, 0, 0, 69, 67,
        196, 208, 0, 0, 0, 0, 70, 5, 145, 80, 0, 0, 0, 0, 71, 35, 166, 208, 0, 0, 0, 0, 71, 238,
        173, 208, 0, 0, 0, 0, 73, 3, 136, 208, 0, 0, 0, 0, 73, 206, 143, 208, 0, 0, 0, 0, 74, 227,
        106, 208, 0, 0, 0, 0, 75, 174, 113, 208, 0, 0, 0, 0, 76, 204, 135, 80, 0, 0, 0, 0, 77, 142,
        83, 208, 0, 0, 0, 0, 84, 76, 1, 64, 1, 2, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 5, 2, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4,
        3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 6, 4, 0, 0, 56, 217, 0, 0, 0, 0, 52, 193,
        0, 4, 0, 0, 56, 64, 0, 8, 0, 0, 84, 96, 1, 12, 0, 0, 70, 80, 0, 16, 0, 0, 70, 80, 1, 16, 0,
        0, 84, 96, 0, 12, 76, 77, 84, 0, 80, 77, 84, 0, 43, 48, 52, 0, 43, 48, 54, 0, 43, 48, 53,
        0, 10, 60, 43, 48, 53, 62, 45, 53, 10,
    ];
    pub(crate) const AsiaYerevan: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        62, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 170, 25, 154, 72, 255, 255, 255, 255, 231,
        218, 12, 80, 0, 0, 0, 0, 21, 39, 153, 192, 0, 0, 0, 0, 22, 24, 206, 48, 0, 0, 0, 0, 23, 8,
        205, 64, 0, 0, 0, 0, 23, 250, 1, 176, 0, 0, 0, 0, 24, 234, 0, 192, 0, 0, 0, 0, 25, 219, 53,
        48, 0, 0, 0, 0, 26, 204, 133, 192, 0, 0, 0, 0, 27, 188, 146, 224, 0, 0, 0, 0, 28, 172, 131,
        224, 0, 0, 0, 0, 29, 156, 116, 224, 0, 0, 0, 0, 30, 140, 101, 224, 0, 0, 0, 0, 31, 124, 86,
        224, 0, 0, 0, 0, 32, 108, 71, 224, 0, 0, 0, 0, 33, 92, 56, 224, 0, 0, 0, 0, 34, 76, 41,
        224, 0, 0, 0, 0, 35, 60, 26, 224, 0, 0, 0, 0, 36, 44, 11, 224, 0, 0, 0, 0, 37, 27, 252,
        224, 0, 0, 0, 0, 38, 11, 237, 224, 0, 0, 0, 0, 39, 5, 25, 96, 0, 0, 0, 0, 39, 245, 10, 96,
        0, 0, 0, 0, 40, 229, 9, 112, 0, 0, 0, 0, 41, 212, 250, 112, 0, 0, 0, 0, 42, 196, 235, 112,
        0, 0, 0, 0, 43, 180, 220, 112, 0, 0, 0, 0, 44, 164, 205, 112, 0, 0, 0, 0, 45, 148, 190,
        112, 0, 0, 0, 0, 46, 132, 175, 112, 0, 0, 0, 0, 47, 116, 160, 112, 0, 0, 0, 0, 48, 100,
        145, 112, 0, 0, 0, 0, 51, 61, 144, 224, 0, 0, 0, 0, 52, 82, 107, 224, 0, 0, 0, 0, 53, 29,
        114, 224, 0, 0, 0, 0, 54, 50, 77, 224, 0, 0, 0, 0, 54, 253, 84, 224, 0, 0, 0, 0, 56, 27,
        106, 96, 0, 0, 0, 0, 56, 221, 54, 224, 0, 0, 0, 0, 57, 251, 76, 96, 0, 0, 0, 0, 58, 189,
        24, 224, 0, 0, 0, 0, 59, 219, 46, 96, 0, 0, 0, 0, 60, 166, 53, 96, 0, 0, 0, 0, 61, 187, 16,
        96, 0, 0, 0, 0, 62, 134, 23, 96, 0, 0, 0, 0, 63, 154, 242, 96, 0, 0, 0, 0, 64, 101, 249,
        96, 0, 0, 0, 0, 65, 132, 14, 224, 0, 0, 0, 0, 66, 69, 219, 96, 0, 0, 0, 0, 67, 99, 240,
        224, 0, 0, 0, 0, 68, 37, 189, 96, 0, 0, 0, 0, 69, 67, 210, 224, 0, 0, 0, 0, 70, 5, 159, 96,
        0, 0, 0, 0, 71, 35, 180, 224, 0, 0, 0, 0, 71, 238, 187, 224, 0, 0, 0, 0, 73, 3, 150, 224,
        0, 0, 0, 0, 73, 206, 157, 224, 0, 0, 0, 0, 74, 227, 120, 224, 0, 0, 0, 0, 75, 174, 127,
        224, 0, 0, 0, 0, 76, 204, 149, 96, 0, 0, 0, 0, 77, 142, 97, 224, 0, 0, 0, 0, 78, 172, 119,
        96, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 1, 4, 1, 4, 1, 4,
        1, 4, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 0, 0, 41, 184, 0, 0, 0, 0, 42, 48, 0, 4, 0, 0, 70, 80, 1, 8, 0, 0, 56, 64, 0, 12,
        0, 0, 56, 64, 1, 12, 76, 77, 84, 0, 43, 48, 51, 0, 43, 48, 53, 0, 43, 48, 52, 0, 10, 60,
        43, 48, 52, 62, 45, 52, 10,
    ];
    pub(crate) const AtlanticAzores: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        140, 0, 0, 0, 7, 0, 0, 0, 24, 255, 255, 255, 255, 94, 61, 27, 144, 255, 255, 255, 255, 146,
        230, 170, 160, 255, 255, 255, 255, 155, 75, 137, 144, 255, 255, 255, 255, 155, 254, 227,
        160, 255, 255, 255, 255, 156, 157, 9, 144, 255, 255, 255, 255, 157, 201, 159, 144, 255,
        255, 255, 255, 158, 127, 142, 144, 255, 255, 255, 255, 159, 170, 211, 16, 255, 255, 255,
        255, 160, 95, 112, 144, 255, 255, 255, 255, 161, 140, 6, 144, 255, 255, 255, 255, 162, 65,
        245, 144, 255, 255, 255, 255, 163, 110, 139, 144, 255, 255, 255, 255, 164, 35, 41, 16, 255,
        255, 255, 255, 165, 79, 191, 16, 255, 255, 255, 255, 170, 6, 11, 144, 255, 255, 255, 255,
        170, 244, 171, 16, 255, 255, 255, 255, 173, 201, 196, 16, 255, 255, 255, 255, 174, 167, 64,
        16, 255, 255, 255, 255, 175, 160, 107, 144, 255, 255, 255, 255, 176, 135, 34, 16, 255, 255,
        255, 255, 177, 137, 136, 16, 255, 255, 255, 255, 178, 112, 62, 144, 255, 255, 255, 255,
        179, 114, 164, 144, 255, 255, 255, 255, 180, 80, 32, 144, 255, 255, 255, 255, 183, 50, 104,
        144, 255, 255, 255, 255, 184, 15, 228, 144, 255, 255, 255, 255, 184, 255, 213, 144, 255,
        255, 255, 255, 185, 239, 198, 144, 255, 255, 255, 255, 188, 200, 212, 16, 255, 255, 255,
        255, 189, 184, 197, 16, 255, 255, 255, 255, 190, 159, 123, 144, 255, 255, 255, 255, 191,
        152, 167, 16, 255, 255, 255, 255, 192, 155, 13, 16, 255, 255, 255, 255, 193, 120, 137, 16,
        255, 255, 255, 255, 194, 104, 122, 16, 255, 255, 255, 255, 195, 88, 107, 16, 255, 255, 255,
        255, 196, 63, 33, 144, 255, 255, 255, 255, 197, 56, 77, 16, 255, 255, 255, 255, 198, 58,
        179, 16, 255, 255, 255, 255, 199, 88, 200, 144, 255, 255, 255, 255, 199, 217, 251, 144,
        255, 255, 255, 255, 201, 1, 75, 144, 255, 255, 255, 255, 201, 241, 60, 144, 255, 255, 255,
        255, 202, 226, 127, 16, 255, 255, 255, 255, 203, 181, 111, 16, 255, 255, 255, 255, 203,
        236, 192, 0, 255, 255, 255, 255, 204, 128, 104, 0, 255, 255, 255, 255, 204, 220, 191, 16,
        255, 255, 255, 255, 205, 149, 81, 16, 255, 255, 255, 255, 205, 195, 103, 128, 255, 255,
        255, 255, 206, 114, 191, 0, 255, 255, 255, 255, 206, 197, 219, 144, 255, 255, 255, 255,
        207, 117, 51, 16, 255, 255, 255, 255, 207, 172, 132, 0, 255, 255, 255, 255, 208, 82, 161,
        0, 255, 255, 255, 255, 208, 165, 189, 144, 255, 255, 255, 255, 209, 85, 21, 16, 255, 255,
        255, 255, 209, 140, 102, 0, 255, 255, 255, 255, 210, 50, 131, 0, 255, 255, 255, 255, 210,
        133, 159, 144, 255, 255, 255, 255, 211, 89, 225, 16, 255, 255, 255, 255, 212, 73, 210, 16,
        255, 255, 255, 255, 213, 57, 237, 64, 255, 255, 255, 255, 214, 41, 222, 64, 255, 255, 255,
        255, 215, 25, 207, 64, 255, 255, 255, 255, 216, 9, 192, 64, 255, 255, 255, 255, 216, 249,
        177, 64, 255, 255, 255, 255, 217, 233, 162, 64, 255, 255, 255, 255, 218, 217, 147, 64, 255,
        255, 255, 255, 219, 201, 132, 64, 255, 255, 255, 255, 220, 185, 117, 64, 255, 255, 255,
        255, 221, 178, 160, 192, 255, 255, 255, 255, 222, 162, 145, 192, 255, 255, 255, 255, 223,
        146, 130, 192, 255, 255, 255, 255, 224, 130, 115, 192, 255, 255, 255, 255, 225, 114, 100,
        192, 255, 255, 255, 255, 226, 98, 85, 192, 255, 255, 255, 255, 227, 82, 70, 192, 255, 255,
        255, 255, 228, 66, 55, 192, 255, 255, 255, 255, 229, 50, 40, 192, 255, 255, 255, 255, 230,
        34, 25, 192, 255, 255, 255, 255, 231, 27, 69, 64, 255, 255, 255, 255, 232, 11, 54, 64, 255,
        255, 255, 255, 232, 251, 39, 64, 255, 255, 255, 255, 233, 235, 24, 64, 255, 255, 255, 255,
        234, 219, 9, 64, 255, 255, 255, 255, 235, 202, 250, 64, 255, 255, 255, 255, 236, 186, 235,
        64, 255, 255, 255, 255, 237, 170, 220, 64, 255, 255, 255, 255, 238, 154, 205, 64, 255, 255,
        255, 255, 239, 138, 190, 64, 255, 255, 255, 255, 240, 122, 175, 64, 255, 255, 255, 255,
        241, 106, 160, 64, 255, 255, 255, 255, 242, 99, 203, 192, 255, 255, 255, 255, 243, 83, 188,
        192, 255, 255, 255, 255, 244, 67, 173, 192, 255, 255, 255, 255, 245, 51, 158, 192, 255,
        255, 255, 255, 246, 35, 143, 192, 255, 255, 255, 255, 247, 19, 128, 192, 255, 255, 255,
        255, 248, 3, 113, 192, 255, 255, 255, 255, 248, 243, 98, 192, 0, 0, 0, 0, 13, 155, 41, 16,
        0, 0, 0, 0, 14, 139, 26, 16, 0, 0, 0, 0, 15, 132, 69, 144, 0, 0, 0, 0, 16, 116, 54, 144, 0,
        0, 0, 0, 17, 100, 39, 144, 0, 0, 0, 0, 18, 84, 38, 160, 0, 0, 0, 0, 19, 68, 9, 144, 0, 0,
        0, 0, 20, 52, 8, 160, 0, 0, 0, 0, 21, 35, 249, 160, 0, 0, 0, 0, 22, 19, 234, 160, 0, 0, 0,
        0, 23, 3, 219, 160, 0, 0, 0, 0, 23, 243, 204, 160, 0, 0, 0, 0, 24, 227, 203, 176, 0, 0, 0,
        0, 25, 211, 174, 160, 0, 0, 0, 0, 26, 195, 159, 160, 0, 0, 0, 0, 27, 188, 203, 32, 0, 0, 0,
        0, 28, 172, 188, 32, 0, 0, 0, 0, 29, 156, 173, 32, 0, 0, 0, 0, 30, 140, 158, 32, 0, 0, 0,
        0, 31, 124, 143, 32, 0, 0, 0, 0, 32, 108, 128, 32, 0, 0, 0, 0, 33, 92, 113, 32, 0, 0, 0, 0,
        34, 76, 98, 32, 0, 0, 0, 0, 35, 60, 83, 32, 0, 0, 0, 0, 36, 44, 68, 32, 0, 0, 0, 0, 37, 28,
        53, 32, 0, 0, 0, 0, 38, 12, 38, 32, 0, 0, 0, 0, 39, 5, 81, 160, 0, 0, 0, 0, 39, 245, 66,
        160, 0, 0, 0, 0, 40, 229, 51, 160, 0, 0, 0, 0, 41, 213, 36, 160, 0, 0, 0, 0, 42, 197, 21,
        160, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148,
        218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48,
        100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 4,
        2, 3, 2, 4, 2, 3, 2, 4, 2, 3, 2, 4, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 5, 4, 5, 4, 5, 4,
        5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 6, 4, 5, 4,
        5, 4, 5, 4, 255, 255, 231, 240, 0, 0, 255, 255, 229, 40, 0, 4, 255, 255, 241, 240, 1, 8,
        255, 255, 227, 224, 0, 12, 0, 0, 0, 0, 1, 16, 255, 255, 241, 240, 0, 8, 0, 0, 0, 0, 0, 20,
        76, 77, 84, 0, 72, 77, 84, 0, 45, 48, 49, 0, 45, 48, 50, 0, 43, 48, 48, 0, 87, 69, 84, 0,
        10, 60, 45, 48, 49, 62, 49, 60, 43, 48, 48, 62, 44, 77, 51, 46, 53, 46, 48, 47, 48, 44, 77,
        49, 48, 46, 53, 46, 48, 47, 49, 10,
    ];
    pub(crate) const AtlanticBermuda: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        95, 0, 0, 0, 5, 0, 0, 0, 20, 255, 255, 255, 255, 105, 135, 24, 70, 255, 255, 255, 255, 156,
        204, 174, 70, 255, 255, 255, 255, 157, 183, 75, 54, 255, 255, 255, 255, 158, 184, 109, 198,
        255, 255, 255, 255, 159, 132, 184, 54, 255, 255, 255, 255, 180, 195, 29, 230, 255, 255,
        255, 255, 203, 98, 166, 224, 255, 255, 255, 255, 204, 211, 188, 208, 255, 255, 255, 255,
        205, 158, 209, 224, 255, 255, 255, 255, 206, 198, 19, 208, 255, 255, 255, 255, 207, 117,
        121, 96, 255, 255, 255, 255, 208, 175, 48, 80, 255, 255, 255, 255, 209, 85, 91, 96, 255,
        255, 255, 255, 210, 143, 18, 80, 255, 255, 255, 255, 213, 113, 104, 96, 255, 255, 255, 255,
        214, 14, 60, 208, 255, 255, 255, 255, 215, 90, 132, 224, 255, 255, 255, 255, 215, 228, 228,
        80, 255, 255, 255, 255, 217, 58, 102, 224, 255, 255, 255, 255, 217, 196, 198, 80, 255, 255,
        255, 255, 219, 35, 131, 96, 255, 255, 255, 255, 219, 164, 168, 80, 255, 255, 255, 255, 221,
        3, 101, 96, 255, 255, 255, 255, 221, 132, 138, 80, 255, 255, 255, 255, 222, 227, 71, 96,
        255, 255, 255, 255, 223, 109, 166, 208, 255, 255, 255, 255, 230, 108, 9, 224, 255, 255,
        255, 255, 231, 55, 2, 208, 0, 0, 0, 0, 8, 32, 179, 96, 0, 0, 0, 0, 9, 16, 150, 80, 0, 0, 0,
        0, 10, 0, 149, 96, 0, 0, 0, 0, 10, 240, 120, 80, 0, 0, 0, 0, 11, 224, 119, 96, 0, 0, 0, 0,
        12, 217, 148, 208, 0, 0, 0, 0, 13, 192, 89, 96, 0, 0, 0, 0, 14, 185, 118, 208, 0, 0, 0, 0,
        15, 169, 117, 224, 0, 0, 0, 0, 16, 153, 88, 208, 0, 0, 0, 0, 17, 137, 87, 224, 0, 0, 0, 0,
        18, 121, 58, 208, 0, 0, 0, 0, 19, 105, 57, 224, 0, 0, 0, 0, 20, 89, 28, 208, 0, 0, 0, 0,
        21, 73, 27, 224, 0, 0, 0, 0, 22, 56, 254, 208, 0, 0, 0, 0, 23, 40, 253, 224, 0, 0, 0, 0,
        24, 34, 27, 80, 0, 0, 0, 0, 25, 8, 223, 224, 0, 0, 0, 0, 26, 1, 253, 80, 0, 0, 0, 0, 26,
        241, 252, 96, 0, 0, 0, 0, 27, 225, 223, 80, 0, 0, 0, 0, 28, 209, 222, 96, 0, 0, 0, 0, 29,
        193, 193, 80, 0, 0, 0, 0, 30, 177, 192, 96, 0, 0, 0, 0, 31, 161, 163, 80, 0, 0, 0, 0, 32,
        117, 242, 224, 0, 0, 0, 0, 33, 129, 133, 80, 0, 0, 0, 0, 34, 85, 212, 224, 0, 0, 0, 0, 35,
        106, 161, 208, 0, 0, 0, 0, 36, 53, 182, 224, 0, 0, 0, 0, 37, 74, 131, 208, 0, 0, 0, 0, 38,
        21, 152, 224, 0, 0, 0, 0, 39, 42, 101, 208, 0, 0, 0, 0, 39, 254, 181, 96, 0, 0, 0, 0, 41,
        10, 71, 208, 0, 0, 0, 0, 41, 222, 151, 96, 0, 0, 0, 0, 42, 234, 41, 208, 0, 0, 0, 0, 43,
        190, 121, 96, 0, 0, 0, 0, 44, 211, 70, 80, 0, 0, 0, 0, 45, 158, 91, 96, 0, 0, 0, 0, 46,
        179, 40, 80, 0, 0, 0, 0, 47, 126, 61, 96, 0, 0, 0, 0, 48, 147, 10, 80, 0, 0, 0, 0, 49, 103,
        89, 224, 0, 0, 0, 0, 50, 114, 236, 80, 0, 0, 0, 0, 51, 71, 59, 224, 0, 0, 0, 0, 52, 82,
        206, 80, 0, 0, 0, 0, 53, 39, 29, 224, 0, 0, 0, 0, 54, 50, 176, 80, 0, 0, 0, 0, 55, 6, 255,
        224, 0, 0, 0, 0, 56, 27, 204, 208, 0, 0, 0, 0, 56, 230, 225, 224, 0, 0, 0, 0, 57, 251, 174,
        208, 0, 0, 0, 0, 58, 198, 195, 224, 0, 0, 0, 0, 59, 219, 144, 208, 0, 0, 0, 0, 60, 175,
        224, 96, 0, 0, 0, 0, 61, 187, 114, 208, 0, 0, 0, 0, 62, 143, 194, 96, 0, 0, 0, 0, 63, 155,
        84, 208, 0, 0, 0, 0, 64, 111, 164, 96, 0, 0, 0, 0, 65, 132, 113, 80, 0, 0, 0, 0, 66, 79,
        134, 96, 0, 0, 0, 0, 67, 100, 83, 80, 0, 0, 0, 0, 68, 47, 104, 96, 0, 0, 0, 0, 69, 68, 53,
        80, 0, 0, 0, 0, 69, 243, 154, 224, 2, 1, 2, 1, 2, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 255, 255, 195, 58, 0, 0, 255, 255, 209, 74,
        1, 4, 255, 255, 195, 58, 0, 8, 255, 255, 213, 208, 1, 12, 255, 255, 199, 192, 0, 16, 76,
        77, 84, 0, 66, 83, 84, 0, 66, 77, 84, 0, 65, 68, 84, 0, 65, 83, 84, 0, 10, 65, 83, 84, 52,
        65, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const AtlanticCanary: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        35, 0, 0, 0, 4, 0, 0, 0, 17, 255, 255, 255, 255, 166, 4, 92, 240, 255, 255, 255, 255, 212,
        65, 247, 32, 0, 0, 0, 0, 19, 77, 54, 0, 0, 0, 0, 0, 20, 51, 250, 144, 0, 0, 0, 0, 21, 35,
        235, 144, 0, 0, 0, 0, 22, 19, 220, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23, 243,
        190, 144, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0, 26,
        195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29,
        156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32,
        108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60,
        69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16,
        0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0,
        0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0,
        0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144,
        0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16,
        1, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 255, 255, 241, 144, 0, 0, 255, 255, 241, 240, 0, 4, 0, 0, 0, 0, 0, 8, 0, 0,
        14, 16, 1, 12, 76, 77, 84, 0, 45, 48, 49, 0, 87, 69, 84, 0, 87, 69, 83, 84, 0, 10, 87, 69,
        84, 48, 87, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 47, 49, 44, 77, 49, 48, 46, 53, 46, 48,
        10,
    ];
    pub(crate) const AtlanticCapeVerde: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        4, 0, 0, 0, 4, 0, 0, 0, 12, 255, 255, 255, 255, 146, 230, 170, 160, 255, 255, 255, 255,
        204, 149, 156, 32, 255, 255, 255, 255, 210, 116, 124, 16, 0, 0, 0, 0, 11, 23, 247, 64, 1,
        2, 1, 3, 255, 255, 233, 244, 0, 0, 255, 255, 227, 224, 0, 4, 255, 255, 241, 240, 1, 8, 255,
        255, 241, 240, 0, 8, 76, 77, 84, 0, 45, 48, 50, 0, 45, 48, 49, 0, 10, 60, 45, 48, 49, 62,
        49, 10,
    ];
    pub(crate) const AtlanticFaeroe: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        32, 0, 0, 0, 3, 0, 0, 0, 13, 255, 255, 255, 255, 139, 109, 164, 88, 0, 0, 0, 0, 21, 35,
        235, 144, 0, 0, 0, 0, 22, 19, 220, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23, 243,
        190, 144, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0, 26,
        195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29,
        156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32,
        108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60,
        69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16,
        0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0,
        0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0,
        0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144,
        0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 255, 255, 249, 168, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 16, 1, 8, 76, 77, 84, 0, 87,
        69, 84, 0, 87, 69, 83, 84, 0, 10, 87, 69, 84, 48, 87, 69, 83, 84, 44, 77, 51, 46, 53, 46,
        48, 47, 49, 44, 77, 49, 48, 46, 53, 46, 48, 10,
    ];
    pub(crate) const AtlanticMadeira: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        140, 0, 0, 0, 7, 0, 0, 0, 29, 255, 255, 255, 255, 94, 61, 19, 88, 255, 255, 255, 255, 146,
        230, 156, 144, 255, 255, 255, 255, 155, 75, 123, 128, 255, 255, 255, 255, 155, 254, 213,
        144, 255, 255, 255, 255, 156, 156, 251, 128, 255, 255, 255, 255, 157, 201, 145, 128, 255,
        255, 255, 255, 158, 127, 128, 128, 255, 255, 255, 255, 159, 170, 197, 0, 255, 255, 255,
        255, 160, 95, 98, 128, 255, 255, 255, 255, 161, 139, 248, 128, 255, 255, 255, 255, 162, 65,
        231, 128, 255, 255, 255, 255, 163, 110, 125, 128, 255, 255, 255, 255, 164, 35, 27, 0, 255,
        255, 255, 255, 165, 79, 177, 0, 255, 255, 255, 255, 170, 5, 253, 128, 255, 255, 255, 255,
        170, 244, 157, 0, 255, 255, 255, 255, 173, 201, 182, 0, 255, 255, 255, 255, 174, 167, 50,
        0, 255, 255, 255, 255, 175, 160, 93, 128, 255, 255, 255, 255, 176, 135, 20, 0, 255, 255,
        255, 255, 177, 137, 122, 0, 255, 255, 255, 255, 178, 112, 48, 128, 255, 255, 255, 255, 179,
        114, 150, 128, 255, 255, 255, 255, 180, 80, 18, 128, 255, 255, 255, 255, 183, 50, 90, 128,
        255, 255, 255, 255, 184, 15, 214, 128, 255, 255, 255, 255, 184, 255, 199, 128, 255, 255,
        255, 255, 185, 239, 184, 128, 255, 255, 255, 255, 188, 200, 198, 0, 255, 255, 255, 255,
        189, 184, 183, 0, 255, 255, 255, 255, 190, 159, 109, 128, 255, 255, 255, 255, 191, 152,
        153, 0, 255, 255, 255, 255, 192, 154, 255, 0, 255, 255, 255, 255, 193, 120, 123, 0, 255,
        255, 255, 255, 194, 104, 108, 0, 255, 255, 255, 255, 195, 88, 93, 0, 255, 255, 255, 255,
        196, 63, 19, 128, 255, 255, 255, 255, 197, 56, 63, 0, 255, 255, 255, 255, 198, 58, 165, 0,
        255, 255, 255, 255, 199, 88, 186, 128, 255, 255, 255, 255, 199, 217, 237, 128, 255, 255,
        255, 255, 201, 1, 61, 128, 255, 255, 255, 255, 201, 241, 46, 128, 255, 255, 255, 255, 202,
        226, 113, 0, 255, 255, 255, 255, 203, 181, 97, 0, 255, 255, 255, 255, 203, 236, 177, 240,
        255, 255, 255, 255, 204, 128, 89, 240, 255, 255, 255, 255, 204, 220, 177, 0, 255, 255, 255,
        255, 205, 149, 67, 0, 255, 255, 255, 255, 205, 195, 89, 112, 255, 255, 255, 255, 206, 114,
        176, 240, 255, 255, 255, 255, 206, 197, 205, 128, 255, 255, 255, 255, 207, 117, 37, 0, 255,
        255, 255, 255, 207, 172, 117, 240, 255, 255, 255, 255, 208, 82, 146, 240, 255, 255, 255,
        255, 208, 165, 175, 128, 255, 255, 255, 255, 209, 85, 7, 0, 255, 255, 255, 255, 209, 140,
        87, 240, 255, 255, 255, 255, 210, 50, 116, 240, 255, 255, 255, 255, 210, 133, 145, 128,
        255, 255, 255, 255, 211, 89, 211, 0, 255, 255, 255, 255, 212, 73, 196, 0, 255, 255, 255,
        255, 213, 57, 223, 48, 255, 255, 255, 255, 214, 41, 208, 48, 255, 255, 255, 255, 215, 25,
        193, 48, 255, 255, 255, 255, 216, 9, 178, 48, 255, 255, 255, 255, 216, 249, 163, 48, 255,
        255, 255, 255, 217, 233, 148, 48, 255, 255, 255, 255, 218, 217, 133, 48, 255, 255, 255,
        255, 219, 201, 118, 48, 255, 255, 255, 255, 220, 185, 103, 48, 255, 255, 255, 255, 221,
        178, 146, 176, 255, 255, 255, 255, 222, 162, 131, 176, 255, 255, 255, 255, 223, 146, 116,
        176, 255, 255, 255, 255, 224, 130, 101, 176, 255, 255, 255, 255, 225, 114, 86, 176, 255,
        255, 255, 255, 226, 98, 71, 176, 255, 255, 255, 255, 227, 82, 56, 176, 255, 255, 255, 255,
        228, 66, 41, 176, 255, 255, 255, 255, 229, 50, 26, 176, 255, 255, 255, 255, 230, 34, 11,
        176, 255, 255, 255, 255, 231, 27, 55, 48, 255, 255, 255, 255, 232, 11, 40, 48, 255, 255,
        255, 255, 232, 251, 25, 48, 255, 255, 255, 255, 233, 235, 10, 48, 255, 255, 255, 255, 234,
        218, 251, 48, 255, 255, 255, 255, 235, 202, 236, 48, 255, 255, 255, 255, 236, 186, 221, 48,
        255, 255, 255, 255, 237, 170, 206, 48, 255, 255, 255, 255, 238, 154, 191, 48, 255, 255,
        255, 255, 239, 138, 176, 48, 255, 255, 255, 255, 240, 122, 161, 48, 255, 255, 255, 255,
        241, 106, 146, 48, 255, 255, 255, 255, 242, 99, 189, 176, 255, 255, 255, 255, 243, 83, 174,
        176, 255, 255, 255, 255, 244, 67, 159, 176, 255, 255, 255, 255, 245, 51, 144, 176, 255,
        255, 255, 255, 246, 35, 129, 176, 255, 255, 255, 255, 247, 19, 114, 176, 255, 255, 255,
        255, 248, 3, 99, 176, 255, 255, 255, 255, 248, 243, 84, 176, 0, 0, 0, 0, 13, 155, 27, 0, 0,
        0, 0, 0, 14, 139, 12, 0, 0, 0, 0, 0, 15, 132, 55, 128, 0, 0, 0, 0, 16, 116, 40, 128, 0, 0,
        0, 0, 17, 100, 25, 128, 0, 0, 0, 0, 18, 84, 24, 144, 0, 0, 0, 0, 19, 67, 251, 128, 0, 0, 0,
        0, 20, 51, 250, 144, 0, 0, 0, 0, 21, 35, 235, 144, 0, 0, 0, 0, 22, 19, 220, 144, 0, 0, 0,
        0, 23, 3, 205, 144, 0, 0, 0, 0, 23, 243, 190, 144, 0, 0, 0, 0, 24, 227, 189, 160, 0, 0, 0,
        0, 25, 211, 160, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0,
        0, 28, 172, 174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0,
        0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0,
        34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28,
        39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52,
        144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7,
        144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148,
        218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48,
        100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 4,
        2, 3, 2, 4, 2, 3, 2, 4, 2, 3, 2, 4, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 6, 5, 6, 5, 6, 5,
        6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5,
        6, 5, 6, 5, 255, 255, 240, 40, 0, 0, 255, 255, 240, 40, 0, 4, 0, 0, 0, 0, 1, 8, 255, 255,
        241, 240, 0, 12, 0, 0, 14, 16, 1, 16, 0, 0, 14, 16, 1, 20, 0, 0, 0, 0, 0, 25, 76, 77, 84,
        0, 70, 77, 84, 0, 43, 48, 48, 0, 45, 48, 49, 0, 43, 48, 49, 0, 87, 69, 83, 84, 0, 87, 69,
        84, 0, 10, 87, 69, 84, 48, 87, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 47, 49, 44, 77, 49,
        48, 46, 53, 46, 48, 10,
    ];
    pub(crate) const AtlanticReykjavik: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        68, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 139, 96, 131, 160, 255, 255, 255, 255,
        156, 145, 30, 0, 255, 255, 255, 255, 157, 209, 136, 144, 255, 255, 255, 255, 158, 114, 81,
        128, 255, 255, 255, 255, 159, 213, 3, 16, 255, 255, 255, 255, 160, 83, 133, 0, 255, 255,
        255, 255, 161, 182, 54, 144, 255, 255, 255, 255, 164, 60, 39, 128, 255, 255, 255, 255, 164,
        185, 116, 16, 255, 255, 255, 255, 198, 77, 26, 0, 255, 255, 255, 255, 199, 61, 39, 32, 255,
        255, 255, 255, 199, 218, 23, 176, 255, 255, 255, 255, 201, 38, 67, 160, 255, 255, 255, 255,
        201, 195, 38, 32, 255, 255, 255, 255, 203, 6, 37, 160, 255, 255, 255, 255, 203, 172, 66,
        160, 255, 255, 255, 255, 204, 220, 205, 32, 255, 255, 255, 255, 205, 140, 36, 160, 255,
        255, 255, 255, 206, 188, 175, 32, 255, 255, 255, 255, 207, 108, 6, 160, 255, 255, 255, 255,
        208, 156, 145, 32, 255, 255, 255, 255, 209, 75, 232, 160, 255, 255, 255, 255, 210, 133,
        173, 160, 255, 255, 255, 255, 211, 43, 202, 160, 255, 255, 255, 255, 212, 101, 143, 160,
        255, 255, 255, 255, 213, 57, 209, 32, 255, 255, 255, 255, 214, 69, 113, 160, 255, 255, 255,
        255, 215, 25, 179, 32, 255, 255, 255, 255, 216, 37, 83, 160, 255, 255, 255, 255, 216, 249,
        149, 32, 255, 255, 255, 255, 218, 14, 112, 32, 255, 255, 255, 255, 218, 217, 119, 32, 255,
        255, 255, 255, 219, 229, 23, 160, 255, 255, 255, 255, 220, 185, 89, 32, 255, 255, 255, 255,
        221, 206, 52, 32, 255, 255, 255, 255, 222, 162, 117, 160, 255, 255, 255, 255, 223, 174, 22,
        32, 255, 255, 255, 255, 224, 130, 87, 160, 255, 255, 255, 255, 225, 141, 248, 32, 255, 255,
        255, 255, 226, 98, 57, 160, 255, 255, 255, 255, 227, 109, 218, 32, 255, 255, 255, 255, 228,
        66, 27, 160, 255, 255, 255, 255, 229, 77, 188, 32, 255, 255, 255, 255, 230, 33, 253, 160,
        255, 255, 255, 255, 231, 54, 216, 160, 255, 255, 255, 255, 232, 11, 26, 32, 255, 255, 255,
        255, 233, 22, 186, 160, 255, 255, 255, 255, 233, 234, 252, 32, 255, 255, 255, 255, 234,
        246, 156, 160, 255, 255, 255, 255, 235, 202, 222, 32, 255, 255, 255, 255, 236, 214, 126,
        160, 255, 255, 255, 255, 237, 170, 192, 32, 255, 255, 255, 255, 238, 182, 96, 160, 255,
        255, 255, 255, 239, 138, 162, 32, 255, 255, 255, 255, 240, 150, 66, 160, 255, 255, 255,
        255, 241, 106, 132, 32, 255, 255, 255, 255, 242, 127, 95, 32, 255, 255, 255, 255, 243, 83,
        160, 160, 255, 255, 255, 255, 244, 95, 65, 32, 255, 255, 255, 255, 245, 51, 130, 160, 255,
        255, 255, 255, 246, 63, 35, 32, 255, 255, 255, 255, 247, 19, 100, 160, 255, 255, 255, 255,
        248, 31, 5, 32, 255, 255, 255, 255, 248, 243, 70, 160, 255, 255, 255, 255, 249, 254, 231,
        32, 255, 255, 255, 255, 250, 211, 40, 160, 255, 255, 255, 255, 251, 232, 3, 160, 255, 255,
        255, 255, 252, 188, 69, 32, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 255, 255, 235, 96, 0, 0, 0, 0, 0, 0, 1,
        4, 255, 255, 241, 240, 0, 8, 0, 0, 0, 0, 0, 12, 76, 77, 84, 0, 43, 48, 48, 0, 45, 48, 49,
        0, 71, 77, 84, 0, 10, 71, 77, 84, 48, 10,
    ];
    pub(crate) const AtlanticSouthGeorgia: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        1, 0, 0, 0, 2, 0, 0, 0, 8, 255, 255, 255, 255, 105, 134, 253, 192, 1, 255, 255, 221, 192,
        0, 0, 255, 255, 227, 224, 0, 4, 76, 77, 84, 0, 45, 48, 50, 0, 10, 60, 45, 48, 50, 62, 50,
        10,
    ];
    pub(crate) const AtlanticStanley: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        70, 0, 0, 0, 6, 0, 0, 0, 20, 255, 255, 255, 255, 105, 135, 17, 188, 255, 255, 255, 255,
        147, 68, 95, 60, 255, 255, 255, 255, 195, 79, 90, 192, 255, 255, 255, 255, 196, 54, 3, 48,
        255, 255, 255, 255, 197, 47, 60, 192, 255, 255, 255, 255, 198, 21, 229, 48, 255, 255, 255,
        255, 199, 24, 89, 64, 255, 255, 255, 255, 199, 255, 1, 176, 255, 255, 255, 255, 200, 248,
        59, 64, 255, 255, 255, 255, 201, 222, 227, 176, 255, 255, 255, 255, 202, 216, 29, 64, 255,
        255, 255, 255, 203, 190, 197, 176, 255, 255, 255, 255, 204, 183, 255, 64, 255, 255, 255,
        255, 205, 54, 129, 48, 0, 0, 0, 0, 25, 17, 254, 64, 0, 0, 0, 0, 25, 211, 188, 176, 0, 0, 0,
        0, 26, 241, 196, 32, 0, 0, 0, 0, 27, 170, 100, 48, 0, 0, 0, 0, 28, 209, 166, 32, 0, 0, 0,
        0, 29, 138, 70, 48, 0, 0, 0, 0, 30, 168, 91, 176, 0, 0, 0, 0, 31, 106, 54, 64, 0, 0, 0, 0,
        32, 136, 61, 176, 0, 0, 0, 0, 33, 74, 24, 64, 0, 0, 0, 0, 34, 104, 31, 176, 0, 0, 0, 0, 35,
        41, 250, 64, 0, 0, 0, 0, 36, 72, 1, 176, 0, 0, 0, 0, 37, 9, 220, 64, 0, 0, 0, 0, 38, 49,
        30, 48, 0, 0, 0, 0, 38, 233, 190, 64, 0, 0, 0, 0, 40, 17, 0, 48, 0, 0, 0, 0, 40, 210, 218,
        192, 0, 0, 0, 0, 41, 240, 226, 48, 0, 0, 0, 0, 42, 178, 188, 192, 0, 0, 0, 0, 43, 208, 196,
        48, 0, 0, 0, 0, 44, 146, 158, 192, 0, 0, 0, 0, 45, 176, 166, 48, 0, 0, 0, 0, 46, 114, 128,
        192, 0, 0, 0, 0, 47, 144, 136, 48, 0, 0, 0, 0, 48, 82, 98, 192, 0, 0, 0, 0, 49, 121, 164,
        176, 0, 0, 0, 0, 50, 59, 127, 64, 0, 0, 0, 0, 51, 89, 134, 176, 0, 0, 0, 0, 52, 27, 97, 64,
        0, 0, 0, 0, 53, 57, 104, 176, 0, 0, 0, 0, 53, 251, 67, 64, 0, 0, 0, 0, 55, 25, 74, 176, 0,
        0, 0, 0, 55, 219, 37, 64, 0, 0, 0, 0, 56, 249, 44, 176, 0, 0, 0, 0, 57, 187, 7, 64, 0, 0,
        0, 0, 58, 217, 42, 208, 0, 0, 0, 0, 59, 145, 202, 224, 0, 0, 0, 0, 60, 194, 71, 80, 0, 0,
        0, 0, 61, 113, 172, 224, 0, 0, 0, 0, 62, 162, 41, 80, 0, 0, 0, 0, 63, 90, 201, 96, 0, 0, 0,
        0, 64, 130, 11, 80, 0, 0, 0, 0, 65, 58, 171, 96, 0, 0, 0, 0, 66, 97, 237, 80, 0, 0, 0, 0,
        67, 26, 141, 96, 0, 0, 0, 0, 68, 65, 207, 80, 0, 0, 0, 0, 68, 250, 111, 96, 0, 0, 0, 0, 70,
        33, 177, 80, 0, 0, 0, 0, 70, 218, 81, 96, 0, 0, 0, 0, 72, 10, 205, 208, 0, 0, 0, 0, 72,
        195, 109, 224, 0, 0, 0, 0, 73, 234, 175, 208, 0, 0, 0, 0, 74, 163, 79, 224, 0, 0, 0, 0, 75,
        202, 145, 208, 0, 0, 0, 0, 76, 131, 49, 224, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 5,
        4, 5, 4, 5, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 5, 255, 255, 201,
        196, 0, 0, 255, 255, 201, 196, 0, 4, 255, 255, 213, 208, 1, 8, 255, 255, 199, 192, 0, 12,
        255, 255, 227, 224, 1, 16, 255, 255, 213, 208, 0, 8, 76, 77, 84, 0, 83, 77, 84, 0, 45, 48,
        51, 0, 45, 48, 52, 0, 45, 48, 50, 0, 10, 60, 45, 48, 51, 62, 51, 10,
    ];
    pub(crate) const AustraliaAct: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        83, 0, 0, 0, 3, 0, 0, 0, 14, 255, 255, 255, 255, 115, 22, 127, 60, 255, 255, 255, 255, 156,
        78, 194, 128, 255, 255, 255, 255, 156, 188, 47, 0, 255, 255, 255, 255, 203, 84, 179, 0,
        255, 255, 255, 255, 203, 199, 101, 128, 255, 255, 255, 255, 204, 183, 86, 128, 255, 255,
        255, 255, 205, 167, 71, 128, 255, 255, 255, 255, 206, 160, 115, 0, 255, 255, 255, 255, 207,
        135, 41, 128, 0, 0, 0, 0, 3, 112, 57, 128, 0, 0, 0, 0, 4, 13, 28, 0, 0, 0, 0, 0, 5, 80, 27,
        128, 0, 0, 0, 0, 5, 246, 56, 128, 0, 0, 0, 0, 7, 47, 253, 128, 0, 0, 0, 0, 7, 214, 26, 128,
        0, 0, 0, 0, 9, 15, 223, 128, 0, 0, 0, 0, 9, 181, 252, 128, 0, 0, 0, 0, 10, 239, 193, 128,
        0, 0, 0, 0, 11, 159, 25, 0, 0, 0, 0, 0, 12, 216, 222, 0, 0, 0, 0, 0, 13, 126, 251, 0, 0, 0,
        0, 0, 14, 184, 192, 0, 0, 0, 0, 0, 15, 94, 221, 0, 0, 0, 0, 0, 16, 152, 162, 0, 0, 0, 0, 0,
        17, 62, 191, 0, 0, 0, 0, 0, 18, 120, 132, 0, 0, 0, 0, 0, 19, 30, 161, 0, 0, 0, 0, 0, 20,
        88, 102, 0, 0, 0, 0, 0, 20, 254, 131, 0, 0, 0, 0, 0, 22, 56, 72, 0, 0, 0, 0, 0, 23, 12,
        137, 128, 0, 0, 0, 0, 24, 33, 100, 128, 0, 0, 0, 0, 24, 199, 129, 128, 0, 0, 0, 0, 26, 1,
        70, 128, 0, 0, 0, 0, 26, 167, 99, 128, 0, 0, 0, 0, 27, 225, 40, 128, 0, 0, 0, 0, 28, 135,
        69, 128, 0, 0, 0, 0, 29, 193, 10, 128, 0, 0, 0, 0, 30, 121, 156, 128, 0, 0, 0, 0, 31, 151,
        178, 0, 0, 0, 0, 0, 32, 89, 126, 128, 0, 0, 0, 0, 33, 128, 206, 128, 0, 0, 0, 0, 34, 66,
        155, 0, 0, 0, 0, 0, 35, 105, 235, 0, 0, 0, 0, 0, 36, 34, 125, 0, 0, 0, 0, 0, 37, 73, 205,
        0, 0, 0, 0, 0, 37, 239, 234, 0, 0, 0, 0, 0, 39, 41, 175, 0, 0, 0, 0, 0, 39, 207, 204, 0, 0,
        0, 0, 0, 41, 9, 145, 0, 0, 0, 0, 0, 41, 175, 174, 0, 0, 0, 0, 0, 42, 233, 115, 0, 0, 0, 0,
        0, 43, 152, 202, 128, 0, 0, 0, 0, 44, 210, 143, 128, 0, 0, 0, 0, 45, 120, 172, 128, 0, 0,
        0, 0, 46, 178, 113, 128, 0, 0, 0, 0, 47, 88, 142, 128, 0, 0, 0, 0, 48, 146, 83, 128, 0, 0,
        0, 0, 49, 93, 90, 128, 0, 0, 0, 0, 50, 114, 53, 128, 0, 0, 0, 0, 51, 61, 60, 128, 0, 0, 0,
        0, 52, 82, 23, 128, 0, 0, 0, 0, 53, 29, 30, 128, 0, 0, 0, 0, 54, 49, 249, 128, 0, 0, 0, 0,
        54, 253, 0, 128, 0, 0, 0, 0, 56, 27, 22, 0, 0, 0, 0, 0, 56, 220, 226, 128, 0, 0, 0, 0, 57,
        167, 233, 128, 0, 0, 0, 0, 58, 188, 196, 128, 0, 0, 0, 0, 59, 218, 218, 0, 0, 0, 0, 0, 60,
        165, 225, 0, 0, 0, 0, 0, 61, 186, 188, 0, 0, 0, 0, 0, 62, 133, 195, 0, 0, 0, 0, 0, 63, 154,
        158, 0, 0, 0, 0, 0, 64, 101, 165, 0, 0, 0, 0, 0, 65, 131, 186, 128, 0, 0, 0, 0, 66, 69,
        135, 0, 0, 0, 0, 0, 67, 99, 156, 128, 0, 0, 0, 0, 68, 46, 163, 128, 0, 0, 0, 0, 69, 67,
        126, 128, 0, 0, 0, 0, 70, 5, 75, 0, 0, 0, 0, 0, 71, 35, 96, 128, 0, 0, 0, 0, 71, 247, 162,
        0, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 0, 141, 196, 0,
        0, 0, 0, 154, 176, 1, 4, 0, 0, 140, 160, 0, 9, 76, 77, 84, 0, 65, 69, 68, 84, 0, 65, 69,
        83, 84, 0, 10, 65, 69, 83, 84, 45, 49, 48, 65, 69, 68, 84, 44, 77, 49, 48, 46, 49, 46, 48,
        44, 77, 52, 46, 49, 46, 48, 47, 51, 10,
    ];
    pub(crate) const AustraliaAdelaide: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        84, 0, 0, 0, 4, 0, 0, 0, 14, 255, 255, 255, 255, 115, 22, 139, 20, 255, 255, 255, 255, 123,
        18, 3, 112, 255, 255, 255, 255, 156, 78, 201, 136, 255, 255, 255, 255, 156, 188, 54, 8,
        255, 255, 255, 255, 203, 84, 186, 8, 255, 255, 255, 255, 203, 199, 108, 136, 255, 255, 255,
        255, 204, 183, 93, 136, 255, 255, 255, 255, 205, 167, 78, 136, 255, 255, 255, 255, 206,
        160, 122, 8, 255, 255, 255, 255, 207, 135, 48, 136, 0, 0, 0, 0, 3, 112, 64, 136, 0, 0, 0,
        0, 4, 13, 35, 8, 0, 0, 0, 0, 5, 80, 34, 136, 0, 0, 0, 0, 5, 246, 63, 136, 0, 0, 0, 0, 7,
        48, 4, 136, 0, 0, 0, 0, 7, 214, 33, 136, 0, 0, 0, 0, 9, 15, 230, 136, 0, 0, 0, 0, 9, 182,
        3, 136, 0, 0, 0, 0, 10, 239, 200, 136, 0, 0, 0, 0, 11, 159, 32, 8, 0, 0, 0, 0, 12, 216,
        229, 8, 0, 0, 0, 0, 13, 127, 2, 8, 0, 0, 0, 0, 14, 184, 199, 8, 0, 0, 0, 0, 15, 94, 228, 8,
        0, 0, 0, 0, 16, 152, 169, 8, 0, 0, 0, 0, 17, 62, 198, 8, 0, 0, 0, 0, 18, 120, 139, 8, 0, 0,
        0, 0, 19, 30, 168, 8, 0, 0, 0, 0, 20, 88, 109, 8, 0, 0, 0, 0, 20, 254, 138, 8, 0, 0, 0, 0,
        22, 56, 79, 8, 0, 0, 0, 0, 22, 231, 166, 136, 0, 0, 0, 0, 24, 33, 107, 136, 0, 0, 0, 0, 24,
        199, 136, 136, 0, 0, 0, 0, 26, 1, 77, 136, 0, 0, 0, 0, 26, 167, 106, 136, 0, 0, 0, 0, 27,
        225, 47, 136, 0, 0, 0, 0, 28, 135, 76, 136, 0, 0, 0, 0, 29, 193, 17, 136, 0, 0, 0, 0, 30,
        121, 163, 136, 0, 0, 0, 0, 31, 151, 185, 8, 0, 0, 0, 0, 32, 89, 133, 136, 0, 0, 0, 0, 33,
        128, 213, 136, 0, 0, 0, 0, 34, 66, 162, 8, 0, 0, 0, 0, 35, 105, 242, 8, 0, 0, 0, 0, 36, 34,
        132, 8, 0, 0, 0, 0, 37, 73, 212, 8, 0, 0, 0, 0, 38, 2, 102, 8, 0, 0, 0, 0, 39, 41, 182, 8,
        0, 0, 0, 0, 39, 207, 211, 8, 0, 0, 0, 0, 41, 9, 152, 8, 0, 0, 0, 0, 41, 203, 100, 136, 0,
        0, 0, 0, 42, 233, 122, 8, 0, 0, 0, 0, 43, 152, 209, 136, 0, 0, 0, 0, 44, 210, 150, 136, 0,
        0, 0, 0, 45, 139, 40, 136, 0, 0, 0, 0, 46, 178, 120, 136, 0, 0, 0, 0, 47, 116, 69, 8, 0, 0,
        0, 0, 48, 146, 90, 136, 0, 0, 0, 0, 49, 93, 97, 136, 0, 0, 0, 0, 50, 114, 60, 136, 0, 0, 0,
        0, 51, 61, 67, 136, 0, 0, 0, 0, 52, 82, 30, 136, 0, 0, 0, 0, 53, 29, 37, 136, 0, 0, 0, 0,
        54, 50, 0, 136, 0, 0, 0, 0, 54, 253, 7, 136, 0, 0, 0, 0, 56, 27, 29, 8, 0, 0, 0, 0, 56,
        220, 233, 136, 0, 0, 0, 0, 57, 250, 255, 8, 0, 0, 0, 0, 58, 188, 203, 136, 0, 0, 0, 0, 59,
        218, 225, 8, 0, 0, 0, 0, 60, 165, 232, 8, 0, 0, 0, 0, 61, 186, 195, 8, 0, 0, 0, 0, 62, 133,
        202, 8, 0, 0, 0, 0, 63, 154, 165, 8, 0, 0, 0, 0, 64, 101, 172, 8, 0, 0, 0, 0, 65, 131, 193,
        136, 0, 0, 0, 0, 66, 69, 142, 8, 0, 0, 0, 0, 67, 99, 163, 136, 0, 0, 0, 0, 68, 46, 170,
        136, 0, 0, 0, 0, 69, 67, 133, 136, 0, 0, 0, 0, 70, 5, 82, 8, 0, 0, 0, 0, 71, 35, 103, 136,
        0, 0, 0, 0, 71, 247, 169, 8, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 0, 0, 129, 236, 0, 0, 0, 0, 126, 144, 0, 4, 0, 0, 147, 168, 1, 9, 0, 0, 133, 152,
        0, 4, 76, 77, 84, 0, 65, 67, 83, 84, 0, 65, 67, 68, 84, 0, 10, 65, 67, 83, 84, 45, 57, 58,
        51, 48, 65, 67, 68, 84, 44, 77, 49, 48, 46, 49, 46, 48, 44, 77, 52, 46, 49, 46, 48, 47, 51,
        10,
    ];
    pub(crate) const AustraliaBrisbane: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        17, 0, 0, 0, 3, 0, 0, 0, 14, 255, 255, 255, 255, 114, 237, 159, 8, 255, 255, 255, 255, 156,
        78, 194, 128, 255, 255, 255, 255, 156, 188, 47, 0, 255, 255, 255, 255, 203, 84, 179, 0,
        255, 255, 255, 255, 203, 199, 101, 128, 255, 255, 255, 255, 204, 183, 86, 128, 255, 255,
        255, 255, 205, 167, 71, 128, 255, 255, 255, 255, 206, 160, 115, 0, 255, 255, 255, 255, 207,
        135, 41, 128, 0, 0, 0, 0, 3, 112, 57, 128, 0, 0, 0, 0, 4, 13, 28, 0, 0, 0, 0, 0, 37, 73,
        205, 0, 0, 0, 0, 0, 37, 239, 234, 0, 0, 0, 0, 0, 39, 41, 175, 0, 0, 0, 0, 0, 39, 207, 204,
        0, 0, 0, 0, 0, 41, 9, 145, 0, 0, 0, 0, 0, 41, 175, 174, 0, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 0, 0, 143, 120, 0, 0, 0, 0, 154, 176, 1, 4, 0, 0, 140, 160, 0, 9, 76, 77,
        84, 0, 65, 69, 68, 84, 0, 65, 69, 83, 84, 0, 10, 65, 69, 83, 84, 45, 49, 48, 10,
    ];
    pub(crate) const AustraliaBrokenHill: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        85, 0, 0, 0, 5, 0, 0, 0, 19, 255, 255, 255, 255, 115, 22, 136, 100, 255, 255, 255, 255,
        118, 4, 165, 224, 255, 255, 255, 255, 123, 18, 3, 112, 255, 255, 255, 255, 156, 78, 201,
        136, 255, 255, 255, 255, 156, 188, 54, 8, 255, 255, 255, 255, 203, 84, 186, 8, 255, 255,
        255, 255, 203, 199, 108, 136, 255, 255, 255, 255, 204, 183, 93, 136, 255, 255, 255, 255,
        205, 167, 78, 136, 255, 255, 255, 255, 206, 160, 122, 8, 255, 255, 255, 255, 207, 135, 48,
        136, 0, 0, 0, 0, 3, 112, 64, 136, 0, 0, 0, 0, 4, 13, 35, 8, 0, 0, 0, 0, 5, 80, 34, 136, 0,
        0, 0, 0, 5, 246, 63, 136, 0, 0, 0, 0, 7, 48, 4, 136, 0, 0, 0, 0, 7, 214, 33, 136, 0, 0, 0,
        0, 9, 15, 230, 136, 0, 0, 0, 0, 9, 182, 3, 136, 0, 0, 0, 0, 10, 239, 200, 136, 0, 0, 0, 0,
        11, 159, 32, 8, 0, 0, 0, 0, 12, 216, 229, 8, 0, 0, 0, 0, 13, 127, 2, 8, 0, 0, 0, 0, 14,
        184, 199, 8, 0, 0, 0, 0, 15, 94, 228, 8, 0, 0, 0, 0, 16, 152, 169, 8, 0, 0, 0, 0, 17, 62,
        198, 8, 0, 0, 0, 0, 18, 120, 139, 8, 0, 0, 0, 0, 19, 30, 168, 8, 0, 0, 0, 0, 20, 88, 109,
        8, 0, 0, 0, 0, 20, 254, 138, 8, 0, 0, 0, 0, 22, 56, 79, 8, 0, 0, 0, 0, 23, 12, 144, 136, 0,
        0, 0, 0, 24, 33, 107, 136, 0, 0, 0, 0, 24, 199, 136, 136, 0, 0, 0, 0, 26, 1, 77, 136, 0, 0,
        0, 0, 26, 167, 106, 136, 0, 0, 0, 0, 27, 225, 47, 136, 0, 0, 0, 0, 28, 135, 76, 136, 0, 0,
        0, 0, 29, 193, 17, 136, 0, 0, 0, 0, 30, 121, 163, 136, 0, 0, 0, 0, 31, 151, 185, 8, 0, 0,
        0, 0, 32, 89, 133, 136, 0, 0, 0, 0, 33, 128, 213, 136, 0, 0, 0, 0, 34, 66, 162, 8, 0, 0, 0,
        0, 35, 105, 242, 8, 0, 0, 0, 0, 36, 34, 132, 8, 0, 0, 0, 0, 37, 73, 212, 8, 0, 0, 0, 0, 37,
        239, 241, 8, 0, 0, 0, 0, 39, 41, 182, 8, 0, 0, 0, 0, 39, 207, 211, 8, 0, 0, 0, 0, 41, 9,
        152, 8, 0, 0, 0, 0, 41, 175, 181, 8, 0, 0, 0, 0, 42, 233, 122, 8, 0, 0, 0, 0, 43, 152, 209,
        136, 0, 0, 0, 0, 44, 210, 150, 136, 0, 0, 0, 0, 45, 120, 179, 136, 0, 0, 0, 0, 46, 178,
        120, 136, 0, 0, 0, 0, 47, 88, 149, 136, 0, 0, 0, 0, 48, 146, 90, 136, 0, 0, 0, 0, 49, 93,
        97, 136, 0, 0, 0, 0, 50, 114, 60, 136, 0, 0, 0, 0, 51, 61, 67, 136, 0, 0, 0, 0, 52, 82, 30,
        136, 0, 0, 0, 0, 53, 29, 37, 136, 0, 0, 0, 0, 54, 50, 0, 136, 0, 0, 0, 0, 54, 253, 7, 136,
        0, 0, 0, 0, 56, 27, 29, 8, 0, 0, 0, 0, 56, 220, 233, 136, 0, 0, 0, 0, 57, 250, 255, 8, 0,
        0, 0, 0, 58, 188, 203, 136, 0, 0, 0, 0, 59, 218, 225, 8, 0, 0, 0, 0, 60, 165, 232, 8, 0, 0,
        0, 0, 61, 186, 195, 8, 0, 0, 0, 0, 62, 133, 202, 8, 0, 0, 0, 0, 63, 154, 165, 8, 0, 0, 0,
        0, 64, 101, 172, 8, 0, 0, 0, 0, 65, 131, 193, 136, 0, 0, 0, 0, 66, 69, 142, 8, 0, 0, 0, 0,
        67, 99, 163, 136, 0, 0, 0, 0, 68, 46, 170, 136, 0, 0, 0, 0, 69, 67, 133, 136, 0, 0, 0, 0,
        70, 5, 82, 8, 0, 0, 0, 0, 71, 35, 103, 136, 0, 0, 0, 0, 71, 247, 169, 8, 1, 2, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 0, 0, 132, 156, 0, 0, 0, 0, 140,
        160, 0, 4, 0, 0, 126, 144, 0, 9, 0, 0, 147, 168, 1, 14, 0, 0, 133, 152, 0, 9, 76, 77, 84,
        0, 65, 69, 83, 84, 0, 65, 67, 83, 84, 0, 65, 67, 68, 84, 0, 10, 65, 67, 83, 84, 45, 57, 58,
        51, 48, 65, 67, 68, 84, 44, 77, 49, 48, 46, 49, 46, 48, 44, 77, 52, 46, 49, 46, 48, 47, 51,
        10,
    ];
    pub(crate) const AustraliaCurrie: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        94, 0, 0, 0, 3, 0, 0, 0, 14, 255, 255, 255, 255, 116, 46, 0, 228, 255, 255, 255, 255, 155,
        213, 120, 128, 255, 255, 255, 255, 156, 188, 47, 0, 255, 255, 255, 255, 157, 218, 68, 128,
        255, 255, 255, 255, 158, 128, 97, 128, 255, 255, 255, 255, 159, 186, 38, 128, 255, 255,
        255, 255, 160, 96, 67, 128, 255, 255, 255, 255, 203, 84, 179, 0, 255, 255, 255, 255, 203,
        199, 101, 128, 255, 255, 255, 255, 204, 183, 86, 128, 255, 255, 255, 255, 205, 167, 71,
        128, 255, 255, 255, 255, 206, 160, 115, 0, 255, 255, 255, 255, 207, 135, 41, 128, 255, 255,
        255, 255, 251, 194, 141, 0, 255, 255, 255, 255, 252, 178, 126, 0, 255, 255, 255, 255, 253,
        199, 89, 0, 255, 255, 255, 255, 254, 118, 176, 128, 255, 255, 255, 255, 255, 167, 59, 0, 0,
        0, 0, 0, 0, 86, 146, 128, 0, 0, 0, 0, 1, 135, 29, 0, 0, 0, 0, 0, 2, 63, 175, 0, 0, 0, 0, 0,
        3, 112, 57, 128, 0, 0, 0, 0, 4, 13, 28, 0, 0, 0, 0, 0, 5, 80, 27, 128, 0, 0, 0, 0, 5, 246,
        56, 128, 0, 0, 0, 0, 7, 47, 253, 128, 0, 0, 0, 0, 7, 214, 26, 128, 0, 0, 0, 0, 9, 15, 223,
        128, 0, 0, 0, 0, 9, 181, 252, 128, 0, 0, 0, 0, 10, 239, 193, 128, 0, 0, 0, 0, 11, 159, 25,
        0, 0, 0, 0, 0, 12, 216, 222, 0, 0, 0, 0, 0, 13, 126, 251, 0, 0, 0, 0, 0, 14, 184, 192, 0,
        0, 0, 0, 0, 15, 94, 221, 0, 0, 0, 0, 0, 16, 152, 162, 0, 0, 0, 0, 0, 17, 62, 191, 0, 0, 0,
        0, 0, 18, 120, 132, 0, 0, 0, 0, 0, 19, 30, 161, 0, 0, 0, 0, 0, 20, 88, 102, 0, 0, 0, 0, 0,
        20, 254, 131, 0, 0, 0, 0, 0, 22, 56, 72, 0, 0, 0, 0, 0, 23, 3, 79, 0, 0, 0, 0, 0, 24, 33,
        100, 128, 0, 0, 0, 0, 24, 227, 49, 0, 0, 0, 0, 0, 26, 1, 70, 128, 0, 0, 0, 0, 26, 167, 99,
        128, 0, 0, 0, 0, 27, 225, 40, 128, 0, 0, 0, 0, 28, 135, 69, 128, 0, 0, 0, 0, 29, 193, 10,
        128, 0, 0, 0, 0, 30, 103, 39, 128, 0, 0, 0, 0, 31, 151, 178, 0, 0, 0, 0, 0, 32, 89, 126,
        128, 0, 0, 0, 0, 33, 128, 206, 128, 0, 0, 0, 0, 34, 66, 155, 0, 0, 0, 0, 0, 35, 105, 235,
        0, 0, 0, 0, 0, 36, 34, 125, 0, 0, 0, 0, 0, 37, 73, 205, 0, 0, 0, 0, 0, 38, 2, 95, 0, 0, 0,
        0, 0, 39, 41, 175, 0, 0, 0, 0, 0, 39, 244, 182, 0, 0, 0, 0, 0, 40, 237, 225, 128, 0, 0, 0,
        0, 41, 212, 152, 0, 0, 0, 0, 0, 42, 205, 195, 128, 0, 0, 0, 0, 43, 180, 122, 0, 0, 0, 0, 0,
        44, 173, 165, 128, 0, 0, 0, 0, 45, 148, 92, 0, 0, 0, 0, 0, 46, 141, 135, 128, 0, 0, 0, 0,
        47, 116, 62, 0, 0, 0, 0, 0, 48, 109, 105, 128, 0, 0, 0, 0, 49, 93, 90, 128, 0, 0, 0, 0, 50,
        86, 134, 0, 0, 0, 0, 0, 51, 61, 60, 128, 0, 0, 0, 0, 52, 54, 104, 0, 0, 0, 0, 0, 53, 29,
        30, 128, 0, 0, 0, 0, 54, 22, 74, 0, 0, 0, 0, 0, 54, 253, 0, 128, 0, 0, 0, 0, 55, 246, 44,
        0, 0, 0, 0, 0, 56, 220, 226, 128, 0, 0, 0, 0, 57, 167, 233, 128, 0, 0, 0, 0, 58, 188, 196,
        128, 0, 0, 0, 0, 59, 191, 42, 128, 0, 0, 0, 0, 60, 165, 225, 0, 0, 0, 0, 0, 61, 159, 12,
        128, 0, 0, 0, 0, 62, 133, 195, 0, 0, 0, 0, 0, 63, 126, 238, 128, 0, 0, 0, 0, 64, 101, 165,
        0, 0, 0, 0, 0, 65, 94, 208, 128, 0, 0, 0, 0, 66, 69, 135, 0, 0, 0, 0, 0, 67, 62, 178, 128,
        0, 0, 0, 0, 68, 46, 163, 128, 0, 0, 0, 0, 69, 30, 148, 128, 0, 0, 0, 0, 70, 5, 75, 0, 0, 0,
        0, 0, 71, 7, 177, 0, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0, 0, 138, 28, 0, 0, 0, 0, 154, 176, 1, 4, 0, 0, 140, 160,
        0, 9, 76, 77, 84, 0, 65, 69, 68, 84, 0, 65, 69, 83, 84, 0, 10, 65, 69, 83, 84, 45, 49, 48,
        65, 69, 68, 84, 44, 77, 49, 48, 46, 49, 46, 48, 44, 77, 52, 46, 49, 46, 48, 47, 51, 10,
    ];
    pub(crate) const AustraliaDarwin: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        10, 0, 0, 0, 4, 0, 0, 0, 14, 255, 255, 255, 255, 115, 22, 146, 88, 255, 255, 255, 255, 123,
        18, 3, 112, 255, 255, 255, 255, 156, 78, 201, 136, 255, 255, 255, 255, 156, 188, 54, 8,
        255, 255, 255, 255, 203, 84, 186, 8, 255, 255, 255, 255, 203, 199, 108, 136, 255, 255, 255,
        255, 204, 183, 93, 136, 255, 255, 255, 255, 205, 167, 78, 136, 255, 255, 255, 255, 206,
        160, 122, 8, 255, 255, 255, 255, 207, 135, 48, 136, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 0, 0,
        122, 168, 0, 0, 0, 0, 126, 144, 0, 4, 0, 0, 147, 168, 1, 9, 0, 0, 133, 152, 0, 4, 76, 77,
        84, 0, 65, 67, 83, 84, 0, 65, 67, 68, 84, 0, 10, 65, 67, 83, 84, 45, 57, 58, 51, 48, 10,
    ];
    pub(crate) const AustraliaEucla: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        19, 0, 0, 0, 3, 0, 0, 0, 16, 255, 255, 255, 255, 116, 166, 10, 176, 255, 255, 255, 255,
        156, 78, 212, 20, 255, 255, 255, 255, 156, 188, 64, 148, 255, 255, 255, 255, 203, 84, 196,
        148, 255, 255, 255, 255, 203, 199, 119, 20, 255, 255, 255, 255, 204, 183, 104, 20, 255,
        255, 255, 255, 205, 167, 89, 20, 0, 0, 0, 0, 9, 15, 241, 20, 0, 0, 0, 0, 9, 182, 14, 20, 0,
        0, 0, 0, 26, 1, 88, 20, 0, 0, 0, 0, 26, 167, 117, 20, 0, 0, 0, 0, 41, 37, 82, 20, 0, 0, 0,
        0, 41, 175, 191, 148, 0, 0, 0, 0, 69, 113, 180, 148, 0, 0, 0, 0, 70, 5, 92, 148, 0, 0, 0,
        0, 71, 35, 114, 20, 0, 0, 0, 0, 71, 238, 121, 20, 0, 0, 0, 0, 73, 3, 84, 20, 0, 0, 0, 0,
        73, 206, 91, 20, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 0, 120, 208,
        0, 0, 0, 0, 137, 28, 1, 4, 0, 0, 123, 12, 0, 10, 76, 77, 84, 0, 43, 48, 57, 52, 53, 0, 43,
        48, 56, 52, 53, 0, 10, 60, 43, 48, 56, 52, 53, 62, 45, 56, 58, 52, 53, 10,
    ];
    pub(crate) const AustraliaLhi: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        56, 0, 0, 0, 5, 0, 0, 0, 25, 255, 255, 255, 255, 115, 22, 119, 220, 0, 0, 0, 0, 20, 254,
        102, 224, 0, 0, 0, 0, 22, 56, 64, 248, 0, 0, 0, 0, 22, 231, 138, 104, 0, 0, 0, 0, 24, 33,
        93, 120, 0, 0, 0, 0, 24, 199, 108, 104, 0, 0, 0, 0, 26, 1, 63, 120, 0, 0, 0, 0, 26, 167,
        78, 104, 0, 0, 0, 0, 27, 225, 33, 120, 0, 0, 0, 0, 28, 135, 48, 104, 0, 0, 0, 0, 29, 193,
        3, 120, 0, 0, 0, 0, 30, 121, 142, 112, 0, 0, 0, 0, 31, 151, 170, 248, 0, 0, 0, 0, 32, 89,
        112, 112, 0, 0, 0, 0, 33, 128, 199, 120, 0, 0, 0, 0, 34, 66, 140, 240, 0, 0, 0, 0, 35, 105,
        227, 248, 0, 0, 0, 0, 36, 34, 110, 240, 0, 0, 0, 0, 37, 73, 197, 248, 0, 0, 0, 0, 37, 239,
        219, 240, 0, 0, 0, 0, 39, 41, 167, 248, 0, 0, 0, 0, 39, 207, 189, 240, 0, 0, 0, 0, 41, 9,
        137, 248, 0, 0, 0, 0, 41, 175, 159, 240, 0, 0, 0, 0, 42, 233, 107, 248, 0, 0, 0, 0, 43,
        152, 188, 112, 0, 0, 0, 0, 44, 210, 136, 120, 0, 0, 0, 0, 45, 120, 158, 112, 0, 0, 0, 0,
        46, 178, 106, 120, 0, 0, 0, 0, 47, 88, 128, 112, 0, 0, 0, 0, 48, 146, 76, 120, 0, 0, 0, 0,
        49, 93, 76, 112, 0, 0, 0, 0, 50, 114, 46, 120, 0, 0, 0, 0, 51, 61, 46, 112, 0, 0, 0, 0, 52,
        82, 16, 120, 0, 0, 0, 0, 53, 29, 16, 112, 0, 0, 0, 0, 54, 49, 242, 120, 0, 0, 0, 0, 54,
        252, 242, 112, 0, 0, 0, 0, 56, 27, 14, 248, 0, 0, 0, 0, 56, 220, 212, 112, 0, 0, 0, 0, 57,
        167, 226, 120, 0, 0, 0, 0, 58, 188, 182, 112, 0, 0, 0, 0, 59, 218, 210, 248, 0, 0, 0, 0,
        60, 165, 210, 240, 0, 0, 0, 0, 61, 186, 180, 248, 0, 0, 0, 0, 62, 133, 180, 240, 0, 0, 0,
        0, 63, 154, 150, 248, 0, 0, 0, 0, 64, 101, 150, 240, 0, 0, 0, 0, 65, 131, 179, 120, 0, 0,
        0, 0, 66, 69, 120, 240, 0, 0, 0, 0, 67, 99, 149, 120, 0, 0, 0, 0, 68, 46, 149, 112, 0, 0,
        0, 0, 69, 67, 119, 120, 0, 0, 0, 0, 70, 5, 60, 240, 0, 0, 0, 0, 71, 35, 89, 120, 0, 0, 0,
        0, 71, 247, 147, 240, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4,
        3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4,
        3, 4, 3, 0, 0, 149, 36, 0, 0, 0, 0, 140, 160, 0, 4, 0, 0, 161, 184, 1, 9, 0, 0, 147, 168,
        0, 15, 0, 0, 154, 176, 1, 21, 76, 77, 84, 0, 65, 69, 83, 84, 0, 43, 49, 49, 51, 48, 0, 43,
        49, 48, 51, 48, 0, 43, 49, 49, 0, 10, 60, 43, 49, 48, 51, 48, 62, 45, 49, 48, 58, 51, 48,
        60, 43, 49, 49, 62, 45, 49, 49, 44, 77, 49, 48, 46, 49, 46, 48, 44, 77, 52, 46, 49, 46, 48,
        10,
    ];
    pub(crate) const AustraliaLindeman: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        21, 0, 0, 0, 3, 0, 0, 0, 14, 255, 255, 255, 255, 114, 237, 162, 212, 255, 255, 255, 255,
        156, 78, 194, 128, 255, 255, 255, 255, 156, 188, 47, 0, 255, 255, 255, 255, 203, 84, 179,
        0, 255, 255, 255, 255, 203, 199, 101, 128, 255, 255, 255, 255, 204, 183, 86, 128, 255, 255,
        255, 255, 205, 167, 71, 128, 255, 255, 255, 255, 206, 160, 115, 0, 255, 255, 255, 255, 207,
        135, 41, 128, 0, 0, 0, 0, 3, 112, 57, 128, 0, 0, 0, 0, 4, 13, 28, 0, 0, 0, 0, 0, 37, 73,
        205, 0, 0, 0, 0, 0, 37, 239, 234, 0, 0, 0, 0, 0, 39, 41, 175, 0, 0, 0, 0, 0, 39, 207, 204,
        0, 0, 0, 0, 0, 41, 9, 145, 0, 0, 0, 0, 0, 41, 175, 174, 0, 0, 0, 0, 0, 42, 233, 115, 0, 0,
        0, 0, 0, 43, 152, 202, 128, 0, 0, 0, 0, 44, 210, 143, 128, 0, 0, 0, 0, 45, 120, 172, 128,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 0, 139, 172, 0, 0, 0, 0,
        154, 176, 1, 4, 0, 0, 140, 160, 0, 9, 76, 77, 84, 0, 65, 69, 68, 84, 0, 65, 69, 83, 84, 0,
        10, 65, 69, 83, 84, 45, 49, 48, 10,
    ];
    pub(crate) const AustraliaMelbourne: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        83, 0, 0, 0, 3, 0, 0, 0, 14, 255, 255, 255, 255, 115, 22, 133, 24, 255, 255, 255, 255, 156,
        78, 194, 128, 255, 255, 255, 255, 156, 188, 47, 0, 255, 255, 255, 255, 203, 84, 179, 0,
        255, 255, 255, 255, 203, 199, 101, 128, 255, 255, 255, 255, 204, 183, 86, 128, 255, 255,
        255, 255, 205, 167, 71, 128, 255, 255, 255, 255, 206, 160, 115, 0, 255, 255, 255, 255, 207,
        135, 41, 128, 0, 0, 0, 0, 3, 112, 57, 128, 0, 0, 0, 0, 4, 13, 28, 0, 0, 0, 0, 0, 5, 80, 27,
        128, 0, 0, 0, 0, 5, 246, 56, 128, 0, 0, 0, 0, 7, 47, 253, 128, 0, 0, 0, 0, 7, 214, 26, 128,
        0, 0, 0, 0, 9, 15, 223, 128, 0, 0, 0, 0, 9, 181, 252, 128, 0, 0, 0, 0, 10, 239, 193, 128,
        0, 0, 0, 0, 11, 159, 25, 0, 0, 0, 0, 0, 12, 216, 222, 0, 0, 0, 0, 0, 13, 126, 251, 0, 0, 0,
        0, 0, 14, 184, 192, 0, 0, 0, 0, 0, 15, 94, 221, 0, 0, 0, 0, 0, 16, 152, 162, 0, 0, 0, 0, 0,
        17, 62, 191, 0, 0, 0, 0, 0, 18, 120, 132, 0, 0, 0, 0, 0, 19, 30, 161, 0, 0, 0, 0, 0, 20,
        88, 102, 0, 0, 0, 0, 0, 20, 254, 131, 0, 0, 0, 0, 0, 22, 56, 72, 0, 0, 0, 0, 0, 22, 231,
        159, 128, 0, 0, 0, 0, 24, 33, 100, 128, 0, 0, 0, 0, 24, 199, 129, 128, 0, 0, 0, 0, 26, 1,
        70, 128, 0, 0, 0, 0, 26, 167, 99, 128, 0, 0, 0, 0, 27, 225, 40, 128, 0, 0, 0, 0, 28, 135,
        69, 128, 0, 0, 0, 0, 29, 193, 10, 128, 0, 0, 0, 0, 30, 121, 156, 128, 0, 0, 0, 0, 31, 151,
        178, 0, 0, 0, 0, 0, 32, 89, 126, 128, 0, 0, 0, 0, 33, 119, 148, 0, 0, 0, 0, 0, 34, 66, 155,
        0, 0, 0, 0, 0, 35, 105, 235, 0, 0, 0, 0, 0, 36, 34, 125, 0, 0, 0, 0, 0, 37, 73, 205, 0, 0,
        0, 0, 0, 38, 2, 95, 0, 0, 0, 0, 0, 39, 41, 175, 0, 0, 0, 0, 0, 39, 207, 204, 0, 0, 0, 0, 0,
        41, 9, 145, 0, 0, 0, 0, 0, 41, 175, 174, 0, 0, 0, 0, 0, 42, 233, 115, 0, 0, 0, 0, 0, 43,
        152, 202, 128, 0, 0, 0, 0, 44, 210, 143, 128, 0, 0, 0, 0, 45, 120, 172, 128, 0, 0, 0, 0,
        46, 178, 113, 128, 0, 0, 0, 0, 47, 116, 62, 0, 0, 0, 0, 0, 48, 146, 83, 128, 0, 0, 0, 0,
        49, 93, 90, 128, 0, 0, 0, 0, 50, 114, 53, 128, 0, 0, 0, 0, 51, 61, 60, 128, 0, 0, 0, 0, 52,
        82, 23, 128, 0, 0, 0, 0, 53, 29, 30, 128, 0, 0, 0, 0, 54, 49, 249, 128, 0, 0, 0, 0, 54,
        253, 0, 128, 0, 0, 0, 0, 56, 27, 22, 0, 0, 0, 0, 0, 56, 220, 226, 128, 0, 0, 0, 0, 57, 167,
        233, 128, 0, 0, 0, 0, 58, 188, 196, 128, 0, 0, 0, 0, 59, 218, 218, 0, 0, 0, 0, 0, 60, 165,
        225, 0, 0, 0, 0, 0, 61, 186, 188, 0, 0, 0, 0, 0, 62, 133, 195, 0, 0, 0, 0, 0, 63, 154, 158,
        0, 0, 0, 0, 0, 64, 101, 165, 0, 0, 0, 0, 0, 65, 131, 186, 128, 0, 0, 0, 0, 66, 69, 135, 0,
        0, 0, 0, 0, 67, 99, 156, 128, 0, 0, 0, 0, 68, 46, 163, 128, 0, 0, 0, 0, 69, 67, 126, 128,
        0, 0, 0, 0, 70, 5, 75, 0, 0, 0, 0, 0, 71, 35, 96, 128, 0, 0, 0, 0, 71, 247, 162, 0, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 0, 135, 232, 0, 0, 0, 0,
        154, 176, 1, 4, 0, 0, 140, 160, 0, 9, 76, 77, 84, 0, 65, 69, 68, 84, 0, 65, 69, 83, 84, 0,
        10, 65, 69, 83, 84, 45, 49, 48, 65, 69, 68, 84, 44, 77, 49, 48, 46, 49, 46, 48, 44, 77, 52,
        46, 49, 46, 48, 47, 51, 10,
    ];
    pub(crate) const AustraliaPerth: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        19, 0, 0, 0, 3, 0, 0, 0, 14, 255, 255, 255, 255, 116, 166, 22, 228, 255, 255, 255, 255,
        156, 78, 222, 160, 255, 255, 255, 255, 156, 188, 75, 32, 255, 255, 255, 255, 203, 84, 207,
        32, 255, 255, 255, 255, 203, 199, 129, 160, 255, 255, 255, 255, 204, 183, 114, 160, 255,
        255, 255, 255, 205, 167, 99, 160, 0, 0, 0, 0, 9, 15, 251, 160, 0, 0, 0, 0, 9, 182, 24, 160,
        0, 0, 0, 0, 26, 1, 98, 160, 0, 0, 0, 0, 26, 167, 127, 160, 0, 0, 0, 0, 41, 37, 92, 160, 0,
        0, 0, 0, 41, 175, 202, 32, 0, 0, 0, 0, 69, 113, 191, 32, 0, 0, 0, 0, 70, 5, 103, 32, 0, 0,
        0, 0, 71, 35, 124, 160, 0, 0, 0, 0, 71, 238, 131, 160, 0, 0, 0, 0, 73, 3, 94, 160, 0, 0, 0,
        0, 73, 206, 101, 160, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 0, 108,
        156, 0, 0, 0, 0, 126, 144, 1, 4, 0, 0, 112, 128, 0, 9, 76, 77, 84, 0, 65, 87, 68, 84, 0,
        65, 87, 83, 84, 0, 10, 65, 87, 83, 84, 45, 56, 10,
    ];
    pub(crate) const Cet: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        53, 0, 0, 0, 2, 0, 0, 0, 9, 255, 255, 255, 255, 155, 12, 23, 96, 255, 255, 255, 255, 155,
        213, 218, 240, 255, 255, 255, 255, 156, 217, 174, 144, 255, 255, 255, 255, 157, 164, 181,
        144, 255, 255, 255, 255, 158, 185, 144, 144, 255, 255, 255, 255, 159, 132, 151, 144, 255,
        255, 255, 255, 200, 9, 113, 144, 255, 255, 255, 255, 204, 231, 75, 16, 255, 255, 255, 255,
        205, 169, 23, 144, 255, 255, 255, 255, 206, 162, 67, 16, 255, 255, 255, 255, 207, 146, 52,
        16, 255, 255, 255, 255, 208, 130, 37, 16, 255, 255, 255, 255, 209, 114, 22, 16, 255, 255,
        255, 255, 210, 78, 64, 144, 0, 0, 0, 0, 13, 164, 99, 144, 0, 0, 0, 0, 14, 139, 26, 16, 0,
        0, 0, 0, 15, 132, 69, 144, 0, 0, 0, 0, 16, 116, 54, 144, 0, 0, 0, 0, 17, 100, 39, 144, 0,
        0, 0, 0, 18, 84, 24, 144, 0, 0, 0, 0, 19, 77, 68, 16, 0, 0, 0, 0, 20, 51, 250, 144, 0, 0,
        0, 0, 21, 35, 235, 144, 0, 0, 0, 0, 22, 19, 220, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0,
        0, 23, 243, 190, 144, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0,
        0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0,
        0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0,
        0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0,
        35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12,
        24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37,
        144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248,
        144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132,
        203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93,
        217, 16, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 14, 16,
        0, 5, 0, 0, 28, 32, 1, 0, 67, 69, 83, 84, 0, 67, 69, 84, 0, 10, 67, 69, 84, 45, 49, 67, 69,
        83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const ChileEasterIsland: &[u8] = &[
        84, 90, 105, 102, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 51,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        102, 0, 0, 0, 6, 0, 0, 0, 20, 255, 255, 255, 255, 105, 135, 66, 8, 255, 255, 255, 255, 185,
        199, 64, 136, 255, 255, 255, 255, 253, 209, 60, 64, 255, 255, 255, 255, 254, 146, 250, 176,
        255, 255, 255, 255, 255, 204, 205, 192, 0, 0, 0, 0, 0, 114, 220, 176, 0, 0, 0, 0, 1, 117,
        80, 192, 0, 0, 0, 0, 2, 64, 73, 176, 0, 0, 0, 0, 3, 85, 50, 192, 0, 0, 0, 0, 4, 32, 43,
        176, 0, 0, 0, 0, 5, 62, 79, 64, 0, 0, 0, 0, 6, 0, 13, 176, 0, 0, 0, 0, 7, 11, 188, 64, 0,
        0, 0, 0, 7, 223, 239, 176, 0, 0, 0, 0, 8, 254, 19, 64, 0, 0, 0, 0, 9, 191, 209, 176, 0, 0,
        0, 0, 10, 221, 245, 64, 0, 0, 0, 0, 11, 168, 238, 48, 0, 0, 0, 0, 12, 189, 215, 64, 0, 0,
        0, 0, 13, 136, 208, 48, 0, 0, 0, 0, 14, 157, 185, 64, 0, 0, 0, 0, 15, 104, 178, 48, 0, 0,
        0, 0, 16, 134, 213, 192, 0, 0, 0, 0, 17, 72, 148, 48, 0, 0, 0, 0, 18, 102, 183, 192, 0, 0,
        0, 0, 19, 40, 118, 48, 0, 0, 0, 0, 20, 70, 153, 192, 0, 0, 0, 0, 21, 17, 146, 176, 0, 0, 0,
        0, 22, 38, 123, 192, 0, 0, 0, 0, 22, 241, 116, 176, 0, 0, 0, 0, 24, 6, 93, 192, 0, 0, 0, 0,
        24, 209, 86, 176, 0, 0, 0, 0, 25, 230, 63, 192, 0, 0, 0, 0, 26, 177, 56, 176, 0, 0, 0, 0,
        27, 207, 92, 64, 0, 0, 0, 0, 28, 145, 26, 176, 0, 0, 0, 0, 29, 175, 62, 64, 0, 0, 0, 0, 30,
        112, 252, 176, 0, 0, 0, 0, 31, 143, 32, 64, 0, 0, 0, 0, 32, 127, 3, 48, 0, 0, 0, 0, 33,
        111, 2, 64, 0, 0, 0, 0, 34, 57, 251, 48, 0, 0, 0, 0, 35, 78, 228, 64, 0, 0, 0, 0, 36, 25,
        221, 48, 0, 0, 0, 0, 37, 56, 0, 192, 0, 0, 0, 0, 37, 249, 191, 48, 0, 0, 0, 0, 38, 242,
        248, 192, 0, 0, 0, 0, 39, 217, 161, 48, 0, 0, 0, 0, 40, 247, 196, 192, 0, 0, 0, 0, 41, 194,
        189, 176, 0, 0, 0, 0, 42, 215, 166, 192, 0, 0, 0, 0, 43, 162, 159, 176, 0, 0, 0, 0, 44,
        183, 136, 192, 0, 0, 0, 0, 45, 130, 129, 176, 0, 0, 0, 0, 46, 151, 106, 192, 0, 0, 0, 0,
        47, 98, 99, 176, 0, 0, 0, 0, 48, 128, 135, 64, 0, 0, 0, 0, 49, 66, 69, 176, 0, 0, 0, 0, 50,
        96, 105, 64, 0, 0, 0, 0, 51, 61, 215, 48, 0, 0, 0, 0, 52, 64, 75, 64, 0, 0, 0, 0, 53, 11,
        68, 48, 0, 0, 0, 0, 54, 13, 184, 64, 0, 0, 0, 0, 55, 6, 213, 176, 0, 0, 0, 0, 56, 0, 15,
        64, 0, 0, 0, 0, 56, 203, 8, 48, 0, 0, 0, 0, 57, 233, 43, 192, 0, 0, 0, 0, 58, 170, 234, 48,
        0, 0, 0, 0, 59, 201, 13, 192, 0, 0, 0, 0, 60, 138, 204, 48, 0, 0, 0, 0, 61, 168, 239, 192,
        0, 0, 0, 0, 62, 106, 174, 48, 0, 0, 0, 0, 63, 136, 209, 192, 0, 0, 0, 0, 64, 83, 202, 176,
        0, 0, 0, 0, 65, 104, 179, 192, 0, 0, 0, 0, 66, 51, 172, 176, 0, 0, 0, 0, 67, 72, 149, 192,
        0, 0, 0, 0, 68, 19, 142, 176, 0, 0, 0, 0, 69, 49, 178, 64, 0, 0, 0, 0, 69, 243, 112, 176,
        0, 0, 0, 0, 71, 17, 148, 64, 0, 0, 0, 0, 71, 239, 2, 48, 0, 0, 0, 0, 72, 241, 118, 64, 0,
        0, 0, 0, 73, 188, 111, 48, 0, 0, 0, 0, 74, 209, 88, 64, 0, 0, 0, 0, 75, 184, 0, 176, 0, 0,
        0, 0, 76, 177, 58, 64, 0, 0, 0, 0, 77, 198, 7, 48, 0, 0, 0, 0, 78, 80, 130, 192, 0, 0, 0,
        0, 79, 156, 174, 176, 0, 0, 0, 0, 80, 66, 217, 192, 0, 0, 0, 0, 81, 124, 144, 176, 0, 0, 0,
        0, 82, 43, 246, 64, 0, 0, 0, 0, 83, 92, 114, 176, 0, 0, 0, 0, 84, 11, 216, 64, 0, 0, 0, 0,
        87, 55, 230, 48, 0, 0, 0, 0, 87, 175, 236, 192, 0, 0, 0, 0, 89, 23, 200, 48, 0, 0, 0, 0,
        89, 143, 206, 192, 0, 0, 0, 0, 90, 247, 170, 48, 0, 0, 0, 0, 91, 111, 176, 192, 0, 0, 0, 0,
        92, 169, 103, 176, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4,
        5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4,
        5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 255, 255, 153, 120, 0, 0, 255, 255,
        153, 120, 0, 4, 255, 255, 171, 160, 1, 8, 255, 255, 157, 144, 0, 12, 255, 255, 171, 160, 0,
        8, 255, 255, 185, 176, 1, 16, 76, 77, 84, 0, 69, 77, 84, 0, 45, 48, 54, 0, 45, 48, 55, 0,
        45, 48, 53, 0, 10, 60, 45, 48, 54, 62, 54, 60, 45, 48, 53, 62, 44, 77, 57, 46, 49, 46, 54,
        47, 50, 50, 44, 77, 52, 46, 49, 46, 54, 47, 50, 50, 10,
    ];
    pub(crate) const Cst6Cdt: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        88, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 158, 166, 44, 128, 255, 255, 255, 255,
        159, 186, 249, 112, 255, 255, 255, 255, 160, 134, 14, 128, 255, 255, 255, 255, 161, 154,
        219, 112, 255, 255, 255, 255, 203, 136, 254, 128, 255, 255, 255, 255, 210, 35, 244, 112,
        255, 255, 255, 255, 210, 97, 9, 240, 255, 255, 255, 255, 250, 248, 103, 0, 255, 255, 255,
        255, 251, 232, 73, 240, 255, 255, 255, 255, 252, 216, 73, 0, 255, 255, 255, 255, 253, 200,
        43, 240, 255, 255, 255, 255, 254, 184, 43, 0, 255, 255, 255, 255, 255, 168, 13, 240, 0, 0,
        0, 0, 0, 152, 13, 0, 0, 0, 0, 0, 1, 135, 239, 240, 0, 0, 0, 0, 2, 119, 239, 0, 0, 0, 0, 0,
        3, 113, 12, 112, 0, 0, 0, 0, 4, 97, 11, 128, 0, 0, 0, 0, 5, 80, 238, 112, 0, 0, 0, 0, 6,
        64, 237, 128, 0, 0, 0, 0, 7, 48, 208, 112, 0, 0, 0, 0, 7, 141, 39, 128, 0, 0, 0, 0, 9, 16,
        178, 112, 0, 0, 0, 0, 9, 173, 163, 0, 0, 0, 0, 0, 10, 240, 148, 112, 0, 0, 0, 0, 11, 224,
        147, 128, 0, 0, 0, 0, 12, 217, 176, 240, 0, 0, 0, 0, 13, 192, 117, 128, 0, 0, 0, 0, 14,
        185, 146, 240, 0, 0, 0, 0, 15, 169, 146, 0, 0, 0, 0, 0, 16, 153, 116, 240, 0, 0, 0, 0, 17,
        137, 116, 0, 0, 0, 0, 0, 18, 121, 86, 240, 0, 0, 0, 0, 19, 105, 86, 0, 0, 0, 0, 0, 20, 89,
        56, 240, 0, 0, 0, 0, 21, 73, 56, 0, 0, 0, 0, 0, 22, 57, 26, 240, 0, 0, 0, 0, 23, 41, 26, 0,
        0, 0, 0, 0, 24, 34, 55, 112, 0, 0, 0, 0, 25, 8, 252, 0, 0, 0, 0, 0, 26, 2, 25, 112, 0, 0,
        0, 0, 26, 242, 24, 128, 0, 0, 0, 0, 27, 225, 251, 112, 0, 0, 0, 0, 28, 209, 250, 128, 0, 0,
        0, 0, 29, 193, 221, 112, 0, 0, 0, 0, 30, 177, 220, 128, 0, 0, 0, 0, 31, 161, 191, 112, 0,
        0, 0, 0, 32, 118, 15, 0, 0, 0, 0, 0, 33, 129, 161, 112, 0, 0, 0, 0, 34, 85, 241, 0, 0, 0,
        0, 0, 35, 106, 189, 240, 0, 0, 0, 0, 36, 53, 211, 0, 0, 0, 0, 0, 37, 74, 159, 240, 0, 0, 0,
        0, 38, 21, 181, 0, 0, 0, 0, 0, 39, 42, 129, 240, 0, 0, 0, 0, 39, 254, 209, 128, 0, 0, 0, 0,
        41, 10, 99, 240, 0, 0, 0, 0, 41, 222, 179, 128, 0, 0, 0, 0, 42, 234, 69, 240, 0, 0, 0, 0,
        43, 190, 149, 128, 0, 0, 0, 0, 44, 211, 98, 112, 0, 0, 0, 0, 45, 158, 119, 128, 0, 0, 0, 0,
        46, 179, 68, 112, 0, 0, 0, 0, 47, 126, 89, 128, 0, 0, 0, 0, 48, 147, 38, 112, 0, 0, 0, 0,
        49, 103, 118, 0, 0, 0, 0, 0, 50, 115, 8, 112, 0, 0, 0, 0, 51, 71, 88, 0, 0, 0, 0, 0, 52,
        82, 234, 112, 0, 0, 0, 0, 53, 39, 58, 0, 0, 0, 0, 0, 54, 50, 204, 112, 0, 0, 0, 0, 55, 7,
        28, 0, 0, 0, 0, 0, 56, 27, 232, 240, 0, 0, 0, 0, 56, 230, 254, 0, 0, 0, 0, 0, 57, 251, 202,
        240, 0, 0, 0, 0, 58, 198, 224, 0, 0, 0, 0, 0, 59, 219, 172, 240, 0, 0, 0, 0, 60, 175, 252,
        128, 0, 0, 0, 0, 61, 187, 142, 240, 0, 0, 0, 0, 62, 143, 222, 128, 0, 0, 0, 0, 63, 155,
        112, 240, 0, 0, 0, 0, 64, 111, 192, 128, 0, 0, 0, 0, 65, 132, 141, 112, 0, 0, 0, 0, 66, 79,
        162, 128, 0, 0, 0, 0, 67, 100, 111, 112, 0, 0, 0, 0, 68, 47, 132, 128, 0, 0, 0, 0, 69, 68,
        81, 112, 0, 0, 0, 0, 69, 243, 183, 0, 1, 0, 1, 0, 2, 3, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 255, 255, 171, 160, 0, 4, 255, 255, 185, 176, 1, 0, 255, 255,
        185, 176, 1, 8, 255, 255, 185, 176, 1, 12, 67, 68, 84, 0, 67, 83, 84, 0, 67, 87, 84, 0, 67,
        80, 84, 0, 10, 67, 83, 84, 54, 67, 68, 84, 44, 77, 51, 46, 50, 46, 48, 44, 77, 49, 49, 46,
        49, 46, 48, 10,
    ];
    pub(crate) const Eet: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        39, 0, 0, 0, 2, 0, 0, 0, 9, 0, 0, 0, 0, 13, 164, 99, 144, 0, 0, 0, 0, 14, 139, 26, 16, 0,
        0, 0, 0, 15, 132, 69, 144, 0, 0, 0, 0, 16, 116, 54, 144, 0, 0, 0, 0, 17, 100, 39, 144, 0,
        0, 0, 0, 18, 84, 24, 144, 0, 0, 0, 0, 19, 77, 68, 16, 0, 0, 0, 0, 20, 51, 250, 144, 0, 0,
        0, 0, 21, 35, 235, 144, 0, 0, 0, 0, 22, 19, 220, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0,
        0, 23, 243, 190, 144, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0,
        0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0,
        0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0,
        0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0,
        35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12,
        24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37,
        144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248,
        144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132,
        203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93,
        217, 16, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
        0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 28, 32, 0, 5, 0, 0, 42, 48, 1, 0, 69, 69, 83, 84,
        0, 69, 69, 84, 0, 10, 69, 69, 84, 45, 50, 69, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 47,
        51, 44, 77, 49, 48, 46, 53, 46, 48, 47, 52, 10,
    ];
    pub(crate) const Eire: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        145, 0, 0, 0, 8, 0, 0, 0, 20, 255, 255, 255, 255, 87, 209, 10, 220, 255, 255, 255, 255,
        155, 38, 179, 145, 255, 255, 255, 255, 155, 214, 11, 17, 255, 255, 255, 255, 156, 207, 48,
        160, 255, 255, 255, 255, 157, 164, 195, 160, 255, 255, 255, 255, 158, 156, 157, 160, 255,
        255, 255, 255, 159, 151, 26, 160, 255, 255, 255, 255, 160, 133, 186, 32, 255, 255, 255,
        255, 161, 118, 252, 160, 255, 255, 255, 255, 162, 101, 156, 32, 255, 255, 255, 255, 163,
        123, 200, 160, 255, 255, 255, 255, 164, 78, 184, 160, 255, 255, 255, 255, 165, 63, 251, 32,
        255, 255, 255, 255, 166, 37, 96, 32, 255, 255, 255, 255, 167, 39, 198, 32, 255, 255, 255,
        255, 168, 42, 44, 32, 255, 255, 255, 255, 168, 235, 248, 160, 255, 255, 255, 255, 170, 0,
        211, 160, 255, 255, 255, 255, 170, 213, 21, 32, 255, 255, 255, 255, 171, 233, 240, 32, 255,
        255, 255, 255, 172, 199, 108, 32, 255, 255, 255, 255, 173, 201, 210, 32, 255, 255, 255,
        255, 174, 167, 78, 32, 255, 255, 255, 255, 175, 160, 121, 160, 255, 255, 255, 255, 176,
        135, 48, 32, 255, 255, 255, 255, 177, 146, 208, 160, 255, 255, 255, 255, 178, 112, 76, 160,
        255, 255, 255, 255, 179, 114, 178, 160, 255, 255, 255, 255, 180, 80, 46, 160, 255, 255,
        255, 255, 181, 73, 90, 32, 255, 255, 255, 255, 182, 48, 16, 160, 255, 255, 255, 255, 183,
        50, 118, 160, 255, 255, 255, 255, 184, 15, 242, 160, 255, 255, 255, 255, 185, 18, 88, 160,
        255, 255, 255, 255, 185, 239, 212, 160, 255, 255, 255, 255, 186, 233, 0, 32, 255, 255, 255,
        255, 187, 216, 241, 32, 255, 255, 255, 255, 188, 219, 87, 32, 255, 255, 255, 255, 189, 184,
        211, 32, 255, 255, 255, 255, 190, 177, 254, 160, 255, 255, 255, 255, 191, 152, 181, 32,
        255, 255, 255, 255, 192, 155, 27, 32, 255, 255, 255, 255, 193, 120, 151, 32, 255, 255, 255,
        255, 194, 122, 253, 32, 255, 255, 255, 255, 195, 88, 121, 32, 255, 255, 255, 255, 196, 81,
        164, 160, 255, 255, 255, 255, 197, 56, 91, 32, 255, 255, 255, 255, 198, 58, 193, 32, 255,
        255, 255, 255, 199, 88, 214, 160, 255, 255, 255, 255, 199, 218, 9, 160, 255, 255, 255, 255,
        212, 73, 224, 32, 255, 255, 255, 255, 213, 30, 33, 160, 255, 255, 255, 255, 214, 78, 172,
        32, 255, 255, 255, 255, 215, 44, 40, 32, 255, 255, 255, 255, 216, 46, 142, 32, 255, 255,
        255, 255, 216, 249, 149, 32, 255, 255, 255, 255, 218, 14, 112, 32, 255, 255, 255, 255, 218,
        235, 236, 32, 255, 255, 255, 255, 219, 229, 23, 160, 255, 255, 255, 255, 220, 203, 206, 32,
        255, 255, 255, 255, 221, 196, 249, 160, 255, 255, 255, 255, 222, 180, 234, 160, 255, 255,
        255, 255, 223, 174, 22, 32, 255, 255, 255, 255, 224, 148, 204, 160, 255, 255, 255, 255,
        225, 114, 72, 160, 255, 255, 255, 255, 226, 107, 116, 32, 255, 255, 255, 255, 227, 82, 42,
        160, 255, 255, 255, 255, 228, 84, 144, 160, 255, 255, 255, 255, 229, 50, 12, 160, 255, 255,
        255, 255, 230, 61, 173, 32, 255, 255, 255, 255, 231, 27, 41, 32, 255, 255, 255, 255, 232,
        20, 84, 160, 255, 255, 255, 255, 232, 251, 11, 32, 255, 255, 255, 255, 233, 253, 113, 32,
        255, 255, 255, 255, 234, 218, 237, 32, 255, 255, 255, 255, 235, 221, 83, 32, 255, 255, 255,
        255, 236, 186, 207, 32, 255, 255, 255, 255, 237, 179, 250, 160, 255, 255, 255, 255, 238,
        154, 177, 32, 255, 255, 255, 255, 239, 129, 103, 160, 255, 255, 255, 255, 240, 159, 125,
        32, 255, 255, 255, 255, 241, 97, 73, 160, 255, 255, 255, 255, 242, 127, 95, 32, 255, 255,
        255, 255, 243, 74, 102, 32, 255, 255, 255, 255, 244, 95, 65, 32, 255, 255, 255, 255, 245,
        33, 13, 160, 255, 255, 255, 255, 246, 63, 35, 32, 255, 255, 255, 255, 247, 0, 239, 160,
        255, 255, 255, 255, 248, 31, 5, 32, 255, 255, 255, 255, 248, 224, 209, 160, 255, 255, 255,
        255, 249, 254, 231, 32, 255, 255, 255, 255, 250, 192, 179, 160, 255, 255, 255, 255, 251,
        232, 3, 160, 255, 255, 255, 255, 252, 123, 171, 160, 255, 255, 255, 255, 253, 199, 187,
        112, 0, 0, 0, 0, 3, 112, 198, 32, 0, 0, 0, 0, 4, 41, 88, 32, 0, 0, 0, 0, 5, 80, 168, 32, 0,
        0, 0, 0, 6, 9, 58, 32, 0, 0, 0, 0, 7, 48, 138, 32, 0, 0, 0, 0, 7, 233, 28, 32, 0, 0, 0, 0,
        9, 16, 108, 32, 0, 0, 0, 0, 9, 200, 254, 32, 0, 0, 0, 0, 10, 240, 78, 32, 0, 0, 0, 0, 11,
        178, 26, 160, 0, 0, 0, 0, 12, 208, 48, 32, 0, 0, 0, 0, 13, 145, 252, 160, 0, 0, 0, 0, 14,
        176, 18, 32, 0, 0, 0, 0, 15, 113, 222, 160, 0, 0, 0, 0, 16, 153, 46, 160, 0, 0, 0, 0, 17,
        81, 192, 160, 0, 0, 0, 0, 18, 121, 16, 160, 0, 0, 0, 0, 19, 49, 162, 160, 0, 0, 0, 0, 20,
        88, 242, 160, 0, 0, 0, 0, 21, 35, 235, 144, 0, 0, 0, 0, 22, 56, 198, 144, 0, 0, 0, 0, 23,
        3, 205, 144, 0, 0, 0, 0, 24, 24, 168, 144, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25,
        248, 138, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 225, 167, 16, 0, 0, 0, 0, 28,
        172, 174, 16, 0, 0, 0, 0, 29, 193, 137, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31,
        161, 107, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 129, 77, 16, 0, 0, 0, 0, 34,
        76, 84, 16, 0, 0, 0, 0, 35, 97, 47, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 74, 75,
        144, 0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 42, 45, 144, 0, 0, 0, 0, 39, 245, 52, 144,
        0, 0, 0, 0, 41, 10, 15, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 233, 241, 144,
        0, 0, 0, 0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 201, 211, 144, 0, 0, 0, 0, 45, 148, 218,
        144, 0, 0, 0, 0, 46, 169, 181, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 137,
        151, 144, 0, 0, 0, 0, 49, 93, 217, 16, 1, 2, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 5, 4, 5, 4,
        5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4,
        5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4,
        5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7,
        6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7, 6, 7,
        6, 7, 6, 7, 6, 7, 6, 7, 255, 255, 250, 36, 0, 0, 255, 255, 250, 15, 0, 4, 0, 0, 8, 31, 1,
        8, 0, 0, 14, 16, 1, 12, 0, 0, 0, 0, 0, 16, 0, 0, 14, 16, 1, 8, 0, 0, 0, 0, 1, 16, 0, 0, 14,
        16, 0, 8, 76, 77, 84, 0, 68, 77, 84, 0, 73, 83, 84, 0, 66, 83, 84, 0, 71, 77, 84, 0, 10,
        73, 83, 84, 45, 49, 71, 77, 84, 48, 44, 77, 49, 48, 46, 53, 46, 48, 44, 77, 51, 46, 53, 46,
        48, 47, 49, 10,
    ];
    pub(crate) const Est: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 255, 255, 185, 176, 0, 0, 69, 83, 84, 0, 10, 69, 83, 84, 53, 10,
    ];
    pub(crate) const Est5Edt: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        88, 0, 0, 0, 4, 0, 0, 0, 16, 255, 255, 255, 255, 158, 166, 30, 112, 255, 255, 255, 255,
        159, 186, 235, 96, 255, 255, 255, 255, 160, 134, 0, 112, 255, 255, 255, 255, 161, 154, 205,
        96, 255, 255, 255, 255, 203, 136, 240, 112, 255, 255, 255, 255, 210, 35, 244, 112, 255,
        255, 255, 255, 210, 96, 251, 224, 255, 255, 255, 255, 250, 248, 88, 240, 255, 255, 255,
        255, 251, 232, 59, 224, 255, 255, 255, 255, 252, 216, 58, 240, 255, 255, 255, 255, 253,
        200, 29, 224, 255, 255, 255, 255, 254, 184, 28, 240, 255, 255, 255, 255, 255, 167, 255,
        224, 0, 0, 0, 0, 0, 151, 254, 240, 0, 0, 0, 0, 1, 135, 225, 224, 0, 0, 0, 0, 2, 119, 224,
        240, 0, 0, 0, 0, 3, 112, 254, 96, 0, 0, 0, 0, 4, 96, 253, 112, 0, 0, 0, 0, 5, 80, 224, 96,
        0, 0, 0, 0, 6, 64, 223, 112, 0, 0, 0, 0, 7, 48, 194, 96, 0, 0, 0, 0, 7, 141, 25, 112, 0, 0,
        0, 0, 9, 16, 164, 96, 0, 0, 0, 0, 9, 173, 148, 240, 0, 0, 0, 0, 10, 240, 134, 96, 0, 0, 0,
        0, 11, 224, 133, 112, 0, 0, 0, 0, 12, 217, 162, 224, 0, 0, 0, 0, 13, 192, 103, 112, 0, 0,
        0, 0, 14, 185, 132, 224, 0, 0, 0, 0, 15, 169, 131, 240, 0, 0, 0, 0, 16, 153, 102, 224, 0,
        0, 0, 0, 17, 137, 101, 240, 0, 0, 0, 0, 18, 121, 72, 224, 0, 0, 0, 0, 19, 105, 71, 240, 0,
        0, 0, 0, 20, 89, 42, 224, 0, 0, 0, 0, 21, 73, 41, 240, 0, 0, 0, 0, 22, 57, 12, 224, 0, 0,
        0, 0, 23, 41, 11, 240, 0, 0, 0, 0, 24, 34, 41, 96, 0, 0, 0, 0, 25, 8, 237, 240, 0, 0, 0, 0,
        26, 2, 11, 96, 0, 0, 0, 0, 26, 242, 10, 112, 0, 0, 0, 0, 27, 225, 237, 96, 0, 0, 0, 0, 28,
        209, 236, 112, 0, 0, 0, 0, 29, 193, 207, 96, 0, 0, 0, 0, 30, 177, 206, 112, 0, 0, 0, 0, 31,
        161, 177, 96, 0, 0, 0, 0, 32, 118, 0, 240, 0, 0, 0, 0, 33, 129, 147, 96, 0, 0, 0, 0, 34,
        85, 226, 240, 0, 0, 0, 0, 35, 106, 175, 224, 0, 0, 0, 0, 36, 53, 196, 240, 0, 0, 0, 0, 37,
        74, 145, 224, 0, 0, 0, 0, 38, 21, 166, 240, 0, 0, 0, 0, 39, 42, 115, 224, 0, 0, 0, 0, 39,
        254, 195, 112, 0, 0, 0, 0, 41, 10, 85, 224, 0, 0, 0, 0, 41, 222, 165, 112, 0, 0, 0, 0, 42,
        234, 55, 224, 0, 0, 0, 0, 43, 190, 135, 112, 0, 0, 0, 0, 44, 211, 84, 96, 0, 0, 0, 0, 45,
        158, 105, 112, 0, 0, 0, 0, 46, 179, 54, 96, 0, 0, 0, 0, 47, 126, 75, 112, 0, 0, 0, 0, 48,
        147, 24, 96, 0, 0, 0, 0, 49, 103, 103, 240, 0, 0, 0, 0, 50, 114, 250, 96, 0, 0, 0, 0, 51,
        71, 73, 240, 0, 0, 0, 0, 52, 82, 220, 96, 0, 0, 0, 0, 53, 39, 43, 240, 0, 0, 0, 0, 54, 50,
        190, 96, 0, 0, 0, 0, 55, 7, 13, 240, 0, 0, 0, 0, 56, 27, 218, 224, 0, 0, 0, 0, 56, 230,
        239, 240, 0, 0, 0, 0, 57, 251, 188, 224, 0, 0, 0, 0, 58, 198, 209, 240, 0, 0, 0, 0, 59,
        219, 158, 224, 0, 0, 0, 0, 60, 175, 238, 112, 0, 0, 0, 0, 61, 187, 128, 224, 0, 0, 0, 0,
        62, 143, 208, 112, 0, 0, 0, 0, 63, 155, 98, 224, 0, 0, 0, 0, 64, 111, 178, 112, 0, 0, 0, 0,
        65, 132, 127, 96, 0, 0, 0, 0, 66, 79, 148, 112, 0, 0, 0, 0, 67, 100, 97, 96, 0, 0, 0, 0,
        68, 47, 118, 112, 0, 0, 0, 0, 69, 68, 67, 96, 0, 0, 0, 0, 69, 243, 168, 240, 1, 0, 1, 0, 2,
        3, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0,
        1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 255, 255, 185, 176, 0,
        4, 255, 255, 199, 192, 1, 0, 255, 255, 199, 192, 1, 8, 255, 255, 199, 192, 1, 12, 69, 68,
        84, 0, 69, 83, 84, 0, 69, 87, 84, 0, 69, 80, 84, 0, 10, 69, 83, 84, 53, 69, 68, 84, 44, 77,
        51, 46, 50, 46, 48, 44, 77, 49, 49, 46, 49, 46, 48, 10,
    ];
    pub(crate) const EtcGmt: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 71, 77, 84, 0, 10, 71, 77, 84, 48, 10,
    ];
    pub(crate) const EtcGmtMinus1: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 14, 16, 0, 0, 43, 48, 49, 0, 10, 60, 43, 48, 49, 62, 45,
        49, 10,
    ];
    pub(crate) const EtcGmtMinus10: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 140, 160, 0, 0, 43, 49, 48, 0, 10, 60, 43, 49, 48, 62, 45,
        49, 48, 10,
    ];
    pub(crate) const EtcGmtMinus11: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 154, 176, 0, 0, 43, 49, 49, 0, 10, 60, 43, 49, 49, 62, 45,
        49, 49, 10,
    ];
    pub(crate) const EtcGmtMinus12: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 168, 192, 0, 0, 43, 49, 50, 0, 10, 60, 43, 49, 50, 62, 45,
        49, 50, 10,
    ];
    pub(crate) const EtcGmtMinus13: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 182, 208, 0, 0, 43, 49, 51, 0, 10, 60, 43, 49, 51, 62, 45,
        49, 51, 10,
    ];
    pub(crate) const EtcGmtMinus14: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 196, 224, 0, 0, 43, 49, 52, 0, 10, 60, 43, 49, 52, 62, 45,
        49, 52, 10,
    ];
    pub(crate) const EtcGmtMinus2: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 28, 32, 0, 0, 43, 48, 50, 0, 10, 60, 43, 48, 50, 62, 45,
        50, 10,
    ];
    pub(crate) const EtcGmtMinus3: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 42, 48, 0, 0, 43, 48, 51, 0, 10, 60, 43, 48, 51, 62, 45,
        51, 10,
    ];
    pub(crate) const EtcGmtMinus4: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 56, 64, 0, 0, 43, 48, 52, 0, 10, 60, 43, 48, 52, 62, 45,
        52, 10,
    ];
    pub(crate) const EtcGmtMinus5: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 70, 80, 0, 0, 43, 48, 53, 0, 10, 60, 43, 48, 53, 62, 45,
        53, 10,
    ];
    pub(crate) const EtcGmtMinus6: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 84, 96, 0, 0, 43, 48, 54, 0, 10, 60, 43, 48, 54, 62, 45,
        54, 10,
    ];
    pub(crate) const EtcGmtMinus7: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 98, 112, 0, 0, 43, 48, 55, 0, 10, 60, 43, 48, 55, 62, 45,
        55, 10,
    ];
    pub(crate) const EtcGmtMinus8: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 112, 128, 0, 0, 43, 48, 56, 0, 10, 60, 43, 48, 56, 62, 45,
        56, 10,
    ];
    pub(crate) const EtcGmtMinus9: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 126, 144, 0, 0, 43, 48, 57, 0, 10, 60, 43, 48, 57, 62, 45,
        57, 10,
    ];
    pub(crate) const EtcGmtPlus1: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 255, 255, 241, 240, 0, 0, 45, 48, 49, 0, 10, 60, 45, 48, 49, 62,
        49, 10,
    ];
    pub(crate) const EtcGmtPlus10: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 255, 255, 115, 96, 0, 0, 45, 49, 48, 0, 10, 60, 45, 49, 48, 62,
        49, 48, 10,
    ];
    pub(crate) const EtcGmtPlus11: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 255, 255, 101, 80, 0, 0, 45, 49, 49, 0, 10, 60, 45, 49, 49, 62,
        49, 49, 10,
    ];
    pub(crate) const EtcGmtPlus12: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 255, 255, 87, 64, 0, 0, 45, 49, 50, 0, 10, 60, 45, 49, 50, 62,
        49, 50, 10,
    ];
    pub(crate) const EtcGmtPlus2: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 255, 255, 227, 224, 0, 0, 45, 48, 50, 0, 10, 60, 45, 48, 50, 62,
        50, 10,
    ];
    pub(crate) const EtcGmtPlus3: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 255, 255, 213, 208, 0, 0, 45, 48, 51, 0, 10, 60, 45, 48, 51, 62,
        51, 10,
    ];
    pub(crate) const EtcGmtPlus4: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 255, 255, 199, 192, 0, 0, 45, 48, 52, 0, 10, 60, 45, 48, 52, 62,
        52, 10,
    ];
    pub(crate) const EtcGmtPlus5: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 255, 255, 185, 176, 0, 0, 45, 48, 53, 0, 10, 60, 45, 48, 53, 62,
        53, 10,
    ];
    pub(crate) const EtcGmtPlus6: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 255, 255, 171, 160, 0, 0, 45, 48, 54, 0, 10, 60, 45, 48, 54, 62,
        54, 10,
    ];
    pub(crate) const EtcGmtPlus7: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 255, 255, 157, 144, 0, 0, 45, 48, 55, 0, 10, 60, 45, 48, 55, 62,
        55, 10,
    ];
    pub(crate) const EtcGmtPlus8: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 255, 255, 143, 128, 0, 0, 45, 48, 56, 0, 10, 60, 45, 48, 56, 62,
        56, 10,
    ];
    pub(crate) const EtcGmtPlus9: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 255, 255, 129, 112, 0, 0, 45, 48, 57, 0, 10, 60, 45, 48, 57, 62,
        57, 10,
    ];
    pub(crate) const EtcUct: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 1, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 85, 84, 67, 0, 10, 85, 84, 67, 48, 10,
    ];
    pub(crate) const EuropeAmsterdam: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        97, 0, 0, 0, 7, 0, 0, 0, 33, 255, 255, 255, 255, 2, 18, 81, 108, 255, 255, 255, 255, 155,
        12, 46, 236, 255, 255, 255, 255, 155, 213, 214, 92, 255, 255, 255, 255, 156, 217, 184, 12,
        255, 255, 255, 255, 157, 164, 191, 12, 255, 255, 255, 255, 158, 167, 37, 12, 255, 255, 255,
        255, 159, 151, 22, 12, 255, 255, 255, 255, 160, 144, 65, 140, 255, 255, 255, 255, 161, 118,
        248, 12, 255, 255, 255, 255, 162, 112, 35, 140, 255, 255, 255, 255, 163, 86, 218, 12, 255,
        255, 255, 255, 164, 80, 5, 140, 255, 255, 255, 255, 165, 54, 188, 12, 255, 255, 255, 255,
        166, 37, 91, 140, 255, 255, 255, 255, 167, 39, 193, 140, 255, 255, 255, 255, 168, 94, 227,
        140, 255, 255, 255, 255, 169, 7, 163, 140, 255, 255, 255, 255, 169, 238, 90, 12, 255, 255,
        255, 255, 170, 231, 133, 140, 255, 255, 255, 255, 172, 39, 226, 12, 255, 255, 255, 255,
        172, 199, 103, 140, 255, 255, 255, 255, 173, 237, 102, 12, 255, 255, 255, 255, 174, 167,
        73, 140, 255, 255, 255, 255, 175, 206, 153, 140, 255, 255, 255, 255, 176, 135, 43, 140,
        255, 255, 255, 255, 177, 177, 30, 140, 255, 255, 255, 255, 178, 112, 72, 12, 255, 255, 255,
        255, 179, 146, 82, 12, 255, 255, 255, 255, 180, 80, 42, 12, 255, 255, 255, 255, 181, 115,
        133, 140, 255, 255, 255, 255, 182, 48, 12, 12, 255, 255, 255, 255, 183, 84, 185, 12, 255,
        255, 255, 255, 184, 15, 238, 12, 255, 255, 255, 255, 185, 64, 120, 140, 255, 255, 255, 255,
        185, 239, 208, 12, 255, 255, 255, 255, 187, 24, 113, 140, 255, 255, 255, 255, 187, 216,
        236, 140, 255, 255, 255, 255, 188, 249, 165, 12, 255, 255, 255, 255, 189, 184, 206, 140,
        255, 255, 255, 255, 190, 218, 216, 140, 255, 255, 255, 255, 191, 152, 176, 140, 255, 255,
        255, 255, 192, 189, 93, 140, 255, 255, 255, 255, 193, 120, 146, 140, 255, 255, 255, 255,
        194, 167, 203, 140, 255, 255, 255, 255, 194, 220, 93, 92, 255, 255, 255, 255, 195, 88, 116,
        112, 255, 255, 255, 255, 196, 127, 196, 112, 255, 255, 255, 255, 197, 56, 86, 112, 255,
        255, 255, 255, 198, 96, 247, 240, 255, 255, 255, 255, 199, 33, 114, 240, 255, 255, 255,
        255, 200, 68, 178, 80, 255, 255, 255, 255, 204, 231, 75, 16, 255, 255, 255, 255, 205, 169,
        23, 144, 255, 255, 255, 255, 206, 162, 67, 16, 255, 255, 255, 255, 207, 146, 52, 16, 255,
        255, 255, 255, 208, 130, 37, 16, 255, 255, 255, 255, 209, 114, 22, 16, 255, 255, 255, 255,
        210, 78, 64, 144, 0, 0, 0, 0, 13, 164, 99, 144, 0, 0, 0, 0, 14, 139, 26, 16, 0, 0, 0, 0,
        15, 132, 69, 144, 0, 0, 0, 0, 16, 116, 54, 144, 0, 0, 0, 0, 17, 100, 39, 144, 0, 0, 0, 0,
        18, 84, 24, 144, 0, 0, 0, 0, 19, 77, 68, 16, 0, 0, 0, 0, 20, 51, 250, 144, 0, 0, 0, 0, 21,
        35, 235, 144, 0, 0, 0, 0, 22, 19, 220, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23,
        243, 190, 144, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0,
        26, 195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0,
        29, 156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0,
        32, 108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35,
        60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24,
        16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144,
        0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144,
        0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203,
        144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217,
        16, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 4, 3, 4, 3, 4, 3, 6, 5, 6, 5, 6, 5, 6, 5, 6,
        5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6,
        5, 6, 5, 6, 5, 6, 5, 6, 0, 0, 4, 148, 0, 0, 0, 0, 18, 164, 1, 4, 0, 0, 4, 148, 0, 8, 0, 0,
        4, 176, 0, 12, 0, 0, 18, 192, 1, 18, 0, 0, 14, 16, 0, 24, 0, 0, 28, 32, 1, 28, 76, 77, 84,
        0, 78, 83, 84, 0, 65, 77, 84, 0, 43, 48, 48, 50, 48, 0, 43, 48, 49, 50, 48, 0, 67, 69, 84,
        0, 67, 69, 83, 84, 0, 10, 67, 69, 84, 45, 49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48,
        44, 77, 49, 48, 46, 53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const EuropeAndorra: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        25, 0, 0, 0, 4, 0, 0, 0, 17, 255, 255, 255, 255, 126, 54, 179, 148, 255, 255, 255, 255,
        212, 65, 219, 0, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0,
        30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0,
        33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44,
        54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144,
        0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144,
        0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144,
        0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188,
        144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 1, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 0, 0, 1, 108, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0,
        14, 16, 0, 8, 0, 0, 28, 32, 1, 12, 76, 77, 84, 0, 87, 69, 84, 0, 67, 69, 84, 0, 67, 69, 83,
        84, 0, 10, 67, 69, 84, 45, 49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77, 49, 48,
        46, 53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const EuropeAstrakhan: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        64, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 170, 24, 69, 116, 255, 255, 255, 255, 181,
        164, 11, 80, 0, 0, 0, 0, 21, 39, 153, 192, 0, 0, 0, 0, 22, 24, 206, 48, 0, 0, 0, 0, 23, 8,
        205, 64, 0, 0, 0, 0, 23, 250, 1, 176, 0, 0, 0, 0, 24, 234, 0, 192, 0, 0, 0, 0, 25, 219, 53,
        48, 0, 0, 0, 0, 26, 204, 133, 192, 0, 0, 0, 0, 27, 188, 146, 224, 0, 0, 0, 0, 28, 172, 131,
        224, 0, 0, 0, 0, 29, 156, 116, 224, 0, 0, 0, 0, 30, 140, 101, 224, 0, 0, 0, 0, 31, 124, 86,
        224, 0, 0, 0, 0, 32, 108, 71, 224, 0, 0, 0, 0, 33, 92, 56, 224, 0, 0, 0, 0, 34, 76, 41,
        224, 0, 0, 0, 0, 35, 60, 26, 224, 0, 0, 0, 0, 36, 44, 11, 224, 0, 0, 0, 0, 37, 28, 10, 240,
        0, 0, 0, 0, 38, 11, 251, 240, 0, 0, 0, 0, 39, 5, 39, 112, 0, 0, 0, 0, 39, 245, 24, 112, 0,
        0, 0, 0, 41, 212, 236, 96, 0, 0, 0, 0, 42, 196, 235, 112, 0, 0, 0, 0, 43, 180, 220, 112, 0,
        0, 0, 0, 44, 164, 205, 112, 0, 0, 0, 0, 45, 148, 190, 112, 0, 0, 0, 0, 46, 132, 175, 112,
        0, 0, 0, 0, 47, 116, 160, 112, 0, 0, 0, 0, 48, 100, 145, 112, 0, 0, 0, 0, 49, 93, 188, 240,
        0, 0, 0, 0, 50, 114, 151, 240, 0, 0, 0, 0, 51, 61, 158, 240, 0, 0, 0, 0, 52, 82, 121, 240,
        0, 0, 0, 0, 53, 29, 128, 240, 0, 0, 0, 0, 54, 50, 91, 240, 0, 0, 0, 0, 54, 253, 98, 240, 0,
        0, 0, 0, 56, 27, 120, 112, 0, 0, 0, 0, 56, 221, 68, 240, 0, 0, 0, 0, 57, 251, 90, 112, 0,
        0, 0, 0, 58, 189, 38, 240, 0, 0, 0, 0, 59, 219, 60, 112, 0, 0, 0, 0, 60, 166, 67, 112, 0,
        0, 0, 0, 61, 187, 30, 112, 0, 0, 0, 0, 62, 134, 37, 112, 0, 0, 0, 0, 63, 155, 0, 112, 0, 0,
        0, 0, 64, 102, 7, 112, 0, 0, 0, 0, 65, 132, 28, 240, 0, 0, 0, 0, 66, 69, 233, 112, 0, 0, 0,
        0, 67, 99, 254, 240, 0, 0, 0, 0, 68, 37, 203, 112, 0, 0, 0, 0, 69, 67, 224, 240, 0, 0, 0,
        0, 70, 5, 173, 112, 0, 0, 0, 0, 71, 35, 194, 240, 0, 0, 0, 0, 71, 238, 201, 240, 0, 0, 0,
        0, 73, 3, 164, 240, 0, 0, 0, 0, 73, 206, 171, 240, 0, 0, 0, 0, 74, 227, 134, 240, 0, 0, 0,
        0, 75, 174, 141, 240, 0, 0, 0, 0, 76, 204, 163, 112, 0, 0, 0, 0, 77, 142, 111, 240, 0, 0,
        0, 0, 84, 76, 29, 96, 0, 0, 0, 0, 86, 247, 20, 112, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 4, 1, 4, 1, 3, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1,
        4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 3, 1, 3, 0, 0, 45, 12, 0, 0, 0, 0,
        42, 48, 0, 4, 0, 0, 70, 80, 1, 8, 0, 0, 56, 64, 0, 12, 0, 0, 56, 64, 1, 12, 76, 77, 84, 0,
        43, 48, 51, 0, 43, 48, 53, 0, 43, 48, 52, 0, 10, 60, 43, 48, 52, 62, 45, 52, 10,
    ];
    pub(crate) const EuropeAthens: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        55, 0, 0, 0, 6, 0, 0, 0, 26, 255, 255, 255, 255, 116, 63, 152, 68, 255, 255, 255, 255, 155,
        128, 33, 128, 255, 255, 255, 255, 185, 124, 233, 224, 255, 255, 255, 255, 185, 198, 175,
        208, 255, 255, 255, 255, 201, 242, 99, 224, 255, 255, 255, 255, 202, 16, 168, 80, 255, 255,
        255, 255, 204, 231, 75, 16, 255, 255, 255, 255, 205, 170, 76, 240, 255, 255, 255, 255, 206,
        162, 24, 224, 255, 255, 255, 255, 207, 147, 105, 112, 255, 255, 255, 255, 223, 19, 158, 96,
        255, 255, 255, 255, 223, 183, 10, 80, 0, 0, 0, 0, 9, 236, 94, 96, 0, 0, 0, 0, 11, 24, 244,
        96, 0, 0, 0, 0, 11, 205, 174, 0, 0, 0, 0, 0, 12, 189, 159, 0, 0, 0, 0, 0, 13, 164, 85, 128,
        0, 0, 0, 0, 14, 140, 93, 128, 0, 0, 0, 0, 15, 132, 55, 128, 0, 0, 0, 0, 16, 106, 252, 16,
        0, 0, 0, 0, 17, 100, 123, 240, 0, 0, 0, 0, 18, 82, 170, 240, 0, 0, 0, 0, 19, 70, 130, 96,
        0, 0, 0, 0, 20, 51, 194, 80, 0, 0, 0, 0, 21, 35, 235, 144, 0, 0, 0, 0, 22, 19, 220, 144, 0,
        0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23, 243, 190, 144, 0, 0, 0, 0, 24, 227, 175, 144, 0,
        0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0,
        0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0,
        0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0,
        0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0,
        37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39,
        245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42,
        197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45,
        148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0,
        48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 1, 3, 2, 3, 2, 5, 4, 5, 4, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 0, 0, 22, 60, 0, 0, 0, 0, 22, 60, 0, 4, 0, 0, 42, 48, 1,
        8, 0, 0, 28, 32, 0, 13, 0, 0, 14, 16, 0, 17, 0, 0, 28, 32, 1, 21, 76, 77, 84, 0, 65, 77,
        84, 0, 69, 69, 83, 84, 0, 69, 69, 84, 0, 67, 69, 84, 0, 67, 69, 83, 84, 0, 10, 69, 69, 84,
        45, 50, 69, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 47, 51, 44, 77, 49, 48, 46, 53, 46, 48,
        47, 52, 10,
    ];
    pub(crate) const EuropeBelfast: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        159, 0, 0, 0, 5, 0, 0, 0, 17, 255, 255, 255, 255, 26, 93, 9, 203, 255, 255, 255, 255, 155,
        38, 173, 160, 255, 255, 255, 255, 155, 214, 5, 32, 255, 255, 255, 255, 156, 207, 48, 160,
        255, 255, 255, 255, 157, 164, 195, 160, 255, 255, 255, 255, 158, 156, 157, 160, 255, 255,
        255, 255, 159, 151, 26, 160, 255, 255, 255, 255, 160, 133, 186, 32, 255, 255, 255, 255,
        161, 118, 252, 160, 255, 255, 255, 255, 162, 101, 156, 32, 255, 255, 255, 255, 163, 123,
        200, 160, 255, 255, 255, 255, 164, 78, 184, 160, 255, 255, 255, 255, 165, 63, 251, 32, 255,
        255, 255, 255, 166, 37, 96, 32, 255, 255, 255, 255, 167, 39, 198, 32, 255, 255, 255, 255,
        168, 42, 44, 32, 255, 255, 255, 255, 168, 235, 248, 160, 255, 255, 255, 255, 170, 0, 211,
        160, 255, 255, 255, 255, 170, 213, 21, 32, 255, 255, 255, 255, 171, 233, 240, 32, 255, 255,
        255, 255, 172, 199, 108, 32, 255, 255, 255, 255, 173, 201, 210, 32, 255, 255, 255, 255,
        174, 167, 78, 32, 255, 255, 255, 255, 175, 160, 121, 160, 255, 255, 255, 255, 176, 135, 48,
        32, 255, 255, 255, 255, 177, 146, 208, 160, 255, 255, 255, 255, 178, 112, 76, 160, 255,
        255, 255, 255, 179, 114, 178, 160, 255, 255, 255, 255, 180, 80, 46, 160, 255, 255, 255,
        255, 181, 73, 90, 32, 255, 255, 255, 255, 182, 48, 16, 160, 255, 255, 255, 255, 183, 50,
        118, 160, 255, 255, 255, 255, 184, 15, 242, 160, 255, 255, 255, 255, 185, 18, 88, 160, 255,
        255, 255, 255, 185, 239, 212, 160, 255, 255, 255, 255, 186, 233, 0, 32, 255, 255, 255, 255,
        187, 216, 241, 32, 255, 255, 255, 255, 188, 219, 87, 32, 255, 255, 255, 255, 189, 184, 211,
        32, 255, 255, 255, 255, 190, 177, 254, 160, 255, 255, 255, 255, 191, 152, 181, 32, 255,
        255, 255, 255, 192, 155, 27, 32, 255, 255, 255, 255, 193, 120, 151, 32, 255, 255, 255, 255,
        194, 122, 253, 32, 255, 255, 255, 255, 195, 88, 121, 32, 255, 255, 255, 255, 196, 81, 164,
        160, 255, 255, 255, 255, 197, 56, 91, 32, 255, 255, 255, 255, 198, 58, 193, 32, 255, 255,
        255, 255, 199, 88, 214, 160, 255, 255, 255, 255, 199, 218, 9, 160, 255, 255, 255, 255, 202,
        22, 38, 144, 255, 255, 255, 255, 202, 151, 89, 144, 255, 255, 255, 255, 203, 209, 30, 144,
        255, 255, 255, 255, 204, 119, 59, 144, 255, 255, 255, 255, 205, 177, 0, 144, 255, 255, 255,
        255, 206, 96, 88, 16, 255, 255, 255, 255, 207, 144, 226, 144, 255, 255, 255, 255, 208, 110,
        94, 144, 255, 255, 255, 255, 209, 114, 22, 16, 255, 255, 255, 255, 209, 251, 50, 16, 255,
        255, 255, 255, 210, 105, 254, 32, 255, 255, 255, 255, 211, 99, 41, 160, 255, 255, 255, 255,
        212, 73, 224, 32, 255, 255, 255, 255, 213, 30, 33, 160, 255, 255, 255, 255, 213, 66, 253,
        144, 255, 255, 255, 255, 213, 223, 224, 16, 255, 255, 255, 255, 214, 78, 172, 32, 255, 255,
        255, 255, 214, 254, 3, 160, 255, 255, 255, 255, 216, 46, 142, 32, 255, 255, 255, 255, 216,
        249, 149, 32, 255, 255, 255, 255, 218, 14, 112, 32, 255, 255, 255, 255, 218, 235, 236, 32,
        255, 255, 255, 255, 219, 229, 23, 160, 255, 255, 255, 255, 220, 203, 206, 32, 255, 255,
        255, 255, 221, 196, 249, 160, 255, 255, 255, 255, 222, 180, 234, 160, 255, 255, 255, 255,
        223, 174, 22, 32, 255, 255, 255, 255, 224, 148, 204, 160, 255, 255, 255, 255, 225, 114, 72,
        160, 255, 255, 255, 255, 226, 107, 116, 32, 255, 255, 255, 255, 227, 82, 42, 160, 255, 255,
        255, 255, 228, 84, 144, 160, 255, 255, 255, 255, 229, 50, 12, 160, 255, 255, 255, 255, 230,
        61, 173, 32, 255, 255, 255, 255, 231, 27, 41, 32, 255, 255, 255, 255, 232, 20, 84, 160,
        255, 255, 255, 255, 232, 251, 11, 32, 255, 255, 255, 255, 233, 253, 113, 32, 255, 255, 255,
        255, 234, 218, 237, 32, 255, 255, 255, 255, 235, 221, 83, 32, 255, 255, 255, 255, 236, 186,
        207, 32, 255, 255, 255, 255, 237, 179, 250, 160, 255, 255, 255, 255, 238, 154, 177, 32,
        255, 255, 255, 255, 239, 129, 103, 160, 255, 255, 255, 255, 240, 159, 125, 32, 255, 255,
        255, 255, 241, 97, 73, 160, 255, 255, 255, 255, 242, 127, 95, 32, 255, 255, 255, 255, 243,
        74, 102, 32, 255, 255, 255, 255, 244, 95, 65, 32, 255, 255, 255, 255, 245, 33, 13, 160,
        255, 255, 255, 255, 246, 63, 35, 32, 255, 255, 255, 255, 247, 0, 239, 160, 255, 255, 255,
        255, 248, 31, 5, 32, 255, 255, 255, 255, 248, 224, 209, 160, 255, 255, 255, 255, 249, 254,
        231, 32, 255, 255, 255, 255, 250, 192, 179, 160, 255, 255, 255, 255, 251, 232, 3, 160, 255,
        255, 255, 255, 252, 123, 171, 160, 255, 255, 255, 255, 253, 199, 187, 112, 0, 0, 0, 0, 3,
        112, 198, 32, 0, 0, 0, 0, 4, 41, 88, 32, 0, 0, 0, 0, 5, 80, 168, 32, 0, 0, 0, 0, 6, 9, 58,
        32, 0, 0, 0, 0, 7, 48, 138, 32, 0, 0, 0, 0, 7, 233, 28, 32, 0, 0, 0, 0, 9, 16, 108, 32, 0,
        0, 0, 0, 9, 200, 254, 32, 0, 0, 0, 0, 10, 240, 78, 32, 0, 0, 0, 0, 11, 178, 26, 160, 0, 0,
        0, 0, 12, 208, 48, 32, 0, 0, 0, 0, 13, 145, 252, 160, 0, 0, 0, 0, 14, 176, 18, 32, 0, 0, 0,
        0, 15, 113, 222, 160, 0, 0, 0, 0, 16, 153, 46, 160, 0, 0, 0, 0, 17, 81, 192, 160, 0, 0, 0,
        0, 18, 121, 16, 160, 0, 0, 0, 0, 19, 49, 162, 160, 0, 0, 0, 0, 20, 88, 242, 160, 0, 0, 0,
        0, 21, 35, 235, 144, 0, 0, 0, 0, 22, 56, 198, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0,
        24, 24, 168, 144, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25, 248, 138, 144, 0, 0, 0, 0,
        26, 195, 145, 144, 0, 0, 0, 0, 27, 225, 167, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0,
        29, 193, 137, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 161, 107, 16, 0, 0, 0, 0,
        32, 108, 114, 16, 0, 0, 0, 0, 33, 129, 77, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35,
        97, 47, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 74, 75, 144, 0, 0, 0, 0, 38, 12,
        24, 16, 0, 0, 0, 0, 39, 42, 45, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 41, 10, 15,
        144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 233, 241, 144, 0, 0, 0, 0, 43, 180, 248,
        144, 0, 0, 0, 0, 44, 201, 211, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 169,
        181, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 137, 151, 144, 0, 0, 0, 0, 49, 93,
        217, 16, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 3, 1, 3, 1, 3, 1, 3,
        1, 3, 1, 2, 1, 2, 1, 3, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 4, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 255, 255, 255, 181, 0, 0, 0, 0, 14, 16, 1, 4, 0, 0, 0,
        0, 0, 8, 0, 0, 28, 32, 1, 12, 0, 0, 14, 16, 0, 4, 76, 77, 84, 0, 66, 83, 84, 0, 71, 77, 84,
        0, 66, 68, 83, 84, 0, 10, 71, 77, 84, 48, 66, 83, 84, 44, 77, 51, 46, 53, 46, 48, 47, 49,
        44, 77, 49, 48, 46, 53, 46, 48, 10,
    ];
    pub(crate) const EuropeBelgrade: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        36, 0, 0, 0, 3, 0, 0, 0, 13, 255, 255, 255, 255, 94, 60, 240, 72, 255, 255, 255, 255, 202,
        2, 53, 224, 255, 255, 255, 255, 204, 231, 75, 16, 255, 255, 255, 255, 205, 169, 23, 144,
        255, 255, 255, 255, 206, 162, 67, 16, 255, 255, 255, 255, 207, 146, 52, 16, 255, 255, 255,
        255, 208, 130, 37, 16, 255, 255, 255, 255, 209, 161, 140, 16, 255, 255, 255, 255, 210, 78,
        64, 144, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0, 26, 195,
        145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29, 156,
        159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108,
        114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69,
        16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0,
        0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0,
        0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0,
        0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0,
        0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 0, 0, 19, 56, 0, 0, 0, 0, 14, 16, 0, 4, 0, 0, 28, 32, 1, 8, 76, 77, 84, 0,
        67, 69, 84, 0, 67, 69, 83, 84, 0, 10, 67, 69, 84, 45, 49, 67, 69, 83, 84, 44, 77, 51, 46,
        53, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const EuropeBerlin: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        60, 0, 0, 0, 4, 0, 0, 0, 18, 255, 255, 255, 255, 111, 162, 97, 248, 255, 255, 255, 255,
        155, 12, 23, 96, 255, 255, 255, 255, 155, 213, 218, 240, 255, 255, 255, 255, 156, 217, 174,
        144, 255, 255, 255, 255, 157, 164, 181, 144, 255, 255, 255, 255, 158, 185, 144, 144, 255,
        255, 255, 255, 159, 132, 151, 144, 255, 255, 255, 255, 200, 9, 113, 144, 255, 255, 255,
        255, 204, 231, 75, 16, 255, 255, 255, 255, 205, 169, 23, 144, 255, 255, 255, 255, 206, 162,
        67, 16, 255, 255, 255, 255, 207, 146, 52, 16, 255, 255, 255, 255, 208, 130, 37, 16, 255,
        255, 255, 255, 209, 114, 22, 16, 255, 255, 255, 255, 209, 182, 150, 0, 255, 255, 255, 255,
        210, 88, 190, 128, 255, 255, 255, 255, 210, 161, 79, 16, 255, 255, 255, 255, 211, 99, 27,
        144, 255, 255, 255, 255, 212, 75, 35, 144, 255, 255, 255, 255, 213, 57, 209, 32, 255, 255,
        255, 255, 213, 103, 231, 144, 255, 255, 255, 255, 213, 168, 115, 0, 255, 255, 255, 255,
        214, 41, 180, 16, 255, 255, 255, 255, 215, 44, 26, 16, 255, 255, 255, 255, 216, 9, 150, 16,
        255, 255, 255, 255, 217, 2, 193, 144, 255, 255, 255, 255, 217, 233, 120, 16, 0, 0, 0, 0,
        19, 77, 68, 16, 0, 0, 0, 0, 20, 51, 250, 144, 0, 0, 0, 0, 21, 35, 235, 144, 0, 0, 0, 0, 22,
        19, 220, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23, 243, 190, 144, 0, 0, 0, 0, 24,
        227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0,
        27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0,
        30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0,
        33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44,
        54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144,
        0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144,
        0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144,
        0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188,
        144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 3, 1, 2, 1, 2, 1, 3, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0, 0, 12, 136, 0, 0, 0, 0,
        28, 32, 1, 4, 0, 0, 14, 16, 0, 9, 0, 0, 42, 48, 1, 13, 76, 77, 84, 0, 67, 69, 83, 84, 0,
        67, 69, 84, 0, 67, 69, 77, 84, 0, 10, 67, 69, 84, 45, 49, 67, 69, 83, 84, 44, 77, 51, 46,
        53, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const EuropeBratislava: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        61, 0, 0, 0, 5, 0, 0, 0, 21, 255, 255, 255, 255, 30, 73, 146, 248, 255, 255, 255, 255, 108,
        207, 234, 248, 255, 255, 255, 255, 155, 12, 23, 96, 255, 255, 255, 255, 155, 213, 218, 240,
        255, 255, 255, 255, 156, 217, 174, 144, 255, 255, 255, 255, 157, 164, 181, 144, 255, 255,
        255, 255, 158, 185, 144, 144, 255, 255, 255, 255, 159, 132, 151, 144, 255, 255, 255, 255,
        200, 9, 113, 144, 255, 255, 255, 255, 204, 231, 75, 16, 255, 255, 255, 255, 205, 169, 23,
        144, 255, 255, 255, 255, 206, 162, 67, 16, 255, 255, 255, 255, 207, 146, 52, 16, 255, 255,
        255, 255, 208, 130, 37, 16, 255, 255, 255, 255, 209, 114, 22, 16, 255, 255, 255, 255, 210,
        98, 7, 16, 255, 255, 255, 255, 211, 128, 28, 144, 255, 255, 255, 255, 212, 73, 210, 16,
        255, 255, 255, 255, 212, 147, 180, 32, 255, 255, 255, 255, 213, 2, 114, 32, 255, 255, 255,
        255, 213, 76, 56, 16, 255, 255, 255, 255, 214, 41, 180, 16, 255, 255, 255, 255, 215, 44,
        26, 16, 255, 255, 255, 255, 216, 9, 150, 16, 255, 255, 255, 255, 217, 1, 112, 16, 255, 255,
        255, 255, 217, 233, 120, 16, 0, 0, 0, 0, 17, 100, 39, 144, 0, 0, 0, 0, 18, 84, 24, 144, 0,
        0, 0, 0, 19, 77, 68, 16, 0, 0, 0, 0, 20, 51, 250, 144, 0, 0, 0, 0, 21, 35, 235, 144, 0, 0,
        0, 0, 22, 19, 220, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23, 243, 190, 144, 0, 0,
        0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0,
        0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0,
        0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0,
        0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0,
        0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39,
        5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41,
        213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0, 0, 0, 44,
        164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0, 0, 0, 0,
        47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 1, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 0, 0, 13,
        136, 0, 0, 0, 0, 13, 136, 0, 4, 0, 0, 28, 32, 1, 8, 0, 0, 14, 16, 0, 13, 0, 0, 0, 0, 1, 17,
        76, 77, 84, 0, 80, 77, 84, 0, 67, 69, 83, 84, 0, 67, 69, 84, 0, 71, 77, 84, 0, 10, 67, 69,
        84, 45, 49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48, 47,
        51, 10,
    ];
    pub(crate) const EuropeBrussels: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        102, 0, 0, 0, 6, 0, 0, 0, 26, 255, 255, 255, 255, 86, 182, 223, 230, 255, 255, 255, 255,
        109, 232, 200, 0, 255, 255, 255, 255, 152, 68, 73, 128, 255, 255, 255, 255, 155, 12, 37,
        112, 255, 255, 255, 255, 155, 213, 218, 240, 255, 255, 255, 255, 156, 217, 174, 144, 255,
        255, 255, 255, 157, 164, 181, 144, 255, 255, 255, 255, 158, 185, 144, 144, 255, 255, 255,
        255, 159, 132, 151, 144, 255, 255, 255, 255, 159, 206, 248, 48, 255, 255, 255, 255, 160,
        96, 165, 240, 255, 255, 255, 255, 161, 126, 187, 112, 255, 255, 255, 255, 162, 46, 18, 240,
        255, 255, 255, 255, 163, 122, 76, 240, 255, 255, 255, 255, 164, 53, 129, 240, 255, 255,
        255, 255, 165, 94, 35, 112, 255, 255, 255, 255, 166, 37, 53, 240, 255, 255, 255, 255, 167,
        39, 155, 240, 255, 255, 255, 255, 168, 42, 1, 240, 255, 255, 255, 255, 169, 7, 125, 240,
        255, 255, 255, 255, 169, 238, 52, 112, 255, 255, 255, 255, 170, 231, 95, 240, 255, 255,
        255, 255, 171, 215, 80, 240, 255, 255, 255, 255, 172, 199, 65, 240, 255, 255, 255, 255,
        173, 201, 167, 240, 255, 255, 255, 255, 174, 167, 35, 240, 255, 255, 255, 255, 175, 160,
        79, 112, 255, 255, 255, 255, 176, 135, 5, 240, 255, 255, 255, 255, 177, 137, 107, 240, 255,
        255, 255, 255, 178, 112, 76, 160, 255, 255, 255, 255, 179, 114, 178, 160, 255, 255, 255,
        255, 180, 80, 46, 160, 255, 255, 255, 255, 181, 73, 90, 32, 255, 255, 255, 255, 182, 48,
        16, 160, 255, 255, 255, 255, 183, 50, 118, 160, 255, 255, 255, 255, 184, 15, 242, 160, 255,
        255, 255, 255, 184, 255, 227, 160, 255, 255, 255, 255, 185, 239, 212, 160, 255, 255, 255,
        255, 186, 214, 139, 32, 255, 255, 255, 255, 187, 216, 241, 32, 255, 255, 255, 255, 188,
        200, 226, 32, 255, 255, 255, 255, 189, 184, 211, 32, 255, 255, 255, 255, 190, 159, 137,
        160, 255, 255, 255, 255, 191, 152, 181, 32, 255, 255, 255, 255, 192, 155, 27, 32, 255, 255,
        255, 255, 193, 120, 151, 32, 255, 255, 255, 255, 194, 104, 136, 32, 255, 255, 255, 255,
        195, 88, 121, 32, 255, 255, 255, 255, 196, 63, 47, 160, 255, 255, 255, 255, 197, 56, 91,
        32, 255, 255, 255, 255, 198, 58, 193, 32, 255, 255, 255, 255, 199, 88, 214, 160, 255, 255,
        255, 255, 199, 218, 9, 160, 255, 255, 255, 255, 200, 74, 25, 32, 255, 255, 255, 255, 204,
        231, 75, 16, 255, 255, 255, 255, 205, 169, 23, 144, 255, 255, 255, 255, 206, 162, 67, 16,
        255, 255, 255, 255, 207, 146, 52, 16, 255, 255, 255, 255, 208, 110, 94, 144, 255, 255, 255,
        255, 209, 114, 22, 16, 255, 255, 255, 255, 210, 78, 64, 144, 255, 255, 255, 255, 211, 145,
        64, 16, 255, 255, 255, 255, 212, 75, 35, 144, 0, 0, 0, 0, 13, 164, 99, 144, 0, 0, 0, 0, 14,
        139, 26, 16, 0, 0, 0, 0, 15, 132, 69, 144, 0, 0, 0, 0, 16, 116, 54, 144, 0, 0, 0, 0, 17,
        100, 39, 144, 0, 0, 0, 0, 18, 84, 24, 144, 0, 0, 0, 0, 19, 77, 68, 16, 0, 0, 0, 0, 20, 51,
        250, 144, 0, 0, 0, 0, 21, 35, 235, 144, 0, 0, 0, 0, 22, 19, 220, 144, 0, 0, 0, 0, 23, 3,
        205, 144, 0, 0, 0, 0, 23, 243, 190, 144, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25,
        211, 160, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28,
        172, 174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31,
        124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76,
        84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16,
        0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0,
        0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0,
        0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0,
        0, 0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0,
        0, 0, 0, 49, 93, 217, 16, 1, 2, 3, 4, 3, 4, 3, 4, 3, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2,
        5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2,
        5, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4,
        3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 0, 0, 4, 26, 0, 0, 0, 0, 4, 26,
        0, 4, 0, 0, 0, 0, 0, 8, 0, 0, 14, 16, 0, 12, 0, 0, 28, 32, 1, 16, 0, 0, 14, 16, 1, 21, 76,
        77, 84, 0, 66, 77, 84, 0, 87, 69, 84, 0, 67, 69, 84, 0, 67, 69, 83, 84, 0, 87, 69, 83, 84,
        0, 10, 67, 69, 84, 45, 49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77, 49, 48, 46,
        53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const EuropeBucharest: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        55, 0, 0, 0, 4, 0, 0, 0, 17, 255, 255, 255, 255, 108, 207, 224, 8, 255, 255, 255, 255, 183,
        176, 210, 8, 255, 255, 255, 255, 185, 62, 243, 96, 255, 255, 255, 255, 185, 239, 156, 96,
        255, 255, 255, 255, 186, 223, 141, 96, 255, 255, 255, 255, 187, 207, 126, 96, 255, 255,
        255, 255, 188, 200, 169, 224, 255, 255, 255, 255, 189, 184, 154, 224, 255, 255, 255, 255,
        190, 168, 139, 224, 255, 255, 255, 255, 191, 152, 124, 224, 255, 255, 255, 255, 192, 136,
        109, 224, 255, 255, 255, 255, 193, 120, 94, 224, 255, 255, 255, 255, 194, 104, 79, 224,
        255, 255, 255, 255, 195, 88, 64, 224, 255, 255, 255, 255, 196, 72, 49, 224, 255, 255, 255,
        255, 197, 56, 34, 224, 255, 255, 255, 255, 198, 40, 19, 224, 255, 255, 255, 255, 199, 24,
        4, 224, 0, 0, 0, 0, 17, 173, 209, 96, 0, 0, 0, 0, 18, 83, 224, 80, 0, 0, 0, 0, 19, 77, 11,
        208, 0, 0, 0, 0, 20, 51, 208, 96, 0, 0, 0, 0, 21, 35, 221, 128, 0, 0, 0, 0, 22, 19, 206,
        128, 0, 0, 0, 0, 23, 3, 191, 128, 0, 0, 0, 0, 23, 243, 176, 128, 0, 0, 0, 0, 24, 227, 161,
        128, 0, 0, 0, 0, 25, 211, 146, 128, 0, 0, 0, 0, 26, 195, 131, 128, 0, 0, 0, 0, 27, 188,
        175, 0, 0, 0, 0, 0, 28, 172, 160, 0, 0, 0, 0, 0, 29, 156, 145, 0, 0, 0, 0, 0, 30, 140, 130,
        0, 0, 0, 0, 0, 31, 124, 115, 0, 0, 0, 0, 0, 32, 108, 100, 0, 0, 0, 0, 0, 33, 92, 85, 0, 0,
        0, 0, 0, 34, 76, 70, 0, 0, 0, 0, 0, 35, 60, 55, 0, 0, 0, 0, 0, 36, 44, 40, 0, 0, 0, 0, 0,
        37, 28, 25, 0, 0, 0, 0, 0, 38, 12, 10, 0, 0, 0, 0, 0, 39, 5, 53, 128, 0, 0, 0, 0, 39, 245,
        10, 96, 0, 0, 0, 0, 40, 228, 251, 96, 0, 0, 0, 0, 41, 212, 236, 96, 0, 0, 0, 0, 42, 196,
        221, 96, 0, 0, 0, 0, 43, 180, 206, 96, 0, 0, 0, 0, 44, 164, 191, 96, 0, 0, 0, 0, 45, 148,
        176, 96, 0, 0, 0, 0, 46, 132, 147, 80, 0, 0, 0, 0, 47, 116, 146, 96, 0, 0, 0, 0, 48, 100,
        117, 80, 0, 0, 0, 0, 49, 93, 174, 224, 0, 0, 0, 0, 50, 114, 123, 208, 0, 0, 0, 0, 51, 61,
        187, 16, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 0, 0,
        24, 120, 0, 0, 0, 0, 24, 120, 0, 4, 0, 0, 42, 48, 1, 8, 0, 0, 28, 32, 0, 13, 76, 77, 84, 0,
        66, 77, 84, 0, 69, 69, 83, 84, 0, 69, 69, 84, 0, 10, 69, 69, 84, 45, 50, 69, 69, 83, 84,
        44, 77, 51, 46, 53, 46, 48, 47, 51, 44, 77, 49, 48, 46, 53, 46, 48, 47, 52, 10,
    ];
    pub(crate) const EuropeBudapest: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        68, 0, 0, 0, 3, 0, 0, 0, 13, 255, 255, 255, 255, 107, 23, 145, 156, 255, 255, 255, 255,
        155, 12, 23, 96, 255, 255, 255, 255, 155, 213, 218, 240, 255, 255, 255, 255, 156, 217, 174,
        144, 255, 255, 255, 255, 157, 164, 181, 144, 255, 255, 255, 255, 158, 185, 144, 144, 255,
        255, 255, 255, 159, 132, 151, 144, 255, 255, 255, 255, 160, 154, 196, 16, 255, 255, 255,
        255, 161, 100, 121, 144, 255, 255, 255, 255, 162, 112, 26, 16, 255, 255, 255, 255, 163, 77,
        150, 16, 255, 255, 255, 255, 201, 243, 181, 96, 255, 255, 255, 255, 204, 231, 75, 16, 255,
        255, 255, 255, 205, 169, 23, 144, 255, 255, 255, 255, 206, 162, 67, 16, 255, 255, 255, 255,
        207, 146, 52, 16, 255, 255, 255, 255, 208, 130, 37, 16, 255, 255, 255, 255, 209, 153, 120,
        224, 255, 255, 255, 255, 210, 138, 201, 112, 255, 255, 255, 255, 211, 80, 166, 144, 255,
        255, 255, 255, 212, 75, 21, 128, 255, 255, 255, 255, 213, 57, 195, 16, 255, 255, 255, 255,
        214, 41, 180, 16, 255, 255, 255, 255, 215, 25, 165, 16, 255, 255, 255, 255, 216, 9, 150,
        16, 255, 255, 255, 255, 217, 2, 193, 144, 255, 255, 255, 255, 217, 233, 120, 16, 255, 255,
        255, 255, 226, 162, 168, 240, 255, 255, 255, 255, 227, 81, 242, 96, 255, 255, 255, 255,
        228, 130, 167, 16, 255, 255, 255, 255, 229, 49, 254, 144, 255, 255, 255, 255, 230, 116,
        254, 16, 255, 255, 255, 255, 231, 17, 224, 144, 255, 255, 255, 255, 232, 84, 224, 16, 255,
        255, 255, 255, 232, 241, 194, 144, 0, 0, 0, 0, 19, 77, 39, 240, 0, 0, 0, 0, 20, 51, 222,
        112, 0, 0, 0, 0, 21, 35, 207, 112, 0, 0, 0, 0, 22, 19, 192, 112, 0, 0, 0, 0, 23, 3, 177,
        112, 0, 0, 0, 0, 23, 243, 162, 112, 0, 0, 0, 0, 24, 227, 147, 112, 0, 0, 0, 0, 25, 211,
        132, 112, 0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172,
        174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124,
        129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84,
        16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0,
        0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0,
        0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0,
        43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0,
        0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0,
        0, 0, 49, 93, 217, 16, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0, 0, 17, 228, 0, 0, 0, 0, 28, 32, 1, 4, 0, 0,
        14, 16, 0, 9, 76, 77, 84, 0, 67, 69, 83, 84, 0, 67, 69, 84, 0, 10, 67, 69, 84, 45, 49, 67,
        69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const EuropeBusingen: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        37, 0, 0, 0, 4, 0, 0, 0, 17, 255, 255, 255, 255, 36, 240, 234, 128, 255, 255, 255, 255,
        113, 212, 6, 134, 255, 255, 255, 255, 202, 23, 106, 0, 255, 255, 255, 255, 202, 226, 113,
        0, 255, 255, 255, 255, 203, 247, 76, 0, 255, 255, 255, 255, 204, 194, 83, 0, 0, 0, 0, 0,
        21, 35, 235, 144, 0, 0, 0, 0, 22, 19, 220, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0,
        23, 243, 190, 144, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0,
        0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0,
        0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0,
        0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0,
        35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12,
        24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37,
        144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248,
        144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132,
        203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93,
        217, 16, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 0, 0, 8, 0, 0, 0, 0, 0, 6, 250, 0, 4, 0, 0, 28, 32, 1, 8, 0,
        0, 14, 16, 0, 13, 76, 77, 84, 0, 66, 77, 84, 0, 67, 69, 83, 84, 0, 67, 69, 84, 0, 10, 67,
        69, 84, 45, 49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48,
        47, 51, 10,
    ];
    pub(crate) const EuropeChisinau: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        60, 0, 0, 0, 9, 0, 0, 0, 38, 255, 255, 255, 255, 86, 182, 200, 248, 255, 255, 255, 255,
        158, 107, 159, 12, 255, 255, 255, 255, 183, 176, 210, 8, 255, 255, 255, 255, 185, 62, 243,
        96, 255, 255, 255, 255, 185, 239, 156, 96, 255, 255, 255, 255, 186, 223, 141, 96, 255, 255,
        255, 255, 187, 207, 126, 96, 255, 255, 255, 255, 188, 200, 169, 224, 255, 255, 255, 255,
        189, 184, 154, 224, 255, 255, 255, 255, 190, 168, 139, 224, 255, 255, 255, 255, 191, 152,
        124, 224, 255, 255, 255, 255, 192, 136, 109, 224, 255, 255, 255, 255, 193, 120, 94, 224,
        255, 255, 255, 255, 194, 104, 79, 224, 255, 255, 255, 255, 195, 88, 64, 224, 255, 255, 255,
        255, 196, 72, 49, 224, 255, 255, 255, 255, 197, 56, 34, 224, 255, 255, 255, 255, 198, 40,
        19, 224, 255, 255, 255, 255, 199, 24, 4, 224, 255, 255, 255, 255, 200, 188, 147, 96, 255,
        255, 255, 255, 202, 119, 125, 80, 255, 255, 255, 255, 204, 231, 75, 16, 255, 255, 255, 255,
        205, 169, 23, 144, 255, 255, 255, 255, 206, 162, 67, 16, 255, 255, 255, 255, 207, 146, 52,
        16, 255, 255, 255, 255, 208, 78, 144, 96, 0, 0, 0, 0, 21, 39, 167, 208, 0, 0, 0, 0, 22, 24,
        220, 64, 0, 0, 0, 0, 23, 8, 219, 80, 0, 0, 0, 0, 23, 250, 15, 192, 0, 0, 0, 0, 24, 234, 14,
        208, 0, 0, 0, 0, 25, 219, 67, 64, 0, 0, 0, 0, 26, 204, 147, 208, 0, 0, 0, 0, 27, 188, 160,
        240, 0, 0, 0, 0, 28, 172, 145, 240, 0, 0, 0, 0, 29, 156, 130, 240, 0, 0, 0, 0, 30, 140,
        115, 240, 0, 0, 0, 0, 31, 124, 100, 240, 0, 0, 0, 0, 32, 108, 85, 240, 0, 0, 0, 0, 33, 92,
        70, 240, 0, 0, 0, 0, 34, 76, 55, 240, 0, 0, 0, 0, 35, 60, 40, 240, 0, 0, 0, 0, 36, 44, 25,
        240, 0, 0, 0, 0, 37, 28, 10, 240, 0, 0, 0, 0, 38, 11, 251, 240, 0, 0, 0, 0, 38, 67, 76,
        224, 0, 0, 0, 0, 39, 5, 53, 128, 0, 0, 0, 0, 39, 245, 38, 128, 0, 0, 0, 0, 40, 229, 23,
        128, 0, 0, 0, 0, 41, 212, 236, 96, 0, 0, 0, 0, 42, 196, 207, 80, 0, 0, 0, 0, 43, 180, 206,
        96, 0, 0, 0, 0, 44, 164, 177, 80, 0, 0, 0, 0, 45, 148, 176, 96, 0, 0, 0, 0, 46, 132, 147,
        80, 0, 0, 0, 0, 47, 116, 146, 96, 0, 0, 0, 0, 48, 100, 117, 80, 0, 0, 0, 0, 49, 93, 174,
        224, 0, 0, 0, 0, 50, 114, 123, 208, 0, 0, 0, 0, 51, 61, 173, 0, 1, 2, 4, 3, 4, 3, 4, 3, 4,
        3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 6, 5, 6, 5, 6, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7, 8, 7,
        8, 7, 8, 7, 8, 7, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 0, 0, 27, 8, 0, 0, 0, 0, 26,
        244, 0, 4, 0, 0, 24, 120, 0, 8, 0, 0, 42, 48, 1, 12, 0, 0, 28, 32, 0, 17, 0, 0, 14, 16, 0,
        21, 0, 0, 28, 32, 1, 25, 0, 0, 56, 64, 1, 30, 0, 0, 42, 48, 0, 34, 76, 77, 84, 0, 67, 77,
        84, 0, 66, 77, 84, 0, 69, 69, 83, 84, 0, 69, 69, 84, 0, 67, 69, 84, 0, 67, 69, 83, 84, 0,
        77, 83, 68, 0, 77, 83, 75, 0, 10, 69, 69, 84, 45, 50, 69, 69, 83, 84, 44, 77, 51, 46, 53,
        46, 48, 44, 77, 49, 48, 46, 53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const EuropeCopenhagen: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        51, 0, 0, 0, 4, 0, 0, 0, 17, 255, 255, 255, 255, 105, 134, 207, 180, 255, 255, 255, 255,
        113, 12, 239, 52, 255, 255, 255, 255, 155, 30, 140, 96, 255, 255, 255, 255, 155, 213, 190,
        208, 255, 255, 255, 255, 200, 67, 87, 112, 255, 255, 255, 255, 204, 231, 75, 16, 255, 255,
        255, 255, 205, 169, 23, 144, 255, 255, 255, 255, 206, 162, 67, 16, 255, 255, 255, 255, 207,
        146, 52, 16, 255, 255, 255, 255, 208, 130, 37, 16, 255, 255, 255, 255, 209, 114, 22, 16,
        255, 255, 255, 255, 210, 36, 16, 144, 255, 255, 255, 255, 211, 121, 133, 16, 255, 255, 255,
        255, 212, 27, 173, 144, 255, 255, 255, 255, 213, 94, 173, 16, 255, 255, 255, 255, 213, 223,
        224, 16, 255, 255, 255, 255, 215, 71, 201, 144, 255, 255, 255, 255, 215, 191, 194, 16, 0,
        0, 0, 0, 19, 77, 68, 16, 0, 0, 0, 0, 20, 51, 250, 144, 0, 0, 0, 0, 21, 35, 235, 144, 0, 0,
        0, 0, 22, 19, 220, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23, 243, 190, 144, 0, 0,
        0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0,
        0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0,
        0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0,
        0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0,
        0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39,
        5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41,
        213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0, 0, 0, 44,
        164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0, 0, 0, 0,
        47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 1, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 0, 0, 11, 204, 0, 0, 0, 0, 11, 204, 0,
        4, 0, 0, 28, 32, 1, 8, 0, 0, 14, 16, 0, 13, 76, 77, 84, 0, 67, 77, 84, 0, 67, 69, 83, 84,
        0, 67, 69, 84, 0, 10, 67, 69, 84, 45, 49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44,
        77, 49, 48, 46, 53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const EuropeGibraltar: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        115, 0, 0, 0, 6, 0, 0, 0, 26, 255, 255, 255, 255, 87, 209, 10, 4, 255, 255, 255, 255, 155,
        38, 173, 160, 255, 255, 255, 255, 155, 214, 5, 32, 255, 255, 255, 255, 156, 207, 48, 160,
        255, 255, 255, 255, 157, 164, 195, 160, 255, 255, 255, 255, 158, 156, 157, 160, 255, 255,
        255, 255, 159, 151, 26, 160, 255, 255, 255, 255, 160, 133, 186, 32, 255, 255, 255, 255,
        161, 118, 252, 160, 255, 255, 255, 255, 162, 101, 156, 32, 255, 255, 255, 255, 163, 123,
        200, 160, 255, 255, 255, 255, 164, 78, 184, 160, 255, 255, 255, 255, 165, 63, 251, 32, 255,
        255, 255, 255, 166, 37, 96, 32, 255, 255, 255, 255, 167, 39, 198, 32, 255, 255, 255, 255,
        168, 42, 44, 32, 255, 255, 255, 255, 168, 235, 248, 160, 255, 255, 255, 255, 170, 0, 211,
        160, 255, 255, 255, 255, 170, 213, 21, 32, 255, 255, 255, 255, 171, 233, 240, 32, 255, 255,
        255, 255, 172, 199, 108, 32, 255, 255, 255, 255, 173, 201, 210, 32, 255, 255, 255, 255,
        174, 167, 78, 32, 255, 255, 255, 255, 175, 160, 121, 160, 255, 255, 255, 255, 176, 135, 48,
        32, 255, 255, 255, 255, 177, 146, 208, 160, 255, 255, 255, 255, 178, 112, 76, 160, 255,
        255, 255, 255, 179, 114, 178, 160, 255, 255, 255, 255, 180, 80, 46, 160, 255, 255, 255,
        255, 181, 73, 90, 32, 255, 255, 255, 255, 182, 48, 16, 160, 255, 255, 255, 255, 183, 50,
        118, 160, 255, 255, 255, 255, 184, 15, 242, 160, 255, 255, 255, 255, 185, 18, 88, 160, 255,
        255, 255, 255, 185, 239, 212, 160, 255, 255, 255, 255, 186, 233, 0, 32, 255, 255, 255, 255,
        187, 216, 241, 32, 255, 255, 255, 255, 188, 219, 87, 32, 255, 255, 255, 255, 189, 184, 211,
        32, 255, 255, 255, 255, 190, 177, 254, 160, 255, 255, 255, 255, 191, 152, 181, 32, 255,
        255, 255, 255, 192, 155, 27, 32, 255, 255, 255, 255, 193, 120, 151, 32, 255, 255, 255, 255,
        194, 122, 253, 32, 255, 255, 255, 255, 195, 88, 121, 32, 255, 255, 255, 255, 196, 81, 164,
        160, 255, 255, 255, 255, 197, 56, 91, 32, 255, 255, 255, 255, 198, 58, 193, 32, 255, 255,
        255, 255, 199, 88, 214, 160, 255, 255, 255, 255, 199, 218, 9, 160, 255, 255, 255, 255, 202,
        22, 38, 144, 255, 255, 255, 255, 202, 151, 89, 144, 255, 255, 255, 255, 203, 209, 30, 144,
        255, 255, 255, 255, 204, 119, 59, 144, 255, 255, 255, 255, 205, 177, 0, 144, 255, 255, 255,
        255, 206, 96, 88, 16, 255, 255, 255, 255, 207, 144, 226, 144, 255, 255, 255, 255, 208, 110,
        94, 144, 255, 255, 255, 255, 209, 114, 22, 16, 255, 255, 255, 255, 209, 251, 50, 16, 255,
        255, 255, 255, 210, 105, 254, 32, 255, 255, 255, 255, 211, 99, 41, 160, 255, 255, 255, 255,
        212, 73, 224, 32, 255, 255, 255, 255, 213, 30, 33, 160, 255, 255, 255, 255, 213, 66, 253,
        144, 255, 255, 255, 255, 213, 223, 224, 16, 255, 255, 255, 255, 214, 78, 172, 32, 255, 255,
        255, 255, 214, 254, 3, 160, 255, 255, 255, 255, 216, 46, 142, 32, 255, 255, 255, 255, 216,
        249, 149, 32, 255, 255, 255, 255, 218, 14, 112, 32, 255, 255, 255, 255, 218, 235, 236, 32,
        255, 255, 255, 255, 219, 229, 23, 160, 255, 255, 255, 255, 220, 203, 206, 32, 255, 255,
        255, 255, 221, 196, 249, 160, 255, 255, 255, 255, 222, 180, 234, 160, 255, 255, 255, 255,
        223, 174, 22, 32, 255, 255, 255, 255, 224, 148, 204, 160, 255, 255, 255, 255, 225, 114, 72,
        160, 255, 255, 255, 255, 226, 107, 116, 32, 255, 255, 255, 255, 227, 82, 42, 160, 255, 255,
        255, 255, 228, 84, 144, 160, 255, 255, 255, 255, 229, 50, 12, 160, 255, 255, 255, 255, 230,
        61, 173, 32, 255, 255, 255, 255, 231, 27, 41, 32, 255, 255, 255, 255, 232, 20, 84, 160, 0,
        0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23, 243, 190, 144, 0, 0, 0, 0, 24, 227, 175, 144, 0,
        0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0,
        0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0,
        0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0,
        0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0,
        37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39,
        245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42,
        197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45,
        148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0,
        48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 2, 1, 2, 1, 3, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4,
        5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 255, 255, 250, 252, 0, 0, 0, 0, 14, 16, 1, 4, 0, 0, 0, 0,
        0, 8, 0, 0, 28, 32, 1, 12, 0, 0, 14, 16, 0, 17, 0, 0, 28, 32, 1, 21, 76, 77, 84, 0, 66, 83,
        84, 0, 71, 77, 84, 0, 66, 68, 83, 84, 0, 67, 69, 84, 0, 67, 69, 83, 84, 0, 10, 67, 69, 84,
        45, 49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48, 47, 51,
        10,
    ];
    pub(crate) const EuropeHelsinki: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        35, 0, 0, 0, 4, 0, 0, 0, 17, 255, 255, 255, 255, 83, 186, 38, 155, 255, 255, 255, 255, 164,
        115, 111, 27, 255, 255, 255, 255, 203, 206, 81, 96, 255, 255, 255, 255, 204, 192, 229, 96,
        0, 0, 0, 0, 21, 35, 221, 128, 0, 0, 0, 0, 22, 19, 206, 128, 0, 0, 0, 0, 23, 3, 191, 128, 0,
        0, 0, 0, 23, 243, 176, 128, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144,
        0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16,
        0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16,
        0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0,
        0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0,
        38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40,
        229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43,
        180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0,
        46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0,
        0, 49, 93, 217, 16, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 0, 0, 23, 101, 0, 0, 0, 0, 23, 101, 0, 4, 0, 0, 42, 48, 1,
        8, 0, 0, 28, 32, 0, 13, 76, 77, 84, 0, 72, 77, 84, 0, 69, 69, 83, 84, 0, 69, 69, 84, 0, 10,
        69, 69, 84, 45, 50, 69, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 47, 51, 44, 77, 49, 48, 46,
        53, 46, 48, 47, 52, 10,
    ];
    pub(crate) const EuropeKaliningrad: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        80, 0, 0, 0, 8, 0, 0, 0, 34, 255, 255, 255, 255, 111, 162, 91, 72, 255, 255, 255, 255, 155,
        12, 23, 96, 255, 255, 255, 255, 155, 213, 218, 240, 255, 255, 255, 255, 156, 217, 174, 144,
        255, 255, 255, 255, 157, 164, 181, 144, 255, 255, 255, 255, 158, 185, 144, 144, 255, 255,
        255, 255, 159, 132, 151, 144, 255, 255, 255, 255, 200, 9, 113, 144, 255, 255, 255, 255,
        204, 231, 75, 16, 255, 255, 255, 255, 205, 169, 23, 144, 255, 255, 255, 255, 206, 162, 67,
        16, 255, 255, 255, 255, 207, 146, 52, 16, 255, 255, 255, 255, 208, 130, 37, 16, 255, 255,
        255, 255, 209, 114, 22, 16, 255, 255, 255, 255, 209, 124, 119, 224, 255, 255, 255, 255,
        209, 149, 132, 96, 255, 255, 255, 255, 210, 138, 173, 80, 255, 255, 255, 255, 211, 89, 182,
        224, 0, 0, 0, 0, 21, 39, 167, 208, 0, 0, 0, 0, 22, 24, 220, 64, 0, 0, 0, 0, 23, 8, 219, 80,
        0, 0, 0, 0, 23, 250, 15, 192, 0, 0, 0, 0, 24, 234, 14, 208, 0, 0, 0, 0, 25, 219, 67, 64, 0,
        0, 0, 0, 26, 204, 147, 208, 0, 0, 0, 0, 27, 188, 160, 240, 0, 0, 0, 0, 28, 172, 145, 240,
        0, 0, 0, 0, 29, 156, 130, 240, 0, 0, 0, 0, 30, 140, 115, 240, 0, 0, 0, 0, 31, 124, 100,
        240, 0, 0, 0, 0, 32, 108, 85, 240, 0, 0, 0, 0, 33, 92, 70, 240, 0, 0, 0, 0, 34, 76, 55,
        240, 0, 0, 0, 0, 35, 60, 40, 240, 0, 0, 0, 0, 36, 44, 25, 240, 0, 0, 0, 0, 37, 28, 25, 0,
        0, 0, 0, 0, 38, 12, 10, 0, 0, 0, 0, 0, 39, 5, 53, 128, 0, 0, 0, 0, 39, 245, 38, 128, 0, 0,
        0, 0, 40, 229, 23, 128, 0, 0, 0, 0, 41, 213, 8, 128, 0, 0, 0, 0, 42, 196, 249, 128, 0, 0,
        0, 0, 43, 180, 234, 128, 0, 0, 0, 0, 44, 164, 219, 128, 0, 0, 0, 0, 45, 148, 204, 128, 0,
        0, 0, 0, 46, 132, 189, 128, 0, 0, 0, 0, 47, 116, 174, 128, 0, 0, 0, 0, 48, 100, 159, 128,
        0, 0, 0, 0, 49, 93, 203, 0, 0, 0, 0, 0, 50, 114, 166, 0, 0, 0, 0, 0, 51, 61, 173, 0, 0, 0,
        0, 0, 52, 82, 136, 0, 0, 0, 0, 0, 53, 29, 143, 0, 0, 0, 0, 0, 54, 50, 106, 0, 0, 0, 0, 0,
        54, 253, 113, 0, 0, 0, 0, 0, 56, 27, 134, 128, 0, 0, 0, 0, 56, 221, 83, 0, 0, 0, 0, 0, 57,
        251, 104, 128, 0, 0, 0, 0, 58, 189, 53, 0, 0, 0, 0, 0, 59, 219, 74, 128, 0, 0, 0, 0, 60,
        166, 81, 128, 0, 0, 0, 0, 61, 187, 44, 128, 0, 0, 0, 0, 62, 134, 51, 128, 0, 0, 0, 0, 63,
        155, 14, 128, 0, 0, 0, 0, 64, 102, 21, 128, 0, 0, 0, 0, 65, 132, 43, 0, 0, 0, 0, 0, 66, 69,
        247, 128, 0, 0, 0, 0, 67, 100, 13, 0, 0, 0, 0, 0, 68, 37, 217, 128, 0, 0, 0, 0, 69, 67,
        239, 0, 0, 0, 0, 0, 70, 5, 187, 128, 0, 0, 0, 0, 71, 35, 209, 0, 0, 0, 0, 0, 71, 238, 216,
        0, 0, 0, 0, 0, 73, 3, 179, 0, 0, 0, 0, 0, 73, 206, 186, 0, 0, 0, 0, 0, 74, 227, 149, 0, 0,
        0, 0, 0, 75, 174, 156, 0, 0, 0, 0, 0, 76, 204, 177, 128, 0, 0, 0, 0, 77, 142, 126, 0, 0, 0,
        0, 0, 84, 76, 43, 112, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 4, 3, 4, 6, 5, 6, 5, 6, 5,
        6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 7, 4, 0, 0, 19,
        56, 0, 0, 0, 0, 28, 32, 1, 4, 0, 0, 14, 16, 0, 9, 0, 0, 42, 48, 1, 13, 0, 0, 28, 32, 0, 18,
        0, 0, 56, 64, 1, 22, 0, 0, 42, 48, 0, 26, 0, 0, 42, 48, 0, 30, 76, 77, 84, 0, 67, 69, 83,
        84, 0, 67, 69, 84, 0, 69, 69, 83, 84, 0, 69, 69, 84, 0, 77, 83, 68, 0, 77, 83, 75, 0, 43,
        48, 51, 0, 10, 69, 69, 84, 45, 50, 10,
    ];
    pub(crate) const EuropeKiev: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        38, 0, 0, 0, 8, 0, 0, 0, 34, 255, 255, 255, 255, 86, 182, 199, 100, 255, 255, 255, 255,
        170, 25, 167, 100, 255, 255, 255, 255, 181, 164, 25, 96, 255, 255, 255, 255, 202, 205, 46,
        208, 255, 255, 255, 255, 204, 231, 75, 16, 255, 255, 255, 255, 205, 169, 23, 144, 255, 255,
        255, 255, 206, 162, 67, 16, 255, 255, 255, 255, 206, 205, 168, 112, 0, 0, 0, 0, 21, 39,
        167, 208, 0, 0, 0, 0, 22, 24, 220, 64, 0, 0, 0, 0, 23, 8, 219, 80, 0, 0, 0, 0, 23, 250, 15,
        192, 0, 0, 0, 0, 24, 234, 14, 208, 0, 0, 0, 0, 25, 219, 67, 64, 0, 0, 0, 0, 26, 204, 147,
        208, 0, 0, 0, 0, 27, 188, 160, 240, 0, 0, 0, 0, 28, 172, 145, 240, 0, 0, 0, 0, 29, 156,
        130, 240, 0, 0, 0, 0, 30, 140, 115, 240, 0, 0, 0, 0, 31, 124, 100, 240, 0, 0, 0, 0, 32,
        108, 85, 240, 0, 0, 0, 0, 33, 92, 70, 240, 0, 0, 0, 0, 34, 76, 55, 240, 0, 0, 0, 0, 35, 60,
        40, 240, 0, 0, 0, 0, 36, 44, 25, 240, 0, 0, 0, 0, 37, 28, 10, 240, 0, 0, 0, 0, 38, 11, 251,
        240, 0, 0, 0, 0, 38, 141, 32, 224, 0, 0, 0, 0, 40, 229, 23, 128, 0, 0, 0, 0, 41, 212, 236,
        96, 0, 0, 0, 0, 42, 196, 207, 80, 0, 0, 0, 0, 43, 180, 206, 96, 0, 0, 0, 0, 44, 164, 177,
        80, 0, 0, 0, 0, 45, 148, 176, 96, 0, 0, 0, 0, 46, 132, 147, 80, 0, 0, 0, 0, 47, 116, 188,
        144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 1, 2, 3, 5, 4, 5, 4, 3, 6,
        3, 6, 3, 6, 3, 6, 3, 6, 3, 6, 3, 6, 3, 6, 3, 6, 3, 6, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 0,
        0, 28, 156, 0, 0, 0, 0, 28, 156, 0, 4, 0, 0, 28, 32, 0, 8, 0, 0, 42, 48, 0, 12, 0, 0, 14,
        16, 0, 16, 0, 0, 28, 32, 1, 20, 0, 0, 56, 64, 1, 25, 0, 0, 42, 48, 1, 29, 76, 77, 84, 0,
        75, 77, 84, 0, 69, 69, 84, 0, 77, 83, 75, 0, 67, 69, 84, 0, 67, 69, 83, 84, 0, 77, 83, 68,
        0, 69, 69, 83, 84, 0, 10, 69, 69, 84, 45, 50, 69, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48,
        47, 51, 44, 77, 49, 48, 46, 53, 46, 48, 47, 52, 10,
    ];
    pub(crate) const EuropeKirov: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        63, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 161, 0, 57, 128, 255, 255, 255, 255, 181,
        164, 11, 80, 0, 0, 0, 0, 21, 39, 153, 192, 0, 0, 0, 0, 22, 24, 206, 48, 0, 0, 0, 0, 23, 8,
        205, 64, 0, 0, 0, 0, 23, 250, 1, 176, 0, 0, 0, 0, 24, 234, 0, 192, 0, 0, 0, 0, 25, 219, 53,
        48, 0, 0, 0, 0, 26, 204, 133, 192, 0, 0, 0, 0, 27, 188, 146, 224, 0, 0, 0, 0, 28, 172, 131,
        224, 0, 0, 0, 0, 29, 156, 116, 224, 0, 0, 0, 0, 30, 140, 101, 224, 0, 0, 0, 0, 31, 124, 86,
        224, 0, 0, 0, 0, 32, 108, 71, 224, 0, 0, 0, 0, 33, 92, 56, 224, 0, 0, 0, 0, 34, 76, 41,
        224, 0, 0, 0, 0, 35, 60, 26, 224, 0, 0, 0, 0, 36, 44, 11, 224, 0, 0, 0, 0, 37, 28, 10, 240,
        0, 0, 0, 0, 38, 11, 251, 240, 0, 0, 0, 0, 39, 5, 39, 112, 0, 0, 0, 0, 39, 245, 24, 112, 0,
        0, 0, 0, 41, 212, 236, 96, 0, 0, 0, 0, 42, 196, 235, 112, 0, 0, 0, 0, 43, 180, 220, 112, 0,
        0, 0, 0, 44, 164, 205, 112, 0, 0, 0, 0, 45, 148, 190, 112, 0, 0, 0, 0, 46, 132, 175, 112,
        0, 0, 0, 0, 47, 116, 160, 112, 0, 0, 0, 0, 48, 100, 145, 112, 0, 0, 0, 0, 49, 93, 188, 240,
        0, 0, 0, 0, 50, 114, 151, 240, 0, 0, 0, 0, 51, 61, 158, 240, 0, 0, 0, 0, 52, 82, 121, 240,
        0, 0, 0, 0, 53, 29, 128, 240, 0, 0, 0, 0, 54, 50, 91, 240, 0, 0, 0, 0, 54, 253, 98, 240, 0,
        0, 0, 0, 56, 27, 120, 112, 0, 0, 0, 0, 56, 221, 68, 240, 0, 0, 0, 0, 57, 251, 90, 112, 0,
        0, 0, 0, 58, 189, 38, 240, 0, 0, 0, 0, 59, 219, 60, 112, 0, 0, 0, 0, 60, 166, 67, 112, 0,
        0, 0, 0, 61, 187, 30, 112, 0, 0, 0, 0, 62, 134, 37, 112, 0, 0, 0, 0, 63, 155, 0, 112, 0, 0,
        0, 0, 64, 102, 7, 112, 0, 0, 0, 0, 65, 132, 28, 240, 0, 0, 0, 0, 66, 69, 233, 112, 0, 0, 0,
        0, 67, 99, 254, 240, 0, 0, 0, 0, 68, 37, 203, 112, 0, 0, 0, 0, 69, 67, 224, 240, 0, 0, 0,
        0, 70, 5, 173, 112, 0, 0, 0, 0, 71, 35, 194, 240, 0, 0, 0, 0, 71, 238, 201, 240, 0, 0, 0,
        0, 73, 3, 164, 240, 0, 0, 0, 0, 73, 206, 171, 240, 0, 0, 0, 0, 74, 227, 134, 240, 0, 0, 0,
        0, 75, 174, 141, 240, 0, 0, 0, 0, 76, 204, 163, 112, 0, 0, 0, 0, 77, 142, 111, 240, 0, 0,
        0, 0, 84, 76, 29, 96, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 4, 1, 4, 1, 3,
        4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1,
        4, 1, 4, 1, 4, 1, 4, 1, 3, 1, 0, 0, 46, 152, 0, 0, 0, 0, 42, 48, 0, 4, 0, 0, 70, 80, 1, 8,
        0, 0, 56, 64, 0, 12, 0, 0, 56, 64, 1, 12, 76, 77, 84, 0, 43, 48, 51, 0, 43, 48, 53, 0, 43,
        48, 52, 0, 10, 60, 43, 48, 51, 62, 45, 51, 10,
    ];
    pub(crate) const EuropeLisbon: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        141, 0, 0, 0, 6, 0, 0, 0, 27, 255, 255, 255, 255, 94, 61, 12, 29, 255, 255, 255, 255, 146,
        230, 142, 128, 255, 255, 255, 255, 155, 75, 109, 112, 255, 255, 255, 255, 155, 254, 199,
        128, 255, 255, 255, 255, 156, 156, 237, 112, 255, 255, 255, 255, 157, 201, 131, 112, 255,
        255, 255, 255, 158, 127, 114, 112, 255, 255, 255, 255, 159, 170, 182, 240, 255, 255, 255,
        255, 160, 95, 84, 112, 255, 255, 255, 255, 161, 139, 234, 112, 255, 255, 255, 255, 162, 65,
        217, 112, 255, 255, 255, 255, 163, 110, 111, 112, 255, 255, 255, 255, 164, 35, 12, 240,
        255, 255, 255, 255, 165, 79, 162, 240, 255, 255, 255, 255, 170, 5, 239, 112, 255, 255, 255,
        255, 170, 244, 142, 240, 255, 255, 255, 255, 173, 201, 167, 240, 255, 255, 255, 255, 174,
        167, 35, 240, 255, 255, 255, 255, 175, 160, 79, 112, 255, 255, 255, 255, 176, 135, 5, 240,
        255, 255, 255, 255, 177, 137, 107, 240, 255, 255, 255, 255, 178, 112, 34, 112, 255, 255,
        255, 255, 179, 114, 136, 112, 255, 255, 255, 255, 180, 80, 4, 112, 255, 255, 255, 255, 183,
        50, 76, 112, 255, 255, 255, 255, 184, 15, 200, 112, 255, 255, 255, 255, 184, 255, 185, 112,
        255, 255, 255, 255, 185, 239, 170, 112, 255, 255, 255, 255, 188, 200, 183, 240, 255, 255,
        255, 255, 189, 184, 168, 240, 255, 255, 255, 255, 190, 159, 95, 112, 255, 255, 255, 255,
        191, 152, 138, 240, 255, 255, 255, 255, 192, 154, 240, 240, 255, 255, 255, 255, 193, 120,
        108, 240, 255, 255, 255, 255, 194, 104, 93, 240, 255, 255, 255, 255, 195, 88, 78, 240, 255,
        255, 255, 255, 196, 63, 5, 112, 255, 255, 255, 255, 197, 56, 48, 240, 255, 255, 255, 255,
        198, 58, 150, 240, 255, 255, 255, 255, 199, 88, 172, 112, 255, 255, 255, 255, 199, 217,
        223, 112, 255, 255, 255, 255, 201, 1, 47, 112, 255, 255, 255, 255, 201, 241, 32, 112, 255,
        255, 255, 255, 202, 226, 98, 240, 255, 255, 255, 255, 203, 181, 82, 240, 255, 255, 255,
        255, 203, 236, 163, 224, 255, 255, 255, 255, 204, 128, 75, 224, 255, 255, 255, 255, 204,
        220, 162, 240, 255, 255, 255, 255, 205, 149, 52, 240, 255, 255, 255, 255, 205, 195, 75, 96,
        255, 255, 255, 255, 206, 114, 162, 224, 255, 255, 255, 255, 206, 197, 191, 112, 255, 255,
        255, 255, 207, 117, 22, 240, 255, 255, 255, 255, 207, 172, 103, 224, 255, 255, 255, 255,
        208, 82, 132, 224, 255, 255, 255, 255, 208, 165, 161, 112, 255, 255, 255, 255, 209, 84,
        248, 240, 255, 255, 255, 255, 209, 140, 73, 224, 255, 255, 255, 255, 210, 50, 102, 224,
        255, 255, 255, 255, 210, 133, 131, 112, 255, 255, 255, 255, 211, 89, 196, 240, 255, 255,
        255, 255, 212, 73, 181, 240, 255, 255, 255, 255, 213, 57, 209, 32, 255, 255, 255, 255, 214,
        41, 194, 32, 255, 255, 255, 255, 215, 25, 179, 32, 255, 255, 255, 255, 216, 9, 164, 32,
        255, 255, 255, 255, 216, 249, 149, 32, 255, 255, 255, 255, 217, 233, 134, 32, 255, 255,
        255, 255, 218, 217, 119, 32, 255, 255, 255, 255, 219, 201, 104, 32, 255, 255, 255, 255,
        220, 185, 89, 32, 255, 255, 255, 255, 221, 178, 132, 160, 255, 255, 255, 255, 222, 162,
        117, 160, 255, 255, 255, 255, 223, 146, 102, 160, 255, 255, 255, 255, 224, 130, 87, 160,
        255, 255, 255, 255, 225, 114, 72, 160, 255, 255, 255, 255, 226, 98, 57, 160, 255, 255, 255,
        255, 227, 82, 42, 160, 255, 255, 255, 255, 228, 66, 27, 160, 255, 255, 255, 255, 229, 50,
        12, 160, 255, 255, 255, 255, 230, 33, 253, 160, 255, 255, 255, 255, 231, 27, 41, 32, 255,
        255, 255, 255, 232, 11, 26, 32, 255, 255, 255, 255, 232, 251, 11, 32, 255, 255, 255, 255,
        233, 234, 252, 32, 255, 255, 255, 255, 234, 218, 237, 32, 255, 255, 255, 255, 235, 202,
        222, 32, 255, 255, 255, 255, 236, 186, 207, 32, 255, 255, 255, 255, 237, 170, 192, 32, 255,
        255, 255, 255, 238, 154, 177, 32, 255, 255, 255, 255, 239, 138, 162, 32, 255, 255, 255,
        255, 240, 122, 147, 32, 255, 255, 255, 255, 241, 106, 132, 32, 255, 255, 255, 255, 242, 99,
        175, 160, 255, 255, 255, 255, 243, 83, 160, 160, 255, 255, 255, 255, 244, 67, 145, 160,
        255, 255, 255, 255, 245, 51, 130, 160, 255, 255, 255, 255, 246, 35, 115, 160, 255, 255,
        255, 255, 247, 19, 100, 160, 255, 255, 255, 255, 248, 3, 85, 160, 255, 255, 255, 255, 248,
        243, 70, 160, 0, 0, 0, 0, 12, 171, 42, 0, 0, 0, 0, 0, 13, 155, 27, 0, 0, 0, 0, 0, 14, 139,
        12, 0, 0, 0, 0, 0, 15, 132, 55, 128, 0, 0, 0, 0, 16, 116, 40, 128, 0, 0, 0, 0, 17, 100, 25,
        128, 0, 0, 0, 0, 18, 84, 24, 144, 0, 0, 0, 0, 19, 67, 251, 128, 0, 0, 0, 0, 20, 51, 250,
        144, 0, 0, 0, 0, 21, 35, 235, 144, 0, 0, 0, 0, 22, 19, 220, 144, 0, 0, 0, 0, 23, 3, 205,
        144, 0, 0, 0, 0, 23, 243, 190, 144, 0, 0, 0, 0, 24, 227, 189, 160, 0, 0, 0, 0, 25, 211,
        160, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172,
        174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124,
        129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84,
        16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0,
        0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0,
        0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0,
        43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0,
        0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0,
        0, 0, 49, 93, 217, 16, 0, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 3, 1, 2, 1, 3, 1, 2, 1,
        3, 1, 2, 1, 3, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 4, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 4, 5, 4, 5, 4, 5, 4, 1, 255,
        255, 247, 99, 0, 0, 0, 0, 14, 16, 1, 4, 0, 0, 0, 0, 0, 9, 0, 0, 28, 32, 1, 13, 0, 0, 14,
        16, 0, 18, 0, 0, 28, 32, 1, 22, 76, 77, 84, 0, 87, 69, 83, 84, 0, 87, 69, 84, 0, 87, 69,
        77, 84, 0, 67, 69, 84, 0, 67, 69, 83, 84, 0, 10, 87, 69, 84, 48, 87, 69, 83, 84, 44, 77,
        51, 46, 53, 46, 48, 47, 49, 44, 77, 49, 48, 46, 53, 46, 48, 10,
    ];
    pub(crate) const EuropeLuxembourg: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        100, 0, 0, 0, 7, 0, 0, 0, 22, 255, 255, 255, 255, 132, 162, 173, 188, 255, 255, 255, 255,
        155, 30, 140, 96, 255, 255, 255, 255, 155, 213, 218, 240, 255, 255, 255, 255, 156, 234,
        167, 224, 255, 255, 255, 255, 157, 164, 153, 112, 255, 255, 255, 255, 158, 185, 144, 144,
        255, 255, 255, 255, 159, 132, 151, 144, 255, 255, 255, 255, 159, 224, 196, 112, 255, 255,
        255, 255, 160, 96, 165, 240, 255, 255, 255, 255, 161, 126, 229, 160, 255, 255, 255, 255,
        162, 46, 18, 240, 255, 255, 255, 255, 163, 122, 105, 16, 255, 255, 255, 255, 164, 53, 129,
        240, 255, 255, 255, 255, 165, 94, 63, 144, 255, 255, 255, 255, 166, 37, 53, 240, 255, 255,
        255, 255, 167, 39, 170, 0, 255, 255, 255, 255, 168, 42, 1, 240, 255, 255, 255, 255, 169, 7,
        154, 16, 255, 255, 255, 255, 169, 238, 52, 112, 255, 255, 255, 255, 170, 231, 110, 0, 255,
        255, 255, 255, 171, 216, 162, 112, 255, 255, 255, 255, 172, 199, 80, 0, 255, 255, 255, 255,
        173, 201, 167, 240, 255, 255, 255, 255, 174, 167, 50, 0, 255, 255, 255, 255, 175, 160, 79,
        112, 255, 255, 255, 255, 176, 135, 20, 0, 255, 255, 255, 255, 177, 137, 107, 240, 255, 255,
        255, 255, 178, 112, 48, 128, 255, 255, 255, 255, 179, 114, 136, 112, 255, 255, 255, 255,
        180, 80, 46, 160, 255, 255, 255, 255, 181, 73, 90, 32, 255, 255, 255, 255, 182, 48, 16,
        160, 255, 255, 255, 255, 183, 50, 118, 160, 255, 255, 255, 255, 184, 15, 242, 160, 255,
        255, 255, 255, 184, 255, 227, 160, 255, 255, 255, 255, 185, 239, 212, 160, 255, 255, 255,
        255, 186, 214, 139, 32, 255, 255, 255, 255, 187, 216, 241, 32, 255, 255, 255, 255, 188,
        200, 226, 32, 255, 255, 255, 255, 189, 184, 211, 32, 255, 255, 255, 255, 190, 159, 137,
        160, 255, 255, 255, 255, 191, 152, 181, 32, 255, 255, 255, 255, 192, 155, 27, 32, 255, 255,
        255, 255, 193, 120, 151, 32, 255, 255, 255, 255, 194, 104, 136, 32, 255, 255, 255, 255,
        195, 88, 121, 32, 255, 255, 255, 255, 196, 63, 47, 160, 255, 255, 255, 255, 197, 56, 91,
        32, 255, 255, 255, 255, 198, 58, 193, 32, 255, 255, 255, 255, 199, 88, 214, 160, 255, 255,
        255, 255, 199, 218, 9, 160, 255, 255, 255, 255, 200, 66, 48, 32, 255, 255, 255, 255, 204,
        231, 75, 16, 255, 255, 255, 255, 205, 169, 23, 144, 255, 255, 255, 255, 206, 162, 67, 16,
        255, 255, 255, 255, 207, 146, 52, 16, 255, 255, 255, 255, 208, 111, 176, 16, 255, 255, 255,
        255, 209, 114, 22, 16, 255, 255, 255, 255, 210, 78, 64, 144, 255, 255, 255, 255, 211, 145,
        64, 16, 255, 255, 255, 255, 212, 75, 35, 144, 0, 0, 0, 0, 13, 164, 99, 144, 0, 0, 0, 0, 14,
        139, 26, 16, 0, 0, 0, 0, 15, 132, 69, 144, 0, 0, 0, 0, 16, 116, 54, 144, 0, 0, 0, 0, 17,
        100, 39, 144, 0, 0, 0, 0, 18, 84, 24, 144, 0, 0, 0, 0, 19, 77, 68, 16, 0, 0, 0, 0, 20, 51,
        250, 144, 0, 0, 0, 0, 21, 35, 235, 144, 0, 0, 0, 0, 22, 19, 220, 144, 0, 0, 0, 0, 23, 3,
        205, 144, 0, 0, 0, 0, 23, 243, 190, 144, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25,
        211, 160, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28,
        172, 174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31,
        124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76,
        84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16,
        0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0,
        0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0,
        0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0,
        0, 0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0,
        0, 0, 0, 49, 93, 217, 16, 2, 1, 2, 1, 2, 1, 2, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4,
        3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 6,
        5, 6, 5, 6, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0, 0, 5, 196, 0, 0, 0, 0, 28, 32, 1,
        4, 0, 0, 14, 16, 0, 9, 0, 0, 14, 16, 1, 13, 0, 0, 0, 0, 0, 18, 0, 0, 14, 16, 0, 18, 0, 0,
        28, 32, 1, 13, 76, 77, 84, 0, 67, 69, 83, 84, 0, 67, 69, 84, 0, 87, 69, 83, 84, 0, 87, 69,
        84, 0, 10, 67, 69, 84, 45, 49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77, 49, 48,
        46, 53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const EuropeMadrid: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        79, 0, 0, 0, 6, 0, 0, 0, 27, 255, 255, 255, 255, 126, 54, 181, 0, 255, 255, 255, 255, 158,
        186, 197, 240, 255, 255, 255, 255, 159, 160, 57, 0, 255, 255, 255, 255, 160, 144, 27, 240,
        255, 255, 255, 255, 161, 129, 108, 128, 255, 255, 255, 255, 170, 5, 239, 112, 255, 255,
        255, 255, 170, 231, 110, 0, 255, 255, 255, 255, 173, 201, 167, 240, 255, 255, 255, 255,
        174, 167, 50, 0, 255, 255, 255, 255, 175, 160, 79, 112, 255, 255, 255, 255, 176, 135, 20,
        0, 255, 255, 255, 255, 177, 137, 122, 0, 255, 255, 255, 255, 178, 112, 48, 128, 255, 255,
        255, 255, 179, 114, 136, 112, 255, 255, 255, 255, 180, 80, 18, 128, 255, 255, 255, 255,
        194, 201, 236, 240, 255, 255, 255, 255, 195, 88, 93, 0, 255, 255, 255, 255, 196, 72, 63,
        240, 255, 255, 255, 255, 196, 109, 27, 224, 255, 255, 255, 255, 197, 57, 116, 96, 255, 255,
        255, 255, 199, 33, 91, 128, 255, 255, 255, 255, 199, 245, 142, 240, 255, 255, 255, 255,
        203, 245, 222, 96, 255, 255, 255, 255, 204, 149, 113, 240, 255, 255, 255, 255, 205, 195,
        75, 96, 255, 255, 255, 255, 206, 160, 213, 112, 255, 255, 255, 255, 207, 163, 45, 96, 255,
        255, 255, 255, 208, 128, 183, 112, 255, 255, 255, 255, 209, 131, 15, 96, 255, 255, 255,
        255, 210, 96, 153, 112, 255, 255, 255, 255, 211, 98, 241, 96, 255, 255, 255, 255, 212, 64,
        123, 112, 255, 255, 255, 255, 217, 30, 70, 224, 255, 255, 255, 255, 217, 233, 91, 240, 0,
        0, 0, 0, 8, 13, 205, 224, 0, 0, 0, 0, 8, 244, 146, 112, 0, 0, 0, 0, 9, 237, 175, 224, 0, 0,
        0, 0, 10, 212, 116, 112, 0, 0, 0, 0, 11, 187, 28, 224, 0, 0, 0, 0, 12, 171, 27, 240, 0, 0,
        0, 0, 13, 164, 57, 96, 0, 0, 0, 0, 14, 138, 253, 240, 0, 0, 0, 0, 15, 132, 69, 144, 0, 0,
        0, 0, 16, 116, 54, 144, 0, 0, 0, 0, 17, 100, 39, 144, 0, 0, 0, 0, 18, 84, 24, 144, 0, 0, 0,
        0, 19, 77, 68, 16, 0, 0, 0, 0, 20, 51, 250, 144, 0, 0, 0, 0, 21, 35, 235, 144, 0, 0, 0, 0,
        22, 19, 220, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23, 243, 190, 144, 0, 0, 0, 0,
        24, 227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0,
        0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0,
        0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0,
        0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36,
        44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67,
        144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22,
        144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233,
        144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116,
        188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 3, 1, 2, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4,
        5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4,
        5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 255, 255, 252, 140, 0, 0, 0, 0, 14, 16, 1, 4, 0, 0, 0,
        0, 0, 9, 0, 0, 28, 32, 1, 13, 0, 0, 28, 32, 1, 18, 0, 0, 14, 16, 0, 23, 76, 77, 84, 0, 87,
        69, 83, 84, 0, 87, 69, 84, 0, 87, 69, 77, 84, 0, 67, 69, 83, 84, 0, 67, 69, 84, 0, 10, 67,
        69, 84, 45, 49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48,
        47, 51, 10,
    ];
    pub(crate) const EuropeMalta: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        86, 0, 0, 0, 3, 0, 0, 0, 13, 255, 255, 255, 255, 112, 189, 211, 100, 255, 255, 255, 255,
        155, 56, 248, 112, 255, 255, 255, 255, 155, 213, 204, 224, 255, 255, 255, 255, 156, 197,
        203, 240, 255, 255, 255, 255, 157, 183, 0, 96, 255, 255, 255, 255, 158, 137, 254, 112, 255,
        255, 255, 255, 159, 160, 28, 224, 255, 255, 255, 255, 160, 96, 165, 240, 255, 255, 255,
        255, 161, 126, 173, 96, 255, 255, 255, 255, 162, 92, 55, 112, 255, 255, 255, 255, 163, 76,
        26, 96, 255, 255, 255, 255, 200, 108, 53, 240, 255, 255, 255, 255, 204, 231, 75, 16, 255,
        255, 255, 255, 205, 169, 23, 144, 255, 255, 255, 255, 206, 162, 67, 16, 255, 255, 255, 255,
        207, 144, 226, 144, 255, 255, 255, 255, 208, 110, 94, 144, 255, 255, 255, 255, 209, 114,
        22, 16, 255, 255, 255, 255, 210, 76, 210, 240, 255, 255, 255, 255, 211, 62, 49, 144, 255,
        255, 255, 255, 212, 73, 210, 16, 255, 255, 255, 255, 213, 29, 247, 112, 255, 255, 255, 255,
        214, 41, 151, 240, 255, 255, 255, 255, 214, 235, 128, 144, 255, 255, 255, 255, 216, 9, 150,
        16, 255, 255, 255, 255, 249, 51, 181, 240, 255, 255, 255, 255, 249, 217, 196, 224, 255,
        255, 255, 255, 251, 28, 210, 112, 255, 255, 255, 255, 251, 185, 180, 240, 255, 255, 255,
        255, 252, 252, 180, 112, 255, 255, 255, 255, 253, 153, 150, 240, 255, 255, 255, 255, 254,
        229, 208, 240, 255, 255, 255, 255, 255, 130, 179, 112, 0, 0, 0, 0, 0, 197, 178, 240, 0, 0,
        0, 0, 1, 98, 149, 112, 0, 0, 0, 0, 2, 156, 90, 112, 0, 0, 0, 0, 3, 66, 119, 112, 0, 0, 0,
        0, 4, 133, 118, 240, 0, 0, 0, 0, 5, 43, 147, 240, 0, 0, 0, 0, 6, 26, 51, 112, 0, 0, 0, 0,
        7, 10, 36, 112, 0, 0, 0, 0, 8, 23, 22, 112, 0, 0, 0, 0, 8, 218, 52, 112, 0, 0, 0, 0, 9,
        247, 20, 144, 0, 0, 0, 0, 10, 194, 13, 128, 0, 0, 0, 0, 11, 214, 246, 144, 0, 0, 0, 0, 12,
        161, 239, 128, 0, 0, 0, 0, 13, 182, 216, 144, 0, 0, 0, 0, 14, 129, 209, 128, 0, 0, 0, 0,
        15, 150, 186, 144, 0, 0, 0, 0, 16, 97, 179, 128, 0, 0, 0, 0, 17, 118, 156, 144, 0, 0, 0, 0,
        18, 65, 149, 128, 0, 0, 0, 0, 19, 69, 91, 16, 0, 0, 0, 0, 20, 42, 178, 0, 0, 0, 0, 0, 21,
        35, 235, 144, 0, 0, 0, 0, 22, 19, 220, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23,
        243, 190, 144, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0,
        26, 195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0,
        29, 156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0,
        32, 108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35,
        60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24,
        16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144,
        0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144,
        0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203,
        144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217,
        16, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0, 0, 13,
        156, 0, 0, 0, 0, 28, 32, 1, 4, 0, 0, 14, 16, 0, 9, 76, 77, 84, 0, 67, 69, 83, 84, 0, 67,
        69, 84, 0, 10, 67, 69, 84, 45, 49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77, 49,
        48, 46, 53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const EuropeMinsk: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        68, 0, 0, 0, 9, 0, 0, 0, 38, 255, 255, 255, 255, 86, 182, 202, 40, 255, 255, 255, 255, 170,
        25, 170, 56, 255, 255, 255, 255, 181, 164, 25, 96, 255, 255, 255, 255, 202, 94, 112, 208,
        255, 255, 255, 255, 204, 231, 75, 16, 255, 255, 255, 255, 205, 169, 23, 144, 255, 255, 255,
        255, 206, 162, 67, 16, 255, 255, 255, 255, 207, 146, 52, 16, 255, 255, 255, 255, 208, 10,
        2, 96, 0, 0, 0, 0, 21, 39, 167, 208, 0, 0, 0, 0, 22, 24, 220, 64, 0, 0, 0, 0, 23, 8, 219,
        80, 0, 0, 0, 0, 23, 250, 15, 192, 0, 0, 0, 0, 24, 234, 14, 208, 0, 0, 0, 0, 25, 219, 67,
        64, 0, 0, 0, 0, 26, 204, 147, 208, 0, 0, 0, 0, 27, 188, 160, 240, 0, 0, 0, 0, 28, 172, 145,
        240, 0, 0, 0, 0, 29, 156, 130, 240, 0, 0, 0, 0, 30, 140, 115, 240, 0, 0, 0, 0, 31, 124,
        100, 240, 0, 0, 0, 0, 32, 108, 85, 240, 0, 0, 0, 0, 33, 92, 70, 240, 0, 0, 0, 0, 34, 76,
        55, 240, 0, 0, 0, 0, 35, 60, 40, 240, 0, 0, 0, 0, 36, 44, 25, 240, 0, 0, 0, 0, 37, 28, 10,
        240, 0, 0, 0, 0, 39, 245, 24, 112, 0, 0, 0, 0, 40, 229, 23, 128, 0, 0, 0, 0, 41, 213, 8,
        128, 0, 0, 0, 0, 42, 196, 249, 128, 0, 0, 0, 0, 43, 180, 234, 128, 0, 0, 0, 0, 44, 164,
        219, 128, 0, 0, 0, 0, 45, 148, 204, 128, 0, 0, 0, 0, 46, 132, 189, 128, 0, 0, 0, 0, 47,
        116, 174, 128, 0, 0, 0, 0, 48, 100, 159, 128, 0, 0, 0, 0, 49, 93, 203, 0, 0, 0, 0, 0, 50,
        114, 166, 0, 0, 0, 0, 0, 51, 61, 173, 0, 0, 0, 0, 0, 52, 82, 136, 0, 0, 0, 0, 0, 53, 29,
        143, 0, 0, 0, 0, 0, 54, 50, 106, 0, 0, 0, 0, 0, 54, 253, 113, 0, 0, 0, 0, 0, 56, 27, 134,
        128, 0, 0, 0, 0, 56, 221, 83, 0, 0, 0, 0, 0, 57, 251, 104, 128, 0, 0, 0, 0, 58, 189, 53, 0,
        0, 0, 0, 0, 59, 219, 74, 128, 0, 0, 0, 0, 60, 166, 81, 128, 0, 0, 0, 0, 61, 187, 44, 128,
        0, 0, 0, 0, 62, 134, 51, 128, 0, 0, 0, 0, 63, 155, 14, 128, 0, 0, 0, 0, 64, 102, 21, 128,
        0, 0, 0, 0, 65, 132, 43, 0, 0, 0, 0, 0, 66, 69, 247, 128, 0, 0, 0, 0, 67, 100, 13, 0, 0, 0,
        0, 0, 68, 37, 217, 128, 0, 0, 0, 0, 69, 67, 239, 0, 0, 0, 0, 0, 70, 5, 187, 128, 0, 0, 0,
        0, 71, 35, 209, 0, 0, 0, 0, 0, 71, 238, 216, 0, 0, 0, 0, 0, 73, 3, 179, 0, 0, 0, 0, 0, 73,
        206, 186, 0, 0, 0, 0, 0, 74, 227, 149, 0, 0, 0, 0, 0, 75, 174, 156, 0, 0, 0, 0, 0, 76, 204,
        177, 128, 0, 0, 0, 0, 77, 142, 126, 0, 1, 2, 3, 5, 4, 5, 4, 5, 3, 6, 3, 6, 3, 6, 3, 6, 3,
        6, 3, 6, 3, 6, 3, 6, 3, 6, 3, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2,
        7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 8, 0, 0, 25, 216, 0, 0, 0, 0,
        25, 200, 0, 4, 0, 0, 28, 32, 0, 8, 0, 0, 42, 48, 0, 12, 0, 0, 14, 16, 0, 16, 0, 0, 28, 32,
        1, 20, 0, 0, 56, 64, 1, 25, 0, 0, 42, 48, 1, 29, 0, 0, 42, 48, 0, 34, 76, 77, 84, 0, 77,
        77, 84, 0, 69, 69, 84, 0, 77, 83, 75, 0, 67, 69, 84, 0, 67, 69, 83, 84, 0, 77, 83, 68, 0,
        69, 69, 83, 84, 0, 43, 48, 51, 0, 10, 60, 43, 48, 51, 62, 45, 51, 10,
    ];
    pub(crate) const EuropeMonaco: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        102, 0, 0, 0, 7, 0, 0, 0, 31, 255, 255, 255, 255, 110, 17, 159, 148, 255, 255, 255, 255,
        145, 120, 11, 79, 255, 255, 255, 255, 155, 71, 120, 240, 255, 255, 255, 255, 155, 215, 44,
        112, 255, 255, 255, 255, 156, 188, 145, 112, 255, 255, 255, 255, 157, 192, 72, 240, 255,
        255, 255, 255, 158, 137, 254, 112, 255, 255, 255, 255, 159, 160, 42, 240, 255, 255, 255,
        255, 160, 96, 165, 240, 255, 255, 255, 255, 161, 128, 12, 240, 255, 255, 255, 255, 162, 46,
        18, 240, 255, 255, 255, 255, 163, 122, 76, 240, 255, 255, 255, 255, 164, 53, 129, 240, 255,
        255, 255, 255, 165, 94, 35, 112, 255, 255, 255, 255, 166, 37, 53, 240, 255, 255, 255, 255,
        167, 39, 155, 240, 255, 255, 255, 255, 168, 88, 38, 112, 255, 255, 255, 255, 169, 7, 125,
        240, 255, 255, 255, 255, 169, 238, 52, 112, 255, 255, 255, 255, 170, 231, 95, 240, 255,
        255, 255, 255, 171, 215, 80, 240, 255, 255, 255, 255, 172, 199, 65, 240, 255, 255, 255,
        255, 173, 201, 167, 240, 255, 255, 255, 255, 174, 167, 35, 240, 255, 255, 255, 255, 175,
        160, 79, 112, 255, 255, 255, 255, 176, 135, 5, 240, 255, 255, 255, 255, 177, 137, 107, 240,
        255, 255, 255, 255, 178, 112, 34, 112, 255, 255, 255, 255, 179, 114, 136, 112, 255, 255,
        255, 255, 180, 80, 4, 112, 255, 255, 255, 255, 181, 73, 47, 240, 255, 255, 255, 255, 182,
        47, 230, 112, 255, 255, 255, 255, 183, 50, 76, 112, 255, 255, 255, 255, 184, 15, 200, 112,
        255, 255, 255, 255, 184, 255, 185, 112, 255, 255, 255, 255, 185, 239, 170, 112, 255, 255,
        255, 255, 186, 214, 96, 240, 255, 255, 255, 255, 187, 216, 198, 240, 255, 255, 255, 255,
        188, 200, 183, 240, 255, 255, 255, 255, 189, 184, 168, 240, 255, 255, 255, 255, 190, 159,
        95, 112, 255, 255, 255, 255, 191, 152, 138, 240, 255, 255, 255, 255, 192, 154, 240, 240,
        255, 255, 255, 255, 193, 120, 108, 240, 255, 255, 255, 255, 194, 104, 93, 240, 255, 255,
        255, 255, 195, 88, 78, 240, 255, 255, 255, 255, 196, 63, 5, 112, 255, 255, 255, 255, 197,
        56, 48, 240, 255, 255, 255, 255, 198, 58, 150, 240, 255, 255, 255, 255, 199, 88, 172, 112,
        255, 255, 255, 255, 199, 218, 9, 160, 255, 255, 255, 255, 202, 23, 91, 240, 255, 255, 255,
        255, 202, 226, 84, 224, 255, 255, 255, 255, 203, 173, 105, 240, 255, 255, 255, 255, 204,
        231, 75, 16, 255, 255, 255, 255, 205, 169, 23, 144, 255, 255, 255, 255, 206, 162, 67, 16,
        255, 255, 255, 255, 207, 146, 52, 16, 255, 255, 255, 255, 208, 137, 241, 240, 255, 255,
        255, 255, 209, 114, 22, 16, 255, 255, 255, 255, 210, 78, 64, 144, 0, 0, 0, 0, 11, 187, 57,
        0, 0, 0, 0, 0, 12, 171, 27, 240, 0, 0, 0, 0, 13, 164, 99, 144, 0, 0, 0, 0, 14, 139, 26, 16,
        0, 0, 0, 0, 15, 132, 69, 144, 0, 0, 0, 0, 16, 116, 54, 144, 0, 0, 0, 0, 17, 100, 39, 144,
        0, 0, 0, 0, 18, 84, 24, 144, 0, 0, 0, 0, 19, 77, 68, 16, 0, 0, 0, 0, 20, 51, 250, 144, 0,
        0, 0, 0, 21, 35, 235, 144, 0, 0, 0, 0, 22, 19, 220, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0,
        0, 0, 23, 243, 190, 144, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0,
        0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0,
        0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0,
        0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0,
        0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38,
        12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229,
        37, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180,
        248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46,
        132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0,
        49, 93, 217, 16, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 4, 2, 4, 2,
        4, 2, 4, 2, 4, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6,
        5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 0, 0, 6, 236, 0, 0, 0, 0, 2, 49, 0, 4,
        0, 0, 14, 16, 1, 8, 0, 0, 0, 0, 0, 13, 0, 0, 28, 32, 1, 17, 0, 0, 28, 32, 1, 22, 0, 0, 14,
        16, 0, 27, 76, 77, 84, 0, 80, 77, 84, 0, 87, 69, 83, 84, 0, 87, 69, 84, 0, 87, 69, 77, 84,
        0, 67, 69, 83, 84, 0, 67, 69, 84, 0, 10, 67, 69, 84, 45, 49, 67, 69, 83, 84, 44, 77, 51,
        46, 53, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const EuropeMoscow: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        78, 0, 0, 0, 11, 0, 0, 0, 38, 255, 255, 255, 255, 86, 182, 192, 199, 255, 255, 255, 255,
        155, 95, 30, 199, 255, 255, 255, 255, 157, 62, 242, 121, 255, 255, 255, 255, 158, 42, 238,
        249, 255, 255, 255, 255, 158, 247, 57, 105, 255, 255, 255, 255, 159, 132, 87, 249, 255,
        255, 255, 255, 160, 216, 108, 233, 255, 255, 255, 255, 161, 0, 57, 128, 255, 255, 255, 255,
        161, 60, 166, 64, 255, 255, 255, 255, 164, 16, 109, 192, 255, 255, 255, 255, 164, 61, 50,
        176, 255, 255, 255, 255, 165, 21, 104, 176, 255, 255, 255, 255, 165, 61, 3, 192, 255, 255,
        255, 255, 167, 30, 69, 80, 255, 255, 255, 255, 181, 164, 25, 96, 0, 0, 0, 0, 21, 39, 167,
        208, 0, 0, 0, 0, 22, 24, 220, 64, 0, 0, 0, 0, 23, 8, 219, 80, 0, 0, 0, 0, 23, 250, 15, 192,
        0, 0, 0, 0, 24, 234, 14, 208, 0, 0, 0, 0, 25, 219, 67, 64, 0, 0, 0, 0, 26, 204, 147, 208,
        0, 0, 0, 0, 27, 188, 160, 240, 0, 0, 0, 0, 28, 172, 145, 240, 0, 0, 0, 0, 29, 156, 130,
        240, 0, 0, 0, 0, 30, 140, 115, 240, 0, 0, 0, 0, 31, 124, 100, 240, 0, 0, 0, 0, 32, 108, 85,
        240, 0, 0, 0, 0, 33, 92, 70, 240, 0, 0, 0, 0, 34, 76, 55, 240, 0, 0, 0, 0, 35, 60, 40, 240,
        0, 0, 0, 0, 36, 44, 25, 240, 0, 0, 0, 0, 37, 28, 10, 240, 0, 0, 0, 0, 38, 11, 251, 240, 0,
        0, 0, 0, 39, 5, 39, 112, 0, 0, 0, 0, 39, 245, 24, 112, 0, 0, 0, 0, 40, 229, 23, 128, 0, 0,
        0, 0, 41, 120, 191, 128, 0, 0, 0, 0, 41, 212, 250, 112, 0, 0, 0, 0, 42, 196, 235, 112, 0,
        0, 0, 0, 43, 180, 220, 112, 0, 0, 0, 0, 44, 164, 205, 112, 0, 0, 0, 0, 45, 148, 190, 112,
        0, 0, 0, 0, 46, 132, 175, 112, 0, 0, 0, 0, 47, 116, 160, 112, 0, 0, 0, 0, 48, 100, 145,
        112, 0, 0, 0, 0, 49, 93, 188, 240, 0, 0, 0, 0, 50, 114, 151, 240, 0, 0, 0, 0, 51, 61, 158,
        240, 0, 0, 0, 0, 52, 82, 121, 240, 0, 0, 0, 0, 53, 29, 128, 240, 0, 0, 0, 0, 54, 50, 91,
        240, 0, 0, 0, 0, 54, 253, 98, 240, 0, 0, 0, 0, 56, 27, 120, 112, 0, 0, 0, 0, 56, 221, 68,
        240, 0, 0, 0, 0, 57, 251, 90, 112, 0, 0, 0, 0, 58, 189, 38, 240, 0, 0, 0, 0, 59, 219, 60,
        112, 0, 0, 0, 0, 60, 166, 67, 112, 0, 0, 0, 0, 61, 187, 30, 112, 0, 0, 0, 0, 62, 134, 37,
        112, 0, 0, 0, 0, 63, 155, 0, 112, 0, 0, 0, 0, 64, 102, 7, 112, 0, 0, 0, 0, 65, 132, 28,
        240, 0, 0, 0, 0, 66, 69, 233, 112, 0, 0, 0, 0, 67, 99, 254, 240, 0, 0, 0, 0, 68, 37, 203,
        112, 0, 0, 0, 0, 69, 67, 224, 240, 0, 0, 0, 0, 70, 5, 173, 112, 0, 0, 0, 0, 71, 35, 194,
        240, 0, 0, 0, 0, 71, 238, 201, 240, 0, 0, 0, 0, 73, 3, 164, 240, 0, 0, 0, 0, 73, 206, 171,
        240, 0, 0, 0, 0, 74, 227, 134, 240, 0, 0, 0, 0, 75, 174, 141, 240, 0, 0, 0, 0, 76, 204,
        163, 112, 0, 0, 0, 0, 77, 142, 111, 240, 0, 0, 0, 0, 84, 76, 29, 96, 1, 3, 2, 3, 4, 2, 4,
        5, 6, 5, 7, 5, 6, 8, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 9, 8,
        6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5,
        6, 5, 6, 5, 6, 5, 6, 5, 6, 10, 6, 0, 0, 35, 57, 0, 0, 0, 0, 35, 57, 0, 4, 0, 0, 49, 135, 1,
        8, 0, 0, 35, 119, 0, 4, 0, 0, 63, 151, 1, 12, 0, 0, 56, 64, 1, 17, 0, 0, 42, 48, 0, 21, 0,
        0, 70, 80, 1, 25, 0, 0, 28, 32, 0, 29, 0, 0, 42, 48, 1, 33, 0, 0, 56, 64, 0, 21, 76, 77,
        84, 0, 77, 77, 84, 0, 77, 83, 84, 0, 77, 68, 83, 84, 0, 77, 83, 68, 0, 77, 83, 75, 0, 43,
        48, 53, 0, 69, 69, 84, 0, 69, 69, 83, 84, 0, 10, 77, 83, 75, 45, 51, 10,
    ];
    pub(crate) const EuropeParis: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        101, 0, 0, 0, 7, 0, 0, 0, 31, 255, 255, 255, 255, 107, 201, 155, 207, 255, 255, 255, 255,
        145, 96, 80, 79, 255, 255, 255, 255, 155, 71, 120, 240, 255, 255, 255, 255, 155, 215, 44,
        112, 255, 255, 255, 255, 156, 188, 145, 112, 255, 255, 255, 255, 157, 192, 72, 240, 255,
        255, 255, 255, 158, 137, 254, 112, 255, 255, 255, 255, 159, 160, 42, 240, 255, 255, 255,
        255, 160, 96, 165, 240, 255, 255, 255, 255, 161, 128, 12, 240, 255, 255, 255, 255, 162, 46,
        18, 240, 255, 255, 255, 255, 163, 122, 76, 240, 255, 255, 255, 255, 164, 53, 129, 240, 255,
        255, 255, 255, 165, 94, 35, 112, 255, 255, 255, 255, 166, 37, 53, 240, 255, 255, 255, 255,
        167, 39, 155, 240, 255, 255, 255, 255, 168, 88, 38, 112, 255, 255, 255, 255, 169, 7, 125,
        240, 255, 255, 255, 255, 169, 238, 52, 112, 255, 255, 255, 255, 170, 231, 95, 240, 255,
        255, 255, 255, 171, 215, 80, 240, 255, 255, 255, 255, 172, 199, 65, 240, 255, 255, 255,
        255, 173, 201, 167, 240, 255, 255, 255, 255, 174, 167, 35, 240, 255, 255, 255, 255, 175,
        160, 79, 112, 255, 255, 255, 255, 176, 135, 5, 240, 255, 255, 255, 255, 177, 137, 107, 240,
        255, 255, 255, 255, 178, 112, 34, 112, 255, 255, 255, 255, 179, 114, 136, 112, 255, 255,
        255, 255, 180, 80, 4, 112, 255, 255, 255, 255, 181, 73, 47, 240, 255, 255, 255, 255, 182,
        47, 230, 112, 255, 255, 255, 255, 183, 50, 76, 112, 255, 255, 255, 255, 184, 15, 200, 112,
        255, 255, 255, 255, 184, 255, 185, 112, 255, 255, 255, 255, 185, 239, 170, 112, 255, 255,
        255, 255, 186, 214, 96, 240, 255, 255, 255, 255, 187, 216, 198, 240, 255, 255, 255, 255,
        188, 200, 183, 240, 255, 255, 255, 255, 189, 184, 168, 240, 255, 255, 255, 255, 190, 159,
        95, 112, 255, 255, 255, 255, 191, 152, 138, 240, 255, 255, 255, 255, 192, 154, 240, 240,
        255, 255, 255, 255, 193, 120, 108, 240, 255, 255, 255, 255, 194, 104, 93, 240, 255, 255,
        255, 255, 195, 88, 78, 240, 255, 255, 255, 255, 196, 63, 5, 112, 255, 255, 255, 255, 197,
        56, 48, 240, 255, 255, 255, 255, 198, 58, 150, 240, 255, 255, 255, 255, 199, 88, 172, 112,
        255, 255, 255, 255, 199, 218, 9, 160, 255, 255, 255, 255, 200, 108, 39, 224, 255, 255, 255,
        255, 204, 231, 75, 16, 255, 255, 255, 255, 205, 169, 23, 144, 255, 255, 255, 255, 206, 162,
        67, 16, 255, 255, 255, 255, 207, 146, 52, 16, 255, 255, 255, 255, 208, 79, 225, 224, 255,
        255, 255, 255, 208, 137, 241, 240, 255, 255, 255, 255, 209, 114, 22, 16, 255, 255, 255,
        255, 210, 78, 64, 144, 0, 0, 0, 0, 11, 187, 57, 0, 0, 0, 0, 0, 12, 171, 27, 240, 0, 0, 0,
        0, 13, 164, 99, 144, 0, 0, 0, 0, 14, 139, 26, 16, 0, 0, 0, 0, 15, 132, 69, 144, 0, 0, 0, 0,
        16, 116, 54, 144, 0, 0, 0, 0, 17, 100, 39, 144, 0, 0, 0, 0, 18, 84, 24, 144, 0, 0, 0, 0,
        19, 77, 68, 16, 0, 0, 0, 0, 20, 51, 250, 144, 0, 0, 0, 0, 21, 35, 235, 144, 0, 0, 0, 0, 22,
        19, 220, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23, 243, 190, 144, 0, 0, 0, 0, 24,
        227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0,
        27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0,
        30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0,
        33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44,
        54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144,
        0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144,
        0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144,
        0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188,
        144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 1, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 5, 4, 5, 4, 5, 6, 2, 6, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5,
        4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5, 4, 5,
        4, 5, 0, 0, 2, 49, 0, 0, 0, 0, 2, 49, 0, 4, 0, 0, 14, 16, 1, 8, 0, 0, 0, 0, 0, 13, 0, 0,
        14, 16, 0, 17, 0, 0, 28, 32, 1, 21, 0, 0, 28, 32, 1, 26, 76, 77, 84, 0, 80, 77, 84, 0, 87,
        69, 83, 84, 0, 87, 69, 84, 0, 67, 69, 84, 0, 67, 69, 83, 84, 0, 87, 69, 77, 84, 0, 10, 67,
        69, 84, 45, 49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48,
        47, 51, 10,
    ];
    pub(crate) const EuropeRiga: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        53, 0, 0, 0, 9, 0, 0, 0, 38, 255, 255, 255, 255, 86, 182, 205, 94, 255, 255, 255, 255, 158,
        185, 135, 254, 255, 255, 255, 255, 159, 132, 142, 254, 255, 255, 255, 255, 160, 136, 70,
        126, 255, 255, 255, 255, 160, 203, 130, 254, 255, 255, 255, 255, 173, 231, 241, 222, 255,
        255, 255, 255, 200, 175, 100, 96, 255, 255, 255, 255, 202, 98, 101, 80, 255, 255, 255, 255,
        204, 231, 75, 16, 255, 255, 255, 255, 205, 169, 23, 144, 255, 255, 255, 255, 206, 162, 67,
        16, 255, 255, 255, 255, 207, 146, 52, 16, 255, 255, 255, 255, 208, 130, 37, 16, 255, 255,
        255, 255, 208, 144, 137, 112, 0, 0, 0, 0, 21, 39, 167, 208, 0, 0, 0, 0, 22, 24, 220, 64, 0,
        0, 0, 0, 23, 8, 219, 80, 0, 0, 0, 0, 23, 250, 15, 192, 0, 0, 0, 0, 24, 234, 14, 208, 0, 0,
        0, 0, 25, 219, 67, 64, 0, 0, 0, 0, 26, 204, 147, 208, 0, 0, 0, 0, 27, 188, 160, 240, 0, 0,
        0, 0, 28, 172, 145, 240, 0, 0, 0, 0, 29, 156, 130, 240, 0, 0, 0, 0, 30, 140, 115, 240, 0,
        0, 0, 0, 31, 124, 100, 240, 0, 0, 0, 0, 32, 108, 85, 240, 0, 0, 0, 0, 33, 92, 70, 240, 0,
        0, 0, 0, 34, 76, 55, 240, 0, 0, 0, 0, 35, 60, 40, 240, 0, 0, 0, 0, 36, 44, 25, 240, 0, 0,
        0, 0, 37, 28, 25, 0, 0, 0, 0, 0, 38, 12, 10, 0, 0, 0, 0, 0, 39, 5, 53, 128, 0, 0, 0, 0, 39,
        245, 38, 128, 0, 0, 0, 0, 40, 229, 23, 128, 0, 0, 0, 0, 41, 213, 8, 128, 0, 0, 0, 0, 42,
        196, 249, 128, 0, 0, 0, 0, 43, 180, 234, 128, 0, 0, 0, 0, 44, 164, 219, 128, 0, 0, 0, 0,
        45, 148, 204, 128, 0, 0, 0, 0, 46, 132, 189, 128, 0, 0, 0, 0, 47, 116, 174, 128, 0, 0, 0,
        0, 48, 100, 159, 128, 0, 0, 0, 0, 49, 93, 203, 0, 0, 0, 0, 0, 50, 77, 188, 0, 0, 0, 0, 0,
        51, 61, 187, 16, 0, 0, 0, 0, 52, 82, 150, 16, 0, 0, 0, 0, 53, 29, 157, 16, 0, 0, 0, 0, 54,
        50, 120, 16, 0, 0, 0, 0, 54, 253, 127, 16, 0, 0, 0, 0, 56, 27, 148, 144, 0, 0, 0, 0, 58,
        189, 67, 16, 1, 2, 1, 2, 1, 3, 4, 6, 5, 6, 5, 6, 5, 4, 7, 4, 7, 4, 7, 4, 7, 4, 7, 4, 7, 4,
        7, 4, 7, 4, 8, 3, 8, 3, 8, 3, 8, 3, 8, 3, 8, 3, 8, 3, 8, 3, 8, 3, 8, 3, 8, 3, 8, 0, 0, 22,
        162, 0, 0, 0, 0, 22, 162, 0, 4, 0, 0, 36, 178, 1, 8, 0, 0, 28, 32, 0, 12, 0, 0, 42, 48, 0,
        16, 0, 0, 14, 16, 0, 20, 0, 0, 28, 32, 1, 24, 0, 0, 56, 64, 1, 29, 0, 0, 42, 48, 1, 33, 76,
        77, 84, 0, 82, 77, 84, 0, 76, 83, 84, 0, 69, 69, 84, 0, 77, 83, 75, 0, 67, 69, 84, 0, 67,
        69, 83, 84, 0, 77, 83, 68, 0, 69, 69, 83, 84, 0, 10, 69, 69, 84, 45, 50, 69, 69, 83, 84,
        44, 77, 51, 46, 53, 46, 48, 47, 51, 44, 77, 49, 48, 46, 53, 46, 48, 47, 52, 10,
    ];
    pub(crate) const EuropeRome: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        87, 0, 0, 0, 4, 0, 0, 0, 17, 255, 255, 255, 255, 62, 40, 232, 76, 255, 255, 255, 255, 112,
        188, 129, 112, 255, 255, 255, 255, 155, 56, 248, 112, 255, 255, 255, 255, 155, 213, 204,
        224, 255, 255, 255, 255, 156, 197, 203, 240, 255, 255, 255, 255, 157, 183, 0, 96, 255, 255,
        255, 255, 158, 137, 254, 112, 255, 255, 255, 255, 159, 160, 28, 224, 255, 255, 255, 255,
        160, 96, 165, 240, 255, 255, 255, 255, 161, 126, 173, 96, 255, 255, 255, 255, 162, 92, 55,
        112, 255, 255, 255, 255, 163, 76, 26, 96, 255, 255, 255, 255, 200, 108, 53, 240, 255, 255,
        255, 255, 204, 231, 75, 16, 255, 255, 255, 255, 205, 169, 23, 144, 255, 255, 255, 255, 206,
        162, 67, 16, 255, 255, 255, 255, 207, 146, 52, 16, 255, 255, 255, 255, 208, 110, 94, 144,
        255, 255, 255, 255, 209, 114, 22, 16, 255, 255, 255, 255, 210, 76, 210, 240, 255, 255, 255,
        255, 211, 62, 49, 144, 255, 255, 255, 255, 212, 73, 210, 16, 255, 255, 255, 255, 213, 29,
        247, 112, 255, 255, 255, 255, 214, 41, 151, 240, 255, 255, 255, 255, 214, 235, 128, 144,
        255, 255, 255, 255, 216, 9, 150, 16, 255, 255, 255, 255, 249, 51, 181, 240, 255, 255, 255,
        255, 249, 217, 196, 224, 255, 255, 255, 255, 251, 28, 210, 112, 255, 255, 255, 255, 251,
        185, 180, 240, 255, 255, 255, 255, 252, 252, 180, 112, 255, 255, 255, 255, 253, 153, 150,
        240, 255, 255, 255, 255, 254, 229, 208, 240, 255, 255, 255, 255, 255, 130, 179, 112, 0, 0,
        0, 0, 0, 197, 178, 240, 0, 0, 0, 0, 1, 98, 149, 112, 0, 0, 0, 0, 2, 156, 90, 112, 0, 0, 0,
        0, 3, 66, 119, 112, 0, 0, 0, 0, 4, 133, 118, 240, 0, 0, 0, 0, 5, 43, 147, 240, 0, 0, 0, 0,
        6, 110, 147, 112, 0, 0, 0, 0, 7, 11, 117, 240, 0, 0, 0, 0, 8, 69, 58, 240, 0, 0, 0, 0, 8,
        235, 87, 240, 0, 0, 0, 0, 10, 46, 87, 112, 0, 0, 0, 0, 10, 203, 57, 240, 0, 0, 0, 0, 12,
        14, 57, 112, 0, 0, 0, 0, 12, 171, 27, 240, 0, 0, 0, 0, 13, 228, 224, 240, 0, 0, 0, 0, 14,
        138, 253, 240, 0, 0, 0, 0, 15, 205, 253, 112, 0, 0, 0, 0, 16, 116, 26, 112, 0, 0, 0, 0, 17,
        173, 223, 112, 0, 0, 0, 0, 18, 83, 252, 112, 0, 0, 0, 0, 19, 77, 68, 16, 0, 0, 0, 0, 20,
        51, 250, 144, 0, 0, 0, 0, 21, 35, 235, 144, 0, 0, 0, 0, 22, 19, 220, 144, 0, 0, 0, 0, 23,
        3, 205, 144, 0, 0, 0, 0, 23, 243, 190, 144, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25,
        211, 160, 144, 0, 0, 0, 0, 26, 195, 145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28,
        172, 174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31,
        124, 129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76,
        84, 16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16,
        0, 0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0,
        0, 0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0,
        0, 43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0,
        0, 0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0,
        0, 0, 0, 49, 93, 217, 16, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 0, 0, 11, 180, 0, 0, 0, 0, 11, 180, 0, 4, 0, 0, 28, 32, 1, 8, 0, 0, 14, 16,
        0, 13, 76, 77, 84, 0, 82, 77, 84, 0, 67, 69, 83, 84, 0, 67, 69, 84, 0, 10, 67, 69, 84, 45,
        49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const EuropeSamara: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        64, 0, 0, 0, 6, 0, 0, 0, 16, 255, 255, 255, 255, 161, 0, 57, 128, 255, 255, 255, 255, 181,
        164, 11, 80, 0, 0, 0, 0, 21, 39, 153, 192, 0, 0, 0, 0, 22, 24, 206, 48, 0, 0, 0, 0, 23, 8,
        205, 64, 0, 0, 0, 0, 23, 250, 1, 176, 0, 0, 0, 0, 24, 234, 0, 192, 0, 0, 0, 0, 25, 219, 53,
        48, 0, 0, 0, 0, 26, 204, 133, 192, 0, 0, 0, 0, 27, 188, 146, 224, 0, 0, 0, 0, 28, 172, 131,
        224, 0, 0, 0, 0, 29, 156, 116, 224, 0, 0, 0, 0, 30, 140, 101, 224, 0, 0, 0, 0, 31, 124, 86,
        224, 0, 0, 0, 0, 32, 108, 71, 224, 0, 0, 0, 0, 33, 92, 56, 224, 0, 0, 0, 0, 34, 76, 41,
        224, 0, 0, 0, 0, 35, 60, 26, 224, 0, 0, 0, 0, 36, 44, 11, 224, 0, 0, 0, 0, 37, 28, 10, 240,
        0, 0, 0, 0, 38, 11, 251, 240, 0, 0, 0, 0, 39, 5, 39, 112, 0, 0, 0, 0, 39, 245, 24, 112, 0,
        0, 0, 0, 40, 229, 23, 128, 0, 0, 0, 0, 41, 0, 199, 0, 0, 0, 0, 0, 41, 212, 236, 96, 0, 0,
        0, 0, 42, 196, 221, 96, 0, 0, 0, 0, 43, 180, 206, 96, 0, 0, 0, 0, 44, 164, 191, 96, 0, 0,
        0, 0, 45, 148, 176, 96, 0, 0, 0, 0, 46, 132, 161, 96, 0, 0, 0, 0, 47, 116, 146, 96, 0, 0,
        0, 0, 48, 100, 131, 96, 0, 0, 0, 0, 49, 93, 174, 224, 0, 0, 0, 0, 50, 114, 137, 224, 0, 0,
        0, 0, 51, 61, 144, 224, 0, 0, 0, 0, 52, 82, 107, 224, 0, 0, 0, 0, 53, 29, 114, 224, 0, 0,
        0, 0, 54, 50, 77, 224, 0, 0, 0, 0, 54, 253, 84, 224, 0, 0, 0, 0, 56, 27, 106, 96, 0, 0, 0,
        0, 56, 221, 54, 224, 0, 0, 0, 0, 57, 251, 76, 96, 0, 0, 0, 0, 58, 189, 24, 224, 0, 0, 0, 0,
        59, 219, 46, 96, 0, 0, 0, 0, 60, 166, 53, 96, 0, 0, 0, 0, 61, 187, 16, 96, 0, 0, 0, 0, 62,
        134, 23, 96, 0, 0, 0, 0, 63, 154, 242, 96, 0, 0, 0, 0, 64, 101, 249, 96, 0, 0, 0, 0, 65,
        132, 14, 224, 0, 0, 0, 0, 66, 69, 219, 96, 0, 0, 0, 0, 67, 99, 240, 224, 0, 0, 0, 0, 68,
        37, 189, 96, 0, 0, 0, 0, 69, 67, 210, 224, 0, 0, 0, 0, 70, 5, 159, 96, 0, 0, 0, 0, 71, 35,
        180, 224, 0, 0, 0, 0, 71, 238, 187, 224, 0, 0, 0, 0, 73, 3, 150, 224, 0, 0, 0, 0, 73, 206,
        157, 224, 0, 0, 0, 0, 74, 227, 120, 224, 0, 0, 0, 0, 75, 174, 127, 224, 0, 0, 0, 0, 76,
        204, 163, 112, 0, 0, 0, 0, 77, 142, 111, 240, 1, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 4, 1, 4, 1, 5, 1, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 4, 1, 2, 0, 0, 46, 244, 0, 0, 0, 0, 42, 48,
        0, 4, 0, 0, 56, 64, 0, 8, 0, 0, 70, 80, 1, 12, 0, 0, 56, 64, 1, 8, 0, 0, 42, 48, 1, 4, 76,
        77, 84, 0, 43, 48, 51, 0, 43, 48, 52, 0, 43, 48, 53, 0, 10, 60, 43, 48, 52, 62, 45, 52, 10,
    ];
    pub(crate) const EuropeSaratov: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        64, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 161, 0, 57, 128, 255, 255, 255, 255, 181,
        164, 11, 80, 0, 0, 0, 0, 21, 39, 153, 192, 0, 0, 0, 0, 22, 24, 206, 48, 0, 0, 0, 0, 23, 8,
        205, 64, 0, 0, 0, 0, 23, 250, 1, 176, 0, 0, 0, 0, 24, 234, 0, 192, 0, 0, 0, 0, 25, 219, 53,
        48, 0, 0, 0, 0, 26, 204, 133, 192, 0, 0, 0, 0, 27, 188, 146, 224, 0, 0, 0, 0, 28, 172, 131,
        224, 0, 0, 0, 0, 29, 156, 116, 224, 0, 0, 0, 0, 30, 140, 101, 224, 0, 0, 0, 0, 31, 124, 86,
        224, 0, 0, 0, 0, 32, 108, 71, 224, 0, 0, 0, 0, 33, 92, 56, 224, 0, 0, 0, 0, 34, 76, 41,
        224, 0, 0, 0, 0, 35, 60, 40, 240, 0, 0, 0, 0, 36, 44, 25, 240, 0, 0, 0, 0, 37, 28, 10, 240,
        0, 0, 0, 0, 38, 11, 251, 240, 0, 0, 0, 0, 39, 5, 39, 112, 0, 0, 0, 0, 39, 245, 24, 112, 0,
        0, 0, 0, 41, 212, 236, 96, 0, 0, 0, 0, 42, 196, 235, 112, 0, 0, 0, 0, 43, 180, 220, 112, 0,
        0, 0, 0, 44, 164, 205, 112, 0, 0, 0, 0, 45, 148, 190, 112, 0, 0, 0, 0, 46, 132, 175, 112,
        0, 0, 0, 0, 47, 116, 160, 112, 0, 0, 0, 0, 48, 100, 145, 112, 0, 0, 0, 0, 49, 93, 188, 240,
        0, 0, 0, 0, 50, 114, 151, 240, 0, 0, 0, 0, 51, 61, 158, 240, 0, 0, 0, 0, 52, 82, 121, 240,
        0, 0, 0, 0, 53, 29, 128, 240, 0, 0, 0, 0, 54, 50, 91, 240, 0, 0, 0, 0, 54, 253, 98, 240, 0,
        0, 0, 0, 56, 27, 120, 112, 0, 0, 0, 0, 56, 221, 68, 240, 0, 0, 0, 0, 57, 251, 90, 112, 0,
        0, 0, 0, 58, 189, 38, 240, 0, 0, 0, 0, 59, 219, 60, 112, 0, 0, 0, 0, 60, 166, 67, 112, 0,
        0, 0, 0, 61, 187, 30, 112, 0, 0, 0, 0, 62, 134, 37, 112, 0, 0, 0, 0, 63, 155, 0, 112, 0, 0,
        0, 0, 64, 102, 7, 112, 0, 0, 0, 0, 65, 132, 28, 240, 0, 0, 0, 0, 66, 69, 233, 112, 0, 0, 0,
        0, 67, 99, 254, 240, 0, 0, 0, 0, 68, 37, 203, 112, 0, 0, 0, 0, 69, 67, 224, 240, 0, 0, 0,
        0, 70, 5, 173, 112, 0, 0, 0, 0, 71, 35, 194, 240, 0, 0, 0, 0, 71, 238, 201, 240, 0, 0, 0,
        0, 73, 3, 164, 240, 0, 0, 0, 0, 73, 206, 171, 240, 0, 0, 0, 0, 74, 227, 134, 240, 0, 0, 0,
        0, 75, 174, 141, 240, 0, 0, 0, 0, 76, 204, 163, 112, 0, 0, 0, 0, 77, 142, 111, 240, 0, 0,
        0, 0, 84, 76, 29, 96, 0, 0, 0, 0, 88, 67, 78, 112, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2,
        3, 2, 3, 4, 1, 4, 1, 4, 1, 3, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1,
        4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 3, 1, 3, 0, 0, 43, 50, 0, 0, 0, 0,
        42, 48, 0, 4, 0, 0, 70, 80, 1, 8, 0, 0, 56, 64, 0, 12, 0, 0, 56, 64, 1, 12, 76, 77, 84, 0,
        43, 48, 51, 0, 43, 48, 53, 0, 43, 48, 52, 0, 10, 60, 43, 48, 52, 62, 45, 52, 10,
    ];
    pub(crate) const EuropeSimferopol: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        75, 0, 0, 0, 9, 0, 0, 0, 34, 255, 255, 255, 255, 86, 182, 196, 8, 255, 255, 255, 255, 170,
        25, 164, 32, 255, 255, 255, 255, 181, 164, 25, 96, 255, 255, 255, 255, 203, 4, 141, 208,
        255, 255, 255, 255, 204, 231, 75, 16, 255, 255, 255, 255, 205, 169, 23, 144, 255, 255, 255,
        255, 206, 162, 67, 16, 255, 255, 255, 255, 207, 146, 52, 16, 255, 255, 255, 255, 207, 159,
        56, 224, 0, 0, 0, 0, 21, 39, 167, 208, 0, 0, 0, 0, 22, 24, 220, 64, 0, 0, 0, 0, 23, 8, 219,
        80, 0, 0, 0, 0, 23, 250, 15, 192, 0, 0, 0, 0, 24, 234, 14, 208, 0, 0, 0, 0, 25, 219, 67,
        64, 0, 0, 0, 0, 26, 204, 147, 208, 0, 0, 0, 0, 27, 188, 160, 240, 0, 0, 0, 0, 28, 172, 145,
        240, 0, 0, 0, 0, 29, 156, 130, 240, 0, 0, 0, 0, 30, 140, 115, 240, 0, 0, 0, 0, 31, 124,
        100, 240, 0, 0, 0, 0, 32, 108, 85, 240, 0, 0, 0, 0, 33, 92, 70, 240, 0, 0, 0, 0, 34, 76,
        55, 240, 0, 0, 0, 0, 35, 60, 40, 240, 0, 0, 0, 0, 36, 44, 25, 240, 0, 0, 0, 0, 37, 28, 10,
        240, 0, 0, 0, 0, 38, 141, 46, 240, 0, 0, 0, 0, 41, 212, 236, 96, 0, 0, 0, 0, 42, 196, 207,
        80, 0, 0, 0, 0, 43, 180, 206, 96, 0, 0, 0, 0, 44, 164, 177, 80, 0, 0, 0, 0, 45, 148, 176,
        96, 0, 0, 0, 0, 45, 194, 198, 208, 0, 0, 0, 0, 46, 132, 133, 64, 0, 0, 0, 0, 47, 116, 132,
        80, 0, 0, 0, 0, 48, 100, 103, 64, 0, 0, 0, 0, 49, 93, 160, 208, 0, 0, 0, 0, 50, 114, 166,
        0, 0, 0, 0, 0, 51, 61, 187, 16, 0, 0, 0, 0, 52, 82, 150, 16, 0, 0, 0, 0, 53, 29, 157, 16,
        0, 0, 0, 0, 54, 50, 120, 16, 0, 0, 0, 0, 54, 253, 127, 16, 0, 0, 0, 0, 56, 27, 148, 144, 0,
        0, 0, 0, 56, 221, 97, 16, 0, 0, 0, 0, 57, 251, 118, 144, 0, 0, 0, 0, 58, 189, 67, 16, 0, 0,
        0, 0, 59, 219, 88, 144, 0, 0, 0, 0, 60, 166, 95, 144, 0, 0, 0, 0, 61, 187, 58, 144, 0, 0,
        0, 0, 62, 134, 65, 144, 0, 0, 0, 0, 63, 155, 28, 144, 0, 0, 0, 0, 64, 102, 35, 144, 0, 0,
        0, 0, 65, 132, 57, 16, 0, 0, 0, 0, 66, 70, 5, 144, 0, 0, 0, 0, 67, 100, 27, 16, 0, 0, 0, 0,
        68, 37, 231, 144, 0, 0, 0, 0, 69, 67, 253, 16, 0, 0, 0, 0, 70, 5, 201, 144, 0, 0, 0, 0, 71,
        35, 223, 16, 0, 0, 0, 0, 71, 238, 230, 16, 0, 0, 0, 0, 73, 3, 193, 16, 0, 0, 0, 0, 73, 206,
        200, 16, 0, 0, 0, 0, 74, 227, 163, 16, 0, 0, 0, 0, 75, 174, 170, 16, 0, 0, 0, 0, 76, 204,
        191, 144, 0, 0, 0, 0, 77, 142, 140, 16, 0, 0, 0, 0, 78, 172, 161, 144, 0, 0, 0, 0, 79, 110,
        110, 16, 0, 0, 0, 0, 80, 140, 131, 144, 0, 0, 0, 0, 81, 87, 138, 144, 0, 0, 0, 0, 82, 108,
        101, 144, 0, 0, 0, 0, 83, 55, 94, 128, 0, 0, 0, 0, 84, 76, 29, 96, 1, 2, 3, 5, 4, 5, 4, 5,
        3, 6, 3, 6, 3, 6, 3, 6, 3, 6, 3, 6, 3, 6, 3, 6, 3, 6, 3, 2, 7, 2, 7, 2, 7, 6, 3, 6, 3, 6,
        3, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7, 2, 7,
        2, 7, 2, 7, 2, 8, 3, 0, 0, 31, 248, 0, 0, 0, 0, 31, 224, 0, 4, 0, 0, 28, 32, 0, 8, 0, 0,
        42, 48, 0, 12, 0, 0, 14, 16, 0, 16, 0, 0, 28, 32, 1, 20, 0, 0, 56, 64, 1, 25, 0, 0, 42, 48,
        1, 29, 0, 0, 56, 64, 0, 12, 76, 77, 84, 0, 83, 77, 84, 0, 69, 69, 84, 0, 77, 83, 75, 0, 67,
        69, 84, 0, 67, 69, 83, 84, 0, 77, 83, 68, 0, 69, 69, 83, 84, 0, 10, 77, 83, 75, 45, 51, 10,
    ];
    pub(crate) const EuropeSofia: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        45, 0, 0, 0, 6, 0, 0, 0, 26, 255, 255, 255, 255, 86, 182, 206, 36, 255, 255, 255, 255, 114,
        195, 227, 24, 255, 255, 255, 255, 204, 231, 75, 16, 255, 255, 255, 255, 205, 169, 23, 144,
        255, 255, 255, 255, 206, 162, 67, 16, 255, 255, 255, 255, 207, 146, 52, 16, 255, 255, 255,
        255, 208, 130, 37, 16, 255, 255, 255, 255, 209, 114, 36, 32, 0, 0, 0, 0, 17, 99, 239, 80,
        0, 0, 0, 0, 18, 85, 63, 224, 0, 0, 0, 0, 19, 77, 11, 208, 0, 0, 0, 0, 20, 53, 33, 224, 0,
        0, 0, 0, 21, 44, 237, 208, 0, 0, 0, 0, 22, 19, 192, 112, 0, 0, 0, 0, 23, 12, 207, 208, 0,
        0, 0, 0, 23, 243, 176, 128, 0, 0, 0, 0, 24, 227, 161, 128, 0, 0, 0, 0, 25, 211, 146, 128,
        0, 0, 0, 0, 26, 195, 131, 128, 0, 0, 0, 0, 27, 188, 175, 0, 0, 0, 0, 0, 28, 172, 160, 0, 0,
        0, 0, 0, 29, 156, 145, 0, 0, 0, 0, 0, 30, 140, 130, 0, 0, 0, 0, 0, 31, 124, 115, 0, 0, 0,
        0, 0, 32, 108, 100, 0, 0, 0, 0, 0, 33, 92, 85, 0, 0, 0, 0, 0, 34, 76, 70, 0, 0, 0, 0, 0,
        35, 60, 55, 0, 0, 0, 0, 0, 36, 44, 40, 0, 0, 0, 0, 0, 37, 28, 25, 0, 0, 0, 0, 0, 38, 12,
        10, 0, 0, 0, 0, 0, 39, 5, 53, 128, 0, 0, 0, 0, 39, 245, 10, 96, 0, 0, 0, 0, 40, 228, 237,
        80, 0, 0, 0, 0, 41, 212, 236, 96, 0, 0, 0, 0, 42, 196, 207, 80, 0, 0, 0, 0, 43, 180, 206,
        96, 0, 0, 0, 0, 44, 164, 177, 80, 0, 0, 0, 0, 45, 148, 176, 96, 0, 0, 0, 0, 46, 132, 147,
        80, 0, 0, 0, 0, 47, 116, 146, 96, 0, 0, 0, 0, 48, 100, 117, 80, 0, 0, 0, 0, 49, 93, 174,
        224, 0, 0, 0, 0, 50, 114, 123, 208, 0, 0, 0, 0, 51, 61, 187, 16, 1, 2, 3, 4, 3, 4, 3, 2, 5,
        2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5,
        2, 5, 2, 5, 2, 5, 0, 0, 21, 220, 0, 0, 0, 0, 27, 104, 0, 4, 0, 0, 28, 32, 0, 8, 0, 0, 14,
        16, 0, 12, 0, 0, 28, 32, 1, 16, 0, 0, 42, 48, 1, 21, 76, 77, 84, 0, 73, 77, 84, 0, 69, 69,
        84, 0, 67, 69, 84, 0, 67, 69, 83, 84, 0, 69, 69, 83, 84, 0, 10, 69, 69, 84, 45, 50, 69, 69,
        83, 84, 44, 77, 51, 46, 53, 46, 48, 47, 51, 44, 77, 49, 48, 46, 53, 46, 48, 47, 52, 10,
    ];
    pub(crate) const EuropeStockholm: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        37, 0, 0, 0, 4, 0, 0, 0, 17, 255, 255, 255, 255, 84, 213, 159, 148, 255, 255, 255, 255,
        124, 85, 115, 98, 255, 255, 255, 255, 155, 30, 140, 96, 255, 255, 255, 255, 155, 213, 218,
        240, 0, 0, 0, 0, 19, 77, 68, 16, 0, 0, 0, 0, 20, 51, 250, 144, 0, 0, 0, 0, 21, 35, 235,
        144, 0, 0, 0, 0, 22, 19, 220, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23, 243, 190,
        144, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0, 26, 195,
        145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29, 156,
        159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108,
        114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69,
        16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0,
        0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0,
        0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0,
        0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0,
        0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 1,
        2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        2, 3, 2, 3, 2, 3, 0, 0, 16, 236, 0, 0, 0, 0, 14, 30, 0, 4, 0, 0, 14, 16, 0, 8, 0, 0, 28,
        32, 1, 12, 76, 77, 84, 0, 83, 69, 84, 0, 67, 69, 84, 0, 67, 69, 83, 84, 0, 10, 67, 69, 84,
        45, 49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77, 49, 48, 46, 53, 46, 48, 47, 51,
        10,
    ];
    pub(crate) const EuropeTallinn: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        52, 0, 0, 0, 8, 0, 0, 0, 34, 255, 255, 255, 255, 86, 182, 204, 204, 255, 255, 255, 255,
        158, 89, 45, 204, 255, 255, 255, 255, 158, 185, 144, 144, 255, 255, 255, 255, 159, 132,
        151, 144, 255, 255, 255, 255, 161, 0, 43, 112, 255, 255, 255, 255, 164, 115, 111, 76, 255,
        255, 255, 255, 200, 176, 181, 224, 255, 255, 255, 255, 202, 198, 151, 80, 255, 255, 255,
        255, 204, 231, 75, 16, 255, 255, 255, 255, 205, 169, 23, 144, 255, 255, 255, 255, 206, 162,
        67, 16, 255, 255, 255, 255, 207, 146, 52, 16, 255, 255, 255, 255, 208, 116, 203, 224, 0, 0,
        0, 0, 21, 39, 167, 208, 0, 0, 0, 0, 22, 24, 220, 64, 0, 0, 0, 0, 23, 8, 219, 80, 0, 0, 0,
        0, 23, 250, 15, 192, 0, 0, 0, 0, 24, 234, 14, 208, 0, 0, 0, 0, 25, 219, 67, 64, 0, 0, 0, 0,
        26, 204, 147, 208, 0, 0, 0, 0, 27, 188, 160, 240, 0, 0, 0, 0, 28, 172, 145, 240, 0, 0, 0,
        0, 29, 156, 130, 240, 0, 0, 0, 0, 30, 140, 115, 240, 0, 0, 0, 0, 31, 124, 100, 240, 0, 0,
        0, 0, 32, 108, 85, 240, 0, 0, 0, 0, 33, 92, 70, 240, 0, 0, 0, 0, 34, 76, 55, 240, 0, 0, 0,
        0, 35, 60, 40, 240, 0, 0, 0, 0, 36, 44, 25, 240, 0, 0, 0, 0, 37, 28, 25, 0, 0, 0, 0, 0, 38,
        12, 10, 0, 0, 0, 0, 0, 39, 5, 53, 128, 0, 0, 0, 0, 39, 245, 38, 128, 0, 0, 0, 0, 40, 229,
        23, 128, 0, 0, 0, 0, 41, 213, 8, 128, 0, 0, 0, 0, 42, 196, 249, 128, 0, 0, 0, 0, 43, 180,
        234, 128, 0, 0, 0, 0, 44, 164, 219, 128, 0, 0, 0, 0, 45, 148, 204, 128, 0, 0, 0, 0, 46,
        132, 189, 128, 0, 0, 0, 0, 47, 116, 174, 128, 0, 0, 0, 0, 48, 100, 159, 128, 0, 0, 0, 0,
        49, 93, 203, 0, 0, 0, 0, 0, 50, 114, 166, 0, 0, 0, 0, 0, 51, 61, 173, 0, 0, 0, 0, 0, 52,
        82, 136, 0, 0, 0, 0, 0, 53, 29, 143, 0, 0, 0, 0, 0, 54, 50, 120, 16, 0, 0, 0, 0, 54, 253,
        127, 16, 0, 0, 0, 0, 56, 27, 148, 144, 0, 0, 0, 0, 60, 166, 95, 144, 1, 3, 2, 3, 1, 4, 5,
        2, 3, 2, 3, 2, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 5, 7, 4, 7, 4, 7, 4, 7, 4,
        7, 4, 7, 4, 7, 4, 7, 4, 7, 4, 7, 4, 7, 4, 7, 0, 0, 23, 52, 0, 0, 0, 0, 23, 52, 0, 4, 0, 0,
        28, 32, 1, 8, 0, 0, 14, 16, 0, 13, 0, 0, 28, 32, 0, 17, 0, 0, 42, 48, 0, 21, 0, 0, 56, 64,
        1, 25, 0, 0, 42, 48, 1, 29, 76, 77, 84, 0, 84, 77, 84, 0, 67, 69, 83, 84, 0, 67, 69, 84, 0,
        69, 69, 84, 0, 77, 83, 75, 0, 77, 83, 68, 0, 69, 69, 83, 84, 0, 10, 69, 69, 84, 45, 50, 69,
        69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 47, 51, 44, 77, 49, 48, 46, 53, 46, 48, 47, 52, 10,
    ];
    pub(crate) const EuropeTirane: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        50, 0, 0, 0, 3, 0, 0, 0, 13, 255, 255, 255, 255, 150, 170, 52, 104, 255, 255, 255, 255,
        200, 109, 135, 112, 255, 255, 255, 255, 204, 231, 75, 16, 255, 255, 255, 255, 205, 169, 23,
        144, 255, 255, 255, 255, 205, 184, 233, 144, 0, 0, 0, 0, 8, 40, 57, 240, 0, 0, 0, 0, 8,
        239, 62, 96, 0, 0, 0, 0, 10, 5, 120, 240, 0, 0, 0, 0, 10, 208, 113, 224, 0, 0, 0, 0, 11,
        233, 79, 112, 0, 0, 0, 0, 12, 180, 72, 96, 0, 0, 0, 0, 13, 210, 107, 240, 0, 0, 0, 0, 14,
        148, 42, 96, 0, 0, 0, 0, 15, 176, 252, 112, 0, 0, 0, 0, 16, 116, 12, 96, 0, 0, 0, 0, 17,
        144, 222, 112, 0, 0, 0, 0, 18, 83, 238, 96, 0, 0, 0, 0, 19, 112, 192, 112, 0, 0, 0, 0, 20,
        59, 185, 96, 0, 0, 0, 0, 21, 72, 185, 112, 0, 0, 0, 0, 22, 19, 178, 96, 0, 0, 0, 0, 23, 49,
        213, 240, 0, 0, 0, 0, 23, 252, 206, 224, 0, 0, 0, 0, 25, 0, 148, 112, 0, 0, 0, 0, 25, 219,
        95, 96, 0, 0, 0, 0, 26, 204, 175, 240, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172,
        174, 16, 0, 0, 0, 0, 29, 156, 159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124,
        129, 16, 0, 0, 0, 0, 32, 108, 114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84,
        16, 0, 0, 0, 0, 35, 60, 69, 16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0,
        0, 0, 0, 38, 12, 24, 16, 0, 0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0,
        0, 40, 229, 37, 144, 0, 0, 0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0,
        43, 180, 248, 144, 0, 0, 0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0,
        0, 46, 132, 203, 144, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0,
        0, 0, 49, 93, 217, 16, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1,
        2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 0, 0, 18,
        152, 0, 0, 0, 0, 14, 16, 0, 4, 0, 0, 28, 32, 1, 8, 76, 77, 84, 0, 67, 69, 84, 0, 67, 69,
        83, 84, 0, 10, 67, 69, 84, 45, 49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77, 49,
        48, 46, 53, 46, 48, 47, 51, 10,
    ];
    pub(crate) const EuropeUlyanovsk: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        66, 0, 0, 0, 7, 0, 0, 0, 20, 255, 255, 255, 255, 161, 0, 57, 128, 255, 255, 255, 255, 181,
        164, 11, 80, 0, 0, 0, 0, 21, 39, 153, 192, 0, 0, 0, 0, 22, 24, 206, 48, 0, 0, 0, 0, 23, 8,
        205, 64, 0, 0, 0, 0, 23, 250, 1, 176, 0, 0, 0, 0, 24, 234, 0, 192, 0, 0, 0, 0, 25, 219, 53,
        48, 0, 0, 0, 0, 26, 204, 133, 192, 0, 0, 0, 0, 27, 188, 146, 224, 0, 0, 0, 0, 28, 172, 131,
        224, 0, 0, 0, 0, 29, 156, 116, 224, 0, 0, 0, 0, 30, 140, 101, 224, 0, 0, 0, 0, 31, 124, 86,
        224, 0, 0, 0, 0, 32, 108, 71, 224, 0, 0, 0, 0, 33, 92, 56, 224, 0, 0, 0, 0, 34, 76, 41,
        224, 0, 0, 0, 0, 35, 60, 26, 224, 0, 0, 0, 0, 36, 44, 11, 224, 0, 0, 0, 0, 37, 28, 10, 240,
        0, 0, 0, 0, 38, 11, 251, 240, 0, 0, 0, 0, 39, 5, 39, 112, 0, 0, 0, 0, 39, 245, 24, 112, 0,
        0, 0, 0, 40, 229, 23, 128, 0, 0, 0, 0, 41, 120, 191, 128, 0, 0, 0, 0, 41, 212, 250, 112, 0,
        0, 0, 0, 42, 196, 235, 112, 0, 0, 0, 0, 43, 180, 220, 112, 0, 0, 0, 0, 44, 164, 205, 112,
        0, 0, 0, 0, 45, 148, 190, 112, 0, 0, 0, 0, 46, 132, 175, 112, 0, 0, 0, 0, 47, 116, 160,
        112, 0, 0, 0, 0, 48, 100, 145, 112, 0, 0, 0, 0, 49, 93, 188, 240, 0, 0, 0, 0, 50, 114, 151,
        240, 0, 0, 0, 0, 51, 61, 158, 240, 0, 0, 0, 0, 52, 82, 121, 240, 0, 0, 0, 0, 53, 29, 128,
        240, 0, 0, 0, 0, 54, 50, 91, 240, 0, 0, 0, 0, 54, 253, 98, 240, 0, 0, 0, 0, 56, 27, 120,
        112, 0, 0, 0, 0, 56, 221, 68, 240, 0, 0, 0, 0, 57, 251, 90, 112, 0, 0, 0, 0, 58, 189, 38,
        240, 0, 0, 0, 0, 59, 219, 60, 112, 0, 0, 0, 0, 60, 166, 67, 112, 0, 0, 0, 0, 61, 187, 30,
        112, 0, 0, 0, 0, 62, 134, 37, 112, 0, 0, 0, 0, 63, 155, 0, 112, 0, 0, 0, 0, 64, 102, 7,
        112, 0, 0, 0, 0, 65, 132, 28, 240, 0, 0, 0, 0, 66, 69, 233, 112, 0, 0, 0, 0, 67, 99, 254,
        240, 0, 0, 0, 0, 68, 37, 203, 112, 0, 0, 0, 0, 69, 67, 224, 240, 0, 0, 0, 0, 70, 5, 173,
        112, 0, 0, 0, 0, 71, 35, 194, 240, 0, 0, 0, 0, 71, 238, 201, 240, 0, 0, 0, 0, 73, 3, 164,
        240, 0, 0, 0, 0, 73, 206, 171, 240, 0, 0, 0, 0, 74, 227, 134, 240, 0, 0, 0, 0, 75, 174,
        141, 240, 0, 0, 0, 0, 76, 204, 163, 112, 0, 0, 0, 0, 77, 142, 111, 240, 0, 0, 0, 0, 84, 76,
        29, 96, 0, 0, 0, 0, 86, 247, 20, 112, 1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
        4, 1, 4, 1, 5, 6, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4,
        1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 3, 1, 3, 0, 0, 45, 96, 0, 0, 0, 0, 42, 48, 0,
        4, 0, 0, 70, 80, 1, 8, 0, 0, 56, 64, 0, 12, 0, 0, 56, 64, 1, 12, 0, 0, 42, 48, 1, 4, 0, 0,
        28, 32, 0, 16, 76, 77, 84, 0, 43, 48, 51, 0, 43, 48, 53, 0, 43, 48, 52, 0, 43, 48, 50, 0,
        10, 60, 43, 48, 52, 62, 45, 52, 10,
    ];
    pub(crate) const EuropeUzhgorod: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        37, 0, 0, 0, 7, 0, 0, 0, 30, 255, 255, 255, 255, 106, 238, 176, 24, 255, 255, 255, 255,
        200, 9, 113, 144, 255, 255, 255, 255, 204, 231, 75, 16, 255, 255, 255, 255, 205, 169, 23,
        144, 255, 255, 255, 255, 206, 162, 67, 16, 255, 255, 255, 255, 207, 146, 52, 16, 255, 255,
        255, 255, 208, 161, 158, 224, 255, 255, 255, 255, 209, 229, 253, 240, 0, 0, 0, 0, 21, 39,
        167, 208, 0, 0, 0, 0, 22, 24, 220, 64, 0, 0, 0, 0, 23, 8, 219, 80, 0, 0, 0, 0, 23, 250, 15,
        192, 0, 0, 0, 0, 24, 234, 14, 208, 0, 0, 0, 0, 25, 219, 67, 64, 0, 0, 0, 0, 26, 204, 147,
        208, 0, 0, 0, 0, 27, 188, 160, 240, 0, 0, 0, 0, 28, 172, 145, 240, 0, 0, 0, 0, 29, 156,
        130, 240, 0, 0, 0, 0, 30, 140, 115, 240, 0, 0, 0, 0, 31, 124, 100, 240, 0, 0, 0, 0, 32,
        108, 85, 240, 0, 0, 0, 0, 33, 92, 70, 240, 0, 0, 0, 0, 34, 76, 55, 240, 0, 0, 0, 0, 35, 60,
        40, 240, 0, 0, 0, 0, 36, 44, 25, 240, 0, 0, 0, 0, 37, 28, 10, 240, 0, 0, 0, 0, 38, 141, 46,
        240, 0, 0, 0, 0, 39, 245, 66, 160, 0, 0, 0, 0, 41, 212, 236, 96, 0, 0, 0, 0, 42, 196, 207,
        80, 0, 0, 0, 0, 43, 180, 206, 96, 0, 0, 0, 0, 44, 164, 177, 80, 0, 0, 0, 0, 45, 148, 176,
        96, 0, 0, 0, 0, 46, 132, 147, 80, 0, 0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173,
        144, 0, 0, 0, 0, 49, 93, 217, 16, 1, 2, 1, 2, 1, 2, 1, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3, 4, 3,
        4, 3, 4, 3, 4, 3, 4, 1, 5, 6, 5, 6, 5, 6, 5, 6, 5, 6, 0, 0, 20, 232, 0, 0, 0, 0, 14, 16, 0,
        4, 0, 0, 28, 32, 1, 8, 0, 0, 56, 64, 1, 13, 0, 0, 42, 48, 0, 17, 0, 0, 28, 32, 0, 21, 0, 0,
        42, 48, 1, 25, 76, 77, 84, 0, 67, 69, 84, 0, 67, 69, 83, 84, 0, 77, 83, 68, 0, 77, 83, 75,
        0, 69, 69, 84, 0, 69, 69, 83, 84, 0, 10, 69, 69, 84, 45, 50, 69, 69, 83, 84, 44, 77, 51,
        46, 53, 46, 48, 47, 51, 44, 77, 49, 48, 46, 53, 46, 48, 47, 52, 10,
    ];
    pub(crate) const EuropeVienna: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        56, 0, 0, 0, 3, 0, 0, 0, 13, 255, 255, 255, 255, 111, 162, 95, 47, 255, 255, 255, 255, 155,
        12, 23, 96, 255, 255, 255, 255, 155, 213, 218, 240, 255, 255, 255, 255, 156, 217, 174, 144,
        255, 255, 255, 255, 157, 164, 181, 144, 255, 255, 255, 255, 158, 185, 144, 144, 255, 255,
        255, 255, 159, 132, 151, 144, 255, 255, 255, 255, 162, 112, 26, 16, 255, 255, 255, 255,
        163, 68, 91, 144, 255, 255, 255, 255, 200, 9, 113, 144, 255, 255, 255, 255, 204, 231, 75,
        16, 255, 255, 255, 255, 205, 169, 23, 144, 255, 255, 255, 255, 206, 162, 67, 16, 255, 255,
        255, 255, 207, 146, 52, 16, 255, 255, 255, 255, 208, 130, 37, 16, 255, 255, 255, 255, 209,
        114, 22, 16, 255, 255, 255, 255, 209, 127, 69, 16, 255, 255, 255, 255, 211, 99, 27, 144,
        255, 255, 255, 255, 212, 75, 35, 144, 255, 255, 255, 255, 213, 57, 195, 16, 255, 255, 255,
        255, 214, 41, 180, 16, 255, 255, 255, 255, 215, 44, 26, 16, 255, 255, 255, 255, 216, 9,
        150, 16, 0, 0, 0, 0, 19, 77, 39, 240, 0, 0, 0, 0, 20, 51, 208, 96, 0, 0, 0, 0, 21, 35, 235,
        144, 0, 0, 0, 0, 22, 19, 220, 144, 0, 0, 0, 0, 23, 3, 205, 144, 0, 0, 0, 0, 23, 243, 190,
        144, 0, 0, 0, 0, 24, 227, 175, 144, 0, 0, 0, 0, 25, 211, 160, 144, 0, 0, 0, 0, 26, 195,
        145, 144, 0, 0, 0, 0, 27, 188, 189, 16, 0, 0, 0, 0, 28, 172, 174, 16, 0, 0, 0, 0, 29, 156,
        159, 16, 0, 0, 0, 0, 30, 140, 144, 16, 0, 0, 0, 0, 31, 124, 129, 16, 0, 0, 0, 0, 32, 108,
        114, 16, 0, 0, 0, 0, 33, 92, 99, 16, 0, 0, 0, 0, 34, 76, 84, 16, 0, 0, 0, 0, 35, 60, 69,
        16, 0, 0, 0, 0, 36, 44, 54, 16, 0, 0, 0, 0, 37, 28, 39, 16, 0, 0, 0, 0, 38, 12, 24, 16, 0,
        0, 0, 0, 39, 5, 67, 144, 0, 0, 0, 0, 39, 245, 52, 144, 0, 0, 0, 0, 40, 229, 37, 144, 0, 0,
        0, 0, 41, 213, 22, 144, 0, 0, 0, 0, 42, 197, 7, 144, 0, 0, 0, 0, 43, 180, 248, 144, 0, 0,
        0, 0, 44, 164, 233, 144, 0, 0, 0, 0, 45, 148, 218, 144, 0, 0, 0, 0, 46, 132, 203, 144, 0,
        0, 0, 0, 47, 116, 188, 144, 0, 0, 0, 0, 48, 100, 173, 144, 0, 0, 0, 0, 49, 93, 217, 16, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2,
        1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 0, 0, 15, 81, 0,
        0, 0, 0, 28, 32, 1, 4, 0, 0, 14, 16, 0, 9, 76, 77, 84, 0, 67, 69, 83, 84, 0, 67, 69, 84, 0,
        10, 67, 69, 84, 45, 49, 67, 69, 83, 84, 44, 77, 51, 46, 53, 46, 48, 44, 77, 49, 48, 46, 53,
        46, 48, 47, 51, 10,
    ];
    pub(crate) const EuropeVilnius: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        51, 0, 0, 0, 9, 0, 0, 0, 38, 255, 255, 255, 255, 86, 182, 204, 68, 255, 255, 255, 255, 156,
        79, 31, 80, 255, 255, 255, 255, 161, 133, 74, 152, 255, 255, 255, 255, 162, 241, 48, 240,
        255, 255, 255, 255, 163, 102, 120, 96, 255, 255, 255, 255, 200, 172, 207, 112, 255, 255,
        255, 255, 202, 89, 42, 208, 255, 255, 255, 255, 204, 231, 75, 16, 255, 255, 255, 255, 205,
        169, 23, 144, 255, 255, 255, 255, 206, 162, 67, 16, 255, 255, 255, 255, 207, 146, 52, 16,
        255, 255, 255, 255, 208, 48, 61, 224, 0, 0, 0, 0, 21, 39, 167, 208, 0, 0, 0, 0, 22, 24,
        220, 64, 0, 0, 0, 0, 23, 8, 219, 80, 0, 0, 0, 0, 23, 250, 15, 192, 0, 0, 0, 0, 24, 234, 14,
        208, 0, 0, 0, 0, 25, 219, 67, 64, 0, 0, 0, 0, 26, 204, 147, 208, 0, 0, 0, 0, 27, 188, 160,
        240, 0, 0, 0, 0, 28, 172, 145, 240, 0, 0, 0, 0, 29, 156, 130, 240, 0, 0, 0, 0, 30, 140,
        115, 240, 0, 0, 0, 0, 31, 124, 100, 240, 0, 0, 0, 0, 32, 108, 85, 240, 0, 0, 0, 0, 33, 92,
        70, 240, 0, 0, 0, 0, 34, 76, 55, 240, 0, 0, 0, 0, 35, 60, 40, 240, 0, 0, 0, 0, 36, 44, 25,
        240, 0, 0, 0, 0, 37, 28, 25, 0, 0, 0, 0, 0, 38, 12, 10, 0, 0, 0, 0, 0, 39, 5, 53, 128, 0,
        0, 0, 0, 39, 245, 38, 128, 0, 0, 0, 0, 40, 229, 23, 128, 0, 0, 0, 0, 41, 213, 8, 128, 0, 0,
        0, 0, 42, 196, 249, 128, 0, 0, 0, 0, 43, 180, 234, 128, 0, 0, 0, 0, 44, 164, 219, 128, 0,
        0, 0, 0, 45, 148, 204, 128, 0, 0, 0, 0, 46, 132, 189, 128, 0, 0, 0, 0, 47, 116, 174, 128,
        0, 0, 0, 0, 48, 100, 159, 128, 0, 0, 0, 0, 49, 93, 203, 0, 0, 0, 0, 0, 50, 114, 166, 0, 0,
        0, 0, 0, 51, 61, 173, 0, 0, 0, 0, 0, 52, 82, 136, 0, 0, 0, 0, 0, 53, 29, 157, 16, 0, 0, 0,
        0, 54, 50, 120, 16, 0, 0, 0, 0, 54, 253, 127, 16, 0, 0, 0, 0, 56, 27, 148, 144, 0, 0, 0, 0,
        62, 134, 65, 144, 1, 2, 3, 4, 3, 5, 6, 3, 6, 3, 6, 5, 7, 5, 7, 5, 7, 5, 7, 5, 7, 5, 7, 5,
        7, 5, 7, 5, 8, 4, 8, 4, 8, 4, 8, 4, 8, 4, 8, 4, 8, 4, 8, 4, 8, 4, 6, 3, 6, 4, 8, 0, 0, 23,
        188, 0, 0, 0, 0, 19, 176, 0, 4, 0, 0, 22, 104, 0, 8, 0, 0, 14, 16, 0, 12, 0, 0, 28, 32, 0,
        16, 0, 0, 42, 48, 0, 20, 0, 0, 28, 32, 1, 24, 0, 0, 56, 64, 1, 29, 0, 0, 42, 48, 1, 33, 76,
        77, 84, 0, 87, 77, 84, 0, 75, 77, 84, 0, 67, 69, 84, 0, 69, 69, 84, 0, 77, 83, 75, 0, 67,
        69, 83, 84, 0, 77, 83, 68, 0, 69, 69, 83, 84, 0, 10, 69, 69, 84, 45, 50, 69, 69, 83, 84,
        44, 77, 51, 46, 53, 46, 48, 47, 51, 44, 77, 49, 48, 46, 53, 46, 48, 47, 52, 10,
    ];
    pub(crate) const EuropeVolgograd: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        65, 0, 0, 0, 5, 0, 0, 0, 16, 255, 255, 255, 255, 161, 245, 70, 220, 255, 255, 255, 255,
        181, 164, 11, 80, 0, 0, 0, 0, 21, 39, 153, 192, 0, 0, 0, 0, 22, 24, 206, 48, 0, 0, 0, 0,
        23, 8, 205, 64, 0, 0, 0, 0, 23, 250, 1, 176, 0, 0, 0, 0, 24, 234, 0, 192, 0, 0, 0, 0, 25,
        219, 53, 48, 0, 0, 0, 0, 26, 204, 133, 192, 0, 0, 0, 0, 27, 188, 146, 224, 0, 0, 0, 0, 28,
        172, 131, 224, 0, 0, 0, 0, 29, 156, 116, 224, 0, 0, 0, 0, 30, 140, 101, 224, 0, 0, 0, 0,
        31, 124, 86, 224, 0, 0, 0, 0, 32, 108, 71, 224, 0, 0, 0, 0, 33, 92, 56, 224, 0, 0, 0, 0,
        34, 76, 41, 224, 0, 0, 0, 0, 35, 60, 40, 240, 0, 0, 0, 0, 36, 44, 25, 240, 0, 0, 0, 0, 37,
        28, 10, 240, 0, 0, 0, 0, 38, 11, 251, 240, 0, 0, 0, 0, 39, 5, 39, 112, 0, 0, 0, 0, 39, 245,
        24, 112, 0, 0, 0, 0, 41, 212, 236, 96, 0, 0, 0, 0, 42, 196, 235, 112, 0, 0, 0, 0, 43, 180,
        220, 112, 0, 0, 0, 0, 44, 164, 205, 112, 0, 0, 0, 0, 45, 148, 190, 112, 0, 0, 0, 0, 46,
        132, 175, 112, 0, 0, 0, 0, 47, 116, 160, 112, 0, 0, 0, 0, 48, 100, 145, 112, 0, 0, 0, 0,
        49, 93, 188, 240, 0, 0, 0, 0, 50, 114, 151, 240, 0, 0, 0, 0, 51, 61, 158, 240, 0, 0, 0, 0,
        52, 82, 121, 240, 0, 0, 0, 0, 53, 29, 128, 240, 0, 0, 0, 0, 54, 50, 91, 240, 0, 0, 0, 0,
        54, 253, 98, 240, 0, 0, 0, 0, 56, 27, 120, 112, 0, 0, 0, 0, 56, 221, 68, 240, 0, 0, 0, 0,
        57, 251, 90, 112, 0, 0, 0, 0, 58, 189, 38, 240, 0, 0, 0, 0, 59, 219, 60, 112, 0, 0, 0, 0,
        60, 166, 67, 112, 0, 0, 0, 0, 61, 187, 30, 112, 0, 0, 0, 0, 62, 134, 37, 112, 0, 0, 0, 0,
        63, 155, 0, 112, 0, 0, 0, 0, 64, 102, 7, 112, 0, 0, 0, 0, 65, 132, 28, 240, 0, 0, 0, 0, 66,
        69, 233, 112, 0, 0, 0, 0, 67, 99, 254, 240, 0, 0, 0, 0, 68, 37, 203, 112, 0, 0, 0, 0, 69,
        67, 224, 240, 0, 0, 0, 0, 70, 5, 173, 112, 0, 0, 0, 0, 71, 35, 194, 240, 0, 0, 0, 0, 71,
        238, 201, 240, 0, 0, 0, 0, 73, 3, 164, 240, 0, 0, 0, 0, 73, 206, 171, 240, 0, 0, 0, 0, 74,
        227, 134, 240, 0, 0, 0, 0, 75, 174, 141, 240, 0, 0, 0, 0, 76, 204, 163, 112, 0, 0, 0, 0,
        77, 142, 111, 240, 0, 0, 0, 0, 84, 76, 29, 96, 0, 0, 0, 0, 91, 212, 237, 240, 0, 0, 0, 0,
        95, 231, 178, 96, 1, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 4, 1, 4, 1, 4, 1, 2, 4,
        1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4,
        1, 4, 1, 4, 1, 4, 1, 2, 1, 2, 1, 0, 0, 41, 164, 0, 0, 0, 0, 42, 48, 0, 4, 0, 0, 56, 64, 0,
        8, 0, 0, 70, 80, 1, 12, 0, 0, 56, 64, 1, 8, 76, 77, 84, 0, 43, 48, 51, 0, 43, 48, 52, 0,
        43, 48, 53, 0, 10, 60, 43, 48, 51, 62, 45, 51, 10,
    ];
    pub(crate) const EuropeWarsaw: &[u8] = &[
        84, 90, 105, 102, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 90, 105, 102, 50,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        82, 0, 0, 0, 6, 0, 0, 0, 26, 255, 255, 255, 255, 86, 182, 208, 80, 255, 255, 255, 255, 153,
        168, 42, 208, 255, 255, 255, 255, 155, 12, 23, 96, 255, 255, 255, 255, 155, 213, 218, 240,
        255, 255, 255, 255, 156, 217, 174, 144, 255, 255, 255, 255, 157, 164, 181, 144, 255, 255,
        255, 255, 158, 185, 144, 144, 255, 255, 255, 255, 159, 132, 151, 144, 255, 255, 255, 255,
        160, 154, 182, 0, 255, 255, 255, 255, 161, 101, 189, 0, 255, 255, 255, 255, 166, 125, 124,
        96, 255, 255, 255, 255, 200, 118, 222, 16, 255, 255, 255, 255, 204, 231, 75, 16, 255, 255,
        255, 255, 205, 169, 23, 144, 255, 255, 255, 255, 206, 162, 67, 16, 255, 255, 255, 255, 207,
        146, 52, 16, 255, 255, 255, 255, 208, 132, 186, 0, 255, 255, 255, 255, 209, 149, 146, 112,
        255, 255, 255, 255, 210, 138, 187, 96, 255, 255, 255, 255, 211, 98, 255, 112, 255, 255,
        255, 255, 212, 75, 35, 144, 255, 255, 255, 255, 213, 94, 173, 16, 255, 255, 255, 255, 214,
        41, 180, 16, 255, 255, 255, 