// This file is code-genned by typos-vars-codegen
#![allow(clippy::unreadable_literal, clippy::type_complexity)]

pub type Variants = &'static [&'static str];
pub type VariantsMap = [Variants; 4];

pub fn all_categories() -> crate::CategorySet {
    crate::Category::American
        | crate::Category::BritishIse
        | crate::Category::Canadian
        | crate::Category::Australian
}

pub fn corrections(category: crate::Category, options: VariantsMap) -> &'static [&'static str] {
    match category {
        crate::Category::American => options[0],
        crate::Category::BritishIse => options[1],
        crate::Category::Canadian => options[2],
        crate::Category::Australian => options[3],
        crate::Category::BritishIze | crate::Category::Other => {
            unreachable!("{:?} is unused", category)
        }
    }
}

pub static VARS_TRIE: dictgen::DictTrie<&[(u8, &VariantsMap)]> = dictgen::DictTrie {
    root: &VARS_NODE,
    unicode: &VARS_UNICODE_TABLE,
    range: 2..=24,
};

pub static VARS_UNICODE_TABLE: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[],
    values: &[],
    range: 0..=0,
};

static VARS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_CHILDREN),
    value: None,
};

static VARS_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_A_NODE),
    Some(&VARS_B_NODE),
    Some(&VARS_C_NODE),
    Some(&VARS_D_NODE),
    Some(&VARS_E_NODE),
    Some(&VARS_F_NODE),
    Some(&VARS_G_NODE),
    Some(&VARS_H_NODE),
    Some(&VARS_I_NODE),
    Some(&VARS_J_NODE),
    Some(&VARS_K_NODE),
    Some(&VARS_L_NODE),
    Some(&VARS_M_NODE),
    Some(&VARS_N_NODE),
    Some(&VARS_O_NODE),
    Some(&VARS_P_NODE),
    Some(&VARS_Q_NODE),
    Some(&VARS_R_NODE),
    Some(&VARS_S_NODE),
    Some(&VARS_T_NODE),
    Some(&VARS_U_NODE),
    Some(&VARS_V_NODE),
    Some(&VARS_W_NODE),
    None,
    Some(&VARS_Y_NODE),
    Some(&VARS_Z_NODE),
];

static VARS_Z_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_Z_CHILDREN),
    value: None,
};

pub static VARS_Z_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("affer"),
        dictgen::InsensitiveStr::Ascii("affers"),
        dictgen::InsensitiveStr::Ascii("affre"),
        dictgen::InsensitiveStr::Ascii("affres"),
        dictgen::InsensitiveStr::Ascii("ea"),
        dictgen::InsensitiveStr::Ascii("eas"),
        dictgen::InsensitiveStr::Ascii("eroise"),
        dictgen::InsensitiveStr::Ascii("eroised"),
        dictgen::InsensitiveStr::Ascii("eroises"),
        dictgen::InsensitiveStr::Ascii("eroising"),
        dictgen::InsensitiveStr::Ascii("eroize"),
        dictgen::InsensitiveStr::Ascii("eroized"),
        dictgen::InsensitiveStr::Ascii("eroizes"),
        dictgen::InsensitiveStr::Ascii("eroizing"),
        dictgen::InsensitiveStr::Ascii("oaea"),
        dictgen::InsensitiveStr::Ascii("oea"),
        dictgen::InsensitiveStr::Ascii("oeae"),
        dictgen::InsensitiveStr::Ascii("oeal"),
        dictgen::InsensitiveStr::Ascii("oeas"),
        dictgen::InsensitiveStr::Ascii("oecia"),
        dictgen::InsensitiveStr::Ascii("oecium"),
        dictgen::InsensitiveStr::Ascii("onaesthesia"),
        dictgen::InsensitiveStr::Ascii("onesthesia"),
        dictgen::InsensitiveStr::Ascii("onulae"),
        dictgen::InsensitiveStr::Ascii("onule"),
        dictgen::InsensitiveStr::Ascii("ooea"),
        dictgen::InsensitiveStr::Ascii("ooeae"),
        dictgen::InsensitiveStr::Ascii("ooeal"),
        dictgen::InsensitiveStr::Ascii("ooeas"),
        dictgen::InsensitiveStr::Ascii("ooecia"),
        dictgen::InsensitiveStr::Ascii("ooecium"),
        dictgen::InsensitiveStr::Ascii("ooglea"),
        dictgen::InsensitiveStr::Ascii("oogleae"),
        dictgen::InsensitiveStr::Ascii("oogleal"),
        dictgen::InsensitiveStr::Ascii("oogleas"),
        dictgen::InsensitiveStr::Ascii("oogloea"),
        dictgen::InsensitiveStr::Ascii("oogloeae"),
        dictgen::InsensitiveStr::Ascii("oogloeal"),
        dictgen::InsensitiveStr::Ascii("oogloeas"),
        dictgen::InsensitiveStr::Ascii("ygaenid"),
        dictgen::InsensitiveStr::Ascii("ygenid"),
    ],
    values: &[
        &[(0b00001, &ENTRY_ZAFFER_10527776117983596564)],
        &[(0b00001, &ENTRY_ZAFFERS_2686771360880865447)],
        &[(0b11010, &ENTRY_ZAFFER_10527776117983596564)],
        &[(0b11010, &ENTRY_ZAFFERS_2686771360880865447)],
        &[(0b00001, &ENTRY_ZEA_11106235456645827388)],
        &[(0b00001, &ENTRY_ZEAS_16079098418850825523)],
        &[(0b10010, &ENTRY_ZEROIZE_5851814204224675995)],
        &[(0b10010, &ENTRY_ZEROIZED_17059959399940465949)],
        &[(0b10010, &ENTRY_ZEROIZES_451395537748100839)],
        &[(0b10010, &ENTRY_ZEROIZING_17764051118899638643)],
        &[(0b01001, &ENTRY_ZEROIZE_5851814204224675995)],
        &[(0b01001, &ENTRY_ZEROIZED_17059959399940465949)],
        &[(0b01001, &ENTRY_ZEROIZES_451395537748100839)],
        &[(0b01001, &ENTRY_ZEROIZING_17764051118899638643)],
        &[(0b11010, &ENTRY_ZOEA_17148924521763695652)],
        &[
            (0b11010, &ENTRY_ZEA_11106235456645827388),
            (0b00001, &ENTRY_ZOEA_17148924521763695652),
            (0b00001, &ENTRY_ZOEA_9209140367896697417),
        ],
        &[(0b00001, &ENTRY_ZOEAE_16777813522281751943)],
        &[(0b00001, &ENTRY_ZOEAL_11452762743124231237)],
        &[
            (0b11010, &ENTRY_ZEAS_16079098418850825523),
            (0b00001, &ENTRY_ZOEAS_265178227546758074),
        ],
        &[(0b00001, &ENTRY_ZOECIA_8904526004070274154)],
        &[(0b00001, &ENTRY_ZOECIUM_16562741580002996142)],
        &[(0b11010, &ENTRY_ZONESTHESIA_3100074848208687922)],
        &[(0b00001, &ENTRY_ZONESTHESIA_3100074848208687922)],
        &[(0b11010, &ENTRY_ZONULE_1425795093078962568)],
        &[(0b00001, &ENTRY_ZONULE_1425795093078962568)],
        &[(0b11010, &ENTRY_ZOEA_9209140367896697417)],
        &[(0b11010, &ENTRY_ZOEAE_16777813522281751943)],
        &[(0b11010, &ENTRY_ZOEAL_11452762743124231237)],
        &[(0b11010, &ENTRY_ZOEAS_265178227546758074)],
        &[(0b11010, &ENTRY_ZOECIA_8904526004070274154)],
        &[(0b11010, &ENTRY_ZOECIUM_16562741580002996142)],
        &[(0b00001, &ENTRY_ZOOGLEA_5239592471376961231)],
        &[(0b00001, &ENTRY_ZOOGLEAE_8257944936060167006)],
        &[(0b00001, &ENTRY_ZOOGLEAL_12531107528650388160)],
        &[(0b00001, &ENTRY_ZOOGLEAS_1142556719691697396)],
        &[(0b11010, &ENTRY_ZOOGLEA_5239592471376961231)],
        &[(0b11010, &ENTRY_ZOOGLEAE_8257944936060167006)],
        &[(0b11010, &ENTRY_ZOOGLEAL_12531107528650388160)],
        &[(0b11010, &ENTRY_ZOOGLEAS_1142556719691697396)],
        &[(0b11010, &ENTRY_ZYGENID_18294614842044047958)],
        &[(0b00001, &ENTRY_ZYGENID_18294614842044047958)],
    ],
    range: 2..=11,
};

static VARS_Y_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_Y_CHILDREN),
    value: None,
};

pub static VARS_Y_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("odeled"),
        dictgen::InsensitiveStr::Ascii("odeler"),
        dictgen::InsensitiveStr::Ascii("odelers"),
        dictgen::InsensitiveStr::Ascii("odeling"),
        dictgen::InsensitiveStr::Ascii("odelled"),
        dictgen::InsensitiveStr::Ascii("odeller"),
        dictgen::InsensitiveStr::Ascii("odellers"),
        dictgen::InsensitiveStr::Ascii("odelling"),
        dictgen::InsensitiveStr::Ascii("oghourt"),
        dictgen::InsensitiveStr::Ascii("oghourts"),
        dictgen::InsensitiveStr::Ascii("oghurt"),
        dictgen::InsensitiveStr::Ascii("oghurts"),
        dictgen::InsensitiveStr::Ascii("ogourt"),
        dictgen::InsensitiveStr::Ascii("ogourts"),
    ],
    values: &[
        &[(0b01001, &ENTRY_YODELED_9356406298399519334)],
        &[(0b01001, &ENTRY_YODELER_285878482199218584)],
        &[(0b01001, &ENTRY_YODELERS_2440942956900301409)],
        &[(0b01001, &ENTRY_YODELING_14921433313912990218)],
        &[(0b11010, &ENTRY_YODELED_9356406298399519334)],
        &[(0b11010, &ENTRY_YODELER_285878482199218584)],
        &[(0b11010, &ENTRY_YODELERS_2440942956900301409)],
        &[(0b11010, &ENTRY_YODELING_14921433313912990218)],
        &[(0b10010, &ENTRY_YOGURT_14795287461115589482)],
        &[(0b10010, &ENTRY_YOGURTS_14006847350082938741)],
        &[(0b11010, &ENTRY_YOGURT_14795287461115589482)],
        &[(0b11010, &ENTRY_YOGURTS_14006847350082938741)],
        &[(0b01000, &ENTRY_YOGURT_14795287461115589482)],
        &[(0b01000, &ENTRY_YOGURTS_14006847350082938741)],
    ],
    range: 6..=8,
};

static VARS_W_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_W_CHILDREN),
    value: None,
};

static VARS_W_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_WA_NODE),
    None,
    None,
    None,
    Some(&VARS_WE_NODE),
    None,
    None,
    Some(&VARS_WH_NODE),
    Some(&VARS_WI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_WO_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_WO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_WO_CHILDREN),
    value: None,
};

pub static VARS_WO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("manisation"),
        dictgen::InsensitiveStr::Ascii("manisations"),
        dictgen::InsensitiveStr::Ascii("manise"),
        dictgen::InsensitiveStr::Ascii("manised"),
        dictgen::InsensitiveStr::Ascii("maniser"),
        dictgen::InsensitiveStr::Ascii("manisers"),
        dictgen::InsensitiveStr::Ascii("manises"),
        dictgen::InsensitiveStr::Ascii("manising"),
        dictgen::InsensitiveStr::Ascii("manization"),
        dictgen::InsensitiveStr::Ascii("manizations"),
        dictgen::InsensitiveStr::Ascii("manize"),
        dictgen::InsensitiveStr::Ascii("manized"),
        dictgen::InsensitiveStr::Ascii("manizer"),
        dictgen::InsensitiveStr::Ascii("manizers"),
        dictgen::InsensitiveStr::Ascii("manizes"),
        dictgen::InsensitiveStr::Ascii("manizing"),
        dictgen::InsensitiveStr::Ascii("odcockise"),
        dictgen::InsensitiveStr::Ascii("odcockises"),
        dictgen::InsensitiveStr::Ascii("odcockize"),
        dictgen::InsensitiveStr::Ascii("odcockizes"),
        dictgen::InsensitiveStr::Ascii("olen"),
        dictgen::InsensitiveStr::Ascii("olenization"),
        dictgen::InsensitiveStr::Ascii("olenizations"),
        dictgen::InsensitiveStr::Ascii("olenize"),
        dictgen::InsensitiveStr::Ascii("olenizes"),
        dictgen::InsensitiveStr::Ascii("olenner"),
        dictgen::InsensitiveStr::Ascii("olennest"),
        dictgen::InsensitiveStr::Ascii("olens"),
        dictgen::InsensitiveStr::Ascii("ollen"),
        dictgen::InsensitiveStr::Ascii("ollenisation"),
        dictgen::InsensitiveStr::Ascii("ollenisations"),
        dictgen::InsensitiveStr::Ascii("ollenise"),
        dictgen::InsensitiveStr::Ascii("ollenises"),
        dictgen::InsensitiveStr::Ascii("ollenization"),
        dictgen::InsensitiveStr::Ascii("ollenizations"),
        dictgen::InsensitiveStr::Ascii("ollenize"),
        dictgen::InsensitiveStr::Ascii("ollenizes"),
        dictgen::InsensitiveStr::Ascii("ollenner"),
        dictgen::InsensitiveStr::Ascii("ollennest"),
        dictgen::InsensitiveStr::Ascii("ollens"),
        dictgen::InsensitiveStr::Ascii("rnil"),
        dictgen::InsensitiveStr::Ascii("rshiped"),
        dictgen::InsensitiveStr::Ascii("rshiper"),
        dictgen::InsensitiveStr::Ascii("rshipers"),
        dictgen::InsensitiveStr::Ascii("rshiping"),
        dictgen::InsensitiveStr::Ascii("rshipped"),
        dictgen::InsensitiveStr::Ascii("rshipper"),
        dictgen::InsensitiveStr::Ascii("rshippers"),
        dictgen::InsensitiveStr::Ascii("rshipping"),
        dictgen::InsensitiveStr::Ascii("urnil"),
    ],
    values: &[
        &[(0b10010, &ENTRY_WOMANIZATION_8388350880273651311)],
        &[(0b10010, &ENTRY_WOMANIZATIONS_13952845861350174066)],
        &[(0b10010, &ENTRY_WOMANIZE_13239637807089654458)],
        &[(0b10010, &ENTRY_WOMANIZED_13265813200914382776)],
        &[(0b10010, &ENTRY_WOMANIZER_17770185505558084902)],
        &[(0b10010, &ENTRY_WOMANIZERS_9259673447489824653)],
        &[(0b10010, &ENTRY_WOMANIZES_14963203568866144583)],
        &[(0b10010, &ENTRY_WOMANIZING_18027895621894995913)],
        &[(0b01001, &ENTRY_WOMANIZATION_8388350880273651311)],
        &[(0b01001, &ENTRY_WOMANIZATIONS_13952845861350174066)],
        &[(0b01001, &ENTRY_WOMANIZE_13239637807089654458)],
        &[(0b01001, &ENTRY_WOMANIZED_13265813200914382776)],
        &[(0b01001, &ENTRY_WOMANIZER_17770185505558084902)],
        &[(0b01001, &ENTRY_WOMANIZERS_9259673447489824653)],
        &[(0b01001, &ENTRY_WOMANIZES_14963203568866144583)],
        &[(0b01001, &ENTRY_WOMANIZING_18027895621894995913)],
        &[(0b10010, &ENTRY_WOODCOCKIZE_12359995033224465169)],
        &[(0b10010, &ENTRY_WOODCOCKIZES_12391053488008876606)],
        &[(0b01001, &ENTRY_WOODCOCKIZE_12359995033224465169)],
        &[(0b01001, &ENTRY_WOODCOCKIZES_12391053488008876606)],
        &[(0b01001, &ENTRY_WOOLEN_15717013546287576656)],
        &[(0b00001, &ENTRY_WOOLENIZATION_2116233406109851879)],
        &[(0b00001, &ENTRY_WOOLENIZATIONS_18413526449670419815)],
        &[(0b00001, &ENTRY_WOOLENIZE_3109266446842903533)],
        &[(0b00001, &ENTRY_WOOLENIZES_10986368507483676931)],
        &[(0b01001, &ENTRY_WOOLENNER_17842051069153830315)],
        &[(0b01001, &ENTRY_WOOLENNEST_10863079266692878959)],
        &[(0b01001, &ENTRY_WOOLENS_12209882553973827060)],
        &[(0b11010, &ENTRY_WOOLEN_15717013546287576656)],
        &[(0b10010, &ENTRY_WOOLENIZATION_2116233406109851879)],
        &[(0b10010, &ENTRY_WOOLENIZATIONS_18413526449670419815)],
        &[(0b10010, &ENTRY_WOOLENIZE_3109266446842903533)],
        &[(0b10010, &ENTRY_WOOLENIZES_10986368507483676931)],
        &[(0b01000, &ENTRY_WOOLENIZATION_2116233406109851879)],
        &[(0b01000, &ENTRY_WOOLENIZATIONS_18413526449670419815)],
        &[(0b01000, &ENTRY_WOOLENIZE_3109266446842903533)],
        &[(0b01000, &ENTRY_WOOLENIZES_10986368507483676931)],
        &[(0b11010, &ENTRY_WOOLENNER_17842051069153830315)],
        &[(0b11010, &ENTRY_WOOLENNEST_10863079266692878959)],
        &[(0b11010, &ENTRY_WOOLENS_12209882553973827060)],
        &[(0b00001, &ENTRY_WORNIL_7106321021868280403)],
        &[(0b00001, &ENTRY_WORSHIPED_10866326533617664853)],
        &[(0b00001, &ENTRY_WORSHIPER_4363374512340886503)],
        &[(0b00001, &ENTRY_WORSHIPERS_10535090980834134943)],
        &[(0b00001, &ENTRY_WORSHIPING_7066968947382158195)],
        &[(0b11010, &ENTRY_WORSHIPED_10866326533617664853)],
        &[(0b11010, &ENTRY_WORSHIPER_4363374512340886503)],
        &[(0b11010, &ENTRY_WORSHIPERS_10535090980834134943)],
        &[(0b11010, &ENTRY_WORSHIPING_7066968947382158195)],
        &[(0b11010, &ENTRY_WORNIL_7106321021868280403)],
    ],
    range: 4..=13,
};

static VARS_WI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_WI_CHILDREN),
    value: None,
};

pub static VARS_WI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lfullier"),
        dictgen::InsensitiveStr::Ascii("lfulliest"),
        dictgen::InsensitiveStr::Ascii("lfully"),
        dictgen::InsensitiveStr::Ascii("llful"),
        dictgen::InsensitiveStr::Ascii("llfuler"),
        dictgen::InsensitiveStr::Ascii("llfulest"),
        dictgen::InsensitiveStr::Ascii("llfullier"),
        dictgen::InsensitiveStr::Ascii("llfulliest"),
        dictgen::InsensitiveStr::Ascii("llfully"),
        dictgen::InsensitiveStr::Ascii("llfulness"),
        dictgen::InsensitiveStr::Ascii("nterisation"),
        dictgen::InsensitiveStr::Ascii("nterisations"),
        dictgen::InsensitiveStr::Ascii("nterise"),
        dictgen::InsensitiveStr::Ascii("nterised"),
        dictgen::InsensitiveStr::Ascii("nterises"),
        dictgen::InsensitiveStr::Ascii("nterising"),
        dictgen::InsensitiveStr::Ascii("nterization"),
        dictgen::InsensitiveStr::Ascii("nterizations"),
        dictgen::InsensitiveStr::Ascii("nterize"),
        dictgen::InsensitiveStr::Ascii("nterized"),
        dictgen::InsensitiveStr::Ascii("nterizes"),
        dictgen::InsensitiveStr::Ascii("nterizing"),
        dictgen::InsensitiveStr::Ascii("sen"),
        dictgen::InsensitiveStr::Ascii("zen"),
    ],
    values: &[
        &[(0b11010, &ENTRY_WILLFULLIER_2697017026114247086)],
        &[(0b11010, &ENTRY_WILLFULLIEST_15153395951969058577)],
        &[(0b11010, &ENTRY_WILLFULLY_17551532991278844610)],
        &[(0b01001, &ENTRY_WILLFUL_7624543375604831885)],
        &[(0b01001, &ENTRY_WILLFULER_9723393434882898265)],
        &[(0b01001, &ENTRY_WILLFULEST_1356703166632625612)],
        &[(0b00001, &ENTRY_WILLFULLIER_2697017026114247086)],
        &[(0b00001, &ENTRY_WILLFULLIEST_15153395951969058577)],
        &[(0b00001, &ENTRY_WILLFULLY_17551532991278844610)],
        &[(0b00001, &ENTRY_WILLFULNESS_13563375725271959262)],
        &[(0b10010, &ENTRY_WINTERIZATION_7645598477678155456)],
        &[(0b10010, &ENTRY_WINTERIZATIONS_13592272727744097379)],
        &[(0b10010, &ENTRY_WINTERIZE_3955752504931726030)],
        &[(0b10010, &ENTRY_WINTERIZED_9857678671877956604)],
        &[(0b10010, &ENTRY_WINTERIZES_158574474219766318)],
        &[(0b10010, &ENTRY_WINTERIZING_11041236811279192392)],
        &[(0b01001, &ENTRY_WINTERIZATION_7645598477678155456)],
        &[(0b01001, &ENTRY_WINTERIZATIONS_13592272727744097379)],
        &[(0b01001, &ENTRY_WINTERIZE_3955752504931726030)],
        &[(0b01001, &ENTRY_WINTERIZED_9857678671877956604)],
        &[(0b01001, &ENTRY_WINTERIZES_158574474219766318)],
        &[(0b01001, &ENTRY_WINTERIZING_11041236811279192392)],
        &[(0b10010, &ENTRY_WIZEN_287155720416603669)],
        &[(0b01001, &ENTRY_WIZEN_287155720416603669)],
    ],
    range: 3..=12,
};

static VARS_WH_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_WH_CHILDREN),
    value: None,
};

pub static VARS_WH_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("iskeys"),
        dictgen::InsensitiveStr::Ascii("itmanise"),
        dictgen::InsensitiveStr::Ascii("itmanises"),
        dictgen::InsensitiveStr::Ascii("itmanize"),
        dictgen::InsensitiveStr::Ascii("itmanizes"),
    ],
    values: &[
        &[(0b01001, &ENTRY_WHISKEYS_17211820182326956376)],
        &[(0b10010, &ENTRY_WHITMANIZE_17709805677202222665)],
        &[(0b10010, &ENTRY_WHITMANIZES_2277386686370449672)],
        &[(0b01001, &ENTRY_WHITMANIZE_17709805677202222665)],
        &[(0b01001, &ENTRY_WHITMANIZES_2277386686370449672)],
    ],
    range: 6..=9,
};

static VARS_WE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_WE_CHILDREN),
    value: None,
};

pub static VARS_WE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aseled"),
        dictgen::InsensitiveStr::Ascii("aseling"),
        dictgen::InsensitiveStr::Ascii("aselled"),
        dictgen::InsensitiveStr::Ascii("aselling"),
        dictgen::InsensitiveStr::Ascii("atherise"),
        dictgen::InsensitiveStr::Ascii("atherised"),
        dictgen::InsensitiveStr::Ascii("atherises"),
        dictgen::InsensitiveStr::Ascii("atherising"),
        dictgen::InsensitiveStr::Ascii("atherize"),
        dictgen::InsensitiveStr::Ascii("atherized"),
        dictgen::InsensitiveStr::Ascii("atherizes"),
        dictgen::InsensitiveStr::Ascii("atherizing"),
        dictgen::InsensitiveStr::Ascii("eviled"),
        dictgen::InsensitiveStr::Ascii("evilled"),
        dictgen::InsensitiveStr::Ascii("ftwise"),
        dictgen::InsensitiveStr::Ascii("ftwize"),
        dictgen::InsensitiveStr::Ascii("ise"),
        dictgen::InsensitiveStr::Ascii("ised"),
        dictgen::InsensitiveStr::Ascii("ises"),
        dictgen::InsensitiveStr::Ascii("ising"),
        dictgen::InsensitiveStr::Ascii("ize"),
        dictgen::InsensitiveStr::Ascii("ized"),
        dictgen::InsensitiveStr::Ascii("izes"),
        dictgen::InsensitiveStr::Ascii("izing"),
        dictgen::InsensitiveStr::Ascii("r"),
        dictgen::InsensitiveStr::Ascii("sternisation"),
        dictgen::InsensitiveStr::Ascii("sternisations"),
        dictgen::InsensitiveStr::Ascii("sternise"),
        dictgen::InsensitiveStr::Ascii("sternised"),
        dictgen::InsensitiveStr::Ascii("sternises"),
        dictgen::InsensitiveStr::Ascii("sternising"),
        dictgen::InsensitiveStr::Ascii("sternization"),
        dictgen::InsensitiveStr::Ascii("sternizations"),
        dictgen::InsensitiveStr::Ascii("sternize"),
        dictgen::InsensitiveStr::Ascii("sternized"),
        dictgen::InsensitiveStr::Ascii("sternizes"),
        dictgen::InsensitiveStr::Ascii("sternizing"),
    ],
    values: &[
        &[(0b01001, &ENTRY_WEASELED_11570315947714387529)],
        &[(0b01001, &ENTRY_WEASELING_15286296280087806597)],
        &[(0b10010, &ENTRY_WEASELED_11570315947714387529)],
        &[(0b10010, &ENTRY_WEASELING_15286296280087806597)],
        &[(0b10010, &ENTRY_WEATHERIZE_2192670928369527010)],
        &[(0b10010, &ENTRY_WEATHERIZED_7468196884834492189)],
        &[(0b10010, &ENTRY_WEATHERIZES_9985373291367274228)],
        &[(0b10010, &ENTRY_WEATHERIZING_15974867536961027368)],
        &[(0b01001, &ENTRY_WEATHERIZE_2192670928369527010)],
        &[(0b01001, &ENTRY_WEATHERIZED_7468196884834492189)],
        &[(0b01001, &ENTRY_WEATHERIZES_9985373291367274228)],
        &[(0b01001, &ENTRY_WEATHERIZING_15974867536961027368)],
        &[(0b00001, &ENTRY_WEEVILED_9823853063466769617)],
        &[(0b11010, &ENTRY_WEEVILED_9823853063466769617)],
        &[(0b10010, &ENTRY_WEFTWIZE_11468980171486281071)],
        &[(0b01001, &ENTRY_WEFTWIZE_11468980171486281071)],
        &[(0b10010, &ENTRY_WEIZE_8174776964340050680)],
        &[(0b10010, &ENTRY_WEIZED_15084246244422353791)],
        &[(0b10010, &ENTRY_WEIZES_7320958225089246727)],
        &[(0b10010, &ENTRY_WEIZING_16099137944736271359)],
        &[(0b01001, &ENTRY_WEIZE_8174776964340050680)],
        &[(0b01001, &ENTRY_WEIZED_15084246244422353791)],
        &[(0b01001, &ENTRY_WEIZES_7320958225089246727)],
        &[(0b01001, &ENTRY_WEIZING_16099137944736271359)],
        &[(0b00001, &ENTRY_WER_15853599801760131986)],
        &[(0b10010, &ENTRY_WESTERNIZATION_9450693683308242701)],
        &[(0b10010, &ENTRY_WESTERNIZATIONS_13759633497928659151)],
        &[(0b10010, &ENTRY_WESTERNIZE_18201376901512962153)],
        &[(0b10010, &ENTRY_WESTERNIZED_4777853943475506918)],
        &[(0b10010, &ENTRY_WESTERNIZES_359511446272047498)],
        &[(0b10010, &ENTRY_WESTERNIZING_6658385047324066874)],
        &[(0b01001, &ENTRY_WESTERNIZATION_9450693683308242701)],
        &[(0b01001, &ENTRY_WESTERNIZATIONS_13759633497928659151)],
        &[(0b01001, &ENTRY_WESTERNIZE_18201376901512962153)],
        &[(0b01001, &ENTRY_WESTERNIZED_4777853943475506918)],
        &[(0b01001, &ENTRY_WESTERNIZES_359511446272047498)],
        &[(0b01001, &ENTRY_WESTERNIZING_6658385047324066874)],
    ],
    range: 1..=13,
};

static VARS_WA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_WA_CHILDREN),
    value: None,
};

pub static VARS_WA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ckes"),
        dictgen::InsensitiveStr::Ascii("ckoes"),
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("ggon"),
        dictgen::InsensitiveStr::Ascii("ggoned"),
        dictgen::InsensitiveStr::Ascii("ggoneer"),
        dictgen::InsensitiveStr::Ascii("ggoner"),
        dictgen::InsensitiveStr::Ascii("ggoners"),
        dictgen::InsensitiveStr::Ascii("ggonette"),
        dictgen::InsensitiveStr::Ascii("ggonettes"),
        dictgen::InsensitiveStr::Ascii("ggoning"),
        dictgen::InsensitiveStr::Ascii("ggons"),
        dictgen::InsensitiveStr::Ascii("gnerise"),
        dictgen::InsensitiveStr::Ascii("gnerises"),
        dictgen::InsensitiveStr::Ascii("gnerize"),
        dictgen::InsensitiveStr::Ascii("gnerizes"),
        dictgen::InsensitiveStr::Ascii("ntonise"),
        dictgen::InsensitiveStr::Ascii("ntonised"),
        dictgen::InsensitiveStr::Ascii("ntonises"),
        dictgen::InsensitiveStr::Ascii("ntonising"),
        dictgen::InsensitiveStr::Ascii("ntonize"),
        dictgen::InsensitiveStr::Ascii("ntonized"),
        dictgen::InsensitiveStr::Ascii("ntonizes"),
        dictgen::InsensitiveStr::Ascii("ntonizing"),
        dictgen::InsensitiveStr::Ascii("rer"),
        dictgen::InsensitiveStr::Ascii("rford"),
        dictgen::InsensitiveStr::Ascii("rfourd"),
        dictgen::InsensitiveStr::Ascii("rrantise"),
        dictgen::InsensitiveStr::Ascii("rrantize"),
        dictgen::InsensitiveStr::Ascii("rre"),
        dictgen::InsensitiveStr::Ascii("tercolor"),
        dictgen::InsensitiveStr::Ascii("tercolored"),
        dictgen::InsensitiveStr::Ascii("tercoloring"),
        dictgen::InsensitiveStr::Ascii("tercolorist"),
        dictgen::InsensitiveStr::Ascii("tercolorists"),
        dictgen::InsensitiveStr::Ascii("tercolors"),
        dictgen::InsensitiveStr::Ascii("tercolour"),
        dictgen::InsensitiveStr::Ascii("tercoloured"),
        dictgen::InsensitiveStr::Ascii("tercolouring"),
        dictgen::InsensitiveStr::Ascii("tercolourist"),
        dictgen::InsensitiveStr::Ascii("tercolourists"),
        dictgen::InsensitiveStr::Ascii("tercolours"),
    ],
    values: &[
        &[(0b00001, &ENTRY_WACKES_12738481748744727840)],
        &[(0b11010, &ENTRY_WACKES_12738481748744727840)],
        &[(0b11010, &ENTRY_WER_15853599801760131986)],
        &[(0b10010, &ENTRY_WAGON_9175179404225633205)],
        &[(0b10010, &ENTRY_WAGONED_11373672045286783138)],
        &[(0b11010, &ENTRY_WAGONEER_17408093464143438026)],
        &[(0b10010, &ENTRY_WAGONER_7174401894558856152)],
        &[(0b10010, &ENTRY_WAGONERS_8328342185970927143)],
        &[(0b10010, &ENTRY_WAGONETTE_10106097158675362196)],
        &[(0b10010, &ENTRY_WAGONETTES_18300454369865577574)],
        &[(0b10010, &ENTRY_WAGONING_6834423535434103369)],
        &[(0b10010, &ENTRY_WAGONS_16296021619075314226)],
        &[(0b10010, &ENTRY_WAGNERIZE_6840934791092236521)],
        &[(0b10010, &ENTRY_WAGNERIZES_8895003839461059816)],
        &[(0b01001, &ENTRY_WAGNERIZE_6840934791092236521)],
        &[(0b01001, &ENTRY_WAGNERIZES_8895003839461059816)],
        &[(0b10010, &ENTRY_WANTONIZE_14427284173321750170)],
        &[(0b10010, &ENTRY_WANTONIZED_15092244368516355065)],
        &[(0b10010, &ENTRY_WANTONIZES_8102013437087314845)],
        &[(0b10010, &ENTRY_WANTONIZING_11612419212222365365)],
        &[(0b01001, &ENTRY_WANTONIZE_14427284173321750170)],
        &[(0b01001, &ENTRY_WANTONIZED_15092244368516355065)],
        &[(0b01001, &ENTRY_WANTONIZES_8102013437087314845)],
        &[(0b01001, &ENTRY_WANTONIZING_11612419212222365365)],
        &[(0b00001, &ENTRY_WARER_124002938733117158)],
        &[(0b00001, &ENTRY_WARFORD_9070503211126736019)],
        &[(0b11010, &ENTRY_WARFORD_9070503211126736019)],
        &[(0b10010, &ENTRY_WARRANTIZE_12531974386933132943)],
        &[(0b01001, &ENTRY_WARRANTIZE_12531974386933132943)],
        &[(0b11010, &ENTRY_WARER_124002938733117158)],
        &[(0b11001, &ENTRY_WATERCOLOR_14626819058358461476)],
        &[(0b11001, &ENTRY_WATERCOLORED_6965422467906206000)],
        &[(0b11001, &ENTRY_WATERCOLORING_10355406009413574616)],
        &[(0b00001, &ENTRY_WATERCOLORIST_98941858503965450)],
        &[(0b00001, &ENTRY_WATERCOLORISTS_8716481806936659758)],
        &[(0b11001, &ENTRY_WATERCOLORS_8321231076259173473)],
        &[(0b11010, &ENTRY_WATERCOLOR_14626819058358461476)],
        &[(0b11010, &ENTRY_WATERCOLORED_6965422467906206000)],
        &[(0b11010, &ENTRY_WATERCOLORING_10355406009413574616)],
        &[(0b11010, &ENTRY_WATERCOLORIST_98941858503965450)],
        &[(0b11010, &ENTRY_WATERCOLORISTS_8716481806936659758)],
        &[(0b11010, &ENTRY_WATERCOLORS_8321231076259173473)],
    ],
    range: 2..=13,
};

static VARS_V_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_V_CHILDREN),
    value: None,
};

static VARS_V_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_VA_NODE),
    None,
    None,
    None,
    Some(&VARS_VE_NODE),
    None,
    None,
    None,
    Some(&VARS_VI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_VO_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_VU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_VU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VU_CHILDREN),
    value: None,
};

pub static VARS_VU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lcanisable"),
        dictgen::InsensitiveStr::Ascii("lcanisabler"),
        dictgen::InsensitiveStr::Ascii("lcanisables"),
        dictgen::InsensitiveStr::Ascii("lcanisablest"),
        dictgen::InsensitiveStr::Ascii("lcanisate"),
        dictgen::InsensitiveStr::Ascii("lcanisates"),
        dictgen::InsensitiveStr::Ascii("lcanisation"),
        dictgen::InsensitiveStr::Ascii("lcanisations"),
        dictgen::InsensitiveStr::Ascii("lcanise"),
        dictgen::InsensitiveStr::Ascii("lcanised"),
        dictgen::InsensitiveStr::Ascii("lcaniser"),
        dictgen::InsensitiveStr::Ascii("lcanisers"),
        dictgen::InsensitiveStr::Ascii("lcanises"),
        dictgen::InsensitiveStr::Ascii("lcanising"),
        dictgen::InsensitiveStr::Ascii("lcanizable"),
        dictgen::InsensitiveStr::Ascii("lcanizabler"),
        dictgen::InsensitiveStr::Ascii("lcanizables"),
        dictgen::InsensitiveStr::Ascii("lcanizablest"),
        dictgen::InsensitiveStr::Ascii("lcanizate"),
        dictgen::InsensitiveStr::Ascii("lcanizates"),
        dictgen::InsensitiveStr::Ascii("lcanization"),
        dictgen::InsensitiveStr::Ascii("lcanizations"),
        dictgen::InsensitiveStr::Ascii("lcanize"),
        dictgen::InsensitiveStr::Ascii("lcanized"),
        dictgen::InsensitiveStr::Ascii("lcanizer"),
        dictgen::InsensitiveStr::Ascii("lcanizers"),
        dictgen::InsensitiveStr::Ascii("lcanizes"),
        dictgen::InsensitiveStr::Ascii("lcanizing"),
        dictgen::InsensitiveStr::Ascii("lgarisation"),
        dictgen::InsensitiveStr::Ascii("lgarisations"),
        dictgen::InsensitiveStr::Ascii("lgarise"),
        dictgen::InsensitiveStr::Ascii("lgarised"),
        dictgen::InsensitiveStr::Ascii("lgariser"),
        dictgen::InsensitiveStr::Ascii("lgarisers"),
        dictgen::InsensitiveStr::Ascii("lgarises"),
        dictgen::InsensitiveStr::Ascii("lgarising"),
        dictgen::InsensitiveStr::Ascii("lgarization"),
        dictgen::InsensitiveStr::Ascii("lgarizations"),
        dictgen::InsensitiveStr::Ascii("lgarize"),
        dictgen::InsensitiveStr::Ascii("lgarized"),
        dictgen::InsensitiveStr::Ascii("lgarizer"),
        dictgen::InsensitiveStr::Ascii("lgarizers"),
        dictgen::InsensitiveStr::Ascii("lgarizes"),
        dictgen::InsensitiveStr::Ascii("lgarizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VULCANIZABLE_3568502198024878932)],
        &[(0b10010, &ENTRY_VULCANIZABLER_4054424358397582656)],
        &[(0b10010, &ENTRY_VULCANIZABLES_8379629917557167700)],
        &[(0b10010, &ENTRY_VULCANIZABLEST_6459505877444949673)],
        &[(0b10010, &ENTRY_VULCANIZATE_4795671622025524378)],
        &[(0b10010, &ENTRY_VULCANIZATES_16942202816352460180)],
        &[(0b10010, &ENTRY_VULCANIZATION_3258864381780829761)],
        &[(0b10010, &ENTRY_VULCANIZATIONS_12614859722986396332)],
        &[(0b10010, &ENTRY_VULCANIZE_977902884734413931)],
        &[(0b10010, &ENTRY_VULCANIZED_15788444725575758612)],
        &[(0b10010, &ENTRY_VULCANIZER_3777087061043675341)],
        &[(0b10010, &ENTRY_VULCANIZERS_4164062164915178108)],
        &[(0b10010, &ENTRY_VULCANIZES_18094247566727839218)],
        &[(0b10010, &ENTRY_VULCANIZING_16179329893471043275)],
        &[(0b01001, &ENTRY_VULCANIZABLE_3568502198024878932)],
        &[(0b01001, &ENTRY_VULCANIZABLER_4054424358397582656)],
        &[(0b01001, &ENTRY_VULCANIZABLES_8379629917557167700)],
        &[(0b01001, &ENTRY_VULCANIZABLEST_6459505877444949673)],
        &[(0b01001, &ENTRY_VULCANIZATE_4795671622025524378)],
        &[(0b01001, &ENTRY_VULCANIZATES_16942202816352460180)],
        &[(0b01001, &ENTRY_VULCANIZATION_3258864381780829761)],
        &[(0b01001, &ENTRY_VULCANIZATIONS_12614859722986396332)],
        &[(0b01001, &ENTRY_VULCANIZE_977902884734413931)],
        &[(0b01001, &ENTRY_VULCANIZED_15788444725575758612)],
        &[(0b01001, &ENTRY_VULCANIZER_3777087061043675341)],
        &[(0b01001, &ENTRY_VULCANIZERS_4164062164915178108)],
        &[(0b01001, &ENTRY_VULCANIZES_18094247566727839218)],
        &[(0b01001, &ENTRY_VULCANIZING_16179329893471043275)],
        &[(0b10010, &ENTRY_VULGARIZATION_9399086175034751352)],
        &[(0b10010, &ENTRY_VULGARIZATIONS_17269033887487645821)],
        &[(0b10010, &ENTRY_VULGARIZE_3593216075985714450)],
        &[(0b10010, &ENTRY_VULGARIZED_16682935641229034184)],
        &[(0b10010, &ENTRY_VULGARIZER_11079564505577982456)],
        &[(0b10010, &ENTRY_VULGARIZERS_1013773146928265577)],
        &[(0b10010, &ENTRY_VULGARIZES_1421269681767890441)],
        &[(0b10010, &ENTRY_VULGARIZING_8957250676888139808)],
        &[(0b01001, &ENTRY_VULGARIZATION_9399086175034751352)],
        &[(0b01001, &ENTRY_VULGARIZATIONS_17269033887487645821)],
        &[(0b01001, &ENTRY_VULGARIZE_3593216075985714450)],
        &[(0b01001, &ENTRY_VULGARIZED_16682935641229034184)],
        &[(0b01001, &ENTRY_VULGARIZER_11079564505577982456)],
        &[(0b01001, &ENTRY_VULGARIZERS_1013773146928265577)],
        &[(0b01001, &ENTRY_VULGARIZES_1421269681767890441)],
        &[(0b01001, &ENTRY_VULGARIZING_8957250676888139808)],
    ],
    range: 7..=12,
};

static VARS_VO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_VO_CHILDREN),
    value: None,
};

static VARS_VO_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    Some(&VARS_VOC_NODE),
    None,
    Some(&VARS_VOE_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_VOL_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_VOW_NODE),
    None,
    None,
    None,
];

static VARS_VOW_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VOW_CHILDREN),
    value: None,
};

pub static VARS_VOW_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("elisation"),
        dictgen::InsensitiveStr::Ascii("elisations"),
        dictgen::InsensitiveStr::Ascii("elise"),
        dictgen::InsensitiveStr::Ascii("elised"),
        dictgen::InsensitiveStr::Ascii("elises"),
        dictgen::InsensitiveStr::Ascii("elising"),
        dictgen::InsensitiveStr::Ascii("elization"),
        dictgen::InsensitiveStr::Ascii("elizations"),
        dictgen::InsensitiveStr::Ascii("elize"),
        dictgen::InsensitiveStr::Ascii("elized"),
        dictgen::InsensitiveStr::Ascii("elizes"),
        dictgen::InsensitiveStr::Ascii("elizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VOWELIZATION_989128645335163882)],
        &[(0b10010, &ENTRY_VOWELIZATIONS_5803231980451353684)],
        &[(0b10010, &ENTRY_VOWELIZE_18108634882497063258)],
        &[(0b10010, &ENTRY_VOWELIZED_10046225650144601473)],
        &[(0b10010, &ENTRY_VOWELIZES_10478314626294200903)],
        &[(0b10010, &ENTRY_VOWELIZING_1774578233754681336)],
        &[(0b01001, &ENTRY_VOWELIZATION_989128645335163882)],
        &[(0b01001, &ENTRY_VOWELIZATIONS_5803231980451353684)],
        &[(0b01001, &ENTRY_VOWELIZE_18108634882497063258)],
        &[(0b01001, &ENTRY_VOWELIZED_10046225650144601473)],
        &[(0b01001, &ENTRY_VOWELIZES_10478314626294200903)],
        &[(0b01001, &ENTRY_VOWELIZING_1774578233754681336)],
    ],
    range: 5..=10,
};

static VARS_VOL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VOL_CHILDREN),
    value: None,
};

pub static VARS_VOL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("atilisable"),
        dictgen::InsensitiveStr::Ascii("atilisabler"),
        dictgen::InsensitiveStr::Ascii("atilisables"),
        dictgen::InsensitiveStr::Ascii("atilisablest"),
        dictgen::InsensitiveStr::Ascii("atilisation"),
        dictgen::InsensitiveStr::Ascii("atilisations"),
        dictgen::InsensitiveStr::Ascii("atilise"),
        dictgen::InsensitiveStr::Ascii("atilised"),
        dictgen::InsensitiveStr::Ascii("atiliser"),
        dictgen::InsensitiveStr::Ascii("atilisers"),
        dictgen::InsensitiveStr::Ascii("atilises"),
        dictgen::InsensitiveStr::Ascii("atilising"),
        dictgen::InsensitiveStr::Ascii("atilizable"),
        dictgen::InsensitiveStr::Ascii("atilizabler"),
        dictgen::InsensitiveStr::Ascii("atilizables"),
        dictgen::InsensitiveStr::Ascii("atilizablest"),
        dictgen::InsensitiveStr::Ascii("atilization"),
        dictgen::InsensitiveStr::Ascii("atilizations"),
        dictgen::InsensitiveStr::Ascii("atilize"),
        dictgen::InsensitiveStr::Ascii("atilized"),
        dictgen::InsensitiveStr::Ascii("atilizer"),
        dictgen::InsensitiveStr::Ascii("atilizers"),
        dictgen::InsensitiveStr::Ascii("atilizes"),
        dictgen::InsensitiveStr::Ascii("atilizing"),
        dictgen::InsensitiveStr::Ascii("canisation"),
        dictgen::InsensitiveStr::Ascii("canisations"),
        dictgen::InsensitiveStr::Ascii("canise"),
        dictgen::InsensitiveStr::Ascii("canised"),
        dictgen::InsensitiveStr::Ascii("canises"),
        dictgen::InsensitiveStr::Ascii("canising"),
        dictgen::InsensitiveStr::Ascii("canization"),
        dictgen::InsensitiveStr::Ascii("canizations"),
        dictgen::InsensitiveStr::Ascii("canize"),
        dictgen::InsensitiveStr::Ascii("canized"),
        dictgen::InsensitiveStr::Ascii("canizes"),
        dictgen::InsensitiveStr::Ascii("canizing"),
        dictgen::InsensitiveStr::Ascii("tise"),
        dictgen::InsensitiveStr::Ascii("tises"),
        dictgen::InsensitiveStr::Ascii("tize"),
        dictgen::InsensitiveStr::Ascii("tizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VOLATILIZABLE_14191734210917893484)],
        &[(0b10010, &ENTRY_VOLATILIZABLER_10970801449329037349)],
        &[(0b10010, &ENTRY_VOLATILIZABLES_3387142756898266550)],
        &[(0b10010, &ENTRY_VOLATILIZABLEST_9951102031117910204)],
        &[(0b10010, &ENTRY_VOLATILIZATION_2524869946541654890)],
        &[(0b10010, &ENTRY_VOLATILIZATIONS_2738963093881521684)],
        &[(0b10010, &ENTRY_VOLATILIZE_12701439457008031789)],
        &[(0b10010, &ENTRY_VOLATILIZED_162413967292134988)],
        &[(0b10010, &ENTRY_VOLATILIZER_15355427557723391751)],
        &[(0b10010, &ENTRY_VOLATILIZERS_8351703320828050913)],
        &[(0b10010, &ENTRY_VOLATILIZES_1469470071448453292)],
        &[(0b10010, &ENTRY_VOLATILIZING_4582472073708524953)],
        &[(0b01001, &ENTRY_VOLATILIZABLE_14191734210917893484)],
        &[(0b01001, &ENTRY_VOLATILIZABLER_10970801449329037349)],
        &[(0b01001, &ENTRY_VOLATILIZABLES_3387142756898266550)],
        &[(0b01001, &ENTRY_VOLATILIZABLEST_9951102031117910204)],
        &[(0b01001, &ENTRY_VOLATILIZATION_2524869946541654890)],
        &[(0b01001, &ENTRY_VOLATILIZATIONS_2738963093881521684)],
        &[(0b01001, &ENTRY_VOLATILIZE_12701439457008031789)],
        &[(0b01001, &ENTRY_VOLATILIZED_162413967292134988)],
        &[(0b01001, &ENTRY_VOLATILIZER_15355427557723391751)],
        &[(0b01001, &ENTRY_VOLATILIZERS_8351703320828050913)],
        &[(0b01001, &ENTRY_VOLATILIZES_1469470071448453292)],
        &[(0b01001, &ENTRY_VOLATILIZING_4582472073708524953)],
        &[(0b10010, &ENTRY_VOLCANIZATION_15208079623603218405)],
        &[(0b10010, &ENTRY_VOLCANIZATIONS_11922563203603211916)],
        &[(0b10010, &ENTRY_VOLCANIZE_5966901671703511868)],
        &[(0b10010, &ENTRY_VOLCANIZED_7340807631500965062)],
        &[(0b10010, &ENTRY_VOLCANIZES_8125520318354745094)],
        &[(0b10010, &ENTRY_VOLCANIZING_17170908759013088769)],
        &[(0b01001, &ENTRY_VOLCANIZATION_15208079623603218405)],
        &[(0b01001, &ENTRY_VOLCANIZATIONS_11922563203603211916)],
        &[(0b01001, &ENTRY_VOLCANIZE_5966901671703511868)],
        &[(0b01001, &ENTRY_VOLCANIZED_7340807631500965062)],
        &[(0b01001, &ENTRY_VOLCANIZES_8125520318354745094)],
        &[(0b01001, &ENTRY_VOLCANIZING_17170908759013088769)],
        &[(0b10010, &ENTRY_VOLTIZE_7549036914115473442)],
        &[(0b10010, &ENTRY_VOLTIZES_16866957908997653386)],
        &[(0b01001, &ENTRY_VOLTIZE_7549036914115473442)],
        &[(0b01001, &ENTRY_VOLTIZES_16866957908997653386)],
    ],
    range: 4..=12,
};

static VARS_VOE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VOE_CHILDREN),
    value: Some(&[(0b11010, &ENTRY_VE_18321759983148480762)]),
};

pub static VARS_VOE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[],
    values: &[],
    range: 0..=0,
};

static VARS_VOC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VOC_CHILDREN),
    value: None,
};

pub static VARS_VOC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alisation"),
        dictgen::InsensitiveStr::Ascii("alisations"),
        dictgen::InsensitiveStr::Ascii("alise"),
        dictgen::InsensitiveStr::Ascii("alised"),
        dictgen::InsensitiveStr::Ascii("aliser"),
        dictgen::InsensitiveStr::Ascii("alisers"),
        dictgen::InsensitiveStr::Ascii("alises"),
        dictgen::InsensitiveStr::Ascii("alising"),
        dictgen::InsensitiveStr::Ascii("alization"),
        dictgen::InsensitiveStr::Ascii("alizations"),
        dictgen::InsensitiveStr::Ascii("alize"),
        dictgen::InsensitiveStr::Ascii("alized"),
        dictgen::InsensitiveStr::Ascii("alizer"),
        dictgen::InsensitiveStr::Ascii("alizers"),
        dictgen::InsensitiveStr::Ascii("alizes"),
        dictgen::InsensitiveStr::Ascii("alizing"),
        dictgen::InsensitiveStr::Ascii("ationalisation"),
        dictgen::InsensitiveStr::Ascii("ationalisations"),
        dictgen::InsensitiveStr::Ascii("ationalise"),
        dictgen::InsensitiveStr::Ascii("ationalises"),
        dictgen::InsensitiveStr::Ascii("ationalization"),
        dictgen::InsensitiveStr::Ascii("ationalizations"),
        dictgen::InsensitiveStr::Ascii("ationalize"),
        dictgen::InsensitiveStr::Ascii("ationalizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VOCALIZATION_16299156444456516020)],
        &[(0b10010, &ENTRY_VOCALIZATIONS_6540912521590792850)],
        &[(0b10010, &ENTRY_VOCALIZE_1522162759221483083)],
        &[(0b10010, &ENTRY_VOCALIZED_18024346592150936448)],
        &[(0b10010, &ENTRY_VOCALIZER_12799422523009315217)],
        &[(0b10010, &ENTRY_VOCALIZERS_5083157038348945833)],
        &[(0b10010, &ENTRY_VOCALIZES_1880412935306735877)],
        &[(0b10010, &ENTRY_VOCALIZING_6361847323758753459)],
        &[(0b01001, &ENTRY_VOCALIZATION_16299156444456516020)],
        &[(0b01001, &ENTRY_VOCALIZATIONS_6540912521590792850)],
        &[(0b01001, &ENTRY_VOCALIZE_1522162759221483083)],
        &[(0b01001, &ENTRY_VOCALIZED_18024346592150936448)],
        &[(0b01001, &ENTRY_VOCALIZER_12799422523009315217)],
        &[(0b01001, &ENTRY_VOCALIZERS_5083157038348945833)],
        &[(0b01001, &ENTRY_VOCALIZES_1880412935306735877)],
        &[(0b01001, &ENTRY_VOCALIZING_6361847323758753459)],
        &[(0b10010, &ENTRY_VOCATIONALIZATION_5843882192252215451)],
        &[(0b10010, &ENTRY_VOCATIONALIZATIONS_12760103465092649332)],
        &[(0b10010, &ENTRY_VOCATIONALIZE_11565960507105247770)],
        &[(0b10010, &ENTRY_VOCATIONALIZES_9469137790249815859)],
        &[(0b01001, &ENTRY_VOCATIONALIZATION_5843882192252215451)],
        &[(0b01001, &ENTRY_VOCATIONALIZATIONS_12760103465092649332)],
        &[(0b01001, &ENTRY_VOCATIONALIZE_11565960507105247770)],
        &[(0b01001, &ENTRY_VOCATIONALIZES_9469137790249815859)],
    ],
    range: 5..=15,
};

static VARS_VI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_VI_CHILDREN),
    value: None,
};

static VARS_VI_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_VIA_NODE),
    None,
    Some(&VARS_VIC_NODE),
    Some(&VARS_VID_NODE),
    Some(&VARS_VIE_NODE),
    None,
    Some(&VARS_VIG_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_VIL_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_VIR_NODE),
    Some(&VARS_VIS_NODE),
    Some(&VARS_VIT_NODE),
    None,
    Some(&VARS_VIV_NODE),
    None,
    None,
    None,
    Some(&VARS_VIZ_NODE),
];

static VARS_VIZ_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VIZ_CHILDREN),
    value: None,
};

pub static VARS_VIZ_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ard"),
        dictgen::InsensitiveStr::Ascii("ards"),
        dictgen::InsensitiveStr::Ascii("ied"),
        dictgen::InsensitiveStr::Ascii("ies"),
        dictgen::InsensitiveStr::Ascii("or"),
        dictgen::InsensitiveStr::Ascii("ors"),
    ],
    values: &[
        &[(0b01001, &ENTRY_VIZARD_10999789749375739354)],
        &[(0b01001, &ENTRY_VIZARDS_6967258731291371717)],
        &[(0b01001, &ENTRY_VIZIED_7049215544631748789)],
        &[(0b01001, &ENTRY_VIZIES_2932586557445870650)],
        &[(0b10011, &ENTRY_VISOR_11952253766687812439)],
        &[(0b10011, &ENTRY_VISORS_161131917315397622)],
    ],
    range: 2..=4,
};

static VARS_VIV_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VIV_CHILDREN),
    value: None,
};

pub static VARS_VIV_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("andier"),
        dictgen::InsensitiveStr::Ascii("andire"),
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("errinae"),
        dictgen::InsensitiveStr::Ascii("errine"),
        dictgen::InsensitiveStr::Ascii("ers"),
        dictgen::InsensitiveStr::Ascii("re"),
        dictgen::InsensitiveStr::Ascii("res"),
    ],
    values: &[
        &[(0b00001, &ENTRY_VIVANDIER_12659384511325353809)],
        &[(0b11010, &ENTRY_VIVANDIER_12659384511325353809)],
        &[(0b00001, &ENTRY_VIVER_3159459969980561998)],
        &[(0b11010, &ENTRY_VIVERRINE_4631118611455296151)],
        &[(0b00001, &ENTRY_VIVERRINE_4631118611455296151)],
        &[(0b00001, &ENTRY_VIVERS_1304906869884388477)],
        &[(0b11010, &ENTRY_VIVER_3159459969980561998)],
        &[(0b11010, &ENTRY_VIVERS_1304906869884388477)],
    ],
    range: 2..=7,
};

static VARS_VIT_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VIT_CHILDREN),
    value: None,
};

pub static VARS_VIT_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alisation"),
        dictgen::InsensitiveStr::Ascii("alisations"),
        dictgen::InsensitiveStr::Ascii("alise"),
        dictgen::InsensitiveStr::Ascii("alised"),
        dictgen::InsensitiveStr::Ascii("aliser"),
        dictgen::InsensitiveStr::Ascii("alisers"),
        dictgen::InsensitiveStr::Ascii("alises"),
        dictgen::InsensitiveStr::Ascii("alising"),
        dictgen::InsensitiveStr::Ascii("alisingly"),
        dictgen::InsensitiveStr::Ascii("alisings"),
        dictgen::InsensitiveStr::Ascii("alization"),
        dictgen::InsensitiveStr::Ascii("alizations"),
        dictgen::InsensitiveStr::Ascii("alize"),
        dictgen::InsensitiveStr::Ascii("alized"),
        dictgen::InsensitiveStr::Ascii("alizer"),
        dictgen::InsensitiveStr::Ascii("alizers"),
        dictgen::InsensitiveStr::Ascii("alizes"),
        dictgen::InsensitiveStr::Ascii("alizing"),
        dictgen::InsensitiveStr::Ascii("alizingly"),
        dictgen::InsensitiveStr::Ascii("alizings"),
        dictgen::InsensitiveStr::Ascii("aminisation"),
        dictgen::InsensitiveStr::Ascii("aminise"),
        dictgen::InsensitiveStr::Ascii("aminised"),
        dictgen::InsensitiveStr::Ascii("aminises"),
        dictgen::InsensitiveStr::Ascii("aminising"),
        dictgen::InsensitiveStr::Ascii("aminization"),
        dictgen::InsensitiveStr::Ascii("aminize"),
        dictgen::InsensitiveStr::Ascii("aminized"),
        dictgen::InsensitiveStr::Ascii("aminizes"),
        dictgen::InsensitiveStr::Ascii("aminizing"),
        dictgen::InsensitiveStr::Ascii("riolisable"),
        dictgen::InsensitiveStr::Ascii("riolisables"),
        dictgen::InsensitiveStr::Ascii("riolisation"),
        dictgen::InsensitiveStr::Ascii("riolisations"),
        dictgen::InsensitiveStr::Ascii("riolise"),
        dictgen::InsensitiveStr::Ascii("riolised"),
        dictgen::InsensitiveStr::Ascii("rioliser"),
        dictgen::InsensitiveStr::Ascii("riolisers"),
        dictgen::InsensitiveStr::Ascii("riolises"),
        dictgen::InsensitiveStr::Ascii("riolising"),
        dictgen::InsensitiveStr::Ascii("riolizable"),
        dictgen::InsensitiveStr::Ascii("riolizables"),
        dictgen::InsensitiveStr::Ascii("riolization"),
        dictgen::InsensitiveStr::Ascii("riolizations"),
        dictgen::InsensitiveStr::Ascii("riolize"),
        dictgen::InsensitiveStr::Ascii("riolized"),
        dictgen::InsensitiveStr::Ascii("riolizer"),
        dictgen::InsensitiveStr::Ascii("riolizers"),
        dictgen::InsensitiveStr::Ascii("riolizes"),
        dictgen::InsensitiveStr::Ascii("riolizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VITALIZATION_11563378875657312422)],
        &[(0b10010, &ENTRY_VITALIZATIONS_18199586670931656342)],
        &[(0b10010, &ENTRY_VITALIZE_14767623916291210585)],
        &[(0b10010, &ENTRY_VITALIZED_5879957138765444190)],
        &[(0b10010, &ENTRY_VITALIZER_11015449244036225995)],
        &[(0b10010, &ENTRY_VITALIZERS_4676040118864720970)],
        &[(0b10010, &ENTRY_VITALIZES_6574062411877117887)],
        &[(0b10010, &ENTRY_VITALIZING_1172441218463801200)],
        &[(0b10010, &ENTRY_VITALIZINGLY_17977921766837363551)],
        &[(0b10010, &ENTRY_VITALIZINGS_7993175705382773400)],
        &[(0b01001, &ENTRY_VITALIZATION_11563378875657312422)],
        &[(0b01001, &ENTRY_VITALIZATIONS_18199586670931656342)],
        &[(0b01001, &ENTRY_VITALIZE_14767623916291210585)],
        &[(0b01001, &ENTRY_VITALIZED_5879957138765444190)],
        &[(0b01001, &ENTRY_VITALIZER_11015449244036225995)],
        &[(0b01001, &ENTRY_VITALIZERS_4676040118864720970)],
        &[(0b01001, &ENTRY_VITALIZES_6574062411877117887)],
        &[(0b01001, &ENTRY_VITALIZING_1172441218463801200)],
        &[(0b01001, &ENTRY_VITALIZINGLY_17977921766837363551)],
        &[(0b01001, &ENTRY_VITALIZINGS_7993175705382773400)],
        &[(0b10010, &ENTRY_VITAMINIZATION_4345576685277511178)],
        &[(0b10010, &ENTRY_VITAMINIZE_3815155023809780843)],
        &[(0b10010, &ENTRY_VITAMINIZED_11070966012909977792)],
        &[(0b10010, &ENTRY_VITAMINIZES_11610615403175719091)],
        &[(0b10010, &ENTRY_VITAMINIZING_14433390025156461290)],
        &[(0b01001, &ENTRY_VITAMINIZATION_4345576685277511178)],
        &[(0b01001, &ENTRY_VITAMINIZE_3815155023809780843)],
        &[(0b01001, &ENTRY_VITAMINIZED_11070966012909977792)],
        &[(0b01001, &ENTRY_VITAMINIZES_11610615403175719091)],
        &[(0b01001, &ENTRY_VITAMINIZING_14433390025156461290)],
        &[(0b10010, &ENTRY_VITRIOLIZABLE_10128808547473444732)],
        &[(0b10010, &ENTRY_VITRIOLIZABLES_6495066641769157690)],
        &[(0b10010, &ENTRY_VITRIOLIZATION_12177216141601047223)],
        &[(0b10010, &ENTRY_VITRIOLIZATIONS_12059310110149895869)],
        &[(0b10010, &ENTRY_VITRIOLIZE_16677616817185174970)],
        &[(0b10010, &ENTRY_VITRIOLIZED_726289364433095774)],
        &[(0b10010, &ENTRY_VITRIOLIZER_1822506942241343764)],
        &[(0b10010, &ENTRY_VITRIOLIZERS_1786300307817004832)],
        &[(0b10010, &ENTRY_VITRIOLIZES_12629386703569894013)],
        &[(0b10010, &ENTRY_VITRIOLIZING_9645904006126235201)],
        &[(0b01001, &ENTRY_VITRIOLIZABLE_10128808547473444732)],
        &[(0b01001, &ENTRY_VITRIOLIZABLES_6495066641769157690)],
        &[(0b01001, &ENTRY_VITRIOLIZATION_12177216141601047223)],
        &[(0b01001, &ENTRY_VITRIOLIZATIONS_12059310110149895869)],
        &[(0b01001, &ENTRY_VITRIOLIZE_16677616817185174970)],
        &[(0b01001, &ENTRY_VITRIOLIZED_726289364433095774)],
        &[(0b01001, &ENTRY_VITRIOLIZER_1822506942241343764)],
        &[(0b01001, &ENTRY_VITRIOLIZERS_1786300307817004832)],
        &[(0b01001, &ENTRY_VITRIOLIZES_12629386703569894013)],
        &[(0b01001, &ENTRY_VITRIOLIZING_9645904006126235201)],
    ],
    range: 5..=12,
};

static VARS_VIS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VIS_CHILDREN),
    value: None,
};

pub static VARS_VIS_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ard"),
        dictgen::InsensitiveStr::Ascii("ards"),
        dictgen::InsensitiveStr::Ascii("ied"),
        dictgen::InsensitiveStr::Ascii("ies"),
        dictgen::InsensitiveStr::Ascii("ionise"),
        dictgen::InsensitiveStr::Ascii("ionises"),
        dictgen::InsensitiveStr::Ascii("ionize"),
        dictgen::InsensitiveStr::Ascii("ionizes"),
        dictgen::InsensitiveStr::Ascii("ualisable"),
        dictgen::InsensitiveStr::Ascii("ualisation"),
        dictgen::InsensitiveStr::Ascii("ualisations"),
        dictgen::InsensitiveStr::Ascii("ualise"),
        dictgen::InsensitiveStr::Ascii("ualised"),
        dictgen::InsensitiveStr::Ascii("ualiser"),
        dictgen::InsensitiveStr::Ascii("ualisers"),
        dictgen::InsensitiveStr::Ascii("ualises"),
        dictgen::InsensitiveStr::Ascii("ualising"),
        dictgen::InsensitiveStr::Ascii("ualizable"),
        dictgen::InsensitiveStr::Ascii("ualization"),
        dictgen::InsensitiveStr::Ascii("ualizations"),
        dictgen::InsensitiveStr::Ascii("ualize"),
        dictgen::InsensitiveStr::Ascii("ualized"),
        dictgen::InsensitiveStr::Ascii("ualizer"),
        dictgen::InsensitiveStr::Ascii("ualizers"),
        dictgen::InsensitiveStr::Ascii("ualizes"),
        dictgen::InsensitiveStr::Ascii("ualizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VIZARD_10999789749375739354)],
        &[(0b10010, &ENTRY_VIZARDS_6967258731291371717)],
        &[(0b10010, &ENTRY_VIZIED_7049215544631748789)],
        &[(0b10010, &ENTRY_VIZIES_2932586557445870650)],
        &[(0b10010, &ENTRY_VISIONIZE_3799273824415270214)],
        &[(0b10010, &ENTRY_VISIONIZES_18286863748296097590)],
        &[(0b01001, &ENTRY_VISIONIZE_3799273824415270214)],
        &[(0b01001, &ENTRY_VISIONIZES_18286863748296097590)],
        &[(0b10010, &ENTRY_VISUALIZABLE_7962038464582692957)],
        &[(0b10010, &ENTRY_VISUALIZATION_18445006641756380637)],
        &[(0b10010, &ENTRY_VISUALIZATIONS_14330999670741801492)],
        &[(0b10010, &ENTRY_VISUALIZE_14218254075459395624)],
        &[(0b10010, &ENTRY_VISUALIZED_4913836830057768977)],
        &[(0b10010, &ENTRY_VISUALIZER_6771531166983832662)],
        &[(0b10010, &ENTRY_VISUALIZERS_5162859868708280179)],
        &[(0b10010, &ENTRY_VISUALIZES_1129887224614498129)],
        &[(0b10010, &ENTRY_VISUALIZING_8411182104988658747)],
        &[(0b01001, &ENTRY_VISUALIZABLE_7962038464582692957)],
        &[(0b01001, &ENTRY_VISUALIZATION_18445006641756380637)],
        &[(0b01001, &ENTRY_VISUALIZATIONS_14330999670741801492)],
        &[(0b01001, &ENTRY_VISUALIZE_14218254075459395624)],
        &[(0b01001, &ENTRY_VISUALIZED_4913836830057768977)],
        &[(0b01001, &ENTRY_VISUALIZER_6771531166983832662)],
        &[(0b01001, &ENTRY_VISUALIZERS_5162859868708280179)],
        &[(0b01001, &ENTRY_VISUALIZES_1129887224614498129)],
        &[(0b01001, &ENTRY_VISUALIZING_8411182104988658747)],
    ],
    range: 3..=11,
};

static VARS_VIR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VIR_CHILDREN),
    value: None,
};

pub static VARS_VIR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aemia"),
        dictgen::InsensitiveStr::Ascii("aemias"),
        dictgen::InsensitiveStr::Ascii("aemic"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("emia"),
        dictgen::InsensitiveStr::Ascii("emias"),
        dictgen::InsensitiveStr::Ascii("emic"),
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("ilisation"),
        dictgen::InsensitiveStr::Ascii("ilisations"),
        dictgen::InsensitiveStr::Ascii("ilised"),
        dictgen::InsensitiveStr::Ascii("ilising"),
        dictgen::InsensitiveStr::Ascii("ilization"),
        dictgen::InsensitiveStr::Ascii("ilizations"),
        dictgen::InsensitiveStr::Ascii("ilized"),
        dictgen::InsensitiveStr::Ascii("ilizing"),
        dictgen::InsensitiveStr::Ascii("tualisation"),
        dictgen::InsensitiveStr::Ascii("tualise"),
        dictgen::InsensitiveStr::Ascii("tualises"),
        dictgen::InsensitiveStr::Ascii("tualization"),
        dictgen::InsensitiveStr::Ascii("tualize"),
        dictgen::InsensitiveStr::Ascii("tualizes"),
        dictgen::InsensitiveStr::Ascii("tuosoes"),
    ],
    values: &[
        &[(0b11010, &ENTRY_VIREMIA_1841488076881209053)],
        &[(0b11010, &ENTRY_VIREMIAS_7267662670115422503)],
        &[(0b11010, &ENTRY_VIREMIC_6601391614385695738)],
        &[(0b11010, &ENTRY_VIER_10758602254813181277)],
        &[(0b00001, &ENTRY_VIREMIA_1841488076881209053)],
        &[(0b00001, &ENTRY_VIREMIAS_7267662670115422503)],
        &[(0b00001, &ENTRY_VIREMIC_6601391614385695738)],
        &[(0b11010, &ENTRY_VIERS_10473285009744197700)],
        &[(0b10010, &ENTRY_VIRILIZATION_17984148691371003559)],
        &[(0b10010, &ENTRY_VIRILIZATIONS_2259339284050725137)],
        &[(0b10010, &ENTRY_VIRILIZED_14042124459396072676)],
        &[(0b10010, &ENTRY_VIRILIZING_3864311870427123549)],
        &[(0b01001, &ENTRY_VIRILIZATION_17984148691371003559)],
        &[(0b01001, &ENTRY_VIRILIZATIONS_2259339284050725137)],
        &[(0b01001, &ENTRY_VIRILIZED_14042124459396072676)],
        &[(0b01001, &ENTRY_VIRILIZING_3864311870427123549)],
        &[(0b11010, &ENTRY_VIRTUALIZATION_8096145334874168940)],
        &[(0b10010, &ENTRY_VIRTUALIZE_5037242355249715652)],
        &[(0b10010, &ENTRY_VIRTUALIZES_1664114726545811102)],
        &[(0b00001, &ENTRY_VIRTUALIZATION_8096145334874168940)],
        &[(0b01001, &ENTRY_VIRTUALIZE_5037242355249715652)],
        &[(0b01001, &ENTRY_VIRTUALIZES_1664114726545811102)],
        &[(0b00001, &ENTRY_VIRTUOSI_6032024204705561293)],
    ],
    range: 1..=11,
};

static VARS_VIL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VIL_CHILDREN),
    value: None,
};

pub static VARS_VIL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lagisation"),
        dictgen::InsensitiveStr::Ascii("lagisations"),
        dictgen::InsensitiveStr::Ascii("lagization"),
        dictgen::InsensitiveStr::Ascii("lagizations"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VILLAGIZATION_3904516988221777458)],
        &[(0b10010, &ENTRY_VILLAGIZATIONS_11494631120078954743)],
        &[(0b01001, &ENTRY_VILLAGIZATION_3904516988221777458)],
        &[(0b01001, &ENTRY_VILLAGIZATIONS_11494631120078954743)],
    ],
    range: 10..=11,
};

static VARS_VIG_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VIG_CHILDREN),
    value: None,
};

pub static VARS_VIG_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("or"),
        dictgen::InsensitiveStr::Ascii("orless"),
        dictgen::InsensitiveStr::Ascii("ors"),
        dictgen::InsensitiveStr::Ascii("our"),
        dictgen::InsensitiveStr::Ascii("ourless"),
        dictgen::InsensitiveStr::Ascii("ours"),
    ],
    values: &[
        &[(0b11001, &ENTRY_VIGOR_4255508283031723378)],
        &[(0b00001, &ENTRY_VIGORLESS_8298894391042086723)],
        &[(0b11001, &ENTRY_VIGORS_7078003063773531029)],
        &[(0b11010, &ENTRY_VIGOR_4255508283031723378)],
        &[(0b11010, &ENTRY_VIGORLESS_8298894391042086723)],
        &[(0b11010, &ENTRY_VIGORS_7078003063773531029)],
    ],
    range: 2..=7,
};

static VARS_VIE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VIE_CHILDREN),
    value: None,
};

pub static VARS_VIE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("r"),
        dictgen::InsensitiveStr::Ascii("rs"),
        dictgen::InsensitiveStr::Ascii("tnamisation"),
        dictgen::InsensitiveStr::Ascii("tnamise"),
        dictgen::InsensitiveStr::Ascii("tnamised"),
        dictgen::InsensitiveStr::Ascii("tnamises"),
        dictgen::InsensitiveStr::Ascii("tnamising"),
        dictgen::InsensitiveStr::Ascii("tnamization"),
        dictgen::InsensitiveStr::Ascii("tnamize"),
        dictgen::InsensitiveStr::Ascii("tnamized"),
        dictgen::InsensitiveStr::Ascii("tnamizes"),
        dictgen::InsensitiveStr::Ascii("tnamizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_VIER_10758602254813181277)],
        &[(0b00001, &ENTRY_VIERS_10473285009744197700)],
        &[(0b10010, &ENTRY_VIETNAMIZATION_4722543635437789217)],
        &[(0b10010, &ENTRY_VIETNAMIZE_14928666003292211538)],
        &[(0b10010, &ENTRY_VIETNAMIZED_4541312385379938819)],
        &[(0b10010, &ENTRY_VIETNAMIZES_8386876976890033192)],
        &[(0b10010, &ENTRY_VIETNAMIZING_9657833441293397796)],
        &[(0b01001, &ENTRY_VIETNAMIZATION_4722543635437789217)],
        &[(0b01001, &ENTRY_VIETNAMIZE_14928666003292211538)],
        &[(0b01001, &ENTRY_VIETNAMIZED_4541312385379938819)],
        &[(0b01001, &ENTRY_VIETNAMIZES_8386876976890033192)],
        &[(0b01001, &ENTRY_VIETNAMIZING_9657833441293397796)],
    ],
    range: 1..=11,
};

static VARS_VID_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VID_CHILDREN),
    value: None,
};

pub static VARS_VID_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eodisk"),
        dictgen::InsensitiveStr::Ascii("eodisks"),
    ],
    values: &[
        &[(0b00001, &ENTRY_VIDEODISC_4085471265875741194)],
        &[(0b00001, &ENTRY_VIDEODISCS_8893076495672262384)],
    ],
    range: 6..=7,
};

static VARS_VIC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VIC_CHILDREN),
    value: None,
};

pub static VARS_VIC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("timisable"),
        dictgen::InsensitiveStr::Ascii("timisables"),
        dictgen::InsensitiveStr::Ascii("timisation"),
        dictgen::InsensitiveStr::Ascii("timisations"),
        dictgen::InsensitiveStr::Ascii("timise"),
        dictgen::InsensitiveStr::Ascii("timised"),
        dictgen::InsensitiveStr::Ascii("timiser"),
        dictgen::InsensitiveStr::Ascii("timisers"),
        dictgen::InsensitiveStr::Ascii("timises"),
        dictgen::InsensitiveStr::Ascii("timising"),
        dictgen::InsensitiveStr::Ascii("timizable"),
        dictgen::InsensitiveStr::Ascii("timizables"),
        dictgen::InsensitiveStr::Ascii("timization"),
        dictgen::InsensitiveStr::Ascii("timizations"),
        dictgen::InsensitiveStr::Ascii("timize"),
        dictgen::InsensitiveStr::Ascii("timized"),
        dictgen::InsensitiveStr::Ascii("timizer"),
        dictgen::InsensitiveStr::Ascii("timizers"),
        dictgen::InsensitiveStr::Ascii("timizes"),
        dictgen::InsensitiveStr::Ascii("timizing"),
        dictgen::InsensitiveStr::Ascii("torianise"),
        dictgen::InsensitiveStr::Ascii("torianises"),
        dictgen::InsensitiveStr::Ascii("torianize"),
        dictgen::InsensitiveStr::Ascii("torianizes"),
        dictgen::InsensitiveStr::Ascii("tualage"),
        dictgen::InsensitiveStr::Ascii("tualages"),
        dictgen::InsensitiveStr::Ascii("tualed"),
        dictgen::InsensitiveStr::Ascii("tualer"),
        dictgen::InsensitiveStr::Ascii("tualers"),
        dictgen::InsensitiveStr::Ascii("tualess"),
        dictgen::InsensitiveStr::Ascii("tualing"),
        dictgen::InsensitiveStr::Ascii("tuallage"),
        dictgen::InsensitiveStr::Ascii("tuallages"),
        dictgen::InsensitiveStr::Ascii("tualled"),
        dictgen::InsensitiveStr::Ascii("tualler"),
        dictgen::InsensitiveStr::Ascii("tuallers"),
        dictgen::InsensitiveStr::Ascii("tualless"),
        dictgen::InsensitiveStr::Ascii("tualling"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VICTIMIZABLE_17859456941815780193)],
        &[(0b10010, &ENTRY_VICTIMIZABLES_1207522680409246759)],
        &[(0b10010, &ENTRY_VICTIMIZATION_13826269504308493839)],
        &[(0b10010, &ENTRY_VICTIMIZATIONS_14899906545794033733)],
        &[(0b10010, &ENTRY_VICTIMIZE_14299551425382354965)],
        &[(0b10010, &ENTRY_VICTIMIZED_12606813743201188153)],
        &[(0b10010, &ENTRY_VICTIMIZER_13906638213650914285)],
        &[(0b10010, &ENTRY_VICTIMIZERS_13260960052208526566)],
        &[(0b10010, &ENTRY_VICTIMIZES_7043365108562081976)],
        &[(0b10010, &ENTRY_VICTIMIZING_2146280365921517894)],
        &[(0b01001, &ENTRY_VICTIMIZABLE_17859456941815780193)],
        &[(0b01001, &ENTRY_VICTIMIZABLES_1207522680409246759)],
        &[(0b01001, &ENTRY_VICTIMIZATION_13826269504308493839)],
        &[(0b01001, &ENTRY_VICTIMIZATIONS_14899906545794033733)],
        &[(0b01001, &ENTRY_VICTIMIZE_14299551425382354965)],
        &[(0b01001, &ENTRY_VICTIMIZED_12606813743201188153)],
        &[(0b01001, &ENTRY_VICTIMIZER_13906638213650914285)],
        &[(0b01001, &ENTRY_VICTIMIZERS_13260960052208526566)],
        &[(0b01001, &ENTRY_VICTIMIZES_7043365108562081976)],
        &[(0b01001, &ENTRY_VICTIMIZING_2146280365921517894)],
        &[(0b10010, &ENTRY_VICTORIANIZE_6350658122976337243)],
        &[(0b10010, &ENTRY_VICTORIANIZES_10077169725694243555)],
        &[(0b01001, &ENTRY_VICTORIANIZE_6350658122976337243)],
        &[(0b01001, &ENTRY_VICTORIANIZES_10077169725694243555)],
        &[(0b00001, &ENTRY_VICTUALAGE_11748837061098354479)],
        &[(0b00001, &ENTRY_VICTUALAGES_1602498729217236921)],
        &[(0b00001, &ENTRY_VICTUALED_3906018588064117729)],
        &[(0b00001, &ENTRY_VICTUALER_6754560860965136910)],
        &[(0b00001, &ENTRY_VICTUALERS_3647699329720955367)],
        &[(0b00001, &ENTRY_VICTUALESS_4554391893102998851)],
        &[(0b00001, &ENTRY_VICTUALING_14956768953788562589)],
        &[(0b11010, &ENTRY_VICTUALAGE_11748837061098354479)],
        &[(0b11010, &ENTRY_VICTUALAGES_1602498729217236921)],
        &[(0b11010, &ENTRY_VICTUALED_3906018588064117729)],
        &[(0b11010, &ENTRY_VICTUALER_6754560860965136910)],
        &[(0b11010, &ENTRY_VICTUALERS_3647699329720955367)],
        &[(0b11010, &ENTRY_VICTUALESS_4554391893102998851)],
        &[(0b11010, &ENTRY_VICTUALING_14956768953788562589)],
    ],
    range: 6..=11,
};

static VARS_VIA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VIA_CHILDREN),
    value: None,
};

pub static VARS_VIA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("led"),
        dictgen::InsensitiveStr::Ascii("ling"),
        dictgen::InsensitiveStr::Ascii("lled"),
        dictgen::InsensitiveStr::Ascii("lling"),
    ],
    values: &[
        &[(0b00001, &ENTRY_VIALED_9232052728666801517)],
        &[(0b00001, &ENTRY_VIALING_4586545000054977864)],
        &[(0b11010, &ENTRY_VIALED_9232052728666801517)],
        &[(0b11010, &ENTRY_VIALING_4586545000054977864)],
    ],
    range: 3..=5,
};

static VARS_VE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_VE_CHILDREN),
    value: Some(&[(0b00001, &ENTRY_VE_18321759983148480762)]),
};

static VARS_VE_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    Some(&VARS_VEC_NODE),
    None,
    Some(&VARS_VEE_NODE),
    None,
    Some(&VARS_VEG_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_VEL_NODE),
    None,
    Some(&VARS_VEN_NODE),
    None,
    None,
    None,
    Some(&VARS_VER_NODE),
    Some(&VARS_VES_NODE),
    Some(&VARS_VET_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_VET_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VET_CHILDREN),
    value: None,
};

pub static VARS_VET_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("eranise"),
        dictgen::InsensitiveStr::Ascii("eranises"),
        dictgen::InsensitiveStr::Ascii("eranize"),
        dictgen::InsensitiveStr::Ascii("eranizes"),
        dictgen::InsensitiveStr::Ascii("oer"),
    ],
    values: &[
        &[(0b00001, &ENTRY_VETER_13843276293183836593)],
        &[(0b10010, &ENTRY_VETERANIZE_9438252469704632209)],
        &[(0b10010, &ENTRY_VETERANIZES_11256585660882985870)],
        &[(0b01001, &ENTRY_VETERANIZE_9438252469704632209)],
        &[(0b01001, &ENTRY_VETERANIZES_11256585660882985870)],
        &[(0b11010, &ENTRY_VETER_13843276293183836593)],
    ],
    range: 2..=8,
};

static VARS_VES_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VES_CHILDREN),
    value: None,
};

pub static VARS_VES_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("iculae"),
        dictgen::InsensitiveStr::Ascii("icule"),
        dictgen::InsensitiveStr::Ascii("tryise"),
        dictgen::InsensitiveStr::Ascii("tryises"),
        dictgen::InsensitiveStr::Ascii("tryize"),
        dictgen::InsensitiveStr::Ascii("tryizes"),
    ],
    values: &[
        &[(0b11010, &ENTRY_VESICULE_13319860871922937249)],
        &[(0b00001, &ENTRY_VESICULE_13319860871922937249)],
        &[(0b10010, &ENTRY_VESTRYIZE_2427050586639943215)],
        &[(0b10010, &ENTRY_VESTRYIZES_2842047993646822066)],
        &[(0b01001, &ENTRY_VESTRYIZE_2427050586639943215)],
        &[(0b01001, &ENTRY_VESTRYIZES_2842047993646822066)],
    ],
    range: 5..=7,
};

static VARS_VER_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VER_CHILDREN),
    value: None,
};

pub static VARS_VER_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("balisation"),
        dictgen::InsensitiveStr::Ascii("balisations"),
        dictgen::InsensitiveStr::Ascii("balise"),
        dictgen::InsensitiveStr::Ascii("balised"),
        dictgen::InsensitiveStr::Ascii("baliser"),
        dictgen::InsensitiveStr::Ascii("balisers"),
        dictgen::InsensitiveStr::Ascii("balises"),
        dictgen::InsensitiveStr::Ascii("balising"),
        dictgen::InsensitiveStr::Ascii("balization"),
        dictgen::InsensitiveStr::Ascii("balizations"),
        dictgen::InsensitiveStr::Ascii("balize"),
        dictgen::InsensitiveStr::Ascii("balized"),
        dictgen::InsensitiveStr::Ascii("balizer"),
        dictgen::InsensitiveStr::Ascii("balizers"),
        dictgen::InsensitiveStr::Ascii("balizes"),
        dictgen::InsensitiveStr::Ascii("balizing"),
        dictgen::InsensitiveStr::Ascii("ey"),
        dictgen::InsensitiveStr::Ascii("meiled"),
        dictgen::InsensitiveStr::Ascii("meiles"),
        dictgen::InsensitiveStr::Ascii("meiling"),
        dictgen::InsensitiveStr::Ascii("meilled"),
        dictgen::InsensitiveStr::Ascii("meilles"),
        dictgen::InsensitiveStr::Ascii("meilling"),
        dictgen::InsensitiveStr::Ascii("milionise"),
        dictgen::InsensitiveStr::Ascii("milionises"),
        dictgen::InsensitiveStr::Ascii("milionize"),
        dictgen::InsensitiveStr::Ascii("milionizes"),
        dictgen::InsensitiveStr::Ascii("nacularisation"),
        dictgen::InsensitiveStr::Ascii("nacularisations"),
        dictgen::InsensitiveStr::Ascii("nacularise"),
        dictgen::InsensitiveStr::Ascii("nacularised"),
        dictgen::InsensitiveStr::Ascii("nacularises"),
        dictgen::InsensitiveStr::Ascii("nacularising"),
        dictgen::InsensitiveStr::Ascii("nacularization"),
        dictgen::InsensitiveStr::Ascii("nacularizations"),
        dictgen::InsensitiveStr::Ascii("nacularize"),
        dictgen::InsensitiveStr::Ascii("nacularized"),
        dictgen::InsensitiveStr::Ascii("nacularizes"),
        dictgen::InsensitiveStr::Ascii("nacularizing"),
        dictgen::InsensitiveStr::Ascii("nalisation"),
        dictgen::InsensitiveStr::Ascii("nalisations"),
        dictgen::InsensitiveStr::Ascii("nalise"),
        dictgen::InsensitiveStr::Ascii("nalised"),
        dictgen::InsensitiveStr::Ascii("nalises"),
        dictgen::InsensitiveStr::Ascii("nalising"),
        dictgen::InsensitiveStr::Ascii("nalization"),
        dictgen::InsensitiveStr::Ascii("nalizations"),
        dictgen::InsensitiveStr::Ascii("nalize"),
        dictgen::InsensitiveStr::Ascii("nalized"),
        dictgen::InsensitiveStr::Ascii("nalizes"),
        dictgen::InsensitiveStr::Ascii("nalizing"),
        dictgen::InsensitiveStr::Ascii("sicolor"),
        dictgen::InsensitiveStr::Ascii("sicolorate"),
        dictgen::InsensitiveStr::Ascii("sicolored"),
        dictgen::InsensitiveStr::Ascii("sicolorous"),
        dictgen::InsensitiveStr::Ascii("sicolour"),
        dictgen::InsensitiveStr::Ascii("sicolourate"),
        dictgen::InsensitiveStr::Ascii("sicoloured"),
        dictgen::InsensitiveStr::Ascii("sicolourous"),
        dictgen::InsensitiveStr::Ascii("sionise"),
        dictgen::InsensitiveStr::Ascii("sionises"),
        dictgen::InsensitiveStr::Ascii("sionize"),
        dictgen::InsensitiveStr::Ascii("sionizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VERBALIZATION_1606887602703040047)],
        &[(0b10010, &ENTRY_VERBALIZATIONS_10614435035631184613)],
        &[(0b10010, &ENTRY_VERBALIZE_8914927163486915483)],
        &[(0b10010, &ENTRY_VERBALIZED_3584116992871405343)],
        &[(0b10010, &ENTRY_VERBALIZER_5476531062608223227)],
        &[(0b10010, &ENTRY_VERBALIZERS_13686674633988019779)],
        &[(0b10010, &ENTRY_VERBALIZES_9773922676702933955)],
        &[(0b10010, &ENTRY_VERBALIZING_4674155461307593201)],
        &[(0b01001, &ENTRY_VERBALIZATION_1606887602703040047)],
        &[(0b01001, &ENTRY_VERBALIZATIONS_10614435035631184613)],
        &[(0b01001, &ENTRY_VERBALIZE_8914927163486915483)],
        &[(0b01001, &ENTRY_VERBALIZED_3584116992871405343)],
        &[(0b01001, &ENTRY_VERBALIZER_5476531062608223227)],
        &[(0b01001, &ENTRY_VERBALIZERS_13686674633988019779)],
        &[(0b01001, &ENTRY_VERBALIZES_9773922676702933955)],
        &[(0b01001, &ENTRY_VERBALIZING_4674155461307593201)],
        &[(0b11010, &ENTRY_VEERY_7871806231150043123)],
        &[(0b00001, &ENTRY_VERMEILED_3870685009631656496)],
        &[(0b00001, &ENTRY_VERMEILES_6091101275731102631)],
        &[(0b00001, &ENTRY_VERMEILING_16263718376783682636)],
        &[(0b11010, &ENTRY_VERMEILED_3870685009631656496)],
        &[(0b11010, &ENTRY_VERMEILES_6091101275731102631)],
        &[(0b11010, &ENTRY_VERMEILING_16263718376783682636)],
        &[(0b10010, &ENTRY_VERMILIONIZE_1285328019998267214)],
        &[(0b10010, &ENTRY_VERMILIONIZES_12599262771675475462)],
        &[(0b01001, &ENTRY_VERMILIONIZE_1285328019998267214)],
        &[(0b01001, &ENTRY_VERMILIONIZES_12599262771675475462)],
        &[(0b10010, &ENTRY_VERNACULARIZATION_8027917640062920182)],
        &[(0b10010, &ENTRY_VERNACULARIZATIONS_14415525320546941498)],
        &[(0b10010, &ENTRY_VERNACULARIZE_12667767946887279081)],
        &[(0b10010, &ENTRY_VERNACULARIZED_12492141793786233950)],
        &[(0b10010, &ENTRY_VERNACULARIZES_15960776775823268746)],
        &[(0b10010, &ENTRY_VERNACULARIZING_10081295290347631824)],
        &[(0b01001, &ENTRY_VERNACULARIZATION_8027917640062920182)],
        &[(0b01001, &ENTRY_VERNACULARIZATIONS_14415525320546941498)],
        &[(0b01001, &ENTRY_VERNACULARIZE_12667767946887279081)],
        &[(0b01001, &ENTRY_VERNACULARIZED_12492141793786233950)],
        &[(0b01001, &ENTRY_VERNACULARIZES_15960776775823268746)],
        &[(0b01001, &ENTRY_VERNACULARIZING_10081295290347631824)],
        &[(0b10010, &ENTRY_VERNALIZATION_11355184477337865623)],
        &[(0b10010, &ENTRY_VERNALIZATIONS_4660850075716999699)],
        &[(0b10010, &ENTRY_VERNALIZE_12962724599289195261)],
        &[(0b10010, &ENTRY_VERNALIZED_10973377624262151914)],
        &[(0b10010, &ENTRY_VERNALIZES_5256099709798243477)],
        &[(0b10010, &ENTRY_VERNALIZING_10128158728667959931)],
        &[(0b01001, &ENTRY_VERNALIZATION_11355184477337865623)],
        &[(0b01001, &ENTRY_VERNALIZATIONS_4660850075716999699)],
        &[(0b01001, &ENTRY_VERNALIZE_12962724599289195261)],
        &[(0b01001, &ENTRY_VERNALIZED_10973377624262151914)],
        &[(0b01001, &ENTRY_VERNALIZES_5256099709798243477)],
        &[(0b01001, &ENTRY_VERNALIZING_10128158728667959931)],
        &[(0b00001, &ENTRY_VERSICOLOR_1583338907759165683)],
        &[(0b00001, &ENTRY_VERSICOLORATE_1213108598258359303)],
        &[(0b00001, &ENTRY_VERSICOLORED_8698649720277268404)],
        &[(0b00001, &ENTRY_VERSICOLOROUS_17729000221904743199)],
        &[(0b11010, &ENTRY_VERSICOLOR_1583338907759165683)],
        &[(0b11010, &ENTRY_VERSICOLORATE_1213108598258359303)],
        &[(0b11010, &ENTRY_VERSICOLORED_8698649720277268404)],
        &[(0b11010, &ENTRY_VERSICOLOROUS_17729000221904743199)],
        &[(0b10010, &ENTRY_VERSIONIZE_13036102572385152608)],
        &[(0b10010, &ENTRY_VERSIONIZES_14825603837161816590)],
        &[(0b01001, &ENTRY_VERSIONIZE_13036102572385152608)],
        &[(0b01001, &ENTRY_VERSIONIZES_14825603837161816590)],
    ],
    range: 2..=15,
};

static VARS_VEN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VEN_CHILDREN),
    value: None,
};

pub static VARS_VEN_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alisation"),
        dictgen::InsensitiveStr::Ascii("alisations"),
        dictgen::InsensitiveStr::Ascii("alise"),
        dictgen::InsensitiveStr::Ascii("alises"),
        dictgen::InsensitiveStr::Ascii("alization"),
        dictgen::InsensitiveStr::Ascii("alizations"),
        dictgen::InsensitiveStr::Ascii("alize"),
        dictgen::InsensitiveStr::Ascii("alizes"),
        dictgen::InsensitiveStr::Ascii("der"),
        dictgen::InsensitiveStr::Ascii("ders"),
        dictgen::InsensitiveStr::Ascii("omisation"),
        dictgen::InsensitiveStr::Ascii("omisations"),
        dictgen::InsensitiveStr::Ascii("omise"),
        dictgen::InsensitiveStr::Ascii("omises"),
        dictgen::InsensitiveStr::Ascii("omization"),
        dictgen::InsensitiveStr::Ascii("omizations"),
        dictgen::InsensitiveStr::Ascii("omize"),
        dictgen::InsensitiveStr::Ascii("omizes"),
        dictgen::InsensitiveStr::Ascii("ter"),
        dictgen::InsensitiveStr::Ascii("ters"),
        dictgen::InsensitiveStr::Ascii("tre"),
        dictgen::InsensitiveStr::Ascii("tres"),
        dictgen::InsensitiveStr::Ascii("triloquise"),
        dictgen::InsensitiveStr::Ascii("triloquised"),
        dictgen::InsensitiveStr::Ascii("triloquises"),
        dictgen::InsensitiveStr::Ascii("triloquising"),
        dictgen::InsensitiveStr::Ascii("triloquize"),
        dictgen::InsensitiveStr::Ascii("triloquized"),
        dictgen::InsensitiveStr::Ascii("triloquizes"),
        dictgen::InsensitiveStr::Ascii("triloquizing"),
        dictgen::InsensitiveStr::Ascii("ulae"),
        dictgen::InsensitiveStr::Ascii("ule"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VENALIZATION_2122570152538799298)],
        &[(0b10010, &ENTRY_VENALIZATIONS_2118690871234046077)],
        &[(0b10010, &ENTRY_VENALIZE_17116259915286472347)],
        &[(0b10010, &ENTRY_VENALIZES_17850293216838309236)],
        &[(0b01001, &ENTRY_VENALIZATION_2122570152538799298)],
        &[(0b01001, &ENTRY_VENALIZATIONS_2118690871234046077)],
        &[(0b01001, &ENTRY_VENALIZE_17116259915286472347)],
        &[(0b01001, &ENTRY_VENALIZES_17850293216838309236)],
        &[(0b00001, &ENTRY_VENDOR_2662061828917411576)],
        &[(0b00001, &ENTRY_VENDORS_995846644620124863)],
        &[(0b10010, &ENTRY_VENOMIZATION_15358943620485615148)],
        &[(0b10010, &ENTRY_VENOMIZATIONS_15701983704376518542)],
        &[(0b10010, &ENTRY_VENOMIZE_18257057476761108930)],
        &[(0b10010, &ENTRY_VENOMIZES_16197925629249240457)],
        &[(0b01001, &ENTRY_VENOMIZATION_15358943620485615148)],
        &[(0b01001, &ENTRY_VENOMIZATIONS_15701983704376518542)],
        &[(0b01001, &ENTRY_VENOMIZE_18257057476761108930)],
        &[(0b01001, &ENTRY_VENOMIZES_16197925629249240457)],
        &[(0b00001, &ENTRY_VENTER_10510516635110887923)],
        &[(0b00001, &ENTRY_VENTERS_5205786364593283296)],
        &[(0b11010, &ENTRY_VENTER_10510516635110887923)],
        &[(0b11010, &ENTRY_VENTERS_5205786364593283296)],
        &[(0b10010, &ENTRY_VENTRILOQUIZE_7278912386074535832)],
        &[(0b10010, &ENTRY_VENTRILOQUIZED_17464849051904807365)],
        &[(0b10010, &ENTRY_VENTRILOQUIZES_7366719022132000191)],
        &[(0b10010, &ENTRY_VENTRILOQUIZING_16373058130648158850)],
        &[(0b01001, &ENTRY_VENTRILOQUIZE_7278912386074535832)],
        &[(0b01001, &ENTRY_VENTRILOQUIZED_17464849051904807365)],
        &[(0b01001, &ENTRY_VENTRILOQUIZES_7366719022132000191)],
        &[(0b01001, &ENTRY_VENTRILOQUIZING_16373058130648158850)],
        &[(0b11010, &ENTRY_VENULE_16081436179391149786)],
        &[(0b00001, &ENTRY_VENULE_16081436179391149786)],
    ],
    range: 3..=12,
};

static VARS_VEL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VEL_CHILDREN),
    value: None,
};

pub static VARS_VEL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arisation"),
        dictgen::InsensitiveStr::Ascii("arisations"),
        dictgen::InsensitiveStr::Ascii("arise"),
        dictgen::InsensitiveStr::Ascii("arised"),
        dictgen::InsensitiveStr::Ascii("arises"),
        dictgen::InsensitiveStr::Ascii("arising"),
        dictgen::InsensitiveStr::Ascii("arization"),
        dictgen::InsensitiveStr::Ascii("arizations"),
        dictgen::InsensitiveStr::Ascii("arize"),
        dictgen::InsensitiveStr::Ascii("arized"),
        dictgen::InsensitiveStr::Ascii("arizes"),
        dictgen::InsensitiveStr::Ascii("arizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VELARIZATION_1403990956820502853)],
        &[(0b10010, &ENTRY_VELARIZATIONS_14651119125598343114)],
        &[(0b10010, &ENTRY_VELARIZE_4143880025810776209)],
        &[(0b10010, &ENTRY_VELARIZED_17587151593626429889)],
        &[(0b10010, &ENTRY_VELARIZES_7541885077312241167)],
        &[(0b10010, &ENTRY_VELARIZING_10043182753015176040)],
        &[(0b01001, &ENTRY_VELARIZATION_1403990956820502853)],
        &[(0b01001, &ENTRY_VELARIZATIONS_14651119125598343114)],
        &[(0b01001, &ENTRY_VELARIZE_4143880025810776209)],
        &[(0b01001, &ENTRY_VELARIZED_17587151593626429889)],
        &[(0b01001, &ENTRY_VELARIZES_7541885077312241167)],
        &[(0b01001, &ENTRY_VELARIZING_10043182753015176040)],
    ],
    range: 5..=10,
};

static VARS_VEG_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VEG_CHILDREN),
    value: None,
};

pub static VARS_VEG_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("etablise"),
        dictgen::InsensitiveStr::Ascii("etablises"),
        dictgen::InsensitiveStr::Ascii("etablize"),
        dictgen::InsensitiveStr::Ascii("etablizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VEGETABLIZE_15652329865549979869)],
        &[(0b10010, &ENTRY_VEGETABLIZES_6567628138079375237)],
        &[(0b01001, &ENTRY_VEGETABLIZE_15652329865549979869)],
        &[(0b01001, &ENTRY_VEGETABLIZES_6567628138079375237)],
    ],
    range: 8..=9,
};

static VARS_VEE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VEE_CHILDREN),
    value: None,
};

pub static VARS_VEE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ry")],
    values: &[&[(0b00001, &ENTRY_VEERY_7871806231150043123)]],
    range: 2..=2,
};

static VARS_VEC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VEC_CHILDREN),
    value: None,
};

pub static VARS_VEC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("torisable"),
        dictgen::InsensitiveStr::Ascii("torisation"),
        dictgen::InsensitiveStr::Ascii("torisations"),
        dictgen::InsensitiveStr::Ascii("torise"),
        dictgen::InsensitiveStr::Ascii("torised"),
        dictgen::InsensitiveStr::Ascii("toriser"),
        dictgen::InsensitiveStr::Ascii("torisered"),
        dictgen::InsensitiveStr::Ascii("torisering"),
        dictgen::InsensitiveStr::Ascii("torisers"),
        dictgen::InsensitiveStr::Ascii("torises"),
        dictgen::InsensitiveStr::Ascii("torising"),
        dictgen::InsensitiveStr::Ascii("torizable"),
        dictgen::InsensitiveStr::Ascii("torization"),
        dictgen::InsensitiveStr::Ascii("torizations"),
        dictgen::InsensitiveStr::Ascii("torize"),
        dictgen::InsensitiveStr::Ascii("torized"),
        dictgen::InsensitiveStr::Ascii("torizer"),
        dictgen::InsensitiveStr::Ascii("torizered"),
        dictgen::InsensitiveStr::Ascii("torizering"),
        dictgen::InsensitiveStr::Ascii("torizers"),
        dictgen::InsensitiveStr::Ascii("torizes"),
        dictgen::InsensitiveStr::Ascii("torizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VECTORIZABLE_4166695678492588499)],
        &[(0b10010, &ENTRY_VECTORIZATION_9106141310054062019)],
        &[(0b10010, &ENTRY_VECTORIZATIONS_465401059387640876)],
        &[(0b10010, &ENTRY_VECTORIZE_13096018160775133343)],
        &[(0b10010, &ENTRY_VECTORIZED_13224707387286509209)],
        &[(0b10010, &ENTRY_VECTORIZER_12091376211856766051)],
        &[(0b10010, &ENTRY_VECTORIZERED_9703684870141080163)],
        &[(0b10010, &ENTRY_VECTORIZERING_15878663610053146444)],
        &[(0b10010, &ENTRY_VECTORIZERS_9835891468155617)],
        &[(0b10010, &ENTRY_VECTORIZES_7917294144821648305)],
        &[(0b10010, &ENTRY_VECTORIZING_9538566325910673128)],
        &[(0b01001, &ENTRY_VECTORIZABLE_4166695678492588499)],
        &[(0b01001, &ENTRY_VECTORIZATION_9106141310054062019)],
        &[(0b01001, &ENTRY_VECTORIZATIONS_465401059387640876)],
        &[(0b01001, &ENTRY_VECTORIZE_13096018160775133343)],
        &[(0b01001, &ENTRY_VECTORIZED_13224707387286509209)],
        &[(0b01001, &ENTRY_VECTORIZER_12091376211856766051)],
        &[(0b01001, &ENTRY_VECTORIZERED_9703684870141080163)],
        &[(0b01001, &ENTRY_VECTORIZERING_15878663610053146444)],
        &[(0b01001, &ENTRY_VECTORIZERS_9835891468155617)],
        &[(0b01001, &ENTRY_VECTORIZES_7917294144821648305)],
        &[(0b01001, &ENTRY_VECTORIZING_9538566325910673128)],
    ],
    range: 6..=11,
};

static VARS_VA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_VA_CHILDREN),
    value: None,
};

static VARS_VA_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_VAA_NODE),
    None,
    Some(&VARS_VAC_NODE),
    None,
    None,
    None,
    Some(&VARS_VAG_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_VAL_NODE),
    Some(&VARS_VAM_NODE),
    Some(&VARS_VAN_NODE),
    None,
    Some(&VARS_VAP_NODE),
    None,
    Some(&VARS_VAR_NODE),
    Some(&VARS_VAS_NODE),
    Some(&VARS_VAT_NODE),
    None,
    Some(&VARS_VAV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_VAV_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VAV_CHILDREN),
    value: None,
};

pub static VARS_VAV_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("asor"),
        dictgen::InsensitiveStr::Ascii("asors"),
        dictgen::InsensitiveStr::Ascii("asour"),
        dictgen::InsensitiveStr::Ascii("asours"),
    ],
    values: &[
        &[(0b00001, &ENTRY_VAVASOR_6555930671551149776)],
        &[(0b00001, &ENTRY_VAVASORS_10746634756989528594)],
        &[(0b11010, &ENTRY_VAVASOR_6555930671551149776)],
        &[(0b11010, &ENTRY_VAVASORS_10746634756989528594)],
    ],
    range: 4..=6,
};

static VARS_VAT_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VAT_CHILDREN),
    value: None,
};

pub static VARS_VAT_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("icanisation"),
        dictgen::InsensitiveStr::Ascii("icanisations"),
        dictgen::InsensitiveStr::Ascii("icanise"),
        dictgen::InsensitiveStr::Ascii("icanises"),
        dictgen::InsensitiveStr::Ascii("icanization"),
        dictgen::InsensitiveStr::Ascii("icanizations"),
        dictgen::InsensitiveStr::Ascii("icanize"),
        dictgen::InsensitiveStr::Ascii("icanizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VATICANIZATION_12565515839826698578)],
        &[(0b10010, &ENTRY_VATICANIZATIONS_15982356743750740824)],
        &[(0b10010, &ENTRY_VATICANIZE_13749277718192631537)],
        &[(0b10010, &ENTRY_VATICANIZES_16071718452803582750)],
        &[(0b01001, &ENTRY_VATICANIZATION_12565515839826698578)],
        &[(0b01001, &ENTRY_VATICANIZATIONS_15982356743750740824)],
        &[(0b01001, &ENTRY_VATICANIZE_13749277718192631537)],
        &[(0b01001, &ENTRY_VATICANIZES_16071718452803582750)],
    ],
    range: 7..=12,
};

static VARS_VAS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VAS_CHILDREN),
    value: None,
};

pub static VARS_VAS_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cularisation"),
        dictgen::InsensitiveStr::Ascii("cularisations"),
        dictgen::InsensitiveStr::Ascii("cularise"),
        dictgen::InsensitiveStr::Ascii("cularised"),
        dictgen::InsensitiveStr::Ascii("cularises"),
        dictgen::InsensitiveStr::Ascii("cularising"),
        dictgen::InsensitiveStr::Ascii("cularization"),
        dictgen::InsensitiveStr::Ascii("cularizations"),
        dictgen::InsensitiveStr::Ascii("cularize"),
        dictgen::InsensitiveStr::Ascii("cularized"),
        dictgen::InsensitiveStr::Ascii("cularizes"),
        dictgen::InsensitiveStr::Ascii("cularizing"),
        dictgen::InsensitiveStr::Ascii("ectomise"),
        dictgen::InsensitiveStr::Ascii("ectomised"),
        dictgen::InsensitiveStr::Ascii("ectomising"),
        dictgen::InsensitiveStr::Ascii("ectomize"),
        dictgen::InsensitiveStr::Ascii("ectomized"),
        dictgen::InsensitiveStr::Ascii("ectomizing"),
        dictgen::InsensitiveStr::Ascii("salisation"),
        dictgen::InsensitiveStr::Ascii("salise"),
        dictgen::InsensitiveStr::Ascii("salised"),
        dictgen::InsensitiveStr::Ascii("salises"),
        dictgen::InsensitiveStr::Ascii("salising"),
        dictgen::InsensitiveStr::Ascii("salization"),
        dictgen::InsensitiveStr::Ascii("salize"),
        dictgen::InsensitiveStr::Ascii("salized"),
        dictgen::InsensitiveStr::Ascii("salizes"),
        dictgen::InsensitiveStr::Ascii("salizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VASCULARIZATION_7798251772115817237)],
        &[(0b10010, &ENTRY_VASCULARIZATIONS_8910282637625326095)],
        &[(0b10010, &ENTRY_VASCULARIZE_5629782517352109818)],
        &[(0b10010, &ENTRY_VASCULARIZED_207387324778454868)],
        &[(0b10010, &ENTRY_VASCULARIZES_8060078253096737319)],
        &[(0b10010, &ENTRY_VASCULARIZING_13278299349432868928)],
        &[(0b01001, &ENTRY_VASCULARIZATION_7798251772115817237)],
        &[(0b01001, &ENTRY_VASCULARIZATIONS_8910282637625326095)],
        &[(0b01001, &ENTRY_VASCULARIZE_5629782517352109818)],
        &[(0b01001, &ENTRY_VASCULARIZED_207387324778454868)],
        &[(0b01001, &ENTRY_VASCULARIZES_8060078253096737319)],
        &[(0b01001, &ENTRY_VASCULARIZING_13278299349432868928)],
        &[(0b10010, &ENTRY_VASECTOMIZE_15454430706811576633)],
        &[(0b10010, &ENTRY_VASECTOMIZED_8925568978830732205)],
        &[(0b10010, &ENTRY_VASECTOMIZING_8116057054186241693)],
        &[(0b01001, &ENTRY_VASECTOMIZE_15454430706811576633)],
        &[(0b01001, &ENTRY_VASECTOMIZED_8925568978830732205)],
        &[(0b01001, &ENTRY_VASECTOMIZING_8116057054186241693)],
        &[(0b10010, &ENTRY_VASSALIZATION_7460874923683642348)],
        &[(0b10010, &ENTRY_VASSALIZE_8451924336001983191)],
        &[(0b10010, &ENTRY_VASSALIZED_10083471569803078316)],
        &[(0b10010, &ENTRY_VASSALIZES_4617029144268849855)],
        &[(0b10010, &ENTRY_VASSALIZING_12622050688866231311)],
        &[(0b01001, &ENTRY_VASSALIZATION_7460874923683642348)],
        &[(0b01001, &ENTRY_VASSALIZE_8451924336001983191)],
        &[(0b01001, &ENTRY_VASSALIZED_10083471569803078316)],
        &[(0b01001, &ENTRY_VASSALIZES_4617029144268849855)],
        &[(0b01001, &ENTRY_VASSALIZING_12622050688866231311)],
    ],
    range: 6..=13,
};

static VARS_VAR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VAR_CHILDREN),
    value: None,
};

pub static VARS_VAR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("icolored"),
        dictgen::InsensitiveStr::Ascii("icoloredder"),
        dictgen::InsensitiveStr::Ascii("icoloreddest"),
        dictgen::InsensitiveStr::Ascii("icoloreds"),
        dictgen::InsensitiveStr::Ascii("icolorous"),
        dictgen::InsensitiveStr::Ascii("icoloured"),
        dictgen::InsensitiveStr::Ascii("icolouredder"),
        dictgen::InsensitiveStr::Ascii("icoloureddest"),
        dictgen::InsensitiveStr::Ascii("icoloureds"),
        dictgen::InsensitiveStr::Ascii("icolourous"),
    ],
    values: &[
        &[(0b01001, &ENTRY_VARICOLORED_1171542226285534602)],
        &[(0b01001, &ENTRY_VARICOLOREDDER_9075851730556261800)],
        &[(0b01001, &ENTRY_VARICOLOREDDEST_1560912123897475014)],
        &[(0b01001, &ENTRY_VARICOLOREDS_5399234029222855053)],
        &[(0b00001, &ENTRY_VARICOLOROUS_2090604475004912852)],
        &[(0b11010, &ENTRY_VARICOLORED_1171542226285534602)],
        &[(0b11010, &ENTRY_VARICOLOREDDER_9075851730556261800)],
        &[(0b11010, &ENTRY_VARICOLOREDDEST_1560912123897475014)],
        &[(0b11010, &ENTRY_VARICOLOREDS_5399234029222855053)],
        &[(0b11010, &ENTRY_VARICOLOROUS_2090604475004912852)],
    ],
    range: 8..=13,
};

static VARS_VAP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_VAP_CHILDREN),
    value: None,
};

static VARS_VAP_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_VAPO_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_VAPO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_VAPO_CHILDREN),
    value: None,
};

static VARS_VAPO_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_VAPOR_NODE),
    None,
    None,
    Some(&VARS_VAPOU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_VAPOU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VAPOU_CHILDREN),
    value: None,
};

pub static VARS_VAPOU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("r"),
        dictgen::InsensitiveStr::Ascii("rabilities"),
        dictgen::InsensitiveStr::Ascii("rability"),
        dictgen::InsensitiveStr::Ascii("rable"),
        dictgen::InsensitiveStr::Ascii("rables"),
        dictgen::InsensitiveStr::Ascii("red"),
        dictgen::InsensitiveStr::Ascii("rer"),
        dictgen::InsensitiveStr::Ascii("rers"),
        dictgen::InsensitiveStr::Ascii("rescent"),
        dictgen::InsensitiveStr::Ascii("rier"),
        dictgen::InsensitiveStr::Ascii("riest"),
        dictgen::InsensitiveStr::Ascii("rific"),
        dictgen::InsensitiveStr::Ascii("rimeter"),
        dictgen::InsensitiveStr::Ascii("ring"),
        dictgen::InsensitiveStr::Ascii("ringly"),
        dictgen::InsensitiveStr::Ascii("rings"),
        dictgen::InsensitiveStr::Ascii("rish"),
        dictgen::InsensitiveStr::Ascii("risher"),
        dictgen::InsensitiveStr::Ascii("rishest"),
        dictgen::InsensitiveStr::Ascii("rishness"),
        dictgen::InsensitiveStr::Ascii("rishnesses"),
        dictgen::InsensitiveStr::Ascii("rless"),
        dictgen::InsensitiveStr::Ascii("rlesses"),
        dictgen::InsensitiveStr::Ascii("rlike"),
        dictgen::InsensitiveStr::Ascii("rlikes"),
        dictgen::InsensitiveStr::Ascii("rose"),
        dictgen::InsensitiveStr::Ascii("rously"),
        dictgen::InsensitiveStr::Ascii("rs"),
        dictgen::InsensitiveStr::Ascii("rware"),
        dictgen::InsensitiveStr::Ascii("ry"),
    ],
    values: &[
        &[(0b11010, &ENTRY_VAPOR_15613919849286651309)],
        &[(0b11010, &ENTRY_VAPORABILITIES_2583412300863683415)],
        &[(0b11010, &ENTRY_VAPORABILITY_11761050574300823550)],
        &[(0b11010, &ENTRY_VAPORABLE_9307386414591158227)],
        &[(0b11010, &ENTRY_VAPORABLES_8806153105556416814)],
        &[(0b11010, &ENTRY_VAPORED_9964696878149356362)],
        &[(0b11010, &ENTRY_VAPORER_1067720005826649650)],
        &[(0b11010, &ENTRY_VAPORERS_9040022998985997095)],
        &[(0b11010, &ENTRY_VAPORESCENT_811521758895005989)],
        &[(0b11010, &ENTRY_VAPORIER_5924457613655889706)],
        &[(0b11010, &ENTRY_VAPORIEST_16771875045269754013)],
        &[(0b11010, &ENTRY_VAPORIFIC_16729671073785623946)],
        &[(0b11010, &ENTRY_VAPORIMETER_12463044510053318843)],
        &[(0b11010, &ENTRY_VAPORING_5632349647366369914)],
        &[(0b11010, &ENTRY_VAPORINGLY_18193996619433734220)],
        &[(0b11010, &ENTRY_VAPORINGS_4745851328181075614)],
        &[(0b11010, &ENTRY_VAPORISH_4151648633909268593)],
        &[(0b11010, &ENTRY_VAPORISHER_7217019342243877633)],
        &[(0b11010, &ENTRY_VAPORISHEST_12551478444608603779)],
        &[(0b11010, &ENTRY_VAPORISHNESS_18298682645615478389)],
        &[(0b11010, &ENTRY_VAPORISHNESSES_3346265753722413365)],
        &[(0b11010, &ENTRY_VAPORLESS_9180001548778190890)],
        &[(0b11010, &ENTRY_VAPORLESSES_9449123748147448331)],
        &[(0b11010, &ENTRY_VAPORLIKE_4304234079758020864)],
        &[(0b11010, &ENTRY_VAPORLIKES_17513958557622792273)],
        &[(0b11010, &ENTRY_VAPOROSE_941229128135609892)],
        &[(0b11010, &ENTRY_VAPOROUSLY_10099688633493703963)],
        &[(0b11010, &ENTRY_VAPORS_9486200942177396366)],
        &[(0b11010, &ENTRY_VAPORWARE_2722248098855884375)],
        &[(0b11010, &ENTRY_VAPORY_5997890858470358305)],
    ],
    range: 1..=10,
};

static VARS_VAPOR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VAPOR_CHILDREN),
    value: Some(&[(0b11001, &ENTRY_VAPOR_15613919849286651309)]),
};

pub static VARS_VAPOR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("abilities"),
        dictgen::InsensitiveStr::Ascii("ability"),
        dictgen::InsensitiveStr::Ascii("able"),
        dictgen::InsensitiveStr::Ascii("ables"),
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("ers"),
        dictgen::InsensitiveStr::Ascii("escent"),
        dictgen::InsensitiveStr::Ascii("ier"),
        dictgen::InsensitiveStr::Ascii("iest"),
        dictgen::InsensitiveStr::Ascii("ific"),
        dictgen::InsensitiveStr::Ascii("imeter"),
        dictgen::InsensitiveStr::Ascii("ing"),
        dictgen::InsensitiveStr::Ascii("ingly"),
        dictgen::InsensitiveStr::Ascii("ings"),
        dictgen::InsensitiveStr::Ascii("isable"),
        dictgen::InsensitiveStr::Ascii("isabler"),
        dictgen::InsensitiveStr::Ascii("isables"),
        dictgen::InsensitiveStr::Ascii("isablest"),
        dictgen::InsensitiveStr::Ascii("isation"),
        dictgen::InsensitiveStr::Ascii("isations"),
        dictgen::InsensitiveStr::Ascii("ise"),
        dictgen::InsensitiveStr::Ascii("ised"),
        dictgen::InsensitiveStr::Ascii("iser"),
        dictgen::InsensitiveStr::Ascii("isers"),
        dictgen::InsensitiveStr::Ascii("ises"),
        dictgen::InsensitiveStr::Ascii("ish"),
        dictgen::InsensitiveStr::Ascii("isher"),
        dictgen::InsensitiveStr::Ascii("ishest"),
        dictgen::InsensitiveStr::Ascii("ishness"),
        dictgen::InsensitiveStr::Ascii("ishnesses"),
        dictgen::InsensitiveStr::Ascii("ising"),
        dictgen::InsensitiveStr::Ascii("izable"),
        dictgen::InsensitiveStr::Ascii("izabler"),
        dictgen::InsensitiveStr::Ascii("izables"),
        dictgen::InsensitiveStr::Ascii("izablest"),
        dictgen::InsensitiveStr::Ascii("ization"),
        dictgen::InsensitiveStr::Ascii("izations"),
        dictgen::InsensitiveStr::Ascii("ize"),
        dictgen::InsensitiveStr::Ascii("ized"),
        dictgen::InsensitiveStr::Ascii("izer"),
        dictgen::InsensitiveStr::Ascii("izers"),
        dictgen::InsensitiveStr::Ascii("izes"),
        dictgen::InsensitiveStr::Ascii("izing"),
        dictgen::InsensitiveStr::Ascii("less"),
        dictgen::InsensitiveStr::Ascii("lesses"),
        dictgen::InsensitiveStr::Ascii("like"),
        dictgen::InsensitiveStr::Ascii("likes"),
        dictgen::InsensitiveStr::Ascii("ose"),
        dictgen::InsensitiveStr::Ascii("ously"),
        dictgen::InsensitiveStr::Ascii("s"),
        dictgen::InsensitiveStr::Ascii("ware"),
        dictgen::InsensitiveStr::Ascii("y"),
    ],
    values: &[
        &[(0b00001, &ENTRY_VAPORABILITIES_2583412300863683415)],
        &[(0b00001, &ENTRY_VAPORABILITY_11761050574300823550)],
        &[(0b00001, &ENTRY_VAPORABLE_9307386414591158227)],
        &[(0b00001, &ENTRY_VAPORABLES_8806153105556416814)],
        &[(0b11001, &ENTRY_VAPORED_9964696878149356362)],
        &[(0b00001, &ENTRY_VAPORER_1067720005826649650)],
        &[(0b00001, &ENTRY_VAPORERS_9040022998985997095)],
        &[(0b00001, &ENTRY_VAPORESCENT_811521758895005989)],
        &[(0b00001, &ENTRY_VAPORIER_5924457613655889706)],
        &[(0b00001, &ENTRY_VAPORIEST_16771875045269754013)],
        &[(0b00001, &ENTRY_VAPORIFIC_16729671073785623946)],
        &[(0b00001, &ENTRY_VAPORIMETER_12463044510053318843)],
        &[(0b11001, &ENTRY_VAPORING_5632349647366369914)],
        &[(0b00001, &ENTRY_VAPORINGLY_18193996619433734220)],
        &[(0b11001, &ENTRY_VAPORINGS_4745851328181075614)],
        &[(0b10010, &ENTRY_VAPORIZABLE_1284750919722519568)],
        &[(0b10010, &ENTRY_VAPORIZABLER_330384219459697531)],
        &[(0b10010, &ENTRY_VAPORIZABLES_8570559686466416467)],
        &[(0b10010, &ENTRY_VAPORIZABLEST_16063759849633059522)],
        &[(0b10010, &ENTRY_VAPORIZATION_6624016776962610799)],
        &[(0b10010, &ENTRY_VAPORIZATIONS_3616017509956798175)],
        &[(0b10010, &ENTRY_VAPORIZE_7074947866923787432)],
        &[(0b10010, &ENTRY_VAPORIZED_4100382952590684636)],
        &[(0b10010, &ENTRY_VAPORIZER_8052635902096901156)],
        &[(0b10010, &ENTRY_VAPORIZERS_9656279687545559604)],
        &[(0b10010, &ENTRY_VAPORIZES_12186280109418449105)],
        &[(0b00001, &ENTRY_VAPORISH_4151648633909268593)],
        &[(0b00001, &ENTRY_VAPORISHER_7217019342243877633)],
        &[(0b00001, &ENTRY_VAPORISHEST_12551478444608603779)],
        &[(0b00001, &ENTRY_VAPORISHNESS_18298682645615478389)],
        &[(0b00001, &ENTRY_VAPORISHNESSES_3346265753722413365)],
        &[(0b10010, &ENTRY_VAPORIZING_11720449073985132085)],
        &[(0b01001, &ENTRY_VAPORIZABLE_1284750919722519568)],
        &[(0b01001, &ENTRY_VAPORIZABLER_330384219459697531)],
        &[(0b01001, &ENTRY_VAPORIZABLES_8570559686466416467)],
        &[(0b01001, &ENTRY_VAPORIZABLEST_16063759849633059522)],
        &[(0b01001, &ENTRY_VAPORIZATION_6624016776962610799)],
        &[(0b01001, &ENTRY_VAPORIZATIONS_3616017509956798175)],
        &[(0b01001, &ENTRY_VAPORIZE_7074947866923787432)],
        &[(0b01001, &ENTRY_VAPORIZED_4100382952590684636)],
        &[(0b01001, &ENTRY_VAPORIZER_8052635902096901156)],
        &[(0b01001, &ENTRY_VAPORIZERS_9656279687545559604)],
        &[(0b01001, &ENTRY_VAPORIZES_12186280109418449105)],
        &[(0b01001, &ENTRY_VAPORIZING_11720449073985132085)],
        &[(0b00001, &ENTRY_VAPORLESS_9180001548778190890)],
        &[(0b00001, &ENTRY_VAPORLESSES_9449123748147448331)],
        &[(0b00001, &ENTRY_VAPORLIKE_4304234079758020864)],
        &[(0b00001, &ENTRY_VAPORLIKES_17513958557622792273)],
        &[(0b00001, &ENTRY_VAPOROSE_941229128135609892)],
        &[(0b00001, &ENTRY_VAPOROUSLY_10099688633493703963)],
        &[(0b11001, &ENTRY_VAPORS_9486200942177396366)],
        &[(0b01001, &ENTRY_VAPORWARE_2722248098855884375)],
        &[(0b00001, &ENTRY_VAPORY_5997890858470358305)],
    ],
    range: 1..=9,
};

static VARS_VAN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VAN_CHILDREN),
    value: None,
};

pub static VARS_VAN_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("dalisation"),
        dictgen::InsensitiveStr::Ascii("dalisations"),
        dictgen::InsensitiveStr::Ascii("dalise"),
        dictgen::InsensitiveStr::Ascii("dalised"),
        dictgen::InsensitiveStr::Ascii("dalises"),
        dictgen::InsensitiveStr::Ascii("dalising"),
        dictgen::InsensitiveStr::Ascii("dalization"),
        dictgen::InsensitiveStr::Ascii("dalizations"),
        dictgen::InsensitiveStr::Ascii("dalize"),
        dictgen::InsensitiveStr::Ascii("dalized"),
        dictgen::InsensitiveStr::Ascii("dalizes"),
        dictgen::InsensitiveStr::Ascii("dalizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VANDALIZATION_321326720704663358)],
        &[(0b10010, &ENTRY_VANDALIZATIONS_12533411033790274385)],
        &[(0b10010, &ENTRY_VANDALIZE_13852377148508595432)],
        &[(0b10010, &ENTRY_VANDALIZED_6584048774266312596)],
        &[(0b10010, &ENTRY_VANDALIZES_950444592106680495)],
        &[(0b10010, &ENTRY_VANDALIZING_15674911687333824137)],
        &[(0b01001, &ENTRY_VANDALIZATION_321326720704663358)],
        &[(0b01001, &ENTRY_VANDALIZATIONS_12533411033790274385)],
        &[(0b01001, &ENTRY_VANDALIZE_13852377148508595432)],
        &[(0b01001, &ENTRY_VANDALIZED_6584048774266312596)],
        &[(0b01001, &ENTRY_VANDALIZES_950444592106680495)],
        &[(0b01001, &ENTRY_VANDALIZING_15674911687333824137)],
    ],
    range: 6..=11,
};

static VARS_VAM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VAM_CHILDREN),
    value: None,
};

pub static VARS_VAM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("pirise"),
        dictgen::InsensitiveStr::Ascii("pirised"),
        dictgen::InsensitiveStr::Ascii("pirises"),
        dictgen::InsensitiveStr::Ascii("pirising"),
        dictgen::InsensitiveStr::Ascii("pirize"),
        dictgen::InsensitiveStr::Ascii("pirized"),
        dictgen::InsensitiveStr::Ascii("pirizes"),
        dictgen::InsensitiveStr::Ascii("pirizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VAMPIRIZE_2148156304906706014)],
        &[(0b10010, &ENTRY_VAMPIRIZED_1331377974704440897)],
        &[(0b10010, &ENTRY_VAMPIRIZES_15605173529611826568)],
        &[(0b10010, &ENTRY_VAMPIRIZING_5067863975594369914)],
        &[(0b01001, &ENTRY_VAMPIRIZE_2148156304906706014)],
        &[(0b01001, &ENTRY_VAMPIRIZED_1331377974704440897)],
        &[(0b01001, &ENTRY_VAMPIRIZES_15605173529611826568)],
        &[(0b01001, &ENTRY_VAMPIRIZING_5067863975594369914)],
    ],
    range: 6..=8,
};

static VARS_VAL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VAL_CHILDREN),
    value: None,
};

pub static VARS_VAL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("or"),
        dictgen::InsensitiveStr::Ascii("orisation"),
        dictgen::InsensitiveStr::Ascii("orisations"),
        dictgen::InsensitiveStr::Ascii("orise"),
        dictgen::InsensitiveStr::Ascii("orised"),
        dictgen::InsensitiveStr::Ascii("orises"),
        dictgen::InsensitiveStr::Ascii("orising"),
        dictgen::InsensitiveStr::Ascii("orization"),
        dictgen::InsensitiveStr::Ascii("orizations"),
        dictgen::InsensitiveStr::Ascii("orize"),
        dictgen::InsensitiveStr::Ascii("orized"),
        dictgen::InsensitiveStr::Ascii("orizes"),
        dictgen::InsensitiveStr::Ascii("orizing"),
        dictgen::InsensitiveStr::Ascii("orousness"),
        dictgen::InsensitiveStr::Ascii("ors"),
        dictgen::InsensitiveStr::Ascii("our"),
        dictgen::InsensitiveStr::Ascii("ourousness"),
        dictgen::InsensitiveStr::Ascii("ours"),
        dictgen::InsensitiveStr::Ascii("vulae"),
        dictgen::InsensitiveStr::Ascii("vule"),
    ],
    values: &[
        &[(0b11001, &ENTRY_VALOR_10559677046210656064)],
        &[(0b10010, &ENTRY_VALORIZATION_10419740603004179298)],
        &[(0b10010, &ENTRY_VALORIZATIONS_5550580571650748675)],
        &[(0b10010, &ENTRY_VALORIZE_18286588028207921541)],
        &[(0b10010, &ENTRY_VALORIZED_16812452574506000724)],
        &[(0b10010, &ENTRY_VALORIZES_12702735390304257487)],
        &[(0b10010, &ENTRY_VALORIZING_6868515530721861819)],
        &[(0b01001, &ENTRY_VALORIZATION_10419740603004179298)],
        &[(0b01001, &ENTRY_VALORIZATIONS_5550580571650748675)],
        &[(0b01001, &ENTRY_VALORIZE_18286588028207921541)],
        &[(0b01001, &ENTRY_VALORIZED_16812452574506000724)],
        &[(0b01001, &ENTRY_VALORIZES_12702735390304257487)],
        &[(0b01001, &ENTRY_VALORIZING_6868515530721861819)],
        &[(0b00001, &ENTRY_VALOROUSNESS_4012556260769975737)],
        &[(0b11001, &ENTRY_VALORS_12937983727743095167)],
        &[(0b11010, &ENTRY_VALOR_10559677046210656064)],
        &[(0b11010, &ENTRY_VALOROUSNESS_4012556260769975737)],
        &[(0b11010, &ENTRY_VALORS_12937983727743095167)],
        &[(0b11010, &ENTRY_VALVULE_7068032189967732165)],
        &[(0b00001, &ENTRY_VALVULE_7068032189967732165)],
    ],
    range: 2..=10,
};

static VARS_VAG_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VAG_CHILDREN),
    value: None,
};

pub static VARS_VAG_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("abondise"),
        dictgen::InsensitiveStr::Ascii("abondised"),
        dictgen::InsensitiveStr::Ascii("abondiser"),
        dictgen::InsensitiveStr::Ascii("abondisers"),
        dictgen::InsensitiveStr::Ascii("abondises"),
        dictgen::InsensitiveStr::Ascii("abondising"),
        dictgen::InsensitiveStr::Ascii("abondize"),
        dictgen::InsensitiveStr::Ascii("abondized"),
        dictgen::InsensitiveStr::Ascii("abondizer"),
        dictgen::InsensitiveStr::Ascii("abondizers"),
        dictgen::InsensitiveStr::Ascii("abondizes"),
        dictgen::InsensitiveStr::Ascii("abondizing"),
        dictgen::InsensitiveStr::Ascii("inulae"),
        dictgen::InsensitiveStr::Ascii("inule"),
        dictgen::InsensitiveStr::Ascii("rantise"),
        dictgen::InsensitiveStr::Ascii("rantises"),
        dictgen::InsensitiveStr::Ascii("rantize"),
        dictgen::InsensitiveStr::Ascii("rantizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VAGABONDIZE_11652184056860982029)],
        &[(0b10010, &ENTRY_VAGABONDIZED_8460203338144902596)],
        &[(0b10010, &ENTRY_VAGABONDIZER_3037058975526630888)],
        &[(0b10010, &ENTRY_VAGABONDIZERS_14944892011725033494)],
        &[(0b10010, &ENTRY_VAGABONDIZES_15618104026782170568)],
        &[(0b10010, &ENTRY_VAGABONDIZING_14715875291944757403)],
        &[(0b01001, &ENTRY_VAGABONDIZE_11652184056860982029)],
        &[(0b01001, &ENTRY_VAGABONDIZED_8460203338144902596)],
        &[(0b01001, &ENTRY_VAGABONDIZER_3037058975526630888)],
        &[(0b01001, &ENTRY_VAGABONDIZERS_14944892011725033494)],
        &[(0b01001, &ENTRY_VAGABONDIZES_15618104026782170568)],
        &[(0b01001, &ENTRY_VAGABONDIZING_14715875291944757403)],
        &[(0b11010, &ENTRY_VAGINULE_15009785862152351808)],
        &[(0b00001, &ENTRY_VAGINULE_15009785862152351808)],
        &[(0b10010, &ENTRY_VAGRANTIZE_18388633313665953145)],
        &[(0b10010, &ENTRY_VAGRANTIZES_9039456281230433333)],
        &[(0b01001, &ENTRY_VAGRANTIZE_18388633313665953145)],
        &[(0b01001, &ENTRY_VAGRANTIZES_9039456281230433333)],
    ],
    range: 5..=10,
};

static VARS_VAC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VAC_CHILDREN),
    value: None,
};

pub static VARS_VAC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cinisation"),
        dictgen::InsensitiveStr::Ascii("cinisations"),
        dictgen::InsensitiveStr::Ascii("cinization"),
        dictgen::InsensitiveStr::Ascii("cinizations"),
        dictgen::InsensitiveStr::Ascii("uolisation"),
        dictgen::InsensitiveStr::Ascii("uolisations"),
        dictgen::InsensitiveStr::Ascii("uolization"),
        dictgen::InsensitiveStr::Ascii("uolizations"),
        dictgen::InsensitiveStr::Ascii("uumise"),
        dictgen::InsensitiveStr::Ascii("uumised"),
        dictgen::InsensitiveStr::Ascii("uumises"),
        dictgen::InsensitiveStr::Ascii("uumising"),
        dictgen::InsensitiveStr::Ascii("uumize"),
        dictgen::InsensitiveStr::Ascii("uumized"),
        dictgen::InsensitiveStr::Ascii("uumizes"),
        dictgen::InsensitiveStr::Ascii("uumizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_VACCINIZATION_14920485206127408398)],
        &[(0b10010, &ENTRY_VACCINIZATIONS_7439925486752573538)],
        &[(0b01001, &ENTRY_VACCINIZATION_14920485206127408398)],
        &[(0b01001, &ENTRY_VACCINIZATIONS_7439925486752573538)],
        &[(0b10010, &ENTRY_VACUOLIZATION_13858163343008163773)],
        &[(0b10010, &ENTRY_VACUOLIZATIONS_2613605802168870716)],
        &[(0b01001, &ENTRY_VACUOLIZATION_13858163343008163773)],
        &[(0b01001, &ENTRY_VACUOLIZATIONS_2613605802168870716)],
        &[(0b10010, &ENTRY_VACUUMIZE_14138660867202341090)],
        &[(0b10010, &ENTRY_VACUUMIZED_694297391266218663)],
        &[(0b10010, &ENTRY_VACUUMIZES_3651190374182064680)],
        &[(0b10010, &ENTRY_VACUUMIZING_16587783276915840565)],
        &[(0b01001, &ENTRY_VACUUMIZE_14138660867202341090)],
        &[(0b01001, &ENTRY_VACUUMIZED_694297391266218663)],
        &[(0b01001, &ENTRY_VACUUMIZES_3651190374182064680)],
        &[(0b01001, &ENTRY_VACUUMIZING_16587783276915840565)],
    ],
    range: 6..=11,
};

static VARS_VAA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_VAA_CHILDREN),
    value: None,
};

pub static VARS_VAA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gmaer"),
        dictgen::InsensitiveStr::Ascii("gmer"),
    ],
    values: &[
        &[(0b11010, &ENTRY_VAAGMER_9352026066170753042)],
        &[(0b00001, &ENTRY_VAAGMER_9352026066170753042)],
    ],
    range: 4..=5,
};

static VARS_U_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_U_CHILDREN),
    value: None,
};

static VARS_U_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UL_NODE),
    None,
    Some(&VARS_UN_NODE),
    None,
    Some(&VARS_UP_NODE),
    None,
    Some(&VARS_UR_NODE),
    Some(&VARS_US_NODE),
    Some(&VARS_UT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_UT_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UT_CHILDREN),
    value: None,
};

pub static VARS_UT_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ilisabilities"),
        dictgen::InsensitiveStr::Ascii("ilisability"),
        dictgen::InsensitiveStr::Ascii("ilisable"),
        dictgen::InsensitiveStr::Ascii("ilisables"),
        dictgen::InsensitiveStr::Ascii("ilisation"),
        dictgen::InsensitiveStr::Ascii("ilisations"),
        dictgen::InsensitiveStr::Ascii("ilise"),
        dictgen::InsensitiveStr::Ascii("ilised"),
        dictgen::InsensitiveStr::Ascii("iliser"),
        dictgen::InsensitiveStr::Ascii("ilisers"),
        dictgen::InsensitiveStr::Ascii("ilises"),
        dictgen::InsensitiveStr::Ascii("ilising"),
        dictgen::InsensitiveStr::Ascii("ilitarianise"),
        dictgen::InsensitiveStr::Ascii("ilitarianised"),
        dictgen::InsensitiveStr::Ascii("ilitarianises"),
        dictgen::InsensitiveStr::Ascii("ilitarianising"),
        dictgen::InsensitiveStr::Ascii("ilitarianize"),
        dictgen::InsensitiveStr::Ascii("ilitarianized"),
        dictgen::InsensitiveStr::Ascii("ilitarianizes"),
        dictgen::InsensitiveStr::Ascii("ilitarianizing"),
        dictgen::InsensitiveStr::Ascii("ilizabilities"),
        dictgen::InsensitiveStr::Ascii("ilizability"),
        dictgen::InsensitiveStr::Ascii("ilizable"),
        dictgen::InsensitiveStr::Ascii("ilizables"),
        dictgen::InsensitiveStr::Ascii("ilization"),
        dictgen::InsensitiveStr::Ascii("ilizations"),
        dictgen::InsensitiveStr::Ascii("ilize"),
        dictgen::InsensitiveStr::Ascii("ilized"),
        dictgen::InsensitiveStr::Ascii("ilizer"),
        dictgen::InsensitiveStr::Ascii("ilizers"),
        dictgen::InsensitiveStr::Ascii("ilizes"),
        dictgen::InsensitiveStr::Ascii("ilizing"),
        dictgen::InsensitiveStr::Ascii("opianise"),
        dictgen::InsensitiveStr::Ascii("opianised"),
        dictgen::InsensitiveStr::Ascii("opianiser"),
        dictgen::InsensitiveStr::Ascii("opianisers"),
        dictgen::InsensitiveStr::Ascii("opianises"),
        dictgen::InsensitiveStr::Ascii("opianising"),
        dictgen::InsensitiveStr::Ascii("opianize"),
        dictgen::InsensitiveStr::Ascii("opianized"),
        dictgen::InsensitiveStr::Ascii("opianizer"),
        dictgen::InsensitiveStr::Ascii("opianizers"),
        dictgen::InsensitiveStr::Ascii("opianizes"),
        dictgen::InsensitiveStr::Ascii("opianizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UTILIZABILITIES_2397151207630807999)],
        &[(0b10010, &ENTRY_UTILIZABILITY_8225222995731560442)],
        &[(0b10010, &ENTRY_UTILIZABLE_657706566869914036)],
        &[(0b10010, &ENTRY_UTILIZABLES_2699823619654292368)],
        &[(0b10010, &ENTRY_UTILIZATION_10923497997585510620)],
        &[(0b10010, &ENTRY_UTILIZATIONS_4724972587409135598)],
        &[(0b10010, &ENTRY_UTILIZE_1012773511652592330)],
        &[(0b10010, &ENTRY_UTILIZED_2804070747550195319)],
        &[(0b10010, &ENTRY_UTILIZER_15218673503685600046)],
        &[(0b10010, &ENTRY_UTILIZERS_7682889880042432556)],
        &[(0b10010, &ENTRY_UTILIZES_10186051414736400981)],
        &[(0b10010, &ENTRY_UTILIZING_14247990373114335405)],
        &[(0b10010, &ENTRY_UTILITARIANIZE_8297351043834511620)],
        &[(0b10010, &ENTRY_UTILITARIANIZED_17327794031594514233)],
        &[(0b10010, &ENTRY_UTILITARIANIZES_2918689411948086849)],
        &[(0b10010, &ENTRY_UTILITARIANIZING_11871648364295177065)],
        &[(0b01001, &ENTRY_UTILITARIANIZE_8297351043834511620)],
        &[(0b01001, &ENTRY_UTILITARIANIZED_17327794031594514233)],
        &[(0b01001, &ENTRY_UTILITARIANIZES_2918689411948086849)],
        &[(0b01001, &ENTRY_UTILITARIANIZING_11871648364295177065)],
        &[(0b01001, &ENTRY_UTILIZABILITIES_2397151207630807999)],
        &[(0b01001, &ENTRY_UTILIZABILITY_8225222995731560442)],
        &[(0b01001, &ENTRY_UTILIZABLE_657706566869914036)],
        &[(0b01001, &ENTRY_UTILIZABLES_2699823619654292368)],
        &[(0b01001, &ENTRY_UTILIZATION_10923497997585510620)],
        &[(0b01001, &ENTRY_UTILIZATIONS_4724972587409135598)],
        &[(0b01001, &ENTRY_UTILIZE_1012773511652592330)],
        &[(0b01001, &ENTRY_UTILIZED_2804070747550195319)],
        &[(0b01001, &ENTRY_UTILIZER_15218673503685600046)],
        &[(0b01001, &ENTRY_UTILIZERS_7682889880042432556)],
        &[(0b01001, &ENTRY_UTILIZES_10186051414736400981)],
        &[(0b01001, &ENTRY_UTILIZING_14247990373114335405)],
        &[(0b10010, &ENTRY_UTOPIANIZE_15231068506782111828)],
        &[(0b10010, &ENTRY_UTOPIANIZED_13362099296694661562)],
        &[(0b10010, &ENTRY_UTOPIANIZER_810034931952875575)],
        &[(0b10010, &ENTRY_UTOPIANIZERS_17092121582482431024)],
        &[(0b10010, &ENTRY_UTOPIANIZES_17399145312143334553)],
        &[(0b10010, &ENTRY_UTOPIANIZING_4126566720003715520)],
        &[(0b01001, &ENTRY_UTOPIANIZE_15231068506782111828)],
        &[(0b01001, &ENTRY_UTOPIANIZED_13362099296694661562)],
        &[(0b01001, &ENTRY_UTOPIANIZER_810034931952875575)],
        &[(0b01001, &ENTRY_UTOPIANIZERS_17092121582482431024)],
        &[(0b01001, &ENTRY_UTOPIANIZES_17399145312143334553)],
        &[(0b01001, &ENTRY_UTOPIANIZING_4126566720003715520)],
    ],
    range: 5..=14,
};

static VARS_US_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_US_CHILDREN),
    value: None,
};

pub static VARS_US_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("eability")],
    values: &[&[(0b00001, &ENTRY_USABILITY_2409309504889002778)]],
    range: 8..=8,
};

static VARS_UR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UR_CHILDREN),
    value: None,
};

pub static VARS_UR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aemia"),
        dictgen::InsensitiveStr::Ascii("aemias"),
        dictgen::InsensitiveStr::Ascii("aemic"),
        dictgen::InsensitiveStr::Ascii("alitisation"),
        dictgen::InsensitiveStr::Ascii("alitisations"),
        dictgen::InsensitiveStr::Ascii("alitise"),
        dictgen::InsensitiveStr::Ascii("alitised"),
        dictgen::InsensitiveStr::Ascii("alitises"),
        dictgen::InsensitiveStr::Ascii("alitising"),
        dictgen::InsensitiveStr::Ascii("alitization"),
        dictgen::InsensitiveStr::Ascii("alitizations"),
        dictgen::InsensitiveStr::Ascii("alitize"),
        dictgen::InsensitiveStr::Ascii("alitized"),
        dictgen::InsensitiveStr::Ascii("alitizes"),
        dictgen::InsensitiveStr::Ascii("alitizing"),
        dictgen::InsensitiveStr::Ascii("ataemia"),
        dictgen::InsensitiveStr::Ascii("atemia"),
        dictgen::InsensitiveStr::Ascii("banisation"),
        dictgen::InsensitiveStr::Ascii("banisations"),
        dictgen::InsensitiveStr::Ascii("banise"),
        dictgen::InsensitiveStr::Ascii("banised"),
        dictgen::InsensitiveStr::Ascii("banises"),
        dictgen::InsensitiveStr::Ascii("banising"),
        dictgen::InsensitiveStr::Ascii("banization"),
        dictgen::InsensitiveStr::Ascii("banizations"),
        dictgen::InsensitiveStr::Ascii("banize"),
        dictgen::InsensitiveStr::Ascii("banized"),
        dictgen::InsensitiveStr::Ascii("banizes"),
        dictgen::InsensitiveStr::Ascii("banizing"),
        dictgen::InsensitiveStr::Ascii("edema"),
        dictgen::InsensitiveStr::Ascii("emia"),
        dictgen::InsensitiveStr::Ascii("emias"),
        dictgen::InsensitiveStr::Ascii("emic"),
        dictgen::InsensitiveStr::Ascii("ethrorrhea"),
        dictgen::InsensitiveStr::Ascii("ethrorrhoea"),
        dictgen::InsensitiveStr::Ascii("icaemia"),
        dictgen::InsensitiveStr::Ascii("icaemic"),
        dictgen::InsensitiveStr::Ascii("icemia"),
        dictgen::InsensitiveStr::Ascii("icemic"),
        dictgen::InsensitiveStr::Ascii("inaemia"),
        dictgen::InsensitiveStr::Ascii("inaemic"),
        dictgen::InsensitiveStr::Ascii("inemia"),
        dictgen::InsensitiveStr::Ascii("inemic"),
        dictgen::InsensitiveStr::Ascii("oedema"),
        dictgen::InsensitiveStr::Ascii("ohaematin"),
        dictgen::InsensitiveStr::Ascii("ohematin"),
        dictgen::InsensitiveStr::Ascii("ophaein"),
        dictgen::InsensitiveStr::Ascii("ophein"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UREMIA_5689969777449555427)],
        &[(0b10010, &ENTRY_UREMIAS_922769604822503284)],
        &[(0b10010, &ENTRY_UREMIC_16730857995062547325)],
        &[(0b10010, &ENTRY_URALITIZATION_9224301311774971881)],
        &[(0b10010, &ENTRY_URALITIZATIONS_4694547628568956579)],
        &[(0b10010, &ENTRY_URALITIZE_16749000206864918007)],
        &[(0b10010, &ENTRY_URALITIZED_7976389324622529761)],
        &[(0b10010, &ENTRY_URALITIZES_2908475727458579535)],
        &[(0b10010, &ENTRY_URALITIZING_1776329728839479360)],
        &[(0b01001, &ENTRY_URALITIZATION_9224301311774971881)],
        &[(0b01001, &ENTRY_URALITIZATIONS_4694547628568956579)],
        &[(0b01001, &ENTRY_URALITIZE_16749000206864918007)],
        &[(0b01001, &ENTRY_URALITIZED_7976389324622529761)],
        &[(0b01001, &ENTRY_URALITIZES_2908475727458579535)],
        &[(0b01001, &ENTRY_URALITIZING_1776329728839479360)],
        &[(0b11010, &ENTRY_URATEMIA_5405625611324090705)],
        &[(0b00001, &ENTRY_URATEMIA_5405625611324090705)],
        &[(0b10010, &ENTRY_URBANIZATION_13167682870250962044)],
        &[(0b10010, &ENTRY_URBANIZATIONS_714857663098149035)],
        &[(0b10010, &ENTRY_URBANIZE_13821147474427946226)],
        &[(0b10010, &ENTRY_URBANIZED_14020698925707626324)],
        &[(0b10010, &ENTRY_URBANIZES_3740663614137143534)],
        &[(0b10010, &ENTRY_URBANIZING_6731820196250704237)],
        &[(0b01001, &ENTRY_URBANIZATION_13167682870250962044)],
        &[(0b01001, &ENTRY_URBANIZATIONS_714857663098149035)],
        &[(0b01001, &ENTRY_URBANIZE_13821147474427946226)],
        &[(0b01001, &ENTRY_URBANIZED_14020698925707626324)],
        &[(0b01001, &ENTRY_URBANIZES_3740663614137143534)],
        &[(0b01001, &ENTRY_URBANIZING_6731820196250704237)],
        &[(0b00001, &ENTRY_UREDEMA_959978479087452280)],
        &[(0b01001, &ENTRY_UREMIA_5689969777449555427)],
        &[(0b01001, &ENTRY_UREMIAS_922769604822503284)],
        &[(0b01001, &ENTRY_UREMIC_16730857995062547325)],
        &[(0b00001, &ENTRY_URETHRORRHEA_465812257833285712)],
        &[(0b11010, &ENTRY_URETHRORRHEA_465812257833285712)],
        &[(0b11010, &ENTRY_URICEMIA_735304459969707353)],
        &[(0b11010, &ENTRY_URICEMIC_4538463089231912762)],
        &[(0b00001, &ENTRY_URICEMIA_735304459969707353)],
        &[(0b00001, &ENTRY_URICEMIC_4538463089231912762)],
        &[(0b11010, &ENTRY_URINEMIA_14477903106053677801)],
        &[(0b11010, &ENTRY_URINEMIC_3826715010964749488)],
        &[(0b00001, &ENTRY_URINEMIA_14477903106053677801)],
        &[(0b00001, &ENTRY_URINEMIC_3826715010964749488)],
        &[(0b11010, &ENTRY_UREDEMA_959978479087452280)],
        &[(0b11010, &ENTRY_UROHEMATIN_18414252065450864526)],
        &[(0b00001, &ENTRY_UROHEMATIN_18414252065450864526)],
        &[(0b11010, &ENTRY_UROPHEIN_4036494320759732075)],
        &[(0b00001, &ENTRY_UROPHEIN_4036494320759732075)],
    ],
    range: 4..=12,
};

static VARS_UP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UP_CHILDREN),
    value: None,
};

pub static VARS_UP_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("draft"),
        dictgen::InsensitiveStr::Ascii("drafts"),
        dictgen::InsensitiveStr::Ascii("draught"),
        dictgen::InsensitiveStr::Ascii("draughts"),
    ],
    values: &[
        &[(0b01001, &ENTRY_UPDRAFT_14478591919041764288)],
        &[(0b01001, &ENTRY_UPDRAFTS_15724500159329907899)],
        &[(0b11010, &ENTRY_UPDRAFT_14478591919041764288)],
        &[(0b11010, &ENTRY_UPDRAFTS_15724500159329907899)],
    ],
    range: 5..=8,
};

static VARS_UN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UN_CHILDREN),
    value: None,
};

static VARS_UN_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_UNA_NODE),
    Some(&VARS_UNB_NODE),
    Some(&VARS_UNC_NODE),
    Some(&VARS_UND_NODE),
    Some(&VARS_UNE_NODE),
    Some(&VARS_UNF_NODE),
    Some(&VARS_UNG_NODE),
    Some(&VARS_UNH_NODE),
    Some(&VARS_UNI_NODE),
    Some(&VARS_UNJ_NODE),
    Some(&VARS_UNK_NODE),
    Some(&VARS_UNL_NODE),
    Some(&VARS_UNM_NODE),
    Some(&VARS_UNN_NODE),
    Some(&VARS_UNO_NODE),
    Some(&VARS_UNP_NODE),
    Some(&VARS_UNQ_NODE),
    Some(&VARS_UNR_NODE),
    Some(&VARS_UNS_NODE),
    Some(&VARS_UNT_NODE),
    Some(&VARS_UNU_NODE),
    Some(&VARS_UNV_NODE),
    Some(&VARS_UNW_NODE),
    None,
    None,
    None,
];

static VARS_UNW_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNW_CHILDREN),
    value: None,
};

pub static VARS_UNW_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("esternised"),
        dictgen::InsensitiveStr::Ascii("esterniseds"),
        dictgen::InsensitiveStr::Ascii("esternized"),
        dictgen::InsensitiveStr::Ascii("esternizeds"),
        dictgen::InsensitiveStr::Ascii("omanise"),
        dictgen::InsensitiveStr::Ascii("omanised"),
        dictgen::InsensitiveStr::Ascii("omanises"),
        dictgen::InsensitiveStr::Ascii("omanize"),
        dictgen::InsensitiveStr::Ascii("omanized"),
        dictgen::InsensitiveStr::Ascii("omanizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNWESTERNIZED_2338020082584820680)],
        &[(0b10010, &ENTRY_UNWESTERNIZEDS_8372650994230810456)],
        &[(0b01001, &ENTRY_UNWESTERNIZED_2338020082584820680)],
        &[(0b01001, &ENTRY_UNWESTERNIZEDS_8372650994230810456)],
        &[(0b10010, &ENTRY_UNWOMANIZE_11304497579761163173)],
        &[(0b10010, &ENTRY_UNWOMANIZED_9669879163918865323)],
        &[(0b10010, &ENTRY_UNWOMANIZES_6959542966143151702)],
        &[(0b01001, &ENTRY_UNWOMANIZE_11304497579761163173)],
        &[(0b01001, &ENTRY_UNWOMANIZED_9669879163918865323)],
        &[(0b01001, &ENTRY_UNWOMANIZES_6959542966143151702)],
    ],
    range: 7..=11,
};

static VARS_UNV_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNV_CHILDREN),
    value: None,
};

pub static VARS_UNV_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aporised"),
        dictgen::InsensitiveStr::Ascii("aporiseds"),
        dictgen::InsensitiveStr::Ascii("aporized"),
        dictgen::InsensitiveStr::Ascii("aporizeds"),
        dictgen::InsensitiveStr::Ascii("ectorisable"),
        dictgen::InsensitiveStr::Ascii("ectorizable"),
        dictgen::InsensitiveStr::Ascii("erbalised"),
        dictgen::InsensitiveStr::Ascii("erbalized"),
        dictgen::InsensitiveStr::Ascii("ictimised"),
        dictgen::InsensitiveStr::Ascii("ictimized"),
        dictgen::InsensitiveStr::Ascii("isualised"),
        dictgen::InsensitiveStr::Ascii("isualisedder"),
        dictgen::InsensitiveStr::Ascii("isualiseddest"),
        dictgen::InsensitiveStr::Ascii("isualized"),
        dictgen::InsensitiveStr::Ascii("isualizedder"),
        dictgen::InsensitiveStr::Ascii("isualizeddest"),
        dictgen::InsensitiveStr::Ascii("italised"),
        dictgen::InsensitiveStr::Ascii("italiseds"),
        dictgen::InsensitiveStr::Ascii("italized"),
        dictgen::InsensitiveStr::Ascii("italizeds"),
        dictgen::InsensitiveStr::Ascii("itriolised"),
        dictgen::InsensitiveStr::Ascii("itrioliseds"),
        dictgen::InsensitiveStr::Ascii("itriolized"),
        dictgen::InsensitiveStr::Ascii("itriolizeds"),
        dictgen::InsensitiveStr::Ascii("ocalised"),
        dictgen::InsensitiveStr::Ascii("ocalisedder"),
        dictgen::InsensitiveStr::Ascii("ocaliseddest"),
        dictgen::InsensitiveStr::Ascii("ocaliseds"),
        dictgen::InsensitiveStr::Ascii("ocalized"),
        dictgen::InsensitiveStr::Ascii("ocalizedder"),
        dictgen::InsensitiveStr::Ascii("ocalizeddest"),
        dictgen::InsensitiveStr::Ascii("ocalizeds"),
        dictgen::InsensitiveStr::Ascii("olatilise"),
        dictgen::InsensitiveStr::Ascii("olatilised"),
        dictgen::InsensitiveStr::Ascii("olatilisedder"),
        dictgen::InsensitiveStr::Ascii("olatiliseddest"),
        dictgen::InsensitiveStr::Ascii("olatilises"),
        dictgen::InsensitiveStr::Ascii("olatilize"),
        dictgen::InsensitiveStr::Ascii("olatilized"),
        dictgen::InsensitiveStr::Ascii("olatilizedder"),
        dictgen::InsensitiveStr::Ascii("olatilizeddest"),
        dictgen::InsensitiveStr::Ascii("olatilizes"),
        dictgen::InsensitiveStr::Ascii("ulcanised"),
        dictgen::InsensitiveStr::Ascii("ulcanisedder"),
        dictgen::InsensitiveStr::Ascii("ulcaniseddest"),
        dictgen::InsensitiveStr::Ascii("ulcaniseds"),
        dictgen::InsensitiveStr::Ascii("ulcanized"),
        dictgen::InsensitiveStr::Ascii("ulcanizedder"),
        dictgen::InsensitiveStr::Ascii("ulcanizeddest"),
        dictgen::InsensitiveStr::Ascii("ulcanizeds"),
        dictgen::InsensitiveStr::Ascii("ulgarise"),
        dictgen::InsensitiveStr::Ascii("ulgarised"),
        dictgen::InsensitiveStr::Ascii("ulgarises"),
        dictgen::InsensitiveStr::Ascii("ulgarising"),
        dictgen::InsensitiveStr::Ascii("ulgarize"),
        dictgen::InsensitiveStr::Ascii("ulgarized"),
        dictgen::InsensitiveStr::Ascii("ulgarizes"),
        dictgen::InsensitiveStr::Ascii("ulgarizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNVAPORIZED_16545025727542113291)],
        &[(0b10010, &ENTRY_UNVAPORIZEDS_986543555659572827)],
        &[(0b01001, &ENTRY_UNVAPORIZED_16545025727542113291)],
        &[(0b01001, &ENTRY_UNVAPORIZEDS_986543555659572827)],
        &[(0b10010, &ENTRY_UNVECTORIZABLE_18305744060207565163)],
        &[(0b01001, &ENTRY_UNVECTORIZABLE_18305744060207565163)],
        &[(0b10010, &ENTRY_UNVERBALIZED_16856369756877096411)],
        &[(0b01001, &ENTRY_UNVERBALIZED_16856369756877096411)],
        &[(0b10010, &ENTRY_UNVICTIMIZED_13829704510461931485)],
        &[(0b01001, &ENTRY_UNVICTIMIZED_13829704510461931485)],
        &[(0b10010, &ENTRY_UNVISUALIZED_2776258560824841456)],
        &[(0b10010, &ENTRY_UNVISUALIZEDDER_13256531491156210059)],
        &[(0b10010, &ENTRY_UNVISUALIZEDDEST_6777836850065797871)],
        &[(0b01001, &ENTRY_UNVISUALIZED_2776258560824841456)],
        &[(0b01001, &ENTRY_UNVISUALIZEDDER_13256531491156210059)],
        &[(0b01001, &ENTRY_UNVISUALIZEDDEST_6777836850065797871)],
        &[(0b10010, &ENTRY_UNVITALIZED_11823193045588642198)],
        &[(0b10010, &ENTRY_UNVITALIZEDS_10697536110994369157)],
        &[(0b01001, &ENTRY_UNVITALIZED_11823193045588642198)],
        &[(0b01001, &ENTRY_UNVITALIZEDS_10697536110994369157)],
        &[(0b10010, &ENTRY_UNVITRIOLIZED_15668418284843563695)],
        &[(0b10010, &ENTRY_UNVITRIOLIZEDS_12617332440469592487)],
        &[(0b01001, &ENTRY_UNVITRIOLIZED_15668418284843563695)],
        &[(0b01001, &ENTRY_UNVITRIOLIZEDS_12617332440469592487)],
        &[(0b10010, &ENTRY_UNVOCALIZED_14849265082296142302)],
        &[(0b10010, &ENTRY_UNVOCALIZEDDER_8782052029072763726)],
        &[(0b10010, &ENTRY_UNVOCALIZEDDEST_16264288867545903555)],
        &[(0b10010, &ENTRY_UNVOCALIZEDS_16873526062784100267)],
        &[(0b01001, &ENTRY_UNVOCALIZED_14849265082296142302)],
        &[(0b01001, &ENTRY_UNVOCALIZEDDER_8782052029072763726)],
        &[(0b01001, &ENTRY_UNVOCALIZEDDEST_16264288867545903555)],
        &[(0b01001, &ENTRY_UNVOCALIZEDS_16873526062784100267)],
        &[(0b10010, &ENTRY_UNVOLATILIZE_5958705215773329402)],
        &[(0b10010, &ENTRY_UNVOLATILIZED_7055569159550394451)],
        &[(0b10010, &ENTRY_UNVOLATILIZEDDER_17937975853559322294)],
        &[(0b10010, &ENTRY_UNVOLATILIZEDDEST_14571877913455730099)],
        &[(0b10010, &ENTRY_UNVOLATILIZES_11043825585956014572)],
        &[(0b01001, &ENTRY_UNVOLATILIZE_5958705215773329402)],
        &[(0b01001, &ENTRY_UNVOLATILIZED_7055569159550394451)],
        &[(0b01001, &ENTRY_UNVOLATILIZEDDER_17937975853559322294)],
        &[(0b01001, &ENTRY_UNVOLATILIZEDDEST_14571877913455730099)],
        &[(0b01001, &ENTRY_UNVOLATILIZES_11043825585956014572)],
        &[(0b10010, &ENTRY_UNVULCANIZED_8687515356006252413)],
        &[(0b10010, &ENTRY_UNVULCANIZEDDER_15357474347454753550)],
        &[(0b10010, &ENTRY_UNVULCANIZEDDEST_3232274294131053531)],
        &[(0b10010, &ENTRY_UNVULCANIZEDS_1169880674497437033)],
        &[(0b01001, &ENTRY_UNVULCANIZED_8687515356006252413)],
        &[(0b01001, &ENTRY_UNVULCANIZEDDER_15357474347454753550)],
        &[(0b01001, &ENTRY_UNVULCANIZEDDEST_3232274294131053531)],
        &[(0b01001, &ENTRY_UNVULCANIZEDS_1169880674497437033)],
        &[(0b10010, &ENTRY_UNVULGARIZE_3818104634120863405)],
        &[(0b10010, &ENTRY_UNVULGARIZED_501333356952951895)],
        &[(0b10010, &ENTRY_UNVULGARIZES_4085302381557242262)],
        &[(0b10010, &ENTRY_UNVULGARIZING_6203485172128713465)],
        &[(0b01001, &ENTRY_UNVULGARIZE_3818104634120863405)],
        &[(0b01001, &ENTRY_UNVULGARIZED_501333356952951895)],
        &[(0b01001, &ENTRY_UNVULGARIZES_4085302381557242262)],
        &[(0b01001, &ENTRY_UNVULGARIZING_6203485172128713465)],
    ],
    range: 8..=14,
};

static VARS_UNU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNU_CHILDREN),
    value: None,
};

pub static VARS_UNU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("tilisable"),
        dictgen::InsensitiveStr::Ascii("tilisables"),
        dictgen::InsensitiveStr::Ascii("tilised"),
        dictgen::InsensitiveStr::Ascii("tilizable"),
        dictgen::InsensitiveStr::Ascii("tilizables"),
        dictgen::InsensitiveStr::Ascii("tilized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNUTILIZABLE_9039802547895734958)],
        &[(0b10010, &ENTRY_UNUTILIZABLES_12203087951077580837)],
        &[(0b10010, &ENTRY_UNUTILIZED_6004715330369766853)],
        &[(0b01001, &ENTRY_UNUTILIZABLE_9039802547895734958)],
        &[(0b01001, &ENTRY_UNUTILIZABLES_12203087951077580837)],
        &[(0b01001, &ENTRY_UNUTILIZED_6004715330369766853)],
    ],
    range: 7..=10,
};

static VARS_UNT_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNT_CHILDREN),
    value: None,
};

pub static VARS_UNT_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("antalised"),
        dictgen::InsensitiveStr::Ascii("antalisedder"),
        dictgen::InsensitiveStr::Ascii("antaliseddest"),
        dictgen::InsensitiveStr::Ascii("antalising"),
        dictgen::InsensitiveStr::Ascii("antalisinger"),
        dictgen::InsensitiveStr::Ascii("antalisingest"),
        dictgen::InsensitiveStr::Ascii("antalisings"),
        dictgen::InsensitiveStr::Ascii("antalized"),
        dictgen::InsensitiveStr::Ascii("antalizedder"),
        dictgen::InsensitiveStr::Ascii("antalizeddest"),
        dictgen::InsensitiveStr::Ascii("antalizing"),
        dictgen::InsensitiveStr::Ascii("antalizinger"),
        dictgen::InsensitiveStr::Ascii("antalizingest"),
        dictgen::InsensitiveStr::Ascii("antalizings"),
        dictgen::InsensitiveStr::Ascii("artarised"),
        dictgen::InsensitiveStr::Ascii("artariseds"),
        dictgen::InsensitiveStr::Ascii("artarized"),
        dictgen::InsensitiveStr::Ascii("artarizeds"),
        dictgen::InsensitiveStr::Ascii("echnicalise"),
        dictgen::InsensitiveStr::Ascii("echnicalises"),
        dictgen::InsensitiveStr::Ascii("echnicalize"),
        dictgen::InsensitiveStr::Ascii("echnicalizes"),
        dictgen::InsensitiveStr::Ascii("emporising"),
        dictgen::InsensitiveStr::Ascii("emporisings"),
        dictgen::InsensitiveStr::Ascii("emporizing"),
        dictgen::InsensitiveStr::Ascii("emporizings"),
        dictgen::InsensitiveStr::Ascii("errorised"),
        dictgen::InsensitiveStr::Ascii("errorized"),
        dictgen::InsensitiveStr::Ascii("heorisable"),
        dictgen::InsensitiveStr::Ascii("heorisables"),
        dictgen::InsensitiveStr::Ascii("heorizable"),
        dictgen::InsensitiveStr::Ascii("heorizables"),
        dictgen::InsensitiveStr::Ascii("rammeled"),
        dictgen::InsensitiveStr::Ascii("rammeledder"),
        dictgen::InsensitiveStr::Ascii("rammeleddest"),
        dictgen::InsensitiveStr::Ascii("rammelled"),
        dictgen::InsensitiveStr::Ascii("rammelledder"),
        dictgen::InsensitiveStr::Ascii("rammelleddest"),
        dictgen::InsensitiveStr::Ascii("ranquilised"),
        dictgen::InsensitiveStr::Ascii("ranquilized"),
        dictgen::InsensitiveStr::Ascii("ranquillise"),
        dictgen::InsensitiveStr::Ascii("ranquillised"),
        dictgen::InsensitiveStr::Ascii("ranquillize"),
        dictgen::InsensitiveStr::Ascii("ranquillized"),
        dictgen::InsensitiveStr::Ascii("yrannised"),
        dictgen::InsensitiveStr::Ascii("yrannized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNTANTALIZED_6826245574739736260)],
        &[(0b10010, &ENTRY_UNTANTALIZEDDER_4818289569312071640)],
        &[(0b10010, &ENTRY_UNTANTALIZEDDEST_17808161070361053815)],
        &[(0b10010, &ENTRY_UNTANTALIZING_9378536861335914621)],
        &[(0b10010, &ENTRY_UNTANTALIZINGER_434726785421024269)],
        &[(0b10010, &ENTRY_UNTANTALIZINGEST_14310803913056649148)],
        &[(0b10010, &ENTRY_UNTANTALIZINGS_16007088557356417459)],
        &[(0b01001, &ENTRY_UNTANTALIZED_6826245574739736260)],
        &[(0b01001, &ENTRY_UNTANTALIZEDDER_4818289569312071640)],
        &[(0b01001, &ENTRY_UNTANTALIZEDDEST_17808161070361053815)],
        &[(0b01001, &ENTRY_UNTANTALIZING_9378536861335914621)],
        &[(0b01001, &ENTRY_UNTANTALIZINGER_434726785421024269)],
        &[(0b01001, &ENTRY_UNTANTALIZINGEST_14310803913056649148)],
        &[(0b01001, &ENTRY_UNTANTALIZINGS_16007088557356417459)],
        &[(0b10010, &ENTRY_UNTARTARIZED_9979924217571095451)],
        &[(0b10010, &ENTRY_UNTARTARIZEDS_2508207556036622208)],
        &[(0b01001, &ENTRY_UNTARTARIZED_9979924217571095451)],
        &[(0b01001, &ENTRY_UNTARTARIZEDS_2508207556036622208)],
        &[(0b10010, &ENTRY_UNTECHNICALIZE_7661502502654407908)],
        &[(0b10010, &ENTRY_UNTECHNICALIZES_12316354131512359)],
        &[(0b01001, &ENTRY_UNTECHNICALIZE_7661502502654407908)],
        &[(0b01001, &ENTRY_UNTECHNICALIZES_12316354131512359)],
        &[(0b10010, &ENTRY_UNTEMPORIZING_10262279498666537398)],
        &[(0b10010, &ENTRY_UNTEMPORIZINGS_10863617418556326800)],
        &[(0b01001, &ENTRY_UNTEMPORIZING_10262279498666537398)],
        &[(0b01001, &ENTRY_UNTEMPORIZINGS_10863617418556326800)],
        &[(0b10010, &ENTRY_UNTERRORIZED_11223502884976171489)],
        &[(0b01001, &ENTRY_UNTERRORIZED_11223502884976171489)],
        &[(0b10010, &ENTRY_UNTHEORIZABLE_240618649580760361)],
        &[(0b10010, &ENTRY_UNTHEORIZABLES_13870769123827938921)],
        &[(0b01001, &ENTRY_UNTHEORIZABLE_240618649580760361)],
        &[(0b01001, &ENTRY_UNTHEORIZABLES_13870769123827938921)],
        &[(0b00001, &ENTRY_UNTRAMMELED_549579090643891681)],
        &[(0b00001, &ENTRY_UNTRAMMELEDDER_378198885203754532)],
        &[(0b00001, &ENTRY_UNTRAMMELEDDEST_15285162208707661637)],
        &[(0b11010, &ENTRY_UNTRAMMELED_549579090643891681)],
        &[(0b11010, &ENTRY_UNTRAMMELEDDER_378198885203754532)],
        &[(0b11010, &ENTRY_UNTRAMMELEDDEST_15285162208707661637)],
        &[(0b10010, &ENTRY_UNTRANQUILIZED_14631448086878067814)],
        &[(0b01001, &ENTRY_UNTRANQUILIZED_14631448086878067814)],
        &[(0b10010, &ENTRY_UNTRANQUILLIZE_528996477809981689)],
        &[(0b10010, &ENTRY_UNTRANQUILLIZED_3970525452077680048)],
        &[(0b01001, &ENTRY_UNTRANQUILLIZE_528996477809981689)],
        &[(0b01001, &ENTRY_UNTRANQUILLIZED_3970525452077680048)],
        &[(0b10010, &ENTRY_UNTYRANNIZED_8862669867305834720)],
        &[(0b01001, &ENTRY_UNTYRANNIZED_8862669867305834720)],
    ],
    range: 8..=13,
};

static VARS_UNS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UNS_CHILDREN),
    value: None,
};

static VARS_UNS_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_UNSA_NODE),
    None,
    Some(&VARS_UNSC_NODE),
    None,
    Some(&VARS_UNSE_NODE),
    None,
    None,
    Some(&VARS_UNSH_NODE),
    Some(&VARS_UNSI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UNSO_NODE),
    Some(&VARS_UNSP_NODE),
    None,
    None,
    None,
    Some(&VARS_UNST_NODE),
    Some(&VARS_UNSU_NODE),
    None,
    None,
    None,
    Some(&VARS_UNSY_NODE),
    None,
];

static VARS_UNSY_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UNSY_CHILDREN),
    value: None,
};

static VARS_UNSY_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UNSYM_NODE),
    Some(&VARS_UNSYN_NODE),
    None,
    Some(&VARS_UNSYP_NODE),
    None,
    None,
    Some(&VARS_UNSYS_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_UNSYS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNSYS_CHILDREN),
    value: None,
};

pub static VARS_UNSYS_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("tematised"),
        dictgen::InsensitiveStr::Ascii("tematisedder"),
        dictgen::InsensitiveStr::Ascii("tematiseddest"),
        dictgen::InsensitiveStr::Ascii("tematisedly"),
        dictgen::InsensitiveStr::Ascii("tematising"),
        dictgen::InsensitiveStr::Ascii("tematisinger"),
        dictgen::InsensitiveStr::Ascii("tematisingest"),
        dictgen::InsensitiveStr::Ascii("tematized"),
        dictgen::InsensitiveStr::Ascii("tematizedder"),
        dictgen::InsensitiveStr::Ascii("tematizeddest"),
        dictgen::InsensitiveStr::Ascii("tematizedly"),
        dictgen::InsensitiveStr::Ascii("tematizing"),
        dictgen::InsensitiveStr::Ascii("tematizinger"),
        dictgen::InsensitiveStr::Ascii("tematizingest"),
        dictgen::InsensitiveStr::Ascii("temisable"),
        dictgen::InsensitiveStr::Ascii("temisables"),
        dictgen::InsensitiveStr::Ascii("temizable"),
        dictgen::InsensitiveStr::Ascii("temizables"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNSYSTEMATIZED_14502428691598864878)],
        &[(0b10010, &ENTRY_UNSYSTEMATIZEDDER_9189788093098370830)],
        &[(0b10010, &ENTRY_UNSYSTEMATIZEDDEST_1207211808530410942)],
        &[(0b10010, &ENTRY_UNSYSTEMATIZEDLY_4862881584760401398)],
        &[(0b10010, &ENTRY_UNSYSTEMATIZING_14753078560276504217)],
        &[(0b10010, &ENTRY_UNSYSTEMATIZINGER_15925085597038328684)],
        &[(0b10010, &ENTRY_UNSYSTEMATIZINGEST_5589507975482695103)],
        &[(0b01001, &ENTRY_UNSYSTEMATIZED_14502428691598864878)],
        &[(0b01001, &ENTRY_UNSYSTEMATIZEDDER_9189788093098370830)],
        &[(0b01001, &ENTRY_UNSYSTEMATIZEDDEST_1207211808530410942)],
        &[(0b01001, &ENTRY_UNSYSTEMATIZEDLY_4862881584760401398)],
        &[(0b01001, &ENTRY_UNSYSTEMATIZING_14753078560276504217)],
        &[(0b01001, &ENTRY_UNSYSTEMATIZINGER_15925085597038328684)],
        &[(0b01001, &ENTRY_UNSYSTEMATIZINGEST_5589507975482695103)],
        &[(0b10010, &ENTRY_UNSYSTEMIZABLE_6445655941220298236)],
        &[(0b10010, &ENTRY_UNSYSTEMIZABLES_11770476614828889053)],
        &[(0b01001, &ENTRY_UNSYSTEMIZABLE_6445655941220298236)],
        &[(0b01001, &ENTRY_UNSYSTEMIZABLES_11770476614828889053)],
    ],
    range: 9..=13,
};

static VARS_UNSYP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNSYP_CHILDREN),
    value: None,
};

pub static VARS_UNSYP_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hon"),
        dictgen::InsensitiveStr::Ascii("hons"),
    ],
    values: &[
        &[(0b11010, &ENTRY_UNSIPHON_8751298592164441841)],
        &[(0b11010, &ENTRY_UNSIPHONS_6487069638314844152)],
    ],
    range: 3..=4,
};

static VARS_UNSYN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNSYN_CHILDREN),
    value: None,
};

pub static VARS_UNSYN_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("chronised"),
        dictgen::InsensitiveStr::Ascii("chronisedder"),
        dictgen::InsensitiveStr::Ascii("chroniseddest"),
        dictgen::InsensitiveStr::Ascii("chronized"),
        dictgen::InsensitiveStr::Ascii("chronizedder"),
        dictgen::InsensitiveStr::Ascii("chronizeddest"),
        dictgen::InsensitiveStr::Ascii("thesised"),
        dictgen::InsensitiveStr::Ascii("thesisedder"),
        dictgen::InsensitiveStr::Ascii("thesiseddest"),
        dictgen::InsensitiveStr::Ascii("thesized"),
        dictgen::InsensitiveStr::Ascii("thesizedder"),
        dictgen::InsensitiveStr::Ascii("thesizeddest"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNSYNCHRONIZED_15906225482447601414)],
        &[(0b10010, &ENTRY_UNSYNCHRONIZEDDER_17711872826708633465)],
        &[(0b10010, &ENTRY_UNSYNCHRONIZEDDEST_8914833530283816809)],
        &[(0b01001, &ENTRY_UNSYNCHRONIZED_15906225482447601414)],
        &[(0b01001, &ENTRY_UNSYNCHRONIZEDDER_17711872826708633465)],
        &[(0b01001, &ENTRY_UNSYNCHRONIZEDDEST_8914833530283816809)],
        &[(0b10010, &ENTRY_UNSYNTHESIZED_873390520484748283)],
        &[(0b10010, &ENTRY_UNSYNTHESIZEDDER_47988453461239108)],
        &[(0b10010, &ENTRY_UNSYNTHESIZEDDEST_7437594407505325426)],
        &[(0b01001, &ENTRY_UNSYNTHESIZED_873390520484748283)],
        &[(0b01001, &ENTRY_UNSYNTHESIZEDDER_47988453461239108)],
        &[(0b01001, &ENTRY_UNSYNTHESIZEDDEST_7437594407505325426)],
    ],
    range: 8..=13,
};

static VARS_UNSYM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNSYM_CHILDREN),
    value: None,
};

pub static VARS_UNSYM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bolised"),
        dictgen::InsensitiveStr::Ascii("bolisedder"),
        dictgen::InsensitiveStr::Ascii("boliseddest"),
        dictgen::InsensitiveStr::Ascii("bolized"),
        dictgen::InsensitiveStr::Ascii("bolizedder"),
        dictgen::InsensitiveStr::Ascii("bolizeddest"),
        dictgen::InsensitiveStr::Ascii("metrised"),
        dictgen::InsensitiveStr::Ascii("metriseds"),
        dictgen::InsensitiveStr::Ascii("metrized"),
        dictgen::InsensitiveStr::Ascii("metrizeds"),
        dictgen::InsensitiveStr::Ascii("pathisabilities"),
        dictgen::InsensitiveStr::Ascii("pathisability"),
        dictgen::InsensitiveStr::Ascii("pathisable"),
        dictgen::InsensitiveStr::Ascii("pathisables"),
        dictgen::InsensitiveStr::Ascii("pathised"),
        dictgen::InsensitiveStr::Ascii("pathisedder"),
        dictgen::InsensitiveStr::Ascii("pathiseddest"),
        dictgen::InsensitiveStr::Ascii("pathising"),
        dictgen::InsensitiveStr::Ascii("pathisinger"),
        dictgen::InsensitiveStr::Ascii("pathisingest"),
        dictgen::InsensitiveStr::Ascii("pathisinglier"),
        dictgen::InsensitiveStr::Ascii("pathisingliest"),
        dictgen::InsensitiveStr::Ascii("pathisingly"),
        dictgen::InsensitiveStr::Ascii("pathisings"),
        dictgen::InsensitiveStr::Ascii("pathizabilities"),
        dictgen::InsensitiveStr::Ascii("pathizability"),
        dictgen::InsensitiveStr::Ascii("pathizable"),
        dictgen::InsensitiveStr::Ascii("pathizables"),
        dictgen::InsensitiveStr::Ascii("pathized"),
        dictgen::InsensitiveStr::Ascii("pathizedder"),
        dictgen::InsensitiveStr::Ascii("pathizeddest"),
        dictgen::InsensitiveStr::Ascii("pathizing"),
        dictgen::InsensitiveStr::Ascii("pathizinger"),
        dictgen::InsensitiveStr::Ascii("pathizingest"),
        dictgen::InsensitiveStr::Ascii("pathizinglier"),
        dictgen::InsensitiveStr::Ascii("pathizingliest"),
        dictgen::InsensitiveStr::Ascii("pathizingly"),
        dictgen::InsensitiveStr::Ascii("pathizings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNSYMBOLIZED_4998866146418175348)],
        &[(0b10010, &ENTRY_UNSYMBOLIZEDDER_2693121694591055898)],
        &[(0b10010, &ENTRY_UNSYMBOLIZEDDEST_5688633199932414339)],
        &[(0b01001, &ENTRY_UNSYMBOLIZED_4998866146418175348)],
        &[(0b01001, &ENTRY_UNSYMBOLIZEDDER_2693121694591055898)],
        &[(0b01001, &ENTRY_UNSYMBOLIZEDDEST_5688633199932414339)],
        &[(0b10010, &ENTRY_UNSYMMETRIZED_2416221991577506354)],
        &[(0b10010, &ENTRY_UNSYMMETRIZEDS_17526612862547781039)],
        &[(0b01001, &ENTRY_UNSYMMETRIZED_2416221991577506354)],
        &[(0b01001, &ENTRY_UNSYMMETRIZEDS_17526612862547781039)],
        &[(0b10010, &ENTRY_UNSYMPATHIZABILITIES_5599344496922194828)],
        &[(0b10010, &ENTRY_UNSYMPATHIZABILITY_15552727085219653687)],
        &[(0b10010, &ENTRY_UNSYMPATHIZABLE_6116127447209370164)],
        &[(0b10010, &ENTRY_UNSYMPATHIZABLES_6750873272065181147)],
        &[(0b10010, &ENTRY_UNSYMPATHIZED_7172788372988396436)],
        &[(0b10010, &ENTRY_UNSYMPATHIZEDDER_12857460593078230378)],
        &[(0b10010, &ENTRY_UNSYMPATHIZEDDEST_11795335826469372906)],
        &[(0b10010, &ENTRY_UNSYMPATHIZING_8602889408813208422)],
        &[(0b10010, &ENTRY_UNSYMPATHIZINGER_4506075109833611910)],
        &[(0b10010, &ENTRY_UNSYMPATHIZINGEST_13474971300491840553)],
        &[(0b10010, &ENTRY_UNSYMPATHIZINGLIER_7139683093102134643)],
        &[(0b10010, &ENTRY_UNSYMPATHIZINGLIEST_6904483674657551040)],
        &[(0b10010, &ENTRY_UNSYMPATHIZINGLY_10367834800272884249)],
        &[(0b10010, &ENTRY_UNSYMPATHIZINGS_4389760301799797231)],
        &[(0b01001, &ENTRY_UNSYMPATHIZABILITIES_5599344496922194828)],
        &[(0b01001, &ENTRY_UNSYMPATHIZABILITY_15552727085219653687)],
        &[(0b01001, &ENTRY_UNSYMPATHIZABLE_6116127447209370164)],
        &[(0b01001, &ENTRY_UNSYMPATHIZABLES_6750873272065181147)],
        &[(0b01001, &ENTRY_UNSYMPATHIZED_7172788372988396436)],
        &[(0b01001, &ENTRY_UNSYMPATHIZEDDER_12857460593078230378)],
        &[(0b01001, &ENTRY_UNSYMPATHIZEDDEST_11795335826469372906)],
        &[(0b01001, &ENTRY_UNSYMPATHIZING_8602889408813208422)],
        &[(0b01001, &ENTRY_UNSYMPATHIZINGER_4506075109833611910)],
        &[(0b01001, &ENTRY_UNSYMPATHIZINGEST_13474971300491840553)],
        &[(0b01001, &ENTRY_UNSYMPATHIZINGLIER_7139683093102134643)],
        &[(0b01001, &ENTRY_UNSYMPATHIZINGLIEST_6904483674657551040)],
        &[(0b01001, &ENTRY_UNSYMPATHIZINGLY_10367834800272884249)],
        &[(0b01001, &ENTRY_UNSYMPATHIZINGS_4389760301799797231)],
    ],
    range: 7..=15,
};

static VARS_UNSU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNSU_CHILDREN),
    value: None,
};

pub static VARS_UNSU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bsidised"),
        dictgen::InsensitiveStr::Ascii("bsidized"),
        dictgen::InsensitiveStr::Ascii("bstantialise"),
        dictgen::InsensitiveStr::Ascii("bstantialised"),
        dictgen::InsensitiveStr::Ascii("bstantialises"),
        dictgen::InsensitiveStr::Ascii("bstantialising"),
        dictgen::InsensitiveStr::Ascii("bstantialize"),
        dictgen::InsensitiveStr::Ascii("bstantialized"),
        dictgen::InsensitiveStr::Ascii("bstantializes"),
        dictgen::InsensitiveStr::Ascii("bstantializing"),
        dictgen::InsensitiveStr::Ascii("ccorable"),
        dictgen::InsensitiveStr::Ascii("ccorables"),
        dictgen::InsensitiveStr::Ascii("ccored"),
        dictgen::InsensitiveStr::Ascii("ccourable"),
        dictgen::InsensitiveStr::Ascii("ccourables"),
        dictgen::InsensitiveStr::Ascii("ccoured"),
        dictgen::InsensitiveStr::Ascii("lphurised"),
        dictgen::InsensitiveStr::Ascii("lphuriseds"),
        dictgen::InsensitiveStr::Ascii("lphurized"),
        dictgen::InsensitiveStr::Ascii("lphurizeds"),
        dictgen::InsensitiveStr::Ascii("mmarisable"),
        dictgen::InsensitiveStr::Ascii("mmarised"),
        dictgen::InsensitiveStr::Ascii("mmarisedder"),
        dictgen::InsensitiveStr::Ascii("mmariseddest"),
        dictgen::InsensitiveStr::Ascii("mmarizable"),
        dictgen::InsensitiveStr::Ascii("mmarized"),
        dictgen::InsensitiveStr::Ascii("mmarizedder"),
        dictgen::InsensitiveStr::Ascii("mmarizeddest"),
        dictgen::InsensitiveStr::Ascii("pernaturalise"),
        dictgen::InsensitiveStr::Ascii("pernaturalised"),
        dictgen::InsensitiveStr::Ascii("pernaturalises"),
        dictgen::InsensitiveStr::Ascii("pernaturalize"),
        dictgen::InsensitiveStr::Ascii("pernaturalized"),
        dictgen::InsensitiveStr::Ascii("pernaturalizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNSUBSIDIZED_8506816544552198394)],
        &[(0b01001, &ENTRY_UNSUBSIDIZED_8506816544552198394)],
        &[(0b10010, &ENTRY_UNSUBSTANTIALIZE_18383570451437119535)],
        &[(0b10010, &ENTRY_UNSUBSTANTIALIZED_16036110466855036195)],
        &[(0b10010, &ENTRY_UNSUBSTANTIALIZES_16871510027185551366)],
        &[(0b10010, &ENTRY_UNSUBSTANTIALIZING_2121724985901297893)],
        &[(0b01001, &ENTRY_UNSUBSTANTIALIZE_18383570451437119535)],
        &[(0b01001, &ENTRY_UNSUBSTANTIALIZED_16036110466855036195)],
        &[(0b01001, &ENTRY_UNSUBSTANTIALIZES_16871510027185551366)],
        &[(0b01001, &ENTRY_UNSUBSTANTIALIZING_2121724985901297893)],
        &[(0b00001, &ENTRY_UNSUCCORABLE_12673763242696709684)],
        &[(0b00001, &ENTRY_UNSUCCORABLES_739989955870419064)],
        &[(0b00001, &ENTRY_UNSUCCORED_2160594171074318544)],
        &[(0b11010, &ENTRY_UNSUCCORABLE_12673763242696709684)],
        &[(0b11010, &ENTRY_UNSUCCORABLES_739989955870419064)],
        &[(0b11010, &ENTRY_UNSUCCORED_2160594171074318544)],
        &[(0b10010, &ENTRY_UNSULPHURIZED_4398458517942042949)],
        &[(0b10010, &ENTRY_UNSULPHURIZEDS_10925557470603907058)],
        &[(0b01001, &ENTRY_UNSULPHURIZED_4398458517942042949)],
        &[(0b01001, &ENTRY_UNSULPHURIZEDS_10925557470603907058)],
        &[(0b10010, &ENTRY_UNSUMMARIZABLE_4893860010982930453)],
        &[(0b10010, &ENTRY_UNSUMMARIZED_836436980612704819)],
        &[(0b10010, &ENTRY_UNSUMMARIZEDDER_17857459577512226536)],
        &[(0b10010, &ENTRY_UNSUMMARIZEDDEST_13958313582918609397)],
        &[(0b01001, &ENTRY_UNSUMMARIZABLE_4893860010982930453)],
        &[(0b01001, &ENTRY_UNSUMMARIZED_836436980612704819)],
        &[(0b01001, &ENTRY_UNSUMMARIZEDDER_17857459577512226536)],
        &[(0b01001, &ENTRY_UNSUMMARIZEDDEST_13958313582918609397)],
        &[(0b10010, &ENTRY_UNSUPERNATURALIZE_11379677666614455606)],
        &[(0b10010, &ENTRY_UNSUPERNATURALIZED_13742104250862639914)],
        &[(0b10010, &ENTRY_UNSUPERNATURALIZES_11514791653627540421)],
        &[(0b01001, &ENTRY_UNSUPERNATURALIZE_11379677666614455606)],
        &[(0b01001, &ENTRY_UNSUPERNATURALIZED_13742104250862639914)],
        &[(0b01001, &ENTRY_UNSUPERNATURALIZES_11514791653627540421)],
    ],
    range: 6..=14,
};

static VARS_UNST_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNST_CHILDREN),
    value: None,
};

pub static VARS_UNST_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("abilised"),
        dictgen::InsensitiveStr::Ascii("abilising"),
        dictgen::InsensitiveStr::Ascii("abilized"),
        dictgen::InsensitiveStr::Ascii("abilizing"),
        dictgen::InsensitiveStr::Ascii("andardisable"),
        dictgen::InsensitiveStr::Ascii("andardised"),
        dictgen::InsensitiveStr::Ascii("andardisedder"),
        dictgen::InsensitiveStr::Ascii("andardiseddest"),
        dictgen::InsensitiveStr::Ascii("andardizable"),
        dictgen::InsensitiveStr::Ascii("andardized"),
        dictgen::InsensitiveStr::Ascii("andardizedder"),
        dictgen::InsensitiveStr::Ascii("andardizeddest"),
        dictgen::InsensitiveStr::Ascii("erilised"),
        dictgen::InsensitiveStr::Ascii("erilized"),
        dictgen::InsensitiveStr::Ascii("igmatised"),
        dictgen::InsensitiveStr::Ascii("igmatisedder"),
        dictgen::InsensitiveStr::Ascii("igmatiseddest"),
        dictgen::InsensitiveStr::Ascii("igmatiseds"),
        dictgen::InsensitiveStr::Ascii("igmatized"),
        dictgen::InsensitiveStr::Ascii("igmatizedder"),
        dictgen::InsensitiveStr::Ascii("igmatizeddest"),
        dictgen::InsensitiveStr::Ascii("igmatizeds"),
        dictgen::InsensitiveStr::Ascii("oicise"),
        dictgen::InsensitiveStr::Ascii("oicises"),
        dictgen::InsensitiveStr::Ascii("oicize"),
        dictgen::InsensitiveStr::Ascii("oicizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNSTABILIZED_1384046979087471144)],
        &[(0b10010, &ENTRY_UNSTABILIZING_9105210657283981291)],
        &[(0b01001, &ENTRY_UNSTABILIZED_1384046979087471144)],
        &[(0b01001, &ENTRY_UNSTABILIZING_9105210657283981291)],
        &[(0b10010, &ENTRY_UNSTANDARDIZABLE_3986051184822450887)],
        &[(0b10010, &ENTRY_UNSTANDARDIZED_1272352641434012090)],
        &[(0b10010, &ENTRY_UNSTANDARDIZEDDER_3995682174766736068)],
        &[(0b10010, &ENTRY_UNSTANDARDIZEDDEST_11035827645803141662)],
        &[(0b01001, &ENTRY_UNSTANDARDIZABLE_3986051184822450887)],
        &[(0b01001, &ENTRY_UNSTANDARDIZED_1272352641434012090)],
        &[(0b01001, &ENTRY_UNSTANDARDIZEDDER_3995682174766736068)],
        &[(0b01001, &ENTRY_UNSTANDARDIZEDDEST_11035827645803141662)],
        &[(0b10010, &ENTRY_UNSTERILIZED_13156342258367971107)],
        &[(0b01001, &ENTRY_UNSTERILIZED_13156342258367971107)],
        &[(0b10010, &ENTRY_UNSTIGMATIZED_8147628030660872313)],
        &[(0b10010, &ENTRY_UNSTIGMATIZEDDER_12103644335044897212)],
        &[(0b10010, &ENTRY_UNSTIGMATIZEDDEST_5756983753240929122)],
        &[(0b10010, &ENTRY_UNSTIGMATIZEDS_179009940195529442)],
        &[(0b01001, &ENTRY_UNSTIGMATIZED_8147628030660872313)],
        &[(0b01001, &ENTRY_UNSTIGMATIZEDDER_12103644335044897212)],
        &[(0b01001, &ENTRY_UNSTIGMATIZEDDEST_5756983753240929122)],
        &[(0b01001, &ENTRY_UNSTIGMATIZEDS_179009940195529442)],
        &[(0b10010, &ENTRY_UNSTOICIZE_15130563685517702536)],
        &[(0b10010, &ENTRY_UNSTOICIZES_3633881140952142304)],
        &[(0b01001, &ENTRY_UNSTOICIZE_15130563685517702536)],
        &[(0b01001, &ENTRY_UNSTOICIZES_3633881140952142304)],
    ],
    range: 6..=14,
};

static VARS_UNSP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNSP_CHILDREN),
    value: None,
};

pub static VARS_UNSP_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ecialised"),
        dictgen::InsensitiveStr::Ascii("ecialisedder"),
        dictgen::InsensitiveStr::Ascii("ecialiseddest"),
        dictgen::InsensitiveStr::Ascii("ecialising"),
        dictgen::InsensitiveStr::Ascii("ecialisinger"),
        dictgen::InsensitiveStr::Ascii("ecialisingest"),
        dictgen::InsensitiveStr::Ascii("ecialized"),
        dictgen::InsensitiveStr::Ascii("ecializedder"),
        dictgen::InsensitiveStr::Ascii("ecializeddest"),
        dictgen::InsensitiveStr::Ascii("ecializing"),
        dictgen::InsensitiveStr::Ascii("ecializinger"),
        dictgen::InsensitiveStr::Ascii("ecializingest"),
        dictgen::InsensitiveStr::Ascii("ecterlike"),
        dictgen::InsensitiveStr::Ascii("ecterlikes"),
        dictgen::InsensitiveStr::Ascii("ectrelike"),
        dictgen::InsensitiveStr::Ascii("ectrelikes"),
        dictgen::InsensitiveStr::Ascii("iritualise"),
        dictgen::InsensitiveStr::Ascii("iritualised"),
        dictgen::InsensitiveStr::Ascii("iritualises"),
        dictgen::InsensitiveStr::Ascii("iritualising"),
        dictgen::InsensitiveStr::Ascii("iritualize"),
        dictgen::InsensitiveStr::Ascii("iritualized"),
        dictgen::InsensitiveStr::Ascii("iritualizes"),
        dictgen::InsensitiveStr::Ascii("iritualizing"),
        dictgen::InsensitiveStr::Ascii("lendorous"),
        dictgen::InsensitiveStr::Ascii("lendorously"),
        dictgen::InsensitiveStr::Ascii("lendourous"),
        dictgen::InsensitiveStr::Ascii("lendourously"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNSPECIALIZED_16921915094468110795)],
        &[(0b10010, &ENTRY_UNSPECIALIZEDDER_14482979627473921525)],
        &[(0b10010, &ENTRY_UNSPECIALIZEDDEST_7579806759888561816)],
        &[(0b10010, &ENTRY_UNSPECIALIZING_870209529926883549)],
        &[(0b10010, &ENTRY_UNSPECIALIZINGER_10541176028877396187)],
        &[(0b10010, &ENTRY_UNSPECIALIZINGEST_13963040120295765584)],
        &[(0b01001, &ENTRY_UNSPECIALIZED_16921915094468110795)],
        &[(0b01001, &ENTRY_UNSPECIALIZEDDER_14482979627473921525)],
        &[(0b01001, &ENTRY_UNSPECIALIZEDDEST_7579806759888561816)],
        &[(0b01001, &ENTRY_UNSPECIALIZING_870209529926883549)],
        &[(0b01001, &ENTRY_UNSPECIALIZINGER_10541176028877396187)],
        &[(0b01001, &ENTRY_UNSPECIALIZINGEST_13963040120295765584)],
        &[(0b00001, &ENTRY_UNSPECTERLIKE_15729881691571605322)],
        &[(0b00001, &ENTRY_UNSPECTERLIKES_12569940984145654311)],
        &[(0b11010, &ENTRY_UNSPECTERLIKE_15729881691571605322)],
        &[(0b11010, &ENTRY_UNSPECTERLIKES_12569940984145654311)],
        &[(0b10010, &ENTRY_UNSPIRITUALIZE_5916555052861323400)],
        &[(0b10010, &ENTRY_UNSPIRITUALIZED_13793878683851952015)],
        &[(0b10010, &ENTRY_UNSPIRITUALIZES_13159558072175914180)],
        &[(0b10010, &ENTRY_UNSPIRITUALIZING_17178897114095131956)],
        &[(0b01001, &ENTRY_UNSPIRITUALIZE_5916555052861323400)],
        &[(0b01001, &ENTRY_UNSPIRITUALIZED_13793878683851952015)],
        &[(0b01001, &ENTRY_UNSPIRITUALIZES_13159558072175914180)],
        &[(0b01001, &ENTRY_UNSPIRITUALIZING_17178897114095131956)],
        &[(0b00001, &ENTRY_UNSPLENDOROUS_15638368483821854285)],
        &[(0b00001, &ENTRY_UNSPLENDOROUSLY_11800106086712842867)],
        &[(0b11010, &ENTRY_UNSPLENDOROUS_15638368483821854285)],
        &[(0b11010, &ENTRY_UNSPLENDOROUSLY_11800106086712842867)],
    ],
    range: 9..=13,
};

static VARS_UNSO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNSO_CHILDREN),
    value: None,
};

pub static VARS_UNSO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cialised"),
        dictgen::InsensitiveStr::Ascii("cialisedder"),
        dictgen::InsensitiveStr::Ascii("cialiseddest"),
        dictgen::InsensitiveStr::Ascii("cialising"),
        dictgen::InsensitiveStr::Ascii("cialized"),
        dictgen::InsensitiveStr::Ascii("cializedder"),
        dictgen::InsensitiveStr::Ascii("cializeddest"),
        dictgen::InsensitiveStr::Ascii("cializing"),
        dictgen::InsensitiveStr::Ascii("lemnise"),
        dictgen::InsensitiveStr::Ascii("lemnised"),
        dictgen::InsensitiveStr::Ascii("lemnisedder"),
        dictgen::InsensitiveStr::Ascii("lemniseddest"),
        dictgen::InsensitiveStr::Ascii("lemnises"),
        dictgen::InsensitiveStr::Ascii("lemnize"),
        dictgen::InsensitiveStr::Ascii("lemnized"),
        dictgen::InsensitiveStr::Ascii("lemnizedder"),
        dictgen::InsensitiveStr::Ascii("lemnizeddest"),
        dictgen::InsensitiveStr::Ascii("lemnizes"),
        dictgen::InsensitiveStr::Ascii("mber"),
        dictgen::InsensitiveStr::Ascii("mberly"),
        dictgen::InsensitiveStr::Ascii("mberness"),
        dictgen::InsensitiveStr::Ascii("mbre"),
        dictgen::InsensitiveStr::Ascii("mbrely"),
        dictgen::InsensitiveStr::Ascii("mbreness"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNSOCIALIZED_3496138542165260759)],
        &[(0b10010, &ENTRY_UNSOCIALIZEDDER_10880141521153969743)],
        &[(0b10010, &ENTRY_UNSOCIALIZEDDEST_4448774529600758329)],
        &[(0b10010, &ENTRY_UNSOCIALIZING_8509052272131880502)],
        &[(0b01001, &ENTRY_UNSOCIALIZED_3496138542165260759)],
        &[(0b01001, &ENTRY_UNSOCIALIZEDDER_10880141521153969743)],
        &[(0b01001, &ENTRY_UNSOCIALIZEDDEST_4448774529600758329)],
        &[(0b01001, &ENTRY_UNSOCIALIZING_8509052272131880502)],
        &[(0b10010, &ENTRY_UNSOLEMNIZE_17754689905088315837)],
        &[(0b10010, &ENTRY_UNSOLEMNIZED_13405781150896516414)],
        &[(0b10010, &ENTRY_UNSOLEMNIZEDDER_12639019762331536413)],
        &[(0b10010, &ENTRY_UNSOLEMNIZEDDEST_9414390961190285845)],
        &[(0b10010, &ENTRY_UNSOLEMNIZES_3236564255173918334)],
        &[(0b01001, &ENTRY_UNSOLEMNIZE_17754689905088315837)],
        &[(0b01001, &ENTRY_UNSOLEMNIZED_13405781150896516414)],
        &[(0b01001, &ENTRY_UNSOLEMNIZEDDER_12639019762331536413)],
        &[(0b01001, &ENTRY_UNSOLEMNIZEDDEST_9414390961190285845)],
        &[(0b01001, &ENTRY_UNSOLEMNIZES_3236564255173918334)],
        &[(0b00001, &ENTRY_UNSOMBER_9849015273292267538)],
        &[(0b00001, &ENTRY_UNSOMBERLY_3720066922443442116)],
        &[(0b00001, &ENTRY_UNSOMBERNESS_5229571241405215642)],
        &[(0b11010, &ENTRY_UNSOMBER_9849015273292267538)],
        &[(0b11010, &ENTRY_UNSOMBERLY_3720066922443442116)],
        &[(0b11010, &ENTRY_UNSOMBERNESS_5229571241405215642)],
    ],
    range: 4..=12,
};

static VARS_UNSI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNSI_CHILDREN),
    value: None,
};

pub static VARS_UNSI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gnalised"),
        dictgen::InsensitiveStr::Ascii("gnalisedder"),
        dictgen::InsensitiveStr::Ascii("gnaliseddest"),
        dictgen::InsensitiveStr::Ascii("gnaliseds"),
        dictgen::InsensitiveStr::Ascii("gnalized"),
        dictgen::InsensitiveStr::Ascii("gnalizedder"),
        dictgen::InsensitiveStr::Ascii("gnalizeddest"),
        dictgen::InsensitiveStr::Ascii("gnalizeds"),
        dictgen::InsensitiveStr::Ascii("phon"),
        dictgen::InsensitiveStr::Ascii("phons"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNSIGNALIZED_18072380712584870147)],
        &[(0b10010, &ENTRY_UNSIGNALIZEDDER_2263217046824972534)],
        &[(0b10010, &ENTRY_UNSIGNALIZEDDEST_14758681485610426786)],
        &[(0b10010, &ENTRY_UNSIGNALIZEDS_8158537188065551521)],
        &[(0b01001, &ENTRY_UNSIGNALIZED_18072380712584870147)],
        &[(0b01001, &ENTRY_UNSIGNALIZEDDER_2263217046824972534)],
        &[(0b01001, &ENTRY_UNSIGNALIZEDDEST_14758681485610426786)],
        &[(0b01001, &ENTRY_UNSIGNALIZEDS_8158537188065551521)],
        &[(0b00001, &ENTRY_UNSIPHON_8751298592164441841)],
        &[(0b00001, &ENTRY_UNSIPHONS_6487069638314844152)],
    ],
    range: 4..=12,
};

static VARS_UNSH_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNSH_CHILDREN),
    value: None,
};

pub static VARS_UNSH_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("oed"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNSHED_1748678126240642191)],
        &[(0b11010, &ENTRY_UNSHED_1748678126240642191)],
    ],
    range: 2..=3,
};

static VARS_UNSE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNSE_CHILDREN),
    value: None,
};

pub static VARS_UNSE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ctarianise"),
        dictgen::InsensitiveStr::Ascii("ctarianises"),
        dictgen::InsensitiveStr::Ascii("ctarianize"),
        dictgen::InsensitiveStr::Ascii("ctarianizes"),
        dictgen::InsensitiveStr::Ascii("ctionalised"),
        dictgen::InsensitiveStr::Ascii("ctionalized"),
        dictgen::InsensitiveStr::Ascii("cularise"),
        dictgen::InsensitiveStr::Ascii("cularised"),
        dictgen::InsensitiveStr::Ascii("cularisedder"),
        dictgen::InsensitiveStr::Ascii("culariseddest"),
        dictgen::InsensitiveStr::Ascii("cularises"),
        dictgen::InsensitiveStr::Ascii("cularize"),
        dictgen::InsensitiveStr::Ascii("cularized"),
        dictgen::InsensitiveStr::Ascii("cularizedder"),
        dictgen::InsensitiveStr::Ascii("cularizeddest"),
        dictgen::InsensitiveStr::Ascii("cularizes"),
        dictgen::InsensitiveStr::Ascii("nsitise"),
        dictgen::InsensitiveStr::Ascii("nsitised"),
        dictgen::InsensitiveStr::Ascii("nsitises"),
        dictgen::InsensitiveStr::Ascii("nsitising"),
        dictgen::InsensitiveStr::Ascii("nsitize"),
        dictgen::InsensitiveStr::Ascii("nsitized"),
        dictgen::InsensitiveStr::Ascii("nsitizes"),
        dictgen::InsensitiveStr::Ascii("nsitizing"),
        dictgen::InsensitiveStr::Ascii("nsualise"),
        dictgen::InsensitiveStr::Ascii("nsualised"),
        dictgen::InsensitiveStr::Ascii("nsualises"),
        dictgen::InsensitiveStr::Ascii("nsualising"),
        dictgen::InsensitiveStr::Ascii("nsualize"),
        dictgen::InsensitiveStr::Ascii("nsualized"),
        dictgen::InsensitiveStr::Ascii("nsualizes"),
        dictgen::InsensitiveStr::Ascii("nsualizing"),
        dictgen::InsensitiveStr::Ascii("ntimentalise"),
        dictgen::InsensitiveStr::Ascii("ntimentalised"),
        dictgen::InsensitiveStr::Ascii("ntimentalises"),
        dictgen::InsensitiveStr::Ascii("ntimentalize"),
        dictgen::InsensitiveStr::Ascii("ntimentalized"),
        dictgen::InsensitiveStr::Ascii("ntimentalizes"),
        dictgen::InsensitiveStr::Ascii("pulcher"),
        dictgen::InsensitiveStr::Ascii("pulchered"),
        dictgen::InsensitiveStr::Ascii("pulchers"),
        dictgen::InsensitiveStr::Ascii("pulchre"),
        dictgen::InsensitiveStr::Ascii("pulchred"),
        dictgen::InsensitiveStr::Ascii("pulchres"),
        dictgen::InsensitiveStr::Ascii("rialised"),
        dictgen::InsensitiveStr::Ascii("rialized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNSECTARIANIZE_8896277406677200944)],
        &[(0b10010, &ENTRY_UNSECTARIANIZES_17346999740171237029)],
        &[(0b01001, &ENTRY_UNSECTARIANIZE_8896277406677200944)],
        &[(0b01001, &ENTRY_UNSECTARIANIZES_17346999740171237029)],
        &[(0b10010, &ENTRY_UNSECTIONALIZED_5425065226264728201)],
        &[(0b01001, &ENTRY_UNSECTIONALIZED_5425065226264728201)],
        &[(0b10010, &ENTRY_UNSECULARIZE_5214216027332443223)],
        &[(0b10010, &ENTRY_UNSECULARIZED_14903658695506748830)],
        &[(0b10010, &ENTRY_UNSECULARIZEDDER_11676957079943780409)],
        &[(0b10010, &ENTRY_UNSECULARIZEDDEST_2864881942285944778)],
        &[(0b10010, &ENTRY_UNSECULARIZES_9891479802659859412)],
        &[(0b01001, &ENTRY_UNSECULARIZE_5214216027332443223)],
        &[(0b01001, &ENTRY_UNSECULARIZED_14903658695506748830)],
        &[(0b01001, &ENTRY_UNSECULARIZEDDER_11676957079943780409)],
        &[(0b01001, &ENTRY_UNSECULARIZEDDEST_2864881942285944778)],
        &[(0b01001, &ENTRY_UNSECULARIZES_9891479802659859412)],
        &[(0b10010, &ENTRY_UNSENSITIZE_10205463848604074076)],
        &[(0b10010, &ENTRY_UNSENSITIZED_7794134976310825921)],
        &[(0b10010, &ENTRY_UNSENSITIZES_5803069635824140326)],
        &[(0b10010, &ENTRY_UNSENSITIZING_5882427315960709496)],
        &[(0b01001, &ENTRY_UNSENSITIZE_10205463848604074076)],
        &[(0b01001, &ENTRY_UNSENSITIZED_7794134976310825921)],
        &[(0b01001, &ENTRY_UNSENSITIZES_5803069635824140326)],
        &[(0b01001, &ENTRY_UNSENSITIZING_5882427315960709496)],
        &[(0b10010, &ENTRY_UNSENSUALIZE_15769041899106603358)],
        &[(0b10010, &ENTRY_UNSENSUALIZED_32054534269141140)],
        &[(0b10010, &ENTRY_UNSENSUALIZES_12397866517645397490)],
        &[(0b10010, &ENTRY_UNSENSUALIZING_1812813256933634221)],
        &[(0b01001, &ENTRY_UNSENSUALIZE_15769041899106603358)],
        &[(0b01001, &ENTRY_UNSENSUALIZED_32054534269141140)],
        &[(0b01001, &ENTRY_UNSENSUALIZES_12397866517645397490)],
        &[(0b01001, &ENTRY_UNSENSUALIZING_1812813256933634221)],
        &[(0b10010, &ENTRY_UNSENTIMENTALIZE_5597748571008194983)],
        &[(0b10010, &ENTRY_UNSENTIMENTALIZED_6565195653528439940)],
        &[(0b10010, &ENTRY_UNSENTIMENTALIZES_9475174647404255643)],
        &[(0b01001, &ENTRY_UNSENTIMENTALIZE_5597748571008194983)],
        &[(0b01001, &ENTRY_UNSENTIMENTALIZED_6565195653528439940)],
        &[(0b01001, &ENTRY_UNSENTIMENTALIZES_9475174647404255643)],
        &[(0b00001, &ENTRY_UNSEPULCHER_3660018467990610478)],
        &[(0b00001, &ENTRY_UNSEPULCHERED_728988728789570667)],
        &[(0b00001, &ENTRY_UNSEPULCHERS_1679319036273540108)],
        &[(0b11010, &ENTRY_UNSEPULCHER_3660018467990610478)],
        &[(0b11010, &ENTRY_UNSEPULCHERED_728988728789570667)],
        &[(0b11010, &ENTRY_UNSEPULCHERS_1679319036273540108)],
        &[(0b10010, &ENTRY_UNSERIALIZED_14154792643266589843)],
        &[(0b01001, &ENTRY_UNSERIALIZED_14154792643266589843)],
    ],
    range: 7..=13,
};

static VARS_UNSC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNSC_CHILDREN),
    value: None,
};

pub static VARS_UNSC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("andalise"),
        dictgen::InsensitiveStr::Ascii("andalised"),
        dictgen::InsensitiveStr::Ascii("andalisedder"),
        dictgen::InsensitiveStr::Ascii("andaliseddest"),
        dictgen::InsensitiveStr::Ascii("andalises"),
        dictgen::InsensitiveStr::Ascii("andalize"),
        dictgen::InsensitiveStr::Ascii("andalized"),
        dictgen::InsensitiveStr::Ascii("andalizedder"),
        dictgen::InsensitiveStr::Ascii("andalizeddest"),
        dictgen::InsensitiveStr::Ascii("andalizes"),
        dictgen::InsensitiveStr::Ascii("epter"),
        dictgen::InsensitiveStr::Ascii("eptered"),
        dictgen::InsensitiveStr::Ascii("epteredder"),
        dictgen::InsensitiveStr::Ascii("eptereddest"),
        dictgen::InsensitiveStr::Ascii("epters"),
        dictgen::InsensitiveStr::Ascii("eptre"),
        dictgen::InsensitiveStr::Ascii("eptred"),
        dictgen::InsensitiveStr::Ascii("eptredder"),
        dictgen::InsensitiveStr::Ascii("eptreddest"),
        dictgen::InsensitiveStr::Ascii("eptres"),
        dictgen::InsensitiveStr::Ascii("hematised"),
        dictgen::InsensitiveStr::Ascii("hematisedder"),
        dictgen::InsensitiveStr::Ascii("hematiseddest"),
        dictgen::InsensitiveStr::Ascii("hematiseds"),
        dictgen::InsensitiveStr::Ascii("hematized"),
        dictgen::InsensitiveStr::Ascii("hematizedder"),
        dictgen::InsensitiveStr::Ascii("hematizeddest"),
        dictgen::InsensitiveStr::Ascii("hematizeds"),
        dictgen::InsensitiveStr::Ascii("ored"),
        dictgen::InsensitiveStr::Ascii("oring"),
        dictgen::InsensitiveStr::Ascii("oured"),
        dictgen::InsensitiveStr::Ascii("ouring"),
        dictgen::InsensitiveStr::Ascii("rutinised"),
        dictgen::InsensitiveStr::Ascii("rutinisedder"),
        dictgen::InsensitiveStr::Ascii("rutiniseddest"),
        dictgen::InsensitiveStr::Ascii("rutinising"),
        dictgen::InsensitiveStr::Ascii("rutinisinger"),
        dictgen::InsensitiveStr::Ascii("rutinisingest"),
        dictgen::InsensitiveStr::Ascii("rutinisinglier"),
        dictgen::InsensitiveStr::Ascii("rutinisingliest"),
        dictgen::InsensitiveStr::Ascii("rutinisingly"),
        dictgen::InsensitiveStr::Ascii("rutinized"),
        dictgen::InsensitiveStr::Ascii("rutinizedder"),
        dictgen::InsensitiveStr::Ascii("rutinizeddest"),
        dictgen::InsensitiveStr::Ascii("rutinizing"),
        dictgen::InsensitiveStr::Ascii("rutinizinger"),
        dictgen::InsensitiveStr::Ascii("rutinizingest"),
        dictgen::InsensitiveStr::Ascii("rutinizinglier"),
        dictgen::InsensitiveStr::Ascii("rutinizingliest"),
        dictgen::InsensitiveStr::Ascii("rutinizingly"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNSCANDALIZE_520505661327966431)],
        &[(0b10010, &ENTRY_UNSCANDALIZED_8152094708030261523)],
        &[(0b10010, &ENTRY_UNSCANDALIZEDDER_16598075610375338334)],
        &[(0b10010, &ENTRY_UNSCANDALIZEDDEST_10751215903020225937)],
        &[(0b10010, &ENTRY_UNSCANDALIZES_17840125261680020227)],
        &[(0b01001, &ENTRY_UNSCANDALIZE_520505661327966431)],
        &[(0b01001, &ENTRY_UNSCANDALIZED_8152094708030261523)],
        &[(0b01001, &ENTRY_UNSCANDALIZEDDER_16598075610375338334)],
        &[(0b01001, &ENTRY_UNSCANDALIZEDDEST_10751215903020225937)],
        &[(0b01001, &ENTRY_UNSCANDALIZES_17840125261680020227)],
        &[(0b00001, &ENTRY_UNSCEPTER_12310705858970392134)],
        &[(0b00001, &ENTRY_UNSCEPTERED_13340295677500887608)],
        &[(0b00001, &ENTRY_UNSCEPTEREDDER_2376849210254288587)],
        &[(0b00001, &ENTRY_UNSCEPTEREDDEST_13269872785173189124)],
        &[(0b00001, &ENTRY_UNSCEPTERS_3877189759939193522)],
        &[(0b11010, &ENTRY_UNSCEPTER_12310705858970392134)],
        &[(0b11010, &ENTRY_UNSCEPTERED_13340295677500887608)],
        &[(0b11010, &ENTRY_UNSCEPTEREDDER_2376849210254288587)],
        &[(0b11010, &ENTRY_UNSCEPTEREDDEST_13269872785173189124)],
        &[(0b11010, &ENTRY_UNSCEPTERS_3877189759939193522)],
        &[(0b10010, &ENTRY_UNSCHEMATIZED_15829880150892985637)],
        &[(0b10010, &ENTRY_UNSCHEMATIZEDDER_4716532793392136205)],
        &[(0b10010, &ENTRY_UNSCHEMATIZEDDEST_12088700656751368211)],
        &[(0b10010, &ENTRY_UNSCHEMATIZEDS_298126258475951987)],
        &[(0b01001, &ENTRY_UNSCHEMATIZED_15829880150892985637)],
        &[(0b01001, &ENTRY_UNSCHEMATIZEDDER_4716532793392136205)],
        &[(0b01001, &ENTRY_UNSCHEMATIZEDDEST_12088700656751368211)],
        &[(0b01001, &ENTRY_UNSCHEMATIZEDS_298126258475951987)],
        &[(0b00001, &ENTRY_UNSCORED_14510217564861462498)],
        &[(0b00001, &ENTRY_UNSCORING_7857262218542359235)],
        &[(0b11010, &ENTRY_UNSCORED_14510217564861462498)],
        &[(0b11010, &ENTRY_UNSCORING_7857262218542359235)],
        &[(0b10010, &ENTRY_UNSCRUTINIZED_4499174384647942184)],
        &[(0b10010, &ENTRY_UNSCRUTINIZEDDER_14564478170521424195)],
        &[(0b10010, &ENTRY_UNSCRUTINIZEDDEST_16503621375052442349)],
        &[(0b10010, &ENTRY_UNSCRUTINIZING_12963862895980253271)],
        &[(0b10010, &ENTRY_UNSCRUTINIZINGER_4340449043412100187)],
        &[(0b10010, &ENTRY_UNSCRUTINIZINGEST_9456217512411188422)],
        &[(0b10010, &ENTRY_UNSCRUTINIZINGLIER_16918089062255487129)],
        &[(0b10010, &ENTRY_UNSCRUTINIZINGLIEST_4936819005717689952)],
        &[(0b10010, &ENTRY_UNSCRUTINIZINGLY_5893546295582674444)],
        &[(0b01001, &ENTRY_UNSCRUTINIZED_4499174384647942184)],
        &[(0b01001, &ENTRY_UNSCRUTINIZEDDER_14564478170521424195)],
        &[(0b01001, &ENTRY_UNSCRUTINIZEDDEST_16503621375052442349)],
        &[(0b01001, &ENTRY_UNSCRUTINIZING_12963862895980253271)],
        &[(0b01001, &ENTRY_UNSCRUTINIZINGER_4340449043412100187)],
        &[(0b01001, &ENTRY_UNSCRUTINIZINGEST_9456217512411188422)],
        &[(0b01001, &ENTRY_UNSCRUTINIZINGLIER_16918089062255487129)],
        &[(0b01001, &ENTRY_UNSCRUTINIZINGLIEST_4936819005717689952)],
        &[(0b01001, &ENTRY_UNSCRUTINIZINGLY_5893546295582674444)],
    ],
    range: 4..=15,
};

static VARS_UNSA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNSA_CHILDREN),
    value: None,
};

pub static VARS_UNSA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bered"),
        dictgen::InsensitiveStr::Ascii("beredder"),
        dictgen::InsensitiveStr::Ascii("bereddest"),
        dictgen::InsensitiveStr::Ascii("bred"),
        dictgen::InsensitiveStr::Ascii("bredder"),
        dictgen::InsensitiveStr::Ascii("breddest"),
        dictgen::InsensitiveStr::Ascii("tirisable"),
        dictgen::InsensitiveStr::Ascii("tirise"),
        dictgen::InsensitiveStr::Ascii("tirised"),
        dictgen::InsensitiveStr::Ascii("tirisedder"),
        dictgen::InsensitiveStr::Ascii("tiriseddest"),
        dictgen::InsensitiveStr::Ascii("tirises"),
        dictgen::InsensitiveStr::Ascii("tirizable"),
        dictgen::InsensitiveStr::Ascii("tirize"),
        dictgen::InsensitiveStr::Ascii("tirized"),
        dictgen::InsensitiveStr::Ascii("tirizedder"),
        dictgen::InsensitiveStr::Ascii("tirizeddest"),
        dictgen::InsensitiveStr::Ascii("tirizes"),
        dictgen::InsensitiveStr::Ascii("vored"),
        dictgen::InsensitiveStr::Ascii("voredder"),
        dictgen::InsensitiveStr::Ascii("voreddest"),
        dictgen::InsensitiveStr::Ascii("voredly"),
        dictgen::InsensitiveStr::Ascii("voredness"),
        dictgen::InsensitiveStr::Ascii("vorier"),
        dictgen::InsensitiveStr::Ascii("vories"),
        dictgen::InsensitiveStr::Ascii("voriest"),
        dictgen::InsensitiveStr::Ascii("vorilier"),
        dictgen::InsensitiveStr::Ascii("vorilies"),
        dictgen::InsensitiveStr::Ascii("voriliest"),
        dictgen::InsensitiveStr::Ascii("vorily"),
        dictgen::InsensitiveStr::Ascii("voriness"),
        dictgen::InsensitiveStr::Ascii("vorinesses"),
        dictgen::InsensitiveStr::Ascii("vory"),
        dictgen::InsensitiveStr::Ascii("voured"),
        dictgen::InsensitiveStr::Ascii("vouredder"),
        dictgen::InsensitiveStr::Ascii("voureddest"),
        dictgen::InsensitiveStr::Ascii("vouredly"),
        dictgen::InsensitiveStr::Ascii("vouredness"),
        dictgen::InsensitiveStr::Ascii("vourier"),
        dictgen::InsensitiveStr::Ascii("vouries"),
        dictgen::InsensitiveStr::Ascii("vouriest"),
        dictgen::InsensitiveStr::Ascii("vourilier"),
        dictgen::InsensitiveStr::Ascii("vourilies"),
        dictgen::InsensitiveStr::Ascii("vouriliest"),
        dictgen::InsensitiveStr::Ascii("vourily"),
        dictgen::InsensitiveStr::Ascii("vouriness"),
        dictgen::InsensitiveStr::Ascii("vourinesses"),
        dictgen::InsensitiveStr::Ascii("voury"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNSABERED_7177981977292168575)],
        &[(0b00001, &ENTRY_UNSABEREDDER_1732672318778523343)],
        &[(0b00001, &ENTRY_UNSABEREDDEST_4361858810448422047)],
        &[(0b11010, &ENTRY_UNSABERED_7177981977292168575)],
        &[(0b11010, &ENTRY_UNSABEREDDER_1732672318778523343)],
        &[(0b11010, &ENTRY_UNSABEREDDEST_4361858810448422047)],
        &[(0b10010, &ENTRY_UNSATIRIZABLE_11743121723677468480)],
        &[(0b10010, &ENTRY_UNSATIRIZE_34395718428272863)],
        &[(0b10010, &ENTRY_UNSATIRIZED_13793588944367095442)],
        &[(0b10010, &ENTRY_UNSATIRIZEDDER_11457550322600274631)],
        &[(0b10010, &ENTRY_UNSATIRIZEDDEST_4126847310419402743)],
        &[(0b10010, &ENTRY_UNSATIRIZES_13382097901467533418)],
        &[(0b01001, &ENTRY_UNSATIRIZABLE_11743121723677468480)],
        &[(0b01001, &ENTRY_UNSATIRIZE_34395718428272863)],
        &[(0b01001, &ENTRY_UNSATIRIZED_13793588944367095442)],
        &[(0b01001, &ENTRY_UNSATIRIZEDDER_11457550322600274631)],
        &[(0b01001, &ENTRY_UNSATIRIZEDDEST_4126847310419402743)],
        &[(0b01001, &ENTRY_UNSATIRIZES_13382097901467533418)],
        &[(0b00001, &ENTRY_UNSAVORED_835718759607657454)],
        &[(0b00001, &ENTRY_UNSAVOREDDER_9689868158053003438)],
        &[(0b00001, &ENTRY_UNSAVOREDDEST_9031970620246286024)],
        &[(0b00001, &ENTRY_UNSAVOREDLY_8889339578327024203)],
        &[(0b00001, &ENTRY_UNSAVOREDNESS_8894397023697955452)],
        &[(0b01001, &ENTRY_UNSAVORIER_11499851903563622390)],
        &[(0b01001, &ENTRY_UNSAVORIES_564856304299168322)],
        &[(0b01001, &ENTRY_UNSAVORIEST_4272222949170545033)],
        &[(0b00001, &ENTRY_UNSAVORILIER_17795073319281436965)],
        &[(0b00001, &ENTRY_UNSAVORILIES_2379987631293155666)],
        &[(0b00001, &ENTRY_UNSAVORILIEST_10649069445986118122)],
        &[(0b00001, &ENTRY_UNSAVORILY_10670667337623880247)],
        &[(0b00001, &ENTRY_UNSAVORINESS_16734401353949800250)],
        &[(0b00001, &ENTRY_UNSAVORINESSES_8712909678084814914)],
        &[(0b01001, &ENTRY_UNSAVORY_5814802780012802033)],
        &[(0b11010, &ENTRY_UNSAVORED_835718759607657454)],
        &[(0b11010, &ENTRY_UNSAVOREDDER_9689868158053003438)],
        &[(0b11010, &ENTRY_UNSAVOREDDEST_9031970620246286024)],
        &[(0b11010, &ENTRY_UNSAVOREDLY_8889339578327024203)],
        &[(0b11010, &ENTRY_UNSAVOREDNESS_8894397023697955452)],
        &[(0b11010, &ENTRY_UNSAVORIER_11499851903563622390)],
        &[(0b11010, &ENTRY_UNSAVORIES_564856304299168322)],
        &[(0b11010, &ENTRY_UNSAVORIEST_4272222949170545033)],
        &[(0b11010, &ENTRY_UNSAVORILIER_17795073319281436965)],
        &[(0b11010, &ENTRY_UNSAVORILIES_2379987631293155666)],
        &[(0b11010, &ENTRY_UNSAVORILIEST_10649069445986118122)],
        &[(0b11010, &ENTRY_UNSAVORILY_10670667337623880247)],
        &[(0b11010, &ENTRY_UNSAVORINESS_16734401353949800250)],
        &[(0b11010, &ENTRY_UNSAVORINESSES_8712909678084814914)],
        &[(0b11010, &ENTRY_UNSAVORY_5814802780012802033)],
    ],
    range: 4..=11,
};

static VARS_UNR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UNR_CHILDREN),
    value: None,
};

static VARS_UNR_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_UNRA_NODE),
    None,
    None,
    None,
    Some(&VARS_UNRE_NODE),
    None,
    None,
    None,
    Some(&VARS_UNRI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UNRO_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UNRU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_UNRU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNRU_CHILDREN),
    value: None,
};

pub static VARS_UNRU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("mored"),
        dictgen::InsensitiveStr::Ascii("moredder"),
        dictgen::InsensitiveStr::Ascii("moreddest"),
        dictgen::InsensitiveStr::Ascii("moured"),
        dictgen::InsensitiveStr::Ascii("mouredder"),
        dictgen::InsensitiveStr::Ascii("moureddest"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNRUMORED_11945081100528914083)],
        &[(0b00001, &ENTRY_UNRUMOREDDER_1235386211719339229)],
        &[(0b00001, &ENTRY_UNRUMOREDDEST_10653958198865026338)],
        &[(0b11010, &ENTRY_UNRUMORED_11945081100528914083)],
        &[(0b11010, &ENTRY_UNRUMOREDDER_1235386211719339229)],
        &[(0b11010, &ENTRY_UNRUMOREDDEST_10653958198865026338)],
    ],
    range: 5..=10,
};

static VARS_UNRO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNRO_CHILDREN),
    value: None,
};

pub static VARS_UNRO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("manised"),
        dictgen::InsensitiveStr::Ascii("manized"),
        dictgen::InsensitiveStr::Ascii("manticised"),
        dictgen::InsensitiveStr::Ascii("manticisedder"),
        dictgen::InsensitiveStr::Ascii("manticiseddest"),
        dictgen::InsensitiveStr::Ascii("manticiseds"),
        dictgen::InsensitiveStr::Ascii("manticized"),
        dictgen::InsensitiveStr::Ascii("manticizedder"),
        dictgen::InsensitiveStr::Ascii("manticizeddest"),
        dictgen::InsensitiveStr::Ascii("manticizeds"),
        dictgen::InsensitiveStr::Ascii("yalised"),
        dictgen::InsensitiveStr::Ascii("yaliseds"),
        dictgen::InsensitiveStr::Ascii("yalized"),
        dictgen::InsensitiveStr::Ascii("yalizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNROMANIZED_3332586790919173959)],
        &[(0b01001, &ENTRY_UNROMANIZED_3332586790919173959)],
        &[(0b10010, &ENTRY_UNROMANTICIZED_12323250999848162828)],
        &[(0b10010, &ENTRY_UNROMANTICIZEDDER_7880803665433466684)],
        &[(0b10010, &ENTRY_UNROMANTICIZEDDEST_4366413467561211143)],
        &[(0b10010, &ENTRY_UNROMANTICIZEDS_6905411968539131627)],
        &[(0b01001, &ENTRY_UNROMANTICIZED_12323250999848162828)],
        &[(0b01001, &ENTRY_UNROMANTICIZEDDER_7880803665433466684)],
        &[(0b01001, &ENTRY_UNROMANTICIZEDDEST_4366413467561211143)],
        &[(0b01001, &ENTRY_UNROMANTICIZEDS_6905411968539131627)],
        &[(0b10010, &ENTRY_UNROYALIZED_463331773464183743)],
        &[(0b10010, &ENTRY_UNROYALIZEDS_18166484644206892914)],
        &[(0b01001, &ENTRY_UNROYALIZED_463331773464183743)],
        &[(0b01001, &ENTRY_UNROYALIZEDS_18166484644206892914)],
    ],
    range: 7..=14,
};

static VARS_UNRI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNRI_CHILDREN),
    value: None,
};

pub static VARS_UNRI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("valed"),
        dictgen::InsensitiveStr::Ascii("valedder"),
        dictgen::InsensitiveStr::Ascii("valeddest"),
        dictgen::InsensitiveStr::Ascii("valled"),
        dictgen::InsensitiveStr::Ascii("valledder"),
        dictgen::InsensitiveStr::Ascii("valleddest"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNRIVALED_7117684569657820456)],
        &[(0b00001, &ENTRY_UNRIVALEDDER_4770647244445881329)],
        &[(0b00001, &ENTRY_UNRIVALEDDEST_6685390969368773151)],
        &[(0b11010, &ENTRY_UNRIVALED_7117684569657820456)],
        &[(0b11010, &ENTRY_UNRIVALEDDER_4770647244445881329)],
        &[(0b11010, &ENTRY_UNRIVALEDDEST_6685390969368773151)],
    ],
    range: 5..=10,
};

static VARS_UNRE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNRE_CHILDREN),
    value: None,
};

pub static VARS_UNRE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alisable"),
        dictgen::InsensitiveStr::Ascii("alisables"),
        dictgen::InsensitiveStr::Ascii("alise"),
        dictgen::InsensitiveStr::Ascii("alised"),
        dictgen::InsensitiveStr::Ascii("alises"),
        dictgen::InsensitiveStr::Ascii("alising"),
        dictgen::InsensitiveStr::Ascii("alisings"),
        dictgen::InsensitiveStr::Ascii("alizable"),
        dictgen::InsensitiveStr::Ascii("alizables"),
        dictgen::InsensitiveStr::Ascii("alize"),
        dictgen::InsensitiveStr::Ascii("alized"),
        dictgen::InsensitiveStr::Ascii("alizes"),
        dictgen::InsensitiveStr::Ascii("alizing"),
        dictgen::InsensitiveStr::Ascii("alizings"),
        dictgen::InsensitiveStr::Ascii("cognisable"),
        dictgen::InsensitiveStr::Ascii("cognisabler"),
        dictgen::InsensitiveStr::Ascii("cognisablest"),
        dictgen::InsensitiveStr::Ascii("cognisably"),
        dictgen::InsensitiveStr::Ascii("cognised"),
        dictgen::InsensitiveStr::Ascii("cognising"),
        dictgen::InsensitiveStr::Ascii("cognisingly"),
        dictgen::InsensitiveStr::Ascii("cognizable"),
        dictgen::InsensitiveStr::Ascii("cognizabler"),
        dictgen::InsensitiveStr::Ascii("cognizablest"),
        dictgen::InsensitiveStr::Ascii("cognizably"),
        dictgen::InsensitiveStr::Ascii("cognized"),
        dictgen::InsensitiveStr::Ascii("cognizing"),
        dictgen::InsensitiveStr::Ascii("cognizingly"),
        dictgen::InsensitiveStr::Ascii("connoitered"),
        dictgen::InsensitiveStr::Ascii("connoiteredder"),
        dictgen::InsensitiveStr::Ascii("connoitereddest"),
        dictgen::InsensitiveStr::Ascii("connoitereds"),
        dictgen::InsensitiveStr::Ascii("connoitred"),
        dictgen::InsensitiveStr::Ascii("connoitredder"),
        dictgen::InsensitiveStr::Ascii("connoitreddest"),
        dictgen::InsensitiveStr::Ascii("connoitreds"),
        dictgen::InsensitiveStr::Ascii("gularised"),
        dictgen::InsensitiveStr::Ascii("gularized"),
        dictgen::InsensitiveStr::Ascii("organised"),
        dictgen::InsensitiveStr::Ascii("organisedder"),
        dictgen::InsensitiveStr::Ascii("organiseddest"),
        dictgen::InsensitiveStr::Ascii("organized"),
        dictgen::InsensitiveStr::Ascii("organizedder"),
        dictgen::InsensitiveStr::Ascii("organizeddest"),
        dictgen::InsensitiveStr::Ascii("velationise"),
        dictgen::InsensitiveStr::Ascii("velationises"),
        dictgen::InsensitiveStr::Ascii("velationize"),
        dictgen::InsensitiveStr::Ascii("velationizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNREALIZABLE_7427131823977755851)],
        &[(0b10010, &ENTRY_UNREALIZABLES_9314641022749638380)],
        &[(0b10010, &ENTRY_UNREALIZE_13658903213229006471)],
        &[(0b10010, &ENTRY_UNREALIZED_17404817653704661257)],
        &[(0b10010, &ENTRY_UNREALIZES_5730139003901729864)],
        &[(0b10010, &ENTRY_UNREALIZING_16148636932622971777)],
        &[(0b10010, &ENTRY_UNREALIZINGS_15326868678672664338)],
        &[(0b01001, &ENTRY_UNREALIZABLE_7427131823977755851)],
        &[(0b01001, &ENTRY_UNREALIZABLES_9314641022749638380)],
        &[(0b01001, &ENTRY_UNREALIZE_13658903213229006471)],
        &[(0b01001, &ENTRY_UNREALIZED_17404817653704661257)],
        &[(0b01001, &ENTRY_UNREALIZES_5730139003901729864)],
        &[(0b01001, &ENTRY_UNREALIZING_16148636932622971777)],
        &[(0b01001, &ENTRY_UNREALIZINGS_15326868678672664338)],
        &[(0b10010, &ENTRY_UNRECOGNIZABLE_13177594232205592621)],
        &[(0b10010, &ENTRY_UNRECOGNIZABLER_15443328521804403575)],
        &[(0b10010, &ENTRY_UNRECOGNIZABLEST_11700300065072913162)],
        &[(0b10010, &ENTRY_UNRECOGNIZABLY_12498741757123655980)],
        &[(0b10010, &ENTRY_UNRECOGNIZED_15339742215625954957)],
        &[(0b10010, &ENTRY_UNRECOGNIZING_15165523388753258920)],
        &[(0b10010, &ENTRY_UNRECOGNIZINGLY_2227023476747181630)],
        &[(0b01001, &ENTRY_UNRECOGNIZABLE_13177594232205592621)],
        &[(0b01001, &ENTRY_UNRECOGNIZABLER_15443328521804403575)],
        &[(0b01001, &ENTRY_UNRECOGNIZABLEST_11700300065072913162)],
        &[(0b01001, &ENTRY_UNRECOGNIZABLY_12498741757123655980)],
        &[(0b01001, &ENTRY_UNRECOGNIZED_15339742215625954957)],
        &[(0b01001, &ENTRY_UNRECOGNIZING_15165523388753258920)],
        &[(0b01001, &ENTRY_UNRECOGNIZINGLY_2227023476747181630)],
        &[(0b00001, &ENTRY_UNRECONNOITERED_7020570262194740993)],
        &[(0b00001, &ENTRY_UNRECONNOITEREDDER_6824132526297537617)],
        &[(0b00001, &ENTRY_UNRECONNOITEREDDEST_14662375144067296424)],
        &[(0b00001, &ENTRY_UNRECONNOITEREDS_10144374598602641365)],
        &[(0b11010, &ENTRY_UNRECONNOITERED_7020570262194740993)],
        &[(0b11010, &ENTRY_UNRECONNOITEREDDER_6824132526297537617)],
        &[(0b11010, &ENTRY_UNRECONNOITEREDDEST_14662375144067296424)],
        &[(0b11010, &ENTRY_UNRECONNOITEREDS_10144374598602641365)],
        &[(0b10010, &ENTRY_UNREGULARIZED_8237418541509267985)],
        &[(0b01001, &ENTRY_UNREGULARIZED_8237418541509267985)],
        &[(0b10010, &ENTRY_UNREORGANIZED_15237002088977221645)],
        &[(0b10010, &ENTRY_UNREORGANIZEDDER_6817535441462629186)],
        &[(0b10010, &ENTRY_UNREORGANIZEDDEST_16921729744186143176)],
        &[(0b01001, &ENTRY_UNREORGANIZED_15237002088977221645)],
        &[(0b01001, &ENTRY_UNREORGANIZEDDER_6817535441462629186)],
        &[(0b01001, &ENTRY_UNREORGANIZEDDEST_16921729744186143176)],
        &[(0b10010, &ENTRY_UNREVELATIONIZE_17021292236492045263)],
        &[(0b10010, &ENTRY_UNREVELATIONIZES_8974203434399731612)],
        &[(0b01001, &ENTRY_UNREVELATIONIZE_17021292236492045263)],
        &[(0b01001, &ENTRY_UNREVELATIONIZES_8974203434399731612)],
    ],
    range: 5..=15,
};

static VARS_UNRA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNRA_CHILDREN),
    value: None,
};

pub static VARS_UNRA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("dicalise"),
        dictgen::InsensitiveStr::Ascii("dicalises"),
        dictgen::InsensitiveStr::Ascii("dicalize"),
        dictgen::InsensitiveStr::Ascii("dicalizes"),
        dictgen::InsensitiveStr::Ascii("ncored"),
        dictgen::InsensitiveStr::Ascii("ncoredder"),
        dictgen::InsensitiveStr::Ascii("ncoreddest"),
        dictgen::InsensitiveStr::Ascii("ncoreds"),
        dictgen::InsensitiveStr::Ascii("ncorous"),
        dictgen::InsensitiveStr::Ascii("ncoured"),
        dictgen::InsensitiveStr::Ascii("ncouredder"),
        dictgen::InsensitiveStr::Ascii("ncoureddest"),
        dictgen::InsensitiveStr::Ascii("ncoureds"),
        dictgen::InsensitiveStr::Ascii("ncourous"),
        dictgen::InsensitiveStr::Ascii("tionalised"),
        dictgen::InsensitiveStr::Ascii("tionalising"),
        dictgen::InsensitiveStr::Ascii("tionalized"),
        dictgen::InsensitiveStr::Ascii("tionalizing"),
        dictgen::InsensitiveStr::Ascii("veled"),
        dictgen::InsensitiveStr::Ascii("veler"),
        dictgen::InsensitiveStr::Ascii("velers"),
        dictgen::InsensitiveStr::Ascii("veling"),
        dictgen::InsensitiveStr::Ascii("velled"),
        dictgen::InsensitiveStr::Ascii("veller"),
        dictgen::InsensitiveStr::Ascii("vellers"),
        dictgen::InsensitiveStr::Ascii("velling"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNRADICALIZE_2815754936703483818)],
        &[(0b10010, &ENTRY_UNRADICALIZES_16426285436597116329)],
        &[(0b01001, &ENTRY_UNRADICALIZE_2815754936703483818)],
        &[(0b01001, &ENTRY_UNRADICALIZES_16426285436597116329)],
        &[(0b00001, &ENTRY_UNRANCORED_9184272533577547039)],
        &[(0b00001, &ENTRY_UNRANCOREDDER_6348621930598869186)],
        &[(0b00001, &ENTRY_UNRANCOREDDEST_16686379430125720872)],
        &[(0b00001, &ENTRY_UNRANCOREDS_12103687684487901758)],
        &[(0b00001, &ENTRY_UNRANCOROUS_18064074306523619211)],
        &[(0b11010, &ENTRY_UNRANCORED_9184272533577547039)],
        &[(0b11010, &ENTRY_UNRANCOREDDER_6348621930598869186)],
        &[(0b11010, &ENTRY_UNRANCOREDDEST_16686379430125720872)],
        &[(0b11010, &ENTRY_UNRANCOREDS_12103687684487901758)],
        &[(0b11010, &ENTRY_UNRANCOROUS_18064074306523619211)],
        &[(0b10010, &ENTRY_UNRATIONALIZED_16144188304714101879)],
        &[(0b10010, &ENTRY_UNRATIONALIZING_10416615276147328253)],
        &[(0b01001, &ENTRY_UNRATIONALIZED_16144188304714101879)],
        &[(0b01001, &ENTRY_UNRATIONALIZING_10416615276147328253)],
        &[(0b00001, &ENTRY_UNRAVELED_8531790293658379223)],
        &[(0b00001, &ENTRY_UNRAVELER_4944599394654130396)],
        &[(0b00001, &ENTRY_UNRAVELERS_9836540518095344389)],
        &[(0b00001, &ENTRY_UNRAVELING_17073861557040957443)],
        &[(0b11010, &ENTRY_UNRAVELED_8531790293658379223)],
        &[(0b11010, &ENTRY_UNRAVELER_4944599394654130396)],
        &[(0b11010, &ENTRY_UNRAVELERS_9836540518095344389)],
        &[(0b11010, &ENTRY_UNRAVELING_17073861557040957443)],
    ],
    range: 5..=11,
};

static VARS_UNQ_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNQ_CHILDREN),
    value: None,
};

pub static VARS_UNQ_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("uantised"),
        dictgen::InsensitiveStr::Ascii("uantized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNQUANTIZED_11052817945473923658)],
        &[(0b01001, &ENTRY_UNQUANTIZED_11052817945473923658)],
    ],
    range: 8..=8,
};

static VARS_UNP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UNP_CHILDREN),
    value: None,
};

static VARS_UNP_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_UNPA_NODE),
    None,
    None,
    None,
    Some(&VARS_UNPE_NODE),
    None,
    None,
    Some(&VARS_UNPH_NODE),
    Some(&VARS_UNPI_NODE),
    None,
    None,
    Some(&VARS_UNPL_NODE),
    None,
    None,
    Some(&VARS_UNPO_NODE),
    None,
    None,
    Some(&VARS_UNPR_NODE),
    None,
    None,
    Some(&VARS_UNPU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_UNPU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNPU_CHILDREN),
    value: None,
};

pub static VARS_UNPU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("blicised"),
        dictgen::InsensitiveStr::Ascii("blicized"),
        dictgen::InsensitiveStr::Ascii("lverise"),
        dictgen::InsensitiveStr::Ascii("lverised"),
        dictgen::InsensitiveStr::Ascii("lverisedder"),
        dictgen::InsensitiveStr::Ascii("lveriseddest"),
        dictgen::InsensitiveStr::Ascii("lverises"),
        dictgen::InsensitiveStr::Ascii("lverize"),
        dictgen::InsensitiveStr::Ascii("lverized"),
        dictgen::InsensitiveStr::Ascii("lverizedder"),
        dictgen::InsensitiveStr::Ascii("lverizeddest"),
        dictgen::InsensitiveStr::Ascii("lverizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNPUBLICIZED_2598075486221782263)],
        &[(0b01001, &ENTRY_UNPUBLICIZED_2598075486221782263)],
        &[(0b10010, &ENTRY_UNPULVERIZE_1829206909657688086)],
        &[(0b10010, &ENTRY_UNPULVERIZED_14085892621205036357)],
        &[(0b10010, &ENTRY_UNPULVERIZEDDER_54420185367589206)],
        &[(0b10010, &ENTRY_UNPULVERIZEDDEST_9757737756185024283)],
        &[(0b10010, &ENTRY_UNPULVERIZES_36833523357457577)],
        &[(0b01001, &ENTRY_UNPULVERIZE_1829206909657688086)],
        &[(0b01001, &ENTRY_UNPULVERIZED_14085892621205036357)],
        &[(0b01001, &ENTRY_UNPULVERIZEDDER_54420185367589206)],
        &[(0b01001, &ENTRY_UNPULVERIZEDDEST_9757737756185024283)],
        &[(0b01001, &ENTRY_UNPULVERIZES_36833523357457577)],
    ],
    range: 7..=12,
};

static VARS_UNPR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNPR_CHILDREN),
    value: None,
};

pub static VARS_UNPR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("acticed"),
        dictgen::InsensitiveStr::Ascii("acticedder"),
        dictgen::InsensitiveStr::Ascii("acticeddest"),
        dictgen::InsensitiveStr::Ascii("actised"),
        dictgen::InsensitiveStr::Ascii("actisedder"),
        dictgen::InsensitiveStr::Ascii("actiseddest"),
        dictgen::InsensitiveStr::Ascii("eceptively"),
        dictgen::InsensitiveStr::Ascii("essurised"),
        dictgen::InsensitiveStr::Ascii("essurized"),
        dictgen::InsensitiveStr::Ascii("otestantise"),
        dictgen::InsensitiveStr::Ascii("otestantised"),
        dictgen::InsensitiveStr::Ascii("otestantises"),
        dictgen::InsensitiveStr::Ascii("otestantising"),
        dictgen::InsensitiveStr::Ascii("otestantize"),
        dictgen::InsensitiveStr::Ascii("otestantized"),
        dictgen::InsensitiveStr::Ascii("otestantizes"),
        dictgen::InsensitiveStr::Ascii("otestantizing"),
    ],
    values: &[
        &[(0b01001, &ENTRY_UNPRACTICED_9353245174446259318)],
        &[(0b01001, &ENTRY_UNPRACTICEDDER_6992033786330144479)],
        &[(0b01001, &ENTRY_UNPRACTICEDDEST_15053947325497824834)],
        &[(0b11010, &ENTRY_UNPRACTICED_9353245174446259318)],
        &[(0b11010, &ENTRY_UNPRACTICEDDER_6992033786330144479)],
        &[(0b11010, &ENTRY_UNPRACTICEDDEST_15053947325497824834)],
        &[(0b11010, &ENTRY_UNPERCEPTIVELY_16674495345486986764)],
        &[(0b10010, &ENTRY_UNPRESSURIZED_1643527799717908100)],
        &[(0b01001, &ENTRY_UNPRESSURIZED_1643527799717908100)],
        &[(0b10010, &ENTRY_UNPROTESTANTIZE_5090310073731327645)],
        &[(0b10010, &ENTRY_UNPROTESTANTIZED_6820017680334554701)],
        &[(0b10010, &ENTRY_UNPROTESTANTIZES_5207108080017394469)],
        &[(0b10010, &ENTRY_UNPROTESTANTIZING_2472019232653798522)],
        &[(0b01001, &ENTRY_UNPROTESTANTIZE_5090310073731327645)],
        &[(0b01001, &ENTRY_UNPROTESTANTIZED_6820017680334554701)],
        &[(0b01001, &ENTRY_UNPROTESTANTIZES_5207108080017394469)],
        &[(0b01001, &ENTRY_UNPROTESTANTIZING_2472019232653798522)],
    ],
    range: 7..=13,
};

static VARS_UNPO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNPO_CHILDREN),
    value: None,
};

pub static VARS_UNPO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eticised"),
        dictgen::InsensitiveStr::Ascii("eticisedder"),
        dictgen::InsensitiveStr::Ascii("eticiseddest"),
        dictgen::InsensitiveStr::Ascii("eticiseds"),
        dictgen::InsensitiveStr::Ascii("eticized"),
        dictgen::InsensitiveStr::Ascii("eticizedder"),
        dictgen::InsensitiveStr::Ascii("eticizeddest"),
        dictgen::InsensitiveStr::Ascii("eticizeds"),
        dictgen::InsensitiveStr::Ascii("etise"),
        dictgen::InsensitiveStr::Ascii("etised"),
        dictgen::InsensitiveStr::Ascii("etises"),
        dictgen::InsensitiveStr::Ascii("etize"),
        dictgen::InsensitiveStr::Ascii("etized"),
        dictgen::InsensitiveStr::Ascii("etizes"),
        dictgen::InsensitiveStr::Ascii("larisable"),
        dictgen::InsensitiveStr::Ascii("larisables"),
        dictgen::InsensitiveStr::Ascii("larised"),
        dictgen::InsensitiveStr::Ascii("larisedder"),
        dictgen::InsensitiveStr::Ascii("lariseddest"),
        dictgen::InsensitiveStr::Ascii("lariseds"),
        dictgen::InsensitiveStr::Ascii("larizable"),
        dictgen::InsensitiveStr::Ascii("larizables"),
        dictgen::InsensitiveStr::Ascii("larized"),
        dictgen::InsensitiveStr::Ascii("larizedder"),
        dictgen::InsensitiveStr::Ascii("larizeddest"),
        dictgen::InsensitiveStr::Ascii("larizeds"),
        dictgen::InsensitiveStr::Ascii("lymerised"),
        dictgen::InsensitiveStr::Ascii("lymerisedder"),
        dictgen::InsensitiveStr::Ascii("lymeriseddest"),
        dictgen::InsensitiveStr::Ascii("lymeriseds"),
        dictgen::InsensitiveStr::Ascii("lymerized"),
        dictgen::InsensitiveStr::Ascii("lymerizedder"),
        dictgen::InsensitiveStr::Ascii("lymerizeddest"),
        dictgen::InsensitiveStr::Ascii("lymerizeds"),
        dictgen::InsensitiveStr::Ascii("pularise"),
        dictgen::InsensitiveStr::Ascii("pularised"),
        dictgen::InsensitiveStr::Ascii("pularises"),
        dictgen::InsensitiveStr::Ascii("pularize"),
        dictgen::InsensitiveStr::Ascii("pularized"),
        dictgen::InsensitiveStr::Ascii("pularizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNPOETICIZED_15341478924184758286)],
        &[(0b10010, &ENTRY_UNPOETICIZEDDER_12735195907627961200)],
        &[(0b10010, &ENTRY_UNPOETICIZEDDEST_7053597514693691953)],
        &[(0b10010, &ENTRY_UNPOETICIZEDS_16917648203731599677)],
        &[(0b01001, &ENTRY_UNPOETICIZED_15341478924184758286)],
        &[(0b01001, &ENTRY_UNPOETICIZEDDER_12735195907627961200)],
        &[(0b01001, &ENTRY_UNPOETICIZEDDEST_7053597514693691953)],
        &[(0b01001, &ENTRY_UNPOETICIZEDS_16917648203731599677)],
        &[(0b10010, &ENTRY_UNPOETIZE_14681941329003224540)],
        &[(0b10010, &ENTRY_UNPOETIZED_2934206354212163480)],
        &[(0b10010, &ENTRY_UNPOETIZES_11474052031789009067)],
        &[(0b01001, &ENTRY_UNPOETIZE_14681941329003224540)],
        &[(0b01001, &ENTRY_UNPOETIZED_2934206354212163480)],
        &[(0b01001, &ENTRY_UNPOETIZES_11474052031789009067)],
        &[(0b10010, &ENTRY_UNPOLARIZABLE_2655531584986495323)],
        &[(0b10010, &ENTRY_UNPOLARIZABLES_4705929238062186499)],
        &[(0b10010, &ENTRY_UNPOLARIZED_1673168216555793217)],
        &[(0b10010, &ENTRY_UNPOLARIZEDDER_1873291145002664328)],
        &[(0b10010, &ENTRY_UNPOLARIZEDDEST_6022870955853565151)],
        &[(0b10010, &ENTRY_UNPOLARIZEDS_12480635500313856290)],
        &[(0b01001, &ENTRY_UNPOLARIZABLE_2655531584986495323)],
        &[(0b01001, &ENTRY_UNPOLARIZABLES_4705929238062186499)],
        &[(0b01001, &ENTRY_UNPOLARIZED_1673168216555793217)],
        &[(0b01001, &ENTRY_UNPOLARIZEDDER_1873291145002664328)],
        &[(0b01001, &ENTRY_UNPOLARIZEDDEST_6022870955853565151)],
        &[(0b01001, &ENTRY_UNPOLARIZEDS_12480635500313856290)],
        &[(0b10010, &ENTRY_UNPOLYMERIZED_13019897518101040085)],
        &[(0b10010, &ENTRY_UNPOLYMERIZEDDER_17288114785409523400)],
        &[(0b10010, &ENTRY_UNPOLYMERIZEDDEST_16854986311676403228)],
        &[(0b10010, &ENTRY_UNPOLYMERIZEDS_9720144018872629191)],
        &[(0b01001, &ENTRY_UNPOLYMERIZED_13019897518101040085)],
        &[(0b01001, &ENTRY_UNPOLYMERIZEDDER_17288114785409523400)],
        &[(0b01001, &ENTRY_UNPOLYMERIZEDDEST_16854986311676403228)],
        &[(0b01001, &ENTRY_UNPOLYMERIZEDS_9720144018872629191)],
        &[(0b10010, &ENTRY_UNPOPULARIZE_14649336472865355252)],
        &[(0b10010, &ENTRY_UNPOPULARIZED_76466767521665438)],
        &[(0b10010, &ENTRY_UNPOPULARIZES_1388212767604412165)],
        &[(0b01001, &ENTRY_UNPOPULARIZE_14649336472865355252)],
        &[(0b01001, &ENTRY_UNPOPULARIZED_76466767521665438)],
        &[(0b01001, &ENTRY_UNPOPULARIZES_1388212767604412165)],
    ],
    range: 5..=13,
};

static VARS_UNPL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNPL_CHILDREN),
    value: None,
};

pub static VARS_UNPL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("agiarised"),
        dictgen::InsensitiveStr::Ascii("agiarisedder"),
        dictgen::InsensitiveStr::Ascii("agiariseddest"),
        dictgen::InsensitiveStr::Ascii("agiariseds"),
        dictgen::InsensitiveStr::Ascii("agiarized"),
        dictgen::InsensitiveStr::Ascii("agiarizedder"),
        dictgen::InsensitiveStr::Ascii("agiarizeddest"),
        dictgen::InsensitiveStr::Ascii("agiarizeds"),
        dictgen::InsensitiveStr::Ascii("uralised"),
        dictgen::InsensitiveStr::Ascii("uralized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNPLAGIARIZED_9590657773070630082)],
        &[(0b10010, &ENTRY_UNPLAGIARIZEDDER_2962770941163506588)],
        &[(0b10010, &ENTRY_UNPLAGIARIZEDDEST_3104273454326165318)],
        &[(0b10010, &ENTRY_UNPLAGIARIZEDS_17313414421594015377)],
        &[(0b01001, &ENTRY_UNPLAGIARIZED_9590657773070630082)],
        &[(0b01001, &ENTRY_UNPLAGIARIZEDDER_2962770941163506588)],
        &[(0b01001, &ENTRY_UNPLAGIARIZEDDEST_3104273454326165318)],
        &[(0b01001, &ENTRY_UNPLAGIARIZEDS_17313414421594015377)],
        &[(0b10010, &ENTRY_UNPLURALIZED_5984694540050844180)],
        &[(0b01001, &ENTRY_UNPLURALIZED_5984694540050844180)],
    ],
    range: 8..=13,
};

static VARS_UNPI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNPI_CHILDREN),
    value: None,
};

pub static VARS_UNPI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ctorialise"),
        dictgen::InsensitiveStr::Ascii("ctorialised"),
        dictgen::InsensitiveStr::Ascii("ctorialising"),
        dictgen::InsensitiveStr::Ascii("ctorialize"),
        dictgen::InsensitiveStr::Ascii("ctorialized"),
        dictgen::InsensitiveStr::Ascii("ctorializing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNPICTORIALIZE_8534139020030241947)],
        &[(0b10010, &ENTRY_UNPICTORIALIZED_4786628385029481651)],
        &[(0b10010, &ENTRY_UNPICTORIALIZING_13381639932561913300)],
        &[(0b01001, &ENTRY_UNPICTORIALIZE_8534139020030241947)],
        &[(0b01001, &ENTRY_UNPICTORIALIZED_4786628385029481651)],
        &[(0b01001, &ENTRY_UNPICTORIALIZING_13381639932561913300)],
    ],
    range: 10..=12,
};

static VARS_UNPH_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNPH_CHILDREN),
    value: None,
};

pub static VARS_UNPH_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ilosophise"),
        dictgen::InsensitiveStr::Ascii("ilosophised"),
        dictgen::InsensitiveStr::Ascii("ilosophises"),
        dictgen::InsensitiveStr::Ascii("ilosophize"),
        dictgen::InsensitiveStr::Ascii("ilosophized"),
        dictgen::InsensitiveStr::Ascii("ilosophizes"),
        dictgen::InsensitiveStr::Ascii("osphatised"),
        dictgen::InsensitiveStr::Ascii("osphatisedder"),
        dictgen::InsensitiveStr::Ascii("osphatiseddest"),
        dictgen::InsensitiveStr::Ascii("osphatiseds"),
        dictgen::InsensitiveStr::Ascii("osphatized"),
        dictgen::InsensitiveStr::Ascii("osphatizedder"),
        dictgen::InsensitiveStr::Ascii("osphatizeddest"),
        dictgen::InsensitiveStr::Ascii("osphatizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNPHILOSOPHIZE_15409606515006527524)],
        &[(0b10010, &ENTRY_UNPHILOSOPHIZED_4478449938288203539)],
        &[(0b10010, &ENTRY_UNPHILOSOPHIZES_9638452344711758586)],
        &[(0b01001, &ENTRY_UNPHILOSOPHIZE_15409606515006527524)],
        &[(0b01001, &ENTRY_UNPHILOSOPHIZED_4478449938288203539)],
        &[(0b01001, &ENTRY_UNPHILOSOPHIZES_9638452344711758586)],
        &[(0b10010, &ENTRY_UNPHOSPHATIZED_6698185802257295415)],
        &[(0b10010, &ENTRY_UNPHOSPHATIZEDDER_8344177484520626925)],
        &[(0b10010, &ENTRY_UNPHOSPHATIZEDDEST_7712221667803666231)],
        &[(0b10010, &ENTRY_UNPHOSPHATIZEDS_14190092196126111453)],
        &[(0b01001, &ENTRY_UNPHOSPHATIZED_6698185802257295415)],
        &[(0b01001, &ENTRY_UNPHOSPHATIZEDDER_8344177484520626925)],
        &[(0b01001, &ENTRY_UNPHOSPHATIZEDDEST_7712221667803666231)],
        &[(0b01001, &ENTRY_UNPHOSPHATIZEDS_14190092196126111453)],
    ],
    range: 10..=14,
};

static VARS_UNPE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNPE_CHILDREN),
    value: None,
};

pub static VARS_UNPE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("nalised"),
        dictgen::InsensitiveStr::Ascii("nalisedder"),
        dictgen::InsensitiveStr::Ascii("naliseddest"),
        dictgen::InsensitiveStr::Ascii("nalized"),
        dictgen::InsensitiveStr::Ascii("nalizedder"),
        dictgen::InsensitiveStr::Ascii("nalizeddest"),
        dictgen::InsensitiveStr::Ascii("rceptively"),
        dictgen::InsensitiveStr::Ascii("rsonalised"),
        dictgen::InsensitiveStr::Ascii("rsonalising"),
        dictgen::InsensitiveStr::Ascii("rsonalized"),
        dictgen::InsensitiveStr::Ascii("rsonalizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNPENALIZED_2142967108305186126)],
        &[(0b10010, &ENTRY_UNPENALIZEDDER_8199987065212676092)],
        &[(0b10010, &ENTRY_UNPENALIZEDDEST_9469524353322915881)],
        &[(0b01001, &ENTRY_UNPENALIZED_2142967108305186126)],
        &[(0b01001, &ENTRY_UNPENALIZEDDER_8199987065212676092)],
        &[(0b01001, &ENTRY_UNPENALIZEDDEST_9469524353322915881)],
        &[(0b00001, &ENTRY_UNPERCEPTIVELY_16674495345486986764)],
        &[(0b10010, &ENTRY_UNPERSONALIZED_10430124302522011652)],
        &[(0b10010, &ENTRY_UNPERSONALIZING_15562446084747354495)],
        &[(0b01001, &ENTRY_UNPERSONALIZED_10430124302522011652)],
        &[(0b01001, &ENTRY_UNPERSONALIZING_15562446084747354495)],
    ],
    range: 7..=11,
};

static VARS_UNPA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UNPA_CHILDREN),
    value: None,
};

static VARS_UNPA_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UNPAG_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_UNPAL_NODE),
    None,
    Some(&VARS_UNPAN_NODE),
    None,
    None,
    None,
    Some(&VARS_UNPAR_NODE),
    Some(&VARS_UNPAS_NODE),
    Some(&VARS_UNPAT_NODE),
    Some(&VARS_UNPAU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_UNPAU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNPAU_CHILDREN),
    value: None,
};

pub static VARS_UNPAU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("perised"),
        dictgen::InsensitiveStr::Ascii("periseds"),
        dictgen::InsensitiveStr::Ascii("perized"),
        dictgen::InsensitiveStr::Ascii("perizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNPAUPERIZED_9404943598594952727)],
        &[(0b10010, &ENTRY_UNPAUPERIZEDS_13074066262081440105)],
        &[(0b01001, &ENTRY_UNPAUPERIZED_9404943598594952727)],
        &[(0b01001, &ENTRY_UNPAUPERIZEDS_13074066262081440105)],
    ],
    range: 7..=8,
};

static VARS_UNPAT_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNPAT_CHILDREN),
    value: None,
};

pub static VARS_UNPAT_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ronisable"),
        dictgen::InsensitiveStr::Ascii("ronisabler"),
        dictgen::InsensitiveStr::Ascii("ronisables"),
        dictgen::InsensitiveStr::Ascii("ronisablest"),
        dictgen::InsensitiveStr::Ascii("ronised"),
        dictgen::InsensitiveStr::Ascii("ronising"),
        dictgen::InsensitiveStr::Ascii("ronizable"),
        dictgen::InsensitiveStr::Ascii("ronizabler"),
        dictgen::InsensitiveStr::Ascii("ronizables"),
        dictgen::InsensitiveStr::Ascii("ronizablest"),
        dictgen::InsensitiveStr::Ascii("ronized"),
        dictgen::InsensitiveStr::Ascii("ronizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNPATRONIZABLE_1362396864066933771)],
        &[(0b10010, &ENTRY_UNPATRONIZABLER_14355011026327328507)],
        &[(0b10010, &ENTRY_UNPATRONIZABLES_5259054875641739571)],
        &[(0b10010, &ENTRY_UNPATRONIZABLEST_16700885895853046350)],
        &[(0b10010, &ENTRY_UNPATRONIZED_6212197640341804006)],
        &[(0b10010, &ENTRY_UNPATRONIZING_315514134828674594)],
        &[(0b01001, &ENTRY_UNPATRONIZABLE_1362396864066933771)],
        &[(0b01001, &ENTRY_UNPATRONIZABLER_14355011026327328507)],
        &[(0b01001, &ENTRY_UNPATRONIZABLES_5259054875641739571)],
        &[(0b01001, &ENTRY_UNPATRONIZABLEST_16700885895853046350)],
        &[(0b01001, &ENTRY_UNPATRONIZED_6212197640341804006)],
        &[(0b01001, &ENTRY_UNPATRONIZING_315514134828674594)],
    ],
    range: 7..=11,
};

static VARS_UNPAS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNPAS_CHILDREN),
    value: None,
};

pub static VARS_UNPAS_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("teurised"),
        dictgen::InsensitiveStr::Ascii("teurized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNPASTEURIZED_6016657477118674821)],
        &[(0b01001, &ENTRY_UNPASTEURIZED_6016657477118674821)],
    ],
    range: 8..=8,
};

static VARS_UNPAR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNPAR_CHILDREN),
    value: None,
};

pub static VARS_UNPAR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("agonised"),
        dictgen::InsensitiveStr::Ascii("agoniseds"),
        dictgen::InsensitiveStr::Ascii("agonized"),
        dictgen::InsensitiveStr::Ascii("agonizeds"),
        dictgen::InsensitiveStr::Ascii("alysed"),
        dictgen::InsensitiveStr::Ascii("alysedder"),
        dictgen::InsensitiveStr::Ascii("alyseddest"),
        dictgen::InsensitiveStr::Ascii("alyseds"),
        dictgen::InsensitiveStr::Ascii("alyzed"),
        dictgen::InsensitiveStr::Ascii("alyzedder"),
        dictgen::InsensitiveStr::Ascii("alyzeddest"),
        dictgen::InsensitiveStr::Ascii("alyzeds"),
        dictgen::InsensitiveStr::Ascii("ameterised"),
        dictgen::InsensitiveStr::Ascii("ameterized"),
        dictgen::InsensitiveStr::Ascii("ametrised"),
        dictgen::InsensitiveStr::Ascii("ametrized"),
        dictgen::InsensitiveStr::Ascii("celed"),
        dictgen::InsensitiveStr::Ascii("celedder"),
        dictgen::InsensitiveStr::Ascii("celeddest"),
        dictgen::InsensitiveStr::Ascii("celled"),
        dictgen::InsensitiveStr::Ascii("celledder"),
        dictgen::InsensitiveStr::Ascii("celleddest"),
        dictgen::InsensitiveStr::Ascii("enthesised"),
        dictgen::InsensitiveStr::Ascii("enthesized"),
        dictgen::InsensitiveStr::Ascii("ticularised"),
        dictgen::InsensitiveStr::Ascii("ticularisedder"),
        dictgen::InsensitiveStr::Ascii("ticulariseddest"),
        dictgen::InsensitiveStr::Ascii("ticulariseds"),
        dictgen::InsensitiveStr::Ascii("ticularising"),
        dictgen::InsensitiveStr::Ascii("ticularisinger"),
        dictgen::InsensitiveStr::Ascii("ticularisingest"),
        dictgen::InsensitiveStr::Ascii("ticularisings"),
        dictgen::InsensitiveStr::Ascii("ticularized"),
        dictgen::InsensitiveStr::Ascii("ticularizedder"),
        dictgen::InsensitiveStr::Ascii("ticularizeddest"),
        dictgen::InsensitiveStr::Ascii("ticularizeds"),
        dictgen::InsensitiveStr::Ascii("ticularizing"),
        dictgen::InsensitiveStr::Ascii("ticularizinger"),
        dictgen::InsensitiveStr::Ascii("ticularizingest"),
        dictgen::InsensitiveStr::Ascii("ticularizings"),
        dictgen::InsensitiveStr::Ascii("tisan"),
        dictgen::InsensitiveStr::Ascii("tizan"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNPARAGONIZED_11641249067400700762)],
        &[(0b10010, &ENTRY_UNPARAGONIZEDS_8828912894163008040)],
        &[(0b01001, &ENTRY_UNPARAGONIZED_11641249067400700762)],
        &[(0b01001, &ENTRY_UNPARAGONIZEDS_8828912894163008040)],
        &[(0b11010, &ENTRY_UNPARALYZED_14384393398387787974)],
        &[(0b11010, &ENTRY_UNPARALYZEDDER_10074788125617493696)],
        &[(0b11010, &ENTRY_UNPARALYZEDDEST_8559985515751356281)],
        &[(0b11010, &ENTRY_UNPARALYZEDS_17113201865707449563)],
        &[(0b00001, &ENTRY_UNPARALYZED_14384393398387787974)],
        &[(0b00001, &ENTRY_UNPARALYZEDDER_10074788125617493696)],
        &[(0b00001, &ENTRY_UNPARALYZEDDEST_8559985515751356281)],
        &[(0b00001, &ENTRY_UNPARALYZEDS_17113201865707449563)],
        &[(0b10010, &ENTRY_UNPARAMETERIZED_10261143125001624802)],
        &[(0b01001, &ENTRY_UNPARAMETERIZED_10261143125001624802)],
        &[(0b10010, &ENTRY_UNPARAMETRIZED_37046481284940289)],
        &[(0b01001, &ENTRY_UNPARAMETRIZED_37046481284940289)],
        &[(0b00001, &ENTRY_UNPARCELED_1373494415685202599)],
        &[(0b00001, &ENTRY_UNPARCELEDDER_3319549837550214831)],
        &[(0b00001, &ENTRY_UNPARCELEDDEST_4383492122712518630)],
        &[(0b11010, &ENTRY_UNPARCELED_1373494415685202599)],
        &[(0b11010, &ENTRY_UNPARCELEDDER_3319549837550214831)],
        &[(0b11010, &ENTRY_UNPARCELEDDEST_4383492122712518630)],
        &[(0b10010, &ENTRY_UNPARENTHESIZED_18235036996914091846)],
        &[(0b01001, &ENTRY_UNPARENTHESIZED_18235036996914091846)],
        &[(0b10010, &ENTRY_UNPARTICULARIZED_10369241482954824333)],
        &[(0b10010, &ENTRY_UNPARTICULARIZEDDER_14810130530234822946)],
        &[(0b10010, &ENTRY_UNPARTICULARIZEDDEST_12461674155327065922)],
        &[(0b10010, &ENTRY_UNPARTICULARIZEDS_7009295388737864374)],
        &[(0b10010, &ENTRY_UNPARTICULARIZING_17075351876595992224)],
        &[(0b10010, &ENTRY_UNPARTICULARIZINGER_1405745460438104009)],
        &[(0b10010, &ENTRY_UNPARTICULARIZINGEST_12469995634183150832)],
        &[(0b10010, &ENTRY_UNPARTICULARIZINGS_12061998009550281971)],
        &[(0b01001, &ENTRY_UNPARTICULARIZED_10369241482954824333)],
        &[(0b01001, &ENTRY_UNPARTICULARIZEDDER_14810130530234822946)],
        &[(0b01001, &ENTRY_UNPARTICULARIZEDDEST_12461674155327065922)],
        &[(0b01001, &ENTRY_UNPARTICULARIZEDS_7009295388737864374)],
        &[(0b01001, &ENTRY_UNPARTICULARIZING_17075351876595992224)],
        &[(0b01001, &ENTRY_UNPARTICULARIZINGER_1405745460438104009)],
        &[(0b01001, &ENTRY_UNPARTICULARIZINGEST_12469995634183150832)],
        &[(0b01001, &ENTRY_UNPARTICULARIZINGS_12061998009550281971)],
        &[(0b10010, &ENTRY_UNPARTIZAN_4088887390151350638)],
        &[(0b01001, &ENTRY_UNPARTIZAN_4088887390151350638)],
    ],
    range: 5..=15,
};

static VARS_UNPAN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNPAN_CHILDREN),
    value: None,
};

pub static VARS_UNPAN_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("egyrised"),
        dictgen::InsensitiveStr::Ascii("egyrized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNPANEGYRIZED_12330222380120284751)],
        &[(0b01001, &ENTRY_UNPANEGYRIZED_12330222380120284751)],
    ],
    range: 8..=8,
};

static VARS_UNPAL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNPAL_CHILDREN),
    value: None,
};

pub static VARS_UNPAL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("isaded"),
        dictgen::InsensitiveStr::Ascii("isadoed"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNPALISADED_1035644440444378203)],
        &[(0b11010, &ENTRY_UNPALISADED_1035644440444378203)],
    ],
    range: 6..=7,
};

static VARS_UNPAG_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNPAG_CHILDREN),
    value: None,
};

pub static VARS_UNPAG_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("anise"),
        dictgen::InsensitiveStr::Ascii("anises"),
        dictgen::InsensitiveStr::Ascii("anize"),
        dictgen::InsensitiveStr::Ascii("anizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNPAGANIZE_10797468704092625272)],
        &[(0b10010, &ENTRY_UNPAGANIZES_1814932462765931021)],
        &[(0b01001, &ENTRY_UNPAGANIZE_10797468704092625272)],
        &[(0b01001, &ENTRY_UNPAGANIZES_1814932462765931021)],
    ],
    range: 5..=6,
};

static VARS_UNO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNO_CHILDREN),
    value: None,
};

pub static VARS_UNO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ptimise"),
        dictgen::InsensitiveStr::Ascii("ptimised"),
        dictgen::InsensitiveStr::Ascii("ptimises"),
        dictgen::InsensitiveStr::Ascii("ptimising"),
        dictgen::InsensitiveStr::Ascii("ptimize"),
        dictgen::InsensitiveStr::Ascii("ptimized"),
        dictgen::InsensitiveStr::Ascii("ptimizes"),
        dictgen::InsensitiveStr::Ascii("ptimizing"),
        dictgen::InsensitiveStr::Ascii("rganisable"),
        dictgen::InsensitiveStr::Ascii("rganisabler"),
        dictgen::InsensitiveStr::Ascii("rganisables"),
        dictgen::InsensitiveStr::Ascii("rganisablest"),
        dictgen::InsensitiveStr::Ascii("rganise"),
        dictgen::InsensitiveStr::Ascii("rganised"),
        dictgen::InsensitiveStr::Ascii("rganisedly"),
        dictgen::InsensitiveStr::Ascii("rganisedness"),
        dictgen::InsensitiveStr::Ascii("rganizable"),
        dictgen::InsensitiveStr::Ascii("rganizabler"),
        dictgen::InsensitiveStr::Ascii("rganizables"),
        dictgen::InsensitiveStr::Ascii("rganizablest"),
        dictgen::InsensitiveStr::Ascii("rganize"),
        dictgen::InsensitiveStr::Ascii("rganized"),
        dictgen::InsensitiveStr::Ascii("rganizedly"),
        dictgen::InsensitiveStr::Ascii("rganizedness"),
        dictgen::InsensitiveStr::Ascii("xidisable"),
        dictgen::InsensitiveStr::Ascii("xidisabler"),
        dictgen::InsensitiveStr::Ascii("xidisables"),
        dictgen::InsensitiveStr::Ascii("xidisablest"),
        dictgen::InsensitiveStr::Ascii("xidised"),
        dictgen::InsensitiveStr::Ascii("xidisedder"),
        dictgen::InsensitiveStr::Ascii("xidiseddest"),
        dictgen::InsensitiveStr::Ascii("xidizable"),
        dictgen::InsensitiveStr::Ascii("xidizabler"),
        dictgen::InsensitiveStr::Ascii("xidizables"),
        dictgen::InsensitiveStr::Ascii("xidizablest"),
        dictgen::InsensitiveStr::Ascii("xidized"),
        dictgen::InsensitiveStr::Ascii("xidizedder"),
        dictgen::InsensitiveStr::Ascii("xidizeddest"),
        dictgen::InsensitiveStr::Ascii("xygenised"),
        dictgen::InsensitiveStr::Ascii("xygeniseds"),
        dictgen::InsensitiveStr::Ascii("xygenized"),
        dictgen::InsensitiveStr::Ascii("xygenizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNOPTIMIZE_8337218810202803852)],
        &[(0b10010, &ENTRY_UNOPTIMIZED_16059827780503939479)],
        &[(0b10010, &ENTRY_UNOPTIMIZES_5417054465029431224)],
        &[(0b10010, &ENTRY_UNOPTIMIZING_3167927648308310550)],
        &[(0b01001, &ENTRY_UNOPTIMIZE_8337218810202803852)],
        &[(0b01001, &ENTRY_UNOPTIMIZED_16059827780503939479)],
        &[(0b01001, &ENTRY_UNOPTIMIZES_5417054465029431224)],
        &[(0b01001, &ENTRY_UNOPTIMIZING_3167927648308310550)],
        &[(0b10010, &ENTRY_UNORGANIZABLE_11245437451639231261)],
        &[(0b10010, &ENTRY_UNORGANIZABLER_2651332250209161850)],
        &[(0b10010, &ENTRY_UNORGANIZABLES_14263543529684744487)],
        &[(0b10010, &ENTRY_UNORGANIZABLEST_13952098891985641540)],
        &[(0b10010, &ENTRY_UNORGANIZE_16055712748344908044)],
        &[(0b10010, &ENTRY_UNORGANIZED_8287041392290100911)],
        &[(0b10010, &ENTRY_UNORGANIZEDLY_17706812563099018840)],
        &[(0b10010, &ENTRY_UNORGANIZEDNESS_5163887181546451097)],
        &[(0b01001, &ENTRY_UNORGANIZABLE_11245437451639231261)],
        &[(0b01001, &ENTRY_UNORGANIZABLER_2651332250209161850)],
        &[(0b01001, &ENTRY_UNORGANIZABLES_14263543529684744487)],
        &[(0b01001, &ENTRY_UNORGANIZABLEST_13952098891985641540)],
        &[(0b01001, &ENTRY_UNORGANIZE_16055712748344908044)],
        &[(0b01001, &ENTRY_UNORGANIZED_8287041392290100911)],
        &[(0b01001, &ENTRY_UNORGANIZEDLY_17706812563099018840)],
        &[(0b01001, &ENTRY_UNORGANIZEDNESS_5163887181546451097)],
        &[(0b10010, &ENTRY_UNOXIDIZABLE_16109933882822047402)],
        &[(0b10010, &ENTRY_UNOXIDIZABLER_5359355858057190803)],
        &[(0b10010, &ENTRY_UNOXIDIZABLES_17595850679261895025)],
        &[(0b10010, &ENTRY_UNOXIDIZABLEST_6591525985530653060)],
        &[(0b10010, &ENTRY_UNOXIDIZED_9470542236784645015)],
        &[(0b10010, &ENTRY_UNOXIDIZEDDER_6144115144136830447)],
        &[(0b10010, &ENTRY_UNOXIDIZEDDEST_14507693636430734653)],
        &[(0b01001, &ENTRY_UNOXIDIZABLE_16109933882822047402)],
        &[(0b01001, &ENTRY_UNOXIDIZABLER_5359355858057190803)],
        &[(0b01001, &ENTRY_UNOXIDIZABLES_17595850679261895025)],
        &[(0b01001, &ENTRY_UNOXIDIZABLEST_6591525985530653060)],
        &[(0b01001, &ENTRY_UNOXIDIZED_9470542236784645015)],
        &[(0b01001, &ENTRY_UNOXIDIZEDDER_6144115144136830447)],
        &[(0b01001, &ENTRY_UNOXIDIZEDDEST_14507693636430734653)],
        &[(0b10010, &ENTRY_UNOXYGENIZED_6875578357957209997)],
        &[(0b10010, &ENTRY_UNOXYGENIZEDS_14660262551929716023)],
        &[(0b01001, &ENTRY_UNOXYGENIZED_6875578357957209997)],
        &[(0b01001, &ENTRY_UNOXYGENIZEDS_14660262551929716023)],
    ],
    range: 7..=12,
};

static VARS_UNN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UNN_CHILDREN),
    value: None,
};

static VARS_UNN_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_UNNA_NODE),
    None,
    None,
    None,
    Some(&VARS_UNNE_NODE),
    None,
    None,
    None,
    Some(&VARS_UNNI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UNNO_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_UNNO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNNO_CHILDREN),
    value: None,
};

pub static VARS_UNNO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ncolorables"),
        dictgen::InsensitiveStr::Ascii("ncolorablies"),
        dictgen::InsensitiveStr::Ascii("ncolorably"),
        dictgen::InsensitiveStr::Ascii("ncolourables"),
        dictgen::InsensitiveStr::Ascii("ncolourablies"),
        dictgen::InsensitiveStr::Ascii("ncolourably"),
        dictgen::InsensitiveStr::Ascii("rmalise"),
        dictgen::InsensitiveStr::Ascii("rmalised"),
        dictgen::InsensitiveStr::Ascii("rmalisedder"),
        dictgen::InsensitiveStr::Ascii("rmaliseddest"),
        dictgen::InsensitiveStr::Ascii("rmalises"),
        dictgen::InsensitiveStr::Ascii("rmalising"),
        dictgen::InsensitiveStr::Ascii("rmalisinger"),
        dictgen::InsensitiveStr::Ascii("rmalisingest"),
        dictgen::InsensitiveStr::Ascii("rmalize"),
        dictgen::InsensitiveStr::Ascii("rmalized"),
        dictgen::InsensitiveStr::Ascii("rmalizedder"),
        dictgen::InsensitiveStr::Ascii("rmalizeddest"),
        dictgen::InsensitiveStr::Ascii("rmalizes"),
        dictgen::InsensitiveStr::Ascii("rmalizing"),
        dictgen::InsensitiveStr::Ascii("rmalizinger"),
        dictgen::InsensitiveStr::Ascii("rmalizingest"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNNONCOLORABLES_11603706591378503372)],
        &[(0b00001, &ENTRY_UNNONCOLORABLIES_9150435717670160252)],
        &[(0b00001, &ENTRY_UNNONCOLORABLY_5346203888294556991)],
        &[(0b11010, &ENTRY_UNNONCOLORABLES_11603706591378503372)],
        &[(0b11010, &ENTRY_UNNONCOLORABLIES_9150435717670160252)],
        &[(0b11010, &ENTRY_UNNONCOLORABLY_5346203888294556991)],
        &[(0b10010, &ENTRY_UNNORMALIZE_14634692936439819346)],
        &[(0b10010, &ENTRY_UNNORMALIZED_17182616854570086003)],
        &[(0b10010, &ENTRY_UNNORMALIZEDDER_6088928097619406702)],
        &[(0b10010, &ENTRY_UNNORMALIZEDDEST_11709516950586687994)],
        &[(0b10010, &ENTRY_UNNORMALIZES_10633086048818529153)],
        &[(0b10010, &ENTRY_UNNORMALIZING_1754876569648213763)],
        &[(0b10010, &ENTRY_UNNORMALIZINGER_15099376100231731467)],
        &[(0b10010, &ENTRY_UNNORMALIZINGEST_247021487053357560)],
        &[(0b01001, &ENTRY_UNNORMALIZE_14634692936439819346)],
        &[(0b01001, &ENTRY_UNNORMALIZED_17182616854570086003)],
        &[(0b01001, &ENTRY_UNNORMALIZEDDER_6088928097619406702)],
        &[(0b01001, &ENTRY_UNNORMALIZEDDEST_11709516950586687994)],
        &[(0b01001, &ENTRY_UNNORMALIZES_10633086048818529153)],
        &[(0b01001, &ENTRY_UNNORMALIZING_1754876569648213763)],
        &[(0b01001, &ENTRY_UNNORMALIZINGER_15099376100231731467)],
        &[(0b01001, &ENTRY_UNNORMALIZINGEST_247021487053357560)],
    ],
    range: 7..=13,
};

static VARS_UNNI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNNI_CHILDREN),
    value: None,
};

pub static VARS_UNNI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("trogenised"),
        dictgen::InsensitiveStr::Ascii("trogenisedder"),
        dictgen::InsensitiveStr::Ascii("trogeniseddest"),
        dictgen::InsensitiveStr::Ascii("trogeniseds"),
        dictgen::InsensitiveStr::Ascii("trogenized"),
        dictgen::InsensitiveStr::Ascii("trogenizedder"),
        dictgen::InsensitiveStr::Ascii("trogenizeddest"),
        dictgen::InsensitiveStr::Ascii("trogenizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNNITROGENIZED_9970825803449823138)],
        &[(0b10010, &ENTRY_UNNITROGENIZEDDER_15494417655163954478)],
        &[(0b10010, &ENTRY_UNNITROGENIZEDDEST_14262521068869718443)],
        &[(0b10010, &ENTRY_UNNITROGENIZEDS_16716966430076186540)],
        &[(0b01001, &ENTRY_UNNITROGENIZED_9970825803449823138)],
        &[(0b01001, &ENTRY_UNNITROGENIZEDDER_15494417655163954478)],
        &[(0b01001, &ENTRY_UNNITROGENIZEDDEST_14262521068869718443)],
        &[(0b01001, &ENTRY_UNNITROGENIZEDS_16716966430076186540)],
    ],
    range: 10..=14,
};

static VARS_UNNE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNNE_CHILDREN),
    value: None,
};

pub static VARS_UNNE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ighbored"),
        dictgen::InsensitiveStr::Ascii("ighborlier"),
        dictgen::InsensitiveStr::Ascii("ighborliest"),
        dictgen::InsensitiveStr::Ascii("ighborlike"),
        dictgen::InsensitiveStr::Ascii("ighborlikes"),
        dictgen::InsensitiveStr::Ascii("ighborliness"),
        dictgen::InsensitiveStr::Ascii("ighborlinesses"),
        dictgen::InsensitiveStr::Ascii("ighborly"),
        dictgen::InsensitiveStr::Ascii("ighboured"),
        dictgen::InsensitiveStr::Ascii("ighbourlier"),
        dictgen::InsensitiveStr::Ascii("ighbourliest"),
        dictgen::InsensitiveStr::Ascii("ighbourlike"),
        dictgen::InsensitiveStr::Ascii("ighbourlikes"),
        dictgen::InsensitiveStr::Ascii("ighbourliness"),
        dictgen::InsensitiveStr::Ascii("ighbourlinesses"),
        dictgen::InsensitiveStr::Ascii("ighbourly"),
        dictgen::InsensitiveStr::Ascii("utralise"),
        dictgen::InsensitiveStr::Ascii("utralised"),
        dictgen::InsensitiveStr::Ascii("utralising"),
        dictgen::InsensitiveStr::Ascii("utralize"),
        dictgen::InsensitiveStr::Ascii("utralized"),
        dictgen::InsensitiveStr::Ascii("utralizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNNEIGHBORED_17137517992514420389)],
        &[(0b00001, &ENTRY_UNNEIGHBORLIER_16702491867279586093)],
        &[(0b00001, &ENTRY_UNNEIGHBORLIEST_12419433861097517248)],
        &[(0b00001, &ENTRY_UNNEIGHBORLIKE_10218446635184503929)],
        &[(0b00001, &ENTRY_UNNEIGHBORLIKES_4354261620124645883)],
        &[(0b00001, &ENTRY_UNNEIGHBORLINESS_1038976996631322927)],
        &[(0b00001, &ENTRY_UNNEIGHBORLINESSES_10829695068225729738)],
        &[(0b00001, &ENTRY_UNNEIGHBORLY_14423135391726748415)],
        &[(0b11010, &ENTRY_UNNEIGHBORED_17137517992514420389)],
        &[(0b11010, &ENTRY_UNNEIGHBORLIER_16702491867279586093)],
        &[(0b11010, &ENTRY_UNNEIGHBORLIEST_12419433861097517248)],
        &[(0b11010, &ENTRY_UNNEIGHBORLIKE_10218446635184503929)],
        &[(0b11010, &ENTRY_UNNEIGHBORLIKES_4354261620124645883)],
        &[(0b11010, &ENTRY_UNNEIGHBORLINESS_1038976996631322927)],
        &[(0b11010, &ENTRY_UNNEIGHBORLINESSES_10829695068225729738)],
        &[(0b11010, &ENTRY_UNNEIGHBORLY_14423135391726748415)],
        &[(0b10010, &ENTRY_UNNEUTRALIZE_4698429815634199128)],
        &[(0b10010, &ENTRY_UNNEUTRALIZED_10386359248112453405)],
        &[(0b10010, &ENTRY_UNNEUTRALIZING_4249099403406146838)],
        &[(0b01001, &ENTRY_UNNEUTRALIZE_4698429815634199128)],
        &[(0b01001, &ENTRY_UNNEUTRALIZED_10386359248112453405)],
        &[(0b01001, &ENTRY_UNNEUTRALIZING_4249099403406146838)],
    ],
    range: 8..=15,
};

static VARS_UNNA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNNA_CHILDREN),
    value: None,
};

pub static VARS_UNNA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("tionalised"),
        dictgen::InsensitiveStr::Ascii("tionalisedder"),
        dictgen::InsensitiveStr::Ascii("tionaliseddest"),
        dictgen::InsensitiveStr::Ascii("tionalized"),
        dictgen::InsensitiveStr::Ascii("tionalizedder"),
        dictgen::InsensitiveStr::Ascii("tionalizeddest"),
        dictgen::InsensitiveStr::Ascii("turalisable"),
        dictgen::InsensitiveStr::Ascii("turalisables"),
        dictgen::InsensitiveStr::Ascii("turalise"),
        dictgen::InsensitiveStr::Ascii("turalised"),
        dictgen::InsensitiveStr::Ascii("turalises"),
        dictgen::InsensitiveStr::Ascii("turalising"),
        dictgen::InsensitiveStr::Ascii("turalizable"),
        dictgen::InsensitiveStr::Ascii("turalizables"),
        dictgen::InsensitiveStr::Ascii("turalize"),
        dictgen::InsensitiveStr::Ascii("turalized"),
        dictgen::InsensitiveStr::Ascii("turalizes"),
        dictgen::InsensitiveStr::Ascii("turalizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNNATIONALIZED_17413125925681224817)],
        &[(0b10010, &ENTRY_UNNATIONALIZEDDER_16819534566496048883)],
        &[(0b10010, &ENTRY_UNNATIONALIZEDDEST_6627375631914479221)],
        &[(0b01001, &ENTRY_UNNATIONALIZED_17413125925681224817)],
        &[(0b01001, &ENTRY_UNNATIONALIZEDDER_16819534566496048883)],
        &[(0b01001, &ENTRY_UNNATIONALIZEDDEST_6627375631914479221)],
        &[(0b10010, &ENTRY_UNNATURALIZABLE_11245054765720939783)],
        &[(0b10010, &ENTRY_UNNATURALIZABLES_15331368327954336002)],
        &[(0b10010, &ENTRY_UNNATURALIZE_8515448021724973747)],
        &[(0b10010, &ENTRY_UNNATURALIZED_12904128484572003805)],
        &[(0b10010, &ENTRY_UNNATURALIZES_15417405462560090882)],
        &[(0b10010, &ENTRY_UNNATURALIZING_8059644534756052716)],
        &[(0b01001, &ENTRY_UNNATURALIZABLE_11245054765720939783)],
        &[(0b01001, &ENTRY_UNNATURALIZABLES_15331368327954336002)],
        &[(0b01001, &ENTRY_UNNATURALIZE_8515448021724973747)],
        &[(0b01001, &ENTRY_UNNATURALIZED_12904128484572003805)],
        &[(0b01001, &ENTRY_UNNATURALIZES_15417405462560090882)],
        &[(0b01001, &ENTRY_UNNATURALIZING_8059644534756052716)],
    ],
    range: 8..=14,
};

static VARS_UNM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UNM_CHILDREN),
    value: None,
};

static VARS_UNM_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_UNMA_NODE),
    None,
    None,
    None,
    Some(&VARS_UNME_NODE),
    None,
    None,
    None,
    Some(&VARS_UNMI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UNMO_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UNMU_NODE),
    None,
    None,
    None,
    Some(&VARS_UNMY_NODE),
    None,
];

static VARS_UNMY_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNMY_CHILDREN),
    value: None,
};

pub static VARS_UNMY_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("sticise"),
        dictgen::InsensitiveStr::Ascii("sticised"),
        dictgen::InsensitiveStr::Ascii("sticises"),
        dictgen::InsensitiveStr::Ascii("sticising"),
        dictgen::InsensitiveStr::Ascii("sticize"),
        dictgen::InsensitiveStr::Ascii("sticized"),
        dictgen::InsensitiveStr::Ascii("sticizes"),
        dictgen::InsensitiveStr::Ascii("sticizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNMYSTICIZE_6752614279344741289)],
        &[(0b10010, &ENTRY_UNMYSTICIZED_3871960656463594608)],
        &[(0b10010, &ENTRY_UNMYSTICIZES_593169946783893980)],
        &[(0b10010, &ENTRY_UNMYSTICIZING_7832774330196959394)],
        &[(0b01001, &ENTRY_UNMYSTICIZE_6752614279344741289)],
        &[(0b01001, &ENTRY_UNMYSTICIZED_3871960656463594608)],
        &[(0b01001, &ENTRY_UNMYSTICIZES_593169946783893980)],
        &[(0b01001, &ENTRY_UNMYSTICIZING_7832774330196959394)],
    ],
    range: 7..=9,
};

static VARS_UNMU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNMU_CHILDREN),
    value: None,
};

pub static VARS_UNMU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("nicipalised"),
        dictgen::InsensitiveStr::Ascii("nicipalisedder"),
        dictgen::InsensitiveStr::Ascii("nicipaliseddest"),
        dictgen::InsensitiveStr::Ascii("nicipaliseds"),
        dictgen::InsensitiveStr::Ascii("nicipalized"),
        dictgen::InsensitiveStr::Ascii("nicipalizedder"),
        dictgen::InsensitiveStr::Ascii("nicipalizeddest"),
        dictgen::InsensitiveStr::Ascii("nicipalizeds"),
        dictgen::InsensitiveStr::Ascii("tualised"),
        dictgen::InsensitiveStr::Ascii("tualisedder"),
        dictgen::InsensitiveStr::Ascii("tualiseddest"),
        dictgen::InsensitiveStr::Ascii("tualiseds"),
        dictgen::InsensitiveStr::Ascii("tualized"),
        dictgen::InsensitiveStr::Ascii("tualizedder"),
        dictgen::InsensitiveStr::Ascii("tualizeddest"),
        dictgen::InsensitiveStr::Ascii("tualizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNMUNICIPALIZED_11558570840724190274)],
        &[(0b10010, &ENTRY_UNMUNICIPALIZEDDER_308188906530115010)],
        &[(0b10010, &ENTRY_UNMUNICIPALIZEDDEST_17406856610278064067)],
        &[(0b10010, &ENTRY_UNMUNICIPALIZEDS_10306483843849279865)],
        &[(0b01001, &ENTRY_UNMUNICIPALIZED_11558570840724190274)],
        &[(0b01001, &ENTRY_UNMUNICIPALIZEDDER_308188906530115010)],
        &[(0b01001, &ENTRY_UNMUNICIPALIZEDDEST_17406856610278064067)],
        &[(0b01001, &ENTRY_UNMUNICIPALIZEDS_10306483843849279865)],
        &[(0b10010, &ENTRY_UNMUTUALIZED_3987921361376909408)],
        &[(0b10010, &ENTRY_UNMUTUALIZEDDER_15475671606898414830)],
        &[(0b10010, &ENTRY_UNMUTUALIZEDDEST_9840735398085807516)],
        &[(0b10010, &ENTRY_UNMUTUALIZEDS_11478246322803926821)],
        &[(0b01001, &ENTRY_UNMUTUALIZED_3987921361376909408)],
        &[(0b01001, &ENTRY_UNMUTUALIZEDDER_15475671606898414830)],
        &[(0b01001, &ENTRY_UNMUTUALIZEDDEST_9840735398085807516)],
        &[(0b01001, &ENTRY_UNMUTUALIZEDS_11478246322803926821)],
    ],
    range: 8..=15,
};

static VARS_UNMO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNMO_CHILDREN),
    value: None,
};

pub static VARS_UNMO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bilised"),
        dictgen::InsensitiveStr::Ascii("bilisedder"),
        dictgen::InsensitiveStr::Ascii("biliseddest"),
        dictgen::InsensitiveStr::Ascii("biliseds"),
        dictgen::InsensitiveStr::Ascii("bilized"),
        dictgen::InsensitiveStr::Ascii("bilizedder"),
        dictgen::InsensitiveStr::Ascii("bilizeddest"),
        dictgen::InsensitiveStr::Ascii("bilizeds"),
        dictgen::InsensitiveStr::Ascii("dernise"),
        dictgen::InsensitiveStr::Ascii("dernised"),
        dictgen::InsensitiveStr::Ascii("dernisedder"),
        dictgen::InsensitiveStr::Ascii("derniseddest"),
        dictgen::InsensitiveStr::Ascii("dernises"),
        dictgen::InsensitiveStr::Ascii("dernize"),
        dictgen::InsensitiveStr::Ascii("dernized"),
        dictgen::InsensitiveStr::Ascii("dernizedder"),
        dictgen::InsensitiveStr::Ascii("dernizeddest"),
        dictgen::InsensitiveStr::Ascii("dernizes"),
        dictgen::InsensitiveStr::Ascii("nopolise"),
        dictgen::InsensitiveStr::Ascii("nopolised"),
        dictgen::InsensitiveStr::Ascii("nopolisedder"),
        dictgen::InsensitiveStr::Ascii("nopoliseddest"),
        dictgen::InsensitiveStr::Ascii("nopolises"),
        dictgen::InsensitiveStr::Ascii("nopolising"),
        dictgen::InsensitiveStr::Ascii("nopolisinger"),
        dictgen::InsensitiveStr::Ascii("nopolisingest"),
        dictgen::InsensitiveStr::Ascii("nopolisings"),
        dictgen::InsensitiveStr::Ascii("nopolize"),
        dictgen::InsensitiveStr::Ascii("nopolized"),
        dictgen::InsensitiveStr::Ascii("nopolizedder"),
        dictgen::InsensitiveStr::Ascii("nopolizeddest"),
        dictgen::InsensitiveStr::Ascii("nopolizes"),
        dictgen::InsensitiveStr::Ascii("nopolizing"),
        dictgen::InsensitiveStr::Ascii("nopolizinger"),
        dictgen::InsensitiveStr::Ascii("nopolizingest"),
        dictgen::InsensitiveStr::Ascii("nopolizings"),
        dictgen::InsensitiveStr::Ascii("ralise"),
        dictgen::InsensitiveStr::Ascii("ralised"),
        dictgen::InsensitiveStr::Ascii("ralises"),
        dictgen::InsensitiveStr::Ascii("ralising"),
        dictgen::InsensitiveStr::Ascii("ralisinger"),
        dictgen::InsensitiveStr::Ascii("ralisingest"),
        dictgen::InsensitiveStr::Ascii("ralisings"),
        dictgen::InsensitiveStr::Ascii("ralize"),
        dictgen::InsensitiveStr::Ascii("ralized"),
        dictgen::InsensitiveStr::Ascii("ralizes"),
        dictgen::InsensitiveStr::Ascii("ralizing"),
        dictgen::InsensitiveStr::Ascii("ralizinger"),
        dictgen::InsensitiveStr::Ascii("ralizingest"),
        dictgen::InsensitiveStr::Ascii("ralizings"),
        dictgen::InsensitiveStr::Ascii("torised"),
        dictgen::InsensitiveStr::Ascii("torisedder"),
        dictgen::InsensitiveStr::Ascii("toriseddest"),
        dictgen::InsensitiveStr::Ascii("torized"),
        dictgen::InsensitiveStr::Ascii("torizedder"),
        dictgen::InsensitiveStr::Ascii("torizeddest"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNMOBILIZED_8792915223828792882)],
        &[(0b10010, &ENTRY_UNMOBILIZEDDER_13885990523982700388)],
        &[(0b10010, &ENTRY_UNMOBILIZEDDEST_16430132456615956501)],
        &[(0b10010, &ENTRY_UNMOBILIZEDS_2823498892381128223)],
        &[(0b01001, &ENTRY_UNMOBILIZED_8792915223828792882)],
        &[(0b01001, &ENTRY_UNMOBILIZEDDER_13885990523982700388)],
        &[(0b01001, &ENTRY_UNMOBILIZEDDEST_16430132456615956501)],
        &[(0b01001, &ENTRY_UNMOBILIZEDS_2823498892381128223)],
        &[(0b10010, &ENTRY_UNMODERNIZE_12047442119533678951)],
        &[(0b10010, &ENTRY_UNMODERNIZED_12442385813229323597)],
        &[(0b10010, &ENTRY_UNMODERNIZEDDER_17177773102034890156)],
        &[(0b10010, &ENTRY_UNMODERNIZEDDEST_6107579015702829368)],
        &[(0b10010, &ENTRY_UNMODERNIZES_16814040681635851958)],
        &[(0b01001, &ENTRY_UNMODERNIZE_12047442119533678951)],
        &[(0b01001, &ENTRY_UNMODERNIZED_12442385813229323597)],
        &[(0b01001, &ENTRY_UNMODERNIZEDDER_17177773102034890156)],
        &[(0b01001, &ENTRY_UNMODERNIZEDDEST_6107579015702829368)],
        &[(0b01001, &ENTRY_UNMODERNIZES_16814040681635851958)],
        &[(0b10010, &ENTRY_UNMONOPOLIZE_8209609104862396740)],
        &[(0b10010, &ENTRY_UNMONOPOLIZED_15103252142985776491)],
        &[(0b10010, &ENTRY_UNMONOPOLIZEDDER_367444066669166581)],
        &[(0b10010, &ENTRY_UNMONOPOLIZEDDEST_11036465831290540300)],
        &[(0b10010, &ENTRY_UNMONOPOLIZES_8604670551607021504)],
        &[(0b10010, &ENTRY_UNMONOPOLIZING_780658382091540167)],
        &[(0b10010, &ENTRY_UNMONOPOLIZINGER_8082734413560432137)],
        &[(0b10010, &ENTRY_UNMONOPOLIZINGEST_16940303846507911638)],
        &[(0b10010, &ENTRY_UNMONOPOLIZINGS_2368394829208842158)],
        &[(0b01001, &ENTRY_UNMONOPOLIZE_8209609104862396740)],
        &[(0b01001, &ENTRY_UNMONOPOLIZED_15103252142985776491)],
        &[(0b01001, &ENTRY_UNMONOPOLIZEDDER_367444066669166581)],
        &[(0b01001, &ENTRY_UNMONOPOLIZEDDEST_11036465831290540300)],
        &[(0b01001, &ENTRY_UNMONOPOLIZES_8604670551607021504)],
        &[(0b01001, &ENTRY_UNMONOPOLIZING_780658382091540167)],
        &[(0b01001, &ENTRY_UNMONOPOLIZINGER_8082734413560432137)],
        &[(0b01001, &ENTRY_UNMONOPOLIZINGEST_16940303846507911638)],
        &[(0b01001, &ENTRY_UNMONOPOLIZINGS_2368394829208842158)],
        &[(0b10010, &ENTRY_UNMORALIZE_5811178603962947867)],
        &[(0b10010, &ENTRY_UNMORALIZED_1809019658766145871)],
        &[(0b10010, &ENTRY_UNMORALIZES_2054617732298010888)],
        &[(0b10010, &ENTRY_UNMORALIZING_1635343207643393146)],
        &[(0b10010, &ENTRY_UNMORALIZINGER_2630621700200103097)],
        &[(0b10010, &ENTRY_UNMORALIZINGEST_10371338958162242360)],
        &[(0b10010, &ENTRY_UNMORALIZINGS_13530220804505456674)],
        &[(0b01001, &ENTRY_UNMORALIZE_5811178603962947867)],
        &[(0b01001, &ENTRY_UNMORALIZED_1809019658766145871)],
        &[(0b01001, &ENTRY_UNMORALIZES_2054617732298010888)],
        &[(0b01001, &ENTRY_UNMORALIZING_1635343207643393146)],
        &[(0b01001, &ENTRY_UNMORALIZINGER_2630621700200103097)],
        &[(0b01001, &ENTRY_UNMORALIZINGEST_10371338958162242360)],
        &[(0b01001, &ENTRY_UNMORALIZINGS_13530220804505456674)],
        &[(0b10010, &ENTRY_UNMOTORIZED_6782143677493579372)],
        &[(0b10010, &ENTRY_UNMOTORIZEDDER_4737848326164812310)],
        &[(0b10010, &ENTRY_UNMOTORIZEDDEST_15245325937655928512)],
        &[(0b01001, &ENTRY_UNMOTORIZED_6782143677493579372)],
        &[(0b01001, &ENTRY_UNMOTORIZEDDER_4737848326164812310)],
        &[(0b01001, &ENTRY_UNMOTORIZEDDEST_15245325937655928512)],
    ],
    range: 6..=13,
};

static VARS_UNMI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNMI_CHILDREN),
    value: None,
};

pub static VARS_UNMI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("litarised"),
        dictgen::InsensitiveStr::Ascii("litarized"),
        dictgen::InsensitiveStr::Ascii("neralised"),
        dictgen::InsensitiveStr::Ascii("neralisedder"),
        dictgen::InsensitiveStr::Ascii("neraliseddest"),
        dictgen::InsensitiveStr::Ascii("neraliseds"),
        dictgen::InsensitiveStr::Ascii("neralized"),
        dictgen::InsensitiveStr::Ascii("neralizedder"),
        dictgen::InsensitiveStr::Ascii("neralizeddest"),
        dictgen::InsensitiveStr::Ascii("neralizeds"),
        dictgen::InsensitiveStr::Ascii("nimised"),
        dictgen::InsensitiveStr::Ascii("nimisedder"),
        dictgen::InsensitiveStr::Ascii("nimiseddest"),
        dictgen::InsensitiveStr::Ascii("nimising"),
        dictgen::InsensitiveStr::Ascii("nimized"),
        dictgen::InsensitiveStr::Ascii("nimizedder"),
        dictgen::InsensitiveStr::Ascii("nimizeddest"),
        dictgen::InsensitiveStr::Ascii("nimizing"),
        dictgen::InsensitiveStr::Ascii("ssionised"),
        dictgen::InsensitiveStr::Ascii("ssioniseds"),
        dictgen::InsensitiveStr::Ascii("ssionized"),
        dictgen::InsensitiveStr::Ascii("ssionizeds"),
        dictgen::InsensitiveStr::Ascii("ter"),
        dictgen::InsensitiveStr::Ascii("ters"),
        dictgen::InsensitiveStr::Ascii("tre"),
        dictgen::InsensitiveStr::Ascii("tres"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNMILITARIZED_583903044185013301)],
        &[(0b01001, &ENTRY_UNMILITARIZED_583903044185013301)],
        &[(0b10010, &ENTRY_UNMINERALIZED_13805636642989384132)],
        &[(0b10010, &ENTRY_UNMINERALIZEDDER_15629225524896238795)],
        &[(0b10010, &ENTRY_UNMINERALIZEDDEST_9301755093437071771)],
        &[(0b10010, &ENTRY_UNMINERALIZEDS_14328671455943502679)],
        &[(0b01001, &ENTRY_UNMINERALIZED_13805636642989384132)],
        &[(0b01001, &ENTRY_UNMINERALIZEDDER_15629225524896238795)],
        &[(0b01001, &ENTRY_UNMINERALIZEDDEST_9301755093437071771)],
        &[(0b01001, &ENTRY_UNMINERALIZEDS_14328671455943502679)],
        &[(0b10010, &ENTRY_UNMINIMIZED_2413573858255300069)],
        &[(0b10010, &ENTRY_UNMINIMIZEDDER_10273703457324240806)],
        &[(0b10010, &ENTRY_UNMINIMIZEDDEST_2442440839355809588)],
        &[(0b10010, &ENTRY_UNMINIMIZING_14406353280475862221)],
        &[(0b01001, &ENTRY_UNMINIMIZED_2413573858255300069)],
        &[(0b01001, &ENTRY_UNMINIMIZEDDER_10273703457324240806)],
        &[(0b01001, &ENTRY_UNMINIMIZEDDEST_2442440839355809588)],
        &[(0b01001, &ENTRY_UNMINIMIZING_14406353280475862221)],
        &[(0b10010, &ENTRY_UNMISSIONIZED_8479883138336012141)],
        &[(0b10010, &ENTRY_UNMISSIONIZEDS_10090086707555908231)],
        &[(0b01001, &ENTRY_UNMISSIONIZED_8479883138336012141)],
        &[(0b01001, &ENTRY_UNMISSIONIZEDS_10090086707555908231)],
        &[(0b00001, &ENTRY_UNMITER_1266556994873335198)],
        &[(0b00001, &ENTRY_UNMITERS_8651507553417273017)],
        &[(0b11010, &ENTRY_UNMITER_1266556994873335198)],
        &[(0b11010, &ENTRY_UNMITERS_8651507553417273017)],
    ],
    range: 3..=13,
};

static VARS_UNME_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNME_CHILDREN),
    value: None,
};

pub static VARS_UNME_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("chanise"),
        dictgen::InsensitiveStr::Ascii("chanised"),
        dictgen::InsensitiveStr::Ascii("chanises"),
        dictgen::InsensitiveStr::Ascii("chanising"),
        dictgen::InsensitiveStr::Ascii("chanize"),
        dictgen::InsensitiveStr::Ascii("chanized"),
        dictgen::InsensitiveStr::Ascii("chanizes"),
        dictgen::InsensitiveStr::Ascii("chanizing"),
        dictgen::InsensitiveStr::Ascii("diaeval"),
        dictgen::InsensitiveStr::Ascii("diatised"),
        dictgen::InsensitiveStr::Ascii("diatiseds"),
        dictgen::InsensitiveStr::Ascii("diatized"),
        dictgen::InsensitiveStr::Ascii("diatizeds"),
        dictgen::InsensitiveStr::Ascii("dieval"),
        dictgen::InsensitiveStr::Ascii("lodised"),
        dictgen::InsensitiveStr::Ascii("lodized"),
        dictgen::InsensitiveStr::Ascii("morialised"),
        dictgen::InsensitiveStr::Ascii("morialisedder"),
        dictgen::InsensitiveStr::Ascii("morialiseddest"),
        dictgen::InsensitiveStr::Ascii("morialiseds"),
        dictgen::InsensitiveStr::Ascii("morialized"),
        dictgen::InsensitiveStr::Ascii("morializedder"),
        dictgen::InsensitiveStr::Ascii("morializeddest"),
        dictgen::InsensitiveStr::Ascii("morializeds"),
        dictgen::InsensitiveStr::Ascii("morised"),
        dictgen::InsensitiveStr::Ascii("morized"),
        dictgen::InsensitiveStr::Ascii("rcerised"),
        dictgen::InsensitiveStr::Ascii("rceriseds"),
        dictgen::InsensitiveStr::Ascii("rcerized"),
        dictgen::InsensitiveStr::Ascii("rcerizeds"),
        dictgen::InsensitiveStr::Ascii("smerise"),
        dictgen::InsensitiveStr::Ascii("smerised"),
        dictgen::InsensitiveStr::Ascii("smerisedder"),
        dictgen::InsensitiveStr::Ascii("smeriseddest"),
        dictgen::InsensitiveStr::Ascii("smerises"),
        dictgen::InsensitiveStr::Ascii("smerize"),
        dictgen::InsensitiveStr::Ascii("smerized"),
        dictgen::InsensitiveStr::Ascii("smerizedder"),
        dictgen::InsensitiveStr::Ascii("smerizeddest"),
        dictgen::InsensitiveStr::Ascii("smerizes"),
        dictgen::InsensitiveStr::Ascii("talized"),
        dictgen::InsensitiveStr::Ascii("talizeds"),
        dictgen::InsensitiveStr::Ascii("tallised"),
        dictgen::InsensitiveStr::Ascii("talliseds"),
        dictgen::InsensitiveStr::Ascii("tallized"),
        dictgen::InsensitiveStr::Ascii("tallizeds"),
        dictgen::InsensitiveStr::Ascii("thodised"),
        dictgen::InsensitiveStr::Ascii("thodisedder"),
        dictgen::InsensitiveStr::Ascii("thodiseddest"),
        dictgen::InsensitiveStr::Ascii("thodiseds"),
        dictgen::InsensitiveStr::Ascii("thodising"),
        dictgen::InsensitiveStr::Ascii("thodisinger"),
        dictgen::InsensitiveStr::Ascii("thodisingest"),
        dictgen::InsensitiveStr::Ascii("thodisings"),
        dictgen::InsensitiveStr::Ascii("thodized"),
        dictgen::InsensitiveStr::Ascii("thodizedder"),
        dictgen::InsensitiveStr::Ascii("thodizeddest"),
        dictgen::InsensitiveStr::Ascii("thodizeds"),
        dictgen::InsensitiveStr::Ascii("thodizing"),
        dictgen::InsensitiveStr::Ascii("thodizinger"),
        dictgen::InsensitiveStr::Ascii("thodizingest"),
        dictgen::InsensitiveStr::Ascii("thodizings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNMECHANIZE_11190176714541551865)],
        &[(0b10010, &ENTRY_UNMECHANIZED_4269395601940403385)],
        &[(0b10010, &ENTRY_UNMECHANIZES_165760147883759220)],
        &[(0b10010, &ENTRY_UNMECHANIZING_506881294102189838)],
        &[(0b01001, &ENTRY_UNMECHANIZE_11190176714541551865)],
        &[(0b01001, &ENTRY_UNMECHANIZED_4269395601940403385)],
        &[(0b01001, &ENTRY_UNMECHANIZES_165760147883759220)],
        &[(0b01001, &ENTRY_UNMECHANIZING_506881294102189838)],
        &[(0b11010, &ENTRY_UNMEDIEVAL_15136839068156180300)],
        &[(0b10010, &ENTRY_UNMEDIATIZED_2290392514230277768)],
        &[(0b10010, &ENTRY_UNMEDIATIZEDS_1136374808671187759)],
        &[(0b01001, &ENTRY_UNMEDIATIZED_2290392514230277768)],
        &[(0b01001, &ENTRY_UNMEDIATIZEDS_1136374808671187759)],
        &[(0b00001, &ENTRY_UNMEDIEVAL_15136839068156180300)],
        &[(0b10010, &ENTRY_UNMELODIZED_6500550653004535054)],
        &[(0b01001, &ENTRY_UNMELODIZED_6500550653004535054)],
        &[(0b10010, &ENTRY_UNMEMORIALIZED_6600017525226329095)],
        &[(0b10010, &ENTRY_UNMEMORIALIZEDDER_10743801469581680168)],
        &[(0b10010, &ENTRY_UNMEMORIALIZEDDEST_13083723319671530750)],
        &[(0b10010, &ENTRY_UNMEMORIALIZEDS_14410279063249438063)],
        &[(0b01001, &ENTRY_UNMEMORIALIZED_6600017525226329095)],
        &[(0b01001, &ENTRY_UNMEMORIALIZEDDER_10743801469581680168)],
        &[(0b01001, &ENTRY_UNMEMORIALIZEDDEST_13083723319671530750)],
        &[(0b01001, &ENTRY_UNMEMORIALIZEDS_14410279063249438063)],
        &[(0b10010, &ENTRY_UNMEMORIZED_14626006795396178705)],
        &[(0b01001, &ENTRY_UNMEMORIZED_14626006795396178705)],
        &[(0b10010, &ENTRY_UNMERCERIZED_5852682934764830097)],
        &[(0b10010, &ENTRY_UNMERCERIZEDS_401622175139065596)],
        &[(0b01001, &ENTRY_UNMERCERIZED_5852682934764830097)],
        &[(0b01001, &ENTRY_UNMERCERIZEDS_401622175139065596)],
        &[(0b10010, &ENTRY_UNMESMERIZE_14813961012908823827)],
        &[(0b10010, &ENTRY_UNMESMERIZED_15728753808617264765)],
        &[(0b10010, &ENTRY_UNMESMERIZEDDER_2203744214809621680)],
        &[(0b10010, &ENTRY_UNMESMERIZEDDEST_6656931439181344486)],
        &[(0b10010, &ENTRY_UNMESMERIZES_18225538558952151368)],
        &[(0b01001, &ENTRY_UNMESMERIZE_14813961012908823827)],
        &[(0b01001, &ENTRY_UNMESMERIZED_15728753808617264765)],
        &[(0b01001, &ENTRY_UNMESMERIZEDDER_2203744214809621680)],
        &[(0b01001, &ENTRY_UNMESMERIZEDDEST_6656931439181344486)],
        &[(0b01001, &ENTRY_UNMESMERIZES_18225538558952151368)],
        &[(0b00001, &ENTRY_UNMETALIZED_14653098959762201949)],
        &[(0b00001, &ENTRY_UNMETALIZEDS_3049138545470459904)],
        &[(0b10010, &ENTRY_UNMETALIZED_14653098959762201949)],
        &[(0b10010, &ENTRY_UNMETALIZEDS_3049138545470459904)],
        &[(0b01000, &ENTRY_UNMETALIZED_14653098959762201949)],
        &[(0b01000, &ENTRY_UNMETALIZEDS_3049138545470459904)],
        &[(0b10010, &ENTRY_UNMETHODIZED_2715309362450077299)],
        &[(0b10010, &ENTRY_UNMETHODIZEDDER_14167275580698305003)],
        &[(0b10010, &ENTRY_UNMETHODIZEDDEST_5772600382723646544)],
        &[(0b10010, &ENTRY_UNMETHODIZEDS_10683531682808152372)],
        &[(0b10010, &ENTRY_UNMETHODIZING_4738341700288635217)],
        &[(0b10010, &ENTRY_UNMETHODIZINGER_3360650520164951225)],
        &[(0b10010, &ENTRY_UNMETHODIZINGEST_7025390942240350340)],
        &[(0b10010, &ENTRY_UNMETHODIZINGS_15327848455170179924)],
        &[(0b01001, &ENTRY_UNMETHODIZED_2715309362450077299)],
        &[(0b01001, &ENTRY_UNMETHODIZEDDER_14167275580698305003)],
        &[(0b01001, &ENTRY_UNMETHODIZEDDEST_5772600382723646544)],
        &[(0b01001, &ENTRY_UNMETHODIZEDS_10683531682808152372)],
        &[(0b01001, &ENTRY_UNMETHODIZING_4738341700288635217)],
        &[(0b01001, &ENTRY_UNMETHODIZINGER_3360650520164951225)],
        &[(0b01001, &ENTRY_UNMETHODIZINGEST_7025390942240350340)],
        &[(0b01001, &ENTRY_UNMETHODIZINGS_15327848455170179924)],
    ],
    range: 6..=14,
};

static VARS_UNMA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNMA_CHILDREN),
    value: None,
};

pub static VARS_UNMA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cadamised"),
        dictgen::InsensitiveStr::Ascii("cadamized"),
        dictgen::InsensitiveStr::Ascii("gnetised"),
        dictgen::InsensitiveStr::Ascii("gnetisedder"),
        dictgen::InsensitiveStr::Ascii("gnetiseddest"),
        dictgen::InsensitiveStr::Ascii("gnetiseds"),
        dictgen::InsensitiveStr::Ascii("gnetized"),
        dictgen::InsensitiveStr::Ascii("gnetizedder"),
        dictgen::InsensitiveStr::Ascii("gnetizeddest"),
        dictgen::InsensitiveStr::Ascii("gnetizeds"),
        dictgen::InsensitiveStr::Ascii("terialised"),
        dictgen::InsensitiveStr::Ascii("terialized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNMACADAMIZED_17474698526570727920)],
        &[(0b01001, &ENTRY_UNMACADAMIZED_17474698526570727920)],
        &[(0b10010, &ENTRY_UNMAGNETIZED_15659278602348180756)],
        &[(0b10010, &ENTRY_UNMAGNETIZEDDER_15921026948300347060)],
        &[(0b10010, &ENTRY_UNMAGNETIZEDDEST_9811017267349487901)],
        &[(0b10010, &ENTRY_UNMAGNETIZEDS_18035379637239565234)],
        &[(0b01001, &ENTRY_UNMAGNETIZED_15659278602348180756)],
        &[(0b01001, &ENTRY_UNMAGNETIZEDDER_15921026948300347060)],
        &[(0b01001, &ENTRY_UNMAGNETIZEDDEST_9811017267349487901)],
        &[(0b01001, &ENTRY_UNMAGNETIZEDS_18035379637239565234)],
        &[(0b10010, &ENTRY_UNMATERIALIZED_2222039272937406727)],
        &[(0b01001, &ENTRY_UNMATERIALIZED_2222039272937406727)],
    ],
    range: 8..=12,
};

static VARS_UNL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UNL_CHILDREN),
    value: None,
};

static VARS_UNL_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_UNLA_NODE),
    None,
    None,
    None,
    Some(&VARS_UNLE_NODE),
    None,
    None,
    None,
    Some(&VARS_UNLI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UNLO_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_UNLO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNLO_CHILDREN),
    value: None,
};

pub static VARS_UNLO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("calisable"),
        dictgen::InsensitiveStr::Ascii("calisabler"),
        dictgen::InsensitiveStr::Ascii("calisables"),
        dictgen::InsensitiveStr::Ascii("calisablest"),
        dictgen::InsensitiveStr::Ascii("calise"),
        dictgen::InsensitiveStr::Ascii("calised"),
        dictgen::InsensitiveStr::Ascii("calises"),
        dictgen::InsensitiveStr::Ascii("calising"),
        dictgen::InsensitiveStr::Ascii("calizable"),
        dictgen::InsensitiveStr::Ascii("calizabler"),
        dictgen::InsensitiveStr::Ascii("calizables"),
        dictgen::InsensitiveStr::Ascii("calizablest"),
        dictgen::InsensitiveStr::Ascii("calize"),
        dictgen::InsensitiveStr::Ascii("calized"),
        dictgen::InsensitiveStr::Ascii("calizes"),
        dictgen::InsensitiveStr::Ascii("calizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNLOCALIZABLE_9968738969162630281)],
        &[(0b10010, &ENTRY_UNLOCALIZABLER_1057258441085295588)],
        &[(0b10010, &ENTRY_UNLOCALIZABLES_11709528533561573241)],
        &[(0b10010, &ENTRY_UNLOCALIZABLEST_15276491984146533505)],
        &[(0b10010, &ENTRY_UNLOCALIZE_13492036293954003927)],
        &[(0b10010, &ENTRY_UNLOCALIZED_13119882870487585082)],
        &[(0b10010, &ENTRY_UNLOCALIZES_3658083138206741140)],
        &[(0b10010, &ENTRY_UNLOCALIZING_11595539427192644971)],
        &[(0b01001, &ENTRY_UNLOCALIZABLE_9968738969162630281)],
        &[(0b01001, &ENTRY_UNLOCALIZABLER_1057258441085295588)],
        &[(0b01001, &ENTRY_UNLOCALIZABLES_11709528533561573241)],
        &[(0b01001, &ENTRY_UNLOCALIZABLEST_15276491984146533505)],
        &[(0b01001, &ENTRY_UNLOCALIZE_13492036293954003927)],
        &[(0b01001, &ENTRY_UNLOCALIZED_13119882870487585082)],
        &[(0b01001, &ENTRY_UNLOCALIZES_3658083138206741140)],
        &[(0b01001, &ENTRY_UNLOCALIZING_11595539427192644971)],
    ],
    range: 6..=11,
};

static VARS_UNLI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNLI_CHILDREN),
    value: None,
};

pub static VARS_UNLI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("beralised"),
        dictgen::InsensitiveStr::Ascii("beralisedder"),
        dictgen::InsensitiveStr::Ascii("beraliseddest"),
        dictgen::InsensitiveStr::Ascii("beralized"),
        dictgen::InsensitiveStr::Ascii("beralizedder"),
        dictgen::InsensitiveStr::Ascii("beralizeddest"),
        dictgen::InsensitiveStr::Ascii("onised"),
        dictgen::InsensitiveStr::Ascii("onized"),
        dictgen::InsensitiveStr::Ascii("teralised"),
        dictgen::InsensitiveStr::Ascii("teralized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNLIBERALIZED_10969839816283449452)],
        &[(0b10010, &ENTRY_UNLIBERALIZEDDER_15315614160099270434)],
        &[(0b10010, &ENTRY_UNLIBERALIZEDDEST_13889596379187644396)],
        &[(0b01001, &ENTRY_UNLIBERALIZED_10969839816283449452)],
        &[(0b01001, &ENTRY_UNLIBERALIZEDDER_15315614160099270434)],
        &[(0b01001, &ENTRY_UNLIBERALIZEDDEST_13889596379187644396)],
        &[(0b10010, &ENTRY_UNLIONIZED_16819690612045451722)],
        &[(0b01001, &ENTRY_UNLIONIZED_16819690612045451722)],
        &[(0b10010, &ENTRY_UNLITERALIZED_5582864502376513867)],
        &[(0b01001, &ENTRY_UNLITERALIZED_5582864502376513867)],
    ],
    range: 6..=13,
};

static VARS_UNLE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNLE_CHILDREN),
    value: None,
};

pub static VARS_UNLE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arnt"),
        dictgen::InsensitiveStr::Ascii("galised"),
        dictgen::InsensitiveStr::Ascii("galisedder"),
        dictgen::InsensitiveStr::Ascii("galiseddest"),
        dictgen::InsensitiveStr::Ascii("galized"),
        dictgen::InsensitiveStr::Ascii("galizedder"),
        dictgen::InsensitiveStr::Ascii("galizeddest"),
        dictgen::InsensitiveStr::Ascii("veled"),
        dictgen::InsensitiveStr::Ascii("veling"),
        dictgen::InsensitiveStr::Ascii("velled"),
        dictgen::InsensitiveStr::Ascii("velling"),
    ],
    values: &[
        &[(0b11010, &ENTRY_UNLEARNED_9662354567541580896)],
        &[(0b10010, &ENTRY_UNLEGALIZED_11280366291234483355)],
        &[(0b10010, &ENTRY_UNLEGALIZEDDER_6121814624457190630)],
        &[(0b10010, &ENTRY_UNLEGALIZEDDEST_1908746545075061751)],
        &[(0b01001, &ENTRY_UNLEGALIZED_11280366291234483355)],
        &[(0b01001, &ENTRY_UNLEGALIZEDDER_6121814624457190630)],
        &[(0b01001, &ENTRY_UNLEGALIZEDDEST_1908746545075061751)],
        &[(0b00001, &ENTRY_UNLEVELED_13198441829918947958)],
        &[(0b00001, &ENTRY_UNLEVELING_8030863631176281003)],
        &[(0b11010, &ENTRY_UNLEVELED_13198441829918947958)],
        &[(0b11010, &ENTRY_UNLEVELING_8030863631176281003)],
    ],
    range: 4..=11,
};

static VARS_UNLA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNLA_CHILDREN),
    value: None,
};

pub static VARS_UNLA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("beled"),
        dictgen::InsensitiveStr::Ascii("beledder"),
        dictgen::InsensitiveStr::Ascii("beleddest"),
        dictgen::InsensitiveStr::Ascii("belled"),
        dictgen::InsensitiveStr::Ascii("belledder"),
        dictgen::InsensitiveStr::Ascii("belleddest"),
        dictgen::InsensitiveStr::Ascii("bialise"),
        dictgen::InsensitiveStr::Ascii("bialised"),
        dictgen::InsensitiveStr::Ascii("bialises"),
        dictgen::InsensitiveStr::Ascii("bialising"),
        dictgen::InsensitiveStr::Ascii("bialize"),
        dictgen::InsensitiveStr::Ascii("bialized"),
        dictgen::InsensitiveStr::Ascii("bializes"),
        dictgen::InsensitiveStr::Ascii("bializing"),
        dictgen::InsensitiveStr::Ascii("borable"),
        dictgen::InsensitiveStr::Ascii("borables"),
        dictgen::InsensitiveStr::Ascii("bored"),
        dictgen::InsensitiveStr::Ascii("boredder"),
        dictgen::InsensitiveStr::Ascii("boreddest"),
        dictgen::InsensitiveStr::Ascii("boring"),
        dictgen::InsensitiveStr::Ascii("boringer"),
        dictgen::InsensitiveStr::Ascii("boringest"),
        dictgen::InsensitiveStr::Ascii("borings"),
        dictgen::InsensitiveStr::Ascii("bourable"),
        dictgen::InsensitiveStr::Ascii("bourables"),
        dictgen::InsensitiveStr::Ascii("boured"),
        dictgen::InsensitiveStr::Ascii("bouredder"),
        dictgen::InsensitiveStr::Ascii("boureddest"),
        dictgen::InsensitiveStr::Ascii("bouring"),
        dictgen::InsensitiveStr::Ascii("bouringer"),
        dictgen::InsensitiveStr::Ascii("bouringest"),
        dictgen::InsensitiveStr::Ascii("bourings"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNLABELED_11329682996906852666)],
        &[(0b00001, &ENTRY_UNLABELEDDER_12664387197615721853)],
        &[(0b00001, &ENTRY_UNLABELEDDEST_10069015802563086742)],
        &[(0b11010, &ENTRY_UNLABELED_11329682996906852666)],
        &[(0b11010, &ENTRY_UNLABELEDDER_12664387197615721853)],
        &[(0b11010, &ENTRY_UNLABELEDDEST_10069015802563086742)],
        &[(0b10010, &ENTRY_UNLABIALIZE_217736053462734651)],
        &[(0b10010, &ENTRY_UNLABIALIZED_3984566951140164532)],
        &[(0b10010, &ENTRY_UNLABIALIZES_5567127362436352005)],
        &[(0b10010, &ENTRY_UNLABIALIZING_6104103553465648864)],
        &[(0b01001, &ENTRY_UNLABIALIZE_217736053462734651)],
        &[(0b01001, &ENTRY_UNLABIALIZED_3984566951140164532)],
        &[(0b01001, &ENTRY_UNLABIALIZES_5567127362436352005)],
        &[(0b01001, &ENTRY_UNLABIALIZING_6104103553465648864)],
        &[(0b00001, &ENTRY_UNLABORABLE_917849914005923474)],
        &[(0b00001, &ENTRY_UNLABORABLES_6698240791463419426)],
        &[(0b00001, &ENTRY_UNLABORED_16469902531770188672)],
        &[(0b00001, &ENTRY_UNLABOREDDER_11699946147571417125)],
        &[(0b00001, &ENTRY_UNLABOREDDEST_1362587359789372781)],
        &[(0b00001, &ENTRY_UNLABORING_4591372183864637896)],
        &[(0b00001, &ENTRY_UNLABORINGER_6365954446709867985)],
        &[(0b00001, &ENTRY_UNLABORINGEST_1473791691960115175)],
        &[(0b00001, &ENTRY_UNLABORINGS_4425858704820356556)],
        &[(0b11010, &ENTRY_UNLABORABLE_917849914005923474)],
        &[(0b11010, &ENTRY_UNLABORABLES_6698240791463419426)],
        &[(0b11010, &ENTRY_UNLABORED_16469902531770188672)],
        &[(0b11010, &ENTRY_UNLABOREDDER_11699946147571417125)],
        &[(0b11010, &ENTRY_UNLABOREDDEST_1362587359789372781)],
        &[(0b11010, &ENTRY_UNLABORING_4591372183864637896)],
        &[(0b11010, &ENTRY_UNLABORINGER_6365954446709867985)],
        &[(0b11010, &ENTRY_UNLABORINGEST_1473791691960115175)],
        &[(0b11010, &ENTRY_UNLABORINGS_4425858704820356556)],
    ],
    range: 5..=10,
};

static VARS_UNK_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNK_CHILDREN),
    value: None,
};

pub static VARS_UNK_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("enneled"),
        dictgen::InsensitiveStr::Ascii("enneling"),
        dictgen::InsensitiveStr::Ascii("ennelled"),
        dictgen::InsensitiveStr::Ascii("ennelling"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNKENNELED_3312308653646352421)],
        &[(0b00001, &ENTRY_UNKENNELING_10813411767613768190)],
        &[(0b11010, &ENTRY_UNKENNELED_3312308653646352421)],
        &[(0b11010, &ENTRY_UNKENNELING_10813411767613768190)],
    ],
    range: 7..=9,
};

static VARS_UNJ_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNJ_CHILDREN),
    value: None,
};

pub static VARS_UNJ_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eopardised"),
        dictgen::InsensitiveStr::Ascii("eopardized"),
        dictgen::InsensitiveStr::Ascii("ournalised"),
        dictgen::InsensitiveStr::Ascii("ournalized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNJEOPARDIZED_13875602294611166238)],
        &[(0b01001, &ENTRY_UNJEOPARDIZED_13875602294611166238)],
        &[(0b10010, &ENTRY_UNJOURNALIZED_7826187459873218620)],
        &[(0b01001, &ENTRY_UNJOURNALIZED_7826187459873218620)],
    ],
    range: 10..=10,
};

static VARS_UNI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UNI_CHILDREN),
    value: None,
};

static VARS_UNI_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    Some(&VARS_UNIC_NODE),
    Some(&VARS_UNID_NODE),
    None,
    Some(&VARS_UNIF_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UNIL_NODE),
    Some(&VARS_UNIM_NODE),
    Some(&VARS_UNIN_NODE),
    Some(&VARS_UNIO_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_UNIT_NODE),
    None,
    Some(&VARS_UNIV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_UNIV_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNIV_CHILDREN),
    value: None,
};

pub static VARS_UNIV_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ersalisation"),
        dictgen::InsensitiveStr::Ascii("ersalisations"),
        dictgen::InsensitiveStr::Ascii("ersalise"),
        dictgen::InsensitiveStr::Ascii("ersalised"),
        dictgen::InsensitiveStr::Ascii("ersaliser"),
        dictgen::InsensitiveStr::Ascii("ersalisers"),
        dictgen::InsensitiveStr::Ascii("ersalises"),
        dictgen::InsensitiveStr::Ascii("ersalising"),
        dictgen::InsensitiveStr::Ascii("ersalization"),
        dictgen::InsensitiveStr::Ascii("ersalizations"),
        dictgen::InsensitiveStr::Ascii("ersalize"),
        dictgen::InsensitiveStr::Ascii("ersalized"),
        dictgen::InsensitiveStr::Ascii("ersalizer"),
        dictgen::InsensitiveStr::Ascii("ersalizers"),
        dictgen::InsensitiveStr::Ascii("ersalizes"),
        dictgen::InsensitiveStr::Ascii("ersalizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNIVERSALIZATION_9796721220313365644)],
        &[(0b10010, &ENTRY_UNIVERSALIZATIONS_18379991359571582461)],
        &[(0b10010, &ENTRY_UNIVERSALIZE_3144285012366914544)],
        &[(0b10010, &ENTRY_UNIVERSALIZED_3359716000611655342)],
        &[(0b10010, &ENTRY_UNIVERSALIZER_15363421758448558519)],
        &[(0b10010, &ENTRY_UNIVERSALIZERS_10160828143436328394)],
        &[(0b10010, &ENTRY_UNIVERSALIZES_5744703348821395274)],
        &[(0b10010, &ENTRY_UNIVERSALIZING_3081768953979402863)],
        &[(0b01001, &ENTRY_UNIVERSALIZATION_9796721220313365644)],
        &[(0b01001, &ENTRY_UNIVERSALIZATIONS_18379991359571582461)],
        &[(0b01001, &ENTRY_UNIVERSALIZE_3144285012366914544)],
        &[(0b01001, &ENTRY_UNIVERSALIZED_3359716000611655342)],
        &[(0b01001, &ENTRY_UNIVERSALIZER_15363421758448558519)],
        &[(0b01001, &ENTRY_UNIVERSALIZERS_10160828143436328394)],
        &[(0b01001, &ENTRY_UNIVERSALIZES_5744703348821395274)],
        &[(0b01001, &ENTRY_UNIVERSALIZING_3081768953979402863)],
    ],
    range: 8..=13,
};

static VARS_UNIT_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNIT_CHILDREN),
    value: None,
};

pub static VARS_UNIT_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alicised"),
        dictgen::InsensitiveStr::Ascii("alicized"),
        dictgen::InsensitiveStr::Ascii("arianise"),
        dictgen::InsensitiveStr::Ascii("arianises"),
        dictgen::InsensitiveStr::Ascii("arianize"),
        dictgen::InsensitiveStr::Ascii("arianizes"),
        dictgen::InsensitiveStr::Ascii("emised"),
        dictgen::InsensitiveStr::Ascii("emized"),
        dictgen::InsensitiveStr::Ascii("isation"),
        dictgen::InsensitiveStr::Ascii("isations"),
        dictgen::InsensitiveStr::Ascii("ise"),
        dictgen::InsensitiveStr::Ascii("ised"),
        dictgen::InsensitiveStr::Ascii("ises"),
        dictgen::InsensitiveStr::Ascii("ising"),
        dictgen::InsensitiveStr::Ascii("ization"),
        dictgen::InsensitiveStr::Ascii("izations"),
        dictgen::InsensitiveStr::Ascii("ize"),
        dictgen::InsensitiveStr::Ascii("ized"),
        dictgen::InsensitiveStr::Ascii("izes"),
        dictgen::InsensitiveStr::Ascii("izing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNITALICIZED_4803411370795702968)],
        &[(0b01001, &ENTRY_UNITALICIZED_4803411370795702968)],
        &[(0b10010, &ENTRY_UNITARIANIZE_11972012307902630006)],
        &[(0b10010, &ENTRY_UNITARIANIZES_3299086072898342977)],
        &[(0b01001, &ENTRY_UNITARIANIZE_11972012307902630006)],
        &[(0b01001, &ENTRY_UNITARIANIZES_3299086072898342977)],
        &[(0b10010, &ENTRY_UNITEMIZED_4057716424445166287)],
        &[(0b01001, &ENTRY_UNITEMIZED_4057716424445166287)],
        &[(0b10010, &ENTRY_UNITIZATION_18446645945229573845)],
        &[(0b10010, &ENTRY_UNITIZATIONS_11931524709956438375)],
        &[(0b10010, &ENTRY_UNITIZE_15650295066694421044)],
        &[(0b10010, &ENTRY_UNITIZED_3014655947841823471)],
        &[(0b10010, &ENTRY_UNITIZES_11137940003038331316)],
        &[(0b10010, &ENTRY_UNITIZING_14503461086641416326)],
        &[(0b01001, &ENTRY_UNITIZATION_18446645945229573845)],
        &[(0b01001, &ENTRY_UNITIZATIONS_11931524709956438375)],
        &[(0b01001, &ENTRY_UNITIZE_15650295066694421044)],
        &[(0b01001, &ENTRY_UNITIZED_3014655947841823471)],
        &[(0b01001, &ENTRY_UNITIZES_11137940003038331316)],
        &[(0b01001, &ENTRY_UNITIZING_14503461086641416326)],
    ],
    range: 3..=9,
};

static VARS_UNIO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNIO_CHILDREN),
    value: None,
};

pub static VARS_UNIO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("nisation"),
        dictgen::InsensitiveStr::Ascii("nisations"),
        dictgen::InsensitiveStr::Ascii("nise"),
        dictgen::InsensitiveStr::Ascii("nised"),
        dictgen::InsensitiveStr::Ascii("niser"),
        dictgen::InsensitiveStr::Ascii("nisers"),
        dictgen::InsensitiveStr::Ascii("nises"),
        dictgen::InsensitiveStr::Ascii("nising"),
        dictgen::InsensitiveStr::Ascii("nization"),
        dictgen::InsensitiveStr::Ascii("nizations"),
        dictgen::InsensitiveStr::Ascii("nize"),
        dictgen::InsensitiveStr::Ascii("nized"),
        dictgen::InsensitiveStr::Ascii("nizer"),
        dictgen::InsensitiveStr::Ascii("nizers"),
        dictgen::InsensitiveStr::Ascii("nizes"),
        dictgen::InsensitiveStr::Ascii("nizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNIONIZATION_7581063025295044509)],
        &[(0b10010, &ENTRY_UNIONIZATIONS_14252170992346338262)],
        &[(0b10010, &ENTRY_UNIONIZE_5473899911122601155)],
        &[(0b10010, &ENTRY_UNIONIZED_15115860277830672338)],
        &[(0b10010, &ENTRY_UNIONIZER_7597490110750505710)],
        &[(0b10010, &ENTRY_UNIONIZERS_5139286031818390886)],
        &[(0b10010, &ENTRY_UNIONIZES_15451870011342312257)],
        &[(0b10010, &ENTRY_UNIONIZING_13986959004042777567)],
        &[(0b01001, &ENTRY_UNIONIZATION_7581063025295044509)],
        &[(0b01001, &ENTRY_UNIONIZATIONS_14252170992346338262)],
        &[(0b01001, &ENTRY_UNIONIZE_5473899911122601155)],
        &[(0b01001, &ENTRY_UNIONIZED_15115860277830672338)],
        &[(0b01001, &ENTRY_UNIONIZER_7597490110750505710)],
        &[(0b01001, &ENTRY_UNIONIZERS_5139286031818390886)],
        &[(0b01001, &ENTRY_UNIONIZES_15451870011342312257)],
        &[(0b01001, &ENTRY_UNIONIZING_13986959004042777567)],
    ],
    range: 4..=9,
};

static VARS_UNIN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNIN_CHILDREN),
    value: None,
};

pub static VARS_UNIN_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("dividualise"),
        dictgen::InsensitiveStr::Ascii("dividualised"),
        dictgen::InsensitiveStr::Ascii("dividualises"),
        dictgen::InsensitiveStr::Ascii("dividualize"),
        dictgen::InsensitiveStr::Ascii("dividualized"),
        dictgen::InsensitiveStr::Ascii("dividualizes"),
        dictgen::InsensitiveStr::Ascii("dustrialised"),
        dictgen::InsensitiveStr::Ascii("dustrialiseds"),
        dictgen::InsensitiveStr::Ascii("dustrialized"),
        dictgen::InsensitiveStr::Ascii("dustrializeds"),
        dictgen::InsensitiveStr::Ascii("itialisable"),
        dictgen::InsensitiveStr::Ascii("itialised"),
        dictgen::InsensitiveStr::Ascii("itializable"),
        dictgen::InsensitiveStr::Ascii("itialized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNINDIVIDUALIZE_2549502263365684965)],
        &[(0b10010, &ENTRY_UNINDIVIDUALIZED_10177440970236663663)],
        &[(0b10010, &ENTRY_UNINDIVIDUALIZES_4576420283626985656)],
        &[(0b01001, &ENTRY_UNINDIVIDUALIZE_2549502263365684965)],
        &[(0b01001, &ENTRY_UNINDIVIDUALIZED_10177440970236663663)],
        &[(0b01001, &ENTRY_UNINDIVIDUALIZES_4576420283626985656)],
        &[(0b10010, &ENTRY_UNINDUSTRIALIZED_11443997120471272739)],
        &[(0b10010, &ENTRY_UNINDUSTRIALIZEDS_11481755961805717216)],
        &[(0b01001, &ENTRY_UNINDUSTRIALIZED_11443997120471272739)],
        &[(0b01001, &ENTRY_UNINDUSTRIALIZEDS_11481755961805717216)],
        &[(0b10010, &ENTRY_UNINITIALIZABLE_11628725753710848165)],
        &[(0b10010, &ENTRY_UNINITIALIZED_7444780362077778288)],
        &[(0b01001, &ENTRY_UNINITIALIZABLE_11628725753710848165)],
        &[(0b01001, &ENTRY_UNINITIALIZED_7444780362077778288)],
    ],
    range: 9..=13,
};

static VARS_UNIM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNIM_CHILDREN),
    value: None,
};

pub static VARS_UNIM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("mortalise"),
        dictgen::InsensitiveStr::Ascii("mortalised"),
        dictgen::InsensitiveStr::Ascii("mortalises"),
        dictgen::InsensitiveStr::Ascii("mortalize"),
        dictgen::InsensitiveStr::Ascii("mortalized"),
        dictgen::InsensitiveStr::Ascii("mortalizes"),
        dictgen::InsensitiveStr::Ascii("munised"),
        dictgen::InsensitiveStr::Ascii("munized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNIMMORTALIZE_3846660396067631341)],
        &[(0b10010, &ENTRY_UNIMMORTALIZED_13628471993003828487)],
        &[(0b10010, &ENTRY_UNIMMORTALIZES_16459195990493376386)],
        &[(0b01001, &ENTRY_UNIMMORTALIZE_3846660396067631341)],
        &[(0b01001, &ENTRY_UNIMMORTALIZED_13628471993003828487)],
        &[(0b01001, &ENTRY_UNIMMORTALIZES_16459195990493376386)],
        &[(0b10010, &ENTRY_UNIMMUNIZED_15421817966409765637)],
        &[(0b01001, &ENTRY_UNIMMUNIZED_15421817966409765637)],
    ],
    range: 7..=10,
};

static VARS_UNIL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNIL_CHILDREN),
    value: None,
};

pub static VARS_UNIL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ateralisation"),
        dictgen::InsensitiveStr::Ascii("ateralisations"),
        dictgen::InsensitiveStr::Ascii("ateralise"),
        dictgen::InsensitiveStr::Ascii("ateralises"),
        dictgen::InsensitiveStr::Ascii("ateralization"),
        dictgen::InsensitiveStr::Ascii("ateralizations"),
        dictgen::InsensitiveStr::Ascii("ateralize"),
        dictgen::InsensitiveStr::Ascii("ateralizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNILATERALIZATION_7642348548145928002)],
        &[(0b10010, &ENTRY_UNILATERALIZATIONS_3537291387881487266)],
        &[(0b10010, &ENTRY_UNILATERALIZE_4208361192869727001)],
        &[(0b10010, &ENTRY_UNILATERALIZES_13328450924130846629)],
        &[(0b01001, &ENTRY_UNILATERALIZATION_7642348548145928002)],
        &[(0b01001, &ENTRY_UNILATERALIZATIONS_3537291387881487266)],
        &[(0b01001, &ENTRY_UNILATERALIZE_4208361192869727001)],
        &[(0b01001, &ENTRY_UNILATERALIZES_13328450924130846629)],
    ],
    range: 9..=14,
};

static VARS_UNIF_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNIF_CHILDREN),
    value: None,
};

pub static VARS_UNIF_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ormisation"),
        dictgen::InsensitiveStr::Ascii("ormisations"),
        dictgen::InsensitiveStr::Ascii("ormise"),
        dictgen::InsensitiveStr::Ascii("ormised"),
        dictgen::InsensitiveStr::Ascii("ormises"),
        dictgen::InsensitiveStr::Ascii("ormising"),
        dictgen::InsensitiveStr::Ascii("ormization"),
        dictgen::InsensitiveStr::Ascii("ormizations"),
        dictgen::InsensitiveStr::Ascii("ormize"),
        dictgen::InsensitiveStr::Ascii("ormized"),
        dictgen::InsensitiveStr::Ascii("ormizes"),
        dictgen::InsensitiveStr::Ascii("ormizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNIFORMIZATION_6928779719483130632)],
        &[(0b10010, &ENTRY_UNIFORMIZATIONS_5553647000162520280)],
        &[(0b10010, &ENTRY_UNIFORMIZE_3224156171185377609)],
        &[(0b10010, &ENTRY_UNIFORMIZED_14730906052407110280)],
        &[(0b10010, &ENTRY_UNIFORMIZES_5570715002596396628)],
        &[(0b10010, &ENTRY_UNIFORMIZING_9818028196564001512)],
        &[(0b01001, &ENTRY_UNIFORMIZATION_6928779719483130632)],
        &[(0b01001, &ENTRY_UNIFORMIZATIONS_5553647000162520280)],
        &[(0b01001, &ENTRY_UNIFORMIZE_3224156171185377609)],
        &[(0b01001, &ENTRY_UNIFORMIZED_14730906052407110280)],
        &[(0b01001, &ENTRY_UNIFORMIZES_5570715002596396628)],
        &[(0b01001, &ENTRY_UNIFORMIZING_9818028196564001512)],
    ],
    range: 6..=11,
};

static VARS_UNID_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNID_CHILDREN),
    value: None,
};

pub static VARS_UNID_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ealised"),
        dictgen::InsensitiveStr::Ascii("ealisedder"),
        dictgen::InsensitiveStr::Ascii("ealiseddest"),
        dictgen::InsensitiveStr::Ascii("ealized"),
        dictgen::InsensitiveStr::Ascii("ealizedder"),
        dictgen::InsensitiveStr::Ascii("ealizeddest"),
        dictgen::InsensitiveStr::Ascii("olised"),
        dictgen::InsensitiveStr::Ascii("olisedder"),
        dictgen::InsensitiveStr::Ascii("oliseddest"),
        dictgen::InsensitiveStr::Ascii("oliseds"),
        dictgen::InsensitiveStr::Ascii("olized"),
        dictgen::InsensitiveStr::Ascii("olizedder"),
        dictgen::InsensitiveStr::Ascii("olizeddest"),
        dictgen::InsensitiveStr::Ascii("olizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNIDEALIZED_11116714704594641479)],
        &[(0b10010, &ENTRY_UNIDEALIZEDDER_15335158507099491677)],
        &[(0b10010, &ENTRY_UNIDEALIZEDDEST_9073505704713365354)],
        &[(0b01001, &ENTRY_UNIDEALIZED_11116714704594641479)],
        &[(0b01001, &ENTRY_UNIDEALIZEDDER_15335158507099491677)],
        &[(0b01001, &ENTRY_UNIDEALIZEDDEST_9073505704713365354)],
        &[(0b10010, &ENTRY_UNIDOLIZED_7746581993758703110)],
        &[(0b10010, &ENTRY_UNIDOLIZEDDER_9054539920726947230)],
        &[(0b10010, &ENTRY_UNIDOLIZEDDEST_11902819922448078654)],
        &[(0b10010, &ENTRY_UNIDOLIZEDS_6305662893482523010)],
        &[(0b01001, &ENTRY_UNIDOLIZED_7746581993758703110)],
        &[(0b01001, &ENTRY_UNIDOLIZEDDER_9054539920726947230)],
        &[(0b01001, &ENTRY_UNIDOLIZEDDEST_11902819922448078654)],
        &[(0b01001, &ENTRY_UNIDOLIZEDS_6305662893482523010)],
    ],
    range: 6..=11,
};

static VARS_UNIC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNIC_CHILDREN),
    value: None,
};

pub static VARS_UNIC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("olor"),
        dictgen::InsensitiveStr::Ascii("olorate"),
        dictgen::InsensitiveStr::Ascii("olored"),
        dictgen::InsensitiveStr::Ascii("olorous"),
        dictgen::InsensitiveStr::Ascii("olour"),
        dictgen::InsensitiveStr::Ascii("olourate"),
        dictgen::InsensitiveStr::Ascii("oloured"),
        dictgen::InsensitiveStr::Ascii("olourous"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNICOLOR_17123726217698406043)],
        &[(0b00001, &ENTRY_UNICOLORATE_7320982531251878580)],
        &[(0b00001, &ENTRY_UNICOLORED_15371219763539897842)],
        &[(0b00001, &ENTRY_UNICOLOROUS_9217819624867642093)],
        &[(0b11010, &ENTRY_UNICOLOR_17123726217698406043)],
        &[(0b11010, &ENTRY_UNICOLORATE_7320982531251878580)],
        &[(0b11010, &ENTRY_UNICOLORED_15371219763539897842)],
        &[(0b11010, &ENTRY_UNICOLOROUS_9217819624867642093)],
    ],
    range: 4..=8,
};

static VARS_UNH_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UNH_CHILDREN),
    value: None,
};

static VARS_UNH_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_UNHA_NODE),
    None,
    None,
    None,
    Some(&VARS_UNHE_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UNHO_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UNHU_NODE),
    None,
    None,
    None,
    Some(&VARS_UNHY_NODE),
    None,
];

static VARS_UNHY_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNHY_CHILDREN),
    value: None,
};

pub static VARS_UNHY_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("drolysed"),
        dictgen::InsensitiveStr::Ascii("drolyseds"),
        dictgen::InsensitiveStr::Ascii("drolyzed"),
        dictgen::InsensitiveStr::Ascii("drolyzeds"),
        dictgen::InsensitiveStr::Ascii("pnotisable"),
        dictgen::InsensitiveStr::Ascii("pnotisabler"),
        dictgen::InsensitiveStr::Ascii("pnotisables"),
        dictgen::InsensitiveStr::Ascii("pnotisablest"),
        dictgen::InsensitiveStr::Ascii("pnotise"),
        dictgen::InsensitiveStr::Ascii("pnotised"),
        dictgen::InsensitiveStr::Ascii("pnotises"),
        dictgen::InsensitiveStr::Ascii("pnotising"),
        dictgen::InsensitiveStr::Ascii("pnotizable"),
        dictgen::InsensitiveStr::Ascii("pnotizabler"),
        dictgen::InsensitiveStr::Ascii("pnotizables"),
        dictgen::InsensitiveStr::Ascii("pnotizablest"),
        dictgen::InsensitiveStr::Ascii("pnotize"),
        dictgen::InsensitiveStr::Ascii("pnotized"),
        dictgen::InsensitiveStr::Ascii("pnotizes"),
        dictgen::InsensitiveStr::Ascii("pnotizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_UNHYDROLYZED_1605839220238398471)],
        &[(0b11010, &ENTRY_UNHYDROLYZEDS_13681238840583454957)],
        &[(0b00001, &ENTRY_UNHYDROLYZED_1605839220238398471)],
        &[(0b00001, &ENTRY_UNHYDROLYZEDS_13681238840583454957)],
        &[(0b10010, &ENTRY_UNHYPNOTIZABLE_12677113158391463458)],
        &[(0b10010, &ENTRY_UNHYPNOTIZABLER_8308231553591337285)],
        &[(0b10010, &ENTRY_UNHYPNOTIZABLES_2781823676708254865)],
        &[(0b10010, &ENTRY_UNHYPNOTIZABLEST_18105363756532886213)],
        &[(0b10010, &ENTRY_UNHYPNOTIZE_3076842320349928553)],
        &[(0b10010, &ENTRY_UNHYPNOTIZED_6987621846242827839)],
        &[(0b10010, &ENTRY_UNHYPNOTIZES_11386726980321406907)],
        &[(0b10010, &ENTRY_UNHYPNOTIZING_14708134202663666466)],
        &[(0b01001, &ENTRY_UNHYPNOTIZABLE_12677113158391463458)],
        &[(0b01001, &ENTRY_UNHYPNOTIZABLER_8308231553591337285)],
        &[(0b01001, &ENTRY_UNHYPNOTIZABLES_2781823676708254865)],
        &[(0b01001, &ENTRY_UNHYPNOTIZABLEST_18105363756532886213)],
        &[(0b01001, &ENTRY_UNHYPNOTIZE_3076842320349928553)],
        &[(0b01001, &ENTRY_UNHYPNOTIZED_6987621846242827839)],
        &[(0b01001, &ENTRY_UNHYPNOTIZES_11386726980321406907)],
        &[(0b01001, &ENTRY_UNHYPNOTIZING_14708134202663666466)],
    ],
    range: 7..=12,
};

static VARS_UNHU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNHU_CHILDREN),
    value: None,
};

pub static VARS_UNHU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("manise"),
        dictgen::InsensitiveStr::Ascii("manised"),
        dictgen::InsensitiveStr::Ascii("manises"),
        dictgen::InsensitiveStr::Ascii("manising"),
        dictgen::InsensitiveStr::Ascii("manize"),
        dictgen::InsensitiveStr::Ascii("manized"),
        dictgen::InsensitiveStr::Ascii("manizes"),
        dictgen::InsensitiveStr::Ascii("manizing"),
        dictgen::InsensitiveStr::Ascii("mored"),
        dictgen::InsensitiveStr::Ascii("moredder"),
        dictgen::InsensitiveStr::Ascii("moreddest"),
        dictgen::InsensitiveStr::Ascii("morous"),
        dictgen::InsensitiveStr::Ascii("morously"),
        dictgen::InsensitiveStr::Ascii("moured"),
        dictgen::InsensitiveStr::Ascii("mouredder"),
        dictgen::InsensitiveStr::Ascii("moureddest"),
        dictgen::InsensitiveStr::Ascii("mourous"),
        dictgen::InsensitiveStr::Ascii("mourously"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNHUMANIZE_12854121833055078969)],
        &[(0b10010, &ENTRY_UNHUMANIZED_17662506078275203924)],
        &[(0b10010, &ENTRY_UNHUMANIZES_17954053753304169532)],
        &[(0b10010, &ENTRY_UNHUMANIZING_9429149451831438072)],
        &[(0b01001, &ENTRY_UNHUMANIZE_12854121833055078969)],
        &[(0b01001, &ENTRY_UNHUMANIZED_17662506078275203924)],
        &[(0b01001, &ENTRY_UNHUMANIZES_17954053753304169532)],
        &[(0b01001, &ENTRY_UNHUMANIZING_9429149451831438072)],
        &[(0b00001, &ENTRY_UNHUMORED_18084787621051692653)],
        &[(0b00001, &ENTRY_UNHUMOREDDER_18307311026638177281)],
        &[(0b00001, &ENTRY_UNHUMOREDDEST_7064789414378776056)],
        &[(0b00001, &ENTRY_UNHUMOROUS_2057333796189652890)],
        &[(0b00001, &ENTRY_UNHUMOROUSLY_16491216367858199459)],
        &[(0b11010, &ENTRY_UNHUMORED_18084787621051692653)],
        &[(0b11010, &ENTRY_UNHUMOREDDER_18307311026638177281)],
        &[(0b11010, &ENTRY_UNHUMOREDDEST_7064789414378776056)],
        &[(0b11010, &ENTRY_UNHUMOROUS_2057333796189652890)],
        &[(0b11010, &ENTRY_UNHUMOROUSLY_16491216367858199459)],
    ],
    range: 5..=10,
};

static VARS_UNHO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNHO_CHILDREN),
    value: None,
};

pub static VARS_UNHO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("norable"),
        dictgen::InsensitiveStr::Ascii("norables"),
        dictgen::InsensitiveStr::Ascii("norablies"),
        dictgen::InsensitiveStr::Ascii("norably"),
        dictgen::InsensitiveStr::Ascii("nored"),
        dictgen::InsensitiveStr::Ascii("noredder"),
        dictgen::InsensitiveStr::Ascii("noreddest"),
        dictgen::InsensitiveStr::Ascii("nourable"),
        dictgen::InsensitiveStr::Ascii("nourables"),
        dictgen::InsensitiveStr::Ascii("nourablies"),
        dictgen::InsensitiveStr::Ascii("nourably"),
        dictgen::InsensitiveStr::Ascii("noured"),
        dictgen::InsensitiveStr::Ascii("nouredder"),
        dictgen::InsensitiveStr::Ascii("noureddest"),
        dictgen::InsensitiveStr::Ascii("useled"),
        dictgen::InsensitiveStr::Ascii("uselled"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNHONORABLE_1330850809715602086)],
        &[(0b00001, &ENTRY_UNHONORABLES_5002839830632485659)],
        &[(0b00001, &ENTRY_UNHONORABLIES_7582286055767508232)],
        &[(0b00001, &ENTRY_UNHONORABLY_18210830341929676608)],
        &[(0b00001, &ENTRY_UNHONORED_5460665573065748506)],
        &[(0b00001, &ENTRY_UNHONOREDDER_1452869734187004448)],
        &[(0b00001, &ENTRY_UNHONOREDDEST_6950228220672261606)],
        &[(0b11010, &ENTRY_UNHONORABLE_1330850809715602086)],
        &[(0b11010, &ENTRY_UNHONORABLES_5002839830632485659)],
        &[(0b11010, &ENTRY_UNHONORABLIES_7582286055767508232)],
        &[(0b11010, &ENTRY_UNHONORABLY_18210830341929676608)],
        &[(0b11010, &ENTRY_UNHONORED_5460665573065748506)],
        &[(0b11010, &ENTRY_UNHONOREDDER_1452869734187004448)],
        &[(0b11010, &ENTRY_UNHONOREDDEST_6950228220672261606)],
        &[(0b00001, &ENTRY_UNHOUSELED_8799017796220250092)],
        &[(0b11010, &ENTRY_UNHOUSELED_8799017796220250092)],
    ],
    range: 5..=10,
};

static VARS_UNHE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNHE_CHILDREN),
    value: None,
};

pub static VARS_UNHE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("roise"),
        dictgen::InsensitiveStr::Ascii("roises"),
        dictgen::InsensitiveStr::Ascii("roize"),
        dictgen::InsensitiveStr::Ascii("roizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNHEROIZE_16852054084869741483)],
        &[(0b10010, &ENTRY_UNHEROIZES_18067699959238416206)],
        &[(0b01001, &ENTRY_UNHEROIZE_16852054084869741483)],
        &[(0b01001, &ENTRY_UNHEROIZES_18067699959238416206)],
    ],
    range: 5..=6,
};

static VARS_UNHA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNHA_CHILDREN),
    value: None,
};

pub static VARS_UNHA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rbor"),
        dictgen::InsensitiveStr::Ascii("rbored"),
        dictgen::InsensitiveStr::Ascii("rbour"),
        dictgen::InsensitiveStr::Ascii("rboured"),
        dictgen::InsensitiveStr::Ascii("rmonise"),
        dictgen::InsensitiveStr::Ascii("rmonised"),
        dictgen::InsensitiveStr::Ascii("rmonises"),
        dictgen::InsensitiveStr::Ascii("rmonising"),
        dictgen::InsensitiveStr::Ascii("rmonize"),
        dictgen::InsensitiveStr::Ascii("rmonized"),
        dictgen::InsensitiveStr::Ascii("rmonizes"),
        dictgen::InsensitiveStr::Ascii("rmonizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNHARBOR_1889127797014206122)],
        &[(0b00001, &ENTRY_UNHARBORED_15652861429904710912)],
        &[(0b11010, &ENTRY_UNHARBOR_1889127797014206122)],
        &[(0b11010, &ENTRY_UNHARBORED_15652861429904710912)],
        &[(0b10010, &ENTRY_UNHARMONIZE_14159372496346198461)],
        &[(0b10010, &ENTRY_UNHARMONIZED_3681921261857978250)],
        &[(0b10010, &ENTRY_UNHARMONIZES_13473655128913265796)],
        &[(0b10010, &ENTRY_UNHARMONIZING_3698746930961588812)],
        &[(0b01001, &ENTRY_UNHARMONIZE_14159372496346198461)],
        &[(0b01001, &ENTRY_UNHARMONIZED_3681921261857978250)],
        &[(0b01001, &ENTRY_UNHARMONIZES_13473655128913265796)],
        &[(0b01001, &ENTRY_UNHARMONIZING_3698746930961588812)],
    ],
    range: 4..=9,
};

static VARS_UNG_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNG_CHILDREN),
    value: None,
};

pub static VARS_UNG_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alvanised"),
        dictgen::InsensitiveStr::Ascii("alvaniseds"),
        dictgen::InsensitiveStr::Ascii("alvanized"),
        dictgen::InsensitiveStr::Ascii("alvanizeds"),
        dictgen::InsensitiveStr::Ascii("elatinisable"),
        dictgen::InsensitiveStr::Ascii("elatinisables"),
        dictgen::InsensitiveStr::Ascii("elatinised"),
        dictgen::InsensitiveStr::Ascii("elatiniseds"),
        dictgen::InsensitiveStr::Ascii("elatinizable"),
        dictgen::InsensitiveStr::Ascii("elatinizables"),
        dictgen::InsensitiveStr::Ascii("elatinized"),
        dictgen::InsensitiveStr::Ascii("elatinizeds"),
        dictgen::InsensitiveStr::Ascii("eneralised"),
        dictgen::InsensitiveStr::Ascii("eneralisedder"),
        dictgen::InsensitiveStr::Ascii("eneraliseddest"),
        dictgen::InsensitiveStr::Ascii("eneralising"),
        dictgen::InsensitiveStr::Ascii("eneralized"),
        dictgen::InsensitiveStr::Ascii("eneralizedder"),
        dictgen::InsensitiveStr::Ascii("eneralizeddest"),
        dictgen::InsensitiveStr::Ascii("eneralizing"),
        dictgen::InsensitiveStr::Ascii("entilise"),
        dictgen::InsensitiveStr::Ascii("entilises"),
        dictgen::InsensitiveStr::Ascii("entilize"),
        dictgen::InsensitiveStr::Ascii("entilizes"),
        dictgen::InsensitiveStr::Ascii("entlemanise"),
        dictgen::InsensitiveStr::Ascii("entlemanises"),
        dictgen::InsensitiveStr::Ascii("entlemanize"),
        dictgen::InsensitiveStr::Ascii("entlemanizes"),
        dictgen::InsensitiveStr::Ascii("lamourous"),
        dictgen::InsensitiveStr::Ascii("lamourously"),
        dictgen::InsensitiveStr::Ascii("ospelised"),
        dictgen::InsensitiveStr::Ascii("ospeliseds"),
        dictgen::InsensitiveStr::Ascii("ospelized"),
        dictgen::InsensitiveStr::Ascii("ospelizeds"),
        dictgen::InsensitiveStr::Ascii("raphitised"),
        dictgen::InsensitiveStr::Ascii("raphitiseds"),
        dictgen::InsensitiveStr::Ascii("raphitized"),
        dictgen::InsensitiveStr::Ascii("raphitizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNGALVANIZED_3840316573651324942)],
        &[(0b10010, &ENTRY_UNGALVANIZEDS_4906872843938668122)],
        &[(0b01001, &ENTRY_UNGALVANIZED_3840316573651324942)],
        &[(0b01001, &ENTRY_UNGALVANIZEDS_4906872843938668122)],
        &[(0b10010, &ENTRY_UNGELATINIZABLE_429611291989316452)],
        &[(0b10010, &ENTRY_UNGELATINIZABLES_4045588807998071406)],
        &[(0b10010, &ENTRY_UNGELATINIZED_9064237700681920871)],
        &[(0b10010, &ENTRY_UNGELATINIZEDS_16589417897484720231)],
        &[(0b01001, &ENTRY_UNGELATINIZABLE_429611291989316452)],
        &[(0b01001, &ENTRY_UNGELATINIZABLES_4045588807998071406)],
        &[(0b01001, &ENTRY_UNGELATINIZED_9064237700681920871)],
        &[(0b01001, &ENTRY_UNGELATINIZEDS_16589417897484720231)],
        &[(0b10010, &ENTRY_UNGENERALIZED_304645846605712294)],
        &[(0b10010, &ENTRY_UNGENERALIZEDDER_9404932562611412518)],
        &[(0b10010, &ENTRY_UNGENERALIZEDDEST_10234603051627457134)],
        &[(0b10010, &ENTRY_UNGENERALIZING_3627958036075317148)],
        &[(0b01001, &ENTRY_UNGENERALIZED_304645846605712294)],
        &[(0b01001, &ENTRY_UNGENERALIZEDDER_9404932562611412518)],
        &[(0b01001, &ENTRY_UNGENERALIZEDDEST_10234603051627457134)],
        &[(0b01001, &ENTRY_UNGENERALIZING_3627958036075317148)],
        &[(0b10010, &ENTRY_UNGENTILIZE_1682666321562915658)],
        &[(0b10010, &ENTRY_UNGENTILIZES_1989929300659612547)],
        &[(0b01001, &ENTRY_UNGENTILIZE_1682666321562915658)],
        &[(0b01001, &ENTRY_UNGENTILIZES_1989929300659612547)],
        &[(0b10010, &ENTRY_UNGENTLEMANIZE_6616841421363856905)],
        &[(0b10010, &ENTRY_UNGENTLEMANIZES_5000225273049339991)],
        &[(0b01001, &ENTRY_UNGENTLEMANIZE_6616841421363856905)],
        &[(0b01001, &ENTRY_UNGENTLEMANIZES_5000225273049339991)],
        &[(0b11010, &ENTRY_UNGLAMOROUS_11551883381104018739)],
        &[(0b11010, &ENTRY_UNGLAMOROUSLY_12722711669948552620)],
        &[(0b10010, &ENTRY_UNGOSPELIZED_7916023896723661075)],
        &[(0b10010, &ENTRY_UNGOSPELIZEDS_12370376811231680007)],
        &[(0b01001, &ENTRY_UNGOSPELIZED_7916023896723661075)],
        &[(0b01001, &ENTRY_UNGOSPELIZEDS_12370376811231680007)],
        &[(0b10010, &ENTRY_UNGRAPHITIZED_9140840362551120713)],
        &[(0b10010, &ENTRY_UNGRAPHITIZEDS_17567383968087162591)],
        &[(0b01001, &ENTRY_UNGRAPHITIZED_9140840362551120713)],
        &[(0b01001, &ENTRY_UNGRAPHITIZEDS_17567383968087162591)],
    ],
    range: 8..=14,
};

static VARS_UNF_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UNF_CHILDREN),
    value: None,
};

static VARS_UNF_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_UNFA_NODE),
    None,
    None,
    None,
    Some(&VARS_UNFE_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UNFL_NODE),
    None,
    None,
    Some(&VARS_UNFO_NODE),
    None,
    None,
    Some(&VARS_UNFR_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_UNFR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNFR_CHILDREN),
    value: None,
};

pub static VARS_UNFR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aternised"),
        dictgen::InsensitiveStr::Ascii("aternising"),
        dictgen::InsensitiveStr::Ascii("aternisings"),
        dictgen::InsensitiveStr::Ascii("aternized"),
        dictgen::InsensitiveStr::Ascii("aternizing"),
        dictgen::InsensitiveStr::Ascii("aternizings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNFRATERNIZED_15391653689494557711)],
        &[(0b10010, &ENTRY_UNFRATERNIZING_11945792457598246703)],
        &[(0b10010, &ENTRY_UNFRATERNIZINGS_443815508621461535)],
        &[(0b01001, &ENTRY_UNFRATERNIZED_15391653689494557711)],
        &[(0b01001, &ENTRY_UNFRATERNIZING_11945792457598246703)],
        &[(0b01001, &ENTRY_UNFRATERNIZINGS_443815508621461535)],
    ],
    range: 9..=11,
};

static VARS_UNFO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNFO_CHILDREN),
    value: None,
};

pub static VARS_UNFO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rmalised"),
        dictgen::InsensitiveStr::Ascii("rmalisedder"),
        dictgen::InsensitiveStr::Ascii("rmaliseddest"),
        dictgen::InsensitiveStr::Ascii("rmalized"),
        dictgen::InsensitiveStr::Ascii("rmalizedder"),
        dictgen::InsensitiveStr::Ascii("rmalizeddest"),
        dictgen::InsensitiveStr::Ascii("ssilised"),
        dictgen::InsensitiveStr::Ascii("ssilisedder"),
        dictgen::InsensitiveStr::Ascii("ssiliseddest"),
        dictgen::InsensitiveStr::Ascii("ssiliseds"),
        dictgen::InsensitiveStr::Ascii("ssilized"),
        dictgen::InsensitiveStr::Ascii("ssilizedder"),
        dictgen::InsensitiveStr::Ascii("ssilizeddest"),
        dictgen::InsensitiveStr::Ascii("ssilizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNFORMALIZED_10947362983293799260)],
        &[(0b10010, &ENTRY_UNFORMALIZEDDER_16826016574168323811)],
        &[(0b10010, &ENTRY_UNFORMALIZEDDEST_14745966789505381148)],
        &[(0b01001, &ENTRY_UNFORMALIZED_10947362983293799260)],
        &[(0b01001, &ENTRY_UNFORMALIZEDDER_16826016574168323811)],
        &[(0b01001, &ENTRY_UNFORMALIZEDDEST_14745966789505381148)],
        &[(0b10010, &ENTRY_UNFOSSILIZED_1644345316811460331)],
        &[(0b10010, &ENTRY_UNFOSSILIZEDDER_9873397475242687877)],
        &[(0b10010, &ENTRY_UNFOSSILIZEDDEST_11985032009736222005)],
        &[(0b10010, &ENTRY_UNFOSSILIZEDS_11821803111813998857)],
        &[(0b01001, &ENTRY_UNFOSSILIZED_1644345316811460331)],
        &[(0b01001, &ENTRY_UNFOSSILIZEDDER_9873397475242687877)],
        &[(0b01001, &ENTRY_UNFOSSILIZEDDEST_11985032009736222005)],
        &[(0b01001, &ENTRY_UNFOSSILIZEDS_11821803111813998857)],
    ],
    range: 8..=12,
};

static VARS_UNFL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNFL_CHILDREN),
    value: None,
};

pub static VARS_UNFL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("avored"),
        dictgen::InsensitiveStr::Ascii("avoredder"),
        dictgen::InsensitiveStr::Ascii("avoreddest"),
        dictgen::InsensitiveStr::Ascii("avorous"),
        dictgen::InsensitiveStr::Ascii("avoured"),
        dictgen::InsensitiveStr::Ascii("avouredder"),
        dictgen::InsensitiveStr::Ascii("avoureddest"),
        dictgen::InsensitiveStr::Ascii("avourous"),
    ],
    values: &[
        &[(0b11001, &ENTRY_UNFLAVORED_7704639512615468125)],
        &[(0b11001, &ENTRY_UNFLAVOREDDER_10493652523700310738)],
        &[(0b11001, &ENTRY_UNFLAVOREDDEST_1414059801540499482)],
        &[(0b00001, &ENTRY_UNFLAVOROUS_16935211748591593605)],
        &[(0b11010, &ENTRY_UNFLAVORED_7704639512615468125)],
        &[(0b11010, &ENTRY_UNFLAVOREDDER_10493652523700310738)],
        &[(0b11010, &ENTRY_UNFLAVOREDDEST_1414059801540499482)],
        &[(0b11010, &ENTRY_UNFLAVOROUS_16935211748591593605)],
    ],
    range: 6..=11,
};

static VARS_UNFE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNFE_CHILDREN),
    value: None,
};

pub static VARS_UNFE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("minise"),
        dictgen::InsensitiveStr::Ascii("minised"),
        dictgen::InsensitiveStr::Ascii("minising"),
        dictgen::InsensitiveStr::Ascii("minize"),
        dictgen::InsensitiveStr::Ascii("minized"),
        dictgen::InsensitiveStr::Ascii("minizing"),
        dictgen::InsensitiveStr::Ascii("rtilisable"),
        dictgen::InsensitiveStr::Ascii("rtilisabler"),
        dictgen::InsensitiveStr::Ascii("rtilisables"),
        dictgen::InsensitiveStr::Ascii("rtilisablest"),
        dictgen::InsensitiveStr::Ascii("rtilised"),
        dictgen::InsensitiveStr::Ascii("rtilisedder"),
        dictgen::InsensitiveStr::Ascii("rtiliseddest"),
        dictgen::InsensitiveStr::Ascii("rtilising"),
        dictgen::InsensitiveStr::Ascii("rtilizable"),
        dictgen::InsensitiveStr::Ascii("rtilizabler"),
        dictgen::InsensitiveStr::Ascii("rtilizables"),
        dictgen::InsensitiveStr::Ascii("rtilizablest"),
        dictgen::InsensitiveStr::Ascii("rtilized"),
        dictgen::InsensitiveStr::Ascii("rtilizedder"),
        dictgen::InsensitiveStr::Ascii("rtilizeddest"),
        dictgen::InsensitiveStr::Ascii("rtilizing"),
        dictgen::InsensitiveStr::Ascii("udalise"),
        dictgen::InsensitiveStr::Ascii("udalised"),
        dictgen::InsensitiveStr::Ascii("udalises"),
        dictgen::InsensitiveStr::Ascii("udalising"),
        dictgen::InsensitiveStr::Ascii("udalize"),
        dictgen::InsensitiveStr::Ascii("udalized"),
        dictgen::InsensitiveStr::Ascii("udalizes"),
        dictgen::InsensitiveStr::Ascii("udalizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNFEMINIZE_17213280328995954348)],
        &[(0b10010, &ENTRY_UNFEMINIZED_3027631822761516755)],
        &[(0b10010, &ENTRY_UNFEMINIZING_16839714662136031968)],
        &[(0b01001, &ENTRY_UNFEMINIZE_17213280328995954348)],
        &[(0b01001, &ENTRY_UNFEMINIZED_3027631822761516755)],
        &[(0b01001, &ENTRY_UNFEMINIZING_16839714662136031968)],
        &[(0b10010, &ENTRY_UNFERTILIZABLE_17486342932318545605)],
        &[(0b10010, &ENTRY_UNFERTILIZABLER_7824528564028868183)],
        &[(0b10010, &ENTRY_UNFERTILIZABLES_2276591821562054261)],
        &[(0b10010, &ENTRY_UNFERTILIZABLEST_13686866561865228741)],
        &[(0b10010, &ENTRY_UNFERTILIZED_8536659073895846486)],
        &[(0b10010, &ENTRY_UNFERTILIZEDDER_8970939762495254103)],
        &[(0b10010, &ENTRY_UNFERTILIZEDDEST_3987712837886027136)],
        &[(0b10010, &ENTRY_UNFERTILIZING_18219334417771825481)],
        &[(0b01001, &ENTRY_UNFERTILIZABLE_17486342932318545605)],
        &[(0b01001, &ENTRY_UNFERTILIZABLER_7824528564028868183)],
        &[(0b01001, &ENTRY_UNFERTILIZABLES_2276591821562054261)],
        &[(0b01001, &ENTRY_UNFERTILIZABLEST_13686866561865228741)],
        &[(0b01001, &ENTRY_UNFERTILIZED_8536659073895846486)],
        &[(0b01001, &ENTRY_UNFERTILIZEDDER_8970939762495254103)],
        &[(0b01001, &ENTRY_UNFERTILIZEDDEST_3987712837886027136)],
        &[(0b01001, &ENTRY_UNFERTILIZING_18219334417771825481)],
        &[(0b10010, &ENTRY_UNFEUDALIZE_14691232336692814883)],
        &[(0b10010, &ENTRY_UNFEUDALIZED_11117493394291645590)],
        &[(0b10010, &ENTRY_UNFEUDALIZES_5103523048575728973)],
        &[(0b10010, &ENTRY_UNFEUDALIZING_3182932192190349634)],
        &[(0b01001, &ENTRY_UNFEUDALIZE_14691232336692814883)],
        &[(0b01001, &ENTRY_UNFEUDALIZED_11117493394291645590)],
        &[(0b01001, &ENTRY_UNFEUDALIZES_5103523048575728973)],
        &[(0b01001, &ENTRY_UNFEUDALIZING_3182932192190349634)],
    ],
    range: 6..=12,
};

static VARS_UNFA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNFA_CHILDREN),
    value: None,
};

pub static VARS_UNFA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("miliarised"),
        dictgen::InsensitiveStr::Ascii("miliarisedder"),
        dictgen::InsensitiveStr::Ascii("miliariseddest"),
        dictgen::InsensitiveStr::Ascii("miliarized"),
        dictgen::InsensitiveStr::Ascii("miliarizedder"),
        dictgen::InsensitiveStr::Ascii("miliarizeddest"),
        dictgen::InsensitiveStr::Ascii("vorable"),
        dictgen::InsensitiveStr::Ascii("vorableness"),
        dictgen::InsensitiveStr::Ascii("vorablenesses"),
        dictgen::InsensitiveStr::Ascii("vorabler"),
        dictgen::InsensitiveStr::Ascii("vorables"),
        dictgen::InsensitiveStr::Ascii("vorablest"),
        dictgen::InsensitiveStr::Ascii("vorablier"),
        dictgen::InsensitiveStr::Ascii("vorabliest"),
        dictgen::InsensitiveStr::Ascii("vorably"),
        dictgen::InsensitiveStr::Ascii("vored"),
        dictgen::InsensitiveStr::Ascii("voredder"),
        dictgen::InsensitiveStr::Ascii("voreddest"),
        dictgen::InsensitiveStr::Ascii("voring"),
        dictgen::InsensitiveStr::Ascii("voringer"),
        dictgen::InsensitiveStr::Ascii("voringest"),
        dictgen::InsensitiveStr::Ascii("vorings"),
        dictgen::InsensitiveStr::Ascii("vorite"),
        dictgen::InsensitiveStr::Ascii("voriter"),
        dictgen::InsensitiveStr::Ascii("vorites"),
        dictgen::InsensitiveStr::Ascii("voritest"),
        dictgen::InsensitiveStr::Ascii("vourable"),
        dictgen::InsensitiveStr::Ascii("vourableness"),
        dictgen::InsensitiveStr::Ascii("vourablenesses"),
        dictgen::InsensitiveStr::Ascii("vourabler"),
        dictgen::InsensitiveStr::Ascii("vourables"),
        dictgen::InsensitiveStr::Ascii("vourablest"),
        dictgen::InsensitiveStr::Ascii("vourablier"),
        dictgen::InsensitiveStr::Ascii("vourabliest"),
        dictgen::InsensitiveStr::Ascii("vourably"),
        dictgen::InsensitiveStr::Ascii("voured"),
        dictgen::InsensitiveStr::Ascii("vouredder"),
        dictgen::InsensitiveStr::Ascii("voureddest"),
        dictgen::InsensitiveStr::Ascii("vouring"),
        dictgen::InsensitiveStr::Ascii("vouringer"),
        dictgen::InsensitiveStr::Ascii("vouringest"),
        dictgen::InsensitiveStr::Ascii("vourings"),
        dictgen::InsensitiveStr::Ascii("vourite"),
        dictgen::InsensitiveStr::Ascii("vouriter"),
        dictgen::InsensitiveStr::Ascii("vourites"),
        dictgen::InsensitiveStr::Ascii("vouritest"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNFAMILIARIZED_8539267182006341403)],
        &[(0b10010, &ENTRY_UNFAMILIARIZEDDER_13089042195024096822)],
        &[(0b10010, &ENTRY_UNFAMILIARIZEDDEST_4018673522303778898)],
        &[(0b01001, &ENTRY_UNFAMILIARIZED_8539267182006341403)],
        &[(0b01001, &ENTRY_UNFAMILIARIZEDDER_13089042195024096822)],
        &[(0b01001, &ENTRY_UNFAMILIARIZEDDEST_4018673522303778898)],
        &[(0b11001, &ENTRY_UNFAVORABLE_8233532032007631727)],
        &[(0b11001, &ENTRY_UNFAVORABLENESS_11828384935093784234)],
        &[(0b11001, &ENTRY_UNFAVORABLENESSES_6196655711715423789)],
        &[(0b11001, &ENTRY_UNFAVORABLER_7526512460280153322)],
        &[(0b11001, &ENTRY_UNFAVORABLES_6371240244863361092)],
        &[(0b11001, &ENTRY_UNFAVORABLEST_10537368209740978427)],
        &[(0b11001, &ENTRY_UNFAVORABLIER_9564967346867026046)],
        &[(0b11001, &ENTRY_UNFAVORABLIEST_17311907542528170719)],
        &[(0b11001, &ENTRY_UNFAVORABLY_13214726587411166355)],
        &[(0b11001, &ENTRY_UNFAVORED_8089880807159401110)],
        &[(0b11001, &ENTRY_UNFAVOREDDER_6939782924396346672)],
        &[(0b11001, &ENTRY_UNFAVOREDDEST_9219340201172922449)],
        &[(0b11001, &ENTRY_UNFAVORING_14241568587543696910)],
        &[(0b11001, &ENTRY_UNFAVORINGER_3557197515106588733)],
        &[(0b11001, &ENTRY_UNFAVORINGEST_12052226034286952177)],
        &[(0b11001, &ENTRY_UNFAVORINGS_16058515457408679487)],
        &[(0b11001, &ENTRY_UNFAVORITE_9275402982305749708)],
        &[(0b11001, &ENTRY_UNFAVORITER_3433053368739550354)],
        &[(0b11001, &ENTRY_UNFAVORITES_8192113054989661952)],
        &[(0b11001, &ENTRY_UNFAVORITEST_5653472480878764002)],
        &[(0b11010, &ENTRY_UNFAVORABLE_8233532032007631727)],
        &[(0b11010, &ENTRY_UNFAVORABLENESS_11828384935093784234)],
        &[(0b11010, &ENTRY_UNFAVORABLENESSES_6196655711715423789)],
        &[(0b11010, &ENTRY_UNFAVORABLER_7526512460280153322)],
        &[(0b11010, &ENTRY_UNFAVORABLES_6371240244863361092)],
        &[(0b11010, &ENTRY_UNFAVORABLEST_10537368209740978427)],
        &[(0b11010, &ENTRY_UNFAVORABLIER_9564967346867026046)],
        &[(0b11010, &ENTRY_UNFAVORABLIEST_17311907542528170719)],
        &[(0b11010, &ENTRY_UNFAVORABLY_13214726587411166355)],
        &[(0b11010, &ENTRY_UNFAVORED_8089880807159401110)],
        &[(0b11010, &ENTRY_UNFAVOREDDER_6939782924396346672)],
        &[(0b11010, &ENTRY_UNFAVOREDDEST_9219340201172922449)],
        &[(0b11010, &ENTRY_UNFAVORING_14241568587543696910)],
        &[(0b11010, &ENTRY_UNFAVORINGER_3557197515106588733)],
        &[(0b11010, &ENTRY_UNFAVORINGEST_12052226034286952177)],
        &[(0b11010, &ENTRY_UNFAVORINGS_16058515457408679487)],
        &[(0b11010, &ENTRY_UNFAVORITE_9275402982305749708)],
        &[(0b11010, &ENTRY_UNFAVORITER_3433053368739550354)],
        &[(0b11010, &ENTRY_UNFAVORITES_8192113054989661952)],
        &[(0b11010, &ENTRY_UNFAVORITEST_5653472480878764002)],
    ],
    range: 5..=14,
};

static VARS_UNE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNE_CHILDREN),
    value: None,
};

pub static VARS_UNE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("conomising"),
        dictgen::InsensitiveStr::Ascii("conomizing"),
        dictgen::InsensitiveStr::Ascii("namored"),
        dictgen::InsensitiveStr::Ascii("namoredder"),
        dictgen::InsensitiveStr::Ascii("namoreddest"),
        dictgen::InsensitiveStr::Ascii("namoreds"),
        dictgen::InsensitiveStr::Ascii("namoured"),
        dictgen::InsensitiveStr::Ascii("namouredder"),
        dictgen::InsensitiveStr::Ascii("namoureddest"),
        dictgen::InsensitiveStr::Ascii("namoureds"),
        dictgen::InsensitiveStr::Ascii("ndeavored"),
        dictgen::InsensitiveStr::Ascii("ndeavoured"),
        dictgen::InsensitiveStr::Ascii("nergised"),
        dictgen::InsensitiveStr::Ascii("nergiseds"),
        dictgen::InsensitiveStr::Ascii("nergized"),
        dictgen::InsensitiveStr::Ascii("nergizeds"),
        dictgen::InsensitiveStr::Ascii("pitomised"),
        dictgen::InsensitiveStr::Ascii("pitomisedder"),
        dictgen::InsensitiveStr::Ascii("pitomiseddest"),
        dictgen::InsensitiveStr::Ascii("pitomized"),
        dictgen::InsensitiveStr::Ascii("pitomizedder"),
        dictgen::InsensitiveStr::Ascii("pitomizeddest"),
        dictgen::InsensitiveStr::Ascii("qualed"),
        dictgen::InsensitiveStr::Ascii("qualedder"),
        dictgen::InsensitiveStr::Ascii("qualeddest"),
        dictgen::InsensitiveStr::Ascii("qualise"),
        dictgen::InsensitiveStr::Ascii("qualised"),
        dictgen::InsensitiveStr::Ascii("qualises"),
        dictgen::InsensitiveStr::Ascii("qualising"),
        dictgen::InsensitiveStr::Ascii("qualize"),
        dictgen::InsensitiveStr::Ascii("qualized"),
        dictgen::InsensitiveStr::Ascii("qualizes"),
        dictgen::InsensitiveStr::Ascii("qualizing"),
        dictgen::InsensitiveStr::Ascii("qualled"),
        dictgen::InsensitiveStr::Ascii("qualledder"),
        dictgen::InsensitiveStr::Ascii("qualleddest"),
        dictgen::InsensitiveStr::Ascii("ulogised"),
        dictgen::InsensitiveStr::Ascii("ulogisedder"),
        dictgen::InsensitiveStr::Ascii("ulogiseddest"),
        dictgen::InsensitiveStr::Ascii("ulogiseds"),
        dictgen::InsensitiveStr::Ascii("ulogized"),
        dictgen::InsensitiveStr::Ascii("ulogizedder"),
        dictgen::InsensitiveStr::Ascii("ulogizeddest"),
        dictgen::InsensitiveStr::Ascii("ulogizeds"),
        dictgen::InsensitiveStr::Ascii("vangelised"),
        dictgen::InsensitiveStr::Ascii("vangelisedder"),
        dictgen::InsensitiveStr::Ascii("vangeliseddest"),
        dictgen::InsensitiveStr::Ascii("vangeliseds"),
        dictgen::InsensitiveStr::Ascii("vangelized"),
        dictgen::InsensitiveStr::Ascii("vangelizedder"),
        dictgen::InsensitiveStr::Ascii("vangelizeddest"),
        dictgen::InsensitiveStr::Ascii("vangelizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNECONOMIZING_15613959143050410767)],
        &[(0b01001, &ENTRY_UNECONOMIZING_15613959143050410767)],
        &[(0b00001, &ENTRY_UNENAMORED_8361050364159923006)],
        &[(0b00001, &ENTRY_UNENAMOREDDER_5033547920430041938)],
        &[(0b00001, &ENTRY_UNENAMOREDDEST_5114505485270249696)],
        &[(0b00001, &ENTRY_UNENAMOREDS_16806991213706982613)],
        &[(0b11010, &ENTRY_UNENAMORED_8361050364159923006)],
        &[(0b11010, &ENTRY_UNENAMOREDDER_5033547920430041938)],
        &[(0b11010, &ENTRY_UNENAMOREDDEST_5114505485270249696)],
        &[(0b11010, &ENTRY_UNENAMOREDS_16806991213706982613)],
        &[(0b00001, &ENTRY_UNENDEAVORED_7066291353915558991)],
        &[(0b11010, &ENTRY_UNENDEAVORED_7066291353915558991)],
        &[(0b10010, &ENTRY_UNENERGIZED_1765957718558496954)],
        &[(0b10010, &ENTRY_UNENERGIZEDS_9257032612298922872)],
        &[(0b01001, &ENTRY_UNENERGIZED_1765957718558496954)],
        &[(0b01001, &ENTRY_UNENERGIZEDS_9257032612298922872)],
        &[(0b10010, &ENTRY_UNEPITOMIZED_14848321193589314772)],
        &[(0b10010, &ENTRY_UNEPITOMIZEDDER_14282657736379387619)],
        &[(0b10010, &ENTRY_UNEPITOMIZEDDEST_17830262776297478282)],
        &[(0b01001, &ENTRY_UNEPITOMIZED_14848321193589314772)],
        &[(0b01001, &ENTRY_UNEPITOMIZEDDER_14282657736379387619)],
        &[(0b01001, &ENTRY_UNEPITOMIZEDDEST_17830262776297478282)],
        &[(0b00001, &ENTRY_UNEQUALED_10272049179921241581)],
        &[(0b00001, &ENTRY_UNEQUALEDDER_8399677671352964156)],
        &[(0b00001, &ENTRY_UNEQUALEDDEST_12126395105891544493)],
        &[(0b10010, &ENTRY_UNEQUALIZE_12397832983269467070)],
        &[(0b10010, &ENTRY_UNEQUALIZED_11229527678135642111)],
        &[(0b10010, &ENTRY_UNEQUALIZES_11516811173212612864)],
        &[(0b10010, &ENTRY_UNEQUALIZING_7314201456915686327)],
        &[(0b01001, &ENTRY_UNEQUALIZE_12397832983269467070)],
        &[(0b01001, &ENTRY_UNEQUALIZED_11229527678135642111)],
        &[(0b01001, &ENTRY_UNEQUALIZES_11516811173212612864)],
        &[(0b01001, &ENTRY_UNEQUALIZING_7314201456915686327)],
        &[(0b11010, &ENTRY_UNEQUALED_10272049179921241581)],
        &[(0b11010, &ENTRY_UNEQUALEDDER_8399677671352964156)],
        &[(0b11010, &ENTRY_UNEQUALEDDEST_12126395105891544493)],
        &[(0b10010, &ENTRY_UNEULOGIZED_8625593682318183902)],
        &[(0b10010, &ENTRY_UNEULOGIZEDDER_500502998937424952)],
        &[(0b10010, &ENTRY_UNEULOGIZEDDEST_15902188274770789074)],
        &[(0b10010, &ENTRY_UNEULOGIZEDS_9618091862575439629)],
        &[(0b01001, &ENTRY_UNEULOGIZED_8625593682318183902)],
        &[(0b01001, &ENTRY_UNEULOGIZEDDER_500502998937424952)],
        &[(0b01001, &ENTRY_UNEULOGIZEDDEST_15902188274770789074)],
        &[(0b01001, &ENTRY_UNEULOGIZEDS_9618091862575439629)],
        &[(0b10010, &ENTRY_UNEVANGELIZED_17902646883952932702)],
        &[(0b10010, &ENTRY_UNEVANGELIZEDDER_14389146019253414049)],
        &[(0b10010, &ENTRY_UNEVANGELIZEDDEST_11919291498979551119)],
        &[(0b10010, &ENTRY_UNEVANGELIZEDS_4997587800538848322)],
        &[(0b01001, &ENTRY_UNEVANGELIZED_17902646883952932702)],
        &[(0b01001, &ENTRY_UNEVANGELIZEDDER_14389146019253414049)],
        &[(0b01001, &ENTRY_UNEVANGELIZEDDEST_11919291498979551119)],
        &[(0b01001, &ENTRY_UNEVANGELIZEDS_4997587800538848322)],
    ],
    range: 6..=14,
};

static VARS_UND_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UND_CHILDREN),
    value: None,
};

static VARS_UND_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    Some(&VARS_UNDE_NODE),
    None,
    None,
    None,
    Some(&VARS_UNDI_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UNDR_NODE),
    None,
    None,
    Some(&VARS_UNDU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_UNDU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNDU_CHILDREN),
    value: None,
};

pub static VARS_UNDU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alise"),
        dictgen::InsensitiveStr::Ascii("alises"),
        dictgen::InsensitiveStr::Ascii("alize"),
        dictgen::InsensitiveStr::Ascii("alizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNDUALIZE_12388450838585691212)],
        &[(0b10010, &ENTRY_UNDUALIZES_16398535363456366813)],
        &[(0b01001, &ENTRY_UNDUALIZE_12388450838585691212)],
        &[(0b01001, &ENTRY_UNDUALIZES_16398535363456366813)],
    ],
    range: 5..=6,
};

static VARS_UNDR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNDR_CHILDREN),
    value: None,
};

pub static VARS_UNDR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("amatisable"),
        dictgen::InsensitiveStr::Ascii("amatisabler"),
        dictgen::InsensitiveStr::Ascii("amatisables"),
        dictgen::InsensitiveStr::Ascii("amatisablest"),
        dictgen::InsensitiveStr::Ascii("amatised"),
        dictgen::InsensitiveStr::Ascii("amatiseds"),
        dictgen::InsensitiveStr::Ascii("amatizable"),
        dictgen::InsensitiveStr::Ascii("amatizabler"),
        dictgen::InsensitiveStr::Ascii("amatizables"),
        dictgen::InsensitiveStr::Ascii("amatizablest"),
        dictgen::InsensitiveStr::Ascii("amatized"),
        dictgen::InsensitiveStr::Ascii("amatizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNDRAMATIZABLE_16417239684975540746)],
        &[(0b10010, &ENTRY_UNDRAMATIZABLER_17183761443356610462)],
        &[(0b10010, &ENTRY_UNDRAMATIZABLES_1761059456444333869)],
        &[(0b10010, &ENTRY_UNDRAMATIZABLEST_10351333071010784123)],
        &[(0b10010, &ENTRY_UNDRAMATIZED_10630343306514025585)],
        &[(0b10010, &ENTRY_UNDRAMATIZEDS_12222872129614232202)],
        &[(0b01001, &ENTRY_UNDRAMATIZABLE_16417239684975540746)],
        &[(0b01001, &ENTRY_UNDRAMATIZABLER_17183761443356610462)],
        &[(0b01001, &ENTRY_UNDRAMATIZABLES_1761059456444333869)],
        &[(0b01001, &ENTRY_UNDRAMATIZABLEST_10351333071010784123)],
        &[(0b01001, &ENTRY_UNDRAMATIZED_10630343306514025585)],
        &[(0b01001, &ENTRY_UNDRAMATIZEDS_12222872129614232202)],
    ],
    range: 8..=12,
};

static VARS_UNDI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNDI_CHILDREN),
    value: None,
};

pub static VARS_UNDI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alysed"),
        dictgen::InsensitiveStr::Ascii("alyseds"),
        dictgen::InsensitiveStr::Ascii("alyzed"),
        dictgen::InsensitiveStr::Ascii("alyzeds"),
        dictgen::InsensitiveStr::Ascii("phthongise"),
        dictgen::InsensitiveStr::Ascii("phthongises"),
        dictgen::InsensitiveStr::Ascii("phthongize"),
        dictgen::InsensitiveStr::Ascii("phthongizes"),
        dictgen::InsensitiveStr::Ascii("scolored"),
        dictgen::InsensitiveStr::Ascii("scoloredder"),
        dictgen::InsensitiveStr::Ascii("scoloreddest"),
        dictgen::InsensitiveStr::Ascii("scoloreds"),
        dictgen::InsensitiveStr::Ascii("scoloured"),
        dictgen::InsensitiveStr::Ascii("scolouredder"),
        dictgen::InsensitiveStr::Ascii("scoloureddest"),
        dictgen::InsensitiveStr::Ascii("scoloureds"),
        dictgen::InsensitiveStr::Ascii("shonored"),
        dictgen::InsensitiveStr::Ascii("shonoured"),
        dictgen::InsensitiveStr::Ascii("sorganised"),
        dictgen::InsensitiveStr::Ascii("sorganized"),
    ],
    values: &[
        &[(0b11010, &ENTRY_UNDIALYZED_4239031886129441255)],
        &[(0b11010, &ENTRY_UNDIALYZEDS_15673303853485275568)],
        &[(0b00001, &ENTRY_UNDIALYZED_4239031886129441255)],
        &[(0b00001, &ENTRY_UNDIALYZEDS_15673303853485275568)],
        &[(0b10010, &ENTRY_UNDIPHTHONGIZE_2160275447408384699)],
        &[(0b10010, &ENTRY_UNDIPHTHONGIZES_919729037221686149)],
        &[(0b01001, &ENTRY_UNDIPHTHONGIZE_2160275447408384699)],
        &[(0b01001, &ENTRY_UNDIPHTHONGIZES_919729037221686149)],
        &[(0b00001, &ENTRY_UNDISCOLORED_16617222672466412819)],
        &[(0b00001, &ENTRY_UNDISCOLOREDDER_12948233388857516182)],
        &[(0b00001, &ENTRY_UNDISCOLOREDDEST_588122864294200189)],
        &[(0b00001, &ENTRY_UNDISCOLOREDS_10674456259381646580)],
        &[(0b11010, &ENTRY_UNDISCOLORED_16617222672466412819)],
        &[(0b11010, &ENTRY_UNDISCOLOREDDER_12948233388857516182)],
        &[(0b11010, &ENTRY_UNDISCOLOREDDEST_588122864294200189)],
        &[(0b11010, &ENTRY_UNDISCOLOREDS_10674456259381646580)],
        &[(0b00001, &ENTRY_UNDISHONORED_10570919707421545123)],
        &[(0b11010, &ENTRY_UNDISHONORED_10570919707421545123)],
        &[(0b10010, &ENTRY_UNDISORGANIZED_2987622726902566022)],
        &[(0b01001, &ENTRY_UNDISORGANIZED_2987622726902566022)],
    ],
    range: 6..=13,
};

static VARS_UNDE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UNDE_CHILDREN),
    value: None,
};

static VARS_UNDE_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UNDEF_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_UNDEM_NODE),
    Some(&VARS_UNDEN_NODE),
    None,
    None,
    None,
    Some(&VARS_UNDER_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_UNDER_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UNDER_CHILDREN),
    value: None,
};

static VARS_UNDER_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    Some(&VARS_UNDERC_NODE),
    None,
    Some(&VARS_UNDERE_NODE),
    None,
    Some(&VARS_UNDERG_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_UNDERL_NODE),
    None,
    None,
    Some(&VARS_UNDERO_NODE),
    Some(&VARS_UNDERP_NODE),
    None,
    Some(&VARS_UNDERR_NODE),
    Some(&VARS_UNDERS_NODE),
    None,
    Some(&VARS_UNDERU_NODE),
    Some(&VARS_UNDERV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_UNDERV_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNDERV_CHILDREN),
    value: None,
};

pub static VARS_UNDERV_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("italised"),
        dictgen::InsensitiveStr::Ascii("italiseds"),
        dictgen::InsensitiveStr::Ascii("italized"),
        dictgen::InsensitiveStr::Ascii("italizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNDERVITALIZED_15030486633106066661)],
        &[(0b10010, &ENTRY_UNDERVITALIZEDS_7837775855116374233)],
        &[(0b01001, &ENTRY_UNDERVITALIZED_15030486633106066661)],
        &[(0b01001, &ENTRY_UNDERVITALIZEDS_7837775855116374233)],
    ],
    range: 8..=9,
};

static VARS_UNDERU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNDERU_CHILDREN),
    value: None,
};

pub static VARS_UNDERU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("tilisation"),
        dictgen::InsensitiveStr::Ascii("tilisations"),
        dictgen::InsensitiveStr::Ascii("tilise"),
        dictgen::InsensitiveStr::Ascii("tilised"),
        dictgen::InsensitiveStr::Ascii("tilises"),
        dictgen::InsensitiveStr::Ascii("tilising"),
        dictgen::InsensitiveStr::Ascii("tilization"),
        dictgen::InsensitiveStr::Ascii("tilizations"),
        dictgen::InsensitiveStr::Ascii("tilize"),
        dictgen::InsensitiveStr::Ascii("tilized"),
        dictgen::InsensitiveStr::Ascii("tilizes"),
        dictgen::InsensitiveStr::Ascii("tilizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNDERUTILIZATION_5223118652036751167)],
        &[(0b10010, &ENTRY_UNDERUTILIZATIONS_2736156761561305874)],
        &[(0b10010, &ENTRY_UNDERUTILIZE_1115904263636509242)],
        &[(0b10010, &ENTRY_UNDERUTILIZED_6777172924330394476)],
        &[(0b10010, &ENTRY_UNDERUTILIZES_3826812380680667876)],
        &[(0b10010, &ENTRY_UNDERUTILIZING_13709312952006497089)],
        &[(0b01001, &ENTRY_UNDERUTILIZATION_5223118652036751167)],
        &[(0b01001, &ENTRY_UNDERUTILIZATIONS_2736156761561305874)],
        &[(0b01001, &ENTRY_UNDERUTILIZE_1115904263636509242)],
        &[(0b01001, &ENTRY_UNDERUTILIZED_6777172924330394476)],
        &[(0b01001, &ENTRY_UNDERUTILIZES_3826812380680667876)],
        &[(0b01001, &ENTRY_UNDERUTILIZING_13709312952006497089)],
    ],
    range: 6..=11,
};

static VARS_UNDERS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNDERS_CHILDREN),
    value: None,
};

pub static VARS_UNDERS_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("avior"),
        dictgen::InsensitiveStr::Ascii("aviors"),
        dictgen::InsensitiveStr::Ascii("aviour"),
        dictgen::InsensitiveStr::Ascii("aviours"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNDERSAVIOR_7434958491263890564)],
        &[(0b00001, &ENTRY_UNDERSAVIORS_10984132115349151011)],
        &[(0b11010, &ENTRY_UNDERSAVIOR_7434958491263890564)],
        &[(0b11010, &ENTRY_UNDERSAVIORS_10984132115349151011)],
    ],
    range: 5..=7,
};

static VARS_UNDERR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNDERR_CHILDREN),
    value: None,
};

pub static VARS_UNDERR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ealise"),
        dictgen::InsensitiveStr::Ascii("ealised"),
        dictgen::InsensitiveStr::Ascii("ealises"),
        dictgen::InsensitiveStr::Ascii("ealising"),
        dictgen::InsensitiveStr::Ascii("ealize"),
        dictgen::InsensitiveStr::Ascii("ealized"),
        dictgen::InsensitiveStr::Ascii("ealizes"),
        dictgen::InsensitiveStr::Ascii("ealizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNDERREALIZE_7092158884515094974)],
        &[(0b10010, &ENTRY_UNDERREALIZED_18033081021006552359)],
        &[(0b10010, &ENTRY_UNDERREALIZES_2029819726682856248)],
        &[(0b10010, &ENTRY_UNDERREALIZING_17755667674781640335)],
        &[(0b01001, &ENTRY_UNDERREALIZE_7092158884515094974)],
        &[(0b01001, &ENTRY_UNDERREALIZED_18033081021006552359)],
        &[(0b01001, &ENTRY_UNDERREALIZES_2029819726682856248)],
        &[(0b01001, &ENTRY_UNDERREALIZING_17755667674781640335)],
    ],
    range: 6..=8,
};

static VARS_UNDERP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNDERP_CHILDREN),
    value: None,
};

pub static VARS_UNDERP_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rise"),
        dictgen::InsensitiveStr::Ascii("rised"),
        dictgen::InsensitiveStr::Ascii("rises"),
        dictgen::InsensitiveStr::Ascii("rising"),
        dictgen::InsensitiveStr::Ascii("rize"),
        dictgen::InsensitiveStr::Ascii("rized"),
        dictgen::InsensitiveStr::Ascii("rizes"),
        dictgen::InsensitiveStr::Ascii("rizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNDERPRIZE_5508380942697361246)],
        &[(0b10010, &ENTRY_UNDERPRIZED_10416331611131826895)],
        &[(0b10010, &ENTRY_UNDERPRIZES_6377465244834486670)],
        &[(0b10010, &ENTRY_UNDERPRIZING_17802343668144879352)],
        &[(0b01001, &ENTRY_UNDERPRIZE_5508380942697361246)],
        &[(0b01001, &ENTRY_UNDERPRIZED_10416331611131826895)],
        &[(0b01001, &ENTRY_UNDERPRIZES_6377465244834486670)],
        &[(0b01001, &ENTRY_UNDERPRIZING_17802343668144879352)],
    ],
    range: 4..=6,
};

static VARS_UNDERO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNDERO_CHILDREN),
    value: None,
};

pub static VARS_UNDERO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rganisation"),
        dictgen::InsensitiveStr::Ascii("rganisations"),
        dictgen::InsensitiveStr::Ascii("rganization"),
        dictgen::InsensitiveStr::Ascii("rganizations"),
        dictgen::InsensitiveStr::Ascii("xidise"),
        dictgen::InsensitiveStr::Ascii("xidised"),
        dictgen::InsensitiveStr::Ascii("xidises"),
        dictgen::InsensitiveStr::Ascii("xidising"),
        dictgen::InsensitiveStr::Ascii("xidize"),
        dictgen::InsensitiveStr::Ascii("xidized"),
        dictgen::InsensitiveStr::Ascii("xidizes"),
        dictgen::InsensitiveStr::Ascii("xidizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNDERORGANIZATION_7400455363911340000)],
        &[(0b10010, &ENTRY_UNDERORGANIZATIONS_10335581416606425325)],
        &[(0b01001, &ENTRY_UNDERORGANIZATION_7400455363911340000)],
        &[(0b01001, &ENTRY_UNDERORGANIZATIONS_10335581416606425325)],
        &[(0b10010, &ENTRY_UNDEROXIDIZE_6485083535977243452)],
        &[(0b10010, &ENTRY_UNDEROXIDIZED_9530283666542091132)],
        &[(0b10010, &ENTRY_UNDEROXIDIZES_11400908621570551704)],
        &[(0b10010, &ENTRY_UNDEROXIDIZING_7229227794588570973)],
        &[(0b01001, &ENTRY_UNDEROXIDIZE_6485083535977243452)],
        &[(0b01001, &ENTRY_UNDEROXIDIZED_9530283666542091132)],
        &[(0b01001, &ENTRY_UNDEROXIDIZES_11400908621570551704)],
        &[(0b01001, &ENTRY_UNDEROXIDIZING_7229227794588570973)],
    ],
    range: 6..=12,
};

static VARS_UNDERL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNDERL_CHILDREN),
    value: None,
};

pub static VARS_UNDERL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aborer"),
        dictgen::InsensitiveStr::Ascii("aborers"),
        dictgen::InsensitiveStr::Ascii("abourer"),
        dictgen::InsensitiveStr::Ascii("abourers"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNDERLABORER_3694933881204703688)],
        &[(0b00001, &ENTRY_UNDERLABORERS_9021923481724217322)],
        &[(0b11010, &ENTRY_UNDERLABORER_3694933881204703688)],
        &[(0b11010, &ENTRY_UNDERLABORERS_9021923481724217322)],
    ],
    range: 6..=8,
};

static VARS_UNDERG_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNDERG_CHILDREN),
    value: None,
};

pub static VARS_UNDERG_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("oer"),
        dictgen::InsensitiveStr::Ascii("ore"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNDERGOER_9429829714211980631)],
        &[(0b11010, &ENTRY_UNDERGOER_9429829714211980631)],
    ],
    range: 3..=3,
};

static VARS_UNDERE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNDERE_CHILDREN),
    value: None,
};

pub static VARS_UNDERE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("mphasise"),
        dictgen::InsensitiveStr::Ascii("mphasised"),
        dictgen::InsensitiveStr::Ascii("mphasises"),
        dictgen::InsensitiveStr::Ascii("mphasising"),
        dictgen::InsensitiveStr::Ascii("mphasize"),
        dictgen::InsensitiveStr::Ascii("mphasized"),
        dictgen::InsensitiveStr::Ascii("mphasizes"),
        dictgen::InsensitiveStr::Ascii("mphasizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNDEREMPHASIZE_16005848787441654782)],
        &[(0b10010, &ENTRY_UNDEREMPHASIZED_13287064872491391347)],
        &[(0b10010, &ENTRY_UNDEREMPHASIZES_12584850145350891996)],
        &[(0b10010, &ENTRY_UNDEREMPHASIZING_6499426514394882956)],
        &[(0b01001, &ENTRY_UNDEREMPHASIZE_16005848787441654782)],
        &[(0b01001, &ENTRY_UNDEREMPHASIZED_13287064872491391347)],
        &[(0b01001, &ENTRY_UNDEREMPHASIZES_12584850145350891996)],
        &[(0b01001, &ENTRY_UNDEREMPHASIZING_6499426514394882956)],
    ],
    range: 8..=10,
};

static VARS_UNDERC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNDERC_CHILDREN),
    value: None,
};

pub static VARS_UNDERC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("apitalisation"),
        dictgen::InsensitiveStr::Ascii("apitalisations"),
        dictgen::InsensitiveStr::Ascii("apitalise"),
        dictgen::InsensitiveStr::Ascii("apitalised"),
        dictgen::InsensitiveStr::Ascii("apitalises"),
        dictgen::InsensitiveStr::Ascii("apitalising"),
        dictgen::InsensitiveStr::Ascii("apitalization"),
        dictgen::InsensitiveStr::Ascii("apitalizations"),
        dictgen::InsensitiveStr::Ascii("apitalize"),
        dictgen::InsensitiveStr::Ascii("apitalized"),
        dictgen::InsensitiveStr::Ascii("apitalizes"),
        dictgen::InsensitiveStr::Ascii("apitalizing"),
        dictgen::InsensitiveStr::Ascii("olor"),
        dictgen::InsensitiveStr::Ascii("olored"),
        dictgen::InsensitiveStr::Ascii("oloring"),
        dictgen::InsensitiveStr::Ascii("olorings"),
        dictgen::InsensitiveStr::Ascii("olors"),
        dictgen::InsensitiveStr::Ascii("olour"),
        dictgen::InsensitiveStr::Ascii("oloured"),
        dictgen::InsensitiveStr::Ascii("olouring"),
        dictgen::InsensitiveStr::Ascii("olourings"),
        dictgen::InsensitiveStr::Ascii("olours"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNDERCAPITALIZATION_10660193274275293366)],
        &[(0b10010, &ENTRY_UNDERCAPITALIZATIONS_15182325328537661657)],
        &[(0b10010, &ENTRY_UNDERCAPITALIZE_16023499620792084738)],
        &[(0b10010, &ENTRY_UNDERCAPITALIZED_4628390293054794377)],
        &[(0b10010, &ENTRY_UNDERCAPITALIZES_3303618473551057315)],
        &[(0b10010, &ENTRY_UNDERCAPITALIZING_16232808968195990904)],
        &[(0b01001, &ENTRY_UNDERCAPITALIZATION_10660193274275293366)],
        &[(0b01001, &ENTRY_UNDERCAPITALIZATIONS_15182325328537661657)],
        &[(0b01001, &ENTRY_UNDERCAPITALIZE_16023499620792084738)],
        &[(0b01001, &ENTRY_UNDERCAPITALIZED_4628390293054794377)],
        &[(0b01001, &ENTRY_UNDERCAPITALIZES_3303618473551057315)],
        &[(0b01001, &ENTRY_UNDERCAPITALIZING_16232808968195990904)],
        &[(0b00001, &ENTRY_UNDERCOLOR_8519534420778344085)],
        &[(0b00001, &ENTRY_UNDERCOLORED_17422644742945532202)],
        &[(0b00001, &ENTRY_UNDERCOLORING_7781389003709580079)],
        &[(0b00001, &ENTRY_UNDERCOLORINGS_10087184255355441121)],
        &[(0b00001, &ENTRY_UNDERCOLORS_6190629777654495448)],
        &[(0b11010, &ENTRY_UNDERCOLOR_8519534420778344085)],
        &[(0b11010, &ENTRY_UNDERCOLORED_17422644742945532202)],
        &[(0b11010, &ENTRY_UNDERCOLORING_7781389003709580079)],
        &[(0b11010, &ENTRY_UNDERCOLORINGS_10087184255355441121)],
        &[(0b11010, &ENTRY_UNDERCOLORS_6190629777654495448)],
    ],
    range: 4..=14,
};

static VARS_UNDEN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNDEN_CHILDREN),
    value: None,
};

pub static VARS_UNDEN_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ominationalise"),
        dictgen::InsensitiveStr::Ascii("ominationalises"),
        dictgen::InsensitiveStr::Ascii("ominationalize"),
        dictgen::InsensitiveStr::Ascii("ominationalizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNDENOMINATIONALIZE_6740738141836952680)],
        &[(0b10010, &ENTRY_UNDENOMINATIONALIZES_3120796019381704993)],
        &[(0b01001, &ENTRY_UNDENOMINATIONALIZE_6740738141836952680)],
        &[(0b01001, &ENTRY_UNDENOMINATIONALIZES_3120796019381704993)],
    ],
    range: 14..=15,
};

static VARS_UNDEM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNDEM_CHILDREN),
    value: None,
};

pub static VARS_UNDEM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("agnetisable"),
        dictgen::InsensitiveStr::Ascii("agnetisables"),
        dictgen::InsensitiveStr::Ascii("agnetizable"),
        dictgen::InsensitiveStr::Ascii("agnetizables"),
        dictgen::InsensitiveStr::Ascii("ocratisation"),
        dictgen::InsensitiveStr::Ascii("ocratise"),
        dictgen::InsensitiveStr::Ascii("ocratised"),
        dictgen::InsensitiveStr::Ascii("ocratises"),
        dictgen::InsensitiveStr::Ascii("ocratising"),
        dictgen::InsensitiveStr::Ascii("ocratization"),
        dictgen::InsensitiveStr::Ascii("ocratize"),
        dictgen::InsensitiveStr::Ascii("ocratized"),
        dictgen::InsensitiveStr::Ascii("ocratizes"),
        dictgen::InsensitiveStr::Ascii("ocratizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNDEMAGNETIZABLE_15252782349141238446)],
        &[(0b10010, &ENTRY_UNDEMAGNETIZABLES_5686795504114325763)],
        &[(0b01001, &ENTRY_UNDEMAGNETIZABLE_15252782349141238446)],
        &[(0b01001, &ENTRY_UNDEMAGNETIZABLES_5686795504114325763)],
        &[(0b10010, &ENTRY_UNDEMOCRATIZATION_1985548670847944255)],
        &[(0b10010, &ENTRY_UNDEMOCRATIZE_1034629020769539043)],
        &[(0b10010, &ENTRY_UNDEMOCRATIZED_2117183159769210163)],
        &[(0b10010, &ENTRY_UNDEMOCRATIZES_5725888909225905299)],
        &[(0b10010, &ENTRY_UNDEMOCRATIZING_4527096256498077472)],
        &[(0b01001, &ENTRY_UNDEMOCRATIZATION_1985548670847944255)],
        &[(0b01001, &ENTRY_UNDEMOCRATIZE_1034629020769539043)],
        &[(0b01001, &ENTRY_UNDEMOCRATIZED_2117183159769210163)],
        &[(0b01001, &ENTRY_UNDEMOCRATIZES_5725888909225905299)],
        &[(0b01001, &ENTRY_UNDEMOCRATIZING_4527096256498077472)],
    ],
    range: 8..=12,
};

static VARS_UNDEF_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNDEF_CHILDREN),
    value: None,
};

pub static VARS_UNDEF_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ence"),
        dictgen::InsensitiveStr::Ascii("ences"),
        dictgen::InsensitiveStr::Ascii("ense"),
        dictgen::InsensitiveStr::Ascii("enses"),
    ],
    values: &[
        &[(0b11010, &ENTRY_UNDEFENSE_1506818606399848606)],
        &[(0b11010, &ENTRY_UNDEFENSES_5387761130135332933)],
        &[(0b00001, &ENTRY_UNDEFENSE_1506818606399848606)],
        &[(0b00001, &ENTRY_UNDEFENSES_5387761130135332933)],
    ],
    range: 4..=5,
};

static VARS_UNC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UNC_CHILDREN),
    value: None,
};

static VARS_UNC_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_UNCA_NODE),
    None,
    None,
    None,
    Some(&VARS_UNCE_NODE),
    None,
    None,
    Some(&VARS_UNCH_NODE),
    Some(&VARS_UNCI_NODE),
    None,
    None,
    Some(&VARS_UNCL_NODE),
    None,
    None,
    Some(&VARS_UNCO_NODE),
    None,
    None,
    Some(&VARS_UNCR_NODE),
    None,
    None,
    Some(&VARS_UNCU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_UNCU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNCU_CHILDREN),
    value: None,
};

pub static VARS_UNCU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rricularised"),
        dictgen::InsensitiveStr::Ascii("rriculariseds"),
        dictgen::InsensitiveStr::Ascii("rricularized"),
        dictgen::InsensitiveStr::Ascii("rricularizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNCURRICULARIZED_1510394198207258931)],
        &[(0b10010, &ENTRY_UNCURRICULARIZEDS_8615810342283576503)],
        &[(0b01001, &ENTRY_UNCURRICULARIZED_1510394198207258931)],
        &[(0b01001, &ENTRY_UNCURRICULARIZEDS_8615810342283576503)],
    ],
    range: 12..=13,
};

static VARS_UNCR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNCR_CHILDREN),
    value: None,
};

pub static VARS_UNCR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("iticisable"),
        dictgen::InsensitiveStr::Ascii("iticisabler"),
        dictgen::InsensitiveStr::Ascii("iticisables"),
        dictgen::InsensitiveStr::Ascii("iticisablest"),
        dictgen::InsensitiveStr::Ascii("iticisably"),
        dictgen::InsensitiveStr::Ascii("iticised"),
        dictgen::InsensitiveStr::Ascii("iticising"),
        dictgen::InsensitiveStr::Ascii("iticisingly"),
        dictgen::InsensitiveStr::Ascii("iticizable"),
        dictgen::InsensitiveStr::Ascii("iticizabler"),
        dictgen::InsensitiveStr::Ascii("iticizables"),
        dictgen::InsensitiveStr::Ascii("iticizablest"),
        dictgen::InsensitiveStr::Ascii("iticizably"),
        dictgen::InsensitiveStr::Ascii("iticized"),
        dictgen::InsensitiveStr::Ascii("iticizing"),
        dictgen::InsensitiveStr::Ascii("iticizingly"),
        dictgen::InsensitiveStr::Ascii("ystallisabilities"),
        dictgen::InsensitiveStr::Ascii("ystallisability"),
        dictgen::InsensitiveStr::Ascii("ystallisable"),
        dictgen::InsensitiveStr::Ascii("ystallisabler"),
        dictgen::InsensitiveStr::Ascii("ystallisables"),
        dictgen::InsensitiveStr::Ascii("ystallisablest"),
        dictgen::InsensitiveStr::Ascii("ystallised"),
        dictgen::InsensitiveStr::Ascii("ystallizabilities"),
        dictgen::InsensitiveStr::Ascii("ystallizability"),
        dictgen::InsensitiveStr::Ascii("ystallizable"),
        dictgen::InsensitiveStr::Ascii("ystallizabler"),
        dictgen::InsensitiveStr::Ascii("ystallizables"),
        dictgen::InsensitiveStr::Ascii("ystallizablest"),
        dictgen::InsensitiveStr::Ascii("ystallized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNCRITICIZABLE_11373327800791333419)],
        &[(0b10010, &ENTRY_UNCRITICIZABLER_12547491203255935586)],
        &[(0b10010, &ENTRY_UNCRITICIZABLES_12700073615320281916)],
        &[(0b10010, &ENTRY_UNCRITICIZABLEST_4607318644536802423)],
        &[(0b10010, &ENTRY_UNCRITICIZABLY_5679899333014793182)],
        &[(0b10010, &ENTRY_UNCRITICIZED_2911120484028704139)],
        &[(0b10010, &ENTRY_UNCRITICIZING_11997178515445821682)],
        &[(0b10010, &ENTRY_UNCRITICIZINGLY_8633111293350941138)],
        &[(0b01001, &ENTRY_UNCRITICIZABLE_11373327800791333419)],
        &[(0b01001, &ENTRY_UNCRITICIZABLER_12547491203255935586)],
        &[(0b01001, &ENTRY_UNCRITICIZABLES_12700073615320281916)],
        &[(0b01001, &ENTRY_UNCRITICIZABLEST_4607318644536802423)],
        &[(0b01001, &ENTRY_UNCRITICIZABLY_5679899333014793182)],
        &[(0b01001, &ENTRY_UNCRITICIZED_2911120484028704139)],
        &[(0b01001, &ENTRY_UNCRITICIZING_11997178515445821682)],
        &[(0b01001, &ENTRY_UNCRITICIZINGLY_8633111293350941138)],
        &[(0b10010, &ENTRY_UNCRYSTALLIZABILITIES_17690728856956585473)],
        &[(0b10010, &ENTRY_UNCRYSTALLIZABILITY_11525239910591863121)],
        &[(0b10010, &ENTRY_UNCRYSTALLIZABLE_896206698167723642)],
        &[(0b10010, &ENTRY_UNCRYSTALLIZABLER_16849085510473534176)],
        &[(0b10010, &ENTRY_UNCRYSTALLIZABLES_5618943405184002759)],
        &[(0b10010, &ENTRY_UNCRYSTALLIZABLEST_5988044069876666615)],
        &[(0b10010, &ENTRY_UNCRYSTALLIZED_2777096876542409868)],
        &[(0b01001, &ENTRY_UNCRYSTALLIZABILITIES_17690728856956585473)],
        &[(0b01001, &ENTRY_UNCRYSTALLIZABILITY_11525239910591863121)],
        &[(0b01001, &ENTRY_UNCRYSTALLIZABLE_896206698167723642)],
        &[(0b01001, &ENTRY_UNCRYSTALLIZABLER_16849085510473534176)],
        &[(0b01001, &ENTRY_UNCRYSTALLIZABLES_5618943405184002759)],
        &[(0b01001, &ENTRY_UNCRYSTALLIZABLEST_5988044069876666615)],
        &[(0b01001, &ENTRY_UNCRYSTALLIZED_2777096876542409868)],
    ],
    range: 8..=17,
};

static VARS_UNCO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNCO_CHILDREN),
    value: None,
};

pub static VARS_UNCO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gnisable"),
        dictgen::InsensitiveStr::Ascii("gnizable"),
        dictgen::InsensitiveStr::Ascii("lonise"),
        dictgen::InsensitiveStr::Ascii("lonised"),
        dictgen::InsensitiveStr::Ascii("lonises"),
        dictgen::InsensitiveStr::Ascii("lonising"),
        dictgen::InsensitiveStr::Ascii("lonize"),
        dictgen::InsensitiveStr::Ascii("lonized"),
        dictgen::InsensitiveStr::Ascii("lonizes"),
        dictgen::InsensitiveStr::Ascii("lonizing"),
        dictgen::InsensitiveStr::Ascii("lorable"),
        dictgen::InsensitiveStr::Ascii("lorabler"),
        dictgen::InsensitiveStr::Ascii("lorables"),
        dictgen::InsensitiveStr::Ascii("lorablest"),
        dictgen::InsensitiveStr::Ascii("lorablier"),
        dictgen::InsensitiveStr::Ascii("lorablies"),
        dictgen::InsensitiveStr::Ascii("lorabliest"),
        dictgen::InsensitiveStr::Ascii("lorably"),
        dictgen::InsensitiveStr::Ascii("lored"),
        dictgen::InsensitiveStr::Ascii("loredder"),
        dictgen::InsensitiveStr::Ascii("loreddest"),
        dictgen::InsensitiveStr::Ascii("loredlier"),
        dictgen::InsensitiveStr::Ascii("loredliest"),
        dictgen::InsensitiveStr::Ascii("loredly"),
        dictgen::InsensitiveStr::Ascii("loredness"),
        dictgen::InsensitiveStr::Ascii("lorednesses"),
        dictgen::InsensitiveStr::Ascii("loreds"),
        dictgen::InsensitiveStr::Ascii("lourable"),
        dictgen::InsensitiveStr::Ascii("lourabler"),
        dictgen::InsensitiveStr::Ascii("lourables"),
        dictgen::InsensitiveStr::Ascii("lourablest"),
        dictgen::InsensitiveStr::Ascii("lourablier"),
        dictgen::InsensitiveStr::Ascii("lourablies"),
        dictgen::InsensitiveStr::Ascii("lourabliest"),
        dictgen::InsensitiveStr::Ascii("lourably"),
        dictgen::InsensitiveStr::Ascii("loured"),
        dictgen::InsensitiveStr::Ascii("louredder"),
        dictgen::InsensitiveStr::Ascii("loureddest"),
        dictgen::InsensitiveStr::Ascii("louredlier"),
        dictgen::InsensitiveStr::Ascii("louredliest"),
        dictgen::InsensitiveStr::Ascii("louredly"),
        dictgen::InsensitiveStr::Ascii("louredness"),
        dictgen::InsensitiveStr::Ascii("lourednesses"),
        dictgen::InsensitiveStr::Ascii("loureds"),
        dictgen::InsensitiveStr::Ascii("ncerted"),
        dictgen::InsensitiveStr::Ascii("ncreted"),
        dictgen::InsensitiveStr::Ascii("nventionalise"),
        dictgen::InsensitiveStr::Ascii("nventionalises"),
        dictgen::InsensitiveStr::Ascii("nventionalize"),
        dictgen::InsensitiveStr::Ascii("nventionalizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNCOGNIZABLE_8427011542426523053)],
        &[(0b01001, &ENTRY_UNCOGNIZABLE_8427011542426523053)],
        &[(0b10010, &ENTRY_UNCOLONIZE_4719662676234790116)],
        &[(0b10010, &ENTRY_UNCOLONIZED_14464259688836318286)],
        &[(0b10010, &ENTRY_UNCOLONIZES_9719326327721062003)],
        &[(0b10010, &ENTRY_UNCOLONIZING_15664887216370082580)],
        &[(0b01001, &ENTRY_UNCOLONIZE_4719662676234790116)],
        &[(0b01001, &ENTRY_UNCOLONIZED_14464259688836318286)],
        &[(0b01001, &ENTRY_UNCOLONIZES_9719326327721062003)],
        &[(0b01001, &ENTRY_UNCOLONIZING_15664887216370082580)],
        &[(0b00001, &ENTRY_UNCOLORABLE_16859002938981914415)],
        &[(0b00001, &ENTRY_UNCOLORABLER_1677263340221600893)],
        &[(0b00001, &ENTRY_UNCOLORABLES_3510625143099969360)],
        &[(0b00001, &ENTRY_UNCOLORABLEST_7640890717461053308)],
        &[(0b00001, &ENTRY_UNCOLORABLIER_15894133128738876679)],
        &[(0b00001, &ENTRY_UNCOLORABLIES_11097679658499545820)],
        &[(0b00001, &ENTRY_UNCOLORABLIEST_11422798475250273761)],
        &[(0b00001, &ENTRY_UNCOLORABLY_6941577112469631446)],
        &[(0b11001, &ENTRY_UNCOLORED_11161437304186875893)],
        &[(0b11001, &ENTRY_UNCOLOREDDER_44322368202115976)],
        &[(0b11001, &ENTRY_UNCOLOREDDEST_15878875459057574341)],
        &[(0b00001, &ENTRY_UNCOLOREDLIER_6703103262670401501)],
        &[(0b00001, &ENTRY_UNCOLOREDLIEST_12675741818469230732)],
        &[(0b00001, &ENTRY_UNCOLOREDLY_16713739233776863755)],
        &[(0b00001, &ENTRY_UNCOLOREDNESS_16507195530617886306)],
        &[(0b00001, &ENTRY_UNCOLOREDNESSES_7712224291050878796)],
        &[(0b11001, &ENTRY_UNCOLOREDS_8597280883372836480)],
        &[(0b11010, &ENTRY_UNCOLORABLE_16859002938981914415)],
        &[(0b11010, &ENTRY_UNCOLORABLER_1677263340221600893)],
        &[(0b11010, &ENTRY_UNCOLORABLES_3510625143099969360)],
        &[(0b11010, &ENTRY_UNCOLORABLEST_7640890717461053308)],
        &[(0b11010, &ENTRY_UNCOLORABLIER_15894133128738876679)],
        &[(0b11010, &ENTRY_UNCOLORABLIES_11097679658499545820)],
        &[(0b11010, &ENTRY_UNCOLORABLIEST_11422798475250273761)],
        &[(0b11010, &ENTRY_UNCOLORABLY_6941577112469631446)],
        &[(0b11010, &ENTRY_UNCOLORED_11161437304186875893)],
        &[(0b11010, &ENTRY_UNCOLOREDDER_44322368202115976)],
        &[(0b11010, &ENTRY_UNCOLOREDDEST_15878875459057574341)],
        &[(0b11010, &ENTRY_UNCOLOREDLIER_6703103262670401501)],
        &[(0b11010, &ENTRY_UNCOLOREDLIEST_12675741818469230732)],
        &[(0b11010, &ENTRY_UNCOLOREDLY_16713739233776863755)],
        &[(0b11010, &ENTRY_UNCOLOREDNESS_16507195530617886306)],
        &[(0b11010, &ENTRY_UNCOLOREDNESSES_7712224291050878796)],
        &[(0b11010, &ENTRY_UNCOLOREDS_8597280883372836480)],
        &[(0b00001, &ENTRY_UNCONCERTED_6095497230856593489)],
        &[(0b11010, &ENTRY_UNCONCERTED_6095497230856593489)],
        &[(0b10010, &ENTRY_UNCONVENTIONALIZE_7485202036270814256)],
        &[(0b10010, &ENTRY_UNCONVENTIONALIZES_1804902019330246754)],
        &[(0b01001, &ENTRY_UNCONVENTIONALIZE_7485202036270814256)],
        &[(0b01001, &ENTRY_UNCONVENTIONALIZES_1804902019330246754)],
    ],
    range: 5..=14,
};

static VARS_UNCL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNCL_CHILDREN),
    value: None,
};

pub static VARS_UNCL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ericalise"),
        dictgen::InsensitiveStr::Ascii("ericalises"),
        dictgen::InsensitiveStr::Ascii("ericalize"),
        dictgen::InsensitiveStr::Ascii("ericalizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNCLERICALIZE_5058403399765937609)],
        &[(0b10010, &ENTRY_UNCLERICALIZES_8000982562629252294)],
        &[(0b01001, &ENTRY_UNCLERICALIZE_5058403399765937609)],
        &[(0b01001, &ENTRY_UNCLERICALIZES_8000982562629252294)],
    ],
    range: 9..=10,
};

static VARS_UNCI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNCI_CHILDREN),
    value: None,
};

pub static VARS_UNCI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rcularised"),
        dictgen::InsensitiveStr::Ascii("rcularisedder"),
        dictgen::InsensitiveStr::Ascii("rculariseddest"),
        dictgen::InsensitiveStr::Ascii("rculariseds"),
        dictgen::InsensitiveStr::Ascii("rcularized"),
        dictgen::InsensitiveStr::Ascii("rcularizedder"),
        dictgen::InsensitiveStr::Ascii("rcularizeddest"),
        dictgen::InsensitiveStr::Ascii("rcularizeds"),
        dictgen::InsensitiveStr::Ascii("vilisable"),
        dictgen::InsensitiveStr::Ascii("vilisabler"),
        dictgen::InsensitiveStr::Ascii("vilisables"),
        dictgen::InsensitiveStr::Ascii("vilisablest"),
        dictgen::InsensitiveStr::Ascii("vilise"),
        dictgen::InsensitiveStr::Ascii("vilised"),
        dictgen::InsensitiveStr::Ascii("vilisedly"),
        dictgen::InsensitiveStr::Ascii("vilisedness"),
        dictgen::InsensitiveStr::Ascii("vilises"),
        dictgen::InsensitiveStr::Ascii("vilizable"),
        dictgen::InsensitiveStr::Ascii("vilizabler"),
        dictgen::InsensitiveStr::Ascii("vilizables"),
        dictgen::InsensitiveStr::Ascii("vilizablest"),
        dictgen::InsensitiveStr::Ascii("vilize"),
        dictgen::InsensitiveStr::Ascii("vilized"),
        dictgen::InsensitiveStr::Ascii("vilizedly"),
        dictgen::InsensitiveStr::Ascii("vilizedness"),
        dictgen::InsensitiveStr::Ascii("vilizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNCIRCULARIZED_1673876733486569108)],
        &[(0b10010, &ENTRY_UNCIRCULARIZEDDER_13401377351716086368)],
        &[(0b10010, &ENTRY_UNCIRCULARIZEDDEST_9951597685170363487)],
        &[(0b10010, &ENTRY_UNCIRCULARIZEDS_1250844431562273063)],
        &[(0b01001, &ENTRY_UNCIRCULARIZED_1673876733486569108)],
        &[(0b01001, &ENTRY_UNCIRCULARIZEDDER_13401377351716086368)],
        &[(0b01001, &ENTRY_UNCIRCULARIZEDDEST_9951597685170363487)],
        &[(0b01001, &ENTRY_UNCIRCULARIZEDS_1250844431562273063)],
        &[(0b10010, &ENTRY_UNCIVILIZABLE_5359864439117880170)],
        &[(0b10010, &ENTRY_UNCIVILIZABLER_5349352586984667487)],
        &[(0b10010, &ENTRY_UNCIVILIZABLES_5534726098220309871)],
        &[(0b10010, &ENTRY_UNCIVILIZABLEST_7329790362151161087)],
        &[(0b10010, &ENTRY_UNCIVILIZE_16379895937239654425)],
        &[(0b10010, &ENTRY_UNCIVILIZED_7166539918987564819)],
        &[(0b10010, &ENTRY_UNCIVILIZEDLY_13183249970870160815)],
        &[(0b10010, &ENTRY_UNCIVILIZEDNESS_13286745087730550691)],
        &[(0b10010, &ENTRY_UNCIVILIZES_4114315705302110845)],
        &[(0b01001, &ENTRY_UNCIVILIZABLE_5359864439117880170)],
        &[(0b01001, &ENTRY_UNCIVILIZABLER_5349352586984667487)],
        &[(0b01001, &ENTRY_UNCIVILIZABLES_5534726098220309871)],
        &[(0b01001, &ENTRY_UNCIVILIZABLEST_7329790362151161087)],
        &[(0b01001, &ENTRY_UNCIVILIZE_16379895937239654425)],
        &[(0b01001, &ENTRY_UNCIVILIZED_7166539918987564819)],
        &[(0b01001, &ENTRY_UNCIVILIZEDLY_13183249970870160815)],
        &[(0b01001, &ENTRY_UNCIVILIZEDNESS_13286745087730550691)],
        &[(0b01001, &ENTRY_UNCIVILIZES_4114315705302110845)],
    ],
    range: 6..=14,
};

static VARS_UNCH_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNCH_CHILDREN),
    value: None,
};

pub static VARS_UNCH_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aracterised"),
        dictgen::InsensitiveStr::Ascii("aracterisedder"),
        dictgen::InsensitiveStr::Ascii("aracteriseddest"),
        dictgen::InsensitiveStr::Ascii("aracterized"),
        dictgen::InsensitiveStr::Ascii("aracterizedder"),
        dictgen::InsensitiveStr::Ascii("aracterizeddest"),
        dictgen::InsensitiveStr::Ascii("astisable"),
        dictgen::InsensitiveStr::Ascii("astised"),
        dictgen::InsensitiveStr::Ascii("astizable"),
        dictgen::InsensitiveStr::Ascii("astized"),
        dictgen::InsensitiveStr::Ascii("loridised"),
        dictgen::InsensitiveStr::Ascii("loridiseds"),
        dictgen::InsensitiveStr::Ascii("loridized"),
        dictgen::InsensitiveStr::Ascii("loridizeds"),
        dictgen::InsensitiveStr::Ascii("ristianise"),
        dictgen::InsensitiveStr::Ascii("ristianised"),
        dictgen::InsensitiveStr::Ascii("ristianises"),
        dictgen::InsensitiveStr::Ascii("ristianising"),
        dictgen::InsensitiveStr::Ascii("ristianize"),
        dictgen::InsensitiveStr::Ascii("ristianized"),
        dictgen::InsensitiveStr::Ascii("ristianizes"),
        dictgen::InsensitiveStr::Ascii("ristianizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNCHARACTERIZED_16956353213909858293)],
        &[(0b10010, &ENTRY_UNCHARACTERIZEDDER_9630905361449944494)],
        &[(0b10010, &ENTRY_UNCHARACTERIZEDDEST_12996144895873850714)],
        &[(0b01001, &ENTRY_UNCHARACTERIZED_16956353213909858293)],
        &[(0b01001, &ENTRY_UNCHARACTERIZEDDER_9630905361449944494)],
        &[(0b01001, &ENTRY_UNCHARACTERIZEDDEST_12996144895873850714)],
        &[(0b10010, &ENTRY_UNCHASTIZABLE_9875729189061084670)],
        &[(0b10010, &ENTRY_UNCHASTIZED_4193981014376295283)],
        &[(0b01001, &ENTRY_UNCHASTIZABLE_9875729189061084670)],
        &[(0b01001, &ENTRY_UNCHASTIZED_4193981014376295283)],
        &[(0b10010, &ENTRY_UNCHLORIDIZED_16671439068894580937)],
        &[(0b10010, &ENTRY_UNCHLORIDIZEDS_14218178409370978541)],
        &[(0b01001, &ENTRY_UNCHLORIDIZED_16671439068894580937)],
        &[(0b01001, &ENTRY_UNCHLORIDIZEDS_14218178409370978541)],
        &[(0b10010, &ENTRY_UNCHRISTIANIZE_60148917993740076)],
        &[(0b10010, &ENTRY_UNCHRISTIANIZED_13080855627488192760)],
        &[(0b10010, &ENTRY_UNCHRISTIANIZES_9247340614604210077)],
        &[(0b10010, &ENTRY_UNCHRISTIANIZING_16239590731316126727)],
        &[(0b01001, &ENTRY_UNCHRISTIANIZE_60148917993740076)],
        &[(0b01001, &ENTRY_UNCHRISTIANIZED_13080855627488192760)],
        &[(0b01001, &ENTRY_UNCHRISTIANIZES_9247340614604210077)],
        &[(0b01001, &ENTRY_UNCHRISTIANIZING_16239590731316126727)],
    ],
    range: 7..=15,
};

static VARS_UNCE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNCE_CHILDREN),
    value: None,
};

pub static VARS_UNCE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lestialised"),
        dictgen::InsensitiveStr::Ascii("lestialiseds"),
        dictgen::InsensitiveStr::Ascii("lestialized"),
        dictgen::InsensitiveStr::Ascii("lestializeds"),
        dictgen::InsensitiveStr::Ascii("nter"),
        dictgen::InsensitiveStr::Ascii("ntralised"),
        dictgen::InsensitiveStr::Ascii("ntralized"),
        dictgen::InsensitiveStr::Ascii("ntre"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNCELESTIALIZED_17943151837268803496)],
        &[(0b10010, &ENTRY_UNCELESTIALIZEDS_2449557772093094129)],
        &[(0b01001, &ENTRY_UNCELESTIALIZED_17943151837268803496)],
        &[(0b01001, &ENTRY_UNCELESTIALIZEDS_2449557772093094129)],
        &[(0b00001, &ENTRY_UNCENTER_15807123308053109883)],
        &[(0b10010, &ENTRY_UNCENTRALIZED_3375219947813958573)],
        &[(0b01001, &ENTRY_UNCENTRALIZED_3375219947813958573)],
        &[(0b11010, &ENTRY_UNCENTER_15807123308053109883)],
    ],
    range: 4..=12,
};

static VARS_UNCA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNCA_CHILDREN),
    value: None,
};

pub static VARS_UNCA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("nceled"),
        dictgen::InsensitiveStr::Ascii("nceledder"),
        dictgen::InsensitiveStr::Ascii("nceleddest"),
        dictgen::InsensitiveStr::Ascii("ndor"),
        dictgen::InsensitiveStr::Ascii("ndour"),
        dictgen::InsensitiveStr::Ascii("nonisation"),
        dictgen::InsensitiveStr::Ascii("nonise"),
        dictgen::InsensitiveStr::Ascii("nonised"),
        dictgen::InsensitiveStr::Ascii("nonises"),
        dictgen::InsensitiveStr::Ascii("nonising"),
        dictgen::InsensitiveStr::Ascii("nonization"),
        dictgen::InsensitiveStr::Ascii("nonize"),
        dictgen::InsensitiveStr::Ascii("nonized"),
        dictgen::InsensitiveStr::Ascii("nonizes"),
        dictgen::InsensitiveStr::Ascii("nonizing"),
        dictgen::InsensitiveStr::Ascii("ntonised"),
        dictgen::InsensitiveStr::Ascii("ntoniseds"),
        dictgen::InsensitiveStr::Ascii("ntonized"),
        dictgen::InsensitiveStr::Ascii("ntonizeds"),
        dictgen::InsensitiveStr::Ascii("pitalised"),
        dictgen::InsensitiveStr::Ascii("pitalisedder"),
        dictgen::InsensitiveStr::Ascii("pitaliseddest"),
        dictgen::InsensitiveStr::Ascii("pitalized"),
        dictgen::InsensitiveStr::Ascii("pitalizedder"),
        dictgen::InsensitiveStr::Ascii("pitalizeddest"),
        dictgen::InsensitiveStr::Ascii("ramelised"),
        dictgen::InsensitiveStr::Ascii("ramelized"),
        dictgen::InsensitiveStr::Ascii("techised"),
        dictgen::InsensitiveStr::Ascii("techisedness"),
        dictgen::InsensitiveStr::Ascii("techiseds"),
        dictgen::InsensitiveStr::Ascii("techized"),
        dictgen::InsensitiveStr::Ascii("techizedness"),
        dictgen::InsensitiveStr::Ascii("techizeds"),
        dictgen::InsensitiveStr::Ascii("tegorised"),
        dictgen::InsensitiveStr::Ascii("tegorisedder"),
        dictgen::InsensitiveStr::Ascii("tegoriseddest"),
        dictgen::InsensitiveStr::Ascii("tegorized"),
        dictgen::InsensitiveStr::Ascii("tegorizedder"),
        dictgen::InsensitiveStr::Ascii("tegorizeddest"),
        dictgen::InsensitiveStr::Ascii("tholicise"),
        dictgen::InsensitiveStr::Ascii("tholicised"),
        dictgen::InsensitiveStr::Ascii("tholicises"),
        dictgen::InsensitiveStr::Ascii("tholicising"),
        dictgen::InsensitiveStr::Ascii("tholicize"),
        dictgen::InsensitiveStr::Ascii("tholicized"),
        dictgen::InsensitiveStr::Ascii("tholicizes"),
        dictgen::InsensitiveStr::Ascii("tholicizing"),
        dictgen::InsensitiveStr::Ascii("uterised"),
        dictgen::InsensitiveStr::Ascii("uteriseds"),
        dictgen::InsensitiveStr::Ascii("uterized"),
        dictgen::InsensitiveStr::Ascii("uterizeds"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNCANCELED_14881575187258887119)],
        &[(0b00001, &ENTRY_UNCANCELEDDER_846969059949847342)],
        &[(0b00001, &ENTRY_UNCANCELEDDEST_16688600251952129306)],
        &[(0b00001, &ENTRY_UNCANDOR_1117487908276698433)],
        &[(0b11010, &ENTRY_UNCANDOR_1117487908276698433)],
        &[(0b10010, &ENTRY_UNCANONIZATION_17424198936114457720)],
        &[(0b10010, &ENTRY_UNCANONIZE_8078618209055157420)],
        &[(0b10010, &ENTRY_UNCANONIZED_5538989722513762511)],
        &[(0b10010, &ENTRY_UNCANONIZES_12153715475418673041)],
        &[(0b10010, &ENTRY_UNCANONIZING_3397483964901532622)],
        &[(0b01001, &ENTRY_UNCANONIZATION_17424198936114457720)],
        &[(0b01001, &ENTRY_UNCANONIZE_8078618209055157420)],
        &[(0b01001, &ENTRY_UNCANONIZED_5538989722513762511)],
        &[(0b01001, &ENTRY_UNCANONIZES_12153715475418673041)],
        &[(0b01001, &ENTRY_UNCANONIZING_3397483964901532622)],
        &[(0b10010, &ENTRY_UNCANTONIZED_13456997538693547290)],
        &[(0b10010, &ENTRY_UNCANTONIZEDS_8748104113894653041)],
        &[(0b01001, &ENTRY_UNCANTONIZED_13456997538693547290)],
        &[(0b01001, &ENTRY_UNCANTONIZEDS_8748104113894653041)],
        &[(0b10010, &ENTRY_UNCAPITALIZED_15771287396524776391)],
        &[(0b10010, &ENTRY_UNCAPITALIZEDDER_11516986249977719685)],
        &[(0b10010, &ENTRY_UNCAPITALIZEDDEST_3372925540955398768)],
        &[(0b01001, &ENTRY_UNCAPITALIZED_15771287396524776391)],
        &[(0b01001, &ENTRY_UNCAPITALIZEDDER_11516986249977719685)],
        &[(0b01001, &ENTRY_UNCAPITALIZEDDEST_3372925540955398768)],
        &[(0b10010, &ENTRY_UNCARAMELIZED_14866858801643238047)],
        &[(0b01001, &ENTRY_UNCARAMELIZED_14866858801643238047)],
        &[(0b10010, &ENTRY_UNCATECHIZED_12604807844777819037)],
        &[(0b10010, &ENTRY_UNCATECHIZEDNESS_15422372585260862674)],
        &[(0b10010, &ENTRY_UNCATECHIZEDS_13859045064739112709)],
        &[(0b01001, &ENTRY_UNCATECHIZED_12604807844777819037)],
        &[(0b01001, &ENTRY_UNCATECHIZEDNESS_15422372585260862674)],
        &[(0b01001, &ENTRY_UNCATECHIZEDS_13859045064739112709)],
        &[(0b10010, &ENTRY_UNCATEGORIZED_12671663981711527617)],
        &[(0b10010, &ENTRY_UNCATEGORIZEDDER_15434842518722062137)],
        &[(0b10010, &ENTRY_UNCATEGORIZEDDEST_1757102059002802404)],
        &[(0b01001, &ENTRY_UNCATEGORIZED_12671663981711527617)],
        &[(0b01001, &ENTRY_UNCATEGORIZEDDER_15434842518722062137)],
        &[(0b01001, &ENTRY_UNCATEGORIZEDDEST_1757102059002802404)],
        &[(0b10010, &ENTRY_UNCATHOLICIZE_8425737943401304561)],
        &[(0b10010, &ENTRY_UNCATHOLICIZED_17722391494998523342)],
        &[(0b10010, &ENTRY_UNCATHOLICIZES_8958496403317373578)],
        &[(0b10010, &ENTRY_UNCATHOLICIZING_9453674520447775815)],
        &[(0b01001, &ENTRY_UNCATHOLICIZE_8425737943401304561)],
        &[(0b01001, &ENTRY_UNCATHOLICIZED_17722391494998523342)],
        &[(0b01001, &ENTRY_UNCATHOLICIZES_8958496403317373578)],
        &[(0b01001, &ENTRY_UNCATHOLICIZING_9453674520447775815)],
        &[(0b10010, &ENTRY_UNCAUTERIZED_13512404213504423195)],
        &[(0b10010, &ENTRY_UNCAUTERIZEDS_10677799308952420016)],
        &[(0b01001, &ENTRY_UNCAUTERIZED_13512404213504423195)],
        &[(0b01001, &ENTRY_UNCAUTERIZEDS_10677799308952420016)],
    ],
    range: 4..=13,
};

static VARS_UNB_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNB_CHILDREN),
    value: None,
};

pub static VARS_UNB_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aptise"),
        dictgen::InsensitiveStr::Ascii("aptised"),
        dictgen::InsensitiveStr::Ascii("aptises"),
        dictgen::InsensitiveStr::Ascii("aptising"),
        dictgen::InsensitiveStr::Ascii("aptize"),
        dictgen::InsensitiveStr::Ascii("aptized"),
        dictgen::InsensitiveStr::Ascii("aptizes"),
        dictgen::InsensitiveStr::Ascii("aptizing"),
        dictgen::InsensitiveStr::Ascii("arbarise"),
        dictgen::InsensitiveStr::Ascii("arbarised"),
        dictgen::InsensitiveStr::Ascii("arbarising"),
        dictgen::InsensitiveStr::Ascii("arbarize"),
        dictgen::InsensitiveStr::Ascii("arbarized"),
        dictgen::InsensitiveStr::Ascii("arbarizing"),
        dictgen::InsensitiveStr::Ascii("arricaded"),
        dictgen::InsensitiveStr::Ascii("arricadoed"),
        dictgen::InsensitiveStr::Ascii("astardised"),
        dictgen::InsensitiveStr::Ascii("astardisedder"),
        dictgen::InsensitiveStr::Ascii("astardiseddest"),
        dictgen::InsensitiveStr::Ascii("astardized"),
        dictgen::InsensitiveStr::Ascii("astardizedder"),
        dictgen::InsensitiveStr::Ascii("astardizeddest"),
        dictgen::InsensitiveStr::Ascii("rutalise"),
        dictgen::InsensitiveStr::Ascii("rutalised"),
        dictgen::InsensitiveStr::Ascii("rutalises"),
        dictgen::InsensitiveStr::Ascii("rutalising"),
        dictgen::InsensitiveStr::Ascii("rutalize"),
        dictgen::InsensitiveStr::Ascii("rutalized"),
        dictgen::InsensitiveStr::Ascii("rutalizes"),
        dictgen::InsensitiveStr::Ascii("rutalizing"),
        dictgen::InsensitiveStr::Ascii("rutise"),
        dictgen::InsensitiveStr::Ascii("rutised"),
        dictgen::InsensitiveStr::Ascii("rutises"),
        dictgen::InsensitiveStr::Ascii("rutising"),
        dictgen::InsensitiveStr::Ascii("rutize"),
        dictgen::InsensitiveStr::Ascii("rutized"),
        dictgen::InsensitiveStr::Ascii("rutizes"),
        dictgen::InsensitiveStr::Ascii("rutizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNBAPTIZE_18045749488616509181)],
        &[(0b10010, &ENTRY_UNBAPTIZED_2750609897609115804)],
        &[(0b10010, &ENTRY_UNBAPTIZES_5860001137786586819)],
        &[(0b10010, &ENTRY_UNBAPTIZING_369890182023136394)],
        &[(0b01001, &ENTRY_UNBAPTIZE_18045749488616509181)],
        &[(0b01001, &ENTRY_UNBAPTIZED_2750609897609115804)],
        &[(0b01001, &ENTRY_UNBAPTIZES_5860001137786586819)],
        &[(0b01001, &ENTRY_UNBAPTIZING_369890182023136394)],
        &[(0b10010, &ENTRY_UNBARBARIZE_85759814966596838)],
        &[(0b10010, &ENTRY_UNBARBARIZED_4163251566640502972)],
        &[(0b10010, &ENTRY_UNBARBARIZING_10525570028182827286)],
        &[(0b01001, &ENTRY_UNBARBARIZE_85759814966596838)],
        &[(0b01001, &ENTRY_UNBARBARIZED_4163251566640502972)],
        &[(0b01001, &ENTRY_UNBARBARIZING_10525570028182827286)],
        &[(0b00001, &ENTRY_UNBARRICADED_12195279117302305039)],
        &[(0b11010, &ENTRY_UNBARRICADED_12195279117302305039)],
        &[(0b10010, &ENTRY_UNBASTARDIZED_13342112361958904470)],
        &[(0b10010, &ENTRY_UNBASTARDIZEDDER_6714666111533384003)],
        &[(0b10010, &ENTRY_UNBASTARDIZEDDEST_5748524649962490826)],
        &[(0b01001, &ENTRY_UNBASTARDIZED_13342112361958904470)],
        &[(0b01001, &ENTRY_UNBASTARDIZEDDER_6714666111533384003)],
        &[(0b01001, &ENTRY_UNBASTARDIZEDDEST_5748524649962490826)],
        &[(0b10010, &ENTRY_UNBRUTALIZE_18223840863792260272)],
        &[(0b10010, &ENTRY_UNBRUTALIZED_6338937456842490293)],
        &[(0b10010, &ENTRY_UNBRUTALIZES_4127817782461372270)],
        &[(0b10010, &ENTRY_UNBRUTALIZING_12933117214333059837)],
        &[(0b01001, &ENTRY_UNBRUTALIZE_18223840863792260272)],
        &[(0b01001, &ENTRY_UNBRUTALIZED_6338937456842490293)],
        &[(0b01001, &ENTRY_UNBRUTALIZES_4127817782461372270)],
        &[(0b01001, &ENTRY_UNBRUTALIZING_12933117214333059837)],
        &[(0b10010, &ENTRY_UNBRUTIZE_10482956505266389513)],
        &[(0b10010, &ENTRY_UNBRUTIZED_18292720994739659985)],
        &[(0b10010, &ENTRY_UNBRUTIZES_12365008004715490849)],
        &[(0b10010, &ENTRY_UNBRUTIZING_8068018278771694293)],
        &[(0b01001, &ENTRY_UNBRUTIZE_10482956505266389513)],
        &[(0b01001, &ENTRY_UNBRUTIZED_18292720994739659985)],
        &[(0b01001, &ENTRY_UNBRUTIZES_12365008004715490849)],
        &[(0b01001, &ENTRY_UNBRUTIZING_8068018278771694293)],
    ],
    range: 6..=14,
};

static VARS_UNA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_UNA_CHILDREN),
    value: None,
};

static VARS_UNA_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    Some(&VARS_UNAC_NODE),
    None,
    None,
    None,
    Some(&VARS_UNAG_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_UNAL_NODE),
    Some(&VARS_UNAM_NODE),
    Some(&VARS_UNAN_NODE),
    None,
    Some(&VARS_UNAP_NODE),
    None,
    Some(&VARS_UNAR_NODE),
    None,
    None,
    Some(&VARS_UNAU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_UNAU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNAU_CHILDREN),
    value: None,
};

pub static VARS_UNAU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("thorise"),
        dictgen::InsensitiveStr::Ascii("thorised"),
        dictgen::InsensitiveStr::Ascii("thorisedder"),
        dictgen::InsensitiveStr::Ascii("thoriseddest"),
        dictgen::InsensitiveStr::Ascii("thorisedly"),
        dictgen::InsensitiveStr::Ascii("thorisedness"),
        dictgen::InsensitiveStr::Ascii("thorises"),
        dictgen::InsensitiveStr::Ascii("thorize"),
        dictgen::InsensitiveStr::Ascii("thorized"),
        dictgen::InsensitiveStr::Ascii("thorizedder"),
        dictgen::InsensitiveStr::Ascii("thorizeddest"),
        dictgen::InsensitiveStr::Ascii("thorizedly"),
        dictgen::InsensitiveStr::Ascii("thorizedness"),
        dictgen::InsensitiveStr::Ascii("thorizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNAUTHORIZE_17373059611637260636)],
        &[(0b10010, &ENTRY_UNAUTHORIZED_18330969128189680958)],
        &[(0b10010, &ENTRY_UNAUTHORIZEDDER_4146956705318297921)],
        &[(0b10010, &ENTRY_UNAUTHORIZEDDEST_5230199240119912096)],
        &[(0b10010, &ENTRY_UNAUTHORIZEDLY_1756944536540360350)],
        &[(0b10010, &ENTRY_UNAUTHORIZEDNESS_13848901931254124796)],
        &[(0b10010, &ENTRY_UNAUTHORIZES_15223481987545098919)],
        &[(0b01001, &ENTRY_UNAUTHORIZE_17373059611637260636)],
        &[(0b01001, &ENTRY_UNAUTHORIZED_18330969128189680958)],
        &[(0b01001, &ENTRY_UNAUTHORIZEDDER_4146956705318297921)],
        &[(0b01001, &ENTRY_UNAUTHORIZEDDEST_5230199240119912096)],
        &[(0b01001, &ENTRY_UNAUTHORIZEDLY_1756944536540360350)],
        &[(0b01001, &ENTRY_UNAUTHORIZEDNESS_13848901931254124796)],
        &[(0b01001, &ENTRY_UNAUTHORIZES_15223481987545098919)],
    ],
    range: 7..=12,
};

static VARS_UNAR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNAR_CHILDREN),
    value: None,
};

pub static VARS_UNAR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bored"),
        dictgen::InsensitiveStr::Ascii("boured"),
        dictgen::InsensitiveStr::Ascii("mored"),
        dictgen::InsensitiveStr::Ascii("moredder"),
        dictgen::InsensitiveStr::Ascii("moreddest"),
        dictgen::InsensitiveStr::Ascii("moured"),
        dictgen::InsensitiveStr::Ascii("mouredder"),
        dictgen::InsensitiveStr::Ascii("moureddest"),
    ],
    values: &[
        &[(0b00001, &ENTRY_UNARBORED_10962513521010356596)],
        &[(0b11010, &ENTRY_UNARBORED_10962513521010356596)],
        &[(0b00001, &ENTRY_UNARMORED_4540020611443646355)],
        &[(0b00001, &ENTRY_UNARMOREDDER_4175485372914136238)],
        &[(0b00001, &ENTRY_UNARMOREDDEST_3012270770178515043)],
        &[(0b11010, &ENTRY_UNARMORED_4540020611443646355)],
        &[(0b11010, &ENTRY_UNARMOREDDER_4175485372914136238)],
        &[(0b11010, &ENTRY_UNARMOREDDEST_3012270770178515043)],
    ],
    range: 5..=10,
};

static VARS_UNAP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNAP_CHILDREN),
    value: None,
};

pub static VARS_UNAP_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ologising"),
        dictgen::InsensitiveStr::Ascii("ologizing"),
        dictgen::InsensitiveStr::Ascii("ostatised"),
        dictgen::InsensitiveStr::Ascii("ostatiseds"),
        dictgen::InsensitiveStr::Ascii("ostatized"),
        dictgen::InsensitiveStr::Ascii("ostatizeds"),
        dictgen::InsensitiveStr::Ascii("petising"),
        dictgen::InsensitiveStr::Ascii("petisinger"),
        dictgen::InsensitiveStr::Ascii("petisingest"),
        dictgen::InsensitiveStr::Ascii("petisinglier"),
        dictgen::InsensitiveStr::Ascii("petisingliest"),
        dictgen::InsensitiveStr::Ascii("petisingly"),
        dictgen::InsensitiveStr::Ascii("petizing"),
        dictgen::InsensitiveStr::Ascii("petizinger"),
        dictgen::InsensitiveStr::Ascii("petizingest"),
        dictgen::InsensitiveStr::Ascii("petizinglier"),
        dictgen::InsensitiveStr::Ascii("petizingliest"),
        dictgen::InsensitiveStr::Ascii("petizingly"),
        dictgen::InsensitiveStr::Ascii("prised"),
        dictgen::InsensitiveStr::Ascii("prized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNAPOLOGIZING_8820499902965244314)],
        &[(0b01001, &ENTRY_UNAPOLOGIZING_8820499902965244314)],
        &[(0b10010, &ENTRY_UNAPOSTATIZED_8707752890756536689)],
        &[(0b10010, &ENTRY_UNAPOSTATIZEDS_14669408928414139662)],
        &[(0b01001, &ENTRY_UNAPOSTATIZED_8707752890756536689)],
        &[(0b01001, &ENTRY_UNAPOSTATIZEDS_14669408928414139662)],
        &[(0b10010, &ENTRY_UNAPPETIZING_12749343422231568734)],
        &[(0b10010, &ENTRY_UNAPPETIZINGER_11663943688244312711)],
        &[(0b10010, &ENTRY_UNAPPETIZINGEST_15811327206418622113)],
        &[(0b10010, &ENTRY_UNAPPETIZINGLIER_5194460014263105886)],
        &[(0b10010, &ENTRY_UNAPPETIZINGLIEST_13095442457868536397)],
        &[(0b10010, &ENTRY_UNAPPETIZINGLY_4396083271756728101)],
        &[(0b01001, &ENTRY_UNAPPETIZING_12749343422231568734)],
        &[(0b01001, &ENTRY_UNAPPETIZINGER_11663943688244312711)],
        &[(0b01001, &ENTRY_UNAPPETIZINGEST_15811327206418622113)],
        &[(0b01001, &ENTRY_UNAPPETIZINGLIER_5194460014263105886)],
        &[(0b01001, &ENTRY_UNAPPETIZINGLIEST_13095442457868536397)],
        &[(0b01001, &ENTRY_UNAPPETIZINGLY_4396083271756728101)],
        &[(0b10010, &ENTRY_UNAPPRIZED_6119477476012909356)],
        &[(0b01001, &ENTRY_UNAPPRIZED_6119477476012909356)],
    ],
    range: 6..=13,
};

static VARS_UNAN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNAN_CHILDREN),
    value: None,
};

pub static VARS_UNAN_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aemic"),
        dictgen::InsensitiveStr::Ascii("alysable"),
        dictgen::InsensitiveStr::Ascii("alysed"),
        dictgen::InsensitiveStr::Ascii("alyzable"),
        dictgen::InsensitiveStr::Ascii("alyzed"),
        dictgen::InsensitiveStr::Ascii("atomisable"),
        dictgen::InsensitiveStr::Ascii("atomised"),
        dictgen::InsensitiveStr::Ascii("atomizable"),
        dictgen::InsensitiveStr::Ascii("atomized"),
        dictgen::InsensitiveStr::Ascii("emic"),
        dictgen::InsensitiveStr::Ascii("imalised"),
        dictgen::InsensitiveStr::Ascii("imaliseds"),
        dictgen::InsensitiveStr::Ascii("imalized"),
        dictgen::InsensitiveStr::Ascii("imalizeds"),
        dictgen::InsensitiveStr::Ascii("tagonisable"),
        dictgen::InsensitiveStr::Ascii("tagonisabler"),
        dictgen::InsensitiveStr::Ascii("tagonisables"),
        dictgen::InsensitiveStr::Ascii("tagonisablest"),
        dictgen::InsensitiveStr::Ascii("tagonised"),
        dictgen::InsensitiveStr::Ascii("tagonisedder"),
        dictgen::InsensitiveStr::Ascii("tagoniseddest"),
        dictgen::InsensitiveStr::Ascii("tagonising"),
        dictgen::InsensitiveStr::Ascii("tagonisinger"),
        dictgen::InsensitiveStr::Ascii("tagonisingest"),
        dictgen::InsensitiveStr::Ascii("tagonizable"),
        dictgen::InsensitiveStr::Ascii("tagonizabler"),
        dictgen::InsensitiveStr::Ascii("tagonizables"),
        dictgen::InsensitiveStr::Ascii("tagonizablest"),
        dictgen::InsensitiveStr::Ascii("tagonized"),
        dictgen::InsensitiveStr::Ascii("tagonizedder"),
        dictgen::InsensitiveStr::Ascii("tagonizeddest"),
        dictgen::InsensitiveStr::Ascii("tagonizing"),
        dictgen::InsensitiveStr::Ascii("tagonizinger"),
        dictgen::InsensitiveStr::Ascii("tagonizingest"),
    ],
    values: &[
        &[(0b11010, &ENTRY_UNANEMIC_6804040153460031597)],
        &[(0b10010, &ENTRY_UNANALYZABLE_10015139257021178435)],
        &[(0b10010, &ENTRY_UNANALYZED_16500188544214906359)],
        &[(0b01001, &ENTRY_UNANALYZABLE_10015139257021178435)],
        &[(0b01001, &ENTRY_UNANALYZED_16500188544214906359)],
        &[(0b10010, &ENTRY_UNANATOMIZABLE_12621927696529831665)],
        &[(0b10010, &ENTRY_UNANATOMIZED_6061766559393631360)],
        &[(0b01001, &ENTRY_UNANATOMIZABLE_12621927696529831665)],
        &[(0b01001, &ENTRY_UNANATOMIZED_6061766559393631360)],
        &[(0b00001, &ENTRY_UNANEMIC_6804040153460031597)],
        &[(0b10010, &ENTRY_UNANIMALIZED_2409683454989613456)],
        &[(0b10010, &ENTRY_UNANIMALIZEDS_12083863725694904084)],
        &[(0b01001, &ENTRY_UNANIMALIZED_2409683454989613456)],
        &[(0b01001, &ENTRY_UNANIMALIZEDS_12083863725694904084)],
        &[(0b10010, &ENTRY_UNANTAGONIZABLE_8940938838594676762)],
        &[(0b10010, &ENTRY_UNANTAGONIZABLER_341535602186309075)],
        &[(0b10010, &ENTRY_UNANTAGONIZABLES_2731043692553771550)],
        &[(0b10010, &ENTRY_UNANTAGONIZABLEST_17345953185101673573)],
        &[(0b10010, &ENTRY_UNANTAGONIZED_3298227429647689925)],
        &[(0b10010, &ENTRY_UNANTAGONIZEDDER_17407737658502114220)],
        &[(0b10010, &ENTRY_UNANTAGONIZEDDEST_15019402780215712074)],
        &[(0b10010, &ENTRY_UNANTAGONIZING_3465462232208147407)],
        &[(0b10010, &ENTRY_UNANTAGONIZINGER_15671658988108179272)],
        &[(0b10010, &ENTRY_UNANTAGONIZINGEST_5785945012122373004)],
        &[(0b01001, &ENTRY_UNANTAGONIZABLE_8940938838594676762)],
        &[(0b01001, &ENTRY_UNANTAGONIZABLER_341535602186309075)],
        &[(0b01001, &ENTRY_UNANTAGONIZABLES_2731043692553771550)],
        &[(0b01001, &ENTRY_UNANTAGONIZABLEST_17345953185101673573)],
        &[(0b01001, &ENTRY_UNANTAGONIZED_3298227429647689925)],
        &[(0b01001, &ENTRY_UNANTAGONIZEDDER_17407737658502114220)],
        &[(0b01001, &ENTRY_UNANTAGONIZEDDEST_15019402780215712074)],
        &[(0b01001, &ENTRY_UNANTAGONIZING_3465462232208147407)],
        &[(0b01001, &ENTRY_UNANTAGONIZINGER_15671658988108179272)],
        &[(0b01001, &ENTRY_UNANTAGONIZINGEST_5785945012122373004)],
    ],
    range: 4..=13,
};

static VARS_UNAM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNAM_CHILDREN),
    value: None,
};

pub static VARS_UNAM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ortisation"),
        dictgen::InsensitiveStr::Ascii("ortisations"),
        dictgen::InsensitiveStr::Ascii("ortised"),
        dictgen::InsensitiveStr::Ascii("ortization"),
        dictgen::InsensitiveStr::Ascii("ortizations"),
        dictgen::InsensitiveStr::Ascii("ortized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNAMORTIZATION_12146076887735696880)],
        &[(0b10010, &ENTRY_UNAMORTIZATIONS_11801391438115116167)],
        &[(0b10010, &ENTRY_UNAMORTIZED_13451896776472967546)],
        &[(0b01001, &ENTRY_UNAMORTIZATION_12146076887735696880)],
        &[(0b01001, &ENTRY_UNAMORTIZATIONS_11801391438115116167)],
        &[(0b01001, &ENTRY_UNAMORTIZED_13451896776472967546)],
    ],
    range: 7..=11,
};

static VARS_UNAL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNAL_CHILDREN),
    value: None,
};

pub static VARS_UNAL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("coholised"),
        dictgen::InsensitiveStr::Ascii("coholisedder"),
        dictgen::InsensitiveStr::Ascii("coholiseddest"),
        dictgen::InsensitiveStr::Ascii("coholiseds"),
        dictgen::InsensitiveStr::Ascii("coholized"),
        dictgen::InsensitiveStr::Ascii("coholizedder"),
        dictgen::InsensitiveStr::Ascii("coholizeddest"),
        dictgen::InsensitiveStr::Ascii("coholizeds"),
        dictgen::InsensitiveStr::Ascii("phabetised"),
        dictgen::InsensitiveStr::Ascii("phabetized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNALCOHOLIZED_12462545574552694750)],
        &[(0b10010, &ENTRY_UNALCOHOLIZEDDER_7254338354970976974)],
        &[(0b10010, &ENTRY_UNALCOHOLIZEDDEST_3929868538999714538)],
        &[(0b10010, &ENTRY_UNALCOHOLIZEDS_3779587450961636557)],
        &[(0b01001, &ENTRY_UNALCOHOLIZED_12462545574552694750)],
        &[(0b01001, &ENTRY_UNALCOHOLIZEDDER_7254338354970976974)],
        &[(0b01001, &ENTRY_UNALCOHOLIZEDDEST_3929868538999714538)],
        &[(0b01001, &ENTRY_UNALCOHOLIZEDS_3779587450961636557)],
        &[(0b10010, &ENTRY_UNALPHABETIZED_785154054192050580)],
        &[(0b01001, &ENTRY_UNALPHABETIZED_785154054192050580)],
    ],
    range: 9..=13,
};

static VARS_UNAG_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNAG_CHILDREN),
    value: None,
};

pub static VARS_UNAG_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("onise"),
        dictgen::InsensitiveStr::Ascii("onize"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNAGONIZE_6084501682979547918)],
        &[(0b01001, &ENTRY_UNAGONIZE_6084501682979547918)],
    ],
    range: 5..=5,
};

static VARS_UNAC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UNAC_CHILDREN),
    value: None,
};

pub static VARS_UNAC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("climatised"),
        dictgen::InsensitiveStr::Ascii("climatized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_UNACCLIMATIZED_1969571864517774602)],
        &[(0b01001, &ENTRY_UNACCLIMATIZED_1969571864517774602)],
    ],
    range: 10..=10,
};

static VARS_UL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_UL_CHILDREN),
    value: None,
};

pub static VARS_UL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("tracentraliser"),
        dictgen::InsensitiveStr::Ascii("tracentralisers"),
        dictgen::InsensitiveStr::Ascii("tracentralizer"),
        dictgen::InsensitiveStr::Ascii("tracentralizers"),
        dictgen::InsensitiveStr::Ascii("trahonorable"),
        dictgen::InsensitiveStr::Ascii("trahonorables"),
        dictgen::InsensitiveStr::Ascii("trahonourable"),
        dictgen::InsensitiveStr::Ascii("trahonourables"),
        dictgen::InsensitiveStr::Ascii("traspecialisation"),
        dictgen::InsensitiveStr::Ascii("traspecialisations"),
        dictgen::InsensitiveStr::Ascii("traspecialization"),
        dictgen::InsensitiveStr::Ascii("traspecializations"),
        dictgen::InsensitiveStr::Ascii("trastandardisation"),
        dictgen::InsensitiveStr::Ascii("trastandardisations"),
        dictgen::InsensitiveStr::Ascii("trastandardization"),
        dictgen::InsensitiveStr::Ascii("trastandardizations"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ULTRACENTRALIZER_1386087884281857470)],
        &[(0b10010, &ENTRY_ULTRACENTRALIZERS_15801856694895216516)],
        &[(0b01001, &ENTRY_ULTRACENTRALIZER_1386087884281857470)],
        &[(0b01001, &ENTRY_ULTRACENTRALIZERS_15801856694895216516)],
        &[(0b00001, &ENTRY_ULTRAHONORABLE_17802324312727593194)],
        &[(0b00001, &ENTRY_ULTRAHONORABLES_9342789915681610564)],
        &[(0b11010, &ENTRY_ULTRAHONORABLE_17802324312727593194)],
        &[(0b11010, &ENTRY_ULTRAHONORABLES_9342789915681610564)],
        &[(0b10010, &ENTRY_ULTRASPECIALIZATION_14780888503862218576)],
        &[(0b10010, &ENTRY_ULTRASPECIALIZATIONS_14936216708962453732)],
        &[(0b01001, &ENTRY_ULTRASPECIALIZATION_14780888503862218576)],
        &[(0b01001, &ENTRY_ULTRASPECIALIZATIONS_14936216708962453732)],
        &[(0b10010, &ENTRY_ULTRASTANDARDIZATION_7616606161431137542)],
        &[(0b10010, &ENTRY_ULTRASTANDARDIZATIONS_12958573872619861416)],
        &[(0b01001, &ENTRY_ULTRASTANDARDIZATION_7616606161431137542)],
        &[(0b01001, &ENTRY_ULTRASTANDARDIZATIONS_12958573872619861416)],
    ],
    range: 12..=19,
};

static VARS_T_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_T_CHILDREN),
    value: None,
};

static VARS_T_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_TA_NODE),
    None,
    None,
    None,
    Some(&VARS_TE_NODE),
    None,
    None,
    Some(&VARS_TH_NODE),
    Some(&VARS_TI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_TO_NODE),
    None,
    None,
    Some(&VARS_TR_NODE),
    Some(&VARS_TS_NODE),
    None,
    Some(&VARS_TU_NODE),
    None,
    Some(&VARS_TW_NODE),
    None,
    Some(&VARS_TY_NODE),
    Some(&VARS_TZ_NODE),
];

static VARS_TZ_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TZ_CHILDREN),
    value: None,
};

pub static VARS_TZ_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ar"),
        dictgen::InsensitiveStr::Ascii("ars"),
    ],
    values: &[
        &[(0b10011, &ENTRY_CZAR_11030798322432903782)],
        &[(0b10011, &ENTRY_CZARS_6668028309318935455)],
    ],
    range: 2..=3,
};

static VARS_TY_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TY_CHILDREN),
    value: None,
};

pub static VARS_TY_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lerise"),
        dictgen::InsensitiveStr::Ascii("lerises"),
        dictgen::InsensitiveStr::Ascii("lerize"),
        dictgen::InsensitiveStr::Ascii("lerizes"),
        dictgen::InsensitiveStr::Ascii("phaemia"),
        dictgen::InsensitiveStr::Ascii("phemia"),
        dictgen::InsensitiveStr::Ascii("phlenteritis"),
        dictgen::InsensitiveStr::Ascii("phloenteritis"),
        dictgen::InsensitiveStr::Ascii("phoaemia"),
        dictgen::InsensitiveStr::Ascii("phoemia"),
        dictgen::InsensitiveStr::Ascii("rannise"),
        dictgen::InsensitiveStr::Ascii("rannised"),
        dictgen::InsensitiveStr::Ascii("ranniser"),
        dictgen::InsensitiveStr::Ascii("rannisers"),
        dictgen::InsensitiveStr::Ascii("rannises"),
        dictgen::InsensitiveStr::Ascii("rannising"),
        dictgen::InsensitiveStr::Ascii("rannisinglier"),
        dictgen::InsensitiveStr::Ascii("rannisingliest"),
        dictgen::InsensitiveStr::Ascii("rannisingly"),
        dictgen::InsensitiveStr::Ascii("rannisings"),
        dictgen::InsensitiveStr::Ascii("rannize"),
        dictgen::InsensitiveStr::Ascii("rannized"),
        dictgen::InsensitiveStr::Ascii("rannizer"),
        dictgen::InsensitiveStr::Ascii("rannizers"),
        dictgen::InsensitiveStr::Ascii("rannizes"),
        dictgen::InsensitiveStr::Ascii("rannizing"),
        dictgen::InsensitiveStr::Ascii("rannizinglier"),
        dictgen::InsensitiveStr::Ascii("rannizingliest"),
        dictgen::InsensitiveStr::Ascii("rannizingly"),
        dictgen::InsensitiveStr::Ascii("rannizings"),
        dictgen::InsensitiveStr::Ascii("re"),
        dictgen::InsensitiveStr::Ascii("reo"),
        dictgen::InsensitiveStr::Ascii("reos"),
        dictgen::InsensitiveStr::Ascii("res"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TYLERIZE_6772047772391841205)],
        &[(0b10010, &ENTRY_TYLERIZES_3930431350093885314)],
        &[(0b01001, &ENTRY_TYLERIZE_6772047772391841205)],
        &[(0b01001, &ENTRY_TYLERIZES_3930431350093885314)],
        &[(0b11010, &ENTRY_TYPHEMIA_3949405273592839759)],
        &[
            (0b00001, &ENTRY_TYPHEMIA_3949405273592839759),
            (0b00001, &ENTRY_TYPHEMIA_436328357437921093),
        ],
        &[(0b00001, &ENTRY_TYPHLENTERITIS_16701047769348734014)],
        &[(0b11010, &ENTRY_TYPHLENTERITIS_16701047769348734014)],
        &[(0b11010, &ENTRY_TYPHOEMIA_16341888230675161250)],
        &[
            (0b11010, &ENTRY_TYPHEMIA_436328357437921093),
            (0b00001, &ENTRY_TYPHOEMIA_16341888230675161250),
        ],
        &[(0b10010, &ENTRY_TYRANNIZE_402218976726854223)],
        &[(0b10010, &ENTRY_TYRANNIZED_1941892499943366434)],
        &[(0b10010, &ENTRY_TYRANNIZER_1371535188483909389)],
        &[(0b10010, &ENTRY_TYRANNIZERS_13060284352391993246)],
        &[(0b10010, &ENTRY_TYRANNIZES_10925886797003891936)],
        &[(0b10010, &ENTRY_TYRANNIZING_18363984835873871108)],
        &[(0b10010, &ENTRY_TYRANNIZINGLIER_7411912687837897273)],
        &[(0b10010, &ENTRY_TYRANNIZINGLIEST_13299239458699844336)],
        &[(0b10010, &ENTRY_TYRANNIZINGLY_387905432645898165)],
        &[(0b10010, &ENTRY_TYRANNIZINGS_8912279495006406317)],
        &[(0b01001, &ENTRY_TYRANNIZE_402218976726854223)],
        &[(0b01001, &ENTRY_TYRANNIZED_1941892499943366434)],
        &[(0b01001, &ENTRY_TYRANNIZER_1371535188483909389)],
        &[(0b01001, &ENTRY_TYRANNIZERS_13060284352391993246)],
        &[(0b01001, &ENTRY_TYRANNIZES_10925886797003891936)],
        &[(0b01001, &ENTRY_TYRANNIZING_18363984835873871108)],
        &[(0b01001, &ENTRY_TYRANNIZINGLIER_7411912687837897273)],
        &[(0b01001, &ENTRY_TYRANNIZINGLIEST_13299239458699844336)],
        &[(0b01001, &ENTRY_TYRANNIZINGLY_387905432645898165)],
        &[(0b01001, &ENTRY_TYRANNIZINGS_8912279495006406317)],
        &[(0b10010, &ENTRY_TIRE_17853768187298953050)],
        &[(0b00001, &ENTRY_TYRO_1396628122702945602)],
        &[(0b00001, &ENTRY_TYROS_4063138644213636346)],
        &[(0b10010, &ENTRY_TIRES_13233982026064511360)],
    ],
    range: 2..=14,
};

static VARS_TW_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TW_CHILDREN),
    value: None,
};

pub static VARS_TW_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ier"),
        dictgen::InsensitiveStr::Ascii("iers"),
        dictgen::InsensitiveStr::Ascii("ire"),
        dictgen::InsensitiveStr::Ascii("ires"),
    ],
    values: &[
        &[(0b00001, &ENTRY_TWIER_17943274413772224375)],
        &[(0b00001, &ENTRY_TWIERS_466316859651799693)],
        &[(0b11010, &ENTRY_TWIER_17943274413772224375)],
        &[(0b11010, &ENTRY_TWIERS_466316859651799693)],
    ],
    range: 3..=4,
};

static VARS_TU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_TU_CHILDREN),
    value: None,
};

static VARS_TU_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_TUB_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_TUL_NODE),
    Some(&VARS_TUM_NODE),
    Some(&VARS_TUN_NODE),
    None,
    None,
    None,
    Some(&VARS_TUR_NODE),
    Some(&VARS_TUS_NODE),
    Some(&VARS_TUT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_TUT_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TUT_CHILDREN),
    value: None,
};

pub static VARS_TUT_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("elae"),
        dictgen::InsensitiveStr::Ascii("ele"),
        dictgen::InsensitiveStr::Ascii("orisation"),
        dictgen::InsensitiveStr::Ascii("orisations"),
        dictgen::InsensitiveStr::Ascii("orise"),
        dictgen::InsensitiveStr::Ascii("orised"),
        dictgen::InsensitiveStr::Ascii("orises"),
        dictgen::InsensitiveStr::Ascii("orising"),
        dictgen::InsensitiveStr::Ascii("orization"),
        dictgen::InsensitiveStr::Ascii("orizations"),
        dictgen::InsensitiveStr::Ascii("orize"),
        dictgen::InsensitiveStr::Ascii("orized"),
        dictgen::InsensitiveStr::Ascii("orizes"),
        dictgen::InsensitiveStr::Ascii("orizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TUTELE_16207284368064157603)],
        &[(0b00001, &ENTRY_TUTELE_16207284368064157603)],
        &[(0b10010, &ENTRY_TUTORIZATION_7186477482613526154)],
        &[(0b10010, &ENTRY_TUTORIZATIONS_8014516646889352337)],
        &[(0b10010, &ENTRY_TUTORIZE_5415313587641112365)],
        &[(0b10010, &ENTRY_TUTORIZED_14661527617907051055)],
        &[(0b10010, &ENTRY_TUTORIZES_5000989116733816697)],
        &[(0b10010, &ENTRY_TUTORIZING_17098833328892189609)],
        &[(0b01001, &ENTRY_TUTORIZATION_7186477482613526154)],
        &[(0b01001, &ENTRY_TUTORIZATIONS_8014516646889352337)],
        &[(0b01001, &ENTRY_TUTORIZE_5415313587641112365)],
        &[(0b01001, &ENTRY_TUTORIZED_14661527617907051055)],
        &[(0b01001, &ENTRY_TUTORIZES_5000989116733816697)],
        &[(0b01001, &ENTRY_TUTORIZING_17098833328892189609)],
    ],
    range: 3..=10,
};

static VARS_TUS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TUS_CHILDREN),
    value: None,
};

pub static VARS_TUS_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("canise"),
        dictgen::InsensitiveStr::Ascii("canises"),
        dictgen::InsensitiveStr::Ascii("canize"),
        dictgen::InsensitiveStr::Ascii("canizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TUSCANIZE_7918803889059096084)],
        &[(0b10010, &ENTRY_TUSCANIZES_9646687590900186948)],
        &[(0b01001, &ENTRY_TUSCANIZE_7918803889059096084)],
        &[(0b01001, &ENTRY_TUSCANIZES_9646687590900186948)],
    ],
    range: 6..=7,
};

static VARS_TUR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TUR_CHILDREN),
    value: None,
};

pub static VARS_TUR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("dinae"),
        dictgen::InsensitiveStr::Ascii("dine"),
        dictgen::InsensitiveStr::Ascii("kicise"),
        dictgen::InsensitiveStr::Ascii("kicised"),
        dictgen::InsensitiveStr::Ascii("kicises"),
        dictgen::InsensitiveStr::Ascii("kicising"),
        dictgen::InsensitiveStr::Ascii("kicize"),
        dictgen::InsensitiveStr::Ascii("kicized"),
        dictgen::InsensitiveStr::Ascii("kicizes"),
        dictgen::InsensitiveStr::Ascii("kicizing"),
        dictgen::InsensitiveStr::Ascii("kise"),
        dictgen::InsensitiveStr::Ascii("kises"),
        dictgen::InsensitiveStr::Ascii("kize"),
        dictgen::InsensitiveStr::Ascii("kizes"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TURDINE_8495216946259189004)],
        &[(0b00001, &ENTRY_TURDINE_8495216946259189004)],
        &[(0b10010, &ENTRY_TURKICIZE_12952219324449295324)],
        &[(0b10010, &ENTRY_TURKICIZED_16551093534484123400)],
        &[(0b10010, &ENTRY_TURKICIZES_4184526349077657623)],
        &[(0b10010, &ENTRY_TURKICIZING_11437686965760445130)],
        &[(0b01001, &ENTRY_TURKICIZE_12952219324449295324)],
        &[(0b01001, &ENTRY_TURKICIZED_16551093534484123400)],
        &[(0b01001, &ENTRY_TURKICIZES_4184526349077657623)],
        &[(0b01001, &ENTRY_TURKICIZING_11437686965760445130)],
        &[(0b10010, &ENTRY_TURKIZE_8515585059262136896)],
        &[(0b10010, &ENTRY_TURKIZES_3728749434026795951)],
        &[(0b01001, &ENTRY_TURKIZE_8515585059262136896)],
        &[(0b01001, &ENTRY_TURKIZES_3728749434026795951)],
    ],
    range: 4..=8,
};

static VARS_TUN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TUN_CHILDREN),
    value: None,
};

pub static VARS_TUN_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("neled"),
        dictgen::InsensitiveStr::Ascii("neler"),
        dictgen::InsensitiveStr::Ascii("nelers"),
        dictgen::InsensitiveStr::Ascii("neling"),
        dictgen::InsensitiveStr::Ascii("nelings"),
        dictgen::InsensitiveStr::Ascii("nelled"),
        dictgen::InsensitiveStr::Ascii("neller"),
        dictgen::InsensitiveStr::Ascii("nellers"),
        dictgen::InsensitiveStr::Ascii("nelling"),
        dictgen::InsensitiveStr::Ascii("nellings"),
    ],
    values: &[
        &[(0b00001, &ENTRY_TUNNELED_886730683006426004)],
        &[(0b00001, &ENTRY_TUNNELER_6084737649073030916)],
        &[(0b00001, &ENTRY_TUNNELERS_3199139734449894765)],
        &[(0b00001, &ENTRY_TUNNELING_155358793735796240)],
        &[(0b00001, &ENTRY_TUNNELINGS_14762533053987563131)],
        &[(0b11010, &ENTRY_TUNNELED_886730683006426004)],
        &[(0b11010, &ENTRY_TUNNELER_6084737649073030916)],
        &[(0b11010, &ENTRY_TUNNELERS_3199139734449894765)],
        &[(0b11010, &ENTRY_TUNNELING_155358793735796240)],
        &[(0b11010, &ENTRY_TUNNELINGS_14762533053987563131)],
    ],
    range: 5..=8,
};

static VARS_TUM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TUM_CHILDREN),
    value: None,
};

pub static VARS_TUM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("or"),
        dictgen::InsensitiveStr::Ascii("ored"),
        dictgen::InsensitiveStr::Ascii("ors"),
        dictgen::InsensitiveStr::Ascii("our"),
        dictgen::InsensitiveStr::Ascii("oured"),
        dictgen::InsensitiveStr::Ascii("ours"),
    ],
    values: &[
        &[(0b11001, &ENTRY_TUMOR_15198008231736842579)],
        &[(0b00001, &ENTRY_TUMORED_9530760269255205454)],
        &[(0b11001, &ENTRY_TUMORS_4506585513408357434)],
        &[(0b11010, &ENTRY_TUMOR_15198008231736842579)],
        &[(0b11010, &ENTRY_TUMORED_9530760269255205454)],
        &[(0b11010, &ENTRY_TUMORS_4506585513408357434)],
    ],
    range: 2..=5,
};

static VARS_TUL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TUL_CHILDREN),
    value: None,
};

pub static VARS_TUL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("araemia"),
        dictgen::InsensitiveStr::Ascii("araemias"),
        dictgen::InsensitiveStr::Ascii("araemic"),
        dictgen::InsensitiveStr::Ascii("aremia"),
        dictgen::InsensitiveStr::Ascii("aremias"),
        dictgen::InsensitiveStr::Ascii("aremic"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TULAREMIA_111069766982320509)],
        &[(0b11010, &ENTRY_TULAREMIAS_14187869169219863030)],
        &[(0b11010, &ENTRY_TULAREMIC_7746109038589986442)],
        &[(0b01001, &ENTRY_TULAREMIA_111069766982320509)],
        &[(0b01001, &ENTRY_TULAREMIAS_14187869169219863030)],
        &[(0b00001, &ENTRY_TULAREMIC_7746109038589986442)],
    ],
    range: 6..=8,
};

static VARS_TUB_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TUB_CHILDREN),
    value: None,
};

pub static VARS_TUB_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ercularisation"),
        dictgen::InsensitiveStr::Ascii("ercularise"),
        dictgen::InsensitiveStr::Ascii("ercularised"),
        dictgen::InsensitiveStr::Ascii("ercularising"),
        dictgen::InsensitiveStr::Ascii("ercularization"),
        dictgen::InsensitiveStr::Ascii("ercularize"),
        dictgen::InsensitiveStr::Ascii("ercularized"),
        dictgen::InsensitiveStr::Ascii("ercularizing"),
        dictgen::InsensitiveStr::Ascii("erculinisation"),
        dictgen::InsensitiveStr::Ascii("erculinisations"),
        dictgen::InsensitiveStr::Ascii("erculinise"),
        dictgen::InsensitiveStr::Ascii("erculinised"),
        dictgen::InsensitiveStr::Ascii("erculinises"),
        dictgen::InsensitiveStr::Ascii("erculinising"),
        dictgen::InsensitiveStr::Ascii("erculinization"),
        dictgen::InsensitiveStr::Ascii("erculinizations"),
        dictgen::InsensitiveStr::Ascii("erculinize"),
        dictgen::InsensitiveStr::Ascii("erculinized"),
        dictgen::InsensitiveStr::Ascii("erculinizes"),
        dictgen::InsensitiveStr::Ascii("erculinizing"),
        dictgen::InsensitiveStr::Ascii("erculisation"),
        dictgen::InsensitiveStr::Ascii("erculisations"),
        dictgen::InsensitiveStr::Ascii("erculise"),
        dictgen::InsensitiveStr::Ascii("erculised"),
        dictgen::InsensitiveStr::Ascii("erculises"),
        dictgen::InsensitiveStr::Ascii("erculising"),
        dictgen::InsensitiveStr::Ascii("erculization"),
        dictgen::InsensitiveStr::Ascii("erculizations"),
        dictgen::InsensitiveStr::Ascii("erculize"),
        dictgen::InsensitiveStr::Ascii("erculized"),
        dictgen::InsensitiveStr::Ascii("erculizes"),
        dictgen::InsensitiveStr::Ascii("erculizing"),
        dictgen::InsensitiveStr::Ascii("erisation"),
        dictgen::InsensitiveStr::Ascii("erisations"),
        dictgen::InsensitiveStr::Ascii("erise"),
        dictgen::InsensitiveStr::Ascii("erises"),
        dictgen::InsensitiveStr::Ascii("erization"),
        dictgen::InsensitiveStr::Ascii("erizations"),
        dictgen::InsensitiveStr::Ascii("erize"),
        dictgen::InsensitiveStr::Ascii("erizes"),
        dictgen::InsensitiveStr::Ascii("ulisation"),
        dictgen::InsensitiveStr::Ascii("ulisations"),
        dictgen::InsensitiveStr::Ascii("ulization"),
        dictgen::InsensitiveStr::Ascii("ulizations"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TUBERCULARIZATION_15542666046560010756)],
        &[(0b10010, &ENTRY_TUBERCULARIZE_2157217058313355699)],
        &[(0b10010, &ENTRY_TUBERCULARIZED_12286997214844537953)],
        &[(0b10010, &ENTRY_TUBERCULARIZING_3929944679702207874)],
        &[(0b01001, &ENTRY_TUBERCULARIZATION_15542666046560010756)],
        &[(0b01001, &ENTRY_TUBERCULARIZE_2157217058313355699)],
        &[(0b01001, &ENTRY_TUBERCULARIZED_12286997214844537953)],
        &[(0b01001, &ENTRY_TUBERCULARIZING_3929944679702207874)],
        &[(0b10010, &ENTRY_TUBERCULINIZATION_11797962637301639092)],
        &[(0b10010, &ENTRY_TUBERCULINIZATIONS_10141244678936649951)],
        &[(0b10010, &ENTRY_TUBERCULINIZE_15333531702912733903)],
        &[(0b10010, &ENTRY_TUBERCULINIZED_10816352629411587290)],
        &[(0b10010, &ENTRY_TUBERCULINIZES_13921009254488053820)],
        &[(0b10010, &ENTRY_TUBERCULINIZING_8221476597985863464)],
        &[(0b01001, &ENTRY_TUBERCULINIZATION_11797962637301639092)],
        &[(0b01001, &ENTRY_TUBERCULINIZATIONS_10141244678936649951)],
        &[(0b01001, &ENTRY_TUBERCULINIZE_15333531702912733903)],
        &[(0b01001, &ENTRY_TUBERCULINIZED_10816352629411587290)],
        &[(0b01001, &ENTRY_TUBERCULINIZES_13921009254488053820)],
        &[(0b01001, &ENTRY_TUBERCULINIZING_8221476597985863464)],
        &[(0b10010, &ENTRY_TUBERCULIZATION_12296149150456268539)],
        &[(0b10010, &ENTRY_TUBERCULIZATIONS_14781828629520022038)],
        &[(0b10010, &ENTRY_TUBERCULIZE_3450991821098593135)],
        &[(0b10010, &ENTRY_TUBERCULIZED_10329102836270681912)],
        &[(0b10010, &ENTRY_TUBERCULIZES_1677879746778356818)],
        &[(0b10010, &ENTRY_TUBERCULIZING_2357271713174376242)],
        &[(0b01001, &ENTRY_TUBERCULIZATION_12296149150456268539)],
        &[(0b01001, &ENTRY_TUBERCULIZATIONS_14781828629520022038)],
        &[(0b01001, &ENTRY_TUBERCULIZE_3450991821098593135)],
        &[(0b01001, &ENTRY_TUBERCULIZED_10329102836270681912)],
        &[(0b01001, &ENTRY_TUBERCULIZES_1677879746778356818)],
        &[(0b01001, &ENTRY_TUBERCULIZING_2357271713174376242)],
        &[(0b10010, &ENTRY_TUBERIZATION_10556809563684052487)],
        &[(0b10010, &ENTRY_TUBERIZATIONS_215616275751404145)],
        &[(0b10010, &ENTRY_TUBERIZE_865480950163325912)],
        &[(0b10010, &ENTRY_TUBERIZES_15708878588683938276)],
        &[(0b01001, &ENTRY_TUBERIZATION_10556809563684052487)],
        &[(0b01001, &ENTRY_TUBERIZATIONS_215616275751404145)],
        &[(0b01001, &ENTRY_TUBERIZE_865480950163325912)],
        &[(0b01001, &ENTRY_TUBERIZES_15708878588683938276)],
        &[(0b10010, &ENTRY_TUBULIZATION_12430780901128768431)],
        &[(0b10010, &ENTRY_TUBULIZATIONS_10015790438190867364)],
        &[(0b01001, &ENTRY_TUBULIZATION_12430780901128768431)],
        &[(0b01001, &ENTRY_TUBULIZATIONS_10015790438190867364)],
    ],
    range: 5..=15,
};

static VARS_TS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TS_CHILDREN),
    value: None,
};

pub static VARS_TS_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("oris"),
        dictgen::InsensitiveStr::Ascii("ouris"),
    ],
    values: &[
        &[(0b00001, &ENTRY_TSORIS_14425139026522279430)],
        &[(0b11010, &ENTRY_TSORIS_14425139026522279430)],
    ],
    range: 4..=5,
};

static VARS_TR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_TR_CHILDREN),
    value: None,
};

static VARS_TR_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_TRA_NODE),
    None,
    None,
    None,
    Some(&VARS_TRE_NODE),
    None,
    None,
    None,
    Some(&VARS_TRI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_TRO_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_TRU_NODE),
    None,
    None,
    None,
    Some(&VARS_TRY_NODE),
    None,
];

static VARS_TRY_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRY_CHILDREN),
    value: None,
};

pub static VARS_TRY_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("psinise"),
        dictgen::InsensitiveStr::Ascii("psinises"),
        dictgen::InsensitiveStr::Ascii("psinize"),
        dictgen::InsensitiveStr::Ascii("psinizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TRYPSINIZE_11310311969110258138)],
        &[(0b10010, &ENTRY_TRYPSINIZES_9989364682025433845)],
        &[(0b01001, &ENTRY_TRYPSINIZE_11310311969110258138)],
        &[(0b01001, &ENTRY_TRYPSINIZES_9989364682025433845)],
    ],
    range: 7..=8,
};

static VARS_TRU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRU_CHILDREN),
    value: None,
};

pub static VARS_TRU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("benise"),
        dictgen::InsensitiveStr::Ascii("benised"),
        dictgen::InsensitiveStr::Ascii("benises"),
        dictgen::InsensitiveStr::Ascii("benising"),
        dictgen::InsensitiveStr::Ascii("benize"),
        dictgen::InsensitiveStr::Ascii("benized"),
        dictgen::InsensitiveStr::Ascii("benizes"),
        dictgen::InsensitiveStr::Ascii("benizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TRUBENIZE_1720084137174182623)],
        &[(0b10010, &ENTRY_TRUBENIZED_12138523136394636595)],
        &[(0b10010, &ENTRY_TRUBENIZES_11904727106928842123)],
        &[(0b10010, &ENTRY_TRUBENIZING_6752069478438390648)],
        &[(0b01001, &ENTRY_TRUBENIZE_1720084137174182623)],
        &[(0b01001, &ENTRY_TRUBENIZED_12138523136394636595)],
        &[(0b01001, &ENTRY_TRUBENIZES_11904727106928842123)],
        &[(0b01001, &ENTRY_TRUBENIZING_6752069478438390648)],
    ],
    range: 6..=8,
};

static VARS_TRO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRO_CHILDREN),
    value: None,
};

pub static VARS_TRO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("llied"),
        dictgen::InsensitiveStr::Ascii("llies"),
        dictgen::InsensitiveStr::Ascii("lly"),
        dictgen::InsensitiveStr::Ascii("llying"),
        dictgen::InsensitiveStr::Ascii("paeolin"),
        dictgen::InsensitiveStr::Ascii("peolin"),
        dictgen::InsensitiveStr::Ascii("picalisation"),
        dictgen::InsensitiveStr::Ascii("picalisations"),
        dictgen::InsensitiveStr::Ascii("picalise"),
        dictgen::InsensitiveStr::Ascii("picalised"),
        dictgen::InsensitiveStr::Ascii("picalises"),
        dictgen::InsensitiveStr::Ascii("picalising"),
        dictgen::InsensitiveStr::Ascii("picalization"),
        dictgen::InsensitiveStr::Ascii("picalizations"),
        dictgen::InsensitiveStr::Ascii("picalize"),
        dictgen::InsensitiveStr::Ascii("picalized"),
        dictgen::InsensitiveStr::Ascii("picalizes"),
        dictgen::InsensitiveStr::Ascii("picalizing"),
        dictgen::InsensitiveStr::Ascii("weled"),
        dictgen::InsensitiveStr::Ascii("weler"),
        dictgen::InsensitiveStr::Ascii("welers"),
        dictgen::InsensitiveStr::Ascii("weling"),
        dictgen::InsensitiveStr::Ascii("welled"),
        dictgen::InsensitiveStr::Ascii("weller"),
        dictgen::InsensitiveStr::Ascii("wellers"),
        dictgen::InsensitiveStr::Ascii("welling"),
    ],
    values: &[
        &[(0b01001, &ENTRY_TROLLEYED_16320990397285120378)],
        &[(0b01001, &ENTRY_TROLLEYS_18263143595174364530)],
        &[(0b01001, &ENTRY_TROLLEY_1793317771282721854)],
        &[(0b01001, &ENTRY_TROLLEYING_637696503258459274)],
        &[(0b11010, &ENTRY_TROPEOLIN_13501077771486427288)],
        &[(0b00001, &ENTRY_TROPEOLIN_13501077771486427288)],
        &[(0b10010, &ENTRY_TROPICALIZATION_280149473467881406)],
        &[(0b10010, &ENTRY_TROPICALIZATIONS_11359261593866683979)],
        &[(0b10010, &ENTRY_TROPICALIZE_12627151915334844007)],
        &[(0b10010, &ENTRY_TROPICALIZED_12626126161696724783)],
        &[(0b10010, &ENTRY_TROPICALIZES_10180779904224473997)],
        &[(0b10010, &ENTRY_TROPICALIZING_17779530954870328562)],
        &[(0b01001, &ENTRY_TROPICALIZATION_280149473467881406)],
        &[(0b01001, &ENTRY_TROPICALIZATIONS_11359261593866683979)],
        &[(0b01001, &ENTRY_TROPICALIZE_12627151915334844007)],
        &[(0b01001, &ENTRY_TROPICALIZED_12626126161696724783)],
        &[(0b01001, &ENTRY_TROPICALIZES_10180779904224473997)],
        &[(0b01001, &ENTRY_TROPICALIZING_17779530954870328562)],
        &[(0b00001, &ENTRY_TROWELED_4799678352682284187)],
        &[(0b00001, &ENTRY_TROWELER_16575642105606421144)],
        &[(0b00001, &ENTRY_TROWELERS_3014176820808259829)],
        &[(0b00001, &ENTRY_TROWELING_15187396834118954225)],
        &[(0b11010, &ENTRY_TROWELED_4799678352682284187)],
        &[(0b11010, &ENTRY_TROWELER_16575642105606421144)],
        &[(0b11010, &ENTRY_TROWELERS_3014176820808259829)],
        &[(0b11010, &ENTRY_TROWELING_15187396834118954225)],
    ],
    range: 3..=13,
};

static VARS_TRI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_TRI_CHILDREN),
    value: None,
};

static VARS_TRI_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_TRIA_NODE),
    None,
    Some(&VARS_TRIC_NODE),
    None,
    Some(&VARS_TRIE_NODE),
    Some(&VARS_TRIF_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_TRIL_NODE),
    Some(&VARS_TRIM_NODE),
    None,
    Some(&VARS_TRIO_NODE),
    Some(&VARS_TRIP_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_TRIV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_TRIV_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRIV_CHILDREN),
    value: None,
};

pub static VARS_TRIV_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ialisation"),
        dictgen::InsensitiveStr::Ascii("ialisations"),
        dictgen::InsensitiveStr::Ascii("ialise"),
        dictgen::InsensitiveStr::Ascii("ialised"),
        dictgen::InsensitiveStr::Ascii("ialises"),
        dictgen::InsensitiveStr::Ascii("ialising"),
        dictgen::InsensitiveStr::Ascii("ialization"),
        dictgen::InsensitiveStr::Ascii("ializations"),
        dictgen::InsensitiveStr::Ascii("ialize"),
        dictgen::InsensitiveStr::Ascii("ialized"),
        dictgen::InsensitiveStr::Ascii("ializes"),
        dictgen::InsensitiveStr::Ascii("ializing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TRIVIALIZATION_15415473767815002378)],
        &[(0b10010, &ENTRY_TRIVIALIZATIONS_7001355469538203417)],
        &[(0b10010, &ENTRY_TRIVIALIZE_18242589362817679930)],
        &[(0b10010, &ENTRY_TRIVIALIZED_7658877615119170597)],
        &[(0b10010, &ENTRY_TRIVIALIZES_12098662311152290426)],
        &[(0b10010, &ENTRY_TRIVIALIZING_11202764572056711533)],
        &[(0b01001, &ENTRY_TRIVIALIZATION_15415473767815002378)],
        &[(0b01001, &ENTRY_TRIVIALIZATIONS_7001355469538203417)],
        &[(0b01001, &ENTRY_TRIVIALIZE_18242589362817679930)],
        &[(0b01001, &ENTRY_TRIVIALIZED_7658877615119170597)],
        &[(0b01001, &ENTRY_TRIVIALIZES_12098662311152290426)],
        &[(0b01001, &ENTRY_TRIVIALIZING_11202764572056711533)],
    ],
    range: 6..=11,
};

static VARS_TRIP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRIP_CHILDREN),
    value: None,
};

pub static VARS_TRIP_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ylaean"),
        dictgen::InsensitiveStr::Ascii("ylean"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TRIPYLEAN_10875065225907680531)],
        &[(0b00001, &ENTRY_TRIPYLEAN_10875065225907680531)],
    ],
    range: 5..=6,
};

static VARS_TRIO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRIO_CHILDREN),
    value: None,
};

pub static VARS_TRIO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ecious"),
        dictgen::InsensitiveStr::Ascii("eciously"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TRIECIOUS_13315610863197702350)],
        &[(0b11010, &ENTRY_TRIECIOUSLY_8350175444262968317)],
    ],
    range: 6..=8,
};

static VARS_TRIM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRIM_CHILDREN),
    value: None,
};

pub static VARS_TRIM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("erisation"),
        dictgen::InsensitiveStr::Ascii("erisations"),
        dictgen::InsensitiveStr::Ascii("erization"),
        dictgen::InsensitiveStr::Ascii("erizations"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TRIMERIZATION_12375953829418021021)],
        &[(0b10010, &ENTRY_TRIMERIZATIONS_1022726125043168815)],
        &[(0b01001, &ENTRY_TRIMERIZATION_12375953829418021021)],
        &[(0b01001, &ENTRY_TRIMERIZATIONS_1022726125043168815)],
    ],
    range: 9..=10,
};

static VARS_TRIL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRIL_CHILDREN),
    value: None,
};

pub static VARS_TRIL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lionise"),
        dictgen::InsensitiveStr::Ascii("lionises"),
        dictgen::InsensitiveStr::Ascii("lionize"),
        dictgen::InsensitiveStr::Ascii("lionizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TRILLIONIZE_2061247672357509542)],
        &[(0b10010, &ENTRY_TRILLIONIZES_10650478618693827922)],
        &[(0b01001, &ENTRY_TRILLIONIZE_2061247672357509542)],
        &[(0b01001, &ENTRY_TRILLIONIZES_10650478618693827922)],
    ],
    range: 7..=8,
};

static VARS_TRIF_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRIF_CHILDREN),
    value: None,
};

pub static VARS_TRIF_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("luoride"),
        dictgen::InsensitiveStr::Ascii("luouride"),
    ],
    values: &[
        &[(0b00001, &ENTRY_TRIFLUORIDE_7068061211011145761)],
        &[(0b11010, &ENTRY_TRIFLUORIDE_7068061211011145761)],
    ],
    range: 7..=8,
};

static VARS_TRIE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRIE_CHILDREN),
    value: None,
};

pub static VARS_TRIE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cious"),
        dictgen::InsensitiveStr::Ascii("ciously"),
        dictgen::InsensitiveStr::Ascii("ne"),
    ],
    values: &[
        &[(0b00001, &ENTRY_TRIECIOUS_13315610863197702350)],
        &[(0b00001, &ENTRY_TRIECIOUSLY_8350175444262968317)],
        &[(0b00001, &ENTRY_TRIENE_15794998642666208471)],
    ],
    range: 2..=7,
};

static VARS_TRIC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRIC_CHILDREN),
    value: None,
};

pub static VARS_TRIC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hinisation"),
        dictgen::InsensitiveStr::Ascii("hinisations"),
        dictgen::InsensitiveStr::Ascii("hinise"),
        dictgen::InsensitiveStr::Ascii("hinised"),
        dictgen::InsensitiveStr::Ascii("hinises"),
        dictgen::InsensitiveStr::Ascii("hinising"),
        dictgen::InsensitiveStr::Ascii("hinization"),
        dictgen::InsensitiveStr::Ascii("hinizations"),
        dictgen::InsensitiveStr::Ascii("hinize"),
        dictgen::InsensitiveStr::Ascii("hinized"),
        dictgen::InsensitiveStr::Ascii("hinizes"),
        dictgen::InsensitiveStr::Ascii("hinizing"),
        dictgen::InsensitiveStr::Ascii("hlorethylene"),
        dictgen::InsensitiveStr::Ascii("hlorethylenes"),
        dictgen::InsensitiveStr::Ascii("hloroethylene"),
        dictgen::InsensitiveStr::Ascii("hloroethylenes"),
        dictgen::InsensitiveStr::Ascii("hotomise"),
        dictgen::InsensitiveStr::Ascii("hotomised"),
        dictgen::InsensitiveStr::Ascii("hotomises"),
        dictgen::InsensitiveStr::Ascii("hotomising"),
        dictgen::InsensitiveStr::Ascii("hotomize"),
        dictgen::InsensitiveStr::Ascii("hotomized"),
        dictgen::InsensitiveStr::Ascii("hotomizes"),
        dictgen::InsensitiveStr::Ascii("hotomizing"),
        dictgen::InsensitiveStr::Ascii("olor"),
        dictgen::InsensitiveStr::Ascii("olored"),
        dictgen::InsensitiveStr::Ascii("olors"),
        dictgen::InsensitiveStr::Ascii("olour"),
        dictgen::InsensitiveStr::Ascii("oloured"),
        dictgen::InsensitiveStr::Ascii("olours"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TRICHINIZATION_17095496984757617228)],
        &[(0b10010, &ENTRY_TRICHINIZATIONS_12374290002608454472)],
        &[(0b10010, &ENTRY_TRICHINIZE_5574846251210958831)],
        &[(0b10010, &ENTRY_TRICHINIZED_17644488673613289890)],
        &[(0b10010, &ENTRY_TRICHINIZES_1344045113327285956)],
        &[(0b10010, &ENTRY_TRICHINIZING_3545688560394153529)],
        &[(0b01001, &ENTRY_TRICHINIZATION_17095496984757617228)],
        &[(0b01001, &ENTRY_TRICHINIZATIONS_12374290002608454472)],
        &[(0b01001, &ENTRY_TRICHINIZE_5574846251210958831)],
        &[(0b01001, &ENTRY_TRICHINIZED_17644488673613289890)],
        &[(0b01001, &ENTRY_TRICHINIZES_1344045113327285956)],
        &[(0b01001, &ENTRY_TRICHINIZING_3545688560394153529)],
        &[(0b00001, &ENTRY_TRICHLORETHYLENE_9901005590441640862)],
        &[(0b00001, &ENTRY_TRICHLORETHYLENES_15772099121722073798)],
        &[(0b11010, &ENTRY_TRICHLORETHYLENE_9901005590441640862)],
        &[(0b11010, &ENTRY_TRICHLORETHYLENES_15772099121722073798)],
        &[(0b10010, &ENTRY_TRICHOTOMIZE_854533418810743207)],
        &[(0b10010, &ENTRY_TRICHOTOMIZED_3347768583083276490)],
        &[(0b10010, &ENTRY_TRICHOTOMIZES_17276637113087926760)],
        &[(0b10010, &ENTRY_TRICHOTOMIZING_4094867634668496821)],
        &[(0b01001, &ENTRY_TRICHOTOMIZE_854533418810743207)],
        &[(0b01001, &ENTRY_TRICHOTOMIZED_3347768583083276490)],
        &[(0b01001, &ENTRY_TRICHOTOMIZES_17276637113087926760)],
        &[(0b01001, &ENTRY_TRICHOTOMIZING_4094867634668496821)],
        &[(0b00001, &ENTRY_TRICOLOR_29934386578088381)],
        &[(0b00001, &ENTRY_TRICOLORED_14625827355822839152)],
        &[(0b00001, &ENTRY_TRICOLORS_5653354569553256367)],
        &[(0b11010, &ENTRY_TRICOLOR_29934386578088381)],
        &[(0b11010, &ENTRY_TRICOLORED_14625827355822839152)],
        &[(0b11010, &ENTRY_TRICOLORS_5653354569553256367)],
    ],
    range: 4..=14,
};

static VARS_TRIA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRIA_CHILDREN),
    value: None,
};

pub static VARS_TRIA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ene"),
        dictgen::InsensitiveStr::Ascii("led"),
        dictgen::InsensitiveStr::Ascii("ling"),
        dictgen::InsensitiveStr::Ascii("lisation"),
        dictgen::InsensitiveStr::Ascii("lization"),
        dictgen::InsensitiveStr::Ascii("lled"),
        dictgen::InsensitiveStr::Ascii("lling"),
        dictgen::InsensitiveStr::Ascii("ngularisation"),
        dictgen::InsensitiveStr::Ascii("ngularisations"),
        dictgen::InsensitiveStr::Ascii("ngularise"),
        dictgen::InsensitiveStr::Ascii("ngularised"),
        dictgen::InsensitiveStr::Ascii("ngularises"),
        dictgen::InsensitiveStr::Ascii("ngularising"),
        dictgen::InsensitiveStr::Ascii("ngularization"),
        dictgen::InsensitiveStr::Ascii("ngularizations"),
        dictgen::InsensitiveStr::Ascii("ngularize"),
        dictgen::InsensitiveStr::Ascii("ngularized"),
        dictgen::InsensitiveStr::Ascii("ngularizes"),
        dictgen::InsensitiveStr::Ascii("ngularizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TRIENE_15794998642666208471)],
        &[(0b00001, &ENTRY_TRIALED_10113550628054960808)],
        &[(0b00001, &ENTRY_TRIALING_6397065983321001404)],
        &[(0b10010, &ENTRY_TRIALIZATION_15902543461546982351)],
        &[(0b01001, &ENTRY_TRIALIZATION_15902543461546982351)],
        &[(0b11010, &ENTRY_TRIALED_10113550628054960808)],
        &[(0b11010, &ENTRY_TRIALING_6397065983321001404)],
        &[(0b10010, &ENTRY_TRIANGULARIZATION_5170297502596499934)],
        &[(0b10010, &ENTRY_TRIANGULARIZATIONS_9175876927610339412)],
        &[(0b10010, &ENTRY_TRIANGULARIZE_6075796262826371207)],
        &[(0b10010, &ENTRY_TRIANGULARIZED_8399601922283134135)],
        &[(0b10010, &ENTRY_TRIANGULARIZES_2309859741267387471)],
        &[(0b10010, &ENTRY_TRIANGULARIZING_6298865978999024428)],
        &[(0b01001, &ENTRY_TRIANGULARIZATION_5170297502596499934)],
        &[(0b01001, &ENTRY_TRIANGULARIZATIONS_9175876927610339412)],
        &[(0b01001, &ENTRY_TRIANGULARIZE_6075796262826371207)],
        &[(0b01001, &ENTRY_TRIANGULARIZED_8399601922283134135)],
        &[(0b01001, &ENTRY_TRIANGULARIZES_2309859741267387471)],
        &[(0b01001, &ENTRY_TRIANGULARIZING_6298865978999024428)],
    ],
    range: 3..=14,
};

static VARS_TRE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRE_CHILDREN),
    value: None,
};

pub static VARS_TRE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("f"),
        dictgen::InsensitiveStr::Ascii("ma"),
        dictgen::InsensitiveStr::Ascii("matic"),
        dictgen::InsensitiveStr::Ascii("ts"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TERF_3510176223973213714)],
        &[(0b11010, &ENTRY_TERMA_12658799001593884461)],
        &[(0b11010, &ENTRY_TERMATIC_575294056877958757)],
        &[(0b11010, &ENTRY_TERTS_15921222583797171907)],
    ],
    range: 1..=5,
};

static VARS_TRA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_TRA_CHILDREN),
    value: None,
};

static VARS_TRA_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_TRAB_NODE),
    Some(&VARS_TRAC_NODE),
    Some(&VARS_TRAD_NODE),
    None,
    None,
    Some(&VARS_TRAG_NODE),
    None,
    Some(&VARS_TRAI_NODE),
    None,
    None,
    None,
    Some(&VARS_TRAM_NODE),
    Some(&VARS_TRAN_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_TRAU_NODE),
    Some(&VARS_TRAV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_TRAV_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRAV_CHILDREN),
    value: None,
};

pub static VARS_TRAV_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eled"),
        dictgen::InsensitiveStr::Ascii("eler"),
        dictgen::InsensitiveStr::Ascii("elers"),
        dictgen::InsensitiveStr::Ascii("eling"),
        dictgen::InsensitiveStr::Ascii("elings"),
        dictgen::InsensitiveStr::Ascii("elled"),
        dictgen::InsensitiveStr::Ascii("eller"),
        dictgen::InsensitiveStr::Ascii("ellers"),
        dictgen::InsensitiveStr::Ascii("elling"),
        dictgen::InsensitiveStr::Ascii("ellings"),
        dictgen::InsensitiveStr::Ascii("elog"),
        dictgen::InsensitiveStr::Ascii("elogs"),
    ],
    values: &[
        &[(0b00001, &ENTRY_TRAVELED_7471204723840738059)],
        &[(0b00001, &ENTRY_TRAVELER_13674641254214006714)],
        &[(0b00001, &ENTRY_TRAVELERS_534480827925386728)],
        &[(0b00001, &ENTRY_TRAVELING_15330546315886302191)],
        &[(0b00001, &ENTRY_TRAVELINGS_4473114144843360272)],
        &[(0b11010, &ENTRY_TRAVELED_7471204723840738059)],
        &[(0b11010, &ENTRY_TRAVELER_13674641254214006714)],
        &[(0b11010, &ENTRY_TRAVELERS_534480827925386728)],
        &[(0b11010, &ENTRY_TRAVELING_15330546315886302191)],
        &[(0b11010, &ENTRY_TRAVELINGS_4473114144843360272)],
        &[(0b00001, &ENTRY_TRAVELOGUE_9832945069166970827)],
        &[(0b00001, &ENTRY_TRAVELOGUES_4261693774497596751)],
    ],
    range: 4..=7,
};

static VARS_TRAU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRAU_CHILDREN),
    value: None,
};

pub static VARS_TRAU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("matisation"),
        dictgen::InsensitiveStr::Ascii("matisations"),
        dictgen::InsensitiveStr::Ascii("matise"),
        dictgen::InsensitiveStr::Ascii("matised"),
        dictgen::InsensitiveStr::Ascii("matises"),
        dictgen::InsensitiveStr::Ascii("matising"),
        dictgen::InsensitiveStr::Ascii("matization"),
        dictgen::InsensitiveStr::Ascii("matizations"),
        dictgen::InsensitiveStr::Ascii("matize"),
        dictgen::InsensitiveStr::Ascii("matized"),
        dictgen::InsensitiveStr::Ascii("matizes"),
        dictgen::InsensitiveStr::Ascii("matizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TRAUMATIZATION_3746681776679931423)],
        &[(0b10010, &ENTRY_TRAUMATIZATIONS_7417106584297477223)],
        &[(0b10010, &ENTRY_TRAUMATIZE_8649856127609129608)],
        &[(0b10010, &ENTRY_TRAUMATIZED_7431966359976446213)],
        &[(0b10010, &ENTRY_TRAUMATIZES_4330104088006808909)],
        &[(0b10010, &ENTRY_TRAUMATIZING_2918929651955345564)],
        &[(0b01001, &ENTRY_TRAUMATIZATION_3746681776679931423)],
        &[(0b01001, &ENTRY_TRAUMATIZATIONS_7417106584297477223)],
        &[(0b01001, &ENTRY_TRAUMATIZE_8649856127609129608)],
        &[(0b01001, &ENTRY_TRAUMATIZED_7431966359976446213)],
        &[(0b01001, &ENTRY_TRAUMATIZES_4330104088006808909)],
        &[(0b01001, &ENTRY_TRAUMATIZING_2918929651955345564)],
    ],
    range: 6..=11,
};

static VARS_TRAN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_TRAN_CHILDREN),
    value: None,
};

static VARS_TRAN_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_TRANQ_NODE),
    None,
    Some(&VARS_TRANS_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_TRANS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRANS_CHILDREN),
    value: None,
};

pub static VARS_TRANS_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cendentalisation"),
        dictgen::InsensitiveStr::Ascii("cendentalise"),
        dictgen::InsensitiveStr::Ascii("cendentalised"),
        dictgen::InsensitiveStr::Ascii("cendentalises"),
        dictgen::InsensitiveStr::Ascii("cendentalising"),
        dictgen::InsensitiveStr::Ascii("cendentalization"),
        dictgen::InsensitiveStr::Ascii("cendentalize"),
        dictgen::InsensitiveStr::Ascii("cendentalized"),
        dictgen::InsensitiveStr::Ascii("cendentalizes"),
        dictgen::InsensitiveStr::Ascii("cendentalizing"),
        dictgen::InsensitiveStr::Ascii("color"),
        dictgen::InsensitiveStr::Ascii("coloration"),
        dictgen::InsensitiveStr::Ascii("colorations"),
        dictgen::InsensitiveStr::Ascii("colorrer"),
        dictgen::InsensitiveStr::Ascii("colorrest"),
        dictgen::InsensitiveStr::Ascii("colour"),
        dictgen::InsensitiveStr::Ascii("colouration"),
        dictgen::InsensitiveStr::Ascii("colourations"),
        dictgen::InsensitiveStr::Ascii("colourer"),
        dictgen::InsensitiveStr::Ascii("colourest"),
        dictgen::InsensitiveStr::Ascii("istorisation"),
        dictgen::InsensitiveStr::Ascii("istorisations"),
        dictgen::InsensitiveStr::Ascii("istorise"),
        dictgen::InsensitiveStr::Ascii("istorised"),
        dictgen::InsensitiveStr::Ascii("istorises"),
        dictgen::InsensitiveStr::Ascii("istorising"),
        dictgen::InsensitiveStr::Ascii("istorization"),
        dictgen::InsensitiveStr::Ascii("istorizations"),
        dictgen::InsensitiveStr::Ascii("istorize"),
        dictgen::InsensitiveStr::Ascii("istorized"),
        dictgen::InsensitiveStr::Ascii("istorizes"),
        dictgen::InsensitiveStr::Ascii("istorizing"),
        dictgen::InsensitiveStr::Ascii("parentise"),
        dictgen::InsensitiveStr::Ascii("parentises"),
        dictgen::InsensitiveStr::Ascii("parentize"),
        dictgen::InsensitiveStr::Ascii("parentizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TRANSCENDENTALIZATION_16279978221157892606)],
        &[(0b10010, &ENTRY_TRANSCENDENTALIZE_12477449740073762039)],
        &[(0b10010, &ENTRY_TRANSCENDENTALIZED_1811227647892991582)],
        &[(0b10010, &ENTRY_TRANSCENDENTALIZES_256586495310370731)],
        &[(0b10010, &ENTRY_TRANSCENDENTALIZING_1803732975904952155)],
        &[(0b01001, &ENTRY_TRANSCENDENTALIZATION_16279978221157892606)],
        &[(0b01001, &ENTRY_TRANSCENDENTALIZE_12477449740073762039)],
        &[(0b01001, &ENTRY_TRANSCENDENTALIZED_1811227647892991582)],
        &[(0b01001, &ENTRY_TRANSCENDENTALIZES_256586495310370731)],
        &[(0b01001, &ENTRY_TRANSCENDENTALIZING_1803732975904952155)],
        &[(0b00001, &ENTRY_TRANSCOLOR_3566969815815539331)],
        &[(0b00001, &ENTRY_TRANSCOLORATION_343129450671874835)],
        &[(0b00001, &ENTRY_TRANSCOLORATIONS_16758395443174056843)],
        &[(0b00001, &ENTRY_TRANSCOLORRER_4795645889162012189)],
        &[(0b00001, &ENTRY_TRANSCOLORREST_13178604266626958240)],
        &[(0b11010, &ENTRY_TRANSCOLOR_3566969815815539331)],
        &[(0b11010, &ENTRY_TRANSCOLORATION_343129450671874835)],
        &[(0b11010, &ENTRY_TRANSCOLORATIONS_16758395443174056843)],
        &[(0b11010, &ENTRY_TRANSCOLORRER_4795645889162012189)],
        &[(0b11010, &ENTRY_TRANSCOLORREST_13178604266626958240)],
        &[(0b10010, &ENTRY_TRANSISTORIZATION_1936290593265769427)],
        &[(0b10010, &ENTRY_TRANSISTORIZATIONS_15440922126340456777)],
        &[(0b10010, &ENTRY_TRANSISTORIZE_14955480539617938425)],
        &[(0b10010, &ENTRY_TRANSISTORIZED_15135482287551822492)],
        &[(0b10010, &ENTRY_TRANSISTORIZES_1343939411237171803)],
        &[(0b10010, &ENTRY_TRANSISTORIZING_10767950521341986252)],
        &[(0b01001, &ENTRY_TRANSISTORIZATION_1936290593265769427)],
        &[(0b01001, &ENTRY_TRANSISTORIZATIONS_15440922126340456777)],
        &[(0b01001, &ENTRY_TRANSISTORIZE_14955480539617938425)],
        &[(0b01001, &ENTRY_TRANSISTORIZED_15135482287551822492)],
        &[(0b01001, &ENTRY_TRANSISTORIZES_1343939411237171803)],
        &[(0b01001, &ENTRY_TRANSISTORIZING_10767950521341986252)],
        &[(0b10010, &ENTRY_TRANSPARENTIZE_1817106363462334768)],
        &[(0b10010, &ENTRY_TRANSPARENTIZES_9410899145545451286)],
        &[(0b01001, &ENTRY_TRANSPARENTIZE_1817106363462334768)],
        &[(0b01001, &ENTRY_TRANSPARENTIZES_9410899145545451286)],
    ],
    range: 5..=16,
};

static VARS_TRANQ_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRANQ_CHILDREN),
    value: None,
};

pub static VARS_TRANQ_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("uilisation"),
        dictgen::InsensitiveStr::Ascii("uilisations"),
        dictgen::InsensitiveStr::Ascii("uilisingly"),
        dictgen::InsensitiveStr::Ascii("uilization"),
        dictgen::InsensitiveStr::Ascii("uilizations"),
        dictgen::InsensitiveStr::Ascii("uilize"),
        dictgen::InsensitiveStr::Ascii("uilized"),
        dictgen::InsensitiveStr::Ascii("uilizer"),
        dictgen::InsensitiveStr::Ascii("uilizers"),
        dictgen::InsensitiveStr::Ascii("uilizes"),
        dictgen::InsensitiveStr::Ascii("uilizing"),
        dictgen::InsensitiveStr::Ascii("uilizingly"),
        dictgen::InsensitiveStr::Ascii("uilizings"),
        dictgen::InsensitiveStr::Ascii("uillisation"),
        dictgen::InsensitiveStr::Ascii("uillisations"),
        dictgen::InsensitiveStr::Ascii("uillise"),
        dictgen::InsensitiveStr::Ascii("uillised"),
        dictgen::InsensitiveStr::Ascii("uilliser"),
        dictgen::InsensitiveStr::Ascii("uillisers"),
        dictgen::InsensitiveStr::Ascii("uillises"),
        dictgen::InsensitiveStr::Ascii("uillising"),
        dictgen::InsensitiveStr::Ascii("uillisingly"),
        dictgen::InsensitiveStr::Ascii("uillisings"),
        dictgen::InsensitiveStr::Ascii("uillities"),
        dictgen::InsensitiveStr::Ascii("uillity"),
        dictgen::InsensitiveStr::Ascii("uillization"),
        dictgen::InsensitiveStr::Ascii("uillizations"),
        dictgen::InsensitiveStr::Ascii("uillize"),
        dictgen::InsensitiveStr::Ascii("uillized"),
        dictgen::InsensitiveStr::Ascii("uillizer"),
        dictgen::InsensitiveStr::Ascii("uillizers"),
        dictgen::InsensitiveStr::Ascii("uillizes"),
        dictgen::InsensitiveStr::Ascii("uillizing"),
        dictgen::InsensitiveStr::Ascii("uillizingly"),
        dictgen::InsensitiveStr::Ascii("uillizings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TRANQUILIZATION_14846255753979813760)],
        &[(0b10010, &ENTRY_TRANQUILIZATIONS_17619573841316216935)],
        &[(0b10010, &ENTRY_TRANQUILIZINGLY_556670129841874355)],
        &[(0b01001, &ENTRY_TRANQUILIZATION_14846255753979813760)],
        &[(0b01001, &ENTRY_TRANQUILIZATIONS_17619573841316216935)],
        &[(0b01001, &ENTRY_TRANQUILIZE_10282286664857910461)],
        &[(0b01001, &ENTRY_TRANQUILIZED_8802666398177881938)],
        &[(0b01001, &ENTRY_TRANQUILIZER_2761665163152313094)],
        &[(0b01001, &ENTRY_TRANQUILIZERS_17103334183302096096)],
        &[(0b01001, &ENTRY_TRANQUILIZES_59757620788033573)],
        &[(0b01001, &ENTRY_TRANQUILIZING_13850716228820534198)],
        &[(0b01001, &ENTRY_TRANQUILIZINGLY_556670129841874355)],
        &[(0b01001, &ENTRY_TRANQUILIZINGS_2266773302059369088)],
        &[(0b10010, &ENTRY_TRANQUILLIZATION_11946857030526310268)],
        &[(0b10010, &ENTRY_TRANQUILLIZATIONS_4263826721380617410)],
        &[(0b11010, &ENTRY_TRANQUILIZE_10282286664857910461)],
        &[(0b11010, &ENTRY_TRANQUILIZED_8802666398177881938)],
        &[(0b11010, &ENTRY_TRANQUILIZER_2761665163152313094)],
        &[(0b11010, &ENTRY_TRANQUILIZERS_17103334183302096096)],
        &[(0b11010, &ENTRY_TRANQUILIZES_59757620788033573)],
        &[(0b11010, &ENTRY_TRANQUILIZING_13850716228820534198)],
        &[(0b10010, &ENTRY_TRANQUILLIZINGLY_14381964317822750722)],
        &[(0b11010, &ENTRY_TRANQUILIZINGS_2266773302059369088)],
        &[(0b10011, &ENTRY_TRANQUILITIES_16195163391619170068)],
        &[(0b10011, &ENTRY_TRANQUILITY_8540551709960885595)],
        &[(0b01001, &ENTRY_TRANQUILLIZATION_11946857030526310268)],
        &[(0b01001, &ENTRY_TRANQUILLIZATIONS_4263826721380617410)],
        &[(0b01001, &ENTRY_TRANQUILIZE_10282286664857910461)],
        &[(0b01001, &ENTRY_TRANQUILIZED_8802666398177881938)],
        &[(0b01001, &ENTRY_TRANQUILIZER_2761665163152313094)],
        &[(0b01001, &ENTRY_TRANQUILIZERS_17103334183302096096)],
        &[(0b01001, &ENTRY_TRANQUILIZES_59757620788033573)],
        &[(0b01001, &ENTRY_TRANQUILIZING_13850716228820534198)],
        &[(0b01001, &ENTRY_TRANQUILLIZINGLY_14381964317822750722)],
        &[(0b01001, &ENTRY_TRANQUILIZINGS_2266773302059369088)],
    ],
    range: 6..=12,
};

static VARS_TRAM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRAM_CHILDREN),
    value: None,
};

pub static VARS_TRAM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("meled"),
        dictgen::InsensitiveStr::Ascii("meler"),
        dictgen::InsensitiveStr::Ascii("melers"),
        dictgen::InsensitiveStr::Ascii("meling"),
        dictgen::InsensitiveStr::Ascii("melled"),
        dictgen::InsensitiveStr::Ascii("meller"),
        dictgen::InsensitiveStr::Ascii("mellers"),
        dictgen::InsensitiveStr::Ascii("melling"),
    ],
    values: &[
        &[(0b01001, &ENTRY_TRAMMELED_7321238481699131765)],
        &[(0b00001, &ENTRY_TRAMMELER_1286061836358212954)],
        &[(0b00001, &ENTRY_TRAMMELERS_8202463777486458185)],
        &[(0b01001, &ENTRY_TRAMMELING_2641971254351085893)],
        &[(0b11010, &ENTRY_TRAMMELED_7321238481699131765)],
        &[(0b11010, &ENTRY_TRAMMELER_1286061836358212954)],
        &[(0b11010, &ENTRY_TRAMMELERS_8202463777486458185)],
        &[(0b11010, &ENTRY_TRAMMELING_2641971254351085893)],
    ],
    range: 5..=7,
};

static VARS_TRAI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRAI_CHILDREN),
    value: None,
};

pub static VARS_TRAI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("torise"),
        dictgen::InsensitiveStr::Ascii("torises"),
        dictgen::InsensitiveStr::Ascii("torize"),
        dictgen::InsensitiveStr::Ascii("torizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TRAITORIZE_551131030474656423)],
        &[(0b10010, &ENTRY_TRAITORIZES_16161164434011189838)],
        &[(0b01001, &ENTRY_TRAITORIZE_551131030474656423)],
        &[(0b01001, &ENTRY_TRAITORIZES_16161164434011189838)],
    ],
    range: 6..=7,
};

static VARS_TRAG_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRAG_CHILDREN),
    value: None,
};

pub static VARS_TRAG_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("icise"),
        dictgen::InsensitiveStr::Ascii("icises"),
        dictgen::InsensitiveStr::Ascii("icize"),
        dictgen::InsensitiveStr::Ascii("icizes"),
        dictgen::InsensitiveStr::Ascii("icolored"),
        dictgen::InsensitiveStr::Ascii("icoloured"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TRAGICIZE_957780290072315119)],
        &[(0b10010, &ENTRY_TRAGICIZES_17519202874941904760)],
        &[(0b01001, &ENTRY_TRAGICIZE_957780290072315119)],
        &[(0b01001, &ENTRY_TRAGICIZES_17519202874941904760)],
        &[(0b00001, &ENTRY_TRAGICOLORED_13278772284942211165)],
        &[(0b11010, &ENTRY_TRAGICOLORED_13278772284942211165)],
    ],
    range: 5..=9,
};

static VARS_TRAD_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRAD_CHILDREN),
    value: None,
};

pub static VARS_TRAD_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("itionalise"),
        dictgen::InsensitiveStr::Ascii("itionalised"),
        dictgen::InsensitiveStr::Ascii("itionalises"),
        dictgen::InsensitiveStr::Ascii("itionalize"),
        dictgen::InsensitiveStr::Ascii("itionalized"),
        dictgen::InsensitiveStr::Ascii("itionalizes"),
        dictgen::InsensitiveStr::Ascii("itionise"),
        dictgen::InsensitiveStr::Ascii("itionises"),
        dictgen::InsensitiveStr::Ascii("itionize"),
        dictgen::InsensitiveStr::Ascii("itionizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TRADITIONALIZE_4898176225220743845)],
        &[(0b10010, &ENTRY_TRADITIONALIZED_2635338649308214147)],
        &[(0b10010, &ENTRY_TRADITIONALIZES_17884375175492170718)],
        &[(0b01001, &ENTRY_TRADITIONALIZE_4898176225220743845)],
        &[(0b01001, &ENTRY_TRADITIONALIZED_2635338649308214147)],
        &[(0b01001, &ENTRY_TRADITIONALIZES_17884375175492170718)],
        &[(0b10010, &ENTRY_TRADITIONIZE_11047234467125040571)],
        &[(0b10010, &ENTRY_TRADITIONIZES_18011235531342430501)],
        &[(0b01001, &ENTRY_TRADITIONIZE_11047234467125040571)],
        &[(0b01001, &ENTRY_TRADITIONIZES_18011235531342430501)],
    ],
    range: 8..=11,
};

static VARS_TRAC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRAC_CHILDREN),
    value: None,
};

pub static VARS_TRAC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("torisation"),
        dictgen::InsensitiveStr::Ascii("torisations"),
        dictgen::InsensitiveStr::Ascii("torise"),
        dictgen::InsensitiveStr::Ascii("torises"),
        dictgen::InsensitiveStr::Ascii("torization"),
        dictgen::InsensitiveStr::Ascii("torizations"),
        dictgen::InsensitiveStr::Ascii("torize"),
        dictgen::InsensitiveStr::Ascii("torizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TRACTORIZATION_3823073726188841416)],
        &[(0b10010, &ENTRY_TRACTORIZATIONS_18210642849375336921)],
        &[(0b10010, &ENTRY_TRACTORIZE_12965430895282931565)],
        &[(0b10010, &ENTRY_TRACTORIZES_5631147609434218207)],
        &[(0b01001, &ENTRY_TRACTORIZATION_3823073726188841416)],
        &[(0b01001, &ENTRY_TRACTORIZATIONS_18210642849375336921)],
        &[(0b01001, &ENTRY_TRACTORIZE_12965430895282931565)],
        &[(0b01001, &ENTRY_TRACTORIZES_5631147609434218207)],
    ],
    range: 6..=11,
};

static VARS_TRAB_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TRAB_CHILDREN),
    value: None,
};

pub static VARS_TRAB_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eatae"),
        dictgen::InsensitiveStr::Ascii("eate"),
        dictgen::InsensitiveStr::Ascii("eculae"),
        dictgen::InsensitiveStr::Ascii("ecule"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TRABEATE_475272284513241921)],
        &[(0b00001, &ENTRY_TRABEATE_475272284513241921)],
        &[(0b11010, &ENTRY_TRABECULE_4746018401275580221)],
        &[(0b00001, &ENTRY_TRABECULE_4746018401275580221)],
    ],
    range: 4..=6,
};

static VARS_TO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_TO_CHILDREN),
    value: None,
};

static VARS_TO_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_TON_NODE),
    None,
    Some(&VARS_TOP_NODE),
    None,
    Some(&VARS_TOR_NODE),
    None,
    Some(&VARS_TOT_NODE),
    Some(&VARS_TOU_NODE),
    None,
    Some(&VARS_TOW_NODE),
    Some(&VARS_TOX_NODE),
    None,
    None,
];

static VARS_TOX_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TOX_CHILDREN),
    value: None,
};

pub static VARS_TOX_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aemia"),
        dictgen::InsensitiveStr::Ascii("aemias"),
        dictgen::InsensitiveStr::Ascii("aemic"),
        dictgen::InsensitiveStr::Ascii("anaemia"),
        dictgen::InsensitiveStr::Ascii("anemia"),
        dictgen::InsensitiveStr::Ascii("emia"),
        dictgen::InsensitiveStr::Ascii("emias"),
        dictgen::InsensitiveStr::Ascii("emic"),
        dictgen::InsensitiveStr::Ascii("icaemia"),
        dictgen::InsensitiveStr::Ascii("icemia"),
        dictgen::InsensitiveStr::Ascii("icohaemia"),
        dictgen::InsensitiveStr::Ascii("icohemia"),
        dictgen::InsensitiveStr::Ascii("ihaemia"),
        dictgen::InsensitiveStr::Ascii("ihemia"),
        dictgen::InsensitiveStr::Ascii("inaemia"),
        dictgen::InsensitiveStr::Ascii("inemia"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TOXEMIA_13728114455609378495)],
        &[(0b10010, &ENTRY_TOXEMIAS_16145092731975598632)],
        &[(0b10010, &ENTRY_TOXEMIC_3847368103673580332)],
        &[(0b11010, &ENTRY_TOXANEMIA_5092978943692773401)],
        &[(0b00001, &ENTRY_TOXANEMIA_5092978943692773401)],
        &[(0b11001, &ENTRY_TOXEMIA_13728114455609378495)],
        &[(0b11001, &ENTRY_TOXEMIAS_16145092731975598632)],
        &[(0b11001, &ENTRY_TOXEMIC_3847368103673580332)],
        &[(0b11010, &ENTRY_TOXICEMIA_3221713968588738388)],
        &[(0b00001, &ENTRY_TOXICEMIA_3221713968588738388)],
        &[(0b11010, &ENTRY_TOXICOHEMIA_1510663382315935096)],
        &[(0b00001, &ENTRY_TOXICOHEMIA_1510663382315935096)],
        &[(0b11010, &ENTRY_TOXIHEMIA_17949081455236710796)],
        &[(0b00001, &ENTRY_TOXIHEMIA_17949081455236710796)],
        &[(0b11010, &ENTRY_TOXINEMIA_4067816496926950076)],
        &[(0b00001, &ENTRY_TOXINEMIA_4067816496926950076)],
    ],
    range: 4..=9,
};

static VARS_TOW_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TOW_CHILDREN),
    value: None,
};

pub static VARS_TOW_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eled"),
        dictgen::InsensitiveStr::Ascii("eling"),
        dictgen::InsensitiveStr::Ascii("elings"),
        dictgen::InsensitiveStr::Ascii("elled"),
        dictgen::InsensitiveStr::Ascii("elling"),
        dictgen::InsensitiveStr::Ascii("ellings"),
    ],
    values: &[
        &[(0b00001, &ENTRY_TOWELED_15166488210792177793)],
        &[(0b00001, &ENTRY_TOWELING_4481362776063713769)],
        &[(0b00001, &ENTRY_TOWELINGS_6911217900542580416)],
        &[(0b11010, &ENTRY_TOWELED_15166488210792177793)],
        &[(0b11010, &ENTRY_TOWELING_4481362776063713769)],
        &[(0b11010, &ENTRY_TOWELINGS_6911217900542580416)],
    ],
    range: 4..=7,
};

static VARS_TOU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TOU_CHILDREN),
    value: None,
};

pub static VARS_TOU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ret"),
        dictgen::InsensitiveStr::Ascii("rise"),
        dictgen::InsensitiveStr::Ascii("rises"),
        dictgen::InsensitiveStr::Ascii("rize"),
        dictgen::InsensitiveStr::Ascii("rizes"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TORET_14642122393715101008)],
        &[(0b10010, &ENTRY_TOURIZE_4416339355326535837)],
        &[(0b10010, &ENTRY_TOURIZES_16287459104895480818)],
        &[(0b01001, &ENTRY_TOURIZE_4416339355326535837)],
        &[(0b01001, &ENTRY_TOURIZES_16287459104895480818)],
    ],
    range: 3..=5,
};

static VARS_TOT_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TOT_CHILDREN),
    value: None,
};

pub static VARS_TOT_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aled"),
        dictgen::InsensitiveStr::Ascii("aler"),
        dictgen::InsensitiveStr::Ascii("alers"),
        dictgen::InsensitiveStr::Ascii("aling"),
        dictgen::InsensitiveStr::Ascii("alisation"),
        dictgen::InsensitiveStr::Ascii("alisations"),
        dictgen::InsensitiveStr::Ascii("alisator"),
        dictgen::InsensitiveStr::Ascii("alisators"),
        dictgen::InsensitiveStr::Ascii("alise"),
        dictgen::InsensitiveStr::Ascii("alised"),
        dictgen::InsensitiveStr::Ascii("aliser"),
        dictgen::InsensitiveStr::Ascii("alisers"),
        dictgen::InsensitiveStr::Ascii("alises"),
        dictgen::InsensitiveStr::Ascii("alising"),
        dictgen::InsensitiveStr::Ascii("alitarianise"),
        dictgen::InsensitiveStr::Ascii("alitarianize"),
        dictgen::InsensitiveStr::Ascii("alization"),
        dictgen::InsensitiveStr::Ascii("alizations"),
        dictgen::InsensitiveStr::Ascii("alizator"),
        dictgen::InsensitiveStr::Ascii("alizators"),
        dictgen::InsensitiveStr::Ascii("alize"),
        dictgen::InsensitiveStr::Ascii("alized"),
        dictgen::InsensitiveStr::Ascii("alizer"),
        dictgen::InsensitiveStr::Ascii("alizers"),
        dictgen::InsensitiveStr::Ascii("alizes"),
        dictgen::InsensitiveStr::Ascii("alizing"),
        dictgen::InsensitiveStr::Ascii("alled"),
        dictgen::InsensitiveStr::Ascii("aller"),
        dictgen::InsensitiveStr::Ascii("allers"),
        dictgen::InsensitiveStr::Ascii("alling"),
        dictgen::InsensitiveStr::Ascii("emisation"),
        dictgen::InsensitiveStr::Ascii("emisations"),
        dictgen::InsensitiveStr::Ascii("emization"),
        dictgen::InsensitiveStr::Ascii("emizations"),
    ],
    values: &[
        &[(0b00001, &ENTRY_TOTALED_6013017983757467705)],
        &[(0b00001, &ENTRY_TOTALER_10727979907060022636)],
        &[(0b00001, &ENTRY_TOTALERS_3867797254055796802)],
        &[(0b00001, &ENTRY_TOTALING_9913720993762819432)],
        &[(0b10010, &ENTRY_TOTALIZATION_3221716119411894800)],
        &[(0b10010, &ENTRY_TOTALIZATIONS_16093531371594133063)],
        &[(0b11010, &ENTRY_TOTALIZATOR_8226180587584060233)],
        &[(0b11010, &ENTRY_TOTALIZATORS_8640164609623735800)],
        &[(0b10010, &ENTRY_TOTALIZE_2473362082375699734)],
        &[(0b10010, &ENTRY_TOTALIZED_13767793031901840125)],
        &[(0b10010, &ENTRY_TOTALIZER_10517738673224079027)],
        &[(0b10010, &ENTRY_TOTALIZERS_15548921713961085912)],
        &[(0b10010, &ENTRY_TOTALIZES_6721705970426925276)],
        &[(0b10010, &ENTRY_TOTALIZING_11500628009269088151)],
        &[(0b10010, &ENTRY_TOTALITARIANIZE_8599233737485608940)],
        &[(0b01001, &ENTRY_TOTALITARIANIZE_8599233737485608940)],
        &[(0b01001, &ENTRY_TOTALIZATION_3221716119411894800)],
        &[(0b01001, &ENTRY_TOTALIZATIONS_16093531371594133063)],
        &[(0b00001, &ENTRY_TOTALIZATOR_8226180587584060233)],
        &[(0b00001, &ENTRY_TOTALIZATORS_8640164609623735800)],
        &[(0b01001, &ENTRY_TOTALIZE_2473362082375699734)],
        &[(0b01001, &ENTRY_TOTALIZED_13767793031901840125)],
        &[(0b01001, &ENTRY_TOTALIZER_10517738673224079027)],
        &[(0b01001, &ENTRY_TOTALIZERS_15548921713961085912)],
        &[(0b01001, &ENTRY_TOTALIZES_6721705970426925276)],
        &[(0b01001, &ENTRY_TOTALIZING_11500628009269088151)],
        &[(0b11010, &ENTRY_TOTALED_6013017983757467705)],
        &[(0b11010, &ENTRY_TOTALER_10727979907060022636)],
        &[(0b11010, &ENTRY_TOTALERS_3867797254055796802)],
        &[(0b11010, &ENTRY_TOTALING_9913720993762819432)],
        &[(0b10010, &ENTRY_TOTEMIZATION_17547511589554648221)],
        &[(0b10010, &ENTRY_TOTEMIZATIONS_4524480269908097645)],
        &[(0b01001, &ENTRY_TOTEMIZATION_17547511589554648221)],
        &[(0b01001, &ENTRY_TOTEMIZATIONS_4524480269908097645)],
    ],
    range: 4..=12,
};

static VARS_TOR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TOR_CHILDREN),
    value: None,
};

pub static VARS_TOR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("et"),
        dictgen::InsensitiveStr::Ascii("porise"),
        dictgen::InsensitiveStr::Ascii("porises"),
        dictgen::InsensitiveStr::Ascii("porize"),
        dictgen::InsensitiveStr::Ascii("porizes"),
        dictgen::InsensitiveStr::Ascii("yise"),
        dictgen::InsensitiveStr::Ascii("yises"),
        dictgen::InsensitiveStr::Ascii("yize"),
        dictgen::InsensitiveStr::Ascii("yizes"),
    ],
    values: &[
        &[(0b00001, &ENTRY_TORET_14642122393715101008)],
        &[(0b10010, &ENTRY_TORPORIZE_18297824631247427015)],
        &[(0b10010, &ENTRY_TORPORIZES_7515131355757541341)],
        &[(0b01001, &ENTRY_TORPORIZE_18297824631247427015)],
        &[(0b01001, &ENTRY_TORPORIZES_7515131355757541341)],
        &[(0b10010, &ENTRY_TORYIZE_10210463142410101593)],
        &[(0b10010, &ENTRY_TORYIZES_2714307057530869042)],
        &[(0b01001, &ENTRY_TORYIZE_10210463142410101593)],
        &[(0b01001, &ENTRY_TORYIZES_2714307057530869042)],
    ],
    range: 2..=7,
};

static VARS_TOP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TOP_CHILDREN),
    value: None,
};

pub static VARS_TOP_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aesthesia"),
        dictgen::InsensitiveStr::Ascii("esthesia"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TOPESTHESIA_9952864993680466403)],
        &[(0b00001, &ENTRY_TOPESTHESIA_9952864993680466403)],
    ],
    range: 8..=9,
};

static VARS_TON_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TON_CHILDREN),
    value: None,
};

pub static VARS_TON_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("icise"),
        dictgen::InsensitiveStr::Ascii("icises"),
        dictgen::InsensitiveStr::Ascii("icize"),
        dictgen::InsensitiveStr::Ascii("icizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TONICIZE_2289940295082319741)],
        &[(0b10010, &ENTRY_TONICIZES_17805405285162444673)],
        &[(0b01001, &ENTRY_TONICIZE_2289940295082319741)],
        &[(0b01001, &ENTRY_TONICIZES_17805405285162444673)],
    ],
    range: 5..=6,
};

static VARS_TI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TI_CHILDREN),
    value: None,
};

pub static VARS_TI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("dbit"),
        dictgen::InsensitiveStr::Ascii("dbits"),
        dictgen::InsensitiveStr::Ascii("llford"),
        dictgen::InsensitiveStr::Ascii("llfourd"),
        dictgen::InsensitiveStr::Ascii("monise"),
        dictgen::InsensitiveStr::Ascii("monised"),
        dictgen::InsensitiveStr::Ascii("monises"),
        dictgen::InsensitiveStr::Ascii("monising"),
        dictgen::InsensitiveStr::Ascii("monize"),
        dictgen::InsensitiveStr::Ascii("monized"),
        dictgen::InsensitiveStr::Ascii("monizes"),
        dictgen::InsensitiveStr::Ascii("monizing"),
        dictgen::InsensitiveStr::Ascii("mor"),
        dictgen::InsensitiveStr::Ascii("mour"),
        dictgen::InsensitiveStr::Ascii("nseled"),
        dictgen::InsensitiveStr::Ascii("nselier"),
        dictgen::InsensitiveStr::Ascii("nseliest"),
        dictgen::InsensitiveStr::Ascii("nseling"),
        dictgen::InsensitiveStr::Ascii("nselled"),
        dictgen::InsensitiveStr::Ascii("nsellier"),
        dictgen::InsensitiveStr::Ascii("nselliest"),
        dictgen::InsensitiveStr::Ascii("nselling"),
        dictgen::InsensitiveStr::Ascii("tbit"),
        dictgen::InsensitiveStr::Ascii("tbits"),
        dictgen::InsensitiveStr::Ascii("ter"),
        dictgen::InsensitiveStr::Ascii("ters"),
        dictgen::InsensitiveStr::Ascii("tre"),
        dictgen::InsensitiveStr::Ascii("tres"),
        dictgen::InsensitiveStr::Ascii("ttuped"),
        dictgen::InsensitiveStr::Ascii("ttuping"),
        dictgen::InsensitiveStr::Ascii("ttupped"),
        dictgen::InsensitiveStr::Ascii("ttupping"),
        dictgen::InsensitiveStr::Ascii("ttuppy"),
        dictgen::InsensitiveStr::Ascii("ttupy"),
    ],
    values: &[
        &[(0b01001, &ENTRY_TIDBIT_14858433395468188521)],
        &[(0b01001, &ENTRY_TIDBITS_8862313789168390887)],
        &[(0b00001, &ENTRY_TILLFORD_13927963203563990910)],
        &[(0b11010, &ENTRY_TILLFORD_13927963203563990910)],
        &[(0b10010, &ENTRY_TIMONIZE_4384316048230541265)],
        &[(0b10010, &ENTRY_TIMONIZED_3807325960951210177)],
        &[(0b10010, &ENTRY_TIMONIZES_16589660513575137498)],
        &[(0b10010, &ENTRY_TIMONIZING_13953660282542190706)],
        &[(0b01001, &ENTRY_TIMONIZE_4384316048230541265)],
        &[(0b01001, &ENTRY_TIMONIZED_3807325960951210177)],
        &[(0b01001, &ENTRY_TIMONIZES_16589660513575137498)],
        &[(0b01001, &ENTRY_TIMONIZING_13953660282542190706)],
        &[(0b00001, &ENTRY_TIMOR_2867687196301196005)],
        &[(0b11010, &ENTRY_TIMOR_2867687196301196005)],
        &[(0b01001, &ENTRY_TINSELED_9574695065168366382)],
        &[(0b00001, &ENTRY_TINSELIER_17862744387346717732)],
        &[(0b00001, &ENTRY_TINSELIEST_10796385662191046623)],
        &[(0b01001, &ENTRY_TINSELING_15422200188036739484)],
        &[(0b11010, &ENTRY_TINSELED_9574695065168366382)],
        &[(0b11010, &ENTRY_TINSELIER_17862744387346717732)],
        &[(0b11010, &ENTRY_TINSELIEST_10796385662191046623)],
        &[(0b11010, &ENTRY_TINSELING_15422200188036739484)],
        &[(0b10011, &ENTRY_TIDBIT_14858433395468188521)],
        &[(0b10011, &ENTRY_TIDBITS_8862313789168390887)],
        &[(0b01001, &ENTRY_TITER_3432959079810131995)],
        &[(0b01001, &ENTRY_TITERS_16256818623137143269)],
        &[(0b11010, &ENTRY_TITER_3432959079810131995)],
        &[(0b11010, &ENTRY_TITERS_16256818623137143269)],
        &[(0b00001, &ENTRY_TITTUPED_18032143166294150502)],
        &[(0b00001, &ENTRY_TITTUPING_5945965916177916410)],
        &[(0b11010, &ENTRY_TITTUPED_18032143166294150502)],
        &[(0b11010, &ENTRY_TITTUPING_5945965916177916410)],
        &[(0b11010, &ENTRY_TITTUPY_1440027282222835899)],
        &[(0b00001, &ENTRY_TITTUPY_1440027282222835899)],
    ],
    range: 3..=9,
};

static VARS_TH_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_TH_CHILDREN),
    value: None,
};

static VARS_TH_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_THA_NODE),
    None,
    None,
    None,
    Some(&VARS_THE_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_THR_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_THY_NODE),
    None,
];

static VARS_THY_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_THY_CHILDREN),
    value: None,
};

pub static VARS_THY_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("mectomise"),
        dictgen::InsensitiveStr::Ascii("mectomize"),
        dictgen::InsensitiveStr::Ascii("roidectomised"),
        dictgen::InsensitiveStr::Ascii("roidectomized"),
        dictgen::InsensitiveStr::Ascii("roidisation"),
        dictgen::InsensitiveStr::Ascii("roidisations"),
        dictgen::InsensitiveStr::Ascii("roidization"),
        dictgen::InsensitiveStr::Ascii("roidizations"),
    ],
    values: &[
        &[(0b10010, &ENTRY_THYMECTOMIZE_9188848309665571694)],
        &[(0b01001, &ENTRY_THYMECTOMIZE_9188848309665571694)],
        &[(0b10010, &ENTRY_THYROIDECTOMIZED_18037313633331374041)],
        &[(0b01001, &ENTRY_THYROIDECTOMIZED_18037313633331374041)],
        &[(0b10010, &ENTRY_THYROIDIZATION_6148181864988263565)],
        &[(0b10010, &ENTRY_THYROIDIZATIONS_15147067345688634277)],
        &[(0b01001, &ENTRY_THYROIDIZATION_6148181864988263565)],
        &[(0b01001, &ENTRY_THYROIDIZATIONS_15147067345688634277)],
    ],
    range: 9..=13,
};

static VARS_THR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_THR_CHILDREN),
    value: None,
};

pub static VARS_THR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eap"),
        dictgen::InsensitiveStr::Ascii("eeness"),
        dictgen::InsensitiveStr::Ascii("eenesses"),
        dictgen::InsensitiveStr::Ascii("onise"),
        dictgen::InsensitiveStr::Ascii("onises"),
        dictgen::InsensitiveStr::Ascii("onize"),
        dictgen::InsensitiveStr::Ascii("onizes"),
        dictgen::InsensitiveStr::Ascii("u"),
        dictgen::InsensitiveStr::Ascii("uway"),
        dictgen::InsensitiveStr::Ascii("uways"),
    ],
    values: &[
        &[(0b11010, &ENTRY_THERAP_12439233534474368057)],
        &[(0b11010, &ENTRY_THERENESS_15920110764314066574)],
        &[(0b11010, &ENTRY_THERENESSES_12088887261810562814)],
        &[(0b10010, &ENTRY_THRONIZE_6821227400136957234)],
        &[(0b10010, &ENTRY_THRONIZES_12549201774820221034)],
        &[(0b01001, &ENTRY_THRONIZE_6821227400136957234)],
        &[(0b01001, &ENTRY_THRONIZES_12549201774820221034)],
        &[(0b00001, &ENTRY_THROUGH_13450103710029067577)],
        &[(0b10011, &ENTRY_THRUWAY_8791794387715289057)],
        &[(0b10011, &ENTRY_THRUWAYS_949399170587990036)],
    ],
    range: 1..=8,
};

static VARS_THE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_THE_CHILDREN),
    value: None,
};

static VARS_THE_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_THEA_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_THEO_NODE),
    None,
    None,
    Some(&VARS_THER_NODE),
    Some(&VARS_THES_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_THES_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_THES_CHILDREN),
    value: None,
};

pub static VARS_THES_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("mothetae"),
        dictgen::InsensitiveStr::Ascii("mothete"),
    ],
    values: &[
        &[(0b11010, &ENTRY_THESMOTHETE_5962250708932328706)],
        &[(0b00001, &ENTRY_THESMOTHETE_5962250708932328706)],
    ],
    range: 7..=8,
};

static VARS_THER_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_THER_CHILDREN),
    value: None,
};

pub static VARS_THER_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ap"),
        dictgen::InsensitiveStr::Ascii("eness"),
        dictgen::InsensitiveStr::Ascii("enesses"),
        dictgen::InsensitiveStr::Ascii("mae"),
        dictgen::InsensitiveStr::Ascii("malisation"),
        dictgen::InsensitiveStr::Ascii("malisations"),
        dictgen::InsensitiveStr::Ascii("malise"),
        dictgen::InsensitiveStr::Ascii("malised"),
        dictgen::InsensitiveStr::Ascii("malises"),
        dictgen::InsensitiveStr::Ascii("malising"),
        dictgen::InsensitiveStr::Ascii("malization"),
        dictgen::InsensitiveStr::Ascii("malizations"),
        dictgen::InsensitiveStr::Ascii("malize"),
        dictgen::InsensitiveStr::Ascii("malized"),
        dictgen::InsensitiveStr::Ascii("malizes"),
        dictgen::InsensitiveStr::Ascii("malizing"),
        dictgen::InsensitiveStr::Ascii("me"),
        dictgen::InsensitiveStr::Ascii("mesthesia"),
        dictgen::InsensitiveStr::Ascii("moanaesthesia"),
        dictgen::InsensitiveStr::Ascii("moanaesthesias"),
        dictgen::InsensitiveStr::Ascii("moanesthesia"),
        dictgen::InsensitiveStr::Ascii("moanesthesias"),
        dictgen::InsensitiveStr::Ascii("mometerise"),
        dictgen::InsensitiveStr::Ascii("mometerises"),
        dictgen::InsensitiveStr::Ascii("mometerize"),
        dictgen::InsensitiveStr::Ascii("mometerizes"),
        dictgen::InsensitiveStr::Ascii("mopolymerisation"),
        dictgen::InsensitiveStr::Ascii("mopolymerisations"),
        dictgen::InsensitiveStr::Ascii("mopolymerization"),
        dictgen::InsensitiveStr::Ascii("mopolymerizations"),
        dictgen::InsensitiveStr::Ascii("mosiphon"),
        dictgen::InsensitiveStr::Ascii("mosiphons"),
        dictgen::InsensitiveStr::Ascii("mosyphon"),
        dictgen::InsensitiveStr::Ascii("mosyphons"),
    ],
    values: &[
        &[(0b00001, &ENTRY_THERAP_12439233534474368057)],
        &[(0b00001, &ENTRY_THERENESS_15920110764314066574)],
        &[(0b00001, &ENTRY_THERENESSES_12088887261810562814)],
        &[(0b11010, &ENTRY_THERME_8882059819611896240)],
        &[(0b10010, &ENTRY_THERMALIZATION_7024136436456711519)],
        &[(0b10010, &ENTRY_THERMALIZATIONS_14303369656181821634)],
        &[(0b10010, &ENTRY_THERMALIZE_953829933095771497)],
        &[(0b10010, &ENTRY_THERMALIZED_691663227486729890)],
        &[(0b10010, &ENTRY_THERMALIZES_14481137627377672474)],
        &[(0b10010, &ENTRY_THERMALIZING_8673243577457624256)],
        &[(0b01001, &ENTRY_THERMALIZATION_7024136436456711519)],
        &[(0b01001, &ENTRY_THERMALIZATIONS_14303369656181821634)],
        &[(0b01001, &ENTRY_THERMALIZE_953829933095771497)],
        &[(0b01001, &ENTRY_THERMALIZED_691663227486729890)],
        &[(0b01001, &ENTRY_THERMALIZES_14481137627377672474)],
        &[(0b01001, &ENTRY_THERMALIZING_8673243577457624256)],
        &[(0b00001, &ENTRY_THERME_8882059819611896240)],
        &[(0b00001, &ENTRY_THERMESTHESIA_11561525220243242262)],
        &[(0b11010, &ENTRY_THERMOANESTHESIA_4092307643640683807)],
        &[(0b11010, &ENTRY_THERMOANESTHESIAS_1807836102271064111)],
        &[(0b00001, &ENTRY_THERMOANESTHESIA_4092307643640683807)],
        &[(0b00001, &ENTRY_THERMOANESTHESIAS_1807836102271064111)],
        &[(0b10010, &ENTRY_THERMOMETERIZE_15998653899602520685)],
        &[(0b10010, &ENTRY_THERMOMETERIZES_10840283776322209379)],
        &[(0b01001, &ENTRY_THERMOMETERIZE_15998653899602520685)],
        &[(0b01001, &ENTRY_THERMOMETERIZES_10840283776322209379)],
        &[(0b10010, &ENTRY_THERMOPOLYMERIZATION_10433431029598912285)],
        &[(0b10010, &ENTRY_THERMOPOLYMERIZATIONS_3651245684619525553)],
        &[(0b01001, &ENTRY_THERMOPOLYMERIZATION_10433431029598912285)],
        &[(0b01001, &ENTRY_THERMOPOLYMERIZATIONS_3651245684619525553)],
        &[(0b00001, &ENTRY_THERMOSIPHON_9621111130028620625)],
        &[(0b00001, &ENTRY_THERMOSIPHONS_179083683317180105)],
        &[(0b11010, &ENTRY_THERMOSIPHON_9621111130028620625)],
        &[(0b11010, &ENTRY_THERMOSIPHONS_179083683317180105)],
    ],
    range: 2..=17,
};

static VARS_THEO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_THEO_CHILDREN),
    value: None,
};

pub static VARS_THEO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("logisation"),
        dictgen::InsensitiveStr::Ascii("logisations"),
        dictgen::InsensitiveStr::Ascii("logise"),
        dictgen::InsensitiveStr::Ascii("logised"),
        dictgen::InsensitiveStr::Ascii("logiser"),
        dictgen::InsensitiveStr::Ascii("logisers"),
        dictgen::InsensitiveStr::Ascii("logises"),
        dictgen::InsensitiveStr::Ascii("logising"),
        dictgen::InsensitiveStr::Ascii("logization"),
        dictgen::InsensitiveStr::Ascii("logizations"),
        dictgen::InsensitiveStr::Ascii("logize"),
        dictgen::InsensitiveStr::Ascii("logized"),
        dictgen::InsensitiveStr::Ascii("logizer"),
        dictgen::InsensitiveStr::Ascii("logizers"),
        dictgen::InsensitiveStr::Ascii("logizes"),
        dictgen::InsensitiveStr::Ascii("logizing"),
        dictgen::InsensitiveStr::Ascii("ne"),
        dictgen::InsensitiveStr::Ascii("noe"),
        dictgen::InsensitiveStr::Ascii("risation"),
        dictgen::InsensitiveStr::Ascii("risations"),
        dictgen::InsensitiveStr::Ascii("rise"),
        dictgen::InsensitiveStr::Ascii("rised"),
        dictgen::InsensitiveStr::Ascii("riser"),
        dictgen::InsensitiveStr::Ascii("risers"),
        dictgen::InsensitiveStr::Ascii("rises"),
        dictgen::InsensitiveStr::Ascii("rising"),
        dictgen::InsensitiveStr::Ascii("rization"),
        dictgen::InsensitiveStr::Ascii("rizations"),
        dictgen::InsensitiveStr::Ascii("rize"),
        dictgen::InsensitiveStr::Ascii("rized"),
        dictgen::InsensitiveStr::Ascii("rizer"),
        dictgen::InsensitiveStr::Ascii("rizers"),
        dictgen::InsensitiveStr::Ascii("rizes"),
        dictgen::InsensitiveStr::Ascii("rizing"),
        dictgen::InsensitiveStr::Ascii("sophise"),
        dictgen::InsensitiveStr::Ascii("sophised"),
        dictgen::InsensitiveStr::Ascii("sophises"),
        dictgen::InsensitiveStr::Ascii("sophising"),
        dictgen::InsensitiveStr::Ascii("sophize"),
        dictgen::InsensitiveStr::Ascii("sophized"),
        dictgen::InsensitiveStr::Ascii("sophizes"),
        dictgen::InsensitiveStr::Ascii("sophizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_THEOLOGIZATION_3184169504141390704)],
        &[(0b10010, &ENTRY_THEOLOGIZATIONS_1637833144071496386)],
        &[(0b10010, &ENTRY_THEOLOGIZE_7414032072871637264)],
        &[(0b10010, &ENTRY_THEOLOGIZED_15275657420605826847)],
        &[(0b10010, &ENTRY_THEOLOGIZER_18105337442480749750)],
        &[(0b10010, &ENTRY_THEOLOGIZERS_16421415494739610563)],
        &[(0b10010, &ENTRY_THEOLOGIZES_6187402845034207250)],
        &[(0b10010, &ENTRY_THEOLOGIZING_1522552502275961571)],
        &[(0b01001, &ENTRY_THEOLOGIZATION_3184169504141390704)],
        &[(0b01001, &ENTRY_THEOLOGIZATIONS_1637833144071496386)],
        &[(0b01001, &ENTRY_THEOLOGIZE_7414032072871637264)],
        &[(0b01001, &ENTRY_THEOLOGIZED_15275657420605826847)],
        &[(0b01001, &ENTRY_THEOLOGIZER_18105337442480749750)],
        &[(0b01001, &ENTRY_THEOLOGIZERS_16421415494739610563)],
        &[(0b01001, &ENTRY_THEOLOGIZES_6187402845034207250)],
        &[(0b01001, &ENTRY_THEOLOGIZING_1522552502275961571)],
        &[(0b00001, &ENTRY_THEONE_13907392324350936871)],
        &[(0b11010, &ENTRY_THEONE_13907392324350936871)],
        &[(0b10010, &ENTRY_THEORIZATION_16280749314428462916)],
        &[(0b10010, &ENTRY_THEORIZATIONS_1710707944075838400)],
        &[(0b10010, &ENTRY_THEORIZE_16592272841946174715)],
        &[(0b10010, &ENTRY_THEORIZED_12643356280684289637)],
        &[(0b10010, &ENTRY_THEORIZER_11654654415951381825)],
        &[(0b10010, &ENTRY_THEORIZERS_17644565410392015986)],
        &[(0b10010, &ENTRY_THEORIZES_1097471905147904168)],
        &[(0b10010, &ENTRY_THEORIZING_10670219570353826885)],
        &[(0b01001, &ENTRY_THEORIZATION_16280749314428462916)],
        &[(0b01001, &ENTRY_THEORIZATIONS_1710707944075838400)],
        &[(0b01001, &ENTRY_THEORIZE_16592272841946174715)],
        &[(0b01001, &ENTRY_THEORIZED_12643356280684289637)],
        &[(0b01001, &ENTRY_THEORIZER_11654654415951381825)],
        &[(0b01001, &ENTRY_THEORIZERS_17644565410392015986)],
        &[(0b01001, &ENTRY_THEORIZES_1097471905147904168)],
        &[(0b01001, &ENTRY_THEORIZING_10670219570353826885)],
        &[(0b10010, &ENTRY_THEOSOPHIZE_7321146857183593825)],
        &[(0b10010, &ENTRY_THEOSOPHIZED_16449992798183475453)],
        &[(0b10010, &ENTRY_THEOSOPHIZES_1158826125232789362)],
        &[(0b10010, &ENTRY_THEOSOPHIZING_16087803010212187991)],
        &[(0b01001, &ENTRY_THEOSOPHIZE_7321146857183593825)],
        &[(0b01001, &ENTRY_THEOSOPHIZED_16449992798183475453)],
        &[(0b01001, &ENTRY_THEOSOPHIZES_1158826125232789362)],
        &[(0b01001, &ENTRY_THEOSOPHIZING_16087803010212187991)],
    ],
    range: 2..=11,
};

static VARS_THEA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_THEA_CHILDREN),
    value: None,
};

pub static VARS_THEA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ter"),
        dictgen::InsensitiveStr::Ascii("tergoer"),
        dictgen::InsensitiveStr::Ascii("tergoers"),
        dictgen::InsensitiveStr::Ascii("tergoing"),
        dictgen::InsensitiveStr::Ascii("tergoings"),
        dictgen::InsensitiveStr::Ascii("terless"),
        dictgen::InsensitiveStr::Ascii("terlesses"),
        dictgen::InsensitiveStr::Ascii("terlike"),
        dictgen::InsensitiveStr::Ascii("terlikes"),
        dictgen::InsensitiveStr::Ascii("ters"),
        dictgen::InsensitiveStr::Ascii("tre"),
        dictgen::InsensitiveStr::Ascii("tregoer"),
        dictgen::InsensitiveStr::Ascii("tregoers"),
        dictgen::InsensitiveStr::Ascii("tregoing"),
        dictgen::InsensitiveStr::Ascii("tregoings"),
        dictgen::InsensitiveStr::Ascii("treless"),
        dictgen::InsensitiveStr::Ascii("trelesses"),
        dictgen::InsensitiveStr::Ascii("trelike"),
        dictgen::InsensitiveStr::Ascii("trelikes"),
        dictgen::InsensitiveStr::Ascii("tres"),
        dictgen::InsensitiveStr::Ascii("tricalisation"),
        dictgen::InsensitiveStr::Ascii("tricalisations"),
        dictgen::InsensitiveStr::Ascii("tricalise"),
        dictgen::InsensitiveStr::Ascii("tricalised"),
        dictgen::InsensitiveStr::Ascii("tricalises"),
        dictgen::InsensitiveStr::Ascii("tricalising"),
        dictgen::InsensitiveStr::Ascii("tricalization"),
        dictgen::InsensitiveStr::Ascii("tricalizations"),
        dictgen::InsensitiveStr::Ascii("tricalize"),
        dictgen::InsensitiveStr::Ascii("tricalized"),
        dictgen::InsensitiveStr::Ascii("tricalizes"),
        dictgen::InsensitiveStr::Ascii("tricalizing"),
        dictgen::InsensitiveStr::Ascii("tricise"),
        dictgen::InsensitiveStr::Ascii("tricised"),
        dictgen::InsensitiveStr::Ascii("tricises"),
        dictgen::InsensitiveStr::Ascii("tricising"),
        dictgen::InsensitiveStr::Ascii("tricize"),
        dictgen::InsensitiveStr::Ascii("tricized"),
        dictgen::InsensitiveStr::Ascii("tricizes"),
        dictgen::InsensitiveStr::Ascii("tricizing"),
    ],
    values: &[
        &[(0b01001, &ENTRY_THEATER_14872060673613944088)],
        &[(0b00001, &ENTRY_THEATERGOER_12049893135886436399)],
        &[(0b00001, &ENTRY_THEATERGOERS_8549242292576792477)],
        &[(0b00001, &ENTRY_THEATERGOING_9036609633778609239)],
        &[(0b00001, &ENTRY_THEATERGOINGS_6740435645328474541)],
        &[(0b00001, &ENTRY_THEATERLESS_6418669943810866547)],
        &[(0b00001, &ENTRY_THEATERLESSES_4394383213563812217)],
        &[(0b00001, &ENTRY_THEATERLIKE_8843571728412345332)],
        &[(0b00001, &ENTRY_THEATERLIKES_14410484446681772640)],
        &[(0b01001, &ENTRY_THEATERS_8074723073047846943)],
        &[(0b11010, &ENTRY_THEATER_14872060673613944088)],
        &[(0b11010, &ENTRY_THEATERGOER_12049893135886436399)],
        &[(0b11010, &ENTRY_THEATERGOERS_8549242292576792477)],
        &[(0b11010, &ENTRY_THEATERGOING_9036609633778609239)],
        &[(0b11010, &ENTRY_THEATERGOINGS_6740435645328474541)],
        &[(0b11010, &ENTRY_THEATERLESS_6418669943810866547)],
        &[(0b11010, &ENTRY_THEATERLESSES_4394383213563812217)],
        &[(0b11010, &ENTRY_THEATERLIKE_8843571728412345332)],
        &[(0b11010, &ENTRY_THEATERLIKES_14410484446681772640)],
        &[(0b11010, &ENTRY_THEATERS_8074723073047846943)],
        &[(0b10010, &ENTRY_THEATRICALIZATION_8726932104691046566)],
        &[(0b10010, &ENTRY_THEATRICALIZATIONS_568370628365365537)],
        &[(0b10010, &ENTRY_THEATRICALIZE_7863949736369468171)],
        &[(0b10010, &ENTRY_THEATRICALIZED_1546831350777799151)],
        &[(0b10010, &ENTRY_THEATRICALIZES_16567523932139571310)],
        &[(0b10010, &ENTRY_THEATRICALIZING_4463754121398572674)],
        &[(0b01001, &ENTRY_THEATRICALIZATION_8726932104691046566)],
        &[(0b01001, &ENTRY_THEATRICALIZATIONS_568370628365365537)],
        &[(0b01001, &ENTRY_THEATRICALIZE_7863949736369468171)],
        &[(0b01001, &ENTRY_THEATRICALIZED_1546831350777799151)],
        &[(0b01001, &ENTRY_THEATRICALIZES_16567523932139571310)],
        &[(0b01001, &ENTRY_THEATRICALIZING_4463754121398572674)],
        &[(0b10010, &ENTRY_THEATRICIZE_14394131727190869494)],
        &[(0b10010, &ENTRY_THEATRICIZED_14255451360235022416)],
        &[(0b10010, &ENTRY_THEATRICIZES_6355456595406057113)],
        &[(0b10010, &ENTRY_THEATRICIZING_9815086289375498796)],
        &[(0b01001, &ENTRY_THEATRICIZE_14394131727190869494)],
        &[(0b01001, &ENTRY_THEATRICIZED_14255451360235022416)],
        &[(0b01001, &ENTRY_THEATRICIZES_6355456595406057113)],
        &[(0b01001, &ENTRY_THEATRICIZING_9815086289375498796)],
    ],
    range: 3..=14,
};

static VARS_THA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_THA_CHILDREN),
    value: None,
};

pub static VARS_THA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lamocele"),
        dictgen::InsensitiveStr::Ascii("lamocoele"),
        dictgen::InsensitiveStr::Ascii("lassaemia"),
        dictgen::InsensitiveStr::Ascii("lassaemias"),
        dictgen::InsensitiveStr::Ascii("lassaemic"),
        dictgen::InsensitiveStr::Ascii("lassemia"),
        dictgen::InsensitiveStr::Ascii("lassemias"),
        dictgen::InsensitiveStr::Ascii("lassemic"),
    ],
    values: &[
        &[(0b00001, &ENTRY_THALAMOCELE_5766303350223704636)],
        &[(0b11010, &ENTRY_THALAMOCELE_5766303350223704636)],
        &[(0b11010, &ENTRY_THALASSEMIA_11647657111797513703)],
        &[(0b11010, &ENTRY_THALASSEMIAS_2823805934181113644)],
        &[(0b11010, &ENTRY_THALASSEMIC_4524955441481070676)],
        &[(0b00001, &ENTRY_THALASSEMIA_11647657111797513703)],
        &[(0b00001, &ENTRY_THALASSEMIAS_2823805934181113644)],
        &[(0b00001, &ENTRY_THALASSEMIC_4524955441481070676)],
    ],
    range: 8..=10,
};

static VARS_TE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_TE_CHILDREN),
    value: Some(&[(0b00001, &ENTRY_TE_16963694388719213938)]),
};

static VARS_TE_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_TEA_NODE),
    Some(&VARS_TEB_NODE),
    Some(&VARS_TEC_NODE),
    None,
    Some(&VARS_TEE_NODE),
    None,
    Some(&VARS_TEG_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_TEL_NODE),
    Some(&VARS_TEM_NODE),
    Some(&VARS_TEN_NODE),
    None,
    None,
    None,
    Some(&VARS_TER_NODE),
    Some(&VARS_TES_NODE),
    Some(&VARS_TET_NODE),
    Some(&VARS_TEU_NODE),
    None,
    None,
    Some(&VARS_TEX_NODE),
    None,
    None,
];

static VARS_TEX_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TEX_CHILDREN),
    value: None,
};

pub static VARS_TEX_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("turise"),
        dictgen::InsensitiveStr::Ascii("turised"),
        dictgen::InsensitiveStr::Ascii("turises"),
        dictgen::InsensitiveStr::Ascii("turising"),
        dictgen::InsensitiveStr::Ascii("turize"),
        dictgen::InsensitiveStr::Ascii("turized"),
        dictgen::InsensitiveStr::Ascii("turizes"),
        dictgen::InsensitiveStr::Ascii("turizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TEXTURIZE_2101736980791874876)],
        &[(0b10010, &ENTRY_TEXTURIZED_13270620706415686595)],
        &[(0b10010, &ENTRY_TEXTURIZES_9031143232768038726)],
        &[(0b10010, &ENTRY_TEXTURIZING_12707124326299442433)],
        &[(0b01001, &ENTRY_TEXTURIZE_2101736980791874876)],
        &[(0b01001, &ENTRY_TEXTURIZED_13270620706415686595)],
        &[(0b01001, &ENTRY_TEXTURIZES_9031143232768038726)],
        &[(0b01001, &ENTRY_TEXTURIZING_12707124326299442433)],
    ],
    range: 6..=8,
};

static VARS_TEU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TEU_CHILDREN),
    value: None,
};

pub static VARS_TEU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("tonisation"),
        dictgen::InsensitiveStr::Ascii("tonise"),
        dictgen::InsensitiveStr::Ascii("tonised"),
        dictgen::InsensitiveStr::Ascii("tonises"),
        dictgen::InsensitiveStr::Ascii("tonising"),
        dictgen::InsensitiveStr::Ascii("tonization"),
        dictgen::InsensitiveStr::Ascii("tonize"),
        dictgen::InsensitiveStr::Ascii("tonized"),
        dictgen::InsensitiveStr::Ascii("tonizes"),
        dictgen::InsensitiveStr::Ascii("tonizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TEUTONIZATION_15254944975373981632)],
        &[(0b10010, &ENTRY_TEUTONIZE_2326197985184920584)],
        &[(0b10010, &ENTRY_TEUTONIZED_10064813533808905253)],
        &[(0b10010, &ENTRY_TEUTONIZES_3149749243463447607)],
        &[(0b10010, &ENTRY_TEUTONIZING_1726928371121949281)],
        &[(0b01001, &ENTRY_TEUTONIZATION_15254944975373981632)],
        &[(0b01001, &ENTRY_TEUTONIZE_2326197985184920584)],
        &[(0b01001, &ENTRY_TEUTONIZED_10064813533808905253)],
        &[(0b01001, &ENTRY_TEUTONIZES_3149749243463447607)],
        &[(0b01001, &ENTRY_TEUTONIZING_1726928371121949281)],
    ],
    range: 6..=10,
};

static VARS_TET_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TET_CHILDREN),
    value: None,
};

pub static VARS_TET_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("anisation"),
        dictgen::InsensitiveStr::Ascii("anisations"),
        dictgen::InsensitiveStr::Ascii("anise"),
        dictgen::InsensitiveStr::Ascii("anised"),
        dictgen::InsensitiveStr::Ascii("anises"),
        dictgen::InsensitiveStr::Ascii("anising"),
        dictgen::InsensitiveStr::Ascii("anization"),
        dictgen::InsensitiveStr::Ascii("anizations"),
        dictgen::InsensitiveStr::Ascii("anize"),
        dictgen::InsensitiveStr::Ascii("anized"),
        dictgen::InsensitiveStr::Ascii("anizes"),
        dictgen::InsensitiveStr::Ascii("anizing"),
        dictgen::InsensitiveStr::Ascii("rachlorethylene"),
        dictgen::InsensitiveStr::Ascii("rachlorethylenes"),
        dictgen::InsensitiveStr::Ascii("rachloroethylene"),
        dictgen::InsensitiveStr::Ascii("rachloroethylenes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TETANIZATION_577138016465980211)],
        &[(0b10010, &ENTRY_TETANIZATIONS_9830716338275193986)],
        &[(0b10010, &ENTRY_TETANIZE_13125818857178721563)],
        &[(0b10010, &ENTRY_TETANIZED_8313685340295551426)],
        &[(0b10010, &ENTRY_TETANIZES_18159463373230991034)],
        &[(0b10010, &ENTRY_TETANIZING_3169895590113377680)],
        &[(0b01001, &ENTRY_TETANIZATION_577138016465980211)],
        &[(0b01001, &ENTRY_TETANIZATIONS_9830716338275193986)],
        &[(0b01001, &ENTRY_TETANIZE_13125818857178721563)],
        &[(0b01001, &ENTRY_TETANIZED_8313685340295551426)],
        &[(0b01001, &ENTRY_TETANIZES_18159463373230991034)],
        &[(0b01001, &ENTRY_TETANIZING_3169895590113377680)],
        &[(0b00001, &ENTRY_TETRACHLORETHYLENE_12592700145144546851)],
        &[(0b00001, &ENTRY_TETRACHLORETHYLENES_3697002620069360563)],
        &[(0b11010, &ENTRY_TETRACHLORETHYLENE_12592700145144546851)],
        &[(0b11010, &ENTRY_TETRACHLORETHYLENES_3697002620069360563)],
    ],
    range: 5..=17,
};

static VARS_TES_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TES_CHILDREN),
    value: Some(&[(0b00001, &ENTRY_TES_5634224708893959490)]),
};

pub static VARS_TES_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("tae"),
        dictgen::InsensitiveStr::Ascii("te"),
        dictgen::InsensitiveStr::Ascii("timonialisation"),
        dictgen::InsensitiveStr::Ascii("timonialisations"),
        dictgen::InsensitiveStr::Ascii("timonialise"),
        dictgen::InsensitiveStr::Ascii("timonialised"),
        dictgen::InsensitiveStr::Ascii("timonialiser"),
        dictgen::InsensitiveStr::Ascii("timonialisers"),
        dictgen::InsensitiveStr::Ascii("timonialises"),
        dictgen::InsensitiveStr::Ascii("timonialising"),
        dictgen::InsensitiveStr::Ascii("timonialization"),
        dictgen::InsensitiveStr::Ascii("timonializations"),
        dictgen::InsensitiveStr::Ascii("timonialize"),
        dictgen::InsensitiveStr::Ascii("timonialized"),
        dictgen::InsensitiveStr::Ascii("timonializer"),
        dictgen::InsensitiveStr::Ascii("timonializers"),
        dictgen::InsensitiveStr::Ascii("timonializes"),
        dictgen::InsensitiveStr::Ascii("timonializing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TESTE_7681162770005306000)],
        &[(0b00001, &ENTRY_TESTE_7681162770005306000)],
        &[(0b10010, &ENTRY_TESTIMONIALIZATION_1997898483350721704)],
        &[(0b10010, &ENTRY_TESTIMONIALIZATIONS_10414109904662561931)],
        &[(0b10010, &ENTRY_TESTIMONIALIZE_18040418696714895280)],
        &[(0b10010, &ENTRY_TESTIMONIALIZED_12777074233080067891)],
        &[(0b10010, &ENTRY_TESTIMONIALIZER_5001418100017709831)],
        &[(0b10010, &ENTRY_TESTIMONIALIZERS_13860732262187670713)],
        &[(0b10010, &ENTRY_TESTIMONIALIZES_10551210801248918911)],
        &[(0b10010, &ENTRY_TESTIMONIALIZING_3438847121414565242)],
        &[(0b01001, &ENTRY_TESTIMONIALIZATION_1997898483350721704)],
        &[(0b01001, &ENTRY_TESTIMONIALIZATIONS_10414109904662561931)],
        &[(0b01001, &ENTRY_TESTIMONIALIZE_18040418696714895280)],
        &[(0b01001, &ENTRY_TESTIMONIALIZED_12777074233080067891)],
        &[(0b01001, &ENTRY_TESTIMONIALIZER_5001418100017709831)],
        &[(0b01001, &ENTRY_TESTIMONIALIZERS_13860732262187670713)],
        &[(0b01001, &ENTRY_TESTIMONIALIZES_10551210801248918911)],
        &[(0b01001, &ENTRY_TESTIMONIALIZING_3438847121414565242)],
    ],
    range: 2..=16,
};

static VARS_TER_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TER_CHILDREN),
    value: None,
};

pub static VARS_TER_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("f"),
        dictgen::InsensitiveStr::Ascii("ma"),
        dictgen::InsensitiveStr::Ascii("matic"),
        dictgen::InsensitiveStr::Ascii("minalisation"),
        dictgen::InsensitiveStr::Ascii("minalisations"),
        dictgen::InsensitiveStr::Ascii("minalised"),
        dictgen::InsensitiveStr::Ascii("minaliseds"),
        dictgen::InsensitiveStr::Ascii("minalization"),
        dictgen::InsensitiveStr::Ascii("minalizations"),
        dictgen::InsensitiveStr::Ascii("minalized"),
        dictgen::InsensitiveStr::Ascii("minalizeds"),
        dictgen::InsensitiveStr::Ascii("nise"),
        dictgen::InsensitiveStr::Ascii("nises"),
        dictgen::InsensitiveStr::Ascii("nize"),
        dictgen::InsensitiveStr::Ascii("nizes"),
        dictgen::InsensitiveStr::Ascii("rae"),
        dictgen::InsensitiveStr::Ascii("re"),
        dictgen::InsensitiveStr::Ascii("restrialise"),
        dictgen::InsensitiveStr::Ascii("restrialises"),
        dictgen::InsensitiveStr::Ascii("restrialize"),
        dictgen::InsensitiveStr::Ascii("restrializes"),
        dictgen::InsensitiveStr::Ascii("ritorialisation"),
        dictgen::InsensitiveStr::Ascii("ritorialisations"),
        dictgen::InsensitiveStr::Ascii("ritorialise"),
        dictgen::InsensitiveStr::Ascii("ritorialised"),
        dictgen::InsensitiveStr::Ascii("ritorialises"),
        dictgen::InsensitiveStr::Ascii("ritorialising"),
        dictgen::InsensitiveStr::Ascii("ritorialization"),
        dictgen::InsensitiveStr::Ascii("ritorializations"),
        dictgen::InsensitiveStr::Ascii("ritorialize"),
        dictgen::InsensitiveStr::Ascii("ritorialized"),
        dictgen::InsensitiveStr::Ascii("ritorializes"),
        dictgen::InsensitiveStr::Ascii("ritorializing"),
        dictgen::InsensitiveStr::Ascii("rorisation"),
        dictgen::InsensitiveStr::Ascii("rorisations"),
        dictgen::InsensitiveStr::Ascii("rorise"),
        dictgen::InsensitiveStr::Ascii("rorised"),
        dictgen::InsensitiveStr::Ascii("roriser"),
        dictgen::InsensitiveStr::Ascii("rorisers"),
        dictgen::InsensitiveStr::Ascii("rorises"),
        dictgen::InsensitiveStr::Ascii("rorising"),
        dictgen::InsensitiveStr::Ascii("rorization"),
        dictgen::InsensitiveStr::Ascii("rorizations"),
        dictgen::InsensitiveStr::Ascii("rorize"),
        dictgen::InsensitiveStr::Ascii("rorized"),
        dictgen::InsensitiveStr::Ascii("rorizer"),
        dictgen::InsensitiveStr::Ascii("rorizers"),
        dictgen::InsensitiveStr::Ascii("rorizes"),
        dictgen::InsensitiveStr::Ascii("rorizing"),
        dictgen::InsensitiveStr::Ascii("ts"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TEERS_11547310098132473650)],
        &[(0b00001, &ENTRY_TERF_3510176223973213714)],
        &[(0b00001, &ENTRY_TERMA_12658799001593884461)],
        &[(0b00001, &ENTRY_TERMATIC_575294056877958757)],
        &[(0b10010, &ENTRY_TERMINALIZATION_14611052621641252685)],
        &[(0b10010, &ENTRY_TERMINALIZATIONS_654995620005875057)],
        &[(0b10010, &ENTRY_TERMINALIZED_12792925211824477703)],
        &[(0b10010, &ENTRY_TERMINALIZEDS_7787606091951730758)],
        &[(0b01001, &ENTRY_TERMINALIZATION_14611052621641252685)],
        &[(0b01001, &ENTRY_TERMINALIZATIONS_654995620005875057)],
        &[(0b01001, &ENTRY_TERMINALIZED_12792925211824477703)],
        &[(0b01001, &ENTRY_TERMINALIZEDS_7787606091951730758)],
        &[(0b10010, &ENTRY_TERNIZE_2124050956550290721)],
        &[(0b10010, &ENTRY_TERNIZES_3262666584819248556)],
        &[(0b01001, &ENTRY_TERNIZE_2124050956550290721)],
        &[(0b01001, &ENTRY_TERNIZES_3262666584819248556)],
        &[(0b11010, &ENTRY_TERRE_8819349438187415807)],
        &[(0b00001, &ENTRY_TERRE_8819349438187415807)],
        &[(0b10010, &ENTRY_TERRESTRIALIZE_6347253160507775588)],
        &[(0b10010, &ENTRY_TERRESTRIALIZES_6624949095978395018)],
        &[(0b01001, &ENTRY_TERRESTRIALIZE_6347253160507775588)],
        &[(0b01001, &ENTRY_TERRESTRIALIZES_6624949095978395018)],
        &[(0b10010, &ENTRY_TERRITORIALIZATION_13612272693653351235)],
        &[(0b10010, &ENTRY_TERRITORIALIZATIONS_3176885729614090958)],
        &[(0b10010, &ENTRY_TERRITORIALIZE_7097746563170584866)],
        &[(0b10010, &ENTRY_TERRITORIALIZED_18010704841888125903)],
        &[(0b10010, &ENTRY_TERRITORIALIZES_8896187296510093610)],
        &[(0b10010, &ENTRY_TERRITORIALIZING_7836091817301256528)],
        &[(0b01001, &ENTRY_TERRITORIALIZATION_13612272693653351235)],
        &[(0b01001, &ENTRY_TERRITORIALIZATIONS_3176885729614090958)],
        &[(0b01001, &ENTRY_TERRITORIALIZE_7097746563170584866)],
        &[(0b01001, &ENTRY_TERRITORIALIZED_18010704841888125903)],
        &[(0b01001, &ENTRY_TERRITORIALIZES_8896187296510093610)],
        &[(0b01001, &ENTRY_TERRITORIALIZING_7836091817301256528)],
        &[(0b10010, &ENTRY_TERRORIZATION_12053144759218452192)],
        &[(0b10010, &ENTRY_TERRORIZATIONS_18287886849231369087)],
        &[(0b10010, &ENTRY_TERRORIZE_2182645348231356537)],
        &[(0b10010, &ENTRY_TERRORIZED_12855863820908113709)],
        &[(0b10010, &ENTRY_TERRORIZER_3790900356919417060)],
        &[(0b10010, &ENTRY_TERRORIZERS_15764303900614300931)],
        &[(0b10010, &ENTRY_TERRORIZES_7590151466698739569)],
        &[(0b10010, &ENTRY_TERRORIZING_13104103423474029961)],
        &[(0b01001, &ENTRY_TERRORIZATION_12053144759218452192)],
        &[(0b01001, &ENTRY_TERRORIZATIONS_18287886849231369087)],
        &[(0b01001, &ENTRY_TERRORIZE_2182645348231356537)],
        &[(0b01001, &ENTRY_TERRORIZED_12855863820908113709)],
        &[(0b01001, &ENTRY_TERRORIZER_3790900356919417060)],
        &[(0b01001, &ENTRY_TERRORIZERS_15764303900614300931)],
        &[(0b01001, &ENTRY_TERRORIZES_7590151466698739569)],
        &[(0b01001, &ENTRY_TERRORIZING_13104103423474029961)],
        &[(0b00001, &ENTRY_TERTS_15921222583797171907)],
    ],
    range: 1..=16,
};

static VARS_TEN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TEN_CHILDREN),
    value: None,
};

pub static VARS_TEN_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("derisation"),
        dictgen::InsensitiveStr::Ascii("derisations"),
        dictgen::InsensitiveStr::Ascii("derise"),
        dictgen::InsensitiveStr::Ascii("derised"),
        dictgen::InsensitiveStr::Ascii("deriser"),
        dictgen::InsensitiveStr::Ascii("derisers"),
        dictgen::InsensitiveStr::Ascii("derises"),
        dictgen::InsensitiveStr::Ascii("derising"),
        dictgen::InsensitiveStr::Ascii("derization"),
        dictgen::InsensitiveStr::Ascii("derizations"),
        dictgen::InsensitiveStr::Ascii("derize"),
        dictgen::InsensitiveStr::Ascii("derized"),
        dictgen::InsensitiveStr::Ascii("derizer"),
        dictgen::InsensitiveStr::Ascii("derizers"),
        dictgen::InsensitiveStr::Ascii("derizes"),
        dictgen::InsensitiveStr::Ascii("derizing"),
        dictgen::InsensitiveStr::Ascii("driled"),
        dictgen::InsensitiveStr::Ascii("drilled"),
        dictgen::InsensitiveStr::Ascii("ementisation"),
        dictgen::InsensitiveStr::Ascii("ementisations"),
        dictgen::InsensitiveStr::Ascii("ementise"),
        dictgen::InsensitiveStr::Ascii("ementises"),
        dictgen::InsensitiveStr::Ascii("ementization"),
        dictgen::InsensitiveStr::Ascii("ementizations"),
        dictgen::InsensitiveStr::Ascii("ementize"),
        dictgen::InsensitiveStr::Ascii("ementizes"),
        dictgen::InsensitiveStr::Ascii("ia"),
        dictgen::InsensitiveStr::Ascii("iacidal"),
        dictgen::InsensitiveStr::Ascii("iacide"),
        dictgen::InsensitiveStr::Ascii("iacides"),
        dictgen::InsensitiveStr::Ascii("iae"),
        dictgen::InsensitiveStr::Ascii("iafuge"),
        dictgen::InsensitiveStr::Ascii("iafuges"),
        dictgen::InsensitiveStr::Ascii("ias"),
        dictgen::InsensitiveStr::Ascii("iases"),
        dictgen::InsensitiveStr::Ascii("iasis"),
        dictgen::InsensitiveStr::Ascii("ioid"),
        dictgen::InsensitiveStr::Ascii("thmeter"),
        dictgen::InsensitiveStr::Ascii("thmetre"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TENDERIZATION_15153457077426481235)],
        &[(0b10010, &ENTRY_TENDERIZATIONS_759776932056624247)],
        &[(0b10010, &ENTRY_TENDERIZE_14583554302804750450)],
        &[(0b10010, &ENTRY_TENDERIZED_4549753286584063824)],
        &[(0b10010, &ENTRY_TENDERIZER_9543130259232111639)],
        &[(0b10010, &ENTRY_TENDERIZERS_2243522742396370113)],
        &[(0b10010, &ENTRY_TENDERIZES_8106466981215709305)],
        &[(0b10010, &ENTRY_TENDERIZING_18364924414460195974)],
        &[(0b01001, &ENTRY_TENDERIZATION_15153457077426481235)],
        &[(0b01001, &ENTRY_TENDERIZATIONS_759776932056624247)],
        &[(0b01001, &ENTRY_TENDERIZE_14583554302804750450)],
        &[(0b01001, &ENTRY_TENDERIZED_4549753286584063824)],
        &[(0b01001, &ENTRY_TENDERIZER_9543130259232111639)],
        &[(0b01001, &ENTRY_TENDERIZERS_2243522742396370113)],
        &[(0b01001, &ENTRY_TENDERIZES_8106466981215709305)],
        &[(0b01001, &ENTRY_TENDERIZING_18364924414460195974)],
        &[(0b00001, &ENTRY_TENDRILED_18038918814565810183)],
        &[(0b11010, &ENTRY_TENDRILED_18038918814565810183)],
        &[(0b10010, &ENTRY_TENEMENTIZATION_14600199269437804256)],
        &[(0b10010, &ENTRY_TENEMENTIZATIONS_3755446656409966534)],
        &[(0b10010, &ENTRY_TENEMENTIZE_17197876287592266522)],
        &[(0b10010, &ENTRY_TENEMENTIZES_2276031239379735921)],
        &[(0b01001, &ENTRY_TENEMENTIZATION_14600199269437804256)],
        &[(0b01001, &ENTRY_TENEMENTIZATIONS_3755446656409966534)],
        &[(0b01001, &ENTRY_TENEMENTIZE_17197876287592266522)],
        &[(0b01001, &ENTRY_TENEMENTIZES_2276031239379735921)],
        &[(0b00001, &ENTRY_TENIA_6242231905882591005)],
        &[(0b00001, &ENTRY_TENIACIDAL_11024692641878915165)],
        &[(0b00001, &ENTRY_TENIACIDE_8144045073011901293)],
        &[(0b00001, &ENTRY_TENIACIDES_9867987590675969789)],
        &[(0b00001, &ENTRY_TENIAE_14899975197394248907)],
        &[(0b00001, &ENTRY_TENIAFUGE_535975770678901901)],
        &[(0b00001, &ENTRY_TENIAFUGES_5656721164722933651)],
        &[(0b00001, &ENTRY_TENIAS_16745934458285507889)],
        &[(0b00001, &ENTRY_TENIASES_4934007100111357532)],
        &[(0b00001, &ENTRY_TENIASIS_7229408385178515529)],
        &[(0b00001, &ENTRY_TENIOID_11942386963829586985)],
        &[(0b00001, &ENTRY_TENTHMETER_17561130154323386893)],
        &[(0b11010, &ENTRY_TENTHMETER_17561130154323386893)],
    ],
    range: 2..=13,
};

static VARS_TEM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TEM_CHILDREN),
    value: None,
};

pub static VARS_TEM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("plise"),
        dictgen::InsensitiveStr::Ascii("plises"),
        dictgen::InsensitiveStr::Ascii("plize"),
        dictgen::InsensitiveStr::Ascii("plizes"),
        dictgen::InsensitiveStr::Ascii("poralise"),
        dictgen::InsensitiveStr::Ascii("poralised"),
        dictgen::InsensitiveStr::Ascii("poralises"),
        dictgen::InsensitiveStr::Ascii("poralising"),
        dictgen::InsensitiveStr::Ascii("poralize"),
        dictgen::InsensitiveStr::Ascii("poralized"),
        dictgen::InsensitiveStr::Ascii("poralizes"),
        dictgen::InsensitiveStr::Ascii("poralizing"),
        dictgen::InsensitiveStr::Ascii("porisation"),
        dictgen::InsensitiveStr::Ascii("porisations"),
        dictgen::InsensitiveStr::Ascii("porise"),
        dictgen::InsensitiveStr::Ascii("porised"),
        dictgen::InsensitiveStr::Ascii("poriser"),
        dictgen::InsensitiveStr::Ascii("porisers"),
        dictgen::InsensitiveStr::Ascii("porises"),
        dictgen::InsensitiveStr::Ascii("porising"),
        dictgen::InsensitiveStr::Ascii("porisinglier"),
        dictgen::InsensitiveStr::Ascii("porisingliest"),
        dictgen::InsensitiveStr::Ascii("porisingly"),
        dictgen::InsensitiveStr::Ascii("porisings"),
        dictgen::InsensitiveStr::Ascii("porization"),
        dictgen::InsensitiveStr::Ascii("porizations"),
        dictgen::InsensitiveStr::Ascii("porize"),
        dictgen::InsensitiveStr::Ascii("porized"),
        dictgen::InsensitiveStr::Ascii("porizer"),
        dictgen::InsensitiveStr::Ascii("porizers"),
        dictgen::InsensitiveStr::Ascii("porizes"),
        dictgen::InsensitiveStr::Ascii("porizing"),
        dictgen::InsensitiveStr::Ascii("porizinglier"),
        dictgen::InsensitiveStr::Ascii("porizingliest"),
        dictgen::InsensitiveStr::Ascii("porizingly"),
        dictgen::InsensitiveStr::Ascii("porizings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TEMPLIZE_3769471964247003706)],
        &[(0b10010, &ENTRY_TEMPLIZES_8206287182084029425)],
        &[(0b01001, &ENTRY_TEMPLIZE_3769471964247003706)],
        &[(0b01001, &ENTRY_TEMPLIZES_8206287182084029425)],
        &[(0b10010, &ENTRY_TEMPORALIZE_8976084796595693342)],
        &[(0b10010, &ENTRY_TEMPORALIZED_9346139556114175316)],
        &[(0b10010, &ENTRY_TEMPORALIZES_17569235997419710911)],
        &[(0b10010, &ENTRY_TEMPORALIZING_10385680194697863891)],
        &[(0b01001, &ENTRY_TEMPORALIZE_8976084796595693342)],
        &[(0b01001, &ENTRY_TEMPORALIZED_9346139556114175316)],
        &[(0b01001, &ENTRY_TEMPORALIZES_17569235997419710911)],
        &[(0b01001, &ENTRY_TEMPORALIZING_10385680194697863891)],
        &[(0b10010, &ENTRY_TEMPORIZATION_9268323585901486943)],
        &[(0b10010, &ENTRY_TEMPORIZATIONS_18395264469348932353)],
        &[(0b10010, &ENTRY_TEMPORIZE_6008538957350717253)],
        &[(0b10010, &ENTRY_TEMPORIZED_13828183401152117443)],
        &[(0b10010, &ENTRY_TEMPORIZER_13728915446164211108)],
        &[(0b10010, &ENTRY_TEMPORIZERS_7683732994752843323)],
        &[(0b10010, &ENTRY_TEMPORIZES_3654086099315586263)],
        &[(0b10010, &ENTRY_TEMPORIZING_6302462174887770996)],
        &[(0b10010, &ENTRY_TEMPORIZINGLIER_6355354281150226976)],
        &[(0b10010, &ENTRY_TEMPORIZINGLIEST_9905876624839839389)],
        &[(0b10010, &ENTRY_TEMPORIZINGLY_11640359263718011924)],
        &[(0b10010, &ENTRY_TEMPORIZINGS_20261713602325724)],
        &[(0b01001, &ENTRY_TEMPORIZATION_9268323585901486943)],
        &[(0b01001, &ENTRY_TEMPORIZATIONS_18395264469348932353)],
        &[(0b01001, &ENTRY_TEMPORIZE_6008538957350717253)],
        &[(0b01001, &ENTRY_TEMPORIZED_13828183401152117443)],
        &[(0b01001, &ENTRY_TEMPORIZER_13728915446164211108)],
        &[(0b01001, &ENTRY_TEMPORIZERS_7683732994752843323)],
        &[(0b01001, &ENTRY_TEMPORIZES_3654086099315586263)],
        &[(0b01001, &ENTRY_TEMPORIZING_6302462174887770996)],
        &[(0b01001, &ENTRY_TEMPORIZINGLIER_6355354281150226976)],
        &[(0b01001, &ENTRY_TEMPORIZINGLIEST_9905876624839839389)],
        &[(0b01001, &ENTRY_TEMPORIZINGLY_11640359263718011924)],
        &[(0b01001, &ENTRY_TEMPORIZINGS_20261713602325724)],
    ],
    range: 5..=13,
};

static VARS_TEL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TEL_CHILDREN),
    value: None,
};

pub static VARS_TEL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ae"),
        dictgen::InsensitiveStr::Ascii("aesthesia"),
        dictgen::InsensitiveStr::Ascii("aesthesias"),
        dictgen::InsensitiveStr::Ascii("aesthetic"),
        dictgen::InsensitiveStr::Ascii("aestheticer"),
        dictgen::InsensitiveStr::Ascii("aestheticest"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("epathise"),
        dictgen::InsensitiveStr::Ascii("epathised"),
        dictgen::InsensitiveStr::Ascii("epathises"),
        dictgen::InsensitiveStr::Ascii("epathising"),
        dictgen::InsensitiveStr::Ascii("epathize"),
        dictgen::InsensitiveStr::Ascii("epathized"),
        dictgen::InsensitiveStr::Ascii("epathizes"),
        dictgen::InsensitiveStr::Ascii("epathizing"),
        dictgen::InsensitiveStr::Ascii("esthesia"),
        dictgen::InsensitiveStr::Ascii("esthesias"),
        dictgen::InsensitiveStr::Ascii("esthetic"),
        dictgen::InsensitiveStr::Ascii("estheticer"),
        dictgen::InsensitiveStr::Ascii("estheticest"),
        dictgen::InsensitiveStr::Ascii("lurise"),
        dictgen::InsensitiveStr::Ascii("lurised"),
        dictgen::InsensitiveStr::Ascii("lurises"),
        dictgen::InsensitiveStr::Ascii("lurising"),
        dictgen::InsensitiveStr::Ascii("lurize"),
        dictgen::InsensitiveStr::Ascii("lurized"),
        dictgen::InsensitiveStr::Ascii("lurizes"),
        dictgen::InsensitiveStr::Ascii("lurizing"),
        dictgen::InsensitiveStr::Ascii("s"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TELE_17660775790618180296)],
        &[(0b11010, &ENTRY_TELESTHESIA_3729177704184763745)],
        &[(0b11010, &ENTRY_TELESTHESIAS_13634253936556894398)],
        &[(0b11010, &ENTRY_TELESTHETIC_2492077632449909509)],
        &[(0b11010, &ENTRY_TELESTHETICER_15325218410106938805)],
        &[(0b11010, &ENTRY_TELESTHETICEST_10500637524144952518)],
        &[(0b00001, &ENTRY_TELE_17660775790618180296)],
        &[(0b10010, &ENTRY_TELEPATHIZE_4890254755616696887)],
        &[(0b10010, &ENTRY_TELEPATHIZED_13030563544943449021)],
        &[(0b10010, &ENTRY_TELEPATHIZES_13175684465670989018)],
        &[(0b10010, &ENTRY_TELEPATHIZING_15634779623380965076)],
        &[(0b01001, &ENTRY_TELEPATHIZE_4890254755616696887)],
        &[(0b01001, &ENTRY_TELEPATHIZED_13030563544943449021)],
        &[(0b01001, &ENTRY_TELEPATHIZES_13175684465670989018)],
        &[(0b01001, &ENTRY_TELEPATHIZING_15634779623380965076)],
        &[(0b00001, &ENTRY_TELESTHESIA_3729177704184763745)],
        &[(0b00001, &ENTRY_TELESTHESIAS_13634253936556894398)],
        &[(0b00001, &ENTRY_TELESTHETIC_2492077632449909509)],
        &[(0b00001, &ENTRY_TELESTHETICER_15325218410106938805)],
        &[(0b00001, &ENTRY_TELESTHETICEST_10500637524144952518)],
        &[(0b10010, &ENTRY_TELLURIZE_12969876447874663017)],
        &[(0b10010, &ENTRY_TELLURIZED_4062571174023013836)],
        &[(0b10010, &ENTRY_TELLURIZES_14477745285616322945)],
        &[(0b10010, &ENTRY_TELLURIZING_15726097355587032776)],
        &[(0b01001, &ENTRY_TELLURIZE_12969876447874663017)],
        &[(0b01001, &ENTRY_TELLURIZED_4062571174023013836)],
        &[(0b01001, &ENTRY_TELLURIZES_14477745285616322945)],
        &[(0b01001, &ENTRY_TELLURIZING_15726097355587032776)],
        &[(0b00001, &ENTRY_TELS_3007087834331223229)],
    ],
    range: 1..=12,
};

static VARS_TEG_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TEG_CHILDREN),
    value: None,
};

pub static VARS_TEG_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("u")],
    values: &[&[(0b00001, &ENTRY_TEGU_17495886448442942906)]],
    range: 1..=1,
};

static VARS_TEE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TEE_CHILDREN),
    value: None,
};

pub static VARS_TEE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("r"),
        dictgen::InsensitiveStr::Ascii("rs"),
        dictgen::InsensitiveStr::Ascii("totaled"),
        dictgen::InsensitiveStr::Ascii("totaler"),
        dictgen::InsensitiveStr::Ascii("totalers"),
        dictgen::InsensitiveStr::Ascii("totaling"),
        dictgen::InsensitiveStr::Ascii("totalled"),
        dictgen::InsensitiveStr::Ascii("totaller"),
        dictgen::InsensitiveStr::Ascii("totallers"),
        dictgen::InsensitiveStr::Ascii("totalling"),
    ],
    values: &[
        &[(0b00001, &ENTRY_TEER_1512356504088772276)],
        &[(0b00001, &ENTRY_TEERS_11547310098132473650)],
        &[(0b00001, &ENTRY_TEETOTALED_13601847410093247608)],
        &[(0b00001, &ENTRY_TEETOTALER_4246658529410097511)],
        &[(0b00001, &ENTRY_TEETOTALERS_7523968922648268459)],
        &[(0b00001, &ENTRY_TEETOTALING_14654836145957001388)],
        &[(0b11010, &ENTRY_TEETOTALED_13601847410093247608)],
        &[(0b11010, &ENTRY_TEETOTALER_4246658529410097511)],
        &[(0b11010, &ENTRY_TEETOTALERS_7523968922648268459)],
        &[(0b11010, &ENTRY_TEETOTALING_14654836145957001388)],
    ],
    range: 1..=9,
};

static VARS_TEC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TEC_CHILDREN),
    value: None,
};

pub static VARS_TEC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hnicalisation"),
        dictgen::InsensitiveStr::Ascii("hnicalise"),
        dictgen::InsensitiveStr::Ascii("hnicalises"),
        dictgen::InsensitiveStr::Ascii("hnicalization"),
        dictgen::InsensitiveStr::Ascii("hnicalize"),
        dictgen::InsensitiveStr::Ascii("hnicalizes"),
        dictgen::InsensitiveStr::Ascii("hnicise"),
        dictgen::InsensitiveStr::Ascii("hnicised"),
        dictgen::InsensitiveStr::Ascii("hnicises"),
        dictgen::InsensitiveStr::Ascii("hnicising"),
        dictgen::InsensitiveStr::Ascii("hnicize"),
        dictgen::InsensitiveStr::Ascii("hnicized"),
        dictgen::InsensitiveStr::Ascii("hnicizes"),
        dictgen::InsensitiveStr::Ascii("hnicizing"),
        dictgen::InsensitiveStr::Ascii("hnicolour"),
        dictgen::InsensitiveStr::Ascii("hnicoloured"),
        dictgen::InsensitiveStr::Ascii("hnicolours"),
        dictgen::InsensitiveStr::Ascii("hnologise"),
        dictgen::InsensitiveStr::Ascii("hnologize"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TECHNICALIZATION_3773436217131165599)],
        &[(0b10010, &ENTRY_TECHNICALIZE_13592737048499055793)],
        &[(0b10010, &ENTRY_TECHNICALIZES_5595101189542797653)],
        &[(0b01001, &ENTRY_TECHNICALIZATION_3773436217131165599)],
        &[(0b01001, &ENTRY_TECHNICALIZE_13592737048499055793)],
        &[(0b01001, &ENTRY_TECHNICALIZES_5595101189542797653)],
        &[(0b10010, &ENTRY_TECHNICIZE_8212652477507145699)],
        &[(0b10010, &ENTRY_TECHNICIZED_3663306080874533270)],
        &[(0b10010, &ENTRY_TECHNICIZES_13211595356574862793)],
        &[(0b10010, &ENTRY_TECHNICIZING_13378455688370171176)],
        &[(0b01001, &ENTRY_TECHNICIZE_8212652477507145699)],
        &[(0b01001, &ENTRY_TECHNICIZED_3663306080874533270)],
        &[(0b01001, &ENTRY_TECHNICIZES_13211595356574862793)],
        &[(0b01001, &ENTRY_TECHNICIZING_13378455688370171176)],
        &[
            (0b11010, &ENTRY_TECHNICOLOR_13876999640902564556),
            (0b11010, &ENTRY_TECHNICOLOR_14183677618685504801),
        ],
        &[(0b11010, &ENTRY_TECHNICOLORED_1825328488281394359)],
        &[(0b11010, &ENTRY_TECHNICOLORS_14860686180490475866)],
        &[(0b10010, &ENTRY_TECHNOLOGIZE_4630575226590934600)],
        &[(0b01001, &ENTRY_TECHNOLOGIZE_4630575226590934600)],
    ],
    range: 7..=13,
};

static VARS_TEB_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TEB_CHILDREN),
    value: None,
};

pub static VARS_TEB_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ilise"),
        dictgen::InsensitiveStr::Ascii("ilised"),
        dictgen::InsensitiveStr::Ascii("ilises"),
        dictgen::InsensitiveStr::Ascii("ilising"),
        dictgen::InsensitiveStr::Ascii("ilize"),
        dictgen::InsensitiveStr::Ascii("ilized"),
        dictgen::InsensitiveStr::Ascii("ilizes"),
        dictgen::InsensitiveStr::Ascii("ilizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TEBILIZE_5379298659414145032)],
        &[(0b10010, &ENTRY_TEBILIZED_12603919274755080976)],
        &[(0b10010, &ENTRY_TEBILIZES_2524900190492767802)],
        &[(0b10010, &ENTRY_TEBILIZING_5956809875127660850)],
        &[(0b01001, &ENTRY_TEBILIZE_5379298659414145032)],
        &[(0b01001, &ENTRY_TEBILIZED_12603919274755080976)],
        &[(0b01001, &ENTRY_TEBILIZES_2524900190492767802)],
        &[(0b01001, &ENTRY_TEBILIZING_5956809875127660850)],
    ],
    range: 5..=7,
};

static VARS_TEA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TEA_CHILDREN),
    value: None,
};

pub static VARS_TEA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("selled"),
        dictgen::InsensitiveStr::Ascii("seller"),
        dictgen::InsensitiveStr::Ascii("sellers"),
        dictgen::InsensitiveStr::Ascii("selling"),
        dictgen::InsensitiveStr::Ascii("sellings"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TEER_1512356504088772276)],
        &[(0b00001, &ENTRY_TEASELED_8083609611219835965)],
        &[(0b00001, &ENTRY_TEASELER_15075482462791394349)],
        &[(0b00001, &ENTRY_TEASELERS_17319562617316313679)],
        &[
            (0b00001, &ENTRY_TEASELING_13695401286288634817),
            (0b00001, &ENTRY_TEASELING_2241001256394841761),
        ],
        &[(0b00001, &ENTRY_TEASELINGS_10604239368842442956)],
    ],
    range: 2..=8,
};

static VARS_TA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_TA_CHILDREN),
    value: None,
};

static VARS_TA_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_TAB_NODE),
    Some(&VARS_TAC_NODE),
    None,
    Some(&VARS_TAE_NODE),
    Some(&VARS_TAF_NODE),
    None,
    None,
    Some(&VARS_TAI_NODE),
    None,
    None,
    Some(&VARS_TAL_NODE),
    Some(&VARS_TAM_NODE),
    Some(&VARS_TAN_NODE),
    None,
    None,
    None,
    Some(&VARS_TAR_NODE),
    Some(&VARS_TAS_NODE),
    None,
    Some(&VARS_TAU_NODE),
    Some(&VARS_TAV_NODE),
    None,
    Some(&VARS_TAX_NODE),
    Some(&VARS_TAY_NODE),
    None,
];

static VARS_TAY_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TAY_CHILDREN),
    value: None,
};

pub static VARS_TAY_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lorise"),
        dictgen::InsensitiveStr::Ascii("lorises"),
        dictgen::InsensitiveStr::Ascii("lorize"),
        dictgen::InsensitiveStr::Ascii("lorizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TAYLORIZE_17635648384739575074)],
        &[(0b10010, &ENTRY_TAYLORIZES_13244584135122060485)],
        &[(0b01001, &ENTRY_TAYLORIZE_17635648384739575074)],
        &[(0b01001, &ENTRY_TAYLORIZES_13244584135122060485)],
    ],
    range: 6..=7,
};

static VARS_TAX_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TAX_CHILDREN),
    value: None,
};

pub static VARS_TAX_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("idermise"),
        dictgen::InsensitiveStr::Ascii("idermised"),
        dictgen::InsensitiveStr::Ascii("idermises"),
        dictgen::InsensitiveStr::Ascii("idermising"),
        dictgen::InsensitiveStr::Ascii("idermize"),
        dictgen::InsensitiveStr::Ascii("idermized"),
        dictgen::InsensitiveStr::Ascii("idermizes"),
        dictgen::InsensitiveStr::Ascii("idermizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TAXIDERMIZE_2374104358744757711)],
        &[(0b10010, &ENTRY_TAXIDERMIZED_10192910736850674)],
        &[(0b10010, &ENTRY_TAXIDERMIZES_4441796755398649754)],
        &[(0b10010, &ENTRY_TAXIDERMIZING_13017684951259720401)],
        &[(0b01001, &ENTRY_TAXIDERMIZE_2374104358744757711)],
        &[(0b01001, &ENTRY_TAXIDERMIZED_10192910736850674)],
        &[(0b01001, &ENTRY_TAXIDERMIZES_4441796755398649754)],
        &[(0b01001, &ENTRY_TAXIDERMIZING_13017684951259720401)],
    ],
    range: 8..=10,
};

static VARS_TAV_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TAV_CHILDREN),
    value: None,
};

pub static VARS_TAV_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ernise"),
        dictgen::InsensitiveStr::Ascii("ernises"),
        dictgen::InsensitiveStr::Ascii("ernize"),
        dictgen::InsensitiveStr::Ascii("ernizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TAVERNIZE_11412342911846701308)],
        &[(0b10010, &ENTRY_TAVERNIZES_6120473175514650417)],
        &[(0b01001, &ENTRY_TAVERNIZE_11412342911846701308)],
        &[(0b01001, &ENTRY_TAVERNIZES_6120473175514650417)],
    ],
    range: 6..=7,
};

static VARS_TAU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TAU_CHILDREN),
    value: None,
};

pub static VARS_TAU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("tologise"),
        dictgen::InsensitiveStr::Ascii("tologised"),
        dictgen::InsensitiveStr::Ascii("tologises"),
        dictgen::InsensitiveStr::Ascii("tologising"),
        dictgen::InsensitiveStr::Ascii("tologize"),
        dictgen::InsensitiveStr::Ascii("tologized"),
        dictgen::InsensitiveStr::Ascii("tologizes"),
        dictgen::InsensitiveStr::Ascii("tologizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TAUTOLOGIZE_4665592265999186622)],
        &[(0b10010, &ENTRY_TAUTOLOGIZED_9842553804886781862)],
        &[(0b10010, &ENTRY_TAUTOLOGIZES_11146116641412142667)],
        &[(0b10010, &ENTRY_TAUTOLOGIZING_9943163653831588506)],
        &[(0b01001, &ENTRY_TAUTOLOGIZE_4665592265999186622)],
        &[(0b01001, &ENTRY_TAUTOLOGIZED_9842553804886781862)],
        &[(0b01001, &ENTRY_TAUTOLOGIZES_11146116641412142667)],
        &[(0b01001, &ENTRY_TAUTOLOGIZING_9943163653831588506)],
    ],
    range: 8..=10,
};

static VARS_TAS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TAS_CHILDREN),
    value: None,
};

pub static VARS_TAS_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("seled"),
        dictgen::InsensitiveStr::Ascii("seling"),
        dictgen::InsensitiveStr::Ascii("selled"),
        dictgen::InsensitiveStr::Ascii("selling"),
        dictgen::InsensitiveStr::Ascii("sells"),
    ],
    values: &[
        &[(0b00001, &ENTRY_TASSELED_15553878924111115665)],
        &[(0b00001, &ENTRY_TASSELING_2676198179605847965)],
        &[(0b11010, &ENTRY_TASSELED_15553878924111115665)],
        &[(0b11010, &ENTRY_TASSELING_2676198179605847965)],
        &[(0b11010, &ENTRY_TASSELS_9644147193425846585)],
    ],
    range: 5..=7,
};

static VARS_TAR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TAR_CHILDREN),
    value: None,
};

pub static VARS_TAR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("iffise"),
        dictgen::InsensitiveStr::Ascii("iffises"),
        dictgen::InsensitiveStr::Ascii("iffize"),
        dictgen::InsensitiveStr::Ascii("iffizes"),
        dictgen::InsensitiveStr::Ascii("tarisation"),
        dictgen::InsensitiveStr::Ascii("tarisations"),
        dictgen::InsensitiveStr::Ascii("tarise"),
        dictgen::InsensitiveStr::Ascii("tarised"),
        dictgen::InsensitiveStr::Ascii("tarises"),
        dictgen::InsensitiveStr::Ascii("tarising"),
        dictgen::InsensitiveStr::Ascii("tarization"),
        dictgen::InsensitiveStr::Ascii("tarizations"),
        dictgen::InsensitiveStr::Ascii("tarize"),
        dictgen::InsensitiveStr::Ascii("tarized"),
        dictgen::InsensitiveStr::Ascii("tarizes"),
        dictgen::InsensitiveStr::Ascii("tarizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TARIFFIZE_18377098253013907822)],
        &[(0b10010, &ENTRY_TARIFFIZES_4632513233689174159)],
        &[(0b01001, &ENTRY_TARIFFIZE_18377098253013907822)],
        &[(0b01001, &ENTRY_TARIFFIZES_4632513233689174159)],
        &[(0b10010, &ENTRY_TARTARIZATION_1394513065812646894)],
        &[(0b10010, &ENTRY_TARTARIZATIONS_11628589829012700090)],
        &[(0b10010, &ENTRY_TARTARIZE_11607621879783763771)],
        &[(0b10010, &ENTRY_TARTARIZED_531821600819631957)],
        &[(0b10010, &ENTRY_TARTARIZES_6665817306686419426)],
        &[(0b10010, &ENTRY_TARTARIZING_15412039886176166104)],
        &[(0b01001, &ENTRY_TARTARIZATION_1394513065812646894)],
        &[(0b01001, &ENTRY_TARTARIZATIONS_11628589829012700090)],
        &[(0b01001, &ENTRY_TARTARIZE_11607621879783763771)],
        &[(0b01001, &ENTRY_TARTARIZED_531821600819631957)],
        &[(0b01001, &ENTRY_TARTARIZES_6665817306686419426)],
        &[(0b01001, &ENTRY_TARTARIZING_15412039886176166104)],
    ],
    range: 6..=11,
};

static VARS_TAN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TAN_CHILDREN),
    value: None,
};

pub static VARS_TAN_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alised"),
        dictgen::InsensitiveStr::Ascii("alized"),
        dictgen::InsensitiveStr::Ascii("demise"),
        dictgen::InsensitiveStr::Ascii("demises"),
        dictgen::InsensitiveStr::Ascii("demize"),
        dictgen::InsensitiveStr::Ascii("demizes"),
        dictgen::InsensitiveStr::Ascii("talisation"),
        dictgen::InsensitiveStr::Ascii("talisations"),
        dictgen::InsensitiveStr::Ascii("talise"),
        dictgen::InsensitiveStr::Ascii("talised"),
        dictgen::InsensitiveStr::Ascii("taliser"),
        dictgen::InsensitiveStr::Ascii("talisers"),
        dictgen::InsensitiveStr::Ascii("talises"),
        dictgen::InsensitiveStr::Ascii("talising"),
        dictgen::InsensitiveStr::Ascii("talisinglier"),
        dictgen::InsensitiveStr::Ascii("talisinglies"),
        dictgen::InsensitiveStr::Ascii("talisingliest"),
        dictgen::InsensitiveStr::Ascii("talisingly"),
        dictgen::InsensitiveStr::Ascii("talisingness"),
        dictgen::InsensitiveStr::Ascii("talisingnesses"),
        dictgen::InsensitiveStr::Ascii("talisings"),
        dictgen::InsensitiveStr::Ascii("talization"),
        dictgen::InsensitiveStr::Ascii("talizations"),
        dictgen::InsensitiveStr::Ascii("talize"),
        dictgen::InsensitiveStr::Ascii("talized"),
        dictgen::InsensitiveStr::Ascii("talizer"),
        dictgen::InsensitiveStr::Ascii("talizers"),
        dictgen::InsensitiveStr::Ascii("talizes"),
        dictgen::InsensitiveStr::Ascii("talizing"),
        dictgen::InsensitiveStr::Ascii("talizinglier"),
        dictgen::InsensitiveStr::Ascii("talizinglies"),
        dictgen::InsensitiveStr::Ascii("talizingliest"),
        dictgen::InsensitiveStr::Ascii("talizingly"),
        dictgen::InsensitiveStr::Ascii("talizingness"),
        dictgen::InsensitiveStr::Ascii("talizingnesses"),
        dictgen::InsensitiveStr::Ascii("talizings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TANALIZED_9212065894823627745)],
        &[(0b01001, &ENTRY_TANALIZED_9212065894823627745)],
        &[(0b10010, &ENTRY_TANDEMIZE_4594849143604731371)],
        &[(0b10010, &ENTRY_TANDEMIZES_16858842567411722496)],
        &[(0b01001, &ENTRY_TANDEMIZE_4594849143604731371)],
        &[(0b01001, &ENTRY_TANDEMIZES_16858842567411722496)],
        &[(0b10010, &ENTRY_TANTALIZATION_10133038819327360701)],
        &[(0b10010, &ENTRY_TANTALIZATIONS_13771654142203624068)],
        &[(0b10010, &ENTRY_TANTALIZE_15099675080816392884)],
        &[(0b10010, &ENTRY_TANTALIZED_6407916214765676747)],
        &[(0b10010, &ENTRY_TANTALIZER_3311757807060502289)],
        &[(0b10010, &ENTRY_TANTALIZERS_15746926120203675469)],
        &[(0b10010, &ENTRY_TANTALIZES_7562225734061592970)],
        &[(0b10010, &ENTRY_TANTALIZING_5979831725565904591)],
        &[(0b10010, &ENTRY_TANTALIZINGLIER_10045132062074784268)],
        &[(0b10010, &ENTRY_TANTALIZINGLIES_5104449786998566308)],
        &[(0b10010, &ENTRY_TANTALIZINGLIEST_13318655638322508135)],
        &[(0b10010, &ENTRY_TANTALIZINGLY_8124924363029560350)],
        &[(0b10010, &ENTRY_TANTALIZINGNESS_5920752991593005851)],
        &[(0b10010, &ENTRY_TANTALIZINGNESSES_3198907059754343992)],
        &[(0b10010, &ENTRY_TANTALIZINGS_16838246964261155328)],
        &[(0b01001, &ENTRY_TANTALIZATION_10133038819327360701)],
        &[(0b01001, &ENTRY_TANTALIZATIONS_13771654142203624068)],
        &[(0b01001, &ENTRY_TANTALIZE_15099675080816392884)],
        &[(0b01001, &ENTRY_TANTALIZED_6407916214765676747)],
        &[(0b01001, &ENTRY_TANTALIZER_3311757807060502289)],
        &[(0b01001, &ENTRY_TANTALIZERS_15746926120203675469)],
        &[(0b01001, &ENTRY_TANTALIZES_7562225734061592970)],
        &[(0b01001, &ENTRY_TANTALIZING_5979831725565904591)],
        &[(0b01001, &ENTRY_TANTALIZINGLIER_10045132062074784268)],
        &[(0b01001, &ENTRY_TANTALIZINGLIES_5104449786998566308)],
        &[(0b01001, &ENTRY_TANTALIZINGLIEST_13318655638322508135)],
        &[(0b01001, &ENTRY_TANTALIZINGLY_8124924363029560350)],
        &[(0b01001, &ENTRY_TANTALIZINGNESS_5920752991593005851)],
        &[(0b01001, &ENTRY_TANTALIZINGNESSES_3198907059754343992)],
        &[(0b01001, &ENTRY_TANTALIZINGS_16838246964261155328)],
    ],
    range: 6..=14,
};

static VARS_TAM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TAM_CHILDREN),
    value: None,
};

pub static VARS_TAM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("boura"),
        dictgen::InsensitiveStr::Ascii("bouras"),
        dictgen::InsensitiveStr::Ascii("manyise"),
        dictgen::InsensitiveStr::Ascii("manyises"),
        dictgen::InsensitiveStr::Ascii("manyize"),
        dictgen::InsensitiveStr::Ascii("manyizes"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TAMBURA_1661928953124890659)],
        &[(0b11010, &ENTRY_TAMBURAS_14365291061235589624)],
        &[(0b10010, &ENTRY_TAMMANYIZE_10524041228496510264)],
        &[(0b10010, &ENTRY_TAMMANYIZES_17001559242562845912)],
        &[(0b01001, &ENTRY_TAMMANYIZE_10524041228496510264)],
        &[(0b01001, &ENTRY_TAMMANYIZES_17001559242562845912)],
    ],
    range: 5..=8,
};

static VARS_TAL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TAL_CHILDREN),
    value: None,
};

pub static VARS_TAL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("mudisation"),
        dictgen::InsensitiveStr::Ascii("mudisations"),
        dictgen::InsensitiveStr::Ascii("mudise"),
        dictgen::InsensitiveStr::Ascii("mudises"),
        dictgen::InsensitiveStr::Ascii("mudization"),
        dictgen::InsensitiveStr::Ascii("mudizations"),
        dictgen::InsensitiveStr::Ascii("mudize"),
        dictgen::InsensitiveStr::Ascii("mudizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TALMUDIZATION_15638872772942699916)],
        &[(0b10010, &ENTRY_TALMUDIZATIONS_11451589359461499086)],
        &[(0b10010, &ENTRY_TALMUDIZE_16721620815556202151)],
        &[(0b10010, &ENTRY_TALMUDIZES_2392641621064217398)],
        &[(0b01001, &ENTRY_TALMUDIZATION_15638872772942699916)],
        &[(0b01001, &ENTRY_TALMUDIZATIONS_11451589359461499086)],
        &[(0b01001, &ENTRY_TALMUDIZE_16721620815556202151)],
        &[(0b01001, &ENTRY_TALMUDIZES_2392641621064217398)],
    ],
    range: 6..=11,
};

static VARS_TAI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TAI_CHILDREN),
    value: None,
};

pub static VARS_TAI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lorisation"),
        dictgen::InsensitiveStr::Ascii("lorisations"),
        dictgen::InsensitiveStr::Ascii("lorise"),
        dictgen::InsensitiveStr::Ascii("lorises"),
        dictgen::InsensitiveStr::Ascii("lorization"),
        dictgen::InsensitiveStr::Ascii("lorizations"),
        dictgen::InsensitiveStr::Ascii("lorize"),
        dictgen::InsensitiveStr::Ascii("lorizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TAILORIZATION_15045235103886073598)],
        &[(0b10010, &ENTRY_TAILORIZATIONS_1736724620876472569)],
        &[(0b10010, &ENTRY_TAILORIZE_15097975052812336572)],
        &[(0b10010, &ENTRY_TAILORIZES_6097967392668050636)],
        &[(0b01001, &ENTRY_TAILORIZATION_15045235103886073598)],
        &[(0b01001, &ENTRY_TAILORIZATIONS_1736724620876472569)],
        &[(0b01001, &ENTRY_TAILORIZE_15097975052812336572)],
        &[(0b01001, &ENTRY_TAILORIZES_6097967392668050636)],
    ],
    range: 6..=11,
};

static VARS_TAF_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TAF_CHILDREN),
    value: None,
};

pub static VARS_TAF_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("fetised"),
        dictgen::InsensitiveStr::Ascii("fetized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_TAFFETIZED_8007155516688755691)],
        &[(0b01001, &ENTRY_TAFFETIZED_8007155516688755691)],
    ],
    range: 7..=7,
};

static VARS_TAE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TAE_CHILDREN),
    value: Some(&[(0b11010, &ENTRY_TE_16963694388719213938)]),
};

pub static VARS_TAE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gu"),
        dictgen::InsensitiveStr::Ascii("ls"),
        dictgen::InsensitiveStr::Ascii("nia"),
        dictgen::InsensitiveStr::Ascii("niacidal"),
        dictgen::InsensitiveStr::Ascii("niacide"),
        dictgen::InsensitiveStr::Ascii("niacides"),
        dictgen::InsensitiveStr::Ascii("niae"),
        dictgen::InsensitiveStr::Ascii("niafuge"),
        dictgen::InsensitiveStr::Ascii("niafuges"),
        dictgen::InsensitiveStr::Ascii("nias"),
        dictgen::InsensitiveStr::Ascii("niases"),
        dictgen::InsensitiveStr::Ascii("niasis"),
        dictgen::InsensitiveStr::Ascii("nioid"),
        dictgen::InsensitiveStr::Ascii("s"),
    ],
    values: &[
        &[(0b11010, &ENTRY_TEGU_17495886448442942906)],
        &[(0b11010, &ENTRY_TELS_3007087834331223229)],
        &[(0b11010, &ENTRY_TENIA_6242231905882591005)],
        &[(0b11010, &ENTRY_TENIACIDAL_11024692641878915165)],
        &[(0b11010, &ENTRY_TENIACIDE_8144045073011901293)],
        &[(0b11010, &ENTRY_TENIACIDES_9867987590675969789)],
        &[(0b11010, &ENTRY_TENIAE_14899975197394248907)],
        &[(0b11010, &ENTRY_TENIAFUGE_535975770678901901)],
        &[(0b11010, &ENTRY_TENIAFUGES_5656721164722933651)],
        &[(0b11010, &ENTRY_TENIAS_16745934458285507889)],
        &[(0b11010, &ENTRY_TENIASES_4934007100111357532)],
        &[(0b11010, &ENTRY_TENIASIS_7229408385178515529)],
        &[(0b11010, &ENTRY_TENIOID_11942386963829586985)],
        &[(0b11010, &ENTRY_TES_5634224708893959490)],
    ],
    range: 1..=8,
};

static VARS_TAC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TAC_CHILDREN),
    value: None,
};

pub static VARS_TAC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hypnea"),
        dictgen::InsensitiveStr::Ascii("hypneas"),
        dictgen::InsensitiveStr::Ascii("hypneic"),
        dictgen::InsensitiveStr::Ascii("hypnoea"),
        dictgen::InsensitiveStr::Ascii("hypnoeas"),
        dictgen::InsensitiveStr::Ascii("hypnoeic"),
    ],
    values: &[
        &[(0b00001, &ENTRY_TACHYPNEA_3166922207303436381)],
        &[(0b00001, &ENTRY_TACHYPNEAS_5067707765941922607)],
        &[(0b00001, &ENTRY_TACHYPNEIC_6595193245006460158)],
        &[(0b11010, &ENTRY_TACHYPNEA_3166922207303436381)],
        &[(0b11010, &ENTRY_TACHYPNEAS_5067707765941922607)],
        &[(0b11010, &ENTRY_TACHYPNEIC_6595193245006460158)],
    ],
    range: 6..=8,
};

static VARS_TAB_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_TAB_CHILDREN),
    value: None,
};

pub static VARS_TAB_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ored"),
        dictgen::InsensitiveStr::Ascii("orer"),
        dictgen::InsensitiveStr::Ascii("orers"),
        dictgen::InsensitiveStr::Ascii("oret"),
        dictgen::InsensitiveStr::Ascii("orets"),
        dictgen::InsensitiveStr::Ascii("orin"),
        dictgen::InsensitiveStr::Ascii("orine"),
        dictgen::InsensitiveStr::Ascii("oring"),
        dictgen::InsensitiveStr::Ascii("orins"),
        dictgen::InsensitiveStr::Ascii("oured"),
        dictgen::InsensitiveStr::Ascii("ourer"),
        dictgen::InsensitiveStr::Ascii("ourers"),
        dictgen::InsensitiveStr::Ascii("ouret"),
        dictgen::InsensitiveStr::Ascii("ourets"),
        dictgen::InsensitiveStr::Ascii("ourin"),
        dictgen::InsensitiveStr::Ascii("ourine"),
        dictgen::InsensitiveStr::Ascii("ouring"),
        dictgen::InsensitiveStr::Ascii("ourins"),
        dictgen::InsensitiveStr::Ascii("ulae"),
        dictgen::InsensitiveStr::Ascii("ularisation"),
        dictgen::InsensitiveStr::Ascii("ularisations"),
        dictgen::InsensitiveStr::Ascii("ularise"),
        dictgen::InsensitiveStr::Ascii("ularised"),
        dictgen::InsensitiveStr::Ascii("ularises"),
        dictgen::InsensitiveStr::Ascii("ularising"),
        dictgen::InsensitiveStr::Ascii("ularization"),
        dictgen::InsensitiveStr::Ascii("ularizations"),
        dictgen::InsensitiveStr::Ascii("ularize"),
        dictgen::InsensitiveStr::Ascii("ularized"),
        dictgen::InsensitiveStr::Ascii("ularizes"),
        dictgen::InsensitiveStr::Ascii("ularizing"),
        dictgen::InsensitiveStr::Ascii("ule"),
    ],
    values: &[
        &[(0b00001, &ENTRY_TABORED_3458012263090109952)],
        &[(0b00001, &ENTRY_TABORER_259230914231617550)],
        &[(0b00001, &ENTRY_TABORERS_6060629822354641976)],
        &[(0b00001, &ENTRY_TABORET_7350560887326673778)],
        &[(0b00001, &ENTRY_TABORETS_12733109459658678516)],
        &[(0b00001, &ENTRY_TABORIN_4037230761017031912)],
        &[(0b00001, &ENTRY_TABORINE_6438755799910501319)],
        &[(0b00001, &ENTRY_TABORING_10201578819028294847)],
        &[(0b00001, &ENTRY_TABORINS_16033201340157357087)],
        &[(0b11010, &ENTRY_TABORED_3458012263090109952)],
        &[(0b11010, &ENTRY_TABORER_259230914231617550)],
        &[(0b11010, &ENTRY_TABORERS_6060629822354641976)],
        &[(0b11010, &ENTRY_TABORET_7350560887326673778)],
        &[(0b11010, &ENTRY_TABORETS_12733109459658678516)],
        &[(0b11010, &ENTRY_TABORIN_4037230761017031912)],
        &[(0b11010, &ENTRY_TABORINE_6438755799910501319)],
        &[(0b11010, &ENTRY_TABORING_10201578819028294847)],
        &[(0b11010, &ENTRY_TABORINS_16033201340157357087)],
        &[(0b11010, &ENTRY_TABULE_16853827266028831247)],
        &[(0b10010, &ENTRY_TABULARIZATION_13918426618250472515)],
        &[(0b10010, &ENTRY_TABULARIZATIONS_7435992087915599492)],
        &[(0b10010, &ENTRY_TABULARIZE_4261090986956683891)],
        &[(0b10010, &ENTRY_TABULARIZED_7994290726718343521)],
        &[(0b10010, &ENTRY_TABULARIZES_5785970776539734545)],
        &[(0b10010, &ENTRY_TABULARIZING_182464911659236753)],
        &[(0b01001, &ENTRY_TABULARIZATION_13918426618250472515)],
        &[(0b01001, &ENTRY_TABULARIZATIONS_7435992087915599492)],
        &[(0b01001, &ENTRY_TABULARIZE_4261090986956683891)],
        &[(0b01001, &ENTRY_TABULARIZED_7994290726718343521)],
        &[(0b01001, &ENTRY_TABULARIZES_5785970776539734545)],
        &[(0b01001, &ENTRY_TABULARIZING_182464911659236753)],
        &[(0b00001, &ENTRY_TABULE_16853827266028831247)],
    ],
    range: 3..=12,
};

static VARS_S_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_S_CHILDREN),
    value: None,
};

static VARS_S_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_SA_NODE),
    None,
    Some(&VARS_SC_NODE),
    None,
    Some(&VARS_SE_NODE),
    None,
    None,
    Some(&VARS_SH_NODE),
    Some(&VARS_SI_NODE),
    None,
    Some(&VARS_SK_NODE),
    Some(&VARS_SL_NODE),
    Some(&VARS_SM_NODE),
    Some(&VARS_SN_NODE),
    Some(&VARS_SO_NODE),
    Some(&VARS_SP_NODE),
    Some(&VARS_SQ_NODE),
    None,
    None,
    Some(&VARS_ST_NODE),
    Some(&VARS_SU_NODE),
    None,
    Some(&VARS_SW_NODE),
    None,
    Some(&VARS_SY_NODE),
    None,
];

static VARS_SY_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SY_CHILDREN),
    value: None,
};

static VARS_SY_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    Some(&VARS_SYC_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SYL_NODE),
    Some(&VARS_SYM_NODE),
    Some(&VARS_SYN_NODE),
    None,
    Some(&VARS_SYP_NODE),
    None,
    Some(&VARS_SYR_NODE),
    Some(&VARS_SYS_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_SYS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SYS_CHILDREN),
    value: None,
};

pub static VARS_SYS_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("tematisation"),
        dictgen::InsensitiveStr::Ascii("tematisations"),
        dictgen::InsensitiveStr::Ascii("tematise"),
        dictgen::InsensitiveStr::Ascii("tematised"),
        dictgen::InsensitiveStr::Ascii("tematiser"),
        dictgen::InsensitiveStr::Ascii("tematisers"),
        dictgen::InsensitiveStr::Ascii("tematises"),
        dictgen::InsensitiveStr::Ascii("tematising"),
        dictgen::InsensitiveStr::Ascii("tematization"),
        dictgen::InsensitiveStr::Ascii("tematizations"),
        dictgen::InsensitiveStr::Ascii("tematize"),
        dictgen::InsensitiveStr::Ascii("tematized"),
        dictgen::InsensitiveStr::Ascii("tematizer"),
        dictgen::InsensitiveStr::Ascii("tematizers"),
        dictgen::InsensitiveStr::Ascii("tematizes"),
        dictgen::InsensitiveStr::Ascii("tematizing"),
        dictgen::InsensitiveStr::Ascii("temisable"),
        dictgen::InsensitiveStr::Ascii("temisabler"),
        dictgen::InsensitiveStr::Ascii("temisables"),
        dictgen::InsensitiveStr::Ascii("temisablest"),
        dictgen::InsensitiveStr::Ascii("temisation"),
        dictgen::InsensitiveStr::Ascii("temisations"),
        dictgen::InsensitiveStr::Ascii("temise"),
        dictgen::InsensitiveStr::Ascii("temised"),
        dictgen::InsensitiveStr::Ascii("temiser"),
        dictgen::InsensitiveStr::Ascii("temisers"),
        dictgen::InsensitiveStr::Ascii("temises"),
        dictgen::InsensitiveStr::Ascii("temising"),
        dictgen::InsensitiveStr::Ascii("temizable"),
        dictgen::InsensitiveStr::Ascii("temizabler"),
        dictgen::InsensitiveStr::Ascii("temizables"),
        dictgen::InsensitiveStr::Ascii("temizablest"),
        dictgen::InsensitiveStr::Ascii("temization"),
        dictgen::InsensitiveStr::Ascii("temizations"),
        dictgen::InsensitiveStr::Ascii("temize"),
        dictgen::InsensitiveStr::Ascii("temized"),
        dictgen::InsensitiveStr::Ascii("temizer"),
        dictgen::InsensitiveStr::Ascii("temizers"),
        dictgen::InsensitiveStr::Ascii("temizes"),
        dictgen::InsensitiveStr::Ascii("temizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SYSTEMATIZATION_7949059312574351676)],
        &[(0b10010, &ENTRY_SYSTEMATIZATIONS_4980889965627146570)],
        &[(0b10010, &ENTRY_SYSTEMATIZE_804615704421462730)],
        &[(0b10010, &ENTRY_SYSTEMATIZED_3960322988302014252)],
        &[(0b10010, &ENTRY_SYSTEMATIZER_12159646041280111468)],
        &[(0b10010, &ENTRY_SYSTEMATIZERS_5220548971047734611)],
        &[(0b10010, &ENTRY_SYSTEMATIZES_6130814802973402788)],
        &[(0b10010, &ENTRY_SYSTEMATIZING_7548356459201607237)],
        &[(0b01001, &ENTRY_SYSTEMATIZATION_7949059312574351676)],
        &[(0b01001, &ENTRY_SYSTEMATIZATIONS_4980889965627146570)],
        &[(0b01001, &ENTRY_SYSTEMATIZE_804615704421462730)],
        &[(0b01001, &ENTRY_SYSTEMATIZED_3960322988302014252)],
        &[(0b01001, &ENTRY_SYSTEMATIZER_12159646041280111468)],
        &[(0b01001, &ENTRY_SYSTEMATIZERS_5220548971047734611)],
        &[(0b01001, &ENTRY_SYSTEMATIZES_6130814802973402788)],
        &[(0b01001, &ENTRY_SYSTEMATIZING_7548356459201607237)],
        &[(0b10010, &ENTRY_SYSTEMIZABLE_6386901091487317898)],
        &[(0b10010, &ENTRY_SYSTEMIZABLER_3507991058574811537)],
        &[(0b10010, &ENTRY_SYSTEMIZABLES_1663867473218562178)],
        &[(0b10010, &ENTRY_SYSTEMIZABLEST_9881026680576809052)],
        &[(0b10010, &ENTRY_SYSTEMIZATION_7402744491389982261)],
        &[(0b10010, &ENTRY_SYSTEMIZATIONS_9736157959771706455)],
        &[(0b10010, &ENTRY_SYSTEMIZE_6507154835856335771)],
        &[(0b10010, &ENTRY_SYSTEMIZED_5994844121926171444)],
        &[(0b10010, &ENTRY_SYSTEMIZER_1967185930700519507)],
        &[(0b10010, &ENTRY_SYSTEMIZERS_9699204790114175286)],
        &[(0b10010, &ENTRY_SYSTEMIZES_1513912670035920399)],
        &[(0b10010, &ENTRY_SYSTEMIZING_11787131178563974725)],
        &[(0b01001, &ENTRY_SYSTEMIZABLE_6386901091487317898)],
        &[(0b01001, &ENTRY_SYSTEMIZABLER_3507991058574811537)],
        &[(0b01001, &ENTRY_SYSTEMIZABLES_1663867473218562178)],
        &[(0b01001, &ENTRY_SYSTEMIZABLEST_9881026680576809052)],
        &[(0b01001, &ENTRY_SYSTEMIZATION_7402744491389982261)],
        &[(0b01001, &ENTRY_SYSTEMIZATIONS_9736157959771706455)],
        &[(0b01001, &ENTRY_SYSTEMIZE_6507154835856335771)],
        &[(0b01001, &ENTRY_SYSTEMIZED_5994844121926171444)],
        &[(0b01001, &ENTRY_SYSTEMIZER_1967185930700519507)],
        &[(0b01001, &ENTRY_SYSTEMIZERS_9699204790114175286)],
        &[(0b01001, &ENTRY_SYSTEMIZES_1513912670035920399)],
        &[(0b01001, &ENTRY_SYSTEMIZING_11787131178563974725)],
    ],
    range: 6..=13,
};

static VARS_SYR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SYR_CHILDREN),
    value: None,
};

pub static VARS_SYR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ianise"),
        dictgen::InsensitiveStr::Ascii("ianises"),
        dictgen::InsensitiveStr::Ascii("ianize"),
        dictgen::InsensitiveStr::Ascii("ianizes"),
        dictgen::InsensitiveStr::Ascii("ingocele"),
        dictgen::InsensitiveStr::Ascii("ingocoele"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SYRIANIZE_10187036361030900008)],
        &[(0b10010, &ENTRY_SYRIANIZES_15205618974659997671)],
        &[(0b01001, &ENTRY_SYRIANIZE_10187036361030900008)],
        &[(0b01001, &ENTRY_SYRIANIZES_15205618974659997671)],
        &[(0b00001, &ENTRY_SYRINGOCELE_11968813307237913697)],
        &[(0b11010, &ENTRY_SYRINGOCELE_11968813307237913697)],
    ],
    range: 6..=9,
};

static VARS_SYP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SYP_CHILDREN),
    value: None,
};

pub static VARS_SYP_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hilisation"),
        dictgen::InsensitiveStr::Ascii("hilisations"),
        dictgen::InsensitiveStr::Ascii("hilise"),
        dictgen::InsensitiveStr::Ascii("hilised"),
        dictgen::InsensitiveStr::Ascii("hilising"),
        dictgen::InsensitiveStr::Ascii("hilization"),
        dictgen::InsensitiveStr::Ascii("hilizations"),
        dictgen::InsensitiveStr::Ascii("hilize"),
        dictgen::InsensitiveStr::Ascii("hilized"),
        dictgen::InsensitiveStr::Ascii("hilizing"),
        dictgen::InsensitiveStr::Ascii("hon"),
        dictgen::InsensitiveStr::Ascii("honed"),
        dictgen::InsensitiveStr::Ascii("honing"),
        dictgen::InsensitiveStr::Ascii("honless"),
        dictgen::InsensitiveStr::Ascii("honlesses"),
        dictgen::InsensitiveStr::Ascii("honlike"),
        dictgen::InsensitiveStr::Ascii("honlikes"),
        dictgen::InsensitiveStr::Ascii("honophore"),
        dictgen::InsensitiveStr::Ascii("honostele"),
        dictgen::InsensitiveStr::Ascii("honostelic"),
        dictgen::InsensitiveStr::Ascii("honostely"),
        dictgen::InsensitiveStr::Ascii("hons"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SYPHILIZATION_4055568425962123768)],
        &[(0b10010, &ENTRY_SYPHILIZATIONS_6566377490752303452)],
        &[(0b10010, &ENTRY_SYPHILIZE_13140711569267519345)],
        &[(0b10010, &ENTRY_SYPHILIZED_11930486983642777973)],
        &[(0b10010, &ENTRY_SYPHILIZING_14288192544253600248)],
        &[(0b01001, &ENTRY_SYPHILIZATION_4055568425962123768)],
        &[(0b01001, &ENTRY_SYPHILIZATIONS_6566377490752303452)],
        &[(0b01001, &ENTRY_SYPHILIZE_13140711569267519345)],
        &[(0b01001, &ENTRY_SYPHILIZED_11930486983642777973)],
        &[(0b01001, &ENTRY_SYPHILIZING_14288192544253600248)],
        &[(0b10010, &ENTRY_SIPHON_7910828118148547350)],
        &[(0b10010, &ENTRY_SIPHONED_13775252266477144644)],
        &[(0b10010, &ENTRY_SIPHONING_3524409665423772935)],
        &[(0b11010, &ENTRY_SIPHONLESS_10853607871264713731)],
        &[(0b11010, &ENTRY_SIPHONLESSES_6742087362595900505)],
        &[(0b11010, &ENTRY_SIPHONLIKE_3466549338188047789)],
        &[(0b11010, &ENTRY_SIPHONLIKES_4271727245061818819)],
        &[(0b11010, &ENTRY_SIPHONOPHORE_13045084369054789980)],
        &[(0b11010, &ENTRY_SIPHONOSTELE_10401690898945006274)],
        &[(0b11010, &ENTRY_SIPHONOSTELIC_6331118512817996757)],
        &[(0b11010, &ENTRY_SIPHONOSTELY_260206920676310428)],
        &[(0b10010, &ENTRY_SIPHONS_9477554659409124740)],
    ],
    range: 3..=11,
};

static VARS_SYN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SYN_CHILDREN),
    value: None,
};

static VARS_SYN_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_SYNA_NODE),
    None,
    Some(&VARS_SYNC_NODE),
    Some(&VARS_SYND_NODE),
    Some(&VARS_SYNE_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SYNO_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_SYNT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_SYNT_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SYNT_CHILDREN),
    value: None,
};

pub static VARS_SYNT_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hesisation"),
        dictgen::InsensitiveStr::Ascii("hesisations"),
        dictgen::InsensitiveStr::Ascii("hesise"),
        dictgen::InsensitiveStr::Ascii("hesised"),
        dictgen::InsensitiveStr::Ascii("hesiser"),
        dictgen::InsensitiveStr::Ascii("hesisers"),
        dictgen::InsensitiveStr::Ascii("hesises"),
        dictgen::InsensitiveStr::Ascii("hesising"),
        dictgen::InsensitiveStr::Ascii("hesization"),
        dictgen::InsensitiveStr::Ascii("hesizations"),
        dictgen::InsensitiveStr::Ascii("hesize"),
        dictgen::InsensitiveStr::Ascii("hesized"),
        dictgen::InsensitiveStr::Ascii("hesizes"),
        dictgen::InsensitiveStr::Ascii("hesizing"),
        dictgen::InsensitiveStr::Ascii("hetisation"),
        dictgen::InsensitiveStr::Ascii("hetiser"),
        dictgen::InsensitiveStr::Ascii("hetisers"),
        dictgen::InsensitiveStr::Ascii("hetization"),
        dictgen::InsensitiveStr::Ascii("hetize"),
        dictgen::InsensitiveStr::Ascii("hetized"),
        dictgen::InsensitiveStr::Ascii("hetizer"),
        dictgen::InsensitiveStr::Ascii("hetizers"),
        dictgen::InsensitiveStr::Ascii("hetizes"),
        dictgen::InsensitiveStr::Ascii("hetizing"),
        dictgen::InsensitiveStr::Ascii("onisation"),
        dictgen::InsensitiveStr::Ascii("onise"),
        dictgen::InsensitiveStr::Ascii("onised"),
        dictgen::InsensitiveStr::Ascii("onises"),
        dictgen::InsensitiveStr::Ascii("onising"),
        dictgen::InsensitiveStr::Ascii("onization"),
        dictgen::InsensitiveStr::Ascii("onize"),
        dictgen::InsensitiveStr::Ascii("onized"),
        dictgen::InsensitiveStr::Ascii("onizes"),
        dictgen::InsensitiveStr::Ascii("onizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SYNTHESIZATION_7847480716228741176)],
        &[(0b10010, &ENTRY_SYNTHESIZATIONS_6008071763176942923)],
        &[(0b10010, &ENTRY_SYNTHESIZE_12262264416656123255)],
        &[(0b10010, &ENTRY_SYNTHESIZED_10277854444798047575)],
        &[(0b11010, &ENTRY_SYNTHESIZER_5120597236259656684)],
        &[(0b11010, &ENTRY_SYNTHESIZERS_17412149831785719286)],
        &[(0b10010, &ENTRY_SYNTHESIZES_16719832496998918898)],
        &[(0b10010, &ENTRY_SYNTHESIZING_961211694929147125)],
        &[(0b01001, &ENTRY_SYNTHESIZATION_7847480716228741176)],
        &[(0b01001, &ENTRY_SYNTHESIZATIONS_6008071763176942923)],
        &[(0b01001, &ENTRY_SYNTHESIZE_12262264416656123255)],
        &[(0b01001, &ENTRY_SYNTHESIZED_10277854444798047575)],
        &[(0b01001, &ENTRY_SYNTHESIZES_16719832496998918898)],
        &[(0b01001, &ENTRY_SYNTHESIZING_961211694929147125)],
        &[(0b10010, &ENTRY_SYNTHETIZATION_8539269556584261248)],
        &[(0b10010, &ENTRY_SYNTHETIZER_7370135773010889066)],
        &[(0b10010, &ENTRY_SYNTHETIZERS_13381239636453117418)],
        &[(0b01001, &ENTRY_SYNTHETIZATION_8539269556584261248)],
        &[(0b01000, &ENTRY_SYNTHESIZE_12262264416656123255)],
        &[(0b01000, &ENTRY_SYNTHESIZED_10277854444798047575)],
        &[(0b01001, &ENTRY_SYNTHETIZER_7370135773010889066)],
        &[(0b01001, &ENTRY_SYNTHETIZERS_13381239636453117418)],
        &[(0b01000, &ENTRY_SYNTHESIZES_16719832496998918898)],
        &[(0b01000, &ENTRY_SYNTHESIZING_961211694929147125)],
        &[(0b10010, &ENTRY_SYNTONIZATION_14856908759061340234)],
        &[(0b10010, &ENTRY_SYNTONIZE_1485992200194358305)],
        &[(0b10010, &ENTRY_SYNTONIZED_15041457439325800203)],
        &[(0b10010, &ENTRY_SYNTONIZES_17498682094763362419)],
        &[(0b10010, &ENTRY_SYNTONIZING_3933548631109004593)],
        &[(0b01001, &ENTRY_SYNTONIZATION_14856908759061340234)],
        &[(0b01001, &ENTRY_SYNTONIZE_1485992200194358305)],
        &[(0b01001, &ENTRY_SYNTONIZED_15041457439325800203)],
        &[(0b01001, &ENTRY_SYNTONIZES_17498682094763362419)],
        &[(0b01001, &ENTRY_SYNTONIZING_3933548631109004593)],
    ],
    range: 5..=11,
};

static VARS_SYNO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SYNO_CHILDREN),
    value: None,
};

pub static VARS_SYNO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ecious"),
        dictgen::InsensitiveStr::Ascii("ecise"),
        dictgen::InsensitiveStr::Ascii("ecised"),
        dictgen::InsensitiveStr::Ascii("ecises"),
        dictgen::InsensitiveStr::Ascii("ecising"),
        dictgen::InsensitiveStr::Ascii("ecize"),
        dictgen::InsensitiveStr::Ascii("ecized"),
        dictgen::InsensitiveStr::Ascii("ecizes"),
        dictgen::InsensitiveStr::Ascii("ecizing"),
        dictgen::InsensitiveStr::Ascii("ecologies"),
        dictgen::InsensitiveStr::Ascii("ecology"),
        dictgen::InsensitiveStr::Ascii("etic"),
        dictgen::InsensitiveStr::Ascii("nymise"),
        dictgen::InsensitiveStr::Ascii("nymised"),
        dictgen::InsensitiveStr::Ascii("nymises"),
        dictgen::InsensitiveStr::Ascii("nymising"),
        dictgen::InsensitiveStr::Ascii("nymize"),
        dictgen::InsensitiveStr::Ascii("nymized"),
        dictgen::InsensitiveStr::Ascii("nymizes"),
        dictgen::InsensitiveStr::Ascii("nymizing"),
        dictgen::InsensitiveStr::Ascii("psise"),
        dictgen::InsensitiveStr::Ascii("psised"),
        dictgen::InsensitiveStr::Ascii("psises"),
        dictgen::InsensitiveStr::Ascii("psising"),
        dictgen::InsensitiveStr::Ascii("psize"),
        dictgen::InsensitiveStr::Ascii("psized"),
        dictgen::InsensitiveStr::Ascii("psizes"),
        dictgen::InsensitiveStr::Ascii("psizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SYNECIOUS_16097725599665781486)],
        &[(0b10010, &ENTRY_SYNOECIZE_9903365931663314390)],
        &[(0b10010, &ENTRY_SYNOECIZED_1258981145885331765)],
        &[(0b10010, &ENTRY_SYNOECIZES_14157018111278412405)],
        &[(0b10010, &ENTRY_SYNOECIZING_12619177850029321994)],
        &[(0b01001, &ENTRY_SYNOECIZE_9903365931663314390)],
        &[(0b01001, &ENTRY_SYNOECIZED_1258981145885331765)],
        &[(0b01001, &ENTRY_SYNOECIZES_14157018111278412405)],
        &[(0b01001, &ENTRY_SYNOECIZING_12619177850029321994)],
        &[(0b11010, &ENTRY_SYNECOLOGIES_6305448968712762615)],
        &[(0b11010, &ENTRY_SYNECOLOGY_11727520395273669799)],
        &[(0b11010, &ENTRY_SYNETIC_11062609274567880634)],
        &[(0b10010, &ENTRY_SYNONYMIZE_3437118653893618787)],
        &[(0b10010, &ENTRY_SYNONYMIZED_16655983300964530292)],
        &[(0b10010, &ENTRY_SYNONYMIZES_5682029261506663420)],
        &[(0b10010, &ENTRY_SYNONYMIZING_10383839589382127203)],
        &[(0b01001, &ENTRY_SYNONYMIZE_3437118653893618787)],
        &[(0b01001, &ENTRY_SYNONYMIZED_16655983300964530292)],
        &[(0b01001, &ENTRY_SYNONYMIZES_5682029261506663420)],
        &[(0b01001, &ENTRY_SYNONYMIZING_10383839589382127203)],
        &[(0b10010, &ENTRY_SYNOPSIZE_5009645523556777721)],
        &[(0b10010, &ENTRY_SYNOPSIZED_1730636117992196147)],
        &[(0b10010, &ENTRY_SYNOPSIZES_14967276778682343138)],
        &[(0b10010, &ENTRY_SYNOPSIZING_8436973275561705386)],
        &[(0b01001, &ENTRY_SYNOPSIZE_5009645523556777721)],
        &[(0b01001, &ENTRY_SYNOPSIZED_1730636117992196147)],
        &[(0b01001, &ENTRY_SYNOPSIZES_14967276778682343138)],
        &[(0b01001, &ENTRY_SYNOPSIZING_8436973275561705386)],
    ],
    range: 4..=9,
};

static VARS_SYNE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SYNE_CHILDREN),
    value: None,
};

pub static VARS_SYNE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cious"),
        dictgen::InsensitiveStr::Ascii("cologies"),
        dictgen::InsensitiveStr::Ascii("cology"),
        dictgen::InsensitiveStr::Ascii("reses"),
        dictgen::InsensitiveStr::Ascii("resis"),
        dictgen::InsensitiveStr::Ascii("rgise"),
        dictgen::InsensitiveStr::Ascii("rgised"),
        dictgen::InsensitiveStr::Ascii("rgises"),
        dictgen::InsensitiveStr::Ascii("rgising"),
        dictgen::InsensitiveStr::Ascii("rgize"),
        dictgen::InsensitiveStr::Ascii("rgized"),
        dictgen::InsensitiveStr::Ascii("rgizes"),
        dictgen::InsensitiveStr::Ascii("rgizing"),
        dictgen::InsensitiveStr::Ascii("sthesia"),
        dictgen::InsensitiveStr::Ascii("sthesias"),
        dictgen::InsensitiveStr::Ascii("sthetic"),
        dictgen::InsensitiveStr::Ascii("stheticer"),
        dictgen::InsensitiveStr::Ascii("stheticest"),
        dictgen::InsensitiveStr::Ascii("tic"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SYNECIOUS_16097725599665781486)],
        &[(0b00001, &ENTRY_SYNECOLOGIES_6305448968712762615)],
        &[(0b00001, &ENTRY_SYNECOLOGY_11727520395273669799)],
        &[(0b00001, &ENTRY_SYNERESES_8324225573506584897)],
        &[(0b00001, &ENTRY_SYNERESIS_10899482620726729247)],
        &[(0b10010, &ENTRY_SYNERGIZE_8702906954167154251)],
        &[(0b10010, &ENTRY_SYNERGIZED_2939063503049761679)],
        &[(0b10010, &ENTRY_SYNERGIZES_1372737127479711106)],
        &[(0b10010, &ENTRY_SYNERGIZING_11050376152195270684)],
        &[(0b01001, &ENTRY_SYNERGIZE_8702906954167154251)],
        &[(0b01001, &ENTRY_SYNERGIZED_2939063503049761679)],
        &[(0b01001, &ENTRY_SYNERGIZES_1372737127479711106)],
        &[(0b01001, &ENTRY_SYNERGIZING_11050376152195270684)],
        &[(0b10001, &ENTRY_SYNESTHESIA_16292496210206747868)],
        &[(0b10001, &ENTRY_SYNESTHESIAS_15212694822545420870)],
        &[(0b10001, &ENTRY_SYNESTHETIC_3600503920231115312)],
        &[(0b10001, &ENTRY_SYNESTHETICER_10910454298234931775)],
        &[(0b10001, &ENTRY_SYNESTHETICEST_831211085037853858)],
        &[(0b00001, &ENTRY_SYNETIC_11062609274567880634)],
    ],
    range: 3..=10,
};

static VARS_SYND_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SYND_CHILDREN),
    value: None,
};

pub static VARS_SYND_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("icalise"),
        dictgen::InsensitiveStr::Ascii("icalises"),
        dictgen::InsensitiveStr::Ascii("icalize"),
        dictgen::InsensitiveStr::Ascii("icalizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SYNDICALIZE_6097714922943684680)],
        &[(0b10010, &ENTRY_SYNDICALIZES_7458900059096200056)],
        &[(0b01001, &ENTRY_SYNDICALIZE_6097714922943684680)],
        &[(0b01001, &ENTRY_SYNDICALIZES_7458900059096200056)],
    ],
    range: 7..=8,
};

static VARS_SYNC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SYNC_CHILDREN),
    value: None,
};

pub static VARS_SYNC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hronisable"),
        dictgen::InsensitiveStr::Ascii("hronisables"),
        dictgen::InsensitiveStr::Ascii("hronisation"),
        dictgen::InsensitiveStr::Ascii("hronisations"),
        dictgen::InsensitiveStr::Ascii("hronise"),
        dictgen::InsensitiveStr::Ascii("hronised"),
        dictgen::InsensitiveStr::Ascii("hroniser"),
        dictgen::InsensitiveStr::Ascii("hronisers"),
        dictgen::InsensitiveStr::Ascii("hronises"),
        dictgen::InsensitiveStr::Ascii("hronising"),
        dictgen::InsensitiveStr::Ascii("hronizable"),
        dictgen::InsensitiveStr::Ascii("hronizables"),
        dictgen::InsensitiveStr::Ascii("hronization"),
        dictgen::InsensitiveStr::Ascii("hronizations"),
        dictgen::InsensitiveStr::Ascii("hronize"),
        dictgen::InsensitiveStr::Ascii("hronized"),
        dictgen::InsensitiveStr::Ascii("hronizer"),
        dictgen::InsensitiveStr::Ascii("hronizers"),
        dictgen::InsensitiveStr::Ascii("hronizes"),
        dictgen::InsensitiveStr::Ascii("hronizing"),
        dictgen::InsensitiveStr::Ascii("retise"),
        dictgen::InsensitiveStr::Ascii("retised"),
        dictgen::InsensitiveStr::Ascii("retises"),
        dictgen::InsensitiveStr::Ascii("retising"),
        dictgen::InsensitiveStr::Ascii("retize"),
        dictgen::InsensitiveStr::Ascii("retized"),
        dictgen::InsensitiveStr::Ascii("retizes"),
        dictgen::InsensitiveStr::Ascii("retizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SYNCHRONIZABLE_3205035752239437919)],
        &[(0b10010, &ENTRY_SYNCHRONIZABLES_11909224206869588914)],
        &[(0b10010, &ENTRY_SYNCHRONIZATION_5190235443366915825)],
        &[(0b10010, &ENTRY_SYNCHRONIZATIONS_17488049115311509779)],
        &[(0b10010, &ENTRY_SYNCHRONIZE_15214148970446599589)],
        &[(0b10010, &ENTRY_SYNCHRONIZED_10463645930849898556)],
        &[(0b10010, &ENTRY_SYNCHRONIZER_18217273731132106451)],
        &[(0b10010, &ENTRY_SYNCHRONIZERS_7212648156840732242)],
        &[(0b10010, &ENTRY_SYNCHRONIZES_1300752223538140438)],
        &[(0b10010, &ENTRY_SYNCHRONIZING_16424531352538153842)],
        &[(0b01001, &ENTRY_SYNCHRONIZABLE_3205035752239437919)],
        &[(0b01001, &ENTRY_SYNCHRONIZABLES_11909224206869588914)],
        &[(0b01001, &ENTRY_SYNCHRONIZATION_5190235443366915825)],
        &[(0b01001, &ENTRY_SYNCHRONIZATIONS_17488049115311509779)],
        &[(0b01001, &ENTRY_SYNCHRONIZE_15214148970446599589)],
        &[(0b01001, &ENTRY_SYNCHRONIZED_10463645930849898556)],
        &[(0b01001, &ENTRY_SYNCHRONIZER_18217273731132106451)],
        &[(0b01001, &ENTRY_SYNCHRONIZERS_7212648156840732242)],
        &[(0b01001, &ENTRY_SYNCHRONIZES_1300752223538140438)],
        &[(0b01001, &ENTRY_SYNCHRONIZING_16424531352538153842)],
        &[(0b10010, &ENTRY_SYNCRETIZE_11946220904942894650)],
        &[(0b10010, &ENTRY_SYNCRETIZED_132756498383462765)],
        &[(0b10010, &ENTRY_SYNCRETIZES_15427417846092983438)],
        &[(0b10010, &ENTRY_SYNCRETIZING_16214408936304608287)],
        &[(0b01001, &ENTRY_SYNCRETIZE_11946220904942894650)],
        &[(0b01001, &ENTRY_SYNCRETIZED_132756498383462765)],
        &[(0b01001, &ENTRY_SYNCRETIZES_15427417846092983438)],
        &[(0b01001, &ENTRY_SYNCRETIZING_16214408936304608287)],
    ],
    range: 6..=12,
};

static VARS_SYNA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SYNA_CHILDREN),
    value: None,
};

pub static VARS_SYNA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ereses"),
        dictgen::InsensitiveStr::Ascii("eresis"),
        dictgen::InsensitiveStr::Ascii("esthesia"),
        dictgen::InsensitiveStr::Ascii("esthesias"),
        dictgen::InsensitiveStr::Ascii("esthetic"),
        dictgen::InsensitiveStr::Ascii("estheticer"),
        dictgen::InsensitiveStr::Ascii("estheticest"),
        dictgen::InsensitiveStr::Ascii("lepha"),
        dictgen::InsensitiveStr::Ascii("lephas"),
        dictgen::InsensitiveStr::Ascii("lephe"),
        dictgen::InsensitiveStr::Ascii("loepha"),
        dictgen::InsensitiveStr::Ascii("loephas"),
        dictgen::InsensitiveStr::Ascii("loephe"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SYNERESES_8324225573506584897)],
        &[(0b11010, &ENTRY_SYNERESIS_10899482620726729247)],
        &[(0b11010, &ENTRY_SYNESTHESIA_16292496210206747868)],
        &[(0b11010, &ENTRY_SYNESTHESIAS_15212694822545420870)],
        &[(0b11010, &ENTRY_SYNESTHETIC_3600503920231115312)],
        &[(0b11010, &ENTRY_SYNESTHETICER_10910454298234931775)],
        &[(0b11010, &ENTRY_SYNESTHETICEST_831211085037853858)],
        &[(0b00001, &ENTRY_SYNALEPHA_7165508884472247255)],
        &[(0b00001, &ENTRY_SYNALEPHAS_15856626290957460889)],
        &[(0b00001, &ENTRY_SYNALEPHE_7691233255701997232)],
        &[(0b11010, &ENTRY_SYNALEPHA_7165508884472247255)],
        &[(0b11010, &ENTRY_SYNALEPHAS_15856626290957460889)],
        &[(0b11010, &ENTRY_SYNALEPHE_7691233255701997232)],
    ],
    range: 5..=11,
};

static VARS_SYM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SYM_CHILDREN),
    value: None,
};

static VARS_SYM_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_SYMB_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SYMM_NODE),
    None,
    None,
    Some(&VARS_SYMP_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_SYMP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SYMP_CHILDREN),
    value: None,
};

pub static VARS_SYMP_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("athise"),
        dictgen::InsensitiveStr::Ascii("athised"),
        dictgen::InsensitiveStr::Ascii("athiser"),
        dictgen::InsensitiveStr::Ascii("athisers"),
        dictgen::InsensitiveStr::Ascii("athises"),
        dictgen::InsensitiveStr::Ascii("athising"),
        dictgen::InsensitiveStr::Ascii("athisinglier"),
        dictgen::InsensitiveStr::Ascii("athisingliest"),
        dictgen::InsensitiveStr::Ascii("athisingly"),
        dictgen::InsensitiveStr::Ascii("athisings"),
        dictgen::InsensitiveStr::Ascii("athize"),
        dictgen::InsensitiveStr::Ascii("athized"),
        dictgen::InsensitiveStr::Ascii("athizer"),
        dictgen::InsensitiveStr::Ascii("athizers"),
        dictgen::InsensitiveStr::Ascii("athizes"),
        dictgen::InsensitiveStr::Ascii("athizing"),
        dictgen::InsensitiveStr::Ascii("athizinglier"),
        dictgen::InsensitiveStr::Ascii("athizingliest"),
        dictgen::InsensitiveStr::Ascii("athizingly"),
        dictgen::InsensitiveStr::Ascii("athizings"),
        dictgen::InsensitiveStr::Ascii("honisation"),
        dictgen::InsensitiveStr::Ascii("honise"),
        dictgen::InsensitiveStr::Ascii("honised"),
        dictgen::InsensitiveStr::Ascii("honising"),
        dictgen::InsensitiveStr::Ascii("honization"),
        dictgen::InsensitiveStr::Ascii("honize"),
        dictgen::InsensitiveStr::Ascii("honized"),
        dictgen::InsensitiveStr::Ascii("honizing"),
        dictgen::InsensitiveStr::Ascii("tomatise"),
        dictgen::InsensitiveStr::Ascii("tomatised"),
        dictgen::InsensitiveStr::Ascii("tomatises"),
        dictgen::InsensitiveStr::Ascii("tomatising"),
        dictgen::InsensitiveStr::Ascii("tomatize"),
        dictgen::InsensitiveStr::Ascii("tomatized"),
        dictgen::InsensitiveStr::Ascii("tomatizes"),
        dictgen::InsensitiveStr::Ascii("tomatizing"),
        dictgen::InsensitiveStr::Ascii("tomise"),
        dictgen::InsensitiveStr::Ascii("tomises"),
        dictgen::InsensitiveStr::Ascii("tomize"),
        dictgen::InsensitiveStr::Ascii("tomizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SYMPATHIZE_2083128667147215284)],
        &[(0b10010, &ENTRY_SYMPATHIZED_9100939682714028608)],
        &[(0b10010, &ENTRY_SYMPATHIZER_6062465131842187171)],
        &[(0b10010, &ENTRY_SYMPATHIZERS_3558777146047267180)],
        &[(0b10010, &ENTRY_SYMPATHIZES_18348047905035226610)],
        &[(0b10010, &ENTRY_SYMPATHIZING_5627262407078518926)],
        &[(0b10010, &ENTRY_SYMPATHIZINGLIER_17003334067553508909)],
        &[(0b10010, &ENTRY_SYMPATHIZINGLIEST_8990695458438411519)],
        &[(0b10010, &ENTRY_SYMPATHIZINGLY_18120189054155456947)],
        &[(0b10010, &ENTRY_SYMPATHIZINGS_14242801861585199541)],
        &[(0b01001, &ENTRY_SYMPATHIZE_2083128667147215284)],
        &[(0b01001, &ENTRY_SYMPATHIZED_9100939682714028608)],
        &[(0b01001, &ENTRY_SYMPATHIZER_6062465131842187171)],
        &[(0b01001, &ENTRY_SYMPATHIZERS_3558777146047267180)],
        &[(0b01001, &ENTRY_SYMPATHIZES_18348047905035226610)],
        &[(0b01001, &ENTRY_SYMPATHIZING_5627262407078518926)],
        &[(0b01001, &ENTRY_SYMPATHIZINGLIER_17003334067553508909)],
        &[(0b01001, &ENTRY_SYMPATHIZINGLIEST_8990695458438411519)],
        &[(0b01001, &ENTRY_SYMPATHIZINGLY_18120189054155456947)],
        &[(0b01001, &ENTRY_SYMPATHIZINGS_14242801861585199541)],
        &[(0b10010, &ENTRY_SYMPHONIZATION_7458803542727781710)],
        &[(0b10010, &ENTRY_SYMPHONIZE_14460696128283226931)],
        &[(0b10010, &ENTRY_SYMPHONIZED_10820642800496437334)],
        &[(0b10010, &ENTRY_SYMPHONIZING_6006748045534915173)],
        &[(0b01001, &ENTRY_SYMPHONIZATION_7458803542727781710)],
        &[(0b01001, &ENTRY_SYMPHONIZE_14460696128283226931)],
        &[(0b01001, &ENTRY_SYMPHONIZED_10820642800496437334)],
        &[(0b01001, &ENTRY_SYMPHONIZING_6006748045534915173)],
        &[(0b10010, &ENTRY_SYMPTOMATIZE_7741807692536744481)],
        &[(0b10010, &ENTRY_SYMPTOMATIZED_13255146815106504892)],
        &[(0b10010, &ENTRY_SYMPTOMATIZES_17459302438827356078)],
        &[(0b10010, &ENTRY_SYMPTOMATIZING_7075635847781625915)],
        &[(0b01001, &ENTRY_SYMPTOMATIZE_7741807692536744481)],
        &[(0b01001, &ENTRY_SYMPTOMATIZED_13255146815106504892)],
        &[(0b01001, &ENTRY_SYMPTOMATIZES_17459302438827356078)],
        &[(0b01001, &ENTRY_SYMPTOMATIZING_7075635847781625915)],
        &[(0b10010, &ENTRY_SYMPTOMIZE_10180337916709250431)],
        &[(0b10010, &ENTRY_SYMPTOMIZES_2947814609442326128)],
        &[(0b01001, &ENTRY_SYMPTOMIZE_10180337916709250431)],
        &[(0b01001, &ENTRY_SYMPTOMIZES_2947814609442326128)],
    ],
    range: 6..=13,
};

static VARS_SYMM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SYMM_CHILDREN),
    value: None,
};

pub static VARS_SYMM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("etricly"),
        dictgen::InsensitiveStr::Ascii("etrisation"),
        dictgen::InsensitiveStr::Ascii("etrisations"),
        dictgen::InsensitiveStr::Ascii("etrise"),
        dictgen::InsensitiveStr::Ascii("etrised"),
        dictgen::InsensitiveStr::Ascii("etrises"),
        dictgen::InsensitiveStr::Ascii("etrising"),
        dictgen::InsensitiveStr::Ascii("etrization"),
        dictgen::InsensitiveStr::Ascii("etrizations"),
        dictgen::InsensitiveStr::Ascii("etrize"),
        dictgen::InsensitiveStr::Ascii("etrized"),
        dictgen::InsensitiveStr::Ascii("etrizes"),
        dictgen::InsensitiveStr::Ascii("etrizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SYMMETRICALLY_11790246473159683276)],
        &[(0b10010, &ENTRY_SYMMETRIZATION_485523952999666992)],
        &[(0b10010, &ENTRY_SYMMETRIZATIONS_13298765629243557367)],
        &[(0b10010, &ENTRY_SYMMETRIZE_17748763142030256395)],
        &[(0b10010, &ENTRY_SYMMETRIZED_13721183907018153188)],
        &[(0b10010, &ENTRY_SYMMETRIZES_14737575873723059815)],
        &[(0b10010, &ENTRY_SYMMETRIZING_17834200335648295925)],
        &[(0b01001, &ENTRY_SYMMETRIZATION_485523952999666992)],
        &[(0b01001, &ENTRY_SYMMETRIZATIONS_13298765629243557367)],
        &[(0b01001, &ENTRY_SYMMETRIZE_17748763142030256395)],
        &[(0b01001, &ENTRY_SYMMETRIZED_13721183907018153188)],
        &[(0b01001, &ENTRY_SYMMETRIZES_14737575873723059815)],
        &[(0b01001, &ENTRY_SYMMETRIZING_17834200335648295925)],
    ],
    range: 6..=11,
};

static VARS_SYMB_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SYMB_CHILDREN),
    value: None,
};

pub static VARS_SYMB_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("oled"),
        dictgen::InsensitiveStr::Ascii("oling"),
        dictgen::InsensitiveStr::Ascii("olisation"),
        dictgen::InsensitiveStr::Ascii("olisations"),
        dictgen::InsensitiveStr::Ascii("olise"),
        dictgen::InsensitiveStr::Ascii("olised"),
        dictgen::InsensitiveStr::Ascii("oliser"),
        dictgen::InsensitiveStr::Ascii("olisers"),
        dictgen::InsensitiveStr::Ascii("olises"),
        dictgen::InsensitiveStr::Ascii("olising"),
        dictgen::InsensitiveStr::Ascii("olization"),
        dictgen::InsensitiveStr::Ascii("olizations"),
        dictgen::InsensitiveStr::Ascii("olize"),
        dictgen::InsensitiveStr::Ascii("olized"),
        dictgen::InsensitiveStr::Ascii("olizer"),
        dictgen::InsensitiveStr::Ascii("olizers"),
        dictgen::InsensitiveStr::Ascii("olizes"),
        dictgen::InsensitiveStr::Ascii("olizing"),
        dictgen::InsensitiveStr::Ascii("olled"),
        dictgen::InsensitiveStr::Ascii("olling"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SYMBOLED_11424483443027028085)],
        &[(0b00001, &ENTRY_SYMBOLING_10019336982510109720)],
        &[(0b10010, &ENTRY_SYMBOLIZATION_16179533248304689346)],
        &[(0b10010, &ENTRY_SYMBOLIZATIONS_5969166456353671405)],
        &[(0b10010, &ENTRY_SYMBOLIZE_1459836702485298151)],
        &[(0b10010, &ENTRY_SYMBOLIZED_139431671119330705)],
        &[(0b10010, &ENTRY_SYMBOLIZER_12834461225156804749)],
        &[(0b10010, &ENTRY_SYMBOLIZERS_1983691641725453382)],
        &[(0b10010, &ENTRY_SYMBOLIZES_7534842968073056718)],
        &[(0b10010, &ENTRY_SYMBOLIZING_14319052571837316351)],
        &[(0b01001, &ENTRY_SYMBOLIZATION_16179533248304689346)],
        &[(0b01001, &ENTRY_SYMBOLIZATIONS_5969166456353671405)],
        &[(0b01001, &ENTRY_SYMBOLIZE_1459836702485298151)],
        &[(0b01001, &ENTRY_SYMBOLIZED_139431671119330705)],
        &[(0b01001, &ENTRY_SYMBOLIZER_12834461225156804749)],
        &[(0b01001, &ENTRY_SYMBOLIZERS_1983691641725453382)],
        &[(0b01001, &ENTRY_SYMBOLIZES_7534842968073056718)],
        &[(0b01001, &ENTRY_SYMBOLIZING_14319052571837316351)],
        &[(0b11010, &ENTRY_SYMBOLED_11424483443027028085)],
        &[(0b11010, &ENTRY_SYMBOLING_10019336982510109720)],
    ],
    range: 4..=10,
};

static VARS_SYL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SYL_CHILDREN),
    value: None,
};

pub static VARS_SYL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("labise"),
        dictgen::InsensitiveStr::Ascii("labised"),
        dictgen::InsensitiveStr::Ascii("labises"),
        dictgen::InsensitiveStr::Ascii("labising"),
        dictgen::InsensitiveStr::Ascii("labize"),
        dictgen::InsensitiveStr::Ascii("labized"),
        dictgen::InsensitiveStr::Ascii("labizes"),
        dictgen::InsensitiveStr::Ascii("labizing"),
        dictgen::InsensitiveStr::Ascii("logisation"),
        dictgen::InsensitiveStr::Ascii("logisations"),
        dictgen::InsensitiveStr::Ascii("logise"),
        dictgen::InsensitiveStr::Ascii("logised"),
        dictgen::InsensitiveStr::Ascii("logiser"),
        dictgen::InsensitiveStr::Ascii("logisers"),
        dictgen::InsensitiveStr::Ascii("logises"),
        dictgen::InsensitiveStr::Ascii("logising"),
        dictgen::InsensitiveStr::Ascii("logization"),
        dictgen::InsensitiveStr::Ascii("logizations"),
        dictgen::InsensitiveStr::Ascii("logize"),
        dictgen::InsensitiveStr::Ascii("logized"),
        dictgen::InsensitiveStr::Ascii("logizer"),
        dictgen::InsensitiveStr::Ascii("logizers"),
        dictgen::InsensitiveStr::Ascii("logizes"),
        dictgen::InsensitiveStr::Ascii("logizing"),
        dictgen::InsensitiveStr::Ascii("vanise"),
        dictgen::InsensitiveStr::Ascii("vanises"),
        dictgen::InsensitiveStr::Ascii("vanize"),
        dictgen::InsensitiveStr::Ascii("vanizes"),
        dictgen::InsensitiveStr::Ascii("viinae"),
        dictgen::InsensitiveStr::Ascii("viine"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SYLLABIZE_14838824136293204776)],
        &[(0b10010, &ENTRY_SYLLABIZED_9081626028680716952)],
        &[(0b10010, &ENTRY_SYLLABIZES_4355228480284739560)],
        &[(0b10010, &ENTRY_SYLLABIZING_8483234654100117810)],
        &[(0b01001, &ENTRY_SYLLABIZE_14838824136293204776)],
        &[(0b01001, &ENTRY_SYLLABIZED_9081626028680716952)],
        &[(0b01001, &ENTRY_SYLLABIZES_4355228480284739560)],
        &[(0b01001, &ENTRY_SYLLABIZING_8483234654100117810)],
        &[(0b10010, &ENTRY_SYLLOGIZATION_13866539649373728599)],
        &[(0b10010, &ENTRY_SYLLOGIZATIONS_1183019196317532349)],
        &[(0b10010, &ENTRY_SYLLOGIZE_4080740851235947751)],
        &[(0b10010, &ENTRY_SYLLOGIZED_8853526086846614350)],
        &[(0b10010, &ENTRY_SYLLOGIZER_18106093548206015296)],
        &[(0b10010, &ENTRY_SYLLOGIZERS_16910938558367919539)],
        &[(0b10010, &ENTRY_SYLLOGIZES_4817593494892630151)],
        &[(0b10010, &ENTRY_SYLLOGIZING_2067797967245895866)],
        &[(0b01001, &ENTRY_SYLLOGIZATION_13866539649373728599)],
        &[(0b01001, &ENTRY_SYLLOGIZATIONS_1183019196317532349)],
        &[(0b01001, &ENTRY_SYLLOGIZE_4080740851235947751)],
        &[(0b01001, &ENTRY_SYLLOGIZED_8853526086846614350)],
        &[(0b01001, &ENTRY_SYLLOGIZER_18106093548206015296)],
        &[(0b01001, &ENTRY_SYLLOGIZERS_16910938558367919539)],
        &[(0b01001, &ENTRY_SYLLOGIZES_4817593494892630151)],
        &[(0b01001, &ENTRY_SYLLOGIZING_2067797967245895866)],
        &[(0b10010, &ENTRY_SYLVANIZE_6265985924948097486)],
        &[(0b10010, &ENTRY_SYLVANIZES_12196473219346057983)],
        &[(0b01001, &ENTRY_SYLVANIZE_6265985924948097486)],
        &[(0b01001, &ENTRY_SYLVANIZES_12196473219346057983)],
        &[(0b11010, &ENTRY_SYLVIINE_8241338552519015158)],
        &[(0b00001, &ENTRY_SYLVIINE_8241338552519015158)],
    ],
    range: 5..=11,
};

static VARS_SYC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SYC_CHILDREN),
    value: None,
};

pub static VARS_SYC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ophantise"),
        dictgen::InsensitiveStr::Ascii("ophantised"),
        dictgen::InsensitiveStr::Ascii("ophantises"),
        dictgen::InsensitiveStr::Ascii("ophantising"),
        dictgen::InsensitiveStr::Ascii("ophantize"),
        dictgen::InsensitiveStr::Ascii("ophantized"),
        dictgen::InsensitiveStr::Ascii("ophantizes"),
        dictgen::InsensitiveStr::Ascii("ophantizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SYCOPHANTIZE_12413841667742806235)],
        &[(0b10010, &ENTRY_SYCOPHANTIZED_2066913815102436404)],
        &[(0b10010, &ENTRY_SYCOPHANTIZES_13350123606555790806)],
        &[(0b10010, &ENTRY_SYCOPHANTIZING_3707179500919311993)],
        &[(0b01001, &ENTRY_SYCOPHANTIZE_12413841667742806235)],
        &[(0b01001, &ENTRY_SYCOPHANTIZED_2066913815102436404)],
        &[(0b01001, &ENTRY_SYCOPHANTIZES_13350123606555790806)],
        &[(0b01001, &ENTRY_SYCOPHANTIZING_3707179500919311993)],
    ],
    range: 9..=11,
};

static VARS_SW_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SW_CHILDREN),
    value: None,
};

pub static VARS_SW_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("iveled"),
        dictgen::InsensitiveStr::Ascii("iveling"),
        dictgen::InsensitiveStr::Ascii("ivelled"),
        dictgen::InsensitiveStr::Ascii("ivelling"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SWIVELED_17790968621944461091)],
        &[(0b00001, &ENTRY_SWIVELING_11766360434972105410)],
        &[(0b11010, &ENTRY_SWIVELED_17790968621944461091)],
        &[(0b11010, &ENTRY_SWIVELING_11766360434972105410)],
    ],
    range: 6..=8,
};

static VARS_SU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SU_CHILDREN),
    value: None,
};

static VARS_SU_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_SUB_NODE),
    Some(&VARS_SUC_NODE),
    None,
    Some(&VARS_SUE_NODE),
    None,
    Some(&VARS_SUG_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_SUL_NODE),
    Some(&VARS_SUM_NODE),
    None,
    None,
    Some(&VARS_SUP_NODE),
    None,
    Some(&VARS_SUR_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_SUR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUR_CHILDREN),
    value: None,
};

pub static VARS_SUR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("gerise"),
        dictgen::InsensitiveStr::Ascii("gerises"),
        dictgen::InsensitiveStr::Ascii("gerize"),
        dictgen::InsensitiveStr::Ascii("gerizes"),
        dictgen::InsensitiveStr::Ascii("prisal"),
        dictgen::InsensitiveStr::Ascii("prizal"),
        dictgen::InsensitiveStr::Ascii("sise"),
        dictgen::InsensitiveStr::Ascii("size"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SUERS_7272934736981736758)],
        &[(0b10010, &ENTRY_SURGERIZE_4983277252612670769)],
        &[(0b10010, &ENTRY_SURGERIZES_13175724116978873269)],
        &[(0b01001, &ENTRY_SURGERIZE_4983277252612670769)],
        &[(0b01001, &ENTRY_SURGERIZES_13175724116978873269)],
        &[(0b10010, &ENTRY_SURPRIZAL_5281380386605833450)],
        &[(0b01001, &ENTRY_SURPRIZAL_5281380386605833450)],
        &[(0b10010, &ENTRY_SURSIZE_3670570722345111046)],
        &[(0b01001, &ENTRY_SURSIZE_3670570722345111046)],
    ],
    range: 2..=7,
};

static VARS_SUP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SUP_CHILDREN),
    value: None,
};

static VARS_SUP_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    Some(&VARS_SUPE_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_SUPE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SUPE_CHILDREN),
    value: None,
};

static VARS_SUPE_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SUPER_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_SUPER_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SUPER_CHILDREN),
    value: None,
};

static VARS_SUPER_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_SUPERA_NODE),
    None,
    Some(&VARS_SUPERC_NODE),
    None,
    Some(&VARS_SUPERE_NODE),
    Some(&VARS_SUPERF_NODE),
    None,
    Some(&VARS_SUPERH_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SUPERN_NODE),
    Some(&VARS_SUPERO_NODE),
    None,
    None,
    None,
    Some(&VARS_SUPERS_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_SUPERS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUPERS_CHILDREN),
    value: None,
};

pub static VARS_SUPERS_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ensitisation"),
        dictgen::InsensitiveStr::Ascii("ensitisations"),
        dictgen::InsensitiveStr::Ascii("ensitise"),
        dictgen::InsensitiveStr::Ascii("ensitised"),
        dictgen::InsensitiveStr::Ascii("ensitising"),
        dictgen::InsensitiveStr::Ascii("ensitization"),
        dictgen::InsensitiveStr::Ascii("ensitizations"),
        dictgen::InsensitiveStr::Ascii("ensitize"),
        dictgen::InsensitiveStr::Ascii("ensitized"),
        dictgen::InsensitiveStr::Ascii("ensitizing"),
        dictgen::InsensitiveStr::Ascii("pecialise"),
        dictgen::InsensitiveStr::Ascii("pecialises"),
        dictgen::InsensitiveStr::Ascii("pecialize"),
        dictgen::InsensitiveStr::Ascii("pecializes"),
        dictgen::InsensitiveStr::Ascii("ubtilised"),
        dictgen::InsensitiveStr::Ascii("ubtiliseds"),
        dictgen::InsensitiveStr::Ascii("ubtilized"),
        dictgen::InsensitiveStr::Ascii("ubtilizeds"),
        dictgen::InsensitiveStr::Ascii("ulphurise"),
        dictgen::InsensitiveStr::Ascii("ulphurises"),
        dictgen::InsensitiveStr::Ascii("ulphurize"),
        dictgen::InsensitiveStr::Ascii("ulphurizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUPERSENSITIZATION_13006014246685708385)],
        &[(0b10010, &ENTRY_SUPERSENSITIZATIONS_17166516002820124032)],
        &[(0b10010, &ENTRY_SUPERSENSITIZE_7006527570782329036)],
        &[(0b10010, &ENTRY_SUPERSENSITIZED_1021249000838099530)],
        &[(0b10010, &ENTRY_SUPERSENSITIZING_5029091819363480393)],
        &[(0b01001, &ENTRY_SUPERSENSITIZATION_13006014246685708385)],
        &[(0b01001, &ENTRY_SUPERSENSITIZATIONS_17166516002820124032)],
        &[(0b01001, &ENTRY_SUPERSENSITIZE_7006527570782329036)],
        &[(0b01001, &ENTRY_SUPERSENSITIZED_1021249000838099530)],
        &[(0b01001, &ENTRY_SUPERSENSITIZING_5029091819363480393)],
        &[(0b10010, &ENTRY_SUPERSPECIALIZE_252058508575789924)],
        &[(0b10010, &ENTRY_SUPERSPECIALIZES_4737590243517715555)],
        &[(0b01001, &ENTRY_SUPERSPECIALIZE_252058508575789924)],
        &[(0b01001, &ENTRY_SUPERSPECIALIZES_4737590243517715555)],
        &[(0b10010, &ENTRY_SUPERSUBTILIZED_11208309807789263657)],
        &[(0b10010, &ENTRY_SUPERSUBTILIZEDS_13560124924918518109)],
        &[(0b01001, &ENTRY_SUPERSUBTILIZED_11208309807789263657)],
        &[(0b01001, &ENTRY_SUPERSUBTILIZEDS_13560124924918518109)],
        &[(0b10010, &ENTRY_SUPERSULPHURIZE_3926397118291965214)],
        &[(0b10010, &ENTRY_SUPERSULPHURIZES_1086828648943519821)],
        &[(0b01001, &ENTRY_SUPERSULPHURIZE_3926397118291965214)],
        &[(0b01001, &ENTRY_SUPERSULPHURIZES_1086828648943519821)],
    ],
    range: 8..=13,
};

static VARS_SUPERO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUPERO_CHILDREN),
    value: None,
};

pub static VARS_SUPERO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rganisation"),
        dictgen::InsensitiveStr::Ascii("rganisations"),
        dictgen::InsensitiveStr::Ascii("rganise"),
        dictgen::InsensitiveStr::Ascii("rganises"),
        dictgen::InsensitiveStr::Ascii("rganization"),
        dictgen::InsensitiveStr::Ascii("rganizations"),
        dictgen::InsensitiveStr::Ascii("rganize"),
        dictgen::InsensitiveStr::Ascii("rganizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUPERORGANIZATION_8860022256249649969)],
        &[(0b10010, &ENTRY_SUPERORGANIZATIONS_10617131285596283213)],
        &[(0b10010, &ENTRY_SUPERORGANIZE_8384924288227808894)],
        &[(0b10010, &ENTRY_SUPERORGANIZES_5444912774808934766)],
        &[(0b01001, &ENTRY_SUPERORGANIZATION_8860022256249649969)],
        &[(0b01001, &ENTRY_SUPERORGANIZATIONS_10617131285596283213)],
        &[(0b01001, &ENTRY_SUPERORGANIZE_8384924288227808894)],
        &[(0b01001, &ENTRY_SUPERORGANIZES_5444912774808934766)],
    ],
    range: 7..=12,
};

static VARS_SUPERN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUPERN_CHILDREN),
    value: None,
};

pub static VARS_SUPERN_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aturalise"),
        dictgen::InsensitiveStr::Ascii("aturalised"),
        dictgen::InsensitiveStr::Ascii("aturalises"),
        dictgen::InsensitiveStr::Ascii("aturalising"),
        dictgen::InsensitiveStr::Ascii("aturalize"),
        dictgen::InsensitiveStr::Ascii("aturalized"),
        dictgen::InsensitiveStr::Ascii("aturalizes"),
        dictgen::InsensitiveStr::Ascii("aturalizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUPERNATURALIZE_14037531297937878869)],
        &[(0b10010, &ENTRY_SUPERNATURALIZED_14415170850743090399)],
        &[(0b10010, &ENTRY_SUPERNATURALIZES_16951225069063962411)],
        &[(0b10010, &ENTRY_SUPERNATURALIZING_8508315994313061480)],
        &[(0b01001, &ENTRY_SUPERNATURALIZE_14037531297937878869)],
        &[(0b01001, &ENTRY_SUPERNATURALIZED_14415170850743090399)],
        &[(0b01001, &ENTRY_SUPERNATURALIZES_16951225069063962411)],
        &[(0b01001, &ENTRY_SUPERNATURALIZING_8508315994313061480)],
    ],
    range: 9..=11,
};

static VARS_SUPERH_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUPERH_CHILDREN),
    value: None,
};

pub static VARS_SUPERH_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("umanise"),
        dictgen::InsensitiveStr::Ascii("umanised"),
        dictgen::InsensitiveStr::Ascii("umanises"),
        dictgen::InsensitiveStr::Ascii("umanising"),
        dictgen::InsensitiveStr::Ascii("umanize"),
        dictgen::InsensitiveStr::Ascii("umanized"),
        dictgen::InsensitiveStr::Ascii("umanizes"),
        dictgen::InsensitiveStr::Ascii("umanizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUPERHUMANIZE_15633115389662702814)],
        &[(0b10010, &ENTRY_SUPERHUMANIZED_15608702836101169679)],
        &[(0b10010, &ENTRY_SUPERHUMANIZES_10570138598632742368)],
        &[(0b10010, &ENTRY_SUPERHUMANIZING_4071636756107716090)],
        &[(0b01001, &ENTRY_SUPERHUMANIZE_15633115389662702814)],
        &[(0b01001, &ENTRY_SUPERHUMANIZED_15608702836101169679)],
        &[(0b01001, &ENTRY_SUPERHUMANIZES_10570138598632742368)],
        &[(0b01001, &ENTRY_SUPERHUMANIZING_4071636756107716090)],
    ],
    range: 7..=9,
};

static VARS_SUPERF_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUPERF_CHILDREN),
    value: None,
};

pub static VARS_SUPERF_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("etation"),
        dictgen::InsensitiveStr::Ascii("etations"),
        dictgen::InsensitiveStr::Ascii("icialise"),
        dictgen::InsensitiveStr::Ascii("icialised"),
        dictgen::InsensitiveStr::Ascii("icialises"),
        dictgen::InsensitiveStr::Ascii("icialising"),
        dictgen::InsensitiveStr::Ascii("icialize"),
        dictgen::InsensitiveStr::Ascii("icialized"),
        dictgen::InsensitiveStr::Ascii("icializes"),
        dictgen::InsensitiveStr::Ascii("icializing"),
        dictgen::InsensitiveStr::Ascii("oetation"),
        dictgen::InsensitiveStr::Ascii("oetations"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SUPERFETATION_12600225493156545849)],
        &[(0b00001, &ENTRY_SUPERFETATIONS_10292712087384952307)],
        &[(0b10010, &ENTRY_SUPERFICIALIZE_2738339175970343799)],
        &[(0b10010, &ENTRY_SUPERFICIALIZED_16789114853240296207)],
        &[(0b10010, &ENTRY_SUPERFICIALIZES_17549727985126882796)],
        &[(0b10010, &ENTRY_SUPERFICIALIZING_17334979727341640969)],
        &[(0b01001, &ENTRY_SUPERFICIALIZE_2738339175970343799)],
        &[(0b01001, &ENTRY_SUPERFICIALIZED_16789114853240296207)],
        &[(0b01001, &ENTRY_SUPERFICIALIZES_17549727985126882796)],
        &[(0b01001, &ENTRY_SUPERFICIALIZING_17334979727341640969)],
        &[(0b11010, &ENTRY_SUPERFETATION_12600225493156545849)],
        &[(0b11010, &ENTRY_SUPERFETATIONS_10292712087384952307)],
    ],
    range: 7..=10,
};

static VARS_SUPERE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUPERE_CHILDREN),
    value: None,
};

pub static VARS_SUPERE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("mphasise"),
        dictgen::InsensitiveStr::Ascii("mphasises"),
        dictgen::InsensitiveStr::Ascii("mphasize"),
        dictgen::InsensitiveStr::Ascii("mphasizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUPEREMPHASIZE_3382031681661300047)],
        &[(0b10010, &ENTRY_SUPEREMPHASIZES_11905195641762477558)],
        &[(0b01001, &ENTRY_SUPEREMPHASIZE_3382031681661300047)],
        &[(0b01001, &ENTRY_SUPEREMPHASIZES_11905195641762477558)],
    ],
    range: 8..=9,
};

static VARS_SUPERC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUPERC_CHILDREN),
    value: None,
};

pub static VARS_SUPERC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("anonisation"),
        dictgen::InsensitiveStr::Ascii("anonisations"),
        dictgen::InsensitiveStr::Ascii("anonization"),
        dictgen::InsensitiveStr::Ascii("anonizations"),
        dictgen::InsensitiveStr::Ascii("arbonisation"),
        dictgen::InsensitiveStr::Ascii("arbonisations"),
        dictgen::InsensitiveStr::Ascii("arbonise"),
        dictgen::InsensitiveStr::Ascii("arbonises"),
        dictgen::InsensitiveStr::Ascii("arbonization"),
        dictgen::InsensitiveStr::Ascii("arbonizations"),
        dictgen::InsensitiveStr::Ascii("arbonize"),
        dictgen::InsensitiveStr::Ascii("arbonizes"),
        dictgen::InsensitiveStr::Ascii("ivilisation"),
        dictgen::InsensitiveStr::Ascii("ivilisations"),
        dictgen::InsensitiveStr::Ascii("ivilised"),
        dictgen::InsensitiveStr::Ascii("iviliseds"),
        dictgen::InsensitiveStr::Ascii("ivilization"),
        dictgen::InsensitiveStr::Ascii("ivilizations"),
        dictgen::InsensitiveStr::Ascii("ivilized"),
        dictgen::InsensitiveStr::Ascii("ivilizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUPERCANONIZATION_4336218867107151380)],
        &[(0b10010, &ENTRY_SUPERCANONIZATIONS_4755355331109857311)],
        &[(0b01001, &ENTRY_SUPERCANONIZATION_4336218867107151380)],
        &[(0b01001, &ENTRY_SUPERCANONIZATIONS_4755355331109857311)],
        &[(0b10010, &ENTRY_SUPERCARBONIZATION_1217950256825062958)],
        &[(0b10010, &ENTRY_SUPERCARBONIZATIONS_10831679594408466920)],
        &[(0b10010, &ENTRY_SUPERCARBONIZE_7821965803696896835)],
        &[(0b10010, &ENTRY_SUPERCARBONIZES_683964189361439315)],
        &[(0b01001, &ENTRY_SUPERCARBONIZATION_1217950256825062958)],
        &[(0b01001, &ENTRY_SUPERCARBONIZATIONS_10831679594408466920)],
        &[(0b01001, &ENTRY_SUPERCARBONIZE_7821965803696896835)],
        &[(0b01001, &ENTRY_SUPERCARBONIZES_683964189361439315)],
        &[(0b10010, &ENTRY_SUPERCIVILIZATION_1458840308729646079)],
        &[(0b10010, &ENTRY_SUPERCIVILIZATIONS_2634390504398689511)],
        &[(0b10010, &ENTRY_SUPERCIVILIZED_2238853392228517699)],
        &[(0b10010, &ENTRY_SUPERCIVILIZEDS_2859106069953321338)],
        &[(0b01001, &ENTRY_SUPERCIVILIZATION_1458840308729646079)],
        &[(0b01001, &ENTRY_SUPERCIVILIZATIONS_2634390504398689511)],
        &[(0b01001, &ENTRY_SUPERCIVILIZED_2238853392228517699)],
        &[(0b01001, &ENTRY_SUPERCIVILIZEDS_2859106069953321338)],
    ],
    range: 8..=13,
};

static VARS_SUPERA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUPERA_CHILDREN),
    value: None,
};

pub static VARS_SUPERA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cknowledgement"),
        dictgen::InsensitiveStr::Ascii("cknowledgements"),
        dictgen::InsensitiveStr::Ascii("cknowledgment"),
        dictgen::InsensitiveStr::Ascii("cknowledgments"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SUPERACKNOWLEDGMENT_18055315220706538962)],
        &[(0b11010, &ENTRY_SUPERACKNOWLEDGMENTS_7768783977000239516)],
        &[(0b00001, &ENTRY_SUPERACKNOWLEDGMENT_18055315220706538962)],
        &[(0b00001, &ENTRY_SUPERACKNOWLEDGMENTS_7768783977000239516)],
    ],
    range: 13..=15,
};

static VARS_SUM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUM_CHILDREN),
    value: None,
};

pub static VARS_SUM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("marisable"),
        dictgen::InsensitiveStr::Ascii("marisation"),
        dictgen::InsensitiveStr::Ascii("marisations"),
        dictgen::InsensitiveStr::Ascii("marise"),
        dictgen::InsensitiveStr::Ascii("marised"),
        dictgen::InsensitiveStr::Ascii("mariser"),
        dictgen::InsensitiveStr::Ascii("marisers"),
        dictgen::InsensitiveStr::Ascii("marises"),
        dictgen::InsensitiveStr::Ascii("marising"),
        dictgen::InsensitiveStr::Ascii("marizable"),
        dictgen::InsensitiveStr::Ascii("marization"),
        dictgen::InsensitiveStr::Ascii("marizations"),
        dictgen::InsensitiveStr::Ascii("marize"),
        dictgen::InsensitiveStr::Ascii("marized"),
        dictgen::InsensitiveStr::Ascii("marizer"),
        dictgen::InsensitiveStr::Ascii("marizers"),
        dictgen::InsensitiveStr::Ascii("marizes"),
        dictgen::InsensitiveStr::Ascii("marizing"),
        dictgen::InsensitiveStr::Ascii("merise"),
        dictgen::InsensitiveStr::Ascii("merises"),
        dictgen::InsensitiveStr::Ascii("merize"),
        dictgen::InsensitiveStr::Ascii("merizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUMMARIZABLE_8885048172619412441)],
        &[(0b10010, &ENTRY_SUMMARIZATION_1450117887113919650)],
        &[(0b10010, &ENTRY_SUMMARIZATIONS_6246410965460713485)],
        &[(0b10010, &ENTRY_SUMMARIZE_4043965903576683508)],
        &[(0b10010, &ENTRY_SUMMARIZED_11820249661747504946)],
        &[(0b10010, &ENTRY_SUMMARIZER_10384176123331578848)],
        &[(0b10010, &ENTRY_SUMMARIZERS_10721471147508695276)],
        &[(0b10010, &ENTRY_SUMMARIZES_14818168405290018071)],
        &[(0b10010, &ENTRY_SUMMARIZING_4468233879394675836)],
        &[(0b01001, &ENTRY_SUMMARIZABLE_8885048172619412441)],
        &[(0b01001, &ENTRY_SUMMARIZATION_1450117887113919650)],
        &[(0b01001, &ENTRY_SUMMARIZATIONS_6246410965460713485)],
        &[(0b01001, &ENTRY_SUMMARIZE_4043965903576683508)],
        &[(0b01001, &ENTRY_SUMMARIZED_11820249661747504946)],
        &[(0b01001, &ENTRY_SUMMARIZER_10384176123331578848)],
        &[(0b01001, &ENTRY_SUMMARIZERS_10721471147508695276)],
        &[(0b01001, &ENTRY_SUMMARIZES_14818168405290018071)],
        &[(0b01001, &ENTRY_SUMMARIZING_4468233879394675836)],
        &[(0b10010, &ENTRY_SUMMERIZE_4051177429594741620)],
        &[(0b10010, &ENTRY_SUMMERIZES_12278244173537641354)],
        &[(0b01001, &ENTRY_SUMMERIZE_4051177429594741620)],
        &[(0b01001, &ENTRY_SUMMERIZES_12278244173537641354)],
    ],
    range: 6..=11,
};

static VARS_SUL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUL_CHILDREN),
    value: None,
};

pub static VARS_SUL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("calise"),
        dictgen::InsensitiveStr::Ascii("calised"),
        dictgen::InsensitiveStr::Ascii("calises"),
        dictgen::InsensitiveStr::Ascii("calising"),
        dictgen::InsensitiveStr::Ascii("calize"),
        dictgen::InsensitiveStr::Ascii("calized"),
        dictgen::InsensitiveStr::Ascii("calizes"),
        dictgen::InsensitiveStr::Ascii("calizing"),
        dictgen::InsensitiveStr::Ascii("fate"),
        dictgen::InsensitiveStr::Ascii("fates"),
        dictgen::InsensitiveStr::Ascii("fatise"),
        dictgen::InsensitiveStr::Ascii("fatises"),
        dictgen::InsensitiveStr::Ascii("fatize"),
        dictgen::InsensitiveStr::Ascii("fatizes"),
        dictgen::InsensitiveStr::Ascii("fide"),
        dictgen::InsensitiveStr::Ascii("fides"),
        dictgen::InsensitiveStr::Ascii("furic"),
        dictgen::InsensitiveStr::Ascii("furization"),
        dictgen::InsensitiveStr::Ascii("furizations"),
        dictgen::InsensitiveStr::Ascii("furize"),
        dictgen::InsensitiveStr::Ascii("furized"),
        dictgen::InsensitiveStr::Ascii("furizes"),
        dictgen::InsensitiveStr::Ascii("furizing"),
        dictgen::InsensitiveStr::Ascii("furous"),
        dictgen::InsensitiveStr::Ascii("phate"),
        dictgen::InsensitiveStr::Ascii("phates"),
        dictgen::InsensitiveStr::Ascii("phide"),
        dictgen::InsensitiveStr::Ascii("phides"),
        dictgen::InsensitiveStr::Ascii("phur"),
        dictgen::InsensitiveStr::Ascii("phured"),
        dictgen::InsensitiveStr::Ascii("phuric"),
        dictgen::InsensitiveStr::Ascii("phuring"),
        dictgen::InsensitiveStr::Ascii("phurisation"),
        dictgen::InsensitiveStr::Ascii("phurisations"),
        dictgen::InsensitiveStr::Ascii("phurise"),
        dictgen::InsensitiveStr::Ascii("phurised"),
        dictgen::InsensitiveStr::Ascii("phurises"),
        dictgen::InsensitiveStr::Ascii("phurising"),
        dictgen::InsensitiveStr::Ascii("phurization"),
        dictgen::InsensitiveStr::Ascii("phurizations"),
        dictgen::InsensitiveStr::Ascii("phurize"),
        dictgen::InsensitiveStr::Ascii("phurized"),
        dictgen::InsensitiveStr::Ascii("phurizes"),
        dictgen::InsensitiveStr::Ascii("phurizing"),
        dictgen::InsensitiveStr::Ascii("phurous"),
        dictgen::InsensitiveStr::Ascii("phurs"),
        dictgen::InsensitiveStr::Ascii("tanise"),
        dictgen::InsensitiveStr::Ascii("tanises"),
        dictgen::InsensitiveStr::Ascii("tanize"),
        dictgen::InsensitiveStr::Ascii("tanizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SULCALIZE_8378152628296896141)],
        &[(0b10010, &ENTRY_SULCALIZED_5425406189232692465)],
        &[(0b10010, &ENTRY_SULCALIZES_640675964983651986)],
        &[(0b10010, &ENTRY_SULCALIZING_5886947456402704718)],
        &[(0b01001, &ENTRY_SULCALIZE_8378152628296896141)],
        &[(0b01001, &ENTRY_SULCALIZED_5425406189232692465)],
        &[(0b01001, &ENTRY_SULCALIZES_640675964983651986)],
        &[(0b01001, &ENTRY_SULCALIZING_5886947456402704718)],
        &[(0b01001, &ENTRY_SULFATE_12734582688668505440)],
        &[(0b01001, &ENTRY_SULFATES_4402811146604836852)],
        &[(0b10010, &ENTRY_SULFATIZE_13333268258610123633)],
        &[(0b10010, &ENTRY_SULFATIZES_6036327854424560867)],
        &[(0b01001, &ENTRY_SULFATIZE_13333268258610123633)],
        &[(0b01001, &ENTRY_SULFATIZES_6036327854424560867)],
        &[(0b01001, &ENTRY_SULFIDE_7304142610351212973)],
        &[(0b01001, &ENTRY_SULFIDES_16764216575605816115)],
        &[(0b11001, &ENTRY_SULFURIC_1017009640623214170)],
        &[(0b00001, &ENTRY_SULFURIZATION_14439802421211659492)],
        &[(0b00001, &ENTRY_SULFURIZATIONS_5474468829338012124)],
        &[(0b00001, &ENTRY_SULFURIZE_6207811143838647915)],
        &[(0b00001, &ENTRY_SULFURIZED_13939604428112304430)],
        &[(0b00001, &ENTRY_SULFURIZES_5918702548576518301)],
        &[(0b00001, &ENTRY_SULFURIZING_8560422491260610461)],
        &[(0b01001, &ENTRY_SULFUROUS_10926705129400784683)],
        &[(0b11010, &ENTRY_SULFATE_12734582688668505440)],
        &[(0b11010, &ENTRY_SULFATES_4402811146604836852)],
        &[(0b11010, &ENTRY_SULFIDE_7304142610351212973)],
        &[(0b11010, &ENTRY_SULFIDES_16764216575605816115)],
        &[(0b11010, &ENTRY_SULFUR_10049808270063012273)],
        &[(0b11010, &ENTRY_SULFURED_8189776575606765570)],
        &[(0b11010, &ENTRY_SULFURIC_1017009640623214170)],
        &[(0b11010, &ENTRY_SULFURING_13686792585795899810)],
        &[(0b10010, &ENTRY_SULFURIZATION_14439802421211659492)],
        &[(0b10010, &ENTRY_SULFURIZATIONS_5474468829338012124)],
        &[(0b10010, &ENTRY_SULFURIZE_6207811143838647915)],
        &[(0b10010, &ENTRY_SULFURIZED_13939604428112304430)],
        &[(0b10010, &ENTRY_SULFURIZES_5918702548576518301)],
        &[(0b10010, &ENTRY_SULFURIZING_8560422491260610461)],
        &[(0b01000, &ENTRY_SULFURIZATION_14439802421211659492)],
        &[(0b01000, &ENTRY_SULFURIZATIONS_5474468829338012124)],
        &[(0b01000, &ENTRY_SULFURIZE_6207811143838647915)],
        &[(0b01000, &ENTRY_SULFURIZED_13939604428112304430)],
        &[(0b01000, &ENTRY_SULFURIZES_5918702548576518301)],
        &[(0b01000, &ENTRY_SULFURIZING_8560422491260610461)],
        &[(0b11010, &ENTRY_SULFUROUS_10926705129400784683)],
        &[(0b11010, &ENTRY_SULFURS_750949739916739801)],
        &[(0b10010, &ENTRY_SULTANIZE_4736867272905083425)],
        &[(0b10010, &ENTRY_SULTANIZES_9680614734074701263)],
        &[(0b01001, &ENTRY_SULTANIZE_4736867272905083425)],
        &[(0b01001, &ENTRY_SULTANIZES_9680614734074701263)],
    ],
    range: 4..=12,
};

static VARS_SUG_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUG_CHILDREN),
    value: None,
};

pub static VARS_SUG_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gestionise"),
        dictgen::InsensitiveStr::Ascii("gestionises"),
        dictgen::InsensitiveStr::Ascii("gestionize"),
        dictgen::InsensitiveStr::Ascii("gestionizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUGGESTIONIZE_9511065820694117464)],
        &[(0b10010, &ENTRY_SUGGESTIONIZES_2131192207235128557)],
        &[(0b01001, &ENTRY_SUGGESTIONIZE_9511065820694117464)],
        &[(0b01001, &ENTRY_SUGGESTIONIZES_2131192207235128557)],
    ],
    range: 10..=11,
};

static VARS_SUE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUE_CHILDREN),
    value: None,
};

pub static VARS_SUE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("rs")],
    values: &[&[(0b00001, &ENTRY_SUERS_7272934736981736758)]],
    range: 2..=2,
};

static VARS_SUC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUC_CHILDREN),
    value: None,
};

pub static VARS_SUC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cor"),
        dictgen::InsensitiveStr::Ascii("corable"),
        dictgen::InsensitiveStr::Ascii("corables"),
        dictgen::InsensitiveStr::Ascii("cored"),
        dictgen::InsensitiveStr::Ascii("corer"),
        dictgen::InsensitiveStr::Ascii("corers"),
        dictgen::InsensitiveStr::Ascii("corful"),
        dictgen::InsensitiveStr::Ascii("coring"),
        dictgen::InsensitiveStr::Ascii("corless"),
        dictgen::InsensitiveStr::Ascii("corlesses"),
        dictgen::InsensitiveStr::Ascii("corrhea"),
        dictgen::InsensitiveStr::Ascii("corrhoea"),
        dictgen::InsensitiveStr::Ascii("cors"),
        dictgen::InsensitiveStr::Ascii("cour"),
        dictgen::InsensitiveStr::Ascii("courable"),
        dictgen::InsensitiveStr::Ascii("courables"),
        dictgen::InsensitiveStr::Ascii("coured"),
        dictgen::InsensitiveStr::Ascii("courer"),
        dictgen::InsensitiveStr::Ascii("courers"),
        dictgen::InsensitiveStr::Ascii("courful"),
        dictgen::InsensitiveStr::Ascii("couring"),
        dictgen::InsensitiveStr::Ascii("courless"),
        dictgen::InsensitiveStr::Ascii("courlesses"),
        dictgen::InsensitiveStr::Ascii("cours"),
        dictgen::InsensitiveStr::Ascii("cubae"),
        dictgen::InsensitiveStr::Ascii("cube"),
    ],
    values: &[
        &[(0b10001, &ENTRY_SUCCOR_15081921561003187015)],
        &[(0b10001, &ENTRY_SUCCORABLE_7603179383102744178)],
        &[(0b10001, &ENTRY_SUCCORABLES_10281575419378237491)],
        &[(0b10001, &ENTRY_SUCCORED_12990159801580773138)],
        &[(0b10001, &ENTRY_SUCCORER_16497801407608107954)],
        &[(0b10001, &ENTRY_SUCCORERS_6561319313200472359)],
        &[(0b10001, &ENTRY_SUCCORFUL_4180327020165538900)],
        &[(0b10001, &ENTRY_SUCCORING_11411217915173349617)],
        &[(0b10001, &ENTRY_SUCCORLESS_7850671832548251866)],
        &[(0b00001, &ENTRY_SUCCORLESSES_12939324178963311324)],
        &[(0b00001, &ENTRY_SUCCORRHEA_1494636851481194334)],
        &[(0b11010, &ENTRY_SUCCORRHEA_1494636851481194334)],
        &[(0b10001, &ENTRY_SUCCORS_3531516934857684627)],
        &[(0b11010, &ENTRY_SUCCOR_15081921561003187015)],
        &[(0b11010, &ENTRY_SUCCORABLE_7603179383102744178)],
        &[(0b11010, &ENTRY_SUCCORABLES_10281575419378237491)],
        &[(0b11010, &ENTRY_SUCCORED_12990159801580773138)],
        &[(0b11010, &ENTRY_SUCCORER_16497801407608107954)],
        &[(0b11010, &ENTRY_SUCCORERS_6561319313200472359)],
        &[(0b11010, &ENTRY_SUCCORFUL_4180327020165538900)],
        &[(0b11010, &ENTRY_SUCCORING_11411217915173349617)],
        &[(0b11010, &ENTRY_SUCCORLESS_7850671832548251866)],
        &[(0b11010, &ENTRY_SUCCORLESSES_12939324178963311324)],
        &[(0b11010, &ENTRY_SUCCORS_3531516934857684627)],
        &[(0b11010, &ENTRY_SUCCUBE_9791440353781686466)],
        &[(0b00001, &ENTRY_SUCCUBE_9791440353781686466)],
    ],
    range: 3..=10,
};

static VARS_SUB_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SUB_CHILDREN),
    value: None,
};

static VARS_SUB_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_SUBA_NODE),
    None,
    Some(&VARS_SUBC_NODE),
    Some(&VARS_SUBD_NODE),
    Some(&VARS_SUBE_NODE),
    Some(&VARS_SUBF_NODE),
    None,
    None,
    Some(&VARS_SUBI_NODE),
    Some(&VARS_SUBJ_NODE),
    None,
    Some(&VARS_SUBL_NODE),
    Some(&VARS_SUBM_NODE),
    None,
    Some(&VARS_SUBO_NODE),
    Some(&VARS_SUBP_NODE),
    None,
    None,
    Some(&VARS_SUBS_NODE),
    Some(&VARS_SUBT_NODE),
    Some(&VARS_SUBU_NODE),
    Some(&VARS_SUBV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_SUBV_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUBV_CHILDREN),
    value: None,
};

pub static VARS_SUBV_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("italisation"),
        dictgen::InsensitiveStr::Ascii("italised"),
        dictgen::InsensitiveStr::Ascii("italisedder"),
        dictgen::InsensitiveStr::Ascii("italiseddest"),
        dictgen::InsensitiveStr::Ascii("italiseds"),
        dictgen::InsensitiveStr::Ascii("italization"),
        dictgen::InsensitiveStr::Ascii("italized"),
        dictgen::InsensitiveStr::Ascii("italizedder"),
        dictgen::InsensitiveStr::Ascii("italizeddest"),
        dictgen::InsensitiveStr::Ascii("italizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUBVITALIZATION_14104834684189946569)],
        &[(0b10010, &ENTRY_SUBVITALIZED_12798033182946604207)],
        &[(0b10010, &ENTRY_SUBVITALIZEDDER_6038599483589110897)],
        &[(0b10010, &ENTRY_SUBVITALIZEDDEST_4531581466325644556)],
        &[(0b10010, &ENTRY_SUBVITALIZEDS_319956284183288639)],
        &[(0b01001, &ENTRY_SUBVITALIZATION_14104834684189946569)],
        &[(0b01001, &ENTRY_SUBVITALIZED_12798033182946604207)],
        &[(0b01001, &ENTRY_SUBVITALIZEDDER_6038599483589110897)],
        &[(0b01001, &ENTRY_SUBVITALIZEDDEST_4531581466325644556)],
        &[(0b01001, &ENTRY_SUBVITALIZEDS_319956284183288639)],
    ],
    range: 8..=12,
};

static VARS_SUBU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUBU_CHILDREN),
    value: None,
};

pub static VARS_SUBU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rbanisation"),
        dictgen::InsensitiveStr::Ascii("rbanisations"),
        dictgen::InsensitiveStr::Ascii("rbanise"),
        dictgen::InsensitiveStr::Ascii("rbanised"),
        dictgen::InsensitiveStr::Ascii("rbanises"),
        dictgen::InsensitiveStr::Ascii("rbanising"),
        dictgen::InsensitiveStr::Ascii("rbanization"),
        dictgen::InsensitiveStr::Ascii("rbanizations"),
        dictgen::InsensitiveStr::Ascii("rbanize"),
        dictgen::InsensitiveStr::Ascii("rbanized"),
        dictgen::InsensitiveStr::Ascii("rbanizes"),
        dictgen::InsensitiveStr::Ascii("rbanizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUBURBANIZATION_5041053547374142641)],
        &[(0b10010, &ENTRY_SUBURBANIZATIONS_4594207725356201298)],
        &[(0b10010, &ENTRY_SUBURBANIZE_7361825706290430577)],
        &[(0b10010, &ENTRY_SUBURBANIZED_7801039488105724595)],
        &[(0b10010, &ENTRY_SUBURBANIZES_3051574588598676729)],
        &[(0b10010, &ENTRY_SUBURBANIZING_16607196382879275433)],
        &[(0b01001, &ENTRY_SUBURBANIZATION_5041053547374142641)],
        &[(0b01001, &ENTRY_SUBURBANIZATIONS_4594207725356201298)],
        &[(0b01001, &ENTRY_SUBURBANIZE_7361825706290430577)],
        &[(0b01001, &ENTRY_SUBURBANIZED_7801039488105724595)],
        &[(0b01001, &ENTRY_SUBURBANIZES_3051574588598676729)],
        &[(0b01001, &ENTRY_SUBURBANIZING_16607196382879275433)],
    ],
    range: 7..=12,
};

static VARS_SUBT_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUBT_CHILDREN),
    value: None,
};

pub static VARS_SUBT_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("erraneanise"),
        dictgen::InsensitiveStr::Ascii("erraneanises"),
        dictgen::InsensitiveStr::Ascii("erraneanize"),
        dictgen::InsensitiveStr::Ascii("erraneanizes"),
        dictgen::InsensitiveStr::Ascii("ilisation"),
        dictgen::InsensitiveStr::Ascii("ilisations"),
        dictgen::InsensitiveStr::Ascii("ilise"),
        dictgen::InsensitiveStr::Ascii("ilised"),
        dictgen::InsensitiveStr::Ascii("iliser"),
        dictgen::InsensitiveStr::Ascii("ilisers"),
        dictgen::InsensitiveStr::Ascii("ilises"),
        dictgen::InsensitiveStr::Ascii("ilising"),
        dictgen::InsensitiveStr::Ascii("ilization"),
        dictgen::InsensitiveStr::Ascii("ilizations"),
        dictgen::InsensitiveStr::Ascii("ilize"),
        dictgen::InsensitiveStr::Ascii("ilized"),
        dictgen::InsensitiveStr::Ascii("ilizer"),
        dictgen::InsensitiveStr::Ascii("ilizers"),
        dictgen::InsensitiveStr::Ascii("ilizes"),
        dictgen::InsensitiveStr::Ascii("ilizing"),
        dictgen::InsensitiveStr::Ascii("otaled"),
        dictgen::InsensitiveStr::Ascii("otaling"),
        dictgen::InsensitiveStr::Ascii("otalled"),
        dictgen::InsensitiveStr::Ascii("otalling"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUBTERRANEANIZE_16122048142322693644)],
        &[(0b10010, &ENTRY_SUBTERRANEANIZES_11938427088659999116)],
        &[(0b01001, &ENTRY_SUBTERRANEANIZE_16122048142322693644)],
        &[(0b01001, &ENTRY_SUBTERRANEANIZES_11938427088659999116)],
        &[(0b10010, &ENTRY_SUBTILIZATION_16525688905774221339)],
        &[(0b10010, &ENTRY_SUBTILIZATIONS_816218037167588581)],
        &[(0b10010, &ENTRY_SUBTILIZE_364396766538437717)],
        &[(0b10010, &ENTRY_SUBTILIZED_12953612644850546188)],
        &[(0b10010, &ENTRY_SUBTILIZER_2092624206187190872)],
        &[(0b10010, &ENTRY_SUBTILIZERS_5918033439060086128)],
        &[(0b10010, &ENTRY_SUBTILIZES_7637829126901224384)],
        &[(0b10010, &ENTRY_SUBTILIZING_4890677210606357966)],
        &[(0b01001, &ENTRY_SUBTILIZATION_16525688905774221339)],
        &[(0b01001, &ENTRY_SUBTILIZATIONS_816218037167588581)],
        &[(0b01001, &ENTRY_SUBTILIZE_364396766538437717)],
        &[(0b01001, &ENTRY_SUBTILIZED_12953612644850546188)],
        &[(0b01001, &ENTRY_SUBTILIZER_2092624206187190872)],
        &[(0b01001, &ENTRY_SUBTILIZERS_5918033439060086128)],
        &[(0b01001, &ENTRY_SUBTILIZES_7637829126901224384)],
        &[(0b01001, &ENTRY_SUBTILIZING_4890677210606357966)],
        &[(0b00001, &ENTRY_SUBTOTALED_11251144387232903283)],
        &[(0b00001, &ENTRY_SUBTOTALING_7729561682231991509)],
        &[(0b11010, &ENTRY_SUBTOTALED_11251144387232903283)],
        &[(0b11010, &ENTRY_SUBTOTALING_7729561682231991509)],
    ],
    range: 5..=12,
};

static VARS_SUBS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUBS_CHILDREN),
    value: None,
};

pub static VARS_SUBS_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("idisable"),
        dictgen::InsensitiveStr::Ascii("idisables"),
        dictgen::InsensitiveStr::Ascii("idisation"),
        dictgen::InsensitiveStr::Ascii("idisations"),
        dictgen::InsensitiveStr::Ascii("idise"),
        dictgen::InsensitiveStr::Ascii("idised"),
        dictgen::InsensitiveStr::Ascii("idiser"),
        dictgen::InsensitiveStr::Ascii("idisers"),
        dictgen::InsensitiveStr::Ascii("idises"),
        dictgen::InsensitiveStr::Ascii("idising"),
        dictgen::InsensitiveStr::Ascii("idizable"),
        dictgen::InsensitiveStr::Ascii("idizables"),
        dictgen::InsensitiveStr::Ascii("idization"),
        dictgen::InsensitiveStr::Ascii("idizations"),
        dictgen::InsensitiveStr::Ascii("idize"),
        dictgen::InsensitiveStr::Ascii("idized"),
        dictgen::InsensitiveStr::Ascii("idizer"),
        dictgen::InsensitiveStr::Ascii("idizers"),
        dictgen::InsensitiveStr::Ascii("idizes"),
        dictgen::InsensitiveStr::Ascii("idizing"),
        dictgen::InsensitiveStr::Ascii("pecialise"),
        dictgen::InsensitiveStr::Ascii("pecialises"),
        dictgen::InsensitiveStr::Ascii("pecialities"),
        dictgen::InsensitiveStr::Ascii("peciality"),
        dictgen::InsensitiveStr::Ascii("pecialize"),
        dictgen::InsensitiveStr::Ascii("pecializes"),
        dictgen::InsensitiveStr::Ascii("pecialties"),
        dictgen::InsensitiveStr::Ascii("pecialty"),
        dictgen::InsensitiveStr::Ascii("tandardise"),
        dictgen::InsensitiveStr::Ascii("tandardises"),
        dictgen::InsensitiveStr::Ascii("tandardize"),
        dictgen::InsensitiveStr::Ascii("tandardizes"),
        dictgen::InsensitiveStr::Ascii("tantialise"),
        dictgen::InsensitiveStr::Ascii("tantialised"),
        dictgen::InsensitiveStr::Ascii("tantialises"),
        dictgen::InsensitiveStr::Ascii("tantialising"),
        dictgen::InsensitiveStr::Ascii("tantialize"),
        dictgen::InsensitiveStr::Ascii("tantialized"),
        dictgen::InsensitiveStr::Ascii("tantializes"),
        dictgen::InsensitiveStr::Ascii("tantializing"),
        dictgen::InsensitiveStr::Ascii("tantivise"),
        dictgen::InsensitiveStr::Ascii("tantivised"),
        dictgen::InsensitiveStr::Ascii("tantivises"),
        dictgen::InsensitiveStr::Ascii("tantivising"),
        dictgen::InsensitiveStr::Ascii("tantivize"),
        dictgen::InsensitiveStr::Ascii("tantivized"),
        dictgen::InsensitiveStr::Ascii("tantivizes"),
        dictgen::InsensitiveStr::Ascii("tantivizing"),
        dictgen::InsensitiveStr::Ascii("terilisation"),
        dictgen::InsensitiveStr::Ascii("terilization"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUBSIDIZABLE_12403609187359696273)],
        &[(0b10010, &ENTRY_SUBSIDIZABLES_957075676080529205)],
        &[(0b10010, &ENTRY_SUBSIDIZATION_4505517696726661884)],
        &[(0b10010, &ENTRY_SUBSIDIZATIONS_13296883432062947981)],
        &[(0b10010, &ENTRY_SUBSIDIZE_9015916516385257628)],
        &[(0b10010, &ENTRY_SUBSIDIZED_12958293246622856287)],
        &[(0b10010, &ENTRY_SUBSIDIZER_8190087923295833359)],
        &[(0b10010, &ENTRY_SUBSIDIZERS_10377554586473479765)],
        &[(0b10010, &ENTRY_SUBSIDIZES_5852930110538753767)],
        &[(0b10010, &ENTRY_SUBSIDIZING_2567121642876801163)],
        &[(0b01001, &ENTRY_SUBSIDIZABLE_12403609187359696273)],
        &[(0b01001, &ENTRY_SUBSIDIZABLES_957075676080529205)],
        &[(0b01001, &ENTRY_SUBSIDIZATION_4505517696726661884)],
        &[(0b01001, &ENTRY_SUBSIDIZATIONS_13296883432062947981)],
        &[(0b01001, &ENTRY_SUBSIDIZE_9015916516385257628)],
        &[(0b01001, &ENTRY_SUBSIDIZED_12958293246622856287)],
        &[(0b01001, &ENTRY_SUBSIDIZER_8190087923295833359)],
        &[(0b01001, &ENTRY_SUBSIDIZERS_10377554586473479765)],
        &[(0b01001, &ENTRY_SUBSIDIZES_5852930110538753767)],
        &[(0b01001, &ENTRY_SUBSIDIZING_2567121642876801163)],
        &[(0b10010, &ENTRY_SUBSPECIALIZE_5110123534584151405)],
        &[(0b10010, &ENTRY_SUBSPECIALIZES_14179857379487185513)],
        &[(0b11010, &ENTRY_SUBSPECIALTIES_5856104107956385634)],
        &[(0b11010, &ENTRY_SUBSPECIALTY_4476391942712911269)],
        &[(0b01001, &ENTRY_SUBSPECIALIZE_5110123534584151405)],
        &[(0b01001, &ENTRY_SUBSPECIALIZES_14179857379487185513)],
        &[(0b00001, &ENTRY_SUBSPECIALTIES_5856104107956385634)],
        &[(0b00001, &ENTRY_SUBSPECIALTY_4476391942712911269)],
        &[(0b10010, &ENTRY_SUBSTANDARDIZE_1074329812678020525)],
        &[(0b10010, &ENTRY_SUBSTANDARDIZES_8917636387963391968)],
        &[(0b01001, &ENTRY_SUBSTANDARDIZE_1074329812678020525)],
        &[(0b01001, &ENTRY_SUBSTANDARDIZES_8917636387963391968)],
        &[(0b10010, &ENTRY_SUBSTANTIALIZE_16565480476325052589)],
        &[(0b10010, &ENTRY_SUBSTANTIALIZED_9495547837171370415)],
        &[(0b10010, &ENTRY_SUBSTANTIALIZES_2218483493616659856)],
        &[(0b10010, &ENTRY_SUBSTANTIALIZING_3618259364403658920)],
        &[(0b01001, &ENTRY_SUBSTANTIALIZE_16565480476325052589)],
        &[(0b01001, &ENTRY_SUBSTANTIALIZED_9495547837171370415)],
        &[(0b01001, &ENTRY_SUBSTANTIALIZES_2218483493616659856)],
        &[(0b01001, &ENTRY_SUBSTANTIALIZING_3618259364403658920)],
        &[(0b10010, &ENTRY_SUBSTANTIVIZE_13021735481609078621)],
        &[(0b10010, &ENTRY_SUBSTANTIVIZED_4254503445468994674)],
        &[(0b10010, &ENTRY_SUBSTANTIVIZES_10108249589648833227)],
        &[(0b10010, &ENTRY_SUBSTANTIVIZING_13322008447748586118)],
        &[(0b01001, &ENTRY_SUBSTANTIVIZE_13021735481609078621)],
        &[(0b01001, &ENTRY_SUBSTANTIVIZED_4254503445468994674)],
        &[(0b01001, &ENTRY_SUBSTANTIVIZES_10108249589648833227)],
        &[(0b01001, &ENTRY_SUBSTANTIVIZING_13322008447748586118)],
        &[(0b10010, &ENTRY_SUBSTERILIZATION_18359467976046569227)],
        &[(0b01001, &ENTRY_SUBSTERILIZATION_18359467976046569227)],
    ],
    range: 5..=12,
};

static VARS_SUBP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUBP_CHILDREN),
    value: None,
};

pub static VARS_SUBP_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ulveriser"),
        dictgen::InsensitiveStr::Ascii("ulverisers"),
        dictgen::InsensitiveStr::Ascii("ulverizer"),
        dictgen::InsensitiveStr::Ascii("ulverizers"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUBPULVERIZER_6713080541658378074)],
        &[(0b10010, &ENTRY_SUBPULVERIZERS_7885747060142039285)],
        &[(0b01001, &ENTRY_SUBPULVERIZER_6713080541658378074)],
        &[(0b01001, &ENTRY_SUBPULVERIZERS_7885747060142039285)],
    ],
    range: 9..=10,
};

static VARS_SUBO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUBO_CHILDREN),
    value: None,
};

pub static VARS_SUBO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("esophageal")],
    values: &[&[(0b11010, &ENTRY_SUBESOPHAGEAL_15820663243055824436)]],
    range: 10..=10,
};

static VARS_SUBM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUBM_CHILDREN),
    value: None,
};

pub static VARS_SUBM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("iniaturisation"),
        dictgen::InsensitiveStr::Ascii("iniaturise"),
        dictgen::InsensitiveStr::Ascii("iniaturised"),
        dictgen::InsensitiveStr::Ascii("iniaturises"),
        dictgen::InsensitiveStr::Ascii("iniaturising"),
        dictgen::InsensitiveStr::Ascii("iniaturization"),
        dictgen::InsensitiveStr::Ascii("iniaturize"),
        dictgen::InsensitiveStr::Ascii("iniaturized"),
        dictgen::InsensitiveStr::Ascii("iniaturizes"),
        dictgen::InsensitiveStr::Ascii("iniaturizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUBMINIATURIZATION_14504776542407713912)],
        &[(0b10010, &ENTRY_SUBMINIATURIZE_10382800191995124390)],
        &[(0b10010, &ENTRY_SUBMINIATURIZED_15597111727187376086)],
        &[(0b10010, &ENTRY_SUBMINIATURIZES_17702176303629650188)],
        &[(0b10010, &ENTRY_SUBMINIATURIZING_14891752532954283444)],
        &[(0b01001, &ENTRY_SUBMINIATURIZATION_14504776542407713912)],
        &[(0b01001, &ENTRY_SUBMINIATURIZE_10382800191995124390)],
        &[(0b01001, &ENTRY_SUBMINIATURIZED_15597111727187376086)],
        &[(0b01001, &ENTRY_SUBMINIATURIZES_17702176303629650188)],
        &[(0b01001, &ENTRY_SUBMINIATURIZING_14891752532954283444)],
    ],
    range: 10..=14,
};

static VARS_SUBL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUBL_CHILDREN),
    value: None,
};

pub static VARS_SUBL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("imise"),
        dictgen::InsensitiveStr::Ascii("imised"),
        dictgen::InsensitiveStr::Ascii("imises"),
        dictgen::InsensitiveStr::Ascii("imising"),
        dictgen::InsensitiveStr::Ascii("imize"),
        dictgen::InsensitiveStr::Ascii("imized"),
        dictgen::InsensitiveStr::Ascii("imizes"),
        dictgen::InsensitiveStr::Ascii("imizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUBLIMIZE_8185998513196337857)],
        &[(0b10010, &ENTRY_SUBLIMIZED_17602677846775104325)],
        &[(0b10010, &ENTRY_SUBLIMIZES_430560762252037002)],
        &[(0b10010, &ENTRY_SUBLIMIZING_12673180625915709564)],
        &[(0b01001, &ENTRY_SUBLIMIZE_8185998513196337857)],
        &[(0b01001, &ENTRY_SUBLIMIZED_17602677846775104325)],
        &[(0b01001, &ENTRY_SUBLIMIZES_430560762252037002)],
        &[(0b01001, &ENTRY_SUBLIMIZING_12673180625915709564)],
    ],
    range: 5..=7,
};

static VARS_SUBJ_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUBJ_CHILDREN),
    value: None,
};

pub static VARS_SUBJ_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ectivisation"),
        dictgen::InsensitiveStr::Ascii("ectivisations"),
        dictgen::InsensitiveStr::Ascii("ectivise"),
        dictgen::InsensitiveStr::Ascii("ectivised"),
        dictgen::InsensitiveStr::Ascii("ectivises"),
        dictgen::InsensitiveStr::Ascii("ectivising"),
        dictgen::InsensitiveStr::Ascii("ectivization"),
        dictgen::InsensitiveStr::Ascii("ectivizations"),
        dictgen::InsensitiveStr::Ascii("ectivize"),
        dictgen::InsensitiveStr::Ascii("ectivized"),
        dictgen::InsensitiveStr::Ascii("ectivizes"),
        dictgen::InsensitiveStr::Ascii("ectivizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUBJECTIVIZATION_10907308115440153544)],
        &[(0b10010, &ENTRY_SUBJECTIVIZATIONS_9264628960015842629)],
        &[(0b10010, &ENTRY_SUBJECTIVIZE_2435583356236162378)],
        &[(0b10010, &ENTRY_SUBJECTIVIZED_3246560572891433421)],
        &[(0b10010, &ENTRY_SUBJECTIVIZES_7152248194959006615)],
        &[(0b10010, &ENTRY_SUBJECTIVIZING_8718502587935622549)],
        &[(0b01001, &ENTRY_SUBJECTIVIZATION_10907308115440153544)],
        &[(0b01001, &ENTRY_SUBJECTIVIZATIONS_9264628960015842629)],
        &[(0b01001, &ENTRY_SUBJECTIVIZE_2435583356236162378)],
        &[(0b01001, &ENTRY_SUBJECTIVIZED_3246560572891433421)],
        &[(0b01001, &ENTRY_SUBJECTIVIZES_7152248194959006615)],
        &[(0b01001, &ENTRY_SUBJECTIVIZING_8718502587935622549)],
    ],
    range: 8..=13,
};

static VARS_SUBI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUBI_CHILDREN),
    value: None,
};

pub static VARS_SUBI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("tise"),
        dictgen::InsensitiveStr::Ascii("tised"),
        dictgen::InsensitiveStr::Ascii("tises"),
        dictgen::InsensitiveStr::Ascii("tising"),
        dictgen::InsensitiveStr::Ascii("tize"),
        dictgen::InsensitiveStr::Ascii("tized"),
        dictgen::InsensitiveStr::Ascii("tizes"),
        dictgen::InsensitiveStr::Ascii("tizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SUBITIZE_3227874881853303084)],
        &[(0b10010, &ENTRY_SUBITIZED_2108404178901406655)],
        &[(0b10010, &ENTRY_SUBITIZES_5445288650913572325)],
        &[(0b10010, &ENTRY_SUBITIZING_16606524006734697699)],
        &[(0b01001, &ENTRY_SUBITIZE_3227874881853303084)],
        &[(0b01001, &ENTRY_SUBITIZED_2108404178901406655)],
        &[(0b01001, &ENTRY_SUBITIZES_5445288650913572325)],
        &[(0b01001, &ENTRY_SUBITIZING_16606524006734697699)],
    ],
    range: 4..=6,
};

static VARS_SUBF_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUBF_CHILDREN),
    value: None,
};

pub static VARS_SUBF_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lavor"),
        dictgen::InsensitiveStr::Ascii("lavors"),
        dictgen::InsensitiveStr::Ascii("lavour"),
        dictgen::InsensitiveStr::Ascii("lavours"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SUBFLAVOR_16056956186177727005)],
        &[(0b00001, &ENTRY_SUBFLAVORS_14563327931975471334)],
        &[(0b11010, &ENTRY_SUBFLAVOR_16056956186177727005)],
        &[(0b11010, &ENTRY_SUBFLAVORS_14563327931975471334)],
    ],
    range: 5..=7,
};

static VARS_SUBE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUBE_CHILDREN),
    value: None,
};

pub static VARS_SUBE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rate"),
        dictgen::InsensitiveStr::Ascii("risation"),
        dictgen::InsensitiveStr::Ascii("risations"),
        dictgen::InsensitiveStr::Ascii("rise"),
        dictgen::InsensitiveStr::Ascii("rised"),
        dictgen::InsensitiveStr::Ascii("rises"),
        dictgen::InsensitiveStr::Ascii("rising"),
        dictgen::InsensitiveStr::Ascii("rization"),
        dictgen::InsensitiveStr::Ascii("rizations"),
        dictgen::InsensitiveStr::Ascii("rize"),
        dictgen::InsensitiveStr::Ascii("rized"),
        dictgen::InsensitiveStr::Ascii("rizes"),
        dictgen::InsensitiveStr::Ascii("rizing"),
        dictgen::InsensitiveStr::Ascii("sophageal"),
        dictgen::InsensitiveStr::Ascii("theric"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SUBERATE_2958713859903830046)],
        &[(0b10010, &ENTRY_SUBERIZATION_1080833948419911642)],
        &[(0b10010, &ENTRY_SUBERIZATIONS_7532836560480717833)],
        &[(0b10010, &ENTRY_SUBERIZE_9965568250579749505)],
        &[(0b10010, &ENTRY_SUBERIZED_10174332333495953086)],
        &[(0b10010, &ENTRY_SUBERIZES_17776114559373177493)],
        &[(0b10010, &ENTRY_SUBERIZING_11515978326235360567)],
        &[(0b01001, &ENTRY_SUBERIZATION_1080833948419911642)],
        &[(0b01001, &ENTRY_SUBERIZATIONS_7532836560480717833)],
        &[(0b01001, &ENTRY_SUBERIZE_9965568250579749505)],
        &[(0b01001, &ENTRY_SUBERIZED_10174332333495953086)],
        &[(0b01001, &ENTRY_SUBERIZES_17776114559373177493)],
        &[(0b01001, &ENTRY_SUBERIZING_11515978326235360567)],
        &[(0b00001, &ENTRY_SUBESOPHAGEAL_15820663243055824436)],
        &[(0b00001, &ENTRY_SUBETHERIC_2596346146616427172)],
    ],
    range: 4..=9,
};

static VARS_SUBD_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUBD_CHILDREN),
    value: None,
};

pub static VARS_SUBD_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("uer"),
        dictgen::InsensitiveStr::Ascii("ure"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SUBDUER_6426022057783382265)],
        &[(0b11010, &ENTRY_SUBDUER_6426022057783382265)],
    ],
    range: 3..=3,
};

static VARS_SUBC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUBC_CHILDREN),
    value: None,
};

pub static VARS_SUBC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aliber"),
        dictgen::InsensitiveStr::Ascii("alibre"),
        dictgen::InsensitiveStr::Ascii("ategorising"),
        dictgen::InsensitiveStr::Ascii("ategorizing"),
        dictgen::InsensitiveStr::Ascii("enter"),
        dictgen::InsensitiveStr::Ascii("entre"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SUBCALIBER_16406723248353952807)],
        &[(0b11010, &ENTRY_SUBCALIBER_16406723248353952807)],
        &[(0b10010, &ENTRY_SUBCATEGORIZING_3085156622608452887)],
        &[(0b01001, &ENTRY_SUBCATEGORIZING_3085156622608452887)],
        &[(0b00001, &ENTRY_SUBCENTER_9442934379600097289)],
        &[(0b11010, &ENTRY_SUBCENTER_9442934379600097289)],
    ],
    range: 5..=11,
};

static VARS_SUBA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SUBA_CHILDREN),
    value: None,
};

pub static VARS_SUBA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("erate"),
        dictgen::InsensitiveStr::Ascii("etheric"),
        dictgen::InsensitiveStr::Ascii("rmor"),
        dictgen::InsensitiveStr::Ascii("rmors"),
        dictgen::InsensitiveStr::Ascii("rmour"),
        dictgen::InsensitiveStr::Ascii("rmours"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SUBERATE_2958713859903830046)],
        &[(0b11010, &ENTRY_SUBETHERIC_2596346146616427172)],
        &[(0b00001, &ENTRY_SUBARMOR_10630628688650559346)],
        &[(0b00001, &ENTRY_SUBARMORS_12932609600459968439)],
        &[(0b11010, &ENTRY_SUBARMOR_10630628688650559346)],
        &[(0b11010, &ENTRY_SUBARMORS_12932609600459968439)],
    ],
    range: 4..=7,
};

static VARS_ST_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_ST_CHILDREN),
    value: None,
};

static VARS_ST_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_STA_NODE),
    None,
    None,
    None,
    Some(&VARS_STE_NODE),
    None,
    None,
    None,
    Some(&VARS_STI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_STO_NODE),
    None,
    None,
    Some(&VARS_STR_NODE),
    None,
    None,
    Some(&VARS_STU_NODE),
    None,
    None,
    None,
    Some(&VARS_STY_NODE),
    None,
];

static VARS_STY_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_STY_CHILDREN),
    value: None,
};

pub static VARS_STY_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lisation"),
        dictgen::InsensitiveStr::Ascii("lisations"),
        dictgen::InsensitiveStr::Ascii("lise"),
        dictgen::InsensitiveStr::Ascii("lised"),
        dictgen::InsensitiveStr::Ascii("liser"),
        dictgen::InsensitiveStr::Ascii("lisers"),
        dictgen::InsensitiveStr::Ascii("lises"),
        dictgen::InsensitiveStr::Ascii("lising"),
        dictgen::InsensitiveStr::Ascii("lization"),
        dictgen::InsensitiveStr::Ascii("lizations"),
        dictgen::InsensitiveStr::Ascii("lize"),
        dictgen::InsensitiveStr::Ascii("lized"),
        dictgen::InsensitiveStr::Ascii("lizer"),
        dictgen::InsensitiveStr::Ascii("lizers"),
        dictgen::InsensitiveStr::Ascii("lizes"),
        dictgen::InsensitiveStr::Ascii("lizing"),
        dictgen::InsensitiveStr::Ascii("lopised"),
        dictgen::InsensitiveStr::Ascii("lopized"),
    ],
    values: &[
        &[(0b10010, &ENTRY_STYLIZATION_15244694173883242713)],
        &[(0b10010, &ENTRY_STYLIZATIONS_12181517973286032450)],
        &[(0b10010, &ENTRY_STYLIZE_1535390784645754383)],
        &[(0b10010, &ENTRY_STYLIZED_16020758497839181911)],
        &[(0b10010, &ENTRY_STYLIZER_13937646289429611798)],
        &[(0b10010, &ENTRY_STYLIZERS_2371037382842074036)],
        &[(0b10010, &ENTRY_STYLIZES_7516779593566935765)],
        &[(0b10010, &ENTRY_STYLIZING_9348895301814219487)],
        &[(0b01001, &ENTRY_STYLIZATION_15244694173883242713)],
        &[(0b01001, &ENTRY_STYLIZATIONS_12181517973286032450)],
        &[(0b01001, &ENTRY_STYLIZE_1535390784645754383)],
        &[(0b01001, &ENTRY_STYLIZED_16020758497839181911)],
        &[(0b01001, &ENTRY_STYLIZER_13937646289429611798)],
        &[(0b01001, &ENTRY_STYLIZERS_2371037382842074036)],
        &[(0b01001, &ENTRY_STYLIZES_7516779593566935765)],
        &[(0b01001, &ENTRY_STYLIZING_9348895301814219487)],
        &[(0b10010, &ENTRY_STYLOPIZED_12957953051597400041)],
        &[(0b01001, &ENTRY_STYLOPIZED_12957953051597400041)],
    ],
    range: 4..=9,
};

static VARS_STU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_STU_CHILDREN),
    value: None,
};

pub static VARS_STU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("mor"),
        dictgen::InsensitiveStr::Ascii("mour"),
    ],
    values: &[
        &[(0b00001, &ENTRY_STUMOR_11469482697863124360)],
        &[(0b11010, &ENTRY_STUMOR_11469482697863124360)],
    ],
    range: 3..=4,
};

static VARS_STR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_STR_CHILDREN),
    value: None,
};

pub static VARS_STR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ee"),
        dictgen::InsensitiveStr::Ascii("et"),
        dictgen::InsensitiveStr::Ascii("obilae"),
        dictgen::InsensitiveStr::Ascii("obile"),
        dictgen::InsensitiveStr::Ascii("obilisation"),
        dictgen::InsensitiveStr::Ascii("obilisations"),
        dictgen::InsensitiveStr::Ascii("obilization"),
        dictgen::InsensitiveStr::Ascii("obilizations"),
        dictgen::InsensitiveStr::Ascii("ucturalisation"),
        dictgen::InsensitiveStr::Ascii("ucturalisations"),
        dictgen::InsensitiveStr::Ascii("ucturalise"),
        dictgen::InsensitiveStr::Ascii("ucturalises"),
        dictgen::InsensitiveStr::Ascii("ucturalization"),
        dictgen::InsensitiveStr::Ascii("ucturalizations"),
        dictgen::InsensitiveStr::Ascii("ucturalize"),
        dictgen::InsensitiveStr::Ascii("ucturalizes"),
        dictgen::InsensitiveStr::Ascii("ychninisation"),
        dictgen::InsensitiveStr::Ascii("ychninisations"),
        dictgen::InsensitiveStr::Ascii("ychninise"),
        dictgen::InsensitiveStr::Ascii("ychninises"),
        dictgen::InsensitiveStr::Ascii("ychninization"),
        dictgen::InsensitiveStr::Ascii("ychninizations"),
        dictgen::InsensitiveStr::Ascii("ychninize"),
        dictgen::InsensitiveStr::Ascii("ychninizes"),
    ],
    values: &[
        &[(0b11010, &ENTRY_STERE_14973674637271689830)],
        &[(0b11010, &ENTRY_STERT_15188513933795764953)],
        &[(0b11010, &ENTRY_STROBILE_5462694341161436350)],
        &[(0b00001, &ENTRY_STROBILE_5462694341161436350)],
        &[(0b10010, &ENTRY_STROBILIZATION_7297298229503744242)],
        &[(0b10010, &ENTRY_STROBILIZATIONS_6453453949977182110)],
        &[(0b01001, &ENTRY_STROBILIZATION_7297298229503744242)],
        &[(0b01001, &ENTRY_STROBILIZATIONS_6453453949977182110)],
        &[(0b10010, &ENTRY_STRUCTURALIZATION_16247212527450308015)],
        &[(0b10010, &ENTRY_STRUCTURALIZATIONS_12686176034416013309)],
        &[(0b10010, &ENTRY_STRUCTURALIZE_16594415476051004260)],
        &[(0b10010, &ENTRY_STRUCTURALIZES_538653414352082587)],
        &[(0b01001, &ENTRY_STRUCTURALIZATION_16247212527450308015)],
        &[(0b01001, &ENTRY_STRUCTURALIZATIONS_12686176034416013309)],
        &[(0b01001, &ENTRY_STRUCTURALIZE_16594415476051004260)],
        &[(0b01001, &ENTRY_STRUCTURALIZES_538653414352082587)],
        &[(0b10010, &ENTRY_STRYCHNINIZATION_4044621013040012415)],
        &[(0b10010, &ENTRY_STRYCHNINIZATIONS_565463606315000819)],
        &[(0b10010, &ENTRY_STRYCHNINIZE_17273897055193701327)],
        &[(0b10010, &ENTRY_STRYCHNINIZES_14335926093096659147)],
        &[(0b01001, &ENTRY_STRYCHNINIZATION_4044621013040012415)],
        &[(0b01001, &ENTRY_STRYCHNINIZATIONS_565463606315000819)],
        &[(0b01001, &ENTRY_STRYCHNINIZE_17273897055193701327)],
        &[(0b01001, &ENTRY_STRYCHNINIZES_14335926093096659147)],
    ],
    range: 2..=15,
};

static VARS_STO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_STO_CHILDREN),
    value: None,
};

pub static VARS_STO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("matodaeum"),
        dictgen::InsensitiveStr::Ascii("matodeum"),
        dictgen::InsensitiveStr::Ascii("modaea"),
        dictgen::InsensitiveStr::Ascii("modaeal"),
        dictgen::InsensitiveStr::Ascii("modaeum"),
        dictgen::InsensitiveStr::Ascii("modaeums"),
        dictgen::InsensitiveStr::Ascii("modea"),
        dictgen::InsensitiveStr::Ascii("modeal"),
        dictgen::InsensitiveStr::Ascii("modeum"),
        dictgen::InsensitiveStr::Ascii("modeums"),
        dictgen::InsensitiveStr::Ascii("or"),
        dictgen::InsensitiveStr::Ascii("r"),
        dictgen::InsensitiveStr::Ascii("rier"),
        dictgen::InsensitiveStr::Ascii("ur"),
        dictgen::InsensitiveStr::Ascii("urier"),
        dictgen::InsensitiveStr::Ascii("wer"),
        dictgen::InsensitiveStr::Ascii("wers"),
        dictgen::InsensitiveStr::Ascii("wre"),
        dictgen::InsensitiveStr::Ascii("wres"),
    ],
    values: &[
        &[(0b11010, &ENTRY_STOMATODEUM_8741098205949880656)],
        &[(0b00001, &ENTRY_STOMATODEUM_8741098205949880656)],
        &[(0b11010, &ENTRY_STOMODEA_17558438948754879743)],
        &[(0b11010, &ENTRY_STOMODEAL_862902637399934901)],
        &[(0b11010, &ENTRY_STOMODEUM_7352107598988685520)],
        &[(0b11010, &ENTRY_STOMODEUMS_6754518911406029725)],
        &[(0b00001, &ENTRY_STOMODEA_17558438948754879743)],
        &[(0b00001, &ENTRY_STOMODEAL_862902637399934901)],
        &[(0b00001, &ENTRY_STOMODEUM_7352107598988685520)],
        &[(0b00001, &ENTRY_STOMODEUMS_6754518911406029725)],
        &[(0b11010, &ENTRY_STOR_5667483645094716832)],
        &[(0b00001, &ENTRY_STOR_5667483645094716832)],
        &[(0b00001, &ENTRY_STORIER_6107744465020666747)],
        &[(0b11010, &ENTRY_STOR_5667483645094716832)],
        &[(0b11010, &ENTRY_STORIER_6107744465020666747)],
        &[(0b00001, &ENTRY_STOWER_3427925530344361004)],
        &[(0b00001, &ENTRY_STOWERS_13406600671717463574)],
        &[(0b11010, &ENTRY_STOWER_3427925530344361004)],
        &[(0b11010, &ENTRY_STOWERS_13406600671717463574)],
    ],
    range: 1..=9,
};

static VARS_STI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_STI_CHILDREN),
    value: None,
};

pub static VARS_STI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gmatisation"),
        dictgen::InsensitiveStr::Ascii("gmatisations"),
        dictgen::InsensitiveStr::Ascii("gmatise"),
        dictgen::InsensitiveStr::Ascii("gmatised"),
        dictgen::InsensitiveStr::Ascii("gmatiser"),
        dictgen::InsensitiveStr::Ascii("gmatisers"),
        dictgen::InsensitiveStr::Ascii("gmatises"),
        dictgen::InsensitiveStr::Ascii("gmatising"),
        dictgen::InsensitiveStr::Ascii("gmatization"),
        dictgen::InsensitiveStr::Ascii("gmatizations"),
        dictgen::InsensitiveStr::Ascii("gmatize"),
        dictgen::InsensitiveStr::Ascii("gmatized"),
        dictgen::InsensitiveStr::Ascii("gmatizer"),
        dictgen::InsensitiveStr::Ascii("gmatizers"),
        dictgen::InsensitiveStr::Ascii("gmatizes"),
        dictgen::InsensitiveStr::Ascii("gmatizing"),
        dictgen::InsensitiveStr::Ascii("lbestrol"),
        dictgen::InsensitiveStr::Ascii("lbestrols"),
        dictgen::InsensitiveStr::Ascii("lboestrol"),
        dictgen::InsensitiveStr::Ascii("lboestrols"),
        dictgen::InsensitiveStr::Ascii("pulae"),
        dictgen::InsensitiveStr::Ascii("pule"),
    ],
    values: &[
        &[(0b10010, &ENTRY_STIGMATIZATION_12053258038244177237)],
        &[(0b10010, &ENTRY_STIGMATIZATIONS_5206308770780618928)],
        &[(0b10010, &ENTRY_STIGMATIZE_11220162708705129731)],
        &[(0b10010, &ENTRY_STIGMATIZED_14597283271555524870)],
        &[(0b10010, &ENTRY_STIGMATIZER_6119336948691311551)],
        &[(0b10010, &ENTRY_STIGMATIZERS_14825741166868000953)],
        &[(0b10010, &ENTRY_STIGMATIZES_316959479282222637)],
        &[(0b10010, &ENTRY_STIGMATIZING_14536679038681789225)],
        &[(0b01001, &ENTRY_STIGMATIZATION_12053258038244177237)],
        &[(0b01001, &ENTRY_STIGMATIZATIONS_5206308770780618928)],
        &[(0b01001, &ENTRY_STIGMATIZE_11220162708705129731)],
        &[(0b01001, &ENTRY_STIGMATIZED_14597283271555524870)],
        &[(0b01001, &ENTRY_STIGMATIZER_6119336948691311551)],
        &[(0b01001, &ENTRY_STIGMATIZERS_14825741166868000953)],
        &[(0b01001, &ENTRY_STIGMATIZES_316959479282222637)],
        &[(0b01001, &ENTRY_STIGMATIZING_14536679038681789225)],
        &[(0b00001, &ENTRY_STILBESTROL_10324911942394524790)],
        &[(0b00001, &ENTRY_STILBESTROLS_15735220233409139967)],
        &[(0b11010, &ENTRY_STILBESTROL_10324911942394524790)],
        &[(0b11010, &ENTRY_STILBESTROLS_15735220233409139967)],
        &[(0b11010, &ENTRY_STIPULE_14068580951871446375)],
        &[(0b00001, &ENTRY_STIPULE_14068580951871446375)],
    ],
    range: 4..=12,
};

static VARS_STE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_STE_CHILDREN),
    value: None,
};

pub static VARS_STE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arrhea"),
        dictgen::InsensitiveStr::Ascii("arrhoea"),
        dictgen::InsensitiveStr::Ascii("atorrhea"),
        dictgen::InsensitiveStr::Ascii("atorrheas"),
        dictgen::InsensitiveStr::Ascii("atorrhoea"),
        dictgen::InsensitiveStr::Ascii("atorrhoeas"),
        dictgen::InsensitiveStr::Ascii("lae"),
        dictgen::InsensitiveStr::Ascii("le"),
        dictgen::InsensitiveStr::Ascii("nciled"),
        dictgen::InsensitiveStr::Ascii("nciler"),
        dictgen::InsensitiveStr::Ascii("ncilers"),
        dictgen::InsensitiveStr::Ascii("nciling"),
        dictgen::InsensitiveStr::Ascii("ncilise"),
        dictgen::InsensitiveStr::Ascii("ncilize"),
        dictgen::InsensitiveStr::Ascii("ncilled"),
        dictgen::InsensitiveStr::Ascii("nciller"),
        dictgen::InsensitiveStr::Ascii("ncillers"),
        dictgen::InsensitiveStr::Ascii("ncilling"),
        dictgen::InsensitiveStr::Ascii("nopaeic"),
        dictgen::InsensitiveStr::Ascii("nopeic"),
        dictgen::InsensitiveStr::Ascii("ntor"),
        dictgen::InsensitiveStr::Ascii("ntors"),
        dictgen::InsensitiveStr::Ascii("ntour"),
        dictgen::InsensitiveStr::Ascii("ntours"),
        dictgen::InsensitiveStr::Ascii("rcoraemia"),
        dictgen::InsensitiveStr::Ascii("rcoremia"),
        dictgen::InsensitiveStr::Ascii("re"),
        dictgen::InsensitiveStr::Ascii("rilisabilities"),
        dictgen::InsensitiveStr::Ascii("rilisability"),
        dictgen::InsensitiveStr::Ascii("rilisable"),
        dictgen::InsensitiveStr::Ascii("rilisabler"),
        dictgen::InsensitiveStr::Ascii("rilisables"),
        dictgen::InsensitiveStr::Ascii("rilisablest"),
        dictgen::InsensitiveStr::Ascii("rilisation"),
        dictgen::InsensitiveStr::Ascii("rilisations"),
        dictgen::InsensitiveStr::Ascii("rilise"),
        dictgen::InsensitiveStr::Ascii("rilised"),
        dictgen::InsensitiveStr::Ascii("riliser"),
        dictgen::InsensitiveStr::Ascii("rilisers"),
        dictgen::InsensitiveStr::Ascii("rilises"),
        dictgen::InsensitiveStr::Ascii("rilising"),
        dictgen::InsensitiveStr::Ascii("rilizabilities"),
        dictgen::InsensitiveStr::Ascii("rilizability"),
        dictgen::InsensitiveStr::Ascii("rilizable"),
        dictgen::InsensitiveStr::Ascii("rilizabler"),
        dictgen::InsensitiveStr::Ascii("rilizables"),
        dictgen::InsensitiveStr::Ascii("rilizablest"),
        dictgen::InsensitiveStr::Ascii("rilization"),
        dictgen::InsensitiveStr::Ascii("rilizations"),
        dictgen::InsensitiveStr::Ascii("rilize"),
        dictgen::InsensitiveStr::Ascii("rilized"),
        dictgen::InsensitiveStr::Ascii("rilizer"),
        dictgen::InsensitiveStr::Ascii("rilizers"),
        dictgen::InsensitiveStr::Ascii("rilizes"),
        dictgen::InsensitiveStr::Ascii("rilizing"),
        dictgen::InsensitiveStr::Ascii("rt"),
    ],
    values: &[
        &[(0b00001, &ENTRY_STEARRHEA_595939535574612058)],
        &[(0b11010, &ENTRY_STEARRHEA_595939535574612058)],
        &[(0b00001, &ENTRY_STEATORRHEA_7006550897790317338)],
        &[(0b00001, &ENTRY_STEATORRHEAS_13012158523524663027)],
        &[(0b11010, &ENTRY_STEATORRHEA_7006550897790317338)],
        &[(0b11010, &ENTRY_STEATORRHEAS_13012158523524663027)],
        &[(0b11010, &ENTRY_STELE_2859069730518054769)],
        &[(0b00001, &ENTRY_STELE_2859069730518054769)],
        &[(0b00001, &ENTRY_STENCILED_5697108428616257678)],
        &[(0b00001, &ENTRY_STENCILER_421866534999425286)],
        &[(0b00001, &ENTRY_STENCILERS_9411797891465728151)],
        &[(0b00001, &ENTRY_STENCILING_2842472389755702411)],
        &[(0b10010, &ENTRY_STENCILIZE_2966153114254176045)],
        &[(0b01001, &ENTRY_STENCILIZE_2966153114254176045)],
        &[(0b11010, &ENTRY_STENCILED_5697108428616257678)],
        &[(0b11010, &ENTRY_STENCILER_421866534999425286)],
        &[(0b11010, &ENTRY_STENCILERS_9411797891465728151)],
        &[(0b11010, &ENTRY_STENCILING_2842472389755702411)],
        &[(0b11010, &ENTRY_STENOPEIC_9668625572592229054)],
        &[(0b00001, &ENTRY_STENOPEIC_9668625572592229054)],
        &[(0b00001, &ENTRY_STENTOR_10267053445154488996)],
        &[(0b00001, &ENTRY_STENTORS_11519094998749861028)],
        &[(0b11010, &ENTRY_STENTOR_10267053445154488996)],
        &[(0b11010, &ENTRY_STENTORS_11519094998749861028)],
        &[(0b11010, &ENTRY_STERCOREMIA_16211710810263584762)],
        &[(0b00001, &ENTRY_STERCOREMIA_16211710810263584762)],
        &[(0b00001, &ENTRY_STERE_14973674637271689830)],
        &[(0b10010, &ENTRY_STERILIZABILITIES_6174521207740612143)],
        &[(0b10010, &ENTRY_STERILIZABILITY_15756429437692504074)],
        &[(0b10010, &ENTRY_STERILIZABLE_4293244513265424916)],
        &[(0b10010, &ENTRY_STERILIZABLER_5396292600348410338)],
        &[(0b10010, &ENTRY_STERILIZABLES_395845848212238864)],
        &[(0b10010, &ENTRY_STERILIZABLEST_17116164156498805946)],
        &[(0b10010, &ENTRY_STERILIZATION_12496932581276788803)],
        &[(0b10010, &ENTRY_STERILIZATIONS_5179586981630149963)],
        &[(0b10010, &ENTRY_STERILIZE_12267676068965370103)],
        &[(0b10010, &ENTRY_STERILIZED_5349106414670253614)],
        &[(0b10010, &ENTRY_STERILIZER_9665607973109051795)],
        &[(0b10010, &ENTRY_STERILIZERS_3242667110144307808)],
        &[(0b10010, &ENTRY_STERILIZES_367692529356557376)],
        &[(0b10010, &ENTRY_STERILIZING_14742234573275089575)],
        &[(0b01001, &ENTRY_STERILIZABILITIES_6174521207740612143)],
        &[(0b01001, &ENTRY_STERILIZABILITY_15756429437692504074)],
        &[(0b01001, &ENTRY_STERILIZABLE_4293244513265424916)],
        &[(0b01001, &ENTRY_STERILIZABLER_5396292600348410338)],
        &[(0b01001, &ENTRY_STERILIZABLES_395845848212238864)],
        &[(0b01001, &ENTRY_STERILIZABLEST_17116164156498805946)],
        &[(0b01001, &ENTRY_STERILIZATION_12496932581276788803)],
        &[(0b01001, &ENTRY_STERILIZATIONS_5179586981630149963)],
        &[(0b01001, &ENTRY_STERILIZE_12267676068965370103)],
        &[(0b01001, &ENTRY_STERILIZED_5349106414670253614)],
        &[(0b01001, &ENTRY_STERILIZER_9665607973109051795)],
        &[(0b01001, &ENTRY_STERILIZERS_3242667110144307808)],
        &[(0b01001, &ENTRY_STERILIZES_367692529356557376)],
        &[(0b01001, &ENTRY_STERILIZING_14742234573275089575)],
        &[(0b00001, &ENTRY_STERT_15188513933795764953)],
    ],
    range: 2..=14,
};

static VARS_STA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_STA_CHILDREN),
    value: None,
};

pub static VARS_STA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bilisable"),
        dictgen::InsensitiveStr::Ascii("bilisation"),
        dictgen::InsensitiveStr::Ascii("bilisations"),
        dictgen::InsensitiveStr::Ascii("bilisator"),
        dictgen::InsensitiveStr::Ascii("bilisators"),
        dictgen::InsensitiveStr::Ascii("bilise"),
        dictgen::InsensitiveStr::Ascii("bilised"),
        dictgen::InsensitiveStr::Ascii("biliser"),
        dictgen::InsensitiveStr::Ascii("bilisers"),
        dictgen::InsensitiveStr::Ascii("bilises"),
        dictgen::InsensitiveStr::Ascii("bilising"),
        dictgen::InsensitiveStr::Ascii("bilizable"),
        dictgen::InsensitiveStr::Ascii("bilization"),
        dictgen::InsensitiveStr::Ascii("bilizations"),
        dictgen::InsensitiveStr::Ascii("bilizator"),
        dictgen::InsensitiveStr::Ascii("bilizators"),
        dictgen::InsensitiveStr::Ascii("bilize"),
        dictgen::InsensitiveStr::Ascii("bilized"),
        dictgen::InsensitiveStr::Ascii("bilizer"),
        dictgen::InsensitiveStr::Ascii("bilizers"),
        dictgen::InsensitiveStr::Ascii("bilizes"),
        dictgen::InsensitiveStr::Ascii("bilizing"),
        dictgen::InsensitiveStr::Ascii("llionise"),
        dictgen::InsensitiveStr::Ascii("llionises"),
        dictgen::InsensitiveStr::Ascii("llionize"),
        dictgen::InsensitiveStr::Ascii("llionizes"),
        dictgen::InsensitiveStr::Ascii("lwartise"),
        dictgen::InsensitiveStr::Ascii("lwartises"),
        dictgen::InsensitiveStr::Ascii("lwartize"),
        dictgen::InsensitiveStr::Ascii("lwartizes"),
        dictgen::InsensitiveStr::Ascii("mmelcolor"),
        dictgen::InsensitiveStr::Ascii("mmelcolour"),
        dictgen::InsensitiveStr::Ascii("ndardisable"),
        dictgen::InsensitiveStr::Ascii("ndardisables"),
        dictgen::InsensitiveStr::Ascii("ndardisation"),
        dictgen::InsensitiveStr::Ascii("ndardisations"),
        dictgen::InsensitiveStr::Ascii("ndardise"),
        dictgen::InsensitiveStr::Ascii("ndardised"),
        dictgen::InsensitiveStr::Ascii("ndardiser"),
        dictgen::InsensitiveStr::Ascii("ndardisers"),
        dictgen::InsensitiveStr::Ascii("ndardises"),
        dictgen::InsensitiveStr::Ascii("ndardising"),
        dictgen::InsensitiveStr::Ascii("ndardizable"),
        dictgen::InsensitiveStr::Ascii("ndardizables"),
        dictgen::InsensitiveStr::Ascii("ndardization"),
        dictgen::InsensitiveStr::Ascii("ndardizations"),
        dictgen::InsensitiveStr::Ascii("ndardize"),
        dictgen::InsensitiveStr::Ascii("ndardized"),
        dictgen::InsensitiveStr::Ascii("ndardizer"),
        dictgen::InsensitiveStr::Ascii("ndardizers"),
        dictgen::InsensitiveStr::Ascii("ndardizes"),
        dictgen::InsensitiveStr::Ascii("ndardizing"),
        dictgen::InsensitiveStr::Ascii("nzes"),
        dictgen::InsensitiveStr::Ascii("nzoes"),
        dictgen::InsensitiveStr::Ascii("pedectomised"),
        dictgen::InsensitiveStr::Ascii("pedectomized"),
        dictgen::InsensitiveStr::Ascii("phyledema"),
        dictgen::InsensitiveStr::Ascii("phyloedema"),
        dictgen::InsensitiveStr::Ascii("tisticise"),
        dictgen::InsensitiveStr::Ascii("tisticises"),
        dictgen::InsensitiveStr::Ascii("tisticize"),
        dictgen::InsensitiveStr::Ascii("tisticizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_STABILIZABLE_7038167747817470196)],
        &[(0b10010, &ENTRY_STABILIZATION_2391135939043331459)],
        &[(0b10010, &ENTRY_STABILIZATIONS_9746187249939087138)],
        &[(0b10010, &ENTRY_STABILIZATOR_17741108746142693419)],
        &[(0b10010, &ENTRY_STABILIZATORS_7145810033685180235)],
        &[(0b10010, &ENTRY_STABILIZE_1583006602954926586)],
        &[(0b10010, &ENTRY_STABILIZED_11581917854583003610)],
        &[(0b10010, &ENTRY_STABILIZER_3382378464960197128)],
        &[(0b10010, &ENTRY_STABILIZERS_16116889764524023645)],
        &[(0b10010, &ENTRY_STABILIZES_13521081822794596506)],
        &[(0b10010, &ENTRY_STABILIZING_14660265128274227263)],
        &[(0b01001, &ENTRY_STABILIZABLE_7038167747817470196)],
        &[(0b01001, &ENTRY_STABILIZATION_2391135939043331459)],
        &[(0b01001, &ENTRY_STABILIZATIONS_9746187249939087138)],
        &[(0b01001, &ENTRY_STABILIZATOR_17741108746142693419)],
        &[(0b01001, &ENTRY_STABILIZATORS_7145810033685180235)],
        &[(0b01001, &ENTRY_STABILIZE_1583006602954926586)],
        &[(0b01001, &ENTRY_STABILIZED_11581917854583003610)],
        &[(0b01001, &ENTRY_STABILIZER_3382378464960197128)],
        &[(0b01001, &ENTRY_STABILIZERS_16116889764524023645)],
        &[(0b01001, &ENTRY_STABILIZES_13521081822794596506)],
        &[(0b01001, &ENTRY_STABILIZING_14660265128274227263)],
        &[(0b10010, &ENTRY_STALLIONIZE_4208189765970167174)],
        &[(0b10010, &ENTRY_STALLIONIZES_15526567222649873911)],
        &[(0b01001, &ENTRY_STALLIONIZE_4208189765970167174)],
        &[(0b01001, &ENTRY_STALLIONIZES_15526567222649873911)],
        &[(0b10010, &ENTRY_STALWARTIZE_5995004425928514778)],
        &[(0b10010, &ENTRY_STALWARTIZES_10322196274491160190)],
        &[(0b01001, &ENTRY_STALWARTIZE_5995004425928514778)],
        &[(0b01001, &ENTRY_STALWARTIZES_10322196274491160190)],
        &[(0b00001, &ENTRY_STAMMELCOLOR_3112896012993635952)],
        &[(0b11010, &ENTRY_STAMMELCOLOR_3112896012993635952)],
        &[(0b10010, &ENTRY_STANDARDIZABLE_17034002894056241852)],
        &[(0b10010, &ENTRY_STANDARDIZABLES_16202726792541011392)],
        &[(0b10010, &ENTRY_STANDARDIZATION_18269374167214565579)],
        &[(0b10010, &ENTRY_STANDARDIZATIONS_4142468637621036850)],
        &[(0b10010, &ENTRY_STANDARDIZE_13224353253220214220)],
        &[(0b10010, &ENTRY_STANDARDIZED_10576000602438339721)],
        &[(0b10010, &ENTRY_STANDARDIZER_10177388752556810926)],
        &[(0b10010, &ENTRY_STANDARDIZERS_12514193886547172459)],
        &[(0b10010, &ENTRY_STANDARDIZES_15875984166067512659)],
        &[(0b10010, &ENTRY_STANDARDIZING_14529046022304657646)],
        &[(0b01001, &ENTRY_STANDARDIZABLE_17034002894056241852)],
        &[(0b01001, &ENTRY_STANDARDIZABLES_16202726792541011392)],
        &[(0b01001, &ENTRY_STANDARDIZATION_18269374167214565579)],
        &[(0b01001, &ENTRY_STANDARDIZATIONS_4142468637621036850)],
        &[(0b01001, &ENTRY_STANDARDIZE_13224353253220214220)],
        &[(0b01001, &ENTRY_STANDARDIZED_10576000602438339721)],
        &[(0b01001, &ENTRY_STANDARDIZER_10177388752556810926)],
        &[(0b01001, &ENTRY_STANDARDIZERS_12514193886547172459)],
        &[(0b01001, &ENTRY_STANDARDIZES_15875984166067512659)],
        &[(0b01001, &ENTRY_STANDARDIZING_14529046022304657646)],
        &[(0b00001, &ENTRY_STANZES_13092355244299837812)],
        &[(0b11010, &ENTRY_STANZES_13092355244299837812)],
        &[(0b10010, &ENTRY_STAPEDECTOMIZED_3532179470450241494)],
        &[(0b01001, &ENTRY_STAPEDECTOMIZED_3532179470450241494)],
        &[(0b00001, &ENTRY_STAPHYLEDEMA_15542876830880978325)],
        &[(0b11010, &ENTRY_STAPHYLEDEMA_15542876830880978325)],
        &[(0b10010, &ENTRY_STATISTICIZE_5352173326738036614)],
        &[(0b10010, &ENTRY_STATISTICIZES_3777559913591399659)],
        &[(0b01001, &ENTRY_STATISTICIZE_5352173326738036614)],
        &[(0b01001, &ENTRY_STATISTICIZES_3777559913591399659)],
    ],
    range: 4..=13,
};

static VARS_SQ_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SQ_CHILDREN),
    value: None,
};

pub static VARS_SQ_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("uamae"),
        dictgen::InsensitiveStr::Ascii("uame"),
        dictgen::InsensitiveStr::Ascii("uamulae"),
        dictgen::InsensitiveStr::Ascii("uamule"),
        dictgen::InsensitiveStr::Ascii("uier"),
        dictgen::InsensitiveStr::Ascii("uire"),
        dictgen::InsensitiveStr::Ascii("uirreled"),
        dictgen::InsensitiveStr::Ascii("uirreling"),
        dictgen::InsensitiveStr::Ascii("uirrelled"),
        dictgen::InsensitiveStr::Ascii("uirrelling"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SQUAME_15183787142740018891)],
        &[(0b00001, &ENTRY_SQUAME_15183787142740018891)],
        &[(0b11010, &ENTRY_SQUAMULE_11975141371110576408)],
        &[(0b00001, &ENTRY_SQUAMULE_11975141371110576408)],
        &[(0b00001, &ENTRY_SQUIER_16883964174471128452)],
        &[(0b11010, &ENTRY_SQUIER_16883964174471128452)],
        &[(0b01001, &ENTRY_SQUIRRELED_11318257635454397551)],
        &[(0b01001, &ENTRY_SQUIRRELING_17909585620200517283)],
        &[(0b11010, &ENTRY_SQUIRRELED_11318257635454397551)],
        &[(0b11010, &ENTRY_SQUIRRELING_17909585620200517283)],
    ],
    range: 4..=10,
};

static VARS_SP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SP_CHILDREN),
    value: None,
};

static VARS_SP_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_SPA_NODE),
    None,
    None,
    None,
    Some(&VARS_SPE_NODE),
    None,
    None,
    Some(&VARS_SPH_NODE),
    Some(&VARS_SPI_NODE),
    None,
    None,
    Some(&VARS_SPL_NODE),
    None,
    None,
    Some(&VARS_SPO_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SPY_NODE),
    None,
];

static VARS_SPY_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SPY_CHILDREN),
    value: None,
};

pub static VARS_SPY_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("re"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SPYER_15698237802555201567)],
        &[(0b11010, &ENTRY_SPYER_15698237802555201567)],
    ],
    range: 2..=2,
};

static VARS_SPO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SPO_CHILDREN),
    value: None,
};

pub static VARS_SPO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ilt")],
    values: &[&[(0b11010, &ENTRY_SPOILED_9946660437827218525)]],
    range: 3..=3,
};

static VARS_SPL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SPL_CHILDREN),
    value: None,
};

pub static VARS_SPL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("anchnocele"),
        dictgen::InsensitiveStr::Ascii("anchnocoele"),
        dictgen::InsensitiveStr::Ascii("endor"),
        dictgen::InsensitiveStr::Ascii("endorproof"),
        dictgen::InsensitiveStr::Ascii("endors"),
        dictgen::InsensitiveStr::Ascii("endour"),
        dictgen::InsensitiveStr::Ascii("endourproof"),
        dictgen::InsensitiveStr::Ascii("endours"),
        dictgen::InsensitiveStr::Ascii("enectomised"),
        dictgen::InsensitiveStr::Ascii("enectomized"),
        dictgen::InsensitiveStr::Ascii("enisation"),
        dictgen::InsensitiveStr::Ascii("enisations"),
        dictgen::InsensitiveStr::Ascii("enization"),
        dictgen::InsensitiveStr::Ascii("enizations"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SPLANCHNOCELE_10962826556710463329)],
        &[(0b11010, &ENTRY_SPLANCHNOCELE_10962826556710463329)],
        &[(0b11001, &ENTRY_SPLENDOR_698262644085203522)],
        &[(0b00001, &ENTRY_SPLENDORPROOF_8961725742582755989)],
        &[(0b11001, &ENTRY_SPLENDORS_16829161556225143613)],
        &[(0b11010, &ENTRY_SPLENDOR_698262644085203522)],
        &[(0b11010, &ENTRY_SPLENDORPROOF_8961725742582755989)],
        &[(0b11010, &ENTRY_SPLENDORS_16829161556225143613)],
        &[(0b10010, &ENTRY_SPLENECTOMIZED_8219804151047161524)],
        &[(0b01001, &ENTRY_SPLENECTOMIZED_8219804151047161524)],
        &[(0b10010, &ENTRY_SPLENIZATION_7858507853343431089)],
        &[(0b10010, &ENTRY_SPLENIZATIONS_17949623258974597810)],
        &[(0b01001, &ENTRY_SPLENIZATION_7858507853343431089)],
        &[(0b01001, &ENTRY_SPLENIZATIONS_17949623258974597810)],
    ],
    range: 5..=11,
};

static VARS_SPI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SPI_CHILDREN),
    value: None,
};

pub static VARS_SPI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ers"),
        dictgen::InsensitiveStr::Ascii("nulae"),
        dictgen::InsensitiveStr::Ascii("nule"),
        dictgen::InsensitiveStr::Ascii("raled"),
        dictgen::InsensitiveStr::Ascii("raling"),
        dictgen::InsensitiveStr::Ascii("ralisation"),
        dictgen::InsensitiveStr::Ascii("ralisations"),
        dictgen::InsensitiveStr::Ascii("ralise"),
        dictgen::InsensitiveStr::Ascii("ralises"),
        dictgen::InsensitiveStr::Ascii("ralization"),
        dictgen::InsensitiveStr::Ascii("ralizations"),
        dictgen::InsensitiveStr::Ascii("ralize"),
        dictgen::InsensitiveStr::Ascii("ralizes"),
        dictgen::InsensitiveStr::Ascii("ralled"),
        dictgen::InsensitiveStr::Ascii("ralling"),
        dictgen::InsensitiveStr::Ascii("rea"),
        dictgen::InsensitiveStr::Ascii("reas"),
        dictgen::InsensitiveStr::Ascii("res"),
        dictgen::InsensitiveStr::Ascii("ritise"),
        dictgen::InsensitiveStr::Ascii("ritises"),
        dictgen::InsensitiveStr::Ascii("ritize"),
        dictgen::InsensitiveStr::Ascii("ritizes"),
        dictgen::InsensitiveStr::Ascii("ritualisation"),
        dictgen::InsensitiveStr::Ascii("ritualisations"),
        dictgen::InsensitiveStr::Ascii("ritualise"),
        dictgen::InsensitiveStr::Ascii("ritualised"),
        dictgen::InsensitiveStr::Ascii("ritualiser"),
        dictgen::InsensitiveStr::Ascii("ritualisers"),
        dictgen::InsensitiveStr::Ascii("ritualises"),
        dictgen::InsensitiveStr::Ascii("ritualising"),
        dictgen::InsensitiveStr::Ascii("ritualization"),
        dictgen::InsensitiveStr::Ascii("ritualizations"),
        dictgen::InsensitiveStr::Ascii("ritualize"),
        dictgen::InsensitiveStr::Ascii("ritualized"),
        dictgen::InsensitiveStr::Ascii("ritualizer"),
        dictgen::InsensitiveStr::Ascii("ritualizers"),
        dictgen::InsensitiveStr::Ascii("ritualizes"),
        dictgen::InsensitiveStr::Ascii("ritualizing"),
        dictgen::InsensitiveStr::Ascii("rochaetal"),
        dictgen::InsensitiveStr::Ascii("rochaete"),
        dictgen::InsensitiveStr::Ascii("rochaetes"),
        dictgen::InsensitiveStr::Ascii("rochaetoses"),
        dictgen::InsensitiveStr::Ascii("rochaetosis"),
        dictgen::InsensitiveStr::Ascii("rochaetotic"),
        dictgen::InsensitiveStr::Ascii("rochetal"),
        dictgen::InsensitiveStr::Ascii("rochete"),
        dictgen::InsensitiveStr::Ascii("rochetes"),
        dictgen::InsensitiveStr::Ascii("rochetoses"),
        dictgen::InsensitiveStr::Ascii("rochetosis"),
        dictgen::InsensitiveStr::Ascii("rochetotic"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SPIERS_5515884338097894490)],
        &[(0b11010, &ENTRY_SPINULE_17210556472422983066)],
        &[(0b00001, &ENTRY_SPINULE_17210556472422983066)],
        &[(0b01001, &ENTRY_SPIRALED_4583591683626098518)],
        &[(0b01001, &ENTRY_SPIRALING_4625432215690768886)],
        &[(0b10010, &ENTRY_SPIRALIZATION_8541479832578673907)],
        &[(0b10010, &ENTRY_SPIRALIZATIONS_2042085502750008288)],
        &[(0b10010, &ENTRY_SPIRALIZE_16007127051122986788)],
        &[(0b10010, &ENTRY_SPIRALIZES_6682564053194995427)],
        &[(0b01001, &ENTRY_SPIRALIZATION_8541479832578673907)],
        &[(0b01001, &ENTRY_SPIRALIZATIONS_2042085502750008288)],
        &[(0b01001, &ENTRY_SPIRALIZE_16007127051122986788)],
        &[(0b01001, &ENTRY_SPIRALIZES_6682564053194995427)],
        &[(0b11010, &ENTRY_SPIRALED_4583591683626098518)],
        &[(0b11010, &ENTRY_SPIRALING_4625432215690768886)],
        &[(0b01001, &ENTRY_SPIREA_16883104999884113279)],
        &[(0b01001, &ENTRY_SPIREAS_14727691610313704462)],
        &[(0b11010, &ENTRY_SPIERS_5515884338097894490)],
        &[(0b10010, &ENTRY_SPIRITIZE_9378881530105575004)],
        &[(0b10010, &ENTRY_SPIRITIZES_6541246359921725745)],
        &[(0b01001, &ENTRY_SPIRITIZE_9378881530105575004)],
        &[(0b01001, &ENTRY_SPIRITIZES_6541246359921725745)],
        &[(0b10010, &ENTRY_SPIRITUALIZATION_10305886720640139033)],
        &[(0b10010, &ENTRY_SPIRITUALIZATIONS_8932729483849010613)],
        &[(0b10010, &ENTRY_SPIRITUALIZE_7047180007869852793)],
        &[(0b10010, &ENTRY_SPIRITUALIZED_2725993091146698638)],
        &[(0b10010, &ENTRY_SPIRITUALIZER_8504978883588201552)],
        &[(0b10010, &ENTRY_SPIRITUALIZERS_3732134443047012330)],
        &[(0b10010, &ENTRY_SPIRITUALIZES_1639337578015899962)],
        &[(0b10010, &ENTRY_SPIRITUALIZING_17446854514925186660)],
        &[(0b01001, &ENTRY_SPIRITUALIZATION_10305886720640139033)],
        &[(0b01001, &ENTRY_SPIRITUALIZATIONS_8932729483849010613)],
        &[(0b01001, &ENTRY_SPIRITUALIZE_7047180007869852793)],
        &[(0b01001, &ENTRY_SPIRITUALIZED_2725993091146698638)],
        &[(0b01001, &ENTRY_SPIRITUALIZER_8504978883588201552)],
        &[(0b01001, &ENTRY_SPIRITUALIZERS_3732134443047012330)],
        &[(0b01001, &ENTRY_SPIRITUALIZES_1639337578015899962)],
        &[(0b01001, &ENTRY_SPIRITUALIZING_17446854514925186660)],
        &[(0b11010, &ENTRY_SPIROCHETAL_11634963050010672522)],
        &[(0b10010, &ENTRY_SPIROCHETE_5978254499923720079)],
        &[(0b10010, &ENTRY_SPIROCHETES_13621339480155823661)],
        &[(0b11010, &ENTRY_SPIROCHETOSES_6730304618752518023)],
        &[(0b11010, &ENTRY_SPIROCHETOSIS_13176480837782571985)],
        &[(0b11010, &ENTRY_SPIROCHETOTIC_8684207899956468554)],
        &[(0b00001, &ENTRY_SPIROCHETAL_11634963050010672522)],
        &[(0b01001, &ENTRY_SPIROCHETE_5978254499923720079)],
        &[(0b01001, &ENTRY_SPIROCHETES_13621339480155823661)],
        &[(0b00001, &ENTRY_SPIROCHETOSES_6730304618752518023)],
        &[(0b00001, &ENTRY_SPIROCHETOSIS_13176480837782571985)],
        &[(0b00001, &ENTRY_SPIROCHETOTIC_8684207899956468554)],
    ],
    range: 3..=14,
};

static VARS_SPH_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SPH_CHILDREN),
    value: None,
};

pub static VARS_SPH_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aerocrystal"),
        dictgen::InsensitiveStr::Ascii("aerosome"),
        dictgen::InsensitiveStr::Ascii("enethmoid"),
        dictgen::InsensitiveStr::Ascii("enethmoidal"),
        dictgen::InsensitiveStr::Ascii("enoethmoid"),
        dictgen::InsensitiveStr::Ascii("enoethmoidal"),
        dictgen::InsensitiveStr::Ascii("erocrystal"),
        dictgen::InsensitiveStr::Ascii("eroidisation"),
        dictgen::InsensitiveStr::Ascii("eroidisations"),
        dictgen::InsensitiveStr::Ascii("eroidise"),
        dictgen::InsensitiveStr::Ascii("eroidised"),
        dictgen::InsensitiveStr::Ascii("eroidises"),
        dictgen::InsensitiveStr::Ascii("eroidising"),
        dictgen::InsensitiveStr::Ascii("eroidization"),
        dictgen::InsensitiveStr::Ascii("eroidizations"),
        dictgen::InsensitiveStr::Ascii("eroidize"),
        dictgen::InsensitiveStr::Ascii("eroidized"),
        dictgen::InsensitiveStr::Ascii("eroidizes"),
        dictgen::InsensitiveStr::Ascii("eroidizing"),
        dictgen::InsensitiveStr::Ascii("erosome"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SPHEROCRYSTAL_13381643278818911724)],
        &[(0b11010, &ENTRY_SPHEROSOME_14408424187868099563)],
        &[(0b00001, &ENTRY_SPHENETHMOID_8848939739861600805)],
        &[(0b00001, &ENTRY_SPHENETHMOIDAL_4192928733742313479)],
        &[(0b11010, &ENTRY_SPHENETHMOID_8848939739861600805)],
        &[(0b11010, &ENTRY_SPHENETHMOIDAL_4192928733742313479)],
        &[(0b00001, &ENTRY_SPHEROCRYSTAL_13381643278818911724)],
        &[(0b10010, &ENTRY_SPHEROIDIZATION_1425186216287202703)],
        &[(0b10010, &ENTRY_SPHEROIDIZATIONS_780683803829928867)],
        &[(0b10010, &ENTRY_SPHEROIDIZE_11471029450807575082)],
        &[(0b10010, &ENTRY_SPHEROIDIZED_3309613407465330972)],
        &[(0b10010, &ENTRY_SPHEROIDIZES_6259874484087826697)],
        &[(0b10010, &ENTRY_SPHEROIDIZING_11358721974863679837)],
        &[(0b01001, &ENTRY_SPHEROIDIZATION_1425186216287202703)],
        &[(0b01001, &ENTRY_SPHEROIDIZATIONS_780683803829928867)],
        &[(0b01001, &ENTRY_SPHEROIDIZE_11471029450807575082)],
        &[(0b01001, &ENTRY_SPHEROIDIZED_3309613407465330972)],
        &[(0b01001, &ENTRY_SPHEROIDIZES_6259874484087826697)],
        &[(0b01001, &ENTRY_SPHEROIDIZING_11358721974863679837)],
        &[(0b00001, &ENTRY_SPHEROSOME_14408424187868099563)],
    ],
    range: 7..=13,
};

static VARS_SPE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SPE_CHILDREN),
    value: None,
};

pub static VARS_SPE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cialisation"),
        dictgen::InsensitiveStr::Ascii("cialisations"),
        dictgen::InsensitiveStr::Ascii("cialise"),
        dictgen::InsensitiveStr::Ascii("cialised"),
        dictgen::InsensitiveStr::Ascii("cialiser"),
        dictgen::InsensitiveStr::Ascii("cialisers"),
        dictgen::InsensitiveStr::Ascii("cialises"),
        dictgen::InsensitiveStr::Ascii("cialising"),
        dictgen::InsensitiveStr::Ascii("cialities"),
        dictgen::InsensitiveStr::Ascii("ciality"),
        dictgen::InsensitiveStr::Ascii("cialization"),
        dictgen::InsensitiveStr::Ascii("cializations"),
        dictgen::InsensitiveStr::Ascii("cialize"),
        dictgen::InsensitiveStr::Ascii("cialized"),
        dictgen::InsensitiveStr::Ascii("cializer"),
        dictgen::InsensitiveStr::Ascii("cializers"),
        dictgen::InsensitiveStr::Ascii("cializes"),
        dictgen::InsensitiveStr::Ascii("cializing"),
        dictgen::InsensitiveStr::Ascii("cialties"),
        dictgen::InsensitiveStr::Ascii("cialty"),
        dictgen::InsensitiveStr::Ascii("cificise"),
        dictgen::InsensitiveStr::Ascii("cificises"),
        dictgen::InsensitiveStr::Ascii("cificize"),
        dictgen::InsensitiveStr::Ascii("cificizes"),
        dictgen::InsensitiveStr::Ascii("cimenise"),
        dictgen::InsensitiveStr::Ascii("cimenises"),
        dictgen::InsensitiveStr::Ascii("cimenize"),
        dictgen::InsensitiveStr::Ascii("cimenizes"),
        dictgen::InsensitiveStr::Ascii("cter"),
        dictgen::InsensitiveStr::Ascii("ctered"),
        dictgen::InsensitiveStr::Ascii("cterlike"),
        dictgen::InsensitiveStr::Ascii("cterlikes"),
        dictgen::InsensitiveStr::Ascii("cters"),
        dictgen::InsensitiveStr::Ascii("ctre"),
        dictgen::InsensitiveStr::Ascii("ctred"),
        dictgen::InsensitiveStr::Ascii("ctrelike"),
        dictgen::InsensitiveStr::Ascii("ctrelikes"),
        dictgen::InsensitiveStr::Ascii("ctres"),
        dictgen::InsensitiveStr::Ascii("ctrocolorimetry"),
        dictgen::InsensitiveStr::Ascii("ctrocolourimetry"),
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("laean"),
        dictgen::InsensitiveStr::Ascii("laeological"),
        dictgen::InsensitiveStr::Ascii("laeothem"),
        dictgen::InsensitiveStr::Ascii("laeothems"),
        dictgen::InsensitiveStr::Ascii("lean"),
        dictgen::InsensitiveStr::Ascii("leothem"),
        dictgen::InsensitiveStr::Ascii("leothems"),
        dictgen::InsensitiveStr::Ascii("re"),
        dictgen::InsensitiveStr::Ascii("rmatorrhea"),
        dictgen::InsensitiveStr::Ascii("rmatorrheas"),
        dictgen::InsensitiveStr::Ascii("rmatorrhoea"),
        dictgen::InsensitiveStr::Ascii("rmatorrhoeas"),
        dictgen::InsensitiveStr::Ascii("ronares"),
        dictgen::InsensitiveStr::Ascii("ronaroes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SPECIALIZATION_14868724416514006075)],
        &[(0b10010, &ENTRY_SPECIALIZATIONS_13893908534368099370)],
        &[(0b10010, &ENTRY_SPECIALIZE_13734198890330005704)],
        &[(0b10010, &ENTRY_SPECIALIZED_8365382398741657820)],
        &[(0b10010, &ENTRY_SPECIALIZER_3424451690381023981)],
        &[(0b10010, &ENTRY_SPECIALIZERS_321317241265822118)],
        &[(0b10010, &ENTRY_SPECIALIZES_12943575911419958048)],
        &[(0b10010, &ENTRY_SPECIALIZING_2079181106562003064)],
        &[(0b10010, &ENTRY_SPECIALTIES_3691519001585260032)],
        &[(0b10010, &ENTRY_SPECIALTY_15229334144133093973)],
        &[(0b01001, &ENTRY_SPECIALIZATION_14868724416514006075)],
        &[(0b01001, &ENTRY_SPECIALIZATIONS_13893908534368099370)],
        &[(0b01001, &ENTRY_SPECIALIZE_13734198890330005704)],
        &[(0b01001, &ENTRY_SPECIALIZED_8365382398741657820)],
        &[(0b01001, &ENTRY_SPECIALIZER_3424451690381023981)],
        &[(0b01001, &ENTRY_SPECIALIZERS_321317241265822118)],
        &[(0b01001, &ENTRY_SPECIALIZES_12943575911419958048)],
        &[(0b01001, &ENTRY_SPECIALIZING_2079181106562003064)],
        &[(0b01001, &ENTRY_SPECIALTIES_3691519001585260032)],
        &[(0b01001, &ENTRY_SPECIALTY_15229334144133093973)],
        &[(0b10010, &ENTRY_SPECIFICIZE_14913302620346573053)],
        &[(0b10010, &ENTRY_SPECIFICIZES_14547115587945723943)],
        &[(0b01001, &ENTRY_SPECIFICIZE_14913302620346573053)],
        &[(0b01001, &ENTRY_SPECIFICIZES_14547115587945723943)],
        &[(0b10010, &ENTRY_SPECIMENIZE_2090384801819711905)],
        &[(0b10010, &ENTRY_SPECIMENIZES_8129034162279199571)],
        &[(0b01001, &ENTRY_SPECIMENIZE_2090384801819711905)],
        &[(0b01001, &ENTRY_SPECIMENIZES_8129034162279199571)],
        &[(0b00001, &ENTRY_SPECTER_13138390153678479670)],
        &[(0b00001, &ENTRY_SPECTERED_863247434920694580)],
        &[(0b00001, &ENTRY_SPECTERLIKE_18260751826068593688)],
        &[(0b00001, &ENTRY_SPECTERLIKES_484157250269129460)],
        &[(0b00001, &ENTRY_SPECTERS_7942939111689789209)],
        &[(0b11010, &ENTRY_SPECTER_13138390153678479670)],
        &[(0b11010, &ENTRY_SPECTERED_863247434920694580)],
        &[(0b11010, &ENTRY_SPECTERLIKE_18260751826068593688)],
        &[(0b11010, &ENTRY_SPECTERLIKES_484157250269129460)],
        &[(0b11010, &ENTRY_SPECTERS_7942939111689789209)],
        &[(0b00001, &ENTRY_SPECTROCOLORIMETRY_1759736892341904212)],
        &[(0b11010, &ENTRY_SPECTROCOLORIMETRY_1759736892341904212)],
        &[(0b00001, &ENTRY_SPEER_13429671139585207271)],
        &[(0b11010, &ENTRY_SPELEAN_8367235262898475105)],
        &[(0b11010, &ENTRY_SPELEOLOGICAL_11481859540905022703)],
        &[(0b11010, &ENTRY_SPELEOTHEM_17324027630005062947)],
        &[(0b11010, &ENTRY_SPELEOTHEMS_10285341670778918846)],
        &[(0b00001, &ENTRY_SPELEAN_8367235262898475105)],
        &[(0b00001, &ENTRY_SPELEOTHEM_17324027630005062947)],
        &[(0b00001, &ENTRY_SPELEOTHEMS_10285341670778918846)],
        &[(0b11010, &ENTRY_SPEER_13429671139585207271)],
        &[(0b00001, &ENTRY_SPERMATORRHEA_11364148558414858528)],
        &[(0b00001, &ENTRY_SPERMATORRHEAS_3208610420634611148)],
        &[(0b11010, &ENTRY_SPERMATORRHEA_11364148558414858528)],
        &[(0b11010, &ENTRY_SPERMATORRHEAS_3208610420634611148)],
        &[(0b00001, &ENTRY_SPERONARES_16134515720540164866)],
        &[(0b11010, &ENTRY_SPERONARES_16134515720540164866)],
    ],
    range: 2..=16,
};

static VARS_SPA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SPA_CHILDREN),
    value: None,
};

pub static VARS_SPA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("naemia"),
        dictgen::InsensitiveStr::Ascii("naemic"),
        dictgen::InsensitiveStr::Ascii("nemia"),
        dictgen::InsensitiveStr::Ascii("nemic"),
        dictgen::InsensitiveStr::Ascii("niardisation"),
        dictgen::InsensitiveStr::Ascii("niardisations"),
        dictgen::InsensitiveStr::Ascii("niardise"),
        dictgen::InsensitiveStr::Ascii("niardises"),
        dictgen::InsensitiveStr::Ascii("niardization"),
        dictgen::InsensitiveStr::Ascii("niardizations"),
        dictgen::InsensitiveStr::Ascii("niardize"),
        dictgen::InsensitiveStr::Ascii("niardizes"),
        dictgen::InsensitiveStr::Ascii("niolise"),
        dictgen::InsensitiveStr::Ascii("niolised"),
        dictgen::InsensitiveStr::Ascii("niolises"),
        dictgen::InsensitiveStr::Ascii("niolising"),
        dictgen::InsensitiveStr::Ascii("niolize"),
        dictgen::InsensitiveStr::Ascii("niolized"),
        dictgen::InsensitiveStr::Ascii("niolizes"),
        dictgen::InsensitiveStr::Ascii("niolizing"),
        dictgen::InsensitiveStr::Ascii("nishise"),
        dictgen::InsensitiveStr::Ascii("nishises"),
        dictgen::InsensitiveStr::Ascii("nishize"),
        dictgen::InsensitiveStr::Ascii("nishizes"),
        dictgen::InsensitiveStr::Ascii("nopnea"),
        dictgen::InsensitiveStr::Ascii("nopnoea"),
        dictgen::InsensitiveStr::Ascii("rers"),
        dictgen::InsensitiveStr::Ascii("rres"),
        dictgen::InsensitiveStr::Ascii("rtanise"),
        dictgen::InsensitiveStr::Ascii("rtanises"),
        dictgen::InsensitiveStr::Ascii("rtanize"),
        dictgen::InsensitiveStr::Ascii("rtanizes"),
        dictgen::InsensitiveStr::Ascii("tialisation"),
        dictgen::InsensitiveStr::Ascii("tialisations"),
        dictgen::InsensitiveStr::Ascii("tialise"),
        dictgen::InsensitiveStr::Ascii("tialises"),
        dictgen::InsensitiveStr::Ascii("tialization"),
        dictgen::InsensitiveStr::Ascii("tializations"),
        dictgen::InsensitiveStr::Ascii("tialize"),
        dictgen::InsensitiveStr::Ascii("tializes"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SPANEMIA_9395556157284175278)],
        &[(0b11010, &ENTRY_SPANEMIC_7019184248567022986)],
        &[(0b00001, &ENTRY_SPANEMIA_9395556157284175278)],
        &[(0b00001, &ENTRY_SPANEMIC_7019184248567022986)],
        &[(0b10010, &ENTRY_SPANIARDIZATION_10902219760262843235)],
        &[(0b10010, &ENTRY_SPANIARDIZATIONS_15525961894554670327)],
        &[(0b10010, &ENTRY_SPANIARDIZE_9569545691628177723)],
        &[(0b10010, &ENTRY_SPANIARDIZES_6439262747070069854)],
        &[(0b01001, &ENTRY_SPANIARDIZATION_10902219760262843235)],
        &[(0b01001, &ENTRY_SPANIARDIZATIONS_15525961894554670327)],
        &[(0b01001, &ENTRY_SPANIARDIZE_9569545691628177723)],
        &[(0b01001, &ENTRY_SPANIARDIZES_6439262747070069854)],
        &[(0b10010, &ENTRY_SPANIOLIZE_16413139481606920807)],
        &[(0b10010, &ENTRY_SPANIOLIZED_9570991099566114102)],
        &[(0b10010, &ENTRY_SPANIOLIZES_7108790081189873491)],
        &[(0b10010, &ENTRY_SPANIOLIZING_13650496056576542802)],
        &[(0b01001, &ENTRY_SPANIOLIZE_16413139481606920807)],
        &[(0b01001, &ENTRY_SPANIOLIZED_9570991099566114102)],
        &[(0b01001, &ENTRY_SPANIOLIZES_7108790081189873491)],
        &[(0b01001, &ENTRY_SPANIOLIZING_13650496056576542802)],
        &[(0b10010, &ENTRY_SPANISHIZE_11599801654411089329)],
        &[(0b10010, &ENTRY_SPANISHIZES_15280734989274435032)],
        &[(0b01001, &ENTRY_SPANISHIZE_11599801654411089329)],
        &[(0b01001, &ENTRY_SPANISHIZES_15280734989274435032)],
        &[(0b00001, &ENTRY_SPANOPNEA_8865008578129066489)],
        &[(0b11010, &ENTRY_SPANOPNEA_8865008578129066489)],
        &[(0b00001, &ENTRY_SPARERS_12651957075913392459)],
        &[(0b11010, &ENTRY_SPARERS_12651957075913392459)],
        &[(0b10010, &ENTRY_SPARTANIZE_14452942641175240684)],
        &[(0b10010, &ENTRY_SPARTANIZES_11376123191933793512)],
        &[(0b01001, &ENTRY_SPARTANIZE_14452942641175240684)],
        &[(0b01001, &ENTRY_SPARTANIZES_11376123191933793512)],
        &[(0b10010, &ENTRY_SPATIALIZATION_17405201949564996789)],
        &[(0b10010, &ENTRY_SPATIALIZATIONS_4112547726772378999)],
        &[(0b10010, &ENTRY_SPATIALIZE_16660740722538409917)],
        &[(0b10010, &ENTRY_SPATIALIZES_13997333572376113619)],
        &[(0b01001, &ENTRY_SPATIALIZATION_17405201949564996789)],
        &[(0b01001, &ENTRY_SPATIALIZATIONS_4112547726772378999)],
        &[(0b01001, &ENTRY_SPATIALIZE_16660740722538409917)],
        &[(0b01001, &ENTRY_SPATIALIZES_13997333572376113619)],
    ],
    range: 4..=13,
};

static VARS_SO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SO_CHILDREN),
    value: None,
};

static VARS_SO_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_SOB_NODE),
    Some(&VARS_SOC_NODE),
    Some(&VARS_SOD_NODE),
    Some(&VARS_SOE_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SOL_NODE),
    Some(&VARS_SOM_NODE),
    Some(&VARS_SON_NODE),
    None,
    None,
    None,
    Some(&VARS_SOR_NODE),
    None,
    None,
    Some(&VARS_SOU_NODE),
    Some(&VARS_SOV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_SOV_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SOV_CHILDREN),
    value: None,
};

pub static VARS_SOV_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ietisation"),
        dictgen::InsensitiveStr::Ascii("ietisations"),
        dictgen::InsensitiveStr::Ascii("ietise"),
        dictgen::InsensitiveStr::Ascii("ietised"),
        dictgen::InsensitiveStr::Ascii("ietises"),
        dictgen::InsensitiveStr::Ascii("ietising"),
        dictgen::InsensitiveStr::Ascii("ietization"),
        dictgen::InsensitiveStr::Ascii("ietizations"),
        dictgen::InsensitiveStr::Ascii("ietize"),
        dictgen::InsensitiveStr::Ascii("ietized"),
        dictgen::InsensitiveStr::Ascii("ietizes"),
        dictgen::InsensitiveStr::Ascii("ietizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SOVIETIZATION_13205972349841767875)],
        &[(0b10010, &ENTRY_SOVIETIZATIONS_2629132161469247656)],
        &[(0b10010, &ENTRY_SOVIETIZE_15802906407586023669)],
        &[(0b10010, &ENTRY_SOVIETIZED_7565927092510685793)],
        &[(0b10010, &ENTRY_SOVIETIZES_11590305664562136263)],
        &[(0b10010, &ENTRY_SOVIETIZING_16212924505860778534)],
        &[(0b01001, &ENTRY_SOVIETIZATION_13205972349841767875)],
        &[(0b01001, &ENTRY_SOVIETIZATIONS_2629132161469247656)],
        &[(0b01001, &ENTRY_SOVIETIZE_15802906407586023669)],
        &[(0b01001, &ENTRY_SOVIETIZED_7565927092510685793)],
        &[(0b01001, &ENTRY_SOVIETIZES_11590305664562136263)],
        &[(0b01001, &ENTRY_SOVIETIZING_16212924505860778534)],
    ],
    range: 6..=11,
};

static VARS_SOU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SOU_CHILDREN),
    value: None,
};

pub static VARS_SOU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("fflaed"),
        dictgen::InsensitiveStr::Ascii("ffled"),
        dictgen::InsensitiveStr::Ascii("lter"),
        dictgen::InsensitiveStr::Ascii("ltre"),
        dictgen::InsensitiveStr::Ascii("rd"),
        dictgen::InsensitiveStr::Ascii("rdine"),
        dictgen::InsensitiveStr::Ascii("rdines"),
        dictgen::InsensitiveStr::Ascii("ry"),
        dictgen::InsensitiveStr::Ascii("thernise"),
        dictgen::InsensitiveStr::Ascii("thernised"),
        dictgen::InsensitiveStr::Ascii("thernises"),
        dictgen::InsensitiveStr::Ascii("thernising"),
        dictgen::InsensitiveStr::Ascii("thernize"),
        dictgen::InsensitiveStr::Ascii("thernized"),
        dictgen::InsensitiveStr::Ascii("thernizes"),
        dictgen::InsensitiveStr::Ascii("thernizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SOUFFLED_11288921415541351012)],
        &[(0b00001, &ENTRY_SOUFFLED_11288921415541351012)],
        &[(0b00001, &ENTRY_SOULTER_16287779215263702830)],
        &[(0b11010, &ENTRY_SOULTER_16287779215263702830)],
        &[(0b11010, &ENTRY_SORD_16682875115764427041)],
        &[(0b11010, &ENTRY_SORDINE_13046642983492348660)],
        &[(0b11010, &ENTRY_SORDINES_17955052261708476598)],
        &[(0b11010, &ENTRY_SORY_866294547402037500)],
        &[(0b10010, &ENTRY_SOUTHERNIZE_2007900784402703927)],
        &[(0b10010, &ENTRY_SOUTHERNIZED_5166061537133315558)],
        &[(0b10010, &ENTRY_SOUTHERNIZES_17801238247060666066)],
        &[(0b10010, &ENTRY_SOUTHERNIZING_7105097135265474755)],
        &[(0b01001, &ENTRY_SOUTHERNIZE_2007900784402703927)],
        &[(0b01001, &ENTRY_SOUTHERNIZED_5166061537133315558)],
        &[(0b01001, &ENTRY_SOUTHERNIZES_17801238247060666066)],
        &[(0b01001, &ENTRY_SOUTHERNIZING_7105097135265474755)],
    ],
    range: 2..=10,
};

static VARS_SOR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SOR_CHILDREN),
    value: None,
};

pub static VARS_SOR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bitisation"),
        dictgen::InsensitiveStr::Ascii("bitisations"),
        dictgen::InsensitiveStr::Ascii("bitise"),
        dictgen::InsensitiveStr::Ascii("bitised"),
        dictgen::InsensitiveStr::Ascii("bitises"),
        dictgen::InsensitiveStr::Ascii("bitising"),
        dictgen::InsensitiveStr::Ascii("bitization"),
        dictgen::InsensitiveStr::Ascii("bitizations"),
        dictgen::InsensitiveStr::Ascii("bitize"),
        dictgen::InsensitiveStr::Ascii("bitized"),
        dictgen::InsensitiveStr::Ascii("bitizes"),
        dictgen::InsensitiveStr::Ascii("bitizing"),
        dictgen::InsensitiveStr::Ascii("d"),
        dictgen::InsensitiveStr::Ascii("dine"),
        dictgen::InsensitiveStr::Ascii("dines"),
        dictgen::InsensitiveStr::Ascii("orise"),
        dictgen::InsensitiveStr::Ascii("orised"),
        dictgen::InsensitiveStr::Ascii("orises"),
        dictgen::InsensitiveStr::Ascii("orising"),
        dictgen::InsensitiveStr::Ascii("orize"),
        dictgen::InsensitiveStr::Ascii("orized"),
        dictgen::InsensitiveStr::Ascii("orizes"),
        dictgen::InsensitiveStr::Ascii("orizing"),
        dictgen::InsensitiveStr::Ascii("y"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SORBITIZATION_3511955197103798019)],
        &[(0b10010, &ENTRY_SORBITIZATIONS_15094150133852333070)],
        &[(0b10010, &ENTRY_SORBITIZE_4953121359286386634)],
        &[(0b10010, &ENTRY_SORBITIZED_11029247990437433113)],
        &[(0b10010, &ENTRY_SORBITIZES_17239730547558440933)],
        &[(0b10010, &ENTRY_SORBITIZING_10552560528290540525)],
        &[(0b01001, &ENTRY_SORBITIZATION_3511955197103798019)],
        &[(0b01001, &ENTRY_SORBITIZATIONS_15094150133852333070)],
        &[(0b01001, &ENTRY_SORBITIZE_4953121359286386634)],
        &[(0b01001, &ENTRY_SORBITIZED_11029247990437433113)],
        &[(0b01001, &ENTRY_SORBITIZES_17239730547558440933)],
        &[(0b01001, &ENTRY_SORBITIZING_10552560528290540525)],
        &[(0b00001, &ENTRY_SORD_16682875115764427041)],
        &[(0b00001, &ENTRY_SORDINE_13046642983492348660)],
        &[(0b00001, &ENTRY_SORDINES_17955052261708476598)],
        &[(0b10010, &ENTRY_SORORIZE_10455264558591532576)],
        &[(0b10010, &ENTRY_SORORIZED_10275110518887074085)],
        &[(0b10010, &ENTRY_SORORIZES_5655621331560912625)],
        &[(0b10010, &ENTRY_SORORIZING_2971025569489318464)],
        &[(0b01001, &ENTRY_SORORIZE_10455264558591532576)],
        &[(0b01001, &ENTRY_SORORIZED_10275110518887074085)],
        &[(0b01001, &ENTRY_SORORIZES_5655621331560912625)],
        &[(0b01001, &ENTRY_SORORIZING_2971025569489318464)],
        &[(0b00001, &ENTRY_SORY_866294547402037500)],
    ],
    range: 1..=11,
};

static VARS_SON_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SON_CHILDREN),
    value: None,
};

pub static VARS_SON_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("antised"),
        dictgen::InsensitiveStr::Ascii("antiseds"),
        dictgen::InsensitiveStr::Ascii("antized"),
        dictgen::InsensitiveStr::Ascii("antizeds"),
        dictgen::InsensitiveStr::Ascii("netisation"),
        dictgen::InsensitiveStr::Ascii("netise"),
        dictgen::InsensitiveStr::Ascii("netised"),
        dictgen::InsensitiveStr::Ascii("netises"),
        dictgen::InsensitiveStr::Ascii("netising"),
        dictgen::InsensitiveStr::Ascii("netization"),
        dictgen::InsensitiveStr::Ascii("netize"),
        dictgen::InsensitiveStr::Ascii("netized"),
        dictgen::InsensitiveStr::Ascii("netizes"),
        dictgen::InsensitiveStr::Ascii("netizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SONANTIZED_7465742307673093545)],
        &[(0b10010, &ENTRY_SONANTIZEDS_5806347613534212865)],
        &[(0b01001, &ENTRY_SONANTIZED_7465742307673093545)],
        &[(0b01001, &ENTRY_SONANTIZEDS_5806347613534212865)],
        &[(0b10010, &ENTRY_SONNETIZATION_17811800137071473898)],
        &[(0b10010, &ENTRY_SONNETIZE_3336641041466286630)],
        &[(0b10010, &ENTRY_SONNETIZED_16371695347786264769)],
        &[(0b10010, &ENTRY_SONNETIZES_6585967879025542142)],
        &[(0b10010, &ENTRY_SONNETIZING_2853568487817375411)],
        &[(0b01001, &ENTRY_SONNETIZATION_17811800137071473898)],
        &[(0b01001, &ENTRY_SONNETIZE_3336641041466286630)],
        &[(0b01001, &ENTRY_SONNETIZED_16371695347786264769)],
        &[(0b01001, &ENTRY_SONNETIZES_6585967879025542142)],
        &[(0b01001, &ENTRY_SONNETIZING_2853568487817375411)],
    ],
    range: 6..=10,
};

static VARS_SOM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SOM_CHILDREN),
    value: None,
};

pub static VARS_SOM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aesthesia"),
        dictgen::InsensitiveStr::Ascii("aesthesis"),
        dictgen::InsensitiveStr::Ascii("ber"),
        dictgen::InsensitiveStr::Ascii("berer"),
        dictgen::InsensitiveStr::Ascii("berest"),
        dictgen::InsensitiveStr::Ascii("berish"),
        dictgen::InsensitiveStr::Ascii("berly"),
        dictgen::InsensitiveStr::Ascii("berness"),
        dictgen::InsensitiveStr::Ascii("bernesses"),
        dictgen::InsensitiveStr::Ascii("breish"),
        dictgen::InsensitiveStr::Ascii("esthesia"),
        dictgen::InsensitiveStr::Ascii("esthesis"),
        dictgen::InsensitiveStr::Ascii("niloquise"),
        dictgen::InsensitiveStr::Ascii("niloquised"),
        dictgen::InsensitiveStr::Ascii("niloquises"),
        dictgen::InsensitiveStr::Ascii("niloquising"),
        dictgen::InsensitiveStr::Ascii("niloquize"),
        dictgen::InsensitiveStr::Ascii("niloquized"),
        dictgen::InsensitiveStr::Ascii("niloquizes"),
        dictgen::InsensitiveStr::Ascii("niloquizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SOMESTHESIA_11184895325270057547)],
        &[(0b11010, &ENTRY_SOMESTHESIS_3205445442940535664)],
        &[(0b00001, &ENTRY_SOMBER_5140950589921348685)],
        &[(0b00001, &ENTRY_SOMBERER_17580079165913630117)],
        &[(0b00001, &ENTRY_SOMBEREST_3884649068642437270)],
        &[(0b00001, &ENTRY_SOMBERISH_9751798617429837974)],
        &[(0b00001, &ENTRY_SOMBERLY_14824241355422186369)],
        &[(0b00001, &ENTRY_SOMBERNESS_3289235689799463770)],
        &[(0b00001, &ENTRY_SOMBERNESSES_5970684106925544470)],
        &[(0b11010, &ENTRY_SOMBERISH_9751798617429837974)],
        &[(0b00001, &ENTRY_SOMESTHESIA_11184895325270057547)],
        &[(0b00001, &ENTRY_SOMESTHESIS_3205445442940535664)],
        &[(0b10010, &ENTRY_SOMNILOQUIZE_14989120006007292353)],
        &[(0b10010, &ENTRY_SOMNILOQUIZED_11728587916951539904)],
        &[(0b10010, &ENTRY_SOMNILOQUIZES_7318100064004324381)],
        &[(0b10010, &ENTRY_SOMNILOQUIZING_13842334488833594229)],
        &[(0b01001, &ENTRY_SOMNILOQUIZE_14989120006007292353)],
        &[(0b01001, &ENTRY_SOMNILOQUIZED_11728587916951539904)],
        &[(0b01001, &ENTRY_SOMNILOQUIZES_7318100064004324381)],
        &[(0b01001, &ENTRY_SOMNILOQUIZING_13842334488833594229)],
    ],
    range: 3..=11,
};

static VARS_SOL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SOL_CHILDREN),
    value: None,
};

static VARS_SOL_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_SOLA_NODE),
    None,
    None,
    Some(&VARS_SOLD_NODE),
    Some(&VARS_SOLE_NODE),
    None,
    None,
    None,
    Some(&VARS_SOLI_NODE),
    None,
    None,
    None,
    Some(&VARS_SOLM_NODE),
    None,
    Some(&VARS_SOLO_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SOLU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_SOLU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SOLU_CHILDREN),
    value: None,
};

pub static VARS_SOLU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bilisation"),
        dictgen::InsensitiveStr::Ascii("bilisations"),
        dictgen::InsensitiveStr::Ascii("bilise"),
        dictgen::InsensitiveStr::Ascii("bilised"),
        dictgen::InsensitiveStr::Ascii("bilises"),
        dictgen::InsensitiveStr::Ascii("bilising"),
        dictgen::InsensitiveStr::Ascii("bilization"),
        dictgen::InsensitiveStr::Ascii("bilizations"),
        dictgen::InsensitiveStr::Ascii("bilize"),
        dictgen::InsensitiveStr::Ascii("bilized"),
        dictgen::InsensitiveStr::Ascii("bilizes"),
        dictgen::InsensitiveStr::Ascii("bilizing"),
        dictgen::InsensitiveStr::Ascii("tise"),
        dictgen::InsensitiveStr::Ascii("tiser"),
        dictgen::InsensitiveStr::Ascii("tisers"),
        dictgen::InsensitiveStr::Ascii("tises"),
        dictgen::InsensitiveStr::Ascii("tize"),
        dictgen::InsensitiveStr::Ascii("tizer"),
        dictgen::InsensitiveStr::Ascii("tizers"),
        dictgen::InsensitiveStr::Ascii("tizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SOLUBILIZATION_11329836872303618229)],
        &[(0b10010, &ENTRY_SOLUBILIZATIONS_4369156796378163009)],
        &[(0b10010, &ENTRY_SOLUBILIZE_1662872893301039501)],
        &[(0b10010, &ENTRY_SOLUBILIZED_6258117609347074455)],
        &[(0b10010, &ENTRY_SOLUBILIZES_13987666377462264730)],
        &[(0b10010, &ENTRY_SOLUBILIZING_10490972660552675683)],
        &[(0b01001, &ENTRY_SOLUBILIZATION_11329836872303618229)],
        &[(0b01001, &ENTRY_SOLUBILIZATIONS_4369156796378163009)],
        &[(0b01001, &ENTRY_SOLUBILIZE_1662872893301039501)],
        &[(0b01001, &ENTRY_SOLUBILIZED_6258117609347074455)],
        &[(0b01001, &ENTRY_SOLUBILIZES_13987666377462264730)],
        &[(0b01001, &ENTRY_SOLUBILIZING_10490972660552675683)],
        &[(0b10010, &ENTRY_SOLUTIZE_5438116954578400359)],
        &[(0b10010, &ENTRY_SOLUTIZER_6497015698400010769)],
        &[(0b10010, &ENTRY_SOLUTIZERS_16598006390430358557)],
        &[(0b10010, &ENTRY_SOLUTIZES_16990892992718942912)],
        &[(0b01001, &ENTRY_SOLUTIZE_5438116954578400359)],
        &[(0b01001, &ENTRY_SOLUTIZER_6497015698400010769)],
        &[(0b01001, &ENTRY_SOLUTIZERS_16598006390430358557)],
        &[(0b01001, &ENTRY_SOLUTIZES_16990892992718942912)],
    ],
    range: 4..=11,
};

static VARS_SOLO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SOLO_CHILDREN),
    value: None,
};

pub static VARS_SOLO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("nisation"),
        dictgen::InsensitiveStr::Ascii("nisations"),
        dictgen::InsensitiveStr::Ascii("nization"),
        dictgen::InsensitiveStr::Ascii("nizations"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SOLONIZATION_11249232042663309133)],
        &[(0b10010, &ENTRY_SOLONIZATIONS_4433313152747643816)],
        &[(0b01001, &ENTRY_SOLONIZATION_11249232042663309133)],
        &[(0b01001, &ENTRY_SOLONIZATIONS_4433313152747643816)],
    ],
    range: 8..=9,
};

static VARS_SOLM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SOLM_CHILDREN),
    value: None,
};

pub static VARS_SOLM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("isation"),
        dictgen::InsensitiveStr::Ascii("isations"),
        dictgen::InsensitiveStr::Ascii("ization"),
        dictgen::InsensitiveStr::Ascii("izations"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SOLMIZATION_8566929989308185368)],
        &[(0b10010, &ENTRY_SOLMIZATIONS_13280876893352435221)],
        &[(0b01001, &ENTRY_SOLMIZATION_8566929989308185368)],
        &[(0b01001, &ENTRY_SOLMIZATIONS_13280876893352435221)],
    ],
    range: 7..=8,
};

static VARS_SOLI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SOLI_CHILDREN),
    value: None,
};

pub static VARS_SOLI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("loquisation"),
        dictgen::InsensitiveStr::Ascii("loquise"),
        dictgen::InsensitiveStr::Ascii("loquised"),
        dictgen::InsensitiveStr::Ascii("loquiser"),
        dictgen::InsensitiveStr::Ascii("loquisers"),
        dictgen::InsensitiveStr::Ascii("loquises"),
        dictgen::InsensitiveStr::Ascii("loquising"),
        dictgen::InsensitiveStr::Ascii("loquisingly"),
        dictgen::InsensitiveStr::Ascii("loquisings"),
        dictgen::InsensitiveStr::Ascii("loquization"),
        dictgen::InsensitiveStr::Ascii("loquize"),
        dictgen::InsensitiveStr::Ascii("loquized"),
        dictgen::InsensitiveStr::Ascii("loquizer"),
        dictgen::InsensitiveStr::Ascii("loquizers"),
        dictgen::InsensitiveStr::Ascii("loquizes"),
        dictgen::InsensitiveStr::Ascii("loquizing"),
        dictgen::InsensitiveStr::Ascii("loquizingly"),
        dictgen::InsensitiveStr::Ascii("loquizings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SOLILOQUIZATION_269312513960661785)],
        &[(0b10010, &ENTRY_SOLILOQUIZE_12226193284594737636)],
        &[(0b10010, &ENTRY_SOLILOQUIZED_17939687163528373325)],
        &[(0b10010, &ENTRY_SOLILOQUIZER_5490319459061869143)],
        &[(0b10010, &ENTRY_SOLILOQUIZERS_1912861598555034277)],
        &[(0b10010, &ENTRY_SOLILOQUIZES_9261685774539508340)],
        &[(0b10010, &ENTRY_SOLILOQUIZING_15896904890682292482)],
        &[(0b10010, &ENTRY_SOLILOQUIZINGLY_2770653047985095587)],
        &[(0b10010, &ENTRY_SOLILOQUIZINGS_16013560258108957465)],
        &[(0b01001, &ENTRY_SOLILOQUIZATION_269312513960661785)],
        &[(0b01001, &ENTRY_SOLILOQUIZE_12226193284594737636)],
        &[(0b01001, &ENTRY_SOLILOQUIZED_17939687163528373325)],
        &[(0b01001, &ENTRY_SOLILOQUIZER_5490319459061869143)],
        &[(0b01001, &ENTRY_SOLILOQUIZERS_1912861598555034277)],
        &[(0b01001, &ENTRY_SOLILOQUIZES_9261685774539508340)],
        &[(0b01001, &ENTRY_SOLILOQUIZING_15896904890682292482)],
        &[(0b01001, &ENTRY_SOLILOQUIZINGLY_2770653047985095587)],
        &[(0b01001, &ENTRY_SOLILOQUIZINGS_16013560258108957465)],
    ],
    range: 7..=11,
};

static VARS_SOLE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SOLE_CHILDREN),
    value: None,
};

pub static VARS_SOLE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cise"),
        dictgen::InsensitiveStr::Ascii("cised"),
        dictgen::InsensitiveStr::Ascii("cises"),
        dictgen::InsensitiveStr::Ascii("cising"),
        dictgen::InsensitiveStr::Ascii("cize"),
        dictgen::InsensitiveStr::Ascii("cized"),
        dictgen::InsensitiveStr::Ascii("cizes"),
        dictgen::InsensitiveStr::Ascii("cizing"),
        dictgen::InsensitiveStr::Ascii("mnisation"),
        dictgen::InsensitiveStr::Ascii("mnisations"),
        dictgen::InsensitiveStr::Ascii("mnise"),
        dictgen::InsensitiveStr::Ascii("mnised"),
        dictgen::InsensitiveStr::Ascii("mniser"),
        dictgen::InsensitiveStr::Ascii("mnisers"),
        dictgen::InsensitiveStr::Ascii("mnises"),
        dictgen::InsensitiveStr::Ascii("mnising"),
        dictgen::InsensitiveStr::Ascii("mnization"),
        dictgen::InsensitiveStr::Ascii("mnizations"),
        dictgen::InsensitiveStr::Ascii("mnize"),
        dictgen::InsensitiveStr::Ascii("mnized"),
        dictgen::InsensitiveStr::Ascii("mnizer"),
        dictgen::InsensitiveStr::Ascii("mnizers"),
        dictgen::InsensitiveStr::Ascii("mnizes"),
        dictgen::InsensitiveStr::Ascii("mnizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SOLECIZE_4990335805125403138)],
        &[(0b10010, &ENTRY_SOLECIZED_15911538990572619815)],
        &[(0b10010, &ENTRY_SOLECIZES_15788433464347659056)],
        &[(0b10010, &ENTRY_SOLECIZING_12747426853182310591)],
        &[(0b01001, &ENTRY_SOLECIZE_4990335805125403138)],
        &[(0b01001, &ENTRY_SOLECIZED_15911538990572619815)],
        &[(0b01001, &ENTRY_SOLECIZES_15788433464347659056)],
        &[(0b01001, &ENTRY_SOLECIZING_12747426853182310591)],
        &[(0b10010, &ENTRY_SOLEMNIZATION_16787130687056363702)],
        &[(0b10010, &ENTRY_SOLEMNIZATIONS_6129091422641859142)],
        &[(0b10010, &ENTRY_SOLEMNIZE_15796782944155668670)],
        &[(0b10010, &ENTRY_SOLEMNIZED_2852788835971325204)],
        &[(0b10010, &ENTRY_SOLEMNIZER_5978295607112033996)],
        &[(0b10010, &ENTRY_SOLEMNIZERS_2397316897252319748)],
        &[(0b10010, &ENTRY_SOLEMNIZES_17312526288446264851)],
        &[(0b10010, &ENTRY_SOLEMNIZING_1873698687937846065)],
        &[(0b01001, &ENTRY_SOLEMNIZATION_16787130687056363702)],
        &[(0b01001, &ENTRY_SOLEMNIZATIONS_6129091422641859142)],
        &[(0b01001, &ENTRY_SOLEMNIZE_15796782944155668670)],
        &[(0b01001, &ENTRY_SOLEMNIZED_2852788835971325204)],
        &[(0b01001, &ENTRY_SOLEMNIZER_5978295607112033996)],
        &[(0b01001, &ENTRY_SOLEMNIZERS_2397316897252319748)],
        &[(0b01001, &ENTRY_SOLEMNIZES_17312526288446264851)],
        &[(0b01001, &ENTRY_SOLEMNIZING_1873698687937846065)],
    ],
    range: 4..=10,
};

static VARS_SOLD_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SOLD_CHILDREN),
    value: None,
};

pub static VARS_SOLD_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ierise"),
        dictgen::InsensitiveStr::Ascii("ierises"),
        dictgen::InsensitiveStr::Ascii("ierize"),
        dictgen::InsensitiveStr::Ascii("ierizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SOLDIERIZE_16604236556396943965)],
        &[(0b10010, &ENTRY_SOLDIERIZES_11157601016192388331)],
        &[(0b01001, &ENTRY_SOLDIERIZE_16604236556396943965)],
        &[(0b01001, &ENTRY_SOLDIERIZES_11157601016192388331)],
    ],
    range: 6..=7,
};

static VARS_SOLA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SOLA_CHILDREN),
    value: None,
};

pub static VARS_SOLA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("risation"),
        dictgen::InsensitiveStr::Ascii("risations"),
        dictgen::InsensitiveStr::Ascii("rise"),
        dictgen::InsensitiveStr::Ascii("rised"),
        dictgen::InsensitiveStr::Ascii("rises"),
        dictgen::InsensitiveStr::Ascii("rising"),
        dictgen::InsensitiveStr::Ascii("rization"),
        dictgen::InsensitiveStr::Ascii("rizations"),
        dictgen::InsensitiveStr::Ascii("rize"),
        dictgen::InsensitiveStr::Ascii("rized"),
        dictgen::InsensitiveStr::Ascii("rizes"),
        dictgen::InsensitiveStr::Ascii("rizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SOLARIZATION_1192428962792189832)],
        &[(0b10010, &ENTRY_SOLARIZATIONS_4722132275104202763)],
        &[(0b10010, &ENTRY_SOLARIZE_18258216759051483358)],
        &[(0b10010, &ENTRY_SOLARIZED_5808975743485239818)],
        &[(0b10010, &ENTRY_SOLARIZES_5534323195052354549)],
        &[(0b10010, &ENTRY_SOLARIZING_10862859858263346398)],
        &[(0b01001, &ENTRY_SOLARIZATION_1192428962792189832)],
        &[(0b01001, &ENTRY_SOLARIZATIONS_4722132275104202763)],
        &[(0b01001, &ENTRY_SOLARIZE_18258216759051483358)],
        &[(0b01001, &ENTRY_SOLARIZED_5808975743485239818)],
        &[(0b01001, &ENTRY_SOLARIZES_5534323195052354549)],
        &[(0b01001, &ENTRY_SOLARIZING_10862859858263346398)],
    ],
    range: 4..=9,
};

static VARS_SOE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SOE_CHILDREN),
    value: Some(&[(0b11010, &ENTRY_SE_15361672265999879694)]),
};

pub static VARS_SOE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[],
    values: &[],
    range: 0..=0,
};

static VARS_SOD_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SOD_CHILDREN),
    value: None,
};

pub static VARS_SOD_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("omise"),
        dictgen::InsensitiveStr::Ascii("omised"),
        dictgen::InsensitiveStr::Ascii("omises"),
        dictgen::InsensitiveStr::Ascii("omising"),
        dictgen::InsensitiveStr::Ascii("omize"),
        dictgen::InsensitiveStr::Ascii("omized"),
        dictgen::InsensitiveStr::Ascii("omizes"),
        dictgen::InsensitiveStr::Ascii("omizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SODOMIZE_6206294818202684654)],
        &[(0b10010, &ENTRY_SODOMIZED_12622748833680108292)],
        &[(0b10010, &ENTRY_SODOMIZES_743917781797229302)],
        &[(0b10010, &ENTRY_SODOMIZING_14921360499846607434)],
        &[(0b01001, &ENTRY_SODOMIZE_6206294818202684654)],
        &[(0b01001, &ENTRY_SODOMIZED_12622748833680108292)],
        &[(0b01001, &ENTRY_SODOMIZES_743917781797229302)],
        &[(0b01001, &ENTRY_SODOMIZING_14921360499846607434)],
    ],
    range: 5..=7,
};

static VARS_SOC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SOC_CHILDREN),
    value: None,
};

pub static VARS_SOC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ialisation"),
        dictgen::InsensitiveStr::Ascii("ialisations"),
        dictgen::InsensitiveStr::Ascii("ialise"),
        dictgen::InsensitiveStr::Ascii("ialised"),
        dictgen::InsensitiveStr::Ascii("ialiser"),
        dictgen::InsensitiveStr::Ascii("ialises"),
        dictgen::InsensitiveStr::Ascii("ialising"),
        dictgen::InsensitiveStr::Ascii("ialization"),
        dictgen::InsensitiveStr::Ascii("ializations"),
        dictgen::InsensitiveStr::Ascii("ialize"),
        dictgen::InsensitiveStr::Ascii("ialized"),
        dictgen::InsensitiveStr::Ascii("ializer"),
        dictgen::InsensitiveStr::Ascii("ializes"),
        dictgen::InsensitiveStr::Ascii("ializing"),
        dictgen::InsensitiveStr::Ascii("kdologising"),
        dictgen::InsensitiveStr::Ascii("kdologizing"),
        dictgen::InsensitiveStr::Ascii("ratise"),
        dictgen::InsensitiveStr::Ascii("ratised"),
        dictgen::InsensitiveStr::Ascii("ratises"),
        dictgen::InsensitiveStr::Ascii("ratising"),
        dictgen::InsensitiveStr::Ascii("ratize"),
        dictgen::InsensitiveStr::Ascii("ratized"),
        dictgen::InsensitiveStr::Ascii("ratizes"),
        dictgen::InsensitiveStr::Ascii("ratizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SOCIALIZATION_2084413938110848032)],
        &[(0b10010, &ENTRY_SOCIALIZATIONS_10749899080870387486)],
        &[(0b10010, &ENTRY_SOCIALIZE_6985846630440818655)],
        &[(0b10010, &ENTRY_SOCIALIZED_11336946122134321158)],
        &[(0b10010, &ENTRY_SOCIALIZER_15740033054008322482)],
        &[(0b10010, &ENTRY_SOCIALIZES_1566074373781161623)],
        &[(0b10010, &ENTRY_SOCIALIZING_505177211807278288)],
        &[(0b01001, &ENTRY_SOCIALIZATION_2084413938110848032)],
        &[(0b01001, &ENTRY_SOCIALIZATIONS_10749899080870387486)],
        &[(0b01001, &ENTRY_SOCIALIZE_6985846630440818655)],
        &[(0b01001, &ENTRY_SOCIALIZED_11336946122134321158)],
        &[(0b01001, &ENTRY_SOCIALIZER_15740033054008322482)],
        &[(0b01001, &ENTRY_SOCIALIZES_1566074373781161623)],
        &[(0b01001, &ENTRY_SOCIALIZING_505177211807278288)],
        &[(0b10010, &ENTRY_SOCKDOLOGIZING_16991441468659816755)],
        &[(0b01001, &ENTRY_SOCKDOLOGIZING_16991441468659816755)],
        &[(0b10010, &ENTRY_SOCRATIZE_14310113146869106182)],
        &[(0b10010, &ENTRY_SOCRATIZED_9270084545030336528)],
        &[(0b10010, &ENTRY_SOCRATIZES_14641664105677151925)],
        &[(0b10010, &ENTRY_SOCRATIZING_1982796648064876142)],
        &[(0b01001, &ENTRY_SOCRATIZE_14310113146869106182)],
        &[(0b01001, &ENTRY_SOCRATIZED_9270084545030336528)],
        &[(0b01001, &ENTRY_SOCRATIZES_14641664105677151925)],
        &[(0b01001, &ENTRY_SOCRATIZING_1982796648064876142)],
    ],
    range: 6..=11,
};

static VARS_SOB_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SOB_CHILDREN),
    value: None,
};

pub static VARS_SOB_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("erise"),
        dictgen::InsensitiveStr::Ascii("erised"),
        dictgen::InsensitiveStr::Ascii("erises"),
        dictgen::InsensitiveStr::Ascii("erising"),
        dictgen::InsensitiveStr::Ascii("erize"),
        dictgen::InsensitiveStr::Ascii("erized"),
        dictgen::InsensitiveStr::Ascii("erizes"),
        dictgen::InsensitiveStr::Ascii("erizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SOBERIZE_13532853448534221620)],
        &[(0b10010, &ENTRY_SOBERIZED_7343261452157716449)],
        &[(0b10010, &ENTRY_SOBERIZES_6877701061854218485)],
        &[(0b10010, &ENTRY_SOBERIZING_10684751466686644496)],
        &[(0b01001, &ENTRY_SOBERIZE_13532853448534221620)],
        &[(0b01001, &ENTRY_SOBERIZED_7343261452157716449)],
        &[(0b01001, &ENTRY_SOBERIZES_6877701061854218485)],
        &[(0b01001, &ENTRY_SOBERIZING_10684751466686644496)],
    ],
    range: 5..=7,
};

static VARS_SN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SN_CHILDREN),
    value: None,
};

pub static VARS_SN_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("iveled"),
        dictgen::InsensitiveStr::Ascii("iveler"),
        dictgen::InsensitiveStr::Ascii("ivelers"),
        dictgen::InsensitiveStr::Ascii("iveling"),
        dictgen::InsensitiveStr::Ascii("ivelings"),
        dictgen::InsensitiveStr::Ascii("ivelled"),
        dictgen::InsensitiveStr::Ascii("iveller"),
        dictgen::InsensitiveStr::Ascii("ivellers"),
        dictgen::InsensitiveStr::Ascii("ivelling"),
        dictgen::InsensitiveStr::Ascii("ivellings"),
        dictgen::InsensitiveStr::Ascii("obsniveling"),
        dictgen::InsensitiveStr::Ascii("obsnivelling"),
        dictgen::InsensitiveStr::Ascii("orkeled"),
        dictgen::InsensitiveStr::Ascii("orkeling"),
        dictgen::InsensitiveStr::Ascii("orkelled"),
        dictgen::InsensitiveStr::Ascii("orkelling"),
        dictgen::InsensitiveStr::Ascii("owplough"),
        dictgen::InsensitiveStr::Ascii("owploughs"),
        dictgen::InsensitiveStr::Ascii("owplow"),
        dictgen::InsensitiveStr::Ascii("owplows"),
        dictgen::InsensitiveStr::Ascii("owshed"),
        dictgen::InsensitiveStr::Ascii("owshoed"),
        dictgen::InsensitiveStr::Ascii("uffcolored"),
        dictgen::InsensitiveStr::Ascii("uffcoloured"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SNIVELED_18043727065802009410)],
        &[(0b00001, &ENTRY_SNIVELER_2280951551750996939)],
        &[(0b00001, &ENTRY_SNIVELERS_1542130229737259691)],
        &[(0b00001, &ENTRY_SNIVELING_7895796690459397538)],
        &[(0b00001, &ENTRY_SNIVELINGS_9742658510844280475)],
        &[(0b11010, &ENTRY_SNIVELED_18043727065802009410)],
        &[(0b11010, &ENTRY_SNIVELER_2280951551750996939)],
        &[(0b11010, &ENTRY_SNIVELERS_1542130229737259691)],
        &[(0b11010, &ENTRY_SNIVELING_7895796690459397538)],
        &[(0b11010, &ENTRY_SNIVELINGS_9742658510844280475)],
        &[(0b00001, &ENTRY_SNOBSNIVELING_2460193893793738982)],
        &[(0b11010, &ENTRY_SNOBSNIVELING_2460193893793738982)],
        &[(0b01001, &ENTRY_SNORKELED_17424014433959603672)],
        &[(0b01001, &ENTRY_SNORKELING_16143785804725093743)],
        &[(0b11010, &ENTRY_SNORKELED_17424014433959603672)],
        &[(0b11010, &ENTRY_SNORKELING_16143785804725093743)],
        &[(0b11010, &ENTRY_SNOWPLOW_3516237879610950869)],
        &[(0b11010, &ENTRY_SNOWPLOWS_1272088169272096167)],
        &[(0b01001, &ENTRY_SNOWPLOW_3516237879610950869)],
        &[(0b01001, &ENTRY_SNOWPLOWS_1272088169272096167)],
        &[(0b00001, &ENTRY_SNOWSHED_9651694831654123091)],
        &[(0b11010, &ENTRY_SNOWSHED_9651694831654123091)],
        &[(0b00001, &ENTRY_SNUFFCOLORED_10869337707924680144)],
        &[(0b11010, &ENTRY_SNUFFCOLORED_10869337707924680144)],
    ],
    range: 6..=12,
};

static VARS_SM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SM_CHILDREN),
    value: None,
};

pub static VARS_SM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("idge"),
        dictgen::InsensitiveStr::Ascii("idges"),
        dictgen::InsensitiveStr::Ascii("older"),
        dictgen::InsensitiveStr::Ascii("oldered"),
        dictgen::InsensitiveStr::Ascii("oldering"),
        dictgen::InsensitiveStr::Ascii("olders"),
    ],
    values: &[
        &[(0b01001, &ENTRY_SMIDGEN_2401448801521207321)],
        &[(0b01001, &ENTRY_SMIDGENS_5145607016666105466)],
        &[(0b01001, &ENTRY_SMOLDER_18276687156827940484)],
        &[(0b01001, &ENTRY_SMOLDERED_12136966478992754787)],
        &[(0b01001, &ENTRY_SMOLDERING_17971483108204682038)],
        &[(0b01001, &ENTRY_SMOLDERS_16317626305242093646)],
    ],
    range: 4..=8,
};

static VARS_SL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SL_CHILDREN),
    value: None,
};

pub static VARS_SL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ae"),
        dictgen::InsensitiveStr::Ascii("avicise"),
        dictgen::InsensitiveStr::Ascii("avicises"),
        dictgen::InsensitiveStr::Ascii("avicize"),
        dictgen::InsensitiveStr::Ascii("avicizes"),
        dictgen::InsensitiveStr::Ascii("avisation"),
        dictgen::InsensitiveStr::Ascii("avisations"),
        dictgen::InsensitiveStr::Ascii("avise"),
        dictgen::InsensitiveStr::Ascii("avises"),
        dictgen::InsensitiveStr::Ascii("avization"),
        dictgen::InsensitiveStr::Ascii("avizations"),
        dictgen::InsensitiveStr::Ascii("avize"),
        dictgen::InsensitiveStr::Ascii("avizes"),
        dictgen::InsensitiveStr::Ascii("avonicise"),
        dictgen::InsensitiveStr::Ascii("avonicised"),
        dictgen::InsensitiveStr::Ascii("avonicises"),
        dictgen::InsensitiveStr::Ascii("avonicising"),
        dictgen::InsensitiveStr::Ascii("avonicize"),
        dictgen::InsensitiveStr::Ascii("avonicized"),
        dictgen::InsensitiveStr::Ascii("avonicizes"),
        dictgen::InsensitiveStr::Ascii("avonicizing"),
        dictgen::InsensitiveStr::Ascii("avonise"),
        dictgen::InsensitiveStr::Ascii("avonised"),
        dictgen::InsensitiveStr::Ascii("avonises"),
        dictgen::InsensitiveStr::Ascii("avonising"),
        dictgen::InsensitiveStr::Ascii("avonize"),
        dictgen::InsensitiveStr::Ascii("avonized"),
        dictgen::InsensitiveStr::Ascii("avonizes"),
        dictgen::InsensitiveStr::Ascii("avonizing"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("enderise"),
        dictgen::InsensitiveStr::Ascii("enderised"),
        dictgen::InsensitiveStr::Ascii("enderises"),
        dictgen::InsensitiveStr::Ascii("enderising"),
        dictgen::InsensitiveStr::Ascii("enderize"),
        dictgen::InsensitiveStr::Ascii("enderized"),
        dictgen::InsensitiveStr::Ascii("enderizes"),
        dictgen::InsensitiveStr::Ascii("enderizing"),
        dictgen::InsensitiveStr::Ascii("ier"),
        dictgen::InsensitiveStr::Ascii("iest"),
        dictgen::InsensitiveStr::Ascii("ily"),
        dictgen::InsensitiveStr::Ascii("oganise"),
        dictgen::InsensitiveStr::Ascii("oganised"),
        dictgen::InsensitiveStr::Ascii("oganises"),
        dictgen::InsensitiveStr::Ascii("oganising"),
        dictgen::InsensitiveStr::Ascii("oganisings"),
        dictgen::InsensitiveStr::Ascii("oganize"),
        dictgen::InsensitiveStr::Ascii("oganized"),
        dictgen::InsensitiveStr::Ascii("oganizes"),
        dictgen::InsensitiveStr::Ascii("oganizing"),
        dictgen::InsensitiveStr::Ascii("oganizings"),
        dictgen::InsensitiveStr::Ascii("uggardise"),
        dictgen::InsensitiveStr::Ascii("uggardised"),
        dictgen::InsensitiveStr::Ascii("uggardises"),
        dictgen::InsensitiveStr::Ascii("uggardising"),
        dictgen::InsensitiveStr::Ascii("uggardize"),
        dictgen::InsensitiveStr::Ascii("uggardized"),
        dictgen::InsensitiveStr::Ascii("uggardizes"),
        dictgen::InsensitiveStr::Ascii("uggardizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SLE_604254537387974736)],
        &[(0b10010, &ENTRY_SLAVICIZE_9761827906822368262)],
        &[(0b10010, &ENTRY_SLAVICIZES_4846190454350142805)],
        &[(0b01001, &ENTRY_SLAVICIZE_9761827906822368262)],
        &[(0b01001, &ENTRY_SLAVICIZES_4846190454350142805)],
        &[(0b10010, &ENTRY_SLAVIZATION_13156747122292743639)],
        &[(0b10010, &ENTRY_SLAVIZATIONS_7586698825967104620)],
        &[(0b10010, &ENTRY_SLAVIZE_12144031893570739805)],
        &[(0b10010, &ENTRY_SLAVIZES_13267642890664123364)],
        &[(0b01001, &ENTRY_SLAVIZATION_13156747122292743639)],
        &[(0b01001, &ENTRY_SLAVIZATIONS_7586698825967104620)],
        &[(0b01001, &ENTRY_SLAVIZE_12144031893570739805)],
        &[(0b01001, &ENTRY_SLAVIZES_13267642890664123364)],
        &[(0b10010, &ENTRY_SLAVONICIZE_7075894969271900254)],
        &[(0b10010, &ENTRY_SLAVONICIZED_4556769722338287574)],
        &[(0b10010, &ENTRY_SLAVONICIZES_14342428999925133169)],
        &[(0b10010, &ENTRY_SLAVONICIZING_9470034451915609982)],
        &[(0b01001, &ENTRY_SLAVONICIZE_7075894969271900254)],
        &[(0b01001, &ENTRY_SLAVONICIZED_4556769722338287574)],
        &[(0b01001, &ENTRY_SLAVONICIZES_14342428999925133169)],
        &[(0b01001, &ENTRY_SLAVONICIZING_9470034451915609982)],
        &[(0b10010, &ENTRY_SLAVONIZE_10938982615068583928)],
        &[(0b10010, &ENTRY_SLAVONIZED_5503323155898817895)],
        &[(0b10010, &ENTRY_SLAVONIZES_1966145414926838006)],
        &[(0b10010, &ENTRY_SLAVONIZING_13559715578718041723)],
        &[(0b01001, &ENTRY_SLAVONIZE_10938982615068583928)],
        &[(0b01001, &ENTRY_SLAVONIZED_5503323155898817895)],
        &[(0b01001, &ENTRY_SLAVONIZES_1966145414926838006)],
        &[(0b01001, &ENTRY_SLAVONIZING_13559715578718041723)],
        &[(0b00001, &ENTRY_SLE_604254537387974736)],
        &[(0b10010, &ENTRY_SLENDERIZE_8515172316335563483)],
        &[(0b10010, &ENTRY_SLENDERIZED_7959376560880260414)],
        &[(0b10010, &ENTRY_SLENDERIZES_16779186498929500242)],
        &[(0b10010, &ENTRY_SLENDERIZING_13145961426039938518)],
        &[(0b01001, &ENTRY_SLENDERIZE_8515172316335563483)],
        &[(0b01001, &ENTRY_SLENDERIZED_7959376560880260414)],
        &[(0b01001, &ENTRY_SLENDERIZES_16779186498929500242)],
        &[(0b01001, &ENTRY_SLENDERIZING_13145961426039938518)],
        &[(0b00001, &ENTRY_SLIER_17739050457284539156)],
        &[(0b00001, &ENTRY_SLIEST_8783540132102900417)],
        &[(0b10011, &ENTRY_SLYLY_3141561617868439191)],
        &[(0b10010, &ENTRY_SLOGANIZE_5861449365002655564)],
        &[(0b10010, &ENTRY_SLOGANIZED_17548782227632388322)],
        &[(0b10010, &ENTRY_SLOGANIZES_2095570969989848762)],
        &[(0b10010, &ENTRY_SLOGANIZING_5351599027342186318)],
        &[(0b10010, &ENTRY_SLOGANIZINGS_8139231964165892944)],
        &[(0b01001, &ENTRY_SLOGANIZE_5861449365002655564)],
        &[(0b01001, &ENTRY_SLOGANIZED_17548782227632388322)],
        &[(0b01001, &ENTRY_SLOGANIZES_2095570969989848762)],
        &[(0b01001, &ENTRY_SLOGANIZING_5351599027342186318)],
        &[(0b01001, &ENTRY_SLOGANIZINGS_8139231964165892944)],
        &[(0b10010, &ENTRY_SLUGGARDIZE_15179917084453478031)],
        &[(0b10010, &ENTRY_SLUGGARDIZED_7217161359617146286)],
        &[(0b10010, &ENTRY_SLUGGARDIZES_2193421694271241177)],
        &[(0b10010, &ENTRY_SLUGGARDIZING_3263004984707806773)],
        &[(0b01001, &ENTRY_SLUGGARDIZE_15179917084453478031)],
        &[(0b01001, &ENTRY_SLUGGARDIZED_7217161359617146286)],
        &[(0b01001, &ENTRY_SLUGGARDIZES_2193421694271241177)],
        &[(0b01001, &ENTRY_SLUGGARDIZING_3263004984707806773)],
    ],
    range: 1..=11,
};

static VARS_SK_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SK_CHILDREN),
    value: None,
};

pub static VARS_SK_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eer"),
        dictgen::InsensitiveStr::Ascii("eletonisation"),
        dictgen::InsensitiveStr::Ascii("eletonisations"),
        dictgen::InsensitiveStr::Ascii("eletonise"),
        dictgen::InsensitiveStr::Ascii("eletonised"),
        dictgen::InsensitiveStr::Ascii("eletoniser"),
        dictgen::InsensitiveStr::Ascii("eletonisers"),
        dictgen::InsensitiveStr::Ascii("eletonises"),
        dictgen::InsensitiveStr::Ascii("eletonising"),
        dictgen::InsensitiveStr::Ascii("eletonization"),
        dictgen::InsensitiveStr::Ascii("eletonizations"),
        dictgen::InsensitiveStr::Ascii("eletonize"),
        dictgen::InsensitiveStr::Ascii("eletonized"),
        dictgen::InsensitiveStr::Ascii("eletonizer"),
        dictgen::InsensitiveStr::Ascii("eletonizers"),
        dictgen::InsensitiveStr::Ascii("eletonizes"),
        dictgen::InsensitiveStr::Ascii("eletonizing"),
        dictgen::InsensitiveStr::Ascii("eptic"),
        dictgen::InsensitiveStr::Ascii("eptical"),
        dictgen::InsensitiveStr::Ascii("epticaler"),
        dictgen::InsensitiveStr::Ascii("epticalest"),
        dictgen::InsensitiveStr::Ascii("eptically"),
        dictgen::InsensitiveStr::Ascii("epticer"),
        dictgen::InsensitiveStr::Ascii("epticest"),
        dictgen::InsensitiveStr::Ascii("epticise"),
        dictgen::InsensitiveStr::Ascii("epticises"),
        dictgen::InsensitiveStr::Ascii("epticism"),
        dictgen::InsensitiveStr::Ascii("epticisms"),
        dictgen::InsensitiveStr::Ascii("epticize"),
        dictgen::InsensitiveStr::Ascii("epticizes"),
        dictgen::InsensitiveStr::Ascii("eptics"),
        dictgen::InsensitiveStr::Ascii("ere"),
        dictgen::InsensitiveStr::Ascii("ilful"),
        dictgen::InsensitiveStr::Ascii("ilfully"),
        dictgen::InsensitiveStr::Ascii("ilfulness"),
        dictgen::InsensitiveStr::Ascii("illful"),
        dictgen::InsensitiveStr::Ascii("illfully"),
        dictgen::InsensitiveStr::Ascii("illfulness"),
        dictgen::InsensitiveStr::Ascii("yer"),
        dictgen::InsensitiveStr::Ascii("yers"),
        dictgen::InsensitiveStr::Ascii("yre"),
        dictgen::InsensitiveStr::Ascii("yres"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SKEER_1740844404740176995)],
        &[(0b10010, &ENTRY_SKELETONIZATION_15176281057395840132)],
        &[(0b10010, &ENTRY_SKELETONIZATIONS_2952274931614855136)],
        &[(0b10010, &ENTRY_SKELETONIZE_8844202107033296437)],
        &[(0b10010, &ENTRY_SKELETONIZED_5834618125945052179)],
        &[(0b10010, &ENTRY_SKELETONIZER_1742743360367189615)],
        &[(0b10010, &ENTRY_SKELETONIZERS_11894178897960069861)],
        &[(0b10010, &ENTRY_SKELETONIZES_5920383959770274591)],
        &[(0b10010, &ENTRY_SKELETONIZING_1830503588720890182)],
        &[(0b01001, &ENTRY_SKELETONIZATION_15176281057395840132)],
        &[(0b01001, &ENTRY_SKELETONIZATIONS_2952274931614855136)],
        &[(0b01001, &ENTRY_SKELETONIZE_8844202107033296437)],
        &[(0b01001, &ENTRY_SKELETONIZED_5834618125945052179)],
        &[(0b01001, &ENTRY_SKELETONIZER_1742743360367189615)],
        &[(0b01001, &ENTRY_SKELETONIZERS_11894178897960069861)],
        &[(0b01001, &ENTRY_SKELETONIZES_5920383959770274591)],
        &[(0b01001, &ENTRY_SKELETONIZING_1830503588720890182)],
        &[(0b11001, &ENTRY_SKEPTIC_9366141399207033866)],
        &[(0b11001, &ENTRY_SKEPTICAL_7567920697289876244)],
        &[(0b11001, &ENTRY_SKEPTICALER_3504236392319734868)],
        &[(0b11001, &ENTRY_SKEPTICALEST_1822492830960306797)],
        &[(0b11001, &ENTRY_SKEPTICALLY_15015708074924057237)],
        &[(0b11001, &ENTRY_SKEPTICER_2654895074232389427)],
        &[(0b11001, &ENTRY_SKEPTICEST_13124338123587490640)],
        &[(0b10010, &ENTRY_SKEPTICIZE_233558052004506284)],
        &[(0b10010, &ENTRY_SKEPTICIZES_1621712858377146669)],
        &[(0b11001, &ENTRY_SKEPTICISM_16324594783111490926)],
        &[(0b11001, &ENTRY_SKEPTICISMS_9470460390001384677)],
        &[(0b01001, &ENTRY_SKEPTICIZE_233558052004506284)],
        &[(0b01001, &ENTRY_SKEPTICIZES_1621712858377146669)],
        &[(0b11001, &ENTRY_SKEPTICS_13432613087589375835)],
        &[(0b11010, &ENTRY_SKEER_1740844404740176995)],
        &[(0b11010, &ENTRY_SKILLFUL_8097707939529755598)],
        &[(0b11010, &ENTRY_SKILLFULLY_17336988368413616611)],
        &[(0b11010, &ENTRY_SKILLFULNESS_10066018729560545262)],
        &[(0b10001, &ENTRY_SKILLFUL_8097707939529755598)],
        &[(0b10001, &ENTRY_SKILLFULLY_17336988368413616611)],
        &[(0b10001, &ENTRY_SKILLFULNESS_10066018729560545262)],
        &[(0b00001, &ENTRY_SKYER_15996106329790412626)],
        &[(0b00001, &ENTRY_SKYERS_744502748846351073)],
        &[(0b11010, &ENTRY_SKYER_15996106329790412626)],
        &[(0b11010, &ENTRY_SKYERS_744502748846351073)],
    ],
    range: 3..=14,
};

static VARS_SI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SI_CHILDREN),
    value: None,
};

static VARS_SI_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_SIA_NODE),
    None,
    None,
    Some(&VARS_SID_NODE),
    None,
    None,
    Some(&VARS_SIG_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_SIL_NODE),
    Some(&VARS_SIM_NODE),
    Some(&VARS_SIN_NODE),
    None,
    None,
    None,
    Some(&VARS_SIR_NODE),
    Some(&VARS_SIS_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SIZ_NODE),
];

static VARS_SIZ_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SIZ_CHILDREN),
    value: None,
};

pub static VARS_SIZ_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ably"),
        dictgen::InsensitiveStr::Ascii("eably"),
        dictgen::InsensitiveStr::Ascii("el"),
    ],
    values: &[
        &[(0b01001, &ENTRY_SIZABLY_1222403150260882875)],
        &[(0b10011, &ENTRY_SIZABLY_1222403150260882875)],
        &[(0b01001, &ENTRY_SIZEL_3837879429176540015)],
    ],
    range: 2..=5,
};

static VARS_SIS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SIS_CHILDREN),
    value: None,
};

pub static VARS_SIS_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("el"),
        dictgen::InsensitiveStr::Ascii("terise"),
        dictgen::InsensitiveStr::Ascii("terises"),
        dictgen::InsensitiveStr::Ascii("terize"),
        dictgen::InsensitiveStr::Ascii("terizes"),
        dictgen::InsensitiveStr::Ascii("tern"),
        dictgen::InsensitiveStr::Ascii("tren"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SIZEL_3837879429176540015)],
        &[(0b10010, &ENTRY_SISTERIZE_6948431239930971695)],
        &[(0b10010, &ENTRY_SISTERIZES_17019596055143071237)],
        &[(0b01001, &ENTRY_SISTERIZE_6948431239930971695)],
        &[(0b01001, &ENTRY_SISTERIZES_17019596055143071237)],
        &[(0b00001, &ENTRY_SISTERN_11311516313136487178)],
        &[(0b11010, &ENTRY_SISTERN_11311516313136487178)],
    ],
    range: 2..=7,
};

static VARS_SIR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SIR_CHILDREN),
    value: None,
};

pub static VARS_SIR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("enise"),
        dictgen::InsensitiveStr::Ascii("enised"),
        dictgen::InsensitiveStr::Ascii("enises"),
        dictgen::InsensitiveStr::Ascii("enising"),
        dictgen::InsensitiveStr::Ascii("enize"),
        dictgen::InsensitiveStr::Ascii("enized"),
        dictgen::InsensitiveStr::Ascii("enizes"),
        dictgen::InsensitiveStr::Ascii("enizing"),
        dictgen::InsensitiveStr::Ascii("up"),
        dictgen::InsensitiveStr::Ascii("ups"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SIRENIZE_4666184332714606459)],
        &[(0b10010, &ENTRY_SIRENIZED_2574909956439544564)],
        &[(0b10010, &ENTRY_SIRENIZES_16814257006036530236)],
        &[(0b10010, &ENTRY_SIRENIZING_6540711504301955920)],
        &[(0b01001, &ENTRY_SIRENIZE_4666184332714606459)],
        &[(0b01001, &ENTRY_SIRENIZED_2574909956439544564)],
        &[(0b01001, &ENTRY_SIRENIZES_16814257006036530236)],
        &[(0b01001, &ENTRY_SIRENIZING_6540711504301955920)],
        &[(0b00001, &ENTRY_SYRUP_13414625495147716891)],
        &[(0b00001, &ENTRY_SYRUPS_11767508909122317278)],
    ],
    range: 2..=7,
};

static VARS_SIN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SIN_CHILDREN),
    value: None,
};

pub static VARS_SIN_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ae"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("gularisation"),
        dictgen::InsensitiveStr::Ascii("gularisations"),
        dictgen::InsensitiveStr::Ascii("gularise"),
        dictgen::InsensitiveStr::Ascii("gularised"),
        dictgen::InsensitiveStr::Ascii("gularises"),
        dictgen::InsensitiveStr::Ascii("gularising"),
        dictgen::InsensitiveStr::Ascii("gularization"),
        dictgen::InsensitiveStr::Ascii("gularizations"),
        dictgen::InsensitiveStr::Ascii("gularize"),
        dictgen::InsensitiveStr::Ascii("gularized"),
        dictgen::InsensitiveStr::Ascii("gularizes"),
        dictgen::InsensitiveStr::Ascii("gularizing"),
        dictgen::InsensitiveStr::Ascii("icise"),
        dictgen::InsensitiveStr::Ascii("icised"),
        dictgen::InsensitiveStr::Ascii("icises"),
        dictgen::InsensitiveStr::Ascii("icising"),
        dictgen::InsensitiveStr::Ascii("icize"),
        dictgen::InsensitiveStr::Ascii("icized"),
        dictgen::InsensitiveStr::Ascii("icizes"),
        dictgen::InsensitiveStr::Ascii("icizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SINE_3419162536566868807)],
        &[(0b00001, &ENTRY_SINE_3419162536566868807)],
        &[(0b10010, &ENTRY_SINGULARIZATION_4933930872001149831)],
        &[(0b10010, &ENTRY_SINGULARIZATIONS_4989978119532359980)],
        &[(0b10010, &ENTRY_SINGULARIZE_12969745354704340141)],
        &[(0b10010, &ENTRY_SINGULARIZED_14288632382502472280)],
        &[(0b10010, &ENTRY_SINGULARIZES_5332763602386440207)],
        &[(0b10010, &ENTRY_SINGULARIZING_5008211603587521125)],
        &[(0b01001, &ENTRY_SINGULARIZATION_4933930872001149831)],
        &[(0b01001, &ENTRY_SINGULARIZATIONS_4989978119532359980)],
        &[(0b01001, &ENTRY_SINGULARIZE_12969745354704340141)],
        &[(0b01001, &ENTRY_SINGULARIZED_14288632382502472280)],
        &[(0b01001, &ENTRY_SINGULARIZES_5332763602386440207)],
        &[(0b01001, &ENTRY_SINGULARIZING_5008211603587521125)],
        &[(0b10010, &ENTRY_SINICIZE_5519781244176228688)],
        &[(0b10010, &ENTRY_SINICIZED_1170587988011526807)],
        &[(0b10010, &ENTRY_SINICIZES_16916655538728896626)],
        &[(0b10010, &ENTRY_SINICIZING_12485406975219661792)],
        &[(0b01001, &ENTRY_SINICIZE_5519781244176228688)],
        &[(0b01001, &ENTRY_SINICIZED_1170587988011526807)],
        &[(0b01001, &ENTRY_SINICIZES_16916655538728896626)],
        &[(0b01001, &ENTRY_SINICIZING_12485406975219661792)],
    ],
    range: 1..=13,
};

static VARS_SIM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SIM_CHILDREN),
    value: None,
};

pub static VARS_SIM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ilarise"),
        dictgen::InsensitiveStr::Ascii("ilarises"),
        dictgen::InsensitiveStr::Ascii("ilarize"),
        dictgen::InsensitiveStr::Ascii("ilarizes"),
        dictgen::InsensitiveStr::Ascii("ilise"),
        dictgen::InsensitiveStr::Ascii("ilised"),
        dictgen::InsensitiveStr::Ascii("ilises"),
        dictgen::InsensitiveStr::Ascii("ilising"),
        dictgen::InsensitiveStr::Ascii("ilize"),
        dictgen::InsensitiveStr::Ascii("ilized"),
        dictgen::InsensitiveStr::Ascii("ilizes"),
        dictgen::InsensitiveStr::Ascii("ilizing"),
        dictgen::InsensitiveStr::Ascii("onise"),
        dictgen::InsensitiveStr::Ascii("onize"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SIMILARIZE_2700808984999286713)],
        &[(0b10010, &ENTRY_SIMILARIZES_304454380831943452)],
        &[(0b01001, &ENTRY_SIMILARIZE_2700808984999286713)],
        &[(0b01001, &ENTRY_SIMILARIZES_304454380831943452)],
        &[(0b10010, &ENTRY_SIMILIZE_5812929733131056435)],
        &[(0b10010, &ENTRY_SIMILIZED_10847342221820288097)],
        &[(0b10010, &ENTRY_SIMILIZES_8302279519436698760)],
        &[(0b10010, &ENTRY_SIMILIZING_1862547745562599944)],
        &[(0b01001, &ENTRY_SIMILIZE_5812929733131056435)],
        &[(0b01001, &ENTRY_SIMILIZED_10847342221820288097)],
        &[(0b01001, &ENTRY_SIMILIZES_8302279519436698760)],
        &[(0b01001, &ENTRY_SIMILIZING_1862547745562599944)],
        &[(0b10010, &ENTRY_SIMONIZE_353967938486861116)],
        &[(0b01001, &ENTRY_SIMONIZE_353967938486861116)],
    ],
    range: 5..=8,
};

static VARS_SIL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SIL_CHILDREN),
    value: None,
};

pub static VARS_SIL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("icatisation"),
        dictgen::InsensitiveStr::Ascii("icatisations"),
        dictgen::InsensitiveStr::Ascii("icatization"),
        dictgen::InsensitiveStr::Ascii("icatizations"),
        dictgen::InsensitiveStr::Ascii("icidise"),
        dictgen::InsensitiveStr::Ascii("icidises"),
        dictgen::InsensitiveStr::Ascii("icidize"),
        dictgen::InsensitiveStr::Ascii("icidizes"),
        dictgen::InsensitiveStr::Ascii("iconise"),
        dictgen::InsensitiveStr::Ascii("iconises"),
        dictgen::InsensitiveStr::Ascii("iconize"),
        dictgen::InsensitiveStr::Ascii("iconizes"),
        dictgen::InsensitiveStr::Ascii("iculae"),
        dictgen::InsensitiveStr::Ascii("icule"),
        dictgen::InsensitiveStr::Ascii("iquae"),
        dictgen::InsensitiveStr::Ascii("ique"),
        dictgen::InsensitiveStr::Ascii("oed"),
        dictgen::InsensitiveStr::Ascii("verise"),
        dictgen::InsensitiveStr::Ascii("verised"),
        dictgen::InsensitiveStr::Ascii("veriser"),
        dictgen::InsensitiveStr::Ascii("verisers"),
        dictgen::InsensitiveStr::Ascii("verises"),
        dictgen::InsensitiveStr::Ascii("verising"),
        dictgen::InsensitiveStr::Ascii("verize"),
        dictgen::InsensitiveStr::Ascii("verized"),
        dictgen::InsensitiveStr::Ascii("verizer"),
        dictgen::InsensitiveStr::Ascii("verizers"),
        dictgen::InsensitiveStr::Ascii("verizes"),
        dictgen::InsensitiveStr::Ascii("verizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SILED_10789450856636085272)],
        &[(0b10010, &ENTRY_SILICATIZATION_15183159520715497593)],
        &[(0b10010, &ENTRY_SILICATIZATIONS_12311801766905293588)],
        &[(0b01001, &ENTRY_SILICATIZATION_15183159520715497593)],
        &[(0b01001, &ENTRY_SILICATIZATIONS_12311801766905293588)],
        &[(0b10010, &ENTRY_SILICIDIZE_7437759950119638805)],
        &[(0b10010, &ENTRY_SILICIDIZES_5809599080861161027)],
        &[(0b01001, &ENTRY_SILICIDIZE_7437759950119638805)],
        &[(0b01001, &ENTRY_SILICIDIZES_5809599080861161027)],
        &[(0b10010, &ENTRY_SILICONIZE_13299465442579992202)],
        &[(0b10010, &ENTRY_SILICONIZES_14042775956262597692)],
        &[(0b01001, &ENTRY_SILICONIZE_13299465442579992202)],
        &[(0b01001, &ENTRY_SILICONIZES_14042775956262597692)],
        &[(0b11010, &ENTRY_SILICULE_16607190405791216240)],
        &[(0b00001, &ENTRY_SILICULE_16607190405791216240)],
        &[(0b11010, &ENTRY_SILIQUE_350570384784907901)],
        &[(0b00001, &ENTRY_SILIQUE_350570384784907901)],
        &[(0b11010, &ENTRY_SILED_10789450856636085272)],
        &[(0b10010, &ENTRY_SILVERIZE_1532148002770872366)],
        &[(0b10010, &ENTRY_SILVERIZED_3373734626849304080)],
        &[(0b10010, &ENTRY_SILVERIZER_15985635737519372213)],
        &[(0b10010, &ENTRY_SILVERIZERS_3216971382949916106)],
        &[(0b10010, &ENTRY_SILVERIZES_15646884568196086232)],
        &[(0b10010, &ENTRY_SILVERIZING_2034359189517396764)],
        &[(0b01001, &ENTRY_SILVERIZE_1532148002770872366)],
        &[(0b01001, &ENTRY_SILVERIZED_3373734626849304080)],
        &[(0b01001, &ENTRY_SILVERIZER_15985635737519372213)],
        &[(0b01001, &ENTRY_SILVERIZERS_3216971382949916106)],
        &[(0b01001, &ENTRY_SILVERIZES_15646884568196086232)],
        &[(0b01001, &ENTRY_SILVERIZING_2034359189517396764)],
    ],
    range: 2..=12,
};

static VARS_SIG_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SIG_CHILDREN),
    value: None,
};

pub static VARS_SIG_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("naled"),
        dictgen::InsensitiveStr::Ascii("naler"),
        dictgen::InsensitiveStr::Ascii("nalers"),
        dictgen::InsensitiveStr::Ascii("naling"),
        dictgen::InsensitiveStr::Ascii("nalisation"),
        dictgen::InsensitiveStr::Ascii("nalise"),
        dictgen::InsensitiveStr::Ascii("nalised"),
        dictgen::InsensitiveStr::Ascii("nalises"),
        dictgen::InsensitiveStr::Ascii("nalising"),
        dictgen::InsensitiveStr::Ascii("nalization"),
        dictgen::InsensitiveStr::Ascii("nalize"),
        dictgen::InsensitiveStr::Ascii("nalized"),
        dictgen::InsensitiveStr::Ascii("nalizes"),
        dictgen::InsensitiveStr::Ascii("nalizing"),
        dictgen::InsensitiveStr::Ascii("nalled"),
        dictgen::InsensitiveStr::Ascii("naller"),
        dictgen::InsensitiveStr::Ascii("nallers"),
        dictgen::InsensitiveStr::Ascii("nalling"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SIGNALED_4517098988465661597)],
        &[(0b00001, &ENTRY_SIGNALER_11540498906832061128)],
        &[(0b00001, &ENTRY_SIGNALERS_8816754826640457370)],
        &[(0b00001, &ENTRY_SIGNALING_38367410174135288)],
        &[(0b10010, &ENTRY_SIGNALIZATION_6300811578722786643)],
        &[(0b10010, &ENTRY_SIGNALIZE_15445299234874331775)],
        &[(0b10010, &ENTRY_SIGNALIZED_1328658457279077123)],
        &[(0b10010, &ENTRY_SIGNALIZES_15183847864880876512)],
        &[(0b10010, &ENTRY_SIGNALIZING_14031692614622999963)],
        &[(0b01001, &ENTRY_SIGNALIZATION_6300811578722786643)],
        &[(0b01001, &ENTRY_SIGNALIZE_15445299234874331775)],
        &[(0b01001, &ENTRY_SIGNALIZED_1328658457279077123)],
        &[(0b01001, &ENTRY_SIGNALIZES_15183847864880876512)],
        &[(0b01001, &ENTRY_SIGNALIZING_14031692614622999963)],
        &[(0b11010, &ENTRY_SIGNALED_4517098988465661597)],
        &[(0b11010, &ENTRY_SIGNALER_11540498906832061128)],
        &[(0b11010, &ENTRY_SIGNALERS_8816754826640457370)],
        &[(0b11010, &ENTRY_SIGNALING_38367410174135288)],
    ],
    range: 5..=10,
};

static VARS_SID_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SID_CHILDREN),
    value: None,
};

pub static VARS_SID_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("erealise"),
        dictgen::InsensitiveStr::Ascii("erealises"),
        dictgen::InsensitiveStr::Ascii("erealize"),
        dictgen::InsensitiveStr::Ascii("erealizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SIDEREALIZE_13138990443604086580)],
        &[(0b10010, &ENTRY_SIDEREALIZES_5077853180450618510)],
        &[(0b01001, &ENTRY_SIDEREALIZE_13138990443604086580)],
        &[(0b01001, &ENTRY_SIDEREALIZES_5077853180450618510)],
    ],
    range: 8..=9,
};

static VARS_SIA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SIA_CHILDREN),
    value: None,
};

pub static VARS_SIA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lorrhea"),
        dictgen::InsensitiveStr::Ascii("lorrhoea"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SIALORRHEA_6484075731495212593)],
        &[(0b11010, &ENTRY_SIALORRHEA_6484075731495212593)],
    ],
    range: 7..=8,
};

static VARS_SH_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SH_CHILDREN),
    value: None,
};

pub static VARS_SH_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aikh"),
        dictgen::InsensitiveStr::Ascii("aikhs"),
        dictgen::InsensitiveStr::Ascii("akespearise"),
        dictgen::InsensitiveStr::Ascii("akespearises"),
        dictgen::InsensitiveStr::Ascii("akespearize"),
        dictgen::InsensitiveStr::Ascii("akespearizes"),
        dictgen::InsensitiveStr::Ascii("epherdise"),
        dictgen::InsensitiveStr::Ascii("epherdises"),
        dictgen::InsensitiveStr::Ascii("epherdize"),
        dictgen::InsensitiveStr::Ascii("epherdizes"),
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("erardise"),
        dictgen::InsensitiveStr::Ascii("erardised"),
        dictgen::InsensitiveStr::Ascii("erardises"),
        dictgen::InsensitiveStr::Ascii("erardising"),
        dictgen::InsensitiveStr::Ascii("erardize"),
        dictgen::InsensitiveStr::Ascii("erardized"),
        dictgen::InsensitiveStr::Ascii("erardizes"),
        dictgen::InsensitiveStr::Ascii("erardizing"),
        dictgen::InsensitiveStr::Ascii("ere"),
        dictgen::InsensitiveStr::Ascii("intoise"),
        dictgen::InsensitiveStr::Ascii("intoises"),
        dictgen::InsensitiveStr::Ascii("intoize"),
        dictgen::InsensitiveStr::Ascii("intoizes"),
        dictgen::InsensitiveStr::Ascii("kodaer"),
        dictgen::InsensitiveStr::Ascii("koder"),
        dictgen::InsensitiveStr::Ascii("oer"),
        dictgen::InsensitiveStr::Ascii("oveled"),
        dictgen::InsensitiveStr::Ascii("oveler"),
        dictgen::InsensitiveStr::Ascii("ovelers"),
        dictgen::InsensitiveStr::Ascii("oveling"),
        dictgen::InsensitiveStr::Ascii("ovelled"),
        dictgen::InsensitiveStr::Ascii("oveller"),
        dictgen::InsensitiveStr::Ascii("ovellers"),
        dictgen::InsensitiveStr::Ascii("ovelling"),
        dictgen::InsensitiveStr::Ascii("ree"),
        dictgen::InsensitiveStr::Ascii("riveled"),
        dictgen::InsensitiveStr::Ascii("riveling"),
        dictgen::InsensitiveStr::Ascii("rivelled"),
        dictgen::InsensitiveStr::Ascii("rivelling"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SHEIKH_8983659288141972445)],
        &[(0b00001, &ENTRY_SHEIKHS_10762489381044075569)],
        &[(0b10010, &ENTRY_SHAKESPEARIZE_6066803341152707552)],
        &[(0b10010, &ENTRY_SHAKESPEARIZES_17778092510718324337)],
        &[(0b01001, &ENTRY_SHAKESPEARIZE_6066803341152707552)],
        &[(0b01001, &ENTRY_SHAKESPEARIZES_17778092510718324337)],
        &[(0b10010, &ENTRY_SHEPHERDIZE_9589644434591127897)],
        &[(0b10010, &ENTRY_SHEPHERDIZES_4618442149214601958)],
        &[(0b01001, &ENTRY_SHEPHERDIZE_9589644434591127897)],
        &[(0b01001, &ENTRY_SHEPHERDIZES_4618442149214601958)],
        &[(0b00001, &ENTRY_SHER_17217175326411018784)],
        &[(0b10010, &ENTRY_SHERARDIZE_16617170604726285533)],
        &[(0b10010, &ENTRY_SHERARDIZED_3013055586963630691)],
        &[(0b10010, &ENTRY_SHERARDIZES_5495265908461761242)],
        &[(0b10010, &ENTRY_SHERARDIZING_6141668254225889701)],
        &[(0b01001, &ENTRY_SHERARDIZE_16617170604726285533)],
        &[(0b01001, &ENTRY_SHERARDIZED_3013055586963630691)],
        &[(0b01001, &ENTRY_SHERARDIZES_5495265908461761242)],
        &[(0b01001, &ENTRY_SHERARDIZING_6141668254225889701)],
        &[(0b00001, &ENTRY_SHERE_8519598491987964057)],
        &[(0b10010, &ENTRY_SHINTOIZE_11809502309481638164)],
        &[(0b10010, &ENTRY_SHINTOIZES_7087800735292630340)],
        &[(0b01001, &ENTRY_SHINTOIZE_11809502309481638164)],
        &[(0b01001, &ENTRY_SHINTOIZES_7087800735292630340)],
        &[(0b11010, &ENTRY_SHKODER_5585881395862931532)],
        &[(0b00001, &ENTRY_SHKODER_5585881395862931532)],
        &[(0b11010, &ENTRY_SHER_17217175326411018784)],
        &[(0b00001, &ENTRY_SHOVELED_15062634087638291011)],
        &[(0b01001, &ENTRY_SHOVELER_7861570800291993508)],
        &[(0b01001, &ENTRY_SHOVELERS_2279935736385901824)],
        &[(0b00001, &ENTRY_SHOVELING_4658042570347509024)],
        &[(0b11010, &ENTRY_SHOVELED_15062634087638291011)],
        &[(0b11010, &ENTRY_SHOVELER_7861570800291993508)],
        &[(0b11010, &ENTRY_SHOVELERS_2279935736385901824)],
        &[(0b11010, &ENTRY_SHOVELING_4658042570347509024)],
        &[(0b11010, &ENTRY_SHERE_8519598491987964057)],
        &[(0b00001, &ENTRY_SHRIVELED_9173718681891056162)],
        &[(0b00001, &ENTRY_SHRIVELING_9001440579199169374)],
        &[(0b11010, &ENTRY_SHRIVELED_9173718681891056162)],
        &[(0b11010, &ENTRY_SHRIVELING_9001440579199169374)],
    ],
    range: 2..=12,
};

static VARS_SE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SE_CHILDREN),
    value: Some(&[
        (0b00001, &ENTRY_SE_15361672265999879694),
        (0b00001, &ENTRY_SE_2594869031866220942),
    ]),
};

static VARS_SE_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_SEB_NODE),
    Some(&VARS_SEC_NODE),
    None,
    Some(&VARS_SEE_NODE),
    None,
    None,
    None,
    Some(&VARS_SEI_NODE),
    None,
    None,
    Some(&VARS_SEL_NODE),
    Some(&VARS_SEM_NODE),
    Some(&VARS_SEN_NODE),
    None,
    Some(&VARS_SEP_NODE),
    Some(&VARS_SEQ_NODE),
    Some(&VARS_SER_NODE),
    None,
    Some(&VARS_SET_NODE),
    None,
    Some(&VARS_SEV_NODE),
    None,
    Some(&VARS_SEX_NODE),
    None,
    None,
];

static VARS_SEX_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEX_CHILDREN),
    value: None,
};

pub static VARS_SEX_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ualisation"),
        dictgen::InsensitiveStr::Ascii("ualisations"),
        dictgen::InsensitiveStr::Ascii("ualise"),
        dictgen::InsensitiveStr::Ascii("ualised"),
        dictgen::InsensitiveStr::Ascii("ualises"),
        dictgen::InsensitiveStr::Ascii("ualising"),
        dictgen::InsensitiveStr::Ascii("ualization"),
        dictgen::InsensitiveStr::Ascii("ualizations"),
        dictgen::InsensitiveStr::Ascii("ualize"),
        dictgen::InsensitiveStr::Ascii("ualized"),
        dictgen::InsensitiveStr::Ascii("ualizes"),
        dictgen::InsensitiveStr::Ascii("ualizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SEXUALIZATION_598558153365374975)],
        &[(0b10010, &ENTRY_SEXUALIZATIONS_6419691977489313070)],
        &[(0b10010, &ENTRY_SEXUALIZE_9305579592150587788)],
        &[(0b10010, &ENTRY_SEXUALIZED_17516220740309805973)],
        &[(0b10010, &ENTRY_SEXUALIZES_14899097055849161352)],
        &[(0b10010, &ENTRY_SEXUALIZING_13168796826287121808)],
        &[(0b01001, &ENTRY_SEXUALIZATION_598558153365374975)],
        &[(0b01001, &ENTRY_SEXUALIZATIONS_6419691977489313070)],
        &[(0b01001, &ENTRY_SEXUALIZE_9305579592150587788)],
        &[(0b01001, &ENTRY_SEXUALIZED_17516220740309805973)],
        &[(0b01001, &ENTRY_SEXUALIZES_14899097055849161352)],
        &[(0b01001, &ENTRY_SEXUALIZING_13168796826287121808)],
    ],
    range: 6..=11,
};

static VARS_SEV_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEV_CHILDREN),
    value: None,
};

pub static VARS_SEV_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eralise"),
        dictgen::InsensitiveStr::Ascii("eralises"),
        dictgen::InsensitiveStr::Ascii("eralize"),
        dictgen::InsensitiveStr::Ascii("eralizes"),
        dictgen::InsensitiveStr::Ascii("erisation"),
        dictgen::InsensitiveStr::Ascii("erisations"),
        dictgen::InsensitiveStr::Ascii("erise"),
        dictgen::InsensitiveStr::Ascii("erises"),
        dictgen::InsensitiveStr::Ascii("erization"),
        dictgen::InsensitiveStr::Ascii("erizations"),
        dictgen::InsensitiveStr::Ascii("erize"),
        dictgen::InsensitiveStr::Ascii("erizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SEVERALIZE_10314418645470673257)],
        &[(0b10010, &ENTRY_SEVERALIZES_10859120750647710400)],
        &[(0b01001, &ENTRY_SEVERALIZE_10314418645470673257)],
        &[(0b01001, &ENTRY_SEVERALIZES_10859120750647710400)],
        &[(0b10010, &ENTRY_SEVERIZATION_5132300365352798030)],
        &[(0b10010, &ENTRY_SEVERIZATIONS_14701963156627030317)],
        &[(0b10010, &ENTRY_SEVERIZE_17078342800840793427)],
        &[(0b10010, &ENTRY_SEVERIZES_3513402572065109149)],
        &[(0b01001, &ENTRY_SEVERIZATION_5132300365352798030)],
        &[(0b01001, &ENTRY_SEVERIZATIONS_14701963156627030317)],
        &[(0b01001, &ENTRY_SEVERIZE_17078342800840793427)],
        &[(0b01001, &ENTRY_SEVERIZES_3513402572065109149)],
    ],
    range: 5..=10,
};

static VARS_SET_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SET_CHILDREN),
    value: None,
};

pub static VARS_SET_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("a"),
        dictgen::InsensitiveStr::Ascii("ulae"),
        dictgen::InsensitiveStr::Ascii("ule"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SETA_9673520022199067907)],
        &[(0b11010, &ENTRY_SETULE_8234529077451319159)],
        &[(0b00001, &ENTRY_SETULE_8234529077451319159)],
    ],
    range: 1..=4,
};

static VARS_SER_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SER_CHILDREN),
    value: None,
};

static VARS_SER_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    Some(&VARS_SERE_NODE),
    None,
    None,
    None,
    Some(&VARS_SERI_NODE),
    None,
    None,
    None,
    Some(&VARS_SERM_NODE),
    None,
    Some(&VARS_SERO_NODE),
    Some(&VARS_SERP_NODE),
    None,
    Some(&VARS_SERR_NODE),
    None,
    None,
    None,
    Some(&VARS_SERV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_SERV_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SERV_CHILDREN),
    value: None,
};

pub static VARS_SERV_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ilise"),
        dictgen::InsensitiveStr::Ascii("ilises"),
        dictgen::InsensitiveStr::Ascii("ilize"),
        dictgen::InsensitiveStr::Ascii("ilizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SERVILIZE_14834152406961369316)],
        &[(0b10010, &ENTRY_SERVILIZES_8276384829138801671)],
        &[(0b01001, &ENTRY_SERVILIZE_14834152406961369316)],
        &[(0b01001, &ENTRY_SERVILIZES_8276384829138801671)],
    ],
    range: 5..=6,
};

static VARS_SERR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SERR_CHILDREN),
    value: None,
};

pub static VARS_SERR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ae"),
        dictgen::InsensitiveStr::Ascii("e"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SERRE_3180474638636958561)],
        &[(0b00001, &ENTRY_SERRE_3180474638636958561)],
    ],
    range: 1..=2,
};

static VARS_SERP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SERP_CHILDREN),
    value: None,
};

pub static VARS_SERP_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("entinisation"),
        dictgen::InsensitiveStr::Ascii("entinisations"),
        dictgen::InsensitiveStr::Ascii("entinise"),
        dictgen::InsensitiveStr::Ascii("entinised"),
        dictgen::InsensitiveStr::Ascii("entinises"),
        dictgen::InsensitiveStr::Ascii("entinising"),
        dictgen::InsensitiveStr::Ascii("entinization"),
        dictgen::InsensitiveStr::Ascii("entinizations"),
        dictgen::InsensitiveStr::Ascii("entinize"),
        dictgen::InsensitiveStr::Ascii("entinized"),
        dictgen::InsensitiveStr::Ascii("entinizes"),
        dictgen::InsensitiveStr::Ascii("entinizing"),
        dictgen::InsensitiveStr::Ascii("entise"),
        dictgen::InsensitiveStr::Ascii("entised"),
        dictgen::InsensitiveStr::Ascii("entises"),
        dictgen::InsensitiveStr::Ascii("entising"),
        dictgen::InsensitiveStr::Ascii("entize"),
        dictgen::InsensitiveStr::Ascii("entized"),
        dictgen::InsensitiveStr::Ascii("entizes"),
        dictgen::InsensitiveStr::Ascii("entizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SERPENTINIZATION_5560169582513450767)],
        &[(0b10010, &ENTRY_SERPENTINIZATIONS_18216025003407152452)],
        &[(0b10010, &ENTRY_SERPENTINIZE_9866240419191948775)],
        &[(0b10010, &ENTRY_SERPENTINIZED_7455002792008011952)],
        &[(0b10010, &ENTRY_SERPENTINIZES_8678826049205047091)],
        &[(0b10010, &ENTRY_SERPENTINIZING_9092366228143126428)],
        &[(0b01001, &ENTRY_SERPENTINIZATION_5560169582513450767)],
        &[(0b01001, &ENTRY_SERPENTINIZATIONS_18216025003407152452)],
        &[(0b01001, &ENTRY_SERPENTINIZE_9866240419191948775)],
        &[(0b01001, &ENTRY_SERPENTINIZED_7455002792008011952)],
        &[(0b01001, &ENTRY_SERPENTINIZES_8678826049205047091)],
        &[(0b01001, &ENTRY_SERPENTINIZING_9092366228143126428)],
        &[(0b10010, &ENTRY_SERPENTIZE_3384972221379685069)],
        &[(0b10010, &ENTRY_SERPENTIZED_4330573112091394638)],
        &[(0b10010, &ENTRY_SERPENTIZES_1625704616745057635)],
        &[(0b10010, &ENTRY_SERPENTIZING_9593903542078580092)],
        &[(0b01001, &ENTRY_SERPENTIZE_3384972221379685069)],
        &[(0b01001, &ENTRY_SERPENTIZED_4330573112091394638)],
        &[(0b01001, &ENTRY_SERPENTIZES_1625704616745057635)],
        &[(0b01001, &ENTRY_SERPENTIZING_9593903542078580092)],
    ],
    range: 6..=13,
};

static VARS_SERO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SERO_CHILDREN),
    value: None,
};

pub static VARS_SERO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("sae"),
        dictgen::InsensitiveStr::Ascii("se"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SEROSE_10469280893173049445)],
        &[(0b00001, &ENTRY_SEROSE_10469280893173049445)],
    ],
    range: 2..=3,
};

static VARS_SERM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SERM_CHILDREN),
    value: None,
};

pub static VARS_SERM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("onise"),
        dictgen::InsensitiveStr::Ascii("onised"),
        dictgen::InsensitiveStr::Ascii("oniser"),
        dictgen::InsensitiveStr::Ascii("onisers"),
        dictgen::InsensitiveStr::Ascii("onises"),
        dictgen::InsensitiveStr::Ascii("onising"),
        dictgen::InsensitiveStr::Ascii("onize"),
        dictgen::InsensitiveStr::Ascii("onized"),
        dictgen::InsensitiveStr::Ascii("onizer"),
        dictgen::InsensitiveStr::Ascii("onizers"),
        dictgen::InsensitiveStr::Ascii("onizes"),
        dictgen::InsensitiveStr::Ascii("onizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SERMONIZE_237921077671914948)],
        &[(0b10010, &ENTRY_SERMONIZED_5857494441485850990)],
        &[(0b10010, &ENTRY_SERMONIZER_9999853450353383558)],
        &[(0b10010, &ENTRY_SERMONIZERS_10627211662032897475)],
        &[(0b10010, &ENTRY_SERMONIZES_8207614673919524386)],
        &[(0b10010, &ENTRY_SERMONIZING_9180710516114443189)],
        &[(0b01001, &ENTRY_SERMONIZE_237921077671914948)],
        &[(0b01001, &ENTRY_SERMONIZED_5857494441485850990)],
        &[(0b01001, &ENTRY_SERMONIZER_9999853450353383558)],
        &[(0b01001, &ENTRY_SERMONIZERS_10627211662032897475)],
        &[(0b01001, &ENTRY_SERMONIZES_8207614673919524386)],
        &[(0b01001, &ENTRY_SERMONIZING_9180710516114443189)],
    ],
    range: 5..=7,
};

static VARS_SERI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SERI_CHILDREN),
    value: None,
};

pub static VARS_SERI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alisability"),
        dictgen::InsensitiveStr::Ascii("alisable"),
        dictgen::InsensitiveStr::Ascii("alisation"),
        dictgen::InsensitiveStr::Ascii("alisations"),
        dictgen::InsensitiveStr::Ascii("alise"),
        dictgen::InsensitiveStr::Ascii("alised"),
        dictgen::InsensitiveStr::Ascii("alises"),
        dictgen::InsensitiveStr::Ascii("alising"),
        dictgen::InsensitiveStr::Ascii("alizability"),
        dictgen::InsensitiveStr::Ascii("alizable"),
        dictgen::InsensitiveStr::Ascii("alization"),
        dictgen::InsensitiveStr::Ascii("alizations"),
        dictgen::InsensitiveStr::Ascii("alize"),
        dictgen::InsensitiveStr::Ascii("alized"),
        dictgen::InsensitiveStr::Ascii("alizes"),
        dictgen::InsensitiveStr::Ascii("alizing"),
        dictgen::InsensitiveStr::Ascii("citisation"),
        dictgen::InsensitiveStr::Ascii("citisations"),
        dictgen::InsensitiveStr::Ascii("citization"),
        dictgen::InsensitiveStr::Ascii("citizations"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SERIALIZABILITY_7773982292760873044)],
        &[(0b10010, &ENTRY_SERIALIZABLE_1502323051817082784)],
        &[(0b10010, &ENTRY_SERIALIZATION_8026595017898253094)],
        &[(0b10010, &ENTRY_SERIALIZATIONS_16803629240691327375)],
        &[(0b10010, &ENTRY_SERIALIZE_14044145149155879461)],
        &[(0b10010, &ENTRY_SERIALIZED_1888364664748280784)],
        &[(0b10010, &ENTRY_SERIALIZES_15444051215059194506)],
        &[(0b10010, &ENTRY_SERIALIZING_13270926386983604461)],
        &[(0b01001, &ENTRY_SERIALIZABILITY_7773982292760873044)],
        &[(0b01001, &ENTRY_SERIALIZABLE_1502323051817082784)],
        &[(0b01001, &ENTRY_SERIALIZATION_8026595017898253094)],
        &[(0b01001, &ENTRY_SERIALIZATIONS_16803629240691327375)],
        &[(0b01001, &ENTRY_SERIALIZE_14044145149155879461)],
        &[(0b01001, &ENTRY_SERIALIZED_1888364664748280784)],
        &[(0b01001, &ENTRY_SERIALIZES_15444051215059194506)],
        &[(0b01001, &ENTRY_SERIALIZING_13270926386983604461)],
        &[(0b10010, &ENTRY_SERICITIZATION_8474782731600998020)],
        &[(0b10010, &ENTRY_SERICITIZATIONS_3976668030061776680)],
        &[(0b01001, &ENTRY_SERICITIZATION_8474782731600998020)],
        &[(0b01001, &ENTRY_SERICITIZATIONS_3976668030061776680)],
    ],
    range: 5..=11,
};

static VARS_SERE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SERE_CHILDREN),
    value: None,
};

pub static VARS_SERE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("nise"),
        dictgen::InsensitiveStr::Ascii("nises"),
        dictgen::InsensitiveStr::Ascii("nize"),
        dictgen::InsensitiveStr::Ascii("nizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SERENIZE_13954843561052019043)],
        &[(0b10010, &ENTRY_SERENIZES_3953496351859270409)],
        &[(0b01001, &ENTRY_SERENIZE_13954843561052019043)],
        &[(0b01001, &ENTRY_SERENIZES_3953496351859270409)],
    ],
    range: 4..=5,
};

static VARS_SEQ_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEQ_CHILDREN),
    value: None,
};

pub static VARS_SEQ_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("uentialise"),
        dictgen::InsensitiveStr::Ascii("uentialised"),
        dictgen::InsensitiveStr::Ascii("uentialises"),
        dictgen::InsensitiveStr::Ascii("uentialising"),
        dictgen::InsensitiveStr::Ascii("uentialize"),
        dictgen::InsensitiveStr::Ascii("uentialized"),
        dictgen::InsensitiveStr::Ascii("uentializes"),
        dictgen::InsensitiveStr::Ascii("uentializing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SEQUENTIALIZE_7687249845236795)],
        &[(0b10010, &ENTRY_SEQUENTIALIZED_13342886831978411557)],
        &[(0b10010, &ENTRY_SEQUENTIALIZES_903062549732554575)],
        &[(0b10010, &ENTRY_SEQUENTIALIZING_12526259102466204603)],
        &[(0b01001, &ENTRY_SEQUENTIALIZE_7687249845236795)],
        &[(0b01001, &ENTRY_SEQUENTIALIZED_13342886831978411557)],
        &[(0b01001, &ENTRY_SEQUENTIALIZES_903062549732554575)],
        &[(0b01001, &ENTRY_SEQUENTIALIZING_12526259102466204603)],
    ],
    range: 10..=12,
};

static VARS_SEP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEP_CHILDREN),
    value: None,
};

pub static VARS_SEP_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aled"),
        dictgen::InsensitiveStr::Ascii("aledder"),
        dictgen::InsensitiveStr::Ascii("aleddest"),
        dictgen::InsensitiveStr::Ascii("alled"),
        dictgen::InsensitiveStr::Ascii("alledder"),
        dictgen::InsensitiveStr::Ascii("alleddest"),
        dictgen::InsensitiveStr::Ascii("taemia"),
        dictgen::InsensitiveStr::Ascii("tembriser"),
        dictgen::InsensitiveStr::Ascii("tembrisers"),
        dictgen::InsensitiveStr::Ascii("tembrizer"),
        dictgen::InsensitiveStr::Ascii("tembrizers"),
        dictgen::InsensitiveStr::Ascii("temia"),
        dictgen::InsensitiveStr::Ascii("ticaemia"),
        dictgen::InsensitiveStr::Ascii("ticaemias"),
        dictgen::InsensitiveStr::Ascii("ticaemic"),
        dictgen::InsensitiveStr::Ascii("ticemia"),
        dictgen::InsensitiveStr::Ascii("ticemias"),
        dictgen::InsensitiveStr::Ascii("ticemic"),
        dictgen::InsensitiveStr::Ascii("ticisation"),
        dictgen::InsensitiveStr::Ascii("ticisations"),
        dictgen::InsensitiveStr::Ascii("ticization"),
        dictgen::InsensitiveStr::Ascii("ticizations"),
        dictgen::InsensitiveStr::Ascii("ticolored"),
        dictgen::InsensitiveStr::Ascii("ticoloured"),
        dictgen::InsensitiveStr::Ascii("ulcher"),
        dictgen::InsensitiveStr::Ascii("ulchered"),
        dictgen::InsensitiveStr::Ascii("ulchering"),
        dictgen::InsensitiveStr::Ascii("ulchers"),
        dictgen::InsensitiveStr::Ascii("ulchralise"),
        dictgen::InsensitiveStr::Ascii("ulchralises"),
        dictgen::InsensitiveStr::Ascii("ulchralize"),
        dictgen::InsensitiveStr::Ascii("ulchralizes"),
        dictgen::InsensitiveStr::Ascii("ulchre"),
        dictgen::InsensitiveStr::Ascii("ulchred"),
        dictgen::InsensitiveStr::Ascii("ulchres"),
        dictgen::InsensitiveStr::Ascii("ulchring"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SEPALED_12090295642380405616)],
        &[(0b00001, &ENTRY_SEPALEDDER_18149050438233478463)],
        &[(0b00001, &ENTRY_SEPALEDDEST_16726621142433806076)],
        &[(0b11010, &ENTRY_SEPALED_12090295642380405616)],
        &[(0b11010, &ENTRY_SEPALEDDER_18149050438233478463)],
        &[(0b11010, &ENTRY_SEPALEDDEST_16726621142433806076)],
        &[(0b11010, &ENTRY_SEPTEMIA_17627373967872968416)],
        &[(0b10010, &ENTRY_SEPTEMBRIZER_14180678052471741675)],
        &[(0b10010, &ENTRY_SEPTEMBRIZERS_5568167245143709930)],
        &[(0b01001, &ENTRY_SEPTEMBRIZER_14180678052471741675)],
        &[(0b01001, &ENTRY_SEPTEMBRIZERS_5568167245143709930)],
        &[(0b00001, &ENTRY_SEPTEMIA_17627373967872968416)],
        &[(0b10010, &ENTRY_SEPTICEMIA_11397632634952601953)],
        &[(0b10010, &ENTRY_SEPTICEMIAS_12503495764642957726)],
        &[(0b10010, &ENTRY_SEPTICEMIC_17224432424285146941)],
        &[(0b01001, &ENTRY_SEPTICEMIA_11397632634952601953)],
        &[(0b01001, &ENTRY_SEPTICEMIAS_12503495764642957726)],
        &[(0b01001, &ENTRY_SEPTICEMIC_17224432424285146941)],
        &[(0b10010, &ENTRY_SEPTICIZATION_14002989906709765055)],
        &[(0b10010, &ENTRY_SEPTICIZATIONS_14828929428564717195)],
        &[(0b01001, &ENTRY_SEPTICIZATION_14002989906709765055)],
        &[(0b01001, &ENTRY_SEPTICIZATIONS_14828929428564717195)],
        &[(0b00001, &ENTRY_SEPTICOLORED_5211825597090733015)],
        &[(0b11010, &ENTRY_SEPTICOLORED_5211825597090733015)],
        &[(0b00001, &ENTRY_SEPULCHER_5901571127124975988)],
        &[(0b00001, &ENTRY_SEPULCHERED_13156739439863668198)],
        &[(0b00001, &ENTRY_SEPULCHERING_15916701810150961536)],
        &[(0b00001, &ENTRY_SEPULCHERS_17907839135565596907)],
        &[(0b10010, &ENTRY_SEPULCHRALIZE_471485549032044787)],
        &[(0b10010, &ENTRY_SEPULCHRALIZES_11618984573736373917)],
        &[(0b01001, &ENTRY_SEPULCHRALIZE_471485549032044787)],
        &[(0b01001, &ENTRY_SEPULCHRALIZES_11618984573736373917)],
        &[(0b11010, &ENTRY_SEPULCHER_5901571127124975988)],
        &[(0b11010, &ENTRY_SEPULCHERED_13156739439863668198)],
        &[(0b11010, &ENTRY_SEPULCHERS_17907839135565596907)],
        &[(0b11010, &ENTRY_SEPULCHERING_15916701810150961536)],
    ],
    range: 4..=11,
};

static VARS_SEN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SEN_CHILDREN),
    value: None,
};

static VARS_SEN_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SENI_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SENS_NODE),
    Some(&VARS_SENT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_SENT_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SENT_CHILDREN),
    value: None,
};

pub static VARS_SENT_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("imentalisation"),
        dictgen::InsensitiveStr::Ascii("imentalisations"),
        dictgen::InsensitiveStr::Ascii("imentalise"),
        dictgen::InsensitiveStr::Ascii("imentalised"),
        dictgen::InsensitiveStr::Ascii("imentaliser"),
        dictgen::InsensitiveStr::Ascii("imentalisers"),
        dictgen::InsensitiveStr::Ascii("imentalises"),
        dictgen::InsensitiveStr::Ascii("imentalising"),
        dictgen::InsensitiveStr::Ascii("imentalization"),
        dictgen::InsensitiveStr::Ascii("imentalizations"),
        dictgen::InsensitiveStr::Ascii("imentalize"),
        dictgen::InsensitiveStr::Ascii("imentalized"),
        dictgen::InsensitiveStr::Ascii("imentalizer"),
        dictgen::InsensitiveStr::Ascii("imentalizers"),
        dictgen::InsensitiveStr::Ascii("imentalizes"),
        dictgen::InsensitiveStr::Ascii("imentalizing"),
        dictgen::InsensitiveStr::Ascii("ineled"),
        dictgen::InsensitiveStr::Ascii("ineling"),
        dictgen::InsensitiveStr::Ascii("inelled"),
        dictgen::InsensitiveStr::Ascii("inelling"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SENTIMENTALIZATION_9061044606950222949)],
        &[(0b10010, &ENTRY_SENTIMENTALIZATIONS_17372211169793747786)],
        &[(0b10010, &ENTRY_SENTIMENTALIZE_9074334910736712170)],
        &[(0b10010, &ENTRY_SENTIMENTALIZED_7395272655741592803)],
        &[(0b10010, &ENTRY_SENTIMENTALIZER_10892451054407203292)],
        &[(0b10010, &ENTRY_SENTIMENTALIZERS_4236225160895961849)],
        &[(0b10010, &ENTRY_SENTIMENTALIZES_11687838812874218316)],
        &[(0b10010, &ENTRY_SENTIMENTALIZING_9011281810726145623)],
        &[(0b01001, &ENTRY_SENTIMENTALIZATION_9061044606950222949)],
        &[(0b01001, &ENTRY_SENTIMENTALIZATIONS_17372211169793747786)],
        &[(0b01001, &ENTRY_SENTIMENTALIZE_9074334910736712170)],
        &[(0b01001, &ENTRY_SENTIMENTALIZED_7395272655741592803)],
        &[(0b01001, &ENTRY_SENTIMENTALIZER_10892451054407203292)],
        &[(0b01001, &ENTRY_SENTIMENTALIZERS_4236225160895961849)],
        &[(0b01001, &ENTRY_SENTIMENTALIZES_11687838812874218316)],
        &[(0b01001, &ENTRY_SENTIMENTALIZING_9011281810726145623)],
        &[(0b00001, &ENTRY_SENTINELED_15164238305822628477)],
        &[(0b00001, &ENTRY_SENTINELING_11104191602796418564)],
        &[(0b11010, &ENTRY_SENTINELED_15164238305822628477)],
        &[(0b11010, &ENTRY_SENTINELING_11104191602796418564)],
    ],
    range: 6..=15,
};

static VARS_SENS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SENS_CHILDREN),
    value: None,
};

pub static VARS_SENS_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ationalise"),
        dictgen::InsensitiveStr::Ascii("ationalised"),
        dictgen::InsensitiveStr::Ascii("ationalises"),
        dictgen::InsensitiveStr::Ascii("ationalising"),
        dictgen::InsensitiveStr::Ascii("ationalize"),
        dictgen::InsensitiveStr::Ascii("ationalized"),
        dictgen::InsensitiveStr::Ascii("ationalizes"),
        dictgen::InsensitiveStr::Ascii("ationalizing"),
        dictgen::InsensitiveStr::Ascii("ise"),
        dictgen::InsensitiveStr::Ascii("ises"),
        dictgen::InsensitiveStr::Ascii("itisation"),
        dictgen::InsensitiveStr::Ascii("itisations"),
        dictgen::InsensitiveStr::Ascii("itise"),
        dictgen::InsensitiveStr::Ascii("itised"),
        dictgen::InsensitiveStr::Ascii("itiser"),
        dictgen::InsensitiveStr::Ascii("itisers"),
        dictgen::InsensitiveStr::Ascii("itises"),
        dictgen::InsensitiveStr::Ascii("itising"),
        dictgen::InsensitiveStr::Ascii("itization"),
        dictgen::InsensitiveStr::Ascii("itizations"),
        dictgen::InsensitiveStr::Ascii("itize"),
        dictgen::InsensitiveStr::Ascii("itized"),
        dictgen::InsensitiveStr::Ascii("itizer"),
        dictgen::InsensitiveStr::Ascii("itizers"),
        dictgen::InsensitiveStr::Ascii("itizes"),
        dictgen::InsensitiveStr::Ascii("itizing"),
        dictgen::InsensitiveStr::Ascii("ize"),
        dictgen::InsensitiveStr::Ascii("izes"),
        dictgen::InsensitiveStr::Ascii("ualisation"),
        dictgen::InsensitiveStr::Ascii("ualisations"),
        dictgen::InsensitiveStr::Ascii("ualise"),
        dictgen::InsensitiveStr::Ascii("ualised"),
        dictgen::InsensitiveStr::Ascii("ualises"),
        dictgen::InsensitiveStr::Ascii("ualising"),
        dictgen::InsensitiveStr::Ascii("ualization"),
        dictgen::InsensitiveStr::Ascii("ualizations"),
        dictgen::InsensitiveStr::Ascii("ualize"),
        dictgen::InsensitiveStr::Ascii("ualized"),
        dictgen::InsensitiveStr::Ascii("ualizes"),
        dictgen::InsensitiveStr::Ascii("ualizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SENSATIONALIZE_3612877228613212928)],
        &[(0b10010, &ENTRY_SENSATIONALIZED_15672094773557124276)],
        &[(0b10010, &ENTRY_SENSATIONALIZES_6023223775469404764)],
        &[(0b10010, &ENTRY_SENSATIONALIZING_3700944391567555627)],
        &[(0b01001, &ENTRY_SENSATIONALIZE_3612877228613212928)],
        &[(0b01001, &ENTRY_SENSATIONALIZED_15672094773557124276)],
        &[(0b01001, &ENTRY_SENSATIONALIZES_6023223775469404764)],
        &[(0b01001, &ENTRY_SENSATIONALIZING_3700944391567555627)],
        &[(0b10010, &ENTRY_SENSIZE_17053253712096730252)],
        &[(0b10010, &ENTRY_SENSIZES_10006992614374882912)],
        &[(0b10010, &ENTRY_SENSITIZATION_5562142577083526555)],
        &[(0b10010, &ENTRY_SENSITIZATIONS_13654430266545943350)],
        &[(0b10010, &ENTRY_SENSITIZE_314572801275315620)],
        &[(0b10010, &ENTRY_SENSITIZED_3980543883168272054)],
        &[(0b10010, &ENTRY_SENSITIZER_10276855194832816189)],
        &[(0b10010, &ENTRY_SENSITIZERS_18244790979608274479)],
        &[(0b10010, &ENTRY_SENSITIZES_577413584210679666)],
        &[(0b10010, &ENTRY_SENSITIZING_7753308060738960399)],
        &[(0b01001, &ENTRY_SENSITIZATION_5562142577083526555)],
        &[(0b01001, &ENTRY_SENSITIZATIONS_13654430266545943350)],
        &[(0b01001, &ENTRY_SENSITIZE_314572801275315620)],
        &[(0b01001, &ENTRY_SENSITIZED_3980543883168272054)],
        &[(0b01001, &ENTRY_SENSITIZER_10276855194832816189)],
        &[(0b01001, &ENTRY_SENSITIZERS_18244790979608274479)],
        &[(0b01001, &ENTRY_SENSITIZES_577413584210679666)],
        &[(0b01001, &ENTRY_SENSITIZING_7753308060738960399)],
        &[(0b01001, &ENTRY_SENSIZE_17053253712096730252)],
        &[(0b01001, &ENTRY_SENSIZES_10006992614374882912)],
        &[(0b10010, &ENTRY_SENSUALIZATION_18438288000507867475)],
        &[(0b10010, &ENTRY_SENSUALIZATIONS_4903697434091196616)],
        &[(0b10010, &ENTRY_SENSUALIZE_16925018484398827656)],
        &[(0b10010, &ENTRY_SENSUALIZED_5812075572460333798)],
        &[(0b10010, &ENTRY_SENSUALIZES_6027047404814047775)],
        &[(0b10010, &ENTRY_SENSUALIZING_8787028083330334024)],
        &[(0b01001, &ENTRY_SENSUALIZATION_18438288000507867475)],
        &[(0b01001, &ENTRY_SENSUALIZATIONS_4903697434091196616)],
        &[(0b01001, &ENTRY_SENSUALIZE_16925018484398827656)],
        &[(0b01001, &ENTRY_SENSUALIZED_5812075572460333798)],
        &[(0b01001, &ENTRY_SENSUALIZES_6027047404814047775)],
        &[(0b01001, &ENTRY_SENSUALIZING_8787028083330334024)],
    ],
    range: 3..=12,
};

static VARS_SENI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SENI_CHILDREN),
    value: None,
};

pub static VARS_SENI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lise"),
        dictgen::InsensitiveStr::Ascii("lises"),
        dictgen::InsensitiveStr::Ascii("lize"),
        dictgen::InsensitiveStr::Ascii("lizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SENILIZE_8029621471742989343)],
        &[(0b10010, &ENTRY_SENILIZES_12383752921132409565)],
        &[(0b01001, &ENTRY_SENILIZE_8029621471742989343)],
        &[(0b01001, &ENTRY_SENILIZES_12383752921132409565)],
    ],
    range: 4..=5,
};

static VARS_SEM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SEM_CHILDREN),
    value: None,
};

static VARS_SEM_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_SEMA_NODE),
    None,
    None,
    None,
    Some(&VARS_SEME_NODE),
    None,
    None,
    None,
    Some(&VARS_SEMI_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SEMP_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_SEMP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEMP_CHILDREN),
    value: None,
};

pub static VARS_SEMP_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("re"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SEMPER_8108831112347458625)],
        &[(0b11010, &ENTRY_SEMPER_8108831112347458625)],
    ],
    range: 2..=2,
};

static VARS_SEMI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SEMI_CHILDREN),
    value: None,
};

static VARS_SEMI_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_SEMIA_NODE),
    None,
    Some(&VARS_SEMIC_NODE),
    None,
    None,
    Some(&VARS_SEMIF_NODE),
    None,
    Some(&VARS_SEMIH_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_SEMIM_NODE),
    Some(&VARS_SEMIN_NODE),
    Some(&VARS_SEMIO_NODE),
    Some(&VARS_SEMIP_NODE),
    None,
    None,
    None,
    Some(&VARS_SEMIT_NODE),
    None,
    Some(&VARS_SEMIV_NODE),
    None,
    None,
    None,
    None,
];

static VARS_SEMIV_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEMIV_CHILDREN),
    value: None,
};

pub static VARS_SEMIV_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ulcanised"),
        dictgen::InsensitiveStr::Ascii("ulcaniseds"),
        dictgen::InsensitiveStr::Ascii("ulcanized"),
        dictgen::InsensitiveStr::Ascii("ulcanizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SEMIVULCANIZED_14359220447980579562)],
        &[(0b10010, &ENTRY_SEMIVULCANIZEDS_13162744092050979464)],
        &[(0b01001, &ENTRY_SEMIVULCANIZED_14359220447980579562)],
        &[(0b01001, &ENTRY_SEMIVULCANIZEDS_13162744092050979464)],
    ],
    range: 9..=10,
};

static VARS_SEMIT_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEMIT_CHILDREN),
    value: None,
};

pub static VARS_SEMIT_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ae"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("icise"),
        dictgen::InsensitiveStr::Ascii("icises"),
        dictgen::InsensitiveStr::Ascii("icize"),
        dictgen::InsensitiveStr::Ascii("icizes"),
        dictgen::InsensitiveStr::Ascii("isation"),
        dictgen::InsensitiveStr::Ascii("isations"),
        dictgen::InsensitiveStr::Ascii("ise"),
        dictgen::InsensitiveStr::Ascii("ised"),
        dictgen::InsensitiveStr::Ascii("ises"),
        dictgen::InsensitiveStr::Ascii("ising"),
        dictgen::InsensitiveStr::Ascii("ization"),
        dictgen::InsensitiveStr::Ascii("izations"),
        dictgen::InsensitiveStr::Ascii("ize"),
        dictgen::InsensitiveStr::Ascii("ized"),
        dictgen::InsensitiveStr::Ascii("izes"),
        dictgen::InsensitiveStr::Ascii("izing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SEMITE_8050506285147736874)],
        &[(0b00001, &ENTRY_SEMITE_8050506285147736874)],
        &[(0b10010, &ENTRY_SEMITICIZE_2609826288107126486)],
        &[(0b10010, &ENTRY_SEMITICIZES_14074646105957764366)],
        &[(0b01001, &ENTRY_SEMITICIZE_2609826288107126486)],
        &[(0b01001, &ENTRY_SEMITICIZES_14074646105957764366)],
        &[(0b10010, &ENTRY_SEMITIZATION_2814386441666130450)],
        &[(0b10010, &ENTRY_SEMITIZATIONS_13807542369819114157)],
        &[(0b10010, &ENTRY_SEMITIZE_941534843473568569)],
        &[(0b10010, &ENTRY_SEMITIZED_17290416988749434330)],
        &[(0b10010, &ENTRY_SEMITIZES_11925278580314760912)],
        &[(0b10010, &ENTRY_SEMITIZING_2963320286843005115)],
        &[(0b01001, &ENTRY_SEMITIZATION_2814386441666130450)],
        &[(0b01001, &ENTRY_SEMITIZATIONS_13807542369819114157)],
        &[(0b01001, &ENTRY_SEMITIZE_941534843473568569)],
        &[(0b01001, &ENTRY_SEMITIZED_17290416988749434330)],
        &[(0b01001, &ENTRY_SEMITIZES_11925278580314760912)],
        &[(0b01001, &ENTRY_SEMITIZING_2963320286843005115)],
    ],
    range: 1..=8,
};

static VARS_SEMIP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEMIP_CHILDREN),
    value: None,
};

pub static VARS_SEMIP_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rofessionalised"),
        dictgen::InsensitiveStr::Ascii("rofessionaliseds"),
        dictgen::InsensitiveStr::Ascii("rofessionalized"),
        dictgen::InsensitiveStr::Ascii("rofessionalizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SEMIPROFESSIONALIZED_17328179078904677907)],
        &[(0b10010, &ENTRY_SEMIPROFESSIONALIZEDS_15921777243236052227)],
        &[(0b01001, &ENTRY_SEMIPROFESSIONALIZED_17328179078904677907)],
        &[(0b01001, &ENTRY_SEMIPROFESSIONALIZEDS_15921777243236052227)],
    ],
    range: 15..=16,
};

static VARS_SEMIO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEMIO_CHILDREN),
    value: None,
};

pub static VARS_SEMIO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rganised"),
        dictgen::InsensitiveStr::Ascii("rganiseds"),
        dictgen::InsensitiveStr::Ascii("rganized"),
        dictgen::InsensitiveStr::Ascii("rganizeds"),
        dictgen::InsensitiveStr::Ascii("xidised"),
        dictgen::InsensitiveStr::Ascii("xidiseds"),
        dictgen::InsensitiveStr::Ascii("xidized"),
        dictgen::InsensitiveStr::Ascii("xidizeds"),
        dictgen::InsensitiveStr::Ascii("xygenised"),
        dictgen::InsensitiveStr::Ascii("xygeniseds"),
        dictgen::InsensitiveStr::Ascii("xygenized"),
        dictgen::InsensitiveStr::Ascii("xygenizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SEMIORGANIZED_6555791236440295060)],
        &[(0b10010, &ENTRY_SEMIORGANIZEDS_12008364003973962769)],
        &[(0b01001, &ENTRY_SEMIORGANIZED_6555791236440295060)],
        &[(0b01001, &ENTRY_SEMIORGANIZEDS_12008364003973962769)],
        &[(0b10010, &ENTRY_SEMIOXIDIZED_5315770266537512020)],
        &[(0b10010, &ENTRY_SEMIOXIDIZEDS_6159043438844186188)],
        &[(0b01001, &ENTRY_SEMIOXIDIZED_5315770266537512020)],
        &[(0b01001, &ENTRY_SEMIOXIDIZEDS_6159043438844186188)],
        &[(0b10010, &ENTRY_SEMIOXYGENIZED_15324068707582079762)],
        &[(0b10010, &ENTRY_SEMIOXYGENIZEDS_2404118500235275979)],
        &[(0b01001, &ENTRY_SEMIOXYGENIZED_15324068707582079762)],
        &[(0b01001, &ENTRY_SEMIOXYGENIZEDS_2404118500235275979)],
    ],
    range: 7..=10,
};

static VARS_SEMIN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEMIN_CHILDREN),
    value: None,
};

pub static VARS_SEMIN_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arise"),
        dictgen::InsensitiveStr::Ascii("arises"),
        dictgen::InsensitiveStr::Ascii("arize"),
        dictgen::InsensitiveStr::Ascii("arizes"),
        dictgen::InsensitiveStr::Ascii("ationalisation"),
        dictgen::InsensitiveStr::Ascii("ationalisations"),
        dictgen::InsensitiveStr::Ascii("ationalization"),
        dictgen::InsensitiveStr::Ascii("ationalizations"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SEMINARIZE_16382184306789061126)],
        &[(0b10010, &ENTRY_SEMINARIZES_1867316917365228789)],
        &[(0b01001, &ENTRY_SEMINARIZE_16382184306789061126)],
        &[(0b01001, &ENTRY_SEMINARIZES_1867316917365228789)],
        &[(0b10010, &ENTRY_SEMINATIONALIZATION_14555714753335877358)],
        &[(0b10010, &ENTRY_SEMINATIONALIZATIONS_17200787028274260651)],
        &[(0b01001, &ENTRY_SEMINATIONALIZATION_14555714753335877358)],
        &[(0b01001, &ENTRY_SEMINATIONALIZATIONS_17200787028274260651)],
    ],
    range: 5..=15,
};

static VARS_SEMIM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEMIM_CHILDREN),
    value: None,
};

pub static VARS_SEMIM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ercerised"),
        dictgen::InsensitiveStr::Ascii("erceriseds"),
        dictgen::InsensitiveStr::Ascii("ercerized"),
        dictgen::InsensitiveStr::Ascii("ercerizeds"),
        dictgen::InsensitiveStr::Ascii("ineralised"),
        dictgen::InsensitiveStr::Ascii("ineraliseds"),
        dictgen::InsensitiveStr::Ascii("ineralized"),
        dictgen::InsensitiveStr::Ascii("ineralizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SEMIMERCERIZED_7395245349141510735)],
        &[(0b10010, &ENTRY_SEMIMERCERIZEDS_6499518726299354192)],
        &[(0b01001, &ENTRY_SEMIMERCERIZED_7395245349141510735)],
        &[(0b01001, &ENTRY_SEMIMERCERIZEDS_6499518726299354192)],
        &[(0b10010, &ENTRY_SEMIMINERALIZED_16937456193304785591)],
        &[(0b10010, &ENTRY_SEMIMINERALIZEDS_7867390791226894698)],
        &[(0b01001, &ENTRY_SEMIMINERALIZED_16937456193304785591)],
        &[(0b01001, &ENTRY_SEMIMINERALIZEDS_7867390791226894698)],
    ],
    range: 9..=11,
};

static VARS_SEMIH_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEMIH_CHILDREN),
    value: None,
};

pub static VARS_SEMIH_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("onor"),
        dictgen::InsensitiveStr::Ascii("onors"),
        dictgen::InsensitiveStr::Ascii("onour"),
        dictgen::InsensitiveStr::Ascii("onours"),
        dictgen::InsensitiveStr::Ascii("umanised"),
        dictgen::InsensitiveStr::Ascii("umaniseds"),
        dictgen::InsensitiveStr::Ascii("umanized"),
        dictgen::InsensitiveStr::Ascii("umanizeds"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SEMIHONOR_7457444383686448706)],
        &[(0b00001, &ENTRY_SEMIHONORS_12462123375978457923)],
        &[(0b11010, &ENTRY_SEMIHONOR_7457444383686448706)],
        &[(0b11010, &ENTRY_SEMIHONORS_12462123375978457923)],
        &[(0b10010, &ENTRY_SEMIHUMANIZED_17638546783529197556)],
        &[(0b10010, &ENTRY_SEMIHUMANIZEDS_17371974753621699342)],
        &[(0b01001, &ENTRY_SEMIHUMANIZED_17638546783529197556)],
        &[(0b01001, &ENTRY_SEMIHUMANIZEDS_17371974753621699342)],
    ],
    range: 4..=9,
};

static VARS_SEMIF_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEMIF_CHILDREN),
    value: None,
};

pub static VARS_SEMIF_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ossilised"),
        dictgen::InsensitiveStr::Ascii("ossiliseds"),
        dictgen::InsensitiveStr::Ascii("ossilized"),
        dictgen::InsensitiveStr::Ascii("ossilizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SEMIFOSSILIZED_9350071948098066704)],
        &[(0b10010, &ENTRY_SEMIFOSSILIZEDS_7710393663692254880)],
        &[(0b01001, &ENTRY_SEMIFOSSILIZED_9350071948098066704)],
        &[(0b01001, &ENTRY_SEMIFOSSILIZEDS_7710393663692254880)],
    ],
    range: 9..=10,
};

static VARS_SEMIC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEMIC_CHILDREN),
    value: None,
};

pub static VARS_SEMIC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arbonise"),
        dictgen::InsensitiveStr::Ascii("arbonises"),
        dictgen::InsensitiveStr::Ascii("arbonize"),
        dictgen::InsensitiveStr::Ascii("arbonizes"),
        dictgen::InsensitiveStr::Ascii("ivilisation"),
        dictgen::InsensitiveStr::Ascii("ivilisations"),
        dictgen::InsensitiveStr::Ascii("ivilised"),
        dictgen::InsensitiveStr::Ascii("iviliseds"),
        dictgen::InsensitiveStr::Ascii("ivilization"),
        dictgen::InsensitiveStr::Ascii("ivilizations"),
        dictgen::InsensitiveStr::Ascii("ivilized"),
        dictgen::InsensitiveStr::Ascii("ivilizeds"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SEMICARBONIZE_8409774805182130142)],
        &[(0b10010, &ENTRY_SEMICARBONIZES_1797293499149887442)],
        &[(0b01001, &ENTRY_SEMICARBONIZE_8409774805182130142)],
        &[(0b01001, &ENTRY_SEMICARBONIZES_1797293499149887442)],
        &[(0b10010, &ENTRY_SEMICIVILIZATION_15242671581564814120)],
        &[(0b10010, &ENTRY_SEMICIVILIZATIONS_5720575445164622576)],
        &[(0b10010, &ENTRY_SEMICIVILIZED_4637923957818205530)],
        &[(0b10010, &ENTRY_SEMICIVILIZEDS_2897438279018112835)],
        &[(0b01001, &ENTRY_SEMICIVILIZATION_15242671581564814120)],
        &[(0b01001, &ENTRY_SEMICIVILIZATIONS_5720575445164622576)],
        &[(0b01001, &ENTRY_SEMICIVILIZED_4637923957818205530)],
        &[(0b01001, &ENTRY_SEMICIVILIZEDS_2897438279018112835)],
    ],
    range: 8..=12,
};

static VARS_SEMIA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEMIA_CHILDREN),
    value: None,
};

pub static VARS_SEMIA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("naesthetic"),
        dictgen::InsensitiveStr::Ascii("nesthetic"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SEMIANESTHETIC_603220656140835402)],
        &[(0b00001, &ENTRY_SEMIANESTHETIC_603220656140835402)],
    ],
    range: 9..=10,
};

static VARS_SEME_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEME_CHILDREN),
    value: None,
};

pub static VARS_SEME_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("nov")],
    values: &[&[(0b00001, &ENTRY_SEMENOV_2935209069826757991)]],
    range: 3..=3,
};

static VARS_SEMA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEMA_CHILDREN),
    value: None,
};

pub static VARS_SEMA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("enov")],
    values: &[&[(0b11010, &ENTRY_SEMENOV_2935209069826757991)]],
    range: 4..=4,
};

static VARS_SEL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEL_CHILDREN),
    value: None,
};

pub static VARS_SEL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lae"),
        dictgen::InsensitiveStr::Ascii("le"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SELLE_12446852445813787272)],
        &[(0b00001, &ENTRY_SELLE_12446852445813787272)],
    ],
    range: 2..=3,
};

static VARS_SEI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEI_CHILDREN),
    value: None,
};

pub static VARS_SEI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("sable"),
        dictgen::InsensitiveStr::Ascii("ser"),
        dictgen::InsensitiveStr::Ascii("sers"),
        dictgen::InsensitiveStr::Ascii("sin"),
        dictgen::InsensitiveStr::Ascii("sings"),
        dictgen::InsensitiveStr::Ascii("sins"),
        dictgen::InsensitiveStr::Ascii("zable"),
        dictgen::InsensitiveStr::Ascii("zer"),
        dictgen::InsensitiveStr::Ascii("zers"),
        dictgen::InsensitiveStr::Ascii("zin"),
        dictgen::InsensitiveStr::Ascii("zings"),
        dictgen::InsensitiveStr::Ascii("zins"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SEIZABLE_6299895893787769311)],
        &[(0b10010, &ENTRY_SEIZER_12783623317695995317)],
        &[(0b10010, &ENTRY_SEIZERS_3311206369321638961)],
        &[(0b10010, &ENTRY_SEIZIN_7497048659697035283)],
        &[(0b10010, &ENTRY_SEIZINGS_4904640050385479436)],
        &[(0b10010, &ENTRY_SEIZINS_9859687246678890466)],
        &[(0b01001, &ENTRY_SEIZABLE_6299895893787769311)],
        &[(0b01001, &ENTRY_SEIZER_12783623317695995317)],
        &[(0b01001, &ENTRY_SEIZERS_3311206369321638961)],
        &[(0b01001, &ENTRY_SEIZIN_7497048659697035283)],
        &[(0b01001, &ENTRY_SEIZINGS_4904640050385479436)],
        &[(0b01001, &ENTRY_SEIZINS_9859687246678890466)],
    ],
    range: 3..=5,
};

static VARS_SEE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEE_CHILDREN),
    value: None,
};

pub static VARS_SEE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("d")],
    values: &[&[(0b00001, &ENTRY_SEED_321113364137294796)]],
    range: 1..=1,
};

static VARS_SEC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SEC_CHILDREN),
    value: None,
};

static VARS_SEC_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SECT_NODE),
    Some(&VARS_SECU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_SECU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SECU_CHILDREN),
    value: None,
};

pub static VARS_SECU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("larisation"),
        dictgen::InsensitiveStr::Ascii("larisations"),
        dictgen::InsensitiveStr::Ascii("larise"),
        dictgen::InsensitiveStr::Ascii("larised"),
        dictgen::InsensitiveStr::Ascii("lariser"),
        dictgen::InsensitiveStr::Ascii("larisers"),
        dictgen::InsensitiveStr::Ascii("larises"),
        dictgen::InsensitiveStr::Ascii("larising"),
        dictgen::InsensitiveStr::Ascii("larization"),
        dictgen::InsensitiveStr::Ascii("larizations"),
        dictgen::InsensitiveStr::Ascii("larize"),
        dictgen::InsensitiveStr::Ascii("larized"),
        dictgen::InsensitiveStr::Ascii("larizer"),
        dictgen::InsensitiveStr::Ascii("larizers"),
        dictgen::InsensitiveStr::Ascii("larizes"),
        dictgen::InsensitiveStr::Ascii("larizing"),
        dictgen::InsensitiveStr::Ascii("lum"),
        dictgen::InsensitiveStr::Ascii("lums"),
        dictgen::InsensitiveStr::Ascii("ritisation"),
        dictgen::InsensitiveStr::Ascii("ritisations"),
        dictgen::InsensitiveStr::Ascii("ritise"),
        dictgen::InsensitiveStr::Ascii("ritised"),
        dictgen::InsensitiveStr::Ascii("ritises"),
        dictgen::InsensitiveStr::Ascii("ritising"),
        dictgen::InsensitiveStr::Ascii("ritization"),
        dictgen::InsensitiveStr::Ascii("ritizations"),
        dictgen::InsensitiveStr::Ascii("ritize"),
        dictgen::InsensitiveStr::Ascii("ritized"),
        dictgen::InsensitiveStr::Ascii("ritizes"),
        dictgen::InsensitiveStr::Ascii("ritizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SECULARIZATION_4665508589899729279)],
        &[(0b10010, &ENTRY_SECULARIZATIONS_18385656083748383194)],
        &[(0b10010, &ENTRY_SECULARIZE_8691674226029598576)],
        &[(0b10010, &ENTRY_SECULARIZED_4356348361234297427)],
        &[(0b10010, &ENTRY_SECULARIZER_8531483256485763608)],
        &[(0b10010, &ENTRY_SECULARIZERS_959509276810245817)],
        &[(0b10010, &ENTRY_SECULARIZES_17808446279659322674)],
        &[(0b10010, &ENTRY_SECULARIZING_3038011191545839970)],
        &[(0b01001, &ENTRY_SECULARIZATION_4665508589899729279)],
        &[(0b01001, &ENTRY_SECULARIZATIONS_18385656083748383194)],
        &[(0b01001, &ENTRY_SECULARIZE_8691674226029598576)],
        &[(0b01001, &ENTRY_SECULARIZED_4356348361234297427)],
        &[(0b01001, &ENTRY_SECULARIZER_8531483256485763608)],
        &[(0b01001, &ENTRY_SECULARIZERS_959509276810245817)],
        &[(0b01001, &ENTRY_SECULARIZES_17808446279659322674)],
        &[(0b01001, &ENTRY_SECULARIZING_3038011191545839970)],
        &[(0b00001, &ENTRY_SECULUM_14580513950849648417)],
        &[(0b00001, &ENTRY_SECULUMS_1417148559086086183)],
        &[(0b10010, &ENTRY_SECURITIZATION_15104434495314939017)],
        &[(0b10010, &ENTRY_SECURITIZATIONS_14825154146636731025)],
        &[(0b10010, &ENTRY_SECURITIZE_14199237267948737829)],
        &[(0b10010, &ENTRY_SECURITIZED_3968791155978166897)],
        &[(0b10010, &ENTRY_SECURITIZES_964431635949451194)],
        &[(0b10010, &ENTRY_SECURITIZING_10216698736284529838)],
        &[(0b01001, &ENTRY_SECURITIZATION_15104434495314939017)],
        &[(0b01001, &ENTRY_SECURITIZATIONS_14825154146636731025)],
        &[(0b01001, &ENTRY_SECURITIZE_14199237267948737829)],
        &[(0b01001, &ENTRY_SECURITIZED_3968791155978166897)],
        &[(0b01001, &ENTRY_SECURITIZES_964431635949451194)],
        &[(0b01001, &ENTRY_SECURITIZING_10216698736284529838)],
    ],
    range: 3..=11,
};

static VARS_SECT_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SECT_CHILDREN),
    value: None,
};

pub static VARS_SECT_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arianisation"),
        dictgen::InsensitiveStr::Ascii("arianise"),
        dictgen::InsensitiveStr::Ascii("arianised"),
        dictgen::InsensitiveStr::Ascii("arianises"),
        dictgen::InsensitiveStr::Ascii("arianising"),
        dictgen::InsensitiveStr::Ascii("arianization"),
        dictgen::InsensitiveStr::Ascii("arianize"),
        dictgen::InsensitiveStr::Ascii("arianized"),
        dictgen::InsensitiveStr::Ascii("arianizes"),
        dictgen::InsensitiveStr::Ascii("arianizing"),
        dictgen::InsensitiveStr::Ascii("ionalisation"),
        dictgen::InsensitiveStr::Ascii("ionalisations"),
        dictgen::InsensitiveStr::Ascii("ionalise"),
        dictgen::InsensitiveStr::Ascii("ionalised"),
        dictgen::InsensitiveStr::Ascii("ionalises"),
        dictgen::InsensitiveStr::Ascii("ionalising"),
        dictgen::InsensitiveStr::Ascii("ionalization"),
        dictgen::InsensitiveStr::Ascii("ionalizations"),
        dictgen::InsensitiveStr::Ascii("ionalize"),
        dictgen::InsensitiveStr::Ascii("ionalized"),
        dictgen::InsensitiveStr::Ascii("ionalizes"),
        dictgen::InsensitiveStr::Ascii("ionalizing"),
        dictgen::InsensitiveStr::Ascii("ionisation"),
        dictgen::InsensitiveStr::Ascii("ionisations"),
        dictgen::InsensitiveStr::Ascii("ionise"),
        dictgen::InsensitiveStr::Ascii("ionised"),
        dictgen::InsensitiveStr::Ascii("ionises"),
        dictgen::InsensitiveStr::Ascii("ionising"),
        dictgen::InsensitiveStr::Ascii("ionization"),
        dictgen::InsensitiveStr::Ascii("ionizations"),
        dictgen::InsensitiveStr::Ascii("ionize"),
        dictgen::InsensitiveStr::Ascii("ionized"),
        dictgen::InsensitiveStr::Ascii("ionizes"),
        dictgen::InsensitiveStr::Ascii("ionizing"),
        dictgen::InsensitiveStr::Ascii("orisation"),
        dictgen::InsensitiveStr::Ascii("orisations"),
        dictgen::InsensitiveStr::Ascii("orise"),
        dictgen::InsensitiveStr::Ascii("orised"),
        dictgen::InsensitiveStr::Ascii("orises"),
        dictgen::InsensitiveStr::Ascii("orising"),
        dictgen::InsensitiveStr::Ascii("orization"),
        dictgen::InsensitiveStr::Ascii("orizations"),
        dictgen::InsensitiveStr::Ascii("orize"),
        dictgen::InsensitiveStr::Ascii("orized"),
        dictgen::InsensitiveStr::Ascii("orizes"),
        dictgen::InsensitiveStr::Ascii("orizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SECTARIANIZATION_10329500434104171538)],
        &[(0b10010, &ENTRY_SECTARIANIZE_1734665934956097961)],
        &[(0b10010, &ENTRY_SECTARIANIZED_4323075987609952650)],
        &[(0b10010, &ENTRY_SECTARIANIZES_16984853238843084036)],
        &[(0b10010, &ENTRY_SECTARIANIZING_16586872715969887648)],
        &[(0b01001, &ENTRY_SECTARIANIZATION_10329500434104171538)],
        &[(0b01001, &ENTRY_SECTARIANIZE_1734665934956097961)],
        &[(0b01001, &ENTRY_SECTARIANIZED_4323075987609952650)],
        &[(0b01001, &ENTRY_SECTARIANIZES_16984853238843084036)],
        &[(0b01001, &ENTRY_SECTARIANIZING_16586872715969887648)],
        &[(0b10010, &ENTRY_SECTIONALIZATION_7372956859343047861)],
        &[(0b10010, &ENTRY_SECTIONALIZATIONS_3982770312292073083)],
        &[(0b10010, &ENTRY_SECTIONALIZE_6731417115868692513)],
        &[(0b10010, &ENTRY_SECTIONALIZED_15063335524950991716)],
        &[(0b10010, &ENTRY_SECTIONALIZES_4950660755628313153)],
        &[(0b10010, &ENTRY_SECTIONALIZING_11106492791716994585)],
        &[(0b01001, &ENTRY_SECTIONALIZATION_7372956859343047861)],
        &[(0b01001, &ENTRY_SECTIONALIZATIONS_3982770312292073083)],
        &[(0b01001, &ENTRY_SECTIONALIZE_6731417115868692513)],
        &[(0b01001, &ENTRY_SECTIONALIZED_15063335524950991716)],
        &[(0b01001, &ENTRY_SECTIONALIZES_4950660755628313153)],
        &[(0b01001, &ENTRY_SECTIONALIZING_11106492791716994585)],
        &[(0b10010, &ENTRY_SECTIONIZATION_5059309185384353865)],
        &[(0b10010, &ENTRY_SECTIONIZATIONS_7138672770671968877)],
        &[(0b10010, &ENTRY_SECTIONIZE_3662925954380476587)],
        &[(0b10010, &ENTRY_SECTIONIZED_4875591137215667653)],
        &[(0b10010, &ENTRY_SECTIONIZES_6513394183804020021)],
        &[(0b10010, &ENTRY_SECTIONIZING_5472076843239971417)],
        &[(0b01001, &ENTRY_SECTIONIZATION_5059309185384353865)],
        &[(0b01001, &ENTRY_SECTIONIZATIONS_7138672770671968877)],
        &[(0b01001, &ENTRY_SECTIONIZE_3662925954380476587)],
        &[(0b01001, &ENTRY_SECTIONIZED_4875591137215667653)],
        &[(0b01001, &ENTRY_SECTIONIZES_6513394183804020021)],
        &[(0b01001, &ENTRY_SECTIONIZING_5472076843239971417)],
        &[(0b10010, &ENTRY_SECTORIZATION_13074208022324954117)],
        &[(0b10010, &ENTRY_SECTORIZATIONS_1272351990881337199)],
        &[(0b10010, &ENTRY_SECTORIZE_16349435987024198076)],
        &[(0b10010, &ENTRY_SECTORIZED_3551279836961169706)],
        &[(0b10010, &ENTRY_SECTORIZES_3606396525392350810)],
        &[(0b10010, &ENTRY_SECTORIZING_8533377571217926271)],
        &[(0b01001, &ENTRY_SECTORIZATION_13074208022324954117)],
        &[(0b01001, &ENTRY_SECTORIZATIONS_1272351990881337199)],
        &[(0b01001, &ENTRY_SECTORIZE_16349435987024198076)],
        &[(0b01001, &ENTRY_SECTORIZED_3551279836961169706)],
        &[(0b01001, &ENTRY_SECTORIZES_3606396525392350810)],
        &[(0b01001, &ENTRY_SECTORIZING_8533377571217926271)],
    ],
    range: 5..=13,
};

static VARS_SEB_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SEB_CHILDREN),
    value: None,
};

pub static VARS_SEB_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("orrhea"),
        dictgen::InsensitiveStr::Ascii("orrheas"),
        dictgen::InsensitiveStr::Ascii("orrheic"),
        dictgen::InsensitiveStr::Ascii("orrhoea"),
        dictgen::InsensitiveStr::Ascii("orrhoeas"),
        dictgen::InsensitiveStr::Ascii("orrhoeic"),
    ],
    values: &[
        &[(0b01001, &ENTRY_SEBORRHEA_5911144256699940196)],
        &[(0b01001, &ENTRY_SEBORRHEAS_17176346816866257994)],
        &[(0b01001, &ENTRY_SEBORRHEIC_1999320639299394735)],
        &[(0b10010, &ENTRY_SEBORRHEA_5911144256699940196)],
        &[(0b10010, &ENTRY_SEBORRHEAS_17176346816866257994)],
        &[(0b10010, &ENTRY_SEBORRHEIC_1999320639299394735)],
    ],
    range: 6..=8,
};

static VARS_SC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SC_CHILDREN),
    value: None,
};

static VARS_SC_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_SCA_NODE),
    None,
    None,
    None,
    Some(&VARS_SCE_NODE),
    None,
    None,
    Some(&VARS_SCH_NODE),
    Some(&VARS_SCI_NODE),
    None,
    None,
    Some(&VARS_SCL_NODE),
    None,
    None,
    Some(&VARS_SCO_NODE),
    None,
    None,
    Some(&VARS_SCR_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_SCR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SCR_CHILDREN),
    value: None,
};

pub static VARS_SCR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ipturalise"),
        dictgen::InsensitiveStr::Ascii("ipturalises"),
        dictgen::InsensitiveStr::Ascii("ipturalize"),
        dictgen::InsensitiveStr::Ascii("ipturalizes"),
        dictgen::InsensitiveStr::Ascii("utinisation"),
        dictgen::InsensitiveStr::Ascii("utinisations"),
        dictgen::InsensitiveStr::Ascii("utinise"),
        dictgen::InsensitiveStr::Ascii("utinised"),
        dictgen::InsensitiveStr::Ascii("utiniser"),
        dictgen::InsensitiveStr::Ascii("utinisers"),
        dictgen::InsensitiveStr::Ascii("utinises"),
        dictgen::InsensitiveStr::Ascii("utinising"),
        dictgen::InsensitiveStr::Ascii("utinisinglies"),
        dictgen::InsensitiveStr::Ascii("utinisingly"),
        dictgen::InsensitiveStr::Ascii("utinization"),
        dictgen::InsensitiveStr::Ascii("utinizations"),
        dictgen::InsensitiveStr::Ascii("utinize"),
        dictgen::InsensitiveStr::Ascii("utinized"),
        dictgen::InsensitiveStr::Ascii("utinizer"),
        dictgen::InsensitiveStr::Ascii("utinizers"),
        dictgen::InsensitiveStr::Ascii("utinizes"),
        dictgen::InsensitiveStr::Ascii("utinizing"),
        dictgen::InsensitiveStr::Ascii("utinizinglies"),
        dictgen::InsensitiveStr::Ascii("utinizingly"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SCRIPTURALIZE_16965719438311609740)],
        &[(0b10010, &ENTRY_SCRIPTURALIZES_6331235887129690543)],
        &[(0b01001, &ENTRY_SCRIPTURALIZE_16965719438311609740)],
        &[(0b01001, &ENTRY_SCRIPTURALIZES_6331235887129690543)],
        &[(0b10010, &ENTRY_SCRUTINIZATION_17415762227653222410)],
        &[(0b10010, &ENTRY_SCRUTINIZATIONS_16986534141035954565)],
        &[(0b10010, &ENTRY_SCRUTINIZE_2495160673295116727)],
        &[(0b10010, &ENTRY_SCRUTINIZED_138448923562603427)],
        &[(0b10010, &ENTRY_SCRUTINIZER_16787119409611200536)],
        &[(0b10010, &ENTRY_SCRUTINIZERS_9843755621018893931)],
        &[(0b10010, &ENTRY_SCRUTINIZES_14143862930988132210)],
        &[(0b10010, &ENTRY_SCRUTINIZING_10650157705768207198)],
        &[(0b10010, &ENTRY_SCRUTINIZINGLIES_6550131961437823868)],
        &[(0b10010, &ENTRY_SCRUTINIZINGLY_6838183545046867792)],
        &[(0b01001, &ENTRY_SCRUTINIZATION_17415762227653222410)],
        &[(0b01001, &ENTRY_SCRUTINIZATIONS_16986534141035954565)],
        &[(0b01001, &ENTRY_SCRUTINIZE_2495160673295116727)],
        &[(0b01001, &ENTRY_SCRUTINIZED_138448923562603427)],
        &[(0b01001, &ENTRY_SCRUTINIZER_16787119409611200536)],
        &[(0b01001, &ENTRY_SCRUTINIZERS_9843755621018893931)],
        &[(0b01001, &ENTRY_SCRUTINIZES_14143862930988132210)],
        &[(0b01001, &ENTRY_SCRUTINIZING_10650157705768207198)],
        &[(0b01001, &ENTRY_SCRUTINIZINGLIES_6550131961437823868)],
        &[(0b01001, &ENTRY_SCRUTINIZINGLY_6838183545046867792)],
    ],
    range: 7..=13,
};

static VARS_SCO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SCO_CHILDREN),
    value: None,
};

pub static VARS_SCO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rse"),
        dictgen::InsensitiveStr::Ascii("rsed"),
        dictgen::InsensitiveStr::Ascii("rses"),
        dictgen::InsensitiveStr::Ascii("rsing"),
        dictgen::InsensitiveStr::Ascii("tticise"),
        dictgen::InsensitiveStr::Ascii("tticised"),
        dictgen::InsensitiveStr::Ascii("tticises"),
        dictgen::InsensitiveStr::Ascii("tticising"),
        dictgen::InsensitiveStr::Ascii("tticize"),
        dictgen::InsensitiveStr::Ascii("tticized"),
        dictgen::InsensitiveStr::Ascii("tticizes"),
        dictgen::InsensitiveStr::Ascii("tticizing"),
        dictgen::InsensitiveStr::Ascii("urse"),
        dictgen::InsensitiveStr::Ascii("ursed"),
        dictgen::InsensitiveStr::Ascii("urses"),
        dictgen::InsensitiveStr::Ascii("ursing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SCORSE_15078698805947392168)],
        &[(0b00001, &ENTRY_SCORSED_16083267741792838932)],
        &[(0b00001, &ENTRY_SCORSES_7140175579256526605)],
        &[(0b00001, &ENTRY_SCORSING_3188653853529728017)],
        &[(0b10010, &ENTRY_SCOTTICIZE_17245280330015663168)],
        &[(0b10010, &ENTRY_SCOTTICIZED_9176139469703286390)],
        &[(0b10010, &ENTRY_SCOTTICIZES_4892539654566755234)],
        &[(0b10010, &ENTRY_SCOTTICIZING_2341284462577725385)],
        &[(0b01001, &ENTRY_SCOTTICIZE_17245280330015663168)],
        &[(0b01001, &ENTRY_SCOTTICIZED_9176139469703286390)],
        &[(0b01001, &ENTRY_SCOTTICIZES_4892539654566755234)],
        &[(0b01001, &ENTRY_SCOTTICIZING_2341284462577725385)],
        &[(0b11010, &ENTRY_SCORSE_15078698805947392168)],
        &[(0b11010, &ENTRY_SCORSED_16083267741792838932)],
        &[(0b11010, &ENTRY_SCORSES_7140175579256526605)],
        &[(0b11010, &ENTRY_SCORSING_3188653853529728017)],
    ],
    range: 3..=9,
};

static VARS_SCL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SCL_CHILDREN),
    value: None,
};

pub static VARS_SCL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("erae"),
        dictgen::InsensitiveStr::Ascii("ere"),
        dictgen::InsensitiveStr::Ascii("erotisation"),
        dictgen::InsensitiveStr::Ascii("erotise"),
        dictgen::InsensitiveStr::Ascii("erotised"),
        dictgen::InsensitiveStr::Ascii("erotises"),
        dictgen::InsensitiveStr::Ascii("erotising"),
        dictgen::InsensitiveStr::Ascii("erotization"),
        dictgen::InsensitiveStr::Ascii("erotize"),
        dictgen::InsensitiveStr::Ascii("erotized"),
        dictgen::InsensitiveStr::Ascii("erotizes"),
        dictgen::InsensitiveStr::Ascii("erotizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SCLERE_9746329931158778294)],
        &[(0b00001, &ENTRY_SCLERE_9746329931158778294)],
        &[(0b10010, &ENTRY_SCLEROTIZATION_15026971996955314482)],
        &[(0b10010, &ENTRY_SCLEROTIZE_11388338623919176754)],
        &[(0b10010, &ENTRY_SCLEROTIZED_13849096612293754473)],
        &[(0b10010, &ENTRY_SCLEROTIZES_15593295504016734858)],
        &[(0b10010, &ENTRY_SCLEROTIZING_5997112524177379321)],
        &[(0b01001, &ENTRY_SCLEROTIZATION_15026971996955314482)],
        &[(0b01001, &ENTRY_SCLEROTIZE_11388338623919176754)],
        &[(0b01001, &ENTRY_SCLEROTIZED_13849096612293754473)],
        &[(0b01001, &ENTRY_SCLEROTIZES_15593295504016734858)],
        &[(0b01001, &ENTRY_SCLEROTIZING_5997112524177379321)],
    ],
    range: 3..=11,
};

static VARS_SCI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SCI_CHILDREN),
    value: None,
};

pub static VARS_SCI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("entise"),
        dictgen::InsensitiveStr::Ascii("entised"),
        dictgen::InsensitiveStr::Ascii("entises"),
        dictgen::InsensitiveStr::Ascii("entising"),
        dictgen::InsensitiveStr::Ascii("entize"),
        dictgen::InsensitiveStr::Ascii("entized"),
        dictgen::InsensitiveStr::Ascii("entizes"),
        dictgen::InsensitiveStr::Ascii("entizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SCIENTIZE_10148514792697844596)],
        &[(0b10010, &ENTRY_SCIENTIZED_3311115608371296118)],
        &[(0b10010, &ENTRY_SCIENTIZES_16694012140134350335)],
        &[(0b10010, &ENTRY_SCIENTIZING_15849402639331786377)],
        &[(0b01001, &ENTRY_SCIENTIZE_10148514792697844596)],
        &[(0b01001, &ENTRY_SCIENTIZED_3311115608371296118)],
        &[(0b01001, &ENTRY_SCIENTIZES_16694012140134350335)],
        &[(0b01001, &ENTRY_SCIENTIZING_15849402639331786377)],
    ],
    range: 6..=8,
};

static VARS_SCH_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SCH_CHILDREN),
    value: None,
};

pub static VARS_SCH_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("edulise"),
        dictgen::InsensitiveStr::Ascii("edulises"),
        dictgen::InsensitiveStr::Ascii("edulize"),
        dictgen::InsensitiveStr::Ascii("edulizes"),
        dictgen::InsensitiveStr::Ascii("ematisation"),
        dictgen::InsensitiveStr::Ascii("ematisations"),
        dictgen::InsensitiveStr::Ascii("ematise"),
        dictgen::InsensitiveStr::Ascii("ematised"),
        dictgen::InsensitiveStr::Ascii("ematiser"),
        dictgen::InsensitiveStr::Ascii("ematisers"),
        dictgen::InsensitiveStr::Ascii("ematises"),
        dictgen::InsensitiveStr::Ascii("ematising"),
        dictgen::InsensitiveStr::Ascii("ematization"),
        dictgen::InsensitiveStr::Ascii("ematizations"),
        dictgen::InsensitiveStr::Ascii("ematize"),
        dictgen::InsensitiveStr::Ascii("ematized"),
        dictgen::InsensitiveStr::Ascii("ematizer"),
        dictgen::InsensitiveStr::Ascii("ematizers"),
        dictgen::InsensitiveStr::Ascii("ematizes"),
        dictgen::InsensitiveStr::Ascii("ematizing"),
        dictgen::InsensitiveStr::Ascii("illerisation"),
        dictgen::InsensitiveStr::Ascii("illerisations"),
        dictgen::InsensitiveStr::Ascii("illerise"),
        dictgen::InsensitiveStr::Ascii("illerised"),
        dictgen::InsensitiveStr::Ascii("illerises"),
        dictgen::InsensitiveStr::Ascii("illerising"),
        dictgen::InsensitiveStr::Ascii("illerization"),
        dictgen::InsensitiveStr::Ascii("illerizations"),
        dictgen::InsensitiveStr::Ascii("illerize"),
        dictgen::InsensitiveStr::Ascii("illerized"),
        dictgen::InsensitiveStr::Ascii("illerizes"),
        dictgen::InsensitiveStr::Ascii("illerizing"),
        dictgen::InsensitiveStr::Ascii("ismatise"),
        dictgen::InsensitiveStr::Ascii("ismatised"),
        dictgen::InsensitiveStr::Ascii("ismatises"),
        dictgen::InsensitiveStr::Ascii("ismatising"),
        dictgen::InsensitiveStr::Ascii("ismatize"),
        dictgen::InsensitiveStr::Ascii("ismatized"),
        dictgen::InsensitiveStr::Ascii("ismatizes"),
        dictgen::InsensitiveStr::Ascii("ismatizing"),
        dictgen::InsensitiveStr::Ascii("istocelia"),
        dictgen::InsensitiveStr::Ascii("istocoelia"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SCHEDULIZE_5696008845820733070)],
        &[(0b10010, &ENTRY_SCHEDULIZES_11998681560108042990)],
        &[(0b01001, &ENTRY_SCHEDULIZE_5696008845820733070)],
        &[(0b01001, &ENTRY_SCHEDULIZES_11998681560108042990)],
        &[(0b10010, &ENTRY_SCHEMATIZATION_12280133115355003981)],
        &[(0b10010, &ENTRY_SCHEMATIZATIONS_10214946104759561540)],
        &[(0b10010, &ENTRY_SCHEMATIZE_17242177807075430578)],
        &[(0b10010, &ENTRY_SCHEMATIZED_6065522728213827719)],
        &[(0b10010, &ENTRY_SCHEMATIZER_5371535585135012777)],
        &[(0b10010, &ENTRY_SCHEMATIZERS_4368175659338148324)],
        &[(0b10010, &ENTRY_SCHEMATIZES_5464172182149518273)],
        &[(0b10010, &ENTRY_SCHEMATIZING_5183188849408735782)],
        &[(0b01001, &ENTRY_SCHEMATIZATION_12280133115355003981)],
        &[(0b01001, &ENTRY_SCHEMATIZATIONS_10214946104759561540)],
        &[(0b01001, &ENTRY_SCHEMATIZE_17242177807075430578)],
        &[(0b01001, &ENTRY_SCHEMATIZED_6065522728213827719)],
        &[(0b01001, &ENTRY_SCHEMATIZER_5371535585135012777)],
        &[(0b01001, &ENTRY_SCHEMATIZERS_4368175659338148324)],
        &[(0b01001, &ENTRY_SCHEMATIZES_5464172182149518273)],
        &[(0b01001, &ENTRY_SCHEMATIZING_5183188849408735782)],
        &[(0b10010, &ENTRY_SCHILLERIZATION_1975534132552758492)],
        &[(0b10010, &ENTRY_SCHILLERIZATIONS_1097721139918947159)],
        &[(0b10010, &ENTRY_SCHILLERIZE_955273459416220138)],
        &[(0b10010, &ENTRY_SCHILLERIZED_8127379884079449773)],
        &[(0b10010, &ENTRY_SCHILLERIZES_7351365606194447161)],
        &[(0b10010, &ENTRY_SCHILLERIZING_10704749465715034583)],
        &[(0b01001, &ENTRY_SCHILLERIZATION_1975534132552758492)],
        &[(0b01001, &ENTRY_SCHILLERIZATIONS_1097721139918947159)],
        &[(0b01001, &ENTRY_SCHILLERIZE_955273459416220138)],
        &[(0b01001, &ENTRY_SCHILLERIZED_8127379884079449773)],
        &[(0b01001, &ENTRY_SCHILLERIZES_7351365606194447161)],
        &[(0b01001, &ENTRY_SCHILLERIZING_10704749465715034583)],
        &[(0b10010, &ENTRY_SCHISMATIZE_6430207238586664982)],
        &[(0b10010, &ENTRY_SCHISMATIZED_3002177619960082558)],
        &[(0b10010, &ENTRY_SCHISMATIZES_14979481534021263364)],
        &[(0b10010, &ENTRY_SCHISMATIZING_18224301025260482655)],
        &[(0b01001, &ENTRY_SCHISMATIZE_6430207238586664982)],
        &[(0b01001, &ENTRY_SCHISMATIZED_3002177619960082558)],
        &[(0b01001, &ENTRY_SCHISMATIZES_14979481534021263364)],
        &[(0b01001, &ENTRY_SCHISMATIZING_18224301025260482655)],
        &[(0b00001, &ENTRY_SCHISTOCELIA_3827142390073980619)],
        &[(0b11010, &ENTRY_SCHISTOCELIA_3827142390073980619)],
    ],
    range: 7..=13,
};

static VARS_SCE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SCE_CHILDREN),
    value: None,
};

pub static VARS_SCE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("na"),
        dictgen::InsensitiveStr::Ascii("narioisation"),
        dictgen::InsensitiveStr::Ascii("narioisations"),
        dictgen::InsensitiveStr::Ascii("narioise"),
        dictgen::InsensitiveStr::Ascii("narioises"),
        dictgen::InsensitiveStr::Ascii("narioization"),
        dictgen::InsensitiveStr::Ascii("narioizations"),
        dictgen::InsensitiveStr::Ascii("narioize"),
        dictgen::InsensitiveStr::Ascii("narioizes"),
        dictgen::InsensitiveStr::Ascii("narisation"),
        dictgen::InsensitiveStr::Ascii("narisations"),
        dictgen::InsensitiveStr::Ascii("narise"),
        dictgen::InsensitiveStr::Ascii("narised"),
        dictgen::InsensitiveStr::Ascii("narises"),
        dictgen::InsensitiveStr::Ascii("narising"),
        dictgen::InsensitiveStr::Ascii("narization"),
        dictgen::InsensitiveStr::Ascii("narizations"),
        dictgen::InsensitiveStr::Ascii("narize"),
        dictgen::InsensitiveStr::Ascii("narized"),
        dictgen::InsensitiveStr::Ascii("narizes"),
        dictgen::InsensitiveStr::Ascii("narizing"),
        dictgen::InsensitiveStr::Ascii("pter"),
        dictgen::InsensitiveStr::Ascii("pterdom"),
        dictgen::InsensitiveStr::Ascii("ptered"),
        dictgen::InsensitiveStr::Ascii("ptering"),
        dictgen::InsensitiveStr::Ascii("pterless"),
        dictgen::InsensitiveStr::Ascii("pterlesses"),
        dictgen::InsensitiveStr::Ascii("pters"),
        dictgen::InsensitiveStr::Ascii("ptic"),
        dictgen::InsensitiveStr::Ascii("ptical"),
        dictgen::InsensitiveStr::Ascii("pticaler"),
        dictgen::InsensitiveStr::Ascii("pticalest"),
        dictgen::InsensitiveStr::Ascii("ptically"),
        dictgen::InsensitiveStr::Ascii("pticer"),
        dictgen::InsensitiveStr::Ascii("pticest"),
        dictgen::InsensitiveStr::Ascii("pticism"),
        dictgen::InsensitiveStr::Ascii("pticisms"),
        dictgen::InsensitiveStr::Ascii("ptics"),
        dictgen::InsensitiveStr::Ascii("ptre"),
        dictgen::InsensitiveStr::Ascii("ptred"),
        dictgen::InsensitiveStr::Ascii("ptredom"),
        dictgen::InsensitiveStr::Ascii("ptreless"),
        dictgen::InsensitiveStr::Ascii("ptrelesses"),
        dictgen::InsensitiveStr::Ascii("ptres"),
        dictgen::InsensitiveStr::Ascii("ptring"),
        dictgen::InsensitiveStr::Ascii("vor"),
        dictgen::InsensitiveStr::Ascii("vour"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SCENA_13970174413239259767)],
        &[(0b10010, &ENTRY_SCENARIOIZATION_11568016783832907853)],
        &[(0b10010, &ENTRY_SCENARIOIZATIONS_5354132606433153264)],
        &[(0b10010, &ENTRY_SCENARIOIZE_10573641030848141241)],
        &[(0b10010, &ENTRY_SCENARIOIZES_482550746480154259)],
        &[(0b01001, &ENTRY_SCENARIOIZATION_11568016783832907853)],
        &[(0b01001, &ENTRY_SCENARIOIZATIONS_5354132606433153264)],
        &[(0b01001, &ENTRY_SCENARIOIZE_10573641030848141241)],
        &[(0b01001, &ENTRY_SCENARIOIZES_482550746480154259)],
        &[(0b10010, &ENTRY_SCENARIZATION_8267687093775898269)],
        &[(0b10010, &ENTRY_SCENARIZATIONS_15320566627597434538)],
        &[(0b10010, &ENTRY_SCENARIZE_7764842416771702084)],
        &[(0b10010, &ENTRY_SCENARIZED_13846545490430585820)],
        &[(0b10010, &ENTRY_SCENARIZES_843838764401688514)],
        &[(0b10010, &ENTRY_SCENARIZING_4139993347505235123)],
        &[(0b01001, &ENTRY_SCENARIZATION_8267687093775898269)],
        &[(0b01001, &ENTRY_SCENARIZATIONS_15320566627597434538)],
        &[(0b01001, &ENTRY_SCENARIZE_7764842416771702084)],
        &[(0b01001, &ENTRY_SCENARIZED_13846545490430585820)],
        &[(0b01001, &ENTRY_SCENARIZES_843838764401688514)],
        &[(0b01001, &ENTRY_SCENARIZING_4139993347505235123)],
        &[(0b00001, &ENTRY_SCEPTER_2634314741124349621)],
        &[(0b00001, &ENTRY_SCEPTERDOM_17727578002621263233)],
        &[(0b00001, &ENTRY_SCEPTERED_4309367457883178779)],
        &[(0b00001, &ENTRY_SCEPTERING_11235334755425728893)],
        &[(0b00001, &ENTRY_SCEPTERLESS_14014584389608395039)],
        &[(0b00001, &ENTRY_SCEPTERLESSES_3211886999266482763)],
        &[(0b00001, &ENTRY_SCEPTERS_17320251109355012747)],
        &[(0b11010, &ENTRY_SKEPTIC_9366141399207033866)],
        &[(0b11010, &ENTRY_SKEPTICAL_7567920697289876244)],
        &[(0b11010, &ENTRY_SKEPTICALER_3504236392319734868)],
        &[(0b11010, &ENTRY_SKEPTICALEST_1822492830960306797)],
        &[(0b11010, &ENTRY_SKEPTICALLY_15015708074924057237)],
        &[(0b11010, &ENTRY_SKEPTICER_2654895074232389427)],
        &[(0b11010, &ENTRY_SKEPTICEST_13124338123587490640)],
        &[(0b11010, &ENTRY_SKEPTICISM_16324594783111490926)],
        &[(0b11010, &ENTRY_SKEPTICISMS_9470460390001384677)],
        &[(0b11010, &ENTRY_SKEPTICS_13432613087589375835)],
        &[(0b11010, &ENTRY_SCEPTER_2634314741124349621)],
        &[(0b11010, &ENTRY_SCEPTERED_4309367457883178779)],
        &[(0b11010, &ENTRY_SCEPTERDOM_17727578002621263233)],
        &[(0b11010, &ENTRY_SCEPTERLESS_14014584389608395039)],
        &[(0b11010, &ENTRY_SCEPTERLESSES_3211886999266482763)],
        &[(0b11010, &ENTRY_SCEPTERS_17320251109355012747)],
        &[(0b11010, &ENTRY_SCEPTERING_11235334755425728893)],
        &[(0b00001, &ENTRY_SCEVOR_17742563930876297446)],
        &[(0b11010, &ENTRY_SCEVOR_17742563930876297446)],
    ],
    range: 2..=13,
};

static VARS_SCA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SCA_CHILDREN),
    value: None,
};

pub static VARS_SCA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ena"),
        dictgen::InsensitiveStr::Ascii("ndaled"),
        dictgen::InsensitiveStr::Ascii("ndaling"),
        dictgen::InsensitiveStr::Ascii("ndalisation"),
        dictgen::InsensitiveStr::Ascii("ndalisations"),
        dictgen::InsensitiveStr::Ascii("ndalise"),
        dictgen::InsensitiveStr::Ascii("ndalised"),
        dictgen::InsensitiveStr::Ascii("ndaliser"),
        dictgen::InsensitiveStr::Ascii("ndalisers"),
        dictgen::InsensitiveStr::Ascii("ndalises"),
        dictgen::InsensitiveStr::Ascii("ndalising"),
        dictgen::InsensitiveStr::Ascii("ndalization"),
        dictgen::InsensitiveStr::Ascii("ndalizations"),
        dictgen::InsensitiveStr::Ascii("ndalize"),
        dictgen::InsensitiveStr::Ascii("ndalized"),
        dictgen::InsensitiveStr::Ascii("ndalizer"),
        dictgen::InsensitiveStr::Ascii("ndalizers"),
        dictgen::InsensitiveStr::Ascii("ndalizes"),
        dictgen::InsensitiveStr::Ascii("ndalizing"),
        dictgen::InsensitiveStr::Ascii("ndalled"),
        dictgen::InsensitiveStr::Ascii("ndalling"),
        dictgen::InsensitiveStr::Ascii("paed"),
        dictgen::InsensitiveStr::Ascii("ped"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SCENA_13970174413239259767)],
        &[(0b00001, &ENTRY_SCANDALED_1881652881768607660)],
        &[(0b00001, &ENTRY_SCANDALING_6393905647064815426)],
        &[(0b10010, &ENTRY_SCANDALIZATION_1685701550263872659)],
        &[(0b10010, &ENTRY_SCANDALIZATIONS_7898720696120879071)],
        &[(0b10010, &ENTRY_SCANDALIZE_14741991033789550594)],
        &[(0b10010, &ENTRY_SCANDALIZED_11085730138699741279)],
        &[(0b10010, &ENTRY_SCANDALIZER_5001392876013065734)],
        &[(0b10010, &ENTRY_SCANDALIZERS_15197543038839412069)],
        &[(0b10010, &ENTRY_SCANDALIZES_11290093653234602832)],
        &[(0b10010, &ENTRY_SCANDALIZING_3021901097391350682)],
        &[(0b01001, &ENTRY_SCANDALIZATION_1685701550263872659)],
        &[(0b01001, &ENTRY_SCANDALIZATIONS_7898720696120879071)],
        &[(0b01001, &ENTRY_SCANDALIZE_14741991033789550594)],
        &[(0b01001, &ENTRY_SCANDALIZED_11085730138699741279)],
        &[(0b01001, &ENTRY_SCANDALIZER_5001392876013065734)],
        &[(0b01001, &ENTRY_SCANDALIZERS_15197543038839412069)],
        &[(0b01001, &ENTRY_SCANDALIZES_11290093653234602832)],
        &[(0b01001, &ENTRY_SCANDALIZING_3021901097391350682)],
        &[(0b11010, &ENTRY_SCANDALED_1881652881768607660)],
        &[(0b11010, &ENTRY_SCANDALING_6393905647064815426)],
        &[(0b11010, &ENTRY_SCAPED_11838614965333604867)],
        &[(0b00001, &ENTRY_SCAPED_11838614965333604867)],
    ],
    range: 3..=12,
};

static VARS_SA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SA_CHILDREN),
    value: None,
};

static VARS_SA_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_SAB_NODE),
    Some(&VARS_SAC_NODE),
    None,
    Some(&VARS_SAE_NODE),
    Some(&VARS_SAF_NODE),
    None,
    None,
    Some(&VARS_SAI_NODE),
    None,
    None,
    Some(&VARS_SAL_NODE),
    None,
    Some(&VARS_SAN_NODE),
    None,
    Some(&VARS_SAP_NODE),
    None,
    Some(&VARS_SAR_NODE),
    Some(&VARS_SAS_NODE),
    Some(&VARS_SAT_NODE),
    None,
    Some(&VARS_SAV_NODE),
    None,
    Some(&VARS_SAX_NODE),
    None,
    None,
];

static VARS_SAX_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SAX_CHILDREN),
    value: None,
};

pub static VARS_SAX_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("onisation"),
        dictgen::InsensitiveStr::Ascii("onisations"),
        dictgen::InsensitiveStr::Ascii("onise"),
        dictgen::InsensitiveStr::Ascii("onised"),
        dictgen::InsensitiveStr::Ascii("onises"),
        dictgen::InsensitiveStr::Ascii("onising"),
        dictgen::InsensitiveStr::Ascii("onization"),
        dictgen::InsensitiveStr::Ascii("onizations"),
        dictgen::InsensitiveStr::Ascii("onize"),
        dictgen::InsensitiveStr::Ascii("onized"),
        dictgen::InsensitiveStr::Ascii("onizes"),
        dictgen::InsensitiveStr::Ascii("onizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SAXONIZATION_13920447163448605602)],
        &[(0b10010, &ENTRY_SAXONIZATIONS_2318853882636501152)],
        &[(0b10010, &ENTRY_SAXONIZE_9115638203834180868)],
        &[(0b10010, &ENTRY_SAXONIZED_12370590955724966093)],
        &[(0b10010, &ENTRY_SAXONIZES_5168843153581210465)],
        &[(0b10010, &ENTRY_SAXONIZING_15329045328723618614)],
        &[(0b01001, &ENTRY_SAXONIZATION_13920447163448605602)],
        &[(0b01001, &ENTRY_SAXONIZATIONS_2318853882636501152)],
        &[(0b01001, &ENTRY_SAXONIZE_9115638203834180868)],
        &[(0b01001, &ENTRY_SAXONIZED_12370590955724966093)],
        &[(0b01001, &ENTRY_SAXONIZES_5168843153581210465)],
        &[(0b01001, &ENTRY_SAXONIZING_15329045328723618614)],
    ],
    range: 5..=10,
};

static VARS_SAV_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_SAV_CHILDREN),
    value: None,
};

static VARS_SAV_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_SAVA_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SAVI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_SAVO_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_SAVO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SAVO_CHILDREN),
    value: None,
};

pub static VARS_SAVO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("r"),
        dictgen::InsensitiveStr::Ascii("red"),
        dictgen::InsensitiveStr::Ascii("rer"),
        dictgen::InsensitiveStr::Ascii("rers"),
        dictgen::InsensitiveStr::Ascii("rier"),
        dictgen::InsensitiveStr::Ascii("ries"),
        dictgen::InsensitiveStr::Ascii("riest"),
        dictgen::InsensitiveStr::Ascii("rilies"),
        dictgen::InsensitiveStr::Ascii("rily"),
        dictgen::InsensitiveStr::Ascii("riness"),
        dictgen::InsensitiveStr::Ascii("rinesses"),
        dictgen::InsensitiveStr::Ascii("ring"),
        dictgen::InsensitiveStr::Ascii("ringlier"),
        dictgen::InsensitiveStr::Ascii("ringlies"),
        dictgen::InsensitiveStr::Ascii("ringliest"),
        dictgen::InsensitiveStr::Ascii("ringly"),
        dictgen::InsensitiveStr::Ascii("rless"),
        dictgen::InsensitiveStr::Ascii("rlesser"),
        dictgen::InsensitiveStr::Ascii("rlesses"),
        dictgen::InsensitiveStr::Ascii("rlessest"),
        dictgen::InsensitiveStr::Ascii("rly"),
        dictgen::InsensitiveStr::Ascii("rous"),
        dictgen::InsensitiveStr::Ascii("rouser"),
        dictgen::InsensitiveStr::Ascii("rousest"),
        dictgen::InsensitiveStr::Ascii("rs"),
        dictgen::InsensitiveStr::Ascii("ry"),
        dictgen::InsensitiveStr::Ascii("ur"),
        dictgen::InsensitiveStr::Ascii("ured"),
        dictgen::InsensitiveStr::Ascii("urer"),
        dictgen::InsensitiveStr::Ascii("urers"),
        dictgen::InsensitiveStr::Ascii("urier"),
        dictgen::InsensitiveStr::Ascii("uries"),
        dictgen::InsensitiveStr::Ascii("uriest"),
        dictgen::InsensitiveStr::Ascii("urilies"),
        dictgen::InsensitiveStr::Ascii("urily"),
        dictgen::InsensitiveStr::Ascii("uriness"),
        dictgen::InsensitiveStr::Ascii("urinesses"),
        dictgen::InsensitiveStr::Ascii("uring"),
        dictgen::InsensitiveStr::Ascii("uringlier"),
        dictgen::InsensitiveStr::Ascii("uringlies"),
        dictgen::InsensitiveStr::Ascii("uringliest"),
        dictgen::InsensitiveStr::Ascii("uringly"),
        dictgen::InsensitiveStr::Ascii("urless"),
        dictgen::InsensitiveStr::Ascii("urlesser"),
        dictgen::InsensitiveStr::Ascii("urlesses"),
        dictgen::InsensitiveStr::Ascii("urlessest"),
        dictgen::InsensitiveStr::Ascii("urly"),
        dictgen::InsensitiveStr::Ascii("urous"),
        dictgen::InsensitiveStr::Ascii("urouser"),
        dictgen::InsensitiveStr::Ascii("urousest"),
        dictgen::InsensitiveStr::Ascii("urs"),
        dictgen::InsensitiveStr::Ascii("ury"),
    ],
    values: &[
        &[(0b11001, &ENTRY_SAVOR_7268353245862880587)],
        &[(0b11001, &ENTRY_SAVORED_17866382687586191735)],
        &[(0b11001, &ENTRY_SAVORER_15451082667887423810)],
        &[(0b11001, &ENTRY_SAVORERS_11787687508614999748)],
        &[(0b11001, &ENTRY_SAVORIER_6303687459165405447)],
        &[(0b11001, &ENTRY_SAVORIES_9905015268014283974)],
        &[(0b11001, &ENTRY_SAVORIEST_17206072645132615270)],
        &[(0b11001, &ENTRY_SAVORILIES_6579003325829163067)],
        &[(0b11001, &ENTRY_SAVORILY_15448585721024708912)],
        &[(0b11001, &ENTRY_SAVORINESS_13968014337021909965)],
        &[(0b11001, &ENTRY_SAVORINESSES_10065971623388592088)],
        &[(0b11001, &ENTRY_SAVORING_6763000239615004808)],
        &[(0b11001, &ENTRY_SAVORINGLIER_10137328596366632769)],
        &[(0b11001, &ENTRY_SAVORINGLIES_16962535350125218546)],
        &[(0b11001, &ENTRY_SAVORINGLIEST_15169226019310047256)],
        &[(0b11001, &ENTRY_SAVORINGLY_188792191137435132)],
        &[(0b11001, &ENTRY_SAVORLESS_8806630377030275637)],
        &[(0b11001, &ENTRY_SAVORLESSER_15665106123472425180)],
        &[(0b11001, &ENTRY_SAVORLESSES_7670792878511449933)],
        &[(0b11001, &ENTRY_SAVORLESSEST_9190940621548012509)],
        &[(0b11001, &ENTRY_SAVORLY_7024626808530014518)],
        &[(0b00001, &ENTRY_SAVOROUS_11062427848542635268)],
        &[(0b00001, &ENTRY_SAVOROUSER_1727203765225429536)],
        &[(0b00001, &ENTRY_SAVOROUSEST_3100516665411914597)],
        &[(0b11001, &ENTRY_SAVORS_17864742679821873261)],
        &[(0b11001, &ENTRY_SAVORY_18035223196990312431)],
        &[(0b11010, &ENTRY_SAVOR_7268353245862880587)],
        &[(0b11010, &ENTRY_SAVORED_17866382687586191735)],
        &[(0b11010, &ENTRY_SAVORER_15451082667887423810)],
        &[(0b11010, &ENTRY_SAVORERS_11787687508614999748)],
        &[(0b11010, &ENTRY_SAVORIER_6303687459165405447)],
        &[(0b11010, &ENTRY_SAVORIES_9905015268014283974)],
        &[(0b11010, &ENTRY_SAVORIEST_17206072645132615270)],
        &[(0b11010, &ENTRY_SAVORILIES_6579003325829163067)],
        &[(0b11010, &ENTRY_SAVORILY_15448585721024708912)],
        &[(0b11010, &ENTRY_SAVORINESS_13968014337021909965)],
        &[(0b11010, &ENTRY_SAVORINESSES_10065971623388592088)],
        &[(0b11010, &ENTRY_SAVORING_6763000239615004808)],
        &[(0b11010, &ENTRY_SAVORINGLIER_10137328596366632769)],
        &[(0b11010, &ENTRY_SAVORINGLIES_16962535350125218546)],
        &[(0b11010, &ENTRY_SAVORINGLIEST_15169226019310047256)],
        &[(0b11010, &ENTRY_SAVORINGLY_188792191137435132)],
        &[(0b11010, &ENTRY_SAVORLESS_8806630377030275637)],
        &[(0b11010, &ENTRY_SAVORLESSER_15665106123472425180)],
        &[(0b11010, &ENTRY_SAVORLESSES_7670792878511449933)],
        &[(0b11010, &ENTRY_SAVORLESSEST_9190940621548012509)],
        &[(0b11010, &ENTRY_SAVORLY_7024626808530014518)],
        &[(0b11010, &ENTRY_SAVOROUS_11062427848542635268)],
        &[(0b11010, &ENTRY_SAVOROUSER_1727203765225429536)],
        &[(0b11010, &ENTRY_SAVOROUSEST_3100516665411914597)],
        &[(0b11010, &ENTRY_SAVORS_17864742679821873261)],
        &[(0b11010, &ENTRY_SAVORY_18035223196990312431)],
    ],
    range: 1..=10,
};

static VARS_SAVI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SAVI_CHILDREN),
    value: None,
};

pub static VARS_SAVI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("or"),
        dictgen::InsensitiveStr::Ascii("oress"),
        dictgen::InsensitiveStr::Ascii("orhood"),
        dictgen::InsensitiveStr::Ascii("orhoods"),
        dictgen::InsensitiveStr::Ascii("ors"),
        dictgen::InsensitiveStr::Ascii("orship"),
        dictgen::InsensitiveStr::Ascii("orships"),
        dictgen::InsensitiveStr::Ascii("our"),
        dictgen::InsensitiveStr::Ascii("ouress"),
        dictgen::InsensitiveStr::Ascii("ourhood"),
        dictgen::InsensitiveStr::Ascii("ourhoods"),
        dictgen::InsensitiveStr::Ascii("ours"),
        dictgen::InsensitiveStr::Ascii("ourship"),
        dictgen::InsensitiveStr::Ascii("ourships"),
    ],
    values: &[
        &[(0b11001, &ENTRY_SAVIOR_11215020799589174317)],
        &[(0b00001, &ENTRY_SAVIORESS_8494654417327749250)],
        &[(0b11001, &ENTRY_SAVIORHOOD_2729791171284683689)],
        &[(0b11001, &ENTRY_SAVIORHOODS_2311230659362646694)],
        &[(0b11001, &ENTRY_SAVIORS_13252400093779282591)],
        &[(0b11001, &ENTRY_SAVIORSHIP_2762957268664282572)],
        &[(0b11001, &ENTRY_SAVIORSHIPS_11936339798406737592)],
        &[(0b11010, &ENTRY_SAVIOR_11215020799589174317)],
        &[(0b11010, &ENTRY_SAVIORESS_8494654417327749250)],
        &[(0b11010, &ENTRY_SAVIORHOOD_2729791171284683689)],
        &[(0b11010, &ENTRY_SAVIORHOODS_2311230659362646694)],
        &[(0b11010, &ENTRY_SAVIORS_13252400093779282591)],
        &[(0b11010, &ENTRY_SAVIORSHIP_2762957268664282572)],
        &[(0b11010, &ENTRY_SAVIORSHIPS_11936339798406737592)],
    ],
    range: 2..=8,
};

static VARS_SAVA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SAVA_CHILDREN),
    value: None,
};

pub static VARS_SAVA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gise"),
        dictgen::InsensitiveStr::Ascii("gises"),
        dictgen::InsensitiveStr::Ascii("gize"),
        dictgen::InsensitiveStr::Ascii("gizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SAVAGIZE_826547977271561744)],
        &[(0b10010, &ENTRY_SAVAGIZES_3717388500719289056)],
        &[(0b01001, &ENTRY_SAVAGIZE_826547977271561744)],
        &[(0b01001, &ENTRY_SAVAGIZES_3717388500719289056)],
    ],
    range: 4..=5,
};

static VARS_SAT_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SAT_CHILDREN),
    value: None,
};

pub static VARS_SAT_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("anise"),
        dictgen::InsensitiveStr::Ascii("anises"),
        dictgen::InsensitiveStr::Ascii("anize"),
        dictgen::InsensitiveStr::Ascii("anizes"),
        dictgen::InsensitiveStr::Ascii("ellitise"),
        dictgen::InsensitiveStr::Ascii("ellitised"),
        dictgen::InsensitiveStr::Ascii("ellitises"),
        dictgen::InsensitiveStr::Ascii("ellitising"),
        dictgen::InsensitiveStr::Ascii("ellitize"),
        dictgen::InsensitiveStr::Ascii("ellitized"),
        dictgen::InsensitiveStr::Ascii("ellitizes"),
        dictgen::InsensitiveStr::Ascii("ellitizing"),
        dictgen::InsensitiveStr::Ascii("inise"),
        dictgen::InsensitiveStr::Ascii("inises"),
        dictgen::InsensitiveStr::Ascii("inize"),
        dictgen::InsensitiveStr::Ascii("inizes"),
        dictgen::InsensitiveStr::Ascii("irisable"),
        dictgen::InsensitiveStr::Ascii("irisables"),
        dictgen::InsensitiveStr::Ascii("irisation"),
        dictgen::InsensitiveStr::Ascii("irise"),
        dictgen::InsensitiveStr::Ascii("irised"),
        dictgen::InsensitiveStr::Ascii("iriser"),
        dictgen::InsensitiveStr::Ascii("irisers"),
        dictgen::InsensitiveStr::Ascii("irises"),
        dictgen::InsensitiveStr::Ascii("irising"),
        dictgen::InsensitiveStr::Ascii("irizable"),
        dictgen::InsensitiveStr::Ascii("irizables"),
        dictgen::InsensitiveStr::Ascii("irization"),
        dictgen::InsensitiveStr::Ascii("irize"),
        dictgen::InsensitiveStr::Ascii("irized"),
        dictgen::InsensitiveStr::Ascii("irizer"),
        dictgen::InsensitiveStr::Ascii("irizers"),
        dictgen::InsensitiveStr::Ascii("irizes"),
        dictgen::InsensitiveStr::Ascii("irizing"),
        dictgen::InsensitiveStr::Ascii("ivae"),
        dictgen::InsensitiveStr::Ascii("ive"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SATANIZE_2951447326962462423)],
        &[(0b10010, &ENTRY_SATANIZES_4037603454744610431)],
        &[(0b01001, &ENTRY_SATANIZE_2951447326962462423)],
        &[(0b01001, &ENTRY_SATANIZES_4037603454744610431)],
        &[(0b10010, &ENTRY_SATELLITIZE_1312953346097302445)],
        &[(0b10010, &ENTRY_SATELLITIZED_4530790908872238564)],
        &[(0b10010, &ENTRY_SATELLITIZES_15756736520028846542)],
        &[(0b10010, &ENTRY_SATELLITIZING_5844820839355010398)],
        &[(0b01001, &ENTRY_SATELLITIZE_1312953346097302445)],
        &[(0b01001, &ENTRY_SATELLITIZED_4530790908872238564)],
        &[(0b01001, &ENTRY_SATELLITIZES_15756736520028846542)],
        &[(0b01001, &ENTRY_SATELLITIZING_5844820839355010398)],
        &[(0b10010, &ENTRY_SATINIZE_12856779838184407064)],
        &[(0b10010, &ENTRY_SATINIZES_542674649787102689)],
        &[(0b01001, &ENTRY_SATINIZE_12856779838184407064)],
        &[(0b01001, &ENTRY_SATINIZES_542674649787102689)],
        &[(0b10010, &ENTRY_SATIRIZABLE_2981879413723745381)],
        &[(0b10010, &ENTRY_SATIRIZABLES_12495079216543111113)],
        &[(0b10010, &ENTRY_SATIRIZATION_5803523737972554169)],
        &[(0b10010, &ENTRY_SATIRIZE_4670452432959122101)],
        &[(0b10010, &ENTRY_SATIRIZED_7754739640320301410)],
        &[(0b10010, &ENTRY_SATIRIZER_852195482153342188)],
        &[(0b10010, &ENTRY_SATIRIZERS_15574884911196071567)],
        &[(0b10010, &ENTRY_SATIRIZES_10052925778146532918)],
        &[(0b10010, &ENTRY_SATIRIZING_1764005323783146105)],
        &[(0b01001, &ENTRY_SATIRIZABLE_2981879413723745381)],
        &[(0b01001, &ENTRY_SATIRIZABLES_12495079216543111113)],
        &[(0b01001, &ENTRY_SATIRIZATION_5803523737972554169)],
        &[(0b01001, &ENTRY_SATIRIZE_4670452432959122101)],
        &[(0b01001, &ENTRY_SATIRIZED_7754739640320301410)],
        &[(0b01001, &ENTRY_SATIRIZER_852195482153342188)],
        &[(0b01001, &ENTRY_SATIRIZERS_15574884911196071567)],
        &[(0b01001, &ENTRY_SATIRIZES_10052925778146532918)],
        &[(0b01001, &ENTRY_SATIRIZING_1764005323783146105)],
        &[(0b11010, &ENTRY_SATIVE_2657172684842563277)],
        &[(0b00001, &ENTRY_SATIVE_2657172684842563277)],
    ],
    range: 3..=10,
};

static VARS_SAS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SAS_CHILDREN),
    value: None,
};

pub static VARS_SAS_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("sanidae"),
        dictgen::InsensitiveStr::Ascii("sanide"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SASSANIDE_5335894015828476896)],
        &[(0b00001, &ENTRY_SASSANIDE_5335894015828476896)],
    ],
    range: 6..=7,
};

static VARS_SAR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SAR_CHILDREN),
    value: None,
};

pub static VARS_SAR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cinae"),
        dictgen::InsensitiveStr::Ascii("cine"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SARCINE_1474563832611431940)],
        &[(0b00001, &ENTRY_SARCINE_1474563832611431940)],
    ],
    range: 4..=5,
};

static VARS_SAP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SAP_CHILDREN),
    value: None,
};

pub static VARS_SAP_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ientise"),
        dictgen::InsensitiveStr::Ascii("ientises"),
        dictgen::InsensitiveStr::Ascii("ientize"),
        dictgen::InsensitiveStr::Ascii("ientizes"),
        dictgen::InsensitiveStr::Ascii("or"),
        dictgen::InsensitiveStr::Ascii("ors"),
        dictgen::InsensitiveStr::Ascii("our"),
        dictgen::InsensitiveStr::Ascii("ours"),
        dictgen::InsensitiveStr::Ascii("raemia"),
        dictgen::InsensitiveStr::Ascii("raemias"),
        dictgen::InsensitiveStr::Ascii("raemic"),
        dictgen::InsensitiveStr::Ascii("remia"),
        dictgen::InsensitiveStr::Ascii("remias"),
        dictgen::InsensitiveStr::Ascii("remic"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SAPIENTIZE_14146190997329896957)],
        &[(0b10010, &ENTRY_SAPIENTIZES_16382959409533620025)],
        &[(0b01001, &ENTRY_SAPIENTIZE_14146190997329896957)],
        &[(0b01001, &ENTRY_SAPIENTIZES_16382959409533620025)],
        &[(0b00001, &ENTRY_SAPOR_14377617062405537073)],
        &[(0b00001, &ENTRY_SAPORS_15668621297825529733)],
        &[(0b11010, &ENTRY_SAPOR_14377617062405537073)],
        &[(0b11010, &ENTRY_SAPORS_15668621297825529733)],
        &[(0b11010, &ENTRY_SAPREMIA_10927593620047632704)],
        &[(0b11010, &ENTRY_SAPREMIAS_2393230130508325789)],
        &[(0b11010, &ENTRY_SAPREMIC_9405591661600178250)],
        &[(0b00001, &ENTRY_SAPREMIA_10927593620047632704)],
        &[(0b00001, &ENTRY_SAPREMIAS_2393230130508325789)],
        &[(0b00001, &ENTRY_SAPREMIC_9405591661600178250)],
    ],
    range: 2..=8,
};

static VARS_SAN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SAN_CHILDREN),
    value: None,
};

pub static VARS_SAN_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ctuarise"),
        dictgen::InsensitiveStr::Ascii("ctuarised"),
        dictgen::InsensitiveStr::Ascii("ctuarises"),
        dictgen::InsensitiveStr::Ascii("ctuarising"),
        dictgen::InsensitiveStr::Ascii("ctuarize"),
        dictgen::InsensitiveStr::Ascii("ctuarized"),
        dictgen::InsensitiveStr::Ascii("ctuarizes"),
        dictgen::InsensitiveStr::Ascii("ctuarizing"),
        dictgen::InsensitiveStr::Ascii("daled"),
        dictgen::InsensitiveStr::Ascii("daling"),
        dictgen::InsensitiveStr::Ascii("dalled"),
        dictgen::InsensitiveStr::Ascii("dalling"),
        dictgen::InsensitiveStr::Ascii("ferd"),
        dictgen::InsensitiveStr::Ascii("forise"),
        dictgen::InsensitiveStr::Ascii("forises"),
        dictgen::InsensitiveStr::Ascii("forising"),
        dictgen::InsensitiveStr::Ascii("forize"),
        dictgen::InsensitiveStr::Ascii("forizes"),
        dictgen::InsensitiveStr::Ascii("forizing"),
        dictgen::InsensitiveStr::Ascii("fred"),
        dictgen::InsensitiveStr::Ascii("itisation"),
        dictgen::InsensitiveStr::Ascii("itisations"),
        dictgen::InsensitiveStr::Ascii("itise"),
        dictgen::InsensitiveStr::Ascii("itised"),
        dictgen::InsensitiveStr::Ascii("itiser"),
        dictgen::InsensitiveStr::Ascii("itisers"),
        dictgen::InsensitiveStr::Ascii("itises"),
        dictgen::InsensitiveStr::Ascii("itising"),
        dictgen::InsensitiveStr::Ascii("itization"),
        dictgen::InsensitiveStr::Ascii("itizations"),
        dictgen::InsensitiveStr::Ascii("itize"),
        dictgen::InsensitiveStr::Ascii("itized"),
        dictgen::InsensitiveStr::Ascii("itizer"),
        dictgen::InsensitiveStr::Ascii("itizers"),
        dictgen::InsensitiveStr::Ascii("itizes"),
        dictgen::InsensitiveStr::Ascii("itizing"),
        dictgen::InsensitiveStr::Ascii("skritise"),
        dictgen::InsensitiveStr::Ascii("skritize"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SANCTUARIZE_2684033985693966023)],
        &[(0b10010, &ENTRY_SANCTUARIZED_13881929576576103541)],
        &[(0b10010, &ENTRY_SANCTUARIZES_886243961160484101)],
        &[(0b10010, &ENTRY_SANCTUARIZING_6723253584803089826)],
        &[(0b01001, &ENTRY_SANCTUARIZE_2684033985693966023)],
        &[(0b01001, &ENTRY_SANCTUARIZED_13881929576576103541)],
        &[(0b01001, &ENTRY_SANCTUARIZES_886243961160484101)],
        &[(0b01001, &ENTRY_SANCTUARIZING_6723253584803089826)],
        &[(0b00001, &ENTRY_SANDALED_13249873388295186265)],
        &[(0b00001, &ENTRY_SANDALING_7683116982062206539)],
        &[(0b11010, &ENTRY_SANDALED_13249873388295186265)],
        &[(0b11010, &ENTRY_SANDALING_7683116982062206539)],
        &[(0b00001, &ENTRY_SANFERD_7356557887418560168)],
        &[(0b10010, &ENTRY_SANFORIZE_4265814001637231765)],
        &[(0b10010, &ENTRY_SANFORIZES_2563826137147657575)],
        &[(0b10010, &ENTRY_SANFORIZING_2868487486423425023)],
        &[(0b01001, &ENTRY_SANFORIZE_4265814001637231765)],
        &[(0b01001, &ENTRY_SANFORIZES_2563826137147657575)],
        &[(0b01001, &ENTRY_SANFORIZING_2868487486423425023)],
        &[(0b11010, &ENTRY_SANFERD_7356557887418560168)],
        &[(0b10010, &ENTRY_SANITIZATION_10312415212709623714)],
        &[(0b10010, &ENTRY_SANITIZATIONS_8021402000169967705)],
        &[(0b10010, &ENTRY_SANITIZE_7331650509497054123)],
        &[(0b10010, &ENTRY_SANITIZED_5841984440856760755)],
        &[(0b10010, &ENTRY_SANITIZER_6961399843419580720)],
        &[(0b10010, &ENTRY_SANITIZERS_9114154210371871378)],
        &[(0b10010, &ENTRY_SANITIZES_14632226777926157749)],
        &[(0b10010, &ENTRY_SANITIZING_15814691895167354347)],
        &[(0b01001, &ENTRY_SANITIZATION_10312415212709623714)],
        &[(0b01001, &ENTRY_SANITIZATIONS_8021402000169967705)],
        &[(0b01001, &ENTRY_SANITIZE_7331650509497054123)],
        &[(0b01001, &ENTRY_SANITIZED_5841984440856760755)],
        &[(0b01001, &ENTRY_SANITIZER_6961399843419580720)],
        &[(0b01001, &ENTRY_SANITIZERS_9114154210371871378)],
        &[(0b01001, &ENTRY_SANITIZES_14632226777926157749)],
        &[(0b01001, &ENTRY_SANITIZING_15814691895167354347)],
        &[(0b10010, &ENTRY_SANSKRITIZE_8185278319719381954)],
        &[(0b01001, &ENTRY_SANSKRITIZE_8185278319719381954)],
    ],
    range: 4..=10,
};

static VARS_SAL_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SAL_CHILDREN),
    value: None,
};

pub static VARS_SAL_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("able"),
        dictgen::InsensitiveStr::Ascii("abler"),
        dictgen::InsensitiveStr::Ascii("ablest"),
        dictgen::InsensitiveStr::Ascii("inisation"),
        dictgen::InsensitiveStr::Ascii("inise"),
        dictgen::InsensitiveStr::Ascii("inises"),
        dictgen::InsensitiveStr::Ascii("inization"),
        dictgen::InsensitiveStr::Ascii("inize"),
        dictgen::InsensitiveStr::Ascii("inizes"),
        dictgen::InsensitiveStr::Ascii("tiers"),
        dictgen::InsensitiveStr::Ascii("tierwise"),
        dictgen::InsensitiveStr::Ascii("tires"),
        dictgen::InsensitiveStr::Ascii("tirewise"),
        dictgen::InsensitiveStr::Ascii("tpeter"),
        dictgen::InsensitiveStr::Ascii("tpeters"),
        dictgen::InsensitiveStr::Ascii("tpetre"),
        dictgen::InsensitiveStr::Ascii("tpetres"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SALABLE_13489586256964068577)],
        &[(0b00001, &ENTRY_SALABLER_2191562261555828404)],
        &[(0b00001, &ENTRY_SALABLEST_11739630936470269511)],
        &[(0b10010, &ENTRY_SALINIZATION_14249030620674770707)],
        &[(0b10010, &ENTRY_SALINIZE_1624463717219344911)],
        &[(0b10010, &ENTRY_SALINIZES_15735130644009593162)],
        &[(0b01001, &ENTRY_SALINIZATION_14249030620674770707)],
        &[(0b01001, &ENTRY_SALINIZE_1624463717219344911)],
        &[(0b01001, &ENTRY_SALINIZES_15735130644009593162)],
        &[(0b00001, &ENTRY_SALTIERS_15037062520661036868)],
        &[(0b00001, &ENTRY_SALTIERWISE_13939673853461651998)],
        &[(0b11010, &ENTRY_SALTIERS_15037062520661036868)],
        &[(0b11010, &ENTRY_SALTIERWISE_13939673853461651998)],
        &[(0b00001, &ENTRY_SALTPETER_1364613771688244608)],
        &[(0b00001, &ENTRY_SALTPETERS_13396036659008372276)],
        &[(0b11010, &ENTRY_SALTPETER_1364613771688244608)],
        &[(0b11010, &ENTRY_SALTPETERS_13396036659008372276)],
    ],
    range: 4..=9,
};

static VARS_SAI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SAI_CHILDREN),
    value: None,
};

pub static VARS_SAI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lorising"),
        dictgen::InsensitiveStr::Ascii("lorisings"),
        dictgen::InsensitiveStr::Ascii("lorizing"),
        dictgen::InsensitiveStr::Ascii("lorizings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SAILORIZING_10847894908498319787)],
        &[(0b10010, &ENTRY_SAILORIZINGS_828877064204542534)],
        &[(0b01001, &ENTRY_SAILORIZING_10847894908498319787)],
        &[(0b01001, &ENTRY_SAILORIZINGS_828877064204542534)],
    ],
    range: 8..=9,
};

static VARS_SAF_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SAF_CHILDREN),
    value: None,
};

pub static VARS_SAF_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ier"),
        dictgen::InsensitiveStr::Ascii("ire"),
    ],
    values: &[
        &[(0b00001, &ENTRY_SAFIER_7130557169601659947)],
        &[(0b11010, &ENTRY_SAFIER_7130557169601659947)],
    ],
    range: 3..=3,
};

static VARS_SAE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SAE_CHILDREN),
    value: Some(&[(0b11010, &ENTRY_SE_2594869031866220942)]),
};

pub static VARS_SAE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("culum"),
        dictgen::InsensitiveStr::Ascii("culums"),
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("ta"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SECULUM_14580513950849648417)],
        &[(0b11010, &ENTRY_SECULUMS_1417148559086086183)],
        &[(0b11010, &ENTRY_SEED_321113364137294796)],
        &[(0b11010, &ENTRY_SETA_9673520022199067907)],
    ],
    range: 2..=6,
};

static VARS_SAC_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SAC_CHILDREN),
    value: None,
};

pub static VARS_SAC_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("charisation"),
        dictgen::InsensitiveStr::Ascii("charisations"),
        dictgen::InsensitiveStr::Ascii("charise"),
        dictgen::InsensitiveStr::Ascii("charised"),
        dictgen::InsensitiveStr::Ascii("charises"),
        dictgen::InsensitiveStr::Ascii("charising"),
        dictgen::InsensitiveStr::Ascii("charization"),
        dictgen::InsensitiveStr::Ascii("charizations"),
        dictgen::InsensitiveStr::Ascii("charize"),
        dictgen::InsensitiveStr::Ascii("charized"),
        dictgen::InsensitiveStr::Ascii("charizes"),
        dictgen::InsensitiveStr::Ascii("charizing"),
        dictgen::InsensitiveStr::Ascii("erdotalise"),
        dictgen::InsensitiveStr::Ascii("erdotalised"),
        dictgen::InsensitiveStr::Ascii("erdotalises"),
        dictgen::InsensitiveStr::Ascii("erdotalising"),
        dictgen::InsensitiveStr::Ascii("erdotalize"),
        dictgen::InsensitiveStr::Ascii("erdotalized"),
        dictgen::InsensitiveStr::Ascii("erdotalizes"),
        dictgen::InsensitiveStr::Ascii("erdotalizing"),
        dictgen::InsensitiveStr::Ascii("ralisation"),
        dictgen::InsensitiveStr::Ascii("ralisations"),
        dictgen::InsensitiveStr::Ascii("ralise"),
        dictgen::InsensitiveStr::Ascii("ralised"),
        dictgen::InsensitiveStr::Ascii("ralises"),
        dictgen::InsensitiveStr::Ascii("ralising"),
        dictgen::InsensitiveStr::Ascii("ralization"),
        dictgen::InsensitiveStr::Ascii("ralizations"),
        dictgen::InsensitiveStr::Ascii("ralize"),
        dictgen::InsensitiveStr::Ascii("ralized"),
        dictgen::InsensitiveStr::Ascii("ralizes"),
        dictgen::InsensitiveStr::Ascii("ralizing"),
        dictgen::InsensitiveStr::Ascii("ramentise"),
        dictgen::InsensitiveStr::Ascii("ramentises"),
        dictgen::InsensitiveStr::Ascii("ramentize"),
        dictgen::InsensitiveStr::Ascii("ramentizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_SACCHARIZATION_12951479435448622533)],
        &[(0b10010, &ENTRY_SACCHARIZATIONS_17924715140172127263)],
        &[(0b10010, &ENTRY_SACCHARIZE_8112536361258402472)],
        &[(0b10010, &ENTRY_SACCHARIZED_17475431280128284092)],
        &[(0b10010, &ENTRY_SACCHARIZES_17004868231094363900)],
        &[(0b10010, &ENTRY_SACCHARIZING_4047419846397824266)],
        &[(0b01001, &ENTRY_SACCHARIZATION_12951479435448622533)],
        &[(0b01001, &ENTRY_SACCHARIZATIONS_17924715140172127263)],
        &[(0b01001, &ENTRY_SACCHARIZE_8112536361258402472)],
        &[(0b01001, &ENTRY_SACCHARIZED_17475431280128284092)],
        &[(0b01001, &ENTRY_SACCHARIZES_17004868231094363900)],
        &[(0b01001, &ENTRY_SACCHARIZING_4047419846397824266)],
        &[(0b10010, &ENTRY_SACERDOTALIZE_6234124268374846096)],
        &[(0b10010, &ENTRY_SACERDOTALIZED_3090555217942359397)],
        &[(0b10010, &ENTRY_SACERDOTALIZES_3677365514994329629)],
        &[(0b10010, &ENTRY_SACERDOTALIZING_17120181135430251071)],
        &[(0b01001, &ENTRY_SACERDOTALIZE_6234124268374846096)],
        &[(0b01001, &ENTRY_SACERDOTALIZED_3090555217942359397)],
        &[(0b01001, &ENTRY_SACERDOTALIZES_3677365514994329629)],
        &[(0b01001, &ENTRY_SACERDOTALIZING_17120181135430251071)],
        &[(0b10010, &ENTRY_SACRALIZATION_1618414885145018191)],
        &[(0b10010, &ENTRY_SACRALIZATIONS_14811964160883679275)],
        &[(0b10010, &ENTRY_SACRALIZE_10390344760188291303)],
        &[(0b10010, &ENTRY_SACRALIZED_9465526025728376412)],
        &[(0b10010, &ENTRY_SACRALIZES_15118462953215987237)],
        &[(0b10010, &ENTRY_SACRALIZING_12013845710799024326)],
        &[(0b01001, &ENTRY_SACRALIZATION_1618414885145018191)],
        &[(0b01001, &ENTRY_SACRALIZATIONS_14811964160883679275)],
        &[(0b01001, &ENTRY_SACRALIZE_10390344760188291303)],
        &[(0b01001, &ENTRY_SACRALIZED_9465526025728376412)],
        &[(0b01001, &ENTRY_SACRALIZES_15118462953215987237)],
        &[(0b01001, &ENTRY_SACRALIZING_12013845710799024326)],
        &[(0b10010, &ENTRY_SACRAMENTIZE_5105033131237471754)],
        &[(0b10010, &ENTRY_SACRAMENTIZES_16943481266153665364)],
        &[(0b01001, &ENTRY_SACRAMENTIZE_5105033131237471754)],
        &[(0b01001, &ENTRY_SACRAMENTIZES_16943481266153665364)],
    ],
    range: 6..=12,
};

static VARS_SAB_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_SAB_CHILDREN),
    value: None,
};

pub static VARS_SAB_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aean"),
        dictgen::InsensitiveStr::Ascii("aeans"),
        dictgen::InsensitiveStr::Ascii("bathise"),
        dictgen::InsensitiveStr::Ascii("bathises"),
        dictgen::InsensitiveStr::Ascii("bathize"),
        dictgen::InsensitiveStr::Ascii("bathizes"),
        dictgen::InsensitiveStr::Ascii("batise"),
        dictgen::InsensitiveStr::Ascii("batised"),
        dictgen::InsensitiveStr::Ascii("batises"),
        dictgen::InsensitiveStr::Ascii("batising"),
        dictgen::InsensitiveStr::Ascii("batize"),
        dictgen::InsensitiveStr::Ascii("batized"),
        dictgen::InsensitiveStr::Ascii("batizes"),
        dictgen::InsensitiveStr::Ascii("batizing"),
        dictgen::InsensitiveStr::Ascii("ean"),
        dictgen::InsensitiveStr::Ascii("eans"),
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("erbill"),
        dictgen::InsensitiveStr::Ascii("ered"),
        dictgen::InsensitiveStr::Ascii("ering"),
        dictgen::InsensitiveStr::Ascii("erlike"),
        dictgen::InsensitiveStr::Ascii("erlikes"),
        dictgen::InsensitiveStr::Ascii("ers"),
        dictgen::InsensitiveStr::Ascii("ertooth"),
        dictgen::InsensitiveStr::Ascii("rebill"),
        dictgen::InsensitiveStr::Ascii("relike"),
        dictgen::InsensitiveStr::Ascii("relikes"),
        dictgen::InsensitiveStr::Ascii("retooth"),
    ],
    values: &[
        &[(0b11010, &ENTRY_SABEAN_3967530483638026323)],
        &[(0b11010, &ENTRY_SABEANS_6165241232825542997)],
        &[(0b10010, &ENTRY_SABBATHIZE_9135552393539099453)],
        &[(0b10010, &ENTRY_SABBATHIZES_14657735120604873546)],
        &[(0b01001, &ENTRY_SABBATHIZE_9135552393539099453)],
        &[(0b01001, &ENTRY_SABBATHIZES_14657735120604873546)],
        &[(0b10010, &ENTRY_SABBATIZE_9501648681615619705)],
        &[(0b10010, &ENTRY_SABBATIZED_13406040171945222761)],
        &[(0b10010, &ENTRY_SABBATIZES_15314102181592132563)],
        &[(0b10010, &ENTRY_SABBATIZING_12733815021350519705)],
        &[(0b01001, &ENTRY_SABBATIZE_9501648681615619705)],
        &[(0b01001, &ENTRY_SABBATIZED_13406040171945222761)],
        &[(0b01001, &ENTRY_SABBATIZES_15314102181592132563)],
        &[(0b01001, &ENTRY_SABBATIZING_12733815021350519705)],
        &[(0b00001, &ENTRY_SABEAN_3967530483638026323)],
        &[(0b00001, &ENTRY_SABEANS_6165241232825542997)],
        &[(0b00001, &ENTRY_SABER_11546898781047404082)],
        &[(0b00001, &ENTRY_SABERBILL_8906790336832465441)],
        &[(0b00001, &ENTRY_SABERED_6570351091920240802)],
        &[(0b00001, &ENTRY_SABERING_678610951848245655)],
        &[(0b00001, &ENTRY_SABERLIKE_13557431937207997081)],
        &[(0b00001, &ENTRY_SABERLIKES_11200825439513418213)],
        &[(0b00001, &ENTRY_SABERS_16530304349268606792)],
        &[(0b00001, &ENTRY_SABERTOOTH_232682195526621441)],
        &[(0b11010, &ENTRY_SABERBILL_8906790336832465441)],
        &[(0b11010, &ENTRY_SABERLIKE_13557431937207997081)],
        &[(0b11010, &ENTRY_SABERLIKES_11200825439513418213)],
        &[(0b11010, &ENTRY_SABERTOOTH_232682195526621441)],
    ],
    range: 2..=8,
};

static VARS_R_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_R_CHILDREN),
    value: None,
};

static VARS_R_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_RA_NODE),
    None,
    None,
    None,
    Some(&VARS_RE_NODE),
    None,
    None,
    Some(&VARS_RH_NODE),
    Some(&VARS_RI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_RO_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_RU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_RU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_RU_CHILDREN),
    value: None,
};

static VARS_RU_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_RUB_NODE),
    None,
    None,
    None,
    Some(&VARS_RUF_NODE),
    Some(&VARS_RUG_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_RUM_NODE),
    None,
    None,
    None,
    None,
    Some(&VARS_RUR_NODE),
    Some(&VARS_RUS_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_RUS_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RUS_CHILDREN),
    value: None,
};

pub static VARS_RUS_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("sianisation"),
        dictgen::InsensitiveStr::Ascii("sianisations"),
        dictgen::InsensitiveStr::Ascii("sianise"),
        dictgen::InsensitiveStr::Ascii("sianised"),
        dictgen::InsensitiveStr::Ascii("sianises"),
        dictgen::InsensitiveStr::Ascii("sianising"),
        dictgen::InsensitiveStr::Ascii("sianization"),
        dictgen::InsensitiveStr::Ascii("sianizations"),
        dictgen::InsensitiveStr::Ascii("sianize"),
        dictgen::InsensitiveStr::Ascii("sianized"),
        dictgen::InsensitiveStr::Ascii("sianizes"),
        dictgen::InsensitiveStr::Ascii("sianizing"),
        dictgen::InsensitiveStr::Ascii("ticise"),
        dictgen::InsensitiveStr::Ascii("ticised"),
        dictgen::InsensitiveStr::Ascii("ticises"),
        dictgen::InsensitiveStr::Ascii("ticising"),
        dictgen::InsensitiveStr::Ascii("ticize"),
        dictgen::InsensitiveStr::Ascii("ticized"),
        dictgen::InsensitiveStr::Ascii("ticizes"),
        dictgen::InsensitiveStr::Ascii("ticizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RUSSIANIZATION_16898768923421263030)],
        &[(0b10010, &ENTRY_RUSSIANIZATIONS_11585141916754458789)],
        &[(0b10010, &ENTRY_RUSSIANIZE_9206676310088840254)],
        &[(0b10010, &ENTRY_RUSSIANIZED_15749625767358498066)],
        &[(0b10010, &ENTRY_RUSSIANIZES_16645859177250529320)],
        &[(0b10010, &ENTRY_RUSSIANIZING_12272597000608712547)],
        &[(0b01001, &ENTRY_RUSSIANIZATION_16898768923421263030)],
        &[(0b01001, &ENTRY_RUSSIANIZATIONS_11585141916754458789)],
        &[(0b01001, &ENTRY_RUSSIANIZE_9206676310088840254)],
        &[(0b01001, &ENTRY_RUSSIANIZED_15749625767358498066)],
        &[(0b01001, &ENTRY_RUSSIANIZES_16645859177250529320)],
        &[(0b01001, &ENTRY_RUSSIANIZING_12272597000608712547)],
        &[(0b10010, &ENTRY_RUSTICIZE_12734614119488995185)],
        &[(0b10010, &ENTRY_RUSTICIZED_8719798803495007326)],
        &[(0b10010, &ENTRY_RUSTICIZES_5457546844148812271)],
        &[(0b10010, &ENTRY_RUSTICIZING_2240961739878480538)],
        &[(0b01001, &ENTRY_RUSTICIZE_12734614119488995185)],
        &[(0b01001, &ENTRY_RUSTICIZED_8719798803495007326)],
        &[(0b01001, &ENTRY_RUSTICIZES_5457546844148812271)],
        &[(0b01001, &ENTRY_RUSTICIZING_2240961739878480538)],
    ],
    range: 6..=12,
};

static VARS_RUR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RUR_CHILDREN),
    value: None,
};

pub static VARS_RUR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alisation"),
        dictgen::InsensitiveStr::Ascii("alisations"),
        dictgen::InsensitiveStr::Ascii("alise"),
        dictgen::InsensitiveStr::Ascii("alised"),
        dictgen::InsensitiveStr::Ascii("alises"),
        dictgen::InsensitiveStr::Ascii("alising"),
        dictgen::InsensitiveStr::Ascii("alization"),
        dictgen::InsensitiveStr::Ascii("alizations"),
        dictgen::InsensitiveStr::Ascii("alize"),
        dictgen::InsensitiveStr::Ascii("alized"),
        dictgen::InsensitiveStr::Ascii("alizes"),
        dictgen::InsensitiveStr::Ascii("alizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RURALIZATION_12199675531569627500)],
        &[(0b10010, &ENTRY_RURALIZATIONS_18364650995853039163)],
        &[(0b10010, &ENTRY_RURALIZE_10315684701653459711)],
        &[(0b10010, &ENTRY_RURALIZED_10330894529989453328)],
        &[(0b10010, &ENTRY_RURALIZES_2177534473483628527)],
        &[(0b10010, &ENTRY_RURALIZING_13347398545539483501)],
        &[(0b01001, &ENTRY_RURALIZATION_12199675531569627500)],
        &[(0b01001, &ENTRY_RURALIZATIONS_18364650995853039163)],
        &[(0b01001, &ENTRY_RURALIZE_10315684701653459711)],
        &[(0b01001, &ENTRY_RURALIZED_10330894529989453328)],
        &[(0b01001, &ENTRY_RURALIZES_2177534473483628527)],
        &[(0b01001, &ENTRY_RURALIZING_13347398545539483501)],
    ],
    range: 5..=10,
};

static VARS_RUM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RUM_CHILDREN),
    value: None,
};

pub static VARS_RUM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("or"),
        dictgen::InsensitiveStr::Ascii("ored"),
        dictgen::InsensitiveStr::Ascii("orer"),
        dictgen::InsensitiveStr::Ascii("orers"),
        dictgen::InsensitiveStr::Ascii("oring"),
        dictgen::InsensitiveStr::Ascii("ormonger"),
        dictgen::InsensitiveStr::Ascii("ormongers"),
        dictgen::InsensitiveStr::Ascii("ors"),
        dictgen::InsensitiveStr::Ascii("our"),
        dictgen::InsensitiveStr::Ascii("oured"),
        dictgen::InsensitiveStr::Ascii("ourer"),
        dictgen::InsensitiveStr::Ascii("ourers"),
        dictgen::InsensitiveStr::Ascii("ouring"),
        dictgen::InsensitiveStr::Ascii("ourmonger"),
        dictgen::InsensitiveStr::Ascii("ourmongers"),
        dictgen::InsensitiveStr::Ascii("ours"),
    ],
    values: &[
        &[(0b11001, &ENTRY_RUMOR_9709120178518195057)],
        &[(0b11001, &ENTRY_RUMORED_18309275267346665123)],
        &[(0b00001, &ENTRY_RUMORER_11488343213641948242)],
        &[(0b00001, &ENTRY_RUMORERS_6357305227935379172)],
        &[(0b11001, &ENTRY_RUMORING_2328261845579723307)],
        &[(0b10001, &ENTRY_RUMORMONGER_7299548335065542796)],
        &[(0b10001, &ENTRY_RUMORMONGERS_12499750377413614176)],
        &[(0b11001, &ENTRY_RUMORS_4907921740910409378)],
        &[(0b11010, &ENTRY_RUMOR_9709120178518195057)],
        &[(0b11010, &ENTRY_RUMORED_18309275267346665123)],
        &[(0b11010, &ENTRY_RUMORER_11488343213641948242)],
        &[(0b11010, &ENTRY_RUMORERS_6357305227935379172)],
        &[(0b11010, &ENTRY_RUMORING_2328261845579723307)],
        &[(0b11010, &ENTRY_RUMORMONGER_7299548335065542796)],
        &[(0b11010, &ENTRY_RUMORMONGERS_12499750377413614176)],
        &[(0b11010, &ENTRY_RUMORS_4907921740910409378)],
    ],
    range: 2..=10,
};

static VARS_RUG_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RUG_CHILDREN),
    value: None,
};

pub static VARS_RUG_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gedisation"),
        dictgen::InsensitiveStr::Ascii("gedisations"),
        dictgen::InsensitiveStr::Ascii("gedise"),
        dictgen::InsensitiveStr::Ascii("gedised"),
        dictgen::InsensitiveStr::Ascii("gedises"),
        dictgen::InsensitiveStr::Ascii("gedising"),
        dictgen::InsensitiveStr::Ascii("gedization"),
        dictgen::InsensitiveStr::Ascii("gedizations"),
        dictgen::InsensitiveStr::Ascii("gedize"),
        dictgen::InsensitiveStr::Ascii("gedized"),
        dictgen::InsensitiveStr::Ascii("gedizes"),
        dictgen::InsensitiveStr::Ascii("gedizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RUGGEDIZATION_5669230878299551336)],
        &[(0b10010, &ENTRY_RUGGEDIZATIONS_632588497204849835)],
        &[(0b10010, &ENTRY_RUGGEDIZE_452263712716974983)],
        &[(0b10010, &ENTRY_RUGGEDIZED_16294057666793563055)],
        &[(0b10010, &ENTRY_RUGGEDIZES_16648500507504288559)],
        &[(0b10010, &ENTRY_RUGGEDIZING_10631138816687857349)],
        &[(0b01001, &ENTRY_RUGGEDIZATION_5669230878299551336)],
        &[(0b01001, &ENTRY_RUGGEDIZATIONS_632588497204849835)],
        &[(0b01001, &ENTRY_RUGGEDIZE_452263712716974983)],
        &[(0b01001, &ENTRY_RUGGEDIZED_16294057666793563055)],
        &[(0b01001, &ENTRY_RUGGEDIZES_16648500507504288559)],
        &[(0b01001, &ENTRY_RUGGEDIZING_10631138816687857349)],
    ],
    range: 6..=11,
};

static VARS_RUF_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RUF_CHILDREN),
    value: None,
};

pub static VARS_RUF_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("fianise"),
        dictgen::InsensitiveStr::Ascii("fianises"),
        dictgen::InsensitiveStr::Ascii("fianize"),
        dictgen::InsensitiveStr::Ascii("fianizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RUFFIANIZE_17407878081648774516)],
        &[(0b10010, &ENTRY_RUFFIANIZES_14576217936902384026)],
        &[(0b01001, &ENTRY_RUFFIANIZE_17407878081648774516)],
        &[(0b01001, &ENTRY_RUFFIANIZES_14576217936902384026)],
    ],
    range: 7..=8,
};

static VARS_RUB_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RUB_CHILDREN),
    value: None,
};

pub static VARS_RUB_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("berisation"),
        dictgen::InsensitiveStr::Ascii("berise"),
        dictgen::InsensitiveStr::Ascii("berised"),
        dictgen::InsensitiveStr::Ascii("berises"),
        dictgen::InsensitiveStr::Ascii("berising"),
        dictgen::InsensitiveStr::Ascii("berization"),
        dictgen::InsensitiveStr::Ascii("berize"),
        dictgen::InsensitiveStr::Ascii("berized"),
        dictgen::InsensitiveStr::Ascii("berizes"),
        dictgen::InsensitiveStr::Ascii("berizing"),
        dictgen::InsensitiveStr::Ascii("le"),
        dictgen::InsensitiveStr::Ascii("les"),
        dictgen::InsensitiveStr::Ascii("ricise"),
        dictgen::InsensitiveStr::Ascii("ricises"),
        dictgen::InsensitiveStr::Ascii("ricize"),
        dictgen::InsensitiveStr::Ascii("ricizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RUBBERIZATION_3122682324183377228)],
        &[(0b10010, &ENTRY_RUBBERIZE_8534952429152157034)],
        &[(0b10010, &ENTRY_RUBBERIZED_15637607135983122135)],
        &[(0b10010, &ENTRY_RUBBERIZES_3912030953974462546)],
        &[(0b10010, &ENTRY_RUBBERIZING_5203082318061539960)],
        &[(0b01001, &ENTRY_RUBBERIZATION_3122682324183377228)],
        &[(0b01001, &ENTRY_RUBBERIZE_8534952429152157034)],
        &[(0b01001, &ENTRY_RUBBERIZED_15637607135983122135)],
        &[(0b01001, &ENTRY_RUBBERIZES_3912030953974462546)],
        &[(0b01001, &ENTRY_RUBBERIZING_5203082318061539960)],
        &[(0b00001, &ENTRY_RUBLE_10117878449438778810)],
        &[(0b00001, &ENTRY_RUBLES_5273455018786501602)],
        &[(0b10010, &ENTRY_RUBRICIZE_9836541413862092246)],
        &[(0b10010, &ENTRY_RUBRICIZES_6613684611958202027)],
        &[(0b01001, &ENTRY_RUBRICIZE_9836541413862092246)],
        &[(0b01001, &ENTRY_RUBRICIZES_6613684611958202027)],
    ],
    range: 2..=10,
};

static VARS_RO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_RO_CHILDREN),
    value: None,
};

static VARS_RO_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    Some(&VARS_ROB_NODE),
    None,
    None,
    Some(&VARS_ROE_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_ROM_NODE),
    None,
    Some(&VARS_ROO_NODE),
    None,
    None,
    Some(&VARS_ROR_NODE),
    None,
    None,
    Some(&VARS_ROU_NODE),
    None,
    Some(&VARS_ROW_NODE),
    None,
    Some(&VARS_ROY_NODE),
    None,
];

static VARS_ROY_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_ROY_CHILDREN),
    value: None,
};

pub static VARS_ROY_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alisation"),
        dictgen::InsensitiveStr::Ascii("alisations"),
        dictgen::InsensitiveStr::Ascii("alise"),
        dictgen::InsensitiveStr::Ascii("alised"),
        dictgen::InsensitiveStr::Ascii("alises"),
        dictgen::InsensitiveStr::Ascii("alising"),
        dictgen::InsensitiveStr::Ascii("alization"),
        dictgen::InsensitiveStr::Ascii("alizations"),
        dictgen::InsensitiveStr::Ascii("alize"),
        dictgen::InsensitiveStr::Ascii("alized"),
        dictgen::InsensitiveStr::Ascii("alizes"),
        dictgen::InsensitiveStr::Ascii("alizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ROYALIZATION_11067381201878855200)],
        &[(0b10010, &ENTRY_ROYALIZATIONS_16712363081334842649)],
        &[(0b10010, &ENTRY_ROYALIZE_14272296856251086161)],
        &[(0b10010, &ENTRY_ROYALIZED_5272390552778035423)],
        &[(0b10010, &ENTRY_ROYALIZES_806193357964394419)],
        &[(0b10010, &ENTRY_ROYALIZING_3246861064960016421)],
        &[(0b01001, &ENTRY_ROYALIZATION_11067381201878855200)],
        &[(0b01001, &ENTRY_ROYALIZATIONS_16712363081334842649)],
        &[(0b01001, &ENTRY_ROYALIZE_14272296856251086161)],
        &[(0b01001, &ENTRY_ROYALIZED_5272390552778035423)],
        &[(0b01001, &ENTRY_ROYALIZES_806193357964394419)],
        &[(0b01001, &ENTRY_ROYALIZING_3246861064960016421)],
    ],
    range: 5..=10,
};

static VARS_ROW_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_ROW_CHILDREN),
    value: None,
};

pub static VARS_ROW_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eled"),
        dictgen::InsensitiveStr::Ascii("eling"),
        dictgen::InsensitiveStr::Ascii("elled"),
        dictgen::InsensitiveStr::Ascii("elling"),
    ],
    values: &[
        &[(0b01001, &ENTRY_ROWELED_13637303372527211405)],
        &[(0b01001, &ENTRY_ROWELING_13952035716222413490)],
        &[(0b11010, &ENTRY_ROWELED_13637303372527211405)],
        &[(0b11010, &ENTRY_ROWELING_13952035716222413490)],
    ],
    range: 4..=6,
};

static VARS_ROU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_ROU_CHILDREN),
    value: None,
};

pub static VARS_ROU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ble"),
        dictgen::InsensitiveStr::Ascii("bles"),
        dictgen::InsensitiveStr::Ascii("mania"),
        dictgen::InsensitiveStr::Ascii("manias"),
        dictgen::InsensitiveStr::Ascii("tinisation"),
        dictgen::InsensitiveStr::Ascii("tinisations"),
        dictgen::InsensitiveStr::Ascii("tinise"),
        dictgen::InsensitiveStr::Ascii("tinised"),
        dictgen::InsensitiveStr::Ascii("tinises"),
        dictgen::InsensitiveStr::Ascii("tinising"),
        dictgen::InsensitiveStr::Ascii("tinization"),
        dictgen::InsensitiveStr::Ascii("tinizations"),
        dictgen::InsensitiveStr::Ascii("tinize"),
        dictgen::InsensitiveStr::Ascii("tinized"),
        dictgen::InsensitiveStr::Ascii("tinizes"),
        dictgen::InsensitiveStr::Ascii("tinizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_RUBLE_10117878449438778810)],
        &[(0b11010, &ENTRY_RUBLES_5273455018786501602)],
        &[(0b11010, &ENTRY_ROMANIA_14647491915869407300)],
        &[(0b11010, &ENTRY_ROMANIAS_9441434726837892631)],
        &[(0b10010, &ENTRY_ROUTINIZATION_16656207668238320072)],
        &[(0b10010, &ENTRY_ROUTINIZATIONS_15252472006215427062)],
        &[(0b10010, &ENTRY_ROUTINIZE_5626420320204126115)],
        &[(0b10010, &ENTRY_ROUTINIZED_1851279582216291255)],
        &[(0b10010, &ENTRY_ROUTINIZES_2715007322555254066)],
        &[(0b10010, &ENTRY_ROUTINIZING_6227530109158853879)],
        &[(0b01001, &ENTRY_ROUTINIZATION_16656207668238320072)],
        &[(0b01001, &ENTRY_ROUTINIZATIONS_15252472006215427062)],
        &[(0b01001, &ENTRY_ROUTINIZE_5626420320204126115)],
        &[(0b01001, &ENTRY_ROUTINIZED_1851279582216291255)],
        &[(0b01001, &ENTRY_ROUTINIZES_2715007322555254066)],
        &[(0b01001, &ENTRY_ROUTINIZING_6227530109158853879)],
    ],
    range: 3..=11,
};

static VARS_ROR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_ROR_CHILDREN),
    value: None,
};

pub static VARS_ROR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("e")],
    values: &[&[(0b11010, &ENTRY_ROER_9399565430831118531)]],
    range: 1..=1,
};

static VARS_ROO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_ROO_CHILDREN),
    value: None,
};

pub static VARS_ROO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ed")],
    values: &[&[(0b11010, &ENTRY_ROED_7491598846688934647)]],
    range: 2..=2,
};

static VARS_ROM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_ROM_CHILDREN),
    value: None,
};

pub static VARS_ROM_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ania"),
        dictgen::InsensitiveStr::Ascii("anias"),
        dictgen::InsensitiveStr::Ascii("anisation"),
        dictgen::InsensitiveStr::Ascii("anisations"),
        dictgen::InsensitiveStr::Ascii("anise"),
        dictgen::InsensitiveStr::Ascii("anised"),
        dictgen::InsensitiveStr::Ascii("aniser"),
        dictgen::InsensitiveStr::Ascii("anisers"),
        dictgen::InsensitiveStr::Ascii("anises"),
        dictgen::InsensitiveStr::Ascii("anising"),
        dictgen::InsensitiveStr::Ascii("anization"),
        dictgen::InsensitiveStr::Ascii("anizations"),
        dictgen::InsensitiveStr::Ascii("anize"),
        dictgen::InsensitiveStr::Ascii("anized"),
        dictgen::InsensitiveStr::Ascii("anizer"),
        dictgen::InsensitiveStr::Ascii("anizers"),
        dictgen::InsensitiveStr::Ascii("anizes"),
        dictgen::InsensitiveStr::Ascii("anizing"),
        dictgen::InsensitiveStr::Ascii("anticisation"),
        dictgen::InsensitiveStr::Ascii("anticisations"),
        dictgen::InsensitiveStr::Ascii("anticise"),
        dictgen::InsensitiveStr::Ascii("anticised"),
        dictgen::InsensitiveStr::Ascii("anticises"),
        dictgen::InsensitiveStr::Ascii("anticising"),
        dictgen::InsensitiveStr::Ascii("anticization"),
        dictgen::InsensitiveStr::Ascii("anticizations"),
        dictgen::InsensitiveStr::Ascii("anticize"),
        dictgen::InsensitiveStr::Ascii("anticized"),
        dictgen::InsensitiveStr::Ascii("anticizes"),
        dictgen::InsensitiveStr::Ascii("anticizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_ROMANIA_14647491915869407300)],
        &[(0b00001, &ENTRY_ROMANIAS_9441434726837892631)],
        &[(0b10010, &ENTRY_ROMANIZATION_1812649176047396288)],
        &[(0b10010, &ENTRY_ROMANIZATIONS_9179904637420783701)],
        &[(0b10010, &ENTRY_ROMANIZE_2020383270516389989)],
        &[(0b10010, &ENTRY_ROMANIZED_8188127372098085668)],
        &[(0b10010, &ENTRY_ROMANIZER_10910799684441102818)],
        &[(0b10010, &ENTRY_ROMANIZERS_7186572903998412475)],
        &[(0b10010, &ENTRY_ROMANIZES_7603852869065493171)],
        &[(0b10010, &ENTRY_ROMANIZING_1191652903917979672)],
        &[(0b01001, &ENTRY_ROMANIZATION_1812649176047396288)],
        &[(0b01001, &ENTRY_ROMANIZATIONS_9179904637420783701)],
        &[(0b01001, &ENTRY_ROMANIZE_2020383270516389989)],
        &[(0b01001, &ENTRY_ROMANIZED_8188127372098085668)],
        &[(0b01001, &ENTRY_ROMANIZER_10910799684441102818)],
        &[(0b01001, &ENTRY_ROMANIZERS_7186572903998412475)],
        &[(0b01001, &ENTRY_ROMANIZES_7603852869065493171)],
        &[(0b01001, &ENTRY_ROMANIZING_1191652903917979672)],
        &[(0b10010, &ENTRY_ROMANTICIZATION_1655615510397751437)],
        &[(0b10010, &ENTRY_ROMANTICIZATIONS_14371809476146672855)],
        &[(0b10010, &ENTRY_ROMANTICIZE_17291657258585049672)],
        &[(0b10010, &ENTRY_ROMANTICIZED_10936525722537335211)],
        &[(0b10010, &ENTRY_ROMANTICIZES_14376155573214247856)],
        &[(0b10010, &ENTRY_ROMANTICIZING_7257111435910768108)],
        &[(0b01001, &ENTRY_ROMANTICIZATION_1655615510397751437)],
        &[(0b01001, &ENTRY_ROMANTICIZATIONS_14371809476146672855)],
        &[(0b01001, &ENTRY_ROMANTICIZE_17291657258585049672)],
        &[(0b01001, &ENTRY_ROMANTICIZED_10936525722537335211)],
        &[(0b01001, &ENTRY_ROMANTICIZES_14376155573214247856)],
        &[(0b01001, &ENTRY_ROMANTICIZING_7257111435910768108)],
    ],
    range: 4..=13,
};

static VARS_ROE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_ROE_CHILDREN),
    value: None,
};

pub static VARS_ROE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("d"),
        dictgen::InsensitiveStr::Ascii("hm"),
        dictgen::InsensitiveStr::Ascii("ntgenise"),
        dictgen::InsensitiveStr::Ascii("ntgenize"),
        dictgen::InsensitiveStr::Ascii("r"),
    ],
    values: &[
        &[(0b00001, &ENTRY_ROED_7491598846688934647)],
        &[(0b11010, &ENTRY_REHM_1954003150274029388)],
        &[(0b10010, &ENTRY_ROENTGENIZE_10746435571343043012)],
        &[(0b01001, &ENTRY_ROENTGENIZE_10746435571343043012)],
        &[(0b00001, &ENTRY_ROER_9399565430831118531)],
    ],
    range: 1..=8,
};

static VARS_ROB_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_ROB_CHILDREN),
    value: None,
};

pub static VARS_ROB_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("otisation"),
        dictgen::InsensitiveStr::Ascii("otisations"),
        dictgen::InsensitiveStr::Ascii("otise"),
        dictgen::InsensitiveStr::Ascii("otised"),
        dictgen::InsensitiveStr::Ascii("otises"),
        dictgen::InsensitiveStr::Ascii("otising"),
        dictgen::InsensitiveStr::Ascii("otization"),
        dictgen::InsensitiveStr::Ascii("otizations"),
        dictgen::InsensitiveStr::Ascii("otize"),
        dictgen::InsensitiveStr::Ascii("otized"),
        dictgen::InsensitiveStr::Ascii("otizes"),
        dictgen::InsensitiveStr::Ascii("otizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_ROBOTIZATION_10442464385649584788)],
        &[(0b10010, &ENTRY_ROBOTIZATIONS_11624944842780950110)],
        &[(0b10010, &ENTRY_ROBOTIZE_1822365081322284994)],
        &[(0b10010, &ENTRY_ROBOTIZED_6871096401872030909)],
        &[(0b10010, &ENTRY_ROBOTIZES_8084732757819391045)],
        &[(0b10010, &ENTRY_ROBOTIZING_9767982352083703401)],
        &[(0b01001, &ENTRY_ROBOTIZATION_10442464385649584788)],
        &[(0b01001, &ENTRY_ROBOTIZATIONS_11624944842780950110)],
        &[(0b01001, &ENTRY_ROBOTIZE_1822365081322284994)],
        &[(0b01001, &ENTRY_ROBOTIZED_6871096401872030909)],
        &[(0b01001, &ENTRY_ROBOTIZES_8084732757819391045)],
        &[(0b01001, &ENTRY_ROBOTIZING_9767982352083703401)],
    ],
    range: 5..=10,
};

static VARS_RI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RI_CHILDREN),
    value: None,
};

pub static VARS_RI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("diculise"),
        dictgen::InsensitiveStr::Ascii("diculises"),
        dictgen::InsensitiveStr::Ascii("diculize"),
        dictgen::InsensitiveStr::Ascii("diculizes"),
        dictgen::InsensitiveStr::Ascii("gidise"),
        dictgen::InsensitiveStr::Ascii("gidised"),
        dictgen::InsensitiveStr::Ascii("gidises"),
        dictgen::InsensitiveStr::Ascii("gidising"),
        dictgen::InsensitiveStr::Ascii("gidize"),
        dictgen::InsensitiveStr::Ascii("gidized"),
        dictgen::InsensitiveStr::Ascii("gidizes"),
        dictgen::InsensitiveStr::Ascii("gidizing"),
        dictgen::InsensitiveStr::Ascii("gor"),
        dictgen::InsensitiveStr::Ascii("gorism"),
        dictgen::InsensitiveStr::Ascii("gorist"),
        dictgen::InsensitiveStr::Ascii("goristic"),
        dictgen::InsensitiveStr::Ascii("gors"),
        dictgen::InsensitiveStr::Ascii("gour"),
        dictgen::InsensitiveStr::Ascii("gourism"),
        dictgen::InsensitiveStr::Ascii("gourist"),
        dictgen::InsensitiveStr::Ascii("gouristic"),
        dictgen::InsensitiveStr::Ascii("gours"),
        dictgen::InsensitiveStr::Ascii("otise"),
        dictgen::InsensitiveStr::Ascii("otises"),
        dictgen::InsensitiveStr::Ascii("otize"),
        dictgen::InsensitiveStr::Ascii("otizes"),
        dictgen::InsensitiveStr::Ascii("tornelle"),
        dictgen::InsensitiveStr::Ascii("tornelles"),
        dictgen::InsensitiveStr::Ascii("tournelle"),
        dictgen::InsensitiveStr::Ascii("tournelles"),
        dictgen::InsensitiveStr::Ascii("tualisation"),
        dictgen::InsensitiveStr::Ascii("tualisations"),
        dictgen::InsensitiveStr::Ascii("tualise"),
        dictgen::InsensitiveStr::Ascii("tualised"),
        dictgen::InsensitiveStr::Ascii("tualises"),
        dictgen::InsensitiveStr::Ascii("tualising"),
        dictgen::InsensitiveStr::Ascii("tualization"),
        dictgen::InsensitiveStr::Ascii("tualizations"),
        dictgen::InsensitiveStr::Ascii("tualize"),
        dictgen::InsensitiveStr::Ascii("tualized"),
        dictgen::InsensitiveStr::Ascii("tualizes"),
        dictgen::InsensitiveStr::Ascii("tualizing"),
        dictgen::InsensitiveStr::Ascii("valed"),
        dictgen::InsensitiveStr::Ascii("valess"),
        dictgen::InsensitiveStr::Ascii("valesses"),
        dictgen::InsensitiveStr::Ascii("valing"),
        dictgen::InsensitiveStr::Ascii("valise"),
        dictgen::InsensitiveStr::Ascii("valised"),
        dictgen::InsensitiveStr::Ascii("valises"),
        dictgen::InsensitiveStr::Ascii("valising"),
        dictgen::InsensitiveStr::Ascii("valize"),
        dictgen::InsensitiveStr::Ascii("valized"),
        dictgen::InsensitiveStr::Ascii("valizes"),
        dictgen::InsensitiveStr::Ascii("valizing"),
        dictgen::InsensitiveStr::Ascii("valled"),
        dictgen::InsensitiveStr::Ascii("valless"),
        dictgen::InsensitiveStr::Ascii("vallesses"),
        dictgen::InsensitiveStr::Ascii("valling"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RIDICULIZE_1054636858349594298)],
        &[(0b10010, &ENTRY_RIDICULIZES_14575559099525792123)],
        &[(0b01001, &ENTRY_RIDICULIZE_1054636858349594298)],
        &[(0b01001, &ENTRY_RIDICULIZES_14575559099525792123)],
        &[(0b10010, &ENTRY_RIGIDIZE_156720177693369344)],
        &[(0b10010, &ENTRY_RIGIDIZED_2511443842946442888)],
        &[(0b10010, &ENTRY_RIGIDIZES_8642244566818162964)],
        &[(0b10010, &ENTRY_RIGIDIZING_14021102904701047671)],
        &[(0b01001, &ENTRY_RIGIDIZE_156720177693369344)],
        &[(0b01001, &ENTRY_RIGIDIZED_2511443842946442888)],
        &[(0b01001, &ENTRY_RIGIDIZES_8642244566818162964)],
        &[(0b01001, &ENTRY_RIGIDIZING_14021102904701047671)],
        &[(0b11001, &ENTRY_RIGOR_6127041250190650208)],
        &[(0b00001, &ENTRY_RIGORISM_14069127364398578519)],
        &[(0b00001, &ENTRY_RIGORIST_6703622095815747851)],
        &[(0b00001, &ENTRY_RIGORISTIC_12345844524001178474)],
        &[(0b11001, &ENTRY_RIGORS_163306158062409929)],
        &[(0b11010, &ENTRY_RIGOR_6127041250190650208)],
        &[(0b11010, &ENTRY_RIGORISM_14069127364398578519)],
        &[(0b11010, &ENTRY_RIGORIST_6703622095815747851)],
        &[(0b11010, &ENTRY_RIGORISTIC_12345844524001178474)],
        &[(0b11010, &ENTRY_RIGORS_163306158062409929)],
        &[(0b10010, &ENTRY_RIOTIZE_6719680474007390438)],
        &[(0b10010, &ENTRY_RIOTIZES_17355146657912726592)],
        &[(0b01001, &ENTRY_RIOTIZE_6719680474007390438)],
        &[(0b01001, &ENTRY_RIOTIZES_17355146657912726592)],
        &[(0b00001, &ENTRY_RITORNELLE_12914215580998668402)],
        &[(0b00001, &ENTRY_RITORNELLES_18174381851390434260)],
        &[(0b11010, &ENTRY_RITORNELLE_12914215580998668402)],
        &[(0b11010, &ENTRY_RITORNELLES_18174381851390434260)],
        &[(0b10010, &ENTRY_RITUALIZATION_17705479449777175846)],
        &[(0b10010, &ENTRY_RITUALIZATIONS_6446107650917771589)],
        &[(0b10010, &ENTRY_RITUALIZE_10559347390928816833)],
        &[(0b10010, &ENTRY_RITUALIZED_14603675570872660022)],
        &[(0b10010, &ENTRY_RITUALIZES_6743897608838025402)],
        &[(0b10010, &ENTRY_RITUALIZING_5584795455479400064)],
        &[(0b01001, &ENTRY_RITUALIZATION_17705479449777175846)],
        &[(0b01001, &ENTRY_RITUALIZATIONS_6446107650917771589)],
        &[(0b01001, &ENTRY_RITUALIZE_10559347390928816833)],
        &[(0b01001, &ENTRY_RITUALIZED_14603675570872660022)],
        &[(0b01001, &ENTRY_RITUALIZES_6743897608838025402)],
        &[(0b01001, &ENTRY_RITUALIZING_5584795455479400064)],
        &[(0b00001, &ENTRY_RIVALED_1310914145976397449)],
        &[(0b00001, &ENTRY_RIVALESS_17030046039543701469)],
        &[(0b00001, &ENTRY_RIVALESSES_7896212397487020650)],
        &[(0b00001, &ENTRY_RIVALING_6945496358803583057)],
        &[(0b10010, &ENTRY_RIVALIZE_7944174065886798683)],
        &[(0b10010, &ENTRY_RIVALIZED_7182768422071390801)],
        &[(0b10010, &ENTRY_RIVALIZES_2452557101215464168)],
        &[(0b10010, &ENTRY_RIVALIZING_14048952717153236037)],
        &[(0b01001, &ENTRY_RIVALIZE_7944174065886798683)],
        &[(0b01001, &ENTRY_RIVALIZED_7182768422071390801)],
        &[(0b01001, &ENTRY_RIVALIZES_2452557101215464168)],
        &[(0b01001, &ENTRY_RIVALIZING_14048952717153236037)],
        &[(0b11010, &ENTRY_RIVALED_1310914145976397449)],
        &[(0b11010, &ENTRY_RIVALESS_17030046039543701469)],
        &[(0b11010, &ENTRY_RIVALESSES_7896212397487020650)],
        &[(0b11010, &ENTRY_RIVALING_6945496358803583057)],
    ],
    range: 3..=12,
};

static VARS_RH_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_RH_CHILDREN),
    value: None,
};

static VARS_RH_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_RHA_NODE),
    None,
    None,
    None,
    Some(&VARS_RHE_NODE),
    None,
    None,
    None,
    Some(&VARS_RHI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_RHO_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_RHY_NODE),
    None,
];

static VARS_RHY_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RHY_CHILDREN),
    value: None,
};

pub static VARS_RHY_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("thmicise"),
        dictgen::InsensitiveStr::Ascii("thmicises"),
        dictgen::InsensitiveStr::Ascii("thmicize"),
        dictgen::InsensitiveStr::Ascii("thmicizes"),
        dictgen::InsensitiveStr::Ascii("thmisable"),
        dictgen::InsensitiveStr::Ascii("thmisables"),
        dictgen::InsensitiveStr::Ascii("thmisation"),
        dictgen::InsensitiveStr::Ascii("thmisations"),
        dictgen::InsensitiveStr::Ascii("thmise"),
        dictgen::InsensitiveStr::Ascii("thmised"),
        dictgen::InsensitiveStr::Ascii("thmises"),
        dictgen::InsensitiveStr::Ascii("thmising"),
        dictgen::InsensitiveStr::Ascii("thmizable"),
        dictgen::InsensitiveStr::Ascii("thmizables"),
        dictgen::InsensitiveStr::Ascii("thmization"),
        dictgen::InsensitiveStr::Ascii("thmizations"),
        dictgen::InsensitiveStr::Ascii("thmize"),
        dictgen::InsensitiveStr::Ascii("thmized"),
        dictgen::InsensitiveStr::Ascii("thmizes"),
        dictgen::InsensitiveStr::Ascii("thmizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RHYTHMICIZE_5163197837266584786)],
        &[(0b10010, &ENTRY_RHYTHMICIZES_6647633033339306298)],
        &[(0b01001, &ENTRY_RHYTHMICIZE_5163197837266584786)],
        &[(0b01001, &ENTRY_RHYTHMICIZES_6647633033339306298)],
        &[(0b10010, &ENTRY_RHYTHMIZABLE_2677462370618412645)],
        &[(0b10010, &ENTRY_RHYTHMIZABLES_17776105921216752906)],
        &[(0b10010, &ENTRY_RHYTHMIZATION_16019734668485258402)],
        &[(0b10010, &ENTRY_RHYTHMIZATIONS_7293786921946666216)],
        &[(0b10010, &ENTRY_RHYTHMIZE_10511981276106529519)],
        &[(0b10010, &ENTRY_RHYTHMIZED_5132054189203196434)],
        &[(0b10010, &ENTRY_RHYTHMIZES_5770183289187248055)],
        &[(0b10010, &ENTRY_RHYTHMIZING_4940630798632079527)],
        &[(0b01001, &ENTRY_RHYTHMIZABLE_2677462370618412645)],
        &[(0b01001, &ENTRY_RHYTHMIZABLES_17776105921216752906)],
        &[(0b01001, &ENTRY_RHYTHMIZATION_16019734668485258402)],
        &[(0b01001, &ENTRY_RHYTHMIZATIONS_7293786921946666216)],
        &[(0b01001, &ENTRY_RHYTHMIZE_10511981276106529519)],
        &[(0b01001, &ENTRY_RHYTHMIZED_5132054189203196434)],
        &[(0b01001, &ENTRY_RHYTHMIZES_5770183289187248055)],
        &[(0b01001, &ENTRY_RHYTHMIZING_4940630798632079527)],
    ],
    range: 6..=11,
};

static VARS_RHO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RHO_CHILDREN),
    value: None,
};

pub static VARS_RHO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("danise"),
        dictgen::InsensitiveStr::Ascii("danised"),
        dictgen::InsensitiveStr::Ascii("danises"),
        dictgen::InsensitiveStr::Ascii("danising"),
        dictgen::InsensitiveStr::Ascii("danize"),
        dictgen::InsensitiveStr::Ascii("danized"),
        dictgen::InsensitiveStr::Ascii("danizes"),
        dictgen::InsensitiveStr::Ascii("danizing"),
        dictgen::InsensitiveStr::Ascii("eadine"),
        dictgen::InsensitiveStr::Ascii("tacise"),
        dictgen::InsensitiveStr::Ascii("tacised"),
        dictgen::InsensitiveStr::Ascii("tacises"),
        dictgen::InsensitiveStr::Ascii("tacising"),
        dictgen::InsensitiveStr::Ascii("tacize"),
        dictgen::InsensitiveStr::Ascii("tacized"),
        dictgen::InsensitiveStr::Ascii("tacizes"),
        dictgen::InsensitiveStr::Ascii("tacizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RHODANIZE_302153013978993410)],
        &[(0b10010, &ENTRY_RHODANIZED_12583740850093807678)],
        &[(0b10010, &ENTRY_RHODANIZES_12761949215613135994)],
        &[(0b10010, &ENTRY_RHODANIZING_15623745248128814712)],
        &[(0b01001, &ENTRY_RHODANIZE_302153013978993410)],
        &[(0b01001, &ENTRY_RHODANIZED_12583740850093807678)],
        &[(0b01001, &ENTRY_RHODANIZES_12761949215613135994)],
        &[(0b01001, &ENTRY_RHODANIZING_15623745248128814712)],
        &[(0b11010, &ENTRY_RHEADINE_9620364319130309940)],
        &[(0b10010, &ENTRY_RHOTACIZE_2196984425576687851)],
        &[(0b10010, &ENTRY_RHOTACIZED_9176740167556084330)],
        &[(0b10010, &ENTRY_RHOTACIZES_700796813593687972)],
        &[(0b10010, &ENTRY_RHOTACIZING_1370798169034491463)],
        &[(0b01001, &ENTRY_RHOTACIZE_2196984425576687851)],
        &[(0b01001, &ENTRY_RHOTACIZED_9176740167556084330)],
        &[(0b01001, &ENTRY_RHOTACIZES_700796813593687972)],
        &[(0b01001, &ENTRY_RHOTACIZING_1370798169034491463)],
    ],
    range: 6..=8,
};

static VARS_RHI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RHI_CHILDREN),
    value: None,
};

pub static VARS_RHI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("nocele"),
        dictgen::InsensitiveStr::Ascii("nocelian"),
        dictgen::InsensitiveStr::Ascii("nocoele"),
        dictgen::InsensitiveStr::Ascii("nocoelian"),
        dictgen::InsensitiveStr::Ascii("norrhea"),
        dictgen::InsensitiveStr::Ascii("norrheal"),
        dictgen::InsensitiveStr::Ascii("norrhoea"),
        dictgen::InsensitiveStr::Ascii("norrhoeal"),
    ],
    values: &[
        &[(0b00001, &ENTRY_RHINOCELE_13394138248730638628)],
        &[(0b00001, &ENTRY_RHINOCELIAN_7468732235130691380)],
        &[(0b11010, &ENTRY_RHINOCELE_13394138248730638628)],
        &[(0b11010, &ENTRY_RHINOCELIAN_7468732235130691380)],
        &[(0b00001, &ENTRY_RHINORRHEA_17760754621625220758)],
        &[(0b00001, &ENTRY_RHINORRHEAL_4168671082299209434)],
        &[(0b11010, &ENTRY_RHINORRHEA_17760754621625220758)],
        &[(0b11010, &ENTRY_RHINORRHEAL_4168671082299209434)],
    ],
    range: 6..=9,
};

static VARS_RHE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RHE_CHILDREN),
    value: None,
};

pub static VARS_RHE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("adine"),
        dictgen::InsensitiveStr::Ascii("bosis"),
        dictgen::InsensitiveStr::Ascii("tian"),
        dictgen::InsensitiveStr::Ascii("tic"),
        dictgen::InsensitiveStr::Ascii("torise"),
        dictgen::InsensitiveStr::Ascii("torised"),
        dictgen::InsensitiveStr::Ascii("torises"),
        dictgen::InsensitiveStr::Ascii("torising"),
        dictgen::InsensitiveStr::Ascii("torize"),
        dictgen::InsensitiveStr::Ascii("torized"),
        dictgen::InsensitiveStr::Ascii("torizes"),
        dictgen::InsensitiveStr::Ascii("torizing"),
        dictgen::InsensitiveStr::Ascii("umatise"),
        dictgen::InsensitiveStr::Ascii("umatised"),
        dictgen::InsensitiveStr::Ascii("umatises"),
        dictgen::InsensitiveStr::Ascii("umatising"),
        dictgen::InsensitiveStr::Ascii("umatize"),
        dictgen::InsensitiveStr::Ascii("umatized"),
        dictgen::InsensitiveStr::Ascii("umatizes"),
        dictgen::InsensitiveStr::Ascii("umatizing"),
    ],
    values: &[
        &[(0b00001, &ENTRY_RHEADINE_9620364319130309940)],
        &[(0b00001, &ENTRY_RHEBOSIS_5734830824723368566)],
        &[(0b00001, &ENTRY_RHETIAN_7773375067640200565)],
        &[(0b00001, &ENTRY_RHETIC_18110954895356174940)],
        &[(0b10010, &ENTRY_RHETORIZE_15085474485565052687)],
        &[(0b10010, &ENTRY_RHETORIZED_12036770468694769802)],
        &[(0b10010, &ENTRY_RHETORIZES_11610320224318377716)],
        &[(0b10010, &ENTRY_RHETORIZING_4161503331833209409)],
        &[(0b01001, &ENTRY_RHETORIZE_15085474485565052687)],
        &[(0b01001, &ENTRY_RHETORIZED_12036770468694769802)],
        &[(0b01001, &ENTRY_RHETORIZES_11610320224318377716)],
        &[(0b01001, &ENTRY_RHETORIZING_4161503331833209409)],
        &[(0b10010, &ENTRY_RHEUMATIZE_1531026966882650471)],
        &[(0b10010, &ENTRY_RHEUMATIZED_5025722576540634515)],
        &[(0b10010, &ENTRY_RHEUMATIZES_5411071701844053603)],
        &[(0b10010, &ENTRY_RHEUMATIZING_16915712102407745517)],
        &[(0b01001, &ENTRY_RHEUMATIZE_1531026966882650471)],
        &[(0b01001, &ENTRY_RHEUMATIZED_5025722576540634515)],
        &[(0b01001, &ENTRY_RHEUMATIZES_5411071701844053603)],
        &[(0b01001, &ENTRY_RHEUMATIZING_16915712102407745517)],
    ],
    range: 3..=9,
};

static VARS_RHA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RHA_CHILDREN),
    value: None,
};

pub static VARS_RHA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ebosis"),
        dictgen::InsensitiveStr::Ascii("etian"),
        dictgen::InsensitiveStr::Ascii("etic"),
        dictgen::InsensitiveStr::Ascii("phae"),
        dictgen::InsensitiveStr::Ascii("phe"),
        dictgen::InsensitiveStr::Ascii("psodise"),
        dictgen::InsensitiveStr::Ascii("psodised"),
        dictgen::InsensitiveStr::Ascii("psodises"),
        dictgen::InsensitiveStr::Ascii("psodising"),
        dictgen::InsensitiveStr::Ascii("psodize"),
        dictgen::InsensitiveStr::Ascii("psodized"),
        dictgen::InsensitiveStr::Ascii("psodizes"),
        dictgen::InsensitiveStr::Ascii("psodizing"),
    ],
    values: &[
        &[(0b11010, &ENTRY_RHEBOSIS_5734830824723368566)],
        &[(0b11010, &ENTRY_RHETIAN_7773375067640200565)],
        &[(0b11010, &ENTRY_RHETIC_18110954895356174940)],
        &[(0b11010, &ENTRY_RHAPHE_12384818764664453874)],
        &[(0b00001, &ENTRY_RHAPHE_12384818764664453874)],
        &[(0b10010, &ENTRY_RHAPSODIZE_12516177585413432849)],
        &[(0b10010, &ENTRY_RHAPSODIZED_11519621996184024336)],
        &[(0b10010, &ENTRY_RHAPSODIZES_7765267067797422211)],
        &[(0b10010, &ENTRY_RHAPSODIZING_13362377815551382619)],
        &[(0b01001, &ENTRY_RHAPSODIZE_12516177585413432849)],
        &[(0b01001, &ENTRY_RHAPSODIZED_11519621996184024336)],
        &[(0b01001, &ENTRY_RHAPSODIZES_7765267067797422211)],
        &[(0b01001, &ENTRY_RHAPSODIZING_13362377815551382619)],
    ],
    range: 3..=9,
};

static VARS_RE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_RE_CHILDREN),
    value: None,
};

static VARS_RE_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_REA_NODE),
    Some(&VARS_REB_NODE),
    Some(&VARS_REC_NODE),
    Some(&VARS_RED_NODE),
    Some(&VARS_REE_NODE),
    Some(&VARS_REF_NODE),
    Some(&VARS_REG_NODE),
    Some(&VARS_REH_NODE),
    Some(&VARS_REI_NODE),
    Some(&VARS_REJ_NODE),
    Some(&VARS_REK_NODE),
    Some(&VARS_REL_NODE),
    Some(&VARS_REM_NODE),
    Some(&VARS_REN_NODE),
    Some(&VARS_REO_NODE),
    Some(&VARS_REP_NODE),
    None,
    Some(&VARS_RER_NODE),
    Some(&VARS_RES_NODE),
    Some(&VARS_RET_NODE),
    Some(&VARS_REU_NODE),
    Some(&VARS_REV_NODE),
    None,
    Some(&VARS_REX_NODE),
    None,
    None,
];

static VARS_REX_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_REX_CHILDREN),
    value: None,
};

pub static VARS_REX_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ford"),
        dictgen::InsensitiveStr::Ascii("fourd"),
    ],
    values: &[
        &[(0b00001, &ENTRY_REXFORD_3887609989644811794)],
        &[(0b11010, &ENTRY_REXFORD_3887609989644811794)],
    ],
    range: 4..=5,
};

static VARS_REV_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_REV_CHILDREN),
    value: None,
};

static VARS_REV_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_REVA_NODE),
    None,
    None,
    None,
    Some(&VARS_REVE_NODE),
    None,
    None,
    None,
    Some(&VARS_REVI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_REVO_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static VARS_REVO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_REVO_CHILDREN),
    value: None,
};

pub static VARS_REVO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("latilise"),
        dictgen::InsensitiveStr::Ascii("latilises"),
        dictgen::InsensitiveStr::Ascii("latilize"),
        dictgen::InsensitiveStr::Ascii("latilizes"),
        dictgen::InsensitiveStr::Ascii("lutionise"),
        dictgen::InsensitiveStr::Ascii("lutionised"),
        dictgen::InsensitiveStr::Ascii("lutionisement"),
        dictgen::InsensitiveStr::Ascii("lutionisements"),
        dictgen::InsensitiveStr::Ascii("lutioniser"),
        dictgen::InsensitiveStr::Ascii("lutionisers"),
        dictgen::InsensitiveStr::Ascii("lutionises"),
        dictgen::InsensitiveStr::Ascii("lutionising"),
        dictgen::InsensitiveStr::Ascii("lutionize"),
        dictgen::InsensitiveStr::Ascii("lutionized"),
        dictgen::InsensitiveStr::Ascii("lutionizement"),
        dictgen::InsensitiveStr::Ascii("lutionizements"),
        dictgen::InsensitiveStr::Ascii("lutionizer"),
        dictgen::InsensitiveStr::Ascii("lutionizers"),
        dictgen::InsensitiveStr::Ascii("lutionizes"),
        dictgen::InsensitiveStr::Ascii("lutionizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_REVOLATILIZE_2071105640143175086)],
        &[(0b10010, &ENTRY_REVOLATILIZES_261087607754605694)],
        &[(0b01001, &ENTRY_REVOLATILIZE_2071105640143175086)],
        &[(0b01001, &ENTRY_REVOLATILIZES_261087607754605694)],
        &[(0b10010, &ENTRY_REVOLUTIONIZE_7544492450899006022)],
        &[(0b10010, &ENTRY_REVOLUTIONIZED_14375673469401672065)],
        &[(0b10010, &ENTRY_REVOLUTIONIZEMENT_3712613042773672198)],
        &[(0b10010, &ENTRY_REVOLUTIONIZEMENTS_8372696219470999573)],
        &[(0b10010, &ENTRY_REVOLUTIONIZER_13149778382986804291)],
        &[(0b10010, &ENTRY_REVOLUTIONIZERS_8217397059633187294)],
        &[(0b10010, &ENTRY_REVOLUTIONIZES_6397868062466700275)],
        &[(0b10010, &ENTRY_REVOLUTIONIZING_5584470119488633133)],
        &[(0b01001, &ENTRY_REVOLUTIONIZE_7544492450899006022)],
        &[(0b01001, &ENTRY_REVOLUTIONIZED_14375673469401672065)],
        &[(0b01001, &ENTRY_REVOLUTIONIZEMENT_3712613042773672198)],
        &[(0b01001, &ENTRY_REVOLUTIONIZEMENTS_8372696219470999573)],
        &[(0b01001, &ENTRY_REVOLUTIONIZER_13149778382986804291)],
        &[(0b01001, &ENTRY_REVOLUTIONIZERS_8217397059633187294)],
        &[(0b01001, &ENTRY_REVOLUTIONIZES_6397868062466700275)],
        &[(0b01001, &ENTRY_REVOLUTIONIZING_5584470119488633133)],
    ],
    range: 8..=14,
};

static VARS_REVI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_REVI_CHILDREN),
    value: None,
};

pub static VARS_REVI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gor"),
        dictgen::InsensitiveStr::Ascii("gour"),
        dictgen::InsensitiveStr::Ascii("sualisation"),
        dictgen::InsensitiveStr::Ascii("sualisations"),
        dictgen::InsensitiveStr::Ascii("sualise"),
        dictgen::InsensitiveStr::Ascii("sualises"),
        dictgen::InsensitiveStr::Ascii("sualization"),
        dictgen::InsensitiveStr::Ascii("sualizations"),
        dictgen::InsensitiveStr::Ascii("sualize"),
        dictgen::InsensitiveStr::Ascii("sualizes"),
        dictgen::InsensitiveStr::Ascii("talisation"),
        dictgen::InsensitiveStr::Ascii("talisations"),
        dictgen::InsensitiveStr::Ascii("talise"),
        dictgen::InsensitiveStr::Ascii("talised"),
        dictgen::InsensitiveStr::Ascii("taliser"),
        dictgen::InsensitiveStr::Ascii("talisers"),
        dictgen::InsensitiveStr::Ascii("talises"),
        dictgen::InsensitiveStr::Ascii("talising"),
        dictgen::InsensitiveStr::Ascii("talization"),
        dictgen::InsensitiveStr::Ascii("talizations"),
        dictgen::InsensitiveStr::Ascii("talize"),
        dictgen::InsensitiveStr::Ascii("talized"),
        dictgen::InsensitiveStr::Ascii("talizer"),
        dictgen::InsensitiveStr::Ascii("talizers"),
        dictgen::InsensitiveStr::Ascii("talizes"),
        dictgen::InsensitiveStr::Ascii("talizing"),
        dictgen::InsensitiveStr::Ascii("valise"),
        dictgen::InsensitiveStr::Ascii("valises"),
        dictgen::InsensitiveStr::Ascii("valize"),
        dictgen::InsensitiveStr::Ascii("valizes"),
    ],
    values: &[
        &[(0b00001, &ENTRY_REVIGOR_2376178882147635752)],
        &[(0b11010, &ENTRY_REVIGOR_2376178882147635752)],
        &[(0b10010, &ENTRY_REVISUALIZATION_8953713191827785558)],
        &[(0b10010, &ENTRY_REVISUALIZATIONS_5722856801090540723)],
        &[(0b10010, &ENTRY_REVISUALIZE_10854082452689148747)],
        &[(0b10010, &ENTRY_REVISUALIZES_757435382058959188)],
        &[(0b01001, &ENTRY_REVISUALIZATION_8953713191827785558)],
        &[(0b01001, &ENTRY_REVISUALIZATIONS_5722856801090540723)],
        &[(0b01001, &ENTRY_REVISUALIZE_10854082452689148747)],
        &[(0b01001, &ENTRY_REVISUALIZES_757435382058959188)],
        &[(0b10010, &ENTRY_REVITALIZATION_13062486022413792020)],
        &[(0b10010, &ENTRY_REVITALIZATIONS_10832630253278670475)],
        &[(0b10010, &ENTRY_REVITALIZE_193715103532234630)],
        &[(0b10010, &ENTRY_REVITALIZED_8383897663298145675)],
        &[(0b10010, &ENTRY_REVITALIZER_1269369318155795055)],
        &[(0b10010, &ENTRY_REVITALIZERS_8120596477873838119)],
        &[(0b10010, &ENTRY_REVITALIZES_17733294788931304767)],
        &[(0b10010, &ENTRY_REVITALIZING_16112731945721210438)],
        &[(0b01001, &ENTRY_REVITALIZATION_13062486022413792020)],
        &[(0b01001, &ENTRY_REVITALIZATIONS_10832630253278670475)],
        &[(0b01001, &ENTRY_REVITALIZE_193715103532234630)],
        &[(0b01001, &ENTRY_REVITALIZED_8383897663298145675)],
        &[(0b01001, &ENTRY_REVITALIZER_1269369318155795055)],
        &[(0b01001, &ENTRY_REVITALIZERS_8120596477873838119)],
        &[(0b01001, &ENTRY_REVITALIZES_17733294788931304767)],
        &[(0b01001, &ENTRY_REVITALIZING_16112731945721210438)],
        &[(0b10010, &ENTRY_REVIVALIZE_12399394256488111764)],
        &[(0b10010, &ENTRY_REVIVALIZES_3796336163019290557)],
        &[(0b01001, &ENTRY_REVIVALIZE_12399394256488111764)],
        &[(0b01001, &ENTRY_REVIVALIZES_3796336163019290557)],
    ],
    range: 3..=12,
};

static VARS_REVE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_REVE_CHILDREN),
    value: None,
};

pub static VARS_REVE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lationise"),
        dictgen::InsensitiveStr::Ascii("lationises"),
        dictgen::InsensitiveStr::Ascii("lationize"),
        dictgen::InsensitiveStr::Ascii("lationizes"),
        dictgen::InsensitiveStr::Ascii("led"),
        dictgen::InsensitiveStr::Ascii("ler"),
        dictgen::InsensitiveStr::Ascii("lers"),
        dictgen::InsensitiveStr::Ascii("ling"),
        dictgen::InsensitiveStr::Ascii("lings"),
        dictgen::InsensitiveStr::Ascii("lled"),
        dictgen::InsensitiveStr::Ascii("ller"),
        dictgen::InsensitiveStr::Ascii("llers"),
        dictgen::InsensitiveStr::Ascii("lling"),
        dictgen::InsensitiveStr::Ascii("llings"),
    ],
    values: &[
        &[(0b10010, &ENTRY_REVELATIONIZE_5638146163757517114)],
        &[(0b10010, &ENTRY_REVELATIONIZES_5374780340001639912)],
        &[(0b01001, &ENTRY_REVELATIONIZE_5638146163757517114)],
        &[(0b01001, &ENTRY_REVELATIONIZES_5374780340001639912)],
        &[(0b00001, &ENTRY_REVELED_3269597357727386753)],
        &[(0b00001, &ENTRY_REVELER_6411534393495033889)],
        &[(0b00001, &ENTRY_REVELERS_6407829396102668960)],
        &[(0b00001, &ENTRY_REVELING_7333428498196314928)],
        &[(0b00001, &ENTRY_REVELINGS_14514277807211085480)],
        &[(0b11010, &ENTRY_REVELED_3269597357727386753)],
        &[(0b11010, &ENTRY_REVELER_6411534393495033889)],
        &[(0b11010, &ENTRY_REVELERS_6407829396102668960)],
        &[(0b11010, &ENTRY_REVELING_7333428498196314928)],
        &[(0b11010, &ENTRY_REVELINGS_14514277807211085480)],
    ],
    range: 3..=10,
};

static VARS_REVA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_REVA_CHILDREN),
    value: None,
};

pub static VARS_REVA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lenta"),
        dictgen::InsensitiveStr::Ascii("lentas"),
        dictgen::InsensitiveStr::Ascii("lorisation"),
        dictgen::InsensitiveStr::Ascii("lorisations"),
        dictgen::InsensitiveStr::Ascii("lorise"),
        dictgen::InsensitiveStr::Ascii("lorised"),
        dictgen::InsensitiveStr::Ascii("lorises"),
        dictgen::InsensitiveStr::Ascii("lorising"),
        dictgen::InsensitiveStr::Ascii("lorization"),
        dictgen::InsensitiveStr::Ascii("lorizations"),
        dictgen::InsensitiveStr::Ascii("lorize"),
        dictgen::InsensitiveStr::Ascii("lorized"),
        dictgen::InsensitiveStr::Ascii("lorizes"),
        dictgen::InsensitiveStr::Ascii("lorizing"),
        dictgen::InsensitiveStr::Ascii("porise"),
        dictgen::InsensitiveStr::Ascii("porises"),
        dictgen::InsensitiveStr::Ascii("porization"),
        dictgen::InsensitiveStr::Ascii("porizations"),
        dictgen::InsensitiveStr::Ascii("porize"),
        dictgen::InsensitiveStr::Ascii("porizes"),
        dictgen::InsensitiveStr::Ascii("pourisation"),
        dictgen::InsensitiveStr::Ascii("pourisations"),
    ],
    values: &[
        &[(0b11010, &ENTRY_ERVALENTA_10785450433515167284)],
        &[(0b11010, &ENTRY_ERVALENTAS_18174157063570728071)],
        &[(0b10010, &ENTRY_REVALORIZATION_16691637355795598388)],
        &[(0b10010, &ENTRY_REVALORIZATIONS_8329585362057485832)],
        &[(0b10010, &ENTRY_REVALORIZE_2146865524723286062)],
        &[(0b10010, &ENTRY_REVALORIZED_390002619883458956)],
        &[(0b10010, &ENTRY_REVALORIZES_9002308862045152018)],
        &[(0b10010, &ENTRY_REVALORIZING_15461035195176448361)],
        &[(0b01001, &ENTRY_REVALORIZATION_16691637355795598388)],
        &[(0b01001, &ENTRY_REVALORIZATIONS_8329585362057485832)],
        &[(0b01001, &ENTRY_REVALORIZE_2146865524723286062)],
        &[(0b01001, &ENTRY_REVALORIZED_390002619883458956)],
        &[(0b01001, &ENTRY_REVALORIZES_9002308862045152018)],
        &[(0b01001, &ENTRY_REVALORIZING_15461035195176448361)],
        &[(0b10010, &ENTRY_REVAPORIZE_7400570187982142267)],
        &[(0b10010, &ENTRY_REVAPORIZES_10059326494130071423)],
        &[(0b01001, &ENTRY_REVAPORIZATION_13446372973926423118)],
        &[(0b01001, &ENTRY_REVAPORIZATIONS_5789264572660925070)],
        &[(0b01001, &ENTRY_REVAPORIZE_7400570187982142267)],
        &[(0b01001, &ENTRY_REVAPORIZES_10059326494130071423)],
        &[(0b10010, &ENTRY_REVAPORIZATION_13446372973926423118)],
        &[(0b10010, &ENTRY_REVAPORIZATIONS_5789264572660925070)],
    ],
    range: 5..=12,
};

static VARS_REU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_REU_CHILDREN),
    value: None,
};

pub static VARS_REU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("tilisation"),
        dictgen::InsensitiveStr::Ascii("tilise"),
        dictgen::InsensitiveStr::Ascii("tilised"),
        dictgen::InsensitiveStr::Ascii("tilises"),
        dictgen::InsensitiveStr::Ascii("tilising"),
        dictgen::InsensitiveStr::Ascii("tilization"),
        dictgen::InsensitiveStr::Ascii("tilize"),
        dictgen::InsensitiveStr::Ascii("tilized"),
        dictgen::InsensitiveStr::Ascii("tilizes"),
        dictgen::InsensitiveStr::Ascii("tilizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_REUTILIZATION_2443696530088053698)],
        &[(0b10010, &ENTRY_REUTILIZE_1981534996476836105)],
        &[(0b10010, &ENTRY_REUTILIZED_16677084184753064782)],
        &[(0b10010, &ENTRY_REUTILIZES_14294564954952197276)],
        &[(0b10010, &ENTRY_REUTILIZING_4912219485422295764)],
        &[(0b01001, &ENTRY_REUTILIZATION_2443696530088053698)],
        &[(0b01001, &ENTRY_REUTILIZE_1981534996476836105)],
        &[(0b01001, &ENTRY_REUTILIZED_16677084184753064782)],
        &[(0b01001, &ENTRY_REUTILIZES_14294564954952197276)],
        &[(0b01001, &ENTRY_REUTILIZING_4912219485422295764)],
    ],
    range: 6..=10,
};

static VARS_RET_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RET_CHILDREN),
    value: Some(&[(0b11010, &ENTRY_ERT_3341098308248153715)]),
};

pub static VARS_RET_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("inise"),
        dictgen::InsensitiveStr::Ascii("inises"),
        dictgen::InsensitiveStr::Ascii("inize"),
        dictgen::InsensitiveStr::Ascii("inizes"),
        dictgen::InsensitiveStr::Ascii("inulae"),
        dictgen::InsensitiveStr::Ascii("inule"),
        dictgen::InsensitiveStr::Ascii("ranquilise"),
        dictgen::InsensitiveStr::Ascii("ranquilises"),
        dictgen::InsensitiveStr::Ascii("ranquilize"),
        dictgen::InsensitiveStr::Ascii("ranquilizes"),
        dictgen::InsensitiveStr::Ascii("rocaecal"),
        dictgen::InsensitiveStr::Ascii("rocecal"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RETINIZE_8601446109320109567)],
        &[(0b10010, &ENTRY_RETINIZES_17069507706296598945)],
        &[(0b01001, &ENTRY_RETINIZE_8601446109320109567)],
        &[(0b01001, &ENTRY_RETINIZES_17069507706296598945)],
        &[(0b11010, &ENTRY_RETINULE_17387772655780198016)],
        &[(0b00001, &ENTRY_RETINULE_17387772655780198016)],
        &[(0b10010, &ENTRY_RETRANQUILIZE_10089381173173353384)],
        &[(0b10010, &ENTRY_RETRANQUILIZES_11477435536722915071)],
        &[(0b01001, &ENTRY_RETRANQUILIZE_10089381173173353384)],
        &[(0b01001, &ENTRY_RETRANQUILIZES_11477435536722915071)],
        &[(0b11010, &ENTRY_RETROCECAL_264766737757922842)],
        &[(0b00001, &ENTRY_RETROCECAL_264766737757922842)],
    ],
    range: 5..=11,
};

static VARS_RES_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_RES_CHILDREN),
    value: None,
};

static VARS_RES_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    None,
    None,
    None,
    None,
    Some(&VARS_RESE_NODE),
    None,
    None,
    Some(&VARS_RESH_NODE),
    Some(&VARS_RESI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_RESO_NODE),
    Some(&VARS_RESP_NODE),
    None,
    None,
    None,
    Some(&VARS_REST_NODE),
    Some(&VARS_RESU_NODE),
    None,
    None,
    None,
    Some(&VARS_RESY_NODE),
    None,
];

static VARS_RESY_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RESY_CHILDREN),
    value: None,
};

pub static VARS_RESY_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("mbolisation"),
        dictgen::InsensitiveStr::Ascii("mbolisations"),
        dictgen::InsensitiveStr::Ascii("mbolise"),
        dictgen::InsensitiveStr::Ascii("mbolises"),
        dictgen::InsensitiveStr::Ascii("mbolization"),
        dictgen::InsensitiveStr::Ascii("mbolizations"),
        dictgen::InsensitiveStr::Ascii("mbolize"),
        dictgen::InsensitiveStr::Ascii("mbolizes"),
        dictgen::InsensitiveStr::Ascii("nchronisation"),
        dictgen::InsensitiveStr::Ascii("nchronisations"),
        dictgen::InsensitiveStr::Ascii("nchronise"),
        dictgen::InsensitiveStr::Ascii("nchronised"),
        dictgen::InsensitiveStr::Ascii("nchronises"),
        dictgen::InsensitiveStr::Ascii("nchronising"),
        dictgen::InsensitiveStr::Ascii("nchronization"),
        dictgen::InsensitiveStr::Ascii("nchronizations"),
        dictgen::InsensitiveStr::Ascii("nchronize"),
        dictgen::InsensitiveStr::Ascii("nchronized"),
        dictgen::InsensitiveStr::Ascii("nchronizes"),
        dictgen::InsensitiveStr::Ascii("nchronizing"),
        dictgen::InsensitiveStr::Ascii("nthesise"),
        dictgen::InsensitiveStr::Ascii("nthesises"),
        dictgen::InsensitiveStr::Ascii("nthesize"),
        dictgen::InsensitiveStr::Ascii("nthesizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RESYMBOLIZATION_18289962759086702120)],
        &[(0b10010, &ENTRY_RESYMBOLIZATIONS_13698200804085478042)],
        &[(0b10010, &ENTRY_RESYMBOLIZE_14905039520367290035)],
        &[(0b10010, &ENTRY_RESYMBOLIZES_15380238287856922249)],
        &[(0b01001, &ENTRY_RESYMBOLIZATION_18289962759086702120)],
        &[(0b01001, &ENTRY_RESYMBOLIZATIONS_13698200804085478042)],
        &[(0b01001, &ENTRY_RESYMBOLIZE_14905039520367290035)],
        &[(0b01001, &ENTRY_RESYMBOLIZES_15380238287856922249)],
        &[(0b10010, &ENTRY_RESYNCHRONIZATION_5015538818065006720)],
        &[(0b10010, &ENTRY_RESYNCHRONIZATIONS_15270865884370608060)],
        &[(0b10010, &ENTRY_RESYNCHRONIZE_2523532124129456381)],
        &[(0b10010, &ENTRY_RESYNCHRONIZED_3132801989882471857)],
        &[(0b10010, &ENTRY_RESYNCHRONIZES_5801125742459097915)],
        &[(0b10010, &ENTRY_RESYNCHRONIZING_2324560686252943876)],
        &[(0b01001, &ENTRY_RESYNCHRONIZATION_5015538818065006720)],
        &[(0b01001, &ENTRY_RESYNCHRONIZATIONS_15270865884370608060)],
        &[(0b01001, &ENTRY_RESYNCHRONIZE_2523532124129456381)],
        &[(0b01001, &ENTRY_RESYNCHRONIZED_3132801989882471857)],
        &[(0b01001, &ENTRY_RESYNCHRONIZES_5801125742459097915)],
        &[(0b01001, &ENTRY_RESYNCHRONIZING_2324560686252943876)],
        &[(0b10010, &ENTRY_RESYNTHESIZE_8960121186358208467)],
        &[(0b10010, &ENTRY_RESYNTHESIZES_5964175748046341312)],
        &[(0b01001, &ENTRY_RESYNTHESIZE_8960121186358208467)],
        &[(0b01001, &ENTRY_RESYNTHESIZES_5964175748046341312)],
    ],
    range: 7..=14,
};

static VARS_RESU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RESU_CHILDREN),
    value: None,
};

pub static VARS_RESU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rrectionise"),
        dictgen::InsensitiveStr::Ascii("rrectionised"),
        dictgen::InsensitiveStr::Ascii("rrectionises"),
        dictgen::InsensitiveStr::Ascii("rrectionising"),
        dictgen::InsensitiveStr::Ascii("rrectionize"),
        dictgen::InsensitiveStr::Ascii("rrectionized"),
        dictgen::InsensitiveStr::Ascii("rrectionizes"),
        dictgen::InsensitiveStr::Ascii("rrectionizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RESURRECTIONIZE_6291356889036253818)],
        &[(0b10010, &ENTRY_RESURRECTIONIZED_9400111854395469022)],
        &[(0b10010, &ENTRY_RESURRECTIONIZES_13187140164794979295)],
        &[(0b10010, &ENTRY_RESURRECTIONIZING_691774540853612989)],
        &[(0b01001, &ENTRY_RESURRECTIONIZE_6291356889036253818)],
        &[(0b01001, &ENTRY_RESURRECTIONIZED_9400111854395469022)],
        &[(0b01001, &ENTRY_RESURRECTIONIZES_13187140164794979295)],
        &[(0b01001, &ENTRY_RESURRECTIONIZING_691774540853612989)],
    ],
    range: 11..=13,
};

static VARS_REST_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_REST_CHILDREN),
    value: None,
};

pub static VARS_REST_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("andardisation"),
        dictgen::InsensitiveStr::Ascii("andardisations"),
        dictgen::InsensitiveStr::Ascii("andardise"),
        dictgen::InsensitiveStr::Ascii("andardises"),
        dictgen::InsensitiveStr::Ascii("andardization"),
        dictgen::InsensitiveStr::Ascii("andardizations"),
        dictgen::InsensitiveStr::Ascii("andardize"),
        dictgen::InsensitiveStr::Ascii("andardizes"),
        dictgen::InsensitiveStr::Ascii("erilise"),
        dictgen::InsensitiveStr::Ascii("erilises"),
        dictgen::InsensitiveStr::Ascii("erilize"),
        dictgen::InsensitiveStr::Ascii("erilizes"),
        dictgen::InsensitiveStr::Ascii("igmatise"),
        dictgen::InsensitiveStr::Ascii("igmatises"),
        dictgen::InsensitiveStr::Ascii("igmatize"),
        dictgen::InsensitiveStr::Ascii("igmatizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RESTANDARDIZATION_1125896047095372970)],
        &[(0b10010, &ENTRY_RESTANDARDIZATIONS_13459493042218397698)],
        &[(0b10010, &ENTRY_RESTANDARDIZE_8395056711505036016)],
        &[(0b10010, &ENTRY_RESTANDARDIZES_16671190134442482587)],
        &[(0b01001, &ENTRY_RESTANDARDIZATION_1125896047095372970)],
        &[(0b01001, &ENTRY_RESTANDARDIZATIONS_13459493042218397698)],
        &[(0b01001, &ENTRY_RESTANDARDIZE_8395056711505036016)],
        &[(0b01001, &ENTRY_RESTANDARDIZES_16671190134442482587)],
        &[(0b10010, &ENTRY_RESTERILIZE_4378046269917637799)],
        &[(0b10010, &ENTRY_RESTERILIZES_6083780946048684800)],
        &[(0b01001, &ENTRY_RESTERILIZE_4378046269917637799)],
        &[(0b01001, &ENTRY_RESTERILIZES_6083780946048684800)],
        &[(0b10010, &ENTRY_RESTIGMATIZE_4978105981890694357)],
        &[(0b10010, &ENTRY_RESTIGMATIZES_6711731024062346456)],
        &[(0b01001, &ENTRY_RESTIGMATIZE_4978105981890694357)],
        &[(0b01001, &ENTRY_RESTIGMATIZES_6711731024062346456)],
    ],
    range: 7..=14,
};

static VARS_RESP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RESP_CHILDREN),
    value: None,
};

pub static VARS_RESP_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ectabilise"),
        dictgen::InsensitiveStr::Ascii("ectabilised"),
        dictgen::InsensitiveStr::Ascii("ectabilises"),
        dictgen::InsensitiveStr::Ascii("ectabilising"),
        dictgen::InsensitiveStr::Ascii("ectabilize"),
        dictgen::InsensitiveStr::Ascii("ectabilized"),
        dictgen::InsensitiveStr::Ascii("ectabilizes"),
        dictgen::InsensitiveStr::Ascii("ectabilizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RESPECTABILIZE_11155380117077366918)],
        &[(0b10010, &ENTRY_RESPECTABILIZED_14730970511118216639)],
        &[(0b10010, &ENTRY_RESPECTABILIZES_14602704037450130293)],
        &[(0b10010, &ENTRY_RESPECTABILIZING_10915529601473940175)],
        &[(0b01001, &ENTRY_RESPECTABILIZE_11155380117077366918)],
        &[(0b01001, &ENTRY_RESPECTABILIZED_14730970511118216639)],
        &[(0b01001, &ENTRY_RESPECTABILIZES_14602704037450130293)],
        &[(0b01001, &ENTRY_RESPECTABILIZING_10915529601473940175)],
    ],
    range: 10..=12,
};

static VARS_RESO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RESO_CHILDREN),
    value: None,
};

pub static VARS_RESO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lemnise"),
        dictgen::InsensitiveStr::Ascii("lemnises"),
        dictgen::InsensitiveStr::Ascii("lemnize"),
        dictgen::InsensitiveStr::Ascii("lemnizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RESOLEMNIZE_6056068872801503882)],
        &[(0b10010, &ENTRY_RESOLEMNIZES_10613919753057256614)],
        &[(0b01001, &ENTRY_RESOLEMNIZE_6056068872801503882)],
        &[(0b01001, &ENTRY_RESOLEMNIZES_10613919753057256614)],
    ],
    range: 7..=8,
};

static VARS_RESI_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RESI_CHILDREN),
    value: None,
};

pub static VARS_RESI_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("nise"),
        dictgen::InsensitiveStr::Ascii("nised"),
        dictgen::InsensitiveStr::Ascii("nises"),
        dictgen::InsensitiveStr::Ascii("nising"),
        dictgen::InsensitiveStr::Ascii("nize"),
        dictgen::InsensitiveStr::Ascii("nized"),
        dictgen::InsensitiveStr::Ascii("nizes"),
        dictgen::InsensitiveStr::Ascii("nizing"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RESINIZE_14451332919662209430)],
        &[(0b10010, &ENTRY_RESINIZED_13345987737745617709)],
        &[(0b10010, &ENTRY_RESINIZES_7409295825688368205)],
        &[(0b10010, &ENTRY_RESINIZING_7347311689783160837)],
        &[(0b01001, &ENTRY_RESINIZE_14451332919662209430)],
        &[(0b01001, &ENTRY_RESINIZED_13345987737745617709)],
        &[(0b01001, &ENTRY_RESINIZES_7409295825688368205)],
        &[(0b01001, &ENTRY_RESINIZING_7347311689783160837)],
    ],
    range: 4..=6,
};

static VARS_RESH_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RESH_CHILDREN),
    value: Some(&[(0b11010, &ENTRY_ERSH_939187057767591954)]),
};

pub static VARS_RESH_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("oes"),
    ],
    values: &[
        &[(0b00001, &ENTRY_RESHES_14193366709422680589)],
        &[(0b11010, &ENTRY_RESHES_14193366709422680589)],
    ],
    range: 2..=3,
};

static VARS_RESE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RESE_CHILDREN),
    value: None,
};

pub static VARS_RESE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ise"),
        dictgen::InsensitiveStr::Ascii("iser"),
        dictgen::InsensitiveStr::Ascii("ize"),
        dictgen::InsensitiveStr::Ascii("izer"),
        dictgen::InsensitiveStr::Ascii("nsitisation"),
        dictgen::InsensitiveStr::Ascii("nsitisations"),
        dictgen::InsensitiveStr::Ascii("nsitise"),
        dictgen::InsensitiveStr::Ascii("nsitises"),
        dictgen::InsensitiveStr::Ascii("nsitization"),
        dictgen::InsensitiveStr::Ascii("nsitizations"),
        dictgen::InsensitiveStr::Ascii("nsitize"),
        dictgen::InsensitiveStr::Ascii("nsitizes"),
        dictgen::InsensitiveStr::Ascii("pulcher"),
        dictgen::InsensitiveStr::Ascii("pulchers"),
        dictgen::InsensitiveStr::Ascii("pulchre"),
        dictgen::InsensitiveStr::Ascii("pulchres"),
        dictgen::InsensitiveStr::Ascii("s"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RESEIZE_11829660618323635615)],
        &[(0b10010, &ENTRY_RESEIZER_14462609884001927595)],
        &[(0b01001, &ENTRY_RESEIZE_11829660618323635615)],
        &[(0b01001, &ENTRY_RESEIZER_14462609884001927595)],
        &[(0b10010, &ENTRY_RESENSITIZATION_3685514235786941102)],
        &[(0b10010, &ENTRY_RESENSITIZATIONS_919995710981311836)],
        &[(0b10010, &ENTRY_RESENSITIZE_1303613677297439531)],
        &[(0b10010, &ENTRY_RESENSITIZES_12908617404622953233)],
        &[(0b01001, &ENTRY_RESENSITIZATION_3685514235786941102)],
        &[(0b01001, &ENTRY_RESENSITIZATIONS_919995710981311836)],
        &[(0b01001, &ENTRY_RESENSITIZE_1303613677297439531)],
        &[(0b01001, &ENTRY_RESENSITIZES_12908617404622953233)],
        &[(0b00001, &ENTRY_RESEPULCHER_13255687324173800374)],
        &[(0b00001, &ENTRY_RESEPULCHERS_6740248117563664747)],
        &[(0b11010, &ENTRY_RESEPULCHER_13255687324173800374)],
        &[(0b11010, &ENTRY_RESEPULCHERS_6740248117563664747)],
        &[(0b11010, &ENTRY_ERSES_5709814492624908686)],
    ],
    range: 1..=12,
};

static VARS_RER_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_RER_CHILDREN),
    value: None,
};

pub static VARS_RER_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("oyalise"),
        dictgen::InsensitiveStr::Ascii("oyalises"),
        dictgen::InsensitiveStr::Ascii("oyalize"),
        dictgen::InsensitiveStr::Ascii("oyalizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_REROYALIZE_9299210178122090712)],
        &[(0b10010, &ENTRY_REROYALIZES_658053808235761746)],
        &[(0b01001, &ENTRY_REROYALIZE_9299210178122090712)],
        &[(0b01001, &ENTRY_REROYALIZES_658053808235761746)],
    ],
    range: 7..=8,
};

static VARS_REP_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_REP_CHILDREN),
    value: None,
};

static VARS_REP_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_REPA_NODE),
    None,
    None,
    None,
    Some(&VARS_REPE_NODE),
    None,
    None,
    Some(&VARS_REPH_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_REPO_NODE),
    None,
    None,
    Some(&VARS_REPR_NODE),
    None,
    None,
    Some(&VARS_REPU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static VARS_REPU_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_REPU_CHILDREN),
    value: None,
};

pub static VARS_REPU_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("blicanisation"),
        dictgen::InsensitiveStr::Ascii("blicanisations"),
        dictgen::InsensitiveStr::Ascii("blicanise"),
        dictgen::InsensitiveStr::Ascii("blicanised"),
        dictgen::InsensitiveStr::Ascii("blicaniser"),
        dictgen::InsensitiveStr::Ascii("blicanisers"),
        dictgen::InsensitiveStr::Ascii("blicanises"),
        dictgen::InsensitiveStr::Ascii("blicanising"),
        dictgen::InsensitiveStr::Ascii("blicanization"),
        dictgen::InsensitiveStr::Ascii("blicanizations"),
        dictgen::InsensitiveStr::Ascii("blicanize"),
        dictgen::InsensitiveStr::Ascii("blicanized"),
        dictgen::InsensitiveStr::Ascii("blicanizer"),
        dictgen::InsensitiveStr::Ascii("blicanizers"),
        dictgen::InsensitiveStr::Ascii("blicanizes"),
        dictgen::InsensitiveStr::Ascii("blicanizing"),
        dictgen::InsensitiveStr::Ascii("lverise"),
        dictgen::InsensitiveStr::Ascii("lverises"),
        dictgen::InsensitiveStr::Ascii("lverize"),
        dictgen::InsensitiveStr::Ascii("lverizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_REPUBLICANIZATION_1944426904861411795)],
        &[(0b10010, &ENTRY_REPUBLICANIZATIONS_383652106092527995)],
        &[(0b10010, &ENTRY_REPUBLICANIZE_10386133133725020930)],
        &[(0b10010, &ENTRY_REPUBLICANIZED_580437874147385001)],
        &[(0b10010, &ENTRY_REPUBLICANIZER_18381174866390455070)],
        &[(0b10010, &ENTRY_REPUBLICANIZERS_15251018630663619701)],
        &[(0b10010, &ENTRY_REPUBLICANIZES_7718357541376368950)],
        &[(0b10010, &ENTRY_REPUBLICANIZING_8829607189097248923)],
        &[(0b01001, &ENTRY_REPUBLICANIZATION_1944426904861411795)],
        &[(0b01001, &ENTRY_REPUBLICANIZATIONS_383652106092527995)],
        &[(0b01001, &ENTRY_REPUBLICANIZE_10386133133725020930)],
        &[(0b01001, &ENTRY_REPUBLICANIZED_580437874147385001)],
        &[(0b01001, &ENTRY_REPUBLICANIZER_18381174866390455070)],
        &[(0b01001, &ENTRY_REPUBLICANIZERS_15251018630663619701)],
        &[(0b01001, &ENTRY_REPUBLICANIZES_7718357541376368950)],
        &[(0b01001, &ENTRY_REPUBLICANIZING_8829607189097248923)],
        &[(0b10010, &ENTRY_REPULVERIZE_7976316581557319006)],
        &[(0b10010, &ENTRY_REPULVERIZES_16864243522912897832)],
        &[(0b01001, &ENTRY_REPULVERIZE_7976316581557319006)],
        &[(0b01001, &ENTRY_REPULVERIZES_16864243522912897832)],
    ],
    range: 7..=14,
};

static VARS_REPR_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_REPR_CHILDREN),
    value: None,
};

pub static VARS_REPR_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ised"),
        dictgen::InsensitiveStr::Ascii("ivatisation"),
        dictgen::InsensitiveStr::Ascii("ivatisations"),
        dictgen::InsensitiveStr::Ascii("ivatise"),
        dictgen::InsensitiveStr::Ascii("ivatised"),
        dictgen::InsensitiveStr::Ascii("ivatises"),
        dictgen::InsensitiveStr::Ascii("ivatising"),
        dictgen::InsensitiveStr::Ascii("ivatization"),
        dictgen::InsensitiveStr::Ascii("ivatizations"),
        dictgen::InsensitiveStr::Ascii("ivatize"),
        dictgen::InsensitiveStr::Ascii("ivatized"),
        dictgen::InsensitiveStr::Ascii("ivatizes"),
        dictgen::InsensitiveStr::Ascii("ivatizing"),
        dictgen::InsensitiveStr::Ascii("ized"),
        dictgen::InsensitiveStr::Ascii("ogramme"),
        dictgen::InsensitiveStr::Ascii("ogrammes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_REPRIZED_7288407637875600947)],
        &[(0b10010, &ENTRY_REPRIVATIZATION_13650773811954050943)],
        &[(0b10010, &ENTRY_REPRIVATIZATIONS_14878285207711233234)],
        &[(0b10010, &ENTRY_REPRIVATIZE_5415509619751214059)],
        &[(0b10010, &ENTRY_REPRIVATIZED_12098289997527637409)],
        &[(0b10010, &ENTRY_REPRIVATIZES_16228664850321170772)],
        &[(0b10010, &ENTRY_REPRIVATIZING_12815705532271804492)],
        &[(0b01001, &ENTRY_REPRIVATIZATION_13650773811954050943)],
        &[(0b01001, &ENTRY_REPRIVATIZATIONS_14878285207711233234)],
        &[(0b01001, &ENTRY_REPRIVATIZE_5415509619751214059)],
        &[(0b01001, &ENTRY_REPRIVATIZED_12098289997527637409)],
        &[(0b01001, &ENTRY_REPRIVATIZES_16228664850321170772)],
        &[(0b01001, &ENTRY_REPRIVATIZING_12815705532271804492)],
        &[(0b01001, &ENTRY_REPRIZED_7288407637875600947)],
        &[(0b11010, &ENTRY_REPROGRAM_4774339528962451273)],
        &[(0b11010, &ENTRY_REPROGRAMS_14411569368989355062)],
    ],
    range: 4..=12,
};

static VARS_REPO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_REPO_CHILDREN),
    value: None,
};

pub static VARS_REPO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lymerisation"),
        dictgen::InsensitiveStr::Ascii("lymerisations"),
        dictgen::InsensitiveStr::Ascii("lymerise"),
        dictgen::InsensitiveStr::Ascii("lymerises"),
        dictgen::InsensitiveStr::Ascii("lymerization"),
        dictgen::InsensitiveStr::Ascii("lymerizations"),
        dictgen::InsensitiveStr::Ascii("lymerize"),
        dictgen::InsensitiveStr::Ascii("lymerizes"),
        dictgen::InsensitiveStr::Ascii("pularise"),
        dictgen::InsensitiveStr::Ascii("pularize"),
    ],
    values: &[
        &[(0b10010, &ENTRY_REPOLYMERIZATION_4016733859370100512)],
        &[(0b10010, &ENTRY_REPOLYMERIZATIONS_5935058147340822679)],
        &[(0b10010, &ENTRY_REPOLYMERIZE_9036336021273167586)],
        &[(0b10010, &ENTRY_REPOLYMERIZES_278489027229578119)],
        &[(0b01001, &ENTRY_REPOLYMERIZATION_4016733859370100512)],
        &[(0b01001, &ENTRY_REPOLYMERIZATIONS_5935058147340822679)],
        &[(0b01001, &ENTRY_REPOLYMERIZE_9036336021273167586)],
        &[(0b01001, &ENTRY_REPOLYMERIZES_278489027229578119)],
        &[(0b10010, &ENTRY_REPOPULARIZE_9953057472377229635)],
        &[(0b01001, &ENTRY_REPOPULARIZE_9953057472377229635)],
    ],
    range: 8..=13,
};

static VARS_REPH_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_REPH_CHILDREN),
    value: None,
};

pub static VARS_REPH_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("osphorisation"),
        dictgen::InsensitiveStr::Ascii("osphorisations"),
        dictgen::InsensitiveStr::Ascii("osphorise"),
        dictgen::InsensitiveStr::Ascii("osphorises"),
        dictgen::InsensitiveStr::Ascii("osphorization"),
        dictgen::InsensitiveStr::Ascii("osphorizations"),
        dictgen::InsensitiveStr::Ascii("osphorize"),
        dictgen::InsensitiveStr::Ascii("osphorizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_REPHOSPHORIZATION_1249759851309425020)],
        &[(0b10010, &ENTRY_REPHOSPHORIZATIONS_10501113871961153156)],
        &[(0b10010, &ENTRY_REPHOSPHORIZE_419529770369265116)],
        &[(0b10010, &ENTRY_REPHOSPHORIZES_17888482873852406388)],
        &[(0b01001, &ENTRY_REPHOSPHORIZATION_1249759851309425020)],
        &[(0b01001, &ENTRY_REPHOSPHORIZATIONS_10501113871961153156)],
        &[(0b01001, &ENTRY_REPHOSPHORIZE_419529770369265116)],
        &[(0b01001, &ENTRY_REPHOSPHORIZES_17888482873852406388)],
    ],
    range: 9..=14,
};

static VARS_REPE_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_REPE_CHILDREN),
    value: None,
};

pub static VARS_REPE_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rsonalise"),
        dictgen::InsensitiveStr::Ascii("rsonalize"),
    ],
    values: &[
        &[(0b10010, &ENTRY_REPERSONALIZE_6974920904850829865)],
        &[(0b01001, &ENTRY_REPERSONALIZE_6974920904850829865)],
    ],
    range: 9..=9,
};

static VARS_REPA_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_REPA_CHILDREN),
    value: None,
};

pub static VARS_REPA_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ganisation"),
        dictgen::InsensitiveStr::Ascii("ganisations"),
        dictgen::InsensitiveStr::Ascii("ganise"),
        dictgen::InsensitiveStr::Ascii("ganiser"),
        dictgen::InsensitiveStr::Ascii("ganisers"),
        dictgen::InsensitiveStr::Ascii("ganises"),
        dictgen::InsensitiveStr::Ascii("ganization"),
        dictgen::InsensitiveStr::Ascii("ganizations"),
        dictgen::InsensitiveStr::Ascii("ganize"),
        dictgen::InsensitiveStr::Ascii("ganizer"),
        dictgen::InsensitiveStr::Ascii("ganizers"),
        dictgen::InsensitiveStr::Ascii("ganizes"),
        dictgen::InsensitiveStr::Ascii("tronise"),
        dictgen::InsensitiveStr::Ascii("tronises"),
        dictgen::InsensitiveStr::Ascii("tronize"),
        dictgen::InsensitiveStr::Ascii("tronizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_REPAGANIZATION_17048111709890154504)],
        &[(0b10010, &ENTRY_REPAGANIZATIONS_11524549005753966827)],
        &[(0b10010, &ENTRY_REPAGANIZE_12973755742278560404)],
        &[(0b10010, &ENTRY_REPAGANIZER_6412817561993591645)],
        &[(0b10010, &ENTRY_REPAGANIZERS_1945767306900866182)],
        &[(0b10010, &ENTRY_REPAGANIZES_9803449503187685243)],
        &[(0b01001, &ENTRY_REPAGANIZATION_17048111709890154504)],
        &[(0b01001, &ENTRY_REPAGANIZATIONS_11524549005753966827)],
        &[(0b01001, &ENTRY_REPAGANIZE_12973755742278560404)],
        &[(0b01001, &ENTRY_REPAGANIZER_6412817561993591645)],
        &[(0b01001, &ENTRY_REPAGANIZERS_1945767306900866182)],
        &[(0b01001, &ENTRY_REPAGANIZES_9803449503187685243)],
        &[(0b10010, &ENTRY_REPATRONIZE_14079123483159349622)],
        &[(0b10010, &ENTRY_REPATRONIZES_15919891777429804526)],
        &[(0b01001, &ENTRY_REPATRONIZE_14079123483159349622)],
        &[(0b01001, &ENTRY_REPATRONIZES_15919891777429804526)],
    ],
    range: 6..=11,
};

static VARS_REO_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_REO_CHILDREN),
    value: None,
};

pub static VARS_REO_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bjectivisation"),
        dictgen::InsensitiveStr::Ascii("bjectivisations"),
        dictgen::InsensitiveStr::Ascii("bjectivise"),
        dictgen::InsensitiveStr::Ascii("bjectivises"),
        dictgen::InsensitiveStr::Ascii("bjectivization"),
        dictgen::InsensitiveStr::Ascii("bjectivizations"),
        dictgen::InsensitiveStr::Ascii("bjectivize"),
        dictgen::InsensitiveStr::Ascii("bjectivizes"),
        dictgen::InsensitiveStr::Ascii("rganisation"),
        dictgen::InsensitiveStr::Ascii("rganisational"),
        dictgen::InsensitiveStr::Ascii("rganisationist"),
        dictgen::InsensitiveStr::Ascii("rganisationists"),
        dictgen::InsensitiveStr::Ascii("rganisations"),
        dictgen::InsensitiveStr::Ascii("rganise"),
        dictgen::InsensitiveStr::Ascii("rganised"),
        dictgen::InsensitiveStr::Ascii("rganiser"),
        dictgen::InsensitiveStr::Ascii("rganisers"),
        dictgen::InsensitiveStr::Ascii("rganises"),
        dictgen::InsensitiveStr::Ascii("rganising"),
        dictgen::InsensitiveStr::Ascii("rganization"),
        dictgen::InsensitiveStr::Ascii("rganizational"),
        dictgen::InsensitiveStr::Ascii("rganizationist"),
        dictgen::InsensitiveStr::Ascii("rganizationists"),
        dictgen::InsensitiveStr::Ascii("rganizations"),
        dictgen::InsensitiveStr::Ascii("rganize"),
        dictgen::InsensitiveStr::Ascii("rganized"),
        dictgen::InsensitiveStr::Ascii("rganizer"),
        dictgen::InsensitiveStr::Ascii("rganizers"),
        dictgen::InsensitiveStr::Ascii("rganizes"),
        dictgen::InsensitiveStr::Ascii("rganizing"),
        dictgen::InsensitiveStr::Ascii("xidise"),
        dictgen::InsensitiveStr::Ascii("xidised"),
        dictgen::InsensitiveStr::Ascii("xidises"),
        dictgen::InsensitiveStr::Ascii("xidising"),
        dictgen::InsensitiveStr::Ascii("xidize"),
        dictgen::InsensitiveStr::Ascii("xidized"),
        dictgen::InsensitiveStr::Ascii("xidizes"),
        dictgen::InsensitiveStr::Ascii("xidizing"),
        dictgen::InsensitiveStr::Ascii("xygenise"),
        dictgen::InsensitiveStr::Ascii("xygenises"),
        dictgen::InsensitiveStr::Ascii("xygenize"),
        dictgen::InsensitiveStr::Ascii("xygenizes"),
    ],
    values: &[
        &[(0b10010, &ENTRY_REOBJECTIVIZATION_9934627242133960188)],
        &[(0b10010, &ENTRY_REOBJECTIVIZATIONS_484037855015245777)],
        &[(0b10010, &ENTRY_REOBJECTIVIZE_4586321694839316243)],
        &[(0b10010, &ENTRY_REOBJECTIVIZES_2442086806688158809)],
        &[(0b01001, &ENTRY_REOBJECTIVIZATION_9934627242133960188)],
        &[(0b01001, &ENTRY_REOBJECTIVIZATIONS_484037855015245777)],
        &[(0b01001, &ENTRY_REOBJECTIVIZE_4586321694839316243)],
        &[(0b01001, &ENTRY_REOBJECTIVIZES_2442086806688158809)],
        &[(0b10010, &ENTRY_REORGANIZATION_8169886605299414196)],
        &[(0b10010, &ENTRY_REORGANIZATIONAL_10984641565360643637)],
        &[(0b10010, &ENTRY_REORGANIZATIONIST_11925492221252212415)],
        &[(0b10010, &ENTRY_REORGANIZATIONISTS_10384586979829403733)],
        &[(0b10010, &ENTRY_REORGANIZATIONS_3908357981488387825)],
        &[(0b10010, &ENTRY_REORGANIZE_18181270914612994788)],
        &[(0b10010, &ENTRY_REORGANIZED_5774790920194407083)],
        &[(0b10010, &ENTRY_REORGANIZER_2092510006819704008)],
        &[(0b10010, &ENTRY_REORGANIZERS_9885992780785484737)],
        &[(0b10010, &ENTRY_REORGANIZES_3740948184951472727)],
        &[(0b10010, &ENTRY_REORGANIZING_15784567964948699452)],
        &[(0b01001, &ENTRY_REORGANIZATION_8169886605299414196)],
        &[(0b01001, &ENTRY_REORGANIZATIONAL_10984641565360643637)],
        &[(0b01001, &ENTRY_REORGANIZATIONIST_11925492221252212415)],
        &[(0b01001, &ENTRY_REORGANIZATIONISTS_10384586979829403733)],
        &[(0b01001, &ENTRY_REORGANIZATIONS_3908357981488387825)],
        &[(0b01001, &ENTRY_REORGANIZE_18181270914612994788)],
        &[(0b01001, &ENTRY_REORGANIZED_5774790920194407083)],
        &[(0b01001, &ENTRY_REORGANIZER_2092510006819704008)],
        &[(0b01001, &ENTRY_REORGANIZERS_9885992780785484737)],
        &[(0b01001, &ENTRY_REORGANIZES_3740948184951472727)],
        &[(0b01001, &ENTRY_REORGANIZING_15784567964948699452)],
        &[(0b10010, &ENTRY_REOXIDIZE_4983823425119723374)],
        &[(0b10010, &ENTRY_REOXIDIZED_13705047693863706297)],
        &[(0b10010, &ENTRY_REOXIDIZES_14522324553215140631)],
        &[(0b10010, &ENTRY_REOXIDIZING_18024783650819146058)],
        &[(0b01001, &ENTRY_REOXIDIZE_4983823425119723374)],
        &[(0b01001, &ENTRY_REOXIDIZED_13705047693863706297)],
        &[(0b01001, &ENTRY_REOXIDIZES_14522324553215140631)],
        &[(0b01001, &ENTRY_REOXIDIZING_18024783650819146058)],
        &[(0b10010, &ENTRY_REOXYGENIZE_6926836183647945085)],
        &[(0b10010, &ENTRY_REOXYGENIZES_17640431467346669041)],
        &[(0b01001, &ENTRY_REOXYGENIZE_6926836183647945085)],
        &[(0b01001, &ENTRY_REOXYGENIZES_17640431467346669041)],
    ],
    range: 6..=15,
};

static VARS_REN_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&VARS_REN_CHILDREN),
    value: Some(&[(0b11010, &ENTRY_ERN_10092184086657301009)]),
};

pub static VARS_REN_CHILDREN: dictgen::DictTable<&[(u8, &VariantsMap)]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ationalise"),
        dictgen::InsensitiveStr::Ascii("ationalised"),
        dictgen::InsensitiveStr::Ascii("ationalises"),
        dictgen::InsensitiveStr::Ascii("ationalising"),
        dictgen::InsensitiveStr::Ascii("ationalize"),
        dictgen::InsensitiveStr::Ascii("ationalized"),
        dictgen::InsensitiveStr::Ascii("ationalizes"),
        dictgen::InsensitiveStr::Ascii("ationalizing"),
        dictgen::InsensitiveStr::Ascii("contre"),
        dictgen::InsensitiveStr::Ascii("counter"),
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("est"),
        dictgen::InsensitiveStr::Ascii("ferd"),
        dictgen::InsensitiveStr::Ascii("fred"),
        dictgen::InsensitiveStr::Ascii("ormalisation"),
        dictgen::InsensitiveStr::Ascii("ormalisations"),
        dictgen::InsensitiveStr::Ascii("ormalise"),
        dictgen::InsensitiveStr::Ascii("ormalised"),
        dictgen::InsensitiveStr::Ascii("ormalises"),
        dictgen::InsensitiveStr::Ascii("ormalising"),
        dictgen::InsensitiveStr::Ascii("ormalization"),
        dictgen::InsensitiveStr::Ascii("ormalizations"),
        dictgen::InsensitiveStr::Ascii("ormalize"),
        dictgen::InsensitiveStr::Ascii("ormalized"),
        dictgen::InsensitiveStr::Ascii("ormalizes"),
        dictgen::InsensitiveStr::Ascii("ormalizing"),
        dictgen::InsensitiveStr::Ascii("s"),
    ],
    values: &[
        &[(0b10010, &ENTRY_RENATIONALIZE_13763420489757292678)],
        &[(0b10010, &ENTRY_RENATIONALIZED_245883000485081396)],
        &[(0b10010, &ENTRY_RENATIONALIZES_15008886789696665182)],
        &[(0b10010, &ENTRY_RENATIONALIZING_528289503767142524)],
        &[(0b01001, &ENTRY_RENATIONALIZE_13763420489757292678)],
        &[(0b01001, &ENTRY_RENATIONALIZED_245883000485081396)],
        &[(0b01001, &ENTRY_RENATIONALIZES_15008886789696665182)],
        &[(0b01001, &ENTRY_RENATIONALIZING_528289503767142524)],
        &[(0b11010, &ENTRY_RENCOUNTER_17790527784370805465)],
        &[(0b00001, &ENTRY_RENCOUNTER_17790527784370805465)],
        &[(0b11010, &ENTRY_ERNES_16282144925287112174)],
        &[(0b11010, &ENTRY_ERNEST_2869565578515229588)],
        &[(0b00001, &ENTRY_RENFERD_5332380987373616326)],
        &[(0b11010, &ENTRY_RENFERD_5332380987373616326)],
        &[(0b10010, &ENTRY_RENORMALIZATION_9891230551808040808)],
        &[(0b10010, &ENTRY_RENORMALIZATIONS_6818740031112910643)],
        &[(0b10010, &ENTRY_RENORMALIZE_4228995450916847764)],
        &[(0b10010, &ENTRY_RENORMALIZED_12583163063216549053)],
        &[(0b10010, &ENTRY_RENORMALIZES_12053503023445454685)],
        &[(0b10010, &ENTRY_RENORMALIZING_4696927106111124982)],
        &[(0b01001, &ENTRY_RENORMALIZATION_9891230551808040808)],
        &[(0b01001, &ENTRY_RENORMALIZATIONS_6818740031112910643)],
        &[(0b01001, &ENTRY_RENORMALIZE_4228995450916847764)],
        &[(0b01001, &ENTRY_RENORMALIZED_12583163063216549053)],
        &[(0b01001, &ENTRY_RENORMALIZES_12053503023445454685)],
        &[(0b01001, &ENTRY_RENORMALIZING_4696927106111124982)],
        &[(0b11010, &ENTRY_ERNS_11958672731540988082)],
    ],
    range: 1..=13,
};

static VARS_REM_NODE: dictgen::DictTrieNode<&[(u8, &VariantsMap)]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&VARS_REM_CHILDREN),
    value: None,
};

static VARS_REM_CHILDREN: [Option<&dictgen::DictTrieNode<&[(u8, &VariantsMap)]>>; 26] = [
    Some(&VARS_REMA_NODE),
    None,
    None,
    None,
    Some(&VARS_REME_NODE),
    None,
    None,
    None,
    Some(&VARS_REMI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&VARS_REMO_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    No