// This file is code-genned by typos-vars-codegen
#![allow(clippy::unreadable_literal)]

pub type Variants = &'static [&'static str];
pub type VariantsMap = [Variants; 4];

pub fn all_categories() -> crate::CategorySet {
    crate::Category::American
        | crate::Category::BritishIse
        | crate::Category::Canadian
        | crate::Category::Australian
}

pub fn corrections(category: crate::Category, options: VariantsMap) -> &'static [&'static str] {
    match category {
        crate::Category::American => options[0],
        crate::Category::BritishIse => options[1],
        crate::Category::Canadian => options[2],
        crate::Category::Australian => options[3],
        crate::Category::BritishIze | crate::Category::Other => {
            unreachable!("{:?} is unused", category)
        }
    }
}

pub(crate) static VARS_DICTIONARY: &[(crate::EncodedStr, &[(u8, &VariantsMap)])] = &[
    (
        crate::EncodedStr::Ascii("aaedon"),
        &[(0b11010, &ENTRY_AEDON_13423944760872171401)],
    ),
    (
        crate::EncodedStr::Ascii("aaerialness"),
        &[(0b11010, &ENTRY_AERIALNESS_16182249999029135790)],
    ),
    (
        crate::EncodedStr::Ascii("aaerope"),
        &[(0b11010, &ENTRY_AEROPE_15996663583730344470)],
    ),
    (
        crate::EncodedStr::Ascii("abetter"),
        &[(0b10011, &ENTRY_ABETTOR_7009618908225223897)],
    ),
    (
        crate::EncodedStr::Ascii("abetters"),
        &[(0b10011, &ENTRY_ABETTORS_7043394254318611656)],
    ),
    (
        crate::EncodedStr::Ascii("abnormalise"),
        &[(0b10010, &ENTRY_ABNORMALIZE_17439831460907058384)],
    ),
    (
        crate::EncodedStr::Ascii("abnormalised"),
        &[(0b10010, &ENTRY_ABNORMALIZED_16673259772579712474)],
    ),
    (
        crate::EncodedStr::Ascii("abnormalising"),
        &[(0b10010, &ENTRY_ABNORMALIZING_11364803739175296383)],
    ),
    (
        crate::EncodedStr::Ascii("abnormalize"),
        &[(0b01001, &ENTRY_ABNORMALIZE_17439831460907058384)],
    ),
    (
        crate::EncodedStr::Ascii("abnormalized"),
        &[(0b01001, &ENTRY_ABNORMALIZED_16673259772579712474)],
    ),
    (
        crate::EncodedStr::Ascii("abnormalizing"),
        &[(0b01001, &ENTRY_ABNORMALIZING_11364803739175296383)],
    ),
    (
        crate::EncodedStr::Ascii("abolitionise"),
        &[(0b10010, &ENTRY_ABOLITIONIZE_13202486319737181929)],
    ),
    (
        crate::EncodedStr::Ascii("abolitionised"),
        &[(0b10010, &ENTRY_ABOLITIONIZED_11758918826177421917)],
    ),
    (
        crate::EncodedStr::Ascii("abolitionising"),
        &[(0b10010, &ENTRY_ABOLITIONIZING_6296954614763706120)],
    ),
    (
        crate::EncodedStr::Ascii("abolitionize"),
        &[(0b01001, &ENTRY_ABOLITIONIZE_13202486319737181929)],
    ),
    (
        crate::EncodedStr::Ascii("abolitionized"),
        &[(0b01001, &ENTRY_ABOLITIONIZED_11758918826177421917)],
    ),
    (
        crate::EncodedStr::Ascii("abolitionizing"),
        &[(0b01001, &ENTRY_ABOLITIONIZING_6296954614763706120)],
    ),
    (
        crate::EncodedStr::Ascii("abridgement"),
        &[(0b11010, &ENTRY_ABRIDGMENT_12609101589412407813)],
    ),
    (
        crate::EncodedStr::Ascii("abridgements"),
        &[(0b11010, &ENTRY_ABRIDGMENTS_5740240316470863413)],
    ),
    (
        crate::EncodedStr::Ascii("academise"),
        &[(0b10010, &ENTRY_ACADEMIZE_744429990211461933)],
    ),
    (
        crate::EncodedStr::Ascii("academised"),
        &[(0b10010, &ENTRY_ACADEMIZED_12979046795383243853)],
    ),
    (
        crate::EncodedStr::Ascii("academising"),
        &[(0b10010, &ENTRY_ACADEMIZING_4383983952783387022)],
    ),
    (
        crate::EncodedStr::Ascii("academize"),
        &[(0b01001, &ENTRY_ACADEMIZE_744429990211461933)],
    ),
    (
        crate::EncodedStr::Ascii("academized"),
        &[(0b01001, &ENTRY_ACADEMIZED_12979046795383243853)],
    ),
    (
        crate::EncodedStr::Ascii("academizing"),
        &[(0b01001, &ENTRY_ACADEMIZING_4383983952783387022)],
    ),
    (
        crate::EncodedStr::Ascii("acalephae"),
        &[(0b11010, &ENTRY_ACALEPHE_1796191466689570332)],
    ),
    (
        crate::EncodedStr::Ascii("acalephe"),
        &[(0b00001, &ENTRY_ACALEPHE_1796191466689570332)],
    ),
    (
        crate::EncodedStr::Ascii("accessorise"),
        &[(0b10010, &ENTRY_ACCESSORIZE_3359544250876737878)],
    ),
    (
        crate::EncodedStr::Ascii("accessorised"),
        &[(0b10010, &ENTRY_ACCESSORIZED_1434587952006445874)],
    ),
    (
        crate::EncodedStr::Ascii("accessorises"),
        &[(0b10010, &ENTRY_ACCESSORIZES_15659000820256764933)],
    ),
    (
        crate::EncodedStr::Ascii("accessorising"),
        &[(0b10010, &ENTRY_ACCESSORIZING_1228113688984999234)],
    ),
    (
        crate::EncodedStr::Ascii("accessorize"),
        &[(0b01001, &ENTRY_ACCESSORIZE_3359544250876737878)],
    ),
    (
        crate::EncodedStr::Ascii("accessorized"),
        &[(0b01001, &ENTRY_ACCESSORIZED_1434587952006445874)],
    ),
    (
        crate::EncodedStr::Ascii("accessorizes"),
        &[(0b01001, &ENTRY_ACCESSORIZES_15659000820256764933)],
    ),
    (
        crate::EncodedStr::Ascii("accessorizing"),
        &[(0b01001, &ENTRY_ACCESSORIZING_1228113688984999234)],
    ),
    (
        crate::EncodedStr::Ascii("acclimatisable"),
        &[(0b10010, &ENTRY_ACCLIMATIZABLE_5975234751050111354)],
    ),
    (
        crate::EncodedStr::Ascii("acclimatisation"),
        &[(0b10010, &ENTRY_ACCLIMATIZATION_16603745532174886246)],
    ),
    (
        crate::EncodedStr::Ascii("acclimatise"),
        &[(0b10010, &ENTRY_ACCLIMATIZE_5381021471129203780)],
    ),
    (
        crate::EncodedStr::Ascii("acclimatised"),
        &[(0b10010, &ENTRY_ACCLIMATIZED_4642628968725123515)],
    ),
    (
        crate::EncodedStr::Ascii("acclimatiser"),
        &[(0b10010, &ENTRY_ACCLIMATIZER_3168716002029159117)],
    ),
    (
        crate::EncodedStr::Ascii("acclimatisers"),
        &[(0b10010, &ENTRY_ACCLIMATIZERS_12279845242555753697)],
    ),
    (
        crate::EncodedStr::Ascii("acclimatises"),
        &[(0b10010, &ENTRY_ACCLIMATIZES_1207160639773800361)],
    ),
    (
        crate::EncodedStr::Ascii("acclimatising"),
        &[(0b10010, &ENTRY_ACCLIMATIZING_3751997949097583159)],
    ),
    (
        crate::EncodedStr::Ascii("acclimatizable"),
        &[(0b01001, &ENTRY_ACCLIMATIZABLE_5975234751050111354)],
    ),
    (
        crate::EncodedStr::Ascii("acclimatization"),
        &[(0b01001, &ENTRY_ACCLIMATIZATION_16603745532174886246)],
    ),
    (
        crate::EncodedStr::Ascii("acclimatize"),
        &[(0b01001, &ENTRY_ACCLIMATIZE_5381021471129203780)],
    ),
    (
        crate::EncodedStr::Ascii("acclimatized"),
        &[(0b01001, &ENTRY_ACCLIMATIZED_4642628968725123515)],
    ),
    (
        crate::EncodedStr::Ascii("acclimatizer"),
        &[(0b01001, &ENTRY_ACCLIMATIZER_3168716002029159117)],
    ),
    (
        crate::EncodedStr::Ascii("acclimatizers"),
        &[(0b01001, &ENTRY_ACCLIMATIZERS_12279845242555753697)],
    ),
    (
        crate::EncodedStr::Ascii("acclimatizes"),
        &[(0b01001, &ENTRY_ACCLIMATIZES_1207160639773800361)],
    ),
    (
        crate::EncodedStr::Ascii("acclimatizing"),
        &[(0b01001, &ENTRY_ACCLIMATIZING_3751997949097583159)],
    ),
    (
        crate::EncodedStr::Ascii("accorage"),
        &[(0b00001, &ENTRY_ACCORAGE_4223546442621665298)],
    ),
    (
        crate::EncodedStr::Ascii("accoraged"),
        &[(0b00001, &ENTRY_ACCORAGED_14521717986957835986)],
    ),
    (
        crate::EncodedStr::Ascii("accorages"),
        &[(0b00001, &ENTRY_ACCORAGES_9708962964447816459)],
    ),
    (
        crate::EncodedStr::Ascii("accoraging"),
        &[(0b00001, &ENTRY_ACCORAGING_15274251691846060767)],
    ),
    (
        crate::EncodedStr::Ascii("accourage"),
        &[(0b11010, &ENTRY_ACCORAGE_4223546442621665298)],
    ),
    (
        crate::EncodedStr::Ascii("accouraged"),
        &[(0b11010, &ENTRY_ACCORAGED_14521717986957835986)],
    ),
    (
        crate::EncodedStr::Ascii("accourages"),
        &[(0b11010, &ENTRY_ACCORAGES_9708962964447816459)],
    ),
    (
        crate::EncodedStr::Ascii("accouraging"),
        &[(0b11010, &ENTRY_ACCORAGING_15274251691846060767)],
    ),
    (
        crate::EncodedStr::Ascii("accouter"),
        &[(0b00001, &ENTRY_ACCOUTER_17639188035801239900)],
    ),
    (
        crate::EncodedStr::Ascii("accoutered"),
        &[(0b00001, &ENTRY_ACCOUTERED_12457139511982164079)],
    ),
    (
        crate::EncodedStr::Ascii("accoutering"),
        &[(0b00001, &ENTRY_ACCOUTERING_11722729971237237966)],
    ),
    (
        crate::EncodedStr::Ascii("accouterment"),
        &[(0b00001, &ENTRY_ACCOUTERMENT_5633078260473567371)],
    ),
    (
        crate::EncodedStr::Ascii("accouterments"),
        &[(0b00001, &ENTRY_ACCOUTERMENTS_7782625256444191565)],
    ),
    (
        crate::EncodedStr::Ascii("accouters"),
        &[(0b00001, &ENTRY_ACCOUTERS_7708387867770638479)],
    ),
    (
        crate::EncodedStr::Ascii("acemetae"),
        &[(0b10001, &ENTRY_ACEMETAE_6749477089975884632)],
    ),
    (
        crate::EncodedStr::Ascii("acemetic"),
        &[(0b10001, &ENTRY_ACEMETIC_4282768793534979903)],
    ),
    (
        crate::EncodedStr::Ascii("acer"),
        &[(0b00001, &ENTRY_ACER_5343338374924634546)],
    ),
    (
        crate::EncodedStr::Ascii("acetonaemia"),
        &[(0b11010, &ENTRY_ACETONEMIA_4459698585404045008)],
    ),
    (
        crate::EncodedStr::Ascii("acetonaemic"),
        &[(0b11010, &ENTRY_ACETONEMIC_3556838368325334069)],
    ),
    (
        crate::EncodedStr::Ascii("acetonemia"),
        &[(0b10001, &ENTRY_ACETONEMIA_4459698585404045008)],
    ),
    (
        crate::EncodedStr::Ascii("acetonemic"),
        &[(0b10001, &ENTRY_ACETONEMIC_3556838368325334069)],
    ),
    (
        crate::EncodedStr::Ascii("achaenia"),
        &[(0b11010, &ENTRY_ACHENIA_8478499188556204365)],
    ),
    (
        crate::EncodedStr::Ascii("achaenium"),
        &[(0b11010, &ENTRY_ACHENIUM_11897993706664093871)],
    ),
    (
        crate::EncodedStr::Ascii("achaeniums"),
        &[(0b11010, &ENTRY_ACHENIUMS_13963140948852387190)],
    ),
    (
        crate::EncodedStr::Ascii("achaenocarp"),
        &[(0b11010, &ENTRY_ACHENOCARP_853831801713732483)],
    ),
    (
        crate::EncodedStr::Ascii("achenia"),
        &[(0b10001, &ENTRY_ACHENIA_8478499188556204365)],
    ),
    (
        crate::EncodedStr::Ascii("achenium"),
        &[(0b10001, &ENTRY_ACHENIUM_11897993706664093871)],
    ),
    (
        crate::EncodedStr::Ascii("acheniums"),
        &[(0b10001, &ENTRY_ACHENIUMS_13963140948852387190)],
    ),
    (
        crate::EncodedStr::Ascii("achenocarp"),
        &[(0b10001, &ENTRY_ACHENOCARP_853831801713732483)],
    ),
    (
        crate::EncodedStr::Ascii("achroiocythaemia"),
        &[(0b11010, &ENTRY_ACHROIOCYTHEMIA_5792381842511219354)],
    ),
    (
        crate::EncodedStr::Ascii("achroiocythemia"),
        &[(0b10001, &ENTRY_ACHROIOCYTHEMIA_5792381842511219354)],
    ),
    (
        crate::EncodedStr::Ascii("achromatisation"),
        &[(0b10010, &ENTRY_ACHROMATIZATION_3261887351568242902)],
    ),
    (
        crate::EncodedStr::Ascii("achromatisations"),
        &[(0b10010, &ENTRY_ACHROMATIZATIONS_17303571046130875052)],
    ),
    (
        crate::EncodedStr::Ascii("achromatise"),
        &[(0b10010, &ENTRY_ACHROMATIZE_11381534851343983212)],
    ),
    (
        crate::EncodedStr::Ascii("achromatised"),
        &[(0b10010, &ENTRY_ACHROMATIZED_10686154542806055086)],
    ),
    (
        crate::EncodedStr::Ascii("achromatises"),
        &[(0b10010, &ENTRY_ACHROMATIZES_12398014174188745620)],
    ),
    (
        crate::EncodedStr::Ascii("achromatising"),
        &[(0b10010, &ENTRY_ACHROMATIZING_8797256910702313821)],
    ),
    (
        crate::EncodedStr::Ascii("achromatization"),
        &[(0b01001, &ENTRY_ACHROMATIZATION_3261887351568242902)],
    ),
    (
        crate::EncodedStr::Ascii("achromatizations"),
        &[(0b01001, &ENTRY_ACHROMATIZATIONS_17303571046130875052)],
    ),
    (
        crate::EncodedStr::Ascii("achromatize"),
        &[(0b01001, &ENTRY_ACHROMATIZE_11381534851343983212)],
    ),
    (
        crate::EncodedStr::Ascii("achromatized"),
        &[(0b01001, &ENTRY_ACHROMATIZED_10686154542806055086)],
    ),
    (
        crate::EncodedStr::Ascii("achromatizes"),
        &[(0b01001, &ENTRY_ACHROMATIZES_12398014174188745620)],
    ),
    (
        crate::EncodedStr::Ascii("achromatizing"),
        &[(0b01001, &ENTRY_ACHROMATIZING_8797256910702313821)],
    ),
    (
        crate::EncodedStr::Ascii("acidaemia"),
        &[(0b11010, &ENTRY_ACIDEMIA_4441947562863004388)],
    ),
    (
        crate::EncodedStr::Ascii("acidemia"),
        &[(0b10001, &ENTRY_ACIDEMIA_4441947562863004388)],
    ),
    (
        crate::EncodedStr::Ascii("acknowledgment"),
        &[(0b01001, &ENTRY_ACKNOWLEDGMENT_15886905214207494222)],
    ),
    (
        crate::EncodedStr::Ascii("acknowledgments"),
        &[(0b01001, &ENTRY_ACKNOWLEDGMENTS_6498568084190984931)],
    ),
    (
        crate::EncodedStr::Ascii("acmaesthesia"),
        &[(0b11010, &ENTRY_ACMESTHESIA_7394645664517202151)],
    ),
    (
        crate::EncodedStr::Ascii("acmesthesia"),
        &[(0b00001, &ENTRY_ACMESTHESIA_7394645664517202151)],
    ),
    (
        crate::EncodedStr::Ascii("acoemetae"),
        &[(0b11010, &ENTRY_ACEMETAE_6749477089975884632)],
    ),
    (
        crate::EncodedStr::Ascii("acoemetic"),
        &[(0b11010, &ENTRY_ACEMETIC_4282768793534979903)],
    ),
    (
        crate::EncodedStr::Ascii("acre"),
        &[(0b11010, &ENTRY_ACER_5343338374924634546)],
    ),
    (
        crate::EncodedStr::Ascii("acroaesthesia"),
        &[(0b11010, &ENTRY_ACROESTHESIA_8308136510880851740)],
    ),
    (
        crate::EncodedStr::Ascii("acroanaesthesia"),
        &[(0b11010, &ENTRY_ACROANESTHESIA_106439738109694339)],
    ),
    (
        crate::EncodedStr::Ascii("acroanesthesia"),
        &[(0b00001, &ENTRY_ACROANESTHESIA_106439738109694339)],
    ),
    (
        crate::EncodedStr::Ascii("acroesthesia"),
        &[(0b00001, &ENTRY_ACROESTHESIA_8308136510880851740)],
    ),
    (
        crate::EncodedStr::Ascii("actualisation"),
        &[(0b10010, &ENTRY_ACTUALIZATION_10932469677827186244)],
    ),
    (
        crate::EncodedStr::Ascii("actualisations"),
        &[(0b10010, &ENTRY_ACTUALIZATIONS_12953081702088345443)],
    ),
    (
        crate::EncodedStr::Ascii("actualise"),
        &[(0b10010, &ENTRY_ACTUALIZE_13650893073188599056)],
    ),
    (
        crate::EncodedStr::Ascii("actualised"),
        &[(0b10010, &ENTRY_ACTUALIZED_18291562385674574688)],
    ),
    (
        crate::EncodedStr::Ascii("actualises"),
        &[(0b10010, &ENTRY_ACTUALIZES_1551714425800475584)],
    ),
    (
        crate::EncodedStr::Ascii("actualising"),
        &[(0b10010, &ENTRY_ACTUALIZING_4690007636134300688)],
    ),
    (
        crate::EncodedStr::Ascii("actualization"),
        &[(0b01001, &ENTRY_ACTUALIZATION_10932469677827186244)],
    ),
    (
        crate::EncodedStr::Ascii("actualizations"),
        &[(0b01001, &ENTRY_ACTUALIZATIONS_12953081702088345443)],
    ),
    (
        crate::EncodedStr::Ascii("actualize"),
        &[(0b01001, &ENTRY_ACTUALIZE_13650893073188599056)],
    ),
    (
        crate::EncodedStr::Ascii("actualized"),
        &[(0b01001, &ENTRY_ACTUALIZED_18291562385674574688)],
    ),
    (
        crate::EncodedStr::Ascii("actualizes"),
        &[(0b01001, &ENTRY_ACTUALIZES_1551714425800475584)],
    ),
    (
        crate::EncodedStr::Ascii("actualizing"),
        &[(0b01001, &ENTRY_ACTUALIZING_4690007636134300688)],
    ),
    (
        crate::EncodedStr::Ascii("acuaesthesia"),
        &[(0b11010, &ENTRY_ACUESTHESIA_12188708987996711429)],
    ),
    (
        crate::EncodedStr::Ascii("acuesthesia"),
        &[(0b00001, &ENTRY_ACUESTHESIA_12188708987996711429)],
    ),
    (
        crate::EncodedStr::Ascii("adonise"),
        &[(0b10010, &ENTRY_ADONIZE_9869544785563490952)],
    ),
    (
        crate::EncodedStr::Ascii("adonised"),
        &[(0b10010, &ENTRY_ADONIZED_2235806445765610165)],
    ),
    (
        crate::EncodedStr::Ascii("adonises"),
        &[(0b10010, &ENTRY_ADONIZES_12390820180008298287)],
    ),
    (
        crate::EncodedStr::Ascii("adonising"),
        &[(0b10010, &ENTRY_ADONIZING_5588260356811603655)],
    ),
    (
        crate::EncodedStr::Ascii("adonize"),
        &[(0b01001, &ENTRY_ADONIZE_9869544785563490952)],
    ),
    (
        crate::EncodedStr::Ascii("adonized"),
        &[(0b01001, &ENTRY_ADONIZED_2235806445765610165)],
    ),
    (
        crate::EncodedStr::Ascii("adonizes"),
        &[(0b01001, &ENTRY_ADONIZES_12390820180008298287)],
    ),
    (
        crate::EncodedStr::Ascii("adonizing"),
        &[(0b01001, &ENTRY_ADONIZING_5588260356811603655)],
    ),
    (
        crate::EncodedStr::Ascii("adulterise"),
        &[(0b10010, &ENTRY_ADULTERIZE_4357377158717268989)],
    ),
    (
        crate::EncodedStr::Ascii("adulterised"),
        &[(0b10010, &ENTRY_ADULTERIZED_9727259542657623653)],
    ),
    (
        crate::EncodedStr::Ascii("adulterises"),
        &[(0b10010, &ENTRY_ADULTERIZES_8588447326790555058)],
    ),
    (
        crate::EncodedStr::Ascii("adulterising"),
        &[(0b10010, &ENTRY_ADULTERIZING_3717589244256498605)],
    ),
    (
        crate::EncodedStr::Ascii("adulterize"),
        &[(0b01001, &ENTRY_ADULTERIZE_4357377158717268989)],
    ),
    (
        crate::EncodedStr::Ascii("adulterized"),
        &[(0b01001, &ENTRY_ADULTERIZED_9727259542657623653)],
    ),
    (
        crate::EncodedStr::Ascii("adulterizes"),
        &[(0b01001, &ENTRY_ADULTERIZES_8588447326790555058)],
    ),
    (
        crate::EncodedStr::Ascii("adulterizing"),
        &[(0b01001, &ENTRY_ADULTERIZING_3717589244256498605)],
    ),
    (
        crate::EncodedStr::Ascii("advenae"),
        &[(0b11010, &ENTRY_ADVENE_12688820738991001632)],
    ),
    (
        crate::EncodedStr::Ascii("advene"),
        &[(0b00001, &ENTRY_ADVENE_12688820738991001632)],
    ),
    (
        crate::EncodedStr::Ascii("adverbialise"),
        &[(0b10010, &ENTRY_ADVERBIALIZE_2474916322327345748)],
    ),
    (
        crate::EncodedStr::Ascii("adverbialised"),
        &[(0b10010, &ENTRY_ADVERBIALIZED_11573126518987347280)],
    ),
    (
        crate::EncodedStr::Ascii("adverbialises"),
        &[(0b10010, &ENTRY_ADVERBIALIZES_5412565270521609710)],
    ),
    (
        crate::EncodedStr::Ascii("adverbialising"),
        &[(0b10010, &ENTRY_ADVERBIALIZING_4313670731186707316)],
    ),
    (
        crate::EncodedStr::Ascii("adverbialize"),
        &[(0b01001, &ENTRY_ADVERBIALIZE_2474916322327345748)],
    ),
    (
        crate::EncodedStr::Ascii("adverbialized"),
        &[(0b01001, &ENTRY_ADVERBIALIZED_11573126518987347280)],
    ),
    (
        crate::EncodedStr::Ascii("adverbializes"),
        &[(0b01001, &ENTRY_ADVERBIALIZES_5412565270521609710)],
    ),
    (
        crate::EncodedStr::Ascii("adverbializing"),
        &[(0b01001, &ENTRY_ADVERBIALIZING_4313670731186707316)],
    ),
    (
        crate::EncodedStr::Ascii("advertisable"),
        &[(0b10010, &ENTRY_ADVERTIZABLE_5401609881263486182)],
    ),
    (
        crate::EncodedStr::Ascii("advertizable"),
        &[(0b01001, &ENTRY_ADVERTIZABLE_5401609881263486182)],
    ),
    (
        crate::EncodedStr::Ascii("advertize"),
        &[(0b00001, &ENTRY_ADVERTISE_3306761264995947644)],
    ),
    (
        crate::EncodedStr::Ascii("advertized"),
        &[(0b00001, &ENTRY_ADVERTISED_7933765869847731594)],
    ),
    (
        crate::EncodedStr::Ascii("advertizement"),
        &[(0b00001, &ENTRY_ADVERTISEMENT_16394932953244560183)],
    ),
    (
        crate::EncodedStr::Ascii("advertizements"),
        &[(0b00001, &ENTRY_ADVERTISEMENTS_17895556266113847062)],
    ),
    (
        crate::EncodedStr::Ascii("advertizes"),
        &[(0b00001, &ENTRY_ADVERTISES_3486027710577794712)],
    ),
    (
        crate::EncodedStr::Ascii("advertizing"),
        &[(0b00001, &ENTRY_ADVERTISING_11899923599707408720)],
    ),
    (
        crate::EncodedStr::Ascii("adz"),
        &[(0b00001, &ENTRY_ADZE_7687504085143207741)],
    ),
    (
        crate::EncodedStr::Ascii("aeaetes"),
        &[(0b11010, &ENTRY_AEETES_13066320965486982172)],
    ),
    (
        crate::EncodedStr::Ascii("aec"),
        &[(0b11010, &ENTRY_EC_18369594411890017360)],
    ),
    (
        crate::EncodedStr::Ascii("aedicule"),
        &[(0b11010, &ENTRY_EDICULE_10918770642841249439)],
    ),
    (
        crate::EncodedStr::Ascii("aedility"),
        &[(0b11010, &ENTRY_EDILITY_10658105135103528164)],
    ),
    (
        crate::EncodedStr::Ascii("aedon"),
        &[(0b00001, &ENTRY_AEDON_13423944760872171401)],
    ),
    (
        crate::EncodedStr::Ascii("aeetes"),
        &[(0b00001, &ENTRY_AEETES_13066320965486982172)],
    ),
    (
        crate::EncodedStr::Ascii("aeger"),
        &[(0b11010, &ENTRY_EGER_370209078151771517)],
    ),
    (
        crate::EncodedStr::Ascii("aegilops"),
        &[(0b11010, &ENTRY_EGILOPS_15304768767282746036)],
    ),
    (
        crate::EncodedStr::Ascii("aeglogue"),
        &[(0b11010, &ENTRY_EGLOGUE_16104631981488511989)],
    ),
    (
        crate::EncodedStr::Ascii("aegophony"),
        &[(0b11010, &ENTRY_EGOPHONY_2012602110086773588)],
    ),
    (
        crate::EncodedStr::Ascii("aegritude"),
        &[(0b11010, &ENTRY_EGRITUDE_9946971293935803579)],
    ),
    (
        crate::EncodedStr::Ascii("aemule"),
        &[(0b11010, &ENTRY_EMULE_1972234654623253784)],
    ),
    (
        crate::EncodedStr::Ascii("aemuled"),
        &[(0b11010, &ENTRY_EMULED_10357664319101512866)],
    ),
    (
        crate::EncodedStr::Ascii("aemules"),
        &[(0b11010, &ENTRY_EMULES_6796003945794582963)],
    ),
    (
        crate::EncodedStr::Ascii("aemuling"),
        &[(0b11010, &ENTRY_EMULING_11304283679719960362)],
    ),
    (
        crate::EncodedStr::Ascii("aeneid"),
        &[(0b11010, &ENTRY_ENEID_5242893003172218406)],
    ),
    (
        crate::EncodedStr::Ascii("aeolic"),
        &[(0b11010, &ENTRY_EOLIC_690118974702284625)],
    ),
    (
        crate::EncodedStr::Ascii("aeolipile"),
        &[(0b11010, &ENTRY_EOLIPILE_11849651097249565492)],
    ),
    (
        crate::EncodedStr::Ascii("aeolipiles"),
        &[(0b11010, &ENTRY_EOLIPILES_6469066293612545970)],
    ),
    (
        crate::EncodedStr::Ascii("aeolotropic"),
        &[(0b11010, &ENTRY_EOLOTROPIC_9928061474103766564)],
    ),
    (
        crate::EncodedStr::Ascii("aeonian"),
        &[(0b11010, &ENTRY_EONIAN_2585817843108266796)],
    ),
    (
        crate::EncodedStr::Ascii("aeonism"),
        &[(0b11010, &ENTRY_EONISM_12314541365765950888)],
    ),
    (
        crate::EncodedStr::Ascii("aeonisms"),
        &[(0b11010, &ENTRY_EONISMS_13022437471464751142)],
    ),
    (
        crate::EncodedStr::Ascii("aeq"),
        &[(0b11010, &ENTRY_EQ_17801056412005353118)],
    ),
    (
        crate::EncodedStr::Ascii("aerialness"),
        &[(0b00001, &ENTRY_AERIALNESS_16182249999029135790)],
    ),
    (
        crate::EncodedStr::Ascii("aeric"),
        &[
            (0b00001, &ENTRY_AERIC_17437245564230021595),
            (0b11010, &ENTRY_ERIC_7184163800386574200),
        ],
    ),
    (
        crate::EncodedStr::Ascii("aerical"),
        &[(0b11010, &ENTRY_ERICAL_12478419361229949219)],
    ),
    (
        crate::EncodedStr::Ascii("aerofoil"),
        &[(0b10010, &ENTRY_AIRFOIL_6251188039396016525)],
    ),
    (
        crate::EncodedStr::Ascii("aerofoils"),
        &[(0b10010, &ENTRY_AIRFOILS_11117747260949333982)],
    ),
    (
        crate::EncodedStr::Ascii("aerogel"),
        &[(0b11010, &ENTRY_AIRGEL_9703257971421731594)],
    ),
    (
        crate::EncodedStr::Ascii("aerogenesis"),
        &[(0b11010, &ENTRY_EROGENESIS_4465855575040947833)],
    ),
    (
        crate::EncodedStr::Ascii("aerogenic"),
        &[(0b11010, &ENTRY_EROGENIC_3058184513432824304)],
    ),
    (
        crate::EncodedStr::Ascii("aerographer"),
        &[(0b00001, &ENTRY_AEROGRAPHER_10717546778729152195)],
    ),
    (
        crate::EncodedStr::Ascii("aerographic"),
        &[(0b00001, &ENTRY_AEROGRAPHIC_14818096080809523195)],
    ),
    (
        crate::EncodedStr::Ascii("aerographical"),
        &[(0b00001, &ENTRY_AEROGRAPHICAL_2429273948734988881)],
    ),
    (
        crate::EncodedStr::Ascii("aerographies"),
        &[(0b00001, &ENTRY_AEROGRAPHIES_11844593835635999782)],
    ),
    (
        crate::EncodedStr::Ascii("aerography"),
        &[(0b00001, &ENTRY_AEROGRAPHY_8481321619438820366)],
    ),
    (
        crate::EncodedStr::Ascii("aerologic"),
        &[(0b00001, &ENTRY_AEROLOGIC_6581703267250668822)],
    ),
    (
        crate::EncodedStr::Ascii("aerological"),
        &[(0b00001, &ENTRY_AEROLOGICAL_7035119647902064897)],
    ),
    (
        crate::EncodedStr::Ascii("aerologies"),
        &[(0b00001, &ENTRY_AEROLOGIES_9303474410588856691)],
    ),
    (
        crate::EncodedStr::Ascii("aerologist"),
        &[(0b00001, &ENTRY_AEROLOGIST_9043743609076361118)],
    ),
    (
        crate::EncodedStr::Ascii("aerology"),
        &[(0b00001, &ENTRY_AEROLOGY_2536724281135360580)],
    ),
    (
        crate::EncodedStr::Ascii("aerometer"),
        &[(0b00001, &ENTRY_AEROMETER_11742833131164166928)],
    ),
    (
        crate::EncodedStr::Ascii("aerometers"),
        &[(0b00001, &ENTRY_AEROMETERS_18338221712051507310)],
    ),
    (
        crate::EncodedStr::Ascii("aerometric"),
        &[(0b00001, &ENTRY_AEROMETRIC_13993414140130418477)],
    ),
    (
        crate::EncodedStr::Ascii("aerope"),
        &[(0b00001, &ENTRY_AEROPE_15996663583730344470)],
    ),
    (
        crate::EncodedStr::Ascii("aeroplane"),
        &[(0b10010, &ENTRY_AIRPLANE_8782402934308236857)],
    ),
    (
        crate::EncodedStr::Ascii("aeroplanes"),
        &[(0b10010, &ENTRY_AIRPLANES_10807576172790324268)],
    ),
    (
        crate::EncodedStr::Ascii("aeros"),
        &[(0b11010, &ENTRY_EROS_265509765297093167)],
    ),
    (
        crate::EncodedStr::Ascii("aerose"),
        &[(0b11010, &ENTRY_EROSE_5357559857770402424)],
    ),
    (
        crate::EncodedStr::Ascii("aeruginous"),
        &[(0b11010, &ENTRY_ERUGINOUS_5828853281772845437)],
    ),
    (
        crate::EncodedStr::Ascii("aerugo"),
        &[(0b11010, &ENTRY_ERUGO_17158132187061977414)],
    ),
    (
        crate::EncodedStr::Ascii("aerugos"),
        &[(0b11010, &ENTRY_ERUGOS_15673647349394448977)],
    ),
    (
        crate::EncodedStr::Ascii("aesc"),
        &[(0b11010, &ENTRY_ESC_734356833349788703)],
    ),
    (
        crate::EncodedStr::Ascii("aeschynite"),
        &[(0b11010, &ENTRY_ESCHYNITE_18313041144585925088)],
    ),
    (
        crate::EncodedStr::Ascii("aesculapian"),
        &[(0b11010, &ENTRY_ESCULAPIAN_490183703265219666)],
    ),
    (
        crate::EncodedStr::Ascii("aesculetin"),
        &[(0b11010, &ENTRY_ESCULETIN_4799035190382857787)],
    ),
    (
        crate::EncodedStr::Ascii("aesculin"),
        &[(0b11010, &ENTRY_ESCULIN_10740850830469064996)],
    ),
    (
        crate::EncodedStr::Ascii("aesop"),
        &[(0b11010, &ENTRY_ESOP_13490095149926411543)],
    ),
    (
        crate::EncodedStr::Ascii("aestheses"),
        &[(0b11010, &ENTRY_ESTHESES_16116389526306967239)],
    ),
    (
        crate::EncodedStr::Ascii("aesthesia"),
        &[(0b11010, &ENTRY_ESTHESIA_12451548753996008599)],
    ),
    (
        crate::EncodedStr::Ascii("aesthesias"),
        &[(0b11010, &ENTRY_ESTHESIAS_5684600885047217053)],
    ),
    (
        crate::EncodedStr::Ascii("aesthesiogen"),
        &[(0b11010, &ENTRY_ESTHESIOGEN_10989515066374267030)],
    ),
    (
        crate::EncodedStr::Ascii("aesthesiogenic"),
        &[(0b11010, &ENTRY_ESTHESIOGENIC_8056723690025617876)],
    ),
    (
        crate::EncodedStr::Ascii("aesthesiogens"),
        &[(0b11010, &ENTRY_ESTHESIOGENS_8380315319153501054)],
    ),
    (
        crate::EncodedStr::Ascii("aesthesis"),
        &[(0b11010, &ENTRY_ESTHESIS_7143001285276086388)],
    ),
    (
        crate::EncodedStr::Ascii("aesthetical"),
        &[(0b11010, &ENTRY_ESTHETICAL_827198906307006506)],
    ),
    (
        crate::EncodedStr::Ascii("aesthetician"),
        &[(0b11010, &ENTRY_ESTHETICIAN_4531333424171533067)],
    ),
    (
        crate::EncodedStr::Ascii("aestheticians"),
        &[(0b11010, &ENTRY_ESTHETICIANS_4428473313020471578)],
    ),
    (
        crate::EncodedStr::Ascii("aestheticise"),
        &[(0b10010, &ENTRY_AESTHETICIZE_2522964024252633997)],
    ),
    (
        crate::EncodedStr::Ascii("aestheticised"),
        &[(0b10010, &ENTRY_AESTHETICIZED_15671920631201201295)],
    ),
    (
        crate::EncodedStr::Ascii("aestheticises"),
        &[(0b10010, &ENTRY_AESTHETICIZES_11101104846362678924)],
    ),
    (
        crate::EncodedStr::Ascii("aestheticising"),
        &[(0b10010, &ENTRY_AESTHETICIZING_12506567272891321736)],
    ),
    (
        crate::EncodedStr::Ascii("aestheticize"),
        &[(0b01001, &ENTRY_AESTHETICIZE_2522964024252633997)],
    ),
    (
        crate::EncodedStr::Ascii("aestheticized"),
        &[(0b01001, &ENTRY_AESTHETICIZED_15671920631201201295)],
    ),
    (
        crate::EncodedStr::Ascii("aestheticizes"),
        &[(0b01001, &ENTRY_AESTHETICIZES_11101104846362678924)],
    ),
    (
        crate::EncodedStr::Ascii("aestheticizing"),
        &[(0b01001, &ENTRY_AESTHETICIZING_12506567272891321736)],
    ),
    (
        crate::EncodedStr::Ascii("aestivate"),
        &[(0b11010, &ENTRY_ESTIVATE_6682485567558262552)],
    ),
    (
        crate::EncodedStr::Ascii("aestivated"),
        &[(0b11010, &ENTRY_ESTIVATED_17659059957305359175)],
    ),
    (
        crate::EncodedStr::Ascii("aestivates"),
        &[(0b11010, &ENTRY_ESTIVATES_15795900041274255113)],
    ),
    (
        crate::EncodedStr::Ascii("aestivating"),
        &[(0b11010, &ENTRY_ESTIVATING_3590628019702465357)],
    ),
    (
        crate::EncodedStr::Ascii("aestivation"),
        &[(0b11010, &ENTRY_ESTIVATION_970593505059854945)],
    ),
    (
        crate::EncodedStr::Ascii("aestivations"),
        &[(0b11010, &ENTRY_ESTIVATIONS_11925170250729275718)],
    ),
    (
        crate::EncodedStr::Ascii("aestivator"),
        &[(0b11010, &ENTRY_ESTIVATOR_17192827254089360161)],
    ),
    (
        crate::EncodedStr::Ascii("aestive"),
        &[(0b11010, &ENTRY_ESTIVE_5420134362059951702)],
    ),
    (
        crate::EncodedStr::Ascii("aestuate"),
        &[(0b11010, &ENTRY_ESTUATE_7237204571723121927)],
    ),
    (
        crate::EncodedStr::Ascii("aestuous"),
        &[(0b11010, &ENTRY_ESTUOUS_15581034853542643799)],
    ),
    (
        crate::EncodedStr::Ascii("aesture"),
        &[(0b11010, &ENTRY_ESTURE_3483676630062562550)],
    ),
    (
        crate::EncodedStr::Ascii("aestus"),
        &[(0b11010, &ENTRY_ESTUS_10309034292162795617)],
    ),
    (
        crate::EncodedStr::Ascii("aet"),
        &[(0b11010, &ENTRY_ET_11650800039480951541)],
    ),
    (
        crate::EncodedStr::Ascii("aetheling"),
        &[(0b11010, &ENTRY_ETHELING_7453000440584654761)],
    ),
    (
        crate::EncodedStr::Ascii("aethered"),
        &[(0b11010, &ENTRY_ETHERED_11737830389019716848)],
    ),
    (
        crate::EncodedStr::Ascii("aetheric"),
        &[(0b11010, &ENTRY_ETHERIC_14308840270744949246)],
    ),
    (
        crate::EncodedStr::Ascii("aetiogenic"),
        &[(0b11010, &ENTRY_ETIOGENIC_4607596180327733291)],
    ),
    (
        crate::EncodedStr::Ascii("aetiologically"),
        &[(0b10010, &ENTRY_ETIOLOGICALLY_16961054798674884692)],
    ),
    (
        crate::EncodedStr::Ascii("aetiologist"),
        &[(0b11010, &ENTRY_ETIOLOGIST_11212980661305626571)],
    ),
    (
        crate::EncodedStr::Ascii("aetiologue"),
        &[(0b11010, &ENTRY_ETIOLOGUE_3427764260416926249)],
    ),
    (
        crate::EncodedStr::Ascii("aetiology"),
        &[(0b10010, &ENTRY_ETIOLOGY_7123968270032580321)],
    ),
    (
        crate::EncodedStr::Ascii("aetiophyllin"),
        &[(0b11010, &ENTRY_ETIOPHYLLIN_9404514496968390932)],
    ),
    (
        crate::EncodedStr::Ascii("aetiotropic"),
        &[(0b11010, &ENTRY_ETIOTROPIC_17191333273430729692)],
    ),
    (
        crate::EncodedStr::Ascii("aetiotropically"),
        &[(0b11010, &ENTRY_ETIOTROPICALLY_9902369940420748380)],
    ),
    (
        crate::EncodedStr::Ascii("aeviternal"),
        &[(0b11010, &ENTRY_EVITERNAL_11859651719653588022)],
    ),
    (
        crate::EncodedStr::Ascii("affeer"),
        &[(0b00001, &ENTRY_AFFEER_4911847901267534123)],
    ),
    (
        crate::EncodedStr::Ascii("affere"),
        &[(0b11010, &ENTRY_AFFEER_4911847901267534123)],
    ),
    (
        crate::EncodedStr::Ascii("africanisation"),
        &[(0b10010, &ENTRY_AFRICANIZATION_8630277601343405336)],
    ),
    (
        crate::EncodedStr::Ascii("africanisations"),
        &[(0b10010, &ENTRY_AFRICANIZATIONS_15208317190739871380)],
    ),
    (
        crate::EncodedStr::Ascii("africanise"),
        &[(0b10010, &ENTRY_AFRICANIZE_3531149313200349890)],
    ),
    (
        crate::EncodedStr::Ascii("africanised"),
        &[(0b10010, &ENTRY_AFRICANIZED_1736896838594873888)],
    ),
    (
        crate::EncodedStr::Ascii("africanises"),
        &[(0b10010, &ENTRY_AFRICANIZES_9591823452366186347)],
    ),
    (
        crate::EncodedStr::Ascii("africanising"),
        &[(0b10010, &ENTRY_AFRICANIZING_3956855341391764965)],
    ),
    (
        crate::EncodedStr::Ascii("africanization"),
        &[(0b01001, &ENTRY_AFRICANIZATION_8630277601343405336)],
    ),
    (
        crate::EncodedStr::Ascii("africanizations"),
        &[(0b01001, &ENTRY_AFRICANIZATIONS_15208317190739871380)],
    ),
    (
        crate::EncodedStr::Ascii("africanize"),
        &[(0b01001, &ENTRY_AFRICANIZE_3531149313200349890)],
    ),
    (
        crate::EncodedStr::Ascii("africanized"),
        &[(0b01001, &ENTRY_AFRICANIZED_1736896838594873888)],
    ),
    (
        crate::EncodedStr::Ascii("africanizes"),
        &[(0b01001, &ENTRY_AFRICANIZES_9591823452366186347)],
    ),
    (
        crate::EncodedStr::Ascii("africanizing"),
        &[(0b01001, &ENTRY_AFRICANIZING_3956855341391764965)],
    ),
    (
        crate::EncodedStr::Ascii("afrikanerisation"),
        &[(0b10010, &ENTRY_AFRIKANERIZATION_7997032707492466163)],
    ),
    (
        crate::EncodedStr::Ascii("afrikanerise"),
        &[(0b10010, &ENTRY_AFRIKANERIZE_10253557183425033567)],
    ),
    (
        crate::EncodedStr::Ascii("afrikanerised"),
        &[(0b10010, &ENTRY_AFRIKANERIZED_7798629609213388411)],
    ),
    (
        crate::EncodedStr::Ascii("afrikanerises"),
        &[(0b10010, &ENTRY_AFRIKANERIZES_8717515483112090861)],
    ),
    (
        crate::EncodedStr::Ascii("afrikanerising"),
        &[(0b10010, &ENTRY_AFRIKANERIZING_601585902747830882)],
    ),
    (
        crate::EncodedStr::Ascii("afrikanerization"),
        &[(0b01001, &ENTRY_AFRIKANERIZATION_7997032707492466163)],
    ),
    (
        crate::EncodedStr::Ascii("afrikanerize"),
        &[(0b01001, &ENTRY_AFRIKANERIZE_10253557183425033567)],
    ),
    (
        crate::EncodedStr::Ascii("afrikanerized"),
        &[(0b01001, &ENTRY_AFRIKANERIZED_7798629609213388411)],
    ),
    (
        crate::EncodedStr::Ascii("afrikanerizes"),
        &[(0b01001, &ENTRY_AFRIKANERIZES_8717515483112090861)],
    ),
    (
        crate::EncodedStr::Ascii("afrikanerizing"),
        &[(0b01001, &ENTRY_AFRIKANERIZING_601585902747830882)],
    ),
    (
        crate::EncodedStr::Ascii("afterward"),
        &[(0b01001, &ENTRY_AFTERWARDS_3336707444743528318)],
    ),
    (
        crate::EncodedStr::Ascii("agathodaemon"),
        &[(0b11010, &ENTRY_AGATHODEMON_1771853124296768685)],
    ),
    (
        crate::EncodedStr::Ascii("agathodemon"),
        &[(0b00001, &ENTRY_AGATHODEMON_1771853124296768685)],
    ),
    (
        crate::EncodedStr::Ascii("agatise"),
        &[(0b10010, &ENTRY_AGATIZE_541023285637455463)],
    ),
    (
        crate::EncodedStr::Ascii("agatises"),
        &[(0b10010, &ENTRY_AGATIZES_10204676816406829653)],
    ),
    (
        crate::EncodedStr::Ascii("agatize"),
        &[(0b01001, &ENTRY_AGATIZE_541023285637455463)],
    ),
    (
        crate::EncodedStr::Ascii("agatizes"),
        &[(0b01001, &ENTRY_AGATIZES_10204676816406829653)],
    ),
    (
        crate::EncodedStr::Ascii("agenise"),
        &[(0b10010, &ENTRY_AGENIZE_15273268881147024151)],
    ),
    (
        crate::EncodedStr::Ascii("agenize"),
        &[(0b01001, &ENTRY_AGENIZE_15273268881147024151)],
    ),
    (
        crate::EncodedStr::Ascii("ager"),
        &[(0b00001, &ENTRY_AGER_10154545747728403667)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandisable"),
        &[(0b10010, &ENTRY_AGGRANDIZABLE_14295678675229969268)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandisables"),
        &[(0b10010, &ENTRY_AGGRANDIZABLES_10156833661701900004)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandisation"),
        &[(0b10010, &ENTRY_AGGRANDIZATION_1714468788436088442)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandise"),
        &[(0b10010, &ENTRY_AGGRANDIZE_708175043678043149)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandised"),
        &[(0b10010, &ENTRY_AGGRANDIZED_13651433120186758007)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandisement"),
        &[(0b10010, &ENTRY_AGGRANDIZEMENT_16561527183094401215)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandisements"),
        &[(0b10010, &ENTRY_AGGRANDIZEMENTS_13855550959345858286)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandiser"),
        &[(0b10010, &ENTRY_AGGRANDIZER_8153478492362781998)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandisers"),
        &[(0b10010, &ENTRY_AGGRANDIZERS_760901957715839582)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandises"),
        &[(0b10010, &ENTRY_AGGRANDIZES_15288429086103149165)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandising"),
        &[(0b10010, &ENTRY_AGGRANDIZING_15004603903858043564)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandizable"),
        &[(0b01001, &ENTRY_AGGRANDIZABLE_14295678675229969268)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandizables"),
        &[(0b01001, &ENTRY_AGGRANDIZABLES_10156833661701900004)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandization"),
        &[(0b01001, &ENTRY_AGGRANDIZATION_1714468788436088442)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandize"),
        &[(0b01001, &ENTRY_AGGRANDIZE_708175043678043149)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandized"),
        &[(0b01001, &ENTRY_AGGRANDIZED_13651433120186758007)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandizement"),
        &[(0b01001, &ENTRY_AGGRANDIZEMENT_16561527183094401215)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandizements"),
        &[(0b01001, &ENTRY_AGGRANDIZEMENTS_13855550959345858286)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandizer"),
        &[(0b01001, &ENTRY_AGGRANDIZER_8153478492362781998)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandizers"),
        &[(0b01001, &ENTRY_AGGRANDIZERS_760901957715839582)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandizes"),
        &[(0b01001, &ENTRY_AGGRANDIZES_15288429086103149165)],
    ),
    (
        crate::EncodedStr::Ascii("aggrandizing"),
        &[(0b01001, &ENTRY_AGGRANDIZING_15004603903858043564)],
    ),
    (
        crate::EncodedStr::Ascii("agnise"),
        &[(0b10010, &ENTRY_AGNIZE_5083365122577693060)],
    ),
    (
        crate::EncodedStr::Ascii("agnised"),
        &[(0b10010, &ENTRY_AGNIZED_9871346460164509669)],
    ),
    (
        crate::EncodedStr::Ascii("agnises"),
        &[(0b10010, &ENTRY_AGNIZES_14381052475043058703)],
    ),
    (
        crate::EncodedStr::Ascii("agnising"),
        &[(0b10010, &ENTRY_AGNIZING_312582546202684561)],
    ),
    (
        crate::EncodedStr::Ascii("agnize"),
        &[(0b01001, &ENTRY_AGNIZE_5083365122577693060)],
    ),
    (
        crate::EncodedStr::Ascii("agnized"),
        &[(0b01001, &ENTRY_AGNIZED_9871346460164509669)],
    ),
    (
        crate::EncodedStr::Ascii("agnizes"),
        &[(0b01001, &ENTRY_AGNIZES_14381052475043058703)],
    ),
    (
        crate::EncodedStr::Ascii("agnizing"),
        &[(0b01001, &ENTRY_AGNIZING_312582546202684561)],
    ),
    (
        crate::EncodedStr::Ascii("agonise"),
        &[(0b10010, &ENTRY_AGONIZE_1178366636885440302)],
    ),
    (
        crate::EncodedStr::Ascii("agonised"),
        &[(0b10010, &ENTRY_AGONIZED_8097803478456449055)],
    ),
    (
        crate::EncodedStr::Ascii("agonisedlies"),
        &[(0b10010, &ENTRY_AGONIZEDLIES_3178039635895059319)],
    ),
    (
        crate::EncodedStr::Ascii("agonisedly"),
        &[(0b10010, &ENTRY_AGONIZEDLY_2195479848919207850)],
    ),
    (
        crate::EncodedStr::Ascii("agoniser"),
        &[(0b10010, &ENTRY_AGONIZER_17018191209891639507)],
    ),
    (
        crate::EncodedStr::Ascii("agonisers"),
        &[(0b10010, &ENTRY_AGONIZERS_12684640191692446391)],
    ),
    (
        crate::EncodedStr::Ascii("agonises"),
        &[(0b10010, &ENTRY_AGONIZES_3115769157415966926)],
    ),
    (
        crate::EncodedStr::Ascii("agonising"),
        &[(0b10010, &ENTRY_AGONIZING_1569032344642333561)],
    ),
    (
        crate::EncodedStr::Ascii("agonisinglier"),
        &[(0b10010, &ENTRY_AGONIZINGLIER_8898888445219953420)],
    ),
    (
        crate::EncodedStr::Ascii("agonisingliest"),
        &[(0b10010, &ENTRY_AGONIZINGLIEST_12888967969387776485)],
    ),
    (
        crate::EncodedStr::Ascii("agonisingly"),
        &[(0b10010, &ENTRY_AGONIZINGLY_4863314422731006583)],
    ),
    (
        crate::EncodedStr::Ascii("agonize"),
        &[(0b01001, &ENTRY_AGONIZE_1178366636885440302)],
    ),
    (
        crate::EncodedStr::Ascii("agonized"),
        &[(0b01001, &ENTRY_AGONIZED_8097803478456449055)],
    ),
    (
        crate::EncodedStr::Ascii("agonizedlies"),
        &[(0b01001, &ENTRY_AGONIZEDLIES_3178039635895059319)],
    ),
    (
        crate::EncodedStr::Ascii("agonizedly"),
        &[(0b01001, &ENTRY_AGONIZEDLY_2195479848919207850)],
    ),
    (
        crate::EncodedStr::Ascii("agonizer"),
        &[(0b01001, &ENTRY_AGONIZER_17018191209891639507)],
    ),
    (
        crate::EncodedStr::Ascii("agonizers"),
        &[(0b01001, &ENTRY_AGONIZERS_12684640191692446391)],
    ),
    (
        crate::EncodedStr::Ascii("agonizes"),
        &[(0b01001, &ENTRY_AGONIZES_3115769157415966926)],
    ),
    (
        crate::EncodedStr::Ascii("agonizing"),
        &[(0b01001, &ENTRY_AGONIZING_1569032344642333561)],
    ),
    (
        crate::EncodedStr::Ascii("agonizinglier"),
        &[(0b01001, &ENTRY_AGONIZINGLIER_8898888445219953420)],
    ),
    (
        crate::EncodedStr::Ascii("agonizingliest"),
        &[(0b01001, &ENTRY_AGONIZINGLIEST_12888967969387776485)],
    ),
    (
        crate::EncodedStr::Ascii("agonizingly"),
        &[(0b01001, &ENTRY_AGONIZINGLY_4863314422731006583)],
    ),
    (
        crate::EncodedStr::Ascii("agrarianise"),
        &[(0b10010, &ENTRY_AGRARIANIZE_6371637247712194397)],
    ),
    (
        crate::EncodedStr::Ascii("agrarianises"),
        &[(0b10010, &ENTRY_AGRARIANIZES_6961780232175522640)],
    ),
    (
        crate::EncodedStr::Ascii("agrarianize"),
        &[(0b01001, &ENTRY_AGRARIANIZE_6371637247712194397)],
    ),
    (
        crate::EncodedStr::Ascii("agrarianizes"),
        &[(0b01001, &ENTRY_AGRARIANIZES_6961780232175522640)],
    ),
    (
        crate::EncodedStr::Ascii("agre"),
        &[(0b11010, &ENTRY_AGER_10154545747728403667)],
    ),
    (
        crate::EncodedStr::Ascii("agrise"),
        &[(0b10010, &ENTRY_AGRIZE_1296239263088830290)],
    ),
    (
        crate::EncodedStr::Ascii("agrised"),
        &[(0b10010, &ENTRY_AGRIZED_5916161568343203612)],
    ),
    (
        crate::EncodedStr::Ascii("agrises"),
        &[(0b10010, &ENTRY_AGRIZES_8679221560630105389)],
    ),
    (
        crate::EncodedStr::Ascii("agrising"),
        &[(0b10010, &ENTRY_AGRIZING_15134245886550376210)],
    ),
    (
        crate::EncodedStr::Ascii("agrize"),
        &[(0b01001, &ENTRY_AGRIZE_1296239263088830290)],
    ),
    (
        crate::EncodedStr::Ascii("agrized"),
        &[(0b01001, &ENTRY_AGRIZED_5916161568343203612)],
    ),
    (
        crate::EncodedStr::Ascii("agrizes"),
        &[(0b01001, &ENTRY_AGRIZES_8679221560630105389)],
    ),
    (
        crate::EncodedStr::Ascii("agrizing"),
        &[(0b01001, &ENTRY_AGRIZING_15134245886550376210)],
    ),
    (
        crate::EncodedStr::Ascii("aguise"),
        &[(0b10010, &ENTRY_AGUIZE_11273323337042225528)],
    ),
    (
        crate::EncodedStr::Ascii("aguised"),
        &[(0b10010, &ENTRY_AGUIZED_11146501883929771035)],
    ),
    (
        crate::EncodedStr::Ascii("aguises"),
        &[(0b10010, &ENTRY_AGUIZES_3631645618729972992)],
    ),
    (
        crate::EncodedStr::Ascii("aguising"),
        &[(0b10010, &ENTRY_AGUIZING_13415435362810054429)],
    ),
    (
        crate::EncodedStr::Ascii("aguize"),
        &[(0b01001, &ENTRY_AGUIZE_11273323337042225528)],
    ),
    (
        crate::EncodedStr::Ascii("aguized"),
        &[(0b01001, &ENTRY_AGUIZED_11146501883929771035)],
    ),
    (
        crate::EncodedStr::Ascii("aguizes"),
        &[(0b01001, &ENTRY_AGUIZES_3631645618729972992)],
    ),
    (
        crate::EncodedStr::Ascii("aguizing"),
        &[(0b01001, &ENTRY_AGUIZING_13415435362810054429)],
    ),
    (
        crate::EncodedStr::Ascii("aiger"),
        &[(0b00001, &ENTRY_AIGER_3810072320924874026)],
    ),
    (
        crate::EncodedStr::Ascii("aigre"),
        &[(0b11010, &ENTRY_AIGER_3810072320924874026)],
    ),
    (
        crate::EncodedStr::Ascii("airfoil"),
        &[(0b01001, &ENTRY_AIRFOIL_6251188039396016525)],
    ),
    (
        crate::EncodedStr::Ascii("airfoils"),
        &[(0b01001, &ENTRY_AIRFOILS_11117747260949333982)],
    ),
    (
        crate::EncodedStr::Ascii("airgel"),
        &[(0b00001, &ENTRY_AIRGEL_9703257971421731594)],
    ),
    (
        crate::EncodedStr::Ascii("airplane"),
        &[(0b11001, &ENTRY_AIRPLANE_8782402934308236857)],
    ),
    (
        crate::EncodedStr::Ascii("airplanes"),
        &[(0b11001, &ENTRY_AIRPLANES_10807576172790324268)],
    ),
    (
        crate::EncodedStr::Ascii("aker"),
        &[(0b00001, &ENTRY_AKER_7390977175698591709)],
    ),
    (
        crate::EncodedStr::Ascii("akre"),
        &[(0b11010, &ENTRY_AKER_7390977175698591709)],
    ),
    (
        crate::EncodedStr::Ascii("aktistetae"),
        &[(0b11010, &ENTRY_AKTISTETE_9761990384859089931)],
    ),
    (
        crate::EncodedStr::Ascii("aktistete"),
        &[(0b00001, &ENTRY_AKTISTETE_9761990384859089931)],
    ),
    (
        crate::EncodedStr::Ascii("albitise"),
        &[(0b10010, &ENTRY_ALBITIZE_10634446337478573748)],
    ),
    (
        crate::EncodedStr::Ascii("albitised"),
        &[(0b10010, &ENTRY_ALBITIZED_5682763730263988051)],
    ),
    (
        crate::EncodedStr::Ascii("albitises"),
        &[(0b10010, &ENTRY_ALBITIZES_8014501325445378157)],
    ),
    (
        crate::EncodedStr::Ascii("albitising"),
        &[(0b10010, &ENTRY_ALBITIZING_13797609614113010011)],
    ),
    (
        crate::EncodedStr::Ascii("albitize"),
        &[(0b01001, &ENTRY_ALBITIZE_10634446337478573748)],
    ),
    (
        crate::EncodedStr::Ascii("albitized"),
        &[(0b01001, &ENTRY_ALBITIZED_5682763730263988051)],
    ),
    (
        crate::EncodedStr::Ascii("albitizes"),
        &[(0b01001, &ENTRY_ALBITIZES_8014501325445378157)],
    ),
    (
        crate::EncodedStr::Ascii("albitizing"),
        &[(0b01001, &ENTRY_ALBITIZING_13797609614113010011)],
    ),
    (
        crate::EncodedStr::Ascii("albumeniser"),
        &[(0b10010, &ENTRY_ALBUMENIZER_59375995865224011)],
    ),
    (
        crate::EncodedStr::Ascii("albumenization"),
        &[(0b00001, &ENTRY_ALBUMENIZATION_3169676911273449215)],
    ),
    (
        crate::EncodedStr::Ascii("albumenizations"),
        &[(0b00001, &ENTRY_ALBUMENIZATIONS_15542650325957452592)],
    ),
    (
        crate::EncodedStr::Ascii("albumenize"),
        &[(0b00001, &ENTRY_ALBUMENIZE_15336406098611814458)],
    ),
    (
        crate::EncodedStr::Ascii("albumenized"),
        &[(0b00001, &ENTRY_ALBUMENIZED_9044864672629997378)],
    ),
    (
        crate::EncodedStr::Ascii("albumenizer"),
        &[(0b01001, &ENTRY_ALBUMENIZER_59375995865224011)],
    ),
    (
        crate::EncodedStr::Ascii("albumenizes"),
        &[(0b00001, &ENTRY_ALBUMENIZES_2079965422881672979)],
    ),
    (
        crate::EncodedStr::Ascii("albumenizing"),
        &[(0b00001, &ENTRY_ALBUMENIZING_16229928715193703812)],
    ),
    (
        crate::EncodedStr::Ascii("albuminisation"),
        &[(0b10010, &ENTRY_ALBUMENIZATION_3169676911273449215)],
    ),
    (
        crate::EncodedStr::Ascii("albuminisations"),
        &[(0b10010, &ENTRY_ALBUMENIZATIONS_15542650325957452592)],
    ),
    (
        crate::EncodedStr::Ascii("albuminise"),
        &[(0b10010, &ENTRY_ALBUMENIZE_15336406098611814458)],
    ),
    (
        crate::EncodedStr::Ascii("albuminised"),
        &[(0b10010, &ENTRY_ALBUMENIZED_9044864672629997378)],
    ),
    (
        crate::EncodedStr::Ascii("albuminises"),
        &[(0b10010, &ENTRY_ALBUMENIZES_2079965422881672979)],
    ),
    (
        crate::EncodedStr::Ascii("albuminising"),
        &[(0b10010, &ENTRY_ALBUMENIZING_16229928715193703812)],
    ),
    (
        crate::EncodedStr::Ascii("albuminization"),
        &[(0b01000, &ENTRY_ALBUMENIZATION_3169676911273449215)],
    ),
    (
        crate::EncodedStr::Ascii("albuminizations"),
        &[(0b01000, &ENTRY_ALBUMENIZATIONS_15542650325957452592)],
    ),
    (
        crate::EncodedStr::Ascii("albuminize"),
        &[(0b01000, &ENTRY_ALBUMENIZE_15336406098611814458)],
    ),
    (
        crate::EncodedStr::Ascii("albuminized"),
        &[(0b01000, &ENTRY_ALBUMENIZED_9044864672629997378)],
    ),
    (
        crate::EncodedStr::Ascii("albuminizes"),
        &[(0b01000, &ENTRY_ALBUMENIZES_2079965422881672979)],
    ),
    (
        crate::EncodedStr::Ascii("albuminizing"),
        &[(0b01000, &ENTRY_ALBUMENIZING_16229928715193703812)],
    ),
    (
        crate::EncodedStr::Ascii("alchemise"),
        &[(0b10010, &ENTRY_ALCHEMIZE_5791832055645561888)],
    ),
    (
        crate::EncodedStr::Ascii("alchemised"),
        &[(0b10010, &ENTRY_ALCHEMIZED_8934414538470219345)],
    ),
    (
        crate::EncodedStr::Ascii("alchemises"),
        &[(0b10010, &ENTRY_ALCHEMIZES_6042589921854557418)],
    ),
    (
        crate::EncodedStr::Ascii("alchemising"),
        &[(0b10010, &ENTRY_ALCHEMIZING_12951450180936067566)],
    ),
    (
        crate::EncodedStr::Ascii("alchemize"),
        &[(0b01001, &ENTRY_ALCHEMIZE_5791832055645561888)],
    ),
    (
        crate::EncodedStr::Ascii("alchemized"),
        &[(0b01001, &ENTRY_ALCHEMIZED_8934414538470219345)],
    ),
    (
        crate::EncodedStr::Ascii("alchemizes"),
        &[(0b01001, &ENTRY_ALCHEMIZES_6042589921854557418)],
    ),
    (
        crate::EncodedStr::Ascii("alchemizing"),
        &[(0b01001, &ENTRY_ALCHEMIZING_12951450180936067566)],
    ),
    (
        crate::EncodedStr::Ascii("alcidae"),
        &[(0b11010, &ENTRY_ALCIDE_3165060712397761800)],
    ),
    (
        crate::EncodedStr::Ascii("alcide"),
        &[(0b00001, &ENTRY_ALCIDE_3165060712397761800)],
    ),
    (
        crate::EncodedStr::Ascii("alcithoae"),
        &[(0b11010, &ENTRY_ALCITHOE_1570391634240756603)],
    ),
    (
        crate::EncodedStr::Ascii("alcithoe"),
        &[(0b00001, &ENTRY_ALCITHOE_1570391634240756603)],
    ),
    (
        crate::EncodedStr::Ascii("alcoholisable"),
        &[(0b10010, &ENTRY_ALCOHOLIZABLE_5712454359040751327)],
    ),
    (
        crate::EncodedStr::Ascii("alcoholisables"),
        &[(0b10010, &ENTRY_ALCOHOLIZABLES_787461776643349088)],
    ),
    (
        crate::EncodedStr::Ascii("alcoholisation"),
        &[(0b10010, &ENTRY_ALCOHOLIZATION_9324633993605207466)],
    ),
    (
        crate::EncodedStr::Ascii("alcoholisations"),
        &[(0b10010, &ENTRY_ALCOHOLIZATIONS_5826849890784377569)],
    ),
    (
        crate::EncodedStr::Ascii("alcoholise"),
        &[(0b10010, &ENTRY_ALCOHOLIZE_7529158246880124791)],
    ),
    (
        crate::EncodedStr::Ascii("alcoholised"),
        &[(0b10010, &ENTRY_ALCOHOLIZED_1088708612671476327)],
    ),
    (
        crate::EncodedStr::Ascii("alcoholises"),
        &[(0b10010, &ENTRY_ALCOHOLIZES_155350708519960662)],
    ),
    (
        crate::EncodedStr::Ascii("alcoholising"),
        &[(0b10010, &ENTRY_ALCOHOLIZING_9204884893125609497)],
    ),
    (
        crate::EncodedStr::Ascii("alcoholizable"),
        &[(0b01001, &ENTRY_ALCOHOLIZABLE_5712454359040751327)],
    ),
    (
        crate::EncodedStr::Ascii("alcoholizables"),
        &[(0b01001, &ENTRY_ALCOHOLIZABLES_787461776643349088)],
    ),
    (
        crate::EncodedStr::Ascii("alcoholization"),
        &[(0b01001, &ENTRY_ALCOHOLIZATION_9324633993605207466)],
    ),
    (
        crate::EncodedStr::Ascii("alcoholizations"),
        &[(0b01001, &ENTRY_ALCOHOLIZATIONS_5826849890784377569)],
    ),
    (
        crate::EncodedStr::Ascii("alcoholize"),
        &[(0b01001, &ENTRY_ALCOHOLIZE_7529158246880124791)],
    ),
    (
        crate::EncodedStr::Ascii("alcoholized"),
        &[(0b01001, &ENTRY_ALCOHOLIZED_1088708612671476327)],
    ),
    (
        crate::EncodedStr::Ascii("alcoholizes"),
        &[(0b01001, &ENTRY_ALCOHOLIZES_155350708519960662)],
    ),
    (
        crate::EncodedStr::Ascii("alcoholizing"),
        &[(0b01001, &ENTRY_ALCOHOLIZING_9204884893125609497)],
    ),
    (
        crate::EncodedStr::Ascii("aleucaemic"),
        &[(0b11010, &ENTRY_ALEUCEMIC_13145390844272291381)],
    ),
    (
        crate::EncodedStr::Ascii("aleucemic"),
        &[(0b00001, &ENTRY_ALEUCEMIC_13145390844272291381)],
    ),
    (
        crate::EncodedStr::Ascii("aleukaemic"),
        &[(0b11010, &ENTRY_ALEUKEMIC_1675800078665474730)],
    ),
    (
        crate::EncodedStr::Ascii("aleukemic"),
        &[(0b00001, &ENTRY_ALEUKEMIC_1675800078665474730)],
    ),
    (
        crate::EncodedStr::Ascii("aleus"),
        &[(0b00001, &ENTRY_ALEUS_15999250050243856705)],
    ),
    (
        crate::EncodedStr::Ascii("algaesthesis"),
        &[(0b11010, &ENTRY_ALGESTHESIS_11669784295039335497)],
    ),
    (
        crate::EncodedStr::Ascii("algebraisation"),
        &[(0b10010, &ENTRY_ALGEBRAIZATION_6100403580413387962)],
    ),
    (
        crate::EncodedStr::Ascii("algebraisations"),
        &[(0b10010, &ENTRY_ALGEBRAIZATIONS_8499204281897687517)],
    ),
    (
        crate::EncodedStr::Ascii("algebraise"),
        &[(0b10010, &ENTRY_ALGEBRAIZE_3156432712023151827)],
    ),
    (
        crate::EncodedStr::Ascii("algebraises"),
        &[(0b10010, &ENTRY_ALGEBRAIZES_8779747351341505922)],
    ),
    (
        crate::EncodedStr::Ascii("algebraization"),
        &[(0b01001, &ENTRY_ALGEBRAIZATION_6100403580413387962)],
    ),
    (
        crate::EncodedStr::Ascii("algebraizations"),
        &[(0b01001, &ENTRY_ALGEBRAIZATIONS_8499204281897687517)],
    ),
    (
        crate::EncodedStr::Ascii("algebraize"),
        &[(0b01001, &ENTRY_ALGEBRAIZE_3156432712023151827)],
    ),
    (
        crate::EncodedStr::Ascii("algebraizes"),
        &[(0b01001, &ENTRY_ALGEBRAIZES_8779747351341505922)],
    ),
    (
        crate::EncodedStr::Ascii("algesthesis"),
        &[(0b00001, &ENTRY_ALGESTHESIS_11669784295039335497)],
    ),
    (
        crate::EncodedStr::Ascii("alienise"),
        &[(0b10010, &ENTRY_ALIENIZE_2375788601438381665)],
    ),
    (
        crate::EncodedStr::Ascii("alienises"),
        &[(0b10010, &ENTRY_ALIENIZES_16619977169071842029)],
    ),
    (
        crate::EncodedStr::Ascii("alienize"),
        &[(0b01001, &ENTRY_ALIENIZE_2375788601438381665)],
    ),
    (
        crate::EncodedStr::Ascii("alienizes"),
        &[(0b01001, &ENTRY_ALIENIZES_16619977169071842029)],
    ),
    (
        crate::EncodedStr::Ascii("aline"),
        &[(0b00001, &ENTRY_ALIGN_12031178495543818165)],
    ),
    (
        crate::EncodedStr::Ascii("alined"),
        &[(0b00001, &ENTRY_ALIGNED_12402894359661352325)],
    ),
    (
        crate::EncodedStr::Ascii("alinement"),
        &[(0b00001, &ENTRY_ALIGNMENT_2011105833470144949)],
    ),
    (
        crate::EncodedStr::Ascii("alinements"),
        &[(0b00001, &ENTRY_ALIGNMENTS_14673777835100591286)],
    ),
    (
        crate::EncodedStr::Ascii("alines"),
        &[(0b00001, &ENTRY_ALIGNS_7566776423028199708)],
    ),
    (
        crate::EncodedStr::Ascii("alining"),
        &[(0b00001, &ENTRY_ALIGNING_11699553166951544819)],
    ),
    (
        crate::EncodedStr::Ascii("alkalinisation"),
        &[(0b10010, &ENTRY_ALKALINIZATION_8644837671846444891)],
    ),
    (
        crate::EncodedStr::Ascii("alkalinisations"),
        &[(0b10010, &ENTRY_ALKALINIZATIONS_2537063136327717146)],
    ),
    (
        crate::EncodedStr::Ascii("alkalinise"),
        &[(0b10010, &ENTRY_ALKALINIZE_11019313678160087688)],
    ),
    (
        crate::EncodedStr::Ascii("alkalinised"),
        &[(0b10010, &ENTRY_ALKALINIZED_13701976256938611329)],
    ),
    (
        crate::EncodedStr::Ascii("alkalinises"),
        &[(0b10010, &ENTRY_ALKALINIZES_12313309629208791921)],
    ),
    (
        crate::EncodedStr::Ascii("alkalinising"),
        &[(0b10010, &ENTRY_ALKALINIZING_4329175391998172496)],
    ),
    (
        crate::EncodedStr::Ascii("alkalinization"),
        &[(0b01001, &ENTRY_ALKALINIZATION_8644837671846444891)],
    ),
    (
        crate::EncodedStr::Ascii("alkalinizations"),
        &[(0b01001, &ENTRY_ALKALINIZATIONS_2537063136327717146)],
    ),
    (
        crate::EncodedStr::Ascii("alkalinize"),
        &[(0b01001, &ENTRY_ALKALINIZE_11019313678160087688)],
    ),
    (
        crate::EncodedStr::Ascii("alkalinized"),
        &[(0b01001, &ENTRY_ALKALINIZED_13701976256938611329)],
    ),
    (
        crate::EncodedStr::Ascii("alkalinizes"),
        &[(0b01001, &ENTRY_ALKALINIZES_12313309629208791921)],
    ),
    (
        crate::EncodedStr::Ascii("alkalinizing"),
        &[(0b01001, &ENTRY_ALKALINIZING_4329175391998172496)],
    ),
    (
        crate::EncodedStr::Ascii("alkalisable"),
        &[(0b10010, &ENTRY_ALKALIZABLE_11752711297106864279)],
    ),
    (
        crate::EncodedStr::Ascii("alkalisation"),
        &[(0b10010, &ENTRY_ALKALIZATION_8215651930061013709)],
    ),
    (
        crate::EncodedStr::Ascii("alkalisations"),
        &[(0b10010, &ENTRY_ALKALIZATIONS_1922502555535793567)],
    ),
    (
        crate::EncodedStr::Ascii("alkalise"),
        &[(0b10010, &ENTRY_ALKALIZE_5536262726734715214)],
    ),
    (
        crate::EncodedStr::Ascii("alkalised"),
        &[(0b10010, &ENTRY_ALKALIZED_13051886098360700675)],
    ),
    (
        crate::EncodedStr::Ascii("alkaliser"),
        &[(0b10010, &ENTRY_ALKALIZER_6759136131876406609)],
    ),
    (
        crate::EncodedStr::Ascii("alkalises"),
        &[(0b10010, &ENTRY_ALKALIZES_13569450310007941622)],
    ),
    (
        crate::EncodedStr::Ascii("alkalising"),
        &[(0b10010, &ENTRY_ALKALIZING_8020169751754023745)],
    ),
    (
        crate::EncodedStr::Ascii("alkalizable"),
        &[(0b01001, &ENTRY_ALKALIZABLE_11752711297106864279)],
    ),
    (
        crate::EncodedStr::Ascii("alkalization"),
        &[(0b01001, &ENTRY_ALKALIZATION_8215651930061013709)],
    ),
    (
        crate::EncodedStr::Ascii("alkalizations"),
        &[(0b01001, &ENTRY_ALKALIZATIONS_1922502555535793567)],
    ),
    (
        crate::EncodedStr::Ascii("alkalize"),
        &[(0b01001, &ENTRY_ALKALIZE_5536262726734715214)],
    ),
    (
        crate::EncodedStr::Ascii("alkalized"),
        &[(0b01001, &ENTRY_ALKALIZED_13051886098360700675)],
    ),
    (
        crate::EncodedStr::Ascii("alkalizer"),
        &[(0b01001, &ENTRY_ALKALIZER_6759136131876406609)],
    ),
    (
        crate::EncodedStr::Ascii("alkalizes"),
        &[(0b01001, &ENTRY_ALKALIZES_13569450310007941622)],
    ),
    (
        crate::EncodedStr::Ascii("alkalizing"),
        &[(0b01001, &ENTRY_ALKALIZING_8020169751754023745)],
    ),
    (
        crate::EncodedStr::Ascii("allegorisation"),
        &[(0b10010, &ENTRY_ALLEGORIZATION_14762864111557060395)],
    ),
    (
        crate::EncodedStr::Ascii("allegorisations"),
        &[(0b10010, &ENTRY_ALLEGORIZATIONS_1317829325279302497)],
    ),
    (
        crate::EncodedStr::Ascii("allegorise"),
        &[(0b10010, &ENTRY_ALLEGORIZE_6482121904165219135)],
    ),
    (
        crate::EncodedStr::Ascii("allegorised"),
        &[(0b10010, &ENTRY_ALLEGORIZED_11740413629820898932)],
    ),
    (
        crate::EncodedStr::Ascii("allegoriser"),
        &[(0b10010, &ENTRY_ALLEGORIZER_4274874326715631309)],
    ),
    (
        crate::EncodedStr::Ascii("allegorisers"),
        &[(0b10010, &ENTRY_ALLEGORIZERS_114835122393079616)],
    ),
    (
        crate::EncodedStr::Ascii("allegorises"),
        &[(0b10010, &ENTRY_ALLEGORIZES_4178362701003728243)],
    ),
    (
        crate::EncodedStr::Ascii("allegorising"),
        &[(0b10010, &ENTRY_ALLEGORIZING_899303066346673273)],
    ),
    (
        crate::EncodedStr::Ascii("allegorization"),
        &[(0b01001, &ENTRY_ALLEGORIZATION_14762864111557060395)],
    ),
    (
        crate::EncodedStr::Ascii("allegorizations"),
        &[(0b01001, &ENTRY_ALLEGORIZATIONS_1317829325279302497)],
    ),
    (
        crate::EncodedStr::Ascii("allegorize"),
        &[(0b01001, &ENTRY_ALLEGORIZE_6482121904165219135)],
    ),
    (
        crate::EncodedStr::Ascii("allegorized"),
        &[(0b01001, &ENTRY_ALLEGORIZED_11740413629820898932)],
    ),
    (
        crate::EncodedStr::Ascii("allegorizer"),
        &[(0b01001, &ENTRY_ALLEGORIZER_4274874326715631309)],
    ),
    (
        crate::EncodedStr::Ascii("allegorizers"),
        &[(0b01001, &ENTRY_ALLEGORIZERS_114835122393079616)],
    ),
    (
        crate::EncodedStr::Ascii("allegorizes"),
        &[(0b01001, &ENTRY_ALLEGORIZES_4178362701003728243)],
    ),
    (
        crate::EncodedStr::Ascii("allegorizing"),
        &[(0b01001, &ENTRY_ALLEGORIZING_899303066346673273)],
    ),
    (
        crate::EncodedStr::Ascii("alloxuraemia"),
        &[(0b11010, &ENTRY_ALLOXUREMIA_6517416850737377397)],
    ),
    (
        crate::EncodedStr::Ascii("alloxuremia"),
        &[(0b00001, &ENTRY_ALLOXUREMIA_6517416850737377397)],
    ),
    (
        crate::EncodedStr::Ascii("almanack"),
        &[(0b10010, &ENTRY_ALMANAC_15717861359409582720)],
    ),
    (
        crate::EncodedStr::Ascii("almanacks"),
        &[(0b10010, &ENTRY_ALMANACS_9267005522772569452)],
    ),
    (
        crate::EncodedStr::Ascii("aloeus"),
        &[(0b11010, &ENTRY_ALEUS_15999250050243856705)],
    ),
    (
        crate::EncodedStr::Ascii("alphabetisation"),
        &[(0b10010, &ENTRY_ALPHABETIZATION_16660905929935057642)],
    ),
    (
        crate::EncodedStr::Ascii("alphabetisations"),
        &[(0b10010, &ENTRY_ALPHABETIZATIONS_17047359931254284362)],
    ),
    (
        crate::EncodedStr::Ascii("alphabetise"),
        &[(0b10010, &ENTRY_ALPHABETIZE_5185363765846869604)],
    ),
    (
        crate::EncodedStr::Ascii("alphabetised"),
        &[(0b10010, &ENTRY_ALPHABETIZED_1298633346805774272)],
    ),
    (
        crate::EncodedStr::Ascii("alphabetiser"),
        &[(0b10010, &ENTRY_ALPHABETIZER_14767864421419944921)],
    ),
    (
        crate::EncodedStr::Ascii("alphabetisers"),
        &[(0b10010, &ENTRY_ALPHABETIZERS_6296269536595041194)],
    ),
    (
        crate::EncodedStr::Ascii("alphabetises"),
        &[(0b10010, &ENTRY_ALPHABETIZES_12175651960887303885)],
    ),
    (
        crate::EncodedStr::Ascii("alphabetising"),
        &[(0b10010, &ENTRY_ALPHABETIZING_8059168115305559564)],
    ),
    (
        crate::EncodedStr::Ascii("alphabetization"),
        &[(0b01001, &ENTRY_ALPHABETIZATION_16660905929935057642)],
    ),
    (
        crate::EncodedStr::Ascii("alphabetizations"),
        &[(0b01001, &ENTRY_ALPHABETIZATIONS_17047359931254284362)],
    ),
    (
        crate::EncodedStr::Ascii("alphabetize"),
        &[(0b01001, &ENTRY_ALPHABETIZE_5185363765846869604)],
    ),
    (
        crate::EncodedStr::Ascii("alphabetized"),
        &[(0b01001, &ENTRY_ALPHABETIZED_1298633346805774272)],
    ),
    (
        crate::EncodedStr::Ascii("alphabetizer"),
        &[(0b01001, &ENTRY_ALPHABETIZER_14767864421419944921)],
    ),
    (
        crate::EncodedStr::Ascii("alphabetizers"),
        &[(0b01001, &ENTRY_ALPHABETIZERS_6296269536595041194)],
    ),
    (
        crate::EncodedStr::Ascii("alphabetizes"),
        &[(0b01001, &ENTRY_ALPHABETIZES_12175651960887303885)],
    ),
    (
        crate::EncodedStr::Ascii("alphabetizing"),
        &[(0b01001, &ENTRY_ALPHABETIZING_8059168115305559564)],
    ),
    (
        crate::EncodedStr::Ascii("alternise"),
        &[(0b10010, &ENTRY_ALTERNIZE_285767739893718525)],
    ),
    (
        crate::EncodedStr::Ascii("alternises"),
        &[(0b10010, &ENTRY_ALTERNIZES_9696050258020074609)],
    ),
    (
        crate::EncodedStr::Ascii("alternize"),
        &[(0b01001, &ENTRY_ALTERNIZE_285767739893718525)],
    ),
    (
        crate::EncodedStr::Ascii("alternizes"),
        &[(0b01001, &ENTRY_ALTERNIZES_9696050258020074609)],
    ),
    (
        crate::EncodedStr::Ascii("althaea"),
        &[(0b11010, &ENTRY_ALTHEA_11553591055146462879)],
    ),
    (
        crate::EncodedStr::Ascii("althaeas"),
        &[(0b11010, &ENTRY_ALTHEAS_841278574081921149)],
    ),
    (
        crate::EncodedStr::Ascii("althaein"),
        &[(0b11010, &ENTRY_ALTHEIN_11491174847546175682)],
    ),
    (
        crate::EncodedStr::Ascii("althea"),
        &[(0b10001, &ENTRY_ALTHEA_11553591055146462879)],
    ),
    (
        crate::EncodedStr::Ascii("altheas"),
        &[(0b10001, &ENTRY_ALTHEAS_841278574081921149)],
    ),
    (
        crate::EncodedStr::Ascii("althein"),
        &[(0b00001, &ENTRY_ALTHEIN_11491174847546175682)],
    ),
    (
        crate::EncodedStr::Ascii("altho"),
        &[(0b00001, &ENTRY_ALTHOUGH_9541446420672118730)],
    ),
    (
        crate::EncodedStr::Ascii("aluminisation"),
        &[(0b10010, &ENTRY_ALUMINIZATION_18425035090862987036)],
    ),
    (
        crate::EncodedStr::Ascii("aluminise"),
        &[(0b10010, &ENTRY_ALUMINIZE_15056197197529932132)],
    ),
    (
        crate::EncodedStr::Ascii("aluminised"),
        &[(0b10010, &ENTRY_ALUMINIZED_10495213790591424683)],
    ),
    (
        crate::EncodedStr::Ascii("aluminises"),
        &[(0b10010, &ENTRY_ALUMINIZES_13441975977760937538)],
    ),
    (
        crate::EncodedStr::Ascii("aluminising"),
        &[(0b10010, &ENTRY_ALUMINIZING_12430331523650185895)],
    ),
    (
        crate::EncodedStr::Ascii("aluminium"),
        &[(0b10010, &ENTRY_ALUMINUM_12230548845456538965)],
    ),
    (
        crate::EncodedStr::Ascii("aluminiums"),
        &[(0b10010, &ENTRY_ALUMINUMS_235477509529996640)],
    ),
    (
        crate::EncodedStr::Ascii("aluminization"),
        &[(0b01001, &ENTRY_ALUMINIZATION_18425035090862987036)],
    ),
    (
        crate::EncodedStr::Ascii("aluminize"),
        &[(0b01001, &ENTRY_ALUMINIZE_15056197197529932132)],
    ),
    (
        crate::EncodedStr::Ascii("aluminized"),
        &[(0b01001, &ENTRY_ALUMINIZED_10495213790591424683)],
    ),
    (
        crate::EncodedStr::Ascii("aluminizes"),
        &[(0b01001, &ENTRY_ALUMINIZES_13441975977760937538)],
    ),
    (
        crate::EncodedStr::Ascii("aluminizing"),
        &[(0b01001, &ENTRY_ALUMINIZING_12430331523650185895)],
    ),
    (
        crate::EncodedStr::Ascii("aluminum"),
        &[(0b01001, &ENTRY_ALUMINUM_12230548845456538965)],
    ),
    (
        crate::EncodedStr::Ascii("aluminums"),
        &[(0b01001, &ENTRY_ALUMINUMS_235477509529996640)],
    ),
    (
        crate::EncodedStr::Ascii("alveolae"),
        &[(0b11010, &ENTRY_ALVEOLE_16490342143918785702)],
    ),
    (
        crate::EncodedStr::Ascii("alveole"),
        &[(0b00001, &ENTRY_ALVEOLE_16490342143918785702)],
    ),
    (
        crate::EncodedStr::Ascii("amalgamatise"),
        &[(0b10010, &ENTRY_AMALGAMATIZE_7375445972208185230)],
    ),
    (
        crate::EncodedStr::Ascii("amalgamatises"),
        &[(0b10010, &ENTRY_AMALGAMATIZES_11197265529776604273)],
    ),
    (
        crate::EncodedStr::Ascii("amalgamatize"),
        &[(0b01001, &ENTRY_AMALGAMATIZE_7375445972208185230)],
    ),
    (
        crate::EncodedStr::Ascii("amalgamatizes"),
        &[(0b01001, &ENTRY_AMALGAMATIZES_11197265529776604273)],
    ),
    (
        crate::EncodedStr::Ascii("amalgamisation"),
        &[(0b10010, &ENTRY_AMALGAMIZATION_6873838956097053791)],
    ),
    (
        crate::EncodedStr::Ascii("amalgamisations"),
        &[(0b10010, &ENTRY_AMALGAMIZATIONS_11642266614868063418)],
    ),
    (
        crate::EncodedStr::Ascii("amalgamise"),
        &[(0b10010, &ENTRY_AMALGAMIZE_6774540532866713160)],
    ),
    (
        crate::EncodedStr::Ascii("amalgamises"),
        &[(0b10010, &ENTRY_AMALGAMIZES_18246550602932639451)],
    ),
    (
        crate::EncodedStr::Ascii("amalgamization"),
        &[(0b01001, &ENTRY_AMALGAMIZATION_6873838956097053791)],
    ),
    (
        crate::EncodedStr::Ascii("amalgamizations"),
        &[(0b01001, &ENTRY_AMALGAMIZATIONS_11642266614868063418)],
    ),
    (
        crate::EncodedStr::Ascii("amalgamize"),
        &[(0b01001, &ENTRY_AMALGAMIZE_6774540532866713160)],
    ),
    (
        crate::EncodedStr::Ascii("amalgamizes"),
        &[(0b01001, &ENTRY_AMALGAMIZES_18246550602932639451)],
    ),
    (
        crate::EncodedStr::Ascii("amalthaea"),
        &[(0b11010, &ENTRY_AMALTHEA_17903426763265878110)],
    ),
    (
        crate::EncodedStr::Ascii("amalthea"),
        &[(0b00001, &ENTRY_AMALTHEA_17903426763265878110)],
    ),
    (
        crate::EncodedStr::Ascii("ambicolorate"),
        &[(0b00001, &ENTRY_AMBICOLORATE_6721589398342053523)],
    ),
    (
        crate::EncodedStr::Ascii("ambicoloration"),
        &[(0b00001, &ENTRY_AMBICOLORATION_14002894506100288246)],
    ),
    (
        crate::EncodedStr::Ascii("ambicolourate"),
        &[(0b11010, &ENTRY_AMBICOLORATE_6721589398342053523)],
    ),
    (
        crate::EncodedStr::Ascii("ambicolouration"),
        &[(0b11010, &ENTRY_AMBICOLORATION_14002894506100288246)],
    ),
    (
        crate::EncodedStr::Ascii("ambilaevous"),
        &[(0b11010, &ENTRY_AMBILEVOUS_16610037464217485655)],
    ),
    (
        crate::EncodedStr::Ascii("ambilevous"),
        &[(0b00001, &ENTRY_AMBILEVOUS_16610037464217485655)],
    ),
    (
        crate::EncodedStr::Ascii("ameba"),
        &[(0b10001, &ENTRY_AMOEBA_4495880425081872610)],
    ),
    (
        crate::EncodedStr::Ascii("amebae"),
        &[(0b10001, &ENTRY_AMOEBAS_12713021889803788234)],
    ),
    (
        crate::EncodedStr::Ascii("ameban"),
        &[(0b10001, &ENTRY_AMEBAN_5277068494503541064)],
    ),
    (
        crate::EncodedStr::Ascii("amebas"),
        &[(0b10001, &ENTRY_AMOEBAS_12713021889803788234)],
    ),
    (
        crate::EncodedStr::Ascii("amebean"),
        &[(0b10001, &ENTRY_AMEBEAN_1913759118822823378)],
    ),
    (
        crate::EncodedStr::Ascii("amebian"),
        &[(0b10001, &ENTRY_AMEBIAN_4002663444157694529)],
    ),
    (
        crate::EncodedStr::Ascii("amebiases"),
        &[(0b10001, &ENTRY_AMEBIASES_11778219912968682475)],
    ),
    (
        crate::EncodedStr::Ascii("amebiasis"),
        &[(0b10001, &ENTRY_AMEBIASIS_6361517279962028009)],
    ),
    (
        crate::EncodedStr::Ascii("amebic"),
        &[(0b10001, &ENTRY_AMOEBIC_8026378913624369514)],
    ),
    (
        crate::EncodedStr::Ascii("amebicidal"),
        &[(0b10001, &ENTRY_AMEBICIDAL_17077923016456623176)],
    ),
    (
        crate::EncodedStr::Ascii("amebicide"),
        &[(0b10001, &ENTRY_AMEBICIDE_340489975023787457)],
    ),
    (
        crate::EncodedStr::Ascii("amebid"),
        &[(0b10001, &ENTRY_AMEBID_2070455756616987385)],
    ),
    (
        crate::EncodedStr::Ascii("amebiform"),
        &[(0b10001, &ENTRY_AMEBIFORM_7555597990047716880)],
    ),
    (
        crate::EncodedStr::Ascii("amebiosis"),
        &[(0b10001, &ENTRY_AMEBIOSIS_4936567060198771189)],
    ),
    (
        crate::EncodedStr::Ascii("amebocyte"),
        &[(0b10001, &ENTRY_AMEBOCYTE_14677487577192167094)],
    ),
    (
        crate::EncodedStr::Ascii("amebocytes"),
        &[(0b10001, &ENTRY_AMEBOCYTES_6917539757967941181)],
    ),
    (
        crate::EncodedStr::Ascii("ameboid"),
        &[(0b10001, &ENTRY_AMOEBOID_10813571979914678921)],
    ),
    (
        crate::EncodedStr::Ascii("ameboidism"),
        &[(0b10001, &ENTRY_AMEBOIDISM_6330017017844207166)],
    ),
    (
        crate::EncodedStr::Ascii("amebous"),
        &[(0b10001, &ENTRY_AMEBOUS_1006698274831009682)],
    ),
    (
        crate::EncodedStr::Ascii("amebula"),
        &[(0b10001, &ENTRY_AMEBULA_11715705581331080902)],
    ),
    (
        crate::EncodedStr::Ascii("amenorrhea"),
        &[(0b11001, &ENTRY_AMENORRHEA_9430440773940411667)],
    ),
    (
        crate::EncodedStr::Ascii("amenorrheal"),
        &[(0b11001, &ENTRY_AMENORRHEAL_12274073988422822411)],
    ),
    (
        crate::EncodedStr::Ascii("amenorrheas"),
        &[(0b11001, &ENTRY_AMENORRHEAS_3707756389439454986)],
    ),
    (
        crate::EncodedStr::Ascii("amenorrheic"),
        &[(0b11001, &ENTRY_AMENORRHEIC_7520675613225846121)],
    ),
    (
        crate::EncodedStr::Ascii("amenorrhoea"),
        &[(0b11010, &ENTRY_AMENORRHEA_9430440773940411667)],
    ),
    (
        crate::EncodedStr::Ascii("amenorrhoeal"),
        &[(0b11010, &ENTRY_AMENORRHEAL_12274073988422822411)],
    ),
    (
        crate::EncodedStr::Ascii("amenorrhoeas"),
        &[(0b11010, &ENTRY_AMENORRHEAS_3707756389439454986)],
    ),
    (
        crate::EncodedStr::Ascii("amenorrhoeic"),
        &[(0b11010, &ENTRY_AMENORRHEIC_7520675613225846121)],
    ),
    (
        crate::EncodedStr::Ascii("americanisation"),
        &[(0b10010, &ENTRY_AMERICANIZATION_6309260318644804917)],
    ),
    (
        crate::EncodedStr::Ascii("americanisations"),
        &[(0b10010, &ENTRY_AMERICANIZATIONS_9566538544452946630)],
    ),
    (
        crate::EncodedStr::Ascii("americanise"),
        &[(0b10010, &ENTRY_AMERICANIZE_8636777715370127651)],
    ),
    (
        crate::EncodedStr::Ascii("americanised"),
        &[(0b10010, &ENTRY_AMERICANIZED_1906052736648918553)],
    ),
    (
        crate::EncodedStr::Ascii("americaniser"),
        &[(0b10010, &ENTRY_AMERICANIZER_5573339924551090371)],
    ),
    (
        crate::EncodedStr::Ascii("americanisers"),
        &[(0b10010, &ENTRY_AMERICANIZERS_7997596044566128128)],
    ),
    (
        crate::EncodedStr::Ascii("americanises"),
        &[(0b10010, &ENTRY_AMERICANIZES_1895797903602224728)],
    ),
    (
        crate::EncodedStr::Ascii("americanising"),
        &[(0b10010, &ENTRY_AMERICANIZING_15437774827264361694)],
    ),
    (
        crate::EncodedStr::Ascii("americanization"),
        &[(0b01001, &ENTRY_AMERICANIZATION_6309260318644804917)],
    ),
    (
        crate::EncodedStr::Ascii("americanizations"),
        &[(0b01001, &ENTRY_AMERICANIZATIONS_9566538544452946630)],
    ),
    (
        crate::EncodedStr::Ascii("americanize"),
        &[(0b01001, &ENTRY_AMERICANIZE_8636777715370127651)],
    ),
    (
        crate::EncodedStr::Ascii("americanized"),
        &[(0b01001, &ENTRY_AMERICANIZED_1906052736648918553)],
    ),
    (
        crate::EncodedStr::Ascii("americanizer"),
        &[(0b01001, &ENTRY_AMERICANIZER_5573339924551090371)],
    ),
    (
        crate::EncodedStr::Ascii("americanizers"),
        &[(0b01001, &ENTRY_AMERICANIZERS_7997596044566128128)],
    ),
    (
        crate::EncodedStr::Ascii("americanizes"),
        &[(0b01001, &ENTRY_AMERICANIZES_1895797903602224728)],
    ),
    (
        crate::EncodedStr::Ascii("americanizing"),
        &[(0b01001, &ENTRY_AMERICANIZING_15437774827264361694)],
    ),
    (
        crate::EncodedStr::Ascii("ammocete"),
        &[(0b10001, &ENTRY_AMMOCETE_11149092949437835019)],
    ),
    (
        crate::EncodedStr::Ascii("ammocetes"),
        &[(0b10001, &ENTRY_AMMOCETES_15510029871033694789)],
    ),
    (
        crate::EncodedStr::Ascii("ammocoete"),
        &[(0b11010, &ENTRY_AMMOCETE_11149092949437835019)],
    ),
    (
        crate::EncodedStr::Ascii("ammocoetes"),
        &[(0b11010, &ENTRY_AMMOCETES_15510029871033694789)],
    ),
    (
        crate::EncodedStr::Ascii("ammoniaemia"),
        &[(0b11010, &ENTRY_AMMONIEMIA_12378710937857988312)],
    ),
    (
        crate::EncodedStr::Ascii("ammoniemia"),
        &[(0b00001, &ENTRY_AMMONIEMIA_12378710937857988312)],
    ),
    (
        crate::EncodedStr::Ascii("amoeban"),
        &[(0b11010, &ENTRY_AMEBAN_5277068494503541064)],
    ),
    (
        crate::EncodedStr::Ascii("amoebean"),
        &[(0b11010, &ENTRY_AMEBEAN_1913759118822823378)],
    ),
    (
        crate::EncodedStr::Ascii("amoebian"),
        &[(0b11010, &ENTRY_AMEBIAN_4002663444157694529)],
    ),
    (
        crate::EncodedStr::Ascii("amoebiases"),
        &[(0b11010, &ENTRY_AMEBIASES_11778219912968682475)],
    ),
    (
        crate::EncodedStr::Ascii("amoebiasis"),
        &[(0b11010, &ENTRY_AMEBIASIS_6361517279962028009)],
    ),
    (
        crate::EncodedStr::Ascii("amoebicidal"),
        &[(0b11010, &ENTRY_AMEBICIDAL_17077923016456623176)],
    ),
    (
        crate::EncodedStr::Ascii("amoebicide"),
        &[(0b11010, &ENTRY_AMEBICIDE_340489975023787457)],
    ),
    (
        crate::EncodedStr::Ascii("amoebid"),
        &[(0b11010, &ENTRY_AMEBID_2070455756616987385)],
    ),
    (
        crate::EncodedStr::Ascii("amoebiform"),
        &[(0b11010, &ENTRY_AMEBIFORM_7555597990047716880)],
    ),
    (
        crate::EncodedStr::Ascii("amoebiosis"),
        &[(0b11010, &ENTRY_AMEBIOSIS_4936567060198771189)],
    ),
    (
        crate::EncodedStr::Ascii("amoebocyte"),
        &[(0b11010, &ENTRY_AMEBOCYTE_14677487577192167094)],
    ),
    (
        crate::EncodedStr::Ascii("amoebocytes"),
        &[(0b11010, &ENTRY_AMEBOCYTES_6917539757967941181)],
    ),
    (
        crate::EncodedStr::Ascii("amoeboidism"),
        &[(0b11010, &ENTRY_AMEBOIDISM_6330017017844207166)],
    ),
    (
        crate::EncodedStr::Ascii("amoebous"),
        &[(0b11010, &ENTRY_AMEBOUS_1006698274831009682)],
    ),
    (
        crate::EncodedStr::Ascii("amoebula"),
        &[(0b11010, &ENTRY_AMEBULA_11715705581331080902)],
    ),
    (
        crate::EncodedStr::Ascii("amoralise"),
        &[(0b10010, &ENTRY_AMORALIZE_437899974996323138)],
    ),
    (
        crate::EncodedStr::Ascii("amoralises"),
        &[(0b10010, &ENTRY_AMORALIZES_3004553231540605930)],
    ),
    (
        crate::EncodedStr::Ascii("amoralize"),
        &[(0b01001, &ENTRY_AMORALIZE_437899974996323138)],
    ),
    (
        crate::EncodedStr::Ascii("amoralizes"),
        &[(0b01001, &ENTRY_AMORALIZES_3004553231540605930)],
    ),
    (
        crate::EncodedStr::Ascii("amoret"),
        &[(0b00001, &ENTRY_AMORET_11190930336071907365)],
    ),
    (
        crate::EncodedStr::Ascii("amorism"),
        &[(0b00001, &ENTRY_AMORISM_13622053629400049439)],
    ),
    (
        crate::EncodedStr::Ascii("amorisms"),
        &[(0b00001, &ENTRY_AMORISMS_8591683750858003331)],
    ),
    (
        crate::EncodedStr::Ascii("amorist"),
        &[(0b00001, &ENTRY_AMORIST_15615749666067796835)],
    ),
    (
        crate::EncodedStr::Ascii("amoristic"),
        &[(0b00001, &ENTRY_AMORISTIC_9227858452058548163)],
    ),
    (
        crate::EncodedStr::Ascii("amoristics"),
        &[(0b00001, &ENTRY_AMORISTICS_18339349616054530724)],
    ),
    (
        crate::EncodedStr::Ascii("amorists"),
        &[(0b00001, &ENTRY_AMORISTS_6019660879632735851)],
    ),
    (
        crate::EncodedStr::Ascii("amorphisation"),
        &[(0b10010, &ENTRY_AMORPHIZATION_4718410488040839837)],
    ),
    (
        crate::EncodedStr::Ascii("amorphise"),
        &[(0b10010, &ENTRY_AMORPHIZE_15516090808530900584)],
    ),
    (
        crate::EncodedStr::Ascii("amorphization"),
        &[(0b01001, &ENTRY_AMORPHIZATION_4718410488040839837)],
    ),
    (
        crate::EncodedStr::Ascii("amorphize"),
        &[(0b01001, &ENTRY_AMORPHIZE_15516090808530900584)],
    ),
    (
        crate::EncodedStr::Ascii("amortisable"),
        &[(0b10010, &ENTRY_AMORTIZABLE_18025712452516364127)],
    ),
    (
        crate::EncodedStr::Ascii("amortisabler"),
        &[(0b10010, &ENTRY_AMORTIZABLER_8597378575585075865)],
    ),
    (
        crate::EncodedStr::Ascii("amortisables"),
        &[(0b10010, &ENTRY_AMORTIZABLES_10949882004562997724)],
    ),
    (
        crate::EncodedStr::Ascii("amortisablest"),
        &[(0b10010, &ENTRY_AMORTIZABLEST_2628369391782893993)],
    ),
    (
        crate::EncodedStr::Ascii("amortisation"),
        &[(0b10010, &ENTRY_AMORTIZATION_4181880901981206246)],
    ),
    (
        crate::EncodedStr::Ascii("amortisations"),
        &[(0b10010, &ENTRY_AMORTIZATIONS_10667746967250951820)],
    ),
    (
        crate::EncodedStr::Ascii("amortise"),
        &[(0b10010, &ENTRY_AMORTIZE_14941813541869573228)],
    ),
    (
        crate::EncodedStr::Ascii("amortised"),
        &[(0b10010, &ENTRY_AMORTIZED_5774086997820266664)],
    ),
    (
        crate::EncodedStr::Ascii("amortisement"),
        &[(0b10010, &ENTRY_AMORTIZEMENT_12103927078743615024)],
    ),
    (
        crate::EncodedStr::Ascii("amortisements"),
        &[(0b10010, &ENTRY_AMORTIZEMENTS_10400864127697785423)],
    ),
    (
        crate::EncodedStr::Ascii("amortises"),
        &[(0b10010, &ENTRY_AMORTIZES_18292533417191526171)],
    ),
    (
        crate::EncodedStr::Ascii("amortising"),
        &[(0b10010, &ENTRY_AMORTIZING_12733662438547175763)],
    ),
    (
        crate::EncodedStr::Ascii("amortizable"),
        &[(0b01001, &ENTRY_AMORTIZABLE_18025712452516364127)],
    ),
    (
        crate::EncodedStr::Ascii("amortizabler"),
        &[(0b01001, &ENTRY_AMORTIZABLER_8597378575585075865)],
    ),
    (
        crate::EncodedStr::Ascii("amortizables"),
        &[(0b01001, &ENTRY_AMORTIZABLES_10949882004562997724)],
    ),
    (
        crate::EncodedStr::Ascii("amortizablest"),
        &[(0b01001, &ENTRY_AMORTIZABLEST_2628369391782893993)],
    ),
    (
        crate::EncodedStr::Ascii("amortization"),
        &[(0b01001, &ENTRY_AMORTIZATION_4181880901981206246)],
    ),
    (
        crate::EncodedStr::Ascii("amortizations"),
        &[(0b01001, &ENTRY_AMORTIZATIONS_10667746967250951820)],
    ),
    (
        crate::EncodedStr::Ascii("amortize"),
        &[(0b01001, &ENTRY_AMORTIZE_14941813541869573228)],
    ),
    (
        crate::EncodedStr::Ascii("amortized"),
        &[(0b01001, &ENTRY_AMORTIZED_5774086997820266664)],
    ),
    (
        crate::EncodedStr::Ascii("amortizement"),
        &[(0b01001, &ENTRY_AMORTIZEMENT_12103927078743615024)],
    ),
    (
        crate::EncodedStr::Ascii("amortizements"),
        &[(0b01001, &ENTRY_AMORTIZEMENTS_10400864127697785423)],
    ),
    (
        crate::EncodedStr::Ascii("amortizes"),
        &[(0b01001, &ENTRY_AMORTIZES_18292533417191526171)],
    ),
    (
        crate::EncodedStr::Ascii("amortizing"),
        &[(0b01001, &ENTRY_AMORTIZING_12733662438547175763)],
    ),
    (
        crate::EncodedStr::Ascii("amouret"),
        &[(0b11010, &ENTRY_AMORET_11190930336071907365)],
    ),
    (
        crate::EncodedStr::Ascii("amourism"),
        &[(0b11010, &ENTRY_AMORISM_13622053629400049439)],
    ),
    (
        crate::EncodedStr::Ascii("amourisms"),
        &[(0b11010, &ENTRY_AMORISMS_8591683750858003331)],
    ),
    (
        crate::EncodedStr::Ascii("amourist"),
        &[(0b11010, &ENTRY_AMORIST_15615749666067796835)],
    ),
    (
        crate::EncodedStr::Ascii("amouristic"),
        &[(0b11010, &ENTRY_AMORISTIC_9227858452058548163)],
    ),
    (
        crate::EncodedStr::Ascii("amouristics"),
        &[(0b11010, &ENTRY_AMORISTICS_18339349616054530724)],
    ),
    (
        crate::EncodedStr::Ascii("amourists"),
        &[(0b11010, &ENTRY_AMORISTS_6019660879632735851)],
    ),
    (
        crate::EncodedStr::Ascii("amphigaean"),
        &[(0b11010, &ENTRY_AMPHIGEAN_2635547525436752336)],
    ),
    (
        crate::EncodedStr::Ascii("amphigean"),
        &[(0b00001, &ENTRY_AMPHIGEAN_2635547525436752336)],
    ),
    (
        crate::EncodedStr::Ascii("amphitheater"),
        &[(0b01001, &ENTRY_AMPHITHEATER_3688102909787113288)],
    ),
    (
        crate::EncodedStr::Ascii("amphitheaters"),
        &[(0b01001, &ENTRY_AMPHITHEATERS_6166627403689463943)],
    ),
    (
        crate::EncodedStr::Ascii("amphitheatre"),
        &[(0b11010, &ENTRY_AMPHITHEATER_3688102909787113288)],
    ),
    (
        crate::EncodedStr::Ascii("amphitheatres"),
        &[(0b11010, &ENTRY_AMPHITHEATERS_6166627403689463943)],
    ),
    (
        crate::EncodedStr::Ascii("amygdalae"),
        &[(0b11010, &ENTRY_AMYGDALE_9445312936529667739)],
    ),
    (
        crate::EncodedStr::Ascii("amygdale"),
        &[(0b00001, &ENTRY_AMYGDALE_9445312936529667739)],
    ),
    (
        crate::EncodedStr::Ascii("amyxorrhea"),
        &[(0b00001, &ENTRY_AMYXORRHEA_4253893643371161289)],
    ),
    (
        crate::EncodedStr::Ascii("amyxorrhoea"),
        &[(0b11010, &ENTRY_AMYXORRHEA_4253893643371161289)],
    ),
    (
        crate::EncodedStr::Ascii("anabaptise"),
        &[(0b10010, &ENTRY_ANABAPTIZE_2729267296806864066)],
    ),
    (
        crate::EncodedStr::Ascii("anabaptised"),
        &[(0b10010, &ENTRY_ANABAPTIZED_10937015334598797503)],
    ),
    (
        crate::EncodedStr::Ascii("anabaptises"),
        &[(0b10010, &ENTRY_ANABAPTIZES_5845461765970005402)],
    ),
    (
        crate::EncodedStr::Ascii("anabaptising"),
        &[(0b10010, &ENTRY_ANABAPTIZING_3689660901707732301)],
    ),
    (
        crate::EncodedStr::Ascii("anabaptize"),
        &[(0b01001, &ENTRY_ANABAPTIZE_2729267296806864066)],
    ),
    (
        crate::EncodedStr::Ascii("anabaptized"),
        &[(0b01001, &ENTRY_ANABAPTIZED_10937015334598797503)],
    ),
    (
        crate::EncodedStr::Ascii("anabaptizes"),
        &[(0b01001, &ENTRY_ANABAPTIZES_5845461765970005402)],
    ),
    (
        crate::EncodedStr::Ascii("anabaptizing"),
        &[(0b01001, &ENTRY_ANABAPTIZING_3689660901707732301)],
    ),
    (
        crate::EncodedStr::Ascii("anaematosis"),
        &[(0b11010, &ENTRY_ANEMATOSIS_2231831205038246544)],
    ),
    (
        crate::EncodedStr::Ascii("anaemia"),
        &[(0b10010, &ENTRY_ANEMIA_11444125334540196345)],
    ),
    (
        crate::EncodedStr::Ascii("anaemias"),
        &[(0b10010, &ENTRY_ANEMIAS_11793613272534563937)],
    ),
    (
        crate::EncodedStr::Ascii("anaemic"),
        &[(0b10010, &ENTRY_ANEMIC_3144161607917365302)],
    ),
    (
        crate::EncodedStr::Ascii("anaemically"),
        &[(0b10010, &ENTRY_ANEMICALLY_6100474579337104939)],
    ),
    (
        crate::EncodedStr::Ascii("anaemicer"),
        &[(0b10010, &ENTRY_ANEMICER_16024076703657819532)],
    ),
    (
        crate::EncodedStr::Ascii("anaemicest"),
        &[(0b10010, &ENTRY_ANEMICEST_17483472184329322961)],
    ),
    (
        crate::EncodedStr::Ascii("anaemics"),
        &[(0b10010, &ENTRY_ANEMICS_9964370762426059120)],
    ),
    (
        crate::EncodedStr::Ascii("anaeretic"),
        &[(0b11010, &ENTRY_ANERETIC_6982175402554498005)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthesia"),
        &[(0b11010, &ENTRY_ANESTHESIA_9822581388335098553)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthesiant"),
        &[(0b11010, &ENTRY_ANESTHESIANT_15565352975099719303)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthesias"),
        &[(0b11010, &ENTRY_ANESTHESIAS_9838908694750944673)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthesiologies"),
        &[(0b10010, &ENTRY_ANESTHESIOLOGIES_6679603096569359713)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthesiologist"),
        &[(0b10010, &ENTRY_ANESTHESIOLOGIST_15509935416057002830)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthesiologists"),
        &[(0b10010, &ENTRY_ANESTHESIOLOGISTS_5770405695630095861)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthesiology"),
        &[(0b10010, &ENTRY_ANESTHESIOLOGY_1255532677711876584)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthesis"),
        &[(0b10010, &ENTRY_ANESTHESIS_3798568430045477742)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetic"),
        &[(0b11010, &ENTRY_ANESTHETIC_7346810397925011981)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetically"),
        &[(0b11010, &ENTRY_ANESTHETICALLY_17611597914394933738)],
    ),
    (
        crate::EncodedStr::Ascii("anaestheticer"),
        &[(0b11010, &ENTRY_ANESTHETICER_1712235669739749819)],
    ),
    (
        crate::EncodedStr::Ascii("anaestheticest"),
        &[(0b11010, &ENTRY_ANESTHETICEST_13273804515231488648)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetics"),
        &[(0b11010, &ENTRY_ANESTHETICS_9673867241310151800)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetisation"),
        &[(0b10010, &ENTRY_ANESTHETIZATION_11701429006232412151)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetisations"),
        &[(0b10010, &ENTRY_ANESTHETIZATIONS_10494265552871488873)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetise"),
        &[(0b10010, &ENTRY_ANESTHETIZE_9242516368594572411)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetised"),
        &[(0b10010, &ENTRY_ANESTHETIZED_10115321731074208256)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetiser"),
        &[(0b10010, &ENTRY_ANESTHETIZER_5418733284803121475)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetisers"),
        &[(0b10010, &ENTRY_ANESTHETIZERS_17863131477627405979)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetises"),
        &[(0b10010, &ENTRY_ANESTHETIZES_6149697878942963698)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetising"),
        &[(0b10010, &ENTRY_ANESTHETIZING_15816199569084558224)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetist"),
        &[(0b11010, &ENTRY_ANESTHETIST_10778880823396904501)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetists"),
        &[(0b11010, &ENTRY_ANESTHETISTS_8741608628280855523)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetization"),
        &[(0b01000, &ENTRY_ANESTHETIZATION_11701429006232412151)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetizations"),
        &[(0b01000, &ENTRY_ANESTHETIZATIONS_10494265552871488873)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetize"),
        &[(0b01000, &ENTRY_ANESTHETIZE_9242516368594572411)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetized"),
        &[(0b01000, &ENTRY_ANESTHETIZED_10115321731074208256)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetizer"),
        &[(0b01000, &ENTRY_ANESTHETIZER_5418733284803121475)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetizers"),
        &[(0b01000, &ENTRY_ANESTHETIZERS_17863131477627405979)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetizes"),
        &[(0b01000, &ENTRY_ANESTHETIZES_6149697878942963698)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthetizing"),
        &[(0b01000, &ENTRY_ANESTHETIZING_15816199569084558224)],
    ),
    (
        crate::EncodedStr::Ascii("anaesthyl"),
        &[(0b11010, &ENTRY_ANESTHYL_8174332230955659903)],
    ),
    (
        crate::EncodedStr::Ascii("anaetiological"),
        &[(0b11010, &ENTRY_ANETIOLOGICAL_10165110800520199298)],
    ),
    (
        crate::EncodedStr::Ascii("anagrammatise"),
        &[(0b10010, &ENTRY_ANAGRAMMATIZE_1294531725794717084)],
    ),
    (
        crate::EncodedStr::Ascii("anagrammatised"),
        &[(0b10010, &ENTRY_ANAGRAMMATIZED_17231243584520853895)],
    ),
    (
        crate::EncodedStr::Ascii("anagrammatises"),
        &[(0b10010, &ENTRY_ANAGRAMMATIZES_13203766080338850548)],
    ),
    (
        crate::EncodedStr::Ascii("anagrammatising"),
        &[(0b10010, &ENTRY_ANAGRAMMATIZING_7360812298529172732)],
    ),
    (
        crate::EncodedStr::Ascii("anagrammatize"),
        &[(0b01001, &ENTRY_ANAGRAMMATIZE_1294531725794717084)],
    ),
    (
        crate::EncodedStr::Ascii("anagrammatized"),
        &[(0b01001, &ENTRY_ANAGRAMMATIZED_17231243584520853895)],
    ),
    (
        crate::EncodedStr::Ascii("anagrammatizes"),
        &[(0b01001, &ENTRY_ANAGRAMMATIZES_13203766080338850548)],
    ),
    (
        crate::EncodedStr::Ascii("anagrammatizing"),
        &[(0b01001, &ENTRY_ANAGRAMMATIZING_7360812298529172732)],
    ),
    (
        crate::EncodedStr::Ascii("analogise"),
        &[(0b10010, &ENTRY_ANALOGIZE_5536035389372667946)],
    ),
    (
        crate::EncodedStr::Ascii("analogised"),
        &[(0b10010, &ENTRY_ANALOGIZED_15332378387951220039)],
    ),
    (
        crate::EncodedStr::Ascii("analogises"),
        &[(0b10010, &ENTRY_ANALOGIZES_2435391307518285611)],
    ),
    (
        crate::EncodedStr::Ascii("analogising"),
        &[(0b10010, &ENTRY_ANALOGIZING_5193184992170428572)],
    ),
    (
        crate::EncodedStr::Ascii("analogize"),
        &[(0b01001, &ENTRY_ANALOGIZE_5536035389372667946)],
    ),
    (
        crate::EncodedStr::Ascii("analogized"),
        &[(0b01001, &ENTRY_ANALOGIZED_15332378387951220039)],
    ),
    (
        crate::EncodedStr::Ascii("analogizes"),
        &[(0b01001, &ENTRY_ANALOGIZES_2435391307518285611)],
    ),
    (
        crate::EncodedStr::Ascii("analogizing"),
        &[(0b01001, &ENTRY_ANALOGIZING_5193184992170428572)],
    ),
    (
        crate::EncodedStr::Ascii("analysability"),
        &[(0b10010, &ENTRY_ANALYZABILITY_1551141386065817504)],
    ),
    (
        crate::EncodedStr::Ascii("analysable"),
        &[(0b10010, &ENTRY_ANALYZABLE_617037050560332150)],
    ),
    (
        crate::EncodedStr::Ascii("analysabler"),
        &[(0b10010, &ENTRY_ANALYZABLER_17997925440256942572)],
    ),
    (
        crate::EncodedStr::Ascii("analysablest"),
        &[(0b10010, &ENTRY_ANALYZABLEST_8874109193021320157)],
    ),
    (
        crate::EncodedStr::Ascii("analysation"),
        &[(0b10010, &ENTRY_ANALYZATION_15073164819277453463)],
    ),
    (
        crate::EncodedStr::Ascii("analysations"),
        &[(0b10010, &ENTRY_ANALYZATIONS_10325231710634833644)],
    ),
    (
        crate::EncodedStr::Ascii("analyse"),
        &[(0b11010, &ENTRY_ANALYZE_13435707901024257028)],
    ),
    (
        crate::EncodedStr::Ascii("analysed"),
        &[(0b11010, &ENTRY_ANALYZED_3241611515791740784)],
    ),
    (
        crate::EncodedStr::Ascii("analyser"),
        &[(0b10010, &ENTRY_ANALYZER_13687050517411638821)],
    ),
    (
        crate::EncodedStr::Ascii("analysers"),
        &[(0b10010, &ENTRY_ANALYZERS_7884682095017825661)],
    ),
    (
        crate::EncodedStr::Ascii("analysing"),
        &[(0b11010, &ENTRY_ANALYZING_17972193862022825096)],
    ),
    (
        crate::EncodedStr::Ascii("analyzability"),
        &[(0b01001, &ENTRY_ANALYZABILITY_1551141386065817504)],
    ),
    (
        crate::EncodedStr::Ascii("analyzable"),
        &[(0b01001, &ENTRY_ANALYZABLE_617037050560332150)],
    ),
    (
        crate::EncodedStr::Ascii("analyzabler"),
        &[(0b01001, &ENTRY_ANALYZABLER_17997925440256942572)],
    ),
    (
        crate::EncodedStr::Ascii("analyzablest"),
        &[(0b01001, &ENTRY_ANALYZABLEST_8874109193021320157)],
    ),
    (
        crate::EncodedStr::Ascii("analyzation"),
        &[(0b01001, &ENTRY_ANALYZATION_15073164819277453463)],
    ),
    (
        crate::EncodedStr::Ascii("analyzations"),
        &[(0b01001, &ENTRY_ANALYZATIONS_10325231710634833644)],
    ),
    (
        crate::EncodedStr::Ascii("analyze"),
        &[(0b01001, &ENTRY_ANALYZE_13435707901024257028)],
    ),
    (
        crate::EncodedStr::Ascii("analyzed"),
        &[(0b01001, &ENTRY_ANALYZED_3241611515791740784)],
    ),
    (
        crate::EncodedStr::Ascii("analyzer"),
        &[(0b01001, &ENTRY_ANALYZER_13687050517411638821)],
    ),
    (
        crate::EncodedStr::Ascii("analyzers"),
        &[(0b01001, &ENTRY_ANALYZERS_7884682095017825661)],
    ),
    (
        crate::EncodedStr::Ascii("analyzes"),
        &[(0b01001, &ENTRY_ANALYZES_13473182794044934522)],
    ),
    (
        crate::EncodedStr::Ascii("analyzing"),
        &[(0b01001, &ENTRY_ANALYZING_17972193862022825096)],
    ),
    (
        crate::EncodedStr::Ascii("anapaestically"),
        &[(0b11010, &ENTRY_ANAPESTICALLY_15963069963215922817)],
    ),
    (
        crate::EncodedStr::Ascii("anapestically"),
        &[(0b00001, &ENTRY_ANAPESTICALLY_15963069963215922817)],
    ),
    (
        crate::EncodedStr::Ascii("anapneic"),
        &[(0b00001, &ENTRY_ANAPNEIC_9824624761463965547)],
    ),
    (
        crate::EncodedStr::Ascii("anapnoeic"),
        &[(0b11010, &ENTRY_ANAPNEIC_9824624761463965547)],
    ),
    (
        crate::EncodedStr::Ascii("anarchise"),
        &[(0b10010, &ENTRY_ANARCHIZE_16873413817474048843)],
    ),
    (
        crate::EncodedStr::Ascii("anarchised"),
        &[(0b10010, &ENTRY_ANARCHIZED_13521160029536762262)],
    ),
    (
        crate::EncodedStr::Ascii("anarchises"),
        &[(0b10010, &ENTRY_ANARCHIZES_2426137200100120755)],
    ),
    (
        crate::EncodedStr::Ascii("anarchising"),
        &[(0b10010, &ENTRY_ANARCHIZING_11629066219610630589)],
    ),
    (
        crate::EncodedStr::Ascii("anarchize"),
        &[(0b01001, &ENTRY_ANARCHIZE_16873413817474048843)],
    ),
    (
        crate::EncodedStr::Ascii("anarchized"),
        &[(0b01001, &ENTRY_ANARCHIZED_13521160029536762262)],
    ),
    (
        crate::EncodedStr::Ascii("anarchizes"),
        &[(0b01001, &ENTRY_ANARCHIZES_2426137200100120755)],
    ),
    (
        crate::EncodedStr::Ascii("anarchizing"),
        &[(0b01001, &ENTRY_ANARCHIZING_11629066219610630589)],
    ),
    (
        crate::EncodedStr::Ascii("anathematisation"),
        &[(0b10010, &ENTRY_ANATHEMATIZATION_15280298908583722308)],
    ),
    (
        crate::EncodedStr::Ascii("anathematisations"),
        &[(0b10010, &ENTRY_ANATHEMATIZATIONS_620207996168887075)],
    ),
    (
        crate::EncodedStr::Ascii("anathematise"),
        &[(0b10010, &ENTRY_ANATHEMATIZE_9250331648604756093)],
    ),
    (
        crate::EncodedStr::Ascii("anathematised"),
        &[(0b10010, &ENTRY_ANATHEMATIZED_3874188261925704186)],
    ),
    (
        crate::EncodedStr::Ascii("anathematiser"),
        &[(0b10010, &ENTRY_ANATHEMATIZER_3378013434055917757)],
    ),
    (
        crate::EncodedStr::Ascii("anathematises"),
        &[(0b10010, &ENTRY_ANATHEMATIZES_8973479734940337633)],
    ),
    (
        crate::EncodedStr::Ascii("anathematising"),
        &[(0b10010, &ENTRY_ANATHEMATIZING_10299965854697438675)],
    ),
    (
        crate::EncodedStr::Ascii("anathematization"),
        &[(0b01001, &ENTRY_ANATHEMATIZATION_15280298908583722308)],
    ),
    (
        crate::EncodedStr::Ascii("anathematizations"),
        &[(0b01001, &ENTRY_ANATHEMATIZATIONS_620207996168887075)],
    ),
    (
        crate::EncodedStr::Ascii("anathematize"),
        &[(0b01001, &ENTRY_ANATHEMATIZE_9250331648604756093)],
    ),
    (
        crate::EncodedStr::Ascii("anathematized"),
        &[(0b01001, &ENTRY_ANATHEMATIZED_3874188261925704186)],
    ),
    (
        crate::EncodedStr::Ascii("anathematizer"),
        &[(0b01001, &ENTRY_ANATHEMATIZER_3378013434055917757)],
    ),
    (
        crate::EncodedStr::Ascii("anathematizes"),
        &[(0b01001, &ENTRY_ANATHEMATIZES_8973479734940337633)],
    ),
    (
        crate::EncodedStr::Ascii("anathematizing"),
        &[(0b01001, &ENTRY_ANATHEMATIZING_10299965854697438675)],
    ),
    (
        crate::EncodedStr::Ascii("anatomisable"),
        &[(0b10010, &ENTRY_ANATOMIZABLE_6218592416722946394)],
    ),
    (
        crate::EncodedStr::Ascii("anatomisation"),
        &[(0b10010, &ENTRY_ANATOMIZATION_4269547902777954197)],
    ),
    (
        crate::EncodedStr::Ascii("anatomise"),
        &[(0b10010, &ENTRY_ANATOMIZE_841129889860317661)],
    ),
    (
        crate::EncodedStr::Ascii("anatomised"),
        &[(0b10010, &ENTRY_ANATOMIZED_862561253191916873)],
    ),
    (
        crate::EncodedStr::Ascii("anatomiser"),
        &[(0b10010, &ENTRY_ANATOMIZER_10181303822973702398)],
    ),
    (
        crate::EncodedStr::Ascii("anatomises"),
        &[(0b10010, &ENTRY_ANATOMIZES_6453710897733584587)],
    ),
    (
        crate::EncodedStr::Ascii("anatomising"),
        &[(0b10010, &ENTRY_ANATOMIZING_14431856406330078710)],
    ),
    (
        crate::EncodedStr::Ascii("anatomizable"),
        &[(0b01001, &ENTRY_ANATOMIZABLE_6218592416722946394)],
    ),
    (
        crate::EncodedStr::Ascii("anatomization"),
        &[(0b01001, &ENTRY_ANATOMIZATION_4269547902777954197)],
    ),
    (
        crate::EncodedStr::Ascii("anatomize"),
        &[(0b01001, &ENTRY_ANATOMIZE_841129889860317661)],
    ),
    (
        crate::EncodedStr::Ascii("anatomized"),
        &[(0b01001, &ENTRY_ANATOMIZED_862561253191916873)],
    ),
    (
        crate::EncodedStr::Ascii("anatomizer"),
        &[(0b01001, &ENTRY_ANATOMIZER_10181303822973702398)],
    ),
    (
        crate::EncodedStr::Ascii("anatomizes"),
        &[(0b01001, &ENTRY_ANATOMIZES_6453710897733584587)],
    ),
    (
        crate::EncodedStr::Ascii("anatomizing"),
        &[(0b01001, &ENTRY_ANATOMIZING_14431856406330078710)],
    ),
    (
        crate::EncodedStr::Ascii("anchinoae"),
        &[(0b11010, &ENTRY_ANCHINOE_163304748892282636)],
    ),
    (
        crate::EncodedStr::Ascii("anchinoe"),
        &[(0b00001, &ENTRY_ANCHINOE_163304748892282636)],
    ),
    (
        crate::EncodedStr::Ascii("ancillae"),
        &[(0b11010, &ENTRY_ANCILLE_15818318021107678161)],
    ),
    (
        crate::EncodedStr::Ascii("ancille"),
        &[(0b00001, &ENTRY_ANCILLE_15818318021107678161)],
    ),
    (
        crate::EncodedStr::Ascii("anematosis"),
        &[(0b00001, &ENTRY_ANEMATOSIS_2231831205038246544)],
    ),
    (
        crate::EncodedStr::Ascii("anemia"),
        &[(0b11001, &ENTRY_ANEMIA_11444125334540196345)],
    ),
    (
        crate::EncodedStr::Ascii("anemias"),
        &[(0b11001, &ENTRY_ANEMIAS_11793613272534563937)],
    ),
    (
        crate::EncodedStr::Ascii("anemic"),
        &[(0b11001, &ENTRY_ANEMIC_3144161607917365302)],
    ),
    (
        crate::EncodedStr::Ascii("anemically"),
        &[(0b11001, &ENTRY_ANEMICALLY_6100474579337104939)],
    ),
    (
        crate::EncodedStr::Ascii("anemicer"),
        &[(0b11001, &ENTRY_ANEMICER_16024076703657819532)],
    ),
    (
        crate::EncodedStr::Ascii("anemicest"),
        &[(0b11001, &ENTRY_ANEMICEST_17483472184329322961)],
    ),
    (
        crate::EncodedStr::Ascii("anemics"),
        &[(0b11001, &ENTRY_ANEMICS_9964370762426059120)],
    ),
    (
        crate::EncodedStr::Ascii("aneretic"),
        &[(0b00001, &ENTRY_ANERETIC_6982175402554498005)],
    ),
    (
        crate::EncodedStr::Ascii("anesis"),
        &[(0b00001, &ENTRY_ANESIS_16817046064174279211)],
    ),
    (
        crate::EncodedStr::Ascii("anesthesia"),
        &[(0b11001, &ENTRY_ANESTHESIA_9822581388335098553)],
    ),
    (
        crate::EncodedStr::Ascii("anesthesiant"),
        &[(0b11001, &ENTRY_ANESTHESIANT_15565352975099719303)],
    ),
    (
        crate::EncodedStr::Ascii("anesthesias"),
        &[(0b11001, &ENTRY_ANESTHESIAS_9838908694750944673)],
    ),
    (
        crate::EncodedStr::Ascii("anesthesiologies"),
        &[(0b11001, &ENTRY_ANESTHESIOLOGIES_6679603096569359713)],
    ),
    (
        crate::EncodedStr::Ascii("anesthesiologist"),
        &[(0b11001, &ENTRY_ANESTHESIOLOGIST_15509935416057002830)],
    ),
    (
        crate::EncodedStr::Ascii("anesthesiologists"),
        &[(0b11001, &ENTRY_ANESTHESIOLOGISTS_5770405695630095861)],
    ),
    (
        crate::EncodedStr::Ascii("anesthesiology"),
        &[(0b11001, &ENTRY_ANESTHESIOLOGY_1255532677711876584)],
    ),
    (
        crate::EncodedStr::Ascii("anesthesis"),
        &[(0b11001, &ENTRY_ANESTHESIS_3798568430045477742)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetic"),
        &[(0b11001, &ENTRY_ANESTHETIC_7346810397925011981)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetically"),
        &[(0b11001, &ENTRY_ANESTHETICALLY_17611597914394933738)],
    ),
    (
        crate::EncodedStr::Ascii("anestheticer"),
        &[(0b11001, &ENTRY_ANESTHETICER_1712235669739749819)],
    ),
    (
        crate::EncodedStr::Ascii("anestheticest"),
        &[(0b11001, &ENTRY_ANESTHETICEST_13273804515231488648)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetics"),
        &[(0b11001, &ENTRY_ANESTHETICS_9673867241310151800)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetisation"),
        &[
            (0b10000, &ENTRY_ANESTHETIZATIONS_10494265552871488873),
            (0b10000, &ENTRY_ANESTHETIZATION_11701429006232412151),
        ],
    ),
    (
        crate::EncodedStr::Ascii("anesthetise"),
        &[(0b10000, &ENTRY_ANESTHETIZE_9242516368594572411)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetised"),
        &[(0b10000, &ENTRY_ANESTHETIZED_10115321731074208256)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetiser"),
        &[(0b10000, &ENTRY_ANESTHETIZER_5418733284803121475)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetisers"),
        &[(0b10000, &ENTRY_ANESTHETIZERS_17863131477627405979)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetises"),
        &[(0b10000, &ENTRY_ANESTHETIZES_6149697878942963698)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetising"),
        &[(0b10000, &ENTRY_ANESTHETIZING_15816199569084558224)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetist"),
        &[(0b11001, &ENTRY_ANESTHETIST_10778880823396904501)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetists"),
        &[(0b11001, &ENTRY_ANESTHETISTS_8741608628280855523)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetization"),
        &[(0b00001, &ENTRY_ANESTHETIZATION_11701429006232412151)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetizations"),
        &[(0b00001, &ENTRY_ANESTHETIZATIONS_10494265552871488873)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetize"),
        &[(0b01001, &ENTRY_ANESTHETIZE_9242516368594572411)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetized"),
        &[(0b01001, &ENTRY_ANESTHETIZED_10115321731074208256)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetizer"),
        &[(0b00001, &ENTRY_ANESTHETIZER_5418733284803121475)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetizers"),
        &[(0b00001, &ENTRY_ANESTHETIZERS_17863131477627405979)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetizes"),
        &[(0b01001, &ENTRY_ANESTHETIZES_6149697878942963698)],
    ),
    (
        crate::EncodedStr::Ascii("anesthetizing"),
        &[(0b01001, &ENTRY_ANESTHETIZING_15816199569084558224)],
    ),
    (
        crate::EncodedStr::Ascii("anesthyl"),
        &[(0b00001, &ENTRY_ANESTHYL_8174332230955659903)],
    ),
    (
        crate::EncodedStr::Ascii("anestra"),
        &[(0b10001, &ENTRY_ANESTRA_3216556063016372977)],
    ),
    (
        crate::EncodedStr::Ascii("anestri"),
        &[(0b10001, &ENTRY_ANESTRI_8008769930372220485)],
    ),
    (
        crate::EncodedStr::Ascii("anestrous"),
        &[(0b10001, &ENTRY_ANESTROUS_9129522172283593493)],
    ),
    (
        crate::EncodedStr::Ascii("anestrum"),
        &[(0b10001, &ENTRY_ANESTRUM_11523934029574851144)],
    ),
    (
        crate::EncodedStr::Ascii("anestrus"),
        &[(0b10001, &ENTRY_ANESTRUS_9353558396235507225)],
    ),
    (
        crate::EncodedStr::Ascii("anestruses"),
        &[(0b10001, &ENTRY_ANESTRUSES_8824267452405407476)],
    ),
    (
        crate::EncodedStr::Ascii("anetic"),
        &[(0b10001, &ENTRY_ANETIC_9540754510599321451)],
    ),
    (
        crate::EncodedStr::Ascii("anetiological"),
        &[(0b10001, &ENTRY_ANETIOLOGICAL_10165110800520199298)],
    ),
    (
        crate::EncodedStr::Ascii("angelicise"),
        &[(0b10010, &ENTRY_ANGELICIZE_12868295367561294619)],
    ),
    (
        crate::EncodedStr::Ascii("angelicises"),
        &[(0b10010, &ENTRY_ANGELICIZES_1637579071183202501)],
    ),
    (
        crate::EncodedStr::Ascii("angelicize"),
        &[(0b01001, &ENTRY_ANGELICIZE_12868295367561294619)],
    ),
    (
        crate::EncodedStr::Ascii("angelicizes"),
        &[(0b01001, &ENTRY_ANGELICIZES_1637579071183202501)],
    ),
    (
        crate::EncodedStr::Ascii("angelise"),
        &[(0b10010, &ENTRY_ANGELIZE_3309439384866912750)],
    ),
    (
        crate::EncodedStr::Ascii("angelises"),
        &[(0b10010, &ENTRY_ANGELIZES_11526151045543007463)],
    ),
    (
        crate::EncodedStr::Ascii("angelize"),
        &[(0b01001, &ENTRY_ANGELIZE_3309439384866912750)],
    ),
    (
        crate::EncodedStr::Ascii("angelizes"),
        &[(0b01001, &ENTRY_ANGELIZES_11526151045543007463)],
    ),
    (
        crate::EncodedStr::Ascii("anglicanise"),
        &[(0b10010, &ENTRY_ANGLICANIZE_6589690597387603909)],
    ),
    (
        crate::EncodedStr::Ascii("anglicanises"),
        &[(0b10010, &ENTRY_ANGLICANIZES_16783014059494751778)],
    ),
    (
        crate::EncodedStr::Ascii("anglicanize"),
        &[(0b01001, &ENTRY_ANGLICANIZE_6589690597387603909)],
    ),
    (
        crate::EncodedStr::Ascii("anglicanizes"),
        &[(0b01001, &ENTRY_ANGLICANIZES_16783014059494751778)],
    ),
    (
        crate::EncodedStr::Ascii("anglicisation"),
        &[(0b10010, &ENTRY_ANGLICIZATION_15673594215730164653)],
    ),
    (
        crate::EncodedStr::Ascii("anglicisations"),
        &[(0b10010, &ENTRY_ANGLICIZATIONS_18401409530730050577)],
    ),
    (
        crate::EncodedStr::Ascii("anglicise"),
        &[(0b10010, &ENTRY_ANGLICIZE_3954997619999275868)],
    ),
    (
        crate::EncodedStr::Ascii("anglicised"),
        &[(0b10010, &ENTRY_ANGLICIZED_926209429237587197)],
    ),
    (
        crate::EncodedStr::Ascii("anglicises"),
        &[(0b10010, &ENTRY_ANGLICIZES_17586920051951268985)],
    ),
    (
        crate::EncodedStr::Ascii("anglicising"),
        &[(0b10010, &ENTRY_ANGLICIZING_9709864366695655479)],
    ),
    (
        crate::EncodedStr::Ascii("anglicization"),
        &[(0b01001, &ENTRY_ANGLICIZATION_15673594215730164653)],
    ),
    (
        crate::EncodedStr::Ascii("anglicizations"),
        &[(0b01001, &ENTRY_ANGLICIZATIONS_18401409530730050577)],
    ),
    (
        crate::EncodedStr::Ascii("anglicize"),
        &[(0b01001, &ENTRY_ANGLICIZE_3954997619999275868)],
    ),
    (
        crate::EncodedStr::Ascii("anglicized"),
        &[(0b01001, &ENTRY_ANGLICIZED_926209429237587197)],
    ),
    (
        crate::EncodedStr::Ascii("anglicizes"),
        &[(0b01001, &ENTRY_ANGLICIZES_17586920051951268985)],
    ),
    (
        crate::EncodedStr::Ascii("anglicizing"),
        &[(0b01001, &ENTRY_ANGLICIZING_9709864366695655479)],
    ),
    (
        crate::EncodedStr::Ascii("angraecum"),
        &[(0b11010, &ENTRY_ANGRECUM_15932729819544960039)],
    ),
    (
        crate::EncodedStr::Ascii("angrecum"),
        &[(0b00001, &ENTRY_ANGRECUM_15932729819544960039)],
    ),
    (
        crate::EncodedStr::Ascii("angularisation"),
        &[(0b10010, &ENTRY_ANGULARIZATION_15472457872184311028)],
    ),
    (
        crate::EncodedStr::Ascii("angularisations"),
        &[(0b10010, &ENTRY_ANGULARIZATIONS_11452719329473280471)],
    ),
    (
        crate::EncodedStr::Ascii("angularise"),
        &[(0b10010, &ENTRY_ANGULARIZE_12397633129669042330)],
    ),
    (
        crate::EncodedStr::Ascii("angularises"),
        &[(0b10010, &ENTRY_ANGULARIZES_5024097194073065261)],
    ),
    (
        crate::EncodedStr::Ascii("angularization"),
        &[(0b01001, &ENTRY_ANGULARIZATION_15472457872184311028)],
    ),
    (
        crate::EncodedStr::Ascii("angularizations"),
        &[(0b01001, &ENTRY_ANGULARIZATIONS_11452719329473280471)],
    ),
    (
        crate::EncodedStr::Ascii("angularize"),
        &[(0b01001, &ENTRY_ANGULARIZE_12397633129669042330)],
    ),
    (
        crate::EncodedStr::Ascii("angularizes"),
        &[(0b01001, &ENTRY_ANGULARIZES_5024097194073065261)],
    ),
    (
        crate::EncodedStr::Ascii("anhaematopoiesis"),
        &[(0b11010, &ENTRY_ANHEMATOPOIESIS_17033044080627588200)],
    ),
    (
        crate::EncodedStr::Ascii("anhaematosis"),
        &[(0b11010, &ENTRY_ANHEMATOSIS_1202870001006935602)],
    ),
    (
        crate::EncodedStr::Ascii("anhaemolytic"),
        &[(0b11010, &ENTRY_ANHEMOLYTIC_16692415296726473453)],
    ),
    (
        crate::EncodedStr::Ascii("anhematopoiesis"),
        &[(0b10001, &ENTRY_ANHEMATOPOIESIS_17033044080627588200)],
    ),
    (
        crate::EncodedStr::Ascii("anhematosis"),
        &[(0b10001, &ENTRY_ANHEMATOSIS_1202870001006935602)],
    ),
    (
        crate::EncodedStr::Ascii("anhemolytic"),
        &[(0b10001, &ENTRY_ANHEMOLYTIC_16692415296726473453)],
    ),
    (
        crate::EncodedStr::Ascii("anhydraemia"),
        &[(0b11010, &ENTRY_ANHYDREMIA_6316263310895692445)],
    ),
    (
        crate::EncodedStr::Ascii("anhydraemic"),
        &[(0b11010, &ENTRY_ANHYDREMIC_15977830070786776453)],
    ),
    (
        crate::EncodedStr::Ascii("anhydremia"),
        &[(0b10001, &ENTRY_ANHYDREMIA_6316263310895692445)],
    ),
    (
        crate::EncodedStr::Ascii("anhydremic"),
        &[(0b10001, &ENTRY_ANHYDREMIC_15977830070786776453)],
    ),
    (
        crate::EncodedStr::Ascii("anhydridisation"),
        &[(0b10010, &ENTRY_ANHYDRIDIZATION_5779486140945991167)],
    ),
    (
        crate::EncodedStr::Ascii("anhydridisations"),
        &[(0b10010, &ENTRY_ANHYDRIDIZATIONS_6600161284303257781)],
    ),
    (
        crate::EncodedStr::Ascii("anhydridise"),
        &[(0b10010, &ENTRY_ANHYDRIDIZE_15475133187948388972)],
    ),
    (
        crate::EncodedStr::Ascii("anhydridises"),
        &[(0b10010, &ENTRY_ANHYDRIDIZES_14731666580950863474)],
    ),
    (
        crate::EncodedStr::Ascii("anhydridization"),
        &[(0b01001, &ENTRY_ANHYDRIDIZATION_5779486140945991167)],
    ),
    (
        crate::EncodedStr::Ascii("anhydridizations"),
        &[(0b01001, &ENTRY_ANHYDRIDIZATIONS_6600161284303257781)],
    ),
    (
        crate::EncodedStr::Ascii("anhydridize"),
        &[(0b01001, &ENTRY_ANHYDRIDIZE_15475133187948388972)],
    ),
    (
        crate::EncodedStr::Ascii("anhydridizes"),
        &[(0b01001, &ENTRY_ANHYDRIDIZES_14731666580950863474)],
    ),
    (
        crate::EncodedStr::Ascii("animalisation"),
        &[(0b10010, &ENTRY_ANIMALIZATION_13800839490330789274)],
    ),
    (
        crate::EncodedStr::Ascii("animalisations"),
        &[(0b10010, &ENTRY_ANIMALIZATIONS_9150262297922812039)],
    ),
    (
        crate::EncodedStr::Ascii("animalise"),
        &[(0b10010, &ENTRY_ANIMALIZE_10795005523464430843)],
    ),
    (
        crate::EncodedStr::Ascii("animalised"),
        &[(0b10010, &ENTRY_ANIMALIZED_14858832182572412268)],
    ),
    (
        crate::EncodedStr::Ascii("animalises"),
        &[(0b10010, &ENTRY_ANIMALIZES_10069318372695209095)],
    ),
    (
        crate::EncodedStr::Ascii("animalising"),
        &[(0b10010, &ENTRY_ANIMALIZING_14729872040352851901)],
    ),
    (
        crate::EncodedStr::Ascii("animalization"),
        &[(0b01001, &ENTRY_ANIMALIZATION_13800839490330789274)],
    ),
    (
        crate::EncodedStr::Ascii("animalizations"),
        &[(0b01001, &ENTRY_ANIMALIZATIONS_9150262297922812039)],
    ),
    (
        crate::EncodedStr::Ascii("animalize"),
        &[(0b01001, &ENTRY_ANIMALIZE_10795005523464430843)],
    ),
    (
        crate::EncodedStr::Ascii("animalized"),
        &[(0b01001, &ENTRY_ANIMALIZED_14858832182572412268)],
    ),
    (
        crate::EncodedStr::Ascii("animalizes"),
        &[(0b01001, &ENTRY_ANIMALIZES_10069318372695209095)],
    ),
    (
        crate::EncodedStr::Ascii("animalizing"),
        &[(0b01001, &ENTRY_ANIMALIZING_14729872040352851901)],
    ),
    (
        crate::EncodedStr::Ascii("animised"),
        &[(0b10010, &ENTRY_ANIMIZED_3366606492537025225)],
    ),
    (
        crate::EncodedStr::Ascii("animized"),
        &[(0b01001, &ENTRY_ANIMIZED_3366606492537025225)],
    ),
    (
        crate::EncodedStr::Ascii("annalise"),
        &[(0b10010, &ENTRY_ANNALIZE_5262176181932588410)],
    ),
    (
        crate::EncodedStr::Ascii("annalised"),
        &[(0b10010, &ENTRY_ANNALIZED_1584431856817967939)],
    ),
    (
        crate::EncodedStr::Ascii("annalises"),
        &[(0b10010, &ENTRY_ANNALIZES_9421823492557620465)],
    ),
    (
        crate::EncodedStr::Ascii("annalising"),
        &[(0b10010, &ENTRY_ANNALIZING_7591181130486416840)],
    ),
    (
        crate::EncodedStr::Ascii("annalize"),
        &[(0b01001, &ENTRY_ANNALIZE_5262176181932588410)],
    ),
    (
        crate::EncodedStr::Ascii("annalized"),
        &[(0b01001, &ENTRY_ANNALIZED_1584431856817967939)],
    ),
    (
        crate::EncodedStr::Ascii("annalizes"),
        &[(0b01001, &ENTRY_ANNALIZES_9421823492557620465)],
    ),
    (
        crate::EncodedStr::Ascii("annalizing"),
        &[(0b01001, &ENTRY_ANNALIZING_7591181130486416840)],
    ),
    (
        crate::EncodedStr::Ascii("annualisation"),
        &[(0b10010, &ENTRY_ANNUALIZATION_7581292024702563132)],
    ),
    (
        crate::EncodedStr::Ascii("annualise"),
        &[(0b10010, &ENTRY_ANNUALIZE_10377266175278860708)],
    ),
    (
        crate::EncodedStr::Ascii("annualised"),
        &[(0b10010, &ENTRY_ANNUALIZED_1903235447181584612)],
    ),
    (
        crate::EncodedStr::Ascii("annualises"),
        &[(0b10010, &ENTRY_ANNUALIZES_784688421746976936)],
    ),
    (
        crate::EncodedStr::Ascii("annualising"),
        &[(0b10010, &ENTRY_ANNUALIZING_2550568847360033478)],
    ),
    (
        crate::EncodedStr::Ascii("annualization"),
        &[(0b01001, &ENTRY_ANNUALIZATION_7581292024702563132)],
    ),
    (
        crate::EncodedStr::Ascii("annualize"),
        &[(0b01001, &ENTRY_ANNUALIZE_10377266175278860708)],
    ),
    (
        crate::EncodedStr::Ascii("annualized"),
        &[(0b01001, &ENTRY_ANNUALIZED_1903235447181584612)],
    ),
    (
        crate::EncodedStr::Ascii("annualizes"),
        &[(0b01001, &ENTRY_ANNUALIZES_784688421746976936)],
    ),
    (
        crate::EncodedStr::Ascii("annualizing"),
        &[(0b01001, &ENTRY_ANNUALIZING_2550568847360033478)],
    ),
    (
        crate::EncodedStr::Ascii("anodisation"),
        &[(0b10010, &ENTRY_ANODIZATION_733182598382300688)],
    ),
    (
        crate::EncodedStr::Ascii("anodise"),
        &[(0b10010, &ENTRY_ANODIZE_13790793654476230265)],
    ),
    (
        crate::EncodedStr::Ascii("anodised"),
        &[(0b10010, &ENTRY_ANODIZED_7735922642387297722)],
    ),
    (
        crate::EncodedStr::Ascii("anodises"),
        &[(0b10010, &ENTRY_ANODIZES_16654764323679187252)],
    ),
    (
        crate::EncodedStr::Ascii("anodising"),
        &[(0b10010, &ENTRY_ANODIZING_15645879132035324138)],
    ),
    (
        crate::EncodedStr::Ascii("anodization"),
        &[(0b01001, &ENTRY_ANODIZATION_733182598382300688)],
    ),
    (
        crate::EncodedStr::Ascii("anodize"),
        &[(0b01001, &ENTRY_ANODIZE_13790793654476230265)],
    ),
    (
        crate::EncodedStr::Ascii("anodized"),
        &[(0b01001, &ENTRY_ANODIZED_7735922642387297722)],
    ),
    (
        crate::EncodedStr::Ascii("anodizes"),
        &[(0b01001, &ENTRY_ANODIZES_16654764323679187252)],
    ),
    (
        crate::EncodedStr::Ascii("anodizing"),
        &[(0b01001, &ENTRY_ANODIZING_15645879132035324138)],
    ),
    (
        crate::EncodedStr::Ascii("anoesis"),
        &[(0b11010, &ENTRY_ANESIS_16817046064174279211)],
    ),
    (
        crate::EncodedStr::Ascii("anoestra"),
        &[(0b11010, &ENTRY_ANESTRA_3216556063016372977)],
    ),
    (
        crate::EncodedStr::Ascii("anoestri"),
        &[(0b11010, &ENTRY_ANESTRI_8008769930372220485)],
    ),
    (
        crate::EncodedStr::Ascii("anoestrous"),
        &[(0b11010, &ENTRY_ANESTROUS_9129522172283593493)],
    ),
    (
        crate::EncodedStr::Ascii("anoestrum"),
        &[(0b11010, &ENTRY_ANESTRUM_11523934029574851144)],
    ),
    (
        crate::EncodedStr::Ascii("anoestrus"),
        &[(0b11010, &ENTRY_ANESTRUS_9353558396235507225)],
    ),
    (
        crate::EncodedStr::Ascii("anoestruses"),
        &[(0b11010, &ENTRY_ANESTRUSES_8824267452405407476)],
    ),
    (
        crate::EncodedStr::Ascii("anoetic"),
        &[(0b11010, &ENTRY_ANETIC_9540754510599321451)],
    ),
    (
        crate::EncodedStr::Ascii("anonymise"),
        &[(0b10010, &ENTRY_ANONYMIZE_1026063515222292659)],
    ),
    (
        crate::EncodedStr::Ascii("anonymised"),
        &[(0b10010, &ENTRY_ANONYMIZED_12511764813081644809)],
    ),
    (
        crate::EncodedStr::Ascii("anonymises"),
        &[(0b10010, &ENTRY_ANONYMIZES_8133801285918261260)],
    ),
    (
        crate::EncodedStr::Ascii("anonymising"),
        &[(0b10010, &ENTRY_ANONYMIZING_8330567531910680906)],
    ),
    (
        crate::EncodedStr::Ascii("anonymize"),
        &[(0b01001, &ENTRY_ANONYMIZE_1026063515222292659)],
    ),
    (
        crate::EncodedStr::Ascii("anonymized"),
        &[(0b01001, &ENTRY_ANONYMIZED_12511764813081644809)],
    ),
    (
        crate::EncodedStr::Ascii("anonymizes"),
        &[(0b01001, &ENTRY_ANONYMIZES_8133801285918261260)],
    ),
    (
        crate::EncodedStr::Ascii("anonymizing"),
        &[(0b01001, &ENTRY_ANONYMIZING_8330567531910680906)],
    ),
    (
        crate::EncodedStr::Ascii("anora"),
        &[(0b00001, &ENTRY_ANORA_9499275694738114232)],
    ),
    (
        crate::EncodedStr::Ascii("anoura"),
        &[(0b11010, &ENTRY_ANORA_9499275694738114232)],
    ),
    (
        crate::EncodedStr::Ascii("anoxaemia"),
        &[(0b11010, &ENTRY_ANOXEMIA_938996689614149150)],
    ),
    (
        crate::EncodedStr::Ascii("anoxaemic"),
        &[(0b11010, &ENTRY_ANOXEMIC_11133442815252282278)],
    ),
    (
        crate::EncodedStr::Ascii("anoxemia"),
        &[(0b10001, &ENTRY_ANOXEMIA_938996689614149150)],
    ),
    (
        crate::EncodedStr::Ascii("anoxemic"),
        &[(0b10001, &ENTRY_ANOXEMIC_11133442815252282278)],
    ),
    (
        crate::EncodedStr::Ascii("anserinae"),
        &[(0b11010, &ENTRY_ANSERINE_7284353552541073260)],
    ),
    (
        crate::EncodedStr::Ascii("anserine"),
        &[(0b00001, &ENTRY_ANSERINE_7284353552541073260)],
    ),
    (
        crate::EncodedStr::Ascii("antagonisable"),
        &[(0b10010, &ENTRY_ANTAGONIZABLE_7443781692023206072)],
    ),
    (
        crate::EncodedStr::Ascii("antagonisation"),
        &[(0b10010, &ENTRY_ANTAGONIZATION_15721044409672903140)],
    ),
    (
        crate::EncodedStr::Ascii("antagonisations"),
        &[(0b10010, &ENTRY_ANTAGONIZATIONS_4109454268643874511)],
    ),
    (
        crate::EncodedStr::Ascii("antagonise"),
        &[(0b10010, &ENTRY_ANTAGONIZE_10601283474489177682)],
    ),
    (
        crate::EncodedStr::Ascii("antagonised"),
        &[(0b10010, &ENTRY_ANTAGONIZED_871138940432104250)],
    ),
    (
        crate::EncodedStr::Ascii("antagoniser"),
        &[(0b10010, &ENTRY_ANTAGONIZER_2788747943091284362)],
    ),
    (
        crate::EncodedStr::Ascii("antagonisers"),
        &[(0b10010, &ENTRY_ANTAGONIZERS_12305563490012496402)],
    ),
    (
        crate::EncodedStr::Ascii("antagonises"),
        &[(0b10010, &ENTRY_ANTAGONIZES_10859788922464934847)],
    ),
    (
        crate::EncodedStr::Ascii("antagonising"),
        &[(0b10010, &ENTRY_ANTAGONIZING_7228037109106376861)],
    ),
    (
        crate::EncodedStr::Ascii("antagonizable"),
        &[(0b01001, &ENTRY_ANTAGONIZABLE_7443781692023206072)],
    ),
    (
        crate::EncodedStr::Ascii("antagonization"),
        &[(0b01001, &ENTRY_ANTAGONIZATION_15721044409672903140)],
    ),
    (
        crate::EncodedStr::Ascii("antagonizations"),
        &[(0b01001, &ENTRY_ANTAGONIZATIONS_4109454268643874511)],
    ),
    (
        crate::EncodedStr::Ascii("antagonize"),
        &[(0b01001, &ENTRY_ANTAGONIZE_10601283474489177682)],
    ),
    (
        crate::EncodedStr::Ascii("antagonized"),
        &[(0b01001, &ENTRY_ANTAGONIZED_871138940432104250)],
    ),
    (
        crate::EncodedStr::Ascii("antagonizer"),
        &[(0b01001, &ENTRY_ANTAGONIZER_2788747943091284362)],
    ),
    (
        crate::EncodedStr::Ascii("antagonizers"),
        &[(0b01001, &ENTRY_ANTAGONIZERS_12305563490012496402)],
    ),
    (
        crate::EncodedStr::Ascii("antagonizes"),
        &[(0b01001, &ENTRY_ANTAGONIZES_10859788922464934847)],
    ),
    (
        crate::EncodedStr::Ascii("antagonizing"),
        &[(0b01001, &ENTRY_ANTAGONIZING_7228037109106376861)],
    ),
    (
        crate::EncodedStr::Ascii("anthecological"),
        &[(0b00001, &ENTRY_ANTHECOLOGICAL_17004641370097456161)],
    ),
    (
        crate::EncodedStr::Ascii("anthecologist"),
        &[(0b00001, &ENTRY_ANTHECOLOGIST_10842025172326516523)],
    ),
    (
        crate::EncodedStr::Ascii("anthecology"),
        &[(0b00001, &ENTRY_ANTHECOLOGY_3713437946183115906)],
    ),
    (
        crate::EncodedStr::Ascii("anthoecological"),
        &[(0b11010, &ENTRY_ANTHECOLOGICAL_17004641370097456161)],
    ),
    (
        crate::EncodedStr::Ascii("anthoecologist"),
        &[(0b11010, &ENTRY_ANTHECOLOGIST_10842025172326516523)],
    ),
    (
        crate::EncodedStr::Ascii("anthoecology"),
        &[(0b11010, &ENTRY_ANTHECOLOGY_3713437946183115906)],
    ),
    (
        crate::EncodedStr::Ascii("anthologisation"),
        &[(0b10010, &ENTRY_ANTHOLOGIZATION_16268833295952924414)],
    ),
    (
        crate::EncodedStr::Ascii("anthologise"),
        &[(0b10010, &ENTRY_ANTHOLOGIZE_15075070972324121611)],
    ),
    (
        crate::EncodedStr::Ascii("anthologised"),
        &[(0b10010, &ENTRY_ANTHOLOGIZED_12562962063091396112)],
    ),
    (
        crate::EncodedStr::Ascii("anthologiser"),
        &[(0b10010, &ENTRY_ANTHOLOGIZER_4038135053732224148)],
    ),
    (
        crate::EncodedStr::Ascii("anthologises"),
        &[(0b10010, &ENTRY_ANTHOLOGIZES_5463829982103826072)],
    ),
    (
        crate::EncodedStr::Ascii("anthologising"),
        &[(0b10010, &ENTRY_ANTHOLOGIZING_16324123758427872169)],
    ),
    (
        crate::EncodedStr::Ascii("anthologization"),
        &[(0b01001, &ENTRY_ANTHOLOGIZATION_16268833295952924414)],
    ),
    (
        crate::EncodedStr::Ascii("anthologize"),
        &[(0b01001, &ENTRY_ANTHOLOGIZE_15075070972324121611)],
    ),
    (
        crate::EncodedStr::Ascii("anthologized"),
        &[(0b01001, &ENTRY_ANTHOLOGIZED_12562962063091396112)],
    ),
    (
        crate::EncodedStr::Ascii("anthologizer"),
        &[(0b01001, &ENTRY_ANTHOLOGIZER_4038135053732224148)],
    ),
    (
        crate::EncodedStr::Ascii("anthologizes"),
        &[(0b01001, &ENTRY_ANTHOLOGIZES_5463829982103826072)],
    ),
    (
        crate::EncodedStr::Ascii("anthologizing"),
        &[(0b01001, &ENTRY_ANTHOLOGIZING_16324123758427872169)],
    ),
    (
        crate::EncodedStr::Ascii("anthracaemia"),
        &[(0b11010, &ENTRY_ANTHRACEMIA_14146688523586379951)],
    ),
    (
        crate::EncodedStr::Ascii("anthracemia"),
        &[(0b00001, &ENTRY_ANTHRACEMIA_14146688523586379951)],
    ),
    (
        crate::EncodedStr::Ascii("anthracitisation"),
        &[(0b10010, &ENTRY_ANTHRACITIZATION_8950863959835278016)],
    ),
    (
        crate::EncodedStr::Ascii("anthracitisations"),
        &[(0b10010, &ENTRY_ANTHRACITIZATIONS_1915110451729220165)],
    ),
    (
        crate::EncodedStr::Ascii("anthracitization"),
        &[(0b01001, &ENTRY_ANTHRACITIZATION_8950863959835278016)],
    ),
    (
        crate::EncodedStr::Ascii("anthracitizations"),
        &[(0b01001, &ENTRY_ANTHRACITIZATIONS_1915110451729220165)],
    ),
    (
        crate::EncodedStr::Ascii("anthropomorphisation"),
        &[(0b10010, &ENTRY_ANTHROPOMORPHIZATION_15471734561820106871)],
    ),
    (
        crate::EncodedStr::Ascii("anthropomorphisations"),
        &[(0b10010, &ENTRY_ANTHROPOMORPHIZATIONS_18314256758800098784)],
    ),
    (
        crate::EncodedStr::Ascii("anthropomorphise"),
        &[(0b10010, &ENTRY_ANTHROPOMORPHIZE_18370683813510312473)],
    ),
    (
        crate::EncodedStr::Ascii("anthropomorphised"),
        &[(0b10010, &ENTRY_ANTHROPOMORPHIZED_14538403291788237977)],
    ),
    (
        crate::EncodedStr::Ascii("anthropomorphises"),
        &[(0b10010, &ENTRY_ANTHROPOMORPHIZES_1701634817856038507)],
    ),
    (
        crate::EncodedStr::Ascii("anthropomorphising"),
        &[(0b10010, &ENTRY_ANTHROPOMORPHIZING_2456478028362212796)],
    ),
    (
        crate::EncodedStr::Ascii("anthropomorphization"),
        &[(0b01001, &ENTRY_ANTHROPOMORPHIZATION_15471734561820106871)],
    ),
    (
        crate::EncodedStr::Ascii("anthropomorphizations"),
        &[(0b01001, &ENTRY_ANTHROPOMORPHIZATIONS_18314256758800098784)],
    ),
    (
        crate::EncodedStr::Ascii("anthropomorphize"),
        &[(0b01001, &ENTRY_ANTHROPOMORPHIZE_18370683813510312473)],
    ),
    (
        crate::EncodedStr::Ascii("anthropomorphized"),
        &[(0b01001, &ENTRY_ANTHROPOMORPHIZED_14538403291788237977)],
    ),
    (
        crate::EncodedStr::Ascii("anthropomorphizes"),
        &[(0b01001, &ENTRY_ANTHROPOMORPHIZES_1701634817856038507)],
    ),
    (
        crate::EncodedStr::Ascii("anthropomorphizing"),
        &[(0b01001, &ENTRY_ANTHROPOMORPHIZING_2456478028362212796)],
    ),
    (
        crate::EncodedStr::Ascii("anticatalyser"),
        &[(0b11010, &ENTRY_ANTICATALYZER_4172121096489270019)],
    ),
    (
        crate::EncodedStr::Ascii("anticatalysers"),
        &[(0b11010, &ENTRY_ANTICATALYZERS_14048896960716076262)],
    ),
    (
        crate::EncodedStr::Ascii("anticatalyzer"),
        &[(0b00001, &ENTRY_ANTICATALYZER_4172121096489270019)],
    ),
    (
        crate::EncodedStr::Ascii("anticatalyzers"),
        &[(0b00001, &ENTRY_ANTICATALYZERS_14048896960716076262)],
    ),
    (
        crate::EncodedStr::Ascii("anticentralisation"),
        &[(0b10010, &ENTRY_ANTICENTRALIZATION_14344770334712817786)],
    ),
    (
        crate::EncodedStr::Ascii("anticentralisations"),
        &[(0b10010, &ENTRY_ANTICENTRALIZATIONS_13464164849647372934)],
    ),
    (
        crate::EncodedStr::Ascii("anticentralization"),
        &[(0b01001, &ENTRY_ANTICENTRALIZATION_14344770334712817786)],
    ),
    (
        crate::EncodedStr::Ascii("anticentralizations"),
        &[(0b01001, &ENTRY_ANTICENTRALIZATIONS_13464164849647372934)],
    ),
    (
        crate::EncodedStr::Ascii("anticise"),
        &[(0b10010, &ENTRY_ANTICIZE_16286568034747030643)],
    ),
    (
        crate::EncodedStr::Ascii("anticises"),
        &[(0b10010, &ENTRY_ANTICIZES_10127792012492899699)],
    ),
    (
        crate::EncodedStr::Ascii("anticize"),
        &[(0b01001, &ENTRY_ANTICIZE_16286568034747030643)],
    ),
    (
        crate::EncodedStr::Ascii("anticizes"),
        &[(0b01001, &ENTRY_ANTICIZES_10127792012492899699)],
    ),
    (
        crate::EncodedStr::Ascii("antiepicenter"),
        &[(0b00001, &ENTRY_ANTIEPICENTER_12788218346335819271)],
    ),
    (
        crate::EncodedStr::Ascii("antiepicenters"),
        &[(0b00001, &ENTRY_ANTIEPICENTERS_7717054593335253563)],
    ),
    (
        crate::EncodedStr::Ascii("antiepicentre"),
        &[(0b11010, &ENTRY_ANTIEPICENTER_12788218346335819271)],
    ),
    (
        crate::EncodedStr::Ascii("antiepicentres"),
        &[(0b11010, &ENTRY_ANTIEPICENTERS_7717054593335253563)],
    ),
    (
        crate::EncodedStr::Ascii("antifertiliser"),
        &[(0b10010, &ENTRY_ANTIFERTILIZER_9953475323473604594)],
    ),
    (
        crate::EncodedStr::Ascii("antifertilisers"),
        &[(0b10010, &ENTRY_ANTIFERTILIZERS_13569559599612590243)],
    ),
    (
        crate::EncodedStr::Ascii("antifertilizer"),
        &[(0b01001, &ENTRY_ANTIFERTILIZER_9953475323473604594)],
    ),
    (
        crate::EncodedStr::Ascii("antifertilizers"),
        &[(0b01001, &ENTRY_ANTIFERTILIZERS_13569559599612590243)],
    ),
    (
        crate::EncodedStr::Ascii("antilabor"),
        &[(0b10001, &ENTRY_ANTILABOR_9287358752473165308)],
    ),
    (
        crate::EncodedStr::Ascii("antilabors"),
        &[(0b10001, &ENTRY_ANTILABORS_3039533109874187414)],
    ),
    (
        crate::EncodedStr::Ascii("antilabour"),
        &[(0b11010, &ENTRY_ANTILABOR_9287358752473165308)],
    ),
    (
        crate::EncodedStr::Ascii("antilabours"),
        &[(0b11010, &ENTRY_ANTILABORS_3039533109874187414)],
    ),
    (
        crate::EncodedStr::Ascii("antilemic"),
        &[(0b00001, &ENTRY_ANTILEMIC_9212729723604435140)],
    ),
    (
        crate::EncodedStr::Ascii("antiloemic"),
        &[(0b11010, &ENTRY_ANTILEMIC_9212729723604435140)],
    ),
    (
        crate::EncodedStr::Ascii("antimediaeval"),
        &[(0b11010, &ENTRY_ANTIMEDIEVAL_6846585678553345503)],
    ),
    (
        crate::EncodedStr::Ascii("antimediaevalism"),
        &[(0b11010, &ENTRY_ANTIMEDIEVALISM_8317263462919339358)],
    ),
    (
        crate::EncodedStr::Ascii("antimediaevalist"),
        &[(0b11010, &ENTRY_ANTIMEDIEVALIST_3072518728053155006)],
    ),
    (
        crate::EncodedStr::Ascii("antimediaevally"),
        &[(0b11010, &ENTRY_ANTIMEDIEVALLY_17141320310909970911)],
    ),
    (
        crate::EncodedStr::Ascii("antimedieval"),
        &[(0b00001, &ENTRY_ANTIMEDIEVAL_6846585678553345503)],
    ),
    (
        crate::EncodedStr::Ascii("antimedievalism"),
        &[(0b00001, &ENTRY_ANTIMEDIEVALISM_8317263462919339358)],
    ),
    (
        crate::EncodedStr::Ascii("antimedievalist"),
        &[(0b00001, &ENTRY_ANTIMEDIEVALIST_3072518728053155006)],
    ),
    (
        crate::EncodedStr::Ascii("antimedievally"),
        &[(0b00001, &ENTRY_ANTIMEDIEVALLY_17141320310909970911)],
    ),
    (
        crate::EncodedStr::Ascii("antioxidiser"),
        &[(0b10010, &ENTRY_ANTIOXIDIZER_12620825255232115928)],
    ),
    (
        crate::EncodedStr::Ascii("antioxidisers"),
        &[(0b10010, &ENTRY_ANTIOXIDIZERS_10675061378003290626)],
    ),
    (
        crate::EncodedStr::Ascii("antioxidising"),
        &[(0b10010, &ENTRY_ANTIOXIDIZING_2522097081998511687)],
    ),
    (
        crate::EncodedStr::Ascii("antioxidisings"),
        &[(0b10010, &ENTRY_ANTIOXIDIZINGS_16313410243816058314)],
    ),
    (
        crate::EncodedStr::Ascii("antioxidizer"),
        &[(0b01001, &ENTRY_ANTIOXIDIZER_12620825255232115928)],
    ),
    (
        crate::EncodedStr::Ascii("antioxidizers"),
        &[(0b01001, &ENTRY_ANTIOXIDIZERS_10675061378003290626)],
    ),
    (
        crate::EncodedStr::Ascii("antioxidizing"),
        &[(0b01001, &ENTRY_ANTIOXIDIZING_2522097081998511687)],
    ),
    (
        crate::EncodedStr::Ascii("antioxidizings"),
        &[(0b01001, &ENTRY_ANTIOXIDIZINGS_16313410243816058314)],
    ),
    (
        crate::EncodedStr::Ascii("antipathise"),
        &[(0b10010, &ENTRY_ANTIPATHIZE_14999471117461116868)],
    ),
    (
        crate::EncodedStr::Ascii("antipathises"),
        &[(0b10010, &ENTRY_ANTIPATHIZES_8032094931129328603)],
    ),
    (
        crate::EncodedStr::Ascii("antipathize"),
        &[(0b01001, &ENTRY_ANTIPATHIZE_14999471117461116868)],
    ),
    (
        crate::EncodedStr::Ascii("antipathizes"),
        &[(0b01001, &ENTRY_ANTIPATHIZES_8032094931129328603)],
    ),
    (
        crate::EncodedStr::Ascii("antiquarianise"),
        &[(0b10010, &ENTRY_ANTIQUARIANIZE_12102393390446972744)],
    ),
    (
        crate::EncodedStr::Ascii("antiquarianises"),
        &[(0b10010, &ENTRY_ANTIQUARIANIZES_668583703801855532)],
    ),
    (
        crate::EncodedStr::Ascii("antiquarianize"),
        &[(0b01001, &ENTRY_ANTIQUARIANIZE_12102393390446972744)],
    ),
    (
        crate::EncodedStr::Ascii("antiquarianizes"),
        &[(0b01001, &ENTRY_ANTIQUARIANIZES_668583703801855532)],
    ),
    (
        crate::EncodedStr::Ascii("antirumor"),
        &[(0b10001, &ENTRY_ANTIRUMOR_17427963938068472854)],
    ),
    (
        crate::EncodedStr::Ascii("antirumors"),
        &[(0b10001, &ENTRY_ANTIRUMORS_10439853249354862297)],
    ),
    (
        crate::EncodedStr::Ascii("antirumour"),
        &[(0b11010, &ENTRY_ANTIRUMOR_17427963938068472854)],
    ),
    (
        crate::EncodedStr::Ascii("antirumours"),
        &[(0b11010, &ENTRY_ANTIRUMORS_10439853249354862297)],
    ),
    (
        crate::EncodedStr::Ascii("antisensitise"),
        &[(0b10010, &ENTRY_ANTISENSITIZE_11055978247768215431)],
    ),
    (
        crate::EncodedStr::Ascii("antisensitiser"),
        &[(0b10010, &ENTRY_ANTISENSITIZER_12937207493474321236)],
    ),
    (
        crate::EncodedStr::Ascii("antisensitisers"),
        &[(0b10010, &ENTRY_ANTISENSITIZERS_633215389454343262)],
    ),
    (
        crate::EncodedStr::Ascii("antisensitises"),
        &[(0b10010, &ENTRY_ANTISENSITIZES_16880204120152034442)],
    ),
    (
        crate::EncodedStr::Ascii("antisensitize"),
        &[(0b01001, &ENTRY_ANTISENSITIZE_11055978247768215431)],
    ),
    (
        crate::EncodedStr::Ascii("antisensitizer"),
        &[(0b01001, &ENTRY_ANTISENSITIZER_12937207493474321236)],
    ),
    (
        crate::EncodedStr::Ascii("antisensitizers"),
        &[(0b01001, &ENTRY_ANTISENSITIZERS_633215389454343262)],
    ),
    (
        crate::EncodedStr::Ascii("antisensitizes"),
        &[(0b01001, &ENTRY_ANTISENSITIZES_16880204120152034442)],
    ),
    (
        crate::EncodedStr::Ascii("antisepticise"),
        &[(0b10010, &ENTRY_ANTISEPTICIZE_3241553852417294791)],
    ),
    (
        crate::EncodedStr::Ascii("antisepticised"),
        &[(0b10010, &ENTRY_ANTISEPTICIZED_3518662086162245234)],
    ),
    (
        crate::EncodedStr::Ascii("antisepticises"),
        &[(0b10010, &ENTRY_ANTISEPTICIZES_13502357588080215816)],
    ),
    (
        crate::EncodedStr::Ascii("antisepticising"),
        &[(0b10010, &ENTRY_ANTISEPTICIZING_5069156061578073106)],
    ),
    (
        crate::EncodedStr::Ascii("antisepticize"),
        &[(0b01001, &ENTRY_ANTISEPTICIZE_3241553852417294791)],
    ),
    (
        crate::EncodedStr::Ascii("antisepticized"),
        &[(0b01001, &ENTRY_ANTISEPTICIZED_3518662086162245234)],
    ),
    (
        crate::EncodedStr::Ascii("antisepticizes"),
        &[(0b01001, &ENTRY_ANTISEPTICIZES_13502357588080215816)],
    ),
    (
        crate::EncodedStr::Ascii("antisepticizing"),
        &[(0b01001, &ENTRY_ANTISEPTICIZING_5069156061578073106)],
    ),
    (
        crate::EncodedStr::Ascii("antiseptise"),
        &[(0b10010, &ENTRY_ANTISEPTIZE_3729071818555121770)],
    ),
    (
        crate::EncodedStr::Ascii("antiseptises"),
        &[(0b10010, &ENTRY_ANTISEPTIZES_15830751901555519360)],
    ),
    (
        crate::EncodedStr::Ascii("antiseptize"),
        &[(0b01001, &ENTRY_ANTISEPTIZE_3729071818555121770)],
    ),
    (
        crate::EncodedStr::Ascii("antiseptizes"),
        &[(0b01001, &ENTRY_ANTISEPTIZES_15830751901555519360)],
    ),
    (
        crate::EncodedStr::Ascii("antisiphon"),
        &[(0b00001, &ENTRY_ANTISIPHON_15645040475271523141)],
    ),
    (
        crate::EncodedStr::Ascii("antisiphons"),
        &[(0b00001, &ENTRY_ANTISIPHONS_9333803036952068517)],
    ),
    (
        crate::EncodedStr::Ascii("antisyphon"),
        &[(0b11010, &ENTRY_ANTISIPHON_15645040475271523141)],
    ),
    (
        crate::EncodedStr::Ascii("antisyphons"),
        &[(0b11010, &ENTRY_ANTISIPHONS_9333803036952068517)],
    ),
    (
        crate::EncodedStr::Ascii("antithesise"),
        &[(0b10010, &ENTRY_ANTITHESIZE_6914205044378767893)],
    ),
    (
        crate::EncodedStr::Ascii("antithesises"),
        &[(0b10010, &ENTRY_ANTITHESIZES_6606468090715627462)],
    ),
    (
        crate::EncodedStr::Ascii("antithesize"),
        &[(0b01001, &ENTRY_ANTITHESIZE_6914205044378767893)],
    ),
    (
        crate::EncodedStr::Ascii("antithesizes"),
        &[(0b01001, &ENTRY_ANTITHESIZES_6606468090715627462)],
    ),
    (
        crate::EncodedStr::Ascii("anviled"),
        &[(0b00001, &ENTRY_ANVILED_16736675705730161078)],
    ),
    (
        crate::EncodedStr::Ascii("anviling"),
        &[(0b00001, &ENTRY_ANVILING_5771622187992250616)],
    ),
    (
        crate::EncodedStr::Ascii("anvilled"),
        &[(0b11010, &ENTRY_ANVILED_16736675705730161078)],
    ),
    (
        crate::EncodedStr::Ascii("anvilling"),
        &[(0b11010, &ENTRY_ANVILING_5771622187992250616)],
    ),
    (
        crate::EncodedStr::Ascii("apaesthesia"),
        &[(0b11010, &ENTRY_APESTHESIA_13121175333380557565)],
    ),
    (
        crate::EncodedStr::Ascii("apaesthetic"),
        &[(0b11010, &ENTRY_APESTHETIC_15861671523251257086)],
    ),
    (
        crate::EncodedStr::Ascii("apesthesia"),
        &[(0b00001, &ENTRY_APESTHESIA_13121175333380557565)],
    ),
    (
        crate::EncodedStr::Ascii("apesthetic"),
        &[(0b00001, &ENTRY_APESTHETIC_15861671523251257086)],
    ),
    (
        crate::EncodedStr::Ascii("aphaereses"),
        &[(0b11010, &ENTRY_APHERESES_873005030036232707)],
    ),
    (
        crate::EncodedStr::Ascii("aphaeresis"),
        &[(0b11010, &ENTRY_APHERESIS_14381380856101872428)],
    ),
    (
        crate::EncodedStr::Ascii("aphaeretic"),
        &[(0b11010, &ENTRY_APHERETIC_1426744147716989088)],
    ),
    (
        crate::EncodedStr::Ascii("aphereses"),
        &[(0b10001, &ENTRY_APHERESES_873005030036232707)],
    ),
    (
        crate::EncodedStr::Ascii("apheresis"),
        &[(0b10001, &ENTRY_APHERESIS_14381380856101872428)],
    ),
    (
        crate::EncodedStr::Ascii("apheretic"),
        &[(0b10001, &ENTRY_APHERETIC_1426744147716989088)],
    ),
    (
        crate::EncodedStr::Ascii("aphetise"),
        &[(0b10010, &ENTRY_APHETIZE_17206274738648406980)],
    ),
    (
        crate::EncodedStr::Ascii("aphetised"),
        &[(0b10010, &ENTRY_APHETIZED_3003107362630119729)],
    ),
    (
        crate::EncodedStr::Ascii("aphetises"),
        &[(0b10010, &ENTRY_APHETIZES_1747641243391683773)],
    ),
    (
        crate::EncodedStr::Ascii("aphetising"),
        &[(0b10010, &ENTRY_APHETIZING_13930569398062916036)],
    ),
    (
        crate::EncodedStr::Ascii("aphetize"),
        &[(0b01001, &ENTRY_APHETIZE_17206274738648406980)],
    ),
    (
        crate::EncodedStr::Ascii("aphetized"),
        &[(0b01001, &ENTRY_APHETIZED_3003107362630119729)],
    ),
    (
        crate::EncodedStr::Ascii("aphetizes"),
        &[(0b01001, &ENTRY_APHETIZES_1747641243391683773)],
    ),
    (
        crate::EncodedStr::Ascii("aphetizing"),
        &[(0b01001, &ENTRY_APHETIZING_13930569398062916036)],
    ),
    (
        crate::EncodedStr::Ascii("aphorise"),
        &[(0b10010, &ENTRY_APHORIZE_15454256210406202597)],
    ),
    (
        crate::EncodedStr::Ascii("aphorised"),
        &[(0b10010, &ENTRY_APHORIZED_1699636898236576866)],
    ),
    (
        crate::EncodedStr::Ascii("aphoriser"),
        &[(0b10010, &ENTRY_APHORIZER_14605329647382162831)],
    ),
    (
        crate::EncodedStr::Ascii("aphorisers"),
        &[(0b10010, &ENTRY_APHORIZERS_10347189849445130867)],
    ),
    (
        crate::EncodedStr::Ascii("aphorises"),
        &[(0b10010, &ENTRY_APHORIZES_13164228522572019559)],
    ),
    (
        crate::EncodedStr::Ascii("aphorising"),
        &[(0b10010, &ENTRY_APHORIZING_11576244252883430467)],
    ),
    (
        crate::EncodedStr::Ascii("aphorize"),
        &[(0b01001, &ENTRY_APHORIZE_15454256210406202597)],
    ),
    (
        crate::EncodedStr::Ascii("aphorized"),
        &[(0b01001, &ENTRY_APHORIZED_1699636898236576866)],
    ),
    (
        crate::EncodedStr::Ascii("aphorizer"),
        &[(0b01001, &ENTRY_APHORIZER_14605329647382162831)],
    ),
    (
        crate::EncodedStr::Ascii("aphorizers"),
        &[(0b01001, &ENTRY_APHORIZERS_10347189849445130867)],
    ),
    (
        crate::EncodedStr::Ascii("aphorizes"),
        &[(0b01001, &ENTRY_APHORIZES_13164228522572019559)],
    ),
    (
        crate::EncodedStr::Ascii("aphorizing"),
        &[(0b01001, &ENTRY_APHORIZING_11576244252883430467)],
    ),
    (
        crate::EncodedStr::Ascii("apnea"),
        &[(0b11001, &ENTRY_APNEA_1779953829356774189)],
    ),
    (
        crate::EncodedStr::Ascii("apneal"),
        &[(0b10001, &ENTRY_APNEAL_9097304655696180790)],
    ),
    (
        crate::EncodedStr::Ascii("apneas"),
        &[(0b11001, &ENTRY_APNEAS_16005692722117648490)],
    ),
    (
        crate::EncodedStr::Ascii("apneic"),
        &[(0b10001, &ENTRY_APNEIC_8684812892754015714)],
    ),
    (
        crate::EncodedStr::Ascii("apnoea"),
        &[(0b10010, &ENTRY_APNEA_1779953829356774189)],
    ),
    (
        crate::EncodedStr::Ascii("apnoeal"),
        &[(0b11010, &ENTRY_APNEAL_9097304655696180790)],
    ),
    (
        crate::EncodedStr::Ascii("apnoeas"),
        &[(0b10010, &ENTRY_APNEAS_16005692722117648490)],
    ),
    (
        crate::EncodedStr::Ascii("apnoeic"),
        &[(0b11010, &ENTRY_APNEIC_8684812892754015714)],
    ),
    (
        crate::EncodedStr::Ascii("apocenter"),
        &[(0b00001, &ENTRY_APOCENTER_6510924298032028131)],
    ),
    (
        crate::EncodedStr::Ascii("apocentre"),
        &[(0b11010, &ENTRY_APOCENTER_6510924298032028131)],
    ),
    (
        crate::EncodedStr::Ascii("apogaeic"),
        &[(0b11010, &ENTRY_APOGEIC_10442075832990462520)],
    ),
    (
        crate::EncodedStr::Ascii("apogeic"),
        &[(0b00001, &ENTRY_APOGEIC_10442075832990462520)],
    ),
    (
        crate::EncodedStr::Ascii("apologise"),
        &[(0b10010, &ENTRY_APOLOGIZE_4808140733719974618)],
    ),
    (
        crate::EncodedStr::Ascii("apologised"),
        &[(0b10010, &ENTRY_APOLOGIZED_766769648963130203)],
    ),
    (
        crate::EncodedStr::Ascii("apologiser"),
        &[(0b10010, &ENTRY_APOLOGIZER_6662783343430240014)],
    ),
    (
        crate::EncodedStr::Ascii("apologisers"),
        &[(0b10010, &ENTRY_APOLOGIZERS_9394583326468044369)],
    ),
    (
        crate::EncodedStr::Ascii("apologises"),
        &[(0b10010, &ENTRY_APOLOGIZES_1886820837917495266)],
    ),
    (
        crate::EncodedStr::Ascii("apologising"),
        &[(0b10010, &ENTRY_APOLOGIZING_17198773338731611091)],
    ),
    (
        crate::EncodedStr::Ascii("apologize"),
        &[(0b01001, &ENTRY_APOLOGIZE_4808140733719974618)],
    ),
    (
        crate::EncodedStr::Ascii("apologized"),
        &[(0b01001, &ENTRY_APOLOGIZED_766769648963130203)],
    ),
    (
        crate::EncodedStr::Ascii("apologizer"),
        &[(0b01001, &ENTRY_APOLOGIZER_6662783343430240014)],
    ),
    (
        crate::EncodedStr::Ascii("apologizers"),
        &[(0b01001, &ENTRY_APOLOGIZERS_9394583326468044369)],
    ),
    (
        crate::EncodedStr::Ascii("apologizes"),
        &[(0b01001, &ENTRY_APOLOGIZES_1886820837917495266)],
    ),
    (
        crate::EncodedStr::Ascii("apologizing"),
        &[(0b01001, &ENTRY_APOLOGIZING_17198773338731611091)],
    ),
    (
        crate::EncodedStr::Ascii("apophthegmatise"),
        &[(0b10010, &ENTRY_APOPHTHEGMATIZE_6610517743016644545)],
    ),
    (
        crate::EncodedStr::Ascii("apophthegmatised"),
        &[(0b10010, &ENTRY_APOPHTHEGMATIZED_6403368858420510421)],
    ),
    (
        crate::EncodedStr::Ascii("apophthegmatises"),
        &[(0b10010, &ENTRY_APOPHTHEGMATIZES_9217219445848562213)],
    ),
    (
        crate::EncodedStr::Ascii("apophthegmatising"),
        &[(0b10010, &ENTRY_APOPHTHEGMATIZING_17329841406994799734)],
    ),
    (
        crate::EncodedStr::Ascii("apophthegmatize"),
        &[(0b01001, &ENTRY_APOPHTHEGMATIZE_6610517743016644545)],
    ),
    (
        crate::EncodedStr::Ascii("apophthegmatized"),
        &[(0b01001, &ENTRY_APOPHTHEGMATIZED_6403368858420510421)],
    ),
    (
        crate::EncodedStr::Ascii("apophthegmatizes"),
        &[(0b01001, &ENTRY_APOPHTHEGMATIZES_9217219445848562213)],
    ),
    (
        crate::EncodedStr::Ascii("apophthegmatizing"),
        &[(0b01001, &ENTRY_APOPHTHEGMATIZING_17329841406994799734)],
    ),
    (
        crate::EncodedStr::Ascii("aporrhea"),
        &[(0b10001, &ENTRY_APORRHEA_16606851972678900170)],
    ),
    (
        crate::EncodedStr::Ascii("aporrhoea"),
        &[(0b11010, &ENTRY_APORRHEA_16606851972678900170)],
    ),
    (
        crate::EncodedStr::Ascii("apostatisation"),
        &[(0b10010, &ENTRY_APOSTATIZATION_11912806942865124865)],
    ),
    (
        crate::EncodedStr::Ascii("apostatise"),
        &[(0b10010, &ENTRY_APOSTATIZE_13907286705070263227)],
    ),
    (
        crate::EncodedStr::Ascii("apostatised"),
        &[(0b10010, &ENTRY_APOSTATIZED_7948531497773688326)],
    ),
    (
        crate::EncodedStr::Ascii("apostatises"),
        &[(0b10010, &ENTRY_APOSTATIZES_17887605457755809141)],
    ),
    (
        crate::EncodedStr::Ascii("apostatising"),
        &[(0b10010, &ENTRY_APOSTATIZING_10968882224231134376)],
    ),
    (
        crate::EncodedStr::Ascii("apostatization"),
        &[(0b01001, &ENTRY_APOSTATIZATION_11912806942865124865)],
    ),
    (
        crate::EncodedStr::Ascii("apostatize"),
        &[(0b01001, &ENTRY_APOSTATIZE_13907286705070263227)],
    ),
    (
        crate::EncodedStr::Ascii("apostatized"),
        &[(0b01001, &ENTRY_APOSTATIZED_7948531497773688326)],
    ),
    (
        crate::EncodedStr::Ascii("apostatizes"),
        &[(0b01001, &ENTRY_APOSTATIZES_17887605457755809141)],
    ),
    (
        crate::EncodedStr::Ascii("apostatizing"),
        &[(0b01001, &ENTRY_APOSTATIZING_10968882224231134376)],
    ),
    (
        crate::EncodedStr::Ascii("apostolise"),
        &[(0b10010, &ENTRY_APOSTOLIZE_1194842762673394568)],
    ),
    (
        crate::EncodedStr::Ascii("apostolised"),
        &[(0b10010, &ENTRY_APOSTOLIZED_968548481129324663)],
    ),
    (
        crate::EncodedStr::Ascii("apostolises"),
        &[(0b10010, &ENTRY_APOSTOLIZES_11319414821221634427)],
    ),
    (
        crate::EncodedStr::Ascii("apostolising"),
        &[(0b10010, &ENTRY_APOSTOLIZING_7088290679795202865)],
    ),
    (
        crate::EncodedStr::Ascii("apostolize"),
        &[(0b01001, &ENTRY_APOSTOLIZE_1194842762673394568)],
    ),
    (
        crate::EncodedStr::Ascii("apostolized"),
        &[(0b01001, &ENTRY_APOSTOLIZED_968548481129324663)],
    ),
    (
        crate::EncodedStr::Ascii("apostolizes"),
        &[(0b01001, &ENTRY_APOSTOLIZES_11319414821221634427)],
    ),
    (
        crate::EncodedStr::Ascii("apostolizing"),
        &[(0b01001, &ENTRY_APOSTOLIZING_7088290679795202865)],
    ),
    (
        crate::EncodedStr::Ascii("apostrophise"),
        &[(0b10010, &ENTRY_APOSTROPHIZE_6169660213182266890)],
    ),
    (
        crate::EncodedStr::Ascii("apostrophised"),
        &[(0b10010, &ENTRY_APOSTROPHIZED_10608858047847867957)],
    ),
    (
        crate::EncodedStr::Ascii("apostrophises"),
        &[(0b10010, &ENTRY_APOSTROPHIZES_7531964953977912072)],
    ),
    (
        crate::EncodedStr::Ascii("apostrophising"),
        &[(0b10010, &ENTRY_APOSTROPHIZING_11255712027534928622)],
    ),
    (
        crate::EncodedStr::Ascii("apostrophize"),
        &[(0b01001, &ENTRY_APOSTROPHIZE_6169660213182266890)],
    ),
    (
        crate::EncodedStr::Ascii("apostrophized"),
        &[(0b01001, &ENTRY_APOSTROPHIZED_10608858047847867957)],
    ),
    (
        crate::EncodedStr::Ascii("apostrophizes"),
        &[(0b01001, &ENTRY_APOSTROPHIZES_7531964953977912072)],
    ),
    (
        crate::EncodedStr::Ascii("apostrophizing"),
        &[(0b01001, &ENTRY_APOSTROPHIZING_11255712027534928622)],
    ),
    (
        crate::EncodedStr::Ascii("apothegmatise"),
        &[(0b10010, &ENTRY_APOTHEGMATIZE_9149577190229122350)],
    ),
    (
        crate::EncodedStr::Ascii("apothegmatised"),
        &[(0b10010, &ENTRY_APOTHEGMATIZED_15528209367579426804)],
    ),
    (
        crate::EncodedStr::Ascii("apothegmatises"),
        &[(0b10010, &ENTRY_APOTHEGMATIZES_3386118086394100613)],
    ),
    (
        crate::EncodedStr::Ascii("apothegmatising"),
        &[(0b10010, &ENTRY_APOTHEGMATIZING_2185890142177612358)],
    ),
    (
        crate::EncodedStr::Ascii("apothegmatize"),
        &[(0b01001, &ENTRY_APOTHEGMATIZE_9149577190229122350)],
    ),
    (
        crate::EncodedStr::Ascii("apothegmatized"),
        &[(0b01001, &ENTRY_APOTHEGMATIZED_15528209367579426804)],
    ),
    (
        crate::EncodedStr::Ascii("apothegmatizes"),
        &[(0b01001, &ENTRY_APOTHEGMATIZES_3386118086394100613)],
    ),
    (
        crate::EncodedStr::Ascii("apothegmatizing"),
        &[(0b01001, &ENTRY_APOTHEGMATIZING_2185890142177612358)],
    ),
    (
        crate::EncodedStr::Ascii("apotheosise"),
        &[(0b10010, &ENTRY_APOTHEOSIZE_12839413435396426367)],
    ),
    (
        crate::EncodedStr::Ascii("apotheosised"),
        &[(0b10010, &ENTRY_APOTHEOSIZED_2104097860710903144)],
    ),
    (
        crate::EncodedStr::Ascii("apotheosises"),
        &[(0b10010, &ENTRY_APOTHEOSIZES_6448094166099469006)],
    ),
    (
        crate::EncodedStr::Ascii("apotheosising"),
        &[(0b10010, &ENTRY_APOTHEOSIZING_10092556043562303850)],
    ),
    (
        crate::EncodedStr::Ascii("apotheosize"),
        &[(0b01001, &ENTRY_APOTHEOSIZE_12839413435396426367)],
    ),
    (
        crate::EncodedStr::Ascii("apotheosized"),
        &[(0b01001, &ENTRY_APOTHEOSIZED_2104097860710903144)],
    ),
    (
        crate::EncodedStr::Ascii("apotheosizes"),
        &[(0b01001, &ENTRY_APOTHEOSIZES_6448094166099469006)],
    ),
    (
        crate::EncodedStr::Ascii("apotheosizing"),
        &[(0b01001, &ENTRY_APOTHEOSIZING_10092556043562303850)],
    ),
    (
        crate::EncodedStr::Ascii("appal"),
        &[(0b11010, &ENTRY_APPALL_8105666145197803720)],
    ),
    (
        crate::EncodedStr::Ascii("appall"),
        &[(0b11001, &ENTRY_APPALL_8105666145197803720)],
    ),
    (
        crate::EncodedStr::Ascii("appalls"),
        &[(0b11001, &ENTRY_APPALLS_20865698290307641)],
    ),
    (
        crate::EncodedStr::Ascii("appals"),
        &[(0b11010, &ENTRY_APPALLS_20865698290307641)],
    ),
    (
        crate::EncodedStr::Ascii("appareled"),
        &[(0b00001, &ENTRY_APPARELED_10321717899864381527)],
    ),
    (
        crate::EncodedStr::Ascii("appareling"),
        &[(0b00001, &ENTRY_APPARELING_16684109917693936517)],
    ),
    (
        crate::EncodedStr::Ascii("apparelled"),
        &[(0b11010, &ENTRY_APPARELED_10321717899864381527)],
    ),
    (
        crate::EncodedStr::Ascii("apparelling"),
        &[(0b11010, &ENTRY_APPARELING_16684109917693936517)],
    ),
    (
        crate::EncodedStr::Ascii("appetise"),
        &[(0b10010, &ENTRY_APPETIZE_13936831634592536190)],
    ),
    (
        crate::EncodedStr::Ascii("appetised"),
        &[(0b10010, &ENTRY_APPETIZED_10492350941175942222)],
    ),
    (
        crate::EncodedStr::Ascii("appetisement"),
        &[(0b10010, &ENTRY_APPETIZEMENT_16407004548503724456)],
    ),
    (
        crate::EncodedStr::Ascii("appetisements"),
        &[(0b10010, &ENTRY_APPETIZEMENTS_8628307177248201340)],
    ),
    (
        crate::EncodedStr::Ascii("appetiser"),
        &[(0b10010, &ENTRY_APPETIZER_5123269697918809384)],
    ),
    (
        crate::EncodedStr::Ascii("appetisers"),
        &[(0b10010, &ENTRY_APPETIZERS_7154598257569291418)],
    ),
    (
        crate::EncodedStr::Ascii("appetises"),
        &[(0b10010, &ENTRY_APPETIZES_1889924664779699277)],
    ),
    (
        crate::EncodedStr::Ascii("appetising"),
        &[(0b10010, &ENTRY_APPETIZING_383666770405789408)],
    ),
    (
        crate::EncodedStr::Ascii("appetisingly"),
        &[(0b10010, &ENTRY_APPETIZINGLY_10760124750466327501)],
    ),
    (
        crate::EncodedStr::Ascii("appetize"),
        &[(0b01001, &ENTRY_APPETIZE_13936831634592536190)],
    ),
    (
        crate::EncodedStr::Ascii("appetized"),
        &[(0b01001, &ENTRY_APPETIZED_10492350941175942222)],
    ),
    (
        crate::EncodedStr::Ascii("appetizement"),
        &[(0b01001, &ENTRY_APPETIZEMENT_16407004548503724456)],
    ),
    (
        crate::EncodedStr::Ascii("appetizements"),
        &[(0b01001, &ENTRY_APPETIZEMENTS_8628307177248201340)],
    ),
    (
        crate::EncodedStr::Ascii("appetizer"),
        &[(0b01001, &ENTRY_APPETIZER_5123269697918809384)],
    ),
    (
        crate::EncodedStr::Ascii("appetizers"),
        &[(0b01001, &ENTRY_APPETIZERS_7154598257569291418)],
    ),
    (
        crate::EncodedStr::Ascii("appetizes"),
        &[(0b01001, &ENTRY_APPETIZES_1889924664779699277)],
    ),
    (
        crate::EncodedStr::Ascii("appetizing"),
        &[(0b01001, &ENTRY_APPETIZING_383666770405789408)],
    ),
    (
        crate::EncodedStr::Ascii("appetizingly"),
        &[(0b01001, &ENTRY_APPETIZINGLY_10760124750466327501)],
    ),
    (
        crate::EncodedStr::Ascii("apprisal"),
        &[(0b10010, &ENTRY_APPRIZAL_6335618835659004475)],
    ),
    (
        crate::EncodedStr::Ascii("appriser"),
        &[(0b10010, &ENTRY_APPRIZER_1067225642706442627)],
    ),
    (
        crate::EncodedStr::Ascii("apprisers"),
        &[(0b10010, &ENTRY_APPRIZERS_16559280108388910365)],
    ),
    (
        crate::EncodedStr::Ascii("apprisings"),
        &[(0b10010, &ENTRY_APPRIZINGS_13881830905723497559)],
    ),
    (
        crate::EncodedStr::Ascii("apprizal"),
        &[(0b01001, &ENTRY_APPRIZAL_6335618835659004475)],
    ),
    (
        crate::EncodedStr::Ascii("apprizer"),
        &[(0b01001, &ENTRY_APPRIZER_1067225642706442627)],
    ),
    (
        crate::EncodedStr::Ascii("apprizers"),
        &[(0b01001, &ENTRY_APPRIZERS_16559280108388910365)],
    ),
    (
        crate::EncodedStr::Ascii("apprizings"),
        &[(0b01001, &ENTRY_APPRIZINGS_13881830905723497559)],
    ),
    (
        crate::EncodedStr::Ascii("arabianise"),
        &[(0b10010, &ENTRY_ARABIANIZE_7091452592558944142)],
    ),
    (
        crate::EncodedStr::Ascii("arabianises"),
        &[(0b10010, &ENTRY_ARABIANIZES_6146778824890703405)],
    ),
    (
        crate::EncodedStr::Ascii("arabianize"),
        &[(0b01001, &ENTRY_ARABIANIZE_7091452592558944142)],
    ),
    (
        crate::EncodedStr::Ascii("arabianizes"),
        &[(0b01001, &ENTRY_ARABIANIZES_6146778824890703405)],
    ),
    (
        crate::EncodedStr::Ascii("arabicise"),
        &[(0b10010, &ENTRY_ARABICIZE_7118455398303530058)],
    ),
    (
        crate::EncodedStr::Ascii("arabicises"),
        &[(0b10010, &ENTRY_ARABICIZES_17376878529951217199)],
    ),
    (
        crate::EncodedStr::Ascii("arabicize"),
        &[(0b01001, &ENTRY_ARABICIZE_7118455398303530058)],
    ),
    (
        crate::EncodedStr::Ascii("arabicizes"),
        &[(0b01001, &ENTRY_ARABICIZES_17376878529951217199)],
    ),
    (
        crate::EncodedStr::Ascii("arabisation"),
        &[(0b10010, &ENTRY_ARABIZATION_18186190432640846471)],
    ),
    (
        crate::EncodedStr::Ascii("arabisations"),
        &[(0b10010, &ENTRY_ARABIZATIONS_3254497434968628478)],
    ),
    (
        crate::EncodedStr::Ascii("arabise"),
        &[(0b10010, &ENTRY_ARABIZE_9595110188198649627)],
    ),
    (
        crate::EncodedStr::Ascii("arabised"),
        &[(0b10010, &ENTRY_ARABIZED_13913844866590865979)],
    ),
    (
        crate::EncodedStr::Ascii("arabises"),
        &[(0b10010, &ENTRY_ARABIZES_16630760146158946529)],
    ),
    (
        crate::EncodedStr::Ascii("arabising"),
        &[(0b10010, &ENTRY_ARABIZING_10793371023736049149)],
    ),
    (
        crate::EncodedStr::Ascii("arabization"),
        &[(0b01001, &ENTRY_ARABIZATION_18186190432640846471)],
    ),
    (
        crate::EncodedStr::Ascii("arabizations"),
        &[(0b01001, &ENTRY_ARABIZATIONS_3254497434968628478)],
    ),
    (
        crate::EncodedStr::Ascii("arabize"),
        &[(0b01001, &ENTRY_ARABIZE_9595110188198649627)],
    ),
    (
        crate::EncodedStr::Ascii("arabized"),
        &[(0b01001, &ENTRY_ARABIZED_13913844866590865979)],
    ),
    (
        crate::EncodedStr::Ascii("arabizes"),
        &[(0b01001, &ENTRY_ARABIZES_16630760146158946529)],
    ),
    (
        crate::EncodedStr::Ascii("arabizing"),
        &[(0b01001, &ENTRY_ARABIZING_10793371023736049149)],
    ),
    (
        crate::EncodedStr::Ascii("araeometric"),
        &[(0b11010, &ENTRY_AREOMETRIC_17639504932600545758)],
    ),
    (
        crate::EncodedStr::Ascii("araeometrical"),
        &[(0b11010, &ENTRY_AREOMETRICAL_17718812079898847508)],
    ),
    (
        crate::EncodedStr::Ascii("araeostyle"),
        &[(0b11010, &ENTRY_AREOSTYLE_9887341032000748494)],
    ),
    (
        crate::EncodedStr::Ascii("araeostyles"),
        &[(0b11010, &ENTRY_AREOSTYLES_1673942835480908773)],
    ),
    (
        crate::EncodedStr::Ascii("araeosystyle"),
        &[(0b11010, &ENTRY_AREOSYSTYLE_14135429367026377792)],
    ),
    (
        crate::EncodedStr::Ascii("aramaean"),
        &[(0b11010, &ENTRY_ARAMEAN_4395400457535337445)],
    ),
    (
        crate::EncodedStr::Ascii("aramaeans"),
        &[(0b11010, &ENTRY_ARAMEANS_13793987072806544505)],
    ),
    (
        crate::EncodedStr::Ascii("aramean"),
        &[(0b10001, &ENTRY_ARAMEAN_4395400457535337445)],
    ),
    (
        crate::EncodedStr::Ascii("arameans"),
        &[(0b10001, &ENTRY_ARAMEANS_13793987072806544505)],
    ),
    (
        crate::EncodedStr::Ascii("arbalester"),
        &[(0b00001, &ENTRY_ARBALESTER_17275327857939491618)],
    ),
    (
        crate::EncodedStr::Ascii("arbalestre"),
        &[(0b11010, &ENTRY_ARBALESTER_17275327857939491618)],
    ),
    (
        crate::EncodedStr::Ascii("arbor"),
        &[(0b01001, &ENTRY_ARBOR_2099081688991941134)],
    ),
    (
        crate::EncodedStr::Ascii("arbored"),
        &[(0b00001, &ENTRY_ARBORED_6451632367270810042)],
    ),
    (
        crate::EncodedStr::Ascii("arbores"),
        &[(0b01001, &ENTRY_ARBORES_2760921281327347095)],
    ),
    (
        crate::EncodedStr::Ascii("arborisation"),
        &[(0b10010, &ENTRY_ARBORIZATION_9677792163286494747)],
    ),
    (
        crate::EncodedStr::Ascii("arborisations"),
        &[(0b10010, &ENTRY_ARBORIZATIONS_2080512800793081270)],
    ),
    (
        crate::EncodedStr::Ascii("arborise"),
        &[(0b10010, &ENTRY_ARBORIZE_13993474358635558324)],
    ),
    (
        crate::EncodedStr::Ascii("arborised"),
        &[(0b10010, &ENTRY_ARBORIZED_10511833189104814553)],
    ),
    (
        crate::EncodedStr::Ascii("arborises"),
        &[(0b10010, &ENTRY_ARBORIZES_11990594085526471423)],
    ),
    (
        crate::EncodedStr::Ascii("arborising"),
        &[(0b10010, &ENTRY_ARBORIZING_9399803869936043047)],
    ),
    (
        crate::EncodedStr::Ascii("arborization"),
        &[(0b01001, &ENTRY_ARBORIZATION_9677792163286494747)],
    ),
    (
        crate::EncodedStr::Ascii("arborizations"),
        &[(0b01001, &ENTRY_ARBORIZATIONS_2080512800793081270)],
    ),
    (
        crate::EncodedStr::Ascii("arborize"),
        &[(0b01001, &ENTRY_ARBORIZE_13993474358635558324)],
    ),
    (
        crate::EncodedStr::Ascii("arborized"),
        &[(0b01001, &ENTRY_ARBORIZED_10511833189104814553)],
    ),
    (
        crate::EncodedStr::Ascii("arborizes"),
        &[(0b01001, &ENTRY_ARBORIZES_11990594085526471423)],
    ),
    (
        crate::EncodedStr::Ascii("arborizing"),
        &[(0b01001, &ENTRY_ARBORIZING_9399803869936043047)],
    ),
    (
        crate::EncodedStr::Ascii("arbors"),
        &[(0b01001, &ENTRY_ARBORS_9095342812626319615)],
    ),
    (
        crate::EncodedStr::Ascii("arbour"),
        &[(0b11010, &ENTRY_ARBOR_2099081688991941134)],
    ),
    (
        crate::EncodedStr::Ascii("arboured"),
        &[(0b11010, &ENTRY_ARBORED_6451632367270810042)],
    ),
    (
        crate::EncodedStr::Ascii("arboures"),
        &[(0b11010, &ENTRY_ARBORES_2760921281327347095)],
    ),
    (
        crate::EncodedStr::Ascii("arbours"),
        &[(0b11010, &ENTRY_ARBORS_9095342812626319615)],
    ),
    (
        crate::EncodedStr::Ascii("archae"),
        &[(0b11010, &ENTRY_ARCHE_10156222017687532546)],
    ),
    (
        crate::EncodedStr::Ascii("archaeal"),
        &[(0b11010, &ENTRY_ARCHEAL_6179901035862490669)],
    ),
    (
        crate::EncodedStr::Ascii("archaean"),
        &[(0b11010, &ENTRY_ARCHEAN_14847398170729505321)],
    ),
    (
        crate::EncodedStr::Ascii("archaei"),
        &[(0b11010, &ENTRY_ARCHEI_14186317656172516337)],
    ),
    (
        crate::EncodedStr::Ascii("archaeoastronomies"),
        &[(0b11010, &ENTRY_ARCHEOASTRONOMIES_12672535196068691757)],
    ),
    (
        crate::EncodedStr::Ascii("archaeoastronomy"),
        &[(0b11010, &ENTRY_ARCHEOASTRONOMY_7568086850104584418)],
    ),
    (
        crate::EncodedStr::Ascii("archaeocyte"),
        &[(0b11010, &ENTRY_ARCHEOCYTE_544989770193462231)],
    ),
    (
        crate::EncodedStr::Ascii("archaeol"),
        &[(0b11010, &ENTRY_ARCHEOL_1621301161575668294)],
    ),
    (
        crate::EncodedStr::Ascii("archaeolithic"),
        &[(0b11010, &ENTRY_ARCHEOLITHIC_14371745948924816941)],
    ),
    (
        crate::EncodedStr::Ascii("archaeologian"),
        &[(0b11010, &ENTRY_ARCHEOLOGIAN_11401650089021570001)],
    ),
    (
        crate::EncodedStr::Ascii("archaeometries"),
        &[(0b11010, &ENTRY_ARCHEOMETRIES_9109698910620640943)],
    ),
    (
        crate::EncodedStr::Ascii("archaeometry"),
        &[(0b11010, &ENTRY_ARCHEOMETRY_17067814741857159557)],
    ),
    (
        crate::EncodedStr::Ascii("archaeozic"),
        &[(0b11010, &ENTRY_ARCHEOZIC_9758294415454737448)],
    ),
    (
        crate::EncodedStr::Ascii("archaeozoic"),
        &[(0b11010, &ENTRY_ARCHEOZOIC_18268674600637414324)],
    ),
    (
        crate::EncodedStr::Ascii("archaeus"),
        &[(0b11010, &ENTRY_ARCHEUS_1328632190850149944)],
    ),
    (
        crate::EncodedStr::Ascii("archaise"),
        &[(0b10010, &ENTRY_ARCHAIZE_1359278578081430792)],
    ),
    (
        crate::EncodedStr::Ascii("archaised"),
        &[(0b10010, &ENTRY_ARCHAIZED_13322639529987334614)],
    ),
    (
        crate::EncodedStr::Ascii("archaiser"),
        &[(0b10010, &ENTRY_ARCHAIZER_13710837259267725318)],
    ),
    (
        crate::EncodedStr::Ascii("archaisers"),
        &[(0b10010, &ENTRY_ARCHAIZERS_6972696703859538503)],
    ),
    (
        crate::EncodedStr::Ascii("archaises"),
        &[(0b10010, &ENTRY_ARCHAIZES_4876579109305121157)],
    ),
    (
        crate::EncodedStr::Ascii("archaising"),
        &[(0b10010, &ENTRY_ARCHAIZING_3246941458311193300)],
    ),
    (
        crate::EncodedStr::Ascii("archaize"),
        &[(0b01001, &ENTRY_ARCHAIZE_1359278578081430792)],
    ),
    (
        crate::EncodedStr::Ascii("archaized"),
        &[(0b01001, &ENTRY_ARCHAIZED_13322639529987334614)],
    ),
    (
        crate::EncodedStr::Ascii("archaizer"),
        &[(0b01001, &ENTRY_ARCHAIZER_13710837259267725318)],
    ),
    (
        crate::EncodedStr::Ascii("archaizers"),
        &[(0b01001, &ENTRY_ARCHAIZERS_6972696703859538503)],
    ),
    (
        crate::EncodedStr::Ascii("archaizes"),
        &[(0b01001, &ENTRY_ARCHAIZES_4876579109305121157)],
    ),
    (
        crate::EncodedStr::Ascii("archaizing"),
        &[(0b01001, &ENTRY_ARCHAIZING_3246941458311193300)],
    ),
    (
        crate::EncodedStr::Ascii("arche"),
        &[(0b00001, &ENTRY_ARCHE_10156222017687532546)],
    ),
    (
        crate::EncodedStr::Ascii("archeal"),
        &[(0b10001, &ENTRY_ARCHEAL_6179901035862490669)],
    ),
    (
        crate::EncodedStr::Ascii("archean"),
        &[(0b10001, &ENTRY_ARCHEAN_14847398170729505321)],
    ),
    (
        crate::EncodedStr::Ascii("archei"),
        &[(0b10001, &ENTRY_ARCHEI_14186317656172516337)],
    ),
    (
        crate::EncodedStr::Ascii("archeoastronomies"),
        &[(0b10001, &ENTRY_ARCHEOASTRONOMIES_12672535196068691757)],
    ),
    (
        crate::EncodedStr::Ascii("archeoastronomy"),
        &[(0b10001, &ENTRY_ARCHEOASTRONOMY_7568086850104584418)],
    ),
    (
        crate::EncodedStr::Ascii("archeocyte"),
        &[(0b10001, &ENTRY_ARCHEOCYTE_544989770193462231)],
    ),
    (
        crate::EncodedStr::Ascii("archeol"),
        &[(0b10001, &ENTRY_ARCHEOL_1621301161575668294)],
    ),
    (
        crate::EncodedStr::Ascii("archeolithic"),
        &[(0b10001, &ENTRY_ARCHEOLITHIC_14371745948924816941)],
    ),
    (
        crate::EncodedStr::Ascii("archeologian"),
        &[(0b10001, &ENTRY_ARCHEOLOGIAN_11401650089021570001)],
    ),
    (
        crate::EncodedStr::Ascii("archeologic"),
        &[(0b11001, &ENTRY_ARCHAEOLOGIC_2454164999315616216)],
    ),
    (
        crate::EncodedStr::Ascii("archeological"),
        &[(0b11001, &ENTRY_ARCHAEOLOGICAL_5745535416676733106)],
    ),
    (
        crate::EncodedStr::Ascii("archeologies"),
        &[(0b11001, &ENTRY_ARCHAEOLOGIES_14568028250477257186)],
    ),
    (
        crate::EncodedStr::Ascii("archeologist"),
        &[(0b11001, &ENTRY_ARCHAEOLOGIST_15696704416854872606)],
    ),
    (
        crate::EncodedStr::Ascii("archeologists"),
        &[(0b11001, &ENTRY_ARCHAEOLOGISTS_10939394023447922447)],
    ),
    (
        crate::EncodedStr::Ascii("archeology"),
        &[(0b11001, &ENTRY_ARCHAEOLOGY_4126503997832873296)],
    ),
    (
        crate::EncodedStr::Ascii("archeometries"),
        &[(0b10001, &ENTRY_ARCHEOMETRIES_9109698910620640943)],
    ),
    (
        crate::EncodedStr::Ascii("archeometry"),
        &[(0b10001, &ENTRY_ARCHEOMETRY_17067814741857159557)],
    ),
    (
        crate::EncodedStr::Ascii("archeozic"),
        &[(0b10001, &ENTRY_ARCHEOZIC_9758294415454737448)],
    ),
    (
        crate::EncodedStr::Ascii("archeozoic"),
        &[(0b10001, &ENTRY_ARCHEOZOIC_18268674600637414324)],
    ),
    (
        crate::EncodedStr::Ascii("archeus"),
        &[(0b10001, &ENTRY_ARCHEUS_1328632190850149944)],
    ),
    (
        crate::EncodedStr::Ascii("arcticise"),
        &[(0b10010, &ENTRY_ARCTICIZE_14955043478793537404)],
    ),
    (
        crate::EncodedStr::Ascii("arcticises"),
        &[(0b10010, &ENTRY_ARCTICIZES_17488626861313077167)],
    ),
    (
        crate::EncodedStr::Ascii("arcticize"),
        &[(0b01001, &ENTRY_ARCTICIZE_14955043478793537404)],
    ),
    (
        crate::EncodedStr::Ascii("arcticizes"),
        &[(0b01001, &ENTRY_ARCTICIZES_17488626861313077167)],
    ),
    (
        crate::EncodedStr::Ascii("arctogaea"),
        &[(0b11010, &ENTRY_ARCTOGEA_15159053709851015323)],
    ),
    (
        crate::EncodedStr::Ascii("arctogaean"),
        &[(0b11010, &ENTRY_ARCTOGEAN_2216179672115771268)],
    ),
    (
        crate::EncodedStr::Ascii("arctogaeic"),
        &[(0b11010, &ENTRY_ARCTOGEIC_12166436575342886940)],
    ),
    (
        crate::EncodedStr::Ascii("arctogea"),
        &[(0b10001, &ENTRY_ARCTOGEA_15159053709851015323)],
    ),
    (
        crate::EncodedStr::Ascii("arctogean"),
        &[(0b10001, &ENTRY_ARCTOGEAN_2216179672115771268)],
    ),
    (
        crate::EncodedStr::Ascii("arctogeic"),
        &[(0b10001, &ENTRY_ARCTOGEIC_12166436575342886940)],
    ),
    (
        crate::EncodedStr::Ascii("ardor"),
        &[(0b11001, &ENTRY_ARDOR_16738479217548171426)],
    ),
    (
        crate::EncodedStr::Ascii("ardors"),
        &[(0b11001, &ENTRY_ARDORS_13859299160898289371)],
    ),
    (
        crate::EncodedStr::Ascii("ardour"),
        &[(0b11010, &ENTRY_ARDOR_16738479217548171426)],
    ),
    (
        crate::EncodedStr::Ascii("ardours"),
        &[(0b11010, &ENTRY_ARDORS_13859299160898289371)],
    ),
    (
        crate::EncodedStr::Ascii("areic"),
        &[(0b11010, &ENTRY_AERIC_17437245564230021595)],
    ),
    (
        crate::EncodedStr::Ascii("arenicolor"),
        &[(0b10001, &ENTRY_ARENICOLOR_4953462878754370500)],
    ),
    (
        crate::EncodedStr::Ascii("arenicolour"),
        &[(0b11010, &ENTRY_ARENICOLOR_4953462878754370500)],
    ),
    (
        crate::EncodedStr::Ascii("areographer"),
        &[(0b11010, &ENTRY_AEROGRAPHER_10717546778729152195)],
    ),
    (
        crate::EncodedStr::Ascii("areographic"),
        &[(0b11010, &ENTRY_AEROGRAPHIC_14818096080809523195)],
    ),
    (
        crate::EncodedStr::Ascii("areographical"),
        &[(0b11010, &ENTRY_AEROGRAPHICAL_2429273948734988881)],
    ),
    (
        crate::EncodedStr::Ascii("areographies"),
        &[(0b11010, &ENTRY_AEROGRAPHIES_11844593835635999782)],
    ),
    (
        crate::EncodedStr::Ascii("areography"),
        &[(0b11010, &ENTRY_AEROGRAPHY_8481321619438820366)],
    ),
    (
        crate::EncodedStr::Ascii("areolae"),
        &[(0b11010, &ENTRY_AREOLE_12338780936099127737)],
    ),
    (
        crate::EncodedStr::Ascii("areole"),
        &[(0b00001, &ENTRY_AREOLE_12338780936099127737)],
    ),
    (
        crate::EncodedStr::Ascii("areologic"),
        &[(0b11010, &ENTRY_AEROLOGIC_6581703267250668822)],
    ),
    (
        crate::EncodedStr::Ascii("areological"),
        &[(0b11010, &ENTRY_AEROLOGICAL_7035119647902064897)],
    ),
    (
        crate::EncodedStr::Ascii("areologies"),
        &[(0b11010, &ENTRY_AEROLOGIES_9303474410588856691)],
    ),
    (
        crate::EncodedStr::Ascii("areologist"),
        &[(0b11010, &ENTRY_AEROLOGIST_9043743609076361118)],
    ),
    (
        crate::EncodedStr::Ascii("areology"),
        &[(0b11010, &ENTRY_AEROLOGY_2536724281135360580)],
    ),
    (
        crate::EncodedStr::Ascii("areometer"),
        &[(0b11010, &ENTRY_AEROMETER_11742833131164166928)],
    ),
    (
        crate::EncodedStr::Ascii("areometers"),
        &[(0b11010, &ENTRY_AEROMETERS_18338221712051507310)],
    ),
    (
        crate::EncodedStr::Ascii("areometric"),
        &[
            (0b11010, &ENTRY_AEROMETRIC_13993414140130418477),
            (0b00001, &ENTRY_AREOMETRIC_17639504932600545758),
        ],
    ),
    (
        crate::EncodedStr::Ascii("areometrical"),
        &[(0b10001, &ENTRY_AREOMETRICAL_17718812079898847508)],
    ),
    (
        crate::EncodedStr::Ascii("areostyle"),
        &[(0b10001, &ENTRY_AREOSTYLE_9887341032000748494)],
    ),
    (
        crate::EncodedStr::Ascii("areostyles"),
        &[(0b10001, &ENTRY_AREOSTYLES_1673942835480908773)],
    ),
    (
        crate::EncodedStr::Ascii("areosystyle"),
        &[(0b00001, &ENTRY_AREOSYSTYLE_14135429367026377792)],
    ),
    (
        crate::EncodedStr::Ascii("arianise"),
        &[(0b10010, &ENTRY_ARIANIZE_1475808498118197849)],
    ),
    (
        crate::EncodedStr::Ascii("arianised"),
        &[(0b10010, &ENTRY_ARIANIZED_1259509742119549714)],
    ),
    (
        crate::EncodedStr::Ascii("arianises"),
        &[(0b10010, &ENTRY_ARIANIZES_14713941213590902805)],
    ),
    (
        crate::EncodedStr::Ascii("arianising"),
        &[(0b10010, &ENTRY_ARIANIZING_15061255978082885900)],
    ),
    (
        crate::EncodedStr::Ascii("arianize"),
        &[(0b01001, &ENTRY_ARIANIZE_1475808498118197849)],
    ),
    (
        crate::EncodedStr::Ascii("arianized"),
        &[(0b01001, &ENTRY_ARIANIZED_1259509742119549714)],
    ),
    (
        crate::EncodedStr::Ascii("arianizes"),
        &[(0b01001, &ENTRY_ARIANIZES_14713941213590902805)],
    ),
    (
        crate::EncodedStr::Ascii("arianizing"),
        &[(0b01001, &ENTRY_ARIANIZING_15061255978082885900)],
    ),
    (
        crate::EncodedStr::Ascii("arimathaea"),
        &[(0b11010, &ENTRY_ARIMATHEA_13006899549940341201)],
    ),
    (
        crate::EncodedStr::Ascii("arimathaean"),
        &[(0b11010, &ENTRY_ARIMATHEAN_16207104510661913460)],
    ),
    (
        crate::EncodedStr::Ascii("arimathea"),
        &[(0b10001, &ENTRY_ARIMATHEA_13006899549940341201)],
    ),
    (
        crate::EncodedStr::Ascii("arimathean"),
        &[(0b10001, &ENTRY_ARIMATHEAN_16207104510661913460)],
    ),
    (
        crate::EncodedStr::Ascii("aristae"),
        &[(0b11010, &ENTRY_ARISTE_4207971148573549326)],
    ),
    (
        crate::EncodedStr::Ascii("ariste"),
        &[(0b00001, &ENTRY_ARISTE_4207971148573549326)],
    ),
    (
        crate::EncodedStr::Ascii("arithmetisation"),
        &[(0b10010, &ENTRY_ARITHMETIZATION_10054898680334010685)],
    ),
    (
        crate::EncodedStr::Ascii("arithmetisations"),
        &[(0b10010, &ENTRY_ARITHMETIZATIONS_6133192991101865652)],
    ),
    (
        crate::EncodedStr::Ascii("arithmetise"),
        &[(0b10010, &ENTRY_ARITHMETIZE_15576026606241266299)],
    ),
    (
        crate::EncodedStr::Ascii("arithmetised"),
        &[(0b10010, &ENTRY_ARITHMETIZED_804241885225408901)],
    ),
    (
        crate::EncodedStr::Ascii("arithmetises"),
        &[(0b10010, &ENTRY_ARITHMETIZES_4021129694449874179)],
    ),
    (
        crate::EncodedStr::Ascii("arithmetization"),
        &[(0b01001, &ENTRY_ARITHMETIZATION_10054898680334010685)],
    ),
    (
        crate::EncodedStr::Ascii("arithmetizations"),
        &[(0b01001, &ENTRY_ARITHMETIZATIONS_6133192991101865652)],
    ),
    (
        crate::EncodedStr::Ascii("arithmetize"),
        &[(0b01001, &ENTRY_ARITHMETIZE_15576026606241266299)],
    ),
    (
        crate::EncodedStr::Ascii("arithmetized"),
        &[(0b01001, &ENTRY_ARITHMETIZED_804241885225408901)],
    ),
    (
        crate::EncodedStr::Ascii("arithmetizes"),
        &[(0b01001, &ENTRY_ARITHMETIZES_4021129694449874179)],
    ),
    (
        crate::EncodedStr::Ascii("armor"),
        &[(0b11001, &ENTRY_ARMOR_6791544457048582167)],
    ),
    (
        crate::EncodedStr::Ascii("armorbearer"),
        &[(0b11001, &ENTRY_ARMORBEARER_2157362197814652336)],
    ),
    (
        crate::EncodedStr::Ascii("armored"),
        &[(0b11001, &ENTRY_ARMORED_982936021759049572)],
    ),
    (
        crate::EncodedStr::Ascii("armorer"),
        &[(0b11001, &ENTRY_ARMORER_5772853517114648246)],
    ),
    (
        crate::EncodedStr::Ascii("armorers"),
        &[(0b11001, &ENTRY_ARMORERS_5671193923544706720)],
    ),
    (
        crate::EncodedStr::Ascii("armoried"),
        &[(0b11001, &ENTRY_ARMORIED_11535135214878289513)],
    ),
    (
        crate::EncodedStr::Ascii("armories"),
        &[(0b11001, &ENTRY_ARMORIES_4241896125070646795)],
    ),
    (
        crate::EncodedStr::Ascii("armoring"),
        &[(0b11001, &ENTRY_ARMORING_6447756068859055780)],
    ),
    (
        crate::EncodedStr::Ascii("armorless"),
        &[(0b11001, &ENTRY_ARMORLESS_17033530693523632986)],
    ),
    (
        crate::EncodedStr::Ascii("armors"),
        &[(0b11001, &ENTRY_ARMORS_8991902587170735735)],
    ),
    (
        crate::EncodedStr::Ascii("armory"),
        &[(0b11001, &ENTRY_ARMORY_16496001318701009580)],
    ),
    (
        crate::EncodedStr::Ascii("armour"),
        &[(0b11010, &ENTRY_ARMOR_6791544457048582167)],
    ),
    (
        crate::EncodedStr::Ascii("armourbearer"),
        &[(0b11010, &ENTRY_ARMORBEARER_2157362197814652336)],
    ),
    (
        crate::EncodedStr::Ascii("armoured"),
        &[(0b11010, &ENTRY_ARMORED_982936021759049572)],
    ),
    (
        crate::EncodedStr::Ascii("armourer"),
        &[(0b11010, &ENTRY_ARMORER_5772853517114648246)],
    ),
    (
        crate::EncodedStr::Ascii("armourers"),
        &[(0b11010, &ENTRY_ARMORERS_5671193923544706720)],
    ),
    (
        crate::EncodedStr::Ascii("armouried"),
        &[(0b11010, &ENTRY_ARMORIED_11535135214878289513)],
    ),
    (
        crate::EncodedStr::Ascii("armouries"),
        &[(0b11010, &ENTRY_ARMORIES_4241896125070646795)],
    ),
    (
        crate::EncodedStr::Ascii("armouring"),
        &[(0b11010, &ENTRY_ARMORING_6447756068859055780)],
    ),
    (
        crate::EncodedStr::Ascii("armourless"),
        &[(0b11010, &ENTRY_ARMORLESS_17033530693523632986)],
    ),
    (
        crate::EncodedStr::Ascii("armours"),
        &[(0b11010, &ENTRY_ARMORS_8991902587170735735)],
    ),
    (
        crate::EncodedStr::Ascii("armoury"),
        &[(0b11010, &ENTRY_ARMORY_16496001318701009580)],
    ),
    (
        crate::EncodedStr::Ascii("aromatisation"),
        &[(0b10010, &ENTRY_AROMATIZATION_2953688635914420328)],
    ),
    (
        crate::EncodedStr::Ascii("aromatise"),
        &[(0b10010, &ENTRY_AROMATIZE_14212398289764823606)],
    ),
    (
        crate::EncodedStr::Ascii("aromatised"),
        &[(0b10010, &ENTRY_AROMATIZED_11509335206222252539)],
    ),
    (
        crate::EncodedStr::Ascii("aromatiser"),
        &[(0b10010, &ENTRY_AROMATIZER_9784880273725424914)],
    ),
    (
        crate::EncodedStr::Ascii("aromatises"),
        &[(0b10010, &ENTRY_AROMATIZES_11689049401873834109)],
    ),
    (
        crate::EncodedStr::Ascii("aromatising"),
        &[(0b10010, &ENTRY_AROMATIZING_15725452162461845633)],
    ),
    (
        crate::EncodedStr::Ascii("aromatitae"),
        &[(0b11010, &ENTRY_AROMATITE_13587883584590217655)],
    ),
    (
        crate::EncodedStr::Ascii("aromatite"),
        &[(0b00001, &ENTRY_AROMATITE_13587883584590217655)],
    ),
    (
        crate::EncodedStr::Ascii("aromatization"),
        &[(0b01001, &ENTRY_AROMATIZATION_2953688635914420328)],
    ),
    (
        crate::EncodedStr::Ascii("aromatize"),
        &[(0b01001, &ENTRY_AROMATIZE_14212398289764823606)],
    ),
    (
        crate::EncodedStr::Ascii("aromatized"),
        &[(0b01001, &ENTRY_AROMATIZED_11509335206222252539)],
    ),
    (
        crate::EncodedStr::Ascii("aromatizer"),
        &[(0b01001, &ENTRY_AROMATIZER_9784880273725424914)],
    ),
    (
        crate::EncodedStr::Ascii("aromatizes"),
        &[(0b01001, &ENTRY_AROMATIZES_11689049401873834109)],
    ),
    (
        crate::EncodedStr::Ascii("aromatizing"),
        &[(0b01001, &ENTRY_AROMATIZING_15725452162461845633)],
    ),
    (
        crate::EncodedStr::Ascii("arse"),
        &[(0b11010, &ENTRY_ASS_3108967481325135828)],
    ),
    (
        crate::EncodedStr::Ascii("arsehole"),
        &[(0b11010, &ENTRY_ASSHOLE_12964338351998611148)],
    ),
    (
        crate::EncodedStr::Ascii("arseholes"),
        &[(0b11010, &ENTRY_ASSHOLES_13924057355694920061)],
    ),
    (
        crate::EncodedStr::Ascii("arsenicise"),
        &[(0b10010, &ENTRY_ARSENICIZE_13996042961629556869)],
    ),
    (
        crate::EncodedStr::Ascii("arsenicises"),
        &[(0b10010, &ENTRY_ARSENICIZES_1017198980814944191)],
    ),
    (
        crate::EncodedStr::Ascii("arsenicize"),
        &[(0b01001, &ENTRY_ARSENICIZE_13996042961629556869)],
    ),
    (
        crate::EncodedStr::Ascii("arsenicizes"),
        &[(0b01001, &ENTRY_ARSENICIZES_1017198980814944191)],
    ),
    (
        crate::EncodedStr::Ascii("arses"),
        &[(0b11010, &ENTRY_ASSES_13623663473667601400)],
    ),
    (
        crate::EncodedStr::Ascii("arsinoae"),
        &[(0b11010, &ENTRY_ARSINOE_18015403196399169984)],
    ),
    (
        crate::EncodedStr::Ascii("arsinoe"),
        &[(0b00001, &ENTRY_ARSINOE_18015403196399169984)],
    ),
    (
        crate::EncodedStr::Ascii("artefact"),
        &[(0b11010, &ENTRY_ARTIFACT_2827424156037909074)],
    ),
    (
        crate::EncodedStr::Ascii("artefacts"),
        &[(0b11010, &ENTRY_ARTIFACTS_3550024244562413823)],
    ),
    (
        crate::EncodedStr::Ascii("arterialisation"),
        &[(0b10010, &ENTRY_ARTERIALIZATION_17022790192875553359)],
    ),
    (
        crate::EncodedStr::Ascii("arterialisations"),
        &[(0b10010, &ENTRY_ARTERIALIZATIONS_3727765437552603830)],
    ),
    (
        crate::EncodedStr::Ascii("arterialise"),
        &[(0b10010, &ENTRY_ARTERIALIZE_4417484011804302892)],
    ),
    (
        crate::EncodedStr::Ascii("arterialised"),
        &[(0b10010, &ENTRY_ARTERIALIZED_10808091996021730739)],
    ),
    (
        crate::EncodedStr::Ascii("arterialises"),
        &[(0b10010, &ENTRY_ARTERIALIZES_2237218216825221904)],
    ),
    (
        crate::EncodedStr::Ascii("arterialising"),
        &[(0b10010, &ENTRY_ARTERIALIZING_7575251577380617319)],
    ),
    (
        crate::EncodedStr::Ascii("arterialization"),
        &[(0b01001, &ENTRY_ARTERIALIZATION_17022790192875553359)],
    ),
    (
        crate::EncodedStr::Ascii("arterializations"),
        &[(0b01001, &ENTRY_ARTERIALIZATIONS_3727765437552603830)],
    ),
    (
        crate::EncodedStr::Ascii("arterialize"),
        &[(0b01001, &ENTRY_ARTERIALIZE_4417484011804302892)],
    ),
    (
        crate::EncodedStr::Ascii("arterialized"),
        &[(0b01001, &ENTRY_ARTERIALIZED_10808091996021730739)],
    ),
    (
        crate::EncodedStr::Ascii("arterializes"),
        &[(0b01001, &ENTRY_ARTERIALIZES_2237218216825221904)],
    ),
    (
        crate::EncodedStr::Ascii("arterializing"),
        &[(0b01001, &ENTRY_ARTERIALIZING_7575251577380617319)],
    ),
    (
        crate::EncodedStr::Ascii("arthrempyesis"),
        &[(0b00001, &ENTRY_ARTHREMPYESIS_845595122000356547)],
    ),
    (
        crate::EncodedStr::Ascii("arthroempyesis"),
        &[(0b11010, &ENTRY_ARTHREMPYESIS_845595122000356547)],
    ),
    (
        crate::EncodedStr::Ascii("artifact"),
        &[(0b11001, &ENTRY_ARTIFACT_2827424156037909074)],
    ),
    (
        crate::EncodedStr::Ascii("artifacts"),
        &[(0b11001, &ENTRY_ARTIFACTS_3550024244562413823)],
    ),
    (
        crate::EncodedStr::Ascii("artificialise"),
        &[(0b10010, &ENTRY_ARTIFICIALIZE_6116923120575367102)],
    ),
    (
        crate::EncodedStr::Ascii("artificialised"),
        &[(0b10010, &ENTRY_ARTIFICIALIZED_3661622221795178801)],
    ),
    (
        crate::EncodedStr::Ascii("artificialises"),
        &[(0b10010, &ENTRY_ARTIFICIALIZES_12340528017967580371)],
    ),
    (
        crate::EncodedStr::Ascii("artificialising"),
        &[(0b10010, &ENTRY_ARTIFICIALIZING_6041141466863049208)],
    ),
    (
        crate::EncodedStr::Ascii("artificialize"),
        &[(0b01001, &ENTRY_ARTIFICIALIZE_6116923120575367102)],
    ),
    (
        crate::EncodedStr::Ascii("artificialized"),
        &[(0b01001, &ENTRY_ARTIFICIALIZED_3661622221795178801)],
    ),
    (
        crate::EncodedStr::Ascii("artificializes"),
        &[(0b01001, &ENTRY_ARTIFICIALIZES_12340528017967580371)],
    ),
    (
        crate::EncodedStr::Ascii("artificializing"),
        &[(0b01001, &ENTRY_ARTIFICIALIZING_6041141466863049208)],
    ),
    (
        crate::EncodedStr::Ascii("aryanisation"),
        &[(0b10010, &ENTRY_ARYANIZATION_9851944027750269067)],
    ),
    (
        crate::EncodedStr::Ascii("aryanise"),
        &[(0b10010, &ENTRY_ARYANIZE_16869282873759611476)],
    ),
    (
        crate::EncodedStr::Ascii("aryanised"),
        &[(0b10010, &ENTRY_ARYANIZED_2198024662554456823)],
    ),
    (
        crate::EncodedStr::Ascii("aryanises"),
        &[(0b10010, &ENTRY_ARYANIZES_1271531809715528591)],
    ),
    (
        crate::EncodedStr::Ascii("aryanising"),
        &[(0b10010, &ENTRY_ARYANIZING_14999690626685964985)],
    ),
    (
        crate::EncodedStr::Ascii("aryanization"),
        &[(0b01001, &ENTRY_ARYANIZATION_9851944027750269067)],
    ),
    (
        crate::EncodedStr::Ascii("aryanize"),
        &[(0b01001, &ENTRY_ARYANIZE_16869282873759611476)],
    ),
    (
        crate::EncodedStr::Ascii("aryanized"),
        &[(0b01001, &ENTRY_ARYANIZED_2198024662554456823)],
    ),
    (
        crate::EncodedStr::Ascii("aryanizes"),
        &[(0b01001, &ENTRY_ARYANIZES_1271531809715528591)],
    ),
    (
        crate::EncodedStr::Ascii("aryanizing"),
        &[(0b01001, &ENTRY_ARYANIZING_14999690626685964985)],
    ),
    (
        crate::EncodedStr::Ascii("arytaenoid"),
        &[(0b11010, &ENTRY_ARYTENOID_7001515572255686205)],
    ),
    (
        crate::EncodedStr::Ascii("arytaenoids"),
        &[(0b11010, &ENTRY_ARYTENOIDS_4570196976416030148)],
    ),
    (
        crate::EncodedStr::Ascii("arytenoid"),
        &[(0b00001, &ENTRY_ARYTENOID_7001515572255686205)],
    ),
    (
        crate::EncodedStr::Ascii("arytenoids"),
        &[(0b00001, &ENTRY_ARYTENOIDS_4570196976416030148)],
    ),
    (
        crate::EncodedStr::Ascii("asael"),
        &[(0b11010, &ENTRY_ASEL_2991140811333800185)],
    ),
    (
        crate::EncodedStr::Ascii("asafetida"),
        &[(0b01001, &ENTRY_ASAFETIDA_14075127292131066209)],
    ),
    (
        crate::EncodedStr::Ascii("asafetidas"),
        &[(0b01001, &ENTRY_ASAFETIDAS_3146529801559413940)],
    ),
    (
        crate::EncodedStr::Ascii("asafoetida"),
        &[(0b11010, &ENTRY_ASAFETIDA_14075127292131066209)],
    ),
    (
        crate::EncodedStr::Ascii("asafoetidas"),
        &[(0b11010, &ENTRY_ASAFETIDAS_3146529801559413940)],
    ),
    (
        crate::EncodedStr::Ascii("ascendency"),
        &[(0b01001, &ENTRY_ASCENDANCY_17212684530560634805)],
    ),
    (
        crate::EncodedStr::Ascii("ascendent"),
        &[(0b10011, &ENTRY_ASCENDANT_2752266460494779856)],
    ),
    (
        crate::EncodedStr::Ascii("ascendents"),
        &[(0b10011, &ENTRY_ASCENDANTS_15521170888856908309)],
    ),
    (
        crate::EncodedStr::Ascii("asclepiadae"),
        &[(0b11010, &ENTRY_ASCLEPIADE_10210677193219397680)],
    ),
    (
        crate::EncodedStr::Ascii("asclepiade"),
        &[(0b00001, &ENTRY_ASCLEPIADE_10210677193219397680)],
    ),
    (
        crate::EncodedStr::Ascii("asel"),
        &[(0b00001, &ENTRY_ASEL_2991140811333800185)],
    ),
    (
        crate::EncodedStr::Ascii("asepticise"),
        &[(0b10010, &ENTRY_ASEPTICIZE_3933929209320869926)],
    ),
    (
        crate::EncodedStr::Ascii("asepticised"),
        &[(0b10010, &ENTRY_ASEPTICIZED_17514342866645218287)],
    ),
    (
        crate::EncodedStr::Ascii("asepticises"),
        &[(0b10010, &ENTRY_ASEPTICIZES_18007236908793048941)],
    ),
    (
        crate::EncodedStr::Ascii("asepticising"),
        &[(0b10010, &ENTRY_ASEPTICIZING_16831292622846251458)],
    ),
    (
        crate::EncodedStr::Ascii("asepticize"),
        &[(0b01001, &ENTRY_ASEPTICIZE_3933929209320869926)],
    ),
    (
        crate::EncodedStr::Ascii("asepticized"),
        &[(0b01001, &ENTRY_ASEPTICIZED_17514342866645218287)],
    ),
    (
        crate::EncodedStr::Ascii("asepticizes"),
        &[(0b01001, &ENTRY_ASEPTICIZES_18007236908793048941)],
    ),
    (
        crate::EncodedStr::Ascii("asepticizing"),
        &[(0b01001, &ENTRY_ASEPTICIZING_16831292622846251458)],
    ),
    (
        crate::EncodedStr::Ascii("asexualisation"),
        &[(0b10010, &ENTRY_ASEXUALIZATION_15410884236551711164)],
    ),
    (
        crate::EncodedStr::Ascii("asexualise"),
        &[(0b10010, &ENTRY_ASEXUALIZE_9124079032501171431)],
    ),
    (
        crate::EncodedStr::Ascii("asexualised"),
        &[(0b10010, &ENTRY_ASEXUALIZED_7482569439479163307)],
    ),
    (
        crate::EncodedStr::Ascii("asexualising"),
        &[(0b10010, &ENTRY_ASEXUALIZING_12563154882147712490)],
    ),
    (
        crate::EncodedStr::Ascii("asexualization"),
        &[(0b01001, &ENTRY_ASEXUALIZATION_15410884236551711164)],
    ),
    (
        crate::EncodedStr::Ascii("asexualize"),
        &[(0b01001, &ENTRY_ASEXUALIZE_9124079032501171431)],
    ),
    (
        crate::EncodedStr::Ascii("asexualized"),
        &[(0b01001, &ENTRY_ASEXUALIZED_7482569439479163307)],
    ),
    (
        crate::EncodedStr::Ascii("asexualizing"),
        &[(0b01001, &ENTRY_ASEXUALIZING_12563154882147712490)],
    ),
    (
        crate::EncodedStr::Ascii("asiaticisation"),
        &[(0b10010, &ENTRY_ASIATICIZATION_4610120106437867166)],
    ),
    (
        crate::EncodedStr::Ascii("asiaticisations"),
        &[(0b10010, &ENTRY_ASIATICIZATIONS_12783056870942421620)],
    ),
    (
        crate::EncodedStr::Ascii("asiaticise"),
        &[(0b10010, &ENTRY_ASIATICIZE_17700168473976448799)],
    ),
    (
        crate::EncodedStr::Ascii("asiaticises"),
        &[(0b10010, &ENTRY_ASIATICIZES_16830856299856603906)],
    ),
    (
        crate::EncodedStr::Ascii("asiaticization"),
        &[(0b01001, &ENTRY_ASIATICIZATION_4610120106437867166)],
    ),
    (
        crate::EncodedStr::Ascii("asiaticizations"),
        &[(0b01001, &ENTRY_ASIATICIZATIONS_12783056870942421620)],
    ),
    (
        crate::EncodedStr::Ascii("asiaticize"),
        &[(0b01001, &ENTRY_ASIATICIZE_17700168473976448799)],
    ),
    (
        crate::EncodedStr::Ascii("asiaticizes"),
        &[(0b01001, &ENTRY_ASIATICIZES_16830856299856603906)],
    ),
    (
        crate::EncodedStr::Ascii("asmonaean"),
        &[(0b11010, &ENTRY_ASMONEAN_8413395248866854750)],
    ),
    (
        crate::EncodedStr::Ascii("asmonean"),
        &[(0b10001, &ENTRY_ASMONEAN_8413395248866854750)],
    ),
    (
        crate::EncodedStr::Ascii("aspheterise"),
        &[(0b10010, &ENTRY_ASPHETERIZE_16117159886415614048)],
    ),
    (
        crate::EncodedStr::Ascii("aspheterised"),
        &[(0b10010, &ENTRY_ASPHETERIZED_10290056046377700436)],
    ),
    (
        crate::EncodedStr::Ascii("aspheterises"),
        &[(0b10010, &ENTRY_ASPHETERIZES_14734322769410196190)],
    ),
    (
        crate::EncodedStr::Ascii("aspheterising"),
        &[(0b10010, &ENTRY_ASPHETERIZING_6898599003467614908)],
    ),
    (
        crate::EncodedStr::Ascii("aspheterize"),
        &[(0b01001, &ENTRY_ASPHETERIZE_16117159886415614048)],
    ),
    (
        crate::EncodedStr::Ascii("aspheterized"),
        &[(0b01001, &ENTRY_ASPHETERIZED_10290056046377700436)],
    ),
    (
        crate::EncodedStr::Ascii("aspheterizes"),
        &[(0b01001, &ENTRY_ASPHETERIZES_14734322769410196190)],
    ),
    (
        crate::EncodedStr::Ascii("aspheterizing"),
        &[(0b01001, &ENTRY_ASPHETERIZING_6898599003467614908)],
    ),
    (
        crate::EncodedStr::Ascii("assafetida"),
        &[(0b00001, &ENTRY_ASSAFETIDA_113224093999442010)],
    ),
    (
        crate::EncodedStr::Ascii("assafetidas"),
        &[(0b00001, &ENTRY_ASSAFETIDAS_15617703533170914973)],
    ),
    (
        crate::EncodedStr::Ascii("assafoetida"),
        &[(0b11010, &ENTRY_ASSAFETIDA_113224093999442010)],
    ),
    (
        crate::EncodedStr::Ascii("assafoetidas"),
        &[(0b11010, &ENTRY_ASSAFETIDAS_15617703533170914973)],
    ),
    (
        crate::EncodedStr::Ascii("asshole"),
        &[(0b00001, &ENTRY_ASSHOLE_12964338351998611148)],
    ),
    (
        crate::EncodedStr::Ascii("assholes"),
        &[(0b00001, &ENTRY_ASSHOLES_13924057355694920061)],
    ),
    (
        crate::EncodedStr::Ascii("assidaean"),
        &[(0b11010, &ENTRY_ASSIDEAN_4573494847516673943)],
    ),
    (
        crate::EncodedStr::Ascii("assidean"),
        &[(0b00001, &ENTRY_ASSIDEAN_4573494847516673943)],
    ),
    (
        crate::EncodedStr::Ascii("assyrianise"),
        &[(0b10010, &ENTRY_ASSYRIANIZE_9925515178117509112)],
    ),
    (
        crate::EncodedStr::Ascii("assyrianises"),
        &[(0b10010, &ENTRY_ASSYRIANIZES_1350783930464276444)],
    ),
    (
        crate::EncodedStr::Ascii("assyrianize"),
        &[(0b01001, &ENTRY_ASSYRIANIZE_9925515178117509112)],
    ),
    (
        crate::EncodedStr::Ascii("assyrianizes"),
        &[(0b01001, &ENTRY_ASSYRIANIZES_1350783930464276444)],
    ),
    (
        crate::EncodedStr::Ascii("astera"),
        &[(0b00001, &ENTRY_ASTERA_15037794719691540402)],
    ),
    (
        crate::EncodedStr::Ascii("astigmatiser"),
        &[(0b10010, &ENTRY_ASTIGMATIZER_5573446594967375201)],
    ),
    (
        crate::EncodedStr::Ascii("astigmatisers"),
        &[(0b10010, &ENTRY_ASTIGMATIZERS_18090102560636046522)],
    ),
    (
        crate::EncodedStr::Ascii("astigmatizer"),
        &[(0b01001, &ENTRY_ASTIGMATIZER_5573446594967375201)],
    ),
    (
        crate::EncodedStr::Ascii("astigmatizers"),
        &[(0b01001, &ENTRY_ASTIGMATIZERS_18090102560636046522)],
    ),
    (
        crate::EncodedStr::Ascii("astraea"),
        &[(0b11010, &ENTRY_ASTREA_9491635490797963619)],
    ),
    (
        crate::EncodedStr::Ascii("astraean"),
        &[(0b11010, &ENTRY_ASTREAN_17672754089710155278)],
    ),
    (
        crate::EncodedStr::Ascii("astrea"),
        &[
            (0b11010, &ENTRY_ASTERA_15037794719691540402),
            (0b00001, &ENTRY_ASTREA_9491635490797963619),
        ],
    ),
    (
        crate::EncodedStr::Ascii("astrean"),
        &[(0b00001, &ENTRY_ASTREAN_17672754089710155278)],
    ),
    (
        crate::EncodedStr::Ascii("astronomise"),
        &[(0b10010, &ENTRY_ASTRONOMIZE_8434822243027737838)],
    ),
    (
        crate::EncodedStr::Ascii("astronomised"),
        &[(0b10010, &ENTRY_ASTRONOMIZED_17892819808746658022)],
    ),
    (
        crate::EncodedStr::Ascii("astronomises"),
        &[(0b10010, &ENTRY_ASTRONOMIZES_3426897682798715707)],
    ),
    (
        crate::EncodedStr::Ascii("astronomising"),
        &[(0b10010, &ENTRY_ASTRONOMIZING_14727829167008307417)],
    ),
    (
        crate::EncodedStr::Ascii("astronomize"),
        &[(0b01001, &ENTRY_ASTRONOMIZE_8434822243027737838)],
    ),
    (
        crate::EncodedStr::Ascii("astronomized"),
        &[(0b01001, &ENTRY_ASTRONOMIZED_17892819808746658022)],
    ),
    (
        crate::EncodedStr::Ascii("astronomizes"),
        &[(0b01001, &ENTRY_ASTRONOMIZES_3426897682798715707)],
    ),
    (
        crate::EncodedStr::Ascii("astronomizing"),
        &[(0b01001, &ENTRY_ASTRONOMIZING_14727829167008307417)],
    ),
    (
        crate::EncodedStr::Ascii("asynchronise"),
        &[(0b10010, &ENTRY_ASYNCHRONIZE_3165012635702999054)],
    ),
    (
        crate::EncodedStr::Ascii("asynchronised"),
        &[(0b10010, &ENTRY_ASYNCHRONIZED_2264379807465924648)],
    ),
    (
        crate::EncodedStr::Ascii("asynchronises"),
        &[(0b10010, &ENTRY_ASYNCHRONIZES_4368864858861627592)],
    ),
    (
        crate::EncodedStr::Ascii("asynchronising"),
        &[(0b10010, &ENTRY_ASYNCHRONIZING_16727683109340331408)],
    ),
    (
        crate::EncodedStr::Ascii("asynchronize"),
        &[(0b01001, &ENTRY_ASYNCHRONIZE_3165012635702999054)],
    ),
    (
        crate::EncodedStr::Ascii("asynchronized"),
        &[(0b01001, &ENTRY_ASYNCHRONIZED_2264379807465924648)],
    ),
    (
        crate::EncodedStr::Ascii("asynchronizes"),
        &[(0b01001, &ENTRY_ASYNCHRONIZES_4368864858861627592)],
    ),
    (
        crate::EncodedStr::Ascii("asynchronizing"),
        &[(0b01001, &ENTRY_ASYNCHRONIZING_16727683109340331408)],
    ),
    (
        crate::EncodedStr::Ascii("atheise"),
        &[(0b10010, &ENTRY_ATHEIZE_1650523572049665618)],
    ),
    (
        crate::EncodedStr::Ascii("atheised"),
        &[(0b10010, &ENTRY_ATHEIZED_8361944679804490409)],
    ),
    (
        crate::EncodedStr::Ascii("atheises"),
        &[(0b10010, &ENTRY_ATHEIZES_131064789695988757)],
    ),
    (
        crate::EncodedStr::Ascii("atheising"),
        &[(0b10010, &ENTRY_ATHEIZING_3233601106148671334)],
    ),
    (
        crate::EncodedStr::Ascii("atheize"),
        &[(0b01001, &ENTRY_ATHEIZE_1650523572049665618)],
    ),
    (
        crate::EncodedStr::Ascii("atheized"),
        &[(0b01001, &ENTRY_ATHEIZED_8361944679804490409)],
    ),
    (
        crate::EncodedStr::Ascii("atheizes"),
        &[(0b01001, &ENTRY_ATHEIZES_131064789695988757)],
    ),
    (
        crate::EncodedStr::Ascii("atheizing"),
        &[(0b01001, &ENTRY_ATHEIZING_3233601106148671334)],
    ),
    (
        crate::EncodedStr::Ascii("athetise"),
        &[(0b10010, &ENTRY_ATHETIZE_16801924254921136220)],
    ),
    (
        crate::EncodedStr::Ascii("athetised"),
        &[(0b10010, &ENTRY_ATHETIZED_9779500563027955411)],
    ),
    (
        crate::EncodedStr::Ascii("athetises"),
        &[(0b10010, &ENTRY_ATHETIZES_3263174137872390116)],
    ),
    (
        crate::EncodedStr::Ascii("athetising"),
        &[(0b10010, &ENTRY_ATHETIZING_9191281724888382129)],
    ),
    (
        crate::EncodedStr::Ascii("athetize"),
        &[(0b01001, &ENTRY_ATHETIZE_16801924254921136220)],
    ),
    (
        crate::EncodedStr::Ascii("athetized"),
        &[(0b01001, &ENTRY_ATHETIZED_9779500563027955411)],
    ),
    (
        crate::EncodedStr::Ascii("athetizes"),
        &[(0b01001, &ENTRY_ATHETIZES_3263174137872390116)],
    ),
    (
        crate::EncodedStr::Ascii("athetizing"),
        &[(0b01001, &ENTRY_ATHETIZING_9191281724888382129)],
    ),
    (
        crate::EncodedStr::Ascii("atmolyse"),
        &[(0b10010, &ENTRY_ATMOLYZE_6907417165654906772)],
    ),
    (
        crate::EncodedStr::Ascii("atmolysed"),
        &[(0b10010, &ENTRY_ATMOLYZED_12772305670820601939)],
    ),
    (
        crate::EncodedStr::Ascii("atmolyses"),
        &[(0b10010, &ENTRY_ATMOLYZES_14417513048999254193)],
    ),
    (
        crate::EncodedStr::Ascii("atmolysing"),
        &[(0b10010, &ENTRY_ATMOLYZING_12067305970424863391)],
    ),
    (
        crate::EncodedStr::Ascii("atmolyze"),
        &[(0b01001, &ENTRY_ATMOLYZE_6907417165654906772)],
    ),
    (
        crate::EncodedStr::Ascii("atmolyzed"),
        &[(0b01001, &ENTRY_ATMOLYZED_12772305670820601939)],
    ),
    (
        crate::EncodedStr::Ascii("atmolyzes"),
        &[(0b01001, &ENTRY_ATMOLYZES_14417513048999254193)],
    ),
    (
        crate::EncodedStr::Ascii("atmolyzing"),
        &[(0b01001, &ENTRY_ATMOLYZING_12067305970424863391)],
    ),
    (
        crate::EncodedStr::Ascii("atomisability"),
        &[(0b10010, &ENTRY_ATOMIZABILITY_3662844297231153629)],
    ),
    (
        crate::EncodedStr::Ascii("atomisable"),
        &[(0b10010, &ENTRY_ATOMIZABLE_9006232702939622749)],
    ),
    (
        crate::EncodedStr::Ascii("atomisation"),
        &[(0b10010, &ENTRY_ATOMIZATION_17590563802310665738)],
    ),
    (
        crate::EncodedStr::Ascii("atomisations"),
        &[(0b10010, &ENTRY_ATOMIZATIONS_15654929944891871906)],
    ),
    (
        crate::EncodedStr::Ascii("atomise"),
        &[(0b10010, &ENTRY_ATOMIZE_2064605152651050847)],
    ),
    (
        crate::EncodedStr::Ascii("atomised"),
        &[(0b10010, &ENTRY_ATOMIZED_8537277580871094585)],
    ),
    (
        crate::EncodedStr::Ascii("atomiser"),
        &[(0b10010, &ENTRY_ATOMIZER_10420576678406032842)],
    ),
    (
        crate::EncodedStr::Ascii("atomisers"),
        &[(0b10010, &ENTRY_ATOMIZERS_14449646570970952892)],
    ),
    (
        crate::EncodedStr::Ascii("atomises"),
        &[(0b10010, &ENTRY_ATOMIZES_963643916071531136)],
    ),
    (
        crate::EncodedStr::Ascii("atomising"),
        &[(0b10010, &ENTRY_ATOMIZING_14986115038272633138)],
    ),
    (
        crate::EncodedStr::Ascii("atomizability"),
        &[(0b01001, &ENTRY_ATOMIZABILITY_3662844297231153629)],
    ),
    (
        crate::EncodedStr::Ascii("atomizable"),
        &[(0b01001, &ENTRY_ATOMIZABLE_9006232702939622749)],
    ),
    (
        crate::EncodedStr::Ascii("atomization"),
        &[(0b01001, &ENTRY_ATOMIZATION_17590563802310665738)],
    ),
    (
        crate::EncodedStr::Ascii("atomizations"),
        &[(0b01001, &ENTRY_ATOMIZATIONS_15654929944891871906)],
    ),
    (
        crate::EncodedStr::Ascii("atomize"),
        &[(0b01001, &ENTRY_ATOMIZE_2064605152651050847)],
    ),
    (
        crate::EncodedStr::Ascii("atomized"),
        &[(0b01001, &ENTRY_ATOMIZED_8537277580871094585)],
    ),
    (
        crate::EncodedStr::Ascii("atomizer"),
        &[(0b01001, &ENTRY_ATOMIZER_10420576678406032842)],
    ),
    (
        crate::EncodedStr::Ascii("atomizers"),
        &[(0b01001, &ENTRY_ATOMIZERS_14449646570970952892)],
    ),
    (
        crate::EncodedStr::Ascii("atomizes"),
        &[(0b01001, &ENTRY_ATOMIZES_963643916071531136)],
    ),
    (
        crate::EncodedStr::Ascii("atomizing"),
        &[(0b01001, &ENTRY_ATOMIZING_14986115038272633138)],
    ),
    (
        crate::EncodedStr::Ascii("atroceruleus"),
        &[(0b00001, &ENTRY_ATROCERULEUS_7452134384217065626)],
    ),
    (
        crate::EncodedStr::Ascii("atrocoeruleus"),
        &[(0b11010, &ENTRY_ATROCERULEUS_7452134384217065626)],
    ),
    (
        crate::EncodedStr::Ascii("attemper"),
        &[(0b00001, &ENTRY_ATTEMPER_10321595750792114646)],
    ),
    (
        crate::EncodedStr::Ascii("attempre"),
        &[(0b11010, &ENTRY_ATTEMPER_10321595750792114646)],
    ),
    (
        crate::EncodedStr::Ascii("atticise"),
        &[(0b10010, &ENTRY_ATTICIZE_10540291067079331794)],
    ),
    (
        crate::EncodedStr::Ascii("atticised"),
        &[(0b10010, &ENTRY_ATTICIZED_17898369434810945049)],
    ),
    (
        crate::EncodedStr::Ascii("atticises"),
        &[(0b10010, &ENTRY_ATTICIZES_7824093798291526926)],
    ),
    (
        crate::EncodedStr::Ascii("atticising"),
        &[(0b10010, &ENTRY_ATTICIZING_12115148616495024690)],
    ),
    (
        crate::EncodedStr::Ascii("atticize"),
        &[(0b01001, &ENTRY_ATTICIZE_10540291067079331794)],
    ),
    (
        crate::EncodedStr::Ascii("atticized"),
        &[(0b01001, &ENTRY_ATTICIZED_17898369434810945049)],
    ),
    (
        crate::EncodedStr::Ascii("atticizes"),
        &[(0b01001, &ENTRY_ATTICIZES_7824093798291526926)],
    ),
    (
        crate::EncodedStr::Ascii("atticizing"),
        &[(0b01001, &ENTRY_ATTICIZING_12115148616495024690)],
    ),
    (
        crate::EncodedStr::Ascii("attitudinisation"),
        &[(0b10010, &ENTRY_ATTITUDINIZATION_17706899523030773650)],
    ),
    (
        crate::EncodedStr::Ascii("attitudinise"),
        &[(0b10010, &ENTRY_ATTITUDINIZE_4708014689700982410)],
    ),
    (
        crate::EncodedStr::Ascii("attitudinised"),
        &[(0b10010, &ENTRY_ATTITUDINIZED_5404939483170560810)],
    ),
    (
        crate::EncodedStr::Ascii("attitudiniser"),
        &[(0b10010, &ENTRY_ATTITUDINIZER_2282587564825240743)],
    ),
    (
        crate::EncodedStr::Ascii("attitudinisers"),
        &[(0b10010, &ENTRY_ATTITUDINIZERS_11505676119055064972)],
    ),
    (
        crate::EncodedStr::Ascii("attitudinises"),
        &[(0b10010, &ENTRY_ATTITUDINIZES_4849080985867035260)],
    ),
    (
        crate::EncodedStr::Ascii("attitudinising"),
        &[(0b10010, &ENTRY_ATTITUDINIZING_3722680743543175700)],
    ),
    (
        crate::EncodedStr::Ascii("attitudinisings"),
        &[(0b10010, &ENTRY_ATTITUDINIZINGS_1081765832368849783)],
    ),
    (
        crate::EncodedStr::Ascii("attitudinization"),
        &[(0b01001, &ENTRY_ATTITUDINIZATION_17706899523030773650)],
    ),
    (
        crate::EncodedStr::Ascii("attitudinize"),
        &[(0b01001, &ENTRY_ATTITUDINIZE_4708014689700982410)],
    ),
    (
        crate::EncodedStr::Ascii("attitudinized"),
        &[(0b01001, &ENTRY_ATTITUDINIZED_5404939483170560810)],
    ),
    (
        crate::EncodedStr::Ascii("attitudinizer"),
        &[(0b01001, &ENTRY_ATTITUDINIZER_2282587564825240743)],
    ),
    (
        crate::EncodedStr::Ascii("attitudinizers"),
        &[(0b01001, &ENTRY_ATTITUDINIZERS_11505676119055064972)],
    ),
    (
        crate::EncodedStr::Ascii("attitudinizes"),
        &[(0b01001, &ENTRY_ATTITUDINIZES_4849080985867035260)],
    ),
    (
        crate::EncodedStr::Ascii("attitudinizing"),
        &[(0b01001, &ENTRY_ATTITUDINIZING_3722680743543175700)],
    ),
    (
        crate::EncodedStr::Ascii("attitudinizings"),
        &[(0b01001, &ENTRY_ATTITUDINIZINGS_1081765832368849783)],
    ),
    (
        crate::EncodedStr::Ascii("aunter"),
        &[(0b00001, &ENTRY_AUNTER_3984069006526724037)],
    ),
    (
        crate::EncodedStr::Ascii("auntre"),
        &[(0b11010, &ENTRY_AUNTER_3984069006526724037)],
    ),
    (
        crate::EncodedStr::Ascii("australianise"),
        &[(0b10010, &ENTRY_AUSTRALIANIZE_15680337575086561646)],
    ),
    (
        crate::EncodedStr::Ascii("australianises"),
        &[(0b10010, &ENTRY_AUSTRALIANIZES_15628526718481795434)],
    ),
    (
        crate::EncodedStr::Ascii("australianize"),
        &[(0b01001, &ENTRY_AUSTRALIANIZE_15680337575086561646)],
    ),
    (
        crate::EncodedStr::Ascii("australianizes"),
        &[(0b01001, &ENTRY_AUSTRALIANIZES_15628526718481795434)],
    ),
    (
        crate::EncodedStr::Ascii("australopithecinae"),
        &[(0b11010, &ENTRY_AUSTRALOPITHECINE_461885205668956581)],
    ),
    (
        crate::EncodedStr::Ascii("australopithecine"),
        &[(0b00001, &ENTRY_AUSTRALOPITHECINE_461885205668956581)],
    ),
    (
        crate::EncodedStr::Ascii("austrianise"),
        &[(0b10010, &ENTRY_AUSTRIANIZE_13889494210532044520)],
    ),
    (
        crate::EncodedStr::Ascii("austrianises"),
        &[(0b10010, &ENTRY_AUSTRIANIZES_15942538329526351866)],
    ),
    (
        crate::EncodedStr::Ascii("austrianize"),
        &[(0b01001, &ENTRY_AUSTRIANIZE_13889494210532044520)],
    ),
    (
        crate::EncodedStr::Ascii("austrianizes"),
        &[(0b01001, &ENTRY_AUSTRIANIZES_15942538329526351866)],
    ),
    (
        crate::EncodedStr::Ascii("autecious"),
        &[(0b00001, &ENTRY_AUTECIOUS_13333061310808681838)],
    ),
    (
        crate::EncodedStr::Ascii("auteciously"),
        &[(0b00001, &ENTRY_AUTECIOUSLY_14502261960323316507)],
    ),
    (
        crate::EncodedStr::Ascii("auteciousness"),
        &[(0b00001, &ENTRY_AUTECIOUSNESS_11976285547644733901)],
    ),
    (
        crate::EncodedStr::Ascii("autecism"),
        &[(0b00001, &ENTRY_AUTECISM_1715619165077149465)],
    ),
    (
        crate::EncodedStr::Ascii("autecisms"),
        &[(0b00001, &ENTRY_AUTECISMS_2180607123628399675)],
    ),
    (
        crate::EncodedStr::Ascii("autecy"),
        &[(0b00001, &ENTRY_AUTECY_13719576853502314463)],
    ),
    (
        crate::EncodedStr::Ascii("authorisable"),
        &[(0b10010, &ENTRY_AUTHORIZABLE_5231844717756889861)],
    ),
    (
        crate::EncodedStr::Ascii("authorisation"),
        &[(0b10010, &ENTRY_AUTHORIZATION_395843400641738718)],
    ),
    (
        crate::EncodedStr::Ascii("authorisations"),
        &[(0b10010, &ENTRY_AUTHORIZATIONS_3134679260837487294)],
    ),
    (
        crate::EncodedStr::Ascii("authorise"),
        &[(0b10010, &ENTRY_AUTHORIZE_12314763752837557145)],
    ),
    (
        crate::EncodedStr::Ascii("authorised"),
        &[(0b10010, &ENTRY_AUTHORIZED_2551432787313490355)],
    ),
    (
        crate::EncodedStr::Ascii("authoriser"),
        &[(0b10010, &ENTRY_AUTHORIZER_4327258003305487952)],
    ),
    (
        crate::EncodedStr::Ascii("authorisers"),
        &[(0b10010, &ENTRY_AUTHORIZERS_8627630439372760014)],
    ),
    (
        crate::EncodedStr::Ascii("authorises"),
        &[(0b10010, &ENTRY_AUTHORIZES_17496628475906077057)],
    ),
    (
        crate::EncodedStr::Ascii("authorising"),
        &[(0b10010, &ENTRY_AUTHORIZING_6195944790124186706)],
    ),
    (
        crate::EncodedStr::Ascii("authorizable"),
        &[(0b01001, &ENTRY_AUTHORIZABLE_5231844717756889861)],
    ),
    (
        crate::EncodedStr::Ascii("authorization"),
        &[(0b01001, &ENTRY_AUTHORIZATION_395843400641738718)],
    ),
    (
        crate::EncodedStr::Ascii("authorizations"),
        &[(0b01001, &ENTRY_AUTHORIZATIONS_3134679260837487294)],
    ),
    (
        crate::EncodedStr::Ascii("authorize"),
        &[(0b01001, &ENTRY_AUTHORIZE_12314763752837557145)],
    ),
    (
        crate::EncodedStr::Ascii("authorized"),
        &[(0b01001, &ENTRY_AUTHORIZED_2551432787313490355)],
    ),
    (
        crate::EncodedStr::Ascii("authorizer"),
        &[(0b01001, &ENTRY_AUTHORIZER_4327258003305487952)],
    ),
    (
        crate::EncodedStr::Ascii("authorizers"),
        &[(0b01001, &ENTRY_AUTHORIZERS_8627630439372760014)],
    ),
    (
        crate::EncodedStr::Ascii("authorizes"),
        &[(0b01001, &ENTRY_AUTHORIZES_17496628475906077057)],
    ),
    (
        crate::EncodedStr::Ascii("authorizing"),
        &[(0b01001, &ENTRY_AUTHORIZING_6195944790124186706)],
    ),
    (
        crate::EncodedStr::Ascii("autocatalyse"),
        &[(0b10010, &ENTRY_AUTOCATALYZE_11377656786611519467)],
    ),
    (
        crate::EncodedStr::Ascii("autocatalysed"),
        &[(0b10010, &ENTRY_AUTOCATALYZED_11100710334159127743)],
    ),
    (
        crate::EncodedStr::Ascii("autocatalyses"),
        &[(0b10010, &ENTRY_AUTOCATALYZES_5725738045167769178)],
    ),
    (
        crate::EncodedStr::Ascii("autocatalysing"),
        &[(0b10010, &ENTRY_AUTOCATALYZING_5159779918854952475)],
    ),
    (
        crate::EncodedStr::Ascii("autocatalyze"),
        &[(0b01001, &ENTRY_AUTOCATALYZE_11377656786611519467)],
    ),
    (
        crate::EncodedStr::Ascii("autocatalyzed"),
        &[(0b01001, &ENTRY_AUTOCATALYZED_11100710334159127743)],
    ),
    (
        crate::EncodedStr::Ascii("autocatalyzes"),
        &[(0b01001, &ENTRY_AUTOCATALYZES_5725738045167769178)],
    ),
    (
        crate::EncodedStr::Ascii("autocatalyzing"),
        &[(0b01001, &ENTRY_AUTOCATALYZING_5159779918854952475)],
    ),
    (
        crate::EncodedStr::Ascii("autodialer"),
        &[(0b00001, &ENTRY_AUTODIALER_1134450050813174093)],
    ),
    (
        crate::EncodedStr::Ascii("autodialler"),
        &[(0b11010, &ENTRY_AUTODIALER_1134450050813174093)],
    ),
    (
        crate::EncodedStr::Ascii("autoecious"),
        &[(0b11010, &ENTRY_AUTECIOUS_13333061310808681838)],
    ),
    (
        crate::EncodedStr::Ascii("autoeciously"),
        &[(0b11010, &ENTRY_AUTECIOUSLY_14502261960323316507)],
    ),
    (
        crate::EncodedStr::Ascii("autoeciousness"),
        &[(0b11010, &ENTRY_AUTECIOUSNESS_11976285547644733901)],
    ),
    (
        crate::EncodedStr::Ascii("autoecism"),
        &[(0b11010, &ENTRY_AUTECISM_1715619165077149465)],
    ),
    (
        crate::EncodedStr::Ascii("autoecisms"),
        &[(0b11010, &ENTRY_AUTECISMS_2180607123628399675)],
    ),
    (
        crate::EncodedStr::Ascii("autoecy"),
        &[(0b11010, &ENTRY_AUTECY_13719576853502314463)],
    ),
    (
        crate::EncodedStr::Ascii("autoimmunisation"),
        &[(0b10010, &ENTRY_AUTOIMMUNIZATION_9708656153855152039)],
    ),
    (
        crate::EncodedStr::Ascii("autoimmunization"),
        &[(0b01001, &ENTRY_AUTOIMMUNIZATION_9708656153855152039)],
    ),
    (
        crate::EncodedStr::Ascii("autoionisation"),
        &[(0b10010, &ENTRY_AUTOIONIZATION_6978369082999863184)],
    ),
    (
        crate::EncodedStr::Ascii("autoionization"),
        &[(0b01001, &ENTRY_AUTOIONIZATION_6978369082999863184)],
    ),
    (
        crate::EncodedStr::Ascii("autolysate"),
        &[(0b10010, &ENTRY_AUTOLYZATE_13897976732846843186)],
    ),
    (
        crate::EncodedStr::Ascii("autolysates"),
        &[(0b10010, &ENTRY_AUTOLYZATES_1225100042828836123)],
    ),
    (
        crate::EncodedStr::Ascii("autolyse"),
        &[(0b10010, &ENTRY_AUTOLYZE_11473855583949653238)],
    ),
    (
        crate::EncodedStr::Ascii("autolysed"),
        &[(0b10010, &ENTRY_AUTOLYZED_17033910730696642695)],
    ),
    (
        crate::EncodedStr::Ascii("autolyses"),
        &[(0b10010, &ENTRY_AUTOLYZES_15600692012613351200)],
    ),
    (
        crate::EncodedStr::Ascii("autolysing"),
        &[(0b10010, &ENTRY_AUTOLYZING_489296052443611874)],
    ),
    (
        crate::EncodedStr::Ascii("autolyzate"),
        &[(0b01001, &ENTRY_AUTOLYZATE_13897976732846843186)],
    ),
    (
        crate::EncodedStr::Ascii("autolyzates"),
        &[(0b01001, &ENTRY_AUTOLYZATES_1225100042828836123)],
    ),
    (
        crate::EncodedStr::Ascii("autolyze"),
        &[(0b01001, &ENTRY_AUTOLYZE_11473855583949653238)],
    ),
    (
        crate::EncodedStr::Ascii("autolyzed"),
        &[(0b01001, &ENTRY_AUTOLYZED_17033910730696642695)],
    ),
    (
        crate::EncodedStr::Ascii("autolyzes"),
        &[(0b01001, &ENTRY_AUTOLYZES_15600692012613351200)],
    ),
    (
        crate::EncodedStr::Ascii("autolyzing"),
        &[(0b01001, &ENTRY_AUTOLYZING_489296052443611874)],
    ),
    (
        crate::EncodedStr::Ascii("automatisation"),
        &[(0b10010, &ENTRY_AUTOMATIZATION_1620858880780330964)],
    ),
    (
        crate::EncodedStr::Ascii("automatisations"),
        &[(0b10010, &ENTRY_AUTOMATIZATIONS_619849714390905963)],
    ),
    (
        crate::EncodedStr::Ascii("automatise"),
        &[(0b10010, &ENTRY_AUTOMATIZE_7880401560635519882)],
    ),
    (
        crate::EncodedStr::Ascii("automatised"),
        &[(0b10010, &ENTRY_AUTOMATIZED_9571719111299962204)],
    ),
    (
        crate::EncodedStr::Ascii("automatises"),
        &[(0b10010, &ENTRY_AUTOMATIZES_9261149387605266072)],
    ),
    (
        crate::EncodedStr::Ascii("automatising"),
        &[(0b10010, &ENTRY_AUTOMATIZING_11897346773175064542)],
    ),
    (
        crate::EncodedStr::Ascii("automatization"),
        &[(0b01001, &ENTRY_AUTOMATIZATION_1620858880780330964)],
    ),
    (
        crate::EncodedStr::Ascii("automatizations"),
        &[(0b01001, &ENTRY_AUTOMATIZATIONS_619849714390905963)],
    ),
    (
        crate::EncodedStr::Ascii("automatize"),
        &[(0b01001, &ENTRY_AUTOMATIZE_7880401560635519882)],
    ),
    (
        crate::EncodedStr::Ascii("automatized"),
        &[(0b01001, &ENTRY_AUTOMATIZED_9571719111299962204)],
    ),
    (
        crate::EncodedStr::Ascii("automatizes"),
        &[(0b01001, &ENTRY_AUTOMATIZES_9261149387605266072)],
    ),
    (
        crate::EncodedStr::Ascii("automatizing"),
        &[(0b01001, &ENTRY_AUTOMATIZING_11897346773175064542)],
    ),
    (
        crate::EncodedStr::Ascii("autonoae"),
        &[(0b11010, &ENTRY_AUTONOE_11409143792101174133)],
    ),
    (
        crate::EncodedStr::Ascii("autonoe"),
        &[(0b00001, &ENTRY_AUTONOE_11409143792101174133)],
    ),
    (
        crate::EncodedStr::Ascii("autotomise"),
        &[(0b10010, &ENTRY_AUTOTOMIZE_10870376480991549462)],
    ),
    (
        crate::EncodedStr::Ascii("autotomised"),
        &[(0b10010, &ENTRY_AUTOTOMIZED_7590157601515171803)],
    ),
    (
        crate::EncodedStr::Ascii("autotomises"),
        &[(0b10010, &ENTRY_AUTOTOMIZES_9909588375372995524)],
    ),
    (
        crate::EncodedStr::Ascii("autotomising"),
        &[(0b10010, &ENTRY_AUTOTOMIZING_18376066296486340252)],
    ),
    (
        crate::EncodedStr::Ascii("autotomize"),
        &[(0b01001, &ENTRY_AUTOTOMIZE_10870376480991549462)],
    ),
    (
        crate::EncodedStr::Ascii("autotomized"),
        &[(0b01001, &ENTRY_AUTOTOMIZED_7590157601515171803)],
    ),
    (
        crate::EncodedStr::Ascii("autotomizes"),
        &[(0b01001, &ENTRY_AUTOTOMIZES_9909588375372995524)],
    ),
    (
        crate::EncodedStr::Ascii("autotomizing"),
        &[(0b01001, &ENTRY_AUTOTOMIZING_18376066296486340252)],
    ),
    (
        crate::EncodedStr::Ascii("autotoxaemia"),
        &[(0b11010, &ENTRY_AUTOTOXEMIA_18366267511576797743)],
    ),
    (
        crate::EncodedStr::Ascii("autotoxaemias"),
        &[(0b11010, &ENTRY_AUTOTOXEMIAS_3350713876222978889)],
    ),
    (
        crate::EncodedStr::Ascii("autotoxemia"),
        &[(0b00001, &ENTRY_AUTOTOXEMIA_18366267511576797743)],
    ),
    (
        crate::EncodedStr::Ascii("autotoxemias"),
        &[(0b00001, &ENTRY_AUTOTOXEMIAS_3350713876222978889)],
    ),
    (
        crate::EncodedStr::Ascii("avianise"),
        &[(0b10010, &ENTRY_AVIANIZE_10110854240867535999)],
    ),
    (
        crate::EncodedStr::Ascii("avianised"),
        &[(0b10010, &ENTRY_AVIANIZED_3624907102508634438)],
    ),
    (
        crate::EncodedStr::Ascii("avianises"),
        &[(0b10010, &ENTRY_AVIANIZES_6407105568503397650)],
    ),
    (
        crate::EncodedStr::Ascii("avianising"),
        &[(0b10010, &ENTRY_AVIANIZING_14608259848585895347)],
    ),
    (
        crate::EncodedStr::Ascii("avianize"),
        &[(0b01001, &ENTRY_AVIANIZE_10110854240867535999)],
    ),
    (
        crate::EncodedStr::Ascii("avianized"),
        &[(0b01001, &ENTRY_AVIANIZED_3624907102508634438)],
    ),
    (
        crate::EncodedStr::Ascii("avianizes"),
        &[(0b01001, &ENTRY_AVIANIZES_6407105568503397650)],
    ),
    (
        crate::EncodedStr::Ascii("avianizing"),
        &[(0b01001, &ENTRY_AVIANIZING_14608259848585895347)],
    ),
    (
        crate::EncodedStr::Ascii("avisandum"),
        &[(0b10010, &ENTRY_AVIZANDUM_15832266843653276586)],
    ),
    (
        crate::EncodedStr::Ascii("avisandums"),
        &[(0b10010, &ENTRY_AVIZANDUMS_10365146430390683692)],
    ),
    (
        crate::EncodedStr::Ascii("avise"),
        &[(0b10010, &ENTRY_AVIZE_558609699481267671)],
    ),
    (
        crate::EncodedStr::Ascii("avised"),
        &[(0b10010, &ENTRY_AVIZED_374462512849482817)],
    ),
    (
        crate::EncodedStr::Ascii("avises"),
        &[(0b10010, &ENTRY_AVIZES_4714530384314138108)],
    ),
    (
        crate::EncodedStr::Ascii("avising"),
        &[(0b10010, &ENTRY_AVIZING_3841969763676440589)],
    ),
    (
        crate::EncodedStr::Ascii("avizandum"),
        &[(0b01001, &ENTRY_AVIZANDUM_15832266843653276586)],
    ),
    (
        crate::EncodedStr::Ascii("avizandums"),
        &[(0b01001, &ENTRY_AVIZANDUMS_10365146430390683692)],
    ),
    (
        crate::EncodedStr::Ascii("avize"),
        &[(0b01001, &ENTRY_AVIZE_558609699481267671)],
    ),
    (
        crate::EncodedStr::Ascii("avized"),
        &[(0b01001, &ENTRY_AVIZED_374462512849482817)],
    ),
    (
        crate::EncodedStr::Ascii("avizes"),
        &[(0b01001, &ENTRY_AVIZES_4714530384314138108)],
    ),
    (
        crate::EncodedStr::Ascii("avizing"),
        &[(0b01001, &ENTRY_AVIZING_3841969763676440589)],
    ),
    (
        crate::EncodedStr::Ascii("ax"),
        &[(0b00001, &ENTRY_AX_1575519092942394335)],
    ),
    (
        crate::EncodedStr::Ascii("axe"),
        &[(0b11010, &ENTRY_AX_1575519092942394335)],
    ),
    (
        crate::EncodedStr::Ascii("axiomatisation"),
        &[(0b10010, &ENTRY_AXIOMATIZATION_2512913160865628279)],
    ),
    (
        crate::EncodedStr::Ascii("axiomatisations"),
        &[(0b10010, &ENTRY_AXIOMATIZATIONS_4377624432478694059)],
    ),
    (
        crate::EncodedStr::Ascii("axiomatise"),
        &[(0b10010, &ENTRY_AXIOMATIZE_10684888507156394817)],
    ),
    (
        crate::EncodedStr::Ascii("axiomatised"),
        &[(0b10010, &ENTRY_AXIOMATIZED_13606089758225327424)],
    ),
    (
        crate::EncodedStr::Ascii("axiomatises"),
        &[(0b10010, &ENTRY_AXIOMATIZES_8178035167309590431)],
    ),
    (
        crate::EncodedStr::Ascii("axiomatising"),
        &[(0b10010, &ENTRY_AXIOMATIZING_1265140579235398858)],
    ),
    (
        crate::EncodedStr::Ascii("axiomatization"),
        &[(0b01001, &ENTRY_AXIOMATIZATION_2512913160865628279)],
    ),
    (
        crate::EncodedStr::Ascii("axiomatizations"),
        &[(0b01001, &ENTRY_AXIOMATIZATIONS_4377624432478694059)],
    ),
    (
        crate::EncodedStr::Ascii("axiomatize"),
        &[(0b01001, &ENTRY_AXIOMATIZE_10684888507156394817)],
    ),
    (
        crate::EncodedStr::Ascii("axiomatized"),
        &[(0b01001, &ENTRY_AXIOMATIZED_13606089758225327424)],
    ),
    (
        crate::EncodedStr::Ascii("axiomatizes"),
        &[(0b01001, &ENTRY_AXIOMATIZES_8178035167309590431)],
    ),
    (
        crate::EncodedStr::Ascii("axiomatizing"),
        &[(0b01001, &ENTRY_AXIOMATIZING_1265140579235398858)],
    ),
    (
        crate::EncodedStr::Ascii("azotaemia"),
        &[(0b11010, &ENTRY_AZOTEMIA_11026435551695672571)],
    ),
    (
        crate::EncodedStr::Ascii("azotemia"),
        &[(0b00001, &ENTRY_AZOTEMIA_11026435551695672571)],
    ),
    (
        crate::EncodedStr::Ascii("azotisation"),
        &[(0b10010, &ENTRY_AZOTIZATION_16963563287305367427)],
    ),
    (
        crate::EncodedStr::Ascii("azotise"),
        &[(0b10010, &ENTRY_AZOTIZE_2287686933818550495)],
    ),
    (
        crate::EncodedStr::Ascii("azotised"),
        &[(0b10010, &ENTRY_AZOTIZED_5442413055636672930)],
    ),
    (
        crate::EncodedStr::Ascii("azotises"),
        &[(0b10010, &ENTRY_AZOTIZES_11787523905240626686)],
    ),
    (
        crate::EncodedStr::Ascii("azotising"),
        &[(0b10010, &ENTRY_AZOTIZING_14086470722290046366)],
    ),
    (
        crate::EncodedStr::Ascii("azotization"),
        &[(0b01001, &ENTRY_AZOTIZATION_16963563287305367427)],
    ),
    (
        crate::EncodedStr::Ascii("azotize"),
        &[(0b01001, &ENTRY_AZOTIZE_2287686933818550495)],
    ),
    (
        crate::EncodedStr::Ascii("azotized"),
        &[(0b01001, &ENTRY_AZOTIZED_5442413055636672930)],
    ),
    (
        crate::EncodedStr::Ascii("azotizes"),
        &[(0b01001, &ENTRY_AZOTIZES_11787523905240626686)],
    ),
    (
        crate::EncodedStr::Ascii("azotizing"),
        &[(0b01001, &ENTRY_AZOTIZING_14086470722290046366)],
    ),
    (
        crate::EncodedStr::Ascii("azotorrhea"),
        &[(0b00001, &ENTRY_AZOTORRHEA_15953136960912190838)],
    ),
    (
        crate::EncodedStr::Ascii("azotorrhoea"),
        &[(0b11010, &ENTRY_AZOTORRHEA_15953136960912190838)],
    ),
    (
        crate::EncodedStr::Ascii("babelisation"),
        &[(0b10010, &ENTRY_BABELIZATION_6227505335585113751)],
    ),
    (
        crate::EncodedStr::Ascii("babelise"),
        &[(0b10010, &ENTRY_BABELIZE_14685836478937353557)],
    ),
    (
        crate::EncodedStr::Ascii("babelised"),
        &[(0b10010, &ENTRY_BABELIZED_9260063960247770923)],
    ),
    (
        crate::EncodedStr::Ascii("babelising"),
        &[(0b10010, &ENTRY_BABELIZING_3570390515053010427)],
    ),
    (
        crate::EncodedStr::Ascii("babelization"),
        &[(0b01001, &ENTRY_BABELIZATION_6227505335585113751)],
    ),
    (
        crate::EncodedStr::Ascii("babelize"),
        &[(0b01001, &ENTRY_BABELIZE_14685836478937353557)],
    ),
    (
        crate::EncodedStr::Ascii("babelized"),
        &[(0b01001, &ENTRY_BABELIZED_9260063960247770923)],
    ),
    (
        crate::EncodedStr::Ascii("babelizing"),
        &[(0b01001, &ENTRY_BABELIZING_3570390515053010427)],
    ),
    (
        crate::EncodedStr::Ascii("babylonise"),
        &[(0b10010, &ENTRY_BABYLONIZE_11002600115818594610)],
    ),
    (
        crate::EncodedStr::Ascii("babylonises"),
        &[(0b10010, &ENTRY_BABYLONIZES_15691990922940613274)],
    ),
    (
        crate::EncodedStr::Ascii("babylonize"),
        &[(0b01001, &ENTRY_BABYLONIZE_11002600115818594610)],
    ),
    (
        crate::EncodedStr::Ascii("babylonizes"),
        &[(0b01001, &ENTRY_BABYLONIZES_15691990922940613274)],
    ),
    (
        crate::EncodedStr::Ascii("bachelorise"),
        &[(0b10010, &ENTRY_BACHELORIZE_16140957144715523023)],
    ),
    (
        crate::EncodedStr::Ascii("bachelorises"),
        &[(0b10010, &ENTRY_BACHELORIZES_18287548054552021920)],
    ),
    (
        crate::EncodedStr::Ascii("bachelorize"),
        &[(0b01001, &ENTRY_BACHELORIZE_16140957144715523023)],
    ),
    (
        crate::EncodedStr::Ascii("bachelorizes"),
        &[(0b01001, &ENTRY_BACHELORIZES_18287548054552021920)],
    ),
    (
        crate::EncodedStr::Ascii("bacillaemia"),
        &[(0b11010, &ENTRY_BACILLEMIA_6966726555392631595)],
    ),
    (
        crate::EncodedStr::Ascii("bacillaemias"),
        &[(0b11010, &ENTRY_BACILLEMIAS_5457140517144338455)],
    ),
    (
        crate::EncodedStr::Ascii("bacillemia"),
        &[(0b10001, &ENTRY_BACILLEMIA_6966726555392631595)],
    ),
    (
        crate::EncodedStr::Ascii("bacillemias"),
        &[(0b10001, &ENTRY_BACILLEMIAS_5457140517144338455)],
    ),
    (
        crate::EncodedStr::Ascii("backpedaled"),
        &[(0b00001, &ENTRY_BACKPEDALED_15080995488497192935)],
    ),
    (
        crate::EncodedStr::Ascii("backpedaling"),
        &[(0b00001, &ENTRY_BACKPEDALING_16889760085914099362)],
    ),
    (
        crate::EncodedStr::Ascii("backpedalled"),
        &[(0b11010, &ENTRY_BACKPEDALED_15080995488497192935)],
    ),
    (
        crate::EncodedStr::Ascii("backpedalling"),
        &[(0b11010, &ENTRY_BACKPEDALING_16889760085914099362)],
    ),
    (
        crate::EncodedStr::Ascii("baconise"),
        &[(0b10010, &ENTRY_BACONIZE_13936618010843734949)],
    ),
    (
        crate::EncodedStr::Ascii("baconises"),
        &[(0b10010, &ENTRY_BACONIZES_15492280776277479142)],
    ),
    (
        crate::EncodedStr::Ascii("baconize"),
        &[(0b01001, &ENTRY_BACONIZE_13936618010843734949)],
    ),
    (
        crate::EncodedStr::Ascii("baconizes"),
        &[(0b01001, &ENTRY_BACONIZES_15492280776277479142)],
    ),
    (
        crate::EncodedStr::Ascii("bacteraemia"),
        &[(0b11010, &ENTRY_BACTEREMIA_7447506279056258270)],
    ),
    (
        crate::EncodedStr::Ascii("bacteraemias"),
        &[(0b11010, &ENTRY_BACTEREMIAS_3485923405679674442)],
    ),
    (
        crate::EncodedStr::Ascii("bacteremia"),
        &[(0b10001, &ENTRY_BACTEREMIA_7447506279056258270)],
    ),
    (
        crate::EncodedStr::Ascii("bacteremias"),
        &[(0b10001, &ENTRY_BACTEREMIAS_3485923405679674442)],
    ),
    (
        crate::EncodedStr::Ascii("bacteriaemia"),
        &[(0b11010, &ENTRY_BACTERIEMIA_1013683590812100357)],
    ),
    (
        crate::EncodedStr::Ascii("bacterias"),
        &[(0b00001, &ENTRY_BACTERIA_932829979244663072)],
    ),
    (
        crate::EncodedStr::Ascii("bacteriemia"),
        &[(0b00001, &ENTRY_BACTERIEMIA_1013683590812100357)],
    ),
    (
        crate::EncodedStr::Ascii("bacterise"),
        &[(0b10010, &ENTRY_BACTERIZE_18408113064097816790)],
    ),
    (
        crate::EncodedStr::Ascii("bacterised"),
        &[(0b10010, &ENTRY_BACTERIZED_2369187923965453166)],
    ),
    (
        crate::EncodedStr::Ascii("bacterises"),
        &[(0b10010, &ENTRY_BACTERIZES_16999732192120374065)],
    ),
    (
        crate::EncodedStr::Ascii("bacterising"),
        &[(0b10010, &ENTRY_BACTERIZING_3356633906290065053)],
    ),
    (
        crate::EncodedStr::Ascii("bacterize"),
        &[(0b01001, &ENTRY_BACTERIZE_18408113064097816790)],
    ),
    (
        crate::EncodedStr::Ascii("bacterized"),
        &[(0b01001, &ENTRY_BACTERIZED_2369187923965453166)],
    ),
    (
        crate::EncodedStr::Ascii("bacterizes"),
        &[(0b01001, &ENTRY_BACTERIZES_16999732192120374065)],
    ),
    (
        crate::EncodedStr::Ascii("bacterizing"),
        &[(0b01001, &ENTRY_BACTERIZING_3356633906290065053)],
    ),
    (
        crate::EncodedStr::Ascii("bael"),
        &[(0b11010, &ENTRY_BEL_14468840991245400678)],
    ),
    (
        crate::EncodedStr::Ascii("baels"),
        &[(0b11010, &ENTRY_BELS_17074483974516039729)],
    ),
    (
        crate::EncodedStr::Ascii("baer"),
        &[(0b00001, &ENTRY_BAER_14581860992483818503)],
    ),
    (
        crate::EncodedStr::Ascii("baeria"),
        &[(0b11010, &ENTRY_BERIA_6249864324866743848)],
    ),
    (
        crate::EncodedStr::Ascii("baerl"),
        &[(0b11010, &ENTRY_BERL_1185444321092270619)],
    ),
    (
        crate::EncodedStr::Ascii("baeyer"),
        &[(0b11010, &ENTRY_BEYER_14898169439752870815)],
    ),
    (
        crate::EncodedStr::Ascii("balkanisation"),
        &[(0b10010, &ENTRY_BALKANIZATION_7162843825151431114)],
    ),
    (
        crate::EncodedStr::Ascii("balkanisations"),
        &[(0b10010, &ENTRY_BALKANIZATIONS_1102575160899563311)],
    ),
    (
        crate::EncodedStr::Ascii("balkanise"),
        &[(0b10010, &ENTRY_BALKANIZE_626464622875805915)],
    ),
    (
        crate::EncodedStr::Ascii("balkanised"),
        &[(0b10010, &ENTRY_BALKANIZED_7283200167845869640)],
    ),
    (
        crate::EncodedStr::Ascii("balkanises"),
        &[(0b10010, &ENTRY_BALKANIZES_15710898030250571993)],
    ),
    (
        crate::EncodedStr::Ascii("balkanising"),
        &[(0b10010, &ENTRY_BALKANIZING_2444358339203572953)],
    ),
    (
        crate::EncodedStr::Ascii("balkanization"),
        &[(0b01001, &ENTRY_BALKANIZATION_7162843825151431114)],
    ),
    (
        crate::EncodedStr::Ascii("balkanizations"),
        &[(0b01001, &ENTRY_BALKANIZATIONS_1102575160899563311)],
    ),
    (
        crate::EncodedStr::Ascii("balkanize"),
        &[(0b01001, &ENTRY_BALKANIZE_626464622875805915)],
    ),
    (
        crate::EncodedStr::Ascii("balkanized"),
        &[(0b01001, &ENTRY_BALKANIZED_7283200167845869640)],
    ),
    (
        crate::EncodedStr::Ascii("balkanizes"),
        &[(0b01001, &ENTRY_BALKANIZES_15710898030250571993)],
    ),
    (
        crate::EncodedStr::Ascii("balkanizing"),
        &[(0b01001, &ENTRY_BALKANIZING_2444358339203572953)],
    ),
    (
        crate::EncodedStr::Ascii("balladise"),
        &[(0b10010, &ENTRY_BALLADIZE_15696239668228025324)],
    ),
    (
        crate::EncodedStr::Ascii("balladised"),
        &[(0b10010, &ENTRY_BALLADIZED_2167734885988214874)],
    ),
    (
        crate::EncodedStr::Ascii("balladises"),
        &[(0b10010, &ENTRY_BALLADIZES_6866475825533925100)],
    ),
    (
        crate::EncodedStr::Ascii("balladising"),
        &[(0b10010, &ENTRY_BALLADIZING_3534870542470368404)],
    ),
    (
        crate::EncodedStr::Ascii("balladize"),
        &[(0b01001, &ENTRY_BALLADIZE_15696239668228025324)],
    ),
    (
        crate::EncodedStr::Ascii("balladized"),
        &[(0b01001, &ENTRY_BALLADIZED_2167734885988214874)],
    ),
    (
        crate::EncodedStr::Ascii("balladizes"),
        &[(0b01001, &ENTRY_BALLADIZES_6866475825533925100)],
    ),
    (
        crate::EncodedStr::Ascii("balladizing"),
        &[(0b01001, &ENTRY_BALLADIZING_3534870542470368404)],
    ),
    (
        crate::EncodedStr::Ascii("balsamise"),
        &[(0b10010, &ENTRY_BALSAMIZE_1201263166025813215)],
    ),
    (
        crate::EncodedStr::Ascii("balsamises"),
        &[(0b10010, &ENTRY_BALSAMIZES_9137778879856125866)],
    ),
    (
        crate::EncodedStr::Ascii("balsamize"),
        &[(0b01001, &ENTRY_BALSAMIZE_1201263166025813215)],
    ),
    (
        crate::EncodedStr::Ascii("balsamizes"),
        &[(0b01001, &ENTRY_BALSAMIZES_9137778879856125866)],
    ),
    (
        crate::EncodedStr::Ascii("banalisation"),
        &[(0b10010, &ENTRY_BANALIZATION_11638029989791824412)],
    ),
    (
        crate::EncodedStr::Ascii("banalisations"),
        &[(0b10010, &ENTRY_BANALIZATIONS_13442258248647777583)],
    ),
    (
        crate::EncodedStr::Ascii("banalise"),
        &[(0b10010, &ENTRY_BANALIZE_3555517535598908983)],
    ),
    (
        crate::EncodedStr::Ascii("banalised"),
        &[(0b10010, &ENTRY_BANALIZED_7402767891348368303)],
    ),
    (
        crate::EncodedStr::Ascii("banalises"),
        &[(0b10010, &ENTRY_BANALIZES_18046806542989340297)],
    ),
    (
        crate::EncodedStr::Ascii("banalising"),
        &[(0b10010, &ENTRY_BANALIZING_4703954921087288770)],
    ),
    (
        crate::EncodedStr::Ascii("banalization"),
        &[(0b01001, &ENTRY_BANALIZATION_11638029989791824412)],
    ),
    (
        crate::EncodedStr::Ascii("banalizations"),
        &[(0b01001, &ENTRY_BANALIZATIONS_13442258248647777583)],
    ),
    (
        crate::EncodedStr::Ascii("banalize"),
        &[(0b01001, &ENTRY_BANALIZE_3555517535598908983)],
    ),
    (
        crate::EncodedStr::Ascii("banalized"),
        &[(0b01001, &ENTRY_BANALIZED_7402767891348368303)],
    ),
    (
        crate::EncodedStr::Ascii("banalizes"),
        &[(0b01001, &ENTRY_BANALIZES_18046806542989340297)],
    ),
    (
        crate::EncodedStr::Ascii("banalizing"),
        &[(0b01001, &ENTRY_BANALIZING_4703954921087288770)],
    ),
    (
        crate::EncodedStr::Ascii("bantamise"),
        &[(0b10010, &ENTRY_BANTAMIZE_16291863723097401467)],
    ),
    (
        crate::EncodedStr::Ascii("bantamises"),
        &[(0b10010, &ENTRY_BANTAMIZES_12701524523935305027)],
    ),
    (
        crate::EncodedStr::Ascii("bantamize"),
        &[(0b01001, &ENTRY_BANTAMIZE_16291863723097401467)],
    ),
    (
        crate::EncodedStr::Ascii("bantamizes"),
        &[(0b01001, &ENTRY_BANTAMIZES_12701524523935305027)],
    ),
    (
        crate::EncodedStr::Ascii("baptisable"),
        &[(0b10010, &ENTRY_BAPTIZABLE_16415989175028506130)],
    ),
    (
        crate::EncodedStr::Ascii("baptisables"),
        &[(0b10010, &ENTRY_BAPTIZABLES_14971615946689154480)],
    ),
    (
        crate::EncodedStr::Ascii("baptise"),
        &[(0b10010, &ENTRY_BAPTIZE_1514931118124683391)],
    ),
    (
        crate::EncodedStr::Ascii("baptised"),
        &[(0b10010, &ENTRY_BAPTIZED_13515788660771621839)],
    ),
    (
        crate::EncodedStr::Ascii("baptisement"),
        &[(0b10010, &ENTRY_BAPTIZEMENT_738422419453567978)],
    ),
    (
        crate::EncodedStr::Ascii("baptisements"),
        &[(0b10010, &ENTRY_BAPTIZEMENTS_11049026893818752213)],
    ),
    (
        crate::EncodedStr::Ascii("baptiser"),
        &[(0b10010, &ENTRY_BAPTIZER_9063381427387950458)],
    ),
    (
        crate::EncodedStr::Ascii("baptisers"),
        &[(0b10010, &ENTRY_BAPTIZERS_10757448844252252817)],
    ),
    (
        crate::EncodedStr::Ascii("baptises"),
        &[(0b10010, &ENTRY_BAPTIZES_6929806982786773033)],
    ),
    (
        crate::EncodedStr::Ascii("baptising"),
        &[(0b10010, &ENTRY_BAPTIZING_13695168305550097810)],
    ),
    (
        crate::EncodedStr::Ascii("baptizable"),
        &[(0b01001, &ENTRY_BAPTIZABLE_16415989175028506130)],
    ),
    (
        crate::EncodedStr::Ascii("baptizables"),
        &[(0b01001, &ENTRY_BAPTIZABLES_14971615946689154480)],
    ),
    (
        crate::EncodedStr::Ascii("baptize"),
        &[(0b01001, &ENTRY_BAPTIZE_1514931118124683391)],
    ),
    (
        crate::EncodedStr::Ascii("baptized"),
        &[(0b01001, &ENTRY_BAPTIZED_13515788660771621839)],
    ),
    (
        crate::EncodedStr::Ascii("baptizement"),
        &[(0b01001, &ENTRY_BAPTIZEMENT_738422419453567978)],
    ),
    (
        crate::EncodedStr::Ascii("baptizements"),
        &[(0b01001, &ENTRY_BAPTIZEMENTS_11049026893818752213)],
    ),
    (
        crate::EncodedStr::Ascii("baptizer"),
        &[(0b01001, &ENTRY_BAPTIZER_9063381427387950458)],
    ),
    (
        crate::EncodedStr::Ascii("baptizers"),
        &[(0b01001, &ENTRY_BAPTIZERS_10757448844252252817)],
    ),
    (
        crate::EncodedStr::Ascii("baptizes"),
        &[(0b01001, &ENTRY_BAPTIZES_6929806982786773033)],
    ),
    (
        crate::EncodedStr::Ascii("baptizing"),
        &[(0b01001, &ENTRY_BAPTIZING_13695168305550097810)],
    ),
    (
        crate::EncodedStr::Ascii("barbarianise"),
        &[(0b10010, &ENTRY_BARBARIANIZE_15261658705914178060)],
    ),
    (
        crate::EncodedStr::Ascii("barbarianises"),
        &[(0b10010, &ENTRY_BARBARIANIZES_11395565352922752182)],
    ),
    (
        crate::EncodedStr::Ascii("barbarianize"),
        &[(0b01001, &ENTRY_BARBARIANIZE_15261658705914178060)],
    ),
    (
        crate::EncodedStr::Ascii("barbarianizes"),
        &[(0b01001, &ENTRY_BARBARIANIZES_11395565352922752182)],
    ),
    (
        crate::EncodedStr::Ascii("barbarisation"),
        &[(0b10010, &ENTRY_BARBARIZATION_637634415456611000)],
    ),
    (
        crate::EncodedStr::Ascii("barbarisations"),
        &[(0b10010, &ENTRY_BARBARIZATIONS_6457370917232767902)],
    ),
    (
        crate::EncodedStr::Ascii("barbarise"),
        &[(0b10010, &ENTRY_BARBARIZE_3245642365916369243)],
    ),
    (
        crate::EncodedStr::Ascii("barbarised"),
        &[(0b10010, &ENTRY_BARBARIZED_408182624919762132)],
    ),
    (
        crate::EncodedStr::Ascii("barbarises"),
        &[(0b10010, &ENTRY_BARBARIZES_7081317051698057651)],
    ),
    (
        crate::EncodedStr::Ascii("barbarising"),
        &[(0b10010, &ENTRY_BARBARIZING_9364260930235464394)],
    ),
    (
        crate::EncodedStr::Ascii("barbarization"),
        &[(0b01001, &ENTRY_BARBARIZATION_637634415456611000)],
    ),
    (
        crate::EncodedStr::Ascii("barbarizations"),
        &[(0b01001, &ENTRY_BARBARIZATIONS_6457370917232767902)],
    ),
    (
        crate::EncodedStr::Ascii("barbarize"),
        &[(0b01001, &ENTRY_BARBARIZE_3245642365916369243)],
    ),
    (
        crate::EncodedStr::Ascii("barbarized"),
        &[(0b01001, &ENTRY_BARBARIZED_408182624919762132)],
    ),
    (
        crate::EncodedStr::Ascii("barbarizes"),
        &[(0b01001, &ENTRY_BARBARIZES_7081317051698057651)],
    ),
    (
        crate::EncodedStr::Ascii("barbarizing"),
        &[(0b01001, &ENTRY_BARBARIZING_9364260930235464394)],
    ),
    (
        crate::EncodedStr::Ascii("bare"),
        &[(0b11010, &ENTRY_BAER_14581860992483818503)],
    ),
    (
        crate::EncodedStr::Ascii("baronetise"),
        &[(0b10010, &ENTRY_BARONETIZE_816321287514212290)],
    ),
    (
        crate::EncodedStr::Ascii("baronetised"),
        &[(0b10010, &ENTRY_BARONETIZED_15717984216308695709)],
    ),
    (
        crate::EncodedStr::Ascii("baronetising"),
        &[(0b10010, &ENTRY_BARONETIZING_3724487241546723880)],
    ),
    (
        crate::EncodedStr::Ascii("baronetize"),
        &[(0b01001, &ENTRY_BARONETIZE_816321287514212290)],
    ),
    (
        crate::EncodedStr::Ascii("baronetized"),
        &[(0b01001, &ENTRY_BARONETIZED_15717984216308695709)],
    ),
    (
        crate::EncodedStr::Ascii("baronetizing"),
        &[(0b01001, &ENTRY_BARONETIZING_3724487241546723880)],
    ),
    (
        crate::EncodedStr::Ascii("baronise"),
        &[(0b10010, &ENTRY_BARONIZE_14549807395279592595)],
    ),
    (
        crate::EncodedStr::Ascii("baronises"),
        &[(0b10010, &ENTRY_BARONIZES_2387447146173200401)],
    ),
    (
        crate::EncodedStr::Ascii("baronize"),
        &[(0b01001, &ENTRY_BARONIZE_14549807395279592595)],
    ),
    (
        crate::EncodedStr::Ascii("baronizes"),
        &[(0b01001, &ENTRY_BARONIZES_2387447146173200401)],
    ),
    (
        crate::EncodedStr::Ascii("barreled"),
        &[(0b00001, &ENTRY_BARRELED_771246087900113850)],
    ),
    (
        crate::EncodedStr::Ascii("barreling"),
        &[(0b00001, &ENTRY_BARRELING_14371038101917122463)],
    ),
    (
        crate::EncodedStr::Ascii("bartisan"),
        &[(0b10010, &ENTRY_BARTIZAN_3091667005685807749)],
    ),
    (
        crate::EncodedStr::Ascii("bartisaned"),
        &[(0b10010, &ENTRY_BARTIZANED_11308940237767481814)],
    ),
    (
        crate::EncodedStr::Ascii("bartisans"),
        &[(0b10010, &ENTRY_BARTIZANS_12739620651264432470)],
    ),
    (
        crate::EncodedStr::Ascii("bartizan"),
        &[(0b01001, &ENTRY_BARTIZAN_3091667005685807749)],
    ),
    (
        crate::EncodedStr::Ascii("bartizaned"),
        &[(0b01001, &ENTRY_BARTIZANED_11308940237767481814)],
    ),
    (
        crate::EncodedStr::Ascii("bartizans"),
        &[(0b01001, &ENTRY_BARTIZANS_12739620651264432470)],
    ),
    (
        crate::EncodedStr::Ascii("barycenter"),
        &[(0b00001, &ENTRY_BARYCENTER_18352620831248386358)],
    ),
    (
        crate::EncodedStr::Ascii("barycentre"),
        &[(0b11010, &ENTRY_BARYCENTER_18352620831248386358)],
    ),
    (
        crate::EncodedStr::Ascii("bastardisation"),
        &[(0b10010, &ENTRY_BASTARDIZATION_15150400898607735555)],
    ),
    (
        crate::EncodedStr::Ascii("bastardisations"),
        &[(0b10010, &ENTRY_BASTARDIZATIONS_13505445987148951791)],
    ),
    (
        crate::EncodedStr::Ascii("bastardise"),
        &[(0b10010, &ENTRY_BASTARDIZE_17168607737816618553)],
    ),
    (
        crate::EncodedStr::Ascii("bastardised"),
        &[(0b10010, &ENTRY_BASTARDIZED_15327063659865539383)],
    ),
    (
        crate::EncodedStr::Ascii("bastardises"),
        &[(0b10010, &ENTRY_BASTARDIZES_1734137171535573217)],
    ),
    (
        crate::EncodedStr::Ascii("bastardising"),
        &[(0b10010, &ENTRY_BASTARDIZING_4525888023760792804)],
    ),
    (
        crate::EncodedStr::Ascii("bastardization"),
        &[(0b01001, &ENTRY_BASTARDIZATION_15150400898607735555)],
    ),
    (
        crate::EncodedStr::Ascii("bastardizations"),
        &[(0b01001, &ENTRY_BASTARDIZATIONS_13505445987148951791)],
    ),
    (
        crate::EncodedStr::Ascii("bastardize"),
        &[(0b01001, &ENTRY_BASTARDIZE_17168607737816618553)],
    ),
    (
        crate::EncodedStr::Ascii("bastardized"),
        &[(0b01001, &ENTRY_BASTARDIZED_15327063659865539383)],
    ),
    (
        crate::EncodedStr::Ascii("bastardizes"),
        &[(0b01001, &ENTRY_BASTARDIZES_1734137171535573217)],
    ),
    (
        crate::EncodedStr::Ascii("bastardizing"),
        &[(0b01001, &ENTRY_BASTARDIZING_4525888023760792804)],
    ),
    (
        crate::EncodedStr::Ascii("bastinaded"),
        &[(0b00001, &ENTRY_BASTINADED_10916132116078316936)],
    ),
    (
        crate::EncodedStr::Ascii("bastinades"),
        &[(0b00001, &ENTRY_BASTINADES_16941290810871621543)],
    ),
    (
        crate::EncodedStr::Ascii("bastinadoed"),
        &[(0b11010, &ENTRY_BASTINADED_10916132116078316936)],
    ),
    (
        crate::EncodedStr::Ascii("bastinadoes"),
        &[(0b11010, &ENTRY_BASTINADES_16941290810871621543)],
    ),
    (
        crate::EncodedStr::Ascii("battleax"),
        &[(0b00001, &ENTRY_BATTLEAXE_15052343884109974687)],
    ),
    (
        crate::EncodedStr::Ascii("battologise"),
        &[(0b10010, &ENTRY_BATTOLOGIZE_12105586747261105341)],
    ),
    (
        crate::EncodedStr::Ascii("battologised"),
        &[(0b10010, &ENTRY_BATTOLOGIZED_12783274211026027611)],
    ),
    (
        crate::EncodedStr::Ascii("battologising"),
        &[(0b10010, &ENTRY_BATTOLOGIZING_6018370845171871626)],
    ),
    (
        crate::EncodedStr::Ascii("battologize"),
        &[(0b01001, &ENTRY_BATTOLOGIZE_12105586747261105341)],
    ),
    (
        crate::EncodedStr::Ascii("battologized"),
        &[(0b01001, &ENTRY_BATTOLOGIZED_12783274211026027611)],
    ),
    (
        crate::EncodedStr::Ascii("battologizing"),
        &[(0b01001, &ENTRY_BATTOLOGIZING_6018370845171871626)],
    ),
    (
        crate::EncodedStr::Ascii("baulk"),
        &[(0b10010, &ENTRY_BALK_16157341829373855465)],
    ),
    (
        crate::EncodedStr::Ascii("baulked"),
        &[(0b10010, &ENTRY_BALKED_13168474275010509248)],
    ),
    (
        crate::EncodedStr::Ascii("baulking"),
        &[(0b10010, &ENTRY_BALKING_4782897688469985529)],
    ),
    (
        crate::EncodedStr::Ascii("baulks"),
        &[(0b10010, &ENTRY_BALKS_15300503195053466242)],
    ),
    (
        crate::EncodedStr::Ascii("beaverise"),
        &[(0b10010, &ENTRY_BEAVERIZE_17666585249999378311)],
    ),
    (
        crate::EncodedStr::Ascii("beaverises"),
        &[(0b10010, &ENTRY_BEAVERIZES_3003655027714564574)],
    ),
    (
        crate::EncodedStr::Ascii("beaverize"),
        &[(0b01001, &ENTRY_BEAVERIZE_17666585249999378311)],
    ),
    (
        crate::EncodedStr::Ascii("beaverizes"),
        &[(0b01001, &ENTRY_BEAVERIZES_3003655027714564574)],
    ),
    (
        crate::EncodedStr::Ascii("beclamor"),
        &[(0b10001, &ENTRY_BECLAMOR_15010060560531866056)],
    ),
    (
        crate::EncodedStr::Ascii("beclamored"),
        &[(0b10001, &ENTRY_BECLAMORED_11429770894371708638)],
    ),
    (
        crate::EncodedStr::Ascii("beclamoring"),
        &[(0b10001, &ENTRY_BECLAMORING_9503333775494226894)],
    ),
    (
        crate::EncodedStr::Ascii("beclamors"),
        &[(0b10001, &ENTRY_BECLAMORS_13615720098742172165)],
    ),
    (
        crate::EncodedStr::Ascii("beclamour"),
        &[(0b11010, &ENTRY_BECLAMOR_15010060560531866056)],
    ),
    (
        crate::EncodedStr::Ascii("beclamoured"),
        &[(0b11010, &ENTRY_BECLAMORED_11429770894371708638)],
    ),
    (
        crate::EncodedStr::Ascii("beclamouring"),
        &[(0b11010, &ENTRY_BECLAMORING_9503333775494226894)],
    ),
    (
        crate::EncodedStr::Ascii("beclamours"),
        &[(0b11010, &ENTRY_BECLAMORS_13615720098742172165)],
    ),
    (
        crate::EncodedStr::Ascii("becolor"),
        &[(0b10001, &ENTRY_BECOLOR_1820125413532981726)],
    ),
    (
        crate::EncodedStr::Ascii("becolour"),
        &[(0b11010, &ENTRY_BECOLOR_1820125413532981726)],
    ),
    (
        crate::EncodedStr::Ascii("becudgeled"),
        &[(0b00001, &ENTRY_BECUDGELED_10688892400774535279)],
    ),
    (
        crate::EncodedStr::Ascii("becudgeling"),
        &[(0b00001, &ENTRY_BECUDGELING_2856359572329458860)],
    ),
    (
        crate::EncodedStr::Ascii("becudgelled"),
        &[(0b11010, &ENTRY_BECUDGELED_10688892400774535279)],
    ),
    (
        crate::EncodedStr::Ascii("becudgelling"),
        &[(0b11010, &ENTRY_BECUDGELING_2856359572329458860)],
    ),
    (
        crate::EncodedStr::Ascii("bedeviled"),
        &[(0b00001, &ENTRY_BEDEVILED_14137634025943909745)],
    ),
    (
        crate::EncodedStr::Ascii("bedeviling"),
        &[(0b00001, &ENTRY_BEDEVILING_3264516468398917500)],
    ),
    (
        crate::EncodedStr::Ascii("bedevilled"),
        &[(0b11010, &ENTRY_BEDEVILED_14137634025943909745)],
    ),
    (
        crate::EncodedStr::Ascii("bedevilling"),
        &[(0b11010, &ENTRY_BEDEVILING_3264516468398917500)],
    ),
    (
        crate::EncodedStr::Ascii("bedlamise"),
        &[(0b10010, &ENTRY_BEDLAMIZE_8032432031457666621)],
    ),
    (
        crate::EncodedStr::Ascii("bedlamised"),
        &[(0b10010, &ENTRY_BEDLAMIZED_8070235127373715475)],
    ),
    (
        crate::EncodedStr::Ascii("bedlamises"),
        &[(0b10010, &ENTRY_BEDLAMIZES_2905803091441936414)],
    ),
    (
        crate::EncodedStr::Ascii("bedlamising"),
        &[(0b10010, &ENTRY_BEDLAMIZING_5249207699535847866)],
    ),
    (
        crate::EncodedStr::Ascii("bedlamize"),
        &[(0b01001, &ENTRY_BEDLAMIZE_8032432031457666621)],
    ),
    (
        crate::EncodedStr::Ascii("bedlamized"),
        &[(0b01001, &ENTRY_BEDLAMIZED_8070235127373715475)],
    ),
    (
        crate::EncodedStr::Ascii("bedlamizes"),
        &[(0b01001, &ENTRY_BEDLAMIZES_2905803091441936414)],
    ),
    (
        crate::EncodedStr::Ascii("bedlamizing"),
        &[(0b01001, &ENTRY_BEDLAMIZING_5249207699535847866)],
    ),
    (
        crate::EncodedStr::Ascii("bedriveled"),
        &[(0b00001, &ENTRY_BEDRIVELED_16825680695984036015)],
    ),
    (
        crate::EncodedStr::Ascii("bedriveling"),
        &[(0b00001, &ENTRY_BEDRIVELING_12159930547505129231)],
    ),
    (
        crate::EncodedStr::Ascii("bedrivelled"),
        &[(0b11010, &ENTRY_BEDRIVELED_16825680695984036015)],
    ),
    (
        crate::EncodedStr::Ascii("bedrivelling"),
        &[(0b11010, &ENTRY_BEDRIVELING_12159930547505129231)],
    ),
    (
        crate::EncodedStr::Ascii("beera"),
        &[(0b00001, &ENTRY_BEERA_6010693163623887132)],
    ),
    (
        crate::EncodedStr::Ascii("befavor"),
        &[(0b10001, &ENTRY_BEFAVOR_4929864496662345763)],
    ),
    (
        crate::EncodedStr::Ascii("befavour"),
        &[(0b11010, &ENTRY_BEFAVOR_4929864496662345763)],
    ),
    (
        crate::EncodedStr::Ascii("beglamor"),
        &[(0b10001, &ENTRY_BEGLAMOR_13712112495668100470)],
    ),
    (
        crate::EncodedStr::Ascii("beglamored"),
        &[(0b10001, &ENTRY_BEGLAMORED_17236768717735314854)],
    ),
    (
        crate::EncodedStr::Ascii("beglamoring"),
        &[(0b10001, &ENTRY_BEGLAMORING_16675826950855681606)],
    ),
    (
        crate::EncodedStr::Ascii("beglamors"),
        &[(0b10001, &ENTRY_BEGLAMORS_12605296861327651664)],
    ),
    (
        crate::EncodedStr::Ascii("beglamour"),
        &[(0b11010, &ENTRY_BEGLAMOR_13712112495668100470)],
    ),
    (
        crate::EncodedStr::Ascii("beglamoured"),
        &[(0b11010, &ENTRY_BEGLAMORED_17236768717735314854)],
    ),
    (
        crate::EncodedStr::Ascii("beglamouring"),
        &[(0b11010, &ENTRY_BEGLAMORING_16675826950855681606)],
    ),
    (
        crate::EncodedStr::Ascii("beglamours"),
        &[(0b11010, &ENTRY_BEGLAMORS_12605296861327651664)],
    ),
    (
        crate::EncodedStr::Ascii("behavior"),
        &[(0b11001, &ENTRY_BEHAVIOR_14651200144504457213)],
    ),
    (
        crate::EncodedStr::Ascii("behavioral"),
        &[(0b11001, &ENTRY_BEHAVIORAL_16431863374575357094)],
    ),
    (
        crate::EncodedStr::Ascii("behavioraler"),
        &[(0b11001, &ENTRY_BEHAVIORALER_6184370577289856922)],
    ),
    (
        crate::EncodedStr::Ascii("behavioralest"),
        &[(0b11001, &ENTRY_BEHAVIORALEST_3631208384433367206)],
    ),
    (
        crate::EncodedStr::Ascii("behaviorally"),
        &[(0b11001, &ENTRY_BEHAVIORALLY_3392730520394326300)],
    ),
    (
        crate::EncodedStr::Ascii("behaviored"),
        &[(0b11001, &ENTRY_BEHAVIORED_496799855263187779)],
    ),
    (
        crate::EncodedStr::Ascii("behaviorism"),
        &[(0b11001, &ENTRY_BEHAVIORISM_4176615940346575759)],
    ),
    (
        crate::EncodedStr::Ascii("behaviorisms"),
        &[(0b11001, &ENTRY_BEHAVIORISMS_1554586755841111618)],
    ),
    (
        crate::EncodedStr::Ascii("behaviorist"),
        &[(0b11001, &ENTRY_BEHAVIORIST_5628596059711288582)],
    ),
    (
        crate::EncodedStr::Ascii("behavioristic"),
        &[(0b11001, &ENTRY_BEHAVIORISTIC_2362575912476199312)],
    ),
    (
        crate::EncodedStr::Ascii("behavioristicer"),
        &[(0b11001, &ENTRY_BEHAVIORISTICER_3955710407140770528)],
    ),
    (
        crate::EncodedStr::Ascii("behavioristicest"),
        &[(0b11001, &ENTRY_BEHAVIORISTICEST_9606870366866079149)],
    ),
    (
        crate::EncodedStr::Ascii("behavioristics"),
        &[(0b11001, &ENTRY_BEHAVIORISTICS_18376773413500646501)],
    ),
    (
        crate::EncodedStr::Ascii("behaviorists"),
        &[(0b11001, &ENTRY_BEHAVIORISTS_16129454263271072388)],
    ),
    (
        crate::EncodedStr::Ascii("behaviors"),
        &[(0b11001, &ENTRY_BEHAVIORS_3758424170765605620)],
    ),
    (
        crate::EncodedStr::Ascii("behaviour"),
        &[(0b11010, &ENTRY_BEHAVIOR_14651200144504457213)],
    ),
    (
        crate::EncodedStr::Ascii("behavioural"),
        &[(0b11010, &ENTRY_BEHAVIORAL_16431863374575357094)],
    ),
    (
        crate::EncodedStr::Ascii("behaviouraler"),
        &[(0b11010, &ENTRY_BEHAVIORALER_6184370577289856922)],
    ),
    (
        crate::EncodedStr::Ascii("behaviouralest"),
        &[(0b11010, &ENTRY_BEHAVIORALEST_3631208384433367206)],
    ),
    (
        crate::EncodedStr::Ascii("behaviourally"),
        &[(0b11010, &ENTRY_BEHAVIORALLY_3392730520394326300)],
    ),
    (
        crate::EncodedStr::Ascii("behavioured"),
        &[(0b11010, &ENTRY_BEHAVIORED_496799855263187779)],
    ),
    (
        crate::EncodedStr::Ascii("behaviourism"),
        &[(0b11010, &ENTRY_BEHAVIORISM_4176615940346575759)],
    ),
    (
        crate::EncodedStr::Ascii("behaviourisms"),
        &[(0b11010, &ENTRY_BEHAVIORISMS_1554586755841111618)],
    ),
    (
        crate::EncodedStr::Ascii("behaviourist"),
        &[(0b11010, &ENTRY_BEHAVIORIST_5628596059711288582)],
    ),
    (
        crate::EncodedStr::Ascii("behaviouristic"),
        &[(0b11010, &ENTRY_BEHAVIORISTIC_2362575912476199312)],
    ),
    (
        crate::EncodedStr::Ascii("behaviouristicer"),
        &[(0b11010, &ENTRY_BEHAVIORISTICER_3955710407140770528)],
    ),
    (
        crate::EncodedStr::Ascii("behaviouristicest"),
        &[(0b11010, &ENTRY_BEHAVIORISTICEST_9606870366866079149)],
    ),
    (
        crate::EncodedStr::Ascii("behaviouristics"),
        &[(0b11010, &ENTRY_BEHAVIORISTICS_18376773413500646501)],
    ),
    (
        crate::EncodedStr::Ascii("behaviourists"),
        &[(0b11010, &ENTRY_BEHAVIORISTS_16129454263271072388)],
    ),
    (
        crate::EncodedStr::Ascii("behaviours"),
        &[(0b11010, &ENTRY_BEHAVIORS_3758424170765605620)],
    ),
    (
        crate::EncodedStr::Ascii("behmenism"),
        &[(0b00001, &ENTRY_BEHMENISM_16450421455239972566)],
    ),
    (
        crate::EncodedStr::Ascii("behmenist"),
        &[(0b00001, &ENTRY_BEHMENIST_12053790631810257124)],
    ),
    (
        crate::EncodedStr::Ascii("behmenite"),
        &[(0b00001, &ENTRY_BEHMENITE_3335321400081704671)],
    ),
    (
        crate::EncodedStr::Ascii("behoove"),
        &[(0b01001, &ENTRY_BEHOOVE_6147219241654589987)],
    ),
    (
        crate::EncodedStr::Ascii("behooved"),
        &[(0b01001, &ENTRY_BEHOOVED_1655251573785223409)],
    ),
    (
        crate::EncodedStr::Ascii("behooves"),
        &[(0b01001, &ENTRY_BEHOOVES_3868425672448610419)],
    ),
    (
        crate::EncodedStr::Ascii("behooving"),
        &[(0b01001, &ENTRY_BEHOOVING_8088190138647815853)],
    ),
    (
        crate::EncodedStr::Ascii("behoovingly"),
        &[(0b00001, &ENTRY_BEHOOVINGLY_4751705039419506689)],
    ),
    (
        crate::EncodedStr::Ascii("behoovings"),
        &[(0b01001, &ENTRY_BEHOOVINGS_8205659410382773823)],
    ),
    (
        crate::EncodedStr::Ascii("behove"),
        &[(0b10010, &ENTRY_BEHOOVE_6147219241654589987)],
    ),
    (
        crate::EncodedStr::Ascii("behoved"),
        &[(0b10010, &ENTRY_BEHOOVED_1655251573785223409)],
    ),
    (
        crate::EncodedStr::Ascii("behoves"),
        &[(0b10010, &ENTRY_BEHOOVES_3868425672448610419)],
    ),
    (
        crate::EncodedStr::Ascii("behoving"),
        &[(0b10010, &ENTRY_BEHOOVING_8088190138647815853)],
    ),
    (
        crate::EncodedStr::Ascii("behovingly"),
        &[(0b11010, &ENTRY_BEHOOVINGLY_4751705039419506689)],
    ),
    (
        crate::EncodedStr::Ascii("behovings"),
        &[(0b10010, &ENTRY_BEHOOVINGS_8205659410382773823)],
    ),
    (
        crate::EncodedStr::Ascii("bejeweled"),
        &[(0b00001, &ENTRY_BEJEWELED_4984569160882024545)],
    ),
    (
        crate::EncodedStr::Ascii("bejeweling"),
        &[(0b00001, &ENTRY_BEJEWELING_6307871362607074541)],
    ),
    (
        crate::EncodedStr::Ascii("bejewelled"),
        &[(0b11010, &ENTRY_BEJEWELED_4984569160882024545)],
    ),
    (
        crate::EncodedStr::Ascii("bejewelling"),
        &[(0b11010, &ENTRY_BEJEWELING_6307871362607074541)],
    ),
    (
        crate::EncodedStr::Ascii("bel"),
        &[(0b00001, &ENTRY_BEL_14468840991245400678)],
    ),
    (
        crate::EncodedStr::Ascii("belabor"),
        &[(0b11001, &ENTRY_BELABOR_9577593579762971199)],
    ),
    (
        crate::EncodedStr::Ascii("belabored"),
        &[(0b11001, &ENTRY_BELABORED_2071671744170951559)],
    ),
    (
        crate::EncodedStr::Ascii("belaboring"),
        &[(0b11001, &ENTRY_BELABORING_1181160254749158200)],
    ),
    (
        crate::EncodedStr::Ascii("belabors"),
        &[(0b11001, &ENTRY_BELABORS_6186916057783206938)],
    ),
    (
        crate::EncodedStr::Ascii("belabour"),
        &[(0b11010, &ENTRY_BELABOR_9577593579762971199)],
    ),
    (
        crate::EncodedStr::Ascii("belaboured"),
        &[(0b11010, &ENTRY_BELABORED_2071671744170951559)],
    ),
    (
        crate::EncodedStr::Ascii("belabouring"),
        &[(0b11010, &ENTRY_BELABORING_1181160254749158200)],
    ),
    (
        crate::EncodedStr::Ascii("belabours"),
        &[(0b11010, &ENTRY_BELABORS_6186916057783206938)],
    ),
    (
        crate::EncodedStr::Ascii("bels"),
        &[(0b00001, &ENTRY_BELS_17074483974516039729)],
    ),
    (
        crate::EncodedStr::Ascii("belter"),
        &[(0b00001, &ENTRY_BELTER_6595324842513246324)],
    ),
    (
        crate::EncodedStr::Ascii("belus"),
        &[(0b00001, &ENTRY_BELUS_10707973760047908555)],
    ),
    (
        crate::EncodedStr::Ascii("bemedaled"),
        &[(0b00001, &ENTRY_BEMEDALED_11565185958895431981)],
    ),
    (
        crate::EncodedStr::Ascii("bemedalled"),
        &[(0b11010, &ENTRY_BEMEDALED_11565185958895431981)],
    ),
    (
        crate::EncodedStr::Ascii("berea"),
        &[(0b11010, &ENTRY_BEERA_6010693163623887132)],
    ),
    (
        crate::EncodedStr::Ascii("beria"),
        &[(0b00001, &ENTRY_BERIA_6249864324866743848)],
    ),
    (
        crate::EncodedStr::Ascii("berl"),
        &[(0b00001, &ENTRY_BERL_1185444321092270619)],
    ),
    (
        crate::EncodedStr::Ascii("berlinise"),
        &[(0b10010, &ENTRY_BERLINIZE_15633104344359694284)],
    ),
    (
        crate::EncodedStr::Ascii("berlinises"),
        &[(0b10010, &ENTRY_BERLINIZES_5780526359977067580)],
    ),
    (
        crate::EncodedStr::Ascii("berlinize"),
        &[(0b01001, &ENTRY_BERLINIZE_15633104344359694284)],
    ),
    (
        crate::EncodedStr::Ascii("berlinizes"),
        &[(0b01001, &ENTRY_BERLINIZES_5780526359977067580)],
    ),
    (
        crate::EncodedStr::Ascii("berloque"),
        &[(0b00001, &ENTRY_BERLOQUE_16973140256876933299)],
    ),
    (
        crate::EncodedStr::Ascii("berme"),
        &[(0b00001, &ENTRY_BERME_13467983052397932132)],
    ),
    (
        crate::EncodedStr::Ascii("bern"),
        &[(0b00001, &ENTRY_BERN_9411483658541257171)],
    ),
    (
        crate::EncodedStr::Ascii("bessemerise"),
        &[(0b10010, &ENTRY_BESSEMERIZE_14474112216075710864)],
    ),
    (
        crate::EncodedStr::Ascii("bessemerises"),
        &[(0b10010, &ENTRY_BESSEMERIZES_6207831075537789134)],
    ),
    (
        crate::EncodedStr::Ascii("bessemerize"),
        &[(0b01001, &ENTRY_BESSEMERIZE_14474112216075710864)],
    ),
    (
        crate::EncodedStr::Ascii("bessemerizes"),
        &[(0b01001, &ENTRY_BESSEMERIZES_6207831075537789134)],
    ),
    (
        crate::EncodedStr::Ascii("bestialise"),
        &[(0b10010, &ENTRY_BESTIALIZE_3056063670726597576)],
    ),
    (
        crate::EncodedStr::Ascii("bestialised"),
        &[(0b10010, &ENTRY_BESTIALIZED_9547393233273320821)],
    ),
    (
        crate::EncodedStr::Ascii("bestialises"),
        &[(0b10010, &ENTRY_BESTIALIZES_1393652725255993657)],
    ),
    (
        crate::EncodedStr::Ascii("bestialising"),
        &[(0b10010, &ENTRY_BESTIALIZING_3683935903600606612)],
    ),
    (
        crate::EncodedStr::Ascii("bestialize"),
        &[(0b01001, &ENTRY_BESTIALIZE_3056063670726597576)],
    ),
    (
        crate::EncodedStr::Ascii("bestialized"),
        &[(0b01001, &ENTRY_BESTIALIZED_9547393233273320821)],
    ),
    (
        crate::EncodedStr::Ascii("bestializes"),
        &[(0b01001, &ENTRY_BESTIALIZES_1393652725255993657)],
    ),
    (
        crate::EncodedStr::Ascii("bestializing"),
        &[(0b01001, &ENTRY_BESTIALIZING_3683935903600606612)],
    ),
    (
        crate::EncodedStr::Ascii("beveled"),
        &[(0b01001, &ENTRY_BEVELED_464364200154775119)],
    ),
    (
        crate::EncodedStr::Ascii("beveler"),
        &[(0b01001, &ENTRY_BEVELER_2560516573011394819)],
    ),
    (
        crate::EncodedStr::Ascii("bevelers"),
        &[(0b01001, &ENTRY_BEVELERS_9232933359348996649)],
    ),
    (
        crate::EncodedStr::Ascii("beveling"),
        &[(0b01001, &ENTRY_BEVELING_10855109562149223001)],
    ),
    (
        crate::EncodedStr::Ascii("bevelings"),
        &[(0b01001, &ENTRY_BEVELINGS_2452856377064833303)],
    ),
    (
        crate::EncodedStr::Ascii("bevelled"),
        &[(0b11010, &ENTRY_BEVELED_464364200154775119)],
    ),
    (
        crate::EncodedStr::Ascii("beveller"),
        &[(0b11010, &ENTRY_BEVELER_2560516573011394819)],
    ),
    (
        crate::EncodedStr::Ascii("bevellers"),
        &[(0b11010, &ENTRY_BEVELERS_9232933359348996649)],
    ),
    (
        crate::EncodedStr::Ascii("bevelling"),
        &[(0b11010, &ENTRY_BEVELING_10855109562149223001)],
    ),
    (
        crate::EncodedStr::Ascii("bevellings"),
        &[(0b11010, &ENTRY_BEVELINGS_2452856377064833303)],
    ),
    (
        crate::EncodedStr::Ascii("beyer"),
        &[(0b00001, &ENTRY_BEYER_14898169439752870815)],
    ),
    (
        crate::EncodedStr::Ascii("biassed"),
        &[(0b10011, &ENTRY_BIASED_1791974261124589682)],
    ),
    (
        crate::EncodedStr::Ascii("biassing"),
        &[(0b10011, &ENTRY_BIASING_6997021477668826126)],
    ),
    (
        crate::EncodedStr::Ascii("bichromatise"),
        &[(0b10010, &ENTRY_BICHROMATIZE_6575837359582309819)],
    ),
    (
        crate::EncodedStr::Ascii("bichromatises"),
        &[(0b10010, &ENTRY_BICHROMATIZES_11938767258104126504)],
    ),
    (
        crate::EncodedStr::Ascii("bichromatize"),
        &[(0b01001, &ENTRY_BICHROMATIZE_6575837359582309819)],
    ),
    (
        crate::EncodedStr::Ascii("bichromatizes"),
        &[(0b01001, &ENTRY_BICHROMATIZES_11938767258104126504)],
    ),
    (
        crate::EncodedStr::Ascii("bicolor"),
        &[(0b10001, &ENTRY_BICOLOR_10164358994113091705)],
    ),
    (
        crate::EncodedStr::Ascii("bicolored"),
        &[(0b10001, &ENTRY_BICOLORED_434708862208065723)],
    ),
    (
        crate::EncodedStr::Ascii("bicoloredder"),
        &[(0b10001, &ENTRY_BICOLOREDDER_8362361841051385390)],
    ),
    (
        crate::EncodedStr::Ascii("bicoloreddest"),
        &[(0b10001, &ENTRY_BICOLOREDDEST_8676331588438394982)],
    ),
    (
        crate::EncodedStr::Ascii("bicolorous"),
        &[(0b00001, &ENTRY_BICOLOROUS_9012574496998947343)],
    ),
    (
        crate::EncodedStr::Ascii("bicolorrer"),
        &[(0b10001, &ENTRY_BICOLORRER_5653522831142191999)],
    ),
    (
        crate::EncodedStr::Ascii("bicolorrest"),
        &[(0b10001, &ENTRY_BICOLORREST_693010655310508411)],
    ),
    (
        crate::EncodedStr::Ascii("bicolors"),
        &[(0b10001, &ENTRY_BICOLORS_9368006477019357638)],
    ),
    (
        crate::EncodedStr::Ascii("bicolour"),
        &[(0b11010, &ENTRY_BICOLOR_10164358994113091705)],
    ),
    (
        crate::EncodedStr::Ascii("bicoloured"),
        &[(0b11010, &ENTRY_BICOLORED_434708862208065723)],
    ),
    (
        crate::EncodedStr::Ascii("bicolouredder"),
        &[(0b11010, &ENTRY_BICOLOREDDER_8362361841051385390)],
    ),
    (
        crate::EncodedStr::Ascii("bicoloureddest"),
        &[(0b11010, &ENTRY_BICOLOREDDEST_8676331588438394982)],
    ),
    (
        crate::EncodedStr::Ascii("bicolourer"),
        &[(0b11010, &ENTRY_BICOLORRER_5653522831142191999)],
    ),
    (
        crate::EncodedStr::Ascii("bicolourest"),
        &[(0b11010, &ENTRY_BICOLORREST_693010655310508411)],
    ),
    (
        crate::EncodedStr::Ascii("bicolourous"),
        &[(0b11010, &ENTRY_BICOLOROUS_9012574496998947343)],
    ),
    (
        crate::EncodedStr::Ascii("bicolours"),
        &[(0b11010, &ENTRY_BICOLORS_9368006477019357638)],
    ),
    (
        crate::EncodedStr::Ascii("bimetalist"),
        &[(0b00001, &ENTRY_BIMETALIST_7071235615867580313)],
    ),
    (
        crate::EncodedStr::Ascii("bimetalistic"),
        &[(0b00001, &ENTRY_BIMETALISTIC_10704026739410878685)],
    ),
    (
        crate::EncodedStr::Ascii("bimetallist"),
        &[(0b11010, &ENTRY_BIMETALIST_7071235615867580313)],
    ),
    (
        crate::EncodedStr::Ascii("bimetallistic"),
        &[(0b11010, &ENTRY_BIMETALISTIC_10704026739410878685)],
    ),
    (
        crate::EncodedStr::Ascii("binging"),
        &[(0b00001, &ENTRY_BINGEING_14277432149077039485)],
    ),
    (
        crate::EncodedStr::Ascii("biocenology"),
        &[(0b10001, &ENTRY_BIOCENOLOGY_14689209691235014054)],
    ),
    (
        crate::EncodedStr::Ascii("biocenose"),
        &[(0b10001, &ENTRY_BIOCENOSE_3138770096544861410)],
    ),
    (
        crate::EncodedStr::Ascii("biocenoses"),
        &[(0b10001, &ENTRY_BIOCENOSES_13501584028527836531)],
    ),
    (
        crate::EncodedStr::Ascii("biocenosis"),
        &[(0b10001, &ENTRY_BIOCENOSIS_8916166807214256078)],
    ),
    (
        crate::EncodedStr::Ascii("biocenotic"),
        &[(0b10001, &ENTRY_BIOCENOTIC_8654469384514575281)],
    ),
    (
        crate::EncodedStr::Ascii("biocoenology"),
        &[(0b11010, &ENTRY_BIOCENOLOGY_14689209691235014054)],
    ),
    (
        crate::EncodedStr::Ascii("biocoenose"),
        &[(0b11010, &ENTRY_BIOCENOSE_3138770096544861410)],
    ),
    (
        crate::EncodedStr::Ascii("biocoenoses"),
        &[(0b11010, &ENTRY_BIOCENOSES_13501584028527836531)],
    ),
    (
        crate::EncodedStr::Ascii("biocoenosis"),
        &[(0b11010, &ENTRY_BIOCENOSIS_8916166807214256078)],
    ),
    (
        crate::EncodedStr::Ascii("biocoenotic"),
        &[(0b11010, &ENTRY_BIOCENOTIC_8654469384514575281)],
    ),
    (
        crate::EncodedStr::Ascii("biographise"),
        &[(0b10010, &ENTRY_BIOGRAPHIZE_3101270671578058317)],
    ),
    (
        crate::EncodedStr::Ascii("biographises"),
        &[(0b10010, &ENTRY_BIOGRAPHIZES_9794450292227006800)],
    ),
    (
        crate::EncodedStr::Ascii("biographize"),
        &[(0b01001, &ENTRY_BIOGRAPHIZE_3101270671578058317)],
    ),
    (
        crate::EncodedStr::Ascii("biographizes"),
        &[(0b01001, &ENTRY_BIOGRAPHIZES_9794450292227006800)],
    ),
    (
        crate::EncodedStr::Ascii("biologise"),
        &[(0b10010, &ENTRY_BIOLOGIZE_7350607900569346229)],
    ),
    (
        crate::EncodedStr::Ascii("biologises"),
        &[(0b10010, &ENTRY_BIOLOGIZES_3124510342898949248)],
    ),
    (
        crate::EncodedStr::Ascii("biologize"),
        &[(0b01001, &ENTRY_BIOLOGIZE_7350607900569346229)],
    ),
    (
        crate::EncodedStr::Ascii("biologizes"),
        &[(0b01001, &ENTRY_BIOLOGIZES_3124510342898949248)],
    ),
    (
        crate::EncodedStr::Ascii("biosynthesised"),
        &[(0b10010, &ENTRY_BIOSYNTHESIZED_13192699560463879497)],
    ),
    (
        crate::EncodedStr::Ascii("biosynthesized"),
        &[(0b01001, &ENTRY_BIOSYNTHESIZED_13192699560463879497)],
    ),
    (
        crate::EncodedStr::Ascii("bipolarisation"),
        &[(0b10010, &ENTRY_BIPOLARIZATION_8043840355082199256)],
    ),
    (
        crate::EncodedStr::Ascii("bipolarise"),
        &[(0b10010, &ENTRY_BIPOLARIZE_7871964341365869167)],
    ),
    (
        crate::EncodedStr::Ascii("bipolarises"),
        &[(0b10010, &ENTRY_BIPOLARIZES_9309819257597037093)],
    ),
    (
        crate::EncodedStr::Ascii("bipolarization"),
        &[(0b01001, &ENTRY_BIPOLARIZATION_8043840355082199256)],
    ),
    (
        crate::EncodedStr::Ascii("bipolarize"),
        &[(0b01001, &ENTRY_BIPOLARIZE_7871964341365869167)],
    ),
    (
        crate::EncodedStr::Ascii("bipolarizes"),
        &[(0b01001, &ENTRY_BIPOLARIZES_9309819257597037093)],
    ),
    (
        crate::EncodedStr::Ascii("birminghamise"),
        &[(0b10010, &ENTRY_BIRMINGHAMIZE_8569250108140387650)],
    ),
    (
        crate::EncodedStr::Ascii("birminghamises"),
        &[(0b10010, &ENTRY_BIRMINGHAMIZES_18070978989186779877)],
    ),
    (
        crate::EncodedStr::Ascii("birminghamize"),
        &[(0b01001, &ENTRY_BIRMINGHAMIZE_8569250108140387650)],
    ),
    (
        crate::EncodedStr::Ascii("birminghamizes"),
        &[(0b01001, &ENTRY_BIRMINGHAMIZES_18070978989186779877)],
    ),
    (
        crate::EncodedStr::Ascii("bise"),
        &[(0b10010, &ENTRY_BIZE_12936627068566021826)],
    ),
    (
        crate::EncodedStr::Ascii("biset"),
        &[(0b10010, &ENTRY_BIZET_4586471071545262019)],
    ),
    (
        crate::EncodedStr::Ascii("bister"),
        &[(0b01001, &ENTRY_BISTER_12243394786223476364)],
    ),
    (
        crate::EncodedStr::Ascii("bistered"),
        &[(0b00001, &ENTRY_BISTERED_12594354785868849372)],
    ),
    (
        crate::EncodedStr::Ascii("bisteredder"),
        &[(0b00001, &ENTRY_BISTEREDDER_4919702072233220862)],
    ),
    (
        crate::EncodedStr::Ascii("bistereddest"),
        &[(0b00001, &ENTRY_BISTEREDDEST_8076651195429169182)],
    ),
    (
        crate::EncodedStr::Ascii("bisters"),
        &[(0b01001, &ENTRY_BISTERS_2497112586905993305)],
    ),
    (
        crate::EncodedStr::Ascii("bistre"),
        &[(0b11010, &ENTRY_BISTER_12243394786223476364)],
    ),
    (
        crate::EncodedStr::Ascii("bistred"),
        &[(0b11010, &ENTRY_BISTERED_12594354785868849372)],
    ),
    (
        crate::EncodedStr::Ascii("bistredder"),
        &[(0b11010, &ENTRY_BISTEREDDER_4919702072233220862)],
    ),
    (
        crate::EncodedStr::Ascii("bistreddest"),
        &[(0b11010, &ENTRY_BISTEREDDEST_8076651195429169182)],
    ),
    (
        crate::EncodedStr::Ascii("bistres"),
        &[(0b11010, &ENTRY_BISTERS_2497112586905993305)],
    ),
    (
        crate::EncodedStr::Ascii("bittor"),
        &[(0b00001, &ENTRY_BITTOR_17121981854551948147)],
    ),
    (
        crate::EncodedStr::Ascii("bittors"),
        &[(0b00001, &ENTRY_BITTORS_11286171863858275118)],
    ),
    (
        crate::EncodedStr::Ascii("bittour"),
        &[(0b11010, &ENTRY_BITTOR_17121981854551948147)],
    ),
    (
        crate::EncodedStr::Ascii("bittours"),
        &[(0b11010, &ENTRY_BITTORS_11286171863858275118)],
    ),
    (
        crate::EncodedStr::Ascii("bituminisation"),
        &[(0b10010, &ENTRY_BITUMINIZATION_17454899386160960184)],
    ),
    (
        crate::EncodedStr::Ascii("bituminisations"),
        &[(0b10010, &ENTRY_BITUMINIZATIONS_4430255676913937183)],
    ),
    (
        crate::EncodedStr::Ascii("bituminise"),
        &[(0b10010, &ENTRY_BITUMINIZE_18416379614821284335)],
    ),
    (
        crate::EncodedStr::Ascii("bituminised"),
        &[(0b10010, &ENTRY_BITUMINIZED_3973700773638176633)],
    ),
    (
        crate::EncodedStr::Ascii("bituminises"),
        &[(0b10010, &ENTRY_BITUMINIZES_15984764105434279145)],
    ),
    (
        crate::EncodedStr::Ascii("bituminising"),
        &[(0b10010, &ENTRY_BITUMINIZING_14018683945005443597)],
    ),
    (
        crate::EncodedStr::Ascii("bituminization"),
        &[(0b01001, &ENTRY_BITUMINIZATION_17454899386160960184)],
    ),
    (
        crate::EncodedStr::Ascii("bituminizations"),
        &[(0b01001, &ENTRY_BITUMINIZATIONS_4430255676913937183)],
    ),
    (
        crate::EncodedStr::Ascii("bituminize"),
        &[(0b01001, &ENTRY_BITUMINIZE_18416379614821284335)],
    ),
    (
        crate::EncodedStr::Ascii("bituminized"),
        &[(0b01001, &ENTRY_BITUMINIZED_3973700773638176633)],
    ),
    (
        crate::EncodedStr::Ascii("bituminizes"),
        &[(0b01001, &ENTRY_BITUMINIZES_15984764105434279145)],
    ),
    (
        crate::EncodedStr::Ascii("bituminizing"),
        &[(0b01001, &ENTRY_BITUMINIZING_14018683945005443597)],
    ),
    (
        crate::EncodedStr::Ascii("bize"),
        &[(0b01001, &ENTRY_BIZE_12936627068566021826)],
    ),
    (
        crate::EncodedStr::Ascii("bizet"),
        &[(0b01001, &ENTRY_BIZET_4586471071545262019)],
    ),
    (
        crate::EncodedStr::Ascii("blaise"),
        &[(0b10010, &ENTRY_BLAIZE_1220632059692388861)],
    ),
    (
        crate::EncodedStr::Ascii("blaize"),
        &[(0b01001, &ENTRY_BLAIZE_1220632059692388861)],
    ),
    (
        crate::EncodedStr::Ascii("blamable"),
        &[(0b01001, &ENTRY_BLAMABLE_7328528693620793783)],
    ),
    (
        crate::EncodedStr::Ascii("blastocele"),
        &[(0b00001, &ENTRY_BLASTOCELE_18161446415449857731)],
    ),
    (
        crate::EncodedStr::Ascii("blastocoele"),
        &[(0b11010, &ENTRY_BLASTOCELE_18161446415449857731)],
    ),
    (
        crate::EncodedStr::Ascii("blastulae"),
        &[(0b11010, &ENTRY_BLASTULE_6565332400736377843)],
    ),
    (
        crate::EncodedStr::Ascii("blastule"),
        &[(0b00001, &ENTRY_BLASTULE_6565332400736377843)],
    ),
    (
        crate::EncodedStr::Ascii("blennemesis"),
        &[(0b00001, &ENTRY_BLENNEMESIS_12408003891077842527)],
    ),
    (
        crate::EncodedStr::Ascii("blennoemesis"),
        &[(0b11010, &ENTRY_BLENNEMESIS_12408003891077842527)],
    ),
    (
        crate::EncodedStr::Ascii("blennorrhea"),
        &[(0b10001, &ENTRY_BLENNORRHEA_2218782057410422271)],
    ),
    (
        crate::EncodedStr::Ascii("blennorrhoea"),
        &[(0b11010, &ENTRY_BLENNORRHEA_2218782057410422271)],
    ),
    (
        crate::EncodedStr::Ascii("boaedromius"),
        &[(0b11010, &ENTRY_BOEDROMIUS_10140569261433699587)],
    ),
    (
        crate::EncodedStr::Ascii("boedromius"),
        &[(0b00001, &ENTRY_BOEDROMIUS_10140569261433699587)],
    ),
    (
        crate::EncodedStr::Ascii("boehmenism"),
        &[(0b11010, &ENTRY_BEHMENISM_16450421455239972566)],
    ),
    (
        crate::EncodedStr::Ascii("boehmenist"),
        &[(0b11010, &ENTRY_BEHMENIST_12053790631810257124)],
    ),
    (
        crate::EncodedStr::Ascii("boehmenite"),
        &[(0b11010, &ENTRY_BEHMENITE_3335321400081704671)],
    ),
    (
        crate::EncodedStr::Ascii("boelter"),
        &[(0b11010, &ENTRY_BELTER_6595324842513246324)],
    ),
    (
        crate::EncodedStr::Ascii("boelus"),
        &[(0b11010, &ENTRY_BELUS_10707973760047908555)],
    ),
    (
        crate::EncodedStr::Ascii("boled"),
        &[(0b00001, &ENTRY_BOLED_14696249241634637180)],
    ),
    (
        crate::EncodedStr::Ascii("boloed"),
        &[(0b11010, &ENTRY_BOLED_14696249241634637180)],
    ),
    (
        crate::EncodedStr::Ascii("bolshevise"),
        &[(0b10010, &ENTRY_BOLSHEVIZE_9295222616139275092)],
    ),
    (
        crate::EncodedStr::Ascii("bolshevised"),
        &[(0b10010, &ENTRY_BOLSHEVIZED_12985511351822149082)],
    ),
    (
        crate::EncodedStr::Ascii("bolshevises"),
        &[(0b10010, &ENTRY_BOLSHEVIZES_2750006029755985666)],
    ),
    (
        crate::EncodedStr::Ascii("bolshevising"),
        &[(0b10010, &ENTRY_BOLSHEVIZING_2242830870498003369)],
    ),
    (
        crate::EncodedStr::Ascii("bolshevize"),
        &[(0b01001, &ENTRY_BOLSHEVIZE_9295222616139275092)],
    ),
    (
        crate::EncodedStr::Ascii("bolshevized"),
        &[(0b01001, &ENTRY_BOLSHEVIZED_12985511351822149082)],
    ),
    (
        crate::EncodedStr::Ascii("bolshevizes"),
        &[(0b01001, &ENTRY_BOLSHEVIZES_2750006029755985666)],
    ),
    (
        crate::EncodedStr::Ascii("bolshevizing"),
        &[(0b01001, &ENTRY_BOLSHEVIZING_2242830870498003369)],
    ),
    (
        crate::EncodedStr::Ascii("bonderise"),
        &[(0b10010, &ENTRY_BONDERIZE_7272076124653249026)],
    ),
    (
        crate::EncodedStr::Ascii("bonderize"),
        &[(0b01001, &ENTRY_BONDERIZE_7272076124653249026)],
    ),
    (
        crate::EncodedStr::Ascii("bor"),
        &[(0b00001, &ENTRY_BOR_15726996487969007319)],
    ),
    (
        crate::EncodedStr::Ascii("borage"),
        &[(0b00001, &ENTRY_BORAGE_11906407082412349878)],
    ),
    (
        crate::EncodedStr::Ascii("borasque"),
        &[(0b00001, &ENTRY_BORASQUE_12463950773551631809)],
    ),
    (
        crate::EncodedStr::Ascii("bord"),
        &[(0b00001, &ENTRY_BORD_18164452795863545372)],
    ),
    (
        crate::EncodedStr::Ascii("bords"),
        &[(0b00001, &ENTRY_BORDS_7324219903916101004)],
    ),
    (
        crate::EncodedStr::Ascii("borg"),
        &[(0b00001, &ENTRY_BORG_5368387535636175671)],
    ),
    (
        crate::EncodedStr::Ascii("borise"),
        &[(0b10010, &ENTRY_BORIZE_10330616917016533656)],
    ),
    (
        crate::EncodedStr::Ascii("borises"),
        &[(0b10010, &ENTRY_BORIZES_16866165125304621719)],
    ),
    (
        crate::EncodedStr::Ascii("borize"),
        &[(0b01001, &ENTRY_BORIZE_10330616917016533656)],
    ),
    (
        crate::EncodedStr::Ascii("borizes"),
        &[(0b01001, &ENTRY_BORIZES_16866165125304621719)],
    ),
    (
        crate::EncodedStr::Ascii("boswellise"),
        &[(0b10010, &ENTRY_BOSWELLIZE_3698602768600626065)],
    ),
    (
        crate::EncodedStr::Ascii("boswellised"),
        &[(0b10010, &ENTRY_BOSWELLIZED_8124331813443724374)],
    ),
    (
        crate::EncodedStr::Ascii("boswellises"),
        &[(0b10010, &ENTRY_BOSWELLIZES_11578704107127902682)],
    ),
    (
        crate::EncodedStr::Ascii("boswellising"),
        &[(0b10010, &ENTRY_BOSWELLIZING_5812126249996086388)],
    ),
    (
        crate::EncodedStr::Ascii("boswellize"),
        &[(0b01001, &ENTRY_BOSWELLIZE_3698602768600626065)],
    ),
    (
        crate::EncodedStr::Ascii("boswellized"),
        &[(0b01001, &ENTRY_BOSWELLIZED_8124331813443724374)],
    ),
    (
        crate::EncodedStr::Ascii("boswellizes"),
        &[(0b01001, &ENTRY_BOSWELLIZES_11578704107127902682)],
    ),
    (
        crate::EncodedStr::Ascii("boswellizing"),
        &[(0b01001, &ENTRY_BOSWELLIZING_5812126249996086388)],
    ),
    (
        crate::EncodedStr::Ascii("botanise"),
        &[(0b10010, &ENTRY_BOTANIZE_7551170961793070479)],
    ),
    (
        crate::EncodedStr::Ascii("botanised"),
        &[(0b10010, &ENTRY_BOTANIZED_6978246195480656091)],
    ),
    (
        crate::EncodedStr::Ascii("botaniser"),
        &[(0b10010, &ENTRY_BOTANIZER_10688902380199603159)],
    ),
    (
        crate::EncodedStr::Ascii("botanises"),
        &[(0b10010, &ENTRY_BOTANIZES_4460206956631925576)],
    ),
    (
        crate::EncodedStr::Ascii("botanising"),
        &[(0b10010, &ENTRY_BOTANIZING_15845930378851783636)],
    ),
    (
        crate::EncodedStr::Ascii("botanize"),
        &[(0b01001, &ENTRY_BOTANIZE_7551170961793070479)],
    ),
    (
        crate::EncodedStr::Ascii("botanized"),
        &[(0b01001, &ENTRY_BOTANIZED_6978246195480656091)],
    ),
    (
        crate::EncodedStr::Ascii("botanizer"),
        &[(0b01001, &ENTRY_BOTANIZER_10688902380199603159)],
    ),
    (
        crate::EncodedStr::Ascii("botanizes"),
        &[(0b01001, &ENTRY_BOTANIZES_4460206956631925576)],
    ),
    (
        crate::EncodedStr::Ascii("botanizing"),
        &[(0b01001, &ENTRY_BOTANIZING_15845930378851783636)],
    ),
    (
        crate::EncodedStr::Ascii("boulevardise"),
        &[(0b10010, &ENTRY_BOULEVARDIZE_8185506525213597267)],
    ),
    (
        crate::EncodedStr::Ascii("boulevardises"),
        &[(0b10010, &ENTRY_BOULEVARDIZES_9859087317378411554)],
    ),
    (
        crate::EncodedStr::Ascii("boulevardize"),
        &[(0b01001, &ENTRY_BOULEVARDIZE_8185506525213597267)],
    ),
    (
        crate::EncodedStr::Ascii("boulevardizes"),
        &[(0b01001, &ENTRY_BOULEVARDIZES_9859087317378411554)],
    ),
    (
        crate::EncodedStr::Ascii("bour"),
        &[(0b11010, &ENTRY_BOR_15726996487969007319)],
    ),
    (
        crate::EncodedStr::Ascii("bourage"),
        &[(0b11010, &ENTRY_BORAGE_11906407082412349878)],
    ),
    (
        crate::EncodedStr::Ascii("bourasque"),
        &[(0b11010, &ENTRY_BORASQUE_12463950773551631809)],
    ),
    (
        crate::EncodedStr::Ascii("bourbonise"),
        &[(0b10010, &ENTRY_BOURBONIZE_1178395603606873081)],
    ),
    (
        crate::EncodedStr::Ascii("bourbonises"),
        &[(0b10010, &ENTRY_BOURBONIZES_14462412263603486786)],
    ),
    (
        crate::EncodedStr::Ascii("bourbonize"),
        &[(0b01001, &ENTRY_BOURBONIZE_1178395603606873081)],
    ),
    (
        crate::EncodedStr::Ascii("bourbonizes"),
        &[(0b01001, &ENTRY_BOURBONIZES_14462412263603486786)],
    ),
    (
        crate::EncodedStr::Ascii("bourd"),
        &[(0b11010, &ENTRY_BORD_18164452795863545372)],
    ),
    (
        crate::EncodedStr::Ascii("bourds"),
        &[(0b11010, &ENTRY_BORDS_7324219903916101004)],
    ),
    (
        crate::EncodedStr::Ascii("bourg"),
        &[(0b11010, &ENTRY_BORG_5368387535636175671)],
    ),
    (
        crate::EncodedStr::Ascii("bowdlerisation"),
        &[(0b10010, &ENTRY_BOWDLERIZATION_15003666665570033944)],
    ),
    (
        crate::EncodedStr::Ascii("bowdlerisations"),
        &[(0b10010, &ENTRY_BOWDLERIZATIONS_4765159417978820500)],
    ),
    (
        crate::EncodedStr::Ascii("bowdlerise"),
        &[(0b10010, &ENTRY_BOWDLERIZE_3564223313490479365)],
    ),
    (
        crate::EncodedStr::Ascii("bowdlerised"),
        &[(0b10010, &ENTRY_BOWDLERIZED_11555956899762270807)],
    ),
    (
        crate::EncodedStr::Ascii("bowdleriser"),
        &[(0b10010, &ENTRY_BOWDLERIZER_9391658950288862007)],
    ),
    (
        crate::EncodedStr::Ascii("bowdlerisers"),
        &[(0b10010, &ENTRY_BOWDLERIZERS_3135273670642498247)],
    ),
    (
        crate::EncodedStr::Ascii("bowdlerises"),
        &[(0b10010, &ENTRY_BOWDLERIZES_996948036211004202)],
    ),
    (
        crate::EncodedStr::Ascii("bowdlerising"),
        &[(0b10010, &ENTRY_BOWDLERIZING_8658675993569127303)],
    ),
    (
        crate::EncodedStr::Ascii("bowdlerization"),
        &[(0b01001, &ENTRY_BOWDLERIZATION_15003666665570033944)],
    ),
    (
        crate::EncodedStr::Ascii("bowdlerizations"),
        &[(0b01001, &ENTRY_BOWDLERIZATIONS_4765159417978820500)],
    ),
    (
        crate::EncodedStr::Ascii("bowdlerize"),
        &[(0b01001, &ENTRY_BOWDLERIZE_3564223313490479365)],
    ),
    (
        crate::EncodedStr::Ascii("bowdlerized"),
        &[(0b01001, &ENTRY_BOWDLERIZED_11555956899762270807)],
    ),
    (
        crate::EncodedStr::Ascii("bowdlerizer"),
        &[(0b01001, &ENTRY_BOWDLERIZER_9391658950288862007)],
    ),
    (
        crate::EncodedStr::Ascii("bowdlerizers"),
        &[(0b01001, &ENTRY_BOWDLERIZERS_3135273670642498247)],
    ),
    (
        crate::EncodedStr::Ascii("bowdlerizes"),
        &[(0b01001, &ENTRY_BOWDLERIZES_996948036211004202)],
    ),
    (
        crate::EncodedStr::Ascii("bowdlerizing"),
        &[(0b01001, &ENTRY_BOWDLERIZING_8658675993569127303)],
    ),
    (
        crate::EncodedStr::Ascii("boweled"),
        &[(0b00001, &ENTRY_BOWELED_17573142053252288008)],
    ),
    (
        crate::EncodedStr::Ascii("boweling"),
        &[(0b00001, &ENTRY_BOWELING_12067574292037953398)],
    ),
    (
        crate::EncodedStr::Ascii("bowelled"),
        &[(0b11010, &ENTRY_BOWELED_17573142053252288008)],
    ),
    (
        crate::EncodedStr::Ascii("bowelling"),
        &[(0b11010, &ENTRY_BOWELING_12067574292037953398)],
    ),
    (
        crate::EncodedStr::Ascii("bowlder"),
        &[(0b00001, &ENTRY_BOULDER_12516261271833260895)],
    ),
    (
        crate::EncodedStr::Ascii("bowlders"),
        &[(0b00001, &ENTRY_BOULDERS_3864700166179251654)],
    ),
    (
        crate::EncodedStr::Ascii("bradypnea"),
        &[(0b10001, &ENTRY_BRADYPNEA_14990069084802510573)],
    ),
    (
        crate::EncodedStr::Ascii("bradypnoea"),
        &[(0b11010, &ENTRY_BRADYPNEA_14990069084802510573)],
    ),
    (
        crate::EncodedStr::Ascii("breathalyse"),
        &[(0b11010, &ENTRY_BREATHALYZE_10553810929293173557)],
    ),
    (
        crate::EncodedStr::Ascii("breathalysed"),
        &[(0b11010, &ENTRY_BREATHALYZED_10540875853111278249)],
    ),
    (
        crate::EncodedStr::Ascii("breathalyser"),
        &[(0b11010, &ENTRY_BREATHALYZER_15434122011452224968)],
    ),
    (
        crate::EncodedStr::Ascii("breathalysers"),
        &[(0b11010, &ENTRY_BREATHALYZERS_7686418927650730063)],
    ),
    (
        crate::EncodedStr::Ascii("breathalyses"),
        &[(0b11010, &ENTRY_BREATHALYZES_15395076049944664352)],
    ),
    (
        crate::EncodedStr::Ascii("breathalysing"),
        &[(0b11010, &ENTRY_BREATHALYZING_9538292620264111634)],
    ),
    (
        crate::EncodedStr::Ascii("breathalyze"),
        &[(0b01001, &ENTRY_BREATHALYZE_10553810929293173557)],
    ),
    (
        crate::EncodedStr::Ascii("breathalyzed"),
        &[(0b01001, &ENTRY_BREATHALYZED_10540875853111278249)],
    ),
    (
        crate::EncodedStr::Ascii("breathalyzers"),
        &[(0b00001, &ENTRY_BREATHALYZERS_7686418927650730063)],
    ),
    (
        crate::EncodedStr::Ascii("breathalyzes"),
        &[(0b01001, &ENTRY_BREATHALYZES_15395076049944664352)],
    ),
    (
        crate::EncodedStr::Ascii("breathalyzing"),
        &[(0b01001, &ENTRY_BREATHALYZING_9538292620264111634)],
    ),
    (
        crate::EncodedStr::Ascii("breloque"),
        &[(0b11010, &ENTRY_BERLOQUE_16973140256876933299)],
    ),
    (
        crate::EncodedStr::Ascii("breme"),
        &[(0b11010, &ENTRY_BERME_13467983052397932132)],
    ),
    (
        crate::EncodedStr::Ascii("bren"),
        &[(0b11010, &ENTRY_BERN_9411483658541257171)],
    ),
    (
        crate::EncodedStr::Ascii("brisa"),
        &[(0b10010, &ENTRY_BRIZA_6020459019937063540)],
    ),
    (
        crate::EncodedStr::Ascii("briza"),
        &[(0b01001, &ENTRY_BRIZA_6020459019937063540)],
    ),
    (
        crate::EncodedStr::Ascii("bromethylene"),
        &[(0b00001, &ENTRY_BROMETHYLENE_12089993515876146438)],
    ),
    (
        crate::EncodedStr::Ascii("brominise"),
        &[(0b10010, &ENTRY_BROMINIZE_17329310617302550026)],
    ),
    (
        crate::EncodedStr::Ascii("brominises"),
        &[(0b10010, &ENTRY_BROMINIZES_11166943960094705541)],
    ),
    (
        crate::EncodedStr::Ascii("brominize"),
        &[(0b01001, &ENTRY_BROMINIZE_17329310617302550026)],
    ),
    (
        crate::EncodedStr::Ascii("brominizes"),
        &[(0b01001, &ENTRY_BROMINIZES_11166943960094705541)],
    ),
    (
        crate::EncodedStr::Ascii("bromisation"),
        &[(0b10010, &ENTRY_BROMIZATION_2640938302052484551)],
    ),
    (
        crate::EncodedStr::Ascii("bromise"),
        &[(0b10010, &ENTRY_BROMIZE_9408768460954085967)],
    ),
    (
        crate::EncodedStr::Ascii("bromised"),
        &[(0b10010, &ENTRY_BROMIZED_1262409682973727998)],
    ),
    (
        crate::EncodedStr::Ascii("bromising"),
        &[(0b10010, &ENTRY_BROMIZING_11142091927559534073)],
    ),
    (
        crate::EncodedStr::Ascii("bromization"),
        &[(0b01001, &ENTRY_BROMIZATION_2640938302052484551)],
    ),
    (
        crate::EncodedStr::Ascii("bromize"),
        &[(0b01001, &ENTRY_BROMIZE_9408768460954085967)],
    ),
    (
        crate::EncodedStr::Ascii("bromized"),
        &[(0b01001, &ENTRY_BROMIZED_1262409682973727998)],
    ),
    (
        crate::EncodedStr::Ascii("bromizing"),
        &[(0b01001, &ENTRY_BROMIZING_11142091927559534073)],
    ),
    (
        crate::EncodedStr::Ascii("bromoethylene"),
        &[(0b11010, &ENTRY_BROMETHYLENE_12089993515876146438)],
    ),
    (
        crate::EncodedStr::Ascii("brutalisation"),
        &[(0b10010, &ENTRY_BRUTALIZATION_5823277448598256026)],
    ),
    (
        crate::EncodedStr::Ascii("brutalisations"),
        &[(0b10010, &ENTRY_BRUTALIZATIONS_14502881577076747180)],
    ),
    (
        crate::EncodedStr::Ascii("brutalise"),
        &[(0b10010, &ENTRY_BRUTALIZE_15445890938697612049)],
    ),
    (
        crate::EncodedStr::Ascii("brutalised"),
        &[(0b10010, &ENTRY_BRUTALIZED_12350992663397007437)],
    ),
    (
        crate::EncodedStr::Ascii("brutalises"),
        &[(0b10010, &ENTRY_BRUTALIZES_14319976079482108516)],
    ),
    (
        crate::EncodedStr::Ascii("brutalising"),
        &[(0b10010, &ENTRY_BRUTALIZING_17352191512105797054)],
    ),
    (
        crate::EncodedStr::Ascii("brutalization"),
        &[(0b01001, &ENTRY_BRUTALIZATION_5823277448598256026)],
    ),
    (
        crate::EncodedStr::Ascii("brutalizations"),
        &[(0b01001, &ENTRY_BRUTALIZATIONS_14502881577076747180)],
    ),
    (
        crate::EncodedStr::Ascii("brutalize"),
        &[(0b01001, &ENTRY_BRUTALIZE_15445890938697612049)],
    ),
    (
        crate::EncodedStr::Ascii("brutalized"),
        &[(0b01001, &ENTRY_BRUTALIZED_12350992663397007437)],
    ),
    (
        crate::EncodedStr::Ascii("brutalizes"),
        &[(0b01001, &ENTRY_BRUTALIZES_14319976079482108516)],
    ),
    (
        crate::EncodedStr::Ascii("brutalizing"),
        &[(0b01001, &ENTRY_BRUTALIZING_17352191512105797054)],
    ),
    (
        crate::EncodedStr::Ascii("budaenny"),
        &[(0b11010, &ENTRY_BUDENNY_11099115713729619046)],
    ),
    (
        crate::EncodedStr::Ascii("budenny"),
        &[(0b00001, &ENTRY_BUDENNY_11099115713729619046)],
    ),
    (
        crate::EncodedStr::Ascii("bureaucratisation"),
        &[(0b10010, &ENTRY_BUREAUCRATIZATION_16556810164478202459)],
    ),
    (
        crate::EncodedStr::Ascii("bureaucratisations"),
        &[(0b10010, &ENTRY_BUREAUCRATIZATIONS_4497039635998929992)],
    ),
    (
        crate::EncodedStr::Ascii("bureaucratise"),
        &[(0b10010, &ENTRY_BUREAUCRATIZE_16395985087531018238)],
    ),
    (
        crate::EncodedStr::Ascii("bureaucratised"),
        &[(0b10010, &ENTRY_BUREAUCRATIZED_15775450558155547918)],
    ),
    (
        crate::EncodedStr::Ascii("bureaucratises"),
        &[(0b10010, &ENTRY_BUREAUCRATIZES_961794786572965629)],
    ),
    (
        crate::EncodedStr::Ascii("bureaucratising"),
        &[(0b10010, &ENTRY_BUREAUCRATIZING_11662006117549455029)],
    ),
    (
        crate::EncodedStr::Ascii("bureaucratization"),
        &[(0b01001, &ENTRY_BUREAUCRATIZATION_16556810164478202459)],
    ),
    (
        crate::EncodedStr::Ascii("bureaucratizations"),
        &[(0b01001, &ENTRY_BUREAUCRATIZATIONS_4497039635998929992)],
    ),
    (
        crate::EncodedStr::Ascii("bureaucratize"),
        &[(0b01001, &ENTRY_BUREAUCRATIZE_16395985087531018238)],
    ),
    (
        crate::EncodedStr::Ascii("bureaucratized"),
        &[(0b01001, &ENTRY_BUREAUCRATIZED_15775450558155547918)],
    ),
    (
        crate::EncodedStr::Ascii("bureaucratizes"),
        &[(0b01001, &ENTRY_BUREAUCRATIZES_961794786572965629)],
    ),
    (
        crate::EncodedStr::Ascii("bureaucratizing"),
        &[(0b01001, &ENTRY_BUREAUCRATIZING_11662006117549455029)],
    ),
    (
        crate::EncodedStr::Ascii("burglarise"),
        &[(0b10010, &ENTRY_BURGLARIZE_3702042591254065955)],
    ),
    (
        crate::EncodedStr::Ascii("burglarised"),
        &[(0b10010, &ENTRY_BURGLARIZED_12847959995142931775)],
    ),
    (
        crate::EncodedStr::Ascii("burglarises"),
        &[(0b10010, &ENTRY_BURGLARIZES_9695092733654355865)],
    ),
    (
        crate::EncodedStr::Ascii("burglarising"),
        &[(0b10010, &ENTRY_BURGLARIZING_8183010640223344875)],
    ),
    (
        crate::EncodedStr::Ascii("burglarize"),
        &[(0b01001, &ENTRY_BURGLARIZE_3702042591254065955)],
    ),
    (
        crate::EncodedStr::Ascii("burglarized"),
        &[(0b01001, &ENTRY_BURGLARIZED_12847959995142931775)],
    ),
    (
        crate::EncodedStr::Ascii("burglarizes"),
        &[(0b01001, &ENTRY_BURGLARIZES_9695092733654355865)],
    ),
    (
        crate::EncodedStr::Ascii("burglarizing"),
        &[(0b01001, &ENTRY_BURGLARIZING_8183010640223344875)],
    ),
    (
        crate::EncodedStr::Ascii("burkha"),
        &[(0b01010, &ENTRY_BURKA_1159530484671088481)],
    ),
    (
        crate::EncodedStr::Ascii("burkhas"),
        &[(0b01010, &ENTRY_BURKAS_17648103133414783175)],
    ),
    (
        crate::EncodedStr::Ascii("burnettise"),
        &[(0b10010, &ENTRY_BURNETTIZE_2544477078181246197)],
    ),
    (
        crate::EncodedStr::Ascii("burnettised"),
        &[(0b10010, &ENTRY_BURNETTIZED_4236600316315443722)],
    ),
    (
        crate::EncodedStr::Ascii("burnettises"),
        &[(0b10010, &ENTRY_BURNETTIZES_11084091521976824076)],
    ),
    (
        crate::EncodedStr::Ascii("burnettising"),
        &[(0b10010, &ENTRY_BURNETTIZING_7002913660791249279)],
    ),
    (
        crate::EncodedStr::Ascii("burnettize"),
        &[(0b01001, &ENTRY_BURNETTIZE_2544477078181246197)],
    ),
    (
        crate::EncodedStr::Ascii("burnettized"),
        &[(0b01001, &ENTRY_BURNETTIZED_4236600316315443722)],
    ),
    (
        crate::EncodedStr::Ascii("burnettizes"),
        &[(0b01001, &ENTRY_BURNETTIZES_11084091521976824076)],
    ),
    (
        crate::EncodedStr::Ascii("burnettizing"),
        &[(0b01001, &ENTRY_BURNETTIZING_7002913660791249279)],
    ),
    (
        crate::EncodedStr::Ascii("burqa"),
        &[(0b11010, &ENTRY_BURKA_1159530484671088481)],
    ),
    (
        crate::EncodedStr::Ascii("burqas"),
        &[(0b11010, &ENTRY_BURKAS_17648103133414783175)],
    ),
    (
        crate::EncodedStr::Ascii("busheled"),
        &[(0b00001, &ENTRY_BUSHELED_1118763777829214027)],
    ),
    (
        crate::EncodedStr::Ascii("busheler"),
        &[(0b00001, &ENTRY_BUSHELER_17954630284099342763)],
    ),
    (
        crate::EncodedStr::Ascii("bushelers"),
        &[(0b00001, &ENTRY_BUSHELERS_15210446479419969885)],
    ),
    (
        crate::EncodedStr::Ascii("busheling"),
        &[(0b00001, &ENTRY_BUSHELING_12570417250242863334)],
    ),
    (
        crate::EncodedStr::Ascii("bushelings"),
        &[(0b00001, &ENTRY_BUSHELINGS_985942199985401750)],
    ),
    (
        crate::EncodedStr::Ascii("bushelled"),
        &[(0b11010, &ENTRY_BUSHELED_1118763777829214027)],
    ),
    (
        crate::EncodedStr::Ascii("busheller"),
        &[(0b11010, &ENTRY_BUSHELER_17954630284099342763)],
    ),
    (
        crate::EncodedStr::Ascii("bushellers"),
        &[(0b11010, &ENTRY_BUSHELERS_15210446479419969885)],
    ),
    (
        crate::EncodedStr::Ascii("bushelling"),
        &[(0b11010, &ENTRY_BUSHELING_12570417250242863334)],
    ),
    (
        crate::EncodedStr::Ascii("bushellings"),
        &[(0b11010, &ENTRY_BUSHELINGS_985942199985401750)],
    ),
    (
        crate::EncodedStr::Ascii("bussed"),
        &[(0b10011, &ENTRY_BUSED_11356679774879450486)],
    ),
    (
        crate::EncodedStr::Ascii("bussing"),
        &[(0b10011, &ENTRY_BUSING_14976108434828724214)],
    ),
    (
        crate::EncodedStr::Ascii("bussings"),
        &[(0b10011, &ENTRY_BUSINGS_5189350881089292254)],
    ),
    (
        crate::EncodedStr::Ascii("byronise"),
        &[(0b10010, &ENTRY_BYRONIZE_12114867653355624724)],
    ),
    (
        crate::EncodedStr::Ascii("byronises"),
        &[(0b10010, &ENTRY_BYRONIZES_17917324563061221571)],
    ),
    (
        crate::EncodedStr::Ascii("byronize"),
        &[(0b01001, &ENTRY_BYRONIZE_12114867653355624724)],
    ),
    (
        crate::EncodedStr::Ascii("byronizes"),
        &[(0b01001, &ENTRY_BYRONIZES_17917324563061221571)],
    ),
    (
        crate::EncodedStr::Ascii("byzantinise"),
        &[(0b10010, &ENTRY_BYZANTINIZE_8123759068349438218)],
    ),
    (
        crate::EncodedStr::Ascii("byzantinises"),
        &[(0b10010, &ENTRY_BYZANTINIZES_7526286864523963129)],
    ),
    (
        crate::EncodedStr::Ascii("byzantinize"),
        &[(0b01001, &ENTRY_BYZANTINIZE_8123759068349438218)],
    ),
    (
        crate::EncodedStr::Ascii("byzantinizes"),
        &[(0b01001, &ENTRY_BYZANTINIZES_7526286864523963129)],
    ),
    (
        crate::EncodedStr::Ascii("cacaesthesia"),
        &[(0b11010, &ENTRY_CACESTHESIA_3355744088099232950)],
    ),
    (
        crate::EncodedStr::Ascii("cacesthesia"),
        &[(0b10001, &ENTRY_CACESTHESIA_3355744088099232950)],
    ),
    (
        crate::EncodedStr::Ascii("cachaemia"),
        &[(0b11010, &ENTRY_CACHEMIA_7087156802078224155)],
    ),
    (
        crate::EncodedStr::Ascii("cachaemic"),
        &[(0b11010, &ENTRY_CACHEMIC_8607330359013703184)],
    ),
    (
        crate::EncodedStr::Ascii("cachemia"),
        &[(0b10001, &ENTRY_CACHEMIA_7087156802078224155)],
    ),
    (
        crate::EncodedStr::Ascii("cachemic"),
        &[(0b10001, &ENTRY_CACHEMIC_8607330359013703184)],
    ),
    (
        crate::EncodedStr::Ascii("cacoaethes"),
        &[(0b11010, &ENTRY_CACOETHES_16920803313087394954)],
    ),
    (
        crate::EncodedStr::Ascii("cacodaemon"),
        &[(0b11010, &ENTRY_CACODEMON_14159660385143717967)],
    ),
    (
        crate::EncodedStr::Ascii("cacodaemoniac"),
        &[(0b11010, &ENTRY_CACODEMONIAC_1398909674946225762)],
    ),
    (
        crate::EncodedStr::Ascii("cacodaemonial"),
        &[(0b11010, &ENTRY_CACODEMONIAL_4666484075733322158)],
    ),
    (
        crate::EncodedStr::Ascii("cacodaemonic"),
        &[(0b11010, &ENTRY_CACODEMONIC_13766389188311207544)],
    ),
    (
        crate::EncodedStr::Ascii("cacodaemons"),
        &[(0b11010, &ENTRY_CACODEMONS_4825079147053974709)],
    ),
    (
        crate::EncodedStr::Ascii("cacodemon"),
        &[(0b10001, &ENTRY_CACODEMON_14159660385143717967)],
    ),
    (
        crate::EncodedStr::Ascii("cacodemoniac"),
        &[(0b10001, &ENTRY_CACODEMONIAC_1398909674946225762)],
    ),
    (
        crate::EncodedStr::Ascii("cacodemonial"),
        &[(0b10001, &ENTRY_CACODEMONIAL_4666484075733322158)],
    ),
    (
        crate::EncodedStr::Ascii("cacodemonic"),
        &[(0b10001, &ENTRY_CACODEMONIC_13766389188311207544)],
    ),
    (
        crate::EncodedStr::Ascii("cacodemons"),
        &[(0b10001, &ENTRY_CACODEMONS_4825079147053974709)],
    ),
    (
        crate::EncodedStr::Ascii("cacoethes"),
        &[(0b10001, &ENTRY_CACOETHES_16920803313087394954)],
    ),
    (
        crate::EncodedStr::Ascii("cadaster"),
        &[(0b00001, &ENTRY_CADASTER_600878410341713165)],
    ),
    (
        crate::EncodedStr::Ascii("cadasters"),
        &[(0b00001, &ENTRY_CADASTERS_582180790478148418)],
    ),
    (
        crate::EncodedStr::Ascii("cadastre"),
        &[(0b11010, &ENTRY_CADASTER_600878410341713165)],
    ),
    (
        crate::EncodedStr::Ascii("cadastres"),
        &[(0b11010, &ENTRY_CADASTERS_582180790478148418)],
    ),
    (
        crate::EncodedStr::Ascii("cadaverise"),
        &[(0b10010, &ENTRY_CADAVERIZE_7507726269443380406)],
    ),
    (
        crate::EncodedStr::Ascii("cadaverises"),
        &[(0b10010, &ENTRY_CADAVERIZES_5212133003303242117)],
    ),
    (
        crate::EncodedStr::Ascii("cadaverize"),
        &[(0b01001, &ENTRY_CADAVERIZE_7507726269443380406)],
    ),
    (
        crate::EncodedStr::Ascii("cadaverizes"),
        &[(0b01001, &ENTRY_CADAVERIZES_5212133003303242117)],
    ),
    (
        crate::EncodedStr::Ascii("cadmiumise"),
        &[(0b10010, &ENTRY_CADMIUMIZE_6211453858315644291)],
    ),
    (
        crate::EncodedStr::Ascii("cadmiumises"),
        &[(0b10010, &ENTRY_CADMIUMIZES_784331431098990189)],
    ),
    (
        crate::EncodedStr::Ascii("cadmiumize"),
        &[(0b01001, &ENTRY_CADMIUMIZE_6211453858315644291)],
    ),
    (
        crate::EncodedStr::Ascii("cadmiumizes"),
        &[(0b01001, &ENTRY_CADMIUMIZES_784331431098990189)],
    ),
    (
        crate::EncodedStr::Ascii("caecally"),
        &[(0b11010, &ENTRY_CECALLY_12720796600011784892)],
    ),
    (
        crate::EncodedStr::Ascii("caecitis"),
        &[(0b11010, &ENTRY_CECITIS_18034763690253072964)],
    ),
    (
        crate::EncodedStr::Ascii("caecitises"),
        &[(0b11010, &ENTRY_CECITISES_10355938704850723051)],
    ),
    (
        crate::EncodedStr::Ascii("caecity"),
        &[(0b11010, &ENTRY_CECITY_9865259183091102407)],
    ),
    (
        crate::EncodedStr::Ascii("caecostomy"),
        &[(0b11010, &ENTRY_CECOSTOMY_3475802463529305333)],
    ),
    (
        crate::EncodedStr::Ascii("caecotomy"),
        &[(0b11010, &ENTRY_CECOTOMY_3978768287054362751)],
    ),
    (
        crate::EncodedStr::Ascii("caenis"),
        &[(0b11010, &ENTRY_CENIS_1991031411311203268)],
    ),
    (
        crate::EncodedStr::Ascii("caenogenetic"),
        &[(0b11010, &ENTRY_CENOGENETIC_4645405785928938913)],
    ),
    (
        crate::EncodedStr::Ascii("caenogenetically"),
        &[(0b11010, &ENTRY_CENOGENETICALLY_14614059803186390481)],
    ),
    (
        crate::EncodedStr::Ascii("caenozoic"),
        &[(0b11010, &ENTRY_CENOZOIC_2810735566450048802)],
    ),
    (
        crate::EncodedStr::Ascii("caerule"),
        &[(0b11010, &ENTRY_CERULE_1141707642753807571)],
    ),
    (
        crate::EncodedStr::Ascii("caesar"),
        &[(0b11010, &ENTRY_CESAR_6074944643525905095)],
    ),
    (
        crate::EncodedStr::Ascii("caesaria"),
        &[(0b11010, &ENTRY_CESARIA_7497611325269733598)],
    ),
    (
        crate::EncodedStr::Ascii("caesarise"),
        &[(0b10010, &ENTRY_CAESARIZE_5575641651919740489)],
    ),
    (
        crate::EncodedStr::Ascii("caesarises"),
        &[(0b10010, &ENTRY_CAESARIZES_16957983591444579370)],
    ),
    (
        crate::EncodedStr::Ascii("caesarize"),
        &[(0b01001, &ENTRY_CAESARIZE_5575641651919740489)],
    ),
    (
        crate::EncodedStr::Ascii("caesarizes"),
        &[(0b01001, &ENTRY_CAESARIZES_16957983591444579370)],
    ),
    (
        crate::EncodedStr::Ascii("caesious"),
        &[(0b11010, &ENTRY_CESIOUS_10445245552084517023)],
    ),
    (
        crate::EncodedStr::Ascii("caesium"),
        &[(0b11010, &ENTRY_CESIUM_17343129911628596363)],
    ),
    (
        crate::EncodedStr::Ascii("caesiums"),
        &[(0b11010, &ENTRY_CESIUMS_4513476447764778250)],
    ),
    (
        crate::EncodedStr::Ascii("caespitose"),
        &[(0b11010, &ENTRY_CESPITOSE_2511412164776933409)],
    ),
    (
        crate::EncodedStr::Ascii("caespitosely"),
        &[(0b11010, &ENTRY_CESPITOSELY_7196666758904903124)],
    ),
    (
        crate::EncodedStr::Ascii("caestus"),
        &[(0b11010, &ENTRY_CESTUS_2264271345052468556)],
    ),
    (
        crate::EncodedStr::Ascii("caestuses"),
        &[(0b11010, &ENTRY_CESTUSES_17262448748104314423)],
    ),
    (
        crate::EncodedStr::Ascii("caesural"),
        &[(0b11010, &ENTRY_CESURAL_2827531996476826616)],
    ),
    (
        crate::EncodedStr::Ascii("caffer"),
        &[(0b00001, &ENTRY_CAFFER_7853146588750420256)],
    ),
    (
        crate::EncodedStr::Ascii("caffre"),
        &[(0b11010, &ENTRY_CAFFER_7853146588750420256)],
    ),
    (
        crate::EncodedStr::Ascii("calander"),
        &[(0b00001, &ENTRY_CALANDER_1319585864060436502)],
    ),
    (
        crate::EncodedStr::Ascii("calandre"),
        &[(0b11010, &ENTRY_CALANDER_1319585864060436502)],
    ),
    (
        crate::EncodedStr::Ascii("calcaemia"),
        &[(0b11010, &ENTRY_CALCEMIA_1283576588856942148)],
    ),
    (
        crate::EncodedStr::Ascii("calcemia"),
        &[(0b10001, &ENTRY_CALCEMIA_1283576588856942148)],
    ),
    (
        crate::EncodedStr::Ascii("caldron"),
        &[(0b10011, &ENTRY_CAULDRON_2025597715474043203)],
    ),
    (
        crate::EncodedStr::Ascii("caldrons"),
        &[(0b10011, &ENTRY_CAULDRONS_1493548229478431121)],
    ),
    (
        crate::EncodedStr::Ascii("calendarisation"),
        &[(0b10010, &ENTRY_CALENDARIZATION_11275927263521422623)],
    ),
    (
        crate::EncodedStr::Ascii("calendarisations"),
        &[(0b10010, &ENTRY_CALENDARIZATIONS_4887826632899373259)],
    ),
    (
        crate::EncodedStr::Ascii("calendarise"),
        &[(0b10010, &ENTRY_CALENDARIZE_14479923013676531010)],
    ),
    (
        crate::EncodedStr::Ascii("calendarised"),
        &[(0b10010, &ENTRY_CALENDARIZED_16767057265330067481)],
    ),
    (
        crate::EncodedStr::Ascii("calendarises"),
        &[(0b10010, &ENTRY_CALENDARIZES_9729766993143146526)],
    ),
    (
        crate::EncodedStr::Ascii("calendarising"),
        &[(0b10010, &ENTRY_CALENDARIZING_12252223763201845409)],
    ),
    (
        crate::EncodedStr::Ascii("calendarization"),
        &[(0b01001, &ENTRY_CALENDARIZATION_11275927263521422623)],
    ),
    (
        crate::EncodedStr::Ascii("calendarizations"),
        &[(0b01001, &ENTRY_CALENDARIZATIONS_4887826632899373259)],
    ),
    (
        crate::EncodedStr::Ascii("calendarize"),
        &[(0b01001, &ENTRY_CALENDARIZE_14479923013676531010)],
    ),
    (
        crate::EncodedStr::Ascii("calendarized"),
        &[(0b01001, &ENTRY_CALENDARIZED_16767057265330067481)],
    ),
    (
        crate::EncodedStr::Ascii("calendarizes"),
        &[(0b01001, &ENTRY_CALENDARIZES_9729766993143146526)],
    ),
    (
        crate::EncodedStr::Ascii("calendarizing"),
        &[(0b01001, &ENTRY_CALENDARIZING_12252223763201845409)],
    ),
    (
        crate::EncodedStr::Ascii("calender"),
        &[(0b00001, &ENTRY_CALENDER_4820301279587696859)],
    ),
    (
        crate::EncodedStr::Ascii("calendre"),
        &[(0b11010, &ENTRY_CALENDER_4820301279587696859)],
    ),
    (
        crate::EncodedStr::Ascii("caliber"),
        &[(0b00001, &ENTRY_CALIBER_6088618581414349459)],
    ),
    (
        crate::EncodedStr::Ascii("calibers"),
        &[(0b00001, &ENTRY_CALIBERS_1430668361820786824)],
    ),
    (
        crate::EncodedStr::Ascii("calibre"),
        &[(0b11010, &ENTRY_CALIBER_6088618581414349459)],
    ),
    (
        crate::EncodedStr::Ascii("calibres"),
        &[(0b11010, &ENTRY_CALIBERS_1430668361820786824)],
    ),
    (
        crate::EncodedStr::Ascii("calisthenics"),
        &[(0b01001, &ENTRY_CALISTHENICS_3364072204597622667)],
    ),
    (
        crate::EncodedStr::Ascii("calk"),
        &[
            (0b00001, &ENTRY_CALK_12575257056050776341),
            (0b00001, &ENTRY_CAULK_17535979702514416347),
            (0b00001, &ENTRY_CAULK_18401647289797844299),
        ],
    ),
    (
        crate::EncodedStr::Ascii("calked"),
        &[
            (0b00001, &ENTRY_CALKED_9181583761946600913),
            (0b00001, &ENTRY_CAULKED_16471647952977568672),
        ],
    ),
    (
        crate::EncodedStr::Ascii("calking"),
        &[
            (0b00001, &ENTRY_CALKING_11924577664112241546),
            (0b00001, &ENTRY_CAULKING_9579808018830977690),
            (0b00001, &ENTRY_CAULK_17535979702514416347),
        ],
    ),
    (
        crate::EncodedStr::Ascii("calkings"),
        &[(0b00001, &ENTRY_CAULKS_14651084141226031502)],
    ),
    (
        crate::EncodedStr::Ascii("calks"),
        &[
            (0b00001, &ENTRY_CALKS_16035962776808869627),
            (0b00001, &ENTRY_CAULKS_14651084141226031502),
            (0b00001, &ENTRY_CAULKS_9108482765718739748),
        ],
    ),
    (
        crate::EncodedStr::Ascii("calliper"),
        &[(0b11010, &ENTRY_CALIPER_1634512857873448114)],
    ),
    (
        crate::EncodedStr::Ascii("callipered"),
        &[(0b11010, &ENTRY_CALIPERED_235483477506157991)],
    ),
    (
        crate::EncodedStr::Ascii("callipering"),
        &[(0b11010, &ENTRY_CALIPERING_10891416031331783411)],
    ),
    (
        crate::EncodedStr::Ascii("callipers"),
        &[(0b11010, &ENTRY_CALIPERS_7817536690880904969)],
    ),
    (
        crate::EncodedStr::Ascii("callirrhoae"),
        &[(0b11010, &ENTRY_CALLIRRHOE_14861380595191797356)],
    ),
    (
        crate::EncodedStr::Ascii("callirrhoe"),
        &[(0b00001, &ENTRY_CALLIRRHOE_14861380595191797356)],
    ),
    (
        crate::EncodedStr::Ascii("callisthenics"),
        &[(0b11010, &ENTRY_CALISTHENICS_3364072204597622667)],
    ),
    (
        crate::EncodedStr::Ascii("calodaemon"),
        &[(0b11010, &ENTRY_CALODEMON_13354165079519258551)],
    ),
    (
        crate::EncodedStr::Ascii("calodemon"),
        &[(0b00001, &ENTRY_CALODEMON_13354165079519258551)],
    ),
    (
        crate::EncodedStr::Ascii("calvinise"),
        &[(0b10010, &ENTRY_CALVINIZE_13816648771193752029)],
    ),
    (
        crate::EncodedStr::Ascii("calvinises"),
        &[(0b10010, &ENTRY_CALVINIZES_5436345566017846080)],
    ),
    (
        crate::EncodedStr::Ascii("calvinize"),
        &[(0b01001, &ENTRY_CALVINIZE_13816648771193752029)],
    ),
    (
        crate::EncodedStr::Ascii("calvinizes"),
        &[(0b01001, &ENTRY_CALVINIZES_5436345566017846080)],
    ),
    (
        crate::EncodedStr::Ascii("camisades"),
        &[(0b00001, &ENTRY_CAMISADES_11807808624178252595)],
    ),
    (
        crate::EncodedStr::Ascii("camisadoes"),
        &[(0b11010, &ENTRY_CAMISADES_11807808624178252595)],
    ),
    (
        crate::EncodedStr::Ascii("camise"),
        &[(0b10010, &ENTRY_CAMIZE_10411458476841511707)],
    ),
    (
        crate::EncodedStr::Ascii("camize"),
        &[(0b01001, &ENTRY_CAMIZE_10411458476841511707)],
    ),
    (
        crate::EncodedStr::Ascii("canadianisation"),
        &[(0b10010, &ENTRY_CANADIANIZATION_11574644012372626466)],
    ),
    (
        crate::EncodedStr::Ascii("canadianisations"),
        &[(0b10010, &ENTRY_CANADIANIZATIONS_406463589942768872)],
    ),
    (
        crate::EncodedStr::Ascii("canadianise"),
        &[(0b10010, &ENTRY_CANADIANIZE_16890380569827973630)],
    ),
    (
        crate::EncodedStr::Ascii("canadianises"),
        &[(0b10010, &ENTRY_CANADIANIZES_962660416621258364)],
    ),
    (
        crate::EncodedStr::Ascii("canadianization"),
        &[(0b01001, &ENTRY_CANADIANIZATION_11574644012372626466)],
    ),
    (
        crate::EncodedStr::Ascii("canadianizations"),
        &[(0b01001, &ENTRY_CANADIANIZATIONS_406463589942768872)],
    ),
    (
        crate::EncodedStr::Ascii("canadianize"),
        &[(0b01001, &ENTRY_CANADIANIZE_16890380569827973630)],
    ),
    (
        crate::EncodedStr::Ascii("canadianizes"),
        &[(0b01001, &ENTRY_CANADIANIZES_962660416621258364)],
    ),
    (
        crate::EncodedStr::Ascii("canaled"),
        &[(0b00001, &ENTRY_CANALED_1837439099016219610)],
    ),
    (
        crate::EncodedStr::Ascii("canaler"),
        &[(0b00001, &ENTRY_CANALER_18198043193093593287)],
    ),
    (
        crate::EncodedStr::Ascii("canalers"),
        &[(0b00001, &ENTRY_CANALERS_7689806565376794966)],
    ),
    (
        crate::EncodedStr::Ascii("canaling"),
        &[(0b00001, &ENTRY_CANALING_8814927178454078271)],
    ),
    (
        crate::EncodedStr::Ascii("canalisation"),
        &[(0b10010, &ENTRY_CANALIZATION_9901281941769542241)],
    ),
    (
        crate::EncodedStr::Ascii("canalisations"),
        &[(0b10010, &ENTRY_CANALIZATIONS_2935456196223694503)],
    ),
    (
        crate::EncodedStr::Ascii("canalise"),
        &[(0b10010, &ENTRY_CANALIZE_911721963215339223)],
    ),
    (
        crate::EncodedStr::Ascii("canalised"),
        &[(0b10010, &ENTRY_CANALIZED_5067325481202256530)],
    ),
    (
        crate::EncodedStr::Ascii("canalises"),
        &[(0b10010, &ENTRY_CANALIZES_14989578106312573774)],
    ),
    (
        crate::EncodedStr::Ascii("canalising"),
        &[(0b10010, &ENTRY_CANALIZING_4812741747649871906)],
    ),
    (
        crate::EncodedStr::Ascii("canalization"),
        &[(0b01001, &ENTRY_CANALIZATION_9901281941769542241)],
    ),
    (
        crate::EncodedStr::Ascii("canalizations"),
        &[(0b01001, &ENTRY_CANALIZATIONS_2935456196223694503)],
    ),
    (
        crate::EncodedStr::Ascii("canalize"),
        &[(0b01001, &ENTRY_CANALIZE_911721963215339223)],
    ),
    (
        crate::EncodedStr::Ascii("canalized"),
        &[(0b01001, &ENTRY_CANALIZED_5067325481202256530)],
    ),
    (
        crate::EncodedStr::Ascii("canalizes"),
        &[(0b01001, &ENTRY_CANALIZES_14989578106312573774)],
    ),
    (
        crate::EncodedStr::Ascii("canalizing"),
        &[(0b01001, &ENTRY_CANALIZING_4812741747649871906)],
    ),
    (
        crate::EncodedStr::Ascii("canalled"),
        &[(0b11010, &ENTRY_CANALED_1837439099016219610)],
    ),
    (
        crate::EncodedStr::Ascii("canaller"),
        &[(0b11010, &ENTRY_CANALER_18198043193093593287)],
    ),
    (
        crate::EncodedStr::Ascii("canallers"),
        &[(0b11010, &ENTRY_CANALERS_7689806565376794966)],
    ),
    (
        crate::EncodedStr::Ascii("canalling"),
        &[(0b11010, &ENTRY_CANALING_8814927178454078271)],
    ),
    (
        crate::EncodedStr::Ascii("cananaean"),
        &[(0b11010, &ENTRY_CANANEAN_5897518141290055149)],
    ),
    (
        crate::EncodedStr::Ascii("cananean"),
        &[(0b00001, &ENTRY_CANANEAN_5897518141290055149)],
    ),
    (
        crate::EncodedStr::Ascii("cancelable"),
        &[(0b00001, &ENTRY_CANCELABLE_3744022220960108237)],
    ),
    (
        crate::EncodedStr::Ascii("cancelate"),
        &[(0b00001, &ENTRY_CANCELATE_11514029187019320804)],
    ),
    (
        crate::EncodedStr::Ascii("cancelated"),
        &[(0b00001, &ENTRY_CANCELATED_14737160893696822649)],
    ),
    (
        crate::EncodedStr::Ascii("cancelation"),
        &[(0b00001, &ENTRY_CANCELLATION_16186923162114662177)],
    ),
    (
        crate::EncodedStr::Ascii("canceled"),
        &[(0b00001, &ENTRY_CANCELED_8509071628121806534)],
    ),
    (
        crate::EncodedStr::Ascii("canceler"),
        &[(0b00001, &ENTRY_CANCELER_11336704721008790101)],
    ),
    (
        crate::EncodedStr::Ascii("cancelers"),
        &[(0b00001, &ENTRY_CANCELERS_843956304444885828)],
    ),
    (
        crate::EncodedStr::Ascii("canceling"),
        &[(0b00001, &ENTRY_CANCELING_2043317365185195331)],
    ),
    (
        crate::EncodedStr::Ascii("canceller"),
        &[(0b11010, &ENTRY_CANCELER_11336704721008790101)],
    ),
    (
        crate::EncodedStr::Ascii("cancellers"),
        &[(0b11010, &ENTRY_CANCELERS_843956304444885828)],
    ),
    (
        crate::EncodedStr::Ascii("cancellous"),
        &[(0b11010, &ENTRY_CANCELOUS_13432632612523726300)],
    ),
    (
        crate::EncodedStr::Ascii("cancelous"),
        &[(0b00001, &ENTRY_CANCELOUS_13432632612523726300)],
    ),
    (
        crate::EncodedStr::Ascii("candor"),
        &[(0b11001, &ENTRY_CANDOR_14808094384111961913)],
    ),
    (
        crate::EncodedStr::Ascii("candors"),
        &[(0b11001, &ENTRY_CANDORS_352105524503647274)],
    ),
    (
        crate::EncodedStr::Ascii("candour"),
        &[(0b11010, &ENTRY_CANDOR_14808094384111961913)],
    ),
    (
        crate::EncodedStr::Ascii("candours"),
        &[(0b11010, &ENTRY_CANDORS_352105524503647274)],
    ),
    (
        crate::EncodedStr::Ascii("canephorae"),
        &[(0b11010, &ENTRY_CANEPHORE_6434692370350146164)],
    ),
    (
        crate::EncodedStr::Ascii("canephore"),
        &[
            (0b00001, &ENTRY_CANEPHORE_10522331887025347806),
            (0b00001, &ENTRY_CANEPHORE_6434692370350146164),
        ],
    ),
    (
        crate::EncodedStr::Ascii("canephoroe"),
        &[(0b11010, &ENTRY_CANEPHORE_10522331887025347806)],
    ),
    (
        crate::EncodedStr::Ascii("canisterisation"),
        &[(0b10010, &ENTRY_CANISTERIZATION_9994917120138811095)],
    ),
    (
        crate::EncodedStr::Ascii("canisterisations"),
        &[(0b10010, &ENTRY_CANISTERIZATIONS_16175257743062965718)],
    ),
    (
        crate::EncodedStr::Ascii("canisterise"),
        &[(0b10010, &ENTRY_CANISTERIZE_3823751102053887281)],
    ),
    (
        crate::EncodedStr::Ascii("canisterised"),
        &[(0b10010, &ENTRY_CANISTERIZED_11516075806659176774)],
    ),
    (
        crate::EncodedStr::Ascii("canisterises"),
        &[(0b10010, &ENTRY_CANISTERIZES_8707191536977720595)],
    ),
    (
        crate::EncodedStr::Ascii("canisterising"),
        &[(0b10010, &ENTRY_CANISTERIZING_3833251549971264383)],
    ),
    (
        crate::EncodedStr::Ascii("canisterization"),
        &[(0b01001, &ENTRY_CANISTERIZATION_9994917120138811095)],
    ),
    (
        crate::EncodedStr::Ascii("canisterizations"),
        &[(0b01001, &ENTRY_CANISTERIZATIONS_16175257743062965718)],
    ),
    (
        crate::EncodedStr::Ascii("canisterize"),
        &[(0b01001, &ENTRY_CANISTERIZE_3823751102053887281)],
    ),
    (
        crate::EncodedStr::Ascii("canisterized"),
        &[(0b01001, &ENTRY_CANISTERIZED_11516075806659176774)],
    ),
    (
        crate::EncodedStr::Ascii("canisterizes"),
        &[(0b01001, &ENTRY_CANISTERIZES_8707191536977720595)],
    ),
    (
        crate::EncodedStr::Ascii("canisterizing"),
        &[(0b01001, &ENTRY_CANISTERIZING_3833251549971264383)],
    ),
    (
        crate::EncodedStr::Ascii("cannibalisation"),
        &[(0b10010, &ENTRY_CANNIBALIZATION_7240357016697451118)],
    ),
    (
        crate::EncodedStr::Ascii("cannibalisations"),
        &[(0b10010, &ENTRY_CANNIBALIZATIONS_14659207523926251323)],
    ),
    (
        crate::EncodedStr::Ascii("cannibalise"),
        &[(0b10010, &ENTRY_CANNIBALIZE_6390598440678018772)],
    ),
    (
        crate::EncodedStr::Ascii("cannibalised"),
        &[(0b10010, &ENTRY_CANNIBALIZED_8169504218362659851)],
    ),
    (
        crate::EncodedStr::Ascii("cannibalises"),
        &[(0b10010, &ENTRY_CANNIBALIZES_7622852839420143979)],
    ),
    (
        crate::EncodedStr::Ascii("cannibalising"),
        &[(0b10010, &ENTRY_CANNIBALIZING_12609939168668624233)],
    ),
    (
        crate::EncodedStr::Ascii("cannibalization"),
        &[(0b01001, &ENTRY_CANNIBALIZATION_7240357016697451118)],
    ),
    (
        crate::EncodedStr::Ascii("cannibalizations"),
        &[(0b01001, &ENTRY_CANNIBALIZATIONS_14659207523926251323)],
    ),
    (
        crate::EncodedStr::Ascii("cannibalize"),
        &[(0b01001, &ENTRY_CANNIBALIZE_6390598440678018772)],
    ),
    (
        crate::EncodedStr::Ascii("cannibalized"),
        &[(0b01001, &ENTRY_CANNIBALIZED_8169504218362659851)],
    ),
    (
        crate::EncodedStr::Ascii("cannibalizes"),
        &[(0b01001, &ENTRY_CANNIBALIZES_7622852839420143979)],
    ),
    (
        crate::EncodedStr::Ascii("cannibalizing"),
        &[(0b01001, &ENTRY_CANNIBALIZING_12609939168668624233)],
    ),
    (
        crate::EncodedStr::Ascii("canonicalisation"),
        &[(0b10010, &ENTRY_CANONICALIZATION_7999615851945801309)],
    ),
    (
        crate::EncodedStr::Ascii("canonicalise"),
        &[(0b10010, &ENTRY_CANONICALIZE_2632431567177056192)],
    ),
    (
        crate::EncodedStr::Ascii("canonicalised"),
        &[(0b10010, &ENTRY_CANONICALIZED_11250167296463797072)],
    ),
    (
        crate::EncodedStr::Ascii("canonicalises"),
        &[(0b10010, &ENTRY_CANONICALIZES_18227657368670160690)],
    ),
    (
        crate::EncodedStr::Ascii("canonicalising"),
        &[(0b10010, &ENTRY_CANONICALIZING_1431614031305230237)],
    ),
    (
        crate::EncodedStr::Ascii("canonicalization"),
        &[(0b01001, &ENTRY_CANONICALIZATION_7999615851945801309)],
    ),
    (
        crate::EncodedStr::Ascii("canonicalize"),
        &[(0b01001, &ENTRY_CANONICALIZE_2632431567177056192)],
    ),
    (
        crate::EncodedStr::Ascii("canonicalized"),
        &[(0b01001, &ENTRY_CANONICALIZED_11250167296463797072)],
    ),
    (
        crate::EncodedStr::Ascii("canonicalizes"),
        &[(0b01001, &ENTRY_CANONICALIZES_18227657368670160690)],
    ),
    (
        crate::EncodedStr::Ascii("canonicalizing"),
        &[(0b01001, &ENTRY_CANONICALIZING_1431614031305230237)],
    ),
    (
        crate::EncodedStr::Ascii("canonisation"),
        &[(0b10010, &ENTRY_CANONIZATION_5080602976142523102)],
    ),
    (
        crate::EncodedStr::Ascii("canonisations"),
        &[(0b10010, &ENTRY_CANONIZATIONS_15946456967388997441)],
    ),
    (
        crate::EncodedStr::Ascii("canonise"),
        &[(0b10010, &ENTRY_CANONIZE_7683068140953197405)],
    ),
    (
        crate::EncodedStr::Ascii("canonised"),
        &[(0b10010, &ENTRY_CANONIZED_4794312694447620033)],
    ),
    (
        crate::EncodedStr::Ascii("canoniser"),
        &[(0b10010, &ENTRY_CANONIZER_17140136837292538642)],
    ),
    (
        crate::EncodedStr::Ascii("canonisers"),
        &[(0b10010, &ENTRY_CANONIZERS_1059373452134645246)],
    ),
    (
        crate::EncodedStr::Ascii("canonises"),
        &[(0b10010, &ENTRY_CANONIZES_17683915838157001675)],
    ),
    (
        crate::EncodedStr::Ascii("canonising"),
        &[(0b10010, &ENTRY_CANONIZING_8668155521149668521)],
    ),
    (
        crate::EncodedStr::Ascii("canonization"),
        &[(0b01001, &ENTRY_CANONIZATION_5080602976142523102)],
    ),
    (
        crate::EncodedStr::Ascii("canonizations"),
        &[(0b01001, &ENTRY_CANONIZATIONS_15946456967388997441)],
    ),
    (
        crate::EncodedStr::Ascii("canonize"),
        &[(0b01001, &ENTRY_CANONIZE_7683068140953197405)],
    ),
    (
        crate::EncodedStr::Ascii("canonized"),
        &[(0b01001, &ENTRY_CANONIZED_4794312694447620033)],
    ),
    (
        crate::EncodedStr::Ascii("canonizer"),
        &[(0b01001, &ENTRY_CANONIZER_17140136837292538642)],
    ),
    (
        crate::EncodedStr::Ascii("canonizers"),
        &[(0b01001, &ENTRY_CANONIZERS_1059373452134645246)],
    ),
    (
        crate::EncodedStr::Ascii("canonizes"),
        &[(0b01001, &ENTRY_CANONIZES_17683915838157001675)],
    ),
    (
        crate::EncodedStr::Ascii("canonizing"),
        &[(0b01001, &ENTRY_CANONIZING_8668155521149668521)],
    ),
    (
        crate::EncodedStr::Ascii("cantaloup"),
        &[(0b01001, &ENTRY_CANTALOUPE_7760362447914940621)],
    ),
    (
        crate::EncodedStr::Ascii("cantaloups"),
        &[(0b01001, &ENTRY_CANTALOUPES_10789009086995967817)],
    ),
    (
        crate::EncodedStr::Ascii("cantonisation"),
        &[(0b10010, &ENTRY_CANTONIZATION_6677109296433610186)],
    ),
    (
        crate::EncodedStr::Ascii("cantonisations"),
        &[(0b10010, &ENTRY_CANTONIZATIONS_17246812416090811840)],
    ),
    (
        crate::EncodedStr::Ascii("cantonise"),
        &[(0b10010, &ENTRY_CANTONIZE_1640483783874964493)],
    ),
    (
        crate::EncodedStr::Ascii("cantonised"),
        &[(0b10010, &ENTRY_CANTONIZED_759359507372098389)],
    ),
    (
        crate::EncodedStr::Ascii("cantonises"),
        &[(0b10010, &ENTRY_CANTONIZES_10832472956122974528)],
    ),
    (
        crate::EncodedStr::Ascii("cantonising"),
        &[(0b10010, &ENTRY_CANTONIZING_12871143996405253104)],
    ),
    (
        crate::EncodedStr::Ascii("cantonization"),
        &[(0b01001, &ENTRY_CANTONIZATION_6677109296433610186)],
    ),
    (
        crate::EncodedStr::Ascii("cantonizations"),
        &[(0b01001, &ENTRY_CANTONIZATIONS_17246812416090811840)],
    ),
    (
        crate::EncodedStr::Ascii("cantonize"),
        &[(0b01001, &ENTRY_CANTONIZE_1640483783874964493)],
    ),
    (
        crate::EncodedStr::Ascii("cantonized"),
        &[(0b01001, &ENTRY_CANTONIZED_759359507372098389)],
    ),
    (
        crate::EncodedStr::Ascii("cantonizes"),
        &[(0b01001, &ENTRY_CANTONIZES_10832472956122974528)],
    ),
    (
        crate::EncodedStr::Ascii("cantonizing"),
        &[(0b01001, &ENTRY_CANTONIZING_12871143996405253104)],
    ),
    (
        crate::EncodedStr::Ascii("capitalisable"),
        &[(0b10010, &ENTRY_CAPITALIZABLE_1765975557696773459)],
    ),
    (
        crate::EncodedStr::Ascii("capitalisabler"),
        &[(0b10010, &ENTRY_CAPITALIZABLER_17031718845693435382)],
    ),
    (
        crate::EncodedStr::Ascii("capitalisables"),
        &[(0b10010, &ENTRY_CAPITALIZABLES_12918035538804552826)],
    ),
    (
        crate::EncodedStr::Ascii("capitalisablest"),
        &[(0b10010, &ENTRY_CAPITALIZABLEST_6136542042922432603)],
    ),
    (
        crate::EncodedStr::Ascii("capitalisation"),
        &[(0b10010, &ENTRY_CAPITALIZATION_12627331264579480739)],
    ),
    (
        crate::EncodedStr::Ascii("capitalisations"),
        &[(0b10010, &ENTRY_CAPITALIZATIONS_4554225755737415935)],
    ),
    (
        crate::EncodedStr::Ascii("capitalise"),
        &[(0b10010, &ENTRY_CAPITALIZE_8725562284183074279)],
    ),
    (
        crate::EncodedStr::Ascii("capitalised"),
        &[(0b10010, &ENTRY_CAPITALIZED_15025949045206025922)],
    ),
    (
        crate::EncodedStr::Ascii("capitaliser"),
        &[(0b10010, &ENTRY_CAPITALIZER_15938335196315218634)],
    ),
    (
        crate::EncodedStr::Ascii("capitalisers"),
        &[(0b10010, &ENTRY_CAPITALIZERS_10517751249028432560)],
    ),
    (
        crate::EncodedStr::Ascii("capitalises"),
        &[(0b10010, &ENTRY_CAPITALIZES_16323417076992732600)],
    ),
    (
        crate::EncodedStr::Ascii("capitalising"),
        &[(0b10010, &ENTRY_CAPITALIZING_2512967533316213598)],
    ),
    (
        crate::EncodedStr::Ascii("capitalizable"),
        &[(0b01001, &ENTRY_CAPITALIZABLE_1765975557696773459)],
    ),
    (
        crate::EncodedStr::Ascii("capitalizabler"),
        &[(0b01001, &ENTRY_CAPITALIZABLER_17031718845693435382)],
    ),
    (
        crate::EncodedStr::Ascii("capitalizables"),
        &[(0b01001, &ENTRY_CAPITALIZABLES_12918035538804552826)],
    ),
    (
        crate::EncodedStr::Ascii("capitalizablest"),
        &[(0b01001, &ENTRY_CAPITALIZABLEST_6136542042922432603)],
    ),
    (
        crate::EncodedStr::Ascii("capitalization"),
        &[(0b01001, &ENTRY_CAPITALIZATION_12627331264579480739)],
    ),
    (
        crate::EncodedStr::Ascii("capitalizations"),
        &[(0b01001, &ENTRY_CAPITALIZATIONS_4554225755737415935)],
    ),
    (
        crate::EncodedStr::Ascii("capitalize"),
        &[(0b01001, &ENTRY_CAPITALIZE_8725562284183074279)],
    ),
    (
        crate::EncodedStr::Ascii("capitalized"),
        &[(0b01001, &ENTRY_CAPITALIZED_15025949045206025922)],
    ),
    (
        crate::EncodedStr::Ascii("capitalizer"),
        &[(0b01001, &ENTRY_CAPITALIZER_15938335196315218634)],
    ),
    (
        crate::EncodedStr::Ascii("capitalizers"),
        &[(0b01001, &ENTRY_CAPITALIZERS_10517751249028432560)],
    ),
    (
        crate::EncodedStr::Ascii("capitalizes"),
        &[(0b01001, &ENTRY_CAPITALIZES_16323417076992732600)],
    ),
    (
        crate::EncodedStr::Ascii("capitalizing"),
        &[(0b01001, &ENTRY_CAPITALIZING_2512967533316213598)],
    ),
    (
        crate::EncodedStr::Ascii("caponisation"),
        &[(0b10010, &ENTRY_CAPONIZATION_1938263787545597969)],
    ),
    (
        crate::EncodedStr::Ascii("caponise"),
        &[(0b10010, &ENTRY_CAPONIZE_17964447872816434047)],
    ),
    (
        crate::EncodedStr::Ascii("caponised"),
        &[(0b10010, &ENTRY_CAPONIZED_14836958589299432160)],
    ),
    (
        crate::EncodedStr::Ascii("caponiser"),
        &[(0b10010, &ENTRY_CAPONIZER_5653304916609979245)],
    ),
    (
        crate::EncodedStr::Ascii("caponises"),
        &[(0b10010, &ENTRY_CAPONIZES_8415080645445299415)],
    ),
    (
        crate::EncodedStr::Ascii("caponising"),
        &[(0b10010, &ENTRY_CAPONIZING_12126070973152497349)],
    ),
    (
        crate::EncodedStr::Ascii("caponization"),
        &[(0b01001, &ENTRY_CAPONIZATION_1938263787545597969)],
    ),
    (
        crate::EncodedStr::Ascii("caponize"),
        &[(0b01001, &ENTRY_CAPONIZE_17964447872816434047)],
    ),
    (
        crate::EncodedStr::Ascii("caponized"),
        &[(0b01001, &ENTRY_CAPONIZED_14836958589299432160)],
    ),
    (
        crate::EncodedStr::Ascii("caponizer"),
        &[(0b01001, &ENTRY_CAPONIZER_5653304916609979245)],
    ),
    (
        crate::EncodedStr::Ascii("caponizes"),
        &[(0b01001, &ENTRY_CAPONIZES_8415080645445299415)],
    ),
    (
        crate::EncodedStr::Ascii("caponizing"),
        &[(0b01001, &ENTRY_CAPONIZING_12126070973152497349)],
    ),
    (
        crate::EncodedStr::Ascii("capsulisation"),
        &[(0b10010, &ENTRY_CAPSULIZATION_1378111058341821834)],
    ),
    (
        crate::EncodedStr::Ascii("capsulise"),
        &[(0b10010, &ENTRY_CAPSULIZE_7935266522075201942)],
    ),
    (
        crate::EncodedStr::Ascii("capsulised"),
        &[(0b10010, &ENTRY_CAPSULIZED_14587057948214962939)],
    ),
    (
        crate::EncodedStr::Ascii("capsulises"),
        &[(0b10010, &ENTRY_CAPSULIZES_12567539512302131751)],
    ),
    (
        crate::EncodedStr::Ascii("capsulising"),
        &[(0b10010, &ENTRY_CAPSULIZING_7016335058787637735)],
    ),
    (
        crate::EncodedStr::Ascii("capsulization"),
        &[(0b01001, &ENTRY_CAPSULIZATION_1378111058341821834)],
    ),
    (
        crate::EncodedStr::Ascii("capsulize"),
        &[(0b01001, &ENTRY_CAPSULIZE_7935266522075201942)],
    ),
    (
        crate::EncodedStr::Ascii("capsulized"),
        &[(0b01001, &ENTRY_CAPSULIZED_14587057948214962939)],
    ),
    (
        crate::EncodedStr::Ascii("capsulizes"),
        &[(0b01001, &ENTRY_CAPSULIZES_12567539512302131751)],
    ),
    (
        crate::EncodedStr::Ascii("capsulizing"),
        &[(0b01001, &ENTRY_CAPSULIZING_7016335058787637735)],
    ),
    (
        crate::EncodedStr::Ascii("caracoled"),
        &[(0b00001, &ENTRY_CARACOLED_8083634779350238799)],
    ),
    (
        crate::EncodedStr::Ascii("caracoling"),
        &[(0b00001, &ENTRY_CARACOLING_4913840131879532625)],
    ),
    (
        crate::EncodedStr::Ascii("caracolled"),
        &[(0b11010, &ENTRY_CARACOLED_8083634779350238799)],
    ),
    (
        crate::EncodedStr::Ascii("caracolling"),
        &[(0b11010, &ENTRY_CARACOLING_4913840131879532625)],
    ),
    (
        crate::EncodedStr::Ascii("caramelisation"),
        &[(0b10010, &ENTRY_CARAMELIZATION_12261843451362374441)],
    ),
    (
        crate::EncodedStr::Ascii("caramelisations"),
        &[(0b10010, &ENTRY_CARAMELIZATIONS_16073975104161787099)],
    ),
    (
        crate::EncodedStr::Ascii("caramelise"),
        &[(0b10010, &ENTRY_CARAMELIZE_15122592141568398862)],
    ),
    (
        crate::EncodedStr::Ascii("caramelised"),
        &[(0b10010, &ENTRY_CARAMELIZED_3143066068548786354)],
    ),
    (
        crate::EncodedStr::Ascii("caramelises"),
        &[(0b10010, &ENTRY_CARAMELIZES_12354251654432497813)],
    ),
    (
        crate::EncodedStr::Ascii("caramelising"),
        &[(0b10010, &ENTRY_CARAMELIZING_10890268661953323278)],
    ),
    (
        crate::EncodedStr::Ascii("caramelization"),
        &[(0b01001, &ENTRY_CARAMELIZATION_12261843451362374441)],
    ),
    (
        crate::EncodedStr::Ascii("caramelizations"),
        &[(0b01001, &ENTRY_CARAMELIZATIONS_16073975104161787099)],
    ),
    (
        crate::EncodedStr::Ascii("caramelize"),
        &[(0b01001, &ENTRY_CARAMELIZE_15122592141568398862)],
    ),
    (
        crate::EncodedStr::Ascii("caramelized"),
        &[(0b01001, &ENTRY_CARAMELIZED_3143066068548786354)],
    ),
    (
        crate::EncodedStr::Ascii("caramelizes"),
        &[(0b01001, &ENTRY_CARAMELIZES_12354251654432497813)],
    ),
    (
        crate::EncodedStr::Ascii("caramelizing"),
        &[(0b01001, &ENTRY_CARAMELIZING_10890268661953323278)],
    ),
    (
        crate::EncodedStr::Ascii("carbolisation"),
        &[(0b10010, &ENTRY_CARBOLIZATION_16908167377588079008)],
    ),
    (
        crate::EncodedStr::Ascii("carbolise"),
        &[(0b10010, &ENTRY_CARBOLIZE_10498092873125902774)],
    ),
    (
        crate::EncodedStr::Ascii("carbolised"),
        &[(0b10010, &ENTRY_CARBOLIZED_3610204407073437611)],
    ),
    (
        crate::EncodedStr::Ascii("carbolises"),
        &[(0b10010, &ENTRY_CARBOLIZES_16280869006659938468)],
    ),
    (
        crate::EncodedStr::Ascii("carbolising"),
        &[(0b10010, &ENTRY_CARBOLIZING_10944405222501443697)],
    ),
    (
        crate::EncodedStr::Ascii("carbolization"),
        &[(0b01001, &ENTRY_CARBOLIZATION_16908167377588079008)],
    ),
    (
        crate::EncodedStr::Ascii("carbolize"),
        &[(0b01001, &ENTRY_CARBOLIZE_10498092873125902774)],
    ),
    (
        crate::EncodedStr::Ascii("carbolized"),
        &[(0b01001, &ENTRY_CARBOLIZED_3610204407073437611)],
    ),
    (
        crate::EncodedStr::Ascii("carbolizes"),
        &[(0b01001, &ENTRY_CARBOLIZES_16280869006659938468)],
    ),
    (
        crate::EncodedStr::Ascii("carbolizing"),
        &[(0b01001, &ENTRY_CARBOLIZING_10944405222501443697)],
    ),
    (
        crate::EncodedStr::Ascii("carbonades"),
        &[(0b00001, &ENTRY_CARBONADES_5678712770354789721)],
    ),
    (
        crate::EncodedStr::Ascii("carbonadoes"),
        &[(0b11010, &ENTRY_CARBONADES_5678712770354789721)],
    ),
    (
        crate::EncodedStr::Ascii("carbonatisation"),
        &[(0b10010, &ENTRY_CARBONATIZATION_5251252289578036221)],
    ),
    (
        crate::EncodedStr::Ascii("carbonatisations"),
        &[(0b10010, &ENTRY_CARBONATIZATIONS_10498315283198909416)],
    ),
    (
        crate::EncodedStr::Ascii("carbonatization"),
        &[(0b01001, &ENTRY_CARBONATIZATION_5251252289578036221)],
    ),
    (
        crate::EncodedStr::Ascii("carbonatizations"),
        &[(0b01001, &ENTRY_CARBONATIZATIONS_10498315283198909416)],
    ),
    (
        crate::EncodedStr::Ascii("carbonisable"),
        &[(0b10010, &ENTRY_CARBONIZABLE_7275477916888704155)],
    ),
    (
        crate::EncodedStr::Ascii("carbonisabler"),
        &[(0b10010, &ENTRY_CARBONIZABLER_11011547734927627020)],
    ),
    (
        crate::EncodedStr::Ascii("carbonisables"),
        &[(0b10010, &ENTRY_CARBONIZABLES_4143576460831039714)],
    ),
    (
        crate::EncodedStr::Ascii("carbonisablest"),
        &[(0b10010, &ENTRY_CARBONIZABLEST_112885352202057431)],
    ),
    (
        crate::EncodedStr::Ascii("carbonisation"),
        &[(0b10010, &ENTRY_CARBONIZATION_11122364629547796220)],
    ),
    (
        crate::EncodedStr::Ascii("carbonisations"),
        &[(0b10010, &ENTRY_CARBONIZATIONS_6111370292147685550)],
    ),
    (
        crate::EncodedStr::Ascii("carbonise"),
        &[(0b10010, &ENTRY_CARBONIZE_16235242288107272785)],
    ),
    (
        crate::EncodedStr::Ascii("carbonised"),
        &[(0b10010, &ENTRY_CARBONIZED_14795079813785129130)],
    ),
    (
        crate::EncodedStr::Ascii("carboniser"),
        &[(0b10010, &ENTRY_CARBONIZER_12348552524098629169)],
    ),
    (
        crate::EncodedStr::Ascii("carbonisers"),
        &[(0b10010, &ENTRY_CARBONIZERS_13712244721486829214)],
    ),
    (
        crate::EncodedStr::Ascii("carbonises"),
        &[(0b10010, &ENTRY_CARBONIZES_14523315792081641044)],
    ),
    (
        crate::EncodedStr::Ascii("carbonising"),
        &[(0b10010, &ENTRY_CARBONIZING_6968560222274215193)],
    ),
    (
        crate::EncodedStr::Ascii("carbonizable"),
        &[(0b01001, &ENTRY_CARBONIZABLE_7275477916888704155)],
    ),
    (
        crate::EncodedStr::Ascii("carbonizabler"),
        &[(0b01001, &ENTRY_CARBONIZABLER_11011547734927627020)],
    ),
    (
        crate::EncodedStr::Ascii("carbonizables"),
        &[(0b01001, &ENTRY_CARBONIZABLES_4143576460831039714)],
    ),
    (
        crate::EncodedStr::Ascii("carbonizablest"),
        &[(0b01001, &ENTRY_CARBONIZABLEST_112885352202057431)],
    ),
    (
        crate::EncodedStr::Ascii("carbonization"),
        &[(0b01001, &ENTRY_CARBONIZATION_11122364629547796220)],
    ),
    (
        crate::EncodedStr::Ascii("carbonizations"),
        &[(0b01001, &ENTRY_CARBONIZATIONS_6111370292147685550)],
    ),
    (
        crate::EncodedStr::Ascii("carbonize"),
        &[(0b01001, &ENTRY_CARBONIZE_16235242288107272785)],
    ),
    (
        crate::EncodedStr::Ascii("carbonized"),
        &[(0b01001, &ENTRY_CARBONIZED_14795079813785129130)],
    ),
    (
        crate::EncodedStr::Ascii("carbonizer"),
        &[(0b01001, &ENTRY_CARBONIZER_12348552524098629169)],
    ),
    (
        crate::EncodedStr::Ascii("carbonizers"),
        &[(0b01001, &ENTRY_CARBONIZERS_13712244721486829214)],
    ),
    (
        crate::EncodedStr::Ascii("carbonizes"),
        &[(0b01001, &ENTRY_CARBONIZES_14523315792081641044)],
    ),
    (
        crate::EncodedStr::Ascii("carbonizing"),
        &[(0b01001, &ENTRY_CARBONIZING_6968560222274215193)],
    ),
    (
        crate::EncodedStr::Ascii("carburetor"),
        &[(0b00001, &ENTRY_CARBURETOR_3718140921594640872)],
    ),
    (
        crate::EncodedStr::Ascii("carburetors"),
        &[(0b00001, &ENTRY_CARBURETORS_16992407598754998108)],
    ),
    (
        crate::EncodedStr::Ascii("carburetter"),
        &[(0b11010, &ENTRY_CARBURETOR_3718140921594640872)],
    ),
    (
        crate::EncodedStr::Ascii("carburetters"),
        &[(0b11010, &ENTRY_CARBURETORS_16992407598754998108)],
    ),
    (
        crate::EncodedStr::Ascii("carburettor"),
        &[(0b11010, &ENTRY_CARBURETOR_3718140921594640872)],
    ),
    (
        crate::EncodedStr::Ascii("carburettors"),
        &[(0b11010, &ENTRY_CARBURETORS_16992407598754998108)],
    ),
    (
        crate::EncodedStr::Ascii("carburisation"),
        &[(0b10010, &ENTRY_CARBURIZATION_14186154773415871277)],
    ),
    (
        crate::EncodedStr::Ascii("carburisations"),
        &[(0b10010, &ENTRY_CARBURIZATIONS_4288822688136593112)],
    ),
    (
        crate::EncodedStr::Ascii("carburise"),
        &[(0b10010, &ENTRY_CARBURIZE_886066375006540244)],
    ),
    (
        crate::EncodedStr::Ascii("carburised"),
        &[(0b10010, &ENTRY_CARBURIZED_2653066621032127976)],
    ),
    (
        crate::EncodedStr::Ascii("carburiser"),
        &[(0b10010, &ENTRY_CARBURIZER_1120017158252509510)],
    ),
    (
        crate::EncodedStr::Ascii("carburises"),
        &[(0b10010, &ENTRY_CARBURIZES_2604386355014205446)],
    ),
    (
        crate::EncodedStr::Ascii("carburising"),
        &[(0b10010, &ENTRY_CARBURIZING_14362267205170352071)],
    ),
    (
        crate::EncodedStr::Ascii("carburization"),
        &[(0b01001, &ENTRY_CARBURIZATION_14186154773415871277)],
    ),
    (
        crate::EncodedStr::Ascii("carburizations"),
        &[(0b01001, &ENTRY_CARBURIZATIONS_4288822688136593112)],
    ),
    (
        crate::EncodedStr::Ascii("carburize"),
        &[(0b01001, &ENTRY_CARBURIZE_886066375006540244)],
    ),
    (
        crate::EncodedStr::Ascii("carburized"),
        &[(0b01001, &ENTRY_CARBURIZED_2653066621032127976)],
    ),
    (
        crate::EncodedStr::Ascii("carburizer"),
        &[(0b01001, &ENTRY_CARBURIZER_1120017158252509510)],
    ),
    (
        crate::EncodedStr::Ascii("carburizes"),
        &[(0b01001, &ENTRY_CARBURIZES_2604386355014205446)],
    ),
    (
        crate::EncodedStr::Ascii("carburizing"),
        &[(0b01001, &ENTRY_CARBURIZING_14362267205170352071)],
    ),
    (
        crate::EncodedStr::Ascii("cardiae"),
        &[(0b11010, &ENTRY_CARDIE_2205350999715185435)],
    ),
    (
        crate::EncodedStr::Ascii("cardie"),
        &[(0b00001, &ENTRY_CARDIE_2205350999715185435)],
    ),
    (
        crate::EncodedStr::Ascii("carduelinae"),
        &[(0b11010, &ENTRY_CARDUELINE_17268913123311282389)],
    ),
    (
        crate::EncodedStr::Ascii("cardueline"),
        &[(0b00001, &ENTRY_CARDUELINE_17268913123311282389)],
    ),
    (
        crate::EncodedStr::Ascii("carnalise"),
        &[(0b10010, &ENTRY_CARNALIZE_5475208533929563421)],
    ),
    (
        crate::EncodedStr::Ascii("carnalised"),
        &[(0b10010, &ENTRY_CARNALIZED_7768933264922371251)],
    ),
    (
        crate::EncodedStr::Ascii("carnalises"),
        &[(0b10010, &ENTRY_CARNALIZES_5581084477739167595)],
    ),
    (
        crate::EncodedStr::Ascii("carnalising"),
        &[(0b10010, &ENTRY_CARNALIZING_6431076956231586367)],
    ),
    (
        crate::EncodedStr::Ascii("carnalize"),
        &[(0b01001, &ENTRY_CARNALIZE_5475208533929563421)],
    ),
    (
        crate::EncodedStr::Ascii("carnalized"),
        &[(0b01001, &ENTRY_CARNALIZED_7768933264922371251)],
    ),
    (
        crate::EncodedStr::Ascii("carnalizes"),
        &[(0b01001, &ENTRY_CARNALIZES_5581084477739167595)],
    ),
    (
        crate::EncodedStr::Ascii("carnalizing"),
        &[(0b01001, &ENTRY_CARNALIZING_6431076956231586367)],
    ),
    (
        crate::EncodedStr::Ascii("caroled"),
        &[(0b00001, &ENTRY_CAROLED_10588023811542781156)],
    ),
    (
        crate::EncodedStr::Ascii("caroler"),
        &[(0b00001, &ENTRY_CAROLER_7480138065296781672)],
    ),
    (
        crate::EncodedStr::Ascii("carolers"),
        &[(0b00001, &ENTRY_CAROLERS_10675807177319949622)],
    ),
    (
        crate::EncodedStr::Ascii("caroling"),
        &[(0b00001, &ENTRY_CAROLING_1021261814376249053)],
    ),
    (
        crate::EncodedStr::Ascii("carolled"),
        &[(0b11010, &ENTRY_CAROLED_10588023811542781156)],
    ),
    (
        crate::EncodedStr::Ascii("caroller"),
        &[(0b11010, &ENTRY_CAROLER_7480138065296781672)],
    ),
    (
        crate::EncodedStr::Ascii("carollers"),
        &[(0b11010, &ENTRY_CAROLERS_10675807177319949622)],
    ),
    (
        crate::EncodedStr::Ascii("carolling"),
        &[(0b11010, &ENTRY_CAROLING_1021261814376249053)],
    ),
    (
        crate::EncodedStr::Ascii("carotinaemia"),
        &[(0b11010, &ENTRY_CAROTINEMIA_10522117710609229159)],
    ),
    (
        crate::EncodedStr::Ascii("carotinemia"),
        &[(0b10001, &ENTRY_CAROTINEMIA_10522117710609229159)],
    ),
    (
        crate::EncodedStr::Ascii("cartelisation"),
        &[(0b10010, &ENTRY_CARTELIZATION_1802711991797389087)],
    ),
    (
        crate::EncodedStr::Ascii("cartelisations"),
        &[(0b10010, &ENTRY_CARTELIZATIONS_15852914117827138645)],
    ),
    (
        crate::EncodedStr::Ascii("cartelise"),
        &[(0b10010, &ENTRY_CARTELIZE_7454101035459734890)],
    ),
    (
        crate::EncodedStr::Ascii("cartelised"),
        &[(0b10010, &ENTRY_CARTELIZED_9927132532859356643)],
    ),
    (
        crate::EncodedStr::Ascii("cartelises"),
        &[(0b10010, &ENTRY_CARTELIZES_14469260606626523795)],
    ),
    (
        crate::EncodedStr::Ascii("cartelising"),
        &[(0b10010, &ENTRY_CARTELIZING_16082986042795613861)],
    ),
    (
        crate::EncodedStr::Ascii("cartelization"),
        &[(0b01001, &ENTRY_CARTELIZATION_1802711991797389087)],
    ),
    (
        crate::EncodedStr::Ascii("cartelizations"),
        &[(0b01001, &ENTRY_CARTELIZATIONS_15852914117827138645)],
    ),
    (
        crate::EncodedStr::Ascii("cartelize"),
        &[(0b01001, &ENTRY_CARTELIZE_7454101035459734890)],
    ),
    (
        crate::EncodedStr::Ascii("cartelized"),
        &[(0b01001, &ENTRY_CARTELIZED_9927132532859356643)],
    ),
    (
        crate::EncodedStr::Ascii("cartelizes"),
        &[(0b01001, &ENTRY_CARTELIZES_14469260606626523795)],
    ),
    (
        crate::EncodedStr::Ascii("cartelizing"),
        &[(0b01001, &ENTRY_CARTELIZING_16082986042795613861)],
    ),
    (
        crate::EncodedStr::Ascii("castorised"),
        &[(0b10010, &ENTRY_CASTORIZED_17799018914377706815)],
    ),
    (
        crate::EncodedStr::Ascii("castoriseds"),
        &[(0b10010, &ENTRY_CASTORIZEDS_7380053523540664448)],
    ),
    (
        crate::EncodedStr::Ascii("castorized"),
        &[(0b01001, &ENTRY_CASTORIZED_17799018914377706815)],
    ),
    (
        crate::EncodedStr::Ascii("castorizeds"),
        &[(0b01001, &ENTRY_CASTORIZEDS_7380053523540664448)],
    ),
    (
        crate::EncodedStr::Ascii("casualisation"),
        &[(0b10010, &ENTRY_CASUALIZATION_12871483932151068766)],
    ),
    (
        crate::EncodedStr::Ascii("casualisations"),
        &[(0b10010, &ENTRY_CASUALIZATIONS_4776592355861975796)],
    ),
    (
        crate::EncodedStr::Ascii("casualise"),
        &[(0b10010, &ENTRY_CASUALIZE_10803983540374652623)],
    ),
    (
        crate::EncodedStr::Ascii("casualised"),
        &[(0b10010, &ENTRY_CASUALIZED_3173806408429929886)],
    ),
    (
        crate::EncodedStr::Ascii("casualises"),
        &[(0b10010, &ENTRY_CASUALIZES_2357569365432878510)],
    ),
    (
        crate::EncodedStr::Ascii("casualising"),
        &[(0b10010, &ENTRY_CASUALIZING_16345100801087952198)],
    ),
    (
        crate::EncodedStr::Ascii("casualization"),
        &[(0b01001, &ENTRY_CASUALIZATION_12871483932151068766)],
    ),
    (
        crate::EncodedStr::Ascii("casualizations"),
        &[(0b01001, &ENTRY_CASUALIZATIONS_4776592355861975796)],
    ),
    (
        crate::EncodedStr::Ascii("casualize"),
        &[(0b01001, &ENTRY_CASUALIZE_10803983540374652623)],
    ),
    (
        crate::EncodedStr::Ascii("casualized"),
        &[(0b01001, &ENTRY_CASUALIZED_3173806408429929886)],
    ),
    (
        crate::EncodedStr::Ascii("casualizes"),
        &[(0b01001, &ENTRY_CASUALIZES_2357569365432878510)],
    ),
    (
        crate::EncodedStr::Ascii("casualizing"),
        &[(0b01001, &ENTRY_CASUALIZING_16345100801087952198)],
    ),
    (
        crate::EncodedStr::Ascii("catabolise"),
        &[(0b10010, &ENTRY_CATABOLIZE_1177290851351235880)],
    ),
    (
        crate::EncodedStr::Ascii("catabolize"),
        &[(0b01001, &ENTRY_CATABOLIZE_1177290851351235880)],
    ),
    (
        crate::EncodedStr::Ascii("catalog"),
        &[(0b00001, &ENTRY_CATALOG_6854298310343011085)],
    ),
    (
        crate::EncodedStr::Ascii("cataloged"),
        &[(0b00001, &ENTRY_CATALOGED_17338507726872594232)],
    ),
    (
        crate::EncodedStr::Ascii("cataloger"),
        &[(0b00001, &ENTRY_CATALOGER_1036462752165445499)],
    ),
    (
        crate::EncodedStr::Ascii("catalogers"),
        &[(0b00001, &ENTRY_CATALOGERS_18141804906921168384)],
    ),
    (
        crate::EncodedStr::Ascii("cataloging"),
        &[(0b00001, &ENTRY_CATALOGING_8506877421439024861)],
    ),
    (
        crate::EncodedStr::Ascii("catalogs"),
        &[(0b00001, &ENTRY_CATALOGS_8518416776176012476)],
    ),
    (
        crate::EncodedStr::Ascii("cataloguer"),
        &[(0b11010, &ENTRY_CATALOGER_1036462752165445499)],
    ),
    (
        crate::EncodedStr::Ascii("cataloguers"),
        &[(0b11010, &ENTRY_CATALOGERS_18141804906921168384)],
    ),
    (
        crate::EncodedStr::Ascii("cataloguise"),
        &[(0b10010, &ENTRY_CATALOGUIZE_1271806317788507924)],
    ),
    (
        crate::EncodedStr::Ascii("cataloguised"),
        &[(0b10010, &ENTRY_CATALOGUIZED_4476989929563164358)],
    ),
    (
        crate::EncodedStr::Ascii("cataloguises"),
        &[(0b10010, &ENTRY_CATALOGUIZES_3655562417907187515)],
    ),
    (
        crate::EncodedStr::Ascii("cataloguising"),
        &[(0b10010, &ENTRY_CATALOGUIZING_15932890814645999252)],
    ),
    (
        crate::EncodedStr::Ascii("cataloguize"),
        &[(0b01001, &ENTRY_CATALOGUIZE_1271806317788507924)],
    ),
    (
        crate::EncodedStr::Ascii("cataloguized"),
        &[(0b01001, &ENTRY_CATALOGUIZED_4476989929563164358)],
    ),
    (
        crate::EncodedStr::Ascii("cataloguizes"),
        &[(0b01001, &ENTRY_CATALOGUIZES_3655562417907187515)],
    ),
    (
        crate::EncodedStr::Ascii("cataloguizing"),
        &[(0b01001, &ENTRY_CATALOGUIZING_15932890814645999252)],
    ),
    (
        crate::EncodedStr::Ascii("catalyse"),
        &[(0b11010, &ENTRY_CATALYZE_2004345719426635958)],
    ),
    (
        crate::EncodedStr::Ascii("catalysed"),
        &[(0b11010, &ENTRY_CATALYZED_14626193667566838732)],
    ),
    (
        crate::EncodedStr::Ascii("catalyser"),
        &[(0b11010, &ENTRY_CATALYZER_13103775222379027346)],
    ),
    (
        crate::EncodedStr::Ascii("catalysers"),
        &[(0b11010, &ENTRY_CATALYZERS_14386582083420565337)],
    ),
    (
        crate::EncodedStr::Ascii("catalysing"),
        &[(0b11010, &ENTRY_CATALYZING_5940201018784400445)],
    ),
    (
        crate::EncodedStr::Ascii("catalyze"),
        &[(0b01001, &ENTRY_CATALYZE_2004345719426635958)],
    ),
    (
        crate::EncodedStr::Ascii("catalyzed"),
        &[(0b01001, &ENTRY_CATALYZED_14626193667566838732)],
    ),
    (
        crate::EncodedStr::Ascii("catalyzer"),
        &[(0b00001, &ENTRY_CATALYZER_13103775222379027346)],
    ),
    (
        crate::EncodedStr::Ascii("catalyzers"),
        &[(0b00001, &ENTRY_CATALYZERS_14386582083420565337)],
    ),
    (
        crate::EncodedStr::Ascii("catalyzes"),
        &[(0b01001, &ENTRY_CATALYZES_14856767428712676497)],
    ),
    (
        crate::EncodedStr::Ascii("catalyzing"),
        &[(0b01001, &ENTRY_CATALYZING_5940201018784400445)],
    ),
    (
        crate::EncodedStr::Ascii("catechisable"),
        &[(0b10010, &ENTRY_CATECHIZABLE_8282651021901386912)],
    ),
    (
        crate::EncodedStr::Ascii("catechisabler"),
        &[(0b10010, &ENTRY_CATECHIZABLER_5689981000220656601)],
    ),
    (
        crate::EncodedStr::Ascii("catechisables"),
        &[(0b10010, &ENTRY_CATECHIZABLES_10992088782460228856)],
    ),
    (
        crate::EncodedStr::Ascii("catechisablest"),
        &[(0b10010, &ENTRY_CATECHIZABLEST_7714292286287558770)],
    ),
    (
        crate::EncodedStr::Ascii("catechisation"),
        &[(0b10010, &ENTRY_CATECHIZATION_12810249719668086283)],
    ),
    (
        crate::EncodedStr::Ascii("catechisations"),
        &[(0b10010, &ENTRY_CATECHIZATIONS_7241271747980004634)],
    ),
    (
        crate::EncodedStr::Ascii("catechise"),
        &[(0b10010, &ENTRY_CATECHIZE_4522606049079804123)],
    ),
    (
        crate::EncodedStr::Ascii("catechised"),
        &[(0b10010, &ENTRY_CATECHIZED_8126030264531245281)],
    ),
    (
        crate::EncodedStr::Ascii("catechiser"),
        &[(0b10010, &ENTRY_CATECHIZER_8253596747885095438)],
    ),
    (
        crate::EncodedStr::Ascii("catechisers"),
        &[(0b10010, &ENTRY_CATECHIZERS_10089039414007893489)],
    ),
    (
        crate::EncodedStr::Ascii("catechises"),
        &[(0b10010, &ENTRY_CATECHIZES_9034465079743774482)],
    ),
    (
        crate::EncodedStr::Ascii("catechising"),
        &[(0b10010, &ENTRY_CATECHIZING_12487941153933575504)],
    ),
    (
        crate::EncodedStr::Ascii("catechisings"),
        &[(0b10010, &ENTRY_CATECHIZINGS_5519486100889374813)],
    ),
    (
        crate::EncodedStr::Ascii("catechizable"),
        &[(0b01001, &ENTRY_CATECHIZABLE_8282651021901386912)],
    ),
    (
        crate::EncodedStr::Ascii("catechizabler"),
        &[(0b01001, &ENTRY_CATECHIZABLER_5689981000220656601)],
    ),
    (
        crate::EncodedStr::Ascii("catechizables"),
        &[(0b01001, &ENTRY_CATECHIZABLES_10992088782460228856)],
    ),
    (
        crate::EncodedStr::Ascii("catechizablest"),
        &[(0b01001, &ENTRY_CATECHIZABLEST_7714292286287558770)],
    ),
    (
        crate::EncodedStr::Ascii("catechization"),
        &[(0b01001, &ENTRY_CATECHIZATION_12810249719668086283)],
    ),
    (
        crate::EncodedStr::Ascii("catechizations"),
        &[(0b01001, &ENTRY_CATECHIZATIONS_7241271747980004634)],
    ),
    (
        crate::EncodedStr::Ascii("catechize"),
        &[(0b01001, &ENTRY_CATECHIZE_4522606049079804123)],
    ),
    (
        crate::EncodedStr::Ascii("catechized"),
        &[(0b01001, &ENTRY_CATECHIZED_8126030264531245281)],
    ),
    (
        crate::EncodedStr::Ascii("catechizer"),
        &[(0b01001, &ENTRY_CATECHIZER_8253596747885095438)],
    ),
    (
        crate::EncodedStr::Ascii("catechizers"),
        &[(0b01001, &ENTRY_CATECHIZERS_10089039414007893489)],
    ),
    (
        crate::EncodedStr::Ascii("catechizes"),
        &[(0b01001, &ENTRY_CATECHIZES_9034465079743774482)],
    ),
    (
        crate::EncodedStr::Ascii("catechizing"),
        &[(0b01001, &ENTRY_CATECHIZING_12487941153933575504)],
    ),
    (
        crate::EncodedStr::Ascii("catechizings"),
        &[(0b01001, &ENTRY_CATECHIZINGS_5519486100889374813)],
    ),
    (
        crate::EncodedStr::Ascii("categorisation"),
        &[(0b10010, &ENTRY_CATEGORIZATION_8749709687767811950)],
    ),
    (
        crate::EncodedStr::Ascii("categorisations"),
        &[(0b10010, &ENTRY_CATEGORIZATIONS_16612628821035244612)],
    ),
    (
        crate::EncodedStr::Ascii("categorise"),
        &[(0b10010, &ENTRY_CATEGORIZE_12360966269850201965)],
    ),
    (
        crate::EncodedStr::Ascii("categorised"),
        &[(0b10010, &ENTRY_CATEGORIZED_4533542698041220795)],
    ),
    (
        crate::EncodedStr::Ascii("categoriser"),
        &[(0b10010, &ENTRY_CATEGORIZER_7305291735145100306)],
    ),
    (
        crate::EncodedStr::Ascii("categorisers"),
        &[(0b10010, &ENTRY_CATEGORIZERS_7439137280162913189)],
    ),
    (
        crate::EncodedStr::Ascii("categorises"),
        &[(0b10010, &ENTRY_CATEGORIZES_3536341508655848694)],
    ),
    (
        crate::EncodedStr::Ascii("categorising"),
        &[(0b10010, &ENTRY_CATEGORIZING_961096799238536775)],
    ),
    (
        crate::EncodedStr::Ascii("categorization"),
        &[(0b01001, &ENTRY_CATEGORIZATION_8749709687767811950)],
    ),
    (
        crate::EncodedStr::Ascii("categorizations"),
        &[(0b01001, &ENTRY_CATEGORIZATIONS_16612628821035244612)],
    ),
    (
        crate::EncodedStr::Ascii("categorize"),
        &[(0b01001, &ENTRY_CATEGORIZE_12360966269850201965)],
    ),
    (
        crate::EncodedStr::Ascii("categorized"),
        &[(0b01001, &ENTRY_CATEGORIZED_4533542698041220795)],
    ),
    (
        crate::EncodedStr::Ascii("categorizer"),
        &[(0b01001, &ENTRY_CATEGORIZER_7305291735145100306)],
    ),
    (
        crate::EncodedStr::Ascii("categorizers"),
        &[(0b01001, &ENTRY_CATEGORIZERS_7439137280162913189)],
    ),
    (
        crate::EncodedStr::Ascii("categorizes"),
        &[(0b01001, &ENTRY_CATEGORIZES_3536341508655848694)],
    ),
    (
        crate::EncodedStr::Ascii("categorizing"),
        &[(0b01001, &ENTRY_CATEGORIZING_961096799238536775)],
    ),
    (
        crate::EncodedStr::Ascii("catharise"),
        &[(0b10010, &ENTRY_CATHARIZE_13562362241692832662)],
    ),
    (
        crate::EncodedStr::Ascii("catharised"),
        &[(0b10010, &ENTRY_CATHARIZED_5807291134697395135)],
    ),
    (
        crate::EncodedStr::Ascii("catharises"),
        &[(0b10010, &ENTRY_CATHARIZES_15482284310469218680)],
    ),
    (
        crate::EncodedStr::Ascii("catharising"),
        &[(0b10010, &ENTRY_CATHARIZING_1602215100886763291)],
    ),
    (
        crate::EncodedStr::Ascii("catharize"),
        &[(0b01001, &ENTRY_CATHARIZE_13562362241692832662)],
    ),
    (
        crate::EncodedStr::Ascii("catharized"),
        &[(0b01001, &ENTRY_CATHARIZED_5807291134697395135)],
    ),
    (
        crate::EncodedStr::Ascii("catharizes"),
        &[(0b01001, &ENTRY_CATHARIZES_15482284310469218680)],
    ),
    (
        crate::EncodedStr::Ascii("catharizing"),
        &[(0b01001, &ENTRY_CATHARIZING_1602215100886763291)],
    ),
    (
        crate::EncodedStr::Ascii("catheterisation"),
        &[(0b10010, &ENTRY_CATHETERIZATION_11439863909552030833)],
    ),
    (
        crate::EncodedStr::Ascii("catheterisations"),
        &[(0b10010, &ENTRY_CATHETERIZATIONS_13120993350154324986)],
    ),
    (
        crate::EncodedStr::Ascii("catheterise"),
        &[(0b10010, &ENTRY_CATHETERIZE_6492718106386820661)],
    ),
    (
        crate::EncodedStr::Ascii("catheterised"),
        &[(0b10010, &ENTRY_CATHETERIZED_5620836466321605366)],
    ),
    (
        crate::EncodedStr::Ascii("catheterises"),
        &[(0b10010, &ENTRY_CATHETERIZES_11247243473913332794)],
    ),
    (
        crate::EncodedStr::Ascii("catheterising"),
        &[(0b10010, &ENTRY_CATHETERIZING_17180903138518299050)],
    ),
    (
        crate::EncodedStr::Ascii("catheterization"),
        &[(0b01001, &ENTRY_CATHETERIZATION_11439863909552030833)],
    ),
    (
        crate::EncodedStr::Ascii("catheterizations"),
        &[(0b01001, &ENTRY_CATHETERIZATIONS_13120993350154324986)],
    ),
    (
        crate::EncodedStr::Ascii("catheterize"),
        &[(0b01001, &ENTRY_CATHETERIZE_6492718106386820661)],
    ),
    (
        crate::EncodedStr::Ascii("catheterized"),
        &[(0b01001, &ENTRY_CATHETERIZED_5620836466321605366)],
    ),
    (
        crate::EncodedStr::Ascii("catheterizes"),
        &[(0b01001, &ENTRY_CATHETERIZES_11247243473913332794)],
    ),
    (
        crate::EncodedStr::Ascii("catheterizing"),
        &[(0b01001, &ENTRY_CATHETERIZING_17180903138518299050)],
    ),
    (
        crate::EncodedStr::Ascii("catholicisation"),
        &[(0b10010, &ENTRY_CATHOLICIZATION_1039966536643797028)],
    ),
    (
        crate::EncodedStr::Ascii("catholicisations"),
        &[(0b10010, &ENTRY_CATHOLICIZATIONS_8828933916874627488)],
    ),
    (
        crate::EncodedStr::Ascii("catholicise"),
        &[(0b10010, &ENTRY_CATHOLICIZE_4285061554275370513)],
    ),
    (
        crate::EncodedStr::Ascii("catholicised"),
        &[(0b10010, &ENTRY_CATHOLICIZED_14250990289821303382)],
    ),
    (
        crate::EncodedStr::Ascii("catholiciser"),
        &[(0b10010, &ENTRY_CATHOLICIZER_17454867137057099076)],
    ),
    (
        crate::EncodedStr::Ascii("catholicisers"),
        &[(0b10010, &ENTRY_CATHOLICIZERS_11183927485796882872)],
    ),
    (
        crate::EncodedStr::Ascii("catholicises"),
        &[(0b10010, &ENTRY_CATHOLICIZES_893481801065117743)],
    ),
    (
        crate::EncodedStr::Ascii("catholicising"),
        &[(0b10010, &ENTRY_CATHOLICIZING_483590190526039504)],
    ),
    (
        crate::EncodedStr::Ascii("catholicization"),
        &[(0b01001, &ENTRY_CATHOLICIZATION_1039966536643797028)],
    ),
    (
        crate::EncodedStr::Ascii("catholicizations"),
        &[(0b01001, &ENTRY_CATHOLICIZATIONS_8828933916874627488)],
    ),
    (
        crate::EncodedStr::Ascii("catholicize"),
        &[(0b01001, &ENTRY_CATHOLICIZE_4285061554275370513)],
    ),
    (
        crate::EncodedStr::Ascii("catholicized"),
        &[(0b01001, &ENTRY_CATHOLICIZED_14250990289821303382)],
    ),
    (
        crate::EncodedStr::Ascii("catholicizer"),
        &[(0b01001, &ENTRY_CATHOLICIZER_17454867137057099076)],
    ),
    (
        crate::EncodedStr::Ascii("catholicizers"),
        &[(0b01001, &ENTRY_CATHOLICIZERS_11183927485796882872)],
    ),
    (
        crate::EncodedStr::Ascii("catholicizes"),
        &[(0b01001, &ENTRY_CATHOLICIZES_893481801065117743)],
    ),
    (
        crate::EncodedStr::Ascii("catholicizing"),
        &[(0b01001, &ENTRY_CATHOLICIZING_483590190526039504)],
    ),
    (
        crate::EncodedStr::Ascii("causticisation"),
        &[(0b10010, &ENTRY_CAUSTICIZATION_14179900306302530284)],
    ),
    (
        crate::EncodedStr::Ascii("causticisations"),
        &[(0b10010, &ENTRY_CAUSTICIZATIONS_3386787494158775873)],
    ),
    (
        crate::EncodedStr::Ascii("causticise"),
        &[(0b10010, &ENTRY_CAUSTICIZE_8749392950417620936)],
    ),
    (
        crate::EncodedStr::Ascii("causticiser"),
        &[(0b10010, &ENTRY_CAUSTICIZER_11653296088268450856)],
    ),
    (
        crate::EncodedStr::Ascii("causticisers"),
        &[(0b10010, &ENTRY_CAUSTICIZERS_3776323281922224631)],
    ),
    (
        crate::EncodedStr::Ascii("causticises"),
        &[(0b10010, &ENTRY_CAUSTICIZES_9636663018478092014)],
    ),
    (
        crate::EncodedStr::Ascii("causticization"),
        &[(0b01001, &ENTRY_CAUSTICIZATION_14179900306302530284)],
    ),
    (
        crate::EncodedStr::Ascii("causticizations"),
        &[(0b01001, &ENTRY_CAUSTICIZATIONS_3386787494158775873)],
    ),
    (
        crate::EncodedStr::Ascii("causticize"),
        &[(0b01001, &ENTRY_CAUSTICIZE_8749392950417620936)],
    ),
    (
        crate::EncodedStr::Ascii("causticizer"),
        &[(0b01001, &ENTRY_CAUSTICIZER_11653296088268450856)],
    ),
    (
        crate::EncodedStr::Ascii("causticizers"),
        &[(0b01001, &ENTRY_CAUSTICIZERS_3776323281922224631)],
    ),
    (
        crate::EncodedStr::Ascii("causticizes"),
        &[(0b01001, &ENTRY_CAUSTICIZES_9636663018478092014)],
    ),
    (
        crate::EncodedStr::Ascii("cauterisation"),
        &[(0b10010, &ENTRY_CAUTERIZATION_13195615037701165081)],
    ),
    (
        crate::EncodedStr::Ascii("cauterisations"),
        &[(0b10010, &ENTRY_CAUTERIZATIONS_6182254960121790836)],
    ),
    (
        crate::EncodedStr::Ascii("cauterise"),
        &[(0b10010, &ENTRY_CAUTERIZE_3418770242947142090)],
    ),
    (
        crate::EncodedStr::Ascii("cauterised"),
        &[(0b10010, &ENTRY_CAUTERIZED_14634034015720450176)],
    ),
    (
        crate::EncodedStr::Ascii("cauterises"),
        &[(0b10010, &ENTRY_CAUTERIZES_10593916877351446728)],
    ),
    (
        crate::EncodedStr::Ascii("cauterising"),
        &[(0b10010, &ENTRY_CAUTERIZING_13207260063277352862)],
    ),
    (
        crate::EncodedStr::Ascii("cauterization"),
        &[(0b01001, &ENTRY_CAUTERIZATION_13195615037701165081)],
    ),
    (
        crate::EncodedStr::Ascii("cauterizations"),
        &[(0b01001, &ENTRY_CAUTERIZATIONS_6182254960121790836)],
    ),
    (
        crate::EncodedStr::Ascii("cauterize"),
        &[(0b01001, &ENTRY_CAUTERIZE_3418770242947142090)],
    ),
    (
        crate::EncodedStr::Ascii("cauterized"),
        &[(0b01001, &ENTRY_CAUTERIZED_14634034015720450176)],
    ),
    (
        crate::EncodedStr::Ascii("cauterizes"),
        &[(0b01001, &ENTRY_CAUTERIZES_10593916877351446728)],
    ),
    (
        crate::EncodedStr::Ascii("cauterizing"),
        &[(0b01001, &ENTRY_CAUTERIZING_13207260063277352862)],
    ),
    (
        crate::EncodedStr::Ascii("caviare"),
        &[(0b10011, &ENTRY_CAVIAR_7938491403168755546)],
    ),
    (
        crate::EncodedStr::Ascii("caviares"),
        &[(0b10011, &ENTRY_CAVIARS_3052109653380368873)],
    ),
    (
        crate::EncodedStr::Ascii("cavilation"),
        &[(0b00001, &ENTRY_CAVILATION_6485561782401683356)],
    ),
    (
        crate::EncodedStr::Ascii("caviled"),
        &[(0b01001, &ENTRY_CAVILED_13259789881942666788)],
    ),
    (
        crate::EncodedStr::Ascii("caviler"),
        &[(0b00001, &ENTRY_CAVILER_18221555292854240655)],
    ),
    (
        crate::EncodedStr::Ascii("cavilers"),
        &[(0b00001, &ENTRY_CAVILERS_17995770150287304299)],
    ),
    (
        crate::EncodedStr::Ascii("caviling"),
        &[(0b01001, &ENTRY_CAVILING_3938684952444630623)],
    ),
    (
        crate::EncodedStr::Ascii("cavilings"),
        &[(0b01001, &ENTRY_CAVILINGS_3979930879616230447)],
    ),
    (
        crate::EncodedStr::Ascii("cavillation"),
        &[(0b11010, &ENTRY_CAVILATION_6485561782401683356)],
    ),
    (
        crate::EncodedStr::Ascii("cavilled"),
        &[(0b11010, &ENTRY_CAVILED_13259789881942666788)],
    ),
    (
        crate::EncodedStr::Ascii("caviller"),
        &[(0b11010, &ENTRY_CAVILER_18221555292854240655)],
    ),
    (
        crate::EncodedStr::Ascii("cavillers"),
        &[(0b11010, &ENTRY_CAVILERS_17995770150287304299)],
    ),
    (
        crate::EncodedStr::Ascii("cavilling"),
        &[(0b11010, &ENTRY_CAVILING_3938684952444630623)],
    ),
    (
        crate::EncodedStr::Ascii("cavillings"),
        &[(0b11010, &ENTRY_CAVILINGS_3979930879616230447)],
    ),
    (
        crate::EncodedStr::Ascii("ce"),
        &[(0b00001, &ENTRY_CE_254143254853835550)],
    ),
    (
        crate::EncodedStr::Ascii("cecally"),
        &[(0b10001, &ENTRY_CECALLY_12720796600011784892)],
    ),
    (
        crate::EncodedStr::Ascii("cecitis"),
        &[(0b10001, &ENTRY_CECITIS_18034763690253072964)],
    ),
    (
        crate::EncodedStr::Ascii("cecitises"),
        &[(0b10001, &ENTRY_CECITISES_10355938704850723051)],
    ),
    (
        crate::EncodedStr::Ascii("cecity"),
        &[(0b10001, &ENTRY_CECITY_9865259183091102407)],
    ),
    (
        crate::EncodedStr::Ascii("cecostomy"),
        &[(0b10001, &ENTRY_CECOSTOMY_3475802463529305333)],
    ),
    (
        crate::EncodedStr::Ascii("cecotomy"),
        &[(0b10001, &ENTRY_CECOTOMY_3978768287054362751)],
    ),
    (
        crate::EncodedStr::Ascii("celastraceae"),
        &[(0b00001, &ENTRY_CELASTRACEAE_17324005888177982048)],
    ),
    (
        crate::EncodedStr::Ascii("celastraceous"),
        &[(0b00001, &ENTRY_CELASTRACEOUS_18174723794622646878)],
    ),
    (
        crate::EncodedStr::Ascii("celestialise"),
        &[(0b10010, &ENTRY_CELESTIALIZE_2289649302276111708)],
    ),
    (
        crate::EncodedStr::Ascii("celestialises"),
        &[(0b10010, &ENTRY_CELESTIALIZES_10058751039284937485)],
    ),
    (
        crate::EncodedStr::Ascii("celestialize"),
        &[(0b01001, &ENTRY_CELESTIALIZE_2289649302276111708)],
    ),
    (
        crate::EncodedStr::Ascii("celestializes"),
        &[(0b01001, &ENTRY_CELESTIALIZES_10058751039284937485)],
    ),
    (
        crate::EncodedStr::Ascii("celestine"),
        &[(0b00001, &ENTRY_CELESTINE_11011528250519125092)],
    ),
    (
        crate::EncodedStr::Ascii("celiac"),
        &[(0b10001, &ENTRY_CELIAC_10249133411124257957)],
    ),
    (
        crate::EncodedStr::Ascii("celiacs"),
        &[(0b10001, &ENTRY_CELIACS_10248347099141877177)],
    ),
    (
        crate::EncodedStr::Ascii("celialgia"),
        &[(0b10001, &ENTRY_CELIALGIA_4569927604389576150)],
    ),
    (
        crate::EncodedStr::Ascii("celiomyalgia"),
        &[(0b10001, &ENTRY_CELIOMYALGIA_14548383766443531737)],
    ),
    (
        crate::EncodedStr::Ascii("celiorrhea"),
        &[(0b10001, &ENTRY_CELIORRHEA_5614182174276153091)],
    ),
    (
        crate::EncodedStr::Ascii("celioscopy"),
        &[(0b10001, &ENTRY_CELIOSCOPY_17821312237861674807)],
    ),
    (
        crate::EncodedStr::Ascii("celiotomy"),
        &[(0b10001, &ENTRY_CELIOTOMY_9141657999599968712)],
    ),
    (
        crate::EncodedStr::Ascii("celom"),
        &[(0b11001, &ENTRY_CELOM_581114569279805851)],
    ),
    (
        crate::EncodedStr::Ascii("celoma"),
        &[(0b10001, &ENTRY_CELOMA_8394900856159450271)],
    ),
    (
        crate::EncodedStr::Ascii("celomata"),
        &[(0b10001, &ENTRY_CELOMATA_5399894536275260385)],
    ),
    (
        crate::EncodedStr::Ascii("celoms"),
        &[(0b11001, &ENTRY_CELOMS_16869648723221026513)],
    ),
    (
        crate::EncodedStr::Ascii("celoscope"),
        &[(0b10001, &ENTRY_CELOSCOPE_13733285893205563827)],
    ),
    (
        crate::EncodedStr::Ascii("celticise"),
        &[(0b10010, &ENTRY_CELTICIZE_15359124010454967826)],
    ),
    (
        crate::EncodedStr::Ascii("celticises"),
        &[(0b10010, &ENTRY_CELTICIZES_13468713960478569237)],
    ),
    (
        crate::EncodedStr::Ascii("celticize"),
        &[(0b01001, &ENTRY_CELTICIZE_15359124010454967826)],
    ),
    (
        crate::EncodedStr::Ascii("celticizes"),
        &[(0b01001, &ENTRY_CELTICIZES_13468713960478569237)],
    ),
    (
        crate::EncodedStr::Ascii("cenacle"),
        &[(0b10001, &ENTRY_CENACLE_4902172834128420652)],
    ),
    (
        crate::EncodedStr::Ascii("cenaculum"),
        &[(0b10001, &ENTRY_CENACULUM_14642801640862790402)],
    ),
    (
        crate::EncodedStr::Ascii("cenesthesia"),
        &[(0b10001, &ENTRY_CENESTHESIA_3973419130660988894)],
    ),
    (
        crate::EncodedStr::Ascii("cenesthesias"),
        &[(0b10001, &ENTRY_CENESTHESIAS_17650055632548316730)],
    ),
    (
        crate::EncodedStr::Ascii("cenesthesis"),
        &[(0b10001, &ENTRY_CENESTHESIS_2981771230300833707)],
    ),
    (
        crate::EncodedStr::Ascii("cenis"),
        &[(0b10001, &ENTRY_CENIS_1991031411311203268)],
    ),
    (
        crate::EncodedStr::Ascii("cenobe"),
        &[(0b10001, &ENTRY_CENOBE_17025760197236238291)],
    ),
    (
        crate::EncodedStr::Ascii("cenobitism"),
        &[(0b10001, &ENTRY_CENOBITISM_5016689208030165500)],
    ),
    (
        crate::EncodedStr::Ascii("cenobium"),
        &[(0b10001, &ENTRY_CENOBIUM_6656148321160010108)],
    ),
    (
        crate::EncodedStr::Ascii("cenoby"),
        &[(0b10001, &ENTRY_CENOBY_6246310194380860627)],
    ),
    (
        crate::EncodedStr::Ascii("cenogenetic"),
        &[
            (0b10001, &ENTRY_CENOGENETIC_14752824343681490356),
            (0b10001, &ENTRY_CENOGENETIC_4645405785928938913),
        ],
    ),
    (
        crate::EncodedStr::Ascii("cenogenetically"),
        &[(0b10001, &ENTRY_CENOGENETICALLY_14614059803186390481)],
    ),
    (
        crate::EncodedStr::Ascii("cenosite"),
        &[(0b10001, &ENTRY_CENOSITE_6962695398695523616)],
    ),
    (
        crate::EncodedStr::Ascii("cenospecies"),
        &[(0b10001, &ENTRY_CENOSPECIES_18129881350317785306)],
    ),
    (
        crate::EncodedStr::Ascii("cenospecific"),
        &[(0b10001, &ENTRY_CENOSPECIFIC_10710765180299401749)],
    ),
    (
        crate::EncodedStr::Ascii("cenospecifically"),
        &[(0b10001, &ENTRY_CENOSPECIFICALLY_5111318916340201830)],
    ),
    (
        crate::EncodedStr::Ascii("cenozoic"),
        &[(0b10001, &ENTRY_CENOZOIC_2810735566450048802)],
    ),
    (
        crate::EncodedStr::Ascii("center"),
        &[(0b01001, &ENTRY_CENTER_5116273194089119472)],
    ),
    (
        crate::EncodedStr::Ascii("centerable"),
        &[(0b00001, &ENTRY_CENTERABLE_7850484022405363699)],
    ),
    (
        crate::EncodedStr::Ascii("centerables"),
        &[(0b00001, &ENTRY_CENTERABLES_284130752204252297)],
    ),
    (
        crate::EncodedStr::Ascii("centerboard"),
        &[(0b00001, &ENTRY_CENTERBOARD_6663399917522410894)],
    ),
    (
        crate::EncodedStr::Ascii("centerboards"),
        &[(0b00001, &ENTRY_CENTERBOARDS_6194272976717122092)],
    ),
    (
        crate::EncodedStr::Ascii("centered"),
        &[(0b01001, &ENTRY_CENTERED_7034434783664313969)],
    ),
    (
        crate::EncodedStr::Ascii("centerer"),
        &[(0b00001, &ENTRY_CENTERER_1283754348315229141)],
    ),
    (
        crate::EncodedStr::Ascii("centerers"),
        &[(0b00001, &ENTRY_CENTERERS_8988197150993437622)],
    ),
    (
        crate::EncodedStr::Ascii("centerfold"),
        &[(0b00001, &ENTRY_CENTERFOLD_8184640290263929626)],
    ),
    (
        crate::EncodedStr::Ascii("centerfolds"),
        &[(0b00001, &ENTRY_CENTERFOLDS_3764205251661654267)],
    ),
    (
        crate::EncodedStr::Ascii("centering"),
        &[(0b01001, &ENTRY_CENTERING_2288436236637604266)],
    ),
    (
        crate::EncodedStr::Ascii("centerings"),
        &[(0b01001, &ENTRY_CENTERINGS_3934315661544059303)],
    ),
    (
        crate::EncodedStr::Ascii("centerless"),
        &[(0b00001, &ENTRY_CENTERLESS_16010100430566689787)],
    ),
    (
        crate::EncodedStr::Ascii("centerlesser"),
        &[(0b00001, &ENTRY_CENTERLESSER_4828594898766209427)],
    ),
    (
        crate::EncodedStr::Ascii("centerlessest"),
        &[(0b00001, &ENTRY_CENTERLESSEST_15729458226381131123)],
    ),
    (
        crate::EncodedStr::Ascii("centerline"),
        &[(0b00001, &ENTRY_CENTERLINE_4175184067421726158)],
    ),
    (
        crate::EncodedStr::Ascii("centerlines"),
        &[(0b00001, &ENTRY_CENTERLINES_17943791483589954179)],
    ),
    (
        crate::EncodedStr::Ascii("centermost"),
        &[(0b00001, &ENTRY_CENTERMOST_14667266636773107736)],
    ),
    (
        crate::EncodedStr::Ascii("centerpiece"),
        &[(0b00001, &ENTRY_CENTERPIECE_9404304832569952961)],
    ),
    (
        crate::EncodedStr::Ascii("centerpieces"),
        &[(0b00001, &ENTRY_CENTERPIECES_2175158136644578025)],
    ),
    (
        crate::EncodedStr::Ascii("centers"),
        &[(0b01001, &ENTRY_CENTERS_8512068248537945159)],
    ),
    (
        crate::EncodedStr::Ascii("centerville"),
        &[(0b00001, &ENTRY_CENTERVILLE_8888927316062312202)],
    ),
    (
        crate::EncodedStr::Ascii("centigramme"),
        &[(0b10010, &ENTRY_CENTIGRAM_6661702624209880115)],
    ),
    (
        crate::EncodedStr::Ascii("centigrammes"),
        &[(0b10010, &ENTRY_CENTIGRAMS_13488008474576662923)],
    ),
    (
        crate::EncodedStr::Ascii("centiliter"),
        &[(0b00001, &ENTRY_CENTILITER_16190905673789101195)],
    ),
    (
        crate::EncodedStr::Ascii("centiliters"),
        &[(0b00001, &ENTRY_CENTILITERS_15644223244315246330)],
    ),
    (
        crate::EncodedStr::Ascii("centilitre"),
        &[(0b11010, &ENTRY_CENTILITER_16190905673789101195)],
    ),
    (
        crate::EncodedStr::Ascii("centilitres"),
        &[(0b11010, &ENTRY_CENTILITERS_15644223244315246330)],
    ),
    (
        crate::EncodedStr::Ascii("centimeter"),
        &[(0b00001, &ENTRY_CENTIMETER_7893665458627405085)],
    ),
    (
        crate::EncodedStr::Ascii("centimeters"),
        &[(0b00001, &ENTRY_CENTIMETERS_13218717043789536591)],
    ),
    (
        crate::EncodedStr::Ascii("centimetre"),
        &[(0b11010, &ENTRY_CENTIMETER_7893665458627405085)],
    ),
    (
        crate::EncodedStr::Ascii("centimetres"),
        &[(0b11010, &ENTRY_CENTIMETERS_13218717043789536591)],
    ),
    (
        crate::EncodedStr::Ascii("centralisation"),
        &[(0b10010, &ENTRY_CENTRALIZATION_1234582649982497784)],
    ),
    (
        crate::EncodedStr::Ascii("centralisations"),
        &[(0b10010, &ENTRY_CENTRALIZATIONS_16044732569453119370)],
    ),
    (
        crate::EncodedStr::Ascii("centralise"),
        &[(0b10010, &ENTRY_CENTRALIZE_15017664864759648047)],
    ),
    (
        crate::EncodedStr::Ascii("centralised"),
        &[(0b10010, &ENTRY_CENTRALIZED_70126610329667809)],
    ),
    (
        crate::EncodedStr::Ascii("centraliser"),
        &[(0b10010, &ENTRY_CENTRALIZER_12959940147090220134)],
    ),
    (
        crate::EncodedStr::Ascii("centralisers"),
        &[(0b10010, &ENTRY_CENTRALIZERS_15668441115014907887)],
    ),
    (
        crate::EncodedStr::Ascii("centralises"),
        &[(0b10010, &ENTRY_CENTRALIZES_13145361766427986184)],
    ),
    (
        crate::EncodedStr::Ascii("centralising"),
        &[(0b10010, &ENTRY_CENTRALIZING_11205811887699159106)],
    ),
    (
        crate::EncodedStr::Ascii("centralization"),
        &[(0b01001, &ENTRY_CENTRALIZATION_1234582649982497784)],
    ),
    (
        crate::EncodedStr::Ascii("centralizations"),
        &[(0b01001, &ENTRY_CENTRALIZATIONS_16044732569453119370)],
    ),
    (
        crate::EncodedStr::Ascii("centralize"),
        &[(0b01001, &ENTRY_CENTRALIZE_15017664864759648047)],
    ),
    (
        crate::EncodedStr::Ascii("centralized"),
        &[(0b01001, &ENTRY_CENTRALIZED_70126610329667809)],
    ),
    (
        crate::EncodedStr::Ascii("centralizer"),
        &[(0b01001, &ENTRY_CENTRALIZER_12959940147090220134)],
    ),
    (
        crate::EncodedStr::Ascii("centralizers"),
        &[(0b01001, &ENTRY_CENTRALIZERS_15668441115014907887)],
    ),
    (
        crate::EncodedStr::Ascii("centralizes"),
        &[(0b01001, &ENTRY_CENTRALIZES_13145361766427986184)],
    ),
    (
        crate::EncodedStr::Ascii("centralizing"),
        &[(0b01001, &ENTRY_CENTRALIZING_11205811887699159106)],
    ),
    (
        crate::EncodedStr::Ascii("centre"),
        &[(0b11010, &ENTRY_CENTER_5116273194089119472)],
    ),
    (
        crate::EncodedStr::Ascii("centreable"),
        &[(0b11010, &ENTRY_CENTERABLE_7850484022405363699)],
    ),
    (
        crate::EncodedStr::Ascii("centreables"),
        &[(0b11010, &ENTRY_CENTERABLES_284130752204252297)],
    ),
    (
        crate::EncodedStr::Ascii("centreboard"),
        &[(0b11010, &ENTRY_CENTERBOARD_6663399917522410894)],
    ),
    (
        crate::EncodedStr::Ascii("centreboards"),
        &[(0b11010, &ENTRY_CENTERBOARDS_6194272976717122092)],
    ),
    (
        crate::EncodedStr::Ascii("centred"),
        &[(0b11010, &ENTRY_CENTERED_7034434783664313969)],
    ),
    (
        crate::EncodedStr::Ascii("centrefold"),
        &[(0b11010, &ENTRY_CENTERFOLD_8184640290263929626)],
    ),
    (
        crate::EncodedStr::Ascii("centrefolds"),
        &[(0b11010, &ENTRY_CENTERFOLDS_3764205251661654267)],
    ),
    (
        crate::EncodedStr::Ascii("centreless"),
        &[(0b11010, &ENTRY_CENTERLESS_16010100430566689787)],
    ),
    (
        crate::EncodedStr::Ascii("centrelesser"),
        &[(0b11010, &ENTRY_CENTERLESSER_4828594898766209427)],
    ),
    (
        crate::EncodedStr::Ascii("centrelessest"),
        &[(0b11010, &ENTRY_CENTERLESSEST_15729458226381131123)],
    ),
    (
        crate::EncodedStr::Ascii("centreline"),
        &[(0b11010, &ENTRY_CENTERLINE_4175184067421726158)],
    ),
    (
        crate::EncodedStr::Ascii("centrelines"),
        &[(0b11010, &ENTRY_CENTERLINES_17943791483589954179)],
    ),
    (
        crate::EncodedStr::Ascii("centremost"),
        &[(0b11010, &ENTRY_CENTERMOST_14667266636773107736)],
    ),
    (
        crate::EncodedStr::Ascii("centrepiece"),
        &[(0b11010, &ENTRY_CENTERPIECE_9404304832569952961)],
    ),
    (
        crate::EncodedStr::Ascii("centrepieces"),
        &[(0b11010, &ENTRY_CENTERPIECES_2175158136644578025)],
    ),
    (
        crate::EncodedStr::Ascii("centrer"),
        &[(0b11010, &ENTRY_CENTERER_1283754348315229141)],
    ),
    (
        crate::EncodedStr::Ascii("centrers"),
        &[(0b11010, &ENTRY_CENTERERS_8988197150993437622)],
    ),
    (
        crate::EncodedStr::Ascii("centres"),
        &[(0b11010, &ENTRY_CENTERS_8512068248537945159)],
    ),
    (
        crate::EncodedStr::Ascii("centreville"),
        &[(0b11010, &ENTRY_CENTERVILLE_8888927316062312202)],
    ),
    (
        crate::EncodedStr::Ascii("centrifugalisation"),
        &[(0b10010, &ENTRY_CENTRIFUGALIZATION_10319359115375445805)],
    ),
    (
        crate::EncodedStr::Ascii("centrifugalisations"),
        &[(0b10010, &ENTRY_CENTRIFUGALIZATIONS_16355479198686645900)],
    ),
    (
        crate::EncodedStr::Ascii("centrifugalise"),
        &[(0b10010, &ENTRY_CENTRIFUGALIZE_12152362034063070075)],
    ),
    (
        crate::EncodedStr::Ascii("centrifugalised"),
        &[(0b10010, &ENTRY_CENTRIFUGALIZED_16399570134709120738)],
    ),
    (
        crate::EncodedStr::Ascii("centrifugalises"),
        &[(0b10010, &ENTRY_CENTRIFUGALIZES_17016153988543053118)],
    ),
    (
        crate::EncodedStr::Ascii("centrifugalising"),
        &[(0b10010, &ENTRY_CENTRIFUGALIZING_7217121477743759122)],
    ),
    (
        crate::EncodedStr::Ascii("centrifugalization"),
        &[(0b01001, &ENTRY_CENTRIFUGALIZATION_10319359115375445805)],
    ),
    (
        crate::EncodedStr::Ascii("centrifugalizations"),
        &[(0b01001, &ENTRY_CENTRIFUGALIZATIONS_16355479198686645900)],
    ),
    (
        crate::EncodedStr::Ascii("centrifugalize"),
        &[(0b01001, &ENTRY_CENTRIFUGALIZE_12152362034063070075)],
    ),
    (
        crate::EncodedStr::Ascii("centrifugalized"),
        &[(0b01001, &ENTRY_CENTRIFUGALIZED_16399570134709120738)],
    ),
    (
        crate::EncodedStr::Ascii("centrifugalizes"),
        &[(0b01001, &ENTRY_CENTRIFUGALIZES_17016153988543053118)],
    ),
    (
        crate::EncodedStr::Ascii("centrifugalizing"),
        &[(0b01001, &ENTRY_CENTRIFUGALIZING_7217121477743759122)],
    ),
    (
        crate::EncodedStr::Ascii("centring"),
        &[(0b11010, &ENTRY_CENTERING_2288436236637604266)],
    ),
    (
        crate::EncodedStr::Ascii("centrings"),
        &[(0b11010, &ENTRY_CENTERINGS_3934315661544059303)],
    ),
    (
        crate::EncodedStr::Ascii("cephalisation"),
        &[(0b10010, &ENTRY_CEPHALIZATION_1313416802058839208)],
    ),
    (
        crate::EncodedStr::Ascii("cephalisations"),
        &[(0b10010, &ENTRY_CEPHALIZATIONS_11274159904518065511)],
    ),
    (
        crate::EncodedStr::Ascii("cephalization"),
        &[(0b01001, &ENTRY_CEPHALIZATION_1313416802058839208)],
    ),
    (
        crate::EncodedStr::Ascii("cephalizations"),
        &[(0b01001, &ENTRY_CEPHALIZATIONS_11274159904518065511)],
    ),
    (
        crate::EncodedStr::Ascii("cer"),
        &[(0b00001, &ENTRY_CER_16898181025911443964)],
    ),
    (
        crate::EncodedStr::Ascii("cera"),
        &[(0b00001, &ENTRY_CERA_7059694773303335761)],
    ),
    (
        crate::EncodedStr::Ascii("cerat"),
        &[(0b00001, &ENTRY_CERAT_1886332108569610985)],
    ),
    (
        crate::EncodedStr::Ascii("ceratin"),
        &[(0b00001, &ENTRY_CERATIN_7844527544181435388)],
    ),
    (
        crate::EncodedStr::Ascii("ceratins"),
        &[(0b00001, &ENTRY_CERATINS_7956220450419624429)],
    ),
    (
        crate::EncodedStr::Ascii("cere"),
        &[(0b00001, &ENTRY_CERE_9821157149992437937)],
    ),
    (
        crate::EncodedStr::Ascii("cerebralisation"),
        &[(0b10010, &ENTRY_CEREBRALIZATION_639759174762081390)],
    ),
    (
        crate::EncodedStr::Ascii("cerebralisations"),
        &[(0b10010, &ENTRY_CEREBRALIZATIONS_10944353801184109081)],
    ),
    (
        crate::EncodedStr::Ascii("cerebralise"),
        &[(0b10010, &ENTRY_CEREBRALIZE_4644072502748774455)],
    ),
    (
        crate::EncodedStr::Ascii("cerebralises"),
        &[(0b10010, &ENTRY_CEREBRALIZES_14811698873620229158)],
    ),
    (
        crate::EncodedStr::Ascii("cerebralization"),
        &[(0b01001, &ENTRY_CEREBRALIZATION_639759174762081390)],
    ),
    (
        crate::EncodedStr::Ascii("cerebralizations"),
        &[(0b01001, &ENTRY_CEREBRALIZATIONS_10944353801184109081)],
    ),
    (
        crate::EncodedStr::Ascii("cerebralize"),
        &[(0b01001, &ENTRY_CEREBRALIZE_4644072502748774455)],
    ),
    (
        crate::EncodedStr::Ascii("cerebralizes"),
        &[(0b01001, &ENTRY_CEREBRALIZES_14811698873620229158)],
    ),
    (
        crate::EncodedStr::Ascii("ceremonialise"),
        &[(0b10010, &ENTRY_CEREMONIALIZE_8839368071947058377)],
    ),
    (
        crate::EncodedStr::Ascii("ceremonialises"),
        &[(0b10010, &ENTRY_CEREMONIALIZES_13518074193055353148)],
    ),
    (
        crate::EncodedStr::Ascii("ceremonialize"),
        &[(0b01001, &ENTRY_CEREMONIALIZE_8839368071947058377)],
    ),
    (
        crate::EncodedStr::Ascii("ceremonializes"),
        &[(0b01001, &ENTRY_CEREMONIALIZES_13518074193055353148)],
    ),
    (
        crate::EncodedStr::Ascii("ceres"),
        &[(0b00001, &ENTRY_CERES_4278379745962029428)],
    ),
    (
        crate::EncodedStr::Ascii("cerolite"),
        &[(0b00001, &ENTRY_CEROLITE_7632841335460717740)],
    ),
    (
        crate::EncodedStr::Ascii("cerule"),
        &[(0b00001, &ENTRY_CERULE_1141707642753807571)],
    ),
    (
        crate::EncodedStr::Ascii("ceruleolactite"),
        &[(0b00001, &ENTRY_CERULEOLACTITE_1277200430318336008)],
    ),
    (
        crate::EncodedStr::Ascii("cesar"),
        &[(0b00001, &ENTRY_CESAR_6074944643525905095)],
    ),
    (
        crate::EncodedStr::Ascii("cesaria"),
        &[(0b00001, &ENTRY_CESARIA_7497611325269733598)],
    ),
    (
        crate::EncodedStr::Ascii("cesious"),
        &[(0b00001, &ENTRY_CESIOUS_10445245552084517023)],
    ),
    (
        crate::EncodedStr::Ascii("cesium"),
        &[(0b11001, &ENTRY_CESIUM_17343129911628596363)],
    ),
    (
        crate::EncodedStr::Ascii("cesiums"),
        &[(0b11001, &ENTRY_CESIUMS_4513476447764778250)],
    ),
    (
        crate::EncodedStr::Ascii("cespitose"),
        &[(0b10001, &ENTRY_CESPITOSE_2511412164776933409)],
    ),
    (
        crate::EncodedStr::Ascii("cespitosely"),
        &[(0b10001, &ENTRY_CESPITOSELY_7196666758904903124)],
    ),
    (
        crate::EncodedStr::Ascii("cestus"),
        &[(0b10001, &ENTRY_CESTUS_2264271345052468556)],
    ),
    (
        crate::EncodedStr::Ascii("cestuses"),
        &[(0b10001, &ENTRY_CESTUSES_17262448748104314423)],
    ),
    (
        crate::EncodedStr::Ascii("cesural"),
        &[(0b10001, &ENTRY_CESURAL_2827531996476826616)],
    ),
    (
        crate::EncodedStr::Ascii("cetus"),
        &[(0b10001, &ENTRY_CETUS_11617299917311809086)],
    ),
    (
        crate::EncodedStr::Ascii("chaces"),
        &[(0b10001, &ENTRY_CHACES_10965505579181904844)],
    ),
    (
        crate::EncodedStr::Ascii("chacoes"),
        &[(0b11010, &ENTRY_CHACES_10965505579181904844)],
    ),
    (
        crate::EncodedStr::Ascii("chaetopod"),
        &[(0b11010, &ENTRY_CHETOPOD_16990284463679767109)],
    ),
    (
        crate::EncodedStr::Ascii("chalazae"),
        &[(0b11010, &ENTRY_CHALAZE_4744907345488198318)],
    ),
    (
        crate::EncodedStr::Ascii("chalaze"),
        &[(0b00001, &ENTRY_CHALAZE_4744907345488198318)],
    ),
    (
        crate::EncodedStr::Ascii("chaldaeans"),
        &[(0b11010, &ENTRY_CHALDEANS_13473385401733030342)],
    ),
    (
        crate::EncodedStr::Ascii("chaldeans"),
        &[(0b00001, &ENTRY_CHALDEANS_13473385401733030342)],
    ),
    (
        crate::EncodedStr::Ascii("chameleonise"),
        &[(0b10010, &ENTRY_CHAMELEONIZE_6719282861796065512)],
    ),
    (
        crate::EncodedStr::Ascii("chameleonises"),
        &[(0b10010, &ENTRY_CHAMELEONIZES_16228445024684788006)],
    ),
    (
        crate::EncodedStr::Ascii("chameleonize"),
        &[(0b01001, &ENTRY_CHAMELEONIZE_6719282861796065512)],
    ),
    (
        crate::EncodedStr::Ascii("chameleonizes"),
        &[(0b01001, &ENTRY_CHAMELEONIZES_16228445024684788006)],
    ),
    (
        crate::EncodedStr::Ascii("chamisal"),
        &[(0b10010, &ENTRY_CHAMIZAL_15395913577609401131)],
    ),
    (
        crate::EncodedStr::Ascii("chamizal"),
        &[(0b01001, &ENTRY_CHAMIZAL_15395913577609401131)],
    ),
    (
        crate::EncodedStr::Ascii("championise"),
        &[(0b10010, &ENTRY_CHAMPIONIZE_6246420755652451774)],
    ),
    (
        crate::EncodedStr::Ascii("championises"),
        &[(0b10010, &ENTRY_CHAMPIONIZES_1300772143294053091)],
    ),
    (
        crate::EncodedStr::Ascii("championize"),
        &[(0b01001, &ENTRY_CHAMPIONIZE_6246420755652451774)],
    ),
    (
        crate::EncodedStr::Ascii("championizes"),
        &[(0b01001, &ENTRY_CHAMPIONIZES_1300772143294053091)],
    ),
    (
        crate::EncodedStr::Ascii("channeled"),
        &[(0b00001, &ENTRY_CHANNELED_13645294606351550471)],
    ),
    (
        crate::EncodedStr::Ascii("channeler"),
        &[(0b00001, &ENTRY_CHANNELER_15902006922249091823)],
    ),
    (
        crate::EncodedStr::Ascii("channelers"),
        &[(0b00001, &ENTRY_CHANNELERS_15986650866937147094)],
    ),
    (
        crate::EncodedStr::Ascii("channeling"),
        &[(0b00001, &ENTRY_CHANNELING_9266544299775335589)],
    ),
    (
        crate::EncodedStr::Ascii("channelisation"),
        &[(0b10010, &ENTRY_CHANNELIZATION_8051143060294686401)],
    ),
    (
        crate::EncodedStr::Ascii("channelisations"),
        &[(0b10010, &ENTRY_CHANNELIZATIONS_17088609630173428942)],
    ),
    (
        crate::EncodedStr::Ascii("channelise"),
        &[(0b10010, &ENTRY_CHANNELIZE_12428404691676585341)],
    ),
    (
        crate::EncodedStr::Ascii("channelised"),
        &[(0b10010, &ENTRY_CHANNELIZED_5009658046976798401)],
    ),
    (
        crate::EncodedStr::Ascii("channelises"),
        &[(0b10010, &ENTRY_CHANNELIZES_12481680265741921670)],
    ),
    (
        crate::EncodedStr::Ascii("channelising"),
        &[(0b10010, &ENTRY_CHANNELIZING_3206328004957832674)],
    ),
    (
        crate::EncodedStr::Ascii("channelization"),
        &[(0b01001, &ENTRY_CHANNELIZATION_8051143060294686401)],
    ),
    (
        crate::EncodedStr::Ascii("channelizations"),
        &[(0b01001, &ENTRY_CHANNELIZATIONS_17088609630173428942)],
    ),
    (
        crate::EncodedStr::Ascii("channelize"),
        &[(0b01001, &ENTRY_CHANNELIZE_12428404691676585341)],
    ),
    (
        crate::EncodedStr::Ascii("channelized"),
        &[(0b01001, &ENTRY_CHANNELIZED_5009658046976798401)],
    ),
    (
        crate::EncodedStr::Ascii("channelizes"),
        &[(0b01001, &ENTRY_CHANNELIZES_12481680265741921670)],
    ),
    (
        crate::EncodedStr::Ascii("channelizing"),
        &[(0b01001, &ENTRY_CHANNELIZING_3206328004957832674)],
    ),
    (
        crate::EncodedStr::Ascii("channelled"),
        &[(0b11010, &ENTRY_CHANNELED_13645294606351550471)],
    ),
    (
        crate::EncodedStr::Ascii("channeller"),
        &[(0b11010, &ENTRY_CHANNELER_15902006922249091823)],
    ),
    (
        crate::EncodedStr::Ascii("channellers"),
        &[(0b11010, &ENTRY_CHANNELERS_15986650866937147094)],
    ),
    (
        crate::EncodedStr::Ascii("channelling"),
        &[(0b11010, &ENTRY_CHANNELING_9266544299775335589)],
    ),
    (
        crate::EncodedStr::Ascii("chaptalisation"),
        &[(0b10010, &ENTRY_CHAPTALIZATION_6705837795677885132)],
    ),
    (
        crate::EncodedStr::Ascii("chaptalisations"),
        &[(0b10010, &ENTRY_CHAPTALIZATIONS_11954144109418771855)],
    ),
    (
        crate::EncodedStr::Ascii("chaptalise"),
        &[(0b10010, &ENTRY_CHAPTALIZE_3805623131812885010)],
    ),
    (
        crate::EncodedStr::Ascii("chaptalised"),
        &[(0b10010, &ENTRY_CHAPTALIZED_15614458859451523347)],
    ),
    (
        crate::EncodedStr::Ascii("chaptalises"),
        &[(0b10010, &ENTRY_CHAPTALIZES_12293081829441947782)],
    ),
    (
        crate::EncodedStr::Ascii("chaptalising"),
        &[(0b10010, &ENTRY_CHAPTALIZING_3323047688472626072)],
    ),
    (
        crate::EncodedStr::Ascii("chaptalization"),
        &[(0b01001, &ENTRY_CHAPTALIZATION_6705837795677885132)],
    ),
    (
        crate::EncodedStr::Ascii("chaptalizations"),
        &[(0b01001, &ENTRY_CHAPTALIZATIONS_11954144109418771855)],
    ),
    (
        crate::EncodedStr::Ascii("chaptalize"),
        &[(0b01001, &ENTRY_CHAPTALIZE_3805623131812885010)],
    ),
    (
        crate::EncodedStr::Ascii("chaptalized"),
        &[(0b01001, &ENTRY_CHAPTALIZED_15614458859451523347)],
    ),
    (
        crate::EncodedStr::Ascii("chaptalizes"),
        &[(0b01001, &ENTRY_CHAPTALIZES_12293081829441947782)],
    ),
    (
        crate::EncodedStr::Ascii("chaptalizing"),
        &[(0b01001, &ENTRY_CHAPTALIZING_3323047688472626072)],
    ),
    (
        crate::EncodedStr::Ascii("characterisable"),
        &[(0b10010, &ENTRY_CHARACTERIZABLE_5496268454277897612)],
    ),
    (
        crate::EncodedStr::Ascii("characterisabler"),
        &[(0b10010, &ENTRY_CHARACTERIZABLER_3425015125508980850)],
    ),
    (
        crate::EncodedStr::Ascii("characterisables"),
        &[(0b10010, &ENTRY_CHARACTERIZABLES_15907805406605774252)],
    ),
    (
        crate::EncodedStr::Ascii("characterisablest"),
        &[(0b10010, &ENTRY_CHARACTERIZABLEST_13029951397962650520)],
    ),
    (
        crate::EncodedStr::Ascii("characterisation"),
        &[(0b10010, &ENTRY_CHARACTERIZATION_14570061393281069506)],
    ),
    (
        crate::EncodedStr::Ascii("characterisations"),
        &[(0b10010, &ENTRY_CHARACTERIZATIONS_9619550519705951475)],
    ),
    (
        crate::EncodedStr::Ascii("characterise"),
        &[(0b10010, &ENTRY_CHARACTERIZE_7158652718387618717)],
    ),
    (
        crate::EncodedStr::Ascii("characterised"),
        &[(0b10010, &ENTRY_CHARACTERIZED_3099918736243105904)],
    ),
    (
        crate::EncodedStr::Ascii("characteriser"),
        &[(0b10010, &ENTRY_CHARACTERIZER_14416082234464511775)],
    ),
    (
        crate::EncodedStr::Ascii("characterisers"),
        &[(0b10010, &ENTRY_CHARACTERIZERS_11394110184099705360)],
    ),
    (
        crate::EncodedStr::Ascii("characterises"),
        &[(0b10010, &ENTRY_CHARACTERIZES_10537774223087357590)],
    ),
    (
        crate::EncodedStr::Ascii("characterising"),
        &[(0b10010, &ENTRY_CHARACTERIZING_3950440594591682040)],
    ),
    (
        crate::EncodedStr::Ascii("characterizable"),
        &[(0b01001, &ENTRY_CHARACTERIZABLE_5496268454277897612)],
    ),
    (
        crate::EncodedStr::Ascii("characterizabler"),
        &[(0b01001, &ENTRY_CHARACTERIZABLER_3425015125508980850)],
    ),
    (
        crate::EncodedStr::Ascii("characterizables"),
        &[(0b01001, &ENTRY_CHARACTERIZABLES_15907805406605774252)],
    ),
    (
        crate::EncodedStr::Ascii("characterizablest"),
        &[(0b01001, &ENTRY_CHARACTERIZABLEST_13029951397962650520)],
    ),
    (
        crate::EncodedStr::Ascii("characterization"),
        &[(0b01001, &ENTRY_CHARACTERIZATION_14570061393281069506)],
    ),
    (
        crate::EncodedStr::Ascii("characterizations"),
        &[(0b01001, &ENTRY_CHARACTERIZATIONS_9619550519705951475)],
    ),
    (
        crate::EncodedStr::Ascii("characterize"),
        &[(0b01001, &ENTRY_CHARACTERIZE_7158652718387618717)],
    ),
    (
        crate::EncodedStr::Ascii("characterized"),
        &[(0b01001, &ENTRY_CHARACTERIZED_3099918736243105904)],
    ),
    (
        crate::EncodedStr::Ascii("characterizer"),
        &[(0b01001, &ENTRY_CHARACTERIZER_14416082234464511775)],
    ),
    (
        crate::EncodedStr::Ascii("characterizers"),
        &[(0b01001, &ENTRY_CHARACTERIZERS_11394110184099705360)],
    ),
    (
        crate::EncodedStr::Ascii("characterizes"),
        &[(0b01001, &ENTRY_CHARACTERIZES_10537774223087357590)],
    ),
    (
        crate::EncodedStr::Ascii("characterizing"),
        &[(0b01001, &ENTRY_CHARACTERIZING_3950440594591682040)],
    ),
    (
        crate::EncodedStr::Ascii("charer"),
        &[(0b00001, &ENTRY_CHARER_7967793744452777217)],
    ),
    (
        crate::EncodedStr::Ascii("charre"),
        &[(0b11010, &ENTRY_CHARER_7967793744452777217)],
    ),
    (
        crate::EncodedStr::Ascii("chattelisation"),
        &[(0b10010, &ENTRY_CHATTELIZATION_7363246458991523337)],
    ),
    (
        crate::EncodedStr::Ascii("chattelisations"),
        &[(0b10010, &ENTRY_CHATTELIZATIONS_14825459471315247028)],
    ),
    (
        crate::EncodedStr::Ascii("chattelise"),
        &[(0b10010, &ENTRY_CHATTELIZE_6140490582785528527)],
    ),
    (
        crate::EncodedStr::Ascii("chattelises"),
        &[(0b10010, &ENTRY_CHATTELIZES_8748236808052543965)],
    ),
    (
        crate::EncodedStr::Ascii("chattelization"),
        &[(0b01001, &ENTRY_CHATTELIZATION_7363246458991523337)],
    ),
    (
        crate::EncodedStr::Ascii("chattelizations"),
        &[(0b01001, &ENTRY_CHATTELIZATIONS_14825459471315247028)],
    ),
    (
        crate::EncodedStr::Ascii("chattelize"),
        &[(0b01001, &ENTRY_CHATTELIZE_6140490582785528527)],
    ),
    (
        crate::EncodedStr::Ascii("chattelizes"),
        &[(0b01001, &ENTRY_CHATTELIZES_8748236808052543965)],
    ),
    (
        crate::EncodedStr::Ascii("checkbook"),
        &[(0b00001, &ENTRY_CHECKBOOK_9009854196001512796)],
    ),
    (
        crate::EncodedStr::Ascii("checkbooks"),
        &[(0b00001, &ENTRY_CHECKBOOKS_17794340270798521929)],
    ),
    (
        crate::EncodedStr::Ascii("checkerboard"),
        &[(0b00001, &ENTRY_CHECKERBOARD_8549731976664485147)],
    ),
    (
        crate::EncodedStr::Ascii("checkerboards"),
        &[(0b00001, &ENTRY_CHECKERBOARDS_18064653792576628856)],
    ),
    (
        crate::EncodedStr::Ascii("checkered"),
        &[(0b01001, &ENTRY_CHECKERED_6058427683271064427)],
    ),
    (
        crate::EncodedStr::Ascii("checkering"),
        &[(0b01001, &ENTRY_CHECKERING_13657948767544155739)],
    ),
    (
        crate::EncodedStr::Ascii("cheerfulise"),
        &[(0b10010, &ENTRY_CHEERFULIZE_762771897588790882)],
    ),
    (
        crate::EncodedStr::Ascii("cheerfulises"),
        &[(0b10010, &ENTRY_CHEERFULIZES_14800232417183976396)],
    ),
    (
        crate::EncodedStr::Ascii("cheerfulize"),
        &[(0b01001, &ENTRY_CHEERFULIZE_762771897588790882)],
    ),
    (
        crate::EncodedStr::Ascii("cheerfulizes"),
        &[(0b01001, &ENTRY_CHEERFULIZES_14800232417183976396)],
    ),
    (
        crate::EncodedStr::Ascii("cheerly"),
        &[(0b00001, &ENTRY_CHEERLY_11367263964946583096)],
    ),
    (
        crate::EncodedStr::Ascii("chelicerae"),
        &[(0b11010, &ENTRY_CHELICERE_10130398757296091498)],
    ),
    (
        crate::EncodedStr::Ascii("chelicere"),
        &[(0b00001, &ENTRY_CHELICERE_10130398757296091498)],
    ),
    (
        crate::EncodedStr::Ascii("chemicalisation"),
        &[(0b10010, &ENTRY_CHEMICALIZATION_14523349755381906432)],
    ),
    (
        crate::EncodedStr::Ascii("chemicalisations"),
        &[(0b10010, &ENTRY_CHEMICALIZATIONS_17250488376229572482)],
    ),
    (
        crate::EncodedStr::Ascii("chemicalise"),
        &[(0b10010, &ENTRY_CHEMICALIZE_2429770358300165469)],
    ),
    (
        crate::EncodedStr::Ascii("chemicalises"),
        &[(0b10010, &ENTRY_CHEMICALIZES_17947429043522126420)],
    ),
    (
        crate::EncodedStr::Ascii("chemicalization"),
        &[(0b01001, &ENTRY_CHEMICALIZATION_14523349755381906432)],
    ),
    (
        crate::EncodedStr::Ascii("chemicalizations"),
        &[(0b01001, &ENTRY_CHEMICALIZATIONS_17250488376229572482)],
    ),
    (
        crate::EncodedStr::Ascii("chemicalize"),
        &[(0b01001, &ENTRY_CHEMICALIZE_2429770358300165469)],
    ),
    (
        crate::EncodedStr::Ascii("chemicalizes"),
        &[(0b01001, &ENTRY_CHEMICALIZES_17947429043522126420)],
    ),
    (
        crate::EncodedStr::Ascii("chenix"),
        &[(0b10001, &ENTRY_CHENIX_6890496202644655006)],
    ),
    (
        crate::EncodedStr::Ascii("chenixes"),
        &[(0b10001, &ENTRY_CHENIXES_18140842653808609264)],
    ),
    (
        crate::EncodedStr::Ascii("cheque"),
        &[(0b11010, &ENTRY_CHECK_17773922188155612180)],
    ),
    (
        crate::EncodedStr::Ascii("chequebook"),
        &[(0b11010, &ENTRY_CHECKBOOK_9009854196001512796)],
    ),
    (
        crate::EncodedStr::Ascii("chequebooks"),
        &[(0b11010, &ENTRY_CHECKBOOKS_17794340270798521929)],
    ),
    (
        crate::EncodedStr::Ascii("chequed"),
        &[(0b11010, &ENTRY_CHECKED_864493317061472521)],
    ),
    (
        crate::EncodedStr::Ascii("chequer"),
        &[(0b11010, &ENTRY_CHECKER_9431957816562634502)],
    ),
    (
        crate::EncodedStr::Ascii("chequerboard"),
        &[(0b11010, &ENTRY_CHECKERBOARD_8549731976664485147)],
    ),
    (
        crate::EncodedStr::Ascii("chequerboards"),
        &[(0b11010, &ENTRY_CHECKERBOARDS_18064653792576628856)],
    ),
    (
        crate::EncodedStr::Ascii("chequered"),
        &[(0b11010, &ENTRY_CHECKERED_6058427683271064427)],
    ),
    (
        crate::EncodedStr::Ascii("chequering"),
        &[(0b11010, &ENTRY_CHECKERING_13657948767544155739)],
    ),
    (
        crate::EncodedStr::Ascii("chequers"),
        &[(0b11010, &ENTRY_CHECKERS_4651898690896940599)],
    ),
    (
        crate::EncodedStr::Ascii("cheques"),
        &[(0b11010, &ENTRY_CHECKS_5429237539074196507)],
    ),
    (
        crate::EncodedStr::Ascii("chequing"),
        &[(0b11010, &ENTRY_CHECKING_12030083975828633786)],
    ),
    (
        crate::EncodedStr::Ascii("cherely"),
        &[(0b11010, &ENTRY_CHEERLY_11367263964946583096)],
    ),
    (
        crate::EncodedStr::Ascii("chetopod"),
        &[(0b00001, &ENTRY_CHETOPOD_16990284463679767109)],
    ),
    (
        crate::EncodedStr::Ascii("chiffer"),
        &[(0b00001, &ENTRY_CHIFFER_15730952033932406541)],
    ),
    (
        crate::EncodedStr::Ascii("chiffre"),
        &[(0b11010, &ENTRY_CHIFFER_15730952033932406541)],
    ),
    (
        crate::EncodedStr::Ascii("childer"),
        &[(0b00001, &ENTRY_CHILDER_1838168120264181115)],
    ),
    (
        crate::EncodedStr::Ascii("childre"),
        &[(0b11010, &ENTRY_CHILDER_1838168120264181115)],
    ),
    (
        crate::EncodedStr::Ascii("chile"),
        &[(0b01001, &ENTRY_CHILI_17288123216260222064)],
    ),
    (
        crate::EncodedStr::Ascii("chiles"),
        &[(0b01001, &ENTRY_CHILIES_2805435102646559217)],
    ),
    (
        crate::EncodedStr::Ascii("chili"),
        &[(0b01001, &ENTRY_CHILI_17288123216260222064)],
    ),
    (
        crate::EncodedStr::Ascii("chilies"),
        &[(0b01001, &ENTRY_CHILIES_2805435102646559217)],
    ),
    (
        crate::EncodedStr::Ascii("chilis"),
        &[(0b00001, &ENTRY_CHILIES_2805435102646559217)],
    ),
    (
        crate::EncodedStr::Ascii("chilli"),
        &[(0b10011, &ENTRY_CHILI_17288123216260222064)],
    ),
    (
        crate::EncodedStr::Ascii("chillies"),
        &[(0b10011, &ENTRY_CHILIES_2805435102646559217)],
    ),
    (
        crate::EncodedStr::Ascii("chimaerid"),
        &[(0b11010, &ENTRY_CHIMERID_12786529903260126440)],
    ),
    (
        crate::EncodedStr::Ascii("chimaerids"),
        &[(0b11010, &ENTRY_CHIMERIDS_5877455725309387123)],
    ),
    (
        crate::EncodedStr::Ascii("chimaerism"),
        &[(0b11010, &ENTRY_CHIMERISM_7571951058816157382)],
    ),
    (
        crate::EncodedStr::Ascii("chimaerisms"),
        &[(0b11010, &ENTRY_CHIMERISMS_7406463563173008857)],
    ),
    (
        crate::EncodedStr::Ascii("chimerid"),
        &[(0b00001, &ENTRY_CHIMERID_12786529903260126440)],
    ),
    (
        crate::EncodedStr::Ascii("chimerids"),
        &[(0b00001, &ENTRY_CHIMERIDS_5877455725309387123)],
    ),
    (
        crate::EncodedStr::Ascii("chimerism"),
        &[(0b00001, &ENTRY_CHIMERISM_7571951058816157382)],
    ),
    (
        crate::EncodedStr::Ascii("chimerisms"),
        &[(0b00001, &ENTRY_CHIMERISMS_7406463563173008857)],
    ),
    (
        crate::EncodedStr::Ascii("chiseled"),
        &[(0b00001, &ENTRY_CHISELED_4085439916793683323)],
    ),
    (
        crate::EncodedStr::Ascii("chiseler"),
        &[(0b00001, &ENTRY_CHISELER_5457396429234167127)],
    ),
    (
        crate::EncodedStr::Ascii("chiselers"),
        &[(0b00001, &ENTRY_CHISELERS_2484752867150137049)],
    ),
    (
        crate::EncodedStr::Ascii("chiseling"),
        &[(0b00001, &ENTRY_CHISELING_10949176651834943898)],
    ),
    (
        crate::EncodedStr::Ascii("chloraemia"),
        &[(0b11010, &ENTRY_CHLOREMIA_11927970491263400748)],
    ),
    (
        crate::EncodedStr::Ascii("chloranaemia"),
        &[(0b11010, &ENTRY_CHLORANEMIA_14943573677886171490)],
    ),
    (
        crate::EncodedStr::Ascii("chloranemia"),
        &[(0b10001, &ENTRY_CHLORANEMIA_14943573677886171490)],
    ),
    (
        crate::EncodedStr::Ascii("chloremia"),
        &[(0b10001, &ENTRY_CHLOREMIA_11927970491263400748)],
    ),
    (
        crate::EncodedStr::Ascii("chloridise"),
        &[(0b10010, &ENTRY_CHLORIDIZE_15852197382856458938)],
    ),
    (
        crate::EncodedStr::Ascii("chloridised"),
        &[(0b10010, &ENTRY_CHLORIDIZED_12549087814443170120)],
    ),
    (
        crate::EncodedStr::Ascii("chloridises"),
        &[(0b10010, &ENTRY_CHLORIDIZES_10968236782051706807)],
    ),
    (
        crate::EncodedStr::Ascii("chloridising"),
        &[(0b10010, &ENTRY_CHLORIDIZING_13412386735842532684)],
    ),
    (
        crate::EncodedStr::Ascii("chloridize"),
        &[(0b01001, &ENTRY_CHLORIDIZE_15852197382856458938)],
    ),
    (
        crate::EncodedStr::Ascii("chloridized"),
        &[(0b01001, &ENTRY_CHLORIDIZED_12549087814443170120)],
    ),
    (
        crate::EncodedStr::Ascii("chloridizes"),
        &[(0b01001, &ENTRY_CHLORIDIZES_10968236782051706807)],
    ),
    (
        crate::EncodedStr::Ascii("chloridizing"),
        &[(0b01001, &ENTRY_CHLORIDIZING_13412386735842532684)],
    ),
    (
        crate::EncodedStr::Ascii("chlorinise"),
        &[(0b10010, &ENTRY_CHLORINIZE_4322542416170463875)],
    ),
    (
        crate::EncodedStr::Ascii("chlorinised"),
        &[(0b10010, &ENTRY_CHLORINIZED_17584986266499508813)],
    ),
    (
        crate::EncodedStr::Ascii("chlorinises"),
        &[(0b10010, &ENTRY_CHLORINIZES_6611213572390335959)],
    ),
    (
        crate::EncodedStr::Ascii("chlorinising"),
        &[(0b10010, &ENTRY_CHLORINIZING_11381892907334769846)],
    ),
    (
        crate::EncodedStr::Ascii("chlorinize"),
        &[(0b01001, &ENTRY_CHLORINIZE_4322542416170463875)],
    ),
    (
        crate::EncodedStr::Ascii("chlorinized"),
        &[(0b01001, &ENTRY_CHLORINIZED_17584986266499508813)],
    ),
    (
        crate::EncodedStr::Ascii("chlorinizes"),
        &[(0b01001, &ENTRY_CHLORINIZES_6611213572390335959)],
    ),
    (
        crate::EncodedStr::Ascii("chlorinizing"),
        &[(0b01001, &ENTRY_CHLORINIZING_11381892907334769846)],
    ),
    (
        crate::EncodedStr::Ascii("chloritisation"),
        &[(0b10010, &ENTRY_CHLORITIZATION_6329588467839471117)],
    ),
    (
        crate::EncodedStr::Ascii("chloritisations"),
        &[(0b10010, &ENTRY_CHLORITIZATIONS_14114607753454173066)],
    ),
    (
        crate::EncodedStr::Ascii("chloritization"),
        &[(0b01001, &ENTRY_CHLORITIZATION_6329588467839471117)],
    ),
    (
        crate::EncodedStr::Ascii("chloritizations"),
        &[(0b01001, &ENTRY_CHLORITIZATIONS_14114607753454173066)],
    ),
    (
        crate::EncodedStr::Ascii("chloroanaemia"),
        &[(0b11010, &ENTRY_CHLOROANEMIA_6563825885243058247)],
    ),
    (
        crate::EncodedStr::Ascii("chloroanemia"),
        &[(0b10001, &ENTRY_CHLOROANEMIA_6563825885243058247)],
    ),
    (
        crate::EncodedStr::Ascii("chloroformisation"),
        &[(0b10010, &ENTRY_CHLOROFORMIZATION_18266136341140668534)],
    ),
    (
        crate::EncodedStr::Ascii("chloroformisations"),
        &[(0b10010, &ENTRY_CHLOROFORMIZATIONS_10258939630473669855)],
    ),
    (
        crate::EncodedStr::Ascii("chloroformise"),
        &[(0b10010, &ENTRY_CHLOROFORMIZE_4267369403631594202)],
    ),
    (
        crate::EncodedStr::Ascii("chloroformises"),
        &[(0b10010, &ENTRY_CHLOROFORMIZES_15872749603216002935)],
    ),
    (
        crate::EncodedStr::Ascii("chloroformization"),
        &[(0b01001, &ENTRY_CHLOROFORMIZATION_18266136341140668534)],
    ),
    (
        crate::EncodedStr::Ascii("chloroformizations"),
        &[(0b01001, &ENTRY_CHLOROFORMIZATIONS_10258939630473669855)],
    ),
    (
        crate::EncodedStr::Ascii("chloroformize"),
        &[(0b01001, &ENTRY_CHLOROFORMIZE_4267369403631594202)],
    ),
    (
        crate::EncodedStr::Ascii("chloroformizes"),
        &[(0b01001, &ENTRY_CHLOROFORMIZES_15872749603216002935)],
    ),
    (
        crate::EncodedStr::Ascii("choaephori"),
        &[(0b11010, &ENTRY_CHOEPHORI_13897909648270625076)],
    ),
    (
        crate::EncodedStr::Ascii("choenix"),
        &[(0b11010, &ENTRY_CHENIX_6890496202644655006)],
    ),
    (
        crate::EncodedStr::Ascii("choenixes"),
        &[(0b11010, &ENTRY_CHENIXES_18140842653808609264)],
    ),
    (
        crate::EncodedStr::Ascii("choephori"),
        &[(0b00001, &ENTRY_CHOEPHORI_13897909648270625076)],
    ),
    (
        crate::EncodedStr::Ascii("cholaemia"),
        &[(0b11010, &ENTRY_CHOLEMIA_10472935038101851986)],
    ),
    (
        crate::EncodedStr::Ascii("cholaemias"),
        &[(0b11010, &ENTRY_CHOLEMIAS_1320999302245492995)],
    ),
    (
        crate::EncodedStr::Ascii("cholemia"),
        &[(0b00001, &ENTRY_CHOLEMIA_10472935038101851986)],
    ),
    (
        crate::EncodedStr::Ascii("cholemias"),
        &[(0b00001, &ENTRY_CHOLEMIAS_1320999302245492995)],
    ),
    (
        crate::EncodedStr::Ascii("cholophaein"),
        &[(0b11010, &ENTRY_CHOLOPHEIN_3609148772555478472)],
    ),
    (
        crate::EncodedStr::Ascii("cholophein"),
        &[(0b00001, &ENTRY_CHOLOPHEIN_3609148772555478472)],
    ),
    (
        crate::EncodedStr::Ascii("chorisation"),
        &[(0b10010, &ENTRY_CHORIZATION_2744114980681106174)],
    ),
    (
        crate::EncodedStr::Ascii("chorisations"),
        &[(0b10010, &ENTRY_CHORIZATIONS_15797795758878758614)],
    ),
    (
        crate::EncodedStr::Ascii("chorization"),
        &[(0b01001, &ENTRY_CHORIZATION_2744114980681106174)],
    ),
    (
        crate::EncodedStr::Ascii("chorizations"),
        &[(0b01001, &ENTRY_CHORIZATIONS_15797795758878758614)],
    ),
    (
        crate::EncodedStr::Ascii("christianisation"),
        &[(0b10010, &ENTRY_CHRISTIANIZATION_18360975039569708955)],
    ),
    (
        crate::EncodedStr::Ascii("christianisations"),
        &[(0b10010, &ENTRY_CHRISTIANIZATIONS_939157464750574119)],
    ),
    (
        crate::EncodedStr::Ascii("christianise"),
        &[(0b10010, &ENTRY_CHRISTIANIZE_17043173566737823874)],
    ),
    (
        crate::EncodedStr::Ascii("christianised"),
        &[(0b10010, &ENTRY_CHRISTIANIZED_2305498091852997860)],
    ),
    (
        crate::EncodedStr::Ascii("christianiser"),
        &[(0b10010, &ENTRY_CHRISTIANIZER_12661100042100507791)],
    ),
    (
        crate::EncodedStr::Ascii("christianisers"),
        &[(0b10010, &ENTRY_CHRISTIANIZERS_2108724649580713236)],
    ),
    (
        crate::EncodedStr::Ascii("christianises"),
        &[(0b10010, &ENTRY_CHRISTIANIZES_14805680753012611713)],
    ),
    (
        crate::EncodedStr::Ascii("christianising"),
        &[(0b10010, &ENTRY_CHRISTIANIZING_3955473617595650674)],
    ),
    (
        crate::EncodedStr::Ascii("christianization"),
        &[(0b01001, &ENTRY_CHRISTIANIZATION_18360975039569708955)],
    ),
    (
        crate::EncodedStr::Ascii("christianizations"),
        &[(0b01001, &ENTRY_CHRISTIANIZATIONS_939157464750574119)],
    ),
    (
        crate::EncodedStr::Ascii("christianize"),
        &[(0b01001, &ENTRY_CHRISTIANIZE_17043173566737823874)],
    ),
    (
        crate::EncodedStr::Ascii("christianized"),
        &[(0b01001, &ENTRY_CHRISTIANIZED_2305498091852997860)],
    ),
    (
        crate::EncodedStr::Ascii("christianizer"),
        &[(0b01001, &ENTRY_CHRISTIANIZER_12661100042100507791)],
    ),
    (
        crate::EncodedStr::Ascii("christianizers"),
        &[(0b01001, &ENTRY_CHRISTIANIZERS_2108724649580713236)],
    ),
    (
        crate::EncodedStr::Ascii("christianizes"),
        &[(0b01001, &ENTRY_CHRISTIANIZES_14805680753012611713)],
    ),
    (
        crate::EncodedStr::Ascii("christianizing"),
        &[(0b01001, &ENTRY_CHRISTIANIZING_3955473617595650674)],
    ),
    (
        crate::EncodedStr::Ascii("chromaesthesia"),
        &[(0b11010, &ENTRY_CHROMESTHESIA_3768057935676918572)],
    ),
    (
        crate::EncodedStr::Ascii("chromatise"),
        &[(0b10010, &ENTRY_CHROMATIZE_11372633214051605374)],
    ),
    (
        crate::EncodedStr::Ascii("chromatises"),
        &[(0b10010, &ENTRY_CHROMATIZES_8188945171625541176)],
    ),
    (
        crate::EncodedStr::Ascii("chromatize"),
        &[(0b01001, &ENTRY_CHROMATIZE_11372633214051605374)],
    ),
    (
        crate::EncodedStr::Ascii("chromatizes"),
        &[(0b01001, &ENTRY_CHROMATIZES_8188945171625541176)],
    ),
    (
        crate::EncodedStr::Ascii("chromesthesia"),
        &[(0b00001, &ENTRY_CHROMESTHESIA_3768057935676918572)],
    ),
    (
        crate::EncodedStr::Ascii("chromicise"),
        &[(0b10010, &ENTRY_CHROMICIZE_2411849466836240319)],
    ),
    (
        crate::EncodedStr::Ascii("chromicises"),
        &[(0b10010, &ENTRY_CHROMICIZES_17571169233071174152)],
    ),
    (
        crate::EncodedStr::Ascii("chromicize"),
        &[(0b01001, &ENTRY_CHROMICIZE_2411849466836240319)],
    ),
    (
        crate::EncodedStr::Ascii("chromicizes"),
        &[(0b01001, &ENTRY_CHROMICIZES_17571169233071174152)],
    ),
    (
        crate::EncodedStr::Ascii("chromise"),
        &[(0b10010, &ENTRY_CHROMIZE_5262872595657112785)],
    ),
    (
        crate::EncodedStr::Ascii("chromised"),
        &[(0b10010, &ENTRY_CHROMIZED_10186147401749465104)],
    ),
    (
        crate::EncodedStr::Ascii("chromises"),
        &[(0b10010, &ENTRY_CHROMIZES_15865986984042622696)],
    ),
    (
        crate::EncodedStr::Ascii("chromising"),
        &[(0b10010, &ENTRY_CHROMIZING_1826459851914480574)],
    ),
    (
        crate::EncodedStr::Ascii("chromize"),
        &[(0b01001, &ENTRY_CHROMIZE_5262872595657112785)],
    ),
    (
        crate::EncodedStr::Ascii("chromized"),
        &[(0b01001, &ENTRY_CHROMIZED_10186147401749465104)],
    ),
    (
        crate::EncodedStr::Ascii("chromizes"),
        &[(0b01001, &ENTRY_CHROMIZES_15865986984042622696)],
    ),
    (
        crate::EncodedStr::Ascii("chromizing"),
        &[(0b01001, &ENTRY_CHROMIZING_1826459851914480574)],
    ),
    (
        crate::EncodedStr::Ascii("chronologise"),
        &[(0b10010, &ENTRY_CHRONOLOGIZE_12846965199938511954)],
    ),
    (
        crate::EncodedStr::Ascii("chronologised"),
        &[(0b10010, &ENTRY_CHRONOLOGIZED_5845452320056255894)],
    ),
    (
        crate::EncodedStr::Ascii("chronologises"),
        &[(0b10010, &ENTRY_CHRONOLOGIZES_11841064468767540761)],
    ),
    (
        crate::EncodedStr::Ascii("chronologising"),
        &[(0b10010, &ENTRY_CHRONOLOGIZING_3430096775276619170)],
    ),
    (
        crate::EncodedStr::Ascii("chronologize"),
        &[(0b01001, &ENTRY_CHRONOLOGIZE_12846965199938511954)],
    ),
    (
        crate::EncodedStr::Ascii("chronologized"),
        &[(0b01001, &ENTRY_CHRONOLOGIZED_5845452320056255894)],
    ),
    (
        crate::EncodedStr::Ascii("chronologizes"),
        &[(0b01001, &ENTRY_CHRONOLOGIZES_11841064468767540761)],
    ),
    (
        crate::EncodedStr::Ascii("chronologizing"),
        &[(0b01001, &ENTRY_CHRONOLOGIZING_3430096775276619170)],
    ),
    (
        crate::EncodedStr::Ascii("cicatriculae"),
        &[(0b11010, &ENTRY_CICATRICULE_5186934031307821263)],
    ),
    (
        crate::EncodedStr::Ascii("cicatricule"),
        &[(0b00001, &ENTRY_CICATRICULE_5186934031307821263)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrisant"),
        &[(0b10010, &ENTRY_CICATRIZANT_12486636820913979450)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrisate"),
        &[(0b10010, &ENTRY_CICATRIZATE_4590503640777088427)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrisation"),
        &[(0b10010, &ENTRY_CICATRIZATION_12095729010218257569)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrisations"),
        &[(0b10010, &ENTRY_CICATRIZATIONS_18248179778439022462)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrise"),
        &[(0b10010, &ENTRY_CICATRIZE_17449239625442097002)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrised"),
        &[(0b10010, &ENTRY_CICATRIZED_1926551778073289264)],
    ),
    (
        crate::EncodedStr::Ascii("cicatriser"),
        &[(0b10010, &ENTRY_CICATRIZER_13415710374354046728)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrises"),
        &[(0b10010, &ENTRY_CICATRIZES_18063560548351573209)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrising"),
        &[(0b10010, &ENTRY_CICATRIZING_13257780105810264437)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrixes"),
        &[(0b00001, &ENTRY_CICATRICES_6326588841275377818)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrizant"),
        &[(0b01001, &ENTRY_CICATRIZANT_12486636820913979450)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrizate"),
        &[(0b01001, &ENTRY_CICATRIZATE_4590503640777088427)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrization"),
        &[(0b01001, &ENTRY_CICATRIZATION_12095729010218257569)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrizations"),
        &[(0b01001, &ENTRY_CICATRIZATIONS_18248179778439022462)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrize"),
        &[(0b01001, &ENTRY_CICATRIZE_17449239625442097002)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrized"),
        &[(0b01001, &ENTRY_CICATRIZED_1926551778073289264)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrizer"),
        &[(0b01001, &ENTRY_CICATRIZER_13415710374354046728)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrizes"),
        &[(0b01001, &ENTRY_CICATRIZES_18063560548351573209)],
    ),
    (
        crate::EncodedStr::Ascii("cicatrizing"),
        &[(0b01001, &ENTRY_CICATRIZING_13257780105810264437)],
    ),
    (
        crate::EncodedStr::Ascii("ciceronianise"),
        &[(0b10010, &ENTRY_CICERONIANIZE_15017821268740384544)],
    ),
    (
        crate::EncodedStr::Ascii("ciceronianises"),
        &[(0b10010, &ENTRY_CICERONIANIZES_12944202395538543019)],
    ),
    (
        crate::EncodedStr::Ascii("ciceronianize"),
        &[(0b01001, &ENTRY_CICERONIANIZE_15017821268740384544)],
    ),
    (
        crate::EncodedStr::Ascii("ciceronianizes"),
        &[(0b01001, &ENTRY_CICERONIANIZES_12944202395538543019)],
    ),
    (
        crate::EncodedStr::Ascii("cigaret"),
        &[(0b00001, &ENTRY_CIGARETTE_3240954964785468511)],
    ),
    (
        crate::EncodedStr::Ascii("cigarets"),
        &[(0b00001, &ENTRY_CIGARETTES_2896249679667819882)],
    ),
    (
        crate::EncodedStr::Ascii("cimicidae"),
        &[(0b11010, &ENTRY_CIMICIDE_252691567770959002)],
    ),
    (
        crate::EncodedStr::Ascii("cimicide"),
        &[(0b00001, &ENTRY_CIMICIDE_252691567770959002)],
    ),
    (
        crate::EncodedStr::Ascii("cinchonisation"),
        &[(0b10010, &ENTRY_CINCHONIZATION_10888105560110104460)],
    ),
    (
        crate::EncodedStr::Ascii("cinchonisations"),
        &[(0b10010, &ENTRY_CINCHONIZATIONS_6677879833142170709)],
    ),
    (
        crate::EncodedStr::Ascii("cinchonise"),
        &[(0b10010, &ENTRY_CINCHONIZE_14048235966165265995)],
    ),
    (
        crate::EncodedStr::Ascii("cinchonised"),
        &[(0b10010, &ENTRY_CINCHONIZED_1697201765172263780)],
    ),
    (
        crate::EncodedStr::Ascii("cinchonises"),
        &[(0b10010, &ENTRY_CINCHONIZES_1522582946661651319)],
    ),
    (
        crate::EncodedStr::Ascii("cinchonising"),
        &[(0b10010, &ENTRY_CINCHONIZING_12181226423066017076)],
    ),
    (
        crate::EncodedStr::Ascii("cinchonization"),
        &[(0b01001, &ENTRY_CINCHONIZATION_10888105560110104460)],
    ),
    (
        crate::EncodedStr::Ascii("cinchonizations"),
        &[(0b01001, &ENTRY_CINCHONIZATIONS_6677879833142170709)],
    ),
    (
        crate::EncodedStr::Ascii("cinchonize"),
        &[(0b01001, &ENTRY_CINCHONIZE_14048235966165265995)],
    ),
    (
        crate::EncodedStr::Ascii("cinchonized"),
        &[(0b01001, &ENTRY_CINCHONIZED_1697201765172263780)],
    ),
    (
        crate::EncodedStr::Ascii("cinchonizes"),
        &[(0b01001, &ENTRY_CINCHONIZES_1522582946661651319)],
    ),
    (
        crate::EncodedStr::Ascii("cinchonizing"),
        &[(0b01001, &ENTRY_CINCHONIZING_12181226423066017076)],
    ),
    (
        crate::EncodedStr::Ascii("cinematise"),
        &[(0b10010, &ENTRY_CINEMATIZE_14141234202546792174)],
    ),
    (
        crate::EncodedStr::Ascii("cinematize"),
        &[(0b01001, &ENTRY_CINEMATIZE_14141234202546792174)],
    ),
    (
        crate::EncodedStr::Ascii("cinter"),
        &[(0b00001, &ENTRY_CINTER_5255881384560882873)],
    ),
    (
        crate::EncodedStr::Ascii("cintre"),
        &[(0b11010, &ENTRY_CINTER_5255881384560882873)],
    ),
    (
        crate::EncodedStr::Ascii("circaean"),
        &[(0b11010, &ENTRY_CIRCEAN_2837826078225645071)],
    ),
    (
        crate::EncodedStr::Ascii("circean"),
        &[(0b00001, &ENTRY_CIRCEAN_2837826078225645071)],
    ),
    (
        crate::EncodedStr::Ascii("circularisation"),
        &[(0b10010, &ENTRY_CIRCULARIZATION_17838622241027218582)],
    ),
    (
        crate::EncodedStr::Ascii("circularisations"),
        &[(0b10010, &ENTRY_CIRCULARIZATIONS_1984387235149986914)],
    ),
    (
        crate::EncodedStr::Ascii("circularise"),
        &[(0b10010, &ENTRY_CIRCULARIZE_168549599908464304)],
    ),
    (
        crate::EncodedStr::Ascii("circularised"),
        &[(0b10010, &ENTRY_CIRCULARIZED_17077855093521846327)],
    ),
    (
        crate::EncodedStr::Ascii("circulariser"),
        &[(0b10010, &ENTRY_CIRCULARIZER_10781935971896485951)],
    ),
    (
        crate::EncodedStr::Ascii("circularisers"),
        &[(0b10010, &ENTRY_CIRCULARIZERS_9484517890337368712)],
    ),
    (
        crate::EncodedStr::Ascii("circularises"),
        &[(0b10010, &ENTRY_CIRCULARIZES_5373385699289469463)],
    ),
    (
        crate::EncodedStr::Ascii("circularising"),
        &[(0b10010, &ENTRY_CIRCULARIZING_13000180152805667363)],
    ),
    (
        crate::EncodedStr::Ascii("circularization"),
        &[(0b01001, &ENTRY_CIRCULARIZATION_17838622241027218582)],
    ),
    (
        crate::EncodedStr::Ascii("circularizations"),
        &[(0b01001, &ENTRY_CIRCULARIZATIONS_1984387235149986914)],
    ),
    (
        crate::EncodedStr::Ascii("circularize"),
        &[(0b01001, &ENTRY_CIRCULARIZE_168549599908464304)],
    ),
    (
        crate::EncodedStr::Ascii("circularized"),
        &[(0b01001, &ENTRY_CIRCULARIZED_17077855093521846327)],
    ),
    (
        crate::EncodedStr::Ascii("circularizer"),
        &[(0b01001, &ENTRY_CIRCULARIZER_10781935971896485951)],
    ),
    (
        crate::EncodedStr::Ascii("circularizers"),
        &[(0b01001, &ENTRY_CIRCULARIZERS_9484517890337368712)],
    ),
    (
        crate::EncodedStr::Ascii("circularizes"),
        &[(0b01001, &ENTRY_CIRCULARIZES_5373385699289469463)],
    ),
    (
        crate::EncodedStr::Ascii("circularizing"),
        &[(0b01001, &ENTRY_CIRCULARIZING_13000180152805667363)],
    ),
    (
        crate::EncodedStr::Ascii("circumcenter"),
        &[(0b00001, &ENTRY_CIRCUMCENTER_207116320690761995)],
    ),
    (
        crate::EncodedStr::Ascii("circumcenters"),
        &[(0b00001, &ENTRY_CIRCUMCENTERS_3631459482063575085)],
    ),
    (
        crate::EncodedStr::Ascii("circumcentre"),
        &[(0b11010, &ENTRY_CIRCUMCENTER_207116320690761995)],
    ),
    (
        crate::EncodedStr::Ascii("circumcentres"),
        &[(0b11010, &ENTRY_CIRCUMCENTERS_3631459482063575085)],
    ),
    (
        crate::EncodedStr::Ascii("circumesophagal"),
        &[(0b00001, &ENTRY_CIRCUMESOPHAGAL_14446114158922149948)],
    ),
    (
        crate::EncodedStr::Ascii("circumoesophagal"),
        &[(0b11010, &ENTRY_CIRCUMESOPHAGAL_14446114158922149948)],
    ),
    (
        crate::EncodedStr::Ascii("cise"),
        &[(0b10010, &ENTRY_CIZE_6818406889408576007)],
    ),
    (
        crate::EncodedStr::Ascii("cithern"),
        &[(0b00001, &ENTRY_CITHERN_6627389279929637643)],
    ),
    (
        crate::EncodedStr::Ascii("citherns"),
        &[(0b00001, &ENTRY_CITHERNS_14301574885087358999)],
    ),
    (
        crate::EncodedStr::Ascii("cithren"),
        &[(0b11010, &ENTRY_CITHERN_6627389279929637643)],
    ),
    (
        crate::EncodedStr::Ascii("cithrens"),
        &[(0b11010, &ENTRY_CITHERNS_14301574885087358999)],
    ),
    (
        crate::EncodedStr::Ascii("citizenise"),
        &[(0b10010, &ENTRY_CITIZENIZE_14957512849570966194)],
    ),
    (
        crate::EncodedStr::Ascii("citizenised"),
        &[(0b10010, &ENTRY_CITIZENIZED_1264772045676693507)],
    ),
    (
        crate::EncodedStr::Ascii("citizenises"),
        &[(0b10010, &ENTRY_CITIZENIZES_18430750407999070293)],
    ),
    (
        crate::EncodedStr::Ascii("citizenising"),
        &[(0b10010, &ENTRY_CITIZENIZING_4863665565831279155)],
    ),
    (
        crate::EncodedStr::Ascii("citizenize"),
        &[(0b01001, &ENTRY_CITIZENIZE_14957512849570966194)],
    ),
    (
        crate::EncodedStr::Ascii("citizenized"),
        &[(0b01001, &ENTRY_CITIZENIZED_1264772045676693507)],
    ),
    (
        crate::EncodedStr::Ascii("citizenizes"),
        &[(0b01001, &ENTRY_CITIZENIZES_18430750407999070293)],
    ),
    (
        crate::EncodedStr::Ascii("citizenizing"),
        &[(0b01001, &ENTRY_CITIZENIZING_4863665565831279155)],
    ),
    (
        crate::EncodedStr::Ascii("civilianisation"),
        &[(0b10010, &ENTRY_CIVILIANIZATION_17575505866978524289)],
    ),
    (
        crate::EncodedStr::Ascii("civilianisations"),
        &[(0b10010, &ENTRY_CIVILIANIZATIONS_17045136972884179633)],
    ),
    (
        crate::EncodedStr::Ascii("civilianise"),
        &[(0b10010, &ENTRY_CIVILIANIZE_4503116173799461974)],
    ),
    (
        crate::EncodedStr::Ascii("civilianised"),
        &[(0b10010, &ENTRY_CIVILIANIZED_15443763184741606790)],
    ),
    (
        crate::EncodedStr::Ascii("civilianises"),
        &[(0b10010, &ENTRY_CIVILIANIZES_1873437655700489131)],
    ),
    (
        crate::EncodedStr::Ascii("civilianising"),
        &[(0b10010, &ENTRY_CIVILIANIZING_10886647865038667032)],
    ),
    (
        crate::EncodedStr::Ascii("civilianization"),
        &[(0b01001, &ENTRY_CIVILIANIZATION_17575505866978524289)],
    ),
    (
        crate::EncodedStr::Ascii("civilianizations"),
        &[(0b01001, &ENTRY_CIVILIANIZATIONS_17045136972884179633)],
    ),
    (
        crate::EncodedStr::Ascii("civilianize"),
        &[(0b01001, &ENTRY_CIVILIANIZE_4503116173799461974)],
    ),
    (
        crate::EncodedStr::Ascii("civilianized"),
        &[(0b01001, &ENTRY_CIVILIANIZED_15443763184741606790)],
    ),
    (
        crate::EncodedStr::Ascii("civilianizes"),
        &[(0b01001, &ENTRY_CIVILIANIZES_1873437655700489131)],
    ),
    (
        crate::EncodedStr::Ascii("civilianizing"),
        &[(0b01001, &ENTRY_CIVILIANIZING_10886647865038667032)],
    ),
    (
        crate::EncodedStr::Ascii("civilisable"),
        &[(0b10010, &ENTRY_CIVILIZABLE_12250954830034270586)],
    ),
    (
        crate::EncodedStr::Ascii("civilisabler"),
        &[(0b10010, &ENTRY_CIVILIZABLER_1009443025003033054)],
    ),
    (
        crate::EncodedStr::Ascii("civilisables"),
        &[(0b10010, &ENTRY_CIVILIZABLES_6992110506684451627)],
    ),
    (
        crate::EncodedStr::Ascii("civilisablest"),
        &[(0b10010, &ENTRY_CIVILIZABLEST_10363624488321164576)],
    ),
    (
        crate::EncodedStr::Ascii("civilisation"),
        &[(0b10010, &ENTRY_CIVILIZATION_15013403646640920675)],
    ),
    (
        crate::EncodedStr::Ascii("civilisational"),
        &[(0b10010, &ENTRY_CIVILIZATIONAL_6714937636315886610)],
    ),
    (
        crate::EncodedStr::Ascii("civilisationaler"),
        &[(0b10010, &ENTRY_CIVILIZATIONALER_2223864160765042134)],
    ),
    (
        crate::EncodedStr::Ascii("civilisationalest"),
        &[(0b10010, &ENTRY_CIVILIZATIONALEST_8468211002452117483)],
    ),
    (
        crate::EncodedStr::Ascii("civilisationals"),
        &[(0b10010, &ENTRY_CIVILIZATIONALS_16890543284368506921)],
    ),
    (
        crate::EncodedStr::Ascii("civilisations"),
        &[(0b10010, &ENTRY_CIVILIZATIONS_10559611739235699948)],
    ),
    (
        crate::EncodedStr::Ascii("civilisatory"),
        &[(0b10010, &ENTRY_CIVILIZATORY_1986047737625317948)],
    ),
    (
        crate::EncodedStr::Ascii("civilise"),
        &[(0b10010, &ENTRY_CIVILIZE_11305300708024681316)],
    ),
    (
        crate::EncodedStr::Ascii("civilised"),
        &[(0b10010, &ENTRY_CIVILIZED_12545974517817432534)],
    ),
    (
        crate::EncodedStr::Ascii("civilisedness"),
        &[(0b10010, &ENTRY_CIVILIZEDNESS_8991979933830574813)],
    ),
    (
        crate::EncodedStr::Ascii("civilisednesses"),
        &[(0b10010, &ENTRY_CIVILIZEDNESSES_12980539923790842297)],
    ),
    (
        crate::EncodedStr::Ascii("civiliser"),
        &[(0b10010, &ENTRY_CIVILIZER_6543816336610065762)],
    ),
    (
        crate::EncodedStr::Ascii("civilisers"),
        &[(0b10010, &ENTRY_CIVILIZERS_15636793990348820949)],
    ),
    (
        crate::EncodedStr::Ascii("civilises"),
        &[(0b10010, &ENTRY_CIVILIZES_10418281941070358506)],
    ),
    (
        crate::EncodedStr::Ascii("civilising"),
        &[(0b10010, &ENTRY_CIVILIZING_14404215502589538333)],
    ),
    (
        crate::EncodedStr::Ascii("civilizable"),
        &[(0b01001, &ENTRY_CIVILIZABLE_12250954830034270586)],
    ),
    (
        crate::EncodedStr::Ascii("civilizabler"),
        &[(0b01001, &ENTRY_CIVILIZABLER_1009443025003033054)],
    ),
    (
        crate::EncodedStr::Ascii("civilizables"),
        &[(0b01001, &ENTRY_CIVILIZABLES_6992110506684451627)],
    ),
    (
        crate::EncodedStr::Ascii("civilizablest"),
        &[(0b01001, &ENTRY_CIVILIZABLEST_10363624488321164576)],
    ),
    (
        crate::EncodedStr::Ascii("civilization"),
        &[(0b01001, &ENTRY_CIVILIZATION_15013403646640920675)],
    ),
    (
        crate::EncodedStr::Ascii("civilizational"),
        &[(0b01001, &ENTRY_CIVILIZATIONAL_6714937636315886610)],
    ),
    (
        crate::EncodedStr::Ascii("civilizationaler"),
        &[(0b01001, &ENTRY_CIVILIZATIONALER_2223864160765042134)],
    ),
    (
        crate::EncodedStr::Ascii("civilizationalest"),
        &[(0b01001, &ENTRY_CIVILIZATIONALEST_8468211002452117483)],
    ),
    (
        crate::EncodedStr::Ascii("civilizationals"),
        &[(0b01001, &ENTRY_CIVILIZATIONALS_16890543284368506921)],
    ),
    (
        crate::EncodedStr::Ascii("civilizations"),
        &[(0b01001, &ENTRY_CIVILIZATIONS_10559611739235699948)],
    ),
    (
        crate::EncodedStr::Ascii("civilizatory"),
        &[(0b01001, &ENTRY_CIVILIZATORY_1986047737625317948)],
    ),
    (
        crate::EncodedStr::Ascii("civilize"),
        &[(0b01001, &ENTRY_CIVILIZE_11305300708024681316)],
    ),
    (
        crate::EncodedStr::Ascii("civilized"),
        &[(0b01001, &ENTRY_CIVILIZED_12545974517817432534)],
    ),
    (
        crate::EncodedStr::Ascii("civilizedness"),
        &[(0b01001, &ENTRY_CIVILIZEDNESS_8991979933830574813)],
    ),
    (
        crate::EncodedStr::Ascii("civilizednesses"),
        &[(0b01001, &ENTRY_CIVILIZEDNESSES_12980539923790842297)],
    ),
    (
        crate::EncodedStr::Ascii("civilizer"),
        &[(0b01001, &ENTRY_CIVILIZER_6543816336610065762)],
    ),
    (
        crate::EncodedStr::Ascii("civilizers"),
        &[(0b01001, &ENTRY_CIVILIZERS_15636793990348820949)],
    ),
    (
        crate::EncodedStr::Ascii("civilizes"),
        &[(0b01001, &ENTRY_CIVILIZES_10418281941070358506)],
    ),
    (
        crate::EncodedStr::Ascii("civilizing"),
        &[(0b01001, &ENTRY_CIVILIZING_14404215502589538333)],
    ),
    (
        crate::EncodedStr::Ascii("cize"),
        &[(0b01001, &ENTRY_CIZE_6818406889408576007)],
    ),
    (
        crate::EncodedStr::Ascii("clamor"),
        &[(0b11001, &ENTRY_CLAMOR_11722915000424769718)],
    ),
    (
        crate::EncodedStr::Ascii("clamored"),
        &[(0b11001, &ENTRY_CLAMORED_4631300413281563513)],
    ),
    (
        crate::EncodedStr::Ascii("clamorer"),
        &[(0b11001, &ENTRY_CLAMORER_17883337748457044767)],
    ),
    (
        crate::EncodedStr::Ascii("clamorers"),
        &[(0b11001, &ENTRY_CLAMORERS_15362052334359174240)],
    ),
    (
        crate::EncodedStr::Ascii("clamoring"),
        &[(0b11001, &ENTRY_CLAMORING_5415785372025381455)],
    ),
    (
        crate::EncodedStr::Ascii("clamorist"),
        &[(0b00001, &ENTRY_CLAMORIST_16325759197501191896)],
    ),
    (
        crate::EncodedStr::Ascii("clamors"),
        &[(0b11001, &ENTRY_CLAMORS_2773887349084725873)],
    ),
    (
        crate::EncodedStr::Ascii("clamorsome"),
        &[(0b11001, &ENTRY_CLAMORSOME_7681677003017063573)],
    ),
    (
        crate::EncodedStr::Ascii("clamour"),
        &[(0b11010, &ENTRY_CLAMOR_11722915000424769718)],
    ),
    (
        crate::EncodedStr::Ascii("clamoured"),
        &[(0b11010, &ENTRY_CLAMORED_4631300413281563513)],
    ),
    (
        crate::EncodedStr::Ascii("clamourer"),
        &[(0b11010, &ENTRY_CLAMORER_17883337748457044767)],
    ),
    (
        crate::EncodedStr::Ascii("clamourers"),
        &[(0b11010, &ENTRY_CLAMORERS_15362052334359174240)],
    ),
    (
        crate::EncodedStr::Ascii("clamouring"),
        &[(0b11010, &ENTRY_CLAMORING_5415785372025381455)],
    ),
    (
        crate::EncodedStr::Ascii("clamourist"),
        &[(0b11010, &ENTRY_CLAMORIST_16325759197501191896)],
    ),
    (
        crate::EncodedStr::Ascii("clamours"),
        &[(0b11010, &ENTRY_CLAMORS_2773887349084725873)],
    ),
    (
        crate::EncodedStr::Ascii("clamoursome"),
        &[(0b11010, &ENTRY_CLAMORSOME_7681677003017063573)],
    ),
    (
        crate::EncodedStr::Ascii("clangor"),
        &[(0b11001, &ENTRY_CLANGOR_11515055037441300100)],
    ),
    (
        crate::EncodedStr::Ascii("clangored"),
        &[(0b11001, &ENTRY_CLANGORED_15084752842311792542)],
    ),
    (
        crate::EncodedStr::Ascii("clangoring"),
        &[(0b11001, &ENTRY_CLANGORING_14458664811220315605)],
    ),
    (
        crate::EncodedStr::Ascii("clangors"),
        &[(0b11001, &ENTRY_CLANGORS_14016497850837852764)],
    ),
    (
        crate::EncodedStr::Ascii("clangour"),
        &[(0b11010, &ENTRY_CLANGOR_11515055037441300100)],
    ),
    (
        crate::EncodedStr::Ascii("clangoured"),
        &[(0b11010, &ENTRY_CLANGORED_15084752842311792542)],
    ),
    (
        crate::EncodedStr::Ascii("clangouring"),
        &[(0b11010, &ENTRY_CLANGORING_14458664811220315605)],
    ),
    (
        crate::EncodedStr::Ascii("clangours"),
        &[(0b11010, &ENTRY_CLANGORS_14016497850837852764)],
    ),
    (
        crate::EncodedStr::Ascii("clares"),
        &[(0b00001, &ENTRY_CLARES_1731306513503085955)],
    ),
    (
        crate::EncodedStr::Ascii("clarinetist"),
        &[(0b01001, &ENTRY_CLARINETIST_8834681667523453854)],
    ),
    (
        crate::EncodedStr::Ascii("clarinetists"),
        &[(0b01001, &ENTRY_CLARINETISTS_8097106053649523838)],
    ),
    (
        crate::EncodedStr::Ascii("clarinettist"),
        &[(0b10011, &ENTRY_CLARINETIST_8834681667523453854)],
    ),
    (
        crate::EncodedStr::Ascii("clarinettists"),
        &[(0b10011, &ENTRY_CLARINETISTS_8097106053649523838)],
    ),
    (
        crate::EncodedStr::Ascii("claroes"),
        &[(0b11010, &ENTRY_CLARES_1731306513503085955)],
    ),
    (
        crate::EncodedStr::Ascii("classicalise"),
        &[(0b10010, &ENTRY_CLASSICALIZE_7168633238933548715)],
    ),
    (
        crate::EncodedStr::Ascii("classicalises"),
        &[(0b10010, &ENTRY_CLASSICALIZES_2442176202643132547)],
    ),
    (
        crate::EncodedStr::Ascii("classicalize"),
        &[(0b01001, &ENTRY_CLASSICALIZE_7168633238933548715)],
    ),
    (
        crate::EncodedStr::Ascii("classicalizes"),
        &[(0b01001, &ENTRY_CLASSICALIZES_2442176202643132547)],
    ),
    (
        crate::EncodedStr::Ascii("classicisation"),
        &[(0b10010, &ENTRY_CLASSICIZATION_4974218833361429454)],
    ),
    (
        crate::EncodedStr::Ascii("classicise"),
        &[(0b10010, &ENTRY_CLASSICIZE_6847726068049490278)],
    ),
    (
        crate::EncodedStr::Ascii("classicised"),
        &[(0b10010, &ENTRY_CLASSICIZED_11040640355679759136)],
    ),
    (
        crate::EncodedStr::Ascii("classicises"),
        &[(0b10010, &ENTRY_CLASSICIZES_7627137652355384645)],
    ),
    (
        crate::EncodedStr::Ascii("classicising"),
        &[(0b10010, &ENTRY_CLASSICIZING_13143908142359497861)],
    ),
    (
        crate::EncodedStr::Ascii("classicization"),
        &[(0b01001, &ENTRY_CLASSICIZATION_4974218833361429454)],
    ),
    (
        crate::EncodedStr::Ascii("classicize"),
        &[(0b01001, &ENTRY_CLASSICIZE_6847726068049490278)],
    ),
    (
        crate::EncodedStr::Ascii("classicized"),
        &[(0b01001, &ENTRY_CLASSICIZED_11040640355679759136)],
    ),
    (
        crate::EncodedStr::Ascii("classicizes"),
        &[(0b01001, &ENTRY_CLASSICIZES_7627137652355384645)],
    ),
    (
        crate::EncodedStr::Ascii("classicizing"),
        &[(0b01001, &ENTRY_CLASSICIZING_13143908142359497861)],
    ),
    (
        crate::EncodedStr::Ascii("clausulae"),
        &[(0b11010, &ENTRY_CLAUSULE_67200534337080796)],
    ),
    (
        crate::EncodedStr::Ascii("clausule"),
        &[(0b00001, &ENTRY_CLAUSULE_67200534337080796)],
    ),
    (
        crate::EncodedStr::Ascii("clericalise"),
        &[(0b10010, &ENTRY_CLERICALIZE_1865718535677694450)],
    ),
    (
        crate::EncodedStr::Ascii("clericalises"),
        &[(0b10010, &ENTRY_CLERICALIZES_8269477549000417569)],
    ),
    (
        crate::EncodedStr::Ascii("clericalize"),
        &[(0b01001, &ENTRY_CLERICALIZE_1865718535677694450)],
    ),
    (
        crate::EncodedStr::Ascii("clericalizes"),
        &[(0b01001, &ENTRY_CLERICALIZES_8269477549000417569)],
    ),
    (
        crate::EncodedStr::Ascii("clete"),
        &[(0b00001, &ENTRY_CLETE_1876197067502328027)],
    ),
    (
        crate::EncodedStr::Ascii("climatise"),
        &[(0b10010, &ENTRY_CLIMATIZE_3452063415630301254)],
    ),
    (
        crate::EncodedStr::Ascii("climatised"),
        &[(0b10010, &ENTRY_CLIMATIZED_124773700894549172)],
    ),
    (
        crate::EncodedStr::Ascii("climatises"),
        &[(0b10010, &ENTRY_CLIMATIZES_13429047652583201954)],
    ),
    (
        crate::EncodedStr::Ascii("climatising"),
        &[(0b10010, &ENTRY_CLIMATIZING_4457168972427899649)],
    ),
    (
        crate::EncodedStr::Ascii("climatize"),
        &[(0b01001, &ENTRY_CLIMATIZE_3452063415630301254)],
    ),
    (
        crate::EncodedStr::Ascii("climatized"),
        &[(0b01001, &ENTRY_CLIMATIZED_124773700894549172)],
    ),
    (
        crate::EncodedStr::Ascii("climatizes"),
        &[(0b01001, &ENTRY_CLIMATIZES_13429047652583201954)],
    ),
    (
        crate::EncodedStr::Ascii("climatizing"),
        &[(0b01001, &ENTRY_CLIMATIZING_4457168972427899649)],
    ),
    (
        crate::EncodedStr::Ascii("cloete"),
        &[(0b11010, &ENTRY_CLETE_1876197067502328027)],
    ),
    (
        crate::EncodedStr::Ascii("clower"),
        &[(0b00001, &ENTRY_CLOWER_9225698487842396572)],
    ),
    (
        crate::EncodedStr::Ascii("clowre"),
        &[(0b11010, &ENTRY_CLOWER_9225698487842396572)],
    ),
    (
        crate::EncodedStr::Ascii("clytiae"),
        &[(0b11010, &ENTRY_CLYTIE_11851522067983621366)],
    ),
    (
        crate::EncodedStr::Ascii("clytie"),
        &[(0b00001, &ENTRY_CLYTIE_11851522067983621366)],
    ),
    (
        crate::EncodedStr::Ascii("coalise"),
        &[(0b10010, &ENTRY_COALIZE_1093705182941742482)],
    ),
    (
        crate::EncodedStr::Ascii("coalised"),
        &[(0b10010, &ENTRY_COALIZED_1331392537006305584)],
    ),
    (
        crate::EncodedStr::Ascii("coaliser"),
        &[(0b10010, &ENTRY_COALIZER_8326324895948995645)],
    ),
    (
        crate::EncodedStr::Ascii("coalisers"),
        &[(0b10010, &ENTRY_COALIZERS_8541541270360324668)],
    ),
    (
        crate::EncodedStr::Ascii("coalises"),
        &[(0b10010, &ENTRY_COALIZES_12556076575141372172)],
    ),
    (
        crate::EncodedStr::Ascii("coalising"),
        &[(0b10010, &ENTRY_COALIZING_8107852365569207830)],
    ),
    (
        crate::EncodedStr::Ascii("coalize"),
        &[(0b01001, &ENTRY_COALIZE_1093705182941742482)],
    ),
    (
        crate::EncodedStr::Ascii("coalized"),
        &[(0b01001, &ENTRY_COALIZED_1331392537006305584)],
    ),
    (
        crate::EncodedStr::Ascii("coalizer"),
        &[(0b01001, &ENTRY_COALIZER_8326324895948995645)],
    ),
    (
        crate::EncodedStr::Ascii("coalizers"),
        &[(0b01001, &ENTRY_COALIZERS_8541541270360324668)],
    ),
    (
        crate::EncodedStr::Ascii("coalizes"),
        &[(0b01001, &ENTRY_COALIZES_12556076575141372172)],
    ),
    (
        crate::EncodedStr::Ascii("coalizing"),
        &[(0b01001, &ENTRY_COALIZING_8107852365569207830)],
    ),
    (
        crate::EncodedStr::Ascii("cocainisation"),
        &[(0b10010, &ENTRY_COCAINIZATION_18270228789956323677)],
    ),
    (
        crate::EncodedStr::Ascii("cocainisations"),
        &[(0b10010, &ENTRY_COCAINIZATIONS_3037752219365718178)],
    ),
    (
        crate::EncodedStr::Ascii("cocainise"),
        &[(0b10010, &ENTRY_COCAINIZE_5959521297540551059)],
    ),
    (
        crate::EncodedStr::Ascii("cocainised"),
        &[(0b10010, &ENTRY_COCAINIZED_11738928114927355282)],
    ),
    (
        crate::EncodedStr::Ascii("cocainises"),
        &[(0b10010, &ENTRY_COCAINIZES_4491426404312671844)],
    ),
    (
        crate::EncodedStr::Ascii("cocainising"),
        &[(0b10010, &ENTRY_COCAINIZING_3962782652468626350)],
    ),
    (
        crate::EncodedStr::Ascii("cocainization"),
        &[(0b01001, &ENTRY_COCAINIZATION_18270228789956323677)],
    ),
    (
        crate::EncodedStr::Ascii("cocainizations"),
        &[(0b01001, &ENTRY_COCAINIZATIONS_3037752219365718178)],
    ),
    (
        crate::EncodedStr::Ascii("cocainize"),
        &[(0b01001, &ENTRY_COCAINIZE_5959521297540551059)],
    ),
    (
        crate::EncodedStr::Ascii("cocainized"),
        &[(0b01001, &ENTRY_COCAINIZED_11738928114927355282)],
    ),
    (
        crate::EncodedStr::Ascii("cocainizes"),
        &[(0b01001, &ENTRY_COCAINIZES_4491426404312671844)],
    ),
    (
        crate::EncodedStr::Ascii("cocainizing"),
        &[(0b01001, &ENTRY_COCAINIZING_3962782652468626350)],
    ),
    (
        crate::EncodedStr::Ascii("cocuisa"),
        &[(0b10010, &ENTRY_COCUIZA_6504886933052210304)],
    ),
    (
        crate::EncodedStr::Ascii("cocuiza"),
        &[(0b01001, &ENTRY_COCUIZA_6504886933052210304)],
    ),
    (
        crate::EncodedStr::Ascii("coe"),
        &[
            (0b11010, &ENTRY_CE_254143254853835550),
            (0b00001, &ENTRY_COE_10755603025154058571),
        ],
    ),
    (
        crate::EncodedStr::Ascii("coeducationalise"),
        &[(0b10010, &ENTRY_COEDUCATIONALIZE_1494210807334794701)],
    ),
    (
        crate::EncodedStr::Ascii("coeducationalises"),
        &[(0b10010, &ENTRY_COEDUCATIONALIZES_6378010748334869944)],
    ),
    (
        crate::EncodedStr::Ascii("coeducationalize"),
        &[(0b01001, &ENTRY_COEDUCATIONALIZE_1494210807334794701)],
    ),
    (
        crate::EncodedStr::Ascii("coeducationalizes"),
        &[(0b01001, &ENTRY_COEDUCATIONALIZES_6378010748334869944)],
    ),
    (
        crate::EncodedStr::Ascii("coelastraceae"),
        &[(0b11010, &ENTRY_CELASTRACEAE_17324005888177982048)],
    ),
    (
        crate::EncodedStr::Ascii("coelastraceous"),
        &[(0b11010, &ENTRY_CELASTRACEOUS_18174723794622646878)],
    ),
    (
        crate::EncodedStr::Ascii("coelestine"),
        &[(0b11010, &ENTRY_CELESTINE_11011528250519125092)],
    ),
    (
        crate::EncodedStr::Ascii("coeliac"),
        &[(0b11010, &ENTRY_CELIAC_10249133411124257957)],
    ),
    (
        crate::EncodedStr::Ascii("coeliacs"),
        &[(0b11010, &ENTRY_CELIACS_10248347099141877177)],
    ),
    (
        crate::EncodedStr::Ascii("coelialgia"),
        &[(0b11010, &ENTRY_CELIALGIA_4569927604389576150)],
    ),
    (
        crate::EncodedStr::Ascii("coeliomyalgia"),
        &[(0b11010, &ENTRY_CELIOMYALGIA_14548383766443531737)],
    ),
    (
        crate::EncodedStr::Ascii("coeliorrhea"),
        &[(0b11010, &ENTRY_CELIORRHEA_5614182174276153091)],
    ),
    (
        crate::EncodedStr::Ascii("coelioscopy"),
        &[(0b11010, &ENTRY_CELIOSCOPY_17821312237861674807)],
    ),
    (
        crate::EncodedStr::Ascii("coeliotomy"),
        &[(0b11010, &ENTRY_CELIOTOMY_9141657999599968712)],
    ),
    (
        crate::EncodedStr::Ascii("coelom"),
        &[(0b11010, &ENTRY_CELOM_581114569279805851)],
    ),
    (
        crate::EncodedStr::Ascii("coeloma"),
        &[(0b11010, &ENTRY_CELOMA_8394900856159450271)],
    ),
    (
        crate::EncodedStr::Ascii("coelomata"),
        &[
            (0b11010, &ENTRY_CELOMATA_5399894536275260385),
            (0b00010, &ENTRY_CELOMS_16869648723221026513),
        ],
    ),
    (
        crate::EncodedStr::Ascii("coeloms"),
        &[(0b11010, &ENTRY_CELOMS_16869648723221026513)],
    ),
    (
        crate::EncodedStr::Ascii("coeloscope"),
        &[(0b11010, &ENTRY_CELOSCOPE_13733285893205563827)],
    ),
    (
        crate::EncodedStr::Ascii("coenacle"),
        &[(0b11010, &ENTRY_CENACLE_4902172834128420652)],
    ),
    (
        crate::EncodedStr::Ascii("coenaculum"),
        &[(0b11010, &ENTRY_CENACULUM_14642801640862790402)],
    ),
    (
        crate::EncodedStr::Ascii("coenamor"),
        &[(0b10001, &ENTRY_COENAMOR_8473204005333691620)],
    ),
    (
        crate::EncodedStr::Ascii("coenamored"),
        &[(0b10001, &ENTRY_COENAMORED_9568490962748517648)],
    ),
    (
        crate::EncodedStr::Ascii("coenamoring"),
        &[(0b10001, &ENTRY_COENAMORING_951487569841068233)],
    ),
    (
        crate::EncodedStr::Ascii("coenamorment"),
        &[(0b10001, &ENTRY_COENAMORMENT_10116172708022357030)],
    ),
    (
        crate::EncodedStr::Ascii("coenamors"),
        &[(0b10001, &ENTRY_COENAMORS_8428808930600945906)],
    ),
    (
        crate::EncodedStr::Ascii("coenamour"),
        &[(0b11010, &ENTRY_COENAMOR_8473204005333691620)],
    ),
    (
        crate::EncodedStr::Ascii("coenamoured"),
        &[(0b11010, &ENTRY_COENAMORED_9568490962748517648)],
    ),
    (
        crate::EncodedStr::Ascii("coenamouring"),
        &[(0b11010, &ENTRY_COENAMORING_951487569841068233)],
    ),
    (
        crate::EncodedStr::Ascii("coenamourment"),
        &[(0b11010, &ENTRY_COENAMORMENT_10116172708022357030)],
    ),
    (
        crate::EncodedStr::Ascii("coenamours"),
        &[(0b11010, &ENTRY_COENAMORS_8428808930600945906)],
    ),
    (
        crate::EncodedStr::Ascii("coenesthesia"),
        &[(0b11010, &ENTRY_CENESTHESIA_3973419130660988894)],
    ),
    (
        crate::EncodedStr::Ascii("coenesthesias"),
        &[(0b11010, &ENTRY_CENESTHESIAS_17650055632548316730)],
    ),
    (
        crate::EncodedStr::Ascii("coenesthesis"),
        &[(0b11010, &ENTRY_CENESTHESIS_2981771230300833707)],
    ),
    (
        crate::EncodedStr::Ascii("coenobe"),
        &[(0b11010, &ENTRY_CENOBE_17025760197236238291)],
    ),
    (
        crate::EncodedStr::Ascii("coenobite"),
        &[(0b11010, &ENTRY_CENOBITE_15084617731417587224)],
    ),
    (
        crate::EncodedStr::Ascii("coenobites"),
        &[(0b11010, &ENTRY_CENOBITES_12070792697281985215)],
    ),
    (
        crate::EncodedStr::Ascii("coenobitic"),
        &[(0b11010, &ENTRY_CENOBITIC_861253358414117823)],
    ),
    (
        crate::EncodedStr::Ascii("coenobitical"),
        &[(0b11010, &ENTRY_CENOBITICAL_3907716283980683620)],
    ),
    (
        crate::EncodedStr::Ascii("coenobitism"),
        &[(0b11010, &ENTRY_CENOBITISM_5016689208030165500)],
    ),
    (
        crate::EncodedStr::Ascii("coenobium"),
        &[(0b11010, &ENTRY_CENOBIUM_6656148321160010108)],
    ),
    (
        crate::EncodedStr::Ascii("coenoby"),
        &[(0b11010, &ENTRY_CENOBY_6246310194380860627)],
    ),
    (
        crate::EncodedStr::Ascii("coenogenetic"),
        &[(0b11010, &ENTRY_CENOGENETIC_14752824343681490356)],
    ),
    (
        crate::EncodedStr::Ascii("coenosite"),
        &[(0b11010, &ENTRY_CENOSITE_6962695398695523616)],
    ),
    (
        crate::EncodedStr::Ascii("coenospecies"),
        &[(0b11010, &ENTRY_CENOSPECIES_18129881350317785306)],
    ),
    (
        crate::EncodedStr::Ascii("coenospecific"),
        &[(0b11010, &ENTRY_CENOSPECIFIC_10710765180299401749)],
    ),
    (
        crate::EncodedStr::Ascii("coenospecifically"),
        &[(0b11010, &ENTRY_CENOSPECIFICALLY_5111318916340201830)],
    ),
    (
        crate::EncodedStr::Ascii("coequalise"),
        &[(0b10010, &ENTRY_COEQUALIZE_15105464134551790946)],
    ),
    (
        crate::EncodedStr::Ascii("coequalises"),
        &[(0b10010, &ENTRY_COEQUALIZES_1651368880238979086)],
    ),
    (
        crate::EncodedStr::Ascii("coequalize"),
        &[(0b01001, &ENTRY_COEQUALIZE_15105464134551790946)],
    ),
    (
        crate::EncodedStr::Ascii("coequalizes"),
        &[(0b01001, &ENTRY_COEQUALIZES_1651368880238979086)],
    ),
    (
        crate::EncodedStr::Ascii("coeruleolactite"),
        &[(0b11010, &ENTRY_CERULEOLACTITE_1277200430318336008)],
    ),
    (
        crate::EncodedStr::Ascii("coetus"),
        &[(0b11010, &ENTRY_CETUS_11617299917311809086)],
    ),
    (
        crate::EncodedStr::Ascii("cognisability"),
        &[(0b10010, &ENTRY_COGNIZABILITY_660527253976403780)],
    ),
    (
        crate::EncodedStr::Ascii("cognisable"),
        &[(0b10010, &ENTRY_COGNIZABLE_13131115414619000772)],
    ),
    (
        crate::EncodedStr::Ascii("cognisableness"),
        &[(0b10010, &ENTRY_COGNIZABLENESS_16476592524827512160)],
    ),
    (
        crate::EncodedStr::Ascii("cognisabler"),
        &[(0b10010, &ENTRY_COGNIZABLER_12070099101883833731)],
    ),
    (
        crate::EncodedStr::Ascii("cognisablest"),
        &[(0b10010, &ENTRY_COGNIZABLEST_13955023369005527923)],
    ),
    (
        crate::EncodedStr::Ascii("cognisablier"),
        &[(0b10010, &ENTRY_COGNIZABLIER_1964601888045213766)],
    ),
    (
        crate::EncodedStr::Ascii("cognisabliest"),
        &[(0b10010, &ENTRY_COGNIZABLIEST_13701693542862328478)],
    ),
    (
        crate::EncodedStr::Ascii("cognisably"),
        &[(0b10010, &ENTRY_COGNIZABLY_17839926776700915805)],
    ),
    (
        crate::EncodedStr::Ascii("cognisance"),
        &[(0b10010, &ENTRY_COGNIZANCE_14359512853615918641)],
    ),
    (
        crate::EncodedStr::Ascii("cognisances"),
        &[(0b10010, &ENTRY_COGNIZANCES_183948325192833313)],
    ),
    (
        crate::EncodedStr::Ascii("cognisant"),
        &[(0b10010, &ENTRY_COGNIZANT_2557847978553579663)],
    ),
    (
        crate::EncodedStr::Ascii("cognisanter"),
        &[(0b10010, &ENTRY_COGNIZANTER_9274314327914715355)],
    ),
    (
        crate::EncodedStr::Ascii("cognisantest"),
        &[(0b10010, &ENTRY_COGNIZANTEST_9952434271050939774)],
    ),
    (
        crate::EncodedStr::Ascii("cognise"),
        &[(0b10010, &ENTRY_COGNIZE_7253118900028580039)],
    ),
    (
        crate::EncodedStr::Ascii("cognised"),
        &[(0b10010, &ENTRY_COGNIZED_17562230997464673899)],
    ),
    (
        crate::EncodedStr::Ascii("cogniser"),
        &[(0b10010, &ENTRY_COGNIZER_17235063272659781689)],
    ),
    (
        crate::EncodedStr::Ascii("cognisers"),
        &[(0b10010, &ENTRY_COGNIZERS_16818874771090495789)],
    ),
    (
        crate::EncodedStr::Ascii("cognises"),
        &[(0b10010, &ENTRY_COGNIZES_313141652357958777)],
    ),
    (
        crate::EncodedStr::Ascii("cognising"),
        &[(0b10010, &ENTRY_COGNIZING_14291458489887284299)],
    ),
    (
        crate::EncodedStr::Ascii("cognizability"),
        &[(0b01001, &ENTRY_COGNIZABILITY_660527253976403780)],
    ),
    (
        crate::EncodedStr::Ascii("cognizable"),
        &[(0b01001, &ENTRY_COGNIZABLE_13131115414619000772)],
    ),
    (
        crate::EncodedStr::Ascii("cognizableness"),
        &[(0b01001, &ENTRY_COGNIZABLENESS_16476592524827512160)],
    ),
    (
        crate::EncodedStr::Ascii("cognizabler"),
        &[(0b01001, &ENTRY_COGNIZABLER_12070099101883833731)],
    ),
    (
        crate::EncodedStr::Ascii("cognizablest"),
        &[(0b01001, &ENTRY_COGNIZABLEST_13955023369005527923)],
    ),
    (
        crate::EncodedStr::Ascii("cognizablier"),
        &[(0b01001, &ENTRY_COGNIZABLIER_1964601888045213766)],
    ),
    (
        crate::EncodedStr::Ascii("cognizabliest"),
        &[(0b01001, &ENTRY_COGNIZABLIEST_13701693542862328478)],
    ),
    (
        crate::EncodedStr::Ascii("cognizably"),
        &[(0b01001, &ENTRY_COGNIZABLY_17839926776700915805)],
    ),
    (
        crate::EncodedStr::Ascii("cognizance"),
        &[(0b01001, &ENTRY_COGNIZANCE_14359512853615918641)],
    ),
    (
        crate::EncodedStr::Ascii("cognizances"),
        &[(0b01001, &ENTRY_COGNIZANCES_183948325192833313)],
    ),
    (
        crate::EncodedStr::Ascii("cognizant"),
        &[(0b01001, &ENTRY_COGNIZANT_2557847978553579663)],
    ),
    (
        crate::EncodedStr::Ascii("cognizanter"),
        &[(0b01001, &ENTRY_COGNIZANTER_9274314327914715355)],
    ),
    (
        crate::EncodedStr::Ascii("cognizantest"),
        &[(0b01001, &ENTRY_COGNIZANTEST_9952434271050939774)],
    ),
    (
        crate::EncodedStr::Ascii("cognize"),
        &[(0b01001, &ENTRY_COGNIZE_7253118900028580039)],
    ),
    (
        crate::EncodedStr::Ascii("cognized"),
        &[(0b01001, &ENTRY_COGNIZED_17562230997464673899)],
    ),
    (
        crate::EncodedStr::Ascii("cognizer"),
        &[(0b01001, &ENTRY_COGNIZER_17235063272659781689)],
    ),
    (
        crate::EncodedStr::Ascii("cognizers"),
        &[(0b01001, &ENTRY_COGNIZERS_16818874771090495789)],
    ),
    (
        crate::EncodedStr::Ascii("cognizes"),
        &[(0b01001, &ENTRY_COGNIZES_313141652357958777)],
    ),
    (
        crate::EncodedStr::Ascii("cognizing"),
        &[(0b01001, &ENTRY_COGNIZING_14291458489887284299)],
    ),
    (
        crate::EncodedStr::Ascii("collateralise"),
        &[(0b10010, &ENTRY_COLLATERALIZE_4809202625356484324)],
    ),
    (
        crate::EncodedStr::Ascii("collateralize"),
        &[(0b01001, &ENTRY_COLLATERALIZE_4809202625356484324)],
    ),
    (
        crate::EncodedStr::Ascii("collectable"),
        &[(0b10011, &ENTRY_COLLECTIBLE_16675394473838043634)],
    ),
    (
        crate::EncodedStr::Ascii("collectables"),
        &[(0b10011, &ENTRY_COLLECTIBLES_1426649794037748395)],
    ),
    (
        crate::EncodedStr::Ascii("collectivisation"),
        &[(0b10010, &ENTRY_COLLECTIVIZATION_10577206395052359405)],
    ),
    (
        crate::EncodedStr::Ascii("collectivisations"),
        &[(0b10010, &ENTRY_COLLECTIVIZATIONS_6853316050939234055)],
    ),
    (
        crate::EncodedStr::Ascii("collectivise"),
        &[(0b10010, &ENTRY_COLLECTIVIZE_18197662740300515669)],
    ),
    (
        crate::EncodedStr::Ascii("collectivised"),
        &[(0b10010, &ENTRY_COLLECTIVIZED_14370760959187496202)],
    ),
    (
        crate::EncodedStr::Ascii("collectivises"),
        &[(0b10010, &ENTRY_COLLECTIVIZES_15340840028673940577)],
    ),
    (
        crate::EncodedStr::Ascii("collectivising"),
        &[(0b10010, &ENTRY_COLLECTIVIZING_6177450980824602558)],
    ),
    (
        crate::EncodedStr::Ascii("collectivization"),
        &[(0b01001, &ENTRY_COLLECTIVIZATION_10577206395052359405)],
    ),
    (
        crate::EncodedStr::Ascii("collectivizations"),
        &[(0b01001, &ENTRY_COLLECTIVIZATIONS_6853316050939234055)],
    ),
    (
        crate::EncodedStr::Ascii("collectivize"),
        &[(0b01001, &ENTRY_COLLECTIVIZE_18197662740300515669)],
    ),
    (
        crate::EncodedStr::Ascii("collectivized"),
        &[(0b01001, &ENTRY_COLLECTIVIZED_14370760959187496202)],
    ),
    (
        crate::EncodedStr::Ascii("collectivizes"),
        &[(0b01001, &ENTRY_COLLECTIVIZES_15340840028673940577)],
    ),
    (
        crate::EncodedStr::Ascii("collectivizing"),
        &[(0b01001, &ENTRY_COLLECTIVIZING_6177450980824602558)],
    ),
    (
        crate::EncodedStr::Ascii("colloquialise"),
        &[(0b10010, &ENTRY_COLLOQUIALIZE_400572582640316358)],
    ),
    (
        crate::EncodedStr::Ascii("colloquialises"),
        &[(0b10010, &ENTRY_COLLOQUIALIZES_11772046900035477346)],
    ),
    (
        crate::EncodedStr::Ascii("colloquialize"),
        &[(0b01001, &ENTRY_COLLOQUIALIZE_400572582640316358)],
    ),
    (
        crate::EncodedStr::Ascii("colloquializes"),
        &[(0b01001, &ENTRY_COLLOQUIALIZES_11772046900035477346)],
    ),
    (
        crate::EncodedStr::Ascii("colloquise"),
        &[(0b10010, &ENTRY_COLLOQUIZE_3542999561179306173)],
    ),
    (
        crate::EncodedStr::Ascii("colloquised"),
        &[(0b10010, &ENTRY_COLLOQUIZED_2987662592391153464)],
    ),
    (
        crate::EncodedStr::Ascii("colloquises"),
        &[(0b10010, &ENTRY_COLLOQUIZES_3694957155887273629)],
    ),
    (
        crate::EncodedStr::Ascii("colloquising"),
        &[(0b10010, &ENTRY_COLLOQUIZING_12005217252377921527)],
    ),
    (
        crate::EncodedStr::Ascii("colloquize"),
        &[(0b01001, &ENTRY_COLLOQUIZE_3542999561179306173)],
    ),
    (
        crate::EncodedStr::Ascii("colloquized"),
        &[(0b01001, &ENTRY_COLLOQUIZED_2987662592391153464)],
    ),
    (
        crate::EncodedStr::Ascii("colloquizes"),
        &[(0b01001, &ENTRY_COLLOQUIZES_3694957155887273629)],
    ),
    (
        crate::EncodedStr::Ascii("colloquizing"),
        &[(0b01001, &ENTRY_COLLOQUIZING_12005217252377921527)],
    ),
    (
        crate::EncodedStr::Ascii("colonialise"),
        &[(0b10010, &ENTRY_COLONIALIZE_17015664660619402146)],
    ),
    (
        crate::EncodedStr::Ascii("colonialised"),
        &[(0b10010, &ENTRY_COLONIALIZED_13876149610938201725)],
    ),
    (
        crate::EncodedStr::Ascii("colonialises"),
        &[(0b10010, &ENTRY_COLONIALIZES_14570746695121826765)],
    ),
    (
        crate::EncodedStr::Ascii("colonialising"),
        &[(0b10010, &ENTRY_COLONIALIZING_16068571893089538400)],
    ),
    (
        crate::EncodedStr::Ascii("colonialize"),
        &[(0b01001, &ENTRY_COLONIALIZE_17015664660619402146)],
    ),
    (
        crate::EncodedStr::Ascii("colonialized"),
        &[(0b01001, &ENTRY_COLONIALIZED_13876149610938201725)],
    ),
    (
        crate::EncodedStr::Ascii("colonializes"),
        &[(0b01001, &ENTRY_COLONIALIZES_14570746695121826765)],
    ),
    (
        crate::EncodedStr::Ascii("colonializing"),
        &[(0b01001, &ENTRY_COLONIALIZING_16068571893089538400)],
    ),
    (
        crate::EncodedStr::Ascii("colonisabilities"),
        &[(0b10010, &ENTRY_COLONIZABILITIES_12944259693371296365)],
    ),
    (
        crate::EncodedStr::Ascii("colonisability"),
        &[(0b10010, &ENTRY_COLONIZABILITY_11573587685077716438)],
    ),
    (
        crate::EncodedStr::Ascii("colonisable"),
        &[(0b10010, &ENTRY_COLONIZABLE_1551399607404148929)],
    ),
    (
        crate::EncodedStr::Ascii("colonisabler"),
        &[(0b10010, &ENTRY_COLONIZABLER_7503793641425675771)],
    ),
    (
        crate::EncodedStr::Ascii("colonisables"),
        &[(0b10010, &ENTRY_COLONIZABLES_7468307704661763383)],
    ),
    (
        crate::EncodedStr::Ascii("colonisablest"),
        &[(0b10010, &ENTRY_COLONIZABLEST_13287343767333590772)],
    ),
    (
        crate::EncodedStr::Ascii("colonisation"),
        &[(0b10010, &ENTRY_COLONIZATION_8572095881455583344)],
    ),
    (
        crate::EncodedStr::Ascii("colonisationist"),
        &[(0b10010, &ENTRY_COLONIZATIONIST_176926856555957139)],
    ),
    (
        crate::EncodedStr::Ascii("colonisationists"),
        &[(0b10010, &ENTRY_COLONIZATIONISTS_16863993202249434726)],
    ),
    (
        crate::EncodedStr::Ascii("colonisations"),
        &[(0b10010, &ENTRY_COLONIZATIONS_12298250811536901685)],
    ),
    (
        crate::EncodedStr::Ascii("colonise"),
        &[(0b10010, &ENTRY_COLONIZE_15302728430964322592)],
    ),
    (
        crate::EncodedStr::Ascii("colonised"),
        &[(0b10010, &ENTRY_COLONIZED_12903152841060558253)],
    ),
    (
        crate::EncodedStr::Ascii("coloniser"),
        &[(0b10010, &ENTRY_COLONIZER_5320596989867894996)],
    ),
    (
        crate::EncodedStr::Ascii("colonisers"),
        &[(0b10010, &ENTRY_COLONIZERS_11110896653251592981)],
    ),
    (
        crate::EncodedStr::Ascii("colonises"),
        &[(0b10010, &ENTRY_COLONIZES_5176087008588077388)],
    ),
    (
        crate::EncodedStr::Ascii("colonising"),
        &[(0b10010, &ENTRY_COLONIZING_17297511401074881747)],
    ),
    (
        crate::EncodedStr::Ascii("colonizabilities"),
        &[(0b01001, &ENTRY_COLONIZABILITIES_12944259693371296365)],
    ),
    (
        crate::EncodedStr::Ascii("colonizability"),
        &[(0b01001, &ENTRY_COLONIZABILITY_11573587685077716438)],
    ),
    (
        crate::EncodedStr::Ascii("colonizable"),
        &[(0b01001, &ENTRY_COLONIZABLE_1551399607404148929)],
    ),
    (
        crate::EncodedStr::Ascii("colonizabler"),
        &[(0b01001, &ENTRY_COLONIZABLER_7503793641425675771)],
    ),
    (
        crate::EncodedStr::Ascii("colonizables"),
        &[(0b01001, &ENTRY_COLONIZABLES_7468307704661763383)],
    ),
    (
        crate::EncodedStr::Ascii("colonizablest"),
        &[(0b01001, &ENTRY_COLONIZABLEST_13287343767333590772)],
    ),
    (
        crate::EncodedStr::Ascii("colonization"),
        &[(0b01001, &ENTRY_COLONIZATION_8572095881455583344)],
    ),
    (
        crate::EncodedStr::Ascii("colonizationist"),
        &[(0b01001, &ENTRY_COLONIZATIONIST_176926856555957139)],
    ),
    (
        crate::EncodedStr::Ascii("colonizationists"),
        &[(0b01001, &ENTRY_COLONIZATIONISTS_16863993202249434726)],
    ),
    (
        crate::EncodedStr::Ascii("colonizations"),
        &[(0b01001, &ENTRY_COLONIZATIONS_12298250811536901685)],
    ),
    (
        crate::EncodedStr::Ascii("colonize"),
        &[(0b01001, &ENTRY_COLONIZE_15302728430964322592)],
    ),
    (
        crate::EncodedStr::Ascii("colonized"),
        &[(0b01001, &ENTRY_COLONIZED_12903152841060558253)],
    ),
    (
        crate::EncodedStr::Ascii("colonizer"),
        &[(0b01001, &ENTRY_COLONIZER_5320596989867894996)],
    ),
    (
        crate::EncodedStr::Ascii("colonizers"),
        &[(0b01001, &ENTRY_COLONIZERS_11110896653251592981)],
    ),
    (
        crate::EncodedStr::Ascii("colonizes"),
        &[(0b01001, &ENTRY_COLONIZES_5176087008588077388)],
    ),
    (
        crate::EncodedStr::Ascii("colonizing"),
        &[(0b01001, &ENTRY_COLONIZING_17297511401074881747)],
    ),
    (
        crate::EncodedStr::Ascii("color"),
        &[(0b11001, &ENTRY_COLOR_17720358635329736641)],
    ),
    (
        crate::EncodedStr::Ascii("colorabilities"),
        &[(0b11001, &ENTRY_COLORABILITIES_17934830495879279238)],
    ),
    (
        crate::EncodedStr::Ascii("colorability"),
        &[(0b11001, &ENTRY_COLORABILITY_3833618249244001959)],
    ),
    (
        crate::EncodedStr::Ascii("colorable"),
        &[(0b11001, &ENTRY_COLORABLE_9126609110540102083)],
    ),
    (
        crate::EncodedStr::Ascii("colorableness"),
        &[(0b11001, &ENTRY_COLORABLENESS_1061796348140451347)],
    ),
    (
        crate::EncodedStr::Ascii("colorablenesses"),
        &[(0b11001, &ENTRY_COLORABLENESSES_10749946314548598617)],
    ),
    (
        crate::EncodedStr::Ascii("colorabler"),
        &[(0b11001, &ENTRY_COLORABLER_1063847220352847404)],
    ),
    (
        crate::EncodedStr::Ascii("colorables"),
        &[(0b11001, &ENTRY_COLORABLES_10854398030589164189)],
    ),
    (
        crate::EncodedStr::Ascii("colorablest"),
        &[(0b11001, &ENTRY_COLORABLEST_3683085641889155962)],
    ),
    (
        crate::EncodedStr::Ascii("colorablier"),
        &[(0b11001, &ENTRY_COLORABLIER_5968483988144955864)],
    ),
    (
        crate::EncodedStr::Ascii("colorablies"),
        &[(0b11001, &ENTRY_COLORABLIES_16005107918816262896)],
    ),
    (
        crate::EncodedStr::Ascii("colorabliest"),
        &[(0b11001, &ENTRY_COLORABLIEST_5199306118528597149)],
    ),
    (
        crate::EncodedStr::Ascii("colorably"),
        &[(0b11001, &ENTRY_COLORABLY_13475999889111967538)],
    ),
    (
        crate::EncodedStr::Ascii("coloradan"),
        &[(0b00001, &ENTRY_COLORADAN_1710087118093866996)],
    ),
    (
        crate::EncodedStr::Ascii("coloradans"),
        &[(0b00001, &ENTRY_COLORADANS_1537230991364273395)],
    ),
    (
        crate::EncodedStr::Ascii("colorado"),
        &[(0b00001, &ENTRY_COLORADO_672786360083421122)],
    ),
    (
        crate::EncodedStr::Ascii("coloradoite"),
        &[(0b00001, &ENTRY_COLORADOITE_10437671738809934244)],
    ),
    (
        crate::EncodedStr::Ascii("colorama"),
        &[(0b00001, &ENTRY_COLORAMA_10946100748903023597)],
    ),
    (
        crate::EncodedStr::Ascii("colorant"),
        &[(0b11001, &ENTRY_COLORANT_105918244627467133)],
    ),
    (
        crate::EncodedStr::Ascii("colorants"),
        &[(0b11001, &ENTRY_COLORANTS_7537794752295559574)],
    ),
    (
        crate::EncodedStr::Ascii("colorate"),
        &[(0b00001, &ENTRY_COLORATE_7568881222694249579)],
    ),
    (
        crate::EncodedStr::Ascii("colorative"),
        &[(0b00001, &ENTRY_COLORATIVE_17851173748347347190)],
    ),
    (
        crate::EncodedStr::Ascii("colorbearer"),
        &[(0b11001, &ENTRY_COLORBEARER_9903060614478418481)],
    ),
    (
        crate::EncodedStr::Ascii("colorblind"),
        &[(0b11001, &ENTRY_COLORBLIND_6088870633188592041)],
    ),
    (
        crate::EncodedStr::Ascii("colorblindness"),
        &[(0b11001, &ENTRY_COLORBLINDNESS_15137443200927238655)],
    ),
    (
        crate::EncodedStr::Ascii("colorblindnesses"),
        &[(0b11001, &ENTRY_COLORBLINDNESSES_12714928556099515868)],
    ),
    (
        crate::EncodedStr::Ascii("colorbred"),
        &[(0b11001, &ENTRY_COLORBRED_17391526765371994938)],
    ),
    (
        crate::EncodedStr::Ascii("colorbreed"),
        &[(0b11001, &ENTRY_COLORBREED_988623603127049866)],
    ),
    (
        crate::EncodedStr::Ascii("colorbreeding"),
        &[(0b11001, &ENTRY_COLORBREEDING_14262752611756151320)],
    ),
    (
        crate::EncodedStr::Ascii("colorbreeds"),
        &[(0b11001, &ENTRY_COLORBREEDS_5534022895414416287)],
    ),
    (
        crate::EncodedStr::Ascii("colorcast"),
        &[(0b11001, &ENTRY_COLORCAST_16740960231179575917)],
    ),
    (
        crate::EncodedStr::Ascii("colorcasted"),
        &[(0b11001, &ENTRY_COLORCASTED_10398645425299808234)],
    ),
    (
        crate::EncodedStr::Ascii("colorcaster"),
        &[(0b11001, &ENTRY_COLORCASTER_8192206561724383576)],
    ),
    (
        crate::EncodedStr::Ascii("colorcasters"),
        &[(0b11001, &ENTRY_COLORCASTERS_9885877195250711665)],
    ),
    (
        crate::EncodedStr::Ascii("colorcasting"),
        &[(0b11001, &ENTRY_COLORCASTING_9616298919649932012)],
    ),
    (
        crate::EncodedStr::Ascii("colorcasts"),
        &[(0b11001, &ENTRY_COLORCASTS_17581853229444769235)],
    ),
    (
        crate::EncodedStr::Ascii("colorectal"),
        &[(0b00001, &ENTRY_COLORECTAL_9394771582914199855)],
    ),
    (
        crate::EncodedStr::Ascii("colorectitis"),
        &[(0b00001, &ENTRY_COLORECTITIS_11920759655606208881)],
    ),
    (
        crate::EncodedStr::Ascii("colorectostomy"),
        &[(0b00001, &ENTRY_COLORECTOSTOMY_809184159134628418)],
    ),
    (
        crate::EncodedStr::Ascii("colored"),
        &[(0b11001, &ENTRY_COLORED_809367823820397764)],
    ),
    (
        crate::EncodedStr::Ascii("coloreds"),
        &[(0b11001, &ENTRY_COLOREDS_5638105898846322523)],
    ),
    (
        crate::EncodedStr::Ascii("colorer"),
        &[(0b11001, &ENTRY_COLORER_6377883908421217617)],
    ),
    (
        crate::EncodedStr::Ascii("colorers"),
        &[(0b11001, &ENTRY_COLORERS_5523036624009318320)],
    ),
    (
        crate::EncodedStr::Ascii("colorfast"),
        &[(0b11001, &ENTRY_COLORFAST_16696822485914404702)],
    ),
    (
        crate::EncodedStr::Ascii("colorfastness"),
        &[(0b11001, &ENTRY_COLORFASTNESS_3258841464722986607)],
    ),
    (
        crate::EncodedStr::Ascii("colorfastnesses"),
        &[(0b11001, &ENTRY_COLORFASTNESSES_14995112700652023509)],
    ),
    (
        crate::EncodedStr::Ascii("colorful"),
        &[(0b11001, &ENTRY_COLORFUL_16225861255487751804)],
    ),
    (
        crate::EncodedStr::Ascii("colorfuler"),
        &[(0b11001, &ENTRY_COLORFULER_10294924989983822582)],
    ),
    (
        crate::EncodedStr::Ascii("colorfulest"),
        &[(0b11001, &ENTRY_COLORFULEST_202572902882532719)],
    ),
    (
        crate::EncodedStr::Ascii("colorfullier"),
        &[(0b11001, &ENTRY_COLORFULLIER_3454480613316383412)],
    ),
    (
        crate::EncodedStr::Ascii("colorfulliest"),
        &[(0b11001, &ENTRY_COLORFULLIEST_14019017521674302328)],
    ),
    (
        crate::EncodedStr::Ascii("colorfully"),
        &[(0b11001, &ENTRY_COLORFULLY_7749800674951458575)],
    ),
    (
        crate::EncodedStr::Ascii("colorfulness"),
        &[(0b11001, &ENTRY_COLORFULNESS_8831709788792250227)],
    ),
    (
        crate::EncodedStr::Ascii("colorfulnesses"),
        &[(0b11001, &ENTRY_COLORFULNESSES_11724036744178299544)],
    ),
    (
        crate::EncodedStr::Ascii("colorific"),
        &[(0b00001, &ENTRY_COLORIFIC_17453281363599547611)],
    ),
    (
        crate::EncodedStr::Ascii("colorifics"),
        &[(0b00001, &ENTRY_COLORIFICS_7493178994191350405)],
    ),
    (
        crate::EncodedStr::Ascii("colorimetrical"),
        &[(0b00001, &ENTRY_COLORIMETRICAL_14932230836831976255)],
    ),
    (
        crate::EncodedStr::Ascii("colorimetrically"),
        &[(0b00001, &ENTRY_COLORIMETRICALLY_5243289402205557910)],
    ),
    (
        crate::EncodedStr::Ascii("colorimetrist"),
        &[(0b00001, &ENTRY_COLORIMETRIST_16103668754911113058)],
    ),
    (
        crate::EncodedStr::Ascii("colorin"),
        &[(0b00001, &ENTRY_COLORIN_7364447797547189461)],
    ),
    (
        crate::EncodedStr::Ascii("coloring"),
        &[(0b11001, &ENTRY_COLORING_3210137591351035939)],
    ),
    (
        crate::EncodedStr::Ascii("colorings"),
        &[(0b11001, &ENTRY_COLORINGS_3076825598771260084)],
    ),
    (
        crate::EncodedStr::Ascii("colorism"),
        &[(0b00001, &ENTRY_COLORISM_11451642000509277550)],
    ),
    (
        crate::EncodedStr::Ascii("colorisms"),
        &[(0b00001, &ENTRY_COLORISMS_9834615672957808489)],
    ),
    (
        crate::EncodedStr::Ascii("colorist"),
        &[(0b01001, &ENTRY_COLORIST_3170137357114879751)],
    ),
    (
        crate::EncodedStr::Ascii("coloristic"),
        &[(0b00001, &ENTRY_COLORISTIC_4901807440455152786)],
    ),
    (
        crate::EncodedStr::Ascii("coloristically"),
        &[(0b00001, &ENTRY_COLORISTICALLY_4826074029409437505)],
    ),
    (
        crate::EncodedStr::Ascii("coloristicer"),
        &[(0b00001, &ENTRY_COLORISTICER_8710817088617352267)],
    ),
    (
        crate::EncodedStr::Ascii("coloristicest"),
        &[(0b00001, &ENTRY_COLORISTICEST_2991259503195608639)],
    ),
    (
        crate::EncodedStr::Ascii("coloristics"),
        &[(0b00001, &ENTRY_COLORISTICS_10161388239807067112)],
    ),
    (
        crate::EncodedStr::Ascii("colorists"),
        &[(0b01001, &ENTRY_COLORISTS_205210891187993391)],
    ),
    (
        crate::EncodedStr::Ascii("colorization"),
        &[(0b00001, &ENTRY_COLORIZATION_8112190634064658436)],
    ),
    (
        crate::EncodedStr::Ascii("colorizations"),
        &[(0b00001, &ENTRY_COLORIZATIONS_4267572307963209982)],
    ),
    (
        crate::EncodedStr::Ascii("colorize"),
        &[(0b00001, &ENTRY_COLORIZE_378813947509810224)],
    ),
    (
        crate::EncodedStr::Ascii("colorized"),
        &[(0b00001, &ENTRY_COLORIZED_1927556635004418734)],
    ),
    (
        crate::EncodedStr::Ascii("colorizes"),
        &[(0b00001, &ENTRY_COLORIZES_12579061677034347790)],
    ),
    (
        crate::EncodedStr::Ascii("colorizing"),
        &[(0b00001, &ENTRY_COLORIZING_2623120429929129787)],
    ),
    (
        crate::EncodedStr::Ascii("colorless"),
        &[(0b11001, &ENTRY_COLORLESS_15335426167000546767)],
    ),
    (
        crate::EncodedStr::Ascii("colorlesser"),
        &[(0b11001, &ENTRY_COLORLESSER_9795559032347620897)],
    ),
    (
        crate::EncodedStr::Ascii("colorlessest"),
        &[(0b11001, &ENTRY_COLORLESSEST_2853202552785506979)],
    ),
    (
        crate::EncodedStr::Ascii("colorlesslier"),
        &[(0b11001, &ENTRY_COLORLESSLIER_15143289294047728460)],
    ),
    (
        crate::EncodedStr::Ascii("colorlessliest"),
        &[(0b11001, &ENTRY_COLORLESSLIEST_12819557587409285660)],
    ),
    (
        crate::EncodedStr::Ascii("colorlessly"),
        &[(0b11001, &ENTRY_COLORLESSLY_15719317170801627859)],
    ),
    (
        crate::EncodedStr::Ascii("colorlessness"),
        &[(0b11001, &ENTRY_COLORLESSNESS_3911470984873699039)],
    ),
    (
        crate::EncodedStr::Ascii("colorlessnesses"),
        &[(0b11001, &ENTRY_COLORLESSNESSES_17325232283084205852)],
    ),
    (
        crate::EncodedStr::Ascii("colormaker"),
        &[(0b11001, &ENTRY_COLORMAKER_13048991323713933641)],
    ),
    (
        crate::EncodedStr::Ascii("colormaking"),
        &[(0b11001, &ENTRY_COLORMAKING_3298385465563328410)],
    ),
    (
        crate::EncodedStr::Ascii("colorman"),
        &[(0b11001, &ENTRY_COLORMAN_9192316057645589430)],
    ),
    (
        crate::EncodedStr::Ascii("colormap"),
        &[(0b11001, &ENTRY_COLORMAP_18024738796464819872)],
    ),
    (
        crate::EncodedStr::Ascii("colormaps"),
        &[(0b11001, &ENTRY_COLORMAPS_11406342514432472514)],
    ),
    (
        crate::EncodedStr::Ascii("colormen"),
        &[(0b11001, &ENTRY_COLORMEN_1963797128559420405)],
    ),
    (
        crate::EncodedStr::Ascii("coloroto"),
        &[(0b00001, &ENTRY_COLOROTO_5869254994177780978)],
    ),
    (
        crate::EncodedStr::Ascii("colorpoint"),
        &[(0b11001, &ENTRY_COLORPOINT_12353596064079181917)],
    ),
    (
        crate::EncodedStr::Ascii("colorpoints"),
        &[(0b11001, &ENTRY_COLORPOINTS_13015689836998141845)],
    ),
    (
        crate::EncodedStr::Ascii("colorrest"),
        &[(0b11001, &ENTRY_COLORREST_6777192705388068909)],
    ),
    (
        crate::EncodedStr::Ascii("colorrhaphy"),
        &[(0b00001, &ENTRY_COLORRHAPHY_13136665400257945176)],
    ),
    (
        crate::EncodedStr::Ascii("colors"),
        &[(0b11001, &ENTRY_COLORS_13018845474144214729)],
    ),
    (
        crate::EncodedStr::Ascii("colortype"),
        &[(0b11001, &ENTRY_COLORTYPE_14680038702599961625)],
    ),
    (
        crate::EncodedStr::Ascii("colorway"),
        &[(0b11001, &ENTRY_COLORWAY_14654249147936693420)],
    ),
    (
        crate::EncodedStr::Ascii("colorways"),
        &[(0b11001, &ENTRY_COLORWAYS_6062463807369877282)],
    ),
    (
        crate::EncodedStr::Ascii("colory"),
        &[(0b00001, &ENTRY_COLORY_3235234236420467456)],
    ),
    (
        crate::EncodedStr::Ascii("colour"),
        &[(0b11010, &ENTRY_COLOR_17720358635329736641)],
    ),
    (
        crate::EncodedStr::Ascii("colourabilities"),
        &[(0b11010, &ENTRY_COLORABILITIES_17934830495879279238)],
    ),
    (
        crate::EncodedStr::Ascii("colourability"),
        &[(0b11010, &ENTRY_COLORABILITY_3833618249244001959)],
    ),
    (
        crate::EncodedStr::Ascii("colourable"),
        &[(0b11010, &ENTRY_COLORABLE_9126609110540102083)],
    ),
    (
        crate::EncodedStr::Ascii("colourableness"),
        &[(0b11010, &ENTRY_COLORABLENESS_1061796348140451347)],
    ),
    (
        crate::EncodedStr::Ascii("colourablenesses"),
        &[(0b11010, &ENTRY_COLORABLENESSES_10749946314548598617)],
    ),
    (
        crate::EncodedStr::Ascii("colourabler"),
        &[(0b11010, &ENTRY_COLORABLER_1063847220352847404)],
    ),
    (
        crate::EncodedStr::Ascii("colourables"),
        &[(0b11010, &ENTRY_COLORABLES_10854398030589164189)],
    ),
    (
        crate::EncodedStr::Ascii("colourablest"),
        &[(0b11010, &ENTRY_COLORABLEST_3683085641889155962)],
    ),
    (
        crate::EncodedStr::Ascii("colourablier"),
        &[(0b11010, &ENTRY_COLORABLIER_5968483988144955864)],
    ),
    (
        crate::EncodedStr::Ascii("colourablies"),
        &[(0b11010, &ENTRY_COLORABLIES_16005107918816262896)],
    ),
    (
        crate::EncodedStr::Ascii("colourabliest"),
        &[(0b11010, &ENTRY_COLORABLIEST_5199306118528597149)],
    ),
    (
        crate::EncodedStr::Ascii("colourably"),
        &[(0b11010, &ENTRY_COLORABLY_13475999889111967538)],
    ),
    (
        crate::EncodedStr::Ascii("colouradan"),
        &[(0b11010, &ENTRY_COLORADAN_1710087118093866996)],
    ),
    (
        crate::EncodedStr::Ascii("colouradans"),
        &[(0b11010, &ENTRY_COLORADANS_1537230991364273395)],
    ),
    (
        crate::EncodedStr::Ascii("colourado"),
        &[(0b11010, &ENTRY_COLORADO_672786360083421122)],
    ),
    (
        crate::EncodedStr::Ascii("colouradoite"),
        &[(0b11010, &ENTRY_COLORADOITE_10437671738809934244)],
    ),
    (
        crate::EncodedStr::Ascii("colourama"),
        &[(0b11010, &ENTRY_COLORAMA_10946100748903023597)],
    ),
    (
        crate::EncodedStr::Ascii("colourant"),
        &[(0b11010, &ENTRY_COLORANT_105918244627467133)],
    ),
    (
        crate::EncodedStr::Ascii("colourants"),
        &[(0b11010, &ENTRY_COLORANTS_7537794752295559574)],
    ),
    (
        crate::EncodedStr::Ascii("colourate"),
        &[(0b11010, &ENTRY_COLORATE_7568881222694249579)],
    ),
    (
        crate::EncodedStr::Ascii("colouration"),
        &[(0b11010, &ENTRY_COLORATION_8662739203385742912)],
    ),
    (
        crate::EncodedStr::Ascii("colourational"),
        &[(0b11010, &ENTRY_COLORATIONAL_7644580988989747664)],
    ),
    (
        crate::EncodedStr::Ascii("colourationaler"),
        &[(0b11010, &ENTRY_COLORATIONALER_18110955114460055798)],
    ),
    (
        crate::EncodedStr::Ascii("colourationalest"),
        &[(0b11010, &ENTRY_COLORATIONALEST_16549871838474883279)],
    ),
    (
        crate::EncodedStr::Ascii("colourationallier"),
        &[(0b11010, &ENTRY_COLORATIONALLIER_11632159047499104121)],
    ),
    (
        crate::EncodedStr::Ascii("colourationalliest"),
        &[(0b11010, &ENTRY_COLORATIONALLIEST_15869239691609448176)],
    ),
    (
        crate::EncodedStr::Ascii("colourationally"),
        &[(0b11010, &ENTRY_COLORATIONALLY_6635974304993009997)],
    ),
    (
        crate::EncodedStr::Ascii("colourations"),
        &[(0b11010, &ENTRY_COLORATIONS_1952756960960680507)],
    ),
    (
        crate::EncodedStr::Ascii("colourative"),
        &[(0b11010, &ENTRY_COLORATIVE_17851173748347347190)],
    ),
    (
        crate::EncodedStr::Ascii("colourbearer"),
        &[(0b11010, &ENTRY_COLORBEARER_9903060614478418481)],
    ),
    (
        crate::EncodedStr::Ascii("colourblind"),
        &[(0b11010, &ENTRY_COLORBLIND_6088870633188592041)],
    ),
    (
        crate::EncodedStr::Ascii("colourblindness"),
        &[(0b11010, &ENTRY_COLORBLINDNESS_15137443200927238655)],
    ),
    (
        crate::EncodedStr::Ascii("colourblindnesses"),
        &[(0b11010, &ENTRY_COLORBLINDNESSES_12714928556099515868)],
    ),
    (
        crate::EncodedStr::Ascii("colourbred"),
        &[(0b11010, &ENTRY_COLORBRED_17391526765371994938)],
    ),
    (
        crate::EncodedStr::Ascii("colourbreed"),
        &[(0b11010, &ENTRY_COLORBREED_988623603127049866)],
    ),
    (
        crate::EncodedStr::Ascii("colourbreeding"),
        &[(0b11010, &ENTRY_COLORBREEDING_14262752611756151320)],
    ),
    (
        crate::EncodedStr::Ascii("colourbreeds"),
        &[(0b11010, &ENTRY_COLORBREEDS_5534022895414416287)],
    ),
    (
        crate::EncodedStr::Ascii("colourcast"),
        &[(0b11010, &ENTRY_COLORCAST_16740960231179575917)],
    ),
    (
        crate::EncodedStr::Ascii("colourcasted"),
        &[(0b11010, &ENTRY_COLORCASTED_10398645425299808234)],
    ),
    (
        crate::EncodedStr::Ascii("colourcaster"),
        &[(0b11010, &ENTRY_COLORCASTER_8192206561724383576)],
    ),
    (
        crate::EncodedStr::Ascii("colourcasters"),
        &[(0b11010, &ENTRY_COLORCASTERS_9885877195250711665)],
    ),
    (
        crate::EncodedStr::Ascii("colourcasting"),
        &[(0b11010, &ENTRY_COLORCASTING_9616298919649932012)],
    ),
    (
        crate::EncodedStr::Ascii("colourcasts"),
        &[(0b11010, &ENTRY_COLORCASTS_17581853229444769235)],
    ),
    (
        crate::EncodedStr::Ascii("colourectal"),
        &[(0b11010, &ENTRY_COLORECTAL_9394771582914199855)],
    ),
    (
        crate::EncodedStr::Ascii("colourectitis"),
        &[(0b11010, &ENTRY_COLORECTITIS_11920759655606208881)],
    ),
    (
        crate::EncodedStr::Ascii("colourectostomy"),
        &[(0b11010, &ENTRY_COLORECTOSTOMY_809184159134628418)],
    ),
    (
        crate::EncodedStr::Ascii("coloured"),
        &[(0b11010, &ENTRY_COLORED_809367823820397764)],
    ),
    (
        crate::EncodedStr::Ascii("coloureds"),
        &[(0b11010, &ENTRY_COLOREDS_5638105898846322523)],
    ),
    (
        crate::EncodedStr::Ascii("colourer"),
        &[(0b11010, &ENTRY_COLORER_6377883908421217617)],
    ),
    (
        crate::EncodedStr::Ascii("colourers"),
        &[(0b11010, &ENTRY_COLORERS_5523036624009318320)],
    ),
    (
        crate::EncodedStr::Ascii("colourest"),
        &[(0b11010, &ENTRY_COLORREST_6777192705388068909)],
    ),
    (
        crate::EncodedStr::Ascii("colourfast"),
        &[(0b11010, &ENTRY_COLORFAST_16696822485914404702)],
    ),
    (
        crate::EncodedStr::Ascii("colourfastness"),
        &[(0b11010, &ENTRY_COLORFASTNESS_3258841464722986607)],
    ),
    (
        crate::EncodedStr::Ascii("colourfastnesses"),
        &[(0b11010, &ENTRY_COLORFASTNESSES_14995112700652023509)],
    ),
    (
        crate::EncodedStr::Ascii("colourful"),
        &[(0b11010, &ENTRY_COLORFUL_16225861255487751804)],
    ),
    (
        crate::EncodedStr::Ascii("colourfuler"),
        &[(0b11010, &ENTRY_COLORFULER_10294924989983822582)],
    ),
    (
        crate::EncodedStr::Ascii("colourfulest"),
        &[(0b11010, &ENTRY_COLORFULEST_202572902882532719)],
    ),
    (
        crate::EncodedStr::Ascii("colourfullier"),
        &[(0b11010, &ENTRY_COLORFULLIER_3454480613316383412)],
    ),
    (
        crate::EncodedStr::Ascii("colourfulliest"),
        &[(0b11010, &ENTRY_COLORFULLIEST_14019017521674302328)],
    ),
    (
        crate::EncodedStr::Ascii("colourfully"),
        &[(0b11010, &ENTRY_COLORFULLY_7749800674951458575)],
    ),
    (
        crate::EncodedStr::Ascii("colourfulness"),
        &[(0b11010, &ENTRY_COLORFULNESS_8831709788792250227)],
    ),
    (
        crate::EncodedStr::Ascii("colourfulnesses"),
        &[(0b11010, &ENTRY_COLORFULNESSES_11724036744178299544)],
    ),
    (
        crate::EncodedStr::Ascii("colourific"),
        &[(0b11010, &ENTRY_COLORIFIC_17453281363599547611)],
    ),
    (
        crate::EncodedStr::Ascii("colourifics"),
        &[(0b11010, &ENTRY_COLORIFICS_7493178994191350405)],
    ),
    (
        crate::EncodedStr::Ascii("colourimeter"),
        &[(0b11010, &ENTRY_COLORIMETER_5995992236279956204)],
    ),
    (
        crate::EncodedStr::Ascii("colourimeters"),
        &[(0b11010, &ENTRY_COLORIMETERS_16988328923257615588)],
    ),
    (
        crate::EncodedStr::Ascii("colourimetric"),
        &[(0b11010, &ENTRY_COLORIMETRIC_2752387257901137840)],
    ),
    (
        crate::EncodedStr::Ascii("colourimetrical"),
        &[(0b11010, &ENTRY_COLORIMETRICAL_14932230836831976255)],
    ),
    (
        crate::EncodedStr::Ascii("colourimetrically"),
        &[(0b11010, &ENTRY_COLORIMETRICALLY_5243289402205557910)],
    ),
    (
        crate::EncodedStr::Ascii("colourimetrics"),
        &[(0b11010, &ENTRY_COLORIMETRICS_8847586357101611180)],
    ),
    (
        crate::EncodedStr::Ascii("colourimetries"),
        &[(0b11010, &ENTRY_COLORIMETRIES_16352633730423789473)],
    ),
    (
        crate::EncodedStr::Ascii("colourimetrist"),
        &[(0b11010, &ENTRY_COLORIMETRIST_16103668754911113058)],
    ),
    (
        crate::EncodedStr::Ascii("colourimetry"),
        &[(0b11010, &ENTRY_COLORIMETRY_1096025596659311412)],
    ),
    (
        crate::EncodedStr::Ascii("colourin"),
        &[(0b11010, &ENTRY_COLORIN_7364447797547189461)],
    ),
    (
        crate::EncodedStr::Ascii("colouring"),
        &[(0b11010, &ENTRY_COLORING_3210137591351035939)],
    ),
    (
        crate::EncodedStr::Ascii("colourings"),
        &[(0b11010, &ENTRY_COLORINGS_3076825598771260084)],
    ),
    (
        crate::EncodedStr::Ascii("colourisation"),
        &[(0b10010, &ENTRY_COLORIZATION_8112190634064658436)],
    ),
    (
        crate::EncodedStr::Ascii("colourisations"),
        &[(0b10010, &ENTRY_COLORIZATIONS_4267572307963209982)],
    ),
    (
        crate::EncodedStr::Ascii("colourise"),
        &[(0b10010, &ENTRY_COLORIZE_378813947509810224)],
    ),
    (
        crate::EncodedStr::Ascii("colourised"),
        &[(0b10010, &ENTRY_COLORIZED_1927556635004418734)],
    ),
    (
        crate::EncodedStr::Ascii("colourises"),
        &[(0b10010, &ENTRY_COLORIZES_12579061677034347790)],
    ),
    (
        crate::EncodedStr::Ascii("colourising"),
        &[(0b10010, &ENTRY_COLORIZING_2623120429929129787)],
    ),
    (
        crate::EncodedStr::Ascii("colourism"),
        &[(0b11010, &ENTRY_COLORISM_11451642000509277550)],
    ),
    (
        crate::EncodedStr::Ascii("colourisms"),
        &[(0b11010, &ENTRY_COLORISMS_9834615672957808489)],
    ),
    (
        crate::EncodedStr::Ascii("colourist"),
        &[(0b11010, &ENTRY_COLORIST_3170137357114879751)],
    ),
    (
        crate::EncodedStr::Ascii("colouristic"),
        &[(0b11010, &ENTRY_COLORISTIC_4901807440455152786)],
    ),
    (
        crate::EncodedStr::Ascii("colouristically"),
        &[(0b11010, &ENTRY_COLORISTICALLY_4826074029409437505)],
    ),
    (
        crate::EncodedStr::Ascii("colouristicer"),
        &[(0b11010, &ENTRY_COLORISTICER_8710817088617352267)],
    ),
    (
        crate::EncodedStr::Ascii("colouristicest"),
        &[(0b11010, &ENTRY_COLORISTICEST_2991259503195608639)],
    ),
    (
        crate::EncodedStr::Ascii("colouristics"),
        &[(0b11010, &ENTRY_COLORISTICS_10161388239807067112)],
    ),
    (
        crate::EncodedStr::Ascii("colourists"),
        &[(0b11010, &ENTRY_COLORISTS_205210891187993391)],
    ),
    (
        crate::EncodedStr::Ascii("colourization"),
        &[(0b01000, &ENTRY_COLORIZATION_8112190634064658436)],
    ),
    (
        crate::EncodedStr::Ascii("colourizations"),
        &[(0b01000, &ENTRY_COLORIZATIONS_4267572307963209982)],
    ),
    (
        crate::EncodedStr::Ascii("colourize"),
        &[(0b01000, &ENTRY_COLORIZE_378813947509810224)],
    ),
    (
        crate::EncodedStr::Ascii("colourized"),
        &[(0b01000, &ENTRY_COLORIZED_1927556635004418734)],
    ),
    (
        crate::EncodedStr::Ascii("colourizes"),
        &[(0b01000, &ENTRY_COLORIZES_12579061677034347790)],
    ),
    (
        crate::EncodedStr::Ascii("colourizing"),
        &[(0b01000, &ENTRY_COLORIZING_2623120429929129787)],
    ),
    (
        crate::EncodedStr::Ascii("colourless"),
        &[(0b11010, &ENTRY_COLORLESS_15335426167000546767)],
    ),
    (
        crate::EncodedStr::Ascii("colourlesser"),
        &[(0b11010, &ENTRY_COLORLESSER_9795559032347620897)],
    ),
    (
        crate::EncodedStr::Ascii("colourlessest"),
        &[(0b11010, &ENTRY_COLORLESSEST_2853202552785506979)],
    ),
    (
        crate::EncodedStr::Ascii("colourlesslier"),
        &[(0b11010, &ENTRY_COLORLESSLIER_15143289294047728460)],
    ),
    (
        crate::EncodedStr::Ascii("colourlessliest"),
        &[(0b11010, &ENTRY_COLORLESSLIEST_12819557587409285660)],
    ),
    (
        crate::EncodedStr::Ascii("colourlessly"),
        &[(0b11010, &ENTRY_COLORLESSLY_15719317170801627859)],
    ),
    (
        crate::EncodedStr::Ascii("colourlessness"),
        &[(0b11010, &ENTRY_COLORLESSNESS_3911470984873699039)],
    ),
    (
        crate::EncodedStr::Ascii("colourlessnesses"),
        &[(0b11010, &ENTRY_COLORLESSNESSES_17325232283084205852)],
    ),
    (
        crate::EncodedStr::Ascii("colourmaker"),
        &[(0b11010, &ENTRY_COLORMAKER_13048991323713933641)],
    ),
    (
        crate::EncodedStr::Ascii("colourmaking"),
        &[(0b11010, &ENTRY_COLORMAKING_3298385465563328410)],
    ),
    (
        crate::EncodedStr::Ascii("colourman"),
        &[(0b11010, &ENTRY_COLORMAN_9192316057645589430)],
    ),
    (
        crate::EncodedStr::Ascii("colourmap"),
        &[(0b11010, &ENTRY_COLORMAP_18024738796464819872)],
    ),
    (
        crate::EncodedStr::Ascii("colourmaps"),
        &[(0b11010, &ENTRY_COLORMAPS_11406342514432472514)],
    ),
    (
        crate::EncodedStr::Ascii("colourmen"),
        &[(0b11010, &ENTRY_COLORMEN_1963797128559420405)],
    ),
    (
        crate::EncodedStr::Ascii("colouroto"),
        &[(0b11010, &ENTRY_COLOROTO_5869254994177780978)],
    ),
    (
        crate::EncodedStr::Ascii("colourpoint"),
        &[(0b11010, &ENTRY_COLORPOINT_12353596064079181917)],
    ),
    (
        crate::EncodedStr::Ascii("colourpoints"),
        &[(0b11010, &ENTRY_COLORPOINTS_13015689836998141845)],
    ),
    (
        crate::EncodedStr::Ascii("colourrhaphy"),
        &[(0b11010, &ENTRY_COLORRHAPHY_13136665400257945176)],
    ),
    (
        crate::EncodedStr::Ascii("colours"),
        &[(0b11010, &ENTRY_COLORS_13018845474144214729)],
    ),
    (
        crate::EncodedStr::Ascii("colourtype"),
        &[(0b11010, &ENTRY_COLORTYPE_14680038702599961625)],
    ),
    (
        crate::EncodedStr::Ascii("colourway"),
        &[(0b11010, &ENTRY_COLORWAY_14654249147936693420)],
    ),
    (
        crate::EncodedStr::Ascii("colourways"),
        &[(0b11010, &ENTRY_COLORWAYS_6062463807369877282)],
    ),
    (
        crate::EncodedStr::Ascii("coloury"),
        &[(0b11010, &ENTRY_COLORY_3235234236420467456)],
    ),
    (
        crate::EncodedStr::Ascii("columnisation"),
        &[(0b10010, &ENTRY_COLUMNIZATION_11878276873729118026)],
    ),
    (
        crate::EncodedStr::Ascii("columnisations"),
        &[(0b10010, &ENTRY_COLUMNIZATIONS_12733006362612848403)],
    ),
    (
        crate::EncodedStr::Ascii("columnise"),
        &[(0b10010, &ENTRY_COLUMNIZE_7550365049509673455)],
    ),
    (
        crate::EncodedStr::Ascii("columnised"),
        &[(0b10010, &ENTRY_COLUMNIZED_12525419582000651703)],
    ),
    (
        crate::EncodedStr::Ascii("columnises"),
        &[(0b10010, &ENTRY_COLUMNIZES_920618881458905076)],
    ),
    (
        crate::EncodedStr::Ascii("columnising"),
        &[(0b10010, &ENTRY_COLUMNIZING_11760357087944386265)],
    ),
    (
        crate::EncodedStr::Ascii("columnization"),
        &[(0b01001, &ENTRY_COLUMNIZATION_11878276873729118026)],
    ),
    (
        crate::EncodedStr::Ascii("columnizations"),
        &[(0b01001, &ENTRY_COLUMNIZATIONS_12733006362612848403)],
    ),
    (
        crate::EncodedStr::Ascii("columnize"),
        &[(0b01001, &ENTRY_COLUMNIZE_7550365049509673455)],
    ),
    (
        crate::EncodedStr::Ascii("columnized"),
        &[(0b01001, &ENTRY_COLUMNIZED_12525419582000651703)],
    ),
    (
        crate::EncodedStr::Ascii("columnizes"),
        &[(0b01001, &ENTRY_COLUMNIZES_920618881458905076)],
    ),
    (
        crate::EncodedStr::Ascii("columnizing"),
        &[(0b01001, &ENTRY_COLUMNIZING_11760357087944386265)],
    ),
    (
        crate::EncodedStr::Ascii("comedia"),
        &[(0b00001, &ENTRY_COMEDIA_5856845506973447538)],
    ),
    (
        crate::EncodedStr::Ascii("commercialisation"),
        &[(0b10010, &ENTRY_COMMERCIALIZATION_1643106928830782978)],
    ),
    (
        crate::EncodedStr::Ascii("commercialisations"),
        &[(0b10010, &ENTRY_COMMERCIALIZATIONS_17012404820436874389)],
    ),
    (
        crate::EncodedStr::Ascii("commercialise"),
        &[(0b10010, &ENTRY_COMMERCIALIZE_16888630425257885338)],
    ),
    (
        crate::EncodedStr::Ascii("commercialised"),
        &[(0b10010, &ENTRY_COMMERCIALIZED_13681505620366419859)],
    ),
    (
        crate::EncodedStr::Ascii("commercialises"),
        &[(0b10010, &ENTRY_COMMERCIALIZES_7923464025673338308)],
    ),
    (
        crate::EncodedStr::Ascii("commercialising"),
        &[(0b10010, &ENTRY_COMMERCIALIZING_10714170346661677285)],
    ),
    (
        crate::EncodedStr::Ascii("commercialization"),
        &[(0b01001, &ENTRY_COMMERCIALIZATION_1643106928830782978)],
    ),
    (
        crate::EncodedStr::Ascii("commercializations"),
        &[(0b01001, &ENTRY_COMMERCIALIZATIONS_17012404820436874389)],
    ),
    (
        crate::EncodedStr::Ascii("commercialize"),
        &[(0b01001, &ENTRY_COMMERCIALIZE_16888630425257885338)],
    ),
    (
        crate::EncodedStr::Ascii("commercialized"),
        &[(0b01001, &ENTRY_COMMERCIALIZED_13681505620366419859)],
    ),
    (
        crate::EncodedStr::Ascii("commercializes"),
        &[(0b01001, &ENTRY_COMMERCIALIZES_7923464025673338308)],
    ),
    (
        crate::EncodedStr::Ascii("commercializing"),
        &[(0b01001, &ENTRY_COMMERCIALIZING_10714170346661677285)],
    ),
    (
        crate::EncodedStr::Ascii("commonise"),
        &[(0b10010, &ENTRY_COMMONIZE_3127845796652963145)],
    ),
    (
        crate::EncodedStr::Ascii("commonises"),
        &[(0b10010, &ENTRY_COMMONIZES_1050237353426943643)],
    ),
    (
        crate::EncodedStr::Ascii("commonize"),
        &[(0b01001, &ENTRY_COMMONIZE_3127845796652963145)],
    ),
    (
        crate::EncodedStr::Ascii("commonizes"),
        &[(0b01001, &ENTRY_COMMONIZES_1050237353426943643)],
    ),
    (
        crate::EncodedStr::Ascii("communalisation"),
        &[(0b10010, &ENTRY_COMMUNALIZATION_1354902119947113774)],
    ),
    (
        crate::EncodedStr::Ascii("communalisations"),
        &[(0b10010, &ENTRY_COMMUNALIZATIONS_10004190720704121461)],
    ),
    (
        crate::EncodedStr::Ascii("communalise"),
        &[(0b10010, &ENTRY_COMMUNALIZE_16978210201059417779)],
    ),
    (
        crate::EncodedStr::Ascii("communalised"),
        &[(0b10010, &ENTRY_COMMUNALIZED_8414107067770377657)],
    ),
    (
        crate::EncodedStr::Ascii("communaliser"),
        &[(0b10010, &ENTRY_COMMUNALIZER_9067480767105491194)],
    ),
    (
        crate::EncodedStr::Ascii("communalisers"),
        &[(0b10010, &ENTRY_COMMUNALIZERS_1419522334270734921)],
    ),
    (
        crate::EncodedStr::Ascii("communalises"),
        &[(0b10010, &ENTRY_COMMUNALIZES_12395688431331928966)],
    ),
    (
        crate::EncodedStr::Ascii("communalising"),
        &[(0b10010, &ENTRY_COMMUNALIZING_8021518098437504841)],
    ),
    (
        crate::EncodedStr::Ascii("communalization"),
        &[(0b01001, &ENTRY_COMMUNALIZATION_1354902119947113774)],
    ),
    (
        crate::EncodedStr::Ascii("communalizations"),
        &[(0b01001, &ENTRY_COMMUNALIZATIONS_10004190720704121461)],
    ),
    (
        crate::EncodedStr::Ascii("communalize"),
        &[(0b01001, &ENTRY_COMMUNALIZE_16978210201059417779)],
    ),
    (
        crate::EncodedStr::Ascii("communalized"),
        &[(0b01001, &ENTRY_COMMUNALIZED_8414107067770377657)],
    ),
    (
        crate::EncodedStr::Ascii("communalizer"),
        &[(0b01001, &ENTRY_COMMUNALIZER_9067480767105491194)],
    ),
    (
        crate::EncodedStr::Ascii("communalizers"),
        &[(0b01001, &ENTRY_COMMUNALIZERS_1419522334270734921)],
    ),
    (
        crate::EncodedStr::Ascii("communalizes"),
        &[(0b01001, &ENTRY_COMMUNALIZES_12395688431331928966)],
    ),
    (
        crate::EncodedStr::Ascii("communalizing"),
        &[(0b01001, &ENTRY_COMMUNALIZING_8021518098437504841)],
    ),
    (
        crate::EncodedStr::Ascii("communisation"),
        &[(0b10010, &ENTRY_COMMUNIZATION_847361005287031401)],
    ),
    (
        crate::EncodedStr::Ascii("communisations"),
        &[(0b10010, &ENTRY_COMMUNIZATIONS_9900325170167101461)],
    ),
    (
        crate::EncodedStr::Ascii("communise"),
        &[(0b10010, &ENTRY_COMMUNIZE_13614074380950312902)],
    ),
    (
        crate::EncodedStr::Ascii("communised"),
        &[(0b10010, &ENTRY_COMMUNIZED_15644498154290457954)],
    ),
    (
        crate::EncodedStr::Ascii("communises"),
        &[(0b10010, &ENTRY_COMMUNIZES_16239995256080535914)],
    ),
    (
        crate::EncodedStr::Ascii("communising"),
        &[(0b10010, &ENTRY_COMMUNIZING_4187287385336521999)],
    ),
    (
        crate::EncodedStr::Ascii("communization"),
        &[(0b01001, &ENTRY_COMMUNIZATION_847361005287031401)],
    ),
    (
        crate::EncodedStr::Ascii("communizations"),
        &[(0b01001, &ENTRY_COMMUNIZATIONS_9900325170167101461)],
    ),
    (
        crate::EncodedStr::Ascii("communize"),
        &[(0b01001, &ENTRY_COMMUNIZE_13614074380950312902)],
    ),
    (
        crate::EncodedStr::Ascii("communized"),
        &[(0b01001, &ENTRY_COMMUNIZED_15644498154290457954)],
    ),
    (
        crate::EncodedStr::Ascii("communizes"),
        &[(0b01001, &ENTRY_COMMUNIZES_16239995256080535914)],
    ),
    (
        crate::EncodedStr::Ascii("communizing"),
        &[(0b01001, &ENTRY_COMMUNIZING_4187287385336521999)],
    ),
    (
        crate::EncodedStr::Ascii("comoedia"),
        &[(0b11010, &ENTRY_COMEDIA_5856845506973447538)],
    ),
    (
        crate::EncodedStr::Ascii("companionise"),
        &[(0b10010, &ENTRY_COMPANIONIZE_17295459993069832105)],
    ),
    (
        crate::EncodedStr::Ascii("companionises"),
        &[(0b10010, &ENTRY_COMPANIONIZES_159175304294701734)],
    ),
    (
        crate::EncodedStr::Ascii("companionize"),
        &[(0b01001, &ENTRY_COMPANIONIZE_17295459993069832105)],
    ),
    (
        crate::EncodedStr::Ascii("companionizes"),
        &[(0b01001, &ENTRY_COMPANIONIZES_159175304294701734)],
    ),
    (
        crate::EncodedStr::Ascii("compartmentalisation"),
        &[(0b10010, &ENTRY_COMPARTMENTALIZATION_18240462251141060220)],
    ),
    (
        crate::EncodedStr::Ascii("compartmentalisations"),
        &[(0b10010, &ENTRY_COMPARTMENTALIZATIONS_2073690646158683595)],
    ),
    (
        crate::EncodedStr::Ascii("compartmentalise"),
        &[(0b10010, &ENTRY_COMPARTMENTALIZE_6316599424281105903)],
    ),
    (
        crate::EncodedStr::Ascii("compartmentalised"),
        &[(0b10010, &ENTRY_COMPARTMENTALIZED_2091042337396016604)],
    ),
    (
        crate::EncodedStr::Ascii("compartmentalises"),
        &[(0b10010, &ENTRY_COMPARTMENTALIZES_1429778905943784124)],
    ),
    (
        crate::EncodedStr::Ascii("compartmentalising"),
        &[(0b10010, &ENTRY_COMPARTMENTALIZING_14853138630531540565)],
    ),
    (
        crate::EncodedStr::Ascii("compartmentalization"),
        &[(0b01001, &ENTRY_COMPARTMENTALIZATION_18240462251141060220)],
    ),
    (
        crate::EncodedStr::Ascii("compartmentalizations"),
        &[(0b01001, &ENTRY_COMPARTMENTALIZATIONS_2073690646158683595)],
    ),
    (
        crate::EncodedStr::Ascii("compartmentalize"),
        &[(0b01001, &ENTRY_COMPARTMENTALIZE_6316599424281105903)],
    ),
    (
        crate::EncodedStr::Ascii("compartmentalized"),
        &[(0b01001, &ENTRY_COMPARTMENTALIZED_2091042337396016604)],
    ),
    (
        crate::EncodedStr::Ascii("compartmentalizes"),
        &[(0b01001, &ENTRY_COMPARTMENTALIZES_1429778905943784124)],
    ),
    (
        crate::EncodedStr::Ascii("compartmentalizing"),
        &[(0b01001, &ENTRY_COMPARTMENTALIZING_14853138630531540565)],
    ),
    (
        crate::EncodedStr::Ascii("compartmentise"),
        &[(0b10010, &ENTRY_COMPARTMENTIZE_4090554704802645617)],
    ),
    (
        crate::EncodedStr::Ascii("compartmentises"),
        &[(0b10010, &ENTRY_COMPARTMENTIZES_12901335302225578235)],
    ),
    (
        crate::EncodedStr::Ascii("compartmentize"),
        &[(0b01001, &ENTRY_COMPARTMENTIZE_4090554704802645617)],
    ),
    (
        crate::EncodedStr::Ascii("compartmentizes"),
        &[(0b01001, &ENTRY_COMPARTMENTIZES_12901335302225578235)],
    ),
    (
        crate::EncodedStr::Ascii("comper"),
        &[(0b00001, &ENTRY_COMPER_13800353684688405016)],
    ),
    (
        crate::EncodedStr::Ascii("complementiser"),
        &[(0b10010, &ENTRY_COMPLEMENTIZER_6562757288101998612)],
    ),
    (
        crate::EncodedStr::Ascii("complementizer"),
        &[(0b01001, &ENTRY_COMPLEMENTIZER_6562757288101998612)],
    ),
    (
        crate::EncodedStr::Ascii("compoer"),
        &[(0b11010, &ENTRY_COMPER_13800353684688405016)],
    ),
    (
        crate::EncodedStr::Ascii("compositae"),
        &[(0b11010, &ENTRY_COMPOSITE_2834997305530089174)],
    ),
    (
        crate::EncodedStr::Ascii("composite"),
        &[(0b00001, &ENTRY_COMPOSITE_2834997305530089174)],
    ),
    (
        crate::EncodedStr::Ascii("comprehensivisation"),
        &[(0b10010, &ENTRY_COMPREHENSIVIZATION_15958998661265330414)],
    ),
    (
        crate::EncodedStr::Ascii("comprehensivisations"),
        &[(0b10010, &ENTRY_COMPREHENSIVIZATIONS_1893003905937999548)],
    ),
    (
        crate::EncodedStr::Ascii("comprehensivise"),
        &[(0b10010, &ENTRY_COMPREHENSIVIZE_12410257886709581767)],
    ),
    (
        crate::EncodedStr::Ascii("comprehensivised"),
        &[(0b10010, &ENTRY_COMPREHENSIVIZED_2933839517192572218)],
    ),
    (
        crate::EncodedStr::Ascii("comprehensivises"),
        &[(0b10010, &ENTRY_COMPREHENSIVIZES_7584059223344239212)],
    ),
    (
        crate::EncodedStr::Ascii("comprehensivising"),
        &[(0b10010, &ENTRY_COMPREHENSIVIZING_2953121830198164292)],
    ),
    (
        crate::EncodedStr::Ascii("comprehensivization"),
        &[(0b01001, &ENTRY_COMPREHENSIVIZATION_15958998661265330414)],
    ),
    (
        crate::EncodedStr::Ascii("comprehensivizations"),
        &[(0b01001, &ENTRY_COMPREHENSIVIZATIONS_1893003905937999548)],
    ),
    (
        crate::EncodedStr::Ascii("comprehensivize"),
        &[(0b01001, &ENTRY_COMPREHENSIVIZE_12410257886709581767)],
    ),
    (
        crate::EncodedStr::Ascii("comprehensivized"),
        &[(0b01001, &ENTRY_COMPREHENSIVIZED_2933839517192572218)],
    ),
    (
        crate::EncodedStr::Ascii("comprehensivizes"),
        &[(0b01001, &ENTRY_COMPREHENSIVIZES_7584059223344239212)],
    ),
    (
        crate::EncodedStr::Ascii("comprehensivizing"),
        &[(0b01001, &ENTRY_COMPREHENSIVIZING_2953121830198164292)],
    ),
    (
        crate::EncodedStr::Ascii("comprisable"),
        &[(0b10010, &ENTRY_COMPRIZABLE_4826744105914478701)],
    ),
    (
        crate::EncodedStr::Ascii("comprisal"),
        &[(0b10010, &ENTRY_COMPRIZAL_9931805136956588535)],
    ),
    (
        crate::EncodedStr::Ascii("comprizable"),
        &[(0b01001, &ENTRY_COMPRIZABLE_4826744105914478701)],
    ),
    (
        crate::EncodedStr::Ascii("comprizal"),
        &[(0b01001, &ENTRY_COMPRIZAL_9931805136956588535)],
    ),
    (
        crate::EncodedStr::Ascii("computerisable"),
        &[(0b10010, &ENTRY_COMPUTERIZABLE_11675963878159642483)],
    ),
    (
        crate::EncodedStr::Ascii("computerisation"),
        &[(0b10010, &ENTRY_COMPUTERIZATION_14289958571575590804)],
    ),
    (
        crate::EncodedStr::Ascii("computerisations"),
        &[(0b10010, &ENTRY_COMPUTERIZATIONS_5765686861831125257)],
    ),
    (
        crate::EncodedStr::Ascii("computerise"),
        &[(0b10010, &ENTRY_COMPUTERIZE_15545915378374926111)],
    ),
    (
        crate::EncodedStr::Ascii("computerised"),
        &[(0b10010, &ENTRY_COMPUTERIZED_15101489353463973212)],
    ),
    (
        crate::EncodedStr::Ascii("computerises"),
        &[(0b10010, &ENTRY_COMPUTERIZES_14986241207867566402)],
    ),
    (
        crate::EncodedStr::Ascii("computerising"),
        &[(0b10010, &ENTRY_COMPUTERIZING_12865766678094814563)],
    ),
    (
        crate::EncodedStr::Ascii("computerizable"),
        &[(0b01001, &ENTRY_COMPUTERIZABLE_11675963878159642483)],
    ),
    (
        crate::EncodedStr::Ascii("computerization"),
        &[(0b01001, &ENTRY_COMPUTERIZATION_14289958571575590804)],
    ),
    (
        crate::EncodedStr::Ascii("computerizations"),
        &[(0b01001, &ENTRY_COMPUTERIZATIONS_5765686861831125257)],
    ),
    (
        crate::EncodedStr::Ascii("computerize"),
        &[(0b01001, &ENTRY_COMPUTERIZE_15545915378374926111)],
    ),
    (
        crate::EncodedStr::Ascii("computerized"),
        &[(0b01001, &ENTRY_COMPUTERIZED_15101489353463973212)],
    ),
    (
        crate::EncodedStr::Ascii("computerizes"),
        &[(0b01001, &ENTRY_COMPUTERIZES_14986241207867566402)],
    ),
    (
        crate::EncodedStr::Ascii("computerizing"),
        &[(0b01001, &ENTRY_COMPUTERIZING_12865766678094814563)],
    ),
    (
        crate::EncodedStr::Ascii("concenter"),
        &[(0b00001, &ENTRY_CONCENTER_12599613659019972198)],
    ),
    (
        crate::EncodedStr::Ascii("concentered"),
        &[(0b00001, &ENTRY_CONCENTERED_5661172717823289893)],
    ),
    (
        crate::EncodedStr::Ascii("concentering"),
        &[(0b00001, &ENTRY_CONCENTERING_8029206760572244740)],
    ),
    (
        crate::EncodedStr::Ascii("concenters"),
        &[(0b00001, &ENTRY_CONCENTERS_15190503554801426852)],
    ),
    (
        crate::EncodedStr::Ascii("concentre"),
        &[(0b11010, &ENTRY_CONCENTER_12599613659019972198)],
    ),
    (
        crate::EncodedStr::Ascii("concentred"),
        &[(0b11010, &ENTRY_CONCENTERED_5661172717823289893)],
    ),
    (
        crate::EncodedStr::Ascii("concentres"),
        &[(0b11010, &ENTRY_CONCENTERS_15190503554801426852)],
    ),
    (
        crate::EncodedStr::Ascii("concentring"),
        &[(0b11010, &ENTRY_CONCENTERING_8029206760572244740)],
    ),
    (
        crate::EncodedStr::Ascii("conceptualisation"),
        &[(0b10010, &ENTRY_CONCEPTUALIZATION_5738356471049765058)],
    ),
    (
        crate::EncodedStr::Ascii("conceptualisations"),
        &[(0b10010, &ENTRY_CONCEPTUALIZATIONS_11238993640785943456)],
    ),
    (
        crate::EncodedStr::Ascii("conceptualise"),
        &[(0b10010, &ENTRY_CONCEPTUALIZE_13986310691359872680)],
    ),
    (
        crate::EncodedStr::Ascii("conceptualised"),
        &[(0b10010, &ENTRY_CONCEPTUALIZED_6046228406726865910)],
    ),
    (
        crate::EncodedStr::Ascii("conceptualiser"),
        &[(0b10010, &ENTRY_CONCEPTUALIZER_9902569432824476207)],
    ),
    (
        crate::EncodedStr::Ascii("conceptualises"),
        &[(0b10010, &ENTRY_CONCEPTUALIZES_17221094629974506736)],
    ),
    (
        crate::EncodedStr::Ascii("conceptualising"),
        &[(0b10010, &ENTRY_CONCEPTUALIZING_540854313698733535)],
    ),
    (
        crate::EncodedStr::Ascii("conceptualization"),
        &[(0b01001, &ENTRY_CONCEPTUALIZATION_5738356471049765058)],
    ),
    (
        crate::EncodedStr::Ascii("conceptualizations"),
        &[(0b01001, &ENTRY_CONCEPTUALIZATIONS_11238993640785943456)],
    ),
    (
        crate::EncodedStr::Ascii("conceptualize"),
        &[(0b01001, &ENTRY_CONCEPTUALIZE_13986310691359872680)],
    ),
    (
        crate::EncodedStr::Ascii("conceptualized"),
        &[(0b01001, &ENTRY_CONCEPTUALIZED_6046228406726865910)],
    ),
    (
        crate::EncodedStr::Ascii("conceptualizer"),
        &[(0b01001, &ENTRY_CONCEPTUALIZER_9902569432824476207)],
    ),
    (
        crate::EncodedStr::Ascii("conceptualizes"),
        &[(0b01001, &ENTRY_CONCEPTUALIZES_17221094629974506736)],
    ),
    (
        crate::EncodedStr::Ascii("conceptualizing"),
        &[(0b01001, &ENTRY_CONCEPTUALIZING_540854313698733535)],
    ),
    (
        crate::EncodedStr::Ascii("concertise"),
        &[(0b10010, &ENTRY_CONCERTIZE_12949550082462386391)],
    ),
    (
        crate::EncodedStr::Ascii("concertised"),
        &[(0b10010, &ENTRY_CONCERTIZED_13322827190564875313)],
    ),
    (
        crate::EncodedStr::Ascii("concertiser"),
        &[(0b10010, &ENTRY_CONCERTIZER_1607241334899378280)],
    ),
    (
        crate::EncodedStr::Ascii("concertisers"),
        &[(0b10010, &ENTRY_CONCERTIZERS_18408860231574633709)],
    ),
    (
        crate::EncodedStr::Ascii("concertises"),
        &[(0b10010, &ENTRY_CONCERTIZES_11707521685205330713)],
    ),
    (
        crate::EncodedStr::Ascii("concertising"),
        &[(0b10010, &ENTRY_CONCERTIZING_823694797397139539)],
    ),
    (
        crate::EncodedStr::Ascii("concertist"),
        &[(0b00001, &ENTRY_CONCERTIST_12966623456893238257)],
    ),
    (
        crate::EncodedStr::Ascii("concertize"),
        &[(0b01001, &ENTRY_CONCERTIZE_12949550082462386391)],
    ),
    (
        crate::EncodedStr::Ascii("concertized"),
        &[(0b01001, &ENTRY_CONCERTIZED_13322827190564875313)],
    ),
    (
        crate::EncodedStr::Ascii("concertizer"),
        &[(0b01001, &ENTRY_CONCERTIZER_1607241334899378280)],
    ),
    (
        crate::EncodedStr::Ascii("concertizers"),
        &[(0b01001, &ENTRY_CONCERTIZERS_18408860231574633709)],
    ),
    (
        crate::EncodedStr::Ascii("concertizes"),
        &[(0b01001, &ENTRY_CONCERTIZES_11707521685205330713)],
    ),
    (
        crate::EncodedStr::Ascii("concertizing"),
        &[(0b01001, &ENTRY_CONCERTIZING_823694797397139539)],
    ),
    (
        crate::EncodedStr::Ascii("conchae"),
        &[(0b11010, &ENTRY_CONCHE_198313554269271817)],
    ),
    (
        crate::EncodedStr::Ascii("conche"),
        &[(0b00001, &ENTRY_CONCHE_198313554269271817)],
    ),
    (
        crate::EncodedStr::Ascii("concolor"),
        &[(0b00001, &ENTRY_CONCOLOR_17454478296536964945)],
    ),
    (
        crate::EncodedStr::Ascii("concolorous"),
        &[(0b00001, &ENTRY_CONCOLOROUS_3163909145039836280)],
    ),
    (
        crate::EncodedStr::Ascii("concolour"),
        &[(0b11010, &ENTRY_CONCOLOR_17454478296536964945)],
    ),
    (
        crate::EncodedStr::Ascii("concolourous"),
        &[(0b11010, &ENTRY_CONCOLOROUS_3163909145039836280)],
    ),
    (
        crate::EncodedStr::Ascii("concretisation"),
        &[(0b10010, &ENTRY_CONCRETIZATION_9902216531217228458)],
    ),
    (
        crate::EncodedStr::Ascii("concretisations"),
        &[(0b10010, &ENTRY_CONCRETIZATIONS_14806205502602655468)],
    ),
    (
        crate::EncodedStr::Ascii("concretise"),
        &[(0b10010, &ENTRY_CONCRETIZE_5573134973876025446)],
    ),
    (
        crate::EncodedStr::Ascii("concretised"),
        &[(0b10010, &ENTRY_CONCRETIZED_4880170111921035163)],
    ),
    (
        crate::EncodedStr::Ascii("concretises"),
        &[(0b10010, &ENTRY_CONCRETIZES_14141471054162706394)],
    ),
    (
        crate::EncodedStr::Ascii("concretising"),
        &[(0b10010, &ENTRY_CONCRETIZING_3165984632825616589)],
    ),
    (
        crate::EncodedStr::Ascii("concretist"),
        &[(0b11010, &ENTRY_CONCERTIST_12966623456893238257)],
    ),
    (
        crate::EncodedStr::Ascii("concretization"),
        &[(0b01001, &ENTRY_CONCRETIZATION_9902216531217228458)],
    ),
    (
        crate::EncodedStr::Ascii("concretizations"),
        &[(0b01001, &ENTRY_CONCRETIZATIONS_14806205502602655468)],
    ),
    (
        crate::EncodedStr::Ascii("concretize"),
        &[(0b01001, &ENTRY_CONCRETIZE_5573134973876025446)],
    ),
    (
        crate::EncodedStr::Ascii("concretized"),
        &[(0b01001, &ENTRY_CONCRETIZED_4880170111921035163)],
    ),
    (
        crate::EncodedStr::Ascii("concretizes"),
        &[(0b01001, &ENTRY_CONCRETIZES_14141471054162706394)],
    ),
    (
        crate::EncodedStr::Ascii("concretizing"),
        &[(0b01001, &ENTRY_CONCRETIZING_3165984632825616589)],
    ),
    (
        crate::EncodedStr::Ascii("conditionalise"),
        &[(0b10010, &ENTRY_CONDITIONALIZE_17072508968306397240)],
    ),
    (
        crate::EncodedStr::Ascii("conditionalises"),
        &[(0b10010, &ENTRY_CONDITIONALIZES_15570057258703829423)],
    ),
    (
        crate::EncodedStr::Ascii("conditionalize"),
        &[(0b01001, &ENTRY_CONDITIONALIZE_17072508968306397240)],
    ),
    (
        crate::EncodedStr::Ascii("conditionalizes"),
        &[(0b01001, &ENTRY_CONDITIONALIZES_15570057258703829423)],
    ),
    (
        crate::EncodedStr::Ascii("confederatise"),
        &[(0b10010, &ENTRY_CONFEDERATIZE_6554466446788291559)],
    ),
    (
        crate::EncodedStr::Ascii("confederatises"),
        &[(0b10010, &ENTRY_CONFEDERATIZES_13632434106090755943)],
    ),
    (
        crate::EncodedStr::Ascii("confederatize"),
        &[(0b01001, &ENTRY_CONFEDERATIZE_6554466446788291559)],
    ),
    (
        crate::EncodedStr::Ascii("confederatizes"),
        &[(0b01001, &ENTRY_CONFEDERATIZES_13632434106090755943)],
    ),
    (
        crate::EncodedStr::Ascii("congenialise"),
        &[(0b10010, &ENTRY_CONGENIALIZE_1800526471228574085)],
    ),
    (
        crate::EncodedStr::Ascii("congenialises"),
        &[(0b10010, &ENTRY_CONGENIALIZES_1415068390337769577)],
    ),
    (
        crate::EncodedStr::Ascii("congenialize"),
        &[(0b01001, &ENTRY_CONGENIALIZE_1800526471228574085)],
    ),
    (
        crate::EncodedStr::Ascii("congenializes"),
        &[(0b01001, &ENTRY_CONGENIALIZES_1415068390337769577)],
    ),
    (
        crate::EncodedStr::Ascii("conges"),
        &[(0b00001, &ENTRY_CONGES_13755371658333708467)],
    ),
    (
        crate::EncodedStr::Ascii("congoes"),
        &[(0b11010, &ENTRY_CONGES_13755371658333708467)],
    ),
    (
        crate::EncodedStr::Ascii("congregationalise"),
        &[(0b10010, &ENTRY_CONGREGATIONALIZE_9819463413052527180)],
    ),
    (
        crate::EncodedStr::Ascii("congregationalises"),
        &[(0b10010, &ENTRY_CONGREGATIONALIZES_3694181040722978196)],
    ),
    (
        crate::EncodedStr::Ascii("congregationalize"),
        &[(0b01001, &ENTRY_CONGREGATIONALIZE_9819463413052527180)],
    ),
    (
        crate::EncodedStr::Ascii("congregationalizes"),
        &[(0b01001, &ENTRY_CONGREGATIONALIZES_3694181040722978196)],
    ),
    (
        crate::EncodedStr::Ascii("connecter"),
        &[(0b00001, &ENTRY_CONNECTOR_16799434896865993625)],
    ),
    (
        crate::EncodedStr::Ascii("connecters"),
        &[(0b00001, &ENTRY_CONNECTORS_2322332520801589759)],
    ),
    (
        crate::EncodedStr::Ascii("connectible"),
        &[(0b00001, &ENTRY_CONNECTABLE_4141190038522560448)],
    ),
    (
        crate::EncodedStr::Ascii("connexion"),
        &[(0b10010, &ENTRY_CONNECTION_3596008768342696520)],
    ),
    (
        crate::EncodedStr::Ascii("connexions"),
        &[(0b10010, &ENTRY_CONNECTIONS_4180526765108060503)],
    ),
    (
        crate::EncodedStr::Ascii("conservatise"),
        &[(0b10010, &ENTRY_CONSERVATIZE_2070475109159374656)],
    ),
    (
        crate::EncodedStr::Ascii("conservatised"),
        &[(0b10010, &ENTRY_CONSERVATIZED_8955764860788295695)],
    ),
    (
        crate::EncodedStr::Ascii("conservatises"),
        &[(0b10010, &ENTRY_CONSERVATIZES_6230909821260907845)],
    ),
    (
        crate::EncodedStr::Ascii("conservatising"),
        &[(0b10010, &ENTRY_CONSERVATIZING_3183413058245669100)],
    ),
    (
        crate::EncodedStr::Ascii("conservatize"),
        &[(0b01001, &ENTRY_CONSERVATIZE_2070475109159374656)],
    ),
    (
        crate::EncodedStr::Ascii("conservatized"),
        &[(0b01001, &ENTRY_CONSERVATIZED_8955764860788295695)],
    ),
    (
        crate::EncodedStr::Ascii("conservatizes"),
        &[(0b01001, &ENTRY_CONSERVATIZES_6230909821260907845)],
    ),
    (
        crate::EncodedStr::Ascii("conservatizing"),
        &[(0b01001, &ENTRY_CONSERVATIZING_3183413058245669100)],
    ),
    (
        crate::EncodedStr::Ascii("consonantise"),
        &[(0b10010, &ENTRY_CONSONANTIZE_7643805442006694940)],
    ),
    (
        crate::EncodedStr::Ascii("consonantised"),
        &[(0b10010, &ENTRY_CONSONANTIZED_17873071838789420092)],
    ),
    (
        crate::EncodedStr::Ascii("consonantises"),
        &[(0b10010, &ENTRY_CONSONANTIZES_1574898332026499098)],
    ),
    (
        crate::EncodedStr::Ascii("consonantising"),
        &[(0b10010, &ENTRY_CONSONANTIZING_13097410576135380735)],
    ),
    (
        crate::EncodedStr::Ascii("consonantize"),
        &[(0b01001, &ENTRY_CONSONANTIZE_7643805442006694940)],
    ),
    (
        crate::EncodedStr::Ascii("consonantized"),
        &[(0b01001, &ENTRY_CONSONANTIZED_17873071838789420092)],
    ),
    (
        crate::EncodedStr::Ascii("consonantizes"),
        &[(0b01001, &ENTRY_CONSONANTIZES_1574898332026499098)],
    ),
    (
        crate::EncodedStr::Ascii("consonantizing"),
        &[(0b01001, &ENTRY_CONSONANTIZING_13097410576135380735)],
    ),
    (
        crate::EncodedStr::Ascii("constitutionalisation"),
        &[(0b10010, &ENTRY_CONSTITUTIONALIZATION_15784223903500663882)],
    ),
    (
        crate::EncodedStr::Ascii("constitutionalisations"),
        &[(0b10010, &ENTRY_CONSTITUTIONALIZATIONS_3173298060249661811)],
    ),
    (
        crate::EncodedStr::Ascii("constitutionalise"),
        &[(0b10010, &ENTRY_CONSTITUTIONALIZE_4750305806592443640)],
    ),
    (
        crate::EncodedStr::Ascii("constitutionalised"),
        &[(0b10010, &ENTRY_CONSTITUTIONALIZED_9394750460084858253)],
    ),
    (
        crate::EncodedStr::Ascii("constitutionalises"),
        &[(0b10010, &ENTRY_CONSTITUTIONALIZES_6011502541057503677)],
    ),
    (
        crate::EncodedStr::Ascii("constitutionalising"),
        &[(0b10010, &ENTRY_CONSTITUTIONALIZING_15920645894132149057)],
    ),
    (
        crate::EncodedStr::Ascii("constitutionalization"),
        &[(0b01001, &ENTRY_CONSTITUTIONALIZATION_15784223903500663882)],
    ),
    (
        crate::EncodedStr::Ascii("constitutionalizations"),
        &[(0b01001, &ENTRY_CONSTITUTIONALIZATIONS_3173298060249661811)],
    ),
    (
        crate::EncodedStr::Ascii("constitutionalize"),
        &[(0b01001, &ENTRY_CONSTITUTIONALIZE_4750305806592443640)],
    ),
    (
        crate::EncodedStr::Ascii("constitutionalized"),
        &[(0b01001, &ENTRY_CONSTITUTIONALIZED_9394750460084858253)],
    ),
    (
        crate::EncodedStr::Ascii("constitutionalizes"),
        &[(0b01001, &ENTRY_CONSTITUTIONALIZES_6011502541057503677)],
    ),
    (
        crate::EncodedStr::Ascii("constitutionalizing"),
        &[(0b01001, &ENTRY_CONSTITUTIONALIZING_15920645894132149057)],
    ),
    (
        crate::EncodedStr::Ascii("containerisation"),
        &[(0b10010, &ENTRY_CONTAINERIZATION_5740732325462062174)],
    ),
    (
        crate::EncodedStr::Ascii("containerisations"),
        &[(0b10010, &ENTRY_CONTAINERIZATIONS_4036516080513202324)],
    ),
    (
        crate::EncodedStr::Ascii("containerise"),
        &[(0b10010, &ENTRY_CONTAINERIZE_17609445608339490283)],
    ),
    (
        crate::EncodedStr::Ascii("containerised"),
        &[(0b10010, &ENTRY_CONTAINERIZED_11029791807154416517)],
    ),
    (
        crate::EncodedStr::Ascii("containerises"),
        &[(0b10010, &ENTRY_CONTAINERIZES_5244588712773306715)],
    ),
    (
        crate::EncodedStr::Ascii("containerising"),
        &[(0b10010, &ENTRY_CONTAINERIZING_9054115922997640811)],
    ),
    (
        crate::EncodedStr::Ascii("containerization"),
        &[(0b01001, &ENTRY_CONTAINERIZATION_5740732325462062174)],
    ),
    (
        crate::EncodedStr::Ascii("containerizations"),
        &[(0b01001, &ENTRY_CONTAINERIZATIONS_4036516080513202324)],
    ),
    (
        crate::EncodedStr::Ascii("containerize"),
        &[(0b01001, &ENTRY_CONTAINERIZE_17609445608339490283)],
    ),
    (
        crate::EncodedStr::Ascii("containerized"),
        &[(0b01001, &ENTRY_CONTAINERIZED_11029791807154416517)],
    ),
    (
        crate::EncodedStr::Ascii("containerizes"),
        &[(0b01001, &ENTRY_CONTAINERIZES_5244588712773306715)],
    ),
    (
        crate::EncodedStr::Ascii("containerizing"),
        &[(0b01001, &ENTRY_CONTAINERIZING_9054115922997640811)],
    ),
    (
        crate::EncodedStr::Ascii("contemporisation"),
        &[(0b10010, &ENTRY_CONTEMPORIZATION_16780108593197095593)],
    ),
    (
        crate::EncodedStr::Ascii("contemporise"),
        &[(0b10010, &ENTRY_CONTEMPORIZE_5008428677635696983)],
    ),
    (
        crate::EncodedStr::Ascii("contemporised"),
        &[(0b10010, &ENTRY_CONTEMPORIZED_3426415243352581168)],
    ),
    (
        crate::EncodedStr::Ascii("contemporises"),
        &[(0b10010, &ENTRY_CONTEMPORIZES_2967807069359802216)],
    ),
    (
        crate::EncodedStr::Ascii("contemporising"),
        &[(0b10010, &ENTRY_CONTEMPORIZING_6045892075236219913)],
    ),
    (
        crate::EncodedStr::Ascii("contemporization"),
        &[(0b01001, &ENTRY_CONTEMPORIZATION_16780108593197095593)],
    ),
    (
        crate::EncodedStr::Ascii("contemporize"),
        &[(0b01001, &ENTRY_CONTEMPORIZE_5008428677635696983)],
    ),
    (
        crate::EncodedStr::Ascii("contemporized"),
        &[(0b01001, &ENTRY_CONTEMPORIZED_3426415243352581168)],
    ),
    (
        crate::EncodedStr::Ascii("contemporizes"),
        &[(0b01001, &ENTRY_CONTEMPORIZES_2967807069359802216)],
    ),
    (
        crate::EncodedStr::Ascii("contemporizing"),
        &[(0b01001, &ENTRY_CONTEMPORIZING_6045892075236219913)],
    ),
    (
        crate::EncodedStr::Ascii("contextualisation"),
        &[(0b10010, &ENTRY_CONTEXTUALIZATION_6940693679263259371)],
    ),
    (
        crate::EncodedStr::Ascii("contextualisations"),
        &[(0b10010, &ENTRY_CONTEXTUALIZATIONS_18105932896496599445)],
    ),
    (
        crate::EncodedStr::Ascii("contextualise"),
        &[(0b10010, &ENTRY_CONTEXTUALIZE_4584369818380473712)],
    ),
    (
        crate::EncodedStr::Ascii("contextualised"),
        &[(0b10010, &ENTRY_CONTEXTUALIZED_6300908248792062084)],
    ),
    (
        crate::EncodedStr::Ascii("contextualises"),
        &[(0b10010, &ENTRY_CONTEXTUALIZES_12529336508087690726)],
    ),
    (
        crate::EncodedStr::Ascii("contextualising"),
        &[(0b10010, &ENTRY_CONTEXTUALIZING_7461111452640045211)],
    ),
    (
        crate::EncodedStr::Ascii("contextualization"),
        &[(0b01001, &ENTRY_CONTEXTUALIZATION_6940693679263259371)],
    ),
    (
        crate::EncodedStr::Ascii("contextualizations"),
        &[(0b01001, &ENTRY_CONTEXTUALIZATIONS_18105932896496599445)],
    ),
    (
        crate::EncodedStr::Ascii("contextualize"),
        &[(0b01001, &ENTRY_CONTEXTUALIZE_4584369818380473712)],
    ),
    (
        crate::EncodedStr::Ascii("contextualized"),
        &[(0b01001, &ENTRY_CONTEXTUALIZED_6300908248792062084)],
    ),
    (
        crate::EncodedStr::Ascii("contextualizes"),
        &[(0b01001, &ENTRY_CONTEXTUALIZES_12529336508087690726)],
    ),
    (
        crate::EncodedStr::Ascii("contextualizing"),
        &[(0b01001, &ENTRY_CONTEXTUALIZING_7461111452640045211)],
    ),
    (
        crate::EncodedStr::Ascii("continentalise"),
        &[(0b10010, &ENTRY_CONTINENTALIZE_15476635658600406518)],
    ),
    (
        crate::EncodedStr::Ascii("continentalises"),
        &[(0b10010, &ENTRY_CONTINENTALIZES_6196002065058300897)],
    ),
    (
        crate::EncodedStr::Ascii("continentalize"),
        &[(0b01001, &ENTRY_CONTINENTALIZE_15476635658600406518)],
    ),
    (
        crate::EncodedStr::Ascii("continentalizes"),
        &[(0b01001, &ENTRY_CONTINENTALIZES_6196002065058300897)],
    ),
    (
        crate::EncodedStr::Ascii("controversialise"),
        &[(0b10010, &ENTRY_CONTROVERSIALIZE_3063821365593875585)],
    ),
    (
        crate::EncodedStr::Ascii("controversialises"),
        &[(0b10010, &ENTRY_CONTROVERSIALIZES_7981611622332565361)],
    ),
    (
        crate::EncodedStr::Ascii("controversialize"),
        &[(0b01001, &ENTRY_CONTROVERSIALIZE_3063821365593875585)],
    ),
    (
        crate::EncodedStr::Ascii("controversializes"),
        &[(0b01001, &ENTRY_CONTROVERSIALIZES_7981611622332565361)],
    ),
    (
        crate::EncodedStr::Ascii("conundrumise"),
        &[(0b10010, &ENTRY_CONUNDRUMIZE_12213997648480363330)],
    ),
    (
        crate::EncodedStr::Ascii("conundrumises"),
        &[(0b10010, &ENTRY_CONUNDRUMIZES_7982003424972698355)],
    ),
    (
        crate::EncodedStr::Ascii("conundrumize"),
        &[(0b01001, &ENTRY_CONUNDRUMIZE_12213997648480363330)],
    ),
    (
        crate::EncodedStr::Ascii("conundrumizes"),
        &[(0b01001, &ENTRY_CONUNDRUMIZES_7982003424972698355)],
    ),
    (
        crate::EncodedStr::Ascii("conventionalisation"),
        &[(0b10010, &ENTRY_CONVENTIONALIZATION_13028625690092222465)],
    ),
    (
        crate::EncodedStr::Ascii("conventionalisations"),
        &[(0b10010, &ENTRY_CONVENTIONALIZATIONS_16276682879105179823)],
    ),
    (
        crate::EncodedStr::Ascii("conventionalise"),
        &[(0b10010, &ENTRY_CONVENTIONALIZE_5523697518996561640)],
    ),
    (
        crate::EncodedStr::Ascii("conventionalised"),
        &[(0b10010, &ENTRY_CONVENTIONALIZED_12965553780389351275)],
    ),
    (
        crate::EncodedStr::Ascii("conventionalises"),
        &[(0b10010, &ENTRY_CONVENTIONALIZES_9272151990564007911)],
    ),
    (
        crate::EncodedStr::Ascii("conventionalising"),
        &[(0b10010, &ENTRY_CONVENTIONALIZING_8403911928878303814)],
    ),
    (
        crate::EncodedStr::Ascii("conventionalization"),
        &[(0b01001, &ENTRY_CONVENTIONALIZATION_13028625690092222465)],
    ),
    (
        crate::EncodedStr::Ascii("conventionalizations"),
        &[(0b01001, &ENTRY_CONVENTIONALIZATIONS_16276682879105179823)],
    ),
    (
        crate::EncodedStr::Ascii("conventionalize"),
        &[(0b01001, &ENTRY_CONVENTIONALIZE_5523697518996561640)],
    ),
    (
        crate::EncodedStr::Ascii("conventionalized"),
        &[(0b01001, &ENTRY_CONVENTIONALIZED_12965553780389351275)],
    ),
    (
        crate::EncodedStr::Ascii("conventionalizes"),
        &[(0b01001, &ENTRY_CONVENTIONALIZES_9272151990564007911)],
    ),
    (
        crate::EncodedStr::Ascii("conventionalizing"),
        &[(0b01001, &ENTRY_CONVENTIONALIZING_8403911928878303814)],
    ),
    (
        crate::EncodedStr::Ascii("conventionise"),
        &[(0b10010, &ENTRY_CONVENTIONIZE_10105849898246202377)],
    ),
    (
        crate::EncodedStr::Ascii("conventionises"),
        &[(0b10010, &ENTRY_CONVENTIONIZES_5985365324069048956)],
    ),
    (
        crate::EncodedStr::Ascii("conventionize"),
        &[(0b01001, &ENTRY_CONVENTIONIZE_10105849898246202377)],
    ),
    (
        crate::EncodedStr::Ascii("conventionizes"),
        &[(0b01001, &ENTRY_CONVENTIONIZES_5985365324069048956)],
    ),
    (
        crate::EncodedStr::Ascii("conversationise"),
        &[(0b10010, &ENTRY_CONVERSATIONIZE_5100069228660462527)],
    ),
    (
        crate::EncodedStr::Ascii("conversationises"),
        &[(0b10010, &ENTRY_CONVERSATIONIZES_17870350526921946834)],
    ),
    (
        crate::EncodedStr::Ascii("conversationize"),
        &[(0b01001, &ENTRY_CONVERSATIONIZE_5100069228660462527)],
    ),
    (
        crate::EncodedStr::Ascii("conversationizes"),
        &[(0b01001, &ENTRY_CONVERSATIONIZES_17870350526921946834)],
    ),
    (
        crate::EncodedStr::Ascii("convertor"),
        &[
            (0b10010, &ENTRY_CONVERTER_1832376138567767596),
            (0b10011, &ENTRY_CONVERTER_5031978836001352470),
        ],
    ),
    (
        crate::EncodedStr::Ascii("convertors"),
        &[
            (0b10010, &ENTRY_CONVERTERS_3839419135582169647),
            (0b10011, &ENTRY_CONVERTERS_5331070164538082909),
        ],
    ),
    (
        crate::EncodedStr::Ascii("conveyorise"),
        &[(0b10010, &ENTRY_CONVEYORIZE_13627331458498794547)],
    ),
    (
        crate::EncodedStr::Ascii("conveyorised"),
        &[(0b10010, &ENTRY_CONVEYORIZED_1550738673068217452)],
    ),
    (
        crate::EncodedStr::Ascii("conveyorises"),
        &[(0b10010, &ENTRY_CONVEYORIZES_5699299181152546893)],
    ),
    (
        crate::EncodedStr::Ascii("conveyorising"),
        &[(0b10010, &ENTRY_CONVEYORIZING_12428816853490274627)],
    ),
    (
        crate::EncodedStr::Ascii("conveyorize"),
        &[(0b01001, &ENTRY_CONVEYORIZE_13627331458498794547)],
    ),
    (
        crate::EncodedStr::Ascii("conveyorized"),
        &[(0b01001, &ENTRY_CONVEYORIZED_1550738673068217452)],
    ),
    (
        crate::EncodedStr::Ascii("conveyorizes"),
        &[(0b01001, &ENTRY_CONVEYORIZES_5699299181152546893)],
    ),
    (
        crate::EncodedStr::Ascii("conveyorizing"),
        &[(0b01001, &ENTRY_CONVEYORIZING_12428816853490274627)],
    ),
    (
        crate::EncodedStr::Ascii("convivialise"),
        &[(0b10010, &ENTRY_CONVIVIALIZE_12861322270762809887)],
    ),
    (
        crate::EncodedStr::Ascii("convivialises"),
        &[(0b10010, &ENTRY_CONVIVIALIZES_14081286682414244239)],
    ),
    (
        crate::EncodedStr::Ascii("convivialize"),
        &[(0b01001, &ENTRY_CONVIVIALIZE_12861322270762809887)],
    ),
    (
        crate::EncodedStr::Ascii("convivializes"),
        &[(0b01001, &ENTRY_CONVIVIALIZES_14081286682414244239)],
    ),
    (
        crate::EncodedStr::Ascii("cooe"),
        &[(0b11010, &ENTRY_COE_10755603025154058571)],
    ),
    (
        crate::EncodedStr::Ascii("cooky"),
        &[(0b00001, &ENTRY_COOKIE_7907860379600479031)],
    ),
    (
        crate::EncodedStr::Ascii("copolymerisation"),
        &[(0b10010, &ENTRY_COPOLYMERIZATION_3565686431310114577)],
    ),
    (
        crate::EncodedStr::Ascii("copolymerisations"),
        &[(0b10010, &ENTRY_COPOLYMERIZATIONS_5973914645684635)],
    ),
    (
        crate::EncodedStr::Ascii("copolymerise"),
        &[(0b10010, &ENTRY_COPOLYMERIZE_4215053249879524882)],
    ),
    (
        crate::EncodedStr::Ascii("copolymerised"),
        &[(0b10010, &ENTRY_COPOLYMERIZED_17760814634904159372)],
    ),
    (
        crate::EncodedStr::Ascii("copolymerises"),
        &[(0b10010, &ENTRY_COPOLYMERIZES_13350833418414627371)],
    ),
    (
        crate::EncodedStr::Ascii("copolymerising"),
        &[(0b10010, &ENTRY_COPOLYMERIZING_322624390484211449)],
    ),
    (
        crate::EncodedStr::Ascii("copolymerization"),
        &[(0b01001, &ENTRY_COPOLYMERIZATION_3565686431310114577)],
    ),
    (
        crate::EncodedStr::Ascii("copolymerizations"),
        &[(0b01001, &ENTRY_COPOLYMERIZATIONS_5973914645684635)],
    ),
    (
        crate::EncodedStr::Ascii("copolymerize"),
        &[(0b01001, &ENTRY_COPOLYMERIZE_4215053249879524882)],
    ),
    (
        crate::EncodedStr::Ascii("copolymerized"),
        &[(0b01001, &ENTRY_COPOLYMERIZED_17760814634904159372)],
    ),
    (
        crate::EncodedStr::Ascii("copolymerizes"),
        &[(0b01001, &ENTRY_COPOLYMERIZES_13350833418414627371)],
    ),
    (
        crate::EncodedStr::Ascii("copolymerizing"),
        &[(0b01001, &ENTRY_COPOLYMERIZING_322624390484211449)],
    ),
    (
        crate::EncodedStr::Ascii("copperisation"),
        &[(0b10010, &ENTRY_COPPERIZATION_964826321420421086)],
    ),
    (
        crate::EncodedStr::Ascii("copperisations"),
        &[(0b10010, &ENTRY_COPPERIZATIONS_6621746123672599508)],
    ),
    (
        crate::EncodedStr::Ascii("copperise"),
        &[(0b10010, &ENTRY_COPPERIZE_8585777073067773483)],
    ),
    (
        crate::EncodedStr::Ascii("copperises"),
        &[(0b10010, &ENTRY_COPPERIZES_11565506510531680556)],
    ),
    (
        crate::EncodedStr::Ascii("copperization"),
        &[(0b01001, &ENTRY_COPPERIZATION_964826321420421086)],
    ),
    (
        crate::EncodedStr::Ascii("copperizations"),
        &[(0b01001, &ENTRY_COPPERIZATIONS_6621746123672599508)],
    ),
    (
        crate::EncodedStr::Ascii("copperize"),
        &[(0b01001, &ENTRY_COPPERIZE_8585777073067773483)],
    ),
    (
        crate::EncodedStr::Ascii("copperizes"),
        &[(0b01001, &ENTRY_COPPERIZES_11565506510531680556)],
    ),
    (
        crate::EncodedStr::Ascii("copraemia"),
        &[(0b11010, &ENTRY_COPREMIA_15716946293536237967)],
    ),
    (
        crate::EncodedStr::Ascii("copraemic"),
        &[(0b11010, &ENTRY_COPREMIC_330320805830628274)],
    ),
    (
        crate::EncodedStr::Ascii("copremia"),
        &[(0b10001, &ENTRY_COPREMIA_15716946293536237967)],
    ),
    (
        crate::EncodedStr::Ascii("copremic"),
        &[(0b10001, &ENTRY_COPREMIC_330320805830628274)],
    ),
    (
        crate::EncodedStr::Ascii("coraled"),
        &[(0b00001, &ENTRY_CORALED_17029032369203888932)],
    ),
    (
        crate::EncodedStr::Ascii("coralled"),
        &[(0b11010, &ENTRY_CORALED_17029032369203888932)],
    ),
    (
        crate::EncodedStr::Ascii("coranto"),
        &[(0b00001, &ENTRY_CORANTO_4279134034163662809)],
    ),
    (
        crate::EncodedStr::Ascii("corantoes"),
        &[(0b00001, &ENTRY_CORANTOES_3187574316281975902)],
    ),
    (
        crate::EncodedStr::Ascii("corantos"),
        &[(0b00001, &ENTRY_CORANTOS_4303750137767317450)],
    ),
    (
        crate::EncodedStr::Ascii("corbe"),
        &[(0b00001, &ENTRY_CORBE_17730991887414349664)],
    ),
    (
        crate::EncodedStr::Ascii("corbed"),
        &[(0b00001, &ENTRY_CORBED_3736423820408057899)],
    ),
    (
        crate::EncodedStr::Ascii("corbeled"),
        &[(0b00001, &ENTRY_CORBELED_6042612068469726728)],
    ),
    (
        crate::EncodedStr::Ascii("corbeling"),
        &[(0b00001, &ENTRY_CORBELING_17424209206512192853)],
    ),
    (
        crate::EncodedStr::Ascii("corbelings"),
        &[(0b00001, &ENTRY_CORBELINGS_3564173093504722553)],
    ),
    (
        crate::EncodedStr::Ascii("corbelled"),
        &[(0b11010, &ENTRY_CORBELED_6042612068469726728)],
    ),
    (
        crate::EncodedStr::Ascii("corbelling"),
        &[(0b11010, &ENTRY_CORBELING_17424209206512192853)],
    ),
    (
        crate::EncodedStr::Ascii("corbellings"),
        &[(0b11010, &ENTRY_CORBELINGS_3564173093504722553)],
    ),
    (
        crate::EncodedStr::Ascii("cordialise"),
        &[(0b10010, &ENTRY_CORDIALIZE_18283820928702090126)],
    ),
    (
        crate::EncodedStr::Ascii("cordialised"),
        &[(0b10010, &ENTRY_CORDIALIZED_17060566600018841931)],
    ),
    (
        crate::EncodedStr::Ascii("cordialises"),
        &[(0b10010, &ENTRY_CORDIALIZES_15225222580021745806)],
    ),
    (
        crate::EncodedStr::Ascii("cordialising"),
        &[(0b10010, &ENTRY_CORDIALIZING_16322807405354472673)],
    ),
    (
        crate::EncodedStr::Ascii("cordialize"),
        &[(0b01001, &ENTRY_CORDIALIZE_18283820928702090126)],
    ),
    (
        crate::EncodedStr::Ascii("cordialized"),
        &[(0b01001, &ENTRY_CORDIALIZED_17060566600018841931)],
    ),
    (
        crate::EncodedStr::Ascii("cordializes"),
        &[(0b01001, &ENTRY_CORDIALIZES_15225222580021745806)],
    ),
    (
        crate::EncodedStr::Ascii("cordializing"),
        &[(0b01001, &ENTRY_CORDIALIZING_16322807405354472673)],
    ),
    (
        crate::EncodedStr::Ascii("corge"),
        &[(0b00001, &ENTRY_CORGE_17139623337126675741)],
    ),
    (
        crate::EncodedStr::Ascii("corinthianise"),
        &[(0b10010, &ENTRY_CORINTHIANIZE_15193202304262813823)],
    ),
    (
        crate::EncodedStr::Ascii("corinthianised"),
        &[(0b10010, &ENTRY_CORINTHIANIZED_3878556826042603473)],
    ),
    (
        crate::EncodedStr::Ascii("corinthianises"),
        &[(0b10010, &ENTRY_CORINTHIANIZES_15960209016441005021)],
    ),
    (
        crate::EncodedStr::Ascii("corinthianising"),
        &[(0b10010, &ENTRY_CORINTHIANIZING_5628303096329418476)],
    ),
    (
        crate::EncodedStr::Ascii("corinthianize"),
        &[(0b01001, &ENTRY_CORINTHIANIZE_15193202304262813823)],
    ),
    (
        crate::EncodedStr::Ascii("corinthianized"),
        &[(0b01001, &ENTRY_CORINTHIANIZED_3878556826042603473)],
    ),
    (
        crate::EncodedStr::Ascii("corinthianizes"),
        &[(0b01001, &ENTRY_CORINTHIANIZES_15960209016441005021)],
    ),
    (
        crate::EncodedStr::Ascii("corinthianizing"),
        &[(0b01001, &ENTRY_CORINTHIANIZING_5628303096329418476)],
    ),
    (
        crate::EncodedStr::Ascii("corporealisation"),
        &[(0b10010, &ENTRY_CORPOREALIZATION_13444603137664491535)],
    ),
    (
        crate::EncodedStr::Ascii("corporealisations"),
        &[(0b10010, &ENTRY_CORPOREALIZATIONS_13406569937168049681)],
    ),
    (
        crate::EncodedStr::Ascii("corporealise"),
        &[(0b10010, &ENTRY_CORPOREALIZE_15369417358773446090)],
    ),
    (
        crate::EncodedStr::Ascii("corporealised"),
        &[(0b10010, &ENTRY_CORPOREALIZED_12082854418069448893)],
    ),
    (
        crate::EncodedStr::Ascii("corporealises"),
        &[(0b10010, &ENTRY_CORPOREALIZES_13055328418208419278)],
    ),
    (
        crate::EncodedStr::Ascii("corporealising"),
        &[(0b10010, &ENTRY_CORPOREALIZING_3901751814264969100)],
    ),
    (
        crate::EncodedStr::Ascii("corporealization"),
        &[(0b01001, &ENTRY_CORPOREALIZATION_13444603137664491535)],
    ),
    (
        crate::EncodedStr::Ascii("corporealizations"),
        &[(0b01001, &ENTRY_CORPOREALIZATIONS_13406569937168049681)],
    ),
    (
        crate::EncodedStr::Ascii("corporealize"),
        &[(0b01001, &ENTRY_CORPOREALIZE_15369417358773446090)],
    ),
    (
        crate::EncodedStr::Ascii("corporealized"),
        &[(0b01001, &ENTRY_CORPOREALIZED_12082854418069448893)],
    ),
    (
        crate::EncodedStr::Ascii("corporealizes"),
        &[(0b01001, &ENTRY_CORPOREALIZES_13055328418208419278)],
    ),
    (
        crate::EncodedStr::Ascii("corporealizing"),
        &[(0b01001, &ENTRY_CORPOREALIZING_3901751814264969100)],
    ),
    (
        crate::EncodedStr::Ascii("corsy"),
        &[(0b00001, &ENTRY_CORSY_8397709613851582338)],
    ),
    (
        crate::EncodedStr::Ascii("cortage"),
        &[(0b00001, &ENTRY_CORTAGE_11582769904852791421)],
    ),
    (
        crate::EncodedStr::Ascii("cortin"),
        &[(0b00001, &ENTRY_CORTIN_6028563342284786375)],
    ),
    (
        crate::EncodedStr::Ascii("cortinae"),
        &[(0b11010, &ENTRY_CORTINE_13597620914405629291)],
    ),
    (
        crate::EncodedStr::Ascii("cortine"),
        &[(0b00001, &ENTRY_CORTINE_13597620914405629291)],
    ),
    (
        crate::EncodedStr::Ascii("corvae"),
        &[(0b11010, &ENTRY_CORVE_15600376709730904093)],
    ),
    (
        crate::EncodedStr::Ascii("corve"),
        &[(0b00001, &ENTRY_CORVE_15600376709730904093)],
    ),
    (
        crate::EncodedStr::Ascii("coryphae"),
        &[(0b11010, &ENTRY_CORYPHE_5310787045413936233)],
    ),
    (
        crate::EncodedStr::Ascii("coryphaes"),
        &[(0b11010, &ENTRY_CORYPHES_13646996028278890092)],
    ),
    (
        crate::EncodedStr::Ascii("coryphe"),
        &[(0b00001, &ENTRY_CORYPHE_5310787045413936233)],
    ),
    (
        crate::EncodedStr::Ascii("coryphes"),
        &[(0b00001, &ENTRY_CORYPHES_13646996028278890092)],
    ),
    (
        crate::EncodedStr::Ascii("cosied"),
        &[(0b11010, &ENTRY_COZIED_892102520341074320)],
    ),
    (
        crate::EncodedStr::Ascii("cosier"),
        &[(0b11010, &ENTRY_COZIER_16664560812994447871)],
    ),
    (
        crate::EncodedStr::Ascii("cosies"),
        &[(0b11010, &ENTRY_COZIES_14939999790619704585)],
    ),
    (
        crate::EncodedStr::Ascii("cosiest"),
        &[(0b11010, &ENTRY_COZIEST_2405878050968803482)],
    ),
    (
        crate::EncodedStr::Ascii("cosily"),
        &[(0b10010, &ENTRY_COZILY_12652080440015563463)],
    ),
    (
        crate::EncodedStr::Ascii("cosiness"),
        &[(0b10010, &ENTRY_COZINESS_4340402800488732549)],
    ),
    (
        crate::EncodedStr::Ascii("cosmeticise"),
        &[(0b10010, &ENTRY_COSMETICIZE_4510163316750805851)],
    ),
    (
        crate::EncodedStr::Ascii("cosmeticised"),
        &[(0b10010, &ENTRY_COSMETICIZED_13397803251483774269)],
    ),
    (
        crate::EncodedStr::Ascii("cosmeticises"),
        &[(0b10010, &ENTRY_COSMETICIZES_5573800526141905092)],
    ),
    (
        crate::EncodedStr::Ascii("cosmeticising"),
        &[(0b10010, &ENTRY_COSMETICIZING_4611837122081199790)],
    ),
    (
        crate::EncodedStr::Ascii("cosmeticize"),
        &[(0b01001, &ENTRY_COSMETICIZE_4510163316750805851)],
    ),
    (
        crate::EncodedStr::Ascii("cosmeticized"),
        &[(0b01001, &ENTRY_COSMETICIZED_13397803251483774269)],
    ),
    (
        crate::EncodedStr::Ascii("cosmeticizes"),
        &[(0b01001, &ENTRY_COSMETICIZES_5573800526141905092)],
    ),
    (
        crate::EncodedStr::Ascii("cosmeticizing"),
        &[(0b01001, &ENTRY_COSMETICIZING_4611837122081199790)],
    ),
    (
        crate::EncodedStr::Ascii("cosmopolitanisation"),
        &[(0b10010, &ENTRY_COSMOPOLITANIZATION_13712421328153787188)],
    ),
    (
        crate::EncodedStr::Ascii("cosmopolitanisations"),
        &[(0b10010, &ENTRY_COSMOPOLITANIZATIONS_17982550395466641141)],
    ),
    (
        crate::EncodedStr::Ascii("cosmopolitanise"),
        &[(0b10010, &ENTRY_COSMOPOLITANIZE_11591269984956762481)],
    ),
    (
        crate::EncodedStr::Ascii("cosmopolitanised"),
        &[(0b10010, &ENTRY_COSMOPOLITANIZED_15042192345530983967)],
    ),
    (
        crate::EncodedStr::Ascii("cosmopolitanises"),
        &[(0b10010, &ENTRY_COSMOPOLITANIZES_57296618879818157)],
    ),
    (
        crate::EncodedStr::Ascii("cosmopolitanising"),
        &[(0b10010, &ENTRY_COSMOPOLITANIZING_11804948920948531162)],
    ),
    (
        crate::EncodedStr::Ascii("cosmopolitanization"),
        &[(0b01001, &ENTRY_COSMOPOLITANIZATION_13712421328153787188)],
    ),
    (
        crate::EncodedStr::Ascii("cosmopolitanizations"),
        &[(0b01001, &ENTRY_COSMOPOLITANIZATIONS_17982550395466641141)],
    ),
    (
        crate::EncodedStr::Ascii("cosmopolitanize"),
        &[(0b01001, &ENTRY_COSMOPOLITANIZE_11591269984956762481)],
    ),
    (
        crate::EncodedStr::Ascii("cosmopolitanized"),
        &[(0b01001, &ENTRY_COSMOPOLITANIZED_15042192345530983967)],
    ),
    (
        crate::EncodedStr::Ascii("cosmopolitanizes"),
        &[(0b01001, &ENTRY_COSMOPOLITANIZES_57296618879818157)],
    ),
    (
        crate::EncodedStr::Ascii("cosmopolitanizing"),
        &[(0b01001, &ENTRY_COSMOPOLITANIZING_11804948920948531162)],
    ),
    (
        crate::EncodedStr::Ascii("cosplendor"),
        &[(0b10001, &ENTRY_COSPLENDOR_14307850165475070048)],
    ),
    (
        crate::EncodedStr::Ascii("cosplendour"),
        &[(0b11010, &ENTRY_COSPLENDOR_14307850165475070048)],
    ),
    (
        crate::EncodedStr::Ascii("costae"),
        &[(0b11010, &ENTRY_COSTE_1360786639006955600)],
    ),
    (
        crate::EncodedStr::Ascii("coste"),
        &[(0b00001, &ENTRY_COSTE_1360786639006955600)],
    ),
    (
        crate::EncodedStr::Ascii("costumier"),
        &[(0b00001, &ENTRY_COSTUMIER_4823477100121806221)],
    ),
    (
        crate::EncodedStr::Ascii("costumire"),
        &[(0b11010, &ENTRY_COSTUMIER_4823477100121806221)],
    ),
    (
        crate::EncodedStr::Ascii("cosy"),
        &[(0b11010, &ENTRY_COZY_16771377950900395846)],
    ),
    (
        crate::EncodedStr::Ascii("cosying"),
        &[(0b11010, &ENTRY_COZYING_8737786447759601632)],
    ),
    (
        crate::EncodedStr::Ascii("cottae"),
        &[(0b11010, &ENTRY_COTTE_13644830532086634992)],
    ),
    (
        crate::EncodedStr::Ascii("cotte"),
        &[(0b00001, &ENTRY_COTTE_13644830532086634992)],
    ),
    (
        crate::EncodedStr::Ascii("cottonisation"),
        &[(0b10010, &ENTRY_COTTONIZATION_3551122105294457662)],
    ),
    (
        crate::EncodedStr::Ascii("cottonisations"),
        &[(0b10010, &ENTRY_COTTONIZATIONS_17749803100676719261)],
    ),
    (
        crate::EncodedStr::Ascii("cottonise"),
        &[(0b10010, &ENTRY_COTTONIZE_937005096342491386)],
    ),
    (
        crate::EncodedStr::Ascii("cottonises"),
        &[(0b10010, &ENTRY_COTTONIZES_9008427680743356385)],
    ),
    (
        crate::EncodedStr::Ascii("cottonization"),
        &[(0b01001, &ENTRY_COTTONIZATION_3551122105294457662)],
    ),
    (
        crate::EncodedStr::Ascii("cottonizations"),
        &[(0b01001, &ENTRY_COTTONIZATIONS_17749803100676719261)],
    ),
    (
        crate::EncodedStr::Ascii("cottonize"),
        &[(0b01001, &ENTRY_COTTONIZE_937005096342491386)],
    ),
    (
        crate::EncodedStr::Ascii("cottonizes"),
        &[(0b01001, &ENTRY_COTTONIZES_9008427680743356385)],
    ),
    (
        crate::EncodedStr::Ascii("cotylae"),
        &[(0b11010, &ENTRY_COTYLE_942493646255101754)],
    ),
    (
        crate::EncodedStr::Ascii("cotyle"),
        &[(0b00001, &ENTRY_COTYLE_942493646255101754)],
    ),
    (
        crate::EncodedStr::Ascii("councillor"),
        &[(0b11010, &ENTRY_COUNCILOR_9008971708424749691)],
    ),
    (
        crate::EncodedStr::Ascii("councillors"),
        &[(0b11010, &ENTRY_COUNCILORS_10740681458284876699)],
    ),
    (
        crate::EncodedStr::Ascii("councillorship"),
        &[(0b11010, &ENTRY_COUNCILORSHIP_11271914097682866054)],
    ),
    (
        crate::EncodedStr::Ascii("councillorships"),
        &[(0b11010, &ENTRY_COUNCILORSHIPS_4030354772794301642)],
    ),
    (
        crate::EncodedStr::Ascii("councilor"),
        &[(0b00001, &ENTRY_COUNCILOR_9008971708424749691)],
    ),
    (
        crate::EncodedStr::Ascii("councilors"),
        &[(0b00001, &ENTRY_COUNCILORS_10740681458284876699)],
    ),
    (
        crate::EncodedStr::Ascii("councilorship"),
        &[(0b00001, &ENTRY_COUNCILORSHIP_11271914097682866054)],
    ),
    (
        crate::EncodedStr::Ascii("councilorships"),
        &[(0b00001, &ENTRY_COUNCILORSHIPS_4030354772794301642)],
    ),
    (
        crate::EncodedStr::Ascii("counseled"),
        &[(0b00001, &ENTRY_COUNSELED_16528360610427400796)],
    ),
    (
        crate::EncodedStr::Ascii("counselee"),
        &[(0b00001, &ENTRY_COUNSELEE_5928413848108470968)],
    ),
    (
        crate::EncodedStr::Ascii("counseling"),
        &[(0b00001, &ENTRY_COUNSELING_801410554831071578)],
    ),
    (
        crate::EncodedStr::Ascii("counselled"),
        &[(0b11010, &ENTRY_COUNSELED_16528360610427400796)],
    ),
    (
        crate::EncodedStr::Ascii("counsellee"),
        &[(0b11010, &ENTRY_COUNSELEE_5928413848108470968)],
    ),
    (
        crate::EncodedStr::Ascii("counselling"),
        &[(0b11010, &ENTRY_COUNSELING_801410554831071578)],
    ),
    (
        crate::EncodedStr::Ascii("counsellor"),
        &[(0b11010, &ENTRY_COUNSELOR_10543167328253513516)],
    ),
    (
        crate::EncodedStr::Ascii("counsellors"),
        &[(0b11010, &ENTRY_COUNSELORS_13992003748073450387)],
    ),
    (
        crate::EncodedStr::Ascii("counsellorship"),
        &[(0b11010, &ENTRY_COUNSELORSHIP_5288062081367197198)],
    ),
    (
        crate::EncodedStr::Ascii("counsellorships"),
        &[(0b11010, &ENTRY_COUNSELORSHIPS_7582354069010921169)],
    ),
    (
        crate::EncodedStr::Ascii("counselor"),
        &[(0b01001, &ENTRY_COUNSELOR_10543167328253513516)],
    ),
    (
        crate::EncodedStr::Ascii("counselors"),
        &[(0b01001, &ENTRY_COUNSELORS_13992003748073450387)],
    ),
    (
        crate::EncodedStr::Ascii("counselorship"),
        &[(0b00001, &ENTRY_COUNSELORSHIP_5288062081367197198)],
    ),
    (
        crate::EncodedStr::Ascii("counselorships"),
        &[(0b00001, &ENTRY_COUNSELORSHIPS_7582354069010921169)],
    ),
    (
        crate::EncodedStr::Ascii("countercolored"),
        &[(0b10001, &ENTRY_COUNTERCOLORED_4458254746746370067)],
    ),
    (
        crate::EncodedStr::Ascii("countercoloured"),
        &[(0b11010, &ENTRY_COUNTERCOLORED_4458254746746370067)],
    ),
    (
        crate::EncodedStr::Ascii("countor"),
        &[(0b00001, &ENTRY_COUNTOR_3612808841271391195)],
    ),
    (
        crate::EncodedStr::Ascii("countour"),
        &[(0b11010, &ENTRY_COUNTOR_3612808841271391195)],
    ),
    (
        crate::EncodedStr::Ascii("couranto"),
        &[(0b11010, &ENTRY_CORANTO_4279134034163662809)],
    ),
    (
        crate::EncodedStr::Ascii("courantoes"),
        &[(0b11010, &ENTRY_CORANTOES_3187574316281975902)],
    ),
    (
        crate::EncodedStr::Ascii("courantos"),
        &[(0b11010, &ENTRY_CORANTOS_4303750137767317450)],
    ),
    (
        crate::EncodedStr::Ascii("courbe"),
        &[(0b11010, &ENTRY_CORBE_17730991887414349664)],
    ),
    (
        crate::EncodedStr::Ascii("courbed"),
        &[(0b11010, &ENTRY_CORBED_3736423820408057899)],
    ),
    (
        crate::EncodedStr::Ascii("courge"),
        &[(0b11010, &ENTRY_CORGE_17139623337126675741)],
    ),
    (
        crate::EncodedStr::Ascii("coursy"),
        &[(0b11010, &ENTRY_CORSY_8397709613851582338)],
    ),
    (
        crate::EncodedStr::Ascii("courtage"),
        &[(0b11010, &ENTRY_CORTAGE_11582769904852791421)],
    ),
    (
        crate::EncodedStr::Ascii("courtin"),
        &[(0b11010, &ENTRY_CORTIN_6028563342284786375)],
    ),
    (
        crate::EncodedStr::Ascii("cozied"),
        &[(0b01001, &ENTRY_COZIED_892102520341074320)],
    ),
    (
        crate::EncodedStr::Ascii("cozier"),
        &[(0b01001, &ENTRY_COZIER_16664560812994447871)],
    ),
    (
        crate::EncodedStr::Ascii("cozies"),
        &[(0b01001, &ENTRY_COZIES_14939999790619704585)],
    ),
    (
        crate::EncodedStr::Ascii("coziest"),
        &[(0b01001, &ENTRY_COZIEST_2405878050968803482)],
    ),
    (
        crate::EncodedStr::Ascii("cozily"),
        &[(0b01001, &ENTRY_COZILY_12652080440015563463)],
    ),
    (
        crate::EncodedStr::Ascii("coziness"),
        &[(0b01001, &ENTRY_COZINESS_4340402800488732549)],
    ),
    (
        crate::EncodedStr::Ascii("cozy"),
        &[(0b01001, &ENTRY_COZY_16771377950900395846)],
    ),
    (
        crate::EncodedStr::Ascii("cozying"),
        &[(0b01001, &ENTRY_COZYING_8737786447759601632)],
    ),
    (
        crate::EncodedStr::Ascii("craisey"),
        &[(0b10010, &ENTRY_CRAIZEY_11207510142316496553)],
    ),
    (
        crate::EncodedStr::Ascii("craizey"),
        &[(0b01001, &ENTRY_CRAIZEY_11207510142316496553)],
    ),
    (
        crate::EncodedStr::Ascii("crambes"),
        &[(0b00001, &ENTRY_CRAMBES_5154618776124525704)],
    ),
    (
        crate::EncodedStr::Ascii("cramboes"),
        &[(0b11010, &ENTRY_CRAMBES_5154618776124525704)],
    ),
    (
        crate::EncodedStr::Ascii("crawlerise"),
        &[(0b10010, &ENTRY_CRAWLERIZE_812960636373413412)],
    ),
    (
        crate::EncodedStr::Ascii("crawlerises"),
        &[(0b10010, &ENTRY_CRAWLERIZES_13469653902313454380)],
    ),
    (
        crate::EncodedStr::Ascii("crawlerize"),
        &[(0b01001, &ENTRY_CRAWLERIZE_812960636373413412)],
    ),
    (
        crate::EncodedStr::Ascii("crawlerizes"),
        &[(0b01001, &ENTRY_CRAWLERIZES_13469653902313454380)],
    ),
    (
        crate::EncodedStr::Ascii("cre"),
        &[(0b11010, &ENTRY_CER_16898181025911443964)],
    ),
    (
        crate::EncodedStr::Ascii("crea"),
        &[(0b11010, &ENTRY_CERA_7059694773303335761)],
    ),
    (
        crate::EncodedStr::Ascii("creat"),
        &[(0b11010, &ENTRY_CERAT_1886332108569610985)],
    ),
    (
        crate::EncodedStr::Ascii("creatin"),
        &[(0b11010, &ENTRY_CERATIN_7844527544181435388)],
    ),
    (
        crate::EncodedStr::Ascii("creatins"),
        &[(0b11010, &ENTRY_CERATINS_7956220450419624429)],
    ),
    (
        crate::EncodedStr::Ascii("creaturise"),
        &[(0b10010, &ENTRY_CREATURIZE_11671782863777774169)],
    ),
    (
        crate::EncodedStr::Ascii("creaturises"),
        &[(0b10010, &ENTRY_CREATURIZES_11072091990116315598)],
    ),
    (
        crate::EncodedStr::Ascii("creaturize"),
        &[(0b01001, &ENTRY_CREATURIZE_11671782863777774169)],
    ),
    (
        crate::EncodedStr::Ascii("creaturizes"),
        &[(0b01001, &ENTRY_CREATURIZES_11072091990116315598)],
    ),
    (
        crate::EncodedStr::Ascii("cree"),
        &[(0b11010, &ENTRY_CERE_9821157149992437937)],
    ),
    (
        crate::EncodedStr::Ascii("crees"),
        &[(0b11010, &ENTRY_CERES_4278379745962029428)],
    ),
    (
        crate::EncodedStr::Ascii("crenellate"),
        &[(0b11010, &ENTRY_CRENELATE_4846628544233188866)],
    ),
    (
        crate::EncodedStr::Ascii("crenellated"),
        &[(0b11010, &ENTRY_CRENELATED_4747089085581062744)],
    ),
    (
        crate::EncodedStr::Ascii("crenellater"),
        &[(0b11010, &ENTRY_CRENELATER_17949792491463033916)],
    ),
    (
        crate::EncodedStr::Ascii("crenellates"),
        &[(0b11010, &ENTRY_CRENELATES_1558161520210179871)],
    ),
    (
        crate::EncodedStr::Ascii("crenellatest"),
        &[(0b11010, &ENTRY_CRENELATEST_4139190496016465578)],
    ),
    (
        crate::EncodedStr::Ascii("crenellating"),
        &[(0b11010, &ENTRY_CRENELATING_3475200518815041064)],
    ),
    (
        crate::EncodedStr::Ascii("crenellation"),
        &[(0b11010, &ENTRY_CRENELATION_1079785305940612588)],
    ),
    (
        crate::EncodedStr::Ascii("crenellations"),
        &[(0b11010, &ENTRY_CRENELATIONS_13269172105110545010)],
    ),
    (
        crate::EncodedStr::Ascii("crenelled"),
        &[(0b11010, &ENTRY_CRENELED_12587802714564552958)],
    ),
    (
        crate::EncodedStr::Ascii("crenelling"),
        &[(0b11010, &ENTRY_CRENELING_15994472673064843243)],
    ),
    (
        crate::EncodedStr::Ascii("creolisation"),
        &[(0b10010, &ENTRY_CREOLIZATION_2399026028067198251)],
    ),
    (
        crate::EncodedStr::Ascii("creolisations"),
        &[(0b10010, &ENTRY_CREOLIZATIONS_18438815551943447952)],
    ),
    (
        crate::EncodedStr::Ascii("creolise"),
        &[(0b10010, &ENTRY_CREOLIZE_5145685228179089111)],
    ),
    (
        crate::EncodedStr::Ascii("creolised"),
        &[(0b10010, &ENTRY_CREOLIZED_7643361883981250764)],
    ),
    (
        crate::EncodedStr::Ascii("creolises"),
        &[(0b10010, &ENTRY_CREOLIZES_3089367645000699437)],
    ),
    (
        crate::EncodedStr::Ascii("creolising"),
        &[(0b10010, &ENTRY_CREOLIZING_12140091392528441353)],
    ),
    (
        crate::EncodedStr::Ascii("creolite"),
        &[(0b11010, &ENTRY_CEROLITE_7632841335460717740)],
    ),
    (
        crate::EncodedStr::Ascii("creolization"),
        &[(0b01001, &ENTRY_CREOLIZATION_2399026028067198251)],
    ),
    (
        crate::EncodedStr::Ascii("creolizations"),
        &[(0b01001, &ENTRY_CREOLIZATIONS_18438815551943447952)],
    ),
    (
        crate::EncodedStr::Ascii("creolize"),
        &[(0b01001, &ENTRY_CREOLIZE_5145685228179089111)],
    ),
    (
        crate::EncodedStr::Ascii("creolized"),
        &[(0b01001, &ENTRY_CREOLIZED_7643361883981250764)],
    ),
    (
        crate::EncodedStr::Ascii("creolizes"),
        &[(0b01001, &ENTRY_CREOLIZES_3089367645000699437)],
    ),
    (
        crate::EncodedStr::Ascii("creolizing"),
        &[(0b01001, &ENTRY_CREOLIZING_12140091392528441353)],
    ),
    (
        crate::EncodedStr::Ascii("cretinisation"),
        &[(0b10010, &ENTRY_CRETINIZATION_9976126052462780936)],
    ),
    (
        crate::EncodedStr::Ascii("cretinisations"),
        &[(0b10010, &ENTRY_CRETINIZATIONS_8550950897045447908)],
    ),
    (
        crate::EncodedStr::Ascii("cretinise"),
        &[(0b10010, &ENTRY_CRETINIZE_567737549892855222)],
    ),
    (
        crate::EncodedStr::Ascii("cretinised"),
        &[(0b10010, &ENTRY_CRETINIZED_970325680379971482)],
    ),
    (
        crate::EncodedStr::Ascii("cretinises"),
        &[(0b10010, &ENTRY_CRETINIZES_15606980122166252360)],
    ),
    (
        crate::EncodedStr::Ascii("cretinising"),
        &[(0b10010, &ENTRY_CRETINIZING_10538665090855146969)],
    ),
    (
        crate::EncodedStr::Ascii("cretinization"),
        &[(0b01001, &ENTRY_CRETINIZATION_9976126052462780936)],
    ),
    (
        crate::EncodedStr::Ascii("cretinizations"),
        &[(0b01001, &ENTRY_CRETINIZATIONS_8550950897045447908)],
    ),
    (
        crate::EncodedStr::Ascii("cretinize"),
        &[(0b01001, &ENTRY_CRETINIZE_567737549892855222)],
    ),
    (
        crate::EncodedStr::Ascii("cretinized"),
        &[(0b01001, &ENTRY_CRETINIZED_970325680379971482)],
    ),
    (
        crate::EncodedStr::Ascii("cretinizes"),
        &[(0b01001, &ENTRY_CRETINIZES_15606980122166252360)],
    ),
    (
        crate::EncodedStr::Ascii("cretinizing"),
        &[(0b01001, &ENTRY_CRETINIZING_10538665090855146969)],
    ),
    (
        crate::EncodedStr::Ascii("criminalisation"),
        &[(0b10010, &ENTRY_CRIMINALIZATION_3737684511061545754)],
    ),
    (
        crate::EncodedStr::Ascii("criminalisations"),
        &[(0b10010, &ENTRY_CRIMINALIZATIONS_7033644149025759517)],
    ),
    (
        crate::EncodedStr::Ascii("criminalise"),
        &[(0b10010, &ENTRY_CRIMINALIZE_11153638088565284591)],
    ),
    (
        crate::EncodedStr::Ascii("criminalised"),
        &[(0b10010, &ENTRY_CRIMINALIZED_11203535063879460381)],
    ),
    (
        crate::EncodedStr::Ascii("criminalises"),
        &[(0b10010, &ENTRY_CRIMINALIZES_3410670484073252306)],
    ),
    (
        crate::EncodedStr::Ascii("criminalising"),
        &[(0b10010, &ENTRY_CRIMINALIZING_910154589421830415)],
    ),
    (
        crate::EncodedStr::Ascii("criminalization"),
        &[(0b01001, &ENTRY_CRIMINALIZATION_3737684511061545754)],
    ),
    (
        crate::EncodedStr::Ascii("criminalizations"),
        &[(0b01001, &ENTRY_CRIMINALIZATIONS_7033644149025759517)],
    ),
    (
        crate::EncodedStr::Ascii("criminalize"),
        &[(0b01001, &ENTRY_CRIMINALIZE_11153638088565284591)],
    ),
    (
        crate::EncodedStr::Ascii("criminalized"),
        &[(0b01001, &ENTRY_CRIMINALIZED_11203535063879460381)],
    ),
    (
        crate::EncodedStr::Ascii("criminalizes"),
        &[(0b01001, &ENTRY_CRIMINALIZES_3410670484073252306)],
    ),
    (
        crate::EncodedStr::Ascii("criminalizing"),
        &[(0b01001, &ENTRY_CRIMINALIZING_910154589421830415)],
    ),
    (
        crate::EncodedStr::Ascii("criticisable"),
        &[(0b10010, &ENTRY_CRITICIZABLE_11161073204477833540)],
    ),
    (
        crate::EncodedStr::Ascii("criticisabler"),
        &[(0b10010, &ENTRY_CRITICIZABLER_15788598655348442927)],
    ),
    (
        crate::EncodedStr::Ascii("criticisables"),
        &[(0b10010, &ENTRY_CRITICIZABLES_15336014985309704799)],
    ),
    (
        crate::EncodedStr::Ascii("criticisablest"),
        &[(0b10010, &ENTRY_CRITICIZABLEST_16577651845714565882)],
    ),
    (
        crate::EncodedStr::Ascii("criticise"),
        &[(0b10010, &ENTRY_CRITICIZE_6068870801343218661)],
    ),
    (
        crate::EncodedStr::Ascii("criticised"),
        &[(0b10010, &ENTRY_CRITICIZED_11062690254551858674)],
    ),
    (
        crate::EncodedStr::Ascii("criticiser"),
        &[(0b10010, &ENTRY_CRITICIZER_1957848661038883017)],
    ),
    (
        crate::EncodedStr::Ascii("criticisers"),
        &[(0b10010, &ENTRY_CRITICIZERS_1569351139366706310)],
    ),
    (
        crate::EncodedStr::Ascii("criticises"),
        &[(0b10010, &ENTRY_CRITICIZES_17213534894187218607)],
    ),
    (
        crate::EncodedStr::Ascii("criticising"),
        &[(0b10010, &ENTRY_CRITICIZING_721139847503188555)],
    ),
    (
        crate::EncodedStr::Ascii("criticisinglier"),
        &[(0b10010, &ENTRY_CRITICIZINGLIER_5644837899795371316)],
    ),
    (
        crate::EncodedStr::Ascii("criticisinglies"),
        &[(0b10010, &ENTRY_CRITICIZINGLIES_10873838484352102652)],
    ),
    (
        crate::EncodedStr::Ascii("criticisingliest"),
        &[(0b10010, &ENTRY_CRITICIZINGLIEST_16754553627614394252)],
    ),
    (
        crate::EncodedStr::Ascii("criticisingly"),
        &[(0b10010, &ENTRY_CRITICIZINGLY_17073704302947432967)],
    ),
    (
        crate::EncodedStr::Ascii("criticizable"),
        &[(0b01001, &ENTRY_CRITICIZABLE_11161073204477833540)],
    ),
    (
        crate::EncodedStr::Ascii("criticizabler"),
        &[(0b01001, &ENTRY_CRITICIZABLER_15788598655348442927)],
    ),
    (
        crate::EncodedStr::Ascii("criticizables"),
        &[(0b01001, &ENTRY_CRITICIZABLES_15336014985309704799)],
    ),
    (
        crate::EncodedStr::Ascii("criticizablest"),
        &[(0b01001, &ENTRY_CRITICIZABLEST_16577651845714565882)],
    ),
    (
        crate::EncodedStr::Ascii("criticize"),
        &[(0b01001, &ENTRY_CRITICIZE_6068870801343218661)],
    ),
    (
        crate::EncodedStr::Ascii("criticized"),
        &[(0b01001, &ENTRY_CRITICIZED_11062690254551858674)],
    ),
    (
        crate::EncodedStr::Ascii("criticizer"),
        &[(0b01001, &ENTRY_CRITICIZER_1957848661038883017)],
    ),
    (
        crate::EncodedStr::Ascii("criticizers"),
        &[(0b01001, &ENTRY_CRITICIZERS_1569351139366706310)],
    ),
    (
        crate::EncodedStr::Ascii("criticizes"),
        &[(0b01001, &ENTRY_CRITICIZES_17213534894187218607)],
    ),
    (
        crate::EncodedStr::Ascii("criticizing"),
        &[(0b01001, &ENTRY_CRITICIZING_721139847503188555)],
    ),
    (
        crate::EncodedStr::Ascii("criticizinglier"),
        &[(0b01001, &ENTRY_CRITICIZINGLIER_5644837899795371316)],
    ),
    (
        crate::EncodedStr::Ascii("criticizinglies"),
        &[(0b01001, &ENTRY_CRITICIZINGLIES_10873838484352102652)],
    ),
    (
        crate::EncodedStr::Ascii("criticizingliest"),
        &[(0b01001, &ENTRY_CRITICIZINGLIEST_16754553627614394252)],
    ),
    (
        crate::EncodedStr::Ascii("criticizingly"),
        &[(0b01001, &ENTRY_CRITICIZINGLY_17073704302947432967)],
    ),
    (
        crate::EncodedStr::Ascii("crofterisation"),
        &[(0b10010, &ENTRY_CROFTERIZATION_5035727674537403320)],
    ),
    (
        crate::EncodedStr::Ascii("crofterisations"),
        &[(0b10010, &ENTRY_CROFTERIZATIONS_16334682363476700656)],
    ),
    (
        crate::EncodedStr::Ascii("crofterise"),
        &[(0b10010, &ENTRY_CROFTERIZE_16982662599909303513)],
    ),
    (
        crate::EncodedStr::Ascii("crofterises"),
        &[(0b10010, &ENTRY_CROFTERIZES_11462100976556470416)],
    ),
    (
        crate::EncodedStr::Ascii("crofterization"),
        &[(0b01001, &ENTRY_CROFTERIZATION_5035727674537403320)],
    ),
    (
        crate::EncodedStr::Ascii("crofterizations"),
        &[(0b01001, &ENTRY_CROFTERIZATIONS_16334682363476700656)],
    ),
    (
        crate::EncodedStr::Ascii("crofterize"),
        &[(0b01001, &ENTRY_CROFTERIZE_16982662599909303513)],
    ),
    (
        crate::EncodedStr::Ascii("crofterizes"),
        &[(0b01001, &ENTRY_CROFTERIZES_11462100976556470416)],
    ),
    (
        crate::EncodedStr::Ascii("crueler"),
        &[(0b01001, &ENTRY_CRUELER_8850779393447007974)],
    ),
    (
        crate::EncodedStr::Ascii("cruelest"),
        &[(0b01001, &ENTRY_CRUELEST_9704800828794339180)],
    ),
    (
        crate::EncodedStr::Ascii("cruelise"),
        &[(0b10010, &ENTRY_CRUELIZE_1812841929360609104)],
    ),
    (
        crate::EncodedStr::Ascii("cruelises"),
        &[(0b10010, &ENTRY_CRUELIZES_5359533254509589966)],
    ),
    (
        crate::EncodedStr::Ascii("cruelize"),
        &[(0b01001, &ENTRY_CRUELIZE_1812841929360609104)],
    ),
    (
        crate::EncodedStr::Ascii("cruelizes"),
        &[(0b01001, &ENTRY_CRUELIZES_5359533254509589966)],
    ),
    (
        crate::EncodedStr::Ascii("crueller"),
        &[(0b11010, &ENTRY_CRUELER_8850779393447007974)],
    ),
    (
        crate::EncodedStr::Ascii("cruellest"),
        &[(0b11010, &ENTRY_CRUELEST_9704800828794339180)],
    ),
    (
        crate::EncodedStr::Ascii("cryaesthesia"),
        &[(0b11010, &ENTRY_CRYESTHESIA_5758775181330161574)],
    ),
    (
        crate::EncodedStr::Ascii("cryesthesia"),
        &[(0b10001, &ENTRY_CRYESTHESIA_5758775181330161574)],
    ),
    (
        crate::EncodedStr::Ascii("cryoanaesthesia"),
        &[(0b11010, &ENTRY_CRYOANESTHESIA_5659435164723717323)],
    ),
    (
        crate::EncodedStr::Ascii("cryoanesthesia"),
        &[(0b10001, &ENTRY_CRYOANESTHESIA_5659435164723717323)],
    ),
    (
        crate::EncodedStr::Ascii("cryptaesthesia"),
        &[(0b11010, &ENTRY_CRYPTESTHESIA_11957770407798142447)],
    ),
    (
        crate::EncodedStr::Ascii("cryptaesthesias"),
        &[(0b11010, &ENTRY_CRYPTESTHESIAS_13878578396343060203)],
    ),
    (
        crate::EncodedStr::Ascii("cryptaesthetic"),
        &[(0b11010, &ENTRY_CRYPTESTHETIC_6202935653821971765)],
    ),
    (
        crate::EncodedStr::Ascii("cryptanalyses"),
        &[(0b10010, &ENTRY_CRYPTANALYZES_8578659007864632505)],
    ),
    (
        crate::EncodedStr::Ascii("cryptanalyzes"),
        &[(0b01001, &ENTRY_CRYPTANALYZES_8578659007864632505)],
    ),
    (
        crate::EncodedStr::Ascii("cryptesthesia"),
        &[(0b10001, &ENTRY_CRYPTESTHESIA_11957770407798142447)],
    ),
    (
        crate::EncodedStr::Ascii("cryptesthesias"),
        &[(0b10001, &ENTRY_CRYPTESTHESIAS_13878578396343060203)],
    ),
    (
        crate::EncodedStr::Ascii("cryptesthetic"),
        &[(0b10001, &ENTRY_CRYPTESTHETIC_6202935653821971765)],
    ),
    (
        crate::EncodedStr::Ascii("crystalize"),
        &[(0b00001, &ENTRY_CRYSTALLIZE_16085680612819973763)],
    ),
    (
        crate::EncodedStr::Ascii("crystalized"),
        &[(0b00001, &ENTRY_CRYSTALLIZED_1190597515180481232)],
    ),
    (
        crate::EncodedStr::Ascii("crystalizes"),
        &[(0b00001, &ENTRY_CRYSTALLIZES_4917509722520652987)],
    ),
    (
        crate::EncodedStr::Ascii("crystalizing"),
        &[(0b00001, &ENTRY_CRYSTALLIZING_1947916141166292087)],
    ),
    (
        crate::EncodedStr::Ascii("crystallisabilities"),
        &[(0b10010, &ENTRY_CRYSTALLIZABILITIES_3954684427565379393)],
    ),
    (
        crate::EncodedStr::Ascii("crystallisability"),
        &[(0b10010, &ENTRY_CRYSTALLIZABILITY_417676650172898499)],
    ),
    (
        crate::EncodedStr::Ascii("crystallisable"),
        &[(0b10010, &ENTRY_CRYSTALLIZABLE_5487202742125994763)],
    ),
    (
        crate::EncodedStr::Ascii("crystallisabler"),
        &[(0b10010, &ENTRY_CRYSTALLIZABLER_14422860421659122029)],
    ),
    (
        crate::EncodedStr::Ascii("crystallisables"),
        &[(0b10010, &ENTRY_CRYSTALLIZABLES_13105784762937285967)],
    ),
    (
        crate::EncodedStr::Ascii("crystallisablest"),
        &[(0b10010, &ENTRY_CRYSTALLIZABLEST_11639541143335039276)],
    ),
    (
        crate::EncodedStr::Ascii("crystallisation"),
        &[(0b10010, &ENTRY_CRYSTALLIZATION_11917761263858890133)],
    ),
    (
        crate::EncodedStr::Ascii("crystallisations"),
        &[(0b10010, &ENTRY_CRYSTALLIZATIONS_8117698772064969073)],
    ),
    (
        crate::EncodedStr::Ascii("crystallise"),
        &[(0b10010, &ENTRY_CRYSTALLIZE_16085680612819973763)],
    ),
    (
        crate::EncodedStr::Ascii("crystallised"),
        &[(0b10010, &ENTRY_CRYSTALLIZED_1190597515180481232)],
    ),
    (
        crate::EncodedStr::Ascii("crystalliser"),
        &[(0b10010, &ENTRY_CRYSTALLIZER_9934670519220100357)],
    ),
    (
        crate::EncodedStr::Ascii("crystallisers"),
        &[(0b10010, &ENTRY_CRYSTALLIZERS_541454243380461975)],
    ),
    (
        crate::EncodedStr::Ascii("crystallises"),
        &[(0b10010, &ENTRY_CRYSTALLIZES_4917509722520652987)],
    ),
    (
        crate::EncodedStr::Ascii("crystallising"),
        &[(0b10010, &ENTRY_CRYSTALLIZING_1947916141166292087)],
    ),
    (
        crate::EncodedStr::Ascii("crystallizabilities"),
        &[(0b01001, &ENTRY_CRYSTALLIZABILITIES_3954684427565379393)],
    ),
    (
        crate::EncodedStr::Ascii("crystallizability"),
        &[(0b01001, &ENTRY_CRYSTALLIZABILITY_417676650172898499)],
    ),
    (
        crate::EncodedStr::Ascii("crystallizable"),
        &[(0b01001, &ENTRY_CRYSTALLIZABLE_5487202742125994763)],
    ),
    (
        crate::EncodedStr::Ascii("crystallizabler"),
        &[(0b01001, &ENTRY_CRYSTALLIZABLER_14422860421659122029)],
    ),
    (
        crate::EncodedStr::Ascii("crystallizables"),
        &[(0b01001, &ENTRY_CRYSTALLIZABLES_13105784762937285967)],
    ),
    (
        crate::EncodedStr::Ascii("crystallizablest"),
        &[(0b01001, &ENTRY_CRYSTALLIZABLEST_11639541143335039276)],
    ),
    (
        crate::EncodedStr::Ascii("crystallization"),
        &[(0b01001, &ENTRY_CRYSTALLIZATION_11917761263858890133)],
    ),
    (
        crate::EncodedStr::Ascii("crystallizations"),
        &[(0b01001, &ENTRY_CRYSTALLIZATIONS_8117698772064969073)],
    ),
    (
        crate::EncodedStr::Ascii("crystallize"),
        &[(0b01001, &ENTRY_CRYSTALLIZE_16085680612819973763)],
    ),
    (
        crate::EncodedStr::Ascii("crystallized"),
        &[(0b01001, &ENTRY_CRYSTALLIZED_1190597515180481232)],
    ),
    (
        crate::EncodedStr::Ascii("crystallizer"),
        &[(0b01001, &ENTRY_CRYSTALLIZER_9934670519220100357)],
    ),
    (
        crate::EncodedStr::Ascii("crystallizers"),
        &[(0b01001, &ENTRY_CRYSTALLIZERS_541454243380461975)],
    ),
    (
        crate::EncodedStr::Ascii("crystallizes"),
        &[(0b01001, &ENTRY_CRYSTALLIZES_4917509722520652987)],
    ),
    (
        crate::EncodedStr::Ascii("crystallizing"),
        &[(0b01001, &ENTRY_CRYSTALLIZING_1947916141166292087)],
    ),
    (
        crate::EncodedStr::Ascii("cubanise"),
        &[(0b10010, &ENTRY_CUBANIZE_5406869394071964531)],
    ),
    (
        crate::EncodedStr::Ascii("cubanises"),
        &[(0b10010, &ENTRY_CUBANIZES_11947476283611479479)],
    ),
    (
        crate::EncodedStr::Ascii("cubanize"),
        &[(0b01001, &ENTRY_CUBANIZE_5406869394071964531)],
    ),
    (
        crate::EncodedStr::Ascii("cubanizes"),
        &[(0b01001, &ENTRY_CUBANIZES_11947476283611479479)],
    ),
    (
        crate::EncodedStr::Ascii("cuckoldise"),
        &[(0b10010, &ENTRY_CUCKOLDIZE_15621372017035539958)],
    ),
    (
        crate::EncodedStr::Ascii("cuckoldised"),
        &[(0b10010, &ENTRY_CUCKOLDIZED_8063124355706017628)],
    ),
    (
        crate::EncodedStr::Ascii("cuckoldises"),
        &[(0b10010, &ENTRY_CUCKOLDIZES_12399951352713548106)],
    ),
    (
        crate::EncodedStr::Ascii("cuckoldising"),
        &[(0b10010, &ENTRY_CUCKOLDIZING_7372514622681800766)],
    ),
    (
        crate::EncodedStr::Ascii("cuckoldize"),
        &[(0b01001, &ENTRY_CUCKOLDIZE_15621372017035539958)],
    ),
    (
        crate::EncodedStr::Ascii("cuckoldized"),
        &[(0b01001, &ENTRY_CUCKOLDIZED_8063124355706017628)],
    ),
    (
        crate::EncodedStr::Ascii("cuckoldizes"),
        &[(0b01001, &ENTRY_CUCKOLDIZES_12399951352713548106)],
    ),
    (
        crate::EncodedStr::Ascii("cuckoldizing"),
        &[(0b01001, &ENTRY_CUCKOLDIZING_7372514622681800766)],
    ),
    (
        crate::EncodedStr::Ascii("cudgeled"),
        &[(0b00001, &ENTRY_CUDGELED_5228795318766271839)],
    ),
    (
        crate::EncodedStr::Ascii("cudgeler"),
        &[(0b00001, &ENTRY_CUDGELER_14634684249116397869)],
    ),
    (
        crate::EncodedStr::Ascii("cudgelers"),
        &[(0b00001, &ENTRY_CUDGELERS_17674302985237395736)],
    ),
    (
        crate::EncodedStr::Ascii("cudgeling"),
        &[(0b00001, &ENTRY_CUDGELING_10321409265487926568)],
    ),
    (
        crate::EncodedStr::Ascii("cudgelings"),
        &[(0b00001, &ENTRY_CUDGELINGS_2528963097802037407)],
    ),
    (
        crate::EncodedStr::Ascii("cudgelled"),
        &[(0b11010, &ENTRY_CUDGELED_5228795318766271839)],
    ),
    (
        crate::EncodedStr::Ascii("cudgeller"),
        &[(0b11010, &ENTRY_CUDGELER_14634684249116397869)],
    ),
    (
        crate::EncodedStr::Ascii("cudgellers"),
        &[(0b11010, &ENTRY_CUDGELERS_17674302985237395736)],
    ),
    (
        crate::EncodedStr::Ascii("cudgelling"),
        &[(0b11010, &ENTRY_CUDGELING_10321409265487926568)],
    ),
    (
        crate::EncodedStr::Ascii("cudgellings"),
        &[(0b11010, &ENTRY_CUDGELINGS_2528963097802037407)],
    ),
    (
        crate::EncodedStr::Ascii("culicidae"),
        &[(0b11010, &ENTRY_CULICIDE_539049738338426871)],
    ),
    (
        crate::EncodedStr::Ascii("culicide"),
        &[(0b00001, &ENTRY_CULICIDE_539049738338426871)],
    ),
    (
        crate::EncodedStr::Ascii("culturisation"),
        &[(0b10010, &ENTRY_CULTURIZATION_8113112597865327363)],
    ),
    (
        crate::EncodedStr::Ascii("culturisations"),
        &[(0b10010, &ENTRY_CULTURIZATIONS_433804245511281258)],
    ),
    (
        crate::EncodedStr::Ascii("culturise"),
        &[(0b10010, &ENTRY_CULTURIZE_9663475963702798186)],
    ),
    (
        crate::EncodedStr::Ascii("culturises"),
        &[(0b10010, &ENTRY_CULTURIZES_8371845703179033846)],
    ),
    (
        crate::EncodedStr::Ascii("culturization"),
        &[(0b01001, &ENTRY_CULTURIZATION_8113112597865327363)],
    ),
    (
        crate::EncodedStr::Ascii("culturizations"),
        &[(0b01001, &ENTRY_CULTURIZATIONS_433804245511281258)],
    ),
    (
        crate::EncodedStr::Ascii("culturize"),
        &[(0b01001, &ENTRY_CULTURIZE_9663475963702798186)],
    ),
    (
        crate::EncodedStr::Ascii("culturizes"),
        &[(0b01001, &ENTRY_CULTURIZES_8371845703179033846)],
    ),
    (
        crate::EncodedStr::Ascii("cupelation"),
        &[(0b00001, &ENTRY_CUPELATION_14255540896200543840)],
    ),
    (
        crate::EncodedStr::Ascii("cupeled"),
        &[(0b00001, &ENTRY_CUPELED_8946630193695466634)],
    ),
    (
        crate::EncodedStr::Ascii("cupeler"),
        &[(0b00001, &ENTRY_CUPELER_7377946170413406251)],
    ),
    (
        crate::EncodedStr::Ascii("cupelers"),
        &[(0b00001, &ENTRY_CUPELERS_5725217363507193203)],
    ),
    (
        crate::EncodedStr::Ascii("cupeling"),
        &[(0b00001, &ENTRY_CUPELING_4033682037469028100)],
    ),
    (
        crate::EncodedStr::Ascii("cupellation"),
        &[(0b11010, &ENTRY_CUPELATION_14255540896200543840)],
    ),
    (
        crate::EncodedStr::Ascii("cupelled"),
        &[(0b11010, &ENTRY_CUPELED_8946630193695466634)],
    ),
    (
        crate::EncodedStr::Ascii("cupeller"),
        &[(0b11010, &ENTRY_CUPELER_7377946170413406251)],
    ),
    (
        crate::EncodedStr::Ascii("cupellers"),
        &[(0b11010, &ENTRY_CUPELERS_5725217363507193203)],
    ),
    (
        crate::EncodedStr::Ascii("cupelling"),
        &[(0b11010, &ENTRY_CUPELING_4033682037469028100)],
    ),
    (
        crate::EncodedStr::Ascii("cupulae"),
        &[(0b11010, &ENTRY_CUPULE_4300809885306855718)],
    ),
    (
        crate::EncodedStr::Ascii("cupule"),
        &[(0b00001, &ENTRY_CUPULE_4300809885306855718)],
    ),
    (
        crate::EncodedStr::Ascii("curarise"),
        &[(0b10010, &ENTRY_CURARIZE_9480914079622972520)],
    ),
    (
        crate::EncodedStr::Ascii("curarised"),
        &[(0b10010, &ENTRY_CURARIZED_16380507751440201850)],
    ),
    (
        crate::EncodedStr::Ascii("curarises"),
        &[(0b10010, &ENTRY_CURARIZES_11507088447457007709)],
    ),
    (
        crate::EncodedStr::Ascii("curarising"),
        &[(0b10010, &ENTRY_CURARIZING_17039072217967273189)],
    ),
    (
        crate::EncodedStr::Ascii("curarize"),
        &[(0b01001, &ENTRY_CURARIZE_9480914079622972520)],
    ),
    (
        crate::EncodedStr::Ascii("curarized"),
        &[(0b01001, &ENTRY_CURARIZED_16380507751440201850)],
    ),
    (
        crate::EncodedStr::Ascii("curarizes"),
        &[(0b01001, &ENTRY_CURARIZES_11507088447457007709)],
    ),
    (
        crate::EncodedStr::Ascii("curarizing"),
        &[(0b01001, &ENTRY_CURARIZING_17039072217967273189)],
    ),
    (
        crate::EncodedStr::Ascii("curatise"),
        &[(0b10010, &ENTRY_CURATIZE_12754148319229450576)],
    ),
    (
        crate::EncodedStr::Ascii("curatises"),
        &[(0b10010, &ENTRY_CURATIZES_4333181687986321191)],
    ),
    (
        crate::EncodedStr::Ascii("curatize"),
        &[(0b01001, &ENTRY_CURATIZE_12754148319229450576)],
    ),
    (
        crate::EncodedStr::Ascii("curatizes"),
        &[(0b01001, &ENTRY_CURATIZES_4333181687986321191)],
    ),
    (
        crate::EncodedStr::Ascii("curricularisation"),
        &[(0b10010, &ENTRY_CURRICULARIZATION_17949948352689251703)],
    ),
    (
        crate::EncodedStr::Ascii("curricularisations"),
        &[(0b10010, &ENTRY_CURRICULARIZATIONS_8190097899978040825)],
    ),
    (
        crate::EncodedStr::Ascii("curricularise"),
        &[(0b10010, &ENTRY_CURRICULARIZE_16163595528229474912)],
    ),
    (
        crate::EncodedStr::Ascii("curricularises"),
        &[(0b10010, &ENTRY_CURRICULARIZES_15886142937581991191)],
    ),
    (
        crate::EncodedStr::Ascii("curricularization"),
        &[(0b01001, &ENTRY_CURRICULARIZATION_17949948352689251703)],
    ),
    (
        crate::EncodedStr::Ascii("curricularizations"),
        &[(0b01001, &ENTRY_CURRICULARIZATIONS_8190097899978040825)],
    ),
    (
        crate::EncodedStr::Ascii("curricularize"),
        &[(0b01001, &ENTRY_CURRICULARIZE_16163595528229474912)],
    ),
    (
        crate::EncodedStr::Ascii("curricularizes"),
        &[(0b01001, &ENTRY_CURRICULARIZES_15886142937581991191)],
    ),
    (
        crate::EncodedStr::Ascii("customisable"),
        &[(0b10010, &ENTRY_CUSTOMIZABLE_4188832830695107920)],
    ),
    (
        crate::EncodedStr::Ascii("customisation"),
        &[(0b10010, &ENTRY_CUSTOMIZATION_453875871734424262)],
    ),
    (
        crate::EncodedStr::Ascii("customisations"),
        &[(0b10010, &ENTRY_CUSTOMIZATIONS_5506803585454620316)],
    ),
    (
        crate::EncodedStr::Ascii("customise"),
        &[(0b10010, &ENTRY_CUSTOMIZE_17506619842499670481)],
    ),
    (
        crate::EncodedStr::Ascii("customised"),
        &[(0b10010, &ENTRY_CUSTOMIZED_13934442474650970923)],
    ),
    (
        crate::EncodedStr::Ascii("customiser"),
        &[(0b10010, &ENTRY_CUSTOMIZER_10903429132081239237)],
    ),
    (
        crate::EncodedStr::Ascii("customisers"),
        &[(0b10010, &ENTRY_CUSTOMIZERS_7343425341470389472)],
    ),
    (
        crate::EncodedStr::Ascii("customises"),
        &[(0b10010, &ENTRY_CUSTOMIZES_7573381294777108850)],
    ),
    (
        crate::EncodedStr::Ascii("customising"),
        &[(0b10010, &ENTRY_CUSTOMIZING_12981538261584263761)],
    ),
    (
        crate::EncodedStr::Ascii("customizable"),
        &[(0b01001, &ENTRY_CUSTOMIZABLE_4188832830695107920)],
    ),
    (
        crate::EncodedStr::Ascii("customization"),
        &[(0b01001, &ENTRY_CUSTOMIZATION_453875871734424262)],
    ),
    (
        crate::EncodedStr::Ascii("customizations"),
        &[(0b01001, &ENTRY_CUSTOMIZATIONS_5506803585454620316)],
    ),
    (
        crate::EncodedStr::Ascii("customize"),
        &[(0b01001, &ENTRY_CUSTOMIZE_17506619842499670481)],
    ),
    (
        crate::EncodedStr::Ascii("customized"),
        &[(0b01001, &ENTRY_CUSTOMIZED_13934442474650970923)],
    ),
    (
        crate::EncodedStr::Ascii("customizer"),
        &[(0b01001, &ENTRY_CUSTOMIZER_10903429132081239237)],
    ),
    (
        crate::EncodedStr::Ascii("customizers"),
        &[(0b01001, &ENTRY_CUSTOMIZERS_7343425341470389472)],
    ),
    (
        crate::EncodedStr::Ascii("customizes"),
        &[(0b01001, &ENTRY_CUSTOMIZES_7573381294777108850)],
    ),
    (
        crate::EncodedStr::Ascii("customizing"),
        &[(0b01001, &ENTRY_CUSTOMIZING_12981538261584263761)],
    ),
    (
        crate::EncodedStr::Ascii("cuticolor"),
        &[(0b00001, &ENTRY_CUTICOLOR_17641383408080176141)],
    ),
    (
        crate::EncodedStr::Ascii("cuticolour"),
        &[(0b11010, &ENTRY_CUTICOLOR_17641383408080176141)],
    ),
    (
        crate::EncodedStr::Ascii("cutinisation"),
        &[(0b10010, &ENTRY_CUTINIZATION_7081285991404911992)],
    ),
    (
        crate::EncodedStr::Ascii("cutinisations"),
        &[(0b10010, &ENTRY_CUTINIZATIONS_17168596603659079378)],
    ),
    (
        crate::EncodedStr::Ascii("cutinise"),
        &[(0b10010, &ENTRY_CUTINIZE_17770128684096533482)],
    ),
    (
        crate::EncodedStr::Ascii("cutinised"),
        &[(0b10010, &ENTRY_CUTINIZED_8304546337057011168)],
    ),
    (
        crate::EncodedStr::Ascii("cutinises"),
        &[(0b10010, &ENTRY_CUTINIZES_7397928291454568665)],
    ),
    (
        crate::EncodedStr::Ascii("cutinising"),
        &[(0b10010, &ENTRY_CUTINIZING_17947614786569489277)],
    ),
    (
        crate::EncodedStr::Ascii("cutinization"),
        &[(0b01001, &ENTRY_CUTINIZATION_7081285991404911992)],
    ),
    (
        crate::EncodedStr::Ascii("cutinizations"),
        &[(0b01001, &ENTRY_CUTINIZATIONS_17168596603659079378)],
    ),
    (
        crate::EncodedStr::Ascii("cutinize"),
        &[(0b01001, &ENTRY_CUTINIZE_17770128684096533482)],
    ),
    (
        crate::EncodedStr::Ascii("cutinized"),
        &[(0b01001, &ENTRY_CUTINIZED_8304546337057011168)],
    ),
    (
        crate::EncodedStr::Ascii("cutinizes"),
        &[(0b01001, &ENTRY_CUTINIZES_7397928291454568665)],
    ),
    (
        crate::EncodedStr::Ascii("cutinizing"),
        &[(0b01001, &ENTRY_CUTINIZING_17947614786569489277)],
    ),
    (
        crate::EncodedStr::Ascii("cutisation"),
        &[(0b10010, &ENTRY_CUTIZATION_8177626209182721273)],
    ),
    (
        crate::EncodedStr::Ascii("cutisations"),
        &[(0b10010, &ENTRY_CUTIZATIONS_12588515800323296191)],
    ),
    (
        crate::EncodedStr::Ascii("cutization"),
        &[(0b01001, &ENTRY_CUTIZATION_8177626209182721273)],
    ),
    (
        crate::EncodedStr::Ascii("cutizations"),
        &[(0b01001, &ENTRY_CUTIZATIONS_12588515800323296191)],
    ),
    (
        crate::EncodedStr::Ascii("cuvae"),
        &[(0b11010, &ENTRY_CUVE_11772864420884703925)],
    ),
    (
        crate::EncodedStr::Ascii("cuve"),
        &[(0b00001, &ENTRY_CUVE_11772864420884703925)],
    ),
    (
        crate::EncodedStr::Ascii("cyaneae"),
        &[(0b11010, &ENTRY_CYANEE_11375348371881906566)],
    ),
    (
        crate::EncodedStr::Ascii("cyanee"),
        &[(0b00001, &ENTRY_CYANEE_11375348371881906566)],
    ),
    (
        crate::EncodedStr::Ascii("cyanise"),
        &[(0b10010, &ENTRY_CYANIZE_16155583626941063831)],
    ),
    (
        crate::EncodedStr::Ascii("cyanised"),
        &[(0b10010, &ENTRY_CYANIZED_17361255917873352647)],
    ),
    (
        crate::EncodedStr::Ascii("cyanises"),
        &[(0b10010, &ENTRY_CYANIZES_5685851010869963468)],
    ),
    (
        crate::EncodedStr::Ascii("cyanising"),
        &[(0b10010, &ENTRY_CYANIZING_13714646055406888213)],
    ),
    (
        crate::EncodedStr::Ascii("cyanize"),
        &[(0b01001, &ENTRY_CYANIZE_16155583626941063831)],
    ),
    (
        crate::EncodedStr::Ascii("cyanized"),
        &[(0b01001, &ENTRY_CYANIZED_17361255917873352647)],
    ),
    (
        crate::EncodedStr::Ascii("cyanizes"),
        &[(0b01001, &ENTRY_CYANIZES_5685851010869963468)],
    ),
    (
        crate::EncodedStr::Ascii("cyanizing"),
        &[(0b01001, &ENTRY_CYANIZING_13714646055406888213)],
    ),
    (
        crate::EncodedStr::Ascii("cyanomethaemoglobin"),
        &[(0b11010, &ENTRY_CYANOMETHEMOGLOBIN_17992938767240588113)],
    ),
    (
        crate::EncodedStr::Ascii("cyanomethemoglobin"),
        &[(0b10001, &ENTRY_CYANOMETHEMOGLOBIN_17992938767240588113)],
    ),
    (
        crate::EncodedStr::Ascii("cyclisation"),
        &[(0b10010, &ENTRY_CYCLIZATION_18360017396052282635)],
    ),
    (
        crate::EncodedStr::Ascii("cyclisations"),
        &[(0b10010, &ENTRY_CYCLIZATIONS_3981106857955296675)],
    ),
    (
        crate::EncodedStr::Ascii("cyclise"),
        &[(0b10010, &ENTRY_CYCLIZE_11964539384894004110)],
    ),
    (
        crate::EncodedStr::Ascii("cyclised"),
        &[(0b10010, &ENTRY_CYCLIZED_9753759946426964794)],
    ),
    (
        crate::EncodedStr::Ascii("cyclises"),
        &[(0b10010, &ENTRY_CYCLIZES_5515758818050542691)],
    ),
    (
        crate::EncodedStr::Ascii("cyclising"),
        &[(0b10010, &ENTRY_CYCLIZING_8867677036457804725)],
    ),
    (
        crate::EncodedStr::Ascii("cyclization"),
        &[(0b01001, &ENTRY_CYCLIZATION_18360017396052282635)],
    ),
    (
        crate::EncodedStr::Ascii("cyclizations"),
        &[(0b01001, &ENTRY_CYCLIZATIONS_3981106857955296675)],
    ),
    (
        crate::EncodedStr::Ascii("cyclize"),
        &[(0b01001, &ENTRY_CYCLIZE_11964539384894004110)],
    ),
    (
        crate::EncodedStr::Ascii("cyclized"),
        &[(0b01001, &ENTRY_CYCLIZED_9753759946426964794)],
    ),
    (
        crate::EncodedStr::Ascii("cyclizes"),
        &[(0b01001, &ENTRY_CYCLIZES_5515758818050542691)],
    ),
    (
        crate::EncodedStr::Ascii("cyclizing"),
        &[(0b01001, &ENTRY_CYCLIZING_8867677036457804725)],
    ),
    (
        crate::EncodedStr::Ascii("cymae"),
        &[(0b11010, &ENTRY_CYME_3841905397007660900)],
    ),
    (
        crate::EncodedStr::Ascii("cyme"),
        &[(0b00001, &ENTRY_CYME_3841905397007660900)],
    ),
    (
        crate::EncodedStr::Ascii("czechisation"),
        &[(0b10010, &ENTRY_CZECHIZATION_14599848904820315137)],
    ),
    (
        crate::EncodedStr::Ascii("czechisations"),
        &[(0b10010, &ENTRY_CZECHIZATIONS_406710155217652709)],
    ),
    (
        crate::EncodedStr::Ascii("czechization"),
        &[(0b01001, &ENTRY_CZECHIZATION_14599848904820315137)],
    ),
    (
        crate::EncodedStr::Ascii("czechizations"),
        &[(0b01001, &ENTRY_CZECHIZATIONS_406710155217652709)],
    ),
    (
        crate::EncodedStr::Ascii("daedal"),
        &[(0b11010, &ENTRY_DEDAL_3527172992604688330)],
    ),
    (
        crate::EncodedStr::Ascii("daedalian"),
        &[(0b11010, &ENTRY_DEDALIAN_1818689560079214410)],
    ),
    (
        crate::EncodedStr::Ascii("daemonian"),
        &[(0b11010, &ENTRY_DEMONIAN_17257435076983249346)],
    ),
    (
        crate::EncodedStr::Ascii("daeva"),
        &[(0b11010, &ENTRY_DEVA_18303315502243076060)],
    ),
    (
        crate::EncodedStr::Ascii("danae"),
        &[(0b11010, &ENTRY_DANE_3862192600118407294)],
    ),
    (
        crate::EncodedStr::Ascii("danaidae"),
        &[(0b11010, &ENTRY_DANAIDE_9364396268060723081)],
    ),
    (
        crate::EncodedStr::Ascii("danaide"),
        &[(0b00001, &ENTRY_DANAIDE_9364396268060723081)],
    ),
    (
        crate::EncodedStr::Ascii("dandisette"),
        &[(0b10010, &ENTRY_DANDIZETTE_7715971230906134138)],
    ),
    (
        crate::EncodedStr::Ascii("dandizette"),
        &[(0b01001, &ENTRY_DANDIZETTE_7715971230906134138)],
    ),
    (
        crate::EncodedStr::Ascii("dandyise"),
        &[(0b10010, &ENTRY_DANDYIZE_10327123579855543927)],
    ),
    (
        crate::EncodedStr::Ascii("dandyises"),
        &[(0b10010, &ENTRY_DANDYIZES_5178148648982336582)],
    ),
    (
        crate::EncodedStr::Ascii("dandyize"),
        &[(0b01001, &ENTRY_DANDYIZE_10327123579855543927)],
    ),
    (
        crate::EncodedStr::Ascii("dandyizes"),
        &[(0b01001, &ENTRY_DANDYIZES_5178148648982336582)],
    ),
    (
        crate::EncodedStr::Ascii("dane"),
        &[(0b00001, &ENTRY_DANE_3862192600118407294)],
    ),
    (
        crate::EncodedStr::Ascii("danisation"),
        &[(0b10010, &ENTRY_DANIZATION_4527343444630609033)],
    ),
    (
        crate::EncodedStr::Ascii("danisations"),
        &[(0b10010, &ENTRY_DANIZATIONS_586018653689790602)],
    ),
    (
        crate::EncodedStr::Ascii("danise"),
        &[(0b10010, &ENTRY_DANIZE_7643162790699672050)],
    ),
    (
        crate::EncodedStr::Ascii("danises"),
        &[(0b10010, &ENTRY_DANIZES_982119247166854426)],
    ),
    (
        crate::EncodedStr::Ascii("danization"),
        &[(0b01001, &ENTRY_DANIZATION_4527343444630609033)],
    ),
    (
        crate::EncodedStr::Ascii("danizations"),
        &[(0b01001, &ENTRY_DANIZATIONS_586018653689790602)],
    ),
    (
        crate::EncodedStr::Ascii("danize"),
        &[(0b01001, &ENTRY_DANIZE_7643162790699672050)],
    ),
    (
        crate::EncodedStr::Ascii("danizes"),
        &[(0b01001, &ENTRY_DANIZES_982119247166854426)],
    ),
    (
        crate::EncodedStr::Ascii("darwinise"),
        &[(0b10010, &ENTRY_DARWINIZE_17708644917698913001)],
    ),
    (
        crate::EncodedStr::Ascii("darwinises"),
        &[(0b10010, &ENTRY_DARWINIZES_4276823588989949702)],
    ),
    (
        crate::EncodedStr::Ascii("darwinize"),
        &[(0b01001, &ENTRY_DARWINIZE_17708644917698913001)],
    ),
    (
        crate::EncodedStr::Ascii("darwinizes"),
        &[(0b01001, &ENTRY_DARWINIZES_4276823588989949702)],
    ),
    (
        crate::EncodedStr::Ascii("dastardise"),
        &[(0b10010, &ENTRY_DASTARDIZE_9137258977351501392)],
    ),
    (
        crate::EncodedStr::Ascii("dastardises"),
        &[(0b10010, &ENTRY_DASTARDIZES_14814359505750971454)],
    ),
    (
        crate::EncodedStr::Ascii("dastardize"),
        &[(0b01001, &ENTRY_DASTARDIZE_9137258977351501392)],
    ),
    (
        crate::EncodedStr::Ascii("dastardizes"),
        &[(0b01001, &ENTRY_DASTARDIZES_14814359505750971454)],
    ),
    (
        crate::EncodedStr::Ascii("deaconise"),
        &[(0b10010, &ENTRY_DEACONIZE_18248452212031779732)],
    ),
    (
        crate::EncodedStr::Ascii("deaconises"),
        &[(0b10010, &ENTRY_DEACONIZES_10922795038830896546)],
    ),
    (
        crate::EncodedStr::Ascii("deaconize"),
        &[(0b01001, &ENTRY_DEACONIZE_18248452212031779732)],
    ),
    (
        crate::EncodedStr::Ascii("deaconizes"),
        &[(0b01001, &ENTRY_DEACONIZES_10922795038830896546)],
    ),
    (
        crate::EncodedStr::Ascii("deadrise"),
        &[(0b10010, &ENTRY_DEADRIZE_16948183351591896893)],
    ),
    (
        crate::EncodedStr::Ascii("deadrize"),
        &[(0b01001, &ENTRY_DEADRIZE_16948183351591896893)],
    ),
    (
        crate::EncodedStr::Ascii("dealcoholise"),
        &[(0b10010, &ENTRY_DEALCOHOLIZE_17481590891108727711)],
    ),
    (
        crate::EncodedStr::Ascii("dealcoholised"),
        &[(0b10010, &ENTRY_DEALCOHOLIZED_4879647847969574400)],
    ),
    (
        crate::EncodedStr::Ascii("dealcoholises"),
        &[(0b10010, &ENTRY_DEALCOHOLIZES_8191413688823277724)],
    ),
    (
        crate::EncodedStr::Ascii("dealcoholising"),
        &[(0b10010, &ENTRY_DEALCOHOLIZING_9291655249306543942)],
    ),
    (
        crate::EncodedStr::Ascii("dealcoholize"),
        &[(0b01001, &ENTRY_DEALCOHOLIZE_17481590891108727711)],
    ),
    (
        crate::EncodedStr::Ascii("dealcoholized"),
        &[(0b01001, &ENTRY_DEALCOHOLIZED_4879647847969574400)],
    ),
    (
        crate::EncodedStr::Ascii("dealcoholizes"),
        &[(0b01001, &ENTRY_DEALCOHOLIZES_8191413688823277724)],
    ),
    (
        crate::EncodedStr::Ascii("dealcoholizing"),
        &[(0b01001, &ENTRY_DEALCOHOLIZING_9291655249306543942)],
    ),
    (
        crate::EncodedStr::Ascii("deaminise"),
        &[(0b10010, &ENTRY_DEAMINIZE_18302767805033719686)],
    ),
    (
        crate::EncodedStr::Ascii("deaminize"),
        &[(0b01001, &ENTRY_DEAMINIZE_18302767805033719686)],
    ),
    (
        crate::EncodedStr::Ascii("decaliter"),
        &[(0b00001, &ENTRY_DECALITER_4375398060796975724)],
    ),
    (
        crate::EncodedStr::Ascii("decaliters"),
        &[(0b00001, &ENTRY_DECALITERS_3685909594822331600)],
    ),
    (
        crate::EncodedStr::Ascii("decalitre"),
        &[(0b11010, &ENTRY_DECALITER_4375398060796975724)],
    ),
    (
        crate::EncodedStr::Ascii("decalitres"),
        &[(0b11010, &ENTRY_DECALITERS_3685909594822331600)],
    ),
    (
        crate::EncodedStr::Ascii("decameter"),
        &[(0b00001, &ENTRY_DECAMETER_14656314621987784949)],
    ),
    (
        crate::EncodedStr::Ascii("decameters"),
        &[(0b00001, &ENTRY_DECAMETERS_12345413372720956347)],
    ),
    (
        crate::EncodedStr::Ascii("decametre"),
        &[(0b11010, &ENTRY_DECAMETER_14656314621987784949)],
    ),
    (
        crate::EncodedStr::Ascii("decametres"),
        &[(0b11010, &ENTRY_DECAMETERS_12345413372720956347)],
    ),
    (
        crate::EncodedStr::Ascii("decapitalisation"),
        &[(0b10010, &ENTRY_DECAPITALIZATION_10013185676274515636)],
    ),
    (
        crate::EncodedStr::Ascii("decapitalisations"),
        &[(0b10010, &ENTRY_DECAPITALIZATIONS_4946483081288861635)],
    ),
    (
        crate::EncodedStr::Ascii("decapitalise"),
        &[(0b10010, &ENTRY_DECAPITALIZE_16025876451254005657)],
    ),
    (
        crate::EncodedStr::Ascii("decapitalised"),
        &[(0b10010, &ENTRY_DECAPITALIZED_11861526144439577453)],
    ),
    (
        crate::EncodedStr::Ascii("decapitalises"),
        &[(0b10010, &ENTRY_DECAPITALIZES_3757956433811423536)],
    ),
    (
        crate::EncodedStr::Ascii("decapitalising"),
        &[(0b10010, &ENTRY_DECAPITALIZING_9239457887018733519)],
    ),
    (
        crate::EncodedStr::Ascii("decapitalization"),
        &[(0b01001, &ENTRY_DECAPITALIZATION_10013185676274515636)],
    ),
    (
        crate::EncodedStr::Ascii("decapitalizations"),
        &[(0b01001, &ENTRY_DECAPITALIZATIONS_4946483081288861635)],
    ),
    (
        crate::EncodedStr::Ascii("decapitalize"),
        &[(0b01001, &ENTRY_DECAPITALIZE_16025876451254005657)],
    ),
    (
        crate::EncodedStr::Ascii("decapitalized"),
        &[(0b01001, &ENTRY_DECAPITALIZED_11861526144439577453)],
    ),
    (
        crate::EncodedStr::Ascii("decapitalizes"),
        &[(0b01001, &ENTRY_DECAPITALIZES_3757956433811423536)],
    ),
    (
        crate::EncodedStr::Ascii("decapitalizing"),
        &[(0b01001, &ENTRY_DECAPITALIZING_9239457887018733519)],
    ),
    (
        crate::EncodedStr::Ascii("decarbonisation"),
        &[(0b10010, &ENTRY_DECARBONIZATION_8874762898635047514)],
    ),
    (
        crate::EncodedStr::Ascii("decarbonisations"),
        &[(0b10010, &ENTRY_DECARBONIZATIONS_12243161232853744724)],
    ),
    (
        crate::EncodedStr::Ascii("decarbonise"),
        &[(0b10010, &ENTRY_DECARBONIZE_14547194689917209691)],
    ),
    (
        crate::EncodedStr::Ascii("decarbonised"),
        &[(0b10010, &ENTRY_DECARBONIZED_831670285440777483)],
    ),
    (
        crate::EncodedStr::Ascii("decarboniser"),
        &[(0b10010, &ENTRY_DECARBONIZER_7249394058399586099)],
    ),
    (
        crate::EncodedStr::Ascii("decarbonisers"),
        &[(0b10010, &ENTRY_DECARBONIZERS_11181600971431230502)],
    ),
    (
        crate::EncodedStr::Ascii("decarbonises"),
        &[(0b10010, &ENTRY_DECARBONIZES_16627154206935494807)],
    ),
    (
        crate::EncodedStr::Ascii("decarbonising"),
        &[(0b10010, &ENTRY_DECARBONIZING_17299516323553280568)],
    ),
    (
        crate::EncodedStr::Ascii("decarbonization"),
        &[(0b01001, &ENTRY_DECARBONIZATION_8874762898635047514)],
    ),
    (
        crate::EncodedStr::Ascii("decarbonizations"),
        &[(0b01001, &ENTRY_DECARBONIZATIONS_12243161232853744724)],
    ),
    (
        crate::EncodedStr::Ascii("decarbonize"),
        &[(0b01001, &ENTRY_DECARBONIZE_14547194689917209691)],
    ),
    (
        crate::EncodedStr::Ascii("decarbonized"),
        &[(0b01001, &ENTRY_DECARBONIZED_831670285440777483)],
    ),
    (
        crate::EncodedStr::Ascii("decarbonizer"),
        &[(0b01001, &ENTRY_DECARBONIZER_7249394058399586099)],
    ),
    (
        crate::EncodedStr::Ascii("decarbonizers"),
        &[(0b01001, &ENTRY_DECARBONIZERS_11181600971431230502)],
    ),
    (
        crate::EncodedStr::Ascii("decarbonizes"),
        &[(0b01001, &ENTRY_DECARBONIZES_16627154206935494807)],
    ),
    (
        crate::EncodedStr::Ascii("decarbonizing"),
        &[(0b01001, &ENTRY_DECARBONIZING_17299516323553280568)],
    ),
    (
        crate::EncodedStr::Ascii("decarburisation"),
        &[(0b10010, &ENTRY_DECARBURIZATION_9039500434838585200)],
    ),
    (
        crate::EncodedStr::Ascii("decarburisations"),
        &[(0b10010, &ENTRY_DECARBURIZATIONS_2176112887354481552)],
    ),
    (
        crate::EncodedStr::Ascii("decarburise"),
        &[(0b10010, &ENTRY_DECARBURIZE_9459391841384624626)],
    ),
    (
        crate::EncodedStr::Ascii("decarburised"),
        &[(0b10010, &ENTRY_DECARBURIZED_2477575653270598611)],
    ),
    (
        crate::EncodedStr::Ascii("decarburises"),
        &[(0b10010, &ENTRY_DECARBURIZES_4783060351348035100)],
    ),
    (
        crate::EncodedStr::Ascii("decarburising"),
        &[(0b10010, &ENTRY_DECARBURIZING_6487494577812793164)],
    ),
    (
        crate::EncodedStr::Ascii("decarburization"),
        &[(0b01001, &ENTRY_DECARBURIZATION_9039500434838585200)],
    ),
    (
        crate::EncodedStr::Ascii("decarburizations"),
        &[(0b01001, &ENTRY_DECARBURIZATIONS_2176112887354481552)],
    ),
    (
        crate::EncodedStr::Ascii("decarburize"),
        &[(0b01001, &ENTRY_DECARBURIZE_9459391841384624626)],
    ),
    (
        crate::EncodedStr::Ascii("decarburized"),
        &[(0b01001, &ENTRY_DECARBURIZED_2477575653270598611)],
    ),
    (
        crate::EncodedStr::Ascii("decarburizes"),
        &[(0b01001, &ENTRY_DECARBURIZES_4783060351348035100)],
    ),
    (
        crate::EncodedStr::Ascii("decarburizing"),
        &[(0b01001, &ENTRY_DECARBURIZING_6487494577812793164)],
    ),
    (
        crate::EncodedStr::Ascii("decasualisation"),
        &[(0b10010, &ENTRY_DECASUALIZATION_10274253385824132479)],
    ),
    (
        crate::EncodedStr::Ascii("decasualisations"),
        &[(0b10010, &ENTRY_DECASUALIZATIONS_3864825352222685439)],
    ),
    (
        crate::EncodedStr::Ascii("decasualise"),
        &[(0b10010, &ENTRY_DECASUALIZE_17572605258851322561)],
    ),
    (
        crate::EncodedStr::Ascii("decasualised"),
        &[(0b10010, &ENTRY_DECASUALIZED_1520306088891108700)],
    ),
    (
        crate::EncodedStr::Ascii("decasualising"),
        &[(0b10010, &ENTRY_DECASUALIZING_18325301279691614544)],
    ),
    (
        crate::EncodedStr::Ascii("decasualization"),
        &[(0b01001, &ENTRY_DECASUALIZATION_10274253385824132479)],
    ),
    (
        crate::EncodedStr::Ascii("decasualizations"),
        &[(0b01001, &ENTRY_DECASUALIZATIONS_3864825352222685439)],
    ),
    (
        crate::EncodedStr::Ascii("decasualize"),
        &[(0b01001, &ENTRY_DECASUALIZE_17572605258851322561)],
    ),
    (
        crate::EncodedStr::Ascii("decasualized"),
        &[(0b01001, &ENTRY_DECASUALIZED_1520306088891108700)],
    ),
    (
        crate::EncodedStr::Ascii("decasualizing"),
        &[(0b01001, &ENTRY_DECASUALIZING_18325301279691614544)],
    ),
    (
        crate::EncodedStr::Ascii("decenters"),
        &[(0b00001, &ENTRY_DECENTERS_782900641405037424)],
    ),
    (
        crate::EncodedStr::Ascii("decentralisation"),
        &[(0b10010, &ENTRY_DECENTRALIZATION_1145039421821383347)],
    ),
    (
        crate::EncodedStr::Ascii("decentralisationist"),
        &[(0b10010, &ENTRY_DECENTRALIZATIONIST_15242187117214090536)],
    ),
    (
        crate::EncodedStr::Ascii("decentralisations"),
        &[(0b10010, &ENTRY_DECENTRALIZATIONS_17002754818902434488)],
    ),
    (
        crate::EncodedStr::Ascii("decentralise"),
        &[(0b10010, &ENTRY_DECENTRALIZE_1723656843408900394)],
    ),
    (
        crate::EncodedStr::Ascii("decentralised"),
        &[(0b10010, &ENTRY_DECENTRALIZED_17904951634508172483)],
    ),
    (
        crate::EncodedStr::Ascii("decentralises"),
        &[(0b10010, &ENTRY_DECENTRALIZES_4819976769659557164)],
    ),
    (
        crate::EncodedStr::Ascii("decentralising"),
        &[(0b10010, &ENTRY_DECENTRALIZING_1061628518546631855)],
    ),
    (
        crate::EncodedStr::Ascii("decentralization"),
        &[(0b01001, &ENTRY_DECENTRALIZATION_1145039421821383347)],
    ),
    (
        crate::EncodedStr::Ascii("decentralizationist"),
        &[(0b01001, &ENTRY_DECENTRALIZATIONIST_15242187117214090536)],
    ),
    (
        crate::EncodedStr::Ascii("decentralizations"),
        &[(0b01001, &ENTRY_DECENTRALIZATIONS_17002754818902434488)],
    ),
    (
        crate::EncodedStr::Ascii("decentralize"),
        &[(0b01001, &ENTRY_DECENTRALIZE_1723656843408900394)],
    ),
    (
        crate::EncodedStr::Ascii("decentralized"),
        &[(0b01001, &ENTRY_DECENTRALIZED_17904951634508172483)],
    ),
    (
        crate::EncodedStr::Ascii("decentralizes"),
        &[(0b01001, &ENTRY_DECENTRALIZES_4819976769659557164)],
    ),
    (
        crate::EncodedStr::Ascii("decentralizing"),
        &[(0b01001, &ENTRY_DECENTRALIZING_1061628518546631855)],
    ),
    (
        crate::EncodedStr::Ascii("decentres"),
        &[(0b11010, &ENTRY_DECENTERS_782900641405037424)],
    ),
    (
        crate::EncodedStr::Ascii("decerebrise"),
        &[(0b10010, &ENTRY_DECEREBRIZE_5169026104609683255)],
    ),
    (
        crate::EncodedStr::Ascii("decerebrised"),
        &[(0b10010, &ENTRY_DECEREBRIZED_14339403834612181570)],
    ),
    (
        crate::EncodedStr::Ascii("decerebrises"),
        &[(0b10010, &ENTRY_DECEREBRIZES_7217503420848291830)],
    ),
    (
        crate::EncodedStr::Ascii("decerebrising"),
        &[(0b10010, &ENTRY_DECEREBRIZING_6341477046577811325)],
    ),
    (
        crate::EncodedStr::Ascii("decerebrize"),
        &[(0b01001, &ENTRY_DECEREBRIZE_5169026104609683255)],
    ),
    (
        crate::EncodedStr::Ascii("decerebrized"),
        &[(0b01001, &ENTRY_DECEREBRIZED_14339403834612181570)],
    ),
    (
        crate::EncodedStr::Ascii("decerebrizes"),
        &[(0b01001, &ENTRY_DECEREBRIZES_7217503420848291830)],
    ),
    (
        crate::EncodedStr::Ascii("decerebrizing"),
        &[(0b01001, &ENTRY_DECEREBRIZING_6341477046577811325)],
    ),
    (
        crate::EncodedStr::Ascii("dechristianisation"),
        &[(0b10010, &ENTRY_DECHRISTIANIZATION_11836465351921531501)],
    ),
    (
        crate::EncodedStr::Ascii("dechristianisations"),
        &[(0b10010, &ENTRY_DECHRISTIANIZATIONS_17028100591913749882)],
    ),
    (
        crate::EncodedStr::Ascii("dechristianise"),
        &[(0b10010, &ENTRY_DECHRISTIANIZE_1708321262942279453)],
    ),
    (
        crate::EncodedStr::Ascii("dechristianised"),
        &[(0b10010, &ENTRY_DECHRISTIANIZED_6964242037591866891)],
    ),
    (
        crate::EncodedStr::Ascii("dechristianises"),
        &[(0b10010, &ENTRY_DECHRISTIANIZES_6387580170865898146)],
    ),
    (
        crate::EncodedStr::Ascii("dechristianising"),
        &[(0b10010, &ENTRY_DECHRISTIANIZING_9955318127138092041)],
    ),
    (
        crate::EncodedStr::Ascii("dechristianization"),
        &[(0b01001, &ENTRY_DECHRISTIANIZATION_11836465351921531501)],
    ),
    (
        crate::EncodedStr::Ascii("dechristianizations"),
        &[(0b01001, &ENTRY_DECHRISTIANIZATIONS_17028100591913749882)],
    ),
    (
        crate::EncodedStr::Ascii("dechristianize"),
        &[(0b01001, &ENTRY_DECHRISTIANIZE_1708321262942279453)],
    ),
    (
        crate::EncodedStr::Ascii("dechristianized"),
        &[(0b01001, &ENTRY_DECHRISTIANIZED_6964242037591866891)],
    ),
    (
        crate::EncodedStr::Ascii("dechristianizes"),
        &[(0b01001, &ENTRY_DECHRISTIANIZES_6387580170865898146)],
    ),
    (
        crate::EncodedStr::Ascii("dechristianizing"),
        &[(0b01001, &ENTRY_DECHRISTIANIZING_9955318127138092041)],
    ),
    (
        crate::EncodedStr::Ascii("decigramme"),
        &[(0b10010, &ENTRY_DECIGRAM_17589790411371966600)],
    ),
    (
        crate::EncodedStr::Ascii("decigrammes"),
        &[(0b10010, &ENTRY_DECIGRAMS_7725289753257784879)],
    ),
    (
        crate::EncodedStr::Ascii("deciliter"),
        &[(0b00001, &ENTRY_DECILITER_16804458751438697102)],
    ),
    (
        crate::EncodedStr::Ascii("deciliters"),
        &[(0b00001, &ENTRY_DECILITERS_4643786240815277020)],
    ),
    (
        crate::EncodedStr::Ascii("decilitre"),
        &[(0b11010, &ENTRY_DECILITER_16804458751438697102)],
    ),
    (
        crate::EncodedStr::Ascii("decilitres"),
        &[(0b11010, &ENTRY_DECILITERS_4643786240815277020)],
    ),
    (
        crate::EncodedStr::Ascii("decimalisation"),
        &[(0b10010, &ENTRY_DECIMALIZATION_6996195191656110298)],
    ),
    (
        crate::EncodedStr::Ascii("decimalisations"),
        &[(0b10010, &ENTRY_DECIMALIZATIONS_7263991078898399657)],
    ),
    (
        crate::EncodedStr::Ascii("decimalise"),
        &[(0b10010, &ENTRY_DECIMALIZE_17840181587779229578)],
    ),
    (
        crate::EncodedStr::Ascii("decimalised"),
        &[(0b10010, &ENTRY_DECIMALIZED_11759803687347791070)],
    ),
    (
        crate::EncodedStr::Ascii("decimalises"),
        &[(0b10010, &ENTRY_DECIMALIZES_10277653931987829798)],
    ),
    (
        crate::EncodedStr::Ascii("decimalising"),
        &[(0b10010, &ENTRY_DECIMALIZING_6772930949596594022)],
    ),
    (
        crate::EncodedStr::Ascii("decimalization"),
        &[(0b01001, &ENTRY_DECIMALIZATION_6996195191656110298)],
    ),
    (
        crate::EncodedStr::Ascii("decimalizations"),
        &[(0b01001, &ENTRY_DECIMALIZATIONS_7263991078898399657)],
    ),
    (
        crate::EncodedStr::Ascii("decimalize"),
        &[(0b01001, &ENTRY_DECIMALIZE_17840181587779229578)],
    ),
    (
        crate::EncodedStr::Ascii("decimalized"),
        &[(0b01001, &ENTRY_DECIMALIZED_11759803687347791070)],
    ),
    (
        crate::EncodedStr::Ascii("decimalizes"),
        &[(0b01001, &ENTRY_DECIMALIZES_10277653931987829798)],
    ),
    (
        crate::EncodedStr::Ascii("decimalizing"),
        &[(0b01001, &ENTRY_DECIMALIZING_6772930949596594022)],
    ),
    (
        crate::EncodedStr::Ascii("decimeter"),
        &[(0b00001, &ENTRY_DECIMETER_14067880338205453806)],
    ),
    (
        crate::EncodedStr::Ascii("decimeters"),
        &[(0b00001, &ENTRY_DECIMETERS_4158783169372669202)],
    ),
    (
        crate::EncodedStr::Ascii("decimetre"),
        &[(0b11010, &ENTRY_DECIMETER_14067880338205453806)],
    ),
    (
        crate::EncodedStr::Ascii("decimetres"),
        &[(0b11010, &ENTRY_DECIMETERS_4158783169372669202)],
    ),
    (
        crate::EncodedStr::Ascii("decivilise"),
        &[(0b10010, &ENTRY_DECIVILIZE_16580511735338840581)],
    ),
    (
        crate::EncodedStr::Ascii("decivilised"),
        &[(0b10010, &ENTRY_DECIVILIZED_5079080916308187134)],
    ),
    (
        crate::EncodedStr::Ascii("decivilises"),
        &[(0b10010, &ENTRY_DECIVILIZES_6813589689406092861)],
    ),
    (
        crate::EncodedStr::Ascii("decivilising"),
        &[(0b10010, &ENTRY_DECIVILIZING_4023615304630258958)],
    ),
    (
        crate::EncodedStr::Ascii("decivilize"),
        &[(0b01001, &ENTRY_DECIVILIZE_16580511735338840581)],
    ),
    (
        crate::EncodedStr::Ascii("decivilized"),
        &[(0b01001, &ENTRY_DECIVILIZED_5079080916308187134)],
    ),
    (
        crate::EncodedStr::Ascii("decivilizes"),
        &[(0b01001, &ENTRY_DECIVILIZES_6813589689406092861)],
    ),
    (
        crate::EncodedStr::Ascii("decivilizing"),
        &[(0b01001, &ENTRY_DECIVILIZING_4023615304630258958)],
    ),
    (
        crate::EncodedStr::Ascii("decolonisation"),
        &[(0b10010, &ENTRY_DECOLONIZATION_14844676044557344393)],
    ),
    (
        crate::EncodedStr::Ascii("decolonisations"),
        &[(0b10010, &ENTRY_DECOLONIZATIONS_15473229397920826981)],
    ),
    (
        crate::EncodedStr::Ascii("decolonise"),
        &[(0b10010, &ENTRY_DECOLONIZE_8704444043034616664)],
    ),
    (
        crate::EncodedStr::Ascii("decolonised"),
        &[(0b10010, &ENTRY_DECOLONIZED_2468128191816289613)],
    ),
    (
        crate::EncodedStr::Ascii("decolonises"),
        &[(0b10010, &ENTRY_DECOLONIZES_17529571225109301692)],
    ),
    (
        crate::EncodedStr::Ascii("decolonising"),
        &[(0b10010, &ENTRY_DECOLONIZING_15890941705265622387)],
    ),
    (
        crate::EncodedStr::Ascii("decolonization"),
        &[(0b01001, &ENTRY_DECOLONIZATION_14844676044557344393)],
    ),
    (
        crate::EncodedStr::Ascii("decolonizations"),
        &[(0b01001, &ENTRY_DECOLONIZATIONS_15473229397920826981)],
    ),
    (
        crate::EncodedStr::Ascii("decolonize"),
        &[(0b01001, &ENTRY_DECOLONIZE_8704444043034616664)],
    ),
    (
        crate::EncodedStr::Ascii("decolonized"),
        &[(0b01001, &ENTRY_DECOLONIZED_2468128191816289613)],
    ),
    (
        crate::EncodedStr::Ascii("decolonizes"),
        &[(0b01001, &ENTRY_DECOLONIZES_17529571225109301692)],
    ),
    (
        crate::EncodedStr::Ascii("decolonizing"),
        &[(0b01001, &ENTRY_DECOLONIZING_15890941705265622387)],
    ),
    (
        crate::EncodedStr::Ascii("decolor"),
        &[(0b11001, &ENTRY_DECOLOR_5736949126416349048)],
    ),
    (
        crate::EncodedStr::Ascii("decolorant"),
        &[(0b11001, &ENTRY_DECOLORANT_5335359943030311716)],
    ),
    (
        crate::EncodedStr::Ascii("decolorants"),
        &[(0b11001, &ENTRY_DECOLORANTS_14395800598549575388)],
    ),
    (
        crate::EncodedStr::Ascii("decolorate"),
        &[(0b00001, &ENTRY_DECOLORATE_16171421314227384757)],
    ),
    (
        crate::EncodedStr::Ascii("decolorated"),
        &[(0b00001, &ENTRY_DECOLORATED_13361198090261586484)],
    ),
    (
        crate::EncodedStr::Ascii("decolorates"),
        &[(0b00001, &ENTRY_DECOLORATES_970217286770855278)],
    ),
    (
        crate::EncodedStr::Ascii("decoloration"),
        &[(0b00001, &ENTRY_DECOLORATION_687527831916147355)],
    ),
    (
        crate::EncodedStr::Ascii("decolorations"),
        &[(0b00001, &ENTRY_DECOLORATIONS_5937830887779716004)],
    ),
    (
        crate::EncodedStr::Ascii("decolored"),
        &[(0b11001, &ENTRY_DECOLORED_12789961260525747964)],
    ),
    (
        crate::EncodedStr::Ascii("decolorimeter"),
        &[(0b00001, &ENTRY_DECOLORIMETER_9685638258569395132)],
    ),
    (
        crate::EncodedStr::Ascii("decoloring"),
        &[(0b11001, &ENTRY_DECOLORING_6691256159228887702)],
    ),
    (
        crate::EncodedStr::Ascii("decolorization"),
        &[(0b00001, &ENTRY_DECOLORIZATION_9440321833606051398)],
    ),
    (
        crate::EncodedStr::Ascii("decolorizations"),
        &[(0b00001, &ENTRY_DECOLORIZATIONS_5583822483356878390)],
    ),
    (
        crate::EncodedStr::Ascii("decolorize"),
        &[(0b00001, &ENTRY_DECOLORIZE_10787926865254737924)],
    ),
    (
        crate::EncodedStr::Ascii("decolorized"),
        &[(0b00001, &ENTRY_DECOLORIZED_17864546395597600300)],
    ),
    (
        crate::EncodedStr::Ascii("decolorizer"),
        &[(0b00001, &ENTRY_DECOLORIZER_1117085801636205705)],
    ),
    (
        crate::EncodedStr::Ascii("decolorizers"),
        &[(0b00001, &ENTRY_DECOLORIZERS_2577270439983901494)],
    ),
    (
        crate::EncodedStr::Ascii("decolorizes"),
        &[(0b00001, &ENTRY_DECOLORIZES_5066928271122015081)],
    ),
    (
        crate::EncodedStr::Ascii("decolorizing"),
        &[(0b00001, &ENTRY_DECOLORIZING_16950423814877555244)],
    ),
    (
        crate::EncodedStr::Ascii("decolors"),
        &[(0b11001, &ENTRY_DECOLORS_121898289642929190)],
    ),
    (
        crate::EncodedStr::Ascii("decolour"),
        &[(0b11010, &ENTRY_DECOLOR_5736949126416349048)],
    ),
    (
        crate::EncodedStr::Ascii("decolourant"),
        &[(0b11010, &ENTRY_DECOLORANT_5335359943030311716)],
    ),
    (
        crate::EncodedStr::Ascii("decolourants"),
        &[(0b11010, &ENTRY_DECOLORANTS_14395800598549575388)],
    ),
    (
        crate::EncodedStr::Ascii("decolourate"),
        &[(0b11010, &ENTRY_DECOLORATE_16171421314227384757)],
    ),
    (
        crate::EncodedStr::Ascii("decolourated"),
        &[(0b11010, &ENTRY_DECOLORATED_13361198090261586484)],
    ),
    (
        crate::EncodedStr::Ascii("decolourates"),
        &[(0b11010, &ENTRY_DECOLORATES_970217286770855278)],
    ),
    (
        crate::EncodedStr::Ascii("decolouration"),
        &[(0b11010, &ENTRY_DECOLORATION_687527831916147355)],
    ),
    (
        crate::EncodedStr::Ascii("decolourations"),
        &[(0b11010, &ENTRY_DECOLORATIONS_5937830887779716004)],
    ),
    (
        crate::EncodedStr::Ascii("decoloured"),
        &[(0b11010, &ENTRY_DECOLORED_12789961260525747964)],
    ),
    (
        crate::EncodedStr::Ascii("decolourimeter"),
        &[(0b11010, &ENTRY_DECOLORIMETER_9685638258569395132)],
    ),
    (
        crate::EncodedStr::Ascii("decolouring"),
        &[(0b11010, &ENTRY_DECOLORING_6691256159228887702)],
    ),
    (
        crate::EncodedStr::Ascii("decolourisation"),
        &[(0b10010, &ENTRY_DECOLORIZATION_9440321833606051398)],
    ),
    (
        crate::EncodedStr::Ascii("decolourisations"),
        &[(0b10010, &ENTRY_DECOLORIZATIONS_5583822483356878390)],
    ),
    (
        crate::EncodedStr::Ascii("decolourise"),
        &[(0b10010, &ENTRY_DECOLORIZE_10787926865254737924)],
    ),
    (
        crate::EncodedStr::Ascii("decolourised"),
        &[(0b10010, &ENTRY_DECOLORIZED_17864546395597600300)],
    ),
    (
        crate::EncodedStr::Ascii("decolouriser"),
        &[(0b10010, &ENTRY_DECOLORIZER_1117085801636205705)],
    ),
    (
        crate::EncodedStr::Ascii("decolourisers"),
        &[(0b10010, &ENTRY_DECOLORIZERS_2577270439983901494)],
    ),
    (
        crate::EncodedStr::Ascii("decolourises"),
        &[(0b10010, &ENTRY_DECOLORIZES_5066928271122015081)],
    ),
    (
        crate::EncodedStr::Ascii("decolourising"),
        &[(0b10010, &ENTRY_DECOLORIZING_16950423814877555244)],
    ),
    (
        crate::EncodedStr::Ascii("decolourization"),
        &[(0b01000, &ENTRY_DECOLORIZATION_9440321833606051398)],
    ),
    (
        crate::EncodedStr::Ascii("decolourizations"),
        &[(0b01000, &ENTRY_DECOLORIZATIONS_5583822483356878390)],
    ),
    (
        crate::EncodedStr::Ascii("decolourize"),
        &[(0b01000, &ENTRY_DECOLORIZE_10787926865254737924)],
    ),
    (
        crate::EncodedStr::Ascii("decolourized"),
        &[(0b01000, &ENTRY_DECOLORIZED_17864546395597600300)],
    ),
    (
        crate::EncodedStr::Ascii("decolourizer"),
        &[(0b01000, &ENTRY_DECOLORIZER_1117085801636205705)],
    ),
    (
        crate::EncodedStr::Ascii("decolourizers"),
        &[(0b01000, &ENTRY_DECOLORIZERS_2577270439983901494)],
    ),
    (
        crate::EncodedStr::Ascii("decolourizes"),
        &[(0b01000, &ENTRY_DECOLORIZES_5066928271122015081)],
    ),
    (
        crate::EncodedStr::Ascii("decolourizing"),
        &[(0b01000, &ENTRY_DECOLORIZING_16950423814877555244)],
    ),
    (
        crate::EncodedStr::Ascii("decolours"),
        &[(0b11010, &ENTRY_DECOLORS_121898289642929190)],
    ),
    (
        crate::EncodedStr::Ascii("decriminalisation"),
        &[(0b10010, &ENTRY_DECRIMINALIZATION_11495835016656319471)],
    ),
    (
        crate::EncodedStr::Ascii("decriminalisations"),
        &[(0b10010, &ENTRY_DECRIMINALIZATIONS_8826141293763176549)],
    ),
    (
        crate::EncodedStr::Ascii("decriminalise"),
        &[(0b10010, &ENTRY_DECRIMINALIZE_6091198611704708595)],
    ),
    (
        crate::EncodedStr::Ascii("decriminalised"),
        &[(0b10010, &ENTRY_DECRIMINALIZED_14857350688716779167)],
    ),
    (
        crate::EncodedStr::Ascii("decriminalises"),
        &[(0b10010, &ENTRY_DECRIMINALIZES_6368952306309816010)],
    ),
    (
        crate::EncodedStr::Ascii("decriminalising"),
        &[(0b10010, &ENTRY_DECRIMINALIZING_16672118604268496422)],
    ),
    (
        crate::EncodedStr::Ascii("decriminalization"),
        &[(0b01001, &ENTRY_DECRIMINALIZATION_11495835016656319471)],
    ),
    (
        crate::EncodedStr::Ascii("decriminalizations"),
        &[(0b01001, &ENTRY_DECRIMINALIZATIONS_8826141293763176549)],
    ),
    (
        crate::EncodedStr::Ascii("decriminalize"),
        &[(0b01001, &ENTRY_DECRIMINALIZE_6091198611704708595)],
    ),
    (
        crate::EncodedStr::Ascii("decriminalized"),
        &[(0b01001, &ENTRY_DECRIMINALIZED_14857350688716779167)],
    ),
    (
        crate::EncodedStr::Ascii("decriminalizes"),
        &[(0b01001, &ENTRY_DECRIMINALIZES_6368952306309816010)],
    ),
    (
        crate::EncodedStr::Ascii("decriminalizing"),
        &[(0b01001, &ENTRY_DECRIMINALIZING_16672118604268496422)],
    ),
    (
        crate::EncodedStr::Ascii("dedal"),
        &[(0b00001, &ENTRY_DEDAL_3527172992604688330)],
    ),
    (
        crate::EncodedStr::Ascii("dedalian"),
        &[(0b00001, &ENTRY_DEDALIAN_1818689560079214410)],
    ),
    (
        crate::EncodedStr::Ascii("dedramatise"),
        &[(0b10010, &ENTRY_DEDRAMATIZE_13453343698039522020)],
    ),
    (
        crate::EncodedStr::Ascii("dedramatised"),
        &[(0b10010, &ENTRY_DEDRAMATIZED_322035020814147818)],
    ),
    (
        crate::EncodedStr::Ascii("dedramatises"),
        &[(0b10010, &ENTRY_DEDRAMATIZES_17967690669487003147)],
    ),
    (
        crate::EncodedStr::Ascii("dedramatising"),
        &[(0b10010, &ENTRY_DEDRAMATIZING_62928488875515887)],
    ),
    (
        crate::EncodedStr::Ascii("dedramatize"),
        &[(0b01001, &ENTRY_DEDRAMATIZE_13453343698039522020)],
    ),
    (
        crate::EncodedStr::Ascii("dedramatized"),
        &[(0b01001, &ENTRY_DEDRAMATIZED_322035020814147818)],
    ),
    (
        crate::EncodedStr::Ascii("dedramatizes"),
        &[(0b01001, &ENTRY_DEDRAMATIZES_17967690669487003147)],
    ),
    (
        crate::EncodedStr::Ascii("dedramatizing"),
        &[(0b01001, &ENTRY_DEDRAMATIZING_62928488875515887)],
    ),
    (
        crate::EncodedStr::Ascii("deemphasisation"),
        &[(0b10010, &ENTRY_DEEMPHASIZATION_17228655479618550538)],
    ),
    (
        crate::EncodedStr::Ascii("deemphasise"),
        &[(0b10010, &ENTRY_DEEMPHASIZE_17692949100195205354)],
    ),
    (
        crate::EncodedStr::Ascii("deemphasised"),
        &[(0b10010, &ENTRY_DEEMPHASIZED_14166971579948169339)],
    ),
    (
        crate::EncodedStr::Ascii("deemphasiser"),
        &[(0b10010, &ENTRY_DEEMPHASIZER_2232629022737279052)],
    ),
    (
        crate::EncodedStr::Ascii("deemphasisers"),
        &[(0b10010, &ENTRY_DEEMPHASIZERS_13733231012811038223)],
    ),
    (
        crate::EncodedStr::Ascii("deemphasises"),
        &[(0b10010, &ENTRY_DEEMPHASIZES_13005114554703747835)],
    ),
    (
        crate::EncodedStr::Ascii("deemphasising"),
        &[(0b10010, &ENTRY_DEEMPHASIZING_11093382399783111373)],
    ),
    (
        crate::EncodedStr::Ascii("deemphasization"),
        &[(0b01001, &ENTRY_DEEMPHASIZATION_17228655479618550538)],
    ),
    (
        crate::EncodedStr::Ascii("deemphasize"),
        &[(0b01001, &ENTRY_DEEMPHASIZE_17692949100195205354)],
    ),
    (
        crate::EncodedStr::Ascii("deemphasized"),
        &[(0b01001, &ENTRY_DEEMPHASIZED_14166971579948169339)],
    ),
    (
        crate::EncodedStr::Ascii("deemphasizer"),
        &[(0b01001, &ENTRY_DEEMPHASIZER_2232629022737279052)],
    ),
    (
        crate::EncodedStr::Ascii("deemphasizers"),
        &[(0b01001, &ENTRY_DEEMPHASIZERS_13733231012811038223)],
    ),
    (
        crate::EncodedStr::Ascii("deemphasizes"),
        &[(0b01001, &ENTRY_DEEMPHASIZES_13005114554703747835)],
    ),
    (
        crate::EncodedStr::Ascii("deemphasizing"),
        &[(0b01001, &ENTRY_DEEMPHASIZING_11093382399783111373)],
    ),
    (
        crate::EncodedStr::Ascii("deenergise"),
        &[(0b10010, &ENTRY_DEENERGIZE_12832371231418785666)],
    ),
    (
        crate::EncodedStr::Ascii("deenergised"),
        &[(0b10010, &ENTRY_DEENERGIZED_11846795185389581725)],
    ),
    (
        crate::EncodedStr::Ascii("deenergiser"),
        &[(0b10010, &ENTRY_DEENERGIZER_385500425712909906)],
    ),
    (
        crate::EncodedStr::Ascii("deenergises"),
        &[(0b10010, &ENTRY_DEENERGIZES_12119467381981965243)],
    ),
    (
        crate::EncodedStr::Ascii("deenergising"),
        &[(0b10010, &ENTRY_DEENERGIZING_5214336872196253860)],
    ),
    (
        crate::EncodedStr::Ascii("deenergize"),
        &[(0b01001, &ENTRY_DEENERGIZE_12832371231418785666)],
    ),
    (
        crate::EncodedStr::Ascii("deenergized"),
        &[(0b01001, &ENTRY_DEENERGIZED_11846795185389581725)],
    ),
    (
        crate::EncodedStr::Ascii("deenergizer"),
        &[(0b01001, &ENTRY_DEENERGIZER_385500425712909906)],
    ),
    (
        crate::EncodedStr::Ascii("deenergizes"),
        &[(0b01001, &ENTRY_DEENERGIZES_12119467381981965243)],
    ),
    (
        crate::EncodedStr::Ascii("deenergizing"),
        &[(0b01001, &ENTRY_DEENERGIZING_5214336872196253860)],
    ),
    (
        crate::EncodedStr::Ascii("defedation"),
        &[(0b10001, &ENTRY_DEFEDATION_1250124429421953221)],
    ),
    (
        crate::EncodedStr::Ascii("defeminisation"),
        &[(0b10010, &ENTRY_DEFEMINIZATION_10970895057607673057)],
    ),
    (
        crate::EncodedStr::Ascii("defeminise"),
        &[(0b10010, &ENTRY_DEFEMINIZE_2460703809552770265)],
    ),
    (
        crate::EncodedStr::Ascii("defeminised"),
        &[(0b10010, &ENTRY_DEFEMINIZED_501903520845893607)],
    ),
    (
        crate::EncodedStr::Ascii("defeminises"),
        &[(0b10010, &ENTRY_DEFEMINIZES_13215201164940484905)],
    ),
    (
        crate::EncodedStr::Ascii("defeminising"),
        &[(0b10010, &ENTRY_DEFEMINIZING_2126786312766733725)],
    ),
    (
        crate::EncodedStr::Ascii("defeminization"),
        &[(0b01001, &ENTRY_DEFEMINIZATION_10970895057607673057)],
    ),
    (
        crate::EncodedStr::Ascii("defeminize"),
        &[(0b01001, &ENTRY_DEFEMINIZE_2460703809552770265)],
    ),
    (
        crate::EncodedStr::Ascii("defeminized"),
        &[(0b01001, &ENTRY_DEFEMINIZED_501903520845893607)],
    ),
    (
        crate::EncodedStr::Ascii("defeminizes"),
        &[(0b01001, &ENTRY_DEFEMINIZES_13215201164940484905)],
    ),
    (
        crate::EncodedStr::Ascii("defeminizing"),
        &[(0b01001, &ENTRY_DEFEMINIZING_2126786312766733725)],
    ),
    (
        crate::EncodedStr::Ascii("defence"),
        &[(0b11010, &ENTRY_DEFENSE_11018687793676709280)],
    ),
    (
        crate::EncodedStr::Ascii("defenced"),
        &[(0b11010, &ENTRY_DEFENSED_4741744499926552984)],
    ),
    (
        crate::EncodedStr::Ascii("defenceless"),
        &[(0b11010, &ENTRY_DEFENSELESS_10794271276397387569)],
    ),
    (
        crate::EncodedStr::Ascii("defencelesser"),
        &[(0b11010, &ENTRY_DEFENSELESSER_14429190642942612093)],
    ),
    (
        crate::EncodedStr::Ascii("defencelessest"),
        &[(0b11010, &ENTRY_DEFENSELESSEST_2810886385008994530)],
    ),
    (
        crate::EncodedStr::Ascii("defencelesslier"),
        &[(0b11010, &ENTRY_DEFENSELESSLIER_16858376230646568189)],
    ),
    (
        crate::EncodedStr::Ascii("defencelessliest"),
        &[(0b11010, &ENTRY_DEFENSELESSLIEST_4063724903759190513)],
    ),
    (
        crate::EncodedStr::Ascii("defencelessly"),
        &[(0b11010, &ENTRY_DEFENSELESSLY_14439715594919858663)],
    ),
    (
        crate::EncodedStr::Ascii("defencelessness"),
        &[(0b11010, &ENTRY_DEFENSELESSNESS_12644024888445988945)],
    ),
    (
        crate::EncodedStr::Ascii("defencelessnesses"),
        &[(0b11010, &ENTRY_DEFENSELESSNESSES_18348884860793393516)],
    ),
    (
        crate::EncodedStr::Ascii("defenceman"),
        &[(0b11010, &ENTRY_DEFENSEMAN_4178732654030128668)],
    ),
    (
        crate::EncodedStr::Ascii("defencemen"),
        &[(0b11010, &ENTRY_DEFENSEMEN_13356773840082441675)],
    ),
    (
        crate::EncodedStr::Ascii("defences"),
        &[(0b11010, &ENTRY_DEFENSES_17918359003970109622)],
    ),
    (
        crate::EncodedStr::Ascii("defencing"),
        &[(0b11010, &ENTRY_DEFENSING_13872432362849183791)],
    ),
    (
        crate::EncodedStr::Ascii("defense"),
        &[(0b01001, &ENTRY_DEFENSE_11018687793676709280)],
    ),
    (
        crate::EncodedStr::Ascii("defensed"),
        &[(0b01001, &ENTRY_DEFENSED_4741744499926552984)],
    ),
    (
        crate::EncodedStr::Ascii("defenseless"),
        &[(0b00001, &ENTRY_DEFENSELESS_10794271276397387569)],
    ),
    (
        crate::EncodedStr::Ascii("defenselesser"),
        &[(0b00001, &ENTRY_DEFENSELESSER_14429190642942612093)],
    ),
    (
        crate::EncodedStr::Ascii("defenselessest"),
        &[(0b00001, &ENTRY_DEFENSELESSEST_2810886385008994530)],
    ),
    (
        crate::EncodedStr::Ascii("defenselesslier"),
        &[(0b00001, &ENTRY_DEFENSELESSLIER_16858376230646568189)],
    ),
    (
        crate::EncodedStr::Ascii("defenselessliest"),
        &[(0b00001, &ENTRY_DEFENSELESSLIEST_4063724903759190513)],
    ),
    (
        crate::EncodedStr::Ascii("defenselessly"),
        &[(0b00001, &ENTRY_DEFENSELESSLY_14439715594919858663)],
    ),
    (
        crate::EncodedStr::Ascii("defenselessness"),
        &[(0b00001, &ENTRY_DEFENSELESSNESS_12644024888445988945)],
    ),
    (
        crate::EncodedStr::Ascii("defenselessnesses"),
        &[(0b00001, &ENTRY_DEFENSELESSNESSES_18348884860793393516)],
    ),
    (
        crate::EncodedStr::Ascii("defenseman"),
        &[(0b00001, &ENTRY_DEFENSEMAN_4178732654030128668)],
    ),
    (
        crate::EncodedStr::Ascii("defensemen"),
        &[(0b00001, &ENTRY_DEFENSEMEN_13356773840082441675)],
    ),
    (
        crate::EncodedStr::Ascii("defenses"),
        &[(0b01001, &ENTRY_DEFENSES_17918359003970109622)],
    ),
    (
        crate::EncodedStr::Ascii("defensing"),
        &[(0b01001, &ENTRY_DEFENSING_13872432362849183791)],
    ),
    (
        crate::EncodedStr::Ascii("defeudalise"),
        &[(0b10010, &ENTRY_DEFEUDALIZE_6153813523071316351)],
    ),
    (
        crate::EncodedStr::Ascii("defeudalised"),
        &[(0b10010, &ENTRY_DEFEUDALIZED_10926320617236271428)],
    ),
    (
        crate::EncodedStr::Ascii("defeudalises"),
        &[(0b10010, &ENTRY_DEFEUDALIZES_8548426077225192329)],
    ),
    (
        crate::EncodedStr::Ascii("defeudalising"),
        &[(0b10010, &ENTRY_DEFEUDALIZING_6851219039661107804)],
    ),
    (
        crate::EncodedStr::Ascii("defeudalize"),
        &[(0b01001, &ENTRY_DEFEUDALIZE_6153813523071316351)],
    ),
    (
        crate::EncodedStr::Ascii("defeudalized"),
        &[(0b01001, &ENTRY_DEFEUDALIZED_10926320617236271428)],
    ),
    (
        crate::EncodedStr::Ascii("defeudalizes"),
        &[(0b01001, &ENTRY_DEFEUDALIZES_8548426077225192329)],
    ),
    (
        crate::EncodedStr::Ascii("defeudalizing"),
        &[(0b01001, &ENTRY_DEFEUDALIZING_6851219039661107804)],
    ),
    (
        crate::EncodedStr::Ascii("defibrinise"),
        &[(0b10010, &ENTRY_DEFIBRINIZE_18283930865175559011)],
    ),
    (
        crate::EncodedStr::Ascii("defibrinised"),
        &[(0b10010, &ENTRY_DEFIBRINIZED_142002320112068005)],
    ),
    (
        crate::EncodedStr::Ascii("defibrinises"),
        &[(0b10010, &ENTRY_DEFIBRINIZES_7864712038065216074)],
    ),
    (
        crate::EncodedStr::Ascii("defibrinising"),
        &[(0b10010, &ENTRY_DEFIBRINIZING_15126402992130628305)],
    ),
    (
        crate::EncodedStr::Ascii("defibrinize"),
        &[(0b01001, &ENTRY_DEFIBRINIZE_18283930865175559011)],
    ),
    (
        crate::EncodedStr::Ascii("defibrinized"),
        &[(0b01001, &ENTRY_DEFIBRINIZED_142002320112068005)],
    ),
    (
        crate::EncodedStr::Ascii("defibrinizes"),
        &[(0b01001, &ENTRY_DEFIBRINIZES_7864712038065216074)],
    ),
    (
        crate::EncodedStr::Ascii("defibrinizing"),
        &[(0b01001, &ENTRY_DEFIBRINIZING_15126402992130628305)],
    ),
    (
        crate::EncodedStr::Ascii("definitisation"),
        &[(0b10010, &ENTRY_DEFINITIZATION_7958601692772655221)],
    ),
    (
        crate::EncodedStr::Ascii("definitisations"),
        &[(0b10010, &ENTRY_DEFINITIZATIONS_2927011527962264879)],
    ),
    (
        crate::EncodedStr::Ascii("definitise"),
        &[(0b10010, &ENTRY_DEFINITIZE_13578665782923325519)],
    ),
    (
        crate::EncodedStr::Ascii("definitised"),
        &[(0b10010, &ENTRY_DEFINITIZED_9429215788712667143)],
    ),
    (
        crate::EncodedStr::Ascii("definitises"),
        &[(0b10010, &ENTRY_DEFINITIZES_5808003072438523190)],
    ),
    (
        crate::EncodedStr::Ascii("definitising"),
        &[(0b10010, &ENTRY_DEFINITIZING_17784497757438565701)],
    ),
    (
        crate::EncodedStr::Ascii("definitization"),
        &[(0b01001, &ENTRY_DEFINITIZATION_7958601692772655221)],
    ),
    (
        crate::EncodedStr::Ascii("definitizations"),
        &[(0b01001, &ENTRY_DEFINITIZATIONS_2927011527962264879)],
    ),
    (
        crate::EncodedStr::Ascii("definitize"),
        &[(0b01001, &ENTRY_DEFINITIZE_13578665782923325519)],
    ),
    (
        crate::EncodedStr::Ascii("definitized"),
        &[(0b01001, &ENTRY_DEFINITIZED_9429215788712667143)],
    ),
    (
        crate::EncodedStr::Ascii("definitizes"),
        &[(0b01001, &ENTRY_DEFINITIZES_5808003072438523190)],
    ),
    (
        crate::EncodedStr::Ascii("definitizing"),
        &[(0b01001, &ENTRY_DEFINITIZING_17784497757438565701)],
    ),
    (
        crate::EncodedStr::Ascii("deflectionisation"),
        &[(0b10010, &ENTRY_DEFLECTIONIZATION_11878097824098112217)],
    ),
    (
        crate::EncodedStr::Ascii("deflectionisations"),
        &[(0b10010, &ENTRY_DEFLECTIONIZATIONS_17851027536180674050)],
    ),
    (
        crate::EncodedStr::Ascii("deflectionise"),
        &[(0b10010, &ENTRY_DEFLECTIONIZE_3095690419241116219)],
    ),
    (
        crate::EncodedStr::Ascii("deflectionises"),
        &[(0b10010, &ENTRY_DEFLECTIONIZES_6073384244042155810)],
    ),
    (
        crate::EncodedStr::Ascii("deflectionization"),
        &[(0b01001, &ENTRY_DEFLECTIONIZATION_11878097824098112217)],
    ),
    (
        crate::EncodedStr::Ascii("deflectionizations"),
        &[(0b01001, &ENTRY_DEFLECTIONIZATIONS_17851027536180674050)],
    ),
    (
        crate::EncodedStr::Ascii("deflectionize"),
        &[(0b01001, &ENTRY_DEFLECTIONIZE_3095690419241116219)],
    ),
    (
        crate::EncodedStr::Ascii("deflectionizes"),
        &[(0b01001, &ENTRY_DEFLECTIONIZES_6073384244042155810)],
    ),
    (
        crate::EncodedStr::Ascii("defoedation"),
        &[(0b11010, &ENTRY_DEFEDATION_1250124429421953221)],
    ),
    (
        crate::EncodedStr::Ascii("deformalise"),
        &[(0b10010, &ENTRY_DEFORMALIZE_15907382900288731005)],
    ),
    (
        crate::EncodedStr::Ascii("deformalize"),
        &[(0b01001, &ENTRY_DEFORMALIZE_15907382900288731005)],
    ),
    (
        crate::EncodedStr::Ascii("defunctionalisation"),
        &[(0b10010, &ENTRY_DEFUNCTIONALIZATION_13807631024565298493)],
    ),
    (
        crate::EncodedStr::Ascii("defunctionalisations"),
        &[(0b10010, &ENTRY_DEFUNCTIONALIZATIONS_13484968269526464929)],
    ),
    (
        crate::EncodedStr::Ascii("defunctionalise"),
        &[(0b10010, &ENTRY_DEFUNCTIONALIZE_3067764666659364877)],
    ),
    (
        crate::EncodedStr::Ascii("defunctionalises"),
        &[(0b10010, &ENTRY_DEFUNCTIONALIZES_2354126124027039718)],
    ),
    (
        crate::EncodedStr::Ascii("defunctionalization"),
        &[(0b01001, &ENTRY_DEFUNCTIONALIZATION_13807631024565298493)],
    ),
    (
        crate::EncodedStr::Ascii("defunctionalizations"),
        &[(0b01001, &ENTRY_DEFUNCTIONALIZATIONS_13484968269526464929)],
    ),
    (
        crate::EncodedStr::Ascii("defunctionalize"),
        &[(0b01001, &ENTRY_DEFUNCTIONALIZE_3067764666659364877)],
    ),
    (
        crate::EncodedStr::Ascii("defunctionalizes"),
        &[(0b01001, &ENTRY_DEFUNCTIONALIZES_2354126124027039718)],
    ),
    (
        crate::EncodedStr::Ascii("deglycerolised"),
        &[(0b10010, &ENTRY_DEGLYCEROLIZED_5620184830818473145)],
    ),
    (
        crate::EncodedStr::Ascii("deglycerolized"),
        &[(0b01001, &ENTRY_DEGLYCEROLIZED_5620184830818473145)],
    ),
    (
        crate::EncodedStr::Ascii("dehumanisation"),
        &[(0b10010, &ENTRY_DEHUMANIZATION_3572788173744551934)],
    ),
    (
        crate::EncodedStr::Ascii("dehumanisations"),
        &[(0b10010, &ENTRY_DEHUMANIZATIONS_6897797502184645692)],
    ),
    (
        crate::EncodedStr::Ascii("dehumanise"),
        &[(0b10010, &ENTRY_DEHUMANIZE_2232272408872299361)],
    ),
    (
        crate::EncodedStr::Ascii("dehumanised"),
        &[(0b10010, &ENTRY_DEHUMANIZED_2513733723938163946)],
    ),
    (
        crate::EncodedStr::Ascii("dehumanises"),
        &[(0b10010, &ENTRY_DEHUMANIZES_79010027424209477)],
    ),
    (
        crate::EncodedStr::Ascii("dehumanising"),
        &[(0b10010, &ENTRY_DEHUMANIZING_18121800466455281577)],
    ),
    (
        crate::EncodedStr::Ascii("dehumanization"),
        &[(0b01001, &ENTRY_DEHUMANIZATION_3572788173744551934)],
    ),
    (
        crate::EncodedStr::Ascii("dehumanizations"),
        &[(0b01001, &ENTRY_DEHUMANIZATIONS_6897797502184645692)],
    ),
    (
        crate::EncodedStr::Ascii("dehumanize"),
        &[(0b01001, &ENTRY_DEHUMANIZE_2232272408872299361)],
    ),
    (
        crate::EncodedStr::Ascii("dehumanized"),
        &[(0b01001, &ENTRY_DEHUMANIZED_2513733723938163946)],
    ),
    (
        crate::EncodedStr::Ascii("dehumanizes"),
        &[(0b01001, &ENTRY_DEHUMANIZES_79010027424209477)],
    ),
    (
        crate::EncodedStr::Ascii("dehumanizing"),
        &[(0b01001, &ENTRY_DEHUMANIZING_18121800466455281577)],
    ),
    (
        crate::EncodedStr::Ascii("dehydrogenisation"),
        &[(0b10010, &ENTRY_DEHYDROGENIZATION_17529379708129741720)],
    ),
    (
        crate::EncodedStr::Ascii("dehydrogenise"),
        &[(0b10010, &ENTRY_DEHYDROGENIZE_7036691670691764716)],
    ),
    (
        crate::EncodedStr::Ascii("dehydrogenised"),
        &[(0b10010, &ENTRY_DEHYDROGENIZED_4042573802152435240)],
    ),
    (
        crate::EncodedStr::Ascii("dehydrogeniser"),
        &[(0b10010, &ENTRY_DEHYDROGENIZER_8525507183037678721)],
    ),
    (
        crate::EncodedStr::Ascii("dehydrogenising"),
        &[(0b10010, &ENTRY_DEHYDROGENIZING_5974089619476922717)],
    ),
    (
        crate::EncodedStr::Ascii("dehydrogenization"),
        &[(0b01001, &ENTRY_DEHYDROGENIZATION_17529379708129741720)],
    ),
    (
        crate::EncodedStr::Ascii("dehydrogenize"),
        &[(0b01001, &ENTRY_DEHYDROGENIZE_7036691670691764716)],
    ),
    (
        crate::EncodedStr::Ascii("dehydrogenized"),
        &[(0b01001, &ENTRY_DEHYDROGENIZED_4042573802152435240)],
    ),
    (
        crate::EncodedStr::Ascii("dehydrogenizer"),
        &[(0b01001, &ENTRY_DEHYDROGENIZER_8525507183037678721)],
    ),
    (
        crate::EncodedStr::Ascii("dehydrogenizing"),
        &[(0b01001, &ENTRY_DEHYDROGENIZING_5974089619476922717)],
    ),
    (
        crate::EncodedStr::Ascii("dehypnotisation"),
        &[(0b10010, &ENTRY_DEHYPNOTIZATION_12210599348961381724)],
    ),
    (
        crate::EncodedStr::Ascii("dehypnotisations"),
        &[(0b10010, &ENTRY_DEHYPNOTIZATIONS_4718849388849423582)],
    ),
    (
        crate::EncodedStr::Ascii("dehypnotise"),
        &[(0b10010, &ENTRY_DEHYPNOTIZE_10726010356831719725)],
    ),
    (
        crate::EncodedStr::Ascii("dehypnotised"),
        &[(0b10010, &ENTRY_DEHYPNOTIZED_6695632276418370962)],
    ),
    (
        crate::EncodedStr::Ascii("dehypnotises"),
        &[(0b10010, &ENTRY_DEHYPNOTIZES_6146772561847797201)],
    ),
    (
        crate::EncodedStr::Ascii("dehypnotising"),
        &[(0b10010, &ENTRY_DEHYPNOTIZING_12455661718180344756)],
    ),
    (
        crate::EncodedStr::Ascii("dehypnotization"),
        &[(0b01001, &ENTRY_DEHYPNOTIZATION_12210599348961381724)],
    ),
    (
        crate::EncodedStr::Ascii("dehypnotizations"),
        &[(0b01001, &ENTRY_DEHYPNOTIZATIONS_4718849388849423582)],
    ),
    (
        crate::EncodedStr::Ascii("dehypnotize"),
        &[(0b01001, &ENTRY_DEHYPNOTIZE_10726010356831719725)],
    ),
    (
        crate::EncodedStr::Ascii("dehypnotized"),
        &[(0b01001, &ENTRY_DEHYPNOTIZED_6695632276418370962)],
    ),
    (
        crate::EncodedStr::Ascii("dehypnotizes"),
        &[(0b01001, &ENTRY_DEHYPNOTIZES_6146772561847797201)],
    ),
    (
        crate::EncodedStr::Ascii("dehypnotizing"),
        &[(0b01001, &ENTRY_DEHYPNOTIZING_12455661718180344756)],
    ),
    (
        crate::EncodedStr::Ascii("deindustrialisation"),
        &[(0b10010, &ENTRY_DEINDUSTRIALIZATION_14471451768199148096)],
    ),
    (
        crate::EncodedStr::Ascii("deindustrialisations"),
        &[(0b10010, &ENTRY_DEINDUSTRIALIZATIONS_15910460441488223406)],
    ),
    (
        crate::EncodedStr::Ascii("deindustrialise"),
        &[(0b10010, &ENTRY_DEINDUSTRIALIZE_15995862968967762494)],
    ),
    (
        crate::EncodedStr::Ascii("deindustrialised"),
        &[(0b10010, &ENTRY_DEINDUSTRIALIZED_1125754572889024423)],
    ),
    (
        crate::EncodedStr::Ascii("deindustrialises"),
        &[(0b10010, &ENTRY_DEINDUSTRIALIZES_13990996861462469130)],
    ),
    (
        crate::EncodedStr::Ascii("deindustrialising"),
        &[(0b10010, &ENTRY_DEINDUSTRIALIZING_3929932887349601221)],
    ),
    (
        crate::EncodedStr::Ascii("deindustrialization"),
        &[(0b01001, &ENTRY_DEINDUSTRIALIZATION_14471451768199148096)],
    ),
    (
        crate::EncodedStr::Ascii("deindustrializations"),
        &[(0b01001, &ENTRY_DEINDUSTRIALIZATIONS_15910460441488223406)],
    ),
    (
        crate::EncodedStr::Ascii("deindustrialize"),
        &[(0b01001, &ENTRY_DEINDUSTRIALIZE_15995862968967762494)],
    ),
    (
        crate::EncodedStr::Ascii("deindustrialized"),
        &[(0b01001, &ENTRY_DEINDUSTRIALIZED_1125754572889024423)],
    ),
    (
        crate::EncodedStr::Ascii("deindustrializes"),
        &[(0b01001, &ENTRY_DEINDUSTRIALIZES_13990996861462469130)],
    ),
    (
        crate::EncodedStr::Ascii("deindustrializing"),
        &[(0b01001, &ENTRY_DEINDUSTRIALIZING_3929932887349601221)],
    ),
    (
        crate::EncodedStr::Ascii("deionisation"),
        &[(0b10010, &ENTRY_DEIONIZATION_18037411003245501415)],
    ),
    (
        crate::EncodedStr::Ascii("deionise"),
        &[(0b10010, &ENTRY_DEIONIZE_3742251118696055698)],
    ),
    (
        crate::EncodedStr::Ascii("deionised"),
        &[(0b10010, &ENTRY_DEIONIZED_18147519954228604298)],
    ),
    (
        crate::EncodedStr::Ascii("deionises"),
        &[(0b10010, &ENTRY_DEIONIZES_2511822428052345171)],
    ),
    (
        crate::EncodedStr::Ascii("deionising"),
        &[(0b10010, &ENTRY_DEIONIZING_3409760745768493185)],
    ),
    (
        crate::EncodedStr::Ascii("deionization"),
        &[(0b01001, &ENTRY_DEIONIZATION_18037411003245501415)],
    ),
    (
        crate::EncodedStr::Ascii("deionize"),
        &[(0b01001, &ENTRY_DEIONIZE_3742251118696055698)],
    ),
    (
        crate::EncodedStr::Ascii("deionized"),
        &[(0b01001, &ENTRY_DEIONIZED_18147519954228604298)],
    ),
    (
        crate::EncodedStr::Ascii("deionizes"),
        &[(0b01001, &ENTRY_DEIONIZES_2511822428052345171)],
    ),
    (
        crate::EncodedStr::Ascii("deionizing"),
        &[(0b01001, &ENTRY_DEIONIZING_3409760745768493185)],
    ),
    (
        crate::EncodedStr::Ascii("dekagramme"),
        &[(0b10010, &ENTRY_DEKAGRAM_12670145940876311522)],
    ),
    (
        crate::EncodedStr::Ascii("dekagrammes"),
        &[(0b10010, &ENTRY_DEKAGRAMS_16794902135907120348)],
    ),
    (
        crate::EncodedStr::Ascii("dekaliter"),
        &[(0b00001, &ENTRY_DEKALITER_3783941176090837116)],
    ),
    (
        crate::EncodedStr::Ascii("dekaliters"),
        &[(0b00001, &ENTRY_DEKALITERS_8450766135929935128)],
    ),
    (
        crate::EncodedStr::Ascii("dekalitre"),
        &[(0b11010, &ENTRY_DEKALITER_3783941176090837116)],
    ),
    (
        crate::EncodedStr::Ascii("dekalitres"),
        &[(0b11010, &ENTRY_DEKALITERS_8450766135929935128)],
    ),
    (
        crate::EncodedStr::Ascii("dekameter"),
        &[(0b00001, &ENTRY_DEKAMETER_12894292200985003434)],
    ),
    (
        crate::EncodedStr::Ascii("dekameters"),
        &[(0b00001, &ENTRY_DEKAMETERS_17531050124125527369)],
    ),
    (
        crate::EncodedStr::Ascii("dekametre"),
        &[(0b11010, &ENTRY_DEKAMETER_12894292200985003434)],
    ),
    (
        crate::EncodedStr::Ascii("dekametres"),
        &[(0b11010, &ENTRY_DEKAMETERS_17531050124125527369)],
    ),
    (
        crate::EncodedStr::Ascii("delimitise"),
        &[(0b10010, &ENTRY_DELIMITIZE_16541986644088610431)],
    ),
    (
        crate::EncodedStr::Ascii("delimitises"),
        &[(0b10010, &ENTRY_DELIMITIZES_8971276824870720345)],
    ),
    (
        crate::EncodedStr::Ascii("delimitize"),
        &[(0b01001, &ENTRY_DELIMITIZE_16541986644088610431)],
    ),
    (
        crate::EncodedStr::Ascii("delimitizes"),
        &[(0b01001, &ENTRY_DELIMITIZES_8971276824870720345)],
    ),
    (
        crate::EncodedStr::Ascii("delocalisation"),
        &[(0b10010, &ENTRY_DELOCALIZATION_4312310346451666001)],
    ),
    (
        crate::EncodedStr::Ascii("delocalisations"),
        &[(0b10010, &ENTRY_DELOCALIZATIONS_460587193756388712)],
    ),
    (
        crate::EncodedStr::Ascii("delocalise"),
        &[(0b10010, &ENTRY_DELOCALIZE_142384639921788725)],
    ),
    (
        crate::EncodedStr::Ascii("delocalised"),
        &[(0b10010, &ENTRY_DELOCALIZED_6707490578440021648)],
    ),
    (
        crate::EncodedStr::Ascii("delocalises"),
        &[(0b10010, &ENTRY_DELOCALIZES_15812480500294999003)],
    ),
    (
        crate::EncodedStr::Ascii("delocalising"),
        &[(0b10010, &ENTRY_DELOCALIZING_11766970531294712613)],
    ),
    (
        crate::EncodedStr::Ascii("delocalization"),
        &[(0b01001, &ENTRY_DELOCALIZATION_4312310346451666001)],
    ),
    (
        crate::EncodedStr::Ascii("delocalizations"),
        &[(0b01001, &ENTRY_DELOCALIZATIONS_460587193756388712)],
    ),
    (
        crate::EncodedStr::Ascii("delocalize"),
        &[(0b01001, &ENTRY_DELOCALIZE_142384639921788725)],
    ),
    (
        crate::EncodedStr::Ascii("delocalized"),
        &[(0b01001, &ENTRY_DELOCALIZED_6707490578440021648)],
    ),
    (
        crate::EncodedStr::Ascii("delocalizes"),
        &[(0b01001, &ENTRY_DELOCALIZES_15812480500294999003)],
    ),
    (
        crate::EncodedStr::Ascii("delocalizing"),
        &[(0b01001, &ENTRY_DELOCALIZING_11766970531294712613)],
    ),
    (
        crate::EncodedStr::Ascii("deluster"),
        &[(0b00001, &ENTRY_DELUSTER_14098580558613886243)],
    ),
    (
        crate::EncodedStr::Ascii("delustre"),
        &[(0b11010, &ENTRY_DELUSTER_14098580558613886243)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetisable"),
        &[(0b10010, &ENTRY_DEMAGNETIZABLE_2829745576751479415)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetisabler"),
        &[(0b10010, &ENTRY_DEMAGNETIZABLER_14067236382470080700)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetisables"),
        &[(0b10010, &ENTRY_DEMAGNETIZABLES_17349604975000267862)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetisablest"),
        &[(0b10010, &ENTRY_DEMAGNETIZABLEST_231408157539452152)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetisation"),
        &[(0b10010, &ENTRY_DEMAGNETIZATION_10848943172388045538)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetisations"),
        &[(0b10010, &ENTRY_DEMAGNETIZATIONS_17906684919392124321)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetise"),
        &[(0b10010, &ENTRY_DEMAGNETIZE_17682740839823545869)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetised"),
        &[(0b10010, &ENTRY_DEMAGNETIZED_429555390860227118)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetiser"),
        &[(0b10010, &ENTRY_DEMAGNETIZER_7369266141467515452)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetisers"),
        &[(0b10010, &ENTRY_DEMAGNETIZERS_3139106218193590904)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetises"),
        &[(0b10010, &ENTRY_DEMAGNETIZES_2351872097402777148)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetising"),
        &[(0b10010, &ENTRY_DEMAGNETIZING_14763681981656800434)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetizable"),
        &[(0b01001, &ENTRY_DEMAGNETIZABLE_2829745576751479415)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetizabler"),
        &[(0b01001, &ENTRY_DEMAGNETIZABLER_14067236382470080700)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetizables"),
        &[(0b01001, &ENTRY_DEMAGNETIZABLES_17349604975000267862)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetizablest"),
        &[(0b01001, &ENTRY_DEMAGNETIZABLEST_231408157539452152)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetization"),
        &[(0b01001, &ENTRY_DEMAGNETIZATION_10848943172388045538)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetizations"),
        &[(0b01001, &ENTRY_DEMAGNETIZATIONS_17906684919392124321)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetize"),
        &[(0b01001, &ENTRY_DEMAGNETIZE_17682740839823545869)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetized"),
        &[(0b01001, &ENTRY_DEMAGNETIZED_429555390860227118)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetizer"),
        &[(0b01001, &ENTRY_DEMAGNETIZER_7369266141467515452)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetizers"),
        &[(0b01001, &ENTRY_DEMAGNETIZERS_3139106218193590904)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetizes"),
        &[(0b01001, &ENTRY_DEMAGNETIZES_2351872097402777148)],
    ),
    (
        crate::EncodedStr::Ascii("demagnetizing"),
        &[(0b01001, &ENTRY_DEMAGNETIZING_14763681981656800434)],
    ),
    (
        crate::EncodedStr::Ascii("demagog"),
        &[(0b00001, &ENTRY_DEMAGOGUE_5181969032657952767)],
    ),
    (
        crate::EncodedStr::Ascii("demagoged"),
        &[(0b00001, &ENTRY_DEMAGOGUED_8161585994268339914)],
    ),
    (
        crate::EncodedStr::Ascii("demagoging"),
        &[(0b00001, &ENTRY_DEMAGOGUING_1728340214383068433)],
    ),
    (
        crate::EncodedStr::Ascii("demagogry"),
        &[(0b00001, &ENTRY_DEMAGOGUERY_18141115406054203519)],
    ),
    (
        crate::EncodedStr::Ascii("demagogs"),
        &[(0b00001, &ENTRY_DEMAGOGUES_12777890380184860275)],
    ),
    (
        crate::EncodedStr::Ascii("demasculinisation"),
        &[(0b10010, &ENTRY_DEMASCULINIZATION_3144268104204565212)],
    ),
    (
        crate::EncodedStr::Ascii("demasculinise"),
        &[(0b10010, &ENTRY_DEMASCULINIZE_10705941850922882000)],
    ),
    (
        crate::EncodedStr::Ascii("demasculinised"),
        &[(0b10010, &ENTRY_DEMASCULINIZED_14641565565158279941)],
    ),
    (
        crate::EncodedStr::Ascii("demasculinising"),
        &[(0b10010, &ENTRY_DEMASCULINIZING_2815690345809976595)],
    ),
    (
        crate::EncodedStr::Ascii("demasculinization"),
        &[(0b01001, &ENTRY_DEMASCULINIZATION_3144268104204565212)],
    ),
    (
        crate::EncodedStr::Ascii("demasculinize"),
        &[(0b01001, &ENTRY_DEMASCULINIZE_10705941850922882000)],
    ),
    (
        crate::EncodedStr::Ascii("demasculinized"),
        &[(0b01001, &ENTRY_DEMASCULINIZED_14641565565158279941)],
    ),
    (
        crate::EncodedStr::Ascii("demasculinizing"),
        &[(0b01001, &ENTRY_DEMASCULINIZING_2815690345809976595)],
    ),
    (
        crate::EncodedStr::Ascii("dematerialisation"),
        &[(0b10010, &ENTRY_DEMATERIALIZATION_12365708154794235297)],
    ),
    (
        crate::EncodedStr::Ascii("dematerialisations"),
        &[(0b10010, &ENTRY_DEMATERIALIZATIONS_3461546780666068183)],
    ),
    (
        crate::EncodedStr::Ascii("dematerialise"),
        &[(0b10010, &ENTRY_DEMATERIALIZE_204119081752940756)],
    ),
    (
        crate::EncodedStr::Ascii("dematerialised"),
        &[(0b10010, &ENTRY_DEMATERIALIZED_7148599036847365626)],
    ),
    (
        crate::EncodedStr::Ascii("dematerialises"),
        &[(0b10010, &ENTRY_DEMATERIALIZES_17865238971422686230)],
    ),
    (
        crate::EncodedStr::Ascii("dematerialising"),
        &[(0b10010, &ENTRY_DEMATERIALIZING_10155714463244702927)],
    ),
    (
        crate::EncodedStr::Ascii("dematerialization"),
        &[(0b01001, &ENTRY_DEMATERIALIZATION_12365708154794235297)],
    ),
    (
        crate::EncodedStr::Ascii("dematerializations"),
        &[(0b01001, &ENTRY_DEMATERIALIZATIONS_3461546780666068183)],
    ),
    (
        crate::EncodedStr::Ascii("dematerialize"),
        &[(0b01001, &ENTRY_DEMATERIALIZE_204119081752940756)],
    ),
    (
        crate::EncodedStr::Ascii("dematerialized"),
        &[(0b01001, &ENTRY_DEMATERIALIZED_7148599036847365626)],
    ),
    (
        crate::EncodedStr::Ascii("dematerializes"),
        &[(0b01001, &ENTRY_DEMATERIALIZES_17865238971422686230)],
    ),
    (
        crate::EncodedStr::Ascii("dematerializing"),
        &[(0b01001, &ENTRY_DEMATERIALIZING_10155714463244702927)],
    ),
    (
        crate::EncodedStr::Ascii("demeanor"),
        &[(0b11001, &ENTRY_DEMEANOR_13927976893530181065)],
    ),
    (
        crate::EncodedStr::Ascii("demeanors"),
        &[(0b11001, &ENTRY_DEMEANORS_15645246800979825016)],
    ),
    (
        crate::EncodedStr::Ascii("demeanour"),
        &[(0b11010, &ENTRY_DEMEANOR_13927976893530181065)],
    ),
    (
        crate::EncodedStr::Ascii("demeanours"),
        &[(0b11010, &ENTRY_DEMEANORS_15645246800979825016)],
    ),
    (
        crate::EncodedStr::Ascii("demilitarisation"),
        &[(0b10010, &ENTRY_DEMILITARIZATION_1830348363036337787)],
    ),
    (
        crate::EncodedStr::Ascii("demilitarisations"),
        &[(0b10010, &ENTRY_DEMILITARIZATIONS_12252664721077083328)],
    ),
    (
        crate::EncodedStr::Ascii("demilitarise"),
        &[(0b10010, &ENTRY_DEMILITARIZE_16703679582695532386)],
    ),
    (
        crate::EncodedStr::Ascii("demilitarised"),
        &[(0b10010, &ENTRY_DEMILITARIZED_7958961857075865134)],
    ),
    (
        crate::EncodedStr::Ascii("demilitarises"),
        &[(0b10010, &ENTRY_DEMILITARIZES_17566131017554380497)],
    ),
    (
        crate::EncodedStr::Ascii("demilitarising"),
        &[(0b10010, &ENTRY_DEMILITARIZING_5137023236614361970)],
    ),
    (
        crate::EncodedStr::Ascii("demilitarization"),
        &[(0b01001, &ENTRY_DEMILITARIZATION_1830348363036337787)],
    ),
    (
        crate::EncodedStr::Ascii("demilitarizations"),
        &[(0b01001, &ENTRY_DEMILITARIZATIONS_12252664721077083328)],
    ),
    (
        crate::EncodedStr::Ascii("demilitarize"),
        &[(0b01001, &ENTRY_DEMILITARIZE_16703679582695532386)],
    ),
    (
        crate::EncodedStr::Ascii("demilitarized"),
        &[(0b01001, &ENTRY_DEMILITARIZED_7958961857075865134)],
    ),
    (
        crate::EncodedStr::Ascii("demilitarizes"),
        &[(0b01001, &ENTRY_DEMILITARIZES_17566131017554380497)],
    ),
    (
        crate::EncodedStr::Ascii("demilitarizing"),
        &[(0b01001, &ENTRY_DEMILITARIZING_5137023236614361970)],
    ),
    (
        crate::EncodedStr::Ascii("demiluster"),
        &[(0b00001, &ENTRY_DEMILUSTER_18156742814546492480)],
    ),
    (
        crate::EncodedStr::Ascii("demilustre"),
        &[(0b11010, &ENTRY_DEMILUSTER_18156742814546492480)],
    ),
    (
        crate::EncodedStr::Ascii("demineralisation"),
        &[(0b10010, &ENTRY_DEMINERALIZATION_11860382402591403329)],
    ),
    (
        crate::EncodedStr::Ascii("demineralisations"),
        &[(0b10010, &ENTRY_DEMINERALIZATIONS_9687527290224020253)],
    ),
    (
        crate::EncodedStr::Ascii("demineralise"),
        &[(0b10010, &ENTRY_DEMINERALIZE_2028750406115400134)],
    ),
    (
        crate::EncodedStr::Ascii("demineralised"),
        &[(0b10010, &ENTRY_DEMINERALIZED_417389536885991347)],
    ),
    (
        crate::EncodedStr::Ascii("demineraliser"),
        &[(0b10010, &ENTRY_DEMINERALIZER_11839062214960881518)],
    ),
    (
        crate::EncodedStr::Ascii("demineralises"),
        &[(0b10010, &ENTRY_DEMINERALIZES_10853907656124140046)],
    ),
    (
        crate::EncodedStr::Ascii("demineralising"),
        &[(0b10010, &ENTRY_DEMINERALIZING_8656195446853674994)],
    ),
    (
        crate::EncodedStr::Ascii("demineralization"),
        &[(0b01001, &ENTRY_DEMINERALIZATION_11860382402591403329)],
    ),
    (
        crate::EncodedStr::Ascii("demineralizations"),
        &[(0b01001, &ENTRY_DEMINERALIZATIONS_9687527290224020253)],
    ),
    (
        crate::EncodedStr::Ascii("demineralize"),
        &[(0b01001, &ENTRY_DEMINERALIZE_2028750406115400134)],
    ),
    (
        crate::EncodedStr::Ascii("demineralized"),
        &[(0b01001, &ENTRY_DEMINERALIZED_417389536885991347)],
    ),
    (
        crate::EncodedStr::Ascii("demineralizer"),
        &[(0b01001, &ENTRY_DEMINERALIZER_11839062214960881518)],
    ),
    (
        crate::EncodedStr::Ascii("demineralizes"),
        &[(0b01001, &ENTRY_DEMINERALIZES_10853907656124140046)],
    ),
    (
        crate::EncodedStr::Ascii("demineralizing"),
        &[(0b01001, &ENTRY_DEMINERALIZING_8656195446853674994)],
    ),
    (
        crate::EncodedStr::Ascii("demobilisation"),
        &[(0b10010, &ENTRY_DEMOBILIZATION_8427760600922715154)],
    ),
    (
        crate::EncodedStr::Ascii("demobilisations"),
        &[(0b10010, &ENTRY_DEMOBILIZATIONS_6851457664741914489)],
    ),
    (
        crate::EncodedStr::Ascii("demobilise"),
        &[(0b10010, &ENTRY_DEMOBILIZE_7893368911880481234)],
    ),
    (
        crate::EncodedStr::Ascii("demobilised"),
        &[(0b10010, &ENTRY_DEMOBILIZED_9206102949665526961)],
    ),
    (
        crate::EncodedStr::Ascii("demobilises"),
        &[(0b10010, &ENTRY_DEMOBILIZES_9950566876349545979)],
    ),
    (
        crate::EncodedStr::Ascii("demobilising"),
        &[(0b10010, &ENTRY_DEMOBILIZING_2666589548621520076)],
    ),
    (
        crate::EncodedStr::Ascii("demobilization"),
        &[(0b01001, &ENTRY_DEMOBILIZATION_8427760600922715154)],
    ),
    (
        crate::EncodedStr::Ascii("demobilizations"),
        &[(0b01001, &ENTRY_DEMOBILIZATIONS_6851457664741914489)],
    ),
    (
        crate::EncodedStr::Ascii("demobilize"),
        &[(0b01001, &ENTRY_DEMOBILIZE_7893368911880481234)],
    ),
    (
        crate::EncodedStr::Ascii("demobilized"),
        &[(0b01001, &ENTRY_DEMOBILIZED_9206102949665526961)],
    ),
    (
        crate::EncodedStr::Ascii("demobilizes"),
        &[(0b01001, &ENTRY_DEMOBILIZES_9950566876349545979)],
    ),
    (
        crate::EncodedStr::Ascii("demobilizing"),
        &[(0b01001, &ENTRY_DEMOBILIZING_2666589548621520076)],
    ),
    (
        crate::EncodedStr::Ascii("democratisation"),
        &[(0b10010, &ENTRY_DEMOCRATIZATION_17254764392338903283)],
    ),
    (
        crate::EncodedStr::Ascii("democratisations"),
        &[(0b10010, &ENTRY_DEMOCRATIZATIONS_4388695499854265807)],
    ),
    (
        crate::EncodedStr::Ascii("democratise"),
        &[(0b10010, &ENTRY_DEMOCRATIZE_10194385791283666571)],
    ),
    (
        crate::EncodedStr::Ascii("democratised"),
        &[(0b10010, &ENTRY_DEMOCRATIZED_18121735197237538789)],
    ),
    (
        crate::EncodedStr::Ascii("democratiser"),
        &[(0b10010, &ENTRY_DEMOCRATIZER_15492342920596234152)],
    ),
    (
        crate::EncodedStr::Ascii("democratises"),
        &[(0b10010, &ENTRY_DEMOCRATIZES_11290287892884717824)],
    ),
    (
        crate::EncodedStr::Ascii("democratising"),
        &[(0b10010, &ENTRY_DEMOCRATIZING_5756319688655505152)],
    ),
    (
        crate::EncodedStr::Ascii("democratization"),
        &[(0b01001, &ENTRY_DEMOCRATIZATION_17254764392338903283)],
    ),
    (
        crate::EncodedStr::Ascii("democratizations"),
        &[(0b01001, &ENTRY_DEMOCRATIZATIONS_4388695499854265807)],
    ),
    (
        crate::EncodedStr::Ascii("democratize"),
        &[(0b01001, &ENTRY_DEMOCRATIZE_10194385791283666571)],
    ),
    (
        crate::EncodedStr::Ascii("democratized"),
        &[(0b01001, &ENTRY_DEMOCRATIZED_18121735197237538789)],
    ),
    (
        crate::EncodedStr::Ascii("democratizer"),
        &[(0b01001, &ENTRY_DEMOCRATIZER_15492342920596234152)],
    ),
    (
        crate::EncodedStr::Ascii("democratizes"),
        &[(0b01001, &ENTRY_DEMOCRATIZES_11290287892884717824)],
    ),
    (
        crate::EncodedStr::Ascii("democratizing"),
        &[(0b01001, &ENTRY_DEMOCRATIZING_5756319688655505152)],
    ),
    (
        crate::EncodedStr::Ascii("demonetisation"),
        &[(0b10010, &ENTRY_DEMONETIZATION_10800150167569494235)],
    ),
    (
        crate::EncodedStr::Ascii("demonetisations"),
        &[(0b10010, &ENTRY_DEMONETIZATIONS_255741605004235275)],
    ),
    (
        crate::EncodedStr::Ascii("demonetise"),
        &[(0b10010, &ENTRY_DEMONETIZE_9169780209388435319)],
    ),
    (
        crate::EncodedStr::Ascii("demonetised"),
        &[(0b10010, &ENTRY_DEMONETIZED_13800822593083516335)],
    ),
    (
        crate::EncodedStr::Ascii("demonetises"),
        &[(0b10010, &ENTRY_DEMONETIZES_7423921842471575397)],
    ),
    (
        crate::EncodedStr::Ascii("demonetising"),
        &[(0b10010, &ENTRY_DEMONETIZING_6533722070664012445)],
    ),
    (
        crate::EncodedStr::Ascii("demonetization"),
        &[(0b01001, &ENTRY_DEMONETIZATION_10800150167569494235)],
    ),
    (
        crate::EncodedStr::Ascii("demonetizations"),
        &[(0b01001, &ENTRY_DEMONETIZATIONS_255741605004235275)],
    ),
    (
        crate::EncodedStr::Ascii("demonetize"),
        &[(0b01001, &ENTRY_DEMONETIZE_9169780209388435319)],
    ),
    (
        crate::EncodedStr::Ascii("demonetized"),
        &[(0b01001, &ENTRY_DEMONETIZED_13800822593083516335)],
    ),
    (
        crate::EncodedStr::Ascii("demonetizes"),
        &[(0b01001, &ENTRY_DEMONETIZES_7423921842471575397)],
    ),
    (
        crate::EncodedStr::Ascii("demonetizing"),
        &[(0b01001, &ENTRY_DEMONETIZING_6533722070664012445)],
    ),
    (
        crate::EncodedStr::Ascii("demonian"),
        &[(0b10001, &ENTRY_DEMONIAN_17257435076983249346)],
    ),
    (
        crate::EncodedStr::Ascii("demonisation"),
        &[(0b10010, &ENTRY_DEMONIZATION_16933975817485552160)],
    ),
    (
        crate::EncodedStr::Ascii("demonise"),
        &[(0b10010, &ENTRY_DEMONIZE_12145752355966993821)],
    ),
    (
        crate::EncodedStr::Ascii("demonised"),
        &[(0b10010, &ENTRY_DEMONIZED_12813528693273757543)],
    ),
    (
        crate::EncodedStr::Ascii("demonises"),
        &[(0b10010, &ENTRY_DEMONIZES_9920698644496788584)],
    ),
    (
        crate::EncodedStr::Ascii("demonising"),
        &[(0b10010, &ENTRY_DEMONIZING_6566799728062813977)],
    ),
    (
        crate::EncodedStr::Ascii("demonization"),
        &[(0b01001, &ENTRY_DEMONIZATION_16933975817485552160)],
    ),
    (
        crate::EncodedStr::Ascii("demonize"),
        &[(0b01001, &ENTRY_DEMONIZE_12145752355966993821)],
    ),
    (
        crate::EncodedStr::Ascii("demonized"),
        &[(0b01001, &ENTRY_DEMONIZED_12813528693273757543)],
    ),
    (
        crate::EncodedStr::Ascii("demonizes"),
        &[(0b01001, &ENTRY_DEMONIZES_9920698644496788584)],
    ),
    (
        crate::EncodedStr::Ascii("demonizing"),
        &[(0b01001, &ENTRY_DEMONIZING_6566799728062813977)],
    ),
    (
        crate::EncodedStr::Ascii("demoralisation"),
        &[(0b10010, &ENTRY_DEMORALIZATION_13446399219739683931)],
    ),
    (
        crate::EncodedStr::Ascii("demoralisations"),
        &[(0b10010, &ENTRY_DEMORALIZATIONS_1875584783582242810)],
    ),
    (
        crate::EncodedStr::Ascii("demoralise"),
        &[(0b10010, &ENTRY_DEMORALIZE_5844727729581502857)],
    ),
    (
        crate::EncodedStr::Ascii("demoralised"),
        &[(0b10010, &ENTRY_DEMORALIZED_11996398655519385837)],
    ),
    (
        crate::EncodedStr::Ascii("demoraliser"),
        &[(0b10010, &ENTRY_DEMORALIZER_9540636813033814633)],
    ),
    (
        crate::EncodedStr::Ascii("demoralisers"),
        &[(0b10010, &ENTRY_DEMORALIZERS_600938080037133255)],
    ),
    (
        crate::EncodedStr::Ascii("demoralises"),
        &[(0b10010, &ENTRY_DEMORALIZES_6517352001271737987)],
    ),
    (
        crate::EncodedStr::Ascii("demoralising"),
        &[(0b10010, &ENTRY_DEMORALIZING_2653761035115515698)],
    ),
    (
        crate::EncodedStr::Ascii("demoralisingly"),
        &[(0b10010, &ENTRY_DEMORALIZINGLY_8510512214576425144)],
    ),
    (
        crate::EncodedStr::Ascii("demoralization"),
        &[(0b01001, &ENTRY_DEMORALIZATION_13446399219739683931)],
    ),
    (
        crate::EncodedStr::Ascii("demoralizations"),
        &[(0b01001, &ENTRY_DEMORALIZATIONS_1875584783582242810)],
    ),
    (
        crate::EncodedStr::Ascii("demoralize"),
        &[(0b01001, &ENTRY_DEMORALIZE_5844727729581502857)],
    ),
    (
        crate::EncodedStr::Ascii("demoralized"),
        &[(0b01001, &ENTRY_DEMORALIZED_11996398655519385837)],
    ),
    (
        crate::EncodedStr::Ascii("demoralizer"),
        &[(0b01001, &ENTRY_DEMORALIZER_9540636813033814633)],
    ),
    (
        crate::EncodedStr::Ascii("demoralizers"),
        &[(0b01001, &ENTRY_DEMORALIZERS_600938080037133255)],
    ),
    (
        crate::EncodedStr::Ascii("demoralizes"),
        &[(0b01001, &ENTRY_DEMORALIZES_6517352001271737987)],
    ),
    (
        crate::EncodedStr::Ascii("demoralizing"),
        &[(0b01001, &ENTRY_DEMORALIZING_2653761035115515698)],
    ),
    (
        crate::EncodedStr::Ascii("demoralizingly"),
        &[(0b01001, &ENTRY_DEMORALIZINGLY_8510512214576425144)],
    ),
    (
        crate::EncodedStr::Ascii("demutualisation"),
        &[(0b10010, &ENTRY_DEMUTUALIZATION_5558427623273214024)],
    ),
    (
        crate::EncodedStr::Ascii("demutualisations"),
        &[(0b10010, &ENTRY_DEMUTUALIZATIONS_10275807852426892350)],
    ),
    (
        crate::EncodedStr::Ascii("demutualise"),
        &[(0b10010, &ENTRY_DEMUTUALIZE_2272296115716481128)],
    ),
    (
        crate::EncodedStr::Ascii("demutualised"),
        &[(0b10010, &ENTRY_DEMUTUALIZED_11852403011547269121)],
    ),
    (
        crate::EncodedStr::Ascii("demutualises"),
        &[(0b10010, &ENTRY_DEMUTUALIZES_11099575180973682407)],
    ),
    (
        crate::EncodedStr::Ascii("demutualising"),
        &[(0b10010, &ENTRY_DEMUTUALIZING_7987101933996172504)],
    ),
    (
        crate::EncodedStr::Ascii("demutualization"),
        &[(0b01001, &ENTRY_DEMUTUALIZATION_5558427623273214024)],
    ),
    (
        crate::EncodedStr::Ascii("demutualizations"),
        &[(0b01001, &ENTRY_DEMUTUALIZATIONS_10275807852426892350)],
    ),
    (
        crate::EncodedStr::Ascii("demutualize"),
        &[(0b01001, &ENTRY_DEMUTUALIZE_2272296115716481128)],
    ),
    (
        crate::EncodedStr::Ascii("demutualized"),
        &[(0b01001, &ENTRY_DEMUTUALIZED_11852403011547269121)],
    ),
    (
        crate::EncodedStr::Ascii("demutualizes"),
        &[(0b01001, &ENTRY_DEMUTUALIZES_11099575180973682407)],
    ),
    (
        crate::EncodedStr::Ascii("demutualizing"),
        &[(0b01001, &ENTRY_DEMUTUALIZING_7987101933996172504)],
    ),
    (
        crate::EncodedStr::Ascii("demythologisation"),
        &[(0b10010, &ENTRY_DEMYTHOLOGIZATION_10340600013226874649)],
    ),
    (
        crate::EncodedStr::Ascii("demythologisations"),
        &[(0b10010, &ENTRY_DEMYTHOLOGIZATIONS_14134816474323970961)],
    ),
    (
        crate::EncodedStr::Ascii("demythologise"),
        &[(0b10010, &ENTRY_DEMYTHOLOGIZE_16862432836085218960)],
    ),
    (
        crate::EncodedStr::Ascii("demythologised"),
        &[(0b10010, &ENTRY_DEMYTHOLOGIZED_4313900331791829006)],
    ),
    (
        crate::EncodedStr::Ascii("demythologiser"),
        &[(0b10010, &ENTRY_DEMYTHOLOGIZER_5237816041623179771)],
    ),
    (
        crate::EncodedStr::Ascii("demythologises"),
        &[(0b10010, &ENTRY_DEMYTHOLOGIZES_18185232184173660209)],
    ),
    (
        crate::EncodedStr::Ascii("demythologising"),
        &[(0b10010, &ENTRY_DEMYTHOLOGIZING_12409215121201891385)],
    ),
    (
        crate::EncodedStr::Ascii("demythologization"),
        &[(0b01001, &ENTRY_DEMYTHOLOGIZATION_10340600013226874649)],
    ),
    (
        crate::EncodedStr::Ascii("demythologizations"),
        &[(0b01001, &ENTRY_DEMYTHOLOGIZATIONS_14134816474323970961)],
    ),
    (
        crate::EncodedStr::Ascii("demythologize"),
        &[(0b01001, &ENTRY_DEMYTHOLOGIZE_16862432836085218960)],
    ),
    (
        crate::EncodedStr::Ascii("demythologized"),
        &[(0b01001, &ENTRY_DEMYTHOLOGIZED_4313900331791829006)],
    ),
    (
        crate::EncodedStr::Ascii("demythologizer"),
        &[(0b01001, &ENTRY_DEMYTHOLOGIZER_5237816041623179771)],
    ),
    (
        crate::EncodedStr::Ascii("demythologizes"),
        &[(0b01001, &ENTRY_DEMYTHOLOGIZES_18185232184173660209)],
    ),
    (
        crate::EncodedStr::Ascii("demythologizing"),
        &[(0b01001, &ENTRY_DEMYTHOLOGIZING_12409215121201891385)],
    ),
    (
        crate::EncodedStr::Ascii("denationalisation"),
        &[(0b10010, &ENTRY_DENATIONALIZATION_16856781549152365477)],
    ),
    (
        crate::EncodedStr::Ascii("denationalisations"),
        &[(0b10010, &ENTRY_DENATIONALIZATIONS_9164415981140694292)],
    ),
    (
        crate::EncodedStr::Ascii("denationalise"),
        &[(0b10010, &ENTRY_DENATIONALIZE_10800464833245961489)],
    ),
    (
        crate::EncodedStr::Ascii("denationalised"),
        &[(0b10010, &ENTRY_DENATIONALIZED_10472708594349713108)],
    ),
    (
        crate::EncodedStr::Ascii("denationalises"),
        &[(0b10010, &ENTRY_DENATIONALIZES_817254898726083409)],
    ),
    (
        crate::EncodedStr::Ascii("denationalising"),
        &[(0b10010, &ENTRY_DENATIONALIZING_8331022494929548611)],
    ),
    (
        crate::EncodedStr::Ascii("denationalization"),
        &[(0b01001, &ENTRY_DENATIONALIZATION_16856781549152365477)],
    ),
    (
        crate::EncodedStr::Ascii("denationalizations"),
        &[(0b01001, &ENTRY_DENATIONALIZATIONS_9164415981140694292)],
    ),
    (
        crate::EncodedStr::Ascii("denationalize"),
        &[(0b01001, &ENTRY_DENATIONALIZE_10800464833245961489)],
    ),
    (
        crate::EncodedStr::Ascii("denationalized"),
        &[(0b01001, &ENTRY_DENATIONALIZED_10472708594349713108)],
    ),
    (
        crate::EncodedStr::Ascii("denationalizes"),
        &[(0b01001, &ENTRY_DENATIONALIZES_817254898726083409)],
    ),
    (
        crate::EncodedStr::Ascii("denationalizing"),
        &[(0b01001, &ENTRY_DENATIONALIZING_8331022494929548611)],
    ),
    (
        crate::EncodedStr::Ascii("denaturalisation"),
        &[(0b10010, &ENTRY_DENATURALIZATION_4147617871911149693)],
    ),
    (
        crate::EncodedStr::Ascii("denaturalisations"),
        &[(0b10010, &ENTRY_DENATURALIZATIONS_16570465894458392415)],
    ),
    (
        crate::EncodedStr::Ascii("denaturalise"),
        &[(0b10010, &ENTRY_DENATURALIZE_12142869922927195304)],
    ),
    (
        crate::EncodedStr::Ascii("denaturalised"),
        &[(0b10010, &ENTRY_DENATURALIZED_1338969835914266213)],
    ),
    (
        crate::EncodedStr::Ascii("denaturalises"),
        &[(0b10010, &ENTRY_DENATURALIZES_12885068908916155509)],
    ),
    (
        crate::EncodedStr::Ascii("denaturalising"),
        &[(0b10010, &ENTRY_DENATURALIZING_11035796773484399105)],
    ),
    (
        crate::EncodedStr::Ascii("denaturalization"),
        &[(0b01001, &ENTRY_DENATURALIZATION_4147617871911149693)],
    ),
    (
        crate::EncodedStr::Ascii("denaturalizations"),
        &[(0b01001, &ENTRY_DENATURALIZATIONS_16570465894458392415)],
    ),
    (
        crate::EncodedStr::Ascii("denaturalize"),
        &[(0b01001, &ENTRY_DENATURALIZE_12142869922927195304)],
    ),
    (
        crate::EncodedStr::Ascii("denaturalized"),
        &[(0b01001, &ENTRY_DENATURALIZED_1338969835914266213)],
    ),
    (
        crate::EncodedStr::Ascii("denaturalizes"),
        &[(0b01001, &ENTRY_DENATURALIZES_12885068908916155509)],
    ),
    (
        crate::EncodedStr::Ascii("denaturalizing"),
        &[(0b01001, &ENTRY_DENATURALIZING_11035796773484399105)],
    ),
    (
        crate::EncodedStr::Ascii("denaturisation"),
        &[(0b10010, &ENTRY_DENATURIZATION_2153844497547377154)],
    ),
    (
        crate::EncodedStr::Ascii("denaturisations"),
        &[(0b10010, &ENTRY_DENATURIZATIONS_12481426158532842249)],
    ),
    (
        crate::EncodedStr::Ascii("denaturise"),
        &[(0b10010, &ENTRY_DENATURIZE_16665212717126083275)],
    ),
    (
        crate::EncodedStr::Ascii("denaturised"),
        &[(0b10010, &ENTRY_DENATURIZED_11293306666666002972)],
    ),
    (
        crate::EncodedStr::Ascii("denaturiser"),
        &[(0b10010, &ENTRY_DENATURIZER_9311420005130802353)],
    ),
    (
        crate::EncodedStr::Ascii("denaturisers"),
        &[(0b10010, &ENTRY_DENATURIZERS_7527212398694915324)],
    ),
    (
        crate::EncodedStr::Ascii("denaturises"),
        &[(0b10010, &ENTRY_DENATURIZES_2160785183565221398)],
    ),
    (
        crate::EncodedStr::Ascii("denaturising"),
        &[(0b10010, &ENTRY_DENATURIZING_7455919186731907769)],
    ),
    (
        crate::EncodedStr::Ascii("denaturization"),
        &[(0b01001, &ENTRY_DENATURIZATION_2153844497547377154)],
    ),
    (
        crate::EncodedStr::Ascii("denaturizations"),
        &[(0b01001, &ENTRY_DENATURIZATIONS_12481426158532842249)],
    ),
    (
        crate::EncodedStr::Ascii("denaturize"),
        &[(0b01001, &ENTRY_DENATURIZE_16665212717126083275)],
    ),
    (
        crate::EncodedStr::Ascii("denaturized"),
        &[(0b01001, &ENTRY_DENATURIZED_11293306666666002972)],
    ),
    (
        crate::EncodedStr::Ascii("denaturizer"),
        &[(0b01001, &ENTRY_DENATURIZER_9311420005130802353)],
    ),
    (
        crate::EncodedStr::Ascii("denaturizers"),
        &[(0b01001, &ENTRY_DENATURIZERS_7527212398694915324)],
    ),
    (
        crate::EncodedStr::Ascii("denaturizes"),
        &[(0b01001, &ENTRY_DENATURIZES_2160785183565221398)],
    ),
    (
        crate::EncodedStr::Ascii("denaturizing"),
        &[(0b01001, &ENTRY_DENATURIZING_7455919186731907769)],
    ),
    (
        crate::EncodedStr::Ascii("denicotinise"),
        &[(0b10010, &ENTRY_DENICOTINIZE_1657978267403261883)],
    ),
    (
        crate::EncodedStr::Ascii("denicotinize"),
        &[(0b01001, &ENTRY_DENICOTINIZE_1657978267403261883)],
    ),
    (
        crate::EncodedStr::Ascii("denizenise"),
        &[(0b10010, &ENTRY_DENIZENIZE_15175171930010739812)],
    ),
    (
        crate::EncodedStr::Ascii("denizenises"),
        &[(0b10010, &ENTRY_DENIZENIZES_4532386499907231320)],
    ),
    (
        crate::EncodedStr::Ascii("denizenize"),
        &[(0b01001, &ENTRY_DENIZENIZE_15175171930010739812)],
    ),
    (
        crate::EncodedStr::Ascii("denizenizes"),
        &[(0b01001, &ENTRY_DENIZENIZES_4532386499907231320)],
    ),
    (
        crate::EncodedStr::Ascii("denominationalise"),
        &[(0b10010, &ENTRY_DENOMINATIONALIZE_11508794372277368265)],
    ),
    (
        crate::EncodedStr::Ascii("denominationalises"),
        &[(0b10010, &ENTRY_DENOMINATIONALIZES_16912479616014894849)],
    ),
    (
        crate::EncodedStr::Ascii("denominationalize"),
        &[(0b01001, &ENTRY_DENOMINATIONALIZE_11508794372277368265)],
    ),
    (
        crate::EncodedStr::Ascii("denominationalizes"),
        &[(0b01001, &ENTRY_DENOMINATIONALIZES_16912479616014894849)],
    ),
    (
        crate::EncodedStr::Ascii("denormalise"),
        &[(0b10010, &ENTRY_DENORMALIZE_14457389572229397553)],
    ),
    (
        crate::EncodedStr::Ascii("denormalize"),
        &[(0b01001, &ENTRY_DENORMALIZE_14457389572229397553)],
    ),
    (
        crate::EncodedStr::Ascii("dentalisation"),
        &[(0b10010, &ENTRY_DENTALIZATION_15022518066445577537)],
    ),
    (
        crate::EncodedStr::Ascii("dentalisations"),
        &[(0b10010, &ENTRY_DENTALIZATIONS_1316043456675495124)],
    ),
    (
        crate::EncodedStr::Ascii("dentalise"),
        &[(0b10010, &ENTRY_DENTALIZE_13079577939938126746)],
    ),
    (
        crate::EncodedStr::Ascii("dentalised"),
        &[(0b10010, &ENTRY_DENTALIZED_2413837908707543437)],
    ),
    (
        crate::EncodedStr::Ascii("dentalises"),
        &[(0b10010, &ENTRY_DENTALIZES_6643609780500500774)],
    ),
    (
        crate::EncodedStr::Ascii("dentalising"),
        &[(0b10010, &ENTRY_DENTALIZING_324908095822959388)],
    ),
    (
        crate::EncodedStr::Ascii("dentalization"),
        &[(0b01001, &ENTRY_DENTALIZATION_15022518066445577537)],
    ),
    (
        crate::EncodedStr::Ascii("dentalizations"),
        &[(0b01001, &ENTRY_DENTALIZATIONS_1316043456675495124)],
    ),
    (
        crate::EncodedStr::Ascii("dentalize"),
        &[(0b01001, &ENTRY_DENTALIZE_13079577939938126746)],
    ),
    (
        crate::EncodedStr::Ascii("dentalized"),
        &[(0b01001, &ENTRY_DENTALIZED_2413837908707543437)],
    ),
    (
        crate::EncodedStr::Ascii("dentalizes"),
        &[(0b01001, &ENTRY_DENTALIZES_6643609780500500774)],
    ),
    (
        crate::EncodedStr::Ascii("dentalizing"),
        &[(0b01001, &ENTRY_DENTALIZING_324908095822959388)],
    ),
    (
        crate::EncodedStr::Ascii("dentin"),
        &[(0b00001, &ENTRY_DENTIN_8335953072295603807)],
    ),
    (
        crate::EncodedStr::Ascii("dentins"),
        &[(0b00001, &ENTRY_DENTINS_8462696171012072981)],
    ),
    (
        crate::EncodedStr::Ascii("denuclearisation"),
        &[(0b10010, &ENTRY_DENUCLEARIZATION_6246945169000847057)],
    ),
    (
        crate::EncodedStr::Ascii("denuclearisations"),
        &[(0b10010, &ENTRY_DENUCLEARIZATIONS_7167298608770271904)],
    ),
    (
        crate::EncodedStr::Ascii("denuclearise"),
        &[(0b10010, &ENTRY_DENUCLEARIZE_7871525726880557534)],
    ),
    (
        crate::EncodedStr::Ascii("denuclearised"),
        &[(0b10010, &ENTRY_DENUCLEARIZED_14638949387306808248)],
    ),
    (
        crate::EncodedStr::Ascii("denuclearises"),
        &[(0b10010, &ENTRY_DENUCLEARIZES_3857601007676937998)],
    ),
    (
        crate::EncodedStr::Ascii("denuclearising"),
        &[(0b10010, &ENTRY_DENUCLEARIZING_6228420000189119754)],
    ),
    (
        crate::EncodedStr::Ascii("denuclearization"),
        &[(0b01001, &ENTRY_DENUCLEARIZATION_6246945169000847057)],
    ),
    (
        crate::EncodedStr::Ascii("denuclearizations"),
        &[(0b01001, &ENTRY_DENUCLEARIZATIONS_7167298608770271904)],
    ),
    (
        crate::EncodedStr::Ascii("denuclearize"),
        &[(0b01001, &ENTRY_DENUCLEARIZE_7871525726880557534)],
    ),
    (
        crate::EncodedStr::Ascii("denuclearized"),
        &[(0b01001, &ENTRY_DENUCLEARIZED_14638949387306808248)],
    ),
    (
        crate::EncodedStr::Ascii("denuclearizes"),
        &[(0b01001, &ENTRY_DENUCLEARIZES_3857601007676937998)],
    ),
    (
        crate::EncodedStr::Ascii("denuclearizing"),
        &[(0b01001, &ENTRY_DENUCLEARIZING_6228420000189119754)],
    ),
    (
        crate::EncodedStr::Ascii("deodorisation"),
        &[(0b10010, &ENTRY_DEODORIZATION_15234202985364171925)],
    ),
    (
        crate::EncodedStr::Ascii("deodorisations"),
        &[(0b10010, &ENTRY_DEODORIZATIONS_12657185289043189294)],
    ),
    (
        crate::EncodedStr::Ascii("deodorise"),
        &[(0b10010, &ENTRY_DEODORIZE_16215032566622833150)],
    ),
    (
        crate::EncodedStr::Ascii("deodorised"),
        &[(0b10010, &ENTRY_DEODORIZED_17559687252320728172)],
    ),
    (
        crate::EncodedStr::Ascii("deodoriser"),
        &[(0b10010, &ENTRY_DEODORIZER_13797022735041696461)],
    ),
    (
        crate::EncodedStr::Ascii("deodorisers"),
        &[(0b10010, &ENTRY_DEODORIZERS_7206686442131612842)],
    ),
    (
        crate::EncodedStr::Ascii("deodorises"),
        &[(0b10010, &ENTRY_DEODORIZES_4648778267610996306)],
    ),
    (
        crate::EncodedStr::Ascii("deodorising"),
        &[(0b10010, &ENTRY_DEODORIZING_12515361627952335019)],
    ),
    (
        crate::EncodedStr::Ascii("deodorization"),
        &[(0b01001, &ENTRY_DEODORIZATION_15234202985364171925)],
    ),
    (
        crate::EncodedStr::Ascii("deodorizations"),
        &[(0b01001, &ENTRY_DEODORIZATIONS_12657185289043189294)],
    ),
    (
        crate::EncodedStr::Ascii("deodorize"),
        &[(0b01001, &ENTRY_DEODORIZE_16215032566622833150)],
    ),
    (
        crate::EncodedStr::Ascii("deodorized"),
        &[(0b01001, &ENTRY_DEODORIZED_17559687252320728172)],
    ),
    (
        crate::EncodedStr::Ascii("deodorizer"),
        &[(0b01001, &ENTRY_DEODORIZER_13797022735041696461)],
    ),
    (
        crate::EncodedStr::Ascii("deodorizers"),
        &[(0b01001, &ENTRY_DEODORIZERS_7206686442131612842)],
    ),
    (
        crate::EncodedStr::Ascii("deodorizes"),
        &[(0b01001, &ENTRY_DEODORIZES_4648778267610996306)],
    ),
    (
        crate::EncodedStr::Ascii("deodorizing"),
        &[(0b01001, &ENTRY_DEODORIZING_12515361627952335019)],
    ),
    (
        crate::EncodedStr::Ascii("deoxidisation"),
        &[(0b10010, &ENTRY_DEOXIDIZATION_7394934458510098573)],
    ),
    (
        crate::EncodedStr::Ascii("deoxidisations"),
        &[(0b10010, &ENTRY_DEOXIDIZATIONS_13683604498444194612)],
    ),
    (
        crate::EncodedStr::Ascii("deoxidise"),
        &[(0b10010, &ENTRY_DEOXIDIZE_8564134429609100253)],
    ),
    (
        crate::EncodedStr::Ascii("deoxidised"),
        &[(0b10010, &ENTRY_DEOXIDIZED_14617928271424988803)],
    ),
    (
        crate::EncodedStr::Ascii("deoxidiser"),
        &[(0b10010, &ENTRY_DEOXIDIZER_11973963213903362992)],
    ),
    (
        crate::EncodedStr::Ascii("deoxidisers"),
        &[(0b10010, &ENTRY_DEOXIDIZERS_10105977169121575310)],
    ),
    (
        crate::EncodedStr::Ascii("deoxidises"),
        &[(0b10010, &ENTRY_DEOXIDIZES_4018740714548992165)],
    ),
    (
        crate::EncodedStr::Ascii("deoxidising"),
        &[(0b10010, &ENTRY_DEOXIDIZING_17849539330093953654)],
    ),
    (
        crate::EncodedStr::Ascii("deoxidization"),
        &[(0b01001, &ENTRY_DEOXIDIZATION_7394934458510098573)],
    ),
    (
        crate::EncodedStr::Ascii("deoxidizations"),
        &[(0b01001, &ENTRY_DEOXIDIZATIONS_13683604498444194612)],
    ),
    (
        crate::EncodedStr::Ascii("deoxidize"),
        &[(0b01001, &ENTRY_DEOXIDIZE_8564134429609100253)],
    ),
    (
        crate::EncodedStr::Ascii("deoxidized"),
        &[(0b01001, &ENTRY_DEOXIDIZED_14617928271424988803)],
    ),
    (
        crate::EncodedStr::Ascii("deoxidizer"),
        &[(0b01001, &ENTRY_DEOXIDIZER_11973963213903362992)],
    ),
    (
        crate::EncodedStr::Ascii("deoxidizers"),
        &[(0b01001, &ENTRY_DEOXIDIZERS_10105977169121575310)],
    ),
    (
        crate::EncodedStr::Ascii("deoxidizes"),
        &[(0b01001, &ENTRY_DEOXIDIZES_4018740714548992165)],
    ),
    (
        crate::EncodedStr::Ascii("deoxidizing"),
        &[(0b01001, &ENTRY_DEOXIDIZING_17849539330093953654)],
    ),
    (
        crate::EncodedStr::Ascii("deoxygenise"),
        &[(0b10010, &ENTRY_DEOXYGENIZE_7933890150357499237)],
    ),
    (
        crate::EncodedStr::Ascii("deoxygenised"),
        &[(0b10010, &ENTRY_DEOXYGENIZED_6360726218188064127)],
    ),
    (
        crate::EncodedStr::Ascii("deoxygenises"),
        &[(0b10010, &ENTRY_DEOXYGENIZES_17788466892741650049)],
    ),
    (
        crate::EncodedStr::Ascii("deoxygenising"),
        &[(0b10010, &ENTRY_DEOXYGENIZING_6445979304009334071)],
    ),
    (
        crate::EncodedStr::Ascii("deoxygenize"),
        &[(0b01001, &ENTRY_DEOXYGENIZE_7933890150357499237)],
    ),
    (
        crate::EncodedStr::Ascii("deoxygenized"),
        &[(0b01001, &ENTRY_DEOXYGENIZED_6360726218188064127)],
    ),
    (
        crate::EncodedStr::Ascii("deoxygenizes"),
        &[(0b01001, &ENTRY_DEOXYGENIZES_17788466892741650049)],
    ),
    (
        crate::EncodedStr::Ascii("deoxygenizing"),
        &[(0b01001, &ENTRY_DEOXYGENIZING_6445979304009334071)],
    ),
    (
        crate::EncodedStr::Ascii("departmentalisation"),
        &[(0b10010, &ENTRY_DEPARTMENTALIZATION_12611432409781436004)],
    ),
    (
        crate::EncodedStr::Ascii("departmentalisations"),
        &[(0b10010, &ENTRY_DEPARTMENTALIZATIONS_13030339549069230554)],
    ),
    (
        crate::EncodedStr::Ascii("departmentalise"),
        &[(0b10010, &ENTRY_DEPARTMENTALIZE_14009690449414337770)],
    ),
    (
        crate::EncodedStr::Ascii("departmentalised"),
        &[(0b10010, &ENTRY_DEPARTMENTALIZED_7739211835934086119)],
    ),
    (
        crate::EncodedStr::Ascii("departmentalises"),
        &[(0b10010, &ENTRY_DEPARTMENTALIZES_2816661299052746212)],
    ),
    (
        crate::EncodedStr::Ascii("departmentalising"),
        &[(0b10010, &ENTRY_DEPARTMENTALIZING_18236918120360172300)],
    ),
    (
        crate::EncodedStr::Ascii("departmentalization"),
        &[(0b01001, &ENTRY_DEPARTMENTALIZATION_12611432409781436004)],
    ),
    (
        crate::EncodedStr::Ascii("departmentalizations"),
        &[(0b01001, &ENTRY_DEPARTMENTALIZATIONS_13030339549069230554)],
    ),
    (
        crate::EncodedStr::Ascii("departmentalize"),
        &[(0b01001, &ENTRY_DEPARTMENTALIZE_14009690449414337770)],
    ),
    (
        crate::EncodedStr::Ascii("departmentalized"),
        &[(0b01001, &ENTRY_DEPARTMENTALIZED_7739211835934086119)],
    ),
    (
        crate::EncodedStr::Ascii("departmentalizes"),
        &[(0b01001, &ENTRY_DEPARTMENTALIZES_2816661299052746212)],
    ),
    (
        crate::EncodedStr::Ascii("departmentalizing"),
        &[(0b01001, &ENTRY_DEPARTMENTALIZING_18236918120360172300)],
    ),
    (
        crate::EncodedStr::Ascii("departmentisation"),
        &[(0b10010, &ENTRY_DEPARTMENTIZATION_10520965656271033045)],
    ),
    (
        crate::EncodedStr::Ascii("departmentisations"),
        &[(0b10010, &ENTRY_DEPARTMENTIZATIONS_3570201152511445119)],
    ),
    (
        crate::EncodedStr::Ascii("departmentise"),
        &[(0b10010, &ENTRY_DEPARTMENTIZE_14523218551427073465)],
    ),
    (
        crate::EncodedStr::Ascii("departmentises"),
        &[(0b10010, &ENTRY_DEPARTMENTIZES_7420843837381616897)],
    ),
    (
        crate::EncodedStr::Ascii("departmentization"),
        &[(0b01001, &ENTRY_DEPARTMENTIZATION_10520965656271033045)],
    ),
    (
        crate::EncodedStr::Ascii("departmentizations"),
        &[(0b01001, &ENTRY_DEPARTMENTIZATIONS_3570201152511445119)],
    ),
    (
        crate::EncodedStr::Ascii("departmentize"),
        &[(0b01001, &ENTRY_DEPARTMENTIZE_14523218551427073465)],
    ),
    (
        crate::EncodedStr::Ascii("departmentizes"),
        &[(0b01001, &ENTRY_DEPARTMENTIZES_7420843837381616897)],
    ),
    (
        crate::EncodedStr::Ascii("depauperisation"),
        &[(0b10010, &ENTRY_DEPAUPERIZATION_12167006445811415084)],
    ),
    (
        crate::EncodedStr::Ascii("depauperise"),
        &[(0b10010, &ENTRY_DEPAUPERIZE_5573322689772847322)],
    ),
    (
        crate::EncodedStr::Ascii("depauperised"),
        &[(0b10010, &ENTRY_DEPAUPERIZED_18062942538181210641)],
    ),
    (
        crate::EncodedStr::Ascii("depauperises"),
        &[(0b10010, &ENTRY_DEPAUPERIZES_5838182964694454265)],
    ),
    (
        crate::EncodedStr::Ascii("depauperising"),
        &[(0b10010, &ENTRY_DEPAUPERIZING_17019784408353154824)],
    ),
    (
        crate::EncodedStr::Ascii("depauperization"),
        &[(0b01001, &ENTRY_DEPAUPERIZATION_12167006445811415084)],
    ),
    (
        crate::EncodedStr::Ascii("depauperize"),
        &[(0b01001, &ENTRY_DEPAUPERIZE_5573322689772847322)],
    ),
    (
        crate::EncodedStr::Ascii("depauperized"),
        &[(0b01001, &ENTRY_DEPAUPERIZED_18062942538181210641)],
    ),
    (
        crate::EncodedStr::Ascii("depauperizes"),
        &[(0b01001, &ENTRY_DEPAUPERIZES_5838182964694454265)],
    ),
    (
        crate::EncodedStr::Ascii("depauperizing"),
        &[(0b01001, &ENTRY_DEPAUPERIZING_17019784408353154824)],
    ),
    (
        crate::EncodedStr::Ascii("dependance"),
        &[(0b00001, &ENTRY_DEPENDENCE_10489349889910496855)],
    ),
    (
        crate::EncodedStr::Ascii("dependances"),
        &[(0b00001, &ENTRY_DEPENDENCES_3098774442639177584)],
    ),
    (
        crate::EncodedStr::Ascii("dependant"),
        &[(0b11010, &ENTRY_DEPENDENT_14174944247872454288)],
    ),
    (
        crate::EncodedStr::Ascii("dependants"),
        &[(0b11010, &ENTRY_DEPENDENTS_1571044403913138535)],
    ),
    (
        crate::EncodedStr::Ascii("depersonalisation"),
        &[(0b10010, &ENTRY_DEPERSONALIZATION_16899026211036624682)],
    ),
    (
        crate::EncodedStr::Ascii("depersonalisations"),
        &[(0b10010, &ENTRY_DEPERSONALIZATIONS_934260460324727269)],
    ),
    (
        crate::EncodedStr::Ascii("depersonalise"),
        &[(0b10010, &ENTRY_DEPERSONALIZE_18024338536202331812)],
    ),
    (
        crate::EncodedStr::Ascii("depersonalised"),
        &[(0b10010, &ENTRY_DEPERSONALIZED_6040306005149363450)],
    ),
    (
        crate::EncodedStr::Ascii("depersonalises"),
        &[(0b10010, &ENTRY_DEPERSONALIZES_8248879637475981954)],
    ),
    (
        crate::EncodedStr::Ascii("depersonalising"),
        &[(0b10010, &ENTRY_DEPERSONALIZING_9579967389250229168)],
    ),
    (
        crate::EncodedStr::Ascii("depersonalization"),
        &[(0b01001, &ENTRY_DEPERSONALIZATION_16899026211036624682)],
    ),
    (
        crate::EncodedStr::Ascii("depersonalizations"),
        &[(0b01001, &ENTRY_DEPERSONALIZATIONS_934260460324727269)],
    ),
    (
        crate::EncodedStr::Ascii("depersonalize"),
        &[(0b01001, &ENTRY_DEPERSONALIZE_18024338536202331812)],
    ),
    (
        crate::EncodedStr::Ascii("depersonalized"),
        &[(0b01001, &ENTRY_DEPERSONALIZED_6040306005149363450)],
    ),
    (
        crate::EncodedStr::Ascii("depersonalizes"),
        &[(0b01001, &ENTRY_DEPERSONALIZES_8248879637475981954)],
    ),
    (
        crate::EncodedStr::Ascii("depersonalizing"),
        &[(0b01001, &ENTRY_DEPERSONALIZING_9579967389250229168)],
    ),
    (
        crate::EncodedStr::Ascii("depolarisation"),
        &[(0b10010, &ENTRY_DEPOLARIZATION_2742985217153412220)],
    ),
    (
        crate::EncodedStr::Ascii("depolarisations"),
        &[(0b10010, &ENTRY_DEPOLARIZATIONS_6588998950476370531)],
    ),
    (
        crate::EncodedStr::Ascii("depolarise"),
        &[(0b10010, &ENTRY_DEPOLARIZE_13378765368414695477)],
    ),
    (
        crate::EncodedStr::Ascii("depolarised"),
        &[(0b10010, &ENTRY_DEPOLARIZED_13852987575688176985)],
    ),
    (
        crate::EncodedStr::Ascii("depolariser"),
        &[(0b10010, &ENTRY_DEPOLARIZER_13724559510199383868)],
    ),
    (
        crate::EncodedStr::Ascii("depolarisers"),
        &[(0b10010, &ENTRY_DEPOLARIZERS_17405526508830397920)],
    ),
    (
        crate::EncodedStr::Ascii("depolarises"),
        &[(0b10010, &ENTRY_DEPOLARIZES_16555447378193023350)],
    ),
    (
        crate::EncodedStr::Ascii("depolarising"),
        &[(0b10010, &ENTRY_DEPOLARIZING_1326681409200466325)],
    ),
    (
        crate::EncodedStr::Ascii("depolarization"),
        &[(0b01001, &ENTRY_DEPOLARIZATION_2742985217153412220)],
    ),
    (
        crate::EncodedStr::Ascii("depolarizations"),
        &[(0b01001, &ENTRY_DEPOLARIZATIONS_6588998950476370531)],
    ),
    (
        crate::EncodedStr::Ascii("depolarize"),
        &[(0b01001, &ENTRY_DEPOLARIZE_13378765368414695477)],
    ),
    (
        crate::EncodedStr::Ascii("depolarized"),
        &[(0b01001, &ENTRY_DEPOLARIZED_13852987575688176985)],
    ),
    (
        crate::EncodedStr::Ascii("depolarizer"),
        &[(0b01001, &ENTRY_DEPOLARIZER_13724559510199383868)],
    ),
    (
        crate::EncodedStr::Ascii("depolarizers"),
        &[(0b01001, &ENTRY_DEPOLARIZERS_17405526508830397920)],
    ),
    (
        crate::EncodedStr::Ascii("depolarizes"),
        &[(0b01001, &ENTRY_DEPOLARIZES_16555447378193023350)],
    ),
    (
        crate::EncodedStr::Ascii("depolarizing"),
        &[(0b01001, &ENTRY_DEPOLARIZING_1326681409200466325)],
    ),
    (
        crate::EncodedStr::Ascii("depoliticisation"),
        &[(0b10010, &ENTRY_DEPOLITICIZATION_14063377291726000588)],
    ),
    (
        crate::EncodedStr::Ascii("depoliticise"),
        &[(0b10010, &ENTRY_DEPOLITICIZE_646707646854880895)],
    ),
    (
        crate::EncodedStr::Ascii("depoliticised"),
        &[(0b10010, &ENTRY_DEPOLITICIZED_17863590655277271452)],
    ),
    (
        crate::EncodedStr::Ascii("depoliticises"),
        &[(0b10010, &ENTRY_DEPOLITICIZES_17679110590239399087)],
    ),
    (
        crate::EncodedStr::Ascii("depoliticising"),
        &[(0b10010, &ENTRY_DEPOLITICIZING_7335312451906636158)],
    ),
    (
        crate::EncodedStr::Ascii("depoliticization"),
        &[(0b01001, &ENTRY_DEPOLITICIZATION_14063377291726000588)],
    ),
    (
        crate::EncodedStr::Ascii("depoliticize"),
        &[(0b01001, &ENTRY_DEPOLITICIZE_646707646854880895)],
    ),
    (
        crate::EncodedStr::Ascii("depoliticized"),
        &[(0b01001, &ENTRY_DEPOLITICIZED_17863590655277271452)],
    ),
    (
        crate::EncodedStr::Ascii("depoliticizes"),
        &[(0b01001, &ENTRY_DEPOLITICIZES_17679110590239399087)],
    ),
    (
        crate::EncodedStr::Ascii("depoliticizing"),
        &[(0b01001, &ENTRY_DEPOLITICIZING_7335312451906636158)],
    ),
    (
        crate::EncodedStr::Ascii("depolymerisation"),
        &[(0b10010, &ENTRY_DEPOLYMERIZATION_11553792676168407099)],
    ),
    (
        crate::EncodedStr::Ascii("depolymerisations"),
        &[(0b10010, &ENTRY_DEPOLYMERIZATIONS_10499384093097172145)],
    ),
    (
        crate::EncodedStr::Ascii("depolymerise"),
        &[(0b10010, &ENTRY_DEPOLYMERIZE_332335072679713287)],
    ),
    (
        crate::EncodedStr::Ascii("depolymerised"),
        &[(0b10010, &ENTRY_DEPOLYMERIZED_10301635163339565907)],
    ),
    (
        crate::EncodedStr::Ascii("depolymerises"),
        &[(0b10010, &ENTRY_DEPOLYMERIZES_8621948432119164421)],
    ),
    (
        crate::EncodedStr::Ascii("depolymerising"),
        &[(0b10010, &ENTRY_DEPOLYMERIZING_9371889196944478207)],
    ),
    (
        crate::EncodedStr::Ascii("depolymerization"),
        &[(0b01001, &ENTRY_DEPOLYMERIZATION_11553792676168407099)],
    ),
    (
        crate::EncodedStr::Ascii("depolymerizations"),
        &[(0b01001, &ENTRY_DEPOLYMERIZATIONS_10499384093097172145)],
    ),
    (
        crate::EncodedStr::Ascii("depolymerize"),
        &[(0b01001, &ENTRY_DEPOLYMERIZE_332335072679713287)],
    ),
    (
        crate::EncodedStr::Ascii("depolymerized"),
        &[(0b01001, &ENTRY_DEPOLYMERIZED_10301635163339565907)],
    ),
    (
        crate::EncodedStr::Ascii("depolymerizes"),
        &[(0b01001, &ENTRY_DEPOLYMERIZES_8621948432119164421)],
    ),
    (
        crate::EncodedStr::Ascii("depolymerizing"),
        &[(0b01001, &ENTRY_DEPOLYMERIZING_9371889196944478207)],
    ),
    (
        crate::EncodedStr::Ascii("depressurisation"),
        &[(0b10010, &ENTRY_DEPRESSURIZATION_8699831289105571367)],
    ),
    (
        crate::EncodedStr::Ascii("depressurisations"),
        &[(0b10010, &ENTRY_DEPRESSURIZATIONS_11557965491679491854)],
    ),
    (
        crate::EncodedStr::Ascii("depressurise"),
        &[(0b10010, &ENTRY_DEPRESSURIZE_2580273134181372193)],
    ),
    (
        crate::EncodedStr::Ascii("depressurised"),
        &[(0b10010, &ENTRY_DEPRESSURIZED_590523559314456395)],
    ),
    (
        crate::EncodedStr::Ascii("depressurises"),
        &[(0b10010, &ENTRY_DEPRESSURIZES_9794647774856679413)],
    ),
    (
        crate::EncodedStr::Ascii("depressurising"),
        &[(0b10010, &ENTRY_DEPRESSURIZING_13641347976969899739)],
    ),
    (
        crate::EncodedStr::Ascii("depressurization"),
        &[(0b01001, &ENTRY_DEPRESSURIZATION_8699831289105571367)],
    ),
    (
        crate::EncodedStr::Ascii("depressurizations"),
        &[(0b01001, &ENTRY_DEPRESSURIZATIONS_11557965491679491854)],
    ),
    (
        crate::EncodedStr::Ascii("depressurize"),
        &[(0b01001, &ENTRY_DEPRESSURIZE_2580273134181372193)],
    ),
    (
        crate::EncodedStr::Ascii("depressurized"),
        &[(0b01001, &ENTRY_DEPRESSURIZED_590523559314456395)],
    ),
    (
        crate::EncodedStr::Ascii("depressurizes"),
        &[(0b01001, &ENTRY_DEPRESSURIZES_9794647774856679413)],
    ),
    (
        crate::EncodedStr::Ascii("depressurizing"),
        &[(0b01001, &ENTRY_DEPRESSURIZING_13641347976969899739)],
    ),
    (
        crate::EncodedStr::Ascii("deputationise"),
        &[(0b10010, &ENTRY_DEPUTATIONIZE_6925287050174299860)],
    ),
    (
        crate::EncodedStr::Ascii("deputationises"),
        &[(0b10010, &ENTRY_DEPUTATIONIZES_6787325415938091394)],
    ),
    (
        crate::EncodedStr::Ascii("deputationize"),
        &[(0b01001, &ENTRY_DEPUTATIONIZE_6925287050174299860)],
    ),
    (
        crate::EncodedStr::Ascii("deputationizes"),
        &[(0b01001, &ENTRY_DEPUTATIONIZES_6787325415938091394)],
    ),
    (
        crate::EncodedStr::Ascii("deputisation"),
        &[(0b10010, &ENTRY_DEPUTIZATION_1712123122893688078)],
    ),
    (
        crate::EncodedStr::Ascii("deputise"),
        &[(0b10010, &ENTRY_DEPUTIZE_2146946330988443787)],
    ),
    (
        crate::EncodedStr::Ascii("deputised"),
        &[(0b10010, &ENTRY_DEPUTIZED_7193789182724757168)],
    ),
    (
        crate::EncodedStr::Ascii("deputises"),
        &[(0b10010, &ENTRY_DEPUTIZES_11101760392402320280)],
    ),
    (
        crate::EncodedStr::Ascii("deputising"),
        &[(0b10010, &ENTRY_DEPUTIZING_7923968930248772327)],
    ),
    (
        crate::EncodedStr::Ascii("deputization"),
        &[(0b01001, &ENTRY_DEPUTIZATION_1712123122893688078)],
    ),
    (
        crate::EncodedStr::Ascii("deputize"),
        &[(0b01001, &ENTRY_DEPUTIZE_2146946330988443787)],
    ),
    (
        crate::EncodedStr::Ascii("deputized"),
        &[(0b01001, &ENTRY_DEPUTIZED_7193789182724757168)],
    ),
    (
        crate::EncodedStr::Ascii("deputizes"),
        &[(0b01001, &ENTRY_DEPUTIZES_11101760392402320280)],
    ),
    (
        crate::EncodedStr::Ascii("deputizing"),
        &[(0b01001, &ENTRY_DEPUTIZING_7923968930248772327)],
    ),
    (
        crate::EncodedStr::Ascii("deracialise"),
        &[(0b10010, &ENTRY_DERACIALIZE_16127533532397871488)],
    ),
    (
        crate::EncodedStr::Ascii("deracialised"),
        &[(0b10010, &ENTRY_DERACIALIZED_13925986860775238916)],
    ),
    (
        crate::EncodedStr::Ascii("deracialises"),
        &[(0b10010, &ENTRY_DERACIALIZES_3059282447110218733)],
    ),
    (
        crate::EncodedStr::Ascii("deracialising"),
        &[(0b10010, &ENTRY_DERACIALIZING_14275754837816585059)],
    ),
    (
        crate::EncodedStr::Ascii("deracialize"),
        &[(0b01001, &ENTRY_DERACIALIZE_16127533532397871488)],
    ),
    (
        crate::EncodedStr::Ascii("deracialized"),
        &[(0b01001, &ENTRY_DERACIALIZED_13925986860775238916)],
    ),
    (
        crate::EncodedStr::Ascii("deracializes"),
        &[(0b01001, &ENTRY_DERACIALIZES_3059282447110218733)],
    ),
    (
        crate::EncodedStr::Ascii("deracializing"),
        &[(0b01001, &ENTRY_DERACIALIZING_14275754837816585059)],
    ),
    (
        crate::EncodedStr::Ascii("derationalisation"),
        &[(0b10010, &ENTRY_DERATIONALIZATION_10528830942768591126)],
    ),
    (
        crate::EncodedStr::Ascii("derationalisations"),
        &[(0b10010, &ENTRY_DERATIONALIZATIONS_17119655431636120190)],
    ),
    (
        crate::EncodedStr::Ascii("derationalise"),
        &[(0b10010, &ENTRY_DERATIONALIZE_2313042250140882971)],
    ),
    (
        crate::EncodedStr::Ascii("derationalises"),
        &[(0b10010, &ENTRY_DERATIONALIZES_3693097460338270754)],
    ),
    (
        crate::EncodedStr::Ascii("derationalization"),
        &[(0b01001, &ENTRY_DERATIONALIZATION_10528830942768591126)],
    ),
    (
        crate::EncodedStr::Ascii("derationalizations"),
        &[(0b01001, &ENTRY_DERATIONALIZATIONS_17119655431636120190)],
    ),
    (
        crate::EncodedStr::Ascii("derationalize"),
        &[(0b01001, &ENTRY_DERATIONALIZE_2313042250140882971)],
    ),
    (
        crate::EncodedStr::Ascii("derationalizes"),
        &[(0b01001, &ENTRY_DERATIONALIZES_3693097460338270754)],
    ),
    (
        crate::EncodedStr::Ascii("deratisation"),
        &[(0b10010, &ENTRY_DERATIZATION_1556052931660067306)],
    ),
    (
        crate::EncodedStr::Ascii("deratisations"),
        &[(0b10010, &ENTRY_DERATIZATIONS_2987948756893457504)],
    ),
    (
        crate::EncodedStr::Ascii("deratization"),
        &[(0b01001, &ENTRY_DERATIZATION_1556052931660067306)],
    ),
    (
        crate::EncodedStr::Ascii("deratizations"),
        &[(0b01001, &ENTRY_DERATIZATIONS_2987948756893457504)],
    ),
    (
        crate::EncodedStr::Ascii("derealisation"),
        &[(0b10010, &ENTRY_DEREALIZATION_4431015585806198367)],
    ),
    (
        crate::EncodedStr::Ascii("derealization"),
        &[(0b01001, &ENTRY_DEREALIZATION_4431015585806198367)],
    ),
    (
        crate::EncodedStr::Ascii("derecognise"),
        &[(0b10010, &ENTRY_DERECOGNIZE_12966064062970832050)],
    ),
    (
        crate::EncodedStr::Ascii("derecognised"),
        &[(0b10010, &ENTRY_DERECOGNIZED_10133422456568606840)],
    ),
    (
        crate::EncodedStr::Ascii("derecognises"),
        &[(0b10010, &ENTRY_DERECOGNIZES_2898686597965431739)],
    ),
    (
        crate::EncodedStr::Ascii("derecognising"),
        &[(0b10010, &ENTRY_DERECOGNIZING_15630007461435589758)],
    ),
    (
        crate::EncodedStr::Ascii("derecognize"),
        &[(0b01001, &ENTRY_DERECOGNIZE_12966064062970832050)],
    ),
    (
        crate::EncodedStr::Ascii("derecognized"),
        &[(0b01001, &ENTRY_DERECOGNIZED_10133422456568606840)],
    ),
    (
        crate::EncodedStr::Ascii("derecognizes"),
        &[(0b01001, &ENTRY_DERECOGNIZES_2898686597965431739)],
    ),
    (
        crate::EncodedStr::Ascii("derecognizing"),
        &[(0b01001, &ENTRY_DERECOGNIZING_15630007461435589758)],
    ),
    (
        crate::EncodedStr::Ascii("deregulationise"),
        &[(0b10010, &ENTRY_DEREGULATIONIZE_4270787265190494422)],
    ),
    (
        crate::EncodedStr::Ascii("deregulationises"),
        &[(0b10010, &ENTRY_DEREGULATIONIZES_10669971165971717976)],
    ),
    (
        crate::EncodedStr::Ascii("deregulationize"),
        &[(0b01001, &ENTRY_DEREGULATIONIZE_4270787265190494422)],
    ),
    (
        crate::EncodedStr::Ascii("deregulationizes"),
        &[(0b01001, &ENTRY_DEREGULATIONIZES_10669971165971717976)],
    ),
    (
        crate::EncodedStr::Ascii("dereligionise"),
        &[(0b10010, &ENTRY_DERELIGIONIZE_2197762790814142315)],
    ),
    (
        crate::EncodedStr::Ascii("dereligionised"),
        &[(0b10010, &ENTRY_DERELIGIONIZED_12703552936820666292)],
    ),
    (
        crate::EncodedStr::Ascii("dereligionises"),
        &[(0b10010, &ENTRY_DERELIGIONIZES_15734216747597028796)],
    ),
    (
        crate::EncodedStr::Ascii("dereligionising"),
        &[(0b10010, &ENTRY_DERELIGIONIZING_5815795344545989827)],
    ),
    (
        crate::EncodedStr::Ascii("dereligionize"),
        &[(0b01001, &ENTRY_DERELIGIONIZE_2197762790814142315)],
    ),
    (
        crate::EncodedStr::Ascii("dereligionized"),
        &[(0b01001, &ENTRY_DERELIGIONIZED_12703552936820666292)],
    ),
    (
        crate::EncodedStr::Ascii("dereligionizes"),
        &[(0b01001, &ENTRY_DERELIGIONIZES_15734216747597028796)],
    ),
    (
        crate::EncodedStr::Ascii("dereligionizing"),
        &[(0b01001, &ENTRY_DERELIGIONIZING_5815795344545989827)],
    ),
    (
        crate::EncodedStr::Ascii("derk"),
        &[(0b00001, &ENTRY_DERK_4716671464297446249)],
    ),
    (
        crate::EncodedStr::Ascii("dermatorrhea"),
        &[(0b10001, &ENTRY_DERMATORRHEA_1805754234241080569)],
    ),
    (
        crate::EncodedStr::Ascii("dermatorrhoea"),
        &[(0b11010, &ENTRY_DERMATORRHEA_1805754234241080569)],
    ),
    (
        crate::EncodedStr::Ascii("derr"),
        &[(0b00001, &ENTRY_DERR_8497357744990730455)],
    ),
    (
        crate::EncodedStr::Ascii("desacralisation"),
        &[(0b10010, &ENTRY_DESACRALIZATION_8933482512308094840)],
    ),
    (
        crate::EncodedStr::Ascii("desacralisations"),
        &[(0b10010, &ENTRY_DESACRALIZATIONS_3159008120594250545)],
    ),
    (
        crate::EncodedStr::Ascii("desacralise"),
        &[(0b10010, &ENTRY_DESACRALIZE_2904720596855309711)],
    ),
    (
        crate::EncodedStr::Ascii("desacralised"),
        &[(0b10010, &ENTRY_DESACRALIZED_5172113800600262057)],
    ),
    (
        crate::EncodedStr::Ascii("desacralises"),
        &[(0b10010, &ENTRY_DESACRALIZES_3129397141770379489)],
    ),
    (
        crate::EncodedStr::Ascii("desacralising"),
        &[(0b10010, &ENTRY_DESACRALIZING_1923812032604675331)],
    ),
    (
        crate::EncodedStr::Ascii("desacralization"),
        &[(0b01001, &ENTRY_DESACRALIZATION_8933482512308094840)],
    ),
    (
        crate::EncodedStr::Ascii("desacralizations"),
        &[(0b01001, &ENTRY_DESACRALIZATIONS_3159008120594250545)],
    ),
    (
        crate::EncodedStr::Ascii("desacralize"),
        &[(0b01001, &ENTRY_DESACRALIZE_2904720596855309711)],
    ),
    (
        crate::EncodedStr::Ascii("desacralized"),
        &[(0b01001, &ENTRY_DESACRALIZED_5172113800600262057)],
    ),
    (
        crate::EncodedStr::Ascii("desacralizes"),
        &[(0b01001, &ENTRY_DESACRALIZES_3129397141770379489)],
    ),
    (
        crate::EncodedStr::Ascii("desacralizing"),
        &[(0b01001, &ENTRY_DESACRALIZING_1923812032604675331)],
    ),
    (
        crate::EncodedStr::Ascii("desalinisation"),
        &[(0b10010, &ENTRY_DESALINIZATION_3112141684596769008)],
    ),
    (
        crate::EncodedStr::Ascii("desalinisations"),
        &[(0b10010, &ENTRY_DESALINIZATIONS_6688266856012610087)],
    ),
    (
        crate::EncodedStr::Ascii("desalinise"),
        &[(0b10010, &ENTRY_DESALINIZE_14106924193733250969)],
    ),
    (
        crate::EncodedStr::Ascii("desalinised"),
        &[(0b10010, &ENTRY_DESALINIZED_15785822948480949641)],
    ),
    (
        crate::EncodedStr::Ascii("desalinises"),
        &[(0b10010, &ENTRY_DESALINIZES_9833000153222176974)],
    ),
    (
        crate::EncodedStr::Ascii("desalinising"),
        &[(0b10010, &ENTRY_DESALINIZING_375221854324330696)],
    ),
    (
        crate::EncodedStr::Ascii("desalinization"),
        &[(0b01001, &ENTRY_DESALINIZATION_3112141684596769008)],
    ),
    (
        crate::EncodedStr::Ascii("desalinizations"),
        &[(0b01001, &ENTRY_DESALINIZATIONS_6688266856012610087)],
    ),
    (
        crate::EncodedStr::Ascii("desalinize"),
        &[(0b01001, &ENTRY_DESALINIZE_14106924193733250969)],
    ),
    (
        crate::EncodedStr::Ascii("desalinized"),
        &[(0b01001, &ENTRY_DESALINIZED_15785822948480949641)],
    ),
    (
        crate::EncodedStr::Ascii("desalinizes"),
        &[(0b01001, &ENTRY_DESALINIZES_9833000153222176974)],
    ),
    (
        crate::EncodedStr::Ascii("desalinizing"),
        &[(0b01001, &ENTRY_DESALINIZING_375221854324330696)],
    ),
    (
        crate::EncodedStr::Ascii("descendents"),
        &[(0b00001, &ENTRY_DESCENDANTS_13592723156308791185)],
    ),
    (
        crate::EncodedStr::Ascii("desensitisation"),
        &[(0b10010, &ENTRY_DESENSITIZATION_12566365864470462238)],
    ),
    (
        crate::EncodedStr::Ascii("desensitisations"),
        &[(0b10010, &ENTRY_DESENSITIZATIONS_8251374796564084894)],
    ),
    (
        crate::EncodedStr::Ascii("desensitise"),
        &[(0b10010, &ENTRY_DESENSITIZE_3550903971648567607)],
    ),
    (
        crate::EncodedStr::Ascii("desensitised"),
        &[(0b10010, &ENTRY_DESENSITIZED_16642593456085222259)],
    ),
    (
        crate::EncodedStr::Ascii("desensitiser"),
        &[(0b10010, &ENTRY_DESENSITIZER_6020988563376810609)],
    ),
    (
        crate::EncodedStr::Ascii("desensitisers"),
        &[(0b10010, &ENTRY_DESENSITIZERS_14718511209845696977)],
    ),
    (
        crate::EncodedStr::Ascii("desensitises"),
        &[(0b10010, &ENTRY_DESENSITIZES_7107240430399068707)],
    ),
    (
        crate::EncodedStr::Ascii("desensitising"),
        &[(0b10010, &ENTRY_DESENSITIZING_16627131864153604352)],
    ),
    (
        crate::EncodedStr::Ascii("desensitization"),
        &[(0b01001, &ENTRY_DESENSITIZATION_12566365864470462238)],
    ),
    (
        crate::EncodedStr::Ascii("desensitizations"),
        &[(0b01001, &ENTRY_DESENSITIZATIONS_8251374796564084894)],
    ),
    (
        crate::EncodedStr::Ascii("desensitize"),
        &[(0b01001, &ENTRY_DESENSITIZE_3550903971648567607)],
    ),
    (
        crate::EncodedStr::Ascii("desensitized"),
        &[(0b01001, &ENTRY_DESENSITIZED_16642593456085222259)],
    ),
    (
        crate::EncodedStr::Ascii("desensitizer"),
        &[(0b01001, &ENTRY_DESENSITIZER_6020988563376810609)],
    ),
    (
        crate::EncodedStr::Ascii("desensitizers"),
        &[(0b01001, &ENTRY_DESENSITIZERS_14718511209845696977)],
    ),
    (
        crate::EncodedStr::Ascii("desensitizes"),
        &[(0b01001, &ENTRY_DESENSITIZES_7107240430399068707)],
    ),
    (
        crate::EncodedStr::Ascii("desensitizing"),
        &[(0b01001, &ENTRY_DESENSITIZING_16627131864153604352)],
    ),
    (
        crate::EncodedStr::Ascii("desertisation"),
        &[(0b10010, &ENTRY_DESERTIZATION_14992284590814327365)],
    ),
    (
        crate::EncodedStr::Ascii("desertisations"),
        &[(0b10010, &ENTRY_DESERTIZATIONS_9614321958416784718)],
    ),
    (
        crate::EncodedStr::Ascii("desertization"),
        &[(0b01001, &ENTRY_DESERTIZATION_14992284590814327365)],
    ),
    (
        crate::EncodedStr::Ascii("desertizations"),
        &[(0b01001, &ENTRY_DESERTIZATIONS_9614321958416784718)],
    ),
    (
        crate::EncodedStr::Ascii("desexualisation"),
        &[(0b10010, &ENTRY_DESEXUALIZATION_7051669726674300306)],
    ),
    (
        crate::EncodedStr::Ascii("desexualisations"),
        &[(0b10010, &ENTRY_DESEXUALIZATIONS_317703425355638040)],
    ),
    (
        crate::EncodedStr::Ascii("desexualise"),
        &[(0b10010, &ENTRY_DESEXUALIZE_4949470699070422167)],
    ),
    (
        crate::EncodedStr::Ascii("desexualised"),
        &[(0b10010, &ENTRY_DESEXUALIZED_709042860780979441)],
    ),
    (
        crate::EncodedStr::Ascii("desexualises"),
        &[(0b10010, &ENTRY_DESEXUALIZES_12483266755535786660)],
    ),
    (
        crate::EncodedStr::Ascii("desexualising"),
        &[(0b10010, &ENTRY_DESEXUALIZING_9440019274877492043)],
    ),
    (
        crate::EncodedStr::Ascii("desexualization"),
        &[(0b01001, &ENTRY_DESEXUALIZATION_7051669726674300306)],
    ),
    (
        crate::EncodedStr::Ascii("desexualizations"),
        &[(0b01001, &ENTRY_DESEXUALIZATIONS_317703425355638040)],
    ),
    (
        crate::EncodedStr::Ascii("desexualize"),
        &[(0b01001, &ENTRY_DESEXUALIZE_4949470699070422167)],
    ),
    (
        crate::EncodedStr::Ascii("desexualized"),
        &[(0b01001, &ENTRY_DESEXUALIZED_709042860780979441)],
    ),
    (
        crate::EncodedStr::Ascii("desexualizes"),
        &[(0b01001, &ENTRY_DESEXUALIZES_12483266755535786660)],
    ),
    (
        crate::EncodedStr::Ascii("desexualizing"),
        &[(0b01001, &ENTRY_DESEXUALIZING_9440019274877492043)],
    ),
    (
        crate::EncodedStr::Ascii("desilverisation"),
        &[(0b10010, &ENTRY_DESILVERIZATION_7083077588146441964)],
    ),
    (
        crate::EncodedStr::Ascii("desilverisations"),
        &[(0b10010, &ENTRY_DESILVERIZATIONS_3476812538372816382)],
    ),
    (
        crate::EncodedStr::Ascii("desilverise"),
        &[(0b10010, &ENTRY_DESILVERIZE_6336096088586818504)],
    ),
    (
        crate::EncodedStr::Ascii("desilverised"),
        &[(0b10010, &ENTRY_DESILVERIZED_16070622223837559170)],
    ),
    (
        crate::EncodedStr::Ascii("desilverises"),
        &[(0b10010, &ENTRY_DESILVERIZES_557243620662112813)],
    ),
    (
        crate::EncodedStr::Ascii("desilverising"),
        &[(0b10010, &ENTRY_DESILVERIZING_13130813397466342155)],
    ),
    (
        crate::EncodedStr::Ascii("desilverization"),
        &[(0b01001, &ENTRY_DESILVERIZATION_7083077588146441964)],
    ),
    (
        crate::EncodedStr::Ascii("desilverizations"),
        &[(0b01001, &ENTRY_DESILVERIZATIONS_3476812538372816382)],
    ),
    (
        crate::EncodedStr::Ascii("desilverize"),
        &[(0b01001, &ENTRY_DESILVERIZE_6336096088586818504)],
    ),
    (
        crate::EncodedStr::Ascii("desilverized"),
        &[(0b01001, &ENTRY_DESILVERIZED_16070622223837559170)],
    ),
    (
        crate::EncodedStr::Ascii("desilverizes"),
        &[(0b01001, &ENTRY_DESILVERIZES_557243620662112813)],
    ),
    (
        crate::EncodedStr::Ascii("desilverizing"),
        &[(0b01001, &ENTRY_DESILVERIZING_13130813397466342155)],
    ),
    (
        crate::EncodedStr::Ascii("despatch"),
        &[(0b10011, &ENTRY_DISPATCH_4830799078943953115)],
    ),
    (
        crate::EncodedStr::Ascii("despatched"),
        &[(0b10011, &ENTRY_DISPATCHED_15382141028599285955)],
    ),
    (
        crate::EncodedStr::Ascii("despatches"),
        &[(0b10011, &ENTRY_DISPATCHES_13572237410774142362)],
    ),
    (
        crate::EncodedStr::Ascii("despatching"),
        &[(0b10011, &ENTRY_DISPATCHING_13590867743632657867)],
    ),
    (
        crate::EncodedStr::Ascii("despiritualisation"),
        &[(0b10010, &ENTRY_DESPIRITUALIZATION_9440879345640859842)],
    ),
    (
        crate::EncodedStr::Ascii("despiritualise"),
        &[(0b10010, &ENTRY_DESPIRITUALIZE_18226118672475753223)],
    ),
    (
        crate::EncodedStr::Ascii("despiritualization"),
        &[(0b01001, &ENTRY_DESPIRITUALIZATION_9440879345640859842)],
    ),
    (
        crate::EncodedStr::Ascii("despiritualize"),
        &[(0b01001, &ENTRY_DESPIRITUALIZE_18226118672475753223)],
    ),
    (
        crate::EncodedStr::Ascii("despotise"),
        &[(0b10010, &ENTRY_DESPOTIZE_7875765767418230550)],
    ),
    (
        crate::EncodedStr::Ascii("despotises"),
        &[(0b10010, &ENTRY_DESPOTIZES_5251286731168770044)],
    ),
    (
        crate::EncodedStr::Ascii("despotize"),
        &[(0b01001, &ENTRY_DESPOTIZE_7875765767418230550)],
    ),
    (
        crate::EncodedStr::Ascii("despotizes"),
        &[(0b01001, &ENTRY_DESPOTIZES_5251286731168770044)],
    ),
    (
        crate::EncodedStr::Ascii("destabilisation"),
        &[(0b10010, &ENTRY_DESTABILIZATION_14326190546524052452)],
    ),
    (
        crate::EncodedStr::Ascii("destabilise"),
        &[(0b10010, &ENTRY_DESTABILIZE_5513808993828420574)],
    ),
    (
        crate::EncodedStr::Ascii("destabilised"),
        &[(0b10010, &ENTRY_DESTABILIZED_1777832444349565509)],
    ),
    (
        crate::EncodedStr::Ascii("destabiliser"),
        &[(0b10010, &ENTRY_DESTABILIZER_5486156107617069595)],
    ),
    (
        crate::EncodedStr::Ascii("destabilisers"),
        &[(0b10010, &ENTRY_DESTABILIZERS_6141576176215173386)],
    ),
    (
        crate::EncodedStr::Ascii("destabilises"),
        &[(0b10010, &ENTRY_DESTABILIZES_13491486327241590151)],
    ),
    (
        crate::EncodedStr::Ascii("destabilising"),
        &[(0b10010, &ENTRY_DESTABILIZING_10660910526175900618)],
    ),
    (
        crate::EncodedStr::Ascii("destabilization"),
        &[(0b01001, &ENTRY_DESTABILIZATION_14326190546524052452)],
    ),
    (
        crate::EncodedStr::Ascii("destabilize"),
        &[(0b01001, &ENTRY_DESTABILIZE_5513808993828420574)],
    ),
    (
        crate::EncodedStr::Ascii("destabilized"),
        &[(0b01001, &ENTRY_DESTABILIZED_1777832444349565509)],
    ),
    (
        crate::EncodedStr::Ascii("destabilizer"),
        &[(0b01001, &ENTRY_DESTABILIZER_5486156107617069595)],
    ),
    (
        crate::EncodedStr::Ascii("destabilizers"),
        &[(0b01001, &ENTRY_DESTABILIZERS_6141576176215173386)],
    ),
    (
        crate::EncodedStr::Ascii("destabilizes"),
        &[(0b01001, &ENTRY_DESTABILIZES_13491486327241590151)],
    ),
    (
        crate::EncodedStr::Ascii("destabilizing"),
        &[(0b01001, &ENTRY_DESTABILIZING_10660910526175900618)],
    ),
    (
        crate::EncodedStr::Ascii("destalinise"),
        &[(0b10010, &ENTRY_DESTALINIZE_9557464174451415418)],
    ),
    (
        crate::EncodedStr::Ascii("destalinised"),
        &[(0b10010, &ENTRY_DESTALINIZED_9729731297639277285)],
    ),
    (
        crate::EncodedStr::Ascii("destalinises"),
        &[(0b10010, &ENTRY_DESTALINIZES_5575846993066512172)],
    ),
    (
        crate::EncodedStr::Ascii("destalinising"),
        &[(0b10010, &ENTRY_DESTALINIZING_365060634953959661)],
    ),
    (
        crate::EncodedStr::Ascii("destalinize"),
        &[(0b01001, &ENTRY_DESTALINIZE_9557464174451415418)],
    ),
    (
        crate::EncodedStr::Ascii("destalinized"),
        &[(0b01001, &ENTRY_DESTALINIZED_9729731297639277285)],
    ),
    (
        crate::EncodedStr::Ascii("destalinizes"),
        &[(0b01001, &ENTRY_DESTALINIZES_5575846993066512172)],
    ),
    (
        crate::EncodedStr::Ascii("destalinizing"),
        &[(0b01001, &ENTRY_DESTALINIZING_365060634953959661)],
    ),
    (
        crate::EncodedStr::Ascii("desterilise"),
        &[(0b10010, &ENTRY_DESTERILIZE_10235095546341603640)],
    ),
    (
        crate::EncodedStr::Ascii("desterilize"),
        &[(0b01001, &ENTRY_DESTERILIZE_10235095546341603640)],
    ),
    (
        crate::EncodedStr::Ascii("destigmatisation"),
        &[(0b10010, &ENTRY_DESTIGMATIZATION_76784710048289446)],
    ),
    (
        crate::EncodedStr::Ascii("destigmatization"),
        &[(0b01001, &ENTRY_DESTIGMATIZATION_76784710048289446)],
    ),
    (
        crate::EncodedStr::Ascii("desulfuriser"),
        &[(0b10010, &ENTRY_DESULFURIZER_5734678686912127702)],
    ),
    (
        crate::EncodedStr::Ascii("desulfurization"),
        &[(0b00001, &ENTRY_DESULFURIZATION_10145479217290079220)],
    ),
    (
        crate::EncodedStr::Ascii("desulfurizations"),
        &[(0b00001, &ENTRY_DESULFURIZATIONS_14861998503665123704)],
    ),
    (
        crate::EncodedStr::Ascii("desulfurize"),
        &[(0b00001, &ENTRY_DESULFURIZE_12876573712862714533)],
    ),
    (
        crate::EncodedStr::Ascii("desulfurized"),
        &[(0b00001, &ENTRY_DESULFURIZED_1535371682591396877)],
    ),
    (
        crate::EncodedStr::Ascii("desulfurizer"),
        &[(0b01001, &ENTRY_DESULFURIZER_5734678686912127702)],
    ),
    (
        crate::EncodedStr::Ascii("desulfurizes"),
        &[(0b00001, &ENTRY_DESULFURIZES_1197207125684665875)],
    ),
    (
        crate::EncodedStr::Ascii("desulfurizing"),
        &[(0b00001, &ENTRY_DESULFURIZING_7858975859555627847)],
    ),
    (
        crate::EncodedStr::Ascii("desulphurisation"),
        &[(0b10010, &ENTRY_DESULFURIZATION_10145479217290079220)],
    ),
    (
        crate::EncodedStr::Ascii("desulphurisations"),
        &[(0b10010, &ENTRY_DESULFURIZATIONS_14861998503665123704)],
    ),
    (
        crate::EncodedStr::Ascii("desulphurise"),
        &[(0b10010, &ENTRY_DESULFURIZE_12876573712862714533)],
    ),
    (
        crate::EncodedStr::Ascii("desulphurised"),
        &[(0b10010, &ENTRY_DESULFURIZED_1535371682591396877)],
    ),
    (
        crate::EncodedStr::Ascii("desulphuriser"),
        &[(0b10010, &ENTRY_DESULPHURIZER_10137789356803923951)],
    ),
    (
        crate::EncodedStr::Ascii("desulphurisers"),
        &[(0b10010, &ENTRY_DESULPHURIZERS_282853998000810658)],
    ),
    (
        crate::EncodedStr::Ascii("desulphurises"),
        &[(0b10010, &ENTRY_DESULFURIZES_1197207125684665875)],
    ),
    (
        crate::EncodedStr::Ascii("desulphurising"),
        &[(0b10010, &ENTRY_DESULFURIZING_7858975859555627847)],
    ),
    (
        crate::EncodedStr::Ascii("desulphurization"),
        &[(0b01000, &ENTRY_DESULFURIZATION_10145479217290079220)],
    ),
    (
        crate::EncodedStr::Ascii("desulphurizations"),
        &[(0b01000, &ENTRY_DESULFURIZATIONS_14861998503665123704)],
    ),
    (
        crate::EncodedStr::Ascii("desulphurize"),
        &[(0b01000, &ENTRY_DESULFURIZE_12876573712862714533)],
    ),
    (
        crate::EncodedStr::Ascii("desulphurized"),
        &[(0b01000, &ENTRY_DESULFURIZED_1535371682591396877)],
    ),
    (
        crate::EncodedStr::Ascii("desulphurizer"),
        &[(0b01001, &ENTRY_DESULPHURIZER_10137789356803923951)],
    ),
    (
        crate::EncodedStr::Ascii("desulphurizers"),
        &[(0b01001, &ENTRY_DESULPHURIZERS_282853998000810658)],
    ),
    (
        crate::EncodedStr::Ascii("desulphurizes"),
        &[(0b01000, &ENTRY_DESULFURIZES_1197207125684665875)],
    ),
    (
        crate::EncodedStr::Ascii("desulphurizing"),
        &[(0b01000, &ENTRY_DESULFURIZING_7858975859555627847)],
    ),
    (
        crate::EncodedStr::Ascii("desynchronisation"),
        &[(0b10010, &ENTRY_DESYNCHRONIZATION_15934272175464625660)],
    ),
    (
        crate::EncodedStr::Ascii("desynchronisations"),
        &[(0b10010, &ENTRY_DESYNCHRONIZATIONS_8142294090130517034)],
    ),
    (
        crate::EncodedStr::Ascii("desynchronise"),
        &[(0b10010, &ENTRY_DESYNCHRONIZE_8943647682721253433)],
    ),
    (
        crate::EncodedStr::Ascii("desynchronised"),
        &[(0b10010, &ENTRY_DESYNCHRONIZED_13365058336037754735)],
    ),
    (
        crate::EncodedStr::Ascii("desynchronises"),
        &[(0b10010, &ENTRY_DESYNCHRONIZES_3997067564763019035)],
    ),
    (
        crate::EncodedStr::Ascii("desynchronising"),
        &[(0b10010, &ENTRY_DESYNCHRONIZING_15189349053662354180)],
    ),
    (
        crate::EncodedStr::Ascii("desynchronization"),
        &[(0b01001, &ENTRY_DESYNCHRONIZATION_15934272175464625660)],
    ),
    (
        crate::EncodedStr::Ascii("desynchronizations"),
        &[(0b01001, &ENTRY_DESYNCHRONIZATIONS_8142294090130517034)],
    ),
    (
        crate::EncodedStr::Ascii("desynchronize"),
        &[(0b01001, &ENTRY_DESYNCHRONIZE_8943647682721253433)],
    ),
    (
        crate::EncodedStr::Ascii("desynchronized"),
        &[(0b01001, &ENTRY_DESYNCHRONIZED_13365058336037754735)],
    ),
    (
        crate::EncodedStr::Ascii("desynchronizes"),
        &[(0b01001, &ENTRY_DESYNCHRONIZES_3997067564763019035)],
    ),
    (
        crate::EncodedStr::Ascii("desynchronizing"),
        &[(0b01001, &ENTRY_DESYNCHRONIZING_15189349053662354180)],
    ),
    (
        crate::EncodedStr::Ascii("detribalisation"),
        &[(0b10010, &ENTRY_DETRIBALIZATION_16952730237997981409)],
    ),
    (
        crate::EncodedStr::Ascii("detribalisations"),
        &[(0b10010, &ENTRY_DETRIBALIZATIONS_11756828771994817312)],
    ),
    (
        crate::EncodedStr::Ascii("detribalise"),
        &[(0b10010, &ENTRY_DETRIBALIZE_15143242476306432587)],
    ),
    (
        crate::EncodedStr::Ascii("detribalised"),
        &[(0b10010, &ENTRY_DETRIBALIZED_7286047575373525196)],
    ),
    (
        crate::EncodedStr::Ascii("detribalises"),
        &[(0b10010, &ENTRY_DETRIBALIZES_17667503652444099945)],
    ),
    (
        crate::EncodedStr::Ascii("detribalising"),
        &[(0b10010, &ENTRY_DETRIBALIZING_12535699864595434298)],
    ),
    (
        crate::EncodedStr::Ascii("detribalization"),
        &[(0b01001, &ENTRY_DETRIBALIZATION_16952730237997981409)],
    ),
    (
        crate::EncodedStr::Ascii("detribalizations"),
        &[(0b01001, &ENTRY_DETRIBALIZATIONS_11756828771994817312)],
    ),
    (
        crate::EncodedStr::Ascii("detribalize"),
        &[(0b01001, &ENTRY_DETRIBALIZE_15143242476306432587)],
    ),
    (
        crate::EncodedStr::Ascii("detribalized"),
        &[(0b01001, &ENTRY_DETRIBALIZED_7286047575373525196)],
    ),
    (
        crate::EncodedStr::Ascii("detribalizes"),
        &[(0b01001, &ENTRY_DETRIBALIZES_17667503652444099945)],
    ),
    (
        crate::EncodedStr::Ascii("detribalizing"),
        &[(0b01001, &ENTRY_DETRIBALIZING_12535699864595434298)],
    ),
    (
        crate::EncodedStr::Ascii("deva"),
        &[(0b00001, &ENTRY_DEVA_18303315502243076060)],
    ),
    (
        crate::EncodedStr::Ascii("devalorisation"),
        &[(0b10010, &ENTRY_DEVALORIZATION_15315014812840888413)],
    ),
    (
        crate::EncodedStr::Ascii("devalorisations"),
        &[(0b10010, &ENTRY_DEVALORIZATIONS_12670639433164026734)],
    ),
    (
        crate::EncodedStr::Ascii("devalorise"),
        &[(0b10010, &ENTRY_DEVALORIZE_10794559313991782118)],
    ),
    (
        crate::EncodedStr::Ascii("devalorised"),
        &[(0b10010, &ENTRY_DEVALORIZED_10544100609075377554)],
    ),
    (
        crate::EncodedStr::Ascii("devalorises"),
        &[(0b10010, &ENTRY_DEVALORIZES_4580727997112987764)],
    ),
    (
        crate::EncodedStr::Ascii("devalorising"),
        &[(0b10010, &ENTRY_DEVALORIZING_745754966056062243)],
    ),
    (
        crate::EncodedStr::Ascii("devalorization"),
        &[(0b01001, &ENTRY_DEVALORIZATION_15315014812840888413)],
    ),
    (
        crate::EncodedStr::Ascii("devalorizations"),
        &[(0b01001, &ENTRY_DEVALORIZATIONS_12670639433164026734)],
    ),
    (
        crate::EncodedStr::Ascii("devalorize"),
        &[(0b01001, &ENTRY_DEVALORIZE_10794559313991782118)],
    ),
    (
        crate::EncodedStr::Ascii("devalorized"),
        &[(0b01001, &ENTRY_DEVALORIZED_10544100609075377554)],
    ),
    (
        crate::EncodedStr::Ascii("devalorizes"),
        &[(0b01001, &ENTRY_DEVALORIZES_4580727997112987764)],
    ),
    (
        crate::EncodedStr::Ascii("devalorizing"),
        &[(0b01001, &ENTRY_DEVALORIZING_745754966056062243)],
    ),
    (
        crate::EncodedStr::Ascii("develed"),
        &[(0b00001, &ENTRY_DEVELED_13710518174394409286)],
    ),
    (
        crate::EncodedStr::Ascii("develing"),
        &[(0b00001, &ENTRY_DEVELING_8091139982686168573)],
    ),
    (
        crate::EncodedStr::Ascii("develled"),
        &[(0b11010, &ENTRY_DEVELED_13710518174394409286)],
    ),
    (
        crate::EncodedStr::Ascii("develling"),
        &[(0b11010, &ENTRY_DEVELING_8091139982686168573)],
    ),
    (
        crate::EncodedStr::Ascii("deviled"),
        &[(0b00001, &ENTRY_DEVILED_13014517801589922329)],
    ),
    (
        crate::EncodedStr::Ascii("deviling"),
        &[(0b00001, &ENTRY_DEVILING_6936097926436525993)],
    ),
    (
        crate::EncodedStr::Ascii("devilise"),
        &[(0b10010, &ENTRY_DEVILIZE_9795464369905562385)],
    ),
    (
        crate::EncodedStr::Ascii("devilises"),
        &[(0b10010, &ENTRY_DEVILIZES_17745578183045333673)],
    ),
    (
        crate::EncodedStr::Ascii("devilize"),
        &[(0b01001, &ENTRY_DEVILIZE_9795464369905562385)],
    ),
    (
        crate::EncodedStr::Ascii("devilizes"),
        &[(0b01001, &ENTRY_DEVILIZES_17745578183045333673)],
    ),
    (
        crate::EncodedStr::Ascii("devilled"),
        &[(0b11010, &ENTRY_DEVILED_13014517801589922329)],
    ),
    (
        crate::EncodedStr::Ascii("devilling"),
        &[(0b11010, &ENTRY_DEVILING_6936097926436525993)],
    ),
    (
        crate::EncodedStr::Ascii("devitalisation"),
        &[(0b10010, &ENTRY_DEVITALIZATION_2114332477720992030)],
    ),
    (
        crate::EncodedStr::Ascii("devitalisations"),
        &[(0b10010, &ENTRY_DEVITALIZATIONS_13354425441260498778)],
    ),
    (
        crate::EncodedStr::Ascii("devitalise"),
        &[(0b10010, &ENTRY_DEVITALIZE_1043658353870554736)],
    ),
    (
        crate::EncodedStr::Ascii("devitalised"),
        &[(0b10010, &ENTRY_DEVITALIZED_8717395560461798050)],
    ),
    (
        crate::EncodedStr::Ascii("devitalises"),
        &[(0b10010, &ENTRY_DEVITALIZES_9074596952558116656)],
    ),
    (
        crate::EncodedStr::Ascii("devitalising"),
        &[(0b10010, &ENTRY_DEVITALIZING_14131643871253145067)],
    ),
    (
        crate::EncodedStr::Ascii("devitalization"),
        &[(0b01001, &ENTRY_DEVITALIZATION_2114332477720992030)],
    ),
    (
        crate::EncodedStr::Ascii("devitalizations"),
        &[(0b01001, &ENTRY_DEVITALIZATIONS_13354425441260498778)],
    ),
    (
        crate::EncodedStr::Ascii("devitalize"),
        &[(0b01001, &ENTRY_DEVITALIZE_1043658353870554736)],
    ),
    (
        crate::EncodedStr::Ascii("devitalized"),
        &[(0b01001, &ENTRY_DEVITALIZED_8717395560461798050)],
    ),
    (
        crate::EncodedStr::Ascii("devitalizes"),
        &[(0b01001, &ENTRY_DEVITALIZES_9074596952558116656)],
    ),
    (
        crate::EncodedStr::Ascii("devitalizing"),
        &[(0b01001, &ENTRY_DEVITALIZING_14131643871253145067)],
    ),
    (
        crate::EncodedStr::Ascii("devocalisation"),
        &[(0b10010, &ENTRY_DEVOCALIZATION_10444917076714233126)],
    ),
    (
        crate::EncodedStr::Ascii("devocalise"),
        &[(0b10010, &ENTRY_DEVOCALIZE_1529649237001829017)],
    ),
    (
        crate::EncodedStr::Ascii("devocalised"),
        &[(0b10010, &ENTRY_DEVOCALIZED_16555396131330717996)],
    ),
    (
        crate::EncodedStr::Ascii("devocalises"),
        &[(0b10010, &ENTRY_DEVOCALIZES_11452435934127095123)],
    ),
    (
        crate::EncodedStr::Ascii("devocalising"),
        &[(0b10010, &ENTRY_DEVOCALIZING_540893798000083473)],
    ),
    (
        crate::EncodedStr::Ascii("devocalization"),
        &[(0b01001, &ENTRY_DEVOCALIZATION_10444917076714233126)],
    ),
    (
        crate::EncodedStr::Ascii("devocalize"),
        &[(0b01001, &ENTRY_DEVOCALIZE_1529649237001829017)],
    ),
    (
        crate::EncodedStr::Ascii("devocalized"),
        &[(0b01001, &ENTRY_DEVOCALIZED_16555396131330717996)],
    ),
    (
        crate::EncodedStr::Ascii("devocalizes"),
        &[(0b01001, &ENTRY_DEVOCALIZES_11452435934127095123)],
    ),
    (
        crate::EncodedStr::Ascii("devocalizing"),
        &[(0b01001, &ENTRY_DEVOCALIZING_540893798000083473)],
    ),
    (
        crate::EncodedStr::Ascii("devolatilisation"),
        &[(0b10010, &ENTRY_DEVOLATILIZATION_4689429575223597286)],
    ),
    (
        crate::EncodedStr::Ascii("devolatilisations"),
        &[(0b10010, &ENTRY_DEVOLATILIZATIONS_4707574596121848991)],
    ),
    (
        crate::EncodedStr::Ascii("devolatilise"),
        &[(0b10010, &ENTRY_DEVOLATILIZE_11441006506088892627)],
    ),
    (
        crate::EncodedStr::Ascii("devolatilised"),
        &[(0b10010, &ENTRY_DEVOLATILIZED_507035959515124086)],
    ),
    (
        crate::EncodedStr::Ascii("devolatilises"),
        &[(0b10010, &ENTRY_DEVOLATILIZES_8071137154044730701)],
    ),
    (
        crate::EncodedStr::Ascii("devolatilising"),
        &[(0b10010, &ENTRY_DEVOLATILIZING_9726618714956110506)],
    ),
    (
        crate::EncodedStr::Ascii("devolatilization"),
        &[(0b01001, &ENTRY_DEVOLATILIZATION_4689429575223597286)],
    ),
    (
        crate::EncodedStr::Ascii("devolatilizations"),
        &[(0b01001, &ENTRY_DEVOLATILIZATIONS_4707574596121848991)],
    ),
    (
        crate::EncodedStr::Ascii("devolatilize"),
        &[(0b01001, &ENTRY_DEVOLATILIZE_11441006506088892627)],
    ),
    (
        crate::EncodedStr::Ascii("devolatilized"),
        &[(0b01001, &ENTRY_DEVOLATILIZED_507035959515124086)],
    ),
    (
        crate::EncodedStr::Ascii("devolatilizes"),
        &[(0b01001, &ENTRY_DEVOLATILIZES_8071137154044730701)],
    ),
    (
        crate::EncodedStr::Ascii("devolatilizing"),
        &[(0b01001, &ENTRY_DEVOLATILIZING_9726618714956110506)],
    ),
    (
        crate::EncodedStr::Ascii("diabolisation"),
        &[(0b10010, &ENTRY_DIABOLIZATION_8147427661526738727)],
    ),
    (
        crate::EncodedStr::Ascii("diabolisations"),
        &[(0b10010, &ENTRY_DIABOLIZATIONS_3822742467764077320)],
    ),
    (
        crate::EncodedStr::Ascii("diabolise"),
        &[(0b10010, &ENTRY_DIABOLIZE_13327939806411873396)],
    ),
    (
        crate::EncodedStr::Ascii("diabolised"),
        &[(0b10010, &ENTRY_DIABOLIZED_5121441305555041821)],
    ),
    (
        crate::EncodedStr::Ascii("diabolises"),
        &[(0b10010, &ENTRY_DIABOLIZES_6289744568368918053)],
    ),
    (
        crate::EncodedStr::Ascii("diabolising"),
        &[(0b10010, &ENTRY_DIABOLIZING_17353660640060220296)],
    ),
    (
        crate::EncodedStr::Ascii("diabolization"),
        &[(0b01001, &ENTRY_DIABOLIZATION_8147427661526738727)],
    ),
    (
        crate::EncodedStr::Ascii("diabolizations"),
        &[(0b01001, &ENTRY_DIABOLIZATIONS_3822742467764077320)],
    ),
    (
        crate::EncodedStr::Ascii("diabolize"),
        &[(0b01001, &ENTRY_DIABOLIZE_13327939806411873396)],
    ),
    (
        crate::EncodedStr::Ascii("diabolized"),
        &[(0b01001, &ENTRY_DIABOLIZED_5121441305555041821)],
    ),
    (
        crate::EncodedStr::Ascii("diabolizes"),
        &[(0b01001, &ENTRY_DIABOLIZES_6289744568368918053)],
    ),
    (
        crate::EncodedStr::Ascii("diabolizing"),
        &[(0b01001, &ENTRY_DIABOLIZING_17353660640060220296)],
    ),
    (
        crate::EncodedStr::Ascii("diaene"),
        &[(0b11010, &ENTRY_DIENE_8393408286309594192)],
    ),
    (
        crate::EncodedStr::Ascii("diaeretic"),
        &[(0b11010, &ENTRY_DIERETIC_13830183413584247379)],
    ),
    (
        crate::EncodedStr::Ascii("diagonalisable"),
        &[(0b10010, &ENTRY_DIAGONALIZABLE_10977422841248602526)],
    ),
    (
        crate::EncodedStr::Ascii("diagonalisation"),
        &[(0b10010, &ENTRY_DIAGONALIZATION_17906612353739944122)],
    ),
    (
        crate::EncodedStr::Ascii("diagonalise"),
        &[(0b10010, &ENTRY_DIAGONALIZE_17545470866818361268)],
    ),
    (
        crate::EncodedStr::Ascii("diagonalised"),
        &[(0b10010, &ENTRY_DIAGONALIZED_16278489065750351065)],
    ),
    (
        crate::EncodedStr::Ascii("diagonalises"),
        &[(0b10010, &ENTRY_DIAGONALIZES_15436394800752209539)],
    ),
    (
        crate::EncodedStr::Ascii("diagonalising"),
        &[(0b10010, &ENTRY_DIAGONALIZING_14520835686620115538)],
    ),
    (
        crate::EncodedStr::Ascii("diagonalizable"),
        &[(0b01001, &ENTRY_DIAGONALIZABLE_10977422841248602526)],
    ),
    (
        crate::EncodedStr::Ascii("diagonalization"),
        &[(0b01001, &ENTRY_DIAGONALIZATION_17906612353739944122)],
    ),
    (
        crate::EncodedStr::Ascii("diagonalize"),
        &[(0b01001, &ENTRY_DIAGONALIZE_17545470866818361268)],
    ),
    (
        crate::EncodedStr::Ascii("diagonalized"),
        &[(0b01001, &ENTRY_DIAGONALIZED_16278489065750351065)],
    ),
    (
        crate::EncodedStr::Ascii("diagonalizes"),
        &[(0b01001, &ENTRY_DIAGONALIZES_15436394800752209539)],
    ),
    (
        crate::EncodedStr::Ascii("diagonalizing"),
        &[(0b01001, &ENTRY_DIAGONALIZING_14520835686620115538)],
    ),
    (
        crate::EncodedStr::Ascii("dialecticise"),
        &[(0b10010, &ENTRY_DIALECTICIZE_2204671560565196577)],
    ),
    (
        crate::EncodedStr::Ascii("dialecticises"),
        &[(0b10010, &ENTRY_DIALECTICIZES_3201740277613515360)],
    ),
    (
        crate::EncodedStr::Ascii("dialecticize"),
        &[(0b01001, &ENTRY_DIALECTICIZE_2204671560565196577)],
    ),
    (
        crate::EncodedStr::Ascii("dialecticizes"),
        &[(0b01001, &ENTRY_DIALECTICIZES_3201740277613515360)],
    ),
    (
        crate::EncodedStr::Ascii("dialed"),
        &[(0b01001, &ENTRY_DIALED_12445554267564800284)],
    ),
    (
        crate::EncodedStr::Ascii("dialer"),
        &[(0b00001, &ENTRY_DIALER_4550505305630586540)],
    ),
    (
        crate::EncodedStr::Ascii("dialers"),
        &[(0b00001, &ENTRY_DIALERS_5602259152205050826)],
    ),
    (
        crate::EncodedStr::Ascii("dialing"),
        &[(0b01001, &ENTRY_DIALING_15825922980741414813)],
    ),
    (
        crate::EncodedStr::Ascii("dialings"),
        &[(0b01001, &ENTRY_DIALINGS_4797662219825576657)],
    ),
    (
        crate::EncodedStr::Ascii("dialist"),
        &[(0b00001, &ENTRY_DIALIST_8678208478430149150)],
    ),
    (
        crate::EncodedStr::Ascii("dialists"),
        &[(0b00001, &ENTRY_DIALISTS_17620866403243878741)],
    ),
    (
        crate::EncodedStr::Ascii("dialled"),
        &[(0b11010, &ENTRY_DIALED_12445554267564800284)],
    ),
    (
        crate::EncodedStr::Ascii("dialler"),
        &[(0b11010, &ENTRY_DIALER_4550505305630586540)],
    ),
    (
        crate::EncodedStr::Ascii("diallers"),
        &[(0b11010, &ENTRY_DIALERS_5602259152205050826)],
    ),
    (
        crate::EncodedStr::Ascii("dialling"),
        &[(0b11010, &ENTRY_DIALING_15825922980741414813)],
    ),
    (
        crate::EncodedStr::Ascii("diallings"),
        &[(0b11010, &ENTRY_DIALINGS_4797662219825576657)],
    ),
    (
        crate::EncodedStr::Ascii("diallist"),
        &[(0b11010, &ENTRY_DIALIST_8678208478430149150)],
    ),
    (
        crate::EncodedStr::Ascii("diallists"),
        &[(0b11010, &ENTRY_DIALISTS_17620866403243878741)],
    ),
    (
        crate::EncodedStr::Ascii("dialogged"),
        &[(0b00001, &ENTRY_DIALOGUED_1860543501002215986)],
    ),
    (
        crate::EncodedStr::Ascii("dialogging"),
        &[(0b00001, &ENTRY_DIALOGUING_14221452045191699395)],
    ),
    (
        crate::EncodedStr::Ascii("dialogise"),
        &[(0b10010, &ENTRY_DIALOGIZE_3147664435711992783)],
    ),
    (
        crate::EncodedStr::Ascii("dialogised"),
        &[(0b10010, &ENTRY_DIALOGIZED_16517368637953000442)],
    ),
    (
        crate::EncodedStr::Ascii("dialogises"),
        &[(0b10010, &ENTRY_DIALOGIZES_10946689184118338197)],
    ),
    (
        crate::EncodedStr::Ascii("dialogising"),
        &[(0b10010, &ENTRY_DIALOGIZING_10876002085618537096)],
    ),
    (
        crate::EncodedStr::Ascii("dialogize"),
        &[(0b01001, &ENTRY_DIALOGIZE_3147664435711992783)],
    ),
    (
        crate::EncodedStr::Ascii("dialogized"),
        &[(0b01001, &ENTRY_DIALOGIZED_16517368637953000442)],
    ),
    (
        crate::EncodedStr::Ascii("dialogizes"),
        &[(0b01001, &ENTRY_DIALOGIZES_10946689184118338197)],
    ),
    (
        crate::EncodedStr::Ascii("dialogizing"),
        &[(0b01001, &ENTRY_DIALOGIZING_10876002085618537096)],
    ),
    (
        crate::EncodedStr::Ascii("dialogs"),
        &[(0b00001, &ENTRY_DIALOGUES_11157018411024684853)],
    ),
    (
        crate::EncodedStr::Ascii("dialysabilities"),
        &[(0b11010, &ENTRY_DIALYZABILITIES_16919452053444132964)],
    ),
    (
        crate::EncodedStr::Ascii("dialysability"),
        &[(0b11010, &ENTRY_DIALYZABILITY_2385882814800744278)],
    ),
    (
        crate::EncodedStr::Ascii("dialysable"),
        &[(0b11010, &ENTRY_DIALYZABLE_4481317071046410548)],
    ),
    (
        crate::EncodedStr::Ascii("dialysabler"),
        &[(0b11010, &ENTRY_DIALYZABLER_2950437622828839578)],
    ),
    (
        crate::EncodedStr::Ascii("dialysables"),
        &[(0b11010, &ENTRY_DIALYZABLES_15000950498086971159)],
    ),
    (
        crate::EncodedStr::Ascii("dialysablest"),
        &[(0b11010, &ENTRY_DIALYZABLEST_10251547193383432771)],
    ),
    (
        crate::EncodedStr::Ascii("dialysate"),
        &[(0b10010, &ENTRY_DIALYZATE_847425955284979672)],
    ),
    (
        crate::EncodedStr::Ascii("dialysates"),
        &[(0b10010, &ENTRY_DIALYZATES_16159553587347789538)],
    ),
    (
        crate::EncodedStr::Ascii("dialysation"),
        &[(0b10010, &ENTRY_DIALYZATION_14569182709416219304)],
    ),
    (
        crate::EncodedStr::Ascii("dialyse"),
        &[(0b10010, &ENTRY_DIALYZE_6329229259949071274)],
    ),
    (
        crate::EncodedStr::Ascii("dialysed"),
        &[(0b10010, &ENTRY_DIALYZED_1600178824809360907)],
    ),
    (
        crate::EncodedStr::Ascii("dialyser"),
        &[(0b10010, &ENTRY_DIALYZER_7774506769012694605)],
    ),
    (
        crate::EncodedStr::Ascii("dialysers"),
        &[(0b10010, &ENTRY_DIALYZERS_11623550947622716911)],
    ),
    (
        crate::EncodedStr::Ascii("dialysing"),
        &[(0b10010, &ENTRY_DIALYZING_4945836046675013341)],
    ),
    (
        crate::EncodedStr::Ascii("dialyzabilities"),
        &[(0b00001, &ENTRY_DIALYZABILITIES_16919452053444132964)],
    ),
    (
        crate::EncodedStr::Ascii("dialyzability"),
        &[(0b00001, &ENTRY_DIALYZABILITY_2385882814800744278)],
    ),
    (
        crate::EncodedStr::Ascii("dialyzable"),
        &[(0b00001, &ENTRY_DIALYZABLE_4481317071046410548)],
    ),
    (
        crate::EncodedStr::Ascii("dialyzabler"),
        &[(0b00001, &ENTRY_DIALYZABLER_2950437622828839578)],
    ),
    (
        crate::EncodedStr::Ascii("dialyzables"),
        &[(0b00001, &ENTRY_DIALYZABLES_15000950498086971159)],
    ),
    (
        crate::EncodedStr::Ascii("dialyzablest"),
        &[(0b00001, &ENTRY_DIALYZABLEST_10251547193383432771)],
    ),
    (
        crate::EncodedStr::Ascii("dialyzate"),
        &[(0b01001, &ENTRY_DIALYZATE_847425955284979672)],
    ),
    (
        crate::EncodedStr::Ascii("dialyzates"),
        &[(0b01001, &ENTRY_DIALYZATES_16159553587347789538)],
    ),
    (
        crate::EncodedStr::Ascii("dialyzation"),
        &[(0b01001, &ENTRY_DIALYZATION_14569182709416219304)],
    ),
    (
        crate::EncodedStr::Ascii("dialyze"),
        &[(0b01001, &ENTRY_DIALYZE_6329229259949071274)],
    ),
    (
        crate::EncodedStr::Ascii("dialyzed"),
        &[(0b01001, &ENTRY_DIALYZED_1600178824809360907)],
    ),
    (
        crate::EncodedStr::Ascii("dialyzer"),
        &[(0b01001, &ENTRY_DIALYZER_7774506769012694605)],
    ),
    (
        crate::EncodedStr::Ascii("dialyzers"),
        &[(0b01001, &ENTRY_DIALYZERS_11623550947622716911)],
    ),
    (
        crate::EncodedStr::Ascii("dialyzes"),
        &[(0b01001, &ENTRY_DIALYZES_9413207522578141113)],
    ),
    (
        crate::EncodedStr::Ascii("dialyzing"),
        &[(0b01001, &ENTRY_DIALYZING_4945836046675013341)],
    ),
    (
        crate::EncodedStr::Ascii("diamondise"),
        &[(0b10010, &ENTRY_DIAMONDIZE_974653197096494091)],
    ),
    (
        crate::EncodedStr::Ascii("diamondises"),
        &[(0b10010, &ENTRY_DIAMONDIZES_11382117953228798781)],
    ),
    (
        crate::EncodedStr::Ascii("diamondize"),
        &[(0b01001, &ENTRY_DIAMONDIZE_974653197096494091)],
    ),
    (
        crate::EncodedStr::Ascii("diamondizes"),
        &[(0b01001, &ENTRY_DIAMONDIZES_11382117953228798781)],
    ),
    (
        crate::EncodedStr::Ascii("diarise"),
        &[(0b10010, &ENTRY_DIARIZE_7333441747497120999)],
    ),
    (
        crate::EncodedStr::Ascii("diarised"),
        &[(0b10010, &ENTRY_DIARIZED_15375708985365837815)],
    ),
    (
        crate::EncodedStr::Ascii("diarises"),
        &[(0b10010, &ENTRY_DIARIZES_6733157561570470769)],
    ),
    (
        crate::EncodedStr::Ascii("diarising"),
        &[(0b10010, &ENTRY_DIARIZING_6033557535432094232)],
    ),
    (
        crate::EncodedStr::Ascii("diarize"),
        &[(0b01001, &ENTRY_DIARIZE_7333441747497120999)],
    ),
    (
        crate::EncodedStr::Ascii("diarized"),
        &[(0b01001, &ENTRY_DIARIZED_15375708985365837815)],
    ),
    (
        crate::EncodedStr::Ascii("diarizes"),
        &[(0b01001, &ENTRY_DIARIZES_6733157561570470769)],
    ),
    (
        crate::EncodedStr::Ascii("diarizing"),
        &[(0b01001, &ENTRY_DIARIZING_6033557535432094232)],
    ),
    (
        crate::EncodedStr::Ascii("diarrhea"),
        &[(0b11001, &ENTRY_DIARRHEA_16651318537078726725)],
    ),
    (
        crate::EncodedStr::Ascii("diarrheal"),
        &[(0b11001, &ENTRY_DIARRHEAL_13590773083958773898)],
    ),
    (
        crate::EncodedStr::Ascii("diarrhealer"),
        &[(0b11001, &ENTRY_DIARRHEALER_11350171176863314647)],
    ),
    (
        crate::EncodedStr::Ascii("diarrhealest"),
        &[(0b11001, &ENTRY_DIARRHEALEST_16171976767316321320)],
    ),
    (
        crate::EncodedStr::Ascii("diarrheas"),
        &[(0b11001, &ENTRY_DIARRHEAS_11453476003683730830)],
    ),
    (
        crate::EncodedStr::Ascii("diarrheic"),
        &[(0b10001, &ENTRY_DIARRHEIC_5406216762270560046)],
    ),
    (
        crate::EncodedStr::Ascii("diarrheicer"),
        &[(0b10001, &ENTRY_DIARRHEICER_15169580495143503922)],
    ),
    (
        crate::EncodedStr::Ascii("diarrheicest"),
        &[(0b10001, &ENTRY_DIARRHEICEST_14221151968572902300)],
    ),
    (
        crate::EncodedStr::Ascii("diarrhetic"),
        &[(0b10001, &ENTRY_DIARRHETIC_6608432625592653807)],
    ),
    (
        crate::EncodedStr::Ascii("diarrheticer"),
        &[(0b10001, &ENTRY_DIARRHETICER_8758731973889395817)],
    ),
    (
        crate::EncodedStr::Ascii("diarrheticest"),
        &[(0b10001, &ENTRY_DIARRHETICEST_7576238721431437280)],
    ),
    (
        crate::EncodedStr::Ascii("diarrhoea"),
        &[(0b10010, &ENTRY_DIARRHEA_16651318537078726725)],
    ),
    (
        crate::EncodedStr::Ascii("diarrhoeal"),
        &[(0b10010, &ENTRY_DIARRHEAL_13590773083958773898)],
    ),
    (
        crate::EncodedStr::Ascii("diarrhoealer"),
        &[(0b10010, &ENTRY_DIARRHEALER_11350171176863314647)],
    ),
    (
        crate::EncodedStr::Ascii("diarrhoealest"),
        &[(0b10010, &ENTRY_DIARRHEALEST_16171976767316321320)],
    ),
    (
        crate::EncodedStr::Ascii("diarrhoeas"),
        &[(0b10010, &ENTRY_DIARRHEAS_11453476003683730830)],
    ),
    (
        crate::EncodedStr::Ascii("diarrhoeic"),
        &[(0b11010, &ENTRY_DIARRHEIC_5406216762270560046)],
    ),
    (
        crate::EncodedStr::Ascii("diarrhoeicer"),
        &[(0b11010, &ENTRY_DIARRHEICER_15169580495143503922)],
    ),
    (
        crate::EncodedStr::Ascii("diarrhoeicest"),
        &[(0b11010, &ENTRY_DIARRHEICEST_14221151968572902300)],
    ),
    (
        crate::EncodedStr::Ascii("diarrhoetic"),
        &[(0b11010, &ENTRY_DIARRHETIC_6608432625592653807)],
    ),
    (
        crate::EncodedStr::Ascii("diarrhoeticer"),
        &[(0b11010, &ENTRY_DIARRHETICER_8758731973889395817)],
    ),
    (
        crate::EncodedStr::Ascii("diarrhoeticest"),
        &[(0b11010, &ENTRY_DIARRHETICEST_7576238721431437280)],
    ),
    (
        crate::EncodedStr::Ascii("dichotomisation"),
        &[(0b10010, &ENTRY_DICHOTOMIZATION_14814468761822605666)],
    ),
    (
        crate::EncodedStr::Ascii("dichotomisations"),
        &[(0b10010, &ENTRY_DICHOTOMIZATIONS_11511794064634282366)],
    ),
    (
        crate::EncodedStr::Ascii("dichotomise"),
        &[(0b10010, &ENTRY_DICHOTOMIZE_2536151466993014840)],
    ),
    (
        crate::EncodedStr::Ascii("dichotomised"),
        &[(0b10010, &ENTRY_DICHOTOMIZED_11469969501387954088)],
    ),
    (
        crate::EncodedStr::Ascii("dichotomises"),
        &[(0b10010, &ENTRY_DICHOTOMIZES_9486969443354667350)],
    ),
    (
        crate::EncodedStr::Ascii("dichotomising"),
        &[(0b10010, &ENTRY_DICHOTOMIZING_6605468293502488075)],
    ),
    (
        crate::EncodedStr::Ascii("dichotomization"),
        &[(0b01001, &ENTRY_DICHOTOMIZATION_14814468761822605666)],
    ),
    (
        crate::EncodedStr::Ascii("dichotomizations"),
        &[(0b01001, &ENTRY_DICHOTOMIZATIONS_11511794064634282366)],
    ),
    (
        crate::EncodedStr::Ascii("dichotomize"),
        &[(0b01001, &ENTRY_DICHOTOMIZE_2536151466993014840)],
    ),
    (
        crate::EncodedStr::Ascii("dichotomized"),
        &[(0b01001, &ENTRY_DICHOTOMIZED_11469969501387954088)],
    ),
    (
        crate::EncodedStr::Ascii("dichotomizes"),
        &[(0b01001, &ENTRY_DICHOTOMIZES_9486969443354667350)],
    ),
    (
        crate::EncodedStr::Ascii("dichotomizing"),
        &[(0b01001, &ENTRY_DICHOTOMIZING_6605468293502488075)],
    ),
    (
        crate::EncodedStr::Ascii("diecious"),
        &[(0b00001, &ENTRY_DIOECIOUS_421155846144149881)],
    ),
    (
        crate::EncodedStr::Ascii("dieciously"),
        &[(0b00001, &ENTRY_DIOECIOUSLY_10693807285796274184)],
    ),
    (
        crate::EncodedStr::Ascii("diene"),
        &[(0b00001, &ENTRY_DIENE_8393408286309594192)],
    ),
    (
        crate::EncodedStr::Ascii("dieretic"),
        &[(0b00001, &ENTRY_DIERETIC_13830183413584247379)],
    ),
    (
        crate::EncodedStr::Ascii("dieselisation"),
        &[(0b10010, &ENTRY_DIESELIZATION_16989738541584421026)],
    ),
    (
        crate::EncodedStr::Ascii("dieselisations"),
        &[(0b10010, &ENTRY_DIESELIZATIONS_14749287237278344971)],
    ),
    (
        crate::EncodedStr::Ascii("dieselise"),
        &[(0b10010, &ENTRY_DIESELIZE_14819412399240860707)],
    ),
    (
        crate::EncodedStr::Ascii("dieselised"),
        &[(0b10010, &ENTRY_DIESELIZED_1396909342953338000)],
    ),
    (
        crate::EncodedStr::Ascii("dieselises"),
        &[(0b10010, &ENTRY_DIESELIZES_13977733140626156483)],
    ),
    (
        crate::EncodedStr::Ascii("dieselising"),
        &[(0b10010, &ENTRY_DIESELIZING_17476118384961942350)],
    ),
    (
        crate::EncodedStr::Ascii("dieselization"),
        &[(0b01001, &ENTRY_DIESELIZATION_16989738541584421026)],
    ),
    (
        crate::EncodedStr::Ascii("dieselizations"),
        &[(0b01001, &ENTRY_DIESELIZATIONS_14749287237278344971)],
    ),
    (
        crate::EncodedStr::Ascii("dieselize"),
        &[(0b01001, &ENTRY_DIESELIZE_14819412399240860707)],
    ),
    (
        crate::EncodedStr::Ascii("dieselized"),
        &[(0b01001, &ENTRY_DIESELIZED_1396909342953338000)],
    ),
    (
        crate::EncodedStr::Ascii("dieselizes"),
        &[(0b01001, &ENTRY_DIESELIZES_13977733140626156483)],
    ),
    (
        crate::EncodedStr::Ascii("dieselizing"),
        &[(0b01001, &ENTRY_DIESELIZING_17476118384961942350)],
    ),
    (
        crate::EncodedStr::Ascii("diestrous"),
        &[(0b10001, &ENTRY_DIESTROUS_2649092910168728128)],
    ),
    (
        crate::EncodedStr::Ascii("diestrual"),
        &[(0b10001, &ENTRY_DIESTRUAL_4297674653321861564)],
    ),
    (
        crate::EncodedStr::Ascii("diestrum"),
        &[(0b10001, &ENTRY_DIESTRUM_5374513461214013606)],
    ),
    (
        crate::EncodedStr::Ascii("diestrus"),
        &[(0b10001, &ENTRY_DIESTRUS_10065397832891326590)],
    ),
    (
        crate::EncodedStr::Ascii("diestruses"),
        &[(0b10001, &ENTRY_DIESTRUSES_551696630438157478)],
    ),
    (
        crate::EncodedStr::Ascii("diethylstilbestrol"),
        &[(0b00001, &ENTRY_DIETHYLSTILBESTROL_1887150150156134254)],
    ),
    (
        crate::EncodedStr::Ascii("diethylstilboestrol"),
        &[(0b11010, &ENTRY_DIETHYLSTILBESTROL_1887150150156134254)],
    ),
    (
        crate::EncodedStr::Ascii("differentialise"),
        &[(0b10010, &ENTRY_DIFFERENTIALIZE_16668562110152154633)],
    ),
    (
        crate::EncodedStr::Ascii("differentialises"),
        &[(0b10010, &ENTRY_DIFFERENTIALIZES_2900226538448132077)],
    ),
    (
        crate::EncodedStr::Ascii("differentialize"),
        &[(0b01001, &ENTRY_DIFFERENTIALIZE_16668562110152154633)],
    ),
    (
        crate::EncodedStr::Ascii("differentializes"),
        &[(0b01001, &ENTRY_DIFFERENTIALIZES_2900226538448132077)],
    ),
    (
        crate::EncodedStr::Ascii("digitalisation"),
        &[(0b10010, &ENTRY_DIGITALIZATION_5413639479952668184)],
    ),
    (
        crate::EncodedStr::Ascii("digitalisations"),
        &[(0b10010, &ENTRY_DIGITALIZATIONS_7057163228044401005)],
    ),
    (
        crate::EncodedStr::Ascii("digitalise"),
        &[(0b10010, &ENTRY_DIGITALIZE_7792956770391756553)],
    ),
    (
        crate::EncodedStr::Ascii("digitalised"),
        &[(0b10010, &ENTRY_DIGITALIZED_10368572290482312188)],
    ),
    (
        crate::EncodedStr::Ascii("digitalises"),
        &[(0b10010, &ENTRY_DIGITALIZES_14236944342236594070)],
    ),
    (
        crate::EncodedStr::Ascii("digitalising"),
        &[(0b10010, &ENTRY_DIGITALIZING_5922141572600056524)],
    ),
    (
        crate::EncodedStr::Ascii("digitalization"),
        &[(0b01001, &ENTRY_DIGITALIZATION_5413639479952668184)],
    ),
    (
        crate::EncodedStr::Ascii("digitalizations"),
        &[(0b01001, &ENTRY_DIGITALIZATIONS_7057163228044401005)],
    ),
    (
        crate::EncodedStr::Ascii("digitalize"),
        &[(0b01001, &ENTRY_DIGITALIZE_7792956770391756553)],
    ),
    (
        crate::EncodedStr::Ascii("digitalized"),
        &[(0b01001, &ENTRY_DIGITALIZED_10368572290482312188)],
    ),
    (
        crate::EncodedStr::Ascii("digitalizes"),
        &[(0b01001, &ENTRY_DIGITALIZES_14236944342236594070)],
    ),
    (
        crate::EncodedStr::Ascii("digitalizing"),
        &[(0b01001, &ENTRY_DIGITALIZING_5922141572600056524)],
    ),
    (
        crate::EncodedStr::Ascii("digitisation"),
        &[(0b10010, &ENTRY_DIGITIZATION_17548895183926914542)],
    ),
    (
        crate::EncodedStr::Ascii("digitisations"),
        &[(0b10010, &ENTRY_DIGITIZATIONS_16897900325023989676)],
    ),
    (
        crate::EncodedStr::Ascii("digitise"),
        &[(0b10010, &ENTRY_DIGITIZE_9662348846686188302)],
    ),
    (
        crate::EncodedStr::Ascii("digitised"),
        &[(0b10010, &ENTRY_DIGITIZED_18167407254586843848)],
    ),
    (
        crate::EncodedStr::Ascii("digitiser"),
        &[(0b10010, &ENTRY_DIGITIZER_10090672409246281037)],
    ),
    (
        crate::EncodedStr::Ascii("digitisers"),
        &[(0b10010, &ENTRY_DIGITIZERS_13411982289262402294)],
    ),
    (
        crate::EncodedStr::Ascii("digitises"),
        &[(0b10010, &ENTRY_DIGITIZES_2690419763079826049)],
    ),
    (
        crate::EncodedStr::Ascii("digitising"),
        &[(0b10010, &ENTRY_DIGITIZING_14141099429643492961)],
    ),
    (
        crate::EncodedStr::Ascii("digitization"),
        &[(0b01001, &ENTRY_DIGITIZATION_17548895183926914542)],
    ),
    (
        crate::EncodedStr::Ascii("digitizations"),
        &[(0b01001, &ENTRY_DIGITIZATIONS_16897900325023989676)],
    ),
    (
        crate::EncodedStr::Ascii("digitize"),
        &[(0b01001, &ENTRY_DIGITIZE_9662348846686188302)],
    ),
    (
        crate::EncodedStr::Ascii("digitized"),
        &[(0b01001, &ENTRY_DIGITIZED_18167407254586843848)],
    ),
    (
        crate::EncodedStr::Ascii("digitizer"),
        &[(0b01001, &ENTRY_DIGITIZER_10090672409246281037)],
    ),
    (
        crate::EncodedStr::Ascii("digitizers"),
        &[(0b01001, &ENTRY_DIGITIZERS_13411982289262402294)],
    ),
    (
        crate::EncodedStr::Ascii("digitizes"),
        &[(0b01001, &ENTRY_DIGITIZES_2690419763079826049)],
    ),
    (
        crate::EncodedStr::Ascii("digitizing"),
        &[(0b01001, &ENTRY_DIGITIZING_14141099429643492961)],
    ),
    (
        crate::EncodedStr::Ascii("dimensionalisation"),
        &[(0b10010, &ENTRY_DIMENSIONALIZATION_928272190267284990)],
    ),
    (
        crate::EncodedStr::Ascii("dimensionalise"),
        &[(0b10010, &ENTRY_DIMENSIONALIZE_17867138639749619838)],
    ),
    (
        crate::EncodedStr::Ascii("dimensionalised"),
        &[(0b10010, &ENTRY_DIMENSIONALIZED_7314101641422273330)],
    ),
    (
        crate::EncodedStr::Ascii("dimensionalises"),
        &[(0b10010, &ENTRY_DIMENSIONALIZES_8173757650577128994)],
    ),
    (
        crate::EncodedStr::Ascii("dimensionalising"),
        &[(0b10010, &ENTRY_DIMENSIONALIZING_5188710411327541644)],
    ),
    (
        crate::EncodedStr::Ascii("dimensionalization"),
        &[(0b01001, &ENTRY_DIMENSIONALIZATION_928272190267284990)],
    ),
    (
        crate::EncodedStr::Ascii("dimensionalize"),
        &[(0b01001, &ENTRY_DIMENSIONALIZE_17867138639749619838)],
    ),
    (
        crate::EncodedStr::Ascii("dimensionalized"),
        &[(0b01001, &ENTRY_DIMENSIONALIZED_7314101641422273330)],
    ),
    (
        crate::EncodedStr::Ascii("dimensionalizes"),
        &[(0b01001, &ENTRY_DIMENSIONALIZES_8173757650577128994)],
    ),
    (
        crate::EncodedStr::Ascii("dimensionalizing"),
        &[(0b01001, &ENTRY_DIMENSIONALIZING_5188710411327541644)],
    ),
    (
        crate::EncodedStr::Ascii("dimerisation"),
        &[(0b10010, &ENTRY_DIMERIZATION_15302035121240997222)],
    ),
    (
        crate::EncodedStr::Ascii("dimerisations"),
        &[(0b10010, &ENTRY_DIMERIZATIONS_14028175985445569270)],
    ),
    (
        crate::EncodedStr::Ascii("dimerise"),
        &[(0b10010, &ENTRY_DIMERIZE_16193073428737317522)],
    ),
    (
        crate::EncodedStr::Ascii("dimerised"),
        &[(0b10010, &ENTRY_DIMERIZED_15199320696227405238)],
    ),
    (
        crate::EncodedStr::Ascii("dimerises"),
        &[(0b10010, &ENTRY_DIMERIZES_1537628000711484411)],
    ),
    (
        crate::EncodedStr::Ascii("dimerising"),
        &[(0b10010, &ENTRY_DIMERIZING_14292842827296885678)],
    ),
    (
        crate::EncodedStr::Ascii("dimerization"),
        &[(0b01001, &ENTRY_DIMERIZATION_15302035121240997222)],
    ),
    (
        crate::EncodedStr::Ascii("dimerizations"),
        &[(0b01001, &ENTRY_DIMERIZATIONS_14028175985445569270)],
    ),
    (
        crate::EncodedStr::Ascii("dimerize"),
        &[(0b01001, &ENTRY_DIMERIZE_16193073428737317522)],
    ),
    (
        crate::EncodedStr::Ascii("dimerized"),
        &[(0b01001, &ENTRY_DIMERIZED_15199320696227405238)],
    ),
    (
        crate::EncodedStr::Ascii("dimerizes"),
        &[(0b01001, &ENTRY_DIMERIZES_1537628000711484411)],
    ),
    (
        crate::EncodedStr::Ascii("dimerizing"),
        &[(0b01001, &ENTRY_DIMERIZING_14292842827296885678)],
    ),
    (
        crate::EncodedStr::Ascii("diminutivise"),
        &[(0b10010, &ENTRY_DIMINUTIVIZE_8157805496969771537)],
    ),
    (
        crate::EncodedStr::Ascii("diminutivises"),
        &[(0b10010, &ENTRY_DIMINUTIVIZES_340938279453222908)],
    ),
    (
        crate::EncodedStr::Ascii("diminutivize"),
        &[(0b01001, &ENTRY_DIMINUTIVIZE_8157805496969771537)],
    ),
    (
        crate::EncodedStr::Ascii("diminutivizes"),
        &[(0b01001, &ENTRY_DIMINUTIVIZES_340938279453222908)],
    ),
    (
        crate::EncodedStr::Ascii("dioestrous"),
        &[(0b11010, &ENTRY_DIESTROUS_2649092910168728128)],
    ),
    (
        crate::EncodedStr::Ascii("dioestrual"),
        &[(0b11010, &ENTRY_DIESTRUAL_4297674653321861564)],
    ),
    (
        crate::EncodedStr::Ascii("dioestrum"),
        &[(0b11010, &ENTRY_DIESTRUM_5374513461214013606)],
    ),
    (
        crate::EncodedStr::Ascii("dioestrus"),
        &[(0b11010, &ENTRY_DIESTRUS_10065397832891326590)],
    ),
    (
        crate::EncodedStr::Ascii("dioestruses"),
        &[(0b11010, &ENTRY_DIESTRUSES_551696630438157478)],
    ),
    (
        crate::EncodedStr::Ascii("dionise"),
        &[(0b10010, &ENTRY_DIONIZE_5302013842773672496)],
    ),
    (
        crate::EncodedStr::Ascii("dionize"),
        &[(0b01001, &ENTRY_DIONIZE_5302013842773672496)],
    ),
    (
        crate::EncodedStr::Ascii("diopter"),
        &[(0b01001, &ENTRY_DIOPTER_10363011140557994074)],
    ),
    (
        crate::EncodedStr::Ascii("diopters"),
        &[(0b01001, &ENTRY_DIOPTERS_516947549353623981)],
    ),
    (
        crate::EncodedStr::Ascii("dioptre"),
        &[(0b11010, &ENTRY_DIOPTER_10363011140557994074)],
    ),
    (
        crate::EncodedStr::Ascii("dioptres"),
        &[(0b11010, &ENTRY_DIOPTERS_516947549353623981)],
    ),
    (
        crate::EncodedStr::Ascii("diphthongisation"),
        &[(0b10010, &ENTRY_DIPHTHONGIZATION_4888277953337569133)],
    ),
    (
        crate::EncodedStr::Ascii("diphthongisations"),
        &[(0b10010, &ENTRY_DIPHTHONGIZATIONS_3965346305488551771)],
    ),
    (
        crate::EncodedStr::Ascii("diphthongise"),
        &[(0b10010, &ENTRY_DIPHTHONGIZE_12838588614712725416)],
    ),
    (
        crate::EncodedStr::Ascii("diphthongised"),
        &[(0b10010, &ENTRY_DIPHTHONGIZED_7607687267591459487)],
    ),
    (
        crate::EncodedStr::Ascii("diphthongises"),
        &[(0b10010, &ENTRY_DIPHTHONGIZES_9976473308769011757)],
    ),
    (
        crate::EncodedStr::Ascii("diphthongising"),
        &[(0b10010, &ENTRY_DIPHTHONGIZING_9367101143579778156)],
    ),
    (
        crate::EncodedStr::Ascii("diphthongization"),
        &[(0b01001, &ENTRY_DIPHTHONGIZATION_4888277953337569133)],
    ),
    (
        crate::EncodedStr::Ascii("diphthongizations"),
        &[(0b01001, &ENTRY_DIPHTHONGIZATIONS_3965346305488551771)],
    ),
    (
        crate::EncodedStr::Ascii("diphthongize"),
        &[(0b01001, &ENTRY_DIPHTHONGIZE_12838588614712725416)],
    ),
    (
        crate::EncodedStr::Ascii("diphthongized"),
        &[(0b01001, &ENTRY_DIPHTHONGIZED_7607687267591459487)],
    ),
    (
        crate::EncodedStr::Ascii("diphthongizes"),
        &[(0b01001, &ENTRY_DIPHTHONGIZES_9976473308769011757)],
    ),
    (
        crate::EncodedStr::Ascii("diphthongizing"),
        &[(0b01001, &ENTRY_DIPHTHONGIZING_9367101143579778156)],
    ),
    (
        crate::EncodedStr::Ascii("diple"),
        &[(0b00001, &ENTRY_DIPLE_3376459421960689495)],
    ),
    (
        crate::EncodedStr::Ascii("diploae"),
        &[(0b11010, &ENTRY_DIPLOE_5571525081319448833)],
    ),
    (
        crate::EncodedStr::Ascii("diploe"),
        &[
            (0b11010, &ENTRY_DIPLE_3376459421960689495),
            (0b00001, &ENTRY_DIPLOE_5571525081319448833),
        ],
    ),
    (
        crate::EncodedStr::Ascii("diplomatise"),
        &[(0b10010, &ENTRY_DIPLOMATIZE_8810012624009252945)],
    ),
    (
        crate::EncodedStr::Ascii("diplomatised"),
        &[(0b10010, &ENTRY_DIPLOMATIZED_18386252538878346892)],
    ),
    (
        crate::EncodedStr::Ascii("diplomatises"),
        &[(0b10010, &ENTRY_DIPLOMATIZES_17976479831103709392)],
    ),
    (
        crate::EncodedStr::Ascii("diplomatising"),
        &[(0b10010, &ENTRY_DIPLOMATIZING_10466832182528029316)],
    ),
    (
        crate::EncodedStr::Ascii("diplomatize"),
        &[(0b01001, &ENTRY_DIPLOMATIZE_8810012624009252945)],
    ),
    (
        crate::EncodedStr::Ascii("diplomatized"),
        &[(0b01001, &ENTRY_DIPLOMATIZED_18386252538878346892)],
    ),
    (
        crate::EncodedStr::Ascii("diplomatizes"),
        &[(0b01001, &ENTRY_DIPLOMATIZES_17976479831103709392)],
    ),
    (
        crate::EncodedStr::Ascii("diplomatizing"),
        &[(0b01001, &ENTRY_DIPLOMATIZING_10466832182528029316)],
    ),
    (
        crate::EncodedStr::Ascii("disangularise"),
        &[(0b10010, &ENTRY_DISANGULARIZE_15234154485855761347)],
    ),
    (
        crate::EncodedStr::Ascii("disangularises"),
        &[(0b10010, &ENTRY_DISANGULARIZES_4645387961020197923)],
    ),
    (
        crate::EncodedStr::Ascii("disangularize"),
        &[(0b01001, &ENTRY_DISANGULARIZE_15234154485855761347)],
    ),
    (
        crate::EncodedStr::Ascii("disangularizes"),
        &[(0b01001, &ENTRY_DISANGULARIZES_4645387961020197923)],
    ),
    (
        crate::EncodedStr::Ascii("disauthorise"),
        &[(0b10010, &ENTRY_DISAUTHORIZE_9729193059512637993)],
    ),
    (
        crate::EncodedStr::Ascii("disauthorised"),
        &[(0b10010, &ENTRY_DISAUTHORIZED_15149050577902575232)],
    ),
    (
        crate::EncodedStr::Ascii("disauthorises"),
        &[(0b10010, &ENTRY_DISAUTHORIZES_16971580585403699509)],
    ),
    (
        crate::EncodedStr::Ascii("disauthorising"),
        &[(0b10010, &ENTRY_DISAUTHORIZING_1506123926769301204)],
    ),
    (
        crate::EncodedStr::Ascii("disauthorize"),
        &[(0b01001, &ENTRY_DISAUTHORIZE_9729193059512637993)],
    ),
    (
        crate::EncodedStr::Ascii("disauthorized"),
        &[(0b01001, &ENTRY_DISAUTHORIZED_15149050577902575232)],
    ),
    (
        crate::EncodedStr::Ascii("disauthorizes"),
        &[(0b01001, &ENTRY_DISAUTHORIZES_16971580585403699509)],
    ),
    (
        crate::EncodedStr::Ascii("disauthorizing"),
        &[(0b01001, &ENTRY_DISAUTHORIZING_1506123926769301204)],
    ),
    (
        crate::EncodedStr::Ascii("disboweled"),
        &[(0b00001, &ENTRY_DISBOWELED_8124420063056832999)],
    ),
    (
        crate::EncodedStr::Ascii("disboweling"),
        &[(0b00001, &ENTRY_DISBOWELING_14146470427022244483)],
    ),
    (
        crate::EncodedStr::Ascii("disbowelled"),
        &[(0b11010, &ENTRY_DISBOWELED_8124420063056832999)],
    ),
    (
        crate::EncodedStr::Ascii("disbowelling"),
        &[(0b11010, &ENTRY_DISBOWELING_14146470427022244483)],
    ),
    (
        crate::EncodedStr::Ascii("discanonisation"),
        &[(0b10010, &ENTRY_DISCANONIZATION_9504497596950273772)],
    ),
    (
        crate::EncodedStr::Ascii("discanonisations"),
        &[(0b10010, &ENTRY_DISCANONIZATIONS_714613792349570061)],
    ),
    (
        crate::EncodedStr::Ascii("discanonise"),
        &[(0b10010, &ENTRY_DISCANONIZE_10059279715015590378)],
    ),
    (
        crate::EncodedStr::Ascii("discanonises"),
        &[(0b10010, &ENTRY_DISCANONIZES_7404724245545428484)],
    ),
    (
        crate::EncodedStr::Ascii("discanonization"),
        &[(0b01001, &ENTRY_DISCANONIZATION_9504497596950273772)],
    ),
    (
        crate::EncodedStr::Ascii("discanonizations"),
        &[(0b01001, &ENTRY_DISCANONIZATIONS_714613792349570061)],
    ),
    (
        crate::EncodedStr::Ascii("discanonize"),
        &[(0b01001, &ENTRY_DISCANONIZE_10059279715015590378)],
    ),
    (
        crate::EncodedStr::Ascii("discanonizes"),
        &[(0b01001, &ENTRY_DISCANONIZES_7404724245545428484)],
    ),
    (
        crate::EncodedStr::Ascii("discolor"),
        &[(0b01001, &ENTRY_DISCOLOR_5229997782497228003)],
    ),
    (
        crate::EncodedStr::Ascii("discolorate"),
        &[(0b00001, &ENTRY_DISCOLORATE_17525488967185123450)],
    ),
    (
        crate::EncodedStr::Ascii("discolorated"),
        &[(0b00001, &ENTRY_DISCOLORATED_9751918465389903770)],
    ),
    (
        crate::EncodedStr::Ascii("discolored"),
        &[(0b01001, &ENTRY_DISCOLORED_11781061950619883476)],
    ),
    (
        crate::EncodedStr::Ascii("discoloredness"),
        &[(0b00001, &ENTRY_DISCOLOREDNESS_6651369091187102535)],
    ),
    (
        crate::EncodedStr::Ascii("discoloreds"),
        &[(0b01001, &ENTRY_DISCOLOREDS_2390131969640640898)],
    ),
    (
        crate::EncodedStr::Ascii("discoloring"),
        &[(0b01001, &ENTRY_DISCOLORING_2630857377151306278)],
    ),
    (
        crate::EncodedStr::Ascii("discolorization"),
        &[(0b00001, &ENTRY_DISCOLORIZATION_1561449986421291790)],
    ),
    (
        crate::EncodedStr::Ascii("discolorizations"),
        &[(0b00001, &ENTRY_DISCOLORIZATIONS_14292400843926128979)],
    ),
    (
        crate::EncodedStr::Ascii("discolorment"),
        &[(0b00001, &ENTRY_DISCOLORMENT_14928622858833795102)],
    ),
    (
        crate::EncodedStr::Ascii("discolorments"),
        &[(0b00001, &ENTRY_DISCOLORMENTS_11818433310186389225)],
    ),
    (
        crate::EncodedStr::Ascii("discolors"),
        &[(0b01001, &ENTRY_DISCOLORS_5612202091276496972)],
    ),
    (
        crate::EncodedStr::Ascii("discolour"),
        &[(0b11010, &ENTRY_DISCOLOR_5229997782497228003)],
    ),
    (
        crate::EncodedStr::Ascii("discolourate"),
        &[(0b11010, &ENTRY_DISCOLORATE_17525488967185123450)],
    ),
    (
        crate::EncodedStr::Ascii("discolourated"),
        &[(0b11010, &ENTRY_DISCOLORATED_9751918465389903770)],
    ),
    (
        crate::EncodedStr::Ascii("discolouration"),
        &[(0b11010, &ENTRY_DISCOLORATION_14169998051189645771)],
    ),
    (
        crate::EncodedStr::Ascii("discolourations"),
        &[(0b11010, &ENTRY_DISCOLORATIONS_161368754086315692)],
    ),
    (
        crate::EncodedStr::Ascii("discoloured"),
        &[(0b11010, &ENTRY_DISCOLORED_11781061950619883476)],
    ),
    (
        crate::EncodedStr::Ascii("discolouredness"),
        &[(0b11010, &ENTRY_DISCOLOREDNESS_6651369091187102535)],
    ),
    (
        crate::EncodedStr::Ascii("discoloureds"),
        &[(0b11010, &ENTRY_DISCOLOREDS_2390131969640640898)],
    ),
    (
        crate::EncodedStr::Ascii("discolouring"),
        &[(0b11010, &ENTRY_DISCOLORING_2630857377151306278)],
    ),
    (
        crate::EncodedStr::Ascii("discolourisation"),
        &[(0b10010, &ENTRY_DISCOLORIZATION_1561449986421291790)],
    ),
    (
        crate::EncodedStr::Ascii("discolourisations"),
        &[(0b10010, &ENTRY_DISCOLORIZATIONS_14292400843926128979)],
    ),
    (
        crate::EncodedStr::Ascii("discolourization"),
        &[(0b01000, &ENTRY_DISCOLORIZATION_1561449986421291790)],
    ),
    (
        crate::EncodedStr::Ascii("discolourizations"),
        &[(0b01000, &ENTRY_DISCOLORIZATIONS_14292400843926128979)],
    ),
    (
        crate::EncodedStr::Ascii("discolourment"),
        &[(0b11010, &ENTRY_DISCOLORMENT_14928622858833795102)],
    ),
    (
        crate::EncodedStr::Ascii("discolourments"),
        &[(0b11010, &ENTRY_DISCOLORMENTS_11818433310186389225)],
    ),
    (
        crate::EncodedStr::Ascii("discolours"),
        &[(0b11010, &ENTRY_DISCOLORS_5612202091276496972)],
    ),
    (
        crate::EncodedStr::Ascii("discretisation"),
        &[(0b10010, &ENTRY_DISCRETIZATION_12744800183024300851)],
    ),
    (
        crate::EncodedStr::Ascii("discretise"),
        &[(0b10010, &ENTRY_DISCRETIZE_5822871996560826075)],
    ),
    (
        crate::EncodedStr::Ascii("discretization"),
        &[(0b01001, &ENTRY_DISCRETIZATION_12744800183024300851)],
    ),
    (
        crate::EncodedStr::Ascii("discretize"),
        &[(0b01001, &ENTRY_DISCRETIZE_5822871996560826075)],
    ),
    (
        crate::EncodedStr::Ascii("disdenominationalise"),
        &[(0b10010, &ENTRY_DISDENOMINATIONALIZE_535012825291404497)],
    ),
    (
        crate::EncodedStr::Ascii("disdenominationalises"),
        &[(0b10010, &ENTRY_DISDENOMINATIONALIZES_12397562771885821092)],
    ),
    (
        crate::EncodedStr::Ascii("disdenominationalize"),
        &[(0b01001, &ENTRY_DISDENOMINATIONALIZE_535012825291404497)],
    ),
    (
        crate::EncodedStr::Ascii("disdenominationalizes"),
        &[(0b01001, &ENTRY_DISDENOMINATIONALIZES_12397562771885821092)],
    ),
    (
        crate::EncodedStr::Ascii("disdiplomatise"),
        &[(0b10010, &ENTRY_DISDIPLOMATIZE_885764438051293853)],
    ),
    (
        crate::EncodedStr::Ascii("disdiplomatises"),
        &[(0b10010, &ENTRY_DISDIPLOMATIZES_4891957747419116479)],
    ),
    (
        crate::EncodedStr::Ascii("disdiplomatize"),
        &[(0b01001, &ENTRY_DISDIPLOMATIZE_885764438051293853)],
    ),
    (
        crate::EncodedStr::Ascii("disdiplomatizes"),
        &[(0b01001, &ENTRY_DISDIPLOMATIZES_4891957747419116479)],
    ),
    (
        crate::EncodedStr::Ascii("disemboweled"),
        &[(0b00001, &ENTRY_DISEMBOWELED_10970335018373428342)],
    ),
    (
        crate::EncodedStr::Ascii("disemboweling"),
        &[(0b00001, &ENTRY_DISEMBOWELING_1397333253900455739)],
    ),
    (
        crate::EncodedStr::Ascii("disembowelled"),
        &[(0b11010, &ENTRY_DISEMBOWELED_10970335018373428342)],
    ),
    (
        crate::EncodedStr::Ascii("disembowelling"),
        &[(0b11010, &ENTRY_DISEMBOWELING_1397333253900455739)],
    ),
    (
        crate::EncodedStr::Ascii("disequalise"),
        &[(0b10010, &ENTRY_DISEQUALIZE_2351244429763172565)],
    ),
    (
        crate::EncodedStr::Ascii("disequaliser"),
        &[(0b10010, &ENTRY_DISEQUALIZER_15153684888095615538)],
    ),
    (
        crate::EncodedStr::Ascii("disequalisers"),
        &[(0b10010, &ENTRY_DISEQUALIZERS_17092206736491516096)],
    ),
    (
        crate::EncodedStr::Ascii("disequalises"),
        &[(0b10010, &ENTRY_DISEQUALIZES_7417403436798093715)],
    ),
    (
        crate::EncodedStr::Ascii("disequalize"),
        &[(0b01001, &ENTRY_DISEQUALIZE_2351244429763172565)],
    ),
    (
        crate::EncodedStr::Ascii("disequalizer"),
        &[(0b01001, &ENTRY_DISEQUALIZER_15153684888095615538)],
    ),
    (
        crate::EncodedStr::Ascii("disequalizers"),
        &[(0b01001, &ENTRY_DISEQUALIZERS_17092206736491516096)],
    ),
    (
        crate::EncodedStr::Ascii("disequalizes"),
        &[(0b01001, &ENTRY_DISEQUALIZES_7417403436798093715)],
    ),
    (
        crate::EncodedStr::Ascii("disfavor"),
        &[(0b11001, &ENTRY_DISFAVOR_10548525794143920697)],
    ),
    (
        crate::EncodedStr::Ascii("disfavored"),
        &[(0b11001, &ENTRY_DISFAVORED_4040006339995038210)],
    ),
    (
        crate::EncodedStr::Ascii("disfavorer"),
        &[(0b11001, &ENTRY_DISFAVORER_10571638081997401701)],
    ),
    (
        crate::EncodedStr::Ascii("disfavorers"),
        &[(0b11001, &ENTRY_DISFAVORERS_18430656322920499015)],
    ),
    (
        crate::EncodedStr::Ascii("disfavoring"),
        &[(0b11001, &ENTRY_DISFAVORING_16851499602444812970)],
    ),
    (
        crate::EncodedStr::Ascii("disfavors"),
        &[(0b11001, &ENTRY_DISFAVORS_15834201467329633407)],
    ),
    (
        crate::EncodedStr::Ascii("disfavour"),
        &[(0b11010, &ENTRY_DISFAVOR_10548525794143920697)],
    ),
    (
        crate::EncodedStr::Ascii("disfavoured"),
        &[(0b11010, &ENTRY_DISFAVORED_4040006339995038210)],
    ),
    (
        crate::EncodedStr::Ascii("disfavourer"),
        &[(0b11010, &ENTRY_DISFAVORER_10571638081997401701)],
    ),
    (
        crate::EncodedStr::Ascii("disfavourers"),
        &[(0b11010, &ENTRY_DISFAVORERS_18430656322920499015)],
    ),
    (
        crate::EncodedStr::Ascii("disfavouring"),
        &[(0b11010, &ENTRY_DISFAVORING_16851499602444812970)],
    ),
    (
        crate::EncodedStr::Ascii("disfavours"),
        &[(0b11010, &ENTRY_DISFAVORS_15834201467329633407)],
    ),
    (
        crate::EncodedStr::Ascii("disharmonise"),
        &[(0b10010, &ENTRY_DISHARMONIZE_14492960974540093828)],
    ),
    (
        crate::EncodedStr::Ascii("disharmonised"),
        &[(0b10010, &ENTRY_DISHARMONIZED_4901310729391279975)],
    ),
    (
        crate::EncodedStr::Ascii("disharmonises"),
        &[(0b10010, &ENTRY_DISHARMONIZES_6597311294304545400)],
    ),
    (
        crate::EncodedStr::Ascii("disharmonising"),
        &[(0b10010, &ENTRY_DISHARMONIZING_15220607346038133749)],
    ),
    (
        crate::EncodedStr::Ascii("disharmonize"),
        &[(0b01001, &ENTRY_DISHARMONIZE_14492960974540093828)],
    ),
    (
        crate::EncodedStr::Ascii("disharmonized"),
        &[(0b01001, &ENTRY_DISHARMONIZED_4901310729391279975)],
    ),
    (
        crate::EncodedStr::Ascii("disharmonizes"),
        &[(0b01001, &ENTRY_DISHARMONIZES_6597311294304545400)],
    ),
    (
        crate::EncodedStr::Ascii("disharmonizing"),
        &[(0b01001, &ENTRY_DISHARMONIZING_15220607346038133749)],
    ),
    (
        crate::EncodedStr::Ascii("disheveled"),
        &[(0b00001, &ENTRY_DISHEVELED_4439055663190726624)],
    ),
    (
        crate::EncodedStr::Ascii("disheveler"),
        &[(0b00001, &ENTRY_DISHEVELER_8621924881071797327)],
    ),
    (
        crate::EncodedStr::Ascii("disheveling"),
        &[(0b00001, &ENTRY_DISHEVELING_10590618683250803788)],
    ),
    (
        crate::EncodedStr::Ascii("dishevelled"),
        &[(0b11010, &ENTRY_DISHEVELED_4439055663190726624)],
    ),
    (
        crate::EncodedStr::Ascii("disheveller"),
        &[(0b11010, &ENTRY_DISHEVELER_8621924881071797327)],
    ),
    (
        crate::EncodedStr::Ascii("dishevelling"),
        &[(0b11010, &ENTRY_DISHEVELING_10590618683250803788)],
    ),
    (
        crate::EncodedStr::Ascii("dishonor"),
        &[(0b11001, &ENTRY_DISHONOR_16058760573294695856)],
    ),
    (
        crate::EncodedStr::Ascii("dishonorable"),
        &[(0b11001, &ENTRY_DISHONORABLE_6906558183452633549)],
    ),
    (
        crate::EncodedStr::Ascii("dishonorableness"),
        &[(0b11001, &ENTRY_DISHONORABLENESS_10647077411353658138)],
    ),
    (
        crate::EncodedStr::Ascii("dishonorablenesses"),
        &[(0b11001, &ENTRY_DISHONORABLENESSES_11979409559133838321)],
    ),
    (
        crate::EncodedStr::Ascii("dishonorabler"),
        &[(0b11001, &ENTRY_DISHONORABLER_3043788293690199279)],
    ),
    (
        crate::EncodedStr::Ascii("dishonorables"),
        &[(0b11001, &ENTRY_DISHONORABLES_9899266461697606508)],
    ),
    (
        crate::EncodedStr::Ascii("dishonorablest"),
        &[(0b11001, &ENTRY_DISHONORABLEST_3928567236277526991)],
    ),
    (
        crate::EncodedStr::Ascii("dishonorablier"),
        &[(0b11001, &ENTRY_DISHONORABLIER_8450606157745671431)],
    ),
    (
        crate::EncodedStr::Ascii("dishonorablies"),
        &[(0b11001, &ENTRY_DISHONORABLIES_14942803523606691356)],
    ),
    (
        crate::EncodedStr::Ascii("dishonorabliest"),
        &[(0b11001, &ENTRY_DISHONORABLIEST_12463634118581290321)],
    ),
    (
        crate::EncodedStr::Ascii("dishonorably"),
        &[(0b11001, &ENTRY_DISHONORABLY_16389408757341415026)],
    ),
    (
        crate::EncodedStr::Ascii("dishonorary"),
        &[(0b00001, &ENTRY_DISHONORARY_7185175374757498337)],
    ),
    (
        crate::EncodedStr::Ascii("dishonored"),
        &[(0b11001, &ENTRY_DISHONORED_1979408375344629609)],
    ),
    (
        crate::EncodedStr::Ascii("dishonorer"),
        &[(0b11001, &ENTRY_DISHONORER_11600072711097852356)],
    ),
    (
        crate::EncodedStr::Ascii("dishonorers"),
        &[(0b11001, &ENTRY_DISHONORERS_16218792927597703675)],
    ),
    (
        crate::EncodedStr::Ascii("dishonoring"),
        &[(0b11001, &ENTRY_DISHONORING_16122094070164850675)],
    ),
    (
        crate::EncodedStr::Ascii("dishonors"),
        &[(0b11001, &ENTRY_DISHONORS_5828073138827677548)],
    ),
    (
        crate::EncodedStr::Ascii("dishonour"),
        &[(0b11010, &ENTRY_DISHONOR_16058760573294695856)],
    ),
    (
        crate::EncodedStr::Ascii("dishonourable"),
        &[(0b11010, &ENTRY_DISHONORABLE_6906558183452633549)],
    ),
    (
        crate::EncodedStr::Ascii("dishonourableness"),
        &[(0b11010, &ENTRY_DISHONORABLENESS_10647077411353658138)],
    ),
    (
        crate::EncodedStr::Ascii("dishonourablenesses"),
        &[(0b11010, &ENTRY_DISHONORABLENESSES_11979409559133838321)],
    ),
    (
        crate::EncodedStr::Ascii("dishonourabler"),
        &[(0b11010, &ENTRY_DISHONORABLER_3043788293690199279)],
    ),
    (
        crate::EncodedStr::Ascii("dishonourables"),
        &[(0b11010, &ENTRY_DISHONORABLES_9899266461697606508)],
    ),
    (
        crate::EncodedStr::Ascii("dishonourablest"),
        &[(0b11010, &ENTRY_DISHONORABLEST_3928567236277526991)],
    ),
    (
        crate::EncodedStr::Ascii("dishonourablier"),
        &[(0b11010, &ENTRY_DISHONORABLIER_8450606157745671431)],
    ),
    (
        crate::EncodedStr::Ascii("dishonourablies"),
        &[(0b11010, &ENTRY_DISHONORABLIES_14942803523606691356)],
    ),
    (
        crate::EncodedStr::Ascii("dishonourabliest"),
        &[(0b11010, &ENTRY_DISHONORABLIEST_12463634118581290321)],
    ),
    (
        crate::EncodedStr::Ascii("dishonourably"),
        &[(0b11010, &ENTRY_DISHONORABLY_16389408757341415026)],
    ),
    (
        crate::EncodedStr::Ascii("dishonourary"),
        &[(0b11010, &ENTRY_DISHONORARY_7185175374757498337)],
    ),
    (
        crate::EncodedStr::Ascii("dishonoured"),
        &[(0b11010, &ENTRY_DISHONORED_1979408375344629609)],
    ),
    (
        crate::EncodedStr::Ascii("dishonourer"),
        &[(0b11010, &ENTRY_DISHONORER_11600072711097852356)],
    ),
    (
        crate::EncodedStr::Ascii("dishonourers"),
        &[(0b11010, &ENTRY_DISHONORERS_16218792927597703675)],
    ),
    (
        crate::EncodedStr::Ascii("dishonouring"),
        &[(0b11010, &ENTRY_DISHONORING_16122094070164850675)],
    ),
    (
        crate::EncodedStr::Ascii("dishonours"),
        &[(0b11010, &ENTRY_DISHONORS_5828073138827677548)],
    ),
    (
        crate::EncodedStr::Ascii("dishumanise"),
        &[(0b10010, &ENTRY_DISHUMANIZE_2097256647850275480)],
    ),
    (
        crate::EncodedStr::Ascii("dishumanises"),
        &[(0b10010, &ENTRY_DISHUMANIZES_11017789745964682172)],
    ),
    (
        crate::EncodedStr::Ascii("dishumanize"),
        &[(0b01001, &ENTRY_DISHUMANIZE_2097256647850275480)],
    ),
    (
        crate::EncodedStr::Ascii("dishumanizes"),
        &[(0b01001, &ENTRY_DISHUMANIZES_11017789745964682172)],
    ),
    (
        crate::EncodedStr::Ascii("dishumor"),
        &[(0b11001, &ENTRY_DISHUMOR_17351796049135318401)],
    ),
    (
        crate::EncodedStr::Ascii("dishumored"),
        &[(0b11001, &ENTRY_DISHUMORED_2383879622247462959)],
    ),
    (
        crate::EncodedStr::Ascii("dishumors"),
        &[(0b11001, &ENTRY_DISHUMORS_4122248585102919920)],
    ),
    (
        crate::EncodedStr::Ascii("dishumour"),
        &[(0b11010, &ENTRY_DISHUMOR_17351796049135318401)],
    ),
    (
        crate::EncodedStr::Ascii("dishumoured"),
        &[(0b11010, &ENTRY_DISHUMORED_2383879622247462959)],
    ),
    (
        crate::EncodedStr::Ascii("dishumours"),
        &[(0b11010, &ENTRY_DISHUMORS_4122248585102919920)],
    ),
    (
        crate::EncodedStr::Ascii("disillusionise"),
        &[(0b10010, &ENTRY_DISILLUSIONIZE_6725876315510879655)],
    ),
    (
        crate::EncodedStr::Ascii("disillusionised"),
        &[(0b10010, &ENTRY_DISILLUSIONIZED_9985249129164082054)],
    ),
    (
        crate::EncodedStr::Ascii("disillusioniser"),
        &[(0b10010, &ENTRY_DISILLUSIONIZER_7747439668540485853)],
    ),
    (
        crate::EncodedStr::Ascii("disillusionisers"),
        &[(0b10010, &ENTRY_DISILLUSIONIZERS_3528478054985367590)],
    ),
    (
        crate::EncodedStr::Ascii("disillusionises"),
        &[(0b10010, &ENTRY_DISILLUSIONIZES_12240679786185783886)],
    ),
    (
        crate::EncodedStr::Ascii("disillusionising"),
        &[(0b10010, &ENTRY_DISILLUSIONIZING_7223559157676347916)],
    ),
    (
        crate::EncodedStr::Ascii("disillusionize"),
        &[(0b01001, &ENTRY_DISILLUSIONIZE_6725876315510879655)],
    ),
    (
        crate::EncodedStr::Ascii("disillusionized"),
        &[(0b01001, &ENTRY_DISILLUSIONIZED_9985249129164082054)],
    ),
    (
        crate::EncodedStr::Ascii("disillusionizer"),
        &[(0b01001, &ENTRY_DISILLUSIONIZER_7747439668540485853)],
    ),
    (
        crate::EncodedStr::Ascii("disillusionizers"),
        &[(0b01001, &ENTRY_DISILLUSIONIZERS_3528478054985367590)],
    ),
    (
        crate::EncodedStr::Ascii("disillusionizes"),
        &[(0b01001, &ENTRY_DISILLUSIONIZES_12240679786185783886)],
    ),
    (
        crate::EncodedStr::Ascii("disillusionizing"),
        &[(0b01001, &ENTRY_DISILLUSIONIZING_7223559157676347916)],
    ),
    (
        crate::EncodedStr::Ascii("disindividualise"),
        &[(0b10010, &ENTRY_DISINDIVIDUALIZE_5618805340357401608)],
    ),
    (
        crate::EncodedStr::Ascii("disindividualised"),
        &[(0b10010, &ENTRY_DISINDIVIDUALIZED_2490609976879253784)],
    ),
    (
        crate::EncodedStr::Ascii("disindividualises"),
        &[(0b10010, &ENTRY_DISINDIVIDUALIZES_3078349844192054680)],
    ),
    (
        crate::EncodedStr::Ascii("disindividualising"),
        &[(0b10010, &ENTRY_DISINDIVIDUALIZING_6461619562502650122)],
    ),
    (
        crate::EncodedStr::Ascii("disindividualize"),
        &[(0b01001, &ENTRY_DISINDIVIDUALIZE_5618805340357401608)],
    ),
    (
        crate::EncodedStr::Ascii("disindividualized"),
        &[(0b01001, &ENTRY_DISINDIVIDUALIZED_2490609976879253784)],
    ),
    (
        crate::EncodedStr::Ascii("disindividualizes"),
        &[(0b01001, &ENTRY_DISINDIVIDUALIZES_3078349844192054680)],
    ),
    (
        crate::EncodedStr::Ascii("disindividualizing"),
        &[(0b01001, &ENTRY_DISINDIVIDUALIZING_6461619562502650122)],
    ),
    (
        crate::EncodedStr::Ascii("disindustrialisation"),
        &[(0b10010, &ENTRY_DISINDUSTRIALIZATION_11631925405929512766)],
    ),
    (
        crate::EncodedStr::Ascii("disindustrialisations"),
        &[(0b10010, &ENTRY_DISINDUSTRIALIZATIONS_12474625419721941228)],
    ),
    (
        crate::EncodedStr::Ascii("disindustrialise"),
        &[(0b10010, &ENTRY_DISINDUSTRIALIZE_11677234080103658662)],
    ),
    (
        crate::EncodedStr::Ascii("disindustrialised"),
        &[(0b10010, &ENTRY_DISINDUSTRIALIZED_9116894414125815191)],
    ),
    (
        crate::EncodedStr::Ascii("disindustrialises"),
        &[(0b10010, &ENTRY_DISINDUSTRIALIZES_11775441929762490304)],
    ),
    (
        crate::EncodedStr::Ascii("disindustrialising"),
        &[(0b10010, &ENTRY_DISINDUSTRIALIZING_11227038092400551095)],
    ),
    (
        crate::EncodedStr::Ascii("disindustrialization"),
        &[(0b01001, &ENTRY_DISINDUSTRIALIZATION_11631925405929512766)],
    ),
    (
        crate::EncodedStr::Ascii("disindustrializations"),
        &[(0b01001, &ENTRY_DISINDUSTRIALIZATIONS_12474625419721941228)],
    ),
    (
        crate::EncodedStr::Ascii("disindustrialize"),
        &[(0b01001, &ENTRY_DISINDUSTRIALIZE_11677234080103658662)],
    ),
    (
        crate::EncodedStr::Ascii("disindustrialized"),
        &[(0b01001, &ENTRY_DISINDUSTRIALIZED_9116894414125815191)],
    ),
    (
        crate::EncodedStr::Ascii("disindustrializes"),
        &[(0b01001, &ENTRY_DISINDUSTRIALIZES_11775441929762490304)],
    ),
    (
        crate::EncodedStr::Ascii("disindustrializing"),
        &[(0b01001, &ENTRY_DISINDUSTRIALIZING_11227038092400551095)],
    ),
    (
        crate::EncodedStr::Ascii("disluster"),
        &[(0b00001, &ENTRY_DISLUSTER_17318159058933817750)],
    ),
    (
        crate::EncodedStr::Ascii("dislustre"),
        &[(0b11010, &ENTRY_DISLUSTER_17318159058933817750)],
    ),
    (
        crate::EncodedStr::Ascii("dismalise"),
        &[(0b10010, &ENTRY_DISMALIZE_10250151666987366777)],
    ),
    (
        crate::EncodedStr::Ascii("dismalises"),
        &[(0b10010, &ENTRY_DISMALIZES_15353135750014042755)],
    ),
    (
        crate::EncodedStr::Ascii("dismalize"),
        &[(0b01001, &ENTRY_DISMALIZE_10250151666987366777)],
    ),
    (
        crate::EncodedStr::Ascii("dismalizes"),
        &[(0b01001, &ENTRY_DISMALIZES_15353135750014042755)],
    ),
    (
        crate::EncodedStr::Ascii("disnaturalisation"),
        &[(0b10010, &ENTRY_DISNATURALIZATION_11670344026850361488)],
    ),
    (
        crate::EncodedStr::Ascii("disnaturalisations"),
        &[(0b10010, &ENTRY_DISNATURALIZATIONS_10342585743158502872)],
    ),
    (
        crate::EncodedStr::Ascii("disnaturalise"),
        &[(0b10010, &ENTRY_DISNATURALIZE_12307126110445937749)],
    ),
    (
        crate::EncodedStr::Ascii("disnaturalised"),
        &[(0b10010, &ENTRY_DISNATURALIZED_5916107255821231797)],
    ),
    (
        crate::EncodedStr::Ascii("disnaturalises"),
        &[(0b10010, &ENTRY_DISNATURALIZES_559626355389259758)],
    ),
    (
        crate::EncodedStr::Ascii("disnaturalising"),
        &[(0b10010, &ENTRY_DISNATURALIZING_797893369591768933)],
    ),
    (
        crate::EncodedStr::Ascii("disnaturalization"),
        &[(0b01001, &ENTRY_DISNATURALIZATION_11670344026850361488)],
    ),
    (
        crate::EncodedStr::Ascii("disnaturalizations"),
        &[(0b01001, &ENTRY_DISNATURALIZATIONS_10342585743158502872)],
    ),
    (
        crate::EncodedStr::Ascii("disnaturalize"),
        &[(0b01001, &ENTRY_DISNATURALIZE_12307126110445937749)],
    ),
    (
        crate::EncodedStr::Ascii("disnaturalized"),
        &[(0b01001, &ENTRY_DISNATURALIZED_5916107255821231797)],
    ),
    (
        crate::EncodedStr::Ascii("disnaturalizes"),
        &[(0b01001, &ENTRY_DISNATURALIZES_559626355389259758)],
    ),
    (
        crate::EncodedStr::Ascii("disnaturalizing"),
        &[(0b01001, &ENTRY_DISNATURALIZING_797893369591768933)],
    ),
    (
        crate::EncodedStr::Ascii("disorganisation"),
        &[(0b10010, &ENTRY_DISORGANIZATION_16905278515917730708)],
    ),
    (
        crate::EncodedStr::Ascii("disorganisations"),
        &[(0b10010, &ENTRY_DISORGANIZATIONS_14738569434179616840)],
    ),
    (
        crate::EncodedStr::Ascii("disorganise"),
        &[(0b10010, &ENTRY_DISORGANIZE_11143780718836315842)],
    ),
    (
        crate::EncodedStr::Ascii("disorganised"),
        &[(0b10010, &ENTRY_DISORGANIZED_16082182829150319317)],
    ),
    (
        crate::EncodedStr::Ascii("disorganiser"),
        &[(0b10010, &ENTRY_DISORGANIZER_13968612653185254007)],
    ),
    (
        crate::EncodedStr::Ascii("disorganisers"),
        &[(0b10010, &ENTRY_DISORGANIZERS_3700614044173779869)],
    ),
    (
        crate::EncodedStr::Ascii("disorganises"),
        &[(0b10010, &ENTRY_DISORGANIZES_3148142030701826514)],
    ),
    (
        crate::EncodedStr::Ascii("disorganising"),
        &[(0b10010, &ENTRY_DISORGANIZING_3512715266110397978)],
    ),
    (
        crate::EncodedStr::Ascii("disorganization"),
        &[(0b01001, &ENTRY_DISORGANIZATION_16905278515917730708)],
    ),
    (
        crate::EncodedStr::Ascii("disorganizations"),
        &[(0b01001, &ENTRY_DISORGANIZATIONS_14738569434179616840)],
    ),
    (
        crate::EncodedStr::Ascii("disorganize"),
        &[(0b01001, &ENTRY_DISORGANIZE_11143780718836315842)],
    ),
    (
        crate::EncodedStr::Ascii("disorganized"),
        &[(0b01001, &ENTRY_DISORGANIZED_16082182829150319317)],
    ),
    (
        crate::EncodedStr::Ascii("disorganizer"),
        &[(0b01001, &ENTRY_DISORGANIZER_13968612653185254007)],
    ),
    (
        crate::EncodedStr::Ascii("disorganizers"),
        &[(0b01001, &ENTRY_DISORGANIZERS_3700614044173779869)],
    ),
    (
        crate::EncodedStr::Ascii("disorganizes"),
        &[(0b01001, &ENTRY_DISORGANIZES_3148142030701826514)],
    ),
    (
        crate::EncodedStr::Ascii("disorganizing"),
        &[(0b01001, &ENTRY_DISORGANIZING_3512715266110397978)],
    ),
    (
        crate::EncodedStr::Ascii("disozonise"),
        &[(0b10010, &ENTRY_DISOZONIZE_14151388182315461753)],
    ),
    (
        crate::EncodedStr::Ascii("disozonises"),
        &[(0b10010, &ENTRY_DISOZONIZES_12107113608008991830)],
    ),
    (
        crate::EncodedStr::Ascii("disozonize"),
        &[(0b01001, &ENTRY_DISOZONIZE_14151388182315461753)],
    ),
    (
        crate::EncodedStr::Ascii("disozonizes"),
        &[(0b01001, &ENTRY_DISOZONIZES_12107113608008991830)],
    ),
    (
        crate::EncodedStr::Ascii("dispapalise"),
        &[(0b10010, &ENTRY_DISPAPALIZE_13165058594407425203)],
    ),
    (
        crate::EncodedStr::Ascii("dispapalises"),
        &[(0b10010, &ENTRY_DISPAPALIZES_15889961525847775881)],
    ),
    (
        crate::EncodedStr::Ascii("dispapalize"),
        &[(0b01001, &ENTRY_DISPAPALIZE_13165058594407425203)],
    ),
    (
        crate::EncodedStr::Ascii("dispapalizes"),
        &[(0b01001, &ENTRY_DISPAPALIZES_15889961525847775881)],
    ),
    (
        crate::EncodedStr::Ascii("dispauperise"),
        &[(0b10010, &ENTRY_DISPAUPERIZE_4660569275468440176)],
    ),
    (
        crate::EncodedStr::Ascii("dispauperised"),
        &[(0b10010, &ENTRY_DISPAUPERIZED_12650677804830175257)],
    ),
    (
        crate::EncodedStr::Ascii("dispauperises"),
        &[(0b10010, &ENTRY_DISPAUPERIZES_12194191945308397437)],
    ),
    (
        crate::EncodedStr::Ascii("dispauperising"),
        &[(0b10010, &ENTRY_DISPAUPERIZING_17043875401453982735)],
    ),
    (
        crate::EncodedStr::Ascii("dispauperize"),
        &[(0b01001, &ENTRY_DISPAUPERIZE_4660569275468440176)],
    ),
    (
        crate::EncodedStr::Ascii("dispauperized"),
        &[(0b01001, &ENTRY_DISPAUPERIZED_12650677804830175257)],
    ),
    (
        crate::EncodedStr::Ascii("dispauperizes"),
        &[(0b01001, &ENTRY_DISPAUPERIZES_12194191945308397437)],
    ),
    (
        crate::EncodedStr::Ascii("dispauperizing"),
        &[(0b01001, &ENTRY_DISPAUPERIZING_17043875401453982735)],
    ),
    (
        crate::EncodedStr::Ascii("dispersonalise"),
        &[(0b10010, &ENTRY_DISPERSONALIZE_6396828987917605190)],
    ),
    (
        crate::EncodedStr::Ascii("dispersonalises"),
        &[(0b10010, &ENTRY_DISPERSONALIZES_16334720714201751331)],
    ),
    (
        crate::EncodedStr::Ascii("dispersonalize"),
        &[(0b01001, &ENTRY_DISPERSONALIZE_6396828987917605190)],
    ),
    (
        crate::EncodedStr::Ascii("dispersonalizes"),
        &[(0b01001, &ENTRY_DISPERSONALIZES_16334720714201751331)],
    ),
    (
        crate::EncodedStr::Ascii("dispopularise"),
        &[(0b10010, &ENTRY_DISPOPULARIZE_6744315358378905582)],
    ),
    (
        crate::EncodedStr::Ascii("dispopularises"),
        &[(0b10010, &ENTRY_DISPOPULARIZES_3346222683675559134)],
    ),
    (
        crate::EncodedStr::Ascii("dispopularize"),
        &[(0b01001, &ENTRY_DISPOPULARIZE_6744315358378905582)],
    ),
    (
        crate::EncodedStr::Ascii("dispopularizes"),
        &[(0b01001, &ENTRY_DISPOPULARIZES_3346222683675559134)],
    ),
    (
        crate::EncodedStr::Ascii("disrealise"),
        &[(0b10010, &ENTRY_DISREALIZE_6886884802512895754)],
    ),
    (
        crate::EncodedStr::Ascii("disrealises"),
        &[(0b10010, &ENTRY_DISREALIZES_7034995371229494339)],
    ),
    (
        crate::EncodedStr::Ascii("disrealize"),
        &[(0b01001, &ENTRY_DISREALIZE_6886884802512895754)],
    ),
    (
        crate::EncodedStr::Ascii("disrealizes"),
        &[(0b01001, &ENTRY_DISREALIZES_7034995371229494339)],
    ),
    (
        crate::EncodedStr::Ascii("disscepter"),
        &[(0b00001, &ENTRY_DISSCEPTER_9219896270222345750)],
    ),
    (
        crate::EncodedStr::Ascii("disscepters"),
        &[(0b00001, &ENTRY_DISSCEPTERS_8501541001325274567)],
    ),
    (
        crate::EncodedStr::Ascii("dissceptre"),
        &[(0b11010, &ENTRY_DISSCEPTER_9219896270222345750)],
    ),
    (
        crate::EncodedStr::Ascii("dissceptres"),
        &[(0b11010, &ENTRY_DISSCEPTERS_8501541001325274567)],
    ),
    (
        crate::EncodedStr::Ascii("disseise"),
        &[(0b10010, &ENTRY_DISSEIZE_2220027749090213580)],
    ),
    (
        crate::EncodedStr::Ascii("disseised"),
        &[(0b10010, &ENTRY_DISSEIZED_9143200265660844579)],
    ),
    (
        crate::EncodedStr::Ascii("disseisee"),
        &[(0b10010, &ENTRY_DISSEIZEE_10324450713845414018)],
    ),
    (
        crate::EncodedStr::Ascii("disseises"),
        &[(0b10010, &ENTRY_DISSEIZES_2475038653439253891)],
    ),
    (
        crate::EncodedStr::Ascii("disseisin"),
        &[(0b11010, &ENTRY_DISSEIZIN_14782548980677684377)],
    ),
    (
        crate::EncodedStr::Ascii("disseising"),
        &[(0b10010, &ENTRY_DISSEIZING_10817480248875018424)],
    ),
    (
        crate::EncodedStr::Ascii("disseisins"),
        &[(0b11010, &ENTRY_DISSEIZINS_9611939215700895786)],
    ),
    (
        crate::EncodedStr::Ascii("disseisor"),
        &[(0b11010, &ENTRY_DISSEIZOR_13887745959308891534)],
    ),
    (
        crate::EncodedStr::Ascii("disseisors"),
        &[(0b11010, &ENTRY_DISSEIZORS_6099442410087886972)],
    ),
    (
        crate::EncodedStr::Ascii("disseize"),
        &[(0b01001, &ENTRY_DISSEIZE_2220027749090213580)],
    ),
    (
        crate::EncodedStr::Ascii("disseized"),
        &[(0b01001, &ENTRY_DISSEIZED_9143200265660844579)],
    ),
    (
        crate::EncodedStr::Ascii("disseizee"),
        &[(0b01001, &ENTRY_DISSEIZEE_10324450713845414018)],
    ),
    (
        crate::EncodedStr::Ascii("disseizes"),
        &[(0b01001, &ENTRY_DISSEIZES_2475038653439253891)],
    ),
    (
        crate::EncodedStr::Ascii("disseizin"),
        &[(0b00001, &ENTRY_DISSEIZIN_14782548980677684377)],
    ),
    (
        crate::EncodedStr::Ascii("disseizing"),
        &[(0b01001, &ENTRY_DISSEIZING_10817480248875018424)],
    ),
    (
        crate::EncodedStr::Ascii("disseizins"),
        &[(0b00001, &ENTRY_DISSEIZINS_9611939215700895786)],
    ),
    (
        crate::EncodedStr::Ascii("disseizor"),
        &[(0b00001, &ENTRY_DISSEIZOR_13887745959308891534)],
    ),
    (
        crate::EncodedStr::Ascii("disseizors"),
        &[(0b00001, &ENTRY_DISSEIZORS_6099442410087886972)],
    ),
    (
        crate::EncodedStr::Ascii("dissensualise"),
        &[(0b10010, &ENTRY_DISSENSUALIZE_6621544703464419271)],
    ),
    (
        crate::EncodedStr::Ascii("dissensualises"),
        &[(0b10010, &ENTRY_DISSENSUALIZES_10730088086704898161)],
    ),
    (
        crate::EncodedStr::Ascii("dissensualize"),
        &[(0b01001, &ENTRY_DISSENSUALIZE_6621544703464419271)],
    ),
    (
        crate::EncodedStr::Ascii("dissensualizes"),
        &[(0b01001, &ENTRY_DISSENSUALIZES_10730088086704898161)],
    ),
    (
        crate::EncodedStr::Ascii("dissocialise"),
        &[(0b10010, &ENTRY_DISSOCIALIZE_15635530793606336711)],
    ),
    (
        crate::EncodedStr::Ascii("dissocialised"),
        &[(0b10010, &ENTRY_DISSOCIALIZED_948976280000356279)],
    ),
    (
        crate::EncodedStr::Ascii("dissocialises"),
        &[(0b10010, &ENTRY_DISSOCIALIZES_15997318284457012428)],
    ),
    (
        crate::EncodedStr::Ascii("dissocialising"),
        &[(0b10010, &ENTRY_DISSOCIALIZING_6928297824228630438)],
    ),
    (
        crate::EncodedStr::Ascii("dissocialize"),
        &[(0b01001, &ENTRY_DISSOCIALIZE_15635530793606336711)],
    ),
    (
        crate::EncodedStr::Ascii("dissocialized"),
        &[(0b01001, &ENTRY_DISSOCIALIZED_948976280000356279)],
    ),
    (
        crate::EncodedStr::Ascii("dissocializes"),
        &[(0b01001, &ENTRY_DISSOCIALIZES_15997318284457012428)],
    ),
    (
        crate::EncodedStr::Ascii("dissocializing"),
        &[(0b01001, &ENTRY_DISSOCIALIZING_6928297824228630438)],
    ),
    (
        crate::EncodedStr::Ascii("dissyllabise"),
        &[(0b10010, &ENTRY_DISSYLLABIZE_10272862471065893703)],
    ),
    (
        crate::EncodedStr::Ascii("dissyllabised"),
        &[(0b10010, &ENTRY_DISSYLLABIZED_17425272029213608821)],
    ),
    (
        crate::EncodedStr::Ascii("dissyllabising"),
        &[(0b10010, &ENTRY_DISSYLLABIZING_7453400268342543405)],
    ),
    (
        crate::EncodedStr::Ascii("dissyllabize"),
        &[(0b01001, &ENTRY_DISSYLLABIZE_10272862471065893703)],
    ),
    (
        crate::EncodedStr::Ascii("dissyllabized"),
        &[(0b01001, &ENTRY_DISSYLLABIZED_17425272029213608821)],
    ),
    (
        crate::EncodedStr::Ascii("dissyllabizing"),
        &[(0b01001, &ENTRY_DISSYLLABIZING_7453400268342543405)],
    ),
    (
        crate::EncodedStr::Ascii("dissympathise"),
        &[(0b10010, &ENTRY_DISSYMPATHIZE_4993319775705622084)],
    ),
    (
        crate::EncodedStr::Ascii("dissympathises"),
        &[(0b10010, &ENTRY_DISSYMPATHIZES_11030202988485089450)],
    ),
    (
        crate::EncodedStr::Ascii("dissympathize"),
        &[(0b01001, &ENTRY_DISSYMPATHIZE_4993319775705622084)],
    ),
    (
        crate::EncodedStr::Ascii("dissympathizes"),
        &[(0b01001, &ENTRY_DISSYMPATHIZES_11030202988485089450)],
    ),
    (
        crate::EncodedStr::Ascii("distill"),
        &[(0b01001, &ENTRY_DISTILL_15657274320458397213)],
    ),
    (
        crate::EncodedStr::Ascii("distills"),
        &[(0b01001, &ENTRY_DISTILLS_2389426309220426558)],
    ),
    (
        crate::EncodedStr::Ascii("disutilise"),
        &[(0b10010, &ENTRY_DISUTILIZE_10973235722650343703)],
    ),
    (
        crate::EncodedStr::Ascii("disutilises"),
        &[(0b10010, &ENTRY_DISUTILIZES_8581123670870213073)],
    ),
    (
        crate::EncodedStr::Ascii("disutilize"),
        &[(0b01001, &ENTRY_DISUTILIZE_10973235722650343703)],
    ),
    (
        crate::EncodedStr::Ascii("disutilizes"),
        &[(0b01001, &ENTRY_DISUTILIZES_8581123670870213073)],
    ),
    (
        crate::EncodedStr::Ascii("diversicolored"),
        &[(0b00001, &ENTRY_DIVERSICOLORED_651357966110994775)],
    ),
    (
        crate::EncodedStr::Ascii("diversicoloured"),
        &[(0b11010, &ENTRY_DIVERSICOLORED_651357966110994775)],
    ),
    (
        crate::EncodedStr::Ascii("divinisation"),
        &[(0b10010, &ENTRY_DIVINIZATION_8790430811943080539)],
    ),
    (
        crate::EncodedStr::Ascii("divinisations"),
        &[(0b10010, &ENTRY_DIVINIZATIONS_4602312198214871584)],
    ),
    (
        crate::EncodedStr::Ascii("divinise"),
        &[(0b10010, &ENTRY_DIVINIZE_15517841088563999430)],
    ),
    (
        crate::EncodedStr::Ascii("divinised"),
        &[(0b10010, &ENTRY_DIVINIZED_7849256710429601444)],
    ),
    (
        crate::EncodedStr::Ascii("divinises"),
        &[(0b10010, &ENTRY_DIVINIZES_2478647172593491088)],
    ),
    (
        crate::EncodedStr::Ascii("divinising"),
        &[(0b10010, &ENTRY_DIVINIZING_3663245257392927615)],
    ),
    (
        crate::EncodedStr::Ascii("divinister"),
        &[(0b00001, &ENTRY_DIVINISTER_6065276535238492048)],
    ),
    (
        crate::EncodedStr::Ascii("divinistre"),
        &[(0b11010, &ENTRY_DIVINISTER_6065276535238492048)],
    ),
    (
        crate::EncodedStr::Ascii("divinization"),
        &[(0b01001, &ENTRY_DIVINIZATION_8790430811943080539)],
    ),
    (
        crate::EncodedStr::Ascii("divinizations"),
        &[(0b01001, &ENTRY_DIVINIZATIONS_4602312198214871584)],
    ),
    (
        crate::EncodedStr::Ascii("divinize"),
        &[(0b01001, &ENTRY_DIVINIZE_15517841088563999430)],
    ),
    (
        crate::EncodedStr::Ascii("divinized"),
        &[(0b01001, &ENTRY_DIVINIZED_7849256710429601444)],
    ),
    (
        crate::EncodedStr::Ascii("divinizes"),
        &[(0b01001, &ENTRY_DIVINIZES_2478647172593491088)],
    ),
    (
        crate::EncodedStr::Ascii("divinizing"),
        &[(0b01001, &ENTRY_DIVINIZING_3663245257392927615)],
    ),
    (
        crate::EncodedStr::Ascii("divisionalisation"),
        &[(0b10010, &ENTRY_DIVISIONALIZATION_12097639934213939942)],
    ),
    (
        crate::EncodedStr::Ascii("divisionalisations"),
        &[(0b10010, &ENTRY_DIVISIONALIZATIONS_5100962745240087520)],
    ),
    (
        crate::EncodedStr::Ascii("divisionalization"),
        &[(0b01001, &ENTRY_DIVISIONALIZATION_12097639934213939942)],
    ),
    (
        crate::EncodedStr::Ascii("divisionalizations"),
        &[(0b01001, &ENTRY_DIVISIONALIZATIONS_5100962745240087520)],
    ),
    (
        crate::EncodedStr::Ascii("docetae"),
        &[(0b11010, &ENTRY_DOCETE_9982236132390447888)],
    ),
    (
        crate::EncodedStr::Ascii("docete"),
        &[(0b00001, &ENTRY_DOCETE_9982236132390447888)],
    ),
    (
        crate::EncodedStr::Ascii("dockisation"),
        &[(0b10010, &ENTRY_DOCKIZATION_1535416910054929275)],
    ),
    (
        crate::EncodedStr::Ascii("dockisations"),
        &[(0b10010, &ENTRY_DOCKIZATIONS_11682590158800904305)],
    ),
    (
        crate::EncodedStr::Ascii("dockise"),
        &[(0b10010, &ENTRY_DOCKIZE_7971946050616909881)],
    ),
    (
        crate::EncodedStr::Ascii("dockised"),
        &[(0b10010, &ENTRY_DOCKIZED_11497882154286445931)],
    ),
    (
        crate::EncodedStr::Ascii("dockises"),
        &[(0b10010, &ENTRY_DOCKIZES_18122194512183460168)],
    ),
    (
        crate::EncodedStr::Ascii("dockising"),
        &[(0b10010, &ENTRY_DOCKIZING_3734828908908895957)],
    ),
    (
        crate::EncodedStr::Ascii("dockization"),
        &[(0b01001, &ENTRY_DOCKIZATION_1535416910054929275)],
    ),
    (
        crate::EncodedStr::Ascii("dockizations"),
        &[(0b01001, &ENTRY_DOCKIZATIONS_11682590158800904305)],
    ),
    (
        crate::EncodedStr::Ascii("dockize"),
        &[(0b01001, &ENTRY_DOCKIZE_7971946050616909881)],
    ),
    (
        crate::EncodedStr::Ascii("dockized"),
        &[(0b01001, &ENTRY_DOCKIZED_11497882154286445931)],
    ),
    (
        crate::EncodedStr::Ascii("dockizes"),
        &[(0b01001, &ENTRY_DOCKIZES_18122194512183460168)],
    ),
    (
        crate::EncodedStr::Ascii("dockizing"),
        &[(0b01001, &ENTRY_DOCKIZING_3734828908908895957)],
    ),
    (
        crate::EncodedStr::Ascii("doctorisation"),
        &[(0b10010, &ENTRY_DOCTORIZATION_16033729298032621232)],
    ),
    (
        crate::EncodedStr::Ascii("doctorisations"),
        &[(0b10010, &ENTRY_DOCTORIZATIONS_16822908416090304265)],
    ),
    (
        crate::EncodedStr::Ascii("doctorise"),
        &[(0b10010, &ENTRY_DOCTORIZE_6755038590757730967)],
    ),
    (
        crate::EncodedStr::Ascii("doctorises"),
        &[(0b10010, &ENTRY_DOCTORIZES_5548640602945580448)],
    ),
    (
        crate::EncodedStr::Ascii("doctorization"),
        &[(0b01001, &ENTRY_DOCTORIZATION_16033729298032621232)],
    ),
    (
        crate::EncodedStr::Ascii("doctorizations"),
        &[(0b01001, &ENTRY_DOCTORIZATIONS_16822908416090304265)],
    ),
    (
        crate::EncodedStr::Ascii("doctorize"),
        &[(0b01001, &ENTRY_DOCTORIZE_6755038590757730967)],
    ),
    (
        crate::EncodedStr::Ascii("doctorizes"),
        &[(0b01001, &ENTRY_DOCTORIZES_5548640602945580448)],
    ),
    (
        crate::EncodedStr::Ascii("doctrinisation"),
        &[(0b10010, &ENTRY_DOCTRINIZATION_16019265374829905601)],
    ),
    (
        crate::EncodedStr::Ascii("doctrinisations"),
        &[(0b10010, &ENTRY_DOCTRINIZATIONS_15902219939645192582)],
    ),
    (
        crate::EncodedStr::Ascii("doctrinise"),
        &[(0b10010, &ENTRY_DOCTRINIZE_6295108165555928163)],
    ),
    (
        crate::EncodedStr::Ascii("doctrinises"),
        &[(0b10010, &ENTRY_DOCTRINIZES_5935013749533049591)],
    ),
    (
        crate::EncodedStr::Ascii("doctrinization"),
        &[(0b01001, &ENTRY_DOCTRINIZATION_16019265374829905601)],
    ),
    (
        crate::EncodedStr::Ascii("doctrinizations"),
        &[(0b01001, &ENTRY_DOCTRINIZATIONS_15902219939645192582)],
    ),
    (
        crate::EncodedStr::Ascii("doctrinize"),
        &[(0b01001, &ENTRY_DOCTRINIZE_6295108165555928163)],
    ),
    (
        crate::EncodedStr::Ascii("doctrinizes"),
        &[(0b01001, &ENTRY_DOCTRINIZES_5935013749533049591)],
    ),
    (
        crate::EncodedStr::Ascii("documentarisation"),
        &[(0b10010, &ENTRY_DOCUMENTARIZATION_17974536989356012536)],
    ),
    (
        crate::EncodedStr::Ascii("documentarisations"),
        &[(0b10010, &ENTRY_DOCUMENTARIZATIONS_10331155650038384543)],
    ),
    (
        crate::EncodedStr::Ascii("documentarise"),
        &[(0b10010, &ENTRY_DOCUMENTARIZE_4613182909392922028)],
    ),
    (
        crate::EncodedStr::Ascii("documentarised"),
        &[(0b10010, &ENTRY_DOCUMENTARIZED_17052922427938453018)],
    ),
    (
        crate::EncodedStr::Ascii("documentarises"),
        &[(0b10010, &ENTRY_DOCUMENTARIZES_12258340263601716780)],
    ),
    (
        crate::EncodedStr::Ascii("documentarising"),
        &[(0b10010, &ENTRY_DOCUMENTARIZING_617029537042756884)],
    ),
    (
        crate::EncodedStr::Ascii("documentarization"),
        &[(0b01001, &ENTRY_DOCUMENTARIZATION_17974536989356012536)],
    ),
    (
        crate::EncodedStr::Ascii("documentarizations"),
        &[(0b01001, &ENTRY_DOCUMENTARIZATIONS_10331155650038384543)],
    ),
    (
        crate::EncodedStr::Ascii("documentarize"),
        &[(0b01001, &ENTRY_DOCUMENTARIZE_4613182909392922028)],
    ),
    (
        crate::EncodedStr::Ascii("documentarized"),
        &[(0b01001, &ENTRY_DOCUMENTARIZED_17052922427938453018)],
    ),
    (
        crate::EncodedStr::Ascii("documentarizes"),
        &[(0b01001, &ENTRY_DOCUMENTARIZES_12258340263601716780)],
    ),
    (
        crate::EncodedStr::Ascii("documentarizing"),
        &[(0b01001, &ENTRY_DOCUMENTARIZING_617029537042756884)],
    ),
    (
        crate::EncodedStr::Ascii("documentise"),
        &[(0b10010, &ENTRY_DOCUMENTIZE_8987269843659123718)],
    ),
    (
        crate::EncodedStr::Ascii("documentises"),
        &[(0b10010, &ENTRY_DOCUMENTIZES_16197448875654270526)],
    ),
    (
        crate::EncodedStr::Ascii("documentize"),
        &[(0b01001, &ENTRY_DOCUMENTIZE_8987269843659123718)],
    ),
    (
        crate::EncodedStr::Ascii("documentizes"),
        &[(0b01001, &ENTRY_DOCUMENTIZES_16197448875654270526)],
    ),
    (
        crate::EncodedStr::Ascii("dodonaean"),
        &[(0b11010, &ENTRY_DODONEAN_4865245390182893775)],
    ),
    (
        crate::EncodedStr::Ascii("dodonean"),
        &[(0b00001, &ENTRY_DODONEAN_4865245390182893775)],
    ),
    (
        crate::EncodedStr::Ascii("dogmatisation"),
        &[(0b10010, &ENTRY_DOGMATIZATION_9807437487276138631)],
    ),
    (
        crate::EncodedStr::Ascii("dogmatisations"),
        &[(0b10010, &ENTRY_DOGMATIZATIONS_16998792177218196465)],
    ),
    (
        crate::EncodedStr::Ascii("dogmatise"),
        &[(0b10010, &ENTRY_DOGMATIZE_17787716068922105181)],
    ),
    (
        crate::EncodedStr::Ascii("dogmatised"),
        &[(0b10010, &ENTRY_DOGMATIZED_16841797752844209570)],
    ),
    (
        crate::EncodedStr::Ascii("dogmatiser"),
        &[(0b10010, &ENTRY_DOGMATIZER_12352899563923207585)],
    ),
    (
        crate::EncodedStr::Ascii("dogmatisers"),
        &[(0b10010, &ENTRY_DOGMATIZERS_4399276900624905781)],
    ),
    (
        crate::EncodedStr::Ascii("dogmatises"),
        &[(0b10010, &ENTRY_DOGMATIZES_5834123085035176852)],
    ),
    (
        crate::EncodedStr::Ascii("dogmatising"),
        &[(0b10010, &ENTRY_DOGMATIZING_2447061813414873668)],
    ),
    (
        crate::EncodedStr::Ascii("dogmatization"),
        &[(0b01001, &ENTRY_DOGMATIZATION_9807437487276138631)],
    ),
    (
        crate::EncodedStr::Ascii("dogmatizations"),
        &[(0b01001, &ENTRY_DOGMATIZATIONS_16998792177218196465)],
    ),
    (
        crate::EncodedStr::Ascii("dogmatize"),
        &[(0b01001, &ENTRY_DOGMATIZE_17787716068922105181)],
    ),
    (
        crate::EncodedStr::Ascii("dogmatized"),
        &[(0b01001, &ENTRY_DOGMATIZED_16841797752844209570)],
    ),
    (
        crate::EncodedStr::Ascii("dogmatizer"),
        &[(0b01001, &ENTRY_DOGMATIZER_12352899563923207585)],
    ),
    (
        crate::EncodedStr::Ascii("dogmatizers"),
        &[(0b01001, &ENTRY_DOGMATIZERS_4399276900624905781)],
    ),
    (
        crate::EncodedStr::Ascii("dogmatizes"),
        &[(0b01001, &ENTRY_DOGMATIZES_5834123085035176852)],
    ),
    (
        crate::EncodedStr::Ascii("dogmatizing"),
        &[(0b01001, &ENTRY_DOGMATIZING_2447061813414873668)],
    ),
    (
        crate::EncodedStr::Ascii("dognaped"),
        &[(0b00001, &ENTRY_DOGNAPED_11073408213279300229)],
    ),
    (
        crate::EncodedStr::Ascii("dognaping"),
        &[(0b00001, &ENTRY_DOGNAPING_18285041110852582538)],
    ),
    (
        crate::EncodedStr::Ascii("dognapped"),
        &[(0b11010, &ENTRY_DOGNAPED_11073408213279300229)],
    ),
    (
        crate::EncodedStr::Ascii("dognapping"),
        &[(0b11010, &ENTRY_DOGNAPING_18285041110852582538)],
    ),
    (
        crate::EncodedStr::Ascii("dollarisation"),
        &[(0b10010, &ENTRY_DOLLARIZATION_17756157301501272744)],
    ),
    (
        crate::EncodedStr::Ascii("dollarisations"),
        &[(0b10010, &ENTRY_DOLLARIZATIONS_17625833038744269977)],
    ),
    (
        crate::EncodedStr::Ascii("dollarization"),
        &[(0b01001, &ENTRY_DOLLARIZATION_17756157301501272744)],
    ),
    (
        crate::EncodedStr::Ascii("dollarizations"),
        &[(0b01001, &ENTRY_DOLLARIZATIONS_17625833038744269977)],
    ),
    (
        crate::EncodedStr::Ascii("dolomitisation"),
        &[(0b10010, &ENTRY_DOLOMITIZATION_14933423504719929542)],
    ),
    (
        crate::EncodedStr::Ascii("dolomitisations"),
        &[(0b10010, &ENTRY_DOLOMITIZATIONS_14772713962775924448)],
    ),
    (
        crate::EncodedStr::Ascii("dolomitise"),
        &[(0b10010, &ENTRY_DOLOMITIZE_11040063579570529637)],
    ),
    (
        crate::EncodedStr::Ascii("dolomitised"),
        &[(0b10010, &ENTRY_DOLOMITIZED_11692953153623694619)],
    ),
    (
        crate::EncodedStr::Ascii("dolomitises"),
        &[(0b10010, &ENTRY_DOLOMITIZES_14363893600761024796)],
    ),
    (
        crate::EncodedStr::Ascii("dolomitising"),
        &[(0b10010, &ENTRY_DOLOMITIZING_438564637284719498)],
    ),
    (
        crate::EncodedStr::Ascii("dolomitization"),
        &[(0b01001, &ENTRY_DOLOMITIZATION_14933423504719929542)],
    ),
    (
        crate::EncodedStr::Ascii("dolomitizations"),
        &[(0b01001, &ENTRY_DOLOMITIZATIONS_14772713962775924448)],
    ),
    (
        crate::EncodedStr::Ascii("dolomitize"),
        &[(0b01001, &ENTRY_DOLOMITIZE_11040063579570529637)],
    ),
    (
        crate::EncodedStr::Ascii("dolomitized"),
        &[(0b01001, &ENTRY_DOLOMITIZED_11692953153623694619)],
    ),
    (
        crate::EncodedStr::Ascii("dolomitizes"),
        &[(0b01001, &ENTRY_DOLOMITIZES_14363893600761024796)],
    ),
    (
        crate::EncodedStr::Ascii("dolomitizing"),
        &[(0b01001, &ENTRY_DOLOMITIZING_438564637284719498)],
    ),
    (
        crate::EncodedStr::Ascii("dolor"),
        &[(0b11001, &ENTRY_DOLOR_13331739895797537426)],
    ),
    (
        crate::EncodedStr::Ascii("dolors"),
        &[(0b11001, &ENTRY_DOLORS_14103590959031573361)],
    ),
    (
        crate::EncodedStr::Ascii("dolour"),
        &[(0b11010, &ENTRY_DOLOR_13331739895797537426)],
    ),
    (
        crate::EncodedStr::Ascii("dolours"),
        &[(0b11010, &ENTRY_DOLORS_14103590959031573361)],
    ),
    (
        crate::EncodedStr::Ascii("domesticise"),
        &[(0b10010, &ENTRY_DOMESTICIZE_13328191379606735400)],
    ),
    (
        crate::EncodedStr::Ascii("domesticised"),
        &[(0b10010, &ENTRY_DOMESTICIZED_942799913724257410)],
    ),
    (
        crate::EncodedStr::Ascii("domesticises"),
        &[(0b10010, &ENTRY_DOMESTICIZES_10740490321221958206)],
    ),
    (
        crate::EncodedStr::Ascii("domesticising"),
        &[(0b10010, &ENTRY_DOMESTICIZING_14826454957919135861)],
    ),
    (
        crate::EncodedStr::Ascii("domesticize"),
        &[(0b01001, &ENTRY_DOMESTICIZE_13328191379606735400)],
    ),
    (
        crate::EncodedStr::Ascii("domesticized"),
        &[(0b01001, &ENTRY_DOMESTICIZED_942799913724257410)],
    ),
    (
        crate::EncodedStr::Ascii("domesticizes"),
        &[(0b01001, &ENTRY_DOMESTICIZES_10740490321221958206)],
    ),
    (
        crate::EncodedStr::Ascii("domesticizing"),
        &[(0b01001, &ENTRY_DOMESTICIZING_14826454957919135861)],
    ),
    (
        crate::EncodedStr::Ascii("dominae"),
        &[(0b11010, &ENTRY_DOMINE_6107407794990069253)],
    ),
    (
        crate::EncodedStr::Ascii("domine"),
        &[(0b00001, &ENTRY_DOMINE_6107407794990069253)],
    ),
    (
        crate::EncodedStr::Ascii("donut"),
        &[(0b00001, &ENTRY_DOUGHNUT_10730795230131641057)],
    ),
    (
        crate::EncodedStr::Ascii("donuts"),
        &[(0b00001, &ENTRY_DOUGHNUTS_2863778322372164342)],
    ),
    (
        crate::EncodedStr::Ascii("dora"),
        &[(0b00001, &ENTRY_DORA_16140085300068073244)],
    ),
    (
        crate::EncodedStr::Ascii("doricise"),
        &[(0b10010, &ENTRY_DORICIZE_6423501943985007435)],
    ),
    (
        crate::EncodedStr::Ascii("doricises"),
        &[(0b10010, &ENTRY_DORICIZES_6267531821171799546)],
    ),
    (
        crate::EncodedStr::Ascii("doricize"),
        &[(0b01001, &ENTRY_DORICIZE_6423501943985007435)],
    ),
    (
        crate::EncodedStr::Ascii("doricizes"),
        &[(0b01001, &ENTRY_DORICIZES_6267531821171799546)],
    ),
    (
        crate::EncodedStr::Ascii("dorise"),
        &[(0b10010, &ENTRY_DORIZE_5375683295399571559)],
    ),
    (
        crate::EncodedStr::Ascii("dorised"),
        &[(0b10010, &ENTRY_DORIZED_15641017864552407948)],
    ),
    (
        crate::EncodedStr::Ascii("dorises"),
        &[(0b10010, &ENTRY_DORIZES_2466661328762540129)],
    ),
    (
        crate::EncodedStr::Ascii("dorising"),
        &[(0b10010, &ENTRY_DORIZING_8550740907826559833)],
    ),
    (
        crate::EncodedStr::Ascii("dorize"),
        &[(0b01001, &ENTRY_DORIZE_5375683295399571559)],
    ),
    (
        crate::EncodedStr::Ascii("dorized"),
        &[(0b01001, &ENTRY_DORIZED_15641017864552407948)],
    ),
    (
        crate::EncodedStr::Ascii("dorizes"),
        &[(0b01001, &ENTRY_DORIZES_2466661328762540129)],
    ),
    (
        crate::EncodedStr::Ascii("dorizing"),
        &[(0b01001, &ENTRY_DORIZING_8550740907826559833)],
    ),
    (
        crate::EncodedStr::Ascii("dorylinae"),
        &[(0b11010, &ENTRY_DORYLINE_13007837504764606022)],
    ),
    (
        crate::EncodedStr::Ascii("doryline"),
        &[(0b00001, &ENTRY_DORYLINE_13007837504764606022)],
    ),
    (
        crate::EncodedStr::Ascii("doura"),
        &[(0b11010, &ENTRY_DORA_16140085300068073244)],
    ),
    (
        crate::EncodedStr::Ascii("doweled"),
        &[(0b00001, &ENTRY_DOWELED_3347505904680781852)],
    ),
    (
        crate::EncodedStr::Ascii("doweler"),
        &[(0b00001, &ENTRY_DOWELER_14640077182615108914)],
    ),
    (
        crate::EncodedStr::Ascii("doweling"),
        &[(0b00001, &ENTRY_DOWELING_18059799987098176192)],
    ),
    (
        crate::EncodedStr::Ascii("dowelled"),
        &[(0b11010, &ENTRY_DOWELED_3347505904680781852)],
    ),
    (
        crate::EncodedStr::Ascii("doweller"),
        &[(0b11010, &ENTRY_DOWELER_14640077182615108914)],
    ),
    (
        crate::EncodedStr::Ascii("dowelling"),
        &[(0b11010, &ENTRY_DOWELING_18059799987098176192)],
    ),
    (
        crate::EncodedStr::Ascii("downdraft"),
        &[(0b01001, &ENTRY_DOWNDRAFT_9039488072887961853)],
    ),
    (
        crate::EncodedStr::Ascii("downdraught"),
        &[(0b10010, &ENTRY_DOWNDRAFT_9039488072887961853)],
    ),
    (
        crate::EncodedStr::Ascii("dracaena"),
        &[(0b11010, &ENTRY_DRACENA_6118539877770808902)],
    ),
    (
        crate::EncodedStr::Ascii("dracaenaceae"),
        &[(0b11010, &ENTRY_DRACENACEAE_16212683568672807360)],
    ),
    (
        crate::EncodedStr::Ascii("dracaenas"),
        &[(0b11010, &ENTRY_DRACENAS_12510578936942457083)],
    ),
    (
        crate::EncodedStr::Ascii("dracena"),
        &[(0b00001, &ENTRY_DRACENA_6118539877770808902)],
    ),
    (
        crate::EncodedStr::Ascii("dracenaceae"),
        &[(0b00001, &ENTRY_DRACENACEAE_16212683568672807360)],
    ),
    (
        crate::EncodedStr::Ascii("dracenas"),
        &[(0b00001, &ENTRY_DRACENAS_12510578936942457083)],
    ),
    (
        crate::EncodedStr::Ascii("draftboard"),
        &[(0b01001, &ENTRY_DRAUGHTBOARD_17601710064627669528)],
    ),
    (
        crate::EncodedStr::Ascii("draftboards"),
        &[(0b01001, &ENTRY_DRAUGHTBOARDS_10338171604839828821)],
    ),
    (
        crate::EncodedStr::Ascii("draftier"),
        &[(0b01001, &ENTRY_DRAFTIER_9222724357623798327)],
    ),
    (
        crate::EncodedStr::Ascii("draftiest"),
        &[(0b01001, &ENTRY_DRAFTIEST_5259543064524205513)],
    ),
    (
        crate::EncodedStr::Ascii("draftilier"),
        &[(0b01001, &ENTRY_DRAFTILIER_6263136181960657686)],
    ),
    (
        crate::EncodedStr::Ascii("draftiliest"),
        &[(0b01001, &ENTRY_DRAFTILIEST_12111711614227754883)],
    ),
    (
        crate::EncodedStr::Ascii("draftily"),
        &[(0b01001, &ENTRY_DRAFTILY_3404853207703525148)],
    ),
    (
        crate::EncodedStr::Ascii("draftiness"),
        &[(0b01001, &ENTRY_DRAFTINESS_5050558803290260054)],
    ),
    (
        crate::EncodedStr::Ascii("draftinesses"),
        &[(0b01001, &ENTRY_DRAFTINESSES_2337311124395489337)],
    ),
    (
        crate::EncodedStr::Ascii("draftsman"),
        &[(0b01001, &ENTRY_DRAFTSMAN_2158426515502784003)],
    ),
    (
        crate::EncodedStr::Ascii("draftsmanship"),
        &[(0b01001, &ENTRY_DRAFTSMANSHIP_14701669807878909941)],
    ),
    (
        crate::EncodedStr::Ascii("draftsmanships"),
        &[(0b01001, &ENTRY_DRAFTSMANSHIPS_3009875565957915648)],
    ),
    (
        crate::EncodedStr::Ascii("draftsmen"),
        &[(0b01001, &ENTRY_DRAFTSMEN_11969721402571410341)],
    ),
    (
        crate::EncodedStr::Ascii("draftsperson"),
        &[(0b01001, &ENTRY_DRAFTSPERSON_17252902994124085558)],
    ),
    (
        crate::EncodedStr::Ascii("draftswoman"),
        &[(0b01001, &ENTRY_DRAFTSWOMAN_13749770471062736806)],
    ),
    (
        crate::EncodedStr::Ascii("draftswomen"),
        &[(0b01001, &ENTRY_DRAFTSWOMEN_14692115605095290784)],
    ),
    (
        crate::EncodedStr::Ascii("drafty"),
        &[(0b01001, &ENTRY_DRAFTY_11689082232746206984)],
    ),
    (
        crate::EncodedStr::Ascii("dragonise"),
        &[(0b10010, &ENTRY_DRAGONIZE_14160202049023947793)],
    ),
    (
        crate::EncodedStr::Ascii("dragonised"),
        &[(0b10010, &ENTRY_DRAGONIZED_13277720972691636848)],
    ),
    (
        crate::EncodedStr::Ascii("dragonises"),
        &[(0b10010, &ENTRY_DRAGONIZES_8370477046170548627)],
    ),
    (
        crate::EncodedStr::Ascii("dragonising"),
        &[(0b10010, &ENTRY_DRAGONIZING_15675970912123878416)],
    ),
    (
        crate::EncodedStr::Ascii("dragonize"),
        &[(0b01001, &ENTRY_DRAGONIZE_14160202049023947793)],
    ),
    (
        crate::EncodedStr::Ascii("dragonized"),
        &[(0b01001, &ENTRY_DRAGONIZED_13277720972691636848)],
    ),
    (
        crate::EncodedStr::Ascii("dragonizes"),
        &[(0b01001, &ENTRY_DRAGONIZES_8370477046170548627)],
    ),
    (
        crate::EncodedStr::Ascii("dragonizing"),
        &[(0b01001, &ENTRY_DRAGONIZING_15675970912123878416)],
    ),
    (
        crate::EncodedStr::Ascii("dramatisable"),
        &[(0b10010, &ENTRY_DRAMATIZABLE_114460072530125204)],
    ),
    (
        crate::EncodedStr::Ascii("dramatisabler"),
        &[(0b10010, &ENTRY_DRAMATIZABLER_14017923335901627289)],
    ),
    (
        crate::EncodedStr::Ascii("dramatisables"),
        &[(0b10010, &ENTRY_DRAMATIZABLES_12929019439166166978)],
    ),
    (
        crate::EncodedStr::Ascii("dramatisablest"),
        &[(0b10010, &ENTRY_DRAMATIZABLEST_11908506320782789726)],
    ),
    (
        crate::EncodedStr::Ascii("dramatisation"),
        &[(0b10010, &ENTRY_DRAMATIZATION_18352830060262048924)],
    ),
    (
        crate::EncodedStr::Ascii("dramatisations"),
        &[(0b10010, &ENTRY_DRAMATIZATIONS_4872008295467161969)],
    ),
    (
        crate::EncodedStr::Ascii("dramatise"),
        &[(0b10010, &ENTRY_DRAMATIZE_11024442299136514965)],
    ),
    (
        crate::EncodedStr::Ascii("dramatised"),
        &[(0b10010, &ENTRY_DRAMATIZED_2372982752652968078)],
    ),
    (
        crate::EncodedStr::Ascii("dramatiser"),
        &[(0b10010, &ENTRY_DRAMATIZER_12312020267573769761)],
    ),
    (
        crate::EncodedStr::Ascii("dramatisers"),
        &[(0b10010, &ENTRY_DRAMATIZERS_17282413603035313323)],
    ),
    (
        crate::EncodedStr::Ascii("dramatises"),
        &[(0b10010, &ENTRY_DRAMATIZES_14716282266966184426)],
    ),
    (
        crate::EncodedStr::Ascii("dramatising"),
        &[(0b10010, &ENTRY_DRAMATIZING_14243240191823624849)],
    ),
    (
        crate::EncodedStr::Ascii("dramatizable"),
        &[(0b01001, &ENTRY_DRAMATIZABLE_114460072530125204)],
    ),
    (
        crate::EncodedStr::Ascii("dramatizabler"),
        &[(0b01001, &ENTRY_DRAMATIZABLER_14017923335901627289)],
    ),
    (
        crate::EncodedStr::Ascii("dramatizables"),
        &[(0b01001, &ENTRY_DRAMATIZABLES_12929019439166166978)],
    ),
    (
        crate::EncodedStr::Ascii("dramatizablest"),
        &[(0b01001, &ENTRY_DRAMATIZABLEST_11908506320782789726)],
    ),
    (
        crate::EncodedStr::Ascii("dramatization"),
        &[(0b01001, &ENTRY_DRAMATIZATION_18352830060262048924)],
    ),
    (
        crate::EncodedStr::Ascii("dramatizations"),
        &[(0b01001, &ENTRY_DRAMATIZATIONS_4872008295467161969)],
    ),
    (
        crate::EncodedStr::Ascii("dramatize"),
        &[(0b01001, &ENTRY_DRAMATIZE_11024442299136514965)],
    ),
    (
        crate::EncodedStr::Ascii("dramatized"),
        &[(0b01001, &ENTRY_DRAMATIZED_2372982752652968078)],
    ),
    (
        crate::EncodedStr::Ascii("dramatizer"),
        &[(0b01001, &ENTRY_DRAMATIZER_12312020267573769761)],
    ),
    (
        crate::EncodedStr::Ascii("dramatizers"),
        &[(0b01001, &ENTRY_DRAMATIZERS_17282413603035313323)],
    ),
    (
        crate::EncodedStr::Ascii("dramatizes"),
        &[(0b01001, &ENTRY_DRAMATIZES_14716282266966184426)],
    ),
    (
        crate::EncodedStr::Ascii("dramatizing"),
        &[(0b01001, &ENTRY_DRAMATIZING_14243240191823624849)],
    ),
    (
        crate::EncodedStr::Ascii("draughted"),
        &[(0b10010, &ENTRY_DRAFTED_2613143638373081360)],
    ),
    (
        crate::EncodedStr::Ascii("draughtier"),
        &[(0b10010, &ENTRY_DRAFTIER_9222724357623798327)],
    ),
    (
        crate::EncodedStr::Ascii("draughtiest"),
        &[(0b10010, &ENTRY_DRAFTIEST_5259543064524205513)],
    ),
    (
        crate::EncodedStr::Ascii("draughtilier"),
        &[(0b10010, &ENTRY_DRAFTILIER_6263136181960657686)],
    ),
    (
        crate::EncodedStr::Ascii("draughtiliest"),
        &[(0b10010, &ENTRY_DRAFTILIEST_12111711614227754883)],
    ),
    (
        crate::EncodedStr::Ascii("draughtily"),
        &[(0b10010, &ENTRY_DRAFTILY_3404853207703525148)],
    ),
    (
        crate::EncodedStr::Ascii("draughtiness"),
        &[(0b10010, &ENTRY_DRAFTINESS_5050558803290260054)],
    ),
    (
        crate::EncodedStr::Ascii("draughtinesses"),
        &[(0b10010, &ENTRY_DRAFTINESSES_2337311124395489337)],
    ),
    (
        crate::EncodedStr::Ascii("draughting"),
        &[(0b10010, &ENTRY_DRAFTING_8913342336646949258)],
    ),
    (
        crate::EncodedStr::Ascii("draughtsmanship"),
        &[(0b10010, &ENTRY_DRAFTSMANSHIP_14701669807878909941)],
    ),
    (
        crate::EncodedStr::Ascii("draughtsmanships"),
        &[(0b10010, &ENTRY_DRAFTSMANSHIPS_3009875565957915648)],
    ),
    (
        crate::EncodedStr::Ascii("draughtsperson"),
        &[(0b10010, &ENTRY_DRAFTSPERSON_17252902994124085558)],
    ),
    (
        crate::EncodedStr::Ascii("draughtswoman"),
        &[(0b10010, &ENTRY_DRAFTSWOMAN_13749770471062736806)],
    ),
    (
        crate::EncodedStr::Ascii("draughtswomen"),
        &[(0b10010, &ENTRY_DRAFTSWOMEN_14692115605095290784)],
    ),
    (
        crate::EncodedStr::Ascii("draughty"),
        &[(0b10010, &ENTRY_DRAFTY_11689082232746206984)],
    ),
    (
        crate::EncodedStr::Ascii("dreamt"),
        &[(0b11010, &ENTRY_DREAMED_693371865095129101)],
    ),
    (
        crate::EncodedStr::Ascii("drek"),
        &[(0b11010, &ENTRY_DERK_4716671464297446249)],
    ),
    (
        crate::EncodedStr::Ascii("drer"),
        &[(0b11010, &ENTRY_DERR_8497357744990730455)],
    ),
    (
        crate::EncodedStr::Ascii("driveled"),
        &[(0b00001, &ENTRY_DRIVELED_7030750316386626325)],
    ),
    (
        crate::EncodedStr::Ascii("driveler"),
        &[(0b00001, &ENTRY_DRIVELER_13922515254126867061)],
    ),
    (
        crate::EncodedStr::Ascii("drivelers"),
        &[(0b00001, &ENTRY_DRIVELERS_719861811563082420)],
    ),
    (
        crate::EncodedStr::Ascii("driveling"),
        &[(0b00001, &ENTRY_DRIVELING_8695688524206031945)],
    ),
    (
        crate::EncodedStr::Ascii("drivelled"),
        &[(0b11010, &ENTRY_DRIVELED_7030750316386626325)],
    ),
    (
        crate::EncodedStr::Ascii("driveller"),
        &[(0b11010, &ENTRY_DRIVELER_13922515254126867061)],
    ),
    (
        crate::EncodedStr::Ascii("drivellers"),
        &[(0b11010, &ENTRY_DRIVELERS_719861811563082420)],
    ),
    (
        crate::EncodedStr::Ascii("drivelling"),
        &[(0b11010, &ENTRY_DRIVELING_8695688524206031945)],
    ),
    (
        crate::EncodedStr::Ascii("dualisation"),
        &[(0b10010, &ENTRY_DUALIZATION_297757979352720010)],
    ),
    (
        crate::EncodedStr::Ascii("dualisations"),
        &[(0b10010, &ENTRY_DUALIZATIONS_1769778750613840808)],
    ),
    (
        crate::EncodedStr::Ascii("dualise"),
        &[(0b10010, &ENTRY_DUALIZE_14667812076587421504)],
    ),
    (
        crate::EncodedStr::Ascii("dualises"),
        &[(0b10010, &ENTRY_DUALIZES_6580630624039637450)],
    ),
    (
        crate::EncodedStr::Ascii("dualization"),
        &[(0b01001, &ENTRY_DUALIZATION_297757979352720010)],
    ),
    (
        crate::EncodedStr::Ascii("dualizations"),
        &[(0b01001, &ENTRY_DUALIZATIONS_1769778750613840808)],
    ),
    (
        crate::EncodedStr::Ascii("dualize"),
        &[(0b01001, &ENTRY_DUALIZE_14667812076587421504)],
    ),
    (
        crate::EncodedStr::Ascii("dualizes"),
        &[(0b01001, &ENTRY_DUALIZES_6580630624039637450)],
    ),
    (
        crate::EncodedStr::Ascii("ductilise"),
        &[(0b10010, &ENTRY_DUCTILIZE_5117009823320979710)],
    ),
    (
        crate::EncodedStr::Ascii("ductilises"),
        &[(0b10010, &ENTRY_DUCTILIZES_8324019089066090944)],
    ),
    (
        crate::EncodedStr::Ascii("ductilize"),
        &[(0b01001, &ENTRY_DUCTILIZE_5117009823320979710)],
    ),
    (
        crate::EncodedStr::Ascii("ductilizes"),
        &[(0b01001, &ENTRY_DUCTILIZES_8324019089066090944)],
    ),
    (
        crate::EncodedStr::Ascii("dueled"),
        &[(0b00001, &ENTRY_DUELED_14139003527020650904)],
    ),
    (
        crate::EncodedStr::Ascii("dueler"),
        &[(0b00001, &ENTRY_DUELER_17639225109776633494)],
    ),
    (
        crate::EncodedStr::Ascii("duelers"),
        &[(0b00001, &ENTRY_DUELERS_885313812620534811)],
    ),
    (
        crate::EncodedStr::Ascii("dueling"),
        &[(0b00001, &ENTRY_DUELING_5778547651645125895)],
    ),
    (
        crate::EncodedStr::Ascii("duelings"),
        &[(0b00001, &ENTRY_DUELINGS_14759091337280437276)],
    ),
    (
        crate::EncodedStr::Ascii("duelist"),
        &[(0b00001, &ENTRY_DUELIST_6970922052642565539)],
    ),
    (
        crate::EncodedStr::Ascii("duelists"),
        &[(0b00001, &ENTRY_DUELISTS_18258331536218201176)],
    ),
    (
        crate::EncodedStr::Ascii("duelled"),
        &[(0b11010, &ENTRY_DUELED_14139003527020650904)],
    ),
    (
        crate::EncodedStr::Ascii("dueller"),
        &[(0b11010, &ENTRY_DUELER_17639225109776633494)],
    ),
    (
        crate::EncodedStr::Ascii("duellers"),
        &[(0b11010, &ENTRY_DUELERS_885313812620534811)],
    ),
    (
        crate::EncodedStr::Ascii("duelling"),
        &[(0b11010, &ENTRY_DUELING_5778547651645125895)],
    ),
    (
        crate::EncodedStr::Ascii("duellings"),
        &[(0b11010, &ENTRY_DUELINGS_14759091337280437276)],
    ),
    (
        crate::EncodedStr::Ascii("duellist"),
        &[(0b11010, &ENTRY_DUELIST_6970922052642565539)],
    ),
    (
        crate::EncodedStr::Ascii("duellists"),
        &[(0b11010, &ENTRY_DUELISTS_18258331536218201176)],
    ),
    (
        crate::EncodedStr::Ascii("duer"),
        &[(0b00001, &ENTRY_DUER_2007337493238246122)],
    ),
    (
        crate::EncodedStr::Ascii("dure"),
        &[(0b11010, &ENTRY_DUER_2007337493238246122)],
    ),
    (
        crate::EncodedStr::Ascii("dynamise"),
        &[(0b10010, &ENTRY_DYNAMIZE_16898679564021204348)],
    ),
    (
        crate::EncodedStr::Ascii("dynamised"),
        &[(0b10010, &ENTRY_DYNAMIZED_11851467384344631451)],
    ),
    (
        crate::EncodedStr::Ascii("dynamises"),
        &[(0b10010, &ENTRY_DYNAMIZES_8572022122021418990)],
    ),
    (
        crate::EncodedStr::Ascii("dynamising"),
        &[(0b10010, &ENTRY_DYNAMIZING_15204260139319478124)],
    ),
    (
        crate::EncodedStr::Ascii("dynamize"),
        &[(0b01001, &ENTRY_DYNAMIZE_16898679564021204348)],
    ),
    (
        crate::EncodedStr::Ascii("dynamized"),
        &[(0b01001, &ENTRY_DYNAMIZED_11851467384344631451)],
    ),
    (
        crate::EncodedStr::Ascii("dynamizes"),
        &[(0b01001, &ENTRY_DYNAMIZES_8572022122021418990)],
    ),
    (
        crate::EncodedStr::Ascii("dynamizing"),
        &[(0b01001, &ENTRY_DYNAMIZING_15204260139319478124)],
    ),
    (
        crate::EncodedStr::Ascii("dysaesthesia"),
        &[(0b11010, &ENTRY_DYSESTHESIA_10145261120272617451)],
    ),
    (
        crate::EncodedStr::Ascii("dysaesthetic"),
        &[(0b11010, &ENTRY_DYSESTHETIC_9985209311909479038)],
    ),
    (
        crate::EncodedStr::Ascii("dysesthesia"),
        &[(0b10001, &ENTRY_DYSESTHESIA_10145261120272617451)],
    ),
    (
        crate::EncodedStr::Ascii("dysesthetic"),
        &[(0b10001, &ENTRY_DYSESTHETIC_9985209311909479038)],
    ),
    (
        crate::EncodedStr::Ascii("dysmenorrhea"),
        &[(0b10001, &ENTRY_DYSMENORRHEA_666903672534201582)],
    ),
    (
        crate::EncodedStr::Ascii("dysmenorrheal"),
        &[(0b10001, &ENTRY_DYSMENORRHEAL_3211916475354947561)],
    ),
    (
        crate::EncodedStr::Ascii("dysmenorrheas"),
        &[(0b10001, &ENTRY_DYSMENORRHEAS_8092414813964160172)],
    ),
    (
        crate::EncodedStr::Ascii("dysmenorrheic"),
        &[(0b10001, &ENTRY_DYSMENORRHEIC_17754264387759129903)],
    ),
    (
        crate::EncodedStr::Ascii("dysmenorrhoea"),
        &[(0b11010, &ENTRY_DYSMENORRHEA_666903672534201582)],
    ),
    (
        crate::EncodedStr::Ascii("dysmenorrhoeal"),
        &[(0b11010, &ENTRY_DYSMENORRHEAL_3211916475354947561)],
    ),
    (
        crate::EncodedStr::Ascii("dysmenorrhoeas"),
        &[(0b11010, &ENTRY_DYSMENORRHEAS_8092414813964160172)],
    ),
    (
        crate::EncodedStr::Ascii("dysmenorrhoeic"),
        &[(0b11010, &ENTRY_DYSMENORRHEIC_17754264387759129903)],
    ),
    (
        crate::EncodedStr::Ascii("dyspnea"),
        &[(0b11001, &ENTRY_DYSPNEA_3275451076579387530)],
    ),
    (
        crate::EncodedStr::Ascii("dyspneal"),
        &[(0b10001, &ENTRY_DYSPNEAL_4877333742970701237)],
    ),
    (
        crate::EncodedStr::Ascii("dyspneas"),
        &[(0b11001, &ENTRY_DYSPNEAS_2665152845196591077)],
    ),
    (
        crate::EncodedStr::Ascii("dyspneic"),
        &[(0b10001, &ENTRY_DYSPNEIC_8845859738600782802)],
    ),
    (
        crate::EncodedStr::Ascii("dyspnoea"),
        &[(0b10010, &ENTRY_DYSPNEA_3275451076579387530)],
    ),
    (
        crate::EncodedStr::Ascii("dyspnoeal"),
        &[(0b11010, &ENTRY_DYSPNEAL_4877333742970701237)],
    ),
    (
        crate::EncodedStr::Ascii("dyspnoeas"),
        &[(0b10010, &ENTRY_DYSPNEAS_2665152845196591077)],
    ),
    (
        crate::EncodedStr::Ascii("dyspnoeic"),
        &[(0b11010, &ENTRY_DYSPNEIC_8845859738600782802)],
    ),
    (
        crate::EncodedStr::Ascii("eaetion"),
        &[(0b11010, &ENTRY_EETION_7506982938713093790)],
    ),
    (
        crate::EncodedStr::Ascii("earlierise"),
        &[(0b10010, &ENTRY_EARLIERIZE_11997942640911832041)],
    ),
    (
        crate::EncodedStr::Ascii("earlierised"),
        &[(0b10010, &ENTRY_EARLIERIZED_5951041999526558231)],
    ),
    (
        crate::EncodedStr::Ascii("earlierises"),
        &[(0b10010, &ENTRY_EARLIERIZES_5592536878851474631)],
    ),
    (
        crate::EncodedStr::Ascii("earlierising"),
        &[(0b10010, &ENTRY_EARLIERIZING_8179681759986389983)],
    ),
    (
        crate::EncodedStr::Ascii("earlierize"),
        &[(0b01001, &ENTRY_EARLIERIZE_11997942640911832041)],
    ),
    (
        crate::EncodedStr::Ascii("earlierized"),
        &[(0b01001, &ENTRY_EARLIERIZED_5951041999526558231)],
    ),
    (
        crate::EncodedStr::Ascii("earlierizes"),
        &[(0b01001, &ENTRY_EARLIERIZES_5592536878851474631)],
    ),
    (
        crate::EncodedStr::Ascii("earlierizing"),
        &[(0b01001, &ENTRY_EARLIERIZING_8179681759986389983)],
    ),
    (
        crate::EncodedStr::Ascii("easternise"),
        &[(0b10010, &ENTRY_EASTERNIZE_12013346158934132557)],
    ),
    (
        crate::EncodedStr::Ascii("easternize"),
        &[(0b01001, &ENTRY_EASTERNIZE_12013346158934132557)],
    ),
    (
        crate::EncodedStr::Ascii("ebionise"),
        &[(0b10010, &ENTRY_EBIONIZE_14882150669745577807)],
    ),
    (
        crate::EncodedStr::Ascii("ebionised"),
        &[(0b10010, &ENTRY_EBIONIZED_607134243617959572)],
    ),
    (
        crate::EncodedStr::Ascii("ebionises"),
        &[(0b10010, &ENTRY_EBIONIZES_4728139485714479539)],
    ),
    (
        crate::EncodedStr::Ascii("ebionising"),
        &[(0b10010, &ENTRY_EBIONIZING_6877070461214793032)],
    ),
    (
        crate::EncodedStr::Ascii("ebionize"),
        &[(0b01001, &ENTRY_EBIONIZE_14882150669745577807)],
    ),
    (
        crate::EncodedStr::Ascii("ebionized"),
        &[(0b01001, &ENTRY_EBIONIZED_607134243617959572)],
    ),
    (
        crate::EncodedStr::Ascii("ebionizes"),
        &[(0b01001, &ENTRY_EBIONIZES_4728139485714479539)],
    ),
    (
        crate::EncodedStr::Ascii("ebionizing"),
        &[(0b01001, &ENTRY_EBIONIZING_6877070461214793032)],
    ),
    (
        crate::EncodedStr::Ascii("ebonisation"),
        &[(0b10010, &ENTRY_EBONIZATION_5157733486316868335)],
    ),
    (
        crate::EncodedStr::Ascii("ebonise"),
        &[(0b10010, &ENTRY_EBONIZE_8171442481512187913)],
    ),
    (
        crate::EncodedStr::Ascii("ebonised"),
        &[(0b10010, &ENTRY_EBONIZED_3445883171941210725)],
    ),
    (
        crate::EncodedStr::Ascii("ebonises"),
        &[(0b10010, &ENTRY_EBONIZES_7098552992016802268)],
    ),
    (
        crate::EncodedStr::Ascii("ebonising"),
        &[(0b10010, &ENTRY_EBONIZING_1463384613006749087)],
    ),
    (
        crate::EncodedStr::Ascii("ebonization"),
        &[(0b01001, &ENTRY_EBONIZATION_5157733486316868335)],
    ),
    (
        crate::EncodedStr::Ascii("ebonize"),
        &[(0b01001, &ENTRY_EBONIZE_8171442481512187913)],
    ),
    (
        crate::EncodedStr::Ascii("ebonized"),
        &[(0b01001, &ENTRY_EBONIZED_3445883171941210725)],
    ),
    (
        crate::EncodedStr::Ascii("ebonizes"),
        &[(0b01001, &ENTRY_EBONIZES_7098552992016802268)],
    ),
    (
        crate::EncodedStr::Ascii("ebonizing"),
        &[(0b01001, &ENTRY_EBONIZING_1463384613006749087)],
    ),
    (
        crate::EncodedStr::Ascii("ec"),
        &[(0b00001, &ENTRY_EC_18369594411890017360)],
    ),
    (
        crate::EncodedStr::Ascii("ecclesiasticise"),
        &[(0b10010, &ENTRY_ECCLESIASTICIZE_5375790565507371661)],
    ),
    (
        crate::EncodedStr::Ascii("ecclesiasticises"),
        &[(0b10010, &ENTRY_ECCLESIASTICIZES_17947325437796182000)],
    ),
    (
        crate::EncodedStr::Ascii("ecclesiasticize"),
        &[(0b01001, &ENTRY_ECCLESIASTICIZE_5375790565507371661)],
    ),
    (
        crate::EncodedStr::Ascii("ecclesiasticizes"),
        &[(0b01001, &ENTRY_ECCLESIASTICIZES_17947325437796182000)],
    ),
    (
        crate::EncodedStr::Ascii("echoise"),
        &[(0b10010, &ENTRY_ECHOIZE_9793911410527060783)],
    ),
    (
        crate::EncodedStr::Ascii("echoised"),
        &[(0b10010, &ENTRY_ECHOIZED_6584344175654222383)],
    ),
    (
        crate::EncodedStr::Ascii("echoises"),
        &[(0b10010, &ENTRY_ECHOIZES_17651680927186205508)],
    ),
    (
        crate::EncodedStr::Ascii("echoising"),
        &[(0b10010, &ENTRY_ECHOIZING_13817992796446083050)],
    ),
    (
        crate::EncodedStr::Ascii("echoize"),
        &[(0b01001, &ENTRY_ECHOIZE_9793911410527060783)],
    ),
    (
        crate::EncodedStr::Ascii("echoized"),
        &[(0b01001, &ENTRY_ECHOIZED_6584344175654222383)],
    ),
    (
        crate::EncodedStr::Ascii("echoizes"),
        &[(0b01001, &ENTRY_ECHOIZES_17651680927186205508)],
    ),
    (
        crate::EncodedStr::Ascii("echoizing"),
        &[(0b01001, &ENTRY_ECHOIZING_13817992796446083050)],
    ),
    (
        crate::EncodedStr::Ascii("eclecticise"),
        &[(0b10010, &ENTRY_ECLECTICIZE_1537579377409875615)],
    ),
    (
        crate::EncodedStr::Ascii("eclecticises"),
        &[(0b10010, &ENTRY_ECLECTICIZES_18162048424932631142)],
    ),
    (
        crate::EncodedStr::Ascii("eclecticize"),
        &[(0b01001, &ENTRY_ECLECTICIZE_1537579377409875615)],
    ),
    (
        crate::EncodedStr::Ascii("eclecticizes"),
        &[(0b01001, &ENTRY_ECLECTICIZES_18162048424932631142)],
    ),
    (
        crate::EncodedStr::Ascii("ecoid"),
        &[(0b00001, &ENTRY_ECOID_15718380068289810443)],
    ),
    (
        crate::EncodedStr::Ascii("economisation"),
        &[(0b10010, &ENTRY_ECONOMIZATION_17236921042856233623)],
    ),
    (
        crate::EncodedStr::Ascii("economisations"),
        &[(0b10010, &ENTRY_ECONOMIZATIONS_13677505030173502975)],
    ),
    (
        crate::EncodedStr::Ascii("economise"),
        &[(0b10010, &ENTRY_ECONOMIZE_12358668986073235407)],
    ),
    (
        crate::EncodedStr::Ascii("economised"),
        &[(0b10010, &ENTRY_ECONOMIZED_18148417393969980009)],
    ),
    (
        crate::EncodedStr::Ascii("economiser"),
        &[(0b10010, &ENTRY_ECONOMIZER_14737250670952641028)],
    ),
    (
        crate::EncodedStr::Ascii("economisers"),
        &[(0b10010, &ENTRY_ECONOMIZERS_12502480689214202445)],
    ),
    (
        crate::EncodedStr::Ascii("economises"),
        &[(0b10010, &ENTRY_ECONOMIZES_12987737212565587737)],
    ),
    (
        crate::EncodedStr::Ascii("economising"),
        &[(0b10010, &ENTRY_ECONOMIZING_11359270378553989667)],
    ),
    (
        crate::EncodedStr::Ascii("economization"),
        &[(0b01001, &ENTRY_ECONOMIZATION_17236921042856233623)],
    ),
    (
        crate::EncodedStr::Ascii("economizations"),
        &[(0b01001, &ENTRY_ECONOMIZATIONS_13677505030173502975)],
    ),
    (
        crate::EncodedStr::Ascii("economize"),
        &[(0b01001, &ENTRY_ECONOMIZE_12358668986073235407)],
    ),
    (
        crate::EncodedStr::Ascii("economized"),
        &[(0b01001, &ENTRY_ECONOMIZED_18148417393969980009)],
    ),
    (
        crate::EncodedStr::Ascii("economizer"),
        &[(0b01001, &ENTRY_ECONOMIZER_14737250670952641028)],
    ),
    (
        crate::EncodedStr::Ascii("economizers"),
        &[(0b01001, &ENTRY_ECONOMIZERS_12502480689214202445)],
    ),
    (
        crate::EncodedStr::Ascii("economizes"),
        &[(0b01001, &ENTRY_ECONOMIZES_12987737212565587737)],
    ),
    (
        crate::EncodedStr::Ascii("economizing"),
        &[(0b01001, &ENTRY_ECONOMIZING_11359270378553989667)],
    ),
    (
        crate::EncodedStr::Ascii("ecophobia"),
        &[(0b00001, &ENTRY_ECOPHOBIA_3341542489768933704)],
    ),
    (
        crate::EncodedStr::Ascii("ecstasise"),
        &[(0b10010, &ENTRY_ECSTASIZE_12478888629525898090)],
    ),
    (
        crate::EncodedStr::Ascii("ecstasised"),
        &[(0b10010, &ENTRY_ECSTASIZED_14433048399656133421)],
    ),
    (
        crate::EncodedStr::Ascii("ecstasises"),
        &[(0b10010, &ENTRY_ECSTASIZES_4161308607604786330)],
    ),
    (
        crate::EncodedStr::Ascii("ecstasising"),
        &[(0b10010, &ENTRY_ECSTASIZING_2299211862700315587)],
    ),
    (
        crate::EncodedStr::Ascii("ecstasize"),
        &[(0b01001, &ENTRY_ECSTASIZE_12478888629525898090)],
    ),
    (
        crate::EncodedStr::Ascii("ecstasized"),
        &[(0b01001, &ENTRY_ECSTASIZED_14433048399656133421)],
    ),
    (
        crate::EncodedStr::Ascii("ecstasizes"),
        &[(0b01001, &ENTRY_ECSTASIZES_4161308607604786330)],
    ),
    (
        crate::EncodedStr::Ascii("ecstasizing"),
        &[(0b01001, &ENTRY_ECSTASIZING_2299211862700315587)],
    ),
    (
        crate::EncodedStr::Ascii("ecstaticise"),
        &[(0b10010, &ENTRY_ECSTATICIZE_10857806109758048478)],
    ),
    (
        crate::EncodedStr::Ascii("ecstaticises"),
        &[(0b10010, &ENTRY_ECSTATICIZES_12312353657798123304)],
    ),
    (
        crate::EncodedStr::Ascii("ecstaticize"),
        &[(0b01001, &ENTRY_ECSTATICIZE_10857806109758048478)],
    ),
    (
        crate::EncodedStr::Ascii("ecstaticizes"),
        &[(0b01001, &ENTRY_ECSTATICIZES_12312353657798123304)],
    ),
    (
        crate::EncodedStr::Ascii("ectethmoid"),
        &[(0b00001, &ENTRY_ECTETHMOID_4932886455054265154)],
    ),
    (
        crate::EncodedStr::Ascii("ectocelic"),
        &[(0b10001, &ENTRY_ECTOCELIC_15109589632064964048)],
    ),
    (
        crate::EncodedStr::Ascii("ectocoelic"),
        &[(0b11010, &ENTRY_ECTOCELIC_15109589632064964048)],
    ),
    (
        crate::EncodedStr::Ascii("ectoethmoid"),
        &[(0b11010, &ENTRY_ECTETHMOID_4932886455054265154)],
    ),
    (
        crate::EncodedStr::Ascii("ecus"),
        &[(0b00001, &ENTRY_ECUS_7337291910539278082)],
    ),
    (
        crate::EncodedStr::Ascii("edema"),
        &[(0b11001, &ENTRY_EDEMA_6018744134424908364)],
    ),
    (
        crate::EncodedStr::Ascii("edemas"),
        &[(0b11001, &ENTRY_EDEMAS_7742566514366737816)],
    ),
    (
        crate::EncodedStr::Ascii("edematose"),
        &[(0b11001, &ENTRY_EDEMATOSE_16851378643586465230)],
    ),
    (
        crate::EncodedStr::Ascii("edematous"),
        &[(0b11001, &ENTRY_EDEMATOUS_2501565917049629990)],
    ),
    (
        crate::EncodedStr::Ascii("edenisation"),
        &[(0b10010, &ENTRY_EDENIZATION_14877368160810371784)],
    ),
    (
        crate::EncodedStr::Ascii("edenisations"),
        &[(0b10010, &ENTRY_EDENIZATIONS_17717672445150358731)],
    ),
    (
        crate::EncodedStr::Ascii("edenise"),
        &[(0b10010, &ENTRY_EDENIZE_4547310883249177007)],
    ),
    (
        crate::EncodedStr::Ascii("edenises"),
        &[(0b10010, &ENTRY_EDENIZES_13029714813212856027)],
    ),
    (
        crate::EncodedStr::Ascii("edenization"),
        &[(0b01001, &ENTRY_EDENIZATION_14877368160810371784)],
    ),
    (
        crate::EncodedStr::Ascii("edenizations"),
        &[(0b01001, &ENTRY_EDENIZATIONS_17717672445150358731)],
    ),
    (
        crate::EncodedStr::Ascii("edenize"),
        &[(0b01001, &ENTRY_EDENIZE_4547310883249177007)],
    ),
    (
        crate::EncodedStr::Ascii("edenizes"),
        &[(0b01001, &ENTRY_EDENIZES_13029714813212856027)],
    ),
    (
        crate::EncodedStr::Ascii("edicule"),
        &[(0b00001, &ENTRY_EDICULE_10918770642841249439)],
    ),
    (
        crate::EncodedStr::Ascii("edile"),
        &[(0b00001, &ENTRY_AEDILE_7817422603194149495)],
    ),
    (
        crate::EncodedStr::Ascii("ediles"),
        &[(0b00001, &ENTRY_AEDILES_7017631595752864436)],
    ),
    (
        crate::EncodedStr::Ascii("edility"),
        &[(0b00001, &ENTRY_EDILITY_10658105135103528164)],
    ),
    (
        crate::EncodedStr::Ascii("editorialisation"),
        &[(0b10010, &ENTRY_EDITORIALIZATION_16653146908113662887)],
    ),
    (
        crate::EncodedStr::Ascii("editorialisations"),
        &[(0b10010, &ENTRY_EDITORIALIZATIONS_12319328368566597913)],
    ),
    (
        crate::EncodedStr::Ascii("editorialise"),
        &[(0b10010, &ENTRY_EDITORIALIZE_425925589943067801)],
    ),
    (
        crate::EncodedStr::Ascii("editorialised"),
        &[(0b10010, &ENTRY_EDITORIALIZED_9618808155032869338)],
    ),
    (
        crate::EncodedStr::Ascii("editorialiser"),
        &[(0b10010, &ENTRY_EDITORIALIZER_907841174282390671)],
    ),
    (
        crate::EncodedStr::Ascii("editorialises"),
        &[(0b10010, &ENTRY_EDITORIALIZES_3002090244472118034)],
    ),
    (
        crate::EncodedStr::Ascii("editorialising"),
        &[(0b10010, &ENTRY_EDITORIALIZING_4056192079667477523)],
    ),
    (
        crate::EncodedStr::Ascii("editorialization"),
        &[(0b01001, &ENTRY_EDITORIALIZATION_16653146908113662887)],
    ),
    (
        crate::EncodedStr::Ascii("editorializations"),
        &[(0b01001, &ENTRY_EDITORIALIZATIONS_12319328368566597913)],
    ),
    (
        crate::EncodedStr::Ascii("editorialize"),
        &[(0b01001, &ENTRY_EDITORIALIZE_425925589943067801)],
    ),
    (
        crate::EncodedStr::Ascii("editorialized"),
        &[(0b01001, &ENTRY_EDITORIALIZED_9618808155032869338)],
    ),
    (
        crate::EncodedStr::Ascii("editorializer"),
        &[(0b01001, &ENTRY_EDITORIALIZER_907841174282390671)],
    ),
    (
        crate::EncodedStr::Ascii("editorializes"),
        &[(0b01001, &ENTRY_EDITORIALIZES_3002090244472118034)],
    ),
    (
        crate::EncodedStr::Ascii("editorializing"),
        &[(0b01001, &ENTRY_EDITORIALIZING_4056192079667477523)],
    ),
    (
        crate::EncodedStr::Ascii("eetion"),
        &[(0b00001, &ENTRY_EETION_7506982938713093790)],
    ),
    (
        crate::EncodedStr::Ascii("effectualise"),
        &[(0b10010, &ENTRY_EFFECTUALIZE_2854942339620949483)],
    ),
    (
        crate::EncodedStr::Ascii("effectualises"),
        &[(0b10010, &ENTRY_EFFECTUALIZES_5750997542764404732)],
    ),
    (
        crate::EncodedStr::Ascii("effectualize"),
        &[(0b01001, &ENTRY_EFFECTUALIZE_2854942339620949483)],
    ),
    (
        crate::EncodedStr::Ascii("effectualizes"),
        &[(0b01001, &ENTRY_EFFECTUALIZES_5750997542764404732)],
    ),
    (
        crate::EncodedStr::Ascii("effeminatise"),
        &[(0b10010, &ENTRY_EFFEMINATIZE_6301232153675654071)],
    ),
    (
        crate::EncodedStr::Ascii("effeminatises"),
        &[(0b10010, &ENTRY_EFFEMINATIZES_10162259315067828496)],
    ),
    (
        crate::EncodedStr::Ascii("effeminatize"),
        &[(0b01001, &ENTRY_EFFEMINATIZE_6301232153675654071)],
    ),
    (
        crate::EncodedStr::Ascii("effeminatizes"),
        &[(0b01001, &ENTRY_EFFEMINATIZES_10162259315067828496)],
    ),
    (
        crate::EncodedStr::Ascii("effeminisation"),
        &[(0b10010, &ENTRY_EFFEMINIZATION_3469570906021333989)],
    ),
    (
        crate::EncodedStr::Ascii("effeminise"),
        &[(0b10010, &ENTRY_EFFEMINIZE_3367646221923186814)],
    ),
    (
        crate::EncodedStr::Ascii("effeminised"),
        &[(0b10010, &ENTRY_EFFEMINIZED_2488051553108619858)],
    ),
    (
        crate::EncodedStr::Ascii("effeminises"),
        &[(0b10010, &ENTRY_EFFEMINIZES_1751738554568598255)],
    ),
    (
        crate::EncodedStr::Ascii("effeminising"),
        &[(0b10010, &ENTRY_EFFEMINIZING_14300719326884303630)],
    ),
    (
        crate::EncodedStr::Ascii("effeminization"),
        &[(0b01001, &ENTRY_EFFEMINIZATION_3469570906021333989)],
    ),
    (
        crate::EncodedStr::Ascii("effeminize"),
        &[(0b01001, &ENTRY_EFFEMINIZE_3367646221923186814)],
    ),
    (
        crate::EncodedStr::Ascii("effeminized"),
        &[(0b01001, &ENTRY_EFFEMINIZED_2488051553108619858)],
    ),
    (
        crate::EncodedStr::Ascii("effeminizes"),
        &[(0b01001, &ENTRY_EFFEMINIZES_1751738554568598255)],
    ),
    (
        crate::EncodedStr::Ascii("effeminizing"),
        &[(0b01001, &ENTRY_EFFEMINIZING_14300719326884303630)],
    ),
    (
        crate::EncodedStr::Ascii("eger"),
        &[
            (0b00001, &ENTRY_EGER_3267279819185100866),
            (0b00001, &ENTRY_EGER_370209078151771517),
        ],
    ),
    (
        crate::EncodedStr::Ascii("egilops"),
        &[(0b00001, &ENTRY_EGILOPS_15304768767282746036)],
    ),
    (
        crate::EncodedStr::Ascii("egis"),
        &[(0b00001, &ENTRY_AEGIS_7746172769585303727)],
    ),
    (
        crate::EncodedStr::Ascii("egises"),
        &[(0b00001, &ENTRY_AEGISES_17452084053545629669)],
    ),
    (
        crate::EncodedStr::Ascii("eglogue"),
        &[(0b00001, &ENTRY_EGLOGUE_16104631981488511989)],
    ),
    (
        crate::EncodedStr::Ascii("egoise"),
        &[(0b10010, &ENTRY_EGOIZE_848168811919938232)],
    ),
    (
        crate::EncodedStr::Ascii("egoiser"),
        &[(0b10010, &ENTRY_EGOIZER_6042847438515593386)],
    ),
    (
        crate::EncodedStr::Ascii("egoisers"),
        &[(0b10010, &ENTRY_EGOIZERS_16599062205549549591)],
    ),
    (
        crate::EncodedStr::Ascii("egoises"),
        &[(0b10010, &ENTRY_EGOIZES_7296127181194814948)],
    ),
    (
        crate::EncodedStr::Ascii("egoize"),
        &[(0b01001, &ENTRY_EGOIZE_848168811919938232)],
    ),
    (
        crate::EncodedStr::Ascii("egoizer"),
        &[(0b01001, &ENTRY_EGOIZER_6042847438515593386)],
    ),
    (
        crate::EncodedStr::Ascii("egoizers"),
        &[(0b01001, &ENTRY_EGOIZERS_16599062205549549591)],
    ),
    (
        crate::EncodedStr::Ascii("egoizes"),
        &[(0b01001, &ENTRY_EGOIZES_7296127181194814948)],
    ),
    (
        crate::EncodedStr::Ascii("egophony"),
        &[(0b00001, &ENTRY_EGOPHONY_2012602110086773588)],
    ),
    (
        crate::EncodedStr::Ascii("egotise"),
        &[(0b10010, &ENTRY_EGOTIZE_10473969129670528822)],
    ),
    (
        crate::EncodedStr::Ascii("egotised"),
        &[(0b10010, &ENTRY_EGOTIZED_14948617827289949091)],
    ),
    (
        crate::EncodedStr::Ascii("egotises"),
        &[(0b10010, &ENTRY_EGOTIZES_17356051654981309847)],
    ),
    (
        crate::EncodedStr::Ascii("egotising"),
        &[(0b10010, &ENTRY_EGOTIZING_255552054661601129)],
    ),
    (
        crate::EncodedStr::Ascii("egotize"),
        &[(0b01001, &ENTRY_EGOTIZE_10473969129670528822)],
    ),
    (
        crate::EncodedStr::Ascii("egotized"),
        &[(0b01001, &ENTRY_EGOTIZED_14948617827289949091)],
    ),
    (
        crate::EncodedStr::Ascii("egotizes"),
        &[(0b01001, &ENTRY_EGOTIZES_17356051654981309847)],
    ),
    (
        crate::EncodedStr::Ascii("egotizing"),
        &[(0b01001, &ENTRY_EGOTIZING_255552054661601129)],
    ),
    (
        crate::EncodedStr::Ascii("egre"),
        &[(0b11010, &ENTRY_EGER_3267279819185100866)],
    ),
    (
        crate::EncodedStr::Ascii("egritude"),
        &[(0b00001, &ENTRY_EGRITUDE_9946971293935803579)],
    ),
    (
        crate::EncodedStr::Ascii("egyptianisation"),
        &[(0b10010, &ENTRY_EGYPTIANIZATION_10487155187974848335)],
    ),
    (
        crate::EncodedStr::Ascii("egyptianisations"),
        &[(0b10010, &ENTRY_EGYPTIANIZATIONS_14876553018910189078)],
    ),
    (
        crate::EncodedStr::Ascii("egyptianise"),
        &[(0b10010, &ENTRY_EGYPTIANIZE_3829453833375546559)],
    ),
    (
        crate::EncodedStr::Ascii("egyptianised"),
        &[(0b10010, &ENTRY_EGYPTIANIZED_16285206324460702808)],
    ),
    (
        crate::EncodedStr::Ascii("egyptianises"),
        &[(0b10010, &ENTRY_EGYPTIANIZES_8703144950337739653)],
    ),
    (
        crate::EncodedStr::Ascii("egyptianising"),
        &[(0b10010, &ENTRY_EGYPTIANIZING_14447728275835277106)],
    ),
    (
        crate::EncodedStr::Ascii("egyptianization"),
        &[(0b01001, &ENTRY_EGYPTIANIZATION_10487155187974848335)],
    ),
    (
        crate::EncodedStr::Ascii("egyptianizations"),
        &[(0b01001, &ENTRY_EGYPTIANIZATIONS_14876553018910189078)],
    ),
    (
        crate::EncodedStr::Ascii("egyptianize"),
        &[(0b01001, &ENTRY_EGYPTIANIZE_3829453833375546559)],
    ),
    (
        crate::EncodedStr::Ascii("egyptianized"),
        &[(0b01001, &ENTRY_EGYPTIANIZED_16285206324460702808)],
    ),
    (
        crate::EncodedStr::Ascii("egyptianizes"),
        &[(0b01001, &ENTRY_EGYPTIANIZES_8703144950337739653)],
    ),
    (
        crate::EncodedStr::Ascii("egyptianizing"),
        &[(0b01001, &ENTRY_EGYPTIANIZING_14447728275835277106)],
    ),
    (
        crate::EncodedStr::Ascii("egyptise"),
        &[(0b10010, &ENTRY_EGYPTIZE_7334581701121422605)],
    ),
    (
        crate::EncodedStr::Ascii("egyptises"),
        &[(0b10010, &ENTRY_EGYPTIZES_9609036163136479870)],
    ),
    (
        crate::EncodedStr::Ascii("egyptize"),
        &[(0b01001, &ENTRY_EGYPTIZE_7334581701121422605)],
    ),
    (
        crate::EncodedStr::Ascii("egyptizes"),
        &[(0b01001, &ENTRY_EGYPTIZES_9609036163136479870)],
    ),
    (
        crate::EncodedStr::Ascii("elaeoblast"),
        &[(0b11010, &ENTRY_ELEOBLAST_8021023369296032808)],
    ),
    (
        crate::EncodedStr::Ascii("elaeolite"),
        &[(0b11010, &ENTRY_ELEOLITE_8551744649156866087)],
    ),
    (
        crate::EncodedStr::Ascii("elaeomargaric"),
        &[(0b11010, &ENTRY_ELEOMARGARIC_16571690257823782694)],
    ),
    (
        crate::EncodedStr::Ascii("elaeometer"),
        &[(0b11010, &ENTRY_ELEOMETER_8406501550306573221)],
    ),
    (
        crate::EncodedStr::Ascii("elaeoptene"),
        &[(0b11010, &ENTRY_ELEOPTENE_189677587011952998)],
    ),
    (
        crate::EncodedStr::Ascii("elasticisation"),
        &[(0b10010, &ENTRY_ELASTICIZATION_15154020732606510926)],
    ),
    (
        crate::EncodedStr::Ascii("elasticise"),
        &[(0b10010, &ENTRY_ELASTICIZE_6142699365245709219)],
    ),
    (
        crate::EncodedStr::Ascii("elasticised"),
        &[(0b10010, &ENTRY_ELASTICIZED_17571893237729540044)],
    ),
    (
        crate::EncodedStr::Ascii("elasticiser"),
        &[(0b10010, &ENTRY_ELASTICIZER_15500813180956764351)],
    ),
    (
        crate::EncodedStr::Ascii("elasticisers"),
        &[(0b10010, &ENTRY_ELASTICIZERS_16095393649186847498)],
    ),
    (
        crate::EncodedStr::Ascii("elasticises"),
        &[(0b10010, &ENTRY_ELASTICIZES_15507458752832878092)],
    ),
    (
        crate::EncodedStr::Ascii("elasticising"),
        &[(0b10010, &ENTRY_ELASTICIZING_14323113355310943519)],
    ),
    (
        crate::EncodedStr::Ascii("elasticization"),
        &[(0b01001, &ENTRY_ELASTICIZATION_15154020732606510926)],
    ),
    (
        crate::EncodedStr::Ascii("elasticize"),
        &[(0b01001, &ENTRY_ELASTICIZE_6142699365245709219)],
    ),
    (
        crate::EncodedStr::Ascii("elasticized"),
        &[(0b01001, &ENTRY_ELASTICIZED_17571893237729540044)],
    ),
    (
        crate::EncodedStr::Ascii("elasticizer"),
        &[(0b01001, &ENTRY_ELASTICIZER_15500813180956764351)],
    ),
    (
        crate::EncodedStr::Ascii("elasticizers"),
        &[(0b01001, &ENTRY_ELASTICIZERS_16095393649186847498)],
    ),
    (
        crate::EncodedStr::Ascii("elasticizes"),
        &[(0b01001, &ENTRY_ELASTICIZES_15507458752832878092)],
    ),
    (
        crate::EncodedStr::Ascii("elasticizing"),
        &[(0b01001, &ENTRY_ELASTICIZING_14323113355310943519)],
    ),
    (
        crate::EncodedStr::Ascii("electricalise"),
        &[(0b10010, &ENTRY_ELECTRICALIZE_12653348063928720225)],
    ),
    (
        crate::EncodedStr::Ascii("electricalises"),
        &[(0b10010, &ENTRY_ELECTRICALIZES_11839544262325067272)],
    ),
    (
        crate::EncodedStr::Ascii("electricalize"),
        &[(0b01001, &ENTRY_ELECTRICALIZE_12653348063928720225)],
    ),
    (
        crate::EncodedStr::Ascii("electricalizes"),
        &[(0b01001, &ENTRY_ELECTRICALIZES_11839544262325067272)],
    ),
    (
        crate::EncodedStr::Ascii("electricise"),
        &[(0b10010, &ENTRY_ELECTRICIZE_4911015515844771622)],
    ),
    (
        crate::EncodedStr::Ascii("electricises"),
        &[(0b10010, &ENTRY_ELECTRICIZES_3929185044639312558)],
    ),
    (
        crate::EncodedStr::Ascii("electricize"),
        &[(0b01001, &ENTRY_ELECTRICIZE_4911015515844771622)],
    ),
    (
        crate::EncodedStr::Ascii("electricizes"),
        &[(0b01001, &ENTRY_ELECTRICIZES_3929185044639312558)],
    ),
    (
        crate::EncodedStr::Ascii("electrisation"),
        &[(0b10010, &ENTRY_ELECTRIZATION_7597451149298731659)],
    ),
    (
        crate::EncodedStr::Ascii("electrisations"),
        &[(0b10010, &ENTRY_ELECTRIZATIONS_13976280743140547777)],
    ),
    (
        crate::EncodedStr::Ascii("electrise"),
        &[(0b10010, &ENTRY_ELECTRIZE_7840311297044744924)],
    ),
    (
        crate::EncodedStr::Ascii("electrised"),
        &[(0b10010, &ENTRY_ELECTRIZED_14788122243236354566)],
    ),
    (
        crate::EncodedStr::Ascii("electrises"),
        &[(0b10010, &ENTRY_ELECTRIZES_8739623266390445152)],
    ),
    (
        crate::EncodedStr::Ascii("electrising"),
        &[(0b10010, &ENTRY_ELECTRIZING_14822771639775450790)],
    ),
    (
        crate::EncodedStr::Ascii("electrization"),
        &[(0b01001, &ENTRY_ELECTRIZATION_7597451149298731659)],
    ),
    (
        crate::EncodedStr::Ascii("electrizations"),
        &[(0b01001, &ENTRY_ELECTRIZATIONS_13976280743140547777)],
    ),
    (
        crate::EncodedStr::Ascii("electrize"),
        &[(0b01001, &ENTRY_ELECTRIZE_7840311297044744924)],
    ),
    (
        crate::EncodedStr::Ascii("electrized"),
        &[(0b01001, &ENTRY_ELECTRIZED_14788122243236354566)],
    ),
    (
        crate::EncodedStr::Ascii("electrizes"),
        &[(0b01001, &ENTRY_ELECTRIZES_8739623266390445152)],
    ),
    (
        crate::EncodedStr::Ascii("electrizing"),
        &[(0b01001, &ENTRY_ELECTRIZING_14822771639775450790)],
    ),
    (
        crate::EncodedStr::Ascii("electroanaesthesia"),
        &[(0b11010, &ENTRY_ELECTROANESTHESIA_6580395617178938362)],
    ),
    (
        crate::EncodedStr::Ascii("electroanaesthesias"),
        &[(0b11010, &ENTRY_ELECTROANESTHESIAS_6303108604980733618)],
    ),
    (
        crate::EncodedStr::Ascii("electroanesthesia"),
        &[(0b00001, &ENTRY_ELECTROANESTHESIA_6580395617178938362)],
    ),
    (
        crate::EncodedStr::Ascii("electroanesthesias"),
        &[(0b00001, &ENTRY_ELECTROANESTHESIAS_6303108604980733618)],
    ),
    (
        crate::EncodedStr::Ascii("electrocauterisation"),
        &[(0b10010, &ENTRY_ELECTROCAUTERIZATION_16903094457115645430)],
    ),
    (
        crate::EncodedStr::Ascii("electrocauterisations"),
        &[(0b10010, &ENTRY_ELECTROCAUTERIZATIONS_16892082350141619114)],
    ),
    (
        crate::EncodedStr::Ascii("electrocauterization"),
        &[(0b01001, &ENTRY_ELECTROCAUTERIZATION_16903094457115645430)],
    ),
    (
        crate::EncodedStr::Ascii("electrocauterizations"),
        &[(0b01001, &ENTRY_ELECTROCAUTERIZATIONS_16892082350141619114)],
    ),
    (
        crate::EncodedStr::Ascii("electrodialyse"),
        &[(0b11010, &ENTRY_ELECTRODIALYZE_2544367951940511335)],
    ),
    (
        crate::EncodedStr::Ascii("electrodialyser"),
        &[(0b11010, &ENTRY_ELECTRODIALYZER_12002873361469261764)],
    ),
    (
        crate::EncodedStr::Ascii("electrodialysers"),
        &[(0b11010, &ENTRY_ELECTRODIALYZERS_1528101750662982617)],
    ),
    (
        crate::EncodedStr::Ascii("electrodialyses"),
        &[(0b11010, &ENTRY_ELECTRODIALYZES_3747563092652406931)],
    ),
    (
        crate::EncodedStr::Ascii("electrodialyze"),
        &[(0b00001, &ENTRY_ELECTRODIALYZE_2544367951940511335)],
    ),
    (
        crate::EncodedStr::Ascii("electrodialyzer"),
        &[(0b00001, &ENTRY_ELECTRODIALYZER_12002873361469261764)],
    ),
    (
        crate::EncodedStr::Ascii("electrodialyzers"),
        &[(0b00001, &ENTRY_ELECTRODIALYZERS_1528101750662982617)],
    ),
    (
        crate::EncodedStr::Ascii("electrodialyzes"),
        &[(0b00001, &ENTRY_ELECTRODIALYZES_3747563092652406931)],
    ),
    (
        crate::EncodedStr::Ascii("electrogalvanise"),
        &[(0b10010, &ENTRY_ELECTROGALVANIZE_10321474051524162337)],
    ),
    (
        crate::EncodedStr::Ascii("electrogalvanises"),
        &[(0b10010, &ENTRY_ELECTROGALVANIZES_13557830902076339969)],
    ),
    (
        crate::EncodedStr::Ascii("electrogalvanize"),
        &[(0b01001, &ENTRY_ELECTROGALVANIZE_10321474051524162337)],
    ),
    (
        crate::EncodedStr::Ascii("electrogalvanizes"),
        &[(0b01001, &ENTRY_ELECTROGALVANIZES_13557830902076339969)],
    ),
    (
        crate::EncodedStr::Ascii("electrohomoeopathies"),
        &[(0b11010, &ENTRY_ELECTROHOMEOPATHIES_17935525580469832451)],
    ),
    (
        crate::EncodedStr::Ascii("electrohomoeopathy"),
        &[(0b11010, &ENTRY_ELECTROHOMEOPATHY_13185050690123434514)],
    ),
    (
        crate::EncodedStr::Ascii("electrolysation"),
        &[(0b10010, &ENTRY_ELECTROLYZATION_9992320209908525657)],
    ),
    (
        crate::EncodedStr::Ascii("electrolyse"),
        &[(0b11010, &ENTRY_ELECTROLYZE_7508850835901837851)],
    ),
    (
        crate::EncodedStr::Ascii("electrolysed"),
        &[(0b11010, &ENTRY_ELECTROLYZED_8924003047140896401)],
    ),
    (
        crate::EncodedStr::Ascii("electrolyser"),
        &[(0b10010, &ENTRY_ELECTROLYZER_712384492117912586)],
    ),
    (
        crate::EncodedStr::Ascii("electrolyses"),
        &[(0b11010, &ENTRY_ELECTROLYZES_11477690971732519647)],
    ),
    (
        crate::EncodedStr::Ascii("electrolysing"),
        &[(0b11010, &ENTRY_ELECTROLYZING_9315861603300473848)],
    ),
    (
        crate::EncodedStr::Ascii("electrolyzation"),
        &[(0b01001, &ENTRY_ELECTROLYZATION_9992320209908525657)],
    ),
    (
        crate::EncodedStr::Ascii("electrolyze"),
        &[(0b00001, &ENTRY_ELECTROLYZE_7508850835901837851)],
    ),
    (
        crate::EncodedStr::Ascii("electrolyzed"),
        &[(0b00001, &ENTRY_ELECTROLYZED_8924003047140896401)],
    ),
    (
        crate::EncodedStr::Ascii("electrolyzer"),
        &[(0b01001, &ENTRY_ELECTROLYZER_712384492117912586)],
    ),
    (
        crate::EncodedStr::Ascii("electrolyzes"),
        &[(0b00001, &ENTRY_ELECTROLYZES_11477690971732519647)],
    ),
    (
        crate::EncodedStr::Ascii("electrolyzing"),
        &[(0b00001, &ENTRY_ELECTROLYZING_9315861603300473848)],
    ),
    (
        crate::EncodedStr::Ascii("electromagnetisable"),
        &[(0b10010, &ENTRY_ELECTROMAGNETIZABLE_9739565016268970696)],
    ),
    (
        crate::EncodedStr::Ascii("electromagnetizable"),
        &[(0b01001, &ENTRY_ELECTROMAGNETIZABLE_9739565016268970696)],
    ),
    (
        crate::EncodedStr::Ascii("electrotonise"),
        &[(0b10010, &ENTRY_ELECTROTONIZE_16993410664382051345)],
    ),
    (
        crate::EncodedStr::Ascii("electrotonises"),
        &[(0b10010, &ENTRY_ELECTROTONIZES_9465124994125319681)],
    ),
    (
        crate::EncodedStr::Ascii("electrotonize"),
        &[(0b01001, &ENTRY_ELECTROTONIZE_16993410664382051345)],
    ),
    (
        crate::EncodedStr::Ascii("electrotonizes"),
        &[(0b01001, &ENTRY_ELECTROTONIZES_9465124994125319681)],
    ),
    (
        crate::EncodedStr::Ascii("elegise"),
        &[(0b10010, &ENTRY_ELEGIZE_7937759892215576690)],
    ),
    (
        crate::EncodedStr::Ascii("elegised"),
        &[(0b10010, &ENTRY_ELEGIZED_234567674978394451)],
    ),
    (
        crate::EncodedStr::Ascii("elegises"),
        &[(0b10010, &ENTRY_ELEGIZES_10107353784266158156)],
    ),
    (
        crate::EncodedStr::Ascii("elegising"),
        &[(0b10010, &ENTRY_ELEGIZING_3259872614184614593)],
    ),
    (
        crate::EncodedStr::Ascii("elegize"),
        &[(0b01001, &ENTRY_ELEGIZE_7937759892215576690)],
    ),
    (
        crate::EncodedStr::Ascii("elegized"),
        &[(0b01001, &ENTRY_ELEGIZED_234567674978394451)],
    ),
    (
        crate::EncodedStr::Ascii("elegizes"),
        &[(0b01001, &ENTRY_ELEGIZES_10107353784266158156)],
    ),
    (
        crate::EncodedStr::Ascii("elegizing"),
        &[(0b01001, &ENTRY_ELEGIZING_3259872614184614593)],
    ),
    (
        crate::EncodedStr::Ascii("elementalise"),
        &[(0b10010, &ENTRY_ELEMENTALIZE_4802665164184536596)],
    ),
    (
        crate::EncodedStr::Ascii("elementalises"),
        &[(0b10010, &ENTRY_ELEMENTALIZES_2940727419159689038)],
    ),
    (
        crate::EncodedStr::Ascii("elementalize"),
        &[(0b01001, &ENTRY_ELEMENTALIZE_4802665164184536596)],
    ),
    (
        crate::EncodedStr::Ascii("elementalizes"),
        &[(0b01001, &ENTRY_ELEMENTALIZES_2940727419159689038)],
    ),
    (
        crate::EncodedStr::Ascii("eleoblast"),
        &[(0b00001, &ENTRY_ELEOBLAST_8021023369296032808)],
    ),
    (
        crate::EncodedStr::Ascii("eleolite"),
        &[(0b00001, &ENTRY_ELEOLITE_8551744649156866087)],
    ),
    (
        crate::EncodedStr::Ascii("eleomargaric"),
        &[(0b00001, &ENTRY_ELEOMARGARIC_16571690257823782694)],
    ),
    (
        crate::EncodedStr::Ascii("eleometer"),
        &[(0b00001, &ENTRY_ELEOMETER_8406501550306573221)],
    ),
    (
        crate::EncodedStr::Ascii("eleoptene"),
        &[(0b00001, &ENTRY_ELEOPTENE_189677587011952998)],
    ),
    (
        crate::EncodedStr::Ascii("elisabethville"),
        &[(0b10010, &ENTRY_ELIZABETHVILLE_7585322377517108871)],
    ),
    (
        crate::EncodedStr::Ascii("elizabethanise"),
        &[(0b10010, &ENTRY_ELIZABETHANIZE_14863227819015951221)],
    ),
    (
        crate::EncodedStr::Ascii("elizabethanises"),
        &[(0b10010, &ENTRY_ELIZABETHANIZES_8429280681938858568)],
    ),
    (
        crate::EncodedStr::Ascii("elizabethanize"),
        &[(0b01001, &ENTRY_ELIZABETHANIZE_14863227819015951221)],
    ),
    (
        crate::EncodedStr::Ascii("elizabethanizes"),
        &[(0b01001, &ENTRY_ELIZABETHANIZES_8429280681938858568)],
    ),
    (
        crate::EncodedStr::Ascii("elizabethville"),
        &[(0b01001, &ENTRY_ELIZABETHVILLE_7585322377517108871)],
    ),
    (
        crate::EncodedStr::Ascii("emblematicise"),
        &[(0b10010, &ENTRY_EMBLEMATICIZE_5365410222867877084)],
    ),
    (
        crate::EncodedStr::Ascii("emblematicises"),
        &[(0b10010, &ENTRY_EMBLEMATICIZES_1712964621674583121)],
    ),
    (
        crate::EncodedStr::Ascii("emblematicize"),
        &[(0b01001, &ENTRY_EMBLEMATICIZE_5365410222867877084)],
    ),
    (
        crate::EncodedStr::Ascii("emblematicizes"),
        &[(0b01001, &ENTRY_EMBLEMATICIZES_1712964621674583121)],
    ),
    (
        crate::EncodedStr::Ascii("emblematisation"),
        &[(0b10010, &ENTRY_EMBLEMATIZATION_3037774664990291578)],
    ),
    (
        crate::EncodedStr::Ascii("emblematise"),
        &[(0b10010, &ENTRY_EMBLEMATIZE_12296991017617416245)],
    ),
    (
        crate::EncodedStr::Ascii("emblematised"),
        &[(0b10010, &ENTRY_EMBLEMATIZED_11833827530357489690)],
    ),
    (
        crate::EncodedStr::Ascii("emblematises"),
        &[(0b10010, &ENTRY_EMBLEMATIZES_2053946387275416277)],
    ),
    (
        crate::EncodedStr::Ascii("emblematising"),
        &[(0b10010, &ENTRY_EMBLEMATIZING_15961105666979470386)],
    ),
    (
        crate::EncodedStr::Ascii("emblematization"),
        &[(0b01001, &ENTRY_EMBLEMATIZATION_3037774664990291578)],
    ),
    (
        crate::EncodedStr::Ascii("emblematize"),
        &[(0b01001, &ENTRY_EMBLEMATIZE_12296991017617416245)],
    ),
    (
        crate::EncodedStr::Ascii("emblematized"),
        &[(0b01001, &ENTRY_EMBLEMATIZED_11833827530357489690)],
    ),
    (
        crate::EncodedStr::Ascii("emblematizes"),
        &[(0b01001, &ENTRY_EMBLEMATIZES_2053946387275416277)],
    ),
    (
        crate::EncodedStr::Ascii("emblematizing"),
        &[(0b01001, &ENTRY_EMBLEMATIZING_15961105666979470386)],
    ),
    (
        crate::EncodedStr::Ascii("emblemise"),
        &[(0b10010, &ENTRY_EMBLEMIZE_1401519711379921201)],
    ),
    (
        crate::EncodedStr::Ascii("emblemised"),
        &[(0b10010, &ENTRY_EMBLEMIZED_10594160594841460386)],
    ),
    (
        crate::EncodedStr::Ascii("emblemises"),
        &[(0b10010, &ENTRY_EMBLEMIZES_4063063334401141759)],
    ),
    (
        crate::EncodedStr::Ascii("emblemising"),
        &[(0b10010, &ENTRY_EMBLEMIZING_10846409341438865894)],
    ),
    (
        crate::EncodedStr::Ascii("emblemize"),
        &[(0b01001, &ENTRY_EMBLEMIZE_1401519711379921201)],
    ),
    (
        crate::EncodedStr::Ascii("emblemized"),
        &[(0b01001, &ENTRY_EMBLEMIZED_10594160594841460386)],
    ),
    (
        crate::EncodedStr::Ascii("emblemizes"),
        &[(0b01001, &ENTRY_EMBLEMIZES_4063063334401141759)],
    ),
    (
        crate::EncodedStr::Ascii("emblemizing"),
        &[(0b01001, &ENTRY_EMBLEMIZING_10846409341438865894)],
    ),
    (
        crate::EncodedStr::Ascii("embolisation"),
        &[(0b10010, &ENTRY_EMBOLIZATION_11273543037803448058)],
    ),
    (
        crate::EncodedStr::Ascii("embolization"),
        &[(0b01001, &ENTRY_EMBOLIZATION_11273543037803448058)],
    ),
    (
        crate::EncodedStr::Ascii("emboweled"),
        &[(0b00001, &ENTRY_EMBOWELED_4570354825435090850)],
    ),
    (
        crate::EncodedStr::Ascii("emboweling"),
        &[(0b00001, &ENTRY_EMBOWELING_2941434533991212942)],
    ),
    (
        crate::EncodedStr::Ascii("embowelled"),
        &[(0b11010, &ENTRY_EMBOWELED_4570354825435090850)],
    ),
    (
        crate::EncodedStr::Ascii("embowelling"),
        &[(0b11010, &ENTRY_EMBOWELING_2941434533991212942)],
    ),
    (
        crate::EncodedStr::Ascii("emotionalisation"),
        &[(0b10010, &ENTRY_EMOTIONALIZATION_8285067224344808560)],
    ),
    (
        crate::EncodedStr::Ascii("emotionalisations"),
        &[(0b10010, &ENTRY_EMOTIONALIZATIONS_8068177829901134213)],
    ),
    (
        crate::EncodedStr::Ascii("emotionalise"),
        &[(0b10010, &ENTRY_EMOTIONALIZE_9595590056518240613)],
    ),
    (
        crate::EncodedStr::Ascii("emotionalised"),
        &[(0b10010, &ENTRY_EMOTIONALIZED_10357036420236281327)],
    ),
    (
        crate::EncodedStr::Ascii("emotionalises"),
        &[(0b10010, &ENTRY_EMOTIONALIZES_3570691650798864535)],
    ),
    (
        crate::EncodedStr::Ascii("emotionalising"),
        &[(0b10010, &ENTRY_EMOTIONALIZING_18340248172153003025)],
    ),
    (
        crate::EncodedStr::Ascii("emotionalization"),
        &[(0b01001, &ENTRY_EMOTIONALIZATION_8285067224344808560)],
    ),
    (
        crate::EncodedStr::Ascii("emotionalizations"),
        &[(0b01001, &ENTRY_EMOTIONALIZATIONS_8068177829901134213)],
    ),
    (
        crate::EncodedStr::Ascii("emotionalize"),
        &[(0b01001, &ENTRY_EMOTIONALIZE_9595590056518240613)],
    ),
    (
        crate::EncodedStr::Ascii("emotionalized"),
        &[(0b01001, &ENTRY_EMOTIONALIZED_10357036420236281327)],
    ),
    (
        crate::EncodedStr::Ascii("emotionalizes"),
        &[(0b01001, &ENTRY_EMOTIONALIZES_3570691650798864535)],
    ),
    (
        crate::EncodedStr::Ascii("emotionalizing"),
        &[(0b01001, &ENTRY_EMOTIONALIZING_18340248172153003025)],
    ),
    (
        crate::EncodedStr::Ascii("emotionise"),
        &[(0b10010, &ENTRY_EMOTIONIZE_15015605431088092781)],
    ),
    (
        crate::EncodedStr::Ascii("emotionises"),
        &[(0b10010, &ENTRY_EMOTIONIZES_4881347793120141643)],
    ),
    (
        crate::EncodedStr::Ascii("emotionize"),
        &[(0b01001, &ENTRY_EMOTIONIZE_15015605431088092781)],
    ),
    (
        crate::EncodedStr::Ascii("emotionizes"),
        &[(0b01001, &ENTRY_EMOTIONIZES_4881347793120141643)],
    ),
    (
        crate::EncodedStr::Ascii("empaestic"),
        &[(0b11010, &ENTRY_EMPESTIC_14588541811997276042)],
    ),
    (
        crate::EncodedStr::Ascii("empaneled"),
        &[(0b00001, &ENTRY_IMPANELED_1167928814655817587)],
    ),
    (
        crate::EncodedStr::Ascii("empaneling"),
        &[(0b00001, &ENTRY_IMPANELING_8436697861195228668)],
    ),
    (
        crate::EncodedStr::Ascii("empanelled"),
        &[(0b11010, &ENTRY_IMPANELED_1167928814655817587)],
    ),
    (
        crate::EncodedStr::Ascii("empanelling"),
        &[(0b11010, &ENTRY_IMPANELING_8436697861195228668)],
    ),
    (
        crate::EncodedStr::Ascii("empathise"),
        &[(0b10010, &ENTRY_EMPATHIZE_1626505131224915017)],
    ),
    (
        crate::EncodedStr::Ascii("empathised"),
        &[(0b10010, &ENTRY_EMPATHIZED_14314991802693364328)],
    ),
    (
        crate::EncodedStr::Ascii("empathises"),
        &[(0b10010, &ENTRY_EMPATHIZES_3252518257724496702)],
    ),
    (
        crate::EncodedStr::Ascii("empathising"),
        &[(0b10010, &ENTRY_EMPATHIZING_137602655573298152)],
    ),
    (
        crate::EncodedStr::Ascii("empathize"),
        &[(0b01001, &ENTRY_EMPATHIZE_1626505131224915017)],
    ),
    (
        crate::EncodedStr::Ascii("empathized"),
        &[(0b01001, &ENTRY_EMPATHIZED_14314991802693364328)],
    ),
    (
        crate::EncodedStr::Ascii("empathizes"),
        &[(0b01001, &ENTRY_EMPATHIZES_3252518257724496702)],
    ),
    (
        crate::EncodedStr::Ascii("empathizing"),
        &[(0b01001, &ENTRY_EMPATHIZING_137602655573298152)],
    ),
    (
        crate::EncodedStr::Ascii("emperise"),
        &[(0b10010, &ENTRY_EMPERIZE_1384359766709835064)],
    ),
    (
        crate::EncodedStr::Ascii("emperised"),
        &[(0b10010, &ENTRY_EMPERIZED_3609672014387585150)],
    ),
    (
        crate::EncodedStr::Ascii("emperises"),
        &[(0b10010, &ENTRY_EMPERIZES_5086736676911735307)],
    ),
    (
        crate::EncodedStr::Ascii("emperising"),
        &[(0b10010, &ENTRY_EMPERIZING_6110004448635217910)],
    ),
    (
        crate::EncodedStr::Ascii("emperize"),
        &[(0b01001, &ENTRY_EMPERIZE_1384359766709835064)],
    ),
    (
        crate::EncodedStr::Ascii("emperized"),
        &[(0b01001, &ENTRY_EMPERIZED_3609672014387585150)],
    ),
    (
        crate::EncodedStr::Ascii("emperizes"),
        &[(0b01001, &ENTRY_EMPERIZES_5086736676911735307)],
    ),
    (
        crate::EncodedStr::Ascii("emperizing"),
        &[(0b01001, &ENTRY_EMPERIZING_6110004448635217910)],
    ),
    (
        crate::EncodedStr::Ascii("empestic"),
        &[(0b10001, &ENTRY_EMPESTIC_14588541811997276042)],
    ),
    (
        crate::EncodedStr::Ascii("emphasise"),
        &[(0b10010, &ENTRY_EMPHASIZE_15381357888908119930)],
    ),
    (
        crate::EncodedStr::Ascii("emphasised"),
        &[(0b10010, &ENTRY_EMPHASIZED_649083867029832853)],
    ),
    (
        crate::EncodedStr::Ascii("emphasiser"),
        &[(0b10010, &ENTRY_EMPHASIZER_11403370446466675303)],
    ),
    (
        crate::EncodedStr::Ascii("emphasisers"),
        &[(0b10010, &ENTRY_EMPHASIZERS_18309998515128705301)],
    ),
    (
        crate::EncodedStr::Ascii("emphasises"),
        &[(0b10010, &ENTRY_EMPHASIZES_5772436931297938243)],
    ),
    (
        crate::EncodedStr::Ascii("emphasising"),
        &[(0b10010, &ENTRY_EMPHASIZING_8877699404927600063)],
    ),
    (
        crate::EncodedStr::Ascii("emphasize"),
        &[(0b01001, &ENTRY_EMPHASIZE_15381357888908119930)],
    ),
    (
        crate::EncodedStr::Ascii("emphasized"),
        &[(0b01001, &ENTRY_EMPHASIZED_649083867029832853)],
    ),
    (
        crate::EncodedStr::Ascii("emphasizer"),
        &[(0b01001, &ENTRY_EMPHASIZER_11403370446466675303)],
    ),
    (
        crate::EncodedStr::Ascii("emphasizers"),
        &[(0b01001, &ENTRY_EMPHASIZERS_18309998515128705301)],
    ),
    (
        crate::EncodedStr::Ascii("emphasizes"),
        &[(0b01001, &ENTRY_EMPHASIZES_5772436931297938243)],
    ),
    (
        crate::EncodedStr::Ascii("emphasizing"),
        &[(0b01001, &ENTRY_EMPHASIZING_8877699404927600063)],
    ),
    (
        crate::EncodedStr::Ascii("employe"),
        &[(0b00001, &ENTRY_EMPLOYEE_11669968157991382973)],
    ),
    (
        crate::EncodedStr::Ascii("employes"),
        &[(0b00001, &ENTRY_EMPLOYEES_5068613761389447671)],
    ),
    (
        crate::EncodedStr::Ascii("empyreumatise"),
        &[(0b10010, &ENTRY_EMPYREUMATIZE_15069068830093340604)],
    ),
    (
        crate::EncodedStr::Ascii("empyreumatised"),
        &[(0b10010, &ENTRY_EMPYREUMATIZED_15637035447882020628)],
    ),
    (
        crate::EncodedStr::Ascii("empyreumatises"),
        &[(0b10010, &ENTRY_EMPYREUMATIZES_9068196112099455402)],
    ),
    (
        crate::EncodedStr::Ascii("empyreumatising"),
        &[(0b10010, &ENTRY_EMPYREUMATIZING_2341701252050540041)],
    ),
    (
        crate::EncodedStr::Ascii("empyreumatize"),
        &[(0b01001, &ENTRY_EMPYREUMATIZE_15069068830093340604)],
    ),
    (
        crate::EncodedStr::Ascii("empyreumatized"),
        &[(0b01001, &ENTRY_EMPYREUMATIZED_15637035447882020628)],
    ),
    (
        crate::EncodedStr::Ascii("empyreumatizes"),
        &[(0b01001, &ENTRY_EMPYREUMATIZES_9068196112099455402)],
    ),
    (
        crate::EncodedStr::Ascii("empyreumatizing"),
        &[(0b01001, &ENTRY_EMPYREUMATIZING_2341701252050540041)],
    ),
    (
        crate::EncodedStr::Ascii("emule"),
        &[(0b00001, &ENTRY_EMULE_1972234654623253784)],
    ),
    (
        crate::EncodedStr::Ascii("emuled"),
        &[(0b00001, &ENTRY_EMULED_10357664319101512866)],
    ),
    (
        crate::EncodedStr::Ascii("emules"),
        &[(0b00001, &ENTRY_EMULES_6796003945794582963)],
    ),
    (
        crate::EncodedStr::Ascii("emuling"),
        &[(0b00001, &ENTRY_EMULING_11304283679719960362)],
    ),
    (
        crate::EncodedStr::Ascii("emulsionise"),
        &[(0b10010, &ENTRY_EMULSIONIZE_7053945529955407436)],
    ),
    (
        crate::EncodedStr::Ascii("emulsionised"),
        &[(0b10010, &ENTRY_EMULSIONIZED_16825639760819643474)],
    ),
    (
        crate::EncodedStr::Ascii("emulsionises"),
        &[(0b10010, &ENTRY_EMULSIONIZES_16895497312962998295)],
    ),
    (
        crate::EncodedStr::Ascii("emulsionising"),
        &[(0b10010, &ENTRY_EMULSIONIZING_10164290780298735348)],
    ),
    (
        crate::EncodedStr::Ascii("emulsionize"),
        &[(0b01001, &ENTRY_EMULSIONIZE_7053945529955407436)],
    ),
    (
        crate::EncodedStr::Ascii("emulsionized"),
        &[(0b01001, &ENTRY_EMULSIONIZED_16825639760819643474)],
    ),
    (
        crate::EncodedStr::Ascii("emulsionizes"),
        &[(0b01001, &ENTRY_EMULSIONIZES_16895497312962998295)],
    ),
    (
        crate::EncodedStr::Ascii("emulsionizing"),
        &[(0b01001, &ENTRY_EMULSIONIZING_10164290780298735348)],
    ),
    (
        crate::EncodedStr::Ascii("enameled"),
        &[(0b01001, &ENTRY_ENAMELED_989404607221066133)],
    ),
    (
        crate::EncodedStr::Ascii("enameler"),
        &[(0b00001, &ENTRY_ENAMELER_14880476578662103007)],
    ),
    (
        crate::EncodedStr::Ascii("enamelers"),
        &[(0b00001, &ENTRY_ENAMELERS_7855006556277285142)],
    ),
    (
        crate::EncodedStr::Ascii("enameling"),
        &[(0b01001, &ENTRY_ENAMELING_651499017740975299)],
    ),
    (
        crate::EncodedStr::Ascii("enamelings"),
        &[(0b01001, &ENTRY_ENAMELINGS_4169856245572563917)],
    ),
    (
        crate::EncodedStr::Ascii("enamelist"),
        &[(0b00001, &ENTRY_ENAMELIST_6556021724769945893)],
    ),
    (
        crate::EncodedStr::Ascii("enamelists"),
        &[(0b00001, &ENTRY_ENAMELISTS_3600110159132815371)],
    ),
    (
        crate::EncodedStr::Ascii("enamelled"),
        &[(0b11010, &ENTRY_ENAMELED_989404607221066133)],
    ),
    (
        crate::EncodedStr::Ascii("enameller"),
        &[(0b11010, &ENTRY_ENAMELER_14880476578662103007)],
    ),
    (
        crate::EncodedStr::Ascii("enamellers"),
        &[(0b11010, &ENTRY_ENAMELERS_7855006556277285142)],
    ),
    (
        crate::EncodedStr::Ascii("enamelling"),
        &[(0b11010, &ENTRY_ENAMELING_651499017740975299)],
    ),
    (
        crate::EncodedStr::Ascii("enamellings"),
        &[(0b11010, &ENTRY_ENAMELINGS_4169856245572563917)],
    ),
    (
        crate::EncodedStr::Ascii("enamellist"),
        &[(0b11010, &ENTRY_ENAMELIST_6556021724769945893)],
    ),
    (
        crate::EncodedStr::Ascii("enamellists"),
        &[(0b11010, &ENTRY_ENAMELISTS_3600110159132815371)],
    ),
    (
        crate::EncodedStr::Ascii("enamor"),
        &[(0b11001, &ENTRY_ENAMOR_2911879302324239036)],
    ),
    (
        crate::EncodedStr::Ascii("enamored"),
        &[(0b11001, &ENTRY_ENAMORED_16186178270973267134)],
    ),
    (
        crate::EncodedStr::Ascii("enamoredness"),
        &[(0b11001, &ENTRY_ENAMOREDNESS_10996665665818617331)],
    ),
    (
        crate::EncodedStr::Ascii("enamorednesses"),
        &[(0b11001, &ENTRY_ENAMOREDNESSES_1348249767052969587)],
    ),
    (
        crate::EncodedStr::Ascii("enamoreds"),
        &[(0b11001, &ENTRY_ENAMOREDS_6301165412476267762)],
    ),
    (
        crate::EncodedStr::Ascii("enamoring"),
        &[(0b11001, &ENTRY_ENAMORING_17989678795134022497)],
    ),
    (
        crate::EncodedStr::Ascii("enamorment"),
        &[(0b11001, &ENTRY_ENAMORMENT_7471105087461120528)],
    ),
    (
        crate::EncodedStr::Ascii("enamorments"),
        &[(0b11001, &ENTRY_ENAMORMENTS_13370005761506802640)],
    ),
    (
        crate::EncodedStr::Ascii("enamors"),
        &[(0b11001, &ENTRY_ENAMORS_9636937238080184741)],
    ),
    (
        crate::EncodedStr::Ascii("enamour"),
        &[(0b11010, &ENTRY_ENAMOR_2911879302324239036)],
    ),
    (
        crate::EncodedStr::Ascii("enamoured"),
        &[(0b11010, &ENTRY_ENAMORED_16186178270973267134)],
    ),
    (
        crate::EncodedStr::Ascii("enamouredness"),
        &[(0b11010, &ENTRY_ENAMOREDNESS_10996665665818617331)],
    ),
    (
        crate::EncodedStr::Ascii("enamourednesses"),
        &[(0b11010, &ENTRY_ENAMOREDNESSES_1348249767052969587)],
    ),
    (
        crate::EncodedStr::Ascii("enamoureds"),
        &[(0b11010, &ENTRY_ENAMOREDS_6301165412476267762)],
    ),
    (
        crate::EncodedStr::Ascii("enamouring"),
        &[(0b11010, &ENTRY_ENAMORING_17989678795134022497)],
    ),
    (
        crate::EncodedStr::Ascii("enamourment"),
        &[(0b11010, &ENTRY_ENAMORMENT_7471105087461120528)],
    ),
    (
        crate::EncodedStr::Ascii("enamourments"),
        &[(0b11010, &ENTRY_ENAMORMENTS_13370005761506802640)],
    ),
    (
        crate::EncodedStr::Ascii("enamours"),
        &[(0b11010, &ENTRY_ENAMORS_9636937238080184741)],
    ),
    (
        crate::EncodedStr::Ascii("enarbor"),
        &[(0b00001, &ENTRY_ENARBOR_15915857770564812751)],
    ),
    (
        crate::EncodedStr::Ascii("enarbors"),
        &[(0b00001, &ENTRY_ENARBORS_8145891299588576620)],
    ),
    (
        crate::EncodedStr::Ascii("enarbour"),
        &[(0b11010, &ENTRY_ENARBOR_15915857770564812751)],
    ),
    (
        crate::EncodedStr::Ascii("enarbours"),
        &[(0b11010, &ENTRY_ENARBORS_8145891299588576620)],
    ),
    (
        crate::EncodedStr::Ascii("encarnalisation"),
        &[(0b10010, &ENTRY_ENCARNALIZATION_13214089082920950546)],
    ),
    (
        crate::EncodedStr::Ascii("encarnalise"),
        &[(0b10010, &ENTRY_ENCARNALIZE_10850144919400996674)],
    ),
    (
        crate::EncodedStr::Ascii("encarnalised"),
        &[(0b10010, &ENTRY_ENCARNALIZED_13979095018139018531)],
    ),
    (
        crate::EncodedStr::Ascii("encarnalises"),
        &[(0b10010, &ENTRY_ENCARNALIZES_11369013563329530888)],
    ),
    (
        crate::EncodedStr::Ascii("encarnalising"),
        &[(0b10010, &ENTRY_ENCARNALIZING_15767167372584376951)],
    ),
    (
        crate::EncodedStr::Ascii("encarnalization"),
        &[(0b01001, &ENTRY_ENCARNALIZATION_13214089082920950546)],
    ),
    (
        crate::EncodedStr::Ascii("encarnalize"),
        &[(0b01001, &ENTRY_ENCARNALIZE_10850144919400996674)],
    ),
    (
        crate::EncodedStr::Ascii("encarnalized"),
        &[(0b01001, &ENTRY_ENCARNALIZED_13979095018139018531)],
    ),
    (
        crate::EncodedStr::Ascii("encarnalizes"),
        &[(0b01001, &ENTRY_ENCARNALIZES_11369013563329530888)],
    ),
    (
        crate::EncodedStr::Ascii("encarnalizing"),
        &[(0b01001, &ENTRY_ENCARNALIZING_15767167372584376951)],
    ),
    (
        crate::EncodedStr::Ascii("encephalocele"),
        &[(0b00001, &ENTRY_ENCEPHALOCELE_1084758429798248621)],
    ),
    (
        crate::EncodedStr::Ascii("encephalocoele"),
        &[(0b11010, &ENTRY_ENCEPHALOCELE_1084758429798248621)],
    ),
    (
        crate::EncodedStr::Ascii("encolor"),
        &[(0b11001, &ENTRY_ENCOLOR_1492202587953686714)],
    ),
    (
        crate::EncodedStr::Ascii("encolored"),
        &[(0b11001, &ENTRY_ENCOLORED_4939538076917014241)],
    ),
    (
        crate::EncodedStr::Ascii("encoloring"),
        &[(0b11001, &ENTRY_ENCOLORING_4183307079529327993)],
    ),
    (
        crate::EncodedStr::Ascii("encolors"),
        &[(0b11001, &ENTRY_ENCOLORS_8551106713845336956)],
    ),
    (
        crate::EncodedStr::Ascii("encolour"),
        &[(0b11010, &ENTRY_ENCOLOR_1492202587953686714)],
    ),
    (
        crate::EncodedStr::Ascii("encoloured"),
        &[(0b11010, &ENTRY_ENCOLORED_4939538076917014241)],
    ),
    (
        crate::EncodedStr::Ascii("encolouring"),
        &[(0b11010, &ENTRY_ENCOLORING_4183307079529327993)],
    ),
    (
        crate::EncodedStr::Ascii("encolours"),
        &[(0b11010, &ENTRY_ENCOLORS_8551106713845336956)],
    ),
    (
        crate::EncodedStr::Ascii("endameba"),
        &[(0b00001, &ENTRY_ENDAMEBA_3674996897057489972)],
    ),
    (
        crate::EncodedStr::Ascii("endamebae"),
        &[(0b00001, &ENTRY_ENDAMEBAE_7672591039700210017)],
    ),
    (
        crate::EncodedStr::Ascii("endamebas"),
        &[(0b00001, &ENTRY_ENDAMEBAS_3894595978421412160)],
    ),
    (
        crate::EncodedStr::Ascii("endamebiasis"),
        &[(0b00001, &ENTRY_ENDAMEBIASIS_10526584886624559903)],
    ),
    (
        crate::EncodedStr::Ascii("endamebic"),
        &[(0b00001, &ENTRY_ENDAMEBIC_7654343873984680949)],
    ),
    (
        crate::EncodedStr::Ascii("endamoeba"),
        &[(0b11010, &ENTRY_ENDAMEBA_3674996897057489972)],
    ),
    (
        crate::EncodedStr::Ascii("endamoebae"),
        &[(0b11010, &ENTRY_ENDAMEBAE_7672591039700210017)],
    ),
    (
        crate::EncodedStr::Ascii("endamoebas"),
        &[(0b11010, &ENTRY_ENDAMEBAS_3894595978421412160)],
    ),
    (
        crate::EncodedStr::Ascii("endamoebiasis"),
        &[(0b11010, &ENTRY_ENDAMEBIASIS_10526584886624559903)],
    ),
    (
        crate::EncodedStr::Ascii("endamoebic"),
        &[(0b11010, &ENTRY_ENDAMEBIC_7654343873984680949)],
    ),
    (
        crate::EncodedStr::Ascii("endeavor"),
        &[(0b11001, &ENTRY_ENDEAVOR_1861674104846402447)],
    ),
    (
        crate::EncodedStr::Ascii("endeavored"),
        &[(0b11001, &ENTRY_ENDEAVORED_12576902359096148689)],
    ),
    (
        crate::EncodedStr::Ascii("endeavorer"),
        &[(0b11001, &ENTRY_ENDEAVORER_10269034998374810670)],
    ),
    (
        crate::EncodedStr::Ascii("endeavorers"),
        &[(0b11001, &ENTRY_ENDEAVORERS_4264835563429458461)],
    ),
    (
        crate::EncodedStr::Ascii("endeavoring"),
        &[(0b11001, &ENTRY_ENDEAVORING_454178916350601958)],
    ),
    (
        crate::EncodedStr::Ascii("endeavors"),
        &[(0b11001, &ENTRY_ENDEAVORS_5789569016694167960)],
    ),
    (
        crate::EncodedStr::Ascii("endeavour"),
        &[(0b11010, &ENTRY_ENDEAVOR_1861674104846402447)],
    ),
    (
        crate::EncodedStr::Ascii("endeavoured"),
        &[(0b11010, &ENTRY_ENDEAVORED_12576902359096148689)],
    ),
    (
        crate::EncodedStr::Ascii("endeavourer"),
        &[(0b11010, &ENTRY_ENDEAVORER_10269034998374810670)],
    ),
    (
        crate::EncodedStr::Ascii("endeavourers"),
        &[(0b11010, &ENTRY_ENDEAVORERS_4264835563429458461)],
    ),
    (
        crate::EncodedStr::Ascii("endeavouring"),
        &[(0b11010, &ENTRY_ENDEAVORING_454178916350601958)],
    ),
    (
        crate::EncodedStr::Ascii("endeavours"),
        &[(0b11010, &ENTRY_ENDEAVORS_5789569016694167960)],
    ),
    (
        crate::EncodedStr::Ascii("enders"),
        &[(0b00001, &ENTRY_ENDERS_14681940842455541593)],
    ),
    (
        crate::EncodedStr::Ascii("endres"),
        &[(0b11010, &ENTRY_ENDERS_14681940842455541593)],
    ),
    (
        crate::EncodedStr::Ascii("eneid"),
        &[(0b00001, &ENTRY_ENEID_5242893003172218406)],
    ),
    (
        crate::EncodedStr::Ascii("energisation"),
        &[(0b10010, &ENTRY_ENERGIZATION_8281923071042553435)],
    ),
    (
        crate::EncodedStr::Ascii("energise"),
        &[(0b10010, &ENTRY_ENERGIZE_9040021254285160273)],
    ),
    (
        crate::EncodedStr::Ascii("energised"),
        &[(0b10010, &ENTRY_ENERGIZED_10338769724136607063)],
    ),
    (
        crate::EncodedStr::Ascii("energiser"),
        &[(0b10010, &ENTRY_ENERGIZER_449515490537378567)],
    ),
    (
        crate::EncodedStr::Ascii("energisers"),
        &[(0b10010, &ENTRY_ENERGIZERS_10194438715562893992)],
    ),
    (
        crate::EncodedStr::Ascii("energises"),
        &[(0b10010, &ENTRY_ENERGIZES_6958626290038298541)],
    ),
    (
        crate::EncodedStr::Ascii("energising"),
        &[(0b10010, &ENTRY_ENERGIZING_17242100400597322517)],
    ),
    (
        crate::EncodedStr::Ascii("energization"),
        &[(0b01001, &ENTRY_ENERGIZATION_8281923071042553435)],
    ),
    (
        crate::EncodedStr::Ascii("energize"),
        &[(0b01001, &ENTRY_ENERGIZE_9040021254285160273)],
    ),
    (
        crate::EncodedStr::Ascii("energized"),
        &[(0b01001, &ENTRY_ENERGIZED_10338769724136607063)],
    ),
    (
        crate::EncodedStr::Ascii("energizer"),
        &[(0b01001, &ENTRY_ENERGIZER_449515490537378567)],
    ),
    (
        crate::EncodedStr::Ascii("energizers"),
        &[(0b01001, &ENTRY_ENERGIZERS_10194438715562893992)],
    ),
    (
        crate::EncodedStr::Ascii("energizes"),
        &[(0b01001, &ENTRY_ENERGIZES_6958626290038298541)],
    ),
    (
        crate::EncodedStr::Ascii("energizing"),
        &[(0b01001, &ENTRY_ENERGIZING_17242100400597322517)],
    ),
    (
        crate::EncodedStr::Ascii("englishise"),
        &[(0b10010, &ENTRY_ENGLISHIZE_16572744168284665334)],
    ),
    (
        crate::EncodedStr::Ascii("englishises"),
        &[(0b10010, &ENTRY_ENGLISHIZES_18263651365586401449)],
    ),
    (
        crate::EncodedStr::Ascii("englishize"),
        &[(0b01001, &ENTRY_ENGLISHIZE_16572744168284665334)],
    ),
    (
        crate::EncodedStr::Ascii("englishizes"),
        &[(0b01001, &ENTRY_ENGLISHIZES_18263651365586401449)],
    ),
    (
        crate::EncodedStr::Ascii("engrandise"),
        &[(0b10010, &ENTRY_ENGRANDIZE_17642469822387491571)],
    ),
    (
        crate::EncodedStr::Ascii("engrandisement"),
        &[(0b10010, &ENTRY_ENGRANDIZEMENT_6175391937433585069)],
    ),
    (
        crate::EncodedStr::Ascii("engrandisements"),
        &[(0b10010, &ENTRY_ENGRANDIZEMENTS_4909257735302569491)],
    ),
    (
        crate::EncodedStr::Ascii("engrandises"),
        &[(0b10010, &ENTRY_ENGRANDIZES_5787971542005976862)],
    ),
    (
        crate::EncodedStr::Ascii("engrandize"),
        &[(0b01001, &ENTRY_ENGRANDIZE_17642469822387491571)],
    ),
    (
        crate::EncodedStr::Ascii("engrandizement"),
        &[(0b01001, &ENTRY_ENGRANDIZEMENT_6175391937433585069)],
    ),
    (
        crate::EncodedStr::Ascii("engrandizements"),
        &[(0b01001, &ENTRY_ENGRANDIZEMENTS_4909257735302569491)],
    ),
    (
        crate::EncodedStr::Ascii("engrandizes"),
        &[(0b01001, &ENTRY_ENGRANDIZES_5787971542005976862)],
    ),
    (
        crate::EncodedStr::Ascii("enhaemospore"),
        &[(0b11010, &ENTRY_ENHEMOSPORE_15543189487115046896)],
    ),
    (
        crate::EncodedStr::Ascii("enharbor"),
        &[(0b00001, &ENTRY_ENHARBOR_153070629897735018)],
    ),
    (
        crate::EncodedStr::Ascii("enharbour"),
        &[(0b11010, &ENTRY_ENHARBOR_153070629897735018)],
    ),
    (
        crate::EncodedStr::Ascii("enhemospore"),
        &[(0b00001, &ENTRY_ENHEMOSPORE_15543189487115046896)],
    ),
    (
        crate::EncodedStr::Ascii("enhypostatise"),
        &[(0b10010, &ENTRY_ENHYPOSTATIZE_15302074165806361600)],
    ),
    (
        crate::EncodedStr::Ascii("enhypostatised"),
        &[(0b10010, &ENTRY_ENHYPOSTATIZED_1834900422070850325)],
    ),
    (
        crate::EncodedStr::Ascii("enhypostatises"),
        &[(0b10010, &ENTRY_ENHYPOSTATIZES_11790227835392026149)],
    ),
    (
        crate::EncodedStr::Ascii("enhypostatising"),
        &[(0b10010, &ENTRY_ENHYPOSTATIZING_13001414271119905921)],
    ),
    (
        crate::EncodedStr::Ascii("enhypostatize"),
        &[(0b01001, &ENTRY_ENHYPOSTATIZE_15302074165806361600)],
    ),
    (
        crate::EncodedStr::Ascii("enhypostatized"),
        &[(0b01001, &ENTRY_ENHYPOSTATIZED_1834900422070850325)],
    ),
    (
        crate::EncodedStr::Ascii("enhypostatizes"),
        &[(0b01001, &ENTRY_ENHYPOSTATIZES_11790227835392026149)],
    ),
    (
        crate::EncodedStr::Ascii("enhypostatizing"),
        &[(0b01001, &ENTRY_ENHYPOSTATIZING_13001414271119905921)],
    ),
    (
        crate::EncodedStr::Ascii("enigmatise"),
        &[(0b10010, &ENTRY_ENIGMATIZE_10416979299826385433)],
    ),
    (
        crate::EncodedStr::Ascii("enigmatised"),
        &[(0b10010, &ENTRY_ENIGMATIZED_17096479822940125639)],
    ),
    (
        crate::EncodedStr::Ascii("enigmatises"),
        &[(0b10010, &ENTRY_ENIGMATIZES_13870261966778024845)],
    ),
    (
        crate::EncodedStr::Ascii("enigmatising"),
        &[(0b10010, &ENTRY_ENIGMATIZING_7497242872817041134)],
    ),
    (
        crate::EncodedStr::Ascii("enigmatize"),
        &[(0b01001, &ENTRY_ENIGMATIZE_10416979299826385433)],
    ),
    (
        crate::EncodedStr::Ascii("enigmatized"),
        &[(0b01001, &ENTRY_ENIGMATIZED_17096479822940125639)],
    ),
    (
        crate::EncodedStr::Ascii("enigmatizes"),
        &[(0b01001, &ENTRY_ENIGMATIZES_13870261966778024845)],
    ),
    (
        crate::EncodedStr::Ascii("enigmatizing"),
        &[(0b01001, &ENTRY_ENIGMATIZING_7497242872817041134)],
    ),
    (
        crate::EncodedStr::Ascii("enocyte"),
        &[(0b00001, &ENTRY_ENOCYTE_5031071790616444705)],
    ),
    (
        crate::EncodedStr::Ascii("enolic"),
        &[(0b00001, &ENTRY_ENOLIC_8677666364536262517)],
    ),
    (
        crate::EncodedStr::Ascii("enolisation"),
        &[(0b10010, &ENTRY_ENOLIZATION_9705682977867724521)],
    ),
    (
        crate::EncodedStr::Ascii("enolisations"),
        &[(0b10010, &ENTRY_ENOLIZATIONS_15361842836817529123)],
    ),
    (
        crate::EncodedStr::Ascii("enolise"),
        &[(0b10010, &ENTRY_ENOLIZE_5068170608685889108)],
    ),
    (
        crate::EncodedStr::Ascii("enolises"),
        &[(0b10010, &ENTRY_ENOLIZES_16347391140858353185)],
    ),
    (
        crate::EncodedStr::Ascii("enolization"),
        &[(0b01001, &ENTRY_ENOLIZATION_9705682977867724521)],
    ),
    (
        crate::EncodedStr::Ascii("enolizations"),
        &[(0b01001, &ENTRY_ENOLIZATIONS_15361842836817529123)],
    ),
    (
        crate::EncodedStr::Ascii("enolize"),
        &[(0b01001, &ENTRY_ENOLIZE_5068170608685889108)],
    ),
    (
        crate::EncodedStr::Ascii("enolizes"),
        &[(0b01001, &ENTRY_ENOLIZES_16347391140858353185)],
    ),
    (
        crate::EncodedStr::Ascii("enological"),
        &[(0b00001, &ENTRY_ENOLOGICAL_13435934594635959021)],
    ),
    (
        crate::EncodedStr::Ascii("enologist"),
        &[(0b00001, &ENTRY_ENOLOGIST_7144439191139309152)],
    ),
    (
        crate::EncodedStr::Ascii("enologists"),
        &[(0b00001, &ENTRY_ENOLOGISTS_17383228974239236048)],
    ),
    (
        crate::EncodedStr::Ascii("enomania"),
        &[(0b00001, &ENTRY_ENOMANIA_2005674743319272403)],
    ),
    (
        crate::EncodedStr::Ascii("enquire"),
        &[(0b11010, &ENTRY_INQUIRE_13984560274152171356)],
    ),
    (
        crate::EncodedStr::Ascii("enquired"),
        &[(0b11010, &ENTRY_INQUIRED_13488148321304019081)],
    ),
    (
        crate::EncodedStr::Ascii("enquires"),
        &[(0b11010, &ENTRY_INQUIRES_3832461159884672820)],
    ),
    (
        crate::EncodedStr::Ascii("enquiries"),
        &[(0b11010, &ENTRY_INQUIRIES_9592346579573413198)],
    ),
    (
        crate::EncodedStr::Ascii("enquiring"),
        &[(0b11010, &ENTRY_INQUIRING_11670725526763123090)],
    ),
    (
        crate::EncodedStr::Ascii("enquiry"),
        &[(0b11010, &ENTRY_INQUIRY_3419756106654954762)],
    ),
    (
        crate::EncodedStr::Ascii("enrol"),
        &[(0b11010, &ENTRY_ENROLL_1364506938148213622)],
    ),
    (
        crate::EncodedStr::Ascii("enroll"),
        &[(0b11001, &ENTRY_ENROLL_1364506938148213622)],
    ),
    (
        crate::EncodedStr::Ascii("enrollment"),
        &[(0b11001, &ENTRY_ENROLLMENT_11988649571385805864)],
    ),
    (
        crate::EncodedStr::Ascii("enrollments"),
        &[(0b11001, &ENTRY_ENROLLMENTS_9654042434029037164)],
    ),
    (
        crate::EncodedStr::Ascii("enrolls"),
        &[(0b11001, &ENTRY_ENROLLS_13608920793429098761)],
    ),
    (
        crate::EncodedStr::Ascii("enrolment"),
        &[(0b11010, &ENTRY_ENROLLMENT_11988649571385805864)],
    ),
    (
        crate::EncodedStr::Ascii("enrolments"),
        &[(0b11010, &ENTRY_ENROLLMENTS_9654042434029037164)],
    ),
    (
        crate::EncodedStr::Ascii("enrols"),
        &[(0b11010, &ENTRY_ENROLLS_13608920793429098761)],
    ),
    (
        crate::EncodedStr::Ascii("ensepulcher"),
        &[(0b00001, &ENTRY_ENSEPULCHER_18433050111369773849)],
    ),
    (
        crate::EncodedStr::Ascii("ensepulcherred"),
        &[(0b00001, &ENTRY_ENSEPULCHERRED_2215822898020041532)],
    ),
    (
        crate::EncodedStr::Ascii("ensepulcherring"),
        &[(0b00001, &ENTRY_ENSEPULCHERRING_16534463950868972468)],
    ),
    (
        crate::EncodedStr::Ascii("ensepulchers"),
        &[(0b00001, &ENTRY_ENSEPULCHERS_15911081178953815823)],
    ),
    (
        crate::EncodedStr::Ascii("ensepulchre"),
        &[(0b11010, &ENTRY_ENSEPULCHER_18433050111369773849)],
    ),
    (
        crate::EncodedStr::Ascii("ensepulchred"),
        &[(0b11010, &ENTRY_ENSEPULCHERRED_2215822898020041532)],
    ),
    (
        crate::EncodedStr::Ascii("ensepulchres"),
        &[(0b11010, &ENTRY_ENSEPULCHERS_15911081178953815823)],
    ),
    (
        crate::EncodedStr::Ascii("ensepulchring"),
        &[(0b11010, &ENTRY_ENSEPULCHERRING_16534463950868972468)],
    ),
    (
        crate::EncodedStr::Ascii("ensorceled"),
        &[(0b00001, &ENTRY_ENSORCELED_12229416995193303781)],
    ),
    (
        crate::EncodedStr::Ascii("ensorcelled"),
        &[(0b11010, &ENTRY_ENSORCELED_12229416995193303781)],
    ),
    (
        crate::EncodedStr::Ascii("ensorcells"),
        &[(0b11010, &ENTRY_ENSORCELS_14124680308015897322)],
    ),
    (
        crate::EncodedStr::Ascii("ensorcels"),
        &[(0b00001, &ENTRY_ENSORCELS_14124680308015897322)],
    ),
    (
        crate::EncodedStr::Ascii("entameba"),
        &[(0b00001, &ENTRY_ENTAMEBA_11793706106302208785)],
    ),
    (
        crate::EncodedStr::Ascii("entamebae"),
        &[(0b00001, &ENTRY_ENTAMEBAE_2341236739078532290)],
    ),
    (
        crate::EncodedStr::Ascii("entamebas"),
        &[(0b00001, &ENTRY_ENTAMEBAS_2809555012037452245)],
    ),
    (
        crate::EncodedStr::Ascii("entamebic"),
        &[(0b00001, &ENTRY_ENTAMEBIC_8920229737132161042)],
    ),
    (
        crate::EncodedStr::Ascii("entamoeba"),
        &[(0b11010, &ENTRY_ENTAMEBA_11793706106302208785)],
    ),
    (
        crate::EncodedStr::Ascii("entamoebae"),
        &[(0b11010, &ENTRY_ENTAMEBAE_2341236739078532290)],
    ),
    (
        crate::EncodedStr::Ascii("entamoebas"),
        &[(0b11010, &ENTRY_ENTAMEBAS_2809555012037452245)],
    ),
    (
        crate::EncodedStr::Ascii("entamoebic"),
        &[(0b11010, &ENTRY_ENTAMEBIC_8920229737132161042)],
    ),
    (
        crate::EncodedStr::Ascii("entender"),
        &[(0b00001, &ENTRY_ENTENDER_17085849552645364509)],
    ),
    (
        crate::EncodedStr::Ascii("entenders"),
        &[(0b00001, &ENTRY_ENTENDERS_7310937866697087291)],
    ),
    (
        crate::EncodedStr::Ascii("entendre"),
        &[(0b11010, &ENTRY_ENTENDER_17085849552645364509)],
    ),
    (
        crate::EncodedStr::Ascii("entendres"),
        &[(0b11010, &ENTRY_ENTENDERS_7310937866697087291)],
    ),
    (
        crate::EncodedStr::Ascii("enterocele"),
        &[(0b00001, &ENTRY_ENTEROCELE_7421588424099714866)],
    ),
    (
        crate::EncodedStr::Ascii("enteroceles"),
        &[(0b00001, &ENTRY_ENTEROCELES_5370389164173622202)],
    ),
    (
        crate::EncodedStr::Ascii("enterocoele"),
        &[(0b11010, &ENTRY_ENTEROCELE_7421588424099714866)],
    ),
    (
        crate::EncodedStr::Ascii("enterocoeles"),
        &[(0b11010, &ENTRY_ENTEROCELES_5370389164173622202)],
    ),
    (
        crate::EncodedStr::Ascii("enthral"),
        &[
            (0b11010, &ENTRY_ENTHRALL_10463703031933500557),
            (0b11010, &ENTRY_ENTHRALL_16443508848218743746),
        ],
    ),
    (
        crate::EncodedStr::Ascii("enthrall"),
        &[
            (0b01001, &ENTRY_ENTHRALL_10463703031933500557),
            (0b01001, &ENTRY_ENTHRALL_16443508848218743746),
        ],
    ),
    (
        crate::EncodedStr::Ascii("enthrallment"),
        &[(0b01001, &ENTRY_ENTHRALLMENT_17889486799769196724)],
    ),
    (
        crate::EncodedStr::Ascii("enthrallments"),
        &[(0b01001, &ENTRY_ENTHRALLMENTS_16482738497663374563)],
    ),
    (
        crate::EncodedStr::Ascii("enthralls"),
        &[
            (0b01001, &ENTRY_ENTHRALLS_4618745032526572838),
            (0b01001, &ENTRY_ENTHRALLS_6896071459165900179),
        ],
    ),
    (
        crate::EncodedStr::Ascii("enthralment"),
        &[(0b11010, &ENTRY_ENTHRALLMENT_17889486799769196724)],
    ),
    (
        crate::EncodedStr::Ascii("enthralments"),
        &[(0b11010, &ENTRY_ENTHRALLMENTS_16482738497663374563)],
    ),
    (
        crate::EncodedStr::Ascii("enthrals"),
        &[
            (0b11010, &ENTRY_ENTHRALLS_4618745032526572838),
            (0b11010, &ENTRY_ENTHRALLS_6896071459165900179),
        ],
    ),
    (
        crate::EncodedStr::Ascii("enthronisation"),
        &[(0b10010, &ENTRY_ENTHRONIZATION_6974028193403231299)],
    ),
    (
        crate::EncodedStr::Ascii("enthronisations"),
        &[(0b10010, &ENTRY_ENTHRONIZATIONS_17542858977423549781)],
    ),
    (
        crate::EncodedStr::Ascii("enthronise"),
        &[(0b10010, &ENTRY_ENTHRONIZE_8479472121396981406)],
    ),
    (
        crate::EncodedStr::Ascii("enthronised"),
        &[(0b10010, &ENTRY_ENTHRONIZED_15570973078812509329)],
    ),
    (
        crate::EncodedStr::Ascii("enthronises"),
        &[(0b10010, &ENTRY_ENTHRONIZES_6728807480218746557)],
    ),
    (
        crate::EncodedStr::Ascii("enthronising"),
        &[(0b10010, &ENTRY_ENTHRONIZING_5022467519558443336)],
    ),
    (
        crate::EncodedStr::Ascii("enthronization"),
        &[(0b01001, &ENTRY_ENTHRONIZATION_6974028193403231299)],
    ),
    (
        crate::EncodedStr::Ascii("enthronizations"),
        &[(0b01001, &ENTRY_ENTHRONIZATIONS_17542858977423549781)],
    ),
    (
        crate::EncodedStr::Ascii("enthronize"),
        &[(0b01001, &ENTRY_ENTHRONIZE_8479472121396981406)],
    ),
    (
        crate::EncodedStr::Ascii("enthronized"),
        &[(0b01001, &ENTRY_ENTHRONIZED_15570973078812509329)],
    ),
    (
        crate::EncodedStr::Ascii("enthronizes"),
        &[(0b01001, &ENTRY_ENTHRONIZES_6728807480218746557)],
    ),
    (
        crate::EncodedStr::Ascii("enthronizing"),
        &[(0b01001, &ENTRY_ENTHRONIZING_5022467519558443336)],
    ),
    (
        crate::EncodedStr::Ascii("entocele"),
        &[(0b00001, &ENTRY_ENTOCELE_16862864757875933672)],
    ),
    (
        crate::EncodedStr::Ascii("entocoele"),
        &[(0b11010, &ENTRY_ENTOCELE_16862864757875933672)],
    ),
    (
        crate::EncodedStr::Ascii("entomologise"),
        &[(0b10010, &ENTRY_ENTOMOLOGIZE_12930471317891860313)],
    ),
    (
        crate::EncodedStr::Ascii("entomologised"),
        &[(0b10010, &ENTRY_ENTOMOLOGIZED_17180055652025722891)],
    ),
    (
        crate::EncodedStr::Ascii("entomologises"),
        &[(0b10010, &ENTRY_ENTOMOLOGIZES_14741971157180428511)],
    ),
    (
        crate::EncodedStr::Ascii("entomologising"),
        &[(0b10010, &ENTRY_ENTOMOLOGIZING_541087590579894951)],
    ),
    (
        crate::EncodedStr::Ascii("entomologize"),
        &[(0b01001, &ENTRY_ENTOMOLOGIZE_12930471317891860313)],
    ),
    (
        crate::EncodedStr::Ascii("entomologized"),
        &[(0b01001, &ENTRY_ENTOMOLOGIZED_17180055652025722891)],
    ),
    (
        crate::EncodedStr::Ascii("entomologizes"),
        &[(0b01001, &ENTRY_ENTOMOLOGIZES_14741971157180428511)],
    ),
    (
        crate::EncodedStr::Ascii("entomologizing"),
        &[(0b01001, &ENTRY_ENTOMOLOGIZING_541087590579894951)],
    ),
    (
        crate::EncodedStr::Ascii("entrae"),
        &[(0b11010, &ENTRY_ENTRE_13397912193554137949)],
    ),
    (
        crate::EncodedStr::Ascii("entre"),
        &[(0b00001, &ENTRY_ENTRE_13397912193554137949)],
    ),
    (
        crate::EncodedStr::Ascii("envapor"),
        &[(0b10001, &ENTRY_ENVAPOR_3613458891591634750)],
    ),
    (
        crate::EncodedStr::Ascii("envapors"),
        &[(0b10001, &ENTRY_ENVAPORS_5110885845552232253)],
    ),
    (
        crate::EncodedStr::Ascii("envapour"),
        &[(0b11010, &ENTRY_ENVAPOR_3613458891591634750)],
    ),
    (
        crate::EncodedStr::Ascii("envapours"),
        &[(0b11010, &ENTRY_ENVAPORS_5110885845552232253)],
    ),
    (
        crate::EncodedStr::Ascii("envenomisation"),
        &[(0b10010, &ENTRY_ENVENOMIZATION_641743467429707201)],
    ),
    (
        crate::EncodedStr::Ascii("envenomization"),
        &[(0b01001, &ENTRY_ENVENOMIZATION_641743467429707201)],
    ),
    (
        crate::EncodedStr::Ascii("eolic"),
        &[(0b00001, &ENTRY_EOLIC_690118974702284625)],
    ),
    (
        crate::EncodedStr::Ascii("eolipile"),
        &[(0b00001, &ENTRY_EOLIPILE_11849651097249565492)],
    ),
    (
        crate::EncodedStr::Ascii("eolipiles"),
        &[(0b00001, &ENTRY_EOLIPILES_6469066293612545970)],
    ),
    (
        crate::EncodedStr::Ascii("eolotropic"),
        &[(0b00001, &ENTRY_EOLOTROPIC_9928061474103766564)],
    ),
    (
        crate::EncodedStr::Ascii("eonian"),
        &[(0b00001, &ENTRY_EONIAN_2585817843108266796)],
    ),
    (
        crate::EncodedStr::Ascii("eonism"),
        &[(0b00001, &ENTRY_EONISM_12314541365765950888)],
    ),
    (
        crate::EncodedStr::Ascii("eonisms"),
        &[(0b00001, &ENTRY_EONISMS_13022437471464751142)],
    ),
    (
        crate::EncodedStr::Ascii("eopalaeozoic"),
        &[(0b11010, &ENTRY_EOPALEOZOIC_13858730559448370168)],
    ),
    (
        crate::EncodedStr::Ascii("eopaleozoic"),
        &[(0b00001, &ENTRY_EOPALEOZOIC_13858730559448370168)],
    ),
    (
        crate::EncodedStr::Ascii("epaenetic"),
        &[(0b11010, &ENTRY_EPENETIC_4078091931289223174)],
    ),
    (
        crate::EncodedStr::Ascii("epaulet"),
        &[(0b01001, &ENTRY_EPAULET_387424623527969944)],
    ),
    (
        crate::EncodedStr::Ascii("epaulets"),
        &[(0b01001, &ENTRY_EPAULETS_16015840258717142271)],
    ),
    (
        crate::EncodedStr::Ascii("epenetic"),
        &[(0b00001, &ENTRY_EPENETIC_4078091931289223174)],
    ),
    (
        crate::EncodedStr::Ascii("ephetae"),
        &[(0b11010, &ENTRY_EPHETE_2596523211716991798)],
    ),
    (
        crate::EncodedStr::Ascii("ephete"),
        &[(0b00001, &ENTRY_EPHETE_2596523211716991798)],
    ),
    (
        crate::EncodedStr::Ascii("epicele"),
        &[(0b00001, &ENTRY_EPICELE_12455055708908810351)],
    ),
    (
        crate::EncodedStr::Ascii("epicenter"),
        &[(0b00001, &ENTRY_EPICENTER_16342724518099488548)],
    ),
    (
        crate::EncodedStr::Ascii("epicenters"),
        &[(0b00001, &ENTRY_EPICENTERS_13863528771268891291)],
    ),
    (
        crate::EncodedStr::Ascii("epicentre"),
        &[(0b11010, &ENTRY_EPICENTER_16342724518099488548)],
    ),
    (
        crate::EncodedStr::Ascii("epicentres"),
        &[(0b11010, &ENTRY_EPICENTERS_13863528771268891291)],
    ),
    (
        crate::EncodedStr::Ascii("epicoele"),
        &[(0b11010, &ENTRY_EPICELE_12455055708908810351)],
    ),
    (
        crate::EncodedStr::Ascii("epicurise"),
        &[(0b10010, &ENTRY_EPICURIZE_9792021232282849861)],
    ),
    (
        crate::EncodedStr::Ascii("epicurised"),
        &[(0b10010, &ENTRY_EPICURIZED_8210844038944440883)],
    ),
    (
        crate::EncodedStr::Ascii("epicurises"),
        &[(0b10010, &ENTRY_EPICURIZES_604659561636523665)],
    ),
    (
        crate::EncodedStr::Ascii("epicurising"),
        &[(0b10010, &ENTRY_EPICURIZING_15655666870475102269)],
    ),
    (
        crate::EncodedStr::Ascii("epicurize"),
        &[(0b01001, &ENTRY_EPICURIZE_9792021232282849861)],
    ),
    (
        crate::EncodedStr::Ascii("epicurized"),
        &[(0b01001, &ENTRY_EPICURIZED_8210844038944440883)],
    ),
    (
        crate::EncodedStr::Ascii("epicurizes"),
        &[(0b01001, &ENTRY_EPICURIZES_604659561636523665)],
    ),
    (
        crate::EncodedStr::Ascii("epicurizing"),
        &[(0b01001, &ENTRY_EPICURIZING_15655666870475102269)],
    ),
    (
        crate::EncodedStr::Ascii("epidotisation"),
        &[(0b10010, &ENTRY_EPIDOTIZATION_14022545118965805510)],
    ),
    (
        crate::EncodedStr::Ascii("epidotisations"),
        &[(0b10010, &ENTRY_EPIDOTIZATIONS_17986813465862906948)],
    ),
    (
        crate::EncodedStr::Ascii("epidotised"),
        &[(0b10010, &ENTRY_EPIDOTIZED_18043278384935210029)],
    ),
    (
        crate::EncodedStr::Ascii("epidotization"),
        &[(0b01001, &ENTRY_EPIDOTIZATION_14022545118965805510)],
    ),
    (
        crate::EncodedStr::Ascii("epidotizations"),
        &[(0b01001, &ENTRY_EPIDOTIZATIONS_17986813465862906948)],
    ),
    (
        crate::EncodedStr::Ascii("epidotized"),
        &[(0b01001, &ENTRY_EPIDOTIZED_18043278384935210029)],
    ),
    (
        crate::EncodedStr::Ascii("epigaeal"),
        &[(0b11010, &ENTRY_EPIGEAL_9418200985174229088)],
    ),
    (
        crate::EncodedStr::Ascii("epigaean"),
        &[(0b11010, &ENTRY_EPIGEAN_1067479460708884657)],
    ),
    (
        crate::EncodedStr::Ascii("epigaeous"),
        &[(0b11010, &ENTRY_EPIGEOUS_2793155818327732975)],
    ),
    (
        crate::EncodedStr::Ascii("epigeal"),
        &[(0b00001, &ENTRY_EPIGEAL_9418200985174229088)],
    ),
    (
        crate::EncodedStr::Ascii("epigean"),
        &[(0b00001, &ENTRY_EPIGEAN_1067479460708884657)],
    ),
    (
        crate::EncodedStr::Ascii("epigeous"),
        &[(0b00001, &ENTRY_EPIGEOUS_2793155818327732975)],
    ),
    (
        crate::EncodedStr::Ascii("epigrammatisation"),
        &[(0b10010, &ENTRY_EPIGRAMMATIZATION_3435997769901871314)],
    ),
    (
        crate::EncodedStr::Ascii("epigrammatise"),
        &[(0b10010, &ENTRY_EPIGRAMMATIZE_13553329783728837308)],
    ),
    (
        crate::EncodedStr::Ascii("epigrammatised"),
        &[(0b10010, &ENTRY_EPIGRAMMATIZED_3366561652151146715)],
    ),
    (
        crate::EncodedStr::Ascii("epigrammatiser"),
        &[(0b10010, &ENTRY_EPIGRAMMATIZER_202382434686912143)],
    ),
    (
        crate::EncodedStr::Ascii("epigrammatises"),
        &[(0b10010, &ENTRY_EPIGRAMMATIZES_9870871179457908060)],
    ),
    (
        crate::EncodedStr::Ascii("epigrammatising"),
        &[(0b10010, &ENTRY_EPIGRAMMATIZING_9925592242854198273)],
    ),
    (
        crate::EncodedStr::Ascii("epigrammatization"),
        &[(0b01001, &ENTRY_EPIGRAMMATIZATION_3435997769901871314)],
    ),
    (
        crate::EncodedStr::Ascii("epigrammatize"),
        &[(0b01001, &ENTRY_EPIGRAMMATIZE_13553329783728837308)],
    ),
    (
        crate::EncodedStr::Ascii("epigrammatized"),
        &[(0b01001, &ENTRY_EPIGRAMMATIZED_3366561652151146715)],
    ),
    (
        crate::EncodedStr::Ascii("epigrammatizer"),
        &[(0b01001, &ENTRY_EPIGRAMMATIZER_202382434686912143)],
    ),
    (
        crate::EncodedStr::Ascii("epigrammatizes"),
        &[(0b01001, &ENTRY_EPIGRAMMATIZES_9870871179457908060)],
    ),
    (
        crate::EncodedStr::Ascii("epigrammatizing"),
        &[(0b01001, &ENTRY_EPIGRAMMATIZING_9925592242854198273)],
    ),
    (
        crate::EncodedStr::Ascii("epilog"),
        &[(0b00001, &ENTRY_EPILOGUE_10590439015464966835)],
    ),
    (
        crate::EncodedStr::Ascii("epilogise"),
        &[(0b10010, &ENTRY_EPILOGIZE_5104820820812023953)],
    ),
    (
        crate::EncodedStr::Ascii("epilogised"),
        &[(0b10010, &ENTRY_EPILOGIZED_13747207713324695603)],
    ),
    (
        crate::EncodedStr::Ascii("epilogises"),
        &[(0b10010, &ENTRY_EPILOGIZES_6060812301091580461)],
    ),
    (
        crate::EncodedStr::Ascii("epilogising"),
        &[(0b10010, &ENTRY_EPILOGIZING_16045388830092914645)],
    ),
    (
        crate::EncodedStr::Ascii("epilogize"),
        &[(0b01001, &ENTRY_EPILOGIZE_5104820820812023953)],
    ),
    (
        crate::EncodedStr::Ascii("epilogized"),
        &[(0b01001, &ENTRY_EPILOGIZED_13747207713324695603)],
    ),
    (
        crate::EncodedStr::Ascii("epilogizes"),
        &[(0b01001, &ENTRY_EPILOGIZES_6060812301091580461)],
    ),
    (
        crate::EncodedStr::Ascii("epilogizing"),
        &[(0b01001, &ENTRY_EPILOGIZING_16045388830092914645)],
    ),
    (
        crate::EncodedStr::Ascii("epilogs"),
        &[(0b00001, &ENTRY_EPILOGUES_1045687645770537326)],
    ),
    (
        crate::EncodedStr::Ascii("epiloguise"),
        &[(0b10010, &ENTRY_EPILOGUIZE_689201102200555729)],
    ),
    (
        crate::EncodedStr::Ascii("epiloguised"),
        &[(0b10010, &ENTRY_EPILOGUIZED_12441365755453529023)],
    ),
    (
        crate::EncodedStr::Ascii("epiloguises"),
        &[(0b10010, &ENTRY_EPILOGUIZES_2292690148409428255)],
    ),
    (
        crate::EncodedStr::Ascii("epiloguising"),
        &[(0b10010, &ENTRY_EPILOGUIZING_8986609211873957773)],
    ),
    (
        crate::EncodedStr::Ascii("epiloguize"),
        &[(0b01001, &ENTRY_EPILOGUIZE_689201102200555729)],
    ),
    (
        crate::EncodedStr::Ascii("epiloguized"),
        &[(0b01001, &ENTRY_EPILOGUIZED_12441365755453529023)],
    ),
    (
        crate::EncodedStr::Ascii("epiloguizes"),
        &[(0b01001, &ENTRY_EPILOGUIZES_2292690148409428255)],
    ),
    (
        crate::EncodedStr::Ascii("epiloguizing"),
        &[(0b01001, &ENTRY_EPILOGUIZING_8986609211873957773)],
    ),
    (
        crate::EncodedStr::Ascii("epimerise"),
        &[(0b10010, &ENTRY_EPIMERIZE_823465573203429173)],
    ),
    (
        crate::EncodedStr::Ascii("epimerised"),
        &[(0b10010, &ENTRY_EPIMERIZED_14134076359123551022)],
    ),
    (
        crate::EncodedStr::Ascii("epimerising"),
        &[(0b10010, &ENTRY_EPIMERIZING_11872554676821586844)],
    ),
    (
        crate::EncodedStr::Ascii("epimerize"),
        &[(0b01001, &ENTRY_EPIMERIZE_823465573203429173)],
    ),
    (
        crate::EncodedStr::Ascii("epimerized"),
        &[(0b01001, &ENTRY_EPIMERIZED_14134076359123551022)],
    ),
    (
        crate::EncodedStr::Ascii("epimerizing"),
        &[(0b01001, &ENTRY_EPIMERIZING_11872554676821586844)],
    ),
    (
        crate::EncodedStr::Ascii("epiphanise"),
        &[(0b10010, &ENTRY_EPIPHANIZE_3444458754608259700)],
    ),
    (
        crate::EncodedStr::Ascii("epiphanised"),
        &[(0b10010, &ENTRY_EPIPHANIZED_9129723971945803343)],
    ),
    (
        crate::EncodedStr::Ascii("epiphanising"),
        &[(0b10010, &ENTRY_EPIPHANIZING_5611514449736046211)],
    ),
    (
        crate::EncodedStr::Ascii("epiphanize"),
        &[(0b01001, &ENTRY_EPIPHANIZE_3444458754608259700)],
    ),
    (
        crate::EncodedStr::Ascii("epiphanized"),
        &[(0b01001, &ENTRY_EPIPHANIZED_9129723971945803343)],
    ),
    (
        crate::EncodedStr::Ascii("epiphanizing"),
        &[(0b01001, &ENTRY_EPIPHANIZING_5611514449736046211)],
    ),
    (
        crate::EncodedStr::Ascii("episcopalianise"),
        &[(0b10010, &ENTRY_EPISCOPALIANIZE_13601906048877534433)],
    ),
    (
        crate::EncodedStr::Ascii("episcopalianises"),
        &[(0b10010, &ENTRY_EPISCOPALIANIZES_14297906488956283731)],
    ),
    (
        crate::EncodedStr::Ascii("episcopalianize"),
        &[(0b01001, &ENTRY_EPISCOPALIANIZE_13601906048877534433)],
    ),
    (
        crate::EncodedStr::Ascii("episcopalianizes"),
        &[(0b01001, &ENTRY_EPISCOPALIANIZES_14297906488956283731)],
    ),
    (
        crate::EncodedStr::Ascii("episcopise"),
        &[(0b10010, &ENTRY_EPISCOPIZE_5941157562787933973)],
    ),
    (
        crate::EncodedStr::Ascii("episcopised"),
        &[(0b10010, &ENTRY_EPISCOPIZED_16650182802365832304)],
    ),
    (
        crate::EncodedStr::Ascii("episcopises"),
        &[(0b10010, &ENTRY_EPISCOPIZES_9627859512937099394)],
    ),
    (
        crate::EncodedStr::Ascii("episcopising"),
        &[(0b10010, &ENTRY_EPISCOPIZING_17988499911565815852)],
    ),
    (
        crate::EncodedStr::Ascii("episcopize"),
        &[(0b01001, &ENTRY_EPISCOPIZE_5941157562787933973)],
    ),
    (
        crate::EncodedStr::Ascii("episcopized"),
        &[(0b01001, &ENTRY_EPISCOPIZED_16650182802365832304)],
    ),
    (
        crate::EncodedStr::Ascii("episcopizes"),
        &[(0b01001, &ENTRY_EPISCOPIZES_9627859512937099394)],
    ),
    (
        crate::EncodedStr::Ascii("episcopizing"),
        &[(0b01001, &ENTRY_EPISCOPIZING_17988499911565815852)],
    ),
    (
        crate::EncodedStr::Ascii("epistolise"),
        &[(0b10010, &ENTRY_EPISTOLIZE_12798380956553546634)],
    ),
    (
        crate::EncodedStr::Ascii("epistolised"),
        &[(0b10010, &ENTRY_EPISTOLIZED_2534518570318818508)],
    ),
    (
        crate::EncodedStr::Ascii("epistolises"),
        &[(0b10010, &ENTRY_EPISTOLIZES_12529001542994955479)],
    ),
    (
        crate::EncodedStr::Ascii("epistolising"),
        &[(0b10010, &ENTRY_EPISTOLIZING_12184368088240887297)],
    ),
    (
        crate::EncodedStr::Ascii("epistolize"),
        &[(0b01001, &ENTRY_EPISTOLIZE_12798380956553546634)],
    ),
    (
        crate::EncodedStr::Ascii("epistolized"),
        &[(0b01001, &ENTRY_EPISTOLIZED_2534518570318818508)],
    ),
    (
        crate::EncodedStr::Ascii("epistolizes"),
        &[(0b01001, &ENTRY_EPISTOLIZES_12529001542994955479)],
    ),
    (
        crate::EncodedStr::Ascii("epistolizing"),
        &[(0b01001, &ENTRY_EPISTOLIZING_12184368088240887297)],
    ),
    (
        crate::EncodedStr::Ascii("epitaphise"),
        &[(0b10010, &ENTRY_EPITAPHIZE_13795478585860811984)],
    ),
    (
        crate::EncodedStr::Ascii("epitaphises"),
        &[(0b10010, &ENTRY_EPITAPHIZES_162759418609625372)],
    ),
    (
        crate::EncodedStr::Ascii("epitaphize"),
        &[(0b01001, &ENTRY_EPITAPHIZE_13795478585860811984)],
    ),
    (
        crate::EncodedStr::Ascii("epitaphizes"),
        &[(0b01001, &ENTRY_EPITAPHIZES_162759418609625372)],
    ),
    (
        crate::EncodedStr::Ascii("epithetise"),
        &[(0b10010, &ENTRY_EPITHETIZE_14011874895566642629)],
    ),
    (
        crate::EncodedStr::Ascii("epithetises"),
        &[(0b10010, &ENTRY_EPITHETIZES_12815056524749670860)],
    ),
    (
        crate::EncodedStr::Ascii("epithetize"),
        &[(0b01001, &ENTRY_EPITHETIZE_14011874895566642629)],
    ),
    (
        crate::EncodedStr::Ascii("epithetizes"),
        &[(0b01001, &ENTRY_EPITHETIZES_12815056524749670860)],
    ),
    (
        crate::EncodedStr::Ascii("epitomisation"),
        &[(0b10010, &ENTRY_EPITOMIZATION_16124019439482652962)],
    ),
    (
        crate::EncodedStr::Ascii("epitomisations"),
        &[(0b10010, &ENTRY_EPITOMIZATIONS_16374827024040589670)],
    ),
    (
        crate::EncodedStr::Ascii("epitomise"),
        &[(0b10010, &ENTRY_EPITOMIZE_13528530811124562195)],
    ),
    (
        crate::EncodedStr::Ascii("epitomised"),
        &[(0b10010, &ENTRY_EPITOMIZED_5424880168543124583)],
    ),
    (
        crate::EncodedStr::Ascii("epitomiser"),
        &[(0b10010, &ENTRY_EPITOMIZER_8562118215235688018)],
    ),
    (
        crate::EncodedStr::Ascii("epitomisers"),
        &[(0b10010, &ENTRY_EPITOMIZERS_4593373083947475967)],
    ),
    (
        crate::EncodedStr::Ascii("epitomises"),
        &[(0b10010, &ENTRY_EPITOMIZES_10955147197853926635)],
    ),
    (
        crate::EncodedStr::Ascii("epitomising"),
        &[(0b10010, &ENTRY_EPITOMIZING_9913028102891579136)],
    ),
    (
        crate::EncodedStr::Ascii("epitomization"),
        &[(0b01001, &ENTRY_EPITOMIZATION_16124019439482652962)],
    ),
    (
        crate::EncodedStr::Ascii("epitomizations"),
        &[(0b01001, &ENTRY_EPITOMIZATIONS_16374827024040589670)],
    ),
    (
        crate::EncodedStr::Ascii("epitomize"),
        &[(0b01001, &ENTRY_EPITOMIZE_13528530811124562195)],
    ),
    (
        crate::EncodedStr::Ascii("epitomized"),
        &[(0b01001, &ENTRY_EPITOMIZED_5424880168543124583)],
    ),
    (
        crate::EncodedStr::Ascii("epitomizer"),
        &[(0b01001, &ENTRY_EPITOMIZER_8562118215235688018)],
    ),
    (
        crate::EncodedStr::Ascii("epitomizers"),
        &[(0b01001, &ENTRY_EPITOMIZERS_4593373083947475967)],
    ),
    (
        crate::EncodedStr::Ascii("epitomizes"),
        &[(0b01001, &ENTRY_EPITOMIZES_10955147197853926635)],
    ),
    (
        crate::EncodedStr::Ascii("epitomizing"),
        &[(0b01001, &ENTRY_EPITOMIZING_9913028102891579136)],
    ),
    (
        crate::EncodedStr::Ascii("eq"),
        &[(0b00001, &ENTRY_EQ_17801056412005353118)],
    ),
    (
        crate::EncodedStr::Ascii("equaled"),
        &[(0b00001, &ENTRY_EQUALED_8356361230889842625)],
    ),
    (
        crate::EncodedStr::Ascii("equaling"),
        &[(0b00001, &ENTRY_EQUALING_76827185743864845)],
    ),
    (
        crate::EncodedStr::Ascii("equalisation"),
        &[(0b10010, &ENTRY_EQUALIZATION_417591381258528869)],
    ),
    (
        crate::EncodedStr::Ascii("equalisations"),
        &[(0b10010, &ENTRY_EQUALIZATIONS_682915140211915244)],
    ),
    (
        crate::EncodedStr::Ascii("equalise"),
        &[(0b10010, &ENTRY_EQUALIZE_6433971949536645353)],
    ),
    (
        crate::EncodedStr::Ascii("equalised"),
        &[(0b10010, &ENTRY_EQUALIZED_5400608554561448474)],
    ),
    (
        crate::EncodedStr::Ascii("equaliser"),
        &[(0b10010, &ENTRY_EQUALIZER_2855584392309830652)],
    ),
    (
        crate::EncodedStr::Ascii("equalisers"),
        &[(0b10010, &ENTRY_EQUALIZERS_11614687339668491001)],
    ),
    (
        crate::EncodedStr::Ascii("equalises"),
        &[(0b10010, &ENTRY_EQUALIZES_1676516165012158279)],
    ),
    (
        crate::EncodedStr::Ascii("equalising"),
        &[(0b10010, &ENTRY_EQUALIZING_14679492934035290518)],
    ),
    (
        crate::EncodedStr::Ascii("equalisings"),
        &[(0b10010, &ENTRY_EQUALIZINGS_10284543548419639437)],
    ),
    (
        crate::EncodedStr::Ascii("equalization"),
        &[(0b01001, &ENTRY_EQUALIZATION_417591381258528869)],
    ),
    (
        crate::EncodedStr::Ascii("equalizations"),
        &[(0b01001, &ENTRY_EQUALIZATIONS_682915140211915244)],
    ),
    (
        crate::EncodedStr::Ascii("equalize"),
        &[(0b01001, &ENTRY_EQUALIZE_6433971949536645353)],
    ),
    (
        crate::EncodedStr::Ascii("equalized"),
        &[(0b01001, &ENTRY_EQUALIZED_5400608554561448474)],
    ),
    (
        crate::EncodedStr::Ascii("equalizer"),
        &[(0b01001, &ENTRY_EQUALIZER_2855584392309830652)],
    ),
    (
        crate::EncodedStr::Ascii("equalizers"),
        &[(0b01001, &ENTRY_EQUALIZERS_11614687339668491001)],
    ),
    (
        crate::EncodedStr::Ascii("equalizes"),
        &[(0b01001, &ENTRY_EQUALIZES_1676516165012158279)],
    ),
    (
        crate::EncodedStr::Ascii("equalizing"),
        &[(0b01001, &ENTRY_EQUALIZING_14679492934035290518)],
    ),
    (
        crate::EncodedStr::Ascii("equalizings"),
        &[(0b01001, &ENTRY_EQUALIZINGS_10284543548419639437)],
    ),
    (
        crate::EncodedStr::Ascii("equalled"),
        &[(0b11010, &ENTRY_EQUALED_8356361230889842625)],
    ),
    (
        crate::EncodedStr::Ascii("equalling"),
        &[(0b11010, &ENTRY_EQUALING_76827185743864845)],
    ),
    (
        crate::EncodedStr::Ascii("equestrianise"),
        &[(0b10010, &ENTRY_EQUESTRIANIZE_13136044868803266911)],
    ),
    (
        crate::EncodedStr::Ascii("equestrianises"),
        &[(0b10010, &ENTRY_EQUESTRIANIZES_3846608224700022412)],
    ),
    (
        crate::EncodedStr::Ascii("equestrianize"),
        &[(0b01001, &ENTRY_EQUESTRIANIZE_13136044868803266911)],
    ),
    (
        crate::EncodedStr::Ascii("equestrianizes"),
        &[(0b01001, &ENTRY_EQUESTRIANIZES_3846608224700022412)],
    ),
    (
        crate::EncodedStr::Ascii("erbia"),
        &[(0b00001, &ENTRY_ERBIA_3590263034241709068)],
    ),
    (
        crate::EncodedStr::Ascii("erbias"),
        &[(0b00001, &ENTRY_ERBIAS_7628332259520876430)],
    ),
    (
        crate::EncodedStr::Ascii("ergotise"),
        &[(0b10010, &ENTRY_ERGOTIZE_2413804013154734092)],
    ),
    (
        crate::EncodedStr::Ascii("ergotised"),
        &[(0b10010, &ENTRY_ERGOTIZED_8120537335211967484)],
    ),
    (
        crate::EncodedStr::Ascii("ergotises"),
        &[(0b10010, &ENTRY_ERGOTIZES_2875829986652402100)],
    ),
    (
        crate::EncodedStr::Ascii("ergotising"),
        &[(0b10010, &ENTRY_ERGOTIZING_3389078505132496781)],
    ),
    (
        crate::EncodedStr::Ascii("ergotize"),
        &[(0b01001, &ENTRY_ERGOTIZE_2413804013154734092)],
    ),
    (
        crate::EncodedStr::Ascii("ergotized"),
        &[(0b01001, &ENTRY_ERGOTIZED_8120537335211967484)],
    ),
    (
        crate::EncodedStr::Ascii("ergotizes"),
        &[(0b01001, &ENTRY_ERGOTIZES_2875829986652402100)],
    ),
    (
        crate::EncodedStr::Ascii("ergotizing"),
        &[(0b01001, &ENTRY_ERGOTIZING_3389078505132496781)],
    ),
    (
        crate::EncodedStr::Ascii("eric"),
        &[(0b00001, &ENTRY_ERIC_7184163800386574200)],
    ),
    (
        crate::EncodedStr::Ascii("erical"),
        &[(0b00001, &ENTRY_ERICAL_12478419361229949219)],
    ),
    (
        crate::EncodedStr::Ascii("erke"),
        &[(0b00001, &ENTRY_ERKE_6039553976467525040)],
    ),
    (
        crate::EncodedStr::Ascii("ern"),
        &[(0b00001, &ENTRY_ERN_10092184086657301009)],
    ),
    (
        crate::EncodedStr::Ascii("ernes"),
        &[(0b00001, &ENTRY_ERNES_16282144925287112174)],
    ),
    (
        crate::EncodedStr::Ascii("ernest"),
        &[(0b00001, &ENTRY_ERNEST_2869565578515229588)],
    ),
    (
        crate::EncodedStr::Ascii("erns"),
        &[(0b00001, &ENTRY_ERNS_11958672731540988082)],
    ),
    (
        crate::EncodedStr::Ascii("erogenesis"),
        &[(0b00001, &ENTRY_EROGENESIS_4465855575040947833)],
    ),
    (
        crate::EncodedStr::Ascii("erogenic"),
        &[(0b00001, &ENTRY_EROGENIC_3058184513432824304)],
    ),
    (
        crate::EncodedStr::Ascii("eros"),
        &[(0b00001, &ENTRY_EROS_265509765297093167)],
    ),
    (
        crate::EncodedStr::Ascii("erose"),
        &[(0b00001, &ENTRY_EROSE_5357559857770402424)],
    ),
    (
        crate::EncodedStr::Ascii("eroticisation"),
        &[(0b10010, &ENTRY_EROTICIZATION_2630432213360033255)],
    ),
    (
        crate::EncodedStr::Ascii("eroticise"),
        &[(0b10010, &ENTRY_EROTICIZE_10103435938228728741)],
    ),
    (
        crate::EncodedStr::Ascii("eroticised"),
        &[(0b10010, &ENTRY_EROTICIZED_13157811206734809042)],
    ),
    (
        crate::EncodedStr::Ascii("eroticises"),
        &[(0b10010, &ENTRY_EROTICIZES_4798707540088705022)],
    ),
    (
        crate::EncodedStr::Ascii("eroticising"),
        &[(0b10010, &ENTRY_EROTICIZING_7294701366490544040)],
    ),
    (
        crate::EncodedStr::Ascii("eroticization"),
        &[(0b01001, &ENTRY_EROTICIZATION_2630432213360033255)],
    ),
    (
        crate::EncodedStr::Ascii("eroticize"),
        &[(0b01001, &ENTRY_EROTICIZE_10103435938228728741)],
    ),
    (
        crate::EncodedStr::Ascii("eroticized"),
        &[(0b01001, &ENTRY_EROTICIZED_13157811206734809042)],
    ),
    (
        crate::EncodedStr::Ascii("eroticizes"),
        &[(0b01001, &ENTRY_EROTICIZES_4798707540088705022)],
    ),
    (
        crate::EncodedStr::Ascii("eroticizing"),
        &[(0b01001, &ENTRY_EROTICIZING_7294701366490544040)],
    ),
    (
        crate::EncodedStr::Ascii("erses"),
        &[(0b00001, &ENTRY_ERSES_5709814492624908686)],
    ),
    (
        crate::EncodedStr::Ascii("ersh"),
        &[(0b00001, &ENTRY_ERSH_939187057767591954)],
    ),
    (
        crate::EncodedStr::Ascii("ert"),
        &[(0b00001, &ENTRY_ERT_3341098308248153715)],
    ),
    (
        crate::EncodedStr::Ascii("eruginous"),
        &[(0b00001, &ENTRY_ERUGINOUS_5828853281772845437)],
    ),
    (
        crate::EncodedStr::Ascii("erugo"),
        &[(0b00001, &ENTRY_ERUGO_17158132187061977414)],
    ),
    (
        crate::EncodedStr::Ascii("erugos"),
        &[(0b00001, &ENTRY_ERUGOS_15673647349394448977)],
    ),
    (
        crate::EncodedStr::Ascii("ervalenta"),
        &[(0b00001, &ENTRY_ERVALENTA_10785450433515167284)],
    ),
    (
        crate::EncodedStr::Ascii("ervalentas"),
        &[(0b00001, &ENTRY_ERVALENTAS_18174157063570728071)],
    ),
    (
        crate::EncodedStr::Ascii("erythraean"),
        &[(0b11010, &ENTRY_ERYTHREAN_10329526815525592119)],
    ),
    (
        crate::EncodedStr::Ascii("erythraemia"),
        &[(0b11010, &ENTRY_ERYTHREMIA_836879494064020428)],
    ),
    (
        crate::EncodedStr::Ascii("erythrean"),
        &[(0b00001, &ENTRY_ERYTHREAN_10329526815525592119)],
    ),
    (
        crate::EncodedStr::Ascii("erythremia"),
        &[(0b00001, &ENTRY_ERYTHREMIA_836879494064020428)],
    ),
    (
        crate::EncodedStr::Ascii("esc"),
        &[(0b00001, &ENTRY_ESC_734356833349788703)],
    ),
    (
        crate::EncodedStr::Ascii("escalades"),
        &[(0b00001, &ENTRY_ESCALADES_8447970127642962693)],
    ),
    (
        crate::EncodedStr::Ascii("escaladoes"),
        &[(0b11010, &ENTRY_ESCALADES_8447970127642962693)],
    ),
    (
        crate::EncodedStr::Ascii("eschynite"),
        &[(0b00001, &ENTRY_ESCHYNITE_18313041144585925088)],
    ),
    (
        crate::EncodedStr::Ascii("esculapian"),
        &[(0b00001, &ENTRY_ESCULAPIAN_490183703265219666)],
    ),
    (
        crate::EncodedStr::Ascii("esculetin"),
        &[(0b00001, &ENTRY_ESCULETIN_4799035190382857787)],
    ),
    (
        crate::EncodedStr::Ascii("esculin"),
        &[(0b00001, &ENTRY_ESCULIN_10740850830469064996)],
    ),
    (
        crate::EncodedStr::Ascii("eskimoised"),
        &[(0b10010, &ENTRY_ESKIMOIZED_4978095404438860814)],
    ),
    (
        crate::EncodedStr::Ascii("eskimoiseds"),
        &[(0b10010, &ENTRY_ESKIMOIZEDS_8971879976387648671)],
    ),
    (
        crate::EncodedStr::Ascii("eskimoized"),
        &[(0b01001, &ENTRY_ESKIMOIZED_4978095404438860814)],
    ),
    (
        crate::EncodedStr::Ascii("eskimoizeds"),
        &[(0b01001, &ENTRY_ESKIMOIZEDS_8971879976387648671)],
    ),
    (
        crate::EncodedStr::Ascii("esop"),
        &[(0b10001, &ENTRY_ESOP_13490095149926411543)],
    ),
    (
        crate::EncodedStr::Ascii("esophagal"),
        &[(0b10001, &ENTRY_ESOPHAGAL_17089437120427101379)],
    ),
    (
        crate::EncodedStr::Ascii("esophagean"),
        &[(0b10001, &ENTRY_ESOPHAGEAN_1258506141459731259)],
    ),
    (
        crate::EncodedStr::Ascii("esophagi"),
        &[(0b11001, &ENTRY_ESOPHAGI_16651245992122782472)],
    ),
    (
        crate::EncodedStr::Ascii("esophagism"),
        &[(0b10001, &ENTRY_ESOPHAGISM_11099656979396238835)],
    ),
    (
        crate::EncodedStr::Ascii("esophagismus"),
        &[(0b10001, &ENTRY_ESOPHAGISMUS_6650076607428716726)],
    ),
    (
        crate::EncodedStr::Ascii("esophagitis"),
        &[(0b10001, &ENTRY_ESOPHAGITIS_2344628816303730914)],
    ),
    (
        crate::EncodedStr::Ascii("esophagus"),
        &[(0b10001, &ENTRY_ESOPHAGUS_11192235604123814381)],
    ),
    (
        crate::EncodedStr::Ascii("esophaguses"),
        &[(0b01001, &ENTRY_ESOPHAGI_16651245992122782472)],
    ),
    (
        crate::EncodedStr::Ascii("essenise"),
        &[(0b10010, &ENTRY_ESSENIZE_17352973219499483146)],
    ),
    (
        crate::EncodedStr::Ascii("essenises"),
        &[(0b10010, &ENTRY_ESSENIZES_6228789074305241285)],
    ),
    (
        crate::EncodedStr::Ascii("essenize"),
        &[(0b01001, &ENTRY_ESSENIZE_17352973219499483146)],
    ),
    (
        crate::EncodedStr::Ascii("essenizes"),
        &[(0b01001, &ENTRY_ESSENIZES_6228789074305241285)],
    ),
    (
        crate::EncodedStr::Ascii("essentialise"),
        &[(0b10010, &ENTRY_ESSENTIALIZE_6300653085008787820)],
    ),
    (
        crate::EncodedStr::Ascii("essentialises"),
        &[(0b10010, &ENTRY_ESSENTIALIZES_1314761290667427999)],
    ),
    (
        crate::EncodedStr::Ascii("essentialize"),
        &[(0b01001, &ENTRY_ESSENTIALIZE_6300653085008787820)],
    ),
    (
        crate::EncodedStr::Ascii("essentializes"),
        &[(0b01001, &ENTRY_ESSENTIALIZES_1314761290667427999)],
    ),
    (
        crate::EncodedStr::Ascii("esterisation"),
        &[(0b10010, &ENTRY_ESTERIZATION_1838643342430239163)],
    ),
    (
        crate::EncodedStr::Ascii("esterisations"),
        &[(0b10010, &ENTRY_ESTERIZATIONS_13064103908051692902)],
    ),
    (
        crate::EncodedStr::Ascii("esterise"),
        &[(0b10010, &ENTRY_ESTERIZE_14328305651236035983)],
    ),
    (
        crate::EncodedStr::Ascii("esterises"),
        &[(0b10010, &ENTRY_ESTERIZES_1807746540502831909)],
    ),
    (
        crate::EncodedStr::Ascii("esterization"),
        &[(0b01001, &ENTRY_ESTERIZATION_1838643342430239163)],
    ),
    (
        crate::EncodedStr::Ascii("esterizations"),
        &[(0b01001, &ENTRY_ESTERIZATIONS_13064103908051692902)],
    ),
    (
        crate::EncodedStr::Ascii("esterize"),
        &[(0b01001, &ENTRY_ESTERIZE_14328305651236035983)],
    ),
    (
        crate::EncodedStr::Ascii("esterizes"),
        &[(0b01001, &ENTRY_ESTERIZES_1807746540502831909)],
    ),
    (
        crate::EncodedStr::Ascii("estheses"),
        &[(0b00001, &ENTRY_ESTHESES_16116389526306967239)],
    ),
    (
        crate::EncodedStr::Ascii("esthesia"),
        &[(0b00001, &ENTRY_ESTHESIA_12451548753996008599)],
    ),
    (
        crate::EncodedStr::Ascii("esthesias"),
        &[(0b00001, &ENTRY_ESTHESIAS_5684600885047217053)],
    ),
    (
        crate::EncodedStr::Ascii("esthesiogen"),
        &[(0b00001, &ENTRY_ESTHESIOGEN_10989515066374267030)],
    ),
    (
        crate::EncodedStr::Ascii("esthesiogenic"),
        &[(0b00001, &ENTRY_ESTHESIOGENIC_8056723690025617876)],
    ),
    (
        crate::EncodedStr::Ascii("esthesiogens"),
        &[(0b00001, &ENTRY_ESTHESIOGENS_8380315319153501054)],
    ),
    (
        crate::EncodedStr::Ascii("esthesis"),
        &[(0b00001, &ENTRY_ESTHESIS_7143001285276086388)],
    ),
    (
        crate::EncodedStr::Ascii("esthete"),
        &[(0b00001, &ENTRY_AESTHETE_1223222359482085570)],
    ),
    (
        crate::EncodedStr::Ascii("esthetes"),
        &[(0b00001, &ENTRY_AESTHETES_9473189152352933863)],
    ),
    (
        crate::EncodedStr::Ascii("esthetic"),
        &[(0b11001, &ENTRY_AESTHETIC_854984485637846897)],
    ),
    (
        crate::EncodedStr::Ascii("esthetical"),
        &[(0b00001, &ENTRY_ESTHETICAL_827198906307006506)],
    ),
    (
        crate::EncodedStr::Ascii("esthetically"),
        &[(0b00001, &ENTRY_AESTHETICALLY_17149093527344769493)],
    ),
    (
        crate::EncodedStr::Ascii("esthetician"),
        &[(0b01001, &ENTRY_ESTHETICIAN_4531333424171533067)],
    ),
    (
        crate::EncodedStr::Ascii("estheticians"),
        &[(0b01001, &ENTRY_ESTHETICIANS_4428473313020471578)],
    ),
    (
        crate::EncodedStr::Ascii("esthetics"),
        &[(0b11001, &ENTRY_AESTHETICS_9838605701252615431)],
    ),
    (
        crate::EncodedStr::Ascii("estival"),
        &[(0b01001, &ENTRY_ESTIVAL_7252793851065540137)],
    ),
    (
        crate::EncodedStr::Ascii("estivate"),
        &[(0b01001, &ENTRY_ESTIVATE_6682485567558262552)],
    ),
    (
        crate::EncodedStr::Ascii("estivated"),
        &[(0b01001, &ENTRY_ESTIVATED_17659059957305359175)],
    ),
    (
        crate::EncodedStr::Ascii("estivates"),
        &[(0b01001, &ENTRY_ESTIVATES_15795900041274255113)],
    ),
    (
        crate::EncodedStr::Ascii("estivating"),
        &[(0b01001, &ENTRY_ESTIVATING_3590628019702465357)],
    ),
    (
        crate::EncodedStr::Ascii("estivation"),
        &[(0b01001, &ENTRY_ESTIVATION_970593505059854945)],
    ),
    (
        crate::EncodedStr::Ascii("estivations"),
        &[(0b01001, &ENTRY_ESTIVATIONS_11925170250729275718)],
    ),
    (
        crate::EncodedStr::Ascii("estivator"),
        &[(0b00001, &ENTRY_ESTIVATOR_17192827254089360161)],
    ),
    (
        crate::EncodedStr::Ascii("estive"),
        &[(0b00001, &ENTRY_ESTIVE_5420134362059951702)],
    ),
    (
        crate::EncodedStr::Ascii("estradiol"),
        &[(0b00001, &ENTRY_ESTRADIOL_634787677538270649)],
    ),
    (
        crate::EncodedStr::Ascii("estradiols"),
        &[(0b00001, &ENTRY_ESTRADIOLS_6587359583583660465)],
    ),
    (
        crate::EncodedStr::Ascii("estral"),
        &[(0b00001, &ENTRY_ESTRAL_250960197285450439)],
    ),
    (
        crate::EncodedStr::Ascii("estrin"),
        &[(0b00001, &ENTRY_ESTRIN_1271537042891040806)],
    ),
    (
        crate::EncodedStr::Ascii("estrins"),
        &[(0b00001, &ENTRY_ESTRINS_11482863399944620630)],
    ),
    (
        crate::EncodedStr::Ascii("estriol"),
        &[(0b00001, &ENTRY_ESTRIOL_5700840801301268453)],
    ),
    (
        crate::EncodedStr::Ascii("estriols"),
        &[(0b00001, &ENTRY_ESTRIOLS_15504531823851684601)],
    ),
    (
        crate::EncodedStr::Ascii("estrogen"),
        &[(0b11001, &ENTRY_ESTROGEN_9296702706992805950)],
    ),
    (
        crate::EncodedStr::Ascii("estrogenic"),
        &[(0b11001, &ENTRY_ESTROGENIC_9825757897324531986)],
    ),
    (
        crate::EncodedStr::Ascii("estrogens"),
        &[(0b11001, &ENTRY_ESTROGENS_13879624153768181446)],
    ),
    (
        crate::EncodedStr::Ascii("estrone"),
        &[(0b00001, &ENTRY_ESTRONE_5235731124564419249)],
    ),
    (
        crate::EncodedStr::Ascii("estrones"),
        &[(0b00001, &ENTRY_ESTRONES_396980696513423065)],
    ),
    (
        crate::EncodedStr::Ascii("estrous"),
        &[(0b01001, &ENTRY_ESTROUS_3175557539569890653)],
    ),
    (
        crate::EncodedStr::Ascii("estrual"),
        &[(0b00001, &ENTRY_ESTRUAL_2760322156873020612)],
    ),
    (
        crate::EncodedStr::Ascii("estruate"),
        &[(0b00001, &ENTRY_ESTRUATE_9742423605759945651)],
    ),
    (
        crate::EncodedStr::Ascii("estruation"),
        &[(0b00001, &ENTRY_ESTRUATION_528782982925379226)],
    ),
    (
        crate::EncodedStr::Ascii("estrum"),
        &[(0b00001, &ENTRY_ESTRUM_80713081920872301)],
    ),
    (
        crate::EncodedStr::Ascii("estrums"),
        &[(0b00001, &ENTRY_ESTRUMS_13425140989742183588)],
    ),
    (
        crate::EncodedStr::Ascii("estrus"),
        &[(0b01001, &ENTRY_ESTRUS_12109407348878630371)],
    ),
    (
        crate::EncodedStr::Ascii("estruses"),
        &[(0b01001, &ENTRY_ESTRUSES_10476871772114155317)],
    ),
    (
        crate::EncodedStr::Ascii("estuate"),
        &[(0b00001, &ENTRY_ESTUATE_7237204571723121927)],
    ),
    (
        crate::EncodedStr::Ascii("estuous"),
        &[(0b00001, &ENTRY_ESTUOUS_15581034853542643799)],
    ),
    (
        crate::EncodedStr::Ascii("esture"),
        &[(0b00001, &ENTRY_ESTURE_3483676630062562550)],
    ),
    (
        crate::EncodedStr::Ascii("estus"),
        &[(0b00001, &ENTRY_ESTUS_10309034292162795617)],
    ),
    (
        crate::EncodedStr::Ascii("et"),
        &[(0b00001, &ENTRY_ET_11650800039480951541)],
    ),
    (
        crate::EncodedStr::Ascii("eternalisation"),
        &[(0b10010, &ENTRY_ETERNALIZATION_3734495480513175198)],
    ),
    (
        crate::EncodedStr::Ascii("eternalisations"),
        &[(0b10010, &ENTRY_ETERNALIZATIONS_1580610116895380250)],
    ),
    (
        crate::EncodedStr::Ascii("eternalise"),
        &[(0b10010, &ENTRY_ETERNALIZE_11131798101969437364)],
    ),
    (
        crate::EncodedStr::Ascii("eternalised"),
        &[(0b10010, &ENTRY_ETERNALIZED_9585284058759840856)],
    ),
    (
        crate::EncodedStr::Ascii("eternalises"),
        &[(0b10010, &ENTRY_ETERNALIZES_4326233422849452608)],
    ),
    (
        crate::EncodedStr::Ascii("eternalising"),
        &[(0b10010, &ENTRY_ETERNALIZING_14008573203681681715)],
    ),
    (
        crate::EncodedStr::Ascii("eternalization"),
        &[(0b01001, &ENTRY_ETERNALIZATION_3734495480513175198)],
    ),
    (
        crate::EncodedStr::Ascii("eternalizations"),
        &[(0b01001, &ENTRY_ETERNALIZATIONS_1580610116895380250)],
    ),
    (
        crate::EncodedStr::Ascii("eternalize"),
        &[(0b01001, &ENTRY_ETERNALIZE_11131798101969437364)],
    ),
    (
        crate::EncodedStr::Ascii("eternalized"),
        &[(0b01001, &ENTRY_ETERNALIZED_9585284058759840856)],
    ),
    (
        crate::EncodedStr::Ascii("eternalizes"),
        &[(0b01001, &ENTRY_ETERNALIZES_4326233422849452608)],
    ),
    (
        crate::EncodedStr::Ascii("eternalizing"),
        &[(0b01001, &ENTRY_ETERNALIZING_14008573203681681715)],
    ),
    (
        crate::EncodedStr::Ascii("eternisation"),
        &[(0b10010, &ENTRY_ETERNIZATION_2995449191647800002)],
    ),
    (
        crate::EncodedStr::Ascii("eternisations"),
        &[(0b10010, &ENTRY_ETERNIZATIONS_8586384193807168026)],
    ),
    (
        crate::EncodedStr::Ascii("eternise"),
        &[(0b10010, &ENTRY_ETERNIZE_9225349190347066102)],
    ),
    (
        crate::EncodedStr::Ascii("eternised"),
        &[(0b10010, &ENTRY_ETERNIZED_803700093303685693)],
    ),
    (
        crate::EncodedStr::Ascii("eternises"),
        &[(0b10010, &ENTRY_ETERNIZES_13889836130672451566)],
    ),
    (
        crate::EncodedStr::Ascii("eternising"),
        &[(0b10010, &ENTRY_ETERNIZING_10174905521874007767)],
    ),
    (
        crate::EncodedStr::Ascii("eternization"),
        &[(0b01001, &ENTRY_ETERNIZATION_2995449191647800002)],
    ),
    (
        crate::EncodedStr::Ascii("eternizations"),
        &[(0b01001, &ENTRY_ETERNIZATIONS_8586384193807168026)],
    ),
    (
        crate::EncodedStr::Ascii("eternize"),
        &[(0b01001, &ENTRY_ETERNIZE_9225349190347066102)],
    ),
    (
        crate::EncodedStr::Ascii("eternized"),
        &[(0b01001, &ENTRY_ETERNIZED_803700093303685693)],
    ),
    (
        crate::EncodedStr::Ascii("eternizes"),
        &[(0b01001, &ENTRY_ETERNIZES_13889836130672451566)],
    ),
    (
        crate::EncodedStr::Ascii("eternizing"),
        &[(0b01001, &ENTRY_ETERNIZING_10174905521874007767)],
    ),
    (
        crate::EncodedStr::Ascii("etheling"),
        &[(0b00001, &ENTRY_ETHELING_7453000440584654761)],
    ),
    (
        crate::EncodedStr::Ascii("etherealisation"),
        &[(0b10010, &ENTRY_ETHEREALIZATION_12734652389847905816)],
    ),
    (
        crate::EncodedStr::Ascii("etherealisations"),
        &[(0b10010, &ENTRY_ETHEREALIZATIONS_2132392675240347392)],
    ),
    (
        crate::EncodedStr::Ascii("etherealise"),
        &[(0b10010, &ENTRY_ETHEREALIZE_2065340124732116568)],
    ),
    (
        crate::EncodedStr::Ascii("etherealised"),
        &[(0b10010, &ENTRY_ETHEREALIZED_5421449992122948198)],
    ),
    (
        crate::EncodedStr::Ascii("etherealises"),
        &[(0b10010, &ENTRY_ETHEREALIZES_5231734843750416436)],
    ),
    (
        crate::EncodedStr::Ascii("etherealising"),
        &[(0b10010, &ENTRY_ETHEREALIZING_17209337922860403926)],
    ),
    (
        crate::EncodedStr::Ascii("etherealization"),
        &[(0b01001, &ENTRY_ETHEREALIZATION_12734652389847905816)],
    ),
    (
        crate::EncodedStr::Ascii("etherealizations"),
        &[(0b01001, &ENTRY_ETHEREALIZATIONS_2132392675240347392)],
    ),
    (
        crate::EncodedStr::Ascii("etherealize"),
        &[(0b01001, &ENTRY_ETHEREALIZE_2065340124732116568)],
    ),
    (
        crate::EncodedStr::Ascii("etherealized"),
        &[(0b01001, &ENTRY_ETHEREALIZED_5421449992122948198)],
    ),
    (
        crate::EncodedStr::Ascii("etherealizes"),
        &[(0b01001, &ENTRY_ETHEREALIZES_5231734843750416436)],
    ),
    (
        crate::EncodedStr::Ascii("etherealizing"),
        &[(0b01001, &ENTRY_ETHEREALIZING_17209337922860403926)],
    ),
    (
        crate::EncodedStr::Ascii("ethered"),
        &[(0b00001, &ENTRY_ETHERED_11737830389019716848)],
    ),
    (
        crate::EncodedStr::Ascii("etherialisation"),
        &[(0b10010, &ENTRY_ETHERIALIZATION_13934934240531358321)],
    ),
    (
        crate::EncodedStr::Ascii("etherialise"),
        &[(0b10010, &ENTRY_ETHERIALIZE_16410637034856874095)],
    ),
    (
        crate::EncodedStr::Ascii("etherialised"),
        &[(0b10010, &ENTRY_ETHERIALIZED_6425316747358472251)],
    ),
    (
        crate::EncodedStr::Ascii("etherialising"),
        &[(0b10010, &ENTRY_ETHERIALIZING_5420182430706962967)],
    ),
    (
        crate::EncodedStr::Ascii("etherialization"),
        &[(0b01001, &ENTRY_ETHERIALIZATION_13934934240531358321)],
    ),
    (
        crate::EncodedStr::Ascii("etherialize"),
        &[(0b01001, &ENTRY_ETHERIALIZE_16410637034856874095)],
    ),
    (
        crate::EncodedStr::Ascii("etherialized"),
        &[(0b01001, &ENTRY_ETHERIALIZED_6425316747358472251)],
    ),
    (
        crate::EncodedStr::Ascii("etherializing"),
        &[(0b01001, &ENTRY_ETHERIALIZING_5420182430706962967)],
    ),
    (
        crate::EncodedStr::Ascii("etheric"),
        &[(0b00001, &ENTRY_ETHERIC_14308840270744949246)],
    ),
    (
        crate::EncodedStr::Ascii("etherisation"),
        &[(0b10010, &ENTRY_ETHERIZATION_2978885687909295823)],
    ),
    (
        crate::EncodedStr::Ascii("etherisations"),
        &[(0b10010, &ENTRY_ETHERIZATIONS_12592394080916973256)],
    ),
    (
        crate::EncodedStr::Ascii("etherise"),
        &[(0b10010, &ENTRY_ETHERIZE_14089274929682497230)],
    ),
    (
        crate::EncodedStr::Ascii("etherised"),
        &[(0b10010, &ENTRY_ETHERIZED_13463455547519294082)],
    ),
    (
        crate::EncodedStr::Ascii("etheriser"),
        &[(0b10010, &ENTRY_ETHERIZER_10217889819429808699)],
    ),
    (
        crate::EncodedStr::Ascii("etherisers"),
        &[(0b10010, &ENTRY_ETHERIZERS_10538480316981131131)],
    ),
    (
        crate::EncodedStr::Ascii("etherises"),
        &[(0b10010, &ENTRY_ETHERIZES_13469750050699304076)],
    ),
    (
        crate::EncodedStr::Ascii("etherising"),
        &[(0b10010, &ENTRY_ETHERIZING_5812365847799688656)],
    ),
    (
        crate::EncodedStr::Ascii("etherization"),
        &[(0b01001, &ENTRY_ETHERIZATION_2978885687909295823)],
    ),
    (
        crate::EncodedStr::Ascii("etherizations"),
        &[(0b01001, &ENTRY_ETHERIZATIONS_12592394080916973256)],
    ),
    (
        crate::EncodedStr::Ascii("etherize"),
        &[(0b01001, &ENTRY_ETHERIZE_14089274929682497230)],
    ),
    (
        crate::EncodedStr::Ascii("etherized"),
        &[(0b01001, &ENTRY_ETHERIZED_13463455547519294082)],
    ),
    (
        crate::EncodedStr::Ascii("etherizer"),
        &[(0b01001, &ENTRY_ETHERIZER_10217889819429808699)],
    ),
    (
        crate::EncodedStr::Ascii("etherizers"),
        &[(0b01001, &ENTRY_ETHERIZERS_10538480316981131131)],
    ),
    (
        crate::EncodedStr::Ascii("etherizes"),
        &[(0b01001, &ENTRY_ETHERIZES_13469750050699304076)],
    ),
    (
        crate::EncodedStr::Ascii("etherizing"),
        &[(0b01001, &ENTRY_ETHERIZING_5812365847799688656)],
    ),
    (
        crate::EncodedStr::Ascii("ethicisation"),
        &[(0b10010, &ENTRY_ETHICIZATION_7982960618336992609)],
    ),
    (
        crate::EncodedStr::Ascii("ethicise"),
        &[(0b10010, &ENTRY_ETHICIZE_9319969408983326697)],
    ),
    (
        crate::EncodedStr::Ascii("ethicised"),
        &[(0b10010, &ENTRY_ETHICIZED_13298420094237367669)],
    ),
    (
        crate::EncodedStr::Ascii("ethicises"),
        &[(0b10010, &ENTRY_ETHICIZES_4425545207707744116)],
    ),
    (
        crate::EncodedStr::Ascii("ethicising"),
        &[(0b10010, &ENTRY_ETHICIZING_13920935019894378060)],
    ),
    (
        crate::EncodedStr::Ascii("ethicization"),
        &[(0b01001, &ENTRY_ETHICIZATION_7982960618336992609)],
    ),
    (
        crate::EncodedStr::Ascii("ethicize"),
        &[(0b01001, &ENTRY_ETHICIZE_9319969408983326697)],
    ),
    (
        crate::EncodedStr::Ascii("ethicized"),
        &[(0b01001, &ENTRY_ETHICIZED_13298420094237367669)],
    ),
    (
        crate::EncodedStr::Ascii("ethicizes"),
        &[(0b01001, &ENTRY_ETHICIZES_4425545207707744116)],
    ),
    (
        crate::EncodedStr::Ascii("ethicizing"),
        &[(0b01001, &ENTRY_ETHICIZING_13920935019894378060)],
    ),
    (
        crate::EncodedStr::Ascii("ethnicise"),
        &[(0b10010, &ENTRY_ETHNICIZE_9658075899558980564)],
    ),
    (
        crate::EncodedStr::Ascii("ethnicises"),
        &[(0b10010, &ENTRY_ETHNICIZES_17717835002455612610)],
    ),
    (
        crate::EncodedStr::Ascii("ethnicize"),
        &[(0b01001, &ENTRY_ETHNICIZE_9658075899558980564)],
    ),
    (
        crate::EncodedStr::Ascii("ethnicizes"),
        &[(0b01001, &ENTRY_ETHNICIZES_17717835002455612610)],
    ),
    (
        crate::EncodedStr::Ascii("etiogenic"),
        &[(0b10001, &ENTRY_ETIOGENIC_4607596180327733291)],
    ),
    (
        crate::EncodedStr::Ascii("etiologically"),
        &[(0b11001, &ENTRY_ETIOLOGICALLY_16961054798674884692)],
    ),
    (
        crate::EncodedStr::Ascii("etiologist"),
        &[(0b10001, &ENTRY_ETIOLOGIST_11212980661305626571)],
    ),
    (
        crate::EncodedStr::Ascii("etiologue"),
        &[(0b10001, &ENTRY_ETIOLOGUE_3427764260416926249)],
    ),
    (
        crate::EncodedStr::Ascii("etiology"),
        &[(0b11001, &ENTRY_ETIOLOGY_7123968270032580321)],
    ),
    (
        crate::EncodedStr::Ascii("etiophyllin"),
        &[(0b10001, &ENTRY_ETIOPHYLLIN_9404514496968390932)],
    ),
    (
        crate::EncodedStr::Ascii("etiotropic"),
        &[(0b10001, &ENTRY_ETIOTROPIC_17191333273430729692)],
    ),
    (
        crate::EncodedStr::Ascii("etiotropically"),
        &[(0b10001, &ENTRY_ETIOTROPICALLY_9902369940420748380)],
    ),
    (
        crate::EncodedStr::Ascii("etymologisable"),
        &[(0b10010, &ENTRY_ETYMOLOGIZABLE_14324009501183818334)],
    ),
    (
        crate::EncodedStr::Ascii("etymologisation"),
        &[(0b10010, &ENTRY_ETYMOLOGIZATION_6720014631573230453)],
    ),
    (
        crate::EncodedStr::Ascii("etymologise"),
        &[(0b10010, &ENTRY_ETYMOLOGIZE_9732898285094826377)],
    ),
    (
        crate::EncodedStr::Ascii("etymologised"),
        &[(0b10010, &ENTRY_ETYMOLOGIZED_9179162719754519975)],
    ),
    (
        crate::EncodedStr::Ascii("etymologises"),
        &[(0b10010, &ENTRY_ETYMOLOGIZES_18258268798885199036)],
    ),
    (
        crate::EncodedStr::Ascii("etymologising"),
        &[(0b10010, &ENTRY_ETYMOLOGIZING_10793154235770650022)],
    ),
    (
        crate::EncodedStr::Ascii("etymologizable"),
        &[(0b01001, &ENTRY_ETYMOLOGIZABLE_14324009501183818334)],
    ),
    (
        crate::EncodedStr::Ascii("etymologization"),
        &[(0b01001, &ENTRY_ETYMOLOGIZATION_6720014631573230453)],
    ),
    (
        crate::EncodedStr::Ascii("etymologize"),
        &[(0b01001, &ENTRY_ETYMOLOGIZE_9732898285094826377)],
    ),
    (
        crate::EncodedStr::Ascii("etymologized"),
        &[(0b01001, &ENTRY_ETYMOLOGIZED_9179162719754519975)],
    ),
    (
        crate::EncodedStr::Ascii("etymologizes"),
        &[(0b01001, &ENTRY_ETYMOLOGIZES_18258268798885199036)],
    ),
    (
        crate::EncodedStr::Ascii("etymologizing"),
        &[(0b01001, &ENTRY_ETYMOLOGIZING_10793154235770650022)],
    ),
    (
        crate::EncodedStr::Ascii("eudaemon"),
        &[(0b11010, &ENTRY_EUDEMON_11438303724932164772)],
    ),
    (
        crate::EncodedStr::Ascii("eudaemonia"),
        &[(0b11010, &ENTRY_EUDEMONIA_8536611909974853285)],
    ),
    (
        crate::EncodedStr::Ascii("eudaemonic"),
        &[(0b11010, &ENTRY_EUDEMONIC_10703096338080832052)],
    ),
    (
        crate::EncodedStr::Ascii("eudaemonics"),
        &[(0b11010, &ENTRY_EUDEMONICS_11983069269785700336)],
    ),
    (
        crate::EncodedStr::Ascii("eudaemonism"),
        &[(0b11010, &ENTRY_EUDEMONISM_2030451125927147437)],
    ),
    (
        crate::EncodedStr::Ascii("eudaemonisms"),
        &[(0b11010, &ENTRY_EUDEMONISMS_9663152886088963814)],
    ),
    (
        crate::EncodedStr::Ascii("eudaemonist"),
        &[(0b11010, &ENTRY_EUDEMONIST_10437519314337880945)],
    ),
    (
        crate::EncodedStr::Ascii("eudaemonistic"),
        &[(0b11010, &ENTRY_EUDEMONISTIC_4092483053014414870)],
    ),
    (
        crate::EncodedStr::Ascii("eudaemonistical"),
        &[(0b11010, &ENTRY_EUDEMONISTICAL_5594575273383737360)],
    ),
    (
        crate::EncodedStr::Ascii("eudaemonistically"),
        &[(0b11010, &ENTRY_EUDEMONISTICALLY_11557458762944374366)],
    ),
    (
        crate::EncodedStr::Ascii("eudaemonists"),
        &[(0b11010, &ENTRY_EUDEMONISTS_8607780052774605016)],
    ),
    (
        crate::EncodedStr::Ascii("eudaemons"),
        &[(0b11010, &ENTRY_EUDEMONS_619440478160622096)],
    ),
    (
        crate::EncodedStr::Ascii("eudaemony"),
        &[(0b11010, &ENTRY_EUDEMONY_7203436464418206960)],
    ),
    (
        crate::EncodedStr::Ascii("eudemon"),
        &[(0b00001, &ENTRY_EUDEMON_11438303724932164772)],
    ),
    (
        crate::EncodedStr::Ascii("eudemonia"),
        &[(0b00001, &ENTRY_EUDEMONIA_8536611909974853285)],
    ),
    (
        crate::EncodedStr::Ascii("eudemonic"),
        &[(0b00001, &ENTRY_EUDEMONIC_10703096338080832052)],
    ),
    (
        crate::EncodedStr::Ascii("eudemonics"),
        &[(0b00001, &ENTRY_EUDEMONICS_11983069269785700336)],
    ),
    (
        crate::EncodedStr::Ascii("eudemonism"),
        &[(0b00001, &ENTRY_EUDEMONISM_2030451125927147437)],
    ),
    (
        crate::EncodedStr::Ascii("eudemonisms"),
        &[(0b00001, &ENTRY_EUDEMONISMS_9663152886088963814)],
    ),
    (
        crate::EncodedStr::Ascii("eudemonist"),
        &[(0b00001, &ENTRY_EUDEMONIST_10437519314337880945)],
    ),
    (
        crate::EncodedStr::Ascii("eudemonistic"),
        &[(0b00001, &ENTRY_EUDEMONISTIC_4092483053014414870)],
    ),
    (
        crate::EncodedStr::Ascii("eudemonistical"),
        &[(0b00001, &ENTRY_EUDEMONISTICAL_5594575273383737360)],
    ),
    (
        crate::EncodedStr::Ascii("eudemonistically"),
        &[(0b00001, &ENTRY_EUDEMONISTICALLY_11557458762944374366)],
    ),
    (
        crate::EncodedStr::Ascii("eudemonists"),
        &[(0b00001, &ENTRY_EUDEMONISTS_8607780052774605016)],
    ),
    (
        crate::EncodedStr::Ascii("eudemons"),
        &[(0b00001, &ENTRY_EUDEMONS_619440478160622096)],
    ),
    (
        crate::EncodedStr::Ascii("eudemony"),
        &[(0b00001, &ENTRY_EUDEMONY_7203436464418206960)],
    ),
    (
        crate::EncodedStr::Ascii("euhemerise"),
        &[(0b10010, &ENTRY_EUHEMERIZE_10861960486485255136)],
    ),
    (
        crate::EncodedStr::Ascii("euhemerised"),
        &[(0b10010, &ENTRY_EUHEMERIZED_13249306373968955924)],
    ),
    (
        crate::EncodedStr::Ascii("euhemerises"),
        &[(0b10010, &ENTRY_EUHEMERIZES_2599757245144591712)],
    ),
    (
        crate::EncodedStr::Ascii("euhemerising"),
        &[(0b10010, &ENTRY_EUHEMERIZING_9558743899414823460)],
    ),
    (
        crate::EncodedStr::Ascii("euhemerize"),
        &[(0b01001, &ENTRY_EUHEMERIZE_10861960486485255136)],
    ),
    (
        crate::EncodedStr::Ascii("euhemerized"),
        &[(0b01001, &ENTRY_EUHEMERIZED_13249306373968955924)],
    ),
    (
        crate::EncodedStr::Ascii("euhemerizes"),
        &[(0b01001, &ENTRY_EUHEMERIZES_2599757245144591712)],
    ),
    (
        crate::EncodedStr::Ascii("euhemerizing"),
        &[(0b01001, &ENTRY_EUHEMERIZING_9558743899414823460)],
    ),
    (
        crate::EncodedStr::Ascii("eulogisation"),
        &[(0b10010, &ENTRY_EULOGIZATION_10282426959041271101)],
    ),
    (
        crate::EncodedStr::Ascii("eulogisations"),
        &[(0b10010, &ENTRY_EULOGIZATIONS_7636756562230100487)],
    ),
    (
        crate::EncodedStr::Ascii("eulogise"),
        &[(0b10010, &ENTRY_EULOGIZE_1653837351412814344)],
    ),
    (
        crate::EncodedStr::Ascii("eulogised"),
        &[(0b10010, &ENTRY_EULOGIZED_2725015015260591952)],
    ),
    (
        crate::EncodedStr::Ascii("eulogiser"),
        &[(0b10010, &ENTRY_EULOGIZER_1964342767045376178)],
    ),
    (
        crate::EncodedStr::Ascii("eulogisers"),
        &[(0b10010, &ENTRY_EULOGIZERS_14136473823163628988)],
    ),
    (
        crate::EncodedStr::Ascii("eulogises"),
        &[(0b10010, &ENTRY_EULOGIZES_14586567692374933834)],
    ),
    (
        crate::EncodedStr::Ascii("eulogising"),
        &[(0b10010, &ENTRY_EULOGIZING_12476629388826192151)],
    ),
    (
        crate::EncodedStr::Ascii("eulogization"),
        &[(0b01001, &ENTRY_EULOGIZATION_10282426959041271101)],
    ),
    (
        crate::EncodedStr::Ascii("eulogizations"),
        &[(0b01001, &ENTRY_EULOGIZATIONS_7636756562230100487)],
    ),
    (
        crate::EncodedStr::Ascii("eulogize"),
        &[(0b01001, &ENTRY_EULOGIZE_1653837351412814344)],
    ),
    (
        crate::EncodedStr::Ascii("eulogized"),
        &[(0b01001, &ENTRY_EULOGIZED_2725015015260591952)],
    ),
    (
        crate::EncodedStr::Ascii("eulogizer"),
        &[(0b01001, &ENTRY_EULOGIZER_1964342767045376178)],
    ),
    (
        crate::EncodedStr::Ascii("eulogizers"),
        &[(0b01001, &ENTRY_EULOGIZERS_14136473823163628988)],
    ),
    (
        crate::EncodedStr::Ascii("eulogizes"),
        &[(0b01001, &ENTRY_EULOGIZES_14586567692374933834)],
    ),
    (
        crate::EncodedStr::Ascii("eulogizing"),
        &[(0b01001, &ENTRY_EULOGIZING_12476629388826192151)],
    ),
    (
        crate::EncodedStr::Ascii("eunuchise"),
        &[(0b10010, &ENTRY_EUNUCHIZE_15135167016143668512)],
    ),
    (
        crate::EncodedStr::Ascii("eunuchised"),
        &[(0b10010, &ENTRY_EUNUCHIZED_13625235435443656462)],
    ),
    (
        crate::EncodedStr::Ascii("eunuchises"),
        &[(0b10010, &ENTRY_EUNUCHIZES_13328477625215260244)],
    ),
    (
        crate::EncodedStr::Ascii("eunuchising"),
        &[(0b10010, &ENTRY_EUNUCHIZING_1999758532637837177)],
    ),
    (
        crate::EncodedStr::Ascii("eunuchize"),
        &[(0b01001, &ENTRY_EUNUCHIZE_15135167016143668512)],
    ),
    (
        crate::EncodedStr::Ascii("eunuchized"),
        &[(0b01001, &ENTRY_EUNUCHIZED_13625235435443656462)],
    ),
    (
        crate::EncodedStr::Ascii("eunuchizes"),
        &[(0b01001, &ENTRY_EUNUCHIZES_13328477625215260244)],
    ),
    (
        crate::EncodedStr::Ascii("eunuchizing"),
        &[(0b01001, &ENTRY_EUNUCHIZING_1999758532637837177)],
    ),
    (
        crate::EncodedStr::Ascii("euphemisation"),
        &[(0b10010, &ENTRY_EUPHEMIZATION_15897062775810681100)],
    ),
    (
        crate::EncodedStr::Ascii("euphemise"),
        &[(0b10010, &ENTRY_EUPHEMIZE_6156608839130565166)],
    ),
    (
        crate::EncodedStr::Ascii("euphemised"),
        &[(0b10010, &ENTRY_EUPHEMIZED_16524474124949436387)],
    ),
    (
        crate::EncodedStr::Ascii("euphemiser"),
        &[(0b10010, &ENTRY_EUPHEMIZER_3905220143608307778)],
    ),
    (
        crate::EncodedStr::Ascii("euphemisers"),
        &[(0b10010, &ENTRY_EUPHEMIZERS_14865306922922439267)],
    ),
    (
        crate::EncodedStr::Ascii("euphemises"),
        &[(0b10010, &ENTRY_EUPHEMIZES_13615629412067350528)],
    ),
    (
        crate::EncodedStr::Ascii("euphemising"),
        &[(0b10010, &ENTRY_EUPHEMIZING_14044452417298877788)],
    ),
    (
        crate::EncodedStr::Ascii("euphemization"),
        &[(0b01001, &ENTRY_EUPHEMIZATION_15897062775810681100)],
    ),
    (
        crate::EncodedStr::Ascii("euphemize"),
        &[(0b01001, &ENTRY_EUPHEMIZE_6156608839130565166)],
    ),
    (
        crate::EncodedStr::Ascii("euphemized"),
        &[(0b01001, &ENTRY_EUPHEMIZED_16524474124949436387)],
    ),
    (
        crate::EncodedStr::Ascii("euphemizer"),
        &[(0b01001, &ENTRY_EUPHEMIZER_3905220143608307778)],
    ),
    (
        crate::EncodedStr::Ascii("euphemizers"),
        &[(0b01001, &ENTRY_EUPHEMIZERS_14865306922922439267)],
    ),
    (
        crate::EncodedStr::Ascii("euphemizes"),
        &[(0b01001, &ENTRY_EUPHEMIZES_13615629412067350528)],
    ),
    (
        crate::EncodedStr::Ascii("euphemizing"),
        &[(0b01001, &ENTRY_EUPHEMIZING_14044452417298877788)],
    ),
    (
        crate::EncodedStr::Ascii("euphonisation"),
        &[(0b10010, &ENTRY_EUPHONIZATION_8160800683971054658)],
    ),
    (
        crate::EncodedStr::Ascii("euphonise"),
        &[(0b10010, &ENTRY_EUPHONIZE_12154684566192054671)],
    ),
    (
        crate::EncodedStr::Ascii("euphonised"),
        &[(0b10010, &ENTRY_EUPHONIZED_2332221337646658561)],
    ),
    (
        crate::EncodedStr::Ascii("euphonises"),
        &[(0b10010, &ENTRY_EUPHONIZES_10361394233532999333)],
    ),
    (
        crate::EncodedStr::Ascii("euphonising"),
        &[(0b10010, &ENTRY_EUPHONIZING_12869225507816001400)],
    ),
    (
        crate::EncodedStr::Ascii("euphonization"),
        &[(0b01001, &ENTRY_EUPHONIZATION_8160800683971054658)],
    ),
    (
        crate::EncodedStr::Ascii("euphonize"),
        &[(0b01001, &ENTRY_EUPHONIZE_12154684566192054671)],
    ),
    (
        crate::EncodedStr::Ascii("euphonized"),
        &[(0b01001, &ENTRY_EUPHONIZED_2332221337646658561)],
    ),
    (
        crate::EncodedStr::Ascii("euphonizes"),
        &[(0b01001, &ENTRY_EUPHONIZES_10361394233532999333)],
    ),
    (
        crate::EncodedStr::Ascii("euphonizing"),
        &[(0b01001, &ENTRY_EUPHONIZING_12869225507816001400)],
    ),
    (
        crate::EncodedStr::Ascii("euphuise"),
        &[(0b10010, &ENTRY_EUPHUIZE_7719186029258614802)],
    ),
    (
        crate::EncodedStr::Ascii("euphuised"),
        &[(0b10010, &ENTRY_EUPHUIZED_16530053689080256866)],
    ),
    (
        crate::EncodedStr::Ascii("euphuises"),
        &[(0b10010, &ENTRY_EUPHUIZES_1610646119362678571)],
    ),
    (
        crate::EncodedStr::Ascii("euphuising"),
        &[(0b10010, &ENTRY_EUPHUIZING_13793329409991103775)],
    ),
    (
        crate::EncodedStr::Ascii("euphuize"),
        &[(0b01001, &ENTRY_EUPHUIZE_7719186029258614802)],
    ),
    (
        crate::EncodedStr::Ascii("euphuized"),
        &[(0b01001, &ENTRY_EUPHUIZED_16530053689080256866)],
    ),
    (
        crate::EncodedStr::Ascii("euphuizes"),
        &[(0b01001, &ENTRY_EUPHUIZES_1610646119362678571)],
    ),
    (
        crate::EncodedStr::Ascii("euphuizing"),
        &[(0b01001, &ENTRY_EUPHUIZING_13793329409991103775)],
    ),
    (
        crate::EncodedStr::Ascii("eupnea"),
        &[(0b10001, &ENTRY_EUPNEA_15696889609657452284)],
    ),
    (
        crate::EncodedStr::Ascii("eupneas"),
        &[(0b10001, &ENTRY_EUPNEAS_17113263914966538934)],
    ),
    (
        crate::EncodedStr::Ascii("eupneic"),
        &[(0b10001, &ENTRY_EUPNEIC_10760124621699958430)],
    ),
    (
        crate::EncodedStr::Ascii("eupnoea"),
        &[(0b11010, &ENTRY_EUPNEA_15696889609657452284)],
    ),
    (
        crate::EncodedStr::Ascii("eupnoeas"),
        &[(0b11010, &ENTRY_EUPNEAS_17113263914966538934)],
    ),
    (
        crate::EncodedStr::Ascii("eupnoeic"),
        &[(0b11010, &ENTRY_EUPNEIC_10760124621699958430)],
    ),
    (
        crate::EncodedStr::Ascii("europeanisation"),
        &[(0b10010, &ENTRY_EUROPEANIZATION_1560895436028194898)],
    ),
    (
        crate::EncodedStr::Ascii("europeanisations"),
        &[(0b10010, &ENTRY_EUROPEANIZATIONS_10170958288412142340)],
    ),
    (
        crate::EncodedStr::Ascii("europeanise"),
        &[(0b10010, &ENTRY_EUROPEANIZE_9458498374082461253)],
    ),
    (
        crate::EncodedStr::Ascii("europeanised"),
        &[(0b10010, &ENTRY_EUROPEANIZED_4342167856841628431)],
    ),
    (
        crate::EncodedStr::Ascii("europeanises"),
        &[(0b10010, &ENTRY_EUROPEANIZES_12996997230914775868)],
    ),
    (
        crate::EncodedStr::Ascii("europeanising"),
        &[(0b10010, &ENTRY_EUROPEANIZING_17501868806425018896)],
    ),
    (
        crate::EncodedStr::Ascii("europeanization"),
        &[(0b01001, &ENTRY_EUROPEANIZATION_1560895436028194898)],
    ),
    (
        crate::EncodedStr::Ascii("europeanizations"),
        &[(0b01001, &ENTRY_EUROPEANIZATIONS_10170958288412142340)],
    ),
    (
        crate::EncodedStr::Ascii("europeanize"),
        &[(0b01001, &ENTRY_EUROPEANIZE_9458498374082461253)],
    ),
    (
        crate::EncodedStr::Ascii("europeanized"),
        &[(0b01001, &ENTRY_EUROPEANIZED_4342167856841628431)],
    ),
    (
        crate::EncodedStr::Ascii("europeanizes"),
        &[(0b01001, &ENTRY_EUROPEANIZES_12996997230914775868)],
    ),
    (
        crate::EncodedStr::Ascii("europeanizing"),
        &[(0b01001, &ENTRY_EUROPEANIZING_17501868806425018896)],
    ),
    (
        crate::EncodedStr::Ascii("euryalae"),
        &[(0b11010, &ENTRY_EURYALE_4488395712087565374)],
    ),
    (
        crate::EncodedStr::Ascii("euryale"),
        &[(0b00001, &ENTRY_EURYALE_4488395712087565374)],
    ),
    (
        crate::EncodedStr::Ascii("evangelisation"),
        &[(0b10010, &ENTRY_EVANGELIZATION_4680427557456788664)],
    ),
    (
        crate::EncodedStr::Ascii("evangelisations"),
        &[(0b10010, &ENTRY_EVANGELIZATIONS_14789777873996157817)],
    ),
    (
        crate::EncodedStr::Ascii("evangelise"),
        &[(0b10010, &ENTRY_EVANGELIZE_14654810833594718867)],
    ),
    (
        crate::EncodedStr::Ascii("evangelised"),
        &[(0b10010, &ENTRY_EVANGELIZED_17876535001172708816)],
    ),
    (
        crate::EncodedStr::Ascii("evangeliser"),
        &[(0b10010, &ENTRY_EVANGELIZER_23648629311545236)],
    ),
    (
        crate::EncodedStr::Ascii("evangelisers"),
        &[(0b10010, &ENTRY_EVANGELIZERS_14546686203602221124)],
    ),
    (
        crate::EncodedStr::Ascii("evangelises"),
        &[(0b10010, &ENTRY_EVANGELIZES_1437826998377524710)],
    ),
    (
        crate::EncodedStr::Ascii("evangelising"),
        &[(0b10010, &ENTRY_EVANGELIZING_16366309279292917989)],
    ),
    (
        crate::EncodedStr::Ascii("evangelization"),
        &[(0b01001, &ENTRY_EVANGELIZATION_4680427557456788664)],
    ),
    (
        crate::EncodedStr::Ascii("evangelizations"),
        &[(0b01001, &ENTRY_EVANGELIZATIONS_14789777873996157817)],
    ),
    (
        crate::EncodedStr::Ascii("evangelize"),
        &[(0b01001, &ENTRY_EVANGELIZE_14654810833594718867)],
    ),
    (
        crate::EncodedStr::Ascii("evangelized"),
        &[(0b01001, &ENTRY_EVANGELIZED_17876535001172708816)],
    ),
    (
        crate::EncodedStr::Ascii("evangelizer"),
        &[(0b01001, &ENTRY_EVANGELIZER_23648629311545236)],
    ),
    (
        crate::EncodedStr::Ascii("evangelizers"),
        &[(0b01001, &ENTRY_EVANGELIZERS_14546686203602221124)],
    ),
    (
        crate::EncodedStr::Ascii("evangelizes"),
        &[(0b01001, &ENTRY_EVANGELIZES_1437826998377524710)],
    ),
    (
        crate::EncodedStr::Ascii("evangelizing"),
        &[(0b01001, &ENTRY_EVANGELIZING_16366309279292917989)],
    ),
    (
        crate::EncodedStr::Ascii("eventualise"),
        &[(0b10010, &ENTRY_EVENTUALIZE_367328542530437546)],
    ),
    (
        crate::EncodedStr::Ascii("eventualised"),
        &[(0b10010, &ENTRY_EVENTUALIZED_6892945154115451414)],
    ),
    (
        crate::EncodedStr::Ascii("eventualises"),
        &[(0b10010, &ENTRY_EVENTUALIZES_2708156416876716226)],
    ),
    (
        crate::EncodedStr::Ascii("eventualising"),
        &[(0b10010, &ENTRY_EVENTUALIZING_3264561079067185461)],
    ),
    (
        crate::EncodedStr::Ascii("eventualize"),
        &[(0b01001, &ENTRY_EVENTUALIZE_367328542530437546)],
    ),
    (
        crate::EncodedStr::Ascii("eventualized"),
        &[(0b01001, &ENTRY_EVENTUALIZED_6892945154115451414)],
    ),
    (
        crate::EncodedStr::Ascii("eventualizes"),
        &[(0b01001, &ENTRY_EVENTUALIZES_2708156416876716226)],
    ),
    (
        crate::EncodedStr::Ascii("eventualizing"),
        &[(0b01001, &ENTRY_EVENTUALIZING_3264561079067185461)],
    ),
    (
        crate::EncodedStr::Ascii("eviler"),
        &[(0b00001, &ENTRY_EVILER_16165460214642184499)],
    ),
    (
        crate::EncodedStr::Ascii("evilest"),
        &[(0b00001, &ENTRY_EVILEST_2003136876659939656)],
    ),
    (
        crate::EncodedStr::Ascii("eviller"),
        &[(0b11010, &ENTRY_EVILER_16165460214642184499)],
    ),
    (
        crate::EncodedStr::Ascii("evillest"),
        &[(0b11010, &ENTRY_EVILEST_2003136876659939656)],
    ),
    (
        crate::EncodedStr::Ascii("eviternal"),
        &[(0b00001, &ENTRY_EVITERNAL_11859651719653588022)],
    ),
    (
        crate::EncodedStr::Ascii("evolutionise"),
        &[(0b10010, &ENTRY_EVOLUTIONIZE_8517112820891861723)],
    ),
    (
        crate::EncodedStr::Ascii("evolutionises"),
        &[(0b10010, &ENTRY_EVOLUTIONIZES_7496995105206806629)],
    ),
    (
        crate::EncodedStr::Ascii("evolutionize"),
        &[(0b01001, &ENTRY_EVOLUTIONIZE_8517112820891861723)],
    ),
    (
        crate::EncodedStr::Ascii("evolutionizes"),
        &[(0b01001, &ENTRY_EVOLUTIONIZES_7496995105206806629)],
    ),
    (
        crate::EncodedStr::Ascii("exaestuate"),
        &[(0b11010, &ENTRY_EXESTUATE_9637260798228903273)],
    ),
    (
        crate::EncodedStr::Ascii("excursionise"),
        &[(0b10010, &ENTRY_EXCURSIONIZE_6141947279836282456)],
    ),
    (
        crate::EncodedStr::Ascii("excursionised"),
        &[(0b10010, &ENTRY_EXCURSIONIZED_1665688933464332989)],
    ),
    (
        crate::EncodedStr::Ascii("excursionises"),
        &[(0b10010, &ENTRY_EXCURSIONIZES_8190667252177395210)],
    ),
    (
        crate::EncodedStr::Ascii("excursionising"),
        &[(0b10010, &ENTRY_EXCURSIONIZING_17254186462773543752)],
    ),
    (
        crate::EncodedStr::Ascii("excursionize"),
        &[(0b01001, &ENTRY_EXCURSIONIZE_6141947279836282456)],
    ),
    (
        crate::EncodedStr::Ascii("excursionized"),
        &[(0b01001, &ENTRY_EXCURSIONIZED_1665688933464332989)],
    ),
    (
        crate::EncodedStr::Ascii("excursionizes"),
        &[(0b01001, &ENTRY_EXCURSIONIZES_8190667252177395210)],
    ),
    (
        crate::EncodedStr::Ascii("excursionizing"),
        &[(0b01001, &ENTRY_EXCURSIONIZING_17254186462773543752)],
    ),
    (
        crate::EncodedStr::Ascii("exestuate"),
        &[(0b00001, &ENTRY_EXESTUATE_9637260798228903273)],
    ),
    (
        crate::EncodedStr::Ascii("exhibitionise"),
        &[(0b10010, &ENTRY_EXHIBITIONIZE_8148713998545988736)],
    ),
    (
        crate::EncodedStr::Ascii("exhibitionises"),
        &[(0b10010, &ENTRY_EXHIBITIONIZES_9279135115141727061)],
    ),
    (
        crate::EncodedStr::Ascii("exhibitionize"),
        &[(0b01001, &ENTRY_EXHIBITIONIZE_8148713998545988736)],
    ),
    (
        crate::EncodedStr::Ascii("exhibitionizes"),
        &[(0b01001, &ENTRY_EXHIBITIONIZES_9279135115141727061)],
    ),
    (
        crate::EncodedStr::Ascii("existentialise"),
        &[(0b10010, &ENTRY_EXISTENTIALIZE_7223214416858975418)],
    ),
    (
        crate::EncodedStr::Ascii("existentialises"),
        &[(0b10010, &ENTRY_EXISTENTIALIZES_8959667143883061799)],
    ),
    (
        crate::EncodedStr::Ascii("existentialize"),
        &[(0b01001, &ENTRY_EXISTENTIALIZE_7223214416858975418)],
    ),
    (
        crate::EncodedStr::Ascii("existentializes"),
        &[(0b01001, &ENTRY_EXISTENTIALIZES_8959667143883061799)],
    ),
    (
        crate::EncodedStr::Ascii("exorcisation"),
        &[(0b10010, &ENTRY_EXORCIZATION_7841196157883660249)],
    ),
    (
        crate::EncodedStr::Ascii("exorcisement"),
        &[(0b10010, &ENTRY_EXORCIZEMENT_13755936147137266553)],
    ),
    (
        crate::EncodedStr::Ascii("exorciser"),
        &[(0b10010, &ENTRY_EXORCIZER_10300614530359206460)],
    ),
    (
        crate::EncodedStr::Ascii("exorcisers"),
        &[(0b10010, &ENTRY_EXORCIZERS_15464358492441086034)],
    ),
    (
        crate::EncodedStr::Ascii("exorcization"),
        &[(0b01001, &ENTRY_EXORCIZATION_7841196157883660249)],
    ),
    (
        crate::EncodedStr::Ascii("exorcize"),
        &[(0b01001, &ENTRY_EXORCISE_9017869478115489494)],
    ),
    (
        crate::EncodedStr::Ascii("exorcized"),
        &[(0b01001, &ENTRY_EXORCISED_12908864464482354367)],
    ),
    (
        crate::EncodedStr::Ascii("exorcizement"),
        &[(0b01001, &ENTRY_EXORCIZEMENT_13755936147137266553)],
    ),
    (
        crate::EncodedStr::Ascii("exorcizer"),
        &[(0b01001, &ENTRY_EXORCIZER_10300614530359206460)],
    ),
    (
        crate::EncodedStr::Ascii("exorcizers"),
        &[(0b01001, &ENTRY_EXORCIZERS_15464358492441086034)],
    ),
    (
        crate::EncodedStr::Ascii("exorcizes"),
        &[(0b01001, &ENTRY_EXORCISES_3937603215249944418)],
    ),
    (
        crate::EncodedStr::Ascii("exorcizing"),
        &[(0b01001, &ENTRY_EXORCISING_9037133836520531203)],
    ),
    (
        crate::EncodedStr::Ascii("experimentalise"),
        &[(0b10010, &ENTRY_EXPERIMENTALIZE_7321825952497189376)],
    ),
    (
        crate::EncodedStr::Ascii("experimentalised"),
        &[(0b10010, &ENTRY_EXPERIMENTALIZED_3235996828077232088)],
    ),
    (
        crate::EncodedStr::Ascii("experimentalises"),
        &[(0b10010, &ENTRY_EXPERIMENTALIZES_17353857217605159387)],
    ),
    (
        crate::EncodedStr::Ascii("experimentalising"),
        &[(0b10010, &ENTRY_EXPERIMENTALIZING_8250407124148404694)],
    ),
    (
        crate::EncodedStr::Ascii("experimentalize"),
        &[(0b01001, &ENTRY_EXPERIMENTALIZE_7321825952497189376)],
    ),
    (
        crate::EncodedStr::Ascii("experimentalized"),
        &[(0b01001, &ENTRY_EXPERIMENTALIZED_3235996828077232088)],
    ),
    (
        crate::EncodedStr::Ascii("experimentalizes"),
        &[(0b01001, &ENTRY_EXPERIMENTALIZES_17353857217605159387)],
    ),
    (
        crate::EncodedStr::Ascii("experimentalizing"),
        &[(0b01001, &ENTRY_EXPERIMENTALIZING_8250407124148404694)],
    ),
    (
        crate::EncodedStr::Ascii("experimentise"),
        &[(0b10010, &ENTRY_EXPERIMENTIZE_12814319320920140623)],
    ),
    (
        crate::EncodedStr::Ascii("experimentises"),
        &[(0b10010, &ENTRY_EXPERIMENTIZES_9176567868167120281)],
    ),
    (
        crate::EncodedStr::Ascii("experimentize"),
        &[(0b01001, &ENTRY_EXPERIMENTIZE_12814319320920140623)],
    ),
    (
        crate::EncodedStr::Ascii("experimentizes"),
        &[(0b01001, &ENTRY_EXPERIMENTIZES_9176567868167120281)],
    ),
    (
        crate::EncodedStr::Ascii("expertised"),
        &[(0b10010, &ENTRY_EXPERTIZED_9523121825282850630)],
    ),
    (
        crate::EncodedStr::Ascii("expertising"),
        &[(0b10010, &ENTRY_EXPERTIZING_14124314311673129338)],
    ),
    (
        crate::EncodedStr::Ascii("expertized"),
        &[(0b01001, &ENTRY_EXPERTIZED_9523121825282850630)],
    ),
    (
        crate::EncodedStr::Ascii("expertizing"),
        &[(0b01001, &ENTRY_EXPERTIZING_14124314311673129338)],
    ),
    (
        crate::EncodedStr::Ascii("exsiccatae"),
        &[(0b11010, &ENTRY_EXSICCATE_17097371061751609281)],
    ),
    (
        crate::EncodedStr::Ascii("exsiccate"),
        &[(0b00001, &ENTRY_EXSICCATE_17097371061751609281)],
    ),
    (
        crate::EncodedStr::Ascii("extemporisation"),
        &[(0b10010, &ENTRY_EXTEMPORIZATION_6498516717162293633)],
    ),
    (
        crate::EncodedStr::Ascii("extemporisations"),
        &[(0b10010, &ENTRY_EXTEMPORIZATIONS_17970202292616391802)],
    ),
    (
        crate::EncodedStr::Ascii("extemporise"),
        &[(0b10010, &ENTRY_EXTEMPORIZE_8490706080912375039)],
    ),
    (
        crate::EncodedStr::Ascii("extemporised"),
        &[(0b10010, &ENTRY_EXTEMPORIZED_8884254797509015457)],
    ),
    (
        crate::EncodedStr::Ascii("extemporiser"),
        &[(0b10010, &ENTRY_EXTEMPORIZER_15042169661772082145)],
    ),
    (
        crate::EncodedStr::Ascii("extemporisers"),
        &[(0b10010, &ENTRY_EXTEMPORIZERS_10144332391226789510)],
    ),
    (
        crate::EncodedStr::Ascii("extemporises"),
        &[(0b10010, &ENTRY_EXTEMPORIZES_10662898516430920590)],
    ),
    (
        crate::EncodedStr::Ascii("extemporising"),
        &[(0b10010, &ENTRY_EXTEMPORIZING_10937023320075355586)],
    ),
    (
        crate::EncodedStr::Ascii("extemporization"),
        &[(0b01001, &ENTRY_EXTEMPORIZATION_6498516717162293633)],
    ),
    (
        crate::EncodedStr::Ascii("extemporizations"),
        &[(0b01001, &ENTRY_EXTEMPORIZATIONS_17970202292616391802)],
    ),
    (
        crate::EncodedStr::Ascii("extemporize"),
        &[(0b01001, &ENTRY_EXTEMPORIZE_8490706080912375039)],
    ),
    (
        crate::EncodedStr::Ascii("extemporized"),
        &[(0b01001, &ENTRY_EXTEMPORIZED_8884254797509015457)],
    ),
    (
        crate::EncodedStr::Ascii("extemporizer"),
        &[(0b01001, &ENTRY_EXTEMPORIZER_15042169661772082145)],
    ),
    (
        crate::EncodedStr::Ascii("extemporizers"),
        &[(0b01001, &ENTRY_EXTEMPORIZERS_10144332391226789510)],
    ),
    (
        crate::EncodedStr::Ascii("extemporizes"),
        &[(0b01001, &ENTRY_EXTEMPORIZES_10662898516430920590)],
    ),
    (
        crate::EncodedStr::Ascii("extemporizing"),
        &[(0b01001, &ENTRY_EXTEMPORIZING_10937023320075355586)],
    ),
    (
        crate::EncodedStr::Ascii("exteriorisation"),
        &[(0b10010, &ENTRY_EXTERIORIZATION_8592258252267171531)],
    ),
    (
        crate::EncodedStr::Ascii("exteriorisations"),
        &[(0b10010, &ENTRY_EXTERIORIZATIONS_10258294511167010008)],
    ),
    (
        crate::EncodedStr::Ascii("exteriorise"),
        &[(0b10010, &ENTRY_EXTERIORIZE_6928562918919697659)],
    ),
    (
        crate::EncodedStr::Ascii("exteriorised"),
        &[(0b10010, &ENTRY_EXTERIORIZED_2593224941672461767)],
    ),
    (
        crate::EncodedStr::Ascii("exteriorises"),
        &[(0b10010, &ENTRY_EXTERIORIZES_10941715232314771538)],
    ),
    (
        crate::EncodedStr::Ascii("exteriorising"),
        &[(0b10010, &ENTRY_EXTERIORIZING_3361516313097201672)],
    ),
    (
        crate::EncodedStr::Ascii("exteriorization"),
        &[(0b01001, &ENTRY_EXTERIORIZATION_8592258252267171531)],
    ),
    (
        crate::EncodedStr::Ascii("exteriorizations"),
        &[(0b01001, &ENTRY_EXTERIORIZATIONS_10258294511167010008)],
    ),
    (
        crate::EncodedStr::Ascii("exteriorize"),
        &[(0b01001, &ENTRY_EXTERIORIZE_6928562918919697659)],
    ),
    (
        crate::EncodedStr::Ascii("exteriorized"),
        &[(0b01001, &ENTRY_EXTERIORIZED_2593224941672461767)],
    ),
    (
        crate::EncodedStr::Ascii("exteriorizes"),
        &[(0b01001, &ENTRY_EXTERIORIZES_10941715232314771538)],
    ),
    (
        crate::EncodedStr::Ascii("exteriorizing"),
        &[(0b01001, &ENTRY_EXTERIORIZING_3361516313097201672)],
    ),
    (
        crate::EncodedStr::Ascii("externalisation"),
        &[(0b10010, &ENTRY_EXTERNALIZATION_5637241595479106962)],
    ),
    (
        crate::EncodedStr::Ascii("externalisations"),
        &[(0b10010, &ENTRY_EXTERNALIZATIONS_13981636890729920109)],
    ),
    (
        crate::EncodedStr::Ascii("externalise"),
        &[(0b10010, &ENTRY_EXTERNALIZE_6421333850383600915)],
    ),
    (
        crate::EncodedStr::Ascii("externalised"),
        &[(0b10010, &ENTRY_EXTERNALIZED_595019063900238343)],
    ),
    (
        crate::EncodedStr::Ascii("externalises"),
        &[(0b10010, &ENTRY_EXTERNALIZES_11960788314575642832)],
    ),
    (
        crate::EncodedStr::Ascii("externalising"),
        &[(0b10010, &ENTRY_EXTERNALIZING_17289102227300964437)],
    ),
    (
        crate::EncodedStr::Ascii("externalization"),
        &[(0b01001, &ENTRY_EXTERNALIZATION_5637241595479106962)],
    ),
    (
        crate::EncodedStr::Ascii("externalizations"),
        &[(0b01001, &ENTRY_EXTERNALIZATIONS_13981636890729920109)],
    ),
    (
        crate::EncodedStr::Ascii("externalize"),
        &[(0b01001, &ENTRY_EXTERNALIZE_6421333850383600915)],
    ),
    (
        crate::EncodedStr::Ascii("externalized"),
        &[(0b01001, &ENTRY_EXTERNALIZED_595019063900238343)],
    ),
    (
        crate::EncodedStr::Ascii("externalizes"),
        &[(0b01001, &ENTRY_EXTERNALIZES_11960788314575642832)],
    ),
    (
        crate::EncodedStr::Ascii("externalizing"),
        &[(0b01001, &ENTRY_EXTERNALIZING_17289102227300964437)],
    ),
    (
        crate::EncodedStr::Ascii("extoll"),
        &[(0b00001, &ENTRY_EXTOL_17049600042027760409)],
    ),
    (
        crate::EncodedStr::Ascii("extolls"),
        &[(0b00001, &ENTRY_EXTOLS_435999545191713231)],
    ),
    (
        crate::EncodedStr::Ascii("extravert"),
        &[(0b10011, &ENTRY_EXTROVERT_3459138457522989101)],
    ),
    (
        crate::EncodedStr::Ascii("extraverted"),
        &[(0b10011, &ENTRY_EXTROVERTED_9249661851858893561)],
    ),
    (
        crate::EncodedStr::Ascii("extraverts"),
        &[(0b10011, &ENTRY_EXTROVERTS_17343931619747038542)],
    ),
    (
        crate::EncodedStr::Ascii("fabulise"),
        &[(0b10010, &ENTRY_FABULIZE_6554520750007678638)],
    ),
    (
        crate::EncodedStr::Ascii("fabulised"),
        &[(0b10010, &ENTRY_FABULIZED_7556454061259147422)],
    ),
    (
        crate::EncodedStr::Ascii("fabulises"),
        &[(0b10010, &ENTRY_FABULIZES_13117215117496144014)],
    ),
    (
        crate::EncodedStr::Ascii("fabulising"),
        &[(0b10010, &ENTRY_FABULIZING_8547130161556656861)],
    ),
    (
        crate::EncodedStr::Ascii("fabulize"),
        &[(0b01001, &ENTRY_FABULIZE_6554520750007678638)],
    ),
    (
        crate::EncodedStr::Ascii("fabulized"),
        &[(0b01001, &ENTRY_FABULIZED_7556454061259147422)],
    ),
    (
        crate::EncodedStr::Ascii("fabulizes"),
        &[(0b01001, &ENTRY_FABULIZES_13117215117496144014)],
    ),
    (
        crate::EncodedStr::Ascii("fabulizing"),
        &[(0b01001, &ENTRY_FABULIZING_8547130161556656861)],
    ),
    (
        crate::EncodedStr::Ascii("facsimilise"),
        &[(0b10010, &ENTRY_FACSIMILIZE_9828221696654309927)],
    ),
    (
        crate::EncodedStr::Ascii("facsimilises"),
        &[(0b10010, &ENTRY_FACSIMILIZES_13852505000433399295)],
    ),
    (
        crate::EncodedStr::Ascii("facsimilize"),
        &[(0b01001, &ENTRY_FACSIMILIZE_9828221696654309927)],
    ),
    (
        crate::EncodedStr::Ascii("facsimilizes"),
        &[(0b01001, &ENTRY_FACSIMILIZES_13852505000433399295)],
    ),
    (
        crate::EncodedStr::Ascii("factorisation"),
        &[(0b10010, &ENTRY_FACTORIZATION_3182572715959186659)],
    ),
    (
        crate::EncodedStr::Ascii("factorisations"),
        &[(0b10010, &ENTRY_FACTORIZATIONS_16583219313061102178)],
    ),
    (
        crate::EncodedStr::Ascii("factorise"),
        &[(0b10010, &ENTRY_FACTORIZE_8969914975304697583)],
    ),
    (
        crate::EncodedStr::Ascii("factorised"),
        &[(0b10010, &ENTRY_FACTORIZED_15433924875237664508)],
    ),
    (
        crate::EncodedStr::Ascii("factorises"),
        &[(0b10010, &ENTRY_FACTORIZES_7790021725855776528)],
    ),
    (
        crate::EncodedStr::Ascii("factorising"),
        &[(0b10010, &ENTRY_FACTORIZING_6633915971235070053)],
    ),
    (
        crate::EncodedStr::Ascii("factorization"),
        &[(0b01001, &ENTRY_FACTORIZATION_3182572715959186659)],
    ),
    (
        crate::EncodedStr::Ascii("factorizations"),
        &[(0b01001, &ENTRY_FACTORIZATIONS_16583219313061102178)],
    ),
    (
        crate::EncodedStr::Ascii("factorize"),
        &[(0b01001, &ENTRY_FACTORIZE_8969914975304697583)],
    ),
    (
        crate::EncodedStr::Ascii("factorized"),
        &[(0b01001, &ENTRY_FACTORIZED_15433924875237664508)],
    ),
    (
        crate::EncodedStr::Ascii("factorizes"),
        &[(0b01001, &ENTRY_FACTORIZES_7790021725855776528)],
    ),
    (
        crate::EncodedStr::Ascii("factorizing"),
        &[(0b01001, &ENTRY_FACTORIZING_6633915971235070053)],
    ),
    (
        crate::EncodedStr::Ascii("fae"),
        &[(0b11010, &ENTRY_FE_6412855417629126837)],
    ),
    (
        crate::EncodedStr::Ascii("faecal"),
        &[(0b10010, &ENTRY_FECAL_14357706927402634040)],
    ),
    (
        crate::EncodedStr::Ascii("faecalith"),
        &[(0b10010, &ENTRY_FECALITH_1709239582298935153)],
    ),
    (
        crate::EncodedStr::Ascii("faeces"),
        &[(0b11010, &ENTRY_FECES_6588400696084582030)],
    ),
    (
        crate::EncodedStr::Ascii("faecula"),
        &[(0b11010, &ENTRY_FECULA_9980537314701284779)],
    ),
    (
        crate::EncodedStr::Ascii("faeculence"),
        &[(0b11010, &ENTRY_FECULENCE_2631357115871198711)],
    ),
    (
        crate::EncodedStr::Ascii("faedor"),
        &[(0b11010, &ENTRY_FEDOR_8887412529233148008)],
    ),
    (
        crate::EncodedStr::Ascii("faence"),
        &[(0b00001, &ENTRY_FAENCE_6852965957276318244)],
    ),
    (
        crate::EncodedStr::Ascii("fagot"),
        &[
            (0b01001, &ENTRY_FAGOT_12511557487040804077),
            (0b01001, &ENTRY_FAGOT_2908150994909348842),
        ],
    ),
    (
        crate::EncodedStr::Ascii("fagoted"),
        &[(0b01001, &ENTRY_FAGOTED_18130244201646636018)],
    ),
    (
        crate::EncodedStr::Ascii("fagoting"),
        &[(0b01001, &ENTRY_FAGOTING_14091007799386400971)],
    ),
    (
        crate::EncodedStr::Ascii("fagots"),
        &[
            (0b01001, &ENTRY_FAGOTS_13347829079007571091),
            (0b01001, &ENTRY_FAGOTS_9448080982481828615),
        ],
    ),
    (
        crate::EncodedStr::Ascii("faitor"),
        &[(0b00001, &ENTRY_FAITOR_14739031312979666111)],
    ),
    (
        crate::EncodedStr::Ascii("faitors"),
        &[(0b00001, &ENTRY_FAITORS_16017382139132171207)],
    ),
    (
        crate::EncodedStr::Ascii("faitour"),
        &[(0b11010, &ENTRY_FAITOR_14739031312979666111)],
    ),
    (
        crate::EncodedStr::Ascii("faitours"),
        &[(0b11010, &ENTRY_FAITORS_16017382139132171207)],
    ),
    (
        crate::EncodedStr::Ascii("familiarisation"),
        &[(0b10010, &ENTRY_FAMILIARIZATION_7435436227522581935)],
    ),
    (
        crate::EncodedStr::Ascii("familiarisations"),
        &[(0b10010, &ENTRY_FAMILIARIZATIONS_7744496085896785322)],
    ),
    (
        crate::EncodedStr::Ascii("familiarise"),
        &[(0b10010, &ENTRY_FAMILIARIZE_6458271230166262342)],
    ),
    (
        crate::EncodedStr::Ascii("familiarised"),
        &[(0b10010, &ENTRY_FAMILIARIZED_9635879804250335511)],
    ),
    (
        crate::EncodedStr::Ascii("familiariser"),
        &[(0b10010, &ENTRY_FAMILIARIZER_12769069348636773119)],
    ),
    (
        crate::EncodedStr::Ascii("familiarisers"),
        &[(0b10010, &ENTRY_FAMILIARIZERS_8503690372223478730)],
    ),
    (
        crate::EncodedStr::Ascii("familiarises"),
        &[(0b10010, &ENTRY_FAMILIARIZES_15552999136886444100)],
    ),
    (
        crate::EncodedStr::Ascii("familiarising"),
        &[(0b10010, &ENTRY_FAMILIARIZING_3497704747397161180)],
    ),
    (
        crate::EncodedStr::Ascii("familiarisingly"),
        &[(0b10010, &ENTRY_FAMILIARIZINGLY_17102975447523114031)],
    ),
    (
        crate::EncodedStr::Ascii("familiarization"),
        &[(0b01001, &ENTRY_FAMILIARIZATION_7435436227522581935)],
    ),
    (
        crate::EncodedStr::Ascii("familiarizations"),
        &[(0b01001, &ENTRY_FAMILIARIZATIONS_7744496085896785322)],
    ),
    (
        crate::EncodedStr::Ascii("familiarize"),
        &[(0b01001, &ENTRY_FAMILIARIZE_6458271230166262342)],
    ),
    (
        crate::EncodedStr::Ascii("familiarized"),
        &[(0b01001, &ENTRY_FAMILIARIZED_9635879804250335511)],
    ),
    (
        crate::EncodedStr::Ascii("familiarizer"),
        &[(0b01001, &ENTRY_FAMILIARIZER_12769069348636773119)],
    ),
    (
        crate::EncodedStr::Ascii("familiarizers"),
        &[(0b01001, &ENTRY_FAMILIARIZERS_8503690372223478730)],
    ),
    (
        crate::EncodedStr::Ascii("familiarizes"),
        &[(0b01001, &ENTRY_FAMILIARIZES_15552999136886444100)],
    ),
    (
        crate::EncodedStr::Ascii("familiarizing"),
        &[(0b01001, &ENTRY_FAMILIARIZING_3497704747397161180)],
    ),
    (
        crate::EncodedStr::Ascii("familiarizingly"),
        &[(0b01001, &ENTRY_FAMILIARIZINGLY_17102975447523114031)],
    ),
    (
        crate::EncodedStr::Ascii("fanaticise"),
        &[(0b10010, &ENTRY_FANATICIZE_175890918610710058)],
    ),
    (
        crate::EncodedStr::Ascii("fanaticised"),
        &[(0b10010, &ENTRY_FANATICIZED_5234463871342267005)],
    ),
    (
        crate::EncodedStr::Ascii("fanaticises"),
        &[(0b10010, &ENTRY_FANATICIZES_11857074349260388346)],
    ),
    (
        crate::EncodedStr::Ascii("fanaticising"),
        &[(0b10010, &ENTRY_FANATICIZING_13797711926894006340)],
    ),
    (
        crate::EncodedStr::Ascii("fanaticize"),
        &[(0b01001, &ENTRY_FANATICIZE_175890918610710058)],
    ),
    (
        crate::EncodedStr::Ascii("fanaticized"),
        &[(0b01001, &ENTRY_FANATICIZED_5234463871342267005)],
    ),
    (
        crate::EncodedStr::Ascii("fanaticizes"),
        &[(0b01001, &ENTRY_FANATICIZES_11857074349260388346)],
    ),
    (
        crate::EncodedStr::Ascii("fanaticizing"),
        &[(0b01001, &ENTRY_FANATICIZING_13797711926894006340)],
    ),
    (
        crate::EncodedStr::Ascii("fantasise"),
        &[(0b10010, &ENTRY_FANTASIZE_16667407006128337409)],
    ),
    (
        crate::EncodedStr::Ascii("fantasised"),
        &[(0b10010, &ENTRY_FANTASIZED_9815854138753209894)],
    ),
    (
        crate::EncodedStr::Ascii("fantasiser"),
        &[(0b10010, &ENTRY_FANTASIZER_9698455867221961502)],
    ),
    (
        crate::EncodedStr::Ascii("fantasises"),
        &[(0b10010, &ENTRY_FANTASIZES_10834180084204721653)],
    ),
    (
        crate::EncodedStr::Ascii("fantasising"),
        &[(0b10010, &ENTRY_FANTASIZING_17657564354102329164)],
    ),
    (
        crate::EncodedStr::Ascii("fantasize"),
        &[(0b01001, &ENTRY_FANTASIZE_16667407006128337409)],
    ),
    (
        crate::EncodedStr::Ascii("fantasized"),
        &[(0b01001, &ENTRY_FANTASIZED_9815854138753209894)],
    ),
    (
        crate::EncodedStr::Ascii("fantasizer"),
        &[(0b01001, &ENTRY_FANTASIZER_9698455867221961502)],
    ),
    (
        crate::EncodedStr::Ascii("fantasizes"),
        &[(0b01001, &ENTRY_FANTASIZES_10834180084204721653)],
    ),
    (
        crate::EncodedStr::Ascii("fantasizing"),
        &[(0b01001, &ENTRY_FANTASIZING_17657564354102329164)],
    ),
    (
        crate::EncodedStr::Ascii("faoence"),
        &[(0b11010, &ENTRY_FAENCE_6852965957276318244)],
    ),
    (
        crate::EncodedStr::Ascii("faradisation"),
        &[(0b10010, &ENTRY_FARADIZATION_15891788669706277797)],
    ),
    (
        crate::EncodedStr::Ascii("faradisations"),
        &[(0b10010, &ENTRY_FARADIZATIONS_4526439476664692216)],
    ),
    (
        crate::EncodedStr::Ascii("faradise"),
        &[(0b10010, &ENTRY_FARADIZE_13316438844181300579)],
    ),
    (
        crate::EncodedStr::Ascii("faradised"),
        &[(0b10010, &ENTRY_FARADIZED_2216631753438049544)],
    ),
    (
        crate::EncodedStr::Ascii("faradiser"),
        &[(0b10010, &ENTRY_FARADIZER_12209074437517416364)],
    ),
    (
        crate::EncodedStr::Ascii("faradisers"),
        &[(0b10010, &ENTRY_FARADIZERS_96577301703372931)],
    ),
    (
        crate::EncodedStr::Ascii("faradises"),
        &[(0b10010, &ENTRY_FARADIZES_516381975059492431)],
    ),
    (
        crate::EncodedStr::Ascii("faradising"),
        &[(0b10010, &ENTRY_FARADIZING_7236430722652054967)],
    ),
    (
        crate::EncodedStr::Ascii("faradization"),
        &[(0b01001, &ENTRY_FARADIZATION_15891788669706277797)],
    ),
    (
        crate::EncodedStr::Ascii("faradizations"),
        &[(0b01001, &ENTRY_FARADIZATIONS_4526439476664692216)],
    ),
    (
        crate::EncodedStr::Ascii("faradize"),
        &[(0b01001, &ENTRY_FARADIZE_13316438844181300579)],
    ),
    (
        crate::EncodedStr::Ascii("faradized"),
        &[(0b01001, &ENTRY_FARADIZED_2216631753438049544)],
    ),
    (
        crate::EncodedStr::Ascii("faradizer"),
        &[(0b01001, &ENTRY_FARADIZER_12209074437517416364)],
    ),
    (
        crate::EncodedStr::Ascii("faradizers"),
        &[(0b01001, &ENTRY_FARADIZERS_96577301703372931)],
    ),
    (
        crate::EncodedStr::Ascii("faradizes"),
        &[(0b01001, &ENTRY_FARADIZES_516381975059492431)],
    ),
    (
        crate::EncodedStr::Ascii("faradizing"),
        &[(0b01001, &ENTRY_FARADIZING_7236430722652054967)],
    ),
    (
        crate::EncodedStr::Ascii("fasciolae"),
        &[(0b11010, &ENTRY_FASCIOLE_7639436908568338351)],
    ),
    (
        crate::EncodedStr::Ascii("fasciole"),
        &[(0b00001, &ENTRY_FASCIOLE_7639436908568338351)],
    ),
    (
        crate::EncodedStr::Ascii("fascisticisation"),
        &[(0b10010, &ENTRY_FASCISTICIZATION_4858667405774331216)],
    ),
    (
        crate::EncodedStr::Ascii("fascisticisations"),
        &[(0b10010, &ENTRY_FASCISTICIZATIONS_18053530396662800587)],
    ),
    (
        crate::EncodedStr::Ascii("fascisticise"),
        &[(0b10010, &ENTRY_FASCISTICIZE_8685639468575663113)],
    ),
    (
        crate::EncodedStr::Ascii("fascisticises"),
        &[(0b10010, &ENTRY_FASCISTICIZES_5781725162251103852)],
    ),
    (
        crate::EncodedStr::Ascii("fascisticization"),
        &[(0b01001, &ENTRY_FASCISTICIZATION_4858667405774331216)],
    ),
    (
        crate::EncodedStr::Ascii("fascisticizations"),
        &[(0b01001, &ENTRY_FASCISTICIZATIONS_18053530396662800587)],
    ),
    (
        crate::EncodedStr::Ascii("fascisticize"),
        &[(0b01001, &ENTRY_FASCISTICIZE_8685639468575663113)],
    ),
    (
        crate::EncodedStr::Ascii("fascisticizes"),
        &[(0b01001, &ENTRY_FASCISTICIZES_5781725162251103852)],
    ),
    (
        crate::EncodedStr::Ascii("fascistisation"),
        &[(0b10010, &ENTRY_FASCISTIZATION_6926224020620442283)],
    ),
    (
        crate::EncodedStr::Ascii("fascistisations"),
        &[(0b10010, &ENTRY_FASCISTIZATIONS_3946675109662693253)],
    ),
    (
        crate::EncodedStr::Ascii("fascistise"),
        &[(0b10010, &ENTRY_FASCISTIZE_11043251862767140703)],
    ),
    (
        crate::EncodedStr::Ascii("fascistised"),
        &[(0b10010, &ENTRY_FASCISTIZED_17858786995192876357)],
    ),
    (
        crate::EncodedStr::Ascii("fascistises"),
        &[(0b10010, &ENTRY_FASCISTIZES_10726309171561350516)],
    ),
    (
        crate::EncodedStr::Ascii("fascistising"),
        &[(0b10010, &ENTRY_FASCISTIZING_14842848351094053038)],
    ),
    (
        crate::EncodedStr::Ascii("fascistization"),
        &[(0b01001, &ENTRY_FASCISTIZATION_6926224020620442283)],
    ),
    (
        crate::EncodedStr::Ascii("fascistizations"),
        &[(0b01001, &ENTRY_FASCISTIZATIONS_3946675109662693253)],
    ),
    (
        crate::EncodedStr::Ascii("fascistize"),
        &[(0b01001, &ENTRY_FASCISTIZE_11043251862767140703)],
    ),
    (
        crate::EncodedStr::Ascii("fascistized"),
        &[(0b01001, &ENTRY_FASCISTIZED_17858786995192876357)],
    ),
    (
        crate::EncodedStr::Ascii("fascistizes"),
        &[(0b01001, &ENTRY_FASCISTIZES_10726309171561350516)],
    ),
    (
        crate::EncodedStr::Ascii("fascistizing"),
        &[(0b01001, &ENTRY_FASCISTIZING_14842848351094053038)],
    ),
    (
        crate::EncodedStr::Ascii("fashionise"),
        &[(0b10010, &ENTRY_FASHIONIZE_9487132676031513779)],
    ),
    (
        crate::EncodedStr::Ascii("fashionises"),
        &[(0b10010, &ENTRY_FASHIONIZES_12948391454225982571)],
    ),
    (
        crate::EncodedStr::Ascii("fashionize"),
        &[(0b01001, &ENTRY_FASHIONIZE_9487132676031513779)],
    ),
    (
        crate::EncodedStr::Ascii("fashionizes"),
        &[(0b01001, &ENTRY_FASHIONIZES_12948391454225982571)],
    ),
    (
        crate::EncodedStr::Ascii("fatalise"),
        &[(0b10010, &ENTRY_FATALIZE_5795723412936271094)],
    ),
    (
        crate::EncodedStr::Ascii("fatalises"),
        &[(0b10010, &ENTRY_FATALIZES_16154483171742069422)],
    ),
    (
        crate::EncodedStr::Ascii("fatalize"),
        &[(0b01001, &ENTRY_FATALIZE_5795723412936271094)],
    ),
    (
        crate::EncodedStr::Ascii("fatalizes"),
        &[(0b01001, &ENTRY_FATALIZES_16154483171742069422)],
    ),
    (
        crate::EncodedStr::Ascii("favor"),
        &[(0b11001, &ENTRY_FAVOR_16174102806904091593)],
    ),
    (
        crate::EncodedStr::Ascii("favorable"),
        &[(0b11001, &ENTRY_FAVORABLE_16585220116684679375)],
    ),
    (
        crate::EncodedStr::Ascii("favorableness"),
        &[(0b11001, &ENTRY_FAVORABLENESS_15076889136273638786)],
    ),
    (
        crate::EncodedStr::Ascii("favorablenesses"),
        &[(0b11001, &ENTRY_FAVORABLENESSES_7104998476741346696)],
    ),
    (
        crate::EncodedStr::Ascii("favorabler"),
        &[(0b11001, &ENTRY_FAVORABLER_7172677352588609327)],
    ),
    (
        crate::EncodedStr::Ascii("favorables"),
        &[(0b11001, &ENTRY_FAVORABLES_8653228504507516682)],
    ),
    (
        crate::EncodedStr::Ascii("favorablest"),
        &[(0b11001, &ENTRY_FAVORABLEST_3654396515225860920)],
    ),
    (
        crate::EncodedStr::Ascii("favorablier"),
        &[(0b11001, &ENTRY_FAVORABLIER_7406446644901287938)],
    ),
    (
        crate::EncodedStr::Ascii("favorabliest"),
        &[(0b11001, &ENTRY_FAVORABLIEST_13749538246766915905)],
    ),
    (
        crate::EncodedStr::Ascii("favorably"),
        &[(0b11001, &ENTRY_FAVORABLY_8642546699578488365)],
    ),
    (
        crate::EncodedStr::Ascii("favored"),
        &[(0b11001, &ENTRY_FAVORED_16162807193690319578)],
    ),
    (
        crate::EncodedStr::Ascii("favoredlier"),
        &[(0b11001, &ENTRY_FAVOREDLIER_5765865123462240199)],
    ),
    (
        crate::EncodedStr::Ascii("favoredliest"),
        &[(0b11001, &ENTRY_FAVOREDLIEST_10832270749334107398)],
    ),
    (
        crate::EncodedStr::Ascii("favoredly"),
        &[(0b11001, &ENTRY_FAVOREDLY_18181324612001665281)],
    ),
    (
        crate::EncodedStr::Ascii("favoredness"),
        &[(0b11001, &ENTRY_FAVOREDNESS_12375820644528192720)],
    ),
    (
        crate::EncodedStr::Ascii("favorednesses"),
        &[(0b11001, &ENTRY_FAVOREDNESSES_13201622995255558661)],
    ),
    (
        crate::EncodedStr::Ascii("favoreds"),
        &[(0b11001, &ENTRY_FAVOREDS_3475186581170652773)],
    ),
    (
        crate::EncodedStr::Ascii("favorer"),
        &[(0b11001, &ENTRY_FAVORER_14571533058900750983)],
    ),
    (
        crate::EncodedStr::Ascii("favorers"),
        &[(0b11001, &ENTRY_FAVORERS_12669438738558310747)],
    ),
    (
        crate::EncodedStr::Ascii("favoress"),
        &[(0b11001, &ENTRY_FAVORESS_10320527329712113257)],
    ),
    (
        crate::EncodedStr::Ascii("favoring"),
        &[(0b11001, &ENTRY_FAVORING_2135325073071899230)],
    ),
    (
        crate::EncodedStr::Ascii("favoringlier"),
        &[(0b11001, &ENTRY_FAVORINGLIER_13234382898335132498)],
    ),
    (
        crate::EncodedStr::Ascii("favoringliest"),
        &[(0b11001, &ENTRY_FAVORINGLIEST_10272028216258766759)],
    ),
    (
        crate::EncodedStr::Ascii("favoringly"),
        &[(0b11001, &ENTRY_FAVORINGLY_11595619512304812227)],
    ),
    (
        crate::EncodedStr::Ascii("favorings"),
        &[(0b11001, &ENTRY_FAVORINGS_8617057820176781510)],
    ),
    (
        crate::EncodedStr::Ascii("favorite"),
        &[(0b11001, &ENTRY_FAVORITE_2808981011176955343)],
    ),
    (
        crate::EncodedStr::Ascii("favoriter"),
        &[(0b11001, &ENTRY_FAVORITER_7692783527526236076)],
    ),
    (
        crate::EncodedStr::Ascii("favorites"),
        &[(0b11001, &ENTRY_FAVORITES_2546901638617062205)],
    ),
    (
        crate::EncodedStr::Ascii("favoritest"),
        &[(0b11001, &ENTRY_FAVORITEST_13292407585100266353)],
    ),
    (
        crate::EncodedStr::Ascii("favoritism"),
        &[(0b11001, &ENTRY_FAVORITISM_14860734505967533306)],
    ),
    (
        crate::EncodedStr::Ascii("favoritisms"),
        &[(0b11001, &ENTRY_FAVORITISMS_11770976052678857781)],
    ),
    (
        crate::EncodedStr::Ascii("favorless"),
        &[(0b11001, &ENTRY_FAVORLESS_5516474921410922467)],
    ),
    (
        crate::EncodedStr::Ascii("favorlesser"),
        &[(0b11001, &ENTRY_FAVORLESSER_9070895795594476859)],
    ),
    (
        crate::EncodedStr::Ascii("favorlesses"),
        &[(0b11001, &ENTRY_FAVORLESSES_8809391561835385510)],
    ),
    (
        crate::EncodedStr::Ascii("favorlessest"),
        &[(0b11001, &ENTRY_FAVORLESSEST_6458711572083420541)],
    ),
    (
        crate::EncodedStr::Ascii("favors"),
        &[(0b11001, &ENTRY_FAVORS_12388610586480585674)],
    ),
    (
        crate::EncodedStr::Ascii("favour"),
        &[(0b11010, &ENTRY_FAVOR_16174102806904091593)],
    ),
    (
        crate::EncodedStr::Ascii("favourable"),
        &[(0b11010, &ENTRY_FAVORABLE_16585220116684679375)],
    ),
    (
        crate::EncodedStr::Ascii("favourableness"),
        &[(0b11010, &ENTRY_FAVORABLENESS_15076889136273638786)],
    ),
    (
        crate::EncodedStr::Ascii("favourablenesses"),
        &[(0b11010, &ENTRY_FAVORABLENESSES_7104998476741346696)],
    ),
    (
        crate::EncodedStr::Ascii("favourabler"),
        &[(0b11010, &ENTRY_FAVORABLER_7172677352588609327)],
    ),
    (
        crate::EncodedStr::Ascii("favourables"),
        &[(0b11010, &ENTRY_FAVORABLES_8653228504507516682)],
    ),
    (
        crate::EncodedStr::Ascii("favourablest"),
        &[(0b11010, &ENTRY_FAVORABLEST_3654396515225860920)],
    ),
    (
        crate::EncodedStr::Ascii("favourablier"),
        &[(0b11010, &ENTRY_FAVORABLIER_7406446644901287938)],
    ),
    (
        crate::EncodedStr::Ascii("favourabliest"),
        &[(0b11010, &ENTRY_FAVORABLIEST_13749538246766915905)],
    ),
    (
        crate::EncodedStr::Ascii("favourably"),
        &[(0b11010, &ENTRY_FAVORABLY_8642546699578488365)],
    ),
    (
        crate::EncodedStr::Ascii("favoured"),
        &[(0b11010, &ENTRY_FAVORED_16162807193690319578)],
    ),
    (
        crate::EncodedStr::Ascii("favouredlier"),
        &[(0b11010, &ENTRY_FAVOREDLIER_5765865123462240199)],
    ),
    (
        crate::EncodedStr::Ascii("favouredliest"),
        &[(0b11010, &ENTRY_FAVOREDLIEST_10832270749334107398)],
    ),
    (
        crate::EncodedStr::Ascii("favouredly"),
        &[(0b11010, &ENTRY_FAVOREDLY_18181324612001665281)],
    ),
    (
        crate::EncodedStr::Ascii("favouredness"),
        &[(0b11010, &ENTRY_FAVOREDNESS_12375820644528192720)],
    ),
    (
        crate::EncodedStr::Ascii("favourednesses"),
        &[(0b11010, &ENTRY_FAVOREDNESSES_13201622995255558661)],
    ),
    (
        crate::EncodedStr::Ascii("favoureds"),
        &[(0b11010, &ENTRY_FAVOREDS_3475186581170652773)],
    ),
    (
        crate::EncodedStr::Ascii("favourer"),
        