// This file is code-genned by typos-vars-codegen
#![allow(clippy::unreadable_literal)]

use unicase::UniCase;

pub type Variants = &'static [&'static str];
pub type VariantsMap = [Variants; 4];

pub fn all_categories() -> crate::CategorySet {
    crate::Category::American
        | crate::Category::BritishIse
        | crate::Category::Canadian
        | crate::Category::Australian
}

pub fn corrections(category: crate::Category, options: VariantsMap) -> &'static [&'static str] {
    match category {
        crate::Category::American => options[0],
        crate::Category::BritishIse => options[1],
        crate::Category::Canadian => options[2],
        crate::Category::Australian => options[3],
        crate::Category::BritishIze | crate::Category::Other => {
            unreachable!("{:?} is unused", category)
        }
    }
}

pub static VARS_DICTIONARY: phf::Map<
    unicase::UniCase<&'static str>,
    &'static [(u8, &VariantsMap)],
> = ::phf::Map {
    key: 3213172566270843353,
    disps: ::phf::Slice::Static(&[
        (0, 204),
        (0, 120),
        (0, 3),
        (0, 0),
        (0, 103),
        (0, 5),
        (0, 0),
        (0, 0),
        (0, 9),
        (0, 9),
        (0, 0),
        (0, 1),
        (0, 3),
        (0, 277),
        (0, 0),
        (0, 2),
        (0, 3),
        (0, 560),
        (0, 127),
        (0, 843),
        (0, 0),
        (0, 593),
        (0, 3),
        (0, 3),
        (0, 84),
        (0, 0),
        (0, 71),
        (0, 53),
        (0, 4),
        (0, 36),
        (0, 2),
        (0, 431),
        (0, 448),
        (0, 674),
        (0, 57),
        (0, 20),
        (0, 5),
        (0, 716),
        (0, 3),
        (0, 7),
        (0, 1),
        (0, 10),
        (0, 117),
        (0, 336),
        (0, 4),
        (0, 644),
        (0, 2),
        (0, 708),
        (0, 19),
        (0, 0),
        (0, 1004),
        (0, 640),
        (0, 16),
        (0, 0),
        (0, 66),
        (0, 123),
        (0, 2),
        (0, 5),
        (0, 7),
        (0, 20),
        (0, 21),
        (0, 252),
        (0, 12),
        (0, 194),
        (0, 47),
        (0, 173),
        (0, 19),
        (0, 762),
        (0, 106),
        (0, 1192),
        (0, 1295),
        (0, 87),
        (0, 14),
        (0, 1133),
        (0, 623),
        (0, 0),
        (0, 3),
        (0, 143),
        (0, 5),
        (0, 192),
        (0, 158),
        (0, 13),
        (0, 31),
        (0, 29),
        (0, 454),
        (0, 5),
        (0, 4),
        (0, 0),
        (0, 235),
        (0, 8),
        (0, 29),
        (0, 877),
        (0, 5),
        (0, 8),
        (0, 77),
        (0, 68),
        (0, 14),
        (0, 70),
        (0, 176),
        (0, 169),
        (0, 5),
        (0, 38),
        (0, 9),
        (0, 130),
        (0, 134),
        (0, 113),
        (0, 30),
        (0, 57),
        (0, 169),
        (0, 16),
        (0, 40),
        (0, 723),
        (0, 50),
        (0, 0),
        (0, 39),
        (0, 0),
        (0, 122),
        (0, 0),
        (0, 11),
        (0, 3853),
        (0, 42),
        (0, 449),
        (0, 324),
        (0, 56),
        (0, 0),
        (0, 54),
        (0, 308),
        (0, 6),
        (0, 23),
        (0, 906),
        (0, 593),
        (0, 241),
        (0, 21),
        (0, 28),
        (0, 1),
        (0, 154),
        (0, 0),
        (0, 16),
        (0, 152),
        (0, 1209),
        (0, 37),
        (0, 15),
        (0, 14),
        (0, 159),
        (0, 592),
        (0, 81),
        (0, 254),
        (0, 61),
        (0, 0),
        (0, 363),
        (0, 15),
        (0, 178),
        (0, 320),
        (0, 57),
        (0, 588),
        (0, 180),
        (0, 8),
        (0, 207),
        (0, 2),
        (0, 218),
        (0, 6),
        (0, 0),
        (0, 528),
        (0, 5),
        (0, 26),
        (0, 217),
        (0, 88),
        (0, 303),
        (0, 4),
        (0, 252),
        (0, 736),
        (0, 35),
        (0, 160),
        (0, 9),
        (0, 210),
        (0, 1),
        (0, 7),
        (0, 75),
        (0, 0),
        (0, 12),
        (0, 345),
        (0, 257),
        (0, 53),
        (0, 66),
        (0, 9),
        (0, 292),
        (0, 6),
        (0, 1112),
        (0, 3),
        (0, 1),
        (0, 25),
        (0, 11),
        (0, 0),
        (0, 302),
        (0, 633),
        (0, 11),
        (0, 59),
        (0, 22),
        (0, 55),
        (0, 5),
        (0, 0),
        (0, 13),
        (0, 45),
        (0, 37),
        (0, 66),
        (0, 45),
        (0, 2),
        (0, 27),
        (0, 66),
        (0, 78),
        (0, 0),
        (0, 45),
        (0, 18),
        (0, 15),
        (0, 255),
        (0, 33),
        (0, 3),
        (0, 69),
        (0, 110),
        (0, 11),
        (0, 46),
        (0, 9),
        (0, 2902),
        (0, 44),
        (0, 461),
        (0, 1815),
        (0, 98),
        (0, 514),
        (0, 1501),
        (0, 0),
        (0, 126),
        (0, 3),
        (0, 24),
        (0, 9),
        (0, 4),
        (0, 100),
        (0, 1074),
        (0, 6),
        (0, 796),
        (0, 13),
        (0, 46),
        (0, 20),
        (0, 2),
        (0, 6),
        (0, 11),
        (0, 25),
        (0, 182),
        (0, 3),
        (0, 1481),
        (0, 18),
        (0, 48),
        (0, 0),
        (0, 0),
        (0, 19),
        (0, 124),
        (0, 79),
        (0, 4),
        (0, 98),
        (0, 0),
        (0, 0),
        (0, 190),
        (0, 103),
        (0, 4877),
        (0, 12),
        (0, 5),
        (0, 29),
        (0, 221),
        (0, 0),
        (0, 3),
        (0, 2),
        (0, 1),
        (0, 2),
        (0, 2),
        (0, 80),
        (0, 1121),
        (0, 1090),
        (0, 828),
        (0, 720),
        (0, 294),
        (0, 19),
        (0, 228),
        (0, 0),
        (0, 1234),
        (0, 5),
        (0, 8),
        (0, 79),
        (0, 17),
        (0, 590),
        (0, 351),
        (0, 115),
        (0, 2835),
        (0, 53),
        (0, 57),
        (0, 1150),
        (0, 27),
        (0, 23),
        (0, 1),
        (0, 8),
        (0, 2612),
        (0, 107),
        (0, 446),
        (0, 926),
        (0, 0),
        (0, 277),
        (0, 3668),
        (0, 78),
        (0, 7),
        (0, 155),
        (0, 277),
        (0, 228),
        (0, 201),
        (0, 8),
        (0, 6),
        (0, 17),
        (0, 142),
        (0, 69),
        (0, 95),
        (0, 1132),
        (0, 12),
        (0, 773),
        (0, 787),
        (0, 10),
        (0, 62),
        (0, 25),
        (0, 87),
        (0, 16),
        (0, 508),
        (0, 4),
        (0, 291),
        (0, 5),
        (0, 89),
        (0, 44),
        (0, 12),
        (0, 77),
        (0, 7),
        (0, 571),
        (0, 0),
        (0, 2),
        (0, 18),
        (0, 10),
        (0, 36),
        (0, 22),
        (0, 14),
        (0, 2),
        (0, 263),
        (0, 2),
        (0, 1),
        (0, 254),
        (0, 0),
        (0, 99),
        (0, 4),
        (0, 6),
        (0, 367),
        (0, 1047),
        (0, 8),
        (0, 594),
        (0, 35),
        (0, 556),
        (0, 35),
        (0, 162),
        (0, 590),
        (0, 10),
        (0, 11),
        (0, 0),
        (0, 982),
        (0, 587),
        (0, 126),
        (0, 13),
        (0, 3),
        (0, 362),
        (0, 3930),
        (0, 199),
        (0, 53),
        (0, 0),
        (0, 12),
        (0, 68),
        (0, 6),
        (0, 0),
        (0, 21),
        (0, 694),
        (0, 88),
        (0, 54),
        (0, 148),
        (0, 402),
        (0, 411),
        (0, 221),
        (0, 216),
        (0, 505),
        (0, 1490),
        (0, 69),
        (0, 0),
        (0, 2),
        (0, 2),
        (0, 23),
        (0, 8),
        (0, 330),
        (0, 693),
        (0, 445),
        (0, 984),
        (0, 3),
        (0, 23),
        (0, 115),
        (0, 12),
        (0, 6),
        (0, 13),
        (0, 2),
        (0, 1),
        (0, 0),
        (0, 83),
        (0, 149),
        (0, 262),
        (0, 59),
        (0, 130),
        (0, 114),
        (0, 160),
        (0, 3),
        (0, 108),
        (0, 45),
        (0, 8),
        (0, 253),
        (0, 11),
        (0, 1022),
        (0, 575),
        (0, 4),
        (0, 240),
        (0, 47),
        (0, 78),
        (0, 54),
        (0, 98),
        (0, 1),
        (0, 2),
        (0, 46),
        (0, 1),
        (0, 56),
        (0, 22),
        (0, 1254),
        (0, 1357),
        (0, 15),
        (0, 9),
        (0, 12),
        (0, 18),
        (0, 0),
        (0, 101),
        (0, 23),
        (0, 10),
        (0, 366),
        (0, 0),
        (0, 161),
        (0, 4),
        (0, 339),
        (0, 205),
        (0, 339),
        (0, 62),
        (0, 4),
        (0, 2347),
        (0, 13),
        (0, 88),
        (0, 233),
        (0, 2275),
        (0, 13),
        (0, 14),
        (0, 113),
        (0, 51),
        (0, 75),
        (0, 2135),
        (0, 397),
        (0, 818),
        (0, 19),
        (0, 67),
        (0, 321),
        (0, 7),
        (0, 203),
        (0, 25),
        (0, 16),
        (0, 154),
        (0, 3178),
        (0, 45),
        (0, 252),
        (0, 45),
        (0, 2),
        (0, 113),
        (0, 172),
        (0, 479),
        (0, 434),
        (0, 12),
        (0, 700),
        (0, 412),
        (0, 17),
        (0, 270),
        (0, 518),
        (0, 2),
        (0, 1171),
        (0, 77),
        (0, 73),
        (0, 0),
        (0, 36),
        (0, 0),
        (0, 63),
        (0, 1),
        (0, 4),
        (0, 10),
        (0, 45),
        (0, 431),
        (0, 54),
        (0, 406),
        (0, 99),
        (0, 22),
        (0, 112),
        (0, 10),
        (0, 0),
        (0, 0),
        (0, 5),
        (0, 916),
        (0, 7),
        (0, 1022),
        (0, 293),
        (0, 0),
        (0, 155),
        (0, 274),
        (0, 2989),
        (0, 170),
        (0, 22),
        (0, 1),
        (0, 498),
        (0, 2),
        (0, 11),
        (0, 203),
        (0, 57),
        (0, 1),
        (0, 3),
        (0, 1),
        (0, 4),
        (0, 1),
        (0, 1123),
        (0, 928),
        (0, 79),
        (0, 0),
        (0, 887),
        (0, 0),
        (0, 477),
        (0, 2032),
        (0, 2367),
        (0, 1358),
        (0, 2),
        (0, 34),
        (0, 203),
        (0, 4),
        (0, 0),
        (0, 309),
        (0, 9),
        (0, 1),
        (0, 1587),
        (0, 261),
        (0, 3),
        (0, 20),
        (0, 0),
        (0, 0),
        (0, 11),
        (0, 126),
        (0, 2),
        (0, 5),
        (0, 289),
        (0, 117),
        (0, 668),
        (0, 21),
        (0, 373),
        (0, 190),
        (0, 195),
        (0, 418),
        (0, 96),
        (0, 50),
        (0, 433),
        (0, 1),
        (0, 313),
        (0, 32),
        (0, 251),
        (0, 35),
        (0, 43),
        (0, 0),
        (0, 37),
        (0, 891),
        (0, 2582),
        (0, 0),
        (0, 45),
        (0, 8),
        (0, 5),
        (0, 1),
        (0, 39),
        (0, 3208),
        (0, 16),
        (0, 17),
        (0, 825),
        (0, 279),
        (0, 69),
        (0, 18),
        (0, 693),
        (0, 6),
        (0, 12),
        (0, 95),
        (0, 92),
        (0, 1),
        (0, 313),
        (0, 6),
        (0, 1153),
        (0, 48),
        (0, 0),
        (0, 376),
        (0, 1),
        (0, 1310),
        (0, 852),
        (0, 0),
        (0, 57),
        (0, 186),
        (0, 23),
        (0, 305),
        (0, 1742),
        (0, 21),
        (0, 227),
        (0, 141),
        (0, 0),
        (0, 0),
        (0, 109),
        (0, 280),
        (0, 0),
        (0, 7),
        (0, 23),
        (0, 610),
        (0, 1043),
        (0, 2),
        (0, 76),
        (0, 166),
        (0, 65),
        (0, 206),
        (0, 116),
        (0, 1684),
        (0, 149),
        (0, 31),
        (0, 3),
        (0, 43),
        (0, 28),
        (0, 1151),
        (0, 10),
        (0, 97),
        (0, 12),
        (0, 4),
        (0, 5),
        (0, 310),
        (0, 78),
        (0, 564),
        (0, 1040),
        (0, 0),
        (0, 0),
        (0, 435),
        (0, 16),
        (0, 79),
        (0, 205),
        (0, 397),
        (0, 592),
        (0, 1205),
        (0, 0),
        (0, 51),
        (0, 40),
        (0, 34),
        (0, 1403),
        (0, 450),
        (0, 133),
        (0, 1128),
        (0, 24),
        (0, 5),
        (0, 1),
        (0, 0),
        (0, 364),
        (0, 51),
        (0, 1),
        (0, 3),
        (0, 74),
        (0, 33),
        (0, 76),
        (0, 145),
        (0, 4),
        (0, 38),
        (0, 1181),
        (0, 0),
        (0, 27),
        (0, 1085),
        (0, 7),
        (0, 578),
        (0, 0),
        (0, 60),
        (0, 47),
        (0, 34),
        (0, 22),
        (0, 300),
        (0, 967),
        (0, 1),
        (0, 204),
        (0, 20),
        (0, 3),
        (0, 80),
        (0, 2645),
        (0, 41),
        (0, 1),
        (0, 118),
        (0, 21),
        (0, 834),
        (0, 72),
        (0, 112),
        (0, 289),
        (0, 15),
        (0, 10),
        (0, 12),
        (0, 99),
        (0, 748),
        (0, 185),
        (0, 13),
        (0, 451),
        (0, 0),
        (0, 2755),
        (0, 251),
        (0, 49),
        (0, 295),
        (0, 104),
        (0, 105),
        (0, 34),
        (0, 155),
        (0, 62),
        (0, 12),
        (0, 3),
        (0, 28),
        (0, 0),
        (0, 4),
        (0, 46),
        (0, 12),
        (0, 66),
        (0, 0),
        (0, 626),
        (0, 18),
        (0, 120),
        (0, 103),
        (0, 11),
        (0, 322),
        (0, 329),
        (0, 9),
        (0, 952),
        (0, 130),
        (0, 1565),
        (0, 574),
        (0, 61),
        (0, 920),
        (0, 171),
        (0, 233),
        (0, 206),
        (0, 14),
        (0, 26),
        (0, 73),
        (0, 2372),
        (0, 2609),
        (0, 25),
        (0, 4),
        (0, 131),
        (0, 739),
        (0, 119),
        (0, 25),
        (0, 70),
        (0, 177),
        (0, 130),
        (0, 29),
        (0, 295),
        (0, 0),
        (0, 3532),
        (0, 1),
        (0, 395),
        (0, 1),
        (0, 149),
        (0, 76),
        (0, 46),
        (0, 34),
        (0, 329),
        (0, 299),
        (0, 1755),
        (0, 48),
        (0, 921),
        (0, 907),
        (0, 433),
        (0, 970),
        (0, 26),
        (0, 2),
        (0, 13),
        (0, 10),
        (0, 22),
        (0, 17),
        (0, 191),
        (0, 54),
        (0, 44),
        (0, 39),
        (0, 5),
        (0, 179),
        (0, 1738),
        (0, 22),
        (0, 1),
        (0, 6),
        (0, 4070),
        (0, 1790),
        (0, 16),
        (0, 7),
        (0, 83),
        (0, 210),
        (0, 245),
        (0, 100),
        (0, 18),
        (0, 728),
        (0, 30),
        (0, 0),
        (0, 129),
        (0, 288),
        (0, 224),
        (0, 238),
        (0, 398),
        (0, 10),
        (0, 0),
        (0, 5),
        (0, 19),
        (0, 1),
        (0, 45),
        (0, 1136),
        (0, 5),
        (0, 13),
        (0, 68),
        (0, 0),
        (0, 164),
        (0, 610),
        (0, 1411),
        (0, 335),
        (0, 4),
        (0, 285),
        (0, 40),
        (0, 0),
        (0, 697),
        (0, 13),
        (0, 23),
        (0, 1133),
        (0, 0),
        (0, 992),
        (0, 1177),
        (0, 6098),
        (0, 0),
        (0, 56),
        (0, 294),
        (0, 81),
        (0, 375),
        (0, 806),
        (0, 0),
        (0, 10),
        (0, 113),
        (0, 25),
        (1, 23),
        (0, 8),
        (0, 1),
        (0, 214),
        (0, 0),
        (0, 12),
        (0, 1),
        (0, 5),
        (0, 406),
        (0, 68),
        (0, 81),
        (0, 320),
        (0, 184),
        (0, 120),
        (0, 39),
        (0, 895),
        (1, 71),
        (0, 757),
        (0, 0),
        (0, 10),
        (0, 297),
        (0, 152),
        (0, 7),
        (0, 228),
        (0, 681),
        (0, 16),
        (0, 5),
        (0, 146),
        (0, 0),
        (0, 31),
        (0, 570),
        (0, 29),
        (0, 0),
        (0, 109),
        (0, 148),
        (0, 7),
        (0, 550),
        (0, 5),
        (0, 1),
        (0, 324),
        (0, 372),
        (0, 12),
        (0, 580),
        (0, 63),
        (0, 129),
        (0, 3),
        (0, 47),
        (0, 4635),
        (0, 0),
        (0, 19),
        (0, 106),
        (0, 167),
        (0, 1230),
        (0, 0),
        (0, 948),
        (0, 2628),
        (0, 3),
        (0, 182),
        (0, 119),
        (0, 1),
        (0, 204),
        (0, 271),
        (0, 53),
        (0, 1254),
        (0, 3),
        (0, 22),
        (0, 0),
        (0, 0),
        (0, 383),
        (0, 1),
        (0, 0),
        (0, 422),
        (0, 2824),
        (0, 393),
        (0, 28),
        (0, 0),
        (0, 26),
        (0, 1),
        (0, 1357),
        (0, 163),
        (0, 7),
        (0, 875),
        (0, 206),
        (0, 11),
        (0, 123),
        (0, 277),
        (0, 508),
        (0, 13),
        (0, 13),
        (0, 2),
        (0, 12),
        (0, 39),
        (0, 31),
        (0, 3),
        (0, 13),
        (0, 15),
        (0, 17),
        (0, 1723),
        (0, 0),
        (0, 503),
        (0, 0),
        (0, 77),
        (0, 350),
        (0, 1677),
        (0, 0),
        (0, 6),
        (0, 934),
        (0, 73),
        (0, 0),
        (0, 4),
        (0, 393),
        (0, 34),
        (0, 4),
        (0, 670),
        (0, 2146),
        (0, 321),
        (0, 739),
        (0, 8),
        (0, 0),
        (0, 83),
        (0, 1),
        (0, 38),
        (0, 967),
        (0, 404),
        (0, 237),
        (0, 73),
        (0, 21),
        (0, 342),
        (0, 0),
        (0, 341),
        (0, 0),
        (0, 2),
        (0, 197),
        (0, 3),
        (0, 330),
        (0, 115),
        (0, 1),
        (0, 46),
        (0, 674),
        (0, 1014),
        (0, 66),
        (0, 0),
        (0, 659),
        (0, 60),
        (0, 1505),
        (0, 264),
        (0, 776),
        (0, 337),
        (0, 890),
        (0, 853),
        (0, 0),
        (0, 294),
        (0, 9),
        (0, 0),
        (0, 362),
        (0, 1172),
        (0, 0),
        (0, 46),
        (0, 1),
        (0, 72),
        (0, 13),
        (0, 22),
        (0, 24),
        (0, 1174),
        (0, 427),
        (0, 59),
        (0, 94),
        (0, 89),
        (0, 3),
        (0, 16),
        (0, 341),
        (0, 8),
        (0, 3),
        (0, 7),
        (0, 1),
        (0, 678),
        (0, 7),
        (0, 193),
        (0, 897),
        (0, 2281),
        (0, 0),
        (0, 346),
        (0, 1327),
        (0, 298),
        (0, 975),
        (0, 29),
        (0, 402),
        (0, 1620),
        (0, 6125),
        (0, 24),
        (0, 293),
        (0, 16),
        (0, 135),
        (0, 3),
        (0, 39),
        (0, 1215),
        (0, 29),
        (0, 9),
        (0, 33),
        (0, 29),
        (0, 24),
        (0, 6),
        (0, 1621),
        (0, 56),
        (0, 7),
        (0, 8),
        (0, 7),
        (0, 0),
        (0, 2),
        (0, 38),
        (0, 176),
        (0, 1069),
        (0, 9),
        (0, 126),
        (0, 119),
        (0, 28),
        (0, 476),
        (0, 157),
        (0, 195),
        (0, 305),
        (0, 2),
        (0, 646),
        (0, 28),
        (0, 20),
        (0, 241),
        (0, 0),
        (0, 0),
        (0, 270),
        (0, 76),
        (0, 77),
        (0, 1218),
        (0, 1),
        (0, 3415),
        (0, 95),
        (0, 32),
        (0, 118),
        (0, 193),
        (0, 4),
        (0, 4),
        (0, 68),
        (0, 195),
        (0, 23),
        (0, 978),
        (0, 42),
        (0, 19),
        (0, 40),
        (0, 124),
        (0, 45),
        (0, 3164),
        (0, 467),
        (0, 363),
        (0, 55),
        (0, 50),
        (0, 1),
        (0, 196),
        (0, 0),
        (0, 1),
        (0, 6),
        (0, 188),
        (0, 638),
        (0, 0),
        (0, 0),
        (0, 7),
        (0, 1432),
        (0, 25),
        (0, 355),
        (0, 59),
        (0, 2),
        (0, 2),
        (0, 215),
        (0, 1623),
        (0, 0),
        (0, 657),
        (0, 296),
        (0, 386),
        (0, 44),
        (0, 326),
        (0, 579),
        (0, 208),
        (0, 42),
        (0, 0),
        (0, 317),
        (0, 73),
        (0, 0),
        (0, 0),
        (0, 58),
        (0, 23),
        (0, 20),
        (0, 260),
        (0, 1642),
        (0, 3),
        (0, 1),
        (0, 0),
        (0, 126),
        (0, 0),
        (0, 566),
        (0, 1),
        (0, 69),
        (0, 25),
        (0, 1253),
        (0, 224),
        (0, 368),
        (0, 533),
        (0, 30),
        (0, 19),
        (0, 10),
        (0, 51),
        (0, 0),
        (0, 196),
        (0, 5),
        (0, 79),
        (0, 422),
        (0, 111),
        (0, 1108),
        (0, 1794),
        (0, 11),
        (0, 13),
        (0, 0),
        (0, 1),
        (0, 37),
        (0, 2940),
        (0, 53),
        (0, 40),
        (0, 522),
        (0, 28),
        (0, 649),
        (0, 14),
        (0, 10),
        (0, 619),
        (0, 455),
        (0, 0),
        (0, 9),
        (0, 282),
        (0, 11),
        (0, 31),
        (0, 0),
        (0, 14),
        (0, 106),
        (0, 228),
        (0, 621),
        (0, 1),
        (0, 387),
        (0, 519),
        (0, 164),
        (0, 85),
        (0, 6),
        (0, 19),
        (0, 118),
        (0, 43),
        (0, 7),
        (0, 67),
        (0, 138),
        (0, 5),
        (0, 8),
        (0, 11),
        (0, 312),
        (0, 10),
        (0, 172),
        (0, 32),
        (0, 1297),
        (0, 27),
        (0, 11),
        (0, 2),
        (0, 2),
        (0, 99),
        (0, 38),
        (0, 101),
        (0, 1),
        (0, 0),
        (0, 809),
        (0, 44),
        (0, 734),
        (0, 1),
        (0, 55),
        (0, 20),
        (0, 757),
        (0, 351),
        (0, 84),
        (0, 777),
        (0, 303),
        (0, 17),
        (0, 856),
        (0, 748),
        (0, 1935),
        (0, 36),
        (0, 94),
        (0, 556),
        (0, 161),
        (0, 166),
        (0, 216),
        (0, 1375),
        (0, 111),
        (0, 439),
        (0, 81),
        (0, 8),
        (0, 1118),
        (0, 299),
        (0, 834),
        (0, 901),
        (0, 25),
        (0, 366),
        (0, 1541),
        (0, 3),
        (0, 91),
        (0, 79),
        (0, 1),
        (0, 270),
        (0, 123),
        (0, 3),
        (0, 236),
        (0, 4),
        (0, 29),
        (0, 38),
        (0, 1625),
        (0, 14),
        (0, 14),
        (0, 15),
        (0, 39),
        (0, 343),
        (0, 789),
        (0, 170),
        (0, 14),
        (0, 1682),
        (0, 0),
        (0, 8),
        (0, 10),
        (0, 1081),
        (0, 0),
        (0, 366),
        (0, 12),
        (0, 226),
        (0, 15),
        (0, 110),
        (0, 1),
        (0, 196),
        (0, 2031),
        (0, 572),
        (0, 1192),
        (0, 40),
        (0, 123),
        (0, 2704),
        (0, 11),
        (0, 48),
        (0, 484),
        (0, 244),
        (0, 493),
        (0, 165),
        (0, 879),
        (0, 39),
        (0, 530),
        (0, 0),
        (0, 524),
        (0, 4508),
        (0, 496),
        (0, 1899),
        (0, 53),
        (0, 1686),
        (0, 0),
        (0, 1534),
        (0, 83),
        (0, 3387),
        (0, 1672),
        (0, 24),
        (0, 206),
        (0, 52),
        (0, 936),
        (0, 48),
        (0, 565),
        (0, 667),
        (0, 12),
        (0, 14),
        (0, 255),
        (0, 5),
        (0, 106),
        (0, 2773),
        (0, 36),
        (0, 23),
        (0, 250),
        (0, 65),
        (0, 274),
        (0, 1),
        (0, 1),
        (0, 556),
        (0, 74),
        (0, 208),
        (0, 210),
        (0, 2),
        (0, 121),
        (0, 8),
        (0, 6),
        (0, 80),
        (0, 337),
        (0, 83),
        (0, 5),
        (0, 6),
        (0, 10),
        (0, 1138),
        (0, 271),
        (0, 97),
        (0, 44),
        (0, 731),
        (0, 8),
        (0, 3),
        (0, 320),
        (0, 177),
        (0, 332),
        (0, 68),
        (0, 7),
        (0, 699),
        (0, 940),
        (0, 56),
        (0, 146),
        (0, 191),
        (0, 736),
        (0, 0),
        (0, 514),
        (0, 603),
        (0, 49),
        (0, 624),
        (0, 193),
        (0, 69),
        (0, 3610),
        (0, 149),
        (0, 3382),
        (0, 496),
        (0, 1490),
        (0, 32),
        (0, 2),
        (0, 0),
        (0, 4),
        (0, 78),
        (0, 538),
        (0, 0),
        (0, 1378),
        (0, 316),
        (0, 406),
        (0, 14),
        (0, 107),
        (0, 46),
        (0, 653),
        (0, 126),
        (0, 20),
        (0, 653),
        (0, 1668),
        (0, 5),
        (0, 278),
        (0, 8),
        (0, 234),
        (0, 6),
        (0, 2667),
        (0, 39),
        (0, 283),
        (0, 3),
        (0, 3945),
        (0, 53),
        (0, 5),
        (0, 565),
        (0, 4),
        (0, 123),
        (0, 6),
        (0, 481),
        (0, 291),
        (0, 475),
        (0, 2),
        (0, 0),
        (0, 1915),
        (0, 5),
        (0, 55),
        (0, 1293),
        (0, 342),
        (0, 26),
        (0, 0),
        (0, 868),
        (0, 5),
        (0, 199),
        (0, 147),
        (0, 8),
        (0, 12),
        (0, 13),
        (0, 30),
        (0, 0),
        (0, 0),
        (0, 55),
        (0, 2),
        (0, 0),
        (0, 0),
        (0, 2),
        (0, 1),
        (0, 0),
        (0, 106),
        (0, 147),
        (0, 13),
        (0, 34),
        (0, 47),
        (0, 1004),
        (0, 3),
        (0, 0),
        (0, 14),
        (0, 1577),
        (0, 1914),
        (0, 13),
        (0, 368),
        (0, 61),
        (0, 123),
        (0, 617),
        (0, 1398),
        (0, 5),
        (0, 2),
        (0, 6),
        (0, 13),
        (0, 10),
        (0, 747),
        (0, 558),
        (0, 0),
        (0, 47),
        (0, 1022),
        (0, 167),
        (0, 15),
        (0, 0),
        (0, 66),
        (0, 298),
        (0, 7),
        (0, 155),
        (0, 84),
        (0, 39),
        (0, 1034),
        (0, 3453),
        (0, 1342),
        (0, 70),
        (0, 62),
        (0, 1036),
        (0, 1050),
        (0, 101),
        (0, 3),
        (0, 1558),
        (0, 1),
        (0, 1),
        (0, 23),
        (0, 271),
        (0, 0),
        (0, 2039),
        (0, 944),
        (0, 146),
        (0, 0),
        (0, 2508),
        (0, 30),
        (0, 345),
        (0, 26),
        (0, 15),
        (0, 1514),
        (0, 2269),
        (0, 623),
        (0, 589),
        (0, 323),
        (0, 41),
        (0, 1),
        (0, 0),
        (0, 234),
        (0, 139),
        (0, 0),
        (0, 177),
        (0, 108),
        (0, 20),
        (0, 0),
        (0, 1),
        (0, 1207),
        (0, 7),
        (0, 15),
        (0, 2),
        (0, 546),
        (0, 9),
        (0, 65),
        (0, 1720),
        (0, 4),
        (0, 436),
        (0, 592),
        (0, 64),
        (0, 249),
        (0, 3),
        (0, 10),
        (0, 79),
        (0, 468),
        (0, 39),
        (0, 0),
        (0, 3),
        (0, 54),
        (0, 996),
        (0, 133),
        (0, 0),
        (0, 587),
        (0, 2),
        (0, 25),
        (0, 106),
        (0, 17),
        (0, 258),
        (0, 8),
        (0, 6),
        (0, 409),
        (0, 1),
        (0, 104),
        (0, 90),
        (0, 36),
        (0, 6),
        (0, 258),
        (0, 1),
        (0, 2),
        (0, 33),
        (0, 1400),
        (0, 1434),
        (0, 370),
        (0, 812),
        (0, 10),
        (0, 0),
        (0, 735),
        (0, 4),
        (0, 0),
        (0, 2),
        (0, 118),
        (0, 74),
        (0, 49),
        (0, 2),
        (0, 0),
        (0, 218),
        (0, 44),
        (0, 129),
        (0, 109),
        (0, 485),
        (0, 65),
        (0, 0),
        (0, 939),
        (0, 3),
        (0, 34),
        (0, 281),
        (0, 11),
        (0, 7),
        (0, 295),
        (0, 747),
        (0, 25),
        (0, 12),
        (0, 45),
        (0, 62),
        (0, 0),
        (0, 124),
        (0, 745),
        (0, 321),
        (0, 131),
        (0, 227),
        (0, 179),
        (0, 29),
        (0, 12),
        (0, 0),
        (0, 1488),
        (0, 1),
        (0, 18),
        (0, 474),
        (0, 24),
        (0, 27),
        (0, 0),
        (0, 0),
        (0, 0),
        (0, 3145),
        (0, 700),
        (0, 19),
        (0, 28),
        (0, 142),
        (0, 1187),
        (0, 37),
        (0, 4),
        (0, 1374),
        (0, 34),
        (0, 1),
        (0, 22),
        (0, 1339),
        (0, 1184),
        (0, 623),
        (0, 22),
        (0, 996),
        (0, 63),
        (0, 1858),
        (0, 408),
        (0, 12),
        (0, 1308),
        (0, 1),
        (0, 6),
        (0, 603),
        (0, 699),
        (0, 664),
        (0, 217),
        (0, 103),
        (0, 1),
        (0, 32),
        (0, 9),
        (0, 4),
        (0, 313),
        (0, 222),
        (0, 0),
        (0, 43),
        (0, 10),
        (0, 0),
        (0, 126),
        (0, 401),
        (0, 398),
        (0, 54),
        (0, 82),
        (0, 22),
        (0, 520),
        (0, 4624),
        (0, 1),
        (0, 38),
        (0, 1422),
        (0, 561),
        (0, 3),
        (0, 536),
        (0, 21),
        (0, 169),
        (0, 303),
        (0, 4),
        (0, 26),
        (0, 512),
        (0, 204),
        (0, 1),
        (0, 1),
        (0, 39),
        (0, 1),
        (0, 99),
        (0, 22),
        (0, 0),
        (0, 6),
        (0, 345),
        (0, 2),
        (0, 1),
        (0, 36),
        (0, 22),
        (0, 35),
        (0, 86),
        (0, 26),
        (0, 11),
        (0, 18),
        (0, 27),
        (0, 31),
        (0, 0),
        (0, 26),
        (0, 377),
        (0, 397),
        (0, 225),
        (0, 178),
        (0, 176),
        (0, 356),
        (0, 22),
        (0, 42),
        (0, 942),
        (0, 358),
        (0, 6),
        (0, 9),
        (0, 406),
        (0, 943),
        (0, 42),
        (0, 706),
        (0, 779),
        (0, 384),
        (0, 49),
        (0, 358),
        (0, 2),
        (0, 4234),
        (0, 331),
        (0, 93),
        (0, 25),
        (0, 1936),
        (0, 11),
        (0, 102),
        (0, 61),
        (0, 325),
        (0, 0),
        (0, 42),
        (0, 80),
        (0, 147),
        (0, 0),
        (0, 789),
        (0, 6),
        (0, 919),
        (0, 8),
        (0, 307),
        (0, 3),
        (0, 271),
        (0, 680),
        (0, 209),
        (0, 995),
        (0, 304),
        (0, 17),
        (0, 51),
        (0, 1424),
        (0, 23),
        (0, 701),
        (0, 4),
        (0, 1),
        (0, 4),
        (0, 0),
        (0, 268),
        (0, 37),
        (0, 1211),
        (0, 195),
        (0, 355),
        (0, 1),
        (0, 36),
        (0, 82),
        (0, 278),
        (0, 1121),
        (0, 5),
        (0, 2),
        (0, 136),
        (0, 311),
        (0, 8),
        (0, 562),
        (0, 139),
        (0, 2640),
        (0, 2),
        (0, 6),
        (0, 55),
        (0, 0),
        (0, 5),
        (0, 26),
        (0, 268),
        (0, 451),
        (0, 0),
        (0, 20),
        (0, 2),
        (0, 25),
        (0, 18),
        (0, 9),
        (0, 252),
        (0, 20),
        (0, 2368),
        (0, 127),
        (0, 0),
        (0, 1),
        (0, 62),
        (0, 2),
        (0, 975),
        (0, 759),
        (0, 35),
        (0, 6),
        (0, 1189),
        (0, 42),
        (0, 225),
        (0, 138),
        (0, 51),
        (0, 174),
        (0, 2017),
        (0, 18),
        (0, 650),
        (0, 78),
        (0, 93),
        (0, 72),
        (0, 570),
        (0, 0),
        (0, 8),
        (0, 389),
        (0, 1285),
        (0, 24),
        (0, 161),
        (0, 3),
        (0, 165),
        (0, 550),
        (0, 228),
        (0, 4),
        (0, 90),
        (0, 80),
        (0, 64),
        (0, 49),
        (0, 4),
        (0, 6),
        (0, 2220),
        (0, 21),
        (0, 0),
        (0, 7),
        (0, 155),
        (0, 0),
        (0, 1),
        (0, 411),
        (0, 6),
        (0, 12),
        (0, 14),
        (0, 329),
        (0, 4649),
        (0, 3895),
        (0, 5),
        (0, 28),
        (0, 2269),
        (0, 49),
        (0, 34),
        (0, 1),
        (0, 11),
        (0, 11),
        (0, 287),
        (0, 8),
        (0, 45),
        (0, 109),
        (0, 117),
        (0, 0),
        (0, 7),
        (0, 1),
        (0, 399),
        (0, 5),
        (0, 55),
        (0, 0),
        (0, 2375),
        (0, 4),
        (0, 23),
        (0, 10),
        (0, 33),
        (0, 8),
        (0, 153),
        (0, 8),
        (0, 221),
        (0, 40),
        (0, 36),
        (0, 156),
        (0, 2371),
        (0, 287),
        (0, 6),
        (0, 24),
        (0, 44),
        (0, 401),
        (0, 26),
        (0, 550),
        (0, 118),
        (0, 2185),
        (0, 6),
        (0, 22),
        (0, 181),
        (0, 1385),
        (0, 840),
        (0, 1158),
        (0, 1),
        (0, 1293),
        (0, 2),
        (0, 1),
        (0, 35),
        (0, 2),
        (0, 1021),
        (0, 284),
        (0, 44),
        (0, 39),
        (0, 18),
        (0, 3),
        (0, 6582),
        (0, 10),
        (0, 256),
        (0, 437),
        (0, 16),
        (0, 226),
        (0, 206),
        (0, 18),
        (0, 341),
        (0, 896),
        (0, 44),
        (0, 16),
        (0, 9),
        (0, 215),
        (0, 65),
        (0, 271),
        (0, 4331),
        (0, 6442),
        (0, 230),
        (0, 42),
        (0, 962),
        (0, 44),
        (0, 185),
        (0, 0),
        (0, 209),
        (0, 87),
        (0, 4),
        (0, 19),
        (0, 20),
        (0, 1249),
        (0, 2),
        (0, 3),
        (0, 0),
        (0, 575),
        (0, 286),
        (0, 199),
        (0, 0),
        (0, 91),
        (0, 644),
        (0, 20),
        (0, 0),
        (0, 164),
        (0, 7),
        (0, 136),
        (0, 1),
        (0, 62),
        (0, 0),
        (0, 49),
        (0, 1),
        (0, 608),
        (0, 116),
        (0, 1833),
        (0, 11),
        (0, 105),
        (0, 211),
        (0, 519),
        (0, 16),
        (0, 26),
        (0, 62),
        (0, 108),
        (0, 665),
        (0, 25),
        (0, 0),
        (0, 1727),
        (0, 50),
        (0, 400),
        (0, 15),
        (0, 2190),
        (0, 698),
        (0, 629),
        (0, 31),
        (0, 411),
        (0, 0),
        (0, 1572),
        (0, 0),
        (0, 0),
        (0, 1),
        (0, 63),
        (0, 2),
        (0, 8),
        (0, 330),
        (0, 0),
        (0, 69),
        (0, 9),
        (0, 31),
        (0, 298),
        (0, 112),
        (0, 41),
        (0, 6058),
        (0, 435),
        (0, 5),
        (0, 208),
        (0, 1166),
        (0, 135),
        (0, 569),
        (0, 714),
        (0, 199),
        (0, 98),
        (0, 5),
        (0, 658),
        (1, 148),
        (0, 665),
        (0, 0),
        (0, 317),
        (0, 29),
        (0, 202),
        (0, 2),
        (0, 226),
        (0, 537),
        (0, 29),
        (0, 128),
        (0, 36),
        (0, 0),
        (0, 4378),
        (0, 73),
        (0, 3),
        (0, 117),
        (0, 326),
        (0, 328),
        (0, 4),
        (0, 1),
        (0, 124),
        (0, 185),
        (0, 855),
        (0, 3),
        (0, 1477),
        (0, 138),
        (0, 15),
        (0, 113),
        (0, 45),
        (0, 1238),
        (0, 31),
        (0, 328),
        (0, 349),
        (0, 11),
        (0, 18),
        (0, 59),
        (0, 941),
        (0, 12),
        (0, 10),
        (0, 3),
        (0, 1),
        (0, 772),
        (0, 9),
        (0, 21),
        (0, 98),
        (0, 0),
        (0, 263),
        (0, 1),
        (0, 41),
        (0, 179),
        (0, 462),
        (0, 22),
        (0, 14),
        (0, 10),
        (0, 4),
        (0, 221),
        (0, 85),
        (0, 204),
        (0, 5),
        (0, 8),
        (0, 7),
        (0, 0),
        (0, 2),
        (0, 1),
        (0, 2),
        (0, 1082),
        (0, 19),
        (0, 4),
        (0, 1),
        (0, 15),
        (0, 6),
        (0, 84),
        (0, 9),
        (0, 5),
        (0, 1996),
        (0, 13),
        (0, 155),
        (0, 590),
        (0, 943),
        (0, 13),
        (0, 21),
        (0, 61),
        (0, 28),
        (0, 1126),
        (0, 269),
        (0, 563),
        (0, 466),
        (0, 494),
        (0, 0),
        (0, 2),
        (0, 6),
        (0, 8),
        (0, 59),
        (0, 798),
        (0, 29),
        (0, 153),
        (0, 3),
        (0, 66),
        (0, 5),
        (0, 0),
        (0, 0),
        (0, 56),
        (0, 76),
        (0, 34),
        (0, 163),
        (0, 404),
        (0, 4726),
        (0, 0),
        (0, 25),
        (0, 0),
        (0, 0),
        (0, 27),
        (0, 601),
        (0, 388),
        (0, 303),
        (0, 0),
        (0, 4),
        (0, 16),
        (0, 2044),
        (0, 59),
        (0, 0),
        (0, 253),
        (0, 629),
        (0, 15),
        (0, 60),
        (0, 12),
        (0, 31),
        (0, 196),
        (0, 0),
        (0, 55),
        (0, 379),
        (0, 1482),
        (0, 5),
        (0, 537),
        (0, 75),
        (0, 223),
        (0, 1),
        (0, 23),
        (0, 1030),
        (0, 155),
        (0, 153),
        (0, 451),
        (0, 1129),
        (0, 15),
        (0, 5),
        (0, 282),
        (0, 113),
        (0, 13),
        (0, 103),
        (0, 603),
        (0, 242),
        (0, 4193),
        (0, 11),
        (0, 1),
        (0, 0),
        (0, 0),
        (0, 56),
        (0, 367),
        (0, 4),
        (0, 32),
        (0, 3920),
        (0, 91),
        (0, 977),
        (0, 144),
        (0, 175),
        (0, 240),
        (0, 644),
        (0, 717),
        (0, 22),
        (0, 14),
        (0, 1870),
        (0, 141),
        (0, 337),
        (0, 90),
        (0, 23),
        (0, 38),
        (0, 169),
        (0, 3),
        (0, 1835),
        (0, 48),
        (0, 258),
        (0, 136),
        (0, 37),
        (0, 3750),
        (0, 742),
        (0, 33),
        (0, 182),
        (0, 9),
        (0, 276),
        (0, 60),
        (0, 1),
        (0, 0),
        (0, 527),
        (0, 929),
        (0, 116),
        (0, 189),
        (0, 0),
        (0, 4),
        (0, 41),
        (0, 248),
        (0, 52),
        (0, 2),
        (0, 223),
        (0, 927),
        (0, 680),
        (0, 77),
        (0, 6615),
        (0, 467),
        (0, 93),
        (0, 0),
        (0, 1),
        (0, 8),
        (0, 3009),
        (0, 84),
        (0, 1),
        (0, 0),
        (0, 8),
        (0, 0),
        (0, 161),
        (0, 1),
        (0, 295),
        (0, 70),
        (0, 23),
        (0, 11),
        (0, 28),
        (0, 2),
        (0, 0),
        (0, 143),
        (0, 1880),
        (0, 1426),
        (0, 0),
        (0, 96),
        (0, 6),
        (0, 3),
        (0, 232),
        (0, 0),
        (0, 60),
        (0, 17),
        (0, 171),
        (0, 1),
        (0, 57),
        (0, 122),
        (0, 181),
        (0, 12),
        (0, 25),
        (0, 4),
        (0, 394),
        (0, 2841),
        (0, 116),
        (0, 725),
        (0, 1),
        (0, 11),
        (0, 566),
        (0, 481),
        (0, 13),
        (0, 168),
        (0, 4),
        (0, 9),
        (0, 2),
        (0, 247),
        (0, 429),
        (0, 80),
        (0, 211),
        (0, 54),
        (0, 3),
        (0, 12),
        (0, 1396),
        (0, 414),
        (0, 17),
        (0, 1),
        (0, 5563),
        (0, 60),
        (0, 10),
        (0, 780),
        (0, 120),
        (0, 24),
        (0, 16),
        (0, 101),
        (0, 1),
        (0, 6),
        (0, 97),
        (0, 21),
        (0, 0),
        (0, 679),
        (0, 173),
        (0, 931),
        (0, 31),
        (0, 4),
        (0, 20),
        (0, 194),
        (0, 47),
        (0, 1),
        (0, 10),
        (0, 6),
        (0, 32),
        (0, 22),
        (0, 239),
        (0, 1619),
        (0, 564),
        (0, 411),
        (0, 1),
        (0, 1),
        (0, 154),
        (0, 631),
        (0, 1412),
        (0, 81),
        (0, 139),
        (0, 2025),
        (0, 6),
        (0, 103),
        (0, 1467),
        (0, 1360),
        (0, 5373),
        (0, 137),
        (0, 30),
        (0, 2),
        (0, 0),
        (0, 2),
        (0, 190),
        (0, 291),
        (0, 3451),
        (0, 3065),
        (0, 3527),
        (0, 1),
        (0, 77),
        (0, 1178),
        (0, 1),
        (0, 7),
        (0, 312),
        (0, 1206),
        (0, 28),
        (0, 1),
        (0, 2334),
        (0, 666),
        (0, 10),
        (0, 2),
        (0, 5),
        (0, 2),
        (0, 0),
        (0, 64),
        (0, 471),
        (0, 5043),
        (0, 224),
        (0, 9),
        (0, 7),
        (0, 1040),
        (0, 0),
        (0, 2),
        (0, 6),
        (0, 2958),
        (0, 239),
        (0, 264),
        (0, 11),
        (0, 13),
        (0, 131),
        (0, 19),
        (0, 0),
        (0, 0),
        (0, 2546),
        (0, 1413),
        (0, 294),
        (0, 18),
        (0, 39),
        (0, 0),
        (0, 14),
        (0, 152),
        (0, 82),
        (0, 1),
        (0, 391),
        (0, 87),
        (0, 145),
        (0, 335),
        (0, 16),
        (0, 0),
        (0, 231),
        (0, 389),
        (0, 11),
        (0, 0),
        (0, 1166),
        (0, 26),
        (0, 86),
        (0, 99),
        (0, 2),
        (0, 1415),
        (0, 10062),
        (0, 104),
        (0, 4),
        (0, 144),
        (0, 31),
        (0, 22),
        (0, 43),
        (0, 1),
        (0, 335),
        (0, 72),
        (0, 286),
        (0, 5),
        (0, 621),
        (0, 0),
        (0, 1),
        (0, 17),
        (0, 249),
        (0, 272),
        (0, 479),
        (0, 422),
        (0, 1531),
        (0, 97),
        (0, 125),
        (0, 4),
        (0, 263),
        (0, 50),
        (0, 3),
        (0, 3399),
        (0, 3176),
        (0, 50),
        (0, 934),
        (0, 335),
        (0, 2),
        (0, 3),
        (0, 34),
        (0, 1787),
        (0, 795),
        (0, 0),
        (0, 0),
        (0, 1),
        (0, 14),
        (0, 8),
        (0, 9),
        (0, 6190),
        (0, 40),
        (0, 362),
        (0, 100),
        (0, 51),
        (0, 145),
        (0, 2),
        (0, 0),
        (0, 103),
        (0, 0),
        (0, 1249),
        (0, 575),
        (0, 115),
        (0, 33),
        (0, 787),
        (0, 102),
        (0, 12),
        (0, 88),
        (0, 14),
        (0, 11),
        (0, 3224),
        (0, 2),
        (0, 1319),
        (0, 16),
        (0, 764),
        (0, 152),
        (0, 6),
        (0, 1),
        (0, 107),
        (0, 364),
        (0, 52),
        (0, 70),
        (0, 114),
        (0, 4),
        (0, 0),
        (0, 79),
        (0, 83),
        (0, 9),
        (0, 11),
        (0, 652),
        (0, 0),
        (0, 1047),
        (0, 10),
        (0, 244),
        (0, 9),
        (0, 1070),
        (0, 228),
        (0, 4703),
        (0, 415),
        (0, 2),
        (0, 168),
        (0, 3),
        (0, 13),
        (0, 1641),
        (0, 101),
        (0, 2),
        (0, 1),
        (0, 405),
        (0, 3),
        (0, 133),
        (0, 2486),
        (0, 35),
        (0, 1778),
        (0, 101),
        (0, 0),
        (0, 37),
        (0, 13),
        (0, 121),
        (0, 757),
        (0, 61),
        (0, 1),
        (0, 4284),
        (0, 17),
        (0, 9),
        (0, 94),
        (0, 1877),
        (0, 66),
        (0, 860),
        (0, 31),
        (0, 680),
        (0, 2177),
        (0, 5280),
        (0, 6),
        (0, 1),
        (0, 154),
        (0, 106),
        (0, 12),
        (0, 2),
        (0, 2180),
        (0, 51),
        (0, 18),
        (0, 68),
        (0, 12),
        (0, 39),
        (0, 163),
        (0, 335),
        (0, 22),
        (0, 85),
        (0, 1302),
        (0, 1512),
        (0, 199),
        (0, 480),
        (0, 1),
        (0, 23),
        (0, 37),
        (0, 0),
        (0, 1),
        (0, 3731),
        (0, 2663),
        (0, 130),
        (0, 7),
        (0, 228),
        (0, 0),
        (0, 541),
        (0, 356),
        (0, 2914),
        (0, 178),
        (0, 63),
        (0, 208),
        (0, 339),
        (0, 8),
        (0, 584),
        (0, 48),
        (0, 19),
        (0, 46),
        (0, 13),
        (0, 2),
        (0, 3),
        (0, 1),
        (0, 7),
        (0, 1034),
        (0, 234),
        (0, 12),
        (0, 12),
        (0, 171),
        (0, 14),
        (0, 555),
        (0, 1479),
        (0, 129),
        (0, 802),
        (0, 85),
        (0, 264),
        (0, 133),
        (0, 361),
        (0, 1568),
        (0, 65),
        (0, 7),
        (0, 209),
        (0, 47),
        (0, 46),
        (0, 9),
        (0, 84),
        (0, 909),
        (0, 9),
        (0, 0),
        (0, 149),
        (0, 3),
        (0, 896),
        (0, 1),
        (0, 4759),
        (0, 122),
        (0, 2282),
        (0, 287),
        (0, 907),
        (0, 1330),
        (0, 3),
        (0, 0),
        (0, 1465),
        (0, 227),
        (0, 106),
        (0, 601),
        (0, 671),
        (0, 286),
        (0, 2),
        (0, 8),
        (0, 301),
        (0, 69),
        (0, 153),
        (0, 66),
        (0, 379),
        (0, 577),
        (0, 51),
        (0, 64),
        (0, 528),
        (0, 2860),
        (0, 833),
        (0, 109),
        (0, 1042),
        (0, 1),
        (0, 486),
        (0, 464),
        (0, 2454),
        (0, 0),
        (0, 640),
        (0, 41),
        (0, 56),
        (0, 19),
        (0, 29),
        (0, 11),
        (0, 95),
        (0, 338),
        (0, 118),
        (0, 83),
        (0, 3),
        (0, 2082),
        (0, 10),
        (0, 1408),
        (0, 104),
        (0, 0),
        (0, 0),
        (0, 0),
        (0, 87),
        (0, 31),
        (0, 256),
        (0, 2159),
        (0, 391),
        (0, 9),
        (0, 1),
        (0, 20),
        (0, 3816),
        (0, 47),
        (0, 251),
        (0, 1249),
        (0, 0),
        (0, 702),
        (0, 649),
        (0, 1399),
        (0, 91),
        (0, 484),
        (0, 17),
        (0, 19),
        (0, 617),
        (0, 981),
        (0, 377),
        (0, 27),
        (0, 237),
        (0, 698),
        (0, 99),
        (0, 312),
        (0, 20),
        (0, 173),
        (0, 1205),
        (0, 1058),
        (0, 2),
        (0, 75),
        (0, 918),
        (0, 3),
        (0, 84),
        (0, 86),
        (0, 23),
        (0, 367),
        (0, 162),
        (0, 1645),
        (0, 1),
        (0, 3),
        (0, 6),
        (0, 358),
        (0, 1068),
        (0, 5),
        (0, 0),
        (0, 32),
        (0, 1860),
        (0, 1469),
        (0, 290),
        (0, 863),
        (0, 1102),
        (0, 1267),
        (0, 1883),
        (0, 3),
        (0, 688),
        (0, 128),
        (0, 34),
        (0, 879),
        (0, 28),
        (0, 80),
        (0, 577),
        (0, 152),
        (0, 238),
        (0, 757),
        (0, 0),
        (0, 304),
        (0, 123),
        (0, 6613),
        (0, 8),
        (0, 1852),
        (0, 300),
        (0, 129),
        (0, 48),
        (0, 92),
        (0, 27),
        (0, 3),
        (0, 0),
        (0, 20),
        (0, 23),
        (0, 3),
        (0, 220),
        (0, 59),
        (0, 9),
        (0, 37),
        (0, 103),
        (0, 0),
        (0, 178),
        (0, 182),
        (0, 318),
        (0, 565),
        (0, 68),
        (0, 89),
        (0, 429),
        (0, 1173),
        (0, 3643),
        (0, 5),
        (0, 0),
        (0, 6),
        (0, 632),
        (0, 0),
        (0, 7),
        (0, 1),
        (0, 44),
        (0, 5),
        (0, 3),
        (0, 820),
        (0, 459),
        (0, 64),
        (0, 520),
        (0, 0),
        (0, 644),
        (0, 13),
        (0, 37),
        (0, 0),
        (0, 15),
        (0, 799),
        (0, 3142),
        (0, 53),
        (0, 0),
        (0, 2),
        (0, 113),
        (0, 14),
        (0, 431),
        (0, 2186),
        (0, 7),
        (0, 189),
        (0, 520),
        (0, 0),
        (0, 10),
        (0, 7),
        (0, 1636),
        (0, 2),
        (0, 320),
        (0, 509),
        (0, 115),
        (0, 124),
        (0, 14),
        (0, 33),
        (0, 1),
        (0, 8),
        (0, 6),
        (0, 1),
        (0, 1232),
        (0, 10),
        (0, 0),
        (0, 75),
        (0, 552),
        (0, 13),
        (0, 24),
        (0, 405),
        (0, 7407),
        (0, 48),
        (0, 0),
        (0, 44),
        (0, 1012),
        (0, 142),
        (0, 119),
        (0, 1230),
        (0, 14),
        (0, 396),
        (0, 1429),
        (0, 2),
        (0, 38),
        (0, 45),
        (0, 6),
        (0, 51),
        (0, 148),
        (0, 3779),
        (0, 33),
        (0, 2665),
        (0, 211),
        (0, 861),
        (0, 12),
        (0, 35),
        (0, 1323),
        (0, 990),
        (0, 15),
        (0, 20),
        (0, 10),
        (0, 291),
        (0, 635),
        (0, 3647),
        (0, 349),
        (0, 2150),
        (0, 6),
        (0, 0),
        (0, 380),
        (0, 91),
        (0, 3175),
        (0, 39),
        (0, 822),
        (0, 285),
        (0, 4),
        (0, 332),
        (0, 132),
        (0, 1328),
        (0, 16),
        (0, 2),
        (0, 120),
        (0, 801),
        (0, 10),
        (0, 1221),
        (0, 2374),
        (0, 6),
        (0, 500),
        (0, 804),
        (0, 5),
        (0, 37),
        (0, 14),
        (0, 81),
        (0, 1992),
        (0, 748),
        (0, 2),
        (0, 55),
        (0, 697),
        (0, 3),
        (0, 140),
        (0, 6850),
        (0, 3658),
        (0, 0),
        (0, 578),
        (0, 17),
        (0, 37),
        (0, 385),
        (0, 741),
        (0, 75),
        (0, 89),
        (0, 373),
        (0, 677),
        (0, 214),
        (0, 115),
        (0, 145),
        (0, 1),
        (0, 0),
        (0, 3),
        (0, 1985),
        (0, 13),
        (0, 207),
        (0, 44),
        (0, 293),
        (0, 323),
        (0, 2025),
        (0, 687),
        (0, 4),
        (0, 14),
        (0, 2120),
        (0, 259),
        (0, 848),
        (0, 4177),
        (0, 1),
        (0, 108),
        (0, 864),
        (0, 882),
        (0, 220),
        (0, 2755),
        (0, 225),
        (0, 4113),
        (0, 1367),
        (0, 7),
        (0, 1501),
        (0, 6),
        (0, 1152),
        (0, 15),
        (0, 2448),
        (0, 305),
        (0, 0),
        (0, 5),
        (0, 0),
        (0, 319),
        (0, 10),
        (0, 5),
        (0, 2020),
        (0, 2002),
        (0, 78),
        (0, 594),
        (0, 598),
        (0, 273),
        (0, 65),
        (0, 250),
        (0, 1),
        (0, 5),
        (0, 1043),
        (0, 35),
        (0, 1348),
        (0, 2090),
        (0, 0),
        (0, 3),
        (0, 3),
        (0, 38),
        (0, 64),
        (0, 51),
        (0, 590),
        (0, 65),
        (0, 1490),
        (0, 83),
        (0, 721),
        (0, 5848),
        (0, 2),
        (0, 92),
        (0, 9),
        (0, 69),
        (0, 101),
        (0, 0),
        (0, 671),
        (0, 103),
        (0, 4),
        (0, 647),
        (0, 87),
        (0, 294),
        (0, 213),
        (0, 11),
        (0, 323),
        (0, 35),
        (0, 476),
        (0, 1526),
        (0, 236),
        (0, 2424),
        (0, 287),
        (0, 7),
        (0, 627),
        (0, 154),
        (0, 8),
        (0, 269),
        (0, 37),
        (0, 7),
        (0, 51),
        (0, 2),
        (0, 3051),
        (0, 4),
        (0, 471),
        (0, 398),
        (0, 64),
        (0, 119),
        (0, 116),
        (0, 326),
        (0, 26),
        (0, 566),
        (0, 9),
        (0, 49),
        (0, 666),
        (0, 624),
        (0, 939),
        (0, 2104),
        (0, 5),
        (0, 454),
        (0, 73),
        (0, 38),
        (0, 1),
        (0, 7),
        (0, 44),
        (0, 439),
        (0, 2414),
        (0, 72),
        (0, 1525),
        (0, 475),
        (0, 0),
        (0, 1),
        (0, 2887),
        (0, 1678),
        (0, 6),
        (0, 5),
        (0, 672),
        (0, 4),
        (0, 747),
        (0, 101),
        (0, 1532),
        (0, 300),
        (0, 122),
        (0, 33),
        (0, 1),
        (0, 1169),
        (0, 223),
        (0, 898),
        (0, 170),
        (0, 1199),
        (0, 1334),
        (0, 1),
        (0, 3),
        (0, 71),
        (0, 34),
        (0, 112),
        (0, 487),
        (0, 568),
        (0, 582),
        (0, 41),
        (0, 877),
        (0, 0),
        (0, 17),
        (0, 38),
        (0, 0),
        (0, 130),
        (0, 1),
        (0, 266),
        (0, 27),
        (0, 25),
        (0, 234),
        (0, 8),
        (0, 962),
        (0, 1103),
        (0, 2591),
        (0, 33),
        (0, 3),
        (0, 934),
        (0, 481),
        (0, 9),
        (0, 71),
        (0, 182),
        (0, 3340),
        (0, 2044),
        (0, 425),
        (0, 145),
        (0, 2206),
        (0, 199),
        (0, 13),
        (0, 0),
        (0, 135),
        (0, 3693),
        (0, 0),
        (0, 31),
        (0, 345),
        (0, 5),
        (0, 400),
        (0, 1501),
        (0, 226),
        (0, 256),
        (0, 1088),
        (0, 11),
        (0, 16),
        (0, 2304),
        (0, 763),
        (0, 463),
        (0, 47),
        (0, 142),
        (0, 27),
        (0, 33),
        (0, 462),
        (0, 3212),
        (0, 1648),
        (0, 779),
        (0, 1),
        (0, 170),
        (0, 718),
        (0, 29),
        (0, 87),
        (0, 7042),
        (0, 2722),
        (0, 27),
        (0, 46),
        (0, 817),
        (0, 337),
        (0, 99),
        (0, 4),
        (0, 3951),
        (0, 2587),
        (0, 86),
        (0, 1424),
        (0, 23),
        (0, 974),
        (0, 61),
        (0, 264),
        (0, 928),
        (0, 18),
        (0, 33),
        (0, 2),
        (0, 1273),
        (0, 494),
        (0, 220),
        (0, 4482),
        (0, 18),
        (0, 233),
        (0, 52),
        (0, 1919),
        (0, 385),
        (0, 4646),
        (0, 2057),
        (0, 135),
        (0, 59),
        (0, 291),
        (0, 2542),
        (0, 39),
        (0, 6592),
        (0, 946),
        (0, 452),
        (0, 319),
        (0, 1642),
        (0, 118),
        (0, 3),
        (0, 3),
        (0, 25),
        (0, 240),
        (0, 12),
        (0, 3133),
        (0, 141),
        (0, 3878),
        (0, 2),
        (0, 20),
        (0, 98),
        (0, 499),
        (0, 160),
        (0, 1260),
        (0, 0),
        (0, 467),
        (0, 546),
        (0, 4),
        (0, 32),
        (0, 72),
        (0, 265),
        (0, 93),
        (0, 90),
        (0, 3783),
        (0, 130),
        (0, 603),
        (0, 1242),
        (0, 1),
        (0, 44),
        (0, 4698),
        (0, 25),
        (0, 31),
        (0, 2990),
        (0, 18),
        (0, 178),
        (0, 17),
        (0, 71),
        (0, 345),
        (0, 104),
        (0, 2530),
        (0, 210),
        (0, 186),
        (0, 194),
        (0, 31),
        (0, 1182),
        (0, 47),
        (0, 6),
        (0, 102),
        (0, 1355),
        (0, 140),
        (0, 0),
        (0, 781),
        (0, 1007),
        (0, 3636),
        (0, 142),
        (0, 102),
        (0, 63),
        (0, 790),
        (0, 379),
        (0, 237),
        (0, 3948),
        (0, 283),
        (0, 3580),
        (0, 175),
        (0, 1826),
        (0, 69),
        (0, 1),
        (0, 16),
        (0, 124),
        (0, 1),
        (0, 2),
        (0, 931),
        (0, 806),
        (0, 24),
        (0, 50),
        (0, 3216),
        (0, 236),
        (0, 12),
        (0, 2683),
        (0, 0),
        (0, 275),
        (0, 2743),
        (0, 1072),
        (0, 0),
        (0, 6),
        (0, 103),
        (0, 1),
        (0, 65),
        (0, 632),
        (0, 1915),
        (0, 1979),
        (0, 112),
        (0, 1527),
        (0, 3437),
        (0, 1897),
        (0, 452),
        (0, 2),
        (0, 4331),
        (0, 3),
        (0, 1),
        (0, 102),
        (0, 118),
        (0, 20),
        (0, 173),
        (0, 6),
        (0, 201),
        (0, 224),
        (0, 301),
        (0, 2222),
        (0, 236),
        (0, 12),
        (0, 2),
        (0, 1947),
        (0, 1617),
        (0, 199),
        (0, 0),
        (0, 40),
        (0, 592),
        (0, 1505),
        (0, 16),
        (0, 1684),
        (0, 604),
        (0, 481),
        (0, 1086),
        (0, 113),
        (0, 105),
        (0, 552),
        (0, 4953),
        (0, 69),
        (0, 111),
        (0, 2307),
        (0, 29),
        (0, 9),
        (0, 4),
        (0, 450),
        (0, 94),
        (0, 25),
        (0, 1109),
        (0, 724),
        (0, 7717),
        (0, 3095),
        (0, 1088),
        (0, 5800),
        (0, 945),
        (0, 43),
        (0, 414),
        (0, 1),
        (0, 929),
        (0, 204),
        (0, 1453),
        (0, 0),
        (0, 30),
        (0, 4),
        (0, 191),
        (0, 0),
        (0, 373),
        (0, 1096),
        (0, 3593),
        (0, 49),
        (0, 3),
        (0, 12),
        (0, 262),
        (0, 50),
        (0, 213),
        (0, 305),
        (0, 72),
        (0, 92),
        (0, 301),
        (0, 1),
        (0, 7),
        (0, 19),
        (0, 7),
        (0, 46),
        (0, 1),
        (0, 873),
        (0, 87),
        (0, 5177),
        (0, 287),
        (0, 361),
        (0, 2416),
        (0, 0),
        (0, 0),
        (0, 4362),
        (0, 7),
        (0, 1307),
        (0, 932),
        (0, 9),
        (0, 1241),
        (0, 1101),
        (0, 76),
        (0, 108),
        (0, 644),
        (0, 3985),
        (0, 1540),
        (0, 1680),
        (0, 565),
        (0, 249),
        (0, 5),
        (0, 167),
        (0, 0),
        (0, 342),
        (0, 7388),
        (0, 77),
        (0, 49),
        (0, 1),
        (0, 3111),
        (0, 2224),
        (0, 72),
        (0, 42),
        (0, 6623),
        (0, 260),
        (0, 997),
        (0, 3),
        (0, 82),
        (0, 642),
        (0, 7),
        (0, 24),
        (0, 3784),
        (0, 1),
        (0, 2832),
        (0, 173),
        (0, 2422),
        (0, 165),
        (0, 273),
        (0, 121),
        (0, 3),
        (0, 4),
        (0, 0),
        (0, 248),
        (0, 208),
        (0, 80),
        (0, 870),
        (0, 0),
        (0, 4),
        (0, 246),
        (0, 4566),
        (0, 9819),
        (0, 250),
        (0, 17),
        (0, 1),
        (0, 2668),
        (0, 2571),
        (0, 18),
        (0, 2676),
        (0, 1118),
        (0, 4684),
        (0, 1434),
        (0, 1165),
        (0, 6),
        (0, 4),
        (0, 340),
        (0, 241),
        (0, 506),
        (0, 7),
        (0, 7755),
        (0, 467),
        (0, 2),
        (0, 51),
        (0, 574),
        (0, 1047),
        (0, 1374),
        (0, 237),
        (0, 6094),
        (0, 0),
        (0, 1),
        (0, 9),
        (0, 4975),
        (0, 47),
        (0, 3),
        (0, 728),
        (0, 2575),
        (0, 11),
        (0, 106),
        (0, 96),
        (0, 6622),
        (0, 117),
        (0, 0),
        (0, 5),
        (0, 11599),
        (0, 4888),
        (0, 194),
        (0, 263),
        (0, 52),
        (0, 931),
        (0, 844),
        (0, 327),
        (0, 1863),
        (0, 4401),
        (0, 1),
        (0, 132),
        (0, 150),
        (0, 0),
        (0, 2188),
        (0, 1),
        (0, 2),
        (0, 3475),
        (0, 5229),
        (0, 605),
        (0, 23),
        (0, 286),
        (0, 1),
        (0, 347),
        (0, 1),
        (0, 1),
        (0, 846),
        (0, 107),
        (0, 2426),
        (0, 4292),
        (0, 112),
        (0, 0),
        (0, 37),
        (0, 441),
        (0, 18),
        (0, 1447),
        (0, 2318),
        (0, 1314),
        (0, 2819),
        (0, 4),
        (0, 52),
        (0, 3687),
        (0, 2),
        (0, 795),
        (0, 1354),
        (0, 48),
        (0, 3),
        (0, 3009),
        (0, 2449),
        (0, 437),
        (0, 54),
        (0, 806),
        (0, 61),
        (0, 5630),
        (0, 329),
        (0, 3),
        (0, 181),
        (0, 1981),
        (0, 328),
        (0, 24),
        (0, 19),
        (0, 1093),
        (0, 94),
        (0, 273),
        (0, 446),
        (0, 385),
        (0, 19),
        (0, 114),
        (0, 0),
        (0, 1),
        (0, 1946),
        (0, 3),
        (0, 439),
        (0, 1478),
        (0, 507),
        (0, 330),
        (0, 3),
        (0, 16),
        (0, 4731),
        (0, 158),
        (0, 23),
        (0, 1094),
        (0, 49),
        (0, 0),
        (0, 8954),
        (0, 107),
        (0, 1178),
        (0, 82),
        (0, 468),
        (0, 3),
        (0, 12001),
        (0, 277),
        (0, 1),
        (0, 3419),
        (0, 17),
        (0, 809),
        (0, 1439),
        (0, 152),
        (0, 3),
        (0, 34),
        (0, 7),
        (0, 2039),
        (0, 4264),
        (0, 373),
        (0, 3951),
        (0, 2),
        (0, 124),
        (0, 0),
        (0, 0),
        (0, 48),
        (0, 4640),
        (0, 159),
        (0, 2487),
        (0, 1867),
        (0, 9),
        (0, 579),
        (0, 2562),
        (0, 8),
        (0, 55),
        (0, 0),
        (0, 818),
        (0, 1381),
        (0, 379),
        (0, 10),
        (0, 37),
        (0, 399),
        (0, 692),
        (0, 2087),
        (0, 3),
        (0, 630),
        (0, 320),
        (0, 16),
        (0, 8858),
        (0, 1056),
        (0, 0),
        (0, 13),
        (0, 13),
        (0, 137),
        (0, 278),
        (0, 4807),
        (0, 12),
        (0, 0),
        (0, 2),
        (0, 4),
        (0, 1386),
        (0, 135),
        (0, 27),
        (0, 101),
        (0, 105),
        (0, 232),
        (0, 4),
        (0, 791),
        (0, 83),
        (0, 11842),
        (0, 753),
        (0, 0),
        (0, 1158),
        (0, 2156),
        (0, 3),
        (0, 0),
        (0, 51),
        (0, 80),
        (0, 2),
        (0, 5),
        (0, 340),
        (0, 0),
        (0, 98),
        (0, 3193),
        (0, 2441),
        (0, 1134),
        (0, 1094),
        (0, 83),
        (0, 13),
        (0, 1),
        (0, 4255),
        (0, 22),
        (0, 145),
        (0, 9),
        (0, 209),
        (0, 1531),
        (0, 8721),
        (0, 852),
        (0, 160),
        (0, 68),
        (0, 3),
        (0, 5),
        (0, 20),
        (0, 924),
        (0, 0),
        (0, 101),
        (0, 2412),
        (0, 0),
        (0, 73),
        (0, 66),
        (0, 13),
        (0, 1133),
        (0, 19),
        (0, 42),
        (0, 741),
        (0, 853),
        (0, 59),
        (0, 0),
        (0, 3658),
        (0, 1883),
        (0, 11),
        (0, 0),
        (0, 9),
        (0, 0),
        (0, 405),
        (0, 21),
        (0, 1640),
        (0, 524),
        (0, 743),
        (0, 359),
        (0, 1),
        (0, 49),
        (0, 378),
        (0, 15),
        (0, 176),
        (0, 5019),
        (0, 1689),
        (0, 2),
        (0, 792),
        (0, 53),
        (0, 6797),
        (0, 3537),
        (0, 1),
        (0, 41),
        (0, 345),
        (0, 150),
        (0, 0),
        (0, 1461),
        (0, 1450),
        (0, 5869),
        (0, 160),
        (0, 288),
        (0, 1261),
        (0, 0),
        (0, 3972),
        (0, 59),
        (0, 1),
        (0, 130),
        (0, 837),
        (0, 1730),
        (0, 5),
        (0, 64),
        (0, 8968),
        (0, 216),
        (0, 1195),
        (0, 0),
        (0, 220),
        (0, 18234),
        (0, 11553),
        (0, 597),
        (0, 1429),
        (0, 2172),
        (0, 22),
        (0, 53),
        (0, 60),
        (0, 7),
        (0, 0),
        (0, 0),
        (0, 20),
        (0, 6),
        (0, 24),
        (0, 4051),
        (0, 3875),
        (0, 22),
        (0, 156),
        (0, 104),
        (0, 1),
        (0, 4781),
        (0, 1),
        (0, 281),
        (0, 27),
        (0, 9),
        (0, 390),
        (0, 24),
        (0, 30),
        (0, 432),
        (0, 55),
        (0, 1),
        (0, 8),
        (0, 78),
        (0, 0),
        (0, 0),
        (0, 399),
        (0, 122),
        (0, 0),
        (0, 85),
        (0, 558),
        (0, 658),
        (0, 30),
        (0, 2147),
        (0, 7),
        (0, 1494),
        (0, 1),
        (0, 59),
        (0, 0),
        (0, 9518),
        (0, 1),
        (0, 2645),
        (0, 31),
        (0, 647),
        (0, 10443),
        (0, 251),
        (0, 41),
        (0, 44),
        (0, 1102),
        (0, 51),
        (0, 18),
        (0, 983),
        (0, 25),
        (0, 1152),
        (0, 0),
        (0, 17),
        (0, 418),
        (0, 8214),
        (0, 92),
        (0, 7488),
        (0, 1386),
        (0, 891),
        (0, 1194),
        (0, 1455),
        (0, 83),
        (0, 19),
        (0, 83),
        (0, 23),
        (0, 89),
        (0, 0),
        (0, 301),
        (0, 28),
        (0, 0),
        (0, 3284),
        (0, 194),
        (0, 0),
        (0, 33),
        (0, 1420),
        (0, 796),
        (0, 9),
        (0, 919),
        (0, 314),
        (0, 0),
        (0, 96),
        (0, 1),
        (0, 135),
        (0, 648),
        (0, 2),
        (0, 500),
        (0, 15),
        (0, 0),
        (0, 1322),
        (0, 0),
        (0, 31),
        (0, 4),
        (0, 1185),
        (0, 50),
        (0, 1),
        (0, 4022),
        (0, 4245),
        (0, 86),
        (0, 2),
        (0, 2098),
        (0, 45),
        (0, 214),
        (0, 29),
        (0, 3845),
        (0, 407),
        (0, 4818),
        (0, 9),
        (0, 286),
        (0, 2528),
        (0, 37),
        (0, 19),
        (0, 5),
        (0, 278),
        (0, 39),
        (0, 6),
        (0, 103),
        (0, 1402),
        (0, 204),
        (0, 5342),
        (0, 1315),
        (0, 23),
        (0, 0),
        (0, 37),
        (0, 5),
        (0, 17559),
        (0, 110),
        (0, 29),
        (0, 0),
        (0, 433),
        (0, 2674),
        (0, 50),
        (0, 87),
        (0, 411),
        (0, 0),
        (0, 5246),
        (0, 511),
        (0, 4),
        (0, 115),
        (0, 3413),
        (0, 4743),
        (0, 1017),
        (0, 0),
        (0, 1419),
        (0, 1),
        (0, 5204),
        (0, 0),
        (0, 0),
        (0, 31),
        (0, 356),
        (0, 99),
        (0, 24),
        (0, 36),
        (0, 27),
        (0, 1044),
        (0, 9),
        (0, 6562),
        (0, 266),
        (0, 0),
        (0, 17),
        (0, 105),
        (0, 3000),
        (0, 633),
        (0, 52),
        (0, 0),
        (0, 20),
        (0, 54),
        (0, 15),
        (0, 985),
        (0, 124),
        (0, 9477),
        (0, 3),
        (0, 60),
        (0, 2411),
        (0, 9109),
        (0, 6),
        (0, 7534),
        (0, 5),
        (0, 107),
        (0, 35),
        (0, 15),
        (0, 513),
        (0, 516),
        (0, 24),
        (0, 5941),
        (0, 11),
        (0, 3596),
        (0, 20),
        (0, 4888),
        (0, 46),
        (0, 1406),
        (0, 0),
        (0, 6231),
        (0, 1),
        (0, 2),
        (0, 646),
        (0, 293),
        (0, 25),
        (0, 627),
        (0, 747),
        (0, 95),
        (0, 2),
        (0, 47),
        (0, 2508),
        (0, 6),
        (0, 31),
        (0, 9),
        (0, 1),
        (0, 20),
        (0, 11),
        (0, 9),
        (0, 232),
        (0, 0),
        (0, 313),
        (0, 6093),
        (0, 72),
        (0, 441),
        (0, 2473),
        (0, 21),
        (0, 7),
        (0, 48),
        (0, 433),
        (0, 73),
        (0, 0),
        (0, 409),
        (0, 12316),
        (0, 6038),
        (0, 0),
        (0, 19),
        (0, 257),
        (0, 2152),
        (0, 737),
        (0, 408),
        (0, 873),
        (0, 823),
        (0, 3),
        (0, 114),
        (0, 67),
        (0, 439),
        (0, 2029),
        (0, 1071),
        (0, 577),
        (0, 30),
        (0, 878),
        (0, 2),
        (0, 202),
        (0, 3231),
        (0, 9142),
        (0, 1045),
        (0, 4),
        (0, 5293),
        (0, 0),
        (0, 7403),
        (0, 0),
        (0, 243),
        (0, 14),
        (0, 219),
        (0, 627),
        (0, 6374),
        (0, 172),
        (0, 512),
        (0, 2904),
        (0, 470),
        (0, 4673),
        (0, 58),
        (0, 341),
        (0, 122),
        (0, 0),
        (0, 8),
        (0, 18),
        (0, 6907),
        (0, 76),
        (0, 7),
        (0, 13),
        (0, 648),
        (0, 0),
        (0, 6022),
        (0, 44),
        (0, 51),
        (0, 8357),
        (0, 305),
        (0, 44),
        (0, 0),
        (0, 393),
        (0, 1067),
        (0, 1766),
        (0, 1),
        (0, 1),
        (0, 142),
        (0, 199),
        (0, 77),
        (0, 668),
        (0, 9498),
        (0, 19),
        (0, 9),
        (0, 886),
        (0, 53),
        (0, 647),
        (0, 762),
        (0, 1),
        (0, 4936),
        (0, 510),
        (0, 38),
        (0, 2299),
        (0, 916),
        (0, 56),
        (0, 9103),
        (0, 0),
        (0, 35),
        (0, 187),
        (0, 272),
        (0, 21),
        (0, 2),
        (0, 5473),
        (0, 71),
        (0, 53),
        (0, 15229),
        (0, 79),
        (0, 125),
        (0, 9),
        (0, 187),
        (0, 3),
        (0, 1018),
        (0, 5986),
        (0, 208),
        (0, 2417),
        (0, 1228),
        (0, 469),
        (0, 139),
        (0, 10),
        (0, 30),
        (0, 1),
        (0, 1492),
        (0, 788),
        (0, 5017),
        (0, 124),
        (0, 336),
        (0, 46),
        (0, 1360),
        (0, 116),
        (0, 336),
        (0, 1),
        (0, 2),
        (0, 40),
        (0, 703),
        (0, 222),
        (0, 334),
        (0, 2968),
        (0, 52),
        (0, 2364),
        (0, 5),
        (0, 384),
        (0, 5731),
        (0, 5378),
        (0, 3838),
        (0, 862),
        (0, 2918),
        (0, 790),
        (0, 662),
        (0, 1676),
        (0, 912),
        (0, 567),
        (0, 12),
        (0, 0),
        (0, 125),
        (0, 377),
        (0, 1817),
        (0, 963),
        (0, 109),
        (0, 18),
        (0, 1010),
        (0, 6),
        (0, 657),
        (0, 699),
        (0, 13216),
        (0, 7),
        (0, 2552),
        (0, 599),
        (0, 1),
        (0, 854),
        (0, 0),
        (0, 5468),
        (0, 3),
        (0, 4),
        (0, 4),
        (0, 41),
        (0, 453),
        (0, 616),
        (0, 4164),
        (0, 1435),
        (0, 68),
        (0, 396),
        (0, 157),
        (0, 3955),
        (0, 790),
        (0, 3092),
        (0, 2),
        (0, 34),
        (0, 11),
        (0, 9),
        (0, 120),
        (0, 204),
        (0, 33),
        (0, 5480),
        (0, 151),
        (0, 54),
        (0, 271),
        (0, 62),
        (0, 10),
        (0, 70),
        (0, 419),
        (0, 188),
        (0, 69),
        (0, 106),
        (0, 307),
        (0, 6747),
        (0, 1395),
        (0, 3047),
        (0, 442),
        (0, 3),
        (0, 15967),
        (0, 3479),
        (0, 1154),
        (0, 7),
        (0, 12325),
        (0, 6170),
        (0, 22),
        (0, 1616),
        (0, 17234),
        (0, 0),
        (0, 54),
        (0, 3),
        (0, 14),
        (0, 606),
        (0, 2478),
        (0, 44),
        (0, 2022),
        (0, 780),
        (0, 211),
        (0, 535),
        (0, 113),
        (0, 1748),
        (0, 3),
        (0, 411),
        (0, 35),
        (0, 695),
        (0, 1678),
        (0, 4),
        (0, 3607),
        (0, 1212),
        (0, 3420),
        (0, 1484),
        (0, 789),
        (0, 0),
        (0, 5),
        (0, 257),
        (0, 618),
        (0, 9),
        (0, 481),
        (0, 2),
        (0, 282),
        (0, 15),
        (0, 17),
        (0, 14),
        (0, 0),
        (0, 0),
        (0, 0),
        (0, 3),
        (0, 65),
        (0, 1),
        (0, 127),
        (0, 164),
        (0, 0),
        (0, 0),
        (0, 6416),
        (0, 598),
        (0, 5),
        (0, 189),
        (0, 302),
        (0, 257),
        (0, 387),
        (0, 174),
        (0, 0),
        (0, 3084),
        (0, 1),
        (0, 64),
        (0, 18),
        (0, 545),
        (0, 225),
        (0, 65),
        (0, 0),
        (0, 15),
        (0, 6442),
        (0, 6713),
        (0, 2913),
        (0, 251),
        (0, 3),
        (0, 3601),
        (0, 2806),
        (0, 7),
        (0, 1084),
        (0, 26),
        (0, 102),
        (0, 11481),
        (0, 63),
        (0, 84),
        (0, 99),
        (0, 182),
        (0, 624),
        (0, 13),
        (0, 80),
        (0, 9740),
        (0, 725),
        (0, 5772),
        (0, 61),
        (0, 855),
        (0, 7),
        (0, 42),
        (0, 24),
        (0, 473),
        (0, 911),
        (0, 170),
        (0, 1),
        (0, 107),
        (0, 0),
        (0, 72),
        (0, 3542),
        (0, 4),
        (0, 17),
        (0, 11),
        (0, 3),
        (0, 2066),
        (0, 39),
        (0, 146),
        (0, 393),
        (0, 145),
        (0, 2388),
        (0, 7770),
        (0, 40),
        (0, 1),
        (0, 1),
        (0, 153),
        (0, 0),
        (0, 320),
        (0, 140),
        (0, 18),
        (0, 7983),
        (0, 1),
        (0, 0),
        (0, 4381),
        (0, 387),
        (0, 21),
        (0, 4738),
        (0, 804),
        (0, 225),
        (0, 79),
        (0, 6068),
        (0, 133),
        (0, 1),
        (0, 356),
        (0, 5074),
        (0, 13),
        (0, 104),
        (0, 229),
        (0, 4014),
        (0, 53),
        (0, 3610),
        (0, 11),
        (0, 37),
        (0, 222),
        (0, 46),
        (0, 2532),
        (0, 4791),
        (0, 32),
        (0, 1984),
        (0, 3022),
        (0, 944),
        (0, 1),
        (0, 69),
        (0, 2383),
        (0, 185),
        (0, 35),
        (0, 16),
        (0, 2043),
        (0, 26),
        (0, 9),
        (0, 595),
        (0, 330),
        (0, 70),
        (0, 91),
        (0, 84),
        (0, 5),
        (0, 2),
        (0, 416),
        (0, 4907),
        (0, 9950),
        (0, 1695),
        (0, 49),
        (0, 272),
        (0, 190),
        (0, 71),
        (0, 12),
        (0, 522),
        (0, 147),
        (0, 8519),
        (0, 75),
        (0, 353),
        (0, 3036),
        (0, 0),
        (0, 1924),
        (0, 577),
        (0, 8467),
        (0, 78),
        (0, 3557),
        (0, 10402),
        (0, 1970),
        (0, 52),
        (0, 269),
        (0, 4839),
        (0, 1763),
        (0, 13),
        (0, 7590),
        (0, 453),
        (0, 9),
        (0, 71),
        (0, 278),
        (0, 9),
        (0, 5),
        (0, 1),
        (0, 47),
        (0, 1),
        (0, 156),
        (0, 221),
        (0, 8),
        (0, 18259),
        (0, 635),
        (0, 0),
        (0, 9),
        (0, 355),
        (0, 313),
        (0, 2904),
        (0, 6371),
        (0, 7),
        (0, 0),
        (0, 27),
        (0, 1239),
        (0, 301),
        (0, 13),
        (0, 12),
        (0, 665),
        (0, 432),
        (0, 478),
        (0, 272),
        (0, 2690),
        (0, 1143),
        (0, 130),
        (0, 572),
        (0, 10272),
        (0, 1),
        (0, 0),
        (0, 12),
        (0, 13575),
        (0, 25),
        (0, 37),
        (0, 412),
        (0, 113),
        (0, 1769),
        (0, 1598),
        (0, 6),
        (0, 6463),
        (0, 40),
        (0, 27),
        (0, 4),
        (0, 3),
        (0, 1081),
        (0, 2555),
        (0, 8),
        (0, 1771),
        (0, 170),
        (0, 24),
        (0, 187),
        (0, 698),
        (0, 68),
        (0, 69),
        (0, 258),
        (0, 3295),
        (0, 44),
        (0, 12),
        (0, 954),
        (0, 1),
        (0, 3478),
        (0, 17),
        (0, 3097),
        (0, 2184),
        (0, 5373),
        (0, 53),
        (0, 33),
        (0, 2381),
        (0, 24),
        (0, 2701),
        (0, 16826),
        (0, 4256),
        (0, 403),
        (0, 27),
        (0, 14),
        (0, 123),
        (0, 7698),
        (0, 41),
        (0, 26),
        (0, 2),
        (0, 15768),
        (0, 542),
        (0, 9357),
        (0, 1408),
        (0, 3021),
        (0, 5745),
        (0, 130),
        (0, 23),
        (0, 293),
        (0, 16098),
        (0, 28),
        (0, 166),
        (0, 2929),
        (0, 33),
        (0, 469),
        (0, 3),
        (0, 2569),
        (0, 237),
        (0, 1109),
        (0, 2078),
        (0, 3101),
        (0, 11941),
        (0, 381),
        (0, 18),
        (0, 966),
        (0, 7),
        (0, 717),
        (0, 35),
        (0, 4),
        (0, 100),
        (0, 5038),
        (0, 3943),
        (0, 153),
        (0, 5108),
        (0, 9653),
        (0, 15110),
        (0, 139),
        (0, 356),
        (0, 14778),
        (0, 1878),
        (0, 14),
        (0, 79),
        (0, 9),
        (0, 4),
        (0, 6414),
        (0, 1),
        (0, 0),
        (0, 320),
        (0, 3856),
        (0, 1244),
        (0, 18),
        (0, 9521),
        (0, 46),
        (0, 4507),
        (0, 3734),
        (0, 0),
        (0, 200),
        (0, 3),
        (0, 779),
        (0, 6),
        (0, 0),
        (0, 13874),
        (0, 12),
        (0, 218),
        (0, 4041),
        (0, 23),
        (0, 620),
        (0, 1168),
        (0, 269),
        (0, 2966),
        (0, 667),
        (0, 735),
        (0, 3),
        (0, 11),
        (0, 11),
        (0, 6),
        (0, 0),
        (0, 257),
        (0, 1545),
        (0, 7),
        (0, 635),
        (0, 5),
        (0, 8),
        (0, 3606),
        (0, 0),
        (0, 54),
        (0, 6),
        (0, 378),
        (0, 101),
        (0, 22107),
        (0, 2822),
        (0, 1778),
        (0, 408),
        (0, 171),
        (0, 7607),
        (0, 255),
        (0, 3),
        (0, 11258),
        (0, 133),
        (0, 20),
        (0, 32),
        (0, 7),
        (0, 56),
        (0, 215),
        (0, 3818),
        (0, 7579),
        (0, 1556),
        (0, 970),
        (0, 1912),
        (0, 68),
        (0, 511),
        (0, 79),
        (0, 305),
        (0, 20056),
        (0, 284),
        (0, 5),
        (0, 914),
        (0, 4443),
        (0, 1132),
        (0, 10009),
        (0, 15),
        (0, 4355),
        (0, 1359),
        (0, 1105),
        (0, 251),
        (0, 708),
        (0, 0),
        (0, 14),
        (0, 3572),
        (0, 0),
        (0, 267),
        (0, 3399),
        (0, 11052),
        (0, 0),
        (0, 64),
        (0, 48),
        (0, 0),
        (0, 571),
        (0, 3117),
        (0, 24),
        (0, 0),
        (0, 1126),
        (0, 211),
        (0, 153),
        (0, 0),
        (0, 155),
        (0, 186),
        (0, 14759),
        (0, 33),
        (0, 383),
        (0, 1372),
        (0, 612),
        (0, 377),
        (0, 3),
        (0, 14086),
        (0, 0),
        (0, 4130),
        (0, 7024),
        (0, 0),
        (1, 10399),
        (0, 3610),
        (0, 12061),
        (0, 29),
        (0, 1719),
        (0, 473),
        (0, 60),
        (0, 823),
        (0, 1),
        (0, 1340),
        (0, 0),
        (0, 4859),
        (0, 6773),
        (0, 49),
        (0, 667),
        (0, 519),
        (0, 645),
        (0, 1),
        (0, 1352),
        (0, 7390),
        (0, 117),
        (0, 7),
        (0, 789),
        (0, 671),
        (0, 11),
        (0, 0),
        (0, 11285),
        (0, 3398),
        (1, 869),
        (0, 579),
        (0, 22659),
        (0, 33),
        (0, 822),
        (0, 8),
        (0, 63),
        (0, 830),
        (0, 1226),
        (0, 4786),
        (0, 4859),
        (0, 3780),
        (0, 1111),
        (0, 5777),
        (0, 5168),
        (0, 2040),
        (0, 1062),
        (0, 3876),
        (0, 47),
        (0, 356),
        (0, 10851),
        (0, 2),
        (0, 10157),
        (0, 3105),
        (0, 11),
        (0, 5),
        (0, 13),
        (0, 3243),
        (0, 59),
        (0, 3),
        (0, 2701),
        (0, 64),
        (0, 362),
        (0, 12),
        (0, 1505),
        (0, 1139),
        (0, 112),
        (0, 17277),
        (0, 9645),
        (0, 2793),
        (0, 350),
        (0, 2475),
        (0, 60),
        (0, 983),
        (0, 0),
        (0, 27),
        (0, 934),
        (0, 0),
        (0, 1447),
        (0, 7),
        (0, 1510),
        (0, 13614),
        (0, 93),
        (0, 482),
        (0, 21),
        (0, 15),
        (0, 7),
        (0, 20418),
        (0, 0),
        (0, 2166),
        (0, 255),
        (0, 270),
        (0, 645),
        (0, 15),
        (0, 14285),
        (0, 2689),
        (0, 466),
        (0, 5463),
        (0, 1),
        (0, 1301),
        (0, 10736),
        (0, 8521),
        (0, 2236),
        (0, 1328),
        (0, 20),
        (0, 6),
        (0, 10),
        (0, 826),
        (0, 4190),
        (0, 171),
        (0, 17971),
        (0, 13),
        (0, 30),
        (0, 10),
        (0, 306),
        (0, 778),
        (0, 13),
        (0, 23),
        (0, 1),
        (0, 0),
        (0, 9),
        (0, 11),
        (0, 4),
        (0, 1301),
        (0, 5),
        (0, 15585),
        (0, 2),
        (0, 76),
        (0, 558),
        (0, 790),
        (0, 48),
        (0, 16186),
        (0, 2916),
        (0, 2713),
        (0, 3),
        (0, 134),
        (0, 0),
        (0, 3868),
        (0, 12),
        (0, 3206),
        (0, 6933),
        (0, 2972),
        (0, 1184),
        (0, 74),
        (0, 1686),
        (0, 36),
        (0, 431),
        (0, 1081),
        (0, 2711),
        (0, 16736),
        (0, 7426),
        (0, 8472),
        (0, 4),
        (0, 141),
        (0, 41),
        (0, 6030),
        (0, 129),
        (0, 6020),
        (0, 283),
        (0, 7),
        (0, 21),
        (0, 1),
        (0, 9035),
        (0, 3027),
        (0, 10394),
        (0, 566),
        (0, 1276),
        (0, 77),
        (0, 72),
        (0, 0),
        (0, 22673),
        (0, 75),
        (0, 10148),
        (1, 2534),
        (0, 1203),
        (0, 21),
        (0, 1856),
        (0, 1792),
        (0, 9525),
        (0, 46),
        (0, 13888),
        (0, 1255),
        (0, 12154),
        (0, 22912),
        (0, 5433),
        (0, 42),
        (0, 0),
        (0, 1674),
        (0, 18089),
        (0, 24),
        (0, 8093),
        (0, 356),
        (0, 12086),
        (0, 7663),
        (0, 813),
        (0, 11),
        (0, 17573),
        (0, 219),
        (0, 1),
        (0, 3059),
        (0, 0),
        (0, 82),
        (0, 5),
        (0, 193),
        (0, 80),
        (0, 158),
        (0, 227),
        (0, 24896),
        (0, 624),
        (0, 15096),
        (0, 26),
        (0, 863),
        (0, 47),
        (0, 2537),
        (0, 17386),
        (0, 10),
        (0, 10264),
        (0, 14),
        (0, 3569),
        (0, 942),
        (0, 6),
        (0, 507),
        (0, 887),
        (0, 1747),
        (0, 21),
        (0, 6),
        (0, 385),
        (0, 3611),
        (0, 59),
        (0, 4464),
        (1, 4531),
        (0, 25),
        (0, 4845),
        (0, 101),
        (0, 378),
        (0, 68),
        (0, 19624),
        (0, 26),
        (0, 231),
        (0, 4),
        (0, 25550),
        (0, 90),
        (0, 8),
        (0, 2437),
        (0, 21),
        (0, 1),
        (0, 10392),
        (0, 163),
        (0, 202),
        (0, 62),
        (0, 532),
        (0, 12),
        (0, 375),
        (0, 11608),
        (0, 151),
        (0, 57),
        (0, 782),
        (0, 2556),
        (0, 2716),
        (0, 1069),
        (0, 20),
        (0, 76),
        (0, 258),
        (0, 1935),
        (0, 215),
        (0, 50),
        (0, 133),
        (0, 4),
        (0, 208),
        (0, 1766),
        (0, 26),
        (0, 2),
        (0, 77),
        (0, 2256),
        (0, 5223),
        (0, 6097),
        (0, 355),
        (0, 5958),
        (0, 230),
        (0, 1600),
        (0, 1818),
        (0, 2363),
        (0, 2097),
        (0, 89),
        (0, 4),
        (0, 1247),
        (0, 6812),
        (0, 23436),
        (0, 0),
        (0, 84),
        (0, 1560),
        (0, 145),
        (0, 3929),
        (0, 1),
        (0, 8575),
        (0, 3394),
        (0, 100),
        (0, 2126),
        (0, 11966),
        (0, 0),
        (0, 6123),
        (0, 116),
        (0, 618),
        (0, 0),
        (0, 12769),
        (0, 4959),
        (0, 1653),
        (0, 6623),
        (0, 5009),
        (0, 553),
        (0, 1240),
        (0, 13909),
        (0, 956),
        (0, 67),
        (0, 370),
        (0, 7354),
        (0, 12796),
        (0, 5357),
        (0, 1),
        (0, 23347),
        (0, 1),
        (0, 2574),
        (0, 1),
        (0, 238),
        (0, 540),
        (0, 1),
        (0, 9647),
        (0, 5345),
        (0, 37),
        (0, 14),
        (0, 353),
        (1, 12761),
        (0, 2456),
        (0, 1953),
        (0, 2),
        (0, 16616),
        (0, 2752),
        (0, 0),
        (0, 15960),
        (0, 1130),
        (0, 5321),
        (0, 6692),
        (0, 3653),
        (0, 9),
        (0, 73),
        (0, 5548),
        (0, 21),
        (0, 0),
        (0, 2),
        (0, 48),
        (0, 5),
        (0, 1670),
        (0, 5),
        (0, 4868),
        (0, 2407),
        (0, 8043),
        (0, 221),
        (0, 23),
        (0, 1112),
        (0, 50),
        (0, 60),
        (0, 1401),
        (0, 517),
        (0, 84),
        (0, 25),
        (0, 4254),
        (0, 1692),
        (0, 8974),
        (0, 64),
        (0, 5600),
        (0, 11),
        (0, 4),
        (0, 3244),
        (0, 89),
        (0, 11055),
        (0, 19317),
        (0, 21822),
        (0, 3568),
        (0, 37),
        (0, 2130),
        (0, 207),
        (0, 29),
        (0, 4722),
        (0, 157),
        (0, 720),
        (0, 676),
        (0, 2079),
        (0, 1503),
        (0, 85),
        (0, 48),
        (1, 9440),
        (0, 61),
        (0, 6081),
        (0, 1704),
        (0, 2358),
        (0, 1034),
        (0, 7),
        (0, 35),
        (0, 0),
        (0, 687),
        (0, 45),
        (0, 92),
        (0, 18),
        (0, 435),
        (0, 12752),
        (0, 0),
        (0, 28),
        (0, 14595),
        (0, 418),
        (0, 0),
        (0, 3),
        (0, 5),
        (0, 7580),
        (0, 113),
        (0, 2602),
        (0, 3598),
        (0, 29),
        (0, 633),
        (0, 25),
        (0, 31),
        (0, 18),
        (0, 27),
        (0, 568),
        (0, 2),
        (0, 2802),
        (0, 293),
        (0, 9),
        (0, 118),
        (0, 158),
        (0, 864),
        (0, 8252),
        (0, 25994),
        (0, 79),
        (0, 4938),
        (0, 6410),
        (0, 544),
        (0, 5),
        (0, 5181),
        (0, 1803),
        (0, 10),
        (0, 13030),
        (0, 5717),
        (0, 5806),
        (0, 2894),
        (0, 31),
        (0, 3492),
        (0, 1418),
        (0, 4839),
        (0, 492),
        (0, 1),
        (0, 1707),
        (0, 13445),
        (0, 14),
        (0, 6539),
        (0, 1),
        (0, 3072),
        (0, 0),
        (0, 819),
        (0, 1220),
        (0, 0),
        (0, 16),
        (0, 19287),
        (0, 122),
        (0, 697),
        (0, 263),
        (0, 64),
        (0, 5036),
        (0, 22),
        (0, 433),
        (0, 56),
        (0, 1281),
        (0, 597),
        (0, 1456),
        (0, 8),
        (0, 16840),
        (0, 17064),
        (0, 42),
        (0, 1674),
        (0, 2),
        (0, 14),
        (0, 88),
        (0, 839),
        (0, 0),
        (0, 917),
        (0, 3),
        (0, 216),
        (0, 2240),
        (0, 4),
        (0, 838),
        (0, 743),
        (0, 0),
        (0, 560),
        (0, 0),
        (0, 12943),
        (0, 8944),
        (0, 638),
        (0, 5134),
        (0, 24962),
        (0, 5049),
        (0, 160),
        (0, 1581),
        (0, 117),
        (0, 8),
        (0, 26),
        (0, 466),
        (0, 386),
        (0, 133),
        (0, 82),
        (0, 25),
        (0, 16),
        (0, 4757),
        (0, 21285),
        (0, 337),
        (0, 4),
        (0, 3671),
        (1, 190),
        (0, 59),
        (0, 11978),
        (0, 11787),
        (0, 0),
        (0, 1277),
        (0, 411),
        (0, 1),
        (0, 6),
        (0, 8435),
        (0, 348),
        (0, 8629),
        (0, 1458),
        (0, 11),
        (0, 17592),
        (0, 3460),
        (0, 618),
        (0, 2658),
        (0, 13),
        (0, 2),
        (0, 14),
        (0, 197),
        (1, 21602),
        (0, 3076),
        (0, 870),
        (0, 169),
        (0, 26),
        (0, 0),
        (0, 207),
        (0, 262),
        (0, 1742),
        (0, 1138),
        (0, 3986),
        (0, 6978),
        (0, 10642),
        (0, 8),
        (0, 0),
        (0, 1),
        (0, 25),
        (0, 1),
        (0, 801),
        (0, 1990),
        (0, 1),
        (0, 84),
        (0, 741),
        (0, 2390),
        (0, 90),
        (0, 31),
        (0, 2077),
        (0, 150),
        (0, 146),
        (0, 21),
        (0, 1370),
        (0, 1067),
        (0, 0),
        (0, 781),
        (0, 6),
        (0, 88),
        (0, 97),
        (1, 3074),
        (0, 3),
        (0, 22291),
        (0, 0),
        (0, 47),
        (0, 25929),
        (0, 911),
        (0, 208),
        (0, 12),
        (0, 16),
        (0, 73),
        (0, 132),
        (0, 22),
        (0, 5),
        (0, 3524),
        (0, 3),
        (0, 3),
        (0, 5107),
        (0, 1962),
        (0, 22530),
        (0, 1),
        (0, 11),
        (0, 24),
        (0, 221),
        (0, 0),
        (0, 417),
        (0, 46),
        (0, 16342),
        (0, 19380),
        (0, 53),
        (0, 88),
        (0, 80),
        (0, 4589),
        (0, 89),
        (0, 24),
        (0, 1),
        (0, 250),
        (0, 18567),
        (0, 4360),
        (0, 5054),
        (0, 7759),
        (0, 1),
        (0, 162),
        (0, 45),
        (0, 6465),
        (0, 59),
        (0, 79),
        (0, 13913),
        (0, 2913),
        (0, 5),
        (0, 12),
        (0, 1802),
        (0, 3),
        (0, 10),
        (0, 25),
        (0, 5523),
        (0, 654),
        (0, 9),
        (0, 22),
        (0, 0),
        (0, 1515),
        (0, 2018),
        (0, 2),
        (1, 5988),
        (0, 53),
        (0, 3800),
        (0, 3466),
        (0, 1706),
        (0, 1563),
        (0, 192),
        (1, 5955),
        (0, 254),
        (0, 5),
        (0, 58),
        (0, 3139),
        (0, 9083),
        (0, 18215),
        (0, 1962),
        (0, 26613),
        (0, 563),
        (0, 3233),
        (0, 0),
        (0, 56),
        (0, 2),
        (0, 2),
        (0, 13),
        (0, 5321),
        (0, 4),
        (0, 1499),
        (0, 1275),
        (0, 103),
        (0, 16),
        (0, 603),
        (0, 0),
        (0, 177),
        (0, 428),
        (0, 6),
        (0, 538),
        (0, 15094),
        (0, 640),
        (0, 0),
        (0, 6188),
        (0, 26435),
        (0, 1375),
        (0, 19558),
        (0, 4290),
        (0, 3913),
        (0, 34),
        (0, 301),
        (0, 2),
        (0, 619),
        (0, 10),
        (0, 7),
        (0, 1),
        (0, 164),
        (0, 1),
        (0, 1723),
        (0, 122),
        (1, 20495),
        (0, 8912),
        (0, 15309),
        (0, 2458),
        (0, 3576),
        (0, 19611),
        (0, 17542),
        (0, 0),
        (0, 11352),
        (0, 3),
        (0, 1569),
        (0, 3291),
        (0, 8),
        (0, 26399),
        (0, 2142),
        (0, 1674),
        (0, 13420),
        (0, 348),
        (0, 190),
        (0, 4222),
        (0, 3878),
        (0, 3095),
        (0, 2789),
        (0, 458),
        (0, 94),
        (0, 25),
        (0, 9),
        (0, 2394),
        (0, 822),
        (0, 0),
        (0, 4369),
        (0, 409),
        (0, 848),
        (0, 26),
        (0, 19),
        (1, 2922),
        (0, 3),
        (0, 103),
        (1, 14622),
        (0, 305),
        (0, 37),
        (0, 14),
        (0, 10),
        (0, 31),
        (0, 9),
        (0, 23684),
        (0, 8040),
        (0, 12),
        (0, 202),
        (0, 79),
        (0, 351),
        (0, 323),
        (0, 579),
        (0, 15),
        (0, 8067),
        (0, 6),
        (0, 41),
        (0, 20851),
        (0, 26),
        (0, 4),
        (0, 24544),
        (0, 1274),
        (0, 3137),
        (0, 2637),
        (0, 1784),
        (0, 10858),
        (0, 35),
        (0, 227),
        (0, 2786),
        (0, 1152),
        (0, 23731),
        (0, 73),
        (0, 84),
        (0, 17),
        (0, 5575),
        (0, 552),
        (0, 497),
        (0, 884),
        (0, 43),
        (0, 0),
        (0, 36),
        (0, 12),
        (0, 49),
        (0, 15288),
        (0, 5090),
        (0, 84),
        (0, 16949),
        (0, 1240),
        (0, 1182),
        (0, 9768),
        (0, 0),
        (0, 262),
        (0, 109),
        (0, 2523),
        (0, 295),
        (0, 174),
        (0, 38),
        (0, 2),
        (0, 5),
        (0, 3050),
        (0, 144),
        (0, 20657),
        (0, 534),
        (0, 2802),
        (0, 1351),
        (0, 11077),
        (0, 98),
        (0, 32),
        (0, 507),
        (0, 1347),
        (0, 203),
        (0, 23244),
        (0, 2608),
        (0, 838),
        (0, 352),
        (0, 402),
        (0, 12475),
        (0, 146),
        (0, 7694),
        (0, 1030),
        (0, 0),
        (0, 401),
        (0, 1527),
        (0, 57),
        (0, 779),
        (0, 563),
        (0, 5),
        (0, 955),
        (0, 6359),
        (0, 23),
        (0, 4517),
        (0, 7114),
        (0, 217),
        (0, 5143),
        (0, 5614),
        (0, 8726),
        (0, 1816),
        (0, 8453),
        (0, 238),
        (0, 137),
        (0, 18003),
        (0, 38),
        (0, 1115),
        (0, 10),
        (0, 825),
        (0, 13),
        (0, 21),
        (0, 195),
    ]),
    entries: ::phf::Slice::Static(&[
        (
            UniCase::ascii("baulk"),
            &[(0b10010, &ENTRY_BALK_16157341829373855465)],
        ),
        (
            UniCase::ascii("pyrolyzed"),
            &[(0b01001, &ENTRY_PYROLYZED_6450196473837000816)],
        ),
        (
            UniCase::ascii("floramor"),
            &[(0b00001, &ENTRY_FLORAMOR_6523671428808024045)],
        ),
        (
            UniCase::ascii("fustianizes"),
            &[(0b01001, &ENTRY_FUSTIANIZES_8593570763530200647)],
        ),
        (
            UniCase::ascii("electrodialysers"),
            &[(0b11010, &ENTRY_ELECTRODIALYZERS_1528101750662982617)],
        ),
        (
            UniCase::ascii("serpentise"),
            &[(0b10010, &ENTRY_SERPENTIZE_3384972221379685069)],
        ),
        (
            UniCase::ascii("aerofoils"),
            &[(0b10010, &ENTRY_AIRFOILS_11117747260949333982)],
        ),
        (
            UniCase::ascii("randomises"),
            &[(0b10010, &ENTRY_RANDOMIZES_13716959639798364190)],
        ),
        (
            UniCase::ascii("clericalize"),
            &[(0b01001, &ENTRY_CLERICALIZE_1865718535677694450)],
        ),
        (
            UniCase::ascii("depolymerisations"),
            &[(0b10010, &ENTRY_DEPOLYMERIZATIONS_10499384093097172145)],
        ),
        (
            UniCase::ascii("spiraled"),
            &[(0b01001, &ENTRY_SPIRALED_4583591683626098518)],
        ),
        (
            UniCase::ascii("mislabeled"),
            &[(0b00001, &ENTRY_MISLABELED_11561074022001091176)],
        ),
        (
            UniCase::ascii("nitridisation"),
            &[(0b10010, &ENTRY_NITRIDIZATION_918307471678159167)],
        ),
        (
            UniCase::ascii("phorrhoea"),
            &[(0b11010, &ENTRY_PHORRHEA_13208068197196345881)],
        ),
        (
            UniCase::ascii("zooeas"),
            &[(0b11010, &ENTRY_ZOEAS_265178227546758074)],
        ),
        (
            UniCase::ascii("decarbonisation"),
            &[(0b10010, &ENTRY_DECARBONIZATION_8874762898635047514)],
        ),
        (
            UniCase::ascii("pseudoembryonic"),
            &[(0b11010, &ENTRY_PSEUDEMBRYONIC_17990306181748605974)],
        ),
        (
            UniCase::ascii("gynecologists"),
            &[(0b11001, &ENTRY_GYNECOLOGISTS_1517096604835056713)],
        ),
        (
            UniCase::ascii("cretinizations"),
            &[(0b01001, &ENTRY_CRETINIZATIONS_8550950897045447908)],
        ),
        (
            UniCase::ascii("cupelling"),
            &[(0b11010, &ENTRY_CUPELING_4033682037469028100)],
        ),
        (
            UniCase::ascii("clamouring"),
            &[(0b11010, &ENTRY_CLAMORING_5415785372025381455)],
        ),
        (
            UniCase::ascii("outtyrannises"),
            &[(0b10010, &ENTRY_OUTTYRANNIZES_2960809863014622911)],
        ),
        (
            UniCase::ascii("quantisation"),
            &[(0b10010, &ENTRY_QUANTIZATION_17530637216436047165)],
        ),
        (
            UniCase::ascii("slenderizes"),
            &[(0b01001, &ENTRY_SLENDERIZES_16779186498929500242)],
        ),
        (
            UniCase::ascii("palaeogenesis"),
            &[(0b11010, &ENTRY_PALEOGENESIS_3600166863543332590)],
        ),
        (
            UniCase::ascii("mercerisation"),
            &[(0b10010, &ENTRY_MERCERIZATION_14891932795764931552)],
        ),
        (
            UniCase::ascii("demonetization"),
            &[(0b01001, &ENTRY_DEMONETIZATION_10800150167569494235)],
        ),
        (
            UniCase::ascii("templises"),
            &[(0b10010, &ENTRY_TEMPLIZES_8206287182084029425)],
        ),
        (
            UniCase::ascii("israelitise"),
            &[(0b10010, &ENTRY_ISRAELITIZE_2547909155867308223)],
        ),
        (
            UniCase::ascii("radialized"),
            &[(0b01001, &ENTRY_RADIALIZED_4912265723493507733)],
        ),
        (
            UniCase::ascii("giantise"),
            &[(0b10010, &ENTRY_GIANTIZE_9114588567776629038)],
        ),
        (
            UniCase::ascii("proctorisations"),
            &[(0b10010, &ENTRY_PROCTORIZATIONS_16880863477174659915)],
        ),
        (
            UniCase::ascii("finalized"),
            &[(0b01001, &ENTRY_FINALIZED_17116867203523473286)],
        ),
        (
            UniCase::ascii("uralitise"),
            &[(0b10010, &ENTRY_URALITIZE_16749000206864918007)],
        ),
        (
            UniCase::ascii("depoliticisation"),
            &[(0b10010, &ENTRY_DEPOLITICIZATION_14063377291726000588)],
        ),
        (
            UniCase::ascii("regalize"),
            &[(0b01001, &ENTRY_REGALIZE_13206969410028193305)],
        ),
        (
            UniCase::ascii("hyperlipaemic"),
            &[(0b11010, &ENTRY_HYPERLIPEMIC_14507717637329252900)],
        ),
        (
            UniCase::ascii("focalisations"),
            &[(0b10010, &ENTRY_FOCALIZATIONS_16231123162455166109)],
        ),
        (
            UniCase::ascii("historicize"),
            &[(0b01001, &ENTRY_HISTORICIZE_787070662493754066)],
        ),
        (
            UniCase::ascii("disorganize"),
            &[(0b01001, &ENTRY_DISORGANIZE_11143780718836315842)],
        ),
        (
            UniCase::ascii("preacute"),
            &[(0b11010, &ENTRY_PERACUTE_2328162913715436273)],
        ),
        (
            UniCase::ascii("demineralised"),
            &[(0b10010, &ENTRY_DEMINERALIZED_417389536885991347)],
        ),
        (
            UniCase::ascii("decolourizer"),
            &[(0b01000, &ENTRY_DECOLORIZER_1117085801636205705)],
        ),
        (
            UniCase::ascii("dolomitises"),
            &[(0b10010, &ENTRY_DOLOMITIZES_14363893600761024796)],
        ),
        (
            UniCase::ascii("caenogenetically"),
            &[(0b11010, &ENTRY_CENOGENETICALLY_14614059803186390481)],
        ),
        (
            UniCase::ascii("disillusionises"),
            &[(0b10010, &ENTRY_DISILLUSIONIZES_12240679786185783886)],
        ),
        (
            UniCase::ascii("gallize"),
            &[(0b01001, &ENTRY_GALLIZE_13402144085043483688)],
        ),
        (
            UniCase::ascii("centrifugalised"),
            &[(0b10010, &ENTRY_CENTRIFUGALIZED_16399570134709120738)],
        ),
        (
            UniCase::ascii("unsuccourables"),
            &[(0b11010, &ENTRY_UNSUCCORABLES_739989955870419064)],
        ),
        (
            UniCase::ascii("praezygapophysis"),
            &[(0b11010, &ENTRY_PREZYGAPOPHYSIS_14960217627658149191)],
        ),
        (
            UniCase::ascii("subsidisable"),
            &[(0b10010, &ENTRY_SUBSIDIZABLE_12403609187359696273)],
        ),
        (
            UniCase::ascii("logicises"),
            &[(0b10010, &ENTRY_LOGICIZES_3568589430640497383)],
        ),
        (
            UniCase::ascii("organizationals"),
            &[(0b01001, &ENTRY_ORGANIZATIONALS_10559236366326509118)],
        ),
        (
            UniCase::ascii("precriticises"),
            &[(0b10010, &ENTRY_PRECRITICIZES_15135281493768452751)],
        ),
        (
            UniCase::ascii("delocalized"),
            &[(0b01001, &ENTRY_DELOCALIZED_6707490578440021648)],
        ),
        (
            UniCase::ascii("maternalised"),
            &[(0b10010, &ENTRY_MATERNALIZED_14227156040020017965)],
        ),
        (
            UniCase::ascii("parchmentize"),
            &[(0b01001, &ENTRY_PARCHMENTIZE_12324213011474346454)],
        ),
        (
            UniCase::ascii("anhaematopoiesis"),
            &[(0b11010, &ENTRY_ANHEMATOPOIESIS_17033044080627588200)],
        ),
        (
            UniCase::ascii("mesmerizing"),
            &[(0b01001, &ENTRY_MESMERIZING_9747635351758180951)],
        ),
        (
            UniCase::ascii("flavoursomest"),
            &[(0b11010, &ENTRY_FLAVORSOMEST_10683456501512121672)],
        ),
        (
            UniCase::ascii("phrenologised"),
            &[(0b10010, &ENTRY_PHRENOLOGIZED_5269289788245932959)],
        ),
        (
            UniCase::ascii("centrifugalization"),
            &[(0b01001, &ENTRY_CENTRIFUGALIZATION_10319359115375445805)],
        ),
        (
            UniCase::ascii("distill"),
            &[(0b01001, &ENTRY_DISTILL_15657274320458397213)],
        ),
        (
            UniCase::ascii("opiniatre"),
            &[(0b11010, &ENTRY_OPINIATER_8121394919829508808)],
        ),
        (
            UniCase::ascii("hypomenorrhoeas"),
            &[(0b11010, &ENTRY_HYPOMENORRHEAS_10501238150845360653)],
        ),
        (
            UniCase::ascii("moldier"),
            &[(0b11001, &ENTRY_MOLDIER_17925953827043179593)],
        ),
        (
            UniCase::ascii("hemagglutinin"),
            &[(0b10001, &ENTRY_HEMAGGLUTININ_1512122070828458386)],
        ),
        (
            UniCase::ascii("caramelize"),
            &[(0b01001, &ENTRY_CARAMELIZE_15122592141568398862)],
        ),
        (
            UniCase::ascii("uralitizing"),
            &[(0b01001, &ENTRY_URALITIZING_1776329728839479360)],
        ),
        (
            UniCase::ascii("ventriloquized"),
            &[(0b01001, &ENTRY_VENTRILOQUIZED_17464849051904807365)],
        ),
        (
            UniCase::ascii("hoveler"),
            &[(0b00001, &ENTRY_HOVELER_1958268142806831894)],
        ),
        (
            UniCase::ascii("haemochromatosis"),
            &[(0b11010, &ENTRY_HEMOCHROMATOSIS_2585842551183947470)],
        ),
        (
            UniCase::ascii("revisualise"),
            &[(0b10010, &ENTRY_REVISUALIZE_10854082452689148747)],
        ),
        (
            UniCase::ascii("sensationalize"),
            &[(0b01001, &ENTRY_SENSATIONALIZE_3612877228613212928)],
        ),
        (
            UniCase::ascii("catholicizes"),
            &[(0b01001, &ENTRY_CATHOLICIZES_893481801065117743)],
        ),
        (
            UniCase::ascii("tanalised"),
            &[(0b10010, &ENTRY_TANALIZED_9212065894823627745)],
        ),
        (
            UniCase::ascii("aluminiums"),
            &[(0b10010, &ENTRY_ALUMINUMS_235477509529996640)],
        ),
        (
            UniCase::ascii("tranquillisation"),
            &[(0b10010, &ENTRY_TRANQUILLIZATION_11946857030526310268)],
        ),
        (
            UniCase::ascii("vectorisable"),
            &[(0b10010, &ENTRY_VECTORIZABLE_4166695678492588499)],
        ),
        (
            UniCase::ascii("misbehaviors"),
            &[(0b10001, &ENTRY_MISBEHAVIORS_5196208905035156615)],
        ),
        (
            UniCase::ascii("neutralisation"),
            &[(0b10010, &ENTRY_NEUTRALIZATION_13307816516042724010)],
        ),
        (
            UniCase::ascii("untheorizable"),
            &[(0b01001, &ENTRY_UNTHEORIZABLE_240618649580760361)],
        ),
        (
            UniCase::ascii("defeudalized"),
            &[(0b01001, &ENTRY_DEFEUDALIZED_10926320617236271428)],
        ),
        (
            UniCase::ascii("oxidises"),
            &[(0b10010, &ENTRY_OXIDIZES_12570513258219136803)],
        ),
        (
            UniCase::ascii("disboweling"),
            &[(0b00001, &ENTRY_DISBOWELING_14146470427022244483)],
        ),
        (
            UniCase::ascii("syphonless"),
            &[(0b11010, &ENTRY_SIPHONLESS_10853607871264713731)],
        ),
        (
            UniCase::ascii("fibrisers"),
            &[(0b10010, &ENTRY_FIBERIZERS_11340645263185175813)],
        ),
        (
            UniCase::ascii("dishonor"),
            &[(0b11001, &ENTRY_DISHONOR_16058760573294695856)],
        ),
        (
            UniCase::ascii("hematoidin"),
            &[(0b10001, &ENTRY_HEMATOIDIN_16093151429433672073)],
        ),
        (
            UniCase::ascii("lexiconise"),
            &[(0b10010, &ENTRY_LEXICONIZE_11609885077010802762)],
        ),
        (
            UniCase::ascii("demoralisingly"),
            &[(0b10010, &ENTRY_DEMORALIZINGLY_8510512214576425144)],
        ),
        (
            UniCase::ascii("leucorrhoea"),
            &[(0b11010, &ENTRY_LEUCORRHEA_12491143111744908996)],
        ),
        (
            UniCase::ascii("tylerises"),
            &[(0b10010, &ENTRY_TYLERIZES_3930431350093885314)],
        ),
        (
            UniCase::ascii("hemolytic"),
            &[(0b10001, &ENTRY_HEMOLYTIC_16715121281784730995)],
        ),
        (
            UniCase::ascii("cantonise"),
            &[(0b10010, &ENTRY_CANTONIZE_1640483783874964493)],
        ),
        (
            UniCase::ascii("glamorizer"),
            &[(0b01001, &ENTRY_GLAMORIZER_1273764306977330242)],
        ),
        (
            UniCase::ascii("undercolor"),
            &[(0b00001, &ENTRY_UNDERCOLOR_8519534420778344085)],
        ),
        (
            UniCase::ascii("circularizer"),
            &[(0b01001, &ENTRY_CIRCULARIZER_10781935971896485951)],
        ),
        (
            UniCase::ascii("perfectivises"),
            &[(0b10010, &ENTRY_PERFECTIVIZES_9087949345192893342)],
        ),
        (
            UniCase::ascii("unitalicised"),
            &[(0b10010, &ENTRY_UNITALICIZED_4803411370795702968)],
        ),
        (
            UniCase::ascii("prelingually"),
            &[(0b11010, &ENTRY_PERLINGUALLY_11928722645527217541)],
        ),
        (
            UniCase::ascii("rusticizes"),
            &[(0b01001, &ENTRY_RUSTICIZES_5457546844148812271)],
        ),
        (
            UniCase::ascii("rebaptise"),
            &[(0b10010, &ENTRY_REBAPTIZE_571434688106506900)],
        ),
        (
            UniCase::ascii("sanitises"),
            &[(0b10010, &ENTRY_SANITIZES_14632226777926157749)],
        ),
        (
            UniCase::ascii("parochialise"),
            &[(0b10010, &ENTRY_PAROCHIALIZE_4878369212533866158)],
        ),
        (
            UniCase::ascii("oecumenic"),
            &[(0b11010, &ENTRY_ECUMENIC_15780133217602967984)],
        ),
        (
            UniCase::ascii("raphide"),
            &[(0b00001, &ENTRY_RAPHIDE_6262708817040760676)],
        ),
        (
            UniCase::ascii("civilianise"),
            &[(0b10010, &ENTRY_CIVILIANIZE_4503116173799461974)],
        ),
        (
            UniCase::ascii("palestrae"),
            &[(0b10001, &ENTRY_PALESTRAE_1477667196546852023)],
        ),
        (
            UniCase::ascii("develled"),
            &[(0b11010, &ENTRY_DEVELED_13710518174394409286)],
        ),
        (
            UniCase::ascii("visualisers"),
            &[(0b10010, &ENTRY_VISUALIZERS_5162859868708280179)],
        ),
        (
            UniCase::ascii("civilizable"),
            &[(0b01001, &ENTRY_CIVILIZABLE_12250954830034270586)],
        ),
        (
            UniCase::ascii("projectisations"),
            &[(0b10010, &ENTRY_PROJECTIZATIONS_11440603583583794637)],
        ),
        (
            UniCase::ascii("sensualised"),
            &[(0b10010, &ENTRY_SENSUALIZED_5812075572460333798)],
        ),
        (
            UniCase::ascii("unroyalized"),
            &[(0b01001, &ENTRY_UNROYALIZED_463331773464183743)],
        ),
        (
            UniCase::ascii("acuaesthesia"),
            &[(0b11010, &ENTRY_ACUESTHESIA_12188708987996711429)],
        ),
        (
            UniCase::ascii("doctrinisations"),
            &[(0b10010, &ENTRY_DOCTRINIZATIONS_15902219939645192582)],
        ),
        (
            UniCase::ascii("honourableness"),
            &[(0b11010, &ENTRY_HONORABLENESS_11259768724529598124)],
        ),
        (
            UniCase::ascii("neoencephalon"),
            &[(0b11010, &ENTRY_NEENCEPHALON_14187652725536427083)],
        ),
        (
            UniCase::ascii("lionises"),
            &[(0b10010, &ENTRY_LIONIZES_859661935731471597)],
        ),
        (
            UniCase::ascii("productise"),
            &[(0b10010, &ENTRY_PRODUCTIZE_355214308695677973)],
        ),
        (
            UniCase::ascii("palaeogeographically"),
            &[(0b11010, &ENTRY_PALEOGEOGRAPHICALLY_13029998877556984898)],
        ),
        (
            UniCase::ascii("parathyroidectomize"),
            &[(0b01001, &ENTRY_PARATHYROIDECTOMIZE_14332962201064430908)],
        ),
        (
            UniCase::ascii("hygienizations"),
            &[(0b01001, &ENTRY_HYGIENIZATIONS_6338160659202170314)],
        ),
        (
            UniCase::ascii("transcendentalization"),
            &[(0b01001, &ENTRY_TRANSCENDENTALIZATION_16279978221157892606)],
        ),
        (
            UniCase::ascii("reoxidises"),
            &[(0b10010, &ENTRY_REOXIDIZES_14522324553215140631)],
        ),
        (
            UniCase::ascii("vulcanizables"),
            &[(0b01001, &ENTRY_VULCANIZABLES_8379629917557167700)],
        ),
        (
            UniCase::ascii("unnormalise"),
            &[(0b10010, &ENTRY_UNNORMALIZE_14634692936439819346)],
        ),
        (
            UniCase::ascii("macadamised"),
            &[(0b10010, &ENTRY_MACADAMIZED_7938719006509938754)],
        ),
        (
            UniCase::ascii("hematins"),
            &[(0b10001, &ENTRY_HEMATINS_3508374996795413939)],
        ),
        (
            UniCase::ascii("luteinise"),
            &[(0b10010, &ENTRY_LUTEINIZE_11955489358557604884)],
        ),
        (
            UniCase::ascii("ozonisers"),
            &[(0b10010, &ENTRY_OZONIZERS_3033483267089639714)],
        ),
        (
            UniCase::ascii("chronologized"),
            &[(0b01001, &ENTRY_CHRONOLOGIZED_5845452320056255894)],
        ),
        (
            UniCase::ascii("gallicization"),
            &[(0b01001, &ENTRY_GALLICIZATION_7390977763303794298)],
        ),
        (
            UniCase::ascii("alinements"),
            &[(0b00001, &ENTRY_ALIGNMENTS_14673777835100591286)],
        ),
        (
            UniCase::ascii("pilgrimised"),
            &[(0b10010, &ENTRY_PILGRIMIZED_11204759801928429576)],
        ),
        (
            UniCase::ascii("mediatization"),
            &[(0b01001, &ENTRY_MEDIATIZATION_13943602012568749747)],
        ),
        (
            UniCase::ascii("leucocythemia"),
            &[(0b00001, &ENTRY_LEUCOCYTHEMIA_6949077817963406299)],
        ),
        (
            UniCase::ascii("stearrhoea"),
            &[(0b11010, &ENTRY_STEARRHEA_595939535574612058)],
        ),
        (
            UniCase::ascii("exhibitionizes"),
            &[(0b01001, &ENTRY_EXHIBITIONIZES_9279135115141727061)],
        ),
        (
            UniCase::ascii("nuclearise"),
            &[(0b10010, &ENTRY_NUCLEARIZE_16199083117905670972)],
        ),
        (
            UniCase::ascii("novelizing"),
            &[(0b01001, &ENTRY_NOVELIZING_17848834665214118176)],
        ),
        (
            UniCase::ascii("factorising"),
            &[(0b10010, &ENTRY_FACTORIZING_6633915971235070053)],
        ),
        (
            UniCase::ascii("eternizes"),
            &[(0b01001, &ENTRY_ETERNIZES_13889836130672451566)],
        ),
        (
            UniCase::ascii("luteinizations"),
            &[(0b01001, &ENTRY_LUTEINIZATIONS_2301336961919403024)],
        ),
        (
            UniCase::ascii("centrelessest"),
            &[(0b11010, &ENTRY_CENTERLESSEST_15729458226381131123)],
        ),
        (
            UniCase::ascii("clamorer"),
            &[(0b11001, &ENTRY_CLAMORER_17883337748457044767)],
        ),
        (
            UniCase::ascii("fiberizer"),
            &[(0b00001, &ENTRY_FIBERIZER_2701702218944894305)],
        ),
        (
            UniCase::ascii("esterization"),
            &[(0b01001, &ENTRY_ESTERIZATION_1838643342430239163)],
        ),
        (
            UniCase::ascii("civilisations"),
            &[(0b10010, &ENTRY_CIVILIZATIONS_10559611739235699948)],
        ),
        (
            UniCase::ascii("unsavourilier"),
            &[(0b11010, &ENTRY_UNSAVORILIER_17795073319281436965)],
        ),
        (
            UniCase::ascii("imer"),
            &[(0b00001, &ENTRY_IMER_14870920039806180201)],
        ),
        (
            UniCase::ascii("palaeoencephalon"),
            &[(0b11010, &ENTRY_PALEOENCEPHALON_12092496594413779771)],
        ),
        (
            UniCase::ascii("unsubstantializing"),
            &[(0b01001, &ENTRY_UNSUBSTANTIALIZING_2121724985901297893)],
        ),
        (
            UniCase::ascii("autocatalyzed"),
            &[(0b01001, &ENTRY_AUTOCATALYZED_11100710334159127743)],
        ),
        (
            UniCase::ascii("harbourlesser"),
            &[(0b11010, &ENTRY_HARBORLESSER_9734324406563797455)],
        ),
        (
            UniCase::ascii("tutorisation"),
            &[(0b10010, &ENTRY_TUTORIZATION_7186477482613526154)],
        ),
        (
            UniCase::ascii("palaeodendrologically"),
            &[(0b11010, &ENTRY_PALEODENDROLOGICALLY_3827473591390270826)],
        ),
        (
            UniCase::ascii("valvulae"),
            &[(0b11010, &ENTRY_VALVULE_7068032189967732165)],
        ),
        (
            UniCase::ascii("horizontalise"),
            &[(0b10010, &ENTRY_HORIZONTALIZE_7528617191591553093)],
        ),
        (
            UniCase::ascii("phoneticise"),
            &[(0b10010, &ENTRY_PHONETICIZE_2002370945385634969)],
        ),
        (
            UniCase::ascii("sirup"),
            &[(0b00001, &ENTRY_SYRUP_13414625495147716891)],
        ),
        (
            UniCase::ascii("proselytizers"),
            &[(0b01001, &ENTRY_PROSELYTIZERS_8374451172555772107)],
        ),
        (
            UniCase::ascii("institutionalizations"),
            &[(0b01001, &ENTRY_INSTITUTIONALIZATIONS_12755904320513262139)],
        ),
        (
            UniCase::ascii("clamor"),
            &[(0b11001, &ENTRY_CLAMOR_11722915000424769718)],
        ),
        (
            UniCase::ascii("nonoxidising"),
            &[(0b10010, &ENTRY_NONOXIDIZING_16594445364457308574)],
        ),
        (
            UniCase::ascii("orthocentres"),
            &[(0b11010, &ENTRY_ORTHOCENTERS_3251720815245763229)],
        ),
        (
            UniCase::ascii("adulterised"),
            &[(0b10010, &ENTRY_ADULTERIZED_9727259542657623653)],
        ),
        (
            UniCase::ascii("colourimeters"),
            &[(0b11010, &ENTRY_COLORIMETERS_16988328923257615588)],
        ),
        (
            UniCase::ascii("illiberalize"),
            &[(0b01001, &ENTRY_ILLIBERALIZE_16887752615283473950)],
        ),
        (
            UniCase::ascii("protectionise"),
            &[(0b10010, &ENTRY_PROTECTIONIZE_13639705024576405936)],
        ),
        (
            UniCase::ascii("serializing"),
            &[(0b01001, &ENTRY_SERIALIZING_13270926386983604461)],
        ),
        (
            UniCase::ascii("parallelizing"),
            &[(0b01001, &ENTRY_PARALLELIZING_10961993960559405417)],
        ),
        (
            UniCase::ascii("paleozoological"),
            &[(0b10001, &ENTRY_PALEOZOOLOGICAL_8783617239969730799)],
        ),
        (
            UniCase::ascii("precolors"),
            &[(0b10001, &ENTRY_PRECOLORS_9083220684090884764)],
        ),
        (
            UniCase::ascii("faradises"),
            &[(0b10010, &ENTRY_FARADIZES_516381975059492431)],
        ),
        (
            UniCase::ascii("tenementisations"),
            &[(0b10010, &ENTRY_TENEMENTIZATIONS_3755446656409966534)],
        ),
        (
            UniCase::ascii("honorabler"),
            &[(0b11001, &ENTRY_HONORABLER_1697067400290285301)],
        ),
        (
            UniCase::ascii("chloremia"),
            &[(0b10001, &ENTRY_CHLOREMIA_11927970491263400748)],
        ),
        (
            UniCase::ascii("editorialize"),
            &[(0b01001, &ENTRY_EDITORIALIZE_425925589943067801)],
        ),
        (
            UniCase::ascii("palaeoclimatological"),
            &[(0b11010, &ENTRY_PALEOCLIMATOLOGICAL_1574786532199586705)],
        ),
        (
            UniCase::ascii("hemocyte"),
            &[(0b10001, &ENTRY_HEMOCYTE_15334672110474097892)],
        ),
        (
            UniCase::ascii("kidnapers"),
            &[(0b00001, &ENTRY_KIDNAPPERS_7511485392866911549)],
        ),
        (
            UniCase::ascii("victimizables"),
            &[(0b01001, &ENTRY_VICTIMIZABLES_1207522680409246759)],
        ),
        (
            UniCase::ascii("celestializes"),
            &[(0b01001, &ENTRY_CELESTIALIZES_10058751039284937485)],
        ),
        (
            UniCase::ascii("chemicalizes"),
            &[(0b01001, &ENTRY_CHEMICALIZES_17947429043522126420)],
        ),
        (
            UniCase::ascii("initialisable"),
            &[(0b10010, &ENTRY_INITIALIZABLE_7321355618285398649)],
        ),
        (
            UniCase::ascii("metathesise"),
            &[(0b10010, &ENTRY_METATHESIZE_7314132290356926964)],
        ),
        (
            UniCase::ascii("courge"),
            &[(0b11010, &ENTRY_CORGE_17139623337126675741)],
        ),
        (
            UniCase::ascii("communalizers"),
            &[(0b01001, &ENTRY_COMMUNALIZERS_1419522334270734921)],
        ),
        (
            UniCase::ascii("apothegmatize"),
            &[(0b01001, &ENTRY_APOTHEGMATIZE_9149577190229122350)],
        ),
        (
            UniCase::ascii("frivoled"),
            &[(0b00001, &ENTRY_FRIVOLED_6394892650858522123)],
        ),
        (
            UniCase::ascii("nesslerise"),
            &[(0b10010, &ENTRY_NESSLERIZE_6021492543047774975)],
        ),
        (
            UniCase::ascii("resterilize"),
            &[(0b01001, &ENTRY_RESTERILIZE_4378046269917637799)],
        ),
        (
            UniCase::ascii("radializations"),
            &[(0b01001, &ENTRY_RADIALIZATIONS_15793970150795442621)],
        ),
        (
            UniCase::ascii("arterialize"),
            &[(0b01001, &ENTRY_ARTERIALIZE_4417484011804302892)],
        ),
        (
            UniCase::ascii("gaoler"),
            &[(0b10010, &ENTRY_JAILER_1369890010036246012)],
        ),
        (
            UniCase::ascii("paleogeology"),
            &[(0b10001, &ENTRY_PALEOGEOLOGY_1446971404483318371)],
        ),
        (
            UniCase::ascii("homogenisations"),
            &[(0b10010, &ENTRY_HOMOGENIZATIONS_6507363217080422658)],
        ),
        (
            UniCase::ascii("lilliputianizes"),
            &[(0b01001, &ENTRY_LILLIPUTIANIZES_16811775630936201889)],
        ),
        (
            UniCase::ascii("gramme"),
            &[(0b10010, &ENTRY_GRAM_9361867859862457841)],
        ),
        (
            UniCase::ascii("nonsympathisers"),
            &[(0b10010, &ENTRY_NONSYMPATHIZERS_17703989460577560108)],
        ),
        (
            UniCase::ascii("metres"),
            &[(0b11010, &ENTRY_METERS_17916328899664667470)],
        ),
        (
            UniCase::ascii("vulcanizates"),
            &[(0b01001, &ENTRY_VULCANIZATES_16942202816352460180)],
        ),
        (
            UniCase::ascii("gospelises"),
            &[(0b10010, &ENTRY_GOSPELIZES_4662692098801017919)],
        ),
        (
            UniCase::ascii("hectolitres"),
            &[(0b11010, &ENTRY_HECTOLITERS_63081804785897288)],
        ),
        (
            UniCase::ascii("precivilisations"),
            &[(0b10010, &ENTRY_PRECIVILIZATIONS_15617845600007536715)],
        ),
        (
            UniCase::ascii("revivalize"),
            &[(0b01001, &ENTRY_REVIVALIZE_12399394256488111764)],
        ),
        (
            UniCase::ascii("sensitization"),
            &[(0b01001, &ENTRY_SENSITIZATION_5562142577083526555)],
        ),
        (
            UniCase::ascii("preutilisables"),
            &[(0b10010, &ENTRY_PREUTILIZABLES_16060283126975272357)],
        ),
        (
            UniCase::ascii("aeaetes"),
            &[(0b11010, &ENTRY_AEETES_13066320965486982172)],
        ),
        (
            UniCase::ascii("colourised"),
            &[(0b10010, &ENTRY_COLORIZED_1927556635004418734)],
        ),
        (
            UniCase::ascii("etherised"),
            &[(0b10010, &ENTRY_ETHERIZED_13463455547519294082)],
        ),
        (
            UniCase::ascii("misrecognizes"),
            &[(0b01001, &ENTRY_MISRECOGNIZES_18195281488073038600)],
        ),
        (
            UniCase::ascii("entamoeba"),
            &[(0b11010, &ENTRY_ENTAMEBA_11793706106302208785)],
        ),
        (
            UniCase::ascii("yodellers"),
            &[(0b11010, &ENTRY_YODELERS_2440942956900301409)],
        ),
        (
            UniCase::ascii("paynises"),
            &[(0b10010, &ENTRY_PAYNIZES_15490955026943979655)],
        ),
        (
            UniCase::ascii("parallelisations"),
            &[(0b10010, &ENTRY_PARALLELIZATIONS_5527525018980081767)],
        ),
        (
            UniCase::ascii("endamebae"),
            &[(0b00001, &ENTRY_ENDAMEBAE_7672591039700210017)],
        ),
        (
            UniCase::ascii("mathematization"),
            &[(0b01001, &ENTRY_MATHEMATIZATION_11635475143822716979)],
        ),
        (
            UniCase::ascii("universalized"),
            &[(0b01001, &ENTRY_UNIVERSALIZED_3359716000611655342)],
        ),
        (
            UniCase::ascii("preneural"),
            &[(0b00001, &ENTRY_PRENEURAL_3562453023809034170)],
        ),
        (
            UniCase::ascii("palaeoglyph"),
            &[(0b11010, &ENTRY_PALEOGLYPH_15757196795062379228)],
        ),
        (
            UniCase::ascii("realizabler"),
            &[(0b01001, &ENTRY_REALIZABLER_10808842652675364031)],
        ),
        (
            UniCase::ascii("bacterias"),
            &[(0b00001, &ENTRY_BACTERIA_932829979244663072)],
        ),
        (
            UniCase::ascii("sectorize"),
            &[(0b01001, &ENTRY_SECTORIZE_16349435987024198076)],
        ),
        (
            UniCase::ascii("downdraught"),
            &[(0b10010, &ENTRY_DOWNDRAFT_9039488072887961853)],
        ),
        (
            UniCase::ascii("schedulises"),
            &[(0b10010, &ENTRY_SCHEDULIZES_11998681560108042990)],
        ),
        (
            UniCase::ascii("popularizer"),
            &[(0b01001, &ENTRY_POPULARIZER_6873378968353377212)],
        ),
        (
            UniCase::ascii("mobilised"),
            &[(0b10010, &ENTRY_MOBILIZED_13415546459102928772)],
        ),
        (
            UniCase::ascii("monopolized"),
            &[(0b01001, &ENTRY_MONOPOLIZED_10461001871096365991)],
        ),
        (
            UniCase::ascii("triangularising"),
            &[(0b10010, &ENTRY_TRIANGULARIZING_6298865978999024428)],
        ),
        (
            UniCase::ascii("ornamentalises"),
            &[(0b10010, &ENTRY_ORNAMENTALIZES_17286281591371268395)],
        ),
        (
            UniCase::ascii("blastulae"),
            &[(0b11010, &ENTRY_BLASTULE_6565332400736377843)],
        ),
        (
            UniCase::ascii("ventres"),
            &[(0b11010, &ENTRY_VENTERS_5205786364593283296)],
        ),
        (
            UniCase::ascii("baronetised"),
            &[(0b10010, &ENTRY_BARONETIZED_15717984216308695709)],
        ),
        (
            UniCase::ascii("unepitomized"),
            &[(0b01001, &ENTRY_UNEPITOMIZED_14848321193589314772)],
        ),
        (
            UniCase::ascii("paleocrystic"),
            &[(0b10001, &ENTRY_PALEOCRYSTIC_2695211631331372901)],
        ),
        (
            UniCase::ascii("caponizes"),
            &[(0b01001, &ENTRY_CAPONIZES_8415080645445299415)],
        ),
        (
            UniCase::ascii("provincialisation"),
            &[(0b10010, &ENTRY_PROVINCIALIZATION_13831389932205748314)],
        ),
        (
            UniCase::ascii("unwesternized"),
            &[(0b01001, &ENTRY_UNWESTERNIZED_2338020082584820680)],
        ),
        (
            UniCase::ascii("peised"),
            &[(0b10010, &ENTRY_PEIZED_12509957894247332986)],
        ),
        (
            UniCase::ascii("coenamored"),
            &[(0b10001, &ENTRY_COENAMORED_9568490962748517648)],
        ),
        (
            UniCase::ascii("miterworts"),
            &[(0b00001, &ENTRY_MITERWORTS_2595793822662820807)],
        ),
        (
            UniCase::ascii("cutizations"),
            &[(0b01001, &ENTRY_CUTIZATIONS_12588515800323296191)],
        ),
        (
            UniCase::ascii("fragmentises"),
            &[(0b10010, &ENTRY_FRAGMENTIZES_9129150506354302185)],
        ),
        (
            UniCase::ascii("palaeoichthyology"),
            &[(0b11010, &ENTRY_PALEOICHTHYOLOGY_7690182781909447343)],
        ),
        (
            UniCase::ascii("granulise"),
            &[(0b10010, &ENTRY_GRANULIZE_106086847220442662)],
        ),
        (
            UniCase::ascii("ironizes"),
            &[(0b01001, &ENTRY_IRONIZES_17019087894237992930)],
        ),
        (
            UniCase::ascii("prosopopeia"),
            &[(0b01001, &ENTRY_PROSOPOPOEIA_18371169721208163527)],
        ),
        (
            UniCase::ascii("coursy"),
            &[(0b11010, &ENTRY_CORSY_8397709613851582338)],
        ),
        (
            UniCase::ascii("frictionize"),
            &[(0b01001, &ENTRY_FRICTIONIZE_8871056937955154076)],
        ),
        (
            UniCase::ascii("medaling"),
            &[(0b00001, &ENTRY_MEDALING_15272839155813995206)],
        ),
        (
            UniCase::ascii("unrancoureds"),
            &[(0b11010, &ENTRY_UNRANCOREDS_12103687684487901758)],
        ),
        (
            UniCase::ascii("counsellors"),
            &[(0b11010, &ENTRY_COUNSELORS_13992003748073450387)],
        ),
        (
            UniCase::ascii("scandalizer"),
            &[(0b01001, &ENTRY_SCANDALIZER_5001392876013065734)],
        ),
        (
            UniCase::ascii("melanised"),
            &[(0b10010, &ENTRY_MELANIZED_5005801037460172353)],
        ),
        (
            UniCase::ascii("rumourmonger"),
            &[(0b11010, &ENTRY_RUMORMONGER_7299548335065542796)],
        ),
        (
            UniCase::ascii("phenogenetic"),
            &[(0b00001, &ENTRY_PHENOGENETIC_17720618598147822936)],
        ),
        (
            UniCase::ascii("idolise"),
            &[(0b10010, &ENTRY_IDOLIZE_2701460930995107542)],
        ),
        (
            UniCase::ascii("satanises"),
            &[(0b10010, &ENTRY_SATANIZES_4037603454744610431)],
        ),
        (
            UniCase::ascii("beglamor"),
            &[(0b10001, &ENTRY_BEGLAMOR_13712112495668100470)],
        ),
        (
            UniCase::ascii("heterism"),
            &[(0b10001, &ENTRY_HETERISM_629753888071252179)],
        ),
        (
            UniCase::ascii("krein"),
            &[(0b11010, &ENTRY_KERIN_12119680575777787053)],
        ),
        (
            UniCase::ascii("nonlocaliseds"),
            &[(0b10010, &ENTRY_NONLOCALIZEDS_12719123077518106411)],
        ),
        (
            UniCase::ascii("anemia"),
            &[(0b11001, &ENTRY_ANEMIA_11444125334540196345)],
        ),
        (
            UniCase::ascii("syllogized"),
            &[(0b01001, &ENTRY_SYLLOGIZED_8853526086846614350)],
        ),
        (
            UniCase::ascii("achromatizations"),
            &[(0b01001, &ENTRY_ACHROMATIZATIONS_17303571046130875052)],
        ),
        (
            UniCase::ascii("goramies"),
            &[(0b00001, &ENTRY_GORAMIES_15606246035840811431)],
        ),
        (
            UniCase::ascii("phlyctena"),
            &[(0b00001, &ENTRY_PHLYCTENA_8261775604592086893)],
        ),
        (
            UniCase::ascii("phytoecology"),
            &[(0b00001, &ENTRY_PHYTOECOLOGY_3833250044946066382)],
        ),
        (
            UniCase::ascii("aphorizes"),
            &[(0b01001, &ENTRY_APHORIZES_13164228522572019559)],
        ),
        (
            UniCase::ascii("computerising"),
            &[(0b10010, &ENTRY_COMPUTERIZING_12865766678094814563)],
        ),
        (
            UniCase::ascii("favouredness"),
            &[(0b11010, &ENTRY_FAVOREDNESS_12375820644528192720)],
        ),
        (
            UniCase::ascii("passivization"),
            &[(0b01001, &ENTRY_PASSIVIZATION_14743361941945546861)],
        ),
        (
            UniCase::ascii("mercerising"),
            &[(0b10010, &ENTRY_MERCERIZING_12341499939260844341)],
        ),
        (
            UniCase::ascii("uncatholicize"),
            &[(0b01001, &ENTRY_UNCATHOLICIZE_8425737943401304561)],
        ),
        (
            UniCase::ascii("unoxidisable"),
            &[(0b10010, &ENTRY_UNOXIDIZABLE_16109933882822047402)],
        ),
        (
            UniCase::ascii("unminimized"),
            &[(0b01001, &ENTRY_UNMINIMIZED_2413573858255300069)],
        ),
        (
            UniCase::ascii("conceptualises"),
            &[(0b10010, &ENTRY_CONCEPTUALIZES_17221094629974506736)],
        ),
        (
            UniCase::ascii("cyanising"),
            &[(0b10010, &ENTRY_CYANIZING_13714646055406888213)],
        ),
        (
            UniCase::ascii("gyrostabilizations"),
            &[(0b01001, &ENTRY_GYROSTABILIZATIONS_9084662166713279380)],
        ),
        (
            UniCase::ascii("unsympathiseddest"),
            &[(0b10010, &ENTRY_UNSYMPATHIZEDDEST_11795335826469372906)],
        ),
        (
            UniCase::ascii("mongolized"),
            &[(0b01001, &ENTRY_MONGOLIZED_7180490123154768644)],
        ),
        (
            UniCase::ascii("literalises"),
            &[(0b10010, &ENTRY_LITERALIZES_14783446531151201125)],
        ),
        (
            UniCase::ascii("kinaesthesis"),
            &[(0b11010, &ENTRY_KINESTHESIS_11584641061195125769)],
        ),
        (
            UniCase::ascii("overgeneralise"),
            &[(0b10010, &ENTRY_OVERGENERALIZE_12617960222070124101)],
        ),
        (
            UniCase::ascii("denaturized"),
            &[(0b01001, &ENTRY_DENATURIZED_11293306666666002972)],
        ),
        (
            UniCase::ascii("tetanise"),
            &[(0b10010, &ENTRY_TETANIZE_13125818857178721563)],
        ),
        (
            UniCase::ascii("hooverizes"),
            &[(0b01001, &ENTRY_HOOVERIZES_11190309671847930638)],
        ),
        (
            UniCase::ascii("araeometric"),
            &[(0b11010, &ENTRY_AREOMETRIC_17639504932600545758)],
        ),
        (
            UniCase::ascii("programers"),
            &[(0b00001, &ENTRY_PROGRAMMERS_4515854859838156319)],
        ),
        (
            UniCase::ascii("trimerization"),
            &[(0b01001, &ENTRY_TRIMERIZATION_12375953829418021021)],
        ),
        (
            UniCase::ascii("vectoriser"),
            &[(0b10010, &ENTRY_VECTORIZER_12091376211856766051)],
        ),
        (
            UniCase::ascii("archaeologian"),
            &[(0b11010, &ENTRY_ARCHEOLOGIAN_11401650089021570001)],
        ),
        (
            UniCase::ascii("theologizations"),
            &[(0b01001, &ENTRY_THEOLOGIZATIONS_1637833144071496386)],
        ),
        (
            UniCase::ascii("deenergises"),
            &[(0b10010, &ENTRY_DEENERGIZES_12119467381981965243)],
        ),
        (
            UniCase::ascii("privatizes"),
            &[(0b01001, &ENTRY_PRIVATIZES_13414685946229171001)],
        ),
        (
            UniCase::ascii("bedriveling"),
            &[(0b00001, &ENTRY_BEDRIVELING_12159930547505129231)],
        ),
        (
            UniCase::ascii("symptomatizing"),
            &[(0b01001, &ENTRY_SYMPTOMATIZING_7075635847781625915)],
        ),
        (
            UniCase::ascii("tubulizations"),
            &[(0b01001, &ENTRY_TUBULIZATIONS_10015790438190867364)],
        ),
        (
            UniCase::ascii("empathises"),
            &[(0b10010, &ENTRY_EMPATHIZES_3252518257724496702)],
        ),
        (
            UniCase::ascii("estheses"),
            &[(0b00001, &ENTRY_ESTHESES_16116389526306967239)],
        ),
        (
            UniCase::ascii("insurrectionized"),
            &[(0b01001, &ENTRY_INSURRECTIONIZED_9902157018267694954)],
        ),
        (
            UniCase::ascii("niggardised"),
            &[(0b10010, &ENTRY_NIGGARDIZED_4556331947580220081)],
        ),
        (
            UniCase::ascii("spectrelikes"),
            &[(0b11010, &ENTRY_SPECTERLIKES_484157250269129460)],
        ),
        (
            UniCase::ascii("pedotrophic"),
            &[(0b00001, &ENTRY_PEDOTROPHIC_4225819697418345119)],
        ),
        (
            UniCase::ascii("anoestri"),
            &[(0b11010, &ENTRY_ANESTRI_8008769930372220485)],
        ),
        (
            UniCase::ascii("unpenalizeddest"),
            &[(0b01001, &ENTRY_UNPENALIZEDDEST_9469524353322915881)],
        ),
        (
            UniCase::ascii("suburbanisation"),
            &[(0b10010, &ENTRY_SUBURBANIZATION_5041053547374142641)],
        ),
        (
            UniCase::ascii("grammaticized"),
            &[(0b01001, &ENTRY_GRAMMATICIZED_555586288585252490)],
        ),
        (
            UniCase::ascii("humorful"),
            &[(0b11001, &ENTRY_HUMORFUL_15115567956635786701)],
        ),
        (
            UniCase::ascii("vernalise"),
            &[(0b10010, &ENTRY_VERNALIZE_12962724599289195261)],
        ),
        (
            UniCase::ascii("pericecal"),
            &[(0b00001, &ENTRY_PERICECAL_5535752974684809547)],
        ),
        (
            UniCase::ascii("elasticisers"),
            &[(0b10010, &ENTRY_ELASTICIZERS_16095393649186847498)],
        ),
        (
            UniCase::ascii("liters"),
            &[(0b00001, &ENTRY_LITERS_12776695440733823940)],
        ),
        (
            UniCase::ascii("ethicize"),
            &[(0b01001, &ENTRY_ETHICIZE_9319969408983326697)],
        ),
        (
            UniCase::ascii("sorbitize"),
            &[(0b01001, &ENTRY_SORBITIZE_4953121359286386634)],
        ),
        (
            UniCase::ascii("hemins"),
            &[(0b10001, &ENTRY_HEMINS_2205333871048481752)],
        ),
        (
            UniCase::ascii("glamourize"),
            &[(0b01001, &ENTRY_GLAMORIZE_15623953511855635687)],
        ),
        (
            UniCase::ascii("mesmerised"),
            &[(0b10010, &ENTRY_MESMERIZED_14030290228729285174)],
        ),
        (
            UniCase::ascii("prepaleolithic"),
            &[(0b00001, &ENTRY_PREPALEOLITHIC_14202951488126805096)],
        ),
        (
            UniCase::ascii("hypogaeic"),
            &[(0b11010, &ENTRY_HYPOGEIC_8668126381759058087)],
        ),
        (
            UniCase::ascii("unhonourables"),
            &[(0b11010, &ENTRY_UNHONORABLES_5002839830632485659)],
        ),
        (
            UniCase::ascii("slavises"),
            &[(0b10010, &ENTRY_SLAVIZES_13267642890664123364)],
        ),
        (
            UniCase::ascii("preinitialised"),
            &[(0b10010, &ENTRY_PREINITIALIZED_1342530234296788703)],
        ),
        (
            UniCase::ascii("tutelae"),
            &[(0b11010, &ENTRY_TUTELE_16207284368064157603)],
        ),
        (
            UniCase::ascii("demagnetizations"),
            &[(0b01001, &ENTRY_DEMAGNETIZATIONS_17906684919392124321)],
        ),
        (
            UniCase::ascii("particularization"),
            &[(0b01001, &ENTRY_PARTICULARIZATION_10597016863146923743)],
        ),
        (
            UniCase::ascii("unfraternizing"),
            &[(0b01001, &ENTRY_UNFRATERNIZING_11945792457598246703)],
        ),
        (
            UniCase::ascii("concertising"),
            &[(0b10010, &ENTRY_CONCERTIZING_823694797397139539)],
        ),
        (
            UniCase::ascii("toryise"),
            &[(0b10010, &ENTRY_TORYIZE_10210463142410101593)],
        ),
        (
            UniCase::ascii("janisary"),
            &[(0b10010, &ENTRY_JANIZARY_5645655583936688977)],
        ),
        (
            UniCase::ascii("chloroformizations"),
            &[(0b01001, &ENTRY_CHLOROFORMIZATIONS_10258939630473669855)],
        ),
        (
            UniCase::ascii("decapitalisation"),
            &[(0b10010, &ENTRY_DECAPITALIZATION_10013185676274515636)],
        ),
        (
            UniCase::ascii("chamisal"),
            &[(0b10010, &ENTRY_CHAMIZAL_15395913577609401131)],
        ),
        (
            UniCase::ascii("atmolysing"),
            &[(0b10010, &ENTRY_ATMOLYZING_12067305970424863391)],
        ),
        (
            UniCase::ascii("theologize"),
            &[(0b01001, &ENTRY_THEOLOGIZE_7414032072871637264)],
        ),
        (
            UniCase::ascii("unpolarizeddest"),
            &[(0b01001, &ENTRY_UNPOLARIZEDDEST_6022870955853565151)],
        ),
        (
            UniCase::ascii("dedramatise"),
            &[(0b10010, &ENTRY_DEDRAMATIZE_13453343698039522020)],
        ),
        (
            UniCase::ascii("overemphasises"),
            &[(0b10010, &ENTRY_OVEREMPHASIZES_3357752816724585460)],
        ),
        (
            UniCase::ascii("provincialize"),
            &[(0b01001, &ENTRY_PROVINCIALIZE_15342640692775315618)],
        ),
        (
            UniCase::ascii("vandalises"),
            &[(0b10010, &ENTRY_VANDALIZES_950444592106680495)],
        ),
        (
            UniCase::ascii("splanchnocele"),
            &[(0b00001, &ENTRY_SPLANCHNOCELE_10962826556710463329)],
        ),
        (
            UniCase::ascii("erns"),
            &[(0b00001, &ENTRY_ERNS_11958672731540988082)],
        ),
        (
            UniCase::ascii("radborne"),
            &[(0b00001, &ENTRY_RADBORNE_10850064437245752174)],
        ),
        (
            UniCase::ascii("dematerialised"),
            &[(0b10010, &ENTRY_DEMATERIALIZED_7148599036847365626)],
        ),
        (
            UniCase::ascii("colourisations"),
            &[(0b10010, &ENTRY_COLORIZATIONS_4267572307963209982)],
        ),
        (
            UniCase::ascii("misorganizations"),
            &[(0b01001, &ENTRY_MISORGANIZATIONS_15826994608931053543)],
        ),
        (
            UniCase::ascii("superacknowledgement"),
            &[(0b11010, &ENTRY_SUPERACKNOWLEDGMENT_18055315220706538962)],
        ),
        (
            UniCase::ascii("uncolourable"),
            &[(0b11010, &ENTRY_UNCOLORABLE_16859002938981914415)],
        ),
        (
            UniCase::ascii("gynaecologicals"),
            &[(0b10010, &ENTRY_GYNECOLOGICALS_12284377184405525261)],
        ),
        (
            UniCase::ascii("unhouseled"),
            &[(0b00001, &ENTRY_UNHOUSELED_8799017796220250092)],
        ),
        (
            UniCase::ascii("uncivilisablest"),
            &[(0b10010, &ENTRY_UNCIVILIZABLEST_7329790362151161087)],
        ),
        (
            UniCase::ascii("climatises"),
            &[(0b10010, &ENTRY_CLIMATIZES_13429047652583201954)],
        ),
        (
            UniCase::ascii("precolours"),
            &[(0b11010, &ENTRY_PRECOLORS_9083220684090884764)],
        ),
        (
            UniCase::ascii("overcentralize"),
            &[(0b01001, &ENTRY_OVERCENTRALIZE_3364160969428038703)],
        ),
        (
            UniCase::ascii("resensitises"),
            &[(0b10010, &ENTRY_RESENSITIZES_12908617404622953233)],
        ),
        (
            UniCase::ascii("hypocentres"),
            &[(0b11010, &ENTRY_HYPOCENTERS_8535258706052045382)],
        ),
        (
            UniCase::ascii("achaeniums"),
            &[(0b11010, &ENTRY_ACHENIUMS_13963140948852387190)],
        ),
        (
            UniCase::ascii("penalizables"),
            &[(0b01001, &ENTRY_PENALIZABLES_14294337734166643281)],
        ),
        (
            UniCase::ascii("glycogenises"),
            &[(0b10010, &ENTRY_GLYCOGENIZES_8753992975266531652)],
        ),
        (
            UniCase::ascii("ferd"),
            &[(0b00001, &ENTRY_FERD_17290726529250186020)],
        ),
        (
            UniCase::ascii("aerology"),
            &[(0b00001, &ENTRY_AEROLOGY_2536724281135360580)],
        ),
        (
            UniCase::ascii("formalises"),
            &[(0b10010, &ENTRY_FORMALIZES_15952411364716226248)],
        ),
        (
            UniCase::ascii("canonised"),
            &[(0b10010, &ENTRY_CANONIZED_4794312694447620033)],
        ),
        (
            UniCase::ascii("labilizations"),
            &[(0b01001, &ENTRY_LABILIZATIONS_17617289251407409872)],
        ),
        (
            UniCase::ascii("prespecializes"),
            &[(0b01001, &ENTRY_PRESPECIALIZES_4338740854406485524)],
        ),
        (
            UniCase::ascii("haematins"),
            &[(0b11010, &ENTRY_HEMATINS_3508374996795413939)],
        ),
        (
            UniCase::ascii("hybridise"),
            &[(0b10010, &ENTRY_HYBRIDIZE_12739035965572292237)],
        ),
        (
            UniCase::ascii("semiorganiseds"),
            &[(0b10010, &ENTRY_SEMIORGANIZEDS_12008364003973962769)],
        ),
        (
            UniCase::ascii("pemmicanization"),
            &[(0b01001, &ENTRY_PEMMICANIZATION_3498493847858548991)],
        ),
        (
            UniCase::ascii("laborlesses"),
            &[(0b11001, &ENTRY_LABORLESSES_3618662866437106672)],
        ),
        (
            UniCase::ascii("disfavorers"),
            &[(0b11001, &ENTRY_DISFAVORERS_18430656322920499015)],
        ),
        (
            UniCase::ascii("capitaliser"),
            &[(0b10010, &ENTRY_CAPITALIZER_15938335196315218634)],
        ),
        (
            UniCase::ascii("fluoridized"),
            &[(0b01001, &ENTRY_FLUORIDIZED_3488303050093414681)],
        ),
        (
            UniCase::ascii("spelaeothems"),
            &[(0b11010, &ENTRY_SPELEOTHEMS_10285341670778918846)],
        ),
        (
            UniCase::ascii("extraverts"),
            &[(0b10011, &ENTRY_EXTROVERTS_17343931619747038542)],
        ),
        (
            UniCase::ascii("gluttonised"),
            &[(0b10010, &ENTRY_GLUTTONIZED_4146378212700912723)],
        ),
        (
            UniCase::ascii("apocenter"),
            &[(0b00001, &ENTRY_APOCENTER_6510924298032028131)],
        ),
        (
            UniCase::ascii("celoms"),
            &[(0b11001, &ENTRY_CELOMS_16869648723221026513)],
        ),
        (
            UniCase::ascii("centerless"),
            &[(0b00001, &ENTRY_CENTERLESS_16010100430566689787)],
        ),
        (
            UniCase::ascii("triangularizing"),
            &[(0b01001, &ENTRY_TRIANGULARIZING_6298865978999024428)],
        ),
        (
            UniCase::ascii("colorifics"),
            &[(0b00001, &ENTRY_COLORIFICS_7493178994191350405)],
        ),
        (
            UniCase::ascii("radialise"),
            &[(0b10010, &ENTRY_RADIALIZE_4331722839835606750)],
        ),
        (
            UniCase::ascii("polymerisation"),
            &[(0b10010, &ENTRY_POLYMERIZATION_18049461613528686745)],
        ),
        (
            UniCase::ascii("canonization"),
            &[(0b01001, &ENTRY_CANONIZATION_5080602976142523102)],
        ),
        (
            UniCase::ascii("reveled"),
            &[(0b00001, &ENTRY_REVELED_3269597357727386753)],
        ),
        (
            UniCase::ascii("calcemia"),
            &[(0b10001, &ENTRY_CALCEMIA_1283576588856942148)],
        ),
        (
            UniCase::ascii("favorable"),
            &[(0b11001, &ENTRY_FAVORABLE_16585220116684679375)],
        ),
        (
            UniCase::ascii("homoeothermal"),
            &[(0b11010, &ENTRY_HOMEOTHERMAL_12106163977771685441)],
        ),
        (
            UniCase::ascii("serpentinise"),
            &[(0b10010, &ENTRY_SERPENTINIZE_9866240419191948775)],
        ),
        (
            UniCase::ascii("epitomising"),
            &[(0b10010, &ENTRY_EPITOMIZING_9913028102891579136)],
        ),
        (
            UniCase::ascii("satirisables"),
            &[(0b10010, &ENTRY_SATIRIZABLES_12495079216543111113)],
        ),
        (
            UniCase::ascii("feriae"),
            &[(0b11010, &ENTRY_FERIE_16904944536625577586)],
        ),
        (
            UniCase::ascii("unchastised"),
            &[(0b10010, &ENTRY_UNCHASTIZED_4193981014376295283)],
        ),
        (
            UniCase::ascii("macadamization"),
            &[(0b01001, &ENTRY_MACADAMIZATION_10150094710685608161)],
        ),
        (
            UniCase::ascii("caramelizes"),
            &[(0b01001, &ENTRY_CARAMELIZES_12354251654432497813)],
        ),
        (
            UniCase::ascii("teutonised"),
            &[(0b10010, &ENTRY_TEUTONIZED_10064813533808905253)],
        ),
        (
            UniCase::ascii("sceptic"),
            &[(0b11010, &ENTRY_SKEPTIC_9366141399207033866)],
        ),
        (
            UniCase::ascii("archaean"),
            &[(0b11010, &ENTRY_ARCHEAN_14847398170729505321)],
        ),
        (
            UniCase::ascii("deodorizers"),
            &[(0b01001, &ENTRY_DEODORIZERS_7206686442131612842)],
        ),
        (
            UniCase::ascii("taboured"),
            &[(0b11010, &ENTRY_TABORED_3458012263090109952)],
        ),
        (
            UniCase::ascii("rubberizes"),
            &[(0b01001, &ENTRY_RUBBERIZES_3912030953974462546)],
        ),
        (
            UniCase::ascii("prelabour"),
            &[(0b11010, &ENTRY_PRELABOR_12579549139000343078)],
        ),
        (
            UniCase::ascii("tuberculinising"),
            &[(0b10010, &ENTRY_TUBERCULINIZING_8221476597985863464)],
        ),
        (
            UniCase::ascii("prelectress"),
            &[(0b00001, &ENTRY_PRELECTRESS_16642358695295070918)],
        ),
        (
            UniCase::ascii("derr"),
            &[(0b00001, &ENTRY_DERR_8497357744990730455)],
        ),
        (
            UniCase::ascii("graecism"),
            &[(0b11010, &ENTRY_GRECISM_16474963217213327368)],
        ),
        (
            UniCase::ascii("neighborlesser"),
            &[(0b10001, &ENTRY_NEIGHBORLESSER_3537443539054487075)],
        ),
        (
            UniCase::ascii("underemphasized"),
            &[(0b01001, &ENTRY_UNDEREMPHASIZED_13287064872491391347)],
        ),
        (
            UniCase::ascii("maisters"),
            &[(0b00001, &ENTRY_MAISTERS_169323063843277028)],
        ),
        (
            UniCase::ascii("recolonizing"),
            &[(0b01001, &ENTRY_RECOLONIZING_15474385751968098455)],
        ),
        (
            UniCase::ascii("decriminalizes"),
            &[(0b01001, &ENTRY_DECRIMINALIZES_6368952306309816010)],
        ),
        (
            UniCase::ascii("heroinize"),
            &[(0b01001, &ENTRY_HEROINIZE_7929779025273191656)],
        ),
        (
            UniCase::ascii("catholicize"),
            &[(0b01001, &ENTRY_CATHOLICIZE_4285061554275370513)],
        ),
        (
            UniCase::ascii("vulgarization"),
            &[(0b01001, &ENTRY_VULGARIZATION_9399086175034751352)],
        ),
        (
            UniCase::ascii("nectarized"),
            &[(0b01001, &ENTRY_NECTARIZED_7371569570789937934)],
        ),
        (
            UniCase::ascii("cantonization"),
            &[(0b01001, &ENTRY_CANTONIZATION_6677109296433610186)],
        ),
        (
            UniCase::ascii("wantonising"),
            &[(0b10010, &ENTRY_WANTONIZING_11612419212222365365)],
        ),
        (
            UniCase::ascii("paleocrystalline"),
            &[(0b10001, &ENTRY_PALEOCRYSTALLINE_10365119975362565017)],
        ),
        (
            UniCase::ascii("deoxidisation"),
            &[(0b10010, &ENTRY_DEOXIDIZATION_7394934458510098573)],
        ),
        (
            UniCase::ascii("nasalize"),
            &[(0b01001, &ENTRY_NASALIZE_15126394964863135289)],
        ),
        (
            UniCase::ascii("annualizes"),
            &[(0b01001, &ENTRY_ANNUALIZES_784688421746976936)],
        ),
        (
            UniCase::ascii("neutralising"),
            &[(0b10010, &ENTRY_NEUTRALIZING_13668110192955702906)],
        ),
        (
            UniCase::ascii("sacramentize"),
            &[(0b01001, &ENTRY_SACRAMENTIZE_5105033131237471754)],
        ),
        (
            UniCase::ascii("enigmatize"),
            &[(0b01001, &ENTRY_ENIGMATIZE_10416979299826385433)],
        ),
        (
            UniCase::ascii("christianisers"),
            &[(0b10010, &ENTRY_CHRISTIANIZERS_2108724649580713236)],
        ),
        (
            UniCase::ascii("slavonizing"),
            &[(0b01001, &ENTRY_SLAVONIZING_13559715578718041723)],
        ),
        (
            UniCase::ascii("systemising"),
            &[(0b10010, &ENTRY_SYSTEMIZING_11787131178563974725)],
        ),
        (
            UniCase::ascii("dieselisations"),
            &[(0b10010, &ENTRY_DIESELIZATIONS_14749287237278344971)],
        ),
        (
            UniCase::ascii("undercolour"),
            &[(0b11010, &ENTRY_UNDERCOLOR_8519534420778344085)],
        ),
        (
            UniCase::ascii("randomiser"),
            &[(0b10010, &ENTRY_RANDOMIZER_17355019921057008602)],
        ),
        (
            UniCase::ascii("subvitalizeds"),
            &[(0b01001, &ENTRY_SUBVITALIZEDS_319956284183288639)],
        ),
        (
            UniCase::ascii("labialisation"),
            &[(0b10010, &ENTRY_LABIALIZATION_15293853718014014842)],
        ),
        (
            UniCase::ascii("epigean"),
            &[(0b00001, &ENTRY_EPIGEAN_1067479460708884657)],
        ),
        (
            UniCase::ascii("organisational"),
            &[(0b10010, &ENTRY_ORGANIZATIONAL_11623270165270540295)],
        ),
        (
            UniCase::ascii("schedulize"),
            &[(0b01001, &ENTRY_SCHEDULIZE_5696008845820733070)],
        ),
        (
            UniCase::ascii("hyperlipemic"),
            &[(0b10001, &ENTRY_HYPERLIPEMIC_14507717637329252900)],
        ),
        (
            UniCase::ascii("disdiplomatize"),
            &[(0b01001, &ENTRY_DISDIPLOMATIZE_885764438051293853)],
        ),
        (
            UniCase::ascii("supercivilisations"),
            &[(0b10010, &ENTRY_SUPERCIVILIZATIONS_2634390504398689511)],
        ),
        (
            UniCase::ascii("pictorialises"),
            &[(0b10010, &ENTRY_PICTORIALIZES_17175738548381080003)],
        ),
        (
            UniCase::ascii("unschematisedder"),
            &[(0b10010, &ENTRY_UNSCHEMATIZEDDER_4716532793392136205)],
        ),
        (
            UniCase::ascii("rhodanise"),
            &[(0b10010, &ENTRY_RHODANIZE_302153013978993410)],
        ),
        (
            UniCase::ascii("insularize"),
            &[(0b01001, &ENTRY_INSULARIZE_9177745690473314239)],
        ),
        (
            UniCase::ascii("neogaeic"),
            &[(0b11010, &ENTRY_NEOGEIC_15111494082202179702)],
        ),
        (
            UniCase::ascii("depolariser"),
            &[(0b10010, &ENTRY_DEPOLARIZER_13724559510199383868)],
        ),
        (
            UniCase::ascii("pedanticise"),
            &[(0b10010, &ENTRY_PEDANTICIZE_15008322026356551489)],
        ),
        (
            UniCase::ascii("cretinizes"),
            &[(0b01001, &ENTRY_CRETINIZES_15606980122166252360)],
        ),
        (
            UniCase::ascii("dentins"),
            &[(0b00001, &ENTRY_DENTINS_8462696171012072981)],
        ),
        (
            UniCase::ascii("sisterises"),
            &[(0b10010, &ENTRY_SISTERIZES_17019596055143071237)],
        ),
        (
            UniCase::ascii("genealogising"),
            &[(0b10010, &ENTRY_GENEALOGIZING_11925321824699543417)],
        ),
        (
            UniCase::ascii("automatizes"),
            &[(0b01001, &ENTRY_AUTOMATIZES_9261149387605266072)],
        ),
        (
            UniCase::ascii("potentialize"),
            &[(0b01001, &ENTRY_POTENTIALIZE_5306242383006066570)],
        ),
        (
            UniCase::ascii("reinitialize"),
            &[(0b01001, &ENTRY_REINITIALIZE_13966181957218775879)],
        ),
        (
            UniCase::ascii("fae"),
            &[(0b11010, &ENTRY_FE_6412855417629126837)],
        ),
        (
            UniCase::ascii("tuberization"),
            &[(0b01001, &ENTRY_TUBERIZATION_10556809563684052487)],
        ),
        (
            UniCase::ascii("prelocalisations"),
            &[(0b10010, &ENTRY_PRELOCALIZATIONS_6698192050669739492)],
        ),
        (
            UniCase::ascii("tourises"),
            &[(0b10010, &ENTRY_TOURIZES_16287459104895480818)],
        ),
        (
            UniCase::ascii("scourse"),
            &[(0b11010, &ENTRY_SCORSE_15078698805947392168)],
        ),
        (
            UniCase::ascii("tantalisinglier"),
            &[(0b10010, &ENTRY_TANTALIZINGLIER_10045132062074784268)],
        ),
        (
            UniCase::ascii("terrorises"),
            &[(0b10010, &ENTRY_TERRORIZES_7590151466698739569)],
        ),
        (
            UniCase::ascii("fashionises"),
            &[(0b10010, &ENTRY_FASHIONIZES_12948391454225982571)],
        ),
        (
            UniCase::ascii("panderizes"),
            &[(0b01001, &ENTRY_PANDERIZES_1524284286880339446)],
        ),
        (
            UniCase::ascii("feudalize"),
            &[(0b01001, &ENTRY_FEUDALIZE_17118096652700433458)],
        ),
        (
            UniCase::ascii("maneuverablest"),
            &[(0b00001, &ENTRY_MANEUVERABLEST_12615804687818900918)],
        ),
        (
            UniCase::ascii("behaviouristicer"),
            &[(0b11010, &ENTRY_BEHAVIORISTICER_3955710407140770528)],
        ),
        (
            UniCase::ascii("demeanours"),
            &[(0b11010, &ENTRY_DEMEANORS_15645246800979825016)],
        ),
        (
            UniCase::ascii("rigouristic"),
            &[(0b11010, &ENTRY_RIGORISTIC_12345844524001178474)],
        ),
        (
            UniCase::ascii("avianizes"),
            &[(0b01001, &ENTRY_AVIANIZES_6407105568503397650)],
        ),
        (
            UniCase::ascii("areometric"),
            &[
                (0b11010, &ENTRY_AEROMETRIC_13993414140130418477),
                (0b00001, &ENTRY_AREOMETRIC_17639504932600545758),
            ],
        ),
        (
            UniCase::ascii("initialise"),
            &[(0b10010, &ENTRY_INITIALIZE_14137997308893047575)],
        ),
        (
            UniCase::ascii("nounise"),
            &[(0b10010, &ENTRY_NOUNIZE_14880574386923956271)],
        ),
        (
            UniCase::ascii("tantalisers"),
            &[(0b10010, &ENTRY_TANTALIZERS_15746926120203675469)],
        ),
        (
            UniCase::ascii("personalizations"),
            &[(0b01001, &ENTRY_PERSONALIZATIONS_3072710456827540417)],
        ),
        (
            UniCase::ascii("overindustrialize"),
            &[(0b01001, &ENTRY_OVERINDUSTRIALIZE_7348456951187570038)],
        ),
        (
            UniCase::ascii("yoghurt"),
            &[(0b11010, &ENTRY_YOGURT_14795287461115589482)],
        ),
        (
            UniCase::ascii("fantasizes"),
            &[(0b01001, &ENTRY_FANTASIZES_10834180084204721653)],
        ),
        (
            UniCase::ascii("criminalizes"),
            &[(0b01001, &ENTRY_CRIMINALIZES_3410670484073252306)],
        ),
        (
            UniCase::ascii("rampier"),
            &[(0b00001, &ENTRY_RAMPIER_15736266043397566231)],
        ),
        (
            UniCase::ascii("rehumanises"),
            &[(0b10010, &ENTRY_REHUMANIZES_9376605652523591285)],
        ),
        (
            UniCase::ascii("digitalization"),
            &[(0b01001, &ENTRY_DIGITALIZATION_5413639479952668184)],
        ),
        (
            UniCase::ascii("mythologisers"),
            &[(0b10010, &ENTRY_MYTHOLOGIZERS_14789426233370867155)],
        ),
        (
            UniCase::ascii("dynamising"),
            &[(0b10010, &ENTRY_DYNAMIZING_15204260139319478124)],
        ),
        (
            UniCase::ascii("cancelable"),
            &[(0b00001, &ENTRY_CANCELABLE_3744022220960108237)],
        ),
        (
            UniCase::ascii("maximizer"),
            &[(0b01001, &ENTRY_MAXIMIZER_17946247253592585241)],
        ),
        (
            UniCase::ascii("emblematicise"),
            &[(0b10010, &ENTRY_EMBLEMATICIZE_5365410222867877084)],
        ),
        (
            UniCase::ascii("paedomorphosis"),
            &[(0b11010, &ENTRY_PEDOMORPHOSIS_14966272193032820392)],
        ),
        (
            UniCase::ascii("similising"),
            &[(0b10010, &ENTRY_SIMILIZING_1862547745562599944)],
        ),
        (
            UniCase::ascii("mentalization"),
            &[(0b01001, &ENTRY_MENTALIZATION_6058534137827415789)],
        ),
        (
            UniCase::ascii("revisualisation"),
            &[(0b10010, &ENTRY_REVISUALIZATION_8953713191827785558)],
        ),
        (
            UniCase::ascii("theone"),
            &[(0b00001, &ENTRY_THEONE_13907392324350936871)],
        ),
        (
            UniCase::ascii("tutorizations"),
            &[(0b01001, &ENTRY_TUTORIZATIONS_8014516646889352337)],
        ),
        (
            UniCase::ascii("arithmetise"),
            &[(0b10010, &ENTRY_ARITHMETIZE_15576026606241266299)],
        ),
        (
            UniCase::ascii("aesthesia"),
            &[(0b11010, &ENTRY_ESTHESIA_12451548753996008599)],
        ),
        (
            UniCase::ascii("trivialize"),
            &[(0b01001, &ENTRY_TRIVIALIZE_18242589362817679930)],
        ),
        (
            UniCase::ascii("trialization"),
            &[(0b01001, &ENTRY_TRIALIZATION_15902543461546982351)],
        ),
        (
            UniCase::ascii("pogromize"),
            &[(0b01001, &ENTRY_POGROMIZE_6165616786920282232)],
        ),
        (
            UniCase::ascii("prepositure"),
            &[(0b00001, &ENTRY_PREPOSITURE_5966359554589897516)],
        ),
        (
            UniCase::ascii("enamelers"),
            &[(0b00001, &ENTRY_ENAMELERS_7855006556277285142)],
        ),
        (
            UniCase::ascii("demythologizations"),
            &[(0b01001, &ENTRY_DEMYTHOLOGIZATIONS_14134816474323970961)],
        ),
        (
            UniCase::ascii("kerbed"),
            &[(0b10010, &ENTRY_CURBED_15767276793691280481)],
        ),
        (
            UniCase::ascii("emblematization"),
            &[(0b01001, &ENTRY_EMBLEMATIZATION_3037774664990291578)],
        ),
        (
            UniCase::ascii("hemophiliac"),
            &[(0b11001, &ENTRY_HEMOPHILIAC_6895884973735776837)],
        ),
        (
            UniCase::ascii("hyperesthesia"),
            &[(0b10001, &ENTRY_HYPERESTHESIA_3173626697674674219)],
        ),
        (
            UniCase::ascii("unscepters"),
            &[(0b00001, &ENTRY_UNSCEPTERS_3877189759939193522)],
        ),
        (
            UniCase::ascii("harbourful"),
            &[(0b11010, &ENTRY_HARBORFUL_10848468655854650625)],
        ),
        (
            UniCase::ascii("regionalization"),
            &[(0b01001, &ENTRY_REGIONALIZATION_6883441710934248998)],
        ),
        (
            UniCase::ascii("egyptianizes"),
            &[(0b01001, &ENTRY_EGYPTIANIZES_8703144950337739653)],
        ),
        (
            UniCase::ascii("sensitiser"),
            &[(0b10010, &ENTRY_SENSITIZER_10276855194832816189)],
        ),
        (
            UniCase::ascii("antisepticises"),
            &[(0b10010, &ENTRY_ANTISEPTICIZES_13502357588080215816)],
        ),
        (
            UniCase::ascii("graveled"),
            &[(0b00001, &ENTRY_GRAVELED_6396856593557403791)],
        ),
        (
            UniCase::ascii("canceler"),
            &[(0b00001, &ENTRY_CANCELER_11336704721008790101)],
        ),
        (
            UniCase::ascii("albuminisations"),
            &[(0b10010, &ENTRY_ALBUMENIZATIONS_15542650325957452592)],
        ),
        (
            UniCase::ascii("womanising"),
            &[(0b10010, &ENTRY_WOMANIZING_18027895621894995913)],
        ),
        (
            UniCase::ascii("criticiser"),
            &[(0b10010, &ENTRY_CRITICIZER_1957848661038883017)],
        ),
        (
            UniCase::ascii("radiosterilise"),
            &[(0b10010, &ENTRY_RADIOSTERILIZE_12451407989140658611)],
        ),
        (
            UniCase::ascii("organisationist"),
            &[(0b10010, &ENTRY_ORGANIZATIONIST_7224361965665550626)],
        ),
        (
            UniCase::ascii("unsepulcher"),
            &[(0b00001, &ENTRY_UNSEPULCHER_3660018467990610478)],
        ),
        (
            UniCase::ascii("destabilizing"),
            &[(0b01001, &ENTRY_DESTABILIZING_10660910526175900618)],
        ),
        (
            UniCase::ascii("presympathise"),
            &[(0b10010, &ENTRY_PRESYMPATHIZE_15962690746467493454)],
        ),
        (
            UniCase::ascii("indianising"),
            &[(0b10010, &ENTRY_INDIANIZING_10380881278589214058)],
        ),
        (
            UniCase::ascii("dereligionised"),
            &[(0b10010, &ENTRY_DERELIGIONIZED_12703552936820666292)],
        ),
        (
            UniCase::ascii("tularemias"),
            &[(0b01001, &ENTRY_TULAREMIAS_14187869169219863030)],
        ),
        (
            UniCase::ascii("oralises"),
            &[(0b10010, &ENTRY_ORALIZES_13092540530518911479)],
        ),
        (
            UniCase::ascii("colourimetries"),
            &[(0b11010, &ENTRY_COLORIMETRIES_16352633730423789473)],
        ),
        (
            UniCase::ascii("enthrall"),
            &[
                (0b01001, &ENTRY_ENTHRALL_10463703031933500557),
                (0b01001, &ENTRY_ENTHRALL_16443508848218743746),
            ],
        ),
        (
            UniCase::ascii("lysogenizes"),
            &[(0b01001, &ENTRY_LYSOGENIZES_1808661323485276222)],
        ),
        (
            UniCase::ascii("machinize"),
            &[(0b01001, &ENTRY_MACHINIZE_7203320845244735452)],
        ),
        (
            UniCase::ascii("definitizations"),
            &[(0b01001, &ENTRY_DEFINITIZATIONS_2927011527962264879)],
        ),
        (
            UniCase::ascii("sacralises"),
            &[(0b10010, &ENTRY_SACRALIZES_15118462953215987237)],
        ),
        (
            UniCase::ascii("manoeuverings"),
            &[(0b01000, &ENTRY_MANEUVERINGS_16913311735858326454)],
        ),
        (
            UniCase::ascii("unvectorizable"),
            &[(0b01001, &ENTRY_UNVECTORIZABLE_18305744060207565163)],
        ),
        (
            UniCase::ascii("suburbanization"),
            &[(0b01001, &ENTRY_SUBURBANIZATION_5041053547374142641)],
        ),
        (
            UniCase::ascii("missionizer"),
            &[(0b01001, &ENTRY_MISSIONIZER_16128334848487303471)],
        ),
        (
            UniCase::ascii("pillarizes"),
            &[(0b01001, &ENTRY_PILLARIZES_17692578717946990918)],
        ),
        (
            UniCase::ascii("oedema"),
            &[(0b10010, &ENTRY_EDEMA_6018744134424908364)],
        ),
        (
            UniCase::ascii("propositionise"),
            &[(0b10010, &ENTRY_PROPOSITIONIZE_16503275049520839015)],
        ),
        (
            UniCase::ascii("venomisation"),
            &[(0b10010, &ENTRY_VENOMIZATION_15358943620485615148)],
        ),
        (
            UniCase::ascii("unrivaledder"),
            &[(0b00001, &ENTRY_UNRIVALEDDER_4770647244445881329)],
        ),
        (
            UniCase::ascii("unpolymerised"),
            &[(0b10010, &ENTRY_UNPOLYMERIZED_13019897518101040085)],
        ),
        (
            UniCase::ascii("licence"),
            &[
                (0b00010, &ENTRY_LICENSE_13648883593492983919),
                (0b11010, &ENTRY_LICENSE_7596905334721482195),
            ],
        ),
        (
            UniCase::ascii("offencelesses"),
            &[(0b11010, &ENTRY_OFFENSELESSES_9194933418994630180)],
        ),
        (
            UniCase::ascii("copperises"),
            &[(0b10010, &ENTRY_COPPERIZES_11565506510531680556)],
        ),
        (
            UniCase::ascii("symmetrisation"),
            &[(0b10010, &ENTRY_SYMMETRIZATION_485523952999666992)],
        ),
        (
            UniCase::ascii("specter"),
            &[(0b00001, &ENTRY_SPECTER_13138390153678479670)],
        ),
        (
            UniCase::ascii("colourants"),
            &[(0b11010, &ENTRY_COLORANTS_7537794752295559574)],
        ),
        (
            UniCase::ascii("ascendents"),
            &[(0b10011, &ENTRY_ASCENDANTS_15521170888856908309)],
        ),
        (
            UniCase::ascii("parochialising"),
            &[(0b10010, &ENTRY_PAROCHIALIZING_17616216312392224371)],
        ),
        (
            UniCase::ascii("subtilizes"),
            &[(0b01001, &ENTRY_SUBTILIZES_7637829126901224384)],
        ),
        (
            UniCase::ascii("positivizes"),
            &[(0b01001, &ENTRY_POSITIVIZES_14569839266695497939)],
        ),
        (
            UniCase::ascii("syntonisation"),
            &[(0b10010, &ENTRY_SYNTONIZATION_14856908759061340234)],
        ),
        (
            UniCase::ascii("diarrhealer"),
            &[(0b11001, &ENTRY_DIARRHEALER_11350171176863314647)],
        ),
        (
            UniCase::ascii("faecula"),
            &[(0b11010, &ENTRY_FECULA_9980537314701284779)],
        ),
        (
            UniCase::ascii("toxaemia"),
            &[(0b10010, &ENTRY_TOXEMIA_13728114455609378495)],
        ),
        (
            UniCase::ascii("russianizing"),
            &[(0b01001, &ENTRY_RUSSIANIZING_12272597000608712547)],
        ),
        (
            UniCase::ascii("preflavors"),
            &[(0b00001, &ENTRY_PREFLAVORS_6105553296569719644)],
        ),
        (
            UniCase::ascii("delocalizes"),
            &[(0b01001, &ENTRY_DELOCALIZES_15812480500294999003)],
        ),
        (
            UniCase::ascii("althaein"),
            &[(0b11010, &ENTRY_ALTHEIN_11491174847546175682)],
        ),
        (
            UniCase::ascii("colourbred"),
            &[(0b11010, &ENTRY_COLORBRED_17391526765371994938)],
        ),
        (
            UniCase::ascii("borise"),
            &[(0b10010, &ENTRY_BORIZE_10330616917016533656)],
        ),
        (
            UniCase::ascii("randomisation"),
            &[(0b10010, &ENTRY_RANDOMIZATION_1289611966234918219)],
        ),
        (
            UniCase::ascii("criticisingliest"),
            &[(0b10010, &ENTRY_CRITICIZINGLIEST_16754553627614394252)],
        ),
        (
            UniCase::ascii("dishumanise"),
            &[(0b10010, &ENTRY_DISHUMANIZE_2097256647850275480)],
        ),
        (
            UniCase::ascii("harmonised"),
            &[(0b10010, &ENTRY_HARMONIZED_1245910378210887216)],
        ),
        (
            UniCase::ascii("passades"),
            &[(0b00001, &ENTRY_PASSADES_13578732946213603806)],
        ),
        (
            UniCase::ascii("avianized"),
            &[(0b01001, &ENTRY_AVIANIZED_3624907102508634438)],
        ),
        (
            UniCase::ascii("ionisions"),
            &[(0b10010, &ENTRY_IONIZIONS_5183748198612010486)],
        ),
        (
            UniCase::ascii("metamerised"),
            &[(0b10010, &ENTRY_METAMERIZED_10579453458080805856)],
        ),
        (
            UniCase::ascii("praeludium"),
            &[(0b11010, &ENTRY_PRELUDIUM_16182938175477138747)],
        ),
        (
            UniCase::ascii("turkizes"),
            &[(0b01001, &ENTRY_TURKIZES_3728749434026795951)],
        ),
        (
            UniCase::ascii("lethalises"),
            &[(0b10010, &ENTRY_LETHALIZES_134641715057728302)],
        ),
        (
            UniCase::ascii("monetizes"),
            &[(0b01001, &ENTRY_MONETIZES_10634709768412203424)],
        ),
        (
            UniCase::ascii("vitriolization"),
            &[(0b01001, &ENTRY_VITRIOLIZATION_12177216141601047223)],
        ),
        (
            UniCase::ascii("womanizer"),
            &[(0b01001, &ENTRY_WOMANIZER_17770185505558084902)],
        ),
        (
            UniCase::ascii("floralizes"),
            &[(0b01001, &ENTRY_FLORALIZES_9204519605461520054)],
        ),
        (
            UniCase::ascii("eternizing"),
            &[(0b01001, &ENTRY_ETERNIZING_10174905521874007767)],
        ),
        (
            UniCase::ascii("vapourishnesses"),
            &[(0b11010, &ENTRY_VAPORISHNESSES_3346265753722413365)],
        ),
        (
            UniCase::ascii("resepulchre"),
            &[(0b11010, &ENTRY_RESEPULCHER_13255687324173800374)],
        ),
        (
            UniCase::ascii("unamortisation"),
            &[(0b10010, &ENTRY_UNAMORTIZATION_12146076887735696880)],
        ),
        (
            UniCase::ascii("unpublicized"),
            &[(0b01001, &ENTRY_UNPUBLICIZED_2598075486221782263)],
        ),
        (
            UniCase::ascii("goitre"),
            &[(0b11010, &ENTRY_GOITER_17716281509178141747)],
        ),
        (
            UniCase::ascii("centerfold"),
            &[(0b00001, &ENTRY_CENTERFOLD_8184640290263929626)],
        ),
        (
            UniCase::ascii("outmaneuvers"),
            &[(0b01001, &ENTRY_OUTMANEUVERS_5720663247945549588)],
        ),
        (
            UniCase::ascii("aluminizing"),
            &[(0b01001, &ENTRY_ALUMINIZING_12430331523650185895)],
        ),
        (
            UniCase::ascii("perfervors"),
            &[(0b00001, &ENTRY_PERFERVORS_3703900686039672985)],
        ),
        (
            UniCase::ascii("fuzed"),
            &[(0b01001, &ENTRY_FUSED_1257081415466555403)],
        ),
        (
            UniCase::ascii("terrorizer"),
            &[(0b01001, &ENTRY_TERRORIZER_3790900356919417060)],
        ),
        (
            UniCase::ascii("prolusionize"),
            &[(0b01001, &ENTRY_PROLUSIONIZE_16730185172419057812)],
        ),
        (
            UniCase::ascii("systematizations"),
            &[(0b01001, &ENTRY_SYSTEMATIZATIONS_4980889965627146570)],
        ),
        (
            UniCase::ascii("unsceptres"),
            &[(0b11010, &ENTRY_UNSCEPTERS_3877189759939193522)],
        ),
        (
            UniCase::ascii("singularises"),
            &[(0b10010, &ENTRY_SINGULARIZES_5332763602386440207)],
        ),
        (
            UniCase::ascii("winterized"),
            &[(0b01001, &ENTRY_WINTERIZED_9857678671877956604)],
        ),
        (
            UniCase::ascii("monetizing"),
            &[(0b01001, &ENTRY_MONETIZING_15158826539636538785)],
        ),
        (
            UniCase::ascii("orthogonalises"),
            &[(0b10010, &ENTRY_ORTHOGONALIZES_15773663260089545240)],
        ),
        (
            UniCase::ascii("supersensitize"),
            &[(0b01001, &ENTRY_SUPERSENSITIZE_7006527570782329036)],
        ),
        (
            UniCase::ascii("acroesthesia"),
            &[(0b00001, &ENTRY_ACROESTHESIA_8308136510880851740)],
        ),
        (
            UniCase::ascii("hexametrizing"),
            &[(0b01001, &ENTRY_HEXAMETRIZING_2426175730535979568)],
        ),
        (
            UniCase::ascii("propagandise"),
            &[(0b10010, &ENTRY_PROPAGANDIZE_17672695121638138026)],
        ),
        (
            UniCase::ascii("nationalizer"),
            &[(0b01001, &ENTRY_NATIONALIZER_456791214714633888)],
        ),
        (
            UniCase::ascii("sialorrhea"),
            &[(0b00001, &ENTRY_SIALORRHEA_6484075731495212593)],
        ),
        (
            UniCase::ascii("missionarise"),
            &[(0b10010, &ENTRY_MISSIONARIZE_9166622119973962629)],
        ),
        (
            UniCase::ascii("unfeminise"),
            &[(0b10010, &ENTRY_UNFEMINIZE_17213280328995954348)],
        ),
        (
            UniCase::ascii("nonmagnetizables"),
            &[(0b01001, &ENTRY_NONMAGNETIZABLES_2331502932397989651)],
        ),
        (
            UniCase::ascii("logicalization"),
            &[(0b01001, &ENTRY_LOGICALIZATION_12818715216393851906)],
        ),
        (
            UniCase::ascii("enigmatizing"),
            &[(0b01001, &ENTRY_ENIGMATIZING_7497242872817041134)],
        ),
        (
            UniCase::ascii("afrikanerize"),
            &[(0b01001, &ENTRY_AFRIKANERIZE_10253557183425033567)],
        ),
        (
            UniCase::ascii("nuclearisations"),
            &[(0b10010, &ENTRY_NUCLEARIZATIONS_6750475977451359321)],
        ),
        (
            UniCase::ascii("bolshevized"),
            &[(0b01001, &ENTRY_BOLSHEVIZED_12985511351822149082)],
        ),
        (
            UniCase::ascii("sepaledder"),
            &[(0b00001, &ENTRY_SEPALEDDER_18149050438233478463)],
        ),
        (
            UniCase::ascii("tenderisation"),
            &[(0b10010, &ENTRY_TENDERIZATION_15153457077426481235)],
        ),
        (
            UniCase::ascii("monoestrous"),
            &[(0b11010, &ENTRY_MONESTROUS_18265353223508436919)],
        ),
        (
            UniCase::ascii("rapturise"),
            &[(0b10010, &ENTRY_RAPTURIZE_14952128339321888268)],
        ),
        (
            UniCase::ascii("marmarising"),
            &[(0b10010, &ENTRY_MARMARIZING_3793569524149852443)],
        ),
        (
            UniCase::ascii("staphyledema"),
            &[(0b00001, &ENTRY_STAPHYLEDEMA_15542876830880978325)],
        ),
        (
            UniCase::ascii("etherialising"),
            &[(0b10010, &ENTRY_ETHERIALIZING_5420182430706962967)],
        ),
        (
            UniCase::ascii("dissceptres"),
            &[(0b11010, &ENTRY_DISSCEPTERS_8501541001325274567)],
        ),
        (
            UniCase::ascii("reprivatised"),
            &[(0b10010, &ENTRY_REPRIVATIZED_12098289997527637409)],
        ),
        (
            UniCase::ascii("guttule"),
            &[(0b00001, &ENTRY_GUTTULE_6846811733996501915)],
        ),
        (
            UniCase::ascii("supercanonisation"),
            &[(0b10010, &ENTRY_SUPERCANONIZATION_4336218867107151380)],
        ),
        (
            UniCase::ascii("overcolouration"),
            &[(0b11010, &ENTRY_OVERCOLORATION_12100936843984700781)],
        ),
        (
            UniCase::ascii("randomisations"),
            &[(0b10010, &ENTRY_RANDOMIZATIONS_17892832491968037972)],
        ),
        (
            UniCase::ascii("prologuize"),
            &[(0b01001, &ENTRY_PROLOGUIZE_11510955088004134734)],
        ),
        (
            UniCase::ascii("unantagonizinger"),
            &[(0b01001, &ENTRY_UNANTAGONIZINGER_15671658988108179272)],
        ),
        (
            UniCase::ascii("councilors"),
            &[(0b00001, &ENTRY_COUNCILORS_10740681458284876699)],
        ),
        (
            UniCase::ascii("aphetise"),
            &[(0b10010, &ENTRY_APHETIZE_17206274738648406980)],
        ),
        (
            UniCase::ascii("paedologists"),
            &[(0b11010, &ENTRY_PEDOLOGISTS_1295482932093776852)],
        ),
        (
            UniCase::ascii("archeus"),
            &[(0b10001, &ENTRY_ARCHEUS_1328632190850149944)],
        ),
        (
            UniCase::ascii("skeletonizer"),
            &[(0b01001, &ENTRY_SKELETONIZER_1742743360367189615)],
        ),
        (
            UniCase::ascii("specializes"),
            &[(0b01001, &ENTRY_SPECIALIZES_12943575911419958048)],
        ),
        (
            UniCase::ascii("marginalisation"),
            &[(0b10010, &ENTRY_MARGINALIZATION_1233702880571492640)],
        ),
        (
            UniCase::ascii("estrogen"),
            &[(0b11001, &ENTRY_ESTROGEN_9296702706992805950)],
        ),
        (
            UniCase::ascii("radiosterilizes"),
            &[(0b01001, &ENTRY_RADIOSTERILIZES_17227682815929026577)],
        ),
        (
            UniCase::ascii("valorizes"),
            &[(0b01001, &ENTRY_VALORIZES_12702735390304257487)],
        ),
        (
            UniCase::ascii("encarnalization"),
            &[(0b01001, &ENTRY_ENCARNALIZATION_13214089082920950546)],
        ),
        (
            UniCase::ascii("solarised"),
            &[(0b10010, &ENTRY_SOLARIZED_5808975743485239818)],
        ),
        (
            UniCase::ascii("sentimentalisers"),
            &[(0b10010, &ENTRY_SENTIMENTALIZERS_4236225160895961849)],
        ),
        (
            UniCase::ascii("vires"),
            &[(0b11010, &ENTRY_VIERS_10473285009744197700)],
        ),
        (
            UniCase::ascii("randomizes"),
            &[(0b01001, &ENTRY_RANDOMIZES_13716959639798364190)],
        ),
        (
            UniCase::ascii("untheorizables"),
            &[(0b01001, &ENTRY_UNTHEORIZABLES_13870769123827938921)],
        ),
        (
            UniCase::ascii("radialisations"),
            &[(0b10010, &ENTRY_RADIALIZATIONS_15793970150795442621)],
        ),
        (
            UniCase::ascii("varicoloured"),
            &[(0b11010, &ENTRY_VARICOLORED_1171542226285534602)],
        ),
        (
            UniCase::ascii("opalized"),
            &[(0b01001, &ENTRY_OPALIZED_13663629834424998715)],
        ),
        (
            UniCase::ascii("pedodontics"),
            &[(0b00001, &ENTRY_PEDODONTICS_5640137182749900289)],
        ),
        (
            UniCase::ascii("colourizes"),
            &[(0b01000, &ENTRY_COLORIZES_12579061677034347790)],
        ),
        (
            UniCase::ascii("harmonized"),
            &[(0b01001, &ENTRY_HARMONIZED_1245910378210887216)],
        ),
        (
            UniCase::ascii("eric"),
            &[(0b00001, &ENTRY_ERIC_7184163800386574200)],
        ),
        (
            UniCase::ascii("coenamor"),
            &[(0b10001, &ENTRY_COENAMOR_8473204005333691620)],
        ),
        (
            UniCase::ascii("burglarizing"),
            &[(0b01001, &ENTRY_BURGLARIZING_8183010640223344875)],
        ),
        (
            UniCase::ascii("vitalises"),
            &[(0b10010, &ENTRY_VITALIZES_6574062411877117887)],
        ),
        (
            UniCase::ascii("denaturizer"),
            &[(0b01001, &ENTRY_DENATURIZER_9311420005130802353)],
        ),
        (
            UniCase::ascii("tranquilized"),
            &[(0b01001, &ENTRY_TRANQUILIZED_8802666398177881938)],
        ),
        (
            UniCase::ascii("analogise"),
            &[(0b10010, &ENTRY_ANALOGIZE_5536035389372667946)],
        ),
        (
            UniCase::ascii("hypervitalization"),
            &[(0b01001, &ENTRY_HYPERVITALIZATION_372457073358759943)],
        ),
        (
            UniCase::ascii("nonsynthesizeds"),
            &[(0b01001, &ENTRY_NONSYNTHESIZEDS_16944487649499471214)],
        ),
        (
            UniCase::ascii("bituminized"),
            &[(0b01001, &ENTRY_BITUMINIZED_3973700773638176633)],
        ),
        (
            UniCase::ascii("repersonalize"),
            &[(0b01001, &ENTRY_REPERSONALIZE_6974920904850829865)],
        ),
        (
            UniCase::ascii("salinizes"),
            &[(0b01001, &ENTRY_SALINIZES_15735130644009593162)],
        ),
        (
            UniCase::ascii("metabolized"),
            &[(0b01001, &ENTRY_METABOLIZED_13396525183658045150)],
        ),
        (
            UniCase::ascii("lionisations"),
            &[(0b10010, &ENTRY_LIONIZATIONS_6471589896326506860)],
        ),
        (
            UniCase::ascii("recognisedly"),
            &[(0b10010, &ENTRY_RECOGNIZEDLY_15932389996645062386)],
        ),
        (
            UniCase::ascii("pedestrianize"),
            &[(0b01001, &ENTRY_PEDESTRIANIZE_8912536611462431290)],
        ),
        (
            UniCase::ascii("labilisation"),
            &[(0b10010, &ENTRY_LABILIZATION_13451483296111886301)],
        ),
        (
            UniCase::ascii("favorably"),
            &[(0b11001, &ENTRY_FAVORABLY_8642546699578488365)],
        ),
        (
            UniCase::ascii("alchemizing"),
            &[(0b01001, &ENTRY_ALCHEMIZING_12951450180936067566)],
        ),
        (
            UniCase::ascii("misorganises"),
            &[(0b10010, &ENTRY_MISORGANIZES_15277883172814079121)],
        ),
        (
            UniCase::ascii("retinizes"),
            &[(0b01001, &ENTRY_RETINIZES_17069507706296598945)],
        ),
        (
            UniCase::ascii("skepticest"),
            &[(0b11001, &ENTRY_SKEPTICEST_13124338123587490640)],
        ),
        (
            UniCase::ascii("schismatizes"),
            &[(0b01001, &ENTRY_SCHISMATIZES_14979481534021263364)],
        ),
        (
            UniCase::ascii("aggrandizing"),
            &[(0b01001, &ENTRY_AGGRANDIZING_15004603903858043564)],
        ),
        (
            UniCase::ascii("misanthropized"),
            &[(0b01001, &ENTRY_MISANTHROPIZED_11727139559415514846)],
        ),
        (
            UniCase::ascii("mislabours"),
            &[(0b11010, &ENTRY_MISLABORS_12989629945052355383)],
        ),
        (
            UniCase::ascii("gutturalisation"),
            &[(0b10010, &ENTRY_GUTTURALIZATION_8050117225444468225)],
        ),
        (
            UniCase::ascii("resymbolisations"),
            &[(0b10010, &ENTRY_RESYMBOLIZATIONS_13698200804085478042)],
        ),
        (
            UniCase::ascii("jumboise"),
            &[(0b10010, &ENTRY_JUMBOIZE_15138655937615465445)],
        ),
        (
            UniCase::ascii("unmesmerize"),
            &[(0b01001, &ENTRY_UNMESMERIZE_14813961012908823827)],
        ),
        (
            UniCase::ascii("automatizing"),
            &[(0b01001, &ENTRY_AUTOMATIZING_11897346773175064542)],
        ),
        (
            UniCase::ascii("moralization"),
            &[(0b01001, &ENTRY_MORALIZATION_10080916313324833740)],
        ),
        (
            UniCase::ascii("subspecialty"),
            &[(0b00001, &ENTRY_SUBSPECIALTY_4476391942712911269)],
        ),
        (
            UniCase::ascii("accoutering"),
            &[(0b00001, &ENTRY_ACCOUTERING_11722729971237237966)],
        ),
        (
            UniCase::ascii("energising"),
            &[(0b10010, &ENTRY_ENERGIZING_17242100400597322517)],
        ),
        (
            UniCase::ascii("molochizing"),
            &[(0b01001, &ENTRY_MOLOCHIZING_4942125478827957915)],
        ),
        (
            UniCase::ascii("revitalizations"),
            &[(0b01001, &ENTRY_REVITALIZATIONS_10832630253278670475)],
        ),
        (
            UniCase::ascii("catalysing"),
            &[(0b11010, &ENTRY_CATALYZING_5940201018784400445)],
        ),
        (
            UniCase::ascii("slavonicised"),
            &[(0b10010, &ENTRY_SLAVONICIZED_4556769722338287574)],
        ),
        (
            UniCase::ascii("anaesthetise"),
            &[(0b10010, &ENTRY_ANESTHETIZE_9242516368594572411)],
        ),
        (
            UniCase::ascii("gaveller"),
            &[(0b11010, &ENTRY_GAVELER_7497808590664149917)],
        ),
        (
            UniCase::ascii("cinchonized"),
            &[(0b01001, &ENTRY_CINCHONIZED_1697201765172263780)],
        ),
        (
            UniCase::ascii("anatomize"),
            &[(0b01001, &ENTRY_ANATOMIZE_841129889860317661)],
        ),
        (
            UniCase::ascii("sentimentalise"),
            &[(0b10010, &ENTRY_SENTIMENTALIZE_9074334910736712170)],
        ),
        (
            UniCase::ascii("uncanonises"),
            &[(0b10010, &ENTRY_UNCANONIZES_12153715475418673041)],
        ),
        (
            UniCase::ascii("unneutralizing"),
            &[(0b01001, &ENTRY_UNNEUTRALIZING_4249099403406146838)],
        ),
        (
            UniCase::ascii("goodbys"),
            &[(0b00001, &ENTRY_GOODBYES_1825161685740062266)],
        ),
        (
            UniCase::ascii("humorsome"),
            &[(0b11001, &ENTRY_HUMORSOME_8048377448291557893)],
        ),
        (
            UniCase::ascii("frivollers"),
            &[(0b11010, &ENTRY_FRIVOLERS_6222087214473089062)],
        ),
        (
            UniCase::ascii("unrecognising"),
            &[(0b10010, &ENTRY_UNRECOGNIZING_15165523388753258920)],
        ),
        (
            UniCase::ascii("tourise"),
            &[(0b10010, &ENTRY_TOURIZE_4416339355326535837)],
        ),
        (
            UniCase::ascii("disutilise"),
            &[(0b10010, &ENTRY_DISUTILIZE_10973235722650343703)],
        ),
        (
            UniCase::ascii("realizing"),
            &[(0b01001, &ENTRY_REALIZING_3319107293179944558)],
        ),
        (
            UniCase::ascii("arborizes"),
            &[(0b01001, &ENTRY_ARBORIZES_11990594085526471423)],
        ),
        (
            UniCase::ascii("exteriorised"),
            &[(0b10010, &ENTRY_EXTERIORIZED_2593224941672461767)],
        ),
        (
            UniCase::ascii("courbed"),
            &[(0b11010, &ENTRY_CORBED_3736423820408057899)],
        ),
        (
            UniCase::ascii("sirenizing"),
            &[(0b01001, &ENTRY_SIRENIZING_6540711504301955920)],
        ),
        (
            UniCase::ascii("iridectomize"),
            &[(0b01001, &ENTRY_IRIDECTOMIZE_86328183387103922)],
        ),
        (
            UniCase::ascii("sceptred"),
            &[(0b11010, &ENTRY_SCEPTERED_4309367457883178779)],
        ),
        (
            UniCase::ascii("urbanizations"),
            &[(0b01001, &ENTRY_URBANIZATIONS_714857663098149035)],
        ),
        (
            UniCase::ascii("unromanized"),
            &[(0b01001, &ENTRY_UNROMANIZED_3332586790919173959)],
        ),
        (
            UniCase::ascii("sulphurizations"),
            &[(0b01000, &ENTRY_SULFURIZATIONS_5474468829338012124)],
        ),
        (
            UniCase::ascii("beclamoured"),
            &[(0b11010, &ENTRY_BECLAMORED_11429770894371708638)],
        ),
        (
            UniCase::ascii("rephosphorization"),
            &[(0b01001, &ENTRY_REPHOSPHORIZATION_1249759851309425020)],
        ),
        (
            UniCase::ascii("enharbor"),
            &[(0b00001, &ENTRY_ENHARBOR_153070629897735018)],
        ),
        (
            UniCase::ascii("pedophilic"),
            &[(0b10001, &ENTRY_PEDOPHILIC_10586175930831437217)],
        ),
        (
            UniCase::ascii("summarisation"),
            &[(0b10010, &ENTRY_SUMMARIZATION_1450117887113919650)],
        ),
        (
            UniCase::ascii("denizenize"),
            &[(0b01001, &ENTRY_DENIZENIZE_15175171930010739812)],
        ),
        (
            UniCase::ascii("actualising"),
            &[(0b10010, &ENTRY_ACTUALIZING_4690007636134300688)],
        ),
        (
            UniCase::ascii("liberalizer"),
            &[(0b01001, &ENTRY_LIBERALIZER_12070318024950362610)],
        ),
        (
            UniCase::ascii("gynecologics"),
            &[(0b10001, &ENTRY_GYNECOLOGICS_15475065316407176832)],
        ),
        (
            UniCase::ascii("sceptrelesses"),
            &[(0b11010, &ENTRY_SCEPTERLESSES_3211886999266482763)],
        ),
        (
            UniCase::ascii("economiser"),
            &[(0b10010, &ENTRY_ECONOMIZER_14737250670952641028)],
        ),
        (
            UniCase::ascii("repolymerisation"),
            &[(0b10010, &ENTRY_REPOLYMERIZATION_4016733859370100512)],
        ),
        (
            UniCase::ascii("generalisablest"),
            &[(0b10010, &ENTRY_GENERALIZABLEST_1782032942011166169)],
        ),
        (
            UniCase::ascii("immiserised"),
            &[(0b10010, &ENTRY_IMMISERIZED_15690784954007838498)],
        ),
        (
            UniCase::ascii("ionizablest"),
            &[(0b01001, &ENTRY_IONIZABLEST_11616981145574633025)],
        ),
        (
            UniCase::ascii("americanisation"),
            &[(0b10010, &ENTRY_AMERICANIZATION_6309260318644804917)],
        ),
        (
            UniCase::ascii("baronetized"),
            &[(0b01001, &ENTRY_BARONETIZED_15717984216308695709)],
        ),
        (
            UniCase::ascii("alphabetise"),
            &[(0b10010, &ENTRY_ALPHABETIZE_5185363765846869604)],
        ),
        (
            UniCase::ascii("pollinize"),
            &[(0b01001, &ENTRY_POLLINIZE_10886640222621907817)],
        ),
        (
            UniCase::ascii("polonized"),
            &[(0b01001, &ENTRY_POLONIZED_13808803990994600692)],
        ),
        (
            UniCase::ascii("universaliser"),
            &[(0b10010, &ENTRY_UNIVERSALIZER_15363421758448558519)],
        ),
        (
            UniCase::ascii("phenolises"),
            &[(0b10010, &ENTRY_PHENOLIZES_7668478898891743701)],
        ),
        (
            UniCase::ascii("subspecializes"),
            &[(0b01001, &ENTRY_SUBSPECIALIZES_14179857379487185513)],
        ),
        (
            UniCase::ascii("nonmagnetizable"),
            &[(0b01001, &ENTRY_NONMAGNETIZABLE_8373745056323317633)],
        ),
        (
            UniCase::ascii("propagandises"),
            &[(0b10010, &ENTRY_PROPAGANDIZES_17414306414554519223)],
        ),
        (
            UniCase::ascii("diphthongising"),
            &[(0b10010, &ENTRY_DIPHTHONGIZING_9367101143579778156)],
        ),
        (
            UniCase::ascii("favouritisms"),
            &[(0b11010, &ENTRY_FAVORITISMS_11770976052678857781)],
        ),
        (
            UniCase::ascii("paulinizes"),
            &[(0b01001, &ENTRY_PAULINIZES_7824935294790294303)],
        ),
        (
            UniCase::ascii("pedological"),
            &[(0b00001, &ENTRY_PEDOLOGICAL_10471927294836257811)],
        ),
        (
            UniCase::ascii("savourlesses"),
            &[(0b11010, &ENTRY_SAVORLESSES_7670792878511449933)],
        ),
        (
            UniCase::ascii("unmotoriseddest"),
            &[(0b10010, &ENTRY_UNMOTORIZEDDEST_15245325937655928512)],
        ),
        (
            UniCase::ascii("stomodeums"),
            &[(0b00001, &ENTRY_STOMODEUMS_6754518911406029725)],
        ),
        (
            UniCase::ascii("finalisations"),
            &[(0b10010, &ENTRY_FINALIZATIONS_10467708361376087611)],
        ),
        (
            UniCase::ascii("bacteraemias"),
            &[(0b11010, &ENTRY_BACTEREMIAS_3485923405679674442)],
        ),
        (
            UniCase::ascii("uneconomizing"),
            &[(0b01001, &ENTRY_UNECONOMIZING_15613959143050410767)],
        ),
        (
            UniCase::ascii("rhythmicize"),
            &[(0b01001, &ENTRY_RHYTHMICIZE_5163197837266584786)],
        ),
        (
            UniCase::ascii("fluoridising"),
            &[(0b10010, &ENTRY_FLUORIDIZING_15655433412990428539)],
        ),
        (
            UniCase::ascii("dysaesthetic"),
            &[(0b11010, &ENTRY_DYSESTHETIC_9985209311909479038)],
        ),
        (
            UniCase::ascii("solonizations"),
            &[(0b01001, &ENTRY_SOLONIZATIONS_4433313152747643816)],
        ),
        (
            UniCase::ascii("cicatrisation"),
            &[(0b10010, &ENTRY_CICATRIZATION_12095729010218257569)],
        ),
        (
            UniCase::ascii("haemagogue"),
            &[(0b11010, &ENTRY_HEMAGOGUE_7911863114412250688)],
        ),
        (
            UniCase::ascii("enthrallments"),
            &[(0b01001, &ENTRY_ENTHRALLMENTS_16482738497663374563)],
        ),
        (
            UniCase::ascii("paralyze"),
            &[(0b01001, &ENTRY_PARALYZE_4857352680562257186)],
        ),
        (
            UniCase::ascii("haemacytometer"),
            &[(0b11010, &ENTRY_HEMACYTOMETER_10171050284277896358)],
        ),
        (
            UniCase::ascii("epithetizes"),
            &[(0b01001, &ENTRY_EPITHETIZES_12815056524749670860)],
        ),
        (
            UniCase::ascii("protocolled"),
            &[(0b11010, &ENTRY_PROTOCOLED_9184207318768023915)],
        ),
        (
            UniCase::ascii("curarise"),
            &[(0b10010, &ENTRY_CURARIZE_9480914079622972520)],
        ),
        (
            UniCase::ascii("defeminize"),
            &[(0b01001, &ENTRY_DEFEMINIZE_2460703809552770265)],
        ),
        (
            UniCase::ascii("labialization"),
            &[(0b01001, &ENTRY_LABIALIZATION_15293853718014014842)],
        ),
        (
            UniCase::ascii("freity"),
            &[(0b11010, &ENTRY_FERITY_4632811736178249944)],
        ),
        (
            UniCase::ascii("literalizing"),
            &[(0b01001, &ENTRY_LITERALIZING_17176990014657786316)],
        ),
        (
            UniCase::ascii("marvelouser"),
            &[(0b00001, &ENTRY_MARVELOUSER_9300773522759351631)],
        ),
        (
            UniCase::ascii("rubricizes"),
            &[(0b01001, &ENTRY_RUBRICIZES_6613684611958202027)],
        ),
        (
            UniCase::ascii("favoureds"),
            &[(0b11010, &ENTRY_FAVOREDS_3475186581170652773)],
        ),
        (
            UniCase::ascii("journalizer"),
            &[(0b01001, &ENTRY_JOURNALIZER_17240098793213073148)],
        ),
        (
            UniCase::ascii("demutualization"),
            &[(0b01001, &ENTRY_DEMUTUALIZATION_5558427623273214024)],
        ),
        (
            UniCase::ascii("peroral"),
            &[(0b00001, &ENTRY_PERORAL_1577247151206222930)],
        ),
        (
            UniCase::ascii("amortised"),
            &[(0b10010, &ENTRY_AMORTIZED_5774086997820266664)],
        ),
        (
            UniCase::ascii("revolutionizements"),
            &[(0b01001, &ENTRY_REVOLUTIONIZEMENTS_8372696219470999573)],
        ),
        (
            UniCase::ascii("extolls"),
            &[(0b00001, &ENTRY_EXTOLS_435999545191713231)],
        ),
        (
            UniCase::ascii("unmonopolisings"),
            &[(0b10010, &ENTRY_UNMONOPOLIZINGS_2368394829208842158)],
        ),
        (
            UniCase::ascii("haematosis"),
            &[(0b11010, &ENTRY_HEMATOSIS_10551613893224734170)],
        ),
        (
            UniCase::ascii("radiumisation"),
            &[(0b10010, &ENTRY_RADIUMIZATION_619606104192746118)],
        ),
        (
            UniCase::ascii("emblematicises"),
            &[(0b10010, &ENTRY_EMBLEMATICIZES_1712964621674583121)],
        ),
        (
            UniCase::ascii("unromanticizeds"),
            &[(0b01001, &ENTRY_UNROMANTICIZEDS_6905411968539131627)],
        ),
        (
            UniCase::ascii("terminalisations"),
            &[(0b10010, &ENTRY_TERMINALIZATIONS_654995620005875057)],
        ),
        (
            UniCase::ascii("gentlemanises"),
            &[(0b10010, &ENTRY_GENTLEMANIZES_387005180021803735)],
        ),
        (
            UniCase::ascii("cramboes"),
            &[(0b11010, &ENTRY_CRAMBES_5154618776124525704)],
        ),
        (
            UniCase::ascii("sterilizing"),
            &[(0b01001, &ENTRY_STERILIZING_14742234573275089575)],
        ),
        (
            UniCase::ascii("precivilization"),
            &[(0b01001, &ENTRY_PRECIVILIZATION_8718510999880386433)],
        ),
        (
            UniCase::ascii("oxidizements"),
            &[(0b01001, &ENTRY_OXIDIZEMENTS_2713172646044852097)],
        ),
        (
            UniCase::ascii("skepticer"),
            &[(0b11001, &ENTRY_SKEPTICER_2654895074232389427)],
        ),
        (
            UniCase::ascii("sovietizes"),
            &[(0b01001, &ENTRY_SOVIETIZES_11590305664562136263)],
        ),
        (
            UniCase::ascii("undercoloured"),
            &[(0b11010, &ENTRY_UNDERCOLORED_17422644742945532202)],
        ),
        (
            UniCase::ascii("laothoe"),
            &[(0b00001, &ENTRY_LAOTHOE_7381095044467675447)],
        ),
        (
            UniCase::ascii("cruelizes"),
            &[(0b01001, &ENTRY_CRUELIZES_5359533254509589966)],
        ),
        (
            UniCase::ascii("eudemonistically"),
            &[(0b00001, &ENTRY_EUDEMONISTICALLY_11557458762944374366)],
        ),
        (
            UniCase::ascii("optimalize"),
            &[(0b01001, &ENTRY_OPTIMALIZE_12220685864866355750)],
        ),
        (
            UniCase::ascii("precipe"),
            &[(0b00001, &ENTRY_PRECIPE_13555769800049677911)],
        ),
        (
            UniCase::ascii("maderisations"),
            &[(0b10010, &ENTRY_MADERIZATIONS_7073401233591816042)],
        ),
        (
            UniCase::ascii("phosphorising"),
            &[(0b10010, &ENTRY_PHOSPHORIZING_12248460229299793587)],
        ),
        (
            UniCase::ascii("rebourbonizes"),
            &[(0b01001, &ENTRY_REBOURBONIZES_17217540334190607076)],
        ),
        (
            UniCase::ascii("taels"),
            &[(0b11010, &ENTRY_TELS_3007087834331223229)],
        ),
        (
            UniCase::ascii("preclose"),
            &[(0b11010, &ENTRY_PERCLOSE_11470867655063256438)],
        ),
        (
            UniCase::ascii("petrolisation"),
            &[(0b10010, &ENTRY_PETROLIZATION_16999409919613399973)],
        ),
        (
            UniCase::ascii("recolours"),
            &[(0b11010, &ENTRY_RECOLORS_13250820879245551898)],
        ),
        (
            UniCase::ascii("trieciously"),
            &[(0b00001, &ENTRY_TRIECIOUSLY_8350175444262968317)],
        ),
        (
            UniCase::ascii("emotionalizes"),
            &[(0b01001, &ENTRY_EMOTIONALIZES_3570691650798864535)],
        ),
        (
            UniCase::ascii("cosy"),
            &[(0b11010, &ENTRY_COZY_16771377950900395846)],
        ),
        (
            UniCase::ascii("reprised"),
            &[(0b10010, &ENTRY_REPRIZED_7288407637875600947)],
        ),
        (
            UniCase::ascii("asepticize"),
            &[(0b01001, &ENTRY_ASEPTICIZE_3933929209320869926)],
        ),
        (
            UniCase::ascii("overcolors"),
            &[(0b10001, &ENTRY_OVERCOLORS_13972470541416809937)],
        ),
        (
            UniCase::ascii("unoxidiseddest"),
            &[(0b10010, &ENTRY_UNOXIDIZEDDEST_14507693636430734653)],
        ),
        (
            UniCase::ascii("liquidiser"),
            &[(0b10010, &ENTRY_LIQUIDIZER_14433199094156660496)],
        ),
        (
            UniCase::ascii("islamicized"),
            &[(0b01001, &ENTRY_ISLAMICIZED_16429587923977697429)],
        ),
        (
            UniCase::ascii("unmineralizeddest"),
            &[(0b01001, &ENTRY_UNMINERALIZEDDEST_9301755093437071771)],
        ),
        (
            UniCase::ascii("landre"),
            &[(0b11010, &ENTRY_LANDER_14344486190119467949)],
        ),
        (
            UniCase::ascii("mathematizations"),
            &[(0b01001, &ENTRY_MATHEMATIZATIONS_5363665293954590339)],
        ),
        (
            UniCase::ascii("proselytize"),
            &[(0b01001, &ENTRY_PROSELYTIZE_2045808347498243297)],
        ),
        (
            UniCase::ascii("vaporously"),
            &[(0b00001, &ENTRY_VAPOROUSLY_10099688633493703963)],
        ),
        (
            UniCase::ascii("nonrealizations"),
            &[(0b01001, &ENTRY_NONREALIZATIONS_9898578985931514825)],
        ),
        (
            UniCase::ascii("fetors"),
            &[(0b00001, &ENTRY_FETORS_12891768447462956139)],
        ),
        (
            UniCase::ascii("epimerised"),
            &[(0b10010, &ENTRY_EPIMERIZED_14134076359123551022)],
        ),
        (
            UniCase::ascii("unfraternising"),
            &[(0b10010, &ENTRY_UNFRATERNIZING_11945792457598246703)],
        ),
        (
            UniCase::ascii("archaises"),
            &[(0b10010, &ENTRY_ARCHAIZES_4876579109305121157)],
        ),
        (
            UniCase::ascii("schematizing"),
            &[(0b01001, &ENTRY_SCHEMATIZING_5183188849408735782)],
        ),
        (
            UniCase::ascii("scrutinize"),
            &[(0b01001, &ENTRY_SCRUTINIZE_2495160673295116727)],
        ),
        (
            UniCase::ascii("gnosticize"),
            &[(0b01001, &ENTRY_GNOSTICIZE_11128074972430661057)],
        ),
        (
            UniCase::ascii("robotises"),
            &[(0b10010, &ENTRY_ROBOTIZES_8084732757819391045)],
        ),
        (
            UniCase::ascii("antisepticized"),
            &[(0b01001, &ENTRY_ANTISEPTICIZED_3518662086162245234)],
        ),
        (
            UniCase::ascii("palletized"),
            &[(0b01001, &ENTRY_PALLETIZED_12902140764229882038)],
        ),
        (
            UniCase::ascii("haemagglutinating"),
            &[(0b11010, &ENTRY_HEMAGGLUTINATING_406171148269136925)],
        ),
        (
            UniCase::ascii("coeliomyalgia"),
            &[(0b11010, &ENTRY_CELIOMYALGIA_14548383766443531737)],
        ),
        (
            UniCase::ascii("vapouringly"),
            &[(0b11010, &ENTRY_VAPORINGLY_18193996619433734220)],
        ),
        (
            UniCase::ascii("culturize"),
            &[(0b01001, &ENTRY_CULTURIZE_9663475963702798186)],
        ),
        (
            UniCase::ascii("demoralise"),
            &[(0b10010, &ENTRY_DEMORALIZE_5844727729581502857)],
        ),
        (
            UniCase::ascii("phrenologize"),
            &[(0b01001, &ENTRY_PHRENOLOGIZE_12593199073368999981)],
        ),
        (
            UniCase::ascii("recriticises"),
            &[(0b10010, &ENTRY_RECRITICIZES_90813554752564010)],
        ),
        (
            UniCase::ascii("haemosporid"),
            &[(0b11010, &ENTRY_HEMOSPORID_10539794951355089581)],
        ),
        (
            UniCase::ascii("tularaemia"),
            &[(0b11010, &ENTRY_TULAREMIA_111069766982320509)],
        ),
        (
            UniCase::ascii("cenesthesias"),
            &[(0b10001, &ENTRY_CENESTHESIAS_17650055632548316730)],
        ),
        (
            UniCase::ascii("policiser"),
            &[(0b10010, &ENTRY_POLICIZER_7661480523981039298)],
        ),
        (
            UniCase::ascii("gentlemanizes"),
            &[(0b01001, &ENTRY_GENTLEMANIZES_387005180021803735)],
        ),
        (
            UniCase::ascii("repulverise"),
            &[(0b10010, &ENTRY_REPULVERIZE_7976316581557319006)],
        ),
        (
            UniCase::ascii("objectivised"),
            &[(0b10010, &ENTRY_OBJECTIVIZED_5569615171626387785)],
        ),
        (
            UniCase::ascii("cutinisations"),
            &[(0b10010, &ENTRY_CUTINIZATIONS_17168596603659079378)],
        ),
        (
            UniCase::ascii("pencilers"),
            &[(0b00001, &ENTRY_PENCILERS_13737441358026249172)],
        ),
        (
            UniCase::ascii("nosohaemia"),
            &[(0b11010, &ENTRY_NOSOHEMIA_14803479550852669947)],
        ),
        (
            UniCase::ascii("baronise"),
            &[(0b10010, &ENTRY_BARONIZE_14549807395279592595)],
        ),
        (
            UniCase::ascii("utopianised"),
            &[(0b10010, &ENTRY_UTOPIANIZED_13362099296694661562)],
        ),
        (
            UniCase::ascii("temporisings"),
            &[(0b10010, &ENTRY_TEMPORIZINGS_20261713602325724)],
        ),
        (
            UniCase::ascii("maximise"),
            &[(0b10010, &ENTRY_MAXIMIZE_14091219846433103895)],
        ),
        (
            UniCase::ascii("haemangiomata"),
            &[(0b11010, &ENTRY_HEMANGIOMATA_17129056589733427049)],
        ),
        (
            UniCase::ascii("noncolored"),
            &[(0b10001, &ENTRY_NONCOLORED_18370430231269037309)],
        ),
        (
            UniCase::ascii("gyrostabilisations"),
            &[(0b10010, &ENTRY_GYROSTABILIZATIONS_9084662166713279380)],
        ),
        (
            UniCase::ascii("revitalisations"),
            &[(0b10010, &ENTRY_REVITALIZATIONS_10832630253278670475)],
        ),
        (
            UniCase::ascii("perves"),
            &[(0b00001, &ENTRY_PERVES_5996851197956304566)],
        ),
        (
            UniCase::ascii("succourer"),
            &[(0b11010, &ENTRY_SUCCORER_16497801407608107954)],
        ),
        (
            UniCase::ascii("africanizations"),
            &[(0b01001, &ENTRY_AFRICANIZATIONS_15208317190739871380)],
        ),
        (
            UniCase::ascii("prelector"),
            &[(0b00001, &ENTRY_PRELECTOR_8132693048713382385)],
        ),
        (
            UniCase::ascii("parenthesizing"),
            &[(0b01001, &ENTRY_PARENTHESIZING_4060837799462431128)],
        ),
        (
            UniCase::ascii("fertilizes"),
            &[(0b01001, &ENTRY_FERTILIZES_5502375627064483003)],
        ),
        (
            UniCase::ascii("cosmopolitanising"),
            &[(0b10010, &ENTRY_COSMOPOLITANIZING_11804948920948531162)],
        ),
        (
            UniCase::ascii("unmineralised"),
            &[(0b10010, &ENTRY_UNMINERALIZED_13805636642989384132)],
        ),
        (
            UniCase::ascii("gormandise"),
            &[(0b10010, &ENTRY_GORMANDIZE_13620361302078181878)],
        ),
        (
            UniCase::ascii("horizontalises"),
            &[(0b10010, &ENTRY_HORIZONTALIZES_7733280569310807502)],
        ),
        (
            UniCase::ascii("proselytized"),
            &[(0b01001, &ENTRY_PROSELYTIZED_2214158284515887133)],
        ),
        (
            UniCase::ascii("utilitarianize"),
            &[(0b01001, &ENTRY_UTILITARIANIZE_8297351043834511620)],
        ),
        (
            UniCase::ascii("industrialise"),
            &[(0b10010, &ENTRY_INDUSTRIALIZE_11802203695636303310)],
        ),
        (
            UniCase::ascii("conditionalizes"),
            &[(0b01001, &ENTRY_CONDITIONALIZES_15570057258703829423)],
        ),
        (
            UniCase::ascii("palaeochorology"),
            &[(0b11010, &ENTRY_PALEOCHOROLOGY_5640429438972653065)],
        ),
        (
            UniCase::ascii("uncategorised"),
            &[(0b10010, &ENTRY_UNCATEGORIZED_12671663981711527617)],
        ),
        (
            UniCase::ascii("anatomizable"),
            &[(0b01001, &ENTRY_ANATOMIZABLE_6218592416722946394)],
        ),
        (
            UniCase::ascii("tebilized"),
            &[(0b01001, &ENTRY_TEBILIZED_12603919274755080976)],
        ),
        (
            UniCase::ascii("mediumises"),
            &[(0b10010, &ENTRY_MEDIUMIZES_13996371956875882510)],
        ),
        (
            UniCase::ascii("methodizer"),
            &[(0b01001, &ENTRY_METHODIZER_14823424149101284464)],
        ),
        (
            UniCase::ascii("sensitizing"),
            &[(0b01001, &ENTRY_SENSITIZING_7753308060738960399)],
        ),
        (
            UniCase::ascii("hyperimmunization"),
            &[(0b01001, &ENTRY_HYPERIMMUNIZATION_15847003636676248532)],
        ),
        (
            UniCase::ascii("evangelised"),
            &[(0b10010, &ENTRY_EVANGELIZED_17876535001172708816)],
        ),
        (
            UniCase::ascii("updraft"),
            &[(0b01001, &ENTRY_UPDRAFT_14478591919041764288)],
        ),
        (
            UniCase::ascii("haematid"),
            &[(0b11010, &ENTRY_HEMATID_5688919815724817461)],
        ),
        (
            UniCase::ascii("foetuses"),
            &[(0b10010, &ENTRY_FETUSES_1754409052194239428)],
        ),
        (
            UniCase::ascii("illuminise"),
            &[(0b10010, &ENTRY_ILLUMINIZE_12083084487959333250)],
        ),
        (
            UniCase::ascii("unlocalisablest"),
            &[(0b10010, &ENTRY_UNLOCALIZABLEST_15276491984146533505)],
        ),
        (
            UniCase::ascii("hypnotizables"),
            &[(0b01001, &ENTRY_HYPNOTIZABLES_7101472140016331305)],
        ),
        (
            UniCase::ascii("mahoganize"),
            &[(0b01001, &ENTRY_MAHOGANIZE_6685229242417344012)],
        ),
        (
            UniCase::ascii("doricises"),
            &[(0b10010, &ENTRY_DORICIZES_6267531821171799546)],
        ),
        (
            UniCase::ascii("detribalized"),
            &[(0b01001, &ENTRY_DETRIBALIZED_7286047575373525196)],
        ),
        (
            UniCase::ascii("chimerism"),
            &[(0b00001, &ENTRY_CHIMERISM_7571951058816157382)],
        ),
        (
            UniCase::ascii("fraterniser"),
            &[(0b10010, &ENTRY_FRATERNIZER_11810525370100192642)],
        ),
        (
            UniCase::ascii("hore"),
            &[(0b00001, &ENTRY_HORE_240384164818754909)],
        ),
        (
            UniCase::ascii("europeanizations"),
            &[(0b01001, &ENTRY_EUROPEANIZATIONS_10170958288412142340)],
        ),
        (
            UniCase::ascii("etherealise"),
            &[(0b10010, &ENTRY_ETHEREALIZE_2065340124732116568)],
        ),
        (
            UniCase::ascii("channelling"),
            &[(0b11010, &ENTRY_CHANNELING_9266544299775335589)],
        ),
        (
            UniCase::ascii("polychaetous"),
            &[(0b11010, &ENTRY_POLYCHETOUS_17197291065339885815)],
        ),
        (
            UniCase::ascii("ruggedise"),
            &[(0b10010, &ENTRY_RUGGEDIZE_452263712716974983)],
        ),
        (
            UniCase::ascii("chimaerids"),
            &[(0b11010, &ENTRY_CHIMERIDS_5877455725309387123)],
        ),
        (
            UniCase::ascii("technicoloured"),
            &[(0b11010, &ENTRY_TECHNICOLORED_1825328488281394359)],
        ),
        (
            UniCase::ascii("polioencephalomyelitis"),
            &[(0b11010, &ENTRY_POLIENCEPHALOMYELITIS_8330515026545676649)],
        ),
        (
            UniCase::ascii("wantonize"),
            &[(0b01001, &ENTRY_WANTONIZE_14427284173321750170)],
        ),
        (
            UniCase::ascii("sorbitization"),
            &[(0b01001, &ENTRY_SORBITIZATION_3511955197103798019)],
        ),
        (
            UniCase::ascii("overclamors"),
            &[(0b10001, &ENTRY_OVERCLAMORS_12504082063740601729)],
        ),
        (
            UniCase::ascii("communalizing"),
            &[(0b01001, &ENTRY_COMMUNALIZING_8021518098437504841)],
        ),
        (
            UniCase::ascii("organisables"),
            &[(0b10010, &ENTRY_ORGANIZABLES_3895944364193703180)],
        ),
        (
            UniCase::ascii("diarises"),
            &[(0b10010, &ENTRY_DIARIZES_6733157561570470769)],
        ),
        (
            UniCase::ascii("pollinizes"),
            &[(0b01001, &ENTRY_POLLINIZES_11100365061845756268)],
        ),
        (
            UniCase::ascii("proverbise"),
            &[(0b10010, &ENTRY_PROVERBIZE_5057145621251371752)],
        ),
        (
            UniCase::ascii("rhinocoele"),
            &[(0b11010, &ENTRY_RHINOCELE_13394138248730638628)],
        ),
        (
            UniCase::ascii("diarrhoea"),
            &[(0b10010, &ENTRY_DIARRHEA_16651318537078726725)],
        ),
        (
            UniCase::ascii("palaeoanthropologies"),
            &[(0b11010, &ENTRY_PALEOANTHROPOLOGIES_8205118955898337795)],
        ),
        (
            UniCase::ascii("tetanizes"),
            &[(0b01001, &ENTRY_TETANIZES_18159463373230991034)],
        ),
        (
            UniCase::ascii("unrancoreds"),
            &[(0b00001, &ENTRY_UNRANCOREDS_12103687684487901758)],
        ),
        (
            UniCase::ascii("cenoby"),
            &[(0b10001, &ENTRY_CENOBY_6246310194380860627)],
        ),
        (
            UniCase::ascii("plasmapheresis"),
            &[(0b00001, &ENTRY_PLASMAPHERESIS_1508628979977175584)],
        ),
        (
            UniCase::ascii("levellers"),
            &[(0b11010, &ENTRY_LEVELERS_15007791514111643804)],
        ),
        (
            UniCase::ascii("deemphasisation"),
            &[(0b10010, &ENTRY_DEEMPHASIZATION_17228655479618550538)],
        ),
        (
            UniCase::ascii("sensualizes"),
            &[(0b01001, &ENTRY_SENSUALIZES_6027047404814047775)],
        ),
        (
            UniCase::ascii("lignose"),
            &[(0b00001, &ENTRY_LIGNOSE_12807960118794739477)],
        ),
        (
            UniCase::ascii("julide"),
            &[(0b00001, &ENTRY_JULIDE_12150077695995964173)],
        ),
        (
            UniCase::ascii("sinicize"),
            &[(0b01001, &ENTRY_SINICIZE_5519781244176228688)],
        ),
        (
            UniCase::ascii("teetotalled"),
            &[(0b11010, &ENTRY_TEETOTALED_13601847410093247608)],
        ),
        (
            UniCase::ascii("mutagenising"),
            &[(0b10010, &ENTRY_MUTAGENIZING_94769575082965039)],
        ),
        (
            UniCase::ascii("decentralisation"),
            &[(0b10010, &ENTRY_DECENTRALIZATION_1145039421821383347)],
        ),
        (
            UniCase::ascii("fraternisations"),
            &[(0b10010, &ENTRY_FRATERNIZATIONS_14137130464047726144)],
        ),
        (
            UniCase::ascii("vaporizing"),
            &[(0b01001, &ENTRY_VAPORIZING_11720449073985132085)],
        ),
        (
            UniCase::ascii("theatricizing"),
            &[(0b01001, &ENTRY_THEATRICIZING_9815086289375498796)],
        ),
        (
            UniCase::ascii("bushellings"),
            &[(0b11010, &ENTRY_BUSHELINGS_985942199985401750)],
        ),
        (
            UniCase::ascii("phlebotomizes"),
            &[(0b01001, &ENTRY_PHLEBOTOMIZES_14047846782365849478)],
        ),
        (
            UniCase::ascii("feminised"),
            &[(0b10010, &ENTRY_FEMINIZED_8194884343298056834)],
        ),
        (
            UniCase::ascii("antioxidisers"),
            &[(0b10010, &ENTRY_ANTIOXIDIZERS_10675061378003290626)],
        ),
        (
            UniCase::ascii("extemporises"),
            &[(0b10010, &ENTRY_EXTEMPORIZES_10662898516430920590)],
        ),
        (
            UniCase::ascii("coalizing"),
            &[(0b01001, &ENTRY_COALIZING_8107852365569207830)],
        ),
        (
            UniCase::ascii("derealization"),
            &[(0b01001, &ENTRY_DEREALIZATION_4431015585806198367)],
        ),
        (
            UniCase::ascii("iconises"),
            &[(0b10010, &ENTRY_ICONIZES_7146786515616481266)],
        ),
        (
            UniCase::ascii("volatilisations"),
            &[(0b10010, &ENTRY_VOLATILIZATIONS_2738963093881521684)],
        ),
        (
            UniCase::ascii("unequalise"),
            &[(0b10010, &ENTRY_UNEQUALIZE_12397832983269467070)],
        ),
        (
            UniCase::ascii("watercoloring"),
            &[(0b11001, &ENTRY_WATERCOLORING_10355406009413574616)],
        ),
        (
            UniCase::ascii("trichinisation"),
            &[(0b10010, &ENTRY_TRICHINIZATION_17095496984757617228)],
        ),
        (
            UniCase::ascii("phagocytizes"),
            &[(0b01001, &ENTRY_PHAGOCYTIZES_5484801342814585347)],
        ),
        (
            UniCase::ascii("homogenization"),
            &[(0b01001, &ENTRY_HOMOGENIZATION_4656356242119525138)],
        ),
        (
            UniCase::ascii("heavenizes"),
            &[(0b01001, &ENTRY_HEAVENIZES_16090084063510819598)],
        ),
        (
            UniCase::ascii("unfavorableness"),
            &[(0b11001, &ENTRY_UNFAVORABLENESS_11828384935093784234)],
        ),
        (
            UniCase::ascii("estrones"),
            &[(0b00001, &ENTRY_ESTRONES_396980696513423065)],
        ),
        (
            UniCase::ascii("channelised"),
            &[(0b10010, &ENTRY_CHANNELIZED_5009658046976798401)],
        ),
        (
            UniCase::ascii("cataloguised"),
            &[(0b10010, &ENTRY_CATALOGUIZED_4476989929563164358)],
        ),
        (
            UniCase::ascii("archaizes"),
            &[(0b01001, &ENTRY_ARCHAIZES_4876579109305121157)],
        ),
        (
            UniCase::ascii("pediatric"),
            &[(0b11001, &ENTRY_PEDIATRIC_15313872787895414938)],
        ),
        (
            UniCase::ascii("baconises"),
            &[(0b10010, &ENTRY_BACONIZES_15492280776277479142)],
        ),
        (
            UniCase::ascii("marbleises"),
            &[(0b10010, &ENTRY_MARBLEIZES_4834327648631783601)],
        ),
        (
            UniCase::ascii("unbaptise"),
            &[(0b10010, &ENTRY_UNBAPTIZE_18045749488616509181)],
        ),
        (
            UniCase::ascii("paralysingly"),
            &[(0b11010, &ENTRY_PARALYZINGLY_2992135569354984660)],
        ),
        (
            UniCase::ascii("deodoriser"),
            &[(0b10010, &ENTRY_DEODORIZER_13797022735041696461)],
        ),
        (
            UniCase::ascii("reauthorisation"),
            &[(0b10010, &ENTRY_REAUTHORIZATION_5069423989935588733)],
        ),
        (
            UniCase::ascii("haematal"),
            &[(0b11010, &ENTRY_HEMATAL_7087036422270254482)],
        ),
        (
            UniCase::ascii("unilateralize"),
            &[(0b01001, &ENTRY_UNILATERALIZE_4208361192869727001)],
        ),
        (
            UniCase::ascii("siderealises"),
            &[(0b10010, &ENTRY_SIDEREALIZES_5077853180450618510)],
        ),
        (
            UniCase::ascii("machinization"),
            &[(0b01001, &ENTRY_MACHINIZATION_4606202379585370055)],
        ),
        (
            UniCase::ascii("nonioniseds"),
            &[(0b10010, &ENTRY_NONIONIZEDS_15814635301210610227)],
        ),
        (
            UniCase::ascii("undercolours"),
            &[(0b11010, &ENTRY_UNDERCOLORS_6190629777654495448)],
        ),
        (
            UniCase::ascii("martyriser"),
            &[(0b10010, &ENTRY_MARTYRIZER_8947475097586440969)],
        ),
        (
            UniCase::ascii("unfavoritest"),
            &[(0b11001, &ENTRY_UNFAVORITEST_5653472480878764002)],
        ),
        (
            UniCase::ascii("slavisation"),
            &[(0b10010, &ENTRY_SLAVIZATION_13156747122292743639)],
        ),
        (
            UniCase::ascii("magicalise"),
            &[(0b10010, &ENTRY_MAGICALIZE_259845292582546245)],
        ),
        (
            UniCase::ascii("resurrectionizes"),
            &[(0b01001, &ENTRY_RESURRECTIONIZES_13187140164794979295)],
        ),
        (
            UniCase::ascii("etherizing"),
            &[(0b01001, &ENTRY_ETHERIZING_5812365847799688656)],
        ),
        (
            UniCase::ascii("gynaecomorphous"),
            &[(0b11010, &ENTRY_GYNECOMORPHOUS_3257314395419567917)],
        ),
        (
            UniCase::ascii("dognaping"),
            &[(0b00001, &ENTRY_DOGNAPING_18285041110852582538)],
        ),
        (
            UniCase::ascii("heathenisation"),
            &[(0b10010, &ENTRY_HEATHENIZATION_4307661223767237492)],
        ),
        (
            UniCase::ascii("favor"),
            &[(0b11001, &ENTRY_FAVOR_16174102806904091593)],
        ),
        (
            UniCase::ascii("lionisable"),
            &[(0b10010, &ENTRY_LIONIZABLE_8467501967425405420)],
        ),
        (
            UniCase::ascii("multicolors"),
            &[(0b10001, &ENTRY_MULTICOLORS_2420068264028973832)],
        ),
        (
            UniCase::ascii("unneutralized"),
            &[(0b01001, &ENTRY_UNNEUTRALIZED_10386359248112453405)],
        ),
        (
            UniCase::ascii("anaemicer"),
            &[(0b10010, &ENTRY_ANEMICER_16024076703657819532)],
        ),
        (
            UniCase::ascii("parchmentized"),
            &[(0b01001, &ENTRY_PARCHMENTIZED_12167483454807635503)],
        ),
        (
            UniCase::ascii("enameller"),
            &[(0b11010, &ENTRY_ENAMELER_14880476578662103007)],
        ),
        (
            UniCase::ascii("proteide"),
            &[(0b00001, &ENTRY_PROTEIDE_15177699273216527826)],
        ),
        (
            UniCase::ascii("egotising"),
            &[(0b10010, &ENTRY_EGOTIZING_255552054661601129)],
        ),
        (
            UniCase::ascii("tuberize"),
            &[(0b01001, &ENTRY_TUBERIZE_865480950163325912)],
        ),
        (
            UniCase::ascii("vietnamizing"),
            &[(0b01001, &ENTRY_VIETNAMIZING_9657833441293397796)],
        ),
        (
            UniCase::ascii("paulinize"),
            &[(0b01001, &ENTRY_PAULINIZE_4447070483648697360)],
        ),
        (
            UniCase::ascii("untemporizing"),
            &[(0b01001, &ENTRY_UNTEMPORIZING_10262279498666537398)],
        ),
        (
            UniCase::ascii("parametrizes"),
            &[(0b01001, &ENTRY_PARAMETRIZES_15875840276606359299)],
        ),
        (
            UniCase::ascii("redialing"),
            &[(0b01001, &ENTRY_REDIALING_7917159843633067663)],
        ),
        (
            UniCase::ascii("slavicise"),
            &[(0b10010, &ENTRY_SLAVICIZE_9761827906822368262)],
        ),
        (
            UniCase::ascii("aphoriser"),
            &[(0b10010, &ENTRY_APHORIZER_14605329647382162831)],
        ),
        (
            UniCase::ascii("technicised"),
            &[(0b10010, &ENTRY_TECHNICIZED_3663306080874533270)],
        ),
        (
            UniCase::ascii("palaeobotany"),
            &[(0b11010, &ENTRY_PALEOBOTANY_14491399323716171031)],
        ),
        (
            UniCase::ascii("unmethodisings"),
            &[(0b10010, &ENTRY_UNMETHODIZINGS_15327848455170179924)],
        ),
        (
            UniCase::ascii("mischaracterizes"),
            &[(0b01001, &ENTRY_MISCHARACTERIZES_6539624896226097074)],
        ),
        (
            UniCase::ascii("programer"),
            &[(0b00001, &ENTRY_PROGRAMMER_12330374135731657861)],
        ),
        (
            UniCase::ascii("unrecognisingly"),
            &[(0b10010, &ENTRY_UNRECOGNIZINGLY_2227023476747181630)],
        ),
        (
            UniCase::ascii("preutilizables"),
            &[(0b01001, &ENTRY_PREUTILIZABLES_16060283126975272357)],
        ),
        (
            UniCase::ascii("morselization"),
            &[(0b01001, &ENTRY_MORSELIZATION_2667568239096574036)],
        ),
        (
            UniCase::ascii("skepticise"),
            &[(0b10010, &ENTRY_SKEPTICIZE_233558052004506284)],
        ),
        (
            UniCase::ascii("ecclesiasticize"),
            &[(0b01001, &ENTRY_ECCLESIASTICIZE_5375790565507371661)],
        ),
        (
            UniCase::ascii("calendarizing"),
            &[(0b01001, &ENTRY_CALENDARIZING_12252223763201845409)],
        ),
        (
            UniCase::ascii("chattelisation"),
            &[(0b10010, &ENTRY_CHATTELIZATION_7363246458991523337)],
        ),
        (
            UniCase::ascii("immortalised"),
            &[(0b10010, &ENTRY_IMMORTALIZED_12615514167775867804)],
        ),
        (
            UniCase::ascii("cutinises"),
            &[(0b10010, &ENTRY_CUTINIZES_7397928291454568665)],
        ),
        (
            UniCase::ascii("anesthetizing"),
            &[(0b01001, &ENTRY_ANESTHETIZING_15816199569084558224)],
        ),
        (
            UniCase::ascii("chloroanemia"),
            &[(0b10001, &ENTRY_CHLOROANEMIA_6563825885243058247)],
        ),
        (
            UniCase::ascii("nonparlors"),
            &[(0b10001, &ENTRY_NONPARLORS_3253504681695686847)],
        ),
        (
            UniCase::ascii("catholicization"),
            &[(0b01001, &ENTRY_CATHOLICIZATION_1039966536643797028)],
        ),
        (
            UniCase::ascii("presbyterianizing"),
            &[(0b01001, &ENTRY_PRESBYTERIANIZING_11910404725477468034)],
        ),
        (
            UniCase::ascii("parametrise"),
            &[(0b10010, &ENTRY_PARAMETRIZE_14088334789658250719)],
        ),
        (
            UniCase::ascii("emotionalization"),
            &[(0b01001, &ENTRY_EMOTIONALIZATION_8285067224344808560)],
        ),
        (
            UniCase::ascii("pantheonizes"),
            &[(0b01001, &ENTRY_PANTHEONIZES_2223291708212001129)],
        ),
        (
            UniCase::ascii("confederatise"),
            &[(0b10010, &ENTRY_CONFEDERATIZE_6554466446788291559)],
        ),
        (
            UniCase::ascii("posturize"),
            &[(0b01001, &ENTRY_POSTURIZE_539261955307310954)],
        ),
        (
            UniCase::ascii("oversentimentalize"),
            &[(0b01001, &ENTRY_OVERSENTIMENTALIZE_2920069227773965746)],
        ),
        (
            UniCase::ascii("ethicised"),
            &[(0b10010, &ENTRY_ETHICIZED_13298420094237367669)],
        ),
        (
            UniCase::ascii("recrystallised"),
            &[(0b10010, &ENTRY_RECRYSTALLIZED_11205669347561069076)],
        ),
        (
            UniCase::ascii("ruffianise"),
            &[(0b10010, &ENTRY_RUFFIANIZE_17407878081648774516)],
        ),
        (
            UniCase::ascii("caespitosely"),
            &[(0b11010, &ENTRY_CESPITOSELY_7196666758904903124)],
        ),
        (
            UniCase::ascii("unsocialised"),
            &[(0b10010, &ENTRY_UNSOCIALIZED_3496138542165260759)],
        ),
        (
            UniCase::ascii("despatching"),
            &[(0b10011, &ENTRY_DISPATCHING_13590867743632657867)],
        ),
        (
            UniCase::ascii("texturises"),
            &[(0b10010, &ENTRY_TEXTURIZES_9031143232768038726)],
        ),
        (
            UniCase::ascii("behaviorists"),
            &[(0b11001, &ENTRY_BEHAVIORISTS_16129454263271072388)],
        ),
        (
            UniCase::ascii("drer"),
            &[(0b11010, &ENTRY_DERR_8497357744990730455)],
        ),
        (
            UniCase::ascii("agnised"),
            &[(0b10010, &ENTRY_AGNIZED_9871346460164509669)],
        ),
        (
            UniCase::ascii("relabelled"),
            &[(0b11010, &ENTRY_RELABELED_10158046552075682397)],
        ),
        (
            UniCase::ascii("luster"),
            &[(0b00001, &ENTRY_LUSTER_11657857751959453572)],
        ),
        (
            UniCase::ascii("unvulgarises"),
            &[(0b10010, &ENTRY_UNVULGARIZES_4085302381557242262)],
        ),
        (
            UniCase::ascii("mythologizations"),
            &[(0b01001, &ENTRY_MYTHOLOGIZATIONS_3274680051911037587)],
        ),
        (
            UniCase::ascii("leucemic"),
            &[(0b00001, &ENTRY_LEUCEMIC_4805425255684968634)],
        ),
        (
            UniCase::ascii("reprivatizations"),
            &[(0b01001, &ENTRY_REPRIVATIZATIONS_14878285207711233234)],
        ),
        (
            UniCase::ascii("moralisers"),
            &[(0b10010, &ENTRY_MORALIZERS_3365413932300602681)],
        ),
        (
            UniCase::ascii("australopithecine"),
            &[(0b00001, &ENTRY_AUSTRALOPITHECINE_461885205668956581)],
        ),
        (
            UniCase::ascii("labeller"),
            &[(0b11010, &ENTRY_LABELER_4326972748751944713)],
        ),
        (
            UniCase::ascii("mediatizing"),
            &[(0b01001, &ENTRY_MEDIATIZING_3100095196162520920)],
        ),
        (
            UniCase::ascii("pluralised"),
            &[(0b10010, &ENTRY_PLURALIZED_3500489174231988842)],
        ),
        (
            UniCase::ascii("autotomized"),
            &[(0b01001, &ENTRY_AUTOTOMIZED_7590157601515171803)],
        ),
        (
            UniCase::ascii("ungentilize"),
            &[(0b01001, &ENTRY_UNGENTILIZE_1682666321562915658)],
        ),
        (
            UniCase::ascii("symbolization"),
            &[(0b01001, &ENTRY_SYMBOLIZATION_16179533248304689346)],
        ),
        (
            UniCase::ascii("faradised"),
            &[(0b10010, &ENTRY_FARADIZED_2216631753438049544)],
        ),
        (
            UniCase::ascii("copperise"),
            &[(0b10010, &ENTRY_COPPERIZE_8585777073067773483)],
        ),
        (
            UniCase::ascii("ungentilises"),
            &[(0b10010, &ENTRY_UNGENTILIZES_1989929300659612547)],
        ),
        (
            UniCase::ascii("granitise"),
            &[(0b10010, &ENTRY_GRANITIZE_6476105775849514242)],
        ),
        (
            UniCase::ascii("uncharacterized"),
            &[(0b01001, &ENTRY_UNCHARACTERIZED_16956353213909858293)],
        ),
        (
            UniCase::ascii("powellizing"),
            &[(0b01001, &ENTRY_POWELLIZING_8322629798558997363)],
        ),
        (
            UniCase::ascii("orthopedicer"),
            &[(0b11001, &ENTRY_ORTHOPEDICER_8700148210587724397)],
        ),
        (
            UniCase::ascii("sockdologising"),
            &[(0b10010, &ENTRY_SOCKDOLOGIZING_16991441468659816755)],
        ),
        (
            UniCase::ascii("defensed"),
            &[(0b01001, &ENTRY_DEFENSED_4741744499926552984)],
        ),
        (
            UniCase::ascii("precriticize"),
            &[(0b01001, &ENTRY_PRECRITICIZE_8846824592864407133)],
        ),
        (
            UniCase::ascii("concertized"),
            &[(0b01001, &ENTRY_CONCERTIZED_13322827190564875313)],
        ),
        (
            UniCase::ascii("unmonopolisedder"),
            &[(0b10010, &ENTRY_UNMONOPOLIZEDDER_367444066669166581)],
        ),
        (
            UniCase::ascii("familiarising"),
            &[(0b10010, &ENTRY_FAMILIARIZING_3497704747397161180)],
        ),
        (
            UniCase::ascii("notarise"),
            &[(0b11010, &ENTRY_NOTARIZE_9890063397301391140)],
        ),
        (
            UniCase::ascii("trillionize"),
            &[(0b01001, &ENTRY_TRILLIONIZE_2061247672357509542)],
        ),
        (
            UniCase::ascii("heredes"),
            &[(0b00001, &ENTRY_HEREDES_12466213351118710275)],
        ),
        (
            UniCase::ascii("civilianising"),
            &[(0b10010, &ENTRY_CIVILIANIZING_10886647865038667032)],
        ),
        (
            UniCase::ascii("equestrianize"),
            &[(0b01001, &ENTRY_EQUESTRIANIZE_13136044868803266911)],
        ),
        (
            UniCase::ascii("solubilisation"),
            &[(0b10010, &ENTRY_SOLUBILIZATION_11329836872303618229)],
        ),
        (
            UniCase::ascii("leucorrhoeas"),
            &[(0b11010, &ENTRY_LEUCORRHEAS_12147874623824130705)],
        ),
        (
            UniCase::ascii("legitimising"),
            &[(0b10010, &ENTRY_LEGITIMIZING_1120958333215572753)],
        ),
        (
            UniCase::ascii("lateralization"),
            &[(0b01001, &ENTRY_LATERALIZATION_8041407149896392073)],
        ),
        (
            UniCase::ascii("telesthetic"),
            &[(0b00001, &ENTRY_TELESTHETIC_2492077632449909509)],
        ),
        (
            UniCase::ascii("intercrystallises"),
            &[(0b10010, &ENTRY_INTERCRYSTALLIZES_13807609427203436454)],
        ),
        (
            UniCase::ascii("metabolizables"),
            &[(0b01001, &ENTRY_METABOLIZABLES_10614491304432551547)],
        ),
        (
            UniCase::ascii("swivelled"),
            &[(0b11010, &ENTRY_SWIVELED_17790968621944461091)],
        ),
        (
            UniCase::ascii("semimerceriseds"),
            &[(0b10010, &ENTRY_SEMIMERCERIZEDS_6499518726299354192)],
        ),
        (
            UniCase::ascii("magnetizer"),
            &[(0b01001, &ENTRY_MAGNETIZER_10398668050557629386)],
        ),
        (
            UniCase::ascii("dioestrous"),
            &[(0b11010, &ENTRY_DIESTROUS_2649092910168728128)],
        ),
        (
            UniCase::ascii("palaeoecologist"),
            &[(0b11010, &ENTRY_PALEOECOLOGIST_6577271230726993315)],
        ),
        (
            UniCase::ascii("devolatilizing"),
            &[(0b01001, &ENTRY_DEVOLATILIZING_9726618714956110506)],
        ),
        (
            UniCase::ascii("unvolatilizedder"),
            &[(0b01001, &ENTRY_UNVOLATILIZEDDER_17937975853559322294)],
        ),
        (
            UniCase::ascii("misopedism"),
            &[(0b10001, &ENTRY_MISOPEDISM_6542233660865950036)],
        ),
        (
            UniCase::ascii("globigerinae"),
            &[(0b11010, &ENTRY_GLOBIGERINE_8558263536879852579)],
        ),
        (
            UniCase::ascii("percurrent"),
            &[(0b00001, &ENTRY_PERCURRENT_15522415679210362636)],
        ),
        (
            UniCase::ascii("retranquilise"),
            &[(0b10010, &ENTRY_RETRANQUILIZE_10089381173173353384)],
        ),
        (
            UniCase::ascii("capitalisables"),
            &[(0b10010, &ENTRY_CAPITALIZABLES_12918035538804552826)],
        ),
        (
            UniCase::ascii("digitised"),
            &[(0b10010, &ENTRY_DIGITIZED_18167407254586843848)],
        ),
        (
            UniCase::ascii("dorizing"),
            &[(0b01001, &ENTRY_DORIZING_8550740907826559833)],
        ),
        (
            UniCase::ascii("colourableness"),
            &[(0b11010, &ENTRY_COLORABLENESS_1061796348140451347)],
        ),
        (
            UniCase::ascii("palaeogeology"),
            &[(0b11010, &ENTRY_PALEOGEOLOGY_1446971404483318371)],
        ),
        (
            UniCase::ascii("galactosaemia"),
            &[(0b11010, &ENTRY_GALACTOSEMIA_15356026729538488621)],
        ),
        (
            UniCase::ascii("maeandrine"),
            &[(0b11010, &ENTRY_MEANDRINE_15281745123487615934)],
        ),
        (
            UniCase::ascii("devitalizations"),
            &[(0b01001, &ENTRY_DEVITALIZATIONS_13354425441260498778)],
        ),
        (
            UniCase::ascii("metaled"),
            &[(0b01001, &ENTRY_METALED_11411260958286166568)],
        ),
        (
            UniCase::ascii("archei"),
            &[(0b10001, &ENTRY_ARCHEI_14186317656172516337)],
        ),
        (
            UniCase::ascii("revolutionizes"),
            &[(0b01001, &ENTRY_REVOLUTIONIZES_6397868062466700275)],
        ),
        (
            UniCase::ascii("mobilisers"),
            &[(0b10010, &ENTRY_MOBILIZERS_13019397665994940764)],
        ),
        (
            UniCase::ascii("teetotaller"),
            &[(0b11010, &ENTRY_TEETOTALER_4246658529410097511)],
        ),
        (
            UniCase::ascii("undialyzed"),
            &[(0b00001, &ENTRY_UNDIALYZED_4239031886129441255)],
        ),
        (
            UniCase::ascii("criticised"),
            &[(0b10010, &ENTRY_CRITICIZED_11062690254551858674)],
        ),
        (
            UniCase::ascii("similizing"),
            &[(0b01001, &ENTRY_SIMILIZING_1862547745562599944)],
        ),
        (
            UniCase::ascii("defencelessest"),
            &[(0b11010, &ENTRY_DEFENSELESSEST_2810886385008994530)],
        ),
        (
            UniCase::ascii("babelisation"),
            &[(0b10010, &ENTRY_BABELIZATION_6227505335585113751)],
        ),
        (
            UniCase::ascii("gelatinisations"),
            &[(0b10010, &ENTRY_GELATINIZATIONS_16405129470904980935)],
        ),
        (
            UniCase::ascii("spelean"),
            &[(0b00001, &ENTRY_SPELEAN_8367235262898475105)],
        ),
        (
            UniCase::ascii("patternises"),
            &[(0b10010, &ENTRY_PATTERNIZES_12992806022556722958)],
        ),
        (
            UniCase::ascii("tuberculizations"),
            &[(0b01001, &ENTRY_TUBERCULIZATIONS_14781828629520022038)],
        ),
        (
            UniCase::ascii("moisturizers"),
            &[(0b01001, &ENTRY_MOISTURIZERS_3778922692605477146)],
        ),
        (
            UniCase::ascii("vulcanizations"),
            &[(0b01001, &ENTRY_VULCANIZATIONS_12614859722986396332)],
        ),
        (
            UniCase::ascii("creolized"),
            &[(0b01001, &ENTRY_CREOLIZED_7643361883981250764)],
        ),
        (
            UniCase::ascii("hemangioma"),
            &[(0b10001, &ENTRY_HEMANGIOMA_4433290260611802687)],
        ),
        (
            UniCase::ascii("microcolourimeter"),
            &[(0b11010, &ENTRY_MICROCOLORIMETER_9779301620192455553)],
        ),
        (
            UniCase::ascii("schillerizations"),
            &[(0b01001, &ENTRY_SCHILLERIZATIONS_1097721139918947159)],
        ),
        (
            UniCase::ascii("uncoloureddest"),
            &[(0b11010, &ENTRY_UNCOLOREDDEST_15878875459057574341)],
        ),
        (
            UniCase::ascii("stomodaeum"),
            &[(0b11010, &ENTRY_STOMODEUM_7352107598988685520)],
        ),
        (
            UniCase::ascii("vapory"),
            &[(0b00001, &ENTRY_VAPORY_5997890858470358305)],
        ),
        (
            UniCase::ascii("moldiest"),
            &[(0b11001, &ENTRY_MOLDIEST_11552700490364540702)],
        ),
        (
            UniCase::ascii("vaporose"),
            &[(0b00001, &ENTRY_VAPOROSE_941229128135609892)],
        ),
        (
            UniCase::ascii("synoecizes"),
            &[(0b01001, &ENTRY_SYNOECIZES_14157018111278412405)],
        ),
        (
            UniCase::ascii("subminiaturization"),
            &[(0b01001, &ENTRY_SUBMINIATURIZATION_14504776542407713912)],
        ),
        (
            UniCase::ascii("germanizations"),
            &[(0b01001, &ENTRY_GERMANIZATIONS_10792953229272520133)],
        ),
        (
            UniCase::ascii("comprehensivizes"),
            &[(0b01001, &ENTRY_COMPREHENSIVIZES_7584059223344239212)],
        ),
        (
            UniCase::ascii("sectorise"),
            &[(0b10010, &ENTRY_SECTORIZE_16349435987024198076)],
        ),
        (
            UniCase::ascii("attitudinised"),
            &[(0b10010, &ENTRY_ATTITUDINIZED_5404939483170560810)],
        ),
        (
            UniCase::ascii("dysmenorrheas"),
            &[(0b10001, &ENTRY_DYSMENORRHEAS_8092414813964160172)],
        ),
        (
            UniCase::ascii("destabilizers"),
            &[(0b01001, &ENTRY_DESTABILIZERS_6141576176215173386)],
        ),
        (
            UniCase::ascii("utilization"),
            &[(0b01001, &ENTRY_UTILIZATION_10923497997585510620)],
        ),
        (
            UniCase::ascii("circumcentre"),
            &[(0b11010, &ENTRY_CIRCUMCENTER_207116320690761995)],
        ),
        (
            UniCase::ascii("plante"),
            &[(0b00001, &ENTRY_PLANTE_15938795954501174987)],
        ),
        (
            UniCase::ascii("dispopularises"),
            &[(0b10010, &ENTRY_DISPOPULARIZES_3346222683675559134)],
        ),
        (
            UniCase::ascii("behaviorally"),
            &[(0b11001, &ENTRY_BEHAVIORALLY_3392730520394326300)],
        ),
        (
            UniCase::ascii("demineralization"),
            &[(0b01001, &ENTRY_DEMINERALIZATION_11860382402591403329)],
        ),
        (
            UniCase::ascii("foolhardising"),
            &[(0b10010, &ENTRY_FOOLHARDIZING_14970024232233507775)],
        ),
        (
            UniCase::ascii("characterizabler"),
            &[(0b01001, &ENTRY_CHARACTERIZABLER_3425015125508980850)],
        ),
        (
            UniCase::ascii("tenderizer"),
            &[(0b01001, &ENTRY_TENDERIZER_9543130259232111639)],
        ),
        (
            UniCase::ascii("objectivized"),
            &[(0b01001, &ENTRY_OBJECTIVIZED_5569615171626387785)],
        ),
        (
            UniCase::ascii("glauconitization"),
            &[(0b01001, &ENTRY_GLAUCONITIZATION_7362785196117563859)],
        ),
        (
            UniCase::ascii("gaelicize"),
            &[(0b01001, &ENTRY_GAELICIZE_13150850139207150741)],
        ),
        (
            UniCase::ascii("securitization"),
            &[(0b01001, &ENTRY_SECURITIZATION_15104434495314939017)],
        ),
        (
            UniCase::ascii("discolorization"),
            &[(0b00001, &ENTRY_DISCOLORIZATION_1561449986421291790)],
        ),
        (
            UniCase::ascii("parallelises"),
            &[(0b10010, &ENTRY_PARALLELIZES_6725281951117805650)],
        ),
        (
            UniCase::ascii("northernizes"),
            &[(0b01001, &ENTRY_NORTHERNIZES_10191844020334839487)],
        ),
        (
            UniCase::ascii("crystallizabilities"),
            &[(0b01001, &ENTRY_CRYSTALLIZABILITIES_3954684427565379393)],
        ),
        (
            UniCase::ascii("paleometeorological"),
            &[(0b10001, &ENTRY_PALEOMETEOROLOGICAL_550400106195388111)],
        ),
        (
            UniCase::ascii("palletiser"),
            &[(0b10010, &ENTRY_PALLETIZER_6914094309015631146)],
        ),
        (
            UniCase::ascii("polycythaemia"),
            &[(0b11010, &ENTRY_POLYCYTHEMIA_14165398609961484401)],
        ),
        (
            UniCase::ascii("calendarized"),
            &[(0b01001, &ENTRY_CALENDARIZED_16767057265330067481)],
        ),
        (
            UniCase::ascii("persianised"),
            &[(0b10010, &ENTRY_PERSIANIZED_9516440395848303807)],
        ),
        (
            UniCase::ascii("disindustrializing"),
            &[(0b01001, &ENTRY_DISINDUSTRIALIZING_11227038092400551095)],
        ),
        (
            UniCase::ascii("complementizer"),
            &[(0b01001, &ENTRY_COMPLEMENTIZER_6562757288101998612)],
        ),
        (
            UniCase::ascii("hamletizes"),
            &[(0b01001, &ENTRY_HAMLETIZES_3332330520225481896)],
        ),
        (
            UniCase::ascii("calisthenics"),
            &[(0b01001, &ENTRY_CALISTHENICS_3364072204597622667)],
        ),
        (
            UniCase::ascii("refuelling"),
            &[(0b11010, &ENTRY_REFUELING_13653298214509580404)],
        ),
        (
            UniCase::ascii("palaeontographies"),
            &[(0b11010, &ENTRY_PALEONTOGRAPHIES_4145254269175447370)],
        ),
        (
            UniCase::ascii("demobilization"),
            &[(0b01001, &ENTRY_DEMOBILIZATION_8427760600922715154)],
        ),
        (
            UniCase::ascii("neighbourhoods"),
            &[(0b11010, &ENTRY_NEIGHBORHOODS_4358229838170310740)],
        ),
        (
            UniCase::ascii("palaeoeremology"),
            &[(0b11010, &ENTRY_PALEOEREMOLOGY_4326619216815037045)],
        ),
        (
            UniCase::ascii("legitimizes"),
            &[(0b01001, &ENTRY_LEGITIMIZES_8915844240859951340)],
        ),
        (
            UniCase::ascii("homoeostatic"),
            &[(0b11010, &ENTRY_HOMEOSTATIC_8960257562201062527)],
        ),
        (
            UniCase::ascii("geste"),
            &[(0b00001, &ENTRY_GESTE_7096843185027205462)],
        ),
        (
            UniCase::ascii("sailorisings"),
            &[(0b10010, &ENTRY_SAILORIZINGS_828877064204542534)],
        ),
        (
            UniCase::ascii("electrizations"),
            &[(0b01001, &ENTRY_ELECTRIZATIONS_13976280743140547777)],
        ),
        (
            UniCase::ascii("ketonize"),
            &[(0b01001, &ENTRY_KETONIZE_17435606326783529410)],
        ),
        (
            UniCase::ascii("steatorrhea"),
            &[(0b00001, &ENTRY_STEATORRHEA_7006550897790317338)],
        ),
        (
            UniCase::ascii("genteelizes"),
            &[(0b01001, &ENTRY_GENTEELIZES_5600744917352856646)],
        ),
        (
            UniCase::ascii("soberises"),
            &[(0b10010, &ENTRY_SOBERIZES_6877701061854218485)],
        ),
        (
            UniCase::ascii("pedantize"),
            &[(0b01001, &ENTRY_PEDANTIZE_692434760472693565)],
        ),
        (
            UniCase::ascii("racialize"),
            &[(0b01001, &ENTRY_RACIALIZE_5925611520403941440)],
        ),
        (
            UniCase::ascii("esterizes"),
            &[(0b01001, &ENTRY_ESTERIZES_1807746540502831909)],
        ),
        (
            UniCase::ascii("monologuising"),
            &[(0b10010, &ENTRY_MONOLOGUIZING_4287361179938192317)],
        ),
        (
            UniCase::ascii("steriliser"),
            &[(0b10010, &ENTRY_STERILIZER_9665607973109051795)],
        ),
        (
            UniCase::ascii("deemphasizes"),
            &[(0b01001, &ENTRY_DEEMPHASIZES_13005114554703747835)],
        ),
        (
            UniCase::ascii("hucksterises"),
            &[(0b10010, &ENTRY_HUCKSTERIZES_8268659569338877880)],
        ),
        (
            UniCase::ascii("crystallises"),
            &[(0b10010, &ENTRY_CRYSTALLIZES_4917509722520652987)],
        ),
        (
            UniCase::ascii("labourists"),
            &[(0b11010, &ENTRY_LABORISTS_9984046093945823347)],
        ),
        (
            UniCase::ascii("paleophytological"),
            &[(0b10001, &ENTRY_PALEOPHYTOLOGICAL_11128259889095522921)],
        ),
        (
            UniCase::ascii("overcapitalization"),
            &[(0b01001, &ENTRY_OVERCAPITALIZATION_1715510714642089999)],
        ),
        (
            UniCase::ascii("anesthesis"),
            &[(0b11001, &ENTRY_ANESTHESIS_3798568430045477742)],
        ),
        (
            UniCase::ascii("afrikanerising"),
            &[(0b10010, &ENTRY_AFRIKANERIZING_601585902747830882)],
        ),
        (
            UniCase::ascii("alcoholizes"),
            &[(0b01001, &ENTRY_ALCOHOLIZES_155350708519960662)],
        ),
        (
            UniCase::ascii("experimentalizing"),
            &[(0b01001, &ENTRY_EXPERIMENTALIZING_8250407124148404694)],
        ),
        (
            UniCase::ascii("atheising"),
            &[(0b10010, &ENTRY_ATHEIZING_3233601106148671334)],
        ),
        (
            UniCase::ascii("itemization"),
            &[(0b01001, &ENTRY_ITEMIZATION_1151183169051499453)],
        ),
        (
            UniCase::ascii("exteriorize"),
            &[(0b01001, &ENTRY_EXTERIORIZE_6928562918919697659)],
        ),
        (
            UniCase::ascii("picometre"),
            &[(0b11010, &ENTRY_PICOMETER_2628061784674895811)],
        ),
        (
            UniCase::ascii("tubercularise"),
            &[(0b10010, &ENTRY_TUBERCULARIZE_2157217058313355699)],
        ),
        (
            UniCase::ascii("desensitizations"),
            &[(0b01001, &ENTRY_DESENSITIZATIONS_8251374796564084894)],
        ),
        (
            UniCase::ascii("preludizes"),
            &[(0b01001, &ENTRY_PRELUDIZES_17476896209888158296)],
        ),
        (
            UniCase::ascii("postcaecal"),
            &[(0b11010, &ENTRY_POSTCECAL_14039669434720483948)],
        ),
        (
            UniCase::ascii("neologise"),
            &[(0b10010, &ENTRY_NEOLOGIZE_10244910510400951586)],
        ),
        (
            UniCase::ascii("unpoetize"),
            &[(0b01001, &ENTRY_UNPOETIZE_14681941329003224540)],
        ),
        (
            UniCase::ascii("denuclearises"),
            &[(0b10010, &ENTRY_DENUCLEARIZES_3857601007676937998)],
        ),
        (
            UniCase::ascii("haemoglobinuria"),
            &[(0b11010, &ENTRY_HEMOGLOBINURIA_4853343125806894750)],
        ),
        (
            UniCase::ascii("noveliser"),
            &[(0b10010, &ENTRY_NOVELIZER_16608816919992566365)],
        ),
        (
            UniCase::ascii("crystallizes"),
            &[(0b01001, &ENTRY_CRYSTALLIZES_4917509722520652987)],
        ),
        (
            UniCase::ascii("geometricize"),
            &[(0b01001, &ENTRY_GEOMETRICIZE_13223434468003425706)],
        ),
        (
            UniCase::ascii("laborisms"),
            &[(0b11001, &ENTRY_LABORISMS_14951457899010464782)],
        ),
        (
            UniCase::ascii("standardisation"),
            &[(0b10010, &ENTRY_STANDARDIZATION_18269374167214565579)],
        ),
        (
            UniCase::ascii("iricise"),
            &[(0b10010, &ENTRY_IRICIZE_5507636142851661219)],
        ),
        (
            UniCase::ascii("flutists"),
            &[(0b01001, &ENTRY_FLUTISTS_7891281533553389633)],
        ),
        (
            UniCase::ascii("disharmonise"),
            &[(0b10010, &ENTRY_DISHARMONIZE_14492960974540093828)],
        ),
        (
            UniCase::ascii("cannibalized"),
            &[(0b01001, &ENTRY_CANNIBALIZED_8169504218362659851)],
        ),
        (
            UniCase::ascii("pantheonize"),
            &[(0b01001, &ENTRY_PANTHEONIZE_13681139475213145828)],
        ),
        (
            UniCase::ascii("skillful"),
            &[(0b10001, &ENTRY_SKILLFUL_8097707939529755598)],
        ),
        (
            UniCase::ascii("fertilize"),
            &[(0b01001, &ENTRY_FERTILIZE_8254091234870358890)],
        ),
        (
            UniCase::ascii("pereopod"),
            &[(0b00001, &ENTRY_PEREOPOD_9605155749429362953)],
        ),
        (
            UniCase::ascii("behaviouralest"),
            &[(0b11010, &ENTRY_BEHAVIORALEST_3631208384433367206)],
        ),
        (
            UniCase::ascii("precuneus"),
            &[(0b00001, &ENTRY_PRECUNEUS_11481546809254856891)],
        ),
        (
            UniCase::ascii("grecianises"),
            &[(0b10010, &ENTRY_GRECIANIZES_14411759533003325711)],
        ),
        (
            UniCase::ascii("medicalizations"),
            &[(0b01001, &ENTRY_MEDICALIZATIONS_16089901682373921411)],
        ),
        (
            UniCase::ascii("favourablest"),
            &[(0b11010, &ENTRY_FAVORABLEST_3654396515225860920)],
        ),
        (
            UniCase::ascii("dogmatise"),
            &[(0b10010, &ENTRY_DOGMATIZE_17787716068922105181)],
        ),
        (
            UniCase::ascii("palaeoalchemical"),
            &[(0b11010, &ENTRY_PALEOALCHEMICAL_15713650654596147408)],
        ),
        (
            UniCase::ascii("amphitheatres"),
            &[(0b11010, &ENTRY_AMPHITHEATERS_6166627403689463943)],
        ),
        (
            UniCase::ascii("unscrutinisingly"),
            &[(0b10010, &ENTRY_UNSCRUTINIZINGLY_5893546295582674444)],
        ),
        (
            UniCase::ascii("memorialisation"),
            &[(0b10010, &ENTRY_MEMORIALIZATION_8125433852548617131)],
        ),
        (
            UniCase::ascii("rhetorizes"),
            &[(0b01001, &ENTRY_RHETORIZES_11610320224318377716)],
        ),
        (
            UniCase::ascii("archaizers"),
            &[(0b01001, &ENTRY_ARCHAIZERS_6972696703859538503)],
        ),
        (
            UniCase::ascii("demagnetizabler"),
            &[(0b01001, &ENTRY_DEMAGNETIZABLER_14067236382470080700)],
        ),
        (
            UniCase::ascii("unmetallised"),
            &[(0b10010, &ENTRY_UNMETALIZED_14653098959762201949)],
        ),
        (
            UniCase::ascii("unnormalize"),
            &[(0b01001, &ENTRY_UNNORMALIZE_14634692936439819346)],
        ),
        (
            UniCase::ascii("deputationise"),
            &[(0b10010, &ENTRY_DEPUTATIONIZE_6925287050174299860)],
        ),
        (
            UniCase::ascii("insurrectionize"),
            &[(0b01001, &ENTRY_INSURRECTIONIZE_13973633585951003277)],
        ),
        (
            UniCase::ascii("reauthorise"),
            &[(0b10010, &ENTRY_REAUTHORIZE_1493549425007215475)],
        ),
        (
            UniCase::ascii("ferritisations"),
            &[(0b10010, &ENTRY_FERRITIZATIONS_18305080996112489502)],
        ),
        (
            UniCase::ascii("unparalysed"),
            &[(0b11010, &ENTRY_UNPARALYZED_14384393398387787974)],
        ),
        (
            UniCase::ascii("caenogenetic"),
            &[(0b11010, &ENTRY_CENOGENETIC_4645405785928938913)],
        ),
        (
            UniCase::ascii("decapitalizations"),
            &[(0b01001, &ENTRY_DECAPITALIZATIONS_4946483081288861635)],
        ),
        (
            UniCase::ascii("edenization"),
            &[(0b01001, &ENTRY_EDENIZATION_14877368160810371784)],
        ),
        (
            UniCase::ascii("londonising"),
            &[(0b10010, &ENTRY_LONDONIZING_4059093782595442599)],
        ),
        (
            UniCase::ascii("polarisable"),
            &[(0b10010, &ENTRY_POLARIZABLE_7358307787201683785)],
        ),
        (
            UniCase::ascii("victimiser"),
            &[(0b10010, &ENTRY_VICTIMIZER_13906638213650914285)],
        ),
        (
            UniCase::ascii("semaenov"),
            &[(0b11010, &ENTRY_SEMENOV_2935209069826757991)],
        ),
        (
            UniCase::ascii("sulphuring"),
            &[(0b11010, &ENTRY_SULFURING_13686792585795899810)],
        ),
        (
            UniCase::ascii("jeopardises"),
            &[(0b10010, &ENTRY_JEOPARDIZES_14509182339781413876)],
        ),
        (
            UniCase::ascii("chiffre"),
            &[(0b11010, &ENTRY_CHIFFER_15730952033932406541)],
        ),
        (
            UniCase::ascii("stallionize"),
            &[(0b01001, &ENTRY_STALLIONIZE_4208189765970167174)],
        ),
        (
            UniCase::ascii("wornil"),
            &[(0b00001, &ENTRY_WORNIL_7106321021868280403)],
        ),
        (
            UniCase::ascii("pearlizing"),
            &[(0b01001, &ENTRY_PEARLIZING_9707287977475426638)],
        ),
        (
            UniCase::ascii("schillerizing"),
            &[(0b01001, &ENTRY_SCHILLERIZING_10704749465715034583)],
        ),
        (
            UniCase::ascii("foutres"),
            &[(0b11010, &ENTRY_FOUTERS_6533881490801158798)],
        ),
        (
            UniCase::ascii("hypercholesterolaemias"),
            &[(0b11010, &ENTRY_HYPERCHOLESTEROLEMIAS_10902398019851674783)],
        ),
        (
            UniCase::ascii("persianisation"),
            &[(0b10010, &ENTRY_PERSIANIZATION_10456152347071316181)],
        ),
        (
            UniCase::ascii("ungraphitiseds"),
            &[(0b10010, &ENTRY_UNGRAPHITIZEDS_17567383968087162591)],
        ),
        (
            UniCase::ascii("cognise"),
            &[(0b10010, &ENTRY_COGNIZE_7253118900028580039)],
        ),
        (
            UniCase::ascii("gorgonizing"),
            &[(0b01001, &ENTRY_GORGONIZING_17245443610611935765)],
        ),
        (
            UniCase::ascii("eroticised"),
            &[(0b10010, &ENTRY_EROTICIZED_13157811206734809042)],
        ),
        (
            UniCase::ascii("cerebralize"),
            &[(0b01001, &ENTRY_CEREBRALIZE_4644072502748774455)],
        ),
        (
            UniCase::ascii("cerebralisations"),
            &[(0b10010, &ENTRY_CEREBRALIZATIONS_10944353801184109081)],
        ),
        (
            UniCase::ascii("venalises"),
            &[(0b10010, &ENTRY_VENALIZES_17850293216838309236)],
        ),
        (
            UniCase::ascii("devitalize"),
            &[(0b01001, &ENTRY_DEVITALIZE_1043658353870554736)],
        ),
        (
            UniCase::ascii("philosophizes"),
            &[(0b01001, &ENTRY_PHILOSOPHIZES_9120030685330947055)],
        ),
        (
            UniCase::ascii("peptizables"),
            &[(0b01001, &ENTRY_PEPTIZABLES_15657004397021338874)],
        ),
        (
            UniCase::ascii("celiotomy"),
            &[(0b10001, &ENTRY_CELIOTOMY_9141657999599968712)],
        ),
        (
            UniCase::ascii("urbanize"),
            &[(0b01001, &ENTRY_URBANIZE_13821147474427946226)],
        ),
        (
            UniCase::ascii("tuberculise"),
            &[(0b10010, &ENTRY_TUBERCULIZE_3450991821098593135)],
        ),
        (
            UniCase::ascii("organizers"),
            &[(0b01001, &ENTRY_ORGANIZERS_3523554258367195869)],
        ),
        (
            UniCase::ascii("cupelers"),
            &[(0b00001, &ENTRY_CUPELERS_5725217363507193203)],
        ),
        (
            UniCase::ascii("unsummarisedder"),
            &[(0b10010, &ENTRY_UNSUMMARIZEDDER_17857459577512226536)],
        ),
        (
            UniCase::ascii("gyneolater"),
            &[(0b10001, &ENTRY_GYNEOLATER_7078383320128612624)],
        ),
        (
            UniCase::ascii("fabulize"),
            &[(0b01001, &ENTRY_FABULIZE_6554520750007678638)],
        ),
        (
            UniCase::ascii("warford"),
            &[(0b00001, &ENTRY_WARFORD_9070503211126736019)],
        ),
        (
            UniCase::ascii("precancelation"),
            &[(0b00001, &ENTRY_PRECANCELATION_15491223411860446070)],
        ),
        (
            UniCase::ascii("hazardise"),
            &[(0b10010, &ENTRY_HAZARDIZE_16561989176363630666)],
        ),
        (
            UniCase::ascii("patronisings"),
            &[(0b10010, &ENTRY_PATRONIZINGS_17625682551925708597)],
        ),
        (
            UniCase::ascii("theorise"),
            &[(0b10010, &ENTRY_THEORIZE_16592272841946174715)],
        ),
        (
            UniCase::ascii("pragmatised"),
            &[(0b10010, &ENTRY_PRAGMATIZED_15911492964724941957)],
        ),
        (
            UniCase::ascii("eulogizer"),
            &[(0b01001, &ENTRY_EULOGIZER_1964342767045376178)],
        ),
        (
            UniCase::ascii("porcellanise"),
            &[(0b10010, &ENTRY_PORCELLANIZE_5956584629780862310)],
        ),
        (
            UniCase::ascii("diple"),
            &[(0b00001, &ENTRY_DIPLE_3376459421960689495)],
        ),
        (
            UniCase::ascii("dekameters"),
            &[(0b00001, &ENTRY_DEKAMETERS_17531050124125527369)],
        ),
        (
            UniCase::ascii("colourimeter"),
            &[(0b11010, &ENTRY_COLORIMETER_5995992236279956204)],
        ),
        (
            UniCase::ascii("specialize"),
            &[(0b01001, &ENTRY_SPECIALIZE_13734198890330005704)],
        ),
        (
            UniCase::ascii("overspecialisation"),
            &[(0b10010, &ENTRY_OVERSPECIALIZATION_9400215891169659422)],
        ),
        (
            UniCase::ascii("demilitarizations"),
            &[(0b01001, &ENTRY_DEMILITARIZATIONS_12252664721077083328)],
        ),
        (
            UniCase::ascii("perennialise"),
            &[(0b10010, &ENTRY_PERENNIALIZE_16426253784606656534)],
        ),
        (
            UniCase::ascii("harmonisations"),
            &[(0b10010, &ENTRY_HARMONIZATIONS_1390450432634590795)],
        ),
        (
            UniCase::ascii("parisianizations"),
            &[(0b01001, &ENTRY_PARISIANIZATIONS_12496635998441245631)],
        ),
        (
            UniCase::ascii("stylizes"),
            &[(0b01001, &ENTRY_STYLIZES_7516779593566935765)],
        ),
        (
            UniCase::ascii("herborized"),
            &[(0b01001, &ENTRY_HERBORIZED_1986245296299390128)],
        ),
        (
            UniCase::ascii("orthopaedist"),
            &[(0b11010, &ENTRY_ORTHOPEDIST_5359875151039183204)],
        ),
        (
            UniCase::ascii("concretizing"),
            &[(0b01001, &ENTRY_CONCRETIZING_3165984632825616589)],
        ),
        (
            UniCase::ascii("cartelisations"),
            &[(0b10010, &ENTRY_CARTELIZATIONS_15852914117827138645)],
        ),
        (
            UniCase::ascii("ebionizing"),
            &[(0b01001, &ENTRY_EBIONIZING_6877070461214793032)],
        ),
        (
            UniCase::ascii("penalizable"),
            &[(0b01001, &ENTRY_PENALIZABLE_16402490500753160561)],
        ),
        (
            UniCase::ascii("hypercriticize"),
            &[(0b01001, &ENTRY_HYPERCRITICIZE_7531870804381594430)],
        ),
        (
            UniCase::ascii("palaeoethnological"),
            &[(0b11010, &ENTRY_PALEOETHNOLOGICAL_4237301460218128665)],
        ),
        (
            UniCase::ascii("islamise"),
            &[(0b10010, &ENTRY_ISLAMIZE_3716181323919679147)],
        ),
        (
            UniCase::ascii("deputise"),
            &[(0b10010, &ENTRY_DEPUTIZE_2146946330988443787)],
        ),
        (
            UniCase::ascii("archaizing"),
            &[(0b01001, &ENTRY_ARCHAIZING_3246941458311193300)],
        ),
        (
            UniCase::ascii("imperializing"),
            &[(0b01001, &ENTRY_IMPERIALIZING_15786015724673840691)],
        ),
        (
            UniCase::ascii("morselled"),
            &[(0b11010, &ENTRY_MORSELED_6287732670299985987)],
        ),
        (
            UniCase::ascii("paresthesias"),
            &[(0b10001, &ENTRY_PARESTHESIAS_1637525985108297517)],
        ),
        (
            UniCase::ascii("labourhood"),
            &[(0b11010, &ENTRY_LABORHOOD_2858476689555142869)],
        ),
        (
            UniCase::ascii("ituraeans"),
            &[(0b11010, &ENTRY_ITUREANS_17311638727147711544)],
        ),
        (
            UniCase::ascii("palatalized"),
            &[(0b01001, &ENTRY_PALATALIZED_17714539904743727901)],
        ),
        (
            UniCase::ascii("penelopising"),
            &[(0b10010, &ENTRY_PENELOPIZING_9454561321061976299)],
        ),
        (
            UniCase::ascii("bistredder"),
            &[(0b11010, &ENTRY_BISTEREDDER_4919702072233220862)],
        ),
        (
            UniCase::ascii("crystallisation"),
            &[(0b10010, &ENTRY_CRYSTALLIZATION_11917761263858890133)],
        ),
        (
            UniCase::ascii("elegised"),
            &[(0b10010, &ENTRY_ELEGIZED_234567674978394451)],
        ),
        (
            UniCase::ascii("reindustrialisations"),
            &[(0b10010, &ENTRY_REINDUSTRIALIZATIONS_9294526708641521678)],
        ),
        (
            UniCase::ascii("supersubtilised"),
            &[(0b10010, &ENTRY_SUPERSUBTILIZED_11208309807789263657)],
        ),
        (
            UniCase::ascii("achromatized"),
            &[(0b01001, &ENTRY_ACHROMATIZED_10686154542806055086)],
        ),
        (
            UniCase::ascii("excursionized"),
            &[(0b01001, &ENTRY_EXCURSIONIZED_1665688933464332989)],
        ),
        (
            UniCase::ascii("grammes"),
            &[(0b10010, &ENTRY_GRAMS_8379840851265617318)],
        ),
        (
            UniCase::ascii("decasualized"),
            &[(0b01001, &ENTRY_DECASUALIZED_1520306088891108700)],
        ),
        (
            UniCase::ascii("palatalization"),
            &[(0b01001, &ENTRY_PALATALIZATION_2924504919577641238)],
        ),
        (
            UniCase::ascii("regularization"),
            &[(0b01001, &ENTRY_REGULARIZATION_15955920955652647734)],
        ),
        (
            UniCase::ascii("annalising"),
            &[(0b10010, &ENTRY_ANNALIZING_7591181130486416840)],
        ),
        (
            UniCase::ascii("colourfulnesses"),
            &[(0b11010, &ENTRY_COLORFULNESSES_11724036744178299544)],
        ),
        (
            UniCase::ascii("colouristically"),
            &[(0b11010, &ENTRY_COLORISTICALLY_4826074029409437505)],
        ),
        (
            UniCase::ascii("desexualised"),
            &[(0b10010, &ENTRY_DESEXUALIZED_709042860780979441)],
        ),
        (
            UniCase::ascii("goddizes"),
            &[(0b01001, &ENTRY_GODDIZES_4605603392452105679)],
        ),
        (
            UniCase::ascii("sanitization"),
            &[(0b01001, &ENTRY_SANITIZATION_10312415212709623714)],
        ),
        (
            UniCase::ascii("subspecialties"),
            &[(0b00001, &ENTRY_SUBSPECIALTIES_5856104107956385634)],
        ),
        (
            UniCase::ascii("formalisations"),
            &[(0b10010, &ENTRY_FORMALIZATIONS_4885129653293673852)],
        ),
        (
            UniCase::ascii("nesslerize"),
            &[(0b01001, &ENTRY_NESSLERIZE_6021492543047774975)],
        ),
        (
            UniCase::ascii("deionising"),
            &[(0b10010, &ENTRY_DEIONIZING_3409760745768493185)],
        ),
        (
            UniCase::ascii("islamicised"),
            &[(0b10010, &ENTRY_ISLAMICIZED_16429587923977697429)],
        ),
        (
            UniCase::ascii("pretorians"),
            &[(0b00001, &ENTRY_PRETORIANS_5321413914837421784)],
        ),
        (
            UniCase::ascii("intellectualising"),
            &[(0b10010, &ENTRY_INTELLECTUALIZING_11856597360745053121)],
        ),
        (
            UniCase::ascii("professionalizes"),
            &[(0b01001, &ENTRY_PROFESSIONALIZES_13019583386600406552)],
        ),
        (
            UniCase::ascii("taxidermised"),
            &[(0b10010, &ENTRY_TAXIDERMIZED_10192910736850674)],
        ),
        (
            UniCase::ascii("clamorist"),
            &[(0b00001, &ENTRY_CLAMORIST_16325759197501191896)],
        ),
        (
            UniCase::ascii("stylises"),
            &[(0b10010, &ENTRY_STYLIZES_7516779593566935765)],
        ),
        (
            UniCase::ascii("decasualisation"),
            &[(0b10010, &ENTRY_DECASUALIZATION_10274253385824132479)],
        ),
        (
            UniCase::ascii("hyphenizations"),
            &[(0b01001, &ENTRY_HYPHENIZATIONS_2352732446948213541)],
        ),
        (
            UniCase::ascii("uneulogised"),
            &[(0b10010, &ENTRY_UNEULOGIZED_8625593682318183902)],
        ),
        (
            UniCase::ascii("unsocialiseddest"),
            &[(0b10010, &ENTRY_UNSOCIALIZEDDEST_4448774529600758329)],
        ),
        (
            UniCase::ascii("masculinises"),
            &[(0b10010, &ENTRY_MASCULINIZES_8331218415317018409)],
        ),
        (
            UniCase::ascii("phenicopter"),
            &[(0b00001, &ENTRY_PHENICOPTER_102813840191262241)],
        ),
        (
            UniCase::ascii("libelled"),
            &[(0b11010, &ENTRY_LIBELED_4865225818350414783)],
        ),
        (
            UniCase::ascii("unsensitizing"),
            &[(0b01001, &ENTRY_UNSENSITIZING_5882427315960709496)],
        ),
        (
            UniCase::ascii("mohammedanize"),
            &[(0b01001, &ENTRY_MOHAMMEDANIZE_2941075096626155541)],
        ),
        (
            UniCase::ascii("isochronized"),
            &[(0b01001, &ENTRY_ISOCHRONIZED_6953711592892129564)],
        ),
        (
            UniCase::ascii("etiologue"),
            &[(0b10001, &ENTRY_ETIOLOGUE_3427764260416926249)],
        ),
        (
            UniCase::ascii("maximises"),
            &[(0b10010, &ENTRY_MAXIMIZES_3401038828375121966)],
        ),
        (
            UniCase::ascii("caracolling"),
            &[(0b11010, &ENTRY_CARACOLING_4913840131879532625)],
        ),
        (
            UniCase::ascii("epitomize"),
            &[(0b01001, &ENTRY_EPITOMIZE_13528530811124562195)],
        ),
        (
            UniCase::ascii("unalcoholiseddest"),
            &[(0b10010, &ENTRY_UNALCOHOLIZEDDEST_3929868538999714538)],
        ),
        (
            UniCase::ascii("unsystematisinger"),
            &[(0b10010, &ENTRY_UNSYSTEMATIZINGER_15925085597038328684)],
        ),
        (
            UniCase::ascii("equestrianise"),
            &[(0b10010, &ENTRY_EQUESTRIANIZE_13136044868803266911)],
        ),
        (
            UniCase::ascii("prefavor"),
            &[(0b00001, &ENTRY_PREFAVOR_9822958321616866402)],
        ),
        (
            UniCase::ascii("haematin"),
            &[(0b11010, &ENTRY_HEMATIN_7088374062718549777)],
        ),
        (
            UniCase::ascii("pavior"),
            &[(0b00001, &ENTRY_PAVIOR_17636375175721697070)],
        ),
        (
            UniCase::ascii("traditionise"),
            &[(0b10010, &ENTRY_TRADITIONIZE_11047234467125040571)],
        ),
        (
            UniCase::ascii("aphetizing"),
            &[(0b01001, &ENTRY_APHETIZING_13930569398062916036)],
        ),
        (
            UniCase::ascii("autoecy"),
            &[(0b11010, &ENTRY_AUTECY_13719576853502314463)],
        ),
        (
            UniCase::ascii("ventriloquize"),
            &[(0b01001, &ENTRY_VENTRILOQUIZE_7278912386074535832)],
        ),
        (
            UniCase::ascii("kaolinisations"),
            &[(0b10010, &ENTRY_KAOLINIZATIONS_1147736204566705803)],
        ),
        (
            UniCase::ascii("haemophiliacs"),
            &[(0b10010, &ENTRY_HEMOPHILIACS_6189076765654799565)],
        ),
        (
            UniCase::ascii("splenectomized"),
            &[(0b01001, &ENTRY_SPLENECTOMIZED_8219804151047161524)],
        ),
        (
            UniCase::ascii("centrepieces"),
            &[(0b11010, &ENTRY_CENTERPIECES_2175158136644578025)],
        ),
        (
            UniCase::ascii("honorlesser"),
            &[(0b11001, &ENTRY_HONORLESSER_8961804267410442314)],
        ),
        (
            UniCase::ascii("catechisation"),
            &[(0b10010, &ENTRY_CATECHIZATION_12810249719668086283)],
        ),
        (
            UniCase::ascii("monopolises"),
            &[(0b10010, &ENTRY_MONOPOLIZES_6838092214769726019)],
        ),
        (
            UniCase::ascii("paleontologically"),
            &[(0b10001, &ENTRY_PALEONTOLOGICALLY_3574530926178177300)],
        ),
        (
            UniCase::ascii("dastardize"),
            &[(0b01001, &ENTRY_DASTARDIZE_9137258977351501392)],
        ),
        (
            UniCase::ascii("londonizes"),
            &[(0b01001, &ENTRY_LONDONIZES_3901227594887662007)],
        ),
        (
            UniCase::ascii("asynchronizes"),
            &[(0b01001, &ENTRY_ASYNCHRONIZES_4368864858861627592)],
        ),
        (
            UniCase::ascii("mutagenize"),
            &[(0b01001, &ENTRY_MUTAGENIZE_13512560099179859556)],
        ),
        (
            UniCase::ascii("pulpitize"),
            &[(0b01001, &ENTRY_PULPITIZE_14520819506187442470)],
        ),
        (
            UniCase::ascii("federalising"),
            &[(0b10010, &ENTRY_FEDERALIZING_16718667241930274816)],
        ),
        (
            UniCase::ascii("gallisising"),
            &[(0b10010, &ENTRY_GALLISIZING_11425765967668875369)],
        ),
        (
            UniCase::ascii("palaeoanthropography"),
            &[(0b11010, &ENTRY_PALEOANTHROPOGRAPHY_9998212461382827548)],
        ),
        (
            UniCase::ascii("periesophageal"),
            &[(0b00001, &ENTRY_PERIESOPHAGEAL_9030912638833637940)],
        ),
        (
            UniCase::ascii("pulverised"),
            &[(0b10010, &ENTRY_PULVERIZED_14246254308729460669)],
        ),
        (
            UniCase::ascii("toxinemia"),
            &[(0b00001, &ENTRY_TOXINEMIA_4067816496926950076)],
        ),
        (
            UniCase::ascii("casualizing"),
            &[(0b01001, &ENTRY_CASUALIZING_16345100801087952198)],
        ),
        (
            UniCase::ascii("phonemicised"),
            &[(0b10010, &ENTRY_PHONEMICIZED_17232917412462599644)],
        ),
        (
            UniCase::ascii("shoveling"),
            &[(0b00001, &ENTRY_SHOVELING_4658042570347509024)],
        ),
        (
            UniCase::ascii("rebaptize"),
            &[(0b01001, &ENTRY_REBAPTIZE_571434688106506900)],
        ),
        (
            UniCase::ascii("scenarized"),
            &[(0b01001, &ENTRY_SCENARIZED_13846545490430585820)],
        ),
        (
            UniCase::ascii("regionalizations"),
            &[(0b01001, &ENTRY_REGIONALIZATIONS_17188055835713620803)],
        ),
        (
            UniCase::ascii("proctorising"),
            &[(0b10010, &ENTRY_PROCTORIZING_12194166959190016917)],
        ),
        (
            UniCase::ascii("diploe"),
            &[
                (0b11010, &ENTRY_DIPLE_3376459421960689495),
                (0b00001, &ENTRY_DIPLOE_5571525081319448833),
            ],
        ),
        (
            UniCase::ascii("moslemize"),
            &[(0b01001, &ENTRY_MOSLEMIZE_16249209972322086947)],
        ),
        (
            UniCase::ascii("spanishises"),
            &[(0b10010, &ENTRY_SPANISHIZES_15280734989274435032)],
        ),
        (
            UniCase::ascii("agathodemon"),
            &[(0b00001, &ENTRY_AGATHODEMON_1771853124296768685)],
        ),
        (
            UniCase::ascii("allegorisations"),
            &[(0b10010, &ENTRY_ALLEGORIZATIONS_1317829325279302497)],
        ),
        (
            UniCase::ascii("disbowelling"),
            &[(0b11010, &ENTRY_DISBOWELING_14146470427022244483)],
        ),
        (
            UniCase::ascii("semihumanizeds"),
            &[(0b01001, &ENTRY_SEMIHUMANIZEDS_17371974753621699342)],
        ),
        (
            UniCase::ascii("colorblindnesses"),
            &[(0b11001, &ENTRY_COLORBLINDNESSES_12714928556099515868)],
        ),
        (
            UniCase::ascii("astronomise"),
            &[(0b10010, &ENTRY_ASTRONOMIZE_8434822243027737838)],
        ),
        (
            UniCase::ascii("concertiser"),
            &[(0b10010, &ENTRY_CONCERTIZER_1607241334899378280)],
        ),
        (
            UniCase::ascii("haemagglutination"),
            &[(0b11010, &ENTRY_HEMAGGLUTINATION_16199920820699607422)],
        ),
        (
            UniCase::ascii("volatilization"),
            &[(0b01001, &ENTRY_VOLATILIZATION_2524869946541654890)],
        ),
        (
            UniCase::ascii("electricize"),
            &[(0b01001, &ENTRY_ELECTRICIZE_4911015515844771622)],
        ),
        (
            UniCase::ascii("haematometer"),
            &[(0b11010, &ENTRY_HEMATOMETER_16112233482898382242)],
        ),
        (
            UniCase::ascii("senilise"),
            &[(0b10010, &ENTRY_SENILIZE_8029621471742989343)],
        ),
        (
            UniCase::ascii("trivializes"),
            &[(0b01001, &ENTRY_TRIVIALIZES_12098662311152290426)],
        ),
        (
            UniCase::ascii("libellousliest"),
            &[(0b11010, &ENTRY_LIBELOUSLIEST_16123024350035836990)],
        ),
        (
            UniCase::ascii("disindustrializations"),
            &[(0b01001, &ENTRY_DISINDUSTRIALIZATIONS_12474625419721941228)],
        ),
        (
            UniCase::ascii("compartmentalised"),
            &[(0b10010, &ENTRY_COMPARTMENTALIZED_2091042337396016604)],
        ),
        (
            UniCase::ascii("hecatean"),
            &[(0b00001, &ENTRY_HECATEAN_15663949261116623377)],
        ),
        (
            UniCase::ascii("favouress"),
            &[(0b11010, &ENTRY_FAVORESS_10320527329712113257)],
        ),
        (
            UniCase::ascii("armor"),
            &[(0b11001, &ENTRY_ARMOR_6791544457048582167)],
        ),
        (
            UniCase::ascii("reoxidized"),
            &[(0b01001, &ENTRY_REOXIDIZED_13705047693863706297)],
        ),
        (
            UniCase::ascii("contextualizations"),
            &[(0b01001, &ENTRY_CONTEXTUALIZATIONS_18105932896496599445)],
        ),
        (
            UniCase::ascii("haematogeneses"),
            &[(0b11010, &ENTRY_HEMATOGENESES_13718226437830070782)],
        ),
        (
            UniCase::ascii("hyalinize"),
            &[(0b01001, &ENTRY_HYALINIZE_11908495486530243350)],
        ),
        (
            UniCase::ascii("pythagoreanizes"),
            &[(0b01001, &ENTRY_PYTHAGOREANIZES_7402158601998337606)],
        ),
        (
            UniCase::ascii("premillennializing"),
            &[(0b01001, &ENTRY_PREMILLENNIALIZING_250347440556746925)],
        ),
        (
            UniCase::ascii("optimalising"),
            &[(0b10010, &ENTRY_OPTIMALIZING_12458824693754631504)],
        ),
        (
            UniCase::ascii("judicialises"),
            &[(0b10010, &ENTRY_JUDICIALIZES_7935109342064479052)],
        ),
        (
            UniCase::ascii("brutalizations"),
            &[(0b01001, &ENTRY_BRUTALIZATIONS_14502881577076747180)],
        ),
        (
            UniCase::ascii("saeta"),
            &[(0b11010, &ENTRY_SETA_9673520022199067907)],
        ),
        (
            UniCase::ascii("unscepteredder"),
            &[(0b00001, &ENTRY_UNSCEPTEREDDER_2376849210254288587)],
        ),
        (
            UniCase::ascii("noncolorability"),
            &[(0b10001, &ENTRY_NONCOLORABILITY_7944763850740895408)],
        ),
        (
            UniCase::ascii("exorciser"),
            &[(0b10010, &ENTRY_EXORCIZER_10300614530359206460)],
        ),
        (
            UniCase::ascii("antimediaeval"),
            &[(0b11010, &ENTRY_ANTIMEDIEVAL_6846585678553345503)],
        ),
        (
            UniCase::ascii("gastrocoele"),
            &[(0b11010, &ENTRY_GASTROCELE_17796500068789968080)],
        ),
        (
            UniCase::ascii("attitudinizer"),
            &[(0b01001, &ENTRY_ATTITUDINIZER_2282587564825240743)],
        ),
        (
            UniCase::ascii("reaexportation"),
            &[(0b11010, &ENTRY_REEXPORTATION_9761953209479597434)],
        ),
        (
            UniCase::ascii("redialed"),
            &[(0b01001, &ENTRY_REDIALED_1443583636270689000)],
        ),
        (
            UniCase::ascii("paleontographies"),
            &[(0b10001, &ENTRY_PALEONTOGRAPHIES_4145254269175447370)],
        ),
        (
            UniCase::ascii("demobilise"),
            &[(0b10010, &ENTRY_DEMOBILIZE_7893368911880481234)],
        ),
        (
            UniCase::ascii("hypervitalises"),
            &[(0b10010, &ENTRY_HYPERVITALIZES_11384012178375345224)],
        ),
        (
            UniCase::ascii("laboured"),
            &[(0b11010, &ENTRY_LABORED_17978981141111186545)],
        ),
        (
            UniCase::ascii("setulae"),
            &[(0b11010, &ENTRY_SETULE_8234529077451319159)],
        ),
        (
            UniCase::ascii("resinize"),
            &[(0b01001, &ENTRY_RESINIZE_14451332919662209430)],
        ),
        (
            UniCase::ascii("carbonizabler"),
            &[(0b01001, &ENTRY_CARBONIZABLER_11011547734927627020)],
        ),
        (
            UniCase::ascii("dane"),
            &[(0b00001, &ENTRY_DANE_3862192600118407294)],
        ),
        (
            UniCase::ascii("enolise"),
            &[(0b10010, &ENTRY_ENOLIZE_5068170608685889108)],
        ),
        (
            UniCase::ascii("remonetised"),
            &[(0b10010, &ENTRY_REMONETIZED_7157192020575645575)],
        ),
        (
            UniCase::ascii("officialize"),
            &[(0b01001, &ENTRY_OFFICIALIZE_3115747240724358934)],
        ),
        (
            UniCase::ascii("polysulphurization"),
            &[(0b01001, &ENTRY_POLYSULPHURIZATION_16575270856614193114)],
        ),
        (
            UniCase::ascii("aguize"),
            &[(0b01001, &ENTRY_AGUIZE_11273323337042225528)],
        ),
        (
            UniCase::ascii("mythicisation"),
            &[(0b10010, &ENTRY_MYTHICIZATION_4467730647442451023)],
        ),
        (
            UniCase::ascii("communalise"),
            &[(0b10010, &ENTRY_COMMUNALIZE_16978210201059417779)],
        ),
        (
            UniCase::ascii("synopsising"),
            &[(0b10010, &ENTRY_SYNOPSIZING_8436973275561705386)],
        ),
        (
            UniCase::ascii("mesmerizations"),
            &[(0b01001, &ENTRY_MESMERIZATIONS_7650562438007026759)],
        ),
        (
            UniCase::ascii("functionize"),
            &[(0b01001, &ENTRY_FUNCTIONIZE_14138434827093737545)],
        ),
        (
            UniCase::ascii("policizer"),
            &[(0b01001, &ENTRY_POLICIZER_7661480523981039298)],
        ),
        (
            UniCase::ascii("colourtype"),
            &[(0b11010, &ENTRY_COLORTYPE_14680038702599961625)],
        ),
        (
            UniCase::ascii("palaestras"),
            &[(0b11010, &ENTRY_PALESTRAS_10577628877980961814)],
        ),
        (
            UniCase::ascii("priorisations"),
            &[(0b10010, &ENTRY_PRIORIZATIONS_7395933477241911403)],
        ),
        (
            UniCase::ascii("anticatalysers"),
            &[(0b11010, &ENTRY_ANTICATALYZERS_14048896960716076262)],
        ),
        (
            UniCase::ascii("dichotomizing"),
            &[(0b01001, &ENTRY_DICHOTOMIZING_6605468293502488075)],
        ),
        (
            UniCase::ascii("copolymerization"),
            &[(0b01001, &ENTRY_COPOLYMERIZATION_3565686431310114577)],
        ),
        (
            UniCase::ascii("pasteurization"),
            &[(0b01001, &ENTRY_PASTEURIZATION_3504555580005315179)],
        ),
        (
            UniCase::ascii("vaginule"),
            &[(0b00001, &ENTRY_VAGINULE_15009785862152351808)],
        ),
        (
            UniCase::ascii("dissocialise"),
            &[(0b10010, &ENTRY_DISSOCIALIZE_15635530793606336711)],
        ),
        (
            UniCase::ascii("overcentralisations"),
            &[(0b10010, &ENTRY_OVERCENTRALIZATIONS_13210816604166532536)],
        ),
        (
            UniCase::ascii("astronomises"),
            &[(0b10010, &ENTRY_ASTRONOMIZES_3426897682798715707)],
        ),
        (
            UniCase::ascii("nephrectomising"),
            &[(0b10010, &ENTRY_NEPHRECTOMIZING_3756994676330441516)],
        ),
        (
            UniCase::ascii("intercrystallisation"),
            &[(0b10010, &ENTRY_INTERCRYSTALLIZATION_535306253275539668)],
        ),
        (
            UniCase::ascii("unlocalizables"),
            &[(0b01001, &ENTRY_UNLOCALIZABLES_11709528533561573241)],
        ),
        (
            UniCase::ascii("unvisualised"),
            &[(0b10010, &ENTRY_UNVISUALIZED_2776258560824841456)],
        ),
        (
            UniCase::ascii("molds"),
            &[(0b11001, &ENTRY_MOLDS_209402696956725647)],
        ),
        (
            UniCase::ascii("structuralize"),
            &[(0b01001, &ENTRY_STRUCTURALIZE_16594415476051004260)],
        ),
        (
            UniCase::ascii("nominalisations"),
            &[(0b10010, &ENTRY_NOMINALIZATIONS_16075171424950015123)],
        ),
        (
            UniCase::ascii("spheroidizations"),
            &[(0b01001, &ENTRY_SPHEROIDIZATIONS_780683803829928867)],
        ),
        (
            UniCase::ascii("paleobiologic"),
            &[(0b10001, &ENTRY_PALEOBIOLOGIC_16440511702072730664)],
        ),
        (
            UniCase::ascii("palestric"),
            &[(0b10001, &ENTRY_PALESTRIC_13247296948328839180)],
        ),
        (
            UniCase::ascii("marmarises"),
            &[(0b10010, &ENTRY_MARMARIZES_15375966147001754735)],
        ),
        (
            UniCase::ascii("hyperrealizes"),
            &[(0b01001, &ENTRY_HYPERREALIZES_6087084825849447883)],
        ),
        (
            UniCase::ascii("diabolizations"),
            &[(0b01001, &ENTRY_DIABOLIZATIONS_3822742467764077320)],
        ),
        (
            UniCase::ascii("cataloging"),
            &[(0b00001, &ENTRY_CATALOGING_8506877421439024861)],
        ),
        (
            UniCase::ascii("parametrising"),
            &[(0b10010, &ENTRY_PARAMETRIZING_684518743725650757)],
        ),
        (
            UniCase::ascii("inorganisations"),
            &[(0b10010, &ENTRY_INORGANIZATIONS_3786296158259671895)],
        ),
        (
            UniCase::ascii("cicatrises"),
            &[(0b10010, &ENTRY_CICATRIZES_18063560548351573209)],
        ),
        (
            UniCase::ascii("morselling"),
            &[(0b11010, &ENTRY_MORSELING_3778440818761410189)],
        ),
        (
            UniCase::ascii("armorers"),
            &[(0b11001, &ENTRY_ARMORERS_5671193923544706720)],
        ),
        (
            UniCase::ascii("savoring"),
            &[(0b11001, &ENTRY_SAVORING_6763000239615004808)],
        ),
        (
            UniCase::ascii("sapremias"),
            &[(0b00001, &ENTRY_SAPREMIAS_2393230130508325789)],
        ),
        (
            UniCase::ascii("tenderise"),
            &[(0b10010, &ENTRY_TENDERIZE_14583554302804750450)],
        ),
        (
            UniCase::ascii("aggrandizable"),
            &[(0b01001, &ENTRY_AGGRANDIZABLE_14295678675229969268)],
        ),
        (
            UniCase::ascii("galactosemias"),
            &[(0b10001, &ENTRY_GALACTOSEMIAS_2689872380032083965)],
        ),
        (
            UniCase::ascii("insolubilising"),
            &[(0b10010, &ENTRY_INSOLUBILIZING_17373219238380218554)],
        ),
        (
            UniCase::ascii("dishonorablenesses"),
            &[(0b11001, &ENTRY_DISHONORABLENESSES_11979409559133838321)],
        ),
        (
            UniCase::ascii("eviler"),
            &[(0b00001, &ENTRY_EVILER_16165460214642184499)],
        ),
        (
            UniCase::ascii("sourdines"),
            &[(0b11010, &ENTRY_SORDINES_17955052261708476598)],
        ),
        (
            UniCase::ascii("parametrize"),
            &[(0b01001, &ENTRY_PARAMETRIZE_14088334789658250719)],
        ),
        (
            UniCase::ascii("nesslerizing"),
            &[(0b01001, &ENTRY_NESSLERIZING_15229221485702009447)],
        ),
        (
            UniCase::ascii("renormalise"),
            &[(0b10010, &ENTRY_RENORMALIZE_4228995450916847764)],
        ),
        (
            UniCase::ascii("neutralisations"),
            &[(0b10010, &ENTRY_NEUTRALIZATIONS_11864407426607384673)],
        ),
        (
            UniCase::ascii("nickeled"),
            &[(0b00001, &ENTRY_NICKELED_79394617530411001)],
        ),
        (
            UniCase::ascii("unsignaliseddest"),
            &[(0b10010, &ENTRY_UNSIGNALIZEDDEST_14758681485610426786)],
        ),
        (
            UniCase::ascii("theosophises"),
            &[(0b10010, &ENTRY_THEOSOPHIZES_1158826125232789362)],
        ),
        (
            UniCase::ascii("unspecialisingest"),
            &[(0b10010, &ENTRY_UNSPECIALIZINGEST_13963040120295765584)],
        ),
        (
            UniCase::ascii("stowre"),
            &[(0b11010, &ENTRY_STOWER_3427925530344361004)],
        ),
        (
            UniCase::ascii("overspecialisations"),
            &[(0b10010, &ENTRY_OVERSPECIALIZATIONS_602774670593965924)],
        ),
        (
            UniCase::ascii("dockization"),
            &[(0b01001, &ENTRY_DOCKIZATION_1535416910054929275)],
        ),
        (
            UniCase::ascii("apothegmatising"),
            &[(0b10010, &ENTRY_APOTHEGMATIZING_2185890142177612358)],
        ),
        (
            UniCase::ascii("photopolymerization"),
            &[(0b01001, &ENTRY_PHOTOPOLYMERIZATION_16063694208716353085)],
        ),
        (
            UniCase::ascii("bradypnoea"),
            &[(0b11010, &ENTRY_BRADYPNEA_14990069084802510573)],
        ),
        (
            UniCase::ascii("artificializes"),
            &[(0b01001, &ENTRY_ARTIFICIALIZES_12340528017967580371)],
        ),
        (
            UniCase::ascii("dionise"),
            &[(0b10010, &ENTRY_DIONIZE_5302013842773672496)],
        ),
        (
            UniCase::ascii("honourable"),
            &[(0b11010, &ENTRY_HONORABLE_16346079154255994276)],
        ),
        (
            UniCase::ascii("chloridises"),
            &[(0b10010, &ENTRY_CHLORIDIZES_10968236782051706807)],
        ),
        (
            UniCase::ascii("chromised"),
            &[(0b10010, &ENTRY_CHROMIZED_10186147401749465104)],
        ),
        (
            UniCase::ascii("hostilize"),
            &[(0b01001, &ENTRY_HOSTILIZE_13783071968481819947)],
        ),
        (
            UniCase::ascii("corvae"),
            &[(0b11010, &ENTRY_CORVE_15600376709730904093)],
        ),
        (
            UniCase::ascii("proverbialized"),
            &[(0b01001, &ENTRY_PROVERBIALIZED_15384141908364563413)],
        ),
        (
            UniCase::ascii("morselize"),
            &[(0b01001, &ENTRY_MORSELIZE_737147545384494790)],
        ),
        (
            UniCase::ascii("essentialize"),
            &[(0b01001, &ENTRY_ESSENTIALIZE_6300653085008787820)],
        ),
        (
            UniCase::ascii("eglogue"),
            &[(0b00001, &ENTRY_EGLOGUE_16104631981488511989)],
        ),
        (
            UniCase::ascii("socialisation"),
            &[(0b10010, &ENTRY_SOCIALIZATION_2084413938110848032)],
        ),
        (
            UniCase::ascii("neighborlier"),
            &[(0b11001, &ENTRY_NEIGHBORLIER_16947297940053670257)],
        ),
        (
            UniCase::ascii("isoimmunize"),
            &[(0b01001, &ENTRY_ISOIMMUNIZE_1925023617514416731)],
        ),
        (
            UniCase::ascii("epitaphize"),
            &[(0b01001, &ENTRY_EPITAPHIZE_13795478585860811984)],
        ),
        (
            UniCase::ascii("cupellation"),
            &[(0b11010, &ENTRY_CUPELATION_14255540896200543840)],
        ),
        (
            UniCase::ascii("colorants"),
            &[(0b11001, &ENTRY_COLORANTS_7537794752295559574)],
        ),
        (
            UniCase::ascii("epiloguize"),
            &[(0b01001, &ENTRY_EPILOGUIZE_689201102200555729)],
        ),
        (
            UniCase::ascii("randomising"),
            &[(0b10010, &ENTRY_RANDOMIZING_1606855122710420786)],
        ),
        (
            UniCase::ascii("analyzed"),
            &[(0b01001, &ENTRY_ANALYZED_3241611515791740784)],
        ),
        (
            UniCase::ascii("pillorizes"),
            &[(0b01001, &ENTRY_PILLORIZES_12687325336889895788)],
        ),
        (
            UniCase::ascii("infamonizing"),
            &[(0b01001, &ENTRY_INFAMONIZING_3560185438718299549)],
        ),
        (
            UniCase::ascii("securitises"),
            &[(0b10010, &ENTRY_SECURITIZES_964431635949451194)],
        ),
        (
            UniCase::ascii("romanization"),
            &[(0b01001, &ENTRY_ROMANIZATION_1812649176047396288)],
        ),
        (
            UniCase::ascii("anserine"),
            &[(0b00001, &ENTRY_ANSERINE_7284353552541073260)],
        ),
        (
            UniCase::ascii("technicises"),
            &[(0b10010, &ENTRY_TECHNICIZES_13211595356574862793)],
        ),
        (
            UniCase::ascii("photosensitize"),
            &[(0b01001, &ENTRY_PHOTOSENSITIZE_8288914178365456711)],
        ),
        (
            UniCase::ascii("transistorisations"),
            &[(0b10010, &ENTRY_TRANSISTORIZATIONS_15440922126340456777)],
        ),
        (
            UniCase::ascii("balsamize"),
            &[(0b01001, &ENTRY_BALSAMIZE_1201263166025813215)],
        ),
        (
            UniCase::ascii("peroxidize"),
            &[(0b01001, &ENTRY_PEROXIDIZE_15017198944556073397)],
        ),
        (
            UniCase::ascii("ecus"),
            &[(0b00001, &ENTRY_ECUS_7337291910539278082)],
        ),
        (
            UniCase::ascii("gluttonizes"),
            &[(0b01001, &ENTRY_GLUTTONIZES_15763514001401508118)],
        ),
        (
            UniCase::ascii("penalisabler"),
            &[(0b10010, &ENTRY_PENALIZABLER_10283897399997620359)],
        ),
        (
            UniCase::ascii("tutorised"),
            &[(0b10010, &ENTRY_TUTORIZED_14661527617907051055)],
        ),
        (
            UniCase::ascii("cognisabliest"),
            &[(0b10010, &ENTRY_COGNIZABLIEST_13701693542862328478)],
        ),
        (
            UniCase::ascii("hydrolise"),
            &[(0b10010, &ENTRY_HYDROLIZE_5796989920616720182)],
        ),
        (
            UniCase::ascii("pyrenaeus"),
            &[(0b11010, &ENTRY_PYRENEUS_10190704627498876210)],
        ),
        (
            UniCase::ascii("edematose"),
            &[(0b11001, &ENTRY_EDEMATOSE_16851378643586465230)],
        ),
        (
            UniCase::ascii("departmentalises"),
            &[(0b10010, &ENTRY_DEPARTMENTALIZES_2816661299052746212)],
        ),
        (
            UniCase::ascii("sulcalizing"),
            &[(0b01001, &ENTRY_SULCALIZING_5886947456402704718)],
        ),
        (
            UniCase::ascii("unsecularise"),
            &[(0b10010, &ENTRY_UNSECULARIZE_5214216027332443223)],
        ),
        (
            UniCase::ascii("sloganisings"),
            &[(0b10010, &ENTRY_SLOGANIZINGS_8139231964165892944)],
        ),
        (
            UniCase::ascii("persianizing"),
            &[(0b01001, &ENTRY_PERSIANIZING_12004543135849853067)],
        ),
        (
            UniCase::ascii("hemad"),
            &[(0b00001, &ENTRY_HEMAD_13652123074339994243)],
        ),
        (
            UniCase::ascii("criticisables"),
            &[(0b10010, &ENTRY_CRITICIZABLES_15336014985309704799)],
        ),
        (
            UniCase::ascii("synergise"),
            &[(0b10010, &ENTRY_SYNERGIZE_8702906954167154251)],
        ),
        (
            UniCase::ascii("documentarizing"),
            &[(0b01001, &ENTRY_DOCUMENTARIZING_617029537042756884)],
        ),
        (
            UniCase::ascii("epitomisers"),
            &[(0b10010, &ENTRY_EPITOMIZERS_4593373083947475967)],
        ),
        (
            UniCase::ascii("marvelousliest"),
            &[(0b00001, &ENTRY_MARVELOUSLIEST_787848875312131772)],
        ),
        (
            UniCase::ascii("idumeans"),
            &[(0b00001, &ENTRY_IDUMEANS_2701997562386323077)],
        ),
        (
            UniCase::ascii("calking"),
            &[
                (0b00001, &ENTRY_CALKING_11924577664112241546),
                (0b00001, &ENTRY_CAULKING_9579808018830977690),
                (0b00001, &ENTRY_CAULK_17535979702514416347),
            ],
        ),
        (
            UniCase::ascii("conundrumise"),
            &[(0b10010, &ENTRY_CONUNDRUMIZE_12213997648480363330)],
        ),
        (
            UniCase::ascii("foveole"),
            &[(0b00001, &ENTRY_FOVEOLE_11823716102342610928)],
        ),
        (
            UniCase::ascii("gastraeas"),
            &[(0b11010, &ENTRY_GASTREAS_1400735590131613456)],
        ),
        (
            UniCase::ascii("cholaemias"),
            &[(0b11010, &ENTRY_CHOLEMIAS_1320999302245492995)],
        ),
        (
            UniCase::ascii("canonicalise"),
            &[(0b10010, &ENTRY_CANONICALIZE_2632431567177056192)],
        ),
        (
            UniCase::ascii("empyreumatises"),
            &[(0b10010, &ENTRY_EMPYREUMATIZES_9068196112099455402)],
        ),
        (
            UniCase::ascii("subcalibre"),
            &[(0b11010, &ENTRY_SUBCALIBER_16406723248353952807)],
        ),
        (
            UniCase::ascii("libelants"),
            &[(0b00001, &ENTRY_LIBELANTS_18272012151164220579)],
        ),
        (
            UniCase::ascii("skyers"),
            &[(0b00001, &ENTRY_SKYERS_744502748846351073)],
        ),
        (
            UniCase::ascii("resynchronizing"),
            &[(0b01001, &ENTRY_RESYNCHRONIZING_2324560686252943876)],
        ),
        (
            UniCase::ascii("journalises"),
            &[(0b10010, &ENTRY_JOURNALIZES_413265712215135289)],
        ),
        (
            UniCase::ascii("defenceman"),
            &[(0b11010, &ENTRY_DEFENSEMAN_4178732654030128668)],
        ),
        (
            UniCase::ascii("photaesthesis"),
            &[(0b11010, &ENTRY_PHOTESTHESIS_6981549980908445509)],
        ),
        (
            UniCase::ascii("remonetisations"),
            &[(0b10010, &ENTRY_REMONETIZATIONS_5697855088114742500)],
        ),
        (
            UniCase::ascii("anaesthyl"),
            &[(0b11010, &ENTRY_ANESTHYL_8174332230955659903)],
        ),
        (
            UniCase::ascii("preconising"),
            &[(0b10010, &ENTRY_PRECONIZING_10462413300311269807)],
        ),
        (
            UniCase::ascii("berl"),
            &[(0b00001, &ENTRY_BERL_1185444321092270619)],
        ),
        (
            UniCase::ascii("reconnoitrer"),
            &[(0b11010, &ENTRY_RECONNOITERER_12511415252932652959)],
        ),
        (
            UniCase::ascii("disfavor"),
            &[(0b11001, &ENTRY_DISFAVOR_10548525794143920697)],
        ),
        (
            UniCase::ascii("hemotoxic"),
            &[(0b10001, &ENTRY_HEMOTOXIC_15421781554160520339)],
        ),
        (
            UniCase::ascii("polemicising"),
            &[(0b10010, &ENTRY_POLEMICIZING_15439521581223222709)],
        ),
        (
            UniCase::ascii("respectabilises"),
            &[(0b10010, &ENTRY_RESPECTABILIZES_14602704037450130293)],
        ),
        (
            UniCase::ascii("hypocenter"),
            &[(0b00001, &ENTRY_HYPOCENTER_10924617547082167348)],
        ),
        (
            UniCase::ascii("unconventionalize"),
            &[(0b01001, &ENTRY_UNCONVENTIONALIZE_7485202036270814256)],
        ),
        (
            UniCase::ascii("marmarizing"),
            &[(0b01001, &ENTRY_MARMARIZING_3793569524149852443)],
        ),
        (
            UniCase::ascii("immoralises"),
            &[(0b10010, &ENTRY_IMMORALIZES_2840645599967765235)],
        ),
        (
            UniCase::ascii("honourlesses"),
            &[(0b11010, &ENTRY_HONORLESSES_18009355419310607858)],
        ),
        (
            UniCase::ascii("chromise"),
            &[(0b10010, &ENTRY_CHROMIZE_5262872595657112785)],
        ),
        (
            UniCase::ascii("unsupernaturalize"),
            &[(0b01001, &ENTRY_UNSUPERNATURALIZE_11379677666614455606)],
        ),
        (
            UniCase::ascii("epidotisation"),
            &[(0b10010, &ENTRY_EPIDOTIZATION_14022545118965805510)],
        ),
        (
            UniCase::ascii("partialises"),
            &[(0b10010, &ENTRY_PARTIALIZES_13769905578223386853)],
        ),
        (
            UniCase::ascii("parsonises"),
            &[(0b10010, &ENTRY_PARSONIZES_7532265200903960160)],
        ),
        (
            UniCase::ascii("cyanize"),
            &[(0b01001, &ENTRY_CYANIZE_16155583626941063831)],
        ),
        (
            UniCase::ascii("unepitomisedder"),
            &[(0b10010, &ENTRY_UNEPITOMIZEDDER_14282657736379387619)],
        ),
        (
            UniCase::ascii("centimeter"),
            &[(0b00001, &ENTRY_CENTIMETER_7893665458627405085)],
        ),
        (
            UniCase::ascii("neighbourers"),
            &[(0b11010, &ENTRY_NEIGHBORERS_12831530063051977068)],
        ),
        (
            UniCase::ascii("idiotize"),
            &[(0b01001, &ENTRY_IDIOTIZE_1684624828093976331)],
        ),
        (
            UniCase::ascii("polychromize"),
            &[(0b01001, &ENTRY_POLYCHROMIZE_13944884036814089178)],
        ),
        (
            UniCase::ascii("lupines"),
            &[(0b01001, &ENTRY_LUPINES_12557265007088872959)],
        ),
        (
            UniCase::ascii("tragicolored"),
            &[(0b00001, &ENTRY_TRAGICOLORED_13278772284942211165)],
        ),
        (
            UniCase::ascii("unrecognisablest"),
            &[(0b10010, &ENTRY_UNRECOGNIZABLEST_11700300065072913162)],
        ),
        (
            UniCase::ascii("enigmatises"),
            &[(0b10010, &ENTRY_ENIGMATIZES_13870261966778024845)],
        ),
        (
            UniCase::ascii("supercanonization"),
            &[(0b01001, &ENTRY_SUPERCANONIZATION_4336218867107151380)],
        ),
        (
            UniCase::ascii("dolomitizes"),
            &[(0b01001, &ENTRY_DOLOMITIZES_14363893600761024796)],
        ),
        (
            UniCase::ascii("compartmentalization"),
            &[(0b01001, &ENTRY_COMPARTMENTALIZATION_18240462251141060220)],
        ),
        (
            UniCase::ascii("unitizing"),
            &[(0b01001, &ENTRY_UNITIZING_14503461086641416326)],
        ),
        (
            UniCase::ascii("democratizer"),
            &[(0b01001, &ENTRY_DEMOCRATIZER_15492342920596234152)],
        ),
        (
            UniCase::ascii("angelicise"),
            &[(0b10010, &ENTRY_ANGELICIZE_12868295367561294619)],
        ),
        (
            UniCase::ascii("hoodlumizes"),
            &[(0b01001, &ENTRY_HOODLUMIZES_2337314049834401492)],
        ),
        (
            UniCase::ascii("harmonises"),
            &[(0b10010, &ENTRY_HARMONIZES_11148526706436473737)],
        ),
        (
            UniCase::ascii("pamphletize"),
            &[(0b01001, &ENTRY_PAMPHLETIZE_11971804629691384479)],
        ),
        (
            UniCase::ascii("ethicises"),
            &[(0b10010, &ENTRY_ETHICIZES_4425545207707744116)],
        ),
        (
            UniCase::ascii("laevorotations"),
            &[(0b11010, &ENTRY_LEVOROTATIONS_13418481525546457918)],
        ),
        (
            UniCase::ascii("organizationalliest"),
            &[(0b01001, &ENTRY_ORGANIZATIONALLIEST_5857114456710165646)],
        ),
        (
            UniCase::ascii("vulcanizate"),
            &[(0b01001, &ENTRY_VULCANIZATE_4795671622025524378)],
        ),
        (
            UniCase::ascii("saxonisation"),
            &[(0b10010, &ENTRY_SAXONIZATION_13920447163448605602)],
        ),
        (
            UniCase::ascii("orthographise"),
            &[(0b10010, &ENTRY_ORTHOGRAPHIZE_8119365633244588200)],
        ),
        (
            UniCase::ascii("botanise"),
            &[(0b10010, &ENTRY_BOTANIZE_7551170961793070479)],
        ),
        (
            UniCase::ascii("aetheling"),
            &[(0b11010, &ENTRY_ETHELING_7453000440584654761)],
        ),
        (
            UniCase::ascii("unorganize"),
            &[(0b01001, &ENTRY_UNORGANIZE_16055712748344908044)],
        ),
        (
            UniCase::ascii("antithesizes"),
            &[(0b01001, &ENTRY_ANTITHESIZES_6606468090715627462)],
        ),
        (
            UniCase::ascii("unlocalizabler"),
            &[(0b01001, &ENTRY_UNLOCALIZABLER_1057258441085295588)],
        ),
        (
            UniCase::ascii("arabised"),
            &[(0b10010, &ENTRY_ARABIZED_13913844866590865979)],
        ),
        (
            UniCase::ascii("feminise"),
            &[(0b10010, &ENTRY_FEMINIZE_6528476134483497288)],
        ),
        (
            UniCase::ascii("dracaena"),
            &[(0b11010, &ENTRY_DRACENA_6118539877770808902)],
        ),
        (
            UniCase::ascii("eleometer"),
            &[(0b00001, &ENTRY_ELEOMETER_8406501550306573221)],
        ),
        (
            UniCase::ascii("haemathermous"),
            &[(0b11010, &ENTRY_HEMATHERMOUS_15573027130540325878)],
        ),
        (
            UniCase::ascii("geometrising"),
            &[(0b10010, &ENTRY_GEOMETRIZING_16924051865978425252)],
        ),
        (
            UniCase::ascii("endamoebic"),
            &[(0b11010, &ENTRY_ENDAMEBIC_7654343873984680949)],
        ),
        (
            UniCase::ascii("dimerizes"),
            &[(0b01001, &ENTRY_DIMERIZES_1537628000711484411)],
        ),
        (
            UniCase::ascii("neutralizes"),
            &[(0b01001, &ENTRY_NEUTRALIZES_9070000728487662463)],
        ),
        (
            UniCase::ascii("indigenising"),
            &[(0b10010, &ENTRY_INDIGENIZING_5786616818049833426)],
        ),
        (
            UniCase::ascii("plagiarisers"),
            &[(0b10010, &ENTRY_PLAGIARIZERS_4000297058035207269)],
        ),
        (
            UniCase::ascii("climatised"),
            &[(0b10010, &ENTRY_CLIMATIZED_124773700894549172)],
        ),
        (
            UniCase::ascii("reorganizational"),
            &[(0b01001, &ENTRY_REORGANIZATIONAL_10984641565360643637)],
        ),
        (
            UniCase::ascii("decolourimeter"),
            &[(0b11010, &ENTRY_DECOLORIMETER_9685638258569395132)],
        ),
        (
            UniCase::ascii("presternum"),
            &[(0b00001, &ENTRY_PRESTERNUM_10191977327812747108)],
        ),
        (
            UniCase::ascii("decerebrising"),
            &[(0b10010, &ENTRY_DECEREBRIZING_6341477046577811325)],
        ),
        (
            UniCase::ascii("unbrutalised"),
            &[(0b10010, &ENTRY_UNBRUTALIZED_6338937456842490293)],
        ),
        (
            UniCase::ascii("harmonisables"),
            &[(0b10010, &ENTRY_HARMONIZABLES_12681674670896899721)],
        ),
        (
            UniCase::ascii("parfocalise"),
            &[(0b10010, &ENTRY_PARFOCALIZE_11199953063987118573)],
        ),
        (
            UniCase::ascii("defensemen"),
            &[(0b00001, &ENTRY_DEFENSEMEN_13356773840082441675)],
        ),
        (
            UniCase::ascii("subsidisations"),
            &[(0b10010, &ENTRY_SUBSIDIZATIONS_13296883432062947981)],
        ),
        (
            UniCase::ascii("vaporizable"),
            &[(0b01001, &ENTRY_VAPORIZABLE_1284750919722519568)],
        ),
        (
            UniCase::ascii("skepticalest"),
            &[(0b11001, &ENTRY_SKEPTICALEST_1822492830960306797)],
        ),
        (
            UniCase::ascii("revaporizes"),
            &[(0b01001, &ENTRY_REVAPORIZES_10059326494130071423)],
        ),
        (
            UniCase::ascii("mesprises"),
            &[(0b10010, &ENTRY_MESPRIZES_634955430244876338)],
        ),
        (
            UniCase::ascii("metreless"),
            &[(0b11010, &ENTRY_METERLESS_17184210016380634977)],
        ),
        (
            UniCase::ascii("unilateralise"),
            &[(0b10010, &ENTRY_UNILATERALIZE_4208361192869727001)],
        ),
        (
            UniCase::ascii("electricalises"),
            &[(0b10010, &ENTRY_ELECTRICALIZES_11839544262325067272)],
        ),
        (
            UniCase::ascii("overcentralisation"),
            &[(0b10010, &ENTRY_OVERCENTRALIZATION_7417308276149240356)],
        ),
        (
            UniCase::ascii("epicurizing"),
            &[(0b01001, &ENTRY_EPICURIZING_15655666870475102269)],
        ),
        (
            UniCase::ascii("tranquilizes"),
            &[(0b01001, &ENTRY_TRANQUILIZES_59757620788033573)],
        ),
        (
            UniCase::ascii("sylviinae"),
            &[(0b11010, &ENTRY_SYLVIINE_8241338552519015158)],
        ),
        (
            UniCase::ascii("analyzations"),
            &[(0b01001, &ENTRY_ANALYZATIONS_10325231710634833644)],
        ),
        (
            UniCase::ascii("groyne"),
            &[(0b11010, &ENTRY_GROIN_18030282935737915420)],
        ),
        (
            UniCase::ascii("crystallisability"),
            &[(0b10010, &ENTRY_CRYSTALLIZABILITY_417676650172898499)],
        ),
        (
            UniCase::ascii("centrifugalise"),
            &[(0b10010, &ENTRY_CENTRIFUGALIZE_12152362034063070075)],
        ),
        (
            UniCase::ascii("aluminums"),
            &[(0b01001, &ENTRY_ALUMINUMS_235477509529996640)],
        ),
        (
            UniCase::ascii("legitimatizes"),
            &[(0b01001, &ENTRY_LEGITIMATIZES_4219244495979276250)],
        ),
        (
            UniCase::ascii("apophthegmatizing"),
            &[(0b01001, &ENTRY_APOPHTHEGMATIZING_17329841406994799734)],
        ),
        (
            UniCase::ascii("sectionalized"),
            &[(0b01001, &ENTRY_SECTIONALIZED_15063335524950991716)],
        ),
        (
            UniCase::ascii("kilolitres"),
            &[(0b11010, &ENTRY_KILOLITERS_9786627551420863989)],
        ),
        (
            UniCase::ascii("athetizing"),
            &[(0b01001, &ENTRY_ATHETIZING_9191281724888382129)],
        ),
        (
            UniCase::ascii("salinise"),
            &[(0b10010, &ENTRY_SALINIZE_1624463717219344911)],
        ),
        (
            UniCase::ascii("spartanizes"),
            &[(0b01001, &ENTRY_SPARTANIZES_11376123191933793512)],
        ),
        (
            UniCase::ascii("gourmandisms"),
            &[(0b11010, &ENTRY_GORMANDISMS_2185039788447521753)],
        ),
        (
            UniCase::ascii("unevangelised"),
            &[(0b10010, &ENTRY_UNEVANGELIZED_17902646883952932702)],
        ),
        (
            UniCase::ascii("satinise"),
            &[(0b10010, &ENTRY_SATINIZE_12856779838184407064)],
        ),
        (
            UniCase::ascii("dysesthesia"),
            &[(0b10001, &ENTRY_DYSESTHESIA_10145261120272617451)],
        ),
        (
            UniCase::ascii("sensitized"),
            &[(0b01001, &ENTRY_SENSITIZED_3980543883168272054)],
        ),
        (
            UniCase::ascii("picturize"),
            &[(0b01001, &ENTRY_PICTURIZE_9024247702062369559)],
        ),
        (
            UniCase::ascii("irrealizable"),
            &[(0b01001, &ENTRY_IRREALIZABLE_6638234207162807349)],
        ),
        (
            UniCase::ascii("regionalized"),
            &[(0b01001, &ENTRY_REGIONALIZED_5226562196343077794)],
        ),
        (
            UniCase::ascii("memorizations"),
            &[(0b01001, &ENTRY_MEMORIZATIONS_17836564012509783241)],
        ),
        (
            UniCase::ascii("ostracisable"),
            &[(0b10010, &ENTRY_OSTRACIZABLE_14526333713080172694)],
        ),
        (
            UniCase::ascii("foolhardises"),
            &[(0b10010, &ENTRY_FOOLHARDIZES_10067494006367806341)],
        ),
        (
            UniCase::ascii("rumours"),
            &[(0b11010, &ENTRY_RUMORS_4907921740910409378)],
        ),
        (
            UniCase::ascii("strobile"),
            &[(0b00001, &ENTRY_STROBILE_5462694341161436350)],
        ),
        (
            UniCase::ascii("circularizations"),
            &[(0b01001, &ENTRY_CIRCULARIZATIONS_1984387235149986914)],
        ),
        (
            UniCase::ascii("prefertilize"),
            &[(0b01001, &ENTRY_PREFERTILIZE_14615806731386054716)],
        ),
        (
            UniCase::ascii("perichete"),
            &[(0b00001, &ENTRY_PERICHETE_2868508308788688470)],
        ),
        (
            UniCase::ascii("glamorizations"),
            &[(0b01001, &ENTRY_GLAMORIZATIONS_13386360280962328056)],
        ),
        (
            UniCase::ascii("neighbourly"),
            &[(0b11010, &ENTRY_NEIGHBORLY_3913130996486820034)],
        ),
        (
            UniCase::ascii("pulpitizes"),
            &[(0b01001, &ENTRY_PULPITIZES_600820339977194743)],
        ),
        (
            UniCase::ascii("ungalvaniseds"),
            &[(0b10010, &ENTRY_UNGALVANIZEDS_4906872843938668122)],
        ),
        (
            UniCase::ascii("overnationalisation"),
            &[(0b10010, &ENTRY_OVERNATIONALIZATION_16427980336477721392)],
        ),
        (
            UniCase::ascii("extemporised"),
            &[(0b10010, &ENTRY_EXTEMPORIZED_8884254797509015457)],
        ),
        (
            UniCase::ascii("superorganise"),
            &[(0b10010, &ENTRY_SUPERORGANIZE_8384924288227808894)],
        ),
        (
            UniCase::ascii("sordine"),
            &[(0b00001, &ENTRY_SORDINE_13046642983492348660)],
        ),
        (
            UniCase::ascii("thalamocele"),
            &[(0b00001, &ENTRY_THALAMOCELE_5766303350223704636)],
        ),
        (
            UniCase::ascii("hematometer"),
            &[(0b10001, &ENTRY_HEMATOMETER_16112233482898382242)],
        ),
        (
            UniCase::ascii("proverbialize"),
            &[(0b01001, &ENTRY_PROVERBIALIZE_10779880440815640572)],
        ),
        (
            UniCase::ascii("calliper"),
            &[(0b11010, &ENTRY_CALIPER_1634512857873448114)],
        ),
        (
            UniCase::ascii("trichotomizing"),
            &[(0b01001, &ENTRY_TRICHOTOMIZING_4094867634668496821)],
        ),
        (
            UniCase::ascii("homoeoteleutons"),
            &[(0b11010, &ENTRY_HOMEOTELEUTONS_4791090930087046081)],
        ),
        (
            UniCase::ascii("terf"),
            &[(0b00001, &ENTRY_TERF_3510176223973213714)],
        ),
        (
            UniCase::ascii("formalizing"),
            &[(0b01001, &ENTRY_FORMALIZING_14987435811550688603)],
        ),
        (
            UniCase::ascii("contextualize"),
            &[(0b01001, &ENTRY_CONTEXTUALIZE_4584369818380473712)],
        ),
        (
            UniCase::ascii("thermae"),
            &[(0b11010, &ENTRY_THERME_8882059819611896240)],
        ),
        (
            UniCase::ascii("tittuped"),
            &[(0b00001, &ENTRY_TITTUPED_18032143166294150502)],
        ),
        (
            UniCase::ascii("offencelesser"),
            &[(0b11010, &ENTRY_OFFENSELESSER_8750322905944062314)],
        ),
        (
            UniCase::ascii("semiprofessionaliseds"),
            &[(0b10010, &ENTRY_SEMIPROFESSIONALIZEDS_15921777243236052227)],
        ),
        (
            UniCase::ascii("unvulcanizedder"),
            &[(0b01001, &ENTRY_UNVULCANIZEDDER_15357474347454753550)],
        ),
        (
            UniCase::ascii("hepatizing"),
            &[(0b01001, &ENTRY_HEPATIZING_17190565875897655918)],
        ),
        (
            UniCase::ascii("levulose"),
            &[(0b00001, &ENTRY_LEVULOSE_15099852399033494000)],
        ),
        (
            UniCase::ascii("colourmap"),
            &[(0b11010, &ENTRY_COLORMAP_18024738796464819872)],
        ),
        (
            UniCase::ascii("micrometres"),
            &[(0b11010, &ENTRY_MICROMETERS_5540877797236666596)],
        ),
        (
            UniCase::ascii("mythicization"),
            &[(0b01001, &ENTRY_MYTHICIZATION_4467730647442451023)],
        ),
        (
            UniCase::ascii("remonetisation"),
            &[(0b10010, &ENTRY_REMONETIZATION_212742877311562271)],
        ),
        (
            UniCase::ascii("ischemias"),
            &[(0b11001, &ENTRY_ISCHEMIAS_5196750807964195068)],
        ),
        (
            UniCase::ascii("arenicolor"),
            &[(0b10001, &ENTRY_ARENICOLOR_4953462878754370500)],
        ),
        (
            UniCase::ascii("metamerisation"),
            &[(0b10010, &ENTRY_METAMERIZATION_2147110593558933265)],
        ),
        (
            UniCase::ascii("schematised"),
            &[(0b10010, &ENTRY_SCHEMATIZED_6065522728213827719)],
        ),
        (
            UniCase::ascii("magnetised"),
            &[(0b10010, &ENTRY_MAGNETIZED_329380509853608515)],
        ),
        (
            UniCase::ascii("systematization"),
            &[(0b01001, &ENTRY_SYSTEMATIZATION_7949059312574351676)],
        ),
        (
            UniCase::ascii("masculinization"),
            &[(0b01001, &ENTRY_MASCULINIZATION_7323122115632941475)],
        ),
        (
            UniCase::ascii("semite"),
            &[(0b00001, &ENTRY_SEMITE_8050506285147736874)],
        ),
        (
            UniCase::ascii("misopaedism"),
            &[(0b11010, &ENTRY_MISOPEDISM_6542233660865950036)],
        ),
        (
            UniCase::ascii("demineralizations"),
            &[(0b01001, &ENTRY_DEMINERALIZATIONS_9687527290224020253)],
        ),
        (
            UniCase::ascii("dimensionalising"),
            &[(0b10010, &ENTRY_DIMENSIONALIZING_5188710411327541644)],
        ),
        (
            UniCase::ascii("anabaptised"),
            &[(0b10010, &ENTRY_ANABAPTIZED_10937015334598797503)],
        ),
        (
            UniCase::ascii("irrationalizes"),
            &[(0b01001, &ENTRY_IRRATIONALIZES_8065254995992628819)],
        ),
        (
            UniCase::ascii("hanoverize"),
            &[(0b01001, &ENTRY_HANOVERIZE_11360763386599500895)],
        ),
        (
            UniCase::ascii("digitized"),
            &[(0b01001, &ENTRY_DIGITIZED_18167407254586843848)],
        ),
        (
            UniCase::ascii("palatisations"),
            &[(0b10010, &ENTRY_PALATIZATIONS_17121847778628207370)],
        ),
        (
            UniCase::ascii("groveling"),
            &[(0b01001, &ENTRY_GROVELING_1726744122250600972)],
        ),
        (
            UniCase::ascii("normalize"),
            &[(0b01001, &ENTRY_NORMALIZE_10079721671041412822)],
        ),
        (
            UniCase::ascii("modeler"),
            &[(0b00001, &ENTRY_MODELER_15810368749048552373)],
        ),
        (
            UniCase::ascii("appetises"),
            &[(0b10010, &ENTRY_APPETIZES_1889924664779699277)],
        ),
        (
            UniCase::ascii("reflectorising"),
            &[(0b10010, &ENTRY_REFLECTORIZING_8154759098223325317)],
        ),
        (
            UniCase::ascii("cognized"),
            &[(0b01001, &ENTRY_COGNIZED_17562230997464673899)],
        ),
        (
            UniCase::ascii("immobilise"),
            &[(0b10010, &ENTRY_IMMOBILIZE_1538489296094287236)],
        ),
        (
            UniCase::ascii("antisepticised"),
            &[(0b10010, &ENTRY_ANTISEPTICIZED_3518662086162245234)],
        ),
        (
            UniCase::ascii("enologist"),
            &[(0b00001, &ENTRY_ENOLOGIST_7144439191139309152)],
        ),
        (
            UniCase::ascii("liquidizes"),
            &[(0b01001, &ENTRY_LIQUIDIZES_5754653035068200343)],
        ),
        (
            UniCase::ascii("hyperinsulinise"),
            &[(0b10010, &ENTRY_HYPERINSULINIZE_1640801475569483960)],
        ),
        (
            UniCase::ascii("untartarised"),
            &[(0b10010, &ENTRY_UNTARTARIZED_9979924217571095451)],
        ),
        (
            UniCase::ascii("immobilises"),
            &[(0b10010, &ENTRY_IMMOBILIZES_6192137487727370549)],
        ),
        (
            UniCase::ascii("laborabilities"),
            &[(0b11001, &ENTRY_LABORABILITIES_7797372392120967556)],
        ),
        (
            UniCase::ascii("nonsensitised"),
            &[(0b10010, &ENTRY_NONSENSITIZED_16877012909978131488)],
        ),
        (
            UniCase::ascii("tailorisation"),
            &[(0b10010, &ENTRY_TAILORIZATION_15045235103886073598)],
        ),
        (
            UniCase::ascii("clamoured"),
            &[(0b11010, &ENTRY_CLAMORED_4631300413281563513)],
        ),
        (
            UniCase::ascii("pyrolysates"),
            &[(0b11010, &ENTRY_PYROLYZATES_6791890316899917756)],
        ),
        (
            UniCase::ascii("renormalising"),
            &[(0b10010, &ENTRY_RENORMALIZING_4696927106111124982)],
        ),
        (
            UniCase::ascii("disutilises"),
            &[(0b10010, &ENTRY_DISUTILIZES_8581123670870213073)],
        ),
        (
            UniCase::ascii("valvule"),
            &[(0b00001, &ENTRY_VALVULE_7068032189967732165)],
        ),
        (
            UniCase::ascii("tropicalises"),
            &[(0b10010, &ENTRY_TROPICALIZES_10180779904224473997)],
        ),
        (
            UniCase::ascii("bituminisations"),
            &[(0b10010, &ENTRY_BITUMINIZATIONS_4430255676913937183)],
        ),
        (
            UniCase::ascii("fiberfill"),
            &[(0b00001, &ENTRY_FIBERFILL_15892338090700624301)],
        ),
        (
            UniCase::ascii("sectionising"),
            &[(0b10010, &ENTRY_SECTIONIZING_5472076843239971417)],
        ),
        (
            UniCase::ascii("industrializes"),
            &[(0b01001, &ENTRY_INDUSTRIALIZES_108463817008379635)],
        ),
        (
            UniCase::ascii("metameriseds"),
            &[(0b10010, &ENTRY_METAMERIZEDS_4467995640688317236)],
        ),
        (
            UniCase::ascii("carbolised"),
            &[(0b10010, &ENTRY_CARBOLIZED_3610204407073437611)],
        ),
        (
            UniCase::ascii("paleogeographic"),
            &[(0b10001, &ENTRY_PALEOGEOGRAPHIC_7239153512084908161)],
        ),
        (
            UniCase::ascii("linge"),
            &[(0b00001, &ENTRY_LINGE_7553285674660467670)],
        ),
        (
            UniCase::ascii("pelletizer"),
            &[(0b01001, &ENTRY_PELLETIZER_17745386141239426126)],
        ),
        (
            UniCase::ascii("unneighbourly"),
            &[(0b11010, &ENTRY_UNNEIGHBORLY_14423135391726748415)],
        ),
        (
            UniCase::ascii("extravert"),
            &[(0b10011, &ENTRY_EXTROVERT_3459138457522989101)],
        ),
        (
            UniCase::ascii("cerebralises"),
            &[(0b10010, &ENTRY_CEREBRALIZES_14811698873620229158)],
        ),
        (
            UniCase::ascii("levigated"),
            &[(0b00001, &ENTRY_LEVIGATED_14877617934398376831)],
        ),
        (
            UniCase::ascii("milligramme"),
            &[(0b11010, &ENTRY_MILLIGRAM_16796984474169779303)],
        ),
        (
            UniCase::ascii("misrealises"),
            &[(0b10010, &ENTRY_MISREALIZES_6455083844071414450)],
        ),
        (
            UniCase::ascii("faradizations"),
            &[(0b01001, &ENTRY_FARADIZATIONS_4526439476664692216)],
        ),
        (
            UniCase::ascii("propretorial"),
            &[(0b00001, &ENTRY_PROPRETORIAL_4183494453271841116)],
        ),
        (
            UniCase::ascii("lithotritizing"),
            &[(0b01001, &ENTRY_LITHOTRITIZING_3557016990622667149)],
        ),
        (
            UniCase::ascii("temporisation"),
            &[(0b10010, &ENTRY_TEMPORIZATION_9268323585901486943)],
        ),
        (
            UniCase::ascii("oxidisable"),
            &[(0b10010, &ENTRY_OXIDIZABLE_13099591425208273704)],
        ),
        (
            UniCase::ascii("bicolourest"),
            &[(0b11010, &ENTRY_BICOLORREST_693010655310508411)],
        ),
        (
            UniCase::ascii("autoimmunisation"),
            &[(0b10010, &ENTRY_AUTOIMMUNIZATION_9708656153855152039)],
        ),
        (
            UniCase::ascii("matres"),
            &[(0b11010, &ENTRY_MATERS_3979439194038338784)],
        ),
        (
            UniCase::ascii("astronomize"),
            &[(0b01001, &ENTRY_ASTRONOMIZE_8434822243027737838)],
        ),
        (
            UniCase::ascii("semimineralised"),
            &[(0b10010, &ENTRY_SEMIMINERALIZED_16937456193304785591)],
        ),
        (
            UniCase::ascii("prefavorably"),
            &[(0b00001, &ENTRY_PREFAVORABLY_2906405353959131669)],
        ),
        (
            UniCase::ascii("legitimatize"),
            &[(0b01001, &ENTRY_LEGITIMATIZE_14030890652940162105)],
        ),
        (
            UniCase::ascii("repaganise"),
            &[(0b10010, &ENTRY_REPAGANIZE_12973755742278560404)],
        ),
        (
            UniCase::ascii("quarrellers"),
            &[(0b11010, &ENTRY_QUARRELERS_358900163381073241)],
        ),
        (
            UniCase::ascii("disrealize"),
            &[(0b01001, &ENTRY_DISREALIZE_6886884802512895754)],
        ),
        (
            UniCase::ascii("fedaries"),
            &[(0b00001, &ENTRY_FEDARIES_10652713739066961630)],
        ),
        (
            UniCase::ascii("tavernise"),
            &[(0b10010, &ENTRY_TAVERNIZE_11412342911846701308)],
        ),
        (
            UniCase::ascii("deoxidizer"),
            &[(0b01001, &ENTRY_DEOXIDIZER_11973963213903362992)],
        ),
        (
            UniCase::ascii("saccharises"),
            &[(0b10010, &ENTRY_SACCHARIZES_17004868231094363900)],
        ),
        (
            UniCase::ascii("sterilizability"),
            &[(0b01001, &ENTRY_STERILIZABILITY_15756429437692504074)],
        ),
        (
            UniCase::ascii("favourite"),
            &[(0b11010, &ENTRY_FAVORITE_2808981011176955343)],
        ),
        (
            UniCase::ascii("deodorisers"),
            &[(0b10010, &ENTRY_DEODORIZERS_7206686442131612842)],
        ),
        (
            UniCase::ascii("paraselenae"),
            &[(0b11010, &ENTRY_PARASELENE_14205012842021982883)],
        ),
        (
            UniCase::ascii("polarisability"),
            &[(0b10010, &ENTRY_POLARIZABILITY_2003936501471489904)],
        ),
        (
            UniCase::ascii("proletarianisations"),
            &[(0b10010, &ENTRY_PROLETARIANIZATIONS_18153332863179741779)],
        ),
        (
            UniCase::ascii("phylactolema"),
            &[(0b00001, &ENTRY_PHYLACTOLEMA_17387053296583525798)],
        ),
        (
            UniCase::ascii("prussianizes"),
            &[(0b01001, &ENTRY_PRUSSIANIZES_16592096312730648273)],
        ),
        (
            UniCase::ascii("dereligionises"),
            &[(0b10010, &ENTRY_DERELIGIONIZES_15734216747597028796)],
        ),
        (
            UniCase::ascii("athetized"),
            &[(0b01001, &ENTRY_ATHETIZED_9779500563027955411)],
        ),
        (
            UniCase::ascii("microminiaturizes"),
            &[(0b01001, &ENTRY_MICROMINIATURIZES_7333398841442349207)],
        ),
        (
            UniCase::ascii("dramatizers"),
            &[(0b01001, &ENTRY_DRAMATIZERS_17282413603035313323)],
        ),
        (
            UniCase::ascii("kaolinised"),
            &[(0b10010, &ENTRY_KAOLINIZED_9549498899357684926)],
        ),
        (
            UniCase::ascii("pulverisations"),
            &[(0b10010, &ENTRY_PULVERIZATIONS_14450827217528983318)],
        ),
        (
            UniCase::ascii("arborization"),
            &[(0b01001, &ENTRY_ARBORIZATION_9677792163286494747)],
        ),
        (
            UniCase::ascii("nitrogenised"),
            &[(0b10010, &ENTRY_NITROGENIZED_663379866855711530)],
        ),
        (
            UniCase::ascii("compartmentalisations"),
            &[(0b10010, &ENTRY_COMPARTMENTALIZATIONS_2073690646158683595)],
        ),
        (
            UniCase::ascii("unscrutinizeddest"),
            &[(0b01001, &ENTRY_UNSCRUTINIZEDDEST_16503621375052442349)],
        ),
        (
            UniCase::ascii("pseudographize"),
            &[(0b01001, &ENTRY_PSEUDOGRAPHIZE_5452057591678689737)],
        ),
        (
            UniCase::ascii("galvanisation"),
            &[(0b10010, &ENTRY_GALVANIZATION_5356855464894954705)],
        ),
        (
            UniCase::ascii("centerboard"),
            &[(0b00001, &ENTRY_CENTERBOARD_6663399917522410894)],
        ),
        (
            UniCase::ascii("mexicanise"),
            &[(0b10010, &ENTRY_MEXICANIZE_15398963488252123589)],
        ),
        (
            UniCase::ascii("hyperparasitize"),
            &[(0b01001, &ENTRY_HYPERPARASITIZE_7853126625657581368)],
        ),
        (
            UniCase::ascii("snivellings"),
            &[(0b11010, &ENTRY_SNIVELINGS_9742658510844280475)],
        ),
        (
            UniCase::ascii("secularizations"),
            &[(0b01001, &ENTRY_SECULARIZATIONS_18385656083748383194)],
        ),
        (
            UniCase::ascii("unstandardizedder"),
            &[(0b01001, &ENTRY_UNSTANDARDIZEDDER_3995682174766736068)],
        ),
        (
            UniCase::ascii("bedlamize"),
            &[(0b01001, &ENTRY_BEDLAMIZE_8032432031457666621)],
        ),
        (
            UniCase::ascii("unnitrogenizeddest"),
            &[(0b01001, &ENTRY_UNNITROGENIZEDDEST_14262521068869718443)],
        ),
        (
            UniCase::ascii("hostilise"),
            &[(0b10010, &ENTRY_HOSTILIZE_13783071968481819947)],
        ),
        (
            UniCase::ascii("ventriloquizing"),
            &[(0b01001, &ENTRY_VENTRILOQUIZING_16373058130648158850)],
        ),
        (
            UniCase::ascii("nectarise"),
            &[(0b10010, &ENTRY_NECTARIZE_9385124234314658628)],
        ),
        (
            UniCase::ascii("hypnopaedias"),
            &[(0b11010, &ENTRY_HYPNOPEDIAS_2021280433174594462)],
        ),
        (
            UniCase::ascii("mitreworts"),
            &[(0b11010, &ENTRY_MITERWORTS_2595793822662820807)],
        ),
        (
            UniCase::ascii("maximize"),
            &[(0b01001, &ENTRY_MAXIMIZE_14091219846433103895)],
        ),
        (
            UniCase::ascii("unlocalisabler"),
            &[(0b10010, &ENTRY_UNLOCALIZABLER_1057258441085295588)],
        ),
        (
            UniCase::ascii("universalises"),
            &[(0b10010, &ENTRY_UNIVERSALIZES_5744703348821395274)],
        ),
        (
            UniCase::ascii("cantonizations"),
            &[(0b01001, &ENTRY_CANTONIZATIONS_17246812416090811840)],
        ),
        (
            UniCase::ascii("haematopoietic"),
            &[(0b11010, &ENTRY_HEMATOPOIETIC_7321368675852188024)],
        ),
        (
            UniCase::ascii("chromatises"),
            &[(0b10010, &ENTRY_CHROMATIZES_8188945171625541176)],
        ),
        (
            UniCase::ascii("tractorizes"),
            &[(0b01001, &ENTRY_TRACTORIZES_5631147609434218207)],
        ),
        (
            UniCase::ascii("cholophaein"),
            &[(0b11010, &ENTRY_CHOLOPHEIN_3609148772555478472)],
        ),
        (
            UniCase::ascii("narcotizes"),
            &[(0b01001, &ENTRY_NARCOTIZES_4192091924295649919)],
        ),
        (
            UniCase::ascii("meloe"),
            &[(0b11010, &ENTRY_MELE_14922314763041738254)],
        ),
        (
            UniCase::ascii("cartelising"),
            &[(0b10010, &ENTRY_CARTELIZING_16082986042795613861)],
        ),
        (
            UniCase::ascii("haematein"),
            &[(0b11010, &ENTRY_HEMATEIN_15736414880744516603)],
        ),
        (
            UniCase::ascii("sovietisation"),
            &[(0b10010, &ENTRY_SOVIETIZATION_13205972349841767875)],
        ),
        (
            UniCase::ascii("communalising"),
            &[(0b10010, &ENTRY_COMMUNALIZING_8021518098437504841)],
        ),
        (
            UniCase::ascii("talmudises"),
            &[(0b10010, &ENTRY_TALMUDIZES_2392641621064217398)],
        ),
        (
            UniCase::ascii("safier"),
            &[(0b00001, &ENTRY_SAFIER_7130557169601659947)],
        ),
        (
            UniCase::ascii("eternises"),
            &[(0b10010, &ENTRY_ETERNIZES_13889836130672451566)],
        ),
        (
            UniCase::ascii("nebulisation"),
            &[(0b10010, &ENTRY_NEBULIZATION_7326585684837997543)],
        ),
        (
            UniCase::ascii("paraselene"),
            &[(0b00001, &ENTRY_PARASELENE_14205012842021982883)],
        ),
        (
            UniCase::ascii("agathodaemon"),
            &[(0b11010, &ENTRY_AGATHODEMON_1771853124296768685)],
        ),
        (
            UniCase::ascii("unfeudalize"),
            &[(0b01001, &ENTRY_UNFEUDALIZE_14691232336692814883)],
        ),
        (
            UniCase::ascii("sacralisations"),
            &[(0b10010, &ENTRY_SACRALIZATIONS_14811964160883679275)],
        ),
        (
            UniCase::ascii("gyrostabilisers"),
            &[(0b10010, &ENTRY_GYROSTABILIZERS_4574473259133787027)],
        ),
        (
            UniCase::ascii("disboweled"),
            &[(0b00001, &ENTRY_DISBOWELED_8124420063056832999)],
        ),
        (
            UniCase::ascii("unequalized"),
            &[(0b01001, &ENTRY_UNEQUALIZED_11229527678135642111)],
        ),
        (
            UniCase::ascii("patined"),
            &[(0b00001, &ENTRY_PATINED_13394457292336487862)],
        ),
        (
            UniCase::ascii("cognizableness"),
            &[(0b01001, &ENTRY_COGNIZABLENESS_16476592524827512160)],
        ),
        (
            UniCase::ascii("palaeontological"),
            &[(0b10010, &ENTRY_PALEONTOLOGICAL_12663535461634576551)],
        ),
        (
            UniCase::ascii("adulterizing"),
            &[(0b01001, &ENTRY_ADULTERIZING_3717589244256498605)],
        ),
        (
            UniCase::ascii("evolutionise"),
            &[(0b10010, &ENTRY_EVOLUTIONIZE_8517112820891861723)],
        ),
        (
            UniCase::ascii("amoeban"),
            &[(0b11010, &ENTRY_AMEBAN_5277068494503541064)],
        ),
        (
            UniCase::ascii("phagedaenous"),
            &[(0b11010, &ENTRY_PHAGEDENOUS_1804302093376783588)],
        ),
        (
            UniCase::ascii("notarised"),
            &[(0b11010, &ENTRY_NOTARIZED_2113894921750376734)],
        ),
        (
            UniCase::ascii("entomologise"),
            &[(0b10010, &ENTRY_ENTOMOLOGIZE_12930471317891860313)],
        ),
        (
            UniCase::ascii("archaeocyte"),
            &[(0b11010, &ENTRY_ARCHEOCYTE_544989770193462231)],
        ),
        (
            UniCase::ascii("factorize"),
            &[(0b01001, &ENTRY_FACTORIZE_8969914975304697583)],
        ),
        (
            UniCase::ascii("polioencephalitis"),
            &[(0b11010, &ENTRY_POLIENCEPHALITIS_172737026792843669)],
        ),
        (
            UniCase::ascii("unreorganiseddest"),
            &[(0b10010, &ENTRY_UNREORGANIZEDDEST_16921729744186143176)],
        ),
        (
            UniCase::ascii("unnationalizeddest"),
            &[(0b01001, &ENTRY_UNNATIONALIZEDDEST_6627375631914479221)],
        ),
        (
            UniCase::ascii("immunized"),
            &[(0b01001, &ENTRY_IMMUNIZED_12890937714947487224)],
        ),
        (
            UniCase::ascii("dissocialize"),
            &[(0b01001, &ENTRY_DISSOCIALIZE_15635530793606336711)],
        ),
        (
            UniCase::ascii("dialogises"),
            &[(0b10010, &ENTRY_DIALOGIZES_10946689184118338197)],
        ),
        (
            UniCase::ascii("aestivation"),
            &[(0b11010, &ENTRY_ESTIVATION_970593505059854945)],
        ),
        (
            UniCase::ascii("hyphenised"),
            &[(0b10010, &ENTRY_HYPHENIZED_11632374625403992542)],
        ),
        (
            UniCase::ascii("proctorises"),
            &[(0b10010, &ENTRY_PROCTORIZES_5348616729395822128)],
        ),
        (
            UniCase::ascii("domine"),
            &[(0b00001, &ENTRY_DOMINE_6107407794990069253)],
        ),
        (
            UniCase::ascii("ionizable"),
            &[(0b01001, &ENTRY_IONIZABLE_16754526582239461220)],
        ),
        (
            UniCase::ascii("curricularizations"),
            &[(0b01001, &ENTRY_CURRICULARIZATIONS_8190097899978040825)],
        ),
        (
            UniCase::ascii("estheticians"),
            &[(0b01001, &ENTRY_ESTHETICIANS_4428473313020471578)],
        ),
        (
            UniCase::ascii("myocele"),
            &[(0b00001, &ENTRY_MYOCELE_6155543281988825635)],
        ),
        (
            UniCase::ascii("hormonize"),
            &[(0b01001, &ENTRY_HORMONIZE_16402712449126296970)],
        ),
        (
            UniCase::ascii("unmechanises"),
            &[(0b10010, &ENTRY_UNMECHANIZES_165760147883759220)],
        ),
        (
            UniCase::ascii("civilianization"),
            &[(0b01001, &ENTRY_CIVILIANIZATION_17575505866978524289)],
        ),
        (
            UniCase::ascii("amorphize"),
            &[(0b01001, &ENTRY_AMORPHIZE_15516090808530900584)],
        ),
        (
            UniCase::ascii("anhydridize"),
            &[(0b01001, &ENTRY_ANHYDRIDIZE_15475133187948388972)],
        ),
        (
            UniCase::ascii("puebloise"),
            &[(0b10010, &ENTRY_PUEBLOIZE_4789148533035124772)],
        ),
        (
            UniCase::ascii("jeopardizing"),
            &[(0b01001, &ENTRY_JEOPARDIZING_17208030805715513372)],
        ),
        (
            UniCase::ascii("unmobilizeddest"),
            &[(0b01001, &ENTRY_UNMOBILIZEDDEST_16430132456615956501)],
        ),
        (
            UniCase::ascii("sentimentalized"),
            &[(0b01001, &ENTRY_SENTIMENTALIZED_7395272655741592803)],
        ),
        (
            UniCase::ascii("idiotises"),
            &[(0b10010, &ENTRY_IDIOTIZES_7580197157055076168)],
        ),
        (
            UniCase::ascii("enigmatise"),
            &[(0b10010, &ENTRY_ENIGMATIZE_10416979299826385433)],
        ),
        (
            UniCase::ascii("favoritism"),
            &[(0b11001, &ENTRY_FAVORITISM_14860734505967533306)],
        ),
        (
            UniCase::ascii("formalizable"),
            &[(0b01001, &ENTRY_FORMALIZABLE_6664723737959773302)],
        ),
        (
            UniCase::ascii("epigrammatizes"),
            &[(0b01001, &ENTRY_EPIGRAMMATIZES_9870871179457908060)],
        ),
        (
            UniCase::ascii("epigrammatizer"),
            &[(0b01001, &ENTRY_EPIGRAMMATIZER_202382434686912143)],
        ),
        (
            UniCase::ascii("communalized"),
            &[(0b01001, &ENTRY_COMMUNALIZED_8414107067770377657)],
        ),
        (
            UniCase::ascii("particularises"),
            &[(0b10010, &ENTRY_PARTICULARIZES_3435670524070905736)],
        ),
        (
            UniCase::ascii("fractionalizes"),
            &[(0b01001, &ENTRY_FRACTIONALIZES_5842077662678248264)],
        ),
        (
            UniCase::ascii("sensualisations"),
            &[(0b10010, &ENTRY_SENSUALIZATIONS_4903697434091196616)],
        ),
        (
            UniCase::ascii("fascistising"),
            &[(0b10010, &ENTRY_FASCISTIZING_14842848351094053038)],
        ),
        (
            UniCase::ascii("arianised"),
            &[(0b10010, &ENTRY_ARIANIZED_1259509742119549714)],
        ),
        (
            UniCase::ascii("caponized"),
            &[(0b01001, &ENTRY_CAPONIZED_14836958589299432160)],
        ),
        (
            UniCase::ascii("materialization"),
            &[(0b01001, &ENTRY_MATERIALIZATION_5296659211080369904)],
        ),
        (
            UniCase::ascii("communalisation"),
            &[(0b10010, &ENTRY_COMMUNALIZATION_1354902119947113774)],
        ),
        (
            UniCase::ascii("odorlessest"),
            &[(0b11001, &ENTRY_ODORLESSEST_1630943358374016605)],
        ),
        (
            UniCase::ascii("labourist"),
            &[(0b11010, &ENTRY_LABORIST_4404212966525177578)],
        ),
        (
            UniCase::ascii("authorisable"),
            &[(0b10010, &ENTRY_AUTHORIZABLE_5231844717756889861)],
        ),
        (
            UniCase::ascii("unsentimentalises"),
            &[(0b10010, &ENTRY_UNSENTIMENTALIZES_9475174647404255643)],
        ),
        (
            UniCase::ascii("yoghourts"),
            &[(0b10010, &ENTRY_YOGURTS_14006847350082938741)],
        ),
        (
            UniCase::ascii("scenarizes"),
            &[(0b01001, &ENTRY_SCENARIZES_843838764401688514)],
        ),
        (
            UniCase::ascii("unoxidized"),
            &[(0b01001, &ENTRY_UNOXIDIZED_9470542236784645015)],
        ),
        (
            UniCase::ascii("deoxygenising"),
            &[(0b10010, &ENTRY_DEOXYGENIZING_6445979304009334071)],
        ),
        (
            UniCase::ascii("crystalizing"),
            &[(0b00001, &ENTRY_CRYSTALLIZING_1947916141166292087)],
        ),
        (
            UniCase::ascii("exteriorized"),
            &[(0b01001, &ENTRY_EXTERIORIZED_2593224941672461767)],
        ),
        (
            UniCase::ascii("defeudalised"),
            &[(0b10010, &ENTRY_DEFEUDALIZED_10926320617236271428)],
        ),
        (
            UniCase::ascii("civilisationals"),
            &[(0b10010, &ENTRY_CIVILIZATIONALS_16890543284368506921)],
        ),
        (
            UniCase::ascii("caponises"),
            &[(0b10010, &ENTRY_CAPONIZES_8415080645445299415)],
        ),
        (
            UniCase::ascii("unbrutises"),
            &[(0b10010, &ENTRY_UNBRUTIZES_12365008004715490849)],
        ),
        (
            UniCase::ascii("unmonopolizedder"),
            &[(0b01001, &ENTRY_UNMONOPOLIZEDDER_367444066669166581)],
        ),
        (
            UniCase::ascii("paleohydrography"),
            &[(0b10001, &ENTRY_PALEOHYDROGRAPHY_16923732770996851993)],
        ),
        (
            UniCase::ascii("rhotacise"),
            &[(0b10010, &ENTRY_RHOTACIZE_2196984425576687851)],
        ),
        (
            UniCase::ascii("sultanize"),
            &[(0b01001, &ENTRY_SULTANIZE_4736867272905083425)],
        ),
        (
            UniCase::ascii("malodour"),
            &[(0b11010, &ENTRY_MALODOR_1230117012999961238)],
        ),
        (
            UniCase::ascii("dichotomized"),
            &[(0b01001, &ENTRY_DICHOTOMIZED_11469969501387954088)],
        ),
        (
            UniCase::ascii("wer"),
            &[(0b00001, &ENTRY_WER_15853599801760131986)],
        ),
        (
            UniCase::ascii("detribalisations"),
            &[(0b10010, &ENTRY_DETRIBALIZATIONS_11756828771994817312)],
        ),
        (
            UniCase::ascii("uncivilises"),
            &[(0b10010, &ENTRY_UNCIVILIZES_4114315705302110845)],
        ),
        (
            UniCase::ascii("civilizer"),
            &[(0b01001, &ENTRY_CIVILIZER_6543816336610065762)],
        ),
        (
            UniCase::ascii("categorising"),
            &[(0b10010, &ENTRY_CATEGORIZING_961096799238536775)],
        ),
        (
            UniCase::ascii("restandardisation"),
            &[(0b10010, &ENTRY_RESTANDARDIZATION_1125896047095372970)],
        ),
        (
            UniCase::ascii("anticentralization"),
            &[(0b01001, &ENTRY_ANTICENTRALIZATION_14344770334712817786)],
        ),
        (
            UniCase::ascii("culturizes"),
            &[(0b01001, &ENTRY_CULTURIZES_8371845703179033846)],
        ),
        (
            UniCase::ascii("hyperpnea"),
            &[(0b10001, &ENTRY_HYPERPNEA_12342432255421507220)],
        ),
        (
            UniCase::ascii("victimised"),
            &[(0b10010, &ENTRY_VICTIMIZED_12606813743201188153)],
        ),
        (
            UniCase::ascii("uncolorablest"),
            &[(0b00001, &ENTRY_UNCOLORABLEST_7640890717461053308)],
        ),
        (
            UniCase::ascii("clangours"),
            &[(0b11010, &ENTRY_CLANGORS_14016497850837852764)],
        ),
        (
            UniCase::ascii("tyreos"),
            &[(0b00001, &ENTRY_TYROS_4063138644213636346)],
        ),
        (
            UniCase::ascii("cananean"),
            &[(0b00001, &ENTRY_CANANEAN_5897518141290055149)],
        ),
        (
            UniCase::ascii("comprehensivised"),
            &[(0b10010, &ENTRY_COMPREHENSIVIZED_2933839517192572218)],
        ),
        (
            UniCase::ascii("academising"),
            &[(0b10010, &ENTRY_ACADEMIZING_4383983952783387022)],
        ),
        (
            UniCase::ascii("nere"),
            &[(0b11010, &ENTRY_NEER_16355605982802851825)],
        ),
        (
            UniCase::ascii("malodorousness"),
            &[(0b00001, &ENTRY_MALODOROUSNESS_6015133417028203806)],
        ),
        (
            UniCase::ascii("overcivilisation"),
            &[(0b10010, &ENTRY_OVERCIVILIZATION_1403057627715817017)],
        ),
        (
            UniCase::ascii("vigor"),
            &[(0b11001, &ENTRY_VIGOR_4255508283031723378)],
        ),
        (
            UniCase::ascii("colourers"),
            &[(0b11010, &ENTRY_COLORERS_5523036624009318320)],
        ),
        (
            UniCase::ascii("canonicalises"),
            &[(0b10010, &ENTRY_CANONICALIZES_18227657368670160690)],
        ),
        (
            UniCase::ascii("melodramatises"),
            &[(0b10010, &ENTRY_MELODRAMATIZES_1590401015443283848)],
        ),
        (
            UniCase::ascii("dispapalizes"),
            &[(0b01001, &ENTRY_DISPAPALIZES_15889961525847775881)],
        ),
        (
            UniCase::ascii("mediterraneanizes"),
            &[(0b01001, &ENTRY_MEDITERRANEANIZES_4936465023428726899)],
        ),
        (
            UniCase::ascii("intellectualisations"),
            &[(0b10010, &ENTRY_INTELLECTUALIZATIONS_3199889427953063623)],
        ),
        (
            UniCase::ascii("philosophisations"),
            &[(0b10010, &ENTRY_PHILOSOPHIZATIONS_1471954898649055414)],
        ),
        (
            UniCase::ascii("sexualized"),
            &[(0b01001, &ENTRY_SEXUALIZED_17516220740309805973)],
        ),
        (
            UniCase::ascii("tractorization"),
            &[(0b01001, &ENTRY_TRACTORIZATION_3823073726188841416)],
        ),
        (
            UniCase::ascii("personising"),
            &[(0b10010, &ENTRY_PERSONIZING_14903686723706359501)],
        ),
        (
            UniCase::ascii("burglarized"),
            &[(0b01001, &ENTRY_BURGLARIZED_12847959995142931775)],
        ),
        (
            UniCase::ascii("dishonourablier"),
            &[(0b11010, &ENTRY_DISHONORABLIER_8450606157745671431)],
        ),
        (
            UniCase::ascii("fractionizing"),
            &[(0b01001, &ENTRY_FRACTIONIZING_15905405027559811921)],
        ),
        (
            UniCase::ascii("candour"),
            &[(0b11010, &ENTRY_CANDOR_14808094384111961913)],
        ),
        (
            UniCase::ascii("chromicise"),
            &[(0b10010, &ENTRY_CHROMICIZE_2411849466836240319)],
        ),
        (
            UniCase::ascii("powderisers"),
            &[(0b10010, &ENTRY_POWDERIZERS_7366910102231696330)],
        ),
        (
            UniCase::ascii("labouringlier"),
            &[(0b11010, &ENTRY_LABORINGLIER_13113382106188708192)],
        ),
        (
            UniCase::ascii("superhumanize"),
            &[(0b01001, &ENTRY_SUPERHUMANIZE_15633115389662702814)],
        ),
        (
            UniCase::ascii("unsectarianize"),
            &[(0b01001, &ENTRY_UNSECTARIANIZE_8896277406677200944)],
        ),
        (
            UniCase::ascii("archaeol"),
            &[(0b11010, &ENTRY_ARCHEOL_1621301161575668294)],
        ),
        (
            UniCase::ascii("revitalizing"),
            &[(0b01001, &ENTRY_REVITALIZING_16112731945721210438)],
        ),
        (
            UniCase::ascii("antithesise"),
            &[(0b10010, &ENTRY_ANTITHESIZE_6914205044378767893)],
        ),
        (
            UniCase::ascii("nodalize"),
            &[(0b01001, &ENTRY_NODALIZE_12159557011270389807)],
        ),
        (
            UniCase::ascii("memorializer"),
            &[(0b01001, &ENTRY_MEMORIALIZER_188024871039509941)],
        ),
        (
            UniCase::ascii("unicolourous"),
            &[(0b11010, &ENTRY_UNICOLOROUS_9217819624867642093)],
        ),
        (
            UniCase::ascii("effeminatise"),
            &[(0b10010, &ENTRY_EFFEMINATIZE_6301232153675654071)],
        ),
        (
            UniCase::ascii("botanised"),
            &[(0b10010, &ENTRY_BOTANIZED_6978246195480656091)],
        ),
        (
            UniCase::ascii("proletarianizations"),
            &[(0b01001, &ENTRY_PROLETARIANIZATIONS_18153332863179741779)],
        ),
        (
            UniCase::ascii("prelatizing"),
            &[(0b01001, &ENTRY_PRELATIZING_14962226743591213307)],
        ),
        (
            UniCase::ascii("editorializations"),
            &[(0b01001, &ENTRY_EDITORIALIZATIONS_12319328368566597913)],
        ),
        (
            UniCase::ascii("copolymerize"),
            &[(0b01001, &ENTRY_COPOLYMERIZE_4215053249879524882)],
        ),
        (
            UniCase::ascii("uncivilizables"),
            &[(0b01001, &ENTRY_UNCIVILIZABLES_5534726098220309871)],
        ),
        (
            UniCase::ascii("decarbonises"),
            &[(0b10010, &ENTRY_DECARBONIZES_16627154206935494807)],
        ),
        (
            UniCase::ascii("vascularization"),
            &[(0b01001, &ENTRY_VASCULARIZATION_7798251772115817237)],
        ),
        (
            UniCase::ascii("theorized"),
            &[(0b01001, &ENTRY_THEORIZED_12643356280684289637)],
        ),
        (
            UniCase::ascii("radicalised"),
            &[(0b10010, &ENTRY_RADICALIZED_970968663725575990)],
        ),
        (
            UniCase::ascii("undramatizabler"),
            &[(0b01001, &ENTRY_UNDRAMATIZABLER_17183761443356610462)],
        ),
        (
            UniCase::ascii("ower"),
            &[(0b00001, &ENTRY_OWER_3833680922718495358)],
        ),
        (
            UniCase::ascii("courtin"),
            &[(0b11010, &ENTRY_CORTIN_6028563342284786375)],
        ),
        (
            UniCase::ascii("compartmentalise"),
            &[(0b10010, &ENTRY_COMPARTMENTALIZE_6316599424281105903)],
        ),
        (
            UniCase::ascii("hypoxemias"),
            &[(0b10001, &ENTRY_HYPOXEMIAS_16532743875103109491)],
        ),
        (
            UniCase::ascii("regularized"),
            &[(0b01001, &ENTRY_REGULARIZED_16522280649650166951)],
        ),
        (
            UniCase::ascii("willful"),
            &[(0b01001, &ENTRY_WILLFUL_7624543375604831885)],
        ),
        (
            UniCase::ascii("canaled"),
            &[(0b00001, &ENTRY_CANALED_1837439099016219610)],
        ),
        (
            UniCase::ascii("decolourizers"),
            &[(0b01000, &ENTRY_DECOLORIZERS_2577270439983901494)],
        ),
        (
            UniCase::ascii("amorists"),
            &[(0b00001, &ENTRY_AMORISTS_6019660879632735851)],
        ),
        (
            UniCase::ascii("intercolonizations"),
            &[(0b01001, &ENTRY_INTERCOLONIZATIONS_1193684945774928129)],
        ),
        (
            UniCase::ascii("latinizes"),
            &[(0b01001, &ENTRY_LATINIZES_12697197510060274526)],
        ),
        (
            UniCase::ascii("colourability"),
            &[(0b11010, &ENTRY_COLORABILITY_3833618249244001959)],
        ),
        (
            UniCase::ascii("unlaboreddest"),
            &[(0b00001, &ENTRY_UNLABOREDDEST_1362587359789372781)],
        ),
        (
            UniCase::ascii("paraeneses"),
            &[(0b11010, &ENTRY_PARENESES_13856725007668956765)],
        ),
        (
            UniCase::ascii("mobilizablest"),
            &[(0b01001, &ENTRY_MOBILIZABLEST_15444054356148134406)],
        ),
        (
            UniCase::ascii("curarises"),
            &[(0b10010, &ENTRY_CURARIZES_11507088447457007709)],
        ),
        (
            UniCase::ascii("ungelatiniseds"),
            &[(0b10010, &ENTRY_UNGELATINIZEDS_16589417897484720231)],
        ),
        (
            UniCase::ascii("unpersonalizing"),
            &[(0b01001, &ENTRY_UNPERSONALIZING_15562446084747354495)],
        ),
        (
            UniCase::ascii("demagnetizablest"),
            &[(0b01001, &ENTRY_DEMAGNETIZABLEST_231408157539452152)],
        ),
        (
            UniCase::ascii("womanizers"),
            &[(0b01001, &ENTRY_WOMANIZERS_9259673447489824653)],
        ),
        (
            UniCase::ascii("vitrioliser"),
            &[(0b10010, &ENTRY_VITRIOLIZER_1822506942241343764)],
        ),
        (
            UniCase::ascii("civilizationalest"),
            &[(0b01001, &ENTRY_CIVILIZATIONALEST_8468211002452117483)],
        ),
        (
            UniCase::ascii("amygdalae"),
            &[(0b11010, &ENTRY_AMYGDALE_9445312936529667739)],
        ),
        (
            UniCase::ascii("libelers"),
            &[(0b00001, &ENTRY_LIBELERS_7579436350106243412)],
        ),
        (
            UniCase::ascii("subvitalizedder"),
            &[(0b01001, &ENTRY_SUBVITALIZEDDER_6038599483589110897)],
        ),
        (
            UniCase::ascii("unhumoured"),
            &[(0b11010, &ENTRY_UNHUMORED_18084787621051692653)],
        ),
        (
            UniCase::ascii("theatregoers"),
            &[(0b11010, &ENTRY_THEATERGOERS_8549242292576792477)],
        ),
        (
            UniCase::ascii("semitize"),
            &[(0b01001, &ENTRY_SEMITIZE_941534843473568569)],
        ),
        (
            UniCase::ascii("recognizabler"),
            &[(0b01001, &ENTRY_RECOGNIZABLER_4175265933374548777)],
        ),
        (
            UniCase::ascii("exorcisement"),
            &[(0b10010, &ENTRY_EXORCIZEMENT_13755936147137266553)],
        ),
        (
            UniCase::ascii("burglarizes"),
            &[(0b01001, &ENTRY_BURGLARIZES_9695092733654355865)],
        ),
        (
            UniCase::ascii("marginalized"),
            &[(0b01001, &ENTRY_MARGINALIZED_2250429301168529865)],
        ),
        (
            UniCase::ascii("teniacide"),
            &[(0b00001, &ENTRY_TENIACIDE_8144045073011901293)],
        ),
        (
            UniCase::ascii("lysogenisation"),
            &[(0b10010, &ENTRY_LYSOGENIZATION_11026822618685223605)],
        ),
        (
            UniCase::ascii("quantise"),
            &[(0b10010, &ENTRY_QUANTIZE_11931499095330665012)],
        ),
        (
            UniCase::ascii("maderizations"),
            &[(0b01001, &ENTRY_MADERIZATIONS_7073401233591816042)],
        ),
        (
            UniCase::ascii("gelatinisabilities"),
            &[(0b10010, &ENTRY_GELATINIZABILITIES_748271501802959782)],
        ),
        (
            UniCase::ascii("customization"),
            &[(0b01001, &ENTRY_CUSTOMIZATION_453875871734424262)],
        ),
        (
            UniCase::ascii("dissocialises"),
            &[(0b10010, &ENTRY_DISSOCIALIZES_15997318284457012428)],
        ),
        (
            UniCase::ascii("undercolors"),
            &[(0b00001, &ENTRY_UNDERCOLORS_6190629777654495448)],
        ),
        (
            UniCase::ascii("parametrized"),
            &[(0b01001, &ENTRY_PARAMETRIZED_17784422469128630511)],
        ),
        (
            UniCase::ascii("infinitises"),
            &[(0b10010, &ENTRY_INFINITIZES_16900614083188680149)],
        ),
        (
            UniCase::ascii("collectivise"),
            &[(0b10010, &ENTRY_COLLECTIVIZE_18197662740300515669)],
        ),
        (
            UniCase::ascii("intraorganisations"),
            &[(0b10010, &ENTRY_INTRAORGANIZATIONS_1216554799512649042)],
        ),
        (
            UniCase::ascii("unhypnotizes"),
            &[(0b01001, &ENTRY_UNHYPNOTIZES_11386726980321406907)],
        ),
        (
            UniCase::ascii("territorialised"),
            &[(0b10010, &ENTRY_TERRITORIALIZED_18010704841888125903)],
        ),
        (
            UniCase::ascii("patronized"),
            &[(0b01001, &ENTRY_PATRONIZED_2861263128246082573)],
        ),
        (
            UniCase::ascii("tillfourd"),
            &[(0b11010, &ENTRY_TILLFORD_13927963203563990910)],
        ),
        (
            UniCase::ascii("colourises"),
            &[(0b10010, &ENTRY_COLORIZES_12579061677034347790)],
        ),
        (
            UniCase::ascii("unhydrolyzed"),
            &[(0b00001, &ENTRY_UNHYDROLYZED_1605839220238398471)],
        ),
        (
            UniCase::ascii("dentalize"),
            &[(0b01001, &ENTRY_DENTALIZE_13079577939938126746)],
        ),
        (
            UniCase::ascii("ethicization"),
            &[(0b01001, &ENTRY_ETHICIZATION_7982960618336992609)],
        ),
        (
            UniCase::ascii("gaelicised"),
            &[(0b10010, &ENTRY_GAELICIZED_9134821684445081472)],
        ),
        (
            UniCase::ascii("mannerizes"),
            &[(0b01001, &ENTRY_MANNERIZES_11335051494000116458)],
        ),
        (
            UniCase::ascii("nonfulfillment"),
            &[(0b00001, &ENTRY_NONFULFILLMENT_18150430088534928286)],
        ),
        (
            UniCase::ascii("preposter"),
            &[(0b00001, &ENTRY_PREPOSTER_9979045838450867710)],
        ),
        (
            UniCase::ascii("nonpolarizables"),
            &[(0b01001, &ENTRY_NONPOLARIZABLES_1893837066131069642)],
        ),
        (
            UniCase::ascii("criticizable"),
            &[(0b01001, &ENTRY_CRITICIZABLE_11161073204477833540)],
        ),
        (
            UniCase::ascii("tranquillizingly"),
            &[(0b01001, &ENTRY_TRANQUILLIZINGLY_14381964317822750722)],
        ),
        (
            UniCase::ascii("preformative"),
            &[(0b11010, &ENTRY_PERFORMATIVE_11653583321194826668)],
        ),
        (
            UniCase::ascii("parrotises"),
            &[(0b10010, &ENTRY_PARROTIZES_9482751000492529167)],
        ),
        (
            UniCase::ascii("depersonalisation"),
            &[(0b10010, &ENTRY_DEPERSONALIZATION_16899026211036624682)],
        ),
        (
            UniCase::ascii("peize"),
            &[(0b01001, &ENTRY_PEIZE_885907093702515829)],
        ),
        (
            UniCase::ascii("unindividualizes"),
            &[(0b01001, &ENTRY_UNINDIVIDUALIZES_4576420283626985656)],
        ),
        (
            UniCase::ascii("unpersonalising"),
            &[(0b10010, &ENTRY_UNPERSONALIZING_15562446084747354495)],
        ),
        (
            UniCase::ascii("philosophizations"),
            &[(0b01001, &ENTRY_PHILOSOPHIZATIONS_1471954898649055414)],
        ),
        (
            UniCase::ascii("illegalising"),
            &[(0b10010, &ENTRY_ILLEGALIZING_14859202189889876673)],
        ),
        (
            UniCase::ascii("ozonising"),
            &[(0b10010, &ENTRY_OZONIZING_4927916636257465073)],
        ),
        (
            UniCase::ascii("phonemicizing"),
            &[(0b01001, &ENTRY_PHONEMICIZING_15981242182632342378)],
        ),
        (
            UniCase::ascii("flavorsomer"),
            &[(0b11001, &ENTRY_FLAVORSOMER_14092054357849095537)],
        ),
        (
            UniCase::ascii("diarized"),
            &[(0b01001, &ENTRY_DIARIZED_15375708985365837815)],
        ),
        (
            UniCase::ascii("chlorinized"),
            &[(0b01001, &ENTRY_CHLORINIZED_17584986266499508813)],
        ),
        (
            UniCase::ascii("venalization"),
            &[(0b01001, &ENTRY_VENALIZATION_2122570152538799298)],
        ),
        (
            UniCase::ascii("colorless"),
            &[(0b11001, &ENTRY_COLORLESS_15335426167000546767)],
        ),
        (
            UniCase::ascii("greekize"),
            &[(0b01001, &ENTRY_GREEKIZE_15314566857028275164)],
        ),
        (
            UniCase::ascii("deaminize"),
            &[(0b01001, &ENTRY_DEAMINIZE_18302767805033719686)],
        ),
        (
            UniCase::ascii("desexualizes"),
            &[(0b01001, &ENTRY_DESEXUALIZES_12483266755535786660)],
        ),
        (
            UniCase::ascii("decolorization"),
            &[(0b00001, &ENTRY_DECOLORIZATION_9440321833606051398)],
        ),
        (
            UniCase::ascii("sensualized"),
            &[(0b01001, &ENTRY_SENSUALIZED_5812075572460333798)],
        ),
        (
            UniCase::ascii("peises"),
            &[(0b10010, &ENTRY_PEIZES_2190131057773292627)],
        ),
        (
            UniCase::ascii("northernized"),
            &[(0b01001, &ENTRY_NORTHERNIZED_10171965562670427336)],
        ),
        (
            UniCase::ascii("unphosphatizeddest"),
            &[(0b01001, &ENTRY_UNPHOSPHATIZEDDEST_7712221667803666231)],
        ),
        (
            UniCase::ascii("vectorisering"),
            &[(0b10010, &ENTRY_VECTORIZERING_15878663610053146444)],
        ),
        (
            UniCase::ascii("lichenisations"),
            &[(0b10010, &ENTRY_LICHENIZATIONS_229879429336509734)],
        ),
        (
            UniCase::ascii("paralysations"),
            &[(0b11010, &ENTRY_PARALYZATIONS_1774275609038042526)],
        ),
        (
            UniCase::ascii("paedophilic"),
            &[(0b11010, &ENTRY_PEDOPHILIC_10586175930831437217)],
        ),
        (
            UniCase::ascii("nondialysings"),
            &[(0b11010, &ENTRY_NONDIALYZINGS_1819109722847384802)],
        ),
        (
            UniCase::ascii("resymbolises"),
            &[(0b10010, &ENTRY_RESYMBOLIZES_15380238287856922249)],
        ),
        (
            UniCase::ascii("chloroformization"),
            &[(0b01001, &ENTRY_CHLOROFORMIZATION_18266136341140668534)],
        ),
        (
            UniCase::ascii("triangularized"),
            &[(0b01001, &ENTRY_TRIANGULARIZED_8399601922283134135)],
        ),
        (
            UniCase::ascii("parenthesize"),
            &[(0b01001, &ENTRY_PARENTHESIZE_14226036285596216236)],
        ),
        (
            UniCase::ascii("pharmacopeial"),
            &[(0b00001, &ENTRY_PHARMACOPOEIAL_11804050835567169007)],
        ),
        (
            UniCase::ascii("tranquillisers"),
            &[(0b11010, &ENTRY_TRANQUILIZERS_17103334183302096096)],
        ),
        (
            UniCase::ascii("pseudocoele"),
            &[(0b11010, &ENTRY_PSEUDOCELE_16415452007409564004)],
        ),
        (
            UniCase::ascii("moralisation"),
            &[(0b10010, &ENTRY_MORALIZATION_10080916313324833740)],
        ),
        (
            UniCase::ascii("utilisability"),
            &[(0b10010, &ENTRY_UTILIZABILITY_8225222995731560442)],
        ),
        (
            UniCase::ascii("characterizablest"),
            &[(0b01001, &ENTRY_CHARACTERIZABLEST_13029951397962650520)],
        ),
        (
            UniCase::ascii("micropalaeontologies"),
            &[(0b11010, &ENTRY_MICROPALEONTOLOGIES_15673084178324778221)],
        ),
        (
            UniCase::ascii("unsentimentalised"),
            &[(0b10010, &ENTRY_UNSENTIMENTALIZED_6565195653528439940)],
        ),
        (
            UniCase::ascii("prelabours"),
            &[(0b11010, &ENTRY_PRELABORS_17252519264142630543)],
        ),
        (
            UniCase::ascii("recoloring"),
            &[(0b10001, &ENTRY_RECOLORING_6696403137875712708)],
        ),
        (
            UniCase::ascii("unmonopolized"),
            &[(0b01001, &ENTRY_UNMONOPOLIZED_15103252142985776491)],
        ),
        (
            UniCase::ascii("honorableness"),
            &[(0b11001, &ENTRY_HONORABLENESS_11259768724529598124)],
        ),
        (
            UniCase::ascii("decarbonizer"),
            &[(0b01001, &ENTRY_DECARBONIZER_7249394058399586099)],
        ),
        (
            UniCase::ascii("enamours"),
            &[(0b11010, &ENTRY_ENAMORS_9636937238080184741)],
        ),
        (
            UniCase::ascii("fertilise"),
            &[(0b10010, &ENTRY_FERTILIZE_8254091234870358890)],
        ),
        (
            UniCase::ascii("parochialization"),
            &[(0b01001, &ENTRY_PAROCHIALIZATION_9992801911204982717)],
        ),
        (
            UniCase::ascii("haussmannise"),
            &[(0b10010, &ENTRY_HAUSSMANNIZE_1750956549415927085)],
        ),
        (
            UniCase::ascii("preinitialising"),
            &[(0b10010, &ENTRY_PREINITIALIZING_12725446901089230467)],
        ),
        (
            UniCase::ascii("defenselesser"),
            &[(0b00001, &ENTRY_DEFENSELESSER_14429190642942612093)],
        ),
        (
            UniCase::ascii("sublimize"),
            &[(0b01001, &ENTRY_SUBLIMIZE_8185998513196337857)],
        ),
        (
            UniCase::ascii("unrumoredder"),
            &[(0b00001, &ENTRY_UNRUMOREDDER_1235386211719339229)],
        ),
        (
            UniCase::ascii("hemodynamics"),
            &[(0b10001, &ENTRY_HEMODYNAMICS_15802810674260006804)],
        ),
        (
            UniCase::ascii("individualizer"),
            &[(0b01001, &ENTRY_INDIVIDUALIZER_4182762615893522554)],
        ),
        (
            UniCase::ascii("defedation"),
            &[(0b10001, &ENTRY_DEFEDATION_1250124429421953221)],
        ),
        (
            UniCase::ascii("curricularisation"),
            &[(0b10010, &ENTRY_CURRICULARIZATION_17949948352689251703)],
        ),
        (
            UniCase::ascii("championizes"),
            &[(0b01001, &ENTRY_CHAMPIONIZES_1300772143294053091)],
        ),
        (
            UniCase::ascii("electrolyse"),
            &[(0b11010, &ENTRY_ELECTROLYZE_7508850835901837851)],
        ),
        (
            UniCase::ascii("romanticises"),
            &[(0b10010, &ENTRY_ROMANTICIZES_14376155573214247856)],
        ),
        (
            UniCase::ascii("gers"),
            &[(0b00001, &ENTRY_GERS_2810213260239783007)],
        ),
        (
            UniCase::ascii("catharized"),
            &[(0b01001, &ENTRY_CATHARIZED_5807291134697395135)],
        ),
        (
            UniCase::ascii("hygienises"),
            &[(0b10010, &ENTRY_HYGIENIZES_17832600989781813895)],
        ),
        (
            UniCase::ascii("dolomitization"),
            &[(0b01001, &ENTRY_DOLOMITIZATION_14933423504719929542)],
        ),
        (
            UniCase::ascii("phlebotomizations"),
            &[(0b01001, &ENTRY_PHLEBOTOMIZATIONS_3737256506686661609)],
        ),
        (
            UniCase::ascii("colourifics"),
            &[(0b11010, &ENTRY_COLORIFICS_7493178994191350405)],
        ),
        (
            UniCase::ascii("subsidizes"),
            &[(0b01001, &ENTRY_SUBSIDIZES_5852930110538753767)],
        ),
        (
            UniCase::ascii("spheroidize"),
            &[(0b01001, &ENTRY_SPHEROIDIZE_11471029450807575082)],
        ),
        (
            UniCase::ascii("toret"),
            &[(0b00001, &ENTRY_TORET_14642122393715101008)],
        ),
        (
            UniCase::ascii("racialisation"),
            &[(0b10010, &ENTRY_RACIALIZATION_3759743204420570975)],
        ),
        (
            UniCase::ascii("enamouring"),
            &[(0b11010, &ENTRY_ENAMORING_17989678795134022497)],
        ),
        (
            UniCase::ascii("aspheterising"),
            &[(0b10010, &ENTRY_ASPHETERIZING_6898599003467614908)],
        ),
        (
            UniCase::ascii("sexualizes"),
            &[(0b01001, &ENTRY_SEXUALIZES_14899097055849161352)],
        ),
        (
            UniCase::ascii("sabbatises"),
            &[(0b10010, &ENTRY_SABBATIZES_15314102181592132563)],
        ),
        (
            UniCase::ascii("logicising"),
            &[(0b10010, &ENTRY_LOGICIZING_6614561759161636962)],
        ),
        (
            UniCase::ascii("weatherising"),
            &[(0b10010, &ENTRY_WEATHERIZING_15974867536961027368)],
        ),
        (
            UniCase::ascii("colourationalest"),
            &[(0b11010, &ENTRY_COLORATIONALEST_16549871838474883279)],
        ),
        (
            UniCase::ascii("industrialises"),
            &[(0b10010, &ENTRY_INDUSTRIALIZES_108463817008379635)],
        ),
        (
            UniCase::ascii("christianization"),
            &[(0b01001, &ENTRY_CHRISTIANIZATION_18360975039569708955)],
        ),
        (
            UniCase::ascii("pencilings"),
            &[(0b00001, &ENTRY_PENCILINGS_819897427661414754)],
        ),
        (
            UniCase::ascii("mineralise"),
            &[(0b10010, &ENTRY_MINERALIZE_1571843507697484066)],
        ),
        (
            UniCase::ascii("unwesternised"),
            &[(0b10010, &ENTRY_UNWESTERNIZED_2338020082584820680)],
        ),
        (
            UniCase::ascii("harborlesser"),
            &[(0b11001, &ENTRY_HARBORLESSER_9734324406563797455)],
        ),
        (
            UniCase::ascii("vasectomising"),
            &[(0b10010, &ENTRY_VASECTOMIZING_8116057054186241693)],
        ),
        (
            UniCase::ascii("humoursome"),
            &[(0b11010, &ENTRY_HUMORSOME_8048377448291557893)],
        ),
        (
            UniCase::ascii("unindividualized"),
            &[(0b01001, &ENTRY_UNINDIVIDUALIZED_10177440970236663663)],
        ),
        (
            UniCase::ascii("pressurisers"),
            &[(0b10010, &ENTRY_PRESSURIZERS_9860382008246735540)],
        ),
        (
            UniCase::ascii("parochializations"),
            &[(0b01001, &ENTRY_PAROCHIALIZATIONS_9802414540039811945)],
        ),
        (
            UniCase::ascii("barbarisation"),
            &[(0b10010, &ENTRY_BARBARIZATION_637634415456611000)],
        ),
        (
            UniCase::ascii("undercapitalisations"),
            &[(0b10010, &ENTRY_UNDERCAPITALIZATIONS_15182325328537661657)],
        ),
        (
            UniCase::ascii("unraveling"),
            &[(0b00001, &ENTRY_UNRAVELING_17073861557040957443)],
        ),
        (
            UniCase::ascii("tailorizations"),
            &[(0b01001, &ENTRY_TAILORIZATIONS_1736724620876472569)],
        ),
        (
            UniCase::ascii("anglicization"),
            &[(0b01001, &ENTRY_ANGLICIZATION_15673594215730164653)],
        ),
        (
            UniCase::ascii("unheroise"),
            &[(0b10010, &ENTRY_UNHEROIZE_16852054084869741483)],
        ),
        (
            UniCase::ascii("eudaemonic"),
            &[(0b11010, &ENTRY_EUDEMONIC_10703096338080832052)],
        ),
        (
            UniCase::ascii("systematises"),
            &[(0b10010, &ENTRY_SYSTEMATIZES_6130814802973402788)],
        ),
        (
            UniCase::ascii("unsavoriest"),
            &[(0b01001, &ENTRY_UNSAVORIEST_4272222949170545033)],
        ),
        (
            UniCase::ascii("resynchronizes"),
            &[(0b01001, &ENTRY_RESYNCHRONIZES_5801125742459097915)],
        ),
        (
            UniCase::ascii("reorganizationists"),
            &[(0b01001, &ENTRY_REORGANIZATIONISTS_10384586979829403733)],
        ),
        (
            UniCase::ascii("nationalizers"),
            &[(0b01001, &ENTRY_NATIONALIZERS_9687329251077026772)],
        ),
        (
            UniCase::ascii("unnationalized"),
            &[(0b01001, &ENTRY_UNNATIONALIZED_17413125925681224817)],
        ),
        (
            UniCase::ascii("oesophagitis"),
            &[(0b11010, &ENTRY_ESOPHAGITIS_2344628816303730914)],
        ),
        (
            UniCase::ascii("unsensitises"),
            &[(0b10010, &ENTRY_UNSENSITIZES_5803069635824140326)],
        ),
        (
            UniCase::ascii("stomodaea"),
            &[(0b11010, &ENTRY_STOMODEA_17558438948754879743)],
        ),
        (
            UniCase::ascii("overindustrialisations"),
            &[(0b10010, &ENTRY_OVERINDUSTRIALIZATIONS_2479660567106903260)],
        ),
        (
            UniCase::ascii("misdemeanours"),
            &[(0b11010, &ENTRY_MISDEMEANORS_16426839555682853683)],
        ),
        (
            UniCase::ascii("antirumour"),
            &[(0b11010, &ENTRY_ANTIRUMOR_17427963938068472854)],
        ),
        (
            UniCase::ascii("aromatises"),
            &[(0b10010, &ENTRY_AROMATIZES_11689049401873834109)],
        ),
        (
            UniCase::ascii("marveling"),
            &[(0b00001, &ENTRY_MARVELING_17712338885593648087)],
        ),
        (
            UniCase::ascii("unappetising"),
            &[(0b10010, &ENTRY_UNAPPETIZING_12749343422231568734)],
        ),
        (
            UniCase::ascii("prologuized"),
            &[(0b01001, &ENTRY_PROLOGUIZED_3253550402486536987)],
        ),
        (
            UniCase::ascii("verbalisation"),
            &[(0b10010, &ENTRY_VERBALIZATION_1606887602703040047)],
        ),
        (
            UniCase::ascii("ituraean"),
            &[(0b11010, &ENTRY_ITUREAN_1579753874067258559)],
        ),
        (
            UniCase::ascii("dematerializing"),
            &[(0b01001, &ENTRY_DEMATERIALIZING_10155714463244702927)],
        ),
        (
            UniCase::ascii("mesmerising"),
            &[(0b10010, &ENTRY_MESMERIZING_9747635351758180951)],
        ),
        (
            UniCase::ascii("byzantinizes"),
            &[(0b01001, &ENTRY_BYZANTINIZES_7526286864523963129)],
        ),
        (
            UniCase::ascii("noncrystallized"),
            &[(0b01001, &ENTRY_NONCRYSTALLIZED_6387561216013434881)],
        ),
        (
            UniCase::ascii("mediumisation"),
            &[(0b10010, &ENTRY_MEDIUMIZATION_13781773160846845668)],
        ),
        (
            UniCase::ascii("autolysed"),
            &[(0b10010, &ENTRY_AUTOLYZED_17033910730696642695)],
        ),
        (
            UniCase::ascii("galeae"),
            &[(0b11010, &ENTRY_GALEE_18295229614385569377)],
        ),
        (
            UniCase::ascii("viverrinae"),
            &[(0b11010, &ENTRY_VIVERRINE_4631118611455296151)],
        ),
        (
            UniCase::ascii("palaeoanthropic"),
            &[(0b11010, &ENTRY_PALEOANTHROPIC_5954958120113844205)],
        ),
        (
            UniCase::ascii("pupilize"),
            &[(0b01001, &ENTRY_PUPILIZE_5377680490535459429)],
        ),
        (
            UniCase::ascii("ironize"),
            &[(0b01001, &ENTRY_IRONIZE_18110787504657881641)],
        ),
        (
            UniCase::ascii("mentalisations"),
            &[(0b10010, &ENTRY_MENTALIZATIONS_14912536060408920277)],
        ),
        (
            UniCase::ascii("geometrise"),
            &[(0b10010, &ENTRY_GEOMETRIZE_16268499732063085651)],
        ),
        (
            UniCase::ascii("fascistization"),
            &[(0b01001, &ENTRY_FASCISTIZATION_6926224020620442283)],
        ),
        (
            UniCase::ascii("recolour"),
            &[(0b11010, &ENTRY_RECOLOR_3257883209193222439)],
        ),
        (
            UniCase::ascii("chaptalization"),
            &[(0b01001, &ENTRY_CHAPTALIZATION_6705837795677885132)],
        ),
        (
            UniCase::ascii("sorbitising"),
            &[(0b10010, &ENTRY_SORBITIZING_10552560528290540525)],
        ),
        (
            UniCase::ascii("mesprize"),
            &[(0b01001, &ENTRY_MESPRIZE_626385901018439636)],
        ),
        (
            UniCase::ascii("pillorized"),
            &[(0b01001, &ENTRY_PILLORIZED_894715813225067108)],
        ),
        (
            UniCase::ascii("unsterilized"),
            &[(0b01001, &ENTRY_UNSTERILIZED_13156342258367971107)],
        ),
        (
            UniCase::ascii("rematerialize"),
            &[(0b01001, &ENTRY_REMATERIALIZE_12678282950195083048)],
        ),
        (
            UniCase::ascii("unscrutinisingliest"),
            &[(0b10010, &ENTRY_UNSCRUTINIZINGLIEST_4936819005717689952)],
        ),
        (
            UniCase::ascii("harbourside"),
            &[(0b11010, &ENTRY_HARBORSIDE_15034063211426224574)],
        ),
        (
            UniCase::ascii("lastre"),
            &[(0b11010, &ENTRY_LASTER_5242258785041708124)],
        ),
        (
            UniCase::ascii("pedestrianizations"),
            &[(0b01001, &ENTRY_PEDESTRIANIZATIONS_1818839118428039973)],
        ),
        (
            UniCase::ascii("draftier"),
            &[(0b01001, &ENTRY_DRAFTIER_9222724357623798327)],
        ),
        (
            UniCase::ascii("euhemerize"),
            &[(0b01001, &ENTRY_EUHEMERIZE_10861960486485255136)],
        ),
        (
            UniCase::ascii("haematocrit"),
            &[(0b11010, &ENTRY_HEMATOCRIT_6552226497838822276)],
        ),
        (
            UniCase::ascii("spaniardise"),
            &[(0b10010, &ENTRY_SPANIARDIZE_9569545691628177723)],
        ),
        (
            UniCase::ascii("irrecognizable"),
            &[(0b01001, &ENTRY_IRRECOGNIZABLE_17719796395122033372)],
        ),
        (
            UniCase::ascii("unparcelled"),
            &[(0b11010, &ENTRY_UNPARCELED_1373494415685202599)],
        ),
        (
            UniCase::ascii("piaster"),
            &[(0b00001, &ENTRY_PIASTER_13635975646054450930)],
        ),
        (
            UniCase::ascii("categorisations"),
            &[(0b10010, &ENTRY_CATEGORIZATIONS_16612628821035244612)],
        ),
        (
            UniCase::ascii("dracaenaceae"),
            &[(0b11010, &ENTRY_DRACENACEAE_16212683568672807360)],
        ),
        (
            UniCase::ascii("realisations"),
            &[(0b10010, &ENTRY_REALIZATIONS_11017380405499744692)],
        ),
        (
            UniCase::ascii("deformalize"),
            &[(0b01001, &ENTRY_DEFORMALIZE_15907382900288731005)],
        ),
        (
            UniCase::ascii("spiritualization"),
            &[(0b01001, &ENTRY_SPIRITUALIZATION_10305886720640139033)],
        ),
        (
            UniCase::ascii("pense"),
            &[(0b00001, &ENTRY_PENSE_14215361872352066210)],
        ),
        (
            UniCase::ascii("tabularisations"),
            &[(0b10010, &ENTRY_TABULARIZATIONS_7435992087915599492)],
        ),
        (
            UniCase::ascii("chromizes"),
            &[(0b01001, &ENTRY_CHROMIZES_15865986984042622696)],
        ),
        (
            UniCase::ascii("newmanizes"),
            &[(0b01001, &ENTRY_NEWMANIZES_2270185545274776704)],
        ),
        (
            UniCase::ascii("cryoanesthesia"),
            &[(0b10001, &ENTRY_CRYOANESTHESIA_5659435164723717323)],
        ),
        (
            UniCase::ascii("unilateralisation"),
            &[(0b10010, &ENTRY_UNILATERALIZATION_7642348548145928002)],
        ),
        (
            UniCase::ascii("preinitializes"),
            &[(0b01001, &ENTRY_PREINITIALIZES_1948106422392976020)],
        ),
        (
            UniCase::ascii("parsonizes"),
            &[(0b01001, &ENTRY_PARSONIZES_7532265200903960160)],
        ),
        (
            UniCase::ascii("seculum"),
            &[(0b00001, &ENTRY_SECULUM_14580513950849648417)],
        ),
        (
            UniCase::ascii("uncatholicises"),
            &[(0b10010, &ENTRY_UNCATHOLICIZES_8958496403317373578)],
        ),
        (
            UniCase::ascii("cer"),
            &[(0b00001, &ENTRY_CER_16898181025911443964)],
        ),
        (
            UniCase::ascii("titbits"),
            &[(0b10011, &ENTRY_TIDBITS_8862313789168390887)],
        ),
        (
            UniCase::ascii("marsupialization"),
            &[(0b01001, &ENTRY_MARSUPIALIZATION_8918810560002724439)],
        ),
        (
            UniCase::ascii("analyzability"),
            &[(0b01001, &ENTRY_ANALYZABILITY_1551141386065817504)],
        ),
        (
            UniCase::ascii("colourer"),
            &[(0b11010, &ENTRY_COLORER_6377883908421217617)],
        ),
        (
            UniCase::ascii("photocatalyser"),
            &[(0b11010, &ENTRY_PHOTOCATALYZER_11050841619007985543)],
        ),
        (
            UniCase::ascii("anticatalyzers"),
            &[(0b00001, &ENTRY_ANTICATALYZERS_14048896960716076262)],
        ),
        (
            UniCase::ascii("praecava"),
            &[(0b11010, &ENTRY_PRECAVA_2402040055160081507)],
        ),
        (
            UniCase::ascii("uncapitalised"),
            &[(0b10010, &ENTRY_UNCAPITALIZED_15771287396524776391)],
        ),
        (
            UniCase::ascii("unfavouritest"),
            &[(0b11010, &ENTRY_UNFAVORITEST_5653472480878764002)],
        ),
        (
            UniCase::ascii("micropaleontologies"),
            &[(0b10001, &ENTRY_MICROPALEONTOLOGIES_15673084178324778221)],
        ),
        (
            UniCase::ascii("belus"),
            &[(0b00001, &ENTRY_BELUS_10707973760047908555)],
        ),
        (
            UniCase::ascii("decarbonised"),
            &[(0b10010, &ENTRY_DECARBONIZED_831670285440777483)],
        ),
        (
            UniCase::ascii("radiopasteurization"),
            &[(0b01001, &ENTRY_RADIOPASTEURIZATION_10077706312711948195)],
        ),
        (
            UniCase::ascii("bourd"),
            &[(0b11010, &ENTRY_BORD_18164452795863545372)],
        ),
        (
            UniCase::ascii("palaeethnological"),
            &[(0b11010, &ENTRY_PALEETHNOLOGICAL_10389145458276668226)],
        ),
        (
            UniCase::ascii("galee"),
            &[(0b00001, &ENTRY_GALEE_18295229614385569377)],
        ),
        (
            UniCase::ascii("cigarets"),
            &[(0b00001, &ENTRY_CIGARETTES_2896249679667819882)],
        ),
        (
            UniCase::ascii("rehumanise"),
            &[(0b10010, &ENTRY_REHUMANIZE_10181332086255781696)],
        ),
        (
            UniCase::ascii("trypsinize"),
            &[(0b01001, &ENTRY_TRYPSINIZE_11310311969110258138)],
        ),
        (
            UniCase::ascii("neighborship"),
            &[(0b10001, &ENTRY_NEIGHBORSHIP_7342829838404157081)],
        ),
        (
            UniCase::ascii("microcolorimetry"),
            &[(0b00001, &ENTRY_MICROCOLORIMETRY_4008745178077342383)],
        ),
        (
            UniCase::ascii("haemorrhoids"),
            &[(0b10010, &ENTRY_HEMORRHOIDS_7074206056862708793)],
        ),
        (
            UniCase::ascii("palaeohistology"),
            &[(0b11010, &ENTRY_PALEOHISTOLOGY_11971446365505053036)],
        ),
        (
            UniCase::ascii("crenelling"),
            &[(0b11010, &ENTRY_CRENELING_15994472673064843243)],
        ),
        (
            UniCase::ascii("uncurricularized"),
            &[(0b01001, &ENTRY_UNCURRICULARIZED_1510394198207258931)],
        ),
        (
            UniCase::ascii("authorising"),
            &[(0b10010, &ENTRY_AUTHORIZING_6195944790124186706)],
        ),
        (
            UniCase::ascii("urinaemic"),
            &[(0b11010, &ENTRY_URINEMIC_3826715010964749488)],
        ),
        (
            UniCase::ascii("tutorise"),
            &[(0b10010, &ENTRY_TUTORIZE_5415313587641112365)],
        ),
        (
            UniCase::ascii("goyesque"),
            &[(0b00001, &ENTRY_GOYESQUE_6877829052939471298)],
        ),
        (
            UniCase::ascii("haematozoal"),
            &[(0b11010, &ENTRY_HEMATOZOAL_15898976106203214908)],
        ),
        (
            UniCase::ascii("foreignises"),
            &[(0b10010, &ENTRY_FOREIGNIZES_17287836650502268788)],
        ),
        (
            UniCase::ascii("noncrystalliseds"),
            &[(0b10010, &ENTRY_NONCRYSTALLIZEDS_15212825180251803633)],
        ),
        (
            UniCase::ascii("fertiliser"),
            &[(0b10010, &ENTRY_FERTILIZER_17245657864487752834)],
        ),
        (
            UniCase::ascii("derecognises"),
            &[(0b10010, &ENTRY_DERECOGNIZES_2898686597965431739)],
        ),
        (
            UniCase::ascii("syphilize"),
            &[(0b01001, &ENTRY_SYPHILIZE_13140711569267519345)],
        ),
        (
            UniCase::ascii("cognizers"),
            &[(0b01001, &ENTRY_COGNIZERS_16818874771090495789)],
        ),
        (
            UniCase::ascii("supercarbonisations"),
            &[(0b10010, &ENTRY_SUPERCARBONIZATIONS_10831679594408466920)],
        ),
        (
            UniCase::ascii("erogenic"),
            &[(0b00001, &ENTRY_EROGENIC_3058184513432824304)],
        ),
        (
            UniCase::ascii("chloritization"),
            &[(0b01001, &ENTRY_CHLORITIZATION_6329588467839471117)],
        ),
        (
            UniCase::ascii("apophthegmatise"),
            &[(0b10010, &ENTRY_APOPHTHEGMATIZE_6610517743016644545)],
        ),
        (
            UniCase::ascii("burnettised"),
            &[(0b10010, &ENTRY_BURNETTIZED_4236600316315443722)],
        ),
        (
            UniCase::ascii("grammaticise"),
            &[(0b10010, &ENTRY_GRAMMATICIZE_11757970532171038610)],
        ),
        (
            UniCase::ascii("unpaganize"),
            &[(0b01001, &ENTRY_UNPAGANIZE_10797468704092625272)],
        ),
        (
            UniCase::ascii("unsensitized"),
            &[(0b01001, &ENTRY_UNSENSITIZED_7794134976310825921)],
        ),
        (
            UniCase::ascii("deglycerolized"),
            &[(0b01001, &ENTRY_DEGLYCEROLIZED_5620184830818473145)],
        ),
        (
            UniCase::ascii("negroization"),
            &[(0b01001, &ENTRY_NEGROIZATION_8048386169561232415)],
        ),
        (
            UniCase::ascii("popularizing"),
            &[(0b01001, &ENTRY_POPULARIZING_14605893405429303093)],
        ),
        (
            UniCase::ascii("penciler"),
            &[(0b00001, &ENTRY_PENCILER_9299836922075131413)],
        ),
        (
            UniCase::ascii("hemathermal"),
            &[(0b10001, &ENTRY_HEMATHERMAL_1873265424030054420)],
        ),
        (
            UniCase::ascii("omelets"),
            &[(0b01001, &ENTRY_OMELETS_1159437164748315894)],
        ),
        (
            UniCase::ascii("mechanicalizes"),
            &[(0b01001, &ENTRY_MECHANICALIZES_11069973531634237808)],
        ),
        (
            UniCase::ascii("vagabondiser"),
            &[(0b10010, &ENTRY_VAGABONDIZER_3037058975526630888)],
        ),
        (
            UniCase::ascii("optimalizing"),
            &[(0b01001, &ENTRY_OPTIMALIZING_12458824693754631504)],
        ),
        (
            UniCase::ascii("standardizables"),
            &[(0b01001, &ENTRY_STANDARDIZABLES_16202726792541011392)],
        ),
        (
            UniCase::ascii("draftiest"),
            &[(0b01001, &ENTRY_DRAFTIEST_5259543064524205513)],
        ),
        (
            UniCase::ascii("paleoanthropologies"),
            &[(0b10001, &ENTRY_PALEOANTHROPOLOGIES_8205118955898337795)],
        ),
        (
            UniCase::ascii("vermilionize"),
            &[(0b01001, &ENTRY_VERMILIONIZE_1285328019998267214)],
        ),
        (
            UniCase::ascii("mobilisabler"),
            &[(0b10010, &ENTRY_MOBILIZABLER_10904297470856896702)],
        ),
        (
            UniCase::ascii("mercerize"),
            &[(0b01001, &ENTRY_MERCERIZE_15182792491441059447)],
        ),
        (
            UniCase::ascii("hypoxaemias"),
            &[(0b11010, &ENTRY_HYPOXEMIAS_16532743875103109491)],
        ),
        (
            UniCase::ascii("realize"),
            &[(0b01001, &ENTRY_REALIZE_2182577141310692876)],
        ),
        (
            UniCase::ascii("demobilizing"),
            &[(0b01001, &ENTRY_DEMOBILIZING_2666589548621520076)],
        ),
        (
            UniCase::ascii("vagrantises"),
            &[(0b10010, &ENTRY_VAGRANTIZES_9039456281230433333)],
        ),
        (
            UniCase::ascii("phoneticising"),
            &[(0b10010, &ENTRY_PHONETICIZING_10352945092040857910)],
        ),
        (
            UniCase::ascii("plasticizer"),
            &[(0b01001, &ENTRY_PLASTICIZER_4503458591975420540)],
        ),
        (
            UniCase::ascii("paediatrics"),
            &[(0b10010, &ENTRY_PEDIATRICS_13936732030428661587)],
        ),
        (
            UniCase::ascii("channelization"),
            &[(0b01001, &ENTRY_CHANNELIZATION_8051143060294686401)],
        ),
        (
            UniCase::ascii("misauthorize"),
            &[(0b01001, &ENTRY_MISAUTHORIZE_3226310660966698523)],
        ),
        (
            UniCase::ascii("vermeiling"),
            &[(0b00001, &ENTRY_VERMEILING_16263718376783682636)],
        ),
        (
            UniCase::ascii("somberest"),
            &[(0b00001, &ENTRY_SOMBEREST_3884649068642437270)],
        ),
        (
            UniCase::ascii("renormalisation"),
            &[(0b10010, &ENTRY_RENORMALIZATION_9891230551808040808)],
        ),
        (
            UniCase::ascii("syllogised"),
            &[(0b10010, &ENTRY_SYLLOGIZED_8853526086846614350)],
        ),
        (
            UniCase::ascii("idiotizing"),
            &[(0b01001, &ENTRY_IDIOTIZING_7163780928321635270)],
        ),
        (
            UniCase::ascii("unradicalize"),
            &[(0b01001, &ENTRY_UNRADICALIZE_2815754936703483818)],
        ),
        (
            UniCase::ascii("reanimalise"),
            &[(0b10010, &ENTRY_REANIMALIZE_3196465253809288594)],
        ),
        (
            UniCase::ascii("sory"),
            &[(0b00001, &ENTRY_SORY_866294547402037500)],
        ),
        (
            UniCase::ascii("prophetize"),
            &[(0b01001, &ENTRY_PROPHETIZE_3283856741265018815)],
        ),
        (
            UniCase::ascii("unsymbolisedder"),
            &[(0b10010, &ENTRY_UNSYMBOLIZEDDER_2693121694591055898)],
        ),
        (
            UniCase::ascii("weftwise"),
            &[(0b10010, &ENTRY_WEFTWIZE_11468980171486281071)],
        ),
        (
            UniCase::ascii("westernisations"),
            &[(0b10010, &ENTRY_WESTERNIZATIONS_13759633497928659151)],
        ),
        (
            UniCase::ascii("undemagnetizables"),
            &[(0b01001, &ENTRY_UNDEMAGNETIZABLES_5686795504114325763)],
        ),
        (
            UniCase::ascii("personalised"),
            &[(0b10010, &ENTRY_PERSONALIZED_8380116593820467680)],
        ),
        (
            UniCase::ascii("athetised"),
            &[(0b10010, &ENTRY_ATHETIZED_9779500563027955411)],
        ),
        (
            UniCase::ascii("oxidize"),
            &[(0b01001, &ENTRY_OXIDIZE_14098521888186084656)],
        ),
        (
            UniCase::ascii("elizabethanise"),
            &[(0b10010, &ENTRY_ELIZABETHANIZE_14863227819015951221)],
        ),
        (
            UniCase::ascii("polydemonism"),
            &[(0b00001, &ENTRY_POLYDEMONISM_16806489744265358404)],
        ),
        (
            UniCase::ascii("unalphabetized"),
            &[(0b01001, &ENTRY_UNALPHABETIZED_785154054192050580)],
        ),
        (
            UniCase::ascii("unagonize"),
            &[(0b01001, &ENTRY_UNAGONIZE_6084501682979547918)],
        ),
        (
            UniCase::ascii("acclimatizing"),
            &[(0b01001, &ENTRY_ACCLIMATIZING_3751997949097583159)],
        ),
        (
            UniCase::ascii("mathematicises"),
            &[(0b10010, &ENTRY_MATHEMATICIZES_17239793732172029302)],
        ),
        (
            UniCase::ascii("pulpitise"),
            &[(0b10010, &ENTRY_PULPITIZE_14520819506187442470)],
        ),
        (
            UniCase::ascii("cosmopolitanises"),
            &[(0b10010, &ENTRY_COSMOPOLITANIZES_57296618879818157)],
        ),
        (
            UniCase::ascii("tranquillities"),
            &[(0b10011, &ENTRY_TRANQUILITIES_16195163391619170068)],
        ),
        (
            UniCase::ascii("dieselising"),
            &[(0b10010, &ENTRY_DIESELIZING_17476118384961942350)],
        ),
        (
            UniCase::ascii("colonisabler"),
            &[(0b10010, &ENTRY_COLONIZABLER_7503793641425675771)],
        ),
        (
            UniCase::ascii("victorianize"),
            &[(0b01001, &ENTRY_VICTORIANIZE_6350658122976337243)],
        ),
        (
            UniCase::ascii("phaenogenetic"),
            &[(0b11010, &ENTRY_PHENOGENETIC_17720618598147822936)],
        ),
        (
            UniCase::ascii("nonsynthesiseds"),
            &[(0b10010, &ENTRY_NONSYNTHESIZEDS_16944487649499471214)],
        ),
        (
            UniCase::ascii("electrolysing"),
            &[(0b11010, &ENTRY_ELECTROLYZING_9315861603300473848)],
        ),
        (
            UniCase::ascii("pelletize"),
            &[(0b01001, &ENTRY_PELLETIZE_14681817165893413798)],
        ),
        (
            UniCase::ascii("romanisers"),
            &[(0b10010, &ENTRY_ROMANIZERS_7186572903998412475)],
        ),
        (
            UniCase::ascii("elasticises"),
            &[(0b10010, &ENTRY_ELASTICIZES_15507458752832878092)],
        ),
        (
            UniCase::ascii("esculin"),
            &[(0b00001, &ENTRY_ESCULIN_10740850830469064996)],
        ),
        (
            UniCase::ascii("machinises"),
            &[(0b10010, &ENTRY_MACHINIZES_17958467964158304583)],
        ),
        (
            UniCase::ascii("unionizations"),
            &[(0b01001, &ENTRY_UNIONIZATIONS_14252170992346338262)],
        ),
        (
            UniCase::ascii("pluralisations"),
            &[(0b10010, &ENTRY_PLURALIZATIONS_1198848109390483960)],
        ),
        (
            UniCase::ascii("unlaborables"),
            &[(0b00001, &ENTRY_UNLABORABLES_6698240791463419426)],
        ),
        (
            UniCase::ascii("nondialyzing"),
            &[(0b00001, &ENTRY_NONDIALYZING_12492599878535719323)],
        ),
        (
            UniCase::ascii("figurize"),
            &[(0b01001, &ENTRY_FIGURIZE_7661939521561734817)],
        ),
        (
            UniCase::ascii("mischaracterizations"),
            &[(0b01001, &ENTRY_MISCHARACTERIZATIONS_9820262910491559476)],
        ),
        (
            UniCase::ascii("storier"),
            &[(0b00001, &ENTRY_STORIER_6107744465020666747)],
        ),
        (
            UniCase::ascii("nonvolatilised"),
            &[(0b10010, &ENTRY_NONVOLATILIZED_16762619793860124905)],
        ),
        (
            UniCase::ascii("unmediatizeds"),
            &[(0b01001, &ENTRY_UNMEDIATIZEDS_1136374808671187759)],
        ),
        (
            UniCase::ascii("literaliser"),
            &[(0b10010, &ENTRY_LITERALIZER_18413794030675395560)],
        ),
        (
            UniCase::ascii("caramelisation"),
            &[(0b10010, &ENTRY_CARAMELIZATION_12261843451362374441)],
        ),
        (
            UniCase::ascii("dishonorably"),
            &[(0b11001, &ENTRY_DISHONORABLY_16389408757341415026)],
        ),
        (
            UniCase::ascii("draughty"),
            &[(0b10010, &ENTRY_DRAFTY_11689082232746206984)],
        ),
        (
            UniCase::ascii("quaestionary"),
            &[(0b11010, &ENTRY_QUESTIONARY_355066268016349878)],
        ),
        (
            UniCase::ascii("evilest"),
            &[(0b00001, &ENTRY_EVILEST_2003136876659939656)],
        ),
        (
            UniCase::ascii("synetic"),
            &[(0b00001, &ENTRY_SYNETIC_11062609274567880634)],
        ),
        (
            UniCase::ascii("praetextae"),
            &[(0b11010, &ENTRY_PRETEXTAE_16184667912878448094)],
        ),
        (
            UniCase::ascii("smolders"),
            &[(0b01001, &ENTRY_SMOLDERS_16317626305242093646)],
        ),
        (
            UniCase::ascii("reindustrialising"),
            &[(0b10010, &ENTRY_REINDUSTRIALIZING_12638875256658078134)],
        ),
        (
            UniCase::ascii("unneutralize"),
            &[(0b01001, &ENTRY_UNNEUTRALIZE_4698429815634199128)],
        ),
        (
            UniCase::ascii("familiarizingly"),
            &[(0b01001, &ENTRY_FAMILIARIZINGLY_17102975447523114031)],
        ),
        (
            UniCase::ascii("infinitise"),
            &[(0b10010, &ENTRY_INFINITIZE_12913263953737511613)],
        ),
        (
            UniCase::ascii("randomization"),
            &[(0b01001, &ENTRY_RANDOMIZATION_1289611966234918219)],
        ),
        (
            UniCase::ascii("gynecological"),
            &[(0b11001, &ENTRY_GYNECOLOGICAL_8191486902731594424)],
        ),
        (
            UniCase::ascii("decolourant"),
            &[(0b11010, &ENTRY_DECOLORANT_5335359943030311716)],
        ),
        (
            UniCase::ascii("sceptres"),
            &[(0b11010, &ENTRY_SCEPTERS_17320251109355012747)],
        ),
        (
            UniCase::ascii("laborsaving"),
            &[(0b11001, &ENTRY_LABORSAVING_1003966555581027356)],
        ),
        (
            UniCase::ascii("decolorizers"),
            &[(0b00001, &ENTRY_DECOLORIZERS_2577270439983901494)],
        ),
        (
            UniCase::ascii("minimizing"),
            &[(0b01001, &ENTRY_MINIMIZING_6587400313450683054)],
        ),
        (
            UniCase::ascii("divisionalization"),
            &[(0b01001, &ENTRY_DIVISIONALIZATION_12097639934213939942)],
        ),
        (
            UniCase::ascii("hydrogenizing"),
            &[(0b01001, &ENTRY_HYDROGENIZING_14049891921794212990)],
        ),
        (
            UniCase::ascii("atmolyzing"),
            &[(0b01001, &ENTRY_ATMOLYZING_12067305970424863391)],
        ),
        (
            UniCase::ascii("diabolized"),
            &[(0b01001, &ENTRY_DIABOLIZED_5121441305555041821)],
        ),
        (
            UniCase::ascii("monologuize"),
            &[(0b01001, &ENTRY_MONOLOGUIZE_7317088988238212245)],
        ),
        (
            UniCase::ascii("parisianises"),
            &[(0b10010, &ENTRY_PARISIANIZES_425663399052281478)],
        ),
        (
            UniCase::ascii("civilisatory"),
            &[(0b10010, &ENTRY_CIVILIZATORY_1986047737625317948)],
        ),
        (
            UniCase::ascii("skeptic"),
            &[(0b11001, &ENTRY_SKEPTIC_9366141399207033866)],
        ),
        (
            UniCase::ascii("foetidest"),
            &[(0b10010, &ENTRY_FETIDEST_17027395037056500217)],
        ),
        (
            UniCase::ascii("factorizing"),
            &[(0b01001, &ENTRY_FACTORIZING_6633915971235070053)],
        ),
        (
            UniCase::ascii("gynecologicaler"),
            &[(0b11001, &ENTRY_GYNECOLOGICALER_3649621888054805329)],
        ),
        (
            UniCase::ascii("neer"),
            &[(0b00001, &ENTRY_NEER_16355605982802851825)],
        ),
        (
            UniCase::ascii("prehumor"),
            &[(0b00001, &ENTRY_PREHUMOR_5171358378179024334)],
        ),
        (
            UniCase::ascii("palaeolithist"),
            &[(0b11010, &ENTRY_PALEOLITHIST_5532799631229777418)],
        ),
        (
            UniCase::ascii("diarize"),
            &[(0b01001, &ENTRY_DIARIZE_7333441747497120999)],
        ),
        (
            UniCase::ascii("unbrutalizes"),
            &[(0b01001, &ENTRY_UNBRUTALIZES_4127817782461372270)],
        ),
        (
            UniCase::ascii("pluralizer"),
            &[(0b01001, &ENTRY_PLURALIZER_1892398405711976310)],
        ),
        (
            UniCase::ascii("colourmaker"),
            &[(0b11010, &ENTRY_COLORMAKER_13048991323713933641)],
        ),
        (
            UniCase::ascii("checkerboards"),
            &[(0b00001, &ENTRY_CHECKERBOARDS_18064653792576628856)],
        ),
        (
            UniCase::ascii("solecized"),
            &[(0b01001, &ENTRY_SOLECIZED_15911538990572619815)],
        ),
        (
            UniCase::ascii("apostrophising"),
            &[(0b10010, &ENTRY_APOSTROPHIZING_11255712027534928622)],
        ),
        (
            UniCase::ascii("logicize"),
            &[(0b01001, &ENTRY_LOGICIZE_15843613372926701720)],
        ),
        (
            UniCase::ascii("extoll"),
            &[(0b00001, &ENTRY_EXTOL_17049600042027760409)],
        ),
        (
            UniCase::ascii("severalizes"),
            &[(0b01001, &ENTRY_SEVERALIZES_10859120750647710400)],
        ),
        (
            UniCase::ascii("misbaptise"),
            &[(0b10010, &ENTRY_MISBAPTIZE_3680575039131375475)],
        ),
        (
            UniCase::ascii("unvitrioliseds"),
            &[(0b10010, &ENTRY_UNVITRIOLIZEDS_12617332440469592487)],
        ),
        (
            UniCase::ascii("etymologised"),
            &[(0b10010, &ENTRY_ETYMOLOGIZED_9179162719754519975)],
        ),
        (
            UniCase::ascii("enterocoeles"),
            &[(0b11010, &ENTRY_ENTEROCELES_5370389164173622202)],
        ),
        (
            UniCase::ascii("paedomorphic"),
            &[(0b11010, &ENTRY_PEDOMORPHIC_6860459212658075764)],
        ),
        (
            UniCase::ascii("alkalising"),
            &[(0b10010, &ENTRY_ALKALIZING_8020169751754023745)],
        ),
        (
            UniCase::ascii("untantalizings"),
            &[(0b01001, &ENTRY_UNTANTALIZINGS_16007088557356417459)],
        ),
        (
            UniCase::ascii("enrollment"),
            &[(0b11001, &ENTRY_ENROLLMENT_11988649571385805864)],
        ),
        (
            UniCase::ascii("ruffianizes"),
            &[(0b01001, &ENTRY_RUFFIANIZES_14576217936902384026)],
        ),
        (
            UniCase::ascii("tubercularizing"),
            &[(0b01001, &ENTRY_TUBERCULARIZING_3929944679702207874)],
        ),
        (
            UniCase::ascii("likabilities"),
            &[(0b10001, &ENTRY_LIKABILITIES_1914395607629735656)],
        ),
        (
            UniCase::ascii("unoxidizeddest"),
            &[(0b01001, &ENTRY_UNOXIDIZEDDEST_14507693636430734653)],
        ),
        (
            UniCase::ascii("acetonemic"),
            &[(0b10001, &ENTRY_ACETONEMIC_3556838368325334069)],
        ),
        (
            UniCase::ascii("novelized"),
            &[(0b01001, &ENTRY_NOVELIZED_15369631902763073587)],
        ),
        (
            UniCase::ascii("simonise"),
            &[(0b10010, &ENTRY_SIMONIZE_353967938486861116)],
        ),
        (
            UniCase::ascii("repulverize"),
            &[(0b01001, &ENTRY_REPULVERIZE_7976316581557319006)],
        ),
        (
            UniCase::ascii("roubles"),
            &[(0b11010, &ENTRY_RUBLES_5273455018786501602)],
        ),
        (
            UniCase::ascii("anathematiser"),
            &[(0b10010, &ENTRY_ANATHEMATIZER_3378013434055917757)],
        ),
        (
            UniCase::ascii("womanized"),
            &[(0b01001, &ENTRY_WOMANIZED_13265813200914382776)],
        ),
        (
            UniCase::ascii("lavolted"),
            &[(0b00001, &ENTRY_LAVOLTED_5688164088762295019)],
        ),
        (
            UniCase::ascii("ruggedises"),
            &[(0b10010, &ENTRY_RUGGEDIZES_16648500507504288559)],
        ),
        (
            UniCase::ascii("indigenized"),
            &[(0b01001, &ENTRY_INDIGENIZED_17113860080855467952)],
        ),
        (
            UniCase::ascii("individualised"),
            &[(0b10010, &ENTRY_INDIVIDUALIZED_16128034337210456768)],
        ),
        (
            UniCase::ascii("neopaganising"),
            &[(0b10010, &ENTRY_NEOPAGANIZING_13517084271492557770)],
        ),
        (
            UniCase::ascii("unicolour"),
            &[(0b11010, &ENTRY_UNICOLOR_17123726217698406043)],
        ),
        (
            UniCase::ascii("sectionalised"),
            &[(0b10010, &ENTRY_SECTIONALIZED_15063335524950991716)],
        ),
        (
            UniCase::ascii("southernizing"),
            &[(0b01001, &ENTRY_SOUTHERNIZING_7105097135265474755)],
        ),
        (
            UniCase::ascii("essentialise"),
            &[(0b10010, &ENTRY_ESSENTIALIZE_6300653085008787820)],
        ),
        (
            UniCase::ascii("departmentalizes"),
            &[(0b01001, &ENTRY_DEPARTMENTALIZES_2816661299052746212)],
        ),
        (
            UniCase::ascii("spanishizes"),
            &[(0b01001, &ENTRY_SPANISHIZES_15280734989274435032)],
        ),
        (
            UniCase::ascii("philippize"),
            &[(0b01001, &ENTRY_PHILIPPIZE_9477479770062521505)],
        ),
        (
            UniCase::ascii("dimerization"),
            &[(0b01001, &ENTRY_DIMERIZATION_15302035121240997222)],
        ),
        (
            UniCase::ascii("superfetation"),
            &[(0b00001, &ENTRY_SUPERFETATION_12600225493156545849)],
        ),
        (
            UniCase::ascii("pedophilias"),
            &[(0b10001, &ENTRY_PEDOPHILIAS_10406528979051385197)],
        ),
        (
            UniCase::ascii("gavelled"),
            &[(0b11010, &ENTRY_GAVELED_9330937849179337117)],
        ),
        (
            UniCase::ascii("divinizes"),
            &[(0b01001, &ENTRY_DIVINIZES_2478647172593491088)],
        ),
        (
            UniCase::ascii("aphorize"),
            &[(0b01001, &ENTRY_APHORIZE_15454256210406202597)],
        ),
        (
            UniCase::ascii("parochialises"),
            &[(0b10010, &ENTRY_PAROCHIALIZES_18097243070015350318)],
        ),
        (
            UniCase::ascii("intercrystallization"),
            &[(0b01001, &ENTRY_INTERCRYSTALLIZATION_535306253275539668)],
        ),
        (
            UniCase::ascii("colorably"),
            &[(0b11001, &ENTRY_COLORABLY_13475999889111967538)],
        ),
        (
            UniCase::ascii("asexualized"),
            &[(0b01001, &ENTRY_ASEXUALIZED_7482569439479163307)],
        ),
        (
            UniCase::ascii("laboringly"),
            &[(0b11001, &ENTRY_LABORINGLY_7190288000401128860)],
        ),
        (
            UniCase::ascii("unharmonizes"),
            &[(0b01001, &ENTRY_UNHARMONIZES_13473655128913265796)],
        ),
        (
            UniCase::ascii("vaticanises"),
            &[(0b10010, &ENTRY_VATICANIZES_16071718452803582750)],
        ),
        (
            UniCase::ascii("provincializes"),
            &[(0b01001, &ENTRY_PROVINCIALIZES_2334082830205990146)],
        ),
        (
            UniCase::ascii("moisturized"),
            &[(0b01001, &ENTRY_MOISTURIZED_3672738717919459176)],
        ),
        (
            UniCase::ascii("microcolorimetric"),
            &[(0b00001, &ENTRY_MICROCOLORIMETRIC_16293154471196561257)],
        ),
        (
            UniCase::ascii("trichinisations"),
            &[(0b10010, &ENTRY_TRICHINIZATIONS_12374290002608454472)],
        ),
        (
            UniCase::ascii("behavioured"),
            &[(0b11010, &ENTRY_BEHAVIORED_496799855263187779)],
        ),
        (
            UniCase::ascii("urethrorrhoea"),
            &[(0b11010, &ENTRY_URETHRORRHEA_465812257833285712)],
        ),
        (
            UniCase::ascii("shepherdize"),
            &[(0b01001, &ENTRY_SHEPHERDIZE_9589644434591127897)],
        ),
        (
            UniCase::ascii("pragmatization"),
            &[(0b01001, &ENTRY_PRAGMATIZATION_8346324153987456718)],
        ),
        (
            UniCase::ascii("serpentinization"),
            &[(0b01001, &ENTRY_SERPENTINIZATION_5560169582513450767)],
        ),
        (
            UniCase::ascii("professionalisations"),
            &[(0b10010, &ENTRY_PROFESSIONALIZATIONS_820894818241176416)],
        ),
        (
            UniCase::ascii("repaganizes"),
            &[(0b01001, &ENTRY_REPAGANIZES_9803449503187685243)],
        ),
        (
            UniCase::ascii("dispauperizing"),
            &[(0b01001, &ENTRY_DISPAUPERIZING_17043875401453982735)],
        ),
        (
            UniCase::ascii("hematoxylins"),
            &[(0b11001, &ENTRY_HEMATOXYLINS_9008305718553626994)],
        ),
        (
            UniCase::ascii("eulogized"),
            &[(0b01001, &ENTRY_EULOGIZED_2725015015260591952)],
        ),
        (
            UniCase::ascii("reorganise"),
            &[(0b10010, &ENTRY_REORGANIZE_18181270914612994788)],
        ),
        (
            UniCase::ascii("puebloizes"),
            &[(0b01001, &ENTRY_PUEBLOIZES_16793523394160108027)],
        ),
        (
            UniCase::ascii("ruggedizes"),
            &[(0b01001, &ENTRY_RUGGEDIZES_16648500507504288559)],
        ),
        (
            UniCase::ascii("faitour"),
            &[(0b11010, &ENTRY_FAITOR_14739031312979666111)],
        ),
        (
            UniCase::ascii("northernises"),
            &[(0b10010, &ENTRY_NORTHERNIZES_10191844020334839487)],
        ),
        (
            UniCase::ascii("organisationals"),
            &[(0b10010, &ENTRY_ORGANIZATIONALS_10559236366326509118)],
        ),
        (
            UniCase::ascii("stylising"),
            &[(0b10010, &ENTRY_STYLIZING_9348895301814219487)],
        ),
        (
            UniCase::ascii("intellectualisers"),
            &[(0b10010, &ENTRY_INTELLECTUALIZERS_11392986022853877080)],
        ),
        (
            UniCase::ascii("clamours"),
            &[(0b11010, &ENTRY_CLAMORS_2773887349084725873)],
        ),
        (
            UniCase::ascii("unraveller"),
            &[(0b11010, &ENTRY_UNRAVELER_4944599394654130396)],
        ),
        (
            UniCase::ascii("neoterizing"),
            &[(0b01001, &ENTRY_NEOTERIZING_1718278886797679099)],
        ),
        (
            UniCase::ascii("journalized"),
            &[(0b01001, &ENTRY_JOURNALIZED_9351999491366530812)],
        ),
        (
            UniCase::ascii("marbleize"),
            &[(0b01001, &ENTRY_MARBLEIZE_10560158210625088553)],
        ),
        (
            UniCase::ascii("canisterisation"),
            &[(0b10010, &ENTRY_CANISTERIZATION_9994917120138811095)],
        ),
        (
            UniCase::ascii("theologising"),
            &[(0b10010, &ENTRY_THEOLOGIZING_1522552502275961571)],
        ),
        (
            UniCase::ascii("nonaesthetically"),
            &[(0b11010, &ENTRY_NONESTHETICALLY_7037140941147025824)],
        ),
        (
            UniCase::ascii("avianising"),
            &[(0b10010, &ENTRY_AVIANIZING_14608259848585895347)],
        ),
        (
            UniCase::ascii("overhumanise"),
            &[(0b10010, &ENTRY_OVERHUMANIZE_13455822973320239965)],
        ),
        (
            UniCase::ascii("unorganisablest"),
            &[(0b10010, &ENTRY_UNORGANIZABLEST_13952098891985641540)],
        ),
        (
            UniCase::ascii("uncolonized"),
            &[(0b01001, &ENTRY_UNCOLONIZED_14464259688836318286)],
        ),
        (
            UniCase::ascii("patronizations"),
            &[(0b01001, &ENTRY_PATRONIZATIONS_7552667099953006768)],
        ),
        (
            UniCase::ascii("disauthorizing"),
            &[(0b01001, &ENTRY_DISAUTHORIZING_1506123926769301204)],
        ),
        (
            UniCase::ascii("technicalizes"),
            &[(0b01001, &ENTRY_TECHNICALIZES_5595101189542797653)],
        ),
        (
            UniCase::ascii("consonantises"),
            &[(0b10010, &ENTRY_CONSONANTIZES_1574898332026499098)],
        ),
        (
            UniCase::ascii("fibrises"),
            &[(0b10010, &ENTRY_FIBERIZES_17105028343308432924)],
        ),
        (
            UniCase::ascii("federalisations"),
            &[(0b10010, &ENTRY_FEDERALIZATIONS_16597754848421860206)],
        ),
        (
            UniCase::ascii("unmoralizing"),
            &[(0b01001, &ENTRY_UNMORALIZING_1635343207643393146)],
        ),
        (
            UniCase::ascii("centralized"),
            &[(0b01001, &ENTRY_CENTRALIZED_70126610329667809)],
        ),
        (
            UniCase::ascii("gourmandises"),
            &[(0b10010, &ENTRY_GOURMANDIZES_10961415197081735)],
        ),
        (
            UniCase::ascii("tachypnea"),
            &[(0b00001, &ENTRY_TACHYPNEA_3166922207303436381)],
        ),
        (
            UniCase::ascii("quarterisations"),
            &[(0b10010, &ENTRY_QUARTERIZATIONS_5989124183283298739)],
        ),
        (
            UniCase::ascii("precurrent"),
            &[(0b11010, &ENTRY_PERCURRENT_15522415679210362636)],
        ),
        (
            UniCase::ascii("vectorize"),
            &[(0b01001, &ENTRY_VECTORIZE_13096018160775133343)],
        ),
        (
            UniCase::ascii("micresthete"),
            &[(0b00001, &ENTRY_MICRESTHETE_13540257889635101070)],
        ),
        (
            UniCase::ascii("moralizing"),
            &[(0b01001, &ENTRY_MORALIZING_3926799554184116665)],
        ),
        (
            UniCase::ascii("hydrolyser"),
            &[(0b10010, &ENTRY_HYDROLYZER_7963252770617082917)],
        ),
        (
            UniCase::ascii("favorableness"),
            &[(0b11001, &ENTRY_FAVORABLENESS_15076889136273638786)],
        ),
        (
            UniCase::ascii("popularisations"),
            &[(0b10010, &ENTRY_POPULARIZATIONS_10148778209943335276)],
        ),
        (
            UniCase::ascii("summarisations"),
            &[(0b10010, &ENTRY_SUMMARIZATIONS_6246410965460713485)],
        ),
        (
            UniCase::ascii("vocalization"),
            &[(0b01001, &ENTRY_VOCALIZATION_16299156444456516020)],
        ),
        (
            UniCase::ascii("regulise"),
            &[(0b10010, &ENTRY_REGULIZE_1184324425868079001)],
        ),
        (
            UniCase::ascii("antiseptise"),
            &[(0b10010, &ENTRY_ANTISEPTIZE_3729071818555121770)],
        ),
        (
            UniCase::ascii("tabularizations"),
            &[(0b01001, &ENTRY_TABULARIZATIONS_7435992087915599492)],
        ),
        (
            UniCase::ascii("novelizations"),
            &[(0b01001, &ENTRY_NOVELIZATIONS_10468098323494499586)],
        ),
        (
            UniCase::ascii("marvelousest"),
            &[(0b00001, &ENTRY_MARVELOUSEST_4909905498549424330)],
        ),
        (
            UniCase::ascii("unseculariseddest"),
            &[(0b10010, &ENTRY_UNSECULARIZEDDEST_2864881942285944778)],
        ),
        (
            UniCase::ascii("bushellers"),
            &[(0b11010, &ENTRY_BUSHELERS_15210446479419969885)],
        ),
        (
            UniCase::ascii("gargarised"),
            &[(0b10010, &ENTRY_GARGARIZED_7909042564689432197)],
        ),
        (
            UniCase::ascii("technicise"),
            &[(0b10010, &ENTRY_TECHNICIZE_8212652477507145699)],
        ),
        (
            UniCase::ascii("unmysticize"),
            &[(0b01001, &ENTRY_UNMYSTICIZE_6752614279344741289)],
        ),
        (
            UniCase::ascii("ruggedising"),
            &[(0b10010, &ENTRY_RUGGEDIZING_10631138816687857349)],
        ),
        (
            UniCase::ascii("internalizes"),
            &[(0b01001, &ENTRY_INTERNALIZES_3719150015182585151)],
        ),
        (
            UniCase::ascii("anthologizer"),
            &[(0b01001, &ENTRY_ANTHOLOGIZER_4038135053732224148)],
        ),
        (
            UniCase::ascii("succouring"),
            &[(0b11010, &ENTRY_SUCCORING_11411217915173349617)],
        ),
        (
            UniCase::ascii("consonantising"),
            &[(0b10010, &ENTRY_CONSONANTIZING_13097410576135380735)],
        ),
        (
            UniCase::ascii("diallers"),
            &[(0b11010, &ENTRY_DIALERS_5602259152205050826)],
        ),
        (
            UniCase::ascii("neurocele"),
            &[(0b00001, &ENTRY_NEUROCELE_2114330714669438819)],
        ),
        (
            UniCase::ascii("anoxemia"),
            &[(0b10001, &ENTRY_ANOXEMIA_938996689614149150)],
        ),
        (
            UniCase::ascii("solarise"),
            &[(0b10010, &ENTRY_SOLARIZE_18258216759051483358)],
        ),
        (
            UniCase::ascii("dialed"),
            &[(0b01001, &ENTRY_DIALED_12445554267564800284)],
        ),
        (
            UniCase::ascii("homoeopathy"),
            &[(0b10010, &ENTRY_HOMEOPATHY_15227637772904556345)],
        ),
        (
            UniCase::ascii("overdramatized"),
            &[(0b01001, &ENTRY_OVERDRAMATIZED_5081815422525179522)],
        ),
        (
            UniCase::ascii("preaexistent"),
            &[(0b11010, &ENTRY_PREEXISTENT_5468737224949447194)],
        ),
        (
            UniCase::ascii("unsavouredder"),
            &[(0b11010, &ENTRY_UNSAVOREDDER_9689868158053003438)],
        ),
        (
            UniCase::ascii("unparticularizinger"),
            &[(0b01001, &ENTRY_UNPARTICULARIZINGER_1405745460438104009)],
        ),
        (
            UniCase::ascii("patrialize"),
            &[(0b01001, &ENTRY_PATRIALIZE_9230345548828707773)],
        ),
        (
            UniCase::ascii("utilising"),
            &[(0b10010, &ENTRY_UTILIZING_14247990373114335405)],
        ),
        (
            UniCase::ascii("illegalize"),
            &[(0b01001, &ENTRY_ILLEGALIZE_16625635604289115309)],
        ),
        (
            UniCase::ascii("synonymised"),
            &[(0b10010, &ENTRY_SYNONYMIZED_16655983300964530292)],
        ),
        (
            UniCase::ascii("academize"),
            &[(0b01001, &ENTRY_ACADEMIZE_744429990211461933)],
        ),
        (
            UniCase::ascii("martyrisation"),
            &[(0b10010, &ENTRY_MARTYRIZATION_6155264151450173537)],
        ),
        (
            UniCase::ascii("laminarizing"),
            &[(0b01001, &ENTRY_LAMINARIZING_13590610923176310804)],
        ),
        (
            UniCase::ascii("vegetablizes"),
            &[(0b01001, &ENTRY_VEGETABLIZES_6567628138079375237)],
        ),
        (
            UniCase::ascii("neogaean"),
            &[(0b11010, &ENTRY_NEOGEAN_16331008238049777934)],
        ),
        (
            UniCase::ascii("overemphasise"),
            &[(0b10010, &ENTRY_OVEREMPHASIZE_9555654201029285273)],
        ),
        (
            UniCase::ascii("papalised"),
            &[(0b10010, &ENTRY_PAPALIZED_8860509933771894456)],
        ),
        (
            UniCase::ascii("grovelled"),
            &[(0b11010, &ENTRY_GROVELED_2352401965482255212)],
        ),
        (
            UniCase::ascii("rhinorrhoea"),
            &[(0b11010, &ENTRY_RHINORRHEA_17760754621625220758)],
        ),
        (
            UniCase::ascii("electricizes"),
            &[(0b01001, &ENTRY_ELECTRICIZES_3929185044639312558)],
        ),
        (
            UniCase::ascii("rusticised"),
            &[(0b10010, &ENTRY_RUSTICIZED_8719798803495007326)],
        ),
        (
            UniCase::ascii("worshipper"),
            &[(0b11010, &ENTRY_WORSHIPER_4363374512340886503)],
        ),
        (
            UniCase::ascii("metagrabolise"),
            &[(0b10010, &ENTRY_METAGRABOLIZE_4339239122760344200)],
        ),
        (
            UniCase::ascii("psychologising"),
            &[(0b10010, &ENTRY_PSYCHOLOGIZING_15426494443157713628)],
        ),
        (
            UniCase::ascii("medialises"),
            &[(0b10010, &ENTRY_MEDIALIZES_9158496365414473522)],
        ),
        (
            UniCase::ascii("antagonizing"),
            &[(0b01001, &ENTRY_ANTAGONIZING_7228037109106376861)],
        ),
        (
            UniCase::ascii("psalmodize"),
            &[(0b01001, &ENTRY_PSALMODIZE_6785943915373540400)],
        ),
        (
            UniCase::ascii("hyperinsulinization"),
            &[(0b01001, &ENTRY_HYPERINSULINIZATION_8367048383423792181)],
        ),
        (
            UniCase::ascii("tantalizinglies"),
            &[(0b01001, &ENTRY_TANTALIZINGLIES_5104449786998566308)],
        ),
        (
            UniCase::ascii("prelect"),
            &[(0b00001, &ENTRY_PRELECT_15124133363040005475)],
        ),
        (
            UniCase::ascii("organisabler"),
            &[(0b10010, &ENTRY_ORGANIZABLER_16730726147732418422)],
        ),
        (
            UniCase::ascii("photolysing"),
            &[(0b10010, &ENTRY_PHOTOLYZING_5023754747286858353)],
        ),
        (
            UniCase::ascii("incentivizing"),
            &[(0b01001, &ENTRY_INCENTIVIZING_15493171350741422018)],
        ),
        (
            UniCase::ascii("balladises"),
            &[(0b10010, &ENTRY_BALLADIZES_6866475825533925100)],
        ),
        (
            UniCase::ascii("ecstasized"),
            &[(0b01001, &ENTRY_ECSTASIZED_14433048399656133421)],
        ),
        (
            UniCase::ascii("unionizing"),
            &[(0b01001, &ENTRY_UNIONIZING_13986959004042777567)],
        ),
        (
            UniCase::ascii("gallicizing"),
            &[(0b01001, &ENTRY_GALLICIZING_8856226220615441726)],
        ),
        (
            UniCase::ascii("dualisation"),
            &[(0b10010, &ENTRY_DUALIZATION_297757979352720010)],
        ),
        (
            UniCase::ascii("rebrutalize"),
            &[(0b01001, &ENTRY_REBRUTALIZE_15890308064516958097)],
        ),
        (
            UniCase::ascii("hypothesising"),
            &[(0b10010, &ENTRY_HYPOTHESIZING_17752502848335912546)],
        ),
        (
            UniCase::ascii("rationalisables"),
            &[(0b10010, &ENTRY_RATIONALIZABLES_2843790548240367930)],
        ),
        (
            UniCase::ascii("endamoebas"),
            &[(0b11010, &ENTRY_ENDAMEBAS_3894595978421412160)],
        ),
        (
            UniCase::ascii("nephrocoele"),
            &[(0b11010, &ENTRY_NEPHROCELE_10380393167970214732)],
        ),
        (
            UniCase::ascii("marvellouslier"),
            &[(0b11010, &ENTRY_MARVELOUSLIER_15522555805023104308)],
        ),
        (
            UniCase::ascii("jumboized"),
            &[(0b01001, &ENTRY_JUMBOIZED_9650613673854154599)],
        ),
        (
            UniCase::ascii("pasteurisations"),
            &[(0b10010, &ENTRY_PASTEURIZATIONS_102052595045476495)],
        ),
        (
            UniCase::ascii("unlabialize"),
            &[(0b01001, &ENTRY_UNLABIALIZE_217736053462734651)],
        ),
        (
            UniCase::ascii("somniloquised"),
            &[(0b10010, &ENTRY_SOMNILOQUIZED_11728587916951539904)],
        ),
        (
            UniCase::ascii("hospitalise"),
            &[(0b10010, &ENTRY_HOSPITALIZE_6250395622105373650)],
        ),
        (
            UniCase::ascii("siliconises"),
            &[(0b10010, &ENTRY_SILICONIZES_14042775956262597692)],
        ),
        (
            UniCase::ascii("prestandardizes"),
            &[(0b01001, &ENTRY_PRESTANDARDIZES_9801992665812395054)],
        ),
        (
            UniCase::ascii("phosphatised"),
            &[(0b10010, &ENTRY_PHOSPHATIZED_8578950796519736557)],
        ),
        (
            UniCase::ascii("renormalized"),
            &[(0b01001, &ENTRY_RENORMALIZED_12583163063216549053)],
        ),
        (
            UniCase::ascii("uncolouredness"),
            &[(0b11010, &ENTRY_UNCOLOREDNESS_16507195530617886306)],
        ),
        (
            UniCase::ascii("pedantizing"),
            &[(0b01001, &ENTRY_PEDANTIZING_12101236953723349590)],
        ),
        (
            UniCase::ascii("packetiser"),
            &[(0b10010, &ENTRY_PACKETIZER_16605776441937490688)],
        ),
        (
            UniCase::ascii("cesium"),
            &[(0b11001, &ENTRY_CESIUM_17343129911628596363)],
        ),
        (
            UniCase::ascii("robotize"),
            &[(0b01001, &ENTRY_ROBOTIZE_1822365081322284994)],
        ),
        (
            UniCase::ascii("moults"),
            &[(0b11010, &ENTRY_MOLTS_10499278002715999239)],
        ),
        (
            UniCase::ascii("plebeianizing"),
            &[(0b01001, &ENTRY_PLEBEIANIZING_18092068760405524948)],
        ),
        (
            UniCase::ascii("melitaemia"),
            &[(0b11010, &ENTRY_MELITEMIA_2708409562640762486)],
        ),
        (
            UniCase::ascii("mathematicizes"),
            &[(0b01001, &ENTRY_MATHEMATICIZES_17239793732172029302)],
        ),
        (
            UniCase::ascii("colourway"),
            &[(0b11010, &ENTRY_COLORWAY_14654249147936693420)],
        ),
        (
            UniCase::ascii("paleoherpetologist"),
            &[(0b10001, &ENTRY_PALEOHERPETOLOGIST_2006506636872959347)],
        ),
        (
            UniCase::ascii("sulfate"),
            &[(0b01001, &ENTRY_SULFATE_12734582688668505440)],
        ),
        (
            UniCase::ascii("sympathisinglier"),
            &[(0b10010, &ENTRY_SYMPATHIZINGLIER_17003334067553508909)],
        ),
        (
            UniCase::ascii("preanal"),
            &[(0b00001, &ENTRY_PREANAL_8282447312000633016)],
        ),
        (
            UniCase::ascii("colourable"),
            &[(0b11010, &ENTRY_COLORABLE_9126609110540102083)],
        ),
        (
            UniCase::ascii("egyptise"),
            &[(0b10010, &ENTRY_EGYPTIZE_7334581701121422605)],
        ),
        (
            UniCase::ascii("pseudesthesia"),
            &[(0b00001, &ENTRY_PSEUDESTHESIA_12407767994846061516)],
        ),
        (
            UniCase::ascii("reinitializing"),
            &[(0b01001, &ENTRY_REINITIALIZING_2886046725474516411)],
        ),
        (
            UniCase::ascii("savorers"),
            &[(0b11001, &ENTRY_SAVORERS_11787687508614999748)],
        ),
        (
            UniCase::ascii("anaesthetics"),
            &[(0b11010, &ENTRY_ANESTHETICS_9673867241310151800)],
        ),
        (
            UniCase::ascii("anesthesiologies"),
            &[(0b11001, &ENTRY_ANESTHESIOLOGIES_6679603096569359713)],
        ),
        (
            UniCase::ascii("vermilionises"),
            &[(0b10010, &ENTRY_VERMILIONIZES_12599262771675475462)],
        ),
        (
            UniCase::ascii("rationalizer"),
            &[(0b01001, &ENTRY_RATIONALIZER_6435122838480912496)],
        ),
        (
            UniCase::ascii("methaemoglobin"),
            &[(0b11010, &ENTRY_METHEMOGLOBIN_17726338295789945777)],
        ),
        (
            UniCase::ascii("amouristic"),
            &[(0b11010, &ENTRY_AMORISTIC_9227858452058548163)],
        ),
        (
            UniCase::ascii("recolors"),
            &[(0b10001, &ENTRY_RECOLORS_13250820879245551898)],
        ),
        (
            UniCase::ascii("goe"),
            &[(0b11010, &ENTRY_GE_2544027066948517700)],
        ),
        (
            UniCase::ascii("metaphysicizes"),
            &[(0b01001, &ENTRY_METAPHYSICIZES_8743324838290261598)],
        ),
        (
            UniCase::ascii("appals"),
            &[(0b11010, &ENTRY_APPALLS_20865698290307641)],
        ),
        (
            UniCase::ascii("patronizings"),
            &[(0b01001, &ENTRY_PATRONIZINGS_17625682551925708597)],
        ),
        (
            UniCase::ascii("unionizers"),
            &[(0b01001, &ENTRY_UNIONIZERS_5139286031818390886)],
        ),
        (
            UniCase::ascii("unsepulchers"),
            &[(0b00001, &ENTRY_UNSEPULCHERS_1679319036273540108)],
        ),
        (
            UniCase::ascii("perved"),
            &[(0b00001, &ENTRY_PERVED_18208319127618556214)],
        ),
        (
            UniCase::ascii("unstoicises"),
            &[(0b10010, &ENTRY_UNSTOICIZES_3633881140952142304)],
        ),
        (
            UniCase::ascii("zoecium"),
            &[(0b00001, &ENTRY_ZOECIUM_16562741580002996142)],
        ),
        (
            UniCase::ascii("silicatization"),
            &[(0b01001, &ENTRY_SILICATIZATION_15183159520715497593)],
        ),
        (
            UniCase::ascii("vowelization"),
            &[(0b01001, &ENTRY_VOWELIZATION_989128645335163882)],
        ),
        (
            UniCase::ascii("reenforcing"),
            &[(0b00001, &ENTRY_REINFORCING_9420906960117208611)],
        ),
        (
            UniCase::ascii("superemphasizes"),
            &[(0b01001, &ENTRY_SUPEREMPHASIZES_11905195641762477558)],
        ),
        (
            UniCase::ascii("focalizing"),
            &[(0b01001, &ENTRY_FOCALIZING_4851388567122001857)],
        ),
        (
            UniCase::ascii("apogeic"),
            &[(0b00001, &ENTRY_APOGEIC_10442075832990462520)],
        ),
        (
            UniCase::ascii("spaniardization"),
            &[(0b01001, &ENTRY_SPANIARDIZATION_10902219760262843235)],
        ),
        (
            UniCase::ascii("phoenicopter"),
            &[(0b11010, &ENTRY_PHENICOPTER_102813840191262241)],
        ),
        (
            UniCase::ascii("astera"),
            &[(0b00001, &ENTRY_ASTERA_15037794719691540402)],
        ),
        (
            UniCase::ascii("verbalized"),
            &[(0b01001, &ENTRY_VERBALIZED_3584116992871405343)],
        ),
        (
            UniCase::ascii("glycogenizes"),
            &[(0b01001, &ENTRY_GLYCOGENIZES_8753992975266531652)],
        ),
        (
            UniCase::ascii("petalled"),
            &[(0b11010, &ENTRY_PETALED_67675403619589060)],
        ),
        (
            UniCase::ascii("grueling"),
            &[(0b01001, &ENTRY_GRUELING_4646165576783322871)],
        ),
        (
            UniCase::ascii("unpoetised"),
            &[(0b10010, &ENTRY_UNPOETIZED_2934206354212163480)],
        ),
        (
            UniCase::ascii("anaesthetisation"),
            &[(0b10010, &ENTRY_ANESTHETIZATION_11701429006232412151)],
        ),
        (
            UniCase::ascii("gospelized"),
            &[(0b01001, &ENTRY_GOSPELIZED_8655666473040197182)],
        ),
        (
            UniCase::ascii("glycerinise"),
            &[(0b10010, &ENTRY_GLYCERINIZE_15525365444232192960)],
        ),
        (
            UniCase::ascii("unrancoreddest"),
            &[(0b00001, &ENTRY_UNRANCOREDDEST_16686379430125720872)],
        ),
        (
            UniCase::ascii("dishonorabler"),
            &[(0b11001, &ENTRY_DISHONORABLER_3043788293690199279)],
        ),
        (
            UniCase::ascii("unsymbolizedder"),
            &[(0b01001, &ENTRY_UNSYMBOLIZEDDER_2693121694591055898)],
        ),
        (
            UniCase::ascii("preorganize"),
            &[(0b01001, &ENTRY_PREORGANIZE_15777355745082526626)],
        ),
        (
            UniCase::ascii("normanise"),
            &[(0b10010, &ENTRY_NORMANIZE_16686796116216318913)],
        ),
        (
            UniCase::ascii("granitises"),
            &[(0b10010, &ENTRY_GRANITIZES_5307213501352143475)],
        ),
        (
            UniCase::ascii("taylorises"),
            &[(0b10010, &ENTRY_TAYLORIZES_13244584135122060485)],
        ),
        (
            UniCase::ascii("unparagonizeds"),
            &[(0b01001, &ENTRY_UNPARAGONIZEDS_8828912894163008040)],
        ),
        (
            UniCase::ascii("despiritualization"),
            &[(0b01001, &ENTRY_DESPIRITUALIZATION_9440879345640859842)],
        ),
        (
            UniCase::ascii("oestruate"),
            &[(0b11010, &ENTRY_ESTRUATE_9742423605759945651)],
        ),
        (
            UniCase::ascii("diabolising"),
            &[(0b10010, &ENTRY_DIABOLIZING_17353660640060220296)],
        ),
        (
            UniCase::ascii("flavouriest"),
            &[(0b11010, &ENTRY_FLAVORIEST_6780248413885561418)],
        ),
        (
            UniCase::ascii("futurize"),
            &[(0b01001, &ENTRY_FUTURIZE_7365851347469569206)],
        ),
        (
            UniCase::ascii("nonphosphoriseds"),
            &[(0b10010, &ENTRY_NONPHOSPHORIZEDS_14940949194406297295)],
        ),
        (
            UniCase::ascii("bicolors"),
            &[(0b10001, &ENTRY_BICOLORS_9368006477019357638)],
        ),
        (
            UniCase::ascii("undiphthongizes"),
            &[(0b01001, &ENTRY_UNDIPHTHONGIZES_919729037221686149)],
        ),
        (
            UniCase::ascii("microminiaturisation"),
            &[(0b10010, &ENTRY_MICROMINIATURIZATION_5346373952330274164)],
        ),
        (
            UniCase::ascii("bestialise"),
            &[(0b10010, &ENTRY_BESTIALIZE_3056063670726597576)],
        ),
        (
            UniCase::ascii("exorcizers"),
            &[(0b01001, &ENTRY_EXORCIZERS_15464358492441086034)],
        ),
        (
            UniCase::ascii("fertilisable"),
            &[(0b10010, &ENTRY_FERTILIZABLE_12448840079739843294)],
        ),
        (
            UniCase::ascii("ileocaecal"),
            &[(0b11010, &ENTRY_ILEOCECAL_16783306468594549177)],
        ),
        (
            UniCase::ascii("satirizes"),
            &[(0b01001, &ENTRY_SATIRIZES_10052925778146532918)],
        ),
        (
            UniCase::ascii("dispauperises"),
            &[(0b10010, &ENTRY_DISPAUPERIZES_12194191945308397437)],
        ),
        (
            UniCase::ascii("sulfurizations"),
            &[(0b00001, &ENTRY_SULFURIZATIONS_5474468829338012124)],
        ),
        (
            UniCase::ascii("modularize"),
            &[(0b01001, &ENTRY_MODULARIZE_7661020760191995153)],
        ),
        (
            UniCase::ascii("preorganization"),
            &[(0b01001, &ENTRY_PREORGANIZATION_17672450543180011422)],
        ),
        (
            UniCase::ascii("philippized"),
            &[(0b01001, &ENTRY_PHILIPPIZED_178919350171556335)],
        ),
        (
            UniCase::ascii("mesmerization"),
            &[(0b01001, &ENTRY_MESMERIZATION_8961271965340064710)],
        ),
        (
            UniCase::ascii("taffetized"),
            &[(0b01001, &ENTRY_TAFFETIZED_8007155516688755691)],
        ),
        (
            UniCase::ascii("neoterizes"),
            &[(0b01001, &ENTRY_NEOTERIZES_11131918151181201147)],
        ),
        (
            UniCase::ascii("phenomenize"),
            &[(0b01001, &ENTRY_PHENOMENIZE_9110544169399242876)],
        ),
        (
            UniCase::ascii("amphigaean"),
            &[(0b11010, &ENTRY_AMPHIGEAN_2635547525436752336)],
        ),
        (
            UniCase::ascii("teutonizes"),
            &[(0b01001, &ENTRY_TEUTONIZES_3149749243463447607)],
        ),
        (
            UniCase::ascii("gynaecoid"),
            &[(0b11010, &ENTRY_GYNECOID_2669421810154584267)],
        ),
        (
            UniCase::ascii("platitudinise"),
            &[(0b10010, &ENTRY_PLATITUDINIZE_16047744417590066437)],
        ),
        (
            UniCase::ascii("dialyzes"),
            &[(0b01001, &ENTRY_DIALYZES_9413207522578141113)],
        ),
        (
            UniCase::ascii("microminiaturized"),
            &[(0b01001, &ENTRY_MICROMINIATURIZED_17716034338321519125)],
        ),
        (
            UniCase::ascii("manoeuvre"),
            &[(0b11010, &ENTRY_MANEUVER_5387054599640837575)],
        ),
        (
            UniCase::ascii("lairising"),
            &[(0b10010, &ENTRY_LAIRIZING_4521292118527414337)],
        ),
        (
            UniCase::ascii("vaticanisations"),
            &[(0b10010, &ENTRY_VATICANIZATIONS_15982356743750740824)],
        ),
        (
            UniCase::ascii("sensualize"),
            &[(0b01001, &ENTRY_SENSUALIZE_16925018484398827656)],
        ),
        (
            UniCase::ascii("paleodendrological"),
            &[(0b10001, &ENTRY_PALEODENDROLOGICAL_2041711262884531596)],
        ),
        (
            UniCase::ascii("substerilisation"),
            &[(0b10010, &ENTRY_SUBSTERILIZATION_18359467976046569227)],
        ),
        (
            UniCase::ascii("undramatisable"),
            &[(0b10010, &ENTRY_UNDRAMATIZABLE_16417239684975540746)],
        ),
        (
            UniCase::ascii("semihonors"),
            &[(0b00001, &ENTRY_SEMIHONORS_12462123375978457923)],
        ),
        (
            UniCase::ascii("inferiorize"),
            &[(0b01001, &ENTRY_INFERIORIZE_18055626716137479185)],
        ),
        (
            UniCase::ascii("fluidises"),
            &[(0b10010, &ENTRY_FLUIDIZES_15400536994754984208)],
        ),
        (
            UniCase::ascii("preconizes"),
            &[(0b01001, &ENTRY_PRECONIZES_1119327710154936908)],
        ),
        (
            UniCase::ascii("etheling"),
            &[(0b00001, &ENTRY_ETHELING_7453000440584654761)],
        ),
        (
            UniCase::ascii("rebourbonize"),
            &[(0b01001, &ENTRY_REBOURBONIZE_5261400215839580856)],
        ),
        (
            UniCase::ascii("unmesmerizedder"),
            &[(0b01001, &ENTRY_UNMESMERIZEDDER_2203744214809621680)],
        ),
        (
            UniCase::ascii("nomadizing"),
            &[(0b01001, &ENTRY_NOMADIZING_7146960705248823561)],
        ),
        (
            UniCase::ascii("cocuisa"),
            &[(0b10010, &ENTRY_COCUIZA_6504886933052210304)],
        ),
        (
            UniCase::ascii("parathyroidectomized"),
            &[(0b01001, &ENTRY_PARATHYROIDECTOMIZED_6685949501942941317)],
        ),
        (
            UniCase::ascii("enarbour"),
            &[(0b11010, &ENTRY_ENARBOR_15915857770564812751)],
        ),
        (
            UniCase::ascii("spiritualizations"),
            &[(0b01001, &ENTRY_SPIRITUALIZATIONS_8932729483849010613)],
        ),
        (
            UniCase::ascii("marsupializes"),
            &[(0b01001, &ENTRY_MARSUPIALIZES_14629605414761888268)],
        ),
        (
            UniCase::ascii("neuroepithelium"),
            &[(0b11010, &ENTRY_NEUREPITHELIUM_14522596466559359420)],
        ),
        (
            UniCase::ascii("unmitres"),
            &[(0b11010, &ENTRY_UNMITERS_8651507553417273017)],
        ),
        (
            UniCase::ascii("unoxygenised"),
            &[(0b10010, &ENTRY_UNOXYGENIZED_6875578357957209997)],
        ),
        (
            UniCase::ascii("satinises"),
            &[(0b10010, &ENTRY_SATINIZES_542674649787102689)],
        ),
        (
            UniCase::ascii("haem"),
            &[(0b11010, &ENTRY_HEME_3428853214083440122)],
        ),
        (
            UniCase::ascii("centrelines"),
            &[(0b11010, &ENTRY_CENTERLINES_17943791483589954179)],
        ),
        (
            UniCase::ascii("metabolised"),
            &[(0b10010, &ENTRY_METABOLIZED_13396525183658045150)],
        ),
        (
            UniCase::ascii("funnelling"),
            &[(0b11010, &ENTRY_FUNNELING_7298662514265886848)],
        ),
        (
            UniCase::ascii("moustache"),
            &[(0b11010, &ENTRY_MUSTACHE_10319903289050174029)],
        ),
        (
            UniCase::ascii("hypesthesia"),
            &[(0b10001, &ENTRY_HYPESTHESIA_14564732207680543956)],
        ),
        (
            UniCase::ascii("revelationizes"),
            &[(0b01001, &ENTRY_REVELATIONIZES_5374780340001639912)],
        ),
        (
            UniCase::ascii("presbyterianise"),
            &[(0b10010, &ENTRY_PRESBYTERIANIZE_8184517241649663285)],
        ),
        (
            UniCase::ascii("monestrous"),
            &[(0b00001, &ENTRY_MONESTROUS_18265353223508436919)],
        ),
        (
            UniCase::ascii("geometrisation"),
            &[(0b10010, &ENTRY_GEOMETRIZATION_1547434209754062568)],
        ),
        (
            UniCase::ascii("organizational"),
            &[(0b01001, &ENTRY_ORGANIZATIONAL_11623270165270540295)],
        ),
        (
            UniCase::ascii("palaeozoologist"),
            &[(0b11010, &ENTRY_PALEOZOOLOGIST_18146472512848833302)],
        ),
        (
            UniCase::ascii("diabolisation"),
            &[(0b10010, &ENTRY_DIABOLIZATION_8147427661526738727)],
        ),
        (
            UniCase::ascii("sequentialise"),
            &[(0b10010, &ENTRY_SEQUENTIALIZE_7687249845236795)],
        ),
        (
            UniCase::ascii("theatricalise"),
            &[(0b10010, &ENTRY_THEATRICALIZE_7863949736369468171)],
        ),
        (
            UniCase::ascii("gentilisation"),
            &[(0b10010, &ENTRY_GENTILIZATION_3445514503508341831)],
        ),
        (
            UniCase::ascii("depoliticizing"),
            &[(0b01001, &ENTRY_DEPOLITICIZING_7335312451906636158)],
        ),
        (
            UniCase::ascii("paragraphize"),
            &[(0b01001, &ENTRY_PARAGRAPHIZE_15316990182254058602)],
        ),
        (
            UniCase::ascii("tuberculised"),
            &[(0b10010, &ENTRY_TUBERCULIZED_10329102836270681912)],
        ),
        (
            UniCase::ascii("illegitimatised"),
            &[(0b10010, &ENTRY_ILLEGITIMATIZED_9298797108128630594)],
        ),
        (
            UniCase::ascii("fossae"),
            &[(0b11010, &ENTRY_FOSSE_13143491485595457015)],
        ),
        (
            UniCase::ascii("sympathiser"),
            &[(0b10010, &ENTRY_SYMPATHIZER_6062465131842187171)],
        ),
        (
            UniCase::ascii("metre"),
            &[(0b11010, &ENTRY_METER_16566716494062015891)],
        ),
        (
            UniCase::ascii("potentialise"),
            &[(0b10010, &ENTRY_POTENTIALIZE_5306242383006066570)],
        ),
        (
            UniCase::ascii("dishonourers"),
            &[(0b11010, &ENTRY_DISHONORERS_16218792927597703675)],
        ),
        (
            UniCase::ascii("decolonizes"),
            &[(0b01001, &ENTRY_DECOLONIZES_17529571225109301692)],
        ),
        (
            UniCase::ascii("editorializer"),
            &[(0b01001, &ENTRY_EDITORIALIZER_907841174282390671)],
        ),
        (
            UniCase::ascii("mathematicized"),
            &[(0b01001, &ENTRY_MATHEMATICIZED_2954775980735308228)],
        ),
        (
            UniCase::ascii("flannelling"),
            &[(0b11010, &ENTRY_FLANNELING_11086853821529088619)],
        ),
        (
            UniCase::ascii("lignitise"),
            &[(0b10010, &ENTRY_LIGNITIZE_1767530194184708816)],
        ),
        (
            UniCase::ascii("sherardizes"),
            &[(0b01001, &ENTRY_SHERARDIZES_5495265908461761242)],
        ),
        (
            UniCase::ascii("ultrahonourable"),
            &[(0b11010, &ENTRY_ULTRAHONORABLE_17802324312727593194)],
        ),
        (
            UniCase::ascii("photosensitise"),
            &[(0b10010, &ENTRY_PHOTOSENSITIZE_8288914178365456711)],
        ),
        (
            UniCase::ascii("revolutionizer"),
            &[(0b01001, &ENTRY_REVOLUTIONIZER_13149778382986804291)],
        ),
        (
            UniCase::ascii("archeology"),
            &[(0b11001, &ENTRY_ARCHAEOLOGY_4126503997832873296)],
        ),
        (
            UniCase::ascii("maiger"),
            &[(0b00001, &ENTRY_MAIGER_14271708748030342793)],
        ),
        (
            UniCase::ascii("diarrhoeicer"),
            &[(0b11010, &ENTRY_DIARRHEICER_15169580495143503922)],
        ),
        (
            UniCase::ascii("magnetizability"),
            &[(0b01001, &ENTRY_MAGNETIZABILITY_15941565557987915165)],
        ),
        (
            UniCase::ascii("outclamour"),
            &[(0b11010, &ENTRY_OUTCLAMOR_12156695162252037981)],
        ),
        (
            UniCase::ascii("paedagogism"),
            &[(0b11010, &ENTRY_PEDAGOGISM_2620385797924030298)],
        ),
        (
            UniCase::ascii("nonvolatiliseds"),
            &[(0b10010, &ENTRY_NONVOLATILIZEDS_5921558007608409082)],
        ),
        (
            UniCase::ascii("incognizant"),
            &[(0b01001, &ENTRY_INCOGNIZANT_10246562813251688993)],
        ),
        (
            UniCase::ascii("homologises"),
            &[(0b10010, &ENTRY_HOMOLOGIZES_9606957905590841740)],
        ),
        (
            UniCase::ascii("gynaecologicaler"),
            &[(0b10010, &ENTRY_GYNECOLOGICALER_3649621888054805329)],
        ),
        (
            UniCase::ascii("equalizing"),
            &[(0b01001, &ENTRY_EQUALIZING_14679492934035290518)],
        ),
        (
            UniCase::ascii("hemihypesthesia"),
            &[(0b00001, &ENTRY_HEMIHYPESTHESIA_15185944125713437083)],
        ),
        (
            UniCase::ascii("epistolises"),
            &[(0b10010, &ENTRY_EPISTOLIZES_12529001542994955479)],
        ),
        (
            UniCase::ascii("gessoes"),
            &[(0b11010, &ENTRY_GESSES_9447403161510644444)],
        ),
        (
            UniCase::ascii("graphitising"),
            &[(0b10010, &ENTRY_GRAPHITIZING_12925962006333789717)],
        ),
        (
            UniCase::ascii("lunule"),
            &[(0b00001, &ENTRY_LUNULE_13057287095940975866)],
        ),
        (
            UniCase::ascii("pedantise"),
            &[(0b10010, &ENTRY_PEDANTIZE_692434760472693565)],
        ),
        (
            UniCase::ascii("theosophize"),
            &[(0b01001, &ENTRY_THEOSOPHIZE_7321146857183593825)],
        ),
        (
            UniCase::ascii("zonule"),
            &[(0b00001, &ENTRY_ZONULE_1425795093078962568)],
        ),
        (
            UniCase::ascii("proverbialising"),
            &[(0b10010, &ENTRY_PROVERBIALIZING_16662355151354609960)],
        ),
        (
            UniCase::ascii("immobilizer"),
            &[(0b01001, &ENTRY_IMMOBILIZER_10527563302868891526)],
        ),
        (
            UniCase::ascii("scenarizing"),
            &[(0b01001, &ENTRY_SCENARIZING_4139993347505235123)],
        ),
        (
            UniCase::ascii("ungentlemanise"),
            &[(0b10010, &ENTRY_UNGENTLEMANIZE_6616841421363856905)],
        ),
        (
            UniCase::ascii("underprises"),
            &[(0b10010, &ENTRY_UNDERPRIZES_6377465244834486670)],
        ),
        (
            UniCase::ascii("jacobinization"),
            &[(0b01001, &ENTRY_JACOBINIZATION_13248835767295513863)],
        ),
        (
            UniCase::ascii("radiosensitize"),
            &[(0b01001, &ENTRY_RADIOSENSITIZE_493147068573479374)],
        ),
        (
            UniCase::ascii("disnaturalised"),
            &[(0b10010, &ENTRY_DISNATURALIZED_5916107255821231797)],
        ),
        (
            UniCase::ascii("poetised"),
            &[(0b10010, &ENTRY_POETIZED_1386961114003301059)],
        ),
        (
            UniCase::ascii("interjectionalises"),
            &[(0b10010, &ENTRY_INTERJECTIONALIZES_13914305345512718530)],
        ),
        (
            UniCase::ascii("panegyrises"),
            &[(0b10010, &ENTRY_PANEGYRIZES_11019653756667579465)],
        ),
        (
            UniCase::ascii("decivilize"),
            &[(0b01001, &ENTRY_DECIVILIZE_16580511735338840581)],
        ),
        (
            UniCase::ascii("undenominationalizes"),
            &[(0b01001, &ENTRY_UNDENOMINATIONALIZES_3120796019381704993)],
        ),
        (
            UniCase::ascii("synthesise"),
            &[(0b10010, &ENTRY_SYNTHESIZE_12262264416656123255)],
        ),
        (
            UniCase::ascii("hemal"),
            &[(0b10001, &ENTRY_HEMAL_8174621070613039824)],
        ),
        (
            UniCase::ascii("paleocyclic"),
            &[(0b10001, &ENTRY_PALEOCYCLIC_1891041371707085992)],
        ),
        (
            UniCase::ascii("gambolled"),
            &[(0b11010, &ENTRY_GAMBOLED_11853362628222994576)],
        ),
        (
            UniCase::ascii("lusterware"),
            &[(0b00001, &ENTRY_LUSTERWARE_7714995265583039919)],
        ),
        (
            UniCase::ascii("anglicise"),
            &[(0b10010, &ENTRY_ANGLICIZE_3954997619999275868)],
        ),
        (
            UniCase::ascii("gonorrhoealest"),
            &[(0b10010, &ENTRY_GONORRHEALEST_7581818766613734397)],
        ),
        (
            UniCase::ascii("rumored"),
            &[(0b11001, &ENTRY_RUMORED_18309275267346665123)],
        ),
        (
            UniCase::ascii("unsatirizedder"),
            &[(0b01001, &ENTRY_UNSATIRIZEDDER_11457550322600274631)],
        ),
        (
            UniCase::ascii("scotticize"),
            &[(0b01001, &ENTRY_SCOTTICIZE_17245280330015663168)],
        ),
        (
            UniCase::ascii("autolyzed"),
            &[(0b01001, &ENTRY_AUTOLYZED_17033910730696642695)],
        ),
        (
            UniCase::ascii("prerealizations"),
            &[(0b01001, &ENTRY_PREREALIZATIONS_7749496154695447428)],
        ),
        (
            UniCase::ascii("hyperimmunises"),
            &[(0b10010, &ENTRY_HYPERIMMUNIZES_18311239313571916578)],
        ),
        (
            UniCase::ascii("overemphasize"),
            &[(0b01001, &ENTRY_OVEREMPHASIZE_9555654201029285273)],
        ),
        (
            UniCase::ascii("lingualizes"),
            &[(0b01001, &ENTRY_LINGUALIZES_11625557214170052581)],
        ),
        (
            UniCase::ascii("sterilising"),
            &[(0b10010, &ENTRY_STERILIZING_14742234573275089575)],
        ),
        (
            UniCase::ascii("menad"),
            &[(0b00001, &ENTRY_MAENAD_6687371101734029319)],
        ),
        (
            UniCase::ascii("offencelessly"),
            &[(0b11010, &ENTRY_OFFENSELESSLY_8614532241535438605)],
        ),
        (
            UniCase::ascii("emblematizes"),
            &[(0b01001, &ENTRY_EMBLEMATIZES_2053946387275416277)],
        ),
        (
            UniCase::ascii("texturizes"),
            &[(0b01001, &ENTRY_TEXTURIZES_9031143232768038726)],
        ),
        (
            UniCase::ascii("oxidisations"),
            &[(0b10010, &ENTRY_OXIDIZATIONS_18384605206557692188)],
        ),
        (
            UniCase::ascii("hurricanise"),
            &[(0b10010, &ENTRY_HURRICANIZE_11443075877213865736)],
        ),
        (
            UniCase::ascii("sycophantise"),
            &[(0b10010, &ENTRY_SYCOPHANTIZE_12413841667742806235)],
        ),
        (
            UniCase::ascii("desulphurizers"),
            &[(0b01001, &ENTRY_DESULPHURIZERS_282853998000810658)],
        ),
        (
            UniCase::ascii("tammanyise"),
            &[(0b10010, &ENTRY_TAMMANYIZE_10524041228496510264)],
        ),
        (
            UniCase::ascii("radialisation"),
            &[(0b10010, &ENTRY_RADIALIZATION_15909242338822109844)],
        ),
        (
            UniCase::ascii("unsympathizables"),
            &[(0b01001, &ENTRY_UNSYMPATHIZABLES_6750873272065181147)],
        ),
        (
            UniCase::ascii("modularise"),
            &[(0b10010, &ENTRY_MODULARIZE_7661020760191995153)],
        ),
        (
            UniCase::ascii("cutinizations"),
            &[(0b01001, &ENTRY_CUTINIZATIONS_17168596603659079378)],
        ),
        (
            UniCase::ascii("crenellate"),
            &[(0b11010, &ENTRY_CRENELATE_4846628544233188866)],
        ),
        (
            UniCase::ascii("gey"),
            &[(0b00001, &ENTRY_GEY_16134682750611747069)],
        ),
        (
            UniCase::ascii("synchronization"),
            &[(0b01001, &ENTRY_SYNCHRONIZATION_5190235443366915825)],
        ),
        (
            UniCase::ascii("temporalised"),
            &[(0b10010, &ENTRY_TEMPORALIZED_9346139556114175316)],
        ),
        (
            UniCase::ascii("relativisations"),
            &[(0b10010, &ENTRY_RELATIVIZATIONS_1630960536153392856)],
        ),
        (
            UniCase::ascii("criticizinglier"),
            &[(0b01001, &ENTRY_CRITICIZINGLIER_5644837899795371316)],
        ),
        (
            UniCase::ascii("bourds"),
            &[(0b11010, &ENTRY_BORDS_7324219903916101004)],
        ),
        (
            UniCase::ascii("euphemizing"),
            &[(0b01001, &ENTRY_EUPHEMIZING_14044452417298877788)],
        ),
        (
            UniCase::ascii("uncircularized"),
            &[(0b01001, &ENTRY_UNCIRCULARIZED_1673876733486569108)],
        ),
        (
            UniCase::ascii("gae"),
            &[(0b11010, &ENTRY_GE_12788931716494377180)],
        ),
        (
            UniCase::ascii("banalizes"),
            &[(0b01001, &ENTRY_BANALIZES_18046806542989340297)],
        ),
        (
            UniCase::ascii("outhyperbolize"),
            &[(0b01001, &ENTRY_OUTHYPERBOLIZE_3971022545298044678)],
        ),
        (
            UniCase::ascii("diagonalization"),
            &[(0b01001, &ENTRY_DIAGONALIZATION_17906612353739944122)],
        ),
        (
            UniCase::ascii("iodizes"),
            &[(0b01001, &ENTRY_IODIZES_4704571112577733661)],
        ),
        (
            UniCase::ascii("panegyrised"),
            &[(0b10010, &ENTRY_PANEGYRIZED_2757369675942335026)],
        ),
        (
            UniCase::ascii("sectorizing"),
            &[(0b01001, &ENTRY_SECTORIZING_8533377571217926271)],
        ),
        (
            UniCase::ascii("endamebas"),
            &[(0b00001, &ENTRY_ENDAMEBAS_3894595978421412160)],
        ),
        (
            UniCase::ascii("verbalization"),
            &[(0b01001, &ENTRY_VERBALIZATION_1606887602703040047)],
        ),
        (
            UniCase::ascii("ardors"),
            &[(0b11001, &ENTRY_ARDORS_13859299160898289371)],
        ),
        (
            UniCase::ascii("unoxygeniseds"),
            &[(0b10010, &ENTRY_UNOXYGENIZEDS_14660262551929716023)],
        ),
        (
            UniCase::ascii("ruggedisations"),
            &[(0b10010, &ENTRY_RUGGEDIZATIONS_632588497204849835)],
        ),
        (
            UniCase::ascii("flavoursomer"),
            &[(0b11010, &ENTRY_FLAVORSOMER_14092054357849095537)],
        ),
        (
            UniCase::ascii("thermosiphon"),
            &[(0b00001, &ENTRY_THERMOSIPHON_9621111130028620625)],
        ),
        (
            UniCase::ascii("pediatrics"),
            &[(0b11001, &ENTRY_PEDIATRICS_13936732030428661587)],
        ),
        (
            UniCase::ascii("disembowelling"),
            &[(0b11010, &ENTRY_DISEMBOWELING_1397333253900455739)],
        ),
        (
            UniCase::ascii("perchlorethane"),
            &[(0b00001, &ENTRY_PERCHLORETHANE_6974667202987518966)],
        ),
        (
            UniCase::ascii("uncriticizable"),
            &[(0b01001, &ENTRY_UNCRITICIZABLE_11373327800791333419)],
        ),
        (
            UniCase::ascii("characterisables"),
            &[(0b10010, &ENTRY_CHARACTERIZABLES_15907805406605774252)],
        ),
        (
            UniCase::ascii("scotticized"),
            &[(0b01001, &ENTRY_SCOTTICIZED_9176139469703286390)],
        ),
        (
            UniCase::ascii("coeducationalises"),
            &[(0b10010, &ENTRY_COEDUCATIONALIZES_6378010748334869944)],
        ),
        (
            UniCase::ascii("flamboyantises"),
            &[(0b10010, &ENTRY_FLAMBOYANTIZES_13178578745419937978)],
        ),
        (
            UniCase::ascii("paganisers"),
            &[(0b10010, &ENTRY_PAGANIZERS_2218453433509959012)],
        ),
        (
            UniCase::ascii("nonnitrogenizeds"),
            &[(0b01001, &ENTRY_NONNITROGENIZEDS_725125946102913048)],
        ),
        (
            UniCase::ascii("finalize"),
            &[(0b01001, &ENTRY_FINALIZE_7368891692414429008)],
        ),
        (
            UniCase::ascii("remagnetizes"),
            &[(0b01001, &ENTRY_REMAGNETIZES_11510663723565945487)],
        ),
        (
            UniCase::ascii("synoetic"),
            &[(0b11010, &ENTRY_SYNETIC_11062609274567880634)],
        ),
        (
            UniCase::ascii("hematocrits"),
            &[(0b10001, &ENTRY_HEMATOCRITS_11851859531643542564)],
        ),
        (
            UniCase::ascii("unsympathisingest"),
            &[(0b10010, &ENTRY_UNSYMPATHIZINGEST_13474971300491840553)],
        ),
        (
            UniCase::ascii("meline"),
            &[(0b00001, &ENTRY_MELINE_10641747453274309529)],
        ),
        (
            UniCase::ascii("regularise"),
            &[(0b10010, &ENTRY_REGULARIZE_7969176896988982612)],
        ),
        (
            UniCase::ascii("unfertilising"),
            &[(0b10010, &ENTRY_UNFERTILIZING_18219334417771825481)],
        ),
        (
            UniCase::ascii("granulizes"),
            &[(0b01001, &ENTRY_GRANULIZES_14251558873025935098)],
        ),
        (
            UniCase::ascii("monarchize"),
            &[(0b01001, &ENTRY_MONARCHIZE_15594788008045550047)],
        ),
        (
            UniCase::ascii("paedology"),
            &[(0b11010, &ENTRY_PEDOLOGY_3417988831421593040)],
        ),
        (
            UniCase::ascii("pythagoreanize"),
            &[(0b01001, &ENTRY_PYTHAGOREANIZE_8350121642033180635)],
        ),
        (
            UniCase::ascii("photolabelling"),
            &[(0b11010, &ENTRY_PHOTOLABELING_12804494872614821285)],
        ),
        (
            UniCase::ascii("jailors"),
            &[(0b01001, &ENTRY_JAILERS_2346423461770093206)],
        ),
        (
            UniCase::ascii("gluttonises"),
            &[(0b10010, &ENTRY_GLUTTONIZES_15763514001401508118)],
        ),
        (
            UniCase::ascii("cozied"),
            &[(0b01001, &ENTRY_COZIED_892102520341074320)],
        ),
        (
            UniCase::ascii("solutisers"),
            &[(0b10010, &ENTRY_SOLUTIZERS_16598006390430358557)],
        ),
        (
            UniCase::ascii("catholicizations"),
            &[(0b01001, &ENTRY_CATHOLICIZATIONS_8828933916874627488)],
        ),
        (
            UniCase::ascii("colourblind"),
            &[(0b11010, &ENTRY_COLORBLIND_6088870633188592041)],
        ),
        (
            UniCase::ascii("aphereses"),
            &[(0b10001, &ENTRY_APHERESES_873005030036232707)],
        ),
        (
            UniCase::ascii("agnizes"),
            &[(0b01001, &ENTRY_AGNIZES_14381052475043058703)],
        ),
        (
            UniCase::ascii("sassanidae"),
            &[(0b11010, &ENTRY_SASSANIDE_5335894015828476896)],
        ),
        (
            UniCase::ascii("similized"),
            &[(0b01001, &ENTRY_SIMILIZED_10847342221820288097)],
        ),
        (
            UniCase::ascii("nonstylised"),
            &[(0b10010, &ENTRY_NONSTYLIZED_11878483916633075909)],
        ),
        (
            UniCase::ascii("revitalize"),
            &[(0b01001, &ENTRY_REVITALIZE_193715103532234630)],
        ),
        (
            UniCase::ascii("pedometrical"),
            &[(0b00001, &ENTRY_PEDOMETRICAL_11798284037226839595)],
        ),
        (
            UniCase::ascii("coloradan"),
            &[(0b00001, &ENTRY_COLORADAN_1710087118093866996)],
        ),
        (
            UniCase::ascii("phenogenesis"),
            &[(0b00001, &ENTRY_PHENOGENESIS_17567829228271993340)],
        ),
        (
            UniCase::ascii("uncolorednesses"),
            &[(0b00001, &ENTRY_UNCOLOREDNESSES_7712224291050878796)],
        ),
        (
            UniCase::ascii("peraeopods"),
            &[(0b11010, &ENTRY_PEREOPODS_14626696459269814659)],
        ),
        (
            UniCase::ascii("persicise"),
            &[(0b10010, &ENTRY_PERSICIZE_9817820256246452496)],
        ),
        (
            UniCase::ascii("generalisables"),
            &[(0b10010, &ENTRY_GENERALIZABLES_5230645008689603385)],
        ),
        (
            UniCase::ascii("immoralizes"),
            &[(0b01001, &ENTRY_IMMORALIZES_2840645599967765235)],
        ),
        (
            UniCase::ascii("paederasts"),
            &[(0b11010, &ENTRY_PEDERASTS_10300182548635094556)],
        ),
        (
            UniCase::ascii("savourlesser"),
            &[(0b11010, &ENTRY_SAVORLESSER_15665106123472425180)],
        ),
        (
            UniCase::ascii("pouldre"),
            &[(0b11010, &ENTRY_POULDER_6920280469594748753)],
        ),
        (
            UniCase::ascii("moustached"),
            &[(0b11010, &ENTRY_MUSTACHED_2206075060724165943)],
        ),
        (
            UniCase::ascii("puritanising"),
            &[(0b10010, &ENTRY_PURITANIZING_2268731325006525499)],
        ),
        (
            UniCase::ascii("devocalising"),
            &[(0b10010, &ENTRY_DEVOCALIZING_540893798000083473)],
        ),
        (
            UniCase::ascii("pauperizer"),
            &[(0b01001, &ENTRY_PAUPERIZER_17515758464001019002)],
        ),
        (
            UniCase::ascii("mediaevalism"),
            &[(0b11010, &ENTRY_MEDIEVALISM_7626307190061100596)],
        ),
        (
            UniCase::ascii("syllogizations"),
            &[(0b01001, &ENTRY_SYLLOGIZATIONS_1183019196317532349)],
        ),
        (
            UniCase::ascii("winterization"),
            &[(0b01001, &ENTRY_WINTERIZATION_7645598477678155456)],
        ),
        (
            UniCase::ascii("pedobaptism"),
            &[(0b00001, &ENTRY_PEDOBAPTISM_10804678125904355110)],
        ),
        (
            UniCase::ascii("desilverisations"),
            &[(0b10010, &ENTRY_DESILVERIZATIONS_3476812538372816382)],
        ),
        (
            UniCase::ascii("sermonizers"),
            &[(0b01001, &ENTRY_SERMONIZERS_10627211662032897475)],
        ),
        (
            UniCase::ascii("diamondise"),
            &[(0b10010, &ENTRY_DIAMONDIZE_974653197096494091)],
        ),
        (
            UniCase::ascii("pericopae"),
            &[(0b11010, &ENTRY_PERICOPE_2464029041518638801)],
        ),
        (
            UniCase::ascii("intercrystallizations"),
            &[(0b01001, &ENTRY_INTERCRYSTALLIZATIONS_15715918494142587543)],
        ),
        (
            UniCase::ascii("lacklustrest"),
            &[(0b11010, &ENTRY_LACKLUSTERREST_17124785842338778470)],
        ),
        (
            UniCase::ascii("uncanonizes"),
            &[(0b01001, &ENTRY_UNCANONIZES_12153715475418673041)],
        ),
        (
            UniCase::ascii("outcaviling"),
            &[(0b00001, &ENTRY_OUTCAVILING_15276360952144069881)],
        ),
        (
            UniCase::ascii("synoecize"),
            &[(0b01001, &ENTRY_SYNOECIZE_9903365931663314390)],
        ),
        (
            UniCase::ascii("itemises"),
            &[(0b10010, &ENTRY_ITEMIZES_10919132215830907409)],
        ),
        (
            UniCase::ascii("palatalizing"),
            &[(0b01001, &ENTRY_PALATALIZING_3515198110356997816)],
        ),
        (
            UniCase::ascii("graecizes"),
            &[(0b01001, &ENTRY_GRAECIZES_18067197401205415693)],
        ),
        (
            UniCase::ascii("anthoecology"),
            &[(0b11010, &ENTRY_ANTHECOLOGY_3713437946183115906)],
        ),
        (
            UniCase::ascii("unnaturalizable"),
            &[(0b01001, &ENTRY_UNNATURALIZABLE_11245054765720939783)],
        ),
        (
            UniCase::ascii("unsombre"),
            &[(0b11010, &ENTRY_UNSOMBER_9849015273292267538)],
        ),
        (
            UniCase::ascii("disscepter"),
            &[(0b00001, &ENTRY_DISSCEPTER_9219896270222345750)],
        ),
        (
            UniCase::ascii("inflexion"),
            &[(0b10010, &ENTRY_INFLECTION_13441227020426228543)],
        ),
        (
            UniCase::ascii("electricalise"),
            &[(0b10010, &ENTRY_ELECTRICALIZE_12653348063928720225)],
        ),
        (
            UniCase::ascii("pyritisations"),
            &[(0b10010, &ENTRY_PYRITIZATIONS_190433604980286404)],
        ),
        (
            UniCase::ascii("enthronize"),
            &[(0b01001, &ENTRY_ENTHRONIZE_8479472121396981406)],
        ),
        (
            UniCase::ascii("epicoele"),
            &[(0b11010, &ENTRY_EPICELE_12455055708908810351)],
        ),
        (
            UniCase::ascii("gynaecomastia"),
            &[(0b11010, &ENTRY_GYNECOMASTIA_3933758254422394945)],
        ),
        (
            UniCase::ascii("signalizes"),
            &[(0b01001, &ENTRY_SIGNALIZES_15183847864880876512)],
        ),
        (
            UniCase::ascii("diestrus"),
            &[(0b10001, &ENTRY_DIESTRUS_10065397832891326590)],
        ),
        (
            UniCase::ascii("deodorizing"),
            &[(0b01001, &ENTRY_DEODORIZING_12515361627952335019)],
        ),
        (
            UniCase::ascii("unrealize"),
            &[(0b01001, &ENTRY_UNREALIZE_13658903213229006471)],
        ),
        (
            UniCase::ascii("unsympathizabilities"),
            &[(0b01001, &ENTRY_UNSYMPATHIZABILITIES_5599344496922194828)],
        ),
        (
            UniCase::ascii("keratinizing"),
            &[(0b01001, &ENTRY_KERATINIZING_15375186798258678468)],
        ),
        (
            UniCase::ascii("despatched"),
            &[(0b10011, &ENTRY_DISPATCHED_15382141028599285955)],
        ),
        (
            UniCase::ascii("cyclized"),
            &[(0b01001, &ENTRY_CYCLIZED_9753759946426964794)],
        ),
        (
            UniCase::ascii("honourableships"),
            &[(0b11010, &ENTRY_HONORABLESHIPS_17263052691602698851)],
        ),
        (
            UniCase::ascii("reorganisers"),
            &[(0b10010, &ENTRY_REORGANIZERS_9885992780785484737)],
        ),
        (
            UniCase::ascii("canoniser"),
            &[(0b10010, &ENTRY_CANONIZER_17140136837292538642)],
        ),
        (
            UniCase::ascii("unauthoriseddest"),
            &[(0b10010, &ENTRY_UNAUTHORIZEDDEST_5230199240119912096)],
        ),
        (
            UniCase::ascii("plagiarised"),
            &[(0b10010, &ENTRY_PLAGIARIZED_12321658142956326932)],
        ),
        (
            UniCase::ascii("mendelise"),
            &[(0b10010, &ENTRY_MENDELIZE_13155598837739586689)],
        ),
        (
            UniCase::ascii("coralled"),
            &[(0b11010, &ENTRY_CORALED_17029032369203888932)],
        ),
        (
            UniCase::ascii("hovellers"),
            &[(0b11010, &ENTRY_HOVELERS_13219825849431143741)],
        ),
        (
            UniCase::ascii("pretorius"),
            &[(0b00001, &ENTRY_PRETORIUS_278833463846710853)],
        ),
        (
            UniCase::ascii("precriticizes"),
            &[(0b01001, &ENTRY_PRECRITICIZES_15135281493768452751)],
        ),
        (
            UniCase::ascii("ghettoize"),
            &[(0b01001, &ENTRY_GHETTOIZE_8424380127281823491)],
        ),
        (
            UniCase::ascii("synoecizing"),
            &[(0b01001, &ENTRY_SYNOECIZING_12619177850029321994)],
        ),
        (
            UniCase::ascii("hotelisation"),
            &[(0b10010, &ENTRY_HOTELIZATION_11630362029882906887)],
        ),
        (
            UniCase::ascii("propylitized"),
            &[(0b01001, &ENTRY_PROPYLITIZED_8590898197469215076)],
        ),
        (
            UniCase::ascii("pragmatisations"),
            &[(0b10010, &ENTRY_PRAGMATIZATIONS_1347693305826589779)],
        ),
        (
            UniCase::ascii("overjudgment"),
            &[(0b00001, &ENTRY_OVERJUDGMENT_12325219415629312934)],
        ),
        (
            UniCase::ascii("theologise"),
            &[(0b10010, &ENTRY_THEOLOGIZE_7414032072871637264)],
        ),
        (
            UniCase::ascii("historicises"),
            &[(0b10010, &ENTRY_HISTORICIZES_9252360923584277113)],
        ),
        (
            UniCase::ascii("classicalize"),
            &[(0b01001, &ENTRY_CLASSICALIZE_7168633238933548715)],
        ),
        (
            UniCase::ascii("egyptianising"),
            &[(0b10010, &ENTRY_EGYPTIANIZING_14447728275835277106)],
        ),
        (
            UniCase::ascii("militarise"),
            &[(0b10010, &ENTRY_MILITARIZE_8711049019051151425)],
        ),
        (
            UniCase::ascii("underrealize"),
            &[(0b01001, &ENTRY_UNDERREALIZE_7092158884515094974)],
        ),
        (
            UniCase::ascii("hatchelled"),
            &[(0b11010, &ENTRY_HATCHELED_833142746170795775)],
        ),
        (
            UniCase::ascii("hyperinsulinisation"),
            &[(0b10010, &ENTRY_HYPERINSULINIZATION_8367048383423792181)],
        ),
        (
            UniCase::ascii("chile"),
            &[(0b01001, &ENTRY_CHILI_17288123216260222064)],
        ),
        (
            UniCase::ascii("uncenter"),
            &[(0b00001, &ENTRY_UNCENTER_15807123308053109883)],
        ),
        (
            UniCase::ascii("cryptaesthesias"),
            &[(0b11010, &ENTRY_CRYPTESTHESIAS_13878578396343060203)],
        ),
        (
            UniCase::ascii("watercoloured"),
            &[(0b11010, &ENTRY_WATERCOLORED_6965422467906206000)],
        ),
        (
            UniCase::ascii("perdiligent"),
            &[(0b00001, &ENTRY_PERDILIGENT_5349792271361198811)],
        ),
        (
            UniCase::ascii("baeyer"),
            &[(0b11010, &ENTRY_BEYER_14898169439752870815)],
        ),
        (
            UniCase::ascii("teasellings"),
            &[(0b00001, &ENTRY_TEASELINGS_10604239368842442956)],
        ),
        (
            UniCase::ascii("tranquillisings"),
            &[(0b11010, &ENTRY_TRANQUILIZINGS_2266773302059369088)],
        ),
        (
            UniCase::ascii("ghettoisations"),
            &[(0b10010, &ENTRY_GHETTOIZATIONS_4010150485854957474)],
        ),
        (
            UniCase::ascii("cavilling"),
            &[(0b11010, &ENTRY_CAVILING_3938684952444630623)],
        ),
        (
            UniCase::ascii("perilling"),
            &[(0b11010, &ENTRY_PERILING_9472490737862744839)],
        ),
        (
            UniCase::ascii("praecornu"),
            &[(0b11010, &ENTRY_PRECORNU_1505512584010830310)],
        ),
        (
            UniCase::ascii("insurrectionizes"),
            &[(0b01001, &ENTRY_INSURRECTIONIZES_15593571003663123617)],
        ),
        (
            UniCase::ascii("polonisation"),
            &[(0b10010, &ENTRY_POLONIZATION_8741534032787718755)],
        ),
        (
            UniCase::ascii("vacuumized"),
            &[(0b01001, &ENTRY_VACUUMIZED_694297391266218663)],
        ),
        (
            UniCase::ascii("communalize"),
            &[(0b01001, &ENTRY_COMMUNALIZE_16978210201059417779)],
        ),
        (
            UniCase::ascii("dualises"),
            &[(0b10010, &ENTRY_DUALIZES_6580630624039637450)],
        ),
        (
            UniCase::ascii("defeminising"),
            &[(0b10010, &ENTRY_DEFEMINIZING_2126786312766733725)],
        ),
        (
            UniCase::ascii("memorise"),
            &[(0b10010, &ENTRY_MEMORIZE_3326918095136387049)],
        ),
        (
            UniCase::ascii("lexicalisation"),
            &[(0b10010, &ENTRY_LEXICALIZATION_17354516794688165566)],
        ),
        (
            UniCase::ascii("phacocherine"),
            &[(0b00001, &ENTRY_PHACOCHERINE_10095812869794876875)],
        ),
        (
            UniCase::ascii("appetizing"),
            &[(0b01001, &ENTRY_APPETIZING_383666770405789408)],
        ),
        (
            UniCase::ascii("immortalizers"),
            &[(0b01001, &ENTRY_IMMORTALIZERS_6443963380598843946)],
        ),
        (
            UniCase::ascii("canalisation"),
            &[(0b10010, &ENTRY_CANALIZATION_9901281941769542241)],
        ),
        (
            UniCase::ascii("spartanises"),
            &[(0b10010, &ENTRY_SPARTANIZES_11376123191933793512)],
        ),
        (
            UniCase::ascii("undramatised"),
            &[(0b10010, &ENTRY_UNDRAMATIZED_10630343306514025585)],
        ),
        (
            UniCase::ascii("humanized"),
            &[(0b01001, &ENTRY_HUMANIZED_15704417917952177815)],
        ),
        (
            UniCase::ascii("tunneling"),
            &[(0b00001, &ENTRY_TUNNELING_155358793735796240)],
        ),
        (
            UniCase::ascii("micronise"),
            &[(0b10010, &ENTRY_MICRONIZE_17244565019586455413)],
        ),
        (
            UniCase::ascii("sphenethmoid"),
            &[(0b00001, &ENTRY_SPHENETHMOID_8848939739861600805)],
        ),
        (
            UniCase::ascii("syneresis"),
            &[(0b00001, &ENTRY_SYNERESIS_10899482620726729247)],
        ),
        (
            UniCase::ascii("fiberizes"),
            &[(0b00001, &ENTRY_FIBERIZES_17105028343308432924)],
        ),
        (
            UniCase::ascii("paleolimnology"),
            &[(0b10001, &ENTRY_PALEOLIMNOLOGY_14150694516900017849)],
        ),
        (
            UniCase::ascii("unparticularising"),
            &[(0b10010, &ENTRY_UNPARTICULARIZING_17075351876595992224)],
        ),
        (
            UniCase::ascii("dialyzation"),
            &[(0b01001, &ENTRY_DIALYZATION_14569182709416219304)],
        ),
        (
            UniCase::ascii("muscularise"),
            &[(0b10010, &ENTRY_MUSCULARIZE_398052939754954428)],
        ),
        (
            UniCase::ascii("mischaracterize"),
            &[(0b01001, &ENTRY_MISCHARACTERIZE_14909915885126227137)],
        ),
        (
            UniCase::ascii("preaestival"),
            &[(0b11010, &ENTRY_PREESTIVAL_6075881105306786790)],
        ),
        (
            UniCase::ascii("nonanesthetized"),
            &[(0b00001, &ENTRY_NONANESTHETIZED_12181903245888735253)],
        ),
        (
            UniCase::ascii("pigmentizes"),
            &[(0b01001, &ENTRY_PIGMENTIZES_7839824677968960729)],
        ),
        (
            UniCase::ascii("respectabilised"),
            &[(0b10010, &ENTRY_RESPECTABILIZED_14730970511118216639)],
        ),
        (
            UniCase::ascii("vivers"),
            &[(0b00001, &ENTRY_VIVERS_1304906869884388477)],
        ),
        (
            UniCase::ascii("encarnalizes"),
            &[(0b01001, &ENTRY_ENCARNALIZES_11369013563329530888)],
        ),
        (
            UniCase::ascii("overwomanises"),
            &[(0b10010, &ENTRY_OVERWOMANIZES_14746928621471259508)],
        ),
        (
            UniCase::ascii("paleoplain"),
            &[(0b10001, &ENTRY_PALEOPLAIN_3909898326665799560)],
        ),
        (
            UniCase::ascii("amalgamise"),
            &[(0b10010, &ENTRY_AMALGAMIZE_6774540532866713160)],
        ),
        (
            UniCase::ascii("underoxidize"),
            &[(0b01001, &ENTRY_UNDEROXIDIZE_6485083535977243452)],
        ),
        (
            UniCase::ascii("cicatrise"),
            &[(0b10010, &ENTRY_CICATRIZE_17449239625442097002)],
        ),
        (
            UniCase::ascii("scandaled"),
            &[(0b00001, &ENTRY_SCANDALED_1881652881768607660)],
        ),
        (
            UniCase::ascii("sympathizingliest"),
            &[(0b01001, &ENTRY_SYMPATHIZINGLIEST_8990695458438411519)],
        ),
        (
            UniCase::ascii("ocherrest"),
            &[(0b00001, &ENTRY_OCHERREST_9858563234413281789)],
        ),
        (
            UniCase::ascii("anatomise"),
            &[(0b10010, &ENTRY_ANATOMIZE_841129889860317661)],
        ),
        (
            UniCase::ascii("fractionalisation"),
            &[(0b10010, &ENTRY_FRACTIONALIZATION_8741548311534296932)],
        ),
        (
            UniCase::ascii("raphe"),
            &[(0b00001, &ENTRY_RAPHE_15534448576458755657)],
        ),
        (
            UniCase::ascii("velarisation"),
            &[(0b10010, &ENTRY_VELARIZATION_1403990956820502853)],
        ),
        (
            UniCase::ascii("semihumanised"),
            &[(0b10010, &ENTRY_SEMIHUMANIZED_17638546783529197556)],
        ),
        (
            UniCase::ascii("deodorizer"),
            &[(0b01001, &ENTRY_DEODORIZER_13797022735041696461)],
        ),
        (
            UniCase::ascii("ovalisations"),
            &[(0b10010, &ENTRY_OVALIZATIONS_18438883105748297633)],
        ),
        (
            UniCase::ascii("monumentalize"),
            &[(0b01001, &ENTRY_MONUMENTALIZE_2877387938202021398)],
        ),
        (
            UniCase::ascii("eternise"),
            &[(0b10010, &ENTRY_ETERNIZE_9225349190347066102)],
        ),
        (
            UniCase::ascii("theologization"),
            &[(0b01001, &ENTRY_THEOLOGIZATION_3184169504141390704)],
        ),
        (
            UniCase::ascii("unsavourier"),
            &[(0b11010, &ENTRY_UNSAVORIER_11499851903563622390)],
        ),
        (
            UniCase::ascii("schillerises"),
            &[(0b10010, &ENTRY_SCHILLERIZES_7351365606194447161)],
        ),
        (
            UniCase::ascii("nebularizes"),
            &[(0b01001, &ENTRY_NEBULARIZES_8057540089264214439)],
        ),
        (
            UniCase::ascii("restandardizes"),
            &[(0b01001, &ENTRY_RESTANDARDIZES_16671190134442482587)],
        ),
        (
            UniCase::ascii("peraeon"),
            &[(0b11010, &ENTRY_PEREON_16795200992980059464)],
        ),
        (
            UniCase::ascii("contextualizes"),
            &[(0b01001, &ENTRY_CONTEXTUALIZES_12529336508087690726)],
        ),
        (
            UniCase::ascii("amoeboidism"),
            &[(0b11010, &ENTRY_AMEBOIDISM_6330017017844207166)],
        ),
        (
            UniCase::ascii("laster"),
            &[(0b00001, &ENTRY_LASTER_5242258785041708124)],
        ),
        (
            UniCase::ascii("mohammedanizations"),
            &[(0b01001, &ENTRY_MOHAMMEDANIZATIONS_4617417514155359733)],
        ),
        (
            UniCase::ascii("unnationalizedder"),
            &[(0b01001, &ENTRY_UNNATIONALIZEDDER_16819534566496048883)],
        ),
        (
            UniCase::ascii("underrealized"),
            &[(0b01001, &ENTRY_UNDERREALIZED_18033081021006552359)],
        ),
        (
            UniCase::ascii("peptise"),
            &[(0b10010, &ENTRY_PEPTIZE_3206314528337021093)],
        ),
        (
            UniCase::ascii("elisabethville"),
            &[(0b10010, &ENTRY_ELIZABETHVILLE_7585322377517108871)],
        ),
        (
            UniCase::ascii("aluminized"),
            &[(0b01001, &ENTRY_ALUMINIZED_10495213790591424683)],
        ),
        (
            UniCase::ascii("spyer"),
            &[(0b00001, &ENTRY_SPYER_15698237802555201567)],
        ),
        (
            UniCase::ascii("emblemizes"),
            &[(0b01001, &ENTRY_EMBLEMIZES_4063063334401141759)],
        ),
        (
            UniCase::ascii("overhonor"),
            &[(0b10001, &ENTRY_OVERHONOR_7235171621843361158)],
        ),
        (
            UniCase::ascii("callipered"),
            &[(0b11010, &ENTRY_CALIPERED_235483477506157991)],
        ),
        (
            UniCase::ascii("pressurizer"),
            &[(0b01001, &ENTRY_PRESSURIZER_14526609251745245222)],
        ),
        (
            UniCase::ascii("attitudiniser"),
            &[(0b10010, &ENTRY_ATTITUDINIZER_2282587564825240743)],
        ),
        (
            UniCase::ascii("stenciling"),
            &[(0b00001, &ENTRY_STENCILING_2842472389755702411)],
        ),
        (
            UniCase::ascii("apologise"),
            &[(0b10010, &ENTRY_APOLOGIZE_4808140733719974618)],
        ),
        (
            UniCase::ascii("mineralizable"),
            &[(0b01001, &ENTRY_MINERALIZABLE_14273899251330384981)],
        ),
        (
            UniCase::ascii("alkalinization"),
            &[(0b01001, &ENTRY_ALKALINIZATION_8644837671846444891)],
        ),
        (
            UniCase::ascii("sectionize"),
            &[(0b01001, &ENTRY_SECTIONIZE_3662925954380476587)],
        ),
        (
            UniCase::ascii("vitriolised"),
            &[(0b10010, &ENTRY_VITRIOLIZED_726289364433095774)],
        ),
        (
            UniCase::ascii("paganiser"),
            &[(0b10010, &ENTRY_PAGANIZER_6489619638171822325)],
        ),
        (
            UniCase::ascii("levorotatory"),
            &[(0b00001, &ENTRY_LEVOROTATORY_10540472502808384816)],
        ),
        (
            UniCase::ascii("ultrastandardisation"),
            &[(0b10010, &ENTRY_ULTRASTANDARDIZATION_7616606161431137542)],
        ),
        (
            UniCase::ascii("vowelise"),
            &[(0b10010, &ENTRY_VOWELIZE_18108634882497063258)],
        ),
        (
            UniCase::ascii("thronises"),
            &[(0b10010, &ENTRY_THRONIZES_12549201774820221034)],
        ),
        (
            UniCase::ascii("mechanicalisation"),
            &[(0b10010, &ENTRY_MECHANICALIZATION_13195949433368378540)],
        ),
        (
            UniCase::ascii("dialled"),
            &[(0b11010, &ENTRY_DIALED_12445554267564800284)],
        ),
        (
            UniCase::ascii("perilled"),
            &[(0b11010, &ENTRY_PERILED_4377735023565021754)],
        ),
        (
            UniCase::ascii("platitudinized"),
            &[(0b01001, &ENTRY_PLATITUDINIZED_162055508592689397)],
        ),
        (
            UniCase::ascii("feers"),
            &[(0b00001, &ENTRY_FEERS_9816318192129301807)],
        ),
        (
            UniCase::ascii("ptyalises"),
            &[(0b10010, &ENTRY_PTYALIZES_12224265186752645935)],
        ),
        (
            UniCase::ascii("puers"),
            &[(0b00001, &ENTRY_PUERS_17142262766965004130)],
        ),
        (
            UniCase::ascii("panellings"),
            &[(0b11010, &ENTRY_PANELINGS_15074841711846726284)],
        ),
        (
            UniCase::ascii("recognizablest"),
            &[(0b01001, &ENTRY_RECOGNIZABLEST_10751547482572497805)],
        ),
        (
            UniCase::ascii("potentizing"),
            &[(0b01001, &ENTRY_POTENTIZING_10663920911074862748)],
        ),
        (
            UniCase::ascii("tamboura"),
            &[(0b11010, &ENTRY_TAMBURA_1661928953124890659)],
        ),
        (
            UniCase::ascii("liberalised"),
            &[(0b10010, &ENTRY_LIBERALIZED_14395627173650056412)],
        ),
        (
            UniCase::ascii("dramatizes"),
            &[(0b01001, &ENTRY_DRAMATIZES_14716282266966184426)],
        ),
        (
            UniCase::ascii("subsidizable"),
            &[(0b01001, &ENTRY_SUBSIDIZABLE_12403609187359696273)],
        ),
        (
            UniCase::ascii("medicalisation"),
            &[(0b10010, &ENTRY_MEDICALIZATION_2111892448928052093)],
        ),
        (
            UniCase::ascii("colorfulnesses"),
            &[(0b11001, &ENTRY_COLORFULNESSES_11724036744178299544)],
        ),
        (
            UniCase::ascii("totaller"),
            &[(0b11010, &ENTRY_TOTALER_10727979907060022636)],
        ),
        (
            UniCase::ascii("estrogenic"),
            &[(0b11001, &ENTRY_ESTROGENIC_9825757897324531986)],
        ),
        (
            UniCase::ascii("malayizes"),
            &[(0b01001, &ENTRY_MALAYIZES_7101219180314967639)],
        ),
        (
            UniCase::ascii("reprogramme"),
            &[(0b11010, &ENTRY_REPROGRAM_4774339528962451273)],
        ),
        (
            UniCase::ascii("epitomizing"),
            &[(0b01001, &ENTRY_EPITOMIZING_9913028102891579136)],
        ),
        (
            UniCase::ascii("jargonizes"),
            &[(0b01001, &ENTRY_JARGONIZES_3262599751720795311)],
        ),
        (
            UniCase::ascii("mediterraneanisation"),
            &[(0b10010, &ENTRY_MEDITERRANEANIZATION_14068923875498088797)],
        ),
        (
            UniCase::ascii("thermometerise"),
            &[(0b10010, &ENTRY_THERMOMETERIZE_15998653899602520685)],
        ),
        (
            UniCase::ascii("vaporisations"),
            &[(0b10010, &ENTRY_VAPORIZATIONS_3616017509956798175)],
        ),
        (
            UniCase::ascii("spaniardizations"),
            &[(0b01001, &ENTRY_SPANIARDIZATIONS_15525961894554670327)],
        ),
        (
            UniCase::ascii("medalizes"),
            &[(0b01001, &ENTRY_MEDALIZES_8369354423782443921)],
        ),
        (
            UniCase::ascii("photosynthesising"),
            &[(0b10010, &ENTRY_PHOTOSYNTHESIZING_1052004418989698159)],
        ),
        (
            UniCase::ascii("modernizable"),
            &[(0b01001, &ENTRY_MODERNIZABLE_18104998027667857415)],
        ),
        (
            UniCase::ascii("prussianisation"),
            &[(0b10010, &ENTRY_PRUSSIANIZATION_10958382439781151197)],
        ),
        (
            UniCase::ascii("moellon"),
            &[(0b11010, &ENTRY_MELLON_391954139899810285)],
        ),
        (
            UniCase::ascii("rhodanized"),
            &[(0b01001, &ENTRY_RHODANIZED_12583740850093807678)],
        ),
        (
            UniCase::ascii("notarizing"),
            &[(0b01001, &ENTRY_NOTARIZING_9414320864175848283)],
        ),
        (
            UniCase::ascii("dentalizes"),
            &[(0b01001, &ENTRY_DENTALIZES_6643609780500500774)],
        ),
        (
            UniCase::ascii("decimeter"),
            &[(0b00001, &ENTRY_DECIMETER_14067880338205453806)],
        ),
        (
            UniCase::ascii("depolymerizes"),
            &[(0b01001, &ENTRY_DEPOLYMERIZES_8621948432119164421)],
        ),
        (
            UniCase::ascii("arterialization"),
            &[(0b01001, &ENTRY_ARTERIALIZATION_17022790192875553359)],
        ),
        (
            UniCase::ascii("localisables"),
            &[(0b10010, &ENTRY_LOCALIZABLES_12552472873910273687)],
        ),
        (
            UniCase::ascii("consonantized"),
            &[(0b01001, &ENTRY_CONSONANTIZED_17873071838789420092)],
        ),
        (
            UniCase::ascii("balkanize"),
            &[(0b01001, &ENTRY_BALKANIZE_626464622875805915)],
        ),
        (
            UniCase::ascii("mineralisations"),
            &[(0b10010, &ENTRY_MINERALIZATIONS_12229839998070627902)],
        ),
        (
            UniCase::ascii("homogenizes"),
            &[(0b01001, &ENTRY_HOMOGENIZES_8369010059050295552)],
        ),
        (
            UniCase::ascii("unharbour"),
            &[(0b11010, &ENTRY_UNHARBOR_1889127797014206122)],
        ),
        (
            UniCase::ascii("ozonized"),
            &[(0b01001, &ENTRY_OZONIZED_11239117268275093032)],
        ),
        (
            UniCase::ascii("misrouteing"),
            &[(0b11010, &ENTRY_MISROUTING_16866807267371825983)],
        ),
        (
            UniCase::ascii("sabrelike"),
            &[(0b11010, &ENTRY_SABERLIKE_13557431937207997081)],
        ),
        (
            UniCase::ascii("neighborhoods"),
            &[(0b11001, &ENTRY_NEIGHBORHOODS_4358229838170310740)],
        ),
        (
            UniCase::ascii("cancellous"),
            &[(0b11010, &ENTRY_CANCELOUS_13432632612523726300)],
        ),
        (
            UniCase::ascii("tenderised"),
            &[(0b10010, &ENTRY_TENDERIZED_4549753286584063824)],
        ),
        (
            UniCase::ascii("systematisations"),
            &[(0b10010, &ENTRY_SYSTEMATIZATIONS_4980889965627146570)],
        ),
        (
            UniCase::ascii("parameterization"),
            &[(0b01001, &ENTRY_PARAMETERIZATION_7197627343403819237)],
        ),
        (
            UniCase::ascii("fertilizabler"),
            &[(0b01001, &ENTRY_FERTILIZABLER_17085580719524585364)],
        ),
        (
            UniCase::ascii("nielloed"),
            &[(0b11010, &ENTRY_NIELLED_8727132034411172563)],
        ),
        (
            UniCase::ascii("scrutinisations"),
            &[(0b10010, &ENTRY_SCRUTINIZATIONS_16986534141035954565)],
        ),
        (
            UniCase::ascii("fletcherising"),
            &[(0b10010, &ENTRY_FLETCHERIZING_13648398213116551529)],
        ),
        (
            UniCase::ascii("anglicize"),
            &[(0b01001, &ENTRY_ANGLICIZE_3954997619999275868)],
        ),
        (
            UniCase::ascii("platycoelian"),
            &[(0b11010, &ENTRY_PLATYCELIAN_16729912161176580577)],
        ),
        (
            UniCase::ascii("uncivilise"),
            &[(0b10010, &ENTRY_UNCIVILIZE_16379895937239654425)],
        ),
        (
            UniCase::ascii("disfavours"),
            &[(0b11010, &ENTRY_DISFAVORS_15834201467329633407)],
        ),
        (
            UniCase::ascii("sectarianizing"),
            &[(0b01001, &ENTRY_SECTARIANIZING_16586872715969887648)],
        ),
        (
            UniCase::ascii("statisticize"),
            &[(0b01001, &ENTRY_STATISTICIZE_5352173326738036614)],
        ),
        (
            UniCase::ascii("queueing"),
            &[(0b11010, &ENTRY_QUEUING_16824913408770003331)],
        ),
        (
            UniCase::ascii("presplendour"),
            &[(0b11010, &ENTRY_PRESPLENDOR_14618107087953500253)],
        ),
        (
            UniCase::ascii("antimedievalism"),
            &[(0b00001, &ENTRY_ANTIMEDIEVALISM_8317263462919339358)],
        ),
        (
            UniCase::ascii("palaeological"),
            &[(0b11010, &ENTRY_PALEOLOGICAL_14540869198514592883)],
        ),
        (
            UniCase::ascii("quantize"),
            &[(0b01001, &ENTRY_QUANTIZE_11931499095330665012)],
        ),
        (
            UniCase::ascii("telesthesia"),
            &[(0b00001, &ENTRY_TELESTHESIA_3729177704184763745)],
        ),
        (
            UniCase::ascii("polarizes"),
            &[(0b01001, &ENTRY_POLARIZES_2266758101576701172)],
        ),
        (
            UniCase::ascii("initialisers"),
            &[(0b10010, &ENTRY_INITIALIZERS_12398839316559453843)],
        ),
        (
            UniCase::ascii("prelabor"),
            &[(0b00001, &ENTRY_PRELABOR_12579549139000343078)],
        ),
        (
            UniCase::ascii("unsensualise"),
            &[(0b10010, &ENTRY_UNSENSUALIZE_15769041899106603358)],
        ),
        (
            UniCase::ascii("sodomises"),
            &[(0b10010, &ENTRY_SODOMIZES_743917781797229302)],
        ),
        (
            UniCase::ascii("naturalizing"),
            &[(0b01001, &ENTRY_NATURALIZING_3716716428508245601)],
        ),
        (
            UniCase::ascii("uniformised"),
            &[(0b10010, &ENTRY_UNIFORMIZED_14730906052407110280)],
        ),
        (
            UniCase::ascii("clangor"),
            &[(0b11001, &ENTRY_CLANGOR_11515055037441300100)],
        ),
        (
            UniCase::ascii("vaporises"),
            &[(0b10010, &ENTRY_VAPORIZES_12186280109418449105)],
        ),
        (
            UniCase::ascii("sniveling"),
            &[(0b00001, &ENTRY_SNIVELING_7895796690459397538)],
        ),
        (
            UniCase::ascii("unitarianise"),
            &[(0b10010, &ENTRY_UNITARIANIZE_11972012307902630006)],
        ),
        (
            UniCase::ascii("nickelizations"),
            &[(0b01001, &ENTRY_NICKELIZATIONS_12072034603175460493)],
        ),
        (
            UniCase::ascii("creolises"),
            &[(0b10010, &ENTRY_CREOLIZES_3089367645000699437)],
        ),
        (
            UniCase::ascii("taxidermises"),
            &[(0b10010, &ENTRY_TAXIDERMIZES_4441796755398649754)],
        ),
        (
            UniCase::ascii("bacteremia"),
            &[(0b10001, &ENTRY_BACTEREMIA_7447506279056258270)],
        ),
        (
            UniCase::ascii("silique"),
            &[(0b00001, &ENTRY_SILIQUE_350570384784907901)],
        ),
        (
            UniCase::ascii("hematozoa"),
            &[(0b10001, &ENTRY_HEMATOZOA_4614122145286367461)],
        ),
        (
            UniCase::ascii("tunneled"),
            &[(0b00001, &ENTRY_TUNNELED_886730683006426004)],
        ),
        (
            UniCase::ascii("illegitimatizes"),
            &[(0b01001, &ENTRY_ILLEGITIMATIZES_10871580308994962653)],
        ),
        (
            UniCase::ascii("carbolise"),
            &[(0b10010, &ENTRY_CARBOLIZE_10498092873125902774)],
        ),
        (
            UniCase::ascii("unfossiliseds"),
            &[(0b10010, &ENTRY_UNFOSSILIZEDS_11821803111813998857)],
        ),
        (
            UniCase::ascii("humor"),
            &[(0b11001, &ENTRY_HUMOR_2121063190473553072)],
        ),
        (
            UniCase::ascii("hattize"),
            &[(0b01001, &ENTRY_HATTIZE_12381830723700612027)],
        ),
        (
            UniCase::ascii("dolor"),
            &[(0b11001, &ENTRY_DOLOR_13331739895797537426)],
        ),
        (
            UniCase::ascii("cheerfulise"),
            &[(0b10010, &ENTRY_CHEERFULIZE_762771897588790882)],
        ),
        (
            UniCase::ascii("immaterialise"),
            &[(0b10010, &ENTRY_IMMATERIALIZE_2608487643159689091)],
        ),
        (
            UniCase::ascii("indigenises"),
            &[(0b10010, &ENTRY_INDIGENIZES_8212488857174469274)],
        ),
        (
            UniCase::ascii("pedatrophia"),
            &[(0b00001, &ENTRY_PEDATROPHIA_11165730187451303309)],
        ),
        (
            UniCase::ascii("pragmatisers"),
            &[(0b10010, &ENTRY_PRAGMATIZERS_17050725505178628169)],
        ),
        (
            UniCase::ascii("canisterizes"),
            &[(0b01001, &ENTRY_CANISTERIZES_8707191536977720595)],
        ),
        (
            UniCase::ascii("posturizing"),
            &[(0b01001, &ENTRY_POSTURIZING_14553163107601026995)],
        ),
        (
            UniCase::ascii("mandarinises"),
            &[(0b10010, &ENTRY_MANDARINIZES_3405712212187872515)],
        ),
        (
            UniCase::ascii("lemmatising"),
            &[(0b10010, &ENTRY_LEMMATIZING_9177369908160152532)],
        ),
        (
            UniCase::ascii("plasticizes"),
            &[(0b01001, &ENTRY_PLASTICIZES_14237267039551578506)],
        ),
        (
            UniCase::ascii("economisation"),
            &[(0b10010, &ENTRY_ECONOMIZATION_17236921042856233623)],
        ),
        (
            UniCase::ascii("creolisation"),
            &[(0b10010, &ENTRY_CREOLIZATION_2399026028067198251)],
        ),
        (
            UniCase::ascii("fractionize"),
            &[(0b01001, &ENTRY_FRACTIONIZE_2094786255743540739)],
        ),
        (
            UniCase::ascii("partisanizes"),
            &[(0b01001, &ENTRY_PARTISANIZES_9558412409025070058)],
        ),
        (
            UniCase::ascii("protocolisation"),
            &[(0b10010, &ENTRY_PROTOCOLIZATION_912207443070037399)],
        ),
        (
            UniCase::ascii("marbleizing"),
            &[(0b01001, &ENTRY_MARBLEIZING_12106644630219217184)],
        ),
        (
            UniCase::ascii("reprivatization"),
            &[(0b01001, &ENTRY_REPRIVATIZATION_13650773811954050943)],
        ),
        (
            UniCase::ascii("unspecializingest"),
            &[(0b01001, &ENTRY_UNSPECIALIZINGEST_13963040120295765584)],
        ),
        (
            UniCase::ascii("picturizes"),
            &[(0b01001, &ENTRY_PICTURIZES_9102727891294622822)],
        ),
        (
            UniCase::ascii("nebularisations"),
            &[(0b10010, &ENTRY_NEBULARIZATIONS_1344096708238928724)],
        ),
        (
            UniCase::ascii("italianise"),
            &[(0b10010, &ENTRY_ITALIANIZE_3435276594938806940)],
        ),
        (
            UniCase::ascii("saxonizes"),
            &[(0b01001, &ENTRY_SAXONIZES_5168843153581210465)],
        ),
        (
            UniCase::ascii("aspheterised"),
            &[(0b10010, &ENTRY_ASPHETERIZED_10290056046377700436)],
        ),
        (
            UniCase::ascii("semicivilised"),
            &[(0b10010, &ENTRY_SEMICIVILIZED_4637923957818205530)],
        ),
        (
            UniCase::ascii("homoeothermic"),
            &[(0b11010, &ENTRY_HOMEOTHERMIC_3531598803017384948)],
        ),
        (
            UniCase::ascii("bromise"),
            &[(0b10010, &ENTRY_BROMIZE_9408768460954085967)],
        ),
        (
            UniCase::ascii("grises"),
            &[(0b10010, &ENTRY_GRIZES_12774403152381854793)],
        ),
        (
            UniCase::ascii("premillennialising"),
            &[(0b10010, &ENTRY_PREMILLENNIALIZING_250347440556746925)],
        ),
        (
            UniCase::ascii("subcaliber"),
            &[(0b00001, &ENTRY_SUBCALIBER_16406723248353952807)],
        ),
        (
            UniCase::ascii("structuralizes"),
            &[(0b01001, &ENTRY_STRUCTURALIZES_538653414352082587)],
        ),
        (
            UniCase::ascii("unmotorizedder"),
            &[(0b01001, &ENTRY_UNMOTORIZEDDER_4737848326164812310)],
        ),
        (
            UniCase::ascii("aeq"),
            &[(0b11010, &ENTRY_EQ_17801056412005353118)],
        ),
        (
            UniCase::ascii("miraculising"),
            &[(0b10010, &ENTRY_MIRACULIZING_8288198734632161015)],
        ),
        (
            UniCase::ascii("precisionise"),
            &[(0b10010, &ENTRY_PRECISIONIZE_16309913476870820127)],
        ),
        (
            UniCase::ascii("tenderized"),
            &[(0b01001, &ENTRY_TENDERIZED_4549753286584063824)],
        ),
        (
            UniCase::ascii("unpatronized"),
            &[(0b01001, &ENTRY_UNPATRONIZED_6212197640341804006)],
        ),
        (
            UniCase::ascii("underorganisations"),
            &[(0b10010, &ENTRY_UNDERORGANIZATIONS_10335581416606425325)],
        ),
        (
            UniCase::ascii("plebeianises"),
            &[(0b10010, &ENTRY_PLEBEIANIZES_8283743331693072026)],
        ),
        (
            UniCase::ascii("suburbanizing"),
            &[(0b01001, &ENTRY_SUBURBANIZING_16607196382879275433)],
        ),
        (
            UniCase::ascii("undemagnetizable"),
            &[(0b01001, &ENTRY_UNDEMAGNETIZABLE_15252782349141238446)],
        ),
        (
            UniCase::ascii("babelizing"),
            &[(0b01001, &ENTRY_BABELIZING_3570390515053010427)],
        ),
        (
            UniCase::ascii("europeanizing"),
            &[(0b01001, &ENTRY_EUROPEANIZING_17501868806425018896)],
        ),
        (
            UniCase::ascii("officialization"),
            &[(0b01001, &ENTRY_OFFICIALIZATION_12282151738176992879)],
        ),
        (
            UniCase::ascii("ketonisations"),
            &[(0b10010, &ENTRY_KETONIZATIONS_14629309903383300671)],
        ),
        (
            UniCase::ascii("digitalise"),
            &[(0b10010, &ENTRY_DIGITALIZE_7792956770391756553)],
        ),
        (
            UniCase::ascii("peptonization"),
            &[(0b01001, &ENTRY_PEPTONIZATION_17372160958497222923)],
        ),
        (
            UniCase::ascii("synaesthesias"),
            &[(0b11010, &ENTRY_SYNESTHESIAS_15212694822545420870)],
        ),
        (
            UniCase::ascii("unidealiseddest"),
            &[(0b10010, &ENTRY_UNIDEALIZEDDEST_9073505704713365354)],
        ),
        (
            UniCase::ascii("unformalizeddest"),
            &[(0b01001, &ENTRY_UNFORMALIZEDDEST_14745966789505381148)],
        ),
        (
            UniCase::ascii("sanitisation"),
            &[(0b10010, &ENTRY_SANITIZATION_10312415212709623714)],
        ),
        (
            UniCase::ascii("melanises"),
            &[(0b10010, &ENTRY_MELANIZES_4272022967769484050)],
        ),
        (
            UniCase::ascii("africanized"),
            &[(0b01001, &ENTRY_AFRICANIZED_1736896838594873888)],
        ),
        (
            UniCase::ascii("thermalizes"),
            &[(0b01001, &ENTRY_THERMALIZES_14481137627377672474)],
        ),
        (
            UniCase::ascii("splenisation"),
            &[(0b10010, &ENTRY_SPLENIZATION_7858507853343431089)],
        ),
        (
            UniCase::ascii("remilitarising"),
            &[(0b10010, &ENTRY_REMILITARIZING_4173334694500632492)],
        ),
        (
            UniCase::ascii("colourings"),
            &[(0b11010, &ENTRY_COLORINGS_3076825598771260084)],
        ),
        (
            UniCase::ascii("rhythmises"),
            &[(0b10010, &ENTRY_RHYTHMIZES_5770183289187248055)],
        ),
        (
            UniCase::ascii("colloquised"),
            &[(0b10010, &ENTRY_COLLOQUIZED_2987662592391153464)],
        ),
        (
            UniCase::ascii("cottonisation"),
            &[(0b10010, &ENTRY_COTTONIZATION_3551122105294457662)],
        ),
        (
            UniCase::ascii("fatalize"),
            &[(0b01001, &ENTRY_FATALIZE_5795723412936271094)],
        ),
        (
            UniCase::ascii("fictionalisations"),
            &[(0b10010, &ENTRY_FICTIONALIZATIONS_15175949905460110834)],
        ),
        (
            UniCase::ascii("beglamored"),
            &[(0b10001, &ENTRY_BEGLAMORED_17236768717735314854)],
        ),
        (
            UniCase::ascii("misauthorisations"),
            &[(0b10010, &ENTRY_MISAUTHORIZATIONS_18193977628681315405)],
        ),
        (
            UniCase::ascii("personizing"),
            &[(0b01001, &ENTRY_PERSONIZING_14903686723706359501)],
        ),
        (
            UniCase::ascii("overbrutalize"),
            &[(0b01001, &ENTRY_OVERBRUTALIZE_4691228052029488558)],
        ),
        (
            UniCase::ascii("indianizes"),
            &[(0b01001, &ENTRY_INDIANIZES_5103097757150832367)],
        ),
        (
            UniCase::ascii("schematisation"),
            &[(0b10010, &ENTRY_SCHEMATIZATION_12280133115355003981)],
        ),
        (
            UniCase::ascii("hirselled"),
            &[(0b11010, &ENTRY_HIRSELED_6428358124306464688)],
        ),
        (
            UniCase::ascii("chattelisations"),
            &[(0b10010, &ENTRY_CHATTELIZATIONS_14825459471315247028)],
        ),
        (
            UniCase::ascii("plough"),
            &[(0b11010, &ENTRY_PLOW_15240143167426020265)],
        ),
        (
            UniCase::ascii("chlorinising"),
            &[(0b10010, &ENTRY_CHLORINIZING_11381892907334769846)],
        ),
        (
            UniCase::ascii("polychromatise"),
            &[(0b10010, &ENTRY_POLYCHROMATIZE_14431815754129053959)],
        ),
        (
            UniCase::ascii("camise"),
            &[(0b10010, &ENTRY_CAMIZE_10411458476841511707)],
        ),
        (
            UniCase::ascii("bachelorize"),
            &[(0b01001, &ENTRY_BACHELORIZE_16140957144715523023)],
        ),
        (
            UniCase::ascii("synthesisations"),
            &[(0b10010, &ENTRY_SYNTHESIZATIONS_6008071763176942923)],
        ),
        (
            UniCase::ascii("pillorize"),
            &[(0b01001, &ENTRY_PILLORIZE_7161828989665068634)],
        ),
        (
            UniCase::ascii("unharboured"),
            &[(0b11010, &ENTRY_UNHARBORED_15652861429904710912)],
        ),
        (
            UniCase::ascii("plebeianised"),
            &[(0b10010, &ENTRY_PLEBEIANIZED_12150770105441799169)],
        ),
        (
            UniCase::ascii("decapitalization"),
            &[(0b01001, &ENTRY_DECAPITALIZATION_10013185676274515636)],
        ),
        (
            UniCase::ascii("ovalizations"),
            &[(0b01001, &ENTRY_OVALIZATIONS_18438883105748297633)],
        ),
        (
            UniCase::ascii("glamorizing"),
            &[(0b01001, &ENTRY_GLAMORIZING_13126163444695612437)],
        ),
        (
            UniCase::ascii("fashionise"),
            &[(0b10010, &ENTRY_FASHIONIZE_9487132676031513779)],
        ),
        (
            UniCase::ascii("macadamising"),
            &[(0b10010, &ENTRY_MACADAMIZING_13448491539296168208)],
        ),
        (
            UniCase::ascii("unalphabetised"),
            &[(0b10010, &ENTRY_UNALPHABETIZED_785154054192050580)],
        ),
        (
            UniCase::ascii("hematosis"),
            &[(0b10001, &ENTRY_HEMATOSIS_10551613893224734170)],
        ),
        (
            UniCase::ascii("antisensitizers"),
            &[(0b01001, &ENTRY_ANTISENSITIZERS_633215389454343262)],
        ),
        (
            UniCase::ascii("memorises"),
            &[(0b10010, &ENTRY_MEMORIZES_6598457048183240033)],
        ),
        (
            UniCase::ascii("robotized"),
            &[(0b01001, &ENTRY_ROBOTIZED_6871096401872030909)],
        ),
        (
            UniCase::ascii("palaeographic"),
            &[(0b11010, &ENTRY_PALEOGRAPHIC_13213503981348166251)],
        ),
        (
            UniCase::ascii("finlandisation"),
            &[(0b10010, &ENTRY_FINLANDIZATION_8745466326361207485)],
        ),
        (
            UniCase::ascii("asafoetida"),
            &[(0b11010, &ENTRY_ASAFETIDA_14075127292131066209)],
        ),
        (
            UniCase::ascii("fiberizers"),
            &[(0b00001, &ENTRY_FIBERIZERS_11340645263185175813)],
        ),
        (
            UniCase::ascii("reactualizes"),
            &[(0b01001, &ENTRY_REACTUALIZES_5611298045086045988)],
        ),
        (
            UniCase::ascii("tranquillizing"),
            &[(0b01001, &ENTRY_TRANQUILIZING_13850716228820534198)],
        ),
        (
            UniCase::ascii("narcotises"),
            &[(0b10010, &ENTRY_NARCOTIZES_4192091924295649919)],
        ),
        (
            UniCase::ascii("publicizes"),
            &[(0b01001, &ENTRY_PUBLICIZES_16376391030778715202)],
        ),
        (
            UniCase::ascii("ethnicizes"),
            &[(0b01001, &ENTRY_ETHNICIZES_17717835002455612610)],
        ),
        (
            UniCase::ascii("russianization"),
            &[(0b01001, &ENTRY_RUSSIANIZATION_16898768923421263030)],
        ),
        (
            UniCase::ascii("lateralisations"),
            &[(0b10010, &ENTRY_LATERALIZATIONS_6289621742941669396)],
        ),
        (
            UniCase::ascii("paulinise"),
            &[(0b10010, &ENTRY_PAULINIZE_4447070483648697360)],
        ),
        (
            UniCase::ascii("occidentalization"),
            &[(0b01001, &ENTRY_OCCIDENTALIZATION_3769379737658488415)],
        ),
        (
            UniCase::ascii("ultracentralisers"),
            &[(0b10010, &ENTRY_ULTRACENTRALIZERS_15801856694895216516)],
        ),
        (
            UniCase::ascii("pleuroperitoneal"),
            &[(0b00001, &ENTRY_PLEUROPERITONEAL_18421227973934406014)],
        ),
        (
            UniCase::ascii("vaticanization"),
            &[(0b01001, &ENTRY_VATICANIZATION_12565515839826698578)],
        ),
        (
            UniCase::ascii("haemin"),
            &[(0b11010, &ENTRY_HEMIN_2159475285525852130)],
        ),
        (
            UniCase::ascii("mercurialises"),
            &[(0b10010, &ENTRY_MERCURIALIZES_1343259582893080731)],
        ),
        (
            UniCase::ascii("unbarbarising"),
            &[(0b10010, &ENTRY_UNBARBARIZING_10525570028182827286)],
        ),
        (
            UniCase::ascii("internationalization"),
            &[(0b01001, &ENTRY_INTERNATIONALIZATION_8109207030063572661)],
        ),
        (
            UniCase::ascii("paleologist"),
            &[(0b10001, &ENTRY_PALEOLOGIST_12695091568939120465)],
        ),
        (
            UniCase::ascii("supercarbonizations"),
            &[(0b01001, &ENTRY_SUPERCARBONIZATIONS_10831679594408466920)],
        ),
        (
            UniCase::ascii("budaenny"),
            &[(0b11010, &ENTRY_BUDENNY_11099115713729619046)],
        ),
        (
            UniCase::ascii("noncolouring"),
            &[(0b11010, &ENTRY_NONCOLORING_2794432948648709598)],
        ),
        (
            UniCase::ascii("unorganisedness"),
            &[(0b10010, &ENTRY_UNORGANIZEDNESS_5163887181546451097)],
        ),
        (
            UniCase::ascii("centreville"),
            &[(0b11010, &ENTRY_CENTERVILLE_8888927316062312202)],
        ),
        (
            UniCase::ascii("furore"),
            &[(0b10010, &ENTRY_FUROR_15595174347085500171)],
        ),
        (
            UniCase::ascii("photolyse"),
            &[(0b10010, &ENTRY_PHOTOLYZE_16302775288316268906)],
        ),
        (
            UniCase::ascii("subarmour"),
            &[(0b11010, &ENTRY_SUBARMOR_10630628688650559346)],
        ),
        (
            UniCase::ascii("biocenoses"),
            &[(0b10001, &ENTRY_BIOCENOSES_13501584028527836531)],
        ),
        (
            UniCase::ascii("neologised"),
            &[(0b10010, &ENTRY_NEOLOGIZED_5268649546982345213)],
        ),
        (
            UniCase::ascii("myohaematin"),
            &[(0b11010, &ENTRY_MYOHEMATIN_7139519405799594952)],
        ),
        (
            UniCase::ascii("proctorized"),
            &[(0b01001, &ENTRY_PROCTORIZED_2668674070254259488)],
        ),
        (
            UniCase::ascii("miniaturised"),
            &[(0b10010, &ENTRY_MINIATURIZED_2523726741957158389)],
        ),
        (
            UniCase::ascii("labouringly"),
            &[(0b11010, &ENTRY_LABORINGLY_7190288000401128860)],
        ),
        (
            UniCase::ascii("obe"),
            &[(0b00001, &ENTRY_OBE_3387122031217898278)],
        ),
        (
            UniCase::ascii("lobotomising"),
            &[(0b10010, &ENTRY_LOBOTOMIZING_2915569577636182986)],
        ),
        (
            UniCase::ascii("hydrogenises"),
            &[(0b10010, &ENTRY_HYDROGENIZES_15414612709209000503)],
        ),
        (
            UniCase::ascii("sodomizes"),
            &[(0b01001, &ENTRY_SODOMIZES_743917781797229302)],
        ),
        (
            UniCase::ascii("aggrandizements"),
            &[(0b01001, &ENTRY_AGGRANDIZEMENTS_13855550959345858286)],
        ),
        (
            UniCase::ascii("valorizations"),
            &[(0b01001, &ENTRY_VALORIZATIONS_5550580571650748675)],
        ),
        (
            UniCase::ascii("metalling"),
            &[(0b11010, &ENTRY_METALING_10131130132844817603)],
        ),
        (
            UniCase::ascii("excursionizes"),
            &[(0b01001, &ENTRY_EXCURSIONIZES_8190667252177395210)],
        ),
        (
            UniCase::ascii("systemizer"),
            &[(0b01001, &ENTRY_SYSTEMIZER_1967185930700519507)],
        ),
        (
            UniCase::ascii("sultanizes"),
            &[(0b01001, &ENTRY_SULTANIZES_9680614734074701263)],
        ),
        (
            UniCase::ascii("unorganisable"),
            &[(0b10010, &ENTRY_UNORGANIZABLE_11245437451639231261)],
        ),
        (
            UniCase::ascii("valorises"),
            &[(0b10010, &ENTRY_VALORIZES_12702735390304257487)],
        ),
        (
            UniCase::ascii("fossilised"),
            &[(0b10010, &ENTRY_FOSSILIZED_16904263175369675937)],
        ),
        (
            UniCase::ascii("schismatised"),
            &[(0b10010, &ENTRY_SCHISMATIZED_3002177619960082558)],
        ),
        (
            UniCase::ascii("paleethnological"),
            &[(0b10001, &ENTRY_PALEETHNOLOGICAL_10389145458276668226)],
        ),
        (
            UniCase::ascii("teniacides"),
            &[(0b00001, &ENTRY_TENIACIDES_9867987590675969789)],
        ),
        (
            UniCase::ascii("prioritiser"),
            &[(0b10010, &ENTRY_PRIORITIZER_6938111019701759275)],
        ),
        (
            UniCase::ascii("unbaptized"),
            &[(0b01001, &ENTRY_UNBAPTIZED_2750609897609115804)],
        ),
        (
            UniCase::ascii("unantagonizing"),
            &[(0b01001, &ENTRY_UNANTAGONIZING_3465462232208147407)],
        ),
        (
            UniCase::ascii("squier"),
            &[(0b00001, &ENTRY_SQUIER_16883964174471128452)],
        ),
        (
            UniCase::ascii("leguminosae"),
            &[(0b11010, &ENTRY_LEGUMINOSE_13351579956836938693)],
        ),
        (
            UniCase::ascii("untrammeledder"),
            &[(0b00001, &ENTRY_UNTRAMMELEDDER_378198885203754532)],
        ),
        (
            UniCase::ascii("pseudolunulae"),
            &[(0b11010, &ENTRY_PSEUDOLUNULE_1282566980410169374)],
        ),
        (
            UniCase::ascii("macrandre"),
            &[(0b11010, &ENTRY_MACRANDER_9929126881067356727)],
        ),
        (
            UniCase::ascii("methodiser"),
            &[(0b10010, &ENTRY_METHODIZER_14823424149101284464)],
        ),
        (
            UniCase::ascii("standardizes"),
            &[(0b01001, &ENTRY_STANDARDIZES_15875984166067512659)],
        ),
        (
            UniCase::ascii("revelationise"),
            &[(0b10010, &ENTRY_REVELATIONIZE_5638146163757517114)],
        ),
        (
            UniCase::ascii("memorisation"),
            &[(0b10010, &ENTRY_MEMORIZATION_11518051927242789602)],
        ),
        (
            UniCase::ascii("servilize"),
            &[(0b01001, &ENTRY_SERVILIZE_14834152406961369316)],
        ),
        (
            UniCase::ascii("proctorization"),
            &[(0b01001, &ENTRY_PROCTORIZATION_10856447202079910826)],
        ),
        (
            UniCase::ascii("shintoizes"),
            &[(0b01001, &ENTRY_SHINTOIZES_7087800735292630340)],
        ),
        (
            UniCase::ascii("colorcasting"),
            &[(0b11001, &ENTRY_COLORCASTING_9616298919649932012)],
        ),
        (
            UniCase::ascii("marbleised"),
            &[(0b10010, &ENTRY_MARBLEIZED_4437604505512174882)],
        ),
        (
            UniCase::ascii("sericitisation"),
            &[(0b10010, &ENTRY_SERICITIZATION_8474782731600998020)],
        ),
        (
            UniCase::ascii("republicanizers"),
            &[(0b01001, &ENTRY_REPUBLICANIZERS_15251018630663619701)],
        ),
        (
            UniCase::ascii("disdiplomatizes"),
            &[(0b01001, &ENTRY_DISDIPLOMATIZES_4891957747419116479)],
        ),
        (
            UniCase::ascii("ebionise"),
            &[(0b10010, &ENTRY_EBIONIZE_14882150669745577807)],
        ),
        (
            UniCase::ascii("bacteriaemia"),
            &[(0b11010, &ENTRY_BACTERIEMIA_1013683590812100357)],
        ),
        (
            UniCase::ascii("harborward"),
            &[(0b11001, &ENTRY_HARBORWARD_15630040836906357036)],
        ),
        (
            UniCase::ascii("bromization"),
            &[(0b01001, &ENTRY_BROMIZATION_2640938302052484551)],
        ),
        (
            UniCase::ascii("unparticularizedder"),
            &[(0b01001, &ENTRY_UNPARTICULARIZEDDER_14810130530234822946)],
        ),
        (
            UniCase::ascii("modularised"),
            &[(0b10010, &ENTRY_MODULARIZED_13090071993675981622)],
        ),
        (
            UniCase::ascii("mechanises"),
            &[(0b10010, &ENTRY_MECHANIZES_15199857738602551511)],
        ),
        (
            UniCase::ascii("idaean"),
            &[(0b11010, &ENTRY_IDEAN_9346667922217550026)],
        ),
        (
            UniCase::ascii("systemization"),
            &[(0b01001, &ENTRY_SYSTEMIZATION_7402744491389982261)],
        ),
        (
            UniCase::ascii("legalisations"),
            &[(0b10010, &ENTRY_LEGALIZATIONS_5135517055405810830)],
        ),
        (
            UniCase::ascii("laurelled"),
            &[(0b11010, &ENTRY_LAURELED_11054307884791506795)],
        ),
        (
            UniCase::ascii("outrivaling"),
            &[(0b00001, &ENTRY_OUTRIVALING_1537376247789926348)],
        ),
        (
            UniCase::ascii("pretences"),
            &[(0b11010, &ENTRY_PRETENSES_15397156974880122447)],
        ),
        (
            UniCase::ascii("lyophilise"),
            &[(0b10010, &ENTRY_LYOPHILIZE_4883245748865024235)],
        ),
        (
            UniCase::ascii("localizable"),
            &[(0b01001, &ENTRY_LOCALIZABLE_5621481337891586601)],
        ),
        (
            UniCase::ascii("calendarisation"),
            &[(0b10010, &ENTRY_CALENDARIZATION_11275927263521422623)],
        ),
        (
            UniCase::ascii("drivelled"),
            &[(0b11010, &ENTRY_DRIVELED_7030750316386626325)],
        ),
        (
            UniCase::ascii("colourablies"),
            &[(0b11010, &ENTRY_COLORABLIES_16005107918816262896)],
        ),
        (
            UniCase::ascii("burglarised"),
            &[(0b10010, &ENTRY_BURGLARIZED_12847959995142931775)],
        ),
        (
            UniCase::ascii("tidbits"),
            &[(0b01001, &ENTRY_TIDBITS_8862313789168390887)],
        ),
        (
            UniCase::ascii("mainprise"),
            &[(0b10010, &ENTRY_MAINPRIZE_12476293352842703157)],
        ),
        (
            UniCase::ascii("unbarbarised"),
            &[(0b10010, &ENTRY_UNBARBARIZED_4163251566640502972)],
        ),
        (
            UniCase::ascii("newmanizing"),
            &[(0b01001, &ENTRY_NEWMANIZING_13785785322413856)],
        ),
        (
            UniCase::ascii("unclericalizes"),
            &[(0b01001, &ENTRY_UNCLERICALIZES_8000982562629252294)],
        ),
        (
            UniCase::ascii("querelae"),
            &[(0b11010, &ENTRY_QUERELE_11808184504409924035)],
        ),
        (
            UniCase::ascii("unprotestantizing"),
            &[(0b01001, &ENTRY_UNPROTESTANTIZING_2472019232653798522)],
        ),
        (
            UniCase::ascii("tenderisations"),
            &[(0b10010, &ENTRY_TENDERIZATIONS_759776932056624247)],
        ),
        (
            UniCase::ascii("undiscolouredder"),
            &[(0b11010, &ENTRY_UNDISCOLOREDDER_12948233388857516182)],
        ),
        (
            UniCase::ascii("ciceronianise"),
            &[(0b10010, &ENTRY_CICERONIANIZE_15017821268740384544)],
        ),
        (
            UniCase::ascii("overcolouring"),
            &[(0b11010, &ENTRY_OVERCOLORING_1527032230883157274)],
        ),
        (
            UniCase::ascii("localizabler"),
            &[(0b01001, &ENTRY_LOCALIZABLER_5186192263224785623)],
        ),
        (
            UniCase::ascii("rehumanizes"),
            &[(0b01001, &ENTRY_REHUMANIZES_9376605652523591285)],
        ),
        (
            UniCase::ascii("vitaminization"),
            &[(0b01001, &ENTRY_VITAMINIZATION_4345576685277511178)],
        ),
        (
            UniCase::ascii("pigmean"),
            &[(0b00001, &ENTRY_PIGMEAN_838416186676693472)],
        ),
        (
            UniCase::ascii("aphorizing"),
            &[(0b01001, &ENTRY_APHORIZING_11576244252883430467)],
        ),
        (
            UniCase::ascii("modernising"),
            &[(0b10010, &ENTRY_MODERNIZING_12238279341877582234)],
        ),
        (
            UniCase::ascii("fetichized"),
            &[(0b01001, &ENTRY_FETICHIZED_2364538138643524022)],
        ),
        (
            UniCase::ascii("palaeophytologist"),
            &[(0b11010, &ENTRY_PALEOPHYTOLOGIST_8077452540555712875)],
        ),
        (
            UniCase::ascii("theologiser"),
            &[(0b10010, &ENTRY_THEOLOGIZER_18105337442480749750)],
        ),
        (
            UniCase::ascii("romanticization"),
            &[(0b01001, &ENTRY_ROMANTICIZATION_1655615510397751437)],
        ),
        (
            UniCase::ascii("heroisations"),
            &[(0b10010, &ENTRY_HEROIZATIONS_17938260117292724826)],
        ),
        (
            UniCase::ascii("antilabours"),
            &[(0b11010, &ENTRY_ANTILABORS_3039533109874187414)],
        ),
        (
            UniCase::ascii("commercialisations"),
            &[(0b10010, &ENTRY_COMMERCIALIZATIONS_17012404820436874389)],
        ),
        (
            UniCase::ascii("albumeniser"),
            &[(0b10010, &ENTRY_ALBUMENIZER_59375995865224011)],
        ),
        (
            UniCase::ascii("copperisations"),
            &[(0b10010, &ENTRY_COPPERIZATIONS_6621746123672599508)],
        ),
        (
            UniCase::ascii("fibrescope"),
            &[(0b11010, &ENTRY_FIBERSCOPE_4051287012646069815)],
        ),
        (
            UniCase::ascii("prologuizers"),
            &[(0b01001, &ENTRY_PROLOGUIZERS_2076286811253592679)],
        ),
        (
            UniCase::ascii("hypothetising"),
            &[(0b10010, &ENTRY_HYPOTHETIZING_17356916950623118977)],
        ),
        (
            UniCase::ascii("unplagiarizedder"),
            &[(0b01001, &ENTRY_UNPLAGIARIZEDDER_2962770941163506588)],
        ),
        (
            UniCase::ascii("hepatised"),
            &[(0b10010, &ENTRY_HEPATIZED_16132157599205450670)],
        ),
        (
            UniCase::ascii("generalisational"),
            &[(0b10010, &ENTRY_GENERALIZATIONAL_14098063634295023057)],
        ),
        (
            UniCase::ascii("chaptalizing"),
            &[(0b01001, &ENTRY_CHAPTALIZING_3323047688472626072)],
        ),
        (
            UniCase::ascii("unsyphons"),
            &[(0b11010, &ENTRY_UNSIPHONS_6487069638314844152)],
        ),
        (
            UniCase::ascii("fossilisation"),
            &[(0b10010, &ENTRY_FOSSILIZATION_18247511318058151007)],
        ),
        (
            UniCase::ascii("savagise"),
            &[(0b10010, &ENTRY_SAVAGIZE_826547977271561744)],
        ),
        (
            UniCase::ascii("undercapitalising"),
            &[(0b10010, &ENTRY_UNDERCAPITALIZING_16232808968195990904)],
        ),
        (
            UniCase::ascii("arcticize"),
            &[(0b01001, &ENTRY_ARCTICIZE_14955043478793537404)],
        ),
        (
            UniCase::ascii("realisation"),
            &[(0b10010, &ENTRY_REALIZATION_14225128147203750365)],
        ),
        (
            UniCase::ascii("dimerise"),
            &[(0b10010, &ENTRY_DIMERIZE_16193073428737317522)],
        ),
        (
            UniCase::ascii("wilfully"),
            &[(0b11010, &ENTRY_WILLFULLY_17551532991278844610)],
        ),
        (
            UniCase::ascii("constitutionalizing"),
            &[(0b01001, &ENTRY_CONSTITUTIONALIZING_15920645894132149057)],
        ),
        (
            UniCase::ascii("bejewelling"),
            &[(0b11010, &ENTRY_BEJEWELING_6307871362607074541)],
        ),
        (
            UniCase::ascii("monophthongised"),
            &[(0b10010, &ENTRY_MONOPHTHONGIZED_4506738263874777552)],
        ),
        (
            UniCase::ascii("polychromises"),
            &[(0b10010, &ENTRY_POLYCHROMIZES_2277776581160811502)],
        ),
        (
            UniCase::ascii("ultraspecialisation"),
            &[(0b10010, &ENTRY_ULTRASPECIALIZATION_14780888503862218576)],
        ),
        (
            UniCase::ascii("conventionises"),
            &[(0b10010, &ENTRY_CONVENTIONIZES_5985365324069048956)],
        ),
        (
            UniCase::ascii("baptise"),
            &[(0b10010, &ENTRY_BAPTIZE_1514931118124683391)],
        ),
        (
            UniCase::ascii("depersonalises"),
            &[(0b10010, &ENTRY_DEPERSONALIZES_8248879637475981954)],
        ),
        (
            UniCase::ascii("orthogonalisation"),
            &[(0b10010, &ENTRY_ORTHOGONALIZATION_4179399411066144174)],
        ),
        (
            UniCase::ascii("moravianiseds"),
            &[(0b10010, &ENTRY_MORAVIANIZEDS_787565801428409365)],
        ),
        (
            UniCase::ascii("computerise"),
            &[(0b10010, &ENTRY_COMPUTERIZE_15545915378374926111)],
        ),
        (
            UniCase::ascii("caponisation"),
            &[(0b10010, &ENTRY_CAPONIZATION_1938263787545597969)],
        ),
        (
            UniCase::ascii("anathematise"),
            &[(0b10010, &ENTRY_ANATHEMATIZE_9250331648604756093)],
        ),
        (
            UniCase::ascii("instal"),
            &[(0b11010, &ENTRY_INSTALL_1232036630970101636)],
        ),
        (
            UniCase::ascii("deoxygenise"),
            &[(0b10010, &ENTRY_DEOXYGENIZE_7933890150357499237)],
        ),
        (
            UniCase::ascii("dechristianizations"),
            &[(0b01001, &ENTRY_DECHRISTIANIZATIONS_17028100591913749882)],
        ),
        (
            UniCase::ascii("anthologised"),
            &[(0b10010, &ENTRY_ANTHOLOGIZED_12562962063091396112)],
        ),
        (
            UniCase::ascii("unvocalizeds"),
            &[(0b01001, &ENTRY_UNVOCALIZEDS_16873526062784100267)],
        ),
        (
            UniCase::ascii("undisorganised"),
            &[(0b10010, &ENTRY_UNDISORGANIZED_2987622726902566022)],
        ),
        (
            UniCase::ascii("emotionalise"),
            &[(0b10010, &ENTRY_EMOTIONALIZE_9595590056518240613)],
        ),
        (
            UniCase::ascii("collectivised"),
            &[(0b10010, &ENTRY_COLLECTIVIZED_14370760959187496202)],
        ),
        (
            UniCase::ascii("proctorizations"),
            &[(0b01001, &ENTRY_PROCTORIZATIONS_16880863477174659915)],
        ),
        (
            UniCase::ascii("operationalize"),
            &[(0b01001, &ENTRY_OPERATIONALIZE_2692806162887915024)],
        ),
        (
            UniCase::ascii("traditionalise"),
            &[(0b10010, &ENTRY_TRADITIONALIZE_4898176225220743845)],
        ),
        (
            UniCase::ascii("syndicalizes"),
            &[(0b01001, &ENTRY_SYNDICALIZES_7458900059096200056)],
        ),
        (
            UniCase::ascii("catechizations"),
            &[(0b01001, &ENTRY_CATECHIZATIONS_7241271747980004634)],
        ),
        (
            UniCase::ascii("aetiotropically"),
            &[(0b11010, &ENTRY_ETIOTROPICALLY_9902369940420748380)],
        ),
        (
            UniCase::ascii("paleoclimatological"),
            &[(0b10001, &ENTRY_PALEOCLIMATOLOGICAL_1574786532199586705)],
        ),
        (
            UniCase::ascii("mesogleas"),
            &[(0b00001, &ENTRY_MESOGLEAS_15641828554859977983)],
        ),
        (
            UniCase::ascii("micellae"),
            &[(0b11010, &ENTRY_MICELLE_16974791499278810684)],
        ),
        (
            UniCase::ascii("dehypnotize"),
            &[(0b01001, &ENTRY_DEHYPNOTIZE_10726010356831719725)],
        ),
        (
            UniCase::ascii("vaporizer"),
            &[(0b01001, &ENTRY_VAPORIZER_8052635902096901156)],
        ),
        (
            UniCase::ascii("monetizations"),
            &[(0b01001, &ENTRY_MONETIZATIONS_17875812136896605805)],
        ),
        (
            UniCase::ascii("immoralising"),
            &[(0b10010, &ENTRY_IMMORALIZING_225651617588777573)],
        ),
        (
            UniCase::ascii("unkenneled"),
            &[(0b00001, &ENTRY_UNKENNELED_3312308653646352421)],
        ),
        (
            UniCase::ascii("fustianized"),
            &[(0b01001, &ENTRY_FUSTIANIZED_9552600907569960981)],
        ),
        (
            UniCase::ascii("colormaps"),
            &[(0b11001, &ENTRY_COLORMAPS_11406342514432472514)],
        ),
        (
            UniCase::ascii("substantivising"),
            &[(0b10010, &ENTRY_SUBSTANTIVIZING_13322008447748586118)],
        ),
        (
            UniCase::ascii("proverbializing"),
            &[(0b01001, &ENTRY_PROVERBIALIZING_16662355151354609960)],
        ),
        (
            UniCase::ascii("commercialized"),
            &[(0b01001, &ENTRY_COMMERCIALIZED_13681505620366419859)],
        ),
        (
            UniCase::ascii("nonapostatisings"),
            &[(0b10010, &ENTRY_NONAPOSTATIZINGS_11913102920540330783)],
        ),
        (
            UniCase::ascii("anagrammatised"),
            &[(0b10010, &ENTRY_ANAGRAMMATIZED_17231243584520853895)],
        ),
        (
            UniCase::ascii("prefavors"),
            &[(0b00001, &ENTRY_PREFAVORS_7516975395445427601)],
        ),
        (
            UniCase::ascii("twire"),
            &[(0b11010, &ENTRY_TWIER_17943274413772224375)],
        ),
        (
            UniCase::ascii("glycerolize"),
            &[(0b01001, &ENTRY_GLYCEROLIZE_14402503186408445056)],
        ),
        (
            UniCase::ascii("religionize"),
            &[(0b01001, &ENTRY_RELIGIONIZE_6532592146342717831)],
        ),
        (
            UniCase::ascii("puritanises"),
            &[(0b10010, &ENTRY_PURITANIZES_4562255768937344613)],
        ),
        (
            UniCase::ascii("orthopnea"),
            &[(0b00001, &ENTRY_ORTHOPNEA_11714074503904128615)],
        ),
        (
            UniCase::ascii("destabilises"),
            &[(0b10010, &ENTRY_DESTABILIZES_13491486327241590151)],
        ),
        (
            UniCase::ascii("phaenna"),
            &[(0b00001, &ENTRY_PHAENNA_6872669718419162795)],
        ),
        (
            UniCase::ascii("maximiser"),
            &[(0b10010, &ENTRY_MAXIMIZER_17946247253592585241)],
        ),
        (
            UniCase::ascii("esc"),
            &[(0b00001, &ENTRY_ESC_734356833349788703)],
        ),
        (
            UniCase::ascii("metagrabolize"),
            &[(0b01001, &ENTRY_METAGRABOLIZE_4339239122760344200)],
        ),
        (
            UniCase::ascii("colorative"),
            &[(0b00001, &ENTRY_COLORATIVE_17851173748347347190)],
        ),
        (
            UniCase::ascii("angelicises"),
            &[(0b10010, &ENTRY_ANGELICIZES_1637579071183202501)],
        ),
        (
            UniCase::ascii("excursionize"),
            &[(0b01001, &ENTRY_EXCURSIONIZE_6141947279836282456)],
        ),
        (
            UniCase::ascii("individualizations"),
            &[(0b01001, &ENTRY_INDIVIDUALIZATIONS_11118632820394117785)],
        ),
        (
            UniCase::ascii("sterilizabler"),
            &[(0b01001, &ENTRY_STERILIZABLER_5396292600348410338)],
        ),
        (
            UniCase::ascii("resynthesise"),
            &[(0b10010, &ENTRY_RESYNTHESIZE_8960121186358208467)],
        ),
        (
            UniCase::ascii("roehm"),
            &[(0b11010, &ENTRY_REHM_1954003150274029388)],
        ),
        (
            UniCase::ascii("majusculae"),
            &[(0b11010, &ENTRY_MAJUSCULE_4389141979884550889)],
        ),
        (
            UniCase::ascii("canonizer"),
            &[(0b01001, &ENTRY_CANONIZER_17140136837292538642)],
        ),
        (
            UniCase::ascii("enarbor"),
            &[(0b00001, &ENTRY_ENARBOR_15915857770564812751)],
        ),
        (
            UniCase::ascii("colorblind"),
            &[(0b11001, &ENTRY_COLORBLIND_6088870633188592041)],
        ),
        (
            UniCase::ascii("parametrisable"),
            &[(0b10010, &ENTRY_PARAMETRIZABLE_5928777122379787793)],
        ),
        (
            UniCase::ascii("weaseled"),
            &[(0b01001, &ENTRY_WEASELED_11570315947714387529)],
        ),
        (
            UniCase::ascii("revolatilizes"),
            &[(0b01001, &ENTRY_REVOLATILIZES_261087607754605694)],
        ),
        (
            UniCase::ascii("denaturizations"),
            &[(0b01001, &ENTRY_DENATURIZATIONS_12481426158532842249)],
        ),
        (
            UniCase::ascii("nickelization"),
            &[(0b01001, &ENTRY_NICKELIZATION_7986732926112090831)],
        ),
        (
            UniCase::ascii("phonetisation"),
            &[(0b10010, &ENTRY_PHONETIZATION_5080772382710194175)],
        ),
        (
            UniCase::ascii("phosphatise"),
            &[(0b10010, &ENTRY_PHOSPHATIZE_589509609004210876)],
        ),
        (
            UniCase::ascii("syntonised"),
            &[(0b10010, &ENTRY_SYNTONIZED_15041457439325800203)],
        ),
        (
            UniCase::ascii("tyrannizer"),
            &[(0b01001, &ENTRY_TYRANNIZER_1371535188483909389)],
        ),
        (
            UniCase::ascii("otorrhoea"),
            &[(0b11010, &ENTRY_OTORRHEA_2158661830949996618)],
        ),
        (
            UniCase::ascii("gruelled"),
            &[(0b11010, &ENTRY_GRUELED_489064457355388373)],
        ),
        (
            UniCase::ascii("versicoloured"),
            &[(0b11010, &ENTRY_VERSICOLORED_8698649720277268404)],
        ),
        (
            UniCase::ascii("mineralisation"),
            &[(0b10010, &ENTRY_MINERALIZATION_3564945156895387848)],
        ),
        (
            UniCase::ascii("remonetizing"),
            &[(0b01001, &ENTRY_REMONETIZING_11312258848004221079)],
        ),
        (
            UniCase::ascii("parametrisations"),
            &[(0b10010, &ENTRY_PARAMETRIZATIONS_5016585554931052909)],
        ),
        (
            UniCase::ascii("unscoring"),
            &[(0b00001, &ENTRY_UNSCORING_7857262218542359235)],
        ),
        (
            UniCase::ascii("economizations"),
            &[(0b01001, &ENTRY_ECONOMIZATIONS_13677505030173502975)],
        ),
        (
            UniCase::ascii("optimization"),
            &[(0b01001, &ENTRY_OPTIMIZATION_13814783904890834134)],
        ),
        (
            UniCase::ascii("anatomisation"),
            &[(0b10010, &ENTRY_ANATOMIZATION_4269547902777954197)],
        ),
        (
            UniCase::ascii("equalised"),
            &[(0b10010, &ENTRY_EQUALIZED_5400608554561448474)],
        ),
        (
            UniCase::ascii("negritising"),
            &[(0b10010, &ENTRY_NEGRITIZING_9349037264957140834)],
        ),
        (
            UniCase::ascii("unmagnetiseds"),
            &[(0b10010, &ENTRY_UNMAGNETIZEDS_18035379637239565234)],
        ),
        (
            UniCase::ascii("glutei"),
            &[(0b00001, &ENTRY_GLUTEI_16791170565919408237)],
        ),
        (
            UniCase::ascii("superhumanizing"),
            &[(0b01001, &ENTRY_SUPERHUMANIZING_4071636756107716090)],
        ),
        (
            UniCase::ascii("draftsmen"),
            &[(0b01001, &ENTRY_DRAFTSMEN_11969721402571410341)],
        ),
        (
            UniCase::ascii("companionizes"),
            &[(0b01001, &ENTRY_COMPANIONIZES_159175304294701734)],
        ),
        (
            UniCase::ascii("lithotritized"),
            &[(0b01001, &ENTRY_LITHOTRITIZED_16101279289408156476)],
        ),
        (
            UniCase::ascii("glamoring"),
            &[(0b11001, &ENTRY_GLAMOURING_6375193716164556692)],
        ),
        (
            UniCase::ascii("dispauperize"),
            &[(0b01001, &ENTRY_DISPAUPERIZE_4660569275468440176)],
        ),
        (
            UniCase::ascii("perfectivise"),
            &[(0b10010, &ENTRY_PERFECTIVIZE_12830499112403314573)],
        ),
        (
            UniCase::ascii("noncolorableness"),
            &[(0b10001, &ENTRY_NONCOLORABLENESS_1350486861839326465)],
        ),
        (
            UniCase::ascii("unrivalleddest"),
            &[(0b11010, &ENTRY_UNRIVALEDDEST_6685390969368773151)],
        ),
        (
            UniCase::ascii("kaed"),
            &[(0b11010, &ENTRY_KED_16330510442503716352)],
        ),
        (
            UniCase::ascii("phagocytises"),
            &[(0b10010, &ENTRY_PHAGOCYTIZES_5484801342814585347)],
        ),
        (
            UniCase::ascii("carburetor"),
            &[(0b00001, &ENTRY_CARBURETOR_3718140921594640872)],
        ),
        (
            UniCase::ascii("curatizes"),
            &[(0b01001, &ENTRY_CURATIZES_4333181687986321191)],
        ),
        (
            UniCase::ascii("severalises"),
            &[(0b10010, &ENTRY_SEVERALIZES_10859120750647710400)],
        ),
        (
            UniCase::ascii("untantalizeddest"),
            &[(0b01001, &ENTRY_UNTANTALIZEDDEST_17808161070361053815)],
        ),
        (
            UniCase::ascii("syndicalize"),
            &[(0b01001, &ENTRY_SYNDICALIZE_6097714922943684680)],
        ),
        (
            UniCase::ascii("solmisation"),
            &[(0b10010, &ENTRY_SOLMIZATION_8566929989308185368)],
        ),
        (
            UniCase::ascii("informalize"),
            &[(0b01001, &ENTRY_INFORMALIZE_17826170607752662140)],
        ),
        (
            UniCase::ascii("arche"),
            &[(0b00001, &ENTRY_ARCHE_10156222017687532546)],
        ),
        (
            UniCase::ascii("tautologised"),
            &[(0b10010, &ENTRY_TAUTOLOGIZED_9842553804886781862)],
        ),
        (
            UniCase::ascii("reactualise"),
            &[(0b10010, &ENTRY_REACTUALIZE_15121608179320441718)],
        ),
        (
            UniCase::ascii("favored"),
            &[(0b11001, &ENTRY_FAVORED_16162807193690319578)],
        ),
        (
            UniCase::ascii("anodise"),
            &[(0b10010, &ENTRY_ANODIZE_13790793654476230265)],
        ),
        (
            UniCase::ascii("anthropomorphisation"),
            &[(0b10010, &ENTRY_ANTHROPOMORPHIZATION_15471734561820106871)],
        ),
        (
            UniCase::ascii("estivating"),
            &[(0b01001, &ENTRY_ESTIVATING_3590628019702465357)],
        ),
        (
            UniCase::ascii("vulgarizations"),
            &[(0b01001, &ENTRY_VULGARIZATIONS_17269033887487645821)],
        ),
        (
            UniCase::ascii("achromatization"),
            &[(0b01001, &ENTRY_ACHROMATIZATION_3261887351568242902)],
        ),
        (
            UniCase::ascii("unfeudalizing"),
            &[(0b01001, &ENTRY_UNFEUDALIZING_3182932192190349634)],
        ),
        (
            UniCase::ascii("coloury"),
            &[(0b11010, &ENTRY_COLORY_3235234236420467456)],
        ),
        (
            UniCase::ascii("mesmerizes"),
            &[(0b01001, &ENTRY_MESMERIZES_3470825852692700157)],
        ),
        (
            UniCase::ascii("christianizers"),
            &[(0b01001, &ENTRY_CHRISTIANIZERS_2108724649580713236)],
        ),
        (
            UniCase::ascii("odorizing"),
            &[(0b01001, &ENTRY_ODORIZING_15240114282647188255)],
        ),
        (
            UniCase::ascii("orthogonalised"),
            &[(0b10010, &ENTRY_ORTHOGONALIZED_11695907609311865979)],
        ),
        (
            UniCase::ascii("nonpenaliseds"),
            &[(0b10010, &ENTRY_NONPENALIZEDS_9532498621715242902)],
        ),
        (
            UniCase::ascii("skeletonizes"),
            &[(0b01001, &ENTRY_SKELETONIZES_5920383959770274591)],
        ),
        (
            UniCase::ascii("tellurises"),
            &[(0b10010, &ENTRY_TELLURIZES_14477745285616322945)],
        ),
        (
            UniCase::ascii("apostatizes"),
            &[(0b01001, &ENTRY_APOSTATIZES_17887605457755809141)],
        ),
        (
            UniCase::ascii("italianizers"),
            &[(0b01001, &ENTRY_ITALIANIZERS_7438679689208329079)],
        ),
        (
            UniCase::ascii("scorsing"),
            &[(0b00001, &ENTRY_SCORSING_3188653853529728017)],
        ),
        (
            UniCase::ascii("dognapping"),
            &[(0b11010, &ENTRY_DOGNAPING_18285041110852582538)],
        ),
        (
            UniCase::ascii("unpopularized"),
            &[(0b01001, &ENTRY_UNPOPULARIZED_76466767521665438)],
        ),
        (
            UniCase::ascii("unchloridizeds"),
            &[(0b01001, &ENTRY_UNCHLORIDIZEDS_14218178409370978541)],
        ),
        (
            UniCase::ascii("dislustre"),
            &[(0b11010, &ENTRY_DISLUSTER_17318159058933817750)],
        ),
        (
            UniCase::ascii("gelatinizability"),
            &[(0b01001, &ENTRY_GELATINIZABILITY_11867008106433996321)],
        ),
        (
            UniCase::ascii("sulphurizes"),
            &[(0b01000, &ENTRY_SULFURIZES_5918702548576518301)],
        ),
        (
            UniCase::ascii("diarrheticest"),
            &[(0b10001, &ENTRY_DIARRHETICEST_7576238721431437280)],
        ),
        (
            UniCase::ascii("specialised"),
            &[(0b10010, &ENTRY_SPECIALIZED_8365382398741657820)],
        ),
        (
            UniCase::ascii("desexualization"),
            &[(0b01001, &ENTRY_DESEXUALIZATION_7051669726674300306)],
        ),
        (
            UniCase::ascii("venalisations"),
            &[(0b10010, &ENTRY_VENALIZATIONS_2118690871234046077)],
        ),
        (
            UniCase::ascii("marshalled"),
            &[(0b11010, &ENTRY_MARSHALED_14436567244270856596)],
        ),
        (
            UniCase::ascii("teste"),
            &[(0b00001, &ENTRY_TESTE_7681162770005306000)],
        ),
        (
            UniCase::ascii("unitize"),
            &[(0b01001, &ENTRY_UNITIZE_15650295066694421044)],
        ),
        (
            UniCase::ascii("undemagnetisable"),
            &[(0b10010, &ENTRY_UNDEMAGNETIZABLE_15252782349141238446)],
        ),
        (
            UniCase::ascii("cosily"),
            &[(0b10010, &ENTRY_COZILY_12652080440015563463)],
        ),
        (
            UniCase::ascii("neencephalon"),
            &[(0b00001, &ENTRY_NEENCEPHALON_14187652725536427083)],
        ),
        (
            UniCase::ascii("sexualised"),
            &[(0b10010, &ENTRY_SEXUALIZED_17516220740309805973)],
        ),
        (
            UniCase::ascii("ebonizes"),
            &[(0b01001, &ENTRY_EBONIZES_7098552992016802268)],
        ),
        (
            UniCase::ascii("prologized"),
            &[(0b01001, &ENTRY_PROLOGIZED_3624222185686090329)],
        ),
        (
            UniCase::ascii("hyperspiritualizing"),
            &[(0b01001, &ENTRY_HYPERSPIRITUALIZING_5448619034968576987)],
        ),
        (
            UniCase::ascii("pseudoanemics"),
            &[(0b00001, &ENTRY_PSEUDOANEMICS_2122831063804414766)],
        ),
        (
            UniCase::ascii("revisualises"),
            &[(0b10010, &ENTRY_REVISUALIZES_757435382058959188)],
        ),
        (
            UniCase::ascii("gentilising"),
            &[(0b10010, &ENTRY_GENTILIZING_12868465986545165261)],
        ),
        (
            UniCase::ascii("paleobotany"),
            &[(0b10001, &ENTRY_PALEOBOTANY_14491399323716171031)],
        ),
        (
            UniCase::ascii("phelonions"),
            &[(0b00001, &ENTRY_PHELONIONS_7275701311297650329)],
        ),
        (
            UniCase::ascii("ernes"),
            &[(0b00001, &ENTRY_ERNES_16282144925287112174)],
        ),
        (
            UniCase::ascii("bise"),
            &[(0b10010, &ENTRY_BIZE_12936627068566021826)],
        ),
        (
            UniCase::ascii("melodizer"),
            &[(0b01001, &ENTRY_MELODIZER_17176341135857748154)],
        ),
        (
            UniCase::ascii("etymologizable"),
            &[(0b01001, &ENTRY_ETYMOLOGIZABLE_14324009501183818334)],
        ),
        (
            UniCase::ascii("mythicizer"),
            &[(0b01001, &ENTRY_MYTHICIZER_17943353036856898639)],
        ),
        (
            UniCase::ascii("cubanizes"),
            &[(0b01001, &ENTRY_CUBANIZES_11947476283611479479)],
        ),
        (
            UniCase::ascii("modularisation"),
            &[(0b10010, &ENTRY_MODULARIZATION_3680687403533449721)],
        ),
        (
            UniCase::ascii("undemocratizes"),
            &[(0b01001, &ENTRY_UNDEMOCRATIZES_5725888909225905299)],
        ),
        (
            UniCase::ascii("decasualizing"),
            &[(0b01001, &ENTRY_DECASUALIZING_18325301279691614544)],
        ),
        (
            UniCase::ascii("overgeneralising"),
            &[(0b10010, &ENTRY_OVERGENERALIZING_10418526262017180256)],
        ),
        (
            UniCase::ascii("fulgourous"),
            &[(0b11010, &ENTRY_FULGOROUS_16556587498459255650)],
        ),
        (
            UniCase::ascii("prefoliation"),
            &[
                (0b11010, &ENTRY_PERFOLIATION_15643738965251302962),
                (0b00001, &ENTRY_PREFOLIATION_802436263196003766),
            ],
        ),
        (
            UniCase::ascii("fossilizables"),
            &[(0b01001, &ENTRY_FOSSILIZABLES_850215141590149031)],
        ),
        (
            UniCase::ascii("traitorizes"),
            &[(0b01001, &ENTRY_TRAITORIZES_16161164434011189838)],
        ),
        (
            UniCase::ascii("savouries"),
            &[(0b11010, &ENTRY_SAVORIES_9905015268014283974)],
        ),
        (
            UniCase::ascii("systematized"),
            &[(0b01001, &ENTRY_SYSTEMATIZED_3960322988302014252)],
        ),
        (
            UniCase::ascii("communalisers"),
            &[(0b10010, &ENTRY_COMMUNALIZERS_1419522334270734921)],
        ),
        (
            UniCase::ascii("mohammedanise"),
            &[(0b10010, &ENTRY_MOHAMMEDANIZE_2941075096626155541)],
        ),
        (
            UniCase::ascii("hyperimmunizations"),
            &[(0b01001, &ENTRY_HYPERIMMUNIZATIONS_11646409859052189468)],
        ),
        (
            UniCase::ascii("updrafts"),
            &[(0b01001, &ENTRY_UPDRAFTS_15724500159329907899)],
        ),
        (
            UniCase::ascii("unpolarizeds"),
            &[(0b01001, &ENTRY_UNPOLARIZEDS_12480635500313856290)],
        ),
        (
            UniCase::ascii("depoliticize"),
            &[(0b01001, &ENTRY_DEPOLITICIZE_646707646854880895)],
        ),
        (
            UniCase::ascii("gynaecologists"),
            &[(0b10010, &ENTRY_GYNECOLOGISTS_1517096604835056713)],
        ),
        (
            UniCase::ascii("cicatrised"),
            &[(0b10010, &ENTRY_CICATRIZED_1926551778073289264)],
        ),
        (
            UniCase::ascii("loveably"),
            &[(0b00001, &ENTRY_LOVABLY_6219831687533495276)],
        ),
        (
            UniCase::ascii("tariffises"),
            &[(0b10010, &ENTRY_TARIFFIZES_4632513233689174159)],
        ),
        (
            UniCase::ascii("virtualise"),
            &[(0b10010, &ENTRY_VIRTUALIZE_5037242355249715652)],
        ),
        (
            UniCase::ascii("hypogeic"),
            &[(0b10001, &ENTRY_HYPOGEIC_8668126381759058087)],
        ),
        (
            UniCase::ascii("phoneticizations"),
            &[(0b01001, &ENTRY_PHONETICIZATIONS_12272721619858915699)],
        ),
        (
            UniCase::ascii("hemostatic"),
            &[(0b10001, &ENTRY_HEMOSTATIC_16725641889932539790)],
        ),
        (
            UniCase::ascii("aguizes"),
            &[(0b01001, &ENTRY_AGUIZES_3631645618729972992)],
        ),
        (
            UniCase::ascii("niggardized"),
            &[(0b01001, &ENTRY_NIGGARDIZED_4556331947580220081)],
        ),
        (
            UniCase::ascii("postsynchronization"),
            &[(0b01001, &ENTRY_POSTSYNCHRONIZATION_9735500999067667804)],
        ),
        (
            UniCase::ascii("stipule"),
            &[(0b00001, &ENTRY_STIPULE_14068580951871446375)],
        ),
        (
            UniCase::ascii("memorised"),
            &[(0b10010, &ENTRY_MEMORIZED_18012206033008846662)],
        ),
        (
            UniCase::ascii("electrising"),
            &[(0b10010, &ENTRY_ELECTRIZING_14822771639775450790)],
        ),
        (
            UniCase::ascii("misjudgement"),
            &[(0b11010, &ENTRY_MISJUDGMENT_7815182386368600232)],
        ),
        (
            UniCase::ascii("ductilizes"),
            &[(0b01001, &ENTRY_DUCTILIZES_8324019089066090944)],
        ),
        (
            UniCase::ascii("spiritualiser"),
            &[(0b10010, &ENTRY_SPIRITUALIZER_8504978883588201552)],
        ),
        (
            UniCase::ascii("cosiest"),
            &[(0b11010, &ENTRY_COZIEST_2405878050968803482)],
        ),
        (
            UniCase::ascii("ketonisation"),
            &[(0b10010, &ENTRY_KETONIZATION_10404300835427344597)],
        ),
        (
            UniCase::ascii("revaporization"),
            &[(0b01001, &ENTRY_REVAPORIZATION_13446372973926423118)],
        ),
        (
            UniCase::ascii("odorizes"),
            &[(0b01001, &ENTRY_ODORIZES_14078045785775136097)],
        ),
        (
            UniCase::ascii("criminalized"),
            &[(0b01001, &ENTRY_CRIMINALIZED_11203535063879460381)],
        ),
        (
            UniCase::ascii("radiosterilize"),
            &[(0b01001, &ENTRY_RADIOSTERILIZE_12451407989140658611)],
        ),
        (
            UniCase::ascii("memoriser"),
            &[(0b10010, &ENTRY_MEMORIZER_3044267375638741545)],
        ),
        (
            UniCase::ascii("reforestize"),
            &[(0b01001, &ENTRY_REFORESTIZE_2340774127981028167)],
        ),
        (
            UniCase::ascii("ocherouser"),
            &[(0b00001, &ENTRY_OCHEROUSER_5814846539343037272)],
        ),
        (
            UniCase::ascii("hematocryal"),
            &[(0b10001, &ENTRY_HEMATOCRYAL_14432690073423033477)],
        ),
        (
            UniCase::ascii("aedicule"),
            &[(0b11010, &ENTRY_EDICULE_10918770642841249439)],
        ),
        (
            UniCase::ascii("particolouredder"),
            &[(0b11010, &ENTRY_PARTICOLOREDDER_10954556914378270950)],
        ),
        (
            UniCase::ascii("paleontological"),
            &[(0b11001, &ENTRY_PALEONTOLOGICAL_12663535461634576551)],
        ),
        (
            UniCase::ascii("fetishized"),
            &[(0b01001, &ENTRY_FETISHIZED_5250641916695551285)],
        ),
        (
            UniCase::ascii("angelicizes"),
            &[(0b01001, &ENTRY_ANGELICIZES_1637579071183202501)],
        ),
        (
            UniCase::ascii("vapourimeter"),
            &[(0b11010, &ENTRY_VAPORIMETER_12463044510053318843)],
        ),
        (
            UniCase::ascii("unmagnetiseddest"),
            &[(0b10010, &ENTRY_UNMAGNETIZEDDEST_9811017267349487901)],
        ),
        (
            UniCase::ascii("naturalizers"),
            &[(0b01001, &ENTRY_NATURALIZERS_3438182303380931640)],
        ),
        (
            UniCase::ascii("unmerceriseds"),
            &[(0b10010, &ENTRY_UNMERCERIZEDS_401622175139065596)],
        ),
        (
            UniCase::ascii("czechisation"),
            &[(0b10010, &ENTRY_CZECHIZATION_14599848904820315137)],
        ),
        (
            UniCase::ascii("galvanization"),
            &[(0b01001, &ENTRY_GALVANIZATION_5356855464894954705)],
        ),
        (
            UniCase::ascii("stabilizers"),
            &[(0b01001, &ENTRY_STABILIZERS_16116889764524023645)],
        ),
        (
            UniCase::ascii("cryptaesthetic"),
            &[(0b11010, &ENTRY_CRYPTESTHETIC_6202935653821971765)],
        ),
        (
            UniCase::ascii("anesthesias"),
            &[(0b11001, &ENTRY_ANESTHESIAS_9838908694750944673)],
        ),
        (
            UniCase::ascii("palaeoanthropus"),
            &[(0b11010, &ENTRY_PALEOANTHROPUS_7420869959409316912)],
        ),
        (
            UniCase::ascii("palatizes"),
            &[(0b01001, &ENTRY_PALATIZES_14141187893507819752)],
        ),
        (
            UniCase::ascii("deglycerolised"),
            &[(0b10010, &ENTRY_DEGLYCEROLIZED_5620184830818473145)],
        ),
        (
            UniCase::ascii("etherialised"),
            &[(0b10010, &ENTRY_ETHERIALIZED_6425316747358472251)],
        ),
        (
            UniCase::ascii("melanemic"),
            &[(0b10001, &ENTRY_MELANEMIC_13613605974584449832)],
        ),
        (
            UniCase::ascii("hotelize"),
            &[(0b01001, &ENTRY_HOTELIZE_10883646870902168688)],
        ),
        (
            UniCase::ascii("plagiarize"),
            &[(0b01001, &ENTRY_PLAGIARIZE_3775190677956286864)],
        ),
        (
            UniCase::ascii("martyrizers"),
            &[(0b01001, &ENTRY_MARTYRIZERS_8288377886330052956)],
        ),
        (
            UniCase::ascii("civilizednesses"),
            &[(0b01001, &ENTRY_CIVILIZEDNESSES_12980539923790842297)],
        ),
        (
            UniCase::ascii("plagiarise"),
            &[(0b10010, &ENTRY_PLAGIARIZE_3775190677956286864)],
        ),
        (
            UniCase::ascii("potentized"),
            &[(0b01001, &ENTRY_POTENTIZED_16902758254500333884)],
        ),
        (
            UniCase::ascii("pretexta"),
            &[(0b00001, &ENTRY_PRETEXTA_322521945222134396)],
        ),
        (
            UniCase::ascii("customizers"),
            &[(0b01001, &ENTRY_CUSTOMIZERS_7343425341470389472)],
        ),
        (
            UniCase::ascii("untartarized"),
            &[(0b01001, &ENTRY_UNTARTARIZED_9979924217571095451)],
        ),
        (
            UniCase::ascii("cyanized"),
            &[(0b01001, &ENTRY_CYANIZED_17361255917873352647)],
        ),
        (
            UniCase::ascii("semioxygenized"),
            &[(0b01001, &ENTRY_SEMIOXYGENIZED_15324068707582079762)],
        ),
        (
            UniCase::ascii("odors"),
            &[(0b11001, &ENTRY_ODORS_372602031562404386)],
        ),
        (
            UniCase::ascii("estuate"),
            &[(0b00001, &ENTRY_ESTUATE_7237204571723121927)],
        ),
        (
            UniCase::ascii("unfamiliarizedder"),
            &[(0b01001, &ENTRY_UNFAMILIARIZEDDER_13089042195024096822)],
        ),
        (
            UniCase::ascii("nuclearizations"),
            &[(0b01001, &ENTRY_NUCLEARIZATIONS_6750475977451359321)],
        ),
        (
            UniCase::ascii("bussed"),
            &[(0b10011, &ENTRY_BUSED_11356679774879450486)],
        ),
        (
            UniCase::ascii("hebraizer"),
            &[(0b01001, &ENTRY_HEBRAIZER_18227136059206047351)],
        ),
        (
            UniCase::ascii("hypothesised"),
            &[(0b10010, &ENTRY_HYPOTHESIZED_7654092048334444056)],
        ),
        (
            UniCase::ascii("vacuumizes"),
            &[(0b01001, &ENTRY_VACUUMIZES_3651190374182064680)],
        ),
        (
            UniCase::ascii("morphinises"),
            &[(0b10010, &ENTRY_MORPHINIZES_16172356110250914168)],
        ),
        (
            UniCase::ascii("diarrheas"),
            &[(0b11001, &ENTRY_DIARRHEAS_11453476003683730830)],
        ),
        (
            UniCase::ascii("skepticizes"),
            &[(0b01001, &ENTRY_SKEPTICIZES_1621712858377146669)],
        ),
        (
            UniCase::ascii("radicalization"),
            &[(0b01001, &ENTRY_RADICALIZATION_4526956637788815699)],
        ),
        (
            UniCase::ascii("aphorized"),
            &[(0b01001, &ENTRY_APHORIZED_1699636898236576866)],
        ),
        (
            UniCase::ascii("civilized"),
            &[(0b01001, &ENTRY_CIVILIZED_12545974517817432534)],
        ),
        (
            UniCase::ascii("trollied"),
            &[(0b01001, &ENTRY_TROLLEYED_16320990397285120378)],
        ),
        (
            UniCase::ascii("malodourousness"),
            &[(0b11010, &ENTRY_MALODOROUSNESS_6015133417028203806)],
        ),
        (
            UniCase::ascii("sectionisations"),
            &[(0b10010, &ENTRY_SECTIONIZATIONS_7138672770671968877)],
        ),
        (
            UniCase::ascii("logorrhoea"),
            &[(0b10010, &ENTRY_LOGORRHEA_1908810066516211712)],
        ),
        (
            UniCase::ascii("lyricizing"),
            &[(0b01001, &ENTRY_LYRICIZING_16841414967163210794)],
        ),
        (
            UniCase::ascii("ammoniemia"),
            &[(0b00001, &ENTRY_AMMONIEMIA_12378710937857988312)],
        ),
        (
            UniCase::ascii("magnetizing"),
            &[(0b01001, &ENTRY_MAGNETIZING_10233564042553328529)],
        ),
        (
            UniCase::ascii("sanitiser"),
            &[(0b10010, &ENTRY_SANITIZER_6961399843419580720)],
        ),
        (
            UniCase::ascii("eudemonistical"),
            &[(0b00001, &ENTRY_EUDEMONISTICAL_5594575273383737360)],
        ),
        (
            UniCase::ascii("helloed"),
            &[(0b11010, &ENTRY_HELLED_17922575627420769814)],
        ),
        (
            UniCase::ascii("snorkeling"),
            &[(0b01001, &ENTRY_SNORKELING_16143785804725093743)],
        ),
        (
            UniCase::ascii("dealcoholize"),
            &[(0b01001, &ENTRY_DEALCOHOLIZE_17481590891108727711)],
        ),
        (
            UniCase::ascii("proverbialises"),
            &[(0b10010, &ENTRY_PROVERBIALIZES_5554547456085258371)],
        ),
        (
            UniCase::ascii("faradizes"),
            &[(0b01001, &ENTRY_FARADIZES_516381975059492431)],
        ),
        (
            UniCase::ascii("francise"),
            &[(0b10010, &ENTRY_FRANCIZE_124885689522532518)],
        ),
        (
            UniCase::ascii("paedogenetic"),
            &[(0b11010, &ENTRY_PEDOGENETIC_9300436022082143535)],
        ),
        (
            UniCase::ascii("actualize"),
            &[(0b01001, &ENTRY_ACTUALIZE_13650893073188599056)],
        ),
        (
            UniCase::ascii("theologisers"),
            &[(0b10010, &ENTRY_THEOLOGIZERS_16421415494739610563)],
        ),
        (
            UniCase::ascii("unheroize"),
            &[(0b01001, &ENTRY_UNHEROIZE_16852054084869741483)],
        ),
        (
            UniCase::ascii("regalvanises"),
            &[(0b10010, &ENTRY_REGALVANIZES_4666153610159994761)],
        ),
        (
            UniCase::ascii("afrikanerise"),
            &[(0b10010, &ENTRY_AFRIKANERIZE_10253557183425033567)],
        ),
        (
            UniCase::ascii("operatised"),
            &[(0b10010, &ENTRY_OPERATIZED_5105704374145792138)],
        ),
        (
            UniCase::ascii("uricaemia"),
            &[(0b11010, &ENTRY_URICEMIA_735304459969707353)],
        ),
        (
            UniCase::ascii("oesophagi"),
            &[(0b10010, &ENTRY_ESOPHAGI_16651245992122782472)],
        ),
        (
            UniCase::ascii("ideologise"),
            &[(0b10010, &ENTRY_IDEOLOGIZE_6184243847595357924)],
        ),
        (
            UniCase::ascii("globalise"),
            &[(0b10010, &ENTRY_GLOBALIZE_11826473684785302147)],
        ),
        (
            UniCase::ascii("babylonize"),
            &[(0b01001, &ENTRY_BABYLONIZE_11002600115818594610)],
        ),
        (
            UniCase::ascii("lionised"),
            &[(0b10010, &ENTRY_LIONIZED_1114575847150322021)],
        ),
        (
            UniCase::ascii("colorbreeding"),
            &[(0b11001, &ENTRY_COLORBREEDING_14262752611756151320)],
        ),
        (
            UniCase::ascii("pyrolyzer"),
            &[(0b00001, &ENTRY_PYROLYZER_11614680328839062524)],
        ),
        (
            UniCase::ascii("institutionises"),
            &[(0b10010, &ENTRY_INSTITUTIONIZES_10150724383117783571)],
        ),
        (
            UniCase::ascii("grangerizes"),
            &[(0b01001, &ENTRY_GRANGERIZES_13688800262712479914)],
        ),
        (
            UniCase::ascii("neighboured"),
            &[(0b11010, &ENTRY_NEIGHBORED_2912814830482160893)],
        ),
        (
            UniCase::ascii("immortalisabler"),
            &[(0b10010, &ENTRY_IMMORTALIZABLER_564668294341461583)],
        ),
        (
            UniCase::ascii("vulcanizers"),
            &[(0b01001, &ENTRY_VULCANIZERS_4164062164915178108)],
        ),
        (
            UniCase::ascii("mendelises"),
            &[(0b10010, &ENTRY_MENDELIZES_11591249054331616238)],
        ),
        (
            UniCase::ascii("vavasour"),
            &[(0b11010, &ENTRY_VAVASOR_6555930671551149776)],
        ),
        (
            UniCase::ascii("mirrorise"),
            &[(0b10010, &ENTRY_MIRRORIZE_11945337347676406290)],
        ),
        (
            UniCase::ascii("gynaecic"),
            &[(0b11010, &ENTRY_GYNECIC_4612357248684171733)],
        ),
        (
            UniCase::ascii("prerealize"),
            &[(0b01001, &ENTRY_PREREALIZE_10993114358642100374)],
        ),
        (
            UniCase::ascii("respectabilising"),
            &[(0b10010, &ENTRY_RESPECTABILIZING_10915529601473940175)],
        ),
        (
            UniCase::ascii("gonorrhealest"),
            &[(0b11001, &ENTRY_GONORRHEALEST_7581818766613734397)],
        ),
        (
            UniCase::ascii("tranquillization"),
            &[(0b01001, &ENTRY_TRANQUILLIZATION_11946857030526310268)],
        ),
        (
            UniCase::ascii("subflavors"),
            &[(0b00001, &ENTRY_SUBFLAVORS_14563327931975471334)],
        ),
        (
            UniCase::ascii("hyperpnoea"),
            &[(0b11010, &ENTRY_HYPERPNEA_12342432255421507220)],
        ),
        (
            UniCase::ascii("indianised"),
            &[(0b10010, &ENTRY_INDIANIZED_6203878007785616549)],
        ),
        (
            UniCase::ascii("serialised"),
            &[(0b10010, &ENTRY_SERIALIZED_1888364664748280784)],
        ),
        (
            UniCase::ascii("palaeophytic"),
            &[(0b11010, &ENTRY_PALEOPHYTIC_11763578694401197746)],
        ),
        (
            UniCase::ascii("lairize"),
            &[(0b01001, &ENTRY_LAIRIZE_17048626001120383827)],
        ),
        (
            UniCase::ascii("saxonized"),
            &[(0b01001, &ENTRY_SAXONIZED_12370590955724966093)],
        ),
        (
            UniCase::ascii("albuminise"),
            &[(0b10010, &ENTRY_ALBUMENIZE_15336406098611814458)],
        ),
        (
            UniCase::ascii("wantonizes"),
            &[(0b01001, &ENTRY_WANTONIZES_8102013437087314845)],
        ),
        (
            UniCase::ascii("banalisations"),
            &[(0b10010, &ENTRY_BANALIZATIONS_13442258248647777583)],
        ),
        (
            UniCase::ascii("reforestisation"),
            &[(0b10010, &ENTRY_REFORESTIZATION_9160443628806080238)],
        ),
        (
            UniCase::ascii("hyalinizations"),
            &[(0b01001, &ENTRY_HYALINIZATIONS_5013187970535765431)],
        ),
        (
            UniCase::ascii("immoralise"),
            &[(0b10010, &ENTRY_IMMORALIZE_12133461291897920761)],
        ),
        (
            UniCase::ascii("subjectivization"),
            &[(0b01001, &ENTRY_SUBJECTIVIZATION_10907308115440153544)],
        ),
        (
            UniCase::ascii("gynecic"),
            &[(0b10001, &ENTRY_GYNECIC_4612357248684171733)],
        ),
        (
            UniCase::ascii("unpaganise"),
            &[(0b10010, &ENTRY_UNPAGANIZE_10797468704092625272)],
        ),
        (
            UniCase::ascii("cecally"),
            &[(0b10001, &ENTRY_CECALLY_12720796600011784892)],
        ),
        (
            UniCase::ascii("institutionalising"),
            &[(0b10010, &ENTRY_INSTITUTIONALIZING_5314493516630022554)],
        ),
        (
            UniCase::ascii("communizations"),
            &[(0b01001, &ENTRY_COMMUNIZATIONS_9900325170167101461)],
        ),
        (
            UniCase::ascii("theorizations"),
            &[(0b01001, &ENTRY_THEORIZATIONS_1710707944075838400)],
        ),
        (
            UniCase::ascii("improvisatorises"),
            &[(0b10010, &ENTRY_IMPROVIZATORIZES_6258011353493362699)],
        ),
        (
            UniCase::ascii("suberized"),
            &[(0b01001, &ENTRY_SUBERIZED_10174332333495953086)],
        ),
        (
            UniCase::ascii("snorkelled"),
            &[(0b11010, &ENTRY_SNORKELED_17424014433959603672)],
        ),
        (
            UniCase::ascii("bromoethylene"),
            &[(0b11010, &ENTRY_BROMETHYLENE_12089993515876146438)],
        ),
        (
            UniCase::ascii("paleentomology"),
            &[(0b00001, &ENTRY_PALEENTOMOLOGY_9853812566754690275)],
        ),
        (
            UniCase::ascii("dissocialized"),
            &[(0b01001, &ENTRY_DISSOCIALIZED_948976280000356279)],
        ),
        (
            UniCase::ascii("moisturises"),
            &[(0b10010, &ENTRY_MOISTURIZES_12009510094905479817)],
        ),
        (
            UniCase::ascii("initializers"),
            &[(0b01001, &ENTRY_INITIALIZERS_12398839316559453843)],
        ),
        (
            UniCase::ascii("terrestrialises"),
            &[(0b10010, &ENTRY_TERRESTRIALIZES_6624949095978395018)],
        ),
        (
            UniCase::ascii("rhythmization"),
            &[(0b01001, &ENTRY_RHYTHMIZATION_16019734668485258402)],
        ),
        (
            UniCase::ascii("grecian"),
            &[(0b00001, &ENTRY_GRECIAN_417997226095522101)],
        ),
        (
            UniCase::ascii("revitalizes"),
            &[(0b01001, &ENTRY_REVITALIZES_17733294788931304767)],
        ),
        (
            UniCase::ascii("palaeogeographer"),
            &[(0b11010, &ENTRY_PALEOGEOGRAPHER_6181412299853337706)],
        ),
        (
            UniCase::ascii("salinize"),
            &[(0b01001, &ENTRY_SALINIZE_1624463717219344911)],
        ),
        (
            UniCase::ascii("oxygenizing"),
            &[(0b01001, &ENTRY_OXYGENIZING_14936091316073194120)],
        ),
        (
            UniCase::ascii("libellouser"),
            &[(0b11010, &ENTRY_LIBELOUSER_15753313718045269506)],
        ),
        (
            UniCase::ascii("jailor"),
            &[(0b01001, &ENTRY_JAILER_1369890010036246012)],
        ),
        (
            UniCase::ascii("thyroidizations"),
            &[(0b01001, &ENTRY_THYROIDIZATIONS_15147067345688634277)],
        ),
        (
            UniCase::ascii("categorise"),
            &[(0b10010, &ENTRY_CATEGORIZE_12360966269850201965)],
        ),
        (
            UniCase::ascii("ammocoetes"),
            &[(0b11010, &ENTRY_AMMOCETES_15510029871033694789)],
        ),
        (
            UniCase::ascii("uncriticisables"),
            &[(0b10010, &ENTRY_UNCRITICIZABLES_12700073615320281916)],
        ),
        (
            UniCase::ascii("surgerises"),
            &[(0b10010, &ENTRY_SURGERIZES_13175724116978873269)],
        ),
        (
            UniCase::ascii("homoeomery"),
            &[(0b11010, &ENTRY_HOMEOMERY_5639570395337974043)],
        ),
        (
            UniCase::ascii("unfossilizeds"),
            &[(0b01001, &ENTRY_UNFOSSILIZEDS_11821803111813998857)],
        ),
        (
            UniCase::ascii("recognisinglies"),
            &[(0b10010, &ENTRY_RECOGNIZINGLIES_11967771031854316683)],
        ),
        (
            UniCase::ascii("demilitarise"),
            &[(0b10010, &ENTRY_DEMILITARIZE_16703679582695532386)],
        ),
        (
            UniCase::ascii("aerographer"),
            &[(0b00001, &ENTRY_AEROGRAPHER_10717546778729152195)],
        ),
        (
            UniCase::ascii("initialed"),
            &[(0b01001, &ENTRY_INITIALED_1122623591354647527)],
        ),
        (
            UniCase::ascii("unminimising"),
            &[(0b10010, &ENTRY_UNMINIMIZING_14406353280475862221)],
        ),
        (
            UniCase::ascii("superspecialize"),
            &[(0b01001, &ENTRY_SUPERSPECIALIZE_252058508575789924)],
        ),
        (
            UniCase::ascii("colorin"),
            &[(0b00001, &ENTRY_COLORIN_7364447797547189461)],
        ),
        (
            UniCase::ascii("saccharise"),
            &[(0b10010, &ENTRY_SACCHARIZE_8112536361258402472)],
        ),
        (
            UniCase::ascii("hibernicising"),
            &[(0b10010, &ENTRY_HIBERNICIZING_14639684283522219260)],
        ),
        (
            UniCase::ascii("fluidising"),
            &[(0b10010, &ENTRY_FLUIDIZING_18408628175522942192)],
        ),
        (
            UniCase::ascii("foeticides"),
            &[(0b10010, &ENTRY_FETICIDES_13716695115962439528)],
        ),
        (
            UniCase::ascii("aggrandisables"),
            &[(0b10010, &ENTRY_AGGRANDIZABLES_10156833661701900004)],
        ),
        (
            UniCase::ascii("eulogizing"),
            &[(0b01001, &ENTRY_EULOGIZING_12476629388826192151)],
        ),
        (
            UniCase::ascii("orientalisation"),
            &[(0b10010, &ENTRY_ORIENTALIZATION_16408076822380414996)],
        ),
        (
            UniCase::ascii("citizenizes"),
            &[(0b01001, &ENTRY_CITIZENIZES_18430750407999070293)],
        ),
        (
            UniCase::ascii("preoxidises"),
            &[(0b10010, &ENTRY_PREOXIDIZES_17578000495699558353)],
        ),
        (
            UniCase::ascii("packetizes"),
            &[(0b01001, &ENTRY_PACKETIZES_2813822036312110356)],
        ),
        (
            UniCase::ascii("urohaematin"),
            &[(0b11010, &ENTRY_UROHEMATIN_18414252065450864526)],
        ),
        (
            UniCase::ascii("familiarise"),
            &[(0b10010, &ENTRY_FAMILIARIZE_6458271230166262342)],
        ),
        (
            UniCase::ascii("vampirizes"),
            &[(0b01001, &ENTRY_VAMPIRIZES_15605173529611826568)],
        ),
        (
            UniCase::ascii("gospelise"),
            &[(0b10010, &ENTRY_GOSPELIZE_17132485493253272517)],
        ),
        (
            UniCase::ascii("hispaniolises"),
            &[(0b10010, &ENTRY_HISPANIOLIZES_15865799872959107963)],
        ),
        (
            UniCase::ascii("breathalysing"),
            &[(0b11010, &ENTRY_BREATHALYZING_9538292620264111634)],
        ),
        (
            UniCase::ascii("archaeometries"),
            &[(0b11010, &ENTRY_ARCHEOMETRIES_9109698910620640943)],
        ),
        (
            UniCase::ascii("canisterizing"),
            &[(0b01001, &ENTRY_CANISTERIZING_3833251549971264383)],
        ),
        (
            UniCase::ascii("laborings"),
            &[(0b11001, &ENTRY_LABORINGS_10460452481863076398)],
        ),
        (
            UniCase::ascii("demagnetized"),
            &[(0b01001, &ENTRY_DEMAGNETIZED_429555390860227118)],
        ),
        (
            UniCase::ascii("pedomorphic"),
            &[(0b00001, &ENTRY_PEDOMORPHIC_6860459212658075764)],
        ),
        (
            UniCase::ascii("experimentalise"),
            &[(0b10010, &ENTRY_EXPERIMENTALIZE_7321825952497189376)],
        ),
        (
            UniCase::ascii("unpatronisable"),
            &[(0b10010, &ENTRY_UNPATRONIZABLE_1362396864066933771)],
        ),
        (
            UniCase::ascii("rigorism"),
            &[(0b00001, &ENTRY_RIGORISM_14069127364398578519)],
        ),
        (
            UniCase::ascii("attitudinizing"),
            &[(0b01001, &ENTRY_ATTITUDINIZING_3722680743543175700)],
        ),
        (
            UniCase::ascii("fragmentize"),
            &[(0b01001, &ENTRY_FRAGMENTIZE_7391127946985078106)],
        ),
        (
            UniCase::ascii("overindustrializations"),
            &[(0b01001, &ENTRY_OVERINDUSTRIALIZATIONS_2479660567106903260)],
        ),
        (
            UniCase::ascii("contemporize"),
            &[(0b01001, &ENTRY_CONTEMPORIZE_5008428677635696983)],
        ),
        (
            UniCase::ascii("diabolised"),
            &[(0b10010, &ENTRY_DIABOLIZED_5121441305555041821)],
        ),
        (
            UniCase::ascii("aerography"),
            &[(0b00001, &ENTRY_AEROGRAPHY_8481321619438820366)],
        ),
        (
            UniCase::ascii("unmilitarized"),
            &[(0b01001, &ENTRY_UNMILITARIZED_583903044185013301)],
        ),
        (
            UniCase::ascii("likability"),
            &[(0b10001, &ENTRY_LIKABILITY_17749543815120781481)],
        ),
        (
            UniCase::ascii("transcolour"),
            &[(0b11010, &ENTRY_TRANSCOLOR_3566969815815539331)],
        ),
        (
            UniCase::ascii("virtualizes"),
            &[(0b01001, &ENTRY_VIRTUALIZES_1664114726545811102)],
        ),
        (
            UniCase::ascii("vocalizes"),
            &[(0b01001, &ENTRY_VOCALIZES_1880412935306735877)],
        ),
        (
            UniCase::ascii("unformalizedder"),
            &[(0b01001, &ENTRY_UNFORMALIZEDDER_16826016574168323811)],
        ),
        (
            UniCase::ascii("grammaticised"),
            &[(0b10010, &ENTRY_GRAMMATICIZED_555586288585252490)],
        ),
        (
            UniCase::ascii("hydrolyzer"),
            &[(0b01001, &ENTRY_HYDROLYZER_7963252770617082917)],
        ),
        (
            UniCase::ascii("pajamaed"),
            &[(0b00001, &ENTRY_PAJAMAED_5631330919975772121)],
        ),
        (
            UniCase::ascii("savoringlies"),
            &[(0b11001, &ENTRY_SAVORINGLIES_16962535350125218546)],
        ),
        (
            UniCase::ascii("electrised"),
            &[(0b10010, &ENTRY_ELECTRIZED_14788122243236354566)],
        ),
        (
            UniCase::ascii("undercoloring"),
            &[(0b00001, &ENTRY_UNDERCOLORING_7781389003709580079)],
        ),
        (
            UniCase::ascii("jonathanisations"),
            &[(0b10010, &ENTRY_JONATHANIZATIONS_7547805422547054800)],
        ),
        (
            UniCase::ascii("contemporisation"),
            &[(0b10010, &ENTRY_CONTEMPORIZATION_16780108593197095593)],
        ),
        (
            UniCase::ascii("ire"),
            &[(0b11010, &ENTRY_IER_8590173399354916659)],
        ),
        (
            UniCase::ascii("inthrall"),
            &[(0b10010, &ENTRY_ENTHRALL_16443508848218743746)],
        ),
        (
            UniCase::ascii("underemphasise"),
            &[(0b10010, &ENTRY_UNDEREMPHASIZE_16005848787441654782)],
        ),
        (
            UniCase::ascii("decriminalise"),
            &[(0b10010, &ENTRY_DECRIMINALIZE_6091198611704708595)],
        ),
        (
            UniCase::ascii("sherardise"),
            &[(0b10010, &ENTRY_SHERARDIZE_16617170604726285533)],
        ),
        (
            UniCase::ascii("asiaticises"),
            &[(0b10010, &ENTRY_ASIATICIZES_16830856299856603906)],
        ),
        (
            UniCase::ascii("oestrums"),
            &[(0b11010, &ENTRY_ESTRUMS_13425140989742183588)],
        ),
        (
            UniCase::ascii("traumatization"),
            &[(0b01001, &ENTRY_TRAUMATIZATION_3746681776679931423)],
        ),
        (
            UniCase::ascii("ochrest"),
            &[(0b11010, &ENTRY_OCHERREST_9858563234413281789)],
        ),
        (
            UniCase::ascii("gallicize"),
            &[(0b01001, &ENTRY_GALLICIZE_5782054308440267768)],
        ),
        (
            UniCase::ascii("catholicisation"),
            &[(0b10010, &ENTRY_CATHOLICIZATION_1039966536643797028)],
        ),
        (
            UniCase::ascii("germanizer"),
            &[(0b01001, &ENTRY_GERMANIZER_1963166703182074320)],
        ),
        (
            UniCase::ascii("anathematizes"),
            &[(0b01001, &ENTRY_ANATHEMATIZES_8973479734940337633)],
        ),
        (
            UniCase::ascii("modeller"),
            &[(0b11010, &ENTRY_MODELER_15810368749048552373)],
        ),
        (
            UniCase::ascii("banalization"),
            &[(0b01001, &ENTRY_BANALIZATION_11638029989791824412)],
        ),
        (
            UniCase::ascii("pressurisations"),
            &[(0b10010, &ENTRY_PRESSURIZATIONS_9413572764001477371)],
        ),
        (
            UniCase::ascii("epitomisation"),
            &[(0b10010, &ENTRY_EPITOMIZATION_16124019439482652962)],
        ),
        (
            UniCase::ascii("journalisation"),
            &[(0b10010, &ENTRY_JOURNALIZATION_359433808018629079)],
        ),
        (
            UniCase::ascii("stylizing"),
            &[(0b01001, &ENTRY_STYLIZING_9348895301814219487)],
        ),
        (
            UniCase::ascii("caponization"),
            &[(0b01001, &ENTRY_CAPONIZATION_1938263787545597969)],
        ),
        (
            UniCase::ascii("thalassaemias"),
            &[(0b11010, &ENTRY_THALASSEMIAS_2823805934181113644)],
        ),
        (
            UniCase::ascii("philistinizing"),
            &[(0b01001, &ENTRY_PHILISTINIZING_14787991683374543288)],
        ),
        (
            UniCase::ascii("paleontologists"),
            &[(0b11001, &ENTRY_PALEONTOLOGISTS_13268509669082698999)],
        ),
        (
            UniCase::ascii("sentimentalised"),
            &[(0b10010, &ENTRY_SENTIMENTALIZED_7395272655741592803)],
        ),
        (
            UniCase::ascii("demineralizer"),
            &[(0b01001, &ENTRY_DEMINERALIZER_11839062214960881518)],
        ),
        (
            UniCase::ascii("anserinae"),
            &[(0b11010, &ENTRY_ANSERINE_7284353552541073260)],
        ),
        (
            UniCase::ascii("autecism"),
            &[(0b00001, &ENTRY_AUTECISM_1715619165077149465)],
        ),
        (
            UniCase::ascii("disorganisations"),
            &[(0b10010, &ENTRY_DISORGANIZATIONS_14738569434179616840)],
        ),
        (
            UniCase::ascii("micromillimeter"),
            &[(0b00001, &ENTRY_MICROMILLIMETER_10473316398408026315)],
        ),
        (
            UniCase::ascii("favoriter"),
            &[(0b11001, &ENTRY_FAVORITER_7692783527526236076)],
        ),
        (
            UniCase::ascii("spermatorrhea"),
            &[(0b00001, &ENTRY_SPERMATORRHEA_11364148558414858528)],
        ),
        (
            UniCase::ascii("photosensitizers"),
            &[(0b01001, &ENTRY_PHOTOSENSITIZERS_9865390720202085290)],
        ),
        (
            UniCase::ascii("tels"),
            &[(0b00001, &ENTRY_TELS_3007087834331223229)],
        ),
        (
            UniCase::ascii("transcendentalizing"),
            &[(0b01001, &ENTRY_TRANSCENDENTALIZING_1803732975904952155)],
        ),
        (
            UniCase::ascii("petrarchizing"),
            &[(0b01001, &ENTRY_PETRARCHIZING_12012636599315128862)],
        ),
        (
            UniCase::ascii("empanelling"),
            &[(0b11010, &ENTRY_IMPANELING_8436697861195228668)],
        ),
        (
            UniCase::ascii("paleoentomologic"),
            &[(0b10001, &ENTRY_PALEOENTOMOLOGIC_383886705450148741)],
        ),
        (
            UniCase::ascii("uncurricularised"),
            &[(0b10010, &ENTRY_UNCURRICULARIZED_1510394198207258931)],
        ),
        (
            UniCase::ascii("parisianisation"),
            &[(0b10010, &ENTRY_PARISIANIZATION_2149081518294904073)],
        ),
        (
            UniCase::ascii("revitalizers"),
            &[(0b01001, &ENTRY_REVITALIZERS_8120596477873838119)],
        ),
        (
            UniCase::ascii("finalises"),
            &[(0b10010, &ENTRY_FINALIZES_15580788945544450334)],
        ),
        (
            UniCase::ascii("facsimilise"),
            &[(0b10010, &ENTRY_FACSIMILIZE_9828221696654309927)],
        ),
        (
            UniCase::ascii("colorant"),
            &[(0b11001, &ENTRY_COLORANT_105918244627467133)],
        ),
        (
            UniCase::ascii("aryanized"),
            &[(0b01001, &ENTRY_ARYANIZED_2198024662554456823)],
        ),
        (
            UniCase::ascii("palatalizations"),
            &[(0b01001, &ENTRY_PALATALIZATIONS_7795389490222118981)],
        ),
        (
            UniCase::ascii("unparagonized"),
            &[(0b01001, &ENTRY_UNPARAGONIZED_11641249067400700762)],
        ),
        (
            UniCase::ascii("monumentalised"),
            &[(0b10010, &ENTRY_MONUMENTALIZED_10548767854996105071)],
        ),
        (
            UniCase::ascii("palatalize"),
            &[(0b01001, &ENTRY_PALATALIZE_16275238324442191490)],
        ),
        (
            UniCase::ascii("peroxidises"),
            &[(0b10010, &ENTRY_PEROXIDIZES_2231452525489889274)],
        ),
        (
            UniCase::ascii("greisenizes"),
            &[(0b01001, &ENTRY_GREISENIZES_10589439824485596475)],
        ),
        (
            UniCase::ascii("gelatinisability"),
            &[(0b10010, &ENTRY_GELATINIZABILITY_11867008106433996321)],
        ),
        (
            UniCase::ascii("ungeneralizeddest"),
            &[(0b01001, &ENTRY_UNGENERALIZEDDEST_10234603051627457134)],
        ),
        (
            UniCase::ascii("exorcizer"),
            &[(0b01001, &ENTRY_EXORCIZER_10300614530359206460)],
        ),
        (
            UniCase::ascii("craisey"),
            &[(0b10010, &ENTRY_CRAIZEY_11207510142316496553)],
        ),
        (
            UniCase::ascii("templise"),
            &[(0b10010, &ENTRY_TEMPLIZE_3769471964247003706)],
        ),
        (
            UniCase::ascii("papulae"),
            &[(0b11010, &ENTRY_PAPULE_7630225005240179696)],
        ),
        (
            UniCase::ascii("uncatholicizes"),
            &[(0b01001, &ENTRY_UNCATHOLICIZES_8958496403317373578)],
        ),
        (
            UniCase::ascii("individualize"),
            &[(0b01001, &ENTRY_INDIVIDUALIZE_13939176487047243121)],
        ),
        (
            UniCase::ascii("artificialises"),
            &[(0b10010, &ENTRY_ARTIFICIALIZES_12340528017967580371)],
        ),
        (
            UniCase::ascii("paroecism"),
            &[(0b11010, &ENTRY_PARECISM_15139198512135907949)],
        ),
        (
            UniCase::ascii("nasalised"),
            &[(0b10010, &ENTRY_NASALIZED_1174190894841693819)],
        ),
        (
            UniCase::ascii("esthetic"),
            &[(0b11001, &ENTRY_AESTHETIC_854984485637846897)],
        ),
        (
            UniCase::ascii("perlection"),
            &[(0b00001, &ENTRY_PERLECTION_3296452498431632093)],
        ),
        (
            UniCase::ascii("synaesthesia"),
            &[(0b11010, &ENTRY_SYNESTHESIA_16292496210206747868)],
        ),
        (
            UniCase::ascii("experimentalizes"),
            &[(0b01001, &ENTRY_EXPERIMENTALIZES_17353857217605159387)],
        ),
        (
            UniCase::ascii("whitmanize"),
            &[(0b01001, &ENTRY_WHITMANIZE_17709805677202222665)],
        ),
        (
            UniCase::ascii("nonrationaliseds"),
            &[(0b10010, &ENTRY_NONRATIONALIZEDS_18331202286549559702)],
        ),
        (
            UniCase::ascii("hierarchised"),
            &[(0b10010, &ENTRY_HIERARCHIZED_2434677209411391895)],
        ),
        (
            UniCase::ascii("eternised"),
            &[(0b10010, &ENTRY_ETERNIZED_803700093303685693)],
        ),
        (
            UniCase::ascii("dimerisation"),
            &[(0b10010, &ENTRY_DIMERIZATION_15302035121240997222)],
        ),
        (
            UniCase::ascii("demonetisation"),
            &[(0b10010, &ENTRY_DEMONETIZATION_10800150167569494235)],
        ),
        (
            UniCase::ascii("unmoralized"),
            &[(0b01001, &ENTRY_UNMORALIZED_1809019658766145871)],
        ),
        (
            UniCase::ascii("mithridatising"),
            &[(0b10010, &ENTRY_MITHRIDATIZING_9625317964263865406)],
        ),
        (
            UniCase::ascii("unauthorises"),
            &[(0b10010, &ENTRY_UNAUTHORIZES_15223481987545098919)],
        ),
        (
            UniCase::ascii("prefloration"),
            &[(0b00001, &ENTRY_PREFLORATION_11916715073975297394)],
        ),
        (
            UniCase::ascii("polemises"),
            &[(0b10010, &ENTRY_POLEMIZES_15540925378458860831)],
        ),
        (
            UniCase::ascii("deviled"),
            &[(0b00001, &ENTRY_DEVILED_13014517801589922329)],
        ),
        (
            UniCase::ascii("fiberglasses"),
            &[(0b00001, &ENTRY_FIBERGLASSES_9573599106910515750)],
        ),
        (
            UniCase::ascii("autotoxaemia"),
            &[(0b11010, &ENTRY_AUTOTOXEMIA_18366267511576797743)],
        ),
        (
            UniCase::ascii("aromatiser"),
            &[(0b10010, &ENTRY_AROMATIZER_9784880273725424914)],
        ),
        (
            UniCase::ascii("colourisms"),
            &[(0b11010, &ENTRY_COLORISMS_9834615672957808489)],
        ),
        (
            UniCase::ascii("unmesmeriseddest"),
            &[(0b10010, &ENTRY_UNMESMERIZEDDEST_6656931439181344486)],
        ),
        (
            UniCase::ascii("sisterizes"),
            &[(0b01001, &ENTRY_SISTERIZES_17019596055143071237)],
        ),
        (
            UniCase::ascii("balladizing"),
            &[(0b01001, &ENTRY_BALLADIZING_3534870542470368404)],
        ),
        (
            UniCase::ascii("sacerdotalised"),
            &[(0b10010, &ENTRY_SACERDOTALIZED_3090555217942359397)],
        ),
        (
            UniCase::ascii("arterialise"),
            &[(0b10010, &ENTRY_ARTERIALIZE_4417484011804302892)],
        ),
        (
            UniCase::ascii("dimensionalise"),
            &[(0b10010, &ENTRY_DIMENSIONALIZE_17867138639749619838)],
        ),
        (
            UniCase::ascii("balkanises"),
            &[(0b10010, &ENTRY_BALKANIZES_15710898030250571993)],
        ),
        (
            UniCase::ascii("hypothesized"),
            &[(0b01001, &ENTRY_HYPOTHESIZED_7654092048334444056)],
        ),
        (
            UniCase::ascii("psychoanalysers"),
            &[(0b10010, &ENTRY_PSYCHOANALYZERS_1935290147506502388)],
        ),
        (
            UniCase::ascii("satirises"),
            &[(0b10010, &ENTRY_SATIRIZES_10052925778146532918)],
        ),
        (
            UniCase::ascii("bowdlerizations"),
            &[(0b01001, &ENTRY_BOWDLERIZATIONS_4765159417978820500)],
        ),
        (
            UniCase::ascii("revolutionised"),
            &[(0b10010, &ENTRY_REVOLUTIONIZED_14375673469401672065)],
        ),
        (
            UniCase::ascii("lyophilised"),
            &[(0b10010, &ENTRY_LYOPHILIZED_541457860358035146)],
        ),
        (
            UniCase::ascii("lodicule"),
            &[(0b00001, &ENTRY_LODICULE_12304146402971909793)],
        ),
        (
            UniCase::ascii("undemagnetisables"),
            &[(0b10010, &ENTRY_UNDEMAGNETIZABLES_5686795504114325763)],
        ),
        (
            UniCase::ascii("metathesising"),
            &[(0b10010, &ENTRY_METATHESIZING_6771620324906770468)],
        ),
        (
            UniCase::ascii("penelopizes"),
            &[(0b01001, &ENTRY_PENELOPIZES_15812264060242899742)],
        ),
        (
            UniCase::ascii("controversialises"),
            &[(0b10010, &ENTRY_CONTROVERSIALIZES_7981611622332565361)],
        ),
        (
            UniCase::ascii("fluoridization"),
            &[(0b01001, &ENTRY_FLUORIDIZATION_14827318202477553831)],
        ),
        (
            UniCase::ascii("dieselized"),
            &[(0b01001, &ENTRY_DIESELIZED_1396909342953338000)],
        ),
        (
            UniCase::ascii("haematite"),
            &[(0b10010, &ENTRY_HEMATITE_18189725537336168240)],
        ),
        (
            UniCase::ascii("nonutilised"),
            &[(0b10010, &ENTRY_NONUTILIZED_10968594570869729046)],
        ),
        (
            UniCase::ascii("canalers"),
            &[(0b00001, &ENTRY_CANALERS_7689806565376794966)],
        ),
        (
            UniCase::ascii("atomizations"),
            &[(0b01001, &ENTRY_ATOMIZATIONS_15654929944891871906)],
        ),
        (
            UniCase::ascii("demagnetises"),
            &[(0b10010, &ENTRY_DEMAGNETIZES_2351872097402777148)],
        ),
        (
            UniCase::ascii("catechizers"),
            &[(0b01001, &ENTRY_CATECHIZERS_10089039414007893489)],
        ),
        (
            UniCase::ascii("caespitose"),
            &[(0b11010, &ENTRY_CESPITOSE_2511412164776933409)],
        ),
        (
            UniCase::ascii("bejeweled"),
            &[(0b00001, &ENTRY_BEJEWELED_4984569160882024545)],
        ),
        (
            UniCase::ascii("iodise"),
            &[(0b10010, &ENTRY_IODIZE_6551505461584920010)],
        ),
        (
            UniCase::ascii("conundrumizes"),
            &[(0b01001, &ENTRY_CONUNDRUMIZES_7982003424972698355)],
        ),
        (
            UniCase::ascii("monasticises"),
            &[(0b10010, &ENTRY_MONASTICIZES_11754670453138255334)],
        ),
        (
            UniCase::ascii("epimerise"),
            &[(0b10010, &ENTRY_EPIMERIZE_823465573203429173)],
        ),
        (
            UniCase::ascii("cantonised"),
            &[(0b10010, &ENTRY_CANTONIZED_759359507372098389)],
        ),
        (
            UniCase::ascii("aerologic"),
            &[(0b00001, &ENTRY_AEROLOGIC_6581703267250668822)],
        ),
        (
            UniCase::ascii("palaeoethnology"),
            &[(0b11010, &ENTRY_PALEOETHNOLOGY_8500804609820740340)],
        ),
        (
            UniCase::ascii("albuminized"),
            &[(0b01000, &ENTRY_ALBUMENIZED_9044864672629997378)],
        ),
        (
            UniCase::ascii("winterising"),
            &[(0b10010, &ENTRY_WINTERIZING_11041236811279192392)],
        ),
        (
            UniCase::ascii("balsamise"),
            &[(0b10010, &ENTRY_BALSAMIZE_1201263166025813215)],
        ),
        (
            UniCase::ascii("weatherize"),
            &[(0b01001, &ENTRY_WEATHERIZE_2192670928369527010)],
        ),
        (
            UniCase::ascii("utilisabilities"),
            &[(0b10010, &ENTRY_UTILIZABILITIES_2397151207630807999)],
        ),
        (
            UniCase::ascii("institutionise"),
            &[(0b10010, &ENTRY_INSTITUTIONIZE_10372940805349027641)],
        ),
        (
            UniCase::ascii("uncatechizedness"),
            &[(0b01001, &ENTRY_UNCATECHIZEDNESS_15422372585260862674)],
        ),
        (
            UniCase::ascii("powellise"),
            &[(0b10010, &ENTRY_POWELLIZE_14871332950257843934)],
        ),
        (
            UniCase::ascii("hurricanizes"),
            &[(0b01001, &ENTRY_HURRICANIZES_14038183598909771719)],
        ),
        (
            UniCase::ascii("cadastres"),
            &[(0b11010, &ENTRY_CADASTERS_582180790478148418)],
        ),
        (
            UniCase::ascii("unneighborliness"),
            &[(0b00001, &ENTRY_UNNEIGHBORLINESS_1038976996631322927)],
        ),
        (
            UniCase::ascii("vassalizing"),
            &[(0b01001, &ENTRY_VASSALIZING_12622050688866231311)],
        ),
        (
            UniCase::ascii("unlocalise"),
            &[(0b10010, &ENTRY_UNLOCALIZE_13492036293954003927)],
        ),
        (
            UniCase::ascii("unmacadamised"),
            &[(0b10010, &ENTRY_UNMACADAMIZED_17474698526570727920)],
        ),
        (
            UniCase::ascii("gaolbreaks"),
            &[(0b11010, &ENTRY_JAILBREAKS_14725005275090937373)],
        ),
        (
            UniCase::ascii("ecclesiasticizes"),
            &[(0b01001, &ENTRY_ECCLESIASTICIZES_17947325437796182000)],
        ),
        (
            UniCase::ascii("americanizes"),
            &[(0b01001, &ENTRY_AMERICANIZES_1895797903602224728)],
        ),
        (
            UniCase::ascii("tantalisingliest"),
            &[(0b10010, &ENTRY_TANTALIZINGLIEST_13318655638322508135)],
        ),
        (
            UniCase::ascii("priorizing"),
            &[(0b01001, &ENTRY_PRIORIZING_9325893624043708471)],
        ),
        (
            UniCase::ascii("euphemizers"),
            &[(0b01001, &ENTRY_EUPHEMIZERS_14865306922922439267)],
        ),
        (
            UniCase::ascii("paleornithology"),
            &[(0b10001, &ENTRY_PALEORNITHOLOGY_3476002279004463238)],
        ),
        (
            UniCase::ascii("apothegmatises"),
            &[(0b10010, &ENTRY_APOTHEGMATIZES_3386118086394100613)],
        ),
        (
            UniCase::ascii("institutionalisations"),
            &[(0b10010, &ENTRY_INSTITUTIONALIZATIONS_12755904320513262139)],
        ),
        (
            UniCase::ascii("legalizes"),
            &[(0b01001, &ENTRY_LEGALIZES_8869300296267545710)],
        ),
        (
            UniCase::ascii("derationalization"),
            &[(0b01001, &ENTRY_DERATIONALIZATION_10528830942768591126)],
        ),
        (
            UniCase::ascii("canisterised"),
            &[(0b10010, &ENTRY_CANISTERIZED_11516075806659176774)],
        ),
        (
            UniCase::ascii("ensepulchre"),
            &[(0b11010, &ENTRY_ENSEPULCHER_18433050111369773849)],
        ),
        (
            UniCase::ascii("mitres"),
            &[(0b11010, &ENTRY_MITERS_14490210158644236688)],
        ),
        (
            UniCase::ascii("sterilisabilities"),
            &[(0b10010, &ENTRY_STERILIZABILITIES_6174521207740612143)],
        ),
        (
            UniCase::ascii("cognizanter"),
            &[(0b01001, &ENTRY_COGNIZANTER_9274314327914715355)],
        ),
        (
            UniCase::ascii("structuralises"),
            &[(0b10010, &ENTRY_STRUCTURALIZES_538653414352082587)],
        ),
        (
            UniCase::ascii("unfavourable"),
            &[(0b11010, &ENTRY_UNFAVORABLE_8233532032007631727)],
        ),
        (
            UniCase::ascii("dedramatize"),
            &[(0b01001, &ENTRY_DEDRAMATIZE_13453343698039522020)],
        ),
        (
            UniCase::ascii("centerpieces"),
            &[(0b00001, &ENTRY_CENTERPIECES_2175158136644578025)],
        ),
        (
            UniCase::ascii("republicanizer"),
            &[(0b01001, &ENTRY_REPUBLICANIZER_18381174866390455070)],
        ),
        (
            UniCase::ascii("moms"),
            &[(0b01001, &ENTRY_MOMS_301669076590401125)],
        ),
        (
            UniCase::ascii("pedogenic"),
            &[(0b00001, &ENTRY_PEDOGENIC_15968023895342516337)],
        ),
        (
            UniCase::ascii("unrancoredder"),
            &[(0b00001, &ENTRY_UNRANCOREDDER_6348621930598869186)],
        ),
        (
            UniCase::ascii("unappetisinger"),
            &[(0b10010, &ENTRY_UNAPPETIZINGER_11663943688244312711)],
        ),
        (
            UniCase::ascii("stencilling"),
            &[(0b11010, &ENTRY_STENCILING_2842472389755702411)],
        ),
        (
            UniCase::ascii("luteinizing"),
            &[(0b01001, &ENTRY_LUTEINIZING_12727551757461309338)],
        ),
        (
            UniCase::ascii("trichotomising"),
            &[(0b10010, &ENTRY_TRICHOTOMIZING_4094867634668496821)],
        ),
        (
            UniCase::ascii("haematologies"),
            &[(0b10010, &ENTRY_HEMATOLOGIES_13320136886151112131)],
        ),
        (
            UniCase::ascii("optimisation"),
            &[(0b10010, &ENTRY_OPTIMIZATION_13814783904890834134)],
        ),
        (
            UniCase::ascii("objectisations"),
            &[(0b10010, &ENTRY_OBJECTIZATIONS_6401266830241310518)],
        ),
        (
            UniCase::ascii("causticization"),
            &[(0b01001, &ENTRY_CAUSTICIZATION_14179900306302530284)],
        ),
        (
            UniCase::ascii("soliloquization"),
            &[(0b01001, &ENTRY_SOLILOQUIZATION_269312513960661785)],
        ),
        (
            UniCase::ascii("amoebean"),
            &[(0b11010, &ENTRY_AMEBEAN_1913759118822823378)],
        ),
        (
            UniCase::ascii("characterizable"),
            &[(0b01001, &ENTRY_CHARACTERIZABLE_5496268454277897612)],
        ),
        (
            UniCase::ascii("yodelling"),
            &[(0b11010, &ENTRY_YODELING_14921433313912990218)],
        ),
        (
            UniCase::ascii("parecious"),
            &[(0b10001, &ENTRY_PARECIOUS_12511564458907798074)],
        ),
        (
            UniCase::ascii("rhetorize"),
            &[(0b01001, &ENTRY_RHETORIZE_15085474485565052687)],
        ),
        (
            UniCase::ascii("harbouring"),
            &[(0b11010, &ENTRY_HARBORING_8402517685558870632)],
        ),
        (
            UniCase::ascii("palaeobotanical"),
            &[(0b11010, &ENTRY_PALEOBOTANICAL_15741271816715346651)],
        ),
        (
            UniCase::ascii("favour"),
            &[(0b11010, &ENTRY_FAVOR_16174102806904091593)],
        ),
        (
            UniCase::ascii("mythises"),
            &[(0b10010, &ENTRY_MYTHIZES_1545681173644864391)],
        ),
        (
            UniCase::ascii("unequalize"),
            &[(0b01001, &ENTRY_UNEQUALIZE_12397832983269467070)],
        ),
        (
            UniCase::ascii("uncriticizingly"),
            &[(0b01001, &ENTRY_UNCRITICIZINGLY_8633111293350941138)],
        ),
        (
            UniCase::ascii("demilitarizing"),
            &[(0b01001, &ENTRY_DEMILITARIZING_5137023236614361970)],
        ),
        (
            UniCase::ascii("crystallisabilities"),
            &[(0b10010, &ENTRY_CRYSTALLIZABILITIES_3954684427565379393)],
        ),
        (
            UniCase::ascii("maera"),
            &[(0b11010, &ENTRY_MERA_2238379545822097898)],
        ),
        (
            UniCase::ascii("luteinisations"),
            &[(0b10010, &ENTRY_LUTEINIZATIONS_2301336961919403024)],
        ),
        (
            UniCase::ascii("unparalyzedder"),
            &[(0b00001, &ENTRY_UNPARALYZEDDER_10074788125617493696)],
        ),
        (
            UniCase::ascii("dedramatized"),
            &[(0b01001, &ENTRY_DEDRAMATIZED_322035020814147818)],
        ),
        (
            UniCase::ascii("recognisable"),
            &[(0b10010, &ENTRY_RECOGNIZABLE_5889010403845230013)],
        ),
        (
            UniCase::ascii("niter"),
            &[(0b00001, &ENTRY_NITER_4595235793148205687)],
        ),
        (
            UniCase::ascii("leucorrheas"),
            &[(0b00001, &ENTRY_LEUCORRHEAS_12147874623824130705)],
        ),
        (
            UniCase::ascii("publicize"),
            &[(0b01001, &ENTRY_PUBLICIZE_3888814953502121211)],
        ),
        (
            UniCase::ascii("dialogize"),
            &[(0b01001, &ENTRY_DIALOGIZE_3147664435711992783)],
        ),
        (
            UniCase::ascii("suburbanize"),
            &[(0b01001, &ENTRY_SUBURBANIZE_7361825706290430577)],
        ),
        (
            UniCase::ascii("ruralise"),
            &[(0b10010, &ENTRY_RURALIZE_10315684701653459711)],
        ),
        (
            UniCase::ascii("unmoralizinger"),
            &[(0b01001, &ENTRY_UNMORALIZINGER_2630621700200103097)],
        ),
        (
            UniCase::ascii("mithridatised"),
            &[(0b10010, &ENTRY_MITHRIDATIZED_11801964586289066812)],
        ),
        (
            UniCase::ascii("dentalising"),
            &[(0b10010, &ENTRY_DENTALIZING_324908095822959388)],
        ),
        (
            UniCase::ascii("scourses"),
            &[(0b11010, &ENTRY_SCORSES_7140175579256526605)],
        ),
        (
            UniCase::ascii("choenixes"),
            &[(0b11010, &ENTRY_CHENIXES_18140842653808609264)],
        ),
        (
            UniCase::ascii("uncaramelized"),
            &[(0b01001, &ENTRY_UNCARAMELIZED_14866858801643238047)],
        ),
        (
            UniCase::ascii("presidia"),
            &[(0b00001, &ENTRY_PRESIDIUMS_9456994175801399467)],
        ),
        (
            UniCase::ascii("unevangeliseds"),
            &[(0b10010, &ENTRY_UNEVANGELIZEDS_4997587800538848322)],
        ),
        (
            UniCase::ascii("operatising"),
            &[(0b10010, &ENTRY_OPERATIZING_8904168123042897096)],
        ),
        (
            UniCase::ascii("hematogenous"),
            &[(0b10001, &ENTRY_HEMATOGENOUS_251917998139736524)],
        ),
        (
            UniCase::ascii("decimalizations"),
            &[(0b01001, &ENTRY_DECIMALIZATIONS_7263991078898399657)],
        ),
        (
            UniCase::ascii("unfamiliarised"),
            &[(0b10010, &ENTRY_UNFAMILIARIZED_8539267182006341403)],
        ),
        (
            UniCase::ascii("prefavourably"),
            &[(0b11010, &ENTRY_PREFAVORABLY_2906405353959131669)],
        ),
        (
            UniCase::ascii("vaporising"),
            &[(0b10010, &ENTRY_VAPORIZING_11720449073985132085)],
        ),
        (
            UniCase::ascii("prerealisation"),
            &[(0b10010, &ENTRY_PREREALIZATION_4400758119524381256)],
        ),
        (
            UniCase::ascii("myxemia"),
            &[(0b10001, &ENTRY_MYXEMIA_10745005304996222059)],
        ),
        (
            UniCase::ascii("sorbitised"),
            &[(0b10010, &ENTRY_SORBITIZED_11029247990437433113)],
        ),
        (
            UniCase::ascii("monologized"),
            &[(0b01001, &ENTRY_MONOLOGIZED_213349531977540597)],
        ),
        (
            UniCase::ascii("magnetizable"),
            &[(0b01001, &ENTRY_MAGNETIZABLE_12538903182469509996)],
        ),
        (
            UniCase::ascii("parecy"),
            &[(0b10001, &ENTRY_PARECY_5096581135883021145)],
        ),
        (
            UniCase::ascii("subitized"),
            &[(0b01001, &ENTRY_SUBITIZED_2108404178901406655)],
        ),
        (
            UniCase::ascii("haematocele"),
            &[(0b10010, &ENTRY_HEMATOCELE_14219451917679449221)],
        ),
        (
            UniCase::ascii("amenorrheas"),
            &[(0b11001, &ENTRY_AMENORRHEAS_3707756389439454986)],
        ),
        (
            UniCase::ascii("occidentalize"),
            &[(0b01001, &ENTRY_OCCIDENTALIZE_14982167974023633691)],
        ),
        (
            UniCase::ascii("colorables"),
            &[(0b11001, &ENTRY_COLORABLES_10854398030589164189)],
        ),
        (
            UniCase::ascii("celiomyalgia"),
            &[(0b10001, &ENTRY_CELIOMYALGIA_14548383766443531737)],
        ),
        (
            UniCase::ascii("recapitalisations"),
            &[(0b10010, &ENTRY_RECAPITALIZATIONS_3489528805026955416)],
        ),
        (
            UniCase::ascii("enarbours"),
            &[(0b11010, &ENTRY_ENARBORS_8145891299588576620)],
        ),
        (
            UniCase::ascii("instalment"),
            &[(0b11010, &ENTRY_INSTALLMENT_15955257315912152068)],
        ),
        (
            UniCase::ascii("rehumanization"),
            &[(0b01001, &ENTRY_REHUMANIZATION_823615019743132382)],
        ),
        (
            UniCase::ascii("gauffre"),
            &[(0b11010, &ENTRY_GAUFFER_971344940707830760)],
        ),
        (
            UniCase::ascii("colorists"),
            &[(0b01001, &ENTRY_COLORISTS_205210891187993391)],
        ),
        (
            UniCase::ascii("pragmatise"),
            &[(0b10010, &ENTRY_PRAGMATIZE_10222982293817030908)],
        ),
        (
            UniCase::ascii("cinchonises"),
            &[(0b10010, &ENTRY_CINCHONIZES_1522582946661651319)],
        ),
        (
            UniCase::ascii("hinduised"),
            &[(0b10010, &ENTRY_HINDUIZED_11895274507413844911)],
        ),
        (
            UniCase::ascii("amortisement"),
            &[(0b10010, &ENTRY_AMORTIZEMENT_12103927078743615024)],
        ),
        (
            UniCase::ascii("nasalizing"),
            &[(0b01001, &ENTRY_NASALIZING_6931257761484940459)],
        ),
        (
            UniCase::ascii("esthetical"),
            &[(0b00001, &ENTRY_ESTHETICAL_827198906307006506)],
        ),
        (
            UniCase::ascii("pummeled"),
            &[(0b00001, &ENTRY_PUMMELED_18323564550000511359)],
        ),
        (
            UniCase::ascii("visionises"),
            &[(0b10010, &ENTRY_VISIONIZES_18286863748296097590)],
        ),
        (
            UniCase::ascii("colonisablest"),
            &[(0b10010, &ENTRY_COLONIZABLEST_13287343767333590772)],
        ),
        (
            UniCase::ascii("homoeomorphs"),
            &[(0b11010, &ENTRY_HOMEOMORPHS_16100106052531760213)],
        ),
        (
            UniCase::ascii("flavourfuler"),
            &[(0b11010, &ENTRY_FLAVORFULER_15725987112799498805)],
        ),
        (
            UniCase::ascii("lacklusters"),
            &[(0b00001, &ENTRY_LACKLUSTERS_3942521351652409819)],
        ),
        (
            UniCase::ascii("palaeoethnic"),
            &[(0b11010, &ENTRY_PALEOETHNIC_2616697170182083042)],
        ),
        (
            UniCase::ascii("anathematising"),
            &[(0b10010, &ENTRY_ANATHEMATIZING_10299965854697438675)],
        ),
        (
            UniCase::ascii("incognizances"),
            &[(0b01001, &ENTRY_INCOGNIZANCES_17577781369104818851)],
        ),
        (
            UniCase::ascii("recognizedly"),
            &[(0b01001, &ENTRY_RECOGNIZEDLY_15932389996645062386)],
        ),
        (
            UniCase::ascii("gynaecomastias"),
            &[(0b11010, &ENTRY_GYNECOMASTIAS_3172803406961308705)],
        ),
        (
            UniCase::ascii("misadvize"),
            &[(0b01001, &ENTRY_MISADVIZE_16409133113491535237)],
        ),
        (
            UniCase::ascii("opaled"),
            &[(0b00001, &ENTRY_OPALED_11788692301205754513)],
        ),
        (
            UniCase::ascii("anthracitization"),
            &[(0b01001, &ENTRY_ANTHRACITIZATION_8950863959835278016)],
        ),
        (
            UniCase::ascii("tuscanizes"),
            &[(0b01001, &ENTRY_TUSCANIZES_9646687590900186948)],
        ),
        (
            UniCase::ascii("hoosierize"),
            &[(0b01001, &ENTRY_HOOSIERIZE_1491277666553366678)],
        ),
        (
            UniCase::ascii("anhydridizes"),
            &[(0b01001, &ENTRY_ANHYDRIDIZES_14731666580950863474)],
        ),
        (
            UniCase::ascii("varicoloureds"),
            &[(0b11010, &ENTRY_VARICOLOREDS_5399234029222855053)],
        ),
        (
            UniCase::ascii("humanisers"),
            &[(0b10010, &ENTRY_HUMANIZERS_10409227793679563956)],
        ),
        (
            UniCase::ascii("idealized"),
            &[(0b01001, &ENTRY_IDEALIZED_14008500069022545339)],
        ),
        (
            UniCase::ascii("traditionize"),
            &[(0b01001, &ENTRY_TRADITIONIZE_11047234467125040571)],
        ),
        (
            UniCase::ascii("robotizing"),
            &[(0b01001, &ENTRY_ROBOTIZING_9767982352083703401)],
        ),
        (
            UniCase::ascii("missionises"),
            &[(0b10010, &ENTRY_MISSIONIZES_14585446178899362762)],
        ),
        (
            UniCase::ascii("civilize"),
            &[(0b01001, &ENTRY_CIVILIZE_11305300708024681316)],
        ),
        (
            UniCase::ascii("orientises"),
            &[(0b10010, &ENTRY_ORIENTIZES_11330269575495931584)],
        ),
        (
            UniCase::ascii("agrizing"),
            &[(0b01001, &ENTRY_AGRIZING_15134245886550376210)],
        ),
        (
            UniCase::ascii("baptizable"),
            &[(0b01001, &ENTRY_BAPTIZABLE_16415989175028506130)],
        ),
        (
            UniCase::ascii("panegyrizes"),
            &[(0b01001, &ENTRY_PANEGYRIZES_11019653756667579465)],
        ),
        (
            UniCase::ascii("unmobilizedder"),
            &[(0b01001, &ENTRY_UNMOBILIZEDDER_13885990523982700388)],
        ),
        (
            UniCase::ascii("synchronisables"),
            &[(0b10010, &ENTRY_SYNCHRONIZABLES_11909224206869588914)],
        ),
        (
            UniCase::ascii("velarisations"),
            &[(0b10010, &ENTRY_VELARIZATIONS_14651119125598343114)],
        ),
        (
            UniCase::ascii("notarize"),
            &[(0b01001, &ENTRY_NOTARIZE_9890063397301391140)],
        ),
        (
            UniCase::ascii("unfavourably"),
            &[(0b11010, &ENTRY_UNFAVORABLY_13214726587411166355)],
        ),
        (
            UniCase::ascii("favourabliest"),
            &[(0b11010, &ENTRY_FAVORABLIEST_13749538246766915905)],
        ),
        (
            UniCase::ascii("reanimalises"),
            &[(0b10010, &ENTRY_REANIMALIZES_15653498423524957266)],
        ),
        (
            UniCase::ascii("uraemias"),
            &[(0b10010, &ENTRY_UREMIAS_922769604822503284)],
        ),
        (
            UniCase::ascii("recapitalize"),
            &[(0b01001, &ENTRY_RECAPITALIZE_18040056007083479651)],
        ),
        (
            UniCase::ascii("technicolour"),
            &[
                (0b11010, &ENTRY_TECHNICOLOR_13876999640902564556),
                (0b11010, &ENTRY_TECHNICOLOR_14183677618685504801),
            ],
        ),
        (
            UniCase::ascii("fanaticised"),
            &[(0b10010, &ENTRY_FANATICIZED_5234463871342267005)],
        ),
        (
            UniCase::ascii("pemmicanisations"),
            &[(0b10010, &ENTRY_PEMMICANIZATIONS_17863458648609504163)],
        ),
        (
            UniCase::ascii("generalizers"),
            &[(0b01001, &ENTRY_GENERALIZERS_2408957385743792554)],
        ),
        (
            UniCase::ascii("modernizables"),
            &[(0b01001, &ENTRY_MODERNIZABLES_10916683662176279423)],
        ),
        (
            UniCase::ascii("avizandum"),
            &[(0b01001, &ENTRY_AVIZANDUM_15832266843653276586)],
        ),
        (
            UniCase::ascii("fueling"),
            &[(0b00001, &ENTRY_FUELING_16451678036489651807)],
        ),
        (
            UniCase::ascii("italicization"),
            &[(0b01001, &ENTRY_ITALICIZATION_11392681570163865096)],
        ),
        (
            UniCase::ascii("editorializing"),
            &[(0b01001, &ENTRY_EDITORIALIZING_4056192079667477523)],
        ),
        (
            UniCase::ascii("racemised"),
            &[(0b10010, &ENTRY_RACEMIZED_15166940075916248285)],
        ),
        (
            UniCase::ascii("palaeocosmology"),
            &[(0b11010, &ENTRY_PALEOCOSMOLOGY_7229374416435600718)],
        ),
        (
            UniCase::ascii("structuralisation"),
            &[(0b10010, &ENTRY_STRUCTURALIZATION_16247212527450308015)],
        ),
        (
            UniCase::ascii("cavilers"),
            &[(0b00001, &ENTRY_CAVILERS_17995770150287304299)],
        ),
        (
            UniCase::ascii("systemisations"),
            &[(0b10010, &ENTRY_SYSTEMIZATIONS_9736157959771706455)],
        ),
        (
            UniCase::ascii("keizer"),
            &[(0b01001, &ENTRY_KEIZER_3905342153729010348)],
        ),
        (
            UniCase::ascii("amorism"),
            &[(0b00001, &ENTRY_AMORISM_13622053629400049439)],
        ),
        (
            UniCase::ascii("celestine"),
            &[(0b00001, &ENTRY_CELESTINE_11011528250519125092)],
        ),
        (
            UniCase::ascii("recolourations"),
            &[(0b11010, &ENTRY_RECOLORATIONS_4889262529781127619)],
        ),
        (
            UniCase::ascii("symboliser"),
            &[(0b10010, &ENTRY_SYMBOLIZER_12834461225156804749)],
        ),
        (
            UniCase::ascii("goitres"),
            &[(0b11010, &ENTRY_GOITERS_9278089062698566328)],
        ),
        (
            UniCase::ascii("neighborer"),
            &[(0b10001, &ENTRY_NEIGHBORER_17586595116108205470)],
        ),
        (
            UniCase::ascii("eulogisers"),
            &[(0b10010, &ENTRY_EULOGIZERS_14136473823163628988)],
        ),
        (
            UniCase::ascii("amenorrhoea"),
            &[(0b11010, &ENTRY_AMENORRHEA_9430440773940411667)],
        ),
        (
            UniCase::ascii("genealogises"),
            &[(0b10010, &ENTRY_GENEALOGIZES_5856649031077446545)],
        ),
        (
            UniCase::ascii("solemnizing"),
            &[(0b01001, &ENTRY_SOLEMNIZING_1873698687937846065)],
        ),
        (
            UniCase::ascii("minimize"),
            &[(0b01001, &ENTRY_MINIMIZE_3707349867421055069)],
        ),
        (
            UniCase::ascii("napea"),
            &[(0b00001, &ENTRY_NAPEA_2703553051209012323)],
        ),
        (
            UniCase::ascii("immiserising"),
            &[(0b10010, &ENTRY_IMMISERIZING_7076021387262132556)],
        ),
        (
            UniCase::ascii("particoloredder"),
            &[(0b10001, &ENTRY_PARTICOLOREDDER_10954556914378270950)],
        ),
        (
            UniCase::ascii("etherialize"),
            &[(0b01001, &ENTRY_ETHERIALIZE_16410637034856874095)],
        ),
        (
            UniCase::ascii("paleozoologic"),
            &[(0b10001, &ENTRY_PALEOZOOLOGIC_15918765432702043975)],
        ),
        (
            UniCase::ascii("homoeomorph"),
            &[(0b11010, &ENTRY_HOMEOMORPH_84773973062870875)],
        ),
        (
            UniCase::ascii("ergotizing"),
            &[(0b01001, &ENTRY_ERGOTIZING_3389078505132496781)],
        ),
        (
            UniCase::ascii("diagonalized"),
            &[(0b01001, &ENTRY_DIAGONALIZED_16278489065750351065)],
        ),
        (
            UniCase::ascii("strobilizations"),
            &[(0b01001, &ENTRY_STROBILIZATIONS_6453453949977182110)],
        ),
        (
            UniCase::ascii("desexualize"),
            &[(0b01001, &ENTRY_DESEXUALIZE_4949470699070422167)],
        ),
        (
            UniCase::ascii("vacuumize"),
            &[(0b01001, &ENTRY_VACUUMIZE_14138660867202341090)],
        ),
        (
            UniCase::ascii("chlorinised"),
            &[(0b10010, &ENTRY_CHLORINIZED_17584986266499508813)],
        ),
        (
            UniCase::ascii("goloshoes"),
            &[(0b11010, &ENTRY_GOLOSHES_13775493769643547174)],
        ),
        (
            UniCase::ascii("acetonaemia"),
            &[(0b11010, &ENTRY_ACETONEMIA_4459698585404045008)],
        ),
        (
            UniCase::ascii("arabize"),
            &[(0b01001, &ENTRY_ARABIZE_9595110188198649627)],
        ),
        (
            UniCase::ascii("aetiology"),
            &[(0b10010, &ENTRY_ETIOLOGY_7123968270032580321)],
        ),
        (
            UniCase::ascii("dichotomization"),
            &[(0b01001, &ENTRY_DICHOTOMIZATION_14814468761822605666)],
        ),
        (
            UniCase::ascii("gormandizers"),
            &[(0b01001, &ENTRY_GORMANDIZERS_18411470761457014582)],
        ),
        (
            UniCase::ascii("unsepulchered"),
            &[(0b00001, &ENTRY_UNSEPULCHERED_728988728789570667)],
        ),
        (
            UniCase::ascii("incentivisation"),
            &[(0b10010, &ENTRY_INCENTIVIZATION_6332222872955507843)],
        ),
        (
            UniCase::ascii("anonymize"),
            &[(0b01001, &ENTRY_ANONYMIZE_1026063515222292659)],
        ),
        (
            UniCase::ascii("tae"),
            &[(0b11010, &ENTRY_TE_16963694388719213938)],
        ),
        (
            UniCase::ascii("uncivilizabler"),
            &[(0b01001, &ENTRY_UNCIVILIZABLER_5349352586984667487)],
        ),
        (
            UniCase::ascii("succorers"),
            &[(0b10001, &ENTRY_SUCCORERS_6561319313200472359)],
        ),
        (
            UniCase::ascii("underprise"),
            &[(0b10010, &ENTRY_UNDERPRIZE_5508380942697361246)],
        ),
        (
            UniCase::ascii("pragmatized"),
            &[(0b01001, &ENTRY_PRAGMATIZED_15911492964724941957)],
        ),
        (
            UniCase::ascii("doctorize"),
            &[(0b01001, &ENTRY_DOCTORIZE_6755038590757730967)],
        ),
        (
            UniCase::ascii("schematizers"),
            &[(0b01001, &ENTRY_SCHEMATIZERS_4368175659338148324)],
        ),
        (
            UniCase::ascii("recivilise"),
            &[(0b10010, &ENTRY_RECIVILIZE_3997712789498055993)],
        ),
        (
            UniCase::ascii("colourimetrics"),
            &[(0b11010, &ENTRY_COLORIMETRICS_8847586357101611180)],
        ),
        (
            UniCase::ascii("vocalizations"),
            &[(0b01001, &ENTRY_VOCALIZATIONS_6540912521590792850)],
        ),
        (
            UniCase::ascii("nonfavourite"),
            &[(0b11010, &ENTRY_NONFAVORITE_11831237877072163638)],
        ),
        (
            UniCase::ascii("palaeobiogeography"),
            &[(0b11010, &ENTRY_PALEOBIOGEOGRAPHY_12815064252785970775)],
        ),
        (
            UniCase::ascii("gimballing"),
            &[(0b11010, &ENTRY_GIMBALING_17481044329427103960)],
        ),
        (
            UniCase::ascii("soufflaed"),
            &[(0b11010, &ENTRY_SOUFFLED_11288921415541351012)],
        ),
        (
            UniCase::ascii("acclimatisers"),
            &[(0b10010, &ENTRY_ACCLIMATIZERS_12279845242555753697)],
        ),
        (
            UniCase::ascii("medicalizes"),
            &[(0b01001, &ENTRY_MEDICALIZES_10125506143660647869)],
        ),
        (
            UniCase::ascii("eudaemonism"),
            &[(0b11010, &ENTRY_EUDEMONISM_2030451125927147437)],
        ),
        (
            UniCase::ascii("labilisations"),
            &[(0b10010, &ENTRY_LABILIZATIONS_17617289251407409872)],
        ),
        (
            UniCase::ascii("totalisators"),
            &[(0b11010, &ENTRY_TOTALIZATORS_8640164609623735800)],
        ),
        (
            UniCase::ascii("coetus"),
            &[(0b11010, &ENTRY_CETUS_11617299917311809086)],
        ),
        (
            UniCase::ascii("repulverises"),
            &[(0b10010, &ENTRY_REPULVERIZES_16864243522912897832)],
        ),
        (
            UniCase::ascii("peptonizes"),
            &[(0b01001, &ENTRY_PEPTONIZES_1040139223657965665)],
        ),
        (
            UniCase::ascii("departmentalize"),
            &[(0b01001, &ENTRY_DEPARTMENTALIZE_14009690449414337770)],
        ),
        (
            UniCase::ascii("monophthongises"),
            &[(0b10010, &ENTRY_MONOPHTHONGIZES_3173126843603137132)],
        ),
        (
            UniCase::ascii("papalizing"),
            &[(0b01001, &ENTRY_PAPALIZING_11590725765608182808)],
        ),
        (
            UniCase::ascii("astigmatizer"),
            &[(0b01001, &ENTRY_ASTIGMATIZER_5573446594967375201)],
        ),
        (
            UniCase::ascii("anarchize"),
            &[(0b01001, &ENTRY_ANARCHIZE_16873413817474048843)],
        ),
        (
            UniCase::ascii("hebraiser"),
            &[(0b10010, &ENTRY_HEBRAIZER_18227136059206047351)],
        ),
        (
            UniCase::ascii("unrumoureddest"),
            &[(0b11010, &ENTRY_UNRUMOREDDEST_10653958198865026338)],
        ),
        (
            UniCase::ascii("modelers"),
            &[(0b00001, &ENTRY_MODELERS_1650738308079465867)],
        ),
        (
            UniCase::ascii("westernises"),
            &[(0b10010, &ENTRY_WESTERNIZES_359511446272047498)],
        ),
        (
            UniCase::ascii("flavoured"),
            &[(0b11010, &ENTRY_FLAVORED_525661928043886116)],
        ),
        (
            UniCase::ascii("antithesize"),
            &[(0b01001, &ENTRY_ANTITHESIZE_6914205044378767893)],
        ),
        (
            UniCase::ascii("dispopularizes"),
            &[(0b01001, &ENTRY_DISPOPULARIZES_3346222683675559134)],
        ),
        (
            UniCase::ascii("winterizes"),
            &[(0b01001, &ENTRY_WINTERIZES_158574474219766318)],
        ),
        (
            UniCase::ascii("encarnalise"),
            &[(0b10010, &ENTRY_ENCARNALIZE_10850144919400996674)],
        ),
        (
            UniCase::ascii("quintessentializes"),
            &[(0b01001, &ENTRY_QUINTESSENTIALIZES_5864610073124488816)],
        ),
        (
            UniCase::ascii("republicanizing"),
            &[(0b01001, &ENTRY_REPUBLICANIZING_8829607189097248923)],
        ),
        (
            UniCase::ascii("phoneticisations"),
            &[(0b10010, &ENTRY_PHONETICIZATIONS_12272721619858915699)],
        ),
        (
            UniCase::ascii("bacterizing"),
            &[(0b01001, &ENTRY_BACTERIZING_3356633906290065053)],
        ),
        (
            UniCase::ascii("deionises"),
            &[(0b10010, &ENTRY_DEIONIZES_2511822428052345171)],
        ),
        (
            UniCase::ascii("mediatisations"),
            &[(0b10010, &ENTRY_MEDIATIZATIONS_16197242107778706785)],
        ),
        (
            UniCase::ascii("amyxorrhea"),
            &[(0b00001, &ENTRY_AMYXORRHEA_4253893643371161289)],
        ),
        (
            UniCase::ascii("eupnoeic"),
            &[(0b11010, &ENTRY_EUPNEIC_10760124621699958430)],
        ),
        (
            UniCase::ascii("stree"),
            &[(0b11010, &ENTRY_STERE_14973674637271689830)],
        ),
        (
            UniCase::ascii("satellitising"),
            &[(0b10010, &ENTRY_SATELLITIZING_5844820839355010398)],
        ),
        (
            UniCase::ascii("lapelled"),
            &[(0b11010, &ENTRY_LAPELED_3965699421712198651)],
        ),
        (
            UniCase::ascii("wackes"),
            &[(0b00001, &ENTRY_WACKES_12738481748744727840)],
        ),
        (
            UniCase::ascii("missionizing"),
            &[(0b01001, &ENTRY_MISSIONIZING_7220648756581988180)],
        ),
        (
            UniCase::ascii("unwomanise"),
            &[(0b10010, &ENTRY_UNWOMANIZE_11304497579761163173)],
        ),
        (
            UniCase::ascii("foedarie"),
            &[(0b11010, &ENTRY_FEDARIE_6394349204716498948)],
        ),
        (
            UniCase::ascii("favouritism"),
            &[(0b11010, &ENTRY_FAVORITISM_14860734505967533306)],
        ),
        (
            UniCase::ascii("tyrannises"),
            &[(0b10010, &ENTRY_TYRANNIZES_10925886797003891936)],
        ),
        (
            UniCase::ascii("dockisations"),
            &[(0b10010, &ENTRY_DOCKIZATIONS_11682590158800904305)],
        ),
        (
            UniCase::ascii("albitizing"),
            &[(0b01001, &ENTRY_ALBITIZING_13797609614113010011)],
        ),
        (
            UniCase::ascii("unphilosophized"),
            &[(0b01001, &ENTRY_UNPHILOSOPHIZED_4478449938288203539)],
        ),
        (
            UniCase::ascii("unphilosophised"),
            &[(0b10010, &ENTRY_UNPHILOSOPHIZED_4478449938288203539)],
        ),
        (
            UniCase::ascii("totaler"),
            &[(0b00001, &ENTRY_TOTALER_10727979907060022636)],
        ),
        (
            UniCase::ascii("unchloridiseds"),
            &[(0b10010, &ENTRY_UNCHLORIDIZEDS_14218178409370978541)],
        ),
        (
            UniCase::ascii("laborability"),
            &[(0b11001, &ENTRY_LABORABILITY_15883644828666969797)],
        ),
        (
            UniCase::ascii("vernacularisation"),
            &[(0b10010, &ENTRY_VERNACULARIZATION_8027917640062920182)],
        ),
        (
            UniCase::ascii("secularizing"),
            &[(0b01001, &ENTRY_SECULARIZING_3038011191545839970)],
        ),
        (
            UniCase::ascii("organizations"),
            &[(0b01001, &ENTRY_ORGANIZATIONS_18209440244615759048)],
        ),
        (
            UniCase::ascii("unpatronizabler"),
            &[(0b01001, &ENTRY_UNPATRONIZABLER_14355011026327328507)],
        ),
        (
            UniCase::ascii("frivoling"),
            &[(0b00001, &ENTRY_FRIVOLING_18278706907289454096)],
        ),
        (
            UniCase::ascii("unhumorously"),
            &[(0b00001, &ENTRY_UNHUMOROUSLY_16491216367858199459)],
        ),
        (
            UniCase::ascii("fecundises"),
            &[(0b10010, &ENTRY_FECUNDIZES_2678423876082081224)],
        ),
        (
            UniCase::ascii("diphthongizing"),
            &[(0b01001, &ENTRY_DIPHTHONGIZING_9367101143579778156)],
        ),
        (
            UniCase::ascii("tautologise"),
            &[(0b10010, &ENTRY_TAUTOLOGIZE_4665592265999186622)],
        ),
        (
            UniCase::ascii("hectoliter"),
            &[(0b00001, &ENTRY_HECTOLITER_14135938994986629002)],
        ),
        (
            UniCase::ascii("immiserize"),
            &[(0b01001, &ENTRY_IMMISERIZE_14280117300182154146)],
        ),
        (
            UniCase::ascii("stilbestrols"),
            &[(0b00001, &ENTRY_STILBESTROLS_15735220233409139967)],
        ),
        (
            UniCase::ascii("paralogizes"),
            &[(0b01001, &ENTRY_PARALOGIZES_12884972439326038225)],
        ),
        (
            UniCase::ascii("lichenize"),
            &[(0b01001, &ENTRY_LICHENIZE_1218523330923020826)],
        ),
        (
            UniCase::ascii("humorizes"),
            &[(0b01001, &ENTRY_HUMORIZES_3167907102560083410)],
        ),
        (
            UniCase::ascii("darwinizes"),
            &[(0b01001, &ENTRY_DARWINIZES_4276823588989949702)],
        ),
        (
            UniCase::ascii("perclose"),
            &[(0b00001, &ENTRY_PERCLOSE_11470867655063256438)],
        ),
        (
            UniCase::ascii("nonschematized"),
            &[(0b01001, &ENTRY_NONSCHEMATIZED_3994267052359659886)],
        ),
        (
            UniCase::ascii("petrarchises"),
            &[(0b10010, &ENTRY_PETRARCHIZES_4178876562035449090)],
        ),
        (
            UniCase::ascii("poulder"),
            &[(0b00001, &ENTRY_POULDER_6920280469594748753)],
        ),
        (
            UniCase::ascii("boswellise"),
            &[(0b10010, &ENTRY_BOSWELLIZE_3698602768600626065)],
        ),
        (
            UniCase::ascii("synaloepha"),
            &[(0b11010, &ENTRY_SYNALEPHA_7165508884472247255)],
        ),
        (
            UniCase::ascii("anestruses"),
            &[(0b10001, &ENTRY_ANESTRUSES_8824267452405407476)],
        ),
        (
            UniCase::ascii("soberise"),
            &[(0b10010, &ENTRY_SOBERIZE_13532853448534221620)],
        ),
        (
            UniCase::ascii("unmissionised"),
            &[(0b10010, &ENTRY_UNMISSIONIZED_8479883138336012141)],
        ),
        (
            UniCase::ascii("flavorfullier"),
            &[(0b11001, &ENTRY_FLAVORFULLIER_11289585236476375035)],
        ),
        (
            UniCase::ascii("nanisation"),
            &[(0b10010, &ENTRY_NANIZATION_8428761032922909057)],
        ),
        (
            UniCase::ascii("harveyise"),
            &[(0b10010, &ENTRY_HARVEYIZE_8525712996046155627)],
        ),
        (
            UniCase::ascii("dogmatizer"),
            &[(0b01001, &ENTRY_DOGMATIZER_12352899563923207585)],
        ),
        (
            UniCase::ascii("amortise"),
            &[(0b10010, &ENTRY_AMORTIZE_14941813541869573228)],
        ),
        (
            UniCase::ascii("eupnoeas"),
            &[(0b11010, &ENTRY_EUPNEAS_17113263914966538934)],
        ),
        (
            UniCase::ascii("catechizings"),
            &[(0b01001, &ENTRY_CATECHIZINGS_5519486100889374813)],
        ),
        (
            UniCase::ascii("overcapitalising"),
            &[(0b10010, &ENTRY_OVERCAPITALIZING_3902235346884105289)],
        ),
        (
            UniCase::ascii("biologize"),
            &[(0b01001, &ENTRY_BIOLOGIZE_7350607900569346229)],
        ),
        (
            UniCase::ascii("demonetizing"),
            &[(0b01001, &ENTRY_DEMONETIZING_6533722070664012445)],
        ),
        (
            UniCase::ascii("sabrebill"),
            &[(0b11010, &ENTRY_SABERBILL_8906790336832465441)],
        ),
        (
            UniCase::ascii("unrevelationizes"),
            &[(0b01001, &ENTRY_UNREVELATIONIZES_8974203434399731612)],
        ),
        (
            UniCase::ascii("nomadised"),
            &[(0b10010, &ENTRY_NOMADIZED_3822219892599792814)],
        ),
        (
            UniCase::ascii("biographizes"),
            &[(0b01001, &ENTRY_BIOGRAPHIZES_9794450292227006800)],
        ),
        (
            UniCase::ascii("cacodemonial"),
            &[(0b10001, &ENTRY_CACODEMONIAL_4666484075733322158)],
        ),
        (
            UniCase::ascii("colourpoint"),
            &[(0b11010, &ENTRY_COLORPOINT_12353596064079181917)],
        ),
        (
            UniCase::ascii("recoloured"),
            &[(0b11010, &ENTRY_RECOLORED_17015675809629209249)],
        ),
        (
            UniCase::ascii("unprotestantise"),
            &[(0b10010, &ENTRY_UNPROTESTANTIZE_5090310073731327645)],
        ),
        (
            UniCase::ascii("colourative"),
            &[(0b11010, &ENTRY_COLORATIVE_17851173748347347190)],
        ),
        (
            UniCase::ascii("anapnoeic"),
            &[(0b11010, &ENTRY_ANAPNEIC_9824624761463965547)],
        ),
        (
            UniCase::ascii("materializers"),
            &[(0b01001, &ENTRY_MATERIALIZERS_6264608460867840474)],
        ),
        (
            UniCase::ascii("overgeneralised"),
            &[(0b10010, &ENTRY_OVERGENERALIZED_8841918834486724985)],
        ),
        (
            UniCase::ascii("hypostatization"),
            &[(0b01001, &ENTRY_HYPOSTATIZATION_3087117275369319820)],
        ),
        (
            UniCase::ascii("gheber"),
            &[(0b00001, &ENTRY_GHEBER_4914782193870428634)],
        ),
        (
            UniCase::ascii("feudalisables"),
            &[(0b10010, &ENTRY_FEUDALIZABLES_10938382425763284765)],
        ),
        (
            UniCase::ascii("eroticization"),
            &[(0b01001, &ENTRY_EROTICIZATION_2630432213360033255)],
        ),
        (
            UniCase::ascii("derationalisation"),
            &[(0b10010, &ENTRY_DERATIONALIZATION_10528830942768591126)],
        ),
        (
            UniCase::ascii("autolyzate"),
            &[(0b01001, &ENTRY_AUTOLYZATE_13897976732846843186)],
        ),
        (
            UniCase::ascii("emphasize"),
            &[(0b01001, &ENTRY_EMPHASIZE_15381357888908119930)],
        ),
        (
            UniCase::ascii("peculiarising"),
            &[(0b10010, &ENTRY_PECULIARIZING_2141506766135845761)],
        ),
        (
            UniCase::ascii("synergizing"),
            &[(0b01001, &ENTRY_SYNERGIZING_11050376152195270684)],
        ),
        (
            UniCase::ascii("ionicization"),
            &[(0b01001, &ENTRY_IONICIZATION_14275328423202505280)],
        ),
        (
            UniCase::ascii("chloritisations"),
            &[(0b10010, &ENTRY_CHLORITIZATIONS_14114607753454173066)],
        ),
        (
            UniCase::ascii("recolonise"),
            &[(0b10010, &ENTRY_RECOLONIZE_1210620957407633342)],
        ),
        (
            UniCase::ascii("shintoize"),
            &[(0b01001, &ENTRY_SHINTOIZE_11809502309481638164)],
        ),
        (
            UniCase::ascii("zoeas"),
            &[
                (0b11010, &ENTRY_ZEAS_16079098418850825523),
                (0b00001, &ENTRY_ZOEAS_265178227546758074),
            ],
        ),
        (
            UniCase::ascii("crofterisations"),
            &[(0b10010, &ENTRY_CROFTERIZATIONS_16334682363476700656)],
        ),
        (
            UniCase::ascii("rascalise"),
            &[(0b10010, &ENTRY_RASCALIZE_69827033231107941)],
        ),
        (
            UniCase::ascii("intimae"),
            &[(0b11010, &ENTRY_INTIME_16056492823113439440)],
        ),
        (
            UniCase::ascii("antimedieval"),
            &[(0b00001, &ENTRY_ANTIMEDIEVAL_6846585678553345503)],
        ),
        (
            UniCase::ascii("europeanized"),
            &[(0b01001, &ENTRY_EUROPEANIZED_4342167856841628431)],
        ),
        (
            UniCase::ascii("euphemize"),
            &[(0b01001, &ENTRY_EUPHEMIZE_6156608839130565166)],
        ),
        (
            UniCase::ascii("readvertise"),
            &[(0b10010, &ENTRY_READVERTIZE_17135010889729486559)],
        ),
        (
            UniCase::ascii("protestantising"),
            &[(0b10010, &ENTRY_PROTESTANTIZING_218744719233014114)],
        ),
        (
            UniCase::ascii("modellers"),
            &[(0b11010, &ENTRY_MODELERS_1650738308079465867)],
        ),
        (
            UniCase::ascii("rationalised"),
            &[(0b10010, &ENTRY_RATIONALIZED_17223545651759435903)],
        ),
        (
            UniCase::ascii("untantalisedder"),
            &[(0b10010, &ENTRY_UNTANTALIZEDDER_4818289569312071640)],
        ),
        (
            UniCase::ascii("agrised"),
            &[(0b10010, &ENTRY_AGRIZED_5916161568343203612)],
        ),
        (
            UniCase::ascii("eolotropic"),
            &[(0b00001, &ENTRY_EOLOTROPIC_9928061474103766564)],
        ),
        (
            UniCase::ascii("prolusionizes"),
            &[(0b01001, &ENTRY_PROLUSIONIZES_17256356705404835970)],
        ),
        (
            UniCase::ascii("polemicize"),
            &[(0b01001, &ENTRY_POLEMICIZE_15883334541461649709)],
        ),
        (
            UniCase::ascii("discolouration"),
            &[(0b11010, &ENTRY_DISCOLORATION_14169998051189645771)],
        ),
        (
            UniCase::ascii("idealised"),
            &[(0b10010, &ENTRY_IDEALIZED_14008500069022545339)],
        ),
        (
            UniCase::ascii("filmises"),
            &[(0b10010, &ENTRY_FILMIZES_15115815173662536994)],
        ),
        (
            UniCase::ascii("syllabized"),
            &[(0b01001, &ENTRY_SYLLABIZED_9081626028680716952)],
        ),
        (
            UniCase::ascii("calvinizes"),
            &[(0b01001, &ENTRY_CALVINIZES_5436345566017846080)],
        ),
        (
            UniCase::ascii("quintessentialises"),
            &[(0b10010, &ENTRY_QUINTESSENTIALIZES_5864610073124488816)],
        ),
        (
            UniCase::ascii("unamortized"),
            &[(0b01001, &ENTRY_UNAMORTIZED_13451896776472967546)],
        ),
        (
            UniCase::ascii("civilizationaler"),
            &[(0b01001, &ENTRY_CIVILIZATIONALER_2223864160765042134)],
        ),
        (
            UniCase::ascii("bedevilling"),
            &[(0b11010, &ENTRY_BEDEVILING_3264516468398917500)],
        ),
        (
            UniCase::ascii("vitriolize"),
            &[(0b01001, &ENTRY_VITRIOLIZE_16677616817185174970)],
        ),
        (
            UniCase::ascii("baronises"),
            &[(0b10010, &ENTRY_BARONIZES_2387447146173200401)],
        ),
        (
            UniCase::ascii("cacodaemons"),
            &[(0b11010, &ENTRY_CACODEMONS_4825079147053974709)],
        ),
        (
            UniCase::ascii("pulveriser"),
            &[(0b10010, &ENTRY_PULVERIZER_14835766143113548223)],
        ),
        (
            UniCase::ascii("gallicizer"),
            &[(0b01001, &ENTRY_GALLICIZER_6758989856264558701)],
        ),
        (
            UniCase::ascii("telaesthesias"),
            &[(0b11010, &ENTRY_TELESTHESIAS_13634253936556894398)],
        ),
        (
            UniCase::ascii("cottonisations"),
            &[(0b10010, &ENTRY_COTTONIZATIONS_17749803100676719261)],
        ),
        (
            UniCase::ascii("zeroising"),
            &[(0b10010, &ENTRY_ZEROIZING_17764051118899638643)],
        ),
        (
            UniCase::ascii("vascularizes"),
            &[(0b01001, &ENTRY_VASCULARIZES_8060078253096737319)],
        ),
        (
            UniCase::ascii("unrancoured"),
            &[(0b11010, &ENTRY_UNRANCORED_9184272533577547039)],
        ),
        (
            UniCase::ascii("unscandalizedder"),
            &[(0b01001, &ENTRY_UNSCANDALIZEDDER_16598075610375338334)],
        ),
        (
            UniCase::ascii("riotises"),
            &[(0b10010, &ENTRY_RIOTIZES_17355146657912726592)],
        ),
        (
            UniCase::ascii("idumaeans"),
            &[(0b11010, &ENTRY_IDUMEANS_2701997562386323077)],
        ),
        (
            UniCase::ascii("aromatised"),
            &[(0b10010, &ENTRY_AROMATIZED_11509335206222252539)],
        ),
        (
            UniCase::ascii("polysulphurizations"),
            &[(0b01001, &ENTRY_POLYSULPHURIZATIONS_12547437930211655448)],
        ),
        (
            UniCase::ascii("poplitaeal"),
            &[(0b11010, &ENTRY_POPLITEAL_14608064669039474519)],
        ),
        (
            UniCase::ascii("editorialization"),
            &[(0b01001, &ENTRY_EDITORIALIZATION_16653146908113662887)],
        ),
        (
            UniCase::ascii("subterraneanise"),
            &[(0b10010, &ENTRY_SUBTERRANEANIZE_16122048142322693644)],
        ),
        (
            UniCase::ascii("paleoanthropologists"),
            &[(0b10001, &ENTRY_PALEOANTHROPOLOGISTS_4369638882884050551)],
        ),
        (
            UniCase::ascii("conceptualisations"),
            &[(0b10010, &ENTRY_CONCEPTUALIZATIONS_11238993640785943456)],
        ),
        (
            UniCase::ascii("unrealising"),
            &[(0b10010, &ENTRY_UNREALIZING_16148636932622971777)],
        ),
        (
            UniCase::ascii("subtotalled"),
            &[(0b11010, &ENTRY_SUBTOTALED_11251144387232903283)],
        ),
        (
            UniCase::ascii("spiralizes"),
            &[(0b01001, &ENTRY_SPIRALIZES_6682564053194995427)],
        ),
        (
            UniCase::ascii("palletizes"),
            &[(0b01001, &ENTRY_PALLETIZES_13198673987307815474)],
        ),
        (
            UniCase::ascii("unbrutalized"),
            &[(0b01001, &ENTRY_UNBRUTALIZED_6338937456842490293)],
        ),
        (
            UniCase::ascii("peptize"),
            &[(0b01001, &ENTRY_PEPTIZE_3206314528337021093)],
        ),
        (
            UniCase::ascii("zeroised"),
            &[(0b10010, &ENTRY_ZEROIZED_17059959399940465949)],
        ),
        (
            UniCase::ascii("dispopularize"),
            &[(0b01001, &ENTRY_DISPOPULARIZE_6744315358378905582)],
        ),
        (
            UniCase::ascii("romanizing"),
            &[(0b01001, &ENTRY_ROMANIZING_1191652903917979672)],
        ),
        (
            UniCase::ascii("unmaterialized"),
            &[(0b01001, &ENTRY_UNMATERIALIZED_2222039272937406727)],
        ),
        (
            UniCase::ascii("hyperbolizes"),
            &[(0b01001, &ENTRY_HYPERBOLIZES_10753409068722265798)],
        ),
        (
            UniCase::ascii("solecised"),
            &[(0b10010, &ENTRY_SOLECIZED_15911538990572619815)],
        ),
        (
            UniCase::ascii("cenesthesis"),
            &[(0b10001, &ENTRY_CENESTHESIS_2981771230300833707)],
        ),
        (
            UniCase::ascii("agenise"),
            &[(0b10010, &ENTRY_AGENIZE_15273268881147024151)],
        ),
        (
            UniCase::ascii("chloroformizes"),
            &[(0b01001, &ENTRY_CHLOROFORMIZES_15872749603216002935)],
        ),
        (
            UniCase::ascii("acidaemia"),
            &[(0b11010, &ENTRY_ACIDEMIA_4441947562863004388)],
        ),
        (
            UniCase::ascii("idolises"),
            &[(0b10010, &ENTRY_IDOLIZES_15045222501412845991)],
        ),
        (
            UniCase::ascii("diagonalize"),
            &[(0b01001, &ENTRY_DIAGONALIZE_17545470866818361268)],
        ),
        (
            UniCase::ascii("emuling"),
            &[(0b00001, &ENTRY_EMULING_11304283679719960362)],
        ),
        (
            UniCase::ascii("paternalize"),
            &[(0b01001, &ENTRY_PATERNALIZE_16820296051551287672)],
        ),
        (
            UniCase::ascii("albuminizing"),
            &[(0b01000, &ENTRY_ALBUMENIZING_16229928715193703812)],
        ),
        (
            UniCase::ascii("abolitionise"),
            &[(0b10010, &ENTRY_ABOLITIONIZE_13202486319737181929)],
        ),
        (
            UniCase::ascii("rhinorrhoeal"),
            &[(0b11010, &ENTRY_RHINORRHEAL_4168671082299209434)],
        ),
        (
            UniCase::ascii("unminimiseddest"),
            &[(0b10010, &ENTRY_UNMINIMIZEDDEST_2442440839355809588)],
        ),
        (
            UniCase::ascii("authorizable"),
            &[(0b01001, &ENTRY_AUTHORIZABLE_5231844717756889861)],
        ),
        (
            UniCase::ascii("fulfillment"),
            &[(0b01001, &ENTRY_FULFILLMENT_1403777125945191804)],
        ),
        (
            UniCase::ascii("platitudinize"),
            &[(0b01001, &ENTRY_PLATITUDINIZE_16047744417590066437)],
        ),
        (
            UniCase::ascii("rivalise"),
            &[(0b10010, &ENTRY_RIVALIZE_7944174065886798683)],
        ),
        (
            UniCase::ascii("paleophytology"),
            &[(0b10001, &ENTRY_PALEOPHYTOLOGY_17976758756772027621)],
        ),
        (
            UniCase::ascii("ichneumonised"),
            &[(0b10010, &ENTRY_ICHNEUMONIZED_6378362117508680448)],
        ),
        (
            UniCase::ascii("preves"),
            &[(0b11010, &ENTRY_PERVES_5996851197956304566)],
        ),
        (
            UniCase::ascii("satanizes"),
            &[(0b01001, &ENTRY_SATANIZES_4037603454744610431)],
        ),
        (
            UniCase::ascii("antiquarianise"),
            &[(0b10010, &ENTRY_ANTIQUARIANIZE_12102393390446972744)],
        ),
        (
            UniCase::ascii("nickelling"),
            &[(0b11010, &ENTRY_NICKELING_16355800754604695372)],
        ),
        (
            UniCase::ascii("unnormalized"),
            &[(0b01001, &ENTRY_UNNORMALIZED_17182616854570086003)],
        ),
        (
            UniCase::ascii("tuberisation"),
            &[(0b10010, &ENTRY_TUBERIZATION_10556809563684052487)],
        ),
        (
            UniCase::ascii("christianiser"),
            &[(0b10010, &ENTRY_CHRISTIANIZER_12661100042100507791)],
        ),
        (
            UniCase::ascii("gelatinizes"),
            &[(0b01001, &ENTRY_GELATINIZES_1595883472582938174)],
        ),
        (
            UniCase::ascii("literalized"),
            &[(0b01001, &ENTRY_LITERALIZED_17139448346953459594)],
        ),
        (
            UniCase::ascii("propylitizations"),
            &[(0b01001, &ENTRY_PROPYLITIZATIONS_7094329496024697216)],
        ),
        (
            UniCase::ascii("civilizations"),
            &[(0b01001, &ENTRY_CIVILIZATIONS_10559611739235699948)],
        ),
        (
            UniCase::ascii("denaturalise"),
            &[(0b10010, &ENTRY_DENATURALIZE_12142869922927195304)],
        ),
        (
            UniCase::ascii("mucose"),
            &[(0b00001, &ENTRY_MUCOSE_11672488603107743330)],
        ),
        (
            UniCase::ascii("haemocoels"),
            &[(0b11010, &ENTRY_HEMOCOELS_18362432535121397233)],
        ),
        (
            UniCase::ascii("nonoxidizable"),
            &[(0b01001, &ENTRY_NONOXIDIZABLE_17473608806098821507)],
        ),
        (
            UniCase::ascii("rationalisations"),
            &[(0b10010, &ENTRY_RATIONALIZATIONS_8459085318220075747)],
        ),
        (
            UniCase::ascii("perse"),
            &[
                (0b00001, &ENTRY_PERSE_13659628269605068524),
                (0b00001, &ENTRY_PERSE_2874440396224431051),
            ],
        ),
        (
            UniCase::ascii("proletarising"),
            &[(0b10010, &ENTRY_PROLETARIZING_7622597255202403783)],
        ),
        (
            UniCase::ascii("hominization"),
            &[(0b01001, &ENTRY_HOMINIZATION_15453871557875181149)],
        ),
        (
            UniCase::ascii("bittor"),
            &[(0b00001, &ENTRY_BITTOR_17121981854551948147)],
        ),
        (
            UniCase::ascii("laicises"),
            &[(0b10010, &ENTRY_LAICIZES_3370790220822496415)],
        ),
        (
            UniCase::ascii("danisation"),
            &[(0b10010, &ENTRY_DANIZATION_4527343444630609033)],
        ),
        (
            UniCase::ascii("alcoholize"),
            &[(0b01001, &ENTRY_ALCOHOLIZE_7529158246880124791)],
        ),
        (
            UniCase::ascii("nationalizes"),
            &[(0b01001, &ENTRY_NATIONALIZES_7334356969812316358)],
        ),
        (
            UniCase::ascii("humouring"),
            &[(0b11010, &ENTRY_HUMORING_14086332731556696553)],
        ),
        (
            UniCase::ascii("accourage"),
            &[(0b11010, &ENTRY_ACCORAGE_4223546442621665298)],
        ),
        (
            UniCase::ascii("roentgenize"),
            &[(0b01001, &ENTRY_ROENTGENIZE_10746435571343043012)],
        ),
        (
            UniCase::ascii("presolve"),
            &[(0b11010, &ENTRY_PERSOLVE_11803654124888842880)],
        ),
        (
            UniCase::ascii("semitised"),
            &[(0b10010, &ENTRY_SEMITIZED_17290416988749434330)],
        ),
        (
            UniCase::ascii("unmechanize"),
            &[(0b01001, &ENTRY_UNMECHANIZE_11190176714541551865)],
        ),
        (
            UniCase::ascii("unlabializing"),
            &[(0b01001, &ENTRY_UNLABIALIZING_6104103553465648864)],
        ),
        (
            UniCase::ascii("concretizations"),
            &[(0b01001, &ENTRY_CONCRETIZATIONS_14806205502602655468)],
        ),
        (
            UniCase::ascii("overrationalize"),
            &[(0b01001, &ENTRY_OVERRATIONALIZE_14162691183665004674)],
        ),
        (
            UniCase::ascii("hematoid"),
            &[(0b10001, &ENTRY_HEMATOID_4321558159204018583)],
        ),
        (
            UniCase::ascii("mercurise"),
            &[(0b10010, &ENTRY_MERCURIZE_17518451926892582183)],
        ),
        (
            UniCase::ascii("diarised"),
            &[(0b10010, &ENTRY_DIARIZED_15375708985365837815)],
        ),
        (
            UniCase::ascii("logicalises"),
            &[(0b10010, &ENTRY_LOGICALIZES_10430140462205373333)],
        ),
        (
            UniCase::ascii("semiticises"),
            &[(0b10010, &ENTRY_SEMITICIZES_14074646105957764366)],
        ),
        (
            UniCase::ascii("unsensitise"),
            &[(0b10010, &ENTRY_UNSENSITIZE_10205463848604074076)],
        ),
        (
            UniCase::ascii("desalinise"),
            &[(0b10010, &ENTRY_DESALINIZE_14106924193733250969)],
        ),
        (
            UniCase::ascii("fulfills"),
            &[(0b11001, &ENTRY_FULFILLS_6573936474908938280)],
        ),
        (
            UniCase::ascii("stabilised"),
            &[(0b10010, &ENTRY_STABILIZED_11581917854583003610)],
        ),
        (
            UniCase::ascii("contemporization"),
            &[(0b01001, &ENTRY_CONTEMPORIZATION_16780108593197095593)],
        ),
        (
            UniCase::ascii("uncriticizables"),
            &[(0b01001, &ENTRY_UNCRITICIZABLES_12700073615320281916)],
        ),
        (
            UniCase::ascii("behovings"),
            &[(0b10010, &ENTRY_BEHOOVINGS_8205659410382773823)],
        ),
        (
            UniCase::ascii("heroinizes"),
            &[(0b01001, &ENTRY_HEROINIZES_530036718996538373)],
        ),
        (
            UniCase::ascii("untemporisings"),
            &[(0b10010, &ENTRY_UNTEMPORIZINGS_10863617418556326800)],
        ),
        (
            UniCase::ascii("quantiser"),
            &[(0b10010, &ENTRY_QUANTIZER_3494983548212992900)],
        ),
        (
            UniCase::ascii("arctogeic"),
            &[(0b10001, &ENTRY_ARCTOGEIC_12166436575342886940)],
        ),
        (
            UniCase::ascii("hypnoidized"),
            &[(0b01001, &ENTRY_HYPNOIDIZED_9319780668114784761)],
        ),
        (
            UniCase::ascii("departmentalisations"),
            &[(0b10010, &ENTRY_DEPARTMENTALIZATIONS_13030339549069230554)],
        ),
        (
            UniCase::ascii("carburizer"),
            &[(0b01001, &ENTRY_CARBURIZER_1120017158252509510)],
        ),
        (
            UniCase::ascii("unharmonised"),
            &[(0b10010, &ENTRY_UNHARMONIZED_3681921261857978250)],
        ),
        (
            UniCase::ascii("synchronisable"),
            &[(0b10010, &ENTRY_SYNCHRONIZABLE_3205035752239437919)],
        ),
        (
            UniCase::ascii("hypersensitising"),
            &[(0b10010, &ENTRY_HYPERSENSITIZING_6146233767758672273)],
        ),
        (
            UniCase::ascii("crueler"),
            &[(0b01001, &ENTRY_CRUELER_8850779393447007974)],
        ),
        (
            UniCase::ascii("seborrhea"),
            &[(0b01001, &ENTRY_SEBORRHEA_5911144256699940196)],
        ),
        (
            UniCase::ascii("alcoholizing"),
            &[(0b01001, &ENTRY_ALCOHOLIZING_9204884893125609497)],
        ),
        (
            UniCase::ascii("phenolisations"),
            &[(0b10010, &ENTRY_PHENOLIZATIONS_14432785009139345517)],
        ),
        (
            UniCase::ascii("gospelizes"),
            &[(0b01001, &ENTRY_GOSPELIZES_4662692098801017919)],
        ),
        (
            UniCase::ascii("cyclises"),
            &[(0b10010, &ENTRY_CYCLIZES_5515758818050542691)],
        ),
        (
            UniCase::ascii("hispanicising"),
            &[(0b10010, &ENTRY_HISPANICIZING_10297649593265523682)],
        ),
        (
            UniCase::ascii("tuberculinizes"),
            &[(0b01001, &ENTRY_TUBERCULINIZES_13921009254488053820)],
        ),
        (
            UniCase::ascii("phagedaenic"),
            &[(0b11010, &ENTRY_PHAGEDENIC_17318315545560183857)],
        ),
        (
            UniCase::ascii("entomologises"),
            &[(0b10010, &ENTRY_ENTOMOLOGIZES_14741971157180428511)],
        ),
        (
            UniCase::ascii("draughtily"),
            &[(0b10010, &ENTRY_DRAFTILY_3404853207703525148)],
        ),
        (
            UniCase::ascii("uncolorablier"),
            &[(0b00001, &ENTRY_UNCOLORABLIER_15894133128738876679)],
        ),
        (
            UniCase::ascii("electroanesthesia"),
            &[(0b00001, &ENTRY_ELECTROANESTHESIA_6580395617178938362)],
        ),
        (
            UniCase::ascii("patrialized"),
            &[(0b01001, &ENTRY_PATRIALIZED_3341367979909806645)],
        ),
        (
            UniCase::ascii("asynchronizing"),
            &[(0b01001, &ENTRY_ASYNCHRONIZING_16727683109340331408)],
        ),
        (
            UniCase::ascii("oedematous"),
            &[(0b10010, &ENTRY_EDEMATOUS_2501565917049629990)],
        ),
        (
            UniCase::ascii("republicanisers"),
            &[(0b10010, &ENTRY_REPUBLICANIZERS_15251018630663619701)],
        ),
        (
            UniCase::ascii("laevo"),
            &[(0b11010, &ENTRY_LEVO_14542258720001517914)],
        ),
        (
            UniCase::ascii("cardiae"),
            &[(0b11010, &ENTRY_CARDIE_2205350999715185435)],
        ),
        (
            UniCase::ascii("femalize"),
            &[(0b01001, &ENTRY_FEMALIZE_13901043989723708165)],
        ),
        (
            UniCase::ascii("galliardise"),
            &[(0b10010, &ENTRY_GALLIARDIZE_10773583765831320043)],
        ),
        (
            UniCase::ascii("vasectomized"),
            &[(0b01001, &ENTRY_VASECTOMIZED_8925568978830732205)],
        ),
        (
            UniCase::ascii("aesthesiogens"),
            &[(0b11010, &ENTRY_ESTHESIOGENS_8380315319153501054)],
        ),
        (
            UniCase::ascii("legitimiser"),
            &[(0b10010, &ENTRY_LEGITIMIZER_17472185937284492353)],
        ),
        (
            UniCase::ascii("mechanizations"),
            &[(0b01001, &ENTRY_MECHANIZATIONS_16698691905505593378)],
        ),
        (
            UniCase::ascii("culicidae"),
            &[(0b11010, &ENTRY_CULICIDE_539049738338426871)],
        ),
        (
            UniCase::ascii("caesium"),
            &[(0b11010, &ENTRY_CESIUM_17343129911628596363)],
        ),
        (
            UniCase::ascii("rememorises"),
            &[(0b10010, &ENTRY_REMEMORIZES_3334768426875225854)],
        ),
        (
            UniCase::ascii("decolourizations"),
            &[(0b01000, &ENTRY_DECOLORIZATIONS_5583822483356878390)],
        ),
        (
            UniCase::ascii("evangelisations"),
            &[(0b10010, &ENTRY_EVANGELIZATIONS_14789777873996157817)],
        ),
        (
            UniCase::ascii("demilitarized"),
            &[(0b01001, &ENTRY_DEMILITARIZED_7958961857075865134)],
        ),
        (
            UniCase::ascii("asiaticize"),
            &[(0b01001, &ENTRY_ASIATICIZE_17700168473976448799)],
        ),
        (
            UniCase::ascii("rhythmicises"),
            &[(0b10010, &ENTRY_RHYTHMICIZES_6647633033339306298)],
        ),
        (
            UniCase::ascii("acclimatization"),
            &[(0b01001, &ENTRY_ACCLIMATIZATION_16603745532174886246)],
        ),
        (
            UniCase::ascii("denominationalize"),
            &[(0b01001, &ENTRY_DENOMINATIONALIZE_11508794372277368265)],
        ),
        (
            UniCase::ascii("defibrinise"),
            &[(0b10010, &ENTRY_DEFIBRINIZE_18283930865175559011)],
        ),
        (
            UniCase::ascii("unsabereddest"),
            &[(0b00001, &ENTRY_UNSABEREDDEST_4361858810448422047)],
        ),
        (
            UniCase::ascii("semifossiliseds"),
            &[(0b10010, &ENTRY_SEMIFOSSILIZEDS_7710393663692254880)],
        ),
        (
            UniCase::ascii("proindustrialisation"),
            &[(0b10010, &ENTRY_PROINDUSTRIALIZATION_15813974036579142612)],
        ),
        (
            UniCase::ascii("lacklustres"),
            &[(0b11010, &ENTRY_LACKLUSTERS_3942521351652409819)],
        ),
        (
            UniCase::ascii("indianized"),
            &[(0b01001, &ENTRY_INDIANIZED_6203878007785616549)],
        ),
        (
            UniCase::ascii("cataloguises"),
            &[(0b10010, &ENTRY_CATALOGUIZES_3655562417907187515)],
        ),
        (
            UniCase::ascii("aerometric"),
            &[(0b00001, &ENTRY_AEROMETRIC_13993414140130418477)],
        ),
        (
            UniCase::ascii("reinitialise"),
            &[(0b10010, &ENTRY_REINITIALIZE_13966181957218775879)],
        ),
        (
            UniCase::ascii("stomodaeums"),
            &[(0b11010, &ENTRY_STOMODEUMS_6754518911406029725)],
        ),
        (
            UniCase::ascii("unformaliseddest"),
            &[(0b10010, &ENTRY_UNFORMALIZEDDEST_14745966789505381148)],
        ),
        (
            UniCase::ascii("polarizing"),
            &[(0b01001, &ENTRY_POLARIZING_7254748840434133551)],
        ),
        (
            UniCase::ascii("uncolonises"),
            &[(0b10010, &ENTRY_UNCOLONIZES_9719326327721062003)],
        ),
        (
            UniCase::ascii("oxyhemoglobins"),
            &[(0b10001, &ENTRY_OXYHEMOGLOBINS_3513395291969542293)],
        ),
        (
            UniCase::ascii("olympianises"),
            &[(0b10010, &ENTRY_OLYMPIANIZES_15338190775391482293)],
        ),
        (
            UniCase::ascii("disscepters"),
            &[(0b00001, &ENTRY_DISSCEPTERS_8501541001325274567)],
        ),
        (
            UniCase::ascii("effeminization"),
            &[(0b01001, &ENTRY_EFFEMINIZATION_3469570906021333989)],
        ),
        (
            UniCase::ascii("overnationalization"),
            &[(0b01001, &ENTRY_OVERNATIONALIZATION_16427980336477721392)],
        ),
        (
            UniCase::ascii("spectrelike"),
            &[(0b11010, &ENTRY_SPECTERLIKE_18260751826068593688)],
        ),
        (
            UniCase::ascii("anhydridises"),
            &[(0b10010, &ENTRY_ANHYDRIDIZES_14731666580950863474)],
        ),
        (
            UniCase::ascii("unoxygenized"),
            &[(0b01001, &ENTRY_UNOXYGENIZED_6875578357957209997)],
        ),
        (
            UniCase::ascii("eternalized"),
            &[(0b01001, &ENTRY_ETERNALIZED_9585284058759840856)],
        ),
        (
            UniCase::ascii("hematosepsis"),
            &[(0b10001, &ENTRY_HEMATOSEPSIS_13675575187899218762)],
        ),
        (
            UniCase::ascii("apostatized"),
            &[(0b01001, &ENTRY_APOSTATIZED_7948531497773688326)],
        ),
        (
            UniCase::ascii("mesogloeas"),
            &[(0b11010, &ENTRY_MESOGLEAS_15641828554859977983)],
        ),
        (
            UniCase::ascii("denaturalises"),
            &[(0b10010, &ENTRY_DENATURALIZES_12885068908916155509)],
        ),
        (
            UniCase::ascii("profanize"),
            &[(0b01001, &ENTRY_PROFANIZE_12830076681879400499)],
        ),
        (
            UniCase::ascii("pistoled"),
            &[(0b00001, &ENTRY_PISTOLED_14184147191541856361)],
        ),
        (
            UniCase::ascii("nounizes"),
            &[(0b01001, &ENTRY_NOUNIZES_10999252613540238861)],
        ),
        (
            UniCase::ascii("mongolise"),
            &[(0b10010, &ENTRY_MONGOLIZE_3876217931633008306)],
        ),
        (
            UniCase::ascii("palaeodendrologist"),
            &[(0b11010, &ENTRY_PALEODENDROLOGIST_1101730449788449946)],
        ),
        (
            UniCase::ascii("glottalize"),
            &[(0b01001, &ENTRY_GLOTTALIZE_11936017486575639215)],
        ),
        (
            UniCase::ascii("carbonizes"),
            &[(0b01001, &ENTRY_CARBONIZES_14523315792081641044)],
        ),
        (
            UniCase::ascii("overclamours"),
            &[(0b11010, &ENTRY_OVERCLAMORS_12504082063740601729)],
        ),
        (
            UniCase::ascii("recarbonise"),
            &[(0b10010, &ENTRY_RECARBONIZE_15994488180990553654)],
        ),
        (
            UniCase::ascii("torporise"),
            &[(0b10010, &ENTRY_TORPORIZE_18297824631247427015)],
        ),
        (
            UniCase::ascii("divinising"),
            &[(0b10010, &ENTRY_DIVINIZING_3663245257392927615)],
        ),
        (
            UniCase::ascii("conservatises"),
            &[(0b10010, &ENTRY_CONSERVATIZES_6230909821260907845)],
        ),
        (
            UniCase::ascii("miltonised"),
            &[(0b10010, &ENTRY_MILTONIZED_881674982771846921)],
        ),
        (
            UniCase::ascii("unmoralisingest"),
            &[(0b10010, &ENTRY_UNMORALIZINGEST_10371338958162242360)],
        ),
        (
            UniCase::ascii("catabolise"),
            &[(0b10010, &ENTRY_CATABOLIZE_1177290851351235880)],
        ),
        (
            UniCase::ascii("coenesthesis"),
            &[(0b11010, &ENTRY_CENESTHESIS_2981771230300833707)],
        ),
        (
            UniCase::ascii("haematosin"),
            &[(0b11010, &ENTRY_HEMATOSIN_5725284952839086511)],
        ),
        (
            UniCase::ascii("uncivilizes"),
            &[(0b01001, &ENTRY_UNCIVILIZES_4114315705302110845)],
        ),
        (
            UniCase::ascii("uncolouredliest"),
            &[(0b11010, &ENTRY_UNCOLOREDLIEST_12675741818469230732)],
        ),
        (
            UniCase::ascii("palaestrae"),
            &[(0b11010, &ENTRY_PALESTRAE_1477667196546852023)],
        ),
        (
            UniCase::ascii("paresthetic"),
            &[(0b10001, &ENTRY_PARESTHETIC_3283039464622031643)],
        ),
        (
            UniCase::ascii("anaesthesiologist"),
            &[(0b10010, &ENTRY_ANESTHESIOLOGIST_15509935416057002830)],
        ),
        (
            UniCase::ascii("slenderizing"),
            &[(0b01001, &ENTRY_SLENDERIZING_13145961426039938518)],
        ),
        (
            UniCase::ascii("preinitialized"),
            &[(0b01001, &ENTRY_PREINITIALIZED_1342530234296788703)],
        ),
        (
            UniCase::ascii("newspaperizeds"),
            &[(0b01001, &ENTRY_NEWSPAPERIZEDS_15846237086308072144)],
        ),
        (
            UniCase::ascii("pises"),
            &[(0b10010, &ENTRY_PIZES_15927503519599533301)],
        ),
        (
            UniCase::ascii("colourized"),
            &[(0b01000, &ENTRY_COLORIZED_1927556635004418734)],
        ),
        (
            UniCase::ascii("phenomenise"),
            &[(0b10010, &ENTRY_PHENOMENIZE_9110544169399242876)],
        ),
        (
            UniCase::ascii("cognisance"),
            &[(0b10010, &ENTRY_COGNIZANCE_14359512853615918641)],
        ),
        (
            UniCase::ascii("unsatirizable"),
            &[(0b01001, &ENTRY_UNSATIRIZABLE_11743121723677468480)],
        ),
        (
            UniCase::ascii("onionized"),
            &[(0b01001, &ENTRY_ONIONIZED_13175316651387656071)],
        ),
        (
            UniCase::ascii("dialysable"),
            &[(0b11010, &ENTRY_DIALYZABLE_4481317071046410548)],
        ),
        (
            UniCase::ascii("standardizers"),
            &[(0b01001, &ENTRY_STANDARDIZERS_12514193886547172459)],
        ),
        (
            UniCase::ascii("battologising"),
            &[(0b10010, &ENTRY_BATTOLOGIZING_6018370845171871626)],
        ),
        (
            UniCase::ascii("scaena"),
            &[(0b11010, &ENTRY_SCENA_13970174413239259767)],
        ),
        (
            UniCase::ascii("apologizes"),
            &[(0b01001, &ENTRY_APOLOGIZES_1886820837917495266)],
        ),
        (
            UniCase::ascii("compartmentalizations"),
            &[(0b01001, &ENTRY_COMPARTMENTALIZATIONS_2073690646158683595)],
        ),
        (
            UniCase::ascii("defense"),
            &[(0b01001, &ENTRY_DEFENSE_11018687793676709280)],
        ),
        (
            UniCase::ascii("externalization"),
            &[(0b01001, &ENTRY_EXTERNALIZATION_5637241595479106962)],
        ),
        (
            UniCase::ascii("materialises"),
            &[(0b10010, &ENTRY_MATERIALIZES_2541163433716035330)],
        ),
        (
            UniCase::ascii("denaturizes"),
            &[(0b01001, &ENTRY_DENATURIZES_2160785183565221398)],
        ),
        (
            UniCase::ascii("humanization"),
            &[(0b01001, &ENTRY_HUMANIZATION_5830695966920821886)],
        ),
        (
            UniCase::ascii("crystallizer"),
            &[(0b01001, &ENTRY_CRYSTALLIZER_9934670519220100357)],
        ),
        (
            UniCase::ascii("galvanise"),
            &[(0b10010, &ENTRY_GALVANIZE_19760109166282156)],
        ),
        (
            UniCase::ascii("labiovelarisation"),
            &[(0b10010, &ENTRY_LABIOVELARIZATION_7949527129202863262)],
        ),
        (
            UniCase::ascii("poeticization"),
            &[(0b01001, &ENTRY_POETICIZATION_3652192917145042403)],
        ),
        (
            UniCase::ascii("westernization"),
            &[(0b01001, &ENTRY_WESTERNIZATION_9450693683308242701)],
        ),
        (
            UniCase::ascii("unmemorialiseddest"),
            &[(0b10010, &ENTRY_UNMEMORIALIZEDDEST_13083723319671530750)],
        ),
        (
            UniCase::ascii("unalcoholiseds"),
            &[(0b10010, &ENTRY_UNALCOHOLIZEDS_3779587450961636557)],
        ),
        (
            UniCase::ascii("allegorising"),
            &[(0b10010, &ENTRY_ALLEGORIZING_899303066346673273)],
        ),
        (
            UniCase::ascii("hospitalize"),
            &[(0b01001, &ENTRY_HOSPITALIZE_6250395622105373650)],
        ),
        (
            UniCase::ascii("enterocele"),
            &[(0b00001, &ENTRY_ENTEROCELE_7421588424099714866)],
        ),
        (
            UniCase::ascii("undramatizables"),
            &[(0b01001, &ENTRY_UNDRAMATIZABLES_1761059456444333869)],
        ),
        (
            UniCase::ascii("departmentises"),
            &[(0b10010, &ENTRY_DEPARTMENTIZES_7420843837381616897)],
        ),
        (
            UniCase::ascii("hyperthyroidise"),
            &[(0b10010, &ENTRY_HYPERTHYROIDIZE_220125976519158472)],
        ),
        (
            UniCase::ascii("tropicalization"),
            &[(0b01001, &ENTRY_TROPICALIZATION_280149473467881406)],
        ),
        (
            UniCase::ascii("vacuumised"),
            &[(0b10010, &ENTRY_VACUUMIZED_694297391266218663)],
        ),
        (
            UniCase::ascii("criticizers"),
            &[(0b01001, &ENTRY_CRITICIZERS_1569351139366706310)],
        ),
        (
            UniCase::ascii("unparticulariseds"),
            &[(0b10010, &ENTRY_UNPARTICULARIZEDS_7009295388737864374)],
        ),
        (
            UniCase::ascii("tailorisations"),
            &[(0b10010, &ENTRY_TAILORIZATIONS_1736724620876472569)],
        ),
        (
            UniCase::ascii("honorabliest"),
            &[(0b11001, &ENTRY_HONORABLIEST_11197357664137213595)],
        ),
        (
            UniCase::ascii("underprizing"),
            &[(0b01001, &ENTRY_UNDERPRIZING_17802343668144879352)],
        ),
        (
            UniCase::ascii("devalorizing"),
            &[(0b01001, &ENTRY_DEVALORIZING_745754966056062243)],
        ),
        (
            UniCase::ascii("disauthorizes"),
            &[(0b01001, &ENTRY_DISAUTHORIZES_16971580585403699509)],
        ),
        (
            UniCase::ascii("austrianise"),
            &[(0b10010, &ENTRY_AUSTRIANIZE_13889494210532044520)],
        ),
        (
            UniCase::ascii("tantalisingness"),
            &[(0b10010, &ENTRY_TANTALIZINGNESS_5920752991593005851)],
        ),
        (
            UniCase::ascii("paroeciously"),
            &[(0b11010, &ENTRY_PARECIOUSLY_11156310959668142943)],
        ),
        (
            UniCase::ascii("cupelled"),
            &[(0b11010, &ENTRY_CUPELED_8946630193695466634)],
        ),
        (
            UniCase::ascii("alkalize"),
            &[(0b01001, &ENTRY_ALKALIZE_5536262726734715214)],
        ),
        (
            UniCase::ascii("polonizing"),
            &[(0b01001, &ENTRY_POLONIZING_11665670612780971592)],
        ),
        (
            UniCase::ascii("volatilizer"),
            &[(0b01001, &ENTRY_VOLATILIZER_15355427557723391751)],
        ),
        (
            UniCase::ascii("pearlised"),
            &[(0b10010, &ENTRY_PEARLIZED_1624453871015926144)],
        ),
        (
            UniCase::ascii("reutilising"),
            &[(0b10010, &ENTRY_REUTILIZING_4912219485422295764)],
        ),
        (
            UniCase::ascii("fanaticizes"),
            &[(0b01001, &ENTRY_FANATICIZES_11857074349260388346)],
        ),
        (
            UniCase::ascii("carbonisable"),
            &[(0b10010, &ENTRY_CARBONIZABLE_7275477916888704155)],
        ),
        (
            UniCase::ascii("panaesthetic"),
            &[(0b11010, &ENTRY_PANESTHETIC_11607514217078102793)],
        ),
        (
            UniCase::ascii("solutizers"),
            &[(0b01001, &ENTRY_SOLUTIZERS_16598006390430358557)],
        ),
        (
            UniCase::ascii("spirochaetotic"),
            &[(0b11010, &ENTRY_SPIROCHETOTIC_8684207899956468554)],
        ),
        (
            UniCase::ascii("tropicalizing"),
            &[(0b01001, &ENTRY_TROPICALIZING_17779530954870328562)],
        ),
        (
            UniCase::ascii("defensing"),
            &[(0b01001, &ENTRY_DEFENSING_13872432362849183791)],
        ),
        (
            UniCase::ascii("deputationize"),
            &[(0b01001, &ENTRY_DEPUTATIONIZE_6925287050174299860)],
        ),
        (
            UniCase::ascii("centrifugalisations"),
            &[(0b10010, &ENTRY_CENTRIFUGALIZATIONS_16355479198686645900)],
        ),
        (
            UniCase::ascii("unsystemizables"),
            &[(0b01001, &ENTRY_UNSYSTEMIZABLES_11770476614828889053)],
        ),
        (
            UniCase::ascii("trivialising"),
            &[(0b10010, &ENTRY_TRIVIALIZING_11202764572056711533)],
        ),
        (
            UniCase::ascii("enigmatised"),
            &[(0b10010, &ENTRY_ENIGMATIZED_17096479822940125639)],
        ),
        (
            UniCase::ascii("unraveled"),
            &[(0b00001, &ENTRY_UNRAVELED_8531790293658379223)],
        ),
        (
            UniCase::ascii("nationalisation"),
            &[(0b10010, &ENTRY_NATIONALIZATION_5030239828494323305)],
        ),
        (
            UniCase::ascii("earlierizing"),
            &[(0b01001, &ENTRY_EARLIERIZING_8179681759986389983)],
        ),
        (
            UniCase::ascii("demineraliser"),
            &[(0b10010, &ENTRY_DEMINERALIZER_11839062214960881518)],
        ),
        (
            UniCase::ascii("dimerize"),
            &[(0b01001, &ENTRY_DIMERIZE_16193073428737317522)],
        ),
        (
            UniCase::ascii("pharisean"),
            &[(0b00001, &ENTRY_PHARISEAN_2326065742596188618)],
        ),
        (
            UniCase::ascii("interjectionise"),
            &[(0b10010, &ENTRY_INTERJECTIONIZE_4980810915948512817)],
        ),
        (
            UniCase::ascii("spirea"),
            &[(0b01001, &ENTRY_SPIREA_16883104999884113279)],
        ),
        (
            UniCase::ascii("summarizers"),
            &[(0b01001, &ENTRY_SUMMARIZERS_10721471147508695276)],
        ),
        (
            UniCase::ascii("gormandised"),
            &[(0b10010, &ENTRY_GORMANDIZED_10731842314325530180)],
        ),
        (
            UniCase::ascii("genializes"),
            &[(0b01001, &ENTRY_GENIALIZES_12942921211709985866)],
        ),
        (
            UniCase::ascii("peculiarise"),
            &[(0b10010, &ENTRY_PECULIARIZE_3060403711343105035)],
        ),
        (
            UniCase::ascii("apprizers"),
            &[(0b01001, &ENTRY_APPRIZERS_16559280108388910365)],
        ),
        (
            UniCase::ascii("intercivilisations"),
            &[(0b10010, &ENTRY_INTERCIVILIZATIONS_16686447883834461544)],
        ),
        (
            UniCase::ascii("esthesias"),
            &[(0b00001, &ENTRY_ESTHESIAS_5684600885047217053)],
        ),
        (
            UniCase::ascii("phenomenalized"),
            &[(0b01001, &ENTRY_PHENOMENALIZED_5794978347542150916)],
        ),
        (
            UniCase::ascii("dispopularise"),
            &[(0b10010, &ENTRY_DISPOPULARIZE_6744315358378905582)],
        ),
        (
            UniCase::ascii("monologised"),
            &[(0b10010, &ENTRY_MONOLOGIZED_213349531977540597)],
        ),
        (
            UniCase::ascii("cryptanalyzes"),
            &[(0b01001, &ENTRY_CRYPTANALYZES_8578659007864632505)],
        ),
        (
            UniCase::ascii("nominalised"),
            &[(0b10010, &ENTRY_NOMINALIZED_2433981011225381934)],
        ),
        (
            UniCase::ascii("paleozoic"),
            &[(0b10001, &ENTRY_PALEOZOIC_15539659693355565678)],
        ),
        (
            UniCase::ascii("prelatizes"),
            &[(0b01001, &ENTRY_PRELATIZES_10566341519699434934)],
        ),
        (
            UniCase::ascii("enamor"),
            &[(0b11001, &ENTRY_ENAMOR_2911879302324239036)],
        ),
        (
            UniCase::ascii("breathalyser"),
            &[(0b11010, &ENTRY_BREATHALYZER_15434122011452224968)],
        ),
        (
            UniCase::ascii("paleoherpetology"),
            &[(0b10001, &ENTRY_PALEOHERPETOLOGY_6195422226443274584)],
        ),
        (
            UniCase::ascii("apophthegmatises"),
            &[(0b10010, &ENTRY_APOPHTHEGMATIZES_9217219445848562213)],
        ),
        (
            UniCase::ascii("chequerboard"),
            &[(0b11010, &ENTRY_CHECKERBOARD_8549731976664485147)],
        ),
        (
            UniCase::ascii("savory"),
            &[(0b11001, &ENTRY_SAVORY_18035223196990312431)],
        ),
        (
            UniCase::ascii("decimalise"),
            &[(0b10010, &ENTRY_DECIMALIZE_17840181587779229578)],
        ),
        (
            UniCase::ascii("septembrizers"),
            &[(0b01001, &ENTRY_SEPTEMBRIZERS_5568167245143709930)],
        ),
        (
            UniCase::ascii("monophthongize"),
            &[(0b01001, &ENTRY_MONOPHTHONGIZE_15612903189375621340)],
        ),
        (
            UniCase::ascii("parfocalize"),
            &[(0b01001, &ENTRY_PARFOCALIZE_11199953063987118573)],
        ),
        (
            UniCase::ascii("patrializations"),
            &[(0b01001, &ENTRY_PATRIALIZATIONS_17945934088767852952)],
        ),
        (
            UniCase::ascii("quantizers"),
            &[(0b01001, &ENTRY_QUANTIZERS_7834757600518271281)],
        ),
        (
            UniCase::ascii("theorizes"),
            &[(0b01001, &ENTRY_THEORIZES_1097471905147904168)],
        ),
        (
            UniCase::ascii("subaetheric"),
            &[(0b11010, &ENTRY_SUBETHERIC_2596346146616427172)],
        ),
        (
            UniCase::ascii("coenaculum"),
            &[(0b11010, &ENTRY_CENACULUM_14642801640862790402)],
        ),
        (
            UniCase::ascii("editorializes"),
            &[(0b01001, &ENTRY_EDITORIALIZES_3002090244472118034)],
        ),
        (
            UniCase::ascii("vulcanizes"),
            &[(0b01001, &ENTRY_VULCANIZES_18094247566727839218)],
        ),
        (
            UniCase::ascii("sectionalising"),
            &[(0b10010, &ENTRY_SECTIONALIZING_11106492791716994585)],
        ),
        (
            UniCase::ascii("harborlesses"),
            &[(0b11001, &ENTRY_HARBORLESSES_12304255545984710354)],
        ),
        (
            UniCase::ascii("metamerization"),
            &[(0b01001, &ENTRY_METAMERIZATION_2147110593558933265)],
        ),
        (
            UniCase::ascii("noncolours"),
            &[(0b11010, &ENTRY_NONCOLORS_4340941599912184140)],
        ),
        (
            UniCase::ascii("sentimentalizer"),
            &[(0b01001, &ENTRY_SENTIMENTALIZER_10892451054407203292)],
        ),
        (
            UniCase::ascii("hyperaestheticer"),
            &[(0b11010, &ENTRY_HYPERESTHETICER_15328293772641718368)],
        ),
        (
            UniCase::ascii("remoralizations"),
            &[(0b01001, &ENTRY_REMORALIZATIONS_5269456965430948283)],
        ),
        (
            UniCase::ascii("periodizations"),
            &[(0b01001, &ENTRY_PERIODIZATIONS_16536767337590632344)],
        ),
        (
            UniCase::ascii("aristae"),
            &[(0b11010, &ENTRY_ARISTE_4207971148573549326)],
        ),
        (
            UniCase::ascii("tranquillisations"),
            &[(0b10010, &ENTRY_TRANQUILLIZATIONS_4263826721380617410)],
        ),
        (
            UniCase::ascii("characterizables"),
            &[(0b01001, &ENTRY_CHARACTERIZABLES_15907805406605774252)],
        ),
        (
            UniCase::ascii("recognisances"),
            &[(0b10010, &ENTRY_RECOGNIZANCES_6362532022872453821)],
        ),
        (
            UniCase::ascii("ostracizables"),
            &[(0b01001, &ENTRY_OSTRACIZABLES_8680285522090921467)],
        ),
        (
            UniCase::ascii("cerat"),
            &[(0b00001, &ENTRY_CERAT_1886332108569610985)],
        ),
        (
            UniCase::ascii("phoneying"),
            &[(0b00001, &ENTRY_PHONYING_3078208997195609574)],
        ),
        (
            UniCase::ascii("devitalises"),
            &[(0b10010, &ENTRY_DEVITALIZES_9074596952558116656)],
        ),
        (
            UniCase::ascii("vectorizes"),
            &[(0b01001, &ENTRY_VECTORIZES_7917294144821648305)],
        ),
        (
            UniCase::ascii("respectabilise"),
            &[(0b10010, &ENTRY_RESPECTABILIZE_11155380117077366918)],
        ),
        (
            UniCase::ascii("womanizing"),
            &[(0b01001, &ENTRY_WOMANIZING_18027895621894995913)],
        ),
        (
            UniCase::ascii("autotomize"),
            &[(0b01001, &ENTRY_AUTOTOMIZE_10870376480991549462)],
        ),
        (
            UniCase::ascii("licenselesses"),
            &[(0b00001, &ENTRY_LICENSELESSES_13483570119205630906)],
        ),
        (
            UniCase::ascii("remagnetises"),
            &[(0b10010, &ENTRY_REMAGNETIZES_11510663723565945487)],
        ),
        (
            UniCase::ascii("habitualise"),
            &[(0b10010, &ENTRY_HABITUALIZE_1807450546975383265)],
        ),
        (
            UniCase::ascii("catalyzed"),
            &[(0b01001, &ENTRY_CATALYZED_14626193667566838732)],
        ),
        (
            UniCase::ascii("calandre"),
            &[(0b11010, &ENTRY_CALANDER_1319585864060436502)],
        ),
        (
            UniCase::ascii("recarbonisers"),
            &[(0b10010, &ENTRY_RECARBONIZERS_13171975227254449418)],
        ),
        (
            UniCase::ascii("oxygenizer"),
            &[(0b01001, &ENTRY_OXYGENIZER_1558268197723031493)],
        ),
        (
            UniCase::ascii("tranquilisation"),
            &[(0b10010, &ENTRY_TRANQUILIZATION_14846255753979813760)],
        ),
        (
            UniCase::ascii("superfoetation"),
            &[(0b11010, &ENTRY_SUPERFETATION_12600225493156545849)],
        ),
        (
            UniCase::ascii("picogramme"),
            &[(0b10010, &ENTRY_PICOGRAM_11350367043126236604)],
        ),
        (
            UniCase::ascii("unchristianising"),
            &[(0b10010, &ENTRY_UNCHRISTIANIZING_16239590731316126727)],
        ),
        (
            UniCase::ascii("unappetisingliest"),
            &[(0b10010, &ENTRY_UNAPPETIZINGLIEST_13095442457868536397)],
        ),
        (
            UniCase::ascii("symbolizations"),
            &[(0b01001, &ENTRY_SYMBOLIZATIONS_5969166456353671405)],
        ),
        (
            UniCase::ascii("kinestheticalliest"),
            &[(0b10001, &ENTRY_KINESTHETICALLIEST_4433069150068533408)],
        ),
        (
            UniCase::ascii("paleoethnology"),
            &[(0b10001, &ENTRY_PALEOETHNOLOGY_8500804609820740340)],
        ),
        (
            UniCase::ascii("musicalize"),
            &[(0b01001, &ENTRY_MUSICALIZE_14105870209904150736)],
        ),
        (
            UniCase::ascii("civilizabler"),
            &[(0b01001, &ENTRY_CIVILIZABLER_1009443025003033054)],
        ),
        (
            UniCase::ascii("anabaptising"),
            &[(0b10010, &ENTRY_ANABAPTIZING_3689660901707732301)],
        ),
        (
            UniCase::ascii("assidean"),
            &[(0b00001, &ENTRY_ASSIDEAN_4573494847516673943)],
        ),
        (
            UniCase::ascii("unnoncolourably"),
            &[(0b11010, &ENTRY_UNNONCOLORABLY_5346203888294556991)],
        ),
        (
            UniCase::ascii("theatregoings"),
            &[(0b11010, &ENTRY_THEATERGOINGS_6740435645328474541)],
        ),
        (
            UniCase::ascii("sensitisation"),
            &[(0b10010, &ENTRY_SENSITIZATION_5562142577083526555)],
        ),
        (
            UniCase::ascii("suburbanisations"),
            &[(0b10010, &ENTRY_SUBURBANIZATIONS_4594207725356201298)],
        ),
        (
            UniCase::ascii("depressurised"),
            &[(0b10010, &ENTRY_DEPRESSURIZED_590523559314456395)],
        ),
        (
            UniCase::ascii("praepostors"),
            &[(0b11010, &ENTRY_PREPOSTORS_8760995478070950332)],
        ),
        (
            UniCase::ascii("azotising"),
            &[(0b10010, &ENTRY_AZOTIZING_14086470722290046366)],
        ),
        (
            UniCase::ascii("homoeomerous"),
            &[(0b11010, &ENTRY_HOMEOMEROUS_6218438835083612194)],
        ),
        (
            UniCase::ascii("customize"),
            &[(0b01001, &ENTRY_CUSTOMIZE_17506619842499670481)],
        ),
        (
            UniCase::ascii("precipes"),
            &[(0b00001, &ENTRY_PRECIPES_591594308859789992)],
        ),
        (
            UniCase::ascii("prioritising"),
            &[(0b10010, &ENTRY_PRIORITIZING_1918447248395854235)],
        ),
        (
            UniCase::ascii("transcolorrer"),
            &[(0b00001, &ENTRY_TRANSCOLORRER_4795645889162012189)],
        ),
        (
            UniCase::ascii("deenergize"),
            &[(0b01001, &ENTRY_DEENERGIZE_12832371231418785666)],
        ),
        (
            UniCase::ascii("exteriorises"),
            &[(0b10010, &ENTRY_EXTERIORIZES_10941715232314771538)],
        ),
        (
            UniCase::ascii("creolite"),
            &[(0b11010, &ENTRY_CEROLITE_7632841335460717740)],
        ),
        (
            UniCase::ascii("jovialises"),
            &[(0b10010, &ENTRY_JOVIALIZES_15779794696747576301)],
        ),
        (
            UniCase::ascii("proctorisation"),
            &[(0b10010, &ENTRY_PROCTORIZATION_10856447202079910826)],
        ),
        (
            UniCase::ascii("mycohemia"),
            &[(0b10001, &ENTRY_MYCOHEMIA_14011500395634142073)],
        ),
        (
            UniCase::ascii("apotheosises"),
            &[(0b10010, &ENTRY_APOTHEOSIZES_6448094166099469006)],
        ),
        (
            UniCase::ascii("devalorizations"),
            &[(0b01001, &ENTRY_DEVALORIZATIONS_12670639433164026734)],
        ),
        (
            UniCase::ascii("subtilisation"),
            &[(0b10010, &ENTRY_SUBTILIZATION_16525688905774221339)],
        ),
        (
            UniCase::ascii("tutorizing"),
            &[(0b01001, &ENTRY_TUTORIZING_17098833328892189609)],
        ),
        (
            UniCase::ascii("scrutinizinglies"),
            &[(0b01001, &ENTRY_SCRUTINIZINGLIES_6550131961437823868)],
        ),
        (
            UniCase::ascii("woollenize"),
            &[(0b01000, &ENTRY_WOOLENIZE_3109266446842903533)],
        ),
        (
            UniCase::ascii("nonlocalised"),
            &[(0b10010, &ENTRY_NONLOCALIZED_11579777543530255255)],
        ),
        (
            UniCase::ascii("photosynthesize"),
            &[(0b01001, &ENTRY_PHOTOSYNTHESIZE_16528133077473184545)],
        ),
        (
            UniCase::ascii("spiralises"),
            &[(0b10010, &ENTRY_SPIRALIZES_6682564053194995427)],
        ),
        (
            UniCase::ascii("mythiciser"),
            &[(0b10010, &ENTRY_MYTHICIZER_17943353036856898639)],
        ),
        (
            UniCase::ascii("assafetidas"),
            &[(0b00001, &ENTRY_ASSAFETIDAS_15617703533170914973)],
        ),
        (
            UniCase::ascii("spermatorrhoea"),
            &[(0b11010, &ENTRY_SPERMATORRHEA_11364148558414858528)],
        ),
        (
            UniCase::ascii("pelletised"),
            &[(0b10010, &ENTRY_PELLETIZED_3294804075577157384)],
        ),
        (
            UniCase::ascii("unparametrised"),
            &[(0b10010, &ENTRY_UNPARAMETRIZED_37046481284940289)],
        ),
        (
            UniCase::ascii("homologisation"),
            &[(0b10010, &ENTRY_HOMOLOGIZATION_2821144199023611743)],
        ),
        (
            UniCase::ascii("theatergoing"),
            &[(0b00001, &ENTRY_THEATERGOING_9036609633778609239)],
        ),
        (
            UniCase::ascii("phacochoere"),
            &[(0b11010, &ENTRY_PHACOCHERE_4955198037695802664)],
        ),
        (
            UniCase::ascii("typhloenteritis"),
            &[(0b11010, &ENTRY_TYPHLENTERITIS_16701047769348734014)],
        ),
        (
            UniCase::ascii("industrializations"),
            &[(0b01001, &ENTRY_INDUSTRIALIZATIONS_5781661892562457350)],
        ),
        (
            UniCase::ascii("weaselling"),
            &[(0b10010, &ENTRY_WEASELING_15286296280087806597)],
        ),
        (
            UniCase::ascii("albumenizer"),
            &[(0b01001, &ENTRY_ALBUMENIZER_59375995865224011)],
        ),
        (
            UniCase::ascii("aggrandisement"),
            &[(0b10010, &ENTRY_AGGRANDIZEMENT_16561527183094401215)],
        ),
        (
            UniCase::ascii("unsensitising"),
            &[(0b10010, &ENTRY_UNSENSITIZING_5882427315960709496)],
        ),
        (
            UniCase::ascii("proletarized"),
            &[(0b01001, &ENTRY_PROLETARIZED_10377426615142966996)],
        ),
        (
            UniCase::ascii("fantasising"),
            &[(0b10010, &ENTRY_FANTASIZING_17657564354102329164)],
        ),
        (
            UniCase::ascii("joky"),
            &[(0b10011, &ENTRY_JOKEY_16351543528249851559)],
        ),
        (
            UniCase::ascii("repolymerization"),
            &[(0b01001, &ENTRY_REPOLYMERIZATION_4016733859370100512)],
        ),
        (
            UniCase::ascii("doctrinisation"),
            &[(0b10010, &ENTRY_DOCTRINIZATION_16019265374829905601)],
        ),
        (
            UniCase::ascii("alphabetising"),
            &[(0b10010, &ENTRY_ALPHABETIZING_8059168115305559564)],
        ),
        (
            UniCase::ascii("uncatechizeds"),
            &[(0b01001, &ENTRY_UNCATECHIZEDS_13859045064739112709)],
        ),
        (
            UniCase::ascii("leguminose"),
            &[(0b00001, &ENTRY_LEGUMINOSE_13351579956836938693)],
        ),
        (
            UniCase::ascii("parisianize"),
            &[(0b01001, &ENTRY_PARISIANIZE_6192760037620464041)],
        ),
        (
            UniCase::ascii("foolhardizing"),
            &[(0b01001, &ENTRY_FOOLHARDIZING_14970024232233507775)],
        ),
        (
            UniCase::ascii("glamorless"),
            &[(0b10001, &ENTRY_GLAMORLESS_3213378030533857078)],
        ),
        (
            UniCase::ascii("aryanize"),
            &[(0b01001, &ENTRY_ARYANIZE_16869282873759611476)],
        ),
        (
            UniCase::ascii("sulfatizes"),
            &[(0b01001, &ENTRY_SULFATIZES_6036327854424560867)],
        ),
        (
            UniCase::ascii("morphinisations"),
            &[(0b10010, &ENTRY_MORPHINIZATIONS_1979094451135743390)],
        ),
        (
            UniCase::ascii("anthropomorphizations"),
            &[(0b01001, &ENTRY_ANTHROPOMORPHIZATIONS_18314256758800098784)],
        ),
        (
            UniCase::ascii("sabbatized"),
            &[(0b01001, &ENTRY_SABBATIZED_13406040171945222761)],
        ),
        (
            UniCase::ascii("colonised"),
            &[(0b10010, &ENTRY_COLONIZED_12903152841060558253)],
        ),
        (
            UniCase::ascii("antisyphon"),
            &[(0b11010, &ENTRY_ANTISIPHON_15645040475271523141)],
        ),
        (
            UniCase::ascii("sublimising"),
            &[(0b10010, &ENTRY_SUBLIMIZING_12673180625915709564)],
        ),
        (
            UniCase::ascii("neopaganises"),
            &[(0b10010, &ENTRY_NEOPAGANIZES_10627781041046310586)],
        ),
        (
            UniCase::ascii("phlebotomization"),
            &[(0b01001, &ENTRY_PHLEBOTOMIZATION_17488495197793456474)],
        ),
        (
            UniCase::ascii("phorrhea"),
            &[(0b00001, &ENTRY_PHORRHEA_13208068197196345881)],
        ),
        (
            UniCase::ascii("spiritualizers"),
            &[(0b01001, &ENTRY_SPIRITUALIZERS_3732134443047012330)],
        ),
        (
            UniCase::ascii("hellenizes"),
            &[(0b01001, &ENTRY_HELLENIZES_11902572538272316091)],
        ),
        (
            UniCase::ascii("peptizers"),
            &[(0b01001, &ENTRY_PEPTIZERS_969896506919570594)],
        ),
        (
            UniCase::ascii("scepterless"),
            &[(0b00001, &ENTRY_SCEPTERLESS_14014584389608395039)],
        ),
        (
            UniCase::ascii("problemizes"),
            &[(0b01001, &ENTRY_PROBLEMIZES_16167676205731844544)],
        ),
        (
            UniCase::ascii("peptonise"),
            &[(0b10010, &ENTRY_PEPTONIZE_912826138201664087)],
        ),
        (
            UniCase::ascii("fletcherises"),
            &[(0b10010, &ENTRY_FLETCHERIZES_9045962588657153054)],
        ),
        (
            UniCase::ascii("praecordial"),
            &[(0b11010, &ENTRY_PRECORDIAL_11745663068833489838)],
        ),
        (
            UniCase::ascii("missionizers"),
            &[(0b01001, &ENTRY_MISSIONIZERS_9999401875646897234)],
        ),
        (
            UniCase::ascii("crystallisablest"),
            &[(0b10010, &ENTRY_CRYSTALLIZABLEST_11639541143335039276)],
        ),
        (
            UniCase::ascii("equalisations"),
            &[(0b10010, &ENTRY_EQUALIZATIONS_682915140211915244)],
        ),
        (
            UniCase::ascii("parochialisation"),
            &[(0b10010, &ENTRY_PAROCHIALIZATION_9992801911204982717)],
        ),
        (
            UniCase::ascii("seculariser"),
            &[(0b10010, &ENTRY_SECULARIZER_8531483256485763608)],
        ),
        (
            UniCase::ascii("marvellousness"),
            &[(0b11010, &ENTRY_MARVELOUSNESS_7406444444223070939)],
        ),
        (
            UniCase::ascii("nonsuccour"),
            &[(0b11010, &ENTRY_NONSUCCOR_1588594977500462039)],
        ),
        (
            UniCase::ascii("unfavourableness"),
            &[(0b11010, &ENTRY_UNFAVORABLENESS_11828384935093784234)],
        ),
        (
            UniCase::ascii("macarizes"),
            &[(0b01001, &ENTRY_MACARIZES_7493607414497918990)],
        ),
        (
            UniCase::ascii("laureled"),
            &[(0b00001, &ENTRY_LAURELED_11054307884791506795)],
        ),
        (
            UniCase::ascii("coalizer"),
            &[(0b01001, &ENTRY_COALIZER_8326324895948995645)],
        ),
        (
            UniCase::ascii("processionises"),
            &[(0b10010, &ENTRY_PROCESSIONIZES_13973102018086646225)],
        ),
        (
            UniCase::ascii("equalisings"),
            &[(0b10010, &ENTRY_EQUALIZINGS_10284543548419639437)],
        ),
        (
            UniCase::ascii("hematozoon"),
            &[(0b10001, &ENTRY_HEMATOZOON_5429660456895400780)],
        ),
        (
            UniCase::ascii("vaporific"),
            &[(0b00001, &ENTRY_VAPORIFIC_16729671073785623946)],
        ),
        (
            UniCase::ascii("bowlder"),
            &[(0b00001, &ENTRY_BOULDER_12516261271833260895)],
        ),
        (
            UniCase::ascii("prestandardizations"),
            &[(0b01001, &ENTRY_PRESTANDARDIZATIONS_5412386093865221649)],
        ),
        (
            UniCase::ascii("frenula"),
            &[(0b00001, &ENTRY_FRENULA_10450628952852883483)],
        ),
        (
            UniCase::ascii("asynchronised"),
            &[(0b10010, &ENTRY_ASYNCHRONIZED_2264379807465924648)],
        ),
        (
            UniCase::ascii("southernise"),
            &[(0b10010, &ENTRY_SOUTHERNIZE_2007900784402703927)],
        ),
        (
            UniCase::ascii("pamphletises"),
            &[(0b10010, &ENTRY_PAMPHLETIZES_10198512299714902969)],
        ),
        (
            UniCase::ascii("papalisations"),
            &[(0b10010, &ENTRY_PAPALIZATIONS_8937933260778799316)],
        ),
        (
            UniCase::ascii("gynaecologics"),
            &[(0b11010, &ENTRY_GYNECOLOGICS_15475065316407176832)],
        ),
        (
            UniCase::ascii("theorisers"),
            &[(0b10010, &ENTRY_THEORIZERS_17644565410392015986)],
        ),
        (
            UniCase::ascii("unantagonizable"),
            &[(0b01001, &ENTRY_UNANTAGONIZABLE_8940938838594676762)],
        ),
        (
            UniCase::ascii("pseudooedema"),
            &[(0b11010, &ENTRY_PSEUDOEDEMA_15891555805692784302)],
        ),
        (
            UniCase::ascii("jasperizes"),
            &[(0b01001, &ENTRY_JASPERIZES_13853455828472448050)],
        ),
        (
            UniCase::ascii("caestus"),
            &[(0b11010, &ENTRY_CESTUS_2264271345052468556)],
        ),
        (
            UniCase::ascii("eger"),
            &[
                (0b00001, &ENTRY_EGER_3267279819185100866),
                (0b00001, &ENTRY_EGER_370209078151771517),
            ],
        ),
        (
            UniCase::ascii("chimaerid"),
            &[(0b11010, &ENTRY_CHIMERID_12786529903260126440)],
        ),
        (
            UniCase::ascii("hematuria"),
            &[(0b11001, &ENTRY_HEMATURIA_4282384524379690883)],
        ),
        (
            UniCase::ascii("misadvise"),
            &[(0b10010, &ENTRY_MISADVIZE_16409133113491535237)],
        ),
        (
            UniCase::ascii("saccharised"),
            &[(0b10010, &ENTRY_SACCHARIZED_17475431280128284092)],
        ),
        (
            UniCase::ascii("myxoedemas"),
            &[(0b10010, &ENTRY_MYXEDEMAS_2503279100646867910)],
        ),
        (
            UniCase::ascii("yodeller"),
            &[(0b11010, &ENTRY_YODELER_285878482199218584)],
        ),
        (
            UniCase::ascii("unsabreddest"),
            &[(0b11010, &ENTRY_UNSABEREDDEST_4361858810448422047)],
        ),
        (
            UniCase::ascii("collectivization"),
            &[(0b01001, &ENTRY_COLLECTIVIZATION_10577206395052359405)],
        ),
        (
            UniCase::ascii("heavenise"),
            &[(0b10010, &ENTRY_HEAVENIZE_13257962880157202779)],
        ),
        (
            UniCase::ascii("kinaestheses"),
            &[(0b11010, &ENTRY_KINESTHESES_5537328044553929564)],
        ),
        (
            UniCase::ascii("unlocalize"),
            &[(0b01001, &ENTRY_UNLOCALIZE_13492036293954003927)],
        ),
        (
            UniCase::ascii("plowing"),
            &[(0b01001, &ENTRY_PLOWING_16570546940479665223)],
        ),
        (
            UniCase::ascii("herborizing"),
            &[(0b01001, &ENTRY_HERBORIZING_14418490249039027873)],
        ),
        (
            UniCase::ascii("disdiplomatises"),
            &[(0b10010, &ENTRY_DISDIPLOMATIZES_4891957747419116479)],
        ),
        (
            UniCase::ascii("analyzes"),
            &[(0b01001, &ENTRY_ANALYZES_13473182794044934522)],
        ),
        (
            UniCase::ascii("linenisers"),
            &[(0b10010, &ENTRY_LINENIZERS_17723432590290079521)],
        ),
        (
            UniCase::ascii("pragmatizations"),
            &[(0b01001, &ENTRY_PRAGMATIZATIONS_1347693305826589779)],
        ),
        (
            UniCase::ascii("jargonisations"),
            &[(0b10010, &ENTRY_JARGONIZATIONS_3515989118992786878)],
        ),
        (
            UniCase::ascii("petrolise"),
            &[(0b10010, &ENTRY_PETROLIZE_7665552287162264221)],
        ),
        (
            UniCase::ascii("anthecological"),
            &[(0b00001, &ENTRY_ANTHECOLOGICAL_17004641370097456161)],
        ),
        (
            UniCase::ascii("decentralises"),
            &[(0b10010, &ENTRY_DECENTRALIZES_4819976769659557164)],
        ),
        (
            UniCase::ascii("destalinised"),
            &[(0b10010, &ENTRY_DESTALINIZED_9729731297639277285)],
        ),
        (
            UniCase::ascii("isoimmunisation"),
            &[(0b10010, &ENTRY_ISOIMMUNIZATION_16129604172463725287)],
        ),
        (
            UniCase::ascii("estrogens"),
            &[(0b11001, &ENTRY_ESTROGENS_13879624153768181446)],
        ),
        (
            UniCase::ascii("sabertooth"),
            &[(0b00001, &ENTRY_SABERTOOTH_232682195526621441)],
        ),
        (
            UniCase::ascii("taborer"),
            &[(0b00001, &ENTRY_TABORER_259230914231617550)],
        ),
        (
            UniCase::ascii("reoxidising"),
            &[(0b10010, &ENTRY_REOXIDIZING_18024783650819146058)],
        ),
        (
            UniCase::ascii("logicized"),
            &[(0b01001, &ENTRY_LOGICIZED_2546846215835324757)],
        ),
        (
            UniCase::ascii("atrocoeruleus"),
            &[(0b11010, &ENTRY_ATROCERULEUS_7452134384217065626)],
        ),
        (
            UniCase::ascii("unsentimentalized"),
            &[(0b01001, &ENTRY_UNSENTIMENTALIZED_6565195653528439940)],
        ),
        (
            UniCase::ascii("resensitizations"),
            &[(0b01001, &ENTRY_RESENSITIZATIONS_919995710981311836)],
        ),
        (
            UniCase::ascii("outtyrannizes"),
            &[(0b01001, &ENTRY_OUTTYRANNIZES_2960809863014622911)],
        ),
        (
            UniCase::ascii("colorer"),
            &[(0b11001, &ENTRY_COLORER_6377883908421217617)],
        ),
        (
            UniCase::ascii("ungospelized"),
            &[(0b01001, &ENTRY_UNGOSPELIZED_7916023896723661075)],
        ),
        (
            UniCase::ascii("melodising"),
            &[(0b10010, &ENTRY_MELODIZING_13910918430639522337)],
        ),
        (
            UniCase::ascii("engrandize"),
            &[(0b01001, &ENTRY_ENGRANDIZE_17642469822387491571)],
        ),
        (
            UniCase::ascii("ervalenta"),
            &[(0b00001, &ENTRY_ERVALENTA_10785450433515167284)],
        ),
        (
            UniCase::ascii("uncolonizes"),
            &[(0b01001, &ENTRY_UNCOLONIZES_9719326327721062003)],
        ),
        (
            UniCase::ascii("pressurises"),
            &[(0b10010, &ENTRY_PRESSURIZES_3533546061921034401)],
        ),
        (
            UniCase::ascii("suberise"),
            &[(0b10010, &ENTRY_SUBERIZE_9965568250579749505)],
        ),
        (
            UniCase::ascii("harmoniser"),
            &[(0b10010, &ENTRY_HARMONIZER_11079314650397597076)],
        ),
        (
            UniCase::ascii("amoebiosis"),
            &[(0b11010, &ENTRY_AMEBIOSIS_4936567060198771189)],
        ),
        (
            UniCase::ascii("sapremia"),
            &[(0b00001, &ENTRY_SAPREMIA_10927593620047632704)],
        ),
        (
            UniCase::ascii("mesmerisers"),
            &[(0b10010, &ENTRY_MESMERIZERS_2175164108172756867)],
        ),
        (
            UniCase::ascii("spelaean"),
            &[(0b11010, &ENTRY_SPELEAN_8367235262898475105)],
        ),
        (
            UniCase::ascii("palatize"),
            &[(0b01001, &ENTRY_PALATIZE_5498275993725862299)],
        ),
        (
            UniCase::ascii("axiomatizes"),
            &[(0b01001, &ENTRY_AXIOMATIZES_8178035167309590431)],
        ),
        (
            UniCase::ascii("reanalyze"),
            &[(0b01001, &ENTRY_REANALYZE_10186131393135073487)],
        ),
        (
            UniCase::ascii("pedomorphisms"),
            &[(0b00001, &ENTRY_PEDOMORPHISMS_16472332478041997069)],
        ),
        (
            UniCase::ascii("napaea"),
            &[(0b11010, &ENTRY_NAPEA_2703553051209012323)],
        ),
        (
            UniCase::ascii("procrusteanise"),
            &[(0b10010, &ENTRY_PROCRUSTEANIZE_744493252621097169)],
        ),
        (
            UniCase::ascii("eternalise"),
            &[(0b10010, &ENTRY_ETERNALIZE_11131798101969437364)],
        ),
        (
            UniCase::ascii("racemisations"),
            &[(0b10010, &ENTRY_RACEMIZATIONS_14925364252241043462)],
        ),
        (
            UniCase::ascii("napoleonize"),
            &[(0b01001, &ENTRY_NAPOLEONIZE_13711321813606941055)],
        ),
        (
            UniCase::ascii("beveling"),
            &[(0b01001, &ENTRY_BEVELING_10855109562149223001)],
        ),
        (
            UniCase::ascii("disequalisers"),
            &[(0b10010, &ENTRY_DISEQUALIZERS_17092206736491516096)],
        ),
        (
            UniCase::ascii("turdinae"),
            &[(0b11010, &ENTRY_TURDINE_8495216946259189004)],
        ),
        (
            UniCase::ascii("romanticized"),
            &[(0b01001, &ENTRY_ROMANTICIZED_10936525722537335211)],
        ),
        (
            UniCase::ascii("homoeozoic"),
            &[(0b11010, &ENTRY_HOMEOZOIC_10691139051307473852)],
        ),
        (
            UniCase::ascii("unpractised"),
            &[(0b11010, &ENTRY_UNPRACTICED_9353245174446259318)],
        ),
        (
            UniCase::ascii("pantheonises"),
            &[(0b10010, &ENTRY_PANTHEONIZES_2223291708212001129)],
        ),
        (
            UniCase::ascii("uncrystallizability"),
            &[(0b01001, &ENTRY_UNCRYSTALLIZABILITY_11525239910591863121)],
        ),
        (
            UniCase::ascii("anvilled"),
            &[(0b11010, &ENTRY_ANVILED_16736675705730161078)],
        ),
        (
            UniCase::ascii("legitimatized"),
            &[(0b01001, &ENTRY_LEGITIMATIZED_9454437080445749766)],
        ),
        (
            UniCase::ascii("poetizations"),
            &[(0b01001, &ENTRY_POETIZATIONS_14017988435836090874)],
        ),
        (
            UniCase::ascii("japanises"),
            &[(0b10010, &ENTRY_JAPANIZES_17681743681143797110)],
        ),
        (
            UniCase::ascii("penciling"),
            &[(0b00001, &ENTRY_PENCILING_13598020385460524085)],
        ),
        (
            UniCase::ascii("esterizations"),
            &[(0b01001, &ENTRY_ESTERIZATIONS_13064103908051692902)],
        ),
        (
            UniCase::ascii("asel"),
            &[(0b00001, &ENTRY_ASEL_2991140811333800185)],
        ),
        (
            UniCase::ascii("unparticulariseddest"),
            &[(0b10010, &ENTRY_UNPARTICULARIZEDDEST_12461674155327065922)],
        ),
        (
            UniCase::ascii("racialise"),
            &[(0b10010, &ENTRY_RACIALIZE_5925611520403941440)],
        ),
        (
            UniCase::ascii("schillerisations"),
            &[(0b10010, &ENTRY_SCHILLERIZATIONS_1097721139918947159)],
        ),
        (
            UniCase::ascii("gynecomastia"),
            &[(0b11001, &ENTRY_GYNECOMASTIA_3933758254422394945)],
        ),
        (
            UniCase::ascii("missionarises"),
            &[(0b10010, &ENTRY_MISSIONARIZES_13632702496680971142)],
        ),
        (
            UniCase::ascii("unneighborlinesses"),
            &[(0b00001, &ENTRY_UNNEIGHBORLINESSES_10829695068225729738)],
        ),
        (
            UniCase::ascii("hypothesizer"),
            &[(0b01001, &ENTRY_HYPOTHESIZER_12418298699515974202)],
        ),
        (
            UniCase::ascii("orangize"),
            &[(0b01001, &ENTRY_ORANGIZE_8695259728466009401)],
        ),
        (
            UniCase::ascii("fluoridizes"),
            &[(0b01001, &ENTRY_FLUORIDIZES_13091150879113382645)],
        ),
        (
            UniCase::ascii("nonpenalizeds"),
            &[(0b01001, &ENTRY_NONPENALIZEDS_9532498621715242902)],
        ),
        (
            UniCase::ascii("imperialise"),
            &[(0b10010, &ENTRY_IMPERIALIZE_4481105644087115733)],
        ),
        (
            UniCase::ascii("unscrutinizingly"),
            &[(0b01001, &ENTRY_UNSCRUTINIZINGLY_5893546295582674444)],
        ),
        (
            UniCase::ascii("perlingually"),
            &[(0b00001, &ENTRY_PERLINGUALLY_11928722645527217541)],
        ),
        (
            UniCase::ascii("proletarize"),
            &[(0b01001, &ENTRY_PROLETARIZE_7658575278102132004)],
        ),
        (
            UniCase::ascii("fiscalizations"),
            &[(0b01001, &ENTRY_FISCALIZATIONS_5487988177733166944)],
        ),
        (
            UniCase::ascii("eschynite"),
            &[(0b00001, &ENTRY_ESCHYNITE_18313041144585925088)],
        ),
        (
            UniCase::ascii("apostatizing"),
            &[(0b01001, &ENTRY_APOSTATIZING_10968882224231134376)],
        ),
        (
            UniCase::ascii("asynchronized"),
            &[(0b01001, &ENTRY_ASYNCHRONIZED_2264379807465924648)],
        ),
        (
            UniCase::ascii("orthopedical"),
            &[(0b10001, &ENTRY_ORTHOPEDICAL_14906990439117593315)],
        ),
        (
            UniCase::ascii("cosmeticise"),
            &[(0b10010, &ENTRY_COSMETICIZE_4510163316750805851)],
        ),
        (
            UniCase::ascii("atomizer"),
            &[(0b01001, &ENTRY_ATOMIZER_10420576678406032842)],
        ),
        (
            UniCase::ascii("radiumisations"),
            &[(0b10010, &ENTRY_RADIUMIZATIONS_843643436347756512)],
        ),
        (
            UniCase::ascii("immobilizers"),
            &[(0b01001, &ENTRY_IMMOBILIZERS_8902105516181595834)],
        ),
        (
            UniCase::ascii("reactualize"),
            &[(0b01001, &ENTRY_REACTUALIZE_15121608179320441718)],
        ),
        (
            UniCase::ascii("synthetisation"),
            &[(0b10010, &ENTRY_SYNTHETIZATION_8539269556584261248)],
        ),
        (
            UniCase::ascii("resymbolization"),
            &[(0b01001, &ENTRY_RESYMBOLIZATION_18289962759086702120)],
        ),
        (
            UniCase::ascii("moralizer"),
            &[(0b01001, &ENTRY_MORALIZER_4648462715987842582)],
        ),
        (
            UniCase::ascii("coloristics"),
            &[(0b00001, &ENTRY_COLORISTICS_10161388239807067112)],
        ),
        (
            UniCase::ascii("enhaemospore"),
            &[(0b11010, &ENTRY_ENHEMOSPORE_15543189487115046896)],
        ),
        (
            UniCase::ascii("europeanise"),
            &[(0b10010, &ENTRY_EUROPEANIZE_9458498374082461253)],
        ),
        (
            UniCase::ascii("guiser"),
            &[(0b10010, &ENTRY_GUIZER_10053586555200196360)],
        ),
        (
            UniCase::ascii("coloured"),
            &[(0b11010, &ENTRY_COLORED_809367823820397764)],
        ),
        (
            UniCase::ascii("pauperisations"),
            &[(0b10010, &ENTRY_PAUPERIZATIONS_12078339223087449719)],
        ),
        (
            UniCase::ascii("accouraged"),
            &[(0b11010, &ENTRY_ACCORAGED_14521717986957835986)],
        ),
        (
            UniCase::ascii("elasticizers"),
            &[(0b01001, &ENTRY_ELASTICIZERS_16095393649186847498)],
        ),
        (
            UniCase::ascii("unfraternized"),
            &[(0b01001, &ENTRY_UNFRATERNIZED_15391653689494557711)],
        ),
        (
            UniCase::ascii("phosphatises"),
            &[(0b10010, &ENTRY_PHOSPHATIZES_5129360819999903073)],
        ),
        (
            UniCase::ascii("geologizes"),
            &[(0b01001, &ENTRY_GEOLOGIZES_9944756831526943986)],
        ),
        (
            UniCase::ascii("localizers"),
            &[(0b01001, &ENTRY_LOCALIZERS_15025775966428286175)],
        ),
        (
            UniCase::ascii("nesslerised"),
            &[(0b10010, &ENTRY_NESSLERIZED_1142327510849274666)],
        ),
        (
            UniCase::ascii("desilverise"),
            &[(0b10010, &ENTRY_DESILVERIZE_6336096088586818504)],
        ),
        (
            UniCase::ascii("vocalise"),
            &[(0b10010, &ENTRY_VOCALIZE_1522162759221483083)],
        ),
        (
            UniCase::ascii("hemocytoblast"),
            &[(0b10001, &ENTRY_HEMOCYTOBLAST_8571898144164238141)],
        ),
        (
            UniCase::ascii("enolic"),
            &[(0b00001, &ENTRY_ENOLIC_8677666364536262517)],
        ),
        (
            UniCase::ascii("localizations"),
            &[(0b01001, &ENTRY_LOCALIZATIONS_2073048544247751824)],
        ),
        (
            UniCase::ascii("hemameba"),
            &[(0b10001, &ENTRY_HEMAMEBA_3738470481791074652)],
        ),
        (
            UniCase::ascii("skeletoniser"),
            &[(0b10010, &ENTRY_SKELETONIZER_1742743360367189615)],
        ),
        (
            UniCase::ascii("subpulveriser"),
            &[(0b10010, &ENTRY_SUBPULVERIZER_6713080541658378074)],
        ),
        (
            UniCase::ascii("diminutivize"),
            &[(0b01001, &ENTRY_DIMINUTIVIZE_8157805496969771537)],
        ),
        (
            UniCase::ascii("stalwartize"),
            &[(0b01001, &ENTRY_STALWARTIZE_5995004425928514778)],
        ),
        (
            UniCase::ascii("subspeciality"),
            &[(0b11010, &ENTRY_SUBSPECIALTY_4476391942712911269)],
        ),
        (
            UniCase::ascii("manicheans"),
            &[(0b00001, &ENTRY_MANICHEANS_7059235818280734780)],
        ),
        (
            UniCase::ascii("pelletiser"),
            &[(0b10010, &ENTRY_PELLETIZER_17745386141239426126)],
        ),
        (
            UniCase::ascii("unenamoured"),
            &[(0b11010, &ENTRY_UNENAMORED_8361050364159923006)],
        ),
        (
            UniCase::ascii("unsensualises"),
            &[(0b10010, &ENTRY_UNSENSUALIZES_12397866517645397490)],
        ),
        (
            UniCase::ascii("politicalise"),
            &[(0b10010, &ENTRY_POLITICALIZE_10489182143049842367)],
        ),
        (
            UniCase::ascii("testimonialization"),
            &[(0b01001, &ENTRY_TESTIMONIALIZATION_1997898483350721704)],
        ),
        (
            UniCase::ascii("anathematised"),
            &[(0b10010, &ENTRY_ANATHEMATIZED_3874188261925704186)],
        ),
        (
            UniCase::ascii("panegyrising"),
            &[(0b10010, &ENTRY_PANEGYRIZING_8733146786926436047)],
        ),
        (
            UniCase::ascii("aerometer"),
            &[(0b00001, &ENTRY_AEROMETER_11742833131164166928)],
        ),
        (
            UniCase::ascii("laevolactic"),
            &[(0b11010, &ENTRY_LEVOLACTIC_9857925753879522136)],
        ),
        (
            UniCase::ascii("mathematize"),
            &[(0b01001, &ENTRY_MATHEMATIZE_15749632280370319229)],
        ),
        (
            UniCase::ascii("intime"),
            &[(0b00001, &ENTRY_INTIME_16056492823113439440)],
        ),
        (
            UniCase::ascii("reoxidised"),
            &[(0b10010, &ENTRY_REOXIDIZED_13705047693863706297)],
        ),
        (
            UniCase::ascii("sepulchred"),
            &[(0b11010, &ENTRY_SEPULCHERED_13156739439863668198)],
        ),
        (
            UniCase::ascii("depolarisers"),
            &[(0b10010, &ENTRY_DEPOLARIZERS_17405526508830397920)],
        ),
        (
            UniCase::ascii("harvardises"),
            &[(0b10010, &ENTRY_HARVARDIZES_15120540188589580097)],
        ),
        (
            UniCase::ascii("vernacularise"),
            &[(0b10010, &ENTRY_VERNACULARIZE_12667767946887279081)],
        ),
        (
            UniCase::ascii("preoffence"),
            &[(0b11010, &ENTRY_PREOFFENSE_11630042685186486975)],
        ),
        (
            UniCase::ascii("epenetic"),
            &[(0b00001, &ENTRY_EPENETIC_4078091931289223174)],
        ),
        (
            UniCase::ascii("dishumored"),
            &[(0b11001, &ENTRY_DISHUMORED_2383879622247462959)],
        ),
        (
            UniCase::ascii("capsulised"),
            &[(0b10010, &ENTRY_CAPSULIZED_14587057948214962939)],
        ),
        (
            UniCase::ascii("corve"),
            &[(0b00001, &ENTRY_CORVE_15600376709730904093)],
        ),
        (
            UniCase::ascii("nebulisations"),
            &[(0b10010, &ENTRY_NEBULIZATIONS_14508912644751833294)],
        ),
        (
            UniCase::ascii("porcelainizations"),
            &[(0b01001, &ENTRY_PORCELAINIZATIONS_14201569580189820572)],
        ),
        (
            UniCase::ascii("unnaturalisables"),
            &[(0b10010, &ENTRY_UNNATURALIZABLES_15331368327954336002)],
        ),
        (
            UniCase::ascii("personisations"),
            &[(0b10010, &ENTRY_PERSONIZATIONS_2363579352700768230)],
        ),
        (
            UniCase::ascii("colourama"),
            &[(0b11010, &ENTRY_COLORAMA_10946100748903023597)],
        ),
        (
            UniCase::ascii("oxygenisables"),
            &[(0b10010, &ENTRY_OXYGENIZABLES_4594746039702721234)],
        ),
        (
            UniCase::ascii("moralizinglies"),
            &[(0b01001, &ENTRY_MORALIZINGLIES_10462617487774496885)],
        ),
        (
            UniCase::ascii("palaeoclimatologist"),
            &[(0b11010, &ENTRY_PALEOCLIMATOLOGIST_6598866277215835335)],
        ),
        (
            UniCase::ascii("mitering"),
            &[(0b00001, &ENTRY_MITERING_4790682826218652875)],
        ),
        (
            UniCase::ascii("overdramatising"),
            &[(0b10010, &ENTRY_OVERDRAMATIZING_14402358516227867882)],
        ),
        (
            UniCase::ascii("kinaesthetics"),
            &[(0b11010, &ENTRY_KINESTHETICS_246684268615617993)],
        ),
        (
            UniCase::ascii("misprizal"),
            &[(0b01001, &ENTRY_MISPRIZAL_9950323538351898149)],
        ),
        (
            UniCase::ascii("nickeling"),
            &[(0b00001, &ENTRY_NICKELING_16355800754604695372)],
        ),
        (
            UniCase::ascii("macrander"),
            &[(0b00001, &ENTRY_MACRANDER_9929126881067356727)],
        ),
        (
            UniCase::ascii("decriminalized"),
            &[(0b01001, &ENTRY_DECRIMINALIZED_14857350688716779167)],
        ),
        (
            UniCase::ascii("outhumoured"),
            &[(0b11010, &ENTRY_OUTHUMORED_5540858708658054473)],
        ),
        (
            UniCase::ascii("thymectomize"),
            &[(0b01001, &ENTRY_THYMECTOMIZE_9188848309665571694)],
        ),
        (
            UniCase::ascii("archeologies"),
            &[(0b11001, &ENTRY_ARCHAEOLOGIES_14568028250477257186)],
        ),
        (
            UniCase::ascii("signalled"),
            &[(0b11010, &ENTRY_SIGNALED_4517098988465661597)],
        ),
        (
            UniCase::ascii("pinnulae"),
            &[(0b11010, &ENTRY_PINNULE_585935578756924342)],
        ),
        (
            UniCase::ascii("impactionises"),
            &[(0b10010, &ENTRY_IMPACTIONIZES_426122654023138033)],
        ),
        (
            UniCase::ascii("nonimmunizeds"),
            &[(0b01001, &ENTRY_NONIMMUNIZEDS_17055826925642342411)],
        ),
        (
            UniCase::ascii("unalcoholized"),
            &[(0b01001, &ENTRY_UNALCOHOLIZED_12462545574552694750)],
        ),
        (
            UniCase::ascii("scepter"),
            &[(0b00001, &ENTRY_SCEPTER_2634314741124349621)],
        ),
        (
            UniCase::ascii("ungeneralizedder"),
            &[(0b01001, &ENTRY_UNGENERALIZEDDER_9404932562611412518)],
        ),
        (
            UniCase::ascii("unsummariseddest"),
            &[(0b10010, &ENTRY_UNSUMMARIZEDDEST_13958313582918609397)],
        ),
        (
            UniCase::ascii("diestruses"),
            &[(0b10001, &ENTRY_DIESTRUSES_551696630438157478)],
        ),
        (
            UniCase::ascii("poetling"),
            &[(0b11010, &ENTRY_PETLING_4679867327279057417)],
        ),
        (
            UniCase::ascii("tricolour"),
            &[(0b11010, &ENTRY_TRICOLOR_29934386578088381)],
        ),
        (
            UniCase::ascii("sacralized"),
            &[(0b01001, &ENTRY_SACRALIZED_9465526025728376412)],
        ),
        (
            UniCase::ascii("etymologisable"),
            &[(0b10010, &ENTRY_ETYMOLOGIZABLE_14324009501183818334)],
        ),
        (
            UniCase::ascii("genteelising"),
            &[(0b10010, &ENTRY_GENTEELIZING_2357828715581131859)],
        ),
        (
            UniCase::ascii("sulfuric"),
            &[(0b11001, &ENTRY_SULFURIC_1017009640623214170)],
        ),
        (
            UniCase::ascii("zoeae"),
            &[(0b00001, &ENTRY_ZOEAE_16777813522281751943)],
        ),
        (
            UniCase::ascii("chemicalizations"),
            &[(0b01001, &ENTRY_CHEMICALIZATIONS_17250488376229572482)],
        ),
        (
            UniCase::ascii("parasitization"),
            &[(0b01001, &ENTRY_PARASITIZATION_14820584356162257753)],
        ),
        (
            UniCase::ascii("tartarized"),
            &[(0b01001, &ENTRY_TARTARIZED_531821600819631957)],
        ),
        (
            UniCase::ascii("areostyle"),
            &[(0b10001, &ENTRY_AREOSTYLE_9887341032000748494)],
        ),
        (
            UniCase::ascii("standardize"),
            &[(0b01001, &ENTRY_STANDARDIZE_13224353253220214220)],
        ),
        (
            UniCase::ascii("fractionisation"),
            &[(0b10010, &ENTRY_FRACTIONIZATION_15598581478527181020)],
        ),
        (
            UniCase::ascii("septicoloured"),
            &[(0b11010, &ENTRY_SEPTICOLORED_5211825597090733015)],
        ),
        (
            UniCase::ascii("graphitize"),
            &[(0b01001, &ENTRY_GRAPHITIZE_9940023022042490384)],
        ),
        (
            UniCase::ascii("heraldize"),
            &[(0b01001, &ENTRY_HERALDIZE_13245151934087390658)],
        ),
        (
            UniCase::ascii("triangularize"),
            &[(0b01001, &ENTRY_TRIANGULARIZE_6075796262826371207)],
        ),
        (
            UniCase::ascii("undercapitalized"),
            &[(0b01001, &ENTRY_UNDERCAPITALIZED_4628390293054794377)],
        ),
        (
            UniCase::ascii("solemnize"),
            &[(0b01001, &ENTRY_SOLEMNIZE_15796782944155668670)],
        ),
        (
            UniCase::ascii("alveolae"),
            &[(0b11010, &ENTRY_ALVEOLE_16490342143918785702)],
        ),
        (
            UniCase::ascii("potentialisations"),
            &[(0b10010, &ENTRY_POTENTIALIZATIONS_16123270987906203275)],
        ),
        (
            UniCase::ascii("denationalize"),
            &[(0b01001, &ENTRY_DENATIONALIZE_10800464833245961489)],
        ),
        (
            UniCase::ascii("romanisation"),
            &[(0b10010, &ENTRY_ROMANIZATION_1812649176047396288)],
        ),
        (
            UniCase::ascii("hybridisable"),
            &[(0b10010, &ENTRY_HYBRIDIZABLE_10574109574999308410)],
        ),
        (
            UniCase::ascii("anemics"),
            &[(0b11001, &ENTRY_ANEMICS_9964370762426059120)],
        ),
        (
            UniCase::ascii("piscinae"),
            &[(0b11010, &ENTRY_PISCINE_5027149564915569308)],
        ),
        (
            UniCase::ascii("columnization"),
            &[(0b01001, &ENTRY_COLUMNIZATION_11878276873729118026)],
        ),
        (
            UniCase::ascii("ichneumonizeds"),
            &[(0b01001, &ENTRY_ICHNEUMONIZEDS_16408019083414202849)],
        ),
        (
            UniCase::ascii("nonvisualised"),
            &[(0b10010, &ENTRY_NONVISUALIZED_6861453340497684108)],
        ),
        (
            UniCase::ascii("standardiser"),
            &[(0b10010, &ENTRY_STANDARDIZER_10177388752556810926)],
        ),
        (
            UniCase::ascii("unsavoriness"),
            &[(0b00001, &ENTRY_UNSAVORINESS_16734401353949800250)],
        ),
        (
            UniCase::ascii("formulized"),
            &[(0b01001, &ENTRY_FORMULIZED_15428824740043784891)],
        ),
        (
            UniCase::ascii("unvaporizeds"),
            &[(0b01001, &ENTRY_UNVAPORIZEDS_986543555659572827)],
        ),
        (
            UniCase::ascii("recoloration"),
            &[(0b00001, &ENTRY_RECOLORATION_284267020047489567)],
        ),
        (
            UniCase::ascii("reemphasized"),
            &[(0b01001, &ENTRY_REEMPHASIZED_12384916709213775729)],
        ),
        (
            UniCase::ascii("nonflavoured"),
            &[(0b11010, &ENTRY_NONFLAVORED_13086896565836313808)],
        ),
        (
            UniCase::ascii("uncoloredlier"),
            &[(0b00001, &ENTRY_UNCOLOREDLIER_6703103262670401501)],
        ),
        (
            UniCase::ascii("undefence"),
            &[(0b11010, &ENTRY_UNDEFENSE_1506818606399848606)],
        ),
        (
            UniCase::ascii("untartarizeds"),
            &[(0b01001, &ENTRY_UNTARTARIZEDS_2508207556036622208)],
        ),
        (
            UniCase::ascii("disutilizes"),
            &[(0b01001, &ENTRY_DISUTILIZES_8581123670870213073)],
        ),
        (
            UniCase::ascii("monopolise"),
            &[(0b10010, &ENTRY_MONOPOLIZE_8487708636905491508)],
        ),
        (
            UniCase::ascii("europeanising"),
            &[(0b10010, &ENTRY_EUROPEANIZING_17501868806425018896)],
        ),
        (
            UniCase::ascii("nongalvaniseds"),
            &[(0b10010, &ENTRY_NONGALVANIZEDS_3586524971953185452)],
        ),
        (
            UniCase::ascii("alkalise"),
            &[(0b10010, &ENTRY_ALKALIZE_5536262726734715214)],
        ),
        (
            UniCase::ascii("homoeomorphy"),
            &[(0b11010, &ENTRY_HOMEOMORPHY_8107825719716227576)],
        ),
        (
            UniCase::ascii("anemicer"),
            &[(0b11001, &ENTRY_ANEMICER_16024076703657819532)],
        ),
        (
            UniCase::ascii("diplomatising"),
            &[(0b10010, &ENTRY_DIPLOMATIZING_10466832182528029316)],
        ),
        (
            UniCase::ascii("dramatizables"),
            &[(0b01001, &ENTRY_DRAMATIZABLES_12929019439166166978)],
        ),
        (
            UniCase::ascii("hypostatisation"),
            &[(0b10010, &ENTRY_HYPOSTATIZATION_3087117275369319820)],
        ),
        (
            UniCase::ascii("tittupy"),
            &[(0b00001, &ENTRY_TITTUPY_1440027282222835899)],
        ),
        (
            UniCase::ascii("kinaestheticer"),
            &[(0b11010, &ENTRY_KINESTHETICER_1776286349748412373)],
        ),
        (
            UniCase::ascii("mesmerizers"),
            &[(0b01001, &ENTRY_MESMERIZERS_2175164108172756867)],
        ),
        (
            UniCase::ascii("geometrisations"),
            &[(0b10010, &ENTRY_GEOMETRIZATIONS_5268337436538042853)],
        ),
        (
            UniCase::ascii("idolatrised"),
            &[(0b10010, &ENTRY_IDOLATRIZED_13594082497249773073)],
        ),
        (
            UniCase::ascii("potentising"),
            &[(0b10010, &ENTRY_POTENTIZING_10663920911074862748)],
        ),
        (
            UniCase::ascii("dealcoholises"),
            &[(0b10010, &ENTRY_DEALCOHOLIZES_8191413688823277724)],
        ),
        (
            UniCase::ascii("laboress"),
            &[(0b11001, &ENTRY_LABORESS_5168896427468795263)],
        ),
        (
            UniCase::ascii("colorization"),
            &[(0b00001, &ENTRY_COLORIZATION_8112190634064658436)],
        ),
        (
            UniCase::ascii("recolorations"),
            &[(0b00001, &ENTRY_RECOLORATIONS_4889262529781127619)],
        ),
        (
            UniCase::ascii("unsentimentalise"),
            &[(0b10010, &ENTRY_UNSENTIMENTALIZE_5597748571008194983)],
        ),
        (
            UniCase::ascii("anesthetic"),
            &[(0b11001, &ENTRY_ANESTHETIC_7346810397925011981)],
        ),
        (
            UniCase::ascii("diphthongised"),
            &[(0b10010, &ENTRY_DIPHTHONGIZED_7607687267591459487)],
        ),
        (
            UniCase::ascii("unvulcanized"),
            &[(0b01001, &ENTRY_UNVULCANIZED_8687515356006252413)],
        ),
        (
            UniCase::ascii("laborhoods"),
            &[(0b11001, &ENTRY_LABORHOODS_4554219923160158770)],
        ),
        (
            UniCase::ascii("anaesthetizes"),
            &[(0b01000, &ENTRY_ANESTHETIZES_6149697878942963698)],
        ),
        (
            UniCase::ascii("coenamourment"),
            &[(0b11010, &ENTRY_COENAMORMENT_10116172708022357030)],
        ),
        (
            UniCase::ascii("inferiorises"),
            &[(0b10010, &ENTRY_INFERIORIZES_13851169502462205708)],
        ),
        (
            UniCase::ascii("spirochetotic"),
            &[(0b00001, &ENTRY_SPIROCHETOTIC_8684207899956468554)],
        ),
        (
            UniCase::ascii("sericitisations"),
            &[(0b10010, &ENTRY_SERICITIZATIONS_3976668030061776680)],
        ),
        (
            UniCase::ascii("cauterizes"),
            &[(0b01001, &ENTRY_CAUTERIZES_10593916877351446728)],
        ),
        (
            UniCase::ascii("esculapian"),
            &[(0b00001, &ENTRY_ESCULAPIAN_490183703265219666)],
        ),
        (
            UniCase::ascii("unappetisingest"),
            &[(0b10010, &ENTRY_UNAPPETIZINGEST_15811327206418622113)],
        ),
        (
            UniCase::ascii("ventriloquises"),
            &[(0b10010, &ENTRY_VENTRILOQUIZES_7366719022132000191)],
        ),
        (
            UniCase::ascii("quarreled"),
            &[(0b00001, &ENTRY_QUARRELED_5653253897786374680)],
        ),
        (
            UniCase::ascii("episcopalianise"),
            &[(0b10010, &ENTRY_EPISCOPALIANIZE_13601906048877534433)],
        ),
        (
            UniCase::ascii("microminiaturization"),
            &[(0b01001, &ENTRY_MICROMINIATURIZATION_5346373952330274164)],
        ),
        (
            UniCase::ascii("unmethodizing"),
            &[(0b01001, &ENTRY_UNMETHODIZING_4738341700288635217)],
        ),
        (
            UniCase::ascii("senilises"),
            &[(0b10010, &ENTRY_SENILIZES_12383752921132409565)],
        ),
        (
            UniCase::ascii("eudaemons"),
            &[(0b11010, &ENTRY_EUDEMONS_619440478160622096)],
        ),
        (
            UniCase::ascii("lyricises"),
            &[(0b10010, &ENTRY_LYRICIZES_1087674100771642847)],
        ),
        (
            UniCase::ascii("unmesmerisedder"),
            &[(0b10010, &ENTRY_UNMESMERIZEDDER_2203744214809621680)],
        ),
        (
            UniCase::ascii("unacclimatized"),
            &[(0b01001, &ENTRY_UNACCLIMATIZED_1969571864517774602)],
        ),
        (
            UniCase::ascii("demonization"),
            &[(0b01001, &ENTRY_DEMONIZATION_16933975817485552160)],
        ),
        (
            UniCase::ascii("appetizer"),
            &[(0b01001, &ENTRY_APPETIZER_5123269697918809384)],
        ),
        (
            UniCase::ascii("hemochromatosis"),
            &[(0b10001, &ENTRY_HEMOCHROMATOSIS_2585842551183947470)],
        ),
        (
            UniCase::ascii("tumoured"),
            &[(0b11010, &ENTRY_TUMORED_9530760269255205454)],
        ),
        (
            UniCase::ascii("decimalisation"),
            &[(0b10010, &ENTRY_DECIMALIZATION_6996195191656110298)],
        ),
        (
            UniCase::ascii("keratinises"),
            &[(0b10010, &ENTRY_KERATINIZES_14523171164749310546)],
        ),
        (
            UniCase::ascii("ploughing"),
            &[(0b11010, &ENTRY_PLOWING_16570546940479665223)],
        ),
        (
            UniCase::ascii("cize"),
            &[(0b01001, &ENTRY_CIZE_6818406889408576007)],
        ),
        (
            UniCase::ascii("pericenter"),
            &[(0b00001, &ENTRY_PERICENTER_10108739404975251919)],
        ),
        (
            UniCase::ascii("giantize"),
            &[(0b01001, &ENTRY_GIANTIZE_9114588567776629038)],
        ),
        (
            UniCase::ascii("decolourized"),
            &[(0b01000, &ENTRY_DECOLORIZED_17864546395597600300)],
        ),
        (
            UniCase::ascii("nonphosphorized"),
            &[(0b01001, &ENTRY_NONPHOSPHORIZED_3297546196819705879)],
        ),
        (
            UniCase::ascii("singularize"),
            &[(0b01001, &ENTRY_SINGULARIZE_12969745354704340141)],
        ),
        (
            UniCase::ascii("asafoetidas"),
            &[(0b11010, &ENTRY_ASAFETIDAS_3146529801559413940)],
        ),
        (
            UniCase::ascii("hispaniolized"),
            &[(0b01001, &ENTRY_HISPANIOLIZED_17603705847587336285)],
        ),
        (
            UniCase::ascii("ervalentas"),
            &[(0b00001, &ENTRY_ERVALENTAS_18174157063570728071)],
        ),
        (
            UniCase::ascii("characterizer"),
            &[(0b01001, &ENTRY_CHARACTERIZER_14416082234464511775)],
        ),
        (
            UniCase::ascii("turkises"),
            &[(0b10010, &ENTRY_TURKIZES_3728749434026795951)],
        ),
        (
            UniCase::ascii("hyperbolised"),
            &[(0b10010, &ENTRY_HYPERBOLIZED_411978819565944419)],
        ),
        (
            UniCase::ascii("rhetorized"),
            &[(0b01001, &ENTRY_RHETORIZED_12036770468694769802)],
        ),
        (
            UniCase::ascii("oophorectomising"),
            &[(0b10010, &ENTRY_OOPHORECTOMIZING_6744915085700528874)],
        ),
        (
            UniCase::ascii("psalmodises"),
            &[(0b10010, &ENTRY_PSALMODIZES_313135324604902888)],
        ),
        (
            UniCase::ascii("traumatise"),
            &[(0b10010, &ENTRY_TRAUMATIZE_8649856127609129608)],
        ),
        (
            UniCase::ascii("keratinisations"),
            &[(0b10010, &ENTRY_KERATINIZATIONS_4745190074411978728)],
        ),
        (
            UniCase::ascii("carbonizers"),
            &[(0b01001, &ENTRY_CARBONIZERS_13712244721486829214)],
        ),
        (
            UniCase::ascii("unharmonized"),
            &[(0b01001, &ENTRY_UNHARMONIZED_3681921261857978250)],
        ),
        (
            UniCase::ascii("chequing"),
            &[(0b11010, &ENTRY_CHECKING_12030083975828633786)],
        ),
        (
            UniCase::ascii("sovietise"),
            &[(0b10010, &ENTRY_SOVIETIZE_15802906407586023669)],
        ),
        (
            UniCase::ascii("nonvulcanisable"),
            &[(0b10010, &ENTRY_NONVULCANIZABLE_12072046253771095022)],
        ),
        (
            UniCase::ascii("pouders"),
            &[(0b00001, &ENTRY_POUDERS_8848899925700000053)],
        ),
        (
            UniCase::ascii("sodomise"),
            &[(0b10010, &ENTRY_SODOMIZE_6206294818202684654)],
        ),
        (
            UniCase::ascii("flavorlesses"),
            &[(0b11001, &ENTRY_FLAVORLESSES_6887571633548882211)],
        ),
        (
            UniCase::ascii("hydrolyse"),
            &[(0b11010, &ENTRY_HYDROLYZE_14713911854595051121)],
        ),
        (
            UniCase::ascii("latinizing"),
            &[(0b01001, &ENTRY_LATINIZING_2597326847289767095)],
        ),
        (
            UniCase::ascii("itemizing"),
            &[(0b01001, &ENTRY_ITEMIZING_1853557894573485171)],
        ),
        (
            UniCase::ascii("nationaliser"),
            &[(0b10010, &ENTRY_NATIONALIZER_456791214714633888)],
        ),
        (
            UniCase::ascii("dishonorer"),
            &[(0b11001, &ENTRY_DISHONORER_11600072711097852356)],
        ),
        (
            UniCase::ascii("departmentalizations"),
            &[(0b01001, &ENTRY_DEPARTMENTALIZATIONS_13030339549069230554)],
        ),
        (
            UniCase::ascii("territorializes"),
            &[(0b01001, &ENTRY_TERRITORIALIZES_8896187296510093610)],
        ),
        (
            UniCase::ascii("gallicisations"),
            &[(0b10010, &ENTRY_GALLICIZATIONS_12711889075161842819)],
        ),
        (
            UniCase::ascii("sord"),
            &[(0b00001, &ENTRY_SORD_16682875115764427041)],
        ),
        (
            UniCase::ascii("satellitises"),
            &[(0b10010, &ENTRY_SATELLITIZES_15756736520028846542)],
        ),
        (
            UniCase::ascii("criminalised"),
            &[(0b10010, &ENTRY_CRIMINALIZED_11203535063879460381)],
        ),
        (
            UniCase::ascii("overcapitalisations"),
            &[(0b10010, &ENTRY_OVERCAPITALIZATIONS_9484255788644671052)],
        ),
        (
            UniCase::ascii("enamellist"),
            &[(0b11010, &ENTRY_ENAMELIST_6556021724769945893)],
        ),
        (
            UniCase::ascii("sepulchers"),
            &[(0b00001, &ENTRY_SEPULCHERS_17907839135565596907)],
        ),
        (
            UniCase::ascii("draftsman"),
            &[(0b01001, &ENTRY_DRAFTSMAN_2158426515502784003)],
        ),
        (
            UniCase::ascii("cutinise"),
            &[(0b10010, &ENTRY_CUTINIZE_17770128684096533482)],
        ),
        (
            UniCase::ascii("incentivizes"),
            &[(0b01001, &ENTRY_INCENTIVIZES_16584149161391523509)],
        ),
        (
            UniCase::ascii("relabeling"),
            &[(0b00001, &ENTRY_RELABELING_17510567259263942187)],
        ),
        (
            UniCase::ascii("disorganisers"),
            &[(0b10010, &ENTRY_DISORGANIZERS_3700614044173779869)],
        ),
        (
            UniCase::ascii("nonionising"),
            &[(0b10010, &ENTRY_NONIONIZING_13410823671297408563)],
        ),
        (
            UniCase::ascii("insurrectionizing"),
            &[(0b01001, &ENTRY_INSURRECTIONIZING_9230576022597150453)],
        ),
        (
            UniCase::ascii("familiarisingly"),
            &[(0b10010, &ENTRY_FAMILIARIZINGLY_17102975447523114031)],
        ),
        (
            UniCase::ascii("poeticises"),
            &[(0b10010, &ENTRY_POETICIZES_14806750979505922739)],
        ),
        (
            UniCase::ascii("cocainizations"),
            &[(0b01001, &ENTRY_COCAINIZATIONS_3037752219365718178)],
        ),
        (
            UniCase::ascii("unnoncolourablies"),
            &[(0b11010, &ENTRY_UNNONCOLORABLIES_9150435717670160252)],
        ),
        (
            UniCase::ascii("protestantise"),
            &[(0b10010, &ENTRY_PROTESTANTIZE_5849584465690284720)],
        ),
        (
            UniCase::ascii("ravelings"),
            &[(0b01001, &ENTRY_RAVELINGS_4361143677870266413)],
        ),
        (
            UniCase::ascii("recivilizes"),
            &[(0b01001, &ENTRY_RECIVILIZES_13280929754254705028)],
        ),
        (
            UniCase::ascii("remoralises"),
            &[(0b10010, &ENTRY_REMORALIZES_11138700545539530334)],
        ),
        (
            UniCase::ascii("palletizations"),
            &[(0b01001, &ENTRY_PALLETIZATIONS_6464829452261813832)],
        ),
        (
            UniCase::ascii("solubilisations"),
            &[(0b10010, &ENTRY_SOLUBILIZATIONS_4369156796378163009)],
        ),
        (
            UniCase::ascii("subterraneanizes"),
            &[(0b01001, &ENTRY_SUBTERRANEANIZES_11938427088659999116)],
        ),
        (
            UniCase::ascii("rationalising"),
            &[(0b10010, &ENTRY_RATIONALIZING_2753577106103404272)],
        ),
        (
            UniCase::ascii("etymologises"),
            &[(0b10010, &ENTRY_ETYMOLOGIZES_18258268798885199036)],
        ),
        (
            UniCase::ascii("preauthorize"),
            &[(0b01001, &ENTRY_PREAUTHORIZE_15918741156332951414)],
        ),
        (
            UniCase::ascii("leuchaemia"),
            &[(0b11010, &ENTRY_LEUCHEMIA_17930526525127388484)],
        ),
        (
            UniCase::ascii("nicotinize"),
            &[(0b01001, &ENTRY_NICOTINIZE_3100679005969423604)],
        ),
        (
            UniCase::ascii("vestryise"),
            &[(0b10010, &ENTRY_VESTRYIZE_2427050586639943215)],
        ),
        (
            UniCase::ascii("supersulphurises"),
            &[(0b10010, &ENTRY_SUPERSULPHURIZES_1086828648943519821)],
        ),
        (
            UniCase::ascii("unpracticed"),
            &[(0b01001, &ENTRY_UNPRACTICED_9353245174446259318)],
        ),
        (
            UniCase::ascii("collectivisations"),
            &[(0b10010, &ENTRY_COLLECTIVIZATIONS_6853316050939234055)],
        ),
        (
            UniCase::ascii("travellers"),
            &[(0b11010, &ENTRY_TRAVELERS_534480827925386728)],
        ),
        (
            UniCase::ascii("paralysers"),
            &[(0b11010, &ENTRY_PARALYZERS_16689764779974601608)],
        ),
        (
            UniCase::ascii("photolyzable"),
            &[(0b00001, &ENTRY_PHOTOLYZABLE_1307676699359278891)],
        ),
        (
            UniCase::ascii("pullmanizes"),
            &[(0b01001, &ENTRY_PULLMANIZES_15655484632672360202)],
        ),
        (
            UniCase::ascii("mineralizations"),
            &[(0b01001, &ENTRY_MINERALIZATIONS_12229839998070627902)],
        ),
        (
            UniCase::ascii("federalizes"),
            &[(0b01001, &ENTRY_FEDERALIZES_2587577566789708184)],
        ),
        (
            UniCase::ascii("fetiparous"),
            &[(0b00001, &ENTRY_FETIPAROUS_7738738846683585946)],
        ),
        (
            UniCase::ascii("moldering"),
            &[(0b10001, &ENTRY_MOLDERING_761432945987723341)],
        ),
        (
            UniCase::ascii("hetaeric"),
            &[(0b11010, &ENTRY_HETERIC_14927082686103953595)],
        ),
        (
            UniCase::ascii("paraffinize"),
            &[(0b01001, &ENTRY_PARAFFINIZE_10242502814954171305)],
        ),
        (
            UniCase::ascii("photoesthetic"),
            &[(0b00001, &ENTRY_PHOTOESTHETIC_6617324081715374387)],
        ),
        (
            UniCase::ascii("quakerises"),
            &[(0b10010, &ENTRY_QUAKERIZES_6225644625493387619)],
        ),
        (
            UniCase::ascii("ultrahonourables"),
            &[(0b11010, &ENTRY_ULTRAHONORABLES_9342789915681610564)],
        ),
        (
            UniCase::ascii("extemporizing"),
            &[(0b01001, &ENTRY_EXTEMPORIZING_10937023320075355586)],
        ),
        (
            UniCase::ascii("customiser"),
            &[(0b10010, &ENTRY_CUSTOMIZER_10903429132081239237)],
        ),
        (
            UniCase::ascii("immaterialization"),
            &[(0b01001, &ENTRY_IMMATERIALIZATION_6031031436477619826)],
        ),
        (
            UniCase::ascii("decolourization"),
            &[(0b01000, &ENTRY_DECOLORIZATION_9440321833606051398)],
        ),
        (
            UniCase::ascii("mycohaemia"),
            &[(0b11010, &ENTRY_MYCOHEMIA_14011500395634142073)],
        ),
        (
            UniCase::ascii("rapturizes"),
            &[(0b01001, &ENTRY_RAPTURIZES_3958786363790102011)],
        ),
        (
            UniCase::ascii("aemules"),
            &[(0b11010, &ENTRY_EMULES_6796003945794582963)],
        ),
        (
            UniCase::ascii("nanogrammes"),
            &[(0b10010, &ENTRY_NANOGRAMS_9429141690600922745)],
        ),
        (
            UniCase::ascii("breathalyzed"),
            &[(0b01001, &ENTRY_BREATHALYZED_10540875853111278249)],
        ),
        (
            UniCase::ascii("hyperciviliseds"),
            &[(0b10010, &ENTRY_HYPERCIVILIZEDS_8179865442803788169)],
        ),
        (
            UniCase::ascii("channelizing"),
            &[(0b01001, &ENTRY_CHANNELIZING_3206328004957832674)],
        ),
        (
            UniCase::ascii("municipalizer"),
            &[(0b01001, &ENTRY_MUNICIPALIZER_5812211793259788814)],
        ),
        (
            UniCase::ascii("midlandizes"),
            &[(0b01001, &ENTRY_MIDLANDIZES_6424533152072180816)],
        ),
        (
            UniCase::ascii("overanalyses"),
            &[(0b10010, &ENTRY_OVERANALYZES_8889145236404032723)],
        ),
        (
            UniCase::ascii("saviourhood"),
            &[(0b11010, &ENTRY_SAVIORHOOD_2729791171284683689)],
        ),
        (
            UniCase::ascii("gemologies"),
            &[(0b01001, &ENTRY_GEMOLOGIES_213255465904446050)],
        ),
        (
            UniCase::ascii("depauperize"),
            &[(0b01001, &ENTRY_DEPAUPERIZE_5573322689772847322)],
        ),
        (
            UniCase::ascii("priorized"),
            &[(0b01001, &ENTRY_PRIORIZED_986408301813837211)],
        ),
        (
            UniCase::ascii("totalized"),
            &[(0b01001, &ENTRY_TOTALIZED_13767793031901840125)],
        ),
        (
            UniCase::ascii("unorganisabler"),
            &[(0b10010, &ENTRY_UNORGANIZABLER_2651332250209161850)],
        ),
        (
            UniCase::ascii("sparres"),
            &[(0b11010, &ENTRY_SPARERS_12651957075913392459)],
        ),
        (
            UniCase::ascii("psalmodized"),
            &[(0b01001, &ENTRY_PSALMODIZED_9886224417033316783)],
        ),
        (
            UniCase::ascii("soultre"),
            &[(0b11010, &ENTRY_SOULTER_16287779215263702830)],
        ),
        (
            UniCase::ascii("winterises"),
            &[(0b10010, &ENTRY_WINTERIZES_158574474219766318)],
        ),
        (
            UniCase::ascii("cantaloups"),
            &[(0b01001, &ENTRY_CANTALOUPES_10789009086995967817)],
        ),
        (
            UniCase::ascii("darwinise"),
            &[(0b10010, &ENTRY_DARWINIZE_17708644917698913001)],
        ),
        (
            UniCase::ascii("downdraft"),
            &[(0b01001, &ENTRY_DOWNDRAFT_9039488072887961853)],
        ),
        (
            UniCase::ascii("stenopaeic"),
            &[(0b11010, &ENTRY_STENOPEIC_9668625572592229054)],
        ),
        (
            UniCase::ascii("demonised"),
            &[(0b10010, &ENTRY_DEMONIZED_12813528693273757543)],
        ),
        (
            UniCase::ascii("individualiser"),
            &[(0b10010, &ENTRY_INDIVIDUALIZER_4182762615893522554)],
        ),
        (
            UniCase::ascii("undramatizeds"),
            &[(0b01001, &ENTRY_UNDRAMATIZEDS_12222872129614232202)],
        ),
        (
            UniCase::ascii("ghettoized"),
            &[(0b01001, &ENTRY_GHETTOIZED_6310643312381201018)],
        ),
        (
            UniCase::ascii("appall"),
            &[(0b11001, &ENTRY_APPALL_8105666145197803720)],
        ),
        (
            UniCase::ascii("behaviouraler"),
            &[(0b11010, &ENTRY_BEHAVIORALER_6184370577289856922)],
        ),
        (
            UniCase::ascii("unmunicipalizedder"),
            &[(0b01001, &ENTRY_UNMUNICIPALIZEDDER_308188906530115010)],
        ),
        (
            UniCase::ascii("collectivizations"),
            &[(0b01001, &ENTRY_COLLECTIVIZATIONS_6853316050939234055)],
        ),
        (
            UniCase::ascii("gluttonize"),
            &[(0b01001, &ENTRY_GLUTTONIZE_10450449431254721690)],
        ),
        (
            UniCase::ascii("oophorectomize"),
            &[(0b01001, &ENTRY_OOPHORECTOMIZE_6120142783855584835)],
        ),
        (
            UniCase::ascii("alternises"),
            &[(0b10010, &ENTRY_ALTERNIZES_9696050258020074609)],
        ),
        (
            UniCase::ascii("nongelatinisings"),
            &[(0b10010, &ENTRY_NONGELATINIZINGS_14282185464661271575)],
        ),
        (
            UniCase::ascii("optimiser"),
            &[(0b10010, &ENTRY_OPTIMIZER_520050784414587313)],
        ),
        (
            UniCase::ascii("ploughshares"),
            &[(0b11010, &ENTRY_PLOWSHARES_10499526776608850484)],
        ),
        (
            UniCase::ascii("fabulized"),
            &[(0b01001, &ENTRY_FABULIZED_7556454061259147422)],
        ),
        (
            UniCase::ascii("haemorrhoidectomy"),
            &[(0b11010, &ENTRY_HEMORRHOIDECTOMY_14512378041008423124)],
        ),
        (
            UniCase::ascii("apostrophize"),
            &[(0b01001, &ENTRY_APOSTROPHIZE_6169660213182266890)],
        ),
        (
            UniCase::ascii("furculae"),
            &[(0b11010, &ENTRY_FURCULE_1236868035751287961)],
        ),
        (
            UniCase::ascii("catechizable"),
            &[(0b01001, &ENTRY_CATECHIZABLE_8282651021901386912)],
        ),
        (
            UniCase::ascii("expertised"),
            &[(0b10010, &ENTRY_EXPERTIZED_9523121825282850630)],
        ),
        (
            UniCase::ascii("congregationalise"),
            &[(0b10010, &ENTRY_CONGREGATIONALIZE_9819463413052527180)],
        ),
        (
            UniCase::ascii("nonanaesthetised"),
            &[(0b10010, &ENTRY_NONANESTHETIZED_12181903245888735253)],
        ),
        (
            UniCase::ascii("patronisingly"),
            &[(0b10010, &ENTRY_PATRONIZINGLY_1677195389459576502)],
        ),
        (
            UniCase::ascii("smidges"),
            &[(0b01001, &ENTRY_SMIDGENS_5145607016666105466)],
        ),
        (
            UniCase::ascii("effectualizes"),
            &[(0b01001, &ENTRY_EFFECTUALIZES_5750997542764404732)],
        ),
        (
            UniCase::ascii("epicele"),
            &[(0b00001, &ENTRY_EPICELE_12455055708908810351)],
        ),
        (
            UniCase::ascii("ensepulcher"),
            &[(0b00001, &ENTRY_ENSEPULCHER_18433050111369773849)],
        ),
        (
            UniCase::ascii("moult"),
            &[(0b11010, &ENTRY_MOLT_13673484917001179046)],
        ),
        (
            UniCase::ascii("neopaganizing"),
            &[(0b01001, &ENTRY_NEOPAGANIZING_13517084271492557770)],
        ),
        (
            UniCase::ascii("fractionalised"),
            &[(0b10010, &ENTRY_FRACTIONALIZED_1638721305897569649)],
        ),
        (
            UniCase::ascii("novelisations"),
            &[(0b10010, &ENTRY_NOVELIZATIONS_10468098323494499586)],
        ),
        (
            UniCase::ascii("sanskritise"),
            &[(0b10010, &ENTRY_SANSKRITIZE_8185278319719381954)],
        ),
        (
            UniCase::ascii("colourcasters"),
            &[(0b11010, &ENTRY_COLORCASTERS_9885877195250711665)],
        ),
        (
            UniCase::ascii("apostrophised"),
            &[(0b10010, &ENTRY_APOSTROPHIZED_10608858047847867957)],
        ),
        (
            UniCase::ascii("unmonopolizes"),
            &[(0b01001, &ENTRY_UNMONOPOLIZES_8604670551607021504)],
        ),
        (
            UniCase::ascii("colourfastness"),
            &[(0b11010, &ENTRY_COLORFASTNESS_3258841464722986607)],
        ),
        (
            UniCase::ascii("acmaesthesia"),
            &[(0b11010, &ENTRY_ACMESTHESIA_7394645664517202151)],
        ),
        (
            UniCase::ascii("oxygenizables"),
            &[(0b01001, &ENTRY_OXYGENIZABLES_4594746039702721234)],
        ),
        (
            UniCase::ascii("medallist"),
            &[(0b11010, &ENTRY_MEDALIST_3813713439469975305)],
        ),
        (
            UniCase::ascii("gynecocrats"),
            &[(0b10001, &ENTRY_GYNECOCRATS_17242768922364343193)],
        ),
        (
            UniCase::ascii("vietnamizes"),
            &[(0b01001, &ENTRY_VIETNAMIZES_8386876976890033192)],
        ),
        (
            UniCase::ascii("hyperchloremia"),
            &[(0b10001, &ENTRY_HYPERCHLOREMIA_7441395776225879415)],
        ),
        (
            UniCase::ascii("terre"),
            &[(0b00001, &ENTRY_TERRE_8819349438187415807)],
        ),
        (
            UniCase::ascii("compartmentize"),
            &[(0b01001, &ENTRY_COMPARTMENTIZE_4090554704802645617)],
        ),
        (
            UniCase::ascii("behavioristics"),
            &[(0b11001, &ENTRY_BEHAVIORISTICS_18376773413500646501)],
        ),
        (
            UniCase::ascii("fraenula"),
            &[(0b11010, &ENTRY_FRENULA_10450628952852883483)],
        ),
        (
            UniCase::ascii("unsatirisedder"),
            &[(0b10010, &ENTRY_UNSATIRIZEDDER_11457550322600274631)],
        ),
        (
            UniCase::ascii("decarboniser"),
            &[(0b10010, &ENTRY_DECARBONIZER_7249394058399586099)],
        ),
        (
            UniCase::ascii("homogenise"),
            &[(0b10010, &ENTRY_HOMOGENIZE_7151746964336550590)],
        ),
        (
            UniCase::ascii("gimbaled"),
            &[(0b00001, &ENTRY_GIMBALED_13438863350515119161)],
        ),
        (
            UniCase::ascii("revaporize"),
            &[(0b01001, &ENTRY_REVAPORIZE_7400570187982142267)],
        ),
        (
            UniCase::ascii("paleophysiography"),
            &[(0b10001, &ENTRY_PALEOPHYSIOGRAPHY_12430780127473103003)],
        ),
        (
            UniCase::ascii("toxemia"),
            &[(0b11001, &ENTRY_TOXEMIA_13728114455609378495)],
        ),
        (
            UniCase::ascii("pyrolyzing"),
            &[(0b01001, &ENTRY_PYROLYZING_11483665575108061827)],
        ),
        (
            UniCase::ascii("portionize"),
            &[(0b01001, &ENTRY_PORTIONIZE_8183616402693368236)],
        ),
        (
            UniCase::ascii("soliloquizer"),
            &[(0b01001, &ENTRY_SOLILOQUIZER_5490319459061869143)],
        ),
        (
            UniCase::ascii("hibernisation"),
            &[(0b10010, &ENTRY_HIBERNIZATION_13137120377558636657)],
        ),
        (
            UniCase::ascii("pencillings"),
            &[(0b11010, &ENTRY_PENCILINGS_819897427661414754)],
        ),
        (
            UniCase::ascii("unfeminising"),
            &[(0b10010, &ENTRY_UNFEMINIZING_16839714662136031968)],
        ),
        (
            UniCase::ascii("regalvanization"),
            &[(0b01001, &ENTRY_REGALVANIZATION_17316748002349190251)],
        ),
        (
            UniCase::ascii("misauthorization"),
            &[(0b01001, &ENTRY_MISAUTHORIZATION_3255527742163937042)],
        ),
        (
            UniCase::ascii("solarisations"),
            &[(0b10010, &ENTRY_SOLARIZATIONS_4722132275104202763)],
        ),
        (
            UniCase::ascii("unevangelized"),
            &[(0b01001, &ENTRY_UNEVANGELIZED_17902646883952932702)],
        ),
        (
            UniCase::ascii("oligocythemia"),
            &[(0b10001, &ENTRY_OLIGOCYTHEMIA_4447810723170322323)],
        ),
        (
            UniCase::ascii("dogmatizing"),
            &[(0b01001, &ENTRY_DOGMATIZING_2447061813414873668)],
        ),
        (
            UniCase::ascii("mesmerise"),
            &[(0b10010, &ENTRY_MESMERIZE_8247464516832987079)],
        ),
        (
            UniCase::ascii("phenologies"),
            &[(0b00001, &ENTRY_PHENOLOGIES_16864158914924322992)],
        ),
        (
            UniCase::ascii("sensitisers"),
            &[(0b10010, &ENTRY_SENSITIZERS_18244790979608274479)],
        ),
        (
            UniCase::ascii("seizable"),
            &[(0b01001, &ENTRY_SEIZABLE_6299895893787769311)],
        ),
        (
            UniCase::ascii("ungospeliseds"),
            &[(0b10010, &ENTRY_UNGOSPELIZEDS_12370376811231680007)],
        ),
        (
            UniCase::ascii("quarterizations"),
            &[(0b01001, &ENTRY_QUARTERIZATIONS_5989124183283298739)],
        ),
        (
            UniCase::ascii("bedlamised"),
            &[(0b10010, &ENTRY_BEDLAMIZED_8070235127373715475)],
        ),
        (
            UniCase::ascii("medalists"),
            &[(0b00001, &ENTRY_MEDALISTS_14543293296180708193)],
        ),
        (
            UniCase::ascii("pressurized"),
            &[(0b01001, &ENTRY_PRESSURIZED_5893734113312881931)],
        ),
        (
            UniCase::ascii("roumania"),
            &[(0b11010, &ENTRY_ROMANIA_14647491915869407300)],
        ),
        (
            UniCase::ascii("shakespearise"),
            &[(0b10010, &ENTRY_SHAKESPEARIZE_6066803341152707552)],
        ),
        (
            UniCase::ascii("pindarize"),
            &[(0b01001, &ENTRY_PINDARIZE_3371672470278825880)],
        ),
        (
            UniCase::ascii("fascistize"),
            &[(0b01001, &ENTRY_FASCISTIZE_11043251862767140703)],
        ),
        (
            UniCase::ascii("kaolinizing"),
            &[(0b01001, &ENTRY_KAOLINIZING_10817594314873964583)],
        ),
        (
            UniCase::ascii("anhematopoiesis"),
            &[(0b10001, &ENTRY_ANHEMATOPOIESIS_17033044080627588200)],
        ),
        (
            UniCase::ascii("jacobinisation"),
            &[(0b10010, &ENTRY_JACOBINIZATION_13248835767295513863)],
        ),
        (
            UniCase::ascii("vitriolized"),
            &[(0b01001, &ENTRY_VITRIOLIZED_726289364433095774)],
        ),
        (
            UniCase::ascii("generalizing"),
            &[(0b01001, &ENTRY_GENERALIZING_14156289456455119636)],
        ),
        (
            UniCase::ascii("hostilizes"),
            &[(0b01001, &ENTRY_HOSTILIZES_4822749923344907441)],
        ),
        (
            UniCase::ascii("tantalisations"),
            &[(0b10010, &ENTRY_TANTALIZATIONS_13771654142203624068)],
        ),
        (
            UniCase::ascii("italicise"),
            &[(0b10010, &ENTRY_ITALICIZE_9105109899179023320)],
        ),
        (
            UniCase::ascii("symbolisers"),
            &[(0b10010, &ENTRY_SYMBOLIZERS_1983691641725453382)],
        ),
        (
            UniCase::ascii("sherardised"),
            &[(0b10010, &ENTRY_SHERARDIZED_3013055586963630691)],
        ),
        (
            UniCase::ascii("faradisation"),
            &[(0b10010, &ENTRY_FARADIZATION_15891788669706277797)],
        ),
        (
            UniCase::ascii("cosiness"),
            &[(0b10010, &ENTRY_COZINESS_4340402800488732549)],
        ),
        (
            UniCase::ascii("capitalisable"),
            &[(0b10010, &ENTRY_CAPITALIZABLE_1765975557696773459)],
        ),
        (
            UniCase::ascii("pulverize"),
            &[(0b01001, &ENTRY_PULVERIZE_4116752745240045211)],
        ),
        (
            UniCase::ascii("revelling"),
            &[(0b11010, &ENTRY_REVELING_7333428498196314928)],
        ),
        (
            UniCase::ascii("multicoloured"),
            &[(0b11010, &ENTRY_MULTICOLORED_1099974154350113974)],
        ),
        (
            UniCase::ascii("extraverted"),
            &[(0b10011, &ENTRY_EXTROVERTED_9249661851858893561)],
        ),
        (
            UniCase::ascii("uncirculariseds"),
            &[(0b10010, &ENTRY_UNCIRCULARIZEDS_1250844431562273063)],
        ),
        (
            UniCase::ascii("nitridizations"),
            &[(0b01001, &ENTRY_NITRIDIZATIONS_14592567393639183415)],
        ),
        (
            UniCase::ascii("sabbatizing"),
            &[(0b01001, &ENTRY_SABBATIZING_12733815021350519705)],
        ),
        (
            UniCase::ascii("unrecognised"),
            &[(0b10010, &ENTRY_UNRECOGNIZED_15339742215625954957)],
        ),
        (
            UniCase::ascii("neopaganize"),
            &[(0b01001, &ENTRY_NEOPAGANIZE_11390513205223371956)],
        ),
        (
            UniCase::ascii("pectisation"),
            &[(0b10010, &ENTRY_PECTIZATION_11254255408733762028)],
        ),
        (
            UniCase::ascii("periodized"),
            &[(0b01001, &ENTRY_PERIODIZED_14494857337622522468)],
        ),
        (
            UniCase::ascii("remonetizes"),
            &[(0b01001, &ENTRY_REMONETIZES_10479599926916307809)],
        ),
        (
            UniCase::ascii("vocalizing"),
            &[(0b01001, &ENTRY_VOCALIZING_6361847323758753459)],
        ),
        (
            UniCase::ascii("colorlessest"),
            &[(0b11001, &ENTRY_COLORLESSEST_2853202552785506979)],
        ),
        (
            UniCase::ascii("colloquialises"),
            &[(0b10010, &ENTRY_COLLOQUIALIZES_11772046900035477346)],
        ),
        (
            UniCase::ascii("gaolbirds"),
            &[(0b11010, &ENTRY_JAILBIRDS_10419139708074863941)],
        ),
        (
            UniCase::ascii("sulphide"),
            &[(0b11010, &ENTRY_SULFIDE_7304142610351212973)],
        ),
        (
            UniCase::ascii("artefact"),
            &[(0b11010, &ENTRY_ARTIFACT_2827424156037909074)],
        ),
        (
            UniCase::ascii("bastardization"),
            &[(0b01001, &ENTRY_BASTARDIZATION_15150400898607735555)],
        ),
        (
            UniCase::ascii("chromatizes"),
            &[(0b01001, &ENTRY_CHROMATIZES_8188945171625541176)],
        ),
        (
            UniCase::ascii("uneulogizedder"),
            &[(0b01001, &ENTRY_UNEULOGIZEDDER_500502998937424952)],
        ),
        (
            UniCase::ascii("fascistisations"),
            &[(0b10010, &ENTRY_FASCISTIZATIONS_3946675109662693253)],
        ),
        (
            UniCase::ascii("puebloisation"),
            &[(0b10010, &ENTRY_PUEBLOIZATION_14471611923776355990)],
        ),
        (
            UniCase::ascii("proselytizer"),
            &[(0b01001, &ENTRY_PROSELYTIZER_16192805406416418559)],
        ),
        (
            UniCase::ascii("lethargize"),
            &[(0b01001, &ENTRY_LETHARGIZE_16053857967216252311)],
        ),
        (
            UniCase::ascii("cottonizes"),
            &[(0b01001, &ENTRY_COTTONIZES_9008427680743356385)],
        ),
        (
            UniCase::ascii("cutinizing"),
            &[(0b01001, &ENTRY_CUTINIZING_17947614786569489277)],
        ),
        (
            UniCase::ascii("anatomized"),
            &[(0b01001, &ENTRY_ANATOMIZED_862561253191916873)],
        ),
        (
            UniCase::ascii("silicidize"),
            &[(0b01001, &ENTRY_SILICIDIZE_7437759950119638805)],
        ),
        (
            UniCase::ascii("pastoralizes"),
            &[(0b01001, &ENTRY_PASTORALIZES_4475797865513749802)],
        ),
        (
            UniCase::ascii("communalization"),
            &[(0b01001, &ENTRY_COMMUNALIZATION_1354902119947113774)],
        ),
        (
            UniCase::ascii("evangelizing"),
            &[(0b01001, &ENTRY_EVANGELIZING_16366309279292917989)],
        ),
        (
            UniCase::ascii("unorganizable"),
            &[(0b01001, &ENTRY_UNORGANIZABLE_11245437451639231261)],
        ),
        (
            UniCase::ascii("ultracentralizer"),
            &[(0b01001, &ENTRY_ULTRACENTRALIZER_1386087884281857470)],
        ),
        (
            UniCase::ascii("sapor"),
            &[(0b00001, &ENTRY_SAPOR_14377617062405537073)],
        ),
        (
            UniCase::ascii("supernaturalizing"),
            &[(0b01001, &ENTRY_SUPERNATURALIZING_8508315994313061480)],
        ),
        (
            UniCase::ascii("revivalise"),
            &[(0b10010, &ENTRY_REVIVALIZE_12399394256488111764)],
        ),
        (
            UniCase::ascii("photolabeled"),
            &[(0b00001, &ENTRY_PHOTOLABELED_9221461550333475470)],
        ),
        (
            UniCase::ascii("anestheticer"),
            &[(0b11001, &ENTRY_ANESTHETICER_1712235669739749819)],
        ),
        (
            UniCase::ascii("interhybridises"),
            &[(0b10010, &ENTRY_INTERHYBRIDIZES_15088740729497120786)],
        ),
        (
            UniCase::ascii("favours"),
            &[(0b11010, &ENTRY_FAVORS_12388610586480585674)],
        ),
        (
            UniCase::ascii("motorize"),
            &[(0b01001, &ENTRY_MOTORIZE_9953616205839376436)],
        ),
        (
            UniCase::ascii("nodulise"),
            &[(0b10010, &ENTRY_NODULIZE_15512444632148288619)],
        ),
        (
            UniCase::ascii("apneas"),
            &[(0b11001, &ENTRY_APNEAS_16005692722117648490)],
        ),
        (
            UniCase::ascii("micropolarisation"),
            &[(0b10010, &ENTRY_MICROPOLARIZATION_7875633180146454277)],
        ),
        (
            UniCase::ascii("chelicere"),
            &[(0b00001, &ENTRY_CHELICERE_10130398757296091498)],
        ),
        (
            UniCase::ascii("disembowelled"),
            &[(0b11010, &ENTRY_DISEMBOWELED_10970335018373428342)],
        ),
        (
            UniCase::ascii("stomatodeum"),
            &[(0b00001, &ENTRY_STOMATODEUM_8741098205949880656)],
        ),
        (
            UniCase::ascii("sapientises"),
            &[(0b10010, &ENTRY_SAPIENTIZES_16382959409533620025)],
        ),
        (
            UniCase::ascii("arterialisation"),
            &[(0b10010, &ENTRY_ARTERIALIZATION_17022790192875553359)],
        ),
        (
            UniCase::ascii("infamonises"),
            &[(0b10010, &ENTRY_INFAMONIZES_828661709748784693)],
        ),
        (
            UniCase::ascii("supersensitise"),
            &[(0b10010, &ENTRY_SUPERSENSITIZE_7006527570782329036)],
        ),
        (
            UniCase::ascii("paternalises"),
            &[(0b10010, &ENTRY_PATERNALIZES_1247257877767433807)],
        ),
        (
            UniCase::ascii("extemporizer"),
            &[(0b01001, &ENTRY_EXTEMPORIZER_15042169661772082145)],
        ),
        (
            UniCase::ascii("photesthesis"),
            &[
                (0b00001, &ENTRY_PHOTESTHESIS_17727520840546347652),
                (0b00001, &ENTRY_PHOTESTHESIS_6981549980908445509),
            ],
        ),
        (
            UniCase::ascii("remoralized"),
            &[(0b01001, &ENTRY_REMORALIZED_16025093535995812890)],
        ),
        (
            UniCase::ascii("subtilizer"),
            &[(0b01001, &ENTRY_SUBTILIZER_2092624206187190872)],
        ),
        (
            UniCase::ascii("unionisations"),
            &[(0b10010, &ENTRY_UNIONIZATIONS_14252170992346338262)],
        ),
        (
            UniCase::ascii("mithridatise"),
            &[(0b10010, &ENTRY_MITHRIDATIZE_10215083672393880782)],
        ),
        (
            UniCase::ascii("randomisers"),
            &[(0b10010, &ENTRY_RANDOMIZERS_15224984926574272799)],
        ),
        (
            UniCase::ascii("boulevardise"),
            &[(0b10010, &ENTRY_BOULEVARDIZE_8185506525213597267)],
        ),
        (
            UniCase::ascii("plebeianize"),
            &[(0b01001, &ENTRY_PLEBEIANIZE_13948307616682534202)],
        ),
        (
            UniCase::ascii("luvs"),
            &[(0b00001, &ENTRY_LOVES_4486785153621169721)],
        ),
        (
            UniCase::ascii("sectionizes"),
            &[(0b01001, &ENTRY_SECTIONIZES_6513394183804020021)],
        ),
        (
            UniCase::ascii("unantagonizedder"),
            &[(0b01001, &ENTRY_UNANTAGONIZEDDER_17407737658502114220)],
        ),
        (
            UniCase::ascii("paedobaptist"),
            &[(0b11010, &ENTRY_PEDOBAPTIST_17393232685703437549)],
        ),
        (
            UniCase::ascii("theatricalisations"),
            &[(0b10010, &ENTRY_THEATRICALIZATIONS_568370628365365537)],
        ),
        (
            UniCase::ascii("paedotribe"),
            &[(0b11010, &ENTRY_PEDOTRIBE_5791037896195905072)],
        ),
        (
            UniCase::ascii("anesthetising"),
            &[(0b10000, &ENTRY_ANESTHETIZING_15816199569084558224)],
        ),
        (
            UniCase::ascii("idolatrizer"),
            &[(0b01001, &ENTRY_IDOLATRIZER_13466408337970930578)],
        ),
        (
            UniCase::ascii("peroxidizements"),
            &[(0b01001, &ENTRY_PEROXIDIZEMENTS_14879084608269866527)],
        ),
        (
            UniCase::ascii("paleobiological"),
            &[(0b10001, &ENTRY_PALEOBIOLOGICAL_6984844449398043034)],
        ),
        (
            UniCase::ascii("overdoctrinise"),
            &[(0b10010, &ENTRY_OVERDOCTRINIZE_6756558981699337418)],
        ),
        (
            UniCase::ascii("devalorisation"),
            &[(0b10010, &ENTRY_DEVALORIZATION_15315014812840888413)],
        ),
        (
            UniCase::ascii("labouress"),
            &[(0b11010, &ENTRY_LABORESS_5168896427468795263)],
        ),
        (
            UniCase::ascii("protocolizing"),
            &[(0b01001, &ENTRY_PROTOCOLIZING_6817748168002379013)],
        ),
        (
            UniCase::ascii("specificise"),
            &[(0b10010, &ENTRY_SPECIFICIZE_14913302620346573053)],
        ),
        (
            UniCase::ascii("magnetizabilities"),
            &[(0b01001, &ENTRY_MAGNETIZABILITIES_11043943833988980388)],
        ),
        (
            UniCase::ascii("immoralised"),
            &[(0b10010, &ENTRY_IMMORALIZED_8743847232919532242)],
        ),
        (
            UniCase::ascii("organizability"),
            &[(0b01001, &ENTRY_ORGANIZABILITY_11606263519927125050)],
        ),
        (
            UniCase::ascii("sabered"),
            &[(0b00001, &ENTRY_SABERED_6570351091920240802)],
        ),
        (
            UniCase::ascii("mythologising"),
            &[(0b10010, &ENTRY_MYTHOLOGIZING_13752169083408188946)],
        ),
        (
            UniCase::ascii("barbarises"),
            &[(0b10010, &ENTRY_BARBARIZES_7081317051698057651)],
        ),
        (
            UniCase::ascii("presbyterianized"),
            &[(0b01001, &ENTRY_PRESBYTERIANIZED_5190559539797332403)],
        ),
        (
            UniCase::ascii("poetisations"),
            &[(0b10010, &ENTRY_POETIZATIONS_14017988435836090874)],
        ),
        (
            UniCase::ascii("pythoninae"),
            &[(0b11010, &ENTRY_PYTHONINE_8378069869888673614)],
        ),
        (
            UniCase::ascii("arborised"),
            &[(0b10010, &ENTRY_ARBORIZED_10511833189104814553)],
        ),
        (
            UniCase::ascii("anglicanize"),
            &[(0b01001, &ENTRY_ANGLICANIZE_6589690597387603909)],
        ),
        (
            UniCase::ascii("governmentalizes"),
            &[(0b01001, &ENTRY_GOVERNMENTALIZES_15051032983194955811)],
        ),
        (
            UniCase::ascii("subcategorizing"),
            &[(0b01001, &ENTRY_SUBCATEGORIZING_3085156622608452887)],
        ),
        (
            UniCase::ascii("republicanises"),
            &[(0b10010, &ENTRY_REPUBLICANIZES_7718357541376368950)],
        ),
        (
            UniCase::ascii("etiotropically"),
            &[(0b10001, &ENTRY_ETIOTROPICALLY_9902369940420748380)],
        ),
        (
            UniCase::ascii("egotised"),
            &[(0b10010, &ENTRY_EGOTIZED_14948617827289949091)],
        ),
        (
            UniCase::ascii("semianesthetic"),
            &[(0b00001, &ENTRY_SEMIANESTHETIC_603220656140835402)],
        ),
        (
            UniCase::ascii("travelled"),
            &[(0b11010, &ENTRY_TRAVELED_7471204723840738059)],
        ),
        (
            UniCase::ascii("beglamour"),
            &[(0b11010, &ENTRY_BEGLAMOR_13712112495668100470)],
        ),
        (
            UniCase::ascii("virtuosoes"),
            &[(0b00001, &ENTRY_VIRTUOSI_6032024204705561293)],
        ),
        (
            UniCase::ascii("dialogising"),
            &[(0b10010, &ENTRY_DIALOGIZING_10876002085618537096)],
        ),
        (
            UniCase::ascii("conservatizes"),
            &[(0b01001, &ENTRY_CONSERVATIZES_6230909821260907845)],
        ),
        (
            UniCase::ascii("proverbizes"),
            &[(0b01001, &ENTRY_PROVERBIZES_1232232315538032087)],
        ),
        (
            UniCase::ascii("mobilization"),
            &[(0b01001, &ENTRY_MOBILIZATION_12561905628389471063)],
        ),
        (
            UniCase::ascii("incentivised"),
            &[(0b10010, &ENTRY_INCENTIVIZED_2383735849153336951)],
        ),
        (
            UniCase::ascii("proctorize"),
            &[(0b01001, &ENTRY_PROCTORIZE_2264104820190419500)],
        ),
        (
            UniCase::ascii("centrifugalize"),
            &[(0b01001, &ENTRY_CENTRIFUGALIZE_12152362034063070075)],
        ),
        (
            UniCase::ascii("tartarization"),
            &[(0b01001, &ENTRY_TARTARIZATION_1394513065812646894)],
        ),
        (
            UniCase::ascii("deregulationize"),
            &[(0b01001, &ENTRY_DEREGULATIONIZE_4270787265190494422)],
        ),
        (
            UniCase::ascii("lineniser"),
            &[(0b10010, &ENTRY_LINENIZER_11892341743174422110)],
        ),
        (
            UniCase::ascii("balladised"),
            &[(0b10010, &ENTRY_BALLADIZED_2167734885988214874)],
        ),
        (
            UniCase::ascii("prologuizes"),
            &[(0b01001, &ENTRY_PROLOGUIZES_3296728645194085464)],
        ),
        (
            UniCase::ascii("marvellously"),
            &[(0b11010, &ENTRY_MARVELOUSLY_9085447356318740108)],
        ),
        (
            UniCase::ascii("occidentalise"),
            &[(0b10010, &ENTRY_OCCIDENTALIZE_14982167974023633691)],
        ),
        (
            UniCase::ascii("iodize"),
            &[(0b01001, &ENTRY_IODIZE_6551505461584920010)],
        ),
        (
            UniCase::ascii("irishizes"),
            &[(0b01001, &ENTRY_IRISHIZES_13402990074273477360)],
        ),
        (
            UniCase::ascii("platycelian"),
            &[(0b00001, &ENTRY_PLATYCELIAN_16729912161176580577)],
        ),
        (
            UniCase::ascii("haemad"),
            &[(0b11010, &ENTRY_HEMAD_13652123074339994243)],
        ),
        (
            UniCase::ascii("hexachlorethane"),
            &[(0b00001, &ENTRY_HEXACHLORETHANE_11021447419541267943)],
        ),
        (
            UniCase::ascii("hellenization"),
            &[(0b01001, &ENTRY_HELLENIZATION_572299821795419581)],
        ),
        (
            UniCase::ascii("boswellizes"),
            &[(0b01001, &ENTRY_BOSWELLIZES_11578704107127902682)],
        ),
        (
            UniCase::ascii("flavoury"),
            &[(0b11010, &ENTRY_FLAVORY_14845529741701932399)],
        ),
        (
            UniCase::ascii("aphetising"),
            &[(0b10010, &ENTRY_APHETIZING_13930569398062916036)],
        ),
        (
            UniCase::ascii("agonizers"),
            &[(0b01001, &ENTRY_AGONIZERS_12684640191692446391)],
        ),
        (
            UniCase::ascii("engrandizes"),
            &[(0b01001, &ENTRY_ENGRANDIZES_5787971542005976862)],
        ),
        (
            UniCase::ascii("bowdlerizer"),
            &[(0b01001, &ENTRY_BOWDLERIZER_9391658950288862007)],
        ),
        (
            UniCase::ascii("animized"),
            &[(0b01001, &ENTRY_ANIMIZED_3366606492537025225)],
        ),
        (
            UniCase::ascii("parenthesization"),
            &[(0b01001, &ENTRY_PARENTHESIZATION_9124500764491892448)],
        ),
        (
            UniCase::ascii("hyperspiritualisings"),
            &[(0b10010, &ENTRY_HYPERSPIRITUALIZINGS_11634664580831934117)],
        ),
        (
            UniCase::ascii("porcelainized"),
            &[(0b01001, &ENTRY_PORCELAINIZED_8958345284962155259)],
        ),
        (
            UniCase::ascii("pajama"),
            &[(0b01001, &ENTRY_PAJAMA_6036010499883376406)],
        ),
        (
            UniCase::ascii("apostolising"),
            &[(0b10010, &ENTRY_APOSTOLIZING_7088290679795202865)],
        ),
        (
            UniCase::ascii("resymbolizes"),
            &[(0b01001, &ENTRY_RESYMBOLIZES_15380238287856922249)],
        ),
        (
            UniCase::ascii("royalise"),
            &[(0b10010, &ENTRY_ROYALIZE_14272296856251086161)],
        ),
        (
            UniCase::ascii("etiophyllin"),
            &[(0b10001, &ENTRY_ETIOPHYLLIN_9404514496968390932)],
        ),
        (
            UniCase::ascii("vocationalizations"),
            &[(0b01001, &ENTRY_VOCATIONALIZATIONS_12760103465092649332)],
        ),
        (
            UniCase::ascii("hypothetises"),
            &[(0b10010, &ENTRY_HYPOTHETIZES_1892978940988731731)],
        ),
        (
            UniCase::ascii("listerizes"),
            &[(0b01001, &ENTRY_LISTERIZES_6903942868385427615)],
        ),
        (
            UniCase::ascii("containerizes"),
            &[(0b01001, &ENTRY_CONTAINERIZES_5244588712773306715)],
        ),
        (
            UniCase::ascii("nationalize"),
            &[(0b01001, &ENTRY_NATIONALIZE_3677566152660435624)],
        ),
        (
            UniCase::ascii("maeandriniform"),
            &[(0b11010, &ENTRY_MEANDRINIFORM_8185091047283393921)],
        ),
        (
            UniCase::ascii("autotomised"),
            &[(0b10010, &ENTRY_AUTOTOMIZED_7590157601515171803)],
        ),
        (
            UniCase::ascii("medicalize"),
            &[(0b01001, &ENTRY_MEDICALIZE_17606487197661150257)],
        ),
        (
            UniCase::ascii("coenobites"),
            &[(0b11010, &ENTRY_CENOBITES_12070792697281985215)],
        ),
        (
            UniCase::ascii("actualization"),
            &[(0b01001, &ENTRY_ACTUALIZATION_10932469677827186244)],
        ),
        (
            UniCase::ascii("hyaenic"),
            &[(0b11010, &ENTRY_HYENIC_15051336625087668416)],
        ),
        (
            UniCase::ascii("eventualising"),
            &[(0b10010, &ENTRY_EVENTUALIZING_3264561079067185461)],
        ),
        (
            UniCase::ascii("unamortised"),
            &[(0b10010, &ENTRY_UNAMORTIZED_13451896776472967546)],
        ),
        (
            UniCase::ascii("keratinizes"),
            &[(0b01001, &ENTRY_KERATINIZES_14523171164749310546)],
        ),
        (
            UniCase::ascii("eulogisation"),
            &[(0b10010, &ENTRY_EULOGIZATION_10282426959041271101)],
        ),
        (
            UniCase::ascii("columnises"),
            &[(0b10010, &ENTRY_COLUMNIZES_920618881458905076)],
        ),
        (
            UniCase::ascii("fictionisations"),
            &[(0b10010, &ENTRY_FICTIONIZATIONS_8973608411174529758)],
        ),
        (
            UniCase::ascii("professionalization"),
            &[(0b01001, &ENTRY_PROFESSIONALIZATION_17530475144205441796)],
        ),
        (
            UniCase::ascii("unsynthesized"),
            &[(0b01001, &ENTRY_UNSYNTHESIZED_873390520484748283)],
        ),
        (
            UniCase::ascii("astigmatisers"),
            &[(0b10010, &ENTRY_ASTIGMATIZERS_18090102560636046522)],
        ),
        (
            UniCase::ascii("hemoerythrin"),
            &[(0b11010, &ENTRY_HEMERYTHRIN_18297143920246755389)],
        ),
        (
            UniCase::ascii("thymectomise"),
            &[(0b10010, &ENTRY_THYMECTOMIZE_9188848309665571694)],
        ),
        (
            UniCase::ascii("puritanisers"),
            &[(0b10010, &ENTRY_PURITANIZERS_1778141389685069367)],
        ),
        (
            UniCase::ascii("propagandizing"),
            &[(0b01001, &ENTRY_PROPAGANDIZING_14458179375605730291)],
        ),
        (
            UniCase::ascii("ungalvanized"),
            &[(0b01001, &ENTRY_UNGALVANIZED_3840316573651324942)],
        ),
        (
            UniCase::ascii("paleoanthropology"),
            &[(0b10001, &ENTRY_PALEOANTHROPOLOGY_3812740593686907410)],
        ),
        (
            UniCase::ascii("gaufers"),
            &[(0b00001, &ENTRY_GAUFERS_8535552125608729352)],
        ),
        (
            UniCase::ascii("focalise"),
            &[(0b10010, &ENTRY_FOCALIZE_10950232880240497629)],
        ),
        (
            UniCase::ascii("logorrhea"),
            &[(0b11001, &ENTRY_LOGORRHEA_1908810066516211712)],
        ),
        (
            UniCase::ascii("longeval"),
            &[(0b00001, &ENTRY_LONGEVAL_15368062473073605372)],
        ),
        (
            UniCase::ascii("infamonised"),
            &[(0b10010, &ENTRY_INFAMONIZED_12631432978176771320)],
        ),
        (
            UniCase::ascii("aeolotropic"),
            &[(0b11010, &ENTRY_EOLOTROPIC_9928061474103766564)],
        ),
        (
            UniCase::ascii("zoaea"),
            &[(0b11010, &ENTRY_ZOEA_17148924521763695652)],
        ),
        (
            UniCase::ascii("neurepithelium"),
            &[(0b00001, &ENTRY_NEUREPITHELIUM_14522596466559359420)],
        ),
        (
            UniCase::ascii("axiomatising"),
            &[(0b10010, &ENTRY_AXIOMATIZING_1265140579235398858)],
        ),
        (
            UniCase::ascii("idolised"),
            &[(0b10010, &ENTRY_IDOLIZED_816557049996724188)],
        ),
        (
            UniCase::ascii("magicalises"),
            &[(0b10010, &ENTRY_MAGICALIZES_230667262651274489)],
        ),
        (
            UniCase::ascii("pauperisers"),
            &[(0b10010, &ENTRY_PAUPERIZERS_11032753764651813331)],
        ),
        (
            UniCase::ascii("militarizations"),
            &[(0b01001, &ENTRY_MILITARIZATIONS_16041396934802500390)],
        ),
        (
            UniCase::ascii("paleichthyologist"),
            &[(0b10001, &ENTRY_PALEICHTHYOLOGIST_18367699513737958699)],
        ),
        (
            UniCase::ascii("depersonalized"),
            &[(0b01001, &ENTRY_DEPERSONALIZED_6040306005149363450)],
        ),
        (
            UniCase::ascii("photographises"),
            &[(0b10010, &ENTRY_PHOTOGRAPHIZES_7246623188004089530)],
        ),
        (
            UniCase::ascii("magnetisability"),
            &[(0b10010, &ENTRY_MAGNETIZABILITY_15941565557987915165)],
        ),
        (
            UniCase::ascii("subsidize"),
            &[(0b01001, &ENTRY_SUBSIDIZE_9015916516385257628)],
        ),
        (
            UniCase::ascii("ungraphitised"),
            &[(0b10010, &ENTRY_UNGRAPHITIZED_9140840362551120713)],
        ),
        (
            UniCase::ascii("negroizations"),
            &[(0b01001, &ENTRY_NEGROIZATIONS_3358353493795107975)],
        ),
        (
            UniCase::ascii("nitre"),
            &[(0b11010, &ENTRY_NITER_4595235793148205687)],
        ),
        (
            UniCase::ascii("anglicises"),
            &[(0b10010, &ENTRY_ANGLICIZES_17586920051951268985)],
        ),
        (
            UniCase::ascii("systematizes"),
            &[(0b01001, &ENTRY_SYSTEMATIZES_6130814802973402788)],
        ),
        (
            UniCase::ascii("uncharacterised"),
            &[(0b10010, &ENTRY_UNCHARACTERIZED_16956353213909858293)],
        ),
        (
            UniCase::ascii("mortalised"),
            &[(0b10010, &ENTRY_MORTALIZED_16634602645317905204)],
        ),
        (
            UniCase::ascii("virtualization"),
            &[(0b00001, &ENTRY_VIRTUALIZATION_8096145334874168940)],
        ),
        (
            UniCase::ascii("harveyizes"),
            &[(0b01001, &ENTRY_HARVEYIZES_14473265147115327687)],
        ),
        (
            UniCase::ascii("powderiser"),
            &[(0b10010, &ENTRY_POWDERIZER_11484081010411649926)],
        ),
        (
            UniCase::ascii("fertilizers"),
            &[(0b01001, &ENTRY_FERTILIZERS_2400009978178899509)],
        ),
        (
            UniCase::ascii("criticisinglier"),
            &[(0b10010, &ENTRY_CRITICIZINGLIER_5644837899795371316)],
        ),
        (
            UniCase::ascii("agonizedly"),
            &[(0b01001, &ENTRY_AGONIZEDLY_2195479848919207850)],
        ),
        (
            UniCase::ascii("dealcoholizing"),
            &[(0b01001, &ENTRY_DEALCOHOLIZING_9291655249306543942)],
        ),
        (
            UniCase::ascii("prefoliations"),
            &[(0b11010, &ENTRY_PERFOLIATIONS_5441070203325996418)],
        ),
        (
            UniCase::ascii("anathematisations"),
            &[(0b10010, &ENTRY_ANATHEMATIZATIONS_620207996168887075)],
        ),
        (
            UniCase::ascii("civilizationals"),
            &[(0b01001, &ENTRY_CIVILIZATIONALS_16890543284368506921)],
        ),
        (
            UniCase::ascii("disequalizer"),
            &[(0b01001, &ENTRY_DISEQUALIZER_15153684888095615538)],
        ),
        (
            UniCase::ascii("harmonisablest"),
            &[(0b10010, &ENTRY_HARMONIZABLEST_2737362624785805248)],
        ),
        (
            UniCase::ascii("prostatorrhoea"),
            &[(0b11010, &ENTRY_PROSTATORRHEA_560097517692680467)],
        ),
        (
            UniCase::ascii("propylitises"),
            &[(0b10010, &ENTRY_PROPYLITIZES_1960476382403426175)],
        ),
        (
            UniCase::ascii("vowelised"),
            &[(0b10010, &ENTRY_VOWELIZED_10046225650144601473)],
        ),
        (
            UniCase::ascii("unrationalising"),
            &[(0b10010, &ENTRY_UNRATIONALIZING_10416615276147328253)],
        ),
        (
            UniCase::ascii("motorise"),
            &[(0b10010, &ENTRY_MOTORIZE_9953616205839376436)],
        ),
        (
            UniCase::ascii("laboredness"),
            &[(0b11001, &ENTRY_LABOREDNESS_7253397270172707072)],
        ),
        (
            UniCase::ascii("foetid"),
            &[(0b10010, &ENTRY_FETID_1081410302491831537)],
        ),
        (
            UniCase::ascii("philosophizers"),
            &[(0b01001, &ENTRY_PHILOSOPHIZERS_9374939330362272451)],
        ),
        (
            UniCase::ascii("alienizes"),
            &[(0b01001, &ENTRY_ALIENIZES_16619977169071842029)],
        ),
        (
            UniCase::ascii("columnizing"),
            &[(0b01001, &ENTRY_COLUMNIZING_11760357087944386265)],
        ),
        (
            UniCase::ascii("popularisation"),
            &[(0b10010, &ENTRY_POPULARIZATION_10295312737144065502)],
        ),
        (
            UniCase::ascii("colourest"),
            &[(0b11010, &ENTRY_COLORREST_6777192705388068909)],
        ),
        (
            UniCase::ascii("unflavoured"),
            &[(0b11010, &ENTRY_UNFLAVORED_7704639512615468125)],
        ),
        (
            UniCase::ascii("democratizing"),
            &[(0b01001, &ENTRY_DEMOCRATIZING_5756319688655505152)],
        ),
        (
            UniCase::ascii("organisable"),
            &[(0b10010, &ENTRY_ORGANIZABLE_8071054869331386545)],
        ),
        (
            UniCase::ascii("sectorisation"),
            &[(0b10010, &ENTRY_SECTORIZATION_13074208022324954117)],
        ),
        (
            UniCase::ascii("boled"),
            &[(0b00001, &ENTRY_BOLED_14696249241634637180)],
        ),
        (
            UniCase::ascii("sorbitisation"),
            &[(0b10010, &ENTRY_SORBITIZATION_3511955197103798019)],
        ),
        (
            UniCase::ascii("unlocalisable"),
            &[(0b10010, &ENTRY_UNLOCALIZABLE_9968738969162630281)],
        ),
        (
            UniCase::ascii("unhumoureddest"),
            &[(0b11010, &ENTRY_UNHUMOREDDEST_7064789414378776056)],
        ),
        (
            UniCase::ascii("protocolising"),
            &[(0b10010, &ENTRY_PROTOCOLIZING_6817748168002379013)],
        ),
        (
            UniCase::ascii("russianise"),
            &[(0b10010, &ENTRY_RUSSIANIZE_9206676310088840254)],
        ),
        (
            UniCase::ascii("departmentisations"),
            &[(0b10010, &ENTRY_DEPARTMENTIZATIONS_3570201152511445119)],
        ),
        (
            UniCase::ascii("underprize"),
            &[(0b01001, &ENTRY_UNDERPRIZE_5508380942697361246)],
        ),
        (
            UniCase::ascii("linenizes"),
            &[(0b01001, &ENTRY_LINENIZES_13144713631494316074)],
        ),
        (
            UniCase::ascii("hyperbolises"),
            &[(0b10010, &ENTRY_HYPERBOLIZES_10753409068722265798)],
        ),
        (
            UniCase::ascii("ideologized"),
            &[(0b01001, &ENTRY_IDEOLOGIZED_14839820276752351313)],
        ),
        (
            UniCase::ascii("etymologizing"),
            &[(0b01001, &ENTRY_ETYMOLOGIZING_10793154235770650022)],
        ),
        (
            UniCase::ascii("poetising"),
            &[(0b10010, &ENTRY_POETIZING_5617458256013617960)],
        ),
        (
            UniCase::ascii("colloquise"),
            &[(0b10010, &ENTRY_COLLOQUIZE_3542999561179306173)],
        ),
        (
            UniCase::ascii("myrialitre"),
            &[(0b11010, &ENTRY_MYRIALITER_6139987841651830761)],
        ),
        (
            UniCase::ascii("narcotisation"),
            &[(0b10010, &ENTRY_NARCOTIZATION_3430955045881256247)],
        ),
        (
            UniCase::ascii("desynchronisation"),
            &[(0b10010, &ENTRY_DESYNCHRONIZATION_15934272175464625660)],
        ),
        (
            UniCase::ascii("preutilisable"),
            &[(0b10010, &ENTRY_PREUTILIZABLE_13773594832026128190)],
        ),
        (
            UniCase::ascii("authorisation"),
            &[(0b10010, &ENTRY_AUTHORIZATION_395843400641738718)],
        ),
        (
            UniCase::ascii("supernaturalizes"),
            &[(0b01001, &ENTRY_SUPERNATURALIZES_16951225069063962411)],
        ),
        (
            UniCase::ascii("arterializes"),
            &[(0b01001, &ENTRY_ARTERIALIZES_2237218216825221904)],
        ),
        (
            UniCase::ascii("conceptualizer"),
            &[(0b01001, &ENTRY_CONCEPTUALIZER_9902569432824476207)],
        ),
        (
            UniCase::ascii("unsecularizeddest"),
            &[(0b01001, &ENTRY_UNSECULARIZEDDEST_2864881942285944778)],
        ),
        (
            UniCase::ascii("praeposter"),
            &[(0b11010, &ENTRY_PREPOSTER_9979045838450867710)],
        ),
        (
            UniCase::ascii("dialyzates"),
            &[(0b01001, &ENTRY_DIALYZATES_16159553587347789538)],
        ),
        (
            UniCase::ascii("weizes"),
            &[(0b01001, &ENTRY_WEIZES_7320958225089246727)],
        ),
        (
            UniCase::ascii("sorbitises"),
            &[(0b10010, &ENTRY_SORBITIZES_17239730547558440933)],
        ),
        (
            UniCase::ascii("papalized"),
            &[(0b01001, &ENTRY_PAPALIZED_8860509933771894456)],
        ),
        (
            UniCase::ascii("hyphenisations"),
            &[(0b10010, &ENTRY_HYPHENIZATIONS_2352732446948213541)],
        ),
        (
            UniCase::ascii("liberalisers"),
            &[(0b10010, &ENTRY_LIBERALIZERS_2604457956948553415)],
        ),
        (
            UniCase::ascii("unvisualizedder"),
            &[(0b01001, &ENTRY_UNVISUALIZEDDER_13256531491156210059)],
        ),
        (
            UniCase::ascii("obelising"),
            &[(0b10010, &ENTRY_OBELIZING_10540895735990622314)],
        ),
        (
            UniCase::ascii("hepatise"),
            &[(0b10010, &ENTRY_HEPATIZE_9537992825882517878)],
        ),
        (
            UniCase::ascii("martae"),
            &[(0b11010, &ENTRY_MARTE_115900376362314851)],
        ),
        (
            UniCase::ascii("quintessentializing"),
            &[(0b01001, &ENTRY_QUINTESSENTIALIZING_13955826412375505803)],
        ),
        (
            UniCase::ascii("cyclize"),
            &[(0b01001, &ENTRY_CYCLIZE_11964539384894004110)],
        ),
        (
            UniCase::ascii("soldierize"),
            &[(0b01001, &ENTRY_SOLDIERIZE_16604236556396943965)],
        ),
        (
            UniCase::ascii("gelatinizing"),
            &[(0b01001, &ENTRY_GELATINIZING_11893129576765756087)],
        ),
        (
            UniCase::ascii("universalisers"),
            &[(0b10010, &ENTRY_UNIVERSALIZERS_10160828143436328394)],
        ),
        (
            UniCase::ascii("haemochrome"),
            &[(0b11010, &ENTRY_HEMOCHROME_2175430877481267405)],
        ),
        (
            UniCase::ascii("feralized"),
            &[(0b01001, &ENTRY_FERALIZED_2129540690752206051)],
        ),
        (
            UniCase::ascii("ocyrrhoe"),
            &[(0b00001, &ENTRY_OCYRRHOE_15586534960542914241)],
        ),
        (
            UniCase::ascii("divinister"),
            &[(0b00001, &ENTRY_DIVINISTER_6065276535238492048)],
        ),
        (
            UniCase::ascii("phocean"),
            &[(0b00001, &ENTRY_PHOCEAN_7579607581288728415)],
        ),
        (
            UniCase::ascii("micromillimetres"),
            &[(0b11010, &ENTRY_MICROMILLIMETERS_3079930143003610243)],
        ),
        (
            UniCase::ascii("photolysable"),
            &[(0b11010, &ENTRY_PHOTOLYZABLE_1307676699359278891)],
        ),
        (
            UniCase::ascii("estrum"),
            &[(0b00001, &ENTRY_ESTRUM_80713081920872301)],
        ),
        (
            UniCase::ascii("realisablest"),
            &[(0b10010, &ENTRY_REALIZABLEST_5797694315741755778)],
        ),
        (
            UniCase::ascii("idolaster"),
            &[(0b00001, &ENTRY_IDOLASTER_7266072593117643606)],
        ),
        (
            UniCase::ascii("labourability"),
            &[(0b11010, &ENTRY_LABORABILITY_15883644828666969797)],
        ),
        (
            UniCase::ascii("fagoting"),
            &[(0b01001, &ENTRY_FAGOTING_14091007799386400971)],
        ),
        (
            UniCase::ascii("decolourizing"),
            &[(0b01000, &ENTRY_DECOLORIZING_16950423814877555244)],
        ),
        (
            UniCase::ascii("tutorises"),
            &[(0b10010, &ENTRY_TUTORIZES_5000989116733816697)],
        ),
        (
            UniCase::ascii("monecious"),
            &[(0b00001, &ENTRY_MONOECIOUS_16926061790085197953)],
        ),
        (
            UniCase::ascii("greenuk"),
            &[(0b11010, &ENTRY_GERENUK_11123017430709792003)],
        ),
        (
            UniCase::ascii("oecophobia"),
            &[(0b11010, &ENTRY_ECOPHOBIA_3341542489768933704)],
        ),
        (
            UniCase::ascii("excursionise"),
            &[(0b10010, &ENTRY_EXCURSIONIZE_6141947279836282456)],
        ),
        (
            UniCase::ascii("linenise"),
            &[(0b10010, &ENTRY_LINENIZE_4255117013207072568)],
        ),
        (
            UniCase::ascii("persianizations"),
            &[(0b01001, &ENTRY_PERSIANIZATIONS_12804723289958534578)],
        ),
        (
            UniCase::ascii("grovelers"),
            &[(0b00001, &ENTRY_GROVELERS_17279766420386335679)],
        ),
        (
            UniCase::ascii("advertisable"),
            &[(0b10010, &ENTRY_ADVERTIZABLE_5401609881263486182)],
        ),
        (
            UniCase::ascii("peizing"),
            &[(0b01001, &ENTRY_PEIZING_15796017161972728108)],
        ),
        (
            UniCase::ascii("favourably"),
            &[(0b11010, &ENTRY_FAVORABLY_8642546699578488365)],
        ),
        (
            UniCase::ascii("hospitalisation"),
            &[(0b10010, &ENTRY_HOSPITALIZATION_6876754108770647316)],
        ),
        (
            UniCase::ascii("mechanisation"),
            &[(0b10010, &ENTRY_MECHANIZATION_15363685468899666275)],
        ),
        (
            UniCase::ascii("revolutionisements"),
            &[(0b10010, &ENTRY_REVOLUTIONIZEMENTS_8372696219470999573)],
        ),
        (
            UniCase::ascii("dieselization"),
            &[(0b01001, &ENTRY_DIESELIZATION_16989738541584421026)],
        ),
        (
            UniCase::ascii("recentralization"),
            &[(0b01001, &ENTRY_RECENTRALIZATION_6419892289797763156)],
        ),
        (
            UniCase::ascii("rematerialise"),
            &[(0b10010, &ENTRY_REMATERIALIZE_12678282950195083048)],
        ),
        (
            UniCase::ascii("tebilize"),
            &[(0b01001, &ENTRY_TEBILIZE_5379298659414145032)],
        ),
        (
            UniCase::ascii("atroceruleus"),
            &[(0b00001, &ENTRY_ATROCERULEUS_7452134384217065626)],
        ),
        (
            UniCase::ascii("theatergoings"),
            &[(0b00001, &ENTRY_THEATERGOINGS_6740435645328474541)],
        ),
        (
            UniCase::ascii("favoured"),
            &[(0b11010, &ENTRY_FAVORED_16162807193690319578)],
        ),
        (
            UniCase::ascii("undualise"),
            &[(0b10010, &ENTRY_UNDUALIZE_12388450838585691212)],
        ),
        (
            UniCase::ascii("subtilises"),
            &[(0b10010, &ENTRY_SUBTILIZES_7637829126901224384)],
        ),
        (
            UniCase::ascii("legitimatise"),
            &[(0b10010, &ENTRY_LEGITIMATIZE_14030890652940162105)],
        ),
        (
            UniCase::ascii("feudalisations"),
            &[(0b10010, &ENTRY_FEUDALIZATIONS_10450459550757796831)],
        ),
        (
            UniCase::ascii("tranquilizing"),
            &[(0b01001, &ENTRY_TRANQUILIZING_13850716228820534198)],
        ),
        (
            UniCase::ascii("pedantizes"),
            &[(0b01001, &ENTRY_PEDANTIZES_9391276727368944001)],
        ),
        (
            UniCase::ascii("memorialiser"),
            &[(0b10010, &ENTRY_MEMORIALIZER_188024871039509941)],
        ),
        (
            UniCase::ascii("unromanticiseddest"),
            &[(0b10010, &ENTRY_UNROMANTICIZEDDEST_4366413467561211143)],
        ),
        (
            UniCase::ascii("pasteuriser"),
            &[(0b10010, &ENTRY_PASTEURIZER_7779730307883141682)],
        ),
        (
            UniCase::ascii("overemphasized"),
            &[(0b01001, &ENTRY_OVEREMPHASIZED_10786070739152462413)],
        ),
        (
            UniCase::ascii("jacobinising"),
            &[(0b10010, &ENTRY_JACOBINIZING_17823010425672134088)],
        ),
        (
            UniCase::ascii("diagonalizing"),
            &[(0b01001, &ENTRY_DIAGONALIZING_14520835686620115538)],
        ),
        (
            UniCase::ascii("grangerisations"),
            &[(0b10010, &ENTRY_GRANGERIZATIONS_6041546144988435113)],
        ),
        (
            UniCase::ascii("fueled"),
            &[(0b00001, &ENTRY_FUELED_17965004435497699778)],
        ),
        (
            UniCase::ascii("dispauperise"),
            &[(0b10010, &ENTRY_DISPAUPERIZE_4660569275468440176)],
        ),
        (
            UniCase::ascii("microminiaturising"),
            &[(0b10010, &ENTRY_MICROMINIATURIZING_9157788742498342217)],
        ),
        (
            UniCase::ascii("deracialized"),
            &[(0b01001, &ENTRY_DERACIALIZED_13925986860775238916)],
        ),
        (
            UniCase::ascii("taborers"),
            &[(0b00001, &ENTRY_TABORERS_6060629822354641976)],
        ),
        (
            UniCase::ascii("libeler"),
            &[(0b00001, &ENTRY_LIBELER_17085228261817297321)],
        ),
        (
            UniCase::ascii("remodelled"),
            &[(0b11010, &ENTRY_REMODELED_11951619598691255997)],
        ),
        (
            UniCase::ascii("paleoencephalon"),
            &[(0b10001, &ENTRY_PALEOENCEPHALON_12092496594413779771)],
        ),
        (
            UniCase::ascii("sylvanise"),
            &[(0b10010, &ENTRY_SYLVANIZE_6265985924948097486)],
        ),
        (
            UniCase::ascii("unpatronizing"),
            &[(0b01001, &ENTRY_UNPATRONIZING_315514134828674594)],
        ),
        (
            UniCase::ascii("gerne"),
            &[(0b00001, &ENTRY_GERNE_10723705562317631976)],
        ),
        (
            UniCase::ascii("heathenised"),
            &[(0b10010, &ENTRY_HEATHENIZED_11565747380883958930)],
        ),
        (
            UniCase::ascii("crystallised"),
            &[(0b10010, &ENTRY_CRYSTALLIZED_1190597515180481232)],
        ),
        (
            UniCase::ascii("rhetorised"),
            &[(0b10010, &ENTRY_RHETORIZED_12036770468694769802)],
        ),
        (
            UniCase::ascii("decolourated"),
            &[(0b11010, &ENTRY_DECOLORATED_13361198090261586484)],
        ),
        (
            UniCase::ascii("bistereddest"),
            &[(0b00001, &ENTRY_BISTEREDDEST_8076651195429169182)],
        ),
        (
            UniCase::ascii("abetters"),
            &[(0b10011, &ENTRY_ABETTORS_7043394254318611656)],
        ),
        (
            UniCase::ascii("propraetors"),
            &[(0b11010, &ENTRY_PROPRETORS_1061872627090076302)],
        ),
        (
            UniCase::ascii("externalize"),
            &[(0b01001, &ENTRY_EXTERNALIZE_6421333850383600915)],
        ),
        (
            UniCase::ascii("vowelized"),
            &[(0b01001, &ENTRY_VOWELIZED_10046225650144601473)],
        ),
        (
            UniCase::ascii("dishonored"),
            &[(0b11001, &ENTRY_DISHONORED_1979408375344629609)],
        ),
        (
            UniCase::ascii("prebaptises"),
            &[(0b10010, &ENTRY_PREBAPTIZES_11093608958711804148)],
        ),
        (
            UniCase::ascii("spinulae"),
            &[(0b11010, &ENTRY_SPINULE_17210556472422983066)],
        ),
        (
            UniCase::ascii("anthoecological"),
            &[(0b11010, &ENTRY_ANTHECOLOGICAL_17004641370097456161)],
        ),
        (
            UniCase::ascii("singularise"),
            &[(0b10010, &ENTRY_SINGULARIZE_12969745354704340141)],
        ),
        (
            UniCase::ascii("tenia"),
            &[(0b00001, &ENTRY_TENIA_6242231905882591005)],
        ),
        (
            UniCase::ascii("repaganize"),
            &[(0b01001, &ENTRY_REPAGANIZE_12973755742278560404)],
        ),
        (
            UniCase::ascii("recognizably"),
            &[(0b01001, &ENTRY_RECOGNIZABLY_11330537720549631906)],
        ),
        (
            UniCase::ascii("amalthea"),
            &[(0b00001, &ENTRY_AMALTHEA_17903426763265878110)],
        ),
        (
            UniCase::ascii("paganizing"),
            &[(0b01001, &ENTRY_PAGANIZING_17172254602210790902)],
        ),
        (
            UniCase::ascii("palaeencephalon"),
            &[(0b11010, &ENTRY_PALEENCEPHALON_17919159965626856547)],
        ),
        (
            UniCase::ascii("armoury"),
            &[(0b11010, &ENTRY_ARMORY_16496001318701009580)],
        ),
        (
            UniCase::ascii("methodisations"),
            &[(0b10010, &ENTRY_METHODIZATIONS_17570359377170798664)],
        ),
        (
            UniCase::ascii("cognisantest"),
            &[(0b10010, &ENTRY_COGNIZANTEST_9952434271050939774)],
        ),
        (
            UniCase::ascii("cutinized"),
            &[(0b01001, &ENTRY_CUTINIZED_8304546337057011168)],
        ),
        (
            UniCase::ascii("palaeology"),
            &[(0b11010, &ENTRY_PALEOLOGY_14864767825292514427)],
        ),
        (
            UniCase::ascii("robotisation"),
            &[(0b10010, &ENTRY_ROBOTIZATION_10442464385649584788)],
        ),
        (
            UniCase::ascii("hure"),
            &[(0b11010, &ENTRY_HUER_14814098217806996597)],
        ),
        (
            UniCase::ascii("paeanize"),
            &[(0b01001, &ENTRY_PAEANIZE_8806779712541481579)],
        ),
        (
            UniCase::ascii("fabulising"),
            &[(0b10010, &ENTRY_FABULIZING_8547130161556656861)],
        ),
        (
            UniCase::ascii("leveling"),
            &[(0b00001, &ENTRY_LEVELING_2449494232626797630)],
        ),
        (
            UniCase::ascii("taborins"),
            &[(0b00001, &ENTRY_TABORINS_16033201340157357087)],
        ),
        (
            UniCase::ascii("epidotized"),
            &[(0b01001, &ENTRY_EPIDOTIZED_18043278384935210029)],
        ),
        (
            UniCase::ascii("curarised"),
            &[(0b10010, &ENTRY_CURARIZED_16380507751440201850)],
        ),
        (
            UniCase::ascii("unsensualizing"),
            &[(0b01001, &ENTRY_UNSENSUALIZING_1812813256933634221)],
        ),
        (
            UniCase::ascii("fractionalized"),
            &[(0b01001, &ENTRY_FRACTIONALIZED_1638721305897569649)],
        ),
        (
            UniCase::ascii("denuclearise"),
            &[(0b10010, &ENTRY_DENUCLEARIZE_7871525726880557534)],
        ),
        (
            UniCase::ascii("tenementizations"),
            &[(0b01001, &ENTRY_TENEMENTIZATIONS_3755446656409966534)],
        ),
        (
            UniCase::ascii("cree"),
            &[(0b11010, &ENTRY_CERE_9821157149992437937)],
        ),
        (
            UniCase::ascii("strychninize"),
            &[(0b01001, &ENTRY_STRYCHNINIZE_17273897055193701327)],
        ),
        (
            UniCase::ascii("hydrolyzates"),
            &[(0b01001, &ENTRY_HYDROLYZATES_1902626880371868391)],
        ),
        (
            UniCase::ascii("photosensitises"),
            &[(0b10010, &ENTRY_PHOTOSENSITIZES_9120738511428773132)],
        ),
        (
            UniCase::ascii("cretinization"),
            &[(0b01001, &ENTRY_CRETINIZATION_9976126052462780936)],
        ),
        (
            UniCase::ascii("schillerised"),
            &[(0b10010, &ENTRY_SCHILLERIZED_8127379884079449773)],
        ),
        (
            UniCase::ascii("catalyser"),
            &[(0b11010, &ENTRY_CATALYZER_13103775222379027346)],
        ),
        (
            UniCase::ascii("temporiser"),
            &[(0b10010, &ENTRY_TEMPORIZER_13728915446164211108)],
        ),
        (
            UniCase::ascii("itemiser"),
            &[(0b10010, &ENTRY_ITEMIZER_16293437282164566897)],
        ),
        (
            UniCase::ascii("laevigate"),
            &[(0b11010, &ENTRY_LEVIGATE_15789706620200322738)],
        ),
        (
            UniCase::ascii("vulcanizing"),
            &[(0b01001, &ENTRY_VULCANIZING_16179329893471043275)],
        ),
        (
            UniCase::ascii("formulizations"),
            &[(0b01001, &ENTRY_FORMULIZATIONS_5844779062261258067)],
        ),
        (
            UniCase::ascii("etherealizes"),
            &[(0b01001, &ENTRY_ETHEREALIZES_5231734843750416436)],
        ),
        (
            UniCase::ascii("ungelatinised"),
            &[(0b10010, &ENTRY_UNGELATINIZED_9064237700681920871)],
        ),
        (
            UniCase::ascii("alkalizing"),
            &[(0b01001, &ENTRY_ALKALIZING_8020169751754023745)],
        ),
        (
            UniCase::ascii("ostraciser"),
            &[(0b10010, &ENTRY_OSTRACIZER_17846167188643762430)],
        ),
        (
            UniCase::ascii("copolymerizations"),
            &[(0b01001, &ENTRY_COPOLYMERIZATIONS_5973914645684635)],
        ),
        (
            UniCase::ascii("summarizes"),
            &[(0b01001, &ENTRY_SUMMARIZES_14818168405290018071)],
        ),
        (
            UniCase::ascii("envapors"),
            &[(0b10001, &ENTRY_ENVAPORS_5110885845552232253)],
        ),
        (
            UniCase::ascii("electrodialyzes"),
            &[(0b00001, &ENTRY_ELECTRODIALYZES_3747563092652406931)],
        ),
        (
            UniCase::ascii("fictionalizing"),
            &[(0b01001, &ENTRY_FICTIONALIZING_783960443322171580)],
        ),
        (
            UniCase::ascii("destabilizes"),
            &[(0b01001, &ENTRY_DESTABILIZES_13491486327241590151)],
        ),
        (
            UniCase::ascii("faeculence"),
            &[(0b11010, &ENTRY_FECULENCE_2631357115871198711)],
        ),
        (
            UniCase::ascii("burqa"),
            &[(0b11010, &ENTRY_BURKA_1159530484671088481)],
        ),
        (
            UniCase::ascii("hyperglycemic"),
            &[(0b10001, &ENTRY_HYPERGLYCEMIC_2706228210156780391)],
        ),
        (
            UniCase::ascii("modalises"),
            &[(0b10010, &ENTRY_MODALIZES_16162099476273051141)],
        ),
        (
            UniCase::ascii("afrikanerisation"),
            &[(0b10010, &ENTRY_AFRIKANERIZATION_7997032707492466163)],
        ),
        (
            UniCase::ascii("penelopized"),
            &[(0b01001, &ENTRY_PENELOPIZED_16045288822105268504)],
        ),
        (
            UniCase::ascii("cyanomethaemoglobin"),
            &[(0b11010, &ENTRY_CYANOMETHEMOGLOBIN_17992938767240588113)],
        ),
        (
            UniCase::ascii("specters"),
            &[(0b00001, &ENTRY_SPECTERS_7942939111689789209)],
        ),
        (
            UniCase::ascii("womanises"),
            &[(0b10010, &ENTRY_WOMANIZES_14963203568866144583)],
        ),
        (
            UniCase::ascii("almanack"),
            &[(0b10010, &ENTRY_ALMANAC_15717861359409582720)],
        ),
        (
            UniCase::ascii("normanisations"),
            &[(0b10010, &ENTRY_NORMANIZATIONS_14581317840430300825)],
        ),
        (
            UniCase::ascii("gallantise"),
            &[(0b10010, &ENTRY_GALLANTIZE_7623840749699418706)],
        ),
        (
            UniCase::ascii("unrecognisable"),
            &[(0b10010, &ENTRY_UNRECOGNIZABLE_13177594232205592621)],
        ),
        (
            UniCase::ascii("moisturised"),
            &[(0b10010, &ENTRY_MOISTURIZED_3672738717919459176)],
        ),
        (
            UniCase::ascii("winterise"),
            &[(0b10010, &ENTRY_WINTERIZE_3955752504931726030)],
        ),
        (
            UniCase::ascii("aerographies"),
            &[(0b00001, &ENTRY_AEROGRAPHIES_11844593835635999782)],
        ),
        (
            UniCase::ascii("toryizes"),
            &[(0b01001, &ENTRY_TORYIZES_2714307057530869042)],
        ),
        (
            UniCase::ascii("secularization"),
            &[(0b01001, &ENTRY_SECULARIZATION_4665508589899729279)],
        ),
        (
            UniCase::ascii("baptiser"),
            &[(0b10010, &ENTRY_BAPTIZER_9063381427387950458)],
        ),
        (
            UniCase::ascii("plow"),
            &[(0b01001, &ENTRY_PLOW_15240143167426020265)],
        ),
        (
            UniCase::ascii("antisensitizer"),
            &[(0b01001, &ENTRY_ANTISENSITIZER_12937207493474321236)],
        ),
        (
            UniCase::ascii("stele"),
            &[(0b00001, &ENTRY_STELE_2859069730518054769)],
        ),
        (
            UniCase::ascii("enthralment"),
            &[(0b11010, &ENTRY_ENTHRALLMENT_17889486799769196724)],
        ),
        (
            UniCase::ascii("coziness"),
            &[(0b01001, &ENTRY_COZINESS_4340402800488732549)],
        ),
        (
            UniCase::ascii("ottomanizations"),
            &[(0b01001, &ENTRY_OTTOMANIZATIONS_3775785848664183204)],
        ),
        (
            UniCase::ascii("vampirizing"),
            &[(0b01001, &ENTRY_VAMPIRIZING_5067863975594369914)],
        ),
        (
            UniCase::ascii("cocainized"),
            &[(0b01001, &ENTRY_COCAINIZED_11738928114927355282)],
        ),
        (
            UniCase::ascii("mythologized"),
            &[(0b01001, &ENTRY_MYTHOLOGIZED_7891244640375123566)],
        ),
        (
            UniCase::ascii("gyrostabilisation"),
            &[(0b10010, &ENTRY_GYROSTABILIZATION_7444180417440707528)],
        ),
        (
            UniCase::ascii("crenellation"),
            &[(0b11010, &ENTRY_CRENELATION_1079785305940612588)],
        ),
        (
            UniCase::ascii("musicalised"),
            &[(0b10010, &ENTRY_MUSICALIZED_1534933012029862697)],
        ),
        (
            UniCase::ascii("barreling"),
            &[(0b00001, &ENTRY_BARRELING_14371038101917122463)],
        ),
        (
            UniCase::ascii("equalled"),
            &[(0b11010, &ENTRY_EQUALED_8356361230889842625)],
        ),
        (
            UniCase::ascii("hematid"),
            &[(0b10001, &ENTRY_HEMATID_5688919815724817461)],
        ),
        (
            UniCase::ascii("frictionise"),
            &[(0b10010, &ENTRY_FRICTIONIZE_8871056937955154076)],
        ),
        (
            UniCase::ascii("herborizes"),
            &[(0b01001, &ENTRY_HERBORIZES_18049858840826246838)],
        ),
        (
            UniCase::ascii("unmodernisedder"),
            &[(0b10010, &ENTRY_UNMODERNIZEDDER_17177773102034890156)],
        ),
        (
            UniCase::ascii("carbolising"),
            &[(0b10010, &ENTRY_CARBOLIZING_10944405222501443697)],
        ),
        (
            UniCase::ascii("externalised"),
            &[(0b10010, &ENTRY_EXTERNALIZED_595019063900238343)],
        ),
        (
            UniCase::ascii("marvellouser"),
            &[(0b11010, &ENTRY_MARVELOUSER_9300773522759351631)],
        ),
        (
            UniCase::ascii("rhoeadine"),
            &[(0b11010, &ENTRY_RHEADINE_9620364319130309940)],
        ),
        (
            UniCase::ascii("tartarised"),
            &[(0b10010, &ENTRY_TARTARIZED_531821600819631957)],
        ),
        (
            UniCase::ascii("semimercerised"),
            &[(0b10010, &ENTRY_SEMIMERCERIZED_7395245349141510735)],
        ),
        (
            UniCase::ascii("industrialization"),
            &[(0b01001, &ENTRY_INDUSTRIALIZATION_3782509534748207782)],
        ),
        (
            UniCase::ascii("elaeoblast"),
            &[(0b11010, &ENTRY_ELEOBLAST_8021023369296032808)],
        ),
        (
            UniCase::ascii("mylonitised"),
            &[(0b10010, &ENTRY_MYLONITIZED_1836771186609206852)],
        ),
        (
            UniCase::ascii("unvisualized"),
            &[(0b01001, &ENTRY_UNVISUALIZED_2776258560824841456)],
        ),
        (
            UniCase::ascii("grecizes"),
            &[(0b01001, &ENTRY_GRECIZES_7044331661038018107)],
        ),
        (
            UniCase::ascii("penalisation"),
            &[(0b10010, &ENTRY_PENALIZATION_17360891794071301320)],
        ),
        (
            UniCase::ascii("doctorisation"),
            &[(0b10010, &ENTRY_DOCTORIZATION_16033729298032621232)],
        ),
        (
            UniCase::ascii("prese"),
            &[(0b11010, &ENTRY_PERSE_2874440396224431051)],
        ),
        (
            UniCase::ascii("urinemic"),
            &[(0b00001, &ENTRY_URINEMIC_3826715010964749488)],
        ),
        (
            UniCase::ascii("foetalism"),
            &[(0b10010, &ENTRY_FETALISM_13684319792675234496)],
        ),
        (
            UniCase::ascii("uricemia"),
            &[(0b00001, &ENTRY_URICEMIA_735304459969707353)],
        ),
        (
            UniCase::ascii("overcivilize"),
            &[(0b01001, &ENTRY_OVERCIVILIZE_4956758060913570060)],
        ),
        (
            UniCase::ascii("contextualise"),
            &[(0b10010, &ENTRY_CONTEXTUALIZE_4584369818380473712)],
        ),
        (
            UniCase::ascii("criticized"),
            &[(0b01001, &ENTRY_CRITICIZED_11062690254551858674)],
        ),
        (
            UniCase::ascii("mendelize"),
            &[(0b01001, &ENTRY_MENDELIZE_13155598837739586689)],
        ),
        (
            UniCase::ascii("byronize"),
            &[(0b01001, &ENTRY_BYRONIZE_12114867653355624724)],
        ),
        (
            UniCase::ascii("draughtswoman"),
            &[(0b10010, &ENTRY_DRAFTSWOMAN_13749770471062736806)],
        ),
        (
            UniCase::ascii("hattizes"),
            &[(0b01001, &ENTRY_HATTIZES_2400340849510871993)],
        ),
        (
            UniCase::ascii("unstigmatisedder"),
            &[(0b10010, &ENTRY_UNSTIGMATIZEDDER_12103644335044897212)],
        ),
        (
            UniCase::ascii("demoralizes"),
            &[(0b01001, &ENTRY_DEMORALIZES_6517352001271737987)],
        ),
        (
            UniCase::ascii("aryanizing"),
            &[(0b01001, &ENTRY_ARYANIZING_14999690626685964985)],
        ),
        (
            UniCase::ascii("outhumors"),
            &[(0b10001, &ENTRY_OUTHUMORS_12478246544150481705)],
        ),
        (
            UniCase::ascii("parametrises"),
            &[(0b10010, &ENTRY_PARAMETRIZES_15875840276606359299)],
        ),
        (
            UniCase::ascii("indigenization"),
            &[(0b01001, &ENTRY_INDIGENIZATION_7957795492779097437)],
        ),
        (
            UniCase::ascii("mobilizables"),
            &[(0b01001, &ENTRY_MOBILIZABLES_4178976069735614840)],
        ),
        (
            UniCase::ascii("ammoniaemia"),
            &[(0b11010, &ENTRY_AMMONIEMIA_12378710937857988312)],
        ),
        (
            UniCase::ascii("parabolized"),
            &[(0b01001, &ENTRY_PARABOLIZED_16123534121411965653)],
        ),
        (
            UniCase::ascii("platinizations"),
            &[(0b01001, &ENTRY_PLATINIZATIONS_15552354246238607901)],
        ),
        (
            UniCase::ascii("humorers"),
            &[(0b11001, &ENTRY_HUMORERS_11361453604963756719)],
        ),
        (
            UniCase::ascii("epistolise"),
            &[(0b10010, &ENTRY_EPISTOLIZE_12798380956553546634)],
        ),
        (
            UniCase::ascii("pectise"),
            &[(0b10010, &ENTRY_PECTIZE_5412505057526179714)],
        ),
        (
            UniCase::ascii("erythraean"),
            &[(0b11010, &ENTRY_ERYTHREAN_10329526815525592119)],
        ),
        (
            UniCase::ascii("schedulizes"),
            &[(0b01001, &ENTRY_SCHEDULIZES_11998681560108042990)],
        ),
        (
            UniCase::ascii("eventualised"),
            &[(0b10010, &ENTRY_EVENTUALIZED_6892945154115451414)],
        ),
        (
            UniCase::ascii("arithmetization"),
            &[(0b01001, &ENTRY_ARITHMETIZATION_10054898680334010685)],
        ),
        (
            UniCase::ascii("pressurising"),
            &[(0b10010, &ENTRY_PRESSURIZING_920510292816130320)],
        ),
        (
            UniCase::ascii("synonymized"),
            &[(0b01001, &ENTRY_SYNONYMIZED_16655983300964530292)],
        ),
        (
            UniCase::ascii("unmonopolize"),
            &[(0b01001, &ENTRY_UNMONOPOLIZE_8209609104862396740)],
        ),
        (
            UniCase::ascii("mineralized"),
            &[(0b01001, &ENTRY_MINERALIZED_15703772425518702501)],
        ),
        (
            UniCase::ascii("hyperthyroidises"),
            &[(0b10010, &ENTRY_HYPERTHYROIDIZES_16533830875218158099)],
        ),
        (
            UniCase::ascii("kaolinises"),
            &[(0b10010, &ENTRY_KAOLINIZES_6007210570575095960)],
        ),
        (
            UniCase::ascii("teutonize"),
            &[(0b01001, &ENTRY_TEUTONIZE_2326197985184920584)],
        ),
        (
            UniCase::ascii("pragmatizing"),
            &[(0b01001, &ENTRY_PRAGMATIZING_5484672503035338428)],
        ),
        (
            UniCase::ascii("ptyalized"),
            &[(0b01001, &ENTRY_PTYALIZED_14737891637486973456)],
        ),
        (
            UniCase::ascii("velarises"),
            &[(0b10010, &ENTRY_VELARIZES_7541885077312241167)],
        ),
        (
            UniCase::ascii("idiotise"),
            &[(0b10010, &ENTRY_IDIOTIZE_1684624828093976331)],
        ),
        (
            UniCase::ascii("exaestuate"),
            &[(0b11010, &ENTRY_EXESTUATE_9637260798228903273)],
        ),
        (
            UniCase::ascii("colorabilities"),
            &[(0b11001, &ENTRY_COLORABILITIES_17934830495879279238)],
        ),
        (
            UniCase::ascii("gallisize"),
            &[(0b01001, &ENTRY_GALLISIZE_7892805864302635869)],
        ),
        (
            UniCase::ascii("sluggardised"),
            &[(0b10010, &ENTRY_SLUGGARDIZED_7217161359617146286)],
        ),
        (
            UniCase::ascii("cataloguized"),
            &[(0b01001, &ENTRY_CATALOGUIZED_4476989929563164358)],
        ),
        (
            UniCase::ascii("federalization"),
            &[(0b01001, &ENTRY_FEDERALIZATION_2999038236760622034)],
        ),
        (
            UniCase::ascii("prioritized"),
            &[(0b01001, &ENTRY_PRIORITIZED_18023070841869180732)],
        ),
        (
            UniCase::ascii("foetider"),
            &[(0b10010, &ENTRY_FETIDER_5915159455988754255)],
        ),
        (
            UniCase::ascii("amalgamatizes"),
            &[(0b01001, &ENTRY_AMALGAMATIZES_11197265529776604273)],
        ),
        (
            UniCase::ascii("pederastic"),
            &[(0b00001, &ENTRY_PEDERASTIC_17115437534756487424)],
        ),
        (
            UniCase::ascii("chequerboards"),
            &[(0b11010, &ENTRY_CHECKERBOARDS_18064653792576628856)],
        ),
        (
            UniCase::ascii("philtres"),
            &[(0b11010, &ENTRY_PHILTERS_13502292058065280597)],
        ),
        (
            UniCase::ascii("lichenised"),
            &[(0b10010, &ENTRY_LICHENIZED_9848778117506730557)],
        ),
        (
            UniCase::ascii("nitrogenize"),
            &[(0b01001, &ENTRY_NITROGENIZE_16291478229609855163)],
        ),
        (
            UniCase::ascii("microscopise"),
            &[(0b10010, &ENTRY_MICROSCOPIZE_9785839938855486861)],
        ),
        (
            UniCase::ascii("recarbonizations"),
            &[(0b01001, &ENTRY_RECARBONIZATIONS_17520317422251898259)],
        ),
        (
            UniCase::ascii("disorganising"),
            &[(0b10010, &ENTRY_DISORGANIZING_3512715266110397978)],
        ),
        (
            UniCase::ascii("rigidised"),
            &[(0b10010, &ENTRY_RIGIDIZED_2511443842946442888)],
        ),
        (
            UniCase::ascii("outtyrannise"),
            &[(0b10010, &ENTRY_OUTTYRANNIZE_4884886326342063919)],
        ),
        (
            UniCase::ascii("pedestrianising"),
            &[(0b10010, &ENTRY_PEDESTRIANIZING_6787761233409265782)],
        ),
        (
            UniCase::ascii("nebularization"),
            &[(0b01001, &ENTRY_NEBULARIZATION_1442476582031071023)],
        ),
        (
            UniCase::ascii("electrodialyses"),
            &[(0b11010, &ENTRY_ELECTRODIALYZES_3747563092652406931)],
        ),
        (
            UniCase::ascii("ratite"),
            &[(0b00001, &ENTRY_RATITE_17526384648991858474)],
        ),
        (
            UniCase::ascii("ruble"),
            &[(0b00001, &ENTRY_RUBLE_10117878449438778810)],
        ),
        (
            UniCase::ascii("unhypnotise"),
            &[(0b10010, &ENTRY_UNHYPNOTIZE_3076842320349928553)],
        ),
        (
            UniCase::ascii("pollinise"),
            &[(0b10010, &ENTRY_POLLINIZE_10886640222621907817)],
        ),
        (
            UniCase::ascii("haematoma"),
            &[(0b11010, &ENTRY_HEMATOMA_13408617756828997822)],
        ),
        (
            UniCase::ascii("temporizinglier"),
            &[(0b01001, &ENTRY_TEMPORIZINGLIER_6355354281150226976)],
        ),
        (
            UniCase::ascii("overcoloring"),
            &[(0b10001, &ENTRY_OVERCOLORING_1527032230883157274)],
        ),
        (
            UniCase::ascii("epitomiser"),
            &[(0b10010, &ENTRY_EPITOMIZER_8562118215235688018)],
        ),
        (
            UniCase::ascii("hypocentre"),
            &[(0b11010, &ENTRY_HYPOCENTER_10924617547082167348)],
        ),
        (
            UniCase::ascii("colorrhaphy"),
            &[(0b00001, &ENTRY_COLORRHAPHY_13136665400257945176)],
        ),
        (
            UniCase::ascii("sabbathises"),
            &[(0b10010, &ENTRY_SABBATHIZES_14657735120604873546)],
        ),
        (
            UniCase::ascii("juvenilizes"),
            &[(0b01001, &ENTRY_JUVENILIZES_429993400308407468)],
        ),
        (
            UniCase::ascii("ovalizes"),
            &[(0b01001, &ENTRY_OVALIZES_17889836495909704940)],
        ),
        (
            UniCase::ascii("reoxygenize"),
            &[(0b01001, &ENTRY_REOXYGENIZE_6926836183647945085)],
        ),
        (
            UniCase::ascii("fiberscopes"),
            &[(0b00001, &ENTRY_FIBERSCOPES_5722286864782871846)],
        ),
        (
            UniCase::ascii("centrifugalized"),
            &[(0b01001, &ENTRY_CENTRIFUGALIZED_16399570134709120738)],
        ),
        (
            UniCase::ascii("orthopedicalliest"),
            &[(0b10001, &ENTRY_ORTHOPEDICALLIEST_17074628747614047566)],
        ),
        (
            UniCase::ascii("empaneling"),
            &[(0b00001, &ENTRY_IMPANELING_8436697861195228668)],
        ),
        (
            UniCase::ascii("praecordia"),
            &[(0b11010, &ENTRY_PRECORDIA_1238253163440816627)],
        ),
        (
            UniCase::ascii("diphthongizations"),
            &[(0b01001, &ENTRY_DIPHTHONGIZATIONS_3965346305488551771)],
        ),
        (
            UniCase::ascii("honourableship"),
            &[(0b11010, &ENTRY_HONORABLESHIP_16239512951229580872)],
        ),
        (
            UniCase::ascii("unstigmatizedder"),
            &[(0b01001, &ENTRY_UNSTIGMATIZEDDER_12103644335044897212)],
        ),
        (
            UniCase::ascii("enocyte"),
            &[(0b00001, &ENTRY_ENOCYTE_5031071790616444705)],
        ),
        (
            UniCase::ascii("logicalize"),
            &[(0b01001, &ENTRY_LOGICALIZE_2176872405258834372)],
        ),
        (
            UniCase::ascii("ventriloquising"),
            &[(0b10010, &ENTRY_VENTRILOQUIZING_16373058130648158850)],
        ),
        (
            UniCase::ascii("bevelings"),
            &[(0b01001, &ENTRY_BEVELINGS_2452856377064833303)],
        ),
        (
            UniCase::ascii("labouring"),
            &[(0b11010, &ENTRY_LABORING_9545557393231100138)],
        ),
        (
            UniCase::ascii("saviorship"),
            &[(0b11001, &ENTRY_SAVIORSHIP_2762957268664282572)],
        ),
        (
            UniCase::ascii("quae"),
            &[(0b11010, &ENTRY_QUE_13586725649236549292)],
        ),
        (
            UniCase::ascii("metalize"),
            &[(0b00001, &ENTRY_METALIZE_10265648959816292880)],
        ),
        (
            UniCase::ascii("iranise"),
            &[(0b10010, &ENTRY_IRANIZE_14984518848921394539)],
        ),
        (
            UniCase::ascii("grangerising"),
            &[(0b10010, &ENTRY_GRANGERIZING_12003554918644431898)],
        ),
        (
            UniCase::ascii("unmunicipalisedder"),
            &[(0b10010, &ENTRY_UNMUNICIPALIZEDDER_308188906530115010)],
        ),
        (
            UniCase::ascii("mandore"),
            &[(0b11010, &ENTRY_MANDOER_1848218089972389391)],
        ),
        (
            UniCase::ascii("demoralisers"),
            &[(0b10010, &ENTRY_DEMORALIZERS_600938080037133255)],
        ),
        (
            UniCase::ascii("muscularizes"),
            &[(0b01001, &ENTRY_MUSCULARIZES_10614722597220369532)],
        ),
        (
            UniCase::ascii("deracialising"),
            &[(0b10010, &ENTRY_DERACIALIZING_14275754837816585059)],
        ),
        (
            UniCase::ascii("paralyse"),
            &[(0b11010, &ENTRY_PARALYZE_4857352680562257186)],
        ),
        (
            UniCase::ascii("miscolours"),
            &[(0b11010, &ENTRY_MISCOLORS_6442863367431484314)],
        ),
        (
            UniCase::ascii("naturalisation"),
            &[(0b10010, &ENTRY_NATURALIZATION_13649717526845265802)],
        ),
        (
            UniCase::ascii("arabicise"),
            &[(0b10010, &ENTRY_ARABICIZE_7118455398303530058)],
        ),
        (
            UniCase::ascii("deputization"),
            &[(0b01001, &ENTRY_DEPUTIZATION_1712123122893688078)],
        ),
        (
            UniCase::ascii("apothegmatise"),
            &[(0b10010, &ENTRY_APOTHEGMATIZE_9149577190229122350)],
        ),
        (
            UniCase::ascii("mercerized"),
            &[(0b01001, &ENTRY_MERCERIZED_12441200842633397226)],
        ),
        (
            UniCase::ascii("pulverisers"),
            &[(0b10010, &ENTRY_PULVERIZERS_7182805923294437318)],
        ),
        (
            UniCase::ascii("culicide"),
            &[(0b00001, &ENTRY_CULICIDE_539049738338426871)],
        ),
        (
            UniCase::ascii("phagedenic"),
            &[(0b00001, &ENTRY_PHAGEDENIC_17318315545560183857)],
        ),
        (
            UniCase::ascii("fibrefills"),
            &[(0b11010, &ENTRY_FIBERFILLS_10714754498813286510)],
        ),
        (
            UniCase::ascii("colourbreed"),
            &[(0b11010, &ENTRY_COLORBREED_988623603127049866)],
        ),
        (
            UniCase::ascii("ruffianize"),
            &[(0b01001, &ENTRY_RUFFIANIZE_17407878081648774516)],
        ),
        (
            UniCase::ascii("valors"),
            &[(0b11001, &ENTRY_VALORS_12937983727743095167)],
        ),
        (
            UniCase::ascii("favoringlier"),
            &[(0b11001, &ENTRY_FAVORINGLIER_13234382898335132498)],
        ),
        (
            UniCase::ascii("rebaptized"),
            &[(0b01001, &ENTRY_REBAPTIZED_7549343503873914730)],
        ),
        (
            UniCase::ascii("potentizes"),
            &[(0b01001, &ENTRY_POTENTIZES_1694669823229591466)],
        ),
        (
            UniCase::ascii("cyclising"),
            &[(0b10010, &ENTRY_CYCLIZING_8867677036457804725)],
        ),
        (
            UniCase::ascii("stower"),
            &[(0b00001, &ENTRY_STOWER_3427925530344361004)],
        ),
        (
            UniCase::ascii("sinicise"),
            &[(0b10010, &ENTRY_SINICIZE_5519781244176228688)],
        ),
        (
            UniCase::ascii("fiberlessest"),
            &[(0b00001, &ENTRY_FIBERLESSEST_6306196796958857387)],
        ),
        (
            UniCase::ascii("owercome"),
            &[(0b00001, &ENTRY_OWERCOME_7825693961556665659)],
        ),
        (
            UniCase::ascii("hucksterise"),
            &[(0b10010, &ENTRY_HUCKSTERIZE_13308151300872354760)],
        ),
        (
            UniCase::ascii("palletised"),
            &[(0b10010, &ENTRY_PALLETIZED_12902140764229882038)],
        ),
        (
            UniCase::ascii("doweler"),
            &[(0b00001, &ENTRY_DOWELER_14640077182615108914)],
        ),
        (
            UniCase::ascii("apologized"),
            &[(0b01001, &ENTRY_APOLOGIZED_766769648963130203)],
        ),
        (
            UniCase::ascii("abridgement"),
            &[(0b11010, &ENTRY_ABRIDGMENT_12609101589412407813)],
        ),
        (
            UniCase::ascii("desulphurises"),
            &[(0b10010, &ENTRY_DESULFURIZES_1197207125684665875)],
        ),
        (
            UniCase::ascii("disillusionized"),
            &[(0b01001, &ENTRY_DISILLUSIONIZED_9985249129164082054)],
        ),
        (
            UniCase::ascii("arborized"),
            &[(0b01001, &ENTRY_ARBORIZED_10511833189104814553)],
        ),
        (
            UniCase::ascii("alternize"),
            &[(0b01001, &ENTRY_ALTERNIZE_285767739893718525)],
        ),
        (
            UniCase::ascii("texturising"),
            &[(0b10010, &ENTRY_TEXTURIZING_12707124326299442433)],
        ),
        (
            UniCase::ascii("nationalise"),
            &[(0b10010, &ENTRY_NATIONALIZE_3677566152660435624)],
        ),
        (
            UniCase::ascii("depoliticizes"),
            &[(0b01001, &ENTRY_DEPOLITICIZES_17679110590239399087)],
        ),
        (
            UniCase::ascii("pretorium"),
            &[(0b00001, &ENTRY_PRETORIUM_1712722934465958271)],
        ),
        (
            UniCase::ascii("cigaret"),
            &[(0b00001, &ENTRY_CIGARETTE_3240954964785468511)],
        ),
        (
            UniCase::ascii("facsimilizes"),
            &[(0b01001, &ENTRY_FACSIMILIZES_13852505000433399295)],
        ),
        (
            UniCase::ascii("hypostasizing"),
            &[(0b01001, &ENTRY_HYPOSTASIZING_4036380769759199422)],
        ),
        (
            UniCase::ascii("hybridization"),
            &[(0b01001, &ENTRY_HYBRIDIZATION_161986988115386392)],
        ),
        (
            UniCase::ascii("parabolises"),
            &[(0b10010, &ENTRY_PARABOLIZES_7112996769899442233)],
        ),
        (
            UniCase::ascii("accessorises"),
            &[(0b10010, &ENTRY_ACCESSORIZES_15659000820256764933)],
        ),
        (
            UniCase::ascii("dramatisables"),
            &[(0b10010, &ENTRY_DRAMATIZABLES_12929019439166166978)],
        ),
        (
            UniCase::ascii("hygienisation"),
            &[(0b10010, &ENTRY_HYGIENIZATION_625023551255960285)],
        ),
        (
            UniCase::ascii("plowmen"),
            &[(0b01001, &ENTRY_PLOWMEN_15058389578896302329)],
        ),
        (
            UniCase::ascii("authorize"),
            &[(0b01001, &ENTRY_AUTHORIZE_12314763752837557145)],
        ),
        (
            UniCase::ascii("repaganizers"),
            &[(0b01001, &ENTRY_REPAGANIZERS_1945767306900866182)],
        ),
        (
            UniCase::ascii("neogeic"),
            &[(0b00001, &ENTRY_NEOGEIC_15111494082202179702)],
        ),
        (
            UniCase::ascii("dioptres"),
            &[(0b11010, &ENTRY_DIOPTERS_516947549353623981)],
        ),
        (
            UniCase::ascii("lexicalization"),
            &[(0b01001, &ENTRY_LEXICALIZATION_17354516794688165566)],
        ),
        (
            UniCase::ascii("demagnetization"),
            &[(0b01001, &ENTRY_DEMAGNETIZATION_10848943172388045538)],
        ),
        (
            UniCase::ascii("schematizer"),
            &[(0b01001, &ENTRY_SCHEMATIZER_5371535585135012777)],
        ),
        (
            UniCase::ascii("compartmentalize"),
            &[(0b01001, &ENTRY_COMPARTMENTALIZE_6316599424281105903)],
        ),
        (
            UniCase::ascii("vitaminized"),
            &[(0b01001, &ENTRY_VITAMINIZED_11070966012909977792)],
        ),
        (
            UniCase::ascii("deindustrializations"),
            &[(0b01001, &ENTRY_DEINDUSTRIALIZATIONS_15910460441488223406)],
        ),
        (
            UniCase::ascii("hebraization"),
            &[(0b01001, &ENTRY_HEBRAIZATION_8649165272409155064)],
        ),
        (
            UniCase::ascii("gospellers"),
            &[(0b11010, &ENTRY_GOSPELERS_15768484320655667045)],
        ),
        (
            UniCase::ascii("entomologising"),
            &[(0b10010, &ENTRY_ENTOMOLOGIZING_541087590579894951)],
        ),
        (
            UniCase::ascii("unfamiliariseddest"),
            &[(0b10010, &ENTRY_UNFAMILIARIZEDDEST_4018673522303778898)],
        ),
        (
            UniCase::ascii("disillusionised"),
            &[(0b10010, &ENTRY_DISILLUSIONIZED_9985249129164082054)],
        ),
        (
            UniCase::ascii("poeticized"),
            &[(0b01001, &ENTRY_POETICIZED_12390573338020882499)],
        ),
        (
            UniCase::ascii("anaesthetization"),
            &[(0b01000, &ENTRY_ANESTHETIZATION_11701429006232412151)],
        ),
        (
            UniCase::ascii("epigrammatised"),
            &[(0b10010, &ENTRY_EPIGRAMMATIZED_3366561652151146715)],
        ),
        (
            UniCase::ascii("laconizing"),
            &[(0b01001, &ENTRY_LACONIZING_15917635164362459543)],
        ),
        (
            UniCase::ascii("stigmatisations"),
            &[(0b10010, &ENTRY_STIGMATIZATIONS_5206308770780618928)],
        ),
        (
            UniCase::ascii("iridectomising"),
            &[(0b10010, &ENTRY_IRIDECTOMIZING_3730176016492424041)],
        ),
        (
            UniCase::ascii("phelonion"),
            &[(0b00001, &ENTRY_PHELONION_6969396090547227356)],
        ),
        (
            UniCase::ascii("scenarioisations"),
            &[(0b10010, &ENTRY_SCENARIOIZATIONS_5354132606433153264)],
        ),
        (
            UniCase::ascii("substantivize"),
            &[(0b01001, &ENTRY_SUBSTANTIVIZE_13021735481609078621)],
        ),
        (
            UniCase::ascii("defencelesslier"),
            &[(0b11010, &ENTRY_DEFENSELESSLIER_16858376230646568189)],
        ),
        (
            UniCase::ascii("amortises"),
            &[(0b10010, &ENTRY_AMORTIZES_18292533417191526171)],
        ),
        (
            UniCase::ascii("infamonizes"),
            &[(0b01001, &ENTRY_INFAMONIZES_828661709748784693)],
        ),
        (
            UniCase::ascii("testimonialises"),
            &[(0b10010, &ENTRY_TESTIMONIALIZES_10551210801248918911)],
        ),
        (
            UniCase::ascii("anaesthesias"),
            &[(0b11010, &ENTRY_ANESTHESIAS_9838908694750944673)],
        ),
        (
            UniCase::ascii("disnaturalizations"),
            &[(0b01001, &ENTRY_DISNATURALIZATIONS_10342585743158502872)],
        ),
        (
            UniCase::ascii("nebuliser"),
            &[(0b10010, &ENTRY_NEBULIZER_7516977077379919232)],
        ),
        (
            UniCase::ascii("cannibalises"),
            &[(0b10010, &ENTRY_CANNIBALIZES_7622852839420143979)],
        ),
        (
            UniCase::ascii("paleolithic"),
            &[(0b11001, &ENTRY_PALEOLITHIC_9773849440157812866)],
        ),
        (
            UniCase::ascii("tropicalised"),
            &[(0b10010, &ENTRY_TROPICALIZED_12626126161696724783)],
        ),
        (
            UniCase::ascii("pindarise"),
            &[(0b10010, &ENTRY_PINDARIZE_3371672470278825880)],
        ),
        (
            UniCase::ascii("colonising"),
            &[(0b10010, &ENTRY_COLONIZING_17297511401074881747)],
        ),
        (
            UniCase::ascii("caesarise"),
            &[(0b10010, &ENTRY_CAESARIZE_5575641651919740489)],
        ),
        (
            UniCase::ascii("regionalisations"),
            &[(0b10010, &ENTRY_REGIONALIZATIONS_17188055835713620803)],
        ),
        (
            UniCase::ascii("tractorisation"),
            &[(0b10010, &ENTRY_TRACTORIZATION_3823073726188841416)],
        ),
        (
            UniCase::ascii("sluggardizes"),
            &[(0b01001, &ENTRY_SLUGGARDIZES_2193421694271241177)],
        ),
        (
            UniCase::ascii("uncatholicising"),
            &[(0b10010, &ENTRY_UNCATHOLICIZING_9453674520447775815)],
        ),
        (
            UniCase::ascii("orthopedist"),
            &[(0b10001, &ENTRY_ORTHOPEDIST_5359875151039183204)],
        ),
        (
            UniCase::ascii("memorization"),
            &[(0b01001, &ENTRY_MEMORIZATION_11518051927242789602)],
        ),
        (
            UniCase::ascii("hyperinsulinisations"),
            &[(0b10010, &ENTRY_HYPERINSULINIZATIONS_10721167808286232537)],
        ),
        (
            UniCase::ascii("millilitre"),
            &[(0b11010, &ENTRY_MILLILITER_12944386636303269905)],
        ),
        (
            UniCase::ascii("favoress"),
            &[(0b11001, &ENTRY_FAVORESS_10320527329712113257)],
        ),
        (
            UniCase::ascii("oratorize"),
            &[(0b01001, &ENTRY_ORATORIZE_10763244403747894729)],
        ),
        (
            UniCase::ascii("retinize"),
            &[(0b01001, &ENTRY_RETINIZE_8601446109320109567)],
        ),
        (
            UniCase::ascii("anesthetists"),
            &[(0b11001, &ENTRY_ANESTHETISTS_8741608628280855523)],
        ),
        (
            UniCase::ascii("laevogyrate"),
            &[(0b11010, &ENTRY_LEVOGYRATE_6763119482929043236)],
        ),
        (
            UniCase::ascii("ghettoizes"),
            &[(0b01001, &ENTRY_GHETTOIZES_13127566176097583611)],
        ),
        (
            UniCase::ascii("bureaucratizations"),
            &[(0b01001, &ENTRY_BUREAUCRATIZATIONS_4497039635998929992)],
        ),
        (
            UniCase::ascii("nonsensitizeds"),
            &[(0b01001, &ENTRY_NONSENSITIZEDS_6789040092514022355)],
        ),
        (
            UniCase::ascii("carbonising"),
            &[(0b10010, &ENTRY_CARBONIZING_6968560222274215193)],
        ),
        (
            UniCase::ascii("immortalisations"),
            &[(0b10010, &ENTRY_IMMORTALIZATIONS_15664742949388054394)],
        ),
        (
            UniCase::ascii("questorship"),
            &[(0b00001, &ENTRY_QUESTORSHIP_6181167330242868713)],
        ),
        (
            UniCase::ascii("reorganises"),
            &[(0b10010, &ENTRY_REORGANIZES_3740948184951472727)],
        ),
        (
            UniCase::ascii("naturalize"),
            &[(0b01001, &ENTRY_NATURALIZE_9796455531783123727)],
        ),
        (
            UniCase::ascii("mustached"),
            &[(0b00001, &ENTRY_MUSTACHED_2206075060724165943)],
        ),
        (
            UniCase::ascii("autotoxemia"),
            &[(0b00001, &ENTRY_AUTOTOXEMIA_18366267511576797743)],
        ),
        (
            UniCase::ascii("unmonopolises"),
            &[(0b10010, &ENTRY_UNMONOPOLIZES_8604670551607021504)],
        ),
        (
            UniCase::ascii("soe"),
            &[(0b11010, &ENTRY_SE_15361672265999879694)],
        ),
        (
            UniCase::ascii("pelletisations"),
            &[(0b10010, &ENTRY_PELLETIZATIONS_1053842567457998907)],
        ),
        (
            UniCase::ascii("sulphurize"),
            &[(0b01000, &ENTRY_SULFURIZE_6207811143838647915)],
        ),
        (
            UniCase::ascii("scrutinisation"),
            &[(0b10010, &ENTRY_SCRUTINIZATION_17415762227653222410)],
        ),
        (
            UniCase::ascii("honourability"),
            &[(0b11010, &ENTRY_HONORABILITY_12580589027472191611)],
        ),
        (
            UniCase::ascii("glutaeal"),
            &[(0b11010, &ENTRY_GLUTEAL_13945486219027643389)],
        ),
        (
            UniCase::ascii("jacobinized"),
            &[(0b01001, &ENTRY_JACOBINIZED_2692791121160783021)],
        ),
        (
            UniCase::ascii("nonesthetic"),
            &[(0b00001, &ENTRY_NONESTHETIC_1208061013275115321)],
        ),
        (
            UniCase::ascii("subsidizers"),
            &[(0b01001, &ENTRY_SUBSIDIZERS_10377554586473479765)],
        ),
        (
            UniCase::ascii("contemporising"),
            &[(0b10010, &ENTRY_CONTEMPORIZING_6045892075236219913)],
        ),
        (
            UniCase::ascii("acroaesthesia"),
            &[(0b11010, &ENTRY_ACROESTHESIA_8308136510880851740)],
        ),
        (
            UniCase::ascii("overwomanize"),
            &[(0b01001, &ENTRY_OVERWOMANIZE_200946611941560951)],
        ),
        (
            UniCase::ascii("hypnotisable"),
            &[(0b10010, &ENTRY_HYPNOTIZABLE_16992601341623152607)],
        ),
        (
            UniCase::ascii("generalisers"),
            &[(0b10010, &ENTRY_GENERALIZERS_2408957385743792554)],
        ),
        (
            UniCase::ascii("brutalisation"),
            &[(0b10010, &ENTRY_BRUTALIZATION_5823277448598256026)],
        ),
        (
            UniCase::ascii("feminising"),
            &[(0b10010, &ENTRY_FEMINIZING_4796004961681233661)],
        ),
        (
            UniCase::ascii("pedestrianisation"),
            &[(0b10010, &ENTRY_PEDESTRIANIZATION_6831974054939138972)],
        ),
        (
            UniCase::ascii("hellenize"),
            &[(0b01001, &ENTRY_HELLENIZE_423650469605584095)],
        ),
        (
            UniCase::ascii("satirisers"),
            &[(0b10010, &ENTRY_SATIRIZERS_15574884911196071567)],
        ),
        (
            UniCase::ascii("anticentralisations"),
            &[(0b10010, &ENTRY_ANTICENTRALIZATIONS_13464164849647372934)],
        ),
        (
            UniCase::ascii("martyrised"),
            &[(0b10010, &ENTRY_MARTYRIZED_4832114212229439073)],
        ),
        (
            UniCase::ascii("tylerize"),
            &[(0b01001, &ENTRY_TYLERIZE_6772047772391841205)],
        ),
        (
            UniCase::ascii("stylisation"),
            &[(0b10010, &ENTRY_STYLIZATION_15244694173883242713)],
        ),
        (
            UniCase::ascii("empathized"),
            &[(0b01001, &ENTRY_EMPATHIZED_14314991802693364328)],
        ),
        (
            UniCase::ascii("aluminization"),
            &[(0b01001, &ENTRY_ALUMINIZATION_18425035090862987036)],
        ),
        (
            UniCase::ascii("barbarize"),
            &[(0b01001, &ENTRY_BARBARIZE_3245642365916369243)],
        ),
        (
            UniCase::ascii("ebionising"),
            &[(0b10010, &ENTRY_EBIONIZING_6877070461214793032)],
        ),
        (
            UniCase::ascii("localizer"),
            &[(0b01001, &ENTRY_LOCALIZER_7157782650234430721)],
        ),
        (
            UniCase::ascii("unlocalizable"),
            &[(0b01001, &ENTRY_UNLOCALIZABLE_9968738969162630281)],
        ),
        (
            UniCase::ascii("schematizes"),
            &[(0b01001, &ENTRY_SCHEMATIZES_5464172182149518273)],
        ),
        (
            UniCase::ascii("persicised"),
            &[(0b10010, &ENTRY_PERSICIZED_8426958054366327606)],
        ),
        (
            UniCase::ascii("syllogizers"),
            &[(0b01001, &ENTRY_SYLLOGIZERS_16910938558367919539)],
        ),
        (
            UniCase::ascii("civilisabler"),
            &[(0b10010, &ENTRY_CIVILIZABLER_1009443025003033054)],
        ),
        (
            UniCase::ascii("effeminatises"),
            &[(0b10010, &ENTRY_EFFEMINATIZES_10162259315067828496)],
        ),
        (
            UniCase::ascii("dolomitizations"),
            &[(0b01001, &ENTRY_DOLOMITIZATIONS_14772713962775924448)],
        ),
        (
            UniCase::ascii("precavae"),
            &[(0b00001, &ENTRY_PRECAVAE_5572444235139095890)],
        ),
        (
            UniCase::ascii("palaeogenetic"),
            &[(0b11010, &ENTRY_PALEOGENETIC_1015196132875105067)],
        ),
        (
            UniCase::ascii("factorized"),
            &[(0b01001, &ENTRY_FACTORIZED_15433924875237664508)],
        ),
        (
            UniCase::ascii("etiogenic"),
            &[(0b10001, &ENTRY_ETIOGENIC_4607596180327733291)],
        ),
        (
            UniCase::ascii("plebeianise"),
            &[(0b10010, &ENTRY_PLEBEIANIZE_13948307616682534202)],
        ),
        (
            UniCase::ascii("gentilization"),
            &[(0b01001, &ENTRY_GENTILIZATION_3445514503508341831)],
        ),
        (
            UniCase::ascii("unlegalised"),
            &[(0b10010, &ENTRY_UNLEGALIZED_11280366291234483355)],
        ),
        (
            UniCase::ascii("womaniser"),
            &[(0b10010, &ENTRY_WOMANIZER_17770185505558084902)],
        ),
        (
            UniCase::ascii("miniaturises"),
            &[(0b10010, &ENTRY_MINIATURIZES_16030635425775930230)],
        ),
        (
            UniCase::ascii("varicolored"),
            &[(0b01001, &ENTRY_VARICOLORED_1171542226285534602)],
        ),
        (
            UniCase::ascii("personalisation"),
            &[(0b10010, &ENTRY_PERSONALIZATION_8393077675198614709)],
        ),
        (
            UniCase::ascii("analogizing"),
            &[(0b01001, &ENTRY_ANALOGIZING_5193184992170428572)],
        ),
        (
            UniCase::ascii("couranto"),
            &[(0b11010, &ENTRY_CORANTO_4279134034163662809)],
        ),
        (
            UniCase::ascii("dysmenorrhoeal"),
            &[(0b11010, &ENTRY_DYSMENORRHEAL_3211916475354947561)],
        ),
        (
            UniCase::ascii("nonlocalizeds"),
            &[(0b01001, &ENTRY_NONLOCALIZEDS_12719123077518106411)],
        ),
        (
            UniCase::ascii("trammeller"),
            &[(0b11010, &ENTRY_TRAMMELER_1286061836358212954)],
        ),
        (
            UniCase::ascii("vaporisables"),
            &[(0b10010, &ENTRY_VAPORIZABLES_8570559686466416467)],
        ),
        (
            UniCase::ascii("soliloquizers"),
            &[(0b01001, &ENTRY_SOLILOQUIZERS_1912861598555034277)],
        ),
        (
            UniCase::ascii("nonoxidisings"),
            &[(0b10010, &ENTRY_NONOXIDIZINGS_14072069622049297509)],
        ),
        (
            UniCase::ascii("accouraging"),
            &[(0b11010, &ENTRY_ACCORAGING_15274251691846060767)],
        ),
        (
            UniCase::ascii("ochreish"),
            &[(0b11010, &ENTRY_OCHERISH_13974738456690891637)],
        ),
        (
            UniCase::ascii("jargonises"),
            &[(0b10010, &ENTRY_JARGONIZES_3262599751720795311)],
        ),
        (
            UniCase::ascii("centermost"),
            &[(0b00001, &ENTRY_CENTERMOST_14667266636773107736)],
        ),
        (
            UniCase::ascii("anonymizes"),
            &[(0b01001, &ENTRY_ANONYMIZES_8133801285918261260)],
        ),
        (
            UniCase::ascii("unplagiarizeds"),
            &[(0b01001, &ENTRY_UNPLAGIARIZEDS_17313414421594015377)],
        ),
        (
            UniCase::ascii("interiorisation"),
            &[(0b10010, &ENTRY_INTERIORIZATION_13293072248187546000)],
        ),
        (
            UniCase::ascii("hyperrealises"),
            &[(0b10010, &ENTRY_HYPERREALIZES_6087084825849447883)],
        ),
        (
            UniCase::ascii("haussmannized"),
            &[(0b01001, &ENTRY_HAUSSMANNIZED_16790530478703643375)],
        ),
        (
            UniCase::ascii("gulae"),
            &[(0b11010, &ENTRY_GULE_17891121426939931319)],
        ),
        (
            UniCase::ascii("overfavour"),
            &[(0b11010, &ENTRY_OVERFAVOR_2988640921037745317)],
        ),
        (
            UniCase::ascii("psychologized"),
            &[(0b01001, &ENTRY_PSYCHOLOGIZED_12194990558663330704)],
        ),
        (
            UniCase::ascii("channelized"),
            &[(0b01001, &ENTRY_CHANNELIZED_5009658046976798401)],
        ),
        (
            UniCase::ascii("synthesisers"),
            &[(0b11010, &ENTRY_SYNTHESIZERS_17412149831785719286)],
        ),
        (
            UniCase::ascii("oestradiol"),
            &[(0b11010, &ENTRY_ESTRADIOL_634787677538270649)],
        ),
        (
            UniCase::ascii("unscrutinizingest"),
            &[(0b01001, &ENTRY_UNSCRUTINIZINGEST_9456217512411188422)],
        ),
        (
            UniCase::ascii("metagrobolized"),
            &[(0b01001, &ENTRY_METAGROBOLIZED_7134519687053222286)],
        ),
        (
            UniCase::ascii("internalization"),
            &[(0b01001, &ENTRY_INTERNALIZATION_159848461615772073)],
        ),
        (
            UniCase::ascii("omelet"),
            &[(0b01001, &ENTRY_OMELET_7824462662732690545)],
        ),
        (
            UniCase::ascii("refertilisations"),
            &[(0b10010, &ENTRY_REFERTILIZATIONS_10209257884796898169)],
        ),
        (
            UniCase::ascii("ebionises"),
            &[(0b10010, &ENTRY_EBIONIZES_4728139485714479539)],
        ),
        (
            UniCase::ascii("repolymerize"),
            &[(0b01001, &ENTRY_REPOLYMERIZE_9036336021273167586)],
        ),
        (
            UniCase::ascii("axiomatized"),
            &[(0b01001, &ENTRY_AXIOMATIZED_13606089758225327424)],
        ),
        (
            UniCase::ascii("germanised"),
            &[(0b10010, &ENTRY_GERMANIZED_17675668489240602495)],
        ),
        (
            UniCase::ascii("hyperoxygenize"),
            &[(0b01001, &ENTRY_HYPEROXYGENIZE_14719478602723604195)],
        ),
        (
            UniCase::ascii("persicized"),
            &[(0b01001, &ENTRY_PERSICIZED_8426958054366327606)],
        ),
        (
            UniCase::ascii("dramatise"),
            &[(0b10010, &ENTRY_DRAMATIZE_11024442299136514965)],
        ),
        (
            UniCase::ascii("universalizer"),
            &[(0b01001, &ENTRY_UNIVERSALIZER_15363421758448558519)],
        ),
        (
            UniCase::ascii("iricizing"),
            &[(0b01001, &ENTRY_IRICIZING_6368473720803336644)],
        ),
        (
            UniCase::ascii("anaesthesiology"),
            &[(0b10010, &ENTRY_ANESTHESIOLOGY_1255532677711876584)],
        ),
        (
            UniCase::ascii("particularisation"),
            &[(0b10010, &ENTRY_PARTICULARIZATION_10597016863146923743)],
        ),
        (
            UniCase::ascii("bacterize"),
            &[(0b01001, &ENTRY_BACTERIZE_18408113064097816790)],
        ),
        (
            UniCase::ascii("ostracized"),
            &[(0b01001, &ENTRY_OSTRACIZED_7612075679406147400)],
        ),
        (
            UniCase::ascii("laicize"),
            &[(0b01001, &ENTRY_LAICIZE_11308741029398318200)],
        ),
        (
            UniCase::ascii("eleomargaric"),
            &[(0b00001, &ENTRY_ELEOMARGARIC_16571690257823782694)],
        ),
        (
            UniCase::ascii("dracenas"),
            &[(0b00001, &ENTRY_DRACENAS_12510578936942457083)],
        ),
        (
            UniCase::ascii("canonicalized"),
            &[(0b01001, &ENTRY_CANONICALIZED_11250167296463797072)],
        ),
        (
            UniCase::ascii("castorised"),
            &[(0b10010, &ENTRY_CASTORIZED_17799018914377706815)],
        ),
        (
            UniCase::ascii("powellized"),
            &[(0b01001, &ENTRY_POWELLIZED_12963613621406656955)],
        ),
        (
            UniCase::ascii("underrealising"),
            &[(0b10010, &ENTRY_UNDERREALIZING_17755667674781640335)],
        ),
        (
            UniCase::ascii("devitalized"),
            &[(0b01001, &ENTRY_DEVITALIZED_8717395560461798050)],
        ),
        (
            UniCase::ascii("polydemonist"),
            &[(0b00001, &ENTRY_POLYDEMONIST_2400662006979178253)],
        ),
        (
            UniCase::ascii("disharmonises"),
            &[(0b10010, &ENTRY_DISHARMONIZES_6597311294304545400)],
        ),
        (
            UniCase::ascii("hispaniolize"),
            &[(0b01001, &ENTRY_HISPANIOLIZE_12040635907161743907)],
        ),
        (
            UniCase::ascii("socratizing"),
            &[(0b01001, &ENTRY_SOCRATIZING_1982796648064876142)],
        ),
        (
            UniCase::ascii("nomadize"),
            &[(0b01001, &ENTRY_NOMADIZE_5598669829068348168)],
        ),
        (
            UniCase::ascii("unradicalizes"),
            &[(0b01001, &ENTRY_UNRADICALIZES_16426285436597116329)],
        ),
        (
            UniCase::ascii("iridised"),
            &[(0b10010, &ENTRY_IRIDIZED_7355489127205562934)],
        ),
        (
            UniCase::ascii("refuelled"),
            &[(0b11010, &ENTRY_REFUELED_6350295186272675162)],
        ),
        (
            UniCase::ascii("draftinesses"),
            &[(0b01001, &ENTRY_DRAFTINESSES_2337311124395489337)],
        ),
        (
            UniCase::ascii("testimonializations"),
            &[(0b01001, &ENTRY_TESTIMONIALIZATIONS_10414109904662561931)],
        ),
        (
            UniCase::ascii("gimbaling"),
            &[(0b00001, &ENTRY_GIMBALING_17481044329427103960)],
        ),
        (
            UniCase::ascii("snowshed"),
            &[(0b00001, &ENTRY_SNOWSHED_9651694831654123091)],
        ),
        (
            UniCase::ascii("fetor"),
            &[(0b00001, &ENTRY_FETOR_17434398877973743789)],
        ),
        (
            UniCase::ascii("haematherm"),
            &[(0b11010, &ENTRY_HEMATHERM_5926070727779344344)],
        ),
        (
            UniCase::ascii("characterised"),
            &[(0b10010, &ENTRY_CHARACTERIZED_3099918736243105904)],
        ),
        (
            UniCase::ascii("preconises"),
            &[(0b10010, &ENTRY_PRECONIZES_1119327710154936908)],
        ),
        (
            UniCase::ascii("spiralled"),
            &[(0b11010, &ENTRY_SPIRALED_4583591683626098518)],
        ),
        (
            UniCase::ascii("vulgarise"),
            &[(0b10010, &ENTRY_VULGARIZE_3593216075985714450)],
        ),
        (
            UniCase::ascii("psalmodizing"),
            &[(0b01001, &ENTRY_PSALMODIZING_16968583801346153803)],
        ),
        (
            UniCase::ascii("praeanal"),
            &[(0b11010, &ENTRY_PREANAL_8282447312000633016)],
        ),
        (
            UniCase::ascii("vectorizable"),
            &[(0b01001, &ENTRY_VECTORIZABLE_4166695678492588499)],
        ),
        (
            UniCase::ascii("maderise"),
            &[(0b10010, &ENTRY_MADERIZE_2394704387037160176)],
        ),
        (
            UniCase::ascii("oralizations"),
            &[(0b01001, &ENTRY_ORALIZATIONS_8167551586215783500)],
        ),
        (
            UniCase::ascii("constitutionalize"),
            &[(0b01001, &ENTRY_CONSTITUTIONALIZE_4750305806592443640)],
        ),
        (
            UniCase::ascii("pressurize"),
            &[(0b01001, &ENTRY_PRESSURIZE_3538034947751085670)],
        ),
        (
            UniCase::ascii("cicatrising"),
            &[(0b10010, &ENTRY_CICATRIZING_13257780105810264437)],
        ),
        (
            UniCase::ascii("civilisationaler"),
            &[(0b10010, &ENTRY_CIVILIZATIONALER_2223864160765042134)],
        ),
        (
            UniCase::ascii("venter"),
            &[(0b00001, &ENTRY_VENTER_10510516635110887923)],
        ),
        (
            UniCase::ascii("infamises"),
            &[(0b10010, &ENTRY_INFAMIZES_13859908196515724665)],
        ),
        (
            UniCase::ascii("enamoured"),
            &[(0b11010, &ENTRY_ENAMORED_16186178270973267134)],
        ),
        (
            UniCase::ascii("overdramatizing"),
            &[(0b01001, &ENTRY_OVERDRAMATIZING_14402358516227867882)],
        ),
        (
            UniCase::ascii("precolourabler"),
            &[(0b11010, &ENTRY_PRECOLORABLER_11767685787558642755)],
        ),
        (
            UniCase::ascii("reorganize"),
            &[(0b01001, &ENTRY_REORGANIZE_18181270914612994788)],
        ),
        (
            UniCase::ascii("synthesisation"),
            &[(0b10010, &ENTRY_SYNTHESIZATION_7847480716228741176)],
        ),
        (
            UniCase::ascii("balkanised"),
            &[(0b10010, &ENTRY_BALKANIZED_7283200167845869640)],
        ),
        (
            UniCase::ascii("paralogizing"),
            &[(0b01001, &ENTRY_PARALOGIZING_8939374896317650319)],
        ),
        (
            UniCase::ascii("odorized"),
            &[(0b01001, &ENTRY_ODORIZED_12401728499096074253)],
        ),
        (
            UniCase::ascii("sphaerosome"),
            &[(0b11010, &ENTRY_SPHEROSOME_14408424187868099563)],
        ),
        (
            UniCase::ascii("malleablizes"),
            &[(0b01001, &ENTRY_MALLEABLIZES_2447853325264765807)],
        ),
        (
            UniCase::ascii("characterizing"),
            &[(0b01001, &ENTRY_CHARACTERIZING_3950440594591682040)],
        ),
        (
            UniCase::ascii("unsensualised"),
            &[(0b10010, &ENTRY_UNSENSUALIZED_32054534269141140)],
        ),
        (
            UniCase::ascii("catholicisations"),
            &[(0b10010, &ENTRY_CATHOLICIZATIONS_8828933916874627488)],
        ),
        (
            UniCase::ascii("rebaptisations"),
            &[(0b10010, &ENTRY_REBAPTIZATIONS_10409601231952199745)],
        ),
        (
            UniCase::ascii("amalgamization"),
            &[(0b01001, &ENTRY_AMALGAMIZATION_6873838956097053791)],
        ),
        (
            UniCase::ascii("unromanised"),
            &[(0b10010, &ENTRY_UNROMANIZED_3332586790919173959)],
        ),
        (
            UniCase::ascii("itemizes"),
            &[(0b01001, &ENTRY_ITEMIZES_10919132215830907409)],
        ),
        (
            UniCase::ascii("underemphasised"),
            &[(0b10010, &ENTRY_UNDEREMPHASIZED_13287064872491391347)],
        ),
        (
            UniCase::ascii("idealize"),
            &[(0b01001, &ENTRY_IDEALIZE_14123580326934520124)],
        ),
        (
            UniCase::ascii("unsectarianises"),
            &[(0b10010, &ENTRY_UNSECTARIANIZES_17346999740171237029)],
        ),
        (
            UniCase::ascii("reroyalize"),
            &[(0b01001, &ENTRY_REROYALIZE_9299210178122090712)],
        ),
        (
            UniCase::ascii("lateralisation"),
            &[(0b10010, &ENTRY_LATERALIZATION_8041407149896392073)],
        ),
        (
            UniCase::ascii("musicalizes"),
            &[(0b01001, &ENTRY_MUSICALIZES_15122018268806895726)],
        ),
        (
            UniCase::ascii("precisionize"),
            &[(0b01001, &ENTRY_PRECISIONIZE_16309913476870820127)],
        ),
        (
            UniCase::ascii("bartizan"),
            &[(0b01001, &ENTRY_BARTIZAN_3091667005685807749)],
        ),
        (
            UniCase::ascii("deadrise"),
            &[(0b10010, &ENTRY_DEADRIZE_16948183351591896893)],
        ),
        (
            UniCase::ascii("symbolise"),
            &[(0b10010, &ENTRY_SYMBOLIZE_1459836702485298151)],
        ),
        (
            UniCase::ascii("victuallers"),
            &[(0b11010, &ENTRY_VICTUALERS_3647699329720955367)],
        ),
        (
            UniCase::ascii("goloshes"),
            &[(0b00001, &ENTRY_GOLOSHES_13775493769643547174)],
        ),
        (
            UniCase::ascii("speleothems"),
            &[(0b00001, &ENTRY_SPELEOTHEMS_10285341670778918846)],
        ),
        (
            UniCase::ascii("disfavourers"),
            &[(0b11010, &ENTRY_DISFAVORERS_18430656322920499015)],
        ),
        (
            UniCase::ascii("peract"),
            &[(0b00001, &ENTRY_PERACT_16940258999462133608)],
        ),
        (
            UniCase::ascii("paleopathologic"),
            &[(0b10001, &ENTRY_PALEOPATHOLOGIC_12214316584075954034)],
        ),
        (
            UniCase::ascii("agonizingliest"),
            &[(0b01001, &ENTRY_AGONIZINGLIEST_12888967969387776485)],
        ),
        (
            UniCase::ascii("palatalisation"),
            &[(0b10010, &ENTRY_PALATALIZATION_2924504919577641238)],
        ),
        (
            UniCase::ascii("platonising"),
            &[(0b10010, &ENTRY_PLATONIZING_3294563492691077109)],
        ),
        (
            UniCase::ascii("untantalizing"),
            &[(0b01001, &ENTRY_UNTANTALIZING_9378536861335914621)],
        ),
        (
            UniCase::ascii("unmysticises"),
            &[(0b10010, &ENTRY_UNMYSTICIZES_593169946783893980)],
        ),
        (
            UniCase::ascii("celestialise"),
            &[(0b10010, &ENTRY_CELESTIALIZE_2289649302276111708)],
        ),
        (
            UniCase::ascii("plantae"),
            &[(0b11010, &ENTRY_PLANTE_15938795954501174987)],
        ),
        (
            UniCase::ascii("unverbalised"),
            &[(0b10010, &ENTRY_UNVERBALIZED_16856369756877096411)],
        ),
        (
            UniCase::ascii("manoeuvrabilities"),
            &[(0b11010, &ENTRY_MANEUVERABILITIES_4377566838265267604)],
        ),
        (
            UniCase::ascii("platinisation"),
            &[(0b10010, &ENTRY_PLATINIZATION_7294928098928662795)],
        ),
        (
            UniCase::ascii("recapitalisation"),
            &[(0b10010, &ENTRY_RECAPITALIZATION_13789246273577829586)],
        ),
        (
            UniCase::ascii("copolymerized"),
            &[(0b01001, &ENTRY_COPOLYMERIZED_17760814634904159372)],
        ),
        (
            UniCase::ascii("privatizations"),
            &[(0b01001, &ENTRY_PRIVATIZATIONS_14900435995228716791)],
        ),
        (
            UniCase::ascii("tuberculinise"),
            &[(0b10010, &ENTRY_TUBERCULINIZE_15333531702912733903)],
        ),
        (
            UniCase::ascii("vegetablize"),
            &[(0b01001, &ENTRY_VEGETABLIZE_15652329865549979869)],
        ),
        (
            UniCase::ascii("comprehensivising"),
            &[(0b10010, &ENTRY_COMPREHENSIVIZING_2953121830198164292)],
        ),
        (
            UniCase::ascii("pulverizablest"),
            &[(0b01001, &ENTRY_PULVERIZABLEST_9880898831981142418)],
        ),
        (
            UniCase::ascii("siderealize"),
            &[(0b01001, &ENTRY_SIDEREALIZE_13138990443604086580)],
        ),
        (
            UniCase::ascii("substantivizes"),
            &[(0b01001, &ENTRY_SUBSTANTIVIZES_10108249589648833227)],
        ),
        (
            UniCase::ascii("enquires"),
            &[(0b11010, &ENTRY_INQUIRES_3832461159884672820)],
        ),
        (
            UniCase::ascii("vitriolizations"),
            &[(0b01001, &ENTRY_VITRIOLIZATIONS_12059310110149895869)],
        ),
        (
            UniCase::ascii("formularized"),
            &[(0b01001, &ENTRY_FORMULARIZED_13568613489170427732)],
        ),
        (
            UniCase::ascii("pamperises"),
            &[(0b10010, &ENTRY_PAMPERIZES_14945268529810280091)],
        ),
        (
            UniCase::ascii("phonemicisations"),
            &[(0b10010, &ENTRY_PHONEMICIZATIONS_11036149124276358577)],
        ),
        (
            UniCase::ascii("houselling"),
            &[(0b11010, &ENTRY_HOUSELING_9033251538610526455)],
        ),
        (
            UniCase::ascii("nebulisers"),
            &[(0b10010, &ENTRY_NEBULIZERS_5318245889291026270)],
        ),
        (
            UniCase::ascii("martyrisers"),
            &[(0b10010, &ENTRY_MARTYRIZERS_8288377886330052956)],
        ),
        (
            UniCase::ascii("frivolling"),
            &[(0b11010, &ENTRY_FRIVOLING_18278706907289454096)],
        ),
        (
            UniCase::ascii("desynchronizations"),
            &[(0b01001, &ENTRY_DESYNCHRONIZATIONS_8142294090130517034)],
        ),
        (
            UniCase::ascii("sensationalise"),
            &[(0b10010, &ENTRY_SENSATIONALIZE_3612877228613212928)],
        ),
        (
            UniCase::ascii("bastardize"),
            &[(0b01001, &ENTRY_BASTARDIZE_17168607737816618553)],
        ),
        (
            UniCase::ascii("accorage"),
            &[(0b00001, &ENTRY_ACCORAGE_4223546442621665298)],
        ),
        (
            UniCase::ascii("chiseler"),
            &[(0b00001, &ENTRY_CHISELER_5457396429234167127)],
        ),
        (
            UniCase::ascii("unvisualisedder"),
            &[(0b10010, &ENTRY_UNVISUALIZEDDER_13256531491156210059)],
        ),
        (
            UniCase::ascii("relativised"),
            &[(0b10010, &ENTRY_RELATIVIZED_2041795511676409313)],
        ),
        (
            UniCase::ascii("semitization"),
            &[(0b01001, &ENTRY_SEMITIZATION_2814386441666130450)],
        ),
        (
            UniCase::ascii("draftswoman"),
            &[(0b01001, &ENTRY_DRAFTSWOMAN_13749770471062736806)],
        ),
        (
            UniCase::ascii("revalenta"),
            &[(0b11010, &ENTRY_ERVALENTA_10785450433515167284)],
        ),
        (
            UniCase::ascii("teutonized"),
            &[(0b01001, &ENTRY_TEUTONIZED_10064813533808905253)],
        ),
        (
            UniCase::ascii("formulizer"),
            &[(0b01001, &ENTRY_FORMULIZER_16549374471213376016)],
        ),
        (
            UniCase::ascii("haemoconia"),
            &[(0b11010, &ENTRY_HEMOCONIA_16171119888057670146)],
        ),
        (
            UniCase::ascii("bolshevise"),
            &[(0b10010, &ENTRY_BOLSHEVIZE_9295222616139275092)],
        ),
        (
            UniCase::ascii("acroanaesthesia"),
            &[(0b11010, &ENTRY_ACROANESTHESIA_106439738109694339)],
        ),
        (
            UniCase::ascii("zooea"),
            &[(0b11010, &ENTRY_ZOEA_9209140367896697417)],
        ),
        (
            UniCase::ascii("nonoxidisable"),
            &[(0b10010, &ENTRY_NONOXIDIZABLE_17473608806098821507)],
        ),
        (
            UniCase::ascii("subvitalizeddest"),
            &[(0b01001, &ENTRY_SUBVITALIZEDDEST_4531581466325644556)],
        ),
        (
            UniCase::ascii("gothicisers"),
            &[(0b10010, &ENTRY_GOTHICIZERS_14069671387176050924)],
        ),
        (
            UniCase::ascii("proteidae"),
            &[(0b11010, &ENTRY_PROTEIDE_15177699273216527826)],
        ),
        (
            UniCase::ascii("vulgarising"),
            &[(0b10010, &ENTRY_VULGARIZING_8957250676888139808)],
        ),
        (
            UniCase::ascii("preprogram"),
            &[(0b01001, &ENTRY_PREPROGRAM_182544249377649179)],
        ),
        (
            UniCase::ascii("schismatising"),
            &[(0b10010, &ENTRY_SCHISMATIZING_18224301025260482655)],
        ),
        (
            UniCase::ascii("reacclimatisations"),
            &[(0b10010, &ENTRY_REACCLIMATIZATIONS_445812918952620334)],
        ),
        (
            UniCase::ascii("frenchise"),
            &[(0b10010, &ENTRY_FRENCHIZE_9878626967854112935)],
        ),
        (
            UniCase::ascii("alkalinizing"),
            &[(0b01001, &ENTRY_ALKALINIZING_4329175391998172496)],
        ),
        (
            UniCase::ascii("cognizer"),
            &[(0b01001, &ENTRY_COGNIZER_17235063272659781689)],
        ),
        (
            UniCase::ascii("subjectivizes"),
            &[(0b01001, &ENTRY_SUBJECTIVIZES_7152248194959006615)],
        ),
        (
            UniCase::ascii("empyreumatised"),
            &[(0b10010, &ENTRY_EMPYREUMATIZED_15637035447882020628)],
        ),
        (
            UniCase::ascii("seisable"),
            &[(0b10010, &ENTRY_SEIZABLE_6299895893787769311)],
        ),
        (
            UniCase::ascii("zea"),
            &[(0b00001, &ENTRY_ZEA_11106235456645827388)],
        ),
        (
            UniCase::ascii("monarchising"),
            &[(0b10010, &ENTRY_MONARCHIZING_8557056119920625430)],
        ),
        (
            UniCase::ascii("unmediatised"),
            &[(0b10010, &ENTRY_UNMEDIATIZED_2290392514230277768)],
        ),
        (
            UniCase::ascii("similarizes"),
            &[(0b01001, &ENTRY_SIMILARIZES_304454380831943452)],
        ),
        (
            UniCase::ascii("carnalises"),
            &[(0b10010, &ENTRY_CARNALIZES_5581084477739167595)],
        ),
        (
            UniCase::ascii("diphthongizes"),
            &[(0b01001, &ENTRY_DIPHTHONGIZES_9976473308769011757)],
        ),
        (
            UniCase::ascii("mylonitizes"),
            &[(0b01001, &ENTRY_MYLONITIZES_9054608438172135078)],
        ),
        (
            UniCase::ascii("fibriser"),
            &[(0b10010, &ENTRY_FIBERIZER_2701702218944894305)],
        ),
        (
            UniCase::ascii("antilemic"),
            &[(0b00001, &ENTRY_ANTILEMIC_9212729723604435140)],
        ),
        (
            UniCase::ascii("terrorising"),
            &[(0b10010, &ENTRY_TERRORIZING_13104103423474029961)],
        ),
        (
            UniCase::ascii("tractorize"),
            &[(0b01001, &ENTRY_TRACTORIZE_12965430895282931565)],
        ),
        (
            UniCase::ascii("mobilizers"),
            &[(0b01001, &ENTRY_MOBILIZERS_13019397665994940764)],
        ),
        (
            UniCase::ascii("discretize"),
            &[(0b01001, &ENTRY_DISCRETIZE_5822871996560826075)],
        ),
        (
            UniCase::ascii("tetanisations"),
            &[(0b10010, &ENTRY_TETANIZATIONS_9830716338275193986)],
        ),
        (
            UniCase::ascii("aggrandise"),
            &[(0b10010, &ENTRY_AGGRANDIZE_708175043678043149)],
        ),
        (
            UniCase::ascii("unitising"),
            &[(0b10010, &ENTRY_UNITIZING_14503461086641416326)],
        ),
        (
            UniCase::ascii("humaniser"),
            &[(0b10010, &ENTRY_HUMANIZER_12017356498460139218)],
        ),
        (
            UniCase::ascii("decapitalises"),
            &[(0b10010, &ENTRY_DECAPITALIZES_3757956433811423536)],
        ),
        (
            UniCase::ascii("nonrecogniseds"),
            &[(0b10010, &ENTRY_NONRECOGNIZEDS_16936479754167964125)],
        ),
        (
            UniCase::ascii("sectarianisation"),
            &[(0b10010, &ENTRY_SECTARIANIZATION_10329500434104171538)],
        ),
        (
            UniCase::ascii("regalise"),
            &[(0b10010, &ENTRY_REGALIZE_13206969410028193305)],
        ),
        (
            UniCase::ascii("tantalisingly"),
            &[(0b10010, &ENTRY_TANTALIZINGLY_8124924363029560350)],
        ),
        (
            UniCase::ascii("outcaviled"),
            &[(0b00001, &ENTRY_OUTCAVILED_12328360919318201558)],
        ),
        (
            UniCase::ascii("schematise"),
            &[(0b10010, &ENTRY_SCHEMATIZE_17242177807075430578)],
        ),
        (
            UniCase::ascii("mercurialized"),
            &[(0b01001, &ENTRY_MERCURIALIZED_6385834004082463546)],
        ),
        (
            UniCase::ascii("flavoriest"),
            &[(0b11001, &ENTRY_FLAVORIEST_6780248413885561418)],
        ),
        (
            UniCase::ascii("persicize"),
            &[(0b01001, &ENTRY_PERSICIZE_9817820256246452496)],
        ),
        (
            UniCase::ascii("goliathises"),
            &[(0b10010, &ENTRY_GOLIATHIZES_5680945343906319918)],
        ),
        (
            UniCase::ascii("capitalizes"),
            &[(0b01001, &ENTRY_CAPITALIZES_16323417076992732600)],
        ),
        (
            UniCase::ascii("statisticizes"),
            &[(0b01001, &ENTRY_STATISTICIZES_3777559913591399659)],
        ),
        (
            UniCase::ascii("cerebralization"),
            &[(0b01001, &ENTRY_CEREBRALIZATION_639759174762081390)],
        ),
        (
            UniCase::ascii("tetanising"),
            &[(0b10010, &ENTRY_TETANIZING_3169895590113377680)],
        ),
        (
            UniCase::ascii("impaneled"),
            &[(0b00001, &ENTRY_IMPANELED_1167928814655817587)],
        ),
        (
            UniCase::ascii("unparalysedder"),
            &[(0b11010, &ENTRY_UNPARALYZEDDER_10074788125617493696)],
        ),
        (
            UniCase::ascii("vapourers"),
            &[(0b11010, &ENTRY_VAPORERS_9040022998985997095)],
        ),
        (
            UniCase::ascii("similarize"),
            &[(0b01001, &ENTRY_SIMILARIZE_2700808984999286713)],
        ),
        (
            UniCase::ascii("ketonizes"),
            &[(0b01001, &ENTRY_KETONIZES_9616017976128138242)],
        ),
        (
            UniCase::ascii("silicidises"),
            &[(0b10010, &ENTRY_SILICIDIZES_5809599080861161027)],
        ),
        (
            UniCase::ascii("tropicalizes"),
            &[(0b01001, &ENTRY_TROPICALIZES_10180779904224473997)],
        ),
        (
            UniCase::ascii("mediterraneanises"),
            &[(0b10010, &ENTRY_MEDITERRANEANIZES_4936465023428726899)],
        ),
        (
            UniCase::ascii("laurae"),
            &[(0b11010, &ENTRY_LAURE_841157505029689756)],
        ),
        (
            UniCase::ascii("uncivilize"),
            &[(0b01001, &ENTRY_UNCIVILIZE_16379895937239654425)],
        ),
        (
            UniCase::ascii("zonaesthesia"),
            &[(0b11010, &ENTRY_ZONESTHESIA_3100074848208687922)],
        ),
        (
            UniCase::ascii("recentralisations"),
            &[(0b10010, &ENTRY_RECENTRALIZATIONS_17081718818823233232)],
        ),
        (
            UniCase::ascii("hamletises"),
            &[(0b10010, &ENTRY_HAMLETIZES_3332330520225481896)],
        ),
        (
            UniCase::ascii("thermalizing"),
            &[(0b01001, &ENTRY_THERMALIZING_8673243577457624256)],
        ),
        (
            UniCase::ascii("lichenizing"),
            &[(0b01001, &ENTRY_LICHENIZING_4675116376139174902)],
        ),
        (
            UniCase::ascii("tuberculinize"),
            &[(0b01001, &ENTRY_TUBERCULINIZE_15333531702912733903)],
        ),
        (
            UniCase::ascii("anematosis"),
            &[(0b00001, &ENTRY_ANEMATOSIS_2231831205038246544)],
        ),
        (
            UniCase::ascii("turdine"),
            &[(0b00001, &ENTRY_TURDINE_8495216946259189004)],
        ),
        (
            UniCase::ascii("dependants"),
            &[(0b11010, &ENTRY_DEPENDENTS_1571044403913138535)],
        ),
        (
            UniCase::ascii("suberization"),
            &[(0b01001, &ENTRY_SUBERIZATION_1080833948419911642)],
        ),
        (
            UniCase::ascii("cadasters"),
            &[(0b00001, &ENTRY_CADASTERS_582180790478148418)],
        ),
        (
            UniCase::ascii("geologize"),
            &[(0b01001, &ENTRY_GEOLOGIZE_1348394399033582028)],
        ),
        (
            UniCase::ascii("standardized"),
            &[(0b01001, &ENTRY_STANDARDIZED_10576000602438339721)],
        ),
        (
            UniCase::ascii("chronologizes"),
            &[(0b01001, &ENTRY_CHRONOLOGIZES_11841064468767540761)],
        ),
        (
            UniCase::ascii("apogaeic"),
            &[(0b11010, &ENTRY_APOGEIC_10442075832990462520)],
        ),
        (
            UniCase::ascii("subminiaturised"),
            &[(0b10010, &ENTRY_SUBMINIATURIZED_15597111727187376086)],
        ),
        (
            UniCase::ascii("lionising"),
            &[(0b10010, &ENTRY_LIONIZING_10205945039497753785)],
        ),
        (
            UniCase::ascii("gutturalize"),
            &[(0b01001, &ENTRY_GUTTURALIZE_4985183622837803583)],
        ),
        (
            UniCase::ascii("unkennelling"),
            &[(0b11010, &ENTRY_UNKENNELING_10813411767613768190)],
        ),
        (
            UniCase::ascii("travelers"),
            &[(0b00001, &ENTRY_TRAVELERS_534480827925386728)],
        ),
        (
            UniCase::ascii("foolhardized"),
            &[(0b01001, &ENTRY_FOOLHARDIZED_17362186477311628401)],
        ),
        (
            UniCase::ascii("dechristianisation"),
            &[(0b10010, &ENTRY_DECHRISTIANIZATION_11836465351921531501)],
        ),
        (
            UniCase::ascii("palaeobiological"),
            &[(0b11010, &ENTRY_PALEOBIOLOGICAL_6984844449398043034)],
        ),
        (
            UniCase::ascii("unscrutinisinglier"),
            &[(0b10010, &ENTRY_UNSCRUTINIZINGLIER_16918089062255487129)],
        ),
        (
            UniCase::ascii("rivalesses"),
            &[(0b00001, &ENTRY_RIVALESSES_7896212397487020650)],
        ),
        (
            UniCase::ascii("pseudocelom"),
            &[(0b00001, &ENTRY_PSEUDOCELOM_1695207054053145685)],
        ),
        (
            UniCase::ascii("regionalizing"),
            &[(0b01001, &ENTRY_REGIONALIZING_16531030062440884204)],
        ),
        (
            UniCase::ascii("subitize"),
            &[(0b01001, &ENTRY_SUBITIZE_3227874881853303084)],
        ),
        (
            UniCase::ascii("peptizer"),
            &[(0b01001, &ENTRY_PEPTIZER_10333676369659848983)],
        ),
        (
            UniCase::ascii("destigmatisation"),
            &[(0b10010, &ENTRY_DESTIGMATIZATION_76784710048289446)],
        ),
        (
            UniCase::ascii("supersubtilized"),
            &[(0b01001, &ENTRY_SUPERSUBTILIZED_11208309807789263657)],
        ),
        (
            UniCase::ascii("multicolouredder"),
            &[(0b11010, &ENTRY_MULTICOLOREDDER_3341008599097650171)],
        ),
        (
            UniCase::ascii("veteranises"),
            &[(0b10010, &ENTRY_VETERANIZES_11256585660882985870)],
        ),
        (
            UniCase::ascii("unsynchroniseddest"),
            &[(0b10010, &ENTRY_UNSYNCHRONIZEDDEST_8914833530283816809)],
        ),
        (
            UniCase::ascii("waggoning"),
            &[(0b10010, &ENTRY_WAGONING_6834423535434103369)],
        ),
        (
            UniCase::ascii("proctodaeums"),
            &[(0b11010, &ENTRY_PROCTODEUMS_7965990816311016504)],
        ),
        (
            UniCase::ascii("esthetes"),
            &[(0b00001, &ENTRY_AESTHETES_9473189152352933863)],
        ),
        (
            UniCase::ascii("dockised"),
            &[(0b10010, &ENTRY_DOCKIZED_11497882154286445931)],
        ),
        (
            UniCase::ascii("remilitarizations"),
            &[(0b01001, &ENTRY_REMILITARIZATIONS_14597687455768382338)],
        ),
        (
            UniCase::ascii("supersensitising"),
            &[(0b10010, &ENTRY_SUPERSENSITIZING_5029091819363480393)],
        ),
        (
            UniCase::ascii("elegizes"),
            &[(0b01001, &ENTRY_ELEGIZES_10107353784266158156)],
        ),
        (
            UniCase::ascii("cyanises"),
            &[(0b10010, &ENTRY_CYANIZES_5685851010869963468)],
        ),
        (
            UniCase::ascii("specialities"),
            &[(0b10010, &ENTRY_SPECIALTIES_3691519001585260032)],
        ),
        (
            UniCase::ascii("diopters"),
            &[(0b01001, &ENTRY_DIOPTERS_516947549353623981)],
        ),
        (
            UniCase::ascii("alphabetisers"),
            &[(0b10010, &ENTRY_ALPHABETIZERS_6296269536595041194)],
        ),
        (
            UniCase::ascii("atomizability"),
            &[(0b01001, &ENTRY_ATOMIZABILITY_3662844297231153629)],
        ),
        (
            UniCase::ascii("overurbanisation"),
            &[(0b10010, &ENTRY_OVERURBANIZATION_5193813995283903294)],
        ),
        (
            UniCase::ascii("skeletonized"),
            &[(0b01001, &ENTRY_SKELETONIZED_5834618125945052179)],
        ),
        (
            UniCase::ascii("crystallizability"),
            &[(0b01001, &ENTRY_CRYSTALLIZABILITY_417676650172898499)],
        ),
        (
            UniCase::ascii("fetishizing"),
            &[(0b01001, &ENTRY_FETISHIZING_13625208754682318629)],
        ),
        (
            UniCase::ascii("cocainise"),
            &[(0b10010, &ENTRY_COCAINIZE_5959521297540551059)],
        ),
        (
            UniCase::ascii("subjectivising"),
            &[(0b10010, &ENTRY_SUBJECTIVIZING_8718502587935622549)],
        ),
        (
            UniCase::ascii("randomise"),
            &[(0b10010, &ENTRY_RANDOMIZE_13711817980083119800)],
        ),
        (
            UniCase::ascii("decentralisations"),
            &[(0b10010, &ENTRY_DECENTRALIZATIONS_17002754818902434488)],
        ),
        (
            UniCase::ascii("sinicized"),
            &[(0b01001, &ENTRY_SINICIZED_1170587988011526807)],
        ),
        (
            UniCase::ascii("caracolled"),
            &[(0b11010, &ENTRY_CARACOLED_8083634779350238799)],
        ),
        (
            UniCase::ascii("judgement"),
            &[(0b11010, &ENTRY_JUDGMENT_1564861960905688138)],
        ),
        (
            UniCase::ascii("anodising"),
            &[(0b10010, &ENTRY_ANODIZING_15645879132035324138)],
        ),
        (
            UniCase::ascii("misjudgements"),
            &[(0b11010, &ENTRY_MISJUDGMENTS_15088301739266707294)],
        ),
        (
            UniCase::ascii("ethicisation"),
            &[(0b10010, &ENTRY_ETHICIZATION_7982960618336992609)],
        ),
        (
            UniCase::ascii("nosise"),
            &[(0b10010, &ENTRY_NOSIZE_17677768185590899897)],
        ),
        (
            UniCase::ascii("atomises"),
            &[(0b10010, &ENTRY_ATOMIZES_963643916071531136)],
        ),
        (
            UniCase::ascii("untrammelleddest"),
            &[(0b11010, &ENTRY_UNTRAMMELEDDEST_15285162208707661637)],
        ),
        (
            UniCase::ascii("unstandardiseddest"),
            &[(0b10010, &ENTRY_UNSTANDARDIZEDDEST_11035827645803141662)],
        ),
        (
            UniCase::ascii("unserialised"),
            &[(0b10010, &ENTRY_UNSERIALIZED_14154792643266589843)],
        ),
        (
            UniCase::ascii("vocalisers"),
            &[(0b10010, &ENTRY_VOCALIZERS_5083157038348945833)],
        ),
        (
            UniCase::ascii("unroyaliseds"),
            &[(0b10010, &ENTRY_UNROYALIZEDS_18166484644206892914)],
        ),
        (
            UniCase::ascii("adverbialise"),
            &[(0b10010, &ENTRY_ADVERBIALIZE_2474916322327345748)],
        ),
        (
            UniCase::ascii("genialised"),
            &[(0b10010, &ENTRY_GENIALIZED_324742209355172939)],
        ),
        (
            UniCase::ascii("neutralizer"),
            &[(0b01001, &ENTRY_NEUTRALIZER_5629768343757464420)],
        ),
        (
            UniCase::ascii("colorabler"),
            &[(0b11001, &ENTRY_COLORABLER_1063847220352847404)],
        ),
        (
            UniCase::ascii("odourfullest"),
            &[(0b11010, &ENTRY_ODORFULLEST_17115559072799533041)],
        ),
        (
            UniCase::ascii("hypoxaemic"),
            &[(0b11010, &ENTRY_HYPOXEMIC_548533936920854543)],
        ),
        (
            UniCase::ascii("tes"),
            &[(0b00001, &ENTRY_TES_5634224708893959490)],
        ),
        (
            UniCase::ascii("mense"),
            &[(0b00001, &ENTRY_MENSE_16673844012933097881)],
        ),
        (
            UniCase::ascii("collectables"),
            &[(0b10011, &ENTRY_COLLECTIBLES_1426649794037748395)],
        ),
        (
            UniCase::ascii("devolatilisations"),
            &[(0b10010, &ENTRY_DEVOLATILIZATIONS_4707574596121848991)],
        ),
        (
            UniCase::ascii("metacentre"),
            &[(0b11010, &ENTRY_METACENTER_12861464410788453410)],
        ),
        (
            UniCase::ascii("myriameter"),
            &[(0b00001, &ENTRY_MYRIAMETER_284114791865990119)],
        ),
        (
            UniCase::ascii("peptizations"),
            &[(0b01001, &ENTRY_PEPTIZATIONS_7100944985070861177)],
        ),
        (
            UniCase::ascii("untheorisable"),
            &[(0b10010, &ENTRY_UNTHEORIZABLE_240618649580760361)],
        ),
        (
            UniCase::ascii("overjudgments"),
            &[(0b00001, &ENTRY_OVERJUDGMENTS_16817152636455142022)],
        ),
        (
            UniCase::ascii("synthesising"),
            &[(0b10010, &ENTRY_SYNTHESIZING_961211694929147125)],
        ),
        (
            UniCase::ascii("reoxygenise"),
            &[(0b10010, &ENTRY_REOXYGENIZE_6926836183647945085)],
        ),
        (
            UniCase::ascii("reexportation"),
            &[(0b00001, &ENTRY_REEXPORTATION_9761953209479597434)],
        ),
        (
            UniCase::ascii("paleozoology"),
            &[(0b10001, &ENTRY_PALEOZOOLOGY_1422962101591588438)],
        ),
        (
            UniCase::ascii("monumentalises"),
            &[(0b10010, &ENTRY_MONUMENTALIZES_5130414847256959479)],
        ),
        (
            UniCase::ascii("micraesthete"),
            &[(0b11010, &ENTRY_MICRESTHETE_13540257889635101070)],
        ),
        (
            UniCase::ascii("scrutinised"),
            &[(0b10010, &ENTRY_SCRUTINIZED_138448923562603427)],
        ),
        (
            UniCase::ascii("universalisation"),
            &[(0b10010, &ENTRY_UNIVERSALIZATION_9796721220313365644)],
        ),
        (
            UniCase::ascii("revalorizes"),
            &[(0b01001, &ENTRY_REVALORIZES_9002308862045152018)],
        ),
        (
            UniCase::ascii("unkennelled"),
            &[(0b11010, &ENTRY_UNKENNELED_3312308653646352421)],
        ),
        (
            UniCase::ascii("centreless"),
            &[(0b11010, &ENTRY_CENTERLESS_16010100430566689787)],
        ),
        (
            UniCase::ascii("mythize"),
            &[(0b01001, &ENTRY_MYTHIZE_9908305862028630928)],
        ),
        (
            UniCase::ascii("foeticide"),
            &[(0b10010, &ENTRY_FETICIDE_17603941273141945408)],
        ),
        (
            UniCase::ascii("gastreas"),
            &[(0b00001, &ENTRY_GASTREAS_1400735590131613456)],
        ),
        (
            UniCase::ascii("encolors"),
            &[(0b11001, &ENTRY_ENCOLORS_8551106713845336956)],
        ),
        (
            UniCase::ascii("telepathized"),
            &[(0b01001, &ENTRY_TELEPATHIZED_13030563544943449021)],
        ),
        (
            UniCase::ascii("symptomatize"),
            &[(0b01001, &ENTRY_SYMPTOMATIZE_7741807692536744481)],
        ),
        (
            UniCase::ascii("honorables"),
            &[(0b11001, &ENTRY_HONORABLES_2913554671346259853)],
        ),
        (
            UniCase::ascii("proselytizations"),
            &[(0b01001, &ENTRY_PROSELYTIZATIONS_9868313451413411610)],
        ),
        (
            UniCase::ascii("conveyorised"),
            &[(0b10010, &ENTRY_CONVEYORIZED_1550738673068217452)],
        ),
        (
            UniCase::ascii("yogourts"),
            &[(0b01000, &ENTRY_YOGURTS_14006847350082938741)],
        ),
        (
            UniCase::ascii("stylisations"),
            &[(0b10010, &ENTRY_STYLIZATIONS_12181517973286032450)],
        ),
        (
            UniCase::ascii("molochize"),
            &[(0b01001, &ENTRY_MOLOCHIZE_10281963447149464183)],
        ),
        (
            UniCase::ascii("utilitarianised"),
            &[(0b10010, &ENTRY_UTILITARIANIZED_17327794031594514233)],
        ),
        (
            UniCase::ascii("reorganizations"),
            &[(0b01001, &ENTRY_REORGANIZATIONS_3908357981488387825)],
        ),
        (
            UniCase::ascii("formulisation"),
            &[(0b10010, &ENTRY_FORMULIZATION_7090367550673650726)],
        ),
        (
            UniCase::ascii("othematoma"),
            &[(0b10001, &ENTRY_OTHEMATOMA_4021430710484496451)],
        ),
        (
            UniCase::ascii("heroises"),
            &[(0b10010, &ENTRY_HEROIZES_18377738024677746144)],
        ),
        (
            UniCase::ascii("unpractiseddest"),
            &[(0b11010, &ENTRY_UNPRACTICEDDEST_15053947325497824834)],
        ),
        (
            UniCase::ascii("photoesthesis"),
            &[(0b11010, &ENTRY_PHOTESTHESIS_17727520840546347652)],
        ),
        (
            UniCase::ascii("artificialize"),
            &[(0b01001, &ENTRY_ARTIFICIALIZE_6116923120575367102)],
        ),
        (
            UniCase::ascii("entomologizes"),
            &[(0b01001, &ENTRY_ENTOMOLOGIZES_14741971157180428511)],
        ),
        (
            UniCase::ascii("digitises"),
            &[(0b10010, &ENTRY_DIGITIZES_2690419763079826049)],
        ),
        (
            UniCase::ascii("immortalisers"),
            &[(0b10010, &ENTRY_IMMORTALIZERS_6443963380598843946)],
        ),
        (
            UniCase::ascii("colonize"),
            &[(0b01001, &ENTRY_COLONIZE_15302728430964322592)],
        ),
        (
            UniCase::ascii("cudgeler"),
            &[(0b00001, &ENTRY_CUDGELER_14634684249116397869)],
        ),
        (
            UniCase::ascii("unarmored"),
            &[(0b00001, &ENTRY_UNARMORED_4540020611443646355)],
        ),
        (
            UniCase::ascii("hyposensitise"),
            &[(0b10010, &ENTRY_HYPOSENSITIZE_2895248881259272507)],
        ),
        (
            UniCase::ascii("kinesthesia"),
            &[(0b11001, &ENTRY_KINESTHESIA_4147711150901246528)],
        ),
        (
            UniCase::ascii("preutilisation"),
            &[(0b10010, &ENTRY_PREUTILIZATION_4481094491629481493)],
        ),
        (
            UniCase::ascii("geologizing"),
            &[(0b01001, &ENTRY_GEOLOGIZING_1596141849146660093)],
        ),
        (
            UniCase::ascii("noncoloring"),
            &[(0b10001, &ENTRY_NONCOLORING_2794432948648709598)],
        ),
        (
            UniCase::ascii("teaer"),
            &[(0b11010, &ENTRY_TEER_1512356504088772276)],
        ),
        (
            UniCase::ascii("departmentalising"),
            &[(0b10010, &ENTRY_DEPARTMENTALIZING_18236918120360172300)],
        ),
        (
            UniCase::ascii("pyorrheic"),
            &[(0b00001, &ENTRY_PYORRHEIC_3299650509022396406)],
        ),
        (
            UniCase::ascii("oversentimentalise"),
            &[(0b10010, &ENTRY_OVERSENTIMENTALIZE_2920069227773965746)],
        ),
        (
            UniCase::ascii("internationalising"),
            &[(0b10010, &ENTRY_INTERNATIONALIZING_12026461136750240322)],
        ),
        (
            UniCase::ascii("utopianizes"),
            &[(0b01001, &ENTRY_UTOPIANIZES_17399145312143334553)],
        ),
        (
            UniCase::ascii("lacklusterrest"),
            &[(0b00001, &ENTRY_LACKLUSTERREST_17124785842338778470)],
        ),
        (
            UniCase::ascii("methodisers"),
            &[(0b10010, &ENTRY_METHODIZERS_11335706115632934821)],
        ),
        (
            UniCase::ascii("ghebres"),
            &[(0b11010, &ENTRY_GHEBERS_8157544588744048409)],
        ),
        (
            UniCase::ascii("demasculinise"),
            &[(0b10010, &ENTRY_DEMASCULINIZE_10705941850922882000)],
        ),
        (
            UniCase::ascii("perpending"),
            &[(0b00001, &ENTRY_PERPENDING_9760848409550374555)],
        ),
        (
            UniCase::ascii("hemapophysis"),
            &[(0b10001, &ENTRY_HEMAPOPHYSIS_14410027549001408776)],
        ),
        (
            UniCase::ascii("ancille"),
            &[(0b00001, &ENTRY_ANCILLE_15818318021107678161)],
        ),
        (
            UniCase::ascii("eudemonistic"),
            &[(0b00001, &ENTRY_EUDEMONISTIC_4092483053014414870)],
        ),
        (
            UniCase::ascii("unsabered"),
            &[(0b00001, &ENTRY_UNSABERED_7177981977292168575)],
        ),
        (
            UniCase::ascii("unsympathisingly"),
            &[(0b10010, &ENTRY_UNSYMPATHIZINGLY_10367834800272884249)],
        ),
        (
            UniCase::ascii("funneling"),
            &[(0b00001, &ENTRY_FUNNELING_7298662514265886848)],
        ),
        (
            UniCase::ascii("quantizer"),
            &[(0b01001, &ENTRY_QUANTIZER_3494983548212992900)],
        ),
        (
            UniCase::ascii("edenizations"),
            &[(0b01001, &ENTRY_EDENIZATIONS_17717672445150358731)],
        ),
        (
            UniCase::ascii("signalised"),
            &[(0b10010, &ENTRY_SIGNALIZED_1328658457279077123)],
        ),
        (
            UniCase::ascii("coziest"),
            &[(0b01001, &ENTRY_COZIEST_2405878050968803482)],
        ),
        (
            UniCase::ascii("dealcoholized"),
            &[(0b01001, &ENTRY_DEALCOHOLIZED_4879647847969574400)],
        ),
        (
            UniCase::ascii("laminarized"),
            &[(0b01001, &ENTRY_LAMINARIZED_1016333654497584825)],
        ),
        (
            UniCase::ascii("decimeters"),
            &[(0b00001, &ENTRY_DECIMETERS_4158783169372669202)],
        ),
        (
            UniCase::ascii("decalitre"),
            &[(0b11010, &ENTRY_DECALITER_4375398060796975724)],
        ),
        (
            UniCase::ascii("chloridising"),
            &[(0b10010, &ENTRY_CHLORIDIZING_13412386735842532684)],
        ),
        (
            UniCase::ascii("ionisers"),
            &[(0b10010, &ENTRY_IONIZERS_14153461400591590929)],
        ),
        (
            UniCase::ascii("carbonizer"),
            &[(0b01001, &ENTRY_CARBONIZER_12348552524098629169)],
        ),
        (
            UniCase::ascii("denaturalising"),
            &[(0b10010, &ENTRY_DENATURALIZING_11035796773484399105)],
        ),
        (
            UniCase::ascii("fractionalise"),
            &[(0b10010, &ENTRY_FRACTIONALIZE_6994927438734081827)],
        ),
        (
            UniCase::ascii("rhinocoelian"),
            &[(0b11010, &ENTRY_RHINOCELIAN_7468732235130691380)],
        ),
        (
            UniCase::ascii("scandalises"),
            &[(0b10010, &ENTRY_SCANDALIZES_11290093653234602832)],
        ),
        (
            UniCase::ascii("profanise"),
            &[(0b10010, &ENTRY_PROFANIZE_12830076681879400499)],
        ),
        (
            UniCase::ascii("technologize"),
            &[(0b01001, &ENTRY_TECHNOLOGIZE_4630575226590934600)],
        ),
        (
            UniCase::ascii("circularization"),
            &[(0b01001, &ENTRY_CIRCULARIZATION_17838622241027218582)],
        ),
        (
            UniCase::ascii("polarises"),
            &[(0b10010, &ENTRY_POLARIZES_2266758101576701172)],
        ),
        (
            UniCase::ascii("sluggardising"),
            &[(0b10010, &ENTRY_SLUGGARDIZING_3263004984707806773)],
        ),
        (
            UniCase::ascii("cognize"),
            &[(0b01001, &ENTRY_COGNIZE_7253118900028580039)],
        ),
        (
            UniCase::ascii("spheroidizes"),
            &[(0b01001, &ENTRY_SPHEROIDIZES_6259874484087826697)],
        ),
        (
            UniCase::ascii("parenthesised"),
            &[(0b10010, &ENTRY_PARENTHESIZED_13190399718764525857)],
        ),
        (
            UniCase::ascii("solarized"),
            &[(0b01001, &ENTRY_SOLARIZED_5808975743485239818)],
        ),
        (
            UniCase::ascii("marvellousliest"),
            &[(0b11010, &ENTRY_MARVELOUSLIEST_787848875312131772)],
        ),
        (
            UniCase::ascii("panegyrized"),
            &[(0b01001, &ENTRY_PANEGYRIZED_2757369675942335026)],
        ),
        (
            UniCase::ascii("bourbonise"),
            &[(0b10010, &ENTRY_BOURBONIZE_1178395603606873081)],
        ),
        (
            UniCase::ascii("specializing"),
            &[(0b01001, &ENTRY_SPECIALIZING_2079181106562003064)],
        ),
        (
            UniCase::ascii("divisionalisation"),
            &[(0b10010, &ENTRY_DIVISIONALIZATION_12097639934213939942)],
        ),
        (
            UniCase::ascii("militarization"),
            &[(0b01001, &ENTRY_MILITARIZATION_554898038906981603)],
        ),
        (
            UniCase::ascii("emotionises"),
            &[(0b10010, &ENTRY_EMOTIONIZES_4881347793120141643)],
        ),
        (
            UniCase::ascii("cupulae"),
            &[(0b11010, &ENTRY_CUPULE_4300809885306855718)],
        ),
        (
            UniCase::ascii("macadamize"),
            &[(0b01001, &ENTRY_MACADAMIZE_12591043180762607828)],
        ),
        (
            UniCase::ascii("palaeontologists"),
            &[(0b10010, &ENTRY_PALEONTOLOGISTS_13268509669082698999)],
        ),
        (
            UniCase::ascii("femalise"),
            &[(0b10010, &ENTRY_FEMALIZE_13901043989723708165)],
        ),
        (
            UniCase::ascii("recarbonises"),
            &[(0b10010, &ENTRY_RECARBONIZES_1395029874212040625)],
        ),
        (
            UniCase::ascii("economizing"),
            &[(0b01001, &ENTRY_ECONOMIZING_11359270378553989667)],
        ),
        (
            UniCase::ascii("overagonises"),
            &[(0b10010, &ENTRY_OVERAGONIZES_8549625565440966790)],
        ),
        (
            UniCase::ascii("reobjectivizations"),
            &[(0b01001, &ENTRY_REOBJECTIVIZATIONS_484037855015245777)],
        ),
        (
            UniCase::ascii("hamletize"),
            &[(0b01001, &ENTRY_HAMLETIZE_576738953922217726)],
        ),
        (
            UniCase::ascii("chaptalises"),
            &[(0b10010, &ENTRY_CHAPTALIZES_12293081829441947782)],
        ),
        (
            UniCase::ascii("philanthropizes"),
            &[(0b01001, &ENTRY_PHILANTHROPIZES_151487037009790340)],
        ),
        (
            UniCase::ascii("paraesthesias"),
            &[(0b11010, &ENTRY_PARESTHESIAS_1637525985108297517)],
        ),
        (
            UniCase::ascii("dechristianising"),
            &[(0b10010, &ENTRY_DECHRISTIANIZING_9955318127138092041)],
        ),
        (
            UniCase::ascii("unhonored"),
            &[(0b00001, &ENTRY_UNHONORED_5460665573065748506)],
        ),
        (
            UniCase::ascii("gynecol"),
            &[(0b10001, &ENTRY_GYNECOL_9831784870183209183)],
        ),
        (
            UniCase::ascii("arbalestre"),
            &[(0b11010, &ENTRY_ARBALESTER_17275327857939491618)],
        ),
        (
            UniCase::ascii("frivolers"),
            &[(0b00001, &ENTRY_FRIVOLERS_6222087214473089062)],
        ),
        (
            UniCase::ascii("diagonalises"),
            &[(0b10010, &ENTRY_DIAGONALIZES_15436394800752209539)],
        ),
        (
            UniCase::ascii("improvizatorize"),
            &[(0b00001, &ENTRY_IMPROVIZATORIZE_10750757082424118716)],
        ),
        (
            UniCase::ascii("nakedize"),
            &[(0b01001, &ENTRY_NAKEDIZE_4521587020024219245)],
        ),
        (
            UniCase::ascii("deindustrializing"),
            &[(0b01001, &ENTRY_DEINDUSTRIALIZING_3929932887349601221)],
        ),
        (
            UniCase::ascii("embolization"),
            &[(0b01001, &ENTRY_EMBOLIZATION_11273543037803448058)],
        ),
        (
            UniCase::ascii("circulariser"),
            &[(0b10010, &ENTRY_CIRCULARIZER_10781935971896485951)],
        ),
        (
            UniCase::ascii("scandaliser"),
            &[(0b10010, &ENTRY_SCANDALIZER_5001392876013065734)],
        ),
        (
            UniCase::ascii("unrealizables"),
            &[(0b01001, &ENTRY_UNREALIZABLES_9314641022749638380)],
        ),
        (
            UniCase::ascii("nominalize"),
            &[(0b01001, &ENTRY_NOMINALIZE_18405230656463200401)],
        ),
        (
            UniCase::ascii("crofterize"),
            &[(0b01001, &ENTRY_CROFTERIZE_16982662599909303513)],
        ),
        (
            UniCase::ascii("fraternization"),
            &[(0b01001, &ENTRY_FRATERNIZATION_12516017912114447659)],
        ),
        (
            UniCase::ascii("texturized"),
            &[(0b01001, &ENTRY_TEXTURIZED_13270620706415686595)],
        ),
        (
            UniCase::ascii("unmissionizeds"),
            &[(0b01001, &ENTRY_UNMISSIONIZEDS_10090086707555908231)],
        ),
        (
            UniCase::ascii("gynecocracies"),
            &[(0b10001, &ENTRY_GYNECOCRACIES_6538377328563789775)],
        ),
        (
            UniCase::ascii("vascularised"),
            &[(0b10010, &ENTRY_VASCULARIZED_207387324778454868)],
        ),
        (
            UniCase::ascii("outhumour"),
            &[(0b11010, &ENTRY_OUTHUMOR_5098392887011091131)],
        ),
        (
            UniCase::ascii("prejink"),
            &[(0b11010, &ENTRY_PERJINK_7961075561267618144)],
        ),
        (
            UniCase::ascii("defibrinised"),
            &[(0b10010, &ENTRY_DEFIBRINIZED_142002320112068005)],
        ),
        (
            UniCase::ascii("antipathise"),
            &[(0b10010, &ENTRY_ANTIPATHIZE_14999471117461116868)],
        ),
        (
            UniCase::ascii("unscrutinizinglier"),
            &[(0b01001, &ENTRY_UNSCRUTINIZINGLIER_16918089062255487129)],
        ),
        (
            UniCase::ascii("centremost"),
            &[(0b11010, &ENTRY_CENTERMOST_14667266636773107736)],
        ),
        (
            UniCase::ascii("popularized"),
            &[(0b01001, &ENTRY_POPULARIZED_13593967020396788947)],
        ),
        (
            UniCase::ascii("commercializations"),
            &[(0b01001, &ENTRY_COMMERCIALIZATIONS_17012404820436874389)],
        ),
        (
            UniCase::ascii("unoptimize"),
            &[(0b01001, &ENTRY_UNOPTIMIZE_8337218810202803852)],
        ),
        (
            UniCase::ascii("demonetized"),
            &[(0b01001, &ENTRY_DEMONETIZED_13800822593083516335)],
        ),
        (
            UniCase::ascii("rheadine"),
            &[(0b00001, &ENTRY_RHEADINE_9620364319130309940)],
        ),
        (
            UniCase::ascii("cerebralizes"),
            &[(0b01001, &ENTRY_CEREBRALIZES_14811698873620229158)],
        ),
        (
            UniCase::ascii("decerebrised"),
            &[(0b10010, &ENTRY_DECEREBRIZED_14339403834612181570)],
        ),
        (
            UniCase::ascii("getae"),
            &[(0b00001, &ENTRY_GETAE_1718634175022590867)],
        ),
        (
            UniCase::ascii("aphorisers"),
            &[(0b10010, &ENTRY_APHORIZERS_10347189849445130867)],
        ),
        (
            UniCase::ascii("criticisablest"),
            &[(0b10010, &ENTRY_CRITICIZABLEST_16577651845714565882)],
        ),
        (
            UniCase::ascii("mylonitise"),
            &[(0b10010, &ENTRY_MYLONITIZE_8331820604780621489)],
        ),
        (
            UniCase::ascii("frenular"),
            &[(0b00001, &ENTRY_FRENULAR_17354217019987840503)],
        ),
        (
            UniCase::ascii("baptisables"),
            &[(0b10010, &ENTRY_BAPTIZABLES_14971615946689154480)],
        ),
        (
            UniCase::ascii("expertising"),
            &[(0b10010, &ENTRY_EXPERTIZING_14124314311673129338)],
        ),
        (
            UniCase::ascii("colonizing"),
            &[(0b01001, &ENTRY_COLONIZING_17297511401074881747)],
        ),
        (
            UniCase::ascii("revitalisers"),
            &[(0b10010, &ENTRY_REVITALIZERS_8120596477873838119)],
        ),
        (
            UniCase::ascii("anathematizing"),
            &[(0b01001, &ENTRY_ANATHEMATIZING_10299965854697438675)],
        ),
        (
            UniCase::ascii("apotheosised"),
            &[(0b10010, &ENTRY_APOTHEOSIZED_2104097860710903144)],
        ),
        (
            UniCase::ascii("hypnotizer"),
            &[(0b01001, &ENTRY_HYPNOTIZER_13806710050342747653)],
        ),
        (
            UniCase::ascii("jeweling"),
            &[(0b00001, &ENTRY_JEWELING_14303762198587690677)],
        ),
        (
            UniCase::ascii("fluoridise"),
            &[(0b10010, &ENTRY_FLUORIDIZE_7749548833135664422)],
        ),
        (
            UniCase::ascii("federalises"),
            &[(0b10010, &ENTRY_FEDERALIZES_2587577566789708184)],
        ),
        (
            UniCase::ascii("canalise"),
            &[(0b10010, &ENTRY_CANALIZE_911721963215339223)],
        ),
        (
            UniCase::ascii("prologizes"),
            &[(0b01001, &ENTRY_PROLOGIZES_12046698321881734610)],
        ),
        (
            UniCase::ascii("vermilionise"),
            &[(0b10010, &ENTRY_VERMILIONIZE_1285328019998267214)],
        ),
        (
            UniCase::ascii("saxonisations"),
            &[(0b10010, &ENTRY_SAXONIZATIONS_2318853882636501152)],
        ),
        (
            UniCase::ascii("deodorizations"),
            &[(0b01001, &ENTRY_DEODORIZATIONS_12657185289043189294)],
        ),
        (
            UniCase::ascii("unsavourilies"),
            &[(0b11010, &ENTRY_UNSAVORILIES_2379987631293155666)],
        ),
        (
            UniCase::ascii("cudgeller"),
            &[(0b11010, &ENTRY_CUDGELER_14634684249116397869)],
        ),
        (
            UniCase::ascii("imperialize"),
            &[(0b01001, &ENTRY_IMPERIALIZE_4481105644087115733)],
        ),
        (
            UniCase::ascii("hybridisablest"),
            &[(0b10010, &ENTRY_HYBRIDIZABLEST_373072217288267910)],
        ),
        (
            UniCase::ascii("perennialises"),
            &[(0b10010, &ENTRY_PERENNIALIZES_4803467841688723694)],
        ),
        (
            UniCase::ascii("potentize"),
            &[(0b01001, &ENTRY_POTENTIZE_10353484216841656321)],
        ),
        (
            UniCase::ascii("nodalises"),
            &[(0b10010, &ENTRY_NODALIZES_4523050365791573110)],
        ),
        (
            UniCase::ascii("marveller"),
            &[(0b11010, &ENTRY_MARVELER_5290759214700539442)],
        ),
        (
            UniCase::ascii("morselizes"),
            &[(0b01001, &ENTRY_MORSELIZES_1717809719310113488)],
        ),
        (
            UniCase::ascii("outmanoeuvred"),
            &[(0b11010, &ENTRY_OUTMANEUVERED_13287238199156602214)],
        ),
        (
            UniCase::ascii("modularization"),
            &[(0b01001, &ENTRY_MODULARIZATION_3680687403533449721)],
        ),
        (
            UniCase::ascii("winterizations"),
            &[(0b01001, &ENTRY_WINTERIZATIONS_13592272727744097379)],
        ),
        (
            UniCase::ascii("palaeoentomologist"),
            &[(0b11010, &ENTRY_PALEOENTOMOLOGIST_5711399062674583841)],
        ),
        (
            UniCase::ascii("alkalization"),
            &[(0b01001, &ENTRY_ALKALIZATION_8215651930061013709)],
        ),
        (
            UniCase::ascii("peptizes"),
            &[(0b01001, &ENTRY_PEPTIZES_5403839734258988322)],
        ),
        (
            UniCase::ascii("monopolizes"),
            &[(0b01001, &ENTRY_MONOPOLIZES_6838092214769726019)],
        ),
        (
            UniCase::ascii("prosocoele"),
            &[(0b11010, &ENTRY_PROSOCELE_8377653530954019059)],
        ),
        (
            UniCase::ascii("reprivatized"),
            &[(0b01001, &ENTRY_REPRIVATIZED_12098289997527637409)],
        ),
        (
            UniCase::ascii("culturise"),
            &[(0b10010, &ENTRY_CULTURIZE_9663475963702798186)],
        ),
        (
            UniCase::ascii("colorized"),
            &[(0b00001, &ENTRY_COLORIZED_1927556635004418734)],
        ),
        (
            UniCase::ascii("sovietized"),
            &[(0b01001, &ENTRY_SOVIETIZED_7565927092510685793)],
        ),
        (
            UniCase::ascii("polydaemonist"),
            &[(0b11010, &ENTRY_POLYDEMONIST_2400662006979178253)],
        ),
        (
            UniCase::ascii("decolonisation"),
            &[(0b10010, &ENTRY_DECOLONIZATION_14844676044557344393)],
        ),
        (
            UniCase::ascii("devocalises"),
            &[(0b10010, &ENTRY_DEVOCALIZES_11452435934127095123)],
        ),
        (
            UniCase::ascii("reprivatisation"),
            &[(0b10010, &ENTRY_REPRIVATIZATION_13650773811954050943)],
        ),
        (
            UniCase::ascii("oxidiser"),
            &[(0b10010, &ENTRY_OXIDIZER_8663348272113963982)],
        ),
        (
            UniCase::ascii("preacherises"),
            &[(0b10010, &ENTRY_PREACHERIZES_18214780901228990451)],
        ),
        (
            UniCase::ascii("guebres"),
            &[(0b11010, &ENTRY_GUEBERS_8470590757377245464)],
        ),
        (
            UniCase::ascii("annualises"),
            &[(0b10010, &ENTRY_ANNUALIZES_784688421746976936)],
        ),
        (
            UniCase::ascii("localisations"),
            &[(0b10010, &ENTRY_LOCALIZATIONS_2073048544247751824)],
        ),
        (
            UniCase::ascii("unrevelationize"),
            &[(0b01001, &ENTRY_UNREVELATIONIZE_17021292236492045263)],
        ),
        (
            UniCase::ascii("lionized"),
            &[(0b01001, &ENTRY_LIONIZED_1114575847150322021)],
        ),
        (
            UniCase::ascii("defence"),
            &[(0b11010, &ENTRY_DEFENSE_11018687793676709280)],
        ),
        (
            UniCase::ascii("ridiculize"),
            &[(0b01001, &ENTRY_RIDICULIZE_1054636858349594298)],
        ),
        (
            UniCase::ascii("gelatinises"),
            &[(0b10010, &ENTRY_GELATINIZES_1595883472582938174)],
        ),
        (
            UniCase::ascii("jours"),
            &[(0b11010, &ENTRY_JORS_11914557043762091913)],
        ),
        (
            UniCase::ascii("demineralizing"),
            &[(0b01001, &ENTRY_DEMINERALIZING_8656195446853674994)],
        ),
        (
            UniCase::ascii("laicizations"),
            &[(0b01001, &ENTRY_LAICIZATIONS_6800567689500405023)],
        ),
        (
            UniCase::ascii("eudaemonics"),
            &[(0b11010, &ENTRY_EUDEMONICS_11983069269785700336)],
        ),
        (
            UniCase::ascii("cupelation"),
            &[(0b00001, &ENTRY_CUPELATION_14255540896200543840)],
        ),
        (
            UniCase::ascii("travelings"),
            &[(0b00001, &ENTRY_TRAVELINGS_4473114144843360272)],
        ),
        (
            UniCase::ascii("chromizing"),
            &[(0b01001, &ENTRY_CHROMIZING_1826459851914480574)],
        ),
        (
            UniCase::ascii("ethnicize"),
            &[(0b01001, &ENTRY_ETHNICIZE_9658075899558980564)],
        ),
        (
            UniCase::ascii("epiphanising"),
            &[(0b10010, &ENTRY_EPIPHANIZING_5611514449736046211)],
        ),
        (
            UniCase::ascii("evolutionizes"),
            &[(0b01001, &ENTRY_EVOLUTIONIZES_7496995105206806629)],
        ),
        (
            UniCase::ascii("outlabor"),
            &[(0b10001, &ENTRY_OUTLABOR_550919659652857953)],
        ),
        (
            UniCase::ascii("perviousnesses"),
            &[(0b00001, &ENTRY_PERVIOUSNESSES_15261112133254148006)],
        ),
        (
            UniCase::ascii("territorialises"),
            &[(0b10010, &ENTRY_TERRITORIALIZES_8896187296510093610)],
        ),
        (
            UniCase::ascii("naphthalized"),
            &[(0b01001, &ENTRY_NAPHTHALIZED_8961699346078499371)],
        ),
        (
            UniCase::ascii("paraffinizes"),
            &[(0b01001, &ENTRY_PARAFFINIZES_12064336249396828188)],
        ),
        (
            UniCase::ascii("rivalises"),
            &[(0b10010, &ENTRY_RIVALIZES_2452557101215464168)],
        ),
        (
            UniCase::ascii("negritized"),
            &[(0b01001, &ENTRY_NEGRITIZED_10107617084750061015)],
        ),
        (
            UniCase::ascii("pidginized"),
            &[(0b01001, &ENTRY_PIDGINIZED_9275549597676109200)],
        ),
        (
            UniCase::ascii("uniformizes"),
            &[(0b01001, &ENTRY_UNIFORMIZES_5570715002596396628)],
        ),
        (
            UniCase::ascii("fossilises"),
            &[(0b10010, &ENTRY_FOSSILIZES_16548112466000258743)],
        ),
        (
            UniCase::ascii("unstigmatized"),
            &[(0b01001, &ENTRY_UNSTIGMATIZED_8147628030660872313)],
        ),
        (
            UniCase::ascii("vermeiles"),
            &[(0b00001, &ENTRY_VERMEILES_6091101275731102631)],
        ),
        (
            UniCase::ascii("lignitize"),
            &[(0b01001, &ENTRY_LIGNITIZE_1767530194184708816)],
        ),
        (
            UniCase::ascii("ruralisation"),
            &[(0b10010, &ENTRY_RURALIZATION_12199675531569627500)],
        ),
        (
            UniCase::ascii("praecuneus"),
            &[(0b11010, &ENTRY_PRECUNEUS_11481546809254856891)],
        ),
        (
            UniCase::ascii("germanizing"),
            &[(0b01001, &ENTRY_GERMANIZING_10332352803362198758)],
        ),
        (
            UniCase::ascii("patronizes"),
            &[(0b01001, &ENTRY_PATRONIZES_339151254169886766)],
        ),
        (
            UniCase::ascii("teutonising"),
            &[(0b10010, &ENTRY_TEUTONIZING_1726928371121949281)],
        ),
        (
            UniCase::ascii("futurizes"),
            &[(0b01001, &ENTRY_FUTURIZES_17164339410840070834)],
        ),
        (
            UniCase::ascii("subspecialise"),
            &[(0b10010, &ENTRY_SUBSPECIALIZE_5110123534584151405)],
        ),
        (
            UniCase::ascii("optimized"),
            &[(0b01001, &ENTRY_OPTIMIZED_8242242244633121729)],
        ),
        (
            UniCase::ascii("chenixes"),
            &[(0b10001, &ENTRY_CHENIXES_18140842653808609264)],
        ),
        (
            UniCase::ascii("illegalization"),
            &[(0b01001, &ENTRY_ILLEGALIZATION_4625157464834082989)],
        ),
        (
            UniCase::ascii("dispersonalizes"),
            &[(0b01001, &ENTRY_DISPERSONALIZES_16334720714201751331)],
        ),
        (
            UniCase::ascii("honors"),
            &[(0b11001, &ENTRY_HONORS_13638393746809061853)],
        ),
        (
            UniCase::ascii("haemotoxin"),
            &[(0b11010, &ENTRY_HEMOTOXIN_15634750057214615777)],
        ),
        (
            UniCase::ascii("caponizer"),
            &[(0b01001, &ENTRY_CAPONIZER_5653304916609979245)],
        ),
        (
            UniCase::ascii("polarising"),
            &[(0b10010, &ENTRY_POLARIZING_7254748840434133551)],
        ),
        (
            UniCase::ascii("symphonizing"),
            &[(0b01001, &ENTRY_SYMPHONIZING_6006748045534915173)],
        ),
        (
            UniCase::ascii("duellings"),
            &[(0b11010, &ENTRY_DUELINGS_14759091337280437276)],
        ),
        (
            UniCase::ascii("scepticest"),
            &[(0b11010, &ENTRY_SKEPTICEST_13124338123587490640)],
        ),
        (
            UniCase::ascii("vowelisations"),
            &[(0b10010, &ENTRY_VOWELIZATIONS_5803231980451353684)],
        ),
        (
            UniCase::ascii("semivulcaniseds"),
            &[(0b10010, &ENTRY_SEMIVULCANIZEDS_13162744092050979464)],
        ),
        (
            UniCase::ascii("cacodemon"),
            &[(0b10001, &ENTRY_CACODEMON_14159660385143717967)],
        ),
        (
            UniCase::ascii("acuesthesia"),
            &[(0b00001, &ENTRY_ACUESTHESIA_12188708987996711429)],
        ),
        (
            UniCase::ascii("dastardise"),
            &[(0b10010, &ENTRY_DASTARDIZE_9137258977351501392)],
        ),
        (
            UniCase::ascii("detribalize"),
            &[(0b01001, &ENTRY_DETRIBALIZE_15143242476306432587)],
        ),
        (
            UniCase::ascii("unevangelizedder"),
            &[(0b01001, &ENTRY_UNEVANGELIZEDDER_14389146019253414049)],
        ),
        (
            UniCase::ascii("logicizing"),
            &[(0b01001, &ENTRY_LOGICIZING_6614561759161636962)],
        ),
        (
            UniCase::ascii("relabelling"),
            &[(0b11010, &ENTRY_RELABELING_17510567259263942187)],
        ),
        (
            UniCase::ascii("majorizes"),
            &[(0b01001, &ENTRY_MAJORIZES_12441874624584501250)],
        ),
        (
            UniCase::ascii("informalises"),
            &[(0b10010, &ENTRY_INFORMALIZES_10886097819718009126)],
        ),
        (
            UniCase::ascii("prenomen"),
            &[(0b00001, &ENTRY_PRAENOMEN_2873680985932826564)],
        ),
        (
            UniCase::ascii("theosophising"),
            &[(0b10010, &ENTRY_THEOSOPHIZING_16087803010212187991)],
        ),
        (
            UniCase::ascii("harmonizable"),
            &[(0b01001, &ENTRY_HARMONIZABLE_3524685114296597734)],
        ),
        (
            UniCase::ascii("euphonise"),
            &[(0b10010, &ENTRY_EUPHONIZE_12154684566192054671)],
        ),
        (
            UniCase::ascii("apostolised"),
            &[(0b10010, &ENTRY_APOSTOLIZED_968548481129324663)],
        ),
        (
            UniCase::ascii("apprisal"),
            &[(0b10010, &ENTRY_APPRIZAL_6335618835659004475)],
        ),
        (
            UniCase::ascii("unitised"),
            &[(0b10010, &ENTRY_UNITIZED_3014655947841823471)],
        ),
        (
            UniCase::ascii("stabilizator"),
            &[(0b01001, &ENTRY_STABILIZATOR_17741108746142693419)],
        ),
        (
            UniCase::ascii("preve"),
            &[(0b11010, &ENTRY_PERVE_18165674324823475517)],
        ),
        (
            UniCase::ascii("archaeozoic"),
            &[(0b11010, &ENTRY_ARCHEOZOIC_18268674600637414324)],
        ),
        (
            UniCase::ascii("phrenologizes"),
            &[(0b01001, &ENTRY_PHRENOLOGIZES_9501866944819113429)],
        ),
        (
            UniCase::ascii("proctodea"),
            &[(0b00001, &ENTRY_PROCTODEA_7394203941595428980)],
        ),
        (
            UniCase::ascii("nonanaemic"),
            &[(0b11010, &ENTRY_NONANEMIC_973581033440143676)],
        ),
        (
            UniCase::ascii("virilising"),
            &[(0b10010, &ENTRY_VIRILIZING_3864311870427123549)],
        ),
        (
            UniCase::ascii("hydremic"),
            &[(0b10001, &ENTRY_HYDREMIC_7677276768554498277)],
        ),
        (
            UniCase::ascii("unorganized"),
            &[(0b01001, &ENTRY_UNORGANIZED_8287041392290100911)],
        ),
        (
            UniCase::ascii("desalinising"),
            &[(0b10010, &ENTRY_DESALINIZING_375221854324330696)],
        ),
        (
            UniCase::ascii("neglig"),
            &[(0b00001, &ENTRY_NEGLIGEE_14354404705992424135)],
        ),
        (
            UniCase::ascii("earlierising"),
            &[(0b10010, &ENTRY_EARLIERIZING_8179681759986389983)],
        ),
        (
            UniCase::ascii("harmonisers"),
            &[(0b10010, &ENTRY_HARMONIZERS_14760666922495363496)],
        ),
        (
            UniCase::ascii("sympathizers"),
            &[(0b01001, &ENTRY_SYMPATHIZERS_3558777146047267180)],
        ),
        (
            UniCase::ascii("haematemesis"),
            &[(0b11010, &ENTRY_HEMATEMESIS_1150278158641123049)],
        ),
        (
            UniCase::ascii("initialization"),
            &[(0b01001, &ENTRY_INITIALIZATION_13629327501468098349)],
        ),
        (
            UniCase::ascii("agrarianize"),
            &[(0b01001, &ENTRY_AGRARIANIZE_6371637247712194397)],
        ),
        (
            UniCase::ascii("misrecognises"),
            &[(0b10010, &ENTRY_MISRECOGNIZES_18195281488073038600)],
        ),
        (
            UniCase::ascii("papilledema"),
            &[(0b10001, &ENTRY_PAPILLEDEMA_13947738993687090385)],
        ),
        (
            UniCase::ascii("aestheticians"),
            &[(0b11010, &ENTRY_ESTHETICIANS_4428473313020471578)],
        ),
        (
            UniCase::ascii("twier"),
            &[(0b00001, &ENTRY_TWIER_17943274413772224375)],
        ),
        (
            UniCase::ascii("cadmiumizes"),
            &[(0b01001, &ENTRY_CADMIUMIZES_784331431098990189)],
        ),
        (
            UniCase::ascii("synereses"),
            &[(0b00001, &ENTRY_SYNERESES_8324225573506584897)],
        ),
        (
            UniCase::ascii("graecising"),
            &[
                (0b10010, &ENTRY_GRAECIZING_4425395536860878106),
                (0b11010, &ENTRY_GRECISING_9235719733885081536),
            ],
        ),
        (
            UniCase::ascii("italicised"),
            &[(0b10010, &ENTRY_ITALICIZED_17732755536256154944)],
        ),
        (
            UniCase::ascii("culturization"),
            &[(0b01001, &ENTRY_CULTURIZATION_8113112597865327363)],
        ),
        (
            UniCase::ascii("dedramatising"),
            &[(0b10010, &ENTRY_DEDRAMATIZING_62928488875515887)],
        ),
        (
            UniCase::ascii("dollarizations"),
            &[(0b01001, &ENTRY_DOLLARIZATIONS_17625833038744269977)],
        ),
        (
            UniCase::ascii("funeralize"),
            &[(0b01001, &ENTRY_FUNERALIZE_16393341863187882210)],
        ),
        (
            UniCase::ascii("localizes"),
            &[(0b01001, &ENTRY_LOCALIZES_3870056311066884314)],
        ),
        (
            UniCase::ascii("fertilisational"),
            &[(0b10010, &ENTRY_FERTILIZATIONAL_6643363430121231287)],
        ),
        (
            UniCase::ascii("unnoncolourables"),
            &[(0b11010, &ENTRY_UNNONCOLORABLES_11603706591378503372)],
        ),
        (
            UniCase::ascii("vagabondise"),
            &[(0b10010, &ENTRY_VAGABONDIZE_11652184056860982029)],
        ),
        (
            UniCase::ascii("delocalization"),
            &[(0b01001, &ENTRY_DELOCALIZATION_4312310346451666001)],
        ),
        (
            UniCase::ascii("paleontography"),
            &[(0b10001, &ENTRY_PALEONTOGRAPHY_7112963726296976935)],
        ),
        (
            UniCase::ascii("vulgarisers"),
            &[(0b10010, &ENTRY_VULGARIZERS_1013773146928265577)],
        ),
        (
            UniCase::ascii("anaesthetizer"),
            &[(0b01000, &ENTRY_ANESTHETIZER_5418733284803121475)],
        ),
        (
            UniCase::ascii("spanopnoea"),
            &[(0b11010, &ENTRY_SPANOPNEA_8865008578129066489)],
        ),
        (
            UniCase::ascii("calkings"),
            &[(0b00001, &ENTRY_CAULKS_14651084141226031502)],
        ),
        (
            UniCase::ascii("superhumanized"),
            &[(0b01001, &ENTRY_SUPERHUMANIZED_15608702836101169679)],
        ),
        (
            UniCase::ascii("signalling"),
            &[(0b11010, &ENTRY_SIGNALING_38367410174135288)],
        ),
        (
            UniCase::ascii("althea"),
            &[(0b10001, &ENTRY_ALTHEA_11553591055146462879)],
        ),
        (
            UniCase::ascii("ecstaticise"),
            &[(0b10010, &ENTRY_ECSTATICIZE_10857806109758048478)],
        ),
        (
            UniCase::ascii("syndicalises"),
            &[(0b10010, &ENTRY_SYNDICALIZES_7458900059096200056)],
        ),
        (
            UniCase::ascii("parathyroidectomizes"),
            &[(0b01001, &ENTRY_PARATHYROIDECTOMIZES_13875716632357128903)],
        ),
        (
            UniCase::ascii("melena"),
            &[(0b00001, &ENTRY_MELENA_17340470388387299570)],
        ),
        (
            UniCase::ascii("woodcockises"),
            &[(0b10010, &ENTRY_WOODCOCKIZES_12391053488008876606)],
        ),
        (
            UniCase::ascii("aphorises"),
            &[(0b10010, &ENTRY_APHORIZES_13164228522572019559)],
        ),
        (
            UniCase::ascii("mythise"),
            &[(0b10010, &ENTRY_MYTHIZE_9908305862028630928)],
        ),
        (
            UniCase::ascii("unstigmatizeddest"),
            &[(0b01001, &ENTRY_UNSTIGMATIZEDDEST_5756983753240929122)],
        ),
        (
            UniCase::ascii("rivalizing"),
            &[(0b01001, &ENTRY_RIVALIZING_14048952717153236037)],
        ),
        (
            UniCase::ascii("archaisers"),
            &[(0b10010, &ENTRY_ARCHAIZERS_6972696703859538503)],
        ),
        (
            UniCase::ascii("neighbourings"),
            &[(0b11010, &ENTRY_NEIGHBORINGS_8765293309645015940)],
        ),
        (
            UniCase::ascii("fraenulum"),
            &[(0b11010, &ENTRY_FRENULUM_8351124618829742055)],
        ),
        (
            UniCase::ascii("rapturize"),
            &[(0b01001, &ENTRY_RAPTURIZE_14952128339321888268)],
        ),
        (
            UniCase::ascii("insolubilized"),
            &[(0b01001, &ENTRY_INSOLUBILIZED_11559003470253032575)],
        ),
        (
            UniCase::ascii("paralysinglies"),
            &[(0b11010, &ENTRY_PARALYZINGLIES_8785740653550502606)],
        ),
        (
            UniCase::ascii("intellectualized"),
            &[(0b01001, &ENTRY_INTELLECTUALIZED_8385887282030505172)],
        ),
        (
            UniCase::ascii("rapturises"),
            &[(0b10010, &ENTRY_RAPTURIZES_3958786363790102011)],
        ),
        (
            UniCase::ascii("persianisations"),
            &[(0b10010, &ENTRY_PERSIANIZATIONS_12804723289958534578)],
        ),
        (
            UniCase::ascii("teaselling"),
            &[
                (0b00001, &ENTRY_TEASELING_13695401286288634817),
                (0b00001, &ENTRY_TEASELING_2241001256394841761),
            ],
        ),
        (
            UniCase::ascii("spiralizations"),
            &[(0b01001, &ENTRY_SPIRALIZATIONS_2042085502750008288)],
        ),
        (
            UniCase::ascii("gormandized"),
            &[(0b01001, &ENTRY_GORMANDIZED_10731842314325530180)],
        ),
        (
            UniCase::ascii("matronize"),
            &[(0b01001, &ENTRY_MATRONIZE_16335366679027459825)],
        ),
        (
            UniCase::ascii("anathematizer"),
            &[(0b01001, &ENTRY_ANATHEMATIZER_3378013434055917757)],
        ),
        (
            UniCase::ascii("unsulphuriseds"),
            &[(0b10010, &ENTRY_UNSULPHURIZEDS_10925557470603907058)],
        ),
        (
            UniCase::ascii("federalized"),
            &[(0b01001, &ENTRY_FEDERALIZED_4780345550916631576)],
        ),
        (
            UniCase::ascii("immobilised"),
            &[(0b10010, &ENTRY_IMMOBILIZED_6366288157273401051)],
        ),
        (
            UniCase::ascii("deoxidizations"),
            &[(0b01001, &ENTRY_DEOXIDIZATIONS_13683604498444194612)],
        ),
        (
            UniCase::ascii("apheresis"),
            &[(0b10001, &ENTRY_APHERESIS_14381380856101872428)],
        ),
        (
            UniCase::ascii("organizables"),
            &[(0b01001, &ENTRY_ORGANIZABLES_3895944364193703180)],
        ),
        (
            UniCase::ascii("socialize"),
            &[(0b01001, &ENTRY_SOCIALIZE_6985846630440818655)],
        ),
        (
            UniCase::ascii("dracenaceae"),
            &[(0b00001, &ENTRY_DRACENACEAE_16212683568672807360)],
        ),
        (
            UniCase::ascii("fulgorous"),
            &[(0b00001, &ENTRY_FULGOROUS_16556587498459255650)],
        ),
        (
            UniCase::ascii("biassing"),
            &[(0b10011, &ENTRY_BIASING_6997021477668826126)],
        ),
        (
            UniCase::ascii("haematosepsis"),
            &[(0b11010, &ENTRY_HEMATOSEPSIS_13675575187899218762)],
        ),
        (
            UniCase::ascii("metagrabolises"),
            &[(0b10010, &ENTRY_METAGRABOLIZES_14921829028195999540)],
        ),
        (
            UniCase::ascii("polarize"),
            &[(0b01001, &ENTRY_POLARIZE_4104034252753850020)],
        ),
        (
            UniCase::ascii("underutilisations"),
            &[(0b10010, &ENTRY_UNDERUTILIZATIONS_2736156761561305874)],
        ),
        (
            UniCase::ascii("objectivises"),
            &[(0b10010, &ENTRY_OBJECTIVIZES_9154527217307669621)],
        ),
        (
            UniCase::ascii("latinizers"),
            &[(0b01001, &ENTRY_LATINIZERS_5843855516266216328)],
        ),
        (
            UniCase::ascii("fatalises"),
            &[(0b10010, &ENTRY_FATALIZES_16154483171742069422)],
        ),
        (
            UniCase::ascii("eudemonics"),
            &[(0b00001, &ENTRY_EUDEMONICS_11983069269785700336)],
        ),
        (
            UniCase::ascii("renationalised"),
            &[(0b10010, &ENTRY_RENATIONALIZED_245883000485081396)],
        ),
        (
            UniCase::ascii("rhaphe"),
            &[(0b00001, &ENTRY_RHAPHE_12384818764664453874)],
        ),
        (
            UniCase::ascii("picturization"),
            &[(0b01001, &ENTRY_PICTURIZATION_16841013829361902460)],
        ),
        (
            UniCase::ascii("illegalisations"),
            &[(0b10010, &ENTRY_ILLEGALIZATIONS_1156484598694873817)],
        ),
        (
            UniCase::ascii("funneller"),
            &[(0b11010, &ENTRY_FUNNELER_2628031221069632410)],
        ),
        (
            UniCase::ascii("proselytise"),
            &[(0b10010, &ENTRY_PROSELYTIZE_2045808347498243297)],
        ),
        (
            UniCase::ascii("dishonourablies"),
            &[(0b11010, &ENTRY_DISHONORABLIES_14942803523606691356)],
        ),
        (
            UniCase::ascii("deputized"),
            &[(0b01001, &ENTRY_DEPUTIZED_7193789182724757168)],
        ),
        (
            UniCase::ascii("formularises"),
            &[(0b10010, &ENTRY_FORMULARIZES_4653655791226941263)],
        ),
        (
            UniCase::ascii("microcolorimetrically"),
            &[(0b00001, &ENTRY_MICROCOLORIMETRICALLY_642505822013488513)],
        ),
        (
            UniCase::ascii("saxonise"),
            &[(0b10010, &ENTRY_SAXONIZE_9115638203834180868)],
        ),
        (
            UniCase::ascii("unspecializeddest"),
            &[(0b01001, &ENTRY_UNSPECIALIZEDDEST_7579806759888561816)],
        ),
        (
            UniCase::ascii("stilboestrols"),
            &[(0b11010, &ENTRY_STILBESTROLS_15735220233409139967)],
        ),
        (
            UniCase::ascii("rephosphorise"),
            &[(0b10010, &ENTRY_REPHOSPHORIZE_419529770369265116)],
        ),
        (
            UniCase::ascii("posterize"),
            &[(0b01001, &ENTRY_POSTERIZE_4633009065826989954)],
        ),
        (
            UniCase::ascii("unneighborlikes"),
            &[(0b00001, &ENTRY_UNNEIGHBORLIKES_4354261620124645883)],
        ),
        (
            UniCase::ascii("savourless"),
            &[(0b11010, &ENTRY_SAVORLESS_8806630377030275637)],
        ),
        (
            UniCase::ascii("journaliser"),
            &[(0b10010, &ENTRY_JOURNALIZER_17240098793213073148)],
        ),
        (
            UniCase::ascii("gasolene"),
            &[(0b10011, &ENTRY_GASOLINE_9743796479901328135)],
        ),
        (
            UniCase::ascii("disillusionise"),
            &[(0b10010, &ENTRY_DISILLUSIONIZE_6725876315510879655)],
        ),
        (
            UniCase::ascii("asepticizing"),
            &[(0b01001, &ENTRY_ASEPTICIZING_16831292622846251458)],
        ),
        (
            UniCase::ascii("packetising"),
            &[(0b10010, &ENTRY_PACKETIZING_11521124697410978844)],
        ),
        (
            UniCase::ascii("decimalizing"),
            &[(0b01001, &ENTRY_DECIMALIZING_6772930949596594022)],
        ),
        (
            UniCase::ascii("epicenters"),
            &[(0b00001, &ENTRY_EPICENTERS_13863528771268891291)],
        ),
        (
            UniCase::ascii("misanthropising"),
            &[(0b10010, &ENTRY_MISANTHROPIZING_17542823159662397794)],
        ),
        (
            UniCase::ascii("symboling"),
            &[(0b00001, &ENTRY_SYMBOLING_10019336982510109720)],
        ),
        (
            UniCase::ascii("recentralize"),
            &[(0b01001, &ENTRY_RECENTRALIZE_5404153365159026113)],
        ),
        (
            UniCase::ascii("crystallizablest"),
            &[(0b01001, &ENTRY_CRYSTALLIZABLEST_11639541143335039276)],
        ),
        (
            UniCase::ascii("tebilised"),
            &[(0b10010, &ENTRY_TEBILIZED_12603919274755080976)],
        ),
        (
            UniCase::ascii("cyclization"),
            &[(0b01001, &ENTRY_CYCLIZATION_18360017396052282635)],
        ),
        (
            UniCase::ascii("frizette"),
            &[(0b01001, &ENTRY_FRIZETTE_15044855804093147853)],
        ),
        (
            UniCase::ascii("preorganisations"),
            &[(0b10010, &ENTRY_PREORGANIZATIONS_3818715016042200743)],
        ),
        (
            UniCase::ascii("eudaemonists"),
            &[(0b11010, &ENTRY_EUDEMONISTS_8607780052774605016)],
        ),
        (
            UniCase::ascii("glutaei"),
            &[(0b11010, &ENTRY_GLUTEI_16791170565919408237)],
        ),
        (
            UniCase::ascii("grene"),
            &[(0b11010, &ENTRY_GERNE_10723705562317631976)],
        ),
        (
            UniCase::ascii("scrutinizers"),
            &[(0b01001, &ENTRY_SCRUTINIZERS_9843755621018893931)],
        ),
        (
            UniCase::ascii("unpopularised"),
            &[(0b10010, &ENTRY_UNPOPULARIZED_76466767521665438)],
        ),
        (
            UniCase::ascii("gor"),
            &[(0b00001, &ENTRY_GOR_14093694443247898321)],
        ),
        (
            UniCase::ascii("christianized"),
            &[(0b01001, &ENTRY_CHRISTIANIZED_2305498091852997860)],
        ),
        (
            UniCase::ascii("anodized"),
            &[(0b01001, &ENTRY_ANODIZED_7735922642387297722)],
        ),
        (
            UniCase::ascii("haemosporidian"),
            &[(0b11010, &ENTRY_HEMOSPORIDIAN_12777425045521991692)],
        ),
        (
            UniCase::ascii("remilitarizing"),
            &[(0b01001, &ENTRY_REMILITARIZING_4173334694500632492)],
        ),
        (
            UniCase::ascii("slavicize"),
            &[(0b01001, &ENTRY_SLAVICIZE_9761827906822368262)],
        ),
        (
            UniCase::ascii("rejuvenises"),
            &[(0b10010, &ENTRY_REJUVENIZES_13596416797841620302)],
        ),
        (
            UniCase::ascii("dehumanisations"),
            &[(0b10010, &ENTRY_DEHUMANIZATIONS_6897797502184645692)],
        ),
        (
            UniCase::ascii("semifossilised"),
            &[(0b10010, &ENTRY_SEMIFOSSILIZED_9350071948098066704)],
        ),
        (
            UniCase::ascii("callipers"),
            &[(0b11010, &ENTRY_CALIPERS_7817536690880904969)],
        ),
        (
            UniCase::ascii("predy"),
            &[(0b11010, &ENTRY_PERDY_1390936130181263743)],
        ),
        (
            UniCase::ascii("volatilising"),
            &[(0b10010, &ENTRY_VOLATILIZING_4582472073708524953)],
        ),
        (
            UniCase::ascii("vernacularising"),
            &[(0b10010, &ENTRY_VERNACULARIZING_10081295290347631824)],
        ),
        (
            UniCase::ascii("depolymerizing"),
            &[(0b01001, &ENTRY_DEPOLYMERIZING_9371889196944478207)],
        ),
        (
            UniCase::ascii("dogmatisations"),
            &[(0b10010, &ENTRY_DOGMATIZATIONS_16998792177218196465)],
        ),
        (
            UniCase::ascii("lipemic"),
            &[(0b10001, &ENTRY_LIPEMIC_10806335327474718728)],
        ),
        (
            UniCase::ascii("disseises"),
            &[(0b10010, &ENTRY_DISSEIZES_2475038653439253891)],
        ),
        (
            UniCase::ascii("tinsellier"),
            &[(0b11010, &ENTRY_TINSELIER_17862744387346717732)],
        ),
        (
            UniCase::ascii("unitizes"),
            &[(0b01001, &ENTRY_UNITIZES_11137940003038331316)],
        ),
        (
            UniCase::ascii("miaowed"),
            &[(0b10011, &ENTRY_MEOWED_15719981813416166348)],
        ),
        (
            UniCase::ascii("reconceptualisation"),
            &[(0b10010, &ENTRY_RECONCEPTUALIZATION_3284710301791003378)],
        ),
        (
            UniCase::ascii("reharmonisation"),
            &[(0b10010, &ENTRY_REHARMONIZATION_12536421913907080148)],
        ),
        (
            UniCase::ascii("haviours"),
            &[(0b11010, &ENTRY_HAVIORS_7709423866676716486)],
        ),
        (
            UniCase::ascii("hematherm"),
            &[(0b10001, &ENTRY_HEMATHERM_5926070727779344344)],
        ),
        (
            UniCase::ascii("pseudoanaemias"),
            &[(0b11010, &ENTRY_PSEUDOANEMIAS_6046630203472884287)],
        ),
        (
            UniCase::ascii("glamourless"),
            &[(0b11010, &ENTRY_GLAMORLESS_3213378030533857078)],
        ),
        (
            UniCase::ascii("deodorise"),
            &[(0b10010, &ENTRY_DEODORIZE_16215032566622833150)],
        ),
        (
            UniCase::ascii("morbidizes"),
            &[(0b01001, &ENTRY_MORBIDIZES_2796191092499149016)],
        ),
        (
            UniCase::ascii("satirise"),
            &[(0b10010, &ENTRY_SATIRIZE_4670452432959122101)],
        ),
        (
            UniCase::ascii("solemnisations"),
            &[(0b10010, &ENTRY_SOLEMNIZATIONS_6129091422641859142)],
        ),
        (
            UniCase::ascii("rematerializes"),
            &[(0b01001, &ENTRY_REMATERIALIZES_9384263525573606944)],
        ),
        (
            UniCase::ascii("curarize"),
            &[(0b01001, &ENTRY_CURARIZE_9480914079622972520)],
        ),
        (
            UniCase::ascii("cerolite"),
            &[(0b00001, &ENTRY_CEROLITE_7632841335460717740)],
        ),
        (
            UniCase::ascii("thermalisation"),
            &[(0b10010, &ENTRY_THERMALIZATION_7024136436456711519)],
        ),
        (
            UniCase::ascii("galvanisations"),
            &[(0b10010, &ENTRY_GALVANIZATIONS_16208569109815481187)],
        ),
        (
            UniCase::ascii("mineralises"),
            &[(0b10010, &ENTRY_MINERALIZES_4329461307318398064)],
        ),
        (
            UniCase::ascii("sanforizing"),
            &[(0b01001, &ENTRY_SANFORIZING_2868487486423425023)],
        ),
        (
            UniCase::ascii("reformades"),
            &[(0b00001, &ENTRY_REFORMADES_3091028366731709504)],
        ),
        (
            UniCase::ascii("sensationalises"),
            &[(0b10010, &ENTRY_SENSATIONALIZES_6023223775469404764)],
        ),
        (
            UniCase::ascii("fraternise"),
            &[(0b10010, &ENTRY_FRATERNIZE_10028051674996391984)],
        ),
        (
            UniCase::ascii("cannibalising"),
            &[(0b10010, &ENTRY_CANNIBALIZING_12609939168668624233)],
        ),
        (
            UniCase::ascii("milligrammes"),
            &[(0b11010, &ENTRY_MILLIGRAMS_7781869386637459768)],
        ),
        (
            UniCase::ascii("electricise"),
            &[(0b10010, &ENTRY_ELECTRICIZE_4911015515844771622)],
        ),
        (
            UniCase::ascii("pollenizer"),
            &[(0b01001, &ENTRY_POLLENIZER_5840287768704113985)],
        ),
        (
            UniCase::ascii("sterilisables"),
            &[(0b10010, &ENTRY_STERILIZABLES_395845848212238864)],
        ),
        (
            UniCase::ascii("trioecious"),
            &[(0b11010, &ENTRY_TRIECIOUS_13315610863197702350)],
        ),
        (
            UniCase::ascii("hematoxylic"),
            &[(0b10001, &ENTRY_HEMATOXYLIC_8256186193967626317)],
        ),
        (
            UniCase::ascii("danizes"),
            &[(0b01001, &ENTRY_DANIZES_982119247166854426)],
        ),
        (
            UniCase::ascii("arytenoids"),
            &[(0b00001, &ENTRY_ARYTENOIDS_4570196976416030148)],
        ),
        (
            UniCase::ascii("atomisation"),
            &[(0b10010, &ENTRY_ATOMIZATION_17590563802310665738)],
        ),
        (
            UniCase::ascii("empathise"),
            &[(0b10010, &ENTRY_EMPATHIZE_1626505131224915017)],
        ),
        (
            UniCase::ascii("odorised"),
            &[(0b10010, &ENTRY_ODORIZED_12401728499096074253)],
        ),
        (
            UniCase::ascii("haemoglobinopathy"),
            &[(0b11010, &ENTRY_HEMOGLOBINOPATHY_14568715325380669233)],
        ),
        (
            UniCase::ascii("overlaboring"),
            &[(0b00001, &ENTRY_OVERLABORING_15266943753097543372)],
        ),
        (
            UniCase::ascii("humoural"),
            &[(0b11010, &ENTRY_HUMORAL_2853760863304111656)],
        ),
        (
            UniCase::ascii("spiritualisers"),
            &[(0b10010, &ENTRY_SPIRITUALIZERS_3732134443047012330)],
        ),
        (
            UniCase::ascii("cutinize"),
            &[(0b01001, &ENTRY_CUTINIZE_17770128684096533482)],
        ),
        (
            UniCase::ascii("prerealization"),
            &[(0b01001, &ENTRY_PREREALIZATION_4400758119524381256)],
        ),
        (
            UniCase::ascii("undiscoloureddest"),
            &[(0b11010, &ENTRY_UNDISCOLOREDDEST_588122864294200189)],
        ),
        (
            UniCase::ascii("dandizette"),
            &[(0b01001, &ENTRY_DANDIZETTE_7715971230906134138)],
        ),
        (
            UniCase::ascii("aerographical"),
            &[(0b00001, &ENTRY_AEROGRAPHICAL_2429273948734988881)],
        ),
        (
            UniCase::ascii("unfeudalised"),
            &[(0b10010, &ENTRY_UNFEUDALIZED_11117493394291645590)],
        ),
        (
            UniCase::ascii("philippised"),
            &[(0b10010, &ENTRY_PHILIPPIZED_178919350171556335)],
        ),
        (
            UniCase::ascii("materialisers"),
            &[(0b10010, &ENTRY_MATERIALIZERS_6264608460867840474)],
        ),
        (
            UniCase::ascii("syndicalise"),
            &[(0b10010, &ENTRY_SYNDICALIZE_6097714922943684680)],
        ),
        (
            UniCase::ascii("fractionising"),
            &[(0b10010, &ENTRY_FRACTIONIZING_15905405027559811921)],
        ),
        (
            UniCase::ascii("vapoured"),
            &[(0b11010, &ENTRY_VAPORED_9964696878149356362)],
        ),
        (
            UniCase::ascii("rubricise"),
            &[(0b10010, &ENTRY_RUBRICIZE_9836541413862092246)],
        ),
        (
            UniCase::ascii("noncrystallizing"),
            &[(0b01001, &ENTRY_NONCRYSTALLIZING_12893893992637420505)],
        ),
        (
            UniCase::ascii("capitalises"),
            &[(0b10010, &ENTRY_CAPITALIZES_16323417076992732600)],
        ),
        (
            UniCase::ascii("gospellize"),
            &[(0b01001, &ENTRY_GOSPELLIZE_5327023394143893963)],
        ),
        (
            UniCase::ascii("antisepticize"),
            &[(0b01001, &ENTRY_ANTISEPTICIZE_3241553852417294791)],
        ),
        (
            UniCase::ascii("reorganization"),
            &[(0b01001, &ENTRY_REORGANIZATION_8169886605299414196)],
        ),
        (
            UniCase::ascii("newmanized"),
            &[(0b01001, &ENTRY_NEWMANIZED_4174574011419796555)],
        ),
        (
            UniCase::ascii("semiorganised"),
            &[(0b10010, &ENTRY_SEMIORGANIZED_6555791236440295060)],
        ),
        (
            UniCase::ascii("incentivises"),
            &[(0b10010, &ENTRY_INCENTIVIZES_16584149161391523509)],
        ),
        (
            UniCase::ascii("despatches"),
            &[(0b10011, &ENTRY_DISPATCHES_13572237410774142362)],
        ),
        (
            UniCase::ascii("territorialising"),
            &[(0b10010, &ENTRY_TERRITORIALIZING_7836091817301256528)],
        ),
        (
            UniCase::ascii("categorizes"),
            &[(0b01001, &ENTRY_CATEGORIZES_3536341508655848694)],
        ),
        (
            UniCase::ascii("dentalises"),
            &[(0b10010, &ENTRY_DENTALIZES_6643609780500500774)],
        ),
        (
            UniCase::ascii("mongrelisations"),
            &[(0b10010, &ENTRY_MONGRELIZATIONS_4344310052877835528)],
        ),
        (
            UniCase::ascii("protocolised"),
            &[(0b10010, &ENTRY_PROTOCOLIZED_17551306331631525677)],
        ),
        (
            UniCase::ascii("melanisation"),
            &[(0b10010, &ENTRY_MELANIZATION_4310350431255787228)],
        ),
        (
            UniCase::ascii("sentimentalising"),
            &[(0b10010, &ENTRY_SENTIMENTALIZING_9011281810726145623)],
        ),
        (
            UniCase::ascii("anthropomorphization"),
            &[(0b01001, &ENTRY_ANTHROPOMORPHIZATION_15471734561820106871)],
        ),
        (
            UniCase::ascii("eternising"),
            &[(0b10010, &ENTRY_ETERNIZING_10174905521874007767)],
        ),
        (
            UniCase::ascii("discolour"),
            &[(0b11010, &ENTRY_DISCOLOR_5229997782497228003)],
        ),
        (
            UniCase::ascii("formicide"),
            &[(0b00001, &ENTRY_FORMICIDE_1909286592081562828)],
        ),
        (
            UniCase::ascii("antifertiliser"),
            &[(0b10010, &ENTRY_ANTIFERTILIZER_9953475323473604594)],
        ),
        (
            UniCase::ascii("rhinocelian"),
            &[(0b00001, &ENTRY_RHINOCELIAN_7468732235130691380)],
        ),
        (
            UniCase::ascii("uncivilisable"),
            &[(0b10010, &ENTRY_UNCIVILIZABLE_5359864439117880170)],
        ),
        (
            UniCase::ascii("unmunicipalised"),
            &[(0b10010, &ENTRY_UNMUNICIPALIZED_11558570840724190274)],
        ),
        (
            UniCase::ascii("reinitialises"),
            &[(0b10010, &ENTRY_REINITIALIZES_10777259538596408245)],
        ),
        (
            UniCase::ascii("vandalisations"),
            &[(0b10010, &ENTRY_VANDALIZATIONS_12533411033790274385)],
        ),
        (
            UniCase::ascii("bureaucratises"),
            &[(0b10010, &ENTRY_BUREAUCRATIZES_961794786572965629)],
        ),
        (
            UniCase::ascii("refueling"),
            &[(0b00001, &ENTRY_REFUELING_13653298214509580404)],
        ),
        (
            UniCase::ascii("nonorganization"),
            &[(0b01001, &ENTRY_NONORGANIZATION_5772986496320930609)],
        ),
        (
            UniCase::ascii("vassalised"),
            &[(0b10010, &ENTRY_VASSALIZED_10083471569803078316)],
        ),
        (
            UniCase::ascii("matronise"),
            &[(0b10010, &ENTRY_MATRONIZE_16335366679027459825)],
        ),
        (
            UniCase::ascii("daemonian"),
            &[(0b11010, &ENTRY_DEMONIAN_17257435076983249346)],
        ),
        (
            UniCase::ascii("praesternum"),
            &[(0b11010, &ENTRY_PRESTERNUM_10191977327812747108)],
        ),
        (
            UniCase::ascii("eventualize"),
            &[(0b01001, &ENTRY_EVENTUALIZE_367328542530437546)],
        ),
        (
            UniCase::ascii("jasperizing"),
            &[(0b01001, &ENTRY_JASPERIZING_4150717268435548309)],
        ),
        (
            UniCase::ascii("pyritized"),
            &[(0b01001, &ENTRY_PYRITIZED_10674668536971383379)],
        ),
        (
            UniCase::ascii("synopsizes"),
            &[(0b01001, &ENTRY_SYNOPSIZES_14967276778682343138)],
        ),
        (
            UniCase::ascii("jacobinises"),
            &[(0b10010, &ENTRY_JACOBINIZES_13185057525743157466)],
        ),
        (
            UniCase::ascii("conundrumises"),
            &[(0b10010, &ENTRY_CONUNDRUMIZES_7982003424972698355)],
        ),
        (
            UniCase::ascii("toxanemia"),
            &[(0b00001, &ENTRY_TOXANEMIA_5092978943692773401)],
        ),
        (
            UniCase::ascii("tunnellings"),
            &[(0b11010, &ENTRY_TUNNELINGS_14762533053987563131)],
        ),
        (
            UniCase::ascii("gargarizes"),
            &[(0b01001, &ENTRY_GARGARIZES_1914026990505406207)],
        ),
        (
            UniCase::ascii("paralysing"),
            &[(0b11010, &ENTRY_PARALYZING_4886446215231470079)],
        ),
        (
            UniCase::ascii("annalizing"),
            &[(0b01001, &ENTRY_ANNALIZING_7591181130486416840)],
        ),
        (
            UniCase::ascii("learnt"),
            &[(0b11010, &ENTRY_LEARNED_3077939307038472575)],
        ),
        (
            UniCase::ascii("voltise"),
            &[(0b10010, &ENTRY_VOLTIZE_7549036914115473442)],
        ),
        (
            UniCase::ascii("endeavors"),
            &[(0b11001, &ENTRY_ENDEAVORS_5789569016694167960)],
        ),
        (
            UniCase::ascii("phaenologies"),
            &[(0b11010, &ENTRY_PHENOLOGIES_16864158914924322992)],
        ),
        (
            UniCase::ascii("medievally"),
            &[(0b00001, &ENTRY_MEDIEVALLY_4074376096099201747)],
        ),
        (
            UniCase::ascii("disillusionisers"),
            &[(0b10010, &ENTRY_DISILLUSIONIZERS_3528478054985367590)],
        ),
        (
            UniCase::ascii("victimisations"),
            &[(0b10010, &ENTRY_VICTIMIZATIONS_14899906545794033733)],
        ),
        (
            UniCase::ascii("novelise"),
            &[(0b10010, &ENTRY_NOVELIZE_9212839077174855051)],
        ),
        (
            UniCase::ascii("duer"),
            &[(0b00001, &ENTRY_DUER_2007337493238246122)],
        ),
        (
            UniCase::ascii("teniases"),
            &[(0b00001, &ENTRY_TENIASES_4934007100111357532)],
        ),
        (
            UniCase::ascii("reconnoiter"),
            &[(0b01001, &ENTRY_RECONNOITER_18316377090168333117)],
        ),
        (
            UniCase::ascii("soliloquisers"),
            &[(0b10010, &ENTRY_SOLILOQUIZERS_1912861598555034277)],
        ),
        (
            UniCase::ascii("devocalize"),
            &[(0b01001, &ENTRY_DEVOCALIZE_1529649237001829017)],
        ),
        (
            UniCase::ascii("sexualizing"),
            &[(0b01001, &ENTRY_SEXUALIZING_13168796826287121808)],
        ),
        (
            UniCase::ascii("unnationaliseddest"),
            &[(0b10010, &ENTRY_UNNATIONALIZEDDEST_6627375631914479221)],
        ),
        (
            UniCase::ascii("surgerise"),
            &[(0b10010, &ENTRY_SURGERIZE_4983277252612670769)],
        ),
        (
            UniCase::ascii("pyrolysed"),
            &[(0b11010, &ENTRY_PYROLYZED_6450196473837000816)],
        ),
        (
            UniCase::ascii("metreship"),
            &[(0b11010, &ENTRY_METERSHIP_12369315169127590637)],
        ),
        (
            UniCase::ascii("germanizes"),
            &[(0b01001, &ENTRY_GERMANIZES_1350487394674561657)],
        ),
        (
            UniCase::ascii("idumea"),
            &[(0b00001, &ENTRY_IDUMEA_13980136124670779407)],
        ),
        (
            UniCase::ascii("carollers"),
            &[(0b11010, &ENTRY_CAROLERS_10675807177319949622)],
        ),
        (
            UniCase::ascii("areology"),
            &[(0b11010, &ENTRY_AEROLOGY_2536724281135360580)],
        ),
        (
            UniCase::ascii("metabolisable"),
            &[(0b10010, &ENTRY_METABOLIZABLE_9746555623918169812)],
        ),
        (
            UniCase::ascii("liberalize"),
            &[(0b01001, &ENTRY_LIBERALIZE_18317297344527312130)],
        ),
        (
            UniCase::ascii("sulphuric"),
            &[(0b11010, &ENTRY_SULFURIC_1017009640623214170)],
        ),
        (
            UniCase::ascii("dishonours"),
            &[(0b11010, &ENTRY_DISHONORS_5828073138827677548)],
        ),
        (
            UniCase::ascii("pilgrimizes"),
            &[(0b01001, &ENTRY_PILGRIMIZES_245368581812668914)],
        ),
        (
            UniCase::ascii("misorganizes"),
            &[(0b01001, &ENTRY_MISORGANIZES_15277883172814079121)],
        ),
        (
            UniCase::ascii("kaolinizes"),
            &[(0b01001, &ENTRY_KAOLINIZES_6007210570575095960)],
        ),
        (
            UniCase::ascii("unpenalised"),
            &[(0b10010, &ENTRY_UNPENALIZED_2142967108305186126)],
        ),
        (
            UniCase::ascii("uncircularised"),
            &[(0b10010, &ENTRY_UNCIRCULARIZED_1673876733486569108)],
        ),
        (
            UniCase::ascii("realizablest"),
            &[(0b01001, &ENTRY_REALIZABLEST_5797694315741755778)],
        ),
        (
            UniCase::ascii("vampirising"),
            &[(0b10010, &ENTRY_VAMPIRIZING_5067863975594369914)],
        ),
        (
            UniCase::ascii("autonoe"),
            &[(0b00001, &ENTRY_AUTONOE_11409143792101174133)],
        ),
        (
            UniCase::ascii("rusticized"),
            &[(0b01001, &ENTRY_RUSTICIZED_8719798803495007326)],
        ),
        (
            UniCase::ascii("vaporizabler"),
            &[(0b01001, &ENTRY_VAPORIZABLER_330384219459697531)],
        ),
        (
            UniCase::ascii("boehmenite"),
            &[(0b11010, &ENTRY_BEHMENITE_3335321400081704671)],
        ),
        (
            UniCase::ascii("baptised"),
            &[(0b10010, &ENTRY_BAPTIZED_13515788660771621839)],
        ),
        (
            UniCase::ascii("nasalisation"),
            &[(0b10010, &ENTRY_NASALIZATION_2558206430420024353)],
        ),
        (
            UniCase::ascii("burglarise"),
            &[(0b10010, &ENTRY_BURGLARIZE_3702042591254065955)],
        ),
        (
            UniCase::ascii("bureaucratizing"),
            &[(0b01001, &ENTRY_BUREAUCRATIZING_11662006117549455029)],
        ),
        (
            UniCase::ascii("humanizes"),
            &[(0b01001, &ENTRY_HUMANIZES_6273845182070294397)],
        ),
        (
            UniCase::ascii("cognizant"),
            &[(0b01001, &ENTRY_COGNIZANT_2557847978553579663)],
        ),
        (
            UniCase::ascii("sclerotises"),
            &[(0b10010, &ENTRY_SCLEROTIZES_15593295504016734858)],
        ),
        (
            UniCase::ascii("latinisers"),
            &[(0b10010, &ENTRY_LATINIZERS_5843855516266216328)],
        ),
        (
            UniCase::ascii("unsympathisables"),
            &[(0b10010, &ENTRY_UNSYMPATHIZABLES_6750873272065181147)],
        ),
        (
            UniCase::ascii("palaeontology"),
            &[(0b10010, &ENTRY_PALEONTOLOGY_9348542274173969502)],
        ),
        (
            UniCase::ascii("bituminizations"),
            &[(0b01001, &ENTRY_BITUMINIZATIONS_4430255676913937183)],
        ),
        (
            UniCase::ascii("mongrelization"),
            &[(0b01001, &ENTRY_MONGRELIZATION_4498531267273755020)],
        ),
        (
            UniCase::ascii("localisers"),
            &[(0b10010, &ENTRY_LOCALIZERS_15025775966428286175)],
        ),
        (
            UniCase::ascii("proselytization"),
            &[(0b01001, &ENTRY_PROSELYTIZATION_6529379067249492159)],
        ),
        (
            UniCase::ascii("unparticularisingest"),
            &[(0b10010, &ENTRY_UNPARTICULARIZINGEST_12469995634183150832)],
        ),
        (
            UniCase::ascii("pangaea"),
            &[(0b11010, &ENTRY_PANGEA_7134656067039212415)],
        ),
        (
            UniCase::ascii("mercurialization"),
            &[(0b01001, &ENTRY_MERCURIALIZATION_12125945095948399146)],
        ),
        (
            UniCase::ascii("artificializing"),
            &[(0b01001, &ENTRY_ARTIFICIALIZING_6041141466863049208)],
        ),
        (
            UniCase::ascii("suburbanises"),
            &[(0b10010, &ENTRY_SUBURBANIZES_3051574588598676729)],
        ),
        (
            UniCase::ascii("cortage"),
            &[(0b00001, &ENTRY_CORTAGE_11582769904852791421)],
        ),
        (
            UniCase::ascii("photosynthesises"),
            &[(0b10010, &ENTRY_PHOTOSYNTHESIZES_11615882972300115120)],
        ),
        (
            UniCase::ascii("antisensitises"),
            &[(0b10010, &ENTRY_ANTISENSITIZES_16880204120152034442)],
        ),
        (
            UniCase::ascii("dehumanize"),
            &[(0b01001, &ENTRY_DEHUMANIZE_2232272408872299361)],
        ),
        (
            UniCase::ascii("vitaminising"),
            &[(0b10010, &ENTRY_VITAMINIZING_14433390025156461290)],
        ),
        (
            UniCase::ascii("savouringliest"),
            &[(0b11010, &ENTRY_SAVORINGLIEST_15169226019310047256)],
        ),
        (
            UniCase::ascii("transparentise"),
            &[(0b10010, &ENTRY_TRANSPARENTIZE_1817106363462334768)],
        ),
        (
            UniCase::ascii("depolymerize"),
            &[(0b01001, &ENTRY_DEPOLYMERIZE_332335072679713287)],
        ),
        (
            UniCase::ascii("unrealisables"),
            &[(0b10010, &ENTRY_UNREALIZABLES_9314641022749638380)],
        ),
        (
            UniCase::ascii("moslemises"),
            &[(0b10010, &ENTRY_MOSLEMIZES_18082869512875046805)],
        ),
        (
            UniCase::ascii("hypostatising"),
            &[(0b10010, &ENTRY_HYPOSTATIZING_17172618075417547515)],
        ),
        (
            UniCase::ascii("hypersensitisation"),
            &[(0b10010, &ENTRY_HYPERSENSITIZATION_11377085362616181909)],
        ),
        (
            UniCase::ascii("instals"),
            &[(0b11010, &ENTRY_INSTALLS_10741039873860965951)],
        ),
        (
            UniCase::ascii("colorbred"),
            &[(0b11001, &ENTRY_COLORBRED_17391526765371994938)],
        ),
        (
            UniCase::ascii("feminizations"),
            &[(0b01001, &ENTRY_FEMINIZATIONS_4574886318648206346)],
        ),
        (
            UniCase::ascii("mythopeist"),
            &[(0b00001, &ENTRY_MYTHOPEIST_2404759549078344350)],
        ),
        (
            UniCase::ascii("platycelous"),
            &[(0b00001, &ENTRY_PLATYCELOUS_6600039705539585991)],
        ),
        (
            UniCase::ascii("sulcalising"),
            &[(0b10010, &ENTRY_SULCALIZING_5886947456402704718)],
        ),
        (
            UniCase::ascii("aeonisms"),
            &[(0b11010, &ENTRY_EONISMS_13022437471464751142)],
        ),
        (
            UniCase::ascii("sonnetize"),
            &[(0b01001, &ENTRY_SONNETIZE_3336641041466286630)],
        ),
        (
            UniCase::ascii("disillusionize"),
            &[(0b01001, &ENTRY_DISILLUSIONIZE_6725876315510879655)],
        ),
        (
            UniCase::ascii("amoralizes"),
            &[(0b01001, &ENTRY_AMORALIZES_3004553231540605930)],
        ),
        (
            UniCase::ascii("gorgonised"),
            &[(0b10010, &ENTRY_GORGONIZED_1752725026865323443)],
        ),
        (
            UniCase::ascii("criticisingly"),
            &[(0b10010, &ENTRY_CRITICIZINGLY_17073704302947432967)],
        ),
        (
            UniCase::ascii("lunulae"),
            &[(0b11010, &ENTRY_LUNULE_13057287095940975866)],
        ),
        (
            UniCase::ascii("hypothetized"),
            &[(0b01001, &ENTRY_HYPOTHETIZED_5891619059003247329)],
        ),
        (
            UniCase::ascii("gnosticizer"),
            &[(0b01001, &ENTRY_GNOSTICIZER_12421398403440384920)],
        ),
        (
            UniCase::ascii("spheroidising"),
            &[(0b10010, &ENTRY_SPHEROIDIZING_11358721974863679837)],
        ),
        (
            UniCase::ascii("institutionalised"),
            &[(0b10010, &ENTRY_INSTITUTIONALIZED_662778395420998219)],
        ),
        (
            UniCase::ascii("defunctionalization"),
            &[(0b01001, &ENTRY_DEFUNCTIONALIZATION_13807631024565298493)],
        ),
        (
            UniCase::ascii("unneighbourliest"),
            &[(0b11010, &ENTRY_UNNEIGHBORLIEST_12419433861097517248)],
        ),
        (
            UniCase::ascii("unpictorialising"),
            &[(0b10010, &ENTRY_UNPICTORIALIZING_13381639932561913300)],
        ),
        (
            UniCase::ascii("shrivelled"),
            &[(0b11010, &ENTRY_SHRIVELED_9173718681891056162)],
        ),
        (
            UniCase::ascii("behavior"),
            &[(0b11001, &ENTRY_BEHAVIOR_14651200144504457213)],
        ),
        (
            UniCase::ascii("platonizer"),
            &[(0b01001, &ENTRY_PLATONIZER_3400111701490312811)],
        ),
        (
            UniCase::ascii("singularisations"),
            &[(0b10010, &ENTRY_SINGULARIZATIONS_4989978119532359980)],
        ),
        (
            UniCase::ascii("enolisation"),
            &[(0b10010, &ENTRY_ENOLIZATION_9705682977867724521)],
        ),
        (
            UniCase::ascii("pennae"),
            &[(0b11010, &ENTRY_PENNE_16194116927221501612)],
        ),
        (
            UniCase::ascii("flannelet"),
            &[(0b00001, &ENTRY_FLANNELETTE_17407058729842674548)],
        ),
        (
            UniCase::ascii("japanising"),
            &[(0b10010, &ENTRY_JAPANIZING_1684002847958973103)],
        ),
        (
            UniCase::ascii("secularize"),
            &[(0b01001, &ENTRY_SECULARIZE_8691674226029598576)],
        ),
        (
            UniCase::ascii("tabularises"),
            &[(0b10010, &ENTRY_TABULARIZES_5785970776539734545)],
        ),
        (
            UniCase::ascii("boaedromius"),
            &[(0b11010, &ENTRY_BOEDROMIUS_10140569261433699587)],
        ),
        (
            UniCase::ascii("interjectionizes"),
            &[(0b01001, &ENTRY_INTERJECTIONIZES_14093916347873886338)],
        ),
        (
            UniCase::ascii("useability"),
            &[(0b00001, &ENTRY_USABILITY_2409309504889002778)],
        ),
        (
            UniCase::ascii("departmentalization"),
            &[(0b01001, &ENTRY_DEPARTMENTALIZATION_12611432409781436004)],
        ),
        (
            UniCase::ascii("unantagonizables"),
            &[(0b01001, &ENTRY_UNANTAGONIZABLES_2731043692553771550)],
        ),
        (
            UniCase::ascii("realizables"),
            &[(0b01001, &ENTRY_REALIZABLES_12573952050524775505)],
        ),
        (
            UniCase::ascii("unchloridized"),
            &[(0b01001, &ENTRY_UNCHLORIDIZED_16671439068894580937)],
        ),
        (
            UniCase::ascii("resynchronize"),
            &[(0b01001, &ENTRY_RESYNCHRONIZE_2523532124129456381)],
        ),
        (
            UniCase::ascii("professionalisation"),
            &[(0b10010, &ENTRY_PROFESSIONALIZATION_17530475144205441796)],
        ),
        (
            UniCase::ascii("catholicisers"),
            &[(0b10010, &ENTRY_CATHOLICIZERS_11183927485796882872)],
        ),
        (
            UniCase::ascii("conceptualizing"),
            &[(0b01001, &ENTRY_CONCEPTUALIZING_540854313698733535)],
        ),
        (
            UniCase::ascii("scandalled"),
            &[(0b11010, &ENTRY_SCANDALED_1881652881768607660)],
        ),
        (
            UniCase::ascii("noncolourably"),
            &[(0b11010, &ENTRY_NONCOLORABLY_11724968183544783704)],
        ),
        (
            UniCase::ascii("radbourne"),
            &[(0b11010, &ENTRY_RADBORNE_10850064437245752174)],
        ),
        (
            UniCase::ascii("seta"),
            &[(0b00001, &ENTRY_SETA_9673520022199067907)],
        ),
        (
            UniCase::ascii("jeopardise"),
            &[(0b10010, &ENTRY_JEOPARDIZE_17497435966470167065)],
        ),
        (
            UniCase::ascii("syphilisation"),
            &[(0b10010, &ENTRY_SYPHILIZATION_4055568425962123768)],
        ),
        (
            UniCase::ascii("angularise"),
            &[(0b10010, &ENTRY_ANGULARIZE_12397633129669042330)],
        ),
        (
            UniCase::ascii("lysogenising"),
            &[(0b10010, &ENTRY_LYSOGENIZING_8619281309327783502)],
        ),
        (
            UniCase::ascii("propagandized"),
            &[(0b01001, &ENTRY_PROPAGANDIZED_7923401534538057928)],
        ),
        (
            UniCase::ascii("normanization"),
            &[(0b01001, &ENTRY_NORMANIZATION_16947119225150381222)],
        ),
        (
            UniCase::ascii("materialiser"),
            &[(0b10010, &ENTRY_MATERIALIZER_13633659159147435019)],
        ),
        (
            UniCase::ascii("analysations"),
            &[(0b10010, &ENTRY_ANALYZATIONS_10325231710634833644)],
        ),
        (
            UniCase::ascii("graecises"),
            &[(0b10010, &ENTRY_GRAECIZES_18067197401205415693)],
        ),
        (
            UniCase::ascii("agoniser"),
            &[(0b10010, &ENTRY_AGONIZER_17018191209891639507)],
        ),
        (
            UniCase::ascii("sublimise"),
            &[(0b10010, &ENTRY_SUBLIMIZE_8185998513196337857)],
        ),
        (
            UniCase::ascii("protoarchaeology"),
            &[(0b11010, &ENTRY_PROTOARCHEOLOGY_3979328534027257913)],
        ),
        (
            UniCase::ascii("medialization"),
            &[(0b01001, &ENTRY_MEDIALIZATION_11201086450154584377)],
        ),
        (
            UniCase::ascii("dialling"),
            &[(0b11010, &ENTRY_DIALING_15825922980741414813)],
        ),
        (
            UniCase::ascii("fibreware"),
            &[(0b11010, &ENTRY_FIBERWARE_17783914386673468694)],
        ),
        (
            UniCase::ascii("phenomenalizing"),
            &[(0b01001, &ENTRY_PHENOMENALIZING_15597205978617856018)],
        ),
        (
            UniCase::ascii("solutizer"),
            &[(0b01001, &ENTRY_SOLUTIZER_6497015698400010769)],
        ),
        (
            UniCase::ascii("paynizes"),
            &[(0b01001, &ENTRY_PAYNIZES_15490955026943979655)],
        ),
        (
            UniCase::ascii("rationalizes"),
            &[(0b01001, &ENTRY_RATIONALIZES_6112460011448011714)],
        ),
        (
            UniCase::ascii("emblematisation"),
            &[(0b10010, &ENTRY_EMBLEMATIZATION_3037774664990291578)],
        ),
        (
            UniCase::ascii("hotelizations"),
            &[(0b01001, &ENTRY_HOTELIZATIONS_6794114000883410377)],
        ),
        (
            UniCase::ascii("megbote"),
            &[(0b00001, &ENTRY_MEGBOTE_6305017947026218797)],
        ),
        (
            UniCase::ascii("transcendentalising"),
            &[(0b10010, &ENTRY_TRANSCENDENTALIZING_1803732975904952155)],
        ),
        (
            UniCase::ascii("desilverising"),
            &[(0b10010, &ENTRY_DESILVERIZING_13130813397466342155)],
        ),
        (
            UniCase::ascii("arborisation"),
            &[(0b10010, &ENTRY_ARBORIZATION_9677792163286494747)],
        ),
        (
            UniCase::ascii("initialized"),
            &[(0b01001, &ENTRY_INITIALIZED_7587168812809071543)],
        ),
        (
            UniCase::ascii("soliloquizings"),
            &[(0b01001, &ENTRY_SOLILOQUIZINGS_16013560258108957465)],
        ),
        (
            UniCase::ascii("unsignalizedder"),
            &[(0b01001, &ENTRY_UNSIGNALIZEDDER_2263217046824972534)],
        ),
        (
            UniCase::ascii("ironized"),
            &[(0b01001, &ENTRY_IRONIZED_17698114892762359021)],
        ),
        (
            UniCase::ascii("cartelise"),
            &[(0b10010, &ENTRY_CARTELIZE_7454101035459734890)],
        ),
        (
            UniCase::ascii("aerugo"),
            &[(0b11010, &ENTRY_ERUGO_17158132187061977414)],
        ),
        (
            UniCase::ascii("fanaticizing"),
            &[(0b01001, &ENTRY_FANATICIZING_13797711926894006340)],
        ),
        (
            UniCase::ascii("mercerizing"),
            &[(0b01001, &ENTRY_MERCERIZING_12341499939260844341)],
        ),
        (
            UniCase::ascii("disfavouring"),
            &[(0b11010, &ENTRY_DISFAVORING_16851499602444812970)],
        ),
        (
            UniCase::ascii("menorrhoeic"),
            &[(0b11010, &ENTRY_MENORRHEIC_7610022187186673774)],
        ),
        (
            UniCase::ascii("palaeocrystic"),
            &[(0b11010, &ENTRY_PALEOCRYSTIC_2695211631331372901)],
        ),
        (
            UniCase::ascii("tabularising"),
            &[(0b10010, &ENTRY_TABULARIZING_182464911659236753)],
        ),
        (
            UniCase::ascii("autecy"),
            &[(0b00001, &ENTRY_AUTECY_13719576853502314463)],
        ),
        (
            UniCase::ascii("spheroidisations"),
            &[(0b10010, &ENTRY_SPHEROIDIZATIONS_780683803829928867)],
        ),
        (
            UniCase::ascii("criminalising"),
            &[(0b10010, &ENTRY_CRIMINALIZING_910154589421830415)],
        ),
        (
            UniCase::ascii("positivize"),
            &[(0b01001, &ENTRY_POSITIVIZE_13041357091243880766)],
        ),
        (
            UniCase::ascii("pedantises"),
            &[(0b10010, &ENTRY_PEDANTIZES_9391276727368944001)],
        ),
        (
            UniCase::ascii("bacterise"),
            &[(0b10010, &ENTRY_BACTERIZE_18408113064097816790)],
        ),
        (
            UniCase::ascii("deindustrialises"),
            &[(0b10010, &ENTRY_DEINDUSTRIALIZES_13990996861462469130)],
        ),
        (
            UniCase::ascii("visualised"),
            &[(0b10010, &ENTRY_VISUALIZED_4913836830057768977)],
        ),
        (
            UniCase::ascii("colouring"),
            &[(0b11010, &ENTRY_COLORING_3210137591351035939)],
        ),
        (
            UniCase::ascii("diphthongization"),
            &[(0b01001, &ENTRY_DIPHTHONGIZATION_4888277953337569133)],
        ),
        (
            UniCase::ascii("paratragedia"),
            &[(0b00001, &ENTRY_PARATRAGEDIA_7102269813615164101)],
        ),
        (
            UniCase::ascii("generalises"),
            &[(0b10010, &ENTRY_GENERALIZES_3420734890670492638)],
        ),
        (
            UniCase::ascii("carbonization"),
            &[(0b01001, &ENTRY_CARBONIZATION_11122364629547796220)],
        ),
        (
            UniCase::ascii("cinchonize"),
            &[(0b01001, &ENTRY_CINCHONIZE_14048235966165265995)],
        ),
        (
            UniCase::ascii("securitisations"),
            &[(0b10010, &ENTRY_SECURITIZATIONS_14825154146636731025)],
        ),
        (
            UniCase::ascii("presympathize"),
            &[(0b01001, &ENTRY_PRESYMPATHIZE_15962690746467493454)],
        ),
        (
            UniCase::ascii("evangelizations"),
            &[(0b01001, &ENTRY_EVANGELIZATIONS_14789777873996157817)],
        ),
        (
            UniCase::ascii("negroising"),
            &[(0b10010, &ENTRY_NEGROIZING_13585645509887530683)],
        ),
        (
            UniCase::ascii("pediatry"),
            &[(0b00001, &ENTRY_PEDIATRY_2293953192712354696)],
        ),
        (
            UniCase::ascii("catechisabler"),
            &[(0b10010, &ENTRY_CATECHIZABLER_5689981000220656601)],
        ),
        (
            UniCase::ascii("wournil"),
            &[(0b11010, &ENTRY_WORNIL_7106321021868280403)],
        ),
        (
            UniCase::ascii("fetishises"),
            &[(0b10010, &ENTRY_FETISHIZES_1721613276947375571)],
        ),
        (
            UniCase::ascii("preperfect"),
            &[(0b11010, &ENTRY_PERPERFECT_2601720249166533392)],
        ),
        (
            UniCase::ascii("amourists"),
            &[(0b11010, &ENTRY_AMORISTS_6019660879632735851)],
        ),
        (
            UniCase::ascii("colourlessness"),
            &[(0b11010, &ENTRY_COLORLESSNESS_3911470984873699039)],
        ),
        (
            UniCase::ascii("enterocoele"),
            &[(0b11010, &ENTRY_ENTEROCELE_7421588424099714866)],
        ),
        (
            UniCase::ascii("woollens"),
            &[(0b11010, &ENTRY_WOOLENS_12209882553973827060)],
        ),
        (
            UniCase::ascii("danizations"),
            &[(0b01001, &ENTRY_DANIZATIONS_586018653689790602)],
        ),
        (
            UniCase::ascii("phosphatizing"),
            &[(0b01001, &ENTRY_PHOSPHATIZING_4826539255258763256)],
        ),
        (
            UniCase::ascii("mythicisers"),
            &[(0b10010, &ENTRY_MYTHICIZERS_10056546919744418175)],
        ),
        (
            UniCase::ascii("narcotised"),
            &[(0b10010, &ENTRY_NARCOTIZED_1310082531152390964)],
        ),
        (
            UniCase::ascii("subitises"),
            &[(0b10010, &ENTRY_SUBITIZES_5445288650913572325)],
        ),
        (
            UniCase::ascii("integralisation"),
            &[(0b10010, &ENTRY_INTEGRALIZATION_14909799739781830655)],
        ),
        (
            UniCase::ascii("mediterraneanize"),
            &[(0b01001, &ENTRY_MEDITERRANEANIZE_3216295787007797019)],
        ),
        (
            UniCase::ascii("precoracoid"),
            &[(0b00001, &ENTRY_PRECORACOID_8217660205581287132)],
        ),
        (
            UniCase::ascii("lithopedion"),
            &[(0b10001, &ENTRY_LITHOPEDION_18112524864351619969)],
        ),
        (
            UniCase::ascii("uncoloredliest"),
            &[(0b00001, &ENTRY_UNCOLOREDLIEST_12675741818469230732)],
        ),
        (
            UniCase::ascii("feminisation"),
            &[(0b10010, &ENTRY_FEMINIZATION_8522419792968789128)],
        ),
        (
            UniCase::ascii("gaelicizes"),
            &[(0b01001, &ENTRY_GAELICIZES_5628051894918807993)],
        ),
        (
            UniCase::ascii("compartmentalized"),
            &[(0b01001, &ENTRY_COMPARTMENTALIZED_2091042337396016604)],
        ),
        (
            UniCase::ascii("pandora"),
            &[(0b00001, &ENTRY_PANDORA_3725190345946682637)],
        ),
        (
            UniCase::ascii("eudaemonist"),
            &[(0b11010, &ENTRY_EUDEMONIST_10437519314337880945)],
        ),
        (
            UniCase::ascii("hypervitalizes"),
            &[(0b01001, &ENTRY_HYPERVITALIZES_11384012178375345224)],
        ),
        (
            UniCase::ascii("enologists"),
            &[(0b00001, &ENTRY_ENOLOGISTS_17383228974239236048)],
        ),
        (
            UniCase::ascii("interjectionalized"),
            &[(0b01001, &ENTRY_INTERJECTIONALIZED_5045489232723081851)],
        ),
        (
            UniCase::ascii("humanises"),
            &[(0b10010, &ENTRY_HUMANIZES_6273845182070294397)],
        ),
        (
            UniCase::ascii("patronisable"),
            &[(0b10010, &ENTRY_PATRONIZABLE_15319193123060273715)],
        ),
        (
            UniCase::ascii("incognisable"),
            &[(0b10010, &ENTRY_INCOGNIZABLE_10607185097022859286)],
        ),
        (
            UniCase::ascii("unsympathizinger"),
            &[(0b01001, &ENTRY_UNSYMPATHIZINGER_4506075109833611910)],
        ),
        (
            UniCase::ascii("coeliacs"),
            &[(0b11010, &ENTRY_CELIACS_10248347099141877177)],
        ),
        (
            UniCase::ascii("anaesthetising"),
            &[(0b10010, &ENTRY_ANESTHETIZING_15816199569084558224)],
        ),
        (
            UniCase::ascii("vocationalizes"),
            &[(0b01001, &ENTRY_VOCATIONALIZES_9469137790249815859)],
        ),
        (
            UniCase::ascii("forejudgements"),
            &[(0b11010, &ENTRY_FOREJUDGMENTS_12337114003687174866)],
        ),
        (
            UniCase::ascii("nuclearizes"),
            &[(0b01001, &ENTRY_NUCLEARIZES_11938247015587300181)],
        ),
        (
            UniCase::ascii("alchemises"),
            &[(0b10010, &ENTRY_ALCHEMIZES_6042589921854557418)],
        ),
        (
            UniCase::ascii("asafetida"),
            &[(0b01001, &ENTRY_ASAFETIDA_14075127292131066209)],
        ),
        (
            UniCase::ascii("lusterwares"),
            &[(0b00001, &ENTRY_LUSTERWARES_18360797893051456330)],
        ),
        (
            UniCase::ascii("transistorise"),
            &[(0b10010, &ENTRY_TRANSISTORIZE_14955480539617938425)],
        ),
        (
            UniCase::ascii("unfavorabliest"),
            &[(0b11001, &ENTRY_UNFAVORABLIEST_17311907542528170719)],
        ),
        (
            UniCase::ascii("subtiliser"),
            &[(0b10010, &ENTRY_SUBTILIZER_2092624206187190872)],
        ),
        (
            UniCase::ascii("therenesses"),
            &[(0b00001, &ENTRY_THERENESSES_12088887261810562814)],
        ),
        (
            UniCase::ascii("laborsomely"),
            &[(0b11001, &ENTRY_LABORSOMELY_14865352057256202178)],
        ),
        (
            UniCase::ascii("dramatization"),
            &[(0b01001, &ENTRY_DRAMATIZATION_18352830060262048924)],
        ),
        (
            UniCase::ascii("diarrhoealer"),
            &[(0b10010, &ENTRY_DIARRHEALER_11350171176863314647)],
        ),
        (
            UniCase::ascii("devilize"),
            &[(0b01001, &ENTRY_DEVILIZE_9795464369905562385)],
        ),
        (
            UniCase::ascii("dermatorrhoea"),
            &[(0b11010, &ENTRY_DERMATORRHEA_1805754234241080569)],
        ),
        (
            UniCase::ascii("internalises"),
            &[(0b10010, &ENTRY_INTERNALIZES_3719150015182585151)],
        ),
        (
            UniCase::ascii("archeologist"),
            &[(0b11001, &ENTRY_ARCHAEOLOGIST_15696704416854872606)],
        ),
        (
            UniCase::ascii("gallisizing"),
            &[(0b01001, &ENTRY_GALLISIZING_11425765967668875369)],
        ),
        (
            UniCase::ascii("paleopsychological"),
            &[(0b10001, &ENTRY_PALEOPSYCHOLOGICAL_11882282799276562417)],
        ),
        (
            UniCase::ascii("perdicine"),
            &[(0b00001, &ENTRY_PERDICINE_4604747959856287967)],
        ),
        (
            UniCase::ascii("cosmopolitanizes"),
            &[(0b01001, &ENTRY_COSMOPOLITANIZES_57296618879818157)],
        ),
        (
            UniCase::ascii("psychoanalyzing"),
            &[(0b01001, &ENTRY_PSYCHOANALYZING_11072585094830037830)],
        ),
        (
            UniCase::ascii("vagabondising"),
            &[(0b10010, &ENTRY_VAGABONDIZING_14715875291944757403)],
        ),
        (
            UniCase::ascii("akre"),
            &[(0b11010, &ENTRY_AKER_7390977175698591709)],
        ),
        (
            UniCase::ascii("supersulphurizes"),
            &[(0b01001, &ENTRY_SUPERSULPHURIZES_1086828648943519821)],
        ),
        (
            UniCase::ascii("unphosphatised"),
            &[(0b10010, &ENTRY_UNPHOSPHATIZED_6698185802257295415)],
        ),
        (
            UniCase::ascii("colorcasters"),
            &[(0b11001, &ENTRY_COLORCASTERS_9885877195250711665)],
        ),
        (
            UniCase::ascii("skeptics"),
            &[(0b11001, &ENTRY_SKEPTICS_13432613087589375835)],
        ),
        (
            UniCase::ascii("authorisers"),
            &[(0b10010, &ENTRY_AUTHORIZERS_8627630439372760014)],
        ),
        (
            UniCase::ascii("praecipe"),
            &[(0b11010, &ENTRY_PRECIPE_13555769800049677911)],
        ),
        (
            UniCase::ascii("bedrivelling"),
            &[(0b11010, &ENTRY_BEDRIVELING_12159930547505129231)],
        ),
        (
            UniCase::ascii("unicolored"),
            &[(0b00001, &ENTRY_UNICOLORED_15371219763539897842)],
        ),
        (
            UniCase::ascii("favoredlier"),
            &[(0b11001, &ENTRY_FAVOREDLIER_5765865123462240199)],
        ),
        (
            UniCase::ascii("unhypnotisables"),
            &[(0b10010, &ENTRY_UNHYPNOTIZABLES_2781823676708254865)],
        ),
        (
            UniCase::ascii("piratises"),
            &[(0b10010, &ENTRY_PIRATIZES_8919560401490093200)],
        ),
        (
            UniCase::ascii("victimize"),
            &[(0b01001, &ENTRY_VICTIMIZE_14299551425382354965)],
        ),
        (
            UniCase::ascii("sativae"),
            &[(0b11010, &ENTRY_SATIVE_2657172684842563277)],
        ),
        (
            UniCase::ascii("euphonised"),
            &[(0b10010, &ENTRY_EUPHONIZED_2332221337646658561)],
        ),
        (
            UniCase::ascii("entamoebae"),
            &[(0b11010, &ENTRY_ENTAMEBAE_2341236739078532290)],
        ),
        (
            UniCase::ascii("spectred"),
            &[(0b11010, &ENTRY_SPECTERED_863247434920694580)],
        ),
        (
            UniCase::ascii("victimizer"),
            &[(0b01001, &ENTRY_VICTIMIZER_13906638213650914285)],
        ),
        (
            UniCase::ascii("dishonourer"),
            &[(0b11010, &ENTRY_DISHONORER_11600072711097852356)],
        ),
        (
            UniCase::ascii("pulverisable"),
            &[(0b10010, &ENTRY_PULVERIZABLE_5528070605510221873)],
        ),
        (
            UniCase::ascii("amebid"),
            &[(0b10001, &ENTRY_AMEBID_2070455756616987385)],
        ),
        (
            UniCase::ascii("focalises"),
            &[(0b10010, &ENTRY_FOCALIZES_17823194392580987761)],
        ),
        (
            UniCase::ascii("cannibalise"),
            &[(0b10010, &ENTRY_CANNIBALIZE_6390598440678018772)],
        ),
        (
            UniCase::ascii("lemmatised"),
            &[(0b10010, &ENTRY_LEMMATIZED_18039523576098850991)],
        ),
        (
            UniCase::ascii("underutilizations"),
            &[(0b01001, &ENTRY_UNDERUTILIZATIONS_2736156761561305874)],
        ),
        (
            UniCase::ascii("demutualizations"),
            &[(0b01001, &ENTRY_DEMUTUALIZATIONS_10275807852426892350)],
        ),
        (
            UniCase::ascii("offenselesser"),
            &[(0b00001, &ENTRY_OFFENSELESSER_8750322905944062314)],
        ),
        (
            UniCase::ascii("radicalizes"),
            &[(0b01001, &ENTRY_RADICALIZES_6199505773390853831)],
        ),
        (
            UniCase::ascii("prussianizing"),
            &[(0b01001, &ENTRY_PRUSSIANIZING_17187448249162985680)],
        ),
        (
            UniCase::ascii("breathalysers"),
            &[(0b11010, &ENTRY_BREATHALYZERS_7686418927650730063)],
        ),
        (
            UniCase::ascii("glycerinizes"),
            &[(0b01001, &ENTRY_GLYCERINIZES_17601869911441127120)],
        ),
        (
            UniCase::ascii("unroyalised"),
            &[(0b10010, &ENTRY_UNROYALIZED_463331773464183743)],
        ),
        (
            UniCase::ascii("resymbolizations"),
            &[(0b01001, &ENTRY_RESYMBOLIZATIONS_13698200804085478042)],
        ),
        (
            UniCase::ascii("precompound"),
            &[(0b11010, &ENTRY_PERCOMPOUND_414258272162299801)],
        ),
        (
            UniCase::ascii("conveyorized"),
            &[(0b01001, &ENTRY_CONVEYORIZED_1550738673068217452)],
        ),
        (
            UniCase::ascii("indigenize"),
            &[(0b01001, &ENTRY_INDIGENIZE_17958730421669576658)],
        ),
        (
            UniCase::ascii("porcellanize"),
            &[(0b01001, &ENTRY_PORCELLANIZE_5956584629780862310)],
        ),
        (
            UniCase::ascii("italicizations"),
            &[(0b01001, &ENTRY_ITALICIZATIONS_5819324693969518707)],
        ),
        (
            UniCase::ascii("saxonizing"),
            &[(0b01001, &ENTRY_SAXONIZING_15329045328723618614)],
        ),
        (
            UniCase::ascii("resurrectionising"),
            &[(0b10010, &ENTRY_RESURRECTIONIZING_691774540853612989)],
        ),
        (
            UniCase::ascii("odoriser"),
            &[(0b10010, &ENTRY_ODORIZER_9703276154089227183)],
        ),
        (
            UniCase::ascii("humorlesser"),
            &[(0b11001, &ENTRY_HUMORLESSER_16003980549488709473)],
        ),
        (
            UniCase::ascii("aleucemic"),
            &[(0b00001, &ENTRY_ALEUCEMIC_13145390844272291381)],
        ),
        (
            UniCase::ascii("uralitised"),
            &[(0b10010, &ENTRY_URALITIZED_7976389324622529761)],
        ),
        (
            UniCase::ascii("banalizations"),
            &[(0b01001, &ENTRY_BANALIZATIONS_13442258248647777583)],
        ),
        (
            UniCase::ascii("desensitized"),
            &[(0b01001, &ENTRY_DESENSITIZED_16642593456085222259)],
        ),
        (
            UniCase::ascii("floralize"),
            &[(0b01001, &ENTRY_FLORALIZE_16091946751913584148)],
        ),
        (
            UniCase::ascii("persianization"),
            &[(0b01001, &ENTRY_PERSIANIZATION_10456152347071316181)],
        ),
        (
            UniCase::ascii("decigramme"),
            &[(0b10010, &ENTRY_DECIGRAM_17589790411371966600)],
        ),
        (
            UniCase::ascii("martialise"),
            &[(0b10010, &ENTRY_MARTIALIZE_16160203135661407439)],
        ),
        (
            UniCase::ascii("unfertilisedder"),
            &[(0b10010, &ENTRY_UNFERTILIZEDDER_8970939762495254103)],
        ),
        (
            UniCase::ascii("amortizements"),
            &[(0b01001, &ENTRY_AMORTIZEMENTS_10400864127697785423)],
        ),
        (
            UniCase::ascii("unspiritualises"),
            &[(0b10010, &ENTRY_UNSPIRITUALIZES_13159558072175914180)],
        ),
        (
            UniCase::ascii("thyroidectomised"),
            &[(0b10010, &ENTRY_THYROIDECTOMIZED_18037313633331374041)],
        ),
        (
            UniCase::ascii("ritualize"),
            &[(0b01001, &ENTRY_RITUALIZE_10559347390928816833)],
        ),
        (
            UniCase::ascii("alcoholizable"),
            &[(0b01001, &ENTRY_ALCOHOLIZABLE_5712454359040751327)],
        ),
        (
            UniCase::ascii("diamondize"),
            &[(0b01001, &ENTRY_DIAMONDIZE_974653197096494091)],
        ),
        (
            UniCase::ascii("favourablier"),
            &[(0b11010, &ENTRY_FAVORABLIER_7406446644901287938)],
        ),
        (
            UniCase::ascii("gallicizations"),
            &[(0b01001, &ENTRY_GALLICIZATIONS_12711889075161842819)],
        ),
        (
            UniCase::ascii("peasantize"),
            &[(0b01001, &ENTRY_PEASANTIZE_642017851460607948)],
        ),
        (
            UniCase::ascii("ultrastandardizations"),
            &[(0b01001, &ENTRY_ULTRASTANDARDIZATIONS_12958573872619861416)],
        ),
        (
            UniCase::ascii("decapitalisations"),
            &[(0b10010, &ENTRY_DECAPITALIZATIONS_4946483081288861635)],
        ),
        (
            UniCase::ascii("symbolises"),
            &[(0b10010, &ENTRY_SYMBOLIZES_7534842968073056718)],
        ),
        (
            UniCase::ascii("anthologise"),
            &[(0b10010, &ENTRY_ANTHOLOGIZE_15075070972324121611)],
        ),
        (
            UniCase::ascii("fibreglass"),
            &[(0b11010, &ENTRY_FIBERGLASS_13840692803898764317)],
        ),
        (
            UniCase::ascii("ectocoelic"),
            &[(0b11010, &ENTRY_ECTOCELIC_15109589632064964048)],
        ),
        (
            UniCase::ascii("cognizances"),
            &[(0b01001, &ENTRY_COGNIZANCES_183948325192833313)],
        ),
        (
            UniCase::ascii("rigourism"),
            &[(0b11010, &ENTRY_RIGORISM_14069127364398578519)],
        ),
        (
            UniCase::ascii("denuclearized"),
            &[(0b01001, &ENTRY_DENUCLEARIZED_14638949387306808248)],
        ),
        (
            UniCase::ascii("demonian"),
            &[(0b10001, &ENTRY_DEMONIAN_17257435076983249346)],
        ),
        (
            UniCase::ascii("mongolises"),
            &[(0b10010, &ENTRY_MONGOLIZES_14233973300159557786)],
        ),
        (
            UniCase::ascii("neuroticises"),
            &[(0b10010, &ENTRY_NEUROTICIZES_10740992291539730077)],
        ),
        (
            UniCase::ascii("immortalising"),
            &[(0b10010, &ENTRY_IMMORTALIZING_11881433655552032564)],
        ),
        (
            UniCase::ascii("aaerialness"),
            &[(0b11010, &ENTRY_AERIALNESS_16182249999029135790)],
        ),
        (
            UniCase::ascii("myxaemia"),
            &[(0b11010, &ENTRY_MYXEMIA_10745005304996222059)],
        ),
        (
            UniCase::ascii("asexualization"),
            &[(0b01001, &ENTRY_ASEXUALIZATION_15410884236551711164)],
        ),
        (
            UniCase::ascii("fractionalises"),
            &[(0b10010, &ENTRY_FRACTIONALIZES_5842077662678248264)],
        ),
        (
            UniCase::ascii("unlabeledder"),
            &[(0b00001, &ENTRY_UNLABELEDDER_12664387197615721853)],
        ),
        (
            UniCase::ascii("habitualises"),
            &[(0b10010, &ENTRY_HABITUALIZES_15369684171096748006)],
        ),
        (
            UniCase::ascii("casualizes"),
            &[(0b01001, &ENTRY_CASUALIZES_2357569365432878510)],
        ),
        (
            UniCase::ascii("urbanizing"),
            &[(0b01001, &ENTRY_URBANIZING_6731820196250704237)],
        ),
        (
            UniCase::ascii("pindarises"),
            &[(0b10010, &ENTRY_PINDARIZES_4435880422606251900)],
        ),
        (
            UniCase::ascii("scotticise"),
            &[(0b10010, &ENTRY_SCOTTICIZE_17245280330015663168)],
        ),
        (
            UniCase::ascii("unlabourable"),
            &[(0b11010, &ENTRY_UNLABORABLE_917849914005923474)],
        ),
        (
            UniCase::ascii("grize"),
            &[(0b01001, &ENTRY_GRIZE_9453990615766627670)],
        ),
        (
            UniCase::ascii("worshipers"),
            &[(0b00001, &ENTRY_WORSHIPERS_10535090980834134943)],
        ),
        (
            UniCase::ascii("praeesophageal"),
            &[(0b11010, &ENTRY_PREESOPHAGEAL_14877226231602978003)],
        ),
        (
            UniCase::ascii("cadmiumises"),
            &[(0b10010, &ENTRY_CADMIUMIZES_784331431098990189)],
        ),
        (
            UniCase::ascii("derealisation"),
            &[(0b10010, &ENTRY_DEREALIZATION_4431015585806198367)],
        ),
        (
            UniCase::ascii("vigorless"),
            &[(0b00001, &ENTRY_VIGORLESS_8298894391042086723)],
        ),
        (
            UniCase::ascii("diarrhoeas"),
            &[(0b10010, &ENTRY_DIARRHEAS_11453476003683730830)],
        ),
        (
            UniCase::ascii("communization"),
            &[(0b01001, &ENTRY_COMMUNIZATION_847361005287031401)],
        ),
        (
            UniCase::ascii("protectionize"),
            &[(0b01001, &ENTRY_PROTECTIONIZE_13639705024576405936)],
        ),
        (
            UniCase::ascii("hypnoidizing"),
            &[(0b01001, &ENTRY_HYPNOIDIZING_13556905370183450835)],
        ),
        (
            UniCase::ascii("squame"),
            &[(0b00001, &ENTRY_SQUAME_15183787142740018891)],
        ),
        (
            UniCase::ascii("spanishise"),
            &[(0b10010, &ENTRY_SPANISHIZE_11599801654411089329)],
        ),
        (
            UniCase::ascii("misbaptizes"),
            &[(0b01001, &ENTRY_MISBAPTIZES_7471355898746773980)],
        ),
        (
            UniCase::ascii("palletisations"),
            &[(0b10010, &ENTRY_PALLETIZATIONS_6464829452261813832)],
        ),
        (
            UniCase::ascii("silverise"),
            &[(0b10010, &ENTRY_SILVERIZE_1532148002770872366)],
        ),
        (
            UniCase::ascii("monochordizes"),
            &[(0b01001, &ENTRY_MONOCHORDIZES_3579118842327693619)],
        ),
        (
            UniCase::ascii("dimerizations"),
            &[(0b01001, &ENTRY_DIMERIZATIONS_14028175985445569270)],
        ),
        (
            UniCase::ascii("unstandardisable"),
            &[(0b10010, &ENTRY_UNSTANDARDIZABLE_3986051184822450887)],
        ),
        (
            UniCase::ascii("fagots"),
            &[
                (0b01001, &ENTRY_FAGOTS_13347829079007571091),
                (0b01001, &ENTRY_FAGOTS_9448080982481828615),
            ],
        ),
        (
            UniCase::ascii("etherializing"),
            &[(0b01001, &ENTRY_ETHERIALIZING_5420182430706962967)],
        ),
        (
            UniCase::ascii("individualises"),
            &[(0b10010, &ENTRY_INDIVIDUALIZES_10472470571311764620)],
        ),
        (
            UniCase::ascii("medializations"),
            &[(0b01001, &ENTRY_MEDIALIZATIONS_9266737235252383366)],
        ),
        (
            UniCase::ascii("skeptically"),
            &[(0b11001, &ENTRY_SKEPTICALLY_15015708074924057237)],
        ),
        (
            UniCase::ascii("municipalization"),
            &[(0b01001, &ENTRY_MUNICIPALIZATION_9575521026368095408)],
        ),
        (
            UniCase::ascii("plagiarizing"),
            &[(0b01001, &ENTRY_PLAGIARIZING_6331297137787838542)],
        ),
        (
            UniCase::ascii("traumatisation"),
            &[(0b10010, &ENTRY_TRAUMATIZATION_3746681776679931423)],
        ),
        (
            UniCase::ascii("delustre"),
            &[(0b11010, &ENTRY_DELUSTER_14098580558613886243)],
        ),
        (
            UniCase::ascii("mobilized"),
            &[(0b01001, &ENTRY_MOBILIZED_13415546459102928772)],
        ),
        (
            UniCase::ascii("favors"),
            &[(0b11001, &ENTRY_FAVORS_12388610586480585674)],
        ),
        (
            UniCase::ascii("hygienization"),
            &[(0b01001, &ENTRY_HYGIENIZATION_625023551255960285)],
        ),
        (
            UniCase::ascii("englishize"),
            &[(0b01001, &ENTRY_ENGLISHIZE_16572744168284665334)],
        ),
        (
            UniCase::ascii("seizins"),
            &[(0b01001, &ENTRY_SEIZINS_9859687246678890466)],
        ),
        (
            UniCase::ascii("decolonises"),
            &[(0b10010, &ENTRY_DECOLONIZES_17529571225109301692)],
        ),
        (
            UniCase::ascii("favorlessest"),
            &[(0b11001, &ENTRY_FAVORLESSEST_6458711572083420541)],
        ),
        (
            UniCase::ascii("jargonising"),
            &[(0b10010, &ENTRY_JARGONIZING_9271512143905465697)],
        ),
        (
            UniCase::ascii("deputises"),
            &[(0b10010, &ENTRY_DEPUTIZES_11101760392402320280)],
        ),
        (
            UniCase::ascii("melanise"),
            &[(0b10010, &ENTRY_MELANIZE_7849072016729938941)],
        ),
        (
            UniCase::ascii("savoringly"),
            &[(0b11001, &ENTRY_SAVORINGLY_188792191137435132)],
        ),
        (
            UniCase::ascii("orthographize"),
            &[(0b01001, &ENTRY_ORTHOGRAPHIZE_8119365633244588200)],
        ),
        (
            UniCase::ascii("unsavorier"),
            &[(0b01001, &ENTRY_UNSAVORIER_11499851903563622390)],
        ),
        (
            UniCase::ascii("canalled"),
            &[(0b11010, &ENTRY_CANALED_1837439099016219610)],
        ),
        (
            UniCase::ascii("stercoremia"),
            &[(0b00001, &ENTRY_STERCOREMIA_16211710810263584762)],
        ),
        (
            UniCase::ascii("antisepticizing"),
            &[(0b01001, &ENTRY_ANTISEPTICIZING_5069156061578073106)],
        ),
        (
            UniCase::ascii("honorers"),
            &[(0b11001, &ENTRY_HONORERS_6333132769292360884)],
        ),
        (
            UniCase::ascii("judaise"),
            &[(0b10010, &ENTRY_JUDAIZE_1070374568908494373)],
        ),
        (
            UniCase::ascii("mainors"),
            &[(0b00001, &ENTRY_MAINORS_1096950270219286282)],
        ),
        (
            UniCase::ascii("fogeys"),
            &[(0b11010, &ENTRY_FOGIES_2124096126255173426)],
        ),
        (
            UniCase::ascii("carbolized"),
            &[(0b01001, &ENTRY_CARBOLIZED_3610204407073437611)],
        ),
        (
            UniCase::ascii("multicoloredder"),
            &[(0b10001, &ENTRY_MULTICOLOREDDER_3341008599097650171)],
        ),
        (
            UniCase::ascii("favourable"),
            &[(0b11010, &ENTRY_FAVORABLE_16585220116684679375)],
        ),
        (
            UniCase::ascii("depolymerising"),
            &[(0b10010, &ENTRY_DEPOLYMERIZING_9371889196944478207)],
        ),
        (
            UniCase::ascii("reanalyser"),
            &[(0b10010, &ENTRY_REANALYZER_3769720403208548613)],
        ),
        (
            UniCase::ascii("vitalising"),
            &[(0b10010, &ENTRY_VITALIZING_1172441218463801200)],
        ),
        (
            UniCase::ascii("deoxygenize"),
            &[(0b01001, &ENTRY_DEOXYGENIZE_7933890150357499237)],
        ),
        (
            UniCase::ascii("isochronises"),
            &[(0b10010, &ENTRY_ISOCHRONIZES_3749787773992422117)],
        ),
        (
            UniCase::ascii("paleontologic"),
            &[(0b10001, &ENTRY_PALEONTOLOGIC_17768892661333746888)],
        ),
        (
            UniCase::ascii("deemphasizers"),
            &[(0b01001, &ENTRY_DEEMPHASIZERS_13733231012811038223)],
        ),
        (
            UniCase::ascii("alining"),
            &[(0b00001, &ENTRY_ALIGNING_11699553166951544819)],
        ),
        (
            UniCase::ascii("fertilizing"),
            &[(0b01001, &ENTRY_FERTILIZING_2726744554859969827)],
        ),
        (
            UniCase::ascii("lithopaedion"),
            &[(0b11010, &ENTRY_LITHOPEDION_18112524864351619969)],
        ),
        (
            UniCase::ascii("spheroidisation"),
            &[(0b10010, &ENTRY_SPHEROIDIZATION_1425186216287202703)],
        ),
        (
            UniCase::ascii("pasiphaae"),
            &[(0b11010, &ENTRY_PASIPHAE_10488119709560322867)],
        ),
        (
            UniCase::ascii("subtotaled"),
            &[(0b00001, &ENTRY_SUBTOTALED_11251144387232903283)],
        ),
        (
            UniCase::ascii("outclamor"),
            &[(0b10001, &ENTRY_OUTCLAMOR_12156695162252037981)],
        ),
        (
            UniCase::ascii("gres"),
            &[(0b11010, &ENTRY_GERS_2810213260239783007)],
        ),
        (
            UniCase::ascii("ecstasizes"),
            &[(0b01001, &ENTRY_ECSTASIZES_4161308607604786330)],
        ),
        (
            UniCase::ascii("customises"),
            &[(0b10010, &ENTRY_CUSTOMIZES_7573381294777108850)],
        ),
        (
            UniCase::ascii("hanoverises"),
            &[(0b10010, &ENTRY_HANOVERIZES_4571999407649732424)],
        ),
        (
            UniCase::ascii("anestheticest"),
            &[(0b11001, &ENTRY_ANESTHETICEST_13273804515231488648)],
        ),
        (
            UniCase::ascii("superhumanising"),
            &[(0b10010, &ENTRY_SUPERHUMANIZING_4071636756107716090)],
        ),
        (
            UniCase::ascii("supersensitizing"),
            &[(0b01001, &ENTRY_SUPERSENSITIZING_5029091819363480393)],
        ),
        (
            UniCase::ascii("haematoidin"),
            &[(0b11010, &ENTRY_HEMATOIDIN_16093151429433672073)],
        ),
        (
            UniCase::ascii("vulcanisate"),
            &[(0b10010, &ENTRY_VULCANIZATE_4795671622025524378)],
        ),
        (
            UniCase::ascii("nasalizations"),
            &[(0b01001, &ENTRY_NASALIZATIONS_6303999372164951387)],
        ),
        (
            UniCase::ascii("periodicalizes"),
            &[(0b01001, &ENTRY_PERIODICALIZES_7197610449394818524)],
        ),
        (
            UniCase::ascii("crofterization"),
            &[(0b01001, &ENTRY_CROFTERIZATION_5035727674537403320)],
        ),
        (
            UniCase::ascii("mortalizes"),
            &[(0b01001, &ENTRY_MORTALIZES_1136538908901890872)],
        ),
        (
            UniCase::ascii("volatilized"),
            &[(0b01001, &ENTRY_VOLATILIZED_162413967292134988)],
        ),
        (
            UniCase::ascii("sterilization"),
            &[(0b01001, &ENTRY_STERILIZATION_12496932581276788803)],
        ),
        (
            UniCase::ascii("deemphasiser"),
            &[(0b10010, &ENTRY_DEEMPHASIZER_2232629022737279052)],
        ),
        (
            UniCase::ascii("unmunicipalizeds"),
            &[(0b01001, &ENTRY_UNMUNICIPALIZEDS_10306483843849279865)],
        ),
        (
            UniCase::ascii("overhumanises"),
            &[(0b10010, &ENTRY_OVERHUMANIZES_14873101185551055589)],
        ),
        (
            UniCase::ascii("microcolorimeter"),
            &[(0b00001, &ENTRY_MICROCOLORIMETER_9779301620192455553)],
        ),
        (
            UniCase::ascii("monarchised"),
            &[(0b10010, &ENTRY_MONARCHIZED_5463371092470864555)],
        ),
        (
            UniCase::ascii("macadamizes"),
            &[(0b01001, &ENTRY_MACADAMIZES_17270116944727731447)],
        ),
        (
            UniCase::ascii("strychninise"),
            &[(0b10010, &ENTRY_STRYCHNINIZE_17273897055193701327)],
        ),
        (
            UniCase::ascii("parlormaid"),
            &[(0b10001, &ENTRY_PARLORMAID_11273400895928326109)],
        ),
        (
            UniCase::ascii("busheled"),
            &[(0b00001, &ENTRY_BUSHELED_1118763777829214027)],
        ),
        (
            UniCase::ascii("narcotized"),
            &[(0b01001, &ENTRY_NARCOTIZED_1310082531152390964)],
        ),
        (
            UniCase::ascii("afrikanerises"),
            &[(0b10010, &ENTRY_AFRIKANERIZES_8717515483112090861)],
        ),
        (
            UniCase::ascii("casualising"),
            &[(0b10010, &ENTRY_CASUALIZING_16345100801087952198)],
        ),
        (
            UniCase::ascii("adverbializing"),
            &[(0b01001, &ENTRY_ADVERBIALIZING_4313670731186707316)],
        ),
        (
            UniCase::ascii("thronize"),
            &[(0b01001, &ENTRY_THRONIZE_6821227400136957234)],
        ),
        (
            UniCase::ascii("historicized"),
            &[(0b01001, &ENTRY_HISTORICIZED_15317036403172319970)],
        ),
        (
            UniCase::ascii("chiles"),
            &[(0b01001, &ENTRY_CHILIES_2805435102646559217)],
        ),
        (
            UniCase::ascii("organizationallier"),
            &[(0b01001, &ENTRY_ORGANIZATIONALLIER_5244336690983254999)],
        ),
        (
            UniCase::ascii("intellectualises"),
            &[(0b10010, &ENTRY_INTELLECTUALIZES_10524380563631063928)],
        ),
        (
            UniCase::ascii("vectorizing"),
            &[(0b01001, &ENTRY_VECTORIZING_9538566325910673128)],
        ),
        (
            UniCase::ascii("hyphenises"),
            &[(0b10010, &ENTRY_HYPHENIZES_15581224527134621804)],
        ),
        (
            UniCase::ascii("copolymerisation"),
            &[(0b10010, &ENTRY_COPOLYMERIZATION_3565686431310114577)],
        ),
        (
            UniCase::ascii("polychromatizes"),
            &[(0b01001, &ENTRY_POLYCHROMATIZES_16629345361533556580)],
        ),
        (
            UniCase::ascii("estrin"),
            &[(0b00001, &ENTRY_ESTRIN_1271537042891040806)],
        ),
        (
            UniCase::ascii("prioritisation"),
            &[(0b10010, &ENTRY_PRIORITIZATION_10049497275055472359)],
        ),
        (
            UniCase::ascii("fanaticising"),
            &[(0b10010, &ENTRY_FANATICIZING_13797711926894006340)],
        ),
        (
            UniCase::ascii("dispapalize"),
            &[(0b01001, &ENTRY_DISPAPALIZE_13165058594407425203)],
        ),
        (
            UniCase::ascii("glamorize"),
            &[(0b01001, &ENTRY_GLAMORIZE_15623953511855635687)],
        ),
        (
            UniCase::ascii("erical"),
            &[(0b00001, &ENTRY_ERICAL_12478419361229949219)],
        ),
        (
            UniCase::ascii("colorimetrist"),
            &[(0b00001, &ENTRY_COLORIMETRIST_16103668754911113058)],
        ),
        (
            UniCase::ascii("realisers"),
            &[(0b10010, &ENTRY_REALIZERS_5837268423419941688)],
        ),
        (
            UniCase::ascii("immunised"),
            &[(0b10010, &ENTRY_IMMUNIZED_12890937714947487224)],
        ),
        (
            UniCase::ascii("supersensitized"),
            &[(0b01001, &ENTRY_SUPERSENSITIZED_1021249000838099530)],
        ),
        (
            UniCase::ascii("paedophilia"),
            &[(0b11010, &ENTRY_PEDOPHILIA_9946016916272449426)],
        ),
        (
            UniCase::ascii("parameterizable"),
            &[(0b01001, &ENTRY_PARAMETERIZABLE_2808545627544279194)],
        ),
        (
            UniCase::ascii("apostatised"),
            &[(0b10010, &ENTRY_APOSTATIZED_7948531497773688326)],
        ),
        (
            UniCase::ascii("fervorless"),
            &[(0b11001, &ENTRY_FERVORLESS_4739772680862683322)],
        ),
        (
            UniCase::ascii("amoebicidal"),
            &[(0b11010, &ENTRY_AMEBICIDAL_17077923016456623176)],
        ),
        (
            UniCase::ascii("demineralise"),
            &[(0b10010, &ENTRY_DEMINERALIZE_2028750406115400134)],
        ),
        (
            UniCase::ascii("matronizes"),
            &[(0b01001, &ENTRY_MATRONIZES_15227868328935007900)],
        ),
        (
            UniCase::ascii("fossilisables"),
            &[(0b10010, &ENTRY_FOSSILIZABLES_850215141590149031)],
        ),
        (
            UniCase::ascii("esophagi"),
            &[(0b11001, &ENTRY_ESOPHAGI_16651245992122782472)],
        ),
        (
            UniCase::ascii("uncriticisablest"),
            &[(0b10010, &ENTRY_UNCRITICIZABLEST_4607318644536802423)],
        ),
        (
            UniCase::ascii("solmizations"),
            &[(0b01001, &ENTRY_SOLMIZATIONS_13280876893352435221)],
        ),
        (
            UniCase::ascii("frenum"),
            &[(0b00001, &ENTRY_FRENUM_7603649563431435410)],
        ),
        (
            UniCase::ascii("chemicalisation"),
            &[(0b10010, &ENTRY_CHEMICALIZATION_14523349755381906432)],
        ),
        (
            UniCase::ascii("weize"),
            &[(0b01001, &ENTRY_WEIZE_8174776964340050680)],
        ),
        (
            UniCase::ascii("alkalinizations"),
            &[(0b01001, &ENTRY_ALKALINIZATIONS_2537063136327717146)],
        ),
        (
            UniCase::ascii("noncolourableness"),
            &[(0b11010, &ENTRY_NONCOLORABLENESS_1350486861839326465)],
        ),
        (
            UniCase::ascii("consonantise"),
            &[(0b10010, &ENTRY_CONSONANTIZE_7643805442006694940)],
        ),
        (
            UniCase::ascii("teetotallers"),
            &[(0b11010, &ENTRY_TEETOTALERS_7523968922648268459)],
        ),
        (
            UniCase::ascii("unsystematised"),
            &[(0b10010, &ENTRY_UNSYSTEMATIZED_14502428691598864878)],
        ),
        (
            UniCase::ascii("maximisers"),
            &[(0b10010, &ENTRY_MAXIMIZERS_8260289730206734033)],
        ),
        (
            UniCase::ascii("dramatisation"),
            &[(0b10010, &ENTRY_DRAMATIZATION_18352830060262048924)],
        ),
        (
            UniCase::ascii("ourangs"),
            &[(0b11010, &ENTRY_ORANGS_6364282221462306169)],
        ),
        (
            UniCase::ascii("unminimizing"),
            &[(0b01001, &ENTRY_UNMINIMIZING_14406353280475862221)],
        ),
        (
            UniCase::ascii("mentalize"),
            &[(0b01001, &ENTRY_MENTALIZE_1038523375536757780)],
        ),
        (
            UniCase::ascii("nasalizes"),
            &[(0b01001, &ENTRY_NASALIZES_10310087698573638162)],
        ),
        (
            UniCase::ascii("gelatinize"),
            &[(0b01001, &ENTRY_GELATINIZE_14320678590118078567)],
        ),
        (
            UniCase::ascii("cosmopolitanized"),
            &[(0b01001, &ENTRY_COSMOPOLITANIZED_15042192345530983967)],
        ),
        (
            UniCase::ascii("terminalisation"),
            &[(0b10010, &ENTRY_TERMINALIZATION_14611052621641252685)],
        ),
        (
            UniCase::ascii("territorialisation"),
            &[(0b10010, &ENTRY_TERRITORIALIZATION_13612272693653351235)],
        ),
        (
            UniCase::ascii("peasantises"),
            &[(0b10010, &ENTRY_PEASANTIZES_10166156031855873894)],
        ),
        (
            UniCase::ascii("garrulinae"),
            &[(0b11010, &ENTRY_GARRULINE_2763058909710775755)],
        ),
        (
            UniCase::ascii("ager"),
            &[(0b00001, &ENTRY_AGER_10154545747728403667)],
        ),
        (
            UniCase::ascii("cuckoldise"),
            &[(0b10010, &ENTRY_CUCKOLDIZE_15621372017035539958)],
        ),
        (
            UniCase::ascii("corantos"),
            &[(0b00001, &ENTRY_CORANTOS_4303750137767317450)],
        ),
        (
            UniCase::ascii("paediatric"),
            &[(0b10010, &ENTRY_PEDIATRIC_15313872787895414938)],
        ),
        (
            UniCase::ascii("metallised"),
            &[(0b10010, &ENTRY_METALIZED_13873262702122532833)],
        ),
        (
            UniCase::ascii("irregularises"),
            &[(0b10010, &ENTRY_IRREGULARIZES_6852005375793762938)],
        ),
        (
            UniCase::ascii("haemon"),
            &[(0b11010, &ENTRY_HEMON_8613843011077669238)],
        ),
        (
            UniCase::ascii("remagnetize"),
            &[(0b01001, &ENTRY_REMAGNETIZE_7944947263065196618)],
        ),
        (
            UniCase::ascii("quakerizations"),
            &[(0b01001, &ENTRY_QUAKERIZATIONS_9091064691709489634)],
        ),
        (
            UniCase::ascii("detribalizes"),
            &[(0b01001, &ENTRY_DETRIBALIZES_17667503652444099945)],
        ),
        (
            UniCase::ascii("compartmentalizing"),
            &[(0b01001, &ENTRY_COMPARTMENTALIZING_14853138630531540565)],
        ),
        (
            UniCase::ascii("fractionisations"),
            &[(0b10010, &ENTRY_FRACTIONIZATIONS_15392396968809874240)],
        ),
        (
            UniCase::ascii("parathyroidectomising"),
            &[(0b10010, &ENTRY_PARATHYROIDECTOMIZING_12468529059301511586)],
        ),
        (
            UniCase::ascii("solemnizer"),
            &[(0b01001, &ENTRY_SOLEMNIZER_5978295607112033996)],
        ),
        (
            UniCase::ascii("poetized"),
            &[(0b01001, &ENTRY_POETIZED_1386961114003301059)],
        ),
        (
            UniCase::ascii("homoeokinesis"),
            &[(0b11010, &ENTRY_HOMEOKINESIS_6170969351054020797)],
        ),
        (
            UniCase::ascii("intercivilizations"),
            &[(0b01001, &ENTRY_INTERCIVILIZATIONS_16686447883834461544)],
        ),
        (
            UniCase::ascii("millimetre"),
            &[(0b11010, &ENTRY_MILLIMETER_987431015131963906)],
        ),
        (
            UniCase::ascii("unrivaleddest"),
            &[(0b00001, &ENTRY_UNRIVALEDDEST_6685390969368773151)],
        ),
        (
            UniCase::ascii("alkalinized"),
            &[(0b01001, &ENTRY_ALKALINIZED_13701976256938611329)],
        ),
        (
            UniCase::ascii("fletcherizing"),
            &[(0b01001, &ENTRY_FLETCHERIZING_13648398213116551529)],
        ),
        (
            UniCase::ascii("paganizers"),
            &[(0b01001, &ENTRY_PAGANIZERS_2218453433509959012)],
        ),
        (
            UniCase::ascii("federalizations"),
            &[(0b01001, &ENTRY_FEDERALIZATIONS_16597754848421860206)],
        ),
        (
            UniCase::ascii("denationalizes"),
            &[(0b01001, &ENTRY_DENATIONALIZES_817254898726083409)],
        ),
        (
            UniCase::ascii("morbidize"),
            &[(0b01001, &ENTRY_MORBIDIZE_4422039069430263560)],
        ),
        (
            UniCase::ascii("sympathisingliest"),
            &[(0b10010, &ENTRY_SYMPATHIZINGLIEST_8990695458438411519)],
        ),
        (
            UniCase::ascii("gaelicization"),
            &[(0b01001, &ENTRY_GAELICIZATION_8229079546606253770)],
        ),
        (
            UniCase::ascii("customising"),
            &[(0b10010, &ENTRY_CUSTOMIZING_12981538261584263761)],
        ),
        (
            UniCase::ascii("presbyterianize"),
            &[(0b01001, &ENTRY_PRESBYTERIANIZE_8184517241649663285)],
        ),
        (
            UniCase::ascii("albumenizing"),
            &[(0b00001, &ENTRY_ALBUMENIZING_16229928715193703812)],
        ),
        (
            UniCase::ascii("heterecious"),
            &[(0b00001, &ENTRY_HETERECIOUS_528818645302753522)],
        ),
        (
            UniCase::ascii("documentarization"),
            &[(0b01001, &ENTRY_DOCUMENTARIZATION_17974536989356012536)],
        ),
        (
            UniCase::ascii("particularizer"),
            &[(0b01001, &ENTRY_PARTICULARIZER_9553956621020704685)],
        ),
        (
            UniCase::ascii("hysterectomised"),
            &[(0b10010, &ENTRY_HYSTERECTOMIZED_13349404234142869054)],
        ),
        (
            UniCase::ascii("choephori"),
            &[(0b00001, &ENTRY_CHOEPHORI_13897909648270625076)],
        ),
        (
            UniCase::ascii("privatisation"),
            &[(0b10010, &ENTRY_PRIVATIZATION_13261595712696321543)],
        ),
        (
            UniCase::ascii("scandalisers"),
            &[(0b10010, &ENTRY_SCANDALIZERS_15197543038839412069)],
        ),
        (
            UniCase::ascii("plagiarises"),
            &[(0b10010, &ENTRY_PLAGIARIZES_3079051217833247235)],
        ),
        (
            UniCase::ascii("generalisation"),
            &[(0b10010, &ENTRY_GENERALIZATION_8859013031721640663)],
        ),
        (
            UniCase::ascii("acclimatising"),
            &[(0b10010, &ENTRY_ACCLIMATIZING_3751997949097583159)],
        ),
        (
            UniCase::ascii("paleopathologist"),
            &[(0b10001, &ENTRY_PALEOPATHOLOGIST_12270610216847457118)],
        ),
        (
            UniCase::ascii("metastasised"),
            &[(0b10010, &ENTRY_METASTASIZED_7988308203364783556)],
        ),
        (
            UniCase::ascii("uncauterised"),
            &[(0b10010, &ENTRY_UNCAUTERIZED_13512404213504423195)],
        ),
        (
            UniCase::ascii("humourlessest"),
            &[(0b11010, &ENTRY_HUMORLESSEST_11446149668669386608)],
        ),
        (
            UniCase::ascii("connectible"),
            &[(0b00001, &ENTRY_CONNECTABLE_4141190038522560448)],
        ),
        (
            UniCase::ascii("electrocauterisation"),
            &[(0b10010, &ENTRY_ELECTROCAUTERIZATION_16903094457115645430)],
        ),
        (
            UniCase::ascii("arabized"),
            &[(0b01001, &ENTRY_ARABIZED_13913844866590865979)],
        ),
        (
            UniCase::ascii("panderise"),
            &[(0b10010, &ENTRY_PANDERIZE_13584391243213121721)],
        ),
        (
            UniCase::ascii("perorally"),
            &[(0b00001, &ENTRY_PERORALLY_2346315785712029791)],
        ),
        (
            UniCase::ascii("existentialises"),
            &[(0b10010, &ENTRY_EXISTENTIALIZES_8959667143883061799)],
        ),
        (
            UniCase::ascii("gothicize"),
            &[(0b01001, &ENTRY_GOTHICIZE_10579445493165443468)],
        ),
        (
            UniCase::ascii("lyophilises"),
            &[(0b10010, &ENTRY_LYOPHILIZES_17423281299656389223)],
        ),
        (
            UniCase::ascii("achromatisation"),
            &[(0b10010, &ENTRY_ACHROMATIZATION_3261887351568242902)],
        ),
        (
            UniCase::ascii("dehumanising"),
            &[(0b10010, &ENTRY_DEHUMANIZING_18121800466455281577)],
        ),
        (
            UniCase::ascii("oligemia"),
            &[(0b10001, &ENTRY_OLIGEMIA_10907380054389841551)],
        ),
        (
            UniCase::ascii("propylitised"),
            &[(0b10010, &ENTRY_PROPYLITIZED_8590898197469215076)],
        ),
        (
            UniCase::ascii("intellectualizations"),
            &[(0b01001, &ENTRY_INTELLECTUALIZATIONS_3199889427953063623)],
        ),
        (
            UniCase::ascii("anoestrous"),
            &[(0b11010, &ENTRY_ANESTROUS_9129522172283593493)],
        ),
        (
            UniCase::ascii("suberizing"),
            &[(0b01001, &ENTRY_SUBERIZING_11515978326235360567)],
        ),
        (
            UniCase::ascii("hellenises"),
            &[(0b10010, &ENTRY_HELLENIZES_11902572538272316091)],
        ),
        (
            UniCase::ascii("boedromius"),
            &[(0b00001, &ENTRY_BOEDROMIUS_10140569261433699587)],
        ),
        (
            UniCase::ascii("schillerisation"),
            &[(0b10010, &ENTRY_SCHILLERIZATION_1975534132552758492)],
        ),
        (
            UniCase::ascii("radializing"),
            &[(0b01001, &ENTRY_RADIALIZING_3370202487268261936)],
        ),
        (
            UniCase::ascii("synecologies"),
            &[(0b00001, &ENTRY_SYNECOLOGIES_6305448968712762615)],
        ),
        (
            UniCase::ascii("aguised"),
            &[(0b10010, &ENTRY_AGUIZED_11146501883929771035)],
        ),
        (
            UniCase::ascii("hebraicizes"),
            &[(0b01001, &ENTRY_HEBRAICIZES_5673642863053082994)],
        ),
        (
            UniCase::ascii("eternalisations"),
            &[(0b10010, &ENTRY_ETERNALIZATIONS_1580610116895380250)],
        ),
        (
            UniCase::ascii("reconceptualizing"),
            &[(0b01001, &ENTRY_RECONCEPTUALIZING_14548968664268398028)],
        ),
        (
            UniCase::ascii("infinitizes"),
            &[(0b01001, &ENTRY_INFINITIZES_16900614083188680149)],
        ),
        (
      