// This file is code-genned by typos-dict-codegen
#![allow(clippy::unreadable_literal)]

pub static WORD_TRIE: dictgen::DictTrie<&'static [&'static str]> = dictgen::DictTrie {
    root: &WORD_NODE,
    unicode: &WORD_UNICODE_TABLE,
    range: 2..=34,
};

pub static WORD_UNICODE_TABLE: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Unicode("clockwíse"),
        dictgen::InsensitiveStr::Unicode("paínt"),
        dictgen::InsensitiveStr::Unicode("évaluate"),
        dictgen::InsensitiveStr::Unicode("сontain"),
        dictgen::InsensitiveStr::Unicode("сontained"),
        dictgen::InsensitiveStr::Unicode("сontainer"),
        dictgen::InsensitiveStr::Unicode("сontainers"),
        dictgen::InsensitiveStr::Unicode("сontaining"),
        dictgen::InsensitiveStr::Unicode("сontainor"),
        dictgen::InsensitiveStr::Unicode("сontainors"),
        dictgen::InsensitiveStr::Unicode("сontains"),
    ],
    values: &[
        &["clockwise"],
        &["paint"],
        &["evaluate"],
        &["contain"],
        &["contained"],
        &["container"],
        &["containers"],
        &["containing"],
        &["container"],
        &["containers"],
        &["contains"],
    ],
    range: 6..=11,
};

static WORD_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_CHILDREN),
    value: None,
};

static WORD_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_A_NODE),
    Some(&WORD_B_NODE),
    Some(&WORD_C_NODE),
    Some(&WORD_D_NODE),
    Some(&WORD_E_NODE),
    Some(&WORD_F_NODE),
    Some(&WORD_G_NODE),
    Some(&WORD_H_NODE),
    Some(&WORD_I_NODE),
    Some(&WORD_J_NODE),
    Some(&WORD_K_NODE),
    Some(&WORD_L_NODE),
    Some(&WORD_M_NODE),
    Some(&WORD_N_NODE),
    Some(&WORD_O_NODE),
    Some(&WORD_P_NODE),
    Some(&WORD_Q_NODE),
    Some(&WORD_R_NODE),
    Some(&WORD_S_NODE),
    Some(&WORD_T_NODE),
    Some(&WORD_U_NODE),
    Some(&WORD_V_NODE),
    Some(&WORD_W_NODE),
    Some(&WORD_X_NODE),
    Some(&WORD_Y_NODE),
    Some(&WORD_Z_NODE),
];

static WORD_Z_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_Z_CHILDREN),
    value: None,
};

pub static WORD_Z_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aelots"),
        dictgen::InsensitiveStr::Ascii("ealotes"),
        dictgen::InsensitiveStr::Ascii("ealoths"),
        dictgen::InsensitiveStr::Ascii("ealotus"),
        dictgen::InsensitiveStr::Ascii("ealouts"),
        dictgen::InsensitiveStr::Ascii("ealtos"),
        dictgen::InsensitiveStr::Ascii("eebra"),
        dictgen::InsensitiveStr::Ascii("elaots"),
        dictgen::InsensitiveStr::Ascii("elaous"),
        dictgen::InsensitiveStr::Ascii("epplein"),
        dictgen::InsensitiveStr::Ascii("epplien"),
        dictgen::InsensitiveStr::Ascii("imbabe"),
        dictgen::InsensitiveStr::Ascii("imbabew"),
        dictgen::InsensitiveStr::Ascii("imbabwae"),
        dictgen::InsensitiveStr::Ascii("imbabwaen"),
        dictgen::InsensitiveStr::Ascii("imbawbe"),
        dictgen::InsensitiveStr::Ascii("immap"),
        dictgen::InsensitiveStr::Ascii("impaps"),
        dictgen::InsensitiveStr::Ascii("inoists"),
        dictgen::InsensitiveStr::Ascii("ionisim"),
        dictgen::InsensitiveStr::Ascii("ionistas"),
        dictgen::InsensitiveStr::Ascii("ionistes"),
        dictgen::InsensitiveStr::Ascii("ionistisk"),
        dictgen::InsensitiveStr::Ascii("ionistm"),
        dictgen::InsensitiveStr::Ascii("ionsim"),
        dictgen::InsensitiveStr::Ascii("ionsit"),
        dictgen::InsensitiveStr::Ascii("ionsits"),
        dictgen::InsensitiveStr::Ascii("iped"),
        dictgen::InsensitiveStr::Ascii("iper"),
        dictgen::InsensitiveStr::Ascii("iping"),
        dictgen::InsensitiveStr::Ascii("lot"),
        dictgen::InsensitiveStr::Ascii("oinism"),
        dictgen::InsensitiveStr::Ascii("oinist"),
        dictgen::InsensitiveStr::Ascii("oinists"),
        dictgen::InsensitiveStr::Ascii("ombe"),
        dictgen::InsensitiveStr::Ascii("omebie"),
        dictgen::InsensitiveStr::Ascii("user"),
    ],
    values: &[
        &["zealots"],
        &["zealots"],
        &["zealots"],
        &["zealots"],
        &["zealous"],
        &["zealots"],
        &["zebra"],
        &["zealots"],
        &["zealous"],
        &["zeppelin"],
        &["zeppelin"],
        &["zimbabwe"],
        &["zimbabwe"],
        &["zimbabwe"],
        &["zimbabwe"],
        &["zimbabwe"],
        &["zipmap"],
        &["zipmaps"],
        &["zionists"],
        &["zionism"],
        &["zionists"],
        &["zionists"],
        &["zionists"],
        &["zionism"],
        &["zionism"],
        &["zionist"],
        &["zionists"],
        &["zipped"],
        &["zipper"],
        &["zipping"],
        &["slot"],
        &["zionism"],
        &["zionist"],
        &["zionists"],
        &["zombie"],
        &["zombie"],
        &["user"],
    ],
    range: 3..=9,
};

static WORD_Y_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_Y_CHILDREN),
    value: None,
};

pub static WORD_Y_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aching"),
        dictgen::InsensitiveStr::Ascii("aer"),
        dictgen::InsensitiveStr::Ascii("aerly"),
        dictgen::InsensitiveStr::Ascii("aers"),
        dictgen::InsensitiveStr::Ascii("atch"),
        dictgen::InsensitiveStr::Ascii("au"),
        dictgen::InsensitiveStr::Ascii("earm"),
        dictgen::InsensitiveStr::Ascii("easr"),
        dictgen::InsensitiveStr::Ascii("eild"),
        dictgen::InsensitiveStr::Ascii("eilded"),
        dictgen::InsensitiveStr::Ascii("eilding"),
        dictgen::InsensitiveStr::Ascii("eilds"),
        dictgen::InsensitiveStr::Ascii("eld"),
        dictgen::InsensitiveStr::Ascii("elded"),
        dictgen::InsensitiveStr::Ascii("elding"),
        dictgen::InsensitiveStr::Ascii("elds"),
        dictgen::InsensitiveStr::Ascii("ementite"),
        dictgen::InsensitiveStr::Ascii("era"),
        dictgen::InsensitiveStr::Ascii("eras"),
        dictgen::InsensitiveStr::Ascii("ersa"),
        dictgen::InsensitiveStr::Ascii("he"),
        dictgen::InsensitiveStr::Ascii("ieldin"),
        dictgen::InsensitiveStr::Ascii("mbols"),
        dictgen::InsensitiveStr::Ascii("oesmite"),
        dictgen::InsensitiveStr::Ascii("orksher"),
        dictgen::InsensitiveStr::Ascii("orkshie"),
        dictgen::InsensitiveStr::Ascii("orkshrie"),
        dictgen::InsensitiveStr::Ascii("orskhire"),
        dictgen::InsensitiveStr::Ascii("osemeti"),
        dictgen::InsensitiveStr::Ascii("osemitie"),
        dictgen::InsensitiveStr::Ascii("osimete"),
        dictgen::InsensitiveStr::Ascii("otube"),
        dictgen::InsensitiveStr::Ascii("oun"),
        dictgen::InsensitiveStr::Ascii("oungents"),
        dictgen::InsensitiveStr::Ascii("ounget"),
        dictgen::InsensitiveStr::Ascii("oure"),
        dictgen::InsensitiveStr::Ascii("ourr"),
        dictgen::InsensitiveStr::Ascii("ourselfe"),
        dictgen::InsensitiveStr::Ascii("ourselfes"),
        dictgen::InsensitiveStr::Ascii("ourselv"),
        dictgen::InsensitiveStr::Ascii("ourselve"),
        dictgen::InsensitiveStr::Ascii("ourselvs"),
        dictgen::InsensitiveStr::Ascii("oursleves"),
        dictgen::InsensitiveStr::Ascii("ouseff"),
        dictgen::InsensitiveStr::Ascii("ouself"),
        dictgen::InsensitiveStr::Ascii("pes"),
        dictgen::InsensitiveStr::Ascii("rea"),
        dictgen::InsensitiveStr::Ascii("se"),
        dictgen::InsensitiveStr::Ascii("tou"),
        dictgen::InsensitiveStr::Ascii("ugoslac"),
        dictgen::InsensitiveStr::Ascii("uo"),
        dictgen::InsensitiveStr::Ascii("uor"),
        dictgen::InsensitiveStr::Ascii("ur"),
    ],
    values: &[
        &["yachting"],
        &["year"],
        &["yearly"],
        &["years"],
        &["yacht"],
        &["you", "yaw"],
        &["year"],
        &["years"],
        &["yield"],
        &["yielded"],
        &["yielding"],
        &["yields"],
        &["yield"],
        &["yielded"],
        &["yielding"],
        &["yields"],
        &["yemenite", "yemeni"],
        &["year"],
        &["years"],
        &["years"],
        &["the"],
        &["yielding"],
        &["symbols"],
        &["yosemite"],
        &["yorkshire"],
        &["yorkshire"],
        &["yorkshire"],
        &["yorkshire"],
        &["yosemite"],
        &["yosemite"],
        &["yosemite"],
        &["youtube"],
        &["your", "you", "young"],
        &["youngest"],
        &["youngest"],
        &["your"],
        &["your"],
        &["yourself", "yourselves"],
        &["yourselves"],
        &["yourself", "yourselves"],
        &["yourselves", "yourself"],
        &["yourselves"],
        &["yourselves"],
        &["yousef", "yourself"],
        &["yourself"],
        &["types"],
        &["year"],
        &["yes", "use", "nyse"],
        &["you"],
        &["yugoslav"],
        &["you"],
        &["your"],
        &["your"],
    ],
    range: 2..=9,
};

static WORD_X_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_X_CHILDREN),
    value: None,
};

pub static WORD_X_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("describe"),
        dictgen::InsensitiveStr::Ascii("dpf"),
        dictgen::InsensitiveStr::Ascii("enbolade"),
        dictgen::InsensitiveStr::Ascii("enobalde"),
        dictgen::InsensitiveStr::Ascii("enohpobic"),
        dictgen::InsensitiveStr::Ascii("enophibia"),
        dictgen::InsensitiveStr::Ascii("enophibic"),
        dictgen::InsensitiveStr::Ascii("enophobical"),
        dictgen::InsensitiveStr::Ascii("enophoblic"),
        dictgen::InsensitiveStr::Ascii("enophoby"),
        dictgen::InsensitiveStr::Ascii("enophonic"),
        dictgen::InsensitiveStr::Ascii("enophopia"),
        dictgen::InsensitiveStr::Ascii("enophopic"),
        dictgen::InsensitiveStr::Ascii("eonblade"),
        dictgen::InsensitiveStr::Ascii("eonphobia"),
        dictgen::InsensitiveStr::Ascii("eonphobic"),
        dictgen::InsensitiveStr::Ascii("epect"),
        dictgen::InsensitiveStr::Ascii("epected"),
        dictgen::InsensitiveStr::Ascii("epectedly"),
        dictgen::InsensitiveStr::Ascii("epecting"),
        dictgen::InsensitiveStr::Ascii("epects"),
        dictgen::InsensitiveStr::Ascii("getttext"),
        dictgen::InsensitiveStr::Ascii("initiazlize"),
        dictgen::InsensitiveStr::Ascii("mdoel"),
        dictgen::InsensitiveStr::Ascii("our"),
        dictgen::InsensitiveStr::Ascii("you"),
    ],
    values: &[
        &["describe"],
        &["xpdf"],
        &["xenoblade"],
        &["xenoblade"],
        &["xenophobic"],
        &["xenophobia"],
        &["xenophobic"],
        &["xenophobia"],
        &["xenophobic"],
        &["xenophobia"],
        &["xenophobic"],
        &["xenophobia"],
        &["xenophobic"],
        &["xenoblade"],
        &["xenophobia"],
        &["xenophobic"],
        &["expect"],
        &["expected"],
        &["expectedly"],
        &["expecting"],
        &["expects"],
        &["xgettext"],
        &["xinitialize"],
        &["xmodel"],
        &["your"],
        &["you"],
    ],
    range: 3..=11,
};

static WORD_W_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_W_CHILDREN),
    value: None,
};

static WORD_W_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_WA_NODE),
    None,
    None,
    None,
    Some(&WORD_WE_NODE),
    None,
    None,
    Some(&WORD_WH_NODE),
    Some(&WORD_WI_NODE),
    Some(&WORD_WJ_NODE),
    None,
    Some(&WORD_WL_NODE),
    None,
    Some(&WORD_WN_NODE),
    Some(&WORD_WO_NODE),
    None,
    Some(&WORD_WQ_NODE),
    Some(&WORD_WR_NODE),
    Some(&WORD_WS_NODE),
    Some(&WORD_WT_NODE),
    Some(&WORD_WU_NODE),
    None,
    None,
    None,
    Some(&WORD_WY_NODE),
    None,
];

static WORD_WY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WY_CHILDREN),
    value: None,
};

pub static WORD_WY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("a"),
        dictgen::InsensitiveStr::Ascii("th"),
        dictgen::InsensitiveStr::Ascii("thout"),
    ],
    values: &[&["way"], &["with"], &["without"]],
    range: 1..=5,
};

static WORD_WU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WU_CHILDREN),
    value: None,
};

pub static WORD_WU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("old"),
        dictgen::InsensitiveStr::Ascii("pport"),
    ],
    values: &[&["would"], &["support"]],
    range: 3..=5,
};

static WORD_WT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WT_CHILDREN),
    value: None,
};

pub static WORD_WT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("h"),
        dictgen::InsensitiveStr::Ascii("iches"),
        dictgen::InsensitiveStr::Ascii("ih"),
    ],
    values: &[&["with"], &["witches"], &["with"]],
    range: 1..=5,
};

static WORD_WS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WS_CHILDREN),
    value: None,
};

pub static WORD_WS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ee")],
    values: &[&["see"]],
    range: 2..=2,
};

static WORD_WR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WR_CHILDREN),
    value: None,
};

pub static WORD_WR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aning"),
        dictgen::InsensitiveStr::Ascii("anings"),
        dictgen::InsensitiveStr::Ascii("anlger"),
        dictgen::InsensitiveStr::Ascii("aped"),
        dictgen::InsensitiveStr::Ascii("apepd"),
        dictgen::InsensitiveStr::Ascii("aper"),
        dictgen::InsensitiveStr::Ascii("aping"),
        dictgen::InsensitiveStr::Ascii("app"),
        dictgen::InsensitiveStr::Ascii("appered"),
        dictgen::InsensitiveStr::Ascii("appng"),
        dictgen::InsensitiveStr::Ascii("apps"),
        dictgen::InsensitiveStr::Ascii("eckign"),
        dictgen::InsensitiveStr::Ascii("ecthed"),
        dictgen::InsensitiveStr::Ascii("ekcing"),
        dictgen::InsensitiveStr::Ascii("eslte"),
        dictgen::InsensitiveStr::Ascii("eslter"),
        dictgen::InsensitiveStr::Ascii("esters"),
        dictgen::InsensitiveStr::Ascii("estlewar"),
        dictgen::InsensitiveStr::Ascii("iet"),
        dictgen::InsensitiveStr::Ascii("itebufer"),
        dictgen::InsensitiveStr::Ascii("itechetque"),
        dictgen::InsensitiveStr::Ascii("iteing"),
        dictgen::InsensitiveStr::Ascii("iten"),
        dictgen::InsensitiveStr::Ascii("itet"),
        dictgen::InsensitiveStr::Ascii("itewr"),
        dictgen::InsensitiveStr::Ascii("itingm"),
        dictgen::InsensitiveStr::Ascii("itter"),
        dictgen::InsensitiveStr::Ascii("itters"),
        dictgen::InsensitiveStr::Ascii("ittin"),
        dictgen::InsensitiveStr::Ascii("itting"),
        dictgen::InsensitiveStr::Ascii("ittten"),
        dictgen::InsensitiveStr::Ascii("kload"),
        dictgen::InsensitiveStr::Ascii("kloads"),
        dictgen::InsensitiveStr::Ascii("nagler"),
        dictgen::InsensitiveStr::Ascii("od"),
        dictgen::InsensitiveStr::Ascii("oet"),
        dictgen::InsensitiveStr::Ascii("og"),
        dictgen::InsensitiveStr::Ascii("ok"),
        dictgen::InsensitiveStr::Ascii("oked"),
        dictgen::InsensitiveStr::Ascii("okflow"),
        dictgen::InsensitiveStr::Ascii("okflows"),
        dictgen::InsensitiveStr::Ascii("oking"),
        dictgen::InsensitiveStr::Ascii("okload"),
        dictgen::InsensitiveStr::Ascii("okloads"),
        dictgen::InsensitiveStr::Ascii("oks"),
        dictgen::InsensitiveStr::Ascii("on"),
        dictgen::InsensitiveStr::Ascii("onf"),
        dictgen::InsensitiveStr::Ascii("ont"),
        dictgen::InsensitiveStr::Ascii("teched"),
        dictgen::InsensitiveStr::Ascii("tie"),
        dictgen::InsensitiveStr::Ascii("ting"),
    ],
    values: &[
        &["warning"],
        &["warnings"],
        &["wrangler"],
        &["wrapped", "warped"],
        &["wrapped"],
        &["wrapper"],
        &["wrapping", "warping"],
        &["wrap"],
        &["wrapped"],
        &["wrapping"],
        &["wraps"],
        &["wrecking"],
        &["wretched"],
        &["wrecking"],
        &["wrestle"],
        &["wrestler"],
        &["wrestlers"],
        &["wrestler"],
        &["write"],
        &["writebuffer"],
        &["writecheque"],
        &["writing"],
        &["written"],
        &["writes"],
        &["writer"],
        &["writing"],
        &["writer"],
        &["writers"],
        &["written", "writing"],
        &["writing"],
        &["written"],
        &["workload"],
        &["workloads"],
        &["wrangler"],
        &["word"],
        &["wrote"],
        &["wrong"],
        &["work"],
        &["worked"],
        &["workflow"],
        &["workflows"],
        &["working"],
        &["workload"],
        &["workloads"],
        &["works"],
        &["wrong"],
        &["wrong"],
        &["wrong"],
        &["wretched"],
        &["write"],
        &["writing"],
    ],
    range: 2..=10,
};

static WORD_WQ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WQ_CHILDREN),
    value: None,
};

pub static WORD_WQ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("s")],
    values: &[&["was"]],
    range: 1..=1,
};

static WORD_WO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_WO_CHILDREN),
    value: None,
};

static WORD_WO_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_WOA_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_WOH_NODE),
    Some(&WORD_WOI_NODE),
    None,
    Some(&WORD_WOK_NODE),
    Some(&WORD_WOL_NODE),
    Some(&WORD_WOM_NODE),
    Some(&WORD_WON_NODE),
    Some(&WORD_WOO_NODE),
    None,
    None,
    Some(&WORD_WOR_NODE),
    None,
    Some(&WORD_WOT_NODE),
    Some(&WORD_WOU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static WORD_WOU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WOU_CHILDREN),
    value: None,
};

pub static WORD_WOU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("d"),
        dictgen::InsensitiveStr::Ascii("dl"),
        dictgen::InsensitiveStr::Ascii("dlnt"),
        dictgen::InsensitiveStr::Ascii("dlve"),
        dictgen::InsensitiveStr::Ascii("ldnot"),
        dictgen::InsensitiveStr::Ascii("lndt"),
        dictgen::InsensitiveStr::Ascii("nderful"),
        dictgen::InsensitiveStr::Ascii("old"),
        dictgen::InsensitiveStr::Ascii("uld"),
    ],
    values: &[
        &["would"],
        &["would"],
        &["wouldnt"],
        &["wouldve"],
        &["wouldnt"],
        &["wouldnt"],
        &["wonderful"],
        &["would"],
        &["would"],
    ],
    range: 1..=7,
};

static WORD_WOT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WOT_CHILDREN),
    value: None,
};

pub static WORD_WOT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("h"),
        dictgen::InsensitiveStr::Ascii("hout"),
    ],
    values: &[&["worth"], &["without"]],
    range: 1..=4,
};

static WORD_WOR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_WOR_CHILDREN),
    value: None,
};

static WORD_WOR_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_WORA_NODE),
    Some(&WORD_WORB_NODE),
    None,
    Some(&WORD_WORD_NODE),
    None,
    Some(&WORD_WORF_NODE),
    None,
    Some(&WORD_WORH_NODE),
    None,
    None,
    Some(&WORD_WORK_NODE),
    Some(&WORD_WORL_NODE),
    None,
    Some(&WORD_WORN_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_WORS_NODE),
    Some(&WORD_WORT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_WORT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WORT_CHILDREN),
    value: None,
};

pub static WORD_WORT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("helss"),
        dictgen::InsensitiveStr::Ascii("hing"),
        dictgen::InsensitiveStr::Ascii("hwile"),
    ],
    values: &[&["worthless"], &["worth", "meriting"], &["worthwhile"]],
    range: 4..=5,
};

static WORD_WORS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WORS_CHILDREN),
    value: None,
};

pub static WORD_WORS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("hippig"),
        dictgen::InsensitiveStr::Ascii("hippping"),
        dictgen::InsensitiveStr::Ascii("hoping"),
        dictgen::InsensitiveStr::Ascii("hopping"),
        dictgen::InsensitiveStr::Ascii("tened"),
    ],
    values: &[
        &["worse"],
        &["worshipping"],
        &["worshipping"],
        &["worshiping"],
        &["worshipping"],
        &["worsened"],
    ],
    range: 2..=8,
};

static WORD_WORN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WORN_CHILDREN),
    value: None,
};

pub static WORD_WORN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("g"),
        dictgen::InsensitiveStr::Ascii("ged"),
        dictgen::InsensitiveStr::Ascii("gs"),
    ],
    values: &[&["wrong", "worn"], &["wronged"], &["wrongs"]],
    range: 1..=3,
};

static WORD_WORL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WORL_CHILDREN),
    value: None,
};

pub static WORD_WORL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("divew"),
        dictgen::InsensitiveStr::Ascii("dveiw"),
        dictgen::InsensitiveStr::Ascii("oad"),
        dictgen::InsensitiveStr::Ascii("oads"),
        dictgen::InsensitiveStr::Ascii("s"),
    ],
    values: &[
        &["worldview"],
        &["worldview"],
        &["workload"],
        &["workloads"],
        &["world"],
    ],
    range: 1..=5,
};

static WORD_WORK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WORK_CHILDREN),
    value: None,
};

pub static WORD_WORK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aorund"),
        dictgen::InsensitiveStr::Ascii("aound"),
        dictgen::InsensitiveStr::Ascii("aounds"),
        dictgen::InsensitiveStr::Ascii("araound"),
        dictgen::InsensitiveStr::Ascii("araounds"),
        dictgen::InsensitiveStr::Ascii("arbound"),
        dictgen::InsensitiveStr::Ascii("aroud"),
        dictgen::InsensitiveStr::Ascii("arouds"),
        dictgen::InsensitiveStr::Ascii("arould"),
        dictgen::InsensitiveStr::Ascii("aroung"),
        dictgen::InsensitiveStr::Ascii("aroungs"),
        dictgen::InsensitiveStr::Ascii("arround"),
        dictgen::InsensitiveStr::Ascii("arrounds"),
        dictgen::InsensitiveStr::Ascii("arund"),
        dictgen::InsensitiveStr::Ascii("arunds"),
        dictgen::InsensitiveStr::Ascii("banch"),
        dictgen::InsensitiveStr::Ascii("banches"),
        dictgen::InsensitiveStr::Ascii("banchs"),
        dictgen::InsensitiveStr::Ascii("benchs"),
        dictgen::InsensitiveStr::Ascii("bennch"),
        dictgen::InsensitiveStr::Ascii("bennches"),
        dictgen::InsensitiveStr::Ascii("bnech"),
        dictgen::InsensitiveStr::Ascii("bneches"),
        dictgen::InsensitiveStr::Ascii("boos"),
        dictgen::InsensitiveStr::Ascii("d"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("fore"),
        dictgen::InsensitiveStr::Ascii("fow"),
        dictgen::InsensitiveStr::Ascii("fows"),
        dictgen::InsensitiveStr::Ascii("froce"),
        dictgen::InsensitiveStr::Ascii("ign"),
        dictgen::InsensitiveStr::Ascii("ingest"),
        dictgen::InsensitiveStr::Ascii("ins"),
        dictgen::InsensitiveStr::Ascii("lfow"),
        dictgen::InsensitiveStr::Ascii("lfows"),
        dictgen::InsensitiveStr::Ascii("psace"),
        dictgen::InsensitiveStr::Ascii("psaces"),
        dictgen::InsensitiveStr::Ascii("spsace"),
        dictgen::InsensitiveStr::Ascii("spsaces"),
        dictgen::InsensitiveStr::Ascii("staion"),
        dictgen::InsensitiveStr::Ascii("staions"),
        dictgen::InsensitiveStr::Ascii("staition"),
        dictgen::InsensitiveStr::Ascii("staitions"),
        dictgen::InsensitiveStr::Ascii("staiton"),
        dictgen::InsensitiveStr::Ascii("staitons"),
        dictgen::InsensitiveStr::Ascii("staton"),
        dictgen::InsensitiveStr::Ascii("ststion"),
        dictgen::InsensitiveStr::Ascii("ststions"),
    ],
    values: &[
        &["workaround"],
        &["workaround"],
        &["workarounds"],
        &["workaround"],
        &["workarounds"],
        &["workaround"],
        &["workaround"],
        &["workarounds"],
        &["workaround"],
        &["workaround"],
        &["workarounds"],
        &["workaround"],
        &["workarounds"],
        &["workaround"],
        &["workarounds"],
        &["workbench"],
        &["workbenches"],
        &["workbenches"],
        &["workbenches"],
        &["workbench"],
        &["workbenches"],
        &["workbench"],
        &["workbenches"],
        &["workbooks"],
        &["worked"],
        &["work", "worked", "works"],
        &["works"],
        &["workforce"],
        &["workflow"],
        &["workflows"],
        &["workforce"],
        &["working"],
        &["workings"],
        &["workings"],
        &["workflow"],
        &["workflows"],
        &["workspace"],
        &["workspaces"],
        &["workspace"],
        &["workspaces"],
        &["workstation"],
        &["workstations"],
        &["workstation"],
        &["workstations"],
        &["workstation"],
        &["workstations"],
        &["workstation"],
        &["workstation"],
        &["workstations"],
    ],
    range: 1..=9,
};

static WORD_WORH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WORH_CHILDREN),
    value: None,
};

pub static WORD_WORH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("siping"),
        dictgen::InsensitiveStr::Ascii("sipping"),
        dictgen::InsensitiveStr::Ascii("tless"),
    ],
    values: &[&["worshiping"], &["worshipping"], &["worthless"]],
    range: 5..=7,
};

static WORD_WORF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WORF_CHILDREN),
    value: None,
};

pub static WORD_WORF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("klow"),
        dictgen::InsensitiveStr::Ascii("klows"),
        dictgen::InsensitiveStr::Ascii("low"),
        dictgen::InsensitiveStr::Ascii("lows"),
    ],
    values: &[&["workflow"], &["workflows"], &["workflow"], &["workflows"]],
    range: 3..=5,
};

static WORD_WORD_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WORD_CHILDREN),
    value: None,
};

pub static WORD_WORD_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lview"),
        dictgen::InsensitiveStr::Ascii("lwide"),
        dictgen::InsensitiveStr::Ascii("pres"),
    ],
    values: &[&["worldview"], &["worldwide"], &["wordpress"]],
    range: 4..=5,
};

static WORD_WORB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WORB_CHILDREN),
    value: None,
};

pub static WORD_WORB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ench"),
        dictgen::InsensitiveStr::Ascii("enches"),
    ],
    values: &[&["workbench"], &["workbenches"]],
    range: 4..=6,
};

static WORD_WORA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WORA_CHILDREN),
    value: None,
};

pub static WORD_WORA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("round"),
        dictgen::InsensitiveStr::Ascii("rounds"),
    ],
    values: &[&["workaround"], &["workarounds"]],
    range: 5..=6,
};

static WORD_WOO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WOO_CHILDREN),
    value: None,
};

pub static WORD_WOO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("dowrking"),
        dictgen::InsensitiveStr::Ascii("dworkign"),
    ],
    values: &[&["woodworking"], &["woodworking"]],
    range: 8..=8,
};

static WORD_WON_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WON_CHILDREN),
    value: None,
};

pub static WORD_WON_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("deres"),
        dictgen::InsensitiveStr::Ascii("derfull"),
        dictgen::InsensitiveStr::Ascii("derfullly"),
        dictgen::InsensitiveStr::Ascii("derfuly"),
        dictgen::InsensitiveStr::Ascii("derig"),
        dictgen::InsensitiveStr::Ascii("derlad"),
        dictgen::InsensitiveStr::Ascii("derus"),
        dictgen::InsensitiveStr::Ascii("derwand"),
    ],
    values: &[
        &["wonders"],
        &["wonderful"],
        &["wonderfully"],
        &["wonderfully"],
        &["wondering"],
        &["wonderland"],
        &["wonders"],
        &["wonderland"],
    ],
    range: 5..=9,
};

static WORD_WOM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WOM_CHILDREN),
    value: None,
};

pub static WORD_WOM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ens")],
    values: &[&["women"]],
    range: 3..=3,
};

static WORD_WOL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WOL_CHILDREN),
    value: None,
};

pub static WORD_WOL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("low"),
        dictgen::InsensitiveStr::Ascii("lowing"),
        dictgen::InsensitiveStr::Ascii("rd"),
        dictgen::InsensitiveStr::Ascii("rdly"),
        dictgen::InsensitiveStr::Ascii("rdview"),
        dictgen::InsensitiveStr::Ascii("rdwide"),
        dictgen::InsensitiveStr::Ascii("wide"),
    ],
    values: &[
        &["follow", "wallow"],
        &["following", "wallowing"],
        &["world"],
        &["worldly"],
        &["worldview"],
        &["worldwide"],
        &["worldwide"],
    ],
    range: 2..=6,
};

static WORD_WOK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WOK_CHILDREN),
    value: None,
};

pub static WORD_WOK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("r"),
        dictgen::InsensitiveStr::Ascii("ring"),
    ],
    values: &[&["work"], &["working"]],
    range: 1..=4,
};

static WORD_WOI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WOI_CHILDREN),
    value: None,
};

pub static WORD_WOI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ll"),
        dictgen::InsensitiveStr::Ascii("thout"),
    ],
    values: &[&["will"], &["without"]],
    range: 2..=5,
};

static WORD_WOH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WOH_CHILDREN),
    value: Some(&["who"]),
};

pub static WORD_WOH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("le")],
    values: &[&["whole"]],
    range: 2..=2,
};

static WORD_WOA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WOA_CHILDREN),
    value: None,
};

pub static WORD_WOA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("rkaround")],
    values: &[&["workaround"]],
    range: 8..=8,
};

static WORD_WN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WN_CHILDREN),
    value: None,
};

pub static WORD_WN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("at"),
        dictgen::InsensitiveStr::Ascii("ated"),
        dictgen::InsensitiveStr::Ascii("ating"),
        dictgen::InsensitiveStr::Ascii("ats"),
        dictgen::InsensitiveStr::Ascii("en"),
        dictgen::InsensitiveStr::Ascii("idow"),
        dictgen::InsensitiveStr::Ascii("idows"),
    ],
    values: &[
        &["want", "what"],
        &["wanted"],
        &["wanting"],
        &["wants"],
        &["when", "wen"],
        &["window", "widow"],
        &["windows", "widows"],
    ],
    range: 2..=5,
};

static WORD_WL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WL_CHILDREN),
    value: None,
};

pub static WORD_WL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("acott"),
        dictgen::InsensitiveStr::Ascii("l"),
    ],
    values: &[&["walcott"], &["will"]],
    range: 1..=5,
};

static WORD_WJ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WJ_CHILDREN),
    value: None,
};

pub static WORD_WJ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("at")],
    values: &[&["what"]],
    range: 2..=2,
};

static WORD_WI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_WI_CHILDREN),
    value: None,
};

static WORD_WI_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_WIA_NODE),
    None,
    Some(&WORD_WIC_NODE),
    Some(&WORD_WID_NODE),
    Some(&WORD_WIE_NODE),
    None,
    Some(&WORD_WIG_NODE),
    Some(&WORD_WIH_NODE),
    Some(&WORD_WII_NODE),
    None,
    Some(&WORD_WIK_NODE),
    Some(&WORD_WIL_NODE),
    None,
    Some(&WORD_WIN_NODE),
    None,
    Some(&WORD_WIP_NODE),
    None,
    Some(&WORD_WIR_NODE),
    Some(&WORD_WIS_NODE),
    Some(&WORD_WIT_NODE),
    Some(&WORD_WIU_NODE),
    None,
    None,
    None,
    Some(&WORD_WIY_NODE),
    Some(&WORD_WIZ_NODE),
];

static WORD_WIZ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WIZ_CHILDREN),
    value: None,
};

pub static WORD_WIZ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("zard")],
    values: &[&["wizard"]],
    range: 4..=4,
};

static WORD_WIY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WIY_CHILDREN),
    value: None,
};

pub static WORD_WIY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("h"),
        dictgen::InsensitiveStr::Ascii("hout"),
        dictgen::InsensitiveStr::Ascii("th"),
    ],
    values: &[&["with"], &["without"], &["with"]],
    range: 1..=4,
};

static WORD_WIU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WIU_CHILDREN),
    value: None,
};

pub static WORD_WIU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ll")],
    values: &[&["will"]],
    range: 2..=2,
};

static WORD_WIT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WIT_CHILDREN),
    value: None,
};

pub static WORD_WIT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("able"),
        dictgen::InsensitiveStr::Ascii("dh"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("ha"),
        dictgen::InsensitiveStr::Ascii("hces"),
        dictgen::InsensitiveStr::Ascii("hdral"),
        dictgen::InsensitiveStr::Ascii("hdrawalls"),
        dictgen::InsensitiveStr::Ascii("hdrawan"),
        dictgen::InsensitiveStr::Ascii("hdrawel"),
        dictgen::InsensitiveStr::Ascii("hdrawels"),
        dictgen::InsensitiveStr::Ascii("hdrawin"),
        dictgen::InsensitiveStr::Ascii("hdrawl"),
        dictgen::InsensitiveStr::Ascii("hdrawles"),
        dictgen::InsensitiveStr::Ascii("hdrawling"),
        dictgen::InsensitiveStr::Ascii("hdrawning"),
        dictgen::InsensitiveStr::Ascii("held"),
        dictgen::InsensitiveStr::Ascii("helist"),
        dictgen::InsensitiveStr::Ascii("hh"),
        dictgen::InsensitiveStr::Ascii("hhelding"),
        dictgen::InsensitiveStr::Ascii("hholdng"),
        dictgen::InsensitiveStr::Ascii("hih"),
        dictgen::InsensitiveStr::Ascii("hing"),
        dictgen::InsensitiveStr::Ascii("hinn"),
        dictgen::InsensitiveStr::Ascii("hion"),
        dictgen::InsensitiveStr::Ascii("ho"),
        dictgen::InsensitiveStr::Ascii("hoit"),
        dictgen::InsensitiveStr::Ascii("hold"),
        dictgen::InsensitiveStr::Ascii("holding"),
        dictgen::InsensitiveStr::Ascii("hon"),
        dictgen::InsensitiveStr::Ascii("hoout"),
        dictgen::InsensitiveStr::Ascii("hot"),
        dictgen::InsensitiveStr::Ascii("hotu"),
        dictgen::InsensitiveStr::Ascii("hou"),
        dictgen::InsensitiveStr::Ascii("houd"),
        dictgen::InsensitiveStr::Ascii("houg"),
        dictgen::InsensitiveStr::Ascii("hough"),
        dictgen::InsensitiveStr::Ascii("hought"),
        dictgen::InsensitiveStr::Ascii("houht"),
        dictgen::InsensitiveStr::Ascii("hount"),
        dictgen::InsensitiveStr::Ascii("hour"),
        dictgen::InsensitiveStr::Ascii("hourt"),
        dictgen::InsensitiveStr::Ascii("hous"),
        dictgen::InsensitiveStr::Ascii("houth"),
        dictgen::InsensitiveStr::Ascii("houyt"),
        dictgen::InsensitiveStr::Ascii("hput"),
        dictgen::InsensitiveStr::Ascii("hrdawal"),
        dictgen::InsensitiveStr::Ascii("hrdawing"),
        dictgen::InsensitiveStr::Ascii("hs"),
        dictgen::InsensitiveStr::Ascii("ht"),
        dictgen::InsensitiveStr::Ascii("in"),
        dictgen::InsensitiveStr::Ascii("k"),
        dictgen::InsensitiveStr::Ascii("n"),
        dictgen::InsensitiveStr::Ascii("nesess"),
        dictgen::InsensitiveStr::Ascii("nesss"),
        dictgen::InsensitiveStr::Ascii("nesssing"),
        dictgen::InsensitiveStr::Ascii("nissing"),
        dictgen::InsensitiveStr::Ascii("out"),
        dictgen::InsensitiveStr::Ascii("th"),
    ],
    values: &[
        &["writeable"],
        &["width"],
        &["write", "white"],
        &["with"],
        &["witches"],
        &["withdrawal"],
        &["withdrawals"],
        &["withdrawn"],
        &["withdrawal"],
        &["withdrawals"],
        &["withdrawn"],
        &["withdrawal", "withdraw"],
        &["withdrawals"],
        &["withdrawing"],
        &["withdrawing"],
        &["withheld"],
        &["whitelist"],
        &["with"],
        &["withholding"],
        &["withholding"],
        &["within"],
        &["within"],
        &["within"],
        &["within"],
        &["with"],
        &["without"],
        &["withhold"],
        &["withholding"],
        &["within"],
        &["without"],
        &["without"],
        &["without"],
        &["without"],
        &["without"],
        &["without"],
        &["without"],
        &["without"],
        &["without"],
        &["without"],
        &["without"],
        &["without"],
        &["without"],
        &["without"],
        &["without"],
        &["without"],
        &["withdrawals"],
        &["withdrawing"],
        &["with", "widths"],
        &["with"],
        &["within"],
        &["with"],
        &["with"],
        &["witnesses"],
        &["witnesses"],
        &["witnessing"],
        &["witnessing"],
        &["without"],
        &["with"],
    ],
    range: 1..=9,
};

static WORD_WIS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WIS_CHILDREN),
    value: None,
};

pub static WORD_WIS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("conisn"),
        dictgen::InsensitiveStr::Ascii("consion"),
        dictgen::InsensitiveStr::Ascii("hlisht"),
        dictgen::InsensitiveStr::Ascii("hlsit"),
        dictgen::InsensitiveStr::Ascii("hpered"),
        dictgen::InsensitiveStr::Ascii("hpering"),
        dictgen::InsensitiveStr::Ascii("hpers"),
        dictgen::InsensitiveStr::Ascii("nton"),
    ],
    values: &[
        &["wisconsin"],
        &["wisconsin"],
        &["wishlist"],
        &["wishlist"],
        &["whispered"],
        &["whispering"],
        &["whispers"],
        &["winston"],
    ],
    range: 4..=7,
};

static WORD_WIR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WIR_CHILDREN),
    value: None,
};

pub static WORD_WIR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ded"),
        dictgen::InsensitiveStr::Ascii("edest"),
        dictgen::InsensitiveStr::Ascii("h"),
        dictgen::InsensitiveStr::Ascii("table"),
        dictgen::InsensitiveStr::Ascii("te"),
        dictgen::InsensitiveStr::Ascii("ter"),
        dictgen::InsensitiveStr::Ascii("ters"),
        dictgen::InsensitiveStr::Ascii("tes"),
        dictgen::InsensitiveStr::Ascii("th"),
        dictgen::InsensitiveStr::Ascii("ting"),
        dictgen::InsensitiveStr::Ascii("tten"),
        dictgen::InsensitiveStr::Ascii("tual"),
    ],
    values: &[
        &["wired", "weird"],
        &["weirdest"],
        &["with"],
        &["writable", "writeable"],
        &["write"],
        &["writer"],
        &["writers"],
        &["writes"],
        &["with", "worth"],
        &["writing"],
        &["written"],
        &["virtual"],
    ],
    range: 1..=5,
};

static WORD_WIP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WIP_CHILDREN),
    value: None,
};

pub static WORD_WIP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("oing")],
    values: &[&["wiping"]],
    range: 4..=4,
};

static WORD_WIN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WIN_CHILDREN),
    value: None,
};

pub static WORD_WIN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cheseter"),
        dictgen::InsensitiveStr::Ascii("chestor"),
        dictgen::InsensitiveStr::Ascii("dhsield"),
        dictgen::InsensitiveStr::Ascii("do"),
        dictgen::InsensitiveStr::Ascii("does"),
        dictgen::InsensitiveStr::Ascii("doow"),
        dictgen::InsensitiveStr::Ascii("doows"),
        dictgen::InsensitiveStr::Ascii("dos"),
        dictgen::InsensitiveStr::Ascii("dosr"),
        dictgen::InsensitiveStr::Ascii("dsheild"),
        dictgen::InsensitiveStr::Ascii("dsheilds"),
        dictgen::InsensitiveStr::Ascii("dshied"),
        dictgen::InsensitiveStr::Ascii("dshiled"),
        dictgen::InsensitiveStr::Ascii("dsoar"),
        dictgen::InsensitiveStr::Ascii("dwo"),
        dictgen::InsensitiveStr::Ascii("inpeg"),
        dictgen::InsensitiveStr::Ascii("n"),
        dictgen::InsensitiveStr::Ascii("ndow"),
        dictgen::InsensitiveStr::Ascii("ndows"),
        dictgen::InsensitiveStr::Ascii("nigns"),
        dictgen::InsensitiveStr::Ascii("nins"),
        dictgen::InsensitiveStr::Ascii("npieg"),
        dictgen::InsensitiveStr::Ascii("odw"),
        dictgen::InsensitiveStr::Ascii("sdor"),
        dictgen::InsensitiveStr::Ascii("tesses"),
        dictgen::InsensitiveStr::Ascii("tson"),
    ],
    values: &[
        &["winchester"],
        &["winchester"],
        &["windshield"],
        &["window"],
        &["windows"],
        &["window"],
        &["windows"],
        &["windows"],
        &["windsor"],
        &["windshield"],
        &["windshield"],
        &["windshield"],
        &["windshield"],
        &["windsor"],
        &["window"],
        &["winnipeg"],
        &["win"],
        &["window"],
        &["windows"],
        &["winnings"],
        &["winnings"],
        &["winnipeg"],
        &["window"],
        &["windsor"],
        &["witnesses"],
        &["winston"],
    ],
    range: 1..=8,
};

static WORD_WIL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WIL_CHILDREN),
    value: Some(&["will", "well"]),
};

pub static WORD_WIL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("card"),
        dictgen::InsensitiveStr::Ascii("cards"),
        dictgen::InsensitiveStr::Ascii("derniss"),
        dictgen::InsensitiveStr::Ascii("dreness"),
        dictgen::InsensitiveStr::Ascii("h"),
        dictgen::InsensitiveStr::Ascii("laims"),
        dictgen::InsensitiveStr::Ascii("le"),
        dictgen::InsensitiveStr::Ascii("lfullly"),
        dictgen::InsensitiveStr::Ascii("lfuly"),
        dictgen::InsensitiveStr::Ascii("limas"),
        dictgen::InsensitiveStr::Ascii("lingless"),
        dictgen::InsensitiveStr::Ascii("lk"),
        dictgen::InsensitiveStr::Ascii("ll"),
    ],
    values: &[
        &["wildcard"],
        &["wildcards"],
        &["wilderness"],
        &["wilderness"],
        &["will"],
        &["williams"],
        &["will"],
        &["willfully"],
        &["willfully"],
        &["williams"],
        &["willingness"],
        &["will"],
        &["will"],
    ],
    range: 1..=8,
};

static WORD_WIK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WIK_CHILDREN),
    value: None,
};

pub static WORD_WIK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ileakers"),
        dictgen::InsensitiveStr::Ascii("ileakes"),
        dictgen::InsensitiveStr::Ascii("pedia"),
    ],
    values: &[&["wikileaks"], &["wikileaks"], &["wikipedia"]],
    range: 5..=8,
};

static WORD_WII_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WII_CHILDREN),
    value: None,
};

pub static WORD_WII_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("l")],
    values: &[&["will"]],
    range: 1..=1,
};

static WORD_WIH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WIH_CHILDREN),
    value: Some(&["with"]),
};

pub static WORD_WIH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ch"),
        dictgen::InsensitiveStr::Ascii("ich"),
        dictgen::InsensitiveStr::Ascii("ite"),
        dictgen::InsensitiveStr::Ascii("le"),
        dictgen::InsensitiveStr::Ascii("out"),
        dictgen::InsensitiveStr::Ascii("t"),
        dictgen::InsensitiveStr::Ascii("tin"),
        dictgen::InsensitiveStr::Ascii("tout"),
    ],
    values: &[
        &["which"],
        &["which"],
        &["white"],
        &["while"],
        &["without"],
        &["with"],
        &["within"],
        &["without"],
    ],
    range: 1..=4,
};

static WORD_WIG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WIG_CHILDREN),
    value: None,
};

pub static WORD_WIG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("det"),
        dictgen::InsensitiveStr::Ascii("dets"),
        dictgen::InsensitiveStr::Ascii("hed"),
        dictgen::InsensitiveStr::Ascii("hted"),
    ],
    values: &[
        &["widget"],
        &["widgets"],
        &["weighed", "wicked"],
        &["weighted", "weighed"],
    ],
    range: 3..=4,
};

static WORD_WIE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WIE_CHILDREN),
    value: None,
};

pub static WORD_WIE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("f"),
        dictgen::InsensitiveStr::Ascii("ghed"),
        dictgen::InsensitiveStr::Ascii("ght"),
        dictgen::InsensitiveStr::Ascii("ghted"),
        dictgen::InsensitiveStr::Ascii("ghtlifting"),
        dictgen::InsensitiveStr::Ascii("ghts"),
        dictgen::InsensitiveStr::Ascii("h"),
        dictgen::InsensitiveStr::Ascii("rd"),
        dictgen::InsensitiveStr::Ascii("rdly"),
        dictgen::InsensitiveStr::Ascii("rdness"),
        dictgen::InsensitiveStr::Ascii("th"),
        dictgen::InsensitiveStr::Ascii("w"),
    ],
    values: &[
        &["wife"],
        &["weighed"],
        &["weight"],
        &["weighted", "weighed"],
        &["weightlifting"],
        &["weights"],
        &["view"],
        &["weird"],
        &["weirdly"],
        &["weirdness"],
        &["width"],
        &["view"],
    ],
    range: 1..=10,
};

static WORD_WID_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WID_CHILDREN),
    value: None,
};

pub static WORD_WID_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("epsread"),
        dictgen::InsensitiveStr::Ascii("espred"),
        dictgen::InsensitiveStr::Ascii("esread"),
        dictgen::InsensitiveStr::Ascii("ged"),
        dictgen::InsensitiveStr::Ascii("gest"),
        dictgen::InsensitiveStr::Ascii("getas"),
        dictgen::InsensitiveStr::Ascii("git"),
        dictgen::InsensitiveStr::Ascii("ht"),
        dictgen::InsensitiveStr::Ascii("htpoint"),
        dictgen::InsensitiveStr::Ascii("htpoints"),
        dictgen::InsensitiveStr::Ascii("thn"),
        dictgen::InsensitiveStr::Ascii("thout"),
    ],
    values: &[
        &["widespread"],
        &["widespread"],
        &["widespread"],
        &["widget"],
        &["widgets"],
        &["widgets"],
        &["widget"],
        &["width"],
        &["widthpoint"],
        &["widthpoints"],
        &["width"],
        &["without"],
    ],
    range: 2..=8,
};

static WORD_WIC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WIC_CHILDREN),
    value: None,
};

pub static WORD_WIC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("h"),
    ],
    values: &[&["vice"], &["which"]],
    range: 1..=1,
};

static WORD_WIA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WIA_CHILDREN),
    value: None,
};

pub static WORD_WIA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("t"),
        dictgen::InsensitiveStr::Ascii("ters"),
        dictgen::InsensitiveStr::Ascii("vers"),
    ],
    values: &[&["wait"], &["waiters"], &["waivers"]],
    range: 1..=4,
};

static WORD_WH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_WH_CHILDREN),
    value: None,
};

static WORD_WH_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_WHA_NODE),
    None,
    Some(&WORD_WHC_NODE),
    None,
    Some(&WORD_WHE_NODE),
    None,
    None,
    Some(&WORD_WHH_NODE),
    Some(&WORD_WHI_NODE),
    None,
    None,
    Some(&WORD_WHL_NODE),
    None,
    Some(&WORD_WHN_NODE),
    Some(&WORD_WHO_NODE),
    None,
    None,
    Some(&WORD_WHR_NODE),
    Some(&WORD_WHS_NODE),
    Some(&WORD_WHT_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_WHY_NODE),
    None,
];

static WORD_WHY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WHY_CHILDREN),
    value: None,
};

pub static WORD_WHY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("th"),
        dictgen::InsensitiveStr::Ascii("thout"),
    ],
    values: &[&["with"], &["without"]],
    range: 2..=5,
};

static WORD_WHT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WHT_CHILDREN),
    value: None,
};

pub static WORD_WHT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("a"),
        dictgen::InsensitiveStr::Ascii("her"),
        dictgen::InsensitiveStr::Ascii("ielist"),
        dictgen::InsensitiveStr::Ascii("ihin"),
    ],
    values: &[&["what"], &["whether"], &["whitelist"], &["within"]],
    range: 1..=6,
};

static WORD_WHS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WHS_CHILDREN),
    value: None,
};

pub static WORD_WHS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("iper"),
        dictgen::InsensitiveStr::Ascii("ipered"),
        dictgen::InsensitiveStr::Ascii("ipering"),
        dictgen::InsensitiveStr::Ascii("ipers"),
    ],
    values: &[&["whisper"], &["whispered"], &["whispering"], &["whispers"]],
    range: 4..=7,
};

static WORD_WHR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WHR_CHILDREN),
    value: None,
};

pub static WORD_WHR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ilwind")],
    values: &[&["whirlwind"]],
    range: 6..=6,
};

static WORD_WHO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WHO_CHILDREN),
    value: None,
};

pub static WORD_WHO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("leheartadly"),
        dictgen::InsensitiveStr::Ascii("leheartdly"),
        dictgen::InsensitiveStr::Ascii("leheartedy"),
        dictgen::InsensitiveStr::Ascii("leheartely"),
        dictgen::InsensitiveStr::Ascii("leheartidly"),
        dictgen::InsensitiveStr::Ascii("ley"),
        dictgen::InsensitiveStr::Ascii("ly"),
        dictgen::InsensitiveStr::Ascii("ose"),
        dictgen::InsensitiveStr::Ascii("s"),
        dictgen::InsensitiveStr::Ascii("uld"),
    ],
    values: &[
        &["whose"],
        &["wholeheartedly"],
        &["wholeheartedly"],
        &["wholeheartedly"],
        &["wholeheartedly"],
        &["wholeheartedly"],
        &["wholly"],
        &["wholly", "holy"],
        &["whose"],
        &["whose"],
        &["would"],
    ],
    range: 1..=11,
};

static WORD_WHN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WHN_CHILDREN),
    value: Some(&["when"]),
};

pub static WORD_WHN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("e")],
    values: &[&["when"]],
    range: 1..=1,
};

static WORD_WHL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WHL_CHILDREN),
    value: None,
};

pub static WORD_WHL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ch"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("ie"),
    ],
    values: &[&["which"], &["while"], &["while"]],
    range: 1..=2,
};

static WORD_WHI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WHI_CHILDREN),
    value: None,
};

pub static WORD_WHI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("c"),
        dictgen::InsensitiveStr::Ascii("cg"),
        dictgen::InsensitiveStr::Ascii("cht"),
        dictgen::InsensitiveStr::Ascii("etlist"),
        dictgen::InsensitiveStr::Ascii("hc"),
        dictgen::InsensitiveStr::Ascii("hch"),
        dictgen::InsensitiveStr::Ascii("ke"),
        dictgen::InsensitiveStr::Ascii("lest"),
        dictgen::InsensitiveStr::Ascii("lrwind"),
        dictgen::InsensitiveStr::Ascii("lsting"),
        dictgen::InsensitiveStr::Ascii("ltelist"),
        dictgen::InsensitiveStr::Ascii("ltelisted"),
        dictgen::InsensitiveStr::Ascii("ltelisting"),
        dictgen::InsensitiveStr::Ascii("ltelists"),
        dictgen::InsensitiveStr::Ascii("lw"),
        dictgen::InsensitiveStr::Ascii("och"),
        dictgen::InsensitiveStr::Ascii("ped"),
        dictgen::InsensitiveStr::Ascii("pser"),
        dictgen::InsensitiveStr::Ascii("psered"),
        dictgen::InsensitiveStr::Ascii("psering"),
        dictgen::InsensitiveStr::Ascii("psers"),
        dictgen::InsensitiveStr::Ascii("s"),
        dictgen::InsensitiveStr::Ascii("sh"),
        dictgen::InsensitiveStr::Ascii("shlist"),
        dictgen::InsensitiveStr::Ascii("slist"),
        dictgen::InsensitiveStr::Ascii("slte"),
        dictgen::InsensitiveStr::Ascii("sltes"),
        dictgen::InsensitiveStr::Ascii("slting"),
        dictgen::InsensitiveStr::Ascii("sperd"),
        dictgen::InsensitiveStr::Ascii("sperered"),
        dictgen::InsensitiveStr::Ascii("speres"),
        dictgen::InsensitiveStr::Ascii("stel"),
        dictgen::InsensitiveStr::Ascii("stels"),
        dictgen::InsensitiveStr::Ascii("tch"),
        dictgen::InsensitiveStr::Ascii("tchever"),
        dictgen::InsensitiveStr::Ascii("telsit"),
        dictgen::InsensitiveStr::Ascii("tepsace"),
        dictgen::InsensitiveStr::Ascii("tepsaces"),
        dictgen::InsensitiveStr::Ascii("th"),
        dictgen::InsensitiveStr::Ascii("the"),
        dictgen::InsensitiveStr::Ascii("thin"),
        dictgen::InsensitiveStr::Ascii("tholding"),
        dictgen::InsensitiveStr::Ascii("thout"),
        dictgen::InsensitiveStr::Ascii("tleist"),
        dictgen::InsensitiveStr::Ascii("tout"),
        dictgen::InsensitiveStr::Ascii("tre"),
        dictgen::InsensitiveStr::Ascii("tsle"),
        dictgen::InsensitiveStr::Ascii("tsles"),
        dictgen::InsensitiveStr::Ascii("tsling"),
        dictgen::InsensitiveStr::Ascii("tspace"),
    ],
    values: &[
        &["which"],
        &["which"],
        &["which"],
        &["whitelist"],
        &["which"],
        &["which"],
        &["while"],
        &["whilst"],
        &["whirlwind"],
        &["whistling"],
        &["whitelist"],
        &["whitelisted"],
        &["whitelisting"],
        &["whitelists"],
        &["while"],
        &["which"],
        &["whipped", "wiped"],
        &["whisper"],
        &["whispered"],
        &["whispering"],
        &["whispers"],
        &["this", "whisk"],
        &["wish", "whisk"],
        &["wishlist"],
        &["wishlist"],
        &["whistle"],
        &["whistles"],
        &["whistling"],
        &["whispered"],
        &["whispered"],
        &["whispers"],
        &["whistle"],
        &["whistles"],
        &["which"],
        &["whichever"],
        &["whitelist"],
        &["whitespace"],
        &["whitespaces"],
        &["with"],
        &["with", "white"],
        &["within"],
        &["withholding"],
        &["without"],
        &["whitelist"],
        &["without", "whiteout"],
        &["white"],
        &["whistle"],
        &["whistles"],
        &["whistling"],
        &["whitespace"],
    ],
    range: 1..=10,
};

static WORD_WHH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WHH_CHILDREN),
    value: None,
};

pub static WORD_WHH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("eel")],
    values: &[&["wheel"]],
    range: 3..=3,
};

static WORD_WHE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WHE_CHILDREN),
    value: Some(&["when", "we"]),
};

pub static WORD_WHE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ather"),
        dictgen::InsensitiveStr::Ascii("hter"),
        dictgen::InsensitiveStr::Ascii("igh"),
        dictgen::InsensitiveStr::Ascii("ll"),
        dictgen::InsensitiveStr::Ascii("nevery"),
        dictgen::InsensitiveStr::Ascii("nver"),
        dictgen::InsensitiveStr::Ascii("r"),
        dictgen::InsensitiveStr::Ascii("ras"),
        dictgen::InsensitiveStr::Ascii("rease"),
        dictgen::InsensitiveStr::Ascii("reever"),
        dictgen::InsensitiveStr::Ascii("rether"),
        dictgen::InsensitiveStr::Ascii("ry"),
        dictgen::InsensitiveStr::Ascii("teher"),
        dictgen::InsensitiveStr::Ascii("tehr"),
        dictgen::InsensitiveStr::Ascii("ter"),
        dictgen::InsensitiveStr::Ascii("the"),
        dictgen::InsensitiveStr::Ascii("thter"),
    ],
    values: &[
        &["weather", "whether"],
        &["whether"],
        &["weigh"],
        &["wheel", "well"],
        &["whenever"],
        &["whenever"],
        &["where"],
        &["whereas"],
        &["whereas"],
        &["wherever"],
        &["whether"],
        &["where"],
        &["whether"],
        &["whether"],
        &["whether"],
        &["whether"],
        &["whether"],
    ],
    range: 1..=6,
};

static WORD_WHC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WHC_CHILDREN),
    value: None,
};

pub static WORD_WHC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("h"),
        dictgen::InsensitiveStr::Ascii("ih"),
    ],
    values: &[&["which"], &["which"]],
    range: 1..=2,
};

static WORD_WHA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WHA_CHILDREN),
    value: None,
};

pub static WORD_WHA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eton"),
        dictgen::InsensitiveStr::Ascii("n"),
        dictgen::InsensitiveStr::Ascii("nt"),
        dictgen::InsensitiveStr::Ascii("nts"),
        dictgen::InsensitiveStr::Ascii("taver"),
        dictgen::InsensitiveStr::Ascii("tepsace"),
        dictgen::InsensitiveStr::Ascii("tepsaces"),
        dictgen::InsensitiveStr::Ascii("ther"),
        dictgen::InsensitiveStr::Ascii("tosever"),
        dictgen::InsensitiveStr::Ascii("tseover"),
    ],
    values: &[
        &["wheaton"],
        &["want", "when"],
        &["want"],
        &["wants"],
        &["whatever"],
        &["whitespace"],
        &["whitespaces"],
        &["whether", "weather"],
        &["whatsoever"],
        &["whatsoever"],
    ],
    range: 1..=8,
};

static WORD_WE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_WE_CHILDREN),
    value: None,
};

static WORD_WE_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_WEA_NODE),
    Some(&WORD_WEB_NODE),
    None,
    Some(&WORD_WED_NODE),
    None,
    None,
    Some(&WORD_WEG_NODE),
    Some(&WORD_WEH_NODE),
    Some(&WORD_WEI_NODE),
    None,
    None,
    Some(&WORD_WEL_NODE),
    None,
    Some(&WORD_WEN_NODE),
    None,
    Some(&WORD_WEP_NODE),
    None,
    Some(&WORD_WER_NODE),
    Some(&WORD_WES_NODE),
    Some(&WORD_WET_NODE),
    None,
    None,
    Some(&WORD_WEW_NODE),
    None,
    None,
    None,
];

static WORD_WEW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WEW_CHILDREN),
    value: Some(&["we"]),
};

pub static WORD_WEW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[],
    values: &[],
    range: 0..=0,
};

static WORD_WET_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WET_CHILDREN),
    value: None,
};

pub static WORD_WET_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("her")],
    values: &[&["weather", "whether"]],
    range: 3..=3,
};

static WORD_WES_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WES_CHILDREN),
    value: None,
};

pub static WORD_WES_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bite"),
        dictgen::InsensitiveStr::Ascii("bites"),
        dictgen::InsensitiveStr::Ascii("btrook"),
        dictgen::InsensitiveStr::Ascii("tbrok"),
        dictgen::InsensitiveStr::Ascii("tbroook"),
        dictgen::InsensitiveStr::Ascii("ternerns"),
        dictgen::InsensitiveStr::Ascii("ternes"),
        dictgen::InsensitiveStr::Ascii("ternese"),
        dictgen::InsensitiveStr::Ascii("terness"),
        dictgen::InsensitiveStr::Ascii("terse"),
        dictgen::InsensitiveStr::Ascii("tminser"),
        dictgen::InsensitiveStr::Ascii("tminter"),
        dictgen::InsensitiveStr::Ascii("tmisnter"),
        dictgen::InsensitiveStr::Ascii("tmnister"),
        dictgen::InsensitiveStr::Ascii("tmonster"),
        dictgen::InsensitiveStr::Ascii("trbook"),
    ],
    values: &[
        &["website"],
        &["websites"],
        &["westbrook"],
        &["westbrook"],
        &["westbrook"],
        &["westerners"],
        &["westerners"],
        &["westerners"],
        &["westerners"],
        &["westerners"],
        &["westminster"],
        &["westminster"],
        &["westminster"],
        &["westminster"],
        &["westminster"],
        &["westbrook"],
    ],
    range: 4..=8,
};

static WORD_WER_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WER_CHILDREN),
    value: None,
};

pub static WORD_WER_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eabouts"),
        dictgen::InsensitiveStr::Ascii("eas"),
        dictgen::InsensitiveStr::Ascii("ee"),
        dictgen::InsensitiveStr::Ascii("ever"),
        dictgen::InsensitiveStr::Ascii("idest"),
        dictgen::InsensitiveStr::Ascii("idly"),
        dictgen::InsensitiveStr::Ascii("idos"),
        dictgen::InsensitiveStr::Ascii("stle"),
        dictgen::InsensitiveStr::Ascii("stler"),
        dictgen::InsensitiveStr::Ascii("y"),
    ],
    values: &[
        &["whereabouts"],
        &["whereas"],
        &["were"],
        &["wherever"],
        &["weirdest"],
        &["weirdly"],
        &["weirdos"],
        &["wrestle"],
        &["wrestler"],
        &["very", "wary", "weary"],
    ],
    range: 1..=7,
};

static WORD_WEP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WEP_CHILDREN),
    value: None,
};

pub static WORD_WEP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("bage")],
    values: &[&["webpage"]],
    range: 4..=4,
};

static WORD_WEN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WEN_CHILDREN),
    value: None,
};

pub static WORD_WEN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("desday"),
        dictgen::InsensitiveStr::Ascii("desdays"),
        dictgen::InsensitiveStr::Ascii("dsay"),
        dictgen::InsensitiveStr::Ascii("sday"),
    ],
    values: &[
        &["wednesday"],
        &["wednesdays"],
        &["wednesday"],
        &["wednesday"],
    ],
    range: 4..=7,
};

static WORD_WEL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WEL_CHILDREN),
    value: None,
};

pub static WORD_WEL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("athier"),
        dictgen::InsensitiveStr::Ascii("athiest"),
        dictgen::InsensitiveStr::Ascii("athy"),
        dictgen::InsensitiveStr::Ascii("lignton"),
        dictgen::InsensitiveStr::Ascii("lingotn"),
        dictgen::InsensitiveStr::Ascii("lingston"),
        dictgen::InsensitiveStr::Ascii("lingtion"),
    ],
    values: &[
        &["wealthier"],
        &["wealthiest"],
        &["wealthy"],
        &["wellington"],
        &["wellington"],
        &["wellington"],
        &["wellington"],
    ],
    range: 4..=8,
};

static WORD_WEI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WEI_CHILDREN),
    value: None,
};

pub static WORD_WEI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ghtened"),
        dictgen::InsensitiveStr::Ascii("ghtlfiting"),
        dictgen::InsensitiveStr::Ascii("ghtlifing"),
        dictgen::InsensitiveStr::Ascii("ghtlifitng"),
        dictgen::InsensitiveStr::Ascii("ghtligting"),
        dictgen::InsensitiveStr::Ascii("gth"),
        dictgen::InsensitiveStr::Ascii("gthed"),
        dictgen::InsensitiveStr::Ascii("gthlifting"),
        dictgen::InsensitiveStr::Ascii("gths"),
        dictgen::InsensitiveStr::Ascii("ld"),
        dictgen::InsensitiveStr::Ascii("lded"),
        dictgen::InsensitiveStr::Ascii("ll"),
        dictgen::InsensitiveStr::Ascii("red"),
        dictgen::InsensitiveStr::Ascii("rldy"),
        dictgen::InsensitiveStr::Ascii("rods"),
        dictgen::InsensitiveStr::Ascii("tght"),
    ],
    values: &[
        &["weighted"],
        &["weightlifting"],
        &["weightlifting"],
        &["weightlifting"],
        &["weightlifting"],
        &["weight"],
        &["weighted"],
        &["weightlifting"],
        &["weights"],
        &["wield", "wild"],
        &["wielded"],
        &["will"],
        &["weird"],
        &["weirdly"],
        &["weirdos"],
        &["weight"],
    ],
    range: 2..=10,
};

static WORD_WEH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WEH_CHILDREN),
    value: None,
};

pub static WORD_WEH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ere"),
        dictgen::InsensitiveStr::Ascii("n"),
        dictgen::InsensitiveStr::Ascii("ther"),
    ],
    values: &[&["where"], &["when"], &["whether"]],
    range: 1..=4,
};

static WORD_WEG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WEG_CHILDREN),
    value: None,
};

pub static WORD_WEG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("e")],
    values: &[&["wedge"]],
    range: 1..=1,
};

static WORD_WED_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WED_CHILDREN),
    value: None,
};

pub static WORD_WED_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ensday"),
        dictgen::InsensitiveStr::Ascii("ensdays"),
        dictgen::InsensitiveStr::Ascii("nesdaay"),
        dictgen::InsensitiveStr::Ascii("nesdsay"),
        dictgen::InsensitiveStr::Ascii("nesdsy"),
        dictgen::InsensitiveStr::Ascii("nesdy"),
        dictgen::InsensitiveStr::Ascii("nessay"),
        dictgen::InsensitiveStr::Ascii("nessday"),
        dictgen::InsensitiveStr::Ascii("nseday"),
        dictgen::InsensitiveStr::Ascii("nsedays"),
    ],
    values: &[
        &["wednesday"],
        &["wednesdays"],
        &["wednesday"],
        &["wednesdays"],
        &["wednesdays"],
        &["wednesdays"],
        &["wednesdays"],
        &["wednesdays"],
        &["wednesday"],
        &["wednesdays"],
    ],
    range: 5..=7,
};

static WORD_WEB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WEB_CHILDREN),
    value: None,
};

pub static WORD_WEB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("apge"),
        dictgen::InsensitiveStr::Ascii("iste"),
        dictgen::InsensitiveStr::Ascii("istes"),
        dictgen::InsensitiveStr::Ascii("stie"),
        dictgen::InsensitiveStr::Ascii("sties"),
    ],
    values: &[
        &["webpage"],
        &["website"],
        &["websites"],
        &["website"],
        &["websites"],
    ],
    range: 4..=5,
};

static WORD_WEA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WEA_CHILDREN),
    value: None,
};

pub static WORD_WEA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("kenend"),
        dictgen::InsensitiveStr::Ascii("kensses"),
        dictgen::InsensitiveStr::Ascii("kneses"),
        dictgen::InsensitiveStr::Ascii("knesess"),
        dictgen::InsensitiveStr::Ascii("knesss"),
        dictgen::InsensitiveStr::Ascii("knessses"),
        dictgen::InsensitiveStr::Ascii("ltheir"),
        dictgen::InsensitiveStr::Ascii("lthly"),
        dictgen::InsensitiveStr::Ascii("nt"),
        dictgen::InsensitiveStr::Ascii("ponary"),
        dictgen::InsensitiveStr::Ascii("s"),
        dictgen::InsensitiveStr::Ascii("thliest"),
    ],
    values: &[
        &["weakened"],
        &["weaknesses"],
        &["weakness"],
        &["weaknesses"],
        &["weaknesses"],
        &["weaknesses"],
        &["wealthier"],
        &["wealthy"],
        &["want", "wean"],
        &["weaponry"],
        &["was"],
        &["wealthiest"],
    ],
    range: 1..=8,
};

static WORD_WA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_WA_CHILDREN),
    value: None,
};

static WORD_WA_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    None,
    Some(&WORD_WAC_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_WAH_NODE),
    Some(&WORD_WAI_NODE),
    None,
    Some(&WORD_WAK_NODE),
    Some(&WORD_WAL_NODE),
    None,
    None,
    None,
    Some(&WORD_WAP_NODE),
    None,
    Some(&WORD_WAR_NODE),
    Some(&WORD_WAS_NODE),
    Some(&WORD_WAT_NODE),
    None,
    Some(&WORD_WAV_NODE),
    Some(&WORD_WAW_NODE),
    None,
    Some(&WORD_WAY_NODE),
    None,
];

static WORD_WAY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WAY_CHILDREN),
    value: None,
};

pub static WORD_WAY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("word")],
    values: &[&["wayward"]],
    range: 4..=4,
};

static WORD_WAW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WAW_CHILDREN),
    value: None,
};

pub static WORD_WAW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("rick")],
    values: &[&["warwick"]],
    range: 4..=4,
};

static WORD_WAV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WAV_CHILDREN),
    value: None,
};

pub static WORD_WAV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("elegnth"),
        dictgen::InsensitiveStr::Ascii("elegnths"),
        dictgen::InsensitiveStr::Ascii("elengh"),
        dictgen::InsensitiveStr::Ascii("elenghs"),
        dictgen::InsensitiveStr::Ascii("elenght"),
        dictgen::InsensitiveStr::Ascii("elenghth"),
        dictgen::InsensitiveStr::Ascii("elenghts"),
        dictgen::InsensitiveStr::Ascii("elnes"),
        dictgen::InsensitiveStr::Ascii("iers"),
    ],
    values: &[
        &["wavelength"],
        &["wavelength"],
        &["wavelength"],
        &["wavelength"],
        &["wavelength"],
        &["wavelength"],
        &["wavelength", "wavelengths"],
        &["wavelines"],
        &["waivers"],
    ],
    range: 4..=8,
};

static WORD_WAT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WAT_CHILDREN),
    value: None,
};

pub static WORD_WAT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("chdong"),
        dictgen::InsensitiveStr::Ascii("chemn"),
        dictgen::InsensitiveStr::Ascii("chign"),
        dictgen::InsensitiveStr::Ascii("chog"),
        dictgen::InsensitiveStr::Ascii("erlemon"),
        dictgen::InsensitiveStr::Ascii("ermalon"),
        dictgen::InsensitiveStr::Ascii("ermask"),
        dictgen::InsensitiveStr::Ascii("ermeleon"),
        dictgen::InsensitiveStr::Ascii("erproff"),
        dictgen::InsensitiveStr::Ascii("erprooof"),
        dictgen::InsensitiveStr::Ascii("h"),
        dictgen::InsensitiveStr::Ascii("hc"),
        dictgen::InsensitiveStr::Ascii("hcer"),
        dictgen::InsensitiveStr::Ascii("hcing"),
        dictgen::InsensitiveStr::Ascii("hcmen"),
        dictgen::InsensitiveStr::Ascii("hdog"),
        dictgen::InsensitiveStr::Ascii("hever"),
        dictgen::InsensitiveStr::Ascii("hs"),
        dictgen::InsensitiveStr::Ascii("iers"),
        dictgen::InsensitiveStr::Ascii("ing"),
        dictgen::InsensitiveStr::Ascii("kings"),
        dictgen::InsensitiveStr::Ascii("n"),
    ],
    values: &[
        &["watchdog"],
        &["watchmen"],
        &["watching"],
        &["watchdog"],
        &["watermelon"],
        &["watermelon"],
        &["watermark"],
        &["watermelon"],
        &["waterproof"],
        &["waterproof"],
        &["watch", "wrath", "what"],
        &["watch"],
        &["watcher"],
        &["watching"],
        &["watchmen"],
        &["watchdog"],
        &["whatever"],
        &["whats", "watches"],
        &["waiters"],
        &["waiting"],
        &["watkins"],
        &["want"],
    ],
    range: 1..=8,
};

static WORD_WAS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WAS_CHILDREN),
    value: None,
};

pub static WORD_WAS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hignton"),
        dictgen::InsensitiveStr::Ascii("hingtion"),
        dictgen::InsensitiveStr::Ascii("s"),
    ],
    values: &[&["washington"], &["washington"], &["was"]],
    range: 1..=8,
};

static WORD_WAR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WAR_CHILDREN),
    value: None,
};

pub static WORD_WAR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("antee"),
        dictgen::InsensitiveStr::Ascii("anties"),
        dictgen::InsensitiveStr::Ascii("anty"),
        dictgen::InsensitiveStr::Ascii("carft"),
        dictgen::InsensitiveStr::Ascii("crat"),
        dictgen::InsensitiveStr::Ascii("dobe"),
        dictgen::InsensitiveStr::Ascii("ing"),
        dictgen::InsensitiveStr::Ascii("inigs"),
        dictgen::InsensitiveStr::Ascii("inings"),
        dictgen::InsensitiveStr::Ascii("iwck"),
        dictgen::InsensitiveStr::Ascii("ks"),
        dictgen::InsensitiveStr::Ascii("lking"),
        dictgen::InsensitiveStr::Ascii("nibg"),
        dictgen::InsensitiveStr::Ascii("nibgs"),
        dictgen::InsensitiveStr::Ascii("nig"),
        dictgen::InsensitiveStr::Ascii("nign"),
        dictgen::InsensitiveStr::Ascii("nigns"),
        dictgen::InsensitiveStr::Ascii("nigs"),
        dictgen::InsensitiveStr::Ascii("niing"),
        dictgen::InsensitiveStr::Ascii("niings"),
        dictgen::InsensitiveStr::Ascii("nin"),
        dictgen::InsensitiveStr::Ascii("nind"),
        dictgen::InsensitiveStr::Ascii("ninds"),
        dictgen::InsensitiveStr::Ascii("ninf"),
        dictgen::InsensitiveStr::Ascii("ninfs"),
        dictgen::InsensitiveStr::Ascii("ningss"),
        dictgen::InsensitiveStr::Ascii("ninig"),
        dictgen::InsensitiveStr::Ascii("ninigs"),
        dictgen::InsensitiveStr::Ascii("nining"),
        dictgen::InsensitiveStr::Ascii("ninings"),
        dictgen::InsensitiveStr::Ascii("ninng"),
        dictgen::InsensitiveStr::Ascii("ninngs"),
        dictgen::InsensitiveStr::Ascii("nins"),
        dictgen::InsensitiveStr::Ascii("ninsg"),
        dictgen::InsensitiveStr::Ascii("ninsgs"),
        dictgen::InsensitiveStr::Ascii("niong"),
        dictgen::InsensitiveStr::Ascii("niongs"),
        dictgen::InsensitiveStr::Ascii("randyte"),
        dictgen::InsensitiveStr::Ascii("rante"),
        dictgen::InsensitiveStr::Ascii("rantles"),
        dictgen::InsensitiveStr::Ascii("rantly"),
        dictgen::InsensitiveStr::Ascii("rany"),
        dictgen::InsensitiveStr::Ascii("rent"),
        dictgen::InsensitiveStr::Ascii("renties"),
        dictgen::InsensitiveStr::Ascii("rios"),
        dictgen::InsensitiveStr::Ascii("riros"),
        dictgen::InsensitiveStr::Ascii("rriors"),
        dictgen::InsensitiveStr::Ascii("wcik"),
    ],
    values: &[
        &["warranty"],
        &["warranties"],
        &["warranty"],
        &["warcraft"],
        &["warcraft"],
        &["wardrobe"],
        &["warning"],
        &["warnings"],
        &["warnings"],
        &["warwick"],
        &["works"],
        &["walking"],
        &["warning"],
        &["warnings"],
        &["warning"],
        &["warning"],
        &["warnings"],
        &["warnings"],
        &["warning"],
        &["warnings"],
        &["warning"],
        &["warning"],
        &["warnings"],
        &["warning"],
        &["warnings"],
        &["warnings"],
        &["warning"],
        &["warnings"],
        &["warning"],
        &["warnings"],
        &["warning"],
        &["warnings"],
        &["warnings"],
        &["warnings"],
        &["warnings"],
        &["warning"],
        &["warnings"],
        &["warranty"],
        &["warranties"],
        &["warranties"],
        &["warranty"],
        &["warranty"],
        &["warrant"],
        &["warranties"],
        &["warriors"],
        &["warriors"],
        &["warriors"],
        &["warwick"],
    ],
    range: 2..=7,
};

static WORD_WAP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WAP_CHILDREN),
    value: None,
};

pub static WORD_WAP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("pers")],
    values: &[&["wrappers"]],
    range: 4..=4,
};

static WORD_WAL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WAL_CHILDREN),
    value: None,
};

pub static WORD_WAL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lpapaers"),
        dictgen::InsensitiveStr::Ascii("lpapes"),
        dictgen::InsensitiveStr::Ascii("lpappers"),
        dictgen::InsensitiveStr::Ascii("lpapr"),
    ],
    values: &[
        &["wallpapers"],
        &["wallpapers"],
        &["wallpapers"],
        &["wallpapers"],
    ],
    range: 5..=8,
};

static WORD_WAK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WAK_CHILDREN),
    value: None,
};

pub static WORD_WAK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eus"),
        dictgen::InsensitiveStr::Ascii("tins"),
        dictgen::InsensitiveStr::Ascii("up"),
    ],
    values: &[&["wakeups", "walrus"], &["watkins"], &["wakeup"]],
    range: 2..=4,
};

static WORD_WAI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WAI_CHILDREN),
    value: None,
};

pub static WORD_WAI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("tres")],
    values: &[&["waiters"]],
    range: 4..=4,
};

static WORD_WAH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WAH_CHILDREN),
    value: None,
};

pub static WORD_WAH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("t"),
        dictgen::InsensitiveStr::Ascii("tever"),
    ],
    values: &[&["what"], &["whatever"]],
    range: 1..=5,
};

static WORD_WAC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_WAC_CHILDREN),
    value: None,
};

pub static WORD_WAC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lott"),
        dictgen::InsensitiveStr::Ascii("ther"),
    ],
    values: &[&["walcott"], &["watcher"]],
    range: 4..=4,
};

static WORD_V_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_V_CHILDREN),
    value: None,
};

static WORD_V_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_VA_NODE),
    Some(&WORD_VB_NODE),
    None,
    None,
    Some(&WORD_VE_NODE),
    None,
    None,
    Some(&WORD_VH_NODE),
    Some(&WORD_VI_NODE),
    None,
    None,
    Some(&WORD_VL_NODE),
    None,
    None,
    Some(&WORD_VO_NODE),
    None,
    None,
    Some(&WORD_VR_NODE),
    None,
    None,
    Some(&WORD_VU_NODE),
    None,
    None,
    None,
    Some(&WORD_VY_NODE),
    None,
];

static WORD_VY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VY_CHILDREN),
    value: None,
};

pub static WORD_VY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("re"),
    ],
    values: &[&["very"], &["very"]],
    range: 2..=2,
};

static WORD_VU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_VU_CHILDREN),
    value: None,
};

static WORD_VU_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_VUL_NODE),
    None,
    Some(&WORD_VUN_NODE),
    None,
    None,
    None,
    Some(&WORD_VUR_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_VUR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VUR_CHILDREN),
    value: None,
};

pub static WORD_VUR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("nerabilities"),
        dictgen::InsensitiveStr::Ascii("nerability"),
    ],
    values: &[&["vulnerabilities"], &["vulnerability"]],
    range: 10..=12,
};

static WORD_VUN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VUN_CHILDREN),
    value: None,
};

pub static WORD_VUN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("erable"),
        dictgen::InsensitiveStr::Ascii("lerabilities"),
        dictgen::InsensitiveStr::Ascii("lerability"),
        dictgen::InsensitiveStr::Ascii("lerable"),
    ],
    values: &[
        &["vulnerable"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerable"],
    ],
    range: 6..=12,
};

static WORD_VUL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_VUL_CHILDREN),
    value: None,
};

static WORD_VUL_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_VULA_NODE),
    Some(&WORD_VULB_NODE),
    None,
    None,
    Some(&WORD_VULE_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_VULN_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_VULN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VULN_CHILDREN),
    value: None,
};

pub static WORD_VULN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arabilities"),
        dictgen::InsensitiveStr::Ascii("arability"),
        dictgen::InsensitiveStr::Ascii("arable"),
        dictgen::InsensitiveStr::Ascii("eabilities"),
        dictgen::InsensitiveStr::Ascii("eability"),
        dictgen::InsensitiveStr::Ascii("eable"),
        dictgen::InsensitiveStr::Ascii("earabilities"),
        dictgen::InsensitiveStr::Ascii("earability"),
        dictgen::InsensitiveStr::Ascii("earable"),
        dictgen::InsensitiveStr::Ascii("earabule"),
        dictgen::InsensitiveStr::Ascii("earbilities"),
        dictgen::InsensitiveStr::Ascii("earbility"),
        dictgen::InsensitiveStr::Ascii("earbuilities"),
        dictgen::InsensitiveStr::Ascii("earbuility"),
        dictgen::InsensitiveStr::Ascii("erabil"),
        dictgen::InsensitiveStr::Ascii("erabile"),
        dictgen::InsensitiveStr::Ascii("erabilility"),
        dictgen::InsensitiveStr::Ascii("erabilites"),
        dictgen::InsensitiveStr::Ascii("erabiliti"),
        dictgen::InsensitiveStr::Ascii("erabilitie"),
        dictgen::InsensitiveStr::Ascii("erabilitis"),
        dictgen::InsensitiveStr::Ascii("erabilitiy"),
        dictgen::InsensitiveStr::Ascii("erabilitu"),
        dictgen::InsensitiveStr::Ascii("erabiliy"),
        dictgen::InsensitiveStr::Ascii("erabillities"),
        dictgen::InsensitiveStr::Ascii("erabillity"),
        dictgen::InsensitiveStr::Ascii("erabilties"),
        dictgen::InsensitiveStr::Ascii("erabiltiy"),
        dictgen::InsensitiveStr::Ascii("erabilty"),
        dictgen::InsensitiveStr::Ascii("erablility"),
        dictgen::InsensitiveStr::Ascii("erablities"),
        dictgen::InsensitiveStr::Ascii("erablity"),
        dictgen::InsensitiveStr::Ascii("erabuilility"),
        dictgen::InsensitiveStr::Ascii("erabuilites"),
        dictgen::InsensitiveStr::Ascii("erabuiliti"),
        dictgen::InsensitiveStr::Ascii("erabuilitie"),
        dictgen::InsensitiveStr::Ascii("erabuilities"),
        dictgen::InsensitiveStr::Ascii("erabuilitis"),
        dictgen::InsensitiveStr::Ascii("erabuilitiy"),
        dictgen::InsensitiveStr::Ascii("erabuility"),
        dictgen::InsensitiveStr::Ascii("erabuillities"),
        dictgen::InsensitiveStr::Ascii("erabuillity"),
        dictgen::InsensitiveStr::Ascii("erabuilties"),
        dictgen::InsensitiveStr::Ascii("erabuilty"),
        dictgen::InsensitiveStr::Ascii("erabule"),
        dictgen::InsensitiveStr::Ascii("erabulility"),
        dictgen::InsensitiveStr::Ascii("erarbilities"),
        dictgen::InsensitiveStr::Ascii("erarbility"),
        dictgen::InsensitiveStr::Ascii("erarble"),
        dictgen::InsensitiveStr::Ascii("erbilities"),
        dictgen::InsensitiveStr::Ascii("erbility"),
        dictgen::InsensitiveStr::Ascii("erbuilities"),
        dictgen::InsensitiveStr::Ascii("erbuility"),
        dictgen::InsensitiveStr::Ascii("urabilities"),
        dictgen::InsensitiveStr::Ascii("urability"),
        dictgen::InsensitiveStr::Ascii("urable"),
    ],
    values: &[
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerable"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerable"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerable"],
        &["vulnerable"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerable"],
        &["vulnerable"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerability"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerability"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerable"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerable"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerable"],
    ],
    range: 5..=13,
};

static WORD_VULE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VULE_CHILDREN),
    value: None,
};

pub static WORD_VULE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rabilities"),
        dictgen::InsensitiveStr::Ascii("rability"),
        dictgen::InsensitiveStr::Ascii("rable"),
        dictgen::InsensitiveStr::Ascii("rabuilities"),
        dictgen::InsensitiveStr::Ascii("rabuility"),
        dictgen::InsensitiveStr::Ascii("rabule"),
        dictgen::InsensitiveStr::Ascii("rnabilities"),
        dictgen::InsensitiveStr::Ascii("rnability"),
        dictgen::InsensitiveStr::Ascii("rnable"),
    ],
    values: &[
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerable"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerable"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerable"],
    ],
    range: 5..=11,
};

static WORD_VULB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VULB_CHILDREN),
    value: None,
};

pub static WORD_VULB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("earable"),
        dictgen::InsensitiveStr::Ascii("earabule"),
        dictgen::InsensitiveStr::Ascii("earbilities"),
        dictgen::InsensitiveStr::Ascii("earbility"),
        dictgen::InsensitiveStr::Ascii("earbuilities"),
        dictgen::InsensitiveStr::Ascii("earbuility"),
        dictgen::InsensitiveStr::Ascii("erabilility"),
        dictgen::InsensitiveStr::Ascii("erabilites"),
        dictgen::InsensitiveStr::Ascii("erabiliti"),
        dictgen::InsensitiveStr::Ascii("erabilitie"),
        dictgen::InsensitiveStr::Ascii("erabilitis"),
        dictgen::InsensitiveStr::Ascii("erabilitiy"),
        dictgen::InsensitiveStr::Ascii("erability"),
        dictgen::InsensitiveStr::Ascii("erabillities"),
        dictgen::InsensitiveStr::Ascii("erabillity"),
        dictgen::InsensitiveStr::Ascii("erabilties"),
        dictgen::InsensitiveStr::Ascii("erabilty"),
        dictgen::InsensitiveStr::Ascii("erablility"),
        dictgen::InsensitiveStr::Ascii("erabuilility"),
        dictgen::InsensitiveStr::Ascii("erabuilites"),
        dictgen::InsensitiveStr::Ascii("erabuiliti"),
        dictgen::InsensitiveStr::Ascii("erabuilitie"),
        dictgen::InsensitiveStr::Ascii("erabuilities"),
        dictgen::InsensitiveStr::Ascii("erabuilitis"),
        dictgen::InsensitiveStr::Ascii("erabuilitiy"),
        dictgen::InsensitiveStr::Ascii("erabuility"),
        dictgen::InsensitiveStr::Ascii("erabuillities"),
        dictgen::InsensitiveStr::Ascii("erabuillity"),
        dictgen::InsensitiveStr::Ascii("erabuilties"),
        dictgen::InsensitiveStr::Ascii("erabuilty"),
        dictgen::InsensitiveStr::Ascii("erabule"),
        dictgen::InsensitiveStr::Ascii("erabulility"),
        dictgen::InsensitiveStr::Ascii("erbilities"),
        dictgen::InsensitiveStr::Ascii("erbility"),
        dictgen::InsensitiveStr::Ascii("erbuilities"),
        dictgen::InsensitiveStr::Ascii("erbuility"),
    ],
    values: &[
        &["vulnerable"],
        &["vulnerable"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerability"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerable"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
        &["vulnerabilities"],
        &["vulnerability"],
    ],
    range: 7..=13,
};

static WORD_VULA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VULA_CHILDREN),
    value: None,
};

pub static WORD_VULA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cn"),
        dictgen::InsensitiveStr::Ascii("kn"),
    ],
    values: &[&["vulcan"], &["vulkan"]],
    range: 2..=2,
};

static WORD_VR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VR_CHILDREN),
    value: None,
};

pub static WORD_VR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eity"),
        dictgen::InsensitiveStr::Ascii("esion"),
        dictgen::InsensitiveStr::Ascii("ey"),
        dictgen::InsensitiveStr::Ascii("iable"),
        dictgen::InsensitiveStr::Ascii("iables"),
        dictgen::InsensitiveStr::Ascii("iament"),
        dictgen::InsensitiveStr::Ascii("iety"),
        dictgen::InsensitiveStr::Ascii("ifies"),
        dictgen::InsensitiveStr::Ascii("ify"),
        dictgen::InsensitiveStr::Ascii("iginity"),
        dictgen::InsensitiveStr::Ascii("igins"),
        dictgen::InsensitiveStr::Ascii("ilog"),
        dictgen::InsensitiveStr::Ascii("itual"),
        dictgen::InsensitiveStr::Ascii("itualenv"),
        dictgen::InsensitiveStr::Ascii("itualisation"),
        dictgen::InsensitiveStr::Ascii("itualise"),
        dictgen::InsensitiveStr::Ascii("itualization"),
        dictgen::InsensitiveStr::Ascii("itualize"),
        dictgen::InsensitiveStr::Ascii("ituoso"),
        dictgen::InsensitiveStr::Ascii("sion"),
        dictgen::InsensitiveStr::Ascii("sions"),
    ],
    values: &[
        &["variety"],
        &["version"],
        &["very"],
        &["variable"],
        &["variables"],
        &["vraiment"],
        &["variety"],
        &["verifies"],
        &["verify"],
        &["virginity"],
        &["virgins"],
        &["verilog"],
        &["virtual"],
        &["virtualenv"],
        &["virtualisation"],
        &["virtualise"],
        &["virtualization"],
        &["virtualize"],
        &["virtuoso"],
        &["version"],
        &["versions"],
    ],
    range: 2..=12,
};

static WORD_VO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VO_CHILDREN),
    value: None,
};

pub static WORD_VO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cabluary"),
        dictgen::InsensitiveStr::Ascii("cabularily"),
        dictgen::InsensitiveStr::Ascii("cabularity"),
        dictgen::InsensitiveStr::Ascii("cabularly"),
        dictgen::InsensitiveStr::Ascii("ciemail"),
        dictgen::InsensitiveStr::Ascii("icemal"),
        dictgen::InsensitiveStr::Ascii("ilates"),
        dictgen::InsensitiveStr::Ascii("ilating"),
        dictgen::InsensitiveStr::Ascii("ilation"),
        dictgen::InsensitiveStr::Ascii("ilently"),
        dictgen::InsensitiveStr::Ascii("latage"),
        dictgen::InsensitiveStr::Ascii("latages"),
        dictgen::InsensitiveStr::Ascii("latge"),
        dictgen::InsensitiveStr::Ascii("latges"),
        dictgen::InsensitiveStr::Ascii("latiliy"),
        dictgen::InsensitiveStr::Ascii("latillity"),
        dictgen::InsensitiveStr::Ascii("latiltiy"),
        dictgen::InsensitiveStr::Ascii("latily"),
        dictgen::InsensitiveStr::Ascii("lativity"),
        dictgen::InsensitiveStr::Ascii("lcando"),
        dictgen::InsensitiveStr::Ascii("lcanoe"),
        dictgen::InsensitiveStr::Ascii("lcaron"),
        dictgen::InsensitiveStr::Ascii("lenteer"),
        dictgen::InsensitiveStr::Ascii("lenteered"),
        dictgen::InsensitiveStr::Ascii("lenteers"),
        dictgen::InsensitiveStr::Ascii("leyball"),
        dictgen::InsensitiveStr::Ascii("litality"),
        dictgen::InsensitiveStr::Ascii("lleyboll"),
        dictgen::InsensitiveStr::Ascii("llyeball"),
        dictgen::InsensitiveStr::Ascii("lontary"),
        dictgen::InsensitiveStr::Ascii("lonteer"),
        dictgen::InsensitiveStr::Ascii("lonteered"),
        dictgen::InsensitiveStr::Ascii("lonteering"),
        dictgen::InsensitiveStr::Ascii("lonteers"),
        dictgen::InsensitiveStr::Ascii("lounteer"),
        dictgen::InsensitiveStr::Ascii("lounteered"),
        dictgen::InsensitiveStr::Ascii("lounteering"),
        dictgen::InsensitiveStr::Ascii("lounteers"),
        dictgen::InsensitiveStr::Ascii("lumne"),
        dictgen::InsensitiveStr::Ascii("lums"),
        dictgen::InsensitiveStr::Ascii("lunatrily"),
        dictgen::InsensitiveStr::Ascii("lunatry"),
        dictgen::InsensitiveStr::Ascii("luntairly"),
        dictgen::InsensitiveStr::Ascii("luntairy"),
        dictgen::InsensitiveStr::Ascii("luntarilly"),
        dictgen::InsensitiveStr::Ascii("luntarly"),
        dictgen::InsensitiveStr::Ascii("luntears"),
        dictgen::InsensitiveStr::Ascii("lunteed"),
        dictgen::InsensitiveStr::Ascii("lunteeer"),
        dictgen::InsensitiveStr::Ascii("lunteeers"),
        dictgen::InsensitiveStr::Ascii("lunteerd"),
        dictgen::InsensitiveStr::Ascii("lunteraly"),
        dictgen::InsensitiveStr::Ascii("luntered"),
        dictgen::InsensitiveStr::Ascii("luntereed"),
        dictgen::InsensitiveStr::Ascii("lunterily"),
        dictgen::InsensitiveStr::Ascii("lunterring"),
        dictgen::InsensitiveStr::Ascii("nfig"),
        dictgen::InsensitiveStr::Ascii("tlage"),
        dictgen::InsensitiveStr::Ascii("uld"),
        dictgen::InsensitiveStr::Ascii("xes"),
    ],
    values: &[
        &["vocabulary"],
        &["vocabulary"],
        &["vocabulary"],
        &["vocabulary"],
        &["voicemail"],
        &["voicemail"],
        &["violates"],
        &["violating"],
        &["violation"],
        &["violently"],
        &["voltage"],
        &["voltages"],
        &["voltage"],
        &["voltages"],
        &["volatility"],
        &["volatility"],
        &["volatility"],
        &["volatility"],
        &["volatility"],
        &["volcano"],
        &["volcano"],
        &["volcano"],
        &["volunteer"],
        &["volunteered"],
        &["volunteers"],
        &["volleyball"],
        &["volatility"],
        &["volleyball"],
        &["volleyball"],
        &["voluntary"],
        &["volunteer"],
        &["volunteered"],
        &["volunteering"],
        &["volunteers"],
        &["volunteer"],
        &["volunteered"],
        &["volunteering"],
        &["volunteers"],
        &["volume"],
        &["volume"],
        &["voluntarily"],
        &["voluntary"],
        &["voluntarily"],
        &["voluntarily"],
        &["voluntarily"],
        &["voluntary"],
        &["volunteers"],
        &["volunteered"],
        &["volunteers"],
        &["volunteers"],
        &["volunteered"],
        &["voluntarily"],
        &["volunteered"],
        &["volunteered"],
        &["voluntarily"],
        &["volunteering"],
        &["config"],
        &["voltage"],
        &["would"],
        &["voxels", "voxel"],
    ],
    range: 3..=11,
};

static WORD_VL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VL_CHILDREN),
    value: None,
};

pub static WORD_VL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arge"),
        dictgen::InsensitiveStr::Ascii("aue"),
        dictgen::InsensitiveStr::Ascii("aues"),
        dictgen::InsensitiveStr::Ascii("one"),
        dictgen::InsensitiveStr::Ascii("oned"),
        dictgen::InsensitiveStr::Ascii("ones"),
        dictgen::InsensitiveStr::Ascii("ues"),
    ],
    values: &[
        &["large"],
        &["value"],
        &["values"],
        &["clone"],
        &["cloned"],
        &["clones"],
        &["values"],
    ],
    range: 3..=4,
};

static WORD_VI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_VI_CHILDREN),
    value: None,
};

static WORD_VI_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_VIA_NODE),
    Some(&WORD_VIB_NODE),
    Some(&WORD_VIC_NODE),
    Some(&WORD_VID_NODE),
    Some(&WORD_VIE_NODE),
    None,
    Some(&WORD_VIG_NODE),
    None,
    None,
    None,
    Some(&WORD_VIK_NODE),
    Some(&WORD_VIL_NODE),
    None,
    Some(&WORD_VIN_NODE),
    Some(&WORD_VIO_NODE),
    None,
    None,
    Some(&WORD_VIR_NODE),
    Some(&WORD_VIS_NODE),
    Some(&WORD_VIT_NODE),
    Some(&WORD_VIU_NODE),
    None,
    Some(&WORD_VIW_NODE),
    None,
    None,
    Some(&WORD_VIZ_NODE),
];

static WORD_VIZ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VIZ_CHILDREN),
    value: None,
};

pub static WORD_VIZ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ualisation"),
        dictgen::InsensitiveStr::Ascii("ualisations"),
        dictgen::InsensitiveStr::Ascii("ualise"),
        dictgen::InsensitiveStr::Ascii("ualised"),
        dictgen::InsensitiveStr::Ascii("ualization"),
        dictgen::InsensitiveStr::Ascii("ualize"),
        dictgen::InsensitiveStr::Ascii("ualized"),
    ],
    values: &[
        &["visualisation"],
        &["visualisation"],
        &["visualise"],
        &["visualised"],
        &["visualization"],
        &["visualize"],
        &["visualized"],
    ],
    range: 6..=11,
};

static WORD_VIW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VIW_CHILDREN),
    value: None,
};

pub static WORD_VIW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("ers"),
    ],
    values: &[&["viewer"], &["viewers"]],
    range: 2..=3,
};

static WORD_VIU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VIU_CHILDREN),
    value: None,
};

pub static WORD_VIU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("sally"),
        dictgen::InsensitiveStr::Ascii("sualisation"),
    ],
    values: &[&["visually"], &["visualisation"]],
    range: 5..=11,
};

static WORD_VIT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VIT_CHILDREN),
    value: None,
};

pub static WORD_VIT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ailty"),
        dictgen::InsensitiveStr::Ascii("aliy"),
        dictgen::InsensitiveStr::Ascii("aminas"),
        dictgen::InsensitiveStr::Ascii("amines"),
        dictgen::InsensitiveStr::Ascii("amis"),
        dictgen::InsensitiveStr::Ascii("enam"),
        dictgen::InsensitiveStr::Ascii("enamese"),
        dictgen::InsensitiveStr::Ascii("imans"),
        dictgen::InsensitiveStr::Ascii("irol"),
        dictgen::InsensitiveStr::Ascii("main"),
        dictgen::InsensitiveStr::Ascii("mains"),
        dictgen::InsensitiveStr::Ascii("ories"),
        dictgen::InsensitiveStr::Ascii("roil"),
        dictgen::InsensitiveStr::Ascii("rual"),
        dictgen::InsensitiveStr::Ascii("rually"),
        dictgen::InsensitiveStr::Ascii("rues"),
        dictgen::InsensitiveStr::Ascii("ual"),
        dictgen::InsensitiveStr::Ascii("ualization"),
    ],
    values: &[
        &["vitality"],
        &["vitality"],
        &["vitamins"],
        &["vitamins"],
        &["vitamins"],
        &["vietnam"],
        &["vietnamese"],
        &["vitamins"],
        &["vitriol"],
        &["vitamin"],
        &["vitamins"],
        &["victories"],
        &["vitriol"],
        &["virtual"],
        &["virtually"],
        &["virtues"],
        &["virtual"],
        &["visualization"],
    ],
    range: 3..=10,
};

static WORD_VIS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_VIS_CHILDREN),
    value: None,
};

static WORD_VIS_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_VISA_NODE),
    Some(&WORD_VISB_NODE),
    Some(&WORD_VISC_NODE),
    None,
    Some(&WORD_VISE_NODE),
    None,
    None,
    None,
    Some(&WORD_VISI_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_VISS_NODE),
    Some(&WORD_VIST_NODE),
    Some(&WORD_VISU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static WORD_VISU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VISU_CHILDREN),
    value: None,
};

pub static WORD_VISU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ab"),
        dictgen::InsensitiveStr::Ascii("abisation"),
        dictgen::InsensitiveStr::Ascii("abise"),
        dictgen::InsensitiveStr::Ascii("abised"),
        dictgen::InsensitiveStr::Ascii("abises"),
        dictgen::InsensitiveStr::Ascii("abization"),
        dictgen::InsensitiveStr::Ascii("abize"),
        dictgen::InsensitiveStr::Ascii("abized"),
        dictgen::InsensitiveStr::Ascii("abizes"),
        dictgen::InsensitiveStr::Ascii("able"),
        dictgen::InsensitiveStr::Ascii("ables"),
        dictgen::InsensitiveStr::Ascii("ably"),
        dictgen::InsensitiveStr::Ascii("abs"),
        dictgen::InsensitiveStr::Ascii("aisation"),
        dictgen::InsensitiveStr::Ascii("aise"),
        dictgen::InsensitiveStr::Ascii("aised"),
        dictgen::InsensitiveStr::Ascii("aises"),
        dictgen::InsensitiveStr::Ascii("aization"),
        dictgen::InsensitiveStr::Ascii("aize"),
        dictgen::InsensitiveStr::Ascii("aized"),
        dictgen::InsensitiveStr::Ascii("aizes"),
        dictgen::InsensitiveStr::Ascii("ale"),
        dictgen::InsensitiveStr::Ascii("ales"),
        dictgen::InsensitiveStr::Ascii("alizacion"),
        dictgen::InsensitiveStr::Ascii("alizaiton"),
        dictgen::InsensitiveStr::Ascii("alizating"),
        dictgen::InsensitiveStr::Ascii("alizaton"),
        dictgen::InsensitiveStr::Ascii("allisation"),
        dictgen::InsensitiveStr::Ascii("allization"),
        dictgen::InsensitiveStr::Ascii("aly"),
        dictgen::InsensitiveStr::Ascii("alyse"),
    ],
    values: &[
        &["visual"],
        &["visualisation"],
        &["visualise"],
        &["visualised"],
        &["visualises"],
        &["visualization"],
        &["visualize"],
        &["visualized"],
        &["visualizes"],
        &["visual", "visible"],
        &["visuals"],
        &["visually"],
        &["visuals"],
        &["visualisation"],
        &["visualise"],
        &["visualised"],
        &["visualises"],
        &["visualization"],
        &["visualize"],
        &["visualized"],
        &["visualizes"],
        &["visual"],
        &["visuals"],
        &["visualization"],
        &["visualization"],
        &["visualization"],
        &["visualization"],
        &["visualisation"],
        &["visualization"],
        &["visually"],
        &["visualise", "visualise"],
    ],
    range: 2..=10,
};

static WORD_VIST_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VIST_CHILDREN),
    value: None,
};

pub static WORD_VIST_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("ing"),
        dictgen::InsensitiveStr::Ascii("ors"),
    ],
    values: &[&["visited"], &["visiting"], &["visitors"]],
    range: 2..=3,
};

static WORD_VISS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VISS_CHILDREN),
    value: None,
};

pub static WORD_VISS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ible")],
    values: &[&["visible"]],
    range: 4..=4,
};

static WORD_VISI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VISI_CHILDREN),
    value: None,
};

pub static WORD_VISI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("able"),
        dictgen::InsensitiveStr::Ascii("ably"),
        dictgen::InsensitiveStr::Ascii("bale"),
        dictgen::InsensitiveStr::Ascii("bile"),
        dictgen::InsensitiveStr::Ascii("biliy"),
        dictgen::InsensitiveStr::Ascii("billity"),
        dictgen::InsensitiveStr::Ascii("biltiy"),
        dictgen::InsensitiveStr::Ascii("bilty"),
        dictgen::InsensitiveStr::Ascii("bily"),
        dictgen::InsensitiveStr::Ascii("bleable"),
        dictgen::InsensitiveStr::Ascii("bles"),
        dictgen::InsensitiveStr::Ascii("bley"),
        dictgen::InsensitiveStr::Ascii("blities"),
        dictgen::InsensitiveStr::Ascii("blity"),
        dictgen::InsensitiveStr::Ascii("blle"),
        dictgen::InsensitiveStr::Ascii("blly"),
        dictgen::InsensitiveStr::Ascii("nble"),
        dictgen::InsensitiveStr::Ascii("ous"),
        dictgen::InsensitiveStr::Ascii("sble"),
        dictgen::InsensitiveStr::Ascii("ter"),
        dictgen::InsensitiveStr::Ascii("ters"),
        dictgen::InsensitiveStr::Ascii("tng"),
        dictgen::InsensitiveStr::Ascii("vble"),
    ],
    values: &[
        &["visible"],
        &["visibly"],
        &["visible"],
        &["visible"],
        &["visibility"],
        &["visibility"],
        &["visibility"],
        &["visibility"],
        &["visibility"],
        &["visible"],
        &["visible"],
        &["visibly"],
        &["visibilities"],
        &["visibility"],
        &["visible"],
        &["visibly"],
        &["visible"],
        &["vicious"],
        &["visible"],
        &["visitor"],
        &["visitors"],
        &["visiting"],
        &["visible"],
    ],
    range: 3..=7,
};

static WORD_VISE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VISE_CHILDREN),
    value: None,
};

pub static WORD_VISE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("rcal")],
    values: &[&["visceral"]],
    range: 4..=4,
};

static WORD_VISC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VISC_CHILDREN),
    value: None,
};

pub static WORD_VISC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("real")],
    values: &[&["visceral"]],
    range: 4..=4,
};

static WORD_VISB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VISB_CHILDREN),
    value: None,
};

pub static WORD_VISB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ily"),
        dictgen::InsensitiveStr::Ascii("le"),
        dictgen::InsensitiveStr::Ascii("lie"),
        dictgen::InsensitiveStr::Ascii("ly"),
    ],
    values: &[&["visibly"], &["visible"], &["visible"], &["visibly"]],
    range: 2..=3,
};

static WORD_VISA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VISA_CHILDREN),
    value: None,
};

pub static WORD_VISA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bility"),
        dictgen::InsensitiveStr::Ascii("ble"),
        dictgen::InsensitiveStr::Ascii("bly"),
    ],
    values: &[&["visibility"], &["visible"], &["visibly"]],
    range: 3..=6,
};

static WORD_VIR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VIR_CHILDREN),
    value: None,
};

pub static WORD_VIR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ament"),
        dictgen::InsensitiveStr::Ascii("bate"),
        dictgen::InsensitiveStr::Ascii("bation"),
        dictgen::InsensitiveStr::Ascii("bator"),
        dictgen::InsensitiveStr::Ascii("ginas"),
        dictgen::InsensitiveStr::Ascii("gines"),
        dictgen::InsensitiveStr::Ascii("gings"),
        dictgen::InsensitiveStr::Ascii("ginis"),
        dictgen::InsensitiveStr::Ascii("gintiy"),
        dictgen::InsensitiveStr::Ascii("ginus"),
        dictgen::InsensitiveStr::Ascii("ignity"),
        dictgen::InsensitiveStr::Ascii("igns"),
        dictgen::InsensitiveStr::Ascii("tal"),
        dictgen::InsensitiveStr::Ascii("taul"),
        dictgen::InsensitiveStr::Ascii("tical"),
        dictgen::InsensitiveStr::Ascii("tiol"),
        dictgen::InsensitiveStr::Ascii("tiual"),
        dictgen::InsensitiveStr::Ascii("tualisaion"),
        dictgen::InsensitiveStr::Ascii("tualisaiton"),
        dictgen::InsensitiveStr::Ascii("tualizaion"),
        dictgen::InsensitiveStr::Ascii("tualizaiton"),
        dictgen::InsensitiveStr::Ascii("tualiziation"),
        dictgen::InsensitiveStr::Ascii("tualy"),
        dictgen::InsensitiveStr::Ascii("tuell"),
        dictgen::InsensitiveStr::Ascii("tuels"),
        dictgen::InsensitiveStr::Ascii("tuose"),
        dictgen::InsensitiveStr::Ascii("tural"),
        dictgen::InsensitiveStr::Ascii("ture"),
        dictgen::InsensitiveStr::Ascii("ual"),
        dictgen::InsensitiveStr::Ascii("ualization"),
        dictgen::InsensitiveStr::Ascii("utal"),
        dictgen::InsensitiveStr::Ascii("utalenv"),
        dictgen::InsensitiveStr::Ascii("utalisation"),
        dictgen::InsensitiveStr::Ascii("utalise"),
        dictgen::InsensitiveStr::Ascii("utalised"),
        dictgen::InsensitiveStr::Ascii("utalization"),
        dictgen::InsensitiveStr::Ascii("utalize"),
        dictgen::InsensitiveStr::Ascii("utalized"),
        dictgen::InsensitiveStr::Ascii("utally"),
        dictgen::InsensitiveStr::Ascii("utals"),
        dictgen::InsensitiveStr::Ascii("utes"),
    ],
    values: &[
        &["vraiment"],
        &["vibrate"],
        &["vibration"],
        &["vibrator"],
        &["virgins"],
        &["virgins"],
        &["virgins"],
        &["virgins"],
        &["virginity"],
        &["virgins"],
        &["virginity"],
        &["virgins"],
        &["virtual"],
        &["virtual"],
        &["vertical"],
        &["vitriol"],
        &["virtual"],
        &["virtualisation"],
        &["virtualisation"],
        &["virtualization"],
        &["virtualization"],
        &["virtualization"],
        &["virtually"],
        &["virtual"],
        &["virtues"],
        &["virtues"],
        &["virtual"],
        &["virtue"],
        &["virtual", "viral"],
        &["visualization"],
        &["virtual"],
        &["virtualenv"],
        &["virtualisation"],
        &["virtualise"],
        &["virtualised"],
        &["virtualization"],
        &["virtualize"],
        &["virtualized"],
        &["virtually"],
        &["virtuals"],
        &["virtues"],
    ],
    range: 3..=12,
};

static WORD_VIO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VIO_CHILDREN),
    value: None,
};

pub static WORD_VIO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alte"),
        dictgen::InsensitiveStr::Ascii("alting"),
        dictgen::InsensitiveStr::Ascii("altion"),
        dictgen::InsensitiveStr::Ascii("latin"),
        dictgen::InsensitiveStr::Ascii("lentce"),
        dictgen::InsensitiveStr::Ascii("lenty"),
        dictgen::InsensitiveStr::Ascii("letas"),
        dictgen::InsensitiveStr::Ascii("loated"),
        dictgen::InsensitiveStr::Ascii("loating"),
        dictgen::InsensitiveStr::Ascii("loation"),
        dictgen::InsensitiveStr::Ascii("loations"),
    ],
    values: &[
        &["violate"],
        &["violating"],
        &["violation"],
        &["violation"],
        &["violence"],
        &["violently"],
        &["violates"],
        &["violated"],
        &["violating"],
        &["violation"],
        &["violations"],
    ],
    range: 4..=8,
};

static WORD_VIN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VIN_CHILDREN),
    value: None,
};

pub static WORD_VIN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cinity"),
        dictgen::InsensitiveStr::Ascii("dicitve"),
        dictgen::InsensitiveStr::Ascii("dictave"),
        dictgen::InsensitiveStr::Ascii("dicte"),
        dictgen::InsensitiveStr::Ascii("icity"),
        dictgen::InsensitiveStr::Ascii("rator"),
    ],
    values: &[
        &["vicinity"],
        &["vindictive"],
        &["vindictive"],
        &["vindictive"],
        &["vicinity"],
        &["vibrator"],
    ],
    range: 5..=7,
};

static WORD_VIL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VIL_CHILDREN),
    value: None,
};

pub static WORD_VIL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("igant"),
        dictgen::InsensitiveStr::Ascii("igante"),
        dictgen::InsensitiveStr::Ascii("l"),
        dictgen::InsensitiveStr::Ascii("lageois"),
        dictgen::InsensitiveStr::Ascii("legas"),
        dictgen::InsensitiveStr::Ascii("lian"),
        dictgen::InsensitiveStr::Ascii("lification"),
        dictgen::InsensitiveStr::Ascii("lify"),
        dictgen::InsensitiveStr::Ascii("lin"),
        dictgen::InsensitiveStr::Ascii("oently"),
    ],
    values: &[
        &["vigilant"],
        &["vigilante"],
        &["will"],
        &["villages"],
        &["villages"],
        &["villain"],
        &["vilification"],
        &["vilify"],
        &["villain", "villi", "villein"],
        &["violently"],
    ],
    range: 1..=10,
};

static WORD_VIK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VIK_CHILDREN),
    value: None,
};

pub static WORD_VIK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("igns"),
        dictgen::InsensitiveStr::Ascii("ingos"),
    ],
    values: &[&["vikings"], &["vikings"]],
    range: 4..=5,
};

static WORD_VIG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VIG_CHILDREN),
    value: None,
};

pub static WORD_VIG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eur"),
        dictgen::InsensitiveStr::Ascii("ilane"),
        dictgen::InsensitiveStr::Ascii("ilantie"),
        dictgen::InsensitiveStr::Ascii("ilanties"),
        dictgen::InsensitiveStr::Ascii("ilence"),
        dictgen::InsensitiveStr::Ascii("liant"),
        dictgen::InsensitiveStr::Ascii("liante"),
        dictgen::InsensitiveStr::Ascii("oruosly"),
        dictgen::InsensitiveStr::Ascii("ourosly"),
        dictgen::InsensitiveStr::Ascii("ourous"),
        dictgen::InsensitiveStr::Ascii("rins"),
    ],
    values: &[
        &["vigueur", "vigour", "vigour"],
        &["vigilante"],
        &["vigilante"],
        &["vigilante"],
        &["vigilance"],
        &["vigilant"],
        &["vigilante"],
        &["vigorously"],
        &["vigorously"],
        &["vigorous"],
        &["virgins"],
    ],
    range: 3..=8,
};

static WORD_VIE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VIE_CHILDREN),
    value: None,
};

pub static WORD_VIE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ntam"),
        dictgen::InsensitiveStr::Ascii("ntamese"),
        dictgen::InsensitiveStr::Ascii("port"),
        dictgen::InsensitiveStr::Ascii("ports"),
        dictgen::InsensitiveStr::Ascii("tmanese"),
        dictgen::InsensitiveStr::Ascii("tnamees"),
        dictgen::InsensitiveStr::Ascii("tnameese"),
        dictgen::InsensitiveStr::Ascii("tnamesea"),
        dictgen::InsensitiveStr::Ascii("tnamesse"),
        dictgen::InsensitiveStr::Ascii("tnamiese"),
        dictgen::InsensitiveStr::Ascii("tnamnese"),
        dictgen::InsensitiveStr::Ascii("weres"),
        dictgen::InsensitiveStr::Ascii("wpiont"),
        dictgen::InsensitiveStr::Ascii("wpionts"),
        dictgen::InsensitiveStr::Ascii("wpoert"),
        dictgen::InsensitiveStr::Ascii("wpoit"),
        dictgen::InsensitiveStr::Ascii("wtransfromation"),
    ],
    values: &[
        &["vietnam"],
        &["vietnamese"],
        &["viewport"],
        &["viewports"],
        &["vietnamese"],
        &["vietnamese"],
        &["vietnamese"],
        &["vietnamese"],
        &["vietnamese"],
        &["vietnamese"],
        &["vietnamese"],
        &["viewers"],
        &["viewpoint"],
        &["viewpoints"],
        &["viewport"],
        &["viewpoints"],
        &["viewtransformation"],
    ],
    range: 4..=15,
};

static WORD_VID_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VID_CHILDREN),
    value: None,
};

pub static WORD_VID_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eogaem"),
        dictgen::InsensitiveStr::Ascii("eogaems"),
        dictgen::InsensitiveStr::Ascii("eogamemes"),
        dictgen::InsensitiveStr::Ascii("eogams"),
        dictgen::InsensitiveStr::Ascii("eojames"),
        dictgen::InsensitiveStr::Ascii("eostreamming"),
        dictgen::InsensitiveStr::Ascii("oegame"),
        dictgen::InsensitiveStr::Ascii("oegames"),
    ],
    values: &[
        &["videogame"],
        &["videogames"],
        &["videogames"],
        &["videogames"],
        &["videogames"],
        &["videostreaming"],
        &["videogame"],
        &["videogames"],
    ],
    range: 6..=12,
};

static WORD_VIC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VIC_CHILDREN),
    value: None,
};

pub static WORD_VIC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("intiy"),
        dictgen::InsensitiveStr::Ascii("itmized"),
        dictgen::InsensitiveStr::Ascii("itms"),
        dictgen::InsensitiveStr::Ascii("otrian"),
        dictgen::InsensitiveStr::Ascii("otries"),
        dictgen::InsensitiveStr::Ascii("otrious"),
        dictgen::InsensitiveStr::Ascii("seral"),
        dictgen::InsensitiveStr::Ascii("temized"),
        dictgen::InsensitiveStr::Ascii("timas"),
        dictgen::InsensitiveStr::Ascii("times"),
        dictgen::InsensitiveStr::Ascii("toires"),
        dictgen::InsensitiveStr::Ascii("tomized"),
        dictgen::InsensitiveStr::Ascii("torain"),
        dictgen::InsensitiveStr::Ascii("torieuse"),
        dictgen::InsensitiveStr::Ascii("torin"),
        dictgen::InsensitiveStr::Ascii("torina"),
        dictgen::InsensitiveStr::Ascii("torinos"),
        dictgen::InsensitiveStr::Ascii("torinus"),
        dictgen::InsensitiveStr::Ascii("torios"),
        dictgen::InsensitiveStr::Ascii("toriosa"),
        dictgen::InsensitiveStr::Ascii("torioso"),
        dictgen::InsensitiveStr::Ascii("toris"),
        dictgen::InsensitiveStr::Ascii("toriuos"),
        dictgen::InsensitiveStr::Ascii("toriuous"),
        dictgen::InsensitiveStr::Ascii("tumized"),
    ],
    values: &[
        &["vicinity"],
        &["victimized"],
        &["victims"],
        &["victorian"],
        &["victories"],
        &["victorious"],
        &["visceral"],
        &["victimized"],
        &["victims"],
        &["victims"],
        &["victories"],
        &["victimized"],
        &["victorian"],
        &["victories"],
        &["victorian"],
        &["victorian"],
        &["victorious"],
        &["victorious"],
        &["victorious"],
        &["victorious"],
        &["victorious"],
        &["victories"],
        &["victorious"],
        &["victorious"],
        &["victimized"],
    ],
    range: 4..=8,
};

static WORD_VIB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VIB_CHILDREN),
    value: None,
};

pub static WORD_VIB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ratie"),
        dictgen::InsensitiveStr::Ascii("ratin"),
        dictgen::InsensitiveStr::Ascii("ratoare"),
        dictgen::InsensitiveStr::Ascii("ratr"),
    ],
    values: &[&["vibrate"], &["vibration"], &["vibrator"], &["vibrator"]],
    range: 4..=7,
};

static WORD_VIA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VIA_CHILDREN),
    value: None,
};

pub static WORD_VIA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("biliy"),
        dictgen::InsensitiveStr::Ascii("tmin"),
        dictgen::InsensitiveStr::Ascii("tmins"),
        dictgen::InsensitiveStr::Ascii("tnamese"),
    ],
    values: &[&["viability"], &["vitamin"], &["vitamins"], &["vietnamese"]],
    range: 4..=7,
};

static WORD_VH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VH_CHILDREN),
    value: None,
};

pub static WORD_VH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ild")],
    values: &[&["child"]],
    range: 3..=3,
};

static WORD_VE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_VE_CHILDREN),
    value: None,
};

static WORD_VE_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    Some(&WORD_VEB_NODE),
    Some(&WORD_VEC_NODE),
    Some(&WORD_VED_NODE),
    None,
    Some(&WORD_VEF_NODE),
    Some(&WORD_VEG_NODE),
    Some(&WORD_VEH_NODE),
    Some(&WORD_VEI_NODE),
    None,
    Some(&WORD_VEK_NODE),
    Some(&WORD_VEL_NODE),
    None,
    Some(&WORD_VEN_NODE),
    None,
    None,
    None,
    Some(&WORD_VER_NODE),
    Some(&WORD_VES_NODE),
    Some(&WORD_VET_NODE),
    None,
    None,
    Some(&WORD_VEW_NODE),
    None,
    Some(&WORD_VEY_NODE),
    None,
];

static WORD_VEY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VEY_CHILDREN),
    value: None,
};

pub static WORD_VEY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("r")],
    values: &[&["very"]],
    range: 1..=1,
};

static WORD_VEW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VEW_CHILDREN),
    value: Some(&["view"]),
};

pub static WORD_VEW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("iership")],
    values: &[&["viewership"]],
    range: 7..=7,
};

static WORD_VET_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VET_CHILDREN),
    value: None,
};

pub static WORD_VET_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ex"),
        dictgen::InsensitiveStr::Ascii("exes"),
        dictgen::InsensitiveStr::Ascii("ween"),
    ],
    values: &[&["vertex"], &["vertices"], &["between"]],
    range: 2..=4,
};

static WORD_VES_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VES_CHILDREN),
    value: None,
};

pub static WORD_VES_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ion"),
        dictgen::InsensitiveStr::Ascii("ions"),
        dictgen::InsensitiveStr::Ascii("seles"),
        dictgen::InsensitiveStr::Ascii("sells"),
        dictgen::InsensitiveStr::Ascii("sles"),
    ],
    values: &[
        &["version"],
        &["versions"],
        &["vessels"],
        &["vessels"],
        &["vessels"],
    ],
    range: 3..=5,
};

static WORD_VER_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_VER_CHILDREN),
    value: None,
};

static WORD_VER_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_VERA_NODE),
    Some(&WORD_VERB_NODE),
    None,
    None,
    Some(&WORD_VERE_NODE),
    Some(&WORD_VERF_NODE),
    None,
    None,
    Some(&WORD_VERI_NODE),
    None,
    None,
    Some(&WORD_VERL_NODE),
    None,
    Some(&WORD_VERN_NODE),
    None,
    None,
    None,
    Some(&WORD_VERR_NODE),
    Some(&WORD_VERS_NODE),
    Some(&WORD_VERT_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_VERY_NODE),
    None,
];

static WORD_VERY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VERY_CHILDREN),
    value: None,
};

pub static WORD_VERY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("fieng"),
        dictgen::InsensitiveStr::Ascii("fy"),
        dictgen::InsensitiveStr::Ascii("ified"),
        dictgen::InsensitiveStr::Ascii("ifies"),
        dictgen::InsensitiveStr::Ascii("ifing"),
        dictgen::InsensitiveStr::Ascii("ify"),
        dictgen::InsensitiveStr::Ascii("ifying"),
    ],
    values: &[
        &["verifying"],
        &["verify"],
        &["verified"],
        &["verifies"],
        &["verifying"],
        &["verify"],
        &["verifying"],
    ],
    range: 2..=6,
};

static WORD_VERT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VERT_CHILDREN),
    value: None,
};

pub static WORD_VERT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("abim"),
        dictgen::InsensitiveStr::Ascii("extes"),
        dictgen::InsensitiveStr::Ascii("exts"),
        dictgen::InsensitiveStr::Ascii("gio"),
        dictgen::InsensitiveStr::Ascii("ial"),
        dictgen::InsensitiveStr::Ascii("icall"),
        dictgen::InsensitiveStr::Ascii("icallity"),
        dictgen::InsensitiveStr::Ascii("icaly"),
        dictgen::InsensitiveStr::Ascii("icies"),
        dictgen::InsensitiveStr::Ascii("icle"),
        dictgen::InsensitiveStr::Ascii("iclealign"),
        dictgen::InsensitiveStr::Ascii("iece"),
        dictgen::InsensitiveStr::Ascii("ieces"),
        dictgen::InsensitiveStr::Ascii("ifiable"),
        dictgen::InsensitiveStr::Ascii("ification"),
        dictgen::InsensitiveStr::Ascii("ifications"),
        dictgen::InsensitiveStr::Ascii("ify"),
        dictgen::InsensitiveStr::Ascii("igro"),
        dictgen::InsensitiveStr::Ascii("ikal"),
        dictgen::InsensitiveStr::Ascii("ix"),
        dictgen::InsensitiveStr::Ascii("ixes"),
        dictgen::InsensitiveStr::Ascii("ixs"),
    ],
    values: &[
        &["verbatim"],
        &["vertices"],
        &["vertices"],
        &["vertigo"],
        &["vertical"],
        &["vertical"],
        &["vertically"],
        &["vertically"],
        &["vertices"],
        &["vertical"],
        &["verticalalign"],
        &["vertex"],
        &["vertices"],
        &["verifiable"],
        &["certification", "verification"],
        &["verifications"],
        &["verify"],
        &["vertigo"],
        &["vertical"],
        &["vertex"],
        &["vertices"],
        &["vertices"],
    ],
    range: 2..=10,
};

static WORD_VERS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VERS_CHILDREN),
    value: None,
};

pub static WORD_VERS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alite"),
        dictgen::InsensitiveStr::Ascii("atality"),
        dictgen::InsensitiveStr::Ascii("atel"),
        dictgen::InsensitiveStr::Ascii("atiliy"),
        dictgen::InsensitiveStr::Ascii("atille"),
        dictgen::InsensitiveStr::Ascii("atillity"),
        dictgen::InsensitiveStr::Ascii("atilty"),
        dictgen::InsensitiveStr::Ascii("atily"),
        dictgen::InsensitiveStr::Ascii("hin"),
        dictgen::InsensitiveStr::Ascii("in"),
        dictgen::InsensitiveStr::Ascii("io"),
        dictgen::InsensitiveStr::Ascii("iob"),
        dictgen::InsensitiveStr::Ascii("ioed"),
        dictgen::InsensitiveStr::Ascii("ioing"),
        dictgen::InsensitiveStr::Ascii("iom"),
        dictgen::InsensitiveStr::Ascii("ionaddded"),
        dictgen::InsensitiveStr::Ascii("iones"),
        dictgen::InsensitiveStr::Ascii("ionm"),
        dictgen::InsensitiveStr::Ascii("ionms"),
        dictgen::InsensitiveStr::Ascii("ionned"),
        dictgen::InsensitiveStr::Ascii("ionning"),
        dictgen::InsensitiveStr::Ascii("ios"),
        dictgen::InsensitiveStr::Ascii("itale"),
        dictgen::InsensitiveStr::Ascii("itality"),
        dictgen::InsensitiveStr::Ascii("itilaty"),
        dictgen::InsensitiveStr::Ascii("itlity"),
        dictgen::InsensitiveStr::Ascii("oin"),
        dictgen::InsensitiveStr::Ascii("on"),
        dictgen::InsensitiveStr::Ascii("oned"),
        dictgen::InsensitiveStr::Ascii("ons"),
        dictgen::InsensitiveStr::Ascii("taile"),
    ],
    values: &[
        &["versatile"],
        &["versatility"],
        &["versatile"],
        &["versatility"],
        &["versatile"],
        &["versatility"],
        &["versatility"],
        &["versatility"],
        &["version"],
        &["version"],
        &["version"],
        &["version"],
        &["versioned"],
        &["versioning"],
        &["version"],
        &["versionadded"],
        &["versions"],
        &["version"],
        &["versions"],
        &["versioned"],
        &["versioning"],
        &["versions"],
        &["versatile"],
        &["versatility"],
        &["versatility"],
        &["versatility"],
        &["version"],
        &["version"],
        &["versioned"],
        &["versions"],
        &["versatile"],
    ],
    range: 2..=9,
};

static WORD_VERR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VERR_CHILDREN),
    value: None,
};

pub static WORD_VERR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ical"),
        dictgen::InsensitiveStr::Ascii("y"),
    ],
    values: &[&["vertical"], &["very"]],
    range: 1..=4,
};

static WORD_VERN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VERN_CHILDREN),
    value: None,
};

pub static WORD_VERN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aculaire"),
        dictgen::InsensitiveStr::Ascii("dor"),
        dictgen::InsensitiveStr::Ascii("ecular"),
        dictgen::InsensitiveStr::Ascii("icular"),
    ],
    values: &[
        &["vernacular"],
        &["vendor"],
        &["vernacular"],
        &["vernacular"],
    ],
    range: 3..=8,
};

static WORD_VERL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VERL_CHILDREN),
    value: None,
};

pub static WORD_VERL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("y")],
    values: &[&["very"]],
    range: 1..=1,
};

static WORD_VERI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VERI_CHILDREN),
    value: None,
};

pub static WORD_VERI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cal"),
        dictgen::InsensitiveStr::Ascii("fi"),
        dictgen::InsensitiveStr::Ascii("fiaction"),
        dictgen::InsensitiveStr::Ascii("ficacion"),
        dictgen::InsensitiveStr::Ascii("ficaiton"),
        dictgen::InsensitiveStr::Ascii("ficato"),
        dictgen::InsensitiveStr::Ascii("fie"),
        dictgen::InsensitiveStr::Ascii("fikation"),
        dictgen::InsensitiveStr::Ascii("fing"),
        dictgen::InsensitiveStr::Ascii("fiyng"),
        dictgen::InsensitiveStr::Ascii("fty"),
        dictgen::InsensitiveStr::Ascii("ftying"),
        dictgen::InsensitiveStr::Ascii("fyable"),
        dictgen::InsensitiveStr::Ascii("fyied"),
        dictgen::InsensitiveStr::Ascii("on"),
        dictgen::InsensitiveStr::Ascii("ons"),
        dictgen::InsensitiveStr::Ascii("osn"),
        dictgen::InsensitiveStr::Ascii("osns"),
        dictgen::InsensitiveStr::Ascii("ous"),
        dictgen::InsensitiveStr::Ascii("sions"),
        dictgen::InsensitiveStr::Ascii("son"),
        dictgen::InsensitiveStr::Ascii("soned"),
        dictgen::InsensitiveStr::Ascii("sons"),
        dictgen::InsensitiveStr::Ascii("tcal"),
        dictgen::InsensitiveStr::Ascii("tcally"),
        dictgen::InsensitiveStr::Ascii("tgo"),
        dictgen::InsensitiveStr::Ascii("tiable"),
        dictgen::InsensitiveStr::Ascii("tical"),
    ],
    values: &[
        &["vertical"],
        &["verify", "verified"],
        &["verification"],
        &["verification"],
        &["verification"],
        &["verification"],
        &["verify", "verified"],
        &["verification"],
        &["verifying"],
        &["verifying"],
        &["verify"],
        &["verifying"],
        &["verifiable"],
        &["verified"],
        &["version"],
        &["versions"],
        &["version"],
        &["versions"],
        &["various"],
        &["revisions"],
        &["version"],
        &["versioned"],
        &["versions"],
        &["vertical"],
        &["vertically"],
        &["vertigo"],
        &["verifiable"],
        &["vertical"],
    ],
    range: 2..=8,
};

static WORD_VERF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VERF_CHILDREN),
    value: None,
};

pub static WORD_VERF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ication"),
        dictgen::InsensitiveStr::Ascii("iciation"),
        dictgen::InsensitiveStr::Ascii("ifiable"),
        dictgen::InsensitiveStr::Ascii("ification"),
        dictgen::InsensitiveStr::Ascii("ifications"),
        dictgen::InsensitiveStr::Ascii("ified"),
        dictgen::InsensitiveStr::Ascii("ifier"),
        dictgen::InsensitiveStr::Ascii("ifiers"),
        dictgen::InsensitiveStr::Ascii("ifies"),
        dictgen::InsensitiveStr::Ascii("ify"),
        dictgen::InsensitiveStr::Ascii("ifying"),
        dictgen::InsensitiveStr::Ascii("iying"),
        dictgen::InsensitiveStr::Ascii("y"),
        dictgen::InsensitiveStr::Ascii("ying"),
    ],
    values: &[
        &["verification"],
        &["verification"],
        &["verifiable"],
        &["verification"],
        &["verifications"],
        &["verified"],
        &["verifier"],
        &["verifiers"],
        &["verifies"],
        &["verify"],
        &["verifying"],
        &["verifying"],
        &["verify"],
        &["verifying"],
    ],
    range: 1..=10,
};

static WORD_VERE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VERE_CHILDREN),
    value: None,
};

pub static WORD_VERE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("sion"),
        dictgen::InsensitiveStr::Ascii("sions"),
    ],
    values: &[&["version"], &["versions"]],
    range: 4..=5,
};

static WORD_VERB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VERB_CHILDREN),
    value: None,
};

pub static WORD_VERB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aitm"),
        dictgen::InsensitiveStr::Ascii("aly"),
        dictgen::InsensitiveStr::Ascii("atium"),
        dictgen::InsensitiveStr::Ascii("atum"),
        dictgen::InsensitiveStr::Ascii("ous"),
        dictgen::InsensitiveStr::Ascii("ouse"),
        dictgen::InsensitiveStr::Ascii("ously"),
        dictgen::InsensitiveStr::Ascii("se"),
    ],
    values: &[
        &["verbatim"],
        &["verbally"],
        &["verbatim"],
        &["verbatim"],
        &["verbose"],
        &["verbose"],
        &["verbosely"],
        &["verbose"],
    ],
    range: 2..=5,
};

static WORD_VERA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VERA_CHILDREN),
    value: None,
};

pub static WORD_VERA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("blly"),
        dictgen::InsensitiveStr::Ascii("stility"),
    ],
    values: &[&["verbally"], &["versatility"]],
    range: 4..=7,
};

static WORD_VEN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VEN_CHILDREN),
    value: None,
};

pub static WORD_VEN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("deta"),
        dictgen::InsensitiveStr::Ascii("dettta"),
        dictgen::InsensitiveStr::Ascii("egance"),
        dictgen::InsensitiveStr::Ascii("elope"),
        dictgen::InsensitiveStr::Ascii("emous"),
        dictgen::InsensitiveStr::Ascii("euzela"),
        dictgen::InsensitiveStr::Ascii("ezeula"),
        dictgen::InsensitiveStr::Ascii("ezuelean"),
        dictgen::InsensitiveStr::Ascii("ezuelian"),
        dictgen::InsensitiveStr::Ascii("ezuella"),
        dictgen::InsensitiveStr::Ascii("ezulea"),
        dictgen::InsensitiveStr::Ascii("gaence"),
        dictgen::InsensitiveStr::Ascii("gance"),
        dictgen::InsensitiveStr::Ascii("genace"),
        dictgen::InsensitiveStr::Ascii("gence"),
        dictgen::InsensitiveStr::Ascii("talation"),
        dictgen::InsensitiveStr::Ascii("telation"),
        dictgen::InsensitiveStr::Ascii("tialtion"),
        dictgen::InsensitiveStr::Ascii("tilacion"),
        dictgen::InsensitiveStr::Ascii("tilato"),
    ],
    values: &[
        &["vendetta"],
        &["vendetta"],
        &["vengeance"],
        &["envelope"],
        &["venomous"],
        &["venezuela"],
        &["venezuela"],
        &["venezuela"],
        &["venezuela"],
        &["venezuela"],
        &["venezuela"],
        &["vengeance"],
        &["vengeance"],
        &["vengeance"],
        &["vengeance"],
        &["ventilation"],
        &["ventilation"],
        &["ventilation"],
        &["ventilation"],
        &["ventilation"],
    ],
    range: 4..=8,
};

static WORD_VEL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VEL_CHILDREN),
    value: None,
};

pub static WORD_VEL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("antine"),
        dictgen::InsensitiveStr::Ascii("idate"),
        dictgen::InsensitiveStr::Ascii("l"),
        dictgen::InsensitiveStr::Ascii("ociries"),
        dictgen::InsensitiveStr::Ascii("ociry"),
    ],
    values: &[
        &["valentine"],
        &["validate"],
        &["well"],
        &["velocities"],
        &["velocity"],
    ],
    range: 1..=7,
};

static WORD_VEK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VEK_CHILDREN),
    value: None,
};

pub static WORD_VEK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("tor"),
        dictgen::InsensitiveStr::Ascii("tors"),
    ],
    values: &[&["vector"], &["vectors"]],
    range: 3..=4,
};

static WORD_VEI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VEI_CHILDREN),
    value: None,
};

pub static WORD_VEI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("chles"),
        dictgen::InsensitiveStr::Ascii("fy"),
        dictgen::InsensitiveStr::Ascii("tnam"),
        dictgen::InsensitiveStr::Ascii("tnamese"),
        dictgen::InsensitiveStr::Ascii("w"),
        dictgen::InsensitiveStr::Ascii("wed"),
        dictgen::InsensitiveStr::Ascii("wer"),
        dictgen::InsensitiveStr::Ascii("wers"),
        dictgen::InsensitiveStr::Ascii("wership"),
        dictgen::InsensitiveStr::Ascii("wing"),
        dictgen::InsensitiveStr::Ascii("wings"),
        dictgen::InsensitiveStr::Ascii("wpoint"),
        dictgen::InsensitiveStr::Ascii("wpoints"),
        dictgen::InsensitiveStr::Ascii("ws"),
    ],
    values: &[
        &["vehicles"],
        &["verify"],
        &["vietnam"],
        &["vietnamese"],
        &["view"],
        &["viewed"],
        &["viewer"],
        &["viewers"],
        &["viewership"],
        &["viewing"],
        &["viewings"],
        &["viewpoint"],
        &["viewpoints"],
        &["views"],
    ],
    range: 1..=7,
};

static WORD_VEH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VEH_CHILDREN),
    value: None,
};

pub static WORD_VEH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ciles"),
        dictgen::InsensitiveStr::Ascii("emantly"),
        dictgen::InsensitiveStr::Ascii("ementely"),
        dictgen::InsensitiveStr::Ascii("ementy"),
        dictgen::InsensitiveStr::Ascii("emontly"),
        dictgen::InsensitiveStr::Ascii("icels"),
        dictgen::InsensitiveStr::Ascii("icule"),
    ],
    values: &[
        &["vehicles"],
        &["vehemently"],
        &["vehemently"],
        &["vehemently"],
        &["vehemently"],
        &["vehicles"],
        &["vehicle"],
    ],
    range: 5..=8,
};

static WORD_VEG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VEG_CHILDREN),
    value: None,
};

pub static WORD_VEG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("anisim"),
        dictgen::InsensitiveStr::Ascii("ansim"),
        dictgen::InsensitiveStr::Ascii("atarian"),
        dictgen::InsensitiveStr::Ascii("aterian"),
        dictgen::InsensitiveStr::Ascii("aterians"),
        dictgen::InsensitiveStr::Ascii("eratian"),
        dictgen::InsensitiveStr::Ascii("etairan"),
        dictgen::InsensitiveStr::Ascii("etarain"),
        dictgen::InsensitiveStr::Ascii("etarianas"),
        dictgen::InsensitiveStr::Ascii("etarianos"),
        dictgen::InsensitiveStr::Ascii("etarien"),
        dictgen::InsensitiveStr::Ascii("etariens"),
        dictgen::InsensitiveStr::Ascii("etarin"),
        dictgen::InsensitiveStr::Ascii("etarion"),
        dictgen::InsensitiveStr::Ascii("etatian"),
        dictgen::InsensitiveStr::Ascii("etatians"),
        dictgen::InsensitiveStr::Ascii("eterian"),
        dictgen::InsensitiveStr::Ascii("eterians"),
        dictgen::InsensitiveStr::Ascii("itable"),
        dictgen::InsensitiveStr::Ascii("itables"),
        dictgen::InsensitiveStr::Ascii("table"),
    ],
    values: &[
        &["veganism"],
        &["veganism"],
        &["vegetarian"],
        &["vegetarian"],
        &["vegetarians"],
        &["vegetarians"],
        &["vegetarians"],
        &["vegetarians"],
        &["vegetarians"],
        &["vegetarians"],
        &["vegetarian"],
        &["vegetarians"],
        &["vegetarians"],
        &["vegetarian"],
        &["vegetarian"],
        &["vegetarians"],
        &["vegetarian"],
        &["vegetarians"],
        &["vegetable"],
        &["vegetables"],
        &["vegetable"],
    ],
    range: 5..=9,
};

static WORD_VEF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VEF_CHILDREN),
    value: None,
};

pub static WORD_VEF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("iry")],
    values: &[&["verify"]],
    range: 3..=3,
};

static WORD_VED_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VED_CHILDREN),
    value: None,
};

pub static WORD_VED_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("io")],
    values: &[&["video"]],
    range: 2..=2,
};

static WORD_VEC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VEC_CHILDREN),
    value: None,
};

pub static WORD_VEC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hiles"),
        dictgen::InsensitiveStr::Ascii("otr"),
        dictgen::InsensitiveStr::Ascii("otrs"),
        dictgen::InsensitiveStr::Ascii("tore"),
        dictgen::InsensitiveStr::Ascii("tores"),
        dictgen::InsensitiveStr::Ascii("tros"),
        dictgen::InsensitiveStr::Ascii("vtor"),
        dictgen::InsensitiveStr::Ascii("vtors"),
    ],
    values: &[
        &["vehicles"],
        &["vector"],
        &["vectors"],
        &["vector"],
        &["vectors"],
        &["vectors"],
        &["vector"],
        &["vectors"],
    ],
    range: 3..=5,
};

static WORD_VEB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VEB_CHILDREN),
    value: None,
};

pub static WORD_VEB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("rose")],
    values: &[&["verbose"]],
    range: 4..=4,
};

static WORD_VB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VB_CHILDREN),
    value: None,
};

pub static WORD_VB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("srcript")],
    values: &[&["vbscript"]],
    range: 7..=7,
};

static WORD_VA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_VA_CHILDREN),
    value: None,
};

static WORD_VA_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_VAA_NODE),
    None,
    Some(&WORD_VAC_NODE),
    None,
    None,
    None,
    Some(&WORD_VAG_NODE),
    None,
    Some(&WORD_VAI_NODE),
    None,
    Some(&WORD_VAK_NODE),
    Some(&WORD_VAL_NODE),
    Some(&WORD_VAM_NODE),
    Some(&WORD_VAN_NODE),
    None,
    None,
    None,
    Some(&WORD_VAR_NODE),
    Some(&WORD_VAS_NODE),
    Some(&WORD_VAT_NODE),
    Some(&WORD_VAU_NODE),
    Some(&WORD_VAV_NODE),
    None,
    None,
    Some(&WORD_VAY_NODE),
    None,
];

static WORD_VAY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VAY_CHILDREN),
    value: None,
};

pub static WORD_VAY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("lkrie")],
    values: &[&["valkyrie"]],
    range: 5..=5,
};

static WORD_VAV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VAV_CHILDREN),
    value: None,
};

pub static WORD_VAV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("le"),
        dictgen::InsensitiveStr::Ascii("lue"),
        dictgen::InsensitiveStr::Ascii("riable"),
        dictgen::InsensitiveStr::Ascii("riables"),
    ],
    values: &[
        &["have", "valve"],
        &["valve"],
        &["value"],
        &["variable"],
        &["variables"],
    ],
    range: 1..=7,
};

static WORD_VAU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VAU_CHILDREN),
    value: None,
};

pub static WORD_VAU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("gely"),
        dictgen::InsensitiveStr::Ascii("lable"),
        dictgen::InsensitiveStr::Ascii("le"),
        dictgen::InsensitiveStr::Ascii("led"),
        dictgen::InsensitiveStr::Ascii("les"),
        dictgen::InsensitiveStr::Ascii("ling"),
    ],
    values: &[
        &["value"],
        &["vaguely"],
        &["valuable"],
        &["value"],
        &["valued"],
        &["values"],
        &["valuing"],
    ],
    range: 1..=5,
};

static WORD_VAT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VAT_CHILDREN),
    value: None,
};

pub static WORD_VAT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("icaan"),
        dictgen::InsensitiveStr::Ascii("icina"),
    ],
    values: &[&["vatican"], &["vatican"]],
    range: 5..=5,
};

static WORD_VAS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VAS_CHILDREN),
    value: Some(&["was"]),
};

pub static WORD_VAS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("all"),
        dictgen::InsensitiveStr::Ascii("alls"),
        dictgen::InsensitiveStr::Ascii("cetomy"),
        dictgen::InsensitiveStr::Ascii("ectomey"),
        dictgen::InsensitiveStr::Ascii("sales"),
        dictgen::InsensitiveStr::Ascii("salls"),
        dictgen::InsensitiveStr::Ascii("salos"),
        dictgen::InsensitiveStr::Ascii("slas"),
        dictgen::InsensitiveStr::Ascii("tecomy"),
    ],
    values: &[
        &["vassal"],
        &["vassals"],
        &["vasectomy"],
        &["vasectomy"],
        &["vassals"],
        &["vassals"],
        &["vassals"],
        &["vassals"],
        &["vasectomy"],
    ],
    range: 3..=7,
};

static WORD_VAR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VAR_CHILDREN),
    value: None,
};

pub static WORD_VAR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("able"),
        dictgen::InsensitiveStr::Ascii("ables"),
        dictgen::InsensitiveStr::Ascii("aiable"),
        dictgen::InsensitiveStr::Ascii("aiables"),
        dictgen::InsensitiveStr::Ascii("aiance"),
        dictgen::InsensitiveStr::Ascii("aiation"),
        dictgen::InsensitiveStr::Ascii("aible"),
        dictgen::InsensitiveStr::Ascii("aibles"),
        dictgen::InsensitiveStr::Ascii("aint"),
        dictgen::InsensitiveStr::Ascii("aints"),
        dictgen::InsensitiveStr::Ascii("ation"),
        dictgen::InsensitiveStr::Ascii("ations"),
        dictgen::InsensitiveStr::Ascii("eity"),
        dictgen::InsensitiveStr::Ascii("iabe"),
        dictgen::InsensitiveStr::Ascii("iabel"),
        dictgen::InsensitiveStr::Ascii("iabele"),
        dictgen::InsensitiveStr::Ascii("iabes"),
        dictgen::InsensitiveStr::Ascii("iabl"),
        dictgen::InsensitiveStr::Ascii("ialbles"),
        dictgen::InsensitiveStr::Ascii("ian"),
        dictgen::InsensitiveStr::Ascii("ians"),
        dictgen::InsensitiveStr::Ascii("iantes"),
        dictgen::InsensitiveStr::Ascii("iantions"),
        dictgen::InsensitiveStr::Ascii("iatinos"),
        dictgen::InsensitiveStr::Ascii("iatoin"),
        dictgen::InsensitiveStr::Ascii("iatoins"),
        dictgen::InsensitiveStr::Ascii("ibable"),
        dictgen::InsensitiveStr::Ascii("ibables"),
        dictgen::InsensitiveStr::Ascii("ibale"),
        dictgen::InsensitiveStr::Ascii("ibales"),
        dictgen::InsensitiveStr::Ascii("ibaless"),
        dictgen::InsensitiveStr::Ascii("ibel"),
        dictgen::InsensitiveStr::Ascii("ibels"),
        dictgen::InsensitiveStr::Ascii("ibility"),
        dictgen::InsensitiveStr::Ascii("iblae"),
        dictgen::InsensitiveStr::Ascii("iblaes"),
        dictgen::InsensitiveStr::Ascii("ible"),
        dictgen::InsensitiveStr::Ascii("ibles"),
        dictgen::InsensitiveStr::Ascii("ience"),
        dictgen::InsensitiveStr::Ascii("ient"),
        dictgen::InsensitiveStr::Ascii("ients"),
        dictgen::InsensitiveStr::Ascii("ierty"),
        dictgen::InsensitiveStr::Ascii("iey"),
        dictgen::InsensitiveStr::Ascii("ification"),
        dictgen::InsensitiveStr::Ascii("iing"),
        dictgen::InsensitiveStr::Ascii("ing"),
        dictgen::InsensitiveStr::Ascii("isty"),
        dictgen::InsensitiveStr::Ascii("itey"),
        dictgen::InsensitiveStr::Ascii("ities"),
        dictgen::InsensitiveStr::Ascii("ity"),
        dictgen::InsensitiveStr::Ascii("iuos"),
        dictgen::InsensitiveStr::Ascii("iuous"),
        dictgen::InsensitiveStr::Ascii("ius"),
        dictgen::InsensitiveStr::Ascii("n"),
        dictgen::InsensitiveStr::Ascii("ned"),
        dictgen::InsensitiveStr::Ascii("ning"),
        dictgen::InsensitiveStr::Ascii("nings"),
        dictgen::InsensitiveStr::Ascii("ns"),
        dictgen::InsensitiveStr::Ascii("oius"),
        dictgen::InsensitiveStr::Ascii("stiy"),
        dictgen::InsensitiveStr::Ascii("tical"),
        dictgen::InsensitiveStr::Ascii("tically"),
    ],
    values: &[
        &["variable"],
        &["variables"],
        &["variable"],
        &["variables"],
        &["variance"],
        &["variation"],
        &["variable"],
        &["variables"],
        &["variant"],
        &["variants"],
        &["variation"],
        &["variations"],
        &["variety"],
        &["variable"],
        &["variable"],
        &["variable"],
        &["variables"],
        &["variable"],
        &["variables"],
        &["variant"],
        &["variants"],
        &["variants"],
        &["variations"],
        &["variations"],
        &["variation"],
        &["variations"],
        &["variable"],
        &["variables"],
        &["variable"],
        &["variables"],
        &["variables"],
        &["variable"],
        &["variables"],
        &["variability"],
        &["variable"],
        &["variables"],
        &["variable"],
        &["variables"],
        &["variance"],
        &["variant"],
        &["variants"],
        &["variety"],
        &["variety"],
        &["verification"],
        &["varying"],
        &["varying"],
        &["varsity"],
        &["variety"],
        &["varieties"],
        &["variety"],
        &["various"],
        &["various"],
        &["various"],
        &["warn"],
        &["warned"],
        &["warning"],
        &["warnings"],
        &["warns"],
        &["various"],
        &["varsity"],
        &["vertical"],
        &["vertically"],
    ],
    range: 1..=9,
};

static WORD_VAN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VAN_CHILDREN),
    value: None,
};

pub static WORD_VAN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("adlism"),
        dictgen::InsensitiveStr::Ascii("dalisim"),
        dictgen::InsensitiveStr::Ascii("dalsim"),
        dictgen::InsensitiveStr::Ascii("guad"),
        dictgen::InsensitiveStr::Ascii("gurad"),
        dictgen::InsensitiveStr::Ascii("illia"),
        dictgen::InsensitiveStr::Ascii("illla"),
        dictgen::InsensitiveStr::Ascii("ishs"),
        dictgen::InsensitiveStr::Ascii("ugard"),
    ],
    values: &[
        &["vandalism"],
        &["vandalism"],
        &["vandalism"],
        &["vanguard"],
        &["vanguard"],
        &["vanilla"],
        &["vanilla"],
        &["vanishes"],
        &["vanguard"],
    ],
    range: 4..=7,
};

static WORD_VAM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VAM_CHILDREN),
    value: None,
};

pub static WORD_VAM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ipres"),
        dictgen::InsensitiveStr::Ascii("piers"),
        dictgen::InsensitiveStr::Ascii("pirs"),
        dictgen::InsensitiveStr::Ascii("pries"),
    ],
    values: &[&["vampires"], &["vampires"], &["vampires"], &["vampires"]],
    range: 4..=5,
};

static WORD_VAL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VAL_CHILDREN),
    value: None,
};

pub static WORD_VAL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ailable"),
        dictgen::InsensitiveStr::Ascii("date"),
        dictgen::InsensitiveStr::Ascii("diated"),
        dictgen::InsensitiveStr::Ascii("enca"),
        dictgen::InsensitiveStr::Ascii("enica"),
        dictgen::InsensitiveStr::Ascii("entein"),
        dictgen::InsensitiveStr::Ascii("entians"),
        dictgen::InsensitiveStr::Ascii("entie"),
        dictgen::InsensitiveStr::Ascii("entien"),
        dictgen::InsensitiveStr::Ascii("entiens"),
        dictgen::InsensitiveStr::Ascii("entimes"),
        dictgen::InsensitiveStr::Ascii("entinas"),
        dictgen::InsensitiveStr::Ascii("entinos"),
        dictgen::InsensitiveStr::Ascii("entins"),
        dictgen::InsensitiveStr::Ascii("entis"),
        dictgen::InsensitiveStr::Ascii("entones"),
        dictgen::InsensitiveStr::Ascii("etta"),
        dictgen::InsensitiveStr::Ascii("iator"),
        dictgen::InsensitiveStr::Ascii("idade"),
        dictgen::InsensitiveStr::Ascii("idaterelase"),
        dictgen::InsensitiveStr::Ascii("ide"),
        dictgen::InsensitiveStr::Ascii("ididty"),
        dictgen::InsensitiveStr::Ascii("iding"),
        dictgen::InsensitiveStr::Ascii("iditity"),
        dictgen::InsensitiveStr::Ascii("iditiy"),
        dictgen::InsensitiveStr::Ascii("ied"),
        dictgen::InsensitiveStr::Ascii("ies"),
        dictgen::InsensitiveStr::Ascii("if"),
        dictgen::InsensitiveStr::Ascii("itdity"),
        dictgen::InsensitiveStr::Ascii("kirye"),
        dictgen::InsensitiveStr::Ascii("kiyre"),
        dictgen::InsensitiveStr::Ascii("kriye"),
        dictgen::InsensitiveStr::Ascii("kryie"),
        dictgen::InsensitiveStr::Ascii("kues"),
        dictgen::InsensitiveStr::Ascii("kyire"),
        dictgen::InsensitiveStr::Ascii("kyre"),
        dictgen::InsensitiveStr::Ascii("lid"),
        dictgen::InsensitiveStr::Ascii("lidation"),
        dictgen::InsensitiveStr::Ascii("lidity"),
        dictgen::InsensitiveStr::Ascii("lue"),
        dictgen::InsensitiveStr::Ascii("lues"),
        dictgen::InsensitiveStr::Ascii("necia"),
        dictgen::InsensitiveStr::Ascii("netines"),
        dictgen::InsensitiveStr::Ascii("tage"),
        dictgen::InsensitiveStr::Ascii("tages"),
        dictgen::InsensitiveStr::Ascii("u"),
        dictgen::InsensitiveStr::Ascii("uabe"),
        dictgen::InsensitiveStr::Ascii("ubale"),
        dictgen::InsensitiveStr::Ascii("uble"),
        dictgen::InsensitiveStr::Ascii("udes"),
        dictgen::InsensitiveStr::Ascii("ueable"),
        dictgen::InsensitiveStr::Ascii("uess"),
        dictgen::InsensitiveStr::Ascii("uie"),
        dictgen::InsensitiveStr::Ascii("use"),
        dictgen::InsensitiveStr::Ascii("ykrie"),
    ],
    values: &[
        &["available"],
        &["validate"],
        &["validated"],
        &["valencia"],
        &["valencia"],
        &["valentine"],
        &["valentines"],
        &["valentines"],
        &["valentine"],
        &["valentines"],
        &["valentines"],
        &["valentines"],
        &["valentines"],
        &["valentines"],
        &["valentines"],
        &["valentines"],
        &["valletta"],
        &["validator"],
        &["validated"],
        &["validaterelease"],
        &["valid"],
        &["validity"],
        &["validating"],
        &["validity"],
        &["validity"],
        &["valid"],
        &["values"],
        &["valid"],
        &["validity"],
        &["valkyrie"],
        &["valkyrie"],
        &["valkyrie"],
        &["valkyrie"],
        &["values"],
        &["valkyrie"],
        &["valkyrie"],
        &["valid"],
        &["validation"],
        &["validity"],
        &["value"],
        &["values"],
        &["valencia"],
        &["valentines"],
        &["voltage"],
        &["voltages"],
        &["value"],
        &["valuable"],
        &["valuable"],
        &["valuable"],
        &["values"],
        &["valuable"],
        &["values"],
        &["value"],
        &["values", "value"],
        &["valkyrie"],
    ],
    range: 1..=11,
};

static WORD_VAK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VAK_CHILDREN),
    value: None,
};

pub static WORD_VAK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lyrie"),
        dictgen::InsensitiveStr::Ascii("ue"),
        dictgen::InsensitiveStr::Ascii("ued"),
        dictgen::InsensitiveStr::Ascii("ues"),
    ],
    values: &[&["valkyrie"], &["value"], &["valued"], &["values"]],
    range: 2..=5,
};

static WORD_VAI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VAI_CHILDREN),
    value: None,
};

pub static WORD_VAI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("able"),
        dictgen::InsensitiveStr::Ascii("ables"),
        dictgen::InsensitiveStr::Ascii("ant"),
        dictgen::InsensitiveStr::Ascii("ants"),
        dictgen::InsensitiveStr::Ascii("ation"),
        dictgen::InsensitiveStr::Ascii("bility"),
        dictgen::InsensitiveStr::Ascii("d"),
        dictgen::InsensitiveStr::Ascii("eties"),
        dictgen::InsensitiveStr::Ascii("lable"),
        dictgen::InsensitiveStr::Ascii("ld"),
        dictgen::InsensitiveStr::Ascii("ldated"),
        dictgen::InsensitiveStr::Ascii("lidity"),
        dictgen::InsensitiveStr::Ascii("lidty"),
        dictgen::InsensitiveStr::Ascii("rable"),
        dictgen::InsensitiveStr::Ascii("rables"),
        dictgen::InsensitiveStr::Ascii("rant"),
        dictgen::InsensitiveStr::Ascii("rous"),
    ],
    values: &[
        &["variable"],
        &["variables"],
        &["variant"],
        &["variants"],
        &["aviation"],
        &["viability"],
        &["valid", "void"],
        &["varieties"],
        &["available"],
        &["valid"],
        &["validated"],
        &["validity"],
        &["validity"],
        &["variable"],
        &["variables"],
        &["variant"],
        &["various"],
    ],
    range: 1..=6,
};

static WORD_VAG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VAG_CHILDREN),
    value: None,
};

pub static WORD_VAG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("euly"),
        dictgen::InsensitiveStr::Ascii("uaries"),
        dictgen::InsensitiveStr::Ascii("uelly"),
        dictgen::InsensitiveStr::Ascii("uley"),
    ],
    values: &[&["vaguely"], &["vagaries"], &["vaguely"], &["vaguely"]],
    range: 4..=6,
};

static WORD_VAC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VAC_CHILDREN),
    value: None,
};

pub static WORD_VAC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ciante"),
        dictgen::InsensitiveStr::Ascii("ciantion"),
        dictgen::InsensitiveStr::Ascii("cinae"),
        dictgen::InsensitiveStr::Ascii("cinatie"),
        dictgen::InsensitiveStr::Ascii("cinaties"),
        dictgen::InsensitiveStr::Ascii("cinato"),
        dictgen::InsensitiveStr::Ascii("cineras"),
        dictgen::InsensitiveStr::Ascii("ciners"),
        dictgen::InsensitiveStr::Ascii("cinet"),
        dictgen::InsensitiveStr::Ascii("cins"),
        dictgen::InsensitiveStr::Ascii("cum"),
        dictgen::InsensitiveStr::Ascii("cume"),
        dictgen::InsensitiveStr::Ascii("cuum"),
        dictgen::InsensitiveStr::Ascii("estomy"),
        dictgen::InsensitiveStr::Ascii("inity"),
        dictgen::InsensitiveStr::Ascii("tor"),
        dictgen::InsensitiveStr::Ascii("tors"),
        dictgen::InsensitiveStr::Ascii("umme"),
        dictgen::InsensitiveStr::Ascii("uosly"),
    ],
    values: &[
        &["vaccinate"],
        &["vaccination"],
        &["vaccinated"],
        &["vaccinated"],
        &["vaccinate"],
        &["vaccination"],
        &["vaccines"],
        &["vaccines"],
        &["vaccinated"],
        &["vaccines"],
        &["vacuum"],
        &["vacuum"],
        &["vacuum"],
        &["vasectomy"],
        &["vicinity"],
        &["vector"],
        &["vectors"],
        &["vacuum"],
        &["vacuously"],
    ],
    range: 3..=8,
};

static WORD_VAA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_VAA_CHILDREN),
    value: None,
};

pub static WORD_VAA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("lues")],
    values: &[&["values"]],
    range: 4..=4,
};

static WORD_U_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_U_CHILDREN),
    value: None,
};

static WORD_U_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    Some(&WORD_UB_NODE),
    None,
    Some(&WORD_UD_NODE),
    Some(&WORD_UE_NODE),
    None,
    Some(&WORD_UG_NODE),
    None,
    Some(&WORD_UI_NODE),
    None,
    Some(&WORD_UK_NODE),
    Some(&WORD_UL_NODE),
    Some(&WORD_UM_NODE),
    Some(&WORD_UN_NODE),
    None,
    Some(&WORD_UP_NODE),
    None,
    Some(&WORD_UR_NODE),
    Some(&WORD_US_NODE),
    Some(&WORD_UT_NODE),
    Some(&WORD_UU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static WORD_UU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UU_CHILDREN),
    value: None,
};

pub static WORD_UU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("pload")],
    values: &[&["upload"]],
    range: 5..=5,
};

static WORD_UT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UT_CHILDREN),
    value: None,
};

pub static WORD_UT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("iilties"),
        dictgen::InsensitiveStr::Ascii("iliatrian"),
        dictgen::InsensitiveStr::Ascii("ilies"),
        dictgen::InsensitiveStr::Ascii("ililties"),
        dictgen::InsensitiveStr::Ascii("ilis"),
        dictgen::InsensitiveStr::Ascii("ilisa"),
        dictgen::InsensitiveStr::Ascii("ilisaton"),
        dictgen::InsensitiveStr::Ascii("ilitatian"),
        dictgen::InsensitiveStr::Ascii("iliterian"),
        dictgen::InsensitiveStr::Ascii("ilites"),
        dictgen::InsensitiveStr::Ascii("ilitisation"),
        dictgen::InsensitiveStr::Ascii("ilitise"),
        dictgen::InsensitiveStr::Ascii("ilitises"),
        dictgen::InsensitiveStr::Ascii("ilitising"),
        dictgen::InsensitiveStr::Ascii("ilitiy"),
        dictgen::InsensitiveStr::Ascii("ilitization"),
        dictgen::InsensitiveStr::Ascii("ilitize"),
        dictgen::InsensitiveStr::Ascii("ilitizes"),
        dictgen::InsensitiveStr::Ascii("ilitizing"),
        dictgen::InsensitiveStr::Ascii("iliz"),
        dictgen::InsensitiveStr::Ascii("iliza"),
        dictgen::InsensitiveStr::Ascii("ilizacion"),
        dictgen::InsensitiveStr::Ascii("ilizaiton"),
        dictgen::InsensitiveStr::Ascii("ilizating"),
        dictgen::InsensitiveStr::Ascii("ilizaton"),
        dictgen::InsensitiveStr::Ascii("illities"),
        dictgen::InsensitiveStr::Ascii("iltiarian"),
        dictgen::InsensitiveStr::Ascii("ilties"),
        dictgen::InsensitiveStr::Ascii("iltities"),
        dictgen::InsensitiveStr::Ascii("iltity"),
        dictgen::InsensitiveStr::Ascii("iltiy"),
        dictgen::InsensitiveStr::Ascii("ilty"),
        dictgen::InsensitiveStr::Ascii("itity"),
        dictgen::InsensitiveStr::Ascii("itlty"),
        dictgen::InsensitiveStr::Ascii("limate"),
        dictgen::InsensitiveStr::Ascii("limately"),
        dictgen::InsensitiveStr::Ascii("limatum"),
        dictgen::InsensitiveStr::Ascii("lities"),
        dictgen::InsensitiveStr::Ascii("lity"),
        dictgen::InsensitiveStr::Ascii("lrasound"),
        dictgen::InsensitiveStr::Ascii("opain"),
        dictgen::InsensitiveStr::Ascii("poian"),
        dictgen::InsensitiveStr::Ascii("put"),
        dictgen::InsensitiveStr::Ascii("puts"),
    ],
    values: &[
        &["utilities"],
        &["utilitarian"],
        &["utilities"],
        &["utilities"],
        &["utilise"],
        &["utilise"],
        &["utilisation"],
        &["utilitarian"],
        &["utilitarian"],
        &["utilities"],
        &["utilisation"],
        &["utilise"],
        &["utilises"],
        &["utilising"],
        &["utility"],
        &["utilization"],
        &["utilize"],
        &["utilizes"],
        &["utilizing"],
        &["utilize"],
        &["utilize"],
        &["utilization"],
        &["utilization"],
        &["utilization"],
        &["utilization"],
        &["utilities"],
        &["utilitarian"],
        &["utilities"],
        &["utilities"],
        &["utility"],
        &["utility"],
        &["utility"],
        &["utility"],
        &["utility"],
        &["ultimate"],
        &["ultimately"],
        &["ultimatum"],
        &["utilities"],
        &["utility"],
        &["ultrasound"],
        &["utopian"],
        &["utopian"],
        &["output"],
        &["outputs"],
    ],
    range: 3..=11,
};

static WORD_US_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_US_CHILDREN),
    value: None,
};

pub static WORD_US_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("al"),
        dictgen::InsensitiveStr::Ascii("ally"),
        dictgen::InsensitiveStr::Ascii("caled"),
        dictgen::InsensitiveStr::Ascii("eage"),
        dictgen::InsensitiveStr::Ascii("ebility"),
        dictgen::InsensitiveStr::Ascii("eble"),
        dictgen::InsensitiveStr::Ascii("eed"),
        dictgen::InsensitiveStr::Ascii("ees"),
        dictgen::InsensitiveStr::Ascii("efule"),
        dictgen::InsensitiveStr::Ascii("efullness"),
        dictgen::InsensitiveStr::Ascii("efult"),
        dictgen::InsensitiveStr::Ascii("efuly"),
        dictgen::InsensitiveStr::Ascii("efutl"),
        dictgen::InsensitiveStr::Ascii("eg"),
        dictgen::InsensitiveStr::Ascii("ege"),
        dictgen::InsensitiveStr::Ascii("eing"),
        dictgen::InsensitiveStr::Ascii("era"),
        dictgen::InsensitiveStr::Ascii("erapace"),
        dictgen::InsensitiveStr::Ascii("erful"),
        dictgen::InsensitiveStr::Ascii("erpace"),
        dictgen::InsensitiveStr::Ascii("erpsace"),
        dictgen::InsensitiveStr::Ascii("ersapce"),
        dictgen::InsensitiveStr::Ascii("erspase"),
        dictgen::InsensitiveStr::Ascii("esfull"),
        dictgen::InsensitiveStr::Ascii("espace"),
        dictgen::InsensitiveStr::Ascii("etnet"),
        dictgen::InsensitiveStr::Ascii("ibility"),
        dictgen::InsensitiveStr::Ascii("ible"),
        dictgen::InsensitiveStr::Ascii("ig"),
        dictgen::InsensitiveStr::Ascii("ign"),
        dictgen::InsensitiveStr::Ascii("iing"),
        dictgen::InsensitiveStr::Ascii("in"),
        dictgen::InsensitiveStr::Ascii("ind"),
        dictgen::InsensitiveStr::Ascii("inging"),
        dictgen::InsensitiveStr::Ascii("inng"),
        dictgen::InsensitiveStr::Ascii("ng"),
        dictgen::InsensitiveStr::Ascii("pported"),
        dictgen::InsensitiveStr::Ascii("seful"),
        dictgen::InsensitiveStr::Ascii("sual"),
        dictgen::InsensitiveStr::Ascii("suall"),
        dictgen::InsensitiveStr::Ascii("sually"),
        dictgen::InsensitiveStr::Ascii("uable"),
        dictgen::InsensitiveStr::Ascii("uage"),
        dictgen::InsensitiveStr::Ascii("uall"),
        dictgen::InsensitiveStr::Ascii("uallly"),
        dictgen::InsensitiveStr::Ascii("ualy"),
        dictgen::InsensitiveStr::Ascii("ueful"),
        dictgen::InsensitiveStr::Ascii("upported"),
        dictgen::InsensitiveStr::Ascii("usal"),
        dictgen::InsensitiveStr::Ascii("usally"),
    ],
    values: &[
        &["usual"],
        &["usually"],
        &["unscaled"],
        &["usage"],
        &["usability"],
        &["usable"],
        &["used"],
        &["uses"],
        &["useful"],
        &["usefulness"],
        &["useful"],
        &["usefully"],
        &["useful"],
        &["user", "usage"],
        &["usage"],
        &["using"],
        &["users"],
        &["userspace"],
        &["useful"],
        &["userspace"],
        &["userspace"],
        &["userspace"],
        &["userspace"],
        &["useful"],
        &["userspace"],
        &["usenet"],
        &["usability"],
        &["usable"],
        &["using"],
        &["using", "unsign"],
        &["using"],
        &["using"],
        &["using"],
        &["using"],
        &["using"],
        &["using"],
        &["supported", "unsupported"],
        &["useful"],
        &["usual"],
        &["usual"],
        &["usually"],
        &["usable"],
        &["usage"],
        &["usually", "usual"],
        &["usually"],
        &["usually"],
        &["useful"],
        &["unsupported"],
        &["usual"],
        &["usually"],
    ],
    range: 2..=9,
};

static WORD_UR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UR_CHILDREN),
    value: None,
};

pub static WORD_UR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ainum"),
        dictgen::InsensitiveStr::Ascii("anuim"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("ethrea"),
        dictgen::InsensitiveStr::Ascii("etrha"),
        dictgen::InsensitiveStr::Ascii("kaine"),
        dictgen::InsensitiveStr::Ascii("kainian"),
        dictgen::InsensitiveStr::Ascii("kainians"),
        dictgen::InsensitiveStr::Ascii("naium"),
        dictgen::InsensitiveStr::Ascii("rlib"),
        dictgen::InsensitiveStr::Ascii("ugauy"),
        dictgen::InsensitiveStr::Ascii("uguary"),
    ],
    values: &[
        &["uranium"],
        &["uranium"],
        &["sure", "ire", "are", "urea", "rue"],
        &["urethra"],
        &["urethra"],
        &["ukraine"],
        &["ukrainian"],
        &["ukrainians"],
        &["uranium"],
        &["urllib"],
        &["uruguay"],
        &["uruguay"],
    ],
    range: 1..=8,
};

static WORD_UP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_UP_CHILDREN),
    value: None,
};

static WORD_UP_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_UPA_NODE),
    None,
    Some(&WORD_UPC_NODE),
    Some(&WORD_UPD_NODE),
    Some(&WORD_UPE_NODE),
    None,
    Some(&WORD_UPG_NODE),
    Some(&WORD_UPH_NODE),
    None,
    None,
    None,
    Some(&WORD_UPL_NODE),
    None,
    None,
    None,
    Some(&WORD_UPP_NODE),
    None,
    Some(&WORD_UPR_NODE),
    Some(&WORD_UPS_NODE),
    Some(&WORD_UPT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_UPT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UPT_CHILDREN),
    value: None,
};

pub static WORD_UPT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("adeable"),
        dictgen::InsensitiveStr::Ascii("date"),
        dictgen::InsensitiveStr::Ascii("im"),
        dictgen::InsensitiveStr::Ascii("ions"),
        dictgen::InsensitiveStr::Ascii("ream"),
        dictgen::InsensitiveStr::Ascii("reamed"),
        dictgen::InsensitiveStr::Ascii("reamer"),
        dictgen::InsensitiveStr::Ascii("reaming"),
        dictgen::InsensitiveStr::Ascii("reams"),
    ],
    values: &[
        &["updatable"],
        &["update"],
        &["uptime"],
        &["options"],
        &["upstream"],
        &["upstreamed"],
        &["upstreamer"],
        &["upstreaming"],
        &["upstreams"],
    ],
    range: 2..=7,
};

static WORD_UPS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UPS_CHILDREN),
    value: None,
};

pub static WORD_UPS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ream"),
        dictgen::InsensitiveStr::Ascii("reamed"),
        dictgen::InsensitiveStr::Ascii("reamer"),
        dictgen::InsensitiveStr::Ascii("reaming"),
        dictgen::InsensitiveStr::Ascii("reams"),
        dictgen::InsensitiveStr::Ascii("rteam"),
        dictgen::InsensitiveStr::Ascii("rteamed"),
        dictgen::InsensitiveStr::Ascii("rteamer"),
        dictgen::InsensitiveStr::Ascii("rteaming"),
        dictgen::InsensitiveStr::Ascii("rteams"),
        dictgen::InsensitiveStr::Ascii("taris"),
        dictgen::InsensitiveStr::Ascii("team"),
        dictgen::InsensitiveStr::Ascii("teamed"),
        dictgen::InsensitiveStr::Ascii("teamer"),
        dictgen::InsensitiveStr::Ascii("teaming"),
        dictgen::InsensitiveStr::Ascii("teams"),
        dictgen::InsensitiveStr::Ascii("teram"),
        dictgen::InsensitiveStr::Ascii("teramed"),
        dictgen::InsensitiveStr::Ascii("teramer"),
        dictgen::InsensitiveStr::Ascii("teraming"),
        dictgen::InsensitiveStr::Ascii("terams"),
        dictgen::InsensitiveStr::Ascii("tiars"),
        dictgen::InsensitiveStr::Ascii("tread"),
        dictgen::InsensitiveStr::Ascii("treamedd"),
        dictgen::InsensitiveStr::Ascii("treammed"),
        dictgen::InsensitiveStr::Ascii("treammer"),
        dictgen::InsensitiveStr::Ascii("treamming"),
        dictgen::InsensitiveStr::Ascii("treem"),
        dictgen::InsensitiveStr::Ascii("treemed"),
        dictgen::InsensitiveStr::Ascii("treemer"),
        dictgen::InsensitiveStr::Ascii("treeming"),
        dictgen::InsensitiveStr::Ascii("treems"),
        dictgen::InsensitiveStr::Ascii("trema"),
        dictgen::InsensitiveStr::Ascii("upported"),
    ],
    values: &[
        &["upstream"],
        &["upstreamed"],
        &["upstreamer"],
        &["upstreaming"],
        &["upstreams"],
        &["upstream"],
        &["upstreamed"],
        &["upstreamer"],
        &["upstreaming"],
        &["upstreams"],
        &["upstairs"],
        &["upstream"],
        &["upstreamed"],
        &["upstreamer"],
        &["upstreaming"],
        &["upstreams"],
        &["upstream"],
        &["upstreamed"],
        &["upstreamer"],
        &["upstreaming"],
        &["upstreams"],
        &["upstairs"],
        &["upstream"],
        &["upstreamed"],
        &["upstreamed"],
        &["upstreamer"],
        &["upstreaming"],
        &["upstream"],
        &["upstreamed"],
        &["upstreamer"],
        &["upstreaming"],
        &["upstreams"],
        &["upstream"],
        &["unsupported"],
    ],
    range: 4..=9,
};

static WORD_UPR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UPR_CHILDREN),
    value: None,
};

pub static WORD_UPR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ade"),
        dictgen::InsensitiveStr::Ascii("gaded"),
    ],
    values: &[&["upgrade"], &["upgraded"]],
    range: 3..=5,
};

static WORD_UPP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UPP_CHILDREN),
    value: None,
};

pub static WORD_UPP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ler"),
        dictgen::InsensitiveStr::Ascii("on"),
        dictgen::InsensitiveStr::Ascii("orted"),
        dictgen::InsensitiveStr::Ascii("orterd"),
        dictgen::InsensitiveStr::Ascii("stream"),
        dictgen::InsensitiveStr::Ascii("streamed"),
        dictgen::InsensitiveStr::Ascii("streamer"),
        dictgen::InsensitiveStr::Ascii("streaming"),
        dictgen::InsensitiveStr::Ascii("streams"),
        dictgen::InsensitiveStr::Ascii("wards"),
    ],
    values: &[
        &["upper"],
        &["upon"],
        &["supported"],
        &["supported"],
        &["upstream"],
        &["upstreamed"],
        &["upstreamer"],
        &["upstreaming"],
        &["upstreams"],
        &["upwards"],
    ],
    range: 2..=9,
};

static WORD_UPL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UPL_CHILDREN),
    value: None,
};

pub static WORD_UPL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ad"),
        dictgen::InsensitiveStr::Ascii("adad"),
        dictgen::InsensitiveStr::Ascii("adaded"),
        dictgen::InsensitiveStr::Ascii("aded"),
        dictgen::InsensitiveStr::Ascii("ader"),
        dictgen::InsensitiveStr::Ascii("aders"),
        dictgen::InsensitiveStr::Ascii("ading"),
        dictgen::InsensitiveStr::Ascii("ads"),
        dictgen::InsensitiveStr::Ascii("aod"),
        dictgen::InsensitiveStr::Ascii("aodad"),
        dictgen::InsensitiveStr::Ascii("aodaded"),
        dictgen::InsensitiveStr::Ascii("aoded"),
        dictgen::InsensitiveStr::Ascii("aoder"),
        dictgen::InsensitiveStr::Ascii("aoders"),
        dictgen::InsensitiveStr::Ascii("aodes"),
        dictgen::InsensitiveStr::Ascii("aoding"),
        dictgen::InsensitiveStr::Ascii("aods"),
        dictgen::InsensitiveStr::Ascii("fiting"),
        dictgen::InsensitiveStr::Ascii("iad"),
        dictgen::InsensitiveStr::Ascii("ifitng"),
        dictgen::InsensitiveStr::Ascii("oades"),
        dictgen::InsensitiveStr::Ascii("od"),
        dictgen::InsensitiveStr::Ascii("odad"),
        dictgen::InsensitiveStr::Ascii("odaded"),
        dictgen::InsensitiveStr::Ascii("oded"),
        dictgen::InsensitiveStr::Ascii("oder"),
        dictgen::InsensitiveStr::Ascii("oders"),
        dictgen::InsensitiveStr::Ascii("oding"),
        dictgen::InsensitiveStr::Ascii("ods"),
    ],
    values: &[
        &["upload"],
        &["upload", "uploaded"],
        &["uploaded"],
        &["uploaded"],
        &["uploader"],
        &["uploaders"],
        &["uploading"],
        &["uploads"],
        &["upload"],
        &["upload", "uploaded"],
        &["uploaded"],
        &["uploaded"],
        &["uploader"],
        &["uploaders"],
        &["uploads"],
        &["uploading"],
        &["uploads"],
        &["uplifting"],
        &["upload"],
        &["uplifting"],
        &["uploads"],
        &["upload"],
        &["upload", "uploaded"],
        &["uploaded"],
        &["uploaded"],
        &["uploader"],
        &["uploaders"],
        &["uploading"],
        &["uploads"],
    ],
    range: 2..=7,
};

static WORD_UPH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UPH_CHILDREN),
    value: None,
};

pub static WORD_UPH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("olstry")],
    values: &[&["upholstery"]],
    range: 6..=6,
};

static WORD_UPG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UPG_CHILDREN),
    value: None,
};

pub static WORD_UPG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ade"),
        dictgen::InsensitiveStr::Ascii("arde"),
        dictgen::InsensitiveStr::Ascii("arded"),
        dictgen::InsensitiveStr::Ascii("ardes"),
        dictgen::InsensitiveStr::Ascii("arding"),
        dictgen::InsensitiveStr::Ascii("arte"),
        dictgen::InsensitiveStr::Ascii("radded"),
        dictgen::InsensitiveStr::Ascii("radei"),
        dictgen::InsensitiveStr::Ascii("radingn"),
        dictgen::InsensitiveStr::Ascii("rads"),
        dictgen::InsensitiveStr::Ascii("rate"),
    ],
    values: &[
        &["upgrade"],
        &["upgrade"],
        &["upgraded"],
        &["upgrades"],
        &["upgrading"],
        &["upgrade"],
        &["upgraded"],
        &["upgrade"],
        &["upgrading"],
        &["upgrades"],
        &["upgrade"],
    ],
    range: 3..=7,
};

static WORD_UPE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UPE_CHILDREN),
    value: None,
};

pub static WORD_UPE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("rclass")],
    values: &[&["upperclass"]],
    range: 6..=6,
};

static WORD_UPD_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UPD_CHILDREN),
    value: None,
};

pub static WORD_UPD_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("at"),
        dictgen::InsensitiveStr::Ascii("ateded"),
        dictgen::InsensitiveStr::Ascii("ateed"),
        dictgen::InsensitiveStr::Ascii("atees"),
        dictgen::InsensitiveStr::Ascii("ateing"),
        dictgen::InsensitiveStr::Ascii("atig"),
        dictgen::InsensitiveStr::Ascii("ats"),
        dictgen::InsensitiveStr::Ascii("grade"),
        dictgen::InsensitiveStr::Ascii("rage"),
        dictgen::InsensitiveStr::Ascii("te"),
    ],
    values: &[
        &["update"],
        &["updated"],
        &["updated"],
        &["updates"],
        &["updating"],
        &["updating"],
        &["updates"],
        &["upgrade"],
        &["upgrade"],
        &["update"],
    ],
    range: 2..=6,
};

static WORD_UPC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UPC_CHILDREN),
    value: None,
};

pub static WORD_UPC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("omming")],
    values: &[&["upcoming"]],
    range: 6..=6,
};

static WORD_UPA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UPA_CHILDREN),
    value: None,
};

pub static WORD_UPA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("date"),
        dictgen::InsensitiveStr::Ascii("dated"),
        dictgen::InsensitiveStr::Ascii("dater"),
        dictgen::InsensitiveStr::Ascii("dates"),
        dictgen::InsensitiveStr::Ascii("dating"),
        dictgen::InsensitiveStr::Ascii("dte"),
        dictgen::InsensitiveStr::Ascii("dted"),
        dictgen::InsensitiveStr::Ascii("dter"),
        dictgen::InsensitiveStr::Ascii("dters"),
        dictgen::InsensitiveStr::Ascii("dtes"),
        dictgen::InsensitiveStr::Ascii("grade"),
        dictgen::InsensitiveStr::Ascii("graded"),
        dictgen::InsensitiveStr::Ascii("te"),
        dictgen::InsensitiveStr::Ascii("ted"),
        dictgen::InsensitiveStr::Ascii("ter"),
        dictgen::InsensitiveStr::Ascii("tes"),
        dictgen::InsensitiveStr::Ascii("ting"),
    ],
    values: &[
        &["update"],
        &["updated"],
        &["updater"],
        &["updates"],
        &["updating"],
        &["update"],
        &["updated"],
        &["updater"],
        &["updaters"],
        &["updates"],
        &["upgrade"],
        &["upgraded"],
        &["update"],
        &["updated"],
        &["updater"],
        &["updates"],
        &["updating"],
    ],
    range: 2..=6,
};

static WORD_UN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_UN_CHILDREN),
    value: None,
};

static WORD_UN_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_UNA_NODE),
    Some(&WORD_UNB_NODE),
    Some(&WORD_UNC_NODE),
    Some(&WORD_UND_NODE),
    Some(&WORD_UNE_NODE),
    Some(&WORD_UNF_NODE),
    Some(&WORD_UNG_NODE),
    Some(&WORD_UNH_NODE),
    Some(&WORD_UNI_NODE),
    Some(&WORD_UNJ_NODE),
    Some(&WORD_UNK_NODE),
    Some(&WORD_UNL_NODE),
    Some(&WORD_UNM_NODE),
    Some(&WORD_UNN_NODE),
    Some(&WORD_UNO_NODE),
    Some(&WORD_UNP_NODE),
    Some(&WORD_UNQ_NODE),
    Some(&WORD_UNR_NODE),
    Some(&WORD_UNS_NODE),
    Some(&WORD_UNT_NODE),
    Some(&WORD_UNU_NODE),
    Some(&WORD_UNV_NODE),
    Some(&WORD_UNW_NODE),
    Some(&WORD_UNX_NODE),
    None,
    Some(&WORD_UNZ_NODE),
];

static WORD_UNZ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNZ_CHILDREN),
    value: None,
};

pub static WORD_UNZ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("iped")],
    values: &[&["unzipped"]],
    range: 4..=4,
};

static WORD_UNX_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNX_CHILDREN),
    value: Some(&["unix"]),
};

pub static WORD_UNX_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("epected"),
        dictgen::InsensitiveStr::Ascii("epectedly"),
        dictgen::InsensitiveStr::Ascii("pected"),
    ],
    values: &[&["unexpected"], &["unexpectedly"], &["unexpected"]],
    range: 6..=9,
};

static WORD_UNW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNW_CHILDREN),
    value: None,
};

pub static WORD_UNW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arrented"),
        dictgen::InsensitiveStr::Ascii("eildly"),
        dictgen::InsensitiveStr::Ascii("ieldly"),
        dictgen::InsensitiveStr::Ascii("irtten"),
        dictgen::InsensitiveStr::Ascii("orhty"),
        dictgen::InsensitiveStr::Ascii("orthly"),
        dictgen::InsensitiveStr::Ascii("orty"),
        dictgen::InsensitiveStr::Ascii("raped"),
        dictgen::InsensitiveStr::Ascii("rittern"),
        dictgen::InsensitiveStr::Ascii("rritten"),
    ],
    values: &[
        &["unwarranted"],
        &["unwieldy"],
        &["unwieldy"],
        &["unwritten"],
        &["unworthy"],
        &["unworthy"],
        &["unworthy"],
        &["unwrapped"],
        &["unwritten"],
        &["unwritten"],
    ],
    range: 4..=8,
};

static WORD_UNV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNV_CHILDREN),
    value: None,
};

pub static WORD_UNV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ailable"),
        dictgen::InsensitiveStr::Ascii("alid"),
        dictgen::InsensitiveStr::Ascii("alidate"),
        dictgen::InsensitiveStr::Ascii("elievable"),
        dictgen::InsensitiveStr::Ascii("elievably"),
        dictgen::InsensitiveStr::Ascii("erfified"),
        dictgen::InsensitiveStr::Ascii("ersionned"),
        dictgen::InsensitiveStr::Ascii("ersoned"),
        dictgen::InsensitiveStr::Ascii("iersally"),
        dictgen::InsensitiveStr::Ascii("ierse"),
        dictgen::InsensitiveStr::Ascii("ierses"),
        dictgen::InsensitiveStr::Ascii("iersities"),
        dictgen::InsensitiveStr::Ascii("iersity"),
        dictgen::InsensitiveStr::Ascii("ulnerable"),
    ],
    values: &[
        &["unavailable"],
        &["invalid"],
        &["invalidate"],
        &["unbelievable"],
        &["unbelievably"],
        &["unverified"],
        &["unversioned"],
        &["unversioned"],
        &["universally"],
        &["universe"],
        &["universes"],
        &["universities"],
        &["university"],
        &["invulnerable"],
    ],
    range: 4..=9,
};

static WORD_UNU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNU_CHILDREN),
    value: None,
};

pub static WORD_UNU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("nsed"),
        dictgen::InsensitiveStr::Ascii("nsual"),
        dictgen::InsensitiveStr::Ascii("sabe"),
        dictgen::InsensitiveStr::Ascii("sal"),
        dictgen::InsensitiveStr::Ascii("sally"),
        dictgen::InsensitiveStr::Ascii("saully"),
        dictgen::InsensitiveStr::Ascii("seable"),
        dictgen::InsensitiveStr::Ascii("seful"),
        dictgen::InsensitiveStr::Ascii("sre"),
        dictgen::InsensitiveStr::Ascii("suable"),
        dictgen::InsensitiveStr::Ascii("sualy"),
    ],
    values: &[
        &["unused"],
        &["unused"],
        &["unusual"],
        &["unusable"],
        &["unusual"],
        &["unusually"],
        &["unusually"],
        &["unusable"],
        &["useless"],
        &["unsure"],
        &["unusable"],
        &["unusually"],
    ],
    range: 2..=6,
};

static WORD_UNT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNT_CHILDREN),
    value: None,
};

pub static WORD_UNT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("argetted"),
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("ill"),
        dictgen::InsensitiveStr::Ascii("ils"),
        dictgen::InsensitiveStr::Ascii("intuitive"),
        dictgen::InsensitiveStr::Ascii("oched"),
        dictgen::InsensitiveStr::Ascii("queue"),
        dictgen::InsensitiveStr::Ascii("rached"),
        dictgen::InsensitiveStr::Ascii("raind"),
        dictgen::InsensitiveStr::Ascii("ranslateable"),
        dictgen::InsensitiveStr::Ascii("rasform"),
        dictgen::InsensitiveStr::Ascii("rasformed"),
        dictgen::InsensitiveStr::Ascii("rasposed"),
        dictgen::InsensitiveStr::Ascii("rianed"),
        dictgen::InsensitiveStr::Ascii("rustworty"),
    ],
    values: &[
        &["untargeted"],
        &["under"],
        &["until"],
        &["until", "utils"],
        &["unintuitive"],
        &["untouched"],
        &["unqueue"],
        &["untracked"],
        &["untrained"],
        &["untranslatable"],
        &["untransform"],
        &["untransformed"],
        &["untransposed"],
        &["untrained"],
        &["untrustworthy"],
    ],
    range: 2..=12,
};

static WORD_UNS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_UNS_CHILDREN),
    value: None,
};

static WORD_UNS_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_UNSA_NODE),
    None,
    Some(&WORD_UNSC_NODE),
    None,
    Some(&WORD_UNSE_NODE),
    None,
    None,
    Some(&WORD_UNSH_NODE),
    Some(&WORD_UNSI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_UNSO_NODE),
    Some(&WORD_UNSP_NODE),
    None,
    None,
    None,
    Some(&WORD_UNST_NODE),
    Some(&WORD_UNSU_NODE),
    None,
    Some(&WORD_UNSW_NODE),
    None,
    Some(&WORD_UNSY_NODE),
    None,
];

static WORD_UNSY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSY_CHILDREN),
    value: None,
};

pub static WORD_UNSY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("chronise"),
        dictgen::InsensitiveStr::Ascii("chronised"),
        dictgen::InsensitiveStr::Ascii("chronize"),
        dictgen::InsensitiveStr::Ascii("chronized"),
    ],
    values: &[
        &["unsynchronise"],
        &["unsynchronised"],
        &["unsynchronize"],
        &["unsynchronized"],
    ],
    range: 8..=9,
};

static WORD_UNSW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSW_CHILDREN),
    value: None,
};

pub static WORD_UNSW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ithced")],
    values: &[&["unswitched"]],
    range: 6..=6,
};

static WORD_UNSU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_UNSU_CHILDREN),
    value: None,
};

static WORD_UNSU_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_UNSUA_NODE),
    Some(&WORD_UNSUB_NODE),
    Some(&WORD_UNSUC_NODE),
    None,
    Some(&WORD_UNSUE_NODE),
    Some(&WORD_UNSUF_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_UNSUN_NODE),
    None,
    Some(&WORD_UNSUP_NODE),
    None,
    Some(&WORD_UNSUR_NODE),
    Some(&WORD_UNSUS_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_UNSUS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSUS_CHILDREN),
    value: None,
};

pub static WORD_UNSUS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bcribe"),
        dictgen::InsensitiveStr::Ascii("bcribed"),
        dictgen::InsensitiveStr::Ascii("btantiated"),
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("tainble"),
        dictgen::InsensitiveStr::Ascii("tainible"),
        dictgen::InsensitiveStr::Ascii("tianable"),
    ],
    values: &[
        &["unsubscribe"],
        &["unsubscribed"],
        &["unsubstantiated"],
        &["unused"],
        &["unsustainable"],
        &["unsustainable"],
        &["unsustainable"],
    ],
    range: 2..=10,
};

static WORD_UNSUR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSUR_CHILDREN),
    value: None,
};

pub static WORD_UNSUR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("prized"),
        dictgen::InsensitiveStr::Ascii("prizing"),
        dictgen::InsensitiveStr::Ascii("prizingly"),
    ],
    values: &[&["unsurprised"], &["unsurprising"], &["unsurprisingly"]],
    range: 6..=9,
};

static WORD_UNSUP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSUP_CHILDREN),
    value: None,
};

pub static WORD_UNSUP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ortable"),
        dictgen::InsensitiveStr::Ascii("orted"),
        dictgen::InsensitiveStr::Ascii("port"),
        dictgen::InsensitiveStr::Ascii("proted"),
        dictgen::InsensitiveStr::Ascii("ress"),
        dictgen::InsensitiveStr::Ascii("ressed"),
        dictgen::InsensitiveStr::Ascii("resses"),
        dictgen::InsensitiveStr::Ascii("rised"),
        dictgen::InsensitiveStr::Ascii("rising"),
        dictgen::InsensitiveStr::Ascii("risingly"),
        dictgen::InsensitiveStr::Ascii("rized"),
        dictgen::InsensitiveStr::Ascii("rizing"),
        dictgen::InsensitiveStr::Ascii("rizingly"),
    ],
    values: &[
        &["unsupportable"],
        &["unsupported"],
        &["unsupported"],
        &["unsupported"],
        &["unsuppress"],
        &["unsuppressed"],
        &["unsuppresses"],
        &["unsurprised"],
        &["unsurprising"],
        &["unsurprisingly"],
        &["unsurprised"],
        &["unsurprising"],
        &["unsurprisingly"],
    ],
    range: 4..=8,
};

static WORD_UNSUN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSUN_CHILDREN),
    value: None,
};

pub static WORD_UNSUN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("scribe"),
        dictgen::InsensitiveStr::Ascii("scribed"),
    ],
    values: &[&["unsubscribe"], &["unsubscribed"]],
    range: 6..=7,
};

static WORD_UNSUF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSUF_CHILDREN),
    value: None,
};

pub static WORD_UNSUF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ficient")],
    values: &[&["insufficient"]],
    range: 7..=7,
};

static WORD_UNSUE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSUE_CHILDREN),
    value: None,
};

pub static WORD_UNSUE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("d")],
    values: &[&["unused"]],
    range: 1..=1,
};

static WORD_UNSUC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSUC_CHILDREN),
    value: None,
};

pub static WORD_UNSUC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ccessful"),
        dictgen::InsensitiveStr::Ascii("ccessfully"),
        dictgen::InsensitiveStr::Ascii("ccessul"),
        dictgen::InsensitiveStr::Ascii("ccessully"),
        dictgen::InsensitiveStr::Ascii("cesful"),
        dictgen::InsensitiveStr::Ascii("cesfull"),
        dictgen::InsensitiveStr::Ascii("cesfully"),
        dictgen::InsensitiveStr::Ascii("cessfull"),
        dictgen::InsensitiveStr::Ascii("cessfullly"),
        dictgen::InsensitiveStr::Ascii("cessul"),
        dictgen::InsensitiveStr::Ascii("esful"),
        dictgen::InsensitiveStr::Ascii("esfull"),
        dictgen::InsensitiveStr::Ascii("esfully"),
        dictgen::InsensitiveStr::Ascii("esfuly"),
        dictgen::InsensitiveStr::Ascii("essefully"),
        dictgen::InsensitiveStr::Ascii("essflly"),
        dictgen::InsensitiveStr::Ascii("essfually"),
        dictgen::InsensitiveStr::Ascii("essful"),
        dictgen::InsensitiveStr::Ascii("essfull"),
        dictgen::InsensitiveStr::Ascii("essfully"),
        dictgen::InsensitiveStr::Ascii("essfuly"),
        dictgen::InsensitiveStr::Ascii("esssful"),
        dictgen::InsensitiveStr::Ascii("esssfull"),
        dictgen::InsensitiveStr::Ascii("esssfully"),
        dictgen::InsensitiveStr::Ascii("esssfuly"),
        dictgen::InsensitiveStr::Ascii("essufll"),
        dictgen::InsensitiveStr::Ascii("essuflly"),
        dictgen::InsensitiveStr::Ascii("essully"),
    ],
    values: &[
        &["unsuccessful"],
        &["unsuccessfully"],
        &["unsuccessful"],
        &["unsuccessfully"],
        &["unsuccessful"],
        &["unsuccessful"],
        &["unsuccessfully"],
        &["unsuccessful"],
        &["unsuccessfully"],
        &["unsuccessful"],
        &["unsuccessful"],
        &["unsuccessful"],
        &["unsuccessfully"],
        &["unsuccessfully"],
        &["unsuccessfully"],
        &["unsuccessfully"],
        &["unsuccessfully"],
        &["unsuccessful"],
        &["unsuccessful"],
        &["unsuccessfully"],
        &["unsuccessfully"],
        &["unsuccessful"],
        &["unsuccessful"],
        &["unsuccessfully"],
        &["unsuccessfully"],
        &["unsuccessful"],
        &["unsuccessfully"],
        &["unsuccessfully"],
    ],
    range: 5..=10,
};

static WORD_UNSUB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSUB_CHILDREN),
    value: None,
};

pub static WORD_UNSUB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("scibe"),
        dictgen::InsensitiveStr::Ascii("scibed"),
        dictgen::InsensitiveStr::Ascii("scibing"),
        dictgen::InsensitiveStr::Ascii("scirbe"),
        dictgen::InsensitiveStr::Ascii("scirbed"),
        dictgen::InsensitiveStr::Ascii("scirbing"),
        dictgen::InsensitiveStr::Ascii("scirption"),
        dictgen::InsensitiveStr::Ascii("scirptions"),
        dictgen::InsensitiveStr::Ascii("scrbe"),
        dictgen::InsensitiveStr::Ascii("scrbed"),
        dictgen::InsensitiveStr::Ascii("scribade"),
        dictgen::InsensitiveStr::Ascii("scribbed"),
        dictgen::InsensitiveStr::Ascii("scrible"),
        dictgen::InsensitiveStr::Ascii("scrided"),
        dictgen::InsensitiveStr::Ascii("scried"),
        dictgen::InsensitiveStr::Ascii("scripe"),
        dictgen::InsensitiveStr::Ascii("scriped"),
        dictgen::InsensitiveStr::Ascii("scritpion"),
        dictgen::InsensitiveStr::Ascii("scritpions"),
        dictgen::InsensitiveStr::Ascii("scritpiton"),
        dictgen::InsensitiveStr::Ascii("scritpitons"),
        dictgen::InsensitiveStr::Ascii("scritption"),
        dictgen::InsensitiveStr::Ascii("scritptions"),
        dictgen::InsensitiveStr::Ascii("scrive"),
        dictgen::InsensitiveStr::Ascii("scrube"),
        dictgen::InsensitiveStr::Ascii("scrubed"),
        dictgen::InsensitiveStr::Ascii("srcibe"),
        dictgen::InsensitiveStr::Ascii("srcibed"),
        dictgen::InsensitiveStr::Ascii("stanciated"),
        dictgen::InsensitiveStr::Ascii("stansiated"),
        dictgen::InsensitiveStr::Ascii("stantiaed"),
        dictgen::InsensitiveStr::Ascii("stantianted"),
        dictgen::InsensitiveStr::Ascii("stantiative"),
    ],
    values: &[
        &["unsubscribe"],
        &["unsubscribed"],
        &["unsubscribing"],
        &["unsubscribe"],
        &["unsubscribed"],
        &["unsubscribing"],
        &["unsubscription"],
        &["unsubscriptions"],
        &["unsubscribe"],
        &["unsubscribed"],
        &["unsubscribed"],
        &["unsubscribe"],
        &["unsubscribed"],
        &["unsubscribed"],
        &["unsubscribed"],
        &["unsubscribe"],
        &["unsubscribed"],
        &["unsubscription"],
        &["unsubscriptions"],
        &["unsubscription"],
        &["unsubscriptions"],
        &["unsubscription"],
        &["unsubscriptions"],
        &["unsubscribe"],
        &["unsubscribe"],
        &["unsubscribed"],
        &["unsubscribe"],
        &["unsubscribed"],
        &["unsubstantiated"],
        &["unsubstantiated"],
        &["unsubstantiated"],
        &["unsubstantiated"],
        &["unsubstantiated"],
    ],
    range: 5..=11,
};

static WORD_UNSUA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSUA_CHILDREN),
    value: None,
};

pub static WORD_UNSUA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ble"),
        dictgen::InsensitiveStr::Ascii("l"),
    ],
    values: &[&["unusable"], &["unusual"]],
    range: 1..=3,
};

static WORD_UNST_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNST_CHILDREN),
    value: None,
};

pub static WORD_UNST_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("abel"),
        dictgen::InsensitiveStr::Ascii("all"),
        dictgen::InsensitiveStr::Ascii("allation"),
        dictgen::InsensitiveStr::Ascii("alled"),
        dictgen::InsensitiveStr::Ascii("aller"),
        dictgen::InsensitiveStr::Ascii("alles"),
        dictgen::InsensitiveStr::Ascii("alling"),
        dictgen::InsensitiveStr::Ascii("alls"),
    ],
    values: &[
        &["unstable"],
        &["install", "uninstall"],
        &["installation", "uninstallation"],
        &["installed", "uninstalled"],
        &["installer", "uninstaller"],
        &["installs", "uninstalls"],
        &["installing", "uninstalling"],
        &["installs", "uninstalls"],
    ],
    range: 3..=8,
};

static WORD_UNSP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSP_CHILDREN),
    value: None,
};

pub static WORD_UNSP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ecificed"),
        dictgen::InsensitiveStr::Ascii("efcifieid"),
        dictgen::InsensitiveStr::Ascii("efeid"),
        dictgen::InsensitiveStr::Ascii("eficed"),
        dictgen::InsensitiveStr::Ascii("eficeid"),
        dictgen::InsensitiveStr::Ascii("eficialleid"),
        dictgen::InsensitiveStr::Ascii("eficiallied"),
        dictgen::InsensitiveStr::Ascii("eficiallifed"),
        dictgen::InsensitiveStr::Ascii("eficied"),
        dictgen::InsensitiveStr::Ascii("eficieid"),
        dictgen::InsensitiveStr::Ascii("eficifed"),
        dictgen::InsensitiveStr::Ascii("eficifeid"),
        dictgen::InsensitiveStr::Ascii("eficified"),
        dictgen::InsensitiveStr::Ascii("eficififed"),
        dictgen::InsensitiveStr::Ascii("eficiied"),
        dictgen::InsensitiveStr::Ascii("eficiifed"),
        dictgen::InsensitiveStr::Ascii("eficilleid"),
        dictgen::InsensitiveStr::Ascii("eficillied"),
        dictgen::InsensitiveStr::Ascii("eficillifed"),
        dictgen::InsensitiveStr::Ascii("eficiteid"),
        dictgen::InsensitiveStr::Ascii("eficitied"),
        dictgen::InsensitiveStr::Ascii("eficitifed"),
        dictgen::InsensitiveStr::Ascii("efied"),
        dictgen::InsensitiveStr::Ascii("efifed"),
        dictgen::InsensitiveStr::Ascii("efifeid"),
        dictgen::InsensitiveStr::Ascii("efified"),
        dictgen::InsensitiveStr::Ascii("efififed"),
        dictgen::InsensitiveStr::Ascii("efiied"),
        dictgen::InsensitiveStr::Ascii("efiifeid"),
        dictgen::InsensitiveStr::Ascii("efiified"),
        dictgen::InsensitiveStr::Ascii("efiififed"),
        dictgen::InsensitiveStr::Ascii("efixeid"),
        dictgen::InsensitiveStr::Ascii("efixied"),
        dictgen::InsensitiveStr::Ascii("efixifed"),
        dictgen::InsensitiveStr::Ascii("ported"),
    ],
    values: &[
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unspecified"],
        &["unsupported"],
    ],
    range: 5..=12,
};

static WORD_UNSO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSO_CHILDREN),
    value: None,
};

pub static WORD_UNSO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("clicited"),
        dictgen::InsensitiveStr::Ascii("licated"),
        dictgen::InsensitiveStr::Ascii("liciated"),
        dictgen::InsensitiveStr::Ascii("licitied"),
        dictgen::InsensitiveStr::Ascii("licted"),
        dictgen::InsensitiveStr::Ascii("liticed"),
        dictgen::InsensitiveStr::Ascii("locited"),
    ],
    values: &[
        &["unsolicited"],
        &["unsolicited"],
        &["unsolicited"],
        &["unsolicited"],
        &["unsolicited"],
        &["unsolicited"],
        &["unsolicited"],
    ],
    range: 6..=8,
};

static WORD_UNSI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSI_CHILDREN),
    value: None,
};

pub static WORD_UNSI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bscribed"),
        dictgen::InsensitiveStr::Ascii("bstantiated"),
        dictgen::InsensitiveStr::Ascii("ged"),
        dictgen::InsensitiveStr::Ascii("gnificant"),
        dictgen::InsensitiveStr::Ascii("nged"),
        dictgen::InsensitiveStr::Ascii("ntalled"),
        dictgen::InsensitiveStr::Ascii("stainable"),
    ],
    values: &[
        &["unsubscribed"],
        &["unsubstantiated"],
        &["unsigned"],
        &["insignificant"],
        &["unsigned"],
        &["uninstalled"],
        &["unsustainable"],
    ],
    range: 3..=11,
};

static WORD_UNSH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSH_CHILDREN),
    value: None,
};

pub static WORD_UNSH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("arable")],
    values: &[&["unshareable"]],
    range: 6..=6,
};

static WORD_UNSE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSE_CHILDREN),
    value: None,
};

pub static WORD_UNSE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arcahble"),
        dictgen::InsensitiveStr::Ascii("ccessful"),
        dictgen::InsensitiveStr::Ascii("d"),
        dictgen::InsensitiveStr::Ascii("lcted"),
        dictgen::InsensitiveStr::Ascii("lctes"),
        dictgen::InsensitiveStr::Ascii("lcting"),
        dictgen::InsensitiveStr::Ascii("lcts"),
        dictgen::InsensitiveStr::Ascii("lecgt"),
        dictgen::InsensitiveStr::Ascii("lecgted"),
        dictgen::InsensitiveStr::Ascii("lecgtes"),
        dictgen::InsensitiveStr::Ascii("lecgting"),
        dictgen::InsensitiveStr::Ascii("lecgts"),
        dictgen::InsensitiveStr::Ascii("lectabe"),
        dictgen::InsensitiveStr::Ascii("ncored"),
        dictgen::InsensitiveStr::Ascii("pcified"),
        dictgen::InsensitiveStr::Ascii("r"),
        dictgen::InsensitiveStr::Ascii("specting"),
        dictgen::InsensitiveStr::Ascii("ting"),
        dictgen::InsensitiveStr::Ascii("tlling"),
        dictgen::InsensitiveStr::Ascii("ttin"),
        dictgen::InsensitiveStr::Ascii("ttleing"),
    ],
    values: &[
        &["unsearchable"],
        &["unsuccessful"],
        &["used", "unused"],
        &["unselected"],
        &["unselects"],
        &["unselecting"],
        &["unselects"],
        &["unselect"],
        &["unselected"],
        &["unselects"],
        &["unselecting"],
        &["unselects"],
        &["unselectable"],
        &["uncensored"],
        &["unspecified"],
        &["under", "unset", "unsure", "user"],
        &["unsuspecting"],
        &["unsetting"],
        &["unsettling"],
        &["unsetting"],
        &["unsettling"],
    ],
    range: 1..=8,
};

static WORD_UNSC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSC_CHILDREN),
    value: None,
};

pub static WORD_UNSC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cessful"),
        dictgen::InsensitiveStr::Ascii("ubscribe"),
        dictgen::InsensitiveStr::Ascii("ubscribed"),
    ],
    values: &[&["unsuccessful"], &["subscribe"], &["subscribed"]],
    range: 7..=9,
};

static WORD_UNSA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNSA_CHILDREN),
    value: None,
};

pub static WORD_UNSA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ble")],
    values: &[&["unusable", "usable", "unstable"]],
    range: 3..=3,
};

static WORD_UNR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_UNR_CHILDREN),
    value: None,
};

static WORD_UNR_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_UNRA_NODE),
    None,
    None,
    None,
    Some(&WORD_UNRE_NODE),
    None,
    Some(&WORD_UNRG_NODE),
    None,
    Some(&WORD_UNRI_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_UNRN_NODE),
    Some(&WORD_UNRO_NODE),
    Some(&WORD_UNRP_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_UNRW_NODE),
    None,
    None,
    None,
];

static WORD_UNRW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNRW_CHILDREN),
    value: None,
};

pub static WORD_UNRW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("itten")],
    values: &[&["unwritten"]],
    range: 5..=5,
};

static WORD_UNRP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNRP_CHILDREN),
    value: None,
};

pub static WORD_UNRP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("oven")],
    values: &[&["unproven"]],
    range: 4..=4,
};

static WORD_UNRO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNRO_CHILDREN),
    value: None,
};

pub static WORD_UNRO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ated"),
        dictgen::InsensitiveStr::Ascii("sponsive"),
    ],
    values: &[&["unrotated"], &["unresponsive"]],
    range: 4..=8,
};

static WORD_UNRN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNRN_CHILDREN),
    value: None,
};

pub static WORD_UNRN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("aked")],
    values: &[&["unranked"]],
    range: 4..=4,
};

static WORD_UNRI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNRI_CHILDREN),
    value: None,
};

pub static WORD_UNRI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("stricted")],
    values: &[&["unrestricted"]],
    range: 8..=8,
};

static WORD_UNRG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNRG_CHILDREN),
    value: None,
};

pub static WORD_UNRG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("esiter")],
    values: &[&["unregister"]],
    range: 6..=6,
};

static WORD_UNRE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_UNRE_CHILDREN),
    value: None,
};

static WORD_UNRE_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_UNREA_NODE),
    None,
    Some(&WORD_UNREC_NODE),
    None,
    None,
    None,
    Some(&WORD_UNREG_NODE),
    None,
    Some(&WORD_UNREI_NODE),
    None,
    None,
    Some(&WORD_UNREL_NODE),
    None,
    None,
    None,
    Some(&WORD_UNREP_NODE),
    None,
    None,
    Some(&WORD_UNRES_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_UNRES_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNRES_CHILDREN),
    value: None,
};

pub static WORD_UNRES_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gister"),
        dictgen::InsensitiveStr::Ascii("gisterd"),
        dictgen::InsensitiveStr::Ascii("gistered"),
        dictgen::InsensitiveStr::Ascii("gisters"),
        dictgen::InsensitiveStr::Ascii("onable"),
        dictgen::InsensitiveStr::Ascii("poncive"),
        dictgen::InsensitiveStr::Ascii("ponisve"),
        dictgen::InsensitiveStr::Ascii("ponive"),
        dictgen::InsensitiveStr::Ascii("ponse"),
        dictgen::InsensitiveStr::Ascii("ponsibe"),
        dictgen::InsensitiveStr::Ascii("ponsivness"),
        dictgen::InsensitiveStr::Ascii("posive"),
        dictgen::InsensitiveStr::Ascii("tircted"),
        dictgen::InsensitiveStr::Ascii("trcited"),
        dictgen::InsensitiveStr::Ascii("triced"),
        dictgen::InsensitiveStr::Ascii("trictred"),
    ],
    values: &[
        &["unregister"],
        &["unregistered"],
        &["unregistered"],
        &["unregisters"],
        &["unreasonable"],
        &["unresponsive"],
        &["unresponsive"],
        &["unresponsive"],
        &["unresponsive"],
        &["unresponsive"],
        &["unresponsive"],
        &["unresponsive"],
        &["unrestricted"],
        &["unrestricted"],
        &["unrestricted"],
        &["unrestricted"],
    ],
    range: 5..=10,
};

static WORD_UNREP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNREP_CHILDREN),
    value: None,
};

pub static WORD_UNREP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("entent"),
        dictgen::InsensitiveStr::Ascii("etant"),
        dictgen::InsensitiveStr::Ascii("etent"),
        dictgen::InsensitiveStr::Ascii("lacable"),
        dictgen::InsensitiveStr::Ascii("lacalbe"),
        dictgen::InsensitiveStr::Ascii("roducable"),
        dictgen::InsensitiveStr::Ascii("sonsive"),
    ],
    values: &[
        &["unrepentant"],
        &["unrepentant"],
        &["unrepentant"],
        &["unreplaceable"],
        &["unreplaceable"],
        &["unreproducible"],
        &["unresponsive"],
    ],
    range: 5..=9,
};

static WORD_UNREL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNREL_CHILDREN),
    value: None,
};

pub static WORD_UNREL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aible"),
        dictgen::InsensitiveStr::Ascii("atd"),
        dictgen::InsensitiveStr::Ascii("eated"),
        dictgen::InsensitiveStr::Ascii("iabe"),
        dictgen::InsensitiveStr::Ascii("ted"),
        dictgen::InsensitiveStr::Ascii("yable"),
        dictgen::InsensitiveStr::Ascii("ying"),
    ],
    values: &[
        &["unreliable"],
        &["unrelated"],
        &["unreleased", "unrelated"],
        &["unreliable"],
        &["unrelated"],
        &["unreliable"],
        &["underlying"],
    ],
    range: 3..=5,
};

static WORD_UNREI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNREI_CHILDREN),
    value: None,
};

pub static WORD_UNREI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gister"),
        dictgen::InsensitiveStr::Ascii("gster"),
        dictgen::InsensitiveStr::Ascii("gstered"),
        dictgen::InsensitiveStr::Ascii("gstering"),
        dictgen::InsensitiveStr::Ascii("gsters"),
    ],
    values: &[
        &["unregister"],
        &["unregister"],
        &["unregistered"],
        &["unregistering"],
        &["unregisters"],
    ],
    range: 5..=8,
};

static WORD_UNREG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNREG_CHILDREN),
    value: None,
};

pub static WORD_UNREG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ester"),
        dictgen::InsensitiveStr::Ascii("iste"),
        dictgen::InsensitiveStr::Ascii("isted"),
        dictgen::InsensitiveStr::Ascii("isteing"),
        dictgen::InsensitiveStr::Ascii("isterd"),
        dictgen::InsensitiveStr::Ascii("isteres"),
        dictgen::InsensitiveStr::Ascii("istert"),
        dictgen::InsensitiveStr::Ascii("istes"),
        dictgen::InsensitiveStr::Ascii("isting"),
        dictgen::InsensitiveStr::Ascii("istred"),
        dictgen::InsensitiveStr::Ascii("istrs"),
        dictgen::InsensitiveStr::Ascii("iter"),
        dictgen::InsensitiveStr::Ascii("iters"),
        dictgen::InsensitiveStr::Ascii("luated"),
        dictgen::InsensitiveStr::Ascii("nized"),
        dictgen::InsensitiveStr::Ascii("ognised"),
        dictgen::InsensitiveStr::Ascii("siter"),
        dictgen::InsensitiveStr::Ascii("sitered"),
        dictgen::InsensitiveStr::Ascii("sitering"),
        dictgen::InsensitiveStr::Ascii("siters"),
        dictgen::InsensitiveStr::Ascii("ster"),
        dictgen::InsensitiveStr::Ascii("stered"),
        dictgen::InsensitiveStr::Ascii("stering"),
        dictgen::InsensitiveStr::Ascii("sters"),
        dictgen::InsensitiveStr::Ascii("ualted"),
        dictgen::InsensitiveStr::Ascii("ulared"),
    ],
    values: &[
        &["unregister"],
        &["unregister"],
        &["unregistered"],
        &["registering"],
        &["unregistered"],
        &["unregisters"],
        &["unregistered"],
        &["unregisters"],
        &["unregistering"],
        &["unregistered"],
        &["unregisters"],
        &["unregister"],
        &["unregisters"],
        &["unregulated"],
        &["unrecognized"],
        &["unrecognised"],
        &["unregister"],
        &["unregistered"],
        &["unregistering"],
        &["unregisters"],
        &["unregister"],
        &["unregistered"],
        &["unregistering"],
        &["unregisters"],
        &["unregulated"],
        &["unregulated"],
    ],
    range: 4..=8,
};

static WORD_UNREC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNREC_CHILDREN),
    value: None,
};

pub static WORD_UNREC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hable"),
        dictgen::InsensitiveStr::Ascii("ocnized"),
        dictgen::InsensitiveStr::Ascii("oginized"),
        dictgen::InsensitiveStr::Ascii("ogized"),
        dictgen::InsensitiveStr::Ascii("ognixed"),
        dictgen::InsensitiveStr::Ascii("onized"),
        dictgen::InsensitiveStr::Ascii("ovable"),
        dictgen::InsensitiveStr::Ascii("ovarable"),
        dictgen::InsensitiveStr::Ascii("overd"),
    ],
    values: &[
        &["unreachable"],
        &["unrecognized"],
        &["unrecognized"],
        &["unrecognized"],
        &["unrecognized"],
        &["unrecognized"],
        &["unrecoverable"],
        &["unrecoverable"],
        &["unrecovered"],
    ],
    range: 5..=8,
};

static WORD_UNREA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNREA_CHILDREN),
    value: None,
};

pub static WORD_UNREA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cahable"),
        dictgen::InsensitiveStr::Ascii("cahble"),
        dictgen::InsensitiveStr::Ascii("cheable"),
        dictgen::InsensitiveStr::Ascii("leased"),
        dictgen::InsensitiveStr::Ascii("lesed"),
        dictgen::InsensitiveStr::Ascii("lible"),
        dictgen::InsensitiveStr::Ascii("lisitc"),
        dictgen::InsensitiveStr::Ascii("lisitic"),
        dictgen::InsensitiveStr::Ascii("listc"),
        dictgen::InsensitiveStr::Ascii("listisch"),
        dictgen::InsensitiveStr::Ascii("litic"),
        dictgen::InsensitiveStr::Ascii("lsitic"),
        dictgen::InsensitiveStr::Ascii("ponsive"),
        dictgen::InsensitiveStr::Ascii("sonabily"),
        dictgen::InsensitiveStr::Ascii("sonablely"),
        dictgen::InsensitiveStr::Ascii("sonabley"),
        dictgen::InsensitiveStr::Ascii("sonablly"),
        dictgen::InsensitiveStr::Ascii("sonal"),
        dictgen::InsensitiveStr::Ascii("sonalby"),
        dictgen::InsensitiveStr::Ascii("sonbly"),
    ],
    values: &[
        &["unreachable"],
        &["unreachable"],
        &["unreachable"],
        &["unreleased"],
        &["unreleased"],
        &["unreliable"],
        &["unrealistic"],
        &["unrealistic"],
        &["unrealistic"],
        &["unrealistic"],
        &["unrealistic"],
        &["unrealistic"],
        &["unresponsive"],
        &["unreasonably"],
        &["unreasonably"],
        &["unreasonably"],
        &["unreasonably"],
        &["unreasonably"],
        &["unreasonably"],
        &["unreasonably"],
    ],
    range: 5..=9,
};

static WORD_UNRA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNRA_CHILDREN),
    value: None,
};

pub static WORD_UNRA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("kned"),
        dictgen::InsensitiveStr::Ascii("nkend"),
    ],
    values: &[&["unranked"], &["unranked"]],
    range: 4..=5,
};

static WORD_UNQ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNQ_CHILDREN),
    value: None,
};

pub static WORD_UNQ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aulified"),
        dictgen::InsensitiveStr::Ascii("iue"),
        dictgen::InsensitiveStr::Ascii("iuely"),
        dictgen::InsensitiveStr::Ascii("iueness"),
        dictgen::InsensitiveStr::Ascii("oute"),
        dictgen::InsensitiveStr::Ascii("outed"),
        dictgen::InsensitiveStr::Ascii("outes"),
        dictgen::InsensitiveStr::Ascii("outing"),
        dictgen::InsensitiveStr::Ascii("ualifed"),
        dictgen::InsensitiveStr::Ascii("ue"),
    ],
    values: &[
        &["unqualified"],
        &["unique"],
        &["uniquely"],
        &["uniqueness"],
        &["unquote"],
        &["unquoted"],
        &["unquotes"],
        &["unquoting"],
        &["unqualified"],
        &["unique"],
    ],
    range: 2..=8,
};

static WORD_UNP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNP_CHILDREN),
    value: None,
};

pub static WORD_UNP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("acke"),
        dictgen::InsensitiveStr::Ascii("acket"),
        dictgen::InsensitiveStr::Ascii("arseable"),
        dictgen::InsensitiveStr::Ascii("ertubated"),
        dictgen::InsensitiveStr::Ascii("erturbated"),
        dictgen::InsensitiveStr::Ascii("lacable"),
        dictgen::InsensitiveStr::Ascii("layabe"),
        dictgen::InsensitiveStr::Ascii("laybale"),
        dictgen::InsensitiveStr::Ascii("layeble"),
        dictgen::InsensitiveStr::Ascii("lease"),
        dictgen::InsensitiveStr::Ascii("leaseant"),
        dictgen::InsensitiveStr::Ascii("leasent"),
        dictgen::InsensitiveStr::Ascii("lesant"),
        dictgen::InsensitiveStr::Ascii("lesent"),
        dictgen::InsensitiveStr::Ascii("oened"),
        dictgen::InsensitiveStr::Ascii("opluar"),
        dictgen::InsensitiveStr::Ascii("opulair"),
        dictgen::InsensitiveStr::Ascii("ortected"),
        dictgen::InsensitiveStr::Ascii("recendented"),
        dictgen::InsensitiveStr::Ascii("recendeted"),
        dictgen::InsensitiveStr::Ascii("recidented"),
        dictgen::InsensitiveStr::Ascii("recise"),
        dictgen::InsensitiveStr::Ascii("redecented"),
        dictgen::InsensitiveStr::Ascii("redicatable"),
        dictgen::InsensitiveStr::Ascii("redicatble"),
        dictgen::InsensitiveStr::Ascii("redictabe"),
        dictgen::InsensitiveStr::Ascii("redictablity"),
        dictgen::InsensitiveStr::Ascii("redictible"),
        dictgen::InsensitiveStr::Ascii("reductive"),
        dictgen::InsensitiveStr::Ascii("repaired"),
        dictgen::InsensitiveStr::Ascii("reparred"),
        dictgen::InsensitiveStr::Ascii("resedented"),
        dictgen::InsensitiveStr::Ascii("ridictable"),
        dictgen::InsensitiveStr::Ascii("riviliged"),
        dictgen::InsensitiveStr::Ascii("rmopted"),
        dictgen::InsensitiveStr::Ascii("roducive"),
        dictgen::InsensitiveStr::Ascii("roduktive"),
        dictgen::InsensitiveStr::Ascii("rofessinal"),
        dictgen::InsensitiveStr::Ascii("rofessionel"),
        dictgen::InsensitiveStr::Ascii("rofessionnal"),
        dictgen::InsensitiveStr::Ascii("rone"),
        dictgen::InsensitiveStr::Ascii("roteced"),
        dictgen::InsensitiveStr::Ascii("rotexted"),
    ],
    values: &[
        &["unpacked"],
        &["unpacked"],
        &["unparsable"],
        &["unperturbed"],
        &["unperturbed"],
        &["unplayable"],
        &["unplayable"],
        &["unplayable"],
        &["unplayable"],
        &["displease"],
        &["unpleasant"],
        &["unpleasant"],
        &["unpleasant"],
        &["unpleasant"],
        &["unopened"],
        &["unpopular"],
        &["unpopular"],
        &["unprotected"],
        &["unprecedented"],
        &["unprecedented"],
        &["unprecedented"],
        &["imprecise"],
        &["unprecedented"],
        &["unpredictable"],
        &["unpredictable"],
        &["unpredictable"],
        &["unpredictability"],
        &["unpredictable"],
        &["unproductive"],
        &["unprepared"],
        &["unprepared"],
        &["unprecedented"],
        &["unpredictable"],
        &["unprivileged"],
        &["unprompted"],
        &["unproductive"],
        &["unproductive"],
        &["unprofessional"],
        &["unprofessional"],
        &["unprofessional"],
        &["unproven"],
        &["unprotected"],
        &["unprotected"],
    ],
    range: 4..=12,
};

static WORD_UNO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNO_CHILDREN),
    value: None,
};

pub static WORD_UNO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cde"),
        dictgen::InsensitiveStr::Ascii("fficail"),
        dictgen::InsensitiveStr::Ascii("ffical"),
        dictgen::InsensitiveStr::Ascii("ffocial"),
        dictgen::InsensitiveStr::Ascii("in"),
        dictgen::InsensitiveStr::Ascii("mpress"),
        dictgen::InsensitiveStr::Ascii("pend"),
        dictgen::InsensitiveStr::Ascii("penend"),
        dictgen::InsensitiveStr::Ascii("perational"),
        dictgen::InsensitiveStr::Ascii("rderd"),
        dictgen::InsensitiveStr::Ascii("rginial"),
        dictgen::InsensitiveStr::Ascii("riginial"),
        dictgen::InsensitiveStr::Ascii("rigional"),
        dictgen::InsensitiveStr::Ascii("rignial"),
        dictgen::InsensitiveStr::Ascii("rigonal"),
        dictgen::InsensitiveStr::Ascii("rotated"),
        dictgen::InsensitiveStr::Ascii("ticeable"),
    ],
    values: &[
        &["unicode"],
        &["unofficial"],
        &["unofficial"],
        &["unofficial"],
        &["union"],
        &["uncompress"],
        &["unopened"],
        &["unopened"],
        &["nonoperational"],
        &["unordered"],
        &["unoriginal"],
        &["unoriginal"],
        &["unoriginal"],
        &["unoriginal"],
        &["unoriginal"],
        &["unrotated"],
        &["unnoticeable"],
    ],
    range: 2..=10,
};

static WORD_UNN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNN_CHILDREN),
    value: None,
};

pub static WORD_UNN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("acquired"),
        dictgen::InsensitiveStr::Ascii("cessary"),
        dictgen::InsensitiveStr::Ascii("ecassarily"),
        dictgen::InsensitiveStr::Ascii("ecassary"),
        dictgen::InsensitiveStr::Ascii("eccecarily"),
        dictgen::InsensitiveStr::Ascii("eccecary"),
        dictgen::InsensitiveStr::Ascii("eccesarily"),
        dictgen::InsensitiveStr::Ascii("eccesary"),
        dictgen::InsensitiveStr::Ascii("eccessarily"),
        dictgen::InsensitiveStr::Ascii("eccessary"),
        dictgen::InsensitiveStr::Ascii("ecesarily"),
        dictgen::InsensitiveStr::Ascii("ecesarrily"),
        dictgen::InsensitiveStr::Ascii("ecesarry"),
        dictgen::InsensitiveStr::Ascii("ecesary"),
        dictgen::InsensitiveStr::Ascii("ecessairly"),
        dictgen::InsensitiveStr::Ascii("ecessairy"),
        dictgen::InsensitiveStr::Ascii("ecessar"),
        dictgen::InsensitiveStr::Ascii("ecessarely"),
        dictgen::InsensitiveStr::Ascii("ecessarilly"),
        dictgen::InsensitiveStr::Ascii("ecessarity"),
        dictgen::InsensitiveStr::Ascii("ecessarly"),
        dictgen::InsensitiveStr::Ascii("ecesserily"),
        dictgen::InsensitiveStr::Ascii("ecessery"),
        dictgen::InsensitiveStr::Ascii("ecissarily"),
        dictgen::InsensitiveStr::Ascii("ecissary"),
        dictgen::InsensitiveStr::Ascii("ecssary"),
        dictgen::InsensitiveStr::Ascii("edded"),
        dictgen::InsensitiveStr::Ascii("eded"),
        dictgen::InsensitiveStr::Ascii("eedingly"),
        dictgen::InsensitiveStr::Ascii("escessarily"),
        dictgen::InsensitiveStr::Ascii("escessary"),
        dictgen::InsensitiveStr::Ascii("esesarily"),
        dictgen::InsensitiveStr::Ascii("essasary"),
        dictgen::InsensitiveStr::Ascii("essecarily"),
        dictgen::InsensitiveStr::Ascii("essecarry"),
        dictgen::InsensitiveStr::Ascii("essecary"),
        dictgen::InsensitiveStr::Ascii("essesarily"),
        dictgen::InsensitiveStr::Ascii("essesary"),
        dictgen::InsensitiveStr::Ascii("essessarily"),
        dictgen::InsensitiveStr::Ascii("essessary"),
        dictgen::InsensitiveStr::Ascii("ing"),
        dictgen::InsensitiveStr::Ascii("istall"),
        dictgen::InsensitiveStr::Ascii("istalled"),
        dictgen::InsensitiveStr::Ascii("istalling"),
        dictgen::InsensitiveStr::Ascii("necessary"),
        dictgen::InsensitiveStr::Ascii("supported"),
    ],
    values: &[
        &["unacquired"],
        &["unnecessary"],
        &["unnecessarily"],
        &["unnecessary"],
        &["unnecessarily"],
        &["unnecessary"],
        &["unnecessarily"],
        &["unnecessary"],
        &["unnecessarily"],
        &["unnecessary"],
        &["unnecessarily"],
        &["unnecessarily"],
        &["unnecessary"],
        &["unnecessary"],
        &["unnecessarily"],
        &["unnecessarily"],
        &["unnecessary"],
        &["unnecessarily"],
        &["unnecessarily"],
        &["unnecessarily"],
        &["unnecessarily"],
        &["unnecessarily"],
        &["unnecessary"],
        &["unnecessarily"],
        &["unnecessary"],
        &["unnecessary"],
        &["unneeded"],
        &["unneeded"],
        &["unnecessarily"],
        &["unnecessarily"],
        &["unnecessary"],
        &["unnecessarily"],
        &["unnecessary"],
        &["unnecessarily"],
        &["unnecessary"],
        &["unnecessary"],
        &["unnecessarily"],
        &["unnecessary"],
        &["unnecessarily"],
        &["unnecessary"],
        &["running"],
        &["uninstall"],
        &["uninstalled"],
        &["uninstalling"],
        &["unnecessary"],
        &["unsupported"],
    ],
    range: 3..=11,
};

static WORD_UNM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNM_CHILDREN),
    value: None,
};

pub static WORD_UNM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ached"),
        dictgen::InsensitiveStr::Ascii("ainted"),
        dictgen::InsensitiveStr::Ascii("anouverable"),
        dictgen::InsensitiveStr::Ascii("aping"),
        dictgen::InsensitiveStr::Ascii("append"),
        dictgen::InsensitiveStr::Ascii("arsalling"),
        dictgen::InsensitiveStr::Ascii("istakeably"),
        dictgen::InsensitiveStr::Ascii("odfide"),
        dictgen::InsensitiveStr::Ascii("odfided"),
        dictgen::InsensitiveStr::Ascii("odfied"),
        dictgen::InsensitiveStr::Ascii("odfieid"),
        dictgen::InsensitiveStr::Ascii("odfified"),
        dictgen::InsensitiveStr::Ascii("odfitied"),
        dictgen::InsensitiveStr::Ascii("odifable"),
        dictgen::InsensitiveStr::Ascii("odifed"),
        dictgen::InsensitiveStr::Ascii("outned"),
    ],
    values: &[
        &["unmatched"],
        &["unmaintained"],
        &["unmaneuverable", "unmanoeuvrable"],
        &["unmapping"],
        &["unmapped"],
        &["unmarshalling"],
        &["unmistakably"],
        &["unmodified"],
        &["unmodified"],
        &["unmodified"],
        &["unmodified"],
        &["unmodified"],
        &["unmodified"],
        &["unmodifiable"],
        &["unmodified"],
        &["unmounted"],
    ],
    range: 5..=11,
};

static WORD_UNL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNL_CHILDREN),
    value: None,
};

pub static WORD_UNL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cean"),
        dictgen::InsensitiveStr::Ascii("cear"),
        dictgen::InsensitiveStr::Ascii("coks"),
        dictgen::InsensitiveStr::Ascii("cuky"),
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("iaterally"),
        dictgen::InsensitiveStr::Ascii("ikey"),
        dictgen::InsensitiveStr::Ascii("ikley"),
        dictgen::InsensitiveStr::Ascii("imitied"),
        dictgen::InsensitiveStr::Ascii("imted"),
        dictgen::InsensitiveStr::Ascii("ine"),
        dictgen::InsensitiveStr::Ascii("oadins"),
        dictgen::InsensitiveStr::Ascii("ockes"),
        dictgen::InsensitiveStr::Ascii("uckly"),
    ],
    values: &[
        &["unclean"],
        &["unclear"],
        &["unlocks"],
        &["unlucky"],
        &["unless"],
        &["unilaterally"],
        &["unlikely"],
        &["unlikely"],
        &["unlimited"],
        &["unlimited"],
        &["unlike"],
        &["unloading"],
        &["unlocks"],
        &["unlucky"],
    ],
    range: 2..=9,
};

static WORD_UNK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNK_CHILDREN),
    value: None,
};

pub static WORD_UNK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("mown"),
        dictgen::InsensitiveStr::Ascii("non"),
        dictgen::InsensitiveStr::Ascii("nonw"),
        dictgen::InsensitiveStr::Ascii("nonwn"),
        dictgen::InsensitiveStr::Ascii("nonws"),
        dictgen::InsensitiveStr::Ascii("nowingy"),
        dictgen::InsensitiveStr::Ascii("nowinlgy"),
        dictgen::InsensitiveStr::Ascii("nowinly"),
        dictgen::InsensitiveStr::Ascii("nwn"),
        dictgen::InsensitiveStr::Ascii("nwns"),
        dictgen::InsensitiveStr::Ascii("nwoing"),
        dictgen::InsensitiveStr::Ascii("nwoingly"),
        dictgen::InsensitiveStr::Ascii("nwon"),
        dictgen::InsensitiveStr::Ascii("nwons"),
        dictgen::InsensitiveStr::Ascii("onwn"),
        dictgen::InsensitiveStr::Ascii("onwns"),
        dictgen::InsensitiveStr::Ascii("own"),
        dictgen::InsensitiveStr::Ascii("owningly"),
        dictgen::InsensitiveStr::Ascii("owns"),
        dictgen::InsensitiveStr::Ascii("wown"),
    ],
    values: &[
        &["unknown"],
        &["unknown"],
        &["unknown"],
        &["unknown"],
        &["unknowns"],
        &["unknowingly"],
        &["unknowingly"],
        &["unknowingly"],
        &["unknown"],
        &["unknowns"],
        &["unknowing"],
        &["unknowingly"],
        &["unknown"],
        &["unknowns"],
        &["unknown"],
        &["unknowns"],
        &["unknown"],
        &["unknowingly"],
        &["unknowns"],
        &["unknown"],
    ],
    range: 3..=8,
};

static WORD_UNJ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNJ_CHILDREN),
    value: None,
};

pub static WORD_UNJ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ustifed"),
        dictgen::InsensitiveStr::Ascii("ustifyed"),
    ],
    values: &[&["unjustified"], &["unjustified"]],
    range: 7..=8,
};

static WORD_UNI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_UNI_CHILDREN),
    value: None,
};

static WORD_UNI_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    None,
    Some(&WORD_UNIC_NODE),
    Some(&WORD_UNID_NODE),
    None,
    Some(&WORD_UNIF_NODE),
    Some(&WORD_UNIG_NODE),
    Some(&WORD_UNIH_NODE),
    None,
    None,
    None,
    Some(&WORD_UNIL_NODE),
    Some(&WORD_UNIM_NODE),
    Some(&WORD_UNIN_NODE),
    Some(&WORD_UNIO_NODE),
    None,
    Some(&WORD_UNIQ_NODE),
    None,
    Some(&WORD_UNIS_NODE),
    Some(&WORD_UNIT_NODE),
    None,
    Some(&WORD_UNIV_NODE),
    None,
    None,
    None,
    None,
];

static WORD_UNIV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNIV_CHILDREN),
    value: None,
};

pub static WORD_UNIV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eral"),
        dictgen::InsensitiveStr::Ascii("erally"),
        dictgen::InsensitiveStr::Ascii("ercity"),
        dictgen::InsensitiveStr::Ascii("eriality"),
        dictgen::InsensitiveStr::Ascii("erisites"),
        dictgen::InsensitiveStr::Ascii("eristies"),
        dictgen::InsensitiveStr::Ascii("eristy"),
        dictgen::InsensitiveStr::Ascii("erities"),
        dictgen::InsensitiveStr::Ascii("erity"),
        dictgen::InsensitiveStr::Ascii("ersale"),
        dictgen::InsensitiveStr::Ascii("ersaly"),
        dictgen::InsensitiveStr::Ascii("ersella"),
        dictgen::InsensitiveStr::Ascii("ersels"),
        dictgen::InsensitiveStr::Ascii("ersets"),
        dictgen::InsensitiveStr::Ascii("ersial"),
        dictgen::InsensitiveStr::Ascii("ersiality"),
        dictgen::InsensitiveStr::Ascii("ersirty"),
        dictgen::InsensitiveStr::Ascii("ersite"),
        dictgen::InsensitiveStr::Ascii("ersites"),
        dictgen::InsensitiveStr::Ascii("ersitets"),
        dictgen::InsensitiveStr::Ascii("ersitites"),
        dictgen::InsensitiveStr::Ascii("ersse"),
        dictgen::InsensitiveStr::Ascii("erstal"),
        dictgen::InsensitiveStr::Ascii("erstiy"),
        dictgen::InsensitiveStr::Ascii("esities"),
        dictgen::InsensitiveStr::Ascii("esity"),
        dictgen::InsensitiveStr::Ascii("rsal"),
    ],
    values: &[
        &["universal"],
        &["universally"],
        &["university"],
        &["universality"],
        &["universities"],
        &["universities"],
        &["university"],
        &["universities"],
        &["university"],
        &["universe"],
        &["universally"],
        &["universally"],
        &["universes"],
        &["universes"],
        &["universal"],
        &["universality"],
        &["university"],
        &["universities"],
        &["universities"],
        &["universities"],
        &["universities"],
        &["universes"],
        &["universal"],
        &["university"],
        &["universities"],
        &["university"],
        &["universal"],
    ],
    range: 4..=9,
};

static WORD_UNIT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNIT_CHILDREN),
    value: None,
};

pub static WORD_UNIT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("errupted"),
        dictgen::InsensitiveStr::Ascii("esstates"),
        dictgen::InsensitiveStr::Ascii("ialize"),
        dictgen::InsensitiveStr::Ascii("ialized"),
        dictgen::InsensitiveStr::Ascii("ilised"),
        dictgen::InsensitiveStr::Ascii("ilising"),
        dictgen::InsensitiveStr::Ascii("ilities"),
        dictgen::InsensitiveStr::Ascii("ility"),
        dictgen::InsensitiveStr::Ascii("ilized"),
        dictgen::InsensitiveStr::Ascii("ilizing"),
        dictgen::InsensitiveStr::Ascii("ilties"),
        dictgen::InsensitiveStr::Ascii("ilty"),
        dictgen::InsensitiveStr::Ascii("itialized"),
        dictgen::InsensitiveStr::Ascii("ss"),
    ],
    values: &[
        &["uninterrupted"],
        &["unitedstates"],
        &["uninitialize"],
        &["uninitialized"],
        &["uninitialised"],
        &["uninitialising"],
        &["utilities"],
        &["utility"],
        &["uninitialized"],
        &["uninitializing"],
        &["utilities"],
        &["utility"],
        &["uninitialized"],
        &["units"],
    ],
    range: 2..=9,
};

static WORD_UNIS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNIS_CHILDREN),
    value: None,
};

pub static WORD_UNIS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ntall"),
        dictgen::InsensitiveStr::Ascii("ntalled"),
        dictgen::InsensitiveStr::Ascii("ntalling"),
    ],
    values: &[&["uninstall"], &["uninstalled"], &["uninstalling"]],
    range: 5..=8,
};

static WORD_UNIQ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNIQ_CHILDREN),
    value: None,
};

pub static WORD_UNIQ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("u"),
        dictgen::InsensitiveStr::Ascii("uelly"),
        dictgen::InsensitiveStr::Ascii("uesness"),
        dictgen::InsensitiveStr::Ascii("uey"),
        dictgen::InsensitiveStr::Ascii("uiness"),
        dictgen::InsensitiveStr::Ascii("uley"),
        dictgen::InsensitiveStr::Ascii("uness"),
    ],
    values: &[
        &["unique"],
        &["unique"],
        &["uniquely"],
        &["uniqueness"],
        &["uniquely"],
        &["uniqueness"],
        &["uniquely"],
        &["uniqueness"],
    ],
    range: 1..=7,
};

static WORD_UNIO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNIO_CHILDREN),
    value: Some(&["union"]),
};

pub static WORD_UNIO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("s")],
    values: &[&["unions"]],
    range: 1..=1,
};

static WORD_UNIN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_UNIN_CHILDREN),
    value: None,
};

static WORD_UNIN_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_UNINA_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_UNINF_NODE),
    None,
    None,
    Some(&WORD_UNINI_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_UNINS_NODE),
    Some(&WORD_UNINT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_UNINT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNINT_CHILDREN),
    value: None,
};

pub static WORD_UNINT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ellegent"),
        dictgen::InsensitiveStr::Ascii("elligable"),
        dictgen::InsensitiveStr::Ascii("elligant"),
        dictgen::InsensitiveStr::Ascii("elligient"),
        dictgen::InsensitiveStr::Ascii("ensional"),
        dictgen::InsensitiveStr::Ascii("ensionally"),
        dictgen::InsensitiveStr::Ascii("ented"),
        dictgen::InsensitiveStr::Ascii("entially"),
        dictgen::InsensitiveStr::Ascii("entinal"),
        dictgen::InsensitiveStr::Ascii("entionaly"),
        dictgen::InsensitiveStr::Ascii("entionnal"),
        dictgen::InsensitiveStr::Ascii("entionnally"),
        dictgen::InsensitiveStr::Ascii("eresed"),
        dictgen::InsensitiveStr::Ascii("eresing"),
        dictgen::InsensitiveStr::Ascii("eressting"),
        dictgen::InsensitiveStr::Ascii("eristing"),
        dictgen::InsensitiveStr::Ascii("erneted"),
        dictgen::InsensitiveStr::Ascii("erpretted"),
        dictgen::InsensitiveStr::Ascii("erruped"),
        dictgen::InsensitiveStr::Ascii("erruptable"),
        dictgen::InsensitiveStr::Ascii("ersting"),
        dictgen::InsensitiveStr::Ascii("eruppted"),
        dictgen::InsensitiveStr::Ascii("erupted"),
        dictgen::InsensitiveStr::Ascii("esting"),
        dictgen::InsensitiveStr::Ascii("ialised"),
        dictgen::InsensitiveStr::Ascii("ialized"),
        dictgen::InsensitiveStr::Ascii("iallised"),
        dictgen::InsensitiveStr::Ascii("iallized"),
        dictgen::InsensitiveStr::Ascii("ialsied"),
        dictgen::InsensitiveStr::Ascii("ialzied"),
        dictgen::InsensitiveStr::Ascii("uive"),
    ],
    values: &[
        &["unintelligent"],
        &["unintelligible"],
        &["unintelligent"],
        &["unintelligent"],
        &["unintentional"],
        &["unintentionally"],
        &["unintended"],
        &["unintentionally"],
        &["unintentional"],
        &["unintentionally"],
        &["unintentional"],
        &["unintentionally"],
        &["uninterested"],
        &["uninteresting"],
        &["uninteresting"],
        &["uninteresting"],
        &["uninterested"],
        &["uninterpreted"],
        &["uninterrupted"],
        &["uninterruptible"],
        &["uninteresting"],
        &["uninterrupted"],
        &["uninterrupted"],
        &["uninteresting"],
        &["uninitialised"],
        &["uninitialized"],
        &["uninitialised"],
        &["uninitialized"],
        &["uninitialised"],
        &["uninitialized"],
        &["unintuitive"],
    ],
    range: 4..=11,
};

static WORD_UNINS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNINS_CHILDREN),
    value: None,
};

pub static WORD_UNINS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ipred"),
        dictgen::InsensitiveStr::Ascii("piried"),
        dictgen::InsensitiveStr::Ascii("pried"),
        dictgen::InsensitiveStr::Ascii("talable"),
        dictgen::InsensitiveStr::Ascii("taled"),
        dictgen::InsensitiveStr::Ascii("taling"),
        dictgen::InsensitiveStr::Ascii("tallimg"),
        dictgen::InsensitiveStr::Ascii("tallled"),
        dictgen::InsensitiveStr::Ascii("tallling"),
        dictgen::InsensitiveStr::Ascii("tallng"),
        dictgen::InsensitiveStr::Ascii("tatiated"),
    ],
    values: &[
        &["uninspired"],
        &["uninspired"],
        &["uninspired"],
        &["uninstallable"],
        &["uninstalled"],
        &["uninstalling"],
        &["uninstalling"],
        &["uninstalled"],
        &["uninstalling"],
        &["uninstalling"],
        &["uninstantiated"],
    ],
    range: 5..=8,
};

static WORD_UNINI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNINI_CHILDREN),
    value: None,
};

pub static WORD_UNINI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("tailised"),
        dictgen::InsensitiveStr::Ascii("tailized"),
        dictgen::InsensitiveStr::Ascii("talise"),
        dictgen::InsensitiveStr::Ascii("talised"),
        dictgen::InsensitiveStr::Ascii("talises"),
        dictgen::InsensitiveStr::Ascii("talizable"),
        dictgen::InsensitiveStr::Ascii("talize"),
        dictgen::InsensitiveStr::Ascii("talized"),
        dictgen::InsensitiveStr::Ascii("talizes"),
        dictgen::InsensitiveStr::Ascii("teresting"),
        dictgen::InsensitiveStr::Ascii("tializaed"),
        dictgen::InsensitiveStr::Ascii("tialse"),
        dictgen::InsensitiveStr::Ascii("tialsed"),
        dictgen::InsensitiveStr::Ascii("tialses"),
        dictgen::InsensitiveStr::Ascii("tialze"),
        dictgen::InsensitiveStr::Ascii("tialzed"),
        dictgen::InsensitiveStr::Ascii("tialzes"),
    ],
    values: &[
        &["uninitialised"],
        &["uninitialized"],
        &["uninitialise"],
        &["uninitialised"],
        &["uninitialises"],
        &["uninitializable"],
        &["uninitialize"],
        &["uninitialized"],
        &["uninitializes"],
        &["uninteresting"],
        &["uninitialized"],
        &["uninitialise"],
        &["uninitialised"],
        &["uninitialises"],
        &["uninitialize"],
        &["uninitialized"],
        &["uninitializes"],
    ],
    range: 6..=9,
};

static WORD_UNINF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNINF_CHILDREN),
    value: None,
};

pub static WORD_UNINF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rom"),
        dictgen::InsensitiveStr::Ascii("romed"),
        dictgen::InsensitiveStr::Ascii("romes"),
        dictgen::InsensitiveStr::Ascii("roming"),
        dictgen::InsensitiveStr::Ascii("roms"),
    ],
    values: &[
        &["uninform", "uniform"],
        &["uninformed", "uniformed"],
        &["uninforms", "uniforms"],
        &["uninforming", "uniforming"],
        &["uninforms", "uniforms"],
    ],
    range: 3..=6,
};

static WORD_UNINA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNINA_CHILDREN),
    value: None,
};

pub static WORD_UNINA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("mous")],
    values: &[&["unanimous"]],
    range: 4..=4,
};

static WORD_UNIM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNIM_CHILDREN),
    value: None,
};

pub static WORD_UNIM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("pemented"),
        dictgen::InsensitiveStr::Ascii("plemeneted"),
        dictgen::InsensitiveStr::Ascii("plimented"),
        dictgen::InsensitiveStr::Ascii("porant"),
        dictgen::InsensitiveStr::Ascii("portent"),
        dictgen::InsensitiveStr::Ascii("presed"),
        dictgen::InsensitiveStr::Ascii("pressd"),
        dictgen::InsensitiveStr::Ascii("presssed"),
    ],
    values: &[
        &["unimplemented"],
        &["unimplemented"],
        &["unimplemented"],
        &["unimportant"],
        &["unimportant"],
        &["unimpressed"],
        &["unimpressed"],
        &["unimpressed"],
    ],
    range: 6..=10,
};

static WORD_UNIL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNIL_CHILDREN),
    value: None,
};

pub static WORD_UNIL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aterallly"),
        dictgen::InsensitiveStr::Ascii("ateraly"),
        dictgen::InsensitiveStr::Ascii("aterlly"),
        dictgen::InsensitiveStr::Ascii("atreal"),
        dictgen::InsensitiveStr::Ascii("atreally"),
        dictgen::InsensitiveStr::Ascii("iterally"),
    ],
    values: &[
        &["unilaterally"],
        &["unilaterally"],
        &["unilaterally"],
        &["unilateral"],
        &["unilaterally"],
        &["unilaterally"],
    ],
    range: 6..=9,
};

static WORD_UNIH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNIH_CHILDREN),
    value: None,
};

pub static WORD_UNIH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("abited")],
    values: &[&["uninhabited"]],
    range: 6..=6,
};

static WORD_UNIG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNIG_CHILDREN),
    value: None,
};

pub static WORD_UNIG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ned")],
    values: &[&["unsigned"]],
    range: 3..=3,
};

static WORD_UNIF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNIF_CHILDREN),
    value: None,
};

pub static WORD_UNIF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("iy"),
        dictgen::InsensitiveStr::Ascii("nished"),
        dictgen::InsensitiveStr::Ascii("ormely"),
        dictgen::InsensitiveStr::Ascii("ormes"),
        dictgen::InsensitiveStr::Ascii("ormy"),
        dictgen::InsensitiveStr::Ascii("rom"),
        dictgen::InsensitiveStr::Ascii("romed"),
        dictgen::InsensitiveStr::Ascii("romity"),
        dictgen::InsensitiveStr::Ascii("roms"),
    ],
    values: &[
        &["unify"],
        &["unfinished"],
        &["uniformly"],
        &["uniforms"],
        &["uniformly", "uniform"],
        &["uniform"],
        &["uniformed"],
        &["uniformity"],
        &["uniforms"],
    ],
    range: 2..=6,
};

static WORD_UNID_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNID_CHILDREN),
    value: None,
};

pub static WORD_UNID_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("entifiedly"),
        dictgen::InsensitiveStr::Ascii("imensionnal"),
    ],
    values: &[&["unidentified"], &["unidimensional"]],
    range: 10..=11,
};

static WORD_UNIC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNIC_CHILDREN),
    value: None,
};

pub static WORD_UNIC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("de"),
        dictgen::InsensitiveStr::Ascii("ornios"),
        dictgen::InsensitiveStr::Ascii("ornis"),
        dictgen::InsensitiveStr::Ascii("ornus"),
        dictgen::InsensitiveStr::Ascii("ors"),
        dictgen::InsensitiveStr::Ascii("rons"),
    ],
    values: &[
        &["unicode"],
        &["unicorns"],
        &["unicorns"],
        &["unicorns"],
        &["unicorns"],
        &["unicorns"],
    ],
    range: 2..=6,
};

static WORD_UNH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNH_CHILDREN),
    value: None,
};

pub static WORD_UNH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("andeled"),
        dictgen::InsensitiveStr::Ascii("apppy"),
        dictgen::InsensitiveStr::Ascii("ealhty"),
        dictgen::InsensitiveStr::Ascii("ealthly"),
        dictgen::InsensitiveStr::Ascii("ealty"),
        dictgen::InsensitiveStr::Ascii("eathly"),
        dictgen::InsensitiveStr::Ascii("elathy"),
        dictgen::InsensitiveStr::Ascii("ilight"),
        dictgen::InsensitiveStr::Ascii("ilighted"),
        dictgen::InsensitiveStr::Ascii("ilights"),
    ],
    values: &[
        &["unhandled"],
        &["unhappy"],
        &["unhealthy"],
        &["unhealthy"],
        &["unhealthy"],
        &["unhealthy"],
        &["unhealthy"],
        &["unhighlight"],
        &["unhighlighted"],
        &["unhighlights"],
    ],
    range: 5..=8,
};

static WORD_UNG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNG_CHILDREN),
    value: None,
};

pub static WORD_UNG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eneralizeable"),
        dictgen::InsensitiveStr::Ascii("odley"),
        dictgen::InsensitiveStr::Ascii("oldy"),
        dictgen::InsensitiveStr::Ascii("rapeful"),
        dictgen::InsensitiveStr::Ascii("reatful"),
        dictgen::InsensitiveStr::Ascii("reatfull"),
    ],
    values: &[
        &["ungeneralizable"],
        &["ungodly"],
        &["ungodly"],
        &["ungrateful"],
        &["ungrateful"],
        &["ungrateful"],
    ],
    range: 4..=13,
};

static WORD_UNF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNF_CHILDREN),
    value: None,
};

pub static WORD_UNF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ailry"),
        dictgen::InsensitiveStr::Ascii("airy"),
        dictgen::InsensitiveStr::Ascii("amilair"),
        dictgen::InsensitiveStr::Ascii("amilier"),
        dictgen::InsensitiveStr::Ascii("amilliar"),
        dictgen::InsensitiveStr::Ascii("arily"),
        dictgen::InsensitiveStr::Ascii("ilp"),
        dictgen::InsensitiveStr::Ascii("ilpped"),
        dictgen::InsensitiveStr::Ascii("ilpping"),
        dictgen::InsensitiveStr::Ascii("ilps"),
        dictgen::InsensitiveStr::Ascii("insihed"),
        dictgen::InsensitiveStr::Ascii("irendly"),
        dictgen::InsensitiveStr::Ascii("laged"),
        dictgen::InsensitiveStr::Ascii("lexible"),
        dictgen::InsensitiveStr::Ascii("omfortable"),
        dictgen::InsensitiveStr::Ascii("oretunately"),
        dictgen::InsensitiveStr::Ascii("orgetable"),
        dictgen::InsensitiveStr::Ascii("orgiveable"),
        dictgen::InsensitiveStr::Ascii("orgiveble"),
        dictgen::InsensitiveStr::Ascii("orgivible"),
        dictgen::InsensitiveStr::Ascii("ormated"),
        dictgen::InsensitiveStr::Ascii("orseen"),
        dictgen::InsensitiveStr::Ascii("orttunately"),
        dictgen::InsensitiveStr::Ascii("ortuante"),
        dictgen::InsensitiveStr::Ascii("ortuantely"),
        dictgen::InsensitiveStr::Ascii("ortuate"),
        dictgen::InsensitiveStr::Ascii("ortunaltely"),
        dictgen::InsensitiveStr::Ascii("ortunaly"),
        dictgen::InsensitiveStr::Ascii("ortunantly"),
        dictgen::InsensitiveStr::Ascii("ortunat"),
        dictgen::InsensitiveStr::Ascii("ortunatelly"),
        dictgen::InsensitiveStr::Ascii("ortunatetly"),
        dictgen::InsensitiveStr::Ascii("ortunatley"),
        dictgen::InsensitiveStr::Ascii("ortunatly"),
        dictgen::InsensitiveStr::Ascii("ortune"),
        dictgen::InsensitiveStr::Ascii("ortuneatly"),
        dictgen::InsensitiveStr::Ascii("ortunetely"),
        dictgen::InsensitiveStr::Ascii("ortunetly"),
        dictgen::InsensitiveStr::Ascii("ortuntaly"),
        dictgen::InsensitiveStr::Ascii("orunate"),
        dictgen::InsensitiveStr::Ascii("orunately"),
        dictgen::InsensitiveStr::Ascii("orutunate"),
        dictgen::InsensitiveStr::Ascii("orutunately"),
        dictgen::InsensitiveStr::Ascii("ourtunately"),
        dictgen::InsensitiveStr::Ascii("ourtunetly"),
        dictgen::InsensitiveStr::Ascii("reindly"),
        dictgen::InsensitiveStr::Ascii("riednly"),
        dictgen::InsensitiveStr::Ascii("riendy"),
        dictgen::InsensitiveStr::Ascii("riently"),
        dictgen::InsensitiveStr::Ascii("urtunately"),
    ],
    values: &[
        &["unfairly"],
        &["unfairly"],
        &["unfamiliar"],
        &["unfamiliar"],
        &["unfamiliar"],
        &["unfairly"],
        &["unflip"],
        &["unflipped"],
        &["unflipping"],
        &["unflips"],
        &["unfinished"],
        &["unfriendly"],
        &["unflagged"],
        &["inflexible"],
        &["uncomfortable"],
        &["unfortunately"],
        &["unforgettable"],
        &["unforgivable"],
        &["unforgivable"],
        &["unforgivable"],
        &["unformatted"],
        &["unforeseen"],
        &["unfortunately"],
        &["unfortunate"],
        &["unfortunately"],
        &["unfortunate"],
        &["unfortunately"],
        &["unfortunately"],
        &["unfortunately"],
        &["unfortunate"],
        &["unfortunately"],
        &["unfortunately"],
        &["unfortunately"],
        &["unfortunately"],
        &["unfortunate"],
        &["unfortunately"],
        &["unfortunately"],
        &["unfortunately"],
        &["unfortunately"],
        &["unfortunate"],
        &["unfortunately"],
        &["unfortunate"],
        &["unfortunately"],
        &["unfortunately"],
        &["unfortunately"],
        &["unfriendly"],
        &["unfriendly"],
        &["unfriendly"],
        &["unfriendly"],
        &["unfortunately"],
    ],
    range: 3..=11,
};

static WORD_UNE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_UNE_CHILDREN),
    value: None,
};

static WORD_UNE_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    None,
    Some(&WORD_UNEC_NODE),
    Some(&WORD_UNED_NODE),
    Some(&WORD_UNEE_NODE),
    Some(&WORD_UNEF_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_UNEM_NODE),
    Some(&WORD_UNEN_NODE),
    None,
    Some(&WORD_UNEP_NODE),
    Some(&WORD_UNEQ_NODE),
    Some(&WORD_UNER_NODE),
    Some(&WORD_UNES_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_UNEX_NODE),
    None,
    None,
];

static WORD_UNEX_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNEX_CHILDREN),
    value: None,
};

pub static WORD_UNEX_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cected"),
        dictgen::InsensitiveStr::Ascii("cectedly"),
        dictgen::InsensitiveStr::Ascii("cpected"),
        dictgen::InsensitiveStr::Ascii("cpectedly"),
        dictgen::InsensitiveStr::Ascii("ecpted"),
        dictgen::InsensitiveStr::Ascii("ecptedly"),
        dictgen::InsensitiveStr::Ascii("ected"),
        dictgen::InsensitiveStr::Ascii("ectedly"),
        dictgen::InsensitiveStr::Ascii("epcted"),
        dictgen::InsensitiveStr::Ascii("epctedly"),
        dictgen::InsensitiveStr::Ascii("epected"),
        dictgen::InsensitiveStr::Ascii("epectedly"),
        dictgen::InsensitiveStr::Ascii("pacted"),
        dictgen::InsensitiveStr::Ascii("pactedly"),
        dictgen::InsensitiveStr::Ascii("pcted"),
        dictgen::InsensitiveStr::Ascii("pctedly"),
        dictgen::InsensitiveStr::Ascii("pecetd"),
        dictgen::InsensitiveStr::Ascii("pecetdly"),
        dictgen::InsensitiveStr::Ascii("pect"),
        dictgen::InsensitiveStr::Ascii("pectadely"),
        dictgen::InsensitiveStr::Ascii("pectadly"),
        dictgen::InsensitiveStr::Ascii("pectd"),
        dictgen::InsensitiveStr::Ascii("pectdly"),
        dictgen::InsensitiveStr::Ascii("pecte"),
        dictgen::InsensitiveStr::Ascii("pectely"),
        dictgen::InsensitiveStr::Ascii("pectend"),
        dictgen::InsensitiveStr::Ascii("pectendly"),
        dictgen::InsensitiveStr::Ascii("pectetly"),
        dictgen::InsensitiveStr::Ascii("pectidly"),
        dictgen::InsensitiveStr::Ascii("pectly"),
        dictgen::InsensitiveStr::Ascii("peected"),
        dictgen::InsensitiveStr::Ascii("peectedly"),
        dictgen::InsensitiveStr::Ascii("pepected"),
        dictgen::InsensitiveStr::Ascii("pepectedly"),
        dictgen::InsensitiveStr::Ascii("pepted"),
        dictgen::InsensitiveStr::Ascii("peptedly"),
        dictgen::InsensitiveStr::Ascii("percted"),
        dictgen::InsensitiveStr::Ascii("perctedly"),
        dictgen::InsensitiveStr::Ascii("perience"),
        dictgen::InsensitiveStr::Ascii("pested"),
        dictgen::InsensitiveStr::Ascii("pestedly"),
        dictgen::InsensitiveStr::Ascii("petced"),
        dictgen::InsensitiveStr::Ascii("petcedly"),
        dictgen::InsensitiveStr::Ascii("petct"),
        dictgen::InsensitiveStr::Ascii("petcted"),
        dictgen::InsensitiveStr::Ascii("petctedly"),
        dictgen::InsensitiveStr::Ascii("petctly"),
        dictgen::InsensitiveStr::Ascii("petect"),
        dictgen::InsensitiveStr::Ascii("petected"),
        dictgen::InsensitiveStr::Ascii("petectedly"),
        dictgen::InsensitiveStr::Ascii("petectly"),
        dictgen::InsensitiveStr::Ascii("peted"),
        dictgen::InsensitiveStr::Ascii("petedly"),
        dictgen::InsensitiveStr::Ascii("pexcted"),
        dictgen::InsensitiveStr::Ascii("pexctedly"),
        dictgen::InsensitiveStr::Ascii("pexted"),
        dictgen::InsensitiveStr::Ascii("pextedly"),
        dictgen::InsensitiveStr::Ascii("plaind"),
        dictgen::InsensitiveStr::Ascii("planed"),
        dictgen::InsensitiveStr::Ascii("plicably"),
        dictgen::InsensitiveStr::Ascii("spected"),
        dictgen::InsensitiveStr::Ascii("spectedly"),
    ],
    values: &[
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpectedly"],
        &["unexpectedly"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["inexperience"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexpected"],
        &["unexpectedly"],
        &["unexplained"],
        &["unexplained"],
        &["inexplicably"],
        &["unexpected"],
        &["unexpectedly"],
    ],
    range: 4..=10,
};

static WORD_UNES_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNES_CHILDREN),
    value: None,
};

pub static WORD_UNES_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("acpe"),
        dictgen::InsensitiveStr::Ascii("acped"),
        dictgen::InsensitiveStr::Ascii("secarry"),
        dictgen::InsensitiveStr::Ascii("secary"),
    ],
    values: &[
        &["unescape"],
        &["unescaped"],
        &["unnecessary"],
        &["unnecessary"],
    ],
    range: 4..=7,
};

static WORD_UNER_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNER_CHILDREN),
    value: Some(&["under"]),
};

pub static WORD_UNER_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[],
    values: &[],
    range: 0..=0,
};

static WORD_UNEQ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNEQ_CHILDREN),
    value: None,
};

pub static WORD_UNEQ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ualities"),
        dictgen::InsensitiveStr::Ascii("uality"),
    ],
    values: &[&["inequalities"], &["inequality"]],
    range: 6..=8,
};

static WORD_UNEP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNEP_CHILDREN),
    value: None,
};

pub static WORD_UNEP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ected"),
        dictgen::InsensitiveStr::Ascii("ectedly"),
    ],
    values: &[&["unexpected"], &["unexpectedly"]],
    range: 5..=7,
};

static WORD_UNEN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNEN_CHILDREN),
    value: None,
};

pub static WORD_UNEN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("crpt"),
        dictgen::InsensitiveStr::Ascii("crpted"),
        dictgen::InsensitiveStr::Ascii("forcable"),
        dictgen::InsensitiveStr::Ascii("ployment"),
    ],
    values: &[
        &["unencrypt"],
        &["unencrypted"],
        &["unenforceable"],
        &["unemployment"],
    ],
    range: 4..=8,
};

static WORD_UNEM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNEM_CHILDREN),
    value: None,
};

pub static WORD_UNEM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ployeed"),
        dictgen::InsensitiveStr::Ascii("ployemnt"),
        dictgen::InsensitiveStr::Ascii("ployent"),
        dictgen::InsensitiveStr::Ascii("ploymed"),
        dictgen::InsensitiveStr::Ascii("plyoment"),
        dictgen::InsensitiveStr::Ascii("polyed"),
        dictgen::InsensitiveStr::Ascii("polyment"),
    ],
    values: &[
        &["unemployed"],
        &["unemployment"],
        &["unemployment"],
        &["unemployed"],
        &["unemployment"],
        &["unemployed"],
        &["unemployment"],
    ],
    range: 6..=8,
};

static WORD_UNEF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNEF_CHILDREN),
    value: None,
};

pub static WORD_UNEF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("orceable"),
        dictgen::InsensitiveStr::Ascii("orm"),
    ],
    values: &[&["unenforceable"], &["uniform"]],
    range: 3..=8,
};

static WORD_UNEE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNEE_CHILDREN),
    value: None,
};

pub static WORD_UNEE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ded")],
    values: &[&["unneeded", "unheeded", "needed"]],
    range: 3..=3,
};

static WORD_UNED_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNED_CHILDREN),
    value: None,
};

pub static WORD_UNED_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cuated"),
        dictgen::InsensitiveStr::Ascii("icated"),
    ],
    values: &[&["uneducated"], &["uneducated"]],
    range: 6..=6,
};

static WORD_UNEC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNEC_CHILDREN),
    value: None,
};

pub static WORD_UNEC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cesary"),
        dictgen::InsensitiveStr::Ascii("cessarily"),
        dictgen::InsensitiveStr::Ascii("essarily"),
        dictgen::InsensitiveStr::Ascii("essary"),
    ],
    values: &[
        &["unnecessary"],
        &["unnecessarily"],
        &["unnecessarily"],
        &["unnecessary"],
    ],
    range: 6..=9,
};

static WORD_UND_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_UND_CHILDREN),
    value: None,
};

static WORD_UND_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    None,
    None,
    None,
    Some(&WORD_UNDE_NODE),
    Some(&WORD_UNDF_NODE),
    None,
    None,
    Some(&WORD_UNDI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_UNDO_NODE),
    None,
    None,
    Some(&WORD_UNDR_NODE),
    None,
    None,
    Some(&WORD_UNDU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static WORD_UNDU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDU_CHILDREN),
    value: None,
};

pub static WORD_UNDU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("pplicated")],
    values: &[&["unduplicated"]],
    range: 9..=9,
};

static WORD_UNDR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDR_CHILDREN),
    value: None,
};

pub static WORD_UNDR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("eground")],
    values: &[&["underground"]],
    range: 7..=7,
};

static WORD_UNDO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDO_CHILDREN),
    value: None,
};

pub static WORD_UNDO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ctrinated"),
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("rder"),
        dictgen::InsensitiveStr::Ascii("rdered"),
        dictgen::InsensitiveStr::Ascii("ubedtly"),
        dictgen::InsensitiveStr::Ascii("ubetdly"),
        dictgen::InsensitiveStr::Ascii("ubtadly"),
        dictgen::InsensitiveStr::Ascii("ubtebly"),
        dictgen::InsensitiveStr::Ascii("ubtedbly"),
        dictgen::InsensitiveStr::Ascii("ubtedy"),
        dictgen::InsensitiveStr::Ascii("ubtely"),
        dictgen::InsensitiveStr::Ascii("ubtetly"),
        dictgen::InsensitiveStr::Ascii("ubtley"),
    ],
    values: &[
        &["indoctrinated"],
        &["undo", "undone"],
        &["unorder"],
        &["unordered"],
        &["undoubtedly"],
        &["undoubtedly"],
        &["undoubtedly"],
        &["undoubtedly"],
        &["undoubtedly"],
        &["undoubtedly"],
        &["undoubtedly"],
        &["undoubtedly"],
        &["undoubtedly"],
    ],
    range: 2..=9,
};

static WORD_UNDI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDI_CHILDREN),
    value: None,
};

pub static WORD_UNDI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("serable"),
        dictgen::InsensitiveStr::Ascii("stinghable"),
    ],
    values: &[&["undesirable"], &["indistinguishable"]],
    range: 7..=10,
};

static WORD_UNDF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDF_CHILDREN),
    value: None,
};

pub static WORD_UNDF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ine"),
        dictgen::InsensitiveStr::Ascii("ined"),
        dictgen::InsensitiveStr::Ascii("ines"),
    ],
    values: &[&["undefine"], &["undefined"], &["undefines"]],
    range: 3..=4,
};

static WORD_UNDE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_UNDE_CHILDREN),
    value: None,
};

static WORD_UNDE_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    Some(&WORD_UNDEB_NODE),
    Some(&WORD_UNDEC_NODE),
    None,
    None,
    Some(&WORD_UNDEF_NODE),
    None,
    None,
    Some(&WORD_UNDEI_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_UNDEN_NODE),
    None,
    Some(&WORD_UNDEP_NODE),
    None,
    Some(&WORD_UNDER_NODE),
    Some(&WORD_UNDES_NODE),
    Some(&WORD_UNDET_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_UNDET_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDET_CHILDREN),
    value: Some(&["under"]),
};

pub static WORD_UNDET_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ecable"),
        dictgen::InsensitiveStr::Ascii("stand"),
        dictgen::InsensitiveStr::Ascii("ware"),
        dictgen::InsensitiveStr::Ascii("water"),
    ],
    values: &[
        &["undetectable"],
        &["understand"],
        &["underwear"],
        &["underwater"],
    ],
    range: 4..=6,
};

static WORD_UNDES_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDES_CHILDREN),
    value: None,
};

pub static WORD_UNDES_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("core"),
        dictgen::InsensitiveStr::Ascii("ireable"),
        dictgen::InsensitiveStr::Ascii("ireble"),
        dictgen::InsensitiveStr::Ascii("riable"),
        dictgen::InsensitiveStr::Ascii("rtand"),
        dictgen::InsensitiveStr::Ascii("tand"),
        dictgen::InsensitiveStr::Ascii("tood"),
        dictgen::InsensitiveStr::Ascii("tructible"),
    ],
    values: &[
        &["underscore"],
        &["undesirable"],
        &["undesirable"],
        &["undesirable"],
        &["understands"],
        &["understand"],
        &["understood"],
        &["indestructible"],
    ],
    range: 4..=9,
};

static WORD_UNDER_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_UNDER_CHILDREN),
    value: None,
};

static WORD_UNDER_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_UNDERA_NODE),
    Some(&WORD_UNDERB_NODE),
    Some(&WORD_UNDERC_NODE),
    Some(&WORD_UNDERD_NODE),
    Some(&WORD_UNDERE_NODE),
    Some(&WORD_UNDERF_NODE),
    Some(&WORD_UNDERG_NODE),
    Some(&WORD_UNDERH_NODE),
    None,
    None,
    None,
    Some(&WORD_UNDERL_NODE),
    Some(&WORD_UNDERM_NODE),
    Some(&WORD_UNDERN_NODE),
    Some(&WORD_UNDERO_NODE),
    Some(&WORD_UNDERP_NODE),
    None,
    Some(&WORD_UNDERR_NODE),
    Some(&WORD_UNDERS_NODE),
    Some(&WORD_UNDERT_NODE),
    Some(&WORD_UNDERU_NODE),
    None,
    Some(&WORD_UNDERW_NODE),
    None,
    Some(&WORD_UNDERY_NODE),
    None,
];

static WORD_UNDERY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERY_CHILDREN),
    value: None,
};

pub static WORD_UNDERY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ling")],
    values: &[&["underlying"]],
    range: 4..=4,
};

static WORD_UNDERW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERW_CHILDREN),
    value: None,
};

pub static WORD_UNDERW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aer"),
        dictgen::InsensitiveStr::Ascii("ager"),
        dictgen::InsensitiveStr::Ascii("ar"),
        dictgen::InsensitiveStr::Ascii("are"),
        dictgen::InsensitiveStr::Ascii("ares"),
        dictgen::InsensitiveStr::Ascii("arter"),
        dictgen::InsensitiveStr::Ascii("ealming"),
        dictgen::InsensitiveStr::Ascii("helimg"),
        dictgen::InsensitiveStr::Ascii("heling"),
        dictgen::InsensitiveStr::Ascii("hemling"),
        dictgen::InsensitiveStr::Ascii("hleming"),
        dictgen::InsensitiveStr::Ascii("ieght"),
        dictgen::InsensitiveStr::Ascii("olrd"),
        dictgen::InsensitiveStr::Ascii("oord"),
        dictgen::InsensitiveStr::Ascii("right"),
        dictgen::InsensitiveStr::Ascii("rold"),
    ],
    values: &[
        &["underwear"],
        &["underwater"],
        &["underwater"],
        &["underwear"],
        &["underwater"],
        &["underwater"],
        &["underwhelming"],
        &["underwhelming"],
        &["underwhelming"],
        &["underwhelming"],
        &["underwhelming"],
        &["underweight"],
        &["underworld"],
        &["underworld"],
        &["underweight"],
        &["underworld"],
    ],
    range: 2..=7,
};

static WORD_UNDERU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERU_CHILDREN),
    value: None,
};

pub static WORD_UNDERU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("n"),
        dictgen::InsensitiveStr::Ascii("ns"),
    ],
    values: &[&["underrun"], &["underruns"]],
    range: 1..=2,
};

static WORD_UNDERT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERT_CHILDREN),
    value: None,
};

pub static WORD_UNDERT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("able"),
        dictgen::InsensitiveStr::Ascii("acker"),
        dictgen::InsensitiveStr::Ascii("akeing"),
        dictgen::InsensitiveStr::Ascii("and"),
        dictgen::InsensitiveStr::Ascii("andable"),
        dictgen::InsensitiveStr::Ascii("anded"),
        dictgen::InsensitiveStr::Ascii("anding"),
        dictgen::InsensitiveStr::Ascii("ands"),
        dictgen::InsensitiveStr::Ascii("oe"),
        dictgen::InsensitiveStr::Ascii("oker"),
        dictgen::InsensitiveStr::Ascii("sand"),
        dictgen::InsensitiveStr::Ascii("sanding"),
        dictgen::InsensitiveStr::Ascii("sands"),
        dictgen::InsensitiveStr::Ascii("sood"),
        dictgen::InsensitiveStr::Ascii("stand"),
        dictgen::InsensitiveStr::Ascii("stands"),
        dictgen::InsensitiveStr::Ascii("unes"),
    ],
    values: &[
        &["understandable", "understand"],
        &["undertaker"],
        &["undertaking"],
        &["understand"],
        &["understandable"],
        &["understood"],
        &["understanding"],
        &["understands"],
        &["undertones"],
        &["undertaker"],
        &["understands", "understand"],
        &["understanding"],
        &["understands"],
        &["understood"],
        &["understand"],
        &["understands"],
        &["undertones"],
    ],
    range: 2..=7,
};

static WORD_UNDERS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERS_CHILDREN),
    value: None,
};

pub static WORD_UNDERS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("acn"),
        dictgen::InsensitiveStr::Ascii("atnd"),
        dictgen::InsensitiveStr::Ascii("etimate"),
        dictgen::InsensitiveStr::Ascii("etimated"),
        dictgen::InsensitiveStr::Ascii("og"),
        dictgen::InsensitiveStr::Ascii("tad"),
        dictgen::InsensitiveStr::Ascii("tadn"),
        dictgen::InsensitiveStr::Ascii("tadnable"),
        dictgen::InsensitiveStr::Ascii("tadning"),
        dictgen::InsensitiveStr::Ascii("tadns"),
        dictgen::InsensitiveStr::Ascii("tandablely"),
        dictgen::InsensitiveStr::Ascii("tandabley"),
        dictgen::InsensitiveStr::Ascii("tandble"),
        dictgen::InsensitiveStr::Ascii("tandbly"),
        dictgen::InsensitiveStr::Ascii("tandebly"),
        dictgen::InsensitiveStr::Ascii("tandible"),
        dictgen::InsensitiveStr::Ascii("tandibly"),
        dictgen::InsensitiveStr::Ascii("tannd"),
        dictgen::InsensitiveStr::Ascii("tans"),
        dictgen::InsensitiveStr::Ascii("tnad"),
        dictgen::InsensitiveStr::Ascii("toon"),
        dictgen::InsensitiveStr::Ascii("toud"),
        dictgen::InsensitiveStr::Ascii("tsand"),
        dictgen::InsensitiveStr::Ascii("tsnd"),
    ],
    values: &[
        &["underscan"],
        &["understands"],
        &["underestimate"],
        &["underestimated"],
        &["undergo"],
        &["understands"],
        &["understands", "understand"],
        &["understandable"],
        &["understanding"],
        &["understands"],
        &["understandably"],
        &["understandably"],
        &["understandable"],
        &["understandably"],
        &["understandably"],
        &["understandable"],
        &["understandably"],
        &["understands"],
        &["understands"],
        &["understands"],
        &["understood"],
        &["understood"],
        &["understands"],
        &["understands"],
    ],
    range: 2..=10,
};

static WORD_UNDERR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERR_CHILDREN),
    value: None,
};

pub static WORD_UNDERR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aged"),
        dictgen::InsensitiveStr::Ascii("aker"),
        dictgen::InsensitiveStr::Ascii("ater"),
        dictgen::InsensitiveStr::Ascii("atted"),
        dictgen::InsensitiveStr::Ascii("run"),
    ],
    values: &[
        &["underrated"],
        &["undertaker"],
        &["undertaker"],
        &["underrated"],
        &["underrun"],
    ],
    range: 3..=5,
};

static WORD_UNDERP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERP_CHILDREN),
    value: None,
};

pub static WORD_UNDERP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ining"),
        dictgen::InsensitiveStr::Ascii("owed"),
        dictgen::InsensitiveStr::Ascii("owerd"),
        dictgen::InsensitiveStr::Ascii("owererd"),
        dictgen::InsensitiveStr::Ascii("owred"),
    ],
    values: &[
        &["undermining"],
        &["underpowered"],
        &["underpowered"],
        &["underpowered"],
        &["underpowered"],
    ],
    range: 4..=7,
};

static WORD_UNDERO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERO_CHILDREN),
    value: None,
};

pub static WORD_UNDERO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("g")],
    values: &[&["undergo"]],
    range: 1..=1,
};

static WORD_UNDERN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERN_CHILDREN),
    value: None,
};

pub static WORD_UNDERN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("earth"),
        dictgen::InsensitiveStr::Ascii("eeth"),
        dictgen::InsensitiveStr::Ascii("eight"),
        dictgen::InsensitiveStr::Ascii("eith"),
        dictgen::InsensitiveStr::Ascii("ieth"),
    ],
    values: &[
        &["underneath"],
        &["underneath"],
        &["underweight"],
        &["underneath"],
        &["underneath"],
    ],
    range: 4..=5,
};

static WORD_UNDERM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERM_CHILDREN),
    value: None,
};

pub static WORD_UNDERM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("imes"),
        dictgen::InsensitiveStr::Ascii("iming"),
        dictgen::InsensitiveStr::Ascii("inde"),
        dictgen::InsensitiveStr::Ascii("indes"),
        dictgen::InsensitiveStr::Ascii("inding"),
        dictgen::InsensitiveStr::Ascii("ineing"),
        dictgen::InsensitiveStr::Ascii("ineras"),
        dictgen::InsensitiveStr::Ascii("ineres"),
        dictgen::InsensitiveStr::Ascii("ing"),
        dictgen::InsensitiveStr::Ascii("inging"),
        dictgen::InsensitiveStr::Ascii("inig"),
        dictgen::InsensitiveStr::Ascii("inining"),
        dictgen::InsensitiveStr::Ascii("inning"),
    ],
    values: &[
        &["undermines"],
        &["undermining"],
        &["undermines"],
        &["undermines"],
        &["undermining"],
        &["undermining"],
        &["undermines"],
        &["undermines"],
        &["undermining"],
        &["undermining"],
        &["undermining"],
        &["undermining"],
        &["undermining"],
    ],
    range: 3..=7,
};

static WORD_UNDERL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERL_CHILDREN),
    value: None,
};

pub static WORD_UNDERL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ayed"),
        dictgen::InsensitiveStr::Ascii("aying"),
        dictgen::InsensitiveStr::Ascii("ow"),
    ],
    values: &[&["underlaid"], &["underlying"], &["underflow"]],
    range: 2..=5,
};

static WORD_UNDERH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERH_CHILDREN),
    value: None,
};

pub static WORD_UNDERH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eight"),
        dictgen::InsensitiveStr::Ascii("welming"),
        dictgen::InsensitiveStr::Ascii("wleming"),
    ],
    values: &[&["underweight"], &["underwhelming"], &["underwhelming"]],
    range: 5..=7,
};

static WORD_UNDERG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERG_CHILDREN),
    value: None,
};

pub static WORD_UNDERG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ard"),
        dictgen::InsensitiveStr::Ascii("ated"),
        dictgen::InsensitiveStr::Ascii("ating"),
        dictgen::InsensitiveStr::Ascii("lo"),
        dictgen::InsensitiveStr::Ascii("orund"),
        dictgen::InsensitiveStr::Ascii("radate"),
        dictgen::InsensitiveStr::Ascii("radute"),
        dictgen::InsensitiveStr::Ascii("rand"),
        dictgen::InsensitiveStr::Ascii("ratuate"),
        dictgen::InsensitiveStr::Ascii("roud"),
        dictgen::InsensitiveStr::Ascii("rund"),
    ],
    values: &[
        &["undergrad"],
        &["underrated"],
        &["undertaking"],
        &["undergo"],
        &["underground"],
        &["undergraduate"],
        &["undergraduate"],
        &["undergrad"],
        &["undergraduate"],
        &["underground"],
        &["underground"],
    ],
    range: 2..=7,
};

static WORD_UNDERF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERF_CHILDREN),
    value: None,
};

pub static WORD_UNDERF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aker"),
        dictgen::InsensitiveStr::Ascii("iend"),
        dictgen::InsensitiveStr::Ascii("ined"),
    ],
    values: &[&["undertaker"], &["undefined"], &["undefined"]],
    range: 4..=4,
};

static WORD_UNDERE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERE_CHILDREN),
    value: None,
};

pub static WORD_UNDERE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("sitmate"),
        dictgen::InsensitiveStr::Ascii("stamate"),
        dictgen::InsensitiveStr::Ascii("stamated"),
        dictgen::InsensitiveStr::Ascii("stemate"),
        dictgen::InsensitiveStr::Ascii("stemated"),
        dictgen::InsensitiveStr::Ascii("stemating"),
        dictgen::InsensitiveStr::Ascii("stiamte"),
        dictgen::InsensitiveStr::Ascii("stimateing"),
        dictgen::InsensitiveStr::Ascii("stime"),
        dictgen::InsensitiveStr::Ascii("stimeted"),
    ],
    values: &[
        &["underestimated"],
        &["underestimate"],
        &["underestimated"],
        &["underestimate"],
        &["underestimated"],
        &["underestimating"],
        &["underestimated"],
        &["underestimating"],
        &["underestimate"],
        &["underestimated"],
    ],
    range: 5..=10,
};

static WORD_UNDERD_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERD_CHILDREN),
    value: None,
};

pub static WORD_UNDERD_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ong")],
    values: &[&["underdog"]],
    range: 3..=3,
};

static WORD_UNDERC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERC_CHILDREN),
    value: None,
};

pub static WORD_UNDERC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ling"),
        dictgen::InsensitiveStr::Ascii("unt"),
    ],
    values: &[&["underlying"], &["undercut"]],
    range: 3..=4,
};

static WORD_UNDERB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERB_CHILDREN),
    value: None,
};

pub static WORD_UNDERB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aker"),
        dictgen::InsensitiveStr::Ascii("og"),
    ],
    values: &[&["undertaker"], &["undergo"]],
    range: 2..=4,
};

static WORD_UNDERA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDERA_CHILDREN),
    value: None,
};

pub static WORD_UNDERA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("stimate"),
        dictgen::InsensitiveStr::Ascii("stimated"),
        dictgen::InsensitiveStr::Ascii("stimating"),
    ],
    values: &[
        &["underestimate"],
        &["underestimated"],
        &["underestimating"],
    ],
    range: 7..=9,
};

static WORD_UNDEP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDEP_CHILDREN),
    value: None,
};

pub static WORD_UNDEP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("endend")],
    values: &[&["independent", "nondependent"]],
    range: 6..=6,
};

static WORD_UNDEN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDEN_CHILDREN),
    value: None,
};

pub static WORD_UNDEN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aible"),
        dictgen::InsensitiveStr::Ascii("aibly"),
        dictgen::InsensitiveStr::Ascii("iabely"),
        dictgen::InsensitiveStr::Ascii("iablely"),
        dictgen::InsensitiveStr::Ascii("iabley"),
        dictgen::InsensitiveStr::Ascii("iablly"),
        dictgen::InsensitiveStr::Ascii("ialbly"),
        dictgen::InsensitiveStr::Ascii("yable"),
        dictgen::InsensitiveStr::Ascii("yably"),
    ],
    values: &[
        &["undeniable"],
        &["undeniably"],
        &["undeniably"],
        &["undeniably"],
        &["undeniably"],
        &["undeniably"],
        &["undeniably"],
        &["undeniable"],
        &["undeniably"],
    ],
    range: 5..=7,
};

static WORD_UNDEI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDEI_CHILDREN),
    value: None,
};

pub static WORD_UNDEI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("nable"),
        dictgen::InsensitiveStr::Ascii("nably"),
    ],
    values: &[&["undeniable"], &["undeniably"]],
    range: 5..=5,
};

static WORD_UNDEF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDEF_CHILDREN),
    value: None,
};

pub static WORD_UNDEF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ied"),
        dictgen::InsensitiveStr::Ascii("ien"),
        dictgen::InsensitiveStr::Ascii("iend"),
        dictgen::InsensitiveStr::Ascii("inied"),
        dictgen::InsensitiveStr::Ascii("initely"),
        dictgen::InsensitiveStr::Ascii("low"),
        dictgen::InsensitiveStr::Ascii("lows"),
        dictgen::InsensitiveStr::Ascii("uned"),
    ],
    values: &[
        &["undefined"],
        &["undefine"],
        &["undefined"],
        &["undefined"],
        &["indefinitely"],
        &["underflow"],
        &["underflows"],
        &["undefined"],
    ],
    range: 3..=7,
};

static WORD_UNDEC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDEC_CHILDREN),
    value: None,
};

pub static WORD_UNDEC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ideable")],
    values: &[&["undecidable"]],
    range: 7..=7,
};

static WORD_UNDEB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNDEB_CHILDREN),
    value: None,
};

pub static WORD_UNDEB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("iably")],
    values: &[&["undeniably"]],
    range: 5..=5,
};

static WORD_UNC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_UNC_CHILDREN),
    value: None,
};

static WORD_UNC_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_UNCA_NODE),
    None,
    None,
    None,
    Some(&WORD_UNCE_NODE),
    None,
    None,
    Some(&WORD_UNCH_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_UNCO_NODE),
    None,
    None,
    Some(&WORD_UNCR_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_UNCR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNCR_CHILDREN),
    value: None,
};

pub static WORD_UNCR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ypted")],
    values: &[&["unencrypted"]],
    range: 5..=5,
};

static WORD_UNCO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_UNCO_CHILDREN),
    value: None,
};

static WORD_UNCO_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_UNCOG_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_UNCOM_NODE),
    Some(&WORD_UNCON_NODE),
    None,
    None,
    None,
    Some(&WORD_UNCOR_NODE),
    None,
    None,
    Some(&WORD_UNCOU_NODE),
    Some(&WORD_UNCOV_NODE),
    None,
    None,
    None,
    None,
];

static WORD_UNCOV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNCOV_CHILDREN),
    value: None,
};

pub static WORD_UNCOV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("erted")],
    values: &[&["unconverted"]],
    range: 5..=5,
};

static WORD_UNCOU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNCOU_CHILDREN),
    value: None,
};

pub static WORD_UNCOU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ncious"),
        dictgen::InsensitiveStr::Ascii("nciously"),
        dictgen::InsensitiveStr::Ascii("sciously"),
    ],
    values: &[&["unconscious"], &["unconsciously"], &["unconsciously"]],
    range: 6..=8,
};

static WORD_UNCOR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNCOR_CHILDREN),
    value: None,
};

pub static WORD_UNCOR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ectly"),
        dictgen::InsensitiveStr::Ascii("elated"),
        dictgen::InsensitiveStr::Ascii("rect"),
        dictgen::InsensitiveStr::Ascii("rectly"),
        dictgen::InsensitiveStr::Ascii("rolated"),
    ],
    values: &[
        &["incorrectly"],
        &["uncorrelated"],
        &["incorrect"],
        &["incorrectly"],
        &["uncorrelated"],
    ],
    range: 4..=7,
};

static WORD_UNCON_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNCON_CHILDREN),
    value: None,
};

pub static WORD_UNCON_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cious"),
        dictgen::InsensitiveStr::Ascii("ciousness"),
        dictgen::InsensitiveStr::Ascii("cistencies"),
        dictgen::InsensitiveStr::Ascii("cistency"),
        dictgen::InsensitiveStr::Ascii("cistent"),
        dictgen::InsensitiveStr::Ascii("csious"),
        dictgen::InsensitiveStr::Ascii("csiously"),
        dictgen::InsensitiveStr::Ascii("disional"),
        dictgen::InsensitiveStr::Ascii("disionaly"),
        dictgen::InsensitiveStr::Ascii("disionnal"),
        dictgen::InsensitiveStr::Ascii("disionnaly"),
        dictgen::InsensitiveStr::Ascii("ditinal"),
        dictgen::InsensitiveStr::Ascii("ditinally"),
        dictgen::InsensitiveStr::Ascii("ditionable"),
        dictgen::InsensitiveStr::Ascii("ditionaly"),
        dictgen::InsensitiveStr::Ascii("ditionnal"),
        dictgen::InsensitiveStr::Ascii("ditionnally"),
        dictgen::InsensitiveStr::Ascii("ditionnaly"),
        dictgen::InsensitiveStr::Ascii("dtional"),
        dictgen::InsensitiveStr::Ascii("dtionally"),
        dictgen::InsensitiveStr::Ascii("figed"),
        dictgen::InsensitiveStr::Ascii("fortability"),
        dictgen::InsensitiveStr::Ascii("fortable"),
        dictgen::InsensitiveStr::Ascii("fortably"),
        dictgen::InsensitiveStr::Ascii("sciosly"),
        dictgen::InsensitiveStr::Ascii("scioulsy"),
        dictgen::InsensitiveStr::Ascii("sciouly"),
        dictgen::InsensitiveStr::Ascii("sciouslly"),
        dictgen::InsensitiveStr::Ascii("scous"),
        dictgen::InsensitiveStr::Ascii("sicous"),
        dictgen::InsensitiveStr::Ascii("sicously"),
        dictgen::InsensitiveStr::Ascii("siderate"),
        dictgen::InsensitiveStr::Ascii("sisntency"),
        dictgen::InsensitiveStr::Ascii("sistent"),
        dictgen::InsensitiveStr::Ascii("stititional"),
        dictgen::InsensitiveStr::Ascii("stituional"),
        dictgen::InsensitiveStr::Ascii("stitutionnal"),
        dictgen::InsensitiveStr::Ascii("titutional"),
        dictgen::InsensitiveStr::Ascii("trallable"),
        dictgen::InsensitiveStr::Ascii("trallably"),
        dictgen::InsensitiveStr::Ascii("trolable"),
        dictgen::InsensitiveStr::Ascii("trolablly"),
        dictgen::InsensitiveStr::Ascii("trollabe"),
        dictgen::InsensitiveStr::Ascii("trollablely"),
        dictgen::InsensitiveStr::Ascii("trollabley"),
        dictgen::InsensitiveStr::Ascii("trollablly"),
        dictgen::InsensitiveStr::Ascii("trollaby"),
        dictgen::InsensitiveStr::Ascii("vectional"),
        dictgen::InsensitiveStr::Ascii("vencional"),
        dictgen::InsensitiveStr::Ascii("venient"),
        dictgen::InsensitiveStr::Ascii("vensional"),
        dictgen::InsensitiveStr::Ascii("vential"),
        dictgen::InsensitiveStr::Ascii("ventianal"),
        dictgen::InsensitiveStr::Ascii("ventinal"),
        dictgen::InsensitiveStr::Ascii("ventionnal"),
    ],
    values: &[
        &["unconscious"],
        &["unconsciousness"],
        &["inconsistencies"],
        &["inconsistency"],
        &["inconsistent"],
        &["unconscious"],
        &["unconsciously"],
        &["unconditional"],
        &["unconditionally"],
        &["unconditional"],
        &["unconditionally"],
        &["unconditional"],
        &["unconditionally"],
        &["unconditional"],
        &["unconditionally"],
        &["unconditional"],
        &["unconditionally"],
        &["unconditionally"],
        &["unconditional"],
        &["unconditionally"],
        &["unconfigured"],
        &["discomfort"],
        &["uncomfortable"],
        &["uncomfortably"],
        &["unconsciously"],
        &["unconsciously"],
        &["unconsciously"],
        &["unconsciously"],
        &["unconscious"],
        &["unconscious"],
        &["unconsciously"],
        &["inconsiderate"],
        &["inconsistency"],
        &["inconsistent"],
        &["unconstitutional"],
        &["unconstitutional"],
        &["unconstitutional"],
        &["unconstitutional"],
        &["uncontrollable"],
        &["uncontrollably"],
        &["uncontrollable"],
        &["uncontrollably"],
        &["uncontrollable"],
        &["uncontrollably"],
        &["uncontrollably"],
        &["uncontrollably"],
        &["uncontrollably"],
        &["unconventional"],
        &["unconventional"],
        &["inconvenient"],
        &["unconventional"],
        &["unconventional"],
        &["unconventional"],
        &["unconventional"],
        &["unconventional"],
    ],
    range: 5..=12,
};

static WORD_UNCOM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNCOM_CHILDREN),
    value: None,
};

pub static WORD_UNCOM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ent"),
        dictgen::InsensitiveStr::Ascii("ented"),
        dictgen::InsensitiveStr::Ascii("enting"),
        dictgen::InsensitiveStr::Ascii("ents"),
        dictgen::InsensitiveStr::Ascii("fertable"),
        dictgen::InsensitiveStr::Ascii("fertably"),
        dictgen::InsensitiveStr::Ascii("fortabel"),
        dictgen::InsensitiveStr::Ascii("fortablely"),
        dictgen::InsensitiveStr::Ascii("fortabley"),
        dictgen::InsensitiveStr::Ascii("fortablity"),
        dictgen::InsensitiveStr::Ascii("fortablly"),
        dictgen::InsensitiveStr::Ascii("foryable"),
        dictgen::InsensitiveStr::Ascii("frotable"),
        dictgen::InsensitiveStr::Ascii("frotably"),
        dictgen::InsensitiveStr::Ascii("ftorable"),
        dictgen::InsensitiveStr::Ascii("ftorably"),
        dictgen::InsensitiveStr::Ascii("ited"),
        dictgen::InsensitiveStr::Ascii("itted"),
        dictgen::InsensitiveStr::Ascii("mited"),
        dictgen::InsensitiveStr::Ascii("mment"),
        dictgen::InsensitiveStr::Ascii("mmented"),
        dictgen::InsensitiveStr::Ascii("mmenting"),
        dictgen::InsensitiveStr::Ascii("mments"),
        dictgen::InsensitiveStr::Ascii("mmitted"),
        dictgen::InsensitiveStr::Ascii("mmon"),
        dictgen::InsensitiveStr::Ascii("mpresed"),
        dictgen::InsensitiveStr::Ascii("mpresion"),
        dictgen::InsensitiveStr::Ascii("mpressd"),
        dictgen::InsensitiveStr::Ascii("mpressed"),
        dictgen::InsensitiveStr::Ascii("mpression"),
        dictgen::InsensitiveStr::Ascii("mtited"),
        dictgen::InsensitiveStr::Ascii("on"),
        dictgen::InsensitiveStr::Ascii("patible"),
        dictgen::InsensitiveStr::Ascii("petetive"),
        dictgen::InsensitiveStr::Ascii("petive"),
        dictgen::InsensitiveStr::Ascii("plete"),
        dictgen::InsensitiveStr::Ascii("pleteness"),
        dictgen::InsensitiveStr::Ascii("pletness"),
        dictgen::InsensitiveStr::Ascii("pres"),
        dictgen::InsensitiveStr::Ascii("presed"),
        dictgen::InsensitiveStr::Ascii("preses"),
        dictgen::InsensitiveStr::Ascii("presing"),
        dictgen::InsensitiveStr::Ascii("presor"),
        dictgen::InsensitiveStr::Ascii("presors"),
        dictgen::InsensitiveStr::Ascii("prss"),
    ],
    values: &[
        &["uncomment"],
        &["uncommented"],
        &["uncommenting"],
        &["uncomments"],
        &["uncomfortable"],
        &["uncomfortably"],
        &["uncomfortably"],
        &["uncomfortably"],
        &["uncomfortably"],
        &["uncomfortably"],
        &["uncomfortably"],
        &["uncomfortably"],
        &["uncomfortable"],
        &["uncomfortably"],
        &["uncomfortable"],
        &["uncomfortably"],
        &["uncommitted"],
        &["uncommitted"],
        &["uncommitted"],
        &["uncomment"],
        &["uncommented"],
        &["uncommenting"],
        &["uncomments"],
        &["uncommitted"],
        &["uncommon"],
        &["uncompressed"],
        &["uncompression"],
        &["uncompressed"],
        &["uncompressed"],
        &["uncompression"],
        &["uncommitted"],
        &["uncommon"],
        &["incompatible"],
        &["uncompetitive"],
        &["uncompetitive"],
        &["incomplete"],
        &["incompleteness"],
        &["incompleteness"],
        &["uncompress"],
        &["uncompressed"],
        &["uncompresses"],
        &["uncompressing"],
        &["uncompressor"],
        &["uncompressors"],
        &["uncompress"],
    ],
    range: 2..=10,
};

static WORD_UNCOG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNCOG_CHILDREN),
    value: None,
};

pub static WORD_UNCOG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("nized")],
    values: &[&["unrecognized"]],
    range: 5..=5,
};

static WORD_UNCH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNCH_CHILDREN),
    value: None,
};

pub static WORD_UNCH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ache"),
        dictgen::InsensitiveStr::Ascii("ached"),
        dictgen::InsensitiveStr::Ascii("aged"),
        dictgen::InsensitiveStr::Ascii("ainged"),
        dictgen::InsensitiveStr::Ascii("allengable"),
        dictgen::InsensitiveStr::Ascii("aned"),
        dictgen::InsensitiveStr::Ascii("aneged"),
        dictgen::InsensitiveStr::Ascii("angable"),
        dictgen::InsensitiveStr::Ascii("eked"),
        dictgen::InsensitiveStr::Ascii("enged"),
    ],
    values: &[
        &["uncache"],
        &["uncached"],
        &["unchanged"],
        &["unchanged"],
        &["unchallengeable"],
        &["unchanged"],
        &["unchanged"],
        &["unchangeable"],
        &["unchecked"],
        &["unchanged"],
    ],
    range: 4..=10,
};

static WORD_UNCE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNCE_CHILDREN),
    value: Some(&["once"]),
};

pub static WORD_UNCE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hck"),
        dictgen::InsensitiveStr::Ascii("hcked"),
        dictgen::InsensitiveStr::Ascii("ncored"),
        dictgen::InsensitiveStr::Ascii("nsered"),
        dictgen::InsensitiveStr::Ascii("nsord"),
        dictgen::InsensitiveStr::Ascii("nsorred"),
        dictgen::InsensitiveStr::Ascii("rsored"),
        dictgen::InsensitiveStr::Ascii("rtaincy"),
        dictgen::InsensitiveStr::Ascii("rtainities"),
        dictgen::InsensitiveStr::Ascii("rtainity"),
        dictgen::InsensitiveStr::Ascii("rtaintity"),
        dictgen::InsensitiveStr::Ascii("rtaintly"),
        dictgen::InsensitiveStr::Ascii("rtainy"),
        dictgen::InsensitiveStr::Ascii("rtanity"),
        dictgen::InsensitiveStr::Ascii("rtanty"),
        dictgen::InsensitiveStr::Ascii("rtianty"),
        dictgen::InsensitiveStr::Ascii("snored"),
        dictgen::InsensitiveStr::Ascii("ssarily"),
    ],
    values: &[
        &["uncheck"],
        &["unchecked"],
        &["uncensored"],
        &["uncensored"],
        &["uncensored"],
        &["uncensored"],
        &["uncensored"],
        &["uncertainty"],
        &["uncertainties"],
        &["uncertainty"],
        &["uncertainty"],
        &["uncertainty"],
        &["uncertainty"],
        &["uncertainty"],
        &["uncertainty"],
        &["uncertainty"],
        &["uncensored"],
        &["unnecessarily"],
    ],
    range: 3..=10,
};

static WORD_UNCA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNCA_CHILDREN),
    value: None,
};

pub static WORD_UNCA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hnged"),
        dictgen::InsensitiveStr::Ascii("lcualted"),
        dictgen::InsensitiveStr::Ascii("nney"),
        dictgen::InsensitiveStr::Ascii("nnny"),
        dictgen::InsensitiveStr::Ascii("talogued"),
    ],
    values: &[
        &["unchanged"],
        &["uncalculated"],
        &["uncanny"],
        &["uncanny"],
        &["uncataloged"],
    ],
    range: 4..=8,
};

static WORD_UNB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNB_CHILDREN),
    value: None,
};

pub static WORD_UNB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alanaced"),
        dictgen::InsensitiveStr::Ascii("alenced"),
        dictgen::InsensitiveStr::Ascii("allance"),
        dictgen::InsensitiveStr::Ascii("alnaced"),
        dictgen::InsensitiveStr::Ascii("anend"),
        dictgen::InsensitiveStr::Ascii("annd"),
        dictgen::InsensitiveStr::Ascii("annend"),
        dictgen::InsensitiveStr::Ascii("areable"),
        dictgen::InsensitiveStr::Ascii("eakable"),
        dictgen::InsensitiveStr::Ascii("eareble"),
        dictgen::InsensitiveStr::Ascii("eatbale"),
        dictgen::InsensitiveStr::Ascii("eateble"),
        dictgen::InsensitiveStr::Ascii("eerable"),
        dictgen::InsensitiveStr::Ascii("eetable"),
        dictgen::InsensitiveStr::Ascii("eknowst"),
        dictgen::InsensitiveStr::Ascii("eleifable"),
        dictgen::InsensitiveStr::Ascii("eleivable"),
        dictgen::InsensitiveStr::Ascii("eleivably"),
        dictgen::InsensitiveStr::Ascii("eliavable"),
        dictgen::InsensitiveStr::Ascii("eliavably"),
        dictgen::InsensitiveStr::Ascii("eliebable"),
        dictgen::InsensitiveStr::Ascii("eliefable"),
        dictgen::InsensitiveStr::Ascii("elievablely"),
        dictgen::InsensitiveStr::Ascii("elievabley"),
        dictgen::InsensitiveStr::Ascii("elievablly"),
        dictgen::InsensitiveStr::Ascii("elieveble"),
        dictgen::InsensitiveStr::Ascii("elievibly"),
        dictgen::InsensitiveStr::Ascii("elivable"),
        dictgen::InsensitiveStr::Ascii("eliveable"),
        dictgen::InsensitiveStr::Ascii("eliveably"),
        dictgen::InsensitiveStr::Ascii("elivebly"),
        dictgen::InsensitiveStr::Ascii("elizeable"),
        dictgen::InsensitiveStr::Ascii("olievable"),
        dictgen::InsensitiveStr::Ascii("orned"),
        dictgen::InsensitiveStr::Ascii("ouind"),
        dictgen::InsensitiveStr::Ascii("ouinded"),
        dictgen::InsensitiveStr::Ascii("oun"),
        dictgen::InsensitiveStr::Ascii("ounad"),
        dictgen::InsensitiveStr::Ascii("ounaded"),
        dictgen::InsensitiveStr::Ascii("ouned"),
        dictgen::InsensitiveStr::Ascii("ounnd"),
        dictgen::InsensitiveStr::Ascii("ounnded"),
        dictgen::InsensitiveStr::Ascii("ouund"),
        dictgen::InsensitiveStr::Ascii("ouunded"),
        dictgen::InsensitiveStr::Ascii("raikable"),
        dictgen::InsensitiveStr::Ascii("rakeable"),
        dictgen::InsensitiveStr::Ascii("reakabie"),
        dictgen::InsensitiveStr::Ascii("reakabke"),
        dictgen::InsensitiveStr::Ascii("reakbale"),
        dictgen::InsensitiveStr::Ascii("reakble"),
        dictgen::InsensitiveStr::Ascii("reakeble"),
        dictgen::InsensitiveStr::Ascii("rearable"),
        dictgen::InsensitiveStr::Ascii("unded"),
    ],
    values: &[
        &["unbalanced"],
        &["unbalanced"],
        &["unbalance"],
        &["unbalanced"],
        &["unbanned"],
        &["unbanned"],
        &["unbanned"],
        &["unbearable"],
        &["unbeatable"],
        &["unbearable"],
        &["unbeatable"],
        &["unbeatable"],
        &["unbearable"],
        &["unbeatable"],
        &["unbeknownst"],
        &["unbelievable"],
        &["unbelievable"],
        &["unbelievably"],
        &["unbelievable"],
        &["unbelievably"],
        &["unbelievable"],
        &["unbelievable"],
        &["unbelievably"],
        &["unbelievably"],
        &["unbelievably"],
        &["unbelievable"],
        &["unbelievably"],
        &["unbelievable"],
        &["unbelievable"],
        &["unbelievably"],
        &["unbelievably"],
        &["unbelievable"],
        &["unbelievable"],
        &["unborn"],
        &["unbound"],
        &["unbounded"],
        &["unbound"],
        &["unbound"],
        &["unbounded"],
        &["unbounded"],
        &["unbound"],
        &["unbounded"],
        &["unbound"],
        &["unbounded"],
        &["unbreakable"],
        &["unbreakable"],
        &["unbreakable"],
        &["unbreakable"],
        &["unbreakable"],
        &["unbreakable"],
        &["unbreakable"],
        &["unbreakable"],
        &["unbundled", "unbounded"],
    ],
    range: 3..=11,
};

static WORD_UNA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UNA_CHILDREN),
    value: None,
};

pub static WORD_UNA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bailable"),
        dictgen::InsensitiveStr::Ascii("bale"),
        dictgen::InsensitiveStr::Ascii("bel"),
        dictgen::InsensitiveStr::Ascii("bnned"),
        dictgen::InsensitiveStr::Ascii("ccaptable"),
        dictgen::InsensitiveStr::Ascii("cceptible"),
        dictgen::InsensitiveStr::Ascii("ccesible"),
        dictgen::InsensitiveStr::Ascii("ccpetable"),
        dictgen::InsensitiveStr::Ascii("cknowleged"),
        dictgen::InsensitiveStr::Ascii("companied"),
        dictgen::InsensitiveStr::Ascii("hppy"),
        dictgen::InsensitiveStr::Ascii("lllowed"),
        dictgen::InsensitiveStr::Ascii("mbigious"),
        dictgen::InsensitiveStr::Ascii("mbigous"),
        dictgen::InsensitiveStr::Ascii("mbigously"),
        dictgen::InsensitiveStr::Ascii("med"),
        dictgen::InsensitiveStr::Ascii("minous"),
        dictgen::InsensitiveStr::Ascii("nimoulsy"),
        dictgen::InsensitiveStr::Ascii("nimuous"),
        dictgen::InsensitiveStr::Ascii("nmious"),
        dictgen::InsensitiveStr::Ascii("nswerd"),
        dictgen::InsensitiveStr::Ascii("nwsered"),
        dictgen::InsensitiveStr::Ascii("nymous"),
        dictgen::InsensitiveStr::Ascii("ppealling"),
        dictgen::InsensitiveStr::Ascii("ppeasing"),
        dictgen::InsensitiveStr::Ascii("ppeeling"),
        dictgen::InsensitiveStr::Ascii("ppropriate"),
        dictgen::InsensitiveStr::Ascii("ppropriately"),
        dictgen::InsensitiveStr::Ascii("quired"),
        dictgen::InsensitiveStr::Ascii("rchving"),
        dictgen::InsensitiveStr::Ascii("snwered"),
        dictgen::InsensitiveStr::Ascii("thenticated"),
        dictgen::InsensitiveStr::Ascii("thorised"),
        dictgen::InsensitiveStr::Ascii("ttanded"),
        dictgen::InsensitiveStr::Ascii("tteded"),
        dictgen::InsensitiveStr::Ascii("ttendend"),
        dictgen::InsensitiveStr::Ascii("tteneded"),
        dictgen::InsensitiveStr::Ascii("ttented"),
        dictgen::InsensitiveStr::Ascii("ttracive"),
        dictgen::InsensitiveStr::Ascii("ttractice"),
        dictgen::InsensitiveStr::Ascii("uthenicated"),
        dictgen::InsensitiveStr::Ascii("utherized"),
        dictgen::InsensitiveStr::Ascii("uthoried"),
        dictgen::InsensitiveStr::Ascii("uthroized"),
        dictgen::InsensitiveStr::Ascii("vaiable"),
        dictgen::InsensitiveStr::Ascii("vaialable"),
        dictgen::InsensitiveStr::Ascii("vaialbale"),
        dictgen::InsensitiveStr::Ascii("vaialbe"),
        dictgen::InsensitiveStr::Ascii("vaialbel"),
        dictgen::InsensitiveStr::Ascii("vaialbility"),
        dictgen::InsensitiveStr::Ascii("vaialble"),
        dictgen::InsensitiveStr::Ascii("vaible"),
        dictgen::InsensitiveStr::Ascii("vailabe"),
        dictgen::InsensitiveStr::Ascii("vailabel"),
        dictgen::InsensitiveStr::Ascii("vailble"),
        dictgen::InsensitiveStr::Ascii("vailible"),
        dictgen::InsensitiveStr::Ascii("valiable"),
        dictgen::InsensitiveStr::Ascii("vaoidable"),
        dictgen::InsensitiveStr::Ascii("vilable"),
        dictgen::InsensitiveStr::Ascii("viodable"),
        dictgen::InsensitiveStr::Ascii("voidble"),
        dictgen::InsensitiveStr::Ascii("wnsered"),
    ],
    values: &[
        &["unavailable"],
        &["unable"],
        &["unable"],
        &["unbanned"],
        &["unacceptable"],
        &["unacceptable"],
        &["unaccessible"],
        &["unacceptable"],
        &["unacknowledged"],
        &["unaccompanied"],
        &["unhappy"],
        &["unallowed"],
        &["unambiguous"],
        &["unambiguous"],
        &["unambiguously"],
        &["unnamed"],
        &["unanimous"],
        &["unanimous"],
        &["unanimous"],
        &["unanimous"],
        &["unanswered"],
        &["unanswered"],
        &["unanimous"],
        &["unappealing"],
        &["unappealing"],
        &["unappealing"],
        &["inappropriate"],
        &["inappropriately"],
        &["unacquired"],
        &["unarchiving"],
        &["unanswered"],
        &["unauthenticated"],
        &["unauthorised"],
        &["unattended"],
        &["unattended"],
        &["unattended"],
        &["unattended"],
        &["unattended"],
        &["unattractive"],
        &["unattractive"],
        &["unauthenticated"],
        &["unauthorized"],
        &["unauthorized"],
        &["unauthorized"],
        &["unavailable"],
        &["unavailable"],
        &["unavailable"],
        &["unavailable"],
        &["unavailable"],
        &["unavailability"],
        &["unavailable"],
        &["unavailable"],
        &["unavailable"],
        &["unavailable"],
        &["unavailable"],
        &["unavailable"],
        &["unavailable"],
        &["unavoidable"],
        &["unavailable"],
        &["unavoidable"],
        &["unavoidable"],
        &["unanswered"],
    ],
    range: 3..=12,
};

static WORD_UM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UM_CHILDREN),
    value: None,
};

pub static WORD_UM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ambiguous"),
        dictgen::InsensitiveStr::Ascii("ark"),
        dictgen::InsensitiveStr::Ascii("arked"),
        dictgen::InsensitiveStr::Ascii("believable"),
        dictgen::InsensitiveStr::Ascii("berlla"),
        dictgen::InsensitiveStr::Ascii("brealla"),
        dictgen::InsensitiveStr::Ascii("brela"),
        dictgen::InsensitiveStr::Ascii("brellla"),
        dictgen::InsensitiveStr::Ascii("comfortable"),
        dictgen::InsensitiveStr::Ascii("comfortably"),
        dictgen::InsensitiveStr::Ascii("employment"),
        dictgen::InsensitiveStr::Ascii("inportant"),
        dictgen::InsensitiveStr::Ascii("it"),
        dictgen::InsensitiveStr::Ascii("mark"),
        dictgen::InsensitiveStr::Ascii("outn"),
        dictgen::InsensitiveStr::Ascii("predictable"),
    ],
    values: &[
        &["unambiguous"],
        &["unmark"],
        &["unmarked"],
        &["unbelievable"],
        &["umbrella"],
        &["umbrella"],
        &["umbrella"],
        &["umbrella"],
        &["uncomfortable"],
        &["uncomfortably"],
        &["unemployment"],
        &["unimportant"],
        &["unit"],
        &["unmark"],
        &["umount"],
        &["unpredictable"],
    ],
    range: 2..=11,
};

static WORD_UL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UL_CHILDREN),
    value: None,
};

pub static WORD_UL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("imited"),
        dictgen::InsensitiveStr::Ascii("itmate"),
        dictgen::InsensitiveStr::Ascii("itmately"),
        dictgen::InsensitiveStr::Ascii("itmatum"),
        dictgen::InsensitiveStr::Ascii("tamite"),
        dictgen::InsensitiveStr::Ascii("ter"),
        dictgen::InsensitiveStr::Ascii("teration"),
        dictgen::InsensitiveStr::Ascii("terations"),
        dictgen::InsensitiveStr::Ascii("tered"),
        dictgen::InsensitiveStr::Ascii("tering"),
        dictgen::InsensitiveStr::Ascii("terioara"),
        dictgen::InsensitiveStr::Ascii("terioare"),
        dictgen::InsensitiveStr::Ascii("teriour"),
        dictgen::InsensitiveStr::Ascii("ters"),
        dictgen::InsensitiveStr::Ascii("tiamte"),
        dictgen::InsensitiveStr::Ascii("timae"),
        dictgen::InsensitiveStr::Ascii("timatelly"),
        dictgen::InsensitiveStr::Ascii("timative"),
        dictgen::InsensitiveStr::Ascii("timatley"),
        dictgen::InsensitiveStr::Ascii("timatly"),
        dictgen::InsensitiveStr::Ascii("timatuum"),
        dictgen::InsensitiveStr::Ascii("timely"),
        dictgen::InsensitiveStr::Ascii("trason"),
    ],
    values: &[
        &["unlimited"],
        &["ultimate"],
        &["ultimately"],
        &["ultimatum"],
        &["ultimate"],
        &["alter"],
        &["alteration"],
        &["alterations"],
        &["altered"],
        &["altering"],
        &["ulterior"],
        &["ulterior"],
        &["ulterior"],
        &["alters"],
        &["ultimate"],
        &["ultimate"],
        &["ultimately"],
        &["ultimate"],
        &["ultimately"],
        &["ultimately"],
        &["ultimatum"],
        &["ultimately"],
        &["ultrasound"],
    ],
    range: 3..=9,
};

static WORD_UK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UK_CHILDREN),
    value: None,
};

pub static WORD_UK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arine"),
        dictgen::InsensitiveStr::Ascii("nown"),
        dictgen::InsensitiveStr::Ascii("nowns"),
        dictgen::InsensitiveStr::Ascii("owns"),
        dictgen::InsensitiveStr::Ascii("rainain"),
        dictgen::InsensitiveStr::Ascii("rainains"),
        dictgen::InsensitiveStr::Ascii("raineans"),
        dictgen::InsensitiveStr::Ascii("rainias"),
        dictgen::InsensitiveStr::Ascii("rainie"),
        dictgen::InsensitiveStr::Ascii("rainiens"),
        dictgen::InsensitiveStr::Ascii("rainin"),
        dictgen::InsensitiveStr::Ascii("rainina"),
        dictgen::InsensitiveStr::Ascii("raininans"),
        dictgen::InsensitiveStr::Ascii("raininas"),
        dictgen::InsensitiveStr::Ascii("rainisn"),
        dictgen::InsensitiveStr::Ascii("ranian"),
        dictgen::InsensitiveStr::Ascii("ranie"),
        dictgen::InsensitiveStr::Ascii("riane"),
        dictgen::InsensitiveStr::Ascii("rianian"),
        dictgen::InsensitiveStr::Ascii("rianians"),
    ],
    values: &[
        &["ukraine"],
        &["unknown"],
        &["unknowns"],
        &["unknowns", "unknown"],
        &["ukrainian"],
        &["ukrainians"],
        &["ukrainians"],
        &["ukrainians"],
        &["ukraine"],
        &["ukrainians"],
        &["ukrainian"],
        &["ukrainian"],
        &["ukrainians"],
        &["ukrainians"],
        &["ukrainians"],
        &["ukrainian"],
        &["ukraine"],
        &["ukraine"],
        &["ukrainian"],
        &["ukrainians"],
    ],
    range: 4..=9,
};

static WORD_UI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UI_CHILDREN),
    value: None,
};

pub static WORD_UI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("que"),
        dictgen::InsensitiveStr::Ascii("se"),
        dictgen::InsensitiveStr::Ascii("te"),
        dictgen::InsensitiveStr::Ascii("tes"),
    ],
    values: &[&["unique"], &["use"], &["suite"], &["suites"]],
    range: 2..=3,
};

static WORD_UG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UG_CHILDREN),
    value: None,
};

pub static WORD_UG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gly"),
        dictgen::InsensitiveStr::Ascii("glyness"),
        dictgen::InsensitiveStr::Ascii("lyness"),
        dictgen::InsensitiveStr::Ascii("prade"),
        dictgen::InsensitiveStr::Ascii("praded"),
        dictgen::InsensitiveStr::Ascii("prades"),
        dictgen::InsensitiveStr::Ascii("prading"),
    ],
    values: &[
        &["ugly"],
        &["ugliness"],
        &["ugliness"],
        &["upgrade"],
        &["upgraded"],
        &["upgrades"],
        &["upgrading"],
    ],
    range: 3..=7,
};

static WORD_UE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UE_CHILDREN),
    value: Some(&["use", "due"]),
};

pub static WORD_UE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ful"),
        dictgen::InsensitiveStr::Ascii("gister"),
        dictgen::InsensitiveStr::Ascii("sd"),
        dictgen::InsensitiveStr::Ascii("sfull"),
    ],
    values: &[&["useful"], &["unregister"], &["used"], &["usefull"]],
    range: 2..=6,
};

static WORD_UD_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UD_CHILDREN),
    value: None,
};

pub static WORD_UD_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ated"),
        dictgen::InsensitiveStr::Ascii("ater"),
        dictgen::InsensitiveStr::Ascii("ating"),
        dictgen::InsensitiveStr::Ascii("nercut"),
        dictgen::InsensitiveStr::Ascii("nerdog"),
        dictgen::InsensitiveStr::Ascii("nerestimate"),
        dictgen::InsensitiveStr::Ascii("nerpowered"),
        dictgen::InsensitiveStr::Ascii("no"),
        dictgen::InsensitiveStr::Ascii("patable"),
        dictgen::InsensitiveStr::Ascii("pate"),
        dictgen::InsensitiveStr::Ascii("pated"),
        dictgen::InsensitiveStr::Ascii("pater"),
        dictgen::InsensitiveStr::Ascii("pates"),
        dictgen::InsensitiveStr::Ascii("pating"),
    ],
    values: &[
        &["updated", "dated"],
        &["updater", "dater"],
        &["updating", "dating"],
        &["undercut"],
        &["underdog"],
        &["underestimated"],
        &["underpowered"],
        &["undo", "uno"],
        &["updatable"],
        &["update"],
        &["updated"],
        &["updater"],
        &["updates"],
        &["updating"],
    ],
    range: 2..=11,
};

static WORD_UB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_UB_CHILDREN),
    value: None,
};

pub static WORD_UB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("elieveble"),
        dictgen::InsensitiveStr::Ascii("elievebly"),
        dictgen::InsensitiveStr::Ascii("ernetes"),
        dictgen::InsensitiveStr::Ascii("iqituous"),
        dictgen::InsensitiveStr::Ascii("iquitious"),
        dictgen::InsensitiveStr::Ascii("iquitos"),
        dictgen::InsensitiveStr::Ascii("iquituous"),
        dictgen::InsensitiveStr::Ascii("iquituously"),
        dictgen::InsensitiveStr::Ascii("iquotous"),
        dictgen::InsensitiveStr::Ascii("iqutious"),
        dictgen::InsensitiveStr::Ascii("itquitous"),
        dictgen::InsensitiveStr::Ascii("lisher"),
        dictgen::InsensitiveStr::Ascii("subscribed"),
        dictgen::InsensitiveStr::Ascii("substantiated"),
        dictgen::InsensitiveStr::Ascii("unut"),
        dictgen::InsensitiveStr::Ascii("utunu"),
    ],
    values: &[
        &["unbelievable"],
        &["unbelievably"],
        &["kubernetes"],
        &["ubiquitous"],
        &["ubiquitous"],
        &["ubiquitous"],
        &["ubiquitous"],
        &["ubiquitously"],
        &["ubiquitous"],
        &["ubiquitous"],
        &["ubiquitous"],
        &["publisher"],
        &["unsubscribed"],
        &["unsubstantiated"],
        &["ubuntu"],
        &["ubuntu"],
    ],
    range: 4..=13,
};

static WORD_T_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_T_CHILDREN),
    value: None,
};

static WORD_T_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_TA_NODE),
    Some(&WORD_TB_NODE),
    Some(&WORD_TC_NODE),
    None,
    Some(&WORD_TE_NODE),
    None,
    Some(&WORD_TG_NODE),
    Some(&WORD_TH_NODE),
    Some(&WORD_TI_NODE),
    Some(&WORD_TJ_NODE),
    Some(&WORD_TK_NODE),
    Some(&WORD_TL_NODE),
    Some(&WORD_TM_NODE),
    None,
    Some(&WORD_TO_NODE),
    Some(&WORD_TP_NODE),
    None,
    Some(&WORD_TR_NODE),
    Some(&WORD_TS_NODE),
    Some(&WORD_TT_NODE),
    Some(&WORD_TU_NODE),
    None,
    Some(&WORD_TW_NODE),
    None,
    Some(&WORD_TY_NODE),
    None,
];

static WORD_TY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TY_CHILDREN),
    value: None,
};

pub static WORD_TY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("elnol"),
        dictgen::InsensitiveStr::Ascii("ep"),
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("hat"),
        dictgen::InsensitiveStr::Ascii("he"),
        dictgen::InsensitiveStr::Ascii("ies"),
        dictgen::InsensitiveStr::Ascii("lenool"),
        dictgen::InsensitiveStr::Ascii("mecode"),
        dictgen::InsensitiveStr::Ascii("ope"),
        dictgen::InsensitiveStr::Ascii("pcast"),
        dictgen::InsensitiveStr::Ascii("pcasting"),
        dictgen::InsensitiveStr::Ascii("pcasts"),
        dictgen::InsensitiveStr::Ascii("pcial"),
        dictgen::InsensitiveStr::Ascii("pcially"),
        dictgen::InsensitiveStr::Ascii("pechek"),
        dictgen::InsensitiveStr::Ascii("pecheking"),
        dictgen::InsensitiveStr::Ascii("picall"),
        dictgen::InsensitiveStr::Ascii("picallly"),
        dictgen::InsensitiveStr::Ascii("picaly"),
        dictgen::InsensitiveStr::Ascii("picially"),
        dictgen::InsensitiveStr::Ascii("ple"),
        dictgen::InsensitiveStr::Ascii("ples"),
        dictgen::InsensitiveStr::Ascii("poe"),
        dictgen::InsensitiveStr::Ascii("poes"),
        dictgen::InsensitiveStr::Ascii("pographc"),
        dictgen::InsensitiveStr::Ascii("ppe"),
        dictgen::InsensitiveStr::Ascii("pped"),
        dictgen::InsensitiveStr::Ascii("ppes"),
        dictgen::InsensitiveStr::Ascii("ranies"),
        dictgen::InsensitiveStr::Ascii("rannia"),
        dictgen::InsensitiveStr::Ascii("rantical"),
        dictgen::InsensitiveStr::Ascii("rany"),
        dictgen::InsensitiveStr::Ascii("rhard"),
        dictgen::InsensitiveStr::Ascii("ring"),
        dictgen::InsensitiveStr::Ascii("rranies"),
        dictgen::InsensitiveStr::Ascii("rrany"),
    ],
    values: &[
        &["type", "tie"],
        &["tylenol"],
        &["type"],
        &["types", "ties"],
        &["that"],
        &["they"],
        &["tries"],
        &["tylenol"],
        &["timecode"],
        &["type"],
        &["typecast"],
        &["typecasting"],
        &["typecasts"],
        &["typical"],
        &["typically"],
        &["typecheck"],
        &["typechecking"],
        &["typically", "typical"],
        &["typically"],
        &["typically"],
        &["typically"],
        &["tuple"],
        &["tuples"],
        &["typo", "type", "types"],
        &["typos", "types"],
        &["typographic"],
        &["type"],
        &["typed"],
        &["types"],
        &["tyrannies"],
        &["tyrannical"],
        &["tyrannical"],
        &["tyranny"],
        &["tryhard"],
        &["trying"],
        &["tyrannies"],
        &["tyranny"],
    ],
    range: 1..=9,
};

static WORD_TW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TW_CHILDREN),
    value: None,
};

pub static WORD_TW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eleve"),
        dictgen::InsensitiveStr::Ascii("elth"),
        dictgen::InsensitiveStr::Ascii("ilgiht"),
        dictgen::InsensitiveStr::Ascii("iligt"),
        dictgen::InsensitiveStr::Ascii("on"),
        dictgen::InsensitiveStr::Ascii("oo"),
        dictgen::InsensitiveStr::Ascii("po"),
    ],
    values: &[
        &["twelve"],
        &["twelfth"],
        &["twilight"],
        &["twilight"],
        &["town"],
        &["two", "too"],
        &["two"],
    ],
    range: 2..=6,
};

static WORD_TU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TU_CHILDREN),
    value: None,
};

pub static WORD_TU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("esdsay"),
        dictgen::InsensitiveStr::Ascii("esdsy"),
        dictgen::InsensitiveStr::Ascii("fure"),
        dictgen::InsensitiveStr::Ascii("hmbnail"),
        dictgen::InsensitiveStr::Ascii("nelled"),
        dictgen::InsensitiveStr::Ascii("nelling"),
        dictgen::InsensitiveStr::Ascii("nned"),
        dictgen::InsensitiveStr::Ascii("nnell"),
        dictgen::InsensitiveStr::Ascii("nnells"),
        dictgen::InsensitiveStr::Ascii("nning"),
        dictgen::InsensitiveStr::Ascii("nnles"),
        dictgen::InsensitiveStr::Ascii("nraround"),
        dictgen::InsensitiveStr::Ascii("nrtable"),
        dictgen::InsensitiveStr::Ascii("otiral"),
        dictgen::InsensitiveStr::Ascii("otirals"),
        dictgen::InsensitiveStr::Ascii("pel"),
        dictgen::InsensitiveStr::Ascii("pparware"),
        dictgen::InsensitiveStr::Ascii("pperwears"),
        dictgen::InsensitiveStr::Ascii("pple"),
        dictgen::InsensitiveStr::Ascii("pples"),
        dictgen::InsensitiveStr::Ascii("rbins"),
        dictgen::InsensitiveStr::Ascii("re"),
        dictgen::InsensitiveStr::Ascii("rkisch"),
        dictgen::InsensitiveStr::Ascii("rksih"),
        dictgen::InsensitiveStr::Ascii("rle"),
        dictgen::InsensitiveStr::Ascii("rltes"),
        dictgen::InsensitiveStr::Ascii("rly"),
        dictgen::InsensitiveStr::Ascii("rnapound"),
        dictgen::InsensitiveStr::Ascii("rnaroud"),
        dictgen::InsensitiveStr::Ascii("rnk"),
        dictgen::InsensitiveStr::Ascii("rntabe"),
        dictgen::InsensitiveStr::Ascii("rntabel"),
        dictgen::InsensitiveStr::Ascii("rorial"),
        dictgen::InsensitiveStr::Ascii("rorials"),
        dictgen::InsensitiveStr::Ascii("rrest"),
        dictgen::InsensitiveStr::Ascii("rretts"),
        dictgen::InsensitiveStr::Ascii("rstworthy"),
        dictgen::InsensitiveStr::Ascii("rtels"),
        dictgen::InsensitiveStr::Ascii("rthfully"),
        dictgen::InsensitiveStr::Ascii("rtorial"),
        dictgen::InsensitiveStr::Ascii("rtorials"),
        dictgen::InsensitiveStr::Ascii("scon"),
        dictgen::InsensitiveStr::Ascii("seday"),
        dictgen::InsensitiveStr::Ascii("sedays"),
        dictgen::InsensitiveStr::Ascii("snami"),
        dictgen::InsensitiveStr::Ascii("st"),
        dictgen::InsensitiveStr::Ascii("tion"),
        dictgen::InsensitiveStr::Ascii("toriales"),
        dictgen::InsensitiveStr::Ascii("toriel"),
        dictgen::InsensitiveStr::Ascii("toriels"),
        dictgen::InsensitiveStr::Ascii("torual"),
        dictgen::InsensitiveStr::Ascii("trles"),
    ],
    values: &[
        &["tuesdays"],
        &["tuesdays"],
        &["future"],
        &["thumbnail"],
        &["tunnelled"],
        &["tunnelling"],
        &["tuned"],
        &["tunnel"],
        &["tunnels"],
        &["tuning", "running"],
        &["tunnels"],
        &["turnaround"],
        &["turntable"],
        &["tutorial"],
        &["tutorials"],
        &["tuple"],
        &["tupperware"],
        &["tupperware"],
        &["tuple"],
        &["tuples"],
        &["turbines"],
        &["true"],
        &["turkish"],
        &["turkish"],
        &["turtle"],
        &["turtles"],
        &["truly"],
        &["turnaround"],
        &["turnaround"],
        &["trunk", "turnkey", "turn"],
        &["turntable"],
        &["turntable"],
        &["tutorial"],
        &["tutorials"],
        &["turrets"],
        &["turrets"],
        &["trustworthy"],
        &["turtles"],
        &["truthfully"],
        &["tutorial"],
        &["tutorials"],
        &["tucson"],
        &["tuesday"],
        &["tuesdays"],
        &["tsunami"],
        &["trust"],
        &["tuition"],
        &["tutorials"],
        &["tutorial"],
        &["tutorials"],
        &["tutorial"],
        &["turtles"],
    ],
    range: 2..=9,
};

static WORD_TT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TT_CHILDREN),
    value: None,
};

pub static WORD_TT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ests"),
        dictgen::InsensitiveStr::Ascii("he"),
    ],
    values: &[&["tests"], &["the"]],
    range: 2..=4,
};

static WORD_TS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TS_CHILDREN),
    value: None,
};

pub static WORD_TS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("amina"),
        dictgen::InsensitiveStr::Ascii("nuami"),
        dictgen::InsensitiveStr::Ascii("uanmi"),
        dictgen::InsensitiveStr::Ascii("unamai"),
        dictgen::InsensitiveStr::Ascii("unmai"),
    ],
    values: &[
        &["stamina"],
        &["tsunami"],
        &["tsunami"],
        &["tsunami"],
        &["tsunami"],
    ],
    range: 5..=6,
};

static WORD_TR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_TR_CHILDREN),
    value: None,
};

static WORD_TR_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_TRA_NODE),
    None,
    None,
    None,
    Some(&WORD_TRE_NODE),
    None,
    Some(&WORD_TRG_NODE),
    Some(&WORD_TRH_NODE),
    Some(&WORD_TRI_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_TRN_NODE),
    Some(&WORD_TRO_NODE),
    Some(&WORD_TRP_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_TRU_NODE),
    None,
    None,
    None,
    Some(&WORD_TRY_NODE),
    None,
];

static WORD_TRY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRY_CHILDREN),
    value: None,
};

pub static WORD_TRY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ahrd"),
        dictgen::InsensitiveStr::Ascii("annical"),
        dictgen::InsensitiveStr::Ascii("avon"),
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("ig"),
        dictgen::InsensitiveStr::Ascii("inng"),
        dictgen::InsensitiveStr::Ascii("s"),
    ],
    values: &[
        &["tryhard"],
        &["tyrannical"],
        &["trayvon"],
        &["tried"],
        &["tries"],
        &["trying"],
        &["trying"],
        &["tries"],
    ],
    range: 1..=7,
};

static WORD_TRU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRU_CHILDREN),
    value: None,
};

pub static WORD_TRU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("amatic"),
        dictgen::InsensitiveStr::Ascii("amatized"),
        dictgen::InsensitiveStr::Ascii("bble"),
        dictgen::InsensitiveStr::Ascii("bbled"),
        dictgen::InsensitiveStr::Ascii("bbles"),
        dictgen::InsensitiveStr::Ascii("binal"),
        dictgen::InsensitiveStr::Ascii("bines"),
        dictgen::InsensitiveStr::Ascii("ble"),
        dictgen::InsensitiveStr::Ascii("bled"),
        dictgen::InsensitiveStr::Ascii("bles"),
        dictgen::InsensitiveStr::Ascii("cate"),
        dictgen::InsensitiveStr::Ascii("cated"),
        dictgen::InsensitiveStr::Ascii("cates"),
        dictgen::InsensitiveStr::Ascii("cating"),
        dictgen::InsensitiveStr::Ascii("cnate"),
        dictgen::InsensitiveStr::Ascii("cnated"),
        dictgen::InsensitiveStr::Ascii("cnating"),
        dictgen::InsensitiveStr::Ascii("dnle"),
        dictgen::InsensitiveStr::Ascii("elly"),
        dictgen::InsensitiveStr::Ascii("ely"),
        dictgen::InsensitiveStr::Ascii("ied"),
        dictgen::InsensitiveStr::Ascii("imph"),
        dictgen::InsensitiveStr::Ascii("kish"),
        dictgen::InsensitiveStr::Ascii("lly"),
        dictgen::InsensitiveStr::Ascii("mendously"),
        dictgen::InsensitiveStr::Ascii("n"),
        dictgen::InsensitiveStr::Ascii("nacted"),
        dictgen::InsensitiveStr::Ascii("ncat"),
        dictgen::InsensitiveStr::Ascii("nctate"),
        dictgen::InsensitiveStr::Ascii("nctated"),
        dictgen::InsensitiveStr::Ascii("nctating"),
        dictgen::InsensitiveStr::Ascii("nctation"),
        dictgen::InsensitiveStr::Ascii("ncted"),
        dictgen::InsensitiveStr::Ascii("ndel"),
        dictgen::InsensitiveStr::Ascii("ned"),
        dictgen::InsensitiveStr::Ascii("nlde"),
        dictgen::InsensitiveStr::Ascii("ns"),
        dictgen::InsensitiveStr::Ascii("shworthy"),
        dictgen::InsensitiveStr::Ascii("stowrthy"),
        dictgen::InsensitiveStr::Ascii("stwhorty"),
        dictgen::InsensitiveStr::Ascii("stworhty"),
        dictgen::InsensitiveStr::Ascii("stworhy"),
        dictgen::InsensitiveStr::Ascii("stworthly"),
        dictgen::InsensitiveStr::Ascii("stworthyness"),
        dictgen::InsensitiveStr::Ascii("stworty"),
        dictgen::InsensitiveStr::Ascii("stwortyness"),
        dictgen::InsensitiveStr::Ascii("stwothy"),
        dictgen::InsensitiveStr::Ascii("thfullly"),
        dictgen::InsensitiveStr::Ascii("thfuly"),
        dictgen::InsensitiveStr::Ascii("w"),
    ],
    values: &[
        &["traumatic"],
        &["traumatized"],
        &["trouble"],
        &["troubled"],
        &["troubles"],
        &["tribunal"],
        &["turbines"],
        &["trouble"],
        &["troubled"],
        &["troubles"],
        &["truncate"],
        &["truncated"],
        &["truncates"],
        &["truncating"],
        &["truncate"],
        &["truncated"],
        &["truncating"],
        &["trundle"],
        &["truly"],
        &["truly"],
        &["tried"],
        &["triumph"],
        &["turkish"],
        &["truly"],
        &["tremendously"],
        &["turn"],
        &["truncated"],
        &["truncate"],
        &["truncate"],
        &["truncated"],
        &["truncating"],
        &["truncation"],
        &["truncated"],
        &["trundle"],
        &["turned"],
        &["trundle"],
        &["turns"],
        &["trustworthy"],
        &["trustworthy"],
        &["trustworthy"],
        &["trustworthy"],
        &["trustworthy"],
        &["trustworthy"],
        &["trustworthiness"],
        &["trustworthy"],
        &["trustworthiness"],
        &["trustworthy"],
        &["truthfully"],
        &["truthfully"],
        &["true"],
    ],
    range: 1..=12,
};

static WORD_TRP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRP_CHILDREN),
    value: None,
};

pub static WORD_TRP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("oical")],
    values: &[&["tropical"]],
    range: 5..=5,
};

static WORD_TRO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRO_CHILDREN),
    value: None,
};

pub static WORD_TRO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("chlight"),
        dictgen::InsensitiveStr::Ascii("hpies"),
        dictgen::InsensitiveStr::Ascii("leld"),
        dictgen::InsensitiveStr::Ascii("ling"),
        dictgen::InsensitiveStr::Ascii("llade"),
        dictgen::InsensitiveStr::Ascii("nado"),
        dictgen::InsensitiveStr::Ascii("pcial"),
        dictgen::InsensitiveStr::Ascii("pedo"),
        dictgen::InsensitiveStr::Ascii("tilla"),
        dictgen::InsensitiveStr::Ascii("ttle"),
        dictgen::InsensitiveStr::Ascii("ubelshoot"),
        dictgen::InsensitiveStr::Ascii("ubelshooting"),
        dictgen::InsensitiveStr::Ascii("ubelsome"),
        dictgen::InsensitiveStr::Ascii("ublehsoot"),
        dictgen::InsensitiveStr::Ascii("ublehsooting"),
        dictgen::InsensitiveStr::Ascii("ubleshooot"),
        dictgen::InsensitiveStr::Ascii("ubleshotting"),
        dictgen::InsensitiveStr::Ascii("ublshooting"),
        dictgen::InsensitiveStr::Ascii("ughput"),
        dictgen::InsensitiveStr::Ascii("ught"),
        dictgen::InsensitiveStr::Ascii("up"),
        dictgen::InsensitiveStr::Ascii("ups"),
    ],
    values: &[
        &["torchlight"],
        &["trophies"],
        &["trolled"],
        &["trolling"],
        &["trolled"],
        &["tornado"],
        &["tropical"],
        &["torpedo"],
        &["tortilla"],
        &["throttle"],
        &["troubleshoot"],
        &["troubleshooting"],
        &["troublesome"],
        &["troubleshoot"],
        &["troubleshooting"],
        &["troubleshoot"],
        &["troubleshooting"],
        &["troubleshooting"],
        &["throughput"],
        &["through"],
        &["troupe"],
        &["troupes", "troops"],
    ],
    range: 2..=12,
};

static WORD_TRN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRN_CHILDREN),
    value: None,
};

pub static WORD_TRN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("asfers"),
        dictgen::InsensitiveStr::Ascii("asmit"),
        dictgen::InsensitiveStr::Ascii("asmited"),
        dictgen::InsensitiveStr::Ascii("asmits"),
        dictgen::InsensitiveStr::Ascii("sfer"),
        dictgen::InsensitiveStr::Ascii("sfered"),
        dictgen::InsensitiveStr::Ascii("sfers"),
    ],
    values: &[
        &["transfers"],
        &["transmit"],
        &["transmitted"],
        &["transmits"],
        &["transfer"],
        &["transferred"],
        &["transfers"],
    ],
    range: 4..=7,
};

static WORD_TRI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_TRI_CHILDREN),
    value: None,
};

static WORD_TRI_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_TRIA_NODE),
    Some(&WORD_TRIB_NODE),
    Some(&WORD_TRIC_NODE),
    Some(&WORD_TRID_NODE),
    None,
    None,
    Some(&WORD_TRIG_NODE),
    None,
    None,
    None,
    Some(&WORD_TRIK_NODE),
    Some(&WORD_TRIL_NODE),
    Some(&WORD_TRIM_NODE),
    Some(&WORD_TRIN_NODE),
    Some(&WORD_TRIO_NODE),
    Some(&WORD_TRIP_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_TRIU_NODE),
    Some(&WORD_TRIV_NODE),
    None,
    None,
    None,
    None,
];

static WORD_TRIV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRIV_CHILDREN),
    value: None,
};

pub static WORD_TRIV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("al"),
        dictgen::InsensitiveStr::Ascii("ally"),
        dictgen::InsensitiveStr::Ascii("ias"),
    ],
    values: &[&["trivial"], &["trivially"], &["trivia"]],
    range: 2..=4,
};

static WORD_TRIU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRIU_CHILDREN),
    value: None,
};

pub static WORD_TRIU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("mpth")],
    values: &[&["triumph"]],
    range: 4..=4,
};

static WORD_TRIP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRIP_CHILDREN),
    value: None,
};

pub static WORD_TRIP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ple")],
    values: &[&["triple"]],
    range: 3..=3,
};

static WORD_TRIO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRIO_CHILDREN),
    value: None,
};

pub static WORD_TRIO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lgy"),
        dictgen::InsensitiveStr::Ascii("logy"),
    ],
    values: &[&["trilogy"], &["trilogy"]],
    range: 3..=4,
};

static WORD_TRIN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRIN_CHILDREN),
    value: None,
};

pub static WORD_TRIN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("agle"),
        dictgen::InsensitiveStr::Ascii("agles"),
        dictgen::InsensitiveStr::Ascii("ekts"),
        dictgen::InsensitiveStr::Ascii("g"),
        dictgen::InsensitiveStr::Ascii("gale"),
        dictgen::InsensitiveStr::Ascii("gs"),
        dictgen::InsensitiveStr::Ascii("itiy"),
        dictgen::InsensitiveStr::Ascii("iy"),
        dictgen::InsensitiveStr::Ascii("kes"),
        dictgen::InsensitiveStr::Ascii("kst"),
        dictgen::InsensitiveStr::Ascii("tiy"),
    ],
    values: &[
        &["triangle"],
        &["triangles"],
        &["trinkets"],
        &["trying", "string", "ring"],
        &["triangle"],
        &["strings", "rings"],
        &["trinity"],
        &["trinity"],
        &["trinkets"],
        &["trinkets"],
        &["trinity"],
    ],
    range: 1..=5,
};

static WORD_TRIM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRIM_CHILDREN),
    value: None,
};

pub static WORD_TRIM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("ing"),
        dictgen::InsensitiveStr::Ascii("uph"),
    ],
    values: &[&["trimmed"], &["trimming", "timing"], &["triumph"]],
    range: 2..=3,
};

static WORD_TRIL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRIL_CHILDREN),
    value: None,
};

pub static WORD_TRIL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ogoy")],
    values: &[&["trilogy"]],
    range: 4..=4,
};

static WORD_TRIK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRIK_CHILDREN),
    value: Some(&["trick", "trike"]),
};

pub static WORD_TRIK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("ery"),
        dictgen::InsensitiveStr::Ascii("s"),
        dictgen::InsensitiveStr::Ascii("y"),
    ],
    values: &[
        &["tricked"],
        &["trickery"],
        &["tricks", "trikes"],
        &["tricky"],
    ],
    range: 1..=3,
};

static WORD_TRIG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRIG_CHILDREN),
    value: None,
};

pub static WORD_TRIG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("ered"),
        dictgen::InsensitiveStr::Ascii("erred"),
        dictgen::InsensitiveStr::Ascii("erring"),
        dictgen::InsensitiveStr::Ascii("ers"),
        dictgen::InsensitiveStr::Ascii("ged"),
        dictgen::InsensitiveStr::Ascii("gerd"),
        dictgen::InsensitiveStr::Ascii("gereing"),
        dictgen::InsensitiveStr::Ascii("geres"),
        dictgen::InsensitiveStr::Ascii("gern"),
        dictgen::InsensitiveStr::Ascii("gerred"),
        dictgen::InsensitiveStr::Ascii("gerring"),
        dictgen::InsensitiveStr::Ascii("gger"),
        dictgen::InsensitiveStr::Ascii("uered"),
    ],
    values: &[
        &["trigger", "tiger"],
        &["triggered"],
        &["triggered"],
        &["triggering"],
        &["triggers"],
        &["triggered"],
        &["triggered"],
        &["triggering"],
        &["triggers"],
        &["triggering"],
        &["triggered"],
        &["triggering"],
        &["trigger"],
        &["triggered"],
    ],
    range: 2..=7,
};

static WORD_TRID_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRID_CHILDREN),
    value: None,
};

pub static WORD_TRID_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("net")],
    values: &[&["trident"]],
    range: 3..=3,
};

static WORD_TRIC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRIC_CHILDREN),
    value: None,
};

pub static WORD_TRIC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("key"),
        dictgen::InsensitiveStr::Ascii("kyer"),
    ],
    values: &[&["trickery"], &["trickery"]],
    range: 3..=4,
};

static WORD_TRIB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRIB_CHILDREN),
    value: None,
};

pub static WORD_TRIB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("uanl"),
        dictgen::InsensitiveStr::Ascii("unaal"),
    ],
    values: &[&["tribunal"], &["tribunal"]],
    range: 4..=5,
};

static WORD_TRIA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRIA_CHILDREN),
    value: None,
};

pub static WORD_TRIA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ler"),
        dictgen::InsensitiveStr::Ascii("lers"),
        dictgen::InsensitiveStr::Ascii("ncle"),
        dictgen::InsensitiveStr::Ascii("ncles"),
        dictgen::InsensitiveStr::Ascii("ners"),
        dictgen::InsensitiveStr::Ascii("nge"),
        dictgen::InsensitiveStr::Ascii("ngel"),
        dictgen::InsensitiveStr::Ascii("ngels"),
        dictgen::InsensitiveStr::Ascii("ngls"),
        dictgen::InsensitiveStr::Ascii("nglular"),
        dictgen::InsensitiveStr::Ascii("nglutaion"),
        dictgen::InsensitiveStr::Ascii("ngulataion"),
        dictgen::InsensitiveStr::Ascii("ngultaion"),
        dictgen::InsensitiveStr::Ascii("ning"),
        dictgen::InsensitiveStr::Ascii("nlge"),
        dictgen::InsensitiveStr::Ascii("nlges"),
        dictgen::InsensitiveStr::Ascii("nwreck"),
        dictgen::InsensitiveStr::Ascii("tor"),
        dictgen::InsensitiveStr::Ascii("tors"),
    ],
    values: &[
        &["trailer"],
        &["trailers"],
        &["triangle"],
        &["triangles"],
        &["trainers"],
        &["triangle"],
        &["triangle"],
        &["triangles"],
        &["triangles"],
        &["triangular"],
        &["triangulation"],
        &["triangulation"],
        &["triangulation"],
        &["training"],
        &["triangle"],
        &["triangles"],
        &["trainwreck"],
        &["traitor"],
        &["traitors"],
    ],
    range: 3..=10,
};

static WORD_TRH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRH_CHILDREN),
    value: None,
};

pub static WORD_TRH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("illing"),
        dictgen::InsensitiveStr::Ascii("usters"),
    ],
    values: &[&["the"], &["thrilling"], &["thrusters"]],
    range: 1..=6,
};

static WORD_TRG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRG_CHILDREN),
    value: None,
};

pub static WORD_TRG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("istration")],
    values: &[&["registration"]],
    range: 9..=9,
};

static WORD_TRE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRE_CHILDREN),
    value: Some(&["tree"]),
};

pub static WORD_TRE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("adet"),
        dictgen::InsensitiveStr::Ascii("ak"),
        dictgen::InsensitiveStr::Ascii("asue"),
        dictgen::InsensitiveStr::Ascii("asuers"),
        dictgen::InsensitiveStr::Ascii("asurery"),
        dictgen::InsensitiveStr::Ascii("asurey"),
        dictgen::InsensitiveStr::Ascii("asurs"),
        dictgen::InsensitiveStr::Ascii("ate"),
        dictgen::InsensitiveStr::Ascii("atement"),
        dictgen::InsensitiveStr::Ascii("atements"),
        dictgen::InsensitiveStr::Ascii("ates"),
        dictgen::InsensitiveStr::Ascii("atis"),
        dictgen::InsensitiveStr::Ascii("atmens"),
        dictgen::InsensitiveStr::Ascii("atmet"),
        dictgen::InsensitiveStr::Ascii("atsie"),
        dictgen::InsensitiveStr::Ascii("ausre"),
        dictgen::InsensitiveStr::Ascii("ausres"),
        dictgen::InsensitiveStr::Ascii("dning"),
        dictgen::InsensitiveStr::Ascii("melo"),
        dictgen::InsensitiveStr::Ascii("melos"),
        dictgen::InsensitiveStr::Ascii("memdous"),
        dictgen::InsensitiveStr::Ascii("memdously"),
        dictgen::InsensitiveStr::Ascii("mendeous"),
        dictgen::InsensitiveStr::Ascii("mendious"),
        dictgen::InsensitiveStr::Ascii("mendos"),
        dictgen::InsensitiveStr::Ascii("mendoulsy"),
        dictgen::InsensitiveStr::Ascii("menduous"),
        dictgen::InsensitiveStr::Ascii("mondous"),
        dictgen::InsensitiveStr::Ascii("mondously"),
        dictgen::InsensitiveStr::Ascii("mpoline"),
        dictgen::InsensitiveStr::Ascii("ndig"),
        dictgen::InsensitiveStr::Ascii("shhold"),
        dictgen::InsensitiveStr::Ascii("shold"),
        dictgen::InsensitiveStr::Ascii("spasing"),
        dictgen::InsensitiveStr::Ascii("spessing"),
        dictgen::InsensitiveStr::Ascii("ssle"),
        dictgen::InsensitiveStr::Ascii("sspasing"),
        dictgen::InsensitiveStr::Ascii("suary"),
        dictgen::InsensitiveStr::Ascii("ting"),
    ],
    values: &[
        &["treated"],
        &["treat", "tweak"],
        &["treasure"],
        &["treasures"],
        &["treasury"],
        &["treasury"],
        &["treasures"],
        &["treat"],
        &["treatment"],
        &["treatments"],
        &["treats"],
        &["treaties"],
        &["treatments"],
        &["treatments"],
        &["treaties"],
        &["treasure"],
        &["treasures"],
        &["trending"],
        &["tremolo"],
        &["tremolos"],
        &["tremendous"],
        &["tremendously"],
        &["tremendous"],
        &["tremendous"],
        &["tremendous"],
        &["tremendously"],
        &["tremendous"],
        &["tremendous"],
        &["tremendously"],
        &["trampoline"],
        &["trending"],
        &["threshold"],
        &["threshold"],
        &["trespassing"],
        &["trespassing"],
        &["trestle"],
        &["trespassing"],
        &["treasury"],
        &["treating"],
    ],
    range: 2..=9,
};

static WORD_TRA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_TRA_CHILDREN),
    value: None,
};

static WORD_TRA_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    Some(&WORD_TRAB_NODE),
    Some(&WORD_TRAC_NODE),
    Some(&WORD_TRAD_NODE),
    None,
    Some(&WORD_TRAF_NODE),
    Some(&WORD_TRAG_NODE),
    None,
    Some(&WORD_TRAI_NODE),
    None,
    Some(&WORD_TRAK_NODE),
    Some(&WORD_TRAL_NODE),
    Some(&WORD_TRAM_NODE),
    Some(&WORD_TRAN_NODE),
    None,
    Some(&WORD_TRAP_NODE),
    None,
    None,
    Some(&WORD_TRAS_NODE),
    Some(&WORD_TRAT_NODE),
    Some(&WORD_TRAU_NODE),
    Some(&WORD_TRAV_NODE),
    None,
    None,
    None,
    None,
];

static WORD_TRAV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRAV_CHILDREN),
    value: None,
};

pub static WORD_TRAV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("eersal"),
        dictgen::InsensitiveStr::Ascii("eerse"),
        dictgen::InsensitiveStr::Ascii("eersed"),
        dictgen::InsensitiveStr::Ascii("eerses"),
        dictgen::InsensitiveStr::Ascii("eersing"),
        dictgen::InsensitiveStr::Ascii("eld"),
        dictgen::InsensitiveStr::Ascii("eleres"),
        dictgen::InsensitiveStr::Ascii("eles"),
        dictgen::InsensitiveStr::Ascii("ellerhd"),
        dictgen::InsensitiveStr::Ascii("ellodge"),
        dictgen::InsensitiveStr::Ascii("elodge"),
        dictgen::InsensitiveStr::Ascii("eral"),
        dictgen::InsensitiveStr::Ascii("ercal"),
        dictgen::InsensitiveStr::Ascii("erce"),
        dictgen::InsensitiveStr::Ascii("erced"),
        dictgen::InsensitiveStr::Ascii("erces"),
        dictgen::InsensitiveStr::Ascii("ercing"),
        dictgen::InsensitiveStr::Ascii("ere"),
        dictgen::InsensitiveStr::Ascii("ered"),
        dictgen::InsensitiveStr::Ascii("eres"),
        dictgen::InsensitiveStr::Ascii("eresal"),
        dictgen::InsensitiveStr::Ascii("erese"),
        dictgen::InsensitiveStr::Ascii("eresed"),
        dictgen::InsensitiveStr::Ascii("ereses"),
        dictgen::InsensitiveStr::Ascii("eresing"),
        dictgen::InsensitiveStr::Ascii("ering"),
        dictgen::InsensitiveStr::Ascii("erlers"),
        dictgen::InsensitiveStr::Ascii("erls"),
        dictgen::InsensitiveStr::Ascii("ersare"),
        dictgen::InsensitiveStr::Ascii("ersie"),
        dictgen::InsensitiveStr::Ascii("ersier"),
        dictgen::InsensitiveStr::Ascii("esal"),
        dictgen::InsensitiveStr::Ascii("ese"),
        dictgen::InsensitiveStr::Ascii("esed"),
        dictgen::InsensitiveStr::Ascii("eses"),
        dictgen::InsensitiveStr::Ascii("esing"),
        dictgen::InsensitiveStr::Ascii("estry"),
        dictgen::InsensitiveStr::Ascii("esy"),
        dictgen::InsensitiveStr::Ascii("les"),
    ],
    values: &[
        &["traversed"],
        &["traversal"],
        &["traverse"],
        &["traversed"],
        &["traverses"],
        &["traversing"],
        &["traveled"],
        &["travelers"],
        &["travels"],
        &["travelled"],
        &["travelled"],
        &["traveled"],
        &["traversal"],
        &["traversal"],
        &["traverse"],
        &["traversed"],
        &["traverses"],
        &["traversing"],
        &["traverse"],
        &["traversed"],
        &["traverse"],
        &["traversal"],
        &["traverse", "traverses"],
        &["traversed"],
        &["traverses"],
        &["traversing"],
        &["traversing"],
        &["traverse"],
        &["travels", "traversals"],
        &["traverse"],
        &["traverse"],
        &["traverse"],
        &["traversal"],
        &["traverse"],
        &["traversed"],
        &["traverses"],
        &["traversing"],
        &["travesty"],
        &["travesty"],
        &["travels"],
    ],
    range: 2..=7,
};

static WORD_TRAU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRAU_CHILDREN),
    value: None,
};

pub static WORD_TRAU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("matisch"),
        dictgen::InsensitiveStr::Ascii("metized"),
        dictgen::InsensitiveStr::Ascii("mitized"),
    ],
    values: &[&["traumatic"], &["traumatized"], &["traumatized"]],
    range: 7..=7,
};

static WORD_TRAT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRAT_CHILDREN),
    value: None,
};

pub static WORD_TRAT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ior"),
        dictgen::InsensitiveStr::Ascii("iors"),
    ],
    values: &[&["traitor"], &["traitors"]],
    range: 3..=4,
};

static WORD_TRAS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_TRAS_CHILDREN),
    value: None,
};

static WORD_TRAS_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_TRASA_NODE),
    None,
    Some(&WORD_TRASC_NODE),
    None,
    None,
    Some(&WORD_TRASF_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_TRASL_NODE),
    Some(&WORD_TRASM_NODE),
    Some(&WORD_TRASN_NODE),
    None,
    Some(&WORD_TRASP_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_TRASP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRASP_CHILDREN),
    value: None,
};

pub static WORD_TRASP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arency"),
        dictgen::InsensitiveStr::Ascii("arent"),
        dictgen::InsensitiveStr::Ascii("arently"),
        dictgen::InsensitiveStr::Ascii("ort"),
        dictgen::InsensitiveStr::Ascii("ortable"),
        dictgen::InsensitiveStr::Ascii("orted"),
        dictgen::InsensitiveStr::Ascii("orter"),
        dictgen::InsensitiveStr::Ascii("orts"),
        dictgen::InsensitiveStr::Ascii("ose"),
        dictgen::InsensitiveStr::Ascii("osed"),
        dictgen::InsensitiveStr::Ascii("osition"),
        dictgen::InsensitiveStr::Ascii("ositions"),
    ],
    values: &[
        &["transparency"],
        &["transparent"],
        &["transparently"],
        &["transport"],
        &["transportable"],
        &["transported"],
        &["transporter"],
        &["transports"],
        &["transpose"],
        &["transposed"],
        &["transposition"],
        &["transpositions"],
    ],
    range: 3..=8,
};

static WORD_TRASN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRASN_CHILDREN),
    value: None,
};

pub static WORD_TRASN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("action"),
        dictgen::InsensitiveStr::Ascii("cript"),
        dictgen::InsensitiveStr::Ascii("cripts"),
        dictgen::InsensitiveStr::Ascii("fer"),
        dictgen::InsensitiveStr::Ascii("ferred"),
        dictgen::InsensitiveStr::Ascii("ferring"),
        dictgen::InsensitiveStr::Ascii("fers"),
        dictgen::InsensitiveStr::Ascii("form"),
        dictgen::InsensitiveStr::Ascii("formation"),
        dictgen::InsensitiveStr::Ascii("formed"),
        dictgen::InsensitiveStr::Ascii("former"),
        dictgen::InsensitiveStr::Ascii("formers"),
        dictgen::InsensitiveStr::Ascii("forming"),
        dictgen::InsensitiveStr::Ascii("forms"),
        dictgen::InsensitiveStr::Ascii("gender"),
        dictgen::InsensitiveStr::Ascii("gendered"),
        dictgen::InsensitiveStr::Ascii("late"),
        dictgen::InsensitiveStr::Ascii("lated"),
        dictgen::InsensitiveStr::Ascii("lation"),
        dictgen::InsensitiveStr::Ascii("lations"),
        dictgen::InsensitiveStr::Ascii("lator"),
        dictgen::InsensitiveStr::Ascii("mission"),
        dictgen::InsensitiveStr::Ascii("mitted"),
        dictgen::InsensitiveStr::Ascii("mitter"),
        dictgen::InsensitiveStr::Ascii("parency"),
        dictgen::InsensitiveStr::Ascii("parent"),
        dictgen::InsensitiveStr::Ascii("phobic"),
        dictgen::InsensitiveStr::Ascii("plant"),
        dictgen::InsensitiveStr::Ascii("port"),
        dictgen::InsensitiveStr::Ascii("portation"),
        dictgen::InsensitiveStr::Ascii("ported"),
        dictgen::InsensitiveStr::Ascii("porter"),
        dictgen::InsensitiveStr::Ascii("porting"),
        dictgen::InsensitiveStr::Ascii("ports"),
        dictgen::InsensitiveStr::Ascii("smit"),
    ],
    values: &[
        &["transaction"],
        &["transcript"],
        &["transcripts"],
        &["transfer"],
        &["transferred"],
        &["transferring"],
        &["transfers"],
        &["transform"],
        &["transformation"],
        &["transformed"],
        &["transformer"],
        &["transformers"],
        &["transforming"],
        &["transforms"],
        &["transgender"],
        &["transgendered"],
        &["translate"],
        &["translated"],
        &["translation"],
        &["translations"],
        &["translator"],
        &["transmissions"],
        &["transmitted"],
        &["transmitter"],
        &["transparency"],
        &["transparent"],
        &["transphobic"],
        &["transplant"],
        &["transport"],
        &["transportation"],
        &["transported"],
        &["transporter"],
        &["transporting"],
        &["transports"],
        &["transmit"],
    ],
    range: 3..=9,
};

static WORD_TRASM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRASM_CHILDREN),
    value: None,
};

pub static WORD_TRASM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ission"),
        dictgen::InsensitiveStr::Ascii("it"),
    ],
    values: &[&["transmission"], &["transmit"]],
    range: 2..=6,
};

static WORD_TRASL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRASL_CHILDREN),
    value: None,
};

pub static WORD_TRASL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alate"),
        dictgen::InsensitiveStr::Ascii("alated"),
        dictgen::InsensitiveStr::Ascii("alating"),
        dictgen::InsensitiveStr::Ascii("alation"),
        dictgen::InsensitiveStr::Ascii("alations"),
        dictgen::InsensitiveStr::Ascii("ate"),
        dictgen::InsensitiveStr::Ascii("ated"),
        dictgen::InsensitiveStr::Ascii("ates"),
        dictgen::InsensitiveStr::Ascii("ating"),
        dictgen::InsensitiveStr::Ascii("ation"),
        dictgen::InsensitiveStr::Ascii("ations"),
        dictgen::InsensitiveStr::Ascii("ucency"),
    ],
    values: &[
        &["translate"],
        &["translated"],
        &["translating"],
        &["translation"],
        &["translations"],
        &["translate"],
        &["translated"],
        &["translates"],
        &["translating"],
        &["translation"],
        &["translations"],
        &["translucency"],
    ],
    range: 3..=8,
};

static WORD_TRASF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRASF_CHILDREN),
    value: None,
};

pub static WORD_TRASF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("erred"),
        dictgen::InsensitiveStr::Ascii("ers"),
        dictgen::InsensitiveStr::Ascii("orm"),
        dictgen::InsensitiveStr::Ascii("ormable"),
        dictgen::InsensitiveStr::Ascii("ormation"),
        dictgen::InsensitiveStr::Ascii("ormations"),
        dictgen::InsensitiveStr::Ascii("ormative"),
        dictgen::InsensitiveStr::Ascii("ormed"),
        dictgen::InsensitiveStr::Ascii("ormer"),
        dictgen::InsensitiveStr::Ascii("ormers"),
        dictgen::InsensitiveStr::Ascii("orming"),
        dictgen::InsensitiveStr::Ascii("orms"),
    ],
    values: &[
        &["transfer"],
        &["transferred"],
        &["transfers"],
        &["transform"],
        &["transformable"],
        &["transformation"],
        &["transformations"],
        &["transformative"],
        &["transformed"],
        &["transformer"],
        &["transformers"],
        &["transforming"],
        &["transforms"],
    ],
    range: 2..=9,
};

static WORD_TRASC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRASC_CHILDREN),
    value: None,
};

pub static WORD_TRASC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ation")],
    values: &[&["transaction"]],
    range: 5..=5,
};

static WORD_TRASA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRASA_CHILDREN),
    value: None,
};

pub static WORD_TRASA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ction")],
    values: &[&["transaction"]],
    range: 5..=5,
};

static WORD_TRAP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRAP_CHILDREN),
    value: None,
};

pub static WORD_TRAP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eziod"),
        dictgen::InsensitiveStr::Ascii("eziodal"),
    ],
    values: &[&["trapezoid"], &["trapezoidal"]],
    range: 5..=7,
};

static WORD_TRAN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_TRAN_CHILDREN),
    value: None,
};

static WORD_TRAN_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_TRANA_NODE),
    None,
    Some(&WORD_TRANC_NODE),
    Some(&WORD_TRAND_NODE),
    None,
    Some(&WORD_TRANF_NODE),
    None,
    None,
    Some(&WORD_TRANI_NODE),
    None,
    None,
    Some(&WORD_TRANL_NODE),
    Some(&WORD_TRANM_NODE),
    Some(&WORD_TRANN_NODE),
    None,
    Some(&WORD_TRANP_NODE),
    None,
    None,
    Some(&WORD_TRANS_NODE),
    None,
    None,
    Some(&WORD_TRANV_NODE),
    None,
    None,
    None,
    Some(&WORD_TRANZ_NODE),
];

static WORD_TRANZ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANZ_CHILDREN),
    value: None,
};

pub static WORD_TRANZ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("former"),
        dictgen::InsensitiveStr::Ascii("istor"),
        dictgen::InsensitiveStr::Ascii("itions"),
        dictgen::InsensitiveStr::Ascii("porter"),
    ],
    values: &[
        &["transformer"],
        &["transistor"],
        &["transitions"],
        &["transporter"],
    ],
    range: 5..=6,
};

static WORD_TRANV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANV_CHILDREN),
    value: None,
};

pub static WORD_TRANV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ersing")],
    values: &[&["traversing"]],
    range: 6..=6,
};

static WORD_TRANS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_TRANS_CHILDREN),
    value: None,
};

static WORD_TRANS_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_TRANSA_NODE),
    None,
    Some(&WORD_TRANSC_NODE),
    None,
    Some(&WORD_TRANSE_NODE),
    Some(&WORD_TRANSF_NODE),
    Some(&WORD_TRANSG_NODE),
    Some(&WORD_TRANSH_NODE),
    Some(&WORD_TRANSI_NODE),
    None,
    Some(&WORD_TRANSK_NODE),
    Some(&WORD_TRANSL_NODE),
    Some(&WORD_TRANSM_NODE),
    None,
    Some(&WORD_TRANSO_NODE),
    Some(&WORD_TRANSP_NODE),
    None,
    None,
    Some(&WORD_TRANSS_NODE),
    Some(&WORD_TRANST_NODE),
    Some(&WORD_TRANSU_NODE),
    Some(&WORD_TRANSV_NODE),
    None,
    None,
    Some(&WORD_TRANSY_NODE),
    None,
];

static WORD_TRANSY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSY_CHILDREN),
    value: None,
};

pub static WORD_TRANSY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lmania"),
        dictgen::InsensitiveStr::Ascii("lvanai"),
        dictgen::InsensitiveStr::Ascii("lvannia"),
        dictgen::InsensitiveStr::Ascii("lvnia"),
    ],
    values: &[
        &["transylvania"],
        &["transylvania"],
        &["transylvania"],
        &["transylvania"],
    ],
    range: 5..=7,
};

static WORD_TRANSV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSV_CHILDREN),
    value: None,
};

pub static WORD_TRANSV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("orm"),
        dictgen::InsensitiveStr::Ascii("ormation"),
        dictgen::InsensitiveStr::Ascii("ormed"),
        dictgen::InsensitiveStr::Ascii("orming"),
        dictgen::InsensitiveStr::Ascii("orms"),
    ],
    values: &[
        &["transform"],
        &["transformation"],
        &["transformed"],
        &["transforming"],
        &["transforms"],
    ],
    range: 3..=8,
};

static WORD_TRANSU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSU_CHILDREN),
    value: None,
};

pub static WORD_TRANSU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("lcent")],
    values: &[&["translucent"]],
    range: 5..=5,
};

static WORD_TRANST_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANST_CHILDREN),
    value: None,
};

pub static WORD_TRANST_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ator"),
        dictgen::InsensitiveStr::Ascii("ion"),
        dictgen::InsensitiveStr::Ascii("ions"),
        dictgen::InsensitiveStr::Ascii("ition"),
        dictgen::InsensitiveStr::Ascii("itions"),
        dictgen::InsensitiveStr::Ascii("orm"),
        dictgen::InsensitiveStr::Ascii("ormed"),
    ],
    values: &[
        &["translator"],
        &["transition"],
        &["transitions"],
        &["transition"],
        &["transitions"],
        &["transform"],
        &["transformed"],
    ],
    range: 3..=6,
};

static WORD_TRANSS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSS_CHILDREN),
    value: None,
};

pub static WORD_TRANSS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("end"),
        dictgen::InsensitiveStr::Ascii("euxal"),
        dictgen::InsensitiveStr::Ascii("exal"),
        dictgen::InsensitiveStr::Ascii("exaul"),
        dictgen::InsensitiveStr::Ascii("exuel"),
        dictgen::InsensitiveStr::Ascii("exuella"),
        dictgen::InsensitiveStr::Ascii("mision"),
    ],
    values: &[
        &["transcend"],
        &["transsexual"],
        &["transsexual"],
        &["transsexual"],
        &["transsexual"],
        &["transsexual"],
        &["transmissions"],
    ],
    range: 3..=7,
};

static WORD_TRANSP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_TRANSP_CHILDREN),
    value: None,
};

static WORD_TRANSP_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_TRANSPA_NODE),
    None,
    None,
    None,
    Some(&WORD_TRANSPE_NODE),
    None,
    None,
    Some(&WORD_TRANSPH_NODE),
    None,
    None,
    None,
    Some(&WORD_TRANSPL_NODE),
    None,
    None,
    Some(&WORD_TRANSPO_NODE),
    None,
    None,
    Some(&WORD_TRANSPR_NODE),
    Some(&WORD_TRANSPS_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_TRANSPS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSPS_CHILDREN),
    value: None,
};

pub static WORD_TRANSPS_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[dictgen::InsensitiveStr::Ascii("ition")],
        values: &[&["transposition"]],
        range: 5..=5,
    };

static WORD_TRANSPR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSPR_CHILDREN),
    value: None,
};

pub static WORD_TRANSPR_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[
            dictgen::InsensitiveStr::Ascii("encies"),
            dictgen::InsensitiveStr::Ascii("ency"),
            dictgen::InsensitiveStr::Ascii("ent"),
            dictgen::InsensitiveStr::Ascii("ently"),
            dictgen::InsensitiveStr::Ascii("ot"),
            dictgen::InsensitiveStr::Ascii("oted"),
            dictgen::InsensitiveStr::Ascii("oting"),
            dictgen::InsensitiveStr::Ascii("ots"),
            dictgen::InsensitiveStr::Ascii("t"),
            dictgen::InsensitiveStr::Ascii("ted"),
            dictgen::InsensitiveStr::Ascii("ting"),
            dictgen::InsensitiveStr::Ascii("ts"),
        ],
        values: &[
            &["transparencies"],
            &["transparency"],
            &["transparent"],
            &["transparently"],
            &["transport"],
            &["transported"],
            &["transporting"],
            &["transports"],
            &["transport"],
            &["transported"],
            &["transporting"],
            &["transports"],
        ],
        range: 1..=6,
    };

static WORD_TRANSPO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSPO_CHILDREN),
    value: None,
};

pub static WORD_TRANSPO_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[
            dictgen::InsensitiveStr::Ascii("der"),
            dictgen::InsensitiveStr::Ascii("ration"),
            dictgen::InsensitiveStr::Ascii("rder"),
            dictgen::InsensitiveStr::Ascii("ring"),
            dictgen::InsensitiveStr::Ascii("rtaion"),
            dictgen::InsensitiveStr::Ascii("rtar"),
            dictgen::InsensitiveStr::Ascii("rtarme"),
            dictgen::InsensitiveStr::Ascii("rtarse"),
            dictgen::InsensitiveStr::Ascii("rtarte"),
            dictgen::InsensitiveStr::Ascii("rtatin"),
            dictgen::InsensitiveStr::Ascii("rteur"),
            dictgen::InsensitiveStr::Ascii("rteurs"),
            dictgen::InsensitiveStr::Ascii("rtion"),
            dictgen::InsensitiveStr::Ascii("rtng"),
            dictgen::InsensitiveStr::Ascii("rtor"),
            dictgen::InsensitiveStr::Ascii("rtr"),
            dictgen::InsensitiveStr::Ascii("t"),
            dictgen::InsensitiveStr::Ascii("tting"),
        ],
        values: &[
            &["transported"],
            &["transportation"],
            &["transporter"],
            &["transporting"],
            &["transportation"],
            &["transporter"],
            &["transporter"],
            &["transporter"],
            &["transporter"],
            &["transportation"],
            &["transporter"],
            &["transporter"],
            &["transporting"],
            &["transporting"],
            &["transporter"],
            &["transporter"],
            &["transport"],
            &["transporting"],
        ],
        range: 1..=6,
    };

static WORD_TRANSPL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSPL_CHILDREN),
    value: None,
};

pub static WORD_TRANSPL_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[
            dictgen::InsensitiveStr::Ascii("ain"),
            dictgen::InsensitiveStr::Ascii("anet"),
            dictgen::InsensitiveStr::Ascii("antees"),
            dictgen::InsensitiveStr::Ascii("antes"),
            dictgen::InsensitiveStr::Ascii("at"),
            dictgen::InsensitiveStr::Ascii("ate"),
            dictgen::InsensitiveStr::Ascii("ats"),
        ],
        values: &[
            &["transplant"],
            &["transplant"],
            &["transplants"],
            &["transplants"],
            &["transplant"],
            &["transplant"],
            &["transplants"],
        ],
        range: 2..=6,
    };

static WORD_TRANSPH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSPH_CHILDREN),
    value: None,
};

pub static WORD_TRANSPH_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[
            dictgen::InsensitiveStr::Ascii("oic"),
            dictgen::InsensitiveStr::Ascii("onic"),
            dictgen::InsensitiveStr::Ascii("opic"),
        ],
        values: &[&["transphobic"], &["transphobic"], &["transphobic"]],
        range: 3..=4,
    };

static WORD_TRANSPE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSPE_CHILDREN),
    value: None,
};

pub static WORD_TRANSPE_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[
            dictgen::InsensitiveStr::Ascii("ncies"),
            dictgen::InsensitiveStr::Ascii("ncy"),
            dictgen::InsensitiveStr::Ascii("orted"),
            dictgen::InsensitiveStr::Ascii("rancies"),
            dictgen::InsensitiveStr::Ascii("rancy"),
            dictgen::InsensitiveStr::Ascii("rant"),
            dictgen::InsensitiveStr::Ascii("rantly"),
            dictgen::InsensitiveStr::Ascii("rencies"),
            dictgen::InsensitiveStr::Ascii("rency"),
            dictgen::InsensitiveStr::Ascii("rent"),
            dictgen::InsensitiveStr::Ascii("rently"),
        ],
        values: &[
            &["transparencies"],
            &["transparency"],
            &["transported"],
            &["transparencies"],
            &["transparency"],
            &["transparent"],
            &["transparently"],
            &["transparencies"],
            &["transparency"],
            &["transparent"],
            &["transparently"],
        ],
        range: 3..=7,
    };

static WORD_TRANSPA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSPA_CHILDREN),
    value: None,
};

pub static WORD_TRANSPA_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[
            dictgen::InsensitiveStr::Ascii("ble"),
            dictgen::InsensitiveStr::Ascii("cencies"),
            dictgen::InsensitiveStr::Ascii("cency"),
            dictgen::InsensitiveStr::Ascii("ernt"),
            dictgen::InsensitiveStr::Ascii("erntly"),
            dictgen::InsensitiveStr::Ascii("lnt"),
            dictgen::InsensitiveStr::Ascii("ncies"),
            dictgen::InsensitiveStr::Ascii("ncy"),
            dictgen::InsensitiveStr::Ascii("nt"),
            dictgen::InsensitiveStr::Ascii("raent"),
            dictgen::InsensitiveStr::Ascii("raently"),
            dictgen::InsensitiveStr::Ascii("ranceies"),
            dictgen::InsensitiveStr::Ascii("rancey"),
            dictgen::InsensitiveStr::Ascii("rancies"),
            dictgen::InsensitiveStr::Ascii("rancy"),
            dictgen::InsensitiveStr::Ascii("ranet"),
            dictgen::InsensitiveStr::Ascii("ranetly"),
            dictgen::InsensitiveStr::Ascii("ranies"),
            dictgen::InsensitiveStr::Ascii("rant"),
            dictgen::InsensitiveStr::Ascii("rantie"),
            dictgen::InsensitiveStr::Ascii("rantly"),
            dictgen::InsensitiveStr::Ascii("rany"),
            dictgen::InsensitiveStr::Ascii("rarent"),
            dictgen::InsensitiveStr::Ascii("rarently"),
            dictgen::InsensitiveStr::Ascii("rcencies"),
            dictgen::InsensitiveStr::Ascii("rcency"),
            dictgen::InsensitiveStr::Ascii("rcenies"),
            dictgen::InsensitiveStr::Ascii("rceny"),
            dictgen::InsensitiveStr::Ascii("recy"),
            dictgen::InsensitiveStr::Ascii("rentcy"),
            dictgen::InsensitiveStr::Ascii("renty"),
            dictgen::InsensitiveStr::Ascii("reny"),
            dictgen::InsensitiveStr::Ascii("rities"),
            dictgen::InsensitiveStr::Ascii("rity"),
            dictgen::InsensitiveStr::Ascii("rnecies"),
            dictgen::InsensitiveStr::Ascii("rnecy"),
            dictgen::InsensitiveStr::Ascii("rnt"),
            dictgen::InsensitiveStr::Ascii("rntly"),
            dictgen::InsensitiveStr::Ascii("rren"),
            dictgen::InsensitiveStr::Ascii("rrenly"),
            dictgen::InsensitiveStr::Ascii("rrent"),
            dictgen::InsensitiveStr::Ascii("rrently"),
            dictgen::InsensitiveStr::Ascii("rt"),
            dictgen::InsensitiveStr::Ascii("rts"),
            dictgen::InsensitiveStr::Ascii("trent"),
            dictgen::InsensitiveStr::Ascii("trently"),
        ],
        values: &[
            &["transposable"],
            &["transparencies"],
            &["transparency"],
            &["transparent"],
            &["transparently"],
            &["transplants"],
            &["transparencies"],
            &["transparency"],
            &["transplant"],
            &["transparent"],
            &["transparently"],
            &["transparencies"],
            &["transparency"],
            &["transparencies"],
            &["transparency"],
            &["transparent"],
            &["transparently"],
            &["transparencies"],
            &["transparent"],
            &["transparent"],
            &["transparently"],
            &["transparency"],
            &["transparent"],
            &["transparently"],
            &["transparencies"],
            &["transparency"],
            &["transparencies"],
            &["transparency"],
            &["transparency"],
            &["transparency"],
            &["transparency"],
            &["transparency"],
            &["transparencies"],
            &["transparency"],
            &["transparencies"],
            &["transparency"],
            &["transparent"],
            &["transparently"],
            &["transparent"],
            &["transparently"],
            &["transparent"],
            &["transparently"],
            &["transport"],
            &["transports"],
            &["transparent"],
            &["transparently"],
        ],
        range: 2..=8,
    };

static WORD_TRANSO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSO_CHILDREN),
    value: None,
};

pub static WORD_TRANSO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cde"),
        dictgen::InsensitiveStr::Ascii("cded"),
        dictgen::InsensitiveStr::Ascii("cder"),
        dictgen::InsensitiveStr::Ascii("cders"),
        dictgen::InsensitiveStr::Ascii("cdes"),
        dictgen::InsensitiveStr::Ascii("cding"),
        dictgen::InsensitiveStr::Ascii("cdings"),
        dictgen::InsensitiveStr::Ascii("frm"),
        dictgen::InsensitiveStr::Ascii("frmation"),
        dictgen::InsensitiveStr::Ascii("frmed"),
        dictgen::InsensitiveStr::Ascii("frmers"),
        dictgen::InsensitiveStr::Ascii("frming"),
        dictgen::InsensitiveStr::Ascii("hobic"),
        dictgen::InsensitiveStr::Ascii("late"),
        dictgen::InsensitiveStr::Ascii("lated"),
        dictgen::InsensitiveStr::Ascii("lates"),
        dictgen::InsensitiveStr::Ascii("lating"),
        dictgen::InsensitiveStr::Ascii("lation"),
        dictgen::InsensitiveStr::Ascii("lations"),
        dictgen::InsensitiveStr::Ascii("rm"),
        dictgen::InsensitiveStr::Ascii("rmed"),
        dictgen::InsensitiveStr::Ascii("rming"),
        dictgen::InsensitiveStr::Ascii("rms"),
    ],
    values: &[
        &["transcode"],
        &["transcoded"],
        &["transcoder"],
        &["transcoders"],
        &["transcodes"],
        &["transcoding"],
        &["transcodings"],
        &["transform"],
        &["transformation"],
        &["transformed"],
        &["transformers"],
        &["transforming"],
        &["transphobic"],
        &["translate"],
        &["translated"],
        &["translates"],
        &["translating"],
        &["translation"],
        &["translations"],
        &["transform"],
        &["transformed"],
        &["transforming"],
        &["transforms"],
    ],
    range: 2..=8,
};

static WORD_TRANSM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSM_CHILDREN),
    value: None,
};

pub static WORD_TRANSM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("atter"),
        dictgen::InsensitiveStr::Ascii("ision"),
        dictgen::InsensitiveStr::Ascii("isions"),
        dictgen::InsensitiveStr::Ascii("isison"),
        dictgen::InsensitiveStr::Ascii("isisons"),
        dictgen::InsensitiveStr::Ascii("isive"),
        dictgen::InsensitiveStr::Ascii("issable"),
        dictgen::InsensitiveStr::Ascii("issin"),
        dictgen::InsensitiveStr::Ascii("issione"),
        dictgen::InsensitiveStr::Ascii("isson"),
        dictgen::InsensitiveStr::Ascii("issons"),
        dictgen::InsensitiveStr::Ascii("isssion"),
        dictgen::InsensitiveStr::Ascii("ist"),
        dictgen::InsensitiveStr::Ascii("ited"),
        dictgen::InsensitiveStr::Ascii("iter"),
        dictgen::InsensitiveStr::Ascii("iters"),
        dictgen::InsensitiveStr::Ascii("iting"),
        dictgen::InsensitiveStr::Ascii("ition"),
        dictgen::InsensitiveStr::Ascii("itirte"),
        dictgen::InsensitiveStr::Ascii("itor"),
        dictgen::InsensitiveStr::Ascii("itsion"),
        dictgen::InsensitiveStr::Ascii("ittd"),
        dictgen::InsensitiveStr::Ascii("ittion"),
        dictgen::InsensitiveStr::Ascii("ittor"),
        dictgen::InsensitiveStr::Ascii("itts"),
        dictgen::InsensitiveStr::Ascii("ittted"),
        dictgen::InsensitiveStr::Ascii("mit"),
        dictgen::InsensitiveStr::Ascii("orfers"),
        dictgen::InsensitiveStr::Ascii("orged"),
        dictgen::InsensitiveStr::Ascii("orgs"),
        dictgen::InsensitiveStr::Ascii("utter"),
    ],
    values: &[
        &["transmitter"],
        &["transmission"],
        &["transmission"],
        &["transmission"],
        &["transmissions"],
        &["transmissive"],
        &["transmissible"],
        &["transmissions"],
        &["transmission"],
        &["transmission"],
        &["transmissions"],
        &["transmissions"],
        &["transmit"],
        &["transmitted"],
        &["transmitter"],
        &["transmitters"],
        &["transmitting"],
        &["transmission"],
        &["transmitter"],
        &["transistor"],
        &["transmission"],
        &["transmitted"],
        &["transmission"],
        &["transmitter"],
        &["transmits"],
        &["transmitted"],
        &["transmit"],
        &["transformer"],
        &["transformed"],
        &["transforms"],
        &["transmitter"],
    ],
    range: 3..=7,
};

static WORD_TRANSL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSL_CHILDREN),
    value: None,
};

pub static WORD_TRANSL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("astion"),
        dictgen::InsensitiveStr::Ascii("ateing"),
        dictgen::InsensitiveStr::Ascii("ater"),
        dictgen::InsensitiveStr::Ascii("aters"),
        dictgen::InsensitiveStr::Ascii("atied"),
        dictgen::InsensitiveStr::Ascii("atin"),
        dictgen::InsensitiveStr::Ascii("atio"),
        dictgen::InsensitiveStr::Ascii("ationg"),
        dictgen::InsensitiveStr::Ascii("atoin"),
        dictgen::InsensitiveStr::Ascii("atoins"),
        dictgen::InsensitiveStr::Ascii("atron"),
        dictgen::InsensitiveStr::Ascii("pant"),
        dictgen::InsensitiveStr::Ascii("teration"),
        dictgen::InsensitiveStr::Ascii("ucient"),
        dictgen::InsensitiveStr::Ascii("uent"),
        dictgen::InsensitiveStr::Ascii("usent"),
        dictgen::InsensitiveStr::Ascii("yvania"),
        dictgen::InsensitiveStr::Ascii("yvanian"),
    ],
    values: &[
        &["translations"],
        &["translating"],
        &["translator"],
        &["translators"],
        &["translated"],
        &["translations"],
        &["translator"],
        &["translating"],
        &["translation"],
        &["translations"],
        &["translation"],
        &["transplants"],
        &["transliteration"],
        &["translucent"],
        &["translucent"],
        &["translucent"],
        &["transylvania"],
        &["transylvania"],
    ],
    range: 4..=8,
};

static WORD_TRANSK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSK_CHILDREN),
    value: None,
};

pub static WORD_TRANSK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ript"),
        dictgen::InsensitiveStr::Ascii("ription"),
    ],
    values: &[&["transcript"], &["transcription"]],
    range: 4..=7,
};

static WORD_TRANSI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSI_CHILDREN),
    value: None,
};

pub static WORD_TRANSI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cion"),
        dictgen::InsensitiveStr::Ascii("cional"),
        dictgen::InsensitiveStr::Ascii("et"),
        dictgen::InsensitiveStr::Ascii("lvania"),
        dictgen::InsensitiveStr::Ascii("mssion"),
        dictgen::InsensitiveStr::Ascii("sion"),
        dictgen::InsensitiveStr::Ascii("sioned"),
        dictgen::InsensitiveStr::Ascii("sioning"),
        dictgen::InsensitiveStr::Ascii("sions"),
        dictgen::InsensitiveStr::Ascii("sition"),
        dictgen::InsensitiveStr::Ascii("sitor"),
        dictgen::InsensitiveStr::Ascii("ster"),
        dictgen::InsensitiveStr::Ascii("stion"),
        dictgen::InsensitiveStr::Ascii("stions"),
        dictgen::InsensitiveStr::Ascii("stior"),
        dictgen::InsensitiveStr::Ascii("ten"),
        dictgen::InsensitiveStr::Ascii("tin"),
        dictgen::InsensitiveStr::Ascii("tionable"),
        dictgen::InsensitiveStr::Ascii("tionals"),
        dictgen::InsensitiveStr::Ascii("tiond"),
        dictgen::InsensitiveStr::Ascii("tiong"),
        dictgen::InsensitiveStr::Ascii("tionnal"),
        dictgen::InsensitiveStr::Ascii("tionned"),
        dictgen::InsensitiveStr::Ascii("tionning"),
        dictgen::InsensitiveStr::Ascii("to"),
        dictgen::InsensitiveStr::Ascii("ton"),
        dictgen::InsensitiveStr::Ascii("tons"),
        dictgen::InsensitiveStr::Ascii("tor"),
        dictgen::InsensitiveStr::Ascii("tors"),
    ],
    values: &[
        &["transition"],
        &["transitional"],
        &["transient"],
        &["transylvania"],
        &["transmissions"],
        &["transition"],
        &["transitioned"],
        &["transitioning"],
        &["transitions"],
        &["transition"],
        &["transistor"],
        &["transistor"],
        &["transition"],
        &["transitions"],
        &["transistor"],
        &["transient"],
        &["transitions"],
        &["transitional"],
        &["transitions"],
        &["transitioned"],
        &["transitioning"],
        &["transitional"],
        &["transitioned"],
        &["transitioning"],
        &["transition"],
        &["transition"],
        &["transitions"],
        &["transistor"],
        &["transistor", "transistors"],
    ],
    range: 2..=8,
};

static WORD_TRANSH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSH_CHILDREN),
    value: None,
};

pub static WORD_TRANSH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("pobic")],
    values: &[&["transphobic"]],
    range: 5..=5,
};

static WORD_TRANSG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSG_CHILDREN),
    value: None,
};

pub static WORD_TRANSG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eder"),
        dictgen::InsensitiveStr::Ascii("emder"),
        dictgen::InsensitiveStr::Ascii("ended"),
        dictgen::InsensitiveStr::Ascii("enderd"),
        dictgen::InsensitiveStr::Ascii("endred"),
        dictgen::InsensitiveStr::Ascii("ener"),
        dictgen::InsensitiveStr::Ascii("enered"),
        dictgen::InsensitiveStr::Ascii("enger"),
        dictgen::InsensitiveStr::Ascii("engered"),
        dictgen::InsensitiveStr::Ascii("enres"),
    ],
    values: &[
        &["transgender"],
        &["transgender"],
        &["transgender"],
        &["transgendered"],
        &["transgendered"],
        &["transgender"],
        &["transgendered"],
        &["transgender"],
        &["transgendered"],
        &["transgender"],
    ],
    range: 4..=7,
};

static WORD_TRANSF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSF_CHILDREN),
    value: None,
};

pub static WORD_TRANSF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("armers"),
        dictgen::InsensitiveStr::Ascii("arring"),
        dictgen::InsensitiveStr::Ascii("ender"),
        dictgen::InsensitiveStr::Ascii("erd"),
        dictgen::InsensitiveStr::Ascii("ere"),
        dictgen::InsensitiveStr::Ascii("ered"),
        dictgen::InsensitiveStr::Ascii("erer"),
        dictgen::InsensitiveStr::Ascii("erers"),
        dictgen::InsensitiveStr::Ascii("eres"),
        dictgen::InsensitiveStr::Ascii("ering"),
        dictgen::InsensitiveStr::Ascii("errd"),
        dictgen::InsensitiveStr::Ascii("errred"),
        dictgen::InsensitiveStr::Ascii("errring"),
        dictgen::InsensitiveStr::Ascii("errs"),
        dictgen::InsensitiveStr::Ascii("ersom"),
        dictgen::InsensitiveStr::Ascii("ert"),
        dictgen::InsensitiveStr::Ascii("erts"),
        dictgen::InsensitiveStr::Ascii("om"),
        dictgen::InsensitiveStr::Ascii("omation"),
        dictgen::InsensitiveStr::Ascii("omational"),
        dictgen::InsensitiveStr::Ascii("omed"),
        dictgen::InsensitiveStr::Ascii("omer"),
        dictgen::InsensitiveStr::Ascii("omers"),
        dictgen::InsensitiveStr::Ascii("omm"),
        dictgen::InsensitiveStr::Ascii("oprmation"),
        dictgen::InsensitiveStr::Ascii("oration"),
        dictgen::InsensitiveStr::Ascii("orations"),
        dictgen::InsensitiveStr::Ascii("ored"),
        dictgen::InsensitiveStr::Ascii("ormacion"),
        dictgen::InsensitiveStr::Ascii("ormare"),
        dictgen::InsensitiveStr::Ascii("ormarea"),
        dictgen::InsensitiveStr::Ascii("ormarem"),
        dictgen::InsensitiveStr::Ascii("ormarse"),
        dictgen::InsensitiveStr::Ascii("ormas"),
        dictgen::InsensitiveStr::Ascii("ormase"),
        dictgen::InsensitiveStr::Ascii("ormated"),
        dictgen::InsensitiveStr::Ascii("ormates"),
        dictgen::InsensitiveStr::Ascii("ormaton"),
        dictgen::InsensitiveStr::Ascii("ormatted"),
        dictgen::InsensitiveStr::Ascii("orme"),
        dictgen::InsensitiveStr::Ascii("ormees"),
        dictgen::InsensitiveStr::Ascii("ormered"),
        dictgen::InsensitiveStr::Ascii("ormes"),
        dictgen::InsensitiveStr::Ascii("ormis"),
        dictgen::InsensitiveStr::Ascii("ormus"),
        dictgen::InsensitiveStr::Ascii("orners"),
        dictgen::InsensitiveStr::Ascii("ors"),
        dictgen::InsensitiveStr::Ascii("orums"),
        dictgen::InsensitiveStr::Ascii("os"),
        dictgen::InsensitiveStr::Ascii("rom"),
        dictgen::InsensitiveStr::Ascii("romate"),
        dictgen::InsensitiveStr::Ascii("romation"),
        dictgen::InsensitiveStr::Ascii("romations"),
        dictgen::InsensitiveStr::Ascii("romed"),
        dictgen::InsensitiveStr::Ascii("romer"),
        dictgen::InsensitiveStr::Ascii("romers"),
        dictgen::InsensitiveStr::Ascii("roming"),
        dictgen::InsensitiveStr::Ascii("roms"),
    ],
    values: &[
        &["transformers"],
        &["transferring"],
        &["transgender"],
        &["transferred"],
        &["transferred"],
        &["transferred"],
        &["transferred"],
        &["transfers"],
        &["transfers"],
        &["transferring"],
        &["transferred"],
        &["transferred"],
        &["transferring"],
        &["transfers"],
        &["transforms"],
        &["transfer", "transferred"],
        &["transfers"],
        &["transform"],
        &["transformation"],
        &["transformational"],
        &["transformed"],
        &["transformer"],
        &["transforms"],
        &["transform"],
        &["transformation"],
        &["transformation"],
        &["transformations"],
        &["transformed"],
        &["transformation"],
        &["transformers"],
        &["transformer"],
        &["transformer"],
        &["transformers"],
        &["transforms"],
        &["transforms"],
        &["transformed"],
        &["transforms"],
        &["transformation"],
        &["transformed"],
        &["transfer", "transformed", "transformer", "transform"],
        &["transforms"],
        &["transformed"],
        &["transformers"],
        &["transforms"],
        &["transforms"],
        &["transformers"],
        &["transforms"],
        &["transforms"],
        &["transforms"],
        &["transform"],
        &["transform", "transformed"],
        &["transformation"],
        &["transformations"],
        &["transformed"],
        &["transformers", "transformer"],
        &["transformers"],
        &["transforming"],
        &["transforms"],
    ],
    range: 2..=9,
};

static WORD_TRANSE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSE_CHILDREN),
    value: None,
};

pub static WORD_TRANSE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("at"),
        dictgen::InsensitiveStr::Ascii("int"),
        dictgen::InsensitiveStr::Ascii("nding"),
        dictgen::InsensitiveStr::Ascii("r"),
        dictgen::InsensitiveStr::Ascii("sxuals"),
    ],
    values: &[
        &["translates"],
        &["transient"],
        &["transcending"],
        &["transfer"],
        &["transsexuals"],
    ],
    range: 1..=6,
};

static WORD_TRANSC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSC_CHILDREN),
    value: None,
};

pub static WORD_TRANSC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ations"),
        dictgen::InsensitiveStr::Ascii("endance"),
        dictgen::InsensitiveStr::Ascii("endant"),
        dictgen::InsensitiveStr::Ascii("endentational"),
        dictgen::InsensitiveStr::Ascii("evier"),
        dictgen::InsensitiveStr::Ascii("iever"),
        dictgen::InsensitiveStr::Ascii("ievers"),
        dictgen::InsensitiveStr::Ascii("iprt"),
        dictgen::InsensitiveStr::Ascii("irpt"),
        dictgen::InsensitiveStr::Ascii("luent"),
        dictgen::InsensitiveStr::Ascii("ocde"),
        dictgen::InsensitiveStr::Ascii("ocded"),
        dictgen::InsensitiveStr::Ascii("ocder"),
        dictgen::InsensitiveStr::Ascii("ocders"),
        dictgen::InsensitiveStr::Ascii("ocdes"),
        dictgen::InsensitiveStr::Ascii("ocding"),
        dictgen::InsensitiveStr::Ascii("ocdings"),
        dictgen::InsensitiveStr::Ascii("onde"),
        dictgen::InsensitiveStr::Ascii("onded"),
        dictgen::InsensitiveStr::Ascii("onder"),
        dictgen::InsensitiveStr::Ascii("onders"),
        dictgen::InsensitiveStr::Ascii("ondes"),
        dictgen::InsensitiveStr::Ascii("onding"),
        dictgen::InsensitiveStr::Ascii("ondings"),
        dictgen::InsensitiveStr::Ascii("orde"),
        dictgen::InsensitiveStr::Ascii("orded"),
        dictgen::InsensitiveStr::Ascii("order"),
        dictgen::InsensitiveStr::Ascii("orders"),
        dictgen::InsensitiveStr::Ascii("ordes"),
        dictgen::InsensitiveStr::Ascii("ording"),
        dictgen::InsensitiveStr::Ascii("ordings"),
        dictgen::InsensitiveStr::Ascii("oser"),
        dictgen::InsensitiveStr::Ascii("osers"),
        dictgen::InsensitiveStr::Ascii("ribtion"),
        dictgen::InsensitiveStr::Ascii("ripcion"),
        dictgen::InsensitiveStr::Ascii("rips"),
        dictgen::InsensitiveStr::Ascii("ripting"),
        dictgen::InsensitiveStr::Ascii("ripto"),
        dictgen::InsensitiveStr::Ascii("ripton"),
        dictgen::InsensitiveStr::Ascii("riptus"),
        dictgen::InsensitiveStr::Ascii("ris"),
        dictgen::InsensitiveStr::Ascii("rit"),
        dictgen::InsensitiveStr::Ascii("rito"),
        dictgen::InsensitiveStr::Ascii("rits"),
        dictgen::InsensitiveStr::Ascii("rpit"),
        dictgen::InsensitiveStr::Ascii("tions"),
        dictgen::InsensitiveStr::Ascii("ulent"),
    ],
    values: &[
        &["transactions"],
        &["transcendence"],
        &["transcendent"],
        &["transcendental"],
        &["transceiver"],
        &["transceiver"],
        &["transceivers"],
        &["transcripts"],
        &["transcripts"],
        &["translucent"],
        &["transcode"],
        &["transcoded"],
        &["transcoder"],
        &["transcoders"],
        &["transcodes"],
        &["transcoding"],
        &["transcodings"],
        &["transcode"],
        &["transcoded"],
        &["transcoder"],
        &["transcoders"],
        &["transcodes"],
        &["transcoding"],
        &["transcodings"],
        &["transcode"],
        &["transcoded"],
        &["transcoder"],
        &["transcoders"],
        &["transcodes"],
        &["transcoding"],
        &["transcodings"],
        &["transcoder"],
        &["transcoders"],
        &["transcription"],
        &["transcription"],
        &["transcripts"],
        &["transcribing", "transcription"],
        &["transcription"],
        &["transcription"],
        &["transcripts"],
        &["transcripts"],
        &["transcript"],
        &["transcript"],
        &["transcripts"],
        &["transcript"],
        &["transitions"],
        &["translucent"],
    ],
    range: 3..=13,
};

static WORD_TRANSA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANSA_CHILDREN),
    value: None,
};

pub static WORD_TRANSA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ccion"),
        dictgen::InsensitiveStr::Ascii("cion"),
        dictgen::InsensitiveStr::Ascii("citon"),
        dictgen::InsensitiveStr::Ascii("ctoin"),
        dictgen::InsensitiveStr::Ascii("ition"),
        dictgen::InsensitiveStr::Ascii("itions"),
        dictgen::InsensitiveStr::Ascii("lation"),
        dictgen::InsensitiveStr::Ascii("lations"),
        dictgen::InsensitiveStr::Ascii("lt"),
        dictgen::InsensitiveStr::Ascii("lte"),
        dictgen::InsensitiveStr::Ascii("lted"),
        dictgen::InsensitiveStr::Ascii("ltes"),
        dictgen::InsensitiveStr::Ascii("lting"),
        dictgen::InsensitiveStr::Ascii("ltion"),
        dictgen::InsensitiveStr::Ascii("ltions"),
        dictgen::InsensitiveStr::Ascii("ltor"),
        dictgen::InsensitiveStr::Ascii("ltors"),
        dictgen::InsensitiveStr::Ascii("prency"),
        dictgen::InsensitiveStr::Ascii("tion"),
        dictgen::InsensitiveStr::Ascii("tional"),
        dictgen::InsensitiveStr::Ascii("tions"),
    ],
    values: &[
        &["transaction"],
        &["transaction"],
        &["transactions"],
        &["transaction"],
        &["translation", "transition", "transaction"],
        &["translations", "transitions", "transactions"],
        &["translation"],
        &["translations"],
        &["translate"],
        &["translate"],
        &["translated"],
        &["translates"],
        &["translating"],
        &["translation"],
        &["translations"],
        &["translator"],
        &["translators"],
        &["transparency"],
        &["transition", "transaction", "translation"],
        &["transitional"],
        &["transitions", "transactions", "translations"],
    ],
    range: 2..=7,
};

static WORD_TRANP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANP_CHILDREN),
    value: None,
};

pub static WORD_TRANP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arent"),
        dictgen::InsensitiveStr::Ascii("arently"),
        dictgen::InsensitiveStr::Ascii("ort"),
        dictgen::InsensitiveStr::Ascii("ose"),
        dictgen::InsensitiveStr::Ascii("shobic"),
    ],
    values: &[
        &["transparent"],
        &["transparently"],
        &["transport"],
        &["transpose"],
        &["transphobic"],
    ],
    range: 3..=7,
};

static WORD_TRANN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANN_CHILDREN),
    value: None,
};

pub static WORD_TRANN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("sexual")],
    values: &[&["transsexual"]],
    range: 6..=6,
};

static WORD_TRANM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANM_CHILDREN),
    value: None,
};

pub static WORD_TRANM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ission"),
        dictgen::InsensitiveStr::Ascii("ist"),
        dictgen::InsensitiveStr::Ascii("itted"),
        dictgen::InsensitiveStr::Ascii("itting"),
        dictgen::InsensitiveStr::Ascii("sission"),
    ],
    values: &[
        &["transmission"],
        &["transmit"],
        &["transmitted"],
        &["transmitting"],
        &["transmissions"],
    ],
    range: 3..=7,
};

static WORD_TRANL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANL_CHILDREN),
    value: None,
};

pub static WORD_TRANL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("astion"),
        dictgen::InsensitiveStr::Ascii("atable"),
        dictgen::InsensitiveStr::Ascii("ate"),
        dictgen::InsensitiveStr::Ascii("ated"),
        dictgen::InsensitiveStr::Ascii("ates"),
        dictgen::InsensitiveStr::Ascii("ating"),
        dictgen::InsensitiveStr::Ascii("ation"),
        dictgen::InsensitiveStr::Ascii("ations"),
        dictgen::InsensitiveStr::Ascii("sate"),
        dictgen::InsensitiveStr::Ascii("sated"),
        dictgen::InsensitiveStr::Ascii("sating"),
        dictgen::InsensitiveStr::Ascii("sation"),
        dictgen::InsensitiveStr::Ascii("sations"),
        dictgen::InsensitiveStr::Ascii("uscent"),
    ],
    values: &[
        &["translations"],
        &["translatable"],
        &["translate"],
        &["translated"],
        &["translates"],
        &["translating"],
        &["translation"],
        &["translations"],
        &["translate"],
        &["translated"],
        &["translating"],
        &["translation"],
        &["translations"],
        &["translucent"],
    ],
    range: 3..=7,
};

static WORD_TRANI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANI_CHILDREN),
    value: None,
};

pub static WORD_TRANI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ent"),
        dictgen::InsensitiveStr::Ascii("stion"),
        dictgen::InsensitiveStr::Ascii("stional"),
        dictgen::InsensitiveStr::Ascii("stioned"),
        dictgen::InsensitiveStr::Ascii("stioning"),
        dictgen::InsensitiveStr::Ascii("stions"),
    ],
    values: &[
        &["transient"],
        &["transition"],
        &["transitional"],
        &["transitioned"],
        &["transitioning"],
        &["transitions"],
    ],
    range: 3..=8,
};

static WORD_TRANF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANF_CHILDREN),
    value: None,
};

pub static WORD_TRANF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("ered"),
        dictgen::InsensitiveStr::Ascii("ering"),
        dictgen::InsensitiveStr::Ascii("erred"),
        dictgen::InsensitiveStr::Ascii("ers"),
        dictgen::InsensitiveStr::Ascii("orm"),
        dictgen::InsensitiveStr::Ascii("ormable"),
        dictgen::InsensitiveStr::Ascii("ormation"),
        dictgen::InsensitiveStr::Ascii("ormations"),
        dictgen::InsensitiveStr::Ascii("ormative"),
        dictgen::InsensitiveStr::Ascii("ormed"),
        dictgen::InsensitiveStr::Ascii("orming"),
        dictgen::InsensitiveStr::Ascii("orms"),
    ],
    values: &[
        &["transfer"],
        &["transferred"],
        &["transferring"],
        &["transferred"],
        &["transfers"],
        &["transform"],
        &["transformable"],
        &["transformation"],
        &["transformations"],
        &["transformative"],
        &["transformed"],
        &["transforming"],
        &["transforms"],
    ],
    range: 2..=9,
};

static WORD_TRAND_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRAND_CHILDREN),
    value: None,
};

pub static WORD_TRAND_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gender"),
        dictgen::InsensitiveStr::Ascii("itional"),
        dictgen::InsensitiveStr::Ascii("itions"),
    ],
    values: &[&["transgender"], &["transitional"], &["transitions"]],
    range: 6..=7,
};

static WORD_TRANC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANC_CHILDREN),
    value: None,
};

pub static WORD_TRANC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eiver"),
        dictgen::InsensitiveStr::Ascii("eivers"),
        dictgen::InsensitiveStr::Ascii("endent"),
        dictgen::InsensitiveStr::Ascii("ending"),
        dictgen::InsensitiveStr::Ascii("late"),
        dictgen::InsensitiveStr::Ascii("lucent"),
    ],
    values: &[
        &["transceiver"],
        &["transceivers"],
        &["transcendent"],
        &["transcending"],
        &["translate"],
        &["translucent"],
    ],
    range: 4..=6,
};

static WORD_TRANA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRANA_CHILDREN),
    value: None,
};

pub static WORD_TRANA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ction"),
        dictgen::InsensitiveStr::Ascii("ctional"),
        dictgen::InsensitiveStr::Ascii("ctions"),
        dictgen::InsensitiveStr::Ascii("sction"),
    ],
    values: &[
        &["transaction"],
        &["transactional"],
        &["transactions"],
        &["transaction"],
    ],
    range: 5..=7,
};

static WORD_TRAM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRAM_CHILDREN),
    value: None,
};

pub static WORD_TRAM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("a"),
        dictgen::InsensitiveStr::Ascii("autic"),
        dictgen::InsensitiveStr::Ascii("autized"),
        dictgen::InsensitiveStr::Ascii("boline"),
        dictgen::InsensitiveStr::Ascii("endously"),
        dictgen::InsensitiveStr::Ascii("ploine"),
        dictgen::InsensitiveStr::Ascii("polene"),
        dictgen::InsensitiveStr::Ascii("sformers"),
        dictgen::InsensitiveStr::Ascii("sforming"),
        dictgen::InsensitiveStr::Ascii("smit"),
        dictgen::InsensitiveStr::Ascii("smitted"),
        dictgen::InsensitiveStr::Ascii("uatized"),
    ],
    values: &[
        &["trauma"],
        &["traumatic"],
        &["traumatized"],
        &["trampoline"],
        &["tremendously"],
        &["trampoline"],
        &["trampoline"],
        &["transformers"],
        &["transforming"],
        &["transmit"],
        &["transmitted"],
        &["traumatized"],
    ],
    range: 1..=8,
};

static WORD_TRAL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRAL_CHILDREN),
    value: None,
};

pub static WORD_TRAL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ier"),
        dictgen::InsensitiveStr::Ascii("iers"),
        dictgen::InsensitiveStr::Ascii("ing"),
    ],
    values: &[&["trailer"], &["trailers"], &["trailing", "trialing"]],
    range: 3..=4,
};

static WORD_TRAK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRAK_CHILDREN),
    value: None,
};

pub static WORD_TRAK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cers"),
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("ing"),
    ],
    values: &[&["trackers"], &["tracker"], &["tracking"]],
    range: 2..=4,
};

static WORD_TRAI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRAI_CHILDREN),
    value: None,
};

pub static WORD_TRAI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ing"),
        dictgen::InsensitiveStr::Ascii("leras"),
        dictgen::InsensitiveStr::Ascii("les"),
        dictgen::InsensitiveStr::Ascii("lling"),
        dictgen::InsensitiveStr::Ascii("nes"),
        dictgen::InsensitiveStr::Ascii("ngle"),
        dictgen::InsensitiveStr::Ascii("ngles"),
        dictgen::InsensitiveStr::Ascii("ngular"),
        dictgen::InsensitiveStr::Ascii("ngulate"),
        dictgen::InsensitiveStr::Ascii("ngulated"),
        dictgen::InsensitiveStr::Ascii("ngulates"),
        dictgen::InsensitiveStr::Ascii("ngulating"),
        dictgen::InsensitiveStr::Ascii("ngulation"),
        dictgen::InsensitiveStr::Ascii("ngulations"),
        dictgen::InsensitiveStr::Ascii("nig"),
        dictgen::InsensitiveStr::Ascii("nwreak"),
        dictgen::InsensitiveStr::Ascii("nwrek"),
        dictgen::InsensitiveStr::Ascii("toris"),
        dictgen::InsensitiveStr::Ascii("torus"),
        dictgen::InsensitiveStr::Ascii("tour"),
    ],
    values: &[
        &["trailing", "training"],
        &["trailers"],
        &["trailers"],
        &["trailing"],
        &["trainers"],
        &["triangle"],
        &["triangles"],
        &["triangular"],
        &["triangulate"],
        &["triangulated"],
        &["triangulates"],
        &["triangulating"],
        &["triangulation"],
        &["triangulations"],
        &["training"],
        &["trainwreck"],
        &["trainwreck"],
        &["traitors"],
        &["traitors"],
        &["traitor"],
    ],
    range: 3..=10,
};

static WORD_TRAG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRAG_CHILDREN),
    value: None,
};

pub static WORD_TRAG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ectory"),
        dictgen::InsensitiveStr::Ascii("et"),
        dictgen::InsensitiveStr::Ascii("eted"),
        dictgen::InsensitiveStr::Ascii("eting"),
        dictgen::InsensitiveStr::Ascii("ets"),
        dictgen::InsensitiveStr::Ascii("icallly"),
        dictgen::InsensitiveStr::Ascii("icaly"),
    ],
    values: &[
        &["trajectory"],
        &["target"],
        &["targeted"],
        &["targeting"],
        &["targets"],
        &["tragically"],
        &["tragically"],
    ],
    range: 2..=7,
};

static WORD_TRAF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRAF_CHILDREN),
    value: None,
};

pub static WORD_TRAF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ficed"),
        dictgen::InsensitiveStr::Ascii("ficing"),
        dictgen::InsensitiveStr::Ascii("ic"),
    ],
    values: &[&["trafficked"], &["trafficking"], &["traffic"]],
    range: 2..=6,
};

static WORD_TRAD_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRAD_CHILDREN),
    value: None,
};

pub static WORD_TRAD_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gic"),
        dictgen::InsensitiveStr::Ascii("icional"),
        dictgen::InsensitiveStr::Ascii("ionally"),
        dictgen::InsensitiveStr::Ascii("isional"),
        dictgen::InsensitiveStr::Ascii("itilnal"),
        dictgen::InsensitiveStr::Ascii("itiona"),
        dictgen::InsensitiveStr::Ascii("itionaly"),
        dictgen::InsensitiveStr::Ascii("itionel"),
        dictgen::InsensitiveStr::Ascii("itionnal"),
        dictgen::InsensitiveStr::Ascii("itionnally"),
        dictgen::InsensitiveStr::Ascii("itition"),
        dictgen::InsensitiveStr::Ascii("tional"),
        dictgen::InsensitiveStr::Ascii("tionally"),
    ],
    values: &[
        &["tragic"],
        &["traditional"],
        &["traditionally"],
        &["traditional"],
        &["traditional"],
        &["traditional"],
        &["traditionally"],
        &["traditional"],
        &["traditional"],
        &["traditionally"],
        &["tradition"],
        &["traditional"],
        &["traditionally"],
    ],
    range: 3..=10,
};

static WORD_TRAC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRAC_CHILDREN),
    value: None,
};

pub static WORD_TRAC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eablity"),
        dictgen::InsensitiveStr::Ascii("kes"),
        dictgen::InsensitiveStr::Ascii("kign"),
        dictgen::InsensitiveStr::Ascii("kling"),
        dictgen::InsensitiveStr::Ascii("kres"),
        dictgen::InsensitiveStr::Ascii("sode"),
        dictgen::InsensitiveStr::Ascii("soded"),
        dictgen::InsensitiveStr::Ascii("soder"),
        dictgen::InsensitiveStr::Ascii("soders"),
        dictgen::InsensitiveStr::Ascii("sodes"),
        dictgen::InsensitiveStr::Ascii("soding"),
    ],
    values: &[
        &["traceability"],
        &["trackers"],
        &["tracking"],
        &["tracking"],
        &["trackers"],
        &["transcode"],
        &["transcoded"],
        &["transcoder"],
        &["transcoders"],
        &["transcodes"],
        &["transcoding"],
    ],
    range: 3..=7,
};

static WORD_TRAB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TRAB_CHILDREN),
    value: None,
};

pub static WORD_TRAB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ajao"),
        dictgen::InsensitiveStr::Ascii("ajdo"),
        dictgen::InsensitiveStr::Ascii("sform"),
    ],
    values: &[&["trabajo"], &["trabajo"], &["transform"]],
    range: 4..=5,
};

static WORD_TP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TP_CHILDREN),
    value: None,
};

pub static WORD_TP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("yo")],
    values: &[&["typo"]],
    range: 2..=2,
};

static WORD_TO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_TO_CHILDREN),
    value: None,
};

static WORD_TO_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_TOA_NODE),
    Some(&WORD_TOB_NODE),
    Some(&WORD_TOC_NODE),
    Some(&WORD_TOD_NODE),
    Some(&WORD_TOE_NODE),
    None,
    Some(&WORD_TOG_NODE),
    None,
    Some(&WORD_TOI_NODE),
    None,
    None,
    Some(&WORD_TOL_NODE),
    Some(&WORD_TOM_NODE),
    Some(&WORD_TON_NODE),
    Some(&WORD_TOO_NODE),
    Some(&WORD_TOP_NODE),
    None,
    Some(&WORD_TOR_NODE),
    None,
    Some(&WORD_TOT_NODE),
    Some(&WORD_TOU_NODE),
    None,
    Some(&WORD_TOW_NODE),
    Some(&WORD_TOX_NODE),
    None,
    None,
];

static WORD_TOX_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TOX_CHILDREN),
    value: None,
};

pub static WORD_TOX_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("en"),
        dictgen::InsensitiveStr::Ascii("icitity"),
        dictgen::InsensitiveStr::Ascii("icitiy"),
        dictgen::InsensitiveStr::Ascii("iticy"),
    ],
    values: &[&["toxin"], &["toxicity"], &["toxicity"], &["toxicity"]],
    range: 2..=7,
};

static WORD_TOW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TOW_CHILDREN),
    value: None,
};

pub static WORD_TOW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ords"),
        dictgen::InsensitiveStr::Ascii("rad"),
    ],
    values: &[&["towards"], &["toward"]],
    range: 3..=4,
};

static WORD_TOU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TOU_CHILDREN),
    value: None,
};

pub static WORD_TOU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ble"),
        dictgen::InsensitiveStr::Ascii("bles"),
        dictgen::InsensitiveStr::Ascii("bling"),
        dictgen::InsensitiveStr::Ascii("chapd"),
        dictgen::InsensitiveStr::Ascii("chda"),
        dictgen::InsensitiveStr::Ascii("chdwon"),
        dictgen::InsensitiveStr::Ascii("chsceen"),
        dictgen::InsensitiveStr::Ascii("chscreeen"),
        dictgen::InsensitiveStr::Ascii("chscren"),
        dictgen::InsensitiveStr::Ascii("ght"),
        dictgen::InsensitiveStr::Ascii("ghtful"),
        dictgen::InsensitiveStr::Ascii("ghtly"),
        dictgen::InsensitiveStr::Ascii("ghts"),
        dictgen::InsensitiveStr::Ascii("nge"),
        dictgen::InsensitiveStr::Ascii("nrey"),
        dictgen::InsensitiveStr::Ascii("nreys"),
        dictgen::InsensitiveStr::Ascii("ple"),
        dictgen::InsensitiveStr::Ascii("ranment"),
        dictgen::InsensitiveStr::Ascii("ranments"),
        dictgen::InsensitiveStr::Ascii("rch"),
        dictgen::InsensitiveStr::Ascii("risim"),
        dictgen::InsensitiveStr::Ascii("ristas"),
        dictgen::InsensitiveStr::Ascii("ristes"),
        dictgen::InsensitiveStr::Ascii("ristey"),
        dictgen::InsensitiveStr::Ascii("ristly"),
        dictgen::InsensitiveStr::Ascii("ristsy"),
        dictgen::InsensitiveStr::Ascii("risy"),
        dictgen::InsensitiveStr::Ascii("rits"),
        dictgen::InsensitiveStr::Ascii("ritsy"),
        dictgen::InsensitiveStr::Ascii("rmanent"),
        dictgen::InsensitiveStr::Ascii("rnamet"),
        dictgen::InsensitiveStr::Ascii("rnamets"),
        dictgen::InsensitiveStr::Ascii("rnamnet"),
        dictgen::InsensitiveStr::Ascii("rnamnets"),
        dictgen::InsensitiveStr::Ascii("rnemant"),
        dictgen::InsensitiveStr::Ascii("rnemants"),
        dictgen::InsensitiveStr::Ascii("rnement"),
        dictgen::InsensitiveStr::Ascii("rnements"),
        dictgen::InsensitiveStr::Ascii("rnes"),
        dictgen::InsensitiveStr::Ascii("rnmanets"),
        dictgen::InsensitiveStr::Ascii("rnyes"),
        dictgen::InsensitiveStr::Ascii("rsim"),
        dictgen::InsensitiveStr::Ascii("rsit"),
        dictgen::InsensitiveStr::Ascii("rsits"),
        dictgen::InsensitiveStr::Ascii("rsity"),
    ],
    values: &[
        &["trouble"],
        &["troubles"],
        &["troubling"],
        &["touchpad"],
        &["touchpad"],
        &["touchdown"],
        &["touchscreen"],
        &["touchscreen"],
        &["touchscreen"],
        &["thought", "taught", "tough"],
        &["thoughtful"],
        &["tightly"],
        &["thoughts"],
        &["tongue"],
        &["tourney"],
        &["tourneys"],
        &["tuple"],
        &["tournaments"],
        &["tournaments"],
        &["torch", "touch"],
        &["tourism"],
        &["tourists"],
        &["tourists"],
        &["touristy"],
        &["touristy"],
        &["touristy"],
        &["touristy"],
        &["tourist"],
        &["touristy"],
        &["tournaments"],
        &["tournament"],
        &["tournaments"],
        &["tournament"],
        &["tournaments"],
        &["tournament"],
        &["tournaments"],
        &["tournament"],
        &["tournaments"],
        &["tourneys"],
        &["tournaments"],
        &["tourneys"],
        &["tourism"],
        &["tourist"],
        &["tourists"],
        &["touristy"],
    ],
    range: 3..=9,
};

static WORD_TOT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TOT_CHILDREN),
    value: None,
};

pub static WORD_TOT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alitara"),
        dictgen::InsensitiveStr::Ascii("alitaran"),
        dictgen::InsensitiveStr::Ascii("alitarion"),
        dictgen::InsensitiveStr::Ascii("alitarni"),
        dictgen::InsensitiveStr::Ascii("alitatian"),
        dictgen::InsensitiveStr::Ascii("ation"),
        dictgen::InsensitiveStr::Ascii("hiba"),
        dictgen::InsensitiveStr::Ascii("ol"),
        dictgen::InsensitiveStr::Ascii("orial"),
        dictgen::InsensitiveStr::Ascii("orials"),
        dictgen::InsensitiveStr::Ascii("tehnam"),
        dictgen::InsensitiveStr::Ascii("tenahm"),
        dictgen::InsensitiveStr::Ascii("tneham"),
        dictgen::InsensitiveStr::Ascii("urials"),
    ],
    values: &[
        &["totalitarian"],
        &["totalitarian"],
        &["totalitarian"],
        &["totalitarian"],
        &["totalitarian"],
        &["rotation"],
        &["toshiba"],
        &["total"],
        &["tutorial"],
        &["tutorials"],
        &["tottenham"],
        &["tottenham"],
        &["tottenham"],
        &["tutorials"],
    ],
    range: 2..=9,
};

static WORD_TOR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TOR_CHILDREN),
    value: None,
};

pub static WORD_TOR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ando"),
        dictgen::InsensitiveStr::Ascii("andoes"),
        dictgen::InsensitiveStr::Ascii("chilght"),
        dictgen::InsensitiveStr::Ascii("chlgiht"),
        dictgen::InsensitiveStr::Ascii("chligt"),
        dictgen::InsensitiveStr::Ascii("chligth"),
        dictgen::InsensitiveStr::Ascii("elable"),
        dictgen::InsensitiveStr::Ascii("erable"),
        dictgen::InsensitiveStr::Ascii("hclight"),
        dictgen::InsensitiveStr::Ascii("iodal"),
        dictgen::InsensitiveStr::Ascii("itlla"),
        dictgen::InsensitiveStr::Ascii("itllas"),
        dictgen::InsensitiveStr::Ascii("k"),
        dictgen::InsensitiveStr::Ascii("nadoe"),
        dictgen::InsensitiveStr::Ascii("naodes"),
        dictgen::InsensitiveStr::Ascii("ndao"),
        dictgen::InsensitiveStr::Ascii("otise"),
        dictgen::InsensitiveStr::Ascii("pdeo"),
        dictgen::InsensitiveStr::Ascii("peados"),
        dictgen::InsensitiveStr::Ascii("pedeo"),
        dictgen::InsensitiveStr::Ascii("pedos"),
        dictgen::InsensitiveStr::Ascii("phies"),
        dictgen::InsensitiveStr::Ascii("rentas"),
        dictgen::InsensitiveStr::Ascii("rentbig"),
        dictgen::InsensitiveStr::Ascii("renters"),
        dictgen::InsensitiveStr::Ascii("rentes"),
        dictgen::InsensitiveStr::Ascii("rentking"),
        dictgen::InsensitiveStr::Ascii("rentors"),
        dictgen::InsensitiveStr::Ascii("rentting"),
        dictgen::InsensitiveStr::Ascii("rest"),
        dictgen::InsensitiveStr::Ascii("tialls"),
        dictgen::InsensitiveStr::Ascii("tila"),
        dictgen::InsensitiveStr::Ascii("tilini"),
        dictgen::InsensitiveStr::Ascii("tillera"),
        dictgen::InsensitiveStr::Ascii("tillia"),
        dictgen::InsensitiveStr::Ascii("tillias"),
        dictgen::InsensitiveStr::Ascii("tillita"),
        dictgen::InsensitiveStr::Ascii("tillla"),
        dictgen::InsensitiveStr::Ascii("tilllas"),
        dictgen::InsensitiveStr::Ascii("tiose"),
        dictgen::InsensitiveStr::Ascii("tise"),
        dictgen::InsensitiveStr::Ascii("ubleshoot"),
        dictgen::InsensitiveStr::Ascii("ublesome"),
        dictgen::InsensitiveStr::Ascii("uisty"),
        dictgen::InsensitiveStr::Ascii("unament"),
        dictgen::InsensitiveStr::Ascii("unaments"),
        dictgen::InsensitiveStr::Ascii("uney"),
        dictgen::InsensitiveStr::Ascii("uneys"),
        dictgen::InsensitiveStr::Ascii("ward"),
        dictgen::InsensitiveStr::Ascii("wards"),
    ],
    values: &[
        &["tornado"],
        &["tornadoes"],
        &["torchlight"],
        &["torchlight"],
        &["torchlight"],
        &["torchlight"],
        &["tolerable"],
        &["tolerable"],
        &["torchlight"],
        &["toroidal"],
        &["tortilla"],
        &["tortillas"],
        &["torque"],
        &["tornado"],
        &["tornadoes"],
        &["tornado"],
        &["tortoise"],
        &["torpedo"],
        &["torpedoes"],
        &["torpedo"],
        &["torpedoes"],
        &["trophies"],
        &["torrents"],
        &["torrenting"],
        &["torrents"],
        &["torrents"],
        &["torrenting"],
        &["torrents"],
        &["torrenting"],
        &["torrents"],
        &["tortillas"],
        &["tortilla"],
        &["tortellini"],
        &["tortilla"],
        &["tortilla"],
        &["tortilla"],
        &["tortilla"],
        &["tortilla"],
        &["tortilla"],
        &["tortoise"],
        &["tortoise"],
        &["troubleshoot"],
        &["troublesome"],
        &["touristy"],
        &["tournament"],
        &["tournaments"],
        &["tourney"],
        &["tourneys"],
        &["toward"],
        &["towards"],
    ],
    range: 1..=9,
};

static WORD_TOP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TOP_CHILDREN),
    value: None,
};

pub static WORD_TOP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("icaizer"),
        dictgen::InsensitiveStr::Ascii("ologie"),
        dictgen::InsensitiveStr::Ascii("pingest"),
        dictgen::InsensitiveStr::Ascii("pins"),
    ],
    values: &[
        &["topicalizer"],
        &["topology"],
        &["toppings"],
        &["toppings"],
    ],
    range: 4..=7,
};

static WORD_TOO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TOO_CHILDREN),
    value: None,
};

pub static WORD_TOO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("d"),
        dictgen::InsensitiveStr::Ascii("gle"),
        dictgen::InsensitiveStr::Ascii("gling"),
        dictgen::InsensitiveStr::Ascii("kit"),
        dictgen::InsensitiveStr::Ascii("kits"),
        dictgen::InsensitiveStr::Ascii("lar"),
        dictgen::InsensitiveStr::Ascii("lsbox"),
        dictgen::InsensitiveStr::Ascii("m"),
        dictgen::InsensitiveStr::Ascii("o"),
        dictgen::InsensitiveStr::Ascii("s"),
        dictgen::InsensitiveStr::Ascii("thbruch"),
        dictgen::InsensitiveStr::Ascii("thbruth"),
        dictgen::InsensitiveStr::Ascii("thbursh"),
        dictgen::InsensitiveStr::Ascii("thrbush"),
        dictgen::InsensitiveStr::Ascii("tonic"),
    ],
    values: &[
        &["todo"],
        &["toggle"],
        &["toggling"],
        &["toolkit"],
        &["toolkits"],
        &["toolbar"],
        &["toolbox"],
        &["tomb"],
        &["todo"],
        &["tools"],
        &["toothbrush"],
        &["toothbrush"],
        &["toothbrush"],
        &["toothbrush"],
        &["teutonic"],
    ],
    range: 1..=7,
};

static WORD_TON_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TON_CHILDREN),
    value: None,
};

pub static WORD_TON_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("giht"),
        dictgen::InsensitiveStr::Ascii("guers"),
        dictgen::InsensitiveStr::Ascii("ihgt"),
        dictgen::InsensitiveStr::Ascii("uges"),
    ],
    values: &[&["tonight"], &["tongues"], &["tonight"], &["tongues"]],
    range: 4..=5,
};

static WORD_TOM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TOM_CHILDREN),
    value: None,
};

pub static WORD_TOM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("atoe"),
        dictgen::InsensitiveStr::Ascii("atos"),
        dictgen::InsensitiveStr::Ascii("morow"),
        dictgen::InsensitiveStr::Ascii("morrow"),
        dictgen::InsensitiveStr::Ascii("orrrow"),
    ],
    values: &[
        &["tomato"],
        &["tomatoes"],
        &["tomorrow"],
        &["tomorrow"],
        &["tomorrow"],
    ],
    range: 4..=6,
};

static WORD_TOL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TOL_CHILDREN),
    value: None,
};

pub static WORD_TOL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arable"),
        dictgen::InsensitiveStr::Ascii("elerance"),
        dictgen::InsensitiveStr::Ascii("en"),
        dictgen::InsensitiveStr::Ascii("ens"),
        dictgen::InsensitiveStr::Ascii("erabe"),
        dictgen::InsensitiveStr::Ascii("eranz"),
        dictgen::InsensitiveStr::Ascii("erence"),
        dictgen::InsensitiveStr::Ascii("ernce"),
        dictgen::InsensitiveStr::Ascii("iets"),
        dictgen::InsensitiveStr::Ascii("kein"),
        dictgen::InsensitiveStr::Ascii("lerable"),
        dictgen::InsensitiveStr::Ascii("lerance"),
        dictgen::InsensitiveStr::Ascii("lerances"),
    ],
    values: &[
        &["tolerable"],
        &["tolerance"],
        &["token"],
        &["tokens"],
        &["tolerable"],
        &["tolerance"],
        &["tolerance"],
        &["tolerance"],
        &["toilets"],
        &["tolkien"],
        &["tolerable"],
        &["tolerance"],
        &["tolerances"],
    ],
    range: 2..=8,
};

static WORD_TOI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TOI_CHILDREN),
    value: Some(&["to", "toy"]),
};

pub static WORD_TOI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("letts")],
    values: &[&["toilets"]],
    range: 5..=5,
};

static WORD_TOG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TOG_CHILDREN),
    value: None,
};

pub static WORD_TOG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ehter"),
        dictgen::InsensitiveStr::Ascii("gel"),
        dictgen::InsensitiveStr::Ascii("heter"),
        dictgen::InsensitiveStr::Ascii("hether"),
        dictgen::InsensitiveStr::Ascii("ling"),
        dictgen::InsensitiveStr::Ascii("lle"),
        dictgen::InsensitiveStr::Ascii("lled"),
        dictgen::InsensitiveStr::Ascii("ther"),
    ],
    values: &[
        &["together"],
        &["toggle"],
        &["together"],
        &["together"],
        &["toggling"],
        &["toggle"],
        &["toggled"],
        &["together"],
    ],
    range: 3..=6,
};

static WORD_TOE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TOE_CHILDREN),
    value: None,
};

pub static WORD_TOE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("kn")],
    values: &[&["token"]],
    range: 2..=2,
};

static WORD_TOD_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TOD_CHILDREN),
    value: None,
};

pub static WORD_TOD_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ya")],
    values: &[&["today"]],
    range: 2..=2,
};

static WORD_TOC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TOC_CHILDREN),
    value: None,
};

pub static WORD_TOC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hes"),
        dictgen::InsensitiveStr::Ascii("ksen"),
        dictgen::InsensitiveStr::Ascii("uhdown"),
        dictgen::InsensitiveStr::Ascii("uhpad"),
        dictgen::InsensitiveStr::Ascii("uhscreen"),
    ],
    values: &[
        &["touches"],
        &["toxin"],
        &["touchdown"],
        &["touchpad"],
        &["touchscreen"],
    ],
    range: 3..=8,
};

static WORD_TOB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TOB_CHILDREN),
    value: None,
};

pub static WORD_TOB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("baco"),
        dictgen::InsensitiveStr::Ascii("ot"),
    ],
    values: &[&["tobacco"], &["robot"]],
    range: 2..=4,
};

static WORD_TOA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TOA_CHILDREN),
    value: None,
};

pub static WORD_TOA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("lly")],
    values: &[&["totally"]],
    range: 3..=3,
};

static WORD_TM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TM_CHILDREN),
    value: None,
};

pub static WORD_TM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("is")],
    values: &[&["this"]],
    range: 2..=2,
};

static WORD_TL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TL_CHILDREN),
    value: None,
};

pub static WORD_TL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("aking")],
    values: &[&["talking"]],
    range: 5..=5,
};

static WORD_TK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TK_CHILDREN),
    value: None,
};

pub static WORD_TK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ae"),
        dictgen::InsensitiveStr::Ascii("aes"),
        dictgen::InsensitiveStr::Ascii("aing"),
    ],
    values: &[&["take"], &["takes"], &["taking"]],
    range: 2..=4,
};

static WORD_TJ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TJ_CHILDREN),
    value: None,
};

pub static WORD_TJ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("he"),
        dictgen::InsensitiveStr::Ascii("panishad"),
    ],
    values: &[&["the"], &["the"], &["upanishad"]],
    range: 1..=8,
};

static WORD_TI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_TI_CHILDREN),
    value: None,
};

static WORD_TI_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_TIA_NODE),
    None,
    Some(&WORD_TIC_NODE),
    None,
    Some(&WORD_TIE_NODE),
    None,
    Some(&WORD_TIG_NODE),
    Some(&WORD_TIH_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_TIM_NODE),
    Some(&WORD_TIN_NODE),
    Some(&WORD_TIO_NODE),
    Some(&WORD_TIP_NODE),
    None,
    Some(&WORD_TIR_NODE),
    None,
    Some(&WORD_TIT_NODE),
    None,
    None,
    Some(&WORD_TIW_NODE),
    None,
    None,
    None,
];

static WORD_TIW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TIW_CHILDREN),
    value: None,
};

pub static WORD_TIW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ards")],
    values: &[&["towards"]],
    range: 4..=4,
};

static WORD_TIT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TIT_CHILDREN),
    value: None,
};

pub static WORD_TIT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ainum"),
        dictgen::InsensitiveStr::Ascii("anim"),
        dictgen::InsensitiveStr::Ascii("anuim"),
        dictgen::InsensitiveStr::Ascii("el"),
        dictgen::InsensitiveStr::Ascii("els"),
        dictgen::InsensitiveStr::Ascii("ile"),
        dictgen::InsensitiveStr::Ascii("tled"),
        dictgen::InsensitiveStr::Ascii("tling"),
    ],
    values: &[
        &["titanium"],
        &["titanium"],
        &["titanium"],
        &["title"],
        &["titles"],
        &["title"],
        &["titled"],
        &["titling"],
    ],
    range: 2..=5,
};

static WORD_TIR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TIR_CHILDREN),
    value: None,
};

pub static WORD_TIR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("angle"),
        dictgen::InsensitiveStr::Ascii("angles"),
        dictgen::InsensitiveStr::Ascii("bunal"),
        dictgen::InsensitiveStr::Ascii("dent"),
    ],
    values: &[&["triangle"], &["triangles"], &["tribunal"], &["trident"]],
    range: 4..=6,
};

static WORD_TIP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TIP_CHILDREN),
    value: None,
};

pub static WORD_TIP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("ically"),
    ],
    values: &[&["type", "tip"], &["typically"]],
    range: 1..=6,
};

static WORD_TIO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TIO_CHILDREN),
    value: None,
};

pub static WORD_TIO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lets"),
        dictgen::InsensitiveStr::Ascii("me"),
    ],
    values: &[&["toilets"], &["time", "tome"]],
    range: 2..=4,
};

static WORD_TIN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TIN_CHILDREN),
    value: None,
};

pub static WORD_TIN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("dergarten"),
        dictgen::InsensitiveStr::Ascii("terrupts"),
    ],
    values: &[&["kindergarten"], &["interrupts"]],
    range: 8..=9,
};

static WORD_TIM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TIM_CHILDREN),
    value: None,
};

pub static WORD_TIM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("edlta"),
        dictgen::InsensitiveStr::Ascii("eing"),
        dictgen::InsensitiveStr::Ascii("eot"),
        dictgen::InsensitiveStr::Ascii("eput"),
        dictgen::InsensitiveStr::Ascii("eputs"),
        dictgen::InsensitiveStr::Ascii("ere"),
        dictgen::InsensitiveStr::Ascii("espanp"),
        dictgen::InsensitiveStr::Ascii("espanps"),
        dictgen::InsensitiveStr::Ascii("estan"),
        dictgen::InsensitiveStr::Ascii("estanp"),
        dictgen::InsensitiveStr::Ascii("estanps"),
        dictgen::InsensitiveStr::Ascii("estans"),
        dictgen::InsensitiveStr::Ascii("estap"),
        dictgen::InsensitiveStr::Ascii("estemp"),
        dictgen::InsensitiveStr::Ascii("estemps"),
        dictgen::InsensitiveStr::Ascii("estmap"),
        dictgen::InsensitiveStr::Ascii("estmaps"),
        dictgen::InsensitiveStr::Ascii("etamp"),
        dictgen::InsensitiveStr::Ascii("etamps"),
        dictgen::InsensitiveStr::Ascii("mestamp"),
        dictgen::InsensitiveStr::Ascii("mestamps"),
        dictgen::InsensitiveStr::Ascii("ming"),
        dictgen::InsensitiveStr::Ascii("ne"),
        dictgen::InsensitiveStr::Ascii("oeut"),
        dictgen::InsensitiveStr::Ascii("out"),
        dictgen::InsensitiveStr::Ascii("tout"),
        dictgen::InsensitiveStr::Ascii("zeone"),
        dictgen::InsensitiveStr::Ascii("zeones"),
        dictgen::InsensitiveStr::Ascii("zezone"),
        dictgen::InsensitiveStr::Ascii("zezones"),
    ],
    values: &[
        &["timedelta"],
        &["timing"],
        &["timeout"],
        &["timeout"],
        &["timeouts"],
        &["timer"],
        &["timespan"],
        &["timespans"],
        &["timespan"],
        &["timestamp", "timespan"],
        &["timestamps", "timespans"],
        &["timespans"],
        &["timestamp"],
        &["timestamp"],
        &["timestamps"],
        &["timestamp"],
        &["timestamps"],
        &["timestamp"],
        &["timestamps"],
        &["timestamp"],
        &["timestamps"],
        &["timing", "trimming"],
        &["time"],
        &["timeout"],
        &["timeout"],
        &["timeout"],
        &["timezone"],
        &["timezones"],
        &["timezone"],
        &["timezones"],
    ],
    range: 2..=8,
};

static WORD_TIH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TIH_CHILDREN),
    value: None,
};

pub static WORD_TIH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("kn"),
        dictgen::InsensitiveStr::Ascii("s"),
    ],
    values: &[&["think"], &["this"]],
    range: 1..=2,
};

static WORD_TIG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TIG_CHILDREN),
    value: None,
};

pub static WORD_TIG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ger"),
        dictgen::InsensitiveStr::Ascii("gered"),
        dictgen::InsensitiveStr::Ascii("gering"),
        dictgen::InsensitiveStr::Ascii("gers"),
        dictgen::InsensitiveStr::Ascii("hetning"),
        dictgen::InsensitiveStr::Ascii("hly"),
        dictgen::InsensitiveStr::Ascii("htare"),
        dictgen::InsensitiveStr::Ascii("htely"),
        dictgen::InsensitiveStr::Ascii("htenting"),
        dictgen::InsensitiveStr::Ascii("htining"),
        dictgen::InsensitiveStr::Ascii("th"),
        dictgen::InsensitiveStr::Ascii("then"),
        dictgen::InsensitiveStr::Ascii("thened"),
        dictgen::InsensitiveStr::Ascii("thening"),
        dictgen::InsensitiveStr::Ascii("thens"),
        dictgen::InsensitiveStr::Ascii("ther"),
        dictgen::InsensitiveStr::Ascii("thly"),
    ],
    values: &[
        &["trigger"],
        &["triggered"],
        &["triggering"],
        &["triggers"],
        &["tightening"],
        &["tightly"],
        &["tighter"],
        &["tightly"],
        &["tightening"],
        &["tightening"],
        &["tight"],
        &["tighten"],
        &["tightened"],
        &["tightening"],
        &["tightens"],
        &["tighter"],
        &["tightly"],
    ],
    range: 2..=8,
};

static WORD_TIE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TIE_CHILDREN),
    value: None,
};

pub static WORD_TIE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ing"),
        dictgen::InsensitiveStr::Ascii("m"),
        dictgen::InsensitiveStr::Ascii("mout"),
        dictgen::InsensitiveStr::Ascii("mstamp"),
        dictgen::InsensitiveStr::Ascii("th"),
    ],
    values: &[
        &["tying"],
        &["time", "item"],
        &["timeout"],
        &["timestamp"],
        &["tithe"],
    ],
    range: 1..=6,
};

static WORD_TIC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TIC_CHILDREN),
    value: None,
};

pub static WORD_TIC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("h"),
        dictgen::InsensitiveStr::Ascii("hened"),
        dictgen::InsensitiveStr::Ascii("hness"),
    ],
    values: &[
        &["thick", "tick", "titch", "stitch"],
        &["thickened"],
        &["thickness"],
    ],
    range: 1..=5,
};

static WORD_TIA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TIA_CHILDREN),
    value: None,
};

pub static WORD_TIA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("wanese")],
    values: &[&["taiwanese"]],
    range: 6..=6,
};

static WORD_TH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_TH_CHILDREN),
    value: None,
};

static WORD_TH_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_THA_NODE),
    None,
    Some(&WORD_THC_NODE),
    None,
    Some(&WORD_THE_NODE),
    None,
    Some(&WORD_THG_NODE),
    None,
    Some(&WORD_THI_NODE),
    Some(&WORD_THJ_NODE),
    None,
    None,
    Some(&WORD_THM_NODE),
    Some(&WORD_THN_NODE),
    Some(&WORD_THO_NODE),
    None,
    Some(&WORD_THQ_NODE),
    Some(&WORD_THR_NODE),
    Some(&WORD_THS_NODE),
    Some(&WORD_THT_NODE),
    Some(&WORD_THU_NODE),
    None,
    Some(&WORD_THW_NODE),
    None,
    Some(&WORD_THY_NODE),
    None,
];

static WORD_THY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THY_CHILDREN),
    value: None,
};

pub static WORD_THY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("at"),
        dictgen::InsensitiveStr::Ascii("orid"),
        dictgen::InsensitiveStr::Ascii("riod"),
    ],
    values: &[&["that"], &["thyroid"], &["thyroid"]],
    range: 2..=4,
};

static WORD_THW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THW_CHILDREN),
    value: Some(&["the", "thaw"]),
};

pub static WORD_THW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[],
    values: &[],
    range: 0..=0,
};

static WORD_THU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THU_CHILDREN),
    value: None,
};

pub static WORD_THU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bmnails"),
        dictgen::InsensitiveStr::Ascii("dnerbolt"),
        dictgen::InsensitiveStr::Ascii("mbbnail"),
        dictgen::InsensitiveStr::Ascii("mbmails"),
        dictgen::InsensitiveStr::Ascii("mbnailers"),
        dictgen::InsensitiveStr::Ascii("mbnal"),
        dictgen::InsensitiveStr::Ascii("nberbolt"),
        dictgen::InsensitiveStr::Ascii("ndebird"),
        dictgen::InsensitiveStr::Ascii("nderblot"),
        dictgen::InsensitiveStr::Ascii("nderboat"),
        dictgen::InsensitiveStr::Ascii("nderboldt"),
        dictgen::InsensitiveStr::Ascii("nderbot"),
        dictgen::InsensitiveStr::Ascii("nderbots"),
        dictgen::InsensitiveStr::Ascii("nderbowl"),
        dictgen::InsensitiveStr::Ascii("nderjolt"),
        dictgen::InsensitiveStr::Ascii("nderolt"),
        dictgen::InsensitiveStr::Ascii("ndervolt"),
        dictgen::InsensitiveStr::Ascii("r"),
        dictgen::InsensitiveStr::Ascii("rdsay"),
        dictgen::InsensitiveStr::Ascii("rdsays"),
        dictgen::InsensitiveStr::Ascii("rough"),
        dictgen::InsensitiveStr::Ascii("rrow"),
        dictgen::InsensitiveStr::Ascii("rsdsay"),
        dictgen::InsensitiveStr::Ascii("rsdsy"),
        dictgen::InsensitiveStr::Ascii("rsters"),
        dictgen::InsensitiveStr::Ascii("rver"),
    ],
    values: &[
        &["thumbnails"],
        &["thunderbolt"],
        &["thumbnail"],
        &["thumbnails"],
        &["thumbnails"],
        &["thumbnails"],
        &["thunderbolt"],
        &["thunderbird"],
        &["thunderbolt"],
        &["thunderbolt"],
        &["thunderbolt"],
        &["thunderbolt"],
        &["thunderbolt"],
        &["thunderbolt"],
        &["thunderbolt"],
        &["thunderbolt"],
        &["thunderbolt"],
        &["their"],
        &["thursday"],
        &["thursdays"],
        &["thorough"],
        &["thorough"],
        &["thursdays"],
        &["thursdays"],
        &["thrusters"],
        &["further"],
    ],
    range: 1..=9,
};

static WORD_THT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THT_CHILDREN),
    value: Some(&["the", "that"]),
};

pub static WORD_THT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("a"),
        dictgen::InsensitiveStr::Ascii("at"),
        dictgen::InsensitiveStr::Ascii("e"),
    ],
    values: &[&["that"], &["that"], &["the", "that"]],
    range: 1..=2,
};

static WORD_THS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THS_CHILDREN),
    value: Some(&["the", "this"]),
};

pub static WORD_THS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("i"),
        dictgen::InsensitiveStr::Ascii("oe"),
        dictgen::InsensitiveStr::Ascii("ose"),
        dictgen::InsensitiveStr::Ascii("ould"),
        dictgen::InsensitiveStr::Ascii("t"),
    ],
    values: &[
        &["these"],
        &["this"],
        &["those"],
        &["those"],
        &["should"],
        &["that"],
    ],
    range: 1..=4,
};

static WORD_THR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_THR_CHILDREN),
    value: None,
};

static WORD_THR_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_THRA_NODE),
    None,
    None,
    None,
    Some(&WORD_THRE_NODE),
    None,
    None,
    None,
    Some(&WORD_THRI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_THRO_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_THRU_NODE),
    None,
    None,
    None,
    Some(&WORD_THRY_NODE),
    None,
];

static WORD_THRY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THRY_CHILDREN),
    value: None,
};

pub static WORD_THRY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("oid")],
    values: &[&["thyroid"]],
    range: 3..=3,
};

static WORD_THRU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THRU_CHILDREN),
    value: None,
};

pub static WORD_THRU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("ogh"),
        dictgen::InsensitiveStr::Ascii("oghout"),
        dictgen::InsensitiveStr::Ascii("oghput"),
        dictgen::InsensitiveStr::Ascii("out"),
        dictgen::InsensitiveStr::Ascii("sday"),
        dictgen::InsensitiveStr::Ascii("sdays"),
    ],
    values: &[
        &["thru"],
        &["through"],
        &["throughout"],
        &["throughput"],
        &["throughout"],
        &["thursday"],
        &["thursdays"],
    ],
    range: 1..=6,
};

static WORD_THRO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THRO_CHILDREN),
    value: None,
};

pub static WORD_THRO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ast"),
        dictgen::InsensitiveStr::Ascii("aths"),
        dictgen::InsensitiveStr::Ascii("en"),
        dictgen::InsensitiveStr::Ascii("gh"),
        dictgen::InsensitiveStr::Ascii("ium"),
        dictgen::InsensitiveStr::Ascii("n"),
        dictgen::InsensitiveStr::Ascii("ners"),
        dictgen::InsensitiveStr::Ascii("ough"),
        dictgen::InsensitiveStr::Ascii("rough"),
        dictgen::InsensitiveStr::Ascii("thling"),
        dictgen::InsensitiveStr::Ascii("tlling"),
        dictgen::InsensitiveStr::Ascii("tte"),
        dictgen::InsensitiveStr::Ascii("tted"),
        dictgen::InsensitiveStr::Ascii("ttes"),
        dictgen::InsensitiveStr::Ascii("tting"),
        dictgen::InsensitiveStr::Ascii("ttleing"),
        dictgen::InsensitiveStr::Ascii("ttoling"),
        dictgen::InsensitiveStr::Ascii("ug"),
        dictgen::InsensitiveStr::Ascii("ugg"),
        dictgen::InsensitiveStr::Ascii("ughiut"),
        dictgen::InsensitiveStr::Ascii("ughly"),
        dictgen::InsensitiveStr::Ascii("ughoput"),
        dictgen::InsensitiveStr::Ascii("ught"),
        dictgen::InsensitiveStr::Ascii("ughtout"),
        dictgen::InsensitiveStr::Ascii("ughtput"),
        dictgen::InsensitiveStr::Ascii("ugout"),
        dictgen::InsensitiveStr::Ascii("ugt"),
        dictgen::InsensitiveStr::Ascii("ugth"),
        dictgen::InsensitiveStr::Ascii("uh"),
        dictgen::InsensitiveStr::Ascii("uth"),
        dictgen::InsensitiveStr::Ascii("wed"),
        dictgen::InsensitiveStr::Ascii("wgh"),
    ],
    values: &[
        &["throats"],
        &["throats"],
        &["thrown"],
        &["through"],
        &["thorium"],
        &["thrown", "throne"],
        &["thrones"],
        &["thorough"],
        &["thorough"],
        &["throttling"],
        &["throttling"],
        &["throttle", "trot"],
        &["throttled", "trotted"],
        &["throttles", "trots"],
        &["throttling", "trotting"],
        &["throttling"],
        &["throttling"],
        &["through"],
        &["through"],
        &["throughput"],
        &["thoroughly"],
        &["throughput"],
        &["thought", "through", "throughout"],
        &["throughout"],
        &["throughput"],
        &["throughout"],
        &["through"],
        &["through"],
        &["through"],
        &["through"],
        &["threw", "thrown"],
        &["through"],
    ],
    range: 1..=7,
};

static WORD_THRI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THRI_CHILDREN),
    value: None,
};

pub static WORD_THRI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("d"),
        dictgen::InsensitiveStr::Ascii("dly"),
        dictgen::InsensitiveStr::Ascii("sty"),
        dictgen::InsensitiveStr::Ascii("teen"),
        dictgen::InsensitiveStr::Ascii("ties"),
    ],
    values: &[
        &["third"],
        &["thirdly"],
        &["thirsty"],
        &["thirteen"],
        &["thirties"],
    ],
    range: 1..=4,
};

static WORD_THRE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THRE_CHILDREN),
    value: Some(&["three", "there", "their", "the"]),
};

pub static WORD_THRE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("add"),
        dictgen::InsensitiveStr::Ascii("adened"),
        dictgen::InsensitiveStr::Ascii("adsave"),
        dictgen::InsensitiveStr::Ascii("ah"),
        dictgen::InsensitiveStr::Ascii("ashold"),
        dictgen::InsensitiveStr::Ascii("asholds"),
        dictgen::InsensitiveStr::Ascii("ataning"),
        dictgen::InsensitiveStr::Ascii("atend"),
        dictgen::InsensitiveStr::Ascii("atended"),
        dictgen::InsensitiveStr::Ascii("atenes"),
        dictgen::InsensitiveStr::Ascii("ates"),
        dictgen::InsensitiveStr::Ascii("atining"),
        dictgen::InsensitiveStr::Ascii("atment"),
        dictgen::InsensitiveStr::Ascii("atments"),
        dictgen::InsensitiveStr::Ascii("atning"),
        dictgen::InsensitiveStr::Ascii("d"),
        dictgen::InsensitiveStr::Ascii("ded"),
        dictgen::InsensitiveStr::Ascii("dhold"),
        dictgen::InsensitiveStr::Ascii("ding"),
        dictgen::InsensitiveStr::Ascii("ds"),
        dictgen::InsensitiveStr::Ascii("ee"),
        dictgen::InsensitiveStr::Ascii("efor"),
        dictgen::InsensitiveStr::Ascii("eof"),
        dictgen::InsensitiveStr::Ascii("eshold"),
        dictgen::InsensitiveStr::Ascii("hold"),
        dictgen::InsensitiveStr::Ascii("re"),
        dictgen::InsensitiveStr::Ascii("refore"),
        dictgen::InsensitiveStr::Ascii("shhold"),
        dictgen::InsensitiveStr::Ascii("shholds"),
        dictgen::InsensitiveStr::Ascii("shol"),
        dictgen::InsensitiveStr::Ascii("sold"),
        dictgen::InsensitiveStr::Ascii("sshold"),
    ],
    values: &[
        &["threaded"],
        &["threaded"],
        &["threadsafe"],
        &["thread", "threat"],
        &["threshold"],
        &["thresholds"],
        &["threatening"],
        &["threatened"],
        &["threatened"],
        &["threatens"],
        &["threatens"],
        &["threatening"],
        &["treatment"],
        &["treatments"],
        &["threatening"],
        &["thread"],
        &["threaded"],
        &["threshold"],
        &["threading"],
        &["threads"],
        &["three"],
        &["therefor"],
        &["thereof"],
        &["threshold"],
        &["threshold"],
        &["there", "three"],
        &["therefore"],
        &["threshold"],
        &["thresholds"],
        &["threshold"],
        &["threshold"],
        &["threshold"],
    ],
    range: 1..=7,
};

static WORD_THRA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THRA_CHILDREN),
    value: None,
};

pub static WORD_THRA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("d")],
    values: &[&["thread"]],
    range: 1..=1,
};

static WORD_THQ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THQ_CHILDREN),
    value: Some(&["the"]),
};

pub static WORD_THQ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[],
    values: &[],
    range: 0..=0,
};

static WORD_THO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THO_CHILDREN),
    value: None,
};

pub static WORD_THO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ecracy"),
        dictgen::InsensitiveStr::Ascii("erem"),
        dictgen::InsensitiveStr::Ascii("eretical"),
        dictgen::InsensitiveStr::Ascii("eretically"),
        dictgen::InsensitiveStr::Ascii("eries"),
        dictgen::InsensitiveStr::Ascii("erist"),
        dictgen::InsensitiveStr::Ascii("erists"),
        dictgen::InsensitiveStr::Ascii("mspon"),
        dictgen::InsensitiveStr::Ascii("nic"),
        dictgen::InsensitiveStr::Ascii("pmson"),
        dictgen::InsensitiveStr::Ascii("rats"),
        dictgen::InsensitiveStr::Ascii("rnes"),
        dictgen::InsensitiveStr::Ascii("roughy"),
        dictgen::InsensitiveStr::Ascii("rttling"),
        dictgen::InsensitiveStr::Ascii("rugh"),
        dictgen::InsensitiveStr::Ascii("rughout"),
        dictgen::InsensitiveStr::Ascii("ruim"),
        dictgen::InsensitiveStr::Ascii("ruoghly"),
        dictgen::InsensitiveStr::Ascii("rwn"),
        dictgen::InsensitiveStr::Ascii("s"),
        dictgen::InsensitiveStr::Ascii("ses"),
        dictgen::InsensitiveStr::Ascii("ughout"),
        dictgen::InsensitiveStr::Ascii("ughs"),
        dictgen::InsensitiveStr::Ascii("ugt"),
        dictgen::InsensitiveStr::Ascii("ugth"),
        dictgen::InsensitiveStr::Ascii("ugths"),
        dictgen::InsensitiveStr::Ascii("unsands"),
        dictgen::InsensitiveStr::Ascii("urogh"),
        dictgen::InsensitiveStr::Ascii("uroghly"),
        dictgen::InsensitiveStr::Ascii("urough"),
        dictgen::InsensitiveStr::Ascii("uroughly"),
        dictgen::InsensitiveStr::Ascii("w"),
        dictgen::InsensitiveStr::Ascii("wn"),
    ],
    values: &[
        &["theocracy"],
        &["theorem"],
        &["theoretical"],
        &["theoretically"],
        &["theories"],
        &["theorist"],
        &["theorists"],
        &["thompson"],
        &["chthonic"],
        &["thompson"],
        &["throats"],
        &["thrones"],
        &["thoroughly"],
        &["throttling"],
        &["through", "thorough"],
        &["throughout"],
        &["thorium"],
        &["thoroughly"],
        &["thrown", "thorn"],
        &["those", "this"],
        &["those"],
        &["throughout"],
        &["thoughts"],
        &["thought", "though"],
        &["thought"],
        &["thoughts"],
        &["thousands"],
        &["thorough"],
        &["thoroughly"],
        &["thorough"],
        &["thoroughly"],
        &["throw", "tow"],
        &["thrown", "town"],
    ],
    range: 1..=10,
};

static WORD_THN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THN_CHILDREN),
    value: Some(&["then"]),
};

pub static WORD_THN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("a"),
        dictgen::InsensitiveStr::Ascii("ak"),
        dictgen::InsensitiveStr::Ascii("aks"),
        dictgen::InsensitiveStr::Ascii("akyou"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("ig"),
        dictgen::InsensitiveStr::Ascii("igs"),
    ],
    values: &[
        &["than"],
        &["thank"],
        &["thanks"],
        &["thankyou"],
        &["then"],
        &["thing"],
        &["things"],
    ],
    range: 1..=5,
};

static WORD_THM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THM_CHILDREN),
    value: None,
};

pub static WORD_THM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("e")],
    values: &[&["them"]],
    range: 1..=1,
};

static WORD_THJ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THJ_CHILDREN),
    value: None,
};

pub static WORD_THJ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ese")],
    values: &[&["these"]],
    range: 3..=3,
};

static WORD_THI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THI_CHILDREN),
    value: Some(&["the", "this"]),
};

pub static WORD_THI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aland"),
        dictgen::InsensitiveStr::Ascii("cking"),
        dictgen::InsensitiveStr::Ascii("cknes"),
        dictgen::InsensitiveStr::Ascii("d"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("estic"),
        dictgen::InsensitiveStr::Ascii("ests"),
        dictgen::InsensitiveStr::Ascii("ght"),
        dictgen::InsensitiveStr::Ascii("ghts"),
        dictgen::InsensitiveStr::Ascii("gn"),
        dictgen::InsensitiveStr::Ascii("gns"),
        dictgen::InsensitiveStr::Ascii("gny"),
        dictgen::InsensitiveStr::Ascii("gsn"),
        dictgen::InsensitiveStr::Ascii("k"),
        dictgen::InsensitiveStr::Ascii("kn"),
        dictgen::InsensitiveStr::Ascii("kness"),
        dictgen::InsensitiveStr::Ascii("knesses"),
        dictgen::InsensitiveStr::Ascii("kning"),
        dictgen::InsensitiveStr::Ascii("kns"),
        dictgen::InsensitiveStr::Ascii("ks"),
        dictgen::InsensitiveStr::Ascii("me"),
        dictgen::InsensitiveStr::Ascii("mngs"),
        dictgen::InsensitiveStr::Ascii("nigs"),
        dictgen::InsensitiveStr::Ascii("nkabel"),
        dictgen::InsensitiveStr::Ascii("nkg"),
        dictgen::InsensitiveStr::Ascii("nkgs"),
        dictgen::InsensitiveStr::Ascii("nn"),
        dictgen::InsensitiveStr::Ascii("rites"),
        dictgen::InsensitiveStr::Ascii("rldy"),
        dictgen::InsensitiveStr::Ascii("rlling"),
        dictgen::InsensitiveStr::Ascii("rs"),
        dictgen::InsensitiveStr::Ascii("rstay"),
        dictgen::InsensitiveStr::Ascii("rteeen"),
        dictgen::InsensitiveStr::Ascii("rten"),
        dictgen::InsensitiveStr::Ascii("rtsy"),
        dictgen::InsensitiveStr::Ascii("rtyth"),
        dictgen::InsensitiveStr::Ascii("se"),
        dictgen::InsensitiveStr::Ascii("sle"),
        dictgen::InsensitiveStr::Ascii("st"),
        dictgen::InsensitiveStr::Ascii("sy"),
        dictgen::InsensitiveStr::Ascii("unk"),
    ],
    values: &[
        &["thailand"],
        &["thinking", "thickening"],
        &["thickness", "thickens"],
        &["this"],
        &["the", "this"],
        &["their"],
        &["theistic"],
        &["theists"],
        &["tight", "thigh", "fight"],
        &["tights", "thighs", "fights"],
        &["thing"],
        &["things"],
        &["thingy"],
        &["things"],
        &["thick", "think"],
        &["think"],
        &["thickness"],
        &["thicknesses"],
        &["thinking", "thickening"],
        &["thinks"],
        &["thinks"],
        &["time", "theme", "thyme", "thine"],
        &["things"],
        &["things"],
        &["thinkable"],
        &["think", "thing", "things"],
        &["thinks", "things"],
        &["thin"],
        &["thirties"],
        &["thirdly"],
        &["thrilling"],
        &["third", "thirst"],
        &["thirsty"],
        &["thirteen"],
        &["thirteen"],
        &["thirsty"],
        &["thirtieth"],
        &["these", "this"],
        &["thistle"],
        &["this"],
        &["this"],
        &["think"],
    ],
    range: 1..=7,
};

static WORD_THG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THG_CHILDREN),
    value: None,
};

pub static WORD_THG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("at"),
        dictgen::InsensitiveStr::Ascii("e"),
    ],
    values: &[&["that"], &["the"]],
    range: 1..=2,
};

static WORD_THE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_THE_CHILDREN),
    value: None,
};

static WORD_THE_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_THEA_NODE),
    None,
    None,
    None,
    Some(&WORD_THEE_NODE),
    Some(&WORD_THEF_NODE),
    None,
    None,
    Some(&WORD_THEI_NODE),
    None,
    None,
    None,
    Some(&WORD_THEM_NODE),
    Some(&WORD_THEN_NODE),
    Some(&WORD_THEO_NODE),
    None,
    None,
    Some(&WORD_THER_NODE),
    Some(&WORD_THES_NODE),
    Some(&WORD_THET_NODE),
    None,
    Some(&WORD_THEV_NODE),
    None,
    Some(&WORD_THEX_NODE),
    Some(&WORD_THEY_NODE),
    None,
];

static WORD_THEY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THEY_CHILDREN),
    value: None,
};

pub static WORD_THEY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("r"),
        dictgen::InsensitiveStr::Ascii("re"),
    ],
    values: &[&["their", "there"], &["their", "there"]],
    range: 1..=2,
};

static WORD_THEX_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THEX_CHILDREN),
    value: Some(&["the", "then"]),
};

pub static WORD_THEX_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[],
    values: &[],
    range: 0..=0,
};

static WORD_THEV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THEV_CHILDREN),
    value: Some(&["the"]),
};

pub static WORD_THEV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("es")],
    values: &[&["thieves"]],
    range: 2..=2,
};

static WORD_THET_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THET_CHILDREN),
    value: None,
};

pub static WORD_THET_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ering"),
        dictgen::InsensitiveStr::Ascii("her"),
        dictgen::InsensitiveStr::Ascii("rahedron"),
    ],
    values: &[&["tethering"], &["tether", "whether"], &["tetrahedron"]],
    range: 3..=8,
};

static WORD_THES_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THES_CHILDREN),
    value: Some(&["this", "these"]),
};

pub static WORD_THES_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hold"),
        dictgen::InsensitiveStr::Ascii("holds"),
        dictgen::InsensitiveStr::Ascii("itic"),
        dictgen::InsensitiveStr::Ascii("its"),
        dictgen::InsensitiveStr::Ascii("s"),
        dictgen::InsensitiveStr::Ascii("t"),
    ],
    values: &[
        &["threshold"],
        &["thresholds"],
        &["theistic"],
        &["theists"],
        &["this", "these"],
        &["test"],
    ],
    range: 1..=5,
};

static WORD_THER_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THER_CHILDREN),
    value: Some(&["there", "their", "the", "other"]),
};

pub static WORD_THER_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("after"),
        dictgen::InsensitiveStr::Ascii("apautic"),
        dictgen::InsensitiveStr::Ascii("apetic"),
        dictgen::InsensitiveStr::Ascii("apeudic"),
        dictgen::InsensitiveStr::Ascii("apeutisch"),
        dictgen::InsensitiveStr::Ascii("apeutuc"),
        dictgen::InsensitiveStr::Ascii("aphy"),
        dictgen::InsensitiveStr::Ascii("apudic"),
        dictgen::InsensitiveStr::Ascii("apuetic"),
        dictgen::InsensitiveStr::Ascii("aupetic"),
        dictgen::InsensitiveStr::Ascii("by"),
        dictgen::InsensitiveStr::Ascii("eads"),
        dictgen::InsensitiveStr::Ascii("eaputic"),
        dictgen::InsensitiveStr::Ascii("efo"),
        dictgen::InsensitiveStr::Ascii("efoer"),
        dictgen::InsensitiveStr::Ascii("efour"),
        dictgen::InsensitiveStr::Ascii("eian"),
        dictgen::InsensitiveStr::Ascii("em"),
        dictgen::InsensitiveStr::Ascii("eom"),
        dictgen::InsensitiveStr::Ascii("eotical"),
        dictgen::InsensitiveStr::Ascii("eotically"),
        dictgen::InsensitiveStr::Ascii("epeutic"),
        dictgen::InsensitiveStr::Ascii("epists"),
        dictgen::InsensitiveStr::Ascii("erin"),
        dictgen::InsensitiveStr::Ascii("fore"),
        dictgen::InsensitiveStr::Ascii("i"),
        dictgen::InsensitiveStr::Ascii("ien"),
        dictgen::InsensitiveStr::Ascii("ipists"),
        dictgen::InsensitiveStr::Ascii("mastat"),
        dictgen::InsensitiveStr::Ascii("misor"),
        dictgen::InsensitiveStr::Ascii("misors"),
        dictgen::InsensitiveStr::Ascii("mistat"),
        dictgen::InsensitiveStr::Ascii("modinamics"),
        dictgen::InsensitiveStr::Ascii("modyanmics"),
        dictgen::InsensitiveStr::Ascii("modymamics"),
        dictgen::InsensitiveStr::Ascii("modymanics"),
        dictgen::InsensitiveStr::Ascii("modynaics"),
        dictgen::InsensitiveStr::Ascii("modynamcis"),
        dictgen::InsensitiveStr::Ascii("modynamcs"),
        dictgen::InsensitiveStr::Ascii("modynanics"),
        dictgen::InsensitiveStr::Ascii("modynmaics"),
        dictgen::InsensitiveStr::Ascii("momenter"),
        dictgen::InsensitiveStr::Ascii("momether"),
        dictgen::InsensitiveStr::Ascii("mometor"),
        dictgen::InsensitiveStr::Ascii("mometre"),
        dictgen::InsensitiveStr::Ascii("momiter"),
        dictgen::InsensitiveStr::Ascii("momoter"),
        dictgen::InsensitiveStr::Ascii("momter"),
        dictgen::InsensitiveStr::Ascii("moneter"),
        dictgen::InsensitiveStr::Ascii("mostaat"),
        dictgen::InsensitiveStr::Ascii("mostast"),
        dictgen::InsensitiveStr::Ascii("mostasts"),
        dictgen::InsensitiveStr::Ascii("nodynamics"),
        dictgen::InsensitiveStr::Ascii("oem"),
        dictgen::InsensitiveStr::Ascii("oetical"),
        dictgen::InsensitiveStr::Ascii("oetically"),
        dictgen::InsensitiveStr::Ascii("oies"),
        dictgen::InsensitiveStr::Ascii("oist"),
        dictgen::InsensitiveStr::Ascii("oists"),
        dictgen::InsensitiveStr::Ascii("omdynamics"),
        dictgen::InsensitiveStr::Ascii("omstat"),
        dictgen::InsensitiveStr::Ascii("ough"),
        dictgen::InsensitiveStr::Ascii("stat"),
    ],
    values: &[
        &["thereafter"],
        &["therapeutic"],
        &["therapeutic"],
        &["therapeutic"],
        &["therapeutic"],
        &["therapeutic"],
        &["therapy"],
        &["therapeutic"],
        &["therapeutic"],
        &["therapeutic"],
        &["thereby"],
        &["threads"],
        &["therapeutic"],
        &["thereof"],
        &["therefor"],
        &["therefor"],
        &["therein"],
        &["there", "theorem"],
        &["theorem"],
        &["theoretical"],
        &["theoretically"],
        &["therapeutic"],
        &["therapists"],
        &["therein"],
        &["therefore"],
        &["their", "there"],
        &["therein"],
        &["therapists"],
        &["thermostat"],
        &["thermistor"],
        &["thermistors"],
        &["thermostat"],
        &["thermodynamics"],
        &["thermodynamics"],
        &["thermodynamics"],
        &["thermodynamics"],
        &["thermodynamics"],
        &["thermodynamics"],
        &["thermodynamics"],
        &["thermodynamics"],
        &["thermodynamics"],
        &["thermometer"],
        &["thermometer"],
        &["thermometer"],
        &["thermometer"],
        &["thermometer"],
        &["thermometer"],
        &["thermometer"],
        &["thermometer"],
        &["thermostat"],
        &["thermostat"],
        &["thermostats"],
        &["thermodynamics"],
        &["theorem"],
        &["theoretical"],
        &["theoretically"],
        &["theories"],
        &["theorist"],
        &["theorists"],
        &["thermodynamics"],
        &["thermostat"],
        &["through", "thorough"],
        &["thermostat"],
    ],
    range: 1..=10,
};

static WORD_THEO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THEO_CHILDREN),
    value: None,
};

pub static WORD_THEO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cracry"),
        dictgen::InsensitiveStr::Ascii("ligical"),
        dictgen::InsensitiveStr::Ascii("logia"),
        dictgen::InsensitiveStr::Ascii("logial"),
        dictgen::InsensitiveStr::Ascii("logicial"),
        dictgen::InsensitiveStr::Ascii("ratical"),
        dictgen::InsensitiveStr::Ascii("ratically"),
        dictgen::InsensitiveStr::Ascii("rectical"),
        dictgen::InsensitiveStr::Ascii("reticall"),
        dictgen::InsensitiveStr::Ascii("reticaly"),
        dictgen::InsensitiveStr::Ascii("reticly"),
        dictgen::InsensitiveStr::Ascii("rical"),
        dictgen::InsensitiveStr::Ascii("rically"),
        dictgen::InsensitiveStr::Ascii("ritical"),
        dictgen::InsensitiveStr::Ascii("ritically"),
        dictgen::InsensitiveStr::Ascii("rits"),
    ],
    values: &[
        &["theocracy"],
        &["theological"],
        &["theological"],
        &["theological"],
        &["theological"],
        &["theoretical"],
        &["theoretically"],
        &["theoretical"],
        &["theoretically"],
        &["theoretically"],
        &["theoretical"],
        &["theoretical"],
        &["theoretically"],
        &["theoretical"],
        &["theoretically"],
        &["theorist"],
    ],
    range: 4..=9,
};

static WORD_THEN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THEN_CHILDREN),
    value: None,
};

pub static WORD_THEN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("n"),
    ],
    values: &[&["themes"], &["then"]],
    range: 1..=2,
};

static WORD_THEM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THEM_CHILDREN),
    value: None,
};

pub static WORD_THEM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("plate"),
        dictgen::InsensitiveStr::Ascii("sef"),
        dictgen::InsensitiveStr::Ascii("selces"),
        dictgen::InsensitiveStr::Ascii("selfe"),
        dictgen::InsensitiveStr::Ascii("selfes"),
        dictgen::InsensitiveStr::Ascii("selfs"),
        dictgen::InsensitiveStr::Ascii("selve"),
        dictgen::InsensitiveStr::Ascii("selvs"),
        dictgen::InsensitiveStr::Ascii("sevles"),
        dictgen::InsensitiveStr::Ascii("slef"),
        dictgen::InsensitiveStr::Ascii("sleves"),
        dictgen::InsensitiveStr::Ascii("slves"),
    ],
    values: &[
        &["template"],
        &["themself"],
        &["themselves"],
        &["themselves", "themself"],
        &["themselves"],
        &["themselves"],
        &["themselves", "themself"],
        &["themselves"],
        &["themselves"],
        &["themself"],
        &["themselves"],
        &["themselves"],
    ],
    range: 3..=6,
};

static WORD_THEI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THEI_CHILDREN),
    value: Some(&["their", "they"]),
};

pub static WORD_THEI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("f"),
        dictgen::InsensitiveStr::Ascii("fs"),
        dictgen::InsensitiveStr::Ascii("re"),
        dictgen::InsensitiveStr::Ascii("s"),
        dictgen::InsensitiveStr::Ascii("sitc"),
        dictgen::InsensitiveStr::Ascii("stc"),
        dictgen::InsensitiveStr::Ascii("v"),
        dictgen::InsensitiveStr::Ascii("ve"),
        dictgen::InsensitiveStr::Ascii("ves"),
    ],
    values: &[
        &["thief"],
        &["thieves"],
        &["their"],
        &["this", "thesis"],
        &["theistic"],
        &["theistic"],
        &["thief"],
        &["thief"],
        &["thieves"],
    ],
    range: 1..=4,
};

static WORD_THEF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THEF_CHILDREN),
    value: None,
};

pub static WORD_THEF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ore")],
    values: &[&["therefore"]],
    range: 3..=3,
};

static WORD_THEE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THEE_CHILDREN),
    value: None,
};

pub static WORD_THEE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("f"),
        dictgen::InsensitiveStr::Ascii("r"),
        dictgen::InsensitiveStr::Ascii("ry"),
        dictgen::InsensitiveStr::Ascii("se"),
    ],
    values: &[&["thief"], &["there"], &["theory"], &["these"]],
    range: 1..=2,
};

static WORD_THEA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THEA_CHILDREN),
    value: None,
};

pub static WORD_THEA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rd"),
        dictgen::InsensitiveStr::Ascii("rding"),
        dictgen::InsensitiveStr::Ascii("rds"),
        dictgen::InsensitiveStr::Ascii("red"),
        dictgen::InsensitiveStr::Ascii("rpy"),
        dictgen::InsensitiveStr::Ascii("ther"),
        dictgen::InsensitiveStr::Ascii("thre"),
        dictgen::InsensitiveStr::Ascii("ture"),
    ],
    values: &[
        &["thread"],
        &["threading"],
        &["threads"],
        &["threaded"],
        &["therapy"],
        &["theater"],
        &["theatre"],
        &["theatre"],
    ],
    range: 2..=5,
};

static WORD_THC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THC_CHILDREN),
    value: None,
};

pub static WORD_THC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("k")],
    values: &[&["thick"]],
    range: 1..=1,
};

static WORD_THA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_THA_CHILDREN),
    value: Some(&["than", "that", "the"]),
};

pub static WORD_THA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("liand"),
        dictgen::InsensitiveStr::Ascii("nkfullly"),
        dictgen::InsensitiveStr::Ascii("nkfuly"),
        dictgen::InsensitiveStr::Ascii("nksgivng"),
        dictgen::InsensitiveStr::Ascii("nkyooou"),
        dictgen::InsensitiveStr::Ascii("nkyoou"),
        dictgen::InsensitiveStr::Ascii("nkyu"),
        dictgen::InsensitiveStr::Ascii("nn"),
        dictgen::InsensitiveStr::Ascii("nsk"),
        dictgen::InsensitiveStr::Ascii("nskgiving"),
        dictgen::InsensitiveStr::Ascii("nsparent"),
        dictgen::InsensitiveStr::Ascii("nt"),
        dictgen::InsensitiveStr::Ascii("re"),
        dictgen::InsensitiveStr::Ascii("st"),
        dictgen::InsensitiveStr::Ascii("tn"),
        dictgen::InsensitiveStr::Ascii("y"),
    ],
    values: &[
        &["thailand"],
        &["thankfully"],
        &["thankfully"],
        &["thanksgiving"],
        &["thankyou"],
        &["thankyou"],
        &["thankyou"],
        &["than", "thank"],
        &["thanks"],
        &["thanksgiving"],
        &["transparent"],
        &["than"],
        &["there"],
        &["that"],
        &["that", "than"],
        &["they"],
    ],
    range: 1..=9,
};

static WORD_TG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TG_CHILDREN),
    value: None,
};

pub static WORD_TG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("he")],
    values: &[&["the"]],
    range: 2..=2,
};

static WORD_TE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_TE_CHILDREN),
    value: None,
};

static WORD_TE_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_TEA_NODE),
    None,
    Some(&WORD_TEC_NODE),
    Some(&WORD_TED_NODE),
    Some(&WORD_TEE_NODE),
    Some(&WORD_TEF_NODE),
    None,
    Some(&WORD_TEH_NODE),
    None,
    None,
    Some(&WORD_TEK_NODE),
    Some(&WORD_TEL_NODE),
    Some(&WORD_TEM_NODE),
    Some(&WORD_TEN_NODE),
    None,
    Some(&WORD_TEP_NODE),
    Some(&WORD_TEQ_NODE),
    Some(&WORD_TER_NODE),
    Some(&WORD_TES_NODE),
    Some(&WORD_TET_NODE),
    Some(&WORD_TEU_NODE),
    None,
    None,
    Some(&WORD_TEX_NODE),
    Some(&WORD_TEY_NODE),
    None,
];

static WORD_TEY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEY_CHILDREN),
    value: Some(&["they"]),
};

pub static WORD_TEY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[],
    values: &[],
    range: 0..=0,
};

static WORD_TEX_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEX_CHILDREN),
    value: None,
};

pub static WORD_TEX_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("chnically"),
        dictgen::InsensitiveStr::Ascii("line"),
        dictgen::InsensitiveStr::Ascii("tfrme"),
        dictgen::InsensitiveStr::Ascii("turers"),
        dictgen::InsensitiveStr::Ascii("ual"),
        dictgen::InsensitiveStr::Ascii("ually"),
        dictgen::InsensitiveStr::Ascii("utres"),
        dictgen::InsensitiveStr::Ascii("xt"),
    ],
    values: &[
        &["technically"],
        &["textline"],
        &["textframe"],
        &["textures"],
        &["textual"],
        &["textually"],
        &["textures"],
        &["text"],
    ],
    range: 2..=9,
};

static WORD_TEU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEU_CHILDREN),
    value: None,
};

pub static WORD_TEU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("sday"),
        dictgen::InsensitiveStr::Ascii("sdays"),
    ],
    values: &[&["tuesday"], &["tuesdays"]],
    range: 4..=5,
};

static WORD_TET_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TET_CHILDREN),
    value: None,
};

pub static WORD_TET_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rahedran"),
        dictgen::InsensitiveStr::Ascii("rahedrans"),
        dictgen::InsensitiveStr::Ascii("ry"),
        dictgen::InsensitiveStr::Ascii("ss"),
        dictgen::InsensitiveStr::Ascii("xture"),
    ],
    values: &[
        &["tetrahedron"],
        &["tetrahedrons"],
        &["retry"],
        &["tests"],
        &["texture"],
    ],
    range: 2..=9,
};

static WORD_TES_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TES_CHILDREN),
    value: None,
};

pub static WORD_TES_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("case"),
        dictgen::InsensitiveStr::Ascii("cases"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("ellate"),
        dictgen::InsensitiveStr::Ascii("ellated"),
        dictgen::InsensitiveStr::Ascii("ellation"),
        dictgen::InsensitiveStr::Ascii("ellator"),
        dictgen::InsensitiveStr::Ascii("itcle"),
        dictgen::InsensitiveStr::Ascii("itcles"),
        dictgen::InsensitiveStr::Ascii("itfy"),
        dictgen::InsensitiveStr::Ascii("itmony"),
        dictgen::InsensitiveStr::Ascii("sealte"),
        dictgen::InsensitiveStr::Ascii("sealted"),
        dictgen::InsensitiveStr::Ascii("selatad"),
        dictgen::InsensitiveStr::Ascii("selate"),
        dictgen::InsensitiveStr::Ascii("selated"),
        dictgen::InsensitiveStr::Ascii("selation"),
        dictgen::InsensitiveStr::Ascii("selator"),
        dictgen::InsensitiveStr::Ascii("sleate"),
        dictgen::InsensitiveStr::Ascii("sleated"),
        dictgen::InsensitiveStr::Ascii("sleating"),
        dictgen::InsensitiveStr::Ascii("sleator"),
        dictgen::InsensitiveStr::Ascii("tasterone"),
        dictgen::InsensitiveStr::Ascii("teing"),
        dictgen::InsensitiveStr::Ascii("testorone"),
        dictgen::InsensitiveStr::Ascii("tice"),
        dictgen::InsensitiveStr::Ascii("ticel"),
        dictgen::InsensitiveStr::Ascii("ticels"),
        dictgen::InsensitiveStr::Ascii("ticlees"),
        dictgen::InsensitiveStr::Ascii("ticlies"),
        dictgen::InsensitiveStr::Ascii("ticlular"),
        dictgen::InsensitiveStr::Ascii("tifiy"),
        dictgen::InsensitiveStr::Ascii("timoney"),
        dictgen::InsensitiveStr::Ascii("tin"),
        dictgen::InsensitiveStr::Ascii("tng"),
        dictgen::InsensitiveStr::Ascii("tomony"),
    ],
    values: &[
        &["testcase"],
        &["testcases"],
        &["these"],
        &["used", "teased"],
        &["tessellate"],
        &["tessellated"],
        &["tessellation"],
        &["tessellator"],
        &["testicle"],
        &["testicles"],
        &["testify"],
        &["testimony"],
        &["tessellate"],
        &["tessellated"],
        &["tessellated"],
        &["tessellate"],
        &["tessellated"],
        &["tessellation"],
        &["tessellator"],
        &["tessellate"],
        &["tessellated"],
        &["tessellating"],
        &["tessellator"],
        &["testosterone"],
        &["testing"],
        &["testosterone"],
        &["testicle"],
        &["testicle"],
        &["testicles"],
        &["testicles"],
        &["testicle"],
        &["testicular"],
        &["testify"],
        &["testimony"],
        &["testing"],
        &["testing"],
        &["testimony"],
    ],
    range: 1..=9,
};

static WORD_TER_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_TER_CHILDREN),
    value: None,
};

static WORD_TER_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_TERI_NODE),
    None,
    None,
    None,
    Some(&WORD_TERM_NODE),
    Some(&WORD_TERN_NODE),
    Some(&WORD_TERO_NODE),
    None,
    None,
    Some(&WORD_TERR_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_TERR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TERR_CHILDREN),
    value: None,
};

pub static WORD_TERR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("able"),
        dictgen::InsensitiveStr::Ascii("abyte"),
        dictgen::InsensitiveStr::Ascii("atorial"),
        dictgen::InsensitiveStr::Ascii("atories"),
        dictgen::InsensitiveStr::Ascii("erists"),
        dictgen::InsensitiveStr::Ascii("estial"),
        dictgen::InsensitiveStr::Ascii("etorial"),
        dictgen::InsensitiveStr::Ascii("etories"),
        dictgen::InsensitiveStr::Ascii("iblely"),
        dictgen::InsensitiveStr::Ascii("ibley"),
        dictgen::InsensitiveStr::Ascii("iblly"),
        dictgen::InsensitiveStr::Ascii("iories"),
        dictgen::InsensitiveStr::Ascii("iory"),
        dictgen::InsensitiveStr::Ascii("irorial"),
        dictgen::InsensitiveStr::Ascii("irories"),
        dictgen::InsensitiveStr::Ascii("iroties"),
        dictgen::InsensitiveStr::Ascii("iroty"),
        dictgen::InsensitiveStr::Ascii("istrial"),
        dictgen::InsensitiveStr::Ascii("itoires"),
        dictgen::InsensitiveStr::Ascii("itoral"),
        dictgen::InsensitiveStr::Ascii("itores"),
        dictgen::InsensitiveStr::Ascii("itoriella"),
        dictgen::InsensitiveStr::Ascii("itoris"),
        dictgen::InsensitiveStr::Ascii("itorist"),
        dictgen::InsensitiveStr::Ascii("itority"),
        dictgen::InsensitiveStr::Ascii("itorrial"),
        dictgen::InsensitiveStr::Ascii("itorries"),
        dictgen::InsensitiveStr::Ascii("itorry"),
        dictgen::InsensitiveStr::Ascii("itoy"),
        dictgen::InsensitiveStr::Ascii("oist"),
        dictgen::InsensitiveStr::Ascii("orisim"),
        dictgen::InsensitiveStr::Ascii("oristas"),
        dictgen::InsensitiveStr::Ascii("oristes"),
        dictgen::InsensitiveStr::Ascii("orities"),
        dictgen::InsensitiveStr::Ascii("orits"),
        dictgen::InsensitiveStr::Ascii("orsim"),
        dictgen::InsensitiveStr::Ascii("orsits"),
        dictgen::InsensitiveStr::Ascii("otorial"),
        dictgen::InsensitiveStr::Ascii("otories"),
        dictgen::InsensitiveStr::Ascii("urists"),
    ],
    values: &[
        &["terrible"],
        &["terabyte"],
        &["territorial"],
        &["territories"],
        &["terrorists"],
        &["terrestrial"],
        &["territorial"],
        &["territories"],
        &["terribly"],
        &["terribly"],
        &["terribly"],
        &["territories"],
        &["territory"],
        &["territorial"],
        &["territories"],
        &["territories"],
        &["territory"],
        &["territorial"],
        &["territories"],
        &["territorial"],
        &["territories"],
        &["territorial"],
        &["territories"],
        &["terrorist"],
        &["territory"],
        &["territorial"],
        &["territories"],
        &["territory"],
        &["territory"],
        &["terrorist"],
        &["terrorism"],
        &["terrorists"],
        &["terrorists"],
        &["territories"],
        &["terrorist"],
        &["terrorism"],
        &["terrorists"],
        &["territorial"],
        &["territories"],
        &["terrorists"],
    ],
    range: 4..=9,
};

static WORD_TERO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TERO_CHILDREN),
    value: None,
};

pub static WORD_TERO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rrism"),
        dictgen::InsensitiveStr::Ascii("rrist"),
        dictgen::InsensitiveStr::Ascii("rrists"),
    ],
    values: &[&["terrorism"], &["terrorist"], &["terrorists"]],
    range: 5..=6,
};

static WORD_TERN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TERN_CHILDREN),
    value: None,
};

pub static WORD_TERN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ament"),
        dictgen::InsensitiveStr::Ascii("imate"),
    ],
    values: &[&["tournament"], &["terminate"]],
    range: 5..=5,
};

static WORD_TERM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TERM_CHILDREN),
    value: None,
};

pub static WORD_TERM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("anator"),
        dictgen::InsensitiveStr::Ascii("anology"),
        dictgen::InsensitiveStr::Ascii("endous"),
        dictgen::InsensitiveStr::Ascii("endously"),
        dictgen::InsensitiveStr::Ascii("ianls"),
        dictgen::InsensitiveStr::Ascii("ianted"),
        dictgen::InsensitiveStr::Ascii("iantor"),
        dictgen::InsensitiveStr::Ascii("igator"),
        dictgen::InsensitiveStr::Ascii("inacion"),
        dictgen::InsensitiveStr::Ascii("inaison"),
        dictgen::InsensitiveStr::Ascii("inales"),
        dictgen::InsensitiveStr::Ascii("inalis"),
        dictgen::InsensitiveStr::Ascii("inalogy"),
        dictgen::InsensitiveStr::Ascii("inarla"),
        dictgen::InsensitiveStr::Ascii("inarlo"),
        dictgen::InsensitiveStr::Ascii("inaron"),
        dictgen::InsensitiveStr::Ascii("inater"),
        dictgen::InsensitiveStr::Ascii("inaters"),
        dictgen::InsensitiveStr::Ascii("inatior"),
        dictgen::InsensitiveStr::Ascii("inato"),
        dictgen::InsensitiveStr::Ascii("inatorn"),
        dictgen::InsensitiveStr::Ascii("inats"),
        dictgen::InsensitiveStr::Ascii("indate"),
        dictgen::InsensitiveStr::Ascii("ine"),
        dictgen::InsensitiveStr::Ascii("ined"),
        dictgen::InsensitiveStr::Ascii("inilogy"),
        dictgen::InsensitiveStr::Ascii("inolgy"),
        dictgen::InsensitiveStr::Ascii("inoligy"),
        dictgen::InsensitiveStr::Ascii("inte"),
        dictgen::InsensitiveStr::Ascii("o"),
        dictgen::InsensitiveStr::Ascii("ostat"),
        dictgen::InsensitiveStr::Ascii("peratue"),
        dictgen::InsensitiveStr::Ascii("peratues"),
        dictgen::InsensitiveStr::Ascii("perature"),
        dictgen::InsensitiveStr::Ascii("peratures"),
        dictgen::InsensitiveStr::Ascii("plate"),
        dictgen::InsensitiveStr::Ascii("plated"),
        dictgen::InsensitiveStr::Ascii("plates"),
        dictgen::InsensitiveStr::Ascii("poral"),
        dictgen::InsensitiveStr::Ascii("poraries"),
        dictgen::InsensitiveStr::Ascii("porarily"),
        dictgen::InsensitiveStr::Ascii("porary"),
    ],
    values: &[
        &["terminator"],
        &["terminology"],
        &["tremendous"],
        &["tremendously"],
        &["terminals"],
        &["terminated"],
        &["terminator"],
        &["terminator"],
        &["termination"],
        &["termination"],
        &["terminals"],
        &["terminals"],
        &["terminology"],
        &["terminal"],
        &["terminal"],
        &["terminator"],
        &["terminator"],
        &["terminators"],
        &["terminator"],
        &["termination"],
        &["termination"],
        &["terminates"],
        &["terminate"],
        &["determine"],
        &["terminated"],
        &["terminology"],
        &["terminology"],
        &["terminology"],
        &["terminate"],
        &["thermo"],
        &["thermostat"],
        &["temperature"],
        &["temperatures"],
        &["temperature"],
        &["temperatures"],
        &["template"],
        &["templated"],
        &["templates"],
        &["temporal"],
        &["temporaries"],
        &["temporarily"],
        &["temporary"],
    ],
    range: 1..=9,
};

static WORD_TERI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TERI_CHILDREN),
    value: None,
};

pub static WORD_TERI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("dactyl"),
        dictgen::InsensitiveStr::Ascii("fic"),
        dictgen::InsensitiveStr::Ascii("mnate"),
    ],
    values: &[&["pterodactyl"], &["terrific"], &["terminate"]],
    range: 3..=6,
};

static WORD_TEQ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEQ_CHILDREN),
    value: None,
};

pub static WORD_TEQ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("uilia"),
        dictgen::InsensitiveStr::Ascii("ulia"),
    ],
    values: &[&["tequila"], &["tequila"]],
    range: 4..=5,
};

static WORD_TEP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEP_CHILDREN),
    value: None,
};

pub static WORD_TEP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lmate"),
        dictgen::InsensitiveStr::Ascii("lmated"),
        dictgen::InsensitiveStr::Ascii("lmates"),
        dictgen::InsensitiveStr::Ascii("morarily"),
    ],
    values: &[
        &["template"],
        &["templated"],
        &["templates"],
        &["temporarily"],
    ],
    range: 5..=8,
};

static WORD_TEN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEN_CHILDREN),
    value: None,
};

pub static WORD_TEN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("acitiy"),
        dictgen::InsensitiveStr::Ascii("acle"),
        dictgen::InsensitiveStr::Ascii("acles"),
        dictgen::InsensitiveStr::Ascii("actiy"),
        dictgen::InsensitiveStr::Ascii("ative"),
        dictgen::InsensitiveStr::Ascii("atively"),
        dictgen::InsensitiveStr::Ascii("caity"),
        dictgen::InsensitiveStr::Ascii("dacy"),
        dictgen::InsensitiveStr::Ascii("dancies"),
        dictgen::InsensitiveStr::Ascii("dancy"),
        dictgen::InsensitiveStr::Ascii("dence"),
        dictgen::InsensitiveStr::Ascii("dencias"),
        dictgen::InsensitiveStr::Ascii("dencije"),
        dictgen::InsensitiveStr::Ascii("densies"),
        dictgen::InsensitiveStr::Ascii("dincies"),
        dictgen::InsensitiveStr::Ascii("gentially"),
        dictgen::InsensitiveStr::Ascii("siones"),
        dictgen::InsensitiveStr::Ascii("sionors"),
        dictgen::InsensitiveStr::Ascii("tacel"),
        dictgen::InsensitiveStr::Ascii("tacels"),
        dictgen::InsensitiveStr::Ascii("tacls"),
        dictgen::InsensitiveStr::Ascii("tacreul"),
        dictgen::InsensitiveStr::Ascii("tacuel"),
        dictgen::InsensitiveStr::Ascii("talce"),
        dictgen::InsensitiveStr::Ascii("talces"),
        dictgen::InsensitiveStr::Ascii("tion"),
    ],
    values: &[
        &["tenacity"],
        &["tentacle"],
        &["tentacles"],
        &["tenacity"],
        &["tentative"],
        &["tentatively"],
        &["tenacity"],
        &["tendency"],
        &["tendencies"],
        &["tendency"],
        &["tendencies"],
        &["tendencies"],
        &["tendencies"],
        &["tendencies"],
        &["tendencies"],
        &["tangentially"],
        &["tensions"],
        &["tensions"],
        &["tentacle"],
        &["tentacles"],
        &["tentacles"],
        &["tentacle"],
        &["tentacle"],
        &["tentacle"],
        &["tentacles"],
        &["tension"],
    ],
    range: 4..=9,
};

static WORD_TEM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_TEM_CHILDREN),
    value: None,
};

static WORD_TEM_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_TEMA_NODE),
    None,
    None,
    None,
    Some(&WORD_TEME_NODE),
    None,
    None,
    None,
    Some(&WORD_TEMI_NODE),
    None,
    None,
    Some(&WORD_TEML_NODE),
    Some(&WORD_TEMM_NODE),
    None,
    Some(&WORD_TEMO_NODE),
    Some(&WORD_TEMP_NODE),
    None,
    Some(&WORD_TEMR_NODE),
    None,
    Some(&WORD_TEMT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_TEMT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEMT_CHILDREN),
    value: None,
};

pub static WORD_TEMT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ation")],
    values: &[&["temptation"]],
    range: 5..=5,
};

static WORD_TEMR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEMR_CHILDREN),
    value: Some(&["term"]),
};

pub static WORD_TEMR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[],
    values: &[],
    range: 0..=0,
};

static WORD_TEMP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_TEMP_CHILDREN),
    value: None,
};

static WORD_TEMP_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_TEMPA_NODE),
    None,
    None,
    Some(&WORD_TEMPD_NODE),
    Some(&WORD_TEMPE_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_TEMPL_NODE),
    None,
    None,
    Some(&WORD_TEMPO_NODE),
    None,
    None,
    Some(&WORD_TEMPR_NODE),
    Some(&WORD_TEMPS_NODE),
    Some(&WORD_TEMPT_NODE),
    Some(&WORD_TEMPU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static WORD_TEMPU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEMPU_CHILDREN),
    value: None,
};

pub static WORD_TEMPU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rature"),
        dictgen::InsensitiveStr::Ascii("ratures"),
        dictgen::InsensitiveStr::Ascii("rture"),
    ],
    values: &[&["temperature"], &["temperatures"], &["temperature"]],
    range: 5..=7,
};

static WORD_TEMPT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEMPT_CHILDREN),
    value: None,
};

pub static WORD_TEMPT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("atation"),
        dictgen::InsensitiveStr::Ascii("ating"),
        dictgen::InsensitiveStr::Ascii("etion"),
    ],
    values: &[&["temptation"], &["temptation"], &["temptation"]],
    range: 5..=7,
};

static WORD_TEMPS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEMPS_CHILDREN),
    value: None,
};

pub static WORD_TEMPS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("et")],
    values: &[&["tempest"]],
    range: 2..=2,
};

static WORD_TEMPR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEMPR_CHILDREN),
    value: None,
};

pub static WORD_TEMPR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aaily"),
        dictgen::InsensitiveStr::Ascii("aal"),
        dictgen::InsensitiveStr::Ascii("aarily"),
        dictgen::InsensitiveStr::Ascii("aarly"),
        dictgen::InsensitiveStr::Ascii("aary"),
        dictgen::InsensitiveStr::Ascii("aay"),
        dictgen::InsensitiveStr::Ascii("aily"),
        dictgen::InsensitiveStr::Ascii("al"),
        dictgen::InsensitiveStr::Ascii("ament"),
        dictgen::InsensitiveStr::Ascii("amental"),
        dictgen::InsensitiveStr::Ascii("araily"),
        dictgen::InsensitiveStr::Ascii("aral"),
        dictgen::InsensitiveStr::Ascii("araly"),
        dictgen::InsensitiveStr::Ascii("ararily"),
        dictgen::InsensitiveStr::Ascii("ararly"),
        dictgen::InsensitiveStr::Ascii("arary"),
        dictgen::InsensitiveStr::Ascii("aray"),
        dictgen::InsensitiveStr::Ascii("arily"),
        dictgen::InsensitiveStr::Ascii("ary"),
        dictgen::InsensitiveStr::Ascii("ature"),
        dictgen::InsensitiveStr::Ascii("atures"),
        dictgen::InsensitiveStr::Ascii("ay"),
        dictgen::InsensitiveStr::Ascii("eature"),
        dictgen::InsensitiveStr::Ascii("eatures"),
        dictgen::InsensitiveStr::Ascii("ement"),
        dictgen::InsensitiveStr::Ascii("emental"),
        dictgen::InsensitiveStr::Ascii("oaily"),
        dictgen::InsensitiveStr::Ascii("oal"),
        dictgen::InsensitiveStr::Ascii("oarily"),
        dictgen::InsensitiveStr::Ascii("oarly"),
        dictgen::InsensitiveStr::Ascii("oary"),
        dictgen::InsensitiveStr::Ascii("oay"),
        dictgen::InsensitiveStr::Ascii("oily"),
        dictgen::InsensitiveStr::Ascii("ol"),
        dictgen::InsensitiveStr::Ascii("oment"),
        dictgen::InsensitiveStr::Ascii("omental"),
        dictgen::InsensitiveStr::Ascii("oraily"),
        dictgen::InsensitiveStr::Ascii("oral"),
        dictgen::InsensitiveStr::Ascii("oraly"),
        dictgen::InsensitiveStr::Ascii("orarily"),
        dictgen::InsensitiveStr::Ascii("orarly"),
        dictgen::InsensitiveStr::Ascii("orary"),
        dictgen::InsensitiveStr::Ascii("oray"),
        dictgen::InsensitiveStr::Ascii("orily"),
        dictgen::InsensitiveStr::Ascii("ory"),
        dictgen::InsensitiveStr::Ascii("oy"),
    ],
    values: &[
        &["temporarily"],
        &["temporal"],
        &["temporarily"],
        &["temporarily"],
        &["temporary"],
        &["temporary"],
        &["temporarily"],
        &["temporal"],
        &["temperament"],
        &["temperamental"],
        &["temporarily"],
        &["temporal"],
        &["temporarily", "temporally"],
        &["temporarily"],
        &["temporarily"],
        &["temporary"],
        &["temporary"],
        &["temporarily"],
        &["temporary", "temporarily"],
        &["temperature"],
        &["temperatures"],
        &["temporary"],
        &["temperature"],
        &["temperatures"],
        &["temperament"],
        &["temperamental"],
        &["temporarily"],
        &["temporal"],
        &["temporarily"],
        &["temporarily"],
        &["temporary"],
        &["temporary"],
        &["temporarily", "temporally"],
        &["temporal"],
        &["temperament"],
        &["temperamental"],
        &["temporarily"],
        &["temporal"],
        &["temporarily"],
        &["temporarily"],
        &["temporarily"],
        &["temporary"],
        &["temporary"],
        &["temporarily"],
        &["temporary"],
        &["temporary"],
    ],
    range: 2..=7,
};

static WORD_TEMPO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEMPO_CHILDREN),
    value: None,
};

pub static WORD_TEMPO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aray"),
        dictgen::InsensitiveStr::Ascii("pary"),
        dictgen::InsensitiveStr::Ascii("raere"),
        dictgen::InsensitiveStr::Ascii("rafy"),
        dictgen::InsensitiveStr::Ascii("raily"),
        dictgen::InsensitiveStr::Ascii("rairly"),
        dictgen::InsensitiveStr::Ascii("rali"),
        dictgen::InsensitiveStr::Ascii("ralily"),
        dictgen::InsensitiveStr::Ascii("raly"),
        dictgen::InsensitiveStr::Ascii("raraly"),
        dictgen::InsensitiveStr::Ascii("rarely"),
        dictgen::InsensitiveStr::Ascii("rarilly"),
        dictgen::InsensitiveStr::Ascii("rarilty"),
        dictgen::InsensitiveStr::Ascii("rarilu"),
        dictgen::InsensitiveStr::Ascii("rarirly"),
        dictgen::InsensitiveStr::Ascii("rarity"),
        dictgen::InsensitiveStr::Ascii("rarly"),
        dictgen::InsensitiveStr::Ascii("ray"),
        dictgen::InsensitiveStr::Ascii("ries"),
        dictgen::InsensitiveStr::Ascii("rily"),
        dictgen::InsensitiveStr::Ascii("roraries"),
        dictgen::InsensitiveStr::Ascii("rorarily"),
        dictgen::InsensitiveStr::Ascii("rorary"),
        dictgen::InsensitiveStr::Ascii("rories"),
        dictgen::InsensitiveStr::Ascii("rorily"),
        dictgen::InsensitiveStr::Ascii("rory"),
        dictgen::InsensitiveStr::Ascii("rraies"),
        dictgen::InsensitiveStr::Ascii("rraily"),
        dictgen::InsensitiveStr::Ascii("rraries"),
        dictgen::InsensitiveStr::Ascii("rrarily"),
        dictgen::InsensitiveStr::Ascii("rrary"),
        dictgen::InsensitiveStr::Ascii("rray"),
        dictgen::InsensitiveStr::Ascii("rries"),
        dictgen::InsensitiveStr::Ascii("rrily"),
        dictgen::InsensitiveStr::Ascii("rry"),
        dictgen::InsensitiveStr::Ascii("rtal"),
        dictgen::InsensitiveStr::Ascii("rtaries"),
        dictgen::InsensitiveStr::Ascii("rtarily"),
        dictgen::InsensitiveStr::Ascii("rtary"),
        dictgen::InsensitiveStr::Ascii("ry"),
        dictgen::InsensitiveStr::Ascii("ryries"),
        dictgen::InsensitiveStr::Ascii("ryrily"),
        dictgen::InsensitiveStr::Ascii("ryry"),
    ],
    values: &[
        &["temporary"],
        &["temporary"],
        &["temporary"],
        &["temporary"],
        &["temporarily"],
        &["temporarily"],
        &["temporarily"],
        &["temporarily"],
        &["temporary", "temporarily", "temporally"],
        &["temporarily"],
        &["temporarily"],
        &["temporarily"],
        &["temporarily"],
        &["temporary"],
        &["temporarily"],
        &["temporarily"],
        &["temporary", "temporarily"],
        &["temporary"],
        &["temporaries"],
        &["temporarily"],
        &["temporaries"],
        &["temporarily"],
        &["temporary"],
        &["temporaries"],
        &["temporarily"],
        &["temporary"],
        &["temporaries"],
        &["temporarily"],
        &["temporaries"],
        &["temporarily"],
        &["temporary"],
        &["temporary"],
        &["temporaries"],
        &["temporarily"],
        &["temporary"],
        &["temporal"],
        &["temporaries"],
        &["temporarily"],
        &["temporary"],
        &["temporary"],
        &["temporaries"],
        &["temporarily"],
        &["temporary"],
    ],
    range: 2..=8,
};

static WORD_TEMPL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEMPL_CHILDREN),
    value: None,
};

pub static WORD_TEMPL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aet"),
        dictgen::InsensitiveStr::Ascii("aras"),
        dictgen::InsensitiveStr::Ascii("ares"),
        dictgen::InsensitiveStr::Ascii("arios"),
        dictgen::InsensitiveStr::Ascii("arius"),
        dictgen::InsensitiveStr::Ascii("as"),
        dictgen::InsensitiveStr::Ascii("at"),
        dictgen::InsensitiveStr::Ascii("ateas"),
        dictgen::InsensitiveStr::Ascii("ats"),
        dictgen::InsensitiveStr::Ascii("eos"),
        dictgen::InsensitiveStr::Ascii("ers"),
    ],
    values: &[
        &["template"],
        &["templars"],
        &["templars"],
        &["templars"],
        &["templars"],
        &["templars"],
        &["template"],
        &["templates"],
        &["templates"],
        &["temples"],
        &["temples"],
    ],
    range: 2..=5,
};

static WORD_TEMPE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEMPE_CHILDREN),
    value: None,
};

pub static WORD_TEMPE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arture"),
        dictgen::InsensitiveStr::Ascii("arure"),
        dictgen::InsensitiveStr::Ascii("late"),
        dictgen::InsensitiveStr::Ascii("ls"),
        dictgen::InsensitiveStr::Ascii("ramant"),
        dictgen::InsensitiveStr::Ascii("rarily"),
        dictgen::InsensitiveStr::Ascii("rarure"),
        dictgen::InsensitiveStr::Ascii("rary"),
        dictgen::InsensitiveStr::Ascii("ratue"),
        dictgen::InsensitiveStr::Ascii("ratues"),
        dictgen::InsensitiveStr::Ascii("ratur"),
        dictgen::InsensitiveStr::Ascii("raturas"),
        dictgen::InsensitiveStr::Ascii("raturs"),
        dictgen::InsensitiveStr::Ascii("ratuur"),
        dictgen::InsensitiveStr::Ascii("reature"),
        dictgen::InsensitiveStr::Ascii("rement"),
        dictgen::InsensitiveStr::Ascii("rmeant"),
        dictgen::InsensitiveStr::Ascii("rment"),
        dictgen::InsensitiveStr::Ascii("rtaure"),
        dictgen::InsensitiveStr::Ascii("rture"),
        dictgen::InsensitiveStr::Ascii("ts"),
    ],
    values: &[
        &["temperatures"],
        &["temperature"],
        &["template"],
        &["temples"],
        &["temperament"],
        &["temporarily"],
        &["temperature"],
        &["temporary"],
        &["temperature"],
        &["temperatures"],
        &["temperature"],
        &["temperatures"],
        &["temperatures"],
        &["temperature"],
        &["temperature"],
        &["temperament"],
        &["temperament"],
        &["temperament"],
        &["temperature"],
        &["temperature"],
        &["tempest"],
    ],
    range: 2..=7,
};

static WORD_TEMPD_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEMPD_CHILDREN),
    value: None,
};

pub static WORD_TEMPD_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ate")],
    values: &[&["template"]],
    range: 3..=3,
};

static WORD_TEMPA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEMPA_CHILDREN),
    value: None,
};

pub static WORD_TEMPA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lrs"),
        dictgen::InsensitiveStr::Ascii("lte"),
        dictgen::InsensitiveStr::Ascii("ltes"),
        dictgen::InsensitiveStr::Ascii("rament"),
        dictgen::InsensitiveStr::Ascii("rarily"),
        dictgen::InsensitiveStr::Ascii("rary"),
        dictgen::InsensitiveStr::Ascii("rate"),
        dictgen::InsensitiveStr::Ascii("rature"),
        dictgen::InsensitiveStr::Ascii("ratures"),
        dictgen::InsensitiveStr::Ascii("rement"),
        dictgen::InsensitiveStr::Ascii("rily"),
        dictgen::InsensitiveStr::Ascii("te"),
        dictgen::InsensitiveStr::Ascii("ted"),
        dictgen::InsensitiveStr::Ascii("tes"),
        dictgen::InsensitiveStr::Ascii("tied"),
        dictgen::InsensitiveStr::Ascii("tion"),
        dictgen::InsensitiveStr::Ascii("tised"),
        dictgen::InsensitiveStr::Ascii("tized"),
        dictgen::InsensitiveStr::Ascii("ture"),
    ],
    values: &[
        &["templars"],
        &["template"],
        &["templates"],
        &["temperament"],
        &["temporarily"],
        &["temporary"],
        &["temperate"],
        &["temperature"],
        &["temperatures"],
        &["temperament"],
        &["temporarily"],
        &["template"],
        &["templated"],
        &["templates"],
        &["templatized"],
        &["temptation"],
        &["templatised"],
        &["templatized"],
        &["temperature"],
    ],
    range: 2..=7,
};

static WORD_TEMO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEMO_CHILDREN),
    value: None,
};

pub static WORD_TEMO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rarily"),
        dictgen::InsensitiveStr::Ascii("rary"),
    ],
    values: &[&["temporarily"], &["temporary"]],
    range: 4..=6,
};

static WORD_TEMM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEMM_CHILDREN),
    value: None,
};

pub static WORD_TEMM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("porary")],
    values: &[&["temporary", "temporarily"]],
    range: 6..=6,
};

static WORD_TEML_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEML_CHILDREN),
    value: None,
};

pub static WORD_TEML_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ate")],
    values: &[&["template"]],
    range: 3..=3,
};

static WORD_TEMI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEMI_CHILDREN),
    value: None,
};

pub static WORD_TEMI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("nate"),
        dictgen::InsensitiveStr::Ascii("nated"),
        dictgen::InsensitiveStr::Ascii("nating"),
        dictgen::InsensitiveStr::Ascii("nation"),
    ],
    values: &[
        &["terminate"],
        &["terminated"],
        &["terminating"],
        &["termination"],
    ],
    range: 4..=6,
};

static WORD_TEME_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEME_CHILDREN),
    value: None,
};

pub static WORD_TEME_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("prature"),
        dictgen::InsensitiveStr::Ascii("pratures"),
        dictgen::InsensitiveStr::Ascii("pst"),
        dictgen::InsensitiveStr::Ascii("rature"),
    ],
    values: &[
        &["temperature"],
        &["temperatures"],
        &["tempest"],
        &["temperature"],
    ],
    range: 3..=8,
};

static WORD_TEMA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEMA_CHILDREN),
    value: None,
};

pub static WORD_TEMA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("fight"),
        dictgen::InsensitiveStr::Ascii("fights"),
        dictgen::InsensitiveStr::Ascii("plate"),
        dictgen::InsensitiveStr::Ascii("plates"),
    ],
    values: &[
        &["teamfight"],
        &["teamfights"],
        &["template"],
        &["templates"],
    ],
    range: 5..=6,
};

static WORD_TEL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEL_CHILDREN),
    value: None,
};

pub static WORD_TEL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aportation"),
        dictgen::InsensitiveStr::Ascii("egrah"),
        dictgen::InsensitiveStr::Ascii("egramm"),
        dictgen::InsensitiveStr::Ascii("egrapgh"),
        dictgen::InsensitiveStr::Ascii("egrpah"),
        dictgen::InsensitiveStr::Ascii("elevision"),
        dictgen::InsensitiveStr::Ascii("eporing"),
        dictgen::InsensitiveStr::Ascii("eportaion"),
        dictgen::InsensitiveStr::Ascii("eportating"),
        dictgen::InsensitiveStr::Ascii("eportato"),
        dictgen::InsensitiveStr::Ascii("eportaton"),
        dictgen::InsensitiveStr::Ascii("eportion"),
        dictgen::InsensitiveStr::Ascii("eprotation"),
        dictgen::InsensitiveStr::Ascii("eproting"),
        dictgen::InsensitiveStr::Ascii("evesion"),
        dictgen::InsensitiveStr::Ascii("evisivo"),
        dictgen::InsensitiveStr::Ascii("evsion"),
        dictgen::InsensitiveStr::Ascii("iportation"),
        dictgen::InsensitiveStr::Ascii("ocom"),
        dictgen::InsensitiveStr::Ascii("oportation"),
        dictgen::InsensitiveStr::Ascii("phony"),
    ],
    values: &[
        &["teleportation"],
        &["telegraph"],
        &["telegram"],
        &["telegraph"],
        &["telegraph"],
        &["television"],
        &["teleporting"],
        &["teleportation"],
        &["teleportation"],
        &["teleportation"],
        &["teleportation"],
        &["teleporting"],
        &["teleportation"],
        &["teleporting"],
        &["television"],
        &["television"],
        &["television"],
        &["teleportation"],
        &["telecom"],
        &["teleportation"],
        &["telephony"],
    ],
    range: 4..=10,
};

static WORD_TEK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEK_CHILDREN),
    value: None,
};

pub static WORD_TEK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("st"),
        dictgen::InsensitiveStr::Ascii("sts"),
    ],
    values: &[&["text"], &["texts"]],
    range: 2..=3,
};

static WORD_TEH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEH_CHILDREN),
    value: Some(&["the"]),
};

pub static WORD_TEH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cies"),
        dictgen::InsensitiveStr::Ascii("nically"),
        dictgen::InsensitiveStr::Ascii("tering"),
        dictgen::InsensitiveStr::Ascii("y"),
    ],
    values: &[&["techies"], &["ethnically"], &["tethering"], &["they"]],
    range: 1..=7,
};

static WORD_TEF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEF_CHILDREN),
    value: None,
};

pub static WORD_TEF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ine")],
    values: &[&["define"]],
    range: 3..=3,
};

static WORD_TEE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEE_CHILDREN),
    value: None,
};

pub static WORD_TEE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("angers"),
        dictgen::InsensitiveStr::Ascii("nages"),
    ],
    values: &[&["teenagers"], &["teenagers"]],
    range: 5..=6,
};

static WORD_TED_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TED_CHILDREN),
    value: None,
};

pub static WORD_TED_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("eous")],
    values: &[&["tedious"]],
    range: 4..=4,
};

static WORD_TEC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEC_CHILDREN),
    value: None,
};

pub static WORD_TEC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hanically"),
        dictgen::InsensitiveStr::Ascii("heis"),
        dictgen::InsensitiveStr::Ascii("hical"),
        dictgen::InsensitiveStr::Ascii("hician"),
        dictgen::InsensitiveStr::Ascii("hicians"),
        dictgen::InsensitiveStr::Ascii("hincal"),
        dictgen::InsensitiveStr::Ascii("hincality"),
        dictgen::InsensitiveStr::Ascii("hincally"),
        dictgen::InsensitiveStr::Ascii("hincian"),
        dictgen::InsensitiveStr::Ascii("hincians"),
        dictgen::InsensitiveStr::Ascii("hinically"),
        dictgen::InsensitiveStr::Ascii("hinican"),
        dictgen::InsensitiveStr::Ascii("hinique"),
        dictgen::InsensitiveStr::Ascii("hiniques"),
        dictgen::InsensitiveStr::Ascii("hinque"),
        dictgen::InsensitiveStr::Ascii("hinques"),
        dictgen::InsensitiveStr::Ascii("hique"),
        dictgen::InsensitiveStr::Ascii("hiques"),
        dictgen::InsensitiveStr::Ascii("hmological"),
        dictgen::InsensitiveStr::Ascii("hncially"),
        dictgen::InsensitiveStr::Ascii("hneek"),
        dictgen::InsensitiveStr::Ascii("hnic"),
        dictgen::InsensitiveStr::Ascii("hnicain"),
        dictgen::InsensitiveStr::Ascii("hnicallity"),
        dictgen::InsensitiveStr::Ascii("hnicalty"),
        dictgen::InsensitiveStr::Ascii("hnicaly"),
        dictgen::InsensitiveStr::Ascii("hnicans"),
        dictgen::InsensitiveStr::Ascii("hnichan"),
        dictgen::InsensitiveStr::Ascii("hnichian"),
        dictgen::InsensitiveStr::Ascii("hnicials"),
        dictgen::InsensitiveStr::Ascii("hnicien"),
        dictgen::InsensitiveStr::Ascii("hniciens"),
        dictgen::InsensitiveStr::Ascii("hnicion"),
        dictgen::InsensitiveStr::Ascii("hnics"),
        dictgen::InsensitiveStr::Ascii("hnik"),
        dictgen::InsensitiveStr::Ascii("hniks"),
        dictgen::InsensitiveStr::Ascii("hniqe"),
        dictgen::InsensitiveStr::Ascii("hnitian"),
        dictgen::InsensitiveStr::Ascii("hnitians"),
        dictgen::InsensitiveStr::Ascii("hnition"),
        dictgen::InsensitiveStr::Ascii("hnlogy"),
        dictgen::InsensitiveStr::Ascii("hnnology"),
        dictgen::InsensitiveStr::Ascii("hnolgy"),
        dictgen::InsensitiveStr::Ascii("hnoligical"),
        dictgen::InsensitiveStr::Ascii("hnoligically"),
        dictgen::InsensitiveStr::Ascii("hnologia"),
        dictgen::InsensitiveStr::Ascii("hnologial"),
        dictgen::InsensitiveStr::Ascii("hnologicaly"),
        dictgen::InsensitiveStr::Ascii("hnologicially"),
        dictgen::InsensitiveStr::Ascii("hnologicly"),
        dictgen::InsensitiveStr::Ascii("hnoloiges"),
        dictgen::InsensitiveStr::Ascii("hnqiues"),
        dictgen::InsensitiveStr::Ascii("honlogical"),
        dictgen::InsensitiveStr::Ascii("htician"),
        dictgen::InsensitiveStr::Ascii("hticians"),
        dictgen::InsensitiveStr::Ascii("nic"),
        dictgen::InsensitiveStr::Ascii("nical"),
        dictgen::InsensitiveStr::Ascii("nically"),
        dictgen::InsensitiveStr::Ascii("nician"),
        dictgen::InsensitiveStr::Ascii("nicians"),
        dictgen::InsensitiveStr::Ascii("nique"),
        dictgen::InsensitiveStr::Ascii("niques"),
    ],
    values: &[
        &["mechanically"],
        &["techies"],
        &["technical"],
        &["technician"],
        &["technicians"],
        &["technical"],
        &["technicality"],
        &["technically"],
        &["technician"],
        &["technicians"],
        &["technically"],
        &["technician"],
        &["technique"],
        &["techniques"],
        &["technique"],
        &["techniques"],
        &["technique"],
        &["techniques"],
        &["technological"],
        &["technically"],
        &["technique"],
        &["technique"],
        &["technician"],
        &["technically"],
        &["technicality"],
        &["technically"],
        &["technicians"],
        &["technician"],
        &["technician"],
        &["technicians"],
        &["technician"],
        &["technicians"],
        &["technician"],
        &["techniques"],
        &["technique"],
        &["techniques"],
        &["technique"],
        &["technician"],
        &["technicians"],
        &["technician"],
        &["technology"],
        &["technology"],
        &["technology"],
        &["technological"],
        &["technologically"],
        &["technological"],
        &["technological"],
        &["technologically"],
        &["technologically"],
        &["technological"],
        &["technologies"],
        &["techniques"],
        &["technological"],
        &["technician"],
        &["technicians"],
        &["technique"],
        &["technical"],
        &["technically"],
        &["technician"],
        &["technicians"],
        &["technique"],
        &["techniques"],
    ],
    range: 3..=13,
};

static WORD_TEA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TEA_CHILDREN),
    value: None,
};

pub static WORD_TEA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ched"),
        dictgen::InsensitiveStr::Ascii("chnig"),
        dictgen::InsensitiveStr::Ascii("mfighs"),
        dictgen::InsensitiveStr::Ascii("mfighters"),
        dictgen::InsensitiveStr::Ascii("mfigt"),
        dictgen::InsensitiveStr::Ascii("mfigth"),
        dictgen::InsensitiveStr::Ascii("mfigths"),
        dictgen::InsensitiveStr::Ascii("mifght"),
        dictgen::InsensitiveStr::Ascii("mifghts"),
        dictgen::InsensitiveStr::Ascii("mplate"),
        dictgen::InsensitiveStr::Ascii("mplates"),
        dictgen::InsensitiveStr::Ascii("mpseak"),
        dictgen::InsensitiveStr::Ascii("mspeack"),
        dictgen::InsensitiveStr::Ascii("mspek"),
        dictgen::InsensitiveStr::Ascii("ncity"),
        dictgen::InsensitiveStr::Ascii("nsylvania"),
        dictgen::InsensitiveStr::Ascii("psoon"),
        dictgen::InsensitiveStr::Ascii("spon"),
        dictgen::InsensitiveStr::Ascii("spooon"),
        dictgen::InsensitiveStr::Ascii("ted"),
    ],
    values: &[
        &["taught"],
        &["teaching"],
        &["teamfights"],
        &["teamfights"],
        &["teamfight"],
        &["teamfight"],
        &["teamfights"],
        &["teamfight"],
        &["teamfights"],
        &["template"],
        &["templates"],
        &["teamspeak"],
        &["teamspeak"],
        &["teamspeak"],
        &["tenacity"],
        &["transylvania"],
        &["teaspoon"],
        &["teaspoon"],
        &["teaspoon"],
        &["treated"],
    ],
    range: 3..=9,
};

static WORD_TC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TC_CHILDREN),
    value: None,
};

pub static WORD_TC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ahce"),
        dictgen::InsensitiveStr::Ascii("ahces"),
        dictgen::InsensitiveStr::Ascii("heckout"),
    ],
    values: &[&["cache"], &["caches"], &["checkout"]],
    range: 4..=7,
};

static WORD_TB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TB_CHILDREN),
    value: None,
};

pub static WORD_TB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("ey"),
    ],
    values: &[&["the"], &["they"]],
    range: 1..=2,
};

static WORD_TA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_TA_CHILDREN),
    value: None,
};

static WORD_TA_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    Some(&WORD_TAB_NODE),
    Some(&WORD_TAC_NODE),
    None,
    None,
    None,
    Some(&WORD_TAG_NODE),
    Some(&WORD_TAH_NODE),
    Some(&WORD_TAI_NODE),
    None,
    Some(&WORD_TAK_NODE),
    Some(&WORD_TAL_NODE),
    Some(&WORD_TAM_NODE),
    Some(&WORD_TAN_NODE),
    None,
    Some(&WORD_TAP_NODE),
    None,
    Some(&WORD_TAR_NODE),
    Some(&WORD_TAS_NODE),
    Some(&WORD_TAT_NODE),
    None,
    Some(&WORD_TAV_NODE),
    Some(&WORD_TAW_NODE),
    Some(&WORD_TAX_NODE),
    Some(&WORD_TAY_NODE),
    None,
];

static WORD_TAY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAY_CHILDREN),
    value: None,
};

pub static WORD_TAY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("lored")],
    values: &[&["tailored"]],
    range: 5..=5,
};

static WORD_TAX_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAX_CHILDREN),
    value: None,
};

pub static WORD_TAX_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("anomic"),
        dictgen::InsensitiveStr::Ascii("anomy"),
        dictgen::InsensitiveStr::Ascii("nomy"),
        dictgen::InsensitiveStr::Ascii("omonmy"),
        dictgen::InsensitiveStr::Ascii("onmy"),
        dictgen::InsensitiveStr::Ascii("onoy"),
    ],
    values: &[
        &["taxonomic"],
        &["taxonomy"],
        &["taxonomy"],
        &["taxonomy"],
        &["taxonomy"],
        &["taxonomy"],
    ],
    range: 4..=6,
};

static WORD_TAW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAW_CHILDREN),
    value: None,
};

pub static WORD_TAW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ainese"),
        dictgen::InsensitiveStr::Ascii("ianese"),
        dictgen::InsensitiveStr::Ascii("k"),
    ],
    values: &[&["taiwanese"], &["taiwanese"], &["talk"]],
    range: 1..=6,
};

static WORD_TAV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAV_CHILDREN),
    value: None,
};

pub static WORD_TAV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eled"),
        dictgen::InsensitiveStr::Ascii("eling"),
        dictgen::InsensitiveStr::Ascii("elled"),
        dictgen::InsensitiveStr::Ascii("elling"),
    ],
    values: &[
        &["traveled", "traveled"],
        &["traveling", "traveling"],
        &["travelled", "travelled"],
        &["travelling", "travelling"],
    ],
    range: 4..=6,
};

static WORD_TAT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAT_CHILDREN),
    value: None,
};

pub static WORD_TAT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("h"),
        dictgen::InsensitiveStr::Ascii("oo"),
        dictgen::InsensitiveStr::Ascii("oos"),
        dictgen::InsensitiveStr::Ascii("tooes"),
        dictgen::InsensitiveStr::Ascii("tooos"),
    ],
    values: &[
        &["that"],
        &["tattoo"],
        &["tattoos"],
        &["tattoos"],
        &["tattoos"],
    ],
    range: 1..=5,
};

static WORD_TAS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAS_CHILDREN),
    value: None,
};

pub static WORD_TAS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bar"),
        dictgen::InsensitiveStr::Ascii("kelt"),
        dictgen::InsensitiveStr::Ascii("liman"),
        dictgen::InsensitiveStr::Ascii("t"),
    ],
    values: &[&["taskbar"], &["tasklet"], &["talisman"], &["taste"]],
    range: 1..=5,
};

static WORD_TAR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAR_CHILDREN),
    value: None,
};

pub static WORD_TAR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bal"),
        dictgen::InsensitiveStr::Ascii("bals"),
        dictgen::InsensitiveStr::Ascii("ged"),
        dictgen::InsensitiveStr::Ascii("ger"),
        dictgen::InsensitiveStr::Ascii("getd"),
        dictgen::InsensitiveStr::Ascii("getted"),
        dictgen::InsensitiveStr::Ascii("getting"),
        dictgen::InsensitiveStr::Ascii("gettting"),
        dictgen::InsensitiveStr::Ascii("gt"),
        dictgen::InsensitiveStr::Ascii("gte"),
        dictgen::InsensitiveStr::Ascii("gtets"),
        dictgen::InsensitiveStr::Ascii("migan"),
        dictgen::InsensitiveStr::Ascii("nsparent"),
        dictgen::InsensitiveStr::Ascii("polin"),
        dictgen::InsensitiveStr::Ascii("vis"),
        dictgen::InsensitiveStr::Ascii("visci"),
        dictgen::InsensitiveStr::Ascii("yvon"),
    ],
    values: &[
        &["tarball"],
        &["tarballs"],
        &["target"],
        &["target"],
        &["targeted"],
        &["targeted"],
        &["targeting"],
        &["targeting"],
        &["target"],
        &["target"],
        &["targets"],
        &["ptarmigan"],
        &["transparent"],
        &["tarpaulin"],
        &["travis"],
        &["travisci"],
        &["trayvon"],
    ],
    range: 2..=8,
};

static WORD_TAP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAP_CHILDREN),
    value: None,
};

pub static WORD_TAP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("itude")],
    values: &[&["aptitude"]],
    range: 5..=5,
};

static WORD_TAN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAN_CHILDREN),
    value: None,
};

pub static WORD_TAN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("enhill"),
        dictgen::InsensitiveStr::Ascii("geant"),
        dictgen::InsensitiveStr::Ascii("geantial"),
        dictgen::InsensitiveStr::Ascii("geants"),
        dictgen::InsensitiveStr::Ascii("geld"),
        dictgen::InsensitiveStr::Ascii("gencially"),
        dictgen::InsensitiveStr::Ascii("genitally"),
        dictgen::InsensitiveStr::Ascii("gensial"),
        dictgen::InsensitiveStr::Ascii("gentailly"),
        dictgen::InsensitiveStr::Ascii("gentialy"),
        dictgen::InsensitiveStr::Ascii("get"),
        dictgen::InsensitiveStr::Ascii("getial"),
        dictgen::InsensitiveStr::Ascii("getially"),
        dictgen::InsensitiveStr::Ascii("gets"),
        dictgen::InsensitiveStr::Ascii("gientally"),
        dictgen::InsensitiveStr::Ascii("lged"),
        dictgen::InsensitiveStr::Ascii("nheill"),
        dictgen::InsensitiveStr::Ascii("sact"),
        dictgen::InsensitiveStr::Ascii("saction"),
        dictgen::InsensitiveStr::Ascii("sactional"),
        dictgen::InsensitiveStr::Ascii("sactions"),
        dictgen::InsensitiveStr::Ascii("seint"),
        dictgen::InsensitiveStr::Ascii("sfomed"),
        dictgen::InsensitiveStr::Ascii("sient"),
        dictgen::InsensitiveStr::Ascii("slate"),
        dictgen::InsensitiveStr::Ascii("slated"),
        dictgen::InsensitiveStr::Ascii("slates"),
        dictgen::InsensitiveStr::Ascii("slation"),
        dictgen::InsensitiveStr::Ascii("slations"),
        dictgen::InsensitiveStr::Ascii("slator"),
        dictgen::InsensitiveStr::Ascii("smit"),
        dictgen::InsensitiveStr::Ascii("trumers"),
        dictgen::InsensitiveStr::Ascii("turms"),
    ],
    values: &[
        &["tannehill"],
        &["tangent"],
        &["tangential"],
        &["tangents"],
        &["tangled"],
        &["tangentially"],
        &["tangentially"],
        &["tangential"],
        &["tangentially"],
        &["tangentially"],
        &["tangent"],
        &["tangential"],
        &["tangentially"],
        &["tangents"],
        &["tangentially"],
        &["tangled"],
        &["tannehill"],
        &["transact"],
        &["transaction"],
        &["transactional"],
        &["transactions"],
        &["transient"],
        &["transformed"],
        &["transient"],
        &["translate"],
        &["translated"],
        &["translates"],
        &["translation"],
        &["translations"],
        &["translator"],
        &["transmit"],
        &["tantrums"],
        &["tantrums"],
    ],
    range: 3..=9,
};

static WORD_TAM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAM_CHILDREN),
    value: None,
};

pub static WORD_TAM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("plate"),
        dictgen::InsensitiveStr::Ascii("plated"),
        dictgen::InsensitiveStr::Ascii("plates"),
        dictgen::InsensitiveStr::Ascii("plating"),
    ],
    values: &[
        &["template"],
        &["templated"],
        &["templates"],
        &["templating"],
    ],
    range: 5..=7,
};

static WORD_TAL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAL_CHILDREN),
    value: None,
};

pub static WORD_TAL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("be"),
        dictgen::InsensitiveStr::Ascii("bian"),
        dictgen::InsensitiveStr::Ascii("ekd"),
        dictgen::InsensitiveStr::Ascii("igate"),
        dictgen::InsensitiveStr::Ascii("igating"),
        dictgen::InsensitiveStr::Ascii("iored"),
        dictgen::InsensitiveStr::Ascii("lents"),
        dictgen::InsensitiveStr::Ascii("lerable"),
        dictgen::InsensitiveStr::Ascii("lets"),
        dictgen::InsensitiveStr::Ascii("siman"),
    ],
    values: &[
        &["table"],
        &["taliban"],
        &["talked"],
        &["tailgate"],
        &["tailgating"],
        &["tailored"],
        &["tallest"],
        &["tolerable"],
        &["tallest"],
        &["talisman"],
    ],
    range: 2..=7,
};

static WORD_TAK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAK_CHILDREN),
    value: None,
};

pub static WORD_TAK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("s"),
        dictgen::InsensitiveStr::Ascii("slet"),
    ],
    values: &[&["task", "tasks"], &["tasklet"]],
    range: 1..=4,
};

static WORD_TAI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAI_CHILDREN),
    value: None,
};

pub static WORD_TAI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lban"),
        dictgen::InsensitiveStr::Ascii("lgateing"),
        dictgen::InsensitiveStr::Ascii("lgatting"),
        dictgen::InsensitiveStr::Ascii("lord"),
        dictgen::InsensitiveStr::Ascii("lsman"),
        dictgen::InsensitiveStr::Ascii("wanee"),
        dictgen::InsensitiveStr::Ascii("wanesse"),
    ],
    values: &[
        &["taliban"],
        &["tailgating"],
        &["tailgating"],
        &["tailored"],
        &["talisman"],
        &["taiwanese"],
        &["taiwanese"],
    ],
    range: 4..=8,
};

static WORD_TAH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAH_CHILDREN),
    value: None,
};

pub static WORD_TAH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("n"),
        dictgen::InsensitiveStr::Ascii("nkyou"),
        dictgen::InsensitiveStr::Ascii("t"),
    ],
    values: &[&["than"], &["thankyou"], &["that"]],
    range: 1..=5,
};

static WORD_TAG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAG_CHILDREN),
    value: None,
};

pub static WORD_TAG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("et"),
        dictgen::InsensitiveStr::Ascii("ggen"),
        dictgen::InsensitiveStr::Ascii("liate"),
        dictgen::InsensitiveStr::Ascii("net"),
        dictgen::InsensitiveStr::Ascii("netial"),
        dictgen::InsensitiveStr::Ascii("nets"),
    ],
    values: &[
        &["stage", "take", "tag", "tagged"],
        &["tagged"],
        &["target"],
        &["taggen"],
        &["tailgate"],
        &["tangent"],
        &["tangential"],
        &["tangents"],
    ],
    range: 1..=6,
};

static WORD_TAC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAC_CHILDREN),
    value: None,
};

pub static WORD_TAC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("itcally"),
        dictgen::InsensitiveStr::Ascii("ticallity"),
        dictgen::InsensitiveStr::Ascii("ticaly"),
        dictgen::InsensitiveStr::Ascii("ticas"),
        dictgen::InsensitiveStr::Ascii("ticts"),
        dictgen::InsensitiveStr::Ascii("ticus"),
    ],
    values: &[
        &["tactically"],
        &["tactically"],
        &["tactically"],
        &["tactics"],
        &["tactics"],
        &["tactics"],
    ],
    range: 5..=9,
};

static WORD_TAB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_TAB_CHILDREN),
    value: None,
};

pub static WORD_TAB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("acco"),
        dictgen::InsensitiveStr::Ascii("baray"),
        dictgen::InsensitiveStr::Ascii("blow"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("el"),
        dictgen::InsensitiveStr::Ascii("eles"),
        dictgen::InsensitiveStr::Ascii("els"),
        dictgen::InsensitiveStr::Ascii("elspoon"),
        dictgen::InsensitiveStr::Ascii("elspoons"),
        dictgen::InsensitiveStr::Ascii("eview"),
        dictgen::InsensitiveStr::Ascii("ke"),
        dictgen::InsensitiveStr::Ascii("lepsace"),
        dictgen::InsensitiveStr::Ascii("lepsaces"),
        dictgen::InsensitiveStr::Ascii("lepsoons"),
        dictgen::InsensitiveStr::Ascii("lespon"),
        dictgen::InsensitiveStr::Ascii("lespons"),
        dictgen::InsensitiveStr::Ascii("lespooon"),
        dictgen::InsensitiveStr::Ascii("lespooons"),
        dictgen::InsensitiveStr::Ascii("lesppon"),
        dictgen::InsensitiveStr::Ascii("lesppons"),
        dictgen::InsensitiveStr::Ascii("lle"),
        dictgen::InsensitiveStr::Ascii("luar"),
        dictgen::InsensitiveStr::Ascii("luate"),
        dictgen::InsensitiveStr::Ascii("luated"),
        dictgen::InsensitiveStr::Ascii("luates"),
        dictgen::InsensitiveStr::Ascii("luating"),
        dictgen::InsensitiveStr::Ascii("ualte"),
        dictgen::InsensitiveStr::Ascii("ualted"),
        dictgen::InsensitiveStr::Ascii("ualtes"),
        dictgen::InsensitiveStr::Ascii("ualting"),
        dictgen::InsensitiveStr::Ascii("ualtor"),
        dictgen::InsensitiveStr::Ascii("ualtors"),
    ],
    values: &[
        &["tobacco"],
        &["taboret"],
        &["tableau"],
        &["table"],
        &["table"],
        &["tables"],
        &["tables"],
        &["tablespoon"],
        &["tablespoons"],
        &["tabview"],
        &["table"],
        &["tablespace"],
        &["tablespaces"],
        &["tablespoons"],
        &["tablespoon"],
        &["tablespoons"],
        &["tablespoon"],
        &["tablespoon"],
        &["tablespoon"],
        &["tablespoons"],
        &["table"],
        &["tabular"],
        &["tabulate"],
        &["tabulated"],
        &["tabulates"],
        &["tabulating"],
        &["tabulate"],
        &["tabulated"],
        &["tabulates"],
        &["tabulating"],
        &["tabulator"],
        &["tabulators"],
    ],
    range: 1..=9,
};

static WORD_S_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_S_CHILDREN),
    value: None,
};

static WORD_S_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SA_NODE),
    Some(&WORD_SB_NODE),
    Some(&WORD_SC_NODE),
    None,
    Some(&WORD_SE_NODE),
    Some(&WORD_SF_NODE),
    Some(&WORD_SG_NODE),
    Some(&WORD_SH_NODE),
    Some(&WORD_SI_NODE),
    None,
    Some(&WORD_SK_NODE),
    Some(&WORD_SL_NODE),
    Some(&WORD_SM_NODE),
    Some(&WORD_SN_NODE),
    Some(&WORD_SO_NODE),
    Some(&WORD_SP_NODE),
    Some(&WORD_SQ_NODE),
    Some(&WORD_SR_NODE),
    Some(&WORD_SS_NODE),
    Some(&WORD_ST_NODE),
    Some(&WORD_SU_NODE),
    Some(&WORD_SV_NODE),
    Some(&WORD_SW_NODE),
    Some(&WORD_SX_NODE),
    Some(&WORD_SY_NODE),
    Some(&WORD_SZ_NODE),
];

static WORD_SZ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SZ_CHILDREN),
    value: None,
};

pub static WORD_SZ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("enario"),
        dictgen::InsensitiveStr::Ascii("enarios"),
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("ie"),
        dictgen::InsensitiveStr::Ascii("ied"),
        dictgen::InsensitiveStr::Ascii("ies"),
    ],
    values: &[
        &["scenario"],
        &["scenarios"],
        &["sizes"],
        &["size"],
        &["sized"],
        &["sizes"],
    ],
    range: 2..=7,
};

static WORD_SY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SY_CHILDREN),
    value: None,
};

static WORD_SY_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SYA_NODE),
    Some(&WORD_SYB_NODE),
    Some(&WORD_SYC_NODE),
    Some(&WORD_SYD_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_SYI_NODE),
    None,
    Some(&WORD_SYK_NODE),
    Some(&WORD_SYL_NODE),
    Some(&WORD_SYM_NODE),
    Some(&WORD_SYN_NODE),
    None,
    Some(&WORD_SYP_NODE),
    None,
    Some(&WORD_SYR_NODE),
    Some(&WORD_SYS_NODE),
    Some(&WORD_SYT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_SYT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYT_CHILDREN),
    value: None,
};

pub static WORD_SYT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("em"),
        dictgen::InsensitiveStr::Ascii("ematic"),
        dictgen::InsensitiveStr::Ascii("emd"),
        dictgen::InsensitiveStr::Ascii("eme"),
        dictgen::InsensitiveStr::Ascii("emerror"),
        dictgen::InsensitiveStr::Ascii("emmemory"),
        dictgen::InsensitiveStr::Ascii("ems"),
        dictgen::InsensitiveStr::Ascii("emwindow"),
        dictgen::InsensitiveStr::Ascii("hesis"),
        dictgen::InsensitiveStr::Ascii("le"),
        dictgen::InsensitiveStr::Ascii("led"),
        dictgen::InsensitiveStr::Ascii("les"),
        dictgen::InsensitiveStr::Ascii("lesheet"),
        dictgen::InsensitiveStr::Ascii("ling"),
        dictgen::InsensitiveStr::Ascii("lish"),
        dictgen::InsensitiveStr::Ascii("nax"),
        dictgen::InsensitiveStr::Ascii("ntax"),
        dictgen::InsensitiveStr::Ascii("rofoam"),
    ],
    values: &[
        &["system"],
        &["systematic"],
        &["systemd"],
        &["system"],
        &["systemerror"],
        &["systemmemory"],
        &["systems"],
        &["systemwindow"],
        &["synthesis"],
        &["style"],
        &["styled"],
        &["styles"],
        &["stylesheet"],
        &["styling"],
        &["stylish"],
        &["syntax"],
        &["syntax"],
        &["styrofoam"],
    ],
    range: 2..=8,
};

static WORD_SYS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYS_CHILDREN),
    value: None,
};

pub static WORD_SYS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("admn"),
        dictgen::InsensitiveStr::Ascii("amdin"),
        dictgen::InsensitiveStr::Ascii("bols"),
        dictgen::InsensitiveStr::Ascii("chronize"),
        dictgen::InsensitiveStr::Ascii("damin"),
        dictgen::InsensitiveStr::Ascii("em"),
        dictgen::InsensitiveStr::Ascii("ematic"),
        dictgen::InsensitiveStr::Ascii("ems"),
        dictgen::InsensitiveStr::Ascii("matically"),
        dictgen::InsensitiveStr::Ascii("mbol"),
        dictgen::InsensitiveStr::Ascii("mograph"),
        dictgen::InsensitiveStr::Ascii("tamatic"),
        dictgen::InsensitiveStr::Ascii("tax"),
        dictgen::InsensitiveStr::Ascii("te"),
        dictgen::InsensitiveStr::Ascii("tematicaly"),
        dictgen::InsensitiveStr::Ascii("tematiclly"),
        dictgen::InsensitiveStr::Ascii("tematisch"),
        dictgen::InsensitiveStr::Ascii("temc"),
        dictgen::InsensitiveStr::Ascii("temetic"),
        dictgen::InsensitiveStr::Ascii("temetically"),
        dictgen::InsensitiveStr::Ascii("temisch"),
        dictgen::InsensitiveStr::Ascii("temwindiow"),
        dictgen::InsensitiveStr::Ascii("ten"),
        dictgen::InsensitiveStr::Ascii("tens"),
        dictgen::InsensitiveStr::Ascii("them"),
        dictgen::InsensitiveStr::Ascii("themerror"),
        dictgen::InsensitiveStr::Ascii("themmemory"),
        dictgen::InsensitiveStr::Ascii("thems"),
        dictgen::InsensitiveStr::Ascii("themwindow"),
        dictgen::InsensitiveStr::Ascii("timatic"),
        dictgen::InsensitiveStr::Ascii("timatically"),
        dictgen::InsensitiveStr::Ascii("tm"),
        dictgen::InsensitiveStr::Ascii("tme"),
        dictgen::InsensitiveStr::Ascii("tmes"),
        dictgen::InsensitiveStr::Ascii("tms"),
        dictgen::InsensitiveStr::Ascii("tyem"),
        dictgen::InsensitiveStr::Ascii("tyems"),
        dictgen::InsensitiveStr::Ascii("yem"),
        dictgen::InsensitiveStr::Ascii("yems"),
    ],
    values: &[
        &["sysadmin"],
        &["sysadmin"],
        &["symbols"],
        &["synchronize"],
        &["sysadmin"],
        &["system"],
        &["systematic"],
        &["systems"],
        &["systematically"],
        &["symbol"],
        &["seismograph"],
        &["systematic"],
        &["syntax"],
        &["system"],
        &["systematically"],
        &["systematically"],
        &["systematic"],
        &["systemic"],
        &["systematic"],
        &["systematically"],
        &["systemic"],
        &["systemwindow"],
        &["system"],
        &["systems"],
        &["system"],
        &["systemerror"],
        &["systemmemory"],
        &["systems"],
        &["systemwindow"],
        &["systematic"],
        &["systematically"],
        &["system"],
        &["system"],
        &["systems"],
        &["systems"],
        &["system"],
        &["systems"],
        &["system"],
        &["systems"],
    ],
    range: 2..=11,
};

static WORD_SYR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYR_CHILDREN),
    value: None,
};

pub static WORD_SYR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("acue"),
        dictgen::InsensitiveStr::Ascii("acusae"),
        dictgen::InsensitiveStr::Ascii("ains"),
        dictgen::InsensitiveStr::Ascii("ap"),
        dictgen::InsensitiveStr::Ascii("aucse"),
        dictgen::InsensitiveStr::Ascii("cause"),
        dictgen::InsensitiveStr::Ascii("ingae"),
        dictgen::InsensitiveStr::Ascii("ingue"),
    ],
    values: &[
        &["syracuse"],
        &["syracuse"],
        &["syrians"],
        &["syrup"],
        &["syracuse"],
        &["syracuse"],
        &["syringe"],
        &["syringe"],
    ],
    range: 2..=6,
};

static WORD_SYP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYP_CHILDREN),
    value: None,
};

pub static WORD_SYP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hyllis"),
        dictgen::InsensitiveStr::Ascii("mathetic"),
        dictgen::InsensitiveStr::Ascii("mathize"),
        dictgen::InsensitiveStr::Ascii("mathy"),
        dictgen::InsensitiveStr::Ascii("mtom"),
        dictgen::InsensitiveStr::Ascii("mtoms"),
        dictgen::InsensitiveStr::Ascii("nosis"),
        dictgen::InsensitiveStr::Ascii("port"),
    ],
    values: &[
        &["syphilis"],
        &["sympathetic"],
        &["sympathize"],
        &["sympathy"],
        &["symptom"],
        &["symptoms"],
        &["synopsis"],
        &["support"],
    ],
    range: 4..=8,
};

static WORD_SYN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SYN_CHILDREN),
    value: None,
};

static WORD_SYN_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SYNA_NODE),
    None,
    Some(&WORD_SYNC_NODE),
    Some(&WORD_SYND_NODE),
    Some(&WORD_SYNE_NODE),
    None,
    None,
    None,
    Some(&WORD_SYNI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_SYNO_NODE),
    Some(&WORD_SYNP_NODE),
    None,
    Some(&WORD_SYNR_NODE),
    None,
    Some(&WORD_SYNT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_SYNT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYNT_CHILDREN),
    value: None,
};

pub static WORD_SYNT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ac"),
        dictgen::InsensitiveStr::Ascii("acks"),
        dictgen::InsensitiveStr::Ascii("acs"),
        dictgen::InsensitiveStr::Ascii("act"),
        dictgen::InsensitiveStr::Ascii("actally"),
        dictgen::InsensitiveStr::Ascii("acts"),
        dictgen::InsensitiveStr::Ascii("ak"),
        dictgen::InsensitiveStr::Ascii("aks"),
        dictgen::InsensitiveStr::Ascii("akt"),
        dictgen::InsensitiveStr::Ascii("akts"),
        dictgen::InsensitiveStr::Ascii("atic"),
        dictgen::InsensitiveStr::Ascii("axg"),
        dictgen::InsensitiveStr::Ascii("ehsis"),
        dictgen::InsensitiveStr::Ascii("ehsise"),
        dictgen::InsensitiveStr::Ascii("ehsised"),
        dictgen::InsensitiveStr::Ascii("ehsize"),
        dictgen::InsensitiveStr::Ascii("ehsized"),
        dictgen::InsensitiveStr::Ascii("ehtic"),
        dictgen::InsensitiveStr::Ascii("esis"),
        dictgen::InsensitiveStr::Ascii("ethic"),
        dictgen::InsensitiveStr::Ascii("etic"),
        dictgen::InsensitiveStr::Ascii("etize"),
        dictgen::InsensitiveStr::Ascii("etized"),
        dictgen::InsensitiveStr::Ascii("hesasia"),
        dictgen::InsensitiveStr::Ascii("hesesia"),
        dictgen::InsensitiveStr::Ascii("hethic"),
        dictgen::InsensitiveStr::Ascii("htic"),
    ],
    values: &[
        &["syntax"],
        &["syntax"],
        &["syntax"],
        &["syntax"],
        &["syntactically"],
        &["syntax"],
        &["syntax"],
        &["syntax"],
        &["syntax"],
        &["syntax"],
        &["syntactic"],
        &["syntax"],
        &["synthesis"],
        &["synthesise"],
        &["synthesised"],
        &["synthesize"],
        &["synthesized"],
        &["synthetic"],
        &["synthesis"],
        &["synthetic"],
        &["synthetic"],
        &["synthetize"],
        &["synthetized"],
        &["synthesis"],
        &["synthesis"],
        &["synthetic"],
        &["synthetic"],
    ],
    range: 2..=7,
};

static WORD_SYNR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYNR_CHILDREN),
    value: None,
};

pub static WORD_SYNR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("onous")],
    values: &[&["synchronous"]],
    range: 5..=5,
};

static WORD_SYNP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYNP_CHILDREN),
    value: None,
};

pub static WORD_SYNP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hony"),
        dictgen::InsensitiveStr::Ascii("osis"),
    ],
    values: &[&["symphony"], &["synopsis"]],
    range: 4..=4,
};

static WORD_SYNO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYNO_CHILDREN),
    value: None,
};

pub static WORD_SYNO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("mym"),
        dictgen::InsensitiveStr::Ascii("mymous"),
        dictgen::InsensitiveStr::Ascii("mynous"),
        dictgen::InsensitiveStr::Ascii("myns"),
        dictgen::InsensitiveStr::Ascii("namous"),
        dictgen::InsensitiveStr::Ascii("nim"),
        dictgen::InsensitiveStr::Ascii("nimous"),
        dictgen::InsensitiveStr::Ascii("nmyous"),
        dictgen::InsensitiveStr::Ascii("nmys"),
        dictgen::InsensitiveStr::Ascii("nomous"),
        dictgen::InsensitiveStr::Ascii("nomy"),
        dictgen::InsensitiveStr::Ascii("numous"),
        dictgen::InsensitiveStr::Ascii("nymes"),
        dictgen::InsensitiveStr::Ascii("nymis"),
        dictgen::InsensitiveStr::Ascii("nymns"),
        dictgen::InsensitiveStr::Ascii("nymos"),
        dictgen::InsensitiveStr::Ascii("nymus"),
        dictgen::InsensitiveStr::Ascii("nynous"),
        dictgen::InsensitiveStr::Ascii("psies"),
        dictgen::InsensitiveStr::Ascii("psys"),
        dictgen::InsensitiveStr::Ascii("ym"),
        dictgen::InsensitiveStr::Ascii("ynm"),
        dictgen::InsensitiveStr::Ascii("ynms"),
    ],
    values: &[
        &["synonym"],
        &["synonymous"],
        &["synonymous"],
        &["synonyms"],
        &["synonymous"],
        &["synonym"],
        &["synonymous"],
        &["synonymous"],
        &["synonyms"],
        &["synonymous"],
        &["synonym"],
        &["synonymous"],
        &["synonyms"],
        &["synonyms"],
        &["synonyms"],
        &["synonymous"],
        &["synonyms"],
        &["synonymous"],
        &["synopsis"],
        &["synopsis"],
        &["synonym"],
        &["synonym"],
        &["synonyms"],
    ],
    range: 2..=6,
};

static WORD_SYNI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYNI_CHILDREN),
    value: None,
};

pub static WORD_SYNI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("dcate")],
    values: &[&["syndicate"]],
    range: 5..=5,
};

static WORD_SYNE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYNE_CHILDREN),
    value: None,
};

pub static WORD_SYNE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("gry")],
    values: &[&["synergy"]],
    range: 3..=3,
};

static WORD_SYND_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYND_CHILDREN),
    value: None,
};

pub static WORD_SYND_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("acite"),
        dictgen::InsensitiveStr::Ascii("iacte"),
        dictgen::InsensitiveStr::Ascii("onic"),
    ],
    values: &[&["syndicate"], &["syndicate"], &["syntonic"]],
    range: 4..=5,
};

static WORD_SYNC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYNC_CHILDREN),
    value: None,
};

pub static WORD_SYNC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("honisation"),
        dictgen::InsensitiveStr::Ascii("honise"),
        dictgen::InsensitiveStr::Ascii("honised"),
        dictgen::InsensitiveStr::Ascii("honises"),
        dictgen::InsensitiveStr::Ascii("honising"),
        dictgen::InsensitiveStr::Ascii("honization"),
        dictgen::InsensitiveStr::Ascii("honize"),
        dictgen::InsensitiveStr::Ascii("honized"),
        dictgen::InsensitiveStr::Ascii("honizes"),
        dictgen::InsensitiveStr::Ascii("honizing"),
        dictgen::InsensitiveStr::Ascii("honrous"),
        dictgen::InsensitiveStr::Ascii("hornously"),
        dictgen::InsensitiveStr::Ascii("hrnization"),
        dictgen::InsensitiveStr::Ascii("hrnonization"),
        dictgen::InsensitiveStr::Ascii("hroizing"),
        dictgen::InsensitiveStr::Ascii("hromized"),
        dictgen::InsensitiveStr::Ascii("hroneous"),
        dictgen::InsensitiveStr::Ascii("hroneously"),
        dictgen::InsensitiveStr::Ascii("hronious"),
        dictgen::InsensitiveStr::Ascii("hroniously"),
        dictgen::InsensitiveStr::Ascii("hronizaton"),
        dictgen::InsensitiveStr::Ascii("hronsouly"),
        dictgen::InsensitiveStr::Ascii("hronuous"),
        dictgen::InsensitiveStr::Ascii("hronuously"),
        dictgen::InsensitiveStr::Ascii("hronus"),
        dictgen::InsensitiveStr::Ascii("rhonise"),
        dictgen::InsensitiveStr::Ascii("rhonised"),
        dictgen::InsensitiveStr::Ascii("rhonize"),
        dictgen::InsensitiveStr::Ascii("rhonized"),
        dictgen::InsensitiveStr::Ascii("ronise"),
        dictgen::InsensitiveStr::Ascii("ronised"),
        dictgen::InsensitiveStr::Ascii("ronises"),
        dictgen::InsensitiveStr::Ascii("ronising"),
        dictgen::InsensitiveStr::Ascii("ronization"),
        dictgen::InsensitiveStr::Ascii("ronizations"),
        dictgen::InsensitiveStr::Ascii("ronize"),
        dictgen::InsensitiveStr::Ascii("ronized"),
        dictgen::InsensitiveStr::Ascii("ronizes"),
        dictgen::InsensitiveStr::Ascii("ronizing"),
        dictgen::InsensitiveStr::Ascii("ronous"),
        dictgen::InsensitiveStr::Ascii("ronously"),
        dictgen::InsensitiveStr::Ascii("ronus"),
        dictgen::InsensitiveStr::Ascii("ting"),
    ],
    values: &[
        &["synchronisation"],
        &["synchronise"],
        &["synchronised"],
        &["synchronises"],
        &["synchronising"],
        &["synchronization"],
        &["synchronize"],
        &["synchronized"],
        &["synchronizes"],
        &["synchronizing"],
        &["synchronous"],
        &["synchronously"],
        &["synchronization"],
        &["synchronization"],
        &["synchronizing"],
        &["synchronized"],
        &["synchronous"],
        &["synchronously"],
        &["synchronous"],
        &["synchronously"],
        &["synchronization"],
        &["synchronously"],
        &["synchronous"],
        &["synchronously"],
        &["synchronous"],
        &["synchronise"],
        &["synchronised"],
        &["synchronize"],
        &["synchronized"],
        &["synchronise"],
        &["synchronised"],
        &["synchronises"],
        &["synchronising"],
        &["synchronization"],
        &["synchronizations"],
        &["synchronize"],
        &["synchronized"],
        &["synchronizes"],
        &["synchronizing"],
        &["synchronous"],
        &["synchronously"],
        &["synchronous"],
        &["syncing"],
    ],
    range: 4..=12,
};

static WORD_SYNA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYNA_CHILDREN),
    value: None,
};

pub static WORD_SYNA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gouge"),
        dictgen::InsensitiveStr::Ascii("mic"),
        dictgen::InsensitiveStr::Ascii("x"),
    ],
    values: &[&["synagogue"], &["dynamic"], &["syntax"]],
    range: 1..=5,
};

static WORD_SYM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SYM_CHILDREN),
    value: None,
};

static WORD_SYM_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SYMA_NODE),
    Some(&WORD_SYMB_NODE),
    None,
    None,
    Some(&WORD_SYME_NODE),
    None,
    None,
    Some(&WORD_SYMH_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_SYMM_NODE),
    Some(&WORD_SYMN_NODE),
    Some(&WORD_SYMO_NODE),
    Some(&WORD_SYMP_NODE),
    None,
    None,
    None,
    Some(&WORD_SYMT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_SYMT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYMT_CHILDREN),
    value: None,
};

pub static WORD_SYMT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("pom"),
        dictgen::InsensitiveStr::Ascii("poms"),
    ],
    values: &[&["symptom"], &["symptoms"]],
    range: 3..=4,
};

static WORD_SYMP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYMP_CHILDREN),
    value: None,
};

pub static WORD_SYMP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("athatic"),
        dictgen::InsensitiveStr::Ascii("atheic"),
        dictgen::InsensitiveStr::Ascii("athethic"),
        dictgen::InsensitiveStr::Ascii("athie"),
        dictgen::InsensitiveStr::Ascii("athiek"),
        dictgen::InsensitiveStr::Ascii("athien"),
        dictgen::InsensitiveStr::Ascii("athiers"),
        dictgen::InsensitiveStr::Ascii("athsize"),
        dictgen::InsensitiveStr::Ascii("athsizer"),
        dictgen::InsensitiveStr::Ascii("athtic"),
        dictgen::InsensitiveStr::Ascii("athyze"),
        dictgen::InsensitiveStr::Ascii("athyzers"),
        dictgen::InsensitiveStr::Ascii("aty"),
        dictgen::InsensitiveStr::Ascii("ethetic"),
        dictgen::InsensitiveStr::Ascii("ethize"),
        dictgen::InsensitiveStr::Ascii("ethizers"),
        dictgen::InsensitiveStr::Ascii("hatetic"),
        dictgen::InsensitiveStr::Ascii("hatize"),
        dictgen::InsensitiveStr::Ascii("hatized"),
        dictgen::InsensitiveStr::Ascii("hatizer"),
        dictgen::InsensitiveStr::Ascii("hatizers"),
        dictgen::InsensitiveStr::Ascii("hatizes"),
        dictgen::InsensitiveStr::Ascii("haty"),
        dictgen::InsensitiveStr::Ascii("honey"),
        dictgen::InsensitiveStr::Ascii("honity"),
        dictgen::InsensitiveStr::Ascii("ithizers"),
        dictgen::InsensitiveStr::Ascii("othetic"),
        dictgen::InsensitiveStr::Ascii("othize"),
        dictgen::InsensitiveStr::Ascii("tomes"),
        dictgen::InsensitiveStr::Ascii("tomps"),
        dictgen::InsensitiveStr::Ascii("toom"),
    ],
    values: &[
        &["sympathetic"],
        &["sympathetic"],
        &["sympathetic"],
        &["sympathize"],
        &["sympathize"],
        &["sympathize"],
        &["sympathizers"],
        &["sympathize"],
        &["sympathizers"],
        &["sympathetic"],
        &["sympathize"],
        &["sympathizers"],
        &["sympathy"],
        &["sympathetic"],
        &["sympathize"],
        &["sympathizers"],
        &["sympathetic"],
        &["sympathize"],
        &["sympathize"],
        &["sympathizers"],
        &["sympathizers"],
        &["sympathize"],
        &["sympathy"],
        &["symphony"],
        &["symphony"],
        &["sympathizers"],
        &["sympathetic"],
        &["sympathize"],
        &["symptoms"],
        &["symptoms"],
        &["symptom"],
    ],
    range: 3..=8,
};

static WORD_SYMO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYMO_CHILDREN),
    value: None,
};

pub static WORD_SYMO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bilic"),
        dictgen::InsensitiveStr::Ascii("bl"),
        dictgen::InsensitiveStr::Ascii("blic"),
        dictgen::InsensitiveStr::Ascii("blism"),
        dictgen::InsensitiveStr::Ascii("bls"),
        dictgen::InsensitiveStr::Ascii("l"),
        dictgen::InsensitiveStr::Ascii("ls"),
    ],
    values: &[
        &["symbolic"],
        &["symbol"],
        &["symbolic"],
        &["symbolism"],
        &["symbols"],
        &["symbol"],
        &["symbols"],
    ],
    range: 1..=5,
};

static WORD_SYMN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYMN_CHILDREN),
    value: None,
};

pub static WORD_SYMN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ol"),
        dictgen::InsensitiveStr::Ascii("ols"),
    ],
    values: &[&["symbol"], &["symbols"]],
    range: 2..=3,
};

static WORD_SYMM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYMM_CHILDREN),
    value: None,
};

pub static WORD_SYMM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ertical"),
        dictgen::InsensitiveStr::Ascii("erty"),
        dictgen::InsensitiveStr::Ascii("etic"),
        dictgen::InsensitiveStr::Ascii("etral"),
        dictgen::InsensitiveStr::Ascii("etri"),
        dictgen::InsensitiveStr::Ascii("etria"),
        dictgen::InsensitiveStr::Ascii("etricaly"),
        dictgen::InsensitiveStr::Ascii("ety"),
        dictgen::InsensitiveStr::Ascii("tery"),
    ],
    values: &[
        &["symmetrical"],
        &["symmetry"],
        &["symmetric"],
        &["symmetric"],
        &["symmetry"],
        &["symmetrical"],
        &["symmetrically"],
        &["symmetry"],
        &["symmetry"],
    ],
    range: 3..=8,
};

static WORD_SYMH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYMH_CHILDREN),
    value: None,
};

pub static WORD_SYMH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("pony")],
    values: &[&["symphony"]],
    range: 4..=4,
};

static WORD_SYME_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYME_CHILDREN),
    value: None,
};

pub static WORD_SYME_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("metric"),
        dictgen::InsensitiveStr::Ascii("tri"),
        dictgen::InsensitiveStr::Ascii("tric"),
        dictgen::InsensitiveStr::Ascii("trical"),
        dictgen::InsensitiveStr::Ascii("trically"),
        dictgen::InsensitiveStr::Ascii("try"),
        dictgen::InsensitiveStr::Ascii("ttric"),
    ],
    values: &[
        &["symmetric"],
        &["symmetry"],
        &["symmetric"],
        &["symmetrical"],
        &["symmetrically"],
        &["symmetry"],
        &["symmetric"],
    ],
    range: 3..=8,
};

static WORD_SYMB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYMB_CHILDREN),
    value: None,
};

pub static WORD_SYMB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lic"),
        dictgen::InsensitiveStr::Ascii("o"),
        dictgen::InsensitiveStr::Ascii("oles"),
        dictgen::InsensitiveStr::Ascii("olisch"),
        dictgen::InsensitiveStr::Ascii("olisim"),
        dictgen::InsensitiveStr::Ascii("oll"),
        dictgen::InsensitiveStr::Ascii("olsim"),
        dictgen::InsensitiveStr::Ascii("sol"),
        dictgen::InsensitiveStr::Ascii("sols"),
    ],
    values: &[
        &["symbolic"],
        &["symbol"],
        &["symbols"],
        &["symbolic"],
        &["symbolism"],
        &["symbol"],
        &["symbolism"],
        &["symbol"],
        &["symbols"],
    ],
    range: 1..=6,
};

static WORD_SYMA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYMA_CHILDREN),
    value: None,
};

pub static WORD_SYMA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ntics"),
        dictgen::InsensitiveStr::Ascii("pthetic"),
        dictgen::InsensitiveStr::Ascii("pthize"),
        dictgen::InsensitiveStr::Ascii("pthizers"),
        dictgen::InsensitiveStr::Ascii("pthy"),
    ],
    values: &[
        &["semantics"],
        &["sympathetic"],
        &["sympathize"],
        &["sympathizers"],
        &["sympathy"],
    ],
    range: 4..=8,
};

static WORD_SYL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYL_CHILDREN),
    value: None,
};

pub static WORD_SYL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ablle"),
        dictgen::InsensitiveStr::Ascii("ablles"),
        dictgen::InsensitiveStr::Ascii("abus"),
        dictgen::InsensitiveStr::Ascii("abuses"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("ibol"),
        dictgen::InsensitiveStr::Ascii("inder"),
        dictgen::InsensitiveStr::Ascii("inders"),
        dictgen::InsensitiveStr::Ascii("labe"),
        dictgen::InsensitiveStr::Ascii("label"),
        dictgen::InsensitiveStr::Ascii("labels"),
        dictgen::InsensitiveStr::Ascii("labills"),
        dictgen::InsensitiveStr::Ascii("og"),
    ],
    values: &[
        &["syllable"],
        &["syllables"],
        &["syllabus"],
        &["syllabuses", "syllabi"],
        &["style"],
        &["styles"],
        &["syllable"],
        &["cylinder"],
        &["cylinders"],
        &["syllable"],
        &["syllable"],
        &["syllables"],
        &["syllabus", "syllabification"],
        &["syslog"],
    ],
    range: 1..=7,
};

static WORD_SYK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYK_CHILDREN),
    value: None,
};

pub static WORD_SYK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("walker"),
        dictgen::InsensitiveStr::Ascii("ward"),
    ],
    values: &[&["skywalker"], &["skyward"]],
    range: 4..=6,
};

static WORD_SYI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYI_CHILDREN),
    value: None,
};

pub static WORD_SYI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("rans")],
    values: &[&["syrians"]],
    range: 4..=4,
};

static WORD_SYD_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYD_CHILDREN),
    value: None,
};

pub static WORD_SYD_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("nicate"),
        dictgen::InsensitiveStr::Ascii("nrome"),
    ],
    values: &[&["syndicate"], &["syndrome"]],
    range: 5..=6,
};

static WORD_SYC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYC_CHILDREN),
    value: None,
};

pub static WORD_SYC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hronisation"),
        dictgen::InsensitiveStr::Ascii("hronise"),
        dictgen::InsensitiveStr::Ascii("hronised"),
        dictgen::InsensitiveStr::Ascii("hroniser"),
        dictgen::InsensitiveStr::Ascii("hronises"),
        dictgen::InsensitiveStr::Ascii("hronisly"),
        dictgen::InsensitiveStr::Ascii("hronization"),
        dictgen::InsensitiveStr::Ascii("hronize"),
        dictgen::InsensitiveStr::Ascii("hronized"),
        dictgen::InsensitiveStr::Ascii("hronizer"),
        dictgen::InsensitiveStr::Ascii("hronizes"),
        dictgen::InsensitiveStr::Ascii("hronmode"),
        dictgen::InsensitiveStr::Ascii("hronous"),
        dictgen::InsensitiveStr::Ascii("hronously"),
        dictgen::InsensitiveStr::Ascii("le"),
        dictgen::InsensitiveStr::Ascii("led"),
        dictgen::InsensitiveStr::Ascii("les"),
        dictgen::InsensitiveStr::Ascii("lic"),
        dictgen::InsensitiveStr::Ascii("lical"),
        dictgen::InsensitiveStr::Ascii("ling"),
        dictgen::InsensitiveStr::Ascii("n"),
        dictgen::InsensitiveStr::Ascii("ning"),
        dictgen::InsensitiveStr::Ascii("ology"),
        dictgen::InsensitiveStr::Ascii("ronise"),
        dictgen::InsensitiveStr::Ascii("ronised"),
        dictgen::InsensitiveStr::Ascii("ronises"),
        dictgen::InsensitiveStr::Ascii("ronising"),
        dictgen::InsensitiveStr::Ascii("ronization"),
        dictgen::InsensitiveStr::Ascii("ronizations"),
        dictgen::InsensitiveStr::Ascii("ronize"),
        dictgen::InsensitiveStr::Ascii("ronized"),
        dictgen::InsensitiveStr::Ascii("ronizes"),
        dictgen::InsensitiveStr::Ascii("ronizing"),
        dictgen::InsensitiveStr::Ascii("ronous"),
        dictgen::InsensitiveStr::Ascii("ronously"),
        dictgen::InsensitiveStr::Ascii("ronus"),
        dictgen::InsensitiveStr::Ascii("ther"),
    ],
    values: &[
        &["synchronisation"],
        &["synchronise"],
        &["synchronised"],
        &["synchroniser"],
        &["synchronises"],
        &["synchronously"],
        &["synchronization"],
        &["synchronize"],
        &["synchronized"],
        &["synchronizer"],
        &["synchronizes"],
        &["synchronmode"],
        &["synchronous"],
        &["synchronously"],
        &["cycle"],
        &["cycled"],
        &["cycles"],
        &["cyclic", "psychic"],
        &["cyclical", "physical"],
        &["cycling"],
        &["sync"],
        &["syncing"],
        &["psychology"],
        &["synchronise"],
        &["synchronised"],
        &["synchronises"],
        &["synchronising"],
        &["synchronization"],
        &["synchronizations"],
        &["synchronize"],
        &["synchronized"],
        &["synchronizes"],
        &["synchronizing"],
        &["synchronous"],
        &["synchronously"],
        &["synchronous"],
        &["scyther"],
    ],
    range: 1..=11,
};

static WORD_SYB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYB_CHILDREN),
    value: None,
};

pub static WORD_SYB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("system"),
        dictgen::InsensitiveStr::Ascii("systems"),
    ],
    values: &[&["subsystem"], &["subsystems"]],
    range: 6..=7,
};

static WORD_SYA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SYA_CHILDREN),
    value: None,
};

pub static WORD_SYA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ntax"),
        dictgen::InsensitiveStr::Ascii("rcuse"),
        dictgen::InsensitiveStr::Ascii("s"),
        dictgen::InsensitiveStr::Ascii("tem"),
        dictgen::InsensitiveStr::Ascii("tems"),
    ],
    values: &[
        &["syntax"],
        &["syracuse"],
        &["says"],
        &["system"],
        &["systems"],
    ],
    range: 1..=5,
};

static WORD_SX_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SX_CHILDREN),
    value: None,
};

pub static WORD_SX_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("l")],
    values: &[&["xsl"]],
    range: 1..=1,
};

static WORD_SW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SW_CHILDREN),
    value: None,
};

static WORD_SW_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SWA_NODE),
    None,
    Some(&WORD_SWC_NODE),
    None,
    Some(&WORD_SWE_NODE),
    None,
    None,
    None,
    Some(&WORD_SWI_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_SWN_NODE),
    Some(&WORD_SWO_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_SWT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_SWT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SWT_CHILDREN),
    value: None,
};

pub static WORD_SWT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ich"),
        dictgen::InsensitiveStr::Ascii("iched"),
        dictgen::InsensitiveStr::Ascii("iches"),
        dictgen::InsensitiveStr::Ascii("iching"),
        dictgen::InsensitiveStr::Ascii("ichs"),
        dictgen::InsensitiveStr::Ascii("izerland"),
    ],
    values: &[
        &["switch"],
        &["switched"],
        &["switches"],
        &["switching"],
        &["switches"],
        &["switzerland"],
    ],
    range: 3..=8,
};

static WORD_SWO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SWO_CHILDREN),
    value: None,
};

pub static WORD_SWO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("wn")],
    values: &[&["shown"]],
    range: 2..=2,
};

static WORD_SWN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SWN_CHILDREN),
    value: None,
};

pub static WORD_SWN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("asea")],
    values: &[&["swansea"]],
    range: 4..=4,
};

static WORD_SWI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SWI_CHILDREN),
    value: None,
};

pub static WORD_SWI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ch"),
        dictgen::InsensitiveStr::Ascii("ched"),
        dictgen::InsensitiveStr::Ascii("ching"),
        dictgen::InsensitiveStr::Ascii("cth"),
        dictgen::InsensitiveStr::Ascii("cthed"),
        dictgen::InsensitiveStr::Ascii("cthing"),
        dictgen::InsensitiveStr::Ascii("flty"),
        dictgen::InsensitiveStr::Ascii("ftley"),
        dictgen::InsensitiveStr::Ascii("ming"),
        dictgen::InsensitiveStr::Ascii("tcheasy"),
        dictgen::InsensitiveStr::Ascii("tchign"),
        dictgen::InsensitiveStr::Ascii("tchs"),
        dictgen::InsensitiveStr::Ascii("tchting"),
        dictgen::InsensitiveStr::Ascii("terzland"),
        dictgen::InsensitiveStr::Ascii("tfly"),
        dictgen::InsensitiveStr::Ascii("th"),
        dictgen::InsensitiveStr::Ascii("thable"),
        dictgen::InsensitiveStr::Ascii("thc"),
        dictgen::InsensitiveStr::Ascii("thcboard"),
        dictgen::InsensitiveStr::Ascii("thced"),
        dictgen::InsensitiveStr::Ascii("thces"),
        dictgen::InsensitiveStr::Ascii("thch"),
        dictgen::InsensitiveStr::Ascii("thches"),
        dictgen::InsensitiveStr::Ascii("thching"),
        dictgen::InsensitiveStr::Ascii("thcing"),
        dictgen::InsensitiveStr::Ascii("thcover"),
        dictgen::InsensitiveStr::Ascii("thed"),
        dictgen::InsensitiveStr::Ascii("thing"),
        dictgen::InsensitiveStr::Ascii("tiches"),
        dictgen::InsensitiveStr::Ascii("tserland"),
        dictgen::InsensitiveStr::Ascii("tzerand"),
        dictgen::InsensitiveStr::Ascii("tzlerand"),
        dictgen::InsensitiveStr::Ascii("zterland"),
    ],
    values: &[
        &["switch"],
        &["switched"],
        &["switching"],
        &["switch"],
        &["switched"],
        &["switching"],
        &["swiftly"],
        &["swiftly"],
        &["swimming"],
        &["switches"],
        &["switching"],
        &["switches"],
        &["switching"],
        &["switzerland"],
        &["swiftly"],
        &["switch"],
        &["switchable"],
        &["switch"],
        &["switchboard"],
        &["switched"],
        &["switches"],
        &["switch"],
        &["switches"],
        &["switching"],
        &["switching"],
        &["switchover"],
        &["switched"],
        &["switching"],
        &["switches"],
        &["switzerland"],
        &["switzerland"],
        &["switzerland"],
        &["switzerland"],
    ],
    range: 2..=8,
};

static WORD_SWE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SWE_CHILDREN),
    value: None,
};

pub static WORD_SWE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arengin"),
        dictgen::InsensitiveStr::Ascii("arshirt"),
        dictgen::InsensitiveStr::Ascii("athsirt"),
        dictgen::InsensitiveStr::Ascii("atshit"),
        dictgen::InsensitiveStr::Ascii("atshits"),
        dictgen::InsensitiveStr::Ascii("atshort"),
        dictgen::InsensitiveStr::Ascii("atshrit"),
        dictgen::InsensitiveStr::Ascii("disch"),
        dictgen::InsensitiveStr::Ascii("erheart"),
        dictgen::InsensitiveStr::Ascii("etheat"),
        dictgen::InsensitiveStr::Ascii("etshart"),
        dictgen::InsensitiveStr::Ascii("idsh"),
        dictgen::InsensitiveStr::Ascii("pth"),
    ],
    values: &[
        &["swearing"],
        &["sweatshirt"],
        &["sweatshirt"],
        &["sweatshirt"],
        &["sweatshirt"],
        &["sweatshirt"],
        &["sweatshirt"],
        &["swedish"],
        &["sweetheart"],
        &["sweetheart"],
        &["sweetheart"],
        &["swedish"],
        &["swept"],
    ],
    range: 3..=7,
};

static WORD_SWC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SWC_CHILDREN),
    value: None,
};

pub static WORD_SWC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("loumns")],
    values: &[&["swcolumns"]],
    range: 6..=6,
};

static WORD_SWA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SWA_CHILDREN),
    value: None,
};

pub static WORD_SWA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("ering"),
        dictgen::InsensitiveStr::Ascii("ers"),
        dictgen::InsensitiveStr::Ascii("etshirt"),
        dictgen::InsensitiveStr::Ascii("lloed"),
        dictgen::InsensitiveStr::Ascii("nsoon"),
        dictgen::InsensitiveStr::Ascii("ped"),
        dictgen::InsensitiveStr::Ascii("piness"),
        dictgen::InsensitiveStr::Ascii("ping"),
        dictgen::InsensitiveStr::Ascii("rmin"),
        dictgen::InsensitiveStr::Ascii("sitka"),
        dictgen::InsensitiveStr::Ascii("skita"),
        dictgen::InsensitiveStr::Ascii("stikka"),
        dictgen::InsensitiveStr::Ascii("tiska"),
        dictgen::InsensitiveStr::Ascii("tsika"),
    ],
    values: &[
        &["swear"],
        &["swearing"],
        &["swears"],
        &["sweatshirt"],
        &["swallowed"],
        &["swanson"],
        &["swapped"],
        &["swappiness"],
        &["swapping"],
        &["swarming"],
        &["swastika"],
        &["swastika"],
        &["swastika"],
        &["swastika"],
        &["swastika"],
    ],
    range: 2..=7,
};

static WORD_SV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SV_CHILDREN),
    value: None,
};

pub static WORD_SV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ae"),
        dictgen::InsensitiveStr::Ascii("elt"),
    ],
    values: &[&["save", "suave"], &["svelte"]],
    range: 2..=3,
};

static WORD_SU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SU_CHILDREN),
    value: None,
};

static WORD_SU_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SUA_NODE),
    Some(&WORD_SUB_NODE),
    Some(&WORD_SUC_NODE),
    Some(&WORD_SUD_NODE),
    Some(&WORD_SUE_NODE),
    Some(&WORD_SUF_NODE),
    Some(&WORD_SUG_NODE),
    Some(&WORD_SUH_NODE),
    Some(&WORD_SUI_NODE),
    None,
    None,
    None,
    Some(&WORD_SUM_NODE),
    Some(&WORD_SUN_NODE),
    Some(&WORD_SUO_NODE),
    Some(&WORD_SUP_NODE),
    None,
    Some(&WORD_SUR_NODE),
    Some(&WORD_SUS_NODE),
    Some(&WORD_SUT_NODE),
    Some(&WORD_SUU_NODE),
    Some(&WORD_SUV_NODE),
    None,
    None,
    None,
    None,
];

static WORD_SUV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUV_CHILDREN),
    value: None,
};

pub static WORD_SUV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("enear")],
    values: &[&["souvenir"]],
    range: 5..=5,
};

static WORD_SUU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUU_CHILDREN),
    value: None,
};

pub static WORD_SUU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("port"),
        dictgen::InsensitiveStr::Ascii("ported"),
        dictgen::InsensitiveStr::Ascii("porting"),
        dictgen::InsensitiveStr::Ascii("ports"),
    ],
    values: &[&["support"], &["supported"], &["supporting"], &["supports"]],
    range: 4..=7,
};

static WORD_SUT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUT_CHILDREN),
    value: None,
};

pub static WORD_SUT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("able"),
        dictgen::InsensitiveStr::Ascii("down"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("isfaction"),
        dictgen::InsensitiveStr::Ascii("isfied"),
        dictgen::InsensitiveStr::Ascii("isfies"),
        dictgen::InsensitiveStr::Ascii("isfy"),
        dictgen::InsensitiveStr::Ascii("isfying"),
        dictgen::InsensitiveStr::Ascii("tle"),
        dictgen::InsensitiveStr::Ascii("tled"),
        dictgen::InsensitiveStr::Ascii("tles"),
        dictgen::InsensitiveStr::Ascii("tlety"),
        dictgen::InsensitiveStr::Ascii("tling"),
    ],
    values: &[
        &["suitable", "stable"],
        &["shutdown"],
        &["site", "suite", "suit"],
        &["satisfaction"],
        &["satisfied"],
        &["satisfies"],
        &["satisfy"],
        &["satisfying"],
        &["subtle", "shuttle"],
        &["shuttled"],
        &["shuttles"],
        &["subtlety"],
        &["shuttling"],
    ],
    range: 1..=9,
};

static WORD_SUS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SUS_CHILDREN),
    value: None,
};

static WORD_SUS_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    Some(&WORD_SUSB_NODE),
    Some(&WORD_SUSC_NODE),
    None,
    Some(&WORD_SUSE_NODE),
    None,
    None,
    None,
    Some(&WORD_SUSI_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_SUSN_NODE),
    None,
    Some(&WORD_SUSP_NODE),
    None,
    None,
    Some(&WORD_SUSS_NODE),
    Some(&WORD_SUST_NODE),
    Some(&WORD_SUSU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static WORD_SUSU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUSU_CHILDREN),
    value: None,
};

pub static WORD_SUSU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("pend")],
    values: &[&["suspend"]],
    range: 4..=4,
};

static WORD_SUST_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUST_CHILDREN),
    value: None,
};

pub static WORD_SUST_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ainabillity"),
        dictgen::InsensitiveStr::Ascii("ainabiltiy"),
        dictgen::InsensitiveStr::Ascii("ainabilty"),
        dictgen::InsensitiveStr::Ascii("ainabily"),
        dictgen::InsensitiveStr::Ascii("ainble"),
        dictgen::InsensitiveStr::Ascii("ainible"),
        dictgen::InsensitiveStr::Ascii("em"),
        dictgen::InsensitiveStr::Ascii("ems"),
        dictgen::InsensitiveStr::Ascii("itution"),
        dictgen::InsensitiveStr::Ascii("itutions"),
    ],
    values: &[
        &["sustainability"],
        &["sustainability"],
        &["sustainability"],
        &["sustainability"],
        &["sustainable"],
        &["sustainable"],
        &["system"],
        &["systems"],
        &["substitution"],
        &["substitutions"],
    ],
    range: 2..=11,
};

static WORD_SUSS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUSS_CHILDREN),
    value: None,
};

pub static WORD_SUSS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("inct")],
    values: &[&["succinct"]],
    range: 4..=4,
};

static WORD_SUSP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUSP_CHILDREN),
    value: None,
};

pub static WORD_SUSP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ecions"),
        dictgen::InsensitiveStr::Ascii("ecious"),
        dictgen::InsensitiveStr::Ascii("eciously"),
        dictgen::InsensitiveStr::Ascii("ectes"),
        dictgen::InsensitiveStr::Ascii("ectible"),
        dictgen::InsensitiveStr::Ascii("edn"),
        dictgen::InsensitiveStr::Ascii("encion"),
        dictgen::InsensitiveStr::Ascii("endeds"),
        dictgen::InsensitiveStr::Ascii("endes"),
        dictgen::InsensitiveStr::Ascii("ened"),
        dictgen::InsensitiveStr::Ascii("eneded"),
        dictgen::InsensitiveStr::Ascii("ensie"),
        dictgen::InsensitiveStr::Ascii("enso"),
        dictgen::InsensitiveStr::Ascii("ention"),
        dictgen::InsensitiveStr::Ascii("icians"),
        dictgen::InsensitiveStr::Ascii("iciois"),
        dictgen::InsensitiveStr::Ascii("icios"),
        dictgen::InsensitiveStr::Ascii("iciosly"),
        dictgen::InsensitiveStr::Ascii("icioso"),
        dictgen::InsensitiveStr::Ascii("icioulsy"),
        dictgen::InsensitiveStr::Ascii("iciouly"),
        dictgen::InsensitiveStr::Ascii("icioun"),
        dictgen::InsensitiveStr::Ascii("iciouns"),
        dictgen::InsensitiveStr::Ascii("icision"),
        dictgen::InsensitiveStr::Ascii("icison"),
        dictgen::InsensitiveStr::Ascii("icisons"),
        dictgen::InsensitiveStr::Ascii("iciuos"),
        dictgen::InsensitiveStr::Ascii("iciuosly"),
        dictgen::InsensitiveStr::Ascii("icous"),
        dictgen::InsensitiveStr::Ascii("icously"),
        dictgen::InsensitiveStr::Ascii("icsion"),
        dictgen::InsensitiveStr::Ascii("ision"),
        dictgen::InsensitiveStr::Ascii("isions"),
        dictgen::InsensitiveStr::Ascii("isious"),
        dictgen::InsensitiveStr::Ascii("isiously"),
        dictgen::InsensitiveStr::Ascii("itions"),
        dictgen::InsensitiveStr::Ascii("send"),
    ],
    values: &[
        &["suspicions"],
        &["suspicious"],
        &["suspiciously"],
        &["suspects"],
        &["susceptible"],
        &["suspend"],
        &["suspension"],
        &["suspense"],
        &["suspense"],
        &["suspend"],
        &["suspended"],
        &["suspense"],
        &["suspension"],
        &["suspension"],
        &["suspicions"],
        &["suspicions"],
        &["suspicious"],
        &["suspiciously"],
        &["suspicions"],
        &["suspiciously"],
        &["suspiciously"],
        &["suspicion"],
        &["suspicion"],
        &["suspicions"],
        &["suspicions"],
        &["suspicions"],
        &["suspicions"],
        &["suspiciously"],
        &["suspicious"],
        &["suspiciously"],
        &["suspicions"],
        &["suspicion"],
        &["suspicions"],
        &["suspicious"],
        &["suspiciously"],
        &["suspicions"],
        &["suspend"],
    ],
    range: 3..=8,
};

static WORD_SUSN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUSN_CHILDREN),
    value: None,
};

pub static WORD_SUSN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("creen")],
    values: &[&["sunscreen"]],
    range: 5..=5,
};

static WORD_SUSI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUSI_CHILDREN),
    value: None,
};

pub static WORD_SUSI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("nctly"),
        dictgen::InsensitiveStr::Ascii("nkt"),
    ],
    values: &[&["succinctly"], &["succinct"]],
    range: 3..=5,
};

static WORD_SUSE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUSE_CHILDREN),
    value: None,
};

pub static WORD_SUSE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cptible"),
        dictgen::InsensitiveStr::Ascii("pect"),
        dictgen::InsensitiveStr::Ascii("ptable"),
        dictgen::InsensitiveStr::Ascii("ptible"),
    ],
    values: &[
        &["susceptible"],
        &["suspect"],
        &["susceptible"],
        &["susceptible"],
    ],
    range: 4..=7,
};

static WORD_SUSC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUSC_CHILDREN),
    value: None,
};

pub static WORD_SUSC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("epitble"),
        dictgen::InsensitiveStr::Ascii("eptable"),
        dictgen::InsensitiveStr::Ascii("eptiable"),
        dictgen::InsensitiveStr::Ascii("eptibile"),
        dictgen::InsensitiveStr::Ascii("petible"),
        dictgen::InsensitiveStr::Ascii("ribe"),
        dictgen::InsensitiveStr::Ascii("ribed"),
        dictgen::InsensitiveStr::Ascii("ribes"),
        dictgen::InsensitiveStr::Ascii("ript"),
    ],
    values: &[
        &["susceptible"],
        &["susceptible"],
        &["susceptible"],
        &["susceptible"],
        &["susceptible"],
        &["subscribe"],
        &["subscribed"],
        &["subscribes"],
        &["subscript"],
    ],
    range: 4..=8,
};

static WORD_SUSB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUSB_CHILDREN),
    value: None,
};

pub static WORD_SUSB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cribe"),
        dictgen::InsensitiveStr::Ascii("system"),
        dictgen::InsensitiveStr::Ascii("systems"),
        dictgen::InsensitiveStr::Ascii("sytem"),
        dictgen::InsensitiveStr::Ascii("sytems"),
        dictgen::InsensitiveStr::Ascii("tantial"),
        dictgen::InsensitiveStr::Ascii("tantially"),
        dictgen::InsensitiveStr::Ascii("tantive"),
        dictgen::InsensitiveStr::Ascii("trate"),
    ],
    values: &[
        &["subscribe"],
        &["subsystem"],
        &["subsystems"],
        &["subsystem"],
        &["subsystems"],
        &["substantial"],
        &["substantially"],
        &["substantive"],
        &["substrate"],
    ],
    range: 5..=9,
};

static WORD_SUR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SUR_CHILDREN),
    value: None,
};

static WORD_SUR_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    Some(&WORD_SURB_NODE),
    None,
    None,
    None,
    Some(&WORD_SURF_NODE),
    Some(&WORD_SURG_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_SURL_NODE),
    None,
    None,
    Some(&WORD_SURO_NODE),
    Some(&WORD_SURP_NODE),
    None,
    Some(&WORD_SURR_NODE),
    None,
    None,
    None,
    Some(&WORD_SURV_NODE),
    None,
    None,
    None,
    None,
];

static WORD_SURV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SURV_CHILDREN),
    value: None,
};

pub static WORD_SURV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aillance"),
        dictgen::InsensitiveStr::Ascii("aillence"),
        dictgen::InsensitiveStr::Ascii("allience"),
        dictgen::InsensitiveStr::Ascii("avibility"),
        dictgen::InsensitiveStr::Ascii("ay"),
        dictgen::InsensitiveStr::Ascii("ays"),
        dictgen::InsensitiveStr::Ascii("eilence"),
        dictgen::InsensitiveStr::Ascii("eill"),
        dictgen::InsensitiveStr::Ascii("eillence"),
        dictgen::InsensitiveStr::Ascii("elliance"),
        dictgen::InsensitiveStr::Ascii("eyer"),
        dictgen::InsensitiveStr::Ascii("ibability"),
        dictgen::InsensitiveStr::Ascii("ice"),
        dictgen::InsensitiveStr::Ascii("ices"),
        dictgen::InsensitiveStr::Ascii("iellance"),
        dictgen::InsensitiveStr::Ascii("ivabiity"),
        dictgen::InsensitiveStr::Ascii("ivabililty"),
        dictgen::InsensitiveStr::Ascii("ivabiliy"),
        dictgen::InsensitiveStr::Ascii("ivabillity"),
        dictgen::InsensitiveStr::Ascii("ivabiltiy"),
        dictgen::InsensitiveStr::Ascii("ivabilty"),
        dictgen::InsensitiveStr::Ascii("ivabily"),
        dictgen::InsensitiveStr::Ascii("ivalibity"),
        dictgen::InsensitiveStr::Ascii("ivavility"),
        dictgen::InsensitiveStr::Ascii("ivebility"),
        dictgen::InsensitiveStr::Ascii("iver"),
        dictgen::InsensitiveStr::Ascii("ivers"),
        dictgen::InsensitiveStr::Ascii("ivied"),
        dictgen::InsensitiveStr::Ascii("ivour"),
        dictgen::InsensitiveStr::Ascii("ivours"),
    ],
    values: &[
        &["surveillance"],
        &["surveillance"],
        &["surveillance"],
        &["survivability"],
        &["survey"],
        &["surveys"],
        &["surveillance"],
        &["surveil"],
        &["surveillance"],
        &["surveillance"],
        &["surveyor"],
        &["survivability"],
        &["service", "survive"],
        &["services", "survives"],
        &["surveillance"],
        &["survivability"],
        &["survivability"],
        &["survivability"],
        &["survivability"],
        &["survivability"],
        &["survivability"],
        &["survivability"],
        &["survivability"],
        &["survivability"],
        &["survivability"],
        &["survivor"],
        &["survivors"],
        &["survived"],
        &["survivor"],
        &["survivor"],
    ],
    range: 2..=10,
};

static WORD_SURR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SURR_CHILDREN),
    value: None,
};

pub static WORD_SURR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("egat"),
        dictgen::InsensitiveStr::Ascii("ended"),
        dictgen::InsensitiveStr::Ascii("enderd"),
        dictgen::InsensitiveStr::Ascii("enderred"),
        dictgen::InsensitiveStr::Ascii("epetitious"),
        dictgen::InsensitiveStr::Ascii("epetitiously"),
        dictgen::InsensitiveStr::Ascii("eptious"),
        dictgen::InsensitiveStr::Ascii("eptiously"),
        dictgen::InsensitiveStr::Ascii("ogage"),
        dictgen::InsensitiveStr::Ascii("onded"),
        dictgen::InsensitiveStr::Ascii("oud"),
        dictgen::InsensitiveStr::Ascii("ouded"),
        dictgen::InsensitiveStr::Ascii("ouding"),
        dictgen::InsensitiveStr::Ascii("oundes"),
        dictgen::InsensitiveStr::Ascii("oundig"),
        dictgen::InsensitiveStr::Ascii("oundign"),
        dictgen::InsensitiveStr::Ascii("oundigs"),
        dictgen::InsensitiveStr::Ascii("oundins"),
        dictgen::InsensitiveStr::Ascii("oundngs"),
        dictgen::InsensitiveStr::Ascii("ouned"),
        dictgen::InsensitiveStr::Ascii("ouns"),
        dictgen::InsensitiveStr::Ascii("rounded"),
        dictgen::InsensitiveStr::Ascii("undering"),
    ],
    values: &[
        &["surrogate"],
        &["surrounded", "surrendered"],
        &["surrendered"],
        &["surrendered"],
        &["surreptitious"],
        &["surreptitiously"],
        &["surreptitious"],
        &["surreptitiously"],
        &["surrogate"],
        &["surrounded"],
        &["surround"],
        &["surrounded"],
        &["surrounding"],
        &["surrounds"],
        &["surroundings"],
        &["surroundings"],
        &["surrounds"],
        &["surrounds"],
        &["surrounds"],
        &["surround", "surrounded"],
        &["surrounds"],
        &["surrounded"],
        &["surrendering"],
    ],
    range: 3..=12,
};

static WORD_SURP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SURP_CHILDREN),
    value: None,
};

pub static WORD_SURP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ases"),
        dictgen::InsensitiveStr::Ascii("emacist"),
        dictgen::InsensitiveStr::Ascii("eme"),
        dictgen::InsensitiveStr::Ascii("ise"),
        dictgen::InsensitiveStr::Ascii("ises"),
        dictgen::InsensitiveStr::Ascii("lanted"),
        dictgen::InsensitiveStr::Ascii("ort"),
        dictgen::InsensitiveStr::Ascii("orted"),
        dictgen::InsensitiveStr::Ascii("ress"),
        dictgen::InsensitiveStr::Ascii("ressed"),
        dictgen::InsensitiveStr::Ascii("resses"),
        dictgen::InsensitiveStr::Ascii("ressing"),
        dictgen::InsensitiveStr::Ascii("risinlgy"),
        dictgen::InsensitiveStr::Ascii("risinly"),
        dictgen::InsensitiveStr::Ascii("rize"),
        dictgen::InsensitiveStr::Ascii("rized"),
        dictgen::InsensitiveStr::Ascii("rizing"),
        dictgen::InsensitiveStr::Ascii("rizingly"),
    ],
    values: &[
        &["surpass"],
        &["supremacist"],
        &["supreme"],
        &["surprise"],
        &["surprises"],
        &["supplanted"],
        &["support"],
        &["supported"],
        &["suppress"],
        &["suppressed"],
        &["suppresses"],
        &["suppressing"],
        &["surprisingly"],
        &["surprisingly"],
        &["surprise"],
        &["surprised"],
        &["surprising"],
        &["surprisingly"],
    ],
    range: 3..=8,
};

static WORD_SURO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SURO_CHILDREN),
    value: None,
};

pub static WORD_SURO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("und"),
        dictgen::InsensitiveStr::Ascii("unded"),
        dictgen::InsensitiveStr::Ascii("unding"),
        dictgen::InsensitiveStr::Ascii("undings"),
        dictgen::InsensitiveStr::Ascii("unds"),
    ],
    values: &[
        &["surround"],
        &["surrounded"],
        &["surrounding"],
        &["surroundings"],
        &["surrounds"],
    ],
    range: 3..=7,
};

static WORD_SURL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SURL_CHILDREN),
    value: None,
};

pub static WORD_SURL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ey")],
    values: &[&["surly", "surely"]],
    range: 2..=2,
};

static WORD_SURG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SURG_CHILDREN),
    value: None,
};

pub static WORD_SURG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("est"),
        dictgen::InsensitiveStr::Ascii("ested"),
        dictgen::InsensitiveStr::Ascii("estion"),
        dictgen::InsensitiveStr::Ascii("estions"),
        dictgen::InsensitiveStr::Ascii("ests"),
    ],
    values: &[
        &["suggest"],
        &["suggested"],
        &["suggestion"],
        &["suggestions"],
        &["suggests"],
    ],
    range: 3..=7,
};

static WORD_SURF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SURF_CHILDREN),
    value: None,
};

pub static WORD_SURF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ce")],
    values: &[&["surface"]],
    range: 2..=2,
};

static WORD_SURB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SURB_CHILDREN),
    value: None,
};

pub static WORD_SURB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ert"),
        dictgen::InsensitiveStr::Ascii("uban"),
    ],
    values: &[&["sherbert"], &["suburban"]],
    range: 3..=4,
};

static WORD_SUP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SUP_CHILDREN),
    value: None,
};

static WORD_SUP_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    None,
    None,
    None,
    Some(&WORD_SUPE_NODE),
    None,
    None,
    Some(&WORD_SUPH_NODE),
    Some(&WORD_SUPI_NODE),
    None,
    None,
    Some(&WORD_SUPL_NODE),
    None,
    None,
    Some(&WORD_SUPO_NODE),
    Some(&WORD_SUPP_NODE),
    None,
    Some(&WORD_SUPR_NODE),
    Some(&WORD_SUPS_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_SUPS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPS_CHILDREN),
    value: None,
};

pub static WORD_SUPS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cription"),
        dictgen::InsensitiveStr::Ascii("criptions"),
        dictgen::InsensitiveStr::Ascii("ects"),
        dictgen::InsensitiveStr::Ascii("end"),
        dictgen::InsensitiveStr::Ascii("ense"),
        dictgen::InsensitiveStr::Ascii("ension"),
        dictgen::InsensitiveStr::Ascii("icion"),
        dictgen::InsensitiveStr::Ascii("icions"),
        dictgen::InsensitiveStr::Ascii("icious"),
        dictgen::InsensitiveStr::Ascii("iciously"),
        dictgen::InsensitiveStr::Ascii("pect"),
        dictgen::InsensitiveStr::Ascii("pected"),
        dictgen::InsensitiveStr::Ascii("pecting"),
        dictgen::InsensitiveStr::Ascii("pects"),
    ],
    values: &[
        &["subscription"],
        &["subscriptions"],
        &["suspects"],
        &["suspend"],
        &["suspense"],
        &["suspension"],
        &["suspicion"],
        &["suspicions"],
        &["suspicious"],
        &["suspiciously"],
        &["suspect"],
        &["suspected"],
        &["suspecting"],
        &["suspects"],
    ],
    range: 3..=9,
};

static WORD_SUPR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPR_CHILDREN),
    value: None,
};

pub static WORD_SUPR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("amacist"),
        dictgen::InsensitiveStr::Ascii("ass"),
        dictgen::InsensitiveStr::Ascii("assing"),
        dictgen::InsensitiveStr::Ascii("emacits"),
        dictgen::InsensitiveStr::Ascii("emasist"),
        dictgen::InsensitiveStr::Ascii("emicist"),
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("esed"),
        dictgen::InsensitiveStr::Ascii("eses"),
        dictgen::InsensitiveStr::Ascii("esing"),
        dictgen::InsensitiveStr::Ascii("esion"),
        dictgen::InsensitiveStr::Ascii("ess"),
        dictgen::InsensitiveStr::Ascii("essed"),
        dictgen::InsensitiveStr::Ascii("esses"),
        dictgen::InsensitiveStr::Ascii("essible"),
        dictgen::InsensitiveStr::Ascii("essing"),
        dictgen::InsensitiveStr::Ascii("ession"),
        dictgen::InsensitiveStr::Ascii("essions"),
        dictgen::InsensitiveStr::Ascii("essor"),
        dictgen::InsensitiveStr::Ascii("essors"),
        dictgen::InsensitiveStr::Ascii("esssion"),
        dictgen::InsensitiveStr::Ascii("imacist"),
        dictgen::InsensitiveStr::Ascii("ious"),
        dictgen::InsensitiveStr::Ascii("isd"),
        dictgen::InsensitiveStr::Ascii("ise"),
        dictgen::InsensitiveStr::Ascii("ised"),
        dictgen::InsensitiveStr::Ascii("ises"),
        dictgen::InsensitiveStr::Ascii("ising"),
        dictgen::InsensitiveStr::Ascii("isingly"),
        dictgen::InsensitiveStr::Ascii("ize"),
        dictgen::InsensitiveStr::Ascii("ized"),
        dictgen::InsensitiveStr::Ascii("izing"),
        dictgen::InsensitiveStr::Ascii("izingly"),
        dictgen::InsensitiveStr::Ascii("sied"),
    ],
    values: &[
        &["supremacist"],
        &["surpass"],
        &["surpassing"],
        &["supremacist"],
        &["supremacist"],
        &["supremacist"],
        &["suppress"],
        &["suppressed"],
        &["suppresses"],
        &["suppressing"],
        &["suppression"],
        &["suppress"],
        &["suppressed"],
        &["suppresses"],
        &["suppressible"],
        &["suppressing"],
        &["suppression"],
        &["suppressions"],
        &["suppressor"],
        &["suppressors"],
        &["suppression"],
        &["supremacist"],
        &["spurious"],
        &["surprised"],
        &["surprise"],
        &["surprised"],
        &["surprises"],
        &["surprising"],
        &["surprisingly"],
        &["surprise"],
        &["surprised"],
        &["surprising"],
        &["surprisingly"],
        &["surprised"],
    ],
    range: 2..=7,
};

static WORD_SUPP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SUPP_CHILDREN),
    value: None,
};

static WORD_SUPP_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    None,
    None,
    None,
    Some(&WORD_SUPPE_NODE),
    None,
    None,
    None,
    Some(&WORD_SUPPI_NODE),
    None,
    None,
    Some(&WORD_SUPPL_NODE),
    None,
    None,
    Some(&WORD_SUPPO_NODE),
    Some(&WORD_SUPPP_NODE),
    None,
    Some(&WORD_SUPPR_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_SUPPY_NODE),
    None,
];

static WORD_SUPPY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPPY_CHILDREN),
    value: Some(&["supply"]),
};

pub static WORD_SUPPY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ing")],
    values: &[&["supplying"]],
    range: 3..=3,
};

static WORD_SUPPR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPPR_CHILDREN),
    value: None,
};

pub static WORD_SUPPR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("eses"),
        dictgen::InsensitiveStr::Ascii("esion"),
        dictgen::InsensitiveStr::Ascii("esions"),
        dictgen::InsensitiveStr::Ascii("esors"),
        dictgen::InsensitiveStr::Ascii("essin"),
        dictgen::InsensitiveStr::Ascii("essingd"),
        dictgen::InsensitiveStr::Ascii("essio"),
        dictgen::InsensitiveStr::Ascii("esson"),
        dictgen::InsensitiveStr::Ascii("esssion"),
        dictgen::InsensitiveStr::Ascii("esssor"),
        dictgen::InsensitiveStr::Ascii("ot"),
        dictgen::InsensitiveStr::Ascii("oted"),
        dictgen::InsensitiveStr::Ascii("oter"),
        dictgen::InsensitiveStr::Ascii("oters"),
        dictgen::InsensitiveStr::Ascii("oting"),
        dictgen::InsensitiveStr::Ascii("ots"),
        dictgen::InsensitiveStr::Ascii("t"),
        dictgen::InsensitiveStr::Ascii("ted"),
    ],
    values: &[
        &["suppress"],
        &["suppress"],
        &["suppression"],
        &["suppression"],
        &["suppressor"],
        &["suppression"],
        &["suppressing"],
        &["suppressor"],
        &["suppression"],
        &["suppression"],
        &["suppressor"],
        &["support"],
        &["supported"],
        &["supporter"],
        &["supporters"],
        &["supporting"],
        &["supports"],
        &["support"],
        &["supported"],
    ],
    range: 1..=7,
};

static WORD_SUPPP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPPP_CHILDREN),
    value: None,
};

pub static WORD_SUPPP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lied"),
        dictgen::InsensitiveStr::Ascii("ored"),
        dictgen::InsensitiveStr::Ascii("ort"),
        dictgen::InsensitiveStr::Ascii("orted"),
        dictgen::InsensitiveStr::Ascii("orting"),
        dictgen::InsensitiveStr::Ascii("orts"),
    ],
    values: &[
        &["supplied"],
        &["supported"],
        &["support"],
        &["supported"],
        &["supporting"],
        &["supports"],
    ],
    range: 3..=6,
};

static WORD_SUPPO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPPO_CHILDREN),
    value: None,
};

pub static WORD_SUPPO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("ert"),
        dictgen::InsensitiveStr::Ascii("ort"),
        dictgen::InsensitiveStr::Ascii("orts"),
        dictgen::InsensitiveStr::Ascii("pose"),
        dictgen::InsensitiveStr::Ascii("prt"),
        dictgen::InsensitiveStr::Ascii("prted"),
        dictgen::InsensitiveStr::Ascii("r"),
        dictgen::InsensitiveStr::Ascii("red"),
        dictgen::InsensitiveStr::Ascii("ression"),
        dictgen::InsensitiveStr::Ascii("rre"),
        dictgen::InsensitiveStr::Ascii("rtare"),
        dictgen::InsensitiveStr::Ascii("rtd"),
        dictgen::InsensitiveStr::Ascii("rte"),
        dictgen::InsensitiveStr::Ascii("rtes"),
        dictgen::InsensitiveStr::Ascii("rtet"),
        dictgen::InsensitiveStr::Ascii("rteur"),
        dictgen::InsensitiveStr::Ascii("rteurs"),
        dictgen::InsensitiveStr::Ascii("rtied"),
        dictgen::InsensitiveStr::Ascii("rtin"),
        dictgen::InsensitiveStr::Ascii("rtors"),
        dictgen::InsensitiveStr::Ascii("rtted"),
        dictgen::InsensitiveStr::Ascii("sdely"),
        dictgen::InsensitiveStr::Ascii("sebly"),
        dictgen::InsensitiveStr::Ascii("seded"),
        dictgen::InsensitiveStr::Ascii("sedely"),
        dictgen::InsensitiveStr::Ascii("seds"),
        dictgen::InsensitiveStr::Ascii("sedy"),
        dictgen::InsensitiveStr::Ascii("sidely"),
        dictgen::InsensitiveStr::Ascii("sidly"),
        dictgen::InsensitiveStr::Ascii("singly"),
        dictgen::InsensitiveStr::Ascii("ssed"),
        dictgen::InsensitiveStr::Ascii("st"),
        dictgen::InsensitiveStr::Ascii("ted"),
    ],
    values: &[
        &["supposed"],
        &["support"],
        &["support"],
        &["supports"],
        &["suppose"],
        &["support"],
        &["supported"],
        &["support"],
        &["supported"],
        &["suppression"],
        &["supporters"],
        &["supporters"],
        &["supported"],
        &["supported", "supporter"],
        &["supports"],
        &["supporter", "supported"],
        &["supporter"],
        &["supporters"],
        &["supported"],
        &["supporting"],
        &["supporters"],
        &["supported"],
        &["supposedly"],
        &["supposedly"],
        &["supposed"],
        &["supposedly"],
        &["supposed"],
        &["supposedly"],
        &["supposedly"],
        &["supposedly"],
        &["supposedly"],
        &["supposed"],
        &["supports"],
        &["supported"],
    ],
    range: 1..=7,
};

static WORD_SUPPL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPPL_CHILDREN),
    value: None,
};

pub static WORD_SUPPL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ament"),
        dictgen::InsensitiveStr::Ascii("amental"),
        dictgen::InsensitiveStr::Ascii("amented"),
        dictgen::InsensitiveStr::Ascii("aments"),
        dictgen::InsensitiveStr::Ascii("emant"),
        dictgen::InsensitiveStr::Ascii("emetal"),
        dictgen::InsensitiveStr::Ascii("emets"),
        dictgen::InsensitiveStr::Ascii("iad"),
        dictgen::InsensitiveStr::Ascii("iementing"),
        dictgen::InsensitiveStr::Ascii("iment"),
        dictgen::InsensitiveStr::Ascii("imental"),
    ],
    values: &[
        &["supplement"],
        &["supplemental"],
        &["supplemented"],
        &["supplements"],
        &["supplemental"],
        &["supplemental"],
        &["supplements"],
        &["supplied"],
        &["supplementing"],
        &["supplement"],
        &["supplemental"],
    ],
    range: 3..=9,
};

static WORD_SUPPI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPPI_CHILDREN),
    value: None,
};

pub static WORD_SUPPI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("es"),
    ],
    values: &[&["supplied"], &["supplier"], &["supplies"]],
    range: 2..=2,
};

static WORD_SUPPE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPPE_CHILDREN),
    value: None,
};

pub static WORD_SUPPE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("rssor")],
    values: &[&["suppressor"]],
    range: 5..=5,
};

static WORD_SUPO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPO_CHILDREN),
    value: None,
};

pub static WORD_SUPO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rt"),
        dictgen::InsensitiveStr::Ascii("rted"),
        dictgen::InsensitiveStr::Ascii("rting"),
        dictgen::InsensitiveStr::Ascii("rts"),
        dictgen::InsensitiveStr::Ascii("rtted"),
        dictgen::InsensitiveStr::Ascii("se"),
        dictgen::InsensitiveStr::Ascii("sed"),
        dictgen::InsensitiveStr::Ascii("sedly"),
        dictgen::InsensitiveStr::Ascii("ses"),
        dictgen::InsensitiveStr::Ascii("sing"),
        dictgen::InsensitiveStr::Ascii("sse"),
    ],
    values: &[
        &["support"],
        &["supported"],
        &["supporting"],
        &["supports"],
        &["supported"],
        &["suppose"],
        &["supposed"],
        &["supposedly"],
        &["supposes"],
        &["supposing"],
        &["suppose"],
    ],
    range: 2..=5,
};

static WORD_SUPL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPL_CHILDREN),
    value: None,
};

pub static WORD_SUPL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ant"),
        dictgen::InsensitiveStr::Ascii("anted"),
        dictgen::InsensitiveStr::Ascii("anting"),
        dictgen::InsensitiveStr::Ascii("ants"),
        dictgen::InsensitiveStr::Ascii("ementary"),
        dictgen::InsensitiveStr::Ascii("ied"),
        dictgen::InsensitiveStr::Ascii("imented"),
        dictgen::InsensitiveStr::Ascii("lemental"),
        dictgen::InsensitiveStr::Ascii("lies"),
    ],
    values: &[
        &["supplant"],
        &["supplanted"],
        &["supplanting"],
        &["supplants"],
        &["supplementary"],
        &["supplied"],
        &["supplemented"],
        &["supplemental"],
        &["supplies"],
    ],
    range: 3..=8,
};

static WORD_SUPI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPI_CHILDREN),
    value: None,
};

pub static WORD_SUPI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("rsed")],
    values: &[&["surprised"]],
    range: 4..=4,
};

static WORD_SUPH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPH_CHILDREN),
    value: None,
};

pub static WORD_SUPH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("isticated")],
    values: &[&["sophisticated"]],
    range: 9..=9,
};

static WORD_SUPE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SUPE_CHILDREN),
    value: None,
};

static WORD_SUPE_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    Some(&WORD_SUPEB_NODE),
    None,
    None,
    Some(&WORD_SUPEE_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_SUPER_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_SUPER_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SUPER_CHILDREN),
    value: None,
};

static WORD_SUPER_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    None,
    Some(&WORD_SUPERC_NODE),
    None,
    None,
    Some(&WORD_SUPERF_NODE),
    None,
    Some(&WORD_SUPERH_NODE),
    Some(&WORD_SUPERI_NODE),
    None,
    None,
    None,
    Some(&WORD_SUPERM_NODE),
    Some(&WORD_SUPERN_NODE),
    Some(&WORD_SUPERO_NODE),
    Some(&WORD_SUPERP_NODE),
    None,
    None,
    Some(&WORD_SUPERS_NODE),
    None,
    None,
    Some(&WORD_SUPERV_NODE),
    None,
    None,
    None,
    None,
];

static WORD_SUPERV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPERV_CHILDREN),
    value: None,
};

pub static WORD_SUPERV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("iors"),
        dictgen::InsensitiveStr::Ascii("iosr"),
        dictgen::InsensitiveStr::Ascii("isar"),
        dictgen::InsensitiveStr::Ascii("iser"),
        dictgen::InsensitiveStr::Ascii("isers"),
        dictgen::InsensitiveStr::Ascii("isin"),
        dictgen::InsensitiveStr::Ascii("isior"),
        dictgen::InsensitiveStr::Ascii("isiors"),
        dictgen::InsensitiveStr::Ascii("iso"),
        dictgen::InsensitiveStr::Ascii("ison"),
        dictgen::InsensitiveStr::Ascii("isoras"),
        dictgen::InsensitiveStr::Ascii("isores"),
        dictgen::InsensitiveStr::Ascii("sior"),
    ],
    values: &[
        &["supervisors"],
        &["supervisors"],
        &["supervisor"],
        &["supervisor"],
        &["supervisors"],
        &["supervision"],
        &["supervisor"],
        &["supervisors"],
        &["supervision"],
        &["supervision"],
        &["supervisors"],
        &["supervisors"],
        &["supervisors"],
    ],
    range: 3..=6,
};

static WORD_SUPERS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPERS_CHILDREN),
    value: None,
};

pub static WORD_SUPERS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("eedd"),
        dictgen::InsensitiveStr::Ascii("eede"),
        dictgen::InsensitiveStr::Ascii("eeded"),
        dictgen::InsensitiveStr::Ascii("ition"),
        dictgen::InsensitiveStr::Ascii("ticion"),
        dictgen::InsensitiveStr::Ascii("ticious"),
        dictgen::InsensitiveStr::Ascii("tision"),
        dictgen::InsensitiveStr::Ascii("tisious"),
        dictgen::InsensitiveStr::Ascii("titios"),
        dictgen::InsensitiveStr::Ascii("titiosi"),
        dictgen::InsensitiveStr::Ascii("titiuos"),
        dictgen::InsensitiveStr::Ascii("titon"),
        dictgen::InsensitiveStr::Ascii("titous"),
        dictgen::InsensitiveStr::Ascii("tituous"),
    ],
    values: &[
        &["superseded"],
        &["superseded"],
        &["supersede"],
        &["superseded"],
        &["supervision"],
        &["superstition"],
        &["superstitious"],
        &["superstition"],
        &["superstitious"],
        &["superstitious"],
        &["superstitious"],
        &["superstitious"],
        &["superstition"],
        &["superstitious"],
        &["superstitious"],
    ],
    range: 2..=7,
};

static WORD_SUPERP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPERP_CHILDREN),
    value: None,
};

pub static WORD_SUPERP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("oser"),
        dictgen::InsensitiveStr::Ascii("owereds"),
    ],
    values: &[&["superpowers"], &["superpowers"]],
    range: 4..=7,
};

static WORD_SUPERO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPERO_CHILDREN),
    value: None,
};

pub static WORD_SUPERO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("peator"),
        dictgen::InsensitiveStr::Ascii("uman"),
    ],
    values: &[&["superoperator"], &["superhuman"]],
    range: 4..=6,
};

static WORD_SUPERN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPERN_CHILDREN),
    value: None,
};

pub static WORD_SUPERN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arkets"),
        dictgen::InsensitiveStr::Ascii("atrual"),
        dictgen::InsensitiveStr::Ascii("atual"),
    ],
    values: &[&["supermarkets"], &["supernatural"], &["supernatural"]],
    range: 5..=6,
};

static WORD_SUPERM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPERM_CHILDREN),
    value: None,
};

pub static WORD_SUPERM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("acist"),
        dictgen::InsensitiveStr::Ascii("akert"),
        dictgen::InsensitiveStr::Ascii("aket"),
        dictgen::InsensitiveStr::Ascii("akret"),
        dictgen::InsensitiveStr::Ascii("akter"),
        dictgen::InsensitiveStr::Ascii("are"),
        dictgen::InsensitiveStr::Ascii("arkedet"),
        dictgen::InsensitiveStr::Ascii("arkeds"),
        dictgen::InsensitiveStr::Ascii("arkers"),
        dictgen::InsensitiveStr::Ascii("arkert"),
        dictgen::InsensitiveStr::Ascii("arkerts"),
        dictgen::InsensitiveStr::Ascii("arkt"),
        dictgen::InsensitiveStr::Ascii("arkten"),
        dictgen::InsensitiveStr::Ascii("arktes"),
        dictgen::InsensitiveStr::Ascii("arkts"),
        dictgen::InsensitiveStr::Ascii("aster"),
        dictgen::InsensitiveStr::Ascii("e"),
    ],
    values: &[
        &["supremacist"],
        &["supermarkets"],
        &["supermarket"],
        &["supermarkets"],
        &["supermarkets"],
        &["supermarket"],
        &["supermarket"],
        &["supermarkets"],
        &["supermarkets"],
        &["supermarkets"],
        &["supermarkets"],
        &["supermarket"],
        &["supermarket"],
        &["supermarkets"],
        &["supermarkets"],
        &["supermarkets"],
        &["supreme"],
    ],
    range: 1..=7,
};

static WORD_SUPERI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPERI_CHILDREN),
    value: None,
};

pub static WORD_SUPERI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("fical"),
        dictgen::InsensitiveStr::Ascii("ntendant"),
        dictgen::InsensitiveStr::Ascii("oara"),
        dictgen::InsensitiveStr::Ascii("oare"),
        dictgen::InsensitiveStr::Ascii("orest"),
        dictgen::InsensitiveStr::Ascii("oris"),
        dictgen::InsensitiveStr::Ascii("os"),
        dictgen::InsensitiveStr::Ascii("our"),
        dictgen::InsensitiveStr::Ascii("sor"),
        dictgen::InsensitiveStr::Ascii("vsor"),
    ],
    values: &[
        &["superficial"],
        &["superintendent"],
        &["superior"],
        &["superior"],
        &["superiors"],
        &["superiors"],
        &["superiors"],
        &["superior"],
        &["superiors"],
        &["supervisors"],
    ],
    range: 2..=8,
};

static WORD_SUPERH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPERH_CHILDREN),
    value: None,
};

pub static WORD_SUPERH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("am"),
        dictgen::InsensitiveStr::Ascii("eo"),
        dictgen::InsensitiveStr::Ascii("ereos"),
    ],
    values: &[&["superhuman"], &["superhero"], &["superhero"]],
    range: 2..=5,
};

static WORD_SUPERF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPERF_CHILDREN),
    value: None,
};

pub static WORD_SUPERF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ical"),
        dictgen::InsensitiveStr::Ascii("iciel"),
        dictgen::InsensitiveStr::Ascii("louous"),
        dictgen::InsensitiveStr::Ascii("lous"),
        dictgen::InsensitiveStr::Ascii("louse"),
        dictgen::InsensitiveStr::Ascii("luious"),
        dictgen::InsensitiveStr::Ascii("luos"),
        dictgen::InsensitiveStr::Ascii("luu"),
        dictgen::InsensitiveStr::Ascii("ulous"),
    ],
    values: &[
        &["superficial"],
        &["superficial"],
        &["superfluous"],
        &["superfluous"],
        &["superfluous"],
        &["superfluous"],
        &["superfluous"],
        &["superfluous"],
        &["superfluous"],
    ],
    range: 3..=6,
};

static WORD_SUPERC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPERC_CHILDREN),
    value: None,
};

pub static WORD_SUPERC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alifragilisticexpialidoceous"),
        dictgen::InsensitiveStr::Ascii("ede"),
        dictgen::InsensitiveStr::Ascii("eded"),
        dictgen::InsensitiveStr::Ascii("edes"),
        dictgen::InsensitiveStr::Ascii("eding"),
        dictgen::InsensitiveStr::Ascii("eed"),
        dictgen::InsensitiveStr::Ascii("eeded"),
    ],
    values: &[
        &["supercalifragilisticexpialidocious"],
        &["supersede"],
        &["superseded"],
        &["supersedes"],
        &["superseding"],
        &["supersede"],
        &["superseded"],
    ],
    range: 3..=28,
};

static WORD_SUPEE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPEE_CHILDREN),
    value: None,
};

pub static WORD_SUPEE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("na")],
    values: &[&["subpoena"]],
    range: 2..=2,
};

static WORD_SUPEB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUPEB_CHILDREN),
    value: None,
};

pub static WORD_SUPEB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("lock")],
    values: &[&["superblock"]],
    range: 4..=4,
};

static WORD_SUO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUO_CHILDREN),
    value: None,
};

pub static WORD_SUO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("p")],
    values: &[&["soup"]],
    range: 1..=1,
};

static WORD_SUN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUN_CHILDREN),
    value: None,
};

pub static WORD_SUN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("conscious"),
        dictgen::InsensitiveStr::Ascii("consciously"),
        dictgen::InsensitiveStr::Ascii("derlad"),
        dictgen::InsensitiveStr::Ascii("derlona"),
        dictgen::InsensitiveStr::Ascii("derlund"),
        dictgen::InsensitiveStr::Ascii("fiber"),
        dictgen::InsensitiveStr::Ascii("galsses"),
        dictgen::InsensitiveStr::Ascii("ggle"),
        dictgen::InsensitiveStr::Ascii("glases"),
        dictgen::InsensitiveStr::Ascii("glassses"),
        dictgen::InsensitiveStr::Ascii("glesses"),
        dictgen::InsensitiveStr::Ascii("glinger"),
        dictgen::InsensitiveStr::Ascii("ifre"),
        dictgen::InsensitiveStr::Ascii("screeen"),
        dictgen::InsensitiveStr::Ascii("scren"),
        dictgen::InsensitiveStr::Ascii("task"),
    ],
    values: &[
        &["subconscious"],
        &["subconsciously"],
        &["sunderland"],
        &["sunderland"],
        &["sunderland"],
        &["sunfire"],
        &["sunglasses"],
        &["snuggle"],
        &["sunglasses"],
        &["sunglasses"],
        &["sunglasses"],
        &["gunslinger"],
        &["sunfire"],
        &["sunscreen"],
        &["sunscreen"],
        &["subtask"],
    ],
    range: 4..=11,
};

static WORD_SUM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUM_CHILDREN),
    value: None,
};

pub static WORD_SUM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("amry"),
        dictgen::InsensitiveStr::Ascii("ary"),
        dictgen::InsensitiveStr::Ascii("barine"),
        dictgen::InsensitiveStr::Ascii("barines"),
        dictgen::InsensitiveStr::Ascii("berged"),
        dictgen::InsensitiveStr::Ascii("bissions"),
        dictgen::InsensitiveStr::Ascii("bissive"),
        dictgen::InsensitiveStr::Ascii("bitted"),
        dictgen::InsensitiveStr::Ascii("bitting"),
        dictgen::InsensitiveStr::Ascii("may"),
        dictgen::InsensitiveStr::Ascii("menor"),
        dictgen::InsensitiveStr::Ascii("menors"),
        dictgen::InsensitiveStr::Ascii("merised"),
        dictgen::InsensitiveStr::Ascii("merized"),
        dictgen::InsensitiveStr::Ascii("mersalt"),
        dictgen::InsensitiveStr::Ascii("mmaries"),
        dictgen::InsensitiveStr::Ascii("mmarisation"),
        dictgen::InsensitiveStr::Ascii("mmarised"),
        dictgen::InsensitiveStr::Ascii("mmarization"),
        dictgen::InsensitiveStr::Ascii("mmarized"),
        dictgen::InsensitiveStr::Ascii("mmary"),
        dictgen::InsensitiveStr::Ascii("moenrs"),
        dictgen::InsensitiveStr::Ascii("mones"),
        dictgen::InsensitiveStr::Ascii("monr"),
        dictgen::InsensitiveStr::Ascii("more"),
        dictgen::InsensitiveStr::Ascii("morized"),
        dictgen::InsensitiveStr::Ascii("murized"),
        dictgen::InsensitiveStr::Ascii("odules"),
    ],
    values: &[
        &["summary"],
        &["summary"],
        &["submarine"],
        &["submarines"],
        &["submerged"],
        &["submissions"],
        &["submissive"],
        &["submitted"],
        &["submitting"],
        &["summary"],
        &["summoner"],
        &["summoners"],
        &["summarised"],
        &["summarized"],
        &["somersault"],
        &["summaries"],
        &["summarisation"],
        &["summarised"],
        &["summarization"],
        &["summarized"],
        &["summary"],
        &["summoners"],
        &["summoners"],
        &["summoner"],
        &["summoner"],
        &["summarized"],
        &["summarized"],
        &["submodules"],
    ],
    range: 3..=11,
};

static WORD_SUI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUI_CHILDREN),
    value: None,
};

pub static WORD_SUI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ete"),
        dictgen::InsensitiveStr::Ascii("teable"),
    ],
    values: &[&["suite"], &["suitable"]],
    range: 3..=6,
};

static WORD_SUH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUH_CHILDREN),
    value: Some(&["such"]),
};

pub static WORD_SUH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[],
    values: &[],
    range: 0..=0,
};

static WORD_SUG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUG_CHILDREN),
    value: None,
};

pub static WORD_SUG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ested"),
        dictgen::InsensitiveStr::Ascii("estion"),
        dictgen::InsensitiveStr::Ascii("estions"),
        dictgen::InsensitiveStr::Ascii("ests"),
        dictgen::InsensitiveStr::Ascii("gesst"),
        dictgen::InsensitiveStr::Ascii("geste"),
        dictgen::InsensitiveStr::Ascii("gestes"),
        dictgen::InsensitiveStr::Ascii("gestie"),
        dictgen::InsensitiveStr::Ascii("gestied"),
        dictgen::InsensitiveStr::Ascii("gestief"),
        dictgen::InsensitiveStr::Ascii("gestieve"),
        dictgen::InsensitiveStr::Ascii("gestons"),
        dictgen::InsensitiveStr::Ascii("gestsed"),
        dictgen::InsensitiveStr::Ascii("gestted"),
        dictgen::InsensitiveStr::Ascii("gesttion"),
        dictgen::InsensitiveStr::Ascii("gesttions"),
        dictgen::InsensitiveStr::Ascii("get"),
        dictgen::InsensitiveStr::Ascii("geted"),
        dictgen::InsensitiveStr::Ascii("gets"),
        dictgen::InsensitiveStr::Ascii("getsed"),
        dictgen::InsensitiveStr::Ascii("getsing"),
        dictgen::InsensitiveStr::Ascii("getsion"),
        dictgen::InsensitiveStr::Ascii("ggest"),
        dictgen::InsensitiveStr::Ascii("ggested"),
        dictgen::InsensitiveStr::Ascii("ggesting"),
        dictgen::InsensitiveStr::Ascii("ggestion"),
        dictgen::InsensitiveStr::Ascii("ggestions"),
        dictgen::InsensitiveStr::Ascii("guest"),
        dictgen::InsensitiveStr::Ascii("guested"),
        dictgen::InsensitiveStr::Ascii("guesting"),
        dictgen::InsensitiveStr::Ascii("guestion"),
        dictgen::InsensitiveStr::Ascii("guestions"),
    ],
    values: &[
        &["suggested"],
        &["suggestion"],
        &["suggestions"],
        &["suggests"],
        &["suggests"],
        &["suggestive"],
        &["suggests"],
        &["suggestive"],
        &["suggestive"],
        &["suggestive"],
        &["suggestive"],
        &["suggests"],
        &["suggested"],
        &["suggested"],
        &["suggestion"],
        &["suggestions"],
        &["suggest"],
        &["suggested"],
        &["suggest", "suggests"],
        &["suggested"],
        &["suggesting"],
        &["suggestion"],
        &["suggest"],
        &["suggested"],
        &["suggesting"],
        &["suggestion"],
        &["suggestions"],
        &["suggest"],
        &["suggested"],
        &["suggesting"],
        &["suggestion"],
        &["suggestions"],
    ],
    range: 3..=9,
};

static WORD_SUF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUF_CHILDREN),
    value: None,
};

pub static WORD_SUF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ace"),
        dictgen::InsensitiveStr::Ascii("aces"),
        dictgen::InsensitiveStr::Ascii("face"),
        dictgen::InsensitiveStr::Ascii("faces"),
        dictgen::InsensitiveStr::Ascii("ferage"),
        dictgen::InsensitiveStr::Ascii("ferd"),
        dictgen::InsensitiveStr::Ascii("ferered"),
        dictgen::InsensitiveStr::Ascii("ferred"),
        dictgen::InsensitiveStr::Ascii("ferring"),
        dictgen::InsensitiveStr::Ascii("ficate"),
        dictgen::InsensitiveStr::Ascii("ficated"),
        dictgen::InsensitiveStr::Ascii("ficates"),
        dictgen::InsensitiveStr::Ascii("ficating"),
        dictgen::InsensitiveStr::Ascii("fication"),
        dictgen::InsensitiveStr::Ascii("ficent"),
        dictgen::InsensitiveStr::Ascii("ficently"),
        dictgen::InsensitiveStr::Ascii("ficiant"),
        dictgen::InsensitiveStr::Ascii("ficit"),
        dictgen::InsensitiveStr::Ascii("fisticated"),
        dictgen::InsensitiveStr::Ascii("icate"),
        dictgen::InsensitiveStr::Ascii("icated"),
        dictgen::InsensitiveStr::Ascii("icates"),
        dictgen::InsensitiveStr::Ascii("icating"),
        dictgen::InsensitiveStr::Ascii("ication"),
        dictgen::InsensitiveStr::Ascii("iccient"),
        dictgen::InsensitiveStr::Ascii("icient"),
        dictgen::InsensitiveStr::Ascii("iciently"),
        dictgen::InsensitiveStr::Ascii("ocate"),
        dictgen::InsensitiveStr::Ascii("ocated"),
        dictgen::InsensitiveStr::Ascii("ocates"),
        dictgen::InsensitiveStr::Ascii("ocating"),
        dictgen::InsensitiveStr::Ascii("ocation"),
    ],
    values: &[
        &["surface"],
        &["surfaces"],
        &["surface"],
        &["surfaces"],
        &["suffrage"],
        &["suffered"],
        &["suffered"],
        &["suffered"],
        &["suffering"],
        &["suffocate"],
        &["suffocated"],
        &["suffocates"],
        &["suffocating"],
        &["suffocation"],
        &["sufficient"],
        &["sufficiently"],
        &["sufficient"],
        &["sufficient"],
        &["sophisticated"],
        &["suffocate"],
        &["suffocated"],
        &["suffocates"],
        &["suffocating"],
        &["suffocation"],
        &["sufficient"],
        &["sufficient"],
        &["sufficiently"],
        &["suffocate"],
        &["suffocated"],
        &["suffocates"],
        &["suffocating"],
        &["suffocation"],
    ],
    range: 3..=10,
};

static WORD_SUE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUE_CHILDREN),
    value: None,
};

pub static WORD_SUE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ful"),
        dictgen::InsensitiveStr::Ascii("full"),
    ],
    values: &[&["useful"], &["usefull"]],
    range: 3..=4,
};

static WORD_SUD_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUD_CHILDREN),
    value: None,
};

pub static WORD_SUD_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("deny"),
        dictgen::InsensitiveStr::Ascii("dnely"),
        dictgen::InsensitiveStr::Ascii("ent"),
        dictgen::InsensitiveStr::Ascii("ents"),
        dictgen::InsensitiveStr::Ascii("mobule"),
        dictgen::InsensitiveStr::Ascii("mobules"),
        dictgen::InsensitiveStr::Ascii("nerland"),
    ],
    values: &[
        &["suddenly"],
        &["suddenly"],
        &["student"],
        &["students"],
        &["submodule"],
        &["submodules"],
        &["sunderland"],
    ],
    range: 3..=7,
};

static WORD_SUC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SUC_CHILDREN),
    value: None,
};

static WORD_SUC_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    None,
    Some(&WORD_SUCC_NODE),
    None,
    Some(&WORD_SUCE_NODE),
    None,
    None,
    None,
    Some(&WORD_SUCI_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_SUCO_NODE),
    None,
    None,
    None,
    Some(&WORD_SUCS_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_SUCS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUCS_CHILDREN),
    value: None,
};

pub static WORD_SUCS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ede"),
        dictgen::InsensitiveStr::Ascii("eptible"),
    ],
    values: &[&["succeed"], &["susceptible"]],
    range: 3..=7,
};

static WORD_SUCO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUCO_CHILDREN),
    value: None,
};

pub static WORD_SUCO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("me")],
    values: &[&["succumb"]],
    range: 2..=2,
};

static WORD_SUCI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUCI_CHILDREN),
    value: None,
};

pub static WORD_SUCI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("de"),
        dictgen::InsensitiveStr::Ascii("dial"),
    ],
    values: &[&["suicide"], &["suicidal"]],
    range: 2..=4,
};

static WORD_SUCE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUCE_CHILDREN),
    value: None,
};

pub static WORD_SUCE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("eded"),
        dictgen::InsensitiveStr::Ascii("eding"),
        dictgen::InsensitiveStr::Ascii("eds"),
        dictgen::InsensitiveStr::Ascii("s"),
        dictgen::InsensitiveStr::Ascii("ses"),
        dictgen::InsensitiveStr::Ascii("sful"),
        dictgen::InsensitiveStr::Ascii("sfull"),
        dictgen::InsensitiveStr::Ascii("sfully"),
        dictgen::InsensitiveStr::Ascii("sfuly"),
        dictgen::InsensitiveStr::Ascii("sion"),
        dictgen::InsensitiveStr::Ascii("sive"),
        dictgen::InsensitiveStr::Ascii("ss"),
        dictgen::InsensitiveStr::Ascii("sscient"),
        dictgen::InsensitiveStr::Ascii("ssed"),
        dictgen::InsensitiveStr::Ascii("sseding"),
        dictgen::InsensitiveStr::Ascii("ssefully"),
        dictgen::InsensitiveStr::Ascii("sses"),
        dictgen::InsensitiveStr::Ascii("ssess"),
        dictgen::InsensitiveStr::Ascii("ssflly"),
        dictgen::InsensitiveStr::Ascii("ssfually"),
        dictgen::InsensitiveStr::Ascii("ssfukk"),
        dictgen::InsensitiveStr::Ascii("ssful"),
        dictgen::InsensitiveStr::Ascii("ssfull"),
        dictgen::InsensitiveStr::Ascii("ssfully"),
        dictgen::InsensitiveStr::Ascii("ssfuly"),
        dictgen::InsensitiveStr::Ascii("ssion"),
        dictgen::InsensitiveStr::Ascii("ssiv"),
        dictgen::InsensitiveStr::Ascii("ssive"),
        dictgen::InsensitiveStr::Ascii("ssively"),
        dictgen::InsensitiveStr::Ascii("ssor"),
        dictgen::InsensitiveStr::Ascii("ssors"),
        dictgen::InsensitiveStr::Ascii("ssot"),
        dictgen::InsensitiveStr::Ascii("sss"),
        dictgen::InsensitiveStr::Ascii("ssses"),
        dictgen::InsensitiveStr::Ascii("sssful"),
        dictgen::InsensitiveStr::Ascii("sssfull"),
        dictgen::InsensitiveStr::Ascii("sssfully"),
        dictgen::InsensitiveStr::Ascii("sssfuly"),
        dictgen::InsensitiveStr::Ascii("ssufll"),
        dictgen::InsensitiveStr::Ascii("ssuflly"),
        dictgen::InsensitiveStr::Ascii("ssully"),
    ],
    values: &[
        &["succeed"],
        &["succeeded"],
        &["succeeding"],
        &["succeeds"],
        &["success"],
        &["successes"],
        &["successful"],
        &["successful"],
        &["successfully"],
        &["successfully"],
        &["succession"],
        &["successive"],
        &["success"],
        &["sufficient"],
        &["succeeded"],
        &["succeeding", "seceding"],
        &["successfully"],
        &["successes"],
        &["success"],
        &["successfully"],
        &["successfully"],
        &["successful"],
        &["successful"],
        &["successful"],
        &["successfully"],
        &["successfully"],
        &["succession"],
        &["successive"],
        &["successive"],
        &["successively"],
        &["successor"],
        &["successors"],
        &["successor"],
        &["success"],
        &["successes"],
        &["successful"],
        &["successful"],
        &["successfully"],
        &["successfully"],
        &["successful"],
        &["successfully"],
        &["successfully"],
    ],
    range: 1..=8,
};

static WORD_SUCC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUCC_CHILDREN),
    value: None,
};

pub static WORD_SUCC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ceeded"),
        dictgen::InsensitiveStr::Ascii("cess"),
        dictgen::InsensitiveStr::Ascii("cesses"),
        dictgen::InsensitiveStr::Ascii("cessful"),
        dictgen::InsensitiveStr::Ascii("cessfully"),
        dictgen::InsensitiveStr::Ascii("cessor"),
        dictgen::InsensitiveStr::Ascii("cessors"),
        dictgen::InsensitiveStr::Ascii("cessul"),
        dictgen::InsensitiveStr::Ascii("cessully"),
        dictgen::InsensitiveStr::Ascii("ecful"),
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("edd"),
        dictgen::InsensitiveStr::Ascii("edded"),
        dictgen::InsensitiveStr::Ascii("edding"),
        dictgen::InsensitiveStr::Ascii("edds"),
        dictgen::InsensitiveStr::Ascii("ede"),
        dictgen::InsensitiveStr::Ascii("eded"),
        dictgen::InsensitiveStr::Ascii("edes"),
        dictgen::InsensitiveStr::Ascii("edfully"),
        dictgen::InsensitiveStr::Ascii("eding"),
        dictgen::InsensitiveStr::Ascii("eds"),
        dictgen::InsensitiveStr::Ascii("eedes"),
        dictgen::InsensitiveStr::Ascii("eeed"),
        dictgen::InsensitiveStr::Ascii("eeedds"),
        dictgen::InsensitiveStr::Ascii("eeeds"),
        dictgen::InsensitiveStr::Ascii("ees"),
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("esd"),
        dictgen::InsensitiveStr::Ascii("esed"),
        dictgen::InsensitiveStr::Ascii("esful"),
        dictgen::InsensitiveStr::Ascii("esfull"),
        dictgen::InsensitiveStr::Ascii("esfully"),
        dictgen::InsensitiveStr::Ascii("esfuly"),
        dictgen::InsensitiveStr::Ascii("esion"),
        dictgen::InsensitiveStr::Ascii("esions"),
        dictgen::InsensitiveStr::Ascii("esive"),
        dictgen::InsensitiveStr::Ascii("esor"),
        dictgen::InsensitiveStr::Ascii("esors"),
        dictgen::InsensitiveStr::Ascii("essed"),
        dictgen::InsensitiveStr::Ascii("esseurs"),
        dictgen::InsensitiveStr::Ascii("essfule"),
        dictgen::InsensitiveStr::Ascii("essfull"),
        dictgen::InsensitiveStr::Ascii("essfullies"),
        dictgen::InsensitiveStr::Ascii("essfullly"),
        dictgen::InsensitiveStr::Ascii("essfulln"),
        dictgen::InsensitiveStr::Ascii("essfullness"),
        dictgen::InsensitiveStr::Ascii("essfullt"),
        dictgen::InsensitiveStr::Ascii("essfuly"),
        dictgen::InsensitiveStr::Ascii("essing"),
        dictgen::InsensitiveStr::Ascii("essivo"),
        dictgen::InsensitiveStr::Ascii("esss"),
        dictgen::InsensitiveStr::Ascii("esssfully"),
        dictgen::InsensitiveStr::Ascii("esssion"),
        dictgen::InsensitiveStr::Ascii("essul"),
        dictgen::InsensitiveStr::Ascii("essully"),
        dictgen::InsensitiveStr::Ascii("int"),
        dictgen::InsensitiveStr::Ascii("seeded"),
        dictgen::InsensitiveStr::Ascii("sesfull"),
        dictgen::InsensitiveStr::Ascii("sess"),
        dictgen::InsensitiveStr::Ascii("sessfull"),
        dictgen::InsensitiveStr::Ascii("sessive"),
    ],
    values: &[
        &["succeeded"],
        &["success"],
        &["successes"],
        &["successful"],
        &["successfully"],
        &["successor"],
        &["successors"],
        &["successful"],
        &["successfully"],
        &["successful"],
        &["succeed"],
        &["succeed"],
        &["succeeded"],
        &["succeeding"],
        &["succeeds"],
        &["succeed"],
        &["succeeded"],
        &["succeeds"],
        &["successfully"],
        &["succeeding"],
        &["succeeds"],
        &["succeeds"],
        &["succeed", "succeeded"],
        &["succeeds"],
        &["succeeds"],
        &["succeeds", "success"],
        &["success"],
        &["succeeds"],
        &["succeeds"],
        &["successful"],
        &["successful"],
        &["successfully"],
        &["successfully"],
        &["succession"],
        &["succession"],
        &["successive"],
        &["successor"],
        &["successors"],
        &["succeeded", "success", "successful"],
        &["successes"],
        &["successful"],
        &["successful"],
        &["successfully"],
        &["successfully"],
        &["successful"],
        &["successfulness"],
        &["successfully"],
        &["successfully"],
        &["succession", "successive"],
        &["succession"],
        &["successes", "success"],
        &["successfully"],
        &["succession"],
        &["successful"],
        &["successfully"],
        &["succinct"],
        &["succeeded"],
        &["successfully"],
        &["success"],
        &["successful"],
        &["successive"],
    ],
    range: 2..=11,
};

static WORD_SUB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SUB_CHILDREN),
    value: None,
};

static WORD_SUB_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SUBA_NODE),
    None,
    Some(&WORD_SUBC_NODE),
    Some(&WORD_SUBD_NODE),
    Some(&WORD_SUBE_NODE),
    Some(&WORD_SUBF_NODE),
    None,
    None,
    Some(&WORD_SUBI_NODE),
    Some(&WORD_SUBJ_NODE),
    None,
    Some(&WORD_SUBL_NODE),
    Some(&WORD_SUBM_NODE),
    Some(&WORD_SUBN_NODE),
    Some(&WORD_SUBO_NODE),
    Some(&WORD_SUBP_NODE),
    Some(&WORD_SUBQ_NODE),
    Some(&WORD_SUBR_NODE),
    Some(&WORD_SUBS_NODE),
    Some(&WORD_SUBT_NODE),
    Some(&WORD_SUBU_NODE),
    None,
    None,
    None,
    Some(&WORD_SUBY_NODE),
    None,
];

static WORD_SUBY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBY_CHILDREN),
    value: None,
};

pub static WORD_SUBY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("stem"),
        dictgen::InsensitiveStr::Ascii("stems"),
    ],
    values: &[&["subsystem"], &["subsystems"]],
    range: 4..=5,
};

static WORD_SUBU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBU_CHILDREN),
    value: None,
};

pub static WORD_SUBU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("rburban")],
    values: &[&["suburban"]],
    range: 7..=7,
};

static WORD_SUBT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBT_CHILDREN),
    value: None,
};

pub static WORD_SUBT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("abels"),
        dictgen::InsensitiveStr::Ascii("ances"),
        dictgen::InsensitiveStr::Ascii("arger"),
        dictgen::InsensitiveStr::Ascii("argers"),
        dictgen::InsensitiveStr::Ascii("elty"),
        dictgen::InsensitiveStr::Ascii("erranian"),
        dictgen::InsensitiveStr::Ascii("etly"),
        dictgen::InsensitiveStr::Ascii("iel"),
        dictgen::InsensitiveStr::Ascii("ilte"),
        dictgen::InsensitiveStr::Ascii("iltes"),
        dictgen::InsensitiveStr::Ascii("itel"),
        dictgen::InsensitiveStr::Ascii("itels"),
        dictgen::InsensitiveStr::Ascii("itls"),
        dictgen::InsensitiveStr::Ascii("itltes"),
        dictgen::InsensitiveStr::Ascii("itute"),
        dictgen::InsensitiveStr::Ascii("ituted"),
        dictgen::InsensitiveStr::Ascii("itutes"),
        dictgen::InsensitiveStr::Ascii("ituting"),
        dictgen::InsensitiveStr::Ascii("itution"),
        dictgen::InsensitiveStr::Ascii("itutions"),
        dictgen::InsensitiveStr::Ascii("letly"),
        dictgen::InsensitiveStr::Ascii("ltey"),
        dictgen::InsensitiveStr::Ascii("lties"),
        dictgen::InsensitiveStr::Ascii("rafuge"),
        dictgen::InsensitiveStr::Ascii("ring"),
        dictgen::InsensitiveStr::Ascii("rings"),
        dictgen::InsensitiveStr::Ascii("situtable"),
        dictgen::InsensitiveStr::Ascii("situtatble"),
    ],
    values: &[
        &["subtables"],
        &["substances"],
        &["subtarget"],
        &["subtargets"],
        &["subtlety"],
        &["subterranean"],
        &["subtlety"],
        &["subtitle"],
        &["subtitle"],
        &["subtitles"],
        &["subtitle"],
        &["subtitles"],
        &["subtitles"],
        &["subtitle"],
        &["substitute"],
        &["substituted"],
        &["substitutes"],
        &["substituting"],
        &["substitution"],
        &["substitutions"],
        &["subtlety"],
        &["subtlety"],
        &["subtitles"],
        &["subterfuge"],
        &["substring"],
        &["substrings"],
        &["substitutable"],
        &["substitutable"],
    ],
    range: 3..=10,
};

static WORD_SUBS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SUBS_CHILDREN),
    value: None,
};

static WORD_SUBS_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SUBSA_NODE),
    None,
    Some(&WORD_SUBSC_NODE),
    None,
    Some(&WORD_SUBSE_NODE),
    None,
    None,
    Some(&WORD_SUBSH_NODE),
    Some(&WORD_SUBSI_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_SUBSQ_NODE),
    Some(&WORD_SUBSR_NODE),
    None,
    Some(&WORD_SUBST_NODE),
    Some(&WORD_SUBSU_NODE),
    None,
    None,
    None,
    Some(&WORD_SUBSY_NODE),
    None,
];

static WORD_SUBSY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBSY_CHILDREN),
    value: None,
};

pub static WORD_SUBSY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("sthem"),
        dictgen::InsensitiveStr::Ascii("sthems"),
        dictgen::InsensitiveStr::Ascii("styem"),
        dictgen::InsensitiveStr::Ascii("styems"),
        dictgen::InsensitiveStr::Ascii("sytem"),
        dictgen::InsensitiveStr::Ascii("sytems"),
        dictgen::InsensitiveStr::Ascii("tem"),
        dictgen::InsensitiveStr::Ascii("tems"),
    ],
    values: &[
        &["subsystem"],
        &["subsystems"],
        &["subsystem"],
        &["subsystems"],
        &["subsystem"],
        &["subsystems"],
        &["subsystem"],
        &["subsystems"],
    ],
    range: 3..=6,
};

static WORD_SUBSU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBSU_CHILDREN),
    value: None,
};

pub static WORD_SUBSU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("dized")],
    values: &[&["subsidized"]],
    range: 5..=5,
};

static WORD_SUBST_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SUBST_CHILDREN),
    value: None,
};

static WORD_SUBST_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SUBSTA_NODE),
    None,
    None,
    None,
    Some(&WORD_SUBSTE_NODE),
    None,
    None,
    None,
    Some(&WORD_SUBSTI_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_SUBSTR_NODE),
    None,
    None,
    Some(&WORD_SUBSTU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static WORD_SUBSTU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBSTU_CHILDREN),
    value: None,
};

pub static WORD_SUBSTU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cture"),
        dictgen::InsensitiveStr::Ascii("ctures"),
        dictgen::InsensitiveStr::Ascii("tite"),
    ],
    values: &[
        &["substructure"],
        &["substructures"],
        &["substitutes", "substitute"],
    ],
    range: 4..=6,
};

static WORD_SUBSTR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBSTR_CHILDREN),
    value: None,
};

pub static WORD_SUBSTR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("act"),
        dictgen::InsensitiveStr::Ascii("acted"),
        dictgen::InsensitiveStr::Ascii("acting"),
        dictgen::InsensitiveStr::Ascii("action"),
        dictgen::InsensitiveStr::Ascii("acts"),
    ],
    values: &[
        &["subtract"],
        &["subtracted"],
        &["subtracting"],
        &["subtraction"],
        &["subtracts"],
    ],
    range: 3..=6,
};

static WORD_SUBSTI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBSTI_CHILDREN),
    value: None,
};

pub static WORD_SUBSTI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("te"),
        dictgen::InsensitiveStr::Ascii("tion"),
        dictgen::InsensitiveStr::Ascii("tions"),
        dictgen::InsensitiveStr::Ascii("tite"),
        dictgen::InsensitiveStr::Ascii("tition"),
        dictgen::InsensitiveStr::Ascii("titions"),
        dictgen::InsensitiveStr::Ascii("tiute"),
        dictgen::InsensitiveStr::Ascii("ttue"),
        dictgen::InsensitiveStr::Ascii("tuation"),
        dictgen::InsensitiveStr::Ascii("tuations"),
        dictgen::InsensitiveStr::Ascii("tude"),
        dictgen::InsensitiveStr::Ascii("tuded"),
        dictgen::InsensitiveStr::Ascii("tudes"),
        dictgen::InsensitiveStr::Ascii("tuding"),
        dictgen::InsensitiveStr::Ascii("tue"),
        dictgen::InsensitiveStr::Ascii("tued"),
        dictgen::InsensitiveStr::Ascii("tuer"),
        dictgen::InsensitiveStr::Ascii("tues"),
        dictgen::InsensitiveStr::Ascii("tuing"),
        dictgen::InsensitiveStr::Ascii("tuion"),
        dictgen::InsensitiveStr::Ascii("tuions"),
        dictgen::InsensitiveStr::Ascii("ture"),
        dictgen::InsensitiveStr::Ascii("tures"),
        dictgen::InsensitiveStr::Ascii("tutents"),
        dictgen::InsensitiveStr::Ascii("tuters"),
        dictgen::InsensitiveStr::Ascii("tutie"),
        dictgen::InsensitiveStr::Ascii("tutivo"),
        dictgen::InsensitiveStr::Ascii("tuto"),
        dictgen::InsensitiveStr::Ascii("tutos"),
        dictgen::InsensitiveStr::Ascii("tuts"),
        dictgen::InsensitiveStr::Ascii("tutue"),
        dictgen::InsensitiveStr::Ascii("tutues"),
        dictgen::InsensitiveStr::Ascii("ution"),
    ],
    values: &[
        &["substitute"],
        &["substitution"],
        &["substitutions"],
        &["substitute"],
        &["substitution"],
        &["substitutions"],
        &["substitute"],
        &["substitutes"],
        &["substitution"],
        &["substitutions"],
        &["substitute"],
        &["substituted"],
        &["substitutes"],
        &["substituting"],
        &["substitute"],
        &["substitute", "substituted"],
        &["substitute"],
        &["substitutes"],
        &["substituting"],
        &["substitution"],
        &["substitutions"],
        &["substitute"],
        &["substitutes"],
        &["substitutes"],
        &["substitutes"],
        &["substitutes"],
        &["substitution"],
        &["substitution"],
        &["substitutes"],
        &["substitutes"],
        &["substitutes"],
        &["substitutes"],
        &["substitution"],
    ],
    range: 2..=8,
};

static WORD_SUBSTE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBSTE_CHILDREN),
    value: None,
};

pub static WORD_SUBSTE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("nces"),
        dictgen::InsensitiveStr::Ascii("ntial"),
    ],
    values: &[&["substances"], &["substantial"]],
    range: 4..=5,
};

static WORD_SUBSTA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBSTA_CHILDREN),
    value: None,
};

pub static WORD_SUBSTA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ce"),
        dictgen::InsensitiveStr::Ascii("ct"),
        dictgen::InsensitiveStr::Ascii("intially"),
        dictgen::InsensitiveStr::Ascii("ncial"),
        dictgen::InsensitiveStr::Ascii("ncially"),
        dictgen::InsensitiveStr::Ascii("nial"),
        dictgen::InsensitiveStr::Ascii("nitally"),
        dictgen::InsensitiveStr::Ascii("ns"),
        dictgen::InsensitiveStr::Ascii("nse"),
        dictgen::InsensitiveStr::Ascii("nsen"),
        dictgen::InsensitiveStr::Ascii("nser"),
        dictgen::InsensitiveStr::Ascii("nses"),
        dictgen::InsensitiveStr::Ascii("nsial"),
        dictgen::InsensitiveStr::Ascii("nsially"),
        dictgen::InsensitiveStr::Ascii("nsive"),
        dictgen::InsensitiveStr::Ascii("nta"),
        dictgen::InsensitiveStr::Ascii("nte"),
        dictgen::InsensitiveStr::Ascii("ntiable"),
        dictgen::InsensitiveStr::Ascii("ntialy"),
        dictgen::InsensitiveStr::Ascii("ntie"),
        dictgen::InsensitiveStr::Ascii("ntied"),
        dictgen::InsensitiveStr::Ascii("nties"),
        dictgen::InsensitiveStr::Ascii("ntitve"),
        dictgen::InsensitiveStr::Ascii("ntually"),
        dictgen::InsensitiveStr::Ascii("rte"),
        dictgen::InsensitiveStr::Ascii("tial"),
    ],
    values: &[
        &["substance"],
        &["subtract"],
        &["substantially"],
        &["substantial"],
        &["substantially"],
        &["substantial"],
        &["substantially"],
        &["substances"],
        &["substances"],
        &["substances"],
        &["substances"],
        &["substances"],
        &["substantial"],
        &["substantially"],
        &["substantive"],
        &["substantial"],
        &["substantive"],
        &["substantial"],
        &["substantially"],
        &["substantive"],
        &["substantive"],
        &["substantive"],
        &["substantive"],
        &["substantially"],
        &["substrate"],
        &["substantial"],
    ],
    range: 2..=8,
};

static WORD_SUBSR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBSR_CHILDREN),
    value: None,
};

pub static WORD_SUBSR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cibe"),
        dictgen::InsensitiveStr::Ascii("cibed"),
        dictgen::InsensitiveStr::Ascii("cibers"),
        dictgen::InsensitiveStr::Ascii("ciption"),
        dictgen::InsensitiveStr::Ascii("iber"),
        dictgen::InsensitiveStr::Ascii("icption"),
    ],
    values: &[
        &["subscribe"],
        &["subscribed"],
        &["subscribers"],
        &["subscriptions"],
        &["subscriber"],
        &["subscriptions"],
    ],
    range: 4..=7,
};

static WORD_SUBSQ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBSQ_CHILDREN),
    value: None,
};

pub static WORD_SUBSQ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("uent"),
        dictgen::InsensitiveStr::Ascii("uently"),
    ],
    values: &[&["subsequent"], &["subsequently"]],
    range: 4..=6,
};

static WORD_SUBSI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBSI_CHILDREN),
    value: None,
};

pub static WORD_SUBSI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("dary"),
        dictgen::InsensitiveStr::Ascii("dezed"),
        dictgen::InsensitiveStr::Ascii("diced"),
        dictgen::InsensitiveStr::Ascii("die"),
        dictgen::InsensitiveStr::Ascii("diezed"),
        dictgen::InsensitiveStr::Ascii("diy"),
        dictgen::InsensitiveStr::Ascii("dizied"),
        dictgen::InsensitiveStr::Ascii("dizies"),
        dictgen::InsensitiveStr::Ascii("dizng"),
        dictgen::InsensitiveStr::Ascii("duary"),
        dictgen::InsensitiveStr::Ascii("quent"),
        dictgen::InsensitiveStr::Ascii("quently"),
        dictgen::InsensitiveStr::Ascii("ttute"),
        dictgen::InsensitiveStr::Ascii("tuent"),
        dictgen::InsensitiveStr::Ascii("tuents"),
        dictgen::InsensitiveStr::Ascii("tutable"),
        dictgen::InsensitiveStr::Ascii("tutatble"),
        dictgen::InsensitiveStr::Ascii("tute"),
        dictgen::InsensitiveStr::Ascii("tuted"),
        dictgen::InsensitiveStr::Ascii("tutes"),
        dictgen::InsensitiveStr::Ascii("tuting"),
        dictgen::InsensitiveStr::Ascii("tution"),
        dictgen::InsensitiveStr::Ascii("tutuent"),
        dictgen::InsensitiveStr::Ascii("tutuents"),
        dictgen::InsensitiveStr::Ascii("tutute"),
        dictgen::InsensitiveStr::Ascii("tututed"),
        dictgen::InsensitiveStr::Ascii("tututes"),
        dictgen::InsensitiveStr::Ascii("tututing"),
        dictgen::InsensitiveStr::Ascii("tutution"),
        dictgen::InsensitiveStr::Ascii("zide"),
        dictgen::InsensitiveStr::Ascii("zided"),
        dictgen::InsensitiveStr::Ascii("ziding"),
    ],
    values: &[
        &["subsidiary"],
        &["subsidized"],
        &["subsidized"],
        &["subsidized"],
        &["subsidized"],
        &["subsidy"],
        &["subsidized"],
        &["subsidize"],
        &["subsidizing"],
        &["subsidiary"],
        &["subsequent"],
        &["subsequently"],
        &["substitutes"],
        &["substituent"],
        &["substituents"],
        &["substitutable"],
        &["substitutable"],
        &["substitute"],
        &["substituted"],
        &["substitutes"],
        &["substituting"],
        &["substitution"],
        &["substituent"],
        &["substituents"],
        &["substitute"],
        &["substituted"],
        &["substitutes"],
        &["substituting"],
        &["substitution"],
        &["subsidize"],
        &["subsidized"],
        &["subsidizing"],
    ],
    range: 3..=8,
};

static WORD_SUBSH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBSH_CHILDREN),
    value: None,
};

pub static WORD_SUBSH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ystem"),
        dictgen::InsensitiveStr::Ascii("ystems"),
    ],
    values: &[&["subsystem"], &["subsystems"]],
    range: 5..=6,
};

static WORD_SUBSE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBSE_CHILDREN),
    value: None,
};

pub static WORD_SUBSE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("crion"),
        dictgen::InsensitiveStr::Ascii("dent"),
        dictgen::InsensitiveStr::Ascii("dized"),
        dictgen::InsensitiveStr::Ascii("qence"),
        dictgen::InsensitiveStr::Ascii("qent"),
        dictgen::InsensitiveStr::Ascii("quant"),
        dictgen::InsensitiveStr::Ascii("quenty"),
        dictgen::InsensitiveStr::Ascii("quest"),
        dictgen::InsensitiveStr::Ascii("qunce"),
        dictgen::InsensitiveStr::Ascii("qunt"),
        dictgen::InsensitiveStr::Ascii("quntly"),
    ],
    values: &[
        &["subsection"],
        &["subsequent"],
        &["subsidized"],
        &["subsequence"],
        &["subsequent"],
        &["subsequent"],
        &["subsequently"],
        &["subsequent"],
        &["subsequence"],
        &["subsequent"],
        &["subsequently"],
    ],
    range: 4..=6,
};

static WORD_SUBSC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBSC_CHILDREN),
    value: None,
};

pub static WORD_SUBSC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eptible"),
        dictgen::InsensitiveStr::Ascii("ibe"),
        dictgen::InsensitiveStr::Ascii("ibed"),
        dictgen::InsensitiveStr::Ascii("iber"),
        dictgen::InsensitiveStr::Ascii("ibers"),
        dictgen::InsensitiveStr::Ascii("irbe"),
        dictgen::InsensitiveStr::Ascii("irbed"),
        dictgen::InsensitiveStr::Ascii("irber"),
        dictgen::InsensitiveStr::Ascii("irbers"),
        dictgen::InsensitiveStr::Ascii("irbes"),
        dictgen::InsensitiveStr::Ascii("irbing"),
        dictgen::InsensitiveStr::Ascii("irpt"),
        dictgen::InsensitiveStr::Ascii("irption"),
        dictgen::InsensitiveStr::Ascii("irptions"),
        dictgen::InsensitiveStr::Ascii("oncious"),
        dictgen::InsensitiveStr::Ascii("onciously"),
        dictgen::InsensitiveStr::Ascii("ribar"),
        dictgen::InsensitiveStr::Ascii("ribbed"),
        dictgen::InsensitiveStr::Ascii("ribber"),
        dictgen::InsensitiveStr::Ascii("ribbers"),
        dictgen::InsensitiveStr::Ascii("ribbing"),
        dictgen::InsensitiveStr::Ascii("ribir"),
        dictgen::InsensitiveStr::Ascii("ribirse"),
        dictgen::InsensitiveStr::Ascii("rible"),
        dictgen::InsensitiveStr::Ascii("ribtion"),
        dictgen::InsensitiveStr::Ascii("ribtions"),
        dictgen::InsensitiveStr::Ascii("rie"),
        dictgen::InsensitiveStr::Ascii("riped"),
        dictgen::InsensitiveStr::Ascii("riping"),
        dictgen::InsensitiveStr::Ascii("riptin"),
        dictgen::InsensitiveStr::Ascii("ripton"),
        dictgen::InsensitiveStr::Ascii("riptons"),
        dictgen::InsensitiveStr::Ascii("ritpion"),
        dictgen::InsensitiveStr::Ascii("ritpions"),
        dictgen::InsensitiveStr::Ascii("ritpiton"),
        dictgen::InsensitiveStr::Ascii("ritpitons"),
        dictgen::InsensitiveStr::Ascii("ritpt"),
        dictgen::InsensitiveStr::Ascii("ritption"),
        dictgen::InsensitiveStr::Ascii("ritptions"),
        dictgen::InsensitiveStr::Ascii("rpition"),
        dictgen::InsensitiveStr::Ascii("rubed"),
        dictgen::InsensitiveStr::Ascii("ryber"),
    ],
    values: &[
        &["susceptible"],
        &["subscribe"],
        &["subscribed"],
        &["subscriber"],
        &["subscribers"],
        &["subscribe"],
        &["subscribed"],
        &["subscribers", "subscriber"],
        &["subscribers"],
        &["subscribes"],
        &["subscribing"],
        &["subscript"],
        &["subscriptions", "subscription"],
        &["subscriptions"],
        &["subconscious"],
        &["subconsciously"],
        &["subscriber"],
        &["subscribe"],
        &["subscriber"],
        &["subscribers"],
        &["subscribing"],
        &["subscriber"],
        &["subscriber"],
        &["subscriber"],
        &["subscription"],
        &["subscriptions"],
        &["subscriber"],
        &["subscribed"],
        &["subscribing"],
        &["subscriptions"],
        &["subscription"],
        &["subscriptions"],
        &["subscriptions", "subscription"],
        &["subscriptions"],
        &["subscription"],
        &["subscriptions"],
        &["subscript"],
        &["subscription"],
        &["subscriptions"],
        &["subscriptions"],
        &["subscribed"],
        &["subscriber"],
    ],
    range: 3..=9,
};

static WORD_SUBSA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBSA_CHILDREN),
    value: None,
};

pub static WORD_SUBSA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("dized")],
    values: &[&["subsidized"]],
    range: 5..=5,
};

static WORD_SUBR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBR_CHILDREN),
    value: None,
};

pub static WORD_SUBR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("act"),
        dictgen::InsensitiveStr::Ascii("acted"),
        dictgen::InsensitiveStr::Ascii("action"),
        dictgen::InsensitiveStr::Ascii("edddits"),
        dictgen::InsensitiveStr::Ascii("edditors"),
        dictgen::InsensitiveStr::Ascii("ee"),
        dictgen::InsensitiveStr::Ascii("outie"),
        dictgen::InsensitiveStr::Ascii("outies"),
        dictgen::InsensitiveStr::Ascii("uban"),
    ],
    values: &[
        &["subtract"],
        &["subtracted"],
        &["subtraction"],
        &["subreddits"],
        &["subreddits"],
        &["subtree"],
        &["subroutine"],
        &["subroutines"],
        &["suburban"],
    ],
    range: 2..=8,
};

static WORD_SUBQ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBQ_CHILDREN),
    value: None,
};

pub static WORD_SUBQ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("uue")],
    values: &[&["subqueue"]],
    range: 3..=3,
};

static WORD_SUBP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBP_CHILDREN),
    value: None,
};

pub static WORD_SUBP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ackge"),
        dictgen::InsensitiveStr::Ascii("ackges"),
        dictgen::InsensitiveStr::Ascii("ecies"),
        dictgen::InsensitiveStr::Ascii("orgram"),
        dictgen::InsensitiveStr::Ascii("roccese"),
        dictgen::InsensitiveStr::Ascii("sace"),
    ],
    values: &[
        &["subpackage"],
        &["subpackages"],
        &["subspecies"],
        &["subprogram"],
        &["subprocess"],
        &["subspace"],
    ],
    range: 4..=7,
};

static WORD_SUBO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBO_CHILDREN),
    value: None,
};

pub static WORD_SUBO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bjecs"),
        dictgen::InsensitiveStr::Ascii("utine"),
    ],
    values: &[&["subobjects"], &["subroutine"]],
    range: 5..=5,
};

static WORD_SUBN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBN_CHILDREN),
    value: None,
};

pub static WORD_SUBN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("egatiotiation"),
        dictgen::InsensitiveStr::Ascii("egatiotiations"),
        dictgen::InsensitiveStr::Ascii("egoatiation"),
        dictgen::InsensitiveStr::Ascii("egoatiations"),
        dictgen::InsensitiveStr::Ascii("egoation"),
        dictgen::InsensitiveStr::Ascii("egoations"),
        dictgen::InsensitiveStr::Ascii("egociation"),
        dictgen::InsensitiveStr::Ascii("egociations"),
        dictgen::InsensitiveStr::Ascii("egogtiation"),
        dictgen::InsensitiveStr::Ascii("egogtiations"),
        dictgen::InsensitiveStr::Ascii("egoitation"),
        dictgen::InsensitiveStr::Ascii("egoitations"),
        dictgen::InsensitiveStr::Ascii("egoptionsotiation"),
        dictgen::InsensitiveStr::Ascii("egoptionsotiations"),
        dictgen::InsensitiveStr::Ascii("egosiation"),
        dictgen::InsensitiveStr::Ascii("egosiations"),
        dictgen::InsensitiveStr::Ascii("egotaiation"),
        dictgen::InsensitiveStr::Ascii("egotaiations"),
        dictgen::InsensitiveStr::Ascii("egotaition"),
        dictgen::InsensitiveStr::Ascii("egotaitions"),
        dictgen::InsensitiveStr::Ascii("egotatiation"),
        dictgen::InsensitiveStr::Ascii("egotatiations"),
        dictgen::InsensitiveStr::Ascii("egotation"),
        dictgen::InsensitiveStr::Ascii("egotations"),
        dictgen::InsensitiveStr::Ascii("egothiation"),
        dictgen::InsensitiveStr::Ascii("egothiations"),
        dictgen::InsensitiveStr::Ascii("egotication"),
        dictgen::InsensitiveStr::Ascii("egotications"),
        dictgen::InsensitiveStr::Ascii("egotioation"),
        dictgen::InsensitiveStr::Ascii("egotioations"),
        dictgen::InsensitiveStr::Ascii("egotion"),
        dictgen::InsensitiveStr::Ascii("egotionation"),
        dictgen::InsensitiveStr::Ascii("egotionations"),
        dictgen::InsensitiveStr::Ascii("egotions"),
        dictgen::InsensitiveStr::Ascii("egotiotation"),
        dictgen::InsensitiveStr::Ascii("egotiotations"),
        dictgen::InsensitiveStr::Ascii("egotiotion"),
        dictgen::InsensitiveStr::Ascii("egotiotions"),
        dictgen::InsensitiveStr::Ascii("egotitaion"),
        dictgen::InsensitiveStr::Ascii("egotitaions"),
        dictgen::InsensitiveStr::Ascii("egotitation"),
        dictgen::InsensitiveStr::Ascii("egotitations"),
        dictgen::InsensitiveStr::Ascii("egotition"),
        dictgen::InsensitiveStr::Ascii("egotitions"),
        dictgen::InsensitiveStr::Ascii("egoziation"),
        dictgen::InsensitiveStr::Ascii("egoziations"),
    ],
    values: &[
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
        &["subnegotiation"],
        &["subnegotiations"],
    ],
    range: 7..=18,
};

static WORD_SUBM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBM_CHILDREN),
    value: None,
};

pub static WORD_SUBM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("achne"),
        dictgen::InsensitiveStr::Ascii("arie"),
        dictgen::InsensitiveStr::Ascii("ariens"),
        dictgen::InsensitiveStr::Ascii("arinas"),
        dictgen::InsensitiveStr::Ascii("ergerd"),
        dictgen::InsensitiveStr::Ascii("ergered"),
        dictgen::InsensitiveStr::Ascii("erines"),
        dictgen::InsensitiveStr::Ascii("ision"),
        dictgen::InsensitiveStr::Ascii("isison"),
        dictgen::InsensitiveStr::Ascii("isisons"),
        dictgen::InsensitiveStr::Ascii("issies"),
        dictgen::InsensitiveStr::Ascii("isson"),
        dictgen::InsensitiveStr::Ascii("issons"),
        dictgen::InsensitiveStr::Ascii("ited"),
        dictgen::InsensitiveStr::Ascii("ition"),
        dictgen::InsensitiveStr::Ascii("itions"),
        dictgen::InsensitiveStr::Ascii("ittion"),
        dictgen::InsensitiveStr::Ascii("ittted"),
        dictgen::InsensitiveStr::Ascii("oule"),
        dictgen::InsensitiveStr::Ascii("ti"),
    ],
    values: &[
        &["submachine"],
        &["submarines"],
        &["submarines"],
        &["submarines"],
        &["submerged"],
        &["submerged"],
        &["submarines"],
        &["submission"],
        &["submissions"],
        &["submissions"],
        &["submissive"],
        &["submission"],
        &["submissions"],
        &["submitted"],
        &["submission"],
        &["submissions"],
        &["submitting"],
        &["submitted"],
        &["submodule"],
        &["submit"],
    ],
    range: 2..=7,
};

static WORD_SUBL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBL_CHILDREN),
    value: None,
};

pub static WORD_SUBL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ass"),
        dictgen::InsensitiveStr::Ascii("asse"),
        dictgen::InsensitiveStr::Ascii("asses"),
        dictgen::InsensitiveStr::Ascii("casses"),
        dictgen::InsensitiveStr::Ascii("cuase"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("tety"),
    ],
    values: &[
        &["subclass"],
        &["subclasse"],
        &["subclasses"],
        &["subclasses"],
        &["subclause"],
        &["subtle"],
        &["subtlety"],
    ],
    range: 1..=6,
};

static WORD_SUBJ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBJ_CHILDREN),
    value: None,
};

pub static WORD_SUBJ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ec"),
        dictgen::InsensitiveStr::Ascii("ectief"),
        dictgen::InsensitiveStr::Ascii("ectifs"),
        dictgen::InsensitiveStr::Ascii("ectivelly"),
        dictgen::InsensitiveStr::Ascii("ectivety"),
        dictgen::InsensitiveStr::Ascii("ectivily"),
        dictgen::InsensitiveStr::Ascii("ectivley"),
        dictgen::InsensitiveStr::Ascii("ectivly"),
        dictgen::InsensitiveStr::Ascii("ectivy"),
        dictgen::InsensitiveStr::Ascii("ektive"),
        dictgen::InsensitiveStr::Ascii("est"),
        dictgen::InsensitiveStr::Ascii("et"),
        dictgen::InsensitiveStr::Ascii("udgation"),
    ],
    values: &[
        &["subject"],
        &["subjective"],
        &["subjects"],
        &["subjectively"],
        &["subjectively"],
        &["subjectively"],
        &["subjectively"],
        &["subjectively"],
        &["subjectively"],
        &["subjective"],
        &["subjects"],
        &["subject"],
        &["subjugation"],
    ],
    range: 2..=9,
};

static WORD_SUBI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBI_CHILDREN),
    value: None,
};

pub static WORD_SUBI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rectory"),
        dictgen::InsensitiveStr::Ascii("sdized"),
        dictgen::InsensitiveStr::Ascii("sdizing"),
        dictgen::InsensitiveStr::Ascii("sdy"),
    ],
    values: &[
        &["subdirectory"],
        &["subsidized"],
        &["subsidizing"],
        &["subsidy"],
    ],
    range: 3..=7,
};

static WORD_SUBF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBF_CHILDREN),
    value: None,
};

pub static WORD_SUBF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("olfer"),
        dictgen::InsensitiveStr::Ascii("olfers"),
        dictgen::InsensitiveStr::Ascii("roms"),
    ],
    values: &[&["subfolder"], &["subfolders"], &["subforms"]],
    range: 4..=6,
};

static WORD_SUBE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBE_CHILDREN),
    value: None,
};

pub static WORD_SUBE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lemet"),
        dictgen::InsensitiveStr::Ascii("lemets"),
        dictgen::InsensitiveStr::Ascii("squent"),
        dictgen::InsensitiveStr::Ascii("squently"),
        dictgen::InsensitiveStr::Ascii("xperesion"),
        dictgen::InsensitiveStr::Ascii("xperesions"),
        dictgen::InsensitiveStr::Ascii("xperession"),
        dictgen::InsensitiveStr::Ascii("xperessions"),
        dictgen::InsensitiveStr::Ascii("xpersion"),
        dictgen::InsensitiveStr::Ascii("xpersions"),
        dictgen::InsensitiveStr::Ascii("xperssion"),
        dictgen::InsensitiveStr::Ascii("xperssions"),
        dictgen::InsensitiveStr::Ascii("xpession"),
        dictgen::InsensitiveStr::Ascii("xpessions"),
        dictgen::InsensitiveStr::Ascii("xpresssion"),
        dictgen::InsensitiveStr::Ascii("xpresssions"),
    ],
    values: &[
        &["subelement"],
        &["subelements"],
        &["subsequent"],
        &["subsequently"],
        &["subexpression"],
        &["subexpressions"],
        &["subexpression"],
        &["subexpressions"],
        &["subexpression"],
        &["subexpressions"],
        &["subexpression"],
        &["subexpressions"],
        &["subexpression"],
        &["subexpressions"],
        &["subexpression"],
        &["subexpressions"],
    ],
    range: 5..=11,
};

static WORD_SUBD_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBD_CHILDREN),
    value: None,
};

pub static WORD_SUBD_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("irectoires"),
        dictgen::InsensitiveStr::Ascii("irectorys"),
        dictgen::InsensitiveStr::Ascii("irecty"),
        dictgen::InsensitiveStr::Ascii("ivisio"),
        dictgen::InsensitiveStr::Ascii("ivisiond"),
        dictgen::InsensitiveStr::Ascii("oamin"),
        dictgen::InsensitiveStr::Ascii("oamins"),
    ],
    values: &[
        &["subdirectories"],
        &["subdirectories"],
        &["subdirectory"],
        &["subdivision"],
        &["subdivisioned"],
        &["subdomain"],
        &["subdomains"],
    ],
    range: 5..=10,
};

static WORD_SUBC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBC_CHILDREN),
    value: None,
};

pub static WORD_SUBC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("atagories"),
        dictgen::InsensitiveStr::Ascii("atagory"),
        dictgen::InsensitiveStr::Ascii("irucit"),
        dictgen::InsensitiveStr::Ascii("ommannd"),
        dictgen::InsensitiveStr::Ascii("ommnad"),
        dictgen::InsensitiveStr::Ascii("onchus"),
        dictgen::InsensitiveStr::Ascii("oncsious"),
        dictgen::InsensitiveStr::Ascii("oncsiously"),
        dictgen::InsensitiveStr::Ascii("onsciosly"),
        dictgen::InsensitiveStr::Ascii("onsciouly"),
        dictgen::InsensitiveStr::Ascii("onscius"),
        dictgen::InsensitiveStr::Ascii("onscous"),
        dictgen::InsensitiveStr::Ascii("onsicous"),
        dictgen::InsensitiveStr::Ascii("onsicously"),
        dictgen::InsensitiveStr::Ascii("onsiously"),
        dictgen::InsensitiveStr::Ascii("ouncious"),
        dictgen::InsensitiveStr::Ascii("ribe"),
        dictgen::InsensitiveStr::Ascii("ribed"),
        dictgen::InsensitiveStr::Ascii("ribes"),
        dictgen::InsensitiveStr::Ascii("ribing"),
        dictgen::InsensitiveStr::Ascii("sription"),
        dictgen::InsensitiveStr::Ascii("ulter"),
        dictgen::InsensitiveStr::Ascii("ultuur"),
    ],
    values: &[
        &["subcategories"],
        &["subcategory"],
        &["subcircuit"],
        &["subcommand"],
        &["subcommand"],
        &["subconscious"],
        &["subconscious"],
        &["subconsciously"],
        &["subconsciously"],
        &["subconsciously"],
        &["subconscious"],
        &["subconscious"],
        &["subconscious"],
        &["subconsciously"],
        &["subconsciously"],
        &["subconscious"],
        &["subscribe"],
        &["subscribed"],
        &["subscribes"],
        &["subscribing"],
        &["subscriptions"],
        &["subculture"],
        &["subculture"],
    ],
    range: 4..=10,
};

static WORD_SUBA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUBA_CHILDREN),
    value: None,
};

pub static WORD_SUBA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rmine"),
        dictgen::InsensitiveStr::Ascii("rmines"),
    ],
    values: &[&["submarine"], &["submarines"]],
    range: 5..=6,
};

static WORD_SUA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SUA_CHILDREN),
    value: None,
};

pub static WORD_SUA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("sage"),
        dictgen::InsensitiveStr::Ascii("sages"),
    ],
    values: &[&["sausage"], &["sausages"]],
    range: 4..=5,
};

static WORD_ST_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_ST_CHILDREN),
    value: None,
};

static WORD_ST_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_STA_NODE),
    None,
    Some(&WORD_STC_NODE),
    Some(&WORD_STD_NODE),
    Some(&WORD_STE_NODE),
    None,
    None,
    None,
    Some(&WORD_STI_NODE),
    None,
    None,
    Some(&WORD_STL_NODE),
    None,
    Some(&WORD_STN_NODE),
    Some(&WORD_STO_NODE),
    Some(&WORD_STP_NODE),
    None,
    Some(&WORD_STR_NODE),
    Some(&WORD_STS_NODE),
    Some(&WORD_STT_NODE),
    Some(&WORD_STU_NODE),
    None,
    None,
    None,
    Some(&WORD_STY_NODE),
    None,
];

static WORD_STY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STY_CHILDREN),
    value: None,
};

pub static WORD_STY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("he"),
        dictgen::InsensitiveStr::Ascii("ilistic"),
        dictgen::InsensitiveStr::Ascii("lisch"),
        dictgen::InsensitiveStr::Ascii("rofaom"),
        dictgen::InsensitiveStr::Ascii("rofom"),
    ],
    values: &[
        &["style"],
        &["stylistic"],
        &["stylish"],
        &["styrofoam"],
        &["styrofoam"],
    ],
    range: 2..=7,
};

static WORD_STU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STU_CHILDREN),
    value: None,
};

pub static WORD_STU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ation"),
        dictgen::InsensitiveStr::Ascii("ations"),
        dictgen::InsensitiveStr::Ascii("bbon"),
        dictgen::InsensitiveStr::Ascii("bborness"),
        dictgen::InsensitiveStr::Ascii("bbron"),
        dictgen::InsensitiveStr::Ascii("bmled"),
        dictgen::InsensitiveStr::Ascii("cked"),
        dictgen::InsensitiveStr::Ascii("ckt"),
        dictgen::InsensitiveStr::Ascii("ct"),
        dictgen::InsensitiveStr::Ascii("cts"),
        dictgen::InsensitiveStr::Ascii("cture"),
        dictgen::InsensitiveStr::Ascii("ctured"),
        dictgen::InsensitiveStr::Ascii("ctures"),
        dictgen::InsensitiveStr::Ascii("ddy"),
        dictgen::InsensitiveStr::Ascii("di"),
        dictgen::InsensitiveStr::Ascii("ding"),
        dictgen::InsensitiveStr::Ascii("dioes"),
        dictgen::InsensitiveStr::Ascii("dis"),
        dictgen::InsensitiveStr::Ascii("doi"),
        dictgen::InsensitiveStr::Ascii("dois"),
        dictgen::InsensitiveStr::Ascii("ggling"),
        dictgen::InsensitiveStr::Ascii("ido"),
        dictgen::InsensitiveStr::Ascii("idos"),
        dictgen::InsensitiveStr::Ascii("ill"),
        dictgen::InsensitiveStr::Ascii("ipder"),
        dictgen::InsensitiveStr::Ascii("mbeld"),
        dictgen::InsensitiveStr::Ascii("mmac"),
        dictgen::InsensitiveStr::Ascii("nami"),
        dictgen::InsensitiveStr::Ascii("pdily"),
        dictgen::InsensitiveStr::Ascii("pidfree"),
        dictgen::InsensitiveStr::Ascii("piditiy"),
        dictgen::InsensitiveStr::Ascii("pidiy"),
        dictgen::InsensitiveStr::Ascii("pidr"),
        dictgen::InsensitiveStr::Ascii("pidy"),
        dictgen::InsensitiveStr::Ascii("pire"),
        dictgen::InsensitiveStr::Ascii("pitidy"),
        dictgen::InsensitiveStr::Ascii("rctural"),
        dictgen::InsensitiveStr::Ascii("rcture"),
        dictgen::InsensitiveStr::Ascii("rctures"),
        dictgen::InsensitiveStr::Ascii("rggled"),
        dictgen::InsensitiveStr::Ascii("rggles"),
        dictgen::InsensitiveStr::Ascii("rggling"),
        dictgen::InsensitiveStr::Ascii("rture"),
        dictgen::InsensitiveStr::Ascii("rtured"),
        dictgen::InsensitiveStr::Ascii("rtures"),
        dictgen::InsensitiveStr::Ascii("ructure"),
        dictgen::InsensitiveStr::Ascii("tdown"),
        dictgen::InsensitiveStr::Ascii("tterring"),
        dictgen::InsensitiveStr::Ascii("tus"),
    ],
    values: &[
        &["situation", "station"],
        &["situations", "stations"],
        &["stubborn"],
        &["stubbornness"],
        &["stubborn"],
        &["stumbled"],
        &["stuck"],
        &["stuck"],
        &["struct"],
        &["structs"],
        &["structure"],
        &["structured"],
        &["structures"],
        &["study"],
        &["study", "studio"],
        &["studying"],
        &["studios"],
        &["studies", "studios"],
        &["studio"],
        &["studios"],
        &["struggling"],
        &["studio"],
        &["studios"],
        &["still"],
        &["stupider"],
        &["stumbled"],
        &["stomach"],
        &["tsunami"],
        &["stupidly"],
        &["stupider"],
        &["stupidity"],
        &["stupidity"],
        &["stupider"],
        &["stupidly"],
        &["stupider"],
        &["stupidity"],
        &["structural"],
        &["structure"],
        &["structures"],
        &["struggled"],
        &["struggles"],
        &["struggling"],
        &["structure"],
        &["structured"],
        &["structures"],
        &["structure"],
        &["shutdown"],
        &["stuttering"],
        &["status"],
    ],
    range: 2..=8,
};

static WORD_STT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STT_CHILDREN),
    value: None,
};

pub static WORD_STT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eting"),
        dictgen::InsensitiveStr::Ascii("etings"),
        dictgen::InsensitiveStr::Ascii("ing"),
        dictgen::InsensitiveStr::Ascii("ings"),
        dictgen::InsensitiveStr::Ascii("utering"),
    ],
    values: &[
        &["setting"],
        &["settings"],
        &["string", "setting", "sitting"],
        &["strings", "settings", "sittings"],
        &["stuttering"],
    ],
    range: 3..=7,
};

static WORD_STS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STS_CHILDREN),
    value: None,
};

pub static WORD_STS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("tr")],
    values: &[&["strstr"]],
    range: 2..=2,
};

static WORD_STR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_STR_CHILDREN),
    value: None,
};

static WORD_STR_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_STRA_NODE),
    None,
    Some(&WORD_STRC_NODE),
    None,
    Some(&WORD_STRE_NODE),
    None,
    None,
    None,
    Some(&WORD_STRI_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_STRN_NODE),
    Some(&WORD_STRO_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_STRU_NODE),
    None,
    Some(&WORD_STRW_NODE),
    None,
    Some(&WORD_STRY_NODE),
    None,
];

static WORD_STRY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRY_CHILDREN),
    value: None,
};

pub static WORD_STRY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ofoam")],
    values: &[&["styrofoam"]],
    range: 5..=5,
};

static WORD_STRW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRW_CHILDREN),
    value: None,
};

pub static WORD_STRW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("aberry")],
    values: &[&["strawberry"]],
    range: 6..=6,
};

static WORD_STRU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRU_CHILDREN),
    value: None,
};

pub static WORD_STRU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("c"),
        dictgen::InsensitiveStr::Ascii("crure"),
        dictgen::InsensitiveStr::Ascii("crured"),
        dictgen::InsensitiveStr::Ascii("crures"),
        dictgen::InsensitiveStr::Ascii("cted"),
        dictgen::InsensitiveStr::Ascii("cter"),
        dictgen::InsensitiveStr::Ascii("ctere"),
        dictgen::InsensitiveStr::Ascii("ctered"),
        dictgen::InsensitiveStr::Ascii("cteres"),
        dictgen::InsensitiveStr::Ascii("ctire"),
        dictgen::InsensitiveStr::Ascii("ctre"),
        dictgen::InsensitiveStr::Ascii("ctred"),
        dictgen::InsensitiveStr::Ascii("ctres"),
        dictgen::InsensitiveStr::Ascii("ctrual"),
        dictgen::InsensitiveStr::Ascii("ctual"),
        dictgen::InsensitiveStr::Ascii("ctue"),
        dictgen::InsensitiveStr::Ascii("ctued"),
        dictgen::InsensitiveStr::Ascii("ctues"),
        dictgen::InsensitiveStr::Ascii("ctur"),
        dictgen::InsensitiveStr::Ascii("cturel"),
        dictgen::InsensitiveStr::Ascii("cturels"),
        dictgen::InsensitiveStr::Ascii("cturs"),
        dictgen::InsensitiveStr::Ascii("cure"),
        dictgen::InsensitiveStr::Ascii("cutral"),
        dictgen::InsensitiveStr::Ascii("cutre"),
        dictgen::InsensitiveStr::Ascii("cutred"),
        dictgen::InsensitiveStr::Ascii("cutres"),
        dictgen::InsensitiveStr::Ascii("cuture"),
        dictgen::InsensitiveStr::Ascii("ggel"),
        dictgen::InsensitiveStr::Ascii("ggeld"),
        dictgen::InsensitiveStr::Ascii("ggeled"),
        dictgen::InsensitiveStr::Ascii("ggeling"),
        dictgen::InsensitiveStr::Ascii("ggels"),
        dictgen::InsensitiveStr::Ascii("gglebus"),
        dictgen::InsensitiveStr::Ascii("ggleing"),
        dictgen::InsensitiveStr::Ascii("gglign"),
        dictgen::InsensitiveStr::Ascii("ttural"),
        dictgen::InsensitiveStr::Ascii("tture"),
        dictgen::InsensitiveStr::Ascii("ture"),
    ],
    values: &[
        &["struct"],
        &["structure"],
        &["structured"],
        &["structures"],
        &["structured"],
        &["structure"],
        &["structure"],
        &["structured"],
        &["structures"],
        &["structure"],
        &["structure"],
        &["structured"],
        &["structures"],
        &["structural"],
        &["structural"],
        &["structure"],
        &["structured"],
        &["structures"],
        &["structure"],
        &["structural"],
        &["structures"],
        &["structures"],
        &["structure"],
        &["structural"],
        &["structure"],
        &["structured"],
        &["structures"],
        &["structure"],
        &["struggle"],
        &["struggled"],
        &["struggled"],
        &["struggling"],
        &["struggles"],
        &["struggles"],
        &["struggling"],
        &["struggling"],
        &["structural"],
        &["structure"],
        &["structure"],
    ],
    range: 1..=7,
};

static WORD_STRO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRO_CHILDREN),
    value: None,
};

pub static WORD_STRO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("age"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("ing"),
        dictgen::InsensitiveStr::Ascii("med"),
        dictgen::InsensitiveStr::Ascii("mfront"),
        dictgen::InsensitiveStr::Ascii("nkhold"),
        dictgen::InsensitiveStr::Ascii("nlgy"),
        dictgen::InsensitiveStr::Ascii("nly"),
        dictgen::InsensitiveStr::Ascii("re"),
        dictgen::InsensitiveStr::Ascii("red"),
        dictgen::InsensitiveStr::Ascii("res"),
        dictgen::InsensitiveStr::Ascii("ring"),
        dictgen::InsensitiveStr::Ascii("tage"),
        dictgen::InsensitiveStr::Ascii("y"),
        dictgen::InsensitiveStr::Ascii("yline"),
        dictgen::InsensitiveStr::Ascii("ylines"),
        dictgen::InsensitiveStr::Ascii("ytelling"),
    ],
    values: &[
        &["storage"],
        &["store"],
        &["storing"],
        &["stormed"],
        &["stormfront"],
        &["stronghold"],
        &["strongly"],
        &["strongly"],
        &["store"],
        &["stored"],
        &["stores"],
        &["storing"],
        &["storage"],
        &["story", "destroy"],
        &["storyline"],
        &["storylines"],
        &["storytelling"],
    ],
    range: 1..=8,
};

static WORD_STRN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRN_CHILDREN),
    value: None,
};

pub static WORD_STRN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ad"),
        dictgen::InsensitiveStr::Ascii("g"),
    ],
    values: &[&["strand"], &["string"]],
    range: 1..=2,
};

static WORD_STRI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRI_CHILDREN),
    value: None,
};

pub static WORD_STRI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aght"),
        dictgen::InsensitiveStr::Ascii("aghten"),
        dictgen::InsensitiveStr::Ascii("aghtens"),
        dictgen::InsensitiveStr::Ascii("aghtforward"),
        dictgen::InsensitiveStr::Ascii("aghts"),
        dictgen::InsensitiveStr::Ascii("ans"),
        dictgen::InsensitiveStr::Ascii("clty"),
        dictgen::InsensitiveStr::Ascii("cly"),
        dictgen::InsensitiveStr::Ascii("cteir"),
        dictgen::InsensitiveStr::Ascii("ctier"),
        dictgen::InsensitiveStr::Ascii("ctiest"),
        dictgen::InsensitiveStr::Ascii("ctist"),
        dictgen::InsensitiveStr::Ascii("cty"),
        dictgen::InsensitiveStr::Ascii("ekr"),
        dictgen::InsensitiveStr::Ascii("ekrs"),
        dictgen::InsensitiveStr::Ascii("g"),
        dictgen::InsensitiveStr::Ascii("gification"),
        dictgen::InsensitiveStr::Ascii("gifying"),
        dictgen::InsensitiveStr::Ascii("kely"),
        dictgen::InsensitiveStr::Ascii("nget"),
        dictgen::InsensitiveStr::Ascii("ngifed"),
        dictgen::InsensitiveStr::Ascii("ngnet"),
        dictgen::InsensitiveStr::Ascii("nsg"),
        dictgen::InsensitiveStr::Ascii("ppen"),
        dictgen::InsensitiveStr::Ascii("pt"),
        dictgen::InsensitiveStr::Ascii("rngification"),
    ],
    values: &[
        &["straight"],
        &["straighten"],
        &["straightens"],
        &["straightforward"],
        &["straights"],
        &["strains"],
        &["strictly"],
        &["strictly"],
        &["stricter"],
        &["stricter"],
        &["strictest"],
        &["strictest"],
        &["strictly"],
        &["striker"],
        &["strikers"],
        &["string"],
        &["stringification"],
        &["stringifying"],
        &["strikingly"],
        &["stringent"],
        &["stringified"],
        &["stringent"],
        &["strings"],
        &["stripped"],
        &["stripped"],
        &["stringification"],
    ],
    range: 1..=12,
};

static WORD_STRE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_STRE_CHILDREN),
    value: None,
};

static WORD_STRE_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_STREA_NODE),
    None,
    Some(&WORD_STREC_NODE),
    None,
    Some(&WORD_STREE_NODE),
    None,
    Some(&WORD_STREG_NODE),
    None,
    Some(&WORD_STREI_NODE),
    None,
    None,
    None,
    Some(&WORD_STREM_NODE),
    Some(&WORD_STREN_NODE),
    Some(&WORD_STREO_NODE),
    None,
    None,
    Some(&WORD_STRER_NODE),
    Some(&WORD_STRES_NODE),
    Some(&WORD_STRET_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_STRET_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRET_CHILDREN),
    value: None,
};

pub static WORD_STRET_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("chs"),
        dictgen::InsensitiveStr::Ascii("egically"),
    ],
    values: &[&["stretches"], &["strategically"]],
    range: 3..=8,
};

static WORD_STRES_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRES_CHILDREN),
    value: None,
};

pub static WORD_STRES_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("sade"),
        dictgen::InsensitiveStr::Ascii("sende"),
        dictgen::InsensitiveStr::Ascii("sers"),
        dictgen::InsensitiveStr::Ascii("ss"),
    ],
    values: &[&["stressed"], &["stressed"], &["stresses"], &["stresses"]],
    range: 2..=5,
};

static WORD_STRER_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRER_CHILDREN),
    value: None,
};

pub static WORD_STRER_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("rror")],
    values: &[&["strerror"]],
    range: 4..=4,
};

static WORD_STREO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STREO_CHILDREN),
    value: None,
};

pub static WORD_STREO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("id")],
    values: &[&["steroid"]],
    range: 2..=2,
};

static WORD_STREN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STREN_CHILDREN),
    value: None,
};

pub static WORD_STREN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gh"),
        dictgen::InsensitiveStr::Ascii("ghen"),
        dictgen::InsensitiveStr::Ascii("ghened"),
        dictgen::InsensitiveStr::Ascii("ghening"),
        dictgen::InsensitiveStr::Ascii("ght"),
        dictgen::InsensitiveStr::Ascii("ghten"),
        dictgen::InsensitiveStr::Ascii("ghtend"),
        dictgen::InsensitiveStr::Ascii("ghtened"),
        dictgen::InsensitiveStr::Ascii("ghtening"),
        dictgen::InsensitiveStr::Ascii("ghtens"),
        dictgen::InsensitiveStr::Ascii("ghts"),
        dictgen::InsensitiveStr::Ascii("gsten"),
        dictgen::InsensitiveStr::Ascii("gtened"),
        dictgen::InsensitiveStr::Ascii("gtheing"),
        dictgen::InsensitiveStr::Ascii("gthes"),
        dictgen::InsensitiveStr::Ascii("gthin"),
        dictgen::InsensitiveStr::Ascii("gthining"),
        dictgen::InsensitiveStr::Ascii("gthn"),
        dictgen::InsensitiveStr::Ascii("gts"),
        dictgen::InsensitiveStr::Ascii("ous"),
        dictgen::InsensitiveStr::Ascii("tgh"),
        dictgen::InsensitiveStr::Ascii("tghs"),
        dictgen::InsensitiveStr::Ascii("th"),
    ],
    values: &[
        &["strength"],
        &["strengthen"],
        &["strengthened"],
        &["strengthening"],
        &["strength"],
        &["strengthen"],
        &["strengthen"],
        &["strengthened"],
        &["strengthening"],
        &["strengthen"],
        &["strengths"],
        &["strengthen"],
        &["strengthened"],
        &["strengthening"],
        &["strengths"],
        &["strengthen"],
        &["strengthening"],
        &["strengthen"],
        &["strengths"],
        &["strenuous"],
        &["strength"],
        &["strengths"],
        &["strength"],
    ],
    range: 2..=8,
};

static WORD_STREM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STREM_CHILDREN),
    value: Some(&["stream"]),
};

pub static WORD_STREM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("a"),
        dictgen::InsensitiveStr::Ascii("ear"),
    ],
    values: &[&["stream"], &["streamer"]],
    range: 1..=3,
};

static WORD_STREI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STREI_CHILDREN),
    value: None,
};

pub static WORD_STREI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("chung"),
        dictgen::InsensitiveStr::Ascii("ghtened"),
    ],
    values: &[&["stretching"], &["straightened"]],
    range: 5..=7,
};

static WORD_STREG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STREG_CHILDREN),
    value: None,
};

pub static WORD_STREG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("nth"),
        dictgen::InsensitiveStr::Ascii("nthen"),
        dictgen::InsensitiveStr::Ascii("nthening"),
        dictgen::InsensitiveStr::Ascii("nths"),
        dictgen::InsensitiveStr::Ascii("th"),
    ],
    values: &[
        &["strength"],
        &["strengthen"],
        &["strengthening"],
        &["strengths"],
        &["strength"],
    ],
    range: 2..=8,
};

static WORD_STREE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STREE_CHILDREN),
    value: None,
};

pub static WORD_STREE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("m"),
        dictgen::InsensitiveStr::Ascii("mlining"),
    ],
    values: &[&["stream"], &["streamlining"]],
    range: 1..=7,
};

static WORD_STREC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STREC_CHILDREN),
    value: None,
};

pub static WORD_STREC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("h"),
        dictgen::InsensitiveStr::Ascii("hed"),
        dictgen::InsensitiveStr::Ascii("hes"),
        dictgen::InsensitiveStr::Ascii("hing"),
        dictgen::InsensitiveStr::Ascii("hted"),
        dictgen::InsensitiveStr::Ascii("htes"),
        dictgen::InsensitiveStr::Ascii("hting"),
        dictgen::InsensitiveStr::Ascii("tch"),
        dictgen::InsensitiveStr::Ascii("thed"),
        dictgen::InsensitiveStr::Ascii("thes"),
        dictgen::InsensitiveStr::Ascii("thing"),
    ],
    values: &[
        &["stretch"],
        &["stretched"],
        &["stretches"],
        &["stretching"],
        &["stretched"],
        &["stretches"],
        &["stretching"],
        &["stretch"],
        &["stretched"],
        &["stretches"],
        &["stretching"],
    ],
    range: 1..=5,
};

static WORD_STREA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STREA_CHILDREN),
    value: None,
};

pub static WORD_STREA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ching"),
        dictgen::InsensitiveStr::Ascii("made"),
        dictgen::InsensitiveStr::Ascii("mare"),
        dictgen::InsensitiveStr::Ascii("md"),
        dictgen::InsensitiveStr::Ascii("mear"),
        dictgen::InsensitiveStr::Ascii("mes"),
        dictgen::InsensitiveStr::Ascii("mm"),
        dictgen::InsensitiveStr::Ascii("mmed"),
        dictgen::InsensitiveStr::Ascii("mming"),
        dictgen::InsensitiveStr::Ascii("mos"),
        dictgen::InsensitiveStr::Ascii("mtrue"),
        dictgen::InsensitiveStr::Ascii("mus"),
        dictgen::InsensitiveStr::Ascii("mys"),
        dictgen::InsensitiveStr::Ascii("tched"),
    ],
    values: &[
        &["stretching"],
        &["streamed"],
        &["streamer"],
        &["streamed"],
        &["streamer"],
        &["streams"],
        &["stream"],
        &["streamed"],
        &["streaming"],
        &["streams"],
        &["streamer"],
        &["streams"],
        &["streams"],
        &["stretched"],
    ],
    range: 2..=5,
};

static WORD_STRC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRC_CHILDREN),
    value: None,
};

pub static WORD_STRC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ture"),
        dictgen::InsensitiveStr::Ascii("tures"),
        dictgen::InsensitiveStr::Ascii("utre"),
        dictgen::InsensitiveStr::Ascii("utural"),
        dictgen::InsensitiveStr::Ascii("uture"),
        dictgen::InsensitiveStr::Ascii("utures"),
    ],
    values: &[
        &["structure"],
        &["structures"],
        &["structure"],
        &["structural"],
        &["structure"],
        &["structures"],
    ],
    range: 4..=6,
};

static WORD_STRA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_STRA_CHILDREN),
    value: None,
};

static WORD_STRA_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    None,
    Some(&WORD_STRAC_NODE),
    Some(&WORD_STRAD_NODE),
    None,
    None,
    Some(&WORD_STRAG_NODE),
    None,
    Some(&WORD_STRAI_NODE),
    None,
    None,
    None,
    Some(&WORD_STRAM_NODE),
    Some(&WORD_STRAN_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_STRAT_NODE),
    None,
    Some(&WORD_STRAV_NODE),
    Some(&WORD_STRAW_NODE),
    None,
    None,
    None,
];

static WORD_STRAW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRAW_CHILDREN),
    value: None,
};

pub static WORD_STRAW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("barry"),
        dictgen::InsensitiveStr::Ascii("beary"),
        dictgen::InsensitiveStr::Ascii("beery"),
        dictgen::InsensitiveStr::Ascii("beries"),
        dictgen::InsensitiveStr::Ascii("berrries"),
        dictgen::InsensitiveStr::Ascii("berrry"),
        dictgen::InsensitiveStr::Ascii("bery"),
        dictgen::InsensitiveStr::Ascii("brary"),
        dictgen::InsensitiveStr::Ascii("brerry"),
        dictgen::InsensitiveStr::Ascii("burries"),
        dictgen::InsensitiveStr::Ascii("burry"),
    ],
    values: &[
        &["strawberry"],
        &["strawberry"],
        &["strawberry"],
        &["strawberries"],
        &["strawberries"],
        &["strawberry"],
        &["strawberry"],
        &["strawberry"],
        &["strawberry"],
        &["strawberries"],
        &["strawberry"],
    ],
    range: 4..=8,
};

static WORD_STRAV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRAV_CHILDREN),
    value: None,
};

pub static WORD_STRAV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ation")],
    values: &[&["starvation"]],
    range: 5..=5,
};

static WORD_STRAT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRAT_CHILDREN),
    value: Some(&["start", "strata"]),
};

pub static WORD_STRAT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("agically"),
        dictgen::InsensitiveStr::Ascii("agies"),
        dictgen::InsensitiveStr::Ascii("egems"),
        dictgen::InsensitiveStr::Ascii("egicaly"),
        dictgen::InsensitiveStr::Ascii("egice"),
        dictgen::InsensitiveStr::Ascii("egiclly"),
        dictgen::InsensitiveStr::Ascii("egis"),
        dictgen::InsensitiveStr::Ascii("egisch"),
        dictgen::InsensitiveStr::Ascii("egisk"),
        dictgen::InsensitiveStr::Ascii("egiske"),
        dictgen::InsensitiveStr::Ascii("gey"),
        dictgen::InsensitiveStr::Ascii("igically"),
        dictgen::InsensitiveStr::Ascii("led"),
    ],
    values: &[
        &["strategically"],
        &["strategies"],
        &["strategies"],
        &["strategically"],
        &["strategies"],
        &["strategically"],
        &["strategies"],
        &["strategic"],
        &["strategies"],
        &["strategies"],
        &["strategy"],
        &["strategically"],
        &["startled"],
    ],
    range: 3..=8,
};

static WORD_STRAN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRAN_CHILDREN),
    value: Some(&["strand", "strain"]),
};

pub static WORD_STRAN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gel"),
        dictgen::InsensitiveStr::Ascii("geshit"),
        dictgen::InsensitiveStr::Ascii("get"),
        dictgen::InsensitiveStr::Ascii("gets"),
        dictgen::InsensitiveStr::Ascii("glove"),
        dictgen::InsensitiveStr::Ascii("gly"),
        dictgen::InsensitiveStr::Ascii("gness"),
        dictgen::InsensitiveStr::Ascii("greal"),
    ],
    values: &[
        &["strangle"],
        &["strangest"],
        &["strangest"],
        &["strangest"],
        &["strangle"],
        &["strangely", "strange", "strangle"],
        &["strangeness"],
        &["strangle"],
    ],
    range: 3..=6,
};

static WORD_STRAM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRAM_CHILDREN),
    value: Some(&["steam", "stream", "tram"]),
};

pub static WORD_STRAM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ing"),
        dictgen::InsensitiveStr::Ascii("s"),
    ],
    values: &[&["streaming", "steaming"], &["steams", "streams", "trams"]],
    range: 1..=3,
};

static WORD_STRAI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRAI_CHILDREN),
    value: None,
};

pub static WORD_STRAI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ghforward"),
        dictgen::InsensitiveStr::Ascii("ghtden"),
        dictgen::InsensitiveStr::Ascii("ghted"),
        dictgen::InsensitiveStr::Ascii("ghtend"),
        dictgen::InsensitiveStr::Ascii("ghtenend"),
        dictgen::InsensitiveStr::Ascii("ghtforeward"),
        dictgen::InsensitiveStr::Ascii("ghtforwad"),
        dictgen::InsensitiveStr::Ascii("ghtfoward"),
        dictgen::InsensitiveStr::Ascii("ghtie"),
        dictgen::InsensitiveStr::Ascii("ghtin"),
        dictgen::InsensitiveStr::Ascii("ghtmen"),
        dictgen::InsensitiveStr::Ascii("ghtn"),
        dictgen::InsensitiveStr::Ascii("ghtned"),
        dictgen::InsensitiveStr::Ascii("ghtner"),
        dictgen::InsensitiveStr::Ascii("gnt"),
        dictgen::InsensitiveStr::Ascii("gntened"),
        dictgen::InsensitiveStr::Ascii("gt"),
        dictgen::InsensitiveStr::Ascii("gth"),
        dictgen::InsensitiveStr::Ascii("gthen"),
        dictgen::InsensitiveStr::Ascii("gthened"),
        dictgen::InsensitiveStr::Ascii("gthforward"),
        dictgen::InsensitiveStr::Ascii("nd"),
        dictgen::InsensitiveStr::Ascii("nes"),
        dictgen::InsensitiveStr::Ascii("ngs"),
        dictgen::InsensitiveStr::Ascii("tforward"),
    ],
    values: &[
        &["straightforward"],
        &["straightened"],
        &["straightened"],
        &["straightened"],
        &["straightened"],
        &["straightforward"],
        &["straightforward"],
        &["straightforward"],
        &["straighten"],
        &["straighten"],
        &["straighten"],
        &["straighten"],
        &["straightened"],
        &["straighten"],
        &["straighten"],
        &["straightened"],
        &["straight"],
        &["straight"],
        &["straighten"],
        &["straightened"],
        &["straightforward"],
        &["strained"],
        &["strains"],
        &["strains"],
        &["straightforward"],
    ],
    range: 2..=11,
};

static WORD_STRAG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRAG_CHILDREN),
    value: None,
};

pub static WORD_STRAG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("edy"),
        dictgen::InsensitiveStr::Ascii("egically"),
        dictgen::InsensitiveStr::Ascii("egy"),
        dictgen::InsensitiveStr::Ascii("etic"),
        dictgen::InsensitiveStr::Ascii("etically"),
        dictgen::InsensitiveStr::Ascii("eties"),
        dictgen::InsensitiveStr::Ascii("ety"),
    ],
    values: &[
        &["strategy", "tragedy"],
        &["strategically"],
        &["strategy"],
        &["strategic"],
        &["strategically"],
        &["strategies"],
        &["strategy"],
    ],
    range: 3..=8,
};

static WORD_STRAD_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRAD_CHILDREN),
    value: None,
};

pub static WORD_STRAD_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("egies"),
        dictgen::InsensitiveStr::Ascii("egy"),
    ],
    values: &[&["strategies"], &["strategy"]],
    range: 3..=5,
};

static WORD_STRAC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STRAC_CHILDREN),
    value: None,
};

pub static WORD_STRAC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("k")],
    values: &[&["stack", "track"]],
    range: 1..=1,
};

static WORD_STP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STP_CHILDREN),
    value: None,
};

pub static WORD_STP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("o")],
    values: &[&["stop"]],
    range: 1..=1,
};

static WORD_STO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STO_CHILDREN),
    value: None,
};

pub static WORD_STO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cahstic"),
        dictgen::InsensitiveStr::Ascii("castic"),
        dictgen::InsensitiveStr::Ascii("ckpilled"),
        dictgen::InsensitiveStr::Ascii("ckplie"),
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("ers"),
        dictgen::InsensitiveStr::Ascii("mache"),
        dictgen::InsensitiveStr::Ascii("mpted"),
        dictgen::InsensitiveStr::Ascii("mrfront"),
        dictgen::InsensitiveStr::Ascii("ng"),
        dictgen::InsensitiveStr::Ascii("ped"),
        dictgen::InsensitiveStr::Ascii("ping"),
        dictgen::InsensitiveStr::Ascii("pp"),
        dictgen::InsensitiveStr::Ascii("ppped"),
        dictgen::InsensitiveStr::Ascii("ppping"),
        dictgen::InsensitiveStr::Ascii("pps"),
        dictgen::InsensitiveStr::Ascii("pry"),
        dictgen::InsensitiveStr::Ascii("rag"),
        dictgen::InsensitiveStr::Ascii("reable"),
        dictgen::InsensitiveStr::Ascii("reage"),
        dictgen::InsensitiveStr::Ascii("ream"),
        dictgen::InsensitiveStr::Ascii("reble"),
        dictgen::InsensitiveStr::Ascii("reing"),
        dictgen::InsensitiveStr::Ascii("reis"),
        dictgen::InsensitiveStr::Ascii("relines"),
        dictgen::InsensitiveStr::Ascii("rise"),
        dictgen::InsensitiveStr::Ascii("rmade"),
        dictgen::InsensitiveStr::Ascii("rmde"),
        dictgen::InsensitiveStr::Ascii("rmend"),
        dictgen::InsensitiveStr::Ascii("rmfornt"),
        dictgen::InsensitiveStr::Ascii("rmfromt"),
        dictgen::InsensitiveStr::Ascii("rmfrount"),
        dictgen::InsensitiveStr::Ascii("rnegst"),
        dictgen::InsensitiveStr::Ascii("rnfront"),
        dictgen::InsensitiveStr::Ascii("rnghold"),
        dictgen::InsensitiveStr::Ascii("rys"),
        dictgen::InsensitiveStr::Ascii("ryteling"),
        dictgen::InsensitiveStr::Ascii("rytellling"),
        dictgen::InsensitiveStr::Ascii("yr"),
    ],
    values: &[
        &["stochastic"],
        &["stochastic"],
        &["stockpile"],
        &["stockpile"],
        &["store"],
        &["stores"],
        &["stomach"],
        &["stomped"],
        &["stormfront"],
        &["strong"],
        &["stopped"],
        &["stopping"],
        &["stop"],
        &["stopped"],
        &["stopping"],
        &["stops"],
        &["story"],
        &["storage"],
        &["storable"],
        &["storage"],
        &["stream"],
        &["storable"],
        &["storing"],
        &["storeys", "storeys", "stores"],
        &["storylines"],
        &["stories"],
        &["stormed"],
        &["stormed"],
        &["stormed"],
        &["stormfront"],
        &["stormfront"],
        &["stormfront"],
        &["strongest"],
        &["stormfront"],
        &["stronghold"],
        &["storeys", "storeys"],
        &["storytelling"],
        &["storytelling"],
        &["story"],
    ],
    range: 2..=10,
};

static WORD_STN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STN_CHILDREN),
    value: None,
};

pub static WORD_STN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ad"),
        dictgen::InsensitiveStr::Ascii("dard"),
    ],
    values: &[&["stand"], &["standard"]],
    range: 2..=4,
};

static WORD_STL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STL_CHILDREN),
    value: None,
};

pub static WORD_STL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aker"),
        dictgen::InsensitiveStr::Ascii("akers"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("ye"),
        dictgen::InsensitiveStr::Ascii("yes"),
        dictgen::InsensitiveStr::Ascii("yish"),
    ],
    values: &[
        &["stalker"],
        &["stalkers"],
        &["style"],
        &["style"],
        &["styles"],
        &["stylish"],
    ],
    range: 1..=5,
};

static WORD_STI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STI_CHILDREN),
    value: None,
};

pub static WORD_STI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("chted"),
        dictgen::InsensitiveStr::Ascii("chting"),
        dictgen::InsensitiveStr::Ascii("ckes"),
        dictgen::InsensitiveStr::Ascii("cthed"),
        dictgen::InsensitiveStr::Ascii("cthes"),
        dictgen::InsensitiveStr::Ascii("cthing"),
        dictgen::InsensitiveStr::Ascii("ffneing"),
        dictgen::InsensitiveStr::Ascii("ky"),
        dictgen::InsensitiveStr::Ascii("l"),
        dictgen::InsensitiveStr::Ascii("lus"),
        dictgen::InsensitiveStr::Ascii("milants"),
        dictgen::InsensitiveStr::Ascii("milated"),
        dictgen::InsensitiveStr::Ascii("mluating"),
        dictgen::InsensitiveStr::Ascii("mualted"),
        dictgen::InsensitiveStr::Ascii("mualting"),
        dictgen::InsensitiveStr::Ascii("mualtion"),
        dictgen::InsensitiveStr::Ascii("mulai"),
        dictgen::InsensitiveStr::Ascii("mulans"),
        dictgen::InsensitiveStr::Ascii("mulantes"),
        dictgen::InsensitiveStr::Ascii("mulas"),
        dictgen::InsensitiveStr::Ascii("mulat"),
        dictgen::InsensitiveStr::Ascii("mulatie"),
        dictgen::InsensitiveStr::Ascii("mulatin"),
        dictgen::InsensitiveStr::Ascii("mulaton"),
        dictgen::InsensitiveStr::Ascii("mulents"),
        dictgen::InsensitiveStr::Ascii("mulli"),
        dictgen::InsensitiveStr::Ascii("ngent"),
        dictgen::InsensitiveStr::Ascii("pped"),
        dictgen::InsensitiveStr::Ascii("ring"),
        dictgen::InsensitiveStr::Ascii("rker"),
        dictgen::InsensitiveStr::Ascii("rkers"),
        dictgen::InsensitiveStr::Ascii("rng"),
        dictgen::InsensitiveStr::Ascii("rngs"),
        dictgen::InsensitiveStr::Ascii("rr"),
        dictgen::InsensitiveStr::Ascii("rrig"),
        dictgen::InsensitiveStr::Ascii("rrs"),
        dictgen::InsensitiveStr::Ascii("tchs"),
        dictgen::InsensitiveStr::Ascii("vk"),
        dictgen::InsensitiveStr::Ascii("vks"),
    ],
    values: &[
        &["stitched"],
        &["stitching"],
        &["stickers"],
        &["stitched"],
        &["stitches"],
        &["stitching"],
        &["stiffening"],
        &["sticky"],
        &["still"],
        &["stylus"],
        &["stimulants"],
        &["stimulated"],
        &["stimulating"],
        &["stimulated"],
        &["stimulating"],
        &["stimulation"],
        &["stimuli"],
        &["stimulants"],
        &["stimulants"],
        &["stimulants"],
        &["stimulants"],
        &["stimulated"],
        &["stimulation"],
        &["stimulation"],
        &["stimulants"],
        &["stimuli"],
        &["stringent"],
        &["stripped"],
        &["stirring"],
        &["striker"],
        &["strikers"],
        &["string"],
        &["strings"],
        &["stir"],
        &["stirring"],
        &["stirs"],
        &["stitches"],
        &["stick"],
        &["sticks"],
    ],
    range: 1..=8,
};

static WORD_STE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STE_CHILDREN),
    value: None,
};

pub static WORD_STE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("adilly"),
        dictgen::InsensitiveStr::Ascii("adliy"),
        dictgen::InsensitiveStr::Ascii("alhty"),
        dictgen::InsensitiveStr::Ascii("althboy"),
        dictgen::InsensitiveStr::Ascii("althely"),
        dictgen::InsensitiveStr::Ascii("althify"),
        dictgen::InsensitiveStr::Ascii("althly"),
        dictgen::InsensitiveStr::Ascii("althray"),
        dictgen::InsensitiveStr::Ascii("alty"),
        dictgen::InsensitiveStr::Ascii("athly"),
        dictgen::InsensitiveStr::Ascii("eleries"),
        dictgen::InsensitiveStr::Ascii("eles"),
        dictgen::InsensitiveStr::Ascii("lathy"),
        dictgen::InsensitiveStr::Ascii("ngth"),
        dictgen::InsensitiveStr::Ascii("orid"),
        dictgen::InsensitiveStr::Ascii("ram"),
        dictgen::InsensitiveStr::Ascii("ramed"),
        dictgen::InsensitiveStr::Ascii("ramer"),
        dictgen::InsensitiveStr::Ascii("raming"),
        dictgen::InsensitiveStr::Ascii("rams"),
        dictgen::InsensitiveStr::Ascii("reotipe"),
        dictgen::InsensitiveStr::Ascii("reotipical"),
        dictgen::InsensitiveStr::Ascii("reotpye"),
        dictgen::InsensitiveStr::Ascii("reotpyes"),
        dictgen::InsensitiveStr::Ascii("reotpyical"),
        dictgen::InsensitiveStr::Ascii("reotpying"),
        dictgen::InsensitiveStr::Ascii("reotying"),
        dictgen::InsensitiveStr::Ascii("reotypcial"),
        dictgen::InsensitiveStr::Ascii("reotypeing"),
        dictgen::InsensitiveStr::Ascii("reotypers"),
        dictgen::InsensitiveStr::Ascii("reotypian"),
        dictgen::InsensitiveStr::Ascii("reotypying"),
        dictgen::InsensitiveStr::Ascii("riel"),
        dictgen::InsensitiveStr::Ascii("rilze"),
        dictgen::InsensitiveStr::Ascii("rio"),
        dictgen::InsensitiveStr::Ascii("riods"),
        dictgen::InsensitiveStr::Ascii("riotype"),
        dictgen::InsensitiveStr::Ascii("riotypes"),
        dictgen::InsensitiveStr::Ascii("riotypical"),
        dictgen::InsensitiveStr::Ascii("riotyping"),
        dictgen::InsensitiveStr::Ascii("rlie"),
        dictgen::InsensitiveStr::Ascii("roetype"),
        dictgen::InsensitiveStr::Ascii("roetypes"),
        dictgen::InsensitiveStr::Ascii("roetypical"),
        dictgen::InsensitiveStr::Ascii("roetyping"),
        dictgen::InsensitiveStr::Ascii("rotypes"),
        dictgen::InsensitiveStr::Ascii("ryotype"),
        dictgen::InsensitiveStr::Ascii("ryotypes"),
        dictgen::InsensitiveStr::Ascii("ryotypical"),
        dictgen::InsensitiveStr::Ascii("ryotyping"),
    ],
    values: &[
        &["steadily"],
        &["steadily"],
        &["stealthy"],
        &["stealthy"],
        &["stealthy"],
        &["stealthy"],
        &["stealthy"],
        &["stealthy"],
        &["stealthy"],
        &["stealthy"],
        &["steelers"],
        &["steelers"],
        &["stealthy"],
        &["strength"],
        &["steroid"],
        &["stream"],
        &["streamed"],
        &["streamer"],
        &["streaming"],
        &["streams"],
        &["stereotype"],
        &["stereotypical"],
        &["stereotypes"],
        &["stereotypes"],
        &["stereotypical"],
        &["stereotyping"],
        &["stereotyping"],
        &["stereotypical"],
        &["stereotyping"],
        &["stereotypes"],
        &["stereotyping"],
        &["stereotyping"],
        &["sterile"],
        &["sterile"],
        &["stereo"],
        &["steroids"],
        &["stereotype"],
        &["stereotypes"],
        &["stereotypical"],
        &["stereotyping"],
        &["sterile"],
        &["stereotype"],
        &["stereotypes"],
        &["stereotypical"],
        &["stereotyping"],
        &["stereotypes"],
        &["stereotype"],
        &["stereotypes"],
        &["stereotypical"],
        &["stereotyping"],
    ],
    range: 3..=10,
};

static WORD_STD_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STD_CHILDREN),
    value: None,
};

pub static WORD_STD_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("anard"),
        dictgen::InsensitiveStr::Ascii("anards"),
    ],
    values: &[&["standard"], &["standards"]],
    range: 5..=6,
};

static WORD_STC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STC_CHILDREN),
    value: None,
};

pub static WORD_STC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("okbrush")],
    values: &[&["stockbrush"]],
    range: 7..=7,
};

static WORD_STA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_STA_CHILDREN),
    value: None,
};

static WORD_STA_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    Some(&WORD_STAB_NODE),
    Some(&WORD_STAC_NODE),
    Some(&WORD_STAD_NODE),
    Some(&WORD_STAE_NODE),
    None,
    Some(&WORD_STAG_NODE),
    None,
    Some(&WORD_STAI_NODE),
    None,
    Some(&WORD_STAK_NODE),
    Some(&WORD_STAL_NODE),
    Some(&WORD_STAM_NODE),
    Some(&WORD_STAN_NODE),
    Some(&WORD_STAO_NODE),
    None,
    None,
    Some(&WORD_STAR_NODE),
    None,
    Some(&WORD_STAT_NODE),
    Some(&WORD_STAU_NODE),
    None,
    Some(&WORD_STAW_NODE),
    None,
    None,
    None,
];

static WORD_STAW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STAW_CHILDREN),
    value: None,
};

pub static WORD_STAW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("k")],
    values: &[&["stalk"]],
    range: 1..=1,
};

static WORD_STAU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STAU_CHILDREN),
    value: None,
};

pub static WORD_STAU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lk"),
        dictgen::InsensitiveStr::Ascii("ration"),
        dictgen::InsensitiveStr::Ascii("rday"),
        dictgen::InsensitiveStr::Ascii("rdays"),
        dictgen::InsensitiveStr::Ascii("s"),
        dictgen::InsensitiveStr::Ascii("tes"),
    ],
    values: &[
        &["stalk"],
        &["saturation"],
        &["saturday"],
        &["saturdays"],
        &["status"],
        &["statues"],
    ],
    range: 1..=6,
};

static WORD_STAT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STAT_CHILDREN),
    value: None,
};

pub static WORD_STAT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("amenet"),
        dictgen::InsensitiveStr::Ascii("amenets"),
        dictgen::InsensitiveStr::Ascii("eman"),
        dictgen::InsensitiveStr::Ascii("emanet"),
        dictgen::InsensitiveStr::Ascii("ememts"),
        dictgen::InsensitiveStr::Ascii("emen"),
        dictgen::InsensitiveStr::Ascii("emenet"),
        dictgen::InsensitiveStr::Ascii("emenets"),
        dictgen::InsensitiveStr::Ascii("emet"),
        dictgen::InsensitiveStr::Ascii("emnts"),
        dictgen::InsensitiveStr::Ascii("i"),
        dictgen::InsensitiveStr::Ascii("icly"),
        dictgen::InsensitiveStr::Ascii("ictic"),
        dictgen::InsensitiveStr::Ascii("ictics"),
        dictgen::InsensitiveStr::Ascii("icts"),
        dictgen::InsensitiveStr::Ascii("ionair"),
        dictgen::InsensitiveStr::Ascii("ionairy"),
        dictgen::InsensitiveStr::Ascii("iond"),
        dictgen::InsensitiveStr::Ascii("ionerad"),
        dictgen::InsensitiveStr::Ascii("ionnary"),
        dictgen::InsensitiveStr::Ascii("iony"),
        dictgen::InsensitiveStr::Ascii("isfied"),
        dictgen::InsensitiveStr::Ascii("isfies"),
        dictgen::InsensitiveStr::Ascii("isfy"),
        dictgen::InsensitiveStr::Ascii("isfying"),
        dictgen::InsensitiveStr::Ascii("isitc"),
        dictgen::InsensitiveStr::Ascii("isitcal"),
        dictgen::InsensitiveStr::Ascii("isitcally"),
        dictgen::InsensitiveStr::Ascii("isitcs"),
        dictgen::InsensitiveStr::Ascii("isitics"),
        dictgen::InsensitiveStr::Ascii("iskt"),
        dictgen::InsensitiveStr::Ascii("istacally"),
        dictgen::InsensitiveStr::Ascii("istc"),
        dictgen::InsensitiveStr::Ascii("istcal"),
        dictgen::InsensitiveStr::Ascii("isticaly"),
        dictgen::InsensitiveStr::Ascii("isticly"),
        dictgen::InsensitiveStr::Ascii("istisch"),
        dictgen::InsensitiveStr::Ascii("istisk"),
        dictgen::InsensitiveStr::Ascii("itic"),
        dictgen::InsensitiveStr::Ascii("itics"),
        dictgen::InsensitiveStr::Ascii("its"),
        dictgen::InsensitiveStr::Ascii("menet"),
        dictgen::InsensitiveStr::Ascii("menmt"),
        dictgen::InsensitiveStr::Ascii("ment"),
        dictgen::InsensitiveStr::Ascii("ments"),
        dictgen::InsensitiveStr::Ascii("rt"),
        dictgen::InsensitiveStr::Ascii("sit"),
        dictgen::InsensitiveStr::Ascii("sitical"),
        dictgen::InsensitiveStr::Ascii("tistic"),
        dictgen::InsensitiveStr::Ascii("tues"),
        dictgen::InsensitiveStr::Ascii("ubar"),
        dictgen::InsensitiveStr::Ascii("uer"),
        dictgen::InsensitiveStr::Ascii("uets"),
        dictgen::InsensitiveStr::Ascii("up"),
        dictgen::InsensitiveStr::Ascii("use"),
        dictgen::InsensitiveStr::Ascii("user"),
        dictgen::InsensitiveStr::Ascii("uss"),
        dictgen::InsensitiveStr::Ascii("usses"),
        dictgen::InsensitiveStr::Ascii("ustics"),
        dictgen::InsensitiveStr::Ascii("uts"),
    ],
    values: &[
        &["statement"],
        &["statements"],
        &["statesman"],
        &["statement"],
        &["statements"],
        &["statement"],
        &["statement"],
        &["statements"],
        &["statement"],
        &["statements"],
        &["statuses"],
        &["statically"],
        &["statistic"],
        &["statistics"],
        &["statist"],
        &["stationary"],
        &["stationary"],
        &["stationed"],
        &["stationed"],
        &["stationary"],
        &["stationary"],
        &["satisfied"],
        &["satisfies"],
        &["satisfy"],
        &["satisfying"],
        &["statistic"],
        &["statistical"],
        &["statistically"],
        &["statistics"],
        &["statistics"],
        &["statist"],
        &["statistically"],
        &["statistic"],
        &["statistical"],
        &["statistically"],
        &["statistical"],
        &["statistics"],
        &["statistics"],
        &["statistic"],
        &["statistics"],
        &["statist"],
        &["statement"],
        &["statement"],
        &["statement"],
        &["statements"],
        &["start"],
        &["statist"],
        &["statistical"],
        &["statistic"],
        &["statutes"],
        &["statusbar"],
        &["stature"],
        &["statutes"],
        &["startup"],
        &["statutes"],
        &["stature"],
        &["status"],
        &["statuses"],
        &["statistics"],
        &["statutes"],
    ],
    range: 1..=9,
};

static WORD_STAR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STAR_CHILDREN),
    value: None,
};

pub static WORD_STAR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ation"),
        dictgen::InsensitiveStr::Ascii("d"),
        dictgen::InsensitiveStr::Ascii("dard"),
        dictgen::InsensitiveStr::Ascii("dardized"),
        dictgen::InsensitiveStr::Ascii("ight"),
        dictgen::InsensitiveStr::Ascii("ighten"),
        dictgen::InsensitiveStr::Ascii("ightened"),
        dictgen::InsensitiveStr::Ascii("ightforward"),
        dictgen::InsensitiveStr::Ascii("ined"),
        dictgen::InsensitiveStr::Ascii("ins"),
        dictgen::InsensitiveStr::Ascii("lted"),
        dictgen::InsensitiveStr::Ascii("nation"),
        dictgen::InsensitiveStr::Ascii("td"),
        dictgen::InsensitiveStr::Ascii("tde"),
        dictgen::InsensitiveStr::Ascii("tegic"),
        dictgen::InsensitiveStr::Ascii("tegically"),
        dictgen::InsensitiveStr::Ascii("tegies"),
        dictgen::InsensitiveStr::Ascii("tegy"),
        dictgen::InsensitiveStr::Ascii("teld"),
        dictgen::InsensitiveStr::Ascii("tet"),
        dictgen::InsensitiveStr::Ascii("tign"),
        dictgen::InsensitiveStr::Ascii("tin"),
        dictgen::InsensitiveStr::Ascii("tlisteneing"),
        dictgen::InsensitiveStr::Ascii("tlxde"),
        dictgen::InsensitiveStr::Ascii("tnig"),
        dictgen::InsensitiveStr::Ascii("tsup"),
        dictgen::InsensitiveStr::Ascii("tting"),
        dictgen::InsensitiveStr::Ascii("tupbus"),
        dictgen::InsensitiveStr::Ascii("tus"),
        dictgen::InsensitiveStr::Ascii("up"),
        dictgen::InsensitiveStr::Ascii("ups"),
        dictgen::InsensitiveStr::Ascii("wberries"),
        dictgen::InsensitiveStr::Ascii("wberry"),
    ],
    values: &[
        &["starvation"],
        &["start"],
        &["standard"],
        &["standardized"],
        &["straight"],
        &["straighten"],
        &["straightened"],
        &["straightforward"],
        &["strained"],
        &["strains"],
        &["startled"],
        &["starvation"],
        &["started"],
        &["startled"],
        &["strategic"],
        &["strategically"],
        &["strategies"],
        &["strategy"],
        &["startled"],
        &["started"],
        &["starting"],
        &["starting"],
        &["startlistening"],
        &["startled"],
        &["starting"],
        &["startups"],
        &["starting"],
        &["startups"],
        &["startups"],
        &["startup"],
        &["startups"],
        &["strawberries"],
        &["strawberry"],
    ],
    range: 1..=11,
};

static WORD_STAO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STAO_CHILDREN),
    value: None,
};

pub static WORD_STAO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("shi")],
    values: &[&["satoshi"]],
    range: 3..=3,
};

static WORD_STAN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STAN_CHILDREN),
    value: None,
};

pub static WORD_STAN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cels"),
        dictgen::InsensitiveStr::Ascii("cers"),
        dictgen::InsensitiveStr::Ascii("dalown"),
        dictgen::InsensitiveStr::Ascii("dar"),
        dictgen::InsensitiveStr::Ascii("darad"),
        dictgen::InsensitiveStr::Ascii("dardss"),
        dictgen::InsensitiveStr::Ascii("darized"),
        dictgen::InsensitiveStr::Ascii("dars"),
        dictgen::InsensitiveStr::Ascii("dart"),
        dictgen::InsensitiveStr::Ascii("dartd"),
        dictgen::InsensitiveStr::Ascii("dartds"),
        dictgen::InsensitiveStr::Ascii("dartisation"),
        dictgen::InsensitiveStr::Ascii("dartisator"),
        dictgen::InsensitiveStr::Ascii("dartised"),
        dictgen::InsensitiveStr::Ascii("dartization"),
        dictgen::InsensitiveStr::Ascii("dartizator"),
        dictgen::InsensitiveStr::Ascii("dartized"),
        dictgen::InsensitiveStr::Ascii("darts"),
        dictgen::InsensitiveStr::Ascii("datd"),
        dictgen::InsensitiveStr::Ascii("dbay"),
        dictgen::InsensitiveStr::Ascii("dbuy"),
        dictgen::InsensitiveStr::Ascii("derdized"),
        dictgen::InsensitiveStr::Ascii("dtard"),
        dictgen::InsensitiveStr::Ascii("dy"),
        dictgen::InsensitiveStr::Ascii("gant"),
        dictgen::InsensitiveStr::Ascii("ge"),
        dictgen::InsensitiveStr::Ascii("p"),
    ],
    values: &[
        &["stances"],
        &["stances"],
        &["standalone"],
        &["standard"],
        &["standard"],
        &["standards"],
        &["standardized"],
        &["standards"],
        &["standard"],
        &["standard"],
        &["standards"],
        &["standardisation"],
        &["standardiser"],
        &["standardised"],
        &["standardization"],
        &["standardizer"],
        &["standardized"],
        &["standards"],
        &["standard"],
        &["standby"],
        &["standby"],
        &["standardized"],
        &["standard"],
        &["standby", "sandy", "standee"],
        &["stagnant"],
        &["strange"],
        &["stamp"],
    ],
    range: 1..=11,
};

static WORD_STAM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STAM_CHILDREN),
    value: None,
};

pub static WORD_STAM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("inia"),
        dictgen::InsensitiveStr::Ascii("nia"),
        dictgen::InsensitiveStr::Ascii("pade"),
        dictgen::InsensitiveStr::Ascii("peed"),
    ],
    values: &[&["stamina"], &["stamina"], &["stamped"], &["stamped"]],
    range: 3..=4,
};

static WORD_STAL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STAL_CHILDREN),
    value: None,
};

pub static WORD_STAL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("agtite"),
        dictgen::InsensitiveStr::Ascii("ekrs"),
        dictgen::InsensitiveStr::Ascii("kear"),
        dictgen::InsensitiveStr::Ascii("kes"),
    ],
    values: &[&["stalactite"], &["stalkers"], &["stalker"], &["stalkers"]],
    range: 3..=6,
};

static WORD_STAK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STAK_CHILDREN),
    value: None,
};

pub static WORD_STAK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eboard"),
        dictgen::InsensitiveStr::Ascii("eboarding"),
        dictgen::InsensitiveStr::Ascii("ler"),
        dictgen::InsensitiveStr::Ascii("lers"),
    ],
    values: &[
        &["skateboard"],
        &["skateboarding"],
        &["stalker"],
        &["stalkers"],
    ],
    range: 3..=9,
};

static WORD_STAI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STAI_CHILDREN),
    value: None,
};

pub static WORD_STAI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cally"),
        dictgen::InsensitiveStr::Ascii("dum"),
        dictgen::InsensitiveStr::Ascii("dums"),
        dictgen::InsensitiveStr::Ascii("nlees"),
        dictgen::InsensitiveStr::Ascii("on"),
        dictgen::InsensitiveStr::Ascii("ons"),
        dictgen::InsensitiveStr::Ascii("tion"),
        dictgen::InsensitiveStr::Ascii("tions"),
    ],
    values: &[
        &["statically"],
        &["stadium"],
        &["stadiums"],
        &["stainless"],
        &["station"],
        &["stations"],
        &["station"],
        &["stations"],
    ],
    range: 2..=5,
};

static WORD_STAG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STAG_CHILDREN),
    value: None,
};

pub static WORD_STAG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("garing"),
        dictgen::InsensitiveStr::Ascii("gerring"),
        dictgen::InsensitiveStr::Ascii("gerwing"),
        dictgen::InsensitiveStr::Ascii("nat"),
    ],
    values: &[
        &["staggering"],
        &["staggering"],
        &["staggering"],
        &["stagnant"],
    ],
    range: 3..=7,
};

static WORD_STAE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STAE_CHILDREN),
    value: Some(&["state"]),
};

pub static WORD_STAE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ment")],
    values: &[&["statement"]],
    range: 4..=4,
};

static WORD_STAD_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STAD_CHILDREN),
    value: None,
};

pub static WORD_STAD_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ius"),
        dictgen::InsensitiveStr::Ascii("nard"),
        dictgen::InsensitiveStr::Ascii("nardisation"),
        dictgen::InsensitiveStr::Ascii("nardised"),
        dictgen::InsensitiveStr::Ascii("nardising"),
        dictgen::InsensitiveStr::Ascii("nardization"),
        dictgen::InsensitiveStr::Ascii("nardized"),
        dictgen::InsensitiveStr::Ascii("nardizing"),
        dictgen::InsensitiveStr::Ascii("nards"),
        dictgen::InsensitiveStr::Ascii("uim"),
        dictgen::InsensitiveStr::Ascii("uims"),
    ],
    values: &[
        &["stadiums"],
        &["standard"],
        &["standardisation"],
        &["standardised"],
        &["standardising"],
        &["standardization"],
        &["standardized"],
        &["standardizing"],
        &["standards"],
        &["stadium"],
        &["stadiums"],
    ],
    range: 3..=11,
};

static WORD_STAC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STAC_CHILDREN),
    value: None,
};

pub static WORD_STAC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("h"),
        dictgen::InsensitiveStr::Ascii("kk"),
    ],
    values: &[&["stack"], &["stack"]],
    range: 1..=2,
};

static WORD_STAB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_STAB_CHILDREN),
    value: None,
};

pub static WORD_STAB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alization"),
        dictgen::InsensitiveStr::Ascii("elized"),
        dictgen::InsensitiveStr::Ascii("ilizare"),
        dictgen::InsensitiveStr::Ascii("ilizied"),
        dictgen::InsensitiveStr::Ascii("ilizier"),
        dictgen::InsensitiveStr::Ascii("ilizies"),
        dictgen::InsensitiveStr::Ascii("ilty"),
        dictgen::InsensitiveStr::Ascii("ilzied"),
        dictgen::InsensitiveStr::Ascii("liize"),
        dictgen::InsensitiveStr::Ascii("lility"),
        dictgen::InsensitiveStr::Ascii("lilization"),
        dictgen::InsensitiveStr::Ascii("lize"),
        dictgen::InsensitiveStr::Ascii("lizied"),
    ],
    values: &[
        &["stabilization"],
        &["stabilized"],
        &["stabilize"],
        &["stabilize"],
        &["stabilize"],
        &["stabilize"],
        &["stability"],
        &["stabilized"],
        &["stabilize"],
        &["stability"],
        &["stabilization"],
        &["stabilize"],
        &["stabilized"],
    ],
    range: 4..=10,
};

static WORD_SS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SS_CHILDREN),
    value: None,
};

pub static WORD_SS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ee"),
        dictgen::InsensitiveStr::Ascii("ome"),
    ],
    values: &[&["see"], &["some"]],
    range: 2..=3,
};

static WORD_SR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SR_CHILDREN),
    value: None,
};

pub static WORD_SR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cipt"),
        dictgen::InsensitiveStr::Ascii("cipts"),
        dictgen::InsensitiveStr::Ascii("eampropinfo"),
        dictgen::InsensitiveStr::Ascii("eenshot"),
        dictgen::InsensitiveStr::Ascii("eenshots"),
        dictgen::InsensitiveStr::Ascii("eturns"),
        dictgen::InsensitiveStr::Ascii("ew"),
        dictgen::InsensitiveStr::Ascii("iarcha"),
        dictgen::InsensitiveStr::Ascii("ikeout"),
        dictgen::InsensitiveStr::Ascii("ing"),
        dictgen::InsensitiveStr::Ascii("ings"),
        dictgen::InsensitiveStr::Ascii("ink"),
        dictgen::InsensitiveStr::Ascii("inkd"),
        dictgen::InsensitiveStr::Ascii("inked"),
        dictgen::InsensitiveStr::Ascii("inking"),
        dictgen::InsensitiveStr::Ascii("ipt"),
        dictgen::InsensitiveStr::Ascii("ipts"),
        dictgen::InsensitiveStr::Ascii("iraca"),
        dictgen::InsensitiveStr::Ascii("irachia"),
        dictgen::InsensitiveStr::Ascii("irachra"),
        dictgen::InsensitiveStr::Ascii("ollbar"),
        dictgen::InsensitiveStr::Ascii("ouce"),
        dictgen::InsensitiveStr::Ascii("pouts"),
        dictgen::InsensitiveStr::Ascii("riacha"),
        dictgen::InsensitiveStr::Ascii("ting"),
        dictgen::InsensitiveStr::Ascii("tings"),
        dictgen::InsensitiveStr::Ascii("tructure"),
        dictgen::InsensitiveStr::Ascii("ucture"),
        dictgen::InsensitiveStr::Ascii("uctures"),
        dictgen::InsensitiveStr::Ascii("unk"),
        dictgen::InsensitiveStr::Ascii("unken"),
        dictgen::InsensitiveStr::Ascii("unkn"),
        dictgen::InsensitiveStr::Ascii("yacuse"),
        dictgen::InsensitiveStr::Ascii("yians"),
        dictgen::InsensitiveStr::Ascii("yinge"),
    ],
    values: &[
        &["script"],
        &["scripts"],
        &["streampropinfo"],
        &["screenshot"],
        &["screenshots"],
        &["returns"],
        &["screw", "shrew", "sew"],
        &["sriracha"],
        &["strikeout"],
        &["string"],
        &["strings"],
        &["shrink"],
        &["shrunk"],
        &["shrunk"],
        &["shrinking"],
        &["script"],
        &["scripts"],
        &["sriracha"],
        &["sriracha"],
        &["sriracha"],
        &["scrollbar"],
        &["source"],
        &["sprouts"],
        &["sriracha"],
        &["string", "sorting"],
        &["strings"],
        &["structure"],
        &["structure"],
        &["structures"],
        &["shrunk"],
        &["shrunken"],
        &["shrunken"],
        &["syracuse"],
        &["syrians"],
        &["syringe"],
    ],
    range: 2..=11,
};

static WORD_SQ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SQ_CHILDREN),
    value: None,
};

pub static WORD_SQ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("are"),
        dictgen::InsensitiveStr::Ascii("ared"),
        dictgen::InsensitiveStr::Ascii("ares"),
        dictgen::InsensitiveStr::Ascii("ash"),
        dictgen::InsensitiveStr::Ascii("ashed"),
        dictgen::InsensitiveStr::Ascii("ashing"),
        dictgen::InsensitiveStr::Ascii("audron"),
        dictgen::InsensitiveStr::Ascii("aure"),
        dictgen::InsensitiveStr::Ascii("aured"),
        dictgen::InsensitiveStr::Ascii("aurely"),
        dictgen::InsensitiveStr::Ascii("aures"),
        dictgen::InsensitiveStr::Ascii("euaky"),
        dictgen::InsensitiveStr::Ascii("euence"),
        dictgen::InsensitiveStr::Ascii("iurtle"),
        dictgen::InsensitiveStr::Ascii("iushy"),
        dictgen::InsensitiveStr::Ascii("uadroon"),
        dictgen::InsensitiveStr::Ascii("uardon"),
        dictgen::InsensitiveStr::Ascii("uareds"),
        dictgen::InsensitiveStr::Ascii("uarey"),
        dictgen::InsensitiveStr::Ascii("uarley"),
        dictgen::InsensitiveStr::Ascii("uashgin"),
        dictgen::InsensitiveStr::Ascii("ueakey"),
        dictgen::InsensitiveStr::Ascii("ueakly"),
        dictgen::InsensitiveStr::Ascii("uence"),
        dictgen::InsensitiveStr::Ascii("uirel"),
        dictgen::InsensitiveStr::Ascii("uirl"),
        dictgen::InsensitiveStr::Ascii("uirle"),
        dictgen::InsensitiveStr::Ascii("uirlte"),
        dictgen::InsensitiveStr::Ascii("uirrelies"),
        dictgen::InsensitiveStr::Ascii("uirrelius"),
        dictgen::InsensitiveStr::Ascii("uirrells"),
        dictgen::InsensitiveStr::Ascii("uirrelus"),
        dictgen::InsensitiveStr::Ascii("uirrl"),
        dictgen::InsensitiveStr::Ascii("uirrle"),
        dictgen::InsensitiveStr::Ascii("uirrles"),
        dictgen::InsensitiveStr::Ascii("uirrtle"),
        dictgen::InsensitiveStr::Ascii("uirte"),
        dictgen::InsensitiveStr::Ascii("uirtel"),
        dictgen::InsensitiveStr::Ascii("uishey"),
        dictgen::InsensitiveStr::Ascii("uishly"),
        dictgen::InsensitiveStr::Ascii("urared"),
        dictgen::InsensitiveStr::Ascii("uritle"),
        dictgen::InsensitiveStr::Ascii("urriel"),
        dictgen::InsensitiveStr::Ascii("urriels"),
        dictgen::InsensitiveStr::Ascii("urtile"),
        dictgen::InsensitiveStr::Ascii("usihy"),
    ],
    values: &[
        &["square"],
        &["squared"],
        &["squares"],
        &["squash"],
        &["squashed"],
        &["squashing"],
        &["squadron"],
        &["square"],
        &["squared"],
        &["squarely"],
        &["squares"],
        &["squeaky"],
        &["sequence"],
        &["squirtle"],
        &["squishy"],
        &["squadron"],
        &["squadron"],
        &["squares"],
        &["squarely"],
        &["squarely"],
        &["squashing"],
        &["squeaky"],
        &["squeaky"],
        &["sequence"],
        &["squirtle", "squirrel"],
        &["squirrel"],
        &["squirrel"],
        &["squirtle"],
        &["squirrels"],
        &["squirrels"],
        &["squirrels"],
        &["squirrels"],
        &["squirrel"],
        &["squirrel"],
        &["squirrels"],
        &["squirrel"],
        &["squirtle"],
        &["squirtle"],
        &["squishy"],
        &["squishy"],
        &["squared"],
        &["squirtle"],
        &["squirrel"],
        &["squirrels"],
        &["squirtle"],
        &["squishy"],
    ],
    range: 3..=9,
};

static WORD_SP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SP_CHILDREN),
    value: None,
};

static WORD_SP_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SPA_NODE),
    None,
    Some(&WORD_SPC_NODE),
    None,
    Some(&WORD_SPE_NODE),
    None,
    None,
    Some(&WORD_SPH_NODE),
    Some(&WORD_SPI_NODE),
    None,
    None,
    Some(&WORD_SPL_NODE),
    None,
    None,
    Some(&WORD_SPO_NODE),
    Some(&WORD_SPP_NODE),
    None,
    Some(&WORD_SPR_NODE),
    Some(&WORD_SPS_NODE),
    Some(&WORD_SPT_NODE),
    Some(&WORD_SPU_NODE),
    None,
    Some(&WORD_SPW_NODE),
    None,
    None,
    None,
];

static WORD_SPW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPW_CHILDREN),
    value: None,
};

pub static WORD_SPW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aned"),
        dictgen::InsensitiveStr::Ascii("aning"),
    ],
    values: &[&["spawned"], &["spawning"]],
    range: 4..=5,
};

static WORD_SPU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPU_CHILDREN),
    value: None,
};

pub static WORD_SPU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("rios"),
        dictgen::InsensitiveStr::Ascii("rrious"),
    ],
    values: &[&["spurious"], &["spurious"]],
    range: 4..=6,
};

static WORD_SPT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPT_CHILDREN),
    value: None,
};

pub static WORD_SPT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("intf")],
    values: &[&["sprintf"]],
    range: 4..=4,
};

static WORD_SPS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPS_CHILDREN),
    value: None,
};

pub static WORD_SPS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ace"),
        dictgen::InsensitiveStr::Ascii("aces"),
    ],
    values: &[&["space"], &["spaces"]],
    range: 3..=4,
};

static WORD_SPR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPR_CHILDREN),
    value: None,
};

pub static WORD_SPR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("akling"),
        dictgen::InsensitiveStr::Ascii("ayade"),
        dictgen::InsensitiveStr::Ascii("eaded"),
        dictgen::InsensitiveStr::Ascii("eadhseet"),
        dictgen::InsensitiveStr::Ascii("eadhseets"),
        dictgen::InsensitiveStr::Ascii("eadsheat"),
        dictgen::InsensitiveStr::Ascii("eadsheats"),
        dictgen::InsensitiveStr::Ascii("eadsheeds"),
        dictgen::InsensitiveStr::Ascii("eadsheeet"),
        dictgen::InsensitiveStr::Ascii("eadsheeters"),
        dictgen::InsensitiveStr::Ascii("eadsheeticus"),
        dictgen::InsensitiveStr::Ascii("eadshet"),
        dictgen::InsensitiveStr::Ascii("eadshets"),
        dictgen::InsensitiveStr::Ascii("easheet"),
        dictgen::InsensitiveStr::Ascii("easheets"),
        dictgen::InsensitiveStr::Ascii("ech"),
        dictgen::InsensitiveStr::Ascii("ecial"),
        dictgen::InsensitiveStr::Ascii("ecialized"),
        dictgen::InsensitiveStr::Ascii("ecially"),
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("edsheet"),
        dictgen::InsensitiveStr::Ascii("eedsheet"),
        dictgen::InsensitiveStr::Ascii("inf"),
        dictgen::InsensitiveStr::Ascii("ingfeild"),
        dictgen::InsensitiveStr::Ascii("ingfeld"),
        dictgen::InsensitiveStr::Ascii("ingfied"),
        dictgen::InsensitiveStr::Ascii("ingfiled"),
        dictgen::InsensitiveStr::Ascii("ingst"),
        dictgen::InsensitiveStr::Ascii("inke"),
        dictgen::InsensitiveStr::Ascii("inkel"),
        dictgen::InsensitiveStr::Ascii("inkeld"),
        dictgen::InsensitiveStr::Ascii("inklered"),
        dictgen::InsensitiveStr::Ascii("intas"),
        dictgen::InsensitiveStr::Ascii("iritual"),
        dictgen::InsensitiveStr::Ascii("itual"),
        dictgen::InsensitiveStr::Ascii("oels"),
        dictgen::InsensitiveStr::Ascii("oon"),
        dictgen::InsensitiveStr::Ascii("otsmanship"),
        dictgen::InsensitiveStr::Ascii("outes"),
    ],
    values: &[
        &["sparkling"],
        &["sprayed"],
        &["spread"],
        &["spreadsheet"],
        &["spreadsheets"],
        &["spreadsheet"],
        &["spreadsheets"],
        &["spreadsheets"],
        &["spreadsheets"],
        &["spreadsheets"],
        &["spreadsheets"],
        &["spreadsheet"],
        &["spreadsheets"],
        &["spreadsheet"],
        &["spreadsheets"],
        &["speech"],
        &["special"],
        &["specialized"],
        &["specially"],
        &["spread"],
        &["spreadsheet"],
        &["spreadsheet"],
        &["sprintf"],
        &["springfield"],
        &["springfield"],
        &["springfield"],
        &["springfield"],
        &["sprints"],
        &["sprinkle"],
        &["sprinkle"],
        &["sprinkled"],
        &["sprinkled"],
        &["sprints"],
        &["spiritual"],
        &["spiritual"],
        &["sproles"],
        &["spoon"],
        &["sportsmanship"],
        &["sprouts"],
    ],
    range: 2..=12,
};

static WORD_SPP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPP_CHILDREN),
    value: None,
};

pub static WORD_SPP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eches"),
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("ort"),
        dictgen::InsensitiveStr::Ascii("orted"),
        dictgen::InsensitiveStr::Ascii("orting"),
        dictgen::InsensitiveStr::Ascii("orts"),
    ],
    values: &[
        &["speeches"],
        &["speed", "sped", "sipped", "sapped", "supped", "sopped"],
        &["support"],
        &["supported"],
        &["supporting"],
        &["supports"],
    ],
    range: 2..=6,
};

static WORD_SPO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPO_CHILDREN),
    value: None,
};

pub static WORD_SPO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ace"),
        dictgen::InsensitiveStr::Ascii("ilerd"),
        dictgen::InsensitiveStr::Ascii("iles"),
        dictgen::InsensitiveStr::Ascii("itfy"),
        dictgen::InsensitiveStr::Ascii("lied"),
        dictgen::InsensitiveStr::Ascii("liers"),
        dictgen::InsensitiveStr::Ascii("natenous"),
        dictgen::InsensitiveStr::Ascii("natenously"),
        dictgen::InsensitiveStr::Ascii("natneous"),
        dictgen::InsensitiveStr::Ascii("nosred"),
        dictgen::InsensitiveStr::Ascii("nser"),
        dictgen::InsensitiveStr::Ascii("nsered"),
        dictgen::InsensitiveStr::Ascii("nsers"),
        dictgen::InsensitiveStr::Ascii("nsership"),
        dictgen::InsensitiveStr::Ascii("nsord"),
        dictgen::InsensitiveStr::Ascii("nsorees"),
        dictgen::InsensitiveStr::Ascii("nsores"),
        dictgen::InsensitiveStr::Ascii("nsorhip"),
        dictgen::InsensitiveStr::Ascii("nsorhips"),
        dictgen::InsensitiveStr::Ascii("nsorhsip"),
        dictgen::InsensitiveStr::Ascii("nsorise"),
        dictgen::InsensitiveStr::Ascii("nsorshop"),
        dictgen::InsensitiveStr::Ascii("ntaenous"),
        dictgen::InsensitiveStr::Ascii("ntaenously"),
        dictgen::InsensitiveStr::Ascii("ntainous"),
        dictgen::InsensitiveStr::Ascii("ntainously"),
        dictgen::InsensitiveStr::Ascii("ntaneos"),
        dictgen::InsensitiveStr::Ascii("ntaneosly"),
        dictgen::InsensitiveStr::Ascii("ntaneoulsy"),
        dictgen::InsensitiveStr::Ascii("ntaneouly"),
        dictgen::InsensitiveStr::Ascii("ntanes"),
        dictgen::InsensitiveStr::Ascii("ntaneuos"),
        dictgen::InsensitiveStr::Ascii("ntaneuosly"),
        dictgen::InsensitiveStr::Ascii("ntaneus"),
        dictgen::InsensitiveStr::Ascii("ntanious"),
        dictgen::InsensitiveStr::Ascii("ntaniously"),
        dictgen::InsensitiveStr::Ascii("ntanous"),
        dictgen::InsensitiveStr::Ascii("ntanuously"),
        dictgen::InsensitiveStr::Ascii("nteanous"),
        dictgen::InsensitiveStr::Ascii("nteanously"),
        dictgen::InsensitiveStr::Ascii("nteneous"),
        dictgen::InsensitiveStr::Ascii("nteneously"),
        dictgen::InsensitiveStr::Ascii("nzored"),
        dictgen::InsensitiveStr::Ascii("onfulls"),
        dictgen::InsensitiveStr::Ascii("ranos"),
        dictgen::InsensitiveStr::Ascii("ratic"),
        dictgen::InsensitiveStr::Ascii("rious"),
        dictgen::InsensitiveStr::Ascii("rles"),
        dictgen::InsensitiveStr::Ascii("rstmanship"),
        dictgen::InsensitiveStr::Ascii("rtmansship"),
        dictgen::InsensitiveStr::Ascii("rtsmamship"),
        dictgen::InsensitiveStr::Ascii("rtsmansship"),
        dictgen::InsensitiveStr::Ascii("rtsmenship"),
        dictgen::InsensitiveStr::Ascii("ruts"),
        dictgen::InsensitiveStr::Ascii("tfiy"),
        dictgen::InsensitiveStr::Ascii("tifiy"),
        dictgen::InsensitiveStr::Ascii("tifty"),
    ],
    values: &[
        &["space"],
        &["spoiled"],
        &["spoilers"],
        &["spotify"],
        &["spoiled"],
        &["spoilers"],
        &["spontaneous"],
        &["spontaneously"],
        &["spontaneous"],
        &["sponsored"],
        &["sponsor"],
        &["sponsored"],
        &["sponsors"],
        &["sponsorship"],
        &["sponsored"],
        &["sponsors"],
        &["sponsors"],
        &["sponsorship"],
        &["sponsorship"],
        &["sponsorship"],
        &["sponsors"],
        &["sponsorship"],
        &["spontaneous"],
        &["spontaneously"],
        &["spontaneous"],
        &["spontaneously"],
        &["spontaneous"],
        &["spontaneously"],
        &["spontaneously"],
        &["spontaneously"],
        &["spontaneous"],
        &["spontaneous"],
        &["spontaneously"],
        &["spontaneous"],
        &["spontaneous"],
        &["spontaneously"],
        &["spontaneous"],
        &["spontaneously"],
        &["spontaneous"],
        &["spontaneously"],
        &["spontaneous"],
        &["spontaneously"],
        &["sponsored"],
        &["spoonfuls"],
        &["sopranos"],
        &["sporadic"],
        &["spurious"],
        &["sproles"],
        &["sportsmanship"],
        &["sportsmanship"],
        &["sportsmanship"],
        &["sportsmanship"],
        &["sportsmanship"],
        &["sprouts"],
        &["spotify"],
        &["spotify"],
        &["spotify"],
    ],
    range: 3..=11,
};

static WORD_SPL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPL_CHILDREN),
    value: None,
};

pub static WORD_SPL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aton"),
        dictgen::InsensitiveStr::Ascii("atooon"),
        dictgen::InsensitiveStr::Ascii("eling"),
        dictgen::InsensitiveStr::Ascii("ig"),
        dictgen::InsensitiveStr::Ascii("igs"),
        dictgen::InsensitiveStr::Ascii("iitting"),
        dictgen::InsensitiveStr::Ascii("ite"),
        dictgen::InsensitiveStr::Ascii("iting"),
        dictgen::InsensitiveStr::Ascii("itner"),
        dictgen::InsensitiveStr::Ascii("itted"),
        dictgen::InsensitiveStr::Ascii("ittng"),
        dictgen::InsensitiveStr::Ascii("ittr"),
        dictgen::InsensitiveStr::Ascii("litting"),
    ],
    values: &[
        &["splatoon"],
        &["splatoon"],
        &["spelling"],
        &["split", "splign"],
        &["splits"],
        &["splitting"],
        &["split", "splits", "splice"],
        &["splitting"],
        &["splinter"],
        &["split"],
        &["splitting"],
        &["splitter"],
        &["splitting"],
    ],
    range: 2..=7,
};

static WORD_SPI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPI_CHILDREN),
    value: None,
};

pub static WORD_SPI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cific"),
        dictgen::InsensitiveStr::Ascii("le"),
        dictgen::InsensitiveStr::Ascii("lnter"),
        dictgen::InsensitiveStr::Ascii("ltter"),
        dictgen::InsensitiveStr::Ascii("ltting"),
        dictgen::InsensitiveStr::Ascii("ndel"),
        dictgen::InsensitiveStr::Ascii("ndrel"),
        dictgen::InsensitiveStr::Ascii("nlcok"),
        dictgen::InsensitiveStr::Ascii("nock"),
        dictgen::InsensitiveStr::Ascii("ritd"),
        dictgen::InsensitiveStr::Ascii("rites"),
        dictgen::InsensitiveStr::Ascii("ritis"),
        dictgen::InsensitiveStr::Ascii("ritualiy"),
        dictgen::InsensitiveStr::Ascii("rituallity"),
        dictgen::InsensitiveStr::Ascii("rituallly"),
        dictgen::InsensitiveStr::Ascii("ritualty"),
        dictgen::InsensitiveStr::Ascii("ritualy"),
        dictgen::InsensitiveStr::Ascii("rituella"),
        dictgen::InsensitiveStr::Ascii("ritus"),
        dictgen::InsensitiveStr::Ascii("rtied"),
        dictgen::InsensitiveStr::Ascii("rtiuality"),
        dictgen::InsensitiveStr::Ascii("rtiually"),
        dictgen::InsensitiveStr::Ascii("rutuality"),
        dictgen::InsensitiveStr::Ascii("rutually"),
        dictgen::InsensitiveStr::Ascii("tirually"),
    ],
    values: &[
        &["specific"],
        &["spite", "spiral"],
        &["splinter"],
        &["splitter"],
        &["splitting"],
        &["spindle"],
        &["spindle"],
        &["spinlock"],
        &["spinlock"],
        &["spirited"],
        &["spirits"],
        &["spirits"],
        &["spiritually"],
        &["spiritually"],
        &["spiritually"],
        &["spirituality"],
        &["spiritually"],
        &["spiritually"],
        &["spirits"],
        &["spirited"],
        &["spirituality"],
        &["spiritually"],
        &["spirituality"],
        &["spiritually"],
        &["spiritually"],
    ],
    range: 2..=10,
};

static WORD_SPH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPH_CHILDREN),
    value: None,
};

pub static WORD_SPH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("agetti"),
        dictgen::InsensitiveStr::Ascii("ereos"),
    ],
    values: &[&["spaghetti"], &["spheres"]],
    range: 5..=6,
};

static WORD_SPE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SPE_CHILDREN),
    value: None,
};

static WORD_SPE_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SPEA_NODE),
    None,
    Some(&WORD_SPEC_NODE),
    Some(&WORD_SPED_NODE),
    Some(&WORD_SPEE_NODE),
    Some(&WORD_SPEF_NODE),
    None,
    Some(&WORD_SPEH_NODE),
    Some(&WORD_SPEI_NODE),
    None,
    None,
    Some(&WORD_SPEL_NODE),
    None,
    Some(&WORD_SPEN_NODE),
    None,
    Some(&WORD_SPEP_NODE),
    None,
    Some(&WORD_SPER_NODE),
    Some(&WORD_SPES_NODE),
    Some(&WORD_SPET_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_SPEZ_NODE),
];

static WORD_SPEZ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEZ_CHILDREN),
    value: None,
};

pub static WORD_SPEZ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ialisation"),
        dictgen::InsensitiveStr::Ascii("ific"),
        dictgen::InsensitiveStr::Ascii("ified"),
        dictgen::InsensitiveStr::Ascii("ify"),
    ],
    values: &[
        &["specialisation", "specialisation"],
        &["specific"],
        &["specified"],
        &["specify"],
    ],
    range: 3..=10,
};

static WORD_SPET_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPET_CHILDREN),
    value: None,
};

pub static WORD_SPET_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ember")],
    values: &[&["september"]],
    range: 5..=5,
};

static WORD_SPES_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPES_CHILDREN),
    value: None,
};

pub static WORD_SPES_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hal"),
        dictgen::InsensitiveStr::Ascii("hally"),
        dictgen::InsensitiveStr::Ascii("hel"),
        dictgen::InsensitiveStr::Ascii("helly"),
        dictgen::InsensitiveStr::Ascii("ialisation"),
        dictgen::InsensitiveStr::Ascii("ifically"),
        dictgen::InsensitiveStr::Ascii("ification"),
        dictgen::InsensitiveStr::Ascii("ifications"),
        dictgen::InsensitiveStr::Ascii("ified"),
        dictgen::InsensitiveStr::Ascii("ify"),
    ],
    values: &[
        &["special"],
        &["specially", "especially"],
        &["special"],
        &["specially", "especially"],
        &["specialisation"],
        &["specifically"],
        &["specification"],
        &["specifications"],
        &["specified"],
        &["specify"],
    ],
    range: 3..=10,
};

static WORD_SPER_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPER_CHILDREN),
    value: None,
};

pub static WORD_SPER_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ate"),
        dictgen::InsensitiveStr::Ascii("ately"),
        dictgen::InsensitiveStr::Ascii("matozoan"),
    ],
    values: &[&["separate"], &["separately"], &["spermatozoon"]],
    range: 3..=8,
};

static WORD_SPEP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEP_CHILDREN),
    value: None,
};

pub static WORD_SPEP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arate"),
        dictgen::InsensitiveStr::Ascii("arated"),
        dictgen::InsensitiveStr::Ascii("arating"),
        dictgen::InsensitiveStr::Ascii("aration"),
        dictgen::InsensitiveStr::Ascii("arator"),
        dictgen::InsensitiveStr::Ascii("c"),
    ],
    values: &[
        &["separate"],
        &["separated"],
        &["separating"],
        &["separation"],
        &["separator"],
        &["spec"],
    ],
    range: 1..=7,
};

static WORD_SPEN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEN_CHILDREN),
    value: None,
};

pub static WORD_SPEN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("dour")],
    values: &[&["splendour"]],
    range: 4..=4,
};

static WORD_SPEL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEL_CHILDREN),
    value: None,
};

pub static WORD_SPEL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ing"),
        dictgen::InsensitiveStr::Ascii("lig"),
        dictgen::InsensitiveStr::Ascii("lign"),
        dictgen::InsensitiveStr::Ascii("lshecking"),
    ],
    values: &[
        &["spelling"],
        &["spelling"],
        &["spelling"],
        &["spellchecking"],
    ],
    range: 3..=9,
};

static WORD_SPEI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEI_CHILDREN),
    value: None,
};

pub static WORD_SPEI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cal"),
        dictgen::InsensitiveStr::Ascii("calist"),
        dictgen::InsensitiveStr::Ascii("cally"),
        dictgen::InsensitiveStr::Ascii("cals"),
        dictgen::InsensitiveStr::Ascii("ces"),
        dictgen::InsensitiveStr::Ascii("cfied"),
        dictgen::InsensitiveStr::Ascii("cific"),
        dictgen::InsensitiveStr::Ascii("cified"),
        dictgen::InsensitiveStr::Ascii("cify"),
    ],
    values: &[
        &["special"],
        &["specialist"],
        &["specially"],
        &["specials"],
        &["species"],
        &["specified"],
        &["specific"],
        &["specified"],
        &["specify"],
    ],
    range: 3..=6,
};

static WORD_SPEH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEH_CHILDREN),
    value: None,
};

pub static WORD_SPEH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("res"),
        dictgen::InsensitiveStr::Ascii("rical"),
    ],
    values: &[&["spheres"], &["spherical"]],
    range: 3..=5,
};

static WORD_SPEF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SPEF_CHILDREN),
    value: None,
};

static WORD_SPEF_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SPEFA_NODE),
    None,
    Some(&WORD_SPEFC_NODE),
    None,
    Some(&WORD_SPEFE_NODE),
    None,
    None,
    None,
    Some(&WORD_SPEFI_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_SPEFY_NODE),
    None,
];

static WORD_SPEFY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFY_CHILDREN),
    value: Some(&["specify"]),
};

pub static WORD_SPEFY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ing")],
    values: &[&["specifying"]],
    range: 3..=3,
};

static WORD_SPEFI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SPEFI_CHILDREN),
    value: None,
};

static WORD_SPEFI_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SPEFIA_NODE),
    None,
    Some(&WORD_SPEFIC_NODE),
    None,
    Some(&WORD_SPEFIE_NODE),
    Some(&WORD_SPEFIF_NODE),
    None,
    None,
    Some(&WORD_SPEFII_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_SPEFIX_NODE),
    Some(&WORD_SPEFIY_NODE),
    None,
];

static WORD_SPEFIY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFIY_CHILDREN),
    value: Some(&["specify"]),
};

pub static WORD_SPEFIY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ing")],
    values: &[&["specifying"]],
    range: 3..=3,
};

static WORD_SPEFIX_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFIX_CHILDREN),
    value: None,
};

pub static WORD_SPEFIX_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ally"),
        dictgen::InsensitiveStr::Ascii("ation"),
        dictgen::InsensitiveStr::Ascii("ations"),
        dictgen::InsensitiveStr::Ascii("eid"),
        dictgen::InsensitiveStr::Ascii("eir"),
        dictgen::InsensitiveStr::Ascii("eirs"),
        dictgen::InsensitiveStr::Ascii("eis"),
        dictgen::InsensitiveStr::Ascii("iable"),
        dictgen::InsensitiveStr::Ascii("ic"),
        dictgen::InsensitiveStr::Ascii("ically"),
        dictgen::InsensitiveStr::Ascii("ication"),
        dictgen::InsensitiveStr::Ascii("ications"),
        dictgen::InsensitiveStr::Ascii("ics"),
        dictgen::InsensitiveStr::Ascii("ied"),
        dictgen::InsensitiveStr::Ascii("ier"),
        dictgen::InsensitiveStr::Ascii("iers"),
        dictgen::InsensitiveStr::Ascii("ies"),
        dictgen::InsensitiveStr::Ascii("ifed"),
        dictgen::InsensitiveStr::Ascii("ifer"),
        dictgen::InsensitiveStr::Ascii("ifers"),
        dictgen::InsensitiveStr::Ascii("ifes"),
        dictgen::InsensitiveStr::Ascii("y"),
        dictgen::InsensitiveStr::Ascii("ying"),
    ],
    values: &[
        &["specifically"],
        &["specification"],
        &["specifications"],
        &["specified"],
        &["specifier"],
        &["specifiers"],
        &["specifies"],
        &["specifiable"],
        &["specific"],
        &["specifically"],
        &["specification"],
        &["specifications"],
        &["specifics"],
        &["specified"],
        &["specifier"],
        &["specifiers"],
        &["specifies"],
        &["specified"],
        &["specifier"],
        &["specifiers"],
        &["specifies"],
        &["specify"],
        &["specifying"],
    ],
    range: 1..=8,
};

static WORD_SPEFII_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFII_CHILDREN),
    value: None,
};

pub static WORD_SPEFII_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("able"),
        dictgen::InsensitiveStr::Ascii("c"),
        dictgen::InsensitiveStr::Ascii("cally"),
        dictgen::InsensitiveStr::Ascii("cation"),
        dictgen::InsensitiveStr::Ascii("cations"),
        dictgen::InsensitiveStr::Ascii("cs"),
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("ers"),
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("fally"),
        dictgen::InsensitiveStr::Ascii("fation"),
        dictgen::InsensitiveStr::Ascii("fations"),
        dictgen::InsensitiveStr::Ascii("feid"),
        dictgen::InsensitiveStr::Ascii("feir"),
        dictgen::InsensitiveStr::Ascii("feirs"),
        dictgen::InsensitiveStr::Ascii("feis"),
        dictgen::InsensitiveStr::Ascii("fiable"),
        dictgen::InsensitiveStr::Ascii("fic"),
        dictgen::InsensitiveStr::Ascii("fically"),
        dictgen::InsensitiveStr::Ascii("fication"),
        dictgen::InsensitiveStr::Ascii("fications"),
        dictgen::InsensitiveStr::Ascii("fics"),
        dictgen::InsensitiveStr::Ascii("fied"),
        dictgen::InsensitiveStr::Ascii("fier"),
        dictgen::InsensitiveStr::Ascii("fiers"),
        dictgen::InsensitiveStr::Ascii("fies"),
        dictgen::InsensitiveStr::Ascii("fifed"),
        dictgen::InsensitiveStr::Ascii("fifer"),
        dictgen::InsensitiveStr::Ascii("fifers"),
        dictgen::InsensitiveStr::Ascii("fifes"),
        dictgen::InsensitiveStr::Ascii("fy"),
        dictgen::InsensitiveStr::Ascii("fying"),
    ],
    values: &[
        &["specifiable"],
        &["specific"],
        &["specifically"],
        &["specification"],
        &["specifications"],
        &["specifics"],
        &["specified"],
        &["specifier"],
        &["specifiers"],
        &["specifies"],
        &["specifically"],
        &["specification"],
        &["specifications"],
        &["specified"],
        &["specifier"],
        &["specifiers"],
        &["specifies"],
        &["specifiable"],
        &["specific"],
        &["specifically"],
        &["specification"],
        &["specifications"],
        &["specifics"],
        &["specified"],
        &["specifier"],
        &["specifiers"],
        &["specifies"],
        &["specified"],
        &["specifier"],
        &["specifiers"],
        &["specifies"],
        &["specify"],
        &["specifying"],
    ],
    range: 1..=9,
};

static WORD_SPEFIF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFIF_CHILDREN),
    value: None,
};

pub static WORD_SPEFIF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ally"),
        dictgen::InsensitiveStr::Ascii("ation"),
        dictgen::InsensitiveStr::Ascii("ations"),
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("eid"),
        dictgen::InsensitiveStr::Ascii("eir"),
        dictgen::InsensitiveStr::Ascii("eirs"),
        dictgen::InsensitiveStr::Ascii("eis"),
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("ers"),
        dictgen::InsensitiveStr::Ascii("es"),
        dictgen::InsensitiveStr::Ascii("iable"),
        dictgen::InsensitiveStr::Ascii("ic"),
        dictgen::InsensitiveStr::Ascii("ically"),
        dictgen::InsensitiveStr::Ascii("ication"),
        dictgen::InsensitiveStr::Ascii("ications"),
        dictgen::InsensitiveStr::Ascii("ics"),
        dictgen::InsensitiveStr::Ascii("ied"),
        dictgen::InsensitiveStr::Ascii("ier"),
        dictgen::InsensitiveStr::Ascii("iers"),
        dictgen::InsensitiveStr::Ascii("ies"),
        dictgen::InsensitiveStr::Ascii("ifed"),
        dictgen::InsensitiveStr::Ascii("ifer"),
        dictgen::InsensitiveStr::Ascii("ifers"),
        dictgen::InsensitiveStr::Ascii("ifes"),
        dictgen::InsensitiveStr::Ascii("y"),
        dictgen::InsensitiveStr::Ascii("ying"),
    ],
    values: &[
        &["specifically"],
        &["specification"],
        &["specifications"],
        &["specified"],
        &["specified"],
        &["specifier"],
        &["specifiers"],
        &["specifies"],
        &["specifier"],
        &["specifiers"],
        &["specifies"],
        &["specifiable"],
        &["specific"],
        &["specifically"],
        &["specification"],
        &["specifications"],
        &["specifics"],
        &["specified"],
        &["specifier"],
        &["specifiers"],
        &["specifies"],
        &["specified"],
        &["specifier"],
        &["specifiers"],
        &["specifies"],
        &["specify"],
        &["specifying"],
    ],
    range: 1..=8,
};

static WORD_SPEFIE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFIE_CHILDREN),
    value: None,
};

pub static WORD_SPEFIE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("d"),
        dictgen::InsensitiveStr::Ascii("r"),
        dictgen::InsensitiveStr::Ascii("rs"),
        dictgen::InsensitiveStr::Ascii("s"),
    ],
    values: &[
        &["specified"],
        &["specifier"],
        &["specifiers"],
        &["specifies"],
    ],
    range: 1..=2,
};

static WORD_SPEFIC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SPEFIC_CHILDREN),
    value: Some(&["specific"]),
};

static WORD_SPEFIC_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SPEFICA_NODE),
    None,
    None,
    None,
    Some(&WORD_SPEFICE_NODE),
    None,
    None,
    None,
    Some(&WORD_SPEFICI_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_SPEFICS_NODE),
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_SPEFICY_NODE),
    None,
];

static WORD_SPEFICY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFICY_CHILDREN),
    value: Some(&["specify"]),
};

pub static WORD_SPEFICY_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[dictgen::InsensitiveStr::Ascii("ing")],
        values: &[&["specifying"]],
        range: 3..=3,
    };

static WORD_SPEFICS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFICS_CHILDREN),
    value: Some(&["specifics"]),
};

pub static WORD_SPEFICS_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[],
        values: &[],
        range: 0..=0,
    };

static WORD_SPEFICI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SPEFICI_CHILDREN),
    value: None,
};

static WORD_SPEFICI_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SPEFICIA_NODE),
    None,
    Some(&WORD_SPEFICIC_NODE),
    None,
    Some(&WORD_SPEFICIE_NODE),
    Some(&WORD_SPEFICIF_NODE),
    None,
    None,
    Some(&WORD_SPEFICII_NODE),
    None,
    None,
    Some(&WORD_SPEFICIL_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_SPEFICIT_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_SPEFICIY_NODE),
    None,
];

static WORD_SPEFICIY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFICIY_CHILDREN),
    value: Some(&["specify"]),
};

pub static WORD_SPEFICIY_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[dictgen::InsensitiveStr::Ascii("ing")],
        values: &[&["specifying"]],
        range: 3..=3,
    };

static WORD_SPEFICIT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFICIT_CHILDREN),
    value: None,
};

pub static WORD_SPEFICIT_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[
            dictgen::InsensitiveStr::Ascii("ally"),
            dictgen::InsensitiveStr::Ascii("ation"),
            dictgen::InsensitiveStr::Ascii("ations"),
            dictgen::InsensitiveStr::Ascii("eid"),
            dictgen::InsensitiveStr::Ascii("eir"),
            dictgen::InsensitiveStr::Ascii("eirs"),
            dictgen::InsensitiveStr::Ascii("eis"),
            dictgen::InsensitiveStr::Ascii("iable"),
            dictgen::InsensitiveStr::Ascii("ic"),
            dictgen::InsensitiveStr::Ascii("ically"),
            dictgen::InsensitiveStr::Ascii("ication"),
            dictgen::InsensitiveStr::Ascii("ications"),
            dictgen::InsensitiveStr::Ascii("ics"),
            dictgen::InsensitiveStr::Ascii("ied"),
            dictgen::InsensitiveStr::Ascii("ier"),
            dictgen::InsensitiveStr::Ascii("iers"),
            dictgen::InsensitiveStr::Ascii("ies"),
            dictgen::InsensitiveStr::Ascii("ifed"),
            dictgen::InsensitiveStr::Ascii("ifer"),
            dictgen::InsensitiveStr::Ascii("ifers"),
            dictgen::InsensitiveStr::Ascii("ifes"),
            dictgen::InsensitiveStr::Ascii("y"),
        ],
        values: &[
            &["specifically"],
            &["specification"],
            &["specifications"],
            &["specified"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
            &["specifiable"],
            &["specific"],
            &["specifically"],
            &["specification"],
            &["specifications"],
            &["specifics"],
            &["specified"],
            &["specifier"],
            &["specifiers"],
            &["specificities"],
            &["specified"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
            &["specificity"],
        ],
        range: 1..=8,
    };

static WORD_SPEFICIL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFICIL_CHILDREN),
    value: None,
};

pub static WORD_SPEFICIL_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[
            dictgen::InsensitiveStr::Ascii("lally"),
            dictgen::InsensitiveStr::Ascii("lation"),
            dictgen::InsensitiveStr::Ascii("lations"),
            dictgen::InsensitiveStr::Ascii("leid"),
            dictgen::InsensitiveStr::Ascii("leir"),
            dictgen::InsensitiveStr::Ascii("leirs"),
            dictgen::InsensitiveStr::Ascii("leis"),
            dictgen::InsensitiveStr::Ascii("liable"),
            dictgen::InsensitiveStr::Ascii("lic"),
            dictgen::InsensitiveStr::Ascii("lically"),
            dictgen::InsensitiveStr::Ascii("lication"),
            dictgen::InsensitiveStr::Ascii("lications"),
            dictgen::InsensitiveStr::Ascii("lics"),
            dictgen::InsensitiveStr::Ascii("lied"),
            dictgen::InsensitiveStr::Ascii("lier"),
            dictgen::InsensitiveStr::Ascii("liers"),
            dictgen::InsensitiveStr::Ascii("lies"),
            dictgen::InsensitiveStr::Ascii("lifed"),
            dictgen::InsensitiveStr::Ascii("lifer"),
            dictgen::InsensitiveStr::Ascii("lifers"),
            dictgen::InsensitiveStr::Ascii("lifes"),
            dictgen::InsensitiveStr::Ascii("ly"),
        ],
        values: &[
            &["specifically"],
            &["specification"],
            &["specifications"],
            &["specified"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
            &["specifiable"],
            &["specific"],
            &["specifically"],
            &["specification"],
            &["specifications"],
            &["specifics"],
            &["specified"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
            &["specified"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
            &["specifically"],
        ],
        range: 2..=9,
    };

static WORD_SPEFICII_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFICII_CHILDREN),
    value: None,
};

pub static WORD_SPEFICII_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[
            dictgen::InsensitiveStr::Ascii("able"),
            dictgen::InsensitiveStr::Ascii("c"),
            dictgen::InsensitiveStr::Ascii("cally"),
            dictgen::InsensitiveStr::Ascii("cation"),
            dictgen::InsensitiveStr::Ascii("cations"),
            dictgen::InsensitiveStr::Ascii("cs"),
            dictgen::InsensitiveStr::Ascii("ed"),
            dictgen::InsensitiveStr::Ascii("er"),
            dictgen::InsensitiveStr::Ascii("ers"),
            dictgen::InsensitiveStr::Ascii("es"),
            dictgen::InsensitiveStr::Ascii("fed"),
            dictgen::InsensitiveStr::Ascii("fer"),
            dictgen::InsensitiveStr::Ascii("fers"),
            dictgen::InsensitiveStr::Ascii("fes"),
        ],
        values: &[
            &["specifiable"],
            &["specific"],
            &["specifically"],
            &["specification"],
            &["specifications"],
            &["specifics"],
            &["specified"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
            &["specified"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
        ],
        range: 1..=7,
    };

static WORD_SPEFICIF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFICIF_CHILDREN),
    value: None,
};

pub static WORD_SPEFICIF_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[
            dictgen::InsensitiveStr::Ascii("ally"),
            dictgen::InsensitiveStr::Ascii("ation"),
            dictgen::InsensitiveStr::Ascii("ations"),
            dictgen::InsensitiveStr::Ascii("c"),
            dictgen::InsensitiveStr::Ascii("cally"),
            dictgen::InsensitiveStr::Ascii("cation"),
            dictgen::InsensitiveStr::Ascii("cations"),
            dictgen::InsensitiveStr::Ascii("cs"),
            dictgen::InsensitiveStr::Ascii("ed"),
            dictgen::InsensitiveStr::Ascii("eid"),
            dictgen::InsensitiveStr::Ascii("eir"),
            dictgen::InsensitiveStr::Ascii("eirs"),
            dictgen::InsensitiveStr::Ascii("eis"),
            dictgen::InsensitiveStr::Ascii("er"),
            dictgen::InsensitiveStr::Ascii("ers"),
            dictgen::InsensitiveStr::Ascii("es"),
            dictgen::InsensitiveStr::Ascii("iable"),
            dictgen::InsensitiveStr::Ascii("ic"),
            dictgen::InsensitiveStr::Ascii("ically"),
            dictgen::InsensitiveStr::Ascii("ication"),
            dictgen::InsensitiveStr::Ascii("ications"),
            dictgen::InsensitiveStr::Ascii("ics"),
            dictgen::InsensitiveStr::Ascii("ied"),
            dictgen::InsensitiveStr::Ascii("ier"),
            dictgen::InsensitiveStr::Ascii("iers"),
            dictgen::InsensitiveStr::Ascii("ies"),
            dictgen::InsensitiveStr::Ascii("ifed"),
            dictgen::InsensitiveStr::Ascii("ifer"),
            dictgen::InsensitiveStr::Ascii("ifers"),
            dictgen::InsensitiveStr::Ascii("ifes"),
            dictgen::InsensitiveStr::Ascii("y"),
            dictgen::InsensitiveStr::Ascii("ying"),
        ],
        values: &[
            &["specifically"],
            &["specification"],
            &["specifications"],
            &["specific"],
            &["specifically"],
            &["specification"],
            &["specifications"],
            &["specifics"],
            &["specified"],
            &["specified"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
            &["specifiable"],
            &["specific"],
            &["specifically"],
            &["specification"],
            &["specifications"],
            &["specifics"],
            &["specified"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
            &["specified"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
            &["specify"],
            &["specifying"],
        ],
        range: 1..=8,
    };

static WORD_SPEFICIE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFICIE_CHILDREN),
    value: None,
};

pub static WORD_SPEFICIE_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[
            dictgen::InsensitiveStr::Ascii("d"),
            dictgen::InsensitiveStr::Ascii("id"),
            dictgen::InsensitiveStr::Ascii("ir"),
            dictgen::InsensitiveStr::Ascii("irs"),
            dictgen::InsensitiveStr::Ascii("is"),
            dictgen::InsensitiveStr::Ascii("r"),
            dictgen::InsensitiveStr::Ascii("rs"),
            dictgen::InsensitiveStr::Ascii("s"),
        ],
        values: &[
            &["specified"],
            &["specified"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
        ],
        range: 1..=3,
    };

static WORD_SPEFICIC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFICIC_CHILDREN),
    value: Some(&["specific"]),
};

pub static WORD_SPEFICIC_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[
            dictgen::InsensitiveStr::Ascii("ally"),
            dictgen::InsensitiveStr::Ascii("ation"),
            dictgen::InsensitiveStr::Ascii("ations"),
            dictgen::InsensitiveStr::Ascii("s"),
        ],
        values: &[
            &["specifically"],
            &["specification"],
            &["specifications"],
            &["specifics"],
        ],
        range: 1..=6,
    };

static WORD_SPEFICIA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFICIA_CHILDREN),
    value: None,
};

pub static WORD_SPEFICIA_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[
            dictgen::InsensitiveStr::Ascii("ble"),
            dictgen::InsensitiveStr::Ascii("llally"),
            dictgen::InsensitiveStr::Ascii("llation"),
            dictgen::InsensitiveStr::Ascii("llations"),
            dictgen::InsensitiveStr::Ascii("lleid"),
            dictgen::InsensitiveStr::Ascii("lleir"),
            dictgen::InsensitiveStr::Ascii("lleirs"),
            dictgen::InsensitiveStr::Ascii("lleis"),
            dictgen::InsensitiveStr::Ascii("lliable"),
            dictgen::InsensitiveStr::Ascii("llic"),
            dictgen::InsensitiveStr::Ascii("llically"),
            dictgen::InsensitiveStr::Ascii("llication"),
            dictgen::InsensitiveStr::Ascii("llications"),
            dictgen::InsensitiveStr::Ascii("llics"),
            dictgen::InsensitiveStr::Ascii("llied"),
            dictgen::InsensitiveStr::Ascii("llier"),
            dictgen::InsensitiveStr::Ascii("lliers"),
            dictgen::InsensitiveStr::Ascii("llies"),
            dictgen::InsensitiveStr::Ascii("llifed"),
            dictgen::InsensitiveStr::Ascii("llifer"),
            dictgen::InsensitiveStr::Ascii("llifers"),
            dictgen::InsensitiveStr::Ascii("llifes"),
            dictgen::InsensitiveStr::Ascii("lly"),
            dictgen::InsensitiveStr::Ascii("tion"),
            dictgen::InsensitiveStr::Ascii("tions"),
        ],
        values: &[
            &["specifiable"],
            &["specifically"],
            &["specification"],
            &["specifications"],
            &["specified"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
            &["specifiable"],
            &["specific"],
            &["specifically"],
            &["specification"],
            &["specifications"],
            &["specifics"],
            &["specified"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
            &["specified"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
            &["specifically"],
            &["specification"],
            &["specifications"],
        ],
        range: 3..=10,
    };

static WORD_SPEFICE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFICE_CHILDREN),
    value: None,
};

pub static WORD_SPEFICE_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[
            dictgen::InsensitiveStr::Ascii("d"),
            dictgen::InsensitiveStr::Ascii("id"),
            dictgen::InsensitiveStr::Ascii("ir"),
            dictgen::InsensitiveStr::Ascii("irs"),
            dictgen::InsensitiveStr::Ascii("is"),
            dictgen::InsensitiveStr::Ascii("r"),
            dictgen::InsensitiveStr::Ascii("rs"),
            dictgen::InsensitiveStr::Ascii("s"),
        ],
        values: &[
            &["specified"],
            &["specified"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
            &["specifier"],
            &["specifiers"],
            &["specifies"],
        ],
        range: 1..=3,
    };

static WORD_SPEFICA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFICA_CHILDREN),
    value: None,
};

pub static WORD_SPEFICA_CHILDREN: dictgen::DictTable<&'static [&'static str]> =
    dictgen::DictTable {
        keys: &[
            dictgen::InsensitiveStr::Ascii("ble"),
            dictgen::InsensitiveStr::Ascii("lly"),
            dictgen::InsensitiveStr::Ascii("tion"),
            dictgen::InsensitiveStr::Ascii("tions"),
        ],
        values: &[
            &["specifiable"],
            &["specifically"],
            &["specification"],
            &["specifications"],
        ],
        range: 3..=5,
    };

static WORD_SPEFIA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFIA_CHILDREN),
    value: None,
};

pub static WORD_SPEFIA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ble"),
        dictgen::InsensitiveStr::Ascii("l"),
    ],
    values: &[&["specifiable"], &["special"]],
    range: 1..=3,
};

static WORD_SPEFE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFE_CHILDREN),
    value: None,
};

pub static WORD_SPEFE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("id"),
        dictgen::InsensitiveStr::Ascii("ir"),
        dictgen::InsensitiveStr::Ascii("irs"),
        dictgen::InsensitiveStr::Ascii("is"),
    ],
    values: &[
        &["specified"],
        &["specifier"],
        &["specifiers"],
        &["specifies"],
    ],
    range: 2..=3,
};

static WORD_SPEFC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFC_CHILDREN),
    value: None,
};

pub static WORD_SPEFC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ifiable"),
        dictgen::InsensitiveStr::Ascii("ific"),
        dictgen::InsensitiveStr::Ascii("ifically"),
        dictgen::InsensitiveStr::Ascii("ification"),
        dictgen::InsensitiveStr::Ascii("ifications"),
        dictgen::InsensitiveStr::Ascii("ifics"),
        dictgen::InsensitiveStr::Ascii("ifieid"),
        dictgen::InsensitiveStr::Ascii("ifieir"),
        dictgen::InsensitiveStr::Ascii("ifieirs"),
        dictgen::InsensitiveStr::Ascii("ifieis"),
        dictgen::InsensitiveStr::Ascii("ifiy"),
        dictgen::InsensitiveStr::Ascii("ifiying"),
    ],
    values: &[
        &["specifiable"],
        &["specific"],
        &["specifically"],
        &["specification"],
        &["specifications"],
        &["specifics"],
        &["specified"],
        &["specifier"],
        &["specifiers"],
        &["specifies"],
        &["specify"],
        &["specifying"],
    ],
    range: 4..=10,
};

static WORD_SPEFA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEFA_CHILDREN),
    value: None,
};

pub static WORD_SPEFA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lly"),
        dictgen::InsensitiveStr::Ascii("tion"),
        dictgen::InsensitiveStr::Ascii("tions"),
    ],
    values: &[
        &["specially", "specifically"],
        &["separation", "specification"],
        &["separations", "specifications"],
    ],
    range: 3..=5,
};

static WORD_SPEE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEE_CHILDREN),
    value: None,
};

pub static WORD_SPEE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ak"),
        dictgen::InsensitiveStr::Ascii("aking"),
        dictgen::InsensitiveStr::Ascii("cheasy"),
        dictgen::InsensitiveStr::Ascii("chers"),
        dictgen::InsensitiveStr::Ascii("chs"),
        dictgen::InsensitiveStr::Ascii("ling"),
        dictgen::InsensitiveStr::Ascii("lling"),
        dictgen::InsensitiveStr::Ascii("p"),
        dictgen::InsensitiveStr::Ascii("ped"),
        dictgen::InsensitiveStr::Ascii("ping"),
    ],
    values: &[
        &["speak"],
        &["speaking"],
        &["speeches"],
        &["speeches"],
        &["speeches"],
        &["spelling"],
        &["spelling"],
        &["sleep"],
        &["sped"],
        &["sleeping"],
    ],
    range: 1..=6,
};

static WORD_SPED_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPED_CHILDREN),
    value: None,
};

pub static WORD_SPED_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ific"),
        dictgen::InsensitiveStr::Ascii("ified"),
        dictgen::InsensitiveStr::Ascii("ify"),
    ],
    values: &[&["specific"], &["specified"], &["specify"]],
    range: 3..=5,
};

static WORD_SPEC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SPEC_CHILDREN),
    value: None,
};

static WORD_SPEC_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SPECA_NODE),
    None,
    None,
    None,
    Some(&WORD_SPECE_NODE),
    Some(&WORD_SPECF_NODE),
    None,
    None,
    Some(&WORD_SPECI_NODE),
    None,
    Some(&WORD_SPECK_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_SPECR_NODE),
    None,
    Some(&WORD_SPECT_NODE),
    Some(&WORD_SPECU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static WORD_SPECU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECU_CHILDREN),
    value: None,
};

pub static WORD_SPECU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alte"),
        dictgen::InsensitiveStr::Ascii("alting"),
        dictgen::InsensitiveStr::Ascii("altion"),
        dictgen::InsensitiveStr::Ascii("altions"),
        dictgen::InsensitiveStr::Ascii("altive"),
        dictgen::InsensitiveStr::Ascii("fies"),
        dictgen::InsensitiveStr::Ascii("fy"),
        dictgen::InsensitiveStr::Ascii("larite"),
        dictgen::InsensitiveStr::Ascii("latie"),
        dictgen::InsensitiveStr::Ascii("laties"),
        dictgen::InsensitiveStr::Ascii("latin"),
    ],
    values: &[
        &["speculate"],
        &["speculating"],
        &["speculation"],
        &["speculation"],
        &["speculative"],
        &["specifies"],
        &["specify"],
        &["speculative"],
        &["speculative"],
        &["speculative"],
        &["speculation"],
    ],
    range: 2..=7,
};

static WORD_SPECT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECT_CHILDREN),
    value: None,
};

pub static WORD_SPECT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("acuarly"),
        dictgen::InsensitiveStr::Ascii("aculair"),
        dictgen::InsensitiveStr::Ascii("aculaire"),
        dictgen::InsensitiveStr::Ascii("aculalry"),
        dictgen::InsensitiveStr::Ascii("acularely"),
        dictgen::InsensitiveStr::Ascii("acularily"),
        dictgen::InsensitiveStr::Ascii("aculary"),
        dictgen::InsensitiveStr::Ascii("acullar"),
        dictgen::InsensitiveStr::Ascii("arors"),
        dictgen::InsensitiveStr::Ascii("aters"),
        dictgen::InsensitiveStr::Ascii("atores"),
        dictgen::InsensitiveStr::Ascii("atular"),
        dictgen::InsensitiveStr::Ascii("atularly"),
        dictgen::InsensitiveStr::Ascii("auclar"),
        dictgen::InsensitiveStr::Ascii("aulars"),
        dictgen::InsensitiveStr::Ascii("ecular"),
        dictgen::InsensitiveStr::Ascii("racal"),
        dictgen::InsensitiveStr::Ascii("rail"),
        dictgen::InsensitiveStr::Ascii("raply"),
        dictgen::InsensitiveStr::Ascii("rolab"),
        dictgen::InsensitiveStr::Ascii("s"),
        dictgen::InsensitiveStr::Ascii("ular"),
        dictgen::InsensitiveStr::Ascii("ularly"),
        dictgen::InsensitiveStr::Ascii("um"),
        dictgen::InsensitiveStr::Ascii("urm"),
    ],
    values: &[
        &["spectacular"],
        &["spectacular"],
        &["spectacular"],
        &["spectacularly"],
        &["spectacularly"],
        &["spectacularly"],
        &["spectacularly"],
        &["spectacularly"],
        &["spectators"],
        &["spectators"],
        &["spectators"],
        &["spectacular"],
        &["spectacularly"],
        &["spectacular"],
        &["spectaculars"],
        &["spectacular"],
        &["spectral"],
        &["spectral"],
        &["spectral"],
        &["spectral"],
        &["aspects", "expects", "specs"],
        &["spectacular"],
        &["spectacularly"],
        &["spectrum"],
        &["spectrum"],
    ],
    range: 1..=9,
};

static WORD_SPECR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECR_CHILDREN),
    value: None,
};

pub static WORD_SPECR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("tal")],
    values: &[&["spectral"]],
    range: 3..=3,
};

static WORD_SPECK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECK_CHILDREN),
    value: None,
};

pub static WORD_SPECK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("tor")],
    values: &[&["specter", "specter"]],
    range: 3..=3,
};

static WORD_SPECI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SPECI_CHILDREN),
    value: None,
};

static WORD_SPECI_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SPECIA_NODE),
    None,
    Some(&WORD_SPECIC_NODE),
    Some(&WORD_SPECID_NODE),
    Some(&WORD_SPECIE_NODE),
    Some(&WORD_SPECIF_NODE),
    None,
    None,
    Some(&WORD_SPECII_NODE),
    None,
    None,
    Some(&WORD_SPECIL_NODE),
    Some(&WORD_SPECIM_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_SPECIR_NODE),
    Some(&WORD_SPECIS_NODE),
    None,
    None,
    Some(&WORD_SPECIV_NODE),
    None,
    None,
    Some(&WORD_SPECIY_NODE),
    None,
];

static WORD_SPECIY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECIY_CHILDREN),
    value: Some(&["specify"]),
};

pub static WORD_SPECIY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("fing"),
        dictgen::InsensitiveStr::Ascii("fying"),
        dictgen::InsensitiveStr::Ascii("ing"),
    ],
    values: &[&["specifying"], &["specifying"], &["specifying"]],
    range: 3..=5,
};

static WORD_SPECIV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECIV_CHILDREN),
    value: None,
};

pub static WORD_SPECIV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ied")],
    values: &[&["specified"]],
    range: 3..=3,
};

static WORD_SPECIS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECIS_CHILDREN),
    value: None,
};

pub static WORD_SPECIS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("l")],
    values: &[&["specials"]],
    range: 1..=1,
};

static WORD_SPECIR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECIR_CHILDREN),
    value: None,
};

pub static WORD_SPECIR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ies"),
        dictgen::InsensitiveStr::Ascii("y"),
    ],
    values: &[&["specifies"], &["specify"]],
    range: 1..=3,
};

static WORD_SPECIM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECIM_CHILDREN),
    value: None,
};

pub static WORD_SPECIM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("an"),
        dictgen::InsensitiveStr::Ascii("ine"),
        dictgen::InsensitiveStr::Ascii("ines"),
    ],
    values: &[&["specimen"], &["specimen"], &["specimen"]],
    range: 2..=4,
};

static WORD_SPECIL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECIL_CHILDREN),
    value: None,
};

pub static WORD_SPECIL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aized"),
        dictgen::InsensitiveStr::Ascii("iast"),
        dictgen::InsensitiveStr::Ascii("iazation"),
        dictgen::InsensitiveStr::Ascii("iazed"),
        dictgen::InsensitiveStr::Ascii("ized"),
    ],
    values: &[
        &["specialize"],
        &["specialists"],
        &["specialization"],
        &["specialize"],
        &["specialized"],
    ],
    range: 4..=8,
};

static WORD_SPECII_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECII_CHILDREN),
    value: None,
};

pub static WORD_SPECII_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("fc"),
        dictgen::InsensitiveStr::Ascii("fed"),
    ],
    values: &[&["specified"], &["specific"], &["specified"]],
    range: 2..=3,
};

static WORD_SPECIF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECIF_CHILDREN),
    value: None,
};

pub static WORD_SPECIF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("actions"),
        dictgen::InsensitiveStr::Ascii("c"),
        dictgen::InsensitiveStr::Ascii("cally"),
        dictgen::InsensitiveStr::Ascii("cation"),
        dictgen::InsensitiveStr::Ascii("cations"),
        dictgen::InsensitiveStr::Ascii("cied"),
        dictgen::InsensitiveStr::Ascii("clly"),
        dictgen::InsensitiveStr::Ascii("ed"),
        dictgen::InsensitiveStr::Ascii("fic"),
        dictgen::InsensitiveStr::Ascii("fically"),
        dictgen::InsensitiveStr::Ascii("ially"),
        dictgen::InsensitiveStr::Ascii("icaiton"),
        dictgen::InsensitiveStr::Ascii("icaitons"),
        dictgen::InsensitiveStr::Ascii("icallly"),
        dictgen::InsensitiveStr::Ascii("icaly"),
        dictgen::InsensitiveStr::Ascii("icated"),
        dictgen::InsensitiveStr::Ascii("icateion"),
        dictgen::InsensitiveStr::Ascii("icatin"),
        dictgen::InsensitiveStr::Ascii("icato"),
        dictgen::InsensitiveStr::Ascii("icaton"),
        dictgen::InsensitiveStr::Ascii("icatons"),
        dictgen::InsensitiveStr::Ascii("iced"),
        dictgen::InsensitiveStr::Ascii("ices"),
        dictgen::InsensitiveStr::Ascii("ich"),
        dictgen::InsensitiveStr::Ascii("icially"),
        dictgen::InsensitiveStr::Ascii("iciation"),
        dictgen::InsensitiveStr::Ascii("iciations"),
        dictgen::InsensitiveStr::Ascii("icically"),
        dictgen::InsensitiveStr::Ascii("icied"),
        dictgen::InsensitiveStr::Ascii("icies"),
        dictgen::InsensitiveStr::Ascii("icl"),
        dictgen::InsensitiveStr::Ascii("icly"),
        dictgen::InsensitiveStr::Ascii("iction"),
        dictgen::InsensitiveStr::Ascii("ictions"),
        dictgen::InsensitiveStr::Ascii("icy"),
        dictgen::InsensitiveStr::Ascii("id"),
        dictgen::InsensitiveStr::Ascii("iing"),
        dictgen::InsensitiveStr::Ascii("ikation"),
        dictgen::InsensitiveStr::Ascii("ing"),
        dictgen::InsensitiveStr::Ascii("iy"),
        dictgen::InsensitiveStr::Ascii("iying"),
        dictgen::InsensitiveStr::Ascii("iyng"),
        dictgen::InsensitiveStr::Ascii("ric"),
        dictgen::InsensitiveStr::Ascii("t"),
        dictgen::InsensitiveStr::Ascii("yed"),
        dictgen::InsensitiveStr::Ascii("yied"),
        dictgen::InsensitiveStr::Ascii("yig"),
        dictgen::InsensitiveStr::Ascii("yinhg"),
    ],
    values: &[
        &["specifications"],
        &["specific"],
        &["specifically"],
        &["specification"],
        &["specifications"],
        &["specified"],
        &["specifically"],
        &["specified"],
        &["specific"],
        &["specifically"],
        &["specifically"],
        &["specifications"],
        &["specification"],
        &["specifically"],
        &["specifically"],
        &["specified"],
        &["specification"],
        &["specification"],
        &["specification"],
        &["specification"],
        &["specifications"],
        &["specified"],
        &["specifics", "specifies"],
        &["specify", "specific"],
        &["specifically"],
        &["specification"],
        &["specifications"],
        &["specifically"],
        &["specified"],
        &["specifics"],
        &["specific"],
        &["specifically"],
        &["specification"],
        &["specifications"],
        &["specify", "specificity", "specifically"],
        &["specified"],
        &["specifying"],
        &["specification"],
        &["specifying"],
        &["specify"],
        &["specifying"],
        &["specifying"],
        &["specific"],
        &["specify"],
        &["specified"],
        &["specified"],
        &["specifying"],
        &["specifying"],
    ],
    range: 1..=9,
};

static WORD_SPECIE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECIE_CHILDREN),
    value: None,
};

pub static WORD_SPECIE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("d"),
        dictgen::InsensitiveStr::Ascii("fied"),
    ],
    values: &[&["specified"], &["specified"]],
    range: 1..=4,
};

static WORD_SPECID_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECID_CHILDREN),
    value: None,
};

pub static WORD_SPECID_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ic")],
    values: &[&["specific"]],
    range: 2..=2,
};

static WORD_SPECIC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECIC_CHILDREN),
    value: Some(&["specific"]),
};

pub static WORD_SPECIC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("al"),
        dictgen::InsensitiveStr::Ascii("ation"),
    ],
    values: &[&["special"], &["specification"]],
    range: 2..=5,
};

static WORD_SPECIA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECIA_CHILDREN),
    value: None,
};

pub static WORD_SPECIA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("al"),
        dictgen::InsensitiveStr::Ascii("fied"),
        dictgen::InsensitiveStr::Ascii("les"),
        dictgen::InsensitiveStr::Ascii("lication"),
        dictgen::InsensitiveStr::Ascii("lice"),
        dictgen::InsensitiveStr::Ascii("liced"),
        dictgen::InsensitiveStr::Ascii("lices"),
        dictgen::InsensitiveStr::Ascii("lied"),
        dictgen::InsensitiveStr::Ascii("lies"),
        dictgen::InsensitiveStr::Ascii("lis"),
        dictgen::InsensitiveStr::Ascii("listes"),
        dictgen::InsensitiveStr::Ascii("lites"),
        dictgen::InsensitiveStr::Ascii("lits"),
        dictgen::InsensitiveStr::Ascii("litzed"),
        dictgen::InsensitiveStr::Ascii("lizaiton"),
        dictgen::InsensitiveStr::Ascii("lizare"),
        dictgen::InsensitiveStr::Ascii("lizate"),
        dictgen::InsensitiveStr::Ascii("lizaton"),
        dictgen::InsensitiveStr::Ascii("lizeds"),
        dictgen::InsensitiveStr::Ascii("lizied"),
        dictgen::InsensitiveStr::Ascii("llist"),
        dictgen::InsensitiveStr::Ascii("llity"),
        dictgen::InsensitiveStr::Ascii("llize"),
        dictgen::InsensitiveStr::Ascii("llized"),
        dictgen::InsensitiveStr::Ascii("llly"),
        dictgen::InsensitiveStr::Ascii("llty"),
        dictgen::InsensitiveStr::Ascii("lops"),
        dictgen::InsensitiveStr::Ascii("lsts"),
        dictgen::InsensitiveStr::Ascii("lt"),
        dictgen::InsensitiveStr::Ascii("ltys"),
        dictgen::InsensitiveStr::Ascii("ly"),
        dictgen::InsensitiveStr::Ascii("lz"),
        dictgen::InsensitiveStr::Ascii("lzed"),
        dictgen::InsensitiveStr::Ascii("lzes"),
        dictgen::InsensitiveStr::Ascii("lzied"),
        dictgen::InsensitiveStr::Ascii("s"),
        dictgen::InsensitiveStr::Ascii("tly"),
    ],
    values: &[
        &["special"],
        &["specified"],
        &["specials"],
        &["specialization"],
        &["specialize"],
        &["specialized", "specialised"],
        &["specializes"],
        &["specialized"],
        &["specializes"],
        &["specials"],
        &["specialists"],
        &["specializes"],
        &["specials"],
        &["specialized", "specialized"],
        &["specialization"],
        &["specialize"],
        &["specialize"],
        &["specialization"],
        &["specializes"],
        &["specialize"],
        &["specialist"],
        &["specially"],
        &["specialize"],
        &["specialized", "specialized"],
        &["specially"],
        &["specially"],
        &["specials"],
        &["specialists"],
        &["specialist"],
        &["specials"],
        &["specially"],
        &["specialize"],
        &["specialized"],
        &["specializes"],
        &["specialized"],
        &["specials"],
        &["specialty"],
    ],
    range: 1..=8,
};

static WORD_SPECF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECF_CHILDREN),
    value: None,
};

pub static WORD_SPECF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ic"),
        dictgen::InsensitiveStr::Ascii("ically"),
        dictgen::InsensitiveStr::Ascii("ication"),
        dictgen::InsensitiveStr::Ascii("ications"),
        dictgen::InsensitiveStr::Ascii("ied"),
        dictgen::InsensitiveStr::Ascii("ield"),
        dictgen::InsensitiveStr::Ascii("ies"),
        dictgen::InsensitiveStr::Ascii("iied"),
        dictgen::InsensitiveStr::Ascii("y"),
        dictgen::InsensitiveStr::Ascii("ying"),
    ],
    values: &[
        &["specific"],
        &["specifically"],
        &["specification"],
        &["specifications"],
        &["specified"],
        &["specified"],
        &["specifies"],
        &["specified"],
        &["specify"],
        &["specifying"],
    ],
    range: 1..=8,
};

static WORD_SPECE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECE_CHILDREN),
    value: None,
};

pub static WORD_SPECE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("fied"),
        dictgen::InsensitiveStr::Ascii("min"),
    ],
    values: &[&["specified"], &["specimen"]],
    range: 3..=4,
};

static WORD_SPECA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPECA_CHILDREN),
    value: None,
};

pub static WORD_SPECA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("il"),
        dictgen::InsensitiveStr::Ascii("ilist"),
        dictgen::InsensitiveStr::Ascii("ilists"),
        dictgen::InsensitiveStr::Ascii("ilization"),
        dictgen::InsensitiveStr::Ascii("ilize"),
        dictgen::InsensitiveStr::Ascii("ilized"),
        dictgen::InsensitiveStr::Ascii("ilizes"),
        dictgen::InsensitiveStr::Ascii("illy"),
        dictgen::InsensitiveStr::Ascii("ilty"),
        dictgen::InsensitiveStr::Ascii("lity"),
        dictgen::InsensitiveStr::Ascii("tcular"),
    ],
    values: &[
        &["special"],
        &["specialist"],
        &["specialists"],
        &["specialization"],
        &["specializes"],
        &["specialized"],
        &["specializes"],
        &["specially"],
        &["specialty"],
        &["speciality"],
        &["spectacular"],
    ],
    range: 2..=9,
};

static WORD_SPEA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPEA_CHILDREN),
    value: None,
};

pub static WORD_SPEA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ch"),
        dictgen::InsensitiveStr::Ascii("cial"),
        dictgen::InsensitiveStr::Ascii("rated"),
        dictgen::InsensitiveStr::Ascii("rator"),
        dictgen::InsensitiveStr::Ascii("rators"),
    ],
    values: &[
        &["speech"],
        &["special", "spacial"],
        &["separated"],
        &["separator"],
        &["separators"],
    ],
    range: 2..=6,
};

static WORD_SPC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPC_CHILDREN),
    value: None,
};

pub static WORD_SPC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ae"),
        dictgen::InsensitiveStr::Ascii("ecified"),
        dictgen::InsensitiveStr::Ascii("ial"),
        dictgen::InsensitiveStr::Ascii("ific"),
        dictgen::InsensitiveStr::Ascii("ifies"),
    ],
    values: &[
        &["space"],
        &["specified"],
        &["special"],
        &["specific"],
        &["specifies"],
    ],
    range: 2..=7,
};

static WORD_SPA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SPA_CHILDREN),
    value: None,
};

pub static WORD_SPA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cebr"),
        dictgen::InsensitiveStr::Ascii("cegoat"),
        dictgen::InsensitiveStr::Ascii("cific"),
        dictgen::InsensitiveStr::Ascii("cification"),
        dictgen::InsensitiveStr::Ascii("cifics"),
        dictgen::InsensitiveStr::Ascii("cified"),
        dictgen::InsensitiveStr::Ascii("cifies"),
        dictgen::InsensitiveStr::Ascii("gehtti"),
        dictgen::InsensitiveStr::Ascii("geti"),
        dictgen::InsensitiveStr::Ascii("getti"),
        dictgen::InsensitiveStr::Ascii("gheti"),
        dictgen::InsensitiveStr::Ascii("gnum"),
        dictgen::InsensitiveStr::Ascii("hgetti"),
        dictgen::InsensitiveStr::Ascii("inish"),
        dictgen::InsensitiveStr::Ascii("insh"),
        dictgen::InsensitiveStr::Ascii("ltoon"),
        dictgen::InsensitiveStr::Ascii("mmade"),
        dictgen::InsensitiveStr::Ascii("mmare"),
        dictgen::InsensitiveStr::Ascii("mmear"),
        dictgen::InsensitiveStr::Ascii("mmend"),
        dictgen::InsensitiveStr::Ascii("mmeur"),
        dictgen::InsensitiveStr::Ascii("ning"),
        dictgen::InsensitiveStr::Ascii("nisch"),
        dictgen::InsensitiveStr::Ascii("nsih"),
        dictgen::InsensitiveStr::Ascii("nwed"),
        dictgen::InsensitiveStr::Ascii("rate"),
        dictgen::InsensitiveStr::Ascii("rately"),
        dictgen::InsensitiveStr::Ascii("rkel"),
        dictgen::InsensitiveStr::Ascii("rklie"),
        dictgen::InsensitiveStr::Ascii("rlking"),
        dictgen::InsensitiveStr::Ascii("rtaniis"),
        dictgen::InsensitiveStr::Ascii("rtanops"),
        dictgen::InsensitiveStr::Ascii("rtants"),
        dictgen::InsensitiveStr::Ascii("rtas"),
        dictgen::InsensitiveStr::Ascii("rtsn"),
        dictgen::InsensitiveStr::Ascii("ryed"),
        dictgen::InsensitiveStr::Ascii("w"),
        dictgen::InsensitiveStr::Ascii("wed"),
        dictgen::InsensitiveStr::Ascii("wend"),
        dictgen::InsensitiveStr::Ascii("wing"),
        dictgen::InsensitiveStr::Ascii("wining"),
        dictgen::InsensitiveStr::Ascii("wnig"),
        dictgen::InsensitiveStr::Ascii("wnign"),
        dictgen::InsensitiveStr::Ascii("wnve"),
        dictgen::InsensitiveStr::Ascii("ws"),
    ],
    values: &[
        &["spacebar"],
        &["scapegoat"],
        &["specific"],
        &["specification"],
        &["specifics"],
        &["specified"],
        &["specifies"],
        &["spaghetti"],
        &["spaghetti"],
        &["spaghetti"],
        &["spaghetti"],
        &["sphagnum"],
        &["spaghetti"],
        &["spanish"],
        &["spanish"],
        &["splatoon"],
        &["spammed"],
        &["spammer"],
        &["spammer"],
        &["spammed"],
        &["spammer"],
        &["spanning"],
        &["spanish"],
        &["spanish"],
        &["spawned"],
        &["separate"],
        &["separately"],
        &["sparkle"],
        &["sparkle"],
        &["sparkling"],
        &["spartans"],
        &["spartans"],
        &["spartans"],
        &["spartans"],
        &["spartans"],
        &["sprayed"],
        &["spawn"],
        &["spawned"],
        &["spawned"],
        &["spawning"],
        &["spawning"],
        &["spawning"],
        &["spawning"],
        &["spawn"],
        &["spawns"],
    ],
    range: 1..=10,
};

static WORD_SO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SO_CHILDREN),
    value: None,
};

static WORD_SO_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SOA_NODE),
    Some(&WORD_SOB_NODE),
    Some(&WORD_SOC_NODE),
    None,
    Some(&WORD_SOE_NODE),
    Some(&WORD_SOF_NODE),
    None,
    Some(&WORD_SOH_NODE),
    Some(&WORD_SOI_NODE),
    None,
    Some(&WORD_SOK_NODE),
    Some(&WORD_SOL_NODE),
    Some(&WORD_SOM_NODE),
    Some(&WORD_SON_NODE),
    Some(&WORD_SOO_NODE),
    Some(&WORD_SOP_NODE),
    None,
    Some(&WORD_SOR_NODE),
    Some(&WORD_SOS_NODE),
    Some(&WORD_SOT_NODE),
    Some(&WORD_SOU_NODE),
    Some(&WORD_SOV_NODE),
    Some(&WORD_SOW_NODE),
    None,
    None,
    None,
];

static WORD_SOW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOW_CHILDREN),
    value: None,
};

pub static WORD_SOW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("e")],
    values: &[&["sow"]],
    range: 1..=1,
};

static WORD_SOV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOV_CHILDREN),
    value: None,
};

pub static WORD_SOV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eits"),
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("eregin"),
        dictgen::InsensitiveStr::Ascii("eregnity"),
        dictgen::InsensitiveStr::Ascii("ereighnty"),
        dictgen::InsensitiveStr::Ascii("ereighty"),
        dictgen::InsensitiveStr::Ascii("ereignety"),
        dictgen::InsensitiveStr::Ascii("ereignity"),
        dictgen::InsensitiveStr::Ascii("ereigny"),
        dictgen::InsensitiveStr::Ascii("erein"),
        dictgen::InsensitiveStr::Ascii("ereing"),
        dictgen::InsensitiveStr::Ascii("ereingty"),
        dictgen::InsensitiveStr::Ascii("ereinity"),
        dictgen::InsensitiveStr::Ascii("ereinty"),
        dictgen::InsensitiveStr::Ascii("eriegn"),
        dictgen::InsensitiveStr::Ascii("eriegnty"),
        dictgen::InsensitiveStr::Ascii("eriengty"),
        dictgen::InsensitiveStr::Ascii("erign"),
        dictgen::InsensitiveStr::Ascii("erignity"),
        dictgen::InsensitiveStr::Ascii("erignty"),
        dictgen::InsensitiveStr::Ascii("ietes"),
        dictgen::InsensitiveStr::Ascii("le"),
        dictgen::InsensitiveStr::Ascii("led"),
        dictgen::InsensitiveStr::Ascii("ren"),
    ],
    values: &[
        &["soviets"],
        &["solver"],
        &["sovereign"],
        &["sovereignty"],
        &["sovereignty"],
        &["sovereignty"],
        &["sovereignty"],
        &["sovereignty"],
        &["sovereignty"],
        &["sovereign"],
        &["sovereign"],
        &["sovereignty"],
        &["sovereignty"],
        &["sovereignty"],
        &["sovereign"],
        &["sovereignty"],
        &["sovereignty"],
        &["sovereign"],
        &["sovereignty"],
        &["sovereignty"],
        &["soviets"],
        &["solve"],
        &["solved"],
        &["sovereign"],
    ],
    range: 2..=9,
};

static WORD_SOU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOU_CHILDREN),
    value: None,
};

pub static WORD_SOU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ce"),
        dictgen::InsensitiveStr::Ascii("ces"),
        dictgen::InsensitiveStr::Ascii("cre"),
        dictgen::InsensitiveStr::Ascii("cres"),
        dictgen::InsensitiveStr::Ascii("dn"),
        dictgen::InsensitiveStr::Ascii("dns"),
        dictgen::InsensitiveStr::Ascii("dntrack"),
        dictgen::InsensitiveStr::Ascii("ld"),
        dictgen::InsensitiveStr::Ascii("ndard"),
        dictgen::InsensitiveStr::Ascii("ndrtack"),
        dictgen::InsensitiveStr::Ascii("ndtracs"),
        dictgen::InsensitiveStr::Ascii("ndtrak"),
        dictgen::InsensitiveStr::Ascii("ndtrakc"),
        dictgen::InsensitiveStr::Ascii("ndtrakcs"),
        dictgen::InsensitiveStr::Ascii("ndtrakk"),
        dictgen::InsensitiveStr::Ascii("ndtraks"),
        dictgen::InsensitiveStr::Ascii("ntrack"),
        dictgen::InsensitiveStr::Ascii("rcd"),
        dictgen::InsensitiveStr::Ascii("rcde"),
        dictgen::InsensitiveStr::Ascii("rcedrectory"),
        dictgen::InsensitiveStr::Ascii("rcs"),
        dictgen::InsensitiveStr::Ascii("rcse"),
        dictgen::InsensitiveStr::Ascii("rct"),
        dictgen::InsensitiveStr::Ascii("re"),
        dictgen::InsensitiveStr::Ascii("res"),
        dictgen::InsensitiveStr::Ascii("rrounding"),
        dictgen::InsensitiveStr::Ascii("rt"),
        dictgen::InsensitiveStr::Ascii("rth"),
        dictgen::InsensitiveStr::Ascii("rthern"),
        dictgen::InsensitiveStr::Ascii("thampon"),
        dictgen::InsensitiveStr::Ascii("thamption"),
        dictgen::InsensitiveStr::Ascii("thamton"),
        dictgen::InsensitiveStr::Ascii("thamtpon"),
        dictgen::InsensitiveStr::Ascii("thanpton"),
        dictgen::InsensitiveStr::Ascii("thapmton"),
        dictgen::InsensitiveStr::Ascii("thbrige"),
        dictgen::InsensitiveStr::Ascii("then"),
        dictgen::InsensitiveStr::Ascii("therers"),
        dictgen::InsensitiveStr::Ascii("thernerns"),
        dictgen::InsensitiveStr::Ascii("thernes"),
        dictgen::InsensitiveStr::Ascii("thernese"),
        dictgen::InsensitiveStr::Ascii("therness"),
        dictgen::InsensitiveStr::Ascii("thernest"),
        dictgen::InsensitiveStr::Ascii("thernors"),
        dictgen::InsensitiveStr::Ascii("therton"),
        dictgen::InsensitiveStr::Ascii("thmapton"),
        dictgen::InsensitiveStr::Ascii("thren"),
        dictgen::InsensitiveStr::Ascii("thtampon"),
        dictgen::InsensitiveStr::Ascii("venier"),
        dictgen::InsensitiveStr::Ascii("veniers"),
    ],
    values: &[
        &["source"],
        &["sources"],
        &["source"],
        &["sources"],
        &["sound"],
        &["sounds"],
        &["soundtrack"],
        &["could", "should", "sold"],
        &["soundcard"],
        &["soundtracks"],
        &["soundtracks"],
        &["soundtrack"],
        &["soundtracks"],
        &["soundtracks"],
        &["soundtrack"],
        &["soundtracks"],
        &["soundtrack"],
        &["sourced", "source"],
        &["sourced", "source"],
        &["sourcedirectory"],
        &["sources", "source"],
        &["sources", "source"],
        &["source"],
        &["source", "sure", "sore", "sour", "soured"],
        &["sources", "sores", "sours", "soured"],
        &["surrounding"],
        &["sort", "south", "sour"],
        &["south"],
        &["southern"],
        &["southampton"],
        &["southampton"],
        &["southampton"],
        &["southampton"],
        &["southampton"],
        &["southampton"],
        &["southbridge"],
        &["southern"],
        &["southerners"],
        &["southerners"],
        &["southerners"],
        &["southerners"],
        &["southerners"],
        &["southerners"],
        &["southerners"],
        &["southern"],
        &["southampton"],
        &["southern"],
        &["southampton"],
        &["souvenir"],
        &["souvenirs"],
    ],
    range: 2..=11,
};

static WORD_SOT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOT_CHILDREN),
    value: None,
};

pub static WORD_SOT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("erd"),
        dictgen::InsensitiveStr::Ascii("fware"),
        dictgen::InsensitiveStr::Ascii("rage"),
        dictgen::InsensitiveStr::Ascii("red"),
        dictgen::InsensitiveStr::Ascii("ring"),
        dictgen::InsensitiveStr::Ascii("rmfront"),
        dictgen::InsensitiveStr::Ascii("ry"),
        dictgen::InsensitiveStr::Ascii("ryline"),
        dictgen::InsensitiveStr::Ascii("rylines"),
        dictgen::InsensitiveStr::Ascii("yr"),
    ],
    values: &[
        &["stored", "sorted"],
        &["software"],
        &["storage", "shortage"],
        &["sorted", "stored"],
        &["storing", "sorting"],
        &["stormfront"],
        &["story", "sorry"],
        &["storyline"],
        &["storylines"],
        &["satyr", "story"],
    ],
    range: 2..=7,
};

static WORD_SOS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOS_CHILDREN),
    value: None,
};

pub static WORD_SOS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("cket")],
    values: &[&["socket"]],
    range: 4..=4,
};

static WORD_SOR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOR_CHILDREN),
    value: None,
};

pub static WORD_SOR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ce"),
        dictgen::InsensitiveStr::Ascii("cercy"),
        dictgen::InsensitiveStr::Ascii("cerey"),
        dictgen::InsensitiveStr::Ascii("ceror"),
        dictgen::InsensitiveStr::Ascii("cerry"),
        dictgen::InsensitiveStr::Ascii("panos"),
        dictgen::InsensitiveStr::Ascii("rounding"),
        dictgen::InsensitiveStr::Ascii("tig"),
        dictgen::InsensitiveStr::Ascii("tings"),
        dictgen::InsensitiveStr::Ascii("tlst"),
        dictgen::InsensitiveStr::Ascii("tner"),
        dictgen::InsensitiveStr::Ascii("tnr"),
        dictgen::InsensitiveStr::Ascii("trage"),
        dictgen::InsensitiveStr::Ascii("uce"),
        dictgen::InsensitiveStr::Ascii("uces"),
    ],
    values: &[
        &["source", "force"],
        &["sorcery"],
        &["sorcery"],
        &["sorcerer"],
        &["sorcery"],
        &["sopranos"],
        &["surrounding"],
        &["sorting"],
        &["sorting"],
        &["sortlist"],
        &["sorter"],
        &["sorter"],
        &["storage", "shortage"],
        &["source", "spruce"],
        &["sources", "spruces"],
    ],
    range: 2..=8,
};

static WORD_SOP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOP_CHILDREN),
    value: None,
};

pub static WORD_SOP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("arnos"),
        dictgen::InsensitiveStr::Ascii("hicated"),
        dictgen::InsensitiveStr::Ascii("hisicated"),
        dictgen::InsensitiveStr::Ascii("hisitcated"),
        dictgen::InsensitiveStr::Ascii("histacated"),
        dictgen::InsensitiveStr::Ascii("histicaed"),
        dictgen::InsensitiveStr::Ascii("histicted"),
        dictgen::InsensitiveStr::Ascii("histocated"),
        dictgen::InsensitiveStr::Ascii("hmore"),
        dictgen::InsensitiveStr::Ascii("hosticated"),
        dictgen::InsensitiveStr::Ascii("ohmore"),
    ],
    values: &[
        &["sopranos"],
        &["sophisticated"],
        &["sophisticated"],
        &["sophisticated"],
        &["sophisticated"],
        &["sophisticated"],
        &["sophisticated"],
        &["sophisticated"],
        &["sophomore"],
        &["sophisticated"],
        &["sophomore"],
    ],
    range: 5..=10,
};

static WORD_SOO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOO_CHILDREN),
    value: None,
};

pub static WORD_SOO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aside"),
        dictgen::InsensitiveStr::Ascii("donim"),
        dictgen::InsensitiveStr::Ascii("it"),
        dictgen::InsensitiveStr::Ascii("p"),
        dictgen::InsensitiveStr::Ascii("urce"),
    ],
    values: &[
        &["suicide"],
        &["pseudonym"],
        &["suet", "suit", "soot"],
        &["soup", "scoop", "snoop", "soap"],
        &["source"],
    ],
    range: 1..=5,
};

static WORD_SON_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SON_CHILDREN),
    value: None,
};

pub static WORD_SON_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ething"),
        dictgen::InsensitiveStr::Ascii("glar"),
        dictgen::InsensitiveStr::Ascii("gle"),
        dictgen::InsensitiveStr::Ascii("gled"),
        dictgen::InsensitiveStr::Ascii("gles"),
        dictgen::InsensitiveStr::Ascii("gling"),
    ],
    values: &[
        &["something"],
        &["singular"],
        &["single", "dongle"],
        &["singled", "dongled"],
        &["singles", "dongles"],
        &["singling", "dongling"],
    ],
    range: 3..=6,
};

static WORD_SOM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SOM_CHILDREN),
    value: Some(&["some"]),
};

static WORD_SOM_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SOMA_NODE),
    None,
    None,
    None,
    Some(&WORD_SOME_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_SOMM_NODE),
    None,
    Some(&WORD_SOMO_NODE),
    None,
    None,
    None,
    None,
    Some(&WORD_SOMT_NODE),
    None,
    None,
    Some(&WORD_SOMW_NODE),
    None,
    None,
    None,
];

static WORD_SOMW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOMW_CHILDREN),
    value: None,
};

pub static WORD_SOMW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hat"),
        dictgen::InsensitiveStr::Ascii("here"),
        dictgen::InsensitiveStr::Ascii("ho"),
        dictgen::InsensitiveStr::Ascii("how"),
    ],
    values: &[&["somewhat"], &["somewhere"], &["somehow"], &["somehow"]],
    range: 2..=4,
};

static WORD_SOMT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOMT_CHILDREN),
    value: None,
};

pub static WORD_SOMT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("hign"),
        dictgen::InsensitiveStr::Ascii("hing"),
        dictgen::InsensitiveStr::Ascii("imes"),
    ],
    values: &[&["something"], &["something"], &["sometimes"]],
    range: 4..=4,
};

static WORD_SOMO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOMO_CHILDREN),
    value: None,
};

pub static WORD_SOMO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("enes")],
    values: &[&["someones"]],
    range: 4..=4,
};

static WORD_SOMM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOMM_CHILDREN),
    value: None,
};

pub static WORD_SOMM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("e")],
    values: &[&["some"]],
    range: 1..=1,
};

static WORD_SOME_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOME_CHILDREN),
    value: None,
};

pub static WORD_SOME_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("boby"),
        dictgen::InsensitiveStr::Ascii("htin"),
        dictgen::InsensitiveStr::Ascii("hting"),
        dictgen::InsensitiveStr::Ascii("htings"),
        dictgen::InsensitiveStr::Ascii("hwat"),
        dictgen::InsensitiveStr::Ascii("hwere"),
        dictgen::InsensitiveStr::Ascii("hwo"),
        dictgen::InsensitiveStr::Ascii("ne"),
        dictgen::InsensitiveStr::Ascii("none"),
        dictgen::InsensitiveStr::Ascii("oens"),
        dictgen::InsensitiveStr::Ascii("on"),
        dictgen::InsensitiveStr::Ascii("oneis"),
        dictgen::InsensitiveStr::Ascii("onelse"),
        dictgen::InsensitiveStr::Ascii("ons"),
        dictgen::InsensitiveStr::Ascii("s"),
        dictgen::InsensitiveStr::Ascii("thibng"),
        dictgen::InsensitiveStr::Ascii("thig"),
        dictgen::InsensitiveStr::Ascii("thign"),
        dictgen::InsensitiveStr::Ascii("thigng"),
        dictgen::InsensitiveStr::Ascii("thigns"),
        dictgen::InsensitiveStr::Ascii("thihng"),
        dictgen::InsensitiveStr::Ascii("thiing"),
        dictgen::InsensitiveStr::Ascii("thijng"),
        dictgen::InsensitiveStr::Ascii("thikng"),
        dictgen::InsensitiveStr::Ascii("thimes"),
        dictgen::InsensitiveStr::Ascii("thimg"),
        dictgen::InsensitiveStr::Ascii("thimng"),
        dictgen::InsensitiveStr::Ascii("thinbg"),
        dictgen::InsensitiveStr::Ascii("thines"),
        dictgen::InsensitiveStr::Ascii("thinfg"),
        dictgen::InsensitiveStr::Ascii("thingest"),
        dictgen::InsensitiveStr::Ascii("thingis"),
        dictgen::InsensitiveStr::Ascii("thinhg"),
        dictgen::InsensitiveStr::Ascii("thinig"),
        dictgen::InsensitiveStr::Ascii("thinkg"),
        dictgen::InsensitiveStr::Ascii("thinks"),
        dictgen::InsensitiveStr::Ascii("thinmg"),
        dictgen::InsensitiveStr::Ascii("thinng"),
        dictgen::InsensitiveStr::Ascii("thins"),
        dictgen::InsensitiveStr::Ascii("thintg"),
        dictgen::InsensitiveStr::Ascii("thiong"),
        dictgen::InsensitiveStr::Ascii("this"),
        dictgen::InsensitiveStr::Ascii("thiung"),
        dictgen::InsensitiveStr::Ascii("thn"),
        dictgen::InsensitiveStr::Ascii("tiem"),
        dictgen::InsensitiveStr::Ascii("tiems"),
        dictgen::InsensitiveStr::Ascii("tihing"),
        dictgen::InsensitiveStr::Ascii("tihn"),
        dictgen::InsensitiveStr::Ascii("tihng"),
        dictgen::InsensitiveStr::Ascii("tiles"),
        dictgen::InsensitiveStr::Ascii("tims"),
        dictgen::InsensitiveStr::Ascii("tines"),
        dictgen::InsensitiveStr::Ascii("ting"),
        dictgen::InsensitiveStr::Ascii("tinh"),
        dictgen::InsensitiveStr::Ascii("tinhg"),
        dictgen::InsensitiveStr::Ascii("were"),
        dictgen::InsensitiveStr::Ascii("wher"),
        dictgen::InsensitiveStr::Ascii("who"),
    ],
    values: &[
        &["somebody"],
        &["something"],
        &["something"],
        &["somethings"],
        &["somewhat"],
        &["somewhere"],
        &["somehow"],
        &["someone"],
        &["someone"],
        &["someones"],
        &["someone"],
        &["someones"],
        &["someones"],
        &["someones"],
        &["some"],
        &["something"],
        &["something"],
        &["something"],
        &["something"],
        &["somethings"],
        &["something"],
        &["something"],
        &["something"],
        &["somethin"],
        &["sometimes"],
        &["something"],
        &["something"],
        &["somethings"],
        &["somethings"],
        &["somethings"],
        &["somethings"],
        &["somethings"],
        &["somethings"],
        &["somethings"],
        &["somethings"],
        &["somethings"],
        &["somethings"],
        &["somethings"],
        &["somethings"],
        &["somethings"],
        &["something"],
        &["somethings"],
        &["something"],
        &["something"],
        &["sometime", "sometimes"],
        &["sometimes"],
        &["something"],
        &["something"],
        &["something"],
        &["sometimes"],
        &["sometimes"],
        &["sometimes"],
        &["something"],
        &["something"],
        &["something"],
        &["somewhere"],
        &["somewhere"],
        &["somehow"],
    ],
    range: 1..=8,
};

static WORD_SOMA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOMA_CHILDREN),
    value: None,
};

pub static WORD_SOMA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ila"),
        dictgen::InsensitiveStr::Ascii("lija"),
    ],
    values: &[&["somalia"], &["somalia"]],
    range: 3..=4,
};

static WORD_SOL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOL_CHILDREN),
    value: None,
};

pub static WORD_SOL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("armutx"),
        dictgen::InsensitiveStr::Ascii("atary"),
        dictgen::InsensitiveStr::Ascii("deirs"),
        dictgen::InsensitiveStr::Ascii("diarity"),
        dictgen::InsensitiveStr::Ascii("dies"),
        dictgen::InsensitiveStr::Ascii("dily"),
        dictgen::InsensitiveStr::Ascii("er"),
        dictgen::InsensitiveStr::Ascii("ey"),
        dictgen::InsensitiveStr::Ascii("f"),
        dictgen::InsensitiveStr::Ascii("fed"),
        dictgen::InsensitiveStr::Ascii("fer"),
        dictgen::InsensitiveStr::Ascii("fes"),
        dictgen::InsensitiveStr::Ascii("fing"),
        dictgen::InsensitiveStr::Ascii("fs"),
        dictgen::InsensitiveStr::Ascii("idairty"),
        dictgen::InsensitiveStr::Ascii("idariety"),
        dictgen::InsensitiveStr::Ascii("iders"),
        dictgen::InsensitiveStr::Ascii("iditary"),
        dictgen::InsensitiveStr::Ascii("ification"),
        dictgen::InsensitiveStr::Ascii("iliquy"),
        dictgen::InsensitiveStr::Ascii("itudine"),
        dictgen::InsensitiveStr::Ascii("tion"),
        dictgen::InsensitiveStr::Ascii("uable"),
        dictgen::InsensitiveStr::Ascii("um"),
        dictgen::InsensitiveStr::Ascii("utide"),
        dictgen::InsensitiveStr::Ascii("veable"),
        dictgen::InsensitiveStr::Ascii("wed"),
    ],
    values: &[
        &["solarmutex"],
        &["solitary"],
        &["soldiers"],
        &["solidarity"],
        &["soldiers"],
        &["solidly"],
        &["solver", "solar", "solely"],
        &["solely"],
        &["solve", "sold"],
        &["solved"],
        &["solver", "solder"],
        &["solves"],
        &["solving"],
        &["solves"],
        &["solidarity"],
        &["solidarity"],
        &["soldiers"],
        &["solidarity"],
        &["solidification"],
        &["soliloquy"],
        &["solitude"],
        &["solution"],
        &["soluble"],
        &["solemn"],
        &["solitude"],
        &["solvable"],
        &["solved"],
    ],
    range: 1..=9,
};

static WORD_SOK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOK_CHILDREN),
    value: None,
};

pub static WORD_SOK_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("et"),
        dictgen::InsensitiveStr::Ascii("ets"),
    ],
    values: &[&["socket"], &["sockets"]],
    range: 2..=3,
};

static WORD_SOI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOI_CHILDREN),
    value: None,
};

pub static WORD_SOI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lders"),
        dictgen::InsensitiveStr::Ascii("ldly"),
        dictgen::InsensitiveStr::Ascii("urce"),
    ],
    values: &[&["soldiers"], &["solidly"], &["source"]],
    range: 4..=5,
};

static WORD_SOH_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOH_CHILDREN),
    value: None,
};

pub static WORD_SOH_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("pisticated"),
        dictgen::InsensitiveStr::Ascii("pomore"),
        dictgen::InsensitiveStr::Ascii("w"),
    ],
    values: &[&["sophisticated"], &["sophomore"], &["show"]],
    range: 1..=10,
};

static WORD_SOF_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOF_CHILDREN),
    value: None,
};

pub static WORD_SOF_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("isticated"),
        dictgen::InsensitiveStr::Ascii("tend"),
        dictgen::InsensitiveStr::Ascii("twares"),
        dictgen::InsensitiveStr::Ascii("twre"),
        dictgen::InsensitiveStr::Ascii("ware"),
        dictgen::InsensitiveStr::Ascii("wtare"),
    ],
    values: &[
        &["sophisticated"],
        &["softened"],
        &["software"],
        &["software"],
        &["software"],
        &["software"],
    ],
    range: 4..=9,
};

static WORD_SOE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOE_CHILDREN),
    value: None,
};

pub static WORD_SOE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cialize"),
        dictgen::InsensitiveStr::Ascii("m"),
        dictgen::InsensitiveStr::Ascii("mthin"),
        dictgen::InsensitiveStr::Ascii("mthing"),
        dictgen::InsensitiveStr::Ascii("mthings"),
        dictgen::InsensitiveStr::Ascii("mwhere"),
    ],
    values: &[
        &["specialized"],
        &["some"],
        &["somethin"],
        &["something"],
        &["somethings"],
        &["somewhere"],
    ],
    range: 1..=7,
};

static WORD_SOC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOC_CHILDREN),
    value: None,
};

pub static WORD_SOC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ail"),
        dictgen::InsensitiveStr::Ascii("ailism"),
        dictgen::InsensitiveStr::Ascii("ailist"),
        dictgen::InsensitiveStr::Ascii("ailists"),
        dictgen::InsensitiveStr::Ascii("ailize"),
        dictgen::InsensitiveStr::Ascii("ailized"),
        dictgen::InsensitiveStr::Ascii("ailizing"),
        dictgen::InsensitiveStr::Ascii("ailly"),
        dictgen::InsensitiveStr::Ascii("alism"),
        dictgen::InsensitiveStr::Ascii("artes"),
        dictgen::InsensitiveStr::Ascii("eities"),
        dictgen::InsensitiveStr::Ascii("ekts"),
        dictgen::InsensitiveStr::Ascii("ialicing"),
        dictgen::InsensitiveStr::Ascii("ialim"),
        dictgen::InsensitiveStr::Ascii("ialini"),
        dictgen::InsensitiveStr::Ascii("ialisim"),
        dictgen::InsensitiveStr::Ascii("ialiss"),
        dictgen::InsensitiveStr::Ascii("ialistes"),
        dictgen::InsensitiveStr::Ascii("ialistisk"),
        dictgen::InsensitiveStr::Ascii("ialistos"),
        dictgen::InsensitiveStr::Ascii("ializare"),
        dictgen::InsensitiveStr::Ascii("ializng"),
        dictgen::InsensitiveStr::Ascii("ialogical"),
        dictgen::InsensitiveStr::Ascii("ialsim"),
        dictgen::InsensitiveStr::Ascii("ialsits"),
        dictgen::InsensitiveStr::Ascii("ialy"),
        dictgen::InsensitiveStr::Ascii("iapathic"),
        dictgen::InsensitiveStr::Ascii("iapaths"),
        dictgen::InsensitiveStr::Ascii("ieites"),
        dictgen::InsensitiveStr::Ascii("ilaism"),
        dictgen::InsensitiveStr::Ascii("ilaist"),
        dictgen::InsensitiveStr::Ascii("ilaists"),
        dictgen::InsensitiveStr::Ascii("ilaized"),
        dictgen::InsensitiveStr::Ascii("ioecenomic"),
        dictgen::InsensitiveStr::Ascii("ioecomonic"),
        dictgen::InsensitiveStr::Ascii("ioeconimc"),
        dictgen::InsensitiveStr::Ascii("ioeconimic"),
        dictgen::InsensitiveStr::Ascii("ioeconmic"),
        dictgen::InsensitiveStr::Ascii("ioligical"),
        dictgen::InsensitiveStr::Ascii("iologia"),
        dictgen::InsensitiveStr::Ascii("iologial"),
        dictgen::InsensitiveStr::Ascii("iopatas"),
        dictgen::InsensitiveStr::Ascii("iopatch"),
        dictgen::InsensitiveStr::Ascii("iopathes"),
        dictgen::InsensitiveStr::Ascii("iopathis"),
        dictgen::InsensitiveStr::Ascii("iopati"),
        dictgen::InsensitiveStr::Ascii("iopatic"),
        dictgen::InsensitiveStr::Ascii("iopats"),
        dictgen::InsensitiveStr::Ascii("iophatic"),
        dictgen::InsensitiveStr::Ascii("iopolical"),
        dictgen::InsensitiveStr::Ascii("ities"),
        dictgen::InsensitiveStr::Ascii("ratease"),
        dictgen::InsensitiveStr::Ascii("ratees"),
        dictgen::InsensitiveStr::Ascii("rateks"),
        dictgen::InsensitiveStr::Ascii("reboard"),
        dictgen::InsensitiveStr::Ascii("ttish"),
    ],
    values: &[
        &["social"],
        &["socialism"],
        &["socialist"],
        &["socialists"],
        &["socialize"],
        &["socialized"],
        &["socializing"],
        &["socially"],
        &["socialism"],
        &["socrates"],
        &["societies"],
        &["sockets"],
        &["socializing"],
        &["socialism"],
        &["socializing"],
        &["socialism"],
        &["socialists"],
        &["socialists"],
        &["socialists"],
        &["socialists"],
        &["socialize"],
        &["socializing"],
        &["sociological"],
        &["socialism"],
        &["socialists"],
        &["socially"],
        &["sociopathic"],
        &["sociopaths"],
        &["societies"],
        &["socialism"],
        &["socialist"],
        &["socialists"],
        &["socialized"],
        &["socioeconomic"],
        &["socioeconomic"],
        &["socioeconomic"],
        &["socioeconomic"],
        &["socioeconomic"],
        &["sociological"],
        &["sociological"],
        &["sociological"],
        &["sociopaths"],
        &["sociopaths"],
        &["sociopaths"],
        &["sociopaths"],
        &["sociopathic"],
        &["sociopathic"],
        &["sociopaths"],
        &["sociopathic"],
        &["sociological"],
        &["societies"],
        &["socrates"],
        &["socrates"],
        &["socrates"],
        &["scoreboard"],
        &["scottish"],
    ],
    range: 3..=10,
};

static WORD_SOB_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOB_CHILDREN),
    value: None,
};

pub static WORD_SOB_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("erity"),
        dictgen::InsensitiveStr::Ascii("reity"),
    ],
    values: &[&["sobriety"], &["sobriety"]],
    range: 5..=5,
};

static WORD_SOA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SOA_CHILDREN),
    value: None,
};

pub static WORD_SOA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("lris")],
    values: &[&["solaris"]],
    range: 4..=4,
};

static WORD_SN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SN_CHILDREN),
    value: None,
};

pub static WORD_SN_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("adler"),
        dictgen::InsensitiveStr::Ascii("adstorm"),
        dictgen::InsensitiveStr::Ascii("adwiches"),
        dictgen::InsensitiveStr::Ascii("aped"),
        dictgen::InsensitiveStr::Ascii("aphot"),
        dictgen::InsensitiveStr::Ascii("aphsot"),
        dictgen::InsensitiveStr::Ascii("aping"),
        dictgen::InsensitiveStr::Ascii("appng"),
        dictgen::InsensitiveStr::Ascii("apsnot"),
        dictgen::InsensitiveStr::Ascii("apsnots"),
        dictgen::InsensitiveStr::Ascii("eeks"),
        dictgen::InsensitiveStr::Ascii("ese"),
        dictgen::InsensitiveStr::Ascii("etries"),
        dictgen::InsensitiveStr::Ascii("igles"),
        dictgen::InsensitiveStr::Ascii("ipet"),
        dictgen::InsensitiveStr::Ascii("ipets"),
        dictgen::InsensitiveStr::Ascii("ippent"),
        dictgen::InsensitiveStr::Ascii("ippert"),
        dictgen::InsensitiveStr::Ascii("ippes"),
        dictgen::InsensitiveStr::Ascii("ippetts"),
        dictgen::InsensitiveStr::Ascii("odwen"),
        dictgen::InsensitiveStr::Ascii("owbaling"),
        dictgen::InsensitiveStr::Ascii("owballes"),
        dictgen::InsensitiveStr::Ascii("owballling"),
        dictgen::InsensitiveStr::Ascii("owballls"),
        dictgen::InsensitiveStr::Ascii("owbals"),
        dictgen::InsensitiveStr::Ascii("owbaording"),
        dictgen::InsensitiveStr::Ascii("owboaring"),
        dictgen::InsensitiveStr::Ascii("owbolling"),
        dictgen::InsensitiveStr::Ascii("owfalke"),
        dictgen::InsensitiveStr::Ascii("owfalling"),
        dictgen::InsensitiveStr::Ascii("owflaek"),
        dictgen::InsensitiveStr::Ascii("owlfake"),
        dictgen::InsensitiveStr::Ascii("pashot"),
        dictgen::InsensitiveStr::Ascii("pashots"),
        dictgen::InsensitiveStr::Ascii("ugglie"),
        dictgen::InsensitiveStr::Ascii("woballs"),
        dictgen::InsensitiveStr::Ascii("woden"),
        dictgen::InsensitiveStr::Ascii("yc"),
        dictgen::InsensitiveStr::Ascii("ycing"),
        dictgen::InsensitiveStr::Ascii("ydrome"),
        dictgen::InsensitiveStr::Ascii("yergy"),
        dictgen::InsensitiveStr::Ascii("yopsis"),
        dictgen::InsensitiveStr::Ascii("ytax"),
        dictgen::InsensitiveStr::Ascii("ythesis"),
        dictgen::InsensitiveStr::Ascii("ythetic"),
    ],
    values: &[
        &["sandler"],
        &["sandstorm"],
        &["sandwiches"],
        &["snapped"],
        &["snapshot"],
        &["snapshot"],
        &["snapping"],
        &["snapping"],
        &["snapshot"],
        &["snapshots"],
        &["sneaks"],
        &["sneeze"],
        &["sentries"],
        &["singles"],
        &["snippet"],
        &["snippets"],
        &["snippet"],
        &["snippet"],
        &["snippets"],
        &["snippets"],
        &["snowden"],
        &["snowballing"],
        &["snowballs"],
        &["snowballing"],
        &["snowballs"],
        &["snowballs"],
        &["snowboarding"],
        &["snowboarding"],
        &["snowballing"],
        &["snowflake"],
        &["snowballing"],
        &["snowflake"],
        &["snowflake"],
        &["snapshot"],
        &["snapshots"],
        &["snuggle"],
        &["snowballs"],
        &["snowden"],
        &["sync"],
        &["syncing"],
        &["syndrome"],
        &["synergy"],
        &["synopsis"],
        &["syntax"],
        &["synthesis"],
        &["synthetic"],
    ],
    range: 2..=10,
};

static WORD_SM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SM_CHILDREN),
    value: None,
};

pub static WORD_SM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ackdwon"),
        dictgen::InsensitiveStr::Ascii("ae"),
        dictgen::InsensitiveStr::Ascii("al"),
        dictgen::InsensitiveStr::Ascii("aler"),
        dictgen::InsensitiveStr::Ascii("allar"),
        dictgen::InsensitiveStr::Ascii("alles"),
        dictgen::InsensitiveStr::Ascii("aple"),
        dictgen::InsensitiveStr::Ascii("aples"),
        dictgen::InsensitiveStr::Ascii("arpthone"),
        dictgen::InsensitiveStr::Ascii("artare"),
        dictgen::InsensitiveStr::Ascii("arthpone"),
        dictgen::InsensitiveStr::Ascii("arthpones"),
        dictgen::InsensitiveStr::Ascii("artre"),
        dictgen::InsensitiveStr::Ascii("aurai"),
        dictgen::InsensitiveStr::Ascii("ealting"),
        dictgen::InsensitiveStr::Ascii("eesters"),
        dictgen::InsensitiveStr::Ascii("ething"),
        dictgen::InsensitiveStr::Ascii("ll"),
        dictgen::InsensitiveStr::Ascii("ller"),
        dictgen::InsensitiveStr::Ascii("oe"),
        dictgen::InsensitiveStr::Ascii("oot"),
        dictgen::InsensitiveStr::Ascii("ooter"),
        dictgen::InsensitiveStr::Ascii("oothign"),
        dictgen::InsensitiveStr::Ascii("ooting"),
        dictgen::InsensitiveStr::Ascii("outh"),
        dictgen::InsensitiveStr::Ascii("outhness"),
        dictgen::InsensitiveStr::Ascii("ove"),
        dictgen::InsensitiveStr::Ascii("pt"),
    ],
    values: &[
        &["smackdown"],
        &["same"],
        &["small"],
        &["smaller"],
        &["smaller"],
        &["smallest"],
        &["sample"],
        &["samples"],
        &["smartphones"],
        &["smarter"],
        &["smartphone"],
        &["smartphones"],
        &["smarter"],
        &["samurai"],
        &["smelting"],
        &["semesters"],
        &["something"],
        &["small", "smell"],
        &["smaller"],
        &["some"],
        &["smooth"],
        &["smoother"],
        &["smoothing"],
        &["smoothing"],
        &["smooth"],
        &["smoothness"],
        &["move"],
        &["smtp", "smtpe"],
    ],
    range: 2..=9,
};

static WORD_SL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SL_CHILDREN),
    value: None,
};

pub static WORD_SL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("aptoon"),
        dictgen::InsensitiveStr::Ascii("ase"),
        dictgen::InsensitiveStr::Ascii("ases"),
        dictgen::InsensitiveStr::Ascii("ashs"),
        dictgen::InsensitiveStr::Ascii("aughted"),
        dictgen::InsensitiveStr::Ascii("aughterd"),
        dictgen::InsensitiveStr::Ascii("augterhouses"),
        dictgen::InsensitiveStr::Ascii("augther"),
        dictgen::InsensitiveStr::Ascii("augthered"),
        dictgen::InsensitiveStr::Ascii("augthering"),
        dictgen::InsensitiveStr::Ascii("avage"),
        dictgen::InsensitiveStr::Ascii("averly"),
        dictgen::InsensitiveStr::Ascii("ayign"),
        dictgen::InsensitiveStr::Ascii("diers"),
        dictgen::InsensitiveStr::Ascii("ect"),
        dictgen::InsensitiveStr::Ascii("ected"),
        dictgen::InsensitiveStr::Ascii("ecting"),
        dictgen::InsensitiveStr::Ascii("ection"),
        dictgen::InsensitiveStr::Ascii("eect"),
        dictgen::InsensitiveStr::Ascii("eeped"),
        dictgen::InsensitiveStr::Ascii("eepp"),
        dictgen::InsensitiveStr::Ascii("efies"),
        dictgen::InsensitiveStr::Ascii("efishness"),
        dictgen::InsensitiveStr::Ascii("icable"),
        dictgen::InsensitiveStr::Ascii("ienced"),
        dictgen::InsensitiveStr::Ascii("ient"),
        dictgen::InsensitiveStr::Ascii("iently"),
        dictgen::InsensitiveStr::Ascii("ighlty"),
        dictgen::InsensitiveStr::Ascii("ighly"),
        dictgen::InsensitiveStr::Ascii("ightl"),
        dictgen::InsensitiveStr::Ascii("ighty"),
        dictgen::InsensitiveStr::Ascii("ignt"),
        dictgen::InsensitiveStr::Ascii("igntly"),
        dictgen::InsensitiveStr::Ascii("igth"),
        dictgen::InsensitiveStr::Ascii("igthly"),
        dictgen::InsensitiveStr::Ascii("igtly"),
        dictgen::InsensitiveStr::Ascii("iped"),
        dictgen::InsensitiveStr::Ascii("ipperies"),
        dictgen::InsensitiveStr::Ascii("ipperly"),
        dictgen::InsensitiveStr::Ascii("ippes"),
        dictgen::InsensitiveStr::Ascii("ippey"),
        dictgen::InsensitiveStr::Ascii("iseshow"),
        dictgen::InsensitiveStr::Ascii("oughtering"),
        dictgen::InsensitiveStr::Ascii("owy"),
        dictgen::InsensitiveStr::Ascii("uaghter"),
        dictgen::InsensitiveStr::Ascii("uaghtered"),
        dictgen::InsensitiveStr::Ascii("uaghtering"),
        dictgen::InsensitiveStr::Ascii("uggify"),
    ],
    values: &[
        &["splatoon"],
        &["slash"],
        &["slashes"],
        &["slashes"],
        &["slaughtered"],
        &["slaughtered"],
        &["slaughterhouses"],
        &["slaughter"],
        &["slaughtered"],
        &["slaughtering"],
        &["salvage"],
        &["slavery"],
        &["slaying"],
        &["sliders"],
        &["select"],
        &["selected"],
        &["selecting"],
        &["selection"],
        &["select"],
        &["slept"],
        &["sleep"],
        &["selfies"],
        &["selfishness"],
        &["sliceable"],
        &["silenced"],
        &["silent"],
        &["silently"],
        &["slightly"],
        &["slightly"],
        &["slightly"],
        &["slightly"],
        &["slight"],
        &["slightly"],
        &["slight"],
        &["slightly"],
        &["slightly"],
        &["slipped"],
        &["slippers"],
        &["slippery"],
        &["slippers"],
        &["slippery"],
        &["slideshow"],
        &["slaughtering"],
        &["slowly"],
        &["slaughter"],
        &["slaughtered"],
        &["slaughtering"],
        &["slugify"],
    ],
    range: 3..=12,
};

static WORD_SK_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SK_CHILDREN),
    value: None,
};

static WORD_SK_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SKA_NODE),
    None,
    None,
    None,
    Some(&WORD_SKE_NODE),
    None,
    None,
    None,
    Some(&WORD_SKI_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
    Some(&WORD_SKP_NODE),
    None,
    Some(&WORD_SKR_NODE),
    None,
    Some(&WORD_SKT_NODE),
    None,
    None,
    Some(&WORD_SKW_NODE),
    None,
    Some(&WORD_SKY_NODE),
    None,
];

static WORD_SKY_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SKY_CHILDREN),
    value: None,
};

pub static WORD_SKY_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("p"),
        dictgen::InsensitiveStr::Ascii("walkr"),
    ],
    values: &[&["skip", "skype"], &["skywalker"]],
    range: 1..=5,
};

static WORD_SKW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SKW_CHILDREN),
    value: None,
};

pub static WORD_SKW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("yard")],
    values: &[&["skyward"]],
    range: 4..=4,
};

static WORD_SKT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SKT_CHILDREN),
    value: None,
};

pub static WORD_SKT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("eches"),
        dictgen::InsensitiveStr::Ascii("echy"),
    ],
    values: &[&["sketches"], &["sketchy"]],
    range: 4..=5,
};

static WORD_SKR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SKR_CHILDREN),
    value: None,
};

pub static WORD_SKR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("awberries"),
        dictgen::InsensitiveStr::Ascii("imish"),
    ],
    values: &[&["strawberries"], &["skirmish"]],
    range: 5..=9,
};

static WORD_SKP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SKP_CHILDREN),
    value: None,
};

pub static WORD_SKP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("etic"),
        dictgen::InsensitiveStr::Ascii("eticism"),
        dictgen::InsensitiveStr::Ascii("etics"),
    ],
    values: &[&["skeptic"], &["skepticism"], &["skeptics"]],
    range: 4..=7,
};

static WORD_SKI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SKI_CHILDREN),
    value: None,
};

pub static WORD_SKI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("lfull"),
        dictgen::InsensitiveStr::Ascii("llfull"),
        dictgen::InsensitiveStr::Ascii("llfullness"),
        dictgen::InsensitiveStr::Ascii("llhosts"),
        dictgen::InsensitiveStr::Ascii("llshits"),
        dictgen::InsensitiveStr::Ascii("llshoot"),
        dictgen::InsensitiveStr::Ascii("llshoots"),
        dictgen::InsensitiveStr::Ascii("llshosts"),
        dictgen::InsensitiveStr::Ascii("llslots"),
        dictgen::InsensitiveStr::Ascii("llsofts"),
        dictgen::InsensitiveStr::Ascii("llsshot"),
        dictgen::InsensitiveStr::Ascii("llsto"),
        dictgen::InsensitiveStr::Ascii("mrish"),
        dictgen::InsensitiveStr::Ascii("pd"),
        dictgen::InsensitiveStr::Ascii("ped"),
        dictgen::InsensitiveStr::Ascii("ping"),
        dictgen::InsensitiveStr::Ascii("pp"),
        dictgen::InsensitiveStr::Ascii("ppd"),
        dictgen::InsensitiveStr::Ascii("pt"),
        dictgen::InsensitiveStr::Ascii("rmiches"),
    ],
    values: &[
        &["skilful", "skilful"],
        &["skillful", "skillful", "skillfully", "skillfully"],
        &["skillfulness", "skillfulness"],
        &["skillshots"],
        &["skillshots"],
        &["skillshots"],
        &["skillshots"],
        &["skillshots"],
        &["skillshots"],
        &["skillshots"],
        &["skillshots"],
        &["skillshots"],
        &["skirmish"],
        &["skipped"],
        &["skipped", "skyped"],
        &["skipping"],
        &["skip", "skipped"],
        &["skipped"],
        &["skip", "skype", "skipped"],
        &["skirmish"],
    ],
    range: 2..=10,
};

static WORD_SKE_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SKE_CHILDREN),
    value: None,
};

pub static WORD_SKE_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cth"),
        dictgen::InsensitiveStr::Ascii("cthes"),
        dictgen::InsensitiveStr::Ascii("cthy"),
        dictgen::InsensitiveStr::Ascii("ep"),
        dictgen::InsensitiveStr::Ascii("latel"),
        dictgen::InsensitiveStr::Ascii("letaal"),
        dictgen::InsensitiveStr::Ascii("letl"),
        dictgen::InsensitiveStr::Ascii("letones"),
        dictgen::InsensitiveStr::Ascii("letos"),
        dictgen::InsensitiveStr::Ascii("lton"),
        dictgen::InsensitiveStr::Ascii("pitcal"),
        dictgen::InsensitiveStr::Ascii("pt"),
        dictgen::InsensitiveStr::Ascii("ptecism"),
        dictgen::InsensitiveStr::Ascii("pticals"),
        dictgen::InsensitiveStr::Ascii("pticim"),
        dictgen::InsensitiveStr::Ascii("pticisim"),
        dictgen::InsensitiveStr::Ascii("pticles"),
        dictgen::InsensitiveStr::Ascii("pticons"),
        dictgen::InsensitiveStr::Ascii("ptis"),
        dictgen::InsensitiveStr::Ascii("ptisicm"),
        dictgen::InsensitiveStr::Ascii("ptisism"),
        dictgen::InsensitiveStr::Ascii("tchey"),
        dictgen::InsensitiveStr::Ascii("tchs"),
        dictgen::InsensitiveStr::Ascii("tchysex"),
        dictgen::InsensitiveStr::Ascii("tpic"),
        dictgen::InsensitiveStr::Ascii("tpical"),
        dictgen::InsensitiveStr::Ascii("tpicism"),
        dictgen::InsensitiveStr::Ascii("tpics"),
    ],
    values: &[
        &["sketch"],
        &["sketches"],
        &["sketchy"],
        &["skip"],
        &["skeletal"],
        &["skeletal"],
        &["skeletal"],
        &["skeletons"],
        &["skeletons"],
        &["skeleton"],
        &["skeptical"],
        &["skipped"],
        &["skepticism"],
        &["skeptics"],
        &["skepticism"],
        &["skepticism"],
        &["skeptics"],
        &["skeptics"],
        &["skeptics"],
        &["skepticism"],
        &["skepticism"],
        &["sketchy"],
        &["sketches"],
        &["sketches"],
        &["skeptic"],
        &["skeptical"],
        &["skepticism"],
        &["skeptics"],
    ],
    range: 2..=8,
};

static WORD_SKA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SKA_CHILDREN),
    value: None,
};

pub static WORD_SKA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gerak"),
        dictgen::InsensitiveStr::Ascii("lar"),
        dictgen::InsensitiveStr::Ascii("ndinavian"),
        dictgen::InsensitiveStr::Ascii("tebaord"),
        dictgen::InsensitiveStr::Ascii("tebaording"),
        dictgen::InsensitiveStr::Ascii("tebaords"),
        dictgen::InsensitiveStr::Ascii("teboad"),
        dictgen::InsensitiveStr::Ascii("teboader"),
        dictgen::InsensitiveStr::Ascii("teboaring"),
        dictgen::InsensitiveStr::Ascii("teborad"),
        dictgen::InsensitiveStr::Ascii("teborading"),
        dictgen::InsensitiveStr::Ascii("tebored"),
        dictgen::InsensitiveStr::Ascii("tebrand"),
        dictgen::InsensitiveStr::Ascii("teing"),
    ],
    values: &[
        &["skagerrak"],
        &["scalar"],
        &["scandinavian"],
        &["skateboard"],
        &["skateboarding"],
        &["skateboard"],
        &["skateboard"],
        &["skateboard"],
        &["skateboarding"],
        &["skateboard"],
        &["skateboarding"],
        &["skateboard"],
        &["skateboard"],
        &["skating"],
    ],
    range: 3..=10,
};

static WORD_SI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SI_CHILDREN),
    value: None,
};

static WORD_SI_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    None,
    Some(&WORD_SIB_NODE),
    Some(&WORD_SIC_NODE),
    Some(&WORD_SID_NODE),
    Some(&WORD_SIE_NODE),
    Some(&WORD_SIF_NODE),
    Some(&WORD_SIG_NODE),
    Some(&WORD_SIH_NODE),
    None,
    None,
    None,
    Some(&WORD_SIL_NODE),
    Some(&WORD_SIM_NODE),
    Some(&WORD_SIN_NODE),
    Some(&WORD_SIO_NODE),
    Some(&WORD_SIP_NODE),
    None,
    Some(&WORD_SIR_NODE),
    Some(&WORD_SIS_NODE),
    Some(&WORD_SIT_NODE),
    Some(&WORD_SIU_NODE),
    Some(&WORD_SIV_NODE),
    Some(&WORD_SIW_NODE),
    Some(&WORD_SIX_NODE),
    None,
    Some(&WORD_SIZ_NODE),
];

static WORD_SIZ_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIZ_CHILDREN),
    value: None,
};

pub static WORD_SIZ_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ebale"),
        dictgen::InsensitiveStr::Ascii("re"),
    ],
    values: &[&["sizeable"], &["size"]],
    range: 2..=5,
};

static WORD_SIX_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIX_CHILDREN),
    value: None,
};

pub static WORD_SIX_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("tin")],
    values: &[&["sistine", "sixteen"]],
    range: 3..=3,
};

static WORD_SIW_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIW_CHILDREN),
    value: None,
};

pub static WORD_SIW_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("tch"),
        dictgen::InsensitiveStr::Ascii("tched"),
        dictgen::InsensitiveStr::Ascii("tching"),
    ],
    values: &[&["switch"], &["switched"], &["switching"]],
    range: 3..=6,
};

static WORD_SIV_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIV_CHILDREN),
    value: None,
};

pub static WORD_SIV_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ible")],
    values: &[&["visible"]],
    range: 4..=4,
};

static WORD_SIU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIU_CHILDREN),
    value: None,
};

pub static WORD_SIU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("tational"),
        dictgen::InsensitiveStr::Ascii("te"),
    ],
    values: &[&["situational"], &["suite"]],
    range: 2..=8,
};

static WORD_SIT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIT_CHILDREN),
    value: None,
};

pub static WORD_SIT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ation"),
        dictgen::InsensitiveStr::Ascii("ations"),
        dictgen::InsensitiveStr::Ascii("aution"),
        dictgen::InsensitiveStr::Ascii("autional"),
        dictgen::InsensitiveStr::Ascii("autions"),
        dictgen::InsensitiveStr::Ascii("ck"),
        dictgen::InsensitiveStr::Ascii("ckers"),
        dictgen::InsensitiveStr::Ascii("eu"),
        dictgen::InsensitiveStr::Ascii("ll"),
        dictgen::InsensitiveStr::Ascii("muli"),
        dictgen::InsensitiveStr::Ascii("rring"),
        dictgen::InsensitiveStr::Ascii("uacional"),
        dictgen::InsensitiveStr::Ascii("uatinal"),
        dictgen::InsensitiveStr::Ascii("uationals"),
        dictgen::InsensitiveStr::Ascii("uationly"),
        dictgen::InsensitiveStr::Ascii("uationnal"),
        dictgen::InsensitiveStr::Ascii("uatuion"),
        dictgen::InsensitiveStr::Ascii("uatuions"),
        dictgen::InsensitiveStr::Ascii("uatution"),
        dictgen::InsensitiveStr::Ascii("uatutions"),
        dictgen::InsensitiveStr::Ascii("ubbornness"),
        dictgen::InsensitiveStr::Ascii("udio"),
        dictgen::InsensitiveStr::Ascii("udios"),
        dictgen::InsensitiveStr::Ascii("uration"),
        dictgen::InsensitiveStr::Ascii("urations"),
        dictgen::InsensitiveStr::Ascii("utaion"),
        dictgen::InsensitiveStr::Ascii("utaions"),
        dictgen::InsensitiveStr::Ascii("utation"),
        dictgen::InsensitiveStr::Ascii("utations"),
    ],
    values: &[
        &["situation"],
        &["situations"],
        &["situation"],
        &["situational"],
        &["situations"],
        &["stick"],
        &["stickers"],
        &["site"],
        &["still"],
        &["stimuli"],
        &["stirring"],
        &["situational"],
        &["situational"],
        &["situations", "situational"],
        &["situational", "situationally"],
        &["situational"],
        &["situation"],
        &["situations"],
        &["situation"],
        &["situations"],
        &["stubbornness"],
        &["studio"],
        &["studios"],
        &["situation"],
        &["situations"],
        &["situation"],
        &["situations"],
        &["situation"],
        &["situations"],
    ],
    range: 2..=10,
};

static WORD_SIS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIS_CHILDREN),
    value: None,
};

pub static WORD_SIS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("nce"),
        dictgen::InsensitiveStr::Ascii("tem"),
        dictgen::InsensitiveStr::Ascii("tematically"),
        dictgen::InsensitiveStr::Ascii("tematics"),
        dictgen::InsensitiveStr::Ascii("tematies"),
        dictgen::InsensitiveStr::Ascii("tematising"),
        dictgen::InsensitiveStr::Ascii("tematizing"),
        dictgen::InsensitiveStr::Ascii("tematy"),
        dictgen::InsensitiveStr::Ascii("temed"),
        dictgen::InsensitiveStr::Ascii("temic"),
        dictgen::InsensitiveStr::Ascii("temically"),
        dictgen::InsensitiveStr::Ascii("temics"),
        dictgen::InsensitiveStr::Ascii("teming"),
        dictgen::InsensitiveStr::Ascii("temist"),
        dictgen::InsensitiveStr::Ascii("temists"),
        dictgen::InsensitiveStr::Ascii("temize"),
        dictgen::InsensitiveStr::Ascii("temized"),
        dictgen::InsensitiveStr::Ascii("temizes"),
        dictgen::InsensitiveStr::Ascii("temizing"),
        dictgen::InsensitiveStr::Ascii("tems"),
    ],
    values: &[
        &["size", "sisal"],
        &["since"],
        &["system"],
        &["systematically"],
        &["systematics"],
        &["systematies"],
        &["systematising"],
        &["systematizing"],
        &["systematy"],
        &["systemed"],
        &["systemic"],
        &["systemically"],
        &["systemics"],
        &["systemic", "stemming"],
        &["systemist"],
        &["systemists"],
        &["systemize"],
        &["systemized"],
        &["systemizes"],
        &["systemizing"],
        &["systems"],
    ],
    range: 1..=11,
};

static WORD_SIR_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIR_CHILDREN),
    value: None,
};

pub static WORD_SIR_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("cle"),
        dictgen::InsensitiveStr::Ascii("cles"),
        dictgen::InsensitiveStr::Ascii("cular"),
        dictgen::InsensitiveStr::Ascii("ect"),
        dictgen::InsensitiveStr::Ascii("ected"),
        dictgen::InsensitiveStr::Ascii("ecting"),
        dictgen::InsensitiveStr::Ascii("ection"),
        dictgen::InsensitiveStr::Ascii("ectional"),
        dictgen::InsensitiveStr::Ascii("ectionalities"),
        dictgen::InsensitiveStr::Ascii("ectionality"),
        dictgen::InsensitiveStr::Ascii("ectionals"),
        dictgen::InsensitiveStr::Ascii("ectionless"),
        dictgen::InsensitiveStr::Ascii("ections"),
        dictgen::InsensitiveStr::Ascii("ective"),
        dictgen::InsensitiveStr::Ascii("ectives"),
        dictgen::InsensitiveStr::Ascii("ectly"),
        dictgen::InsensitiveStr::Ascii("ectness"),
        dictgen::InsensitiveStr::Ascii("ector"),
        dictgen::InsensitiveStr::Ascii("ectories"),
        dictgen::InsensitiveStr::Ascii("ectors"),
        dictgen::InsensitiveStr::Ascii("ectory"),
        dictgen::InsensitiveStr::Ascii("ects"),
    ],
    values: &[
        &["circle"],
        &["circles"],
        &["circular"],
        &["direct"],
        &["directed"],
        &["directing"],
        &["direction"],
        &["directional"],
        &["directionalities"],
        &["directionality"],
        &["directionals"],
        &["directionless"],
        &["directions"],
        &["directive"],
        &["directives"],
        &["directly"],
        &["directness"],
        &["director"],
        &["directories"],
        &["directors"],
        &["directory"],
        &["directs"],
    ],
    range: 3..=13,
};

static WORD_SIP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIP_CHILDREN),
    value: None,
};

pub static WORD_SIP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ly")],
    values: &[&["simply"]],
    range: 2..=2,
};

static WORD_SIO_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIO_CHILDREN),
    value: None,
};

pub static WORD_SIO_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("nist"),
        dictgen::InsensitiveStr::Ascii("nists"),
    ],
    values: &[&["zionist"], &["zionists"]],
    range: 4..=5,
};

static WORD_SIN_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SIN_CHILDREN),
    value: None,
};

static WORD_SIN_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SINA_NODE),
    None,
    Some(&WORD_SINC_NODE),
    None,
    None,
    None,
    Some(&WORD_SING_NODE),
    None,
    Some(&WORD_SINI_NODE),
    None,
    None,
    Some(&WORD_SINL_NODE),
    None,
    None,
    None,
    Some(&WORD_SINP_NODE),
    None,
    None,
    Some(&WORD_SINS_NODE),
    Some(&WORD_SINT_NODE),
    None,
    None,
    None,
    None,
    None,
    None,
];

static WORD_SINT_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SINT_CHILDREN),
    value: None,
};

pub static WORD_SINT_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ac"),
        dictgen::InsensitiveStr::Ascii("acks"),
        dictgen::InsensitiveStr::Ascii("acs"),
        dictgen::InsensitiveStr::Ascii("act"),
        dictgen::InsensitiveStr::Ascii("acts"),
        dictgen::InsensitiveStr::Ascii("ak"),
        dictgen::InsensitiveStr::Ascii("aks"),
        dictgen::InsensitiveStr::Ascii("akt"),
        dictgen::InsensitiveStr::Ascii("akts"),
        dictgen::InsensitiveStr::Ascii("ax"),
    ],
    values: &[
        &["syntax"],
        &["syntax"],
        &["syntax"],
        &["syntax"],
        &["syntax"],
        &["syntax"],
        &["syntax"],
        &["syntax"],
        &["syntax"],
        &["syntax"],
    ],
    range: 2..=4,
};

static WORD_SINS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SINS_CHILDREN),
    value: None,
};

pub static WORD_SINS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("iter"),
    ],
    values: &[&["sines", "since"], &["sinister"]],
    range: 1..=4,
};

static WORD_SINP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SINP_CHILDREN),
    value: None,
};

pub static WORD_SINP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("ly")],
    values: &[&["simply"]],
    range: 2..=2,
};

static WORD_SINL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SINL_CHILDREN),
    value: None,
};

pub static WORD_SINL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ge"),
        dictgen::InsensitiveStr::Ascii("geplayer"),
        dictgen::InsensitiveStr::Ascii("ges"),
    ],
    values: &[&["single"], &["singleplayer"], &["singles"]],
    range: 2..=8,
};

static WORD_SINI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SINI_CHILDREN),
    value: None,
};

pub static WORD_SINI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("stre")],
    values: &[&["sinister"]],
    range: 4..=4,
};

static WORD_SING_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SING_CHILDREN),
    value: None,
};

pub static WORD_SING_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("al"),
        dictgen::InsensitiveStr::Ascii("aled"),
        dictgen::InsensitiveStr::Ascii("als"),
        dictgen::InsensitiveStr::Ascii("ature"),
        dictgen::InsensitiveStr::Ascii("atures"),
        dictgen::InsensitiveStr::Ascii("el"),
        dictgen::InsensitiveStr::Ascii("elar"),
        dictgen::InsensitiveStr::Ascii("elarity"),
        dictgen::InsensitiveStr::Ascii("elarly"),
        dictgen::InsensitiveStr::Ascii("eled"),
        dictgen::InsensitiveStr::Ascii("eles"),
        dictgen::InsensitiveStr::Ascii("elplayer"),
        dictgen::InsensitiveStr::Ascii("els"),
        dictgen::InsensitiveStr::Ascii("elton"),
        dictgen::InsensitiveStr::Ascii("ificand"),
        dictgen::InsensitiveStr::Ascii("ificantly"),
        dictgen::InsensitiveStr::Ascii("ify"),
        dictgen::InsensitiveStr::Ascii("lar"),
        dictgen::InsensitiveStr::Ascii("lepalyer"),
        dictgen::InsensitiveStr::Ascii("lers"),
        dictgen::InsensitiveStr::Ascii("ls"),
        dictgen::InsensitiveStr::Ascii("lton"),
        dictgen::InsensitiveStr::Ascii("ltons"),
        dictgen::InsensitiveStr::Ascii("luar"),
        dictgen::InsensitiveStr::Ascii("luarity"),
        dictgen::InsensitiveStr::Ascii("lular"),
        dictgen::InsensitiveStr::Ascii("lularly"),
        dictgen::InsensitiveStr::Ascii("nal"),
        dictgen::InsensitiveStr::Ascii("nalled"),
        dictgen::InsensitiveStr::Ascii("nals"),
        dictgen::InsensitiveStr::Ascii("ol"),
        dictgen::InsensitiveStr::Ascii("olar"),
        dictgen::InsensitiveStr::Ascii("oled"),
        dictgen::InsensitiveStr::Ascii("ols"),
        dictgen::InsensitiveStr::Ascii("ool"),
        dictgen::InsensitiveStr::Ascii("oolar"),
        dictgen::InsensitiveStr::Ascii("oolarity"),
        dictgen::InsensitiveStr::Ascii("oolarly"),
        dictgen::InsensitiveStr::Ascii("ooled"),
        dictgen::InsensitiveStr::Ascii("ools"),
        dictgen::InsensitiveStr::Ascii("paore"),
        dictgen::InsensitiveStr::Ascii("sog"),
        dictgen::InsensitiveStr::Ascii("ualrity"),
        dictgen::InsensitiveStr::Ascii("uarity"),
        dictgen::InsensitiveStr::Ascii("uarl"),
        dictgen::InsensitiveStr::Ascii("ulair"),
        dictgen::InsensitiveStr::Ascii("ulaire"),
        dictgen::InsensitiveStr::Ascii("ulairty"),
        dictgen::InsensitiveStr::Ascii("ularily"),
        dictgen::InsensitiveStr::Ascii("ulariy"),
        dictgen::InsensitiveStr::Ascii("ularty"),
        dictgen::InsensitiveStr::Ascii("ulary"),
        dictgen::InsensitiveStr::Ascii("ulaties"),
        dictgen::InsensitiveStr::Ascii("ulator"),
    ],
    values: &[
        &["signal", "single"],
        &["signaled"],
        &["signals"],
        &["signature"],
        &["signatures"],
        &["single", "signal"],
        &["singular"],
        &["singularity"],
        &["singularly"],
        &["singled", "signaled"],
        &["singles", "signals"],
        &["singleplayer"],
        &["singles"],
        &["singleton"],
        &["significand", "significant"],
        &["significantly"],
        &["signify"],
        &["singular"],
        &["singleplayer"],
        &["singles"],
        &["singles", "single"],
        &["singleton"],
        &["singletons"],
        &["singular"],
        &["singularity"],
        &["singular"],
        &["singularly"],
        &["signal"],
        &["signalled"],
        &["signals"],
        &["signal", "single"],
        &["singular"],
        &["signaled", "singled"],
        &["signals", "singles"],
        &["single", "signal"],
        &["singular"],
        &["singularity"],
        &["singularly"],
        &["singled", "signaled"],
        &["singles", "signals"],
        &["singapore"],
        &["singsong"],
        &["singularity"],
        &["singularity"],
        &["singular"],
        &["singular"],
        &["singular"],
        &["singularity"],
        &["singularity"],
        &["singularity"],
        &["singularity"],
        &["singularity"],
        &["singularities"],
        &["singular"],
    ],
    range: 2..=9,
};

static WORD_SINC_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SINC_CHILDREN),
    value: None,
};

pub static WORD_SINC_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ereley"),
        dictgen::InsensitiveStr::Ascii("erelly"),
        dictgen::InsensitiveStr::Ascii("erley"),
        dictgen::InsensitiveStr::Ascii("erly"),
    ],
    values: &[
        &["sincerely"],
        &["sincerely"],
        &["sincerely"],
        &["sincerely"],
    ],
    range: 4..=6,
};

static WORD_SINA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SINA_CHILDREN),
    value: None,
};

pub static WORD_SINA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("gpore"),
        dictgen::InsensitiveStr::Ascii("ture"),
    ],
    values: &[&["singapore"], &["signature"]],
    range: 4..=5,
};

static WORD_SIM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Nested(&WORD_SIM_CHILDREN),
    value: None,
};

static WORD_SIM_CHILDREN: [Option<&dictgen::DictTrieNode<&'static [&'static str]>>; 26] = [
    Some(&WORD_SIMA_NODE),
    None,
    None,
    None,
    Some(&WORD_SIME_NODE),
    None,
    Some(&WORD_SIMG_NODE),
    None,
    Some(&WORD_SIMI_NODE),
    None,
    None,
    Some(&WORD_SIML_NODE),
    Some(&WORD_SIMM_NODE),
    None,
    None,
    Some(&WORD_SIMP_NODE),
    None,
    None,
    Some(&WORD_SIMS_NODE),
    None,
    Some(&WORD_SIMU_NODE),
    None,
    None,
    None,
    None,
    None,
];

static WORD_SIMU_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIMU_CHILDREN),
    value: None,
};

pub static WORD_SIMU_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alted"),
        dictgen::InsensitiveStr::Ascii("altion"),
        dictgen::InsensitiveStr::Ascii("altions"),
        dictgen::InsensitiveStr::Ascii("altor"),
        dictgen::InsensitiveStr::Ascii("lacion"),
        dictgen::InsensitiveStr::Ascii("laiton"),
        dictgen::InsensitiveStr::Ascii("lantaneous"),
        dictgen::InsensitiveStr::Ascii("lantaneously"),
        dictgen::InsensitiveStr::Ascii("lataeous"),
        dictgen::InsensitiveStr::Ascii("lataeously"),
        dictgen::InsensitiveStr::Ascii("lataneity"),
        dictgen::InsensitiveStr::Ascii("lataneous"),
        dictgen::InsensitiveStr::Ascii("lataneously"),
        dictgen::InsensitiveStr::Ascii("latanious"),
        dictgen::InsensitiveStr::Ascii("lataniously"),
        dictgen::InsensitiveStr::Ascii("latanous"),
        dictgen::InsensitiveStr::Ascii("latanously"),
        dictgen::InsensitiveStr::Ascii("latation"),
        dictgen::InsensitiveStr::Ascii("latenous"),
        dictgen::InsensitiveStr::Ascii("latenously"),
        dictgen::InsensitiveStr::Ascii("latie"),
        dictgen::InsensitiveStr::Ascii("laties"),
        dictgen::InsensitiveStr::Ascii("latin"),
        dictgen::InsensitiveStr::Ascii("latious"),
        dictgen::InsensitiveStr::Ascii("lative"),
        dictgen::InsensitiveStr::Ascii("latneous"),
        dictgen::InsensitiveStr::Ascii("latneously"),
        dictgen::InsensitiveStr::Ascii("lato"),
        dictgen::InsensitiveStr::Ascii("latons"),
        dictgen::InsensitiveStr::Ascii("latore"),
        dictgen::InsensitiveStr::Ascii("ltaenous"),
        dictgen::InsensitiveStr::Ascii("ltaenously"),
        dictgen::InsensitiveStr::Ascii("ltainously"),
        dictgen::InsensitiveStr::Ascii("ltaneos"),
        dictgen::InsensitiveStr::Ascii("ltaneosly"),
        dictgen::InsensitiveStr::Ascii("ltaneoulsy"),
        dictgen::InsensitiveStr::Ascii("ltaneuos"),
        dictgen::InsensitiveStr::Ascii("ltaneuous"),
        dictgen::InsensitiveStr::Ascii("ltaneus"),
        dictgen::InsensitiveStr::Ascii("ltanious"),
        dictgen::InsensitiveStr::Ascii("ltaniously"),
        dictgen::InsensitiveStr::Ascii("ltanous"),
        dictgen::InsensitiveStr::Ascii("ltanously"),
        dictgen::InsensitiveStr::Ascii("lteanously"),
        dictgen::InsensitiveStr::Ascii("lteneous"),
        dictgen::InsensitiveStr::Ascii("taneously"),
    ],
    values: &[
        &["simulated"],
        &["simulation"],
        &["simulations"],
        &["simulator"],
        &["simulation"],
        &["simulations"],
        &["simultaneous"],
        &["simultaneously"],
        &["simultaneous"],
        &["simultaneously"],
        &["simultaneity"],
        &["simultaneous"],
        &["simultaneously"],
        &["simultaneous"],
        &["simultaneously"],
        &["simultaneous"],
        &["simultaneously"],
        &["simulation"],
        &["simultaneous"],
        &["simultaneously"],
        &["simulate"],
        &["simulate"],
        &["simulation"],
        &["simulations"],
        &["simulate"],
        &["simultaneous"],
        &["simultaneously"],
        &["simulation"],
        &["simulations"],
        &["simulate"],
        &["simultaneous"],
        &["simultaneously"],
        &["simultaneously"],
        &["simultaneous"],
        &["simultaneously"],
        &["simultaneously"],
        &["simultaneous"],
        &["simultaneous"],
        &["simultaneous"],
        &["simultaneous"],
        &["simultaneously"],
        &["simultaneous"],
        &["simultaneously"],
        &["simultaneously"],
        &["simultaneous"],
        &["simultaneously"],
    ],
    range: 4..=12,
};

static WORD_SIMS_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIMS_CHILDREN),
    value: None,
};

pub static WORD_SIMS_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("pon")],
    values: &[&["simpson"]],
    range: 3..=3,
};

static WORD_SIMP_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIMP_CHILDREN),
    value: None,
};

pub static WORD_SIMP_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("athizers"),
        dictgen::InsensitiveStr::Ascii("elst"),
        dictgen::InsensitiveStr::Ascii("ified"),
        dictgen::InsensitiveStr::Ascii("lefying"),
        dictgen::InsensitiveStr::Ascii("lei"),
        dictgen::InsensitiveStr::Ascii("let"),
        dictgen::InsensitiveStr::Ascii("lets"),
        dictgen::InsensitiveStr::Ascii("ley"),
        dictgen::InsensitiveStr::Ascii("lfy"),
        dictgen::InsensitiveStr::Ascii("licitly"),
        dictgen::InsensitiveStr::Ascii("lictic"),
        dictgen::InsensitiveStr::Ascii("licty"),
        dictgen::InsensitiveStr::Ascii("licy"),
        dictgen::InsensitiveStr::Ascii("lier"),
        dictgen::InsensitiveStr::Ascii("lies"),
        dictgen::InsensitiveStr::Ascii("liest"),
        dictgen::InsensitiveStr::Ascii("lificacion"),
        dictgen::InsensitiveStr::Ascii("lificaiton"),
        dictgen::InsensitiveStr::Ascii("lificating"),
        dictgen::InsensitiveStr::Ascii("lifiing"),
        dictgen::InsensitiveStr::Ascii("lifing"),
        dictgen::InsensitiveStr::Ascii("lifiy"),
        dictgen::InsensitiveStr::Ascii("lifyed"),
        dictgen::InsensitiveStr::Ascii("lifyng"),
        dictgen::InsensitiveStr::Ascii("lifys"),
        dictgen::InsensitiveStr::Ascii("liifcation"),
        dictgen::InsensitiveStr::Ascii("liifcations"),
        dictgen::InsensitiveStr::Ascii("lisitc"),
        dictgen::InsensitiveStr::Ascii("lisitic"),
        dictgen::InsensitiveStr::Ascii("lisity"),
        dictgen::InsensitiveStr::Ascii("listes"),
        dictgen::InsensitiveStr::Ascii("listisch"),
        dictgen::InsensitiveStr::Ascii("livity"),
        dictgen::InsensitiveStr::Ascii("liy"),
        dictgen::InsensitiveStr::Ascii("lyfied"),
        dictgen::InsensitiveStr::Ascii("lyifing"),
        dictgen::InsensitiveStr::Ascii("osn"),
        dictgen::InsensitiveStr::Ascii("y"),
    ],
    values: &[
        &["sympathizers"],
        &["simplest"],
        &["simplified"],
        &["simplifying"],
        &["simply"],
        &["simplest"],
        &["simplest"],
        &["simply"],
        &["simplify"],
        &["simplicity"],
        &["simplistic"],
        &["simplicity"],
        &["simplicity"],
        &["simpler"],
        &["implies", "simplifies"],
        &["simplest"],
        &["simplification"],
        &["simplification"],
        &["simplification"],
        &["simplifying"],
        &["simplifying"],
        &["simplify"],
        &["simplified"],
        &["simplifying"],
        &["simplifies"],
        &["simplification"],
        &["simplifications"],
        &["simplistic"],
        &["simplistic"],
        &["simplicity"],
        &["simplest"],
        &["simplistic"],
        &["simplicity"],
        &["simplify"],
        &["simplified"],
        &["simplifying"],
        &["simpson"],
        &["simply"],
    ],
    range: 1..=11,
};

static WORD_SIMM_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIMM_CHILDREN),
    value: None,
};

pub static WORD_SIMM_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("etric"),
        dictgen::InsensitiveStr::Ascii("etrical"),
        dictgen::InsensitiveStr::Ascii("etry"),
        dictgen::InsensitiveStr::Ascii("ilar"),
    ],
    values: &[
        &["symmetric"],
        &["symmetrical"],
        &["symmetry"],
        &["similar"],
    ],
    range: 4..=7,
};

static WORD_SIML_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIML_CHILDREN),
    value: None,
};

pub static WORD_SIML_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ar"),
        dictgen::InsensitiveStr::Ascii("arlity"),
        dictgen::InsensitiveStr::Ascii("arly"),
        dictgen::InsensitiveStr::Ascii("e"),
        dictgen::InsensitiveStr::Ascii("iar"),
        dictgen::InsensitiveStr::Ascii("iarities"),
        dictgen::InsensitiveStr::Ascii("iarity"),
        dictgen::InsensitiveStr::Ascii("iarly"),
        dictgen::InsensitiveStr::Ascii("icity"),
        dictgen::InsensitiveStr::Ascii("ified"),
        dictgen::InsensitiveStr::Ascii("iiar"),
        dictgen::InsensitiveStr::Ascii("uate"),
        dictgen::InsensitiveStr::Ascii("uated"),
        dictgen::InsensitiveStr::Ascii("uation"),
        dictgen::InsensitiveStr::Ascii("uations"),
        dictgen::InsensitiveStr::Ascii("uator"),
        dictgen::InsensitiveStr::Ascii("utaneous"),
        dictgen::InsensitiveStr::Ascii("utaneously"),
        dictgen::InsensitiveStr::Ascii("y"),
    ],
    values: &[
        &["similar"],
        &["similarity"],
        &["similarly"],
        &["simple", "smile", "simile"],
        &["similar"],
        &["similarities"],
        &["similarity"],
        &["similarly"],
        &["simplicity"],
        &["simplified"],
        &["similar"],
        &["simulate"],
        &["simulated"],
        &["simulation"],
        &["simulations"],
        &["simulator"],
        &["simultaneous"],
        &["simultaneously"],
        &["simply", "simile", "smiley"],
    ],
    range: 1..=10,
};

static WORD_SIMI_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIMI_CHILDREN),
    value: None,
};

pub static WORD_SIMI_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("alir"),
        dictgen::InsensitiveStr::Ascii("alr"),
        dictgen::InsensitiveStr::Ascii("ar"),
        dictgen::InsensitiveStr::Ascii("ilar"),
        dictgen::InsensitiveStr::Ascii("lair"),
        dictgen::InsensitiveStr::Ascii("lairty"),
        dictgen::InsensitiveStr::Ascii("laraties"),
        dictgen::InsensitiveStr::Ascii("lari"),
        dictgen::InsensitiveStr::Ascii("larily"),
        dictgen::InsensitiveStr::Ascii("larites"),
        dictgen::InsensitiveStr::Ascii("larlity"),
        dictgen::InsensitiveStr::Ascii("larlly"),
        dictgen::InsensitiveStr::Ascii("lart"),
        dictgen::InsensitiveStr::Ascii("lary"),
        dictgen::InsensitiveStr::Ascii("lat"),
        dictgen::InsensitiveStr::Ascii("lia"),
        dictgen::InsensitiveStr::Ascii("liair"),
        dictgen::InsensitiveStr::Ascii("liar"),
        dictgen::InsensitiveStr::Ascii("liarites"),
        dictgen::InsensitiveStr::Ascii("liarity"),
        dictgen::InsensitiveStr::Ascii("liarly"),
        dictgen::InsensitiveStr::Ascii("liarties"),
        dictgen::InsensitiveStr::Ascii("liarty"),
        dictgen::InsensitiveStr::Ascii("liary"),
        dictgen::InsensitiveStr::Ascii("lir"),
        dictgen::InsensitiveStr::Ascii("liraties"),
        dictgen::InsensitiveStr::Ascii("ltaneous"),
        dictgen::InsensitiveStr::Ascii("ltaneously"),
        dictgen::InsensitiveStr::Ascii("ly"),
    ],
    values: &[
        &["similar"],
        &["similar"],
        &["similar"],
        &["similar"],
        &["similar"],
        &["similarity"],
        &["similarities"],
        &["similar"],
        &["similarly"],
        &["similarities"],
        &["similarity"],
        &["similarly"],
        &["similarity"],
        &["similarly"],
        &["similar"],
        &["similar"],
        &["similar"],
        &["similar"],
        &["similarities"],
        &["similarity"],
        &["similarly"],
        &["similarities"],
        &["similarity"],
        &["similarity"],
        &["similar"],
        &["similarities"],
        &["simultaneous"],
        &["simultaneously"],
        &["simile", "smiley", "simply", "similarly"],
    ],
    range: 2..=10,
};

static WORD_SIMG_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIMG_CHILDREN),
    value: None,
};

pub static WORD_SIMG_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[dictgen::InsensitiveStr::Ascii("le")],
    values: &[&["single"]],
    range: 2..=2,
};

static WORD_SIME_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIME_CHILDREN),
    value: None,
};

pub static WORD_SIME_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ltaneous"),
        dictgen::InsensitiveStr::Ascii("ltaneously"),
        dictgen::InsensitiveStr::Ascii("ple"),
    ],
    values: &[&["simultaneous"], &["simultaneously"], &["simple"]],
    range: 3..=10,
};

static WORD_SIMA_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIMA_CHILDREN),
    value: None,
};

pub static WORD_SIMA_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("ltaneous"),
        dictgen::InsensitiveStr::Ascii("ltaneously"),
    ],
    values: &[&["simultaneous"], &["simultaneously"]],
    range: 8..=10,
};

static WORD_SIL_NODE: dictgen::DictTrieNode<&'static [&'static str]> = dictgen::DictTrieNode {
    children: dictgen::DictTrieChild::Flat(&WORD_SIL_CHILDREN),
    value: None,
};

pub static WORD_SIL_CHILDREN: dictgen::DictTable<&'static [&'static str]> = dictgen::DictTable {
    keys: &[
        dictgen::InsensitiveStr::Ascii("bings"),
        dictgen::InsensitiveStr::Ascii("ders"),
        dictgen::InsensitiveStr::Ascii("entely"),
        dictgen::InsensitiveStr::Ascii("enty"),
        dictgen::InsensitiveStr::Ascii("houete"),
        dictgen::InsensitiveStr::Ascii("icoln"),
        dictgen::InsensitiveStr::Ascii("icoon"),
        dictgen::InsensitiveStr::Ascii("iently"),
        dictgen::InsensitiveStr::Ascii("imiar"),
        dictgen::InsensitiveStr::Ascii("ohuette"),
        dictgen::InsensitiveStr::Ascii("ouhette"),
    ],
    values: &[
        &["siblings"],
        &["sliders"],
        &["silently"],
        &["silently"],
        &["silhouette"],
        &["silicon"],
        &["silicon"],
        &["silently", "saliently"],
        &["similar"],
        &["silhouette"],
        &["silhouette