use hex::FromHexError;
use thiserror::*;


#[derive(Error, Debug)]
pub enum TxLogErrors {
    #[error("{0}")]
    HexDecode(
        #[source]    
        #[from]
        FromHexError
    ),
    
    #[error("{0}")]
    SendRequestError(
        #[source]
        #[from]
        reqwest::Error
    ),

    #[error("{0}")]
    BodyDecodeError(
        #[source]
        reqwest::Error
    ),

    #[error("Transaction submission failed")]
    SubmitResponseFailed
}