# txlog_client

rust implementation of a txlog client

# Installation

Can be installed from cargo `txlog_client`

# Usage

```rust
let url = "https://txlog.twetch.app".to_string();
let secret = "<jwt-goes-here>".to_string();
let txid = "b719054c19e96eba236b59056d7c66d64dac3a604a4d032594ae2b567e26a47d".to_string();

// create txlog client instance
let txlog = txlog_client::new(url, secret);

// fetch a rawtx
let rawtx = txlog.rawtx(txid).await.unwrap();

// get information about a transaction
let data = txlog.tx(txid).await.unwrap();

// submit a transaction
let submitted txlog.submit(rawtx, "based twetch").await.unwrap();
```
