use tokio::io::Error;

use env_logger::Builder;
use log::LevelFilter;
use tws::Client;
use tws::ws::Msg;

#[tokio::main]
async fn main() -> Result<(), Error> {
    let mut builder = Builder::new();
    builder.filter_level(LevelFilter::Trace);
    builder.init();

    let url = "wss://fstream3.binance.com/stream?streams=btcusdt@trade".to_string();
    let client = Client::new(url.as_str());
    let mut socket = client.connect().await?;

    while let msg = socket.recv().await {
        let message = match msg {
            Ok(msg) => { msg }
            Err(e) => {
                println!("Error: {:?}", e);
                // let _ = socket.send(Msg::Close(1002)).await;
                break;
            }
        };

        match message {
            Msg::Binary(data) => {
                println!("Binary: {:?}", data);
            }
            Msg::Text(data) => {
                unsafe {
                    println!("string: {}", String::from_utf8_unchecked(data));
                }
                // println!("Text: {:?}", data);
            }
            Msg::Close(code) => {
                let _ = socket.send(Msg::Close(code)).await;
            }
            Msg::Ping(data) => {
                socket.send(Msg::Pong(data)).await;
            }
            Msg::Pong(_) => {}
        }
    }

    Ok(())
}
