use tws::Client;
use tokio::io::Error;
use tws::ws::Msg;
use env_logger::Builder;
use log::LevelFilter;
use async_channel::RecvError;

#[tokio::main]
async fn main() -> Result<(), Error> {
    let mut builder = Builder::new();
    builder.filter_level(LevelFilter::Trace);
    builder.init();

    let client = Client::new("wss://fstream3.binance.com/stream?streams=btcusdt@trade");
    let mut socket = client.connect().await?;

    // loop {
    //     tokio::time::sleep(tokio::time::Duration::from_millis(300)).await;
    // }

    // let m = socket.recv().await;

    // match m {
    //     Ok(msg) => {
    //
    //     }
    //     Err(err) => {}
    // }

    while let Ok(msg) = socket.recv().await {
        match msg {
            Msg::Text(m) => {
                println!("{}", String::from_utf8(m).unwrap());
            }
            Msg::Binary(m) => {
                println!("{}", m.len());
            }
            Msg::Close(_) => {}
            Msg::Ping(m) => {
                println!("ping {:?}", m);
                socket.send(Msg::Pong(m));
            }
            Msg::Pong(_) => {}
        }
    }

    Ok(())
}